/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  GetTokenModal: () => GetTokenModal,
  VkNotifierSettingsTab: () => VkNotifierSettingsTab,
  default: () => VkNotifier
});
module.exports = __toCommonJS(main_exports);
var import_obsidian = require("obsidian");
var appId = 51781583;
var GetTokenModal = class extends import_obsidian.Modal {
  constructor(app, onSubmit) {
    super(app);
    this.onSubmit = onSubmit;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("br");
    const url = "https://oauth.vk.com/authorize?client_id=" + appId + "&display=page&redirect_uri=https://oauth.vk.com/blank.html&scope=" + 262144 + 65536 + "&response_type=token";
    if (import_obsidian.Platform.isIosApp || import_obsidian.Platform.isAndroidApp) {
      contentEl.createEl("p", { text: "Since I can't make WebView to work on Android, you should login in external browser and copy-paste page link in the input field." });
      new import_obsidian.Setting(contentEl).addText(
        (t) => t.onChange((t2) => this.result = t2)
      );
      new import_obsidian.Setting(contentEl).addButton(
        (btn) => btn.setButtonText("Open auth window").setCta().setWarning().onClick(() => {
          window.open(url);
        })
      );
      new import_obsidian.Setting(contentEl).addButton(
        (btn) => btn.setButtonText("Press this after pasting the link").setCta().setWarning().onClick(() => {
          this.close();
          this.onSubmit(this.result);
        })
      );
      return;
    }
    let b = document.createElement("webview");
    b.addEventListener("did-stop-loading", (e) => {
      let url2 = b.getAttribute("src");
      if (url2 == null ? void 0 : url2.contains("https://oauth.vk.com/blank.html#access_token=")) {
        this.close();
        this.onSubmit(b.getAttribute("src"));
      }
    });
    b.setAttribute("src", url);
    contentEl.appendChild(b);
    b.setAttribute("useragent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_6; en-US) AppleWebKit/603.25 (KHTML, like Gecko) Chrome/48.0.1971.300 Safari/537");
    b.shadowRoot.querySelector("iframe").style.height = "70vh";
  }
  onClose() {
    let { contentEl } = this;
    contentEl.empty();
  }
};
var DEFAULT_SETTINGS = {
  accessToken: "default",
  maxDays: 5,
  pinLast: false,
  style: `
	.vkGroupNotifier{}
	.pinnedVkPost{font-style:bold}`,
  dateFormat: "DD-MMMM-YYYY",
  maxTextLength: 100
};
var VkNotifier = class extends import_obsidian.Plugin {
  constructor() {
    super(...arguments);
    this.postprocessor = async (content, el, ctx) => {
      let data = {};
      content.trim().split(/\r?\n/).map((x) => {
        let xx = x.split(":");
        data[xx[0]] = xx[1].trim();
      });
      let url = "access_token=" + this.settings.accessToken + "&domain=" + data["name"] + "&v=5.154";
      if (data["id"]) {
        url += "&owner_id=-" + data["id"].trim();
      }
      const res = await (0, import_obsidian.request)({
        url: "https://api.vk.com/method/wall.get",
        method: "POST",
        body: url
      });
      let j = JSON.parse(res);
      let fitems;
      let items;
      try {
        items = j["response"]["items"];
        fitems = items.filter((x) => {
          return (0, import_obsidian.moment)().diff(x["date"] * 1e3, "day") <= parseInt(data["maxDays"] ? data["maxDays"] : this.settings.maxDays.toString());
        });
      } catch (error) {
        el.setText(j["error"]["error_msg"].toString());
        console.log(j);
        return;
      }
      if (this.settings.pinLast || data["pinLast"] == "true") {
        if (!fitems.includes(items[0])) {
          fitems.unshift(items[0]);
        }
      }
      if (fitems.length == 0) {
        el.setText("No new Posts");
        return;
      }
      let div = el.createDiv();
      div.createEl("a", { href: "https://vk.com/" + (data["id"] ? "club" + data["id"].trim() : data["name"]), text: "Open Page" });
      div.appendChild(this.formatPosts(fitems, this.settings.pinLast || data["pinLast"] == "true", parseInt(data["maxTextLength"] ? data["maxTextLength"] : this.settings.maxTextLength.toString()), data["dateFormat"] ? data["dateFormat"] : this.settings.dateFormat));
      el.appendChild(div);
      ctx.addChild(new import_obsidian.MarkdownRenderChild(el));
    };
  }
  formatPosts(item, pin, maxTextLength, dateFormat) {
    maxTextLength = isNaN(maxTextLength) ? this.settings.maxTextLength : maxTextLength;
    let r = document.createElement("table");
    let style = r.createEl("style", { text: this.settings.style });
    r.className = "vkGroupNotifier";
    item.forEach((e, i) => {
      let tr = r.createEl("tr");
      tr.createEl("td", { text: import_obsidian.moment.unix(e["date"]).format(dateFormat) });
      tr.createEl("td", { text: e["text"].slice(0, maxTextLength) });
      if (i == 0 && pin) {
        tr.className = "pinnedVkPost";
      }
    });
    r.appendChild(style);
    return r;
  }
  async onload() {
    await this.loadSettings();
    this.addSettingTab(new VkNotifierSettingsTab(this.app, this));
    this.registerMarkdownCodeBlockProcessor("vk-group-notifier", this.postprocessor);
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
var VkNotifierSettingsTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    let { containerEl } = this;
    containerEl.empty();
    new import_obsidian.Setting(containerEl).setName("Plugin requires access token to get posts from groups").addButton((btn) => {
      btn.setButtonText("get access token");
      btn.setTooltip("Asked permissions: group, offline");
      btn.onClick(async (e) => {
        let m = new GetTokenModal(this.app, async (r) => {
          try {
            let regexp = /access_token=(.*)&e/g;
            this.plugin.settings.accessToken = regexp.exec(r)[0].slice(13);
            await this.plugin.saveSettings();
            new import_obsidian.Notice("Done!");
          } catch (e2) {
            new import_obsidian.Notice("Something went wrong, can't get access token");
          }
        }).open();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Maximum days (maxDays)").setDesc("to consider post 'old' ").addText(
      (text) => text.setValue(this.plugin.settings.maxDays.toString()).onChange(async (value) => {
        this.plugin.settings.maxDays = parseInt(value);
        await this.plugin.saveSettings();
      })
    );
    new import_obsidian.Setting(containerEl).setName("Pin last post (pinLast)").setDesc("even if it is old ").addToggle(
      (text) => text.setValue(this.plugin.settings.pinLast).onChange(async (value) => {
        this.plugin.settings.pinLast = value;
        await this.plugin.saveSettings();
      })
    );
    new import_obsidian.Setting(containerEl).setName("Date format (dateFormat)").setDesc("standart js formatting").addText(
      (text) => text.setValue(this.plugin.settings.dateFormat).onChange(async (value) => {
        this.plugin.settings.dateFormat = value;
        await this.plugin.saveSettings();
      })
    );
    new import_obsidian.Setting(containerEl).setName("Maximum amount of symbols (maxTextLength)").setDesc("from a post to show in a table").addText(
      (text) => text.setValue(this.plugin.settings.maxTextLength.toString()).onChange(async (value) => {
        this.plugin.settings.maxTextLength = parseInt(value);
        await this.plugin.saveSettings();
      })
    );
    new import_obsidian.Setting(containerEl).setName("Style (style)").setDesc(`
			Css to decorate table.
			table class "vkGroupNotifier", 
			pinned post class "pinnedVkPost"
			`).addTextArea(
      (text) => text.setValue(this.plugin.settings.style).onChange(async (value) => {
        this.plugin.settings.style = value;
        await this.plugin.saveSettings();
      })
    );
  }
};
