/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => TaskStatusPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian4 = require("obsidian");

// src/settings.ts
var import_obsidian = require("obsidian");

// src/themes/AnuPpuccinTheme.ts
var AnuPpuccinTheme = {
  name: "AnuPpuccin Theme",
  statuses: [
    { character: " ", title: "Unchecked" },
    { character: "x", title: "Checked" },
    { character: ">", title: "Rescheduled" },
    { character: "<", title: "Scheduled" },
    { character: "!", title: "Important" },
    { character: "-", title: "Cancelled" },
    { character: "/", title: "In Progress" },
    { character: "?", title: "Question" },
    { character: "*", title: "Star" },
    { character: "n", title: "Note" },
    { character: "l", title: "Location" },
    { character: "i", title: "Information" },
    { character: "I", title: "Idea" },
    { character: "S", title: "Amount" },
    { character: "p", title: "Pro" },
    { character: "c", title: "Con" },
    { character: "b", title: "Bookmark" },
    { character: '"', title: "Quote" },
    { character: "0", title: "Speech bubble 0" },
    { character: "1", title: "Speech bubble 1" },
    { character: "2", title: "Speech bubble 2" },
    { character: "3", title: "Speech bubble 3" },
    { character: "4", title: "Speech bubble 4" },
    { character: "5", title: "Speech bubble 5" },
    { character: "6", title: "Speech bubble 6" },
    { character: "7", title: "Speech bubble 7" },
    { character: "8", title: "Speech bubble 8" },
    { character: "9", title: "Speech bubble 9" }
  ]
};

// src/themes/AuraThemeTheme.ts
var AuraTheme = {
  name: "Aura Theme",
  statuses: [
    { character: " ", title: "incomplete" },
    { character: "x", title: "complete / done" },
    { character: "-", title: "cancelled" },
    { character: ">", title: "deferred" },
    { character: "/", title: "in progress, or half-done" },
    { character: "!", title: "Important" },
    { character: "?", title: "question" },
    { character: "R", title: "review" },
    { character: "+", title: "Inbox / task that should be processed later" },
    { character: "b", title: "bookmark" },
    { character: "B", title: "brainstorm" },
    { character: "D", title: "deferred or scheduled" },
    { character: "I", title: "Info" },
    { character: "i", title: "idea" },
    { character: "N", title: "note" },
    { character: "Q", title: "quote" },
    { character: "W", title: "win / success / reward" },
    { character: "P", title: "pro" },
    { character: "C", title: "con" }
  ]
};

// src/themes/EbullientworksTheme.ts
var EbullientworksTheme = {
  name: "Ebullientworks Theme",
  statuses: [
    { character: " ", title: "Unchecked" },
    { character: "x", title: "Checked" },
    { character: "-", title: "Cancelled" },
    { character: "/", title: "In Progress" },
    { character: ">", title: "Deferred" },
    { character: "!", title: "Important" },
    { character: "?", title: "Question" },
    { character: "r", title: "Review" }
  ]
};

// src/themes/ITSTheme.ts
var ITSTheme = {
  name: "ITS Theme with SlRvb Checkboxes",
  statuses: [
    { character: " ", title: "Unchecked" },
    { character: "x", title: "Regular" },
    { character: "X", title: "Checked" },
    { character: "-", title: "Dropped" },
    { character: ">", title: "Forward" },
    { character: "D", title: "Date" },
    { character: "?", title: "Question" },
    { character: "/", title: "Half Done" },
    { character: "+", title: "Add" },
    { character: "R", title: "Research" },
    { character: "!", title: "Important" },
    { character: "i", title: "Idea" },
    { character: "B", title: "Brainstorm" },
    { character: "P", title: "Pro" },
    { character: "C", title: "Con" },
    { character: "Q", title: "Quote" },
    { character: "N", title: "Note" },
    { character: "b", title: "Bookmark" },
    { character: "I", title: "Information" },
    { character: "p", title: "Paraphrase" },
    { character: "L", title: "Location" },
    { character: "E", title: "Example" },
    { character: "A", title: "Answer" },
    { character: "r", title: "Reward" },
    { character: "c", title: "Choice" },
    { character: "d", title: "Doing" },
    { character: "T", title: "Time" },
    { character: "@", title: "Character / Person" },
    { character: "t", title: "Talk" },
    { character: "O", title: "Outline / Plot" },
    { character: "~", title: "Conflict" },
    { character: "W", title: "World" },
    { character: "f", title: "Clue / Find" },
    { character: "F", title: "Foreshadow" },
    { character: "H", title: "Favorite / Health" },
    { character: "&", title: "Symbolism" },
    { character: "s", title: "Secret" }
  ]
};

// src/themes/LYTModeTheme.ts
var LYTModeTheme = {
  name: "LYT Mode Theme",
  statuses: [
    { character: " ", title: "Unchecked" },
    { character: "x", title: "Checked" },
    { character: ">", title: "Rescheduled" },
    { character: "<", title: "Scheduled" },
    { character: "!", title: "Important" },
    { character: "-", title: "Cancelled" },
    { character: "/", title: "In Progress" },
    { character: "?", title: "Question" },
    { character: "*", title: "Star" },
    { character: "n", title: "Note" },
    { character: "l", title: "Location" },
    { character: "i", title: "Information" },
    { character: "I", title: "Idea" },
    { character: "S", title: "Amount" },
    { character: "p", title: "Pro" },
    { character: "c", title: "Con" },
    { character: "b", title: "Bookmark" },
    { character: "f", title: "Fire" },
    { character: "k", title: "Key" },
    { character: "w", title: "Win" },
    { character: "u", title: "Up" },
    { character: "d", title: "Down" }
  ]
};

// src/themes/MinimalTheme.ts
var MinimalTheme = {
  name: "Minimal Theme",
  statuses: [
    { character: " ", title: "to-do" },
    { character: "/", title: "incomplete" },
    { character: "x", title: "done" },
    { character: "-", title: "canceled" },
    { character: ">", title: "forwarded" },
    { character: "<", title: "scheduling" },
    { character: "?", title: "question" },
    { character: "!", title: "important" },
    { character: "*", title: "star" },
    { character: '"', title: "quote" },
    { character: "l", title: "location" },
    { character: "b", title: "bookmark" },
    { character: "i", title: "information" },
    { character: "S", title: "savings" },
    { character: "I", title: "idea" },
    { character: "p", title: "pros" },
    { character: "c", title: "cons" },
    { character: "f", title: "fire" },
    { character: "k", title: "key" },
    { character: "w", title: "win" },
    { character: "u", title: "up" },
    { character: "d", title: "down" }
  ]
};

// src/themes/ThingsTheme.ts
var ThingsTheme = {
  name: "Things Theme",
  statuses: [
    // Basic
    { character: " ", title: "to-do" },
    { character: "/", title: "incomplete" },
    { character: "x", title: "done" },
    { character: "-", title: "canceled" },
    { character: ">", title: "forwarded" },
    { character: "<", title: "scheduling" },
    // Extras
    { character: "?", title: "question" },
    { character: "!", title: "important" },
    { character: "*", title: "star" },
    { character: '"', title: "quote" },
    { character: "l", title: "location" },
    { character: "b", title: "bookmark" },
    { character: "i", title: "information" },
    { character: "S", title: "savings" },
    { character: "I", title: "idea" },
    { character: "p", title: "pros" },
    { character: "c", title: "cons" },
    { character: "f", title: "fire" },
    { character: "k", title: "key" },
    { character: "w", title: "win" },
    { character: "u", title: "up" },
    { character: "d", title: "down" }
  ]
};

// src/themes/BorderTheme.ts
var BorderTheme = {
  name: "Border Theme",
  statuses: [
    // Basic
    { character: " ", title: "To Do" },
    { character: "/", title: "In Progress" },
    { character: "x", title: "Done" },
    { character: "-", title: "Canceled" },
    { character: ">", title: "Rescheduled" },
    { character: "<", title: "Scheduled" },
    // Extras
    { character: "!", title: "Important" },
    { character: "?", title: "Question" },
    { character: "i", title: "Information" },
    { character: "S", title: "Amount" },
    { character: "*", title: "Star" },
    { character: "b", title: "Bookmark" },
    { character: '"', title: "Quote" },
    { character: "n", title: "Note" },
    { character: "l", title: "Location" },
    { character: "I", title: "Idea" },
    { character: "p", title: "Pro" },
    { character: "c", title: "Con" },
    { character: "u", title: "up" },
    { character: "d", title: "down" }
  ]
};

// src/themes/index.ts
var themes = [
  AnuPpuccinTheme,
  AuraTheme,
  EbullientworksTheme,
  ITSTheme,
  LYTModeTheme,
  MinimalTheme,
  ThingsTheme,
  BorderTheme
];

// src/default-settings.ts
var DEFAULT_SETTINGS = {
  // prettier-ignore
  checkboxOptions: [
    { title: "to-do", character: " " },
    { title: "incomplete", character: "/" },
    { title: "done", character: "x" },
    { title: "canceled", character: "-" },
    { title: "forwarded", character: ">" },
    { title: "scheduling", character: "<" },
    { title: "question", character: "?" },
    { title: "important", character: "!" },
    { title: "star", character: "*" },
    { title: "quote", character: '"' },
    { title: "location", character: "l" },
    { title: "bookmark", character: "b" },
    { title: "information", character: "i" },
    { title: "savings", character: "S" },
    { title: "idea", character: "I" },
    { title: "pros", character: "p" },
    { title: "cons", character: "c" },
    { title: "fire", character: "f" },
    { title: "key", character: "k" },
    { title: "win", character: "w" },
    { title: "up", character: "u" },
    { title: "down", character: "d" },
    { title: "draft pull request", character: "D" },
    { title: "open pull request", character: "P" },
    { title: "merged pull request", character: "M" }
  ]
};
var default_settings_default = DEFAULT_SETTINGS;

// src/settings.ts
function swap(arr, indexA, indexB) {
  if (indexB < 0 || indexB === arr.length)
    return;
  const temp = arr[indexA];
  arr[indexA] = arr[indexB];
  arr[indexB] = temp;
}
function moveToTop(arr, index) {
  const item = arr.splice(index, 1);
  arr.unshift(item[0]);
}
var Settings = class extends import_obsidian.PluginSettingTab {
  /**
   * constructs the settings
   * @param app obsidian application instance
   * @param plugin plugin instance
   */
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  /**
   * Renders the settings view
   */
  display() {
    const { containerEl } = this;
    containerEl.empty();
    this.displayTaskStatuses();
    this.displayListActions();
    this.displayImportOptions();
  }
  /**
   * Render the custom task statuses editing section
   */
  displayTaskStatuses() {
    this.plugin.settings.checkboxOptions.forEach((checkboxOption, index) => {
      new import_obsidian.Setting(this.containerEl).setName(`${(index + 1).toString().padStart(2, "0")}.`).addText(async (text) => {
        text.setPlaceholder("name").setValue(checkboxOption.title).onChange(async (value) => {
          this.plugin.settings.checkboxOptions[index].title = value;
          this.plugin.saveSettings();
        });
      }).addText(async (text) => {
        text.setPlaceholder("character").setValue(checkboxOption.character).onChange(async (value) => {
          this.plugin.settings.checkboxOptions[index].character = value;
          this.plugin.saveSettings();
        });
      }).addExtraButton((button) => {
        button.setIcon("double-up-arrow-glyph").setTooltip("Move to top").onClick(() => {
          moveToTop(this.plugin.settings.checkboxOptions, index);
          this.plugin.saveSettings();
          this.display();
        });
      }).addExtraButton((button) => {
        button.setIcon("up-chevron-glyph").setTooltip("Move up").onClick(() => {
          swap(this.plugin.settings.checkboxOptions, index, index - 1);
          this.plugin.saveSettings();
          this.display();
        });
      }).addExtraButton((button) => {
        button.setIcon("down-chevron-glyph").setTooltip("Move down").onClick(() => {
          swap(this.plugin.settings.checkboxOptions, index, index + 1);
          this.plugin.saveSettings();
          this.display();
        });
      }).addExtraButton((button) => {
        button.setIcon("cross").setTooltip("Delete").onClick(() => {
          this.plugin.settings.checkboxOptions.splice(index, 1);
          this.plugin.saveSettings();
          this.display();
        });
      });
    });
  }
  displayListActions() {
    new import_obsidian.Setting(this.containerEl).setName("Status List Actions").addButton((button) => {
      button.setButtonText("Clear list").setWarning().onClick(() => {
        this.plugin.settings.checkboxOptions = [];
        this.plugin.saveSettings();
        this.display();
      });
    }).addButton((button) => {
      button.setButtonText("Reset to default").onClick(() => {
        this.plugin.settings = structuredClone(default_settings_default);
        this.plugin.saveSettings();
        this.display();
      });
    }).addButton((button) => {
      button.setButtonText("Add new status").setCta().onClick(() => {
        this.plugin.settings.checkboxOptions.push({ title: "undefined", character: "x" });
        this.plugin.saveSettings();
        this.display();
      });
    });
  }
  displayImportOptions() {
    themes.forEach(({ name, statuses }) => {
      new import_obsidian.Setting(this.containerEl).setName(name).setDesc(`Add any missing custom checkbox statuses supported by the ${name}.`).addButton((button) => {
        button.setButtonText(name).onClick(async () => {
          statuses.forEach((option) => {
            const found = this.plugin.settings.checkboxOptions.some((o) => o.character == option.character);
            if (!found) {
              this.plugin.settings.checkboxOptions.push({ ...option });
            }
          });
          this.plugin.saveSettings();
          this.display();
        });
      });
    });
  }
};

// src/register-ribbon.ts
var import_obsidian3 = require("obsidian");

// src/modals/quick-action-modal.ts
var import_obsidian2 = require("obsidian");

// src/swap-checkbox-status.ts
var _SwapCheckboxStatus = class _SwapCheckboxStatus {
  constructor(editor) {
    /**
     * When true, the class will output debug console messages
     */
    this.DEBUG = true;
    this.editor = editor;
  }
  /**
   * Initiates the transformation of editor selected lines
   * @param marker the status marker string to put inside the checkbox
   */
  swap(marker) {
    const selections = this.editor.listSelections();
    selections.forEach((selection) => {
      this.transformSelectionOrLine(selection, marker);
    });
  }
  /**
   * execute the appropriate transform depending on whether a single line or multiple are selected
   * @param selection an editor selection
   * @param marker the status marker to put inside the checkbox
   */
  transformSelectionOrLine(selection, marker) {
    this.log(`selection:
${selection}`);
    if (selection.anchor.line === selection.head.line && selection.anchor.ch === selection.head.ch) {
      this.transformLine(selection.anchor, marker);
    } else {
      this.transformSelection(selection, marker);
    }
  }
  /**
   * transform a single line by it's line number
   * @param line the line number
   * @param target the status marker to put inside the checkbox
   */
  transformLine(anchor, target) {
    const line = anchor.line;
    this.log("start transformLine");
    const original = this.editor.getLine(line);
    const replacement = this.getLineReplacement(original, target);
    this.log(`original:
${original}`);
    this.log(`replacement:
${replacement}`);
    this.editor.setLine(line, replacement);
    let ch = replacement.length;
    if (original.length === replacement.length) {
      ch = anchor.ch;
    } else {
      ch = anchor.ch + replacement.length - original.length;
    }
    this.editor.setSelection({ line, ch });
  }
  getLineReplacement(original, target) {
    _SwapCheckboxStatus.taskRegex.lastIndex = 0;
    _SwapCheckboxStatus.nonTaskRegex.lastIndex = 0;
    _SwapCheckboxStatus.blankLineRegex.lastIndex = 0;
    switch (true) {
      case _SwapCheckboxStatus.taskRegex.test(original):
        return this.transformTasks(original, target);
      case _SwapCheckboxStatus.nonTaskRegex.test(original):
        return this.transformNonTasks(original, target);
      case _SwapCheckboxStatus.blankLineRegex.test(original):
        return this.transformBlankLines(original, target);
      default:
        this.log("detected other");
        return original;
    }
  }
  transformTasks(original, target) {
    this.log("transforming task(s)");
    _SwapCheckboxStatus.taskRegex.lastIndex = 0;
    return original.replace(_SwapCheckboxStatus.taskRegex, `$1[${target}]$2`);
  }
  transformNonTasks(original, target) {
    this.log("transforming non-task(s)");
    _SwapCheckboxStatus.nonTaskRegex.lastIndex = 0;
    const parts = _SwapCheckboxStatus.nonTaskRegex.exec(original);
    if (parts === null)
      return original;
    const bullet = parts[3] || "-";
    return original.replace(_SwapCheckboxStatus.nonTaskRegex, `$2${bullet} [${target}] $4`);
  }
  transformBlankLines(original, target) {
    this.log("transforming blank line(s)");
    _SwapCheckboxStatus.blankLineRegex.lastIndex = 0;
    return original.replace(_SwapCheckboxStatus.blankLineRegex, `$1- [${target}] `);
  }
  /**
   * transform a selection of text
   * @param selection
   * @param target
   */
  transformSelection(selection, target) {
    this.log("start transformSelection");
    this.log("selection", selection);
    const { anchor, head } = selection;
    const anchorIsStart = anchor.ch <= head.ch && anchor.line <= head.line;
    const cursorStart = anchorIsStart ? anchor : head;
    const cursorEnd = anchorIsStart ? head : anchor;
    cursorStart.ch = 0;
    cursorEnd.ch = 0;
    cursorEnd.line += 1;
    let replacement = this.editor.getRange(cursorStart, cursorEnd);
    _SwapCheckboxStatus.taskRegex.lastIndex = 0;
    if (_SwapCheckboxStatus.taskRegex.test(replacement)) {
      replacement = this.transformTasks(replacement, target);
    }
    _SwapCheckboxStatus.nonTaskRegex.lastIndex = 0;
    if (_SwapCheckboxStatus.nonTaskRegex.test(replacement)) {
      replacement = this.transformNonTasks(replacement, target);
    }
    this.log("replacement", replacement);
    this.editor.replaceRange(replacement, cursorStart, cursorEnd);
  }
  /**
   * conditional log output
   * @param args arguments to pass on to console.log
   */
  log(...args) {
    this.DEBUG && console.log(...args);
  }
};
// matches a checklist item:
// start of a line; any amount of whitespace or `>` characters (for callouts);
// then a dash or asterix for a bullet point, a single whitespace, then square bracket syntax
// for the checkbox; followed by any remaining characters til the end of the line.
// Capturing Groups:
//   $1 - everything before the checkbox
//   $2 - everything after the checkbox
_SwapCheckboxStatus.taskRegex = /^([\s>]*[-*+]\s)\[[^\]]\](?!\()(.*)$/gm;
/*
(?!^#+)                                   Ignore Heading (negative lookahead)
(?!^\s*$)                                 Ignore blank lines
(?!^\s{0,3}([-_*]) *(?:\1 *){2,}$)        Ignore horizontal rules and thematic breaks
(?!^[\s>]* \[![\w-]+\])                   Ignore first line of Obsidian Callouts
^                                         start of a line
(?!(?:\s*>?)*\s*[-*+]\s+\[[^\]]\](?!\())  Ignore lines that are tasks (they may or may not be inside block quotes)
([>\s]*)?                                 capture any amount of indentation and nested blockquote markers
(?:(?:[-*+]|[0-9]+\.)\s)?                 don't capture any ordered or unordered list markings
(.*)                                      capture the rest of the text
*/
// matches a line that is not a checklist
// Capturing Groups:
//  $1 - used internally to detect horizontal rules
//  $2 - indentation
//  $3 - bullet character
//  $4 - content
_SwapCheckboxStatus.nonTaskRegex = /(?!^#+)(?!^\s*$)(?!^\s{0,3}([-_*])\s*(?:\1 *){2,}$)(?!^[\s>]* \[![\w-]+\])^(?!(?:\s*>?)*\s*[-*+]\s+\[[^\]]\](?!\())([>\s]*)?(?:(?:([-*+])|[0-9]+\.)\s)?(.*)/gm;
// matches a blank line
_SwapCheckboxStatus.blankLineRegex = /^(\s*)$/gm;
var SwapCheckboxStatus = _SwapCheckboxStatus;
var swap_checkbox_status_default = SwapCheckboxStatus;

// src/modals/quick-action-modal.ts
var QuickActionModal = class extends import_obsidian2.SuggestModal {
  /**
   *
   * @param app Obsidian instance
   * @param plugin plugin instance
   * @param editor editor instance
   */
  constructor(app, plugin, editor) {
    super(app);
    this.plugin = plugin;
    this.editor = editor;
  }
  /**
   * filters the checkbox options; the results are used as suggestions
   * @param query the search string
   * @returns collection of options
   */
  getSuggestions(query) {
    return this.plugin.settings.checkboxOptions.filter(
      (option) => option.title.toLowerCase().includes(query.toLowerCase())
    );
  }
  /**
   * renders each suggestion
   * @param option the checkbox option to display
   * @param el the suggestion HTML element
   */
  renderSuggestion(option, el) {
    el.setCssStyles({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      textAlign: "center"
    });
    el.setAttribute("data-task", option.character);
    el.classList.add("task-list-item");
    if (option.character !== " ") {
      el.classList.add("is-checked");
    }
    const input = el.createEl("input", {
      attr: {
        "type": "checkbox",
        "data-task": option.character
      }
    });
    input.classList.add("task-list-item");
    input.checked = option.character !== " ";
    if (option.character !== " ") {
      input.classList.add("is-checked");
    }
    const span = el.createEl("span", { text: option.title });
    span.classList.add("cm-list-1");
  }
  /**
   * Handler for when the user chooses an option
   * @param option the option selected by the user
   * @param evt the triggering mouse or keyboard event
   */
  onChooseSuggestion(option, evt) {
    new import_obsidian2.Notice(`Selected ${option.title}`);
    new swap_checkbox_status_default(this.editor).swap(option.character);
  }
};

// src/register-ribbon.ts
var register_ribbon_default = (plugin) => {
  (0, import_obsidian3.addIcon)(
    "search-check",
    `<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">
      <g transform="translate(3, 3)" stroke="currentcolor" stroke-width="6">
        <polyline points="26.1111111 41.7777778 36.5555556 52.2222222 57.4444444 31.3333333"></polyline>
        <circle cx="41.7777778" cy="41.7777778" r="41.7777778"></circle>
        <line x1="94" y1="94" x2="71.5444444" y2="71.5444444"></line>
      </g>
    </g>`
  );
  plugin.addRibbonIcon(
    "search-check",
    "Change Checkbox Status",
    (_event) => {
      const activeView = plugin.app.workspace.getActiveViewOfType(import_obsidian3.MarkdownView);
      if (!activeView)
        return;
      const editor = activeView.editor;
      new QuickActionModal(plugin.app, plugin, editor).open();
    }
  );
};

// src/commands/open-task-quick-menu.ts
var changeTaskStatus = (plugin) => ({
  id: "change-task-status",
  name: "change task status",
  // hotkeys: [{ modifiers: ["Mod", "Shift"], key: "l" }],
  editorCallback: (editor, view) => {
    new QuickActionModal(plugin.app, plugin, editor).open();
  }
});
var open_task_quick_menu_default = changeTaskStatus;

// main.ts
var TaskStatusPlugin = class extends import_obsidian4.Plugin {
  /**
   * Setup the plugin when it loads in obsidian
   */
  async onload() {
    console.log("loading Obsidian Task Status");
    await this.loadSettings();
    register_ribbon_default(this);
    this.addCommand(open_task_quick_menu_default(this));
    this.addSettingTab(new Settings(this.app, this));
  }
  /**
   * Teardown the plugin when it gets unloaded
   */
  onunload() {
    console.log("unloading Obsidian Task Status");
  }
  /**
   * Trigger the rendering of the settings view
   */
  async loadSettings() {
    this.settings = Object.assign({}, default_settings_default, await this.loadData());
  }
  /**
   * persist/save the plugin settings
   */
  async saveSettings() {
    await this.saveData(this.settings);
  }
};

/* nosourcemap */