/*! obsidian-smart-connections v3.0.80 | (c) 2025 🌴 Brian (Brian Petro) */
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/obsidian-smart-env/node_modules/base64-js/index.js
var require_base64_js = __commonJS({
  "node_modules/obsidian-smart-env/node_modules/base64-js/index.js"(exports2) {
    "use strict";
    exports2.byteLength = byteLength;
    exports2.toByteArray = toByteArray;
    exports2.fromByteArray = fromByteArray;
    var lookup = [];
    var revLookup = [];
    var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
    var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    for (i = 0, len = code.length; i < len; ++i) {
      lookup[i] = code[i];
      revLookup[code.charCodeAt(i)] = i;
    }
    var i;
    var len;
    revLookup["-".charCodeAt(0)] = 62;
    revLookup["_".charCodeAt(0)] = 63;
    function getLens(b64) {
      var len2 = b64.length;
      if (len2 % 4 > 0) {
        throw new Error("Invalid string. Length must be a multiple of 4");
      }
      var validLen = b64.indexOf("=");
      if (validLen === -1) validLen = len2;
      var placeHoldersLen = validLen === len2 ? 0 : 4 - validLen % 4;
      return [validLen, placeHoldersLen];
    }
    function byteLength(b64) {
      var lens = getLens(b64);
      var validLen = lens[0];
      var placeHoldersLen = lens[1];
      return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
    }
    function _byteLength(b64, validLen, placeHoldersLen) {
      return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
    }
    function toByteArray(b64) {
      var tmp;
      var lens = getLens(b64);
      var validLen = lens[0];
      var placeHoldersLen = lens[1];
      var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
      var curByte = 0;
      var len2 = placeHoldersLen > 0 ? validLen - 4 : validLen;
      var i2;
      for (i2 = 0; i2 < len2; i2 += 4) {
        tmp = revLookup[b64.charCodeAt(i2)] << 18 | revLookup[b64.charCodeAt(i2 + 1)] << 12 | revLookup[b64.charCodeAt(i2 + 2)] << 6 | revLookup[b64.charCodeAt(i2 + 3)];
        arr[curByte++] = tmp >> 16 & 255;
        arr[curByte++] = tmp >> 8 & 255;
        arr[curByte++] = tmp & 255;
      }
      if (placeHoldersLen === 2) {
        tmp = revLookup[b64.charCodeAt(i2)] << 2 | revLookup[b64.charCodeAt(i2 + 1)] >> 4;
        arr[curByte++] = tmp & 255;
      }
      if (placeHoldersLen === 1) {
        tmp = revLookup[b64.charCodeAt(i2)] << 10 | revLookup[b64.charCodeAt(i2 + 1)] << 4 | revLookup[b64.charCodeAt(i2 + 2)] >> 2;
        arr[curByte++] = tmp >> 8 & 255;
        arr[curByte++] = tmp & 255;
      }
      return arr;
    }
    function tripletToBase64(num) {
      return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
    }
    function encodeChunk(uint8, start, end) {
      var tmp;
      var output = [];
      for (var i2 = start; i2 < end; i2 += 3) {
        tmp = (uint8[i2] << 16 & 16711680) + (uint8[i2 + 1] << 8 & 65280) + (uint8[i2 + 2] & 255);
        output.push(tripletToBase64(tmp));
      }
      return output.join("");
    }
    function fromByteArray(uint8) {
      var tmp;
      var len2 = uint8.length;
      var extraBytes = len2 % 3;
      var parts = [];
      var maxChunkLength = 16383;
      for (var i2 = 0, len22 = len2 - extraBytes; i2 < len22; i2 += maxChunkLength) {
        parts.push(encodeChunk(uint8, i2, i2 + maxChunkLength > len22 ? len22 : i2 + maxChunkLength));
      }
      if (extraBytes === 1) {
        tmp = uint8[len2 - 1];
        parts.push(
          lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "=="
        );
      } else if (extraBytes === 2) {
        tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
        parts.push(
          lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "="
        );
      }
      return parts.join("");
    }
  }
});

// src/index.js
var index_exports = {};
__export(index_exports, {
  default: () => SmartConnectionsPlugin
});
module.exports = __toCommonJS(index_exports);
var import_obsidian60 = __toESM(require("obsidian"), 1);

// node_modules/obsidian-smart-env/smart_env.js
var import_obsidian20 = require("obsidian");

// node_modules/obsidian-smart-env/node_modules/smart-environment/components/settings.js
async function build_html(env, opts = {}) {
  const env_settings_html = Object.entries(env.settings_config).map(([setting_key, setting_config]) => {
    if (!setting_config.setting) setting_config.setting = setting_key;
    return this.render_setting_html(setting_config);
  }).join("\n");
  const env_collections_containers_html = Object.entries(env.collections).map(([collection_key, collection]) => {
    return `<div data-smart-settings="${collection_key}"></div>`;
  }).join("\n");
  const html = `
    <div class="">
      ${env_settings_html}
      ${env_collections_containers_html}
    </div>
  `;
  return html;
}
async function render(env, opts = {}) {
  const html = await build_html.call(this, env, opts);
  const frag = this.create_doc_fragment(html);
  return await post_process.call(this, env, frag, opts);
}
async function post_process(env, frag, opts = {}) {
  await this.render_setting_components(frag, { scope: env });
  const env_collections_containers = frag.querySelectorAll("[data-smart-settings]");
  for (const env_collections_container of env_collections_containers) {
    const collection_key = env_collections_container.dataset.smartSettings;
    const collection = env[collection_key];
    await collection.render_settings(env_collections_container);
  }
  return frag;
}

// node_modules/obsidian-smart-env/node_modules/smart-settings/smart_settings.js
var SmartSettings = class {
  /**
   * Creates an instance of SmartEnvSettings.
   * @param {Object} main - The main object to contain the instance (smart_settings) and getter (settings)
   * @param {Object} [opts={}] - Configuration options.
   */
  constructor(main, opts = {}) {
    this.main = main;
    this.opts = opts;
    this._fs = null;
    this._settings = {};
    this._saved = false;
    this.save_timeout = null;
  }
  static async create(main, opts = {}) {
    const smart_settings = new this(main, opts);
    await smart_settings.load();
    main.smart_settings = smart_settings;
    Object.defineProperty(main, "settings", {
      get() {
        return smart_settings.settings;
      },
      set(settings) {
        smart_settings.settings = settings;
      }
    });
    return smart_settings;
  }
  static create_sync(main, opts = {}) {
    const smart_settings = new this(main, opts);
    smart_settings.load_sync();
    main.smart_settings = smart_settings;
    Object.defineProperty(main, "settings", {
      get() {
        return smart_settings.settings;
      },
      set(settings) {
        smart_settings.settings = settings;
      }
    });
    return smart_settings;
  }
  /**
   * Gets the current settings, wrapped with an observer to handle changes.
   * @returns {Proxy} A proxy object that observes changes to the settings.
   */
  get settings() {
    return observe_object(this._settings, (property, value, target) => {
      if (this.save_timeout) clearTimeout(this.save_timeout);
      this.save_timeout = setTimeout(() => {
        this.save(this._settings);
        this.save_timeout = null;
      }, 1e3);
    });
  }
  /**
   * Sets the current settings.
   * @param {Object} settings - The new settings to apply.
   */
  set settings(settings) {
    this._settings = settings;
  }
  async save(settings = this._settings) {
    if (typeof this.opts.save === "function") await this.opts.save(settings);
    else await this.main.save_settings(settings);
  }
  async load() {
    if (typeof this.opts.load === "function") this._settings = await this.opts.load();
    else this._settings = await this.main.load_settings();
  }
  load_sync() {
    if (typeof this.opts.load === "function") this._settings = this.opts.load();
    else this._settings = this.main.load_settings();
  }
};
function observe_object(obj, on_change) {
  function create_proxy(target) {
    return new Proxy(target, {
      set(target2, property, value) {
        if (target2[property] !== value) {
          target2[property] = value;
          on_change(property, value, target2);
        }
        if (typeof value === "object" && value !== null) {
          target2[property] = create_proxy(value);
        }
        return true;
      },
      get(target2, property) {
        const result = target2[property];
        if (typeof result === "object" && result !== null) {
          return create_proxy(result);
        }
        return result;
      },
      deleteProperty(target2, property) {
        if (property in target2) {
          delete target2[property];
          on_change(property, void 0, target2);
        }
        return true;
      }
    });
  }
  return create_proxy(obj);
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/deep_merge.js
function deep_merge(target = {}, source2 = {}) {
  for (const key in source2) {
    if (!Object.prototype.hasOwnProperty.call(source2, key)) continue;
    if (is_plain_object(source2[key]) && is_plain_object(target[key])) {
      deep_merge(target[key], source2[key]);
    } else {
      target[key] = source2[key];
    }
  }
  return target;
}
function is_plain_object(o) {
  return o && typeof o === "object" && !Array.isArray(o);
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/camel_case_to_snake_case.js
function camel_case_to_snake_case(str = "") {
  return str.replace(/([A-Z])/g, (m) => `_${m.toLowerCase()}`).replace(/^_/, "").replace(/2$/, "");
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/utils/normalize_opts.js
function normalize_opts(opts) {
  if (!opts.collections) opts.collections = {};
  if (!opts.modules) opts.modules = {};
  if (!opts.items) opts.items = {};
  Object.entries(opts.collections).forEach(([key, val]) => {
    if (typeof val === "function") {
      opts.collections[key] = { class: val };
    }
    const new_key = camel_case_to_snake_case(key);
    if (new_key !== key) {
      opts.collections[new_key] = opts.collections[key];
      delete opts.collections[key];
    }
    if (!opts.collections[new_key].collection_key) opts.collections[new_key].collection_key = new_key;
    if (val.item_type) {
      opts.items[val.item_type.key || camel_case_to_snake_case(val.item_type.name)] = {
        class: val.item_type
      };
    }
  });
  Object.entries(opts.modules).forEach(([key, val]) => {
    if (typeof val === "function") {
      opts.modules[key] = { class: val };
    }
    const new_key = camel_case_to_snake_case(key);
    if (new_key !== key) {
      opts.modules[new_key] = opts.modules[key];
      delete opts.modules[key];
    }
  });
  if (!opts.item_types) opts.item_types = {};
  if (!opts.items) opts.items = {};
  Object.entries(opts.item_types).forEach(([key, val]) => {
    if (typeof val === "function") {
      const new_key = camel_case_to_snake_case(key);
      opts.items[new_key] = {
        class: val,
        actions: {},
        ...opts.items[new_key] || {}
      };
    }
  });
  return opts;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/utils/deep_clone_config.js
function is_plain_object2(value) {
  if (!value || typeof value !== "object") return false;
  const proto = Object.getPrototypeOf(value);
  return proto === Object.prototype || proto === null;
}
function deep_clone_config(input) {
  if (Array.isArray(input)) {
    return input.map((item) => deep_clone_config(item));
  }
  if (is_plain_object2(input)) {
    const output = {};
    for (const [k, v] of Object.entries(input)) {
      output[k] = deep_clone_config(v);
    }
    return output;
  }
  return input;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/utils/is_plain_object.js
function is_plain_object3(o) {
  if (o === null) return false;
  if (typeof o !== "object") return false;
  if (Array.isArray(o)) return false;
  if (o instanceof Function) return false;
  if (o instanceof Date) return false;
  return Object.getPrototypeOf(o) === Object.prototype;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/utils/deep_merge_no_overwrite.js
function deep_merge_no_overwrite(target, source2, path = []) {
  if (!is_plain_object3(target) || !is_plain_object3(source2)) {
    return target;
  }
  if (path.includes(source2)) {
    return target;
  }
  path.push(source2);
  for (const key of Object.keys(source2)) {
    if (!Object.prototype.hasOwnProperty.call(source2, key)) {
      continue;
    }
    const val = source2[key];
    if (Array.isArray(target[key]) && Array.isArray(val)) {
      for (const item of val) {
        if (typeof item === "function") {
          const item_name = item.name;
          const has_same_fn = target[key].some(
            (el) => typeof el === "function" && el.name === item_name
          );
          if (!has_same_fn) {
            target[key].push(item);
          }
        } else if (item === null || ["string", "number", "boolean", "undefined"].includes(typeof item)) {
          if (!target[key].includes(item)) {
            target[key].push(item);
          }
        } else {
          target[key].push(item);
        }
      }
    } else if (is_plain_object3(val)) {
      if (!is_plain_object3(target[key])) {
        target[key] = {};
      }
      deep_merge_no_overwrite(target[key], val, [...path]);
    } else if (!Object.prototype.hasOwnProperty.call(target, key)) {
      target[key] = val;
    }
  }
  return target;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/utils/merge_env_config.js
function merge_env_config(target, incoming) {
  for (const [key, value] of Object.entries(incoming)) {
    if (key === "collections" && value && typeof value === "object") {
      if (!target.collections) target.collections = {};
      for (const [col_key, col_def] of Object.entries(value)) {
        const existing_def = target.collections[col_key];
        if (!existing_def) {
          target.collections[col_key] = { ...col_def };
          continue;
        }
        const new_ver = +(col_def?.class?.version ?? 0);
        const cur_ver = +(existing_def?.class?.version ?? 0);
        if (new_ver > cur_ver) {
          const replaced = { ...col_def };
          deep_merge_no_overwrite(replaced, existing_def);
          target.collections[col_key] = replaced;
        } else {
          deep_merge_no_overwrite(existing_def, col_def);
        }
      }
      continue;
    }
    if (key === "components" && value && typeof value === "object") {
      if (!target.components) target.components = {};
      for (const [comp_key, comp_def] of Object.entries(value)) {
        if (!target.components[comp_key]) target.components[comp_key] = comp_def;
        else {
          const new_ver = +(comp_def?.version ?? 0);
          const cur_ver = +(target.components[comp_key]?.version ?? 0);
          if (new_ver > cur_ver) {
            target.components[comp_key] = comp_def;
          } else {
            deep_merge_no_overwrite(target.components[comp_key], comp_def);
          }
        }
      }
      continue;
    }
    if (Array.isArray(value)) {
      if (Array.isArray(target[key])) {
        if (value.length > 0 && (typeof value[0] === "string" || typeof value[0] === "number" || typeof value[0] === "boolean")) {
          target[key] = Array.from(/* @__PURE__ */ new Set([...target[key], ...value]));
        } else {
          target[key] = [...target[key], ...value];
        }
      } else {
        if (value.length > 0 && (typeof value[0] === "string" || typeof value[0] === "number" || typeof value[0] === "boolean")) {
          target[key] = Array.from(new Set(value));
        } else {
          target[key] = [...value];
        }
      }
    } else if (value && typeof value === "object") {
      if (!target[key]) target[key] = {};
      deep_merge_no_overwrite(target[key], value);
    } else {
      target[key] = value;
    }
  }
  return target;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/migrations/exclusion_settings.js
function migrate_exclusion_settings_2025_08_22(settings = {}) {
  const { file_exclusions, folder_exclusions, excluded_headings } = settings;
  if (file_exclusions !== void 0 || folder_exclusions !== void 0 || excluded_headings !== void 0) {
    settings.smart_sources = settings.smart_sources || {};
    if (file_exclusions !== void 0) {
      if (file_exclusions.length && file_exclusions !== "Untitled" && (!settings.smart_sources?.file_exclusions?.length || settings.smart_sources?.file_exclusions === "Untitled")) {
        settings.smart_sources.file_exclusions = file_exclusions;
      }
    }
    if (folder_exclusions !== void 0) {
      if (folder_exclusions.length && !settings.smart_sources.folder_exclusions?.length) {
        settings.smart_sources.folder_exclusions = folder_exclusions;
      }
    }
    if (excluded_headings !== void 0) {
      if (excluded_headings.length && !settings.smart_sources.excluded_headings?.length) {
        settings.smart_sources.excluded_headings = excluded_headings;
      }
    }
  }
  delete settings.file_exclusions;
  delete settings.folder_exclusions;
  delete settings.excluded_headings;
  return settings;
}

// node_modules/obsidian-smart-env/node_modules/smart-environment/smart_env.js
var ROOT_SCOPE = typeof globalThis !== "undefined" ? globalThis : Function("return this")();
var SmartEnv = class {
  /**
   * @type {number} version - Bump this number when shipping a new version of SmartEnv.
   * If a newer version is loaded into a runtime that already has an older environment,
   * an automatic reload of all existing mains will occur.
   */
  static version = 2.139272;
  scope_name = "smart_env";
  static global_ref = ROOT_SCOPE;
  global_ref = this.constructor.global_ref;
  constructor(opts = {}) {
    this.state = "init";
    this._components = {};
    this.collections = {};
    this.load_timeout = null;
    this._collections_version_signature = null;
    if (opts.primary_main_key) this.primary_main_key = opts.primary_main_key;
  }
  // ========================================================================
  // ──  CONFIG (now version-aware)                                          ──
  // ========================================================================
  /**
   * Builds or returns the cached configuration object.
   * The cache is invalidated automatically whenever the “version signature”
   * of any collection class changes (controlled by its static `version`).
   *
   * @returns {Object} the merged, up-to-date environment config
   */
  get config() {
    const signature = this.compute_collections_version_signature();
    if (this._config && signature === this._collections_version_signature) {
      return this._config;
    }
    this._collections_version_signature = signature;
    this._config = {};
    const sorted_configs = Object.entries(this.smart_env_configs).sort(([main_key]) => {
      if (!this.primary_main_key) return 0;
      return main_key === this.primary_main_key ? -1 : 0;
    });
    for (const [key, rec] of sorted_configs) {
      if (!rec?.main) {
        console.warn(`SmartEnv: '${key}' unloaded, skipping`);
        delete this.smart_env_configs[key];
        continue;
      }
      if (!rec?.opts) {
        console.warn(`SmartEnv: '${key}' opts missing, skipping`);
        continue;
      }
      merge_env_config(
        this._config,
        deep_clone_config(normalize_opts(rec.opts))
      );
    }
    return this._config;
  }
  /**
   * Produces a deterministic string representing the current versions of every
   * collection class across all mains.  When any collection ships a higher
   * `static version`, the signature changes – automatically invalidating the
   * cached `config`.
   *
   * @returns {string} pipe-delimited version signature
   */
  compute_collections_version_signature() {
    const list = [];
    for (const rec of Object.values(this.smart_env_configs)) {
      const { opts } = rec || {};
      if (!opts) continue;
      for (const [collection_key, def] of Object.entries(opts.collections || {})) {
        const cls = def?.class;
        const v = typeof cls?.version === "number" ? cls.version : 0;
        list.push(`${collection_key}:${v}`);
      }
    }
    return list.sort().join("|");
  }
  // ========================================================================
  // ──  GLOBAL HELPERS / STATIC API                                         ──
  // ========================================================================
  get env_start_wait_time() {
    if (typeof this.config.env_start_wait_time === "number") return this.config.env_start_wait_time;
    return 5e3;
  }
  static get global_env() {
    return this.global_ref.smart_env;
  }
  static set global_env(env) {
    this.global_ref.smart_env = env;
  }
  static get mains() {
    return Object.keys(this.global_ref.smart_env_configs || {});
  }
  get mains() {
    return Object.keys(this.global_ref.smart_env_configs || {});
  }
  static get should_reload() {
    if (!this.global_env) return true;
    if (this.global_env.state === "loaded") return true;
    if (typeof this.global_env?.constructor?.version === "undefined") return true;
    if (this.global_env.constructor.version < this.version) {
      console.warn(
        "SmartEnv: Reloading environment because of version mismatch",
        `${this.version} > ${this.global_env.constructor.version}`
      );
      return true;
    }
    return false;
  }
  static get smart_env_configs() {
    if (!this.global_ref.smart_env_configs) this.global_ref.smart_env_configs = {};
    return this.global_ref.smart_env_configs;
  }
  get smart_env_configs() {
    if (!this.global_ref.smart_env_configs) this.global_ref.smart_env_configs = {};
    return this.global_ref.smart_env_configs;
  }
  /**
   * Serializes all collection data in the environment into a plain object.
   * @returns {object}
   */
  to_json() {
    return Object.fromEntries(
      Object.entries(this).filter(([, val]) => typeof val?.collection_key !== "undefined").map(([key, collection]) => [key, collection_to_plain(collection)])
    );
  }
  /**
   * Waits for either a specific main to be registered in the environment,
   * or (if `opts.main` is not specified) waits for environment collections to load.
   * @param {object} opts
   * @param {object} [opts.main] - if set, the function waits until that main is found.
   * @returns {Promise<SmartEnv>} Resolves with the environment instance
   */
  static wait_for(opts = {}) {
    return new Promise((resolve) => {
      if (opts.main) {
        const interval = setInterval(() => {
          if (this.global_env && this.global_env[opts.main]) {
            clearInterval(interval);
            resolve(this.global_env);
          }
        }, 1e3);
      } else {
        const interval = setInterval(() => {
          if (this.global_env && this.global_env.state === "loaded") {
            clearInterval(interval);
            resolve(this.global_env);
          }
        }, 100);
      }
    });
  }
  /**
   * Creates or updates a SmartEnv instance.
   * - If a global environment exists and is an older version or lacks 'init_main', it is replaced.
   * @param {Object} main - The main object to be added to the SmartEnv instance.
   * @param {Object} [main_env_opts={}] - Options for configuring the SmartEnv instance.
   * @returns {SmartEnv} The SmartEnv instance.
   * @throws {TypeError} If an invalid main object is provided.
   * @throws {Error} If there's an error creating or updating the SmartEnv instance.
   */
  static async create(main, main_env_opts = null) {
    if (!main || typeof main !== "object") {
      throw new TypeError("SmartEnv: Invalid main object provided");
    }
    if (!main_env_opts) {
      if (!main.smart_env_config) {
        throw new Error("SmartEnv: No main_env_opts or main.smart_env_config provided");
      }
      main_env_opts = main.smart_env_config;
    }
    this.add_main(main, main_env_opts);
    if (this.should_reload) {
      const opts = {};
      if (this.global_env && this.version > (this.global_env.constructor?.version || 0)) {
        opts.primary_main_key = camel_case_to_snake_case(main.constructor.name);
      }
      if (this.global_env?.load_timeout) clearTimeout(this.global_env.load_timeout);
      this.global_env = new this(opts);
      const g = this.global_ref;
      if (!g.all_envs) g.all_envs = [];
      g.all_envs.push(this.global_env);
    }
    clearTimeout(this.global_env.load_timeout);
    this.global_env.load_timeout = setTimeout(async () => {
      await this.global_env.load();
      this.global_env.load_timeout = null;
    }, this.global_env.env_start_wait_time);
    return this.global_env;
  }
  static add_main(main, main_env_opts = null) {
    if (this.global_env) {
      this.global_env._config = null;
      this.global_env._collections_version_signature = null;
    }
    if (!main_env_opts) main_env_opts = main.smart_env_config;
    const main_key = camel_case_to_snake_case(main.constructor.name);
    this.smart_env_configs[main_key] = { main, opts: main_env_opts };
    this.create_env_getter(main);
  }
  /**
   * Creates a dynamic environment getter on any instance object.
   * The returned 'env' property will yield the global `smart_env`.
   * @param {Object} instance_to_receive_getter
   */
  static create_env_getter(instance_to_receive_getter) {
    Object.defineProperty(instance_to_receive_getter, "env", {
      configurable: true,
      get: () => this.global_env
    });
  }
  create_env_getter(instance_to_receive_getter) {
    this.constructor.create_env_getter(instance_to_receive_getter);
  }
  async load() {
    this.state = "loading";
    await this.fs.load_files();
    if (!this.settings) await SmartSettings.create(this);
    if (this.config.default_settings) {
      deep_merge_no_overwrite(this.settings, this.config.default_settings);
    }
    migrate_exclusion_settings_2025_08_22(this.settings);
    this.smart_settings.save();
    await this.init_collections();
    for (const [main_key, { main, opts }] of Object.entries(this.smart_env_configs)) {
      this[main_key] = main;
    }
    await this.ready_to_load_collections();
    await this.load_collections();
    this.state = "loaded";
  }
  /**
   * Initializes collection classes if they have an 'init' function.
   * @param {Object} [config=this.config]
  */
  async init_collections(config = this.config) {
    for (const key of Object.keys(config.collections || {})) {
      const _class = config.collections[key]?.class;
      if (!_class) continue;
      if (_class.default_settings) {
        deep_merge_no_overwrite(
          this.settings,
          {
            [key]: _class.default_settings
          }
        );
      }
      if (typeof _class.init !== "function") continue;
      await _class.init(this, { ...config.collections[key] });
      this.collections[key] = "init";
    }
  }
  /**
   * Hook/Override this method to wait for any conditions before loading collections. 
   * @param {Object} main
   */
  async ready_to_load_collections() {
  }
  /**
   * Loads any available collections, processing their load queues.
   * @param {Object} [collections=this.collections] - Key-value map of collection instances.
   */
  async load_collections(collections = this.collections) {
    for (const key of Object.keys(collections || {})) {
      const time_start = Date.now();
      if (typeof this[key]?.process_load_queue === "function") {
        await this[key].process_load_queue();
        this[key].load_time_ms = Date.now() - time_start;
        this.collections[key] = "loaded";
        console.log(`Loaded ${this[key].collection_key} in ${this[key].load_time_ms}ms`);
      }
    }
  }
  /**
   * Removes a main from the global.smart_env_configs to exclude it on reload
   * @param {Class} main
   * @param {Object|null} [unload_config=null]
   */
  static unload_main(main) {
    const main_key = camel_case_to_snake_case(main.constructor.name);
    this.smart_env_configs[main_key] = null;
    delete this.smart_env_configs[main_key];
  }
  unload_main(main) {
    this.constructor.unload_main(main);
  }
  /**
   * Triggers a save event in all known collections.
   */
  save() {
    for (const key of Object.keys(this.collections)) {
      this[key].process_save_queue?.();
    }
  }
  /**
   * Initialize a module from the configured `this.opts.modules`.
   * @param {string} module_key
   * @param {object} opts
   * @returns {object|null} instance of the requested module or null if not found
   */
  init_module(module_key, opts = {}) {
    const module_config = this.opts.modules[module_key];
    if (!module_config) {
      return console.warn(`SmartEnv: module ${module_key} not found`);
    }
    opts = {
      ...{ ...module_config, class: null },
      ...opts
    };
    return new module_config.class(opts);
  }
  get notices() {
    if (!this._notices) {
      const SmartNoticesClass = this.config.modules.smart_notices.class;
      this._notices = new SmartNoticesClass(this, {
        adapter: this.config.modules.smart_notices.adapter
      });
    }
    return this._notices;
  }
  /**
   * Exposes a settings template function from environment opts or defaults.
   * @returns {Function}
   */
  get settings_template() {
    return this.opts.components?.smart_env?.settings || render;
  }
  /**
   * Renders settings UI into a container, using the environment's `settings_template`.
   * @param {HTMLElement} [container=this.settings_container]
   */
  async render_settings(container = this.settings_container) {
    if (!this.settings_container || container !== this.settings_container) {
      this.settings_container = container;
    }
    if (!container) {
      throw new Error("Container is required");
    }
    const frag = await this.render_component("settings", this, {});
    this.smart_view.empty(container);
    container.appendChild(frag);
    return frag;
  }
  /**
   * Renders a named component using an optional scope and options.
   * @param {string} component_key
   * @param {Object} scope
   * @param {Object} [opts]
   * @returns {Promise<HTMLElement>}
   */
  async render_component(component_key, scope, opts = {}) {
    const component_renderer = this.get_component(component_key, scope);
    if (!component_renderer) {
      console.warn(`SmartEnv: component ${component_key} not found for scope ${scope.constructor.name}`);
      return this.smart_view.create_doc_fragment(`<div class="smart-env-component-not-found">
        <h1>Component Not Found</h1>
        <p>The component ${component_key} was not found for scope ${scope.constructor.name}.</p>
      </div>`);
    }
    const frag = await component_renderer(scope, opts);
    return frag;
  }
  /**
   * Retrieves or creates a memoized component renderer function.
   * @param {string} component_key
   * @param {Object} scope
   * @returns {Function|undefined}
   */
  get_component(component_key, scope) {
    const scope_name = scope.collection_key ?? scope.scope_name;
    const _cache_key = scope_name ? `${scope_name}-${component_key}` : component_key;
    if (!this._components[_cache_key]) {
      try {
        if (this.opts.components[scope_name]?.[component_key]) {
          this._components[_cache_key] = this.opts.components[scope_name][component_key].bind(
            this.init_module("smart_view")
          );
        } else if (this.opts.components[component_key]) {
          this._components[_cache_key] = this.opts.components[component_key].bind(
            this.init_module("smart_view")
          );
        } else {
          console.warn(
            `SmartEnv: component ${component_key} not found for scope ${scope_name}`
          );
        }
      } catch (e) {
        console.error("Error getting component", e);
        console.log(
          `scope_name: ${scope_name}; component_key: ${component_key}; this.opts.components: ${Object.keys(
            this.opts.components || {}
          ).join(", ")}; this.opts.components[scope_name]: ${Object.keys(
            this.opts.components[scope_name] || {}
          ).join(", ")}`
        );
      }
    }
    return this._components[_cache_key];
  }
  /**
   * Lazily instantiate the module 'smart_view'.
   * @returns {object}
   */
  get smart_view() {
    if (!this._smart_view) {
      this._smart_view = this.init_module("smart_view");
    }
    return this._smart_view;
  }
  /**
   * A built-in settings schema for this environment.
   * @returns {Object}
   */
  get settings_config() {
    return {
      is_obsidian_vault: {
        name: "Obsidian Vault",
        description: "Toggle on if this is an Obsidian vault.",
        type: "toggle",
        default: false
      }
    };
  }
  get global_prop() {
    return this.opts.global_prop ?? "smart_env";
  }
  get item_types() {
    return this.opts.item_types;
  }
  get fs_module_config() {
    return this.opts.modules.smart_fs;
  }
  get fs() {
    if (!this.smart_fs) {
      this.smart_fs = new this.fs_module_config.class(this, {
        adapter: this.fs_module_config.adapter,
        fs_path: this.opts.env_path || ""
      });
    }
    return this.smart_fs;
  }
  get env_data_dir() {
    const env_settings_files = this.fs.file_paths?.filter((path) => path.endsWith("smart_env.json")) || [];
    let env_data_dir = ".smart-env";
    if (env_settings_files.length > 0) {
      if (env_settings_files.length > 1) {
        const env_data_dir_counts = env_settings_files.map((path) => {
          const dir = path.split("/").slice(-2, -1)[0];
          return {
            dir,
            count: this.fs.file_paths.filter((p) => p.includes(dir)).length
          };
        });
        env_data_dir = env_data_dir_counts.reduce(
          (max, dirObj) => dirObj.count > max.count ? dirObj : max,
          env_data_dir_counts[0]
        ).dir;
      } else {
        env_data_dir = env_settings_files[0].split("/").slice(-2, -1)[0];
      }
    }
    return env_data_dir;
  }
  get data_fs() {
    if (!this._fs) {
      this._fs = new this.fs_module_config.class(this, {
        adapter: this.fs_module_config.adapter,
        fs_path: this.data_fs_path
      });
    }
    return this._fs;
  }
  get data_fs_path() {
    if (!this._data_fs_path) {
      this._data_fs_path = (this.opts.env_path + (this.opts.env_path ? this.opts.env_path.includes("\\") ? "\\" : "/" : "") + this.env_data_dir).replace(/\\\\/g, "\\").replace(/\/\//g, "/");
    }
    return this._data_fs_path;
  }
  /**
   * Saves the current settings to the file system.
   * @param {Object|null} [settings=null] - Optional settings to override the current settings before saving.
   * @returns {Promise<void>}
   */
  async save_settings(settings) {
    this._saved = false;
    if (!await this.data_fs.exists("")) {
      await this.data_fs.mkdir("");
    }
    await this.data_fs.write("smart_env.json", JSON.stringify(settings, null, 2));
    this._saved = true;
  }
  /**
   * Loads settings from the file system, merging with any `default_settings` or `smart_env_settings`.
   * @returns {Promise<Object>} the loaded settings
   */
  async load_settings() {
    if (!await this.data_fs.exists("smart_env.json")) await this.save_settings({});
    let settings = JSON.parse(JSON.stringify(this.config.default_settings || {}));
    deep_merge(settings, JSON.parse(await this.data_fs.read("smart_env.json")));
    deep_merge(settings, this.opts?.smart_env_settings || {});
    this._saved = true;
    if (this.fs.auto_excluded_files) {
      const existing_file_exclusions = settings.smart_sources.file_exclusions.split(",").map((s) => s.trim()).filter(Boolean);
      settings.smart_sources.file_exclusions = [...existing_file_exclusions, ...this.fs.auto_excluded_files].filter((value, index, self) => self.indexOf(value) === index).join(",");
    }
    return settings;
  }
  /**
   * Refreshes file-system state if exclusions changed,
   * then re-renders relevant settings UI
   */
  async update_exclusions() {
    this.smart_sources._fs = null;
    await this.smart_sources.init_fs();
  }
  // DEPRECATED
  /** @deprecated access `this.state` and `collection.state` directly instead */
  get collections_loaded() {
    return this.state === "loaded";
  }
  /** @deprecated Use this['main_class_name'] instead of this.main/this.plugin */
  get main() {
    return this.smart_env_configs[this.mains[0]]?.main;
  }
  /**
   * @deprecated use component pattern instead
   */
  get ejs() {
    return this.opts.ejs;
  }
  /**
   * @deprecated use component pattern instead
   */
  get templates() {
    return this.opts.templates;
  }
  /**
   * @deprecated use component pattern instead
   */
  get views() {
    return this.opts.views;
  }
  /**
   * @deprecated use this.config instead
   */
  get opts() {
    return this.config;
  }
  /**
   * @deprecated Use this.main_class_name instead of this.plugin
   */
  get plugin() {
    return this.main;
  }
};
function collection_to_plain(collection) {
  return {
    items: Object.fromEntries(
      Object.entries(collection.items || {}).map(([key, item]) => [key, item.data])
    )
  };
}

// node_modules/obsidian-smart-env/node_modules/smart-file-system/utils/glob_to_regex.js
function create_regex(pattern, { case_sensitive, extended_glob, windows_paths }) {
  const regex_pattern = glob_to_regex_pattern(pattern, extended_glob);
  const adjusted_pattern = adjust_for_windows_paths(regex_pattern, windows_paths);
  const flags = case_sensitive ? "" : "i";
  return new RegExp(`^${adjusted_pattern}$`, flags);
}
function adjust_for_windows_paths(pattern, windows_paths) {
  return windows_paths ? pattern.replace(/\\\//g, "[\\\\/]").replace(/\\\\\\/g, "[\\\\/]") : pattern;
}
function glob_to_regex_pattern(pattern, extended_glob) {
  let in_class = false;
  let in_brace = 0;
  let result = "";
  for (let i = 0; i < pattern.length; i++) {
    const char = pattern[i];
    switch (char) {
      case "\\":
        if (i + 1 < pattern.length) {
          result += `\\${pattern[i + 1]}`;
          i++;
        } else {
          result += "\\\\";
        }
        break;
      case "/":
        result += "\\/";
        break;
      case "[":
        if (!in_class) {
          const closingIndex = pattern.indexOf("]", i + 1);
          if (closingIndex === -1) {
            result += "\\[";
          } else {
            in_class = true;
            if (pattern[i + 1] === "!") {
              result += "[^";
              i++;
            } else {
              result += "[";
            }
          }
        } else {
          result += "\\[";
        }
        break;
      case "]":
        if (in_class) {
          in_class = false;
          result += "]";
        } else {
          result += "\\]";
        }
        break;
      case "{":
        if (!in_class) {
          const closingIndex = pattern.indexOf("}", i + 1);
          if (closingIndex === -1) {
            result += "\\{";
          } else {
            in_brace++;
            result += "(";
          }
        } else {
          result += "\\{";
        }
        break;
      case "}":
        if (!in_class && in_brace > 0) {
          in_brace--;
          result += ")";
        } else {
          result += "\\}";
        }
        break;
      case ",":
        if (!in_class && in_brace > 0) {
          result += "|";
        } else {
          result += ",";
        }
        break;
      case "*":
        if (!in_class) {
          if (i + 1 < pattern.length && pattern[i + 1] === "*") {
            result += ".*";
            i++;
          } else {
            result += "[^/]*";
          }
        } else {
          result += "\\*";
        }
        break;
      case "?":
        if (!in_class) {
          result += "[^/]";
        } else {
          result += "\\?";
        }
        break;
      // We escape these to ensure they remain literal
      case "(":
      case ")":
      case "+":
      case "|":
      case "^":
      case "$":
      case ".":
        result += `\\${char}`;
        break;
      default:
        result += char;
        break;
    }
  }
  if (in_class) {
    result += "]";
    in_class = false;
  }
  if (extended_glob) {
    result = result.replace(/\\\+\\\((.*?)\\\)/g, "($1)+").replace(/\\\@\\\((.*?)\\\)/g, "($1)").replace(/\\\!\\\((.*?)\\\)/g, "(?!$1).*").replace(/\\\?\\\((.*?)\\\)/g, "($1)?").replace(/\\\*\\\((.*?)\\\)/g, "($1)*");
  }
  return result;
}
function glob_to_regex(pattern, options = {}) {
  const default_options = {
    case_sensitive: true,
    extended_glob: false,
    windows_paths: false
  };
  const merged_options = { ...default_options, ...options };
  if (pattern === "") {
    return /^$/;
  }
  if (pattern === "*" && !merged_options.windows_paths) {
    return /^[^/]+$/;
  }
  if (pattern === "**" && !merged_options.windows_paths) {
    return /^.+$/;
  }
  return create_regex(pattern, merged_options);
}

// node_modules/obsidian-smart-env/node_modules/smart-file-system/utils/fuzzy_search.js
function fuzzy_search(arr, search_term) {
  let matches = [];
  for (let i = 0; i < arr.length; i++) {
    const search_chars = search_term.toLowerCase().split("");
    let match = true;
    let distance = 0;
    const name = arr[i];
    const label_name = name.toLowerCase();
    for (let j = 0; j < search_chars.length; j++) {
      const search_index = label_name.substring(distance).indexOf(search_chars[j]);
      if (search_index >= 0) {
        distance += search_index + 1;
      } else {
        match = false;
        break;
      }
    }
    if (match) matches.push({ name, distance });
  }
  matches.sort((a, b) => a.distance - b.distance);
  return matches.map((match) => match.name);
}

// node_modules/obsidian-smart-env/node_modules/smart-file-system/smart_fs.js
var SmartFs = class {
  /**
   * Create a new SmartFs instance
   * 
   * @param {Object} env - The Smart Environment instance
   * @param {Object} [opts={}] - Optional configuration
   * @param {string} [opts.fs_path] - Custom environment path
   */
  constructor(env, opts = {}) {
    this.env = env;
    this.opts = opts;
    this.fs_path = opts.fs_path || opts.env_path || "";
    if (!opts.adapter) throw new Error("SmartFs requires an adapter");
    this.adapter = new opts.adapter(this);
    this.excluded_patterns = [];
    if (Array.isArray(opts.exclude_patterns)) {
      opts.exclude_patterns.forEach((pattern) => this.add_ignore_pattern(pattern));
    }
    this.folders = {};
    this.files = {};
    this.file_paths = [];
    this.folder_paths = [];
    this.auto_excluded_files = [];
  }
  async refresh() {
    this.files = {};
    this.file_paths = [];
    this.folders = {};
    this.folder_paths = [];
    await this.init();
  }
  async init() {
    await this.load_exclusions();
    await this.load_files();
  }
  async load_files() {
    const all = await this.list_recursive();
    this.file_paths = [];
    this.folder_paths = [];
    all.forEach((file) => {
      if (file.type === "file") {
        this.files[file.path] = file;
        this.file_paths.push(file.path);
      } else if (file.type === "folder") {
        this.folders[file.path] = file;
        this.folder_paths.push(file.path);
      }
    });
  }
  include_file(file_path) {
    const file = this.adapter.get_file(file_path);
    this.files[file.path] = file;
    this.file_paths.push(file.path);
    return file;
  }
  /**
   * Load .gitignore patterns
   * 
   * @returns {Promise<RegExp[]>} Array of RegExp patterns
   */
  async load_exclusions() {
    const gitignore_path = ".gitignore";
    const gitignore_exists = await this.adapter.exists(gitignore_path);
    if (gitignore_exists && !this.env.settings.skip_excluding_gitignore) {
      const gitignore_content = await this.adapter.read(gitignore_path, "utf-8");
      gitignore_content.split("\n").filter((line) => !line.startsWith("#")).filter(Boolean).forEach((pattern) => this.add_ignore_pattern(pattern));
    }
    this.add_ignore_pattern(".**");
    this.add_ignore_pattern("**/.**");
    this.add_ignore_pattern("**/.*/**");
    this.add_ignore_pattern("**/*.ajson");
  }
  /**
   * Add a new ignore pattern
   * 
   * @param {string} pattern - The pattern to add
   */
  add_ignore_pattern(pattern, opts = {}) {
    this.excluded_patterns.push(glob_to_regex(pattern.trim(), opts));
  }
  /**
   * Check if a path is ignored based on gitignore patterns
   * 
   * @param {string} _path - The path to check
   * @returns {boolean} True if the path is ignored, false otherwise
   */
  is_excluded(_path) {
    try {
      if (_path.includes("#")) return true;
      if (!this.excluded_patterns.length) return false;
      return this.excluded_patterns.some((pattern) => pattern.test(_path));
    } catch (e) {
      console.error(`Error checking if path is excluded: ${e.message}`);
      console.error(`Path: `, _path);
      throw e;
    }
  }
  /**
   * Check if any path in an array of paths is excluded
   * 
   * @param {string[]} paths - Array of paths to check
   * @returns {boolean} True if any path is excluded, false otherwise
   */
  has_excluded_patterns(paths) {
    return paths.some((p) => this.is_excluded(p));
  }
  /**
   * Pre-process an array of paths, throwing an error if any path is excluded
   * 
   * @param {string[]} paths - Array of paths to pre-process
   * @throws {Error} If any path in the array is excluded
   * @returns {string[]} The array of paths
   */
  pre_process(paths) {
    if (this.has_excluded_patterns(paths)) {
      throw new Error(`Path is excluded: ${paths.find((p) => this.is_excluded(p))}`);
    }
    return paths;
  }
  /**
   * Post-process the result of an operation
   * 
   * @param {any} returned_value - The value returned by the operation
   * @returns {any} The post-processed value
   */
  post_process(returned_value) {
    if (this.adapter.post_process) return this.adapter.post_process(returned_value);
    if (Array.isArray(returned_value)) {
      returned_value = returned_value.filter((r) => {
        if (typeof r === "string") return !this.is_excluded(r);
        if (typeof r === "object" && r.path) return !this.is_excluded(r.path);
        return true;
      });
    }
    return returned_value;
  }
  // v2
  /**
   * Use the adapter for a method
   * runs pre_process and post_process (checks exclusions)
   * @param {string} method - The method to use
   * @param {string[]} paths - The paths to use
   * @param {...any} args - Additional arguments for the method
   * @returns {Promise<any>} The result of the method
   */
  async use_adapter(method, paths, ...args) {
    if (!this.adapter[method]) throw new Error(`Method ${method} not found in adapter`);
    paths = this.pre_process(paths ?? []);
    let resp = await this.adapter[method](...paths, ...args);
    return this.post_process(resp);
  }
  use_adapter_sync(method, paths, ...args) {
    if (!this.adapter[method]) throw new Error(`Method ${method} not found in adapter`);
    paths = this.pre_process(paths ?? []);
    let resp = this.adapter[method](...paths, ...args);
    return this.post_process(resp);
  }
  /**
   * Append content to a file
   * 
   * @param {string} rel_path - The relative path of the file to append to
   * @param {string|Buffer} content - The content to append
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async append(rel_path, content) {
    return await this.use_adapter("append", [rel_path], content);
  }
  /**
   * Create a new directory
   * 
   * @param {string} rel_path - The relative path of the directory to create
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async mkdir(rel_path, opts = { recursive: true }) {
    return await this.use_adapter("mkdir", [rel_path], opts);
  }
  /**
   * Check if a file or directory exists
   * 
   * @param {string} rel_path - The relative path to check
   * @returns {Promise<boolean>} True if the path exists, false otherwise
   */
  async exists(rel_path) {
    return await this.use_adapter("exists", [rel_path]);
  }
  exists_sync(rel_path) {
    return this.use_adapter_sync("exists_sync", [rel_path]);
  }
  /**
   * List files in a directory
   * 
   * @param {string} rel_path - The relative path to list
   * @returns {Promise<string[]>} Array of file paths
   */
  async list(rel_path = "/") {
    return await this.use_adapter("list", [rel_path]);
  }
  async list_recursive(rel_path = "/") {
    return await this.use_adapter("list_recursive", [rel_path]);
  }
  async list_files(rel_path = "/") {
    return await this.use_adapter("list_files", [rel_path]);
  }
  async list_files_recursive(rel_path = "/") {
    return await this.use_adapter("list_files_recursive", [rel_path]);
  }
  async list_folders(rel_path = "/") {
    return await this.use_adapter("list_folders", [rel_path]);
  }
  async list_folders_recursive(rel_path = "/") {
    return await this.use_adapter("list_folders_recursive", [rel_path]);
  }
  /**
   * Read the contents of a file
   * 
   * @param {string} rel_path - The relative path of the file to read
   * @returns {Promise<string|Buffer>} The contents of the file
   */
  async read(rel_path, encoding = "utf-8") {
    try {
      const content = await this.adapter.read(rel_path, encoding);
      return content;
    } catch (error) {
      console.warn("Error during read: " + error.message, rel_path);
      if (error.code === "ENOENT") return null;
      return { error: error.message };
    }
  }
  /**
   * Remove a file
   * 
   * @param {string} rel_path - The relative path of the file to remove
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async remove(rel_path) {
    return await this.use_adapter("remove", [rel_path]);
  }
  /**
   * Remove a directory
   * 
   * @param {string} rel_path - The relative path of the directory to remove
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async remove_dir(rel_path, recursive = false) {
    return await this.use_adapter("remove_dir", [rel_path], recursive);
  }
  /**
   * Rename a file or directory
   * 
   * @param {string} rel_path - The current relative path
   * @param {string} new_rel_path - The new relative path
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async rename(rel_path, new_rel_path) {
    await this.use_adapter("rename", [rel_path, new_rel_path]);
    await this.refresh();
  }
  /**
   * Get file or directory statistics
   * 
   * @param {string} rel_path - The relative path to get statistics for
   * @returns {Promise<Object>} An object containing file or directory statistics
   */
  async stat(rel_path) {
    return await this.use_adapter("stat", [rel_path]);
  }
  /**
   * Write content to a file
   * Should handle when target path is within a folder that doesn't exist
   * 
   * @param {string} rel_path - The relative path of the file to write to
   * @param {string|Buffer} content - The content to write
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async write(rel_path, content) {
    try {
      await this.adapter.write(rel_path, content);
    } catch (error) {
      console.error("Error during write:", error);
      throw error;
    }
  }
  // // aliases
  // async create(rel_path, content) { return await this.use_adapter('write', [rel_path], content); }
  // async update(rel_path, content) { return await this.use_adapter('write', [rel_path], content); }
  get_link_target_path(link_target, source_path) {
    if (this.adapter.get_link_target_path) return this.adapter.get_link_target_path(link_target, source_path);
    if (!this.file_paths) return console.warn("get_link_target_path: file_paths not found");
    const matching_file_paths = this.file_paths.filter((path) => path.includes(link_target));
    return fuzzy_search(matching_file_paths, link_target)[0];
  }
  get sep() {
    return this.adapter.sep || "/";
  }
  get_full_path(rel_path = "") {
    return this.adapter.get_full_path(rel_path);
  }
  get base_path() {
    return this.adapter.get_base_path();
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-file-system/adapters/obsidian.js
var obsidian = __toESM(require("obsidian"), 1);
var SmartFsObsidianAdapter = class {
  /**
   * Create an SmartFsObsidianAdapter instance
   * 
   * @param {Object} smart_fs - The SmartFs instance
   */
  constructor(smart_fs) {
    this.smart_fs = smart_fs;
    this.obsidian = obsidian;
    this.obsidian_app = smart_fs.env.main.app;
    this.obsidian_adapter = smart_fs.env.main.app.vault.adapter;
  }
  get fs_path() {
    return this.smart_fs.fs_path;
  }
  get_file(file_path) {
    const file = {};
    file.path = file_path.replace(/\\/g, "/").replace(this.smart_fs.fs_path, "").replace(/^\//, "");
    file.type = "file";
    file.extension = file.path.split(".").pop().toLowerCase();
    file.name = file.path.split("/").pop();
    file.basename = file.name.split(".").shift();
    Object.defineProperty(file, "stat", {
      get: () => {
        const tfile = this.obsidian_app.vault.getAbstractFileByPath(file_path);
        if (tfile) {
          return {
            ctime: tfile.stat.ctime,
            mtime: tfile.stat.mtime,
            size: tfile.stat.size,
            isDirectory: () => tfile instanceof this.obsidian.TFolder,
            isFile: () => tfile instanceof this.obsidian.TFile
          };
        }
        return null;
      }
    });
    return file;
  }
  /**
   * Append content to a file
   * 
   * @param {string} rel_path - The relative path of the file to append to
   * @param {string} data - The content to append
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async append(rel_path, data) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    return await this.obsidian_adapter.append(rel_path, data);
  }
  /**
   * Create a new directory
   * 
   * @param {string} rel_path - The relative path of the directory to create
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async mkdir(rel_path) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    return await this.obsidian_adapter.mkdir(rel_path);
  }
  /**
   * Check if a file or directory exists
   * 
   * @param {string} rel_path - The relative path to check
   * @returns {Promise<boolean>} True if the path exists, false otherwise
   */
  async exists(rel_path) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    return await this.obsidian_adapter.exists(rel_path);
  }
  exists_sync(rel_path) {
    return !!this.obsidian_app.vault.getAbstractFileByPath(rel_path);
  }
  /**
   * List files in a directory (NOT up-to-date with list_recursive)
   * 
   * @param {string} rel_path - The relative path to list
   * @returns {Promise<string[]>} Array of file paths
   */
  async list(rel_path, opts = {}) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    if (rel_path.startsWith("/")) rel_path = rel_path.slice(1);
    if (rel_path.endsWith("/")) rel_path = rel_path.slice(0, -1);
    if (rel_path.includes(".")) {
      const { files: file_paths } = await this.obsidian_adapter.list(rel_path);
      const files2 = file_paths.map((file_path) => {
        if (this.smart_fs.fs_path) file_path = file_path.replace(this.smart_fs.fs_path, "").slice(1);
        const file_name = file_path.split("/").pop();
        const file = {
          basename: file_name.split(".")[0],
          extension: file_name.split(".").pop().toLowerCase(),
          name: file_name,
          path: file_path
        };
        return file;
      });
      return files2;
    }
    const files = this.obsidian_app.vault.getAllLoadedFiles().filter((file) => {
      const last_slash = file.path.lastIndexOf("/");
      if (last_slash === -1 && rel_path !== "") return false;
      const folder_path = file.path.slice(0, last_slash);
      if (folder_path !== rel_path) return false;
      return true;
    });
    return files;
  }
  // NOTE: currently does not handle hidden files and folders
  async list_recursive(rel_path, opts = {}) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    if (rel_path.startsWith("/")) rel_path = rel_path.slice(1);
    if (rel_path.endsWith("/")) rel_path = rel_path.slice(0, -1);
    const files = this.obsidian_app.vault.getAllLoadedFiles().filter((file) => {
      if (file.path.length > 200) {
        this.smart_fs.auto_excluded_files.push(file.path);
        return false;
      }
      if (rel_path !== "" && !file.path.startsWith(rel_path)) return false;
      if (file instanceof this.obsidian.TFile) {
        if (opts.type === "folder") return false;
        file.type = "file";
      } else if (file instanceof this.obsidian.TFolder) {
        if (opts.type === "file") return false;
        delete file.basename;
        delete file.extension;
        file.type = "folder";
      }
      if (this.smart_fs.fs_path) file.path = file.path.replace(this.smart_fs.fs_path, "").slice(1);
      return true;
    });
    return files;
  }
  async list_files(rel_path) {
    return await this.list(rel_path, { type: "file" });
  }
  async list_files_recursive(rel_path) {
    return await this.list_recursive(rel_path, { type: "file" });
  }
  async list_folders(rel_path) {
    return await this.list(rel_path, { type: "folder" });
  }
  async list_folders_recursive(rel_path) {
    return await this.list_recursive(rel_path, { type: "folder" });
  }
  /**
   * Read the contents of a file
   * 
   * @param {string} rel_path - The relative path of the file to read
   * @returns {Promise<string>} The contents of the file
   */
  async read(rel_path, encoding, opts = {}) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    if (encoding === "utf-8") {
      if (!opts.no_cache) {
        const tfile = this.obsidian_app.vault.getFileByPath(rel_path);
        if (tfile) return await this.obsidian_app.vault.cachedRead(tfile);
      }
      return await this.obsidian_adapter.read(rel_path);
    }
    if (encoding === "base64") {
      const array_buffer2 = await this.obsidian_adapter.readBinary(rel_path, "base64");
      const base642 = this.obsidian.arrayBufferToBase64(array_buffer2);
      return base642;
    }
    const array_buffer = await this.obsidian_adapter.readBinary(rel_path);
    return array_buffer;
  }
  /**
   * Rename a file or directory
   * 
   * @param {string} old_path - The current path of the file or directory
   * @param {string} new_path - The new path for the file or directory
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async rename(old_path, new_path) {
    if (!old_path.startsWith(this.fs_path)) old_path = this.fs_path + "/" + old_path;
    if (!new_path.startsWith(this.fs_path)) new_path = this.fs_path + "/" + new_path;
    return await this.obsidian_adapter.rename(old_path, new_path);
  }
  /**
   * Remove a file
   * 
   * @param {string} rel_path - The relative path of the file to remove
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async remove(rel_path) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    try {
      return await this.obsidian_adapter.remove(rel_path);
    } catch (error) {
      console.warn(`Error removing file: ${rel_path}`, error);
    }
  }
  /**
   * Remove a directory
   * 
   * @param {string} rel_path - The relative path of the directory to remove
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async remove_dir(rel_path, recursive = false) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    return await this.obsidian_adapter.rmdir(rel_path, recursive);
  }
  /**
   * Get file or directory information
   * 
   * @param {string} rel_path - The relative path of the file or directory
   * @returns {Promise<Object>} An object containing file or directory information
   */
  async stat(rel_path) {
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    return await this.obsidian_adapter.stat(rel_path);
  }
  /**
   * Write content to a file
   * 
   * @param {string} rel_path - The relative path of the file to write to
   * @param {string} data - The content to write
   * @returns {Promise<void>} A promise that resolves when the operation is complete
   */
  async write(rel_path, data) {
    if (!data) data = "";
    if (!rel_path.startsWith(this.fs_path)) rel_path = this.fs_path + "/" + rel_path;
    const folder_path = rel_path.split("/").slice(0, -1).join("/");
    if (!await this.exists(folder_path)) {
      await this.mkdir(folder_path);
      console.log(`Created folder: ${folder_path}`);
    }
    return await this.obsidian_adapter.write(rel_path, data);
  }
  get_link_target_path(link_path, file_path) {
    return this.obsidian_app.metadataCache.getFirstLinkpathDest(link_path, file_path)?.path;
  }
  get_base_path() {
    return this.obsidian_adapter.basePath;
  }
  get_full_path(rel_path = "") {
    const sep = rel_path.includes("/") ? "/" : "\\";
    return this.get_base_path() + sep + rel_path;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-view/utils/empty.js
function empty(elm) {
  const range = document.createRange();
  range.selectNodeContents(elm);
  range.deleteContents();
}

// node_modules/obsidian-smart-env/node_modules/smart-view/utils/replace_html.js
var replace_html = /* @__PURE__ */ (() => {
  const cache = /* @__PURE__ */ new Map();
  return (container, html_snippet) => {
    const key = html_snippet.trim();
    let tpl = cache.get(key);
    if (!tpl) {
      tpl = document.createElement("template");
      tpl.innerHTML = key;
      cache.set(key, tpl);
    }
    container.replaceChildren(tpl.content.cloneNode(true));
  };
})();

// node_modules/obsidian-smart-env/node_modules/smart-view/utils/replace_with_fragment.js
var replace_with_fragment = (container, html_snippet) => {
  const range = document.createRange();
  const frag = range.createContextualFragment(html_snippet.trim());
  container.replaceChildren(frag);
};

// node_modules/obsidian-smart-env/node_modules/smart-view/utils/safe_inner_html.js
var restricted_re = /<(td|th|tr|thead|tbody|tfoot|caption|col|colgroup|option|optgroup|li|dt|dd|source|track)\b/i;
var safe_inner_html = (container, html_snippet) => {
  const trimmed = html_snippet.trim();
  (restricted_re.test(trimmed) ? replace_with_fragment : replace_html)(container, trimmed);
};

// node_modules/obsidian-smart-env/node_modules/smart-utils/escape_html.js
function escape_html(str = "") {
  return String(str).replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/create_hash.js
function murmur_hash_32(input_string, seed = 0) {
  let remainder = input_string.length & 3;
  let bytes = input_string.length - remainder;
  let h1 = seed;
  let c1 = 3432918353;
  let c2 = 461845907;
  let i = 0;
  let k1 = 0;
  let chunk = 0;
  while (i < bytes) {
    chunk = input_string.charCodeAt(i) & 255 | (input_string.charCodeAt(i + 1) & 255) << 8 | (input_string.charCodeAt(i + 2) & 255) << 16 | (input_string.charCodeAt(i + 3) & 255) << 24;
    i += 4;
    k1 = chunk;
    k1 = multiply_32(k1, c1);
    k1 = rotate_left_32(k1, 15);
    k1 = multiply_32(k1, c2);
    h1 ^= k1;
    h1 = rotate_left_32(h1, 13);
    h1 = h1 * 5 + 3864292196 | 0;
  }
  k1 = 0;
  switch (remainder) {
    case 3:
      k1 ^= (input_string.charCodeAt(i + 2) & 255) << 16;
    // falls through
    case 2:
      k1 ^= (input_string.charCodeAt(i + 1) & 255) << 8;
    // falls through
    case 1:
      k1 ^= input_string.charCodeAt(i) & 255;
      k1 = multiply_32(k1, c1);
      k1 = rotate_left_32(k1, 15);
      k1 = multiply_32(k1, c2);
      h1 ^= k1;
      break;
  }
  h1 ^= input_string.length;
  h1 = fmix_32(h1);
  return h1 | 0;
}
function murmur_hash_32_alphanumeric(input_string, seed = 0) {
  const signed_hash = murmur_hash_32(input_string, seed);
  const unsigned_hash = signed_hash >>> 0;
  return unsigned_hash.toString(36);
}
function multiply_32(a, b) {
  return (a & 65535) * b + ((a >>> 16) * b << 16) | 0;
}
function rotate_left_32(value, shift) {
  return value << shift | value >>> 32 - shift;
}
function fmix_32(h) {
  h ^= h >>> 16;
  h = multiply_32(h, 2246822507);
  h ^= h >>> 13;
  h = multiply_32(h, 3266489909);
  h ^= h >>> 16;
  return h | 0;
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/cos_sim.js
function cos_sim(vector1 = [], vector2 = []) {
  if (vector1.length !== vector2.length) {
    throw new Error("Vectors must have the same length");
  }
  let dot_product = 0;
  let magnitude1 = 0;
  let magnitude2 = 0;
  const epsilon = 1e-8;
  for (let i = 0; i < vector1.length; i++) {
    dot_product += vector1[i] * vector2[i];
    magnitude1 += vector1[i] * vector1[i];
    magnitude2 += vector2[i] * vector2[i];
  }
  magnitude1 = Math.sqrt(magnitude1);
  magnitude2 = Math.sqrt(magnitude2);
  if (magnitude1 < epsilon || magnitude2 < epsilon) return 0;
  return dot_product / (magnitude1 * magnitude2);
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/get_by_path.js
function get_by_path(obj, path, scope = null) {
  if (!path) return "";
  const keys = path.split(".");
  if (scope) {
    keys.unshift(scope);
  }
  const final_key = keys.pop();
  const instance = keys.reduce((acc, key) => acc && acc[key], obj);
  if (instance && typeof instance[final_key] === "function") {
    return instance[final_key].bind(instance);
  }
  return instance ? instance[final_key] : void 0;
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/set_by_path.js
function set_by_path(obj, path, value, scope = null) {
  const keys = path.split(".");
  if (scope) {
    keys.unshift(scope);
  }
  const final_key = keys.pop();
  const target = keys.reduce((acc, key) => {
    if (!acc[key] || typeof acc[key] !== "object") {
      acc[key] = {};
    }
    return acc[key];
  }, obj);
  target[final_key] = value;
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/delete_by_path.js
function delete_by_path(obj, path, scope = null) {
  const keys = path.split(".");
  if (scope) {
    keys.unshift(scope);
  }
  const final_key = keys.pop();
  const instance = keys.reduce((acc, key) => acc && acc[key], obj);
  if (instance) {
    delete instance[final_key];
  }
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/geom.js
function compute_centroid(points) {
  if (!points || points.length === 0) {
    return null;
  }
  const n = points.length;
  const dim = points[0].length;
  const sums = new Float64Array(dim);
  for (let i = 0; i < n; i++) {
    const p = points[i];
    for (let d = 0; d < dim; d++) {
      sums[d] += p[d];
    }
  }
  for (let d = 0; d < dim; d++) {
    sums[d] /= n;
  }
  return Array.from(sums);
}
function compute_medoid(points) {
  if (!points || points.length === 0) {
    return null;
  }
  if (points.length === 1) {
    return points[0];
  }
  const n = points.length;
  const dim = points[0].length;
  const sum_of_distances = new Float64Array(n);
  for (let i = 0; i < n - 1; i++) {
    const p_i = points[i];
    for (let j = i + 1; j < n; j++) {
      const p_j = points[j];
      let dist_sq = 0;
      for (let d = 0; d < dim; d++) {
        const diff = p_i[d] - p_j[d];
        dist_sq += diff * diff;
      }
      const dist = Math.sqrt(dist_sq);
      sum_of_distances[i] += dist;
      sum_of_distances[j] += dist;
    }
  }
  let min_index = 0;
  let min_sum = sum_of_distances[0];
  for (let i = 1; i < n; i++) {
    if (sum_of_distances[i] < min_sum) {
      min_sum = sum_of_distances[i];
      min_index = i;
    }
  }
  return points[min_index];
}

// node_modules/obsidian-smart-env/node_modules/smart-view/smart_view.js
var SmartView = class {
  /**
   * @constructor
   * @param {object} opts - Additional options or overrides for rendering.
   */
  constructor(opts = {}) {
    this.opts = opts;
    this._adapter = null;
  }
  /**
   * Renders all setting components within a container.
   * @async
   * @param {HTMLElement} container - The container element.
   * @param {Object} opts - Additional options for rendering.
   * @returns {Promise<void>}
   */
  async render_setting_components(container, opts = {}) {
    const components = container.querySelectorAll(".setting-component");
    const promises = [];
    for (const component of components) {
      promises.push(this.render_setting_component(component, opts));
    }
    await Promise.all(promises);
    return container;
  }
  /**
   * Creates a document fragment from HTML string.
   * @param {string} html - The HTML string.
   * @returns {DocumentFragment}
   */
  create_doc_fragment(html) {
    return document.createRange().createContextualFragment(html);
  }
  /**
   * Gets the adapter instance used for rendering (e.g., Obsidian or Node, etc.).
   * @returns {Object} The adapter instance.
   */
  get adapter() {
    if (!this._adapter) {
      if (!this.opts.adapter) {
        throw new Error("No adapter provided to SmartView. Provide a 'smart_view.adapter' in env config.");
      }
      const AdapterClass = this.opts.adapter;
      this._adapter = new AdapterClass(this);
    }
    return this._adapter;
  }
  /**
   * Gets an icon (implemented in the adapter).
   * @param {string} icon_name - Name of the icon to get.
   * @returns {string} The icon HTML string.
   */
  get_icon_html(icon_name) {
    return this.adapter.get_icon_html(icon_name);
  }
  /**
   * Renders a single setting component (implemented in adapter).
   * @async
   * @param {HTMLElement} setting_elm - The DOM element for the setting.
   * @param {Object} opts - Additional options for rendering.
   * @returns {Promise<*>}
   */
  async render_setting_component(setting_elm, opts = {}) {
    return await this.adapter.render_setting_component(setting_elm, opts);
  }
  /**
   * Renders markdown content (implemented in adapter).
   * @param {string} markdown - The markdown content.
   * @param {object|null} scope - The scope to pass for rendering.
   * @returns {Promise<DocumentFragment>}
   */
  async render_markdown(markdown, scope = null) {
    return await this.adapter.render_markdown(markdown, scope);
  }
  /**
   * Gets a value from an object by path.
   * @param {Object} obj - The object to search in.
   * @param {string} path - The path to the value.
   * @returns {*}
   */
  get_by_path(obj, path, settings_scope = null) {
    return get_by_path(obj, path, settings_scope);
  }
  /**
   * Sets a value in an object by path.
   * @param {Object} obj - The object to modify.
   * @param {string} path - The path to set the value.
   * @param {*} value - The value to set.
   */
  set_by_path(obj, path, value, settings_scope = null) {
    set_by_path(obj, path, value, settings_scope);
  }
  /**
   * Deletes a value from an object by path.
   * @param {Object} obj - The object to modify.
   * @param {string} path - The path to delete.
   */
  delete_by_path(obj, path, settings_scope = null) {
    delete_by_path(obj, path, settings_scope);
  }
  /**
   * Escapes HTML special characters in a string.
   * @param {string} str - The string to escape.
   * @returns {string} The escaped string.
   */
  escape_html(str) {
    return escape_html(str);
  }
  /**
   * A convenience method to build a setting HTML snippet from a config object.
   * @param {Object} setting_config
   * @returns {string}
   */
  render_setting_html(setting_config) {
    if (setting_config.type === "html") {
      return setting_config.value;
    }
    const attributes = Object.entries(setting_config).map(([attr, value]) => {
      if (attr.includes("class")) return "";
      if (typeof value === "number") return `data-${attr.replace(/_/g, "-")}=${value}`;
      return `data-${attr.replace(/_/g, "-")}="${value}"`;
    }).join("\n");
    return `<div class="setting-component${setting_config.scope_class ? " " + setting_config.scope_class : ""}"
data-setting="${setting_config.setting}"
${attributes}
></div>`;
  }
  /**
   * Renders settings from a config, returning a fragment.
   * @async
   * @param {Object} settings_config
   * @param {Object} opts
   * @returns {Promise<DocumentFragment>}
   */
  async render_settings(settings_config5, opts = {}) {
    const html = Object.entries(settings_config5).map(([setting_key, setting_config]) => {
      if (!setting_config.setting) {
        setting_config.setting = setting_key;
      }
      return this.render_setting_html(setting_config);
    }).join("\n");
    const frag = this.create_doc_fragment(`<div>${html}</div>`);
    return await this.render_setting_components(frag, opts);
  }
  /**
   * @function add_settings_listeners
   * @description
   * Scans the given container for elements that have `data-smart-setting` and attaches
   * a 'change' event listener. On change, it updates the corresponding path in `scope.settings`.
   * 
   * @param {Object} scope - An object containing a `settings` property, where new values will be stored.
   * @param {HTMLElement} [container=document] - The DOM element to scan. Defaults to the entire document.
   */
  add_settings_listeners(scope, container = document) {
    const elements = container.querySelectorAll("[data-smart-setting]");
    elements.forEach((elm) => {
      const path = elm.dataset.smartSetting;
      if (!path) return;
      if (!elm.dataset.listenerAttached) {
        elm.dataset.listenerAttached = "true";
        elm.addEventListener("change", () => {
          let newValue;
          if (elm instanceof HTMLInputElement) {
            if (elm.type === "checkbox") {
              newValue = elm.checked;
            } else if (elm.type === "radio") {
              if (elm.checked) {
                newValue = elm.value;
              } else {
                return;
              }
            } else {
              newValue = elm.value;
            }
          } else if (elm instanceof HTMLSelectElement || elm instanceof HTMLTextAreaElement) {
            newValue = elm.value;
          } else {
            newValue = elm.value ?? elm.textContent;
          }
          this.set_by_path(scope.settings, path, newValue);
        });
      }
    });
  }
  apply_style_sheet(sheet) {
    if ("adoptedStyleSheets" in Document.prototype) {
      document.adoptedStyleSheets = [...document.adoptedStyleSheets, sheet];
    } else {
      const styleEl = document.createElement("style");
      if (sheet.cssRules) {
        styleEl.textContent = Array.from(sheet.cssRules).map((rule) => rule.cssText).join("\n");
      }
      document.head.appendChild(styleEl);
    }
  }
  empty(elm) {
    empty(elm);
  }
  safe_inner_html(elm, html) {
    safe_inner_html(elm, html);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-view/adapters/_adapter.js
var SmartViewAdapter = class {
  constructor(main) {
    this.main = main;
  }
  // NECESSARY OVERRIDES
  /**
   * Retrieves the class used for settings.
   * Must be overridden by subclasses to return the appropriate setting class.
   * @abstract
   * @returns {Function} The setting class constructor.
   * @throws Will throw an error if not implemented in the subclass.
   */
  get setting_class() {
    throw new Error("setting_class() not implemented");
  }
  /**
   * Generates the HTML for a specified icon.
   * Must be overridden by subclasses to provide the correct icon HTML.
   * @abstract
   * @param {string} icon_name - The name of the icon to generate HTML for.
   * @returns {string} The HTML string representing the icon.
   * @throws Will throw an error if not implemented in the subclass.
   */
  get_icon_html(icon_name) {
    throw new Error("get_icon_html() not implemented");
  }
  /**
   * Renders Markdown content within a specific scope.
   * Must be overridden by subclasses to handle Markdown rendering appropriately.
   * @abstract
   * @param {string} markdown - The Markdown content to render.
   * @param {object|null} [scope=null] - The scope within which to render the Markdown.
   * @returns {Promise<void>} A promise that resolves when rendering is complete.
   * @throws Will throw an error if not implemented in the subclass.
   */
  async render_markdown(markdown, scope = null) {
    throw new Error("render_markdown() not implemented");
  }
  /**
   * Opens a specified URL.
   * Should be overridden by subclasses to define how URLs are opened.
   * @abstract
   * @param {string} url - The URL to open.
   */
  open_url(url) {
    throw new Error("open_url() not implemented");
  }
  /**
   * Handles the selection of a folder by invoking the folder selection dialog and updating the setting.
   * @abstract
   * @param {string} setting - The path of the setting being modified.
   * @param {string} value - The current value of the setting.
   * @param {HTMLElement} elm - The HTML element associated with the setting.
   * @param {object} scope - The current scope containing settings and actions.
   */
  handle_folder_select(path, value, elm, scope) {
    throw new Error("handle_folder_select not implemented");
  }
  /**
   * Handles the selection of a file by invoking the file selection dialog and updating the setting.
   * @abstract
   * @param {string} setting - The path of the setting being modified.
   * @param {string} value - The current value of the setting.
   * @param {HTMLElement} elm - The HTML element associated with the setting.
   * @param {object} scope - The current scope containing settings and actions.
   */
  handle_file_select(path, value, elm, scope) {
    throw new Error("handle_file_select not implemented");
  }
  /**
   * Performs actions before a setting is changed, such as clearing notices and updating the UI.
   * @abstract
   * @param {string} setting - The path of the setting being changed.
   * @param {*} value - The new value for the setting.
   * @param {HTMLElement} elm - The HTML element associated with the setting.
   * @param {object} scope - The current scope containing settings and actions.
   */
  pre_change(path, value, elm) {
  }
  /**
   * Performs actions after a setting is changed, such as updating UI elements.
   * @abstract
   * @param {string} setting - The path of the setting that was changed.
   * @param {*} value - The new value for the setting.
   * @param {HTMLElement} elm - The HTML element associated with the setting.
   * @param {object} changed - Additional information about the change.
   */
  post_change(path, value, elm) {
  }
  /**
   * Reverts a setting to its previous value in case of validation failure or error.
   * @abstract
   * @param {string} setting - The path of the setting to revert.
   * @param {HTMLElement} elm - The HTML element associated with the setting.
   * @param {object} scope - The current scope containing settings.
   */
  revert_setting(path, elm, scope) {
    console.warn("revert_setting() not implemented");
  }
  // DEFAULT IMPLEMENTATIONS (may be overridden)
  get setting_renderers() {
    return {
      text: this.render_text_component,
      string: this.render_text_component,
      password: this.render_password_component,
      number: this.render_number_component,
      dropdown: this.render_dropdown_component,
      toggle: this.render_toggle_component,
      textarea: this.render_textarea_component,
      textarea_array: this.render_textarea_array_component,
      button: this.render_button_component,
      remove: this.render_remove_component,
      folder: this.render_folder_select_component,
      "text-file": this.render_file_select_component,
      file: this.render_file_select_component,
      slider: this.render_slider_component,
      html: this.render_html_component,
      button_with_confirm: this.render_button_with_confirm_component,
      json: this.render_json_component,
      array: this.render_array_component
    };
  }
  async render_setting_component(elm, opts = {}) {
    this.empty(elm);
    const path = elm.dataset.setting;
    const scope = opts.scope || this.main.main;
    const settings_scope = opts.settings_scope || null;
    try {
      let value = elm.dataset.value ?? this.main.get_by_path(scope.settings, path, settings_scope);
      if (typeof value === "undefined" && typeof elm.dataset.default !== "undefined") {
        value = elm.dataset.default;
        if (typeof value === "string") value = value.toLowerCase() === "true" ? true : value === "false" ? false : value;
        this.main.set_by_path(scope.settings, path, value, settings_scope);
      }
      const renderer = this.setting_renderers[elm.dataset.type];
      if (!renderer) {
        console.warn(`Unsupported setting type: ${elm.dataset.type}`);
        return elm;
      }
      const setting = renderer.call(this, elm, path, value, scope, settings_scope);
      if (elm.dataset.name) setting.setName(elm.dataset.name);
      if (elm.dataset.description) {
        const frag = this.main.create_doc_fragment(`<span>${elm.dataset.description}</span>`);
        setting.setDesc(frag);
      }
      if (elm.dataset.tooltip) setting.setTooltip(elm.dataset.tooltip);
      this.add_button_if_needed(setting, elm, path, scope);
      this.handle_disabled_and_hidden(elm);
      return elm;
    } catch (e) {
      console.error(JSON.stringify({ path, elm }, null, 2));
      console.error(JSON.stringify(e, null, 2));
    }
  }
  render_dropdown_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    let options;
    if (elm.dataset.optionsCallback) {
      console.log(`getting options callback: ${elm.dataset.optionsCallback}`);
      const opts_callback = this.main.get_by_path(scope, elm.dataset.optionsCallback);
      if (typeof opts_callback === "function") options = opts_callback();
      else console.warn(`optionsCallback is not a function: ${elm.dataset.optionsCallback}`, scope);
    }
    if (!options || !options.length) {
      options = this.get_dropdown_options(elm);
    }
    smart_setting.addDropdown((dropdown) => {
      if (elm.dataset.required) dropdown.inputEl.setAttribute("required", true);
      options.forEach((option) => {
        const opt = dropdown.addOption(option.value, option.name ?? option.value);
        opt.selected = option.value === value;
      });
      dropdown.onChange((value2) => {
        this.handle_on_change(path, value2, elm, scope, settings_scope);
      });
      dropdown.setValue(value);
    });
    return smart_setting;
  }
  render_text_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addText((text) => {
      text.setPlaceholder(elm.dataset.placeholder || "");
      if (value) text.setValue(value);
      let debounceTimer;
      if (elm.dataset.button) {
        smart_setting.addButton((button) => {
          button.setButtonText(elm.dataset.button);
          button.onClick(async () => this.handle_on_change(path, text.getValue(), elm, scope));
        });
      } else {
        text.onChange(async (value2) => {
          clearTimeout(debounceTimer);
          debounceTimer = setTimeout(() => this.handle_on_change(path, value2.trim(), elm, scope, settings_scope), 2e3);
        });
      }
    });
    return smart_setting;
  }
  render_password_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addText((text) => {
      text.inputEl.type = "password";
      text.setPlaceholder(elm.dataset.placeholder || "");
      if (value) text.setValue(value);
      let debounceTimer;
      text.onChange(async (value2) => {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => this.handle_on_change(path, value2, elm, scope, settings_scope), 2e3);
      });
    });
    return smart_setting;
  }
  render_number_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addText((number) => {
      number.inputEl.type = "number";
      number.setPlaceholder(elm.dataset.placeholder || "");
      if (typeof value !== "undefined") number.inputEl.value = parseInt(value);
      number.inputEl.min = elm.dataset.min || 0;
      if (elm.dataset.max) number.inputEl.max = elm.dataset.max;
      let debounceTimer;
      number.onChange(async (value2) => {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => this.handle_on_change(path, parseInt(value2), elm, scope, settings_scope), 2e3);
      });
    });
    return smart_setting;
  }
  render_toggle_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addToggle((toggle) => {
      let checkbox_val = value ?? false;
      if (typeof checkbox_val === "string") {
        checkbox_val = checkbox_val.toLowerCase() === "true";
      }
      toggle.setValue(checkbox_val);
      toggle.onChange(async (value2) => this.handle_on_change(path, value2, elm, scope, settings_scope));
    });
    return smart_setting;
  }
  render_textarea_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addTextArea((textarea) => {
      textarea.setPlaceholder(elm.dataset.placeholder || "");
      textarea.setValue(value || "");
      let debounceTimer;
      textarea.onChange(async (value2) => {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => this.handle_on_change(path, value2, elm, scope, settings_scope), 2e3);
      });
    });
    return smart_setting;
  }
  render_textarea_array_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addTextArea((textarea) => {
      textarea.setPlaceholder(elm.dataset.placeholder || "");
      textarea.setValue(Array.isArray(value) ? value.join("\n") : value || "");
      let debounceTimer;
      textarea.onChange(async (value2) => {
        value2 = value2.split("\n").map((v) => v.trim()).filter((v) => v);
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => this.handle_on_change(path, value2, elm, scope, settings_scope), 2e3);
      });
    });
    return smart_setting;
  }
  render_button_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addButton((button) => {
      button.setButtonText(elm.dataset.btnText || elm.dataset.name);
      button.onClick(async () => {
        if (elm.dataset.confirm && !confirm(elm.dataset.confirm)) return;
        if (elm.dataset.href) this.open_url(elm.dataset.href);
        if (elm.dataset.callback) {
          const callback = this.main.get_by_path(scope, elm.dataset.callback);
          if (callback) callback(path, value, elm, scope, settings_scope);
        }
      });
    });
    return smart_setting;
  }
  render_remove_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addButton((button) => {
      button.setButtonText(elm.dataset.btnText || elm.dataset.name || "Remove");
      button.onClick(async () => {
        this.main.delete_by_path(scope.settings, path, settings_scope);
        if (elm.dataset.callback) {
          const callback = this.main.get_by_path(scope, elm.dataset.callback);
          if (callback) callback(path, value, elm, scope, settings_scope);
        }
      });
    });
    return smart_setting;
  }
  render_folder_select_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addFolderSelect((folder_select) => {
      folder_select.setPlaceholder(elm.dataset.placeholder || "");
      if (value) folder_select.setValue(value);
      folder_select.inputEl.closest("div").addEventListener("click", () => {
        this.handle_folder_select(path, value, elm, scope);
      });
      folder_select.inputEl.querySelector("input").addEventListener("change", (e) => {
        const folder = e.target.value;
        this.handle_on_change(path, folder, elm, scope, settings_scope);
      });
    });
    return smart_setting;
  }
  render_file_select_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addFileSelect((file_select) => {
      file_select.setPlaceholder(elm.dataset.placeholder || "");
      if (value) file_select.setValue(value);
      file_select.inputEl.closest("div").addEventListener("click", () => {
        this.handle_file_select(path, value, elm, scope, settings_scope);
      });
    });
    return smart_setting;
  }
  render_slider_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addSlider((slider) => {
      const min = parseFloat(elm.dataset.min) || 0;
      const max = parseFloat(elm.dataset.max) || 100;
      const step = parseFloat(elm.dataset.step) || 1;
      const currentValue = typeof value !== "undefined" ? parseFloat(value) : min;
      slider.setLimits(min, max, step);
      slider.setValue(currentValue);
      slider.onChange((newVal) => {
        const numericVal = parseFloat(newVal);
        this.handle_on_change(path, numericVal, elm, scope, settings_scope);
      });
    });
    return smart_setting;
  }
  render_html_component(elm, path, value, scope) {
    this.safe_inner_html(elm, value);
    return elm;
  }
  /**
   * Renders an array setting component for managing a list of strings.
   * @param {HTMLElement} elm - Container element for the setting.
   * @param {string} path - Dot-notation path to store the array.
   * @param {Array<string>} value - Initial array value.
   * @param {object} scope - Scope containing settings and actions.
   * @param {object|null} settings_scope - Optional nested settings scope.
   * @returns {object} smart_setting instance.
   */
  render_array_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    let arr = Array.isArray(value) ? [...value] : [];
    const items_container = document.createElement("div");
    items_container.className = "array-items-container";
    const render_items = () => {
      items_container.innerHTML = "";
      arr.forEach((val, idx) => {
        const row = document.createElement("div");
        row.className = "array-item-row";
        const input = document.createElement("input");
        input.type = "text";
        input.value = val;
        input.placeholder = "Value";
        const remove_btn = document.createElement("button");
        remove_btn.textContent = "\u2715";
        remove_btn.title = "Remove";
        input.addEventListener("change", () => {
          arr[idx] = input.value;
          trigger_change();
        });
        remove_btn.addEventListener("click", () => {
          arr.splice(idx, 1);
          render_items();
          trigger_change();
        });
        row.appendChild(input);
        row.appendChild(remove_btn);
        items_container.appendChild(row);
      });
    };
    const add_row = document.createElement("div");
    add_row.className = "array-add-row";
    const new_input = document.createElement("input");
    new_input.type = "text";
    new_input.placeholder = "Value";
    const add_btn = document.createElement("button");
    add_btn.textContent = "+";
    add_btn.title = "Add value";
    add_btn.addEventListener("click", () => {
      const v = new_input.value.trim();
      if (!v) return;
      arr.push(v);
      new_input.value = "";
      render_items();
      trigger_change();
    });
    add_row.appendChild(new_input);
    add_row.appendChild(add_btn);
    smart_setting.controlEl.appendChild(items_container);
    smart_setting.controlEl.appendChild(add_row);
    const trigger_change = () => {
      this.handle_on_change(path, [...arr], elm, scope, settings_scope);
    };
    render_items();
    elm.appendChild(smart_setting.settingEl);
    return smart_setting;
  }
  render_json_component(elm, path, value, scope, settings_scope) {
    try {
      const smart_setting = new this.setting_class(elm);
      let obj = typeof value === "object" && value !== null ? { ...value } : {};
      const pairs_container = document.createElement("div");
      pairs_container.className = "json-pairs-container";
      const renderPairs = () => {
        pairs_container.innerHTML = "";
        Object.entries(obj).forEach(([key, val], idx) => {
          const pair_div = document.createElement("div");
          pair_div.className = "json-pair-row";
          const key_i = document.createElement("input");
          key_i.type = "text";
          key_i.value = key;
          key_i.placeholder = "Property";
          const value_i = document.createElement("input");
          value_i.type = "text";
          value_i.value = val;
          value_i.placeholder = "Value";
          const remove_btn = document.createElement("button");
          remove_btn.textContent = "\u2715";
          remove_btn.title = "Remove";
          key_i.addEventListener("change", () => {
            const newKey = key_i.value.trim();
            if (!newKey) return;
            if (newKey !== key) {
              obj[newKey] = obj[key];
              delete obj[key];
              renderPairs();
              triggerChange();
            }
          });
          value_i.addEventListener("change", () => {
            obj[key_i.value] = value_i.value;
            triggerChange();
          });
          remove_btn.addEventListener("click", () => {
            delete obj[key_i.value];
            renderPairs();
            triggerChange();
          });
          pair_div.appendChild(key_i);
          pair_div.appendChild(value_i);
          pair_div.appendChild(remove_btn);
          pairs_container.appendChild(pair_div);
        });
      };
      const add_div = document.createElement("div");
      add_div.className = "json-add-row";
      const new_key_i = document.createElement("input");
      new_key_i.type = "text";
      new_key_i.placeholder = "Property";
      const new_val_i = document.createElement("input");
      new_val_i.type = "text";
      new_val_i.placeholder = "Value";
      const add_btn = document.createElement("button");
      add_btn.textContent = "+";
      add_btn.title = "Add property";
      add_btn.addEventListener("click", () => {
        const k = new_key_i.value.trim();
        if (!k || k in obj) return;
        obj[k] = new_val_i.value;
        new_key_i.value = "";
        new_val_i.value = "";
        renderPairs();
        triggerChange();
      });
      add_div.appendChild(new_key_i);
      add_div.appendChild(new_val_i);
      add_div.appendChild(add_btn);
      smart_setting.controlEl.appendChild(pairs_container);
      smart_setting.controlEl.appendChild(add_div);
      const triggerChange = () => {
        this.handle_on_change(path, { ...obj }, elm, scope, settings_scope);
      };
      renderPairs();
      elm.appendChild(smart_setting.settingEl);
      return smart_setting;
    } catch (e) {
      console.error(e);
    }
  }
  add_button_if_needed(smart_setting, elm, path, scope) {
    if (elm.dataset.btn) {
      smart_setting.addButton((button) => {
        button.setButtonText(elm.dataset.btn);
        button.inputEl.addEventListener("click", (e) => {
          if (elm.dataset.btnCallback && typeof scope[elm.dataset.btnCallback] === "function") {
            if (elm.dataset.btnCallbackArg) scope[elm.dataset.btnCallback](elm.dataset.btnCallbackArg);
            else scope[elm.dataset.btnCallback](path, null, smart_setting, scope);
          } else if (elm.dataset.btnHref) {
            this.open_url(elm.dataset.btnHref);
          } else if (elm.dataset.callback && typeof this.main.get_by_path(scope, elm.dataset.callback) === "function") {
            this.main.get_by_path(scope, elm.dataset.callback)(path, null, smart_setting, scope);
          } else if (elm.dataset.href) {
            this.open_url(elm.dataset.href);
          } else {
            console.error("No callback or href found for button.");
          }
        });
        if (elm.dataset.btnDisabled || elm.dataset.disabled && elm.dataset.btnDisabled !== "false") {
          button.inputEl.disabled = true;
        }
      });
    }
  }
  handle_disabled_and_hidden(elm) {
    if (elm.dataset.disabled && elm.dataset.disabled !== "false") {
      elm.classList.add("disabled");
      elm.querySelector("input, select, textarea, button").disabled = true;
    }
    if (elm.dataset.hidden && elm.dataset.hidden !== "false") {
      elm.style.display = "none";
    }
  }
  get_dropdown_options(elm) {
    return Object.entries(elm.dataset).reduce((acc, [k, v]) => {
      if (!k.startsWith("option")) return acc;
      const [value, name] = v.split("|");
      acc.push({ value, name: name || value });
      return acc;
    }, []);
  }
  handle_on_change(path, value, elm, scope, settings_scope) {
    this.pre_change(path, value, elm, scope);
    if (elm.dataset.validate) {
      const valid = this[elm.dataset.validate](path, value, elm, scope);
      if (!valid) {
        elm.querySelector(".setting-item").style.border = "2px solid red";
        this.revert_setting(path, elm, scope);
        return;
      }
    }
    this.main.set_by_path(scope.settings, path, value, settings_scope);
    if (elm.dataset.callback) {
      const callback = this.main.get_by_path(scope, elm.dataset.callback);
      if (callback) callback(path, value, elm, scope);
    }
    this.post_change(path, value, elm, scope);
  }
  render_button_with_confirm_component(elm, path, value, scope) {
    const smart_setting = new this.setting_class(elm);
    smart_setting.addButton((button) => {
      button.setButtonText(elm.dataset.btnText || elm.dataset.name);
      elm.appendChild(this.main.create_doc_fragment(`
        <div class="sc-inline-confirm-row" style="
          display: none;
        ">
          <span style="margin-right: 10px;">
            ${elm.dataset.confirm || "Are you sure?"}
          </span>
          <span class="sc-inline-confirm-row-buttons">
            <button class="sc-inline-confirm-yes">Yes</button>
            <button class="sc-inline-confirm-cancel">Cancel</button>
          </span>
        </div>
      `));
      const confirm_row = elm.querySelector(".sc-inline-confirm-row");
      const confirm_yes = confirm_row.querySelector(".sc-inline-confirm-yes");
      const confirm_cancel = confirm_row.querySelector(".sc-inline-confirm-cancel");
      button.onClick(async () => {
        confirm_row.style.display = "block";
        elm.querySelector(".setting-item").style.display = "none";
      });
      confirm_yes.addEventListener("click", async () => {
        if (elm.dataset.href) this.open_url(elm.dataset.href);
        if (elm.dataset.callback) {
          const callback = this.main.get_by_path(scope, elm.dataset.callback);
          if (callback) callback(path, value, elm, scope);
        }
        elm.querySelector(".setting-item").style.display = "block";
        confirm_row.style.display = "none";
      });
      confirm_cancel.addEventListener("click", () => {
        confirm_row.style.display = "none";
        elm.querySelector(".setting-item").style.display = "block";
      });
    });
    return smart_setting;
  }
  empty(elm) {
    empty(elm);
  }
  safe_inner_html(elm, html) {
    safe_inner_html(elm, html);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-view/adapters/obsidian.js
var import_obsidian = require("obsidian");
var SmartViewObsidianAdapter = class extends SmartViewAdapter {
  get setting_class() {
    return import_obsidian.Setting;
  }
  open_url(url) {
    window.open(url);
  }
  async render_file_select_component(elm, path, value) {
    return super.render_text_component(elm, path, value);
  }
  async render_markdown(markdown, scope) {
    const component = scope.env.smart_connections_plugin?.connections_view || new import_obsidian.Component();
    if (!scope) return console.warn("Scope required for rendering markdown in Obsidian adapter");
    const frag = this.main.create_doc_fragment("<div><div class='inner'></div></div>");
    const container = frag.querySelector(".inner");
    try {
      await import_obsidian.MarkdownRenderer.render(
        scope.env.plugin.app,
        markdown,
        container,
        scope?.file_path || "",
        component
      );
    } catch (e) {
      console.warn("Error rendering markdown in Obsidian adapter", e);
    }
    return frag;
  }
  get_icon_html(name) {
    return (0, import_obsidian.getIcon)(name).outerHTML;
  }
  // Obsidian Specific
  is_mod_event(event) {
    return import_obsidian.Keymap.isModEvent(event);
  }
  render_folder_select_component(elm, path, value, scope, settings_scope) {
    const smart_setting = new this.setting_class(elm);
    const folders = scope.env.plugin.app.vault.getAllFolders().sort((a, b) => a.path.localeCompare(b.path));
    smart_setting.addDropdown((dropdown) => {
      if (elm.dataset.required) dropdown.inputEl.setAttribute("required", true);
      dropdown.addOption("", "No folder selected");
      folders.forEach((folder) => {
        dropdown.addOption(folder.path, folder.path);
      });
      dropdown.onChange((value2) => {
        this.handle_on_change(path, value2, elm, scope, settings_scope);
      });
      dropdown.setValue(value);
    });
    return smart_setting;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-collections/utils/collection_instance_name_from.js
function collection_instance_name_from(class_name) {
  if (class_name.endsWith("Item")) {
    return class_name.replace(/Item$/, "").toLowerCase();
  }
  return class_name.replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase().replace(/y$/, "ie") + "s";
}

// node_modules/obsidian-smart-env/node_modules/smart-collections/utils/helpers.js
function create_uid(data) {
  const str = JSON.stringify(data);
  let hash = 0;
  if (str.length === 0) return hash;
  for (let i = 0; i < str.length; i++) {
    const char = str.charCodeAt(i);
    hash = (hash << 5) - hash + char;
    hash = hash & hash;
    if (hash < 0) hash = hash * -1;
  }
  return hash.toString() + str.length;
}

// node_modules/obsidian-smart-env/node_modules/smart-collections/utils/deep_equal.js
function deep_equal(obj1, obj2, visited = /* @__PURE__ */ new WeakMap()) {
  if (obj1 === obj2) return true;
  if (obj1 === null || obj2 === null || obj1 === void 0 || obj2 === void 0) return false;
  if (typeof obj1 !== typeof obj2 || Array.isArray(obj1) !== Array.isArray(obj2)) return false;
  if (Array.isArray(obj1)) {
    if (obj1.length !== obj2.length) return false;
    return obj1.every((item, index) => deep_equal(item, obj2[index], visited));
  }
  if (typeof obj1 === "object") {
    if (visited.has(obj1)) return visited.get(obj1) === obj2;
    visited.set(obj1, obj2);
    const keys1 = Object.keys(obj1);
    const keys2 = Object.keys(obj2);
    if (keys1.length !== keys2.length) return false;
    return keys1.every((key) => deep_equal(obj1[key], obj2[key], visited));
  }
  return obj1 === obj2;
}

// node_modules/obsidian-smart-env/node_modules/smart-collections/utils/get_item_display_name.js
function get_item_display_name(key, show_full_path) {
  if (show_full_path) {
    return key.split("/").join(" > ").replace(".md", "");
  }
  return key.split("/").pop().replace(".md", "");
}

// node_modules/obsidian-smart-env/node_modules/smart-collections/utils/compare.js
function compare(item, to_item, params = {}) {
  const {
    algo = (a, b) => ({ is_equal: a === b })
  } = params;
  if (typeof algo !== "function") return { item, error: "Invalid comparison function" };
  return {
    item,
    ...algo(item, to_item) || { error: "Comparison function did not return a result" }
  };
}

// node_modules/obsidian-smart-env/node_modules/smart-collections/item.js
var CollectionItem = class _CollectionItem {
  /**
   * Default properties for an instance of CollectionItem.
   * Override in subclasses to define different defaults.
   * @returns {Object}
   */
  static get defaults() {
    return {
      data: {}
    };
  }
  /**
   * @param {Object} env - The environment/context.
   * @param {Object|null} [data=null] - Initial data for the item.
   */
  constructor(env, data = null) {
    env.create_env_getter(this);
    this.config = this.env?.config;
    this.merge_defaults();
    if (data) deep_merge(this.data, data);
    if (!this.data.class_name) this.data.class_name = this.collection.item_class_name;
  }
  /**
   * Loads an item from data and initializes it.
   * @param {Object} env
   * @param {Object} data
   * @returns {CollectionItem}
   */
  static load(env, data) {
    const item = new this(env, data);
    item.init();
    return item;
  }
  /**
   * Merge default properties from the entire inheritance chain.
   * @private
   */
  merge_defaults() {
    let current_class = this.constructor;
    while (current_class) {
      for (let key in current_class.defaults) {
        const default_val = current_class.defaults[key];
        if (typeof default_val === "object") {
          this[key] = { ...default_val, ...this[key] };
        } else {
          this[key] = this[key] === void 0 ? default_val : this[key];
        }
      }
      current_class = Object.getPrototypeOf(current_class);
    }
  }
  /**
   * Generates or retrieves a unique key for the item.
   * Key syntax supports:
   * - `[i]` for sequences
   * - `/` for super-sources (groups, directories, clusters)
   * - `#` for sub-sources (blocks)
   * @returns {string} The unique key
   */
  get_key() {
    return create_uid(this.data);
  }
  /**
   * Updates the item data and returns true if changed.
   * @param {Object} data
   * @returns {boolean} True if data changed.
   */
  update_data(data) {
    const sanitized_data = this.sanitize_data(data);
    const current_data = { ...this.data };
    deep_merge(current_data, sanitized_data);
    const changed = !deep_equal(this.data, current_data);
    if (!changed) return false;
    this.data = current_data;
    return true;
  }
  /**
   * Sanitizes data for saving. Ensures no circular references.
   * @param {*} data
   * @returns {*} Sanitized data.
   */
  sanitize_data(data) {
    if (data instanceof _CollectionItem) return data.ref;
    if (Array.isArray(data)) return data.map((val) => this.sanitize_data(val));
    if (typeof data === "object" && data !== null) {
      return Object.keys(data).reduce((acc, key) => {
        acc[key] = this.sanitize_data(data[key]);
        return acc;
      }, {});
    }
    return data;
  }
  /**
   * Initializes the item. Override as needed.
   * @param {Object} [input_data] - Additional data that might be provided on creation.
   */
  init(input_data) {
  }
  /**
   * Queues this item for saving.
   */
  queue_save() {
    this._queue_save = true;
  }
  /**
   * Saves this item using its data adapter.
   * @returns {Promise<void>}
   */
  async save() {
    try {
      await this.data_adapter.save_item(this);
      this.init();
    } catch (err) {
      this._queue_save = true;
      console.error(err, err.stack);
    }
  }
  /**
   * Queues this item for loading.
   */
  queue_load() {
    this._queue_load = true;
  }
  /**
   * Loads this item using its data adapter.
   * @returns {Promise<void>}
   */
  async load() {
    try {
      await this.data_adapter.load_item(this);
      this.init();
    } catch (err) {
      this._load_error = err;
      this.on_load_error(err);
    }
  }
  /**
   * Handles load errors by re-queuing for load.
   * Override if needed.
   * @param {Error} err
   */
  on_load_error(err) {
    this.queue_load();
  }
  /**
   * Validates the item before saving. Checks for presence and validity of key.
   * @returns {boolean}
   */
  validate_save() {
    if (!this.key) return false;
    if (this.key.trim() === "") return false;
    if (this.key === "undefined") return false;
    return true;
  }
  /**
   * Marks this item as deleted. This does not immediately remove it from memory,
   * but queues a save that will result in the item being removed from persistent storage.
   */
  delete() {
    this.deleted = true;
    this.queue_save();
  }
  /**
   * Filters items in the collection based on provided options.
   * functional filter (returns true or false) for filtering items in collection; called by collection class
   * @param {Object} filter_opts - Filtering options.
   * @param {string} [filter_opts.exclude_key] - A single key to exclude.
   * @param {string[]} [filter_opts.exclude_keys] - An array of keys to exclude. If exclude_key is provided, it's added to this array.
   * @param {string} [filter_opts.exclude_key_starts_with] - Exclude keys starting with this string.
   * @param {string[]} [filter_opts.exclude_key_starts_with_any] - Exclude keys starting with any of these strings.
   * @param {string} [filter_opts.exclude_key_includes] - Exclude keys that include this string.
   * @param {string[]} [filter_opts.exclude_key_includes_any] - Exclude keys that include any of these strings.
   * @param {string} [filter_opts.exclude_key_ends_with] - Exclude keys ending with this string.
   * @param {string[]} [filter_opts.exclude_key_ends_with_any] - Exclude keys ending with any of these strings.
   * @param {string} [filter_opts.key_ends_with] - Include only keys ending with this string.
   * @param {string} [filter_opts.key_starts_with] - Include only keys starting with this string.
   * @param {string[]} [filter_opts.key_starts_with_any] - Include only keys starting with any of these strings.
   * @param {string} [filter_opts.key_includes] - Include only keys that include this string.
   * @returns {boolean} True if the item passes the filter, false otherwise.
   */
  filter(filter_opts = {}) {
    const {
      exclude_key,
      exclude_keys = exclude_key ? [exclude_key] : [],
      exclude_key_starts_with,
      exclude_key_starts_with_any,
      exclude_key_includes,
      exclude_key_includes_any,
      exclude_key_ends_with,
      exclude_key_ends_with_any,
      key_ends_with,
      key_starts_with,
      key_starts_with_any,
      key_includes,
      key_includes_any
    } = filter_opts;
    if (exclude_keys?.includes(this.key)) return false;
    if (exclude_key_starts_with && this.key.startsWith(exclude_key_starts_with)) return false;
    if (exclude_key_starts_with_any && exclude_key_starts_with_any.some((prefix) => this.key.startsWith(prefix))) return false;
    if (exclude_key_includes && this.key.includes(exclude_key_includes)) return false;
    if (exclude_key_includes_any && exclude_key_includes_any.some((include) => this.key.includes(include))) return false;
    if (exclude_key_ends_with && this.key.endsWith(exclude_key_ends_with)) return false;
    if (exclude_key_ends_with_any && exclude_key_ends_with_any.some((suffix) => this.key.endsWith(suffix))) return false;
    if (key_ends_with && !this.key.endsWith(key_ends_with)) return false;
    if (key_starts_with && !this.key.startsWith(key_starts_with)) return false;
    if (key_starts_with_any && !key_starts_with_any.some((prefix) => this.key.startsWith(prefix))) return false;
    if (key_includes && !this.key.includes(key_includes)) return false;
    if (key_includes_any && !key_includes_any.some((include) => this.key.includes(include))) return false;
    return true;
  }
  /**
   * Compares this item with another item using a custom comparison function.
   * @param {Item} to_item - The item to compare with.
   * @param {Object} [params={}] - Additional parameters for the comparison.
   * @returns {Object} An object containing the original item and the comparison results.
   */
  compare(to_item, params = {}) {
    return compare(this, to_item, params);
  }
  /**
   * Parses item data for additional processing. Override as needed.
   * @deprecated is this used anywhere?
   */
  parse() {
  }
  get actions() {
    if (!this._actions) {
      this._actions = Object.entries(this.env.opts.items[this.item_type_key].actions || {}).reduce((acc, [k, v]) => {
        acc[k] = v.bind(this);
        return acc;
      }, {});
    }
    return this._actions;
  }
  /**
   * Derives the collection key from the class name.
   * @returns {string}
   */
  static get collection_key() {
    let name = this.name;
    if (name.match(/\d$/)) name = name.slice(0, -1);
    return collection_instance_name_from(name);
  }
  /**
   * @returns {string} The collection key for this item.
   */
  get collection_key() {
    let name = this.constructor.name;
    if (name.match(/\d$/)) name = name.slice(0, -1);
    return collection_instance_name_from(name);
  }
  /**
   * Retrieves the parent collection from the environment.
   * @returns {Collection}
   */
  get collection() {
    return this.env[this.collection_key];
  }
  /**
   * @returns {string} The item's key.
   */
  get key() {
    return this.data?.key || this.get_key();
  }
  get item_type_key() {
    let name = this.constructor.name;
    if (name.match(/\d$/)) name = name.slice(0, -1);
    return camel_case_to_snake_case(name);
  }
  /**
   * A simple reference object for this item.
   * @returns {{collection_key: string, key: string}}
   */
  get ref() {
    return { collection_key: this.collection_key, key: this.key };
  }
  /**
   * Emits an event with item metadata.
   *
   * @param {string} event_key
   * @param {Object} [payload={}]
   * @returns {void}
   */
  emit_event(event_key, payload = {}) {
    this.env.events?.emit(event_key, { collection_key: this.collection_key, item_key: this.key, ...payload });
  }
  /**
   * @returns {Object} The data adapter for this item's collection.
   */
  get data_adapter() {
    return this.collection.data_adapter;
  }
  /**
   * @returns {Object} The filesystem adapter.
   */
  get data_fs() {
    return this.collection.data_fs;
  }
  /**
   * Access to collection-level settings.
   * @returns {Object}
   */
  get settings() {
    if (!this.env.settings[this.collection_key]) this.env.settings[this.collection_key] = {};
    return this.env.settings[this.collection_key];
  }
  set settings(settings) {
    this.env.settings[this.collection_key] = settings;
    this.env.smart_settings.save();
  }
  /**
   * @deprecated use env.smart_view
   * @returns {Object}
   */
  get smart_view() {
    if (!this._smart_view) this._smart_view = this.env.init_module("smart_view");
    return this._smart_view;
  }
  /**
   * Retrieves the display name of the collection item.
   * @readonly
   * @deprecated Use `get_item_display_name(key, show_full_path)` instead (keep UI logic out of collections).
   * @returns {string} The display name.
   */
  get name() {
    return get_item_display_name(
      this.key,
      this.env.settings.smart_view_filter?.show_full_path
    );
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-collections/collection.js
var AsyncFunction = Object.getPrototypeOf(async function() {
}).constructor;
var Collection = class {
  /**
   * Constructs a new Collection instance.
   *
   * @param {Object} env - The environment context containing configurations and adapters.
   * @param {Object} [opts={}] - Optional configuration.
   * @param {string} [opts.collection_key] - Custom key to override default collection name.
   * @param {string} [opts.data_dir] - Custom data directory path.
   * @param {boolean} [opts.prevent_load_on_init] - Whether to prevent loading items on initialization.
   */
  constructor(env, opts = {}) {
    env.create_env_getter(this);
    this.opts = opts;
    if (opts.collection_key) this.collection_key = opts.collection_key;
    this.env[this.collection_key] = this;
    this.config = this.env.config;
    this.items = {};
    this.loaded = null;
    this._loading = false;
    this.load_time_ms = null;
    this.settings_container = null;
  }
  /**
   * Initializes a new collection in the environment. Override in subclass if needed.
   *
   * @param {Object} env
   * @param {Object} [opts={}]
   * @returns {Promise<void>}
   */
  static async init(env, opts = {}) {
    env[this.collection_key] = new this(env, opts);
    await env[this.collection_key].init();
    env.collections[this.collection_key] = "init";
  }
  /**
   * The unique collection key derived from the class name.
   * @returns {string}
   */
  static get collection_key() {
    let name = this.name;
    if (name.match(/\d$/)) name = name.slice(0, -1);
    return name.replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase();
  }
  /**
   * Instance-level init. Override in subclasses if necessary.
   * @returns {Promise<void>}
   */
  async init() {
  }
  /**
   * Creates or updates an item in the collection.
   * - If `data` includes a key that matches an existing item, that item is updated.
   * - Otherwise, a new item is created.
   * After updating or creating, the item is validated. If validation fails, the item is logged and returned without being saved.
   * If validation succeeds for a new item, it is added to the collection and marked for saving.
   *
   * If the item’s `init()` method is async, a promise is returned that resolves once init completes.
   * 
   * NOTE: wrapping in try/catch seems to fail to catch errors thrown in async init functions when awaiting create_or_update
   *
   * @param {Object} [data={}] - Data for creating/updating an item.
   * @returns {Promise<Item>|Item} The created or updated item. May return a promise if `init()` is async.
   */
  create_or_update(data = {}) {
    const existing_item = this.find_by(data);
    const item = existing_item ? existing_item : new this.item_type(this.env);
    item._queue_save = !existing_item;
    const data_changed = item.update_data(data);
    if (!existing_item && !item.validate_save()) {
      return item;
    }
    if (!existing_item) {
      this.set(item);
    }
    if (existing_item && !data_changed) return existing_item;
    if (item.init instanceof AsyncFunction) {
      return new Promise((resolve) => {
        item.init(data).then(() => resolve(item));
      });
    }
    item.init(data);
    return item;
  }
  /**
   * Finds an item by partial data match (first checks key). If `data.key` provided,
   * returns the item with that key; otherwise attempts a match by merging data.
   *
   * @param {Object} data - Data to match against.
   * @returns {Item|null}
   */
  find_by(data) {
    if (data.key) return this.get(data.key);
    const temp = new this.item_type(this.env);
    const temp_data = JSON.parse(JSON.stringify(data, temp.sanitize_data(data)));
    deep_merge(temp.data, temp_data);
    return temp.key ? this.get(temp.key) : null;
  }
  /**
   * Filters items based on provided filter options or a custom function.
   *
   * @param {Object|Function} [filter_opts={}] - Filter options or a predicate function.
   * @returns {Item[]} Array of filtered items.
   */
  filter(filter_opts = {}) {
    if (typeof filter_opts === "function") {
      return Object.values(this.items).filter(filter_opts);
    }
    const prepared_filter_opts = this.prepare_filter(filter_opts);
    const results = [];
    const { first_n } = prepared_filter_opts;
    for (const item of Object.values(this.items)) {
      if (first_n && results.length >= first_n) break;
      if (item.filter(prepared_filter_opts)) results.push(item);
    }
    return results;
  }
  /**
   * Alias for `filter()`
   * @param {Object|Function} filter_opts
   * @returns {Item[]}
   */
  list(filter_opts) {
    return this.filter(filter_opts);
  }
  /**
   * Prepares filter options. Can be overridden by subclasses to normalize filter options.
   *
   * @param {Object} filter_opts
   * @returns {Object} Prepared filter options.
   */
  prepare_filter(filter_opts) {
    return filter_opts;
  }
  /**
   * Retrieves an item by key.
   * @param {string} key
   * @returns {Item|undefined}
   */
  get(key) {
    return this.items[key];
  }
  /**
   * Retrieves multiple items by an array of keys.
   * @param {string[]} keys
   * @returns {Item[]}
   */
  get_many(keys = []) {
    if (!Array.isArray(keys)) {
      console.error("get_many called with non-array keys:", keys);
      return [];
    }
    return keys.map((key) => this.get(key)).filter(Boolean);
  }
  /**
   * Retrieves a random item from the collection, optionally filtered by options.
   * @param {Object} [opts]
   * @returns {Item|undefined}
   */
  get_rand(opts = null) {
    if (opts) {
      const filtered = this.filter(opts);
      return filtered[Math.floor(Math.random() * filtered.length)];
    }
    const keys = this.keys;
    return this.items[keys[Math.floor(Math.random() * keys.length)]];
  }
  /**
   * Adds or updates an item in the collection.
   * @param {Item} item
   */
  set(item) {
    if (!item.key) throw new Error("Item must have a key property");
    this.items[item.key] = item;
  }
  /**
   * Updates multiple items by their keys.
   * @param {string[]} keys
   * @param {Object} data
   */
  update_many(keys = [], data = {}) {
    this.get_many(keys).forEach((item) => item.update_data(data));
  }
  /**
   * Clears all items from the collection.
   */
  clear() {
    this.items = {};
  }
  /**
   * @returns {string} The collection key, can be overridden by opts.collection_key
   */
  get collection_key() {
    return this._collection_key ? this._collection_key : this.constructor.collection_key;
  }
  set collection_key(key) {
    this._collection_key = key;
  }
  /**
   * Lazily initializes and returns the data adapter instance for this collection.
   * @returns {Object} The data adapter instance.
   */
  get data_adapter() {
    if (!this._data_adapter) {
      const AdapterClass = this.get_adapter_class("data");
      this._data_adapter = new AdapterClass(this);
    }
    return this._data_adapter;
  }
  get_adapter_class(type) {
    const config = this.env.opts.collections?.[this.collection_key];
    const adapter_key = type + "_adapter";
    const adapter_module = config?.[adapter_key] ?? this.env.opts.collections?.smart_collections?.[adapter_key];
    if (typeof adapter_module === "function") return adapter_module;
    if (typeof adapter_module?.collection === "function") return adapter_module.collection;
    throw new Error(`No '${type}' adapter class found for ${this.collection_key} or smart_collections`);
  }
  /**
   * Data directory strategy for this collection. Defaults to 'multi'.
   * @returns {string}
   */
  get data_dir() {
    return this.collection_key;
  }
  /**
   * File system adapter from the environment.
   * @returns {Object}
   */
  get data_fs() {
    return this.env.data_fs;
  }
  /**
   * Derives the corresponding item class name based on this collection's class name.
   * @returns {string}
   */
  get item_class_name() {
    let name = this.constructor.name;
    if (name.match(/\d$/)) name = name.slice(0, -1);
    if (name.endsWith("ies")) return name.slice(0, -3) + "y";
    else if (name.endsWith("s")) return name.slice(0, -1);
    return name + "Item";
  }
  /**
   * Derives a readable item name from the item class name.
   * @returns {string}
   */
  get item_name() {
    return this.item_class_name.replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase();
  }
  /**
   * Retrieves the item type (constructor) from the environment.
   * @returns {Function} Item constructor.
   */
  get item_type() {
    if (this.opts.item_type) return this.opts.item_type;
    return this.env.item_types[this.item_class_name];
  }
  /**
   * Returns an array of all keys in the collection.
   * @returns {string[]}
   */
  get keys() {
    return Object.keys(this.items);
  }
  /**
   * @deprecated use data_adapter instead (2024-09-14)
   */
  get adapter() {
    return this.data_adapter;
  }
  /**
   * @method process_save_queue
   * @description 
   * Saves items flagged for saving (_queue_save) back to AJSON or SQLite. This ensures persistent storage 
   * of any updates made since last load/import. This method also writes changes to disk (AJSON files or DB).
   */
  async process_save_queue(opts = {}) {
    if (opts.force) {
      Object.values(this.items).forEach((item) => item._queue_save = true);
    }
    await this.data_adapter.process_save_queue(opts);
  }
  /**
   * @alias process_save_queue
   * @returns {Promise<void>}
   */
  async save(opts = {}) {
    await this.process_save_queue(opts);
  }
  /**
   * @method process_load_queue
   * @description 
   * Loads items that have been flagged for loading (_queue_load). This may involve 
   * reading from AJSON/SQLite or re-importing from markdown if needed. 
   * Called once initial environment is ready and collections are known.
   */
  async process_load_queue() {
    await this.data_adapter.process_load_queue();
  }
  /**
   * Retrieves processed settings configuration.
   * @returns {Object}
   */
  get settings_config() {
    return this.process_settings_config({});
  }
  /**
   * Processes given settings config, adding prefixes and handling conditionals.
   *
   * @private
   * @param {Object} _settings_config
   * @param {string} [prefix='']
   * @returns {Object}
   */
  process_settings_config(_settings_config, prefix = "") {
    const add_prefix = (key) => prefix && !key.includes(`${prefix}.`) ? `${prefix}.${key}` : key;
    return Object.entries(_settings_config).reduce((acc, [key, val]) => {
      let new_val = { ...val };
      if (new_val.conditional) {
        if (!new_val.conditional(this)) return acc;
        delete new_val.conditional;
      }
      if (new_val.callback) new_val.callback = add_prefix(new_val.callback);
      if (new_val.btn_callback) new_val.btn_callback = add_prefix(new_val.btn_callback);
      if (new_val.options_callback) new_val.options_callback = add_prefix(new_val.options_callback);
      const new_key = add_prefix(this.process_setting_key(key));
      acc[new_key] = new_val;
      return acc;
    }, {});
  }
  /**
   * Processes an individual setting key. Override if needed.
   * @param {string} key
   * @returns {string}
   */
  process_setting_key(key) {
    return key;
  }
  /**
   * Default settings for this collection. Override in subclasses as needed.
   * @returns {Object}
   */
  get default_settings() {
    return {};
  }
  /**
   * Current settings for the collection.
   * Initializes with default settings if none exist.
   * @returns {Object}
   */
  get settings() {
    if (!this.env.settings[this.collection_key]) {
      this.env.settings[this.collection_key] = this.default_settings;
    }
    return this.env.settings[this.collection_key];
  }
  /**
   * @deprecated use env.smart_view instead
   * @returns {Object} smart_view instance
   */
  get smart_view() {
    if (!this._smart_view) this._smart_view = this.env.init_module("smart_view");
    return this._smart_view;
  }
  /**
   * Renders the settings for the collection into a given container.
   * @deprecated use env.render_component('collection_settings', this) instead (2025-05-25: decouple UI from collections)
   * @param {HTMLElement} [container=this.settings_container]
   * @param {Object} opts
   * @returns {Promise<HTMLElement>}
   */
  async render_settings(container = this.settings_container, opts = {}) {
    return await this.render_collection_settings(container, opts);
  }
  /**
   * Helper function to render collection settings.
   * @deprecated use env.render_component('collection_settings', this) instead (2025-05-25: decouple UI from collections)
   * @param {HTMLElement} [container=this.settings_container]
   * @param {Object} opts
   * @returns {Promise<HTMLElement>}
   */
  async render_collection_settings(container = this.settings_container, opts = {}) {
    if (container && (!this.settings_container || this.settings_container !== container)) {
      this.settings_container = container;
    } else if (!container) {
      container = this.env.smart_view.create_doc_fragment("<div></div>");
    }
    this.env.smart_view.safe_inner_html(container, `<div class="sc-loading">Loading ${this.collection_key} settings...</div>`);
    const frag = await this.env.render_component("settings", this, opts);
    this.env.smart_view.empty(container);
    container.appendChild(frag);
    return container;
  }
  /**
   * Unloads collection data from memory.
   */
  unload() {
    this.clear();
    this.unloaded = true;
    this.env.collections[this.collection_key] = null;
  }
  /**
   * Displays a process notice if the operation exceeds one second.
   *
   * @param {string} process - Identifier for the ongoing process.
   * @param {Object} [opts={}] - Additional options passed to the notice.
   */
  show_process_notice(process2, opts = {}) {
    if (!this.debounce_process_notice) this.debounce_process_notice = {};
    this.debounce_process_notice[process2] = setTimeout(() => {
      this.debounce_process_notice[process2] = null;
      this.env.notices?.show(process2, { collection_key: this.collection_key, ...opts });
    }, 1e3);
  }
  /**
   * Clears any pending process notice timers and removes active notices.
   *
   * @param {string} process - Identifier for the process notice to clear.
   */
  clear_process_notice(process2) {
    if (this.debounce_process_notice?.[process2]) {
      clearTimeout(this.debounce_process_notice[process2]);
      this.debounce_process_notice[process2] = null;
    } else {
      this.env.notices?.remove(process2);
    }
  }
  /**
   * Emits an event with collection metadata.
   *
   * @param {string} event_key
   * @param {Object} [payload={}]
   * @returns {void}
   */
  emit_event(event_key, payload = {}) {
    this.env.events?.emit(event_key, { collection_key: this.collection_key, ...payload });
  }
  /**
   * Lazily binds action functions to the collection instance.
   *
   * @returns {Object} Bound action functions keyed by name.
   */
  get actions() {
    if (!this._actions) {
      this._actions = Object.entries(this.opts.actions || {}).reduce((acc, [k, v]) => {
        acc[k] = v.bind(this);
        return acc;
      }, {});
    }
    return this._actions;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-entities/adapters/_adapter.js
var EntitiesVectorAdapter = class {
  /**
   * @constructor
   * @param {Object} collection - The collection (SmartEntities or derived class) instance.
   */
  constructor(collection) {
    this.collection = collection;
  }
  /**
   * Find the nearest entities to the given vector.
   * @async
   * @param {number[]} vec - The reference vector.
   * @param {Object} [filter={}] - Optional filters (limit, exclude, etc.)
   * @returns {Promise<Array<{item:Object, score:number}>>} Array of results sorted by score descending.
   * @throws {Error} Not implemented by default.
   */
  async nearest(vec, filter = {}) {
    throw new Error("EntitiesVectorAdapter.nearest() not implemented");
  }
  /**
   * Find the furthest entities from the given vector.
   * @async
   * @param {number[]} vec - The reference vector.
   * @param {Object} [filter={}] - Optional filters (limit, exclude, etc.)
   * @returns {Promise<Array<{item:Object, score:number}>>} Array of results sorted by score ascending (furthest).
   * @throws {Error} Not implemented by default.
   */
  async furthest(vec, filter = {}) {
    throw new Error("EntitiesVectorAdapter.furthest() not implemented");
  }
  /**
   * Embed a batch of entities.
   * @async
   * @param {Object[]} entities - Array of entity instances to embed.
   * @returns {Promise<void>}
   * @throws {Error} Not implemented by default.
   */
  async embed_batch(entities) {
    throw new Error("EntitiesVectorAdapter.embed_batch() not implemented");
  }
  /**
   * Process a queue of entities waiting to be embedded.
   * Typically, this will call embed_batch in batches and update entities.
   * @async
   * @param {Object[]} embed_queue - Array of entities to embed.
   * @returns {Promise<void>}
   * @throws {Error} Not implemented by default.
   */
  async process_embed_queue(embed_queue) {
    throw new Error("EntitiesVectorAdapter.process_embed_queue() not implemented");
  }
};
var EntityVectorAdapter = class {
  /**
   * @constructor
   * @param {Object} item - The SmartEntity instance that this adapter is associated with.
   */
  constructor(item) {
    this.item = item;
  }
  /**
   * Retrieve the current vector embedding for this entity.
   * @async
   * @returns {Promise<number[]|undefined>} The entity's vector or undefined if not set.
   * @throws {Error} Not implemented by default.
   */
  async get_vec() {
    throw new Error("EntityVectorAdapter.get_vec() not implemented");
  }
  /**
   * Store/update the vector embedding for this entity.
   * @async
   * @param {number[]} vec - The vector to set.
   * @returns {Promise<void>}
   * @throws {Error} Not implemented by default.
   */
  async set_vec(vec) {
    throw new Error("EntityVectorAdapter.set_vec() not implemented");
  }
  /**
   * Delete/remove the vector embedding for this entity.
   * @async
   * @returns {Promise<void>}
   * @throws {Error} Not implemented by default.
   */
  async delete_vec() {
    throw new Error("EntityVectorAdapter.delete_vec() not implemented");
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-utils/results_acc.js
function results_acc(_acc, result, ct = 10) {
  if (_acc.results.size < ct) {
    _acc.results.add(result);
    if (_acc.results.size === ct && _acc.min === Number.POSITIVE_INFINITY) {
      let { minScore, minObj } = find_min(_acc.results);
      _acc.min = minScore;
      _acc.minResult = minObj;
    }
  } else if (result.score > _acc.min) {
    _acc.results.add(result);
    _acc.results.delete(_acc.minResult);
    let { minScore, minObj } = find_min(_acc.results);
    _acc.min = minScore;
    _acc.minResult = minObj;
  }
}
function furthest_acc(_acc, result, ct = 10) {
  if (_acc.results.size < ct) {
    _acc.results.add(result);
    if (_acc.results.size === ct && _acc.max === Number.NEGATIVE_INFINITY) {
      let { maxScore, maxObj } = find_max(_acc.results);
      _acc.max = maxScore;
      _acc.maxResult = maxObj;
    }
  } else if (result.score < _acc.max) {
    _acc.results.add(result);
    _acc.results.delete(_acc.maxResult);
    let { maxScore, maxObj } = find_max(_acc.results);
    _acc.max = maxScore;
    _acc.maxResult = maxObj;
  }
}
function find_min(results) {
  let minScore = Number.POSITIVE_INFINITY;
  let minObj = null;
  for (const obj of results) {
    if (obj.score < minScore) {
      minScore = obj.score;
      minObj = obj;
    }
  }
  return { minScore, minObj };
}
function find_max(results) {
  let maxScore = Number.NEGATIVE_INFINITY;
  let maxObj = null;
  for (const obj of results) {
    if (obj.score > maxScore) {
      maxScore = obj.score;
      maxObj = obj;
    }
  }
  return { maxScore, maxObj };
}

// node_modules/obsidian-smart-env/node_modules/smart-utils/sort_by_score.js
function sort_by_score(a, b) {
  const epsilon = 1e-9;
  const score_diff = a.score - b.score;
  if (Math.abs(score_diff) < epsilon) return 0;
  return score_diff > 0 ? -1 : 1;
}
function sort_by_score_descending(a, b) {
  return sort_by_score(a, b);
}
function sort_by_score_ascending(a, b) {
  return sort_by_score(a, b) * -1;
}

// node_modules/obsidian-smart-env/node_modules/smart-entities/adapters/default.js
var DefaultEntitiesVectorAdapter = class extends EntitiesVectorAdapter {
  constructor(collection) {
    super(collection);
    this._is_processing_embed_queue = false;
    this._reset_embed_queue_stats();
  }
  /**
   * Find the nearest entities to the given vector.
   * @async
   * @param {number[]} vec - The reference vector.
   * @param {Object} [filter={}] - Optional filters (limit, exclude, etc.)
   * @returns {Promise<Array<{item:Object, score:number}>>} Array of results sorted by score descending.
   */
  async nearest(vec, filter = {}) {
    if (!vec || !Array.isArray(vec)) {
      throw new Error("Invalid vector input to nearest()");
    }
    const {
      limit = 50
      // TODO: default configured in settings
    } = filter;
    const nearest = this.collection.filter(filter).reduce((acc, item) => {
      if (!item.vec) return acc;
      const result = { item, score: cos_sim(vec, item.vec) };
      results_acc(acc, result, limit);
      return acc;
    }, { min: 0, results: /* @__PURE__ */ new Set() });
    return Array.from(nearest.results).sort(sort_by_score_descending);
  }
  /**
   * Find the furthest entities from the given vector.
   * @async
   * @param {number[]} vec - The reference vector.
   * @param {Object} [filter={}] - Optional filters (limit, exclude, etc.)
   * @returns {Promise<Array<{item:Object, score:number}>>} Array of results sorted by score ascending (furthest).
   */
  async furthest(vec, filter = {}) {
    if (!vec || !Array.isArray(vec)) {
      throw new Error("Invalid vector input to furthest()");
    }
    const {
      limit = 50
      // TODO: default configured in settings
    } = filter;
    const furthest = this.collection.filter(filter).reduce((acc, item) => {
      if (!item.vec) return acc;
      const result = { item, score: cos_sim(vec, item.vec) };
      furthest_acc(acc, result, limit);
      return acc;
    }, { max: 0, results: /* @__PURE__ */ new Set() });
    return Array.from(furthest.results).sort(sort_by_score_ascending);
  }
  /**
   * Embed a batch of entities.
   * @async
   * @param {Object[]} entities - Array of entity instances to embed.
   * @returns {Promise<void>}
   */
  async embed_batch(entities) {
    if (!this.collection.embed_model) {
      throw new Error("No embed_model found in collection for embedding");
    }
    await Promise.all(entities.map((e) => e.get_embed_input()));
    const embeddings = await this.collection.embed_model.embed_batch(entities);
    embeddings.forEach((emb, i) => {
      const entity = entities[i];
      entity.vec = emb.vec;
      entity.data.last_embed = entity.data.last_read;
      if (emb.tokens !== void 0) entity.tokens = emb.tokens;
    });
  }
  /**
   * Process a queue of entities waiting to be embedded.
   * Prevents multiple concurrent runs by using `_is_processing_embed_queue`.
   * @async
   * @returns {Promise<void>}
   */
  async process_embed_queue() {
    if (this._is_processing_embed_queue) {
      console.log("process_embed_queue is already running, skipping concurrent call.");
      return;
    }
    this._is_processing_embed_queue = true;
    try {
      if (!this.collection.embed_model.is_loaded) {
        await this.collection.embed_model.load();
      }
    } catch (e) {
      this.collection.emit_event("embed_model:load_failed");
      this.notices?.show("Failed to load embed_model");
      return;
    }
    try {
      const embed_queue = this.collection.embed_queue;
      this._reset_embed_queue_stats();
      if (this.collection.embed_model_key === "None") {
        console.log(`Smart Connections: No active embedding model for ${this.collection.collection_key}, skipping embedding`);
        return;
      }
      if (!this.collection.embed_model) {
        console.log(`Smart Connections: No active embedding model for ${this.collection.collection_key}, skipping embedding`);
        return;
      }
      const datetime_start = /* @__PURE__ */ new Date();
      if (!embed_queue.length) {
        console.log(`Smart Connections: No items in ${this.collection.collection_key} embed queue`);
        return;
      }
      console.log(`Time spent getting embed queue: ${(/* @__PURE__ */ new Date()).getTime() - datetime_start.getTime()}ms`);
      console.log(`Processing ${this.collection.collection_key} embed queue: ${embed_queue.length} items`);
      for (let i = 0; i < embed_queue.length; i += this.collection.embed_model.batch_size) {
        if (this.is_queue_halted) {
          this.is_queue_halted = false;
          break;
        }
        this._show_embed_progress_notice(embed_queue.length);
        const batch = embed_queue.slice(i, i + this.collection.embed_model.batch_size);
        await Promise.all(batch.map((item) => item.get_embed_input()));
        try {
          const start_time = Date.now();
          await this.embed_batch(batch);
          this.total_time += Date.now() - start_time;
        } catch (e) {
          if (e && e.message && e.message.includes("API key not set")) {
            this.halt_embed_queue_processing(`API key not set for ${this.collection.embed_model_key}
Please set the API key in the settings.`);
          }
          console.error(e);
          console.error(`Error processing ${this.collection.collection_key} embed queue: ` + JSON.stringify(e || {}, null, 2));
        }
        batch.forEach((item) => {
          item.embed_hash = item.read_hash;
          item._queue_save = true;
        });
        this.embedded_total += batch.length;
        this.total_tokens += batch.reduce((acc, item) => acc + (item.tokens || 0), 0);
        if (this.embedded_total - this.last_save_total > 1e3) {
          this.last_save_total = this.embedded_total;
          await this.collection.process_save_queue();
          if (this.collection.block_collection) {
            console.log(`Saving ${this.collection.block_collection.collection_key} block collection`);
            await this.collection.block_collection.process_save_queue();
          }
        }
      }
      this._show_embed_completion_notice(embed_queue.length);
      await this.collection.process_save_queue();
      if (this.collection.block_collection) {
        await this.collection.block_collection.process_save_queue();
      }
    } finally {
      this._is_processing_embed_queue = false;
    }
  }
  get should_show_embed_progress_notice() {
    if (Date.now() - (this.last_notice_time ?? 0) > 3e4) {
      return true;
    }
    return this.embedded_total - this.last_notice_embedded_total >= 100;
  }
  /**
   * Displays the embedding progress notice.
   * @private
   * @returns {void}
   */
  _show_embed_progress_notice(embed_queue_length) {
    if (embed_queue_length < 100) return;
    if (!this.should_show_embed_progress_notice) return;
    this.last_notice_time = Date.now();
    this.last_notice_embedded_total = this.embedded_total;
    this.collection.emit_event("embedding:progress_reported", {
      progress: this.embedded_total,
      total: embed_queue_length,
      tokens_per_second: this._calculate_embed_tokens_per_second(),
      model_name: this.collection.embed_model_key
    });
    this.notices?.show("embedding_progress", {
      progress: this.embedded_total,
      total: embed_queue_length,
      tokens_per_second: this._calculate_embed_tokens_per_second(),
      model_name: this.collection.embed_model_key
    });
  }
  /**
   * Displays the embedding completion notice.
   * @private
   * @returns {void}
   */
  _show_embed_completion_notice() {
    this.notices?.remove("embedding_progress");
    if (this.embedded_total > 100) {
      this.collection.emit_event("embedding:completed", {
        total_embeddings: this.embedded_total,
        tokens_per_second: this._calculate_embed_tokens_per_second(),
        model_name: this.collection.embed_model_key
      });
      this.notices?.show("embedding_complete", {
        total_embeddings: this.embedded_total,
        tokens_per_second: this._calculate_embed_tokens_per_second(),
        model_name: this.collection.embed_model_key
      });
    }
  }
  /**
   * Halts the embed queue processing.
   * @param {string|null} msg - Optional message.
   */
  halt_embed_queue_processing(msg = null) {
    this.is_queue_halted = true;
    console.log("Embed queue processing halted");
    this.notices?.remove("embedding_progress");
    this.collection.emit_event("embedding:paused", {
      progress: this.embedded_total,
      total: this.collection._embed_queue.length,
      tokens_per_second: this._calculate_embed_tokens_per_second(),
      model_name: this.collection.embed_model_key
    });
    this.notices?.show("embedding_paused", {
      progress: this.embedded_total,
      total: this.collection._embed_queue.length,
      tokens_per_second: this._calculate_embed_tokens_per_second(),
      model_name: this.collection.embed_model_key
    });
  }
  /**
   * Resumes the embed queue processing after a delay.
   * @param {number} [delay=0] - The delay in milliseconds before resuming.
   * @returns {void}
   */
  resume_embed_queue_processing(delay = 0) {
    console.log("resume_embed_queue_processing");
    this.notices?.remove("embedding_paused");
    setTimeout(() => {
      this.embedded_total = 0;
      this.process_embed_queue();
    }, delay);
  }
  /**
   * Calculates the number of tokens processed per second.
   * @private
   * @returns {number} Tokens per second.
   */
  _calculate_embed_tokens_per_second() {
    const elapsed_time = this.total_time / 1e3;
    return Math.round(this.total_tokens / (elapsed_time || 1));
  }
  /**
   * Resets the statistics related to embed queue processing.
   * @private
   * @returns {void}
   */
  _reset_embed_queue_stats() {
    this.collection._embed_queue = [];
    this.embedded_total = 0;
    this.is_queue_halted = false;
    this.last_save_total = 0;
    this.last_notice_embedded_total = 0;
    this.total_tokens = 0;
    this.total_time = 0;
  }
  get notices() {
    return this.collection.notices;
  }
};
var DefaultEntityVectorAdapter = class extends EntityVectorAdapter {
  get data() {
    return this.item.data;
  }
  /**
   * Retrieve the current vector embedding for this entity.
   * @async
   * @returns {Promise<number[]|undefined>} The entity's vector or undefined if not set.
   */
  async get_vec() {
    return this.vec;
  }
  /**
   * Store/update the vector embedding for this entity.
   * @async
   * @param {number[]} vec - The vector to set.
   * @returns {Promise<void>}
   */
  async set_vec(vec) {
    this.vec = vec;
  }
  /**
   * Delete/remove the vector embedding for this entity.
   * @async
   * @returns {Promise<void>}
   */
  async delete_vec() {
    if (this.item.data?.embeddings?.[this.item.embed_model_key]) {
      delete this.item.data.embeddings[this.item.embed_model_key].vec;
    }
  }
  // adds synchronous get/set for vec
  get vec() {
    return this.item.data?.embeddings?.[this.item.embed_model_key]?.vec;
  }
  set vec(vec) {
    if (!this.item.data.embeddings) {
      this.item.data.embeddings = {};
    }
    if (!this.item.data.embeddings[this.item.embed_model_key]) {
      this.item.data.embeddings[this.item.embed_model_key] = {};
    }
    this.item.data.embeddings[this.item.embed_model_key].vec = vec;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-entities/actions/find_connections.js
async function find_connections(params = {}) {
  const filter_opts = this.prepare_find_connections_filter_opts(params);
  const limit = params.filter?.limit || params.limit || this.env.settings.smart_view_filter?.results_limit || 10;
  const cache_key = this.key + murmur_hash_32_alphanumeric(JSON.stringify({ ...filter_opts, entity: null }));
  if (!this.env.connections_cache) this.env.connections_cache = {};
  if (!this.env.connections_cache[cache_key]) {
    const connections = (await this.nearest(filter_opts)).sort(sort_by_score).slice(0, limit);
    this.connections_to_cache(cache_key, connections);
  }
  return this.connections_from_cache(cache_key);
}
find_connections.action_type = "connections";

// node_modules/obsidian-smart-env/node_modules/smart-entities/smart_entity.js
var SmartEntity = class extends CollectionItem {
  /**
   * Creates an instance of SmartEntity.
   * @constructor
   * @param {Object} env - The environment instance.
   * @param {Object} [opts={}] - Configuration options.
   */
  constructor(env, opts = {}) {
    super(env, opts);
    this.entity_adapter = new DefaultEntityVectorAdapter(this);
  }
  /**
   * Provides default values for a SmartEntity instance.
   * @static
   * @readonly
   * @returns {Object} The default values.
   */
  static get defaults() {
    return {
      data: {
        path: null,
        last_embed: {
          hash: null
        },
        embeddings: {}
      }
    };
  }
  get vector_adapter() {
    if (!this._vector_adapter) {
      this._vector_adapter = new this.collection.opts.vector_adapter.item(this);
    }
    return this._vector_adapter;
  }
  /**
   * Initializes the SmartEntity instance.
   * Checks if the entity has a vector and if it matches the model dimensions.
   * If not, it queues an embed.
   * Removes embeddings for inactive models.
   * @returns {void}
   */
  init() {
    super.init();
    if (!this.vec || !this.vec.length) {
      this.vec = null;
      this.queue_embed();
    }
    Object.entries(this.data.embeddings || {}).forEach(([model, embedding]) => {
      if (model !== this.embed_model_key) {
        this.data.embeddings[model] = null;
        delete this.data.embeddings[model];
      }
    });
  }
  /**
   * Queues the entity for embedding.
   * @returns {void}
   */
  queue_embed() {
    this._queue_embed = true;
  }
  /**
   * Finds the nearest entities to this entity.
   * @param {Object} [filter={}] - Optional filters to apply.
   * @returns {Array<{item:Object, score:number}>} An array of result objects with score and item.
   */
  async nearest(filter = {}) {
    return await this.collection.nearest_to(this, filter);
  }
  /**
   * Prepares the input for embedding.
   * @async
   * @param {string} [content=null] - Optional content to use instead of calling subsequent read()
   * @returns {Promise<void>} Should be overridden in child classes.
   */
  async get_embed_input(content = null) {
  }
  // override in child class
  /**
   * Retrieves the embed input, either from cache or by generating it.
   * @readonly
   * @returns {string|Promise<string>} The embed input string or a promise resolving to it.
   */
  get embed_input() {
    return this._embed_input ? this._embed_input : this.get_embed_input();
  }
  /**
   * Prepares filter options for finding connections based on parameters.
   * @param {Object} [params={}] - Parameters for finding connections.
   * @returns {Object} The prepared filter options.
   */
  prepare_find_connections_filter_opts(params = {}) {
    const opts = {
      ...this.env.settings.smart_view_filter || {},
      ...params,
      entity: this
    };
    if (opts.filter?.limit) delete opts.filter.limit;
    if (opts.limit) delete opts.limit;
    if (opts.exclude_frontmatter_blocks) {
      if (!opts.exclude_key_ends_with_any) opts.exclude_key_ends_with_any = [];
      opts.exclude_key_ends_with_any.push("---frontmatter---");
    }
    return opts;
  }
  /**
   * Finds connections relevant to this entity based on provided parameters.
   * @async
   * @param {Object} [params={}] - Parameters for finding connections.
   * @returns {Array<{item:Object, score:number}>} An array of result objects with score and item.
   */
  async find_connections(params = {}) {
    return await this.actions.find_connections(params);
  }
  /**
   * Retrieves connections from the cache based on the cache key.
   * @param {string} cache_key - The cache key.
   * @returns {Array<{item:Object, score:number}>} The cached connections.
   */
  connections_from_cache(cache_key) {
    return this.env.connections_cache[cache_key];
  }
  /**
   * Stores connections in the cache with the provided cache key.
   * @param {string} cache_key - The cache key.
   * @param {Array<{item:Object, score:number}>} connections - The connections to cache.
   * @returns {void}
   */
  connections_to_cache(cache_key, connections) {
    this.env.connections_cache[cache_key] = connections;
  }
  get read_hash() {
    return this.data.last_read?.hash;
  }
  set read_hash(hash) {
    if (!this.data.last_read) this.data.last_read = {};
    this.data.last_read.hash = hash;
  }
  get embedding_data() {
    if (!this.data.embeddings[this.embed_model_key]) {
      this.data.embeddings[this.embed_model_key] = {};
    }
    return this.data.embeddings[this.embed_model_key];
  }
  get last_embed() {
    if (!this.embedding_data.last_embed) {
      this.embedding_data.last_embed = {};
      if (this.data.last_embed) {
        this.embedding_data.last_embed = this.data.last_embed;
        delete this.data.last_embed;
        this.queue_save();
      }
    }
    return this.embedding_data.last_embed;
  }
  get embed_hash() {
    return this.last_embed?.hash;
  }
  set embed_hash(hash) {
    if (!this.embedding_data.last_embed) this.embedding_data.last_embed = {};
    this.embedding_data.last_embed.hash = hash;
  }
  /**
   * Gets the embed link for the entity.
   * @readonly
   * @returns {string} The embed link.
   */
  get embed_link() {
    return `![[${this.path}]]`;
  }
  /**
   * Gets the key of the embedding model.
   * @readonly
   * @returns {string} The embedding model key.
   */
  get embed_model_key() {
    return this.collection.embed_model_key;
  }
  /**
   * @deprecated Use embed_model instead.
   * @readonly
   * @returns {Object} The smart embedding model.
   */
  get smart_embed() {
    return this.embed_model;
  }
  /**
   * Gets the embedding model instance from the collection.
   * @readonly
   * @returns {Object} The embedding model instance.
   */
  get embed_model() {
    return this.collection.embed_model;
  }
  /**
   * Determines if the entity should be embedded if unembedded. NOT the same as is_unembedded.
   * @readonly
   * @returns {boolean} True if no vector is set, false otherwise.
   */
  get should_embed() {
    return this.size > (this.settings?.min_chars || 300);
  }
  /**
   * Sets the error for the embedding model.
   * @param {string} error - The error message.
   */
  set error(error) {
    this.data.embeddings[this.embed_model_key].error = error;
  }
  /**
   * Gets the number of tokens associated with the entity's embedding.
   * @readonly
   * @returns {number|undefined} The number of tokens, or undefined if not set.
   */
  get tokens() {
    return this.last_embed?.tokens;
  }
  /**
   * Sets the number of tokens for the embedding.
   * @param {number} tokens - The number of tokens.
   */
  set tokens(tokens) {
    this.last_embed.tokens = tokens;
  }
  /**
   * Gets the vector representation from the entity adapter.
   * @readonly
   * @returns {Array<number>|undefined} The vector or undefined if not set.
   */
  get vec() {
    return this.entity_adapter.vec;
  }
  /**
   * Sets the vector representation in the entity adapter.
   * @param {Array<number>} vec - The vector to set.
   */
  set vec(vec) {
    this.entity_adapter.vec = vec;
    this._queue_embed = false;
    this._embed_input = null;
    this.queue_save();
  }
  /**
   * Removes all embeddings from the entity.
   * @returns {void}
   */
  remove_embeddings() {
    this.data.embeddings = null;
    this.queue_save();
  }
  /**
   * Retrieves the key of the entity.
   * @returns {string} The entity key.
   */
  get_key() {
    return this.data.key || this.data.path;
  }
  /**
   * Retrieves the path of the entity.
   * @readonly
   * @returns {string|null} The entity path.
   */
  get path() {
    return this.data.path;
  }
  get is_unembedded() {
    if (!this.vec) return true;
    if (!this.embed_hash || this.embed_hash !== this.read_hash) return true;
    return false;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-entities/smart_entities.js
var SmartEntities = class extends Collection {
  /**
   * Creates an instance of SmartEntities.
   * @constructor
   * @param {Object} env - The environment instance.
   * @param {Object} opts - Configuration options.
   */
  constructor(env, opts) {
    super(env, opts);
    this.entities_vector_adapter = new DefaultEntitiesVectorAdapter(this);
    this.model_instance_id = null;
    this._embed_queue = [];
  }
  /**
   * Initializes the SmartEntities instance by loading embeddings.
   * @async
   * @returns {Promise<void>}
   */
  async init() {
    await super.init();
    await this.load_smart_embed();
    if (!this.embed_model) {
      console.log(`SmartEmbed not loaded for **${this.collection_key}**. Continuing without embedding capabilities.`);
    }
  }
  /**
   * Loads the smart embedding model.
   * @async
   * @returns {Promise<void>}
   */
  async load_smart_embed() {
    if (this.embed_model_key === "None") return;
    if (!this.embed_model) return;
    if (this.embed_model.is_loading) return console.log(`SmartEmbedModel already loading for ${this.embed_model_key}`);
    if (this.embed_model.is_loaded) return console.log(`SmartEmbedModel already loaded for ${this.embed_model_key}`);
    try {
      console.log(`Loading SmartEmbedModel in ${this.collection_key}, current state: ${this.embed_model.state}`);
      await this.embed_model.load();
    } catch (e) {
      console.error(`Error loading SmartEmbedModel for ${this.embed_model.model_key}`);
      console.error(e);
    }
  }
  /**
   * Unloads the smart embedding model.
   * @async
   * @returns {Promise<void>}
   */
  async unload() {
    if (typeof this.embed_model?.unload === "function") {
      this.embed_model.unload();
    }
    super.unload();
  }
  /**
   * Gets the key of the embedding model.
   * @readonly
   * @returns {string} The embedding model key.
   */
  get embed_model_key() {
    return this.embed_model?.model_key;
  }
  /**
   * Gets or creates the container for smart embeddings in the DOM.
   * @readonly
   * @returns {HTMLElement|undefined} The container element or undefined if not available.
   */
  get smart_embed_container() {
    if (!this.model_instance_id) return console.log("model_key not set");
    const id = this.model_instance_id.replace(/[^a-zA-Z0-9]/g, "_");
    if (!window.document) return console.log("window.document not available");
    if (window.document.querySelector(`#${id}`)) return window.document.querySelector(`#${id}`);
    const container = window.document.createElement("div");
    container.id = id;
    window.document.body.appendChild(container);
    return container;
  }
  /**
   * @deprecated Use embed_model instead.
   * @readonly
   * @returns {Object} The smart embedding model.
   */
  get smart_embed() {
    return this.embed_model;
  }
  /**
   * Gets the embedding model instance.
   * @readonly
   * @returns {Object|null} The embedding model instance or null if none.
   */
  get embed_model() {
    if (!this.env._embed_model && this.env.opts.modules.smart_embed_model?.class) this.env._embed_model = new this.env.opts.modules.smart_embed_model.class({
      settings: this.settings.embed_model,
      adapters: this.env.opts.modules.smart_embed_model?.adapters,
      re_render_settings: () => this.env.render_component("collection_settings", this, { settings_container: this.settings_container }),
      reload_model: this.reload_embed_model.bind(this)
    });
    return this.env._embed_model;
  }
  set embed_model(embed_model) {
    this.env._embed_model = embed_model;
  }
  reload_embed_model() {
    console.log("reload_embed_model");
    this.embed_model.unload();
    this.env._embed_model = null;
  }
  /**
   * Finds the nearest entities to a given entity.
   * @async
   * @param {Object} entity - The reference entity.
   * @param {Object} [filter={}] - Optional filters to apply.
   * @returns {Promise<Array<{item:Object, score:number}>>} An array of result objects with score and item.
   */
  async nearest_to(entity, filter = {}) {
    return await this.nearest(entity.vec, filter);
  }
  /**
   * Finds the nearest entities to a vector using the default adapter.
   * @async
   * @param {Array<number>} vec - The vector to compare against.
   * @param {Object} [filter={}] - Optional filters to apply.
   * @returns {Promise<Array<{item:Object, score:number}>>} An array of result objects with score and item.
   */
  async nearest(vec, filter = {}) {
    if (!vec) {
      console.warn("nearest: no vec");
      return [];
    }
    return await this.entities_vector_adapter.nearest(vec, filter);
  }
  /**
   * Finds the furthest entities from a vector using the default adapter.
   * @async
   * @param {Array<number>} vec - The vector to compare against.
   * @param {Object} [filter={}] - Optional filters to apply.
   * @returns {Promise<Array<{item:Object, score:number}>>} An array of result objects with score and item.
   */
  async furthest(vec, filter = {}) {
    if (!vec) return console.warn("furthest: no vec");
    return await this.entities_vector_adapter.furthest(vec, filter);
  }
  /**
   * Gets the file name based on collection key and embedding model key.
   * @readonly
   * @returns {string} The constructed file name.
   */
  get file_name() {
    return this.collection_key + "-" + this.embed_model_key.split("/").pop();
  }
  /**
   * Calculates the relevance of an item based on the search filter.
   * @param {Object} item - The item to calculate relevance for.
   * @param {Object} search_filter - The search filter containing keywords.
   * @returns {number} The relevance score:
   *                   1 if any keyword is found in the item's path,
   *                   0 otherwise (default relevance for keyword in content).
   */
  calculate_relevance(item, search_filter) {
    if (search_filter.keywords.some((keyword) => item.path?.includes(keyword))) return 1;
    return 0;
  }
  /**
   * Prepares the filter options by incorporating entity-based filters.
   * @param {Object} [opts={}] - The filter options.
   * @param {Object} [opts.entity] - The entity to base the filters on.
   * @param {string|string[]} [opts.exclude_filter] - Keys or prefixes to exclude.
   * @param {string|string[]} [opts.include_filter] - Keys or prefixes to include.
   * @param {boolean} [opts.exclude_inlinks] - Whether to exclude inlinks of the entity.
   * @param {boolean} [opts.exclude_outlinks] - Whether to exclude outlinks of the entity.
   * @returns {Object} The modified filter options.
   */
  prepare_filter(opts = {}) {
    const {
      entity,
      exclude_filter,
      include_filter,
      exclude_inlinks,
      exclude_outlinks
    } = opts;
    if (entity) {
      if (typeof opts.exclude_key_starts_with_any === "undefined") opts.exclude_key_starts_with_any = [];
      if (opts.exclude_key_starts_with) {
        opts.exclude_key_starts_with_any = [
          opts.exclude_key_starts_with
        ];
        delete opts.exclude_key_starts_with;
      }
      opts.exclude_key_starts_with_any.push(entity.source_key || entity.key);
      if (exclude_filter) {
        if (!Array.isArray(opts.exclude_key_includes_any)) opts.exclude_key_includes_any = [];
        if (typeof exclude_filter === "string") {
          if (exclude_filter.includes(",")) {
            opts.exclude_key_includes_any.push(...exclude_filter.split(","));
          } else {
            opts.exclude_key_includes_any.push(exclude_filter);
          }
        }
      }
      if (include_filter) {
        if (!Array.isArray(opts.key_includes_any)) opts.key_includes_any = [];
        if (typeof include_filter === "string") {
          if (include_filter.includes(",")) {
            opts.key_includes_any.push(...include_filter.split(","));
          } else {
            opts.key_includes_any.push(include_filter);
          }
        }
      }
      if (exclude_inlinks && entity?.inlinks?.length) {
        if (!Array.isArray(opts.exclude_key_starts_with_any)) opts.exclude_key_starts_with_any = [];
        opts.exclude_key_starts_with_any.push(...entity.inlinks);
      }
      if (exclude_outlinks && entity?.outlinks?.length) {
        if (!Array.isArray(opts.exclude_key_starts_with_any)) opts.exclude_key_starts_with_any = [];
        opts.exclude_key_starts_with_any.push(...entity.outlinks);
      }
    }
    return opts;
  }
  /**
   * Looks up entities based on hypothetical content.
   * @async
   * @param {Object} [params={}] - The parameters for the lookup.
   * @param {Array<string>} [params.hypotheticals=[]] - The hypothetical content to lookup.
   * @param {Object} [params.filter] - The filter to use for the lookup.
   * @param {number} [params.k] - Deprecated: Use `filter.limit` instead.
   * @returns {Promise<Array<Result>|Object>} The lookup results or an error object.
   */
  async lookup(params = {}) {
    const { hypotheticals = [] } = params;
    if (!hypotheticals?.length) return { error: "hypotheticals is required" };
    if (!this.embed_model) return { error: "Embedding search is not enabled." };
    const hyp_vecs = await this.embed_model.embed_batch(hypotheticals.map((h) => ({ embed_input: h })));
    const limit = params.filter?.limit || params.k || this.env.settings.lookup_k || 10;
    if (params.filter?.limit) delete params.filter.limit;
    const filter = {
      ...this.env.chats?.current?.scope || {},
      // DEPRECATED: since Smart Chat v1 (remove after removing legacy Smart Chat v0 from obsidian-smart-connections)
      ...params.filter || {}
    };
    const results = await hyp_vecs.reduce(async (acc_promise, embedding, i) => {
      const acc = await acc_promise;
      const results2 = await this.nearest(embedding.vec, filter);
      results2.forEach((result) => {
        if (!acc[result.item.path] || result.score > acc[result.item.path].score) {
          acc[result.item.path] = {
            key: result.item.key,
            score: result.score,
            item: result.item,
            hypothetical_i: i
          };
        } else {
          result.score = acc[result.item.path].score;
        }
      });
      return acc;
    }, Promise.resolve({}));
    const top_k = Object.values(results).sort(sort_by_score).slice(0, limit);
    console.log(`Found and returned ${top_k.length} ${this.collection_key}.`);
    return top_k;
  }
  /**
   * Gets the configuration for settings.
   * @readonly
   * @returns {Object} The settings configuration.
   */
  get settings_config() {
    return settings_config;
  }
  /**
   * @deprecated use env.render_component('collection_settings', this) instead (2025-05-25: decouple UI from collections)
   */
  async render_settings(container = this.settings_container, opts = {}) {
    container = await this.render_collection_settings(container, opts);
    const embed_model_settings_frag = await this.env.render_component("settings", this.embed_model, opts);
    container.appendChild(embed_model_settings_frag);
    return container;
  }
  /**
   * Gets the notices from the environment.
   * @readonly
   * @returns {Object} The notices object.
   */
  get notices() {
    return this.env.smart_connections_plugin?.notices || this.env.main?.notices;
  }
  /**
   * Gets the embed queue containing items to be embedded.
   * @readonly
   * @returns {Array<Object>} The embed queue.
   */
  get embed_queue() {
    if (!this._embed_queue?.length) {
      console.time(`Building embed queue`);
      this._embed_queue = Object.values(this.items).filter((item) => item._queue_embed || item.is_unembedded && item.should_embed);
      console.timeEnd(`Building embed queue`);
    }
    return this._embed_queue;
  }
  /**
   * Processes the embed queue by delegating to the default vector adapter.
   * @async
   * @returns {Promise<void>}
   */
  async process_embed_queue() {
    await this.entities_vector_adapter.process_embed_queue();
  }
  /**
   * Handles changes to the embedding model by reinitializing and processing the load queue.
   * @async
   * @returns {Promise<void>}
   */
  async embed_model_changed() {
    await this.unload();
    await this.init();
    this.render_settings();
    await this.process_load_queue();
  }
  get connections_filter_config() {
    return connections_filter_config;
  }
};
var settings_config = {
  "min_chars": {
    name: "Minimum length",
    type: "number",
    description: "Minimum length of entity to embed (in characters).",
    placeholder: "Enter number ex. 300",
    default: 300
  }
};
var connections_filter_config = {
  "smart_view_filter.show_full_path": {
    "name": "Show full path",
    "type": "toggle",
    "description": "Turning on will include the folder path in the connections results."
  },
  "smart_view_filter.render_markdown": {
    "name": "Render markdown",
    "type": "toggle",
    "description": "Turn off to prevent rendering markdown and display connection results as plain text."
  },
  "smart_view_filter.results_limit": {
    "name": "Results limit",
    "type": "number",
    "description": "Adjust the number of connections displayed in the connections view (default 20).",
    "default": 20
  },
  "smart_view_filter.exclude_inlinks": {
    "name": "Exclude inlinks (backlinks)",
    "type": "toggle",
    "description": "Exclude notes that already link to the current note from the connections results."
  },
  "smart_view_filter.exclude_outlinks": {
    "name": "Exclude outlinks",
    "type": "toggle",
    "description": "Exclude notes that are already linked from within the current note from appearing in the connections results."
  },
  "smart_view_filter.include_filter": {
    "name": "Include filter",
    "type": "text",
    "description": "Notes must match this value in their file/folder path. Matching notes will be included in the connections results. Separate multiple values with commas."
  },
  "smart_view_filter.exclude_filter": {
    "name": "Exclude filter",
    "type": "text",
    "description": "Notes must *not* match this value in their file/folder path. Matching notes will be *excluded* from the connections results. Separate multiple values with commas."
  },
  // should be better scoped at source-level (leaving here for now since connections_filter_config needs larger refactor)
  "smart_view_filter.exclude_blocks_from_source_connections": {
    "name": "Hide blocks in results",
    "type": "toggle",
    "description": "Show only sources in the connections results (no blocks)."
  },
  // hide frontmatter blocks from connections results
  "smart_view_filter.exclude_frontmatter_blocks": {
    "name": "Hide frontmatter blocks in results",
    "type": "toggle",
    "description": "Show only sources in the connections results (no frontmatter blocks)."
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/components/source.js
async function render2(entity, opts = {}) {
  let markdown;
  if (should_render_embed(entity)) markdown = `${entity.embed_link}

${await entity.read()}`;
  else markdown = process_for_rendering(await entity.read());
  let frag;
  if (source.env.settings.smart_view_filter.render_markdown) frag = await this.render_markdown(markdown, source);
  else frag = this.create_doc_fragment(`<span>${markdown}</span>`);
  return await post_process2.call(this, source, frag, opts);
}
function process_for_rendering(content) {
  if (content.includes("```dataview")) content = content.replace(/```dataview/g, "```\\dataview");
  if (content.includes("![[")) content = content.replace(/\!\[\[/g, "! [[");
  return content;
}
async function post_process2(scope, frag, opts = {}) {
  return frag;
}
function should_render_embed(entity) {
  if (!entity) return false;
  if (entity.is_media) return true;
  return false;
}

// node_modules/obsidian-smart-env/node_modules/smart-sources/actions/find_connections.js
async function find_connections2(params = {}) {
  let connections;
  const filter_settings = this.env.settings.smart_view_filter;
  const exclude_blocks_from_source_connections = params.exclude_blocks_from_source_connections ?? filter_settings?.exclude_blocks_from_source_connections ?? false;
  if (this.block_collection.settings.embed_blocks && !exclude_blocks_from_source_connections) connections = [];
  else connections = await find_connections.call(this, params);
  const filter_opts = this.prepare_find_connections_filter_opts(params);
  const limit = params.filter?.limit || params.limit || this.env.settings.smart_view_filter?.results_limit || 20;
  if (params.filter?.limit) delete params.filter.limit;
  if (params.limit) delete params.limit;
  if (!exclude_blocks_from_source_connections) {
    const cache_key = this.key + murmur_hash_32_alphanumeric(JSON.stringify({ ...filter_opts, entity: null })) + "_blocks";
    if (!this.env.connections_cache) this.env.connections_cache = {};
    if (!this.env.connections_cache[cache_key]) {
      const nearest = (await this.env.smart_blocks.nearest(this.vec, filter_opts)).sort(sort_by_score).slice(0, limit);
      this.connections_to_cache(cache_key, nearest);
    }
    connections = [
      ...connections,
      ...this.connections_from_cache(cache_key)
    ].sort(sort_by_score).slice(0, limit);
  }
  return connections;
}
find_connections2.action_type = "connections";

// node_modules/obsidian-smart-env/node_modules/smart-sources/smart_source.js
var SmartSource = class extends SmartEntity {
  /**
   * Provides default values for a SmartSource instance.
   * @static
   * @readonly
   * @returns {Object} The default values.
   */
  static get defaults() {
    return {
      data: {
        last_read: {
          hash: null,
          mtime: 0
        },
        embeddings: {}
      },
      _embed_input: null,
      // Stored temporarily
      _queue_load: true
    };
  }
  /**
   * Initializes the SmartSource instance by queuing an import if blocks are missing.
   * @returns {void}
   */
  init() {
    super.init();
    if (!this.data.blocks) this.queue_import();
  }
  /**
   * Queues the SmartSource for import.
   * @returns {void}
   */
  queue_import() {
    this._queue_import = true;
  }
  /**
   * Imports the SmartSource by checking for updates and parsing content.
   * @async
   * @returns {Promise<void>}
   */
  async import() {
    this._queue_import = false;
    try {
      await this.source_adapter?.import();
    } catch (err) {
      if (err.code === "ENOENT") {
        console.log(`Smart Connections: Deleting ${this.path} data because it no longer exists on disk`);
        this.delete();
      } else {
        console.warn("Smart Connections: Error during import: re-queueing import", err);
        this.queue_import();
      }
    }
  }
  /**
   * @deprecated likely extraneous
   */
  async parse_content(content = null) {
    const parse_fns = this.env?.opts?.collections?.smart_sources?.content_parsers || [];
    for (const fn of parse_fns) {
      await fn(this, content);
    }
    if (this.data.last_import?.hash === this.data.last_read?.hash) {
      if (this.data.blocks) return;
    }
  }
  /**
   * Finds connections relevant to this SmartSource based on provided parameters.
   * @async
   * @param {Object} [params={}] - Parameters for finding connections.
   * @param {boolean} [params.exclude_blocks_from_source_connections=false] - Whether to exclude block connections from source connections.
   * @param {Object} [params.exclude_frontmatter_blocks=true] - Whether to exclude frontmatter blocks from source connections.
   * @returns {Array<SmartSource>} An array of relevant SmartSource entities.
   */
  async find_connections(params = {}) {
    return await this.actions.find_connections(params);
  }
  /**
   * Prepares the embed input for the SmartSource by reading content and applying exclusions.
   * @async
   * @returns {Promise<string|false>} The embed input string or `false` if already embedded.
   */
  async get_embed_input(content = null) {
    if (typeof this._embed_input === "string" && this._embed_input.length) return this._embed_input;
    if (!content) content = await this.read();
    if (!content) {
      console.warn("SmartSource.get_embed_input: No content available for embedding: " + this.path);
      return "";
    }
    if (this.excluded_lines.length) {
      const content_lines = content.split("\n");
      this.excluded_lines.forEach((lines) => {
        const { start, end } = lines;
        for (let i = start; i <= end; i++) {
          content_lines[i] = "";
        }
      });
      content = content_lines.filter((line) => line.length).join("\n");
    }
    const breadcrumbs = this.path.split("/").join(" > ").replace(".md", "");
    const max_tokens = this.collection.embed_model.model_config.max_tokens || 500;
    const max_chars = Math.floor(max_tokens * 3.7);
    this._embed_input = `${breadcrumbs}:
${content}`.substring(0, max_chars);
    return this._embed_input;
  }
  /**
   * Opens the SmartSource note in the SmartConnections plugin.
   * @returns {void}
   */
  open() {
    this.env.smart_connections_plugin.open_note(this.path);
  }
  /**
   * Retrieves the block associated with a specific line number.
   * @param {number} line - The line number to search for.
   * @returns {SmartBlock|null} The corresponding SmartBlock or `null` if not found.
   */
  get_block_by_line(line) {
    return Object.entries(this.data.blocks || {}).reduce((acc, [sub_key, range]) => {
      if (acc) return acc;
      if (range[0] <= line && range[1] >= line) {
        const block = this.block_collection.get(this.key + sub_key);
        if (block?.vec) return block;
      }
      return acc;
    }, null);
  }
  /**
   * Checks if the source file exists in the file system.
   * @async
   * @returns {Promise<boolean>} A promise that resolves to `true` if the file exists, `false` otherwise.
   */
  async has_source_file() {
    return await this.fs.exists(this.path);
  }
  // CRUD
  /**
   * FILTER/SEARCH METHODS
   */
  /**
   * Searches for keywords within the entity's data and content.
   * @async
   * @param {Object} search_filter - The search filter object.
   * @param {string[]} search_filter.keywords - An array of keywords to search for.
   * @param {string} [search_filter.type='any'] - The type of search to perform. 'any' counts all matching keywords, 'all' counts only if all keywords match.
   * @returns {Promise<number>} A promise that resolves to the number of matching keywords.
   */
  async search(search_filter = {}) {
    const { keywords, type = "any", limit } = search_filter;
    if (!keywords || !Array.isArray(keywords)) {
      console.warn("Entity.search: keywords not set or is not an array");
      return 0;
    }
    if (limit && this.collection.search_results_ct >= limit) return 0;
    const lowercased_keywords = keywords.map((keyword) => keyword.toLowerCase());
    const content = await this.read();
    if (!content || typeof content !== "string" || !content.length) {
      if (content.mime_type) {
        console.warn(`Entity.search: No content available for searching: ${this.path}, mime_type: ${content.mime_type}`);
      } else {
        console.warn(`Entity.search: No content available for searching: ${this.path}, content: ${content ? JSON.stringify(content) : "empty"}`);
      }
      return 0;
    }
    const lowercased_content = content.toLowerCase();
    const lowercased_path = this.path.toLowerCase();
    const matching_keywords = lowercased_keywords.filter(
      (keyword) => lowercased_path.includes(keyword) || lowercased_content.includes(keyword)
    );
    if (type === "all") {
      return matching_keywords.length === lowercased_keywords.length ? matching_keywords.length : 0;
    } else {
      return matching_keywords.length;
    }
  }
  /**
   * ADAPTER METHODS
   */
  use_source_adapter(method, ...args) {
    if (!this.source_adapter) {
      console.warn(`No source adapter available for ${this.key}. Cannot use method ${method}.`);
      return;
    }
    if (typeof this.source_adapter[method] !== "function") {
      console.warn(`Source adapter for ${this.key} does not implement method ${method}.`);
      return;
    }
    return this.source_adapter[method](...args);
  }
  /**
   * Appends content to the end of the source file.
   * @async
   * @param {string} content - The content to append to the file.
   * @returns {Promise<void>} A promise that resolves when the operation is complete.
   */
  async append(content) {
    await this.use_source_adapter("append", content);
    await this.import();
  }
  /**
   * Updates the entire content of the source file.
   * @async
   * @param {string} full_content - The new content to write to the file.
   * @param {Object} [opts={}] - Additional options for the update.
   * @returns {Promise<void>} A promise that resolves when the operation is complete.
   */
  async update(full_content, opts = {}) {
    try {
      await this.use_source_adapter("update", full_content, opts);
      await this.import();
    } catch (error) {
      console.error(`Error during update for ${this.key}:`, error);
    }
  }
  /**
   * Reads the entire content of the source file.
   * @async
   * @param {Object} [opts={}] - Additional options for reading.
   * @returns {Promise<string>} A promise that resolves with the content of the file.
   */
  async read(opts = {}) {
    try {
      return await this.use_source_adapter("read", opts) || "";
    } catch (error) {
      console.error(`Error during reading ${this.key} (returning empty string)`, error);
      return "";
    }
  }
  /**
   * Removes the source file from the file system and deletes the entity.
   * This is different from `delete()` because it also removes the source file.
   * @async
   * @returns {Promise<void>} A promise that resolves when the operation is complete.
   */
  async remove() {
    try {
      await this.use_source_adapter("remove");
    } catch (error) {
      console.error(`Error during remove for ${this.key}:`, error);
    }
  }
  /**
   * Moves the current source to a new location.
   * Handles the destination as a string (new path) or entity (block or source).
   *
   * @async
   * @param {string|Object|SmartEntity} entity_ref - The destination path or entity to move to.
   * @throws {Error} If the entity reference is invalid.
   * @returns {Promise<void>} A promise that resolves when the move operation is complete.
   */
  async move_to(entity_ref) {
    try {
      await this.use_source_adapter("move_to", entity_ref);
    } catch (error) {
      console.error(`Error during move for ${this.key}:`, error);
    }
  }
  /**
   * Merges the given content into the current source.
   * Parses the content into blocks and either appends to existing blocks, replaces blocks, or replaces all content.
   *
   * @async
   * @param {string} content - The content to merge into the current source.
   * @param {Object} [opts={}] - Options object.
   * @param {string} [opts.mode='append'] - The merge mode: 'append', 'replace_blocks', or 'replace_all'.
   * @returns {Promise<void>}
   */
  async merge(content, opts = {}) {
    try {
      await this.use_source_adapter("merge", content, opts);
      await this.import();
    } catch (error) {
      console.error(`Error during merge for ${this.key}:`, error);
    }
  }
  /**
   * Handles errors during the load process.
   * @param {Error} err - The error encountered during load.
   * @returns {void}
   */
  on_load_error(err) {
    super.on_load_error(err);
    if (err.code === "ENOENT") {
      this._queue_load = false;
      this.queue_import();
    }
  }
  // GETTERS
  /**
   * Retrieves the block collection associated with SmartSources.
   * @readonly
   * @returns {SmartBlocks} The block collection instance.
   */
  get block_collection() {
    return this.env.smart_blocks;
  }
  /**
   * Retrieves the vector representations of all blocks within the SmartSource.
   * @readonly
   * @returns {Array<Array<number>>} An array of vectors.
   */
  get block_vecs() {
    return this.blocks.map((block) => block.vec).filter((vec) => vec);
  }
  /**
   * Retrieves all blocks associated with the SmartSource.
   * @readonly
   * @returns {Array<SmartBlock>} An array of SmartBlock instances.
   * @description
   * Uses block refs (Fastest) to get blocks without iterating over all blocks
   */
  get blocks() {
    if (this.data.blocks) return this.block_collection.get_many(Object.keys(this.data.blocks).map((key) => this.key + key));
    return [];
  }
  /**
   * Determines if the SmartSource is excluded from processing.
   * @readonly
   * @returns {boolean} `true` if excluded, `false` otherwise.
   */
  get excluded() {
    return this.fs.is_excluded(this.path);
  }
  /**
   * Retrieves the lines excluded from embedding.
   * @readonly
   * @returns {Array<Object>} An array of objects with `start` and `end` line numbers.
   */
  get excluded_lines() {
    return this.blocks.filter((block) => block.excluded).map((block) => block.lines);
  }
  /**
   * Retrieves the file system instance from the SmartSource's collection.
   * @readonly
   * @returns {SmartFS} The file system instance.
   */
  get fs() {
    return this.collection.fs;
  }
  /**
   * Retrieves the file object associated with the SmartSource.
   * @readonly
   * @returns {Object} The file object.
   */
  get file() {
    return this.fs.files[this.path];
  }
  /**
   * Retrieves the file name of the SmartSource.
   * @readonly
   * @returns {string} The file name.
   */
  get file_name() {
    return this.path.split("/").pop();
  }
  /**
   * Retrieves the file path of the SmartSource.
   * @readonly
   * @returns {string} The file path.
   */
  get file_path() {
    return this.path;
  }
  /**
   * Retrieves the file type based on the file extension.
   * @readonly
   * @returns {string} The file type in lowercase.
   */
  get file_type() {
    if (!this._ext) {
      this._ext = this.collection.get_extension_for_path(this.path) || "md";
    }
    return this._ext;
  }
  /**
   * Retrieves the modification time of the SmartSource.
   * @readonly
   * @returns {number} The modification time.
   */
  get mtime() {
    return this.file?.stat?.mtime || 0;
  }
  /**
   * Retrieves the size of the SmartSource.
   * @readonly
   * @returns {number} The size.
   */
  get size() {
    return this.source_adapter?.size || 0;
  }
  /**
   * Retrieves the last import stat of the SmartSource.
   * @readonly
   * @returns {Object} The last import stat.
   */
  get last_import() {
    return this.data?.last_import;
  }
  /**
   * Retrieves the last import modification time of the SmartSource.
   * @readonly
   * @returns {number} The last import modification time.
   */
  get last_import_mtime() {
    return this.last_import?.mtime || 0;
  }
  /**
   * Retrieves the last import size of the SmartSource.
   * @readonly
   * @returns {number} The last import size.
   */
  get last_import_size() {
    return this.last_import?.size || 0;
  }
  /**
   * Retrieves the paths of inlinks to this SmartSource.
   * @readonly
   * @returns {Array<string>} An array of inlink paths.
   */
  get inlinks() {
    return Object.keys(this.collection.links?.[this.path] || {});
  }
  get is_media() {
    return this.source_adapter.is_media || false;
  }
  /**
   * Determines if the SmartSource is gone (i.e., the file no longer exists).
   * @readonly
   * @returns {boolean} `true` if gone, `false` otherwise.
   */
  get is_gone() {
    return !this.file;
  }
  /**
   * Retrieves the last read hash of the SmartSource.
   * @readonly
   * @returns {string|undefined} The last read hash or `undefined` if not set.
   */
  get last_read() {
    return this.data.last_read;
  }
  get metadata() {
    return this.data.metadata;
  }
  get outdated() {
    return this.source_adapter.outdated;
  }
  /**
   * Retrieves the outlink paths from the SmartSource.
   * @readonly
   * @returns {Array<string>} An array of outlink paths.
   */
  get outlinks() {
    return (this.data.outlinks || []).map((link) => {
      const link_ref = link?.target || link;
      if (typeof link_ref !== "string") return null;
      if (link_ref.startsWith("http")) return null;
      const link_path = this.fs.get_link_target_path(link_ref, this.file_path);
      return link_path;
    }).filter((link_path) => link_path);
  }
  get path() {
    return this.data.path || this.data.key;
  }
  get source_adapters() {
    return this.collection.source_adapters;
  }
  get source_adapter() {
    if (this._source_adapter) return this._source_adapter;
    if (this.source_adapters[this.file_type]) this._source_adapter = new this.source_adapters[this.file_type](this);
    else {
      for (const Adapter of Object.values(this.source_adapters)) {
        if (typeof Adapter.detect_type !== "function") continue;
        if (Adapter.detect_type(this)) {
          this._source_adapter = new Adapter(this);
          break;
        }
      }
    }
    return this._source_adapter;
  }
  // COMPONENTS
  /**
   * Retrieves the component responsible for rendering the SmartSource.
   * @deprecated
   * @readonly
   * @returns {Function} The render function for the source component.
   */
  get component() {
    return render2;
  }
  // Currently unused, but useful for later
  /**
   * Calculates the mean vector of all blocks within the SmartSource.
   * @readonly
   * @returns {Array<number>|null} The mean vector or `null` if no vectors are present.
   */
  get mean_block_vec() {
    if (this._mean_block_vec) {
      this._mean_block_vec = compute_centroid(this.block_vecs);
    }
    return this._mean_block_vec;
  }
  /**
   * Calculates the median vector of all blocks within the SmartSource.
   * @readonly
   * @returns {Array<number>|null} The median vector or `null` if no vectors are present.
   */
  get median_block_vec() {
    if (this._median_block_vec) {
      this._median_block_vec = compute_medoid(this.block_vecs);
    }
    return this._median_block_vec;
  }
  // DEPRECATED methods
  /**
   * @async
   * @deprecated Use `read` instead.
   * @returns {Promise<string>} A promise that resolves with the content of the file.
   */
  async _read() {
    return await this.source_adapter._read();
  }
  /**
   * @async
   * @deprecated Use `remove` instead.
   * @returns {Promise<void>} A promise that resolves when the entity is destroyed.
   */
  async destroy() {
    await this.remove();
  }
  /**
   * @async
   * @deprecated Use `update` instead.
   * @param {string} content - The content to update.
   * @returns {Promise<void>}
   */
  async _update(content) {
    await this.source_adapter.update(content);
  }
  /**
   * @deprecated Use `source` instead.
   * @readonly
   * @returns {SmartSource} The associated SmartSource instance.
   */
  get t_file() {
    return this.fs.files[this.path];
  }
};
var smart_source_default = {
  class: SmartSource,
  actions: {
    find_connections: find_connections2
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/smart_sources.js
var SmartSources = class extends SmartEntities {
  /**
   * Creates an instance of SmartSources.
   * @constructor
   * @param {Object} env - The environment instance.
   * @param {Object} [opts={}] - Configuration options.
   */
  constructor(env, opts = {}) {
    super(env, opts);
    this.search_results_ct = 0;
    this._excluded_headings = null;
  }
  /**
   * Initializes the SmartSources instance by performing an initial scan of sources.
   * @async
   * @returns {Promise<void>}
   */
  async init() {
    await super.init();
    await this.init_items();
  }
  /**
   * Initializes items by letting each adapter do any necessary file-based scanning.
   * Adapters that do not rely on file scanning can skip or do nothing.
   * @async
   * @returns {Promise<void>}
   */
  async init_items() {
    this.emit_event("source:initial_scan_started");
    this.show_process_notice("initial_scan");
    for (const AdapterClass of Object.values(this.source_adapters)) {
      if (typeof AdapterClass.init_items === "function") {
        await AdapterClass.init_items(this);
      }
    }
    this.clear_process_notice("initial_scan");
    this.emit_event("source:initial_scan_completed");
    this.notices?.show("done_initial_scan", { collection_key: this.collection_key });
  }
  /**
   * Creates (or returns existing) a SmartSource for a given file path, if the extension is recognized.
   * @param {string} file_path - The path to the file or pseudo-file
   * @returns {SmartSource|undefined} The newly created or existing SmartSource, or undefined if no recognized extension
   */
  init_file_path(file_path) {
    const ext = this.get_extension_for_path(file_path);
    if (!ext) {
      return;
    }
    if (this.fs.is_excluded(file_path)) {
      console.warn(`File ${file_path} is excluded from processing.`);
      return;
    }
    if (!this.fs.files[file_path]) {
      this.fs.include_file(file_path);
    }
    if (this.items[file_path]) return this.items[file_path];
    const item = new this.item_type(this.env, { path: file_path });
    this.items[file_path] = item;
    item.queue_import();
    item.queue_load();
    return item;
  }
  /**
   * Looks for an extension in descending order:
   * e.g. split "my.file.name.github" -> ["my","file","name","github"]
   * Try 'file.name.github', 'name.github', 'github'
   * Return the first that is in 'source_adapters'
   * @param {string} file_path
   * @returns {string|undefined} recognized extension, or undefined if none
   */
  get_extension_for_path(file_path) {
    if (!file_path) return void 0;
    const pcs = file_path.split(".");
    if (pcs.length < 2) return void 0;
    let last_ext;
    pcs.shift();
    while (pcs.length) {
      const supported_ext = pcs.join(".").toLowerCase();
      if (this.source_adapters[supported_ext]) {
        return supported_ext;
      }
      last_ext = pcs.shift();
    }
    return last_ext;
    return void 0;
  }
  /**
   * Builds a map of links between sources.
   * @returns {Object} An object mapping link paths to source keys.
   */
  build_links_map() {
    const start_time = Date.now();
    this.links = {};
    for (const source2 of Object.values(this.items)) {
      for (const link of source2.outlinks) {
        if (!this.links[link]) this.links[link] = {};
        this.links[link][source2.key] = true;
      }
    }
    const end_time = Date.now();
    console.log(`Time spent building links: ${end_time - start_time}ms`);
    return this.links;
  }
  /**
   * Creates a new source with the given key and content.
   * @async
   * @param {string} key - The key (path) of the new source.
   * @param {string} content - The content to write to the new source.
   * @returns {Promise<SmartSource>} The created SmartSource instance.
   */
  async create(key, content) {
    await this.fs.write(key, content);
    await this.fs.refresh();
    const source2 = await this.create_or_update({ path: key });
    await source2.import();
    return source2;
  }
  /**
   * Performs a lexical search for matching SmartSource content.
   * @async
   * @param {Object} search_filter - The filter criteria for the search.
   * @param {string[]} search_filter.keywords - An array of keywords to search for.
   * @param {number} [search_filter.limit] - The maximum number of results to return.
   * @returns {Promise<Array<SmartSource>>} A promise that resolves to an array of matching SmartSource entities.
   */
  async search(search_filter = {}) {
    const {
      keywords,
      limit,
      ...filter_opts
    } = search_filter;
    if (!keywords) {
      console.warn("search_filter.keywords not set");
      return [];
    }
    this.search_results_ct = 0;
    const initial_results = this.filter(filter_opts);
    const search_results = [];
    for (let i = 0; i < initial_results.length; i += 10) {
      const batch = initial_results.slice(i, i + 10);
      const batch_results = await Promise.all(
        batch.map(async (item) => {
          try {
            const matches = await item.search(search_filter);
            if (matches) {
              this.search_results_ct++;
              return { item, score: matches };
            } else return null;
          } catch (error) {
            console.error(`Error searching item ${item.id || "unknown"}:`, error);
            return null;
          }
        })
      );
      search_results.push(...batch_results.filter(Boolean));
    }
    return search_results.sort((a, b) => b.score - a.score).map((result) => result.item);
  }
  /**
   * Looks up entities based on the provided parameters.
   * @async
   * @param {Object} [params={}] - Parameters for the lookup.
   * @param {Object} [params.filter] - Filter options.
   * @param {number} [params.k] - Deprecated. Use `params.filter.limit` instead.
   * @returns {Promise<Array<SmartSource>>} A promise that resolves to an array of matching SmartSource entities.
   */
  async lookup(params = {}) {
    const limit = params.filter?.limit || params.k || this.env.settings.lookup_k || 10;
    if (params.filter?.limit) delete params.filter.limit;
    if (params.collection) {
      const collection = this.env[params.collection];
      if (collection && collection.lookup) {
        delete params.collection;
        params.skip_blocks = true;
        const results2 = await collection.lookup(params);
        if (results2.error) {
          console.warn(results2.error);
          return [];
        }
        return results2.slice(0, limit);
      }
    }
    let results = await super.lookup(params);
    if (results.error) {
      console.warn(results.error);
      return [];
    }
    if (this.block_collection?.settings?.embed_blocks && !params.skip_blocks) {
      results = [
        ...results,
        ...await this.block_collection.lookup(params)
      ].sort(sort_by_score);
    }
    return results.slice(0, limit);
  }
  /**
   * Processes the load queue by loading items and optionally importing them.
   * Called after a "re-load" from settings, or after environment init.
   * @async
   * @returns {Promise<void>}
   */
  async process_load_queue() {
    await super.process_load_queue();
    if (this.collection_key === "smart_sources" && this.env.smart_blocks) {
      Object.values(this.env.smart_blocks.items).forEach((item) => item.init());
    }
    if (this.block_collection) {
      this.block_collection.loaded = Object.keys(this.block_collection.items).length;
    }
    if (!this.opts.prevent_import_on_load) {
      await this.process_source_import_queue(this.opts);
    }
    this.build_links_map();
  }
  /**
   * @method process_source_import_queue
   * @description 
   * Imports items (SmartSources or SmartBlocks) that have been flagged for import.
   */
  async process_source_import_queue(opts = {}) {
    const { process_embed_queue = true, force = false } = opts;
    if (force) Object.values(this.items).forEach((item) => item._queue_import = true);
    const import_queue = Object.values(this.items).filter((item) => item._queue_import);
    console.log("import_queue " + import_queue.length);
    if (import_queue.length) {
      const time_start = Date.now();
      for (let i = 0; i < import_queue.length; i += 100) {
        this.notices?.show("import_progress", {
          progress: i,
          total: import_queue.length
        });
        await Promise.all(import_queue.slice(i, i + 100).map((item) => item.import()));
      }
      setTimeout(() => {
        this.notices?.remove("import_progress");
      }, 1e3);
      this.notices?.show("done_import", {
        count: import_queue.length,
        time_in_seconds: (Date.now() - time_start) / 1e3
      });
    } else {
      this.notices?.show("no_import_queue");
    }
    this.build_links_map();
    if (process_embed_queue) await this.process_embed_queue();
    else console.log("skipping process_embed_queue");
    await this.process_save_queue();
    await this.block_collection?.process_save_queue();
  }
  /**
   * Retrieves the source adapters based on the collection configuration.
   * @readonly
   * @returns {Object} An object mapping file extensions to adapter constructors.
   */
  get source_adapters() {
    if (!this._source_adapters) {
      const source_adapters = Object.entries(this.env.opts.collections?.[this.collection_key]?.source_adapters || {});
      const _source_adapters = source_adapters.reduce((acc, [key, Adapter]) => {
        if (Adapter.extensions) Adapter.extensions?.forEach((ext) => acc[ext] = Adapter);
        else if (typeof Adapter.detect_type === "function") acc[key] = Adapter;
        return acc;
      }, {});
      if (Object.keys(_source_adapters).length) {
        this._source_adapters = _source_adapters;
      }
    }
    return this._source_adapters;
  }
  /**
   * Retrieves the notices system from the environment.
   * @readonly
   * @returns {Object} The notices object.
   */
  get notices() {
    return this.env.smart_connections_plugin?.notices || this.env.main?.notices;
  }
  /**
   * Retrieves the currently active note.
   * @readonly
   * @returns {SmartSource|null} The current SmartSource instance or null if none.
   */
  get current_note() {
    return this.get(this.env.smart_connections_plugin.app.workspace.getActiveFile().path);
  }
  /**
   * Retrieves the file system instance, initializing it if necessary.
   * @readonly
   * @returns {SmartFS} The file system instance.
   */
  get fs() {
    if (!this._fs) {
      this._fs = new this.env.opts.modules.smart_fs.class(this.env, {
        adapter: this.env.opts.modules.smart_fs.adapter,
        fs_path: this.env.opts.env_path || "",
        exclude_patterns: this.excluded_patterns || []
      });
    }
    return this._fs;
  }
  /**
   * Retrieves the settings configuration by combining superclass settings and adapter-specific settings.
   * @readonly
   * @returns {Object} The settings configuration object.
   */
  get settings_config() {
    const _settings_config = {
      ...super.settings_config,
      ...this.process_settings_config(settings_config2),
      ...this.process_settings_config(this.embed_model.settings_config, "embed_model"),
      ...Object.entries(this.source_adapters).reduce((acc, [file_extension, adapter_constructor]) => {
        if (acc[adapter_constructor]) return acc;
        const item = this.items[Object.keys(this.items).find((i) => i.endsWith(file_extension))];
        const adapter_instance = new adapter_constructor(item || new this.item_type(this.env, {}));
        if (adapter_instance.settings_config) {
          acc[adapter_constructor.name] = {
            type: "html",
            value: `<h4>${adapter_constructor.name} adapter</h4>`
          };
          acc = { ...acc, ...adapter_instance.settings_config };
        }
        return acc;
      }, {})
    };
    return _settings_config;
  }
  /**
   * Retrieves the block collection associated with SmartSources.
   * @readonly
   * @returns {SmartBlocks} The block collection instance.
   */
  get block_collection() {
    return this.env.smart_blocks;
  }
  /**
   * Retrieves the embed queue containing items and their blocks to be embedded.
   * @readonly
   * @returns {Array<Object>} The embed queue.
   */
  get embed_queue() {
    if (!this._embed_queue.length) {
      try {
        const embed_blocks = this.block_collection.settings.embed_blocks;
        this._embed_queue = Object.values(this.items).reduce((acc, item) => {
          if (item._queue_embed || item.should_embed && item.is_unembedded) acc.push(item);
          if (embed_blocks) item.blocks.forEach((block) => {
            if (block._queue_embed || block.should_embed && block.is_unembedded) acc.push(block);
          });
          return acc;
        }, []);
      } catch (e) {
        console.error(`Error getting embed queue:`, e);
      }
    }
    return this._embed_queue;
  }
  /**
   * Clears all data by removing sources and blocks, reinitializing the file system, and reimporting items.
   * @async
   * @returns {Promise<void>}
   */
  async run_clear_all() {
    this.notices?.show("clearing_all");
    await this.data_fs.remove_dir(this.data_dir, true);
    this.clear();
    this.block_collection.clear();
    this._fs = null;
    await this.init_fs();
    await this.init_items();
    this._excluded_headings = null;
    Object.values(this.items).forEach((item) => {
      item.queue_import();
      item.queue_embed();
      item.loaded_at = Date.now() + 9999999999;
    });
    this.notices?.remove("clearing_all");
    this.notices?.show("done_clearing_all");
    await this.process_source_import_queue();
  }
  async init_fs(opts = {}) {
    const { force_refresh = false } = opts;
    if (force_refresh) await this.env.fs.refresh();
    await this.fs.load_exclusions();
    this.fs.file_paths = this.fs.post_process(this.env.fs.file_paths);
    this.fs.files = this.fs.file_paths.reduce((acc, file_path) => {
      acc[file_path] = this.env.fs.files[file_path];
      return acc;
    }, {});
    this.fs.folder_paths = this.fs.post_process(this.env.fs.folder_paths);
    this.fs.folders = this.fs.folder_paths.reduce((acc, folder_path) => {
      acc[folder_path] = this.env.fs.folders[folder_path];
      return acc;
    }, {});
  }
  /**
   * Deletes all *.ajson files in the "multi/" data_dir, then re-saves all sources (opts.force=true).
   */
  async run_clean_up_data() {
    this.notices?.show("pruning_collection", { collection_key: this.block_collection.collection_key });
    const remove_smart_blocks = this.block_collection.filter((item) => {
      if (!item.vec) return false;
      if (item.is_gone) {
        item.reason = "is_gone";
        return true;
      }
      if (!item.should_embed) {
        item.reason = "should not embed";
        return true;
      }
      return false;
    });
    for (let i = 0; i < remove_smart_blocks.length; i++) {
      const item = remove_smart_blocks[i];
      if (item.is_gone) item.delete();
      else item.remove_embeddings();
    }
    this.notices?.remove("pruning_collection");
    this.notices?.show("done_pruning_collection", { collection_key: this.block_collection.collection_key, count: remove_smart_blocks.length });
    console.log(`Pruned ${remove_smart_blocks.length} blocks:
${remove_smart_blocks.map((item) => `${item.reason} - ${item.key}`).join("\n")}`);
    await this.data_fs.remove_dir(this.data_dir, true);
    await this.process_save_queue({ force: true });
  }
  /**
   * Retrieves patterns for excluding files/folders from processing.
   * @readonly
   * @returns {Array<string>}
   */
  get excluded_patterns() {
    return [
      ...this.file_exclusions?.map((file) => `${file}**`) || [],
      ...(this.folder_exclusions || []).map((folder) => `${folder}**`),
      this.env.env_data_dir + "/**"
    ];
  }
  /**
   * Retrieves the file exclusion patterns from settings.
   * @readonly
   * @returns {Array<string>} An array of file exclusion patterns.
   */
  get file_exclusions() {
    const csv = this.env.settings?.smart_sources?.file_exclusions;
    return csv?.length ? csv.split(",").map((file) => file.trim()) : [];
  }
  /**
   * Retrieves the folder exclusion patterns from settings.
   * @readonly
   * @returns {Array<string>} An array of folder exclusion patterns.
   */
  get folder_exclusions() {
    const csv = this.env.settings?.smart_sources?.folder_exclusions;
    return csv?.length ? csv.split(",").map((folder) => {
      folder = folder.trim();
      if (folder === "") return false;
      if (folder === "/") return false;
      if (!folder.endsWith("/")) return folder + "/";
      return folder;
    }).filter(Boolean) : [];
  }
  /**
   * Retrieves the excluded headings from settings.
   * @readonly
   * @returns {Array<string>} An array of excluded headings.
   */
  get excluded_headings() {
    if (!this._excluded_headings) {
      const csv = this.env.settings?.smart_sources?.excluded_headings;
      this._excluded_headings = csv?.length ? csv.split(",").map((heading) => heading.trim()) : [];
    }
    return this._excluded_headings;
  }
  /**
   * Retrieves the count of included files that are not excluded.
   * @readonly
   * @returns {number} The number of included files.
   */
  get included_files() {
    const extensions = Object.keys(this.source_adapters);
    return this.fs.file_paths.filter((file_path) => extensions.some((ext) => file_path.endsWith(ext)) && !this.fs.is_excluded(file_path)).length;
  }
  get excluded_file_paths() {
    return this.env.fs.file_paths.filter((file_path) => this.fs.is_excluded(file_path));
  }
  /**
   * Retrieves the total number of files, regardless of exclusion.
   * @readonly
   * @returns {number} The total number of files.
   */
  get total_files() {
    return this.fs.file_paths.filter((file) => file.endsWith(".md") || file.endsWith(".canvas")).length;
  }
  get data_dir() {
    return "multi";
  }
};
var settings_config2 = {
  file_exclusions: {
    name: "File Exclusions",
    description: "Comma-separated list of files to exclude.",
    type: "text",
    default: "",
    callback: "update_exclusions"
  },
  folder_exclusions: {
    name: "Folder Exclusions",
    description: "Comma-separated list of folders to exclude.",
    type: "text",
    default: "",
    callback: "update_exclusions"
  },
  excluded_headings: {
    name: "Excluded Headings",
    description: "Comma-separated list of headings to exclude.",
    type: "text",
    default: ""
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-collections/adapters/_adapter.js
var CollectionDataAdapter = class {
  /**
   * @constructor
   * @param {Object} collection - The collection instance that this adapter manages.
   */
  constructor(collection) {
    this.collection = collection;
    this.env = collection.env;
  }
  /**
   * The class to use for item adapters.
   * @type {typeof ItemDataAdapter}
   */
  ItemDataAdapter = ItemDataAdapter;
  /**
   * Optional factory method to create item adapters.
   * If `this.item_adapter_class` is not null, it uses that; otherwise can be overridden by subclasses.
   * @param {Object} item - The item to create an adapter for.
   * @returns {ItemDataAdapter}
   */
  create_item_adapter(item) {
    if (!this.ItemDataAdapter) {
      throw new Error("No item_adapter_class specified and create_item_adapter not overridden.");
    }
    return new this.ItemDataAdapter(item);
  }
  /**
   * Load a single item by its key using an `ItemDataAdapter`.
   * @async
   * @param {string} key - The key of the item to load.
   * @returns {Promise<void>} Resolves when the item is loaded.
   */
  async load_item(key) {
    throw new Error("Not implemented");
  }
  /**
   * Save a single item by its key using its associated `ItemDataAdapter`.
   * @async
   * @param {string} key - The key of the item to save.
   * @returns {Promise<void>} Resolves when the item is saved.
   */
  async save_item(key) {
    throw new Error("Not implemented");
  }
  /**
   * Delete a single item by its key. This may involve updating or removing its file,
   * as handled by the `ItemDataAdapter`.
   * @async
   * @param {string} key - The key of the item to delete.
   * @returns {Promise<void>} Resolves when the item is deleted.
   */
  async delete_item(key) {
    throw new Error("Not implemented");
  }
  /**
   * Process any queued load operations. Typically orchestrates calling `load_item()` 
   * on items that have been flagged for loading.
   * @async
   * @returns {Promise<void>}
   */
  async process_load_queue() {
    throw new Error("Not implemented");
  }
  /**
   * Process any queued save operations. Typically orchestrates calling `save_item()` 
   * on items that have been flagged for saving.
   * @async
   * @returns {Promise<void>}
   */
  async process_save_queue() {
    throw new Error("Not implemented");
  }
  /**
   * Load the item's data from storage if it has been updated externally.
   * @async
   * @param {string} key - The key of the item to load.
   * @returns {Promise<void>} Resolves when the item is loaded.
   */
  async load_item_if_updated(item) {
    const adapter = this.create_item_adapter(item);
    await adapter.load_if_updated();
  }
};
var ItemDataAdapter = class {
  /**
   * @constructor
   * @param {Object} item - The collection item instance that this adapter manages.
   */
  constructor(item) {
    this.item = item;
  }
  /**
   * Load the item's data from storage. May involve reading a file and parsing 
   * its contents, then updating `item.data`.
   * @async
   * @returns {Promise<void>} Resolves when the item is fully loaded.
   */
  async load() {
    throw new Error("Not implemented");
  }
  /**
   * Save the item's data to storage. May involve writing to a file or appending 
   * lines in an append-only format.
   * @async
   * @param {string|null} [ajson=null] - An optional serialized representation of the item’s data.
   *                                     If not provided, the adapter should derive it from the item.
   * @returns {Promise<void>} Resolves when the item is saved.
   */
  async save(ajson = null) {
    throw new Error("Not implemented");
  }
  /**
   * Delete the item's data from storage. May involve removing a file or writing 
   * a `null` entry in an append-only file to signify deletion.
   * @async
   * @returns {Promise<void>} Resolves when the item’s data is deleted.
   */
  async delete() {
    throw new Error("Not implemented");
  }
  /**
   * Returns the file path or unique identifier used by this adapter to locate and store 
   * the item's data. This may be a file name derived from the item's key.
   * @returns {string} The path or identifier for the item's data.
   */
  get data_path() {
    throw new Error("Not implemented");
  }
  /**
   * @returns {CollectionDataAdapter} The collection data adapter that this item data adapter belongs to.
   */
  get collection_adapter() {
    return this.item.collection.data_adapter;
  }
  get env() {
    return this.item.env;
  }
  /**
   * Load the item's data from storage if it has been updated externally.
   * @async
   * @returns {Promise<void>} Resolves when the item is loaded.
   */
  async load_if_updated() {
    throw new Error("Not implemented");
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-collections/adapters/_file.js
var FileCollectionDataAdapter = class extends CollectionDataAdapter {
  /**
   * The class to use for item adapters.
   * @type {typeof ItemDataAdapter}
   */
  ItemDataAdapter = FileItemDataAdapter;
  /**
   * @returns {Object} Filesystem interface derived from environment or collection settings.
   */
  get fs() {
    return this.collection.data_fs || this.collection.env.data_fs;
  }
};
var FileItemDataAdapter = class extends ItemDataAdapter {
  /**
   * @returns {Object} Filesystem interface derived from environment or collection settings.
   */
  get fs() {
    return this.item.collection.data_fs || this.item.collection.env.data_fs;
  }
  get data_path() {
    throw new Error("Not implemented");
  }
  async load_if_updated() {
    const data_path = this.data_path;
    if (await this.fs.exists(data_path)) {
      const loaded_at = this.item.loaded_at || 0;
      const data_file_stat = await this.fs.stat(data_path);
      if (data_file_stat.mtime > loaded_at + 1 * 60 * 1e3) {
        console.log(`Smart Collections: Re-loading item ${this.item.key} because it has been updated on disk`);
        await this.load();
      }
    }
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-collections/adapters/ajson_multi_file.js
var class_to_collection_key = {
  "SmartSource": "smart_sources",
  "SmartNote": "smart_sources",
  // DEPRECATED
  "SmartBlock": "smart_blocks",
  "SmartDirectory": "smart_directories"
};
var AjsonMultiFileCollectionDataAdapter = class extends FileCollectionDataAdapter {
  /**
   * The class to use for item adapters.
   * @type {typeof ItemDataAdapter}
   */
  ItemDataAdapter = AjsonMultiFileItemDataAdapter;
  /**
   * Load a single item by its key.
   * @async
   * @param {string} key
   * @returns {Promise<void>}
   */
  async load_item(key) {
    const item = this.collection.get(key);
    if (!item) return;
    const adapter = this.create_item_adapter(item);
    await adapter.load();
  }
  /**
   * Save a single item by its key.
   * @async
   * @param {string} key
   * @returns {Promise<void>}
   */
  async save_item(key) {
    const item = this.collection.get(key);
    if (!item) return;
    const adapter = this.create_item_adapter(item);
    await adapter.save();
  }
  /**
   * Process any queued load operations.
   * @async
   * @returns {Promise<void>}
   */
  async process_load_queue() {
    this.collection.emit_event("collection:load_started");
    this.collection.show_process_notice("loading_collection");
    if (!await this.fs.exists(this.collection.data_dir)) {
      await this.fs.mkdir(this.collection.data_dir);
    }
    const load_queue = Object.values(this.collection.items).filter((item) => item._queue_load);
    if (!load_queue.length) {
      this.collection.clear_process_notice("loading_collection");
      return;
    }
    console.log(`Loading ${this.collection.collection_key}: ${load_queue.length} items`);
    const batch_size = 100;
    for (let i = 0; i < load_queue.length; i += batch_size) {
      const batch = load_queue.slice(i, i + batch_size);
      await Promise.all(batch.map((item) => {
        const adapter = this.create_item_adapter(item);
        return adapter.load().catch((err) => {
          console.warn(`Error loading item ${item.key}`, err);
          item.queue_load();
        });
      }));
    }
    this.collection.loaded = load_queue.length;
    this.collection.clear_process_notice("loading_collection");
    this.collection.emit_event("collection:load_completed");
  }
  /**
   * Process any queued save operations.
   * @async
   * @returns {Promise<void>}
   */
  async process_save_queue() {
    this.collection.emit_event("collection:save_started");
    this.collection.show_process_notice("saving_collection");
    const save_queue = Object.values(this.collection.items).filter((item) => item._queue_save);
    console.log(`Saving ${this.collection.collection_key}: ${save_queue.length} items`);
    const time_start = Date.now();
    const batch_size = 50;
    for (let i = 0; i < save_queue.length; i += batch_size) {
      const batch = save_queue.slice(i, i + batch_size);
      await Promise.all(batch.map((item) => {
        const adapter = this.create_item_adapter(item);
        return adapter.save().catch((err) => {
          console.warn(`Error saving item ${item.key}`, err);
          item.queue_save();
        });
      }));
    }
    const deleted_items = Object.values(this.collection.items).filter((item) => item.deleted);
    if (deleted_items.length) {
      deleted_items.forEach((item) => {
        delete this.collection.items[item.key];
      });
    }
    console.log(`Saved ${this.collection.collection_key} in ${Date.now() - time_start}ms`);
    this.collection.clear_process_notice("saving_collection");
    this.collection.emit_event("collection:save_completed");
  }
  get_item_data_path(key) {
    return [
      this.collection.data_dir || "multi",
      this.fs?.sep || "/",
      this.get_data_file_name(key) + ".ajson"
    ].join("");
  }
  /**
   * Transforms the item key into a safe filename.
   * Replaces spaces, slashes, and dots with underscores.
   * @returns {string} safe file name
   */
  get_data_file_name(key) {
    return key.split("#")[0].replace(/[\s\/\.]/g, "_").replace(".md", "");
  }
  /**
   * Build a single AJSON line for the given item and data.
   * @param {Object} item 
   * @returns {string}
   */
  get_item_ajson(item) {
    const collection_key = item.collection_key;
    const key = item.key;
    const data_value = item.deleted ? "null" : JSON.stringify(item.data);
    return `${JSON.stringify(`${collection_key}:${key}`)}: ${data_value},`;
  }
};
var AjsonMultiFileItemDataAdapter = class extends FileItemDataAdapter {
  /**
   * Derives the `.ajson` file path from the collection's data_dir and item key.
   * @returns {string}
   */
  get data_path() {
    return this.collection_adapter.get_item_data_path(this.item.key);
  }
  /**
   * Load the item from its `.ajson` file.
   * @async
   * @returns {Promise<void>}
   */
  async load() {
    try {
      const raw_data = await this.fs.adapter.read(this.data_path, "utf-8", { no_cache: true });
      if (!raw_data) {
        this.item.queue_import();
        return;
      }
      const { rewrite, file_data } = this._parse(raw_data);
      if (rewrite) {
        if (file_data.length) await this.fs.write(this.data_path, file_data);
        else await this.fs.remove(this.data_path);
      }
      const last_import_mtime = this.item.data.last_import?.at || 0;
      if (last_import_mtime && this.item.init_file_mtime > last_import_mtime) {
        this.item.queue_import();
      }
    } catch (e) {
      this.item.queue_import();
    }
  }
  /**
   * Parse the entire AJSON content as a JSON object, handle legacy keys, and extract final state.
   * @private
   * @param {string} ajson 
   * @returns {boolean}
   */
  _parse(ajson) {
    try {
      let rewrite = false;
      if (!ajson.length) return false;
      ajson = ajson.trim();
      const original_line_count = ajson.split("\n").length;
      const json_str = "{" + ajson.slice(0, -1) + "}";
      const data = JSON.parse(json_str);
      const entries = Object.entries(data);
      for (let i = 0; i < entries.length; i++) {
        const [ajson_key, value] = entries[i];
        if (!value) {
          delete data[ajson_key];
          rewrite = true;
          continue;
        }
        const { collection_key, item_key, changed } = this._parse_ajson_key(ajson_key);
        if (changed) {
          rewrite = true;
          data[collection_key + ":" + item_key] = value;
          delete data[ajson_key];
        }
        const collection = this.env[collection_key];
        if (!collection) continue;
        const existing_item = collection.get(item_key);
        if (!value.key) value.key = item_key;
        if (existing_item) {
          existing_item.data = value;
          existing_item._queue_load = false;
          existing_item.loaded_at = Date.now();
        } else {
          const ItemClass = collection.item_type;
          const new_item = new ItemClass(this.env, value);
          new_item._queue_load = false;
          new_item.loaded_at = Date.now();
          collection.set(new_item);
        }
      }
      if (rewrite || original_line_count > entries.length) {
        rewrite = true;
      }
      return {
        rewrite,
        file_data: rewrite ? Object.entries(data).map(([key, value]) => `${JSON.stringify(key)}: ${JSON.stringify(value)},`).join("\n") : null
      };
    } catch (e) {
      if (ajson.split("\n").some((line) => !line.endsWith(","))) {
        console.warn("fixing trailing comma error");
        ajson = ajson.split("\n").map((line) => line.endsWith(",") ? line : line + ",").join("\n");
        return this._parse(ajson);
      }
      console.warn("Error parsing JSON:", e);
      return { rewrite: true, file_data: null };
    }
  }
  _parse_ajson_key(ajson_key) {
    let changed;
    let [collection_key, ...item_key] = ajson_key.split(":");
    if (class_to_collection_key[collection_key]) {
      collection_key = class_to_collection_key[collection_key];
      changed = true;
    }
    return {
      collection_key,
      item_key: item_key.join(":"),
      changed
    };
  }
  /**
   * Save the current state of the item by appending a new line to its `.ajson` file.
   * @async
   * @returns {Promise<void>}
   */
  async save(retries = 0) {
    try {
      const ajson_line = this.get_item_ajson();
      await this.fs.append(this.data_path, "\n" + ajson_line);
      this.item._queue_save = false;
    } catch (e) {
      if (e.code === "ENOENT" && retries < 1) {
        const dir = this.collection_adapter.collection.data_dir;
        if (!await this.fs.exists(dir)) {
          await this.fs.mkdir(dir);
        }
        return await this.save(retries + 1);
      }
      console.warn("Error saving item", this.data_path, this.item.key, e);
    }
  }
  /**
   * Build a single AJSON line for the given item and data.
   * @param {Object} item 
   * @returns {string}
   */
  get_item_ajson() {
    return this.collection_adapter.get_item_ajson(this.item);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/adapters/data/ajson_multi_file.js
var AjsonMultiFileSourcesDataAdapter = class extends AjsonMultiFileCollectionDataAdapter {
  ItemDataAdapter = AjsonMultiFileSourceDataAdapter;
};
var AjsonMultiFileSourceDataAdapter = class extends AjsonMultiFileItemDataAdapter {
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/adapters/_adapter.js
var SourceContentAdapter = class {
  constructor(item) {
    this.item = item;
  }
  async import() {
    this.throw_not_implemented("import");
  }
  async create() {
    this.throw_not_implemented("create");
  }
  async update() {
    this.throw_not_implemented("update");
  }
  async read() {
    this.throw_not_implemented("read");
  }
  async remove() {
    this.throw_not_implemented("remove");
  }
  // HELPER METHODS
  get data() {
    return this.item.data;
  }
  // async create_hash(content) { return await create_hash(content); }
  create_hash(content) {
    return murmur_hash_32_alphanumeric(content);
  }
  get settings() {
    return this.item.env.settings.smart_sources[this.adapter_key];
  }
  get adapter_key() {
    return to_snake(this.constructor.name);
  }
  static get adapter_key() {
    return to_snake(this.name);
  }
  get fs() {
    return this.item.collection.fs;
  }
  get env() {
    return this.item.env;
  }
};
function to_snake(str) {
  return str[0].toLowerCase() + str.slice(1).replace(/([A-Z])/g, "_$1").toLowerCase();
}

// node_modules/obsidian-smart-env/node_modules/smart-blocks/parsers/markdown.js
function parse_markdown_blocks(markdown, opts = {}) {
  const { start_index = 1, line_keys = false } = opts;
  const lines = markdown.split("\n");
  const result = {};
  const heading_stack = [];
  const heading_lines = {};
  const heading_counts = {};
  const sub_block_counts = {};
  const subheading_counts = {};
  const task_lines = [];
  let current_list_item = null;
  let current_content_block = null;
  let in_frontmatter = false;
  let frontmatter_started = false;
  const root_heading_key = "#";
  let in_code_block = false;
  sub_block_counts[root_heading_key] = 0;
  for (let i = 0; i < lines.length; i++) {
    const line_number = i + start_index;
    const line = lines[i];
    const trimmed_line = line.trim();
    if (trimmed_line === "---") {
      if (!frontmatter_started) {
        frontmatter_started = true;
        in_frontmatter = true;
        heading_lines["#---frontmatter---"] = [line_number, null];
        continue;
      } else if (in_frontmatter) {
        in_frontmatter = false;
        heading_lines["#---frontmatter---"][1] = line_number;
        continue;
      }
    }
    if (in_frontmatter) {
      continue;
    }
    if (!in_code_block && /^[-*+]\s+\[(?: |x|X)\]/.test(trimmed_line)) {
      task_lines.push(line_number);
    }
    if (trimmed_line.startsWith("```")) {
      in_code_block = !in_code_block;
      if (!current_content_block) {
        const parent_key = heading_stack.length > 0 ? heading_stack[heading_stack.length - 1].key : root_heading_key;
        if (parent_key === root_heading_key && !heading_lines[root_heading_key]) {
          heading_lines[root_heading_key] = [line_number, null];
        }
        if (parent_key === root_heading_key) {
          current_content_block = { key: root_heading_key, start_line: line_number };
          if (heading_lines[root_heading_key][1] === null || heading_lines[root_heading_key][1] < line_number) {
            heading_lines[root_heading_key][1] = null;
          }
        } else {
          if (sub_block_counts[parent_key] === void 0) {
            sub_block_counts[parent_key] = 0;
          }
          sub_block_counts[parent_key] += 1;
          const n = sub_block_counts[parent_key];
          const key = `${parent_key}#{${n}}`;
          heading_lines[key] = [line_number, null];
          current_content_block = { key, start_line: line_number };
        }
      }
      continue;
    }
    const heading_match = trimmed_line.match(/^(#{1,6})\s*(.+)$/);
    if (heading_match && !in_code_block) {
      const level = heading_match[1].length;
      let title = heading_match[2].trim();
      while (heading_stack.length > 0 && heading_stack[heading_stack.length - 1].level >= level) {
        const finished_heading = heading_stack.pop();
        if (heading_lines[finished_heading.key][1] === null) {
          heading_lines[finished_heading.key][1] = line_number - 1;
        }
      }
      if (heading_stack.length === 0 && heading_lines[root_heading_key] && heading_lines[root_heading_key][1] === null) {
        heading_lines[root_heading_key][1] = line_number - 1;
      }
      if (current_content_block) {
        if (heading_lines[current_content_block.key][1] === null) {
          heading_lines[current_content_block.key][1] = line_number - 1;
        }
        current_content_block = null;
      }
      if (current_list_item) {
        if (heading_lines[current_list_item.key][1] === null) {
          heading_lines[current_list_item.key][1] = line_number - 1;
        }
        current_list_item = null;
      }
      let parent_key = "";
      let parent_level = 0;
      if (heading_stack.length > 0) {
        parent_key = heading_stack[heading_stack.length - 1].key;
        parent_level = heading_stack[heading_stack.length - 1].level;
      } else {
        parent_key = "";
        parent_level = 0;
      }
      if (heading_stack.length === 0) {
        heading_counts[title] = (heading_counts[title] || 0) + 1;
        if (heading_counts[title] > 1) {
          title += `[${heading_counts[title]}]`;
        }
      } else {
        if (!subheading_counts[parent_key]) {
          subheading_counts[parent_key] = {};
        }
        subheading_counts[parent_key][title] = (subheading_counts[parent_key][title] || 0) + 1;
        const count = subheading_counts[parent_key][title];
        if (count > 1) {
          title += `#{${count}}`;
        }
      }
      const level_diff = level - parent_level;
      const hashes = "#".repeat(level_diff);
      const key = parent_key + hashes + title;
      heading_lines[key] = [line_number, null];
      sub_block_counts[key] = 0;
      heading_stack.push({ level, title, key });
      continue;
    }
    const list_match = line.match(/^(\s*)([-*]|\d+\.) (.+)$/);
    if (list_match && !in_code_block) {
      const indentation = list_match[1].length;
      if (indentation === 0) {
        if (current_list_item) {
          if (heading_lines[current_list_item.key][1] === null) {
            heading_lines[current_list_item.key][1] = line_number - 1;
          }
          current_list_item = null;
        }
        if (current_content_block && current_content_block.key !== root_heading_key) {
          if (heading_lines[current_content_block.key][1] === null) {
            heading_lines[current_content_block.key][1] = line_number - 1;
          }
          current_content_block = null;
        }
        let parent_key = heading_stack.length > 0 ? heading_stack[heading_stack.length - 1].key : root_heading_key;
        if (parent_key === root_heading_key && !heading_lines[root_heading_key]) {
          heading_lines[root_heading_key] = [line_number, null];
        }
        if (sub_block_counts[parent_key] === void 0) {
          sub_block_counts[parent_key] = 0;
        }
        sub_block_counts[parent_key] += 1;
        const n = sub_block_counts[parent_key];
        let key;
        if (line_keys) {
          const content_without_task = list_match[3].replace(/^\[(?: |x|X)\]\s*/, "");
          const words = get_longest_words_in_order(content_without_task, 10);
          key = `${parent_key}#${words}`;
        } else {
          key = `${parent_key}#{${n}}`;
        }
        heading_lines[key] = [line_number, null];
        current_list_item = { key, start_line: line_number };
        continue;
      }
      if (current_list_item) {
        continue;
      }
    }
    if (trimmed_line === "") {
      continue;
    }
    if (!current_content_block) {
      if (current_list_item) {
        if (heading_lines[current_list_item.key][1] === null) {
          heading_lines[current_list_item.key][1] = line_number - 1;
        }
        current_list_item = null;
      }
      let parent_key = heading_stack.length > 0 ? heading_stack[heading_stack.length - 1].key : root_heading_key;
      if (parent_key === root_heading_key) {
        if (!heading_lines[root_heading_key]) {
          heading_lines[root_heading_key] = [line_number, null];
        }
        if (heading_lines[root_heading_key][1] === null || heading_lines[root_heading_key][1] < line_number) {
          heading_lines[root_heading_key][1] = null;
        }
        current_content_block = { key: root_heading_key, start_line: line_number };
      } else {
        if (sub_block_counts[parent_key] === void 0) {
          sub_block_counts[parent_key] = 0;
        }
        sub_block_counts[parent_key] += 1;
        const n = sub_block_counts[parent_key];
        const key = `${parent_key}#{${n}}`;
        heading_lines[key] = [line_number, null];
        current_content_block = { key, start_line: line_number };
      }
    }
  }
  const total_lines = lines.length;
  while (heading_stack.length > 0) {
    const finished_heading = heading_stack.pop();
    if (heading_lines[finished_heading.key][1] === null) {
      heading_lines[finished_heading.key][1] = total_lines + start_index - 1;
    }
  }
  if (current_list_item) {
    if (heading_lines[current_list_item.key][1] === null) {
      heading_lines[current_list_item.key][1] = total_lines + start_index - 1;
    }
    current_list_item = null;
  }
  if (current_content_block) {
    if (heading_lines[current_content_block.key][1] === null) {
      heading_lines[current_content_block.key][1] = total_lines + start_index - 1;
    }
    current_content_block = null;
  }
  if (heading_lines[root_heading_key] && heading_lines[root_heading_key][1] === null) {
    heading_lines[root_heading_key][1] = total_lines + start_index - 1;
  }
  for (const key in heading_lines) {
    result[key] = heading_lines[key];
  }
  return { blocks: result, task_lines };
}
function get_longest_words_in_order(line, n = 3) {
  const words = line.split(/\s+/).sort((a, b) => b.length - a.length).slice(0, n);
  return words.sort((a, b) => line.indexOf(a) - line.indexOf(b)).join(" ");
}

// node_modules/obsidian-smart-env/node_modules/smart-sources/adapters/_file.js
var FileSourceContentAdapter = class extends SourceContentAdapter {
  static async init_items(collection) {
    if (collection.fs_items_initialized) return;
    collection._fs = null;
    await collection.fs.init();
    await collection.init_fs();
    for (const file of Object.values(collection.fs.files)) {
      const item = collection.init_file_path(file.path);
      if (item) item.init_file_mtime = file.stat.mtime;
    }
    collection.fs_items_initialized = Date.now();
  }
  /**
   * @name fs
   * @type {Object}
   * @readonly
   * @description
   * Access the file system interface used by this adapter. Typically derived
   * from `this.item.collection.fs`.
   */
  get fs() {
    return this.item.collection.fs;
  }
  /**
   * @name file_path
   * @type {string}
   * @readonly
   * @description
   * The file path on disk corresponding to the source. Used for read/write operations.
   */
  get file_path() {
    return this.item.file_path;
  }
  /**
   * @async
   * @method create
   * @param {string|null} [content=null] Initial content for the new file.
   * @description
   * Create a new file on disk. If content is not provided, attempts to use
   * `this.item.data.content` as fallback.
   */
  async create(content = null) {
    if (!content) content = this.item.data.content || "";
    await this.fs.write(this.file_path, content);
  }
  /**
   * @async
   * @method update
   * @param {string} content The full new content to write to the file.
   * @description
   * Overwrite the entire file content on disk.
   */
  async update(content) {
    await this.fs.write(this.file_path, content);
  }
  /**
   * @async
   * @method read
   * @returns {Promise<string>} The content of the file.
   * @description
   * Read the file content from disk. Updates `last_read` hash and timestamp on the entity’s data.
   * If file is large or special handling is needed, override this method.
   */
  async read() {
    const content = await this.fs.read(this.file_path);
    this.data.last_read = {
      hash: this.create_hash(content || ""),
      at: Date.now()
    };
    return content;
  }
  /**
   * @async
   * @method remove
   * @returns {Promise<void>}
   * @description
   * Delete the file from disk. After removal, the source item should also be deleted or updated accordingly.
   */
  async remove() {
    await this.fs.remove(this.file_path);
  }
  async move_to(move_to_ref) {
    if (!move_to_ref) {
      throw new Error("Invalid entity reference for move_to operation");
    }
    const move_content = await this.read();
    let has_existing = false;
    if (typeof move_to_ref === "string") {
      const existing = this.item.collection.get(move_to_ref);
      if (existing) {
        move_to_ref = existing;
        has_existing = true;
      }
    } else {
      has_existing = true;
    }
    if (has_existing) {
      await move_to_ref.append(move_content);
    } else {
      move_to_ref = await this.item.collection.create(move_to_ref, move_content);
    }
    if (this.item.key !== move_to_ref.key) {
      await this.remove();
      this.item.delete();
    } else {
      console.log(`did not delete ${this.item.key} because it was moved to ${move_to_ref.key}`);
    }
    return move_to_ref;
  }
  /**
   * TRANSFERRED FROM markdown.js (2024-12-13)
   * TODO NEEDS REVIEW/REFACTOR
   */
  async move_to_v1(entity_ref) {
    const new_path = typeof entity_ref === "string" ? entity_ref : entity_ref.key;
    if (!new_path) {
      throw new Error("Invalid entity reference for move_to operation");
    }
    const current_content = await this.read();
    const [target_source_key, ...headings] = new_path.split("#");
    const target_source = this.item.collection.get(target_source_key);
    if (headings.length > 0) {
      const new_headings_content = this.construct_headings(headings);
      const new_content = `${new_headings_content}
${current_content}`;
      await this._update(new_content);
    }
    if (target_source) {
      await this.merge(current_content, { mode: "append_blocks" });
    } else {
      await this.rename_and_import(target_source_key, current_content);
    }
    if (this.item.key !== target_source_key) await this.remove();
  }
  construct_headings(headings) {
    return headings.map((heading, i) => `${"#".repeat(i + 1)} ${heading}`).join("\n");
  }
  async rename_and_import(target_source_key, content) {
    await this.fs.rename(this.file_path, target_source_key);
    const new_source = await this.item.collection.create_or_update({ path: target_source_key, content });
    await new_source.import();
  }
  /**
   * Merge content into the source
   * @param {string} content - The content to merge into the source
   * @param {Object} opts - Options for the merge operation
   * @param {string} opts.mode - The mode to use for the merge operation. Defaults to 'append_blocks' (may also be 'replace_blocks')
   */
  async merge(content, opts = {}) {
    const { mode = "append_blocks" } = opts;
    const { blocks: blocks_obj, task_lines } = parse_markdown_blocks(content);
    if (typeof blocks_obj !== "object" || Array.isArray(blocks_obj)) {
      console.warn("merge error: Expected an object from parse_markdown_blocks, but received:", blocks_obj);
      throw new Error("merge error: parse_markdown_blocks did not return an object as expected.");
    }
    const { new_blocks, new_with_parent_blocks, changed_blocks, same_blocks } = await this.get_changes(blocks_obj, content);
    for (const block of new_blocks) {
      await this.append(block.content);
    }
    for (const block of new_with_parent_blocks) {
      const parent_block = this.item.block_collection.get(block.parent_key);
      await parent_block.append(block.content);
    }
    for (const block of changed_blocks) {
      const changed_block = this.item.block_collection.get(block.key);
      if (mode === "replace_blocks") {
        await changed_block.update(block.content);
      } else {
        await changed_block.append(block.content);
      }
    }
  }
  async get_changes(blocks_obj, content) {
    const new_blocks = [];
    const new_with_parent_blocks = [];
    const changed_blocks = [];
    const same_blocks = [];
    const existing_blocks = this.source.data.blocks || {};
    for (const [sub_key, line_range] of Object.entries(blocks_obj)) {
      const has_existing = !!existing_blocks[sub_key];
      const block_key = `${this.source.key}${sub_key}`;
      const block_content = get_line_range(content, line_range[0], line_range[1]);
      if (!has_existing) {
        new_blocks.push({
          key: block_key,
          state: "new",
          content: block_content
        });
        continue;
      }
      let has_parent;
      let headings = sub_key.split("#");
      let parent_key;
      while (!has_parent && headings.length > 0) {
        headings.pop();
        parent_key = headings.join("#");
        has_parent = !!existing_blocks[parent_key];
      }
      if (has_parent) {
        new_with_parent_blocks.push({
          key: block_key,
          parent_key: `${this.source.key}${parent_key}`,
          state: "new",
          content: block_content
        });
        continue;
      }
      const block = this.item.block_collection.get(block_key);
      const content_hash = await this.create_hash(block_content);
      if (content_hash !== block.last_read?.hash) {
        changed_blocks.push({
          key: block_key,
          state: "changed",
          content: block_content
        });
        continue;
      }
      same_blocks.push({
        key: block_key,
        state: "same",
        content: block_content
      });
    }
    return {
      new_blocks,
      new_with_parent_blocks,
      changed_blocks,
      same_blocks
    };
  }
  /**
   * Append new content to the source file, placing it at the end of the file.
   * @async
   * @param {string} content - The content to append.
   * @returns {Promise<void>}
   */
  async append(content) {
    const current_content = await this.read();
    const new_content = [
      current_content,
      "",
      content
    ].join("\n").trim();
    await this.update(new_content);
  }
  get size() {
    return this.item.file?.stat?.size || 0;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/utils/get_markdown_links.js
function get_markdown_links(content) {
  const result = [];
  const markdown_link_re = /\[([^\]]+?)\]\(([^)]+?)\)/g;
  const wikilink_re = /\[\[([^\|\]]+?)(?:\|([^\]]+?))?\]\]/g;
  const normalise_target = (raw) => {
    const trimmed = raw.trim();
    if (/^[a-zA-Z][\w+\-.]*:\/\//.test(trimmed)) return trimmed;
    try {
      return decodeURIComponent(trimmed);
    } catch (_) {
      return trimmed.replace(/%20/gi, " ");
    }
  };
  let m;
  while ((m = markdown_link_re.exec(content)) !== null) {
    const title = m[1];
    const target = normalise_target(m[2]);
    const line_no = content.slice(0, m.index).split("\n").length;
    result.push({ title, target, line: line_no });
  }
  while ((m = wikilink_re.exec(content)) !== null) {
    const target_raw = m[1];
    const title = m[2] || target_raw;
    const target = normalise_target(target_raw);
    const line_no = content.slice(0, m.index).split("\n").length;
    result.push({ title, target, line: line_no });
  }
  return result.sort(
    (a, b) => a.line - b.line || a.target.localeCompare(b.target)
  );
}

// node_modules/obsidian-smart-env/node_modules/smart-sources/utils/parse_frontmatter.js
function parse_value(raw_value) {
  const trimmed = raw_value.trim();
  if (trimmed.startsWith('"') && trimmed.endsWith('"') || trimmed.startsWith("'") && trimmed.endsWith("'")) {
    return trimmed.slice(1, -1);
  }
  const lower = trimmed.toLowerCase();
  if (lower === "true") return true;
  if (lower === "false") return false;
  if (!isNaN(trimmed) && trimmed !== "") {
    return Number(trimmed);
  }
  return trimmed;
}
function parse_yaml_block(yaml_block) {
  const lines = yaml_block.split(/\r?\n/);
  const data = {};
  let i = 0;
  while (i < lines.length) {
    const line = lines[i];
    i++;
    if (!line.trim() || line.trim().startsWith("#")) {
      continue;
    }
    const match = line.match(/^([^:]+)\s*:\s*(.*)$/);
    if (!match) {
      continue;
    }
    const key = match[1].trim();
    let value = match[2].trim();
    if (value === ">" || value === "|") {
      const multiline_lines = [];
      while (i < lines.length) {
        const next_line = lines[i];
        if (!/^\s+/.test(next_line) || next_line.trim().startsWith("#")) {
          break;
        }
        multiline_lines.push(next_line.replace(/^\s+/, ""));
        i++;
      }
      const joined = multiline_lines.join("\n");
      data[key] = parse_value(joined);
    } else if (value === "") {
      const arr = [];
      let array_consumed = false;
      while (i < lines.length) {
        const next_line = lines[i];
        if (!next_line.trim().startsWith("- ")) {
          break;
        }
        const item_value = next_line.trim().slice(2);
        arr.push(parse_value(item_value));
        i++;
        array_consumed = true;
      }
      if (array_consumed) {
        data[key] = arr;
      } else {
        data[key] = "";
      }
    } else {
      data[key] = parse_value(value);
    }
  }
  return data;
}
function parse_frontmatter(content) {
  if (!content.startsWith("---")) {
    return { frontmatter: {}, body: content };
  }
  const lines = content.split(/\r?\n/);
  let end_index = -1;
  for (let i = 1; i < lines.length; i++) {
    if (lines[i].trim() === "---") {
      end_index = i;
      break;
    }
  }
  if (end_index === -1) {
    return { frontmatter: {}, body: content };
  }
  const frontmatter_lines = lines.slice(1, end_index);
  const frontmatter_block = frontmatter_lines.join("\n");
  const frontmatter = parse_yaml_block(frontmatter_block);
  const body_lines = lines.slice(end_index + 1);
  const body = body_lines.join("\n");
  return { frontmatter, body };
}

// node_modules/obsidian-smart-env/node_modules/smart-sources/utils/get_markdown_tags.js
var get_markdown_tags = (content = "") => {
  const tag_re = /(?<!\w)#([\w/-]+)/g;
  const tags = /* @__PURE__ */ new Set();
  let match;
  while ((match = tag_re.exec(content)) !== null) {
    tags.add(`#${match[1]}`);
  }
  return [...tags];
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/adapters/markdown_source.js
var MarkdownSourceContentAdapter = class extends FileSourceContentAdapter {
  static extensions = ["md", "txt"];
  /**
   * Import the source file content, parse blocks and links, and update `item.data`.
   * @async
   * @returns {Promise<void>}
   */
  async import() {
    if (!this.can_import) return;
    if (!this.outdated) {
      this.item.blocks.forEach((block) => {
        if (!block.vec) block.queue_embed();
      });
      return;
    }
    const content = await this.read();
    if (!content) {
      return;
    }
    if (!this.item.vec) {
      this.item.data.last_import = null;
    }
    if (this.data.last_import?.hash === this.data.last_read?.hash) {
      if (this.data.blocks) return;
    }
    this.data.blocks = null;
    await this.parse_content(content);
    await this.item.parse_content(content);
    const { mtime, size } = this.item.file.stat;
    this.data.last_import = {
      mtime,
      size,
      at: Date.now(),
      hash: this.data.last_read.hash
    };
    this.item.loaded_at = Date.now();
    this.item.queue_save();
    if (this.item.should_embed) this.item.queue_embed();
  }
  // // WIP: move block parsing here
  // async read() {
  //   const current_last_read_hash = this.data.last_read?.hash;
  //   const content = await super.read();
  //   if(!content) return console.warn(`MarkdownSourceContentAdapter: Skipping missing-file: ${this.file_path}`);
  //   if(current_last_read_hash === this.data.last_read?.hash) return content;
  //   const {blocks: blocks, task_lines} = parse_markdown_blocks(content);
  //   this.handle_excluded_headings(blocks);
  // }
  // Runs before configured content_parsers (for example, templates uses outlinks)
  async parse_content(content) {
    const outlinks = await this.get_links(content);
    this.data.outlinks = outlinks;
    const metadata = await this.get_metadata(content);
    this.data.metadata = metadata;
  }
  async get_links(content = null) {
    if (!content) content = await this.read();
    if (!content) return;
    return get_markdown_links(content);
  }
  async get_metadata(content = null) {
    if (!content) content = await this.read();
    if (!content) return;
    const { frontmatter, body } = parse_frontmatter(content);
    const tag_set = /* @__PURE__ */ new Set();
    let fm_tags = frontmatter.tags;
    if (typeof fm_tags === "string") {
      fm_tags = fm_tags.replace(/[\[\]]/g, "").split(",").map((t) => t.trim()).filter(Boolean);
    }
    if (Array.isArray(fm_tags)) {
      fm_tags.forEach((tag) => tag_set.add(tag.startsWith("#") ? tag : `#${tag}`));
    }
    get_markdown_tags(body).forEach((tag) => tag_set.add(tag));
    if (tag_set.size) frontmatter.tags = [...tag_set];
    return frontmatter;
  }
  // Erroneous reasons to skip import (logs to console)
  get can_import() {
    if (!this.item.file) {
      console.warn(`MarkdownSourceContentAdapter: Skipping missing-file: ${this.file_path}`);
      return false;
    }
    if (this.item.size > (this.settings?.max_import_size || 3e5)) {
      console.warn(`MarkdownSourceContentAdapter: Skipping large file: ${this.file_path}`);
      return false;
    }
    return true;
  }
  /**
   * @deprecated use outdated instead
   */
  get should_import() {
    return this.outdated;
  }
  get outdated() {
    try {
      if (!this.data.last_import) {
        if (this.data.mtime && this.data.size && this.data.hash) {
          this.data.last_import = {
            mtime: this.data.mtime,
            size: this.data.size,
            at: Date.now(),
            hash: this.data.hash
          };
          delete this.data.mtime;
          delete this.data.size;
          delete this.data.hash;
        } else {
          return true;
        }
      }
      if (this.data.last_read.at > this.data.last_import.at) {
        if (this.data.last_import?.hash !== this.data.last_read?.hash) return true;
      }
      if (this.data.last_import.mtime < this.item.mtime) {
        if (!this.data.last_import.size) return true;
        const size_diff = Math.abs(this.data.last_import.size - this.item.size);
        const size_diff_ratio = size_diff / (this.data.last_import.size || 1);
        if (size_diff_ratio > 0.01) return true;
      }
      return false;
    } catch (e) {
      console.warn(`MarkdownSourceContentAdapter: error getting should_import for ${this.file_path}: ${e}`);
      return true;
    }
  }
};

// node_modules/obsidian-smart-env/adapters/smart-sources/obsidian_markdown.js
var import_obsidian2 = require("obsidian");
function merge_tags(fm_tags, cache_tags = []) {
  const tag_set = /* @__PURE__ */ new Set();
  if (typeof fm_tags === "string") {
    fm_tags = fm_tags.replace(/[\[\]]/g, "").split(",").map((t) => t.trim()).filter(Boolean);
  }
  if (Array.isArray(fm_tags)) {
    fm_tags.forEach((tag) => tag_set.add(tag.startsWith("#") ? tag : `#${tag}`));
  }
  cache_tags.forEach(({ tag }) => tag_set.add(tag));
  return [...tag_set];
}
var ObsidianMarkdownSourceContentAdapter = class extends MarkdownSourceContentAdapter {
  /**
   * Returns metadata using Obsidian's metadataCache, merging frontmatter and tags.
   * @async
   * @returns {Promise<Object|undefined>}
   */
  async get_metadata() {
    const app2 = this.item.env.main.app;
    const cache = app2.metadataCache.getFileCache(this.item.file) || {};
    const tags = merge_tags(cache.frontmatter?.tags, cache.tags);
    if (cache.frontmatter) {
      if (tags.length) cache.frontmatter.tags = tags;
      return cache.frontmatter;
    }
    return tags.length ? { tags } : void 0;
  }
  /**
   * Reads the file content. If opts.render_output is true, attempts to use
   * Obsidian's MarkdownRenderer to render the file to HTML, then convert it
   * back to markdown via htmlToMarkdown.
   * @async
   * @param {Object} [opts={}] - Options for reading.
   * @param {boolean} [opts.render_output=false] - If true, render MD -> HTML -> MD.
   * @returns {Promise<string>} The file content (possibly rendered).
   */
  async read(opts = {}) {
    const content = await super.read(opts);
    if (!opts.render_output) {
      return content;
    }
    const app2 = this.item.env.main.app;
    if (!app2 || !import_obsidian2.MarkdownRenderer || !import_obsidian2.htmlToMarkdown) {
      console.warn("Obsidian environment not found; cannot render markdown.");
      return content;
    }
    const container = document.createElement("div");
    await import_obsidian2.MarkdownRenderer.render(app2, content, container, this.item.path, new import_obsidian2.Component());
    let last_html = container.innerHTML;
    const max_wait = 1e4;
    let wait_time = 0;
    let conseq_same = 0;
    let changed = true;
    while (conseq_same < 7) {
      await new Promise((resolve) => setTimeout(resolve, 100));
      changed = last_html !== container.innerHTML;
      last_html = container.innerHTML;
      if (!changed) conseq_same++;
      else conseq_same = 0;
      wait_time += 100;
      if (wait_time > max_wait) {
        console.warn("ObsidianMarkdownSourceContentAdapter: Timeout waiting for markdown to render.");
        break;
      }
    }
    const newMd = (0, import_obsidian2.htmlToMarkdown)(container);
    return newMd;
  }
};

// node_modules/obsidian-smart-env/adapters/smart-sources/bases.js
var BasesSourceContentAdapter = class extends FileSourceContentAdapter {
  static extensions = ["base"];
  async import() {
  }
};

// node_modules/obsidian-smart-env/adapters/smart-sources/excalidraw.js
var ExcalidrawSourceContentAdapter = class extends ObsidianMarkdownSourceContentAdapter {
  static extensions = ["excalidraw.md"];
  is_media = true;
  // Excalidraw files are treated as media for rendering
  async read(opts = {}) {
    const full_content = await super.read(opts);
    const BEGIN_LINE_MATCHER = "# Text Elements";
    const END_LINE_MATCHER = "# Drawing";
    const text_elements_start = full_content.indexOf(BEGIN_LINE_MATCHER);
    const drawing_lines_start = full_content.indexOf(END_LINE_MATCHER);
    if (text_elements_start === -1 || drawing_lines_start === -1) {
      console.warn("Excalidraw file does not contain expected sections. File: " + this.item.key);
      this.item.data.last_read.size = 0;
      return "";
    }
    const text_content = full_content.slice(text_elements_start + BEGIN_LINE_MATCHER.length, drawing_lines_start).trim();
    const stripped_refs = text_content.split("\n").map((line) => {
      if (line.trim() === "%%") return "";
      if (line.trim() === "#") return "";
      return line.replace(/\^[a-z0-9]+$/i, "").trim();
    }).filter(Boolean).join("\n");
    this.item.data.last_read.size = stripped_refs.length;
    return stripped_refs;
  }
  get size() {
    if (this.item.data?.last_read?.size) {
      return this.item.data.last_read.size;
    }
    return this.file?.stat?.size || 0;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-blocks/utils/get_block_display_name.js
function get_block_display_name(key, show_full_path) {
  const [source_key, ...path_parts] = key.split("#").filter(Boolean);
  const source_name = get_item_display_name(source_key, show_full_path);
  if (show_full_path) return [source_name, ...path_parts].join(" > ");
  const last_heading = path_parts.findLast((part) => part && part[0] !== "{");
  return [source_name, last_heading].join(" > ");
}

// node_modules/obsidian-smart-env/node_modules/smart-blocks/smart_block.js
var SmartBlock = class extends SmartEntity {
  /**
   * Provides default values for a SmartBlock instance.
   * @static
   * @readonly
   * @returns {Object} The default values.
   */
  static get defaults() {
    return {
      data: {
        text: null,
        length: 0,
        last_read: {
          hash: null,
          at: 0
        }
      },
      _embed_input: ""
      // Stored temporarily
    };
  }
  get block_adapter() {
    if (!this._block_adapter) {
      this._block_adapter = new this.collection.opts.block_adapters.md(this);
    }
    return this._block_adapter;
  }
  /**
   * Initializes the SmartBlock instance by queuing an embed if embedding is enabled.
   * @returns {void}
   */
  init() {
    if (this.settings.embed_blocks) super.init();
  }
  /**
   * Queues the entity for embedding.
   * @returns {void}
   */
  queue_embed() {
    this._queue_embed = this.should_embed;
    this.source?.queue_embed();
  }
  /**
   * Queues the block for import via the source.
   * @returns {void}
   */
  queue_import() {
    this.source?.queue_import();
  }
  /**
   * Updates the block's data, clearing embeddings if necessary and preparing embed input.
   * @param {Object} data - The new data to merge into the block.
   * @returns {boolean} `true` if data was updated successfully.
   */
  update_data(data) {
    if (this.should_clear_embeddings(data)) {
      this.data.embeddings = {};
    }
    super.update_data(data);
    return true;
  }
  /**
   * Determines whether to clear embeddings based on the new data.
   * @param {Object} data - The new data to evaluate.
   * @returns {boolean} `true` if embeddings should be cleared, `false` otherwise.
   */
  should_clear_embeddings(data) {
    if (this.is_new) return true;
    if (this.embed_model && this.vec?.length !== this.embed_model.model_config.dims) return true;
    return false;
  }
  /**
   * Prepares the embed input for the SmartBlock by reading content and generating a hash.
   * @async
   * @returns {Promise<string|false>} The embed input string or `false` if already embedded.
   */
  async get_embed_input(content = null) {
    if (typeof this._embed_input !== "string" || !this._embed_input.length) {
      if (!content) content = await this.read();
      this._embed_input = this.breadcrumbs + "\n" + content;
    }
    return this._embed_input;
  }
  // CRUD
  /**
   * @method read
   * @description Reads the block content by delegating to the block adapter.
   * @async
   * @returns {Promise<string>} The block content.
   */
  async read() {
    try {
      return await this.block_adapter.read();
    } catch (e) {
      if (e.message.includes("BLOCK NOT FOUND")) {
        return 'BLOCK NOT FOUND (run "Prune" to remove)';
      } else {
        throw e;
      }
    }
  }
  /**
   * @method append
   * @description Appends content to this block by delegating to the block adapter.
   * @async
   * @param {string} content
   * @returns {Promise<void>}
   */
  async append(content) {
    await this.block_adapter.append(content);
    this.queue_save();
  }
  /**
   * @method update
   * @description Updates the block content by delegating to the block adapter.
   * @async
   * @param {string} new_block_content
   * @param {Object} [opts={}]
   * @returns {Promise<void>}
   */
  async update(new_block_content, opts = {}) {
    await this.block_adapter.update(new_block_content, opts);
    this.queue_save();
  }
  /**
   * @method remove
   * @description Removes the block by delegating to the block adapter.
   * @async
   * @returns {Promise<void>}
   */
  async remove() {
    await this.block_adapter.remove();
    this.queue_save();
  }
  /**
   * @method move_to
   * @description Moves the block to another location by delegating to the block adapter.
   * @async
   * @param {string} to_key
   * @returns {Promise<void>}
   */
  async move_to(to_key) {
    await this.block_adapter.move_to(to_key);
    this.queue_save();
  }
  // Getters
  /**
   * Retrieves the breadcrumbs representing the block's path within the source.
   * @readonly
   * @returns {string} The breadcrumbs string.
   */
  get breadcrumbs() {
    return this.key.split("/").join(" > ").split("#").slice(0, -1).join(" > ").replace(".md", "");
  }
  /**
   * Determines if the block is excluded from embedding based on headings.
   * @readonly
   * @returns {boolean} `true` if excluded, `false` otherwise.
   */
  get excluded() {
    const block_headings = this.path.split("#").slice(1);
    if (this.source_collection.excluded_headings.some((heading) => block_headings.includes(heading))) return true;
    return this.source?.excluded;
  }
  /**
   * Retrieves the file path of the SmartSource associated with the block.
   * @readonly
   * @returns {string} The file path.
   */
  get file_path() {
    return this.source?.file_path;
  }
  /**
   * Retrieves the file type of the SmartSource associated with the block.
   * @readonly
   * @returns {string} The file type.
   */
  get file_type() {
    return this.source.file_type;
  }
  /**
   * Retrieves the folder path of the block.
   * @readonly
   * @returns {string} The folder path.
   */
  get folder() {
    return this.path.split("/").slice(0, -1).join("/");
  }
  /**
   * Retrieves the embed link for the block.
   * @readonly
   * @returns {string} The embed link.
   */
  get embed_link() {
    return `![[${this.link}]]`;
  }
  /**
   * Determines if the block has valid line range information.
   * @readonly
   * @returns {boolean} `true` if the block has both start and end lines, `false` otherwise.
   */
  get has_lines() {
    return this.lines && this.lines.length === 2;
  }
  /**
   * Determines if the entity is a block based on its key.
   * @readonly
   * @returns {boolean} `true` if it's a block, `false` otherwise.
   */
  get is_block() {
    return this.key.includes("#");
  }
  /**
   * Determines if the block is gone (i.e., the source file or block data no longer exists).
   * @readonly
   * @returns {boolean} `true` if gone, `false` otherwise.
   */
  get is_gone() {
    if (!this.source?.file) return true;
    if (!this.source?.data?.blocks?.[this.sub_key]) return true;
    return false;
  }
  get last_read() {
    return this.data.last_read;
  }
  /**
   * Retrieves the sub-key of the block.
   * @readonly
   * @returns {string} The sub-key.
   */
  get sub_key() {
    return "#" + this.key.split("#").slice(1).join("#");
  }
  /**
   * Retrieves the lines range of the block.
   * @readonly
   * @returns {Array<number>|undefined} An array containing the start and end lines or `undefined` if not set.
   */
  // get lines() { return this.source?.data?.blocks?.[this.sub_key]; }
  get lines() {
    return this.data.lines;
  }
  /**
   * Retrieves the starting line number of the block.
   * @readonly
   * @returns {number|undefined} The starting line number or `undefined` if not set.
   */
  get line_start() {
    return this.lines?.[0];
  }
  /**
   * Retrieves the ending line number of the block.
   * @readonly
   * @returns {number|undefined} The ending line number or `undefined` if not set.
   */
  get line_end() {
    return this.lines?.[1];
  }
  /**
   * Retrieves the link associated with the block, handling page numbers if present.
   * @readonly
   * @returns {string} The block link.
   */
  get link() {
    if (/^.*page\s*(\d+).*$/i.test(this.sub_key)) {
      const number = this.sub_key.match(/^.*page\s*(\d+).*$/i)[1];
      return `${this.source.path}#page=${number}`;
    } else {
      return this.source?.path || "MISSING SOURCE";
    }
  }
  // uses data.lines to get next block
  get next_block() {
    if (!this.data.lines) return null;
    const next_line = this.data.lines[1] + 1;
    return this.source.blocks?.find((block) => next_line === block.data?.lines?.[0]);
  }
  /**
   * Retrieves the paths of outlinks from the block.
   * @readonly
   * @returns {Array<string>} An array of outlink paths.
   */
  get outlinks() {
    return this.source.outlinks;
  }
  /**
   * Retrieves the path of the SmartBlock.
   * @readonly
   * @returns {string} The path of the SmartBlock.
   */
  get path() {
    return this.key;
  }
  /**
   * Determines if the block should be embedded based on its coverage and size.
   * @readonly
   * @returns {boolean} `true` if it should be embedded, `false` otherwise.
   */
  get should_embed() {
    try {
      if (this.settings?.min_chars && this.size < this.settings.min_chars) return false;
      const match_line_start = this.line_start + 1;
      const match_line_end = this.line_end;
      const { has_line_start, has_line_end } = Object.entries(this.source?.data?.blocks || {}).reduce((acc, [key, range]) => {
        if (!key.startsWith(this.sub_key + "#")) return acc;
        if (range[0] === match_line_start) acc.has_line_start = key;
        if (range[1] === match_line_end) acc.has_line_end = key;
        return acc;
      }, { has_line_start: null, has_line_end: null });
      if (has_line_start && has_line_end) {
        const start_block = this.collection.get(this.source_key + has_line_start);
        if (start_block?.should_embed) {
          const end_block = this.collection.get(this.source_key + has_line_end);
          if (end_block?.should_embed) return false;
        }
      }
      return true;
    } catch (e) {
      console.error(e, e.stack);
      console.error(`Error getting should_embed for ${this.key}: ` + JSON.stringify(e || {}, null, 2));
    }
  }
  /**
   * Retrieves the size of the SmartBlock.
   * @readonly
   * @returns {number} The size of the SmartBlock.
   */
  get size() {
    return this.data.size;
  }
  /**
   * Retrieves the SmartSource associated with the block.
   * @readonly
   * @returns {SmartSource} The associated SmartSource instance.
   */
  get source() {
    return this.source_collection.get(this.source_key);
  }
  /**
   * Retrieves the SmartSources collection instance.
   * @readonly
   * @returns {SmartSources} The SmartSources collection.
   */
  get source_collection() {
    return this.env.smart_sources;
  }
  get source_key() {
    return this.key.split("#")[0];
  }
  get sub_blocks() {
    return this.source?.blocks?.filter((block) => block.key.startsWith(this.key + "#") && block.line_start > this.line_start && block.line_end <= this.line_end) || [];
  }
  // source dependent
  get excluded_lines() {
    return this.source.excluded_lines;
  }
  get file() {
    return this.source.file;
  }
  get is_media() {
    return this.source.is_media;
  }
  get mtime() {
    return this.source.mtime;
  }
  // DEPRECATED
  /**
   * Retrieves the display name of the block.
   * @readonly
   * @returns {string} The display name.
   */
  get name() {
    return get_block_display_name(
      this.key,
      this.env.settings.smart_view_filter?.show_full_path
    );
  }
  /**
   * @deprecated Use `source` instead. Removing after 2025-09-01.
   * @readonly
   * @returns {SmartSource} The associated SmartSource instance.
   */
  get note() {
    return this.source;
  }
  /**
   * @deprecated Use `source.key` instead. Removing after 2025-09-01.
   * @readonly
   * @returns {string} The source key.
   */
  get note_key() {
    return this.key.split("#")[0];
  }
};
var smart_block_default = {
  class: SmartBlock,
  actions: {
    find_connections
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-blocks/smart_blocks.js
var SmartBlocks = class extends SmartEntities {
  /**
   * Initializes the SmartBlocks instance. Currently muted as processing is handled by SmartSources.
   * @returns {void}
   */
  init() {
  }
  get fs() {
    return this.env.smart_sources.fs;
  }
  /**
   * Retrieves the embedding model associated with the SmartSources collection.
   * @readonly
   * @returns {Object|undefined} The embedding model instance or `undefined` if not set.
   */
  get embed_model() {
    return this.source_collection?.embed_model;
  }
  /**
   * Retrieves the embedding model key from the SmartSources collection.
   * @readonly
   * @returns {string|undefined} The embedding model key or `undefined` if not set.
   */
  get embed_model_key() {
    return this.source_collection?.embed_model_key;
  }
  /**
   * Calculates the expected number of blocks based on the SmartSources collection.
   * @readonly
   * @returns {number} The expected count of blocks.
   */
  get expected_blocks_ct() {
    return Object.values(this.source_collection.items).reduce((acc, item) => acc += Object.keys(item.data.blocks || {}).length, 0);
  }
  /**
   * Retrieves the notices system from the environment.
   * @readonly
   * @returns {Object} The notices object.
   */
  get notices() {
    return this.env.smart_connections_plugin?.notices || this.env.main?.notices;
  }
  /**
   * Retrieves the settings configuration for SmartBlocks.
   * @readonly
   * @returns {Object} The settings configuration object.
   */
  get settings_config() {
    return this.process_settings_config({
      "embed_blocks": {
        name: "Utilize Smart Blocks",
        type: "toggle",
        description: "Creates more granular embeddings by splitting sources into smaller chunks. This may improve search results especially for large documents that have well-defined sections.",
        default: true
      },
      ...super.settings_config
    });
  }
  render_settings(container, opts = {}) {
    return this.render_collection_settings(container, opts);
  }
  get data_dir() {
    return "multi";
  }
  /**
   * Retrieves the SmartSources collection instance.
   * @readonly
   * @returns {SmartSources} The SmartSources collection.
   */
  get source_collection() {
    return this.env.smart_sources;
  }
  /**
   * Processes the embed queue. Currently handled by SmartSources, so this method is muted.
   * @async
   * @returns {Promise<void>}
   */
  async process_embed_queue() {
  }
  /**
   * Processes the load queue. Currently muted as processing is handled by SmartSources.
   * @async
   * @returns {Promise<void>}
   */
  async process_load_queue() {
  }
  // TEMP: Methods in sources not implemented in blocks
  /**
   * @async
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {Promise<void>}
   */
  async prune() {
    throw "Not implemented: prune";
  }
  /**
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {void}
   */
  build_links_map() {
    throw "Not implemented: build_links_map";
  }
  /**
   * @async
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {Promise<void>}
   */
  async refresh() {
    throw "Not implemented: refresh";
  }
  /**
   * @async
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {Promise<void>}
   */
  async search() {
    throw "Not implemented: search";
  }
  /**
   * @async
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {Promise<void>}
   */
  async run_refresh() {
    throw "Not implemented: run_refresh";
  }
  /**
   * @async
   * @throws {Error} Throws an error indicating the method is not implemented.
   * @returns {Promise<void>}
   */
  async run_force_refresh() {
    throw "Not implemented: run_force_refresh";
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-blocks/adapters/data/ajson_multi_file.js
var AjsonMultiFileBlocksDataAdapter = class extends AjsonMultiFileCollectionDataAdapter {
  ItemDataAdapter = AjsonMultiFileBlockDataAdapter;
  /**
   * Transforms the item key into a safe filename.
   * Replaces spaces, slashes, and dots with underscores.
   * @returns {string} safe file name
   */
  // get_data_file_name(key) {
  //   return super.get_data_file_name(key.split('#')[0]);
  // }
  get_data_file_name(key) {
    return key.split("#")[0].replace(/[\s\/\.]/g, "_").replace(".md", "");
  }
  /**
   * Process any queued save operations.
   * @async
   * @returns {Promise<void>}
   */
  async process_save_queue() {
    this.collection.emit_event("collection:save_started");
    this.collection.show_process_notice("saving_collection");
    const save_queue = Object.values(this.collection.items).filter((item) => item._queue_save);
    console.log(`Saving ${this.collection.collection_key}: ${save_queue.length} items`);
    const time_start = Date.now();
    const save_files = Object.entries(save_queue.reduce((acc, item) => {
      const file_name = this.get_item_data_path(item.key);
      acc[file_name] = acc[file_name] || [];
      acc[file_name].push(item);
      return acc;
    }, {}));
    for (let i = 0; i < save_files.length; i++) {
      const [file_name, items] = save_files[i];
      await this.fs.append(
        file_name,
        items.map((item) => this.get_item_ajson(item)).join("\n") + "\n"
      );
      items.forEach((item) => item._queue_save = false);
    }
    console.log(`Saved ${this.collection.collection_key} in ${Date.now() - time_start}ms`);
    this.collection.clear_process_notice("saving_collection");
    this.collection.emit_event("collection:save_completed");
  }
  process_load_queue() {
    console.log(`Skipping loading ${this.collection.collection_key}...`);
  }
};
var AjsonMultiFileBlockDataAdapter = class extends AjsonMultiFileItemDataAdapter {
};

// node_modules/obsidian-smart-env/node_modules/smart-blocks/adapters/_adapter.js
var BlockContentAdapter = class {
  /**
   * @constructor
   * @param {Object} item - The SmartBlock instance this adapter operates on.
   * The `item` should at least provide `data` and references to its parent source.
   */
  constructor(item) {
    this.item = item;
  }
  /**
   * @async
   * @method read
   * @abstract
   * @returns {Promise<string>} The content of the block.
   * @throws {Error} If not implemented by subclass.
   */
  async read() {
    throw new Error("Not implemented");
  }
  /**
   * @async
   * @method append
   * @abstract
   * @param {string} content Content to append to the block.
   * @returns {Promise<void>}
   * @throws {Error} If not implemented by subclass.
   */
  async append(content) {
    throw new Error("Not implemented");
  }
  /**
   * @async
   * @method update
   * @abstract
   * @param {string} new_content The new content for the block.
   * @param {Object} [opts={}] Additional update options.
   * @returns {Promise<void>}
   * @throws {Error} If not implemented by subclass.
   */
  async update(new_content, opts = {}) {
    throw new Error("Not implemented");
  }
  /**
   * @async
   * @method remove
   * @abstract
   * @returns {Promise<void>}
   * @throws {Error} If not implemented by subclass.
   */
  async remove() {
    throw new Error("Not implemented");
  }
  /**
   * @async
   * @method move_to
   * @abstract
   * @param {string} to_key The destination key (source or block reference).
   * @returns {Promise<void>}
   * @throws {Error} If not implemented by subclass.
   */
  async move_to(to_key) {
    throw new Error("Not implemented");
  }
  /**
   * @name data
   * @type {Object}
   * @readonly
   * @description Access the block’s data object. Useful for updating metadata like line references or hashes.
   */
  get data() {
    return this.item.data;
  }
  /**
   * @async
   * @method update_last_read
   * @param {string} content The current content of the block.
   * @returns {Promise<void>}
   * @description Update the block’s `last_read` hash and timestamp based on the given content.
   */
  async update_last_read(content) {
    this.data.last_read = {
      hash: this.create_hash(content),
      at: Date.now()
    };
  }
  /**
   * @method create_hash
   * @param {string} content The content to hash.
   * @returns {Promise<string>} The computed hash of the content.
   * @description Hash the block content to detect changes and prevent unnecessary re-embeddings.
   */
  create_hash(content) {
    return murmur_hash_32_alphanumeric(content);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/utils/get_line_range.js
function get_line_range2(content, start_line, end_line) {
  const lines = content.split("\n");
  return lines.slice(start_line - 1, end_line).join("\n");
}

// node_modules/obsidian-smart-env/node_modules/smart-blocks/adapters/markdown_block.js
var MarkdownBlockContentAdapter = class extends BlockContentAdapter {
  /**
   * Read the content of the block.
   * @async
   * @returns {Promise<string>} The block content as a string.
   * @throws {Error} If the block cannot be found.
   */
  async read() {
    const source_content = await this.item.source?.read();
    if (!source_content) {
      console.warn(`BLOCK NOT FOUND: ${this.item.key} has no source content.`);
      return "";
    }
    const content = this._extract_block(source_content);
    this.update_last_read(content);
    return content;
  }
  /**
   * Append content to the existing block.
   * This method inserts additional lines after the block's end, then re-parses the file to update line references.
   * @async
   * @param {string} content Content to append to the block.
   * @returns {Promise<void>}
   * @throws {Error} If the block cannot be found.
   */
  async append(content) {
    let full_content = await this.item.source.read();
    const { line_start, line_end } = this.item;
    if (!line_start || !line_end) {
      throw new Error(`Cannot append to block ${this.item.key}: invalid line references.`);
    }
    const lines = full_content.split("\n");
    lines.splice(line_end, 0, "", content);
    const updated_content = lines.join("\n");
    await this.item.source._update(updated_content);
    await this._reparse_source();
  }
  /**
   * Update the block with new content, replacing its current lines.
   * @async
   * @param {string} new_content New content for the block.
   * @param {Object} [opts={}] Additional options.
   * @returns {Promise<void>}
   * @throws {Error} If the block cannot be found.
   */
  async update(new_content, opts = {}) {
    let full_content = await this.item.source.read();
    const { line_start, line_end } = this.item;
    if (!line_start || !line_end) {
      throw new Error(`Cannot update block ${this.item.key}: invalid line references.`);
    }
    const lines = full_content.split("\n");
    const updated_lines = [
      ...lines.slice(0, line_start - 1),
      ...new_content.split("\n"),
      ...lines.slice(line_end)
    ];
    const updated_content = updated_lines.join("\n");
    await this.item.source._update(updated_content);
    await this._reparse_source();
  }
  /**
   * Remove the block entirely from the source.
   * @async
   * @returns {Promise<void>}
   * @throws {Error} If the block cannot be found.
   */
  async remove() {
    let full_content = await this.item.source.read();
    const { line_start, line_end } = this.item;
    if (!line_start || !line_end) {
      throw new Error(`Cannot remove block ${this.item.key}: invalid line references.`);
    }
    const lines = full_content.split("\n");
    const updated_lines = [
      ...lines.slice(0, line_start - 1),
      ...lines.slice(line_end)
    ];
    const updated_content = updated_lines.join("\n");
    await this.item.source._update(updated_content);
    await this._reparse_source();
  }
  /**
   * Move the block to a new location (another source or heading).
   * This involves reading the block content, removing it from the current source, and appending it to the target.
   * @async
   * @param {string} to_key The destination path or entity reference.
   * @returns {Promise<void>}
   * @throws {Error} If the block or target is invalid.
   */
  async move_to(to_key) {
    const content = await this.read();
    await this.remove();
    const is_block_ref = to_key.includes("#");
    let target_source_key = is_block_ref ? to_key.split("#")[0] : to_key;
    const target_source = this.item.env.smart_sources.get(target_source_key);
    if (!target_source) {
      await this.item.env.smart_sources.create(target_source_key, content);
      return;
    }
    if (is_block_ref) {
      const target_block = this.item.env.smart_blocks.get(to_key);
      if (target_block) {
        await target_block.append(content);
      } else {
        await target_source.append(content);
      }
    } else {
      await target_source.append(content);
    }
  }
  /**
   * Extract the block content using current line references from a full source content.
   * @private
   * @param {string} source_content Full source file content.
   * @returns {string} Extracted block content.
   * @throws {Error} If the block cannot be found.
   */
  _extract_block(source_content) {
    if (!source_content) {
      console.warn(`BLOCK NOT FOUND: ${this.item.key} has no source content.`);
      return "";
    }
    const { line_start, line_end } = this.item;
    if (!line_start || !line_end) {
      throw new Error(`BLOCK NOT FOUND: ${this.item.key} has invalid line references.`);
    }
    return get_line_range2(source_content, line_start, line_end);
  }
  /**
   * Re-parse the source file after a CRUD operation to update line references for all blocks.
   * @private
   * @async
   * @returns {Promise<void>}
   */
  async _reparse_source() {
    await this.item.source.import();
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-sources/components/settings.js
async function build_html2(collection, opts = {}) {
  const settings_html = Object.entries(collection.settings_config).map(([setting_key, setting_config]) => {
    if (!setting_config.setting) setting_config.setting = setting_key;
    return this.render_setting_html(setting_config);
  }).join("\n");
  const html = `<div class="source-settings">
    ${settings_header_html(collection, opts)}
    ${settings_html}
  </div>`;
  return html;
}
function settings_header_html(collection, opts = {}) {
  const heading_text = collection.collection_key.replace(/_/g, " ").replace(/\b\w/g, (char) => char.toUpperCase());
  const heading_html = collection.collection_key === "smart_sources" ? get_source_heading_html(collection) : get_block_heading_html(collection);
  return `<div class="group-header">
    <h2>${heading_text}</h2>
    ${heading_html}
  </div>`;
}
function get_source_heading_html(collection) {
  const item_count = Object.keys(collection.items).length;
  if (!collection.loaded) {
    return `<span>${item_count} sources (embeddings not currently loaded)</span>`;
  }
  const total_count = collection.total_files;
  const included_count = collection.included_files;
  if (collection.loaded !== included_count) {
    return `<span>${collection.loaded}/${included_count} sources (partially loaded, should refresh/reload)</span>`;
  }
  const embedded_items = Object.values(collection.items).filter((item) => item.vec);
  const embedded_percentage = Math.round(embedded_items.length / item_count * 100);
  const load_time_html = collection.load_time_ms ? `<span>Load time: ${collection.load_time_ms}ms</span>` : "";
  return `
    <span>${embedded_percentage}% embedded</span>
    ${embedded_percentage === 0 ? "<span><b>Should run Re-import to re-embed</b></span>" : ""}
    <span>${included_count} included</span>
    <span>${total_count - included_count} excluded</span>
    ${load_time_html}
  `;
}
function get_block_heading_html(collection) {
  const item_count = Object.keys(collection.items).length;
  if (!collection.loaded) {
    return `<span>${item_count} blocks (embeddings not currently loaded)</span>`;
  }
  if (collection.loaded !== item_count) {
    return `<span>${collection.loaded}/${item_count} (loaded/total)</span>`;
  }
  const items_w_vec = Object.values(collection.items).filter((item) => item.vec).length;
  const embedded_percentage = Math.round(items_w_vec / item_count * 100);
  const load_time_html = collection.load_time_ms ? `<span>Load time: ${collection.load_time_ms}ms</span>` : "";
  return `
    <span>${embedded_percentage}% embedded (${items_w_vec}/${item_count})</span>
    <!--<span>Loaded: ${item_count} blocks (expected ${collection.expected_blocks_ct})</span>-->
    ${load_time_html}
  `;
}
async function render3(collection, opts = {}) {
  const html = await build_html2.call(this, collection, opts);
  const frag = this.create_doc_fragment(html);
  return await post_process3.call(this, collection, frag, opts);
}
async function post_process3(collection, frag, opts = {}) {
  await this.render_setting_components(frag, { scope: collection });
  return frag;
}

// node_modules/obsidian-smart-env/node_modules/smart-model/components/settings.js
async function render4(scope, opts = {}) {
  const html = Object.entries(scope.settings_config).map(([setting_key, setting_config]) => {
    if (!setting_config.setting) setting_config.setting = setting_key;
    return this.render_setting_html(setting_config);
  }).join("\n");
  const frag = this.create_doc_fragment(html);
  return await post_process4.call(this, scope, frag, opts);
}
async function post_process4(scope, frag, opts = {}) {
  await this.render_setting_components(frag, { scope });
  return frag;
}

// node_modules/obsidian-smart-env/node_modules/smart-model/smart_model.js
var SmartModel = class {
  scope_name = "smart_model";
  static defaults = {
    // override in sub-class if needed
  };
  /**
   * Create a SmartModel instance.
   * @param {Object} opts - Configuration options
   * @param {Object} opts.adapters - Map of adapter names to adapter classes
   * @param {Object} opts.settings - Model settings configuration
   * @param {Object} opts.model_config - Model-specific configuration
   * @param {string} opts.model_config.adapter - Name of the adapter to use
   * @param {string} [opts.model_key] - Optional model identifier to override settings
   * @throws {Error} If required options are missing
   */
  constructor(opts = {}) {
    this.opts = opts;
    this.validate_opts(opts);
    this.state = "unloaded";
    this._adapter = null;
  }
  /**
   * Initialize the model by loading the configured adapter.
   * @async
   * @returns {Promise<void>}
   */
  async initialize() {
    this.load_adapter(this.adapter_name);
    await this.load();
  }
  /**
   * Validate required options.
   * @param {Object} opts - Configuration options
   */
  validate_opts(opts) {
    if (!opts.adapters) throw new Error("opts.adapters is required");
    if (!opts.settings) throw new Error("opts.settings is required");
  }
  /**
   * Get the current settings
   * @returns {Object} Current settings
   */
  get settings() {
    if (!this.opts.settings) this.opts.settings = {
      ...this.constructor.defaults
    };
    return this.opts.settings;
  }
  /**
   * Get the current adapter name
   * @returns {string} Current adapter name
   */
  get adapter_name() {
    let adapter_key = this.opts.model_config?.adapter || this.opts.adapter || this.settings.adapter || Object.keys(this.adapters)[0];
    if (!adapter_key || !this.adapters[adapter_key]) {
      console.warn(`Platform "${adapter_key}" not supported`);
      adapter_key = Object.keys(this.adapters)[0];
    }
    return adapter_key;
  }
  /**
   * Get adapter-specific settings.
   * @returns {Object} Settings for current adapter
   */
  get adapter_settings() {
    if (!this.settings[this.adapter_name]) this.settings[this.adapter_name] = {};
    return this.settings[this.adapter_name];
  }
  get adapter_config() {
    const base_config = this.adapters[this.adapter_name]?.defaults || {};
    return {
      ...base_config,
      ...this.adapter_settings,
      ...this.opts.adapter_config
    };
  }
  /**
   * Get available models.
   * @returns {Object} Map of model objects
   */
  get models() {
    return this.adapter.models;
  }
  /**
   * Get default model key.
   * @returns {string} Default model key
   */
  get default_model_key() {
    return this.adapter.constructor.defaults.default_model;
  }
  /**
   * Get the current model key
   * @returns {string} Current model key
   */
  get model_key() {
    return this.opts.model_key || this.adapter_config.model_key || this.settings.model_key || this.default_model_key;
  }
  /**
   * Get the current model configuration
   * @returns {Object} Combined base and custom model configuration
   */
  get model_config() {
    const model_key = this.model_key;
    const base_model_config = this.models[model_key] || {};
    return {
      ...this.adapter_config,
      ...base_model_config,
      ...this.opts.model_config
    };
  }
  get model_settings() {
    if (!this.settings[this.model_key]) this.settings[this.model_key] = {};
    return this.settings[this.model_key];
  }
  /**
   * Load the current adapter and transition to loaded state.
   * @async
   * @returns {Promise<void>}
   */
  async load() {
    this.set_state("loading");
    try {
      if (!this.adapter?.is_loaded) {
        await this.invoke_adapter_method("load");
      }
    } catch (err) {
      this.set_state("unloaded");
      if (!this.reload_model_timeout) {
        this.reload_model_timeout = setTimeout(async () => {
          this.reload_model_timeout = null;
          await this.load();
          this.set_state("loaded");
          this.env?.events?.emit("model:loaded", { model_key: this.model_key });
          this.notices?.show("Loaded model: " + this.model_key);
        }, 6e4);
      }
      throw new Error(`Failed to load model: ${err.message}`);
    }
    this.set_state("loaded");
  }
  /**
   * Unload the current adapter and transition to unloaded state.
   * @async
   * @returns {Promise<void>}
   */
  async unload() {
    if (this.adapter?.is_loaded) {
      this.set_state("unloading");
      await this.invoke_adapter_method("unload");
      this.set_state("unloaded");
    }
  }
  /**
   * Set the model's state.
   * @param {('unloaded'|'loading'|'loaded'|'unloading')} new_state - The new state
   * @throws {Error} If the state is invalid
   */
  set_state(new_state) {
    const valid_states = ["unloaded", "loading", "loaded", "unloading"];
    if (!valid_states.includes(new_state)) {
      throw new Error(`Invalid state: ${new_state}`);
    }
    this.state = new_state;
  }
  get is_loading() {
    return this.state === "loading";
  }
  get is_loaded() {
    return this.state === "loaded";
  }
  get is_unloading() {
    return this.state === "unloading";
  }
  get is_unloaded() {
    return this.state === "unloaded";
  }
  // ADAPTERS
  /**
   * Get the map of available adapters
   * @returns {Object} Map of adapter names to adapter classes
   */
  get adapters() {
    return this.opts.adapters || {};
  }
  /**
   * Load a specific adapter by name.
   * @async
   * @param {string} adapter_name - Name of the adapter to load
   * @throws {Error} If adapter not found or loading fails
   * @returns {Promise<void>}
   */
  async load_adapter(adapter_name) {
    this.set_adapter(adapter_name);
    if (!this._adapter.loaded) {
      this.set_state("loading");
      try {
        await this.invoke_adapter_method("load");
        this.set_state("loaded");
      } catch (err) {
        this.set_state("unloaded");
        throw new Error(`Failed to load adapter: ${err.message}`);
      }
    }
  }
  /**
   * Set an adapter instance by name without loading it.
   * @param {string} adapter_name - Name of the adapter to set
   * @throws {Error} If adapter not found
   */
  set_adapter(adapter_name) {
    const AdapterClass = this.adapters[adapter_name];
    if (!AdapterClass) {
      throw new Error(`Adapter "${adapter_name}" not found.`);
    }
    if (this._adapter?.constructor.name.toLowerCase() === adapter_name.toLowerCase()) {
      return;
    }
    this._adapter = new AdapterClass(this);
  }
  /**
   * Get the current active adapter instance
   * @returns {Object} The active adapter instance
   * @throws {Error} If adapter not found
   */
  get adapter() {
    const adapter_name = this.adapter_name;
    if (!adapter_name) {
      throw new Error(`Adapter not set for model.`);
    }
    if (!this._adapter) {
      this.load_adapter(adapter_name);
    }
    return this._adapter;
  }
  /**
   * Ensure the adapter is ready to execute a method.
   * @param {string} method - Name of the method to check
   * @throws {Error} If adapter not loaded or method not implemented
   */
  ensure_adapter_ready(method) {
    if (!this.adapter) {
      throw new Error("No adapter loaded.");
    }
    if (typeof this.adapter[method] !== "function") {
      throw new Error(`Adapter does not implement method: ${method}`);
    }
  }
  /**
   * Invoke a method on the current adapter.
   * @async
   * @param {string} method - Name of the method to call
   * @param {...any} args - Arguments to pass to the method
   * @returns {Promise<any>} Result from the adapter method
   * @throws {Error} If adapter not ready or method fails
   */
  async invoke_adapter_method(method, ...args) {
    this.ensure_adapter_ready(method);
    return await this.adapter[method](...args);
  }
  /**
   * Get platforms as dropdown options.
   * @returns {Array<Object>} Array of {value, name} option objects
   */
  get_platforms_as_options() {
    return Object.entries(this.adapters).map(([key, AdapterClass]) => ({ value: key, name: AdapterClass.defaults.description || key }));
  }
  // SETTINGS
  /**
   * Get the settings configuration schema
   * @returns {Object} Settings configuration object
   */
  get settings_config() {
    return this.process_settings_config({
      adapter: {
        name: "Model Platform",
        type: "dropdown",
        description: "Select a model platform to use with Smart Model.",
        options_callback: "get_platforms_as_options",
        is_scope: true,
        // trigger re-render of settings when changed
        callback: "adapter_changed",
        default: "default"
      }
    });
  }
  /**
   * Process settings configuration with conditionals and prefixes.
   * @param {Object} _settings_config - Raw settings configuration
   * @param {string} [prefix] - Optional prefix for setting keys
   * @returns {Object} Processed settings configuration
   */
  process_settings_config(_settings_config, prefix = null) {
    return Object.entries(_settings_config).reduce((acc, [key, val]) => {
      const new_key = (prefix ? prefix + "." : "") + this.process_setting_key(key);
      acc[new_key] = val;
      return acc;
    }, {});
  }
  /**
   * Process an individual setting key.
   * Example: replace placeholders with actual adapter names.
   * @param {string} key - The setting key with placeholders.
   * @returns {string} Processed setting key.
   */
  process_setting_key(key) {
    return key.replace(/\[ADAPTER\]/g, this.adapter_name);
  }
  re_render_settings() {
    if (typeof this.opts.re_render_settings === "function") this.opts.re_render_settings();
    else console.warn("re_render_settings is not a function (must be passed in model opts)");
  }
  /**
   * Reload model.
   */
  reload_model() {
    if (typeof this.opts.reload_model === "function") this.opts.reload_model();
    else console.warn("reload_model is not a function (must be passed in model opts)");
  }
  adapter_changed() {
    this.reload_model();
    this.re_render_settings();
  }
  model_changed() {
    this.reload_model();
    this.re_render_settings();
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/smart_embed_model.js
var SmartEmbedModel = class extends SmartModel {
  scope_name = "smart_embed_model";
  static defaults = {
    adapter: "transformers"
  };
  /**
   * Create a SmartEmbedModel instance
   * @param {Object} opts - Configuration options
   * @param {Object} [opts.adapters] - Map of available adapter implementations
   * @param {boolean} [opts.use_gpu] - Whether to enable GPU acceleration
   * @param {number} [opts.gpu_batch_size] - Batch size when using GPU
   * @param {number} [opts.batch_size] - Default batch size for processing
   * @param {Object} [opts.model_config] - Model-specific configuration
   * @param {string} [opts.model_config.adapter] - Override adapter type
   * @param {number} [opts.model_config.dims] - Embedding dimensions
   * @param {number} [opts.model_config.max_tokens] - Maximum tokens to process
   * @param {Object} [opts.settings] - User settings
   * @param {string} [opts.settings.api_key] - API key for remote models
   * @param {number} [opts.settings.min_chars] - Minimum text length to embed
   */
  constructor(opts = {}) {
    super(opts);
  }
  /**
   * Count tokens in an input string
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   * @property {number} tokens - Number of tokens in input
   * 
   * @example
   * ```javascript
   * const result = await model.count_tokens("Hello world");
   * console.log(result.tokens); // 2
   * ```
   */
  async count_tokens(input) {
    return await this.invoke_adapter_method("count_tokens", input);
  }
  /**
   * Generate embeddings for a single input
   * @param {string|Object} input - Text or object with embed_input property
   * @returns {Promise<Object>} Embedding result
   * @property {number[]} vec - Embedding vector
   * @property {number} tokens - Token count
   * 
   * @example
   * ```javascript
   * const result = await model.embed("Hello world");
   * console.log(result.vec); // [0.1, 0.2, ...]
   * ```
   */
  async embed(input) {
    if (typeof input === "string") input = { embed_input: input };
    return (await this.embed_batch([input]))[0];
  }
  /**
   * Generate embeddings for multiple inputs in batch
   * @param {Array<string|Object>} inputs - Array of texts or objects with embed_input
   * @returns {Promise<Array<Object>>} Array of embedding results
   * @property {number[]} vec - Embedding vector for each input
   * @property {number} tokens - Token count for each input
   * 
   * @example
   * ```javascript
   * const results = await model.embed_batch([
   *   { embed_input: "First text" },
   *   { embed_input: "Second text" }
   * ]);
   * ```
   */
  async embed_batch(inputs) {
    return await this.invoke_adapter_method("embed_batch", inputs);
  }
  /**
   * Get the current batch size based on GPU settings
   * @returns {number} Current batch size for processing
   */
  get batch_size() {
    return this.adapter.batch_size || 1;
  }
  /**
   * Get settings configuration schema
   * @returns {Object} Settings configuration object
   */
  get settings_config() {
    const _settings_config = {
      adapter: {
        name: "Embedding model platform",
        type: "dropdown",
        description: "Select an embedding model platform. The default 'transformers' utilizes built-in local models.",
        options_callback: "get_platforms_as_options",
        callback: "adapter_changed",
        default: this.constructor.defaults.adapter
      },
      ...this.adapter.settings_config || {}
    };
    return this.process_settings_config(_settings_config);
  }
  process_setting_key(key) {
    return key.replace(/\[ADAPTER\]/g, this.adapter_name);
  }
  /**
   * Get available embedding model options
   * @returns {Array<Object>} Array of model options with value and name
   */
  get_embedding_model_options() {
    return Object.entries(this.models).map(([key, model]) => ({ value: key, name: key }));
  }
  // /**
  //  * Get embedding model options including 'None' option
  //  * @returns {Array<Object>} Array of model options with value and name
  //  */
  // get_block_embedding_model_options() {
  //   const options = this.get_embedding_model_options();
  //   options.unshift({ value: 'None', name: 'None' });
  //   return options;
  // }
};

// node_modules/obsidian-smart-env/node_modules/smart-model/adapters/_adapter.js
var SmartModelAdapter = class {
  /**
   * Create a SmartModelAdapter instance.
   * @param {SmartModel} model - The parent SmartModel instance
   */
  constructor(model) {
    this.model = model;
    this.state = "unloaded";
  }
  /**
   * Load the adapter.
   * @async
   * @returns {Promise<void>}
   */
  async load() {
    this.set_state("loaded");
  }
  /**
   * Unload the adapter.
   * @returns {void}
   */
  unload() {
    this.set_state("unloaded");
  }
  /**
   * Get all settings.
   * @returns {Object} All settings
   */
  get settings() {
    return this.model.settings;
  }
  /**
   * Get the current model key.
   * @returns {string} Current model identifier
   */
  get model_key() {
    return this.model.model_key;
  }
  /**
   * Get the current model configuration.
   * @returns {Object} Model configuration
   */
  get model_config() {
    return this.model.model_config;
  }
  /**
   * Get model-specific settings.
   * @returns {Object} Settings for current model
   */
  get model_settings() {
    return this.model.model_settings;
  }
  /**
   * Get adapter-specific configuration.
   * @returns {Object} Adapter configuration
   */
  get adapter_config() {
    return this.model.adapter_config;
  }
  /**
   * Get adapter-specific settings.
   * @returns {Object} Adapter settings
   */
  get adapter_settings() {
    return this.model.adapter_settings;
  }
  /**
   * Get the models.
   * @returns {Object} Map of model objects
   */
  get models() {
    if (typeof this.adapter_config.models === "object" && Object.keys(this.adapter_config.models || {}).length > 0) return this.adapter_config.models;
    else {
      return {};
    }
  }
  /**
   * Get available models from the API.
   * @abstract
   * @param {boolean} [refresh=false] - Whether to refresh cached models
   * @returns {Promise<Object>} Map of model objects
   */
  async get_models(refresh = false) {
    throw new Error("get_models not implemented");
  }
  /**
   * Validate the parameters for get_models.
   * @returns {boolean|Array<Object>} True if parameters are valid, otherwise an array of error objects
   */
  validate_get_models_params() {
    return true;
  }
  /**
   * Get available models as dropdown options synchronously.
   * @returns {Array<Object>} Array of model options.
   */
  get_models_as_options() {
    const models = this.models;
    const params_valid = this.validate_get_models_params();
    if (params_valid !== true) return params_valid;
    if (!Object.keys(models || {}).length) {
      this.get_models(true);
      return [{ value: "", name: "No models currently available" }];
    }
    return Object.entries(models).map(([id, model]) => ({ value: id, name: model.name || id })).sort((a, b) => a.name.localeCompare(b.name));
  }
  /**
   * Set the adapter's state.
   * @deprecated should be handled in SmartModel (only handle once)
   * @param {('unloaded'|'loading'|'loaded'|'unloading')} new_state - The new state
   * @throws {Error} If the state is invalid
   */
  set_state(new_state) {
    const valid_states = ["unloaded", "loading", "loaded", "unloading"];
    if (!valid_states.includes(new_state)) {
      throw new Error(`Invalid state: ${new_state}`);
    }
    this.state = new_state;
  }
  // Replace individual state getters/setters with a unified state management
  get is_loading() {
    return this.state === "loading";
  }
  get is_loaded() {
    return this.state === "loaded";
  }
  get is_unloading() {
    return this.state === "unloading";
  }
  get is_unloaded() {
    return this.state === "unloaded";
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/_adapter.js
var SmartEmbedAdapter = class extends SmartModelAdapter {
  /**
   * @override in sub-class with adapter-specific default configurations
   * @property {string} id - The adapter identifier
   * @property {string} description - Human-readable description
   * @property {string} type - Adapter type ("API")
   * @property {string} endpoint - API endpoint
   * @property {string} adapter - Adapter identifier
   * @property {string} default_model - Default model to use
   */
  static defaults = {};
  /**
   * Create adapter instance
   * @param {SmartEmbedModel} model - Parent model instance
   */
  constructor(model) {
    super(model);
    this.smart_embed = model;
  }
  /**
   * Count tokens in input text
   * @abstract
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   * @property {number} tokens - Number of tokens in input
   * @throws {Error} If not implemented by subclass
   */
  async count_tokens(input) {
    throw new Error("count_tokens method not implemented");
  }
  /**
   * Generate embeddings for single input
   * @abstract
   * @param {string|Object} input - Text to embed
   * @returns {Promise<Object>} Embedding result
   * @property {number[]} vec - Embedding vector
   * @property {number} tokens - Number of tokens in input
   * @throws {Error} If not implemented by subclass
   */
  async embed(input) {
    throw new Error("embed method not implemented");
  }
  /**
   * Generate embeddings for multiple inputs
   * @abstract
   * @param {Array<string|Object>} inputs - Texts to embed
   * @returns {Promise<Array<Object>>} Array of embedding results
   * @property {number[]} vec - Embedding vector for each input
   * @property {number} tokens - Number of tokens in each input
   * @throws {Error} If not implemented by subclass
   */
  async embed_batch(inputs) {
    throw new Error("embed_batch method not implemented");
  }
  get settings_config() {
    return {
      "[ADAPTER].model_key": {
        name: "Embedding model",
        type: "dropdown",
        description: "Select an embedding model.",
        options_callback: "adapter.get_models_as_options",
        callback: "model_changed",
        default: this.constructor.defaults.default_model
      }
    };
  }
  get dims() {
    return this.model_config.dims;
  }
  get max_tokens() {
    return this.model_config.max_tokens;
  }
  // get batch_size() { return this.model_config.batch_size; }
  get use_gpu() {
    if (typeof this._use_gpu === "undefined") {
      if (typeof this.model.opts.use_gpu !== "undefined") this._use_gpu = this.model.opts.use_gpu;
      else this._use_gpu = typeof navigator !== "undefined" && !!navigator?.gpu && this.model_settings.gpu_batch_size !== 0;
    }
    return this._use_gpu;
  }
  set use_gpu(value) {
    this._use_gpu = value;
  }
  get batch_size() {
    if (this.use_gpu && this.model_config?.gpu_batch_size) return this.model_config.gpu_batch_size;
    return this.model.opts.batch_size || this.model_config.batch_size || 1;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-http-request/smart_http_request.js
var SmartHttpRequest = class {
  /**
   * @param {object} opts - Options for the SmartHttpRequest class
   * @param {SmartHttpRequestAdapter} opts.adapter - The adapter constructor to use for making HTTP requests
   * @param {Obsidian.requestUrl} opts.obsidian_request_adapter - For use with Obsidian adapter
   */
  constructor(opts = {}) {
    this.opts = opts;
    if (!opts.adapter) throw new Error("HttpRequestAdapter is required");
    this.adapter = new opts.adapter(this);
  }
  /**
   * Returns a well-formed response object
   * @param {object} request_params - Parameters for the HTTP request
   * @param {string} request_params.url - The URL to make the request to
   * @param {string} [request_params.method='GET'] - The HTTP method to use
   * @param {object} [request_params.headers] - Headers to include in the request
   * @param {*} [request_params.body] - The body of the request (for POST, PUT, etc.)
   * @returns {SmartHttpResponseAdapter} instance of the SmartHttpResponseAdapter class
   * @example
   * const response = await smart_http_request.request({
   *   url: 'https://api.example.com/data',
   *   method: 'GET',
   *   headers: { 'Content-Type': 'application/json' }
   * });
   * console.log(await response.json());
   */
  async request(request_params) {
    return await this.adapter.request(request_params);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-http-request/adapters/_adapter.js
var SmartHttpRequestAdapter = class {
  constructor(main) {
    this.main = main;
  }
  async request(request_params) {
    throw new Error("request not implemented");
  }
};
var SmartHttpResponseAdapter = class {
  constructor(response) {
    this.response = response;
  }
  async headers() {
    throw new Error("headers not implemented");
  }
  async json() {
    throw new Error("json not implemented");
  }
  async status() {
    throw new Error("status not implemented");
  }
  async text() {
    throw new Error("text not implemented");
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-http-request/adapters/obsidian.js
var SmartHttpObsidianRequestAdapter = class extends SmartHttpRequestAdapter {
  async request(request_params) {
    let response;
    try {
      if (!this.main.opts.obsidian_request_url) {
        throw new Error("obsidian_request_url is required in SmartHttp constructor opts");
      }
      response = await this.main.opts.obsidian_request_url({ ...request_params, throw: false });
      if (response.status === 400) throw new Error("Obsidian request failed");
      return new SmartHttpObsidianResponseAdapter(response);
    } catch (error) {
      console.error("Error in SmartHttpObsidianRequestAdapter.request():");
      console.error(JSON.stringify(request_params, null, 2));
      console.error(response);
      console.error(error);
      return null;
    }
  }
};
var SmartHttpObsidianResponseAdapter = class extends SmartHttpResponseAdapter {
  async status() {
    return this.response.status;
  }
  async json() {
    return await this.response.json;
  }
  async text() {
    return await this.response.text;
  }
  async headers() {
    return this.response.headers;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-http-request/adapters/fetch.js
var SmartHttpRequestFetchAdapter = class extends SmartHttpRequestAdapter {
  async request(request_params) {
    const { url, ...opts } = request_params;
    const resp = await fetch(url, opts);
    return new SmartHttpResponseFetchAdapter(resp);
  }
};
var SmartHttpResponseFetchAdapter = class extends SmartHttpResponseAdapter {
  async headers() {
    return this.response.headers;
  }
  async json() {
    if (!this._json) {
      this._json = await this.response.json();
    }
    return this._json;
  }
  async status() {
    return this.response.status;
  }
  async text() {
    if (!this._text) {
      this._text = await this.response.text();
    }
    return this._text;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/_api.js
var SmartEmbedModelApiAdapter = class extends SmartEmbedAdapter {
  /**
   * Get the request adapter class.
   * @returns {SmartEmbedModelRequestAdapter} The request adapter class
   */
  get req_adapter() {
    return SmartEmbedModelRequestAdapter;
  }
  /**
   * Get the response adapter class.
   * @returns {SmartEmbedModelResponseAdapter} The response adapter class
   */
  get res_adapter() {
    return SmartEmbedModelResponseAdapter;
  }
  /** @returns {string} API endpoint URL */
  get endpoint() {
    return this.model_config.endpoint;
  }
  /**
   * Get HTTP request adapter instance
   * @returns {SmartHttpRequest} HTTP request handler
   */
  get http_adapter() {
    if (!this._http_adapter) {
      if (this.model.opts.http_adapter)
        this._http_adapter = this.model.opts.http_adapter;
      else
        this._http_adapter = new SmartHttpRequest({
          adapter: SmartHttpRequestFetchAdapter
        });
    }
    return this._http_adapter;
  }
  /**
   * Get API key for authentication
   * @returns {string} API key
   */
  get api_key() {
    return this.adapter_settings.api_key || this.settings.api_key || this.model_config.api_key;
  }
  /**
   * Count tokens in input text
   * @abstract
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   * @throws {Error} If not implemented by subclass
   */
  async count_tokens(input) {
    throw new Error("count_tokens not implemented");
  }
  /**
   * Estimate token count for input text
   * Uses character-based estimation (3.7 chars per token)
   * @param {string|Object} input - Input to estimate tokens for
   * @returns {number} Estimated token count
   */
  estimate_tokens(input) {
    if (typeof input === "object") input = JSON.stringify(input);
    return Math.ceil(input.length / 3.7);
  }
  /**
   * Process a batch of inputs for embedding
   * @param {Array<Object>} inputs - Array of input objects
   * @returns {Promise<Array<Object>>} Processed inputs with embeddings
   * @throws {Error} If API key is not set
   */
  async embed_batch(inputs) {
    if (!this.api_key) throw new Error("API key not set");
    inputs = inputs.filter((item) => item.embed_input?.length > 0);
    if (inputs.length === 0) {
      console.log("Empty batch (or all items have empty embed_input)");
      return [];
    }
    const embed_inputs = await Promise.all(
      inputs.map((item) => this.prepare_embed_input(item.embed_input))
    );
    const _req = new this.req_adapter(this, embed_inputs);
    const request_params = _req.to_platform();
    const resp = await this.request(request_params);
    if (!resp) {
      console.error("No response received for embedding request.");
      return [];
    }
    const _res = new this.res_adapter(this, resp);
    const embeddings = _res.to_openai();
    if (!embeddings) {
      console.error("Failed to parse embeddings.");
      return [];
    }
    return inputs.map((item, i) => {
      item.vec = embeddings[i].vec;
      item.tokens = embeddings[i].tokens;
      return item;
    });
  }
  /**
   * Prepare input text for embedding
   * @abstract
   * @param {string} embed_input - Raw input text
   * @returns {Promise<string>} Processed input text
   * @throws {Error} If not implemented by subclass
   */
  async prepare_embed_input(embed_input) {
    throw new Error("prepare_embed_input not implemented");
  }
  /**
   * Prepare request headers
   * @returns {Object} Headers object with authorization
   */
  prepare_request_headers() {
    let headers = {
      "Content-Type": "application/json"
    };
    if (this.api_key) {
      headers["Authorization"] = `Bearer ${this.api_key}`;
    }
    if (this.smart_embed.opts.headers) {
      headers = { ...headers, ...this.smart_embed.opts.headers };
    }
    return headers;
  }
  /**
   * Make API request with retry logic
   * @param {Object} req - Request configuration
   * @param {number} [retries=0] - Number of retries attempted
   * @returns {Promise<Object>} API response
   */
  async request(req, retries = 0) {
    try {
      req.throw = false;
      const resp = await this.http_adapter.request({
        url: this.endpoint,
        ...req
      });
      const resp_json = await this.get_resp_json(resp);
      return resp_json;
    } catch (error) {
      return await this.handle_request_err(error, req, retries);
    }
  }
  /**
   * Handle API request errors with retry logic
   * @param {Error|Object} error - Error object
   * @param {Object} req - Original request
   * @param {number} retries - Number of retries attempted
   * @returns {Promise<Object|null>} Retry response or null
   */
  async handle_request_err(error, req, retries) {
    if (error.status === 429 && retries < 3) {
      const backoff = Math.pow(retries + 1, 2);
      console.log(`Retrying request (429) in ${backoff} seconds...`);
      await new Promise((r) => setTimeout(r, 1e3 * backoff));
      return await this.request(req, retries + 1);
    }
    console.error(error);
    return null;
  }
  /**
   * Parse response body as JSON
   * @param {Response} resp - Response object
   * @returns {Promise<Object>} Parsed JSON
   */
  async get_resp_json(resp) {
    return typeof resp.json === "function" ? await resp.json() : await resp.json;
  }
  /**
   * Validate API key by making test request
   * @returns {Promise<boolean>} True if API key is valid
   */
  async validate_api_key() {
    const resp = await this.embed_batch([{ embed_input: "test" }]);
    return Array.isArray(resp) && resp.length > 0 && resp[0].vec !== null;
  }
  /**
   * Trim input text to satisfy `max_tokens`.
   * @private
   * @param {string} embed_input - Input text
   * @param {number} tokens_ct - Existing token count
   * @returns {Promise<string|null>} Trimmed text
   */
  async trim_input_to_max_tokens(embed_input, tokens_ct) {
    const reduce_ratio = (tokens_ct - this.max_tokens) / tokens_ct;
    const new_length = Math.floor(embed_input.length * (1 - reduce_ratio));
    let trimmed_input = embed_input.slice(0, new_length);
    const last_space_index = trimmed_input.lastIndexOf(" ");
    if (last_space_index > 0) trimmed_input = trimmed_input.slice(0, last_space_index);
    const prepared = await this.prepare_embed_input(trimmed_input);
    if (prepared === null) return null;
    return prepared;
  }
};
var SmartEmbedModelRequestAdapter = class {
  /**
   * @constructor
   * @param {SmartEmbedModelApiAdapter} adapter - The SmartEmbedModelApiAdapter instance
   * @param {Array<string>} embed_inputs - The array of input texts
   */
  constructor(adapter, embed_inputs) {
    this.adapter = adapter;
    this.embed_inputs = embed_inputs;
  }
  /**
   * Get request headers
   * @returns {Object} Headers object
   */
  get_headers() {
    return this.adapter.prepare_request_headers();
  }
  /**
   * Convert request to platform-specific format
   * @returns {Object} Platform-specific request parameters
   */
  to_platform() {
    return {
      method: "POST",
      headers: this.get_headers(),
      body: JSON.stringify(this.prepare_request_body())
    };
  }
  /**
   * Prepare request body for API call
   * @abstract
   * @returns {Object} Request body object
   * @throws {Error} If not implemented by subclass
   */
  prepare_request_body() {
    throw new Error("prepare_request_body not implemented");
  }
};
var SmartEmbedModelResponseAdapter = class {
  /**
   * @constructor
   * @param {SmartEmbedModelApiAdapter} adapter - The SmartEmbedModelApiAdapter instance
   * @param {Object} response - The response object
   */
  constructor(adapter, response) {
    this.adapter = adapter;
    this.response = response;
  }
  /**
   * Convert response to standard format
   * @returns {Array<Object>} Array of embedding results
   */
  to_openai() {
    return this.parse_response();
  }
  /**
   * Parse API response
   * @abstract
   * @returns {Array<Object>} Parsed embedding results
   * @throws {Error} If not implemented by subclass
   */
  parse_response() {
    throw new Error("parse_response not implemented");
  }
};

// node_modules/obsidian-smart-env/node_modules/js-tiktoken/dist/chunk-ZDNLBERF.js
var import_base64_js = __toESM(require_base64_js(), 1);
var __defProp2 = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
function bytePairMerge(piece, ranks) {
  let parts = Array.from(
    { length: piece.length },
    (_, i) => ({ start: i, end: i + 1 })
  );
  while (parts.length > 1) {
    let minRank = null;
    for (let i = 0; i < parts.length - 1; i++) {
      const slice = piece.slice(parts[i].start, parts[i + 1].end);
      const rank = ranks.get(slice.join(","));
      if (rank == null)
        continue;
      if (minRank == null || rank < minRank[0]) {
        minRank = [rank, i];
      }
    }
    if (minRank != null) {
      const i = minRank[1];
      parts[i] = { start: parts[i].start, end: parts[i + 1].end };
      parts.splice(i + 1, 1);
    } else {
      break;
    }
  }
  return parts;
}
function bytePairEncode(piece, ranks) {
  if (piece.length === 1)
    return [ranks.get(piece.join(","))];
  return bytePairMerge(piece, ranks).map((p) => ranks.get(piece.slice(p.start, p.end).join(","))).filter((x) => x != null);
}
function escapeRegex(str) {
  return str.replace(/[\\^$*+?.()|[\]{}]/g, "\\$&");
}
var _Tiktoken = class {
  /** @internal */
  specialTokens;
  /** @internal */
  inverseSpecialTokens;
  /** @internal */
  patStr;
  /** @internal */
  textEncoder = new TextEncoder();
  /** @internal */
  textDecoder = new TextDecoder("utf-8");
  /** @internal */
  rankMap = /* @__PURE__ */ new Map();
  /** @internal */
  textMap = /* @__PURE__ */ new Map();
  constructor(ranks, extendedSpecialTokens) {
    this.patStr = ranks.pat_str;
    const uncompressed = ranks.bpe_ranks.split("\n").filter(Boolean).reduce((memo, x) => {
      const [_, offsetStr, ...tokens] = x.split(" ");
      const offset = Number.parseInt(offsetStr, 10);
      tokens.forEach((token, i) => memo[token] = offset + i);
      return memo;
    }, {});
    for (const [token, rank] of Object.entries(uncompressed)) {
      const bytes = import_base64_js.default.toByteArray(token);
      this.rankMap.set(bytes.join(","), rank);
      this.textMap.set(rank, bytes);
    }
    this.specialTokens = { ...ranks.special_tokens, ...extendedSpecialTokens };
    this.inverseSpecialTokens = Object.entries(this.specialTokens).reduce((memo, [text, rank]) => {
      memo[rank] = this.textEncoder.encode(text);
      return memo;
    }, {});
  }
  encode(text, allowedSpecial = [], disallowedSpecial = "all") {
    const regexes = new RegExp(this.patStr, "ug");
    const specialRegex = _Tiktoken.specialTokenRegex(
      Object.keys(this.specialTokens)
    );
    const ret = [];
    const allowedSpecialSet = new Set(
      allowedSpecial === "all" ? Object.keys(this.specialTokens) : allowedSpecial
    );
    const disallowedSpecialSet = new Set(
      disallowedSpecial === "all" ? Object.keys(this.specialTokens).filter(
        (x) => !allowedSpecialSet.has(x)
      ) : disallowedSpecial
    );
    if (disallowedSpecialSet.size > 0) {
      const disallowedSpecialRegex = _Tiktoken.specialTokenRegex([
        ...disallowedSpecialSet
      ]);
      const specialMatch = text.match(disallowedSpecialRegex);
      if (specialMatch != null) {
        throw new Error(
          `The text contains a special token that is not allowed: ${specialMatch[0]}`
        );
      }
    }
    let start = 0;
    while (true) {
      let nextSpecial = null;
      let startFind = start;
      while (true) {
        specialRegex.lastIndex = startFind;
        nextSpecial = specialRegex.exec(text);
        if (nextSpecial == null || allowedSpecialSet.has(nextSpecial[0]))
          break;
        startFind = nextSpecial.index + 1;
      }
      const end = nextSpecial?.index ?? text.length;
      for (const match of text.substring(start, end).matchAll(regexes)) {
        const piece = this.textEncoder.encode(match[0]);
        const token2 = this.rankMap.get(piece.join(","));
        if (token2 != null) {
          ret.push(token2);
          continue;
        }
        ret.push(...bytePairEncode(piece, this.rankMap));
      }
      if (nextSpecial == null)
        break;
      let token = this.specialTokens[nextSpecial[0]];
      ret.push(token);
      start = nextSpecial.index + nextSpecial[0].length;
    }
    return ret;
  }
  decode(tokens) {
    const res = [];
    let length = 0;
    for (let i2 = 0; i2 < tokens.length; ++i2) {
      const token = tokens[i2];
      const bytes = this.textMap.get(token) ?? this.inverseSpecialTokens[token];
      if (bytes != null) {
        res.push(bytes);
        length += bytes.length;
      }
    }
    const mergedArray = new Uint8Array(length);
    let i = 0;
    for (const bytes of res) {
      mergedArray.set(bytes, i);
      i += bytes.length;
    }
    return this.textDecoder.decode(mergedArray);
  }
};
var Tiktoken = _Tiktoken;
__publicField(Tiktoken, "specialTokenRegex", (tokens) => {
  return new RegExp(tokens.map((i) => escapeRegex(i)).join("|"), "g");
});

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/utils/fetch_cache.js
async function fetch_json_cached(url, cache_key = url) {
  const is_browser = typeof window !== "undefined" && typeof window.document !== "undefined";
  if (is_browser) {
    const cached_text = window.localStorage.getItem(cache_key);
    if (cached_text) return JSON.parse(cached_text);
    const remote2 = await do_fetch(url);
    window.localStorage.setItem(cache_key, JSON.stringify(remote2));
    return remote2;
  }
  const fs = await import("node:fs/promises");
  const path = await import("node:path");
  const os = await import("node:os");
  const cache_dir = path.join(os.homedir(), ".cache", "smart-embed-model");
  const cache_file = path.join(cache_dir, cache_key);
  try {
    const txt = await fs.readFile(cache_file, "utf8");
    return JSON.parse(txt);
  } catch {
  }
  const remote = await do_fetch(url);
  await fs.mkdir(cache_dir, { recursive: true });
  await fs.writeFile(cache_file, JSON.stringify(remote), "utf8");
  return remote;
}
async function do_fetch(url) {
  const resp = await fetch(url);
  if (!resp.ok) throw new Error(`failed to download ${url} \u2013 ${resp.status}`);
  return await resp.json();
}

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/openai.js
var CL100K_URL = "https://raw.githubusercontent.com/brianpetro/jsbrains/refs/heads/main/smart-embed-model/cl100k_base.json";
var SmartEmbedOpenAIAdapter = class extends SmartEmbedModelApiAdapter {
  static defaults = {
    adapter: "openai",
    description: "OpenAI (API)",
    default_model: "text-embedding-3-small",
    endpoint: "https://api.openai.com/v1/embeddings"
  };
  /**
   * Create OpenAI adapter instance
   * @param {SmartEmbedModel} smart_embed - Parent model instance
   */
  constructor(smart_embed) {
    super(smart_embed);
    this.enc = null;
  }
  /**
   * Initialize tokenizer
   * @returns {Promise<void>}
   */
  async load() {
    const cl100k_base = await fetch_json_cached(CL100K_URL, "cl100k_base.json");
    this.enc = new Tiktoken(cl100k_base);
  }
  /**
   * Count tokens in input text using OpenAI's tokenizer
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   */
  async count_tokens(input) {
    if (!this.enc) await this.load();
    return { tokens: this.enc.encode(input).length };
  }
  /**
   * Prepare input text for embedding
   * Handles token limit truncation
   * @param {string} embed_input - Raw input text
   * @returns {Promise<string|null>} Processed input text
   */
  async prepare_embed_input(embed_input) {
    if (typeof embed_input !== "string") {
      throw new TypeError("embed_input must be a string");
    }
    if (embed_input.length === 0) {
      console.log("Warning: prepare_embed_input received an empty string");
      return null;
    }
    const { tokens } = await this.count_tokens(embed_input);
    if (tokens <= this.max_tokens) {
      return embed_input;
    }
    return await this.trim_input_to_max_tokens(embed_input, tokens);
  }
  /**
   * Trim input text to fit token limit
   * @private
   * @param {string} embed_input - Input text to trim
   * @param {number} tokens_ct - Current token count
   * @returns {Promise<string|null>} Trimmed input text
   */
  async trim_input_to_max_tokens(embed_input, tokens_ct) {
    const reduce_ratio = (tokens_ct - this.max_tokens) / tokens_ct;
    const new_length = Math.floor(embed_input.length * (1 - reduce_ratio));
    let trimmed_input = embed_input.slice(0, new_length);
    const last_space_index = trimmed_input.lastIndexOf(" ");
    if (last_space_index > 0) {
      trimmed_input = trimmed_input.slice(0, last_space_index);
    }
    const prepared_input = await this.prepare_embed_input(trimmed_input);
    if (prepared_input === null) {
      console.log(
        "Warning: prepare_embed_input resulted in an empty string after trimming"
      );
      return null;
    }
    return prepared_input;
  }
  /**
   * Get the request adapter class.
   * @returns {SmartEmbedOpenAIRequestAdapter} The request adapter class
   */
  get req_adapter() {
    return SmartEmbedOpenAIRequestAdapter;
  }
  /**
   * Get the response adapter class.
   * @returns {SmartEmbedOpenAIResponseAdapter} The response adapter class
   */
  get res_adapter() {
    return SmartEmbedOpenAIResponseAdapter;
  }
  /** @returns {number} Maximum tokens per input */
  get max_tokens() {
    return this.model_config.max_tokens || 8191;
  }
  /** @returns {Object} Settings configuration for OpenAI adapter */
  get settings_config() {
    return {
      ...super.settings_config,
      "[ADAPTER].api_key": {
        name: "OpenAI API key for embeddings",
        type: "password",
        description: "Required for OpenAI embedding models.",
        placeholder: "Enter OpenAI API key"
      }
    };
  }
  /**
   * Get available models (hardcoded list)
   * @returns {Promise<Object>} Map of model objects
   */
  get_models() {
    return Promise.resolve(this.models);
  }
  get models() {
    return {
      "text-embedding-3-small": {
        "id": "text-embedding-3-small",
        "batch_size": 50,
        "dims": 1536,
        "max_tokens": 8191,
        "name": "OpenAI Text-3 Small",
        "description": "API, 8,191 tokens, 1,536 dim",
        "endpoint": "https://api.openai.com/v1/embeddings",
        "adapter": "openai"
      },
      "text-embedding-3-large": {
        "id": "text-embedding-3-large",
        "batch_size": 50,
        "dims": 3072,
        "max_tokens": 8191,
        "name": "OpenAI Text-3 Large",
        "description": "API, 8,191 tokens, 3,072 dim",
        "endpoint": "https://api.openai.com/v1/embeddings",
        "adapter": "openai"
      },
      "text-embedding-3-small-512": {
        "id": "text-embedding-3-small",
        "batch_size": 50,
        "dims": 512,
        "max_tokens": 8191,
        "name": "OpenAI Text-3 Small - 512",
        "description": "API, 8,191 tokens, 512 dim",
        "endpoint": "https://api.openai.com/v1/embeddings",
        "adapter": "openai"
      },
      "text-embedding-3-large-256": {
        "id": "text-embedding-3-large",
        "batch_size": 50,
        "dims": 256,
        "max_tokens": 8191,
        "name": "OpenAI Text-3 Large - 256",
        "description": "API, 8,191 tokens, 256 dim",
        "endpoint": "https://api.openai.com/v1/embeddings",
        "adapter": "openai"
      },
      "text-embedding-ada-002": {
        "id": "text-embedding-ada-002",
        "batch_size": 50,
        "dims": 1536,
        "max_tokens": 8191,
        "name": "OpenAI Ada",
        "description": "API, 8,191 tokens, 1,536 dim",
        "endpoint": "https://api.openai.com/v1/embeddings",
        "adapter": "openai"
      }
    };
  }
};
var SmartEmbedOpenAIRequestAdapter = class extends SmartEmbedModelRequestAdapter {
  /**
   * Prepare request body for OpenAI API
   * @returns {Object} Request body for API
   */
  prepare_request_body() {
    const body = {
      model: this.adapter.model_config.id,
      input: this.embed_inputs
    };
    if (this.adapter.model_key.startsWith("text-embedding-3")) {
      body.dimensions = this.adapter.model_config.dims;
    }
    return body;
  }
};
var SmartEmbedOpenAIResponseAdapter = class extends SmartEmbedModelResponseAdapter {
  /**
   * Parse OpenAI API response
   * @returns {Array<Object>} Parsed embedding results
   */
  parse_response() {
    const resp = this.response;
    if (!resp || !resp.data || !resp.usage) {
      console.error("Invalid response format", resp);
      return [];
    }
    const avg_tokens = resp.usage.total_tokens / resp.data.length;
    return resp.data.map((item) => ({
      vec: item.embedding,
      tokens: avg_tokens
      // OpenAI doesn't provide tokens per item in batch requests
    }));
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/_message.js
var SmartEmbedMessageAdapter = class extends SmartEmbedAdapter {
  /**
   * Create message adapter instance
   * @param {SmartEmbedModel} model - Parent model instance
   */
  constructor(model) {
    super(model);
    this.message_queue = {};
    this.message_id = 0;
    this.connector = null;
    this.message_prefix = `msg_${Math.random().toString(36).substr(2, 9)}_`;
  }
  /**
   * Send message and wait for response
   * @protected
   * @param {string} method - Method name to call
   * @param {Object} params - Method parameters
   * @returns {Promise<any>} Response data
   */
  async _send_message(method, params) {
    return new Promise((resolve, reject) => {
      const id = `${this.message_prefix}${this.message_id++}`;
      this.message_queue[id] = { resolve, reject };
      this._post_message({ method, params, id });
    });
  }
  /**
   * Handle response message from worker/iframe
   * @protected
   * @param {string} id - Message ID
   * @param {*} result - Response result
   * @param {Error} [error] - Response error
   */
  _handle_message_result(id, result, error) {
    if (!id.startsWith(this.message_prefix)) return;
    if (result?.model_loaded) {
      console.log("model loaded");
      this.model.model_loaded = true;
    }
    if (this.message_queue[id]) {
      if (error) {
        this.message_queue[id].reject(new Error(error));
      } else {
        this.message_queue[id].resolve(result);
      }
      delete this.message_queue[id];
    }
  }
  /**
   * Count tokens in input text
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   */
  async count_tokens(input) {
    return this._send_message("count_tokens", { input });
  }
  /**
   * Generate embeddings for multiple inputs
   * @param {Array<Object>} inputs - Array of input objects
   * @returns {Promise<Array<Object>>} Processed inputs with embeddings
   */
  async embed_batch(inputs) {
    inputs = inputs.filter((item) => item.embed_input?.length > 0);
    if (!inputs.length) return [];
    const embed_inputs = inputs.map((item) => ({ embed_input: item.embed_input }));
    const result = await this._send_message("embed_batch", { inputs: embed_inputs });
    return inputs.map((item, i) => {
      item.vec = result[i].vec;
      item.tokens = result[i].tokens;
      return item;
    });
  }
  /**
   * Post message to worker/iframe
   * @abstract
   * @protected
   * @param {Object} message_data - Message to send
   * @throws {Error} If not implemented by subclass
   */
  _post_message(message_data) {
    throw new Error("_post_message must be implemented by subclass");
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/iframe.js
var SmartEmbedIframeAdapter = class extends SmartEmbedMessageAdapter {
  /**
   * Create iframe adapter instance
   * @param {SmartEmbedModel} model - Parent model instance
   */
  constructor(model) {
    super(model);
    this.iframe = null;
    this.origin = window.location.origin;
    this.iframe_id = `smart_embed_iframe`;
  }
  /**
   * Initialize iframe and load model
   * @returns {Promise<void>}
   */
  async load() {
    const existing_iframe = document.getElementById(this.iframe_id);
    if (existing_iframe) {
      existing_iframe.remove();
    }
    this.iframe = document.createElement("iframe");
    this.iframe.style.display = "none";
    this.iframe.id = this.iframe_id;
    document.body.appendChild(this.iframe);
    window.addEventListener("message", this._handle_message.bind(this));
    this.iframe.srcdoc = `
          <html>
            <body>
              <script type="module">
                ${this.connector}
                // Set up a message listener in the iframe
                window.addEventListener('message', async (event) => {
                    if (event.origin !== '${this.origin}' || event.data.iframe_id !== '${this.iframe_id}') return console.log('message ignored (listener)', event);
                    // Process the message and send the response back
                    const response = await process_message(event.data);
                    window.parent.postMessage({ ...response, iframe_id: '${this.iframe_id}' }, '${this.origin}');
                });
              </script>
            </body>
          </html>
        `;
    await new Promise((resolve) => this.iframe.onload = resolve);
    const load_opts = {
      // ...this.model.opts,
      model_key: this.model.model_key,
      adapters: null,
      // cannot clone classes
      settings: null,
      batch_size: this.batch_size,
      use_gpu: this.use_gpu
    };
    await this._send_message("load", load_opts);
    return new Promise((resolve) => {
      const check_model_loaded = () => {
        if (this.model.model_loaded) {
          resolve();
        } else {
          setTimeout(check_model_loaded, 100);
        }
      };
      check_model_loaded();
    });
  }
  /**
   * Post message to iframe
   * @protected
   * @param {Object} message_data - Message to send
   */
  _post_message(message_data) {
    this.iframe.contentWindow.postMessage({ ...message_data, iframe_id: this.iframe_id }, this.origin);
  }
  /**
   * Handle message from iframe
   * @private
   * @param {MessageEvent} event - Message event
   */
  _handle_message(event) {
    if (event.origin !== this.origin || event.data.iframe_id !== this.iframe_id) return;
    const { id, result, error } = event.data;
    this._handle_message_result(id, result, error);
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/connectors/transformers_iframe.js
var transformers_connector = 'var __defProp = Object.defineProperty;\nvar __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;\nvar __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);\n\n// ../smart-model/smart_model.js\nvar SmartModel = class {\n  /**\n   * Create a SmartModel instance.\n   * @param {Object} opts - Configuration options\n   * @param {Object} opts.adapters - Map of adapter names to adapter classes\n   * @param {Object} opts.settings - Model settings configuration\n   * @param {Object} opts.model_config - Model-specific configuration\n   * @param {string} opts.model_config.adapter - Name of the adapter to use\n   * @param {string} [opts.model_key] - Optional model identifier to override settings\n   * @throws {Error} If required options are missing\n   */\n  constructor(opts = {}) {\n    __publicField(this, "scope_name", "smart_model");\n    this.opts = opts;\n    this.validate_opts(opts);\n    this.state = "unloaded";\n    this._adapter = null;\n  }\n  /**\n   * Initialize the model by loading the configured adapter.\n   * @async\n   * @returns {Promise<void>}\n   */\n  async initialize() {\n    this.load_adapter(this.adapter_name);\n    await this.load();\n  }\n  /**\n   * Validate required options.\n   * @param {Object} opts - Configuration options\n   */\n  validate_opts(opts) {\n    if (!opts.adapters) throw new Error("opts.adapters is required");\n    if (!opts.settings) throw new Error("opts.settings is required");\n  }\n  /**\n   * Get the current settings\n   * @returns {Object} Current settings\n   */\n  get settings() {\n    if (!this.opts.settings) this.opts.settings = {\n      ...this.constructor.defaults\n    };\n    return this.opts.settings;\n  }\n  /**\n   * Get the current adapter name\n   * @returns {string} Current adapter name\n   */\n  get adapter_name() {\n    let adapter_key = this.opts.model_config?.adapter || this.opts.adapter || this.settings.adapter || Object.keys(this.adapters)[0];\n    if (!adapter_key || !this.adapters[adapter_key]) {\n      console.warn(`Platform "${adapter_key}" not supported`);\n      adapter_key = Object.keys(this.adapters)[0];\n    }\n    return adapter_key;\n  }\n  /**\n   * Get adapter-specific settings.\n   * @returns {Object} Settings for current adapter\n   */\n  get adapter_settings() {\n    if (!this.settings[this.adapter_name]) this.settings[this.adapter_name] = {};\n    return this.settings[this.adapter_name];\n  }\n  get adapter_config() {\n    const base_config = this.adapters[this.adapter_name]?.defaults || {};\n    return {\n      ...base_config,\n      ...this.adapter_settings,\n      ...this.opts.adapter_config\n    };\n  }\n  /**\n   * Get available models.\n   * @returns {Object} Map of model objects\n   */\n  get models() {\n    return this.adapter.models;\n  }\n  /**\n   * Get default model key.\n   * @returns {string} Default model key\n   */\n  get default_model_key() {\n    return this.adapter.constructor.defaults.default_model;\n  }\n  /**\n   * Get the current model key\n   * @returns {string} Current model key\n   */\n  get model_key() {\n    return this.opts.model_key || this.adapter_config.model_key || this.settings.model_key || this.default_model_key;\n  }\n  /**\n   * Get the current model configuration\n   * @returns {Object} Combined base and custom model configuration\n   */\n  get model_config() {\n    const model_key = this.model_key;\n    const base_model_config = this.models[model_key] || {};\n    return {\n      ...this.adapter_config,\n      ...base_model_config,\n      ...this.opts.model_config\n    };\n  }\n  get model_settings() {\n    if (!this.settings[this.model_key]) this.settings[this.model_key] = {};\n    return this.settings[this.model_key];\n  }\n  /**\n   * Load the current adapter and transition to loaded state.\n   * @async\n   * @returns {Promise<void>}\n   */\n  async load() {\n    this.set_state("loading");\n    try {\n      if (!this.adapter?.is_loaded) {\n        await this.invoke_adapter_method("load");\n      }\n    } catch (err) {\n      this.set_state("unloaded");\n      if (!this.reload_model_timeout) {\n        this.reload_model_timeout = setTimeout(async () => {\n          this.reload_model_timeout = null;\n          await this.load();\n          this.set_state("loaded");\n          this.notices?.show("Loaded model: " + this.model_key);\n        }, 6e4);\n      }\n      throw new Error(`Failed to load model: ${err.message}`);\n    }\n    this.set_state("loaded");\n  }\n  /**\n   * Unload the current adapter and transition to unloaded state.\n   * @async\n   * @returns {Promise<void>}\n   */\n  async unload() {\n    if (this.adapter?.is_loaded) {\n      this.set_state("unloading");\n      await this.invoke_adapter_method("unload");\n      this.set_state("unloaded");\n    }\n  }\n  /**\n   * Set the model\'s state.\n   * @param {(\'unloaded\'|\'loading\'|\'loaded\'|\'unloading\')} new_state - The new state\n   * @throws {Error} If the state is invalid\n   */\n  set_state(new_state) {\n    const valid_states = ["unloaded", "loading", "loaded", "unloading"];\n    if (!valid_states.includes(new_state)) {\n      throw new Error(`Invalid state: ${new_state}`);\n    }\n    this.state = new_state;\n  }\n  get is_loading() {\n    return this.state === "loading";\n  }\n  get is_loaded() {\n    return this.state === "loaded";\n  }\n  get is_unloading() {\n    return this.state === "unloading";\n  }\n  get is_unloaded() {\n    return this.state === "unloaded";\n  }\n  // ADAPTERS\n  /**\n   * Get the map of available adapters\n   * @returns {Object} Map of adapter names to adapter classes\n   */\n  get adapters() {\n    return this.opts.adapters || {};\n  }\n  /**\n   * Load a specific adapter by name.\n   * @async\n   * @param {string} adapter_name - Name of the adapter to load\n   * @throws {Error} If adapter not found or loading fails\n   * @returns {Promise<void>}\n   */\n  async load_adapter(adapter_name) {\n    this.set_adapter(adapter_name);\n    if (!this._adapter.loaded) {\n      this.set_state("loading");\n      try {\n        await this.invoke_adapter_method("load");\n        this.set_state("loaded");\n      } catch (err) {\n        this.set_state("unloaded");\n        throw new Error(`Failed to load adapter: ${err.message}`);\n      }\n    }\n  }\n  /**\n   * Set an adapter instance by name without loading it.\n   * @param {string} adapter_name - Name of the adapter to set\n   * @throws {Error} If adapter not found\n   */\n  set_adapter(adapter_name) {\n    const AdapterClass = this.adapters[adapter_name];\n    if (!AdapterClass) {\n      throw new Error(`Adapter "${adapter_name}" not found.`);\n    }\n    if (this._adapter?.constructor.name.toLowerCase() === adapter_name.toLowerCase()) {\n      return;\n    }\n    this._adapter = new AdapterClass(this);\n  }\n  /**\n   * Get the current active adapter instance\n   * @returns {Object} The active adapter instance\n   * @throws {Error} If adapter not found\n   */\n  get adapter() {\n    const adapter_name = this.adapter_name;\n    if (!adapter_name) {\n      throw new Error(`Adapter not set for model.`);\n    }\n    if (!this._adapter) {\n      this.load_adapter(adapter_name);\n    }\n    return this._adapter;\n  }\n  /**\n   * Ensure the adapter is ready to execute a method.\n   * @param {string} method - Name of the method to check\n   * @throws {Error} If adapter not loaded or method not implemented\n   */\n  ensure_adapter_ready(method) {\n    if (!this.adapter) {\n      throw new Error("No adapter loaded.");\n    }\n    if (typeof this.adapter[method] !== "function") {\n      throw new Error(`Adapter does not implement method: ${method}`);\n    }\n  }\n  /**\n   * Invoke a method on the current adapter.\n   * @async\n   * @param {string} method - Name of the method to call\n   * @param {...any} args - Arguments to pass to the method\n   * @returns {Promise<any>} Result from the adapter method\n   * @throws {Error} If adapter not ready or method fails\n   */\n  async invoke_adapter_method(method, ...args) {\n    this.ensure_adapter_ready(method);\n    return await this.adapter[method](...args);\n  }\n  /**\n   * Get platforms as dropdown options.\n   * @returns {Array<Object>} Array of {value, name} option objects\n   */\n  get_platforms_as_options() {\n    return Object.entries(this.adapters).map(([key, AdapterClass]) => ({ value: key, name: AdapterClass.defaults.description || key }));\n  }\n  // SETTINGS\n  /**\n   * Get the settings configuration schema\n   * @returns {Object} Settings configuration object\n   */\n  get settings_config() {\n    return this.process_settings_config({\n      adapter: {\n        name: "Model Platform",\n        type: "dropdown",\n        description: "Select a model platform to use with Smart Model.",\n        options_callback: "get_platforms_as_options",\n        is_scope: true,\n        // trigger re-render of settings when changed\n        callback: "adapter_changed",\n        default: "default"\n      }\n    });\n  }\n  /**\n   * Process settings configuration with conditionals and prefixes.\n   * @param {Object} _settings_config - Raw settings configuration\n   * @param {string} [prefix] - Optional prefix for setting keys\n   * @returns {Object} Processed settings configuration\n   */\n  process_settings_config(_settings_config, prefix = null) {\n    return Object.entries(_settings_config).reduce((acc, [key, val]) => {\n      const new_key = (prefix ? prefix + "." : "") + this.process_setting_key(key);\n      acc[new_key] = val;\n      return acc;\n    }, {});\n  }\n  /**\n   * Process an individual setting key.\n   * Example: replace placeholders with actual adapter names.\n   * @param {string} key - The setting key with placeholders.\n   * @returns {string} Processed setting key.\n   */\n  process_setting_key(key) {\n    return key.replace(/\\[ADAPTER\\]/g, this.adapter_name);\n  }\n  re_render_settings() {\n    if (typeof this.opts.re_render_settings === "function") this.opts.re_render_settings();\n    else console.warn("re_render_settings is not a function (must be passed in model opts)");\n  }\n  /**\n   * Reload model.\n   */\n  reload_model() {\n    if (typeof this.opts.reload_model === "function") this.opts.reload_model();\n    else console.warn("reload_model is not a function (must be passed in model opts)");\n  }\n  adapter_changed() {\n    this.reload_model();\n    this.re_render_settings();\n  }\n  model_changed() {\n    this.reload_model();\n    this.re_render_settings();\n  }\n};\n__publicField(SmartModel, "defaults", {\n  // override in sub-class if needed\n});\n\n// smart_embed_model.js\nvar SmartEmbedModel = class extends SmartModel {\n  /**\n   * Create a SmartEmbedModel instance\n   * @param {Object} opts - Configuration options\n   * @param {Object} [opts.adapters] - Map of available adapter implementations\n   * @param {boolean} [opts.use_gpu] - Whether to enable GPU acceleration\n   * @param {number} [opts.gpu_batch_size] - Batch size when using GPU\n   * @param {number} [opts.batch_size] - Default batch size for processing\n   * @param {Object} [opts.model_config] - Model-specific configuration\n   * @param {string} [opts.model_config.adapter] - Override adapter type\n   * @param {number} [opts.model_config.dims] - Embedding dimensions\n   * @param {number} [opts.model_config.max_tokens] - Maximum tokens to process\n   * @param {Object} [opts.settings] - User settings\n   * @param {string} [opts.settings.api_key] - API key for remote models\n   * @param {number} [opts.settings.min_chars] - Minimum text length to embed\n   */\n  constructor(opts = {}) {\n    super(opts);\n    __publicField(this, "scope_name", "smart_embed_model");\n  }\n  /**\n   * Count tokens in an input string\n   * @param {string} input - Text to tokenize\n   * @returns {Promise<Object>} Token count result\n   * @property {number} tokens - Number of tokens in input\n   * \n   * @example\n   * ```javascript\n   * const result = await model.count_tokens("Hello world");\n   * console.log(result.tokens); // 2\n   * ```\n   */\n  async count_tokens(input) {\n    return await this.invoke_adapter_method("count_tokens", input);\n  }\n  /**\n   * Generate embeddings for a single input\n   * @param {string|Object} input - Text or object with embed_input property\n   * @returns {Promise<Object>} Embedding result\n   * @property {number[]} vec - Embedding vector\n   * @property {number} tokens - Token count\n   * \n   * @example\n   * ```javascript\n   * const result = await model.embed("Hello world");\n   * console.log(result.vec); // [0.1, 0.2, ...]\n   * ```\n   */\n  async embed(input) {\n    if (typeof input === "string") input = { embed_input: input };\n    return (await this.embed_batch([input]))[0];\n  }\n  /**\n   * Generate embeddings for multiple inputs in batch\n   * @param {Array<string|Object>} inputs - Array of texts or objects with embed_input\n   * @returns {Promise<Array<Object>>} Array of embedding results\n   * @property {number[]} vec - Embedding vector for each input\n   * @property {number} tokens - Token count for each input\n   * \n   * @example\n   * ```javascript\n   * const results = await model.embed_batch([\n   *   { embed_input: "First text" },\n   *   { embed_input: "Second text" }\n   * ]);\n   * ```\n   */\n  async embed_batch(inputs) {\n    return await this.invoke_adapter_method("embed_batch", inputs);\n  }\n  /**\n   * Get the current batch size based on GPU settings\n   * @returns {number} Current batch size for processing\n   */\n  get batch_size() {\n    return this.adapter.batch_size || 1;\n  }\n  /**\n   * Get settings configuration schema\n   * @returns {Object} Settings configuration object\n   */\n  get settings_config() {\n    const _settings_config = {\n      adapter: {\n        name: "Embedding model platform",\n        type: "dropdown",\n        description: "Select an embedding model platform. The default \'transformers\' utilizes built-in local models.",\n        options_callback: "get_platforms_as_options",\n        callback: "adapter_changed",\n        default: this.constructor.defaults.adapter\n      },\n      ...this.adapter.settings_config || {}\n    };\n    return this.process_settings_config(_settings_config);\n  }\n  process_setting_key(key) {\n    return key.replace(/\\[ADAPTER\\]/g, this.adapter_name);\n  }\n  /**\n   * Get available embedding model options\n   * @returns {Array<Object>} Array of model options with value and name\n   */\n  get_embedding_model_options() {\n    return Object.entries(this.models).map(([key, model2]) => ({ value: key, name: key }));\n  }\n  // /**\n  //  * Get embedding model options including \'None\' option\n  //  * @returns {Array<Object>} Array of model options with value and name\n  //  */\n  // get_block_embedding_model_options() {\n  //   const options = this.get_embedding_model_options();\n  //   options.unshift({ value: \'None\', name: \'None\' });\n  //   return options;\n  // }\n};\n__publicField(SmartEmbedModel, "defaults", {\n  adapter: "transformers"\n});\n\n// ../smart-model/adapters/_adapter.js\nvar SmartModelAdapter = class {\n  /**\n   * Create a SmartModelAdapter instance.\n   * @param {SmartModel} model - The parent SmartModel instance\n   */\n  constructor(model2) {\n    this.model = model2;\n    this.state = "unloaded";\n  }\n  /**\n   * Load the adapter.\n   * @async\n   * @returns {Promise<void>}\n   */\n  async load() {\n    this.set_state("loaded");\n  }\n  /**\n   * Unload the adapter.\n   * @returns {void}\n   */\n  unload() {\n    this.set_state("unloaded");\n  }\n  /**\n   * Get all settings.\n   * @returns {Object} All settings\n   */\n  get settings() {\n    return this.model.settings;\n  }\n  /**\n   * Get the current model key.\n   * @returns {string} Current model identifier\n   */\n  get model_key() {\n    return this.model.model_key;\n  }\n  /**\n   * Get the current model configuration.\n   * @returns {Object} Model configuration\n   */\n  get model_config() {\n    return this.model.model_config;\n  }\n  /**\n   * Get model-specific settings.\n   * @returns {Object} Settings for current model\n   */\n  get model_settings() {\n    return this.model.model_settings;\n  }\n  /**\n   * Get adapter-specific configuration.\n   * @returns {Object} Adapter configuration\n   */\n  get adapter_config() {\n    return this.model.adapter_config;\n  }\n  /**\n   * Get adapter-specific settings.\n   * @returns {Object} Adapter settings\n   */\n  get adapter_settings() {\n    return this.model.adapter_settings;\n  }\n  /**\n   * Get the models.\n   * @returns {Object} Map of model objects\n   */\n  get models() {\n    if (typeof this.adapter_config.models === "object" && Object.keys(this.adapter_config.models || {}).length > 0) return this.adapter_config.models;\n    else {\n      return {};\n    }\n  }\n  /**\n   * Get available models from the API.\n   * @abstract\n   * @param {boolean} [refresh=false] - Whether to refresh cached models\n   * @returns {Promise<Object>} Map of model objects\n   */\n  async get_models(refresh = false) {\n    throw new Error("get_models not implemented");\n  }\n  /**\n   * Validate the parameters for get_models.\n   * @returns {boolean|Array<Object>} True if parameters are valid, otherwise an array of error objects\n   */\n  validate_get_models_params() {\n    return true;\n  }\n  /**\n   * Get available models as dropdown options synchronously.\n   * @returns {Array<Object>} Array of model options.\n   */\n  get_models_as_options() {\n    const models = this.models;\n    const params_valid = this.validate_get_models_params();\n    if (params_valid !== true) return params_valid;\n    if (!Object.keys(models || {}).length) {\n      this.get_models(true);\n      return [{ value: "", name: "No models currently available" }];\n    }\n    return Object.entries(models).map(([id, model2]) => ({ value: id, name: model2.name || id })).sort((a, b) => a.name.localeCompare(b.name));\n  }\n  /**\n   * Set the adapter\'s state.\n   * @deprecated should be handled in SmartModel (only handle once)\n   * @param {(\'unloaded\'|\'loading\'|\'loaded\'|\'unloading\')} new_state - The new state\n   * @throws {Error} If the state is invalid\n   */\n  set_state(new_state) {\n    const valid_states = ["unloaded", "loading", "loaded", "unloading"];\n    if (!valid_states.includes(new_state)) {\n      throw new Error(`Invalid state: ${new_state}`);\n    }\n    this.state = new_state;\n  }\n  // Replace individual state getters/setters with a unified state management\n  get is_loading() {\n    return this.state === "loading";\n  }\n  get is_loaded() {\n    return this.state === "loaded";\n  }\n  get is_unloading() {\n    return this.state === "unloading";\n  }\n  get is_unloaded() {\n    return this.state === "unloaded";\n  }\n};\n\n// adapters/_adapter.js\nvar SmartEmbedAdapter = class extends SmartModelAdapter {\n  /**\n   * Create adapter instance\n   * @param {SmartEmbedModel} model - Parent model instance\n   */\n  constructor(model2) {\n    super(model2);\n    this.smart_embed = model2;\n  }\n  /**\n   * Count tokens in input text\n   * @abstract\n   * @param {string} input - Text to tokenize\n   * @returns {Promise<Object>} Token count result\n   * @property {number} tokens - Number of tokens in input\n   * @throws {Error} If not implemented by subclass\n   */\n  async count_tokens(input) {\n    throw new Error("count_tokens method not implemented");\n  }\n  /**\n   * Generate embeddings for single input\n   * @abstract\n   * @param {string|Object} input - Text to embed\n   * @returns {Promise<Object>} Embedding result\n   * @property {number[]} vec - Embedding vector\n   * @property {number} tokens - Number of tokens in input\n   * @throws {Error} If not implemented by subclass\n   */\n  async embed(input) {\n    throw new Error("embed method not implemented");\n  }\n  /**\n   * Generate embeddings for multiple inputs\n   * @abstract\n   * @param {Array<string|Object>} inputs - Texts to embed\n   * @returns {Promise<Array<Object>>} Array of embedding results\n   * @property {number[]} vec - Embedding vector for each input\n   * @property {number} tokens - Number of tokens in each input\n   * @throws {Error} If not implemented by subclass\n   */\n  async embed_batch(inputs) {\n    throw new Error("embed_batch method not implemented");\n  }\n  get settings_config() {\n    return {\n      "[ADAPTER].model_key": {\n        name: "Embedding model",\n        type: "dropdown",\n        description: "Select an embedding model.",\n        options_callback: "adapter.get_models_as_options",\n        callback: "model_changed",\n        default: this.constructor.defaults.default_model\n      }\n    };\n  }\n  get dims() {\n    return this.model_config.dims;\n  }\n  get max_tokens() {\n    return this.model_config.max_tokens;\n  }\n  // get batch_size() { return this.model_config.batch_size; }\n  get use_gpu() {\n    if (typeof this._use_gpu === "undefined") {\n      if (typeof this.model.opts.use_gpu !== "undefined") this._use_gpu = this.model.opts.use_gpu;\n      else this._use_gpu = typeof navigator !== "undefined" && !!navigator?.gpu && this.model_settings.gpu_batch_size !== 0;\n    }\n    return this._use_gpu;\n  }\n  set use_gpu(value) {\n    this._use_gpu = value;\n  }\n  get batch_size() {\n    if (this.use_gpu && this.model_config?.gpu_batch_size) return this.model_config.gpu_batch_size;\n    return this.model.opts.batch_size || this.model_config.batch_size || 1;\n  }\n};\n/**\n * @override in sub-class with adapter-specific default configurations\n * @property {string} id - The adapter identifier\n * @property {string} description - Human-readable description\n * @property {string} type - Adapter type ("API")\n * @property {string} endpoint - API endpoint\n * @property {string} adapter - Adapter identifier\n * @property {string} default_model - Default model to use\n */\n__publicField(SmartEmbedAdapter, "defaults", {});\n\n// adapters/transformers.js\nvar transformers_defaults = {\n  adapter: "transformers",\n  description: "Transformers (Local, built-in)",\n  default_model: "TaylorAI/bge-micro-v2"\n};\nvar SmartEmbedTransformersAdapter = class extends SmartEmbedAdapter {\n  /**\n   * Create transformers adapter instance\n   * @param {SmartEmbedModel} model - Parent model instance\n   */\n  constructor(model2) {\n    super(model2);\n    this.pipeline = null;\n    this.tokenizer = null;\n  }\n  /**\n   * Load model and tokenizer\n   * @returns {Promise<void>}\n   */\n  async load() {\n    await this.load_transformers();\n    this.loaded = true;\n    this.set_state("loaded");\n  }\n  /**\n   * Unload model and free resources\n   * @returns {Promise<void>}\n   */\n  async unload() {\n    if (this.pipeline) {\n      if (this.pipeline.destroy) this.pipeline.destroy();\n      this.pipeline = null;\n    }\n    if (this.tokenizer) {\n      this.tokenizer = null;\n    }\n    this.loaded = false;\n    this.set_state("unloaded");\n  }\n  /**\n   * Initialize transformers pipeline and tokenizer\n   * @private\n   * @returns {Promise<void>}\n   */\n  async load_transformers() {\n    const { pipeline, env, AutoTokenizer } = await import("@huggingface/transformers");\n    env.allowLocalModels = false;\n    const pipeline_opts = {\n      quantized: true\n    };\n    if (this.use_gpu) {\n      console.log("[Transformers] Using GPU");\n      pipeline_opts.device = "webgpu";\n      pipeline_opts.dtype = "fp32";\n    } else {\n      console.log("[Transformers] Using CPU");\n      env.backends.onnx.wasm.numThreads = 8;\n    }\n    this.pipeline = await pipeline("feature-extraction", this.model_key, pipeline_opts);\n    this.tokenizer = await AutoTokenizer.from_pretrained(this.model_key);\n  }\n  /**\n   * Count tokens in input text\n   * @param {string} input - Text to tokenize\n   * @returns {Promise<Object>} Token count result\n   */\n  async count_tokens(input) {\n    if (!this.tokenizer) await this.load();\n    const { input_ids } = await this.tokenizer(input);\n    return { tokens: input_ids.data.length };\n  }\n  /**\n   * Generate embeddings for multiple inputs\n   * @param {Array<Object>} inputs - Array of input objects\n   * @returns {Promise<Array<Object>>} Processed inputs with embeddings\n   */\n  async embed_batch(inputs) {\n    if (!this.pipeline) await this.load();\n    const filtered_inputs = inputs.filter((item) => item.embed_input?.length > 0);\n    if (!filtered_inputs.length) return [];\n    if (filtered_inputs.length > this.batch_size) {\n      console.log(`Processing ${filtered_inputs.length} inputs in batches of ${this.batch_size}`);\n      const results = [];\n      for (let i = 0; i < filtered_inputs.length; i += this.batch_size) {\n        const batch = filtered_inputs.slice(i, i + this.batch_size);\n        const batch_results = await this._process_batch(batch);\n        results.push(...batch_results);\n      }\n      return results;\n    }\n    return await this._process_batch(filtered_inputs);\n  }\n  /**\n   * Process a single batch of inputs\n   * @private\n   * @param {Array<Object>} batch_inputs - Batch of inputs to process\n   * @returns {Promise<Array<Object>>} Processed batch results\n   */\n  async _process_batch(batch_inputs) {\n    const tokens = await Promise.all(batch_inputs.map((item) => this.count_tokens(item.embed_input)));\n    const embed_inputs = await Promise.all(batch_inputs.map(async (item, i) => {\n      if (tokens[i].tokens < this.max_tokens) return item.embed_input;\n      let token_ct = tokens[i].tokens;\n      let truncated_input = item.embed_input;\n      while (token_ct > this.max_tokens) {\n        const pct = this.max_tokens / token_ct;\n        const max_chars = Math.floor(truncated_input.length * pct * 0.9);\n        truncated_input = truncated_input.substring(0, max_chars) + "...";\n        token_ct = (await this.count_tokens(truncated_input)).tokens;\n      }\n      tokens[i].tokens = token_ct;\n      return truncated_input;\n    }));\n    try {\n      const resp = await this.pipeline(embed_inputs, { pooling: "mean", normalize: true });\n      return batch_inputs.map((item, i) => {\n        item.vec = Array.from(resp[i].data).map((val) => Math.round(val * 1e8) / 1e8);\n        item.tokens = tokens[i].tokens;\n        return item;\n      });\n    } catch (err) {\n      console.error("error_processing_batch", err);\n      this.pipeline?.dispose();\n      this.pipeline = null;\n      await this.load();\n      return Promise.all(batch_inputs.map(async (item) => {\n        try {\n          const result = await this.pipeline(item.embed_input, { pooling: "mean", normalize: true });\n          item.vec = Array.from(result[0].data).map((val) => Math.round(val * 1e8) / 1e8);\n          item.tokens = (await this.count_tokens(item.embed_input)).tokens;\n          return item;\n        } catch (single_err) {\n          console.error("error_processing_single_item", single_err);\n          return {\n            ...item,\n            vec: [],\n            tokens: 0,\n            error: single_err.message\n          };\n        }\n      }));\n    }\n  }\n  /** @returns {Object} Settings configuration for transformers adapter */\n  get settings_config() {\n    return transformers_settings_config;\n  }\n  /**\n   * Get available models (hardcoded list)\n   * @returns {Promise<Object>} Map of model objects\n   */\n  get_models() {\n    return Promise.resolve(this.models);\n  }\n  get models() {\n    return transformers_models;\n  }\n};\n__publicField(SmartEmbedTransformersAdapter, "defaults", transformers_defaults);\nvar transformers_models = {\n  "TaylorAI/bge-micro-v2": {\n    "id": "TaylorAI/bge-micro-v2",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "BGE-micro-v2",\n    "description": "Local, 512 tokens, 384 dim (recommended)",\n    "adapter": "transformers"\n  },\n  "Snowflake/snowflake-arctic-embed-xs": {\n    "id": "Snowflake/snowflake-arctic-embed-xs",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "Snowflake Arctic Embed XS",\n    "description": "Local, 512 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  "Snowflake/snowflake-arctic-embed-s": {\n    "id": "Snowflake/snowflake-arctic-embed-s",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "Snowflake Arctic Embed Small",\n    "description": "Local, 512 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  "Snowflake/snowflake-arctic-embed-m": {\n    "id": "Snowflake/snowflake-arctic-embed-m",\n    "batch_size": 1,\n    "dims": 768,\n    "max_tokens": 512,\n    "name": "Snowflake Arctic Embed Medium",\n    "description": "Local, 512 tokens, 768 dim",\n    "adapter": "transformers"\n  },\n  "TaylorAI/gte-tiny": {\n    "id": "TaylorAI/gte-tiny",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "GTE-tiny",\n    "description": "Local, 512 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  "onnx-community/embeddinggemma-300m-ONNX": {\n    "id": "onnx-community/embeddinggemma-300m-ONNX",\n    "batch_size": 1,\n    "dims": 768,\n    "max_tokens": 2048,\n    "name": "EmbeddingGemma-300M",\n    "description": "Local, 2,048 tokens, 768 dim",\n    "adapter": "transformers"\n  },\n  "Mihaiii/Ivysaur": {\n    "id": "Mihaiii/Ivysaur",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "Ivysaur",\n    "description": "Local, 512 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  "andersonbcdefg/bge-small-4096": {\n    "id": "andersonbcdefg/bge-small-4096",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 4096,\n    "name": "BGE-small-4K",\n    "description": "Local, 4,096 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  // Too slow and persistent crashes\n  // "jinaai/jina-embeddings-v2-base-de": {\n  //   "id": "jinaai/jina-embeddings-v2-base-de",\n  //   "batch_size": 1,\n  //   "dims": 768,\n  //   "max_tokens": 4096,\n  //   "name": "jina-embeddings-v2-base-de",\n  //   "description": "Local, 4,096 tokens, 768 dim, German",\n  //   "adapter": "transformers"\n  // },\n  "Xenova/jina-embeddings-v2-base-zh": {\n    "id": "Xenova/jina-embeddings-v2-base-zh",\n    "batch_size": 1,\n    "dims": 768,\n    "max_tokens": 8192,\n    "name": "Jina-v2-base-zh-8K",\n    "description": "Local, 8,192 tokens, 768 dim, Chinese/English bilingual",\n    "adapter": "transformers"\n  },\n  "Xenova/jina-embeddings-v2-small-en": {\n    "id": "Xenova/jina-embeddings-v2-small-en",\n    "batch_size": 1,\n    "dims": 512,\n    "max_tokens": 8192,\n    "name": "Jina-v2-small-en",\n    "description": "Local, 8,192 tokens, 512 dim",\n    "adapter": "transformers"\n  },\n  "nomic-ai/nomic-embed-text-v1.5": {\n    "id": "nomic-ai/nomic-embed-text-v1.5",\n    "batch_size": 1,\n    "dims": 768,\n    "max_tokens": 2048,\n    "name": "Nomic-embed-text-v1.5",\n    "description": "Local, 8,192 tokens, 768 dim",\n    "adapter": "transformers"\n  },\n  "Xenova/bge-small-en-v1.5": {\n    "id": "Xenova/bge-small-en-v1.5",\n    "batch_size": 1,\n    "dims": 384,\n    "max_tokens": 512,\n    "name": "BGE-small",\n    "description": "Local, 512 tokens, 384 dim",\n    "adapter": "transformers"\n  },\n  "nomic-ai/nomic-embed-text-v1": {\n    "id": "nomic-ai/nomic-embed-text-v1",\n    "batch_size": 1,\n    "dims": 768,\n    "max_tokens": 2048,\n    "name": "Nomic-embed-text",\n    "description": "Local, 2,048 tokens, 768 dim",\n    "adapter": "transformers"\n  }\n};\nvar transformers_settings_config = {\n  "[ADAPTER].gpu_batch_size": {\n    name: "GPU batch size",\n    type: "number",\n    description: "Number of embeddings to process per batch on GPU. Use 0 to disable GPU.",\n    placeholder: "Enter number ex. 10"\n  },\n  "[ADAPTER].legacy_transformers": {\n    name: "Legacy transformers (no GPU)",\n    type: "toggle",\n    description: "Use legacy transformers (v2) instead of v3. This may resolve issues if the local embedding isn\'t working.",\n    callback: "embed_model_changed",\n    default: true\n  }\n};\n\n// build/transformers_iframe_script.js\nvar model = null;\nasync function process_message(data) {\n  const { method, params, id, iframe_id } = data;\n  try {\n    let result;\n    switch (method) {\n      case "init":\n        console.log("init");\n        break;\n      case "load":\n        console.log("load", params);\n        model = new SmartEmbedModel({\n          ...params,\n          adapters: { transformers: SmartEmbedTransformersAdapter },\n          adapter: "transformers",\n          settings: {}\n        });\n        await model.load();\n        result = { model_loaded: true };\n        break;\n      case "embed_batch":\n        if (!model) throw new Error("Model not loaded");\n        result = await model.embed_batch(params.inputs);\n        break;\n      case "count_tokens":\n        if (!model) throw new Error("Model not loaded");\n        result = await model.count_tokens(params);\n        break;\n      default:\n        throw new Error(`Unknown method: ${method}`);\n    }\n    return { id, result, iframe_id };\n  } catch (error) {\n    console.error("Error processing message:", error);\n    return { id, error: error.message, iframe_id };\n  }\n}\nprocess_message({ method: "init" });\n';

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/transformers.js
var transformers_defaults = {
  adapter: "transformers",
  description: "Transformers (Local, built-in)",
  default_model: "TaylorAI/bge-micro-v2"
};
var transformers_models = {
  "TaylorAI/bge-micro-v2": {
    "id": "TaylorAI/bge-micro-v2",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "BGE-micro-v2",
    "description": "Local, 512 tokens, 384 dim (recommended)",
    "adapter": "transformers"
  },
  "Snowflake/snowflake-arctic-embed-xs": {
    "id": "Snowflake/snowflake-arctic-embed-xs",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "Snowflake Arctic Embed XS",
    "description": "Local, 512 tokens, 384 dim",
    "adapter": "transformers"
  },
  "Snowflake/snowflake-arctic-embed-s": {
    "id": "Snowflake/snowflake-arctic-embed-s",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "Snowflake Arctic Embed Small",
    "description": "Local, 512 tokens, 384 dim",
    "adapter": "transformers"
  },
  "Snowflake/snowflake-arctic-embed-m": {
    "id": "Snowflake/snowflake-arctic-embed-m",
    "batch_size": 1,
    "dims": 768,
    "max_tokens": 512,
    "name": "Snowflake Arctic Embed Medium",
    "description": "Local, 512 tokens, 768 dim",
    "adapter": "transformers"
  },
  "TaylorAI/gte-tiny": {
    "id": "TaylorAI/gte-tiny",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "GTE-tiny",
    "description": "Local, 512 tokens, 384 dim",
    "adapter": "transformers"
  },
  "onnx-community/embeddinggemma-300m-ONNX": {
    "id": "onnx-community/embeddinggemma-300m-ONNX",
    "batch_size": 1,
    "dims": 768,
    "max_tokens": 2048,
    "name": "EmbeddingGemma-300M",
    "description": "Local, 2,048 tokens, 768 dim",
    "adapter": "transformers"
  },
  "Mihaiii/Ivysaur": {
    "id": "Mihaiii/Ivysaur",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "Ivysaur",
    "description": "Local, 512 tokens, 384 dim",
    "adapter": "transformers"
  },
  "andersonbcdefg/bge-small-4096": {
    "id": "andersonbcdefg/bge-small-4096",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 4096,
    "name": "BGE-small-4K",
    "description": "Local, 4,096 tokens, 384 dim",
    "adapter": "transformers"
  },
  // Too slow and persistent crashes
  // "jinaai/jina-embeddings-v2-base-de": {
  //   "id": "jinaai/jina-embeddings-v2-base-de",
  //   "batch_size": 1,
  //   "dims": 768,
  //   "max_tokens": 4096,
  //   "name": "jina-embeddings-v2-base-de",
  //   "description": "Local, 4,096 tokens, 768 dim, German",
  //   "adapter": "transformers"
  // },
  "Xenova/jina-embeddings-v2-base-zh": {
    "id": "Xenova/jina-embeddings-v2-base-zh",
    "batch_size": 1,
    "dims": 768,
    "max_tokens": 8192,
    "name": "Jina-v2-base-zh-8K",
    "description": "Local, 8,192 tokens, 768 dim, Chinese/English bilingual",
    "adapter": "transformers"
  },
  "Xenova/jina-embeddings-v2-small-en": {
    "id": "Xenova/jina-embeddings-v2-small-en",
    "batch_size": 1,
    "dims": 512,
    "max_tokens": 8192,
    "name": "Jina-v2-small-en",
    "description": "Local, 8,192 tokens, 512 dim",
    "adapter": "transformers"
  },
  "nomic-ai/nomic-embed-text-v1.5": {
    "id": "nomic-ai/nomic-embed-text-v1.5",
    "batch_size": 1,
    "dims": 768,
    "max_tokens": 2048,
    "name": "Nomic-embed-text-v1.5",
    "description": "Local, 8,192 tokens, 768 dim",
    "adapter": "transformers"
  },
  "Xenova/bge-small-en-v1.5": {
    "id": "Xenova/bge-small-en-v1.5",
    "batch_size": 1,
    "dims": 384,
    "max_tokens": 512,
    "name": "BGE-small",
    "description": "Local, 512 tokens, 384 dim",
    "adapter": "transformers"
  },
  "nomic-ai/nomic-embed-text-v1": {
    "id": "nomic-ai/nomic-embed-text-v1",
    "batch_size": 1,
    "dims": 768,
    "max_tokens": 2048,
    "name": "Nomic-embed-text",
    "description": "Local, 2,048 tokens, 768 dim",
    "adapter": "transformers"
  }
};
var transformers_settings_config = {
  "[ADAPTER].gpu_batch_size": {
    name: "GPU batch size",
    type: "number",
    description: "Number of embeddings to process per batch on GPU. Use 0 to disable GPU.",
    placeholder: "Enter number ex. 10"
  },
  "[ADAPTER].legacy_transformers": {
    name: "Legacy transformers (no GPU)",
    type: "toggle",
    description: "Use legacy transformers (v2) instead of v3. This may resolve issues if the local embedding isn't working.",
    callback: "embed_model_changed",
    default: true
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/transformers_iframe.js
var SmartEmbedTransformersIframeAdapter = class extends SmartEmbedIframeAdapter {
  static defaults = transformers_defaults;
  /**
   * Create transformers iframe adapter instance
   * @param {SmartEmbedModel} model - Parent model instance
   */
  constructor(model) {
    super(model);
    this.connector = transformers_connector;
    if (this.adapter_settings.legacy_transformers || !this.use_gpu) {
      this.connector = this.connector.replace("@huggingface/transformers", "https://cdn.jsdelivr.net/npm/@xenova/transformers@2.17.2");
      this.use_gpu = false;
    } else this.connector = this.connector.replace("@huggingface/transformers", "https://cdn.jsdelivr.net/npm/@huggingface/transformers@3.5.1");
  }
  /** @returns {Object} Settings configuration for transformers adapter */
  get settings_config() {
    return {
      ...super.settings_config,
      ...transformers_settings_config
    };
  }
  /**
   * Get available models (hardcoded list)
   * @returns {Promise<Object>} Map of model objects
   */
  get_models() {
    return Promise.resolve(this.models);
  }
  get models() {
    return transformers_models;
  }
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/adapters/ollama.js
var SmartEmbedOllamaAdapter = class extends SmartEmbedModelApiAdapter {
  static defaults = {
    description: "Ollama (Local)",
    type: "API",
    host: "http://localhost:11434",
    endpoint: "/api/embed",
    models_endpoint: "/api/tags",
    api_key: "na",
    // Not required for local instance
    streaming: false,
    // Ollama's embed API does not support streaming
    max_tokens: 512,
    // Example default, adjust based on model capabilities
    signup_url: null,
    // Not applicable for local instance
    batch_size: 30,
    models: {},
    model_key: "nomic-embed-text"
  };
  get endpoint() {
    return `${this.model_config.host}${this.model_config.endpoint}`;
  }
  get models_endpoint() {
    return `${this.model_config.host}${this.model_config.models_endpoint}`;
  }
  get model_show_endpoint() {
    return `${this.model_config.host}/api/show`;
  }
  async load() {
    await this.get_models();
    await super.load();
  }
  /**
   * Estimate token count for input text.
   * Ollama does not expose a tokenizer so we use a character based heuristic.
   * @param {string} input - Text to tokenize
   * @returns {Promise<Object>} Token count result
   */
  async count_tokens(input) {
    return { tokens: this.estimate_tokens(input) };
  }
  /**
   * Prepare input text and ensure it fits within `max_tokens`.
   * @param {string} embed_input - Raw input text
   * @returns {Promise<string|null>} Processed input text
   */
  async prepare_embed_input(embed_input) {
    if (typeof embed_input !== "string") throw new TypeError("embed_input must be a string");
    if (embed_input.length === 0) return null;
    const { tokens } = await this.count_tokens(embed_input);
    if (tokens <= this.max_tokens) return embed_input;
    return await this.trim_input_to_max_tokens(embed_input, tokens);
  }
  /**
   * Trim input text to satisfy `max_tokens`.
   * @private
   * @param {string} embed_input - Input text
   * @param {number} tokens_ct - Existing token count
   * @returns {Promise<string|null>} Trimmed text
   */
  async trim_input_to_max_tokens(embed_input, tokens_ct) {
    const reduce_ratio = (tokens_ct - this.max_tokens) / tokens_ct;
    const new_length = Math.floor(embed_input.length * (1 - reduce_ratio));
    let trimmed_input = embed_input.slice(0, new_length);
    const last_space_index = trimmed_input.lastIndexOf(" ");
    if (last_space_index > 0) trimmed_input = trimmed_input.slice(0, last_space_index);
    const prepared = await this.prepare_embed_input(trimmed_input);
    if (prepared === null) return null;
    return prepared;
  }
  /** @returns {number} Maximum tokens for an input */
  get max_tokens() {
    return this.model_config.max_tokens || this.constructor.defaults.max_tokens;
  }
  /**
   * Get the request adapter class.
   * @returns {SmartEmbedModelOllamaRequestAdapter} The request adapter class
   */
  get req_adapter() {
    return SmartEmbedModelOllamaRequestAdapter;
  }
  /**
   * Get the response adapter class.
   * @returns {SmartEmbedModelOllamaResponseAdapter} The response adapter class
   */
  get res_adapter() {
    return SmartEmbedModelOllamaResponseAdapter;
  }
  /**
   * Get available models from local Ollama instance.
   * @param {boolean} [refresh=false] - Whether to refresh cached models
   * @returns {Promise<Object>} Map of model objects
   */
  async get_models(refresh = false) {
    if (!this.model_data || refresh) {
      const list_resp = await this.http_adapter.request({
        url: this.models_endpoint,
        method: "GET"
      });
      if (list_resp.ok === false) {
        throw new Error(`Failed to fetch models list: ${list_resp.statusText}`);
      }
      const list_data = await list_resp.json();
      const models_raw = [];
      for (const m of filter_embedding_models(list_data.models || [])) {
        const detail_resp = await this.http_adapter.request({
          url: this.model_show_endpoint,
          method: "POST",
          body: JSON.stringify({ model: m.name })
        });
        models_raw.push({ ...await detail_resp.json(), name: m.name });
      }
      const model_data = this.parse_model_data(models_raw);
      this.model_data = model_data;
      this.model.re_render_settings();
      return model_data;
    }
    return this.model_data;
  }
  /**
   * Get available models as dropdown options synchronously.
   * @returns {Array<Object>} Array of model options.
   */
  get_models_as_options() {
    const models = this.model_data;
    if (!Object.keys(models || {}).length) {
      this.get_models(true);
      return [{ value: "", name: "No models currently available" }];
    }
    return Object.values(models).map((model) => ({ value: model.id, name: model.name || model.id })).sort((a, b) => a.name.localeCompare(b.name));
  }
  /**
   * Parse model data from Ollama API response.
   * @param {Object} model_data - Raw model data from Ollama
   * @returns {Object} Map of model objects with capabilities and limits
   */
  parse_model_data(model_data) {
    if (!Array.isArray(model_data)) {
      this.model_data = {};
      console.error("Invalid model data format from Ollama:", model_data);
      return {};
    }
    if (model_data.length === 0) {
      this.model_data = { "no_models_available": {
        id: "no_models_available",
        name: "No models currently available"
      } };
      return this.model_data;
    }
    this.model_data = model_data.reduce((acc, model) => {
      const info = model.model_info || {};
      const ctx = Object.entries(info).find(([k]) => k.includes("context_length"))?.[1];
      const dims = Object.entries(info).find(([k]) => k.includes("embedding_length"))?.[1];
      acc[model.name] = {
        model_name: model.name,
        id: model.name,
        multimodal: false,
        max_tokens: ctx || this.max_tokens,
        dims,
        description: model.description || `Model: ${model.name}`
      };
      return acc;
    }, {});
    this._models = this.model_data;
    return this.model_data;
  }
  /**
   * Get the models.
   * @returns {Object} Map of model objects
   */
  get models() {
    if (typeof this._models === "object" && Object.keys(this._models || {}).length > 0) return this._models;
    else {
      return {};
    }
  }
  /**
   * Override settings config to remove API key setting since not needed for local instance.
   * @returns {Object} Settings configuration object
   */
  get settings_config() {
    const config = super.settings_config;
    delete config["[ADAPTER].api_key"];
    config["[ADAPTER].host"] = {
      name: "Ollama host",
      type: "text",
      description: "Enter the host for your Ollama instance",
      default: this.constructor.defaults.host
    };
    return config;
  }
};
var SmartEmbedModelOllamaRequestAdapter = class extends SmartEmbedModelRequestAdapter {
  /**
   * Convert request to Ollama's embed API format.
   * @returns {Object} Request parameters in Ollama's format
   */
  to_platform() {
    const ollama_body = {
      model: this.adapter.model_config.model_key,
      input: this.embed_inputs
    };
    return {
      url: this.adapter.endpoint,
      method: "POST",
      headers: this.get_headers(),
      body: JSON.stringify(ollama_body)
    };
  }
  /**
   * Prepare request headers for Ollama API.
   * @returns {Object} Headers object
   */
  get_headers() {
    return {
      "Content-Type": "application/json"
    };
  }
};
var SmartEmbedModelOllamaResponseAdapter = class extends SmartEmbedModelResponseAdapter {
  /**
   * Convert Ollama's response to a standardized OpenAI-like format.
   * @returns {Array<Object>} Array of embedding results
   */
  to_openai() {
    const resp = this.response;
    if (!resp || !resp.embeddings) {
      console.error("Invalid response format from Ollama:", resp);
      return [];
    }
    const tokens = Math.ceil(resp.prompt_eval_count / this.adapter.batch_size);
    const embeddings = resp.embeddings.map((vec) => ({
      vec,
      tokens
    }));
    return embeddings;
  }
  /**
   * Parse the response object.
   * @returns {Array<Object>} Parsed embedding results
   */
  parse_response() {
    return this.to_openai();
  }
};
var is_embedding_model = (mod) => {
  return ["embed", "embedding", "bge"].some((keyword) => mod.name.toLowerCase().includes(keyword));
};
var filter_embedding_models = (models) => {
  if (!Array.isArray(models)) {
    throw new TypeError("models must be an array");
  }
  return models.filter(is_embedding_model);
};

// node_modules/obsidian-smart-env/node_modules/smart-embed-model/cl100k_base.json
var cl100k_base_default = { pat_str: "('s|'S|'t|'T|'re|'rE|'Re|'RE|'ve|'vE|'Ve|'VE|'m|'M|'ll|'lL|'Ll|'LL|'d|'D)|[^\\r\\n\\p{L}\\p{N}]?\\p{L}+|\\p{N}{1,3}| ?[^\\s\\p{L}\\p{N}]+[\\r\\n]*|\\s*[\\r\\n]+|\\s+(?!\\S)|\\s+", special_tokens: { "<|endoftext|>": 100257, "<|fim_prefix|>": 100258, "<|fim_middle|>": 100259, "<|fim_suffix|>": 100260, "<|endofprompt|>": 100276 }, bpe_ranks: "! 0 IQ== Ig== Iw== JA== JQ== Jg== Jw== KA== KQ== Kg== Kw== LA== LQ== Lg== Lw== MA== MQ== Mg== Mw== NA== NQ== Ng== Nw== OA== OQ== Og== Ow== PA== PQ== Pg== Pw== QA== QQ== Qg== Qw== RA== RQ== Rg== Rw== SA== SQ== Sg== Sw== TA== TQ== Tg== Tw== UA== UQ== Ug== Uw== VA== VQ== Vg== Vw== WA== WQ== Wg== Ww== XA== XQ== Xg== Xw== YA== YQ== Yg== Yw== ZA== ZQ== Zg== Zw== aA== aQ== ag== aw== bA== bQ== bg== bw== cA== cQ== cg== cw== dA== dQ== dg== dw== eA== eQ== eg== ew== fA== fQ== fg== oQ== og== ow== pA== pQ== pg== pw== qA== qQ== qg== qw== rA== rg== rw== sA== sQ== sg== sw== tA== tQ== tg== tw== uA== uQ== ug== uw== vA== vQ== vg== vw== wA== wQ== wg== ww== xA== xQ== xg== xw== yA== yQ== yg== yw== zA== zQ== zg== zw== 0A== 0Q== 0g== 0w== 1A== 1Q== 1g== 1w== 2A== 2Q== 2g== 2w== 3A== 3Q== 3g== 3w== 4A== 4Q== 4g== 4w== 5A== 5Q== 5g== 5w== 6A== 6Q== 6g== 6w== 7A== 7Q== 7g== 7w== 8A== 8Q== 8g== 8w== 9A== 9Q== 9g== 9w== +A== +Q== +g== +w== /A== /Q== /g== /w== AA== AQ== Ag== Aw== BA== BQ== Bg== Bw== CA== CQ== Cg== Cw== DA== DQ== Dg== Dw== EA== EQ== Eg== Ew== FA== FQ== Fg== Fw== GA== GQ== Gg== Gw== HA== HQ== Hg== Hw== IA== fw== gA== gQ== gg== gw== hA== hQ== hg== hw== iA== iQ== ig== iw== jA== jQ== jg== jw== kA== kQ== kg== kw== lA== lQ== lg== lw== mA== mQ== mg== mw== nA== nQ== ng== nw== oA== rQ== ICA= ICAgIA== aW4= IHQ= ICAgICAgICA= ZXI= ICAg b24= IGE= cmU= YXQ= c3Q= ZW4= b3I= IHRo Cgo= IGM= bGU= IHM= aXQ= YW4= YXI= YWw= IHRoZQ== Owo= IHA= IGY= b3U= ID0= aXM= ICAgICAgIA== aW5n ZXM= IHc= aW9u ZWQ= aWM= IGI= IGQ= ZXQ= IG0= IG8= CQk= cm8= YXM= ZWw= Y3Q= bmQ= IGlu IGg= ZW50 aWQ= IG4= YW0= ICAgICAgICAgICA= IHRv IHJl LS0= IHs= IG9m b20= KTsK aW0= DQo= ICg= aWw= Ly8= IGFuZA== dXI= c2U= IGw= ZXg= IFM= YWQ= ICI= Y2g= dXQ= aWY= Kio= IH0= ZW0= b2w= ICAgICAgICAgICAgICAgIA== dGg= KQo= IHsK IGc= aWc= aXY= LAo= Y2U= b2Q= IHY= YXRl IFQ= YWc= YXk= ICo= b3Q= dXM= IEM= IHN0 IEk= dW4= dWw= dWU= IEE= b3c= ICc= ZXc= IDw= YXRpb24= KCk= IGZvcg== YWI= b3J0 dW0= YW1l IGlz cGU= dHI= Y2s= 4oA= IHk= aXN0 LS0tLQ== LgoK aGU= IGU= bG8= IE0= IGJl ZXJz IG9u IGNvbg== YXA= dWI= IFA= ICAgICAgICAgICAgICAg YXNz aW50 Pgo= bHk= dXJu ICQ= OwoK YXY= cG9ydA== aXI= LT4= bnQ= Y3Rpb24= ZW5k IGRl MDA= aXRo b3V0 dHVybg== b3Vy ICAgICA= bGlj cmVz cHQ= PT0= IHRoaXM= IHdo IGlm IEQ= dmVy YWdl IEI= aHQ= ZXh0 PSI= IHRoYXQ= KioqKg== IFI= IGl0 ZXNz IEY= IHI= b3M= YW5k IGFz ZWN0 a2U= cm9t IC8v Y29u IEw= KCI= cXU= bGFzcw== IHdpdGg= aXo= ZGU= IE4= IGFs b3A= dXA= Z2V0 IH0K aWxl IGFu YXRh b3Jl cmk= IHBybw== Ow0K CQkJCQ== dGVy YWlu IFc= IEU= IGNvbQ== IHJldHVybg== YXJ0 IEg= YWNr aW1wb3J0 dWJsaWM= IG9y ZXN0 bWVudA== IEc= YWJsZQ== IC0= aW5l aWxs aW5k ZXJl Ojo= aXR5 ICs= IHRy ZWxm aWdodA== KCc= b3Jt dWx0 c3Ry Li4= Iiw= IHlvdQ== eXBl cGw= IG5ldw== IGo= ICAgICAgICAgICAgICAgICAgIA== IGZyb20= IGV4 IE8= MjA= bGQ= IFs= b2M= Ogo= IHNl IGxl LS0tLS0tLS0= LnM= ewo= Jyw= YW50 IGF0 YXNl LmM= IGNo PC8= YXZl YW5n IGFyZQ== IGludA== 4oCZ X3Q= ZXJ0 aWFs YWN0 fQo= aXZl b2Rl b3N0 IGNsYXNz IG5vdA== b2c= b3Jk YWx1ZQ== YWxs ZmY= KCk7Cg== b250 aW1l YXJl IFU= IHBy IDo= aWVz aXpl dXJl IGJ5 aXJl IH0KCg== LnA= IHNo aWNl YXN0 cHRpb24= dHJpbmc= b2s= X18= Y2w= IyM= IGhl YXJk KS4= IEA= aWV3 CQkJ IHdhcw== aXA= dGhpcw== IHU= IFRoZQ== aWRl YWNl aWI= YWM= cm91 IHdl amVjdA== IHB1YmxpYw== YWs= dmU= YXRo b2lk ID0+ dXN0 cXVl IHJlcw== KSk= J3M= IGs= YW5z eXN0 dW5jdGlvbg== KioqKioqKio= IGk= IHVz cHA= MTA= b25l YWls PT09PQ== bmFtZQ== IHN0cg== IC8= ICY= YWNo ZGl2 eXN0ZW0= ZWxs IGhhdmU= ZXJy b3VsZA== dWxs cG9u IEo= X3A= ID09 aWdu U3Q= Lgo= IHBs KTsKCg== Zm9ybQ== cHV0 b3VudA== fQoK ZGQ= aXRl IGdldA== cnI= b21l IOKA YXJhbQ== Y2M= ICov RVI= SW4= bGVz X3M= b25n aWU= IGNhbg== IFY= ZXJ2 cHI= IHVu cm93 YmVy IGRv bGw= IGVs IHNlbGY= YXRlZA== YXJ5 IC4= J10= dWQ= IGVu IFRo ICAgICAgICAgICAgICAgICAgICAgICA= dGU= X2M= dWN0 IGFi b3Jr LmdldA== ICM= YXc= cmVzcw== b2I= TmFtZQ== MjAx YXBw Wyc= IGFsbA== b3J5 aXRpb24= YW5jZQ== ZWFy IGNvbnQ= dmVudA== aWE= IHdpbGw= SU4= ICAgICAgICAg cmV0dXJu IDwv ZGF0YQ== KQoK UmU= cGxl aWxk dGhlcg== IHlvdXI= Igo= KCQ= IG91dA== KSw= IGhhcw== U3RyaW5n c28= IHVw YXg= IGRlZg== IGJv Z2U= YWxzZQ== T04= cGVy MTI= aWNo IGJ1dA== IAo= IF8= X20= YWRk cXVlc3Q= b2RlbA== c2VsZg== ZXJ5 ZnQ= ZW5z Ly8vLw== YWtl LkM= IGdv IGZ1bmN0aW9u IEs= aXZhdGU= IGlt IGNvbnN0 LnQ= ICovCg== KTsNCg== IHZvaWQ= IHNldA== IFN5c3RlbQ== Y3Jp KCkK bGk= CWlm Lm0= YWxseQ== c2V0 ZXA= 4oCZcw== Ym8= ZGVm JywK IG1l ICE= YXRjaA== Ij4= IiwK ZWM= IElu cGg= IHw= X2Y= IHZhcg== ZW5jZQ== SWQ= cmVl aW5r bGVjdA== dWc= ZXRo IGVsc2U= LS0tLS0tLS0tLS0tLS0tLQ== MTk= Y29udA== IHNv YXRpYw== IGxv cHJv dG9u c3M= b3du YWJlbA== b2ludA== b3Vz ZWxk U1Q= VGhl ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= UkU= Ijo= b2xvcg== dHA= ZWc= a2V5 dWRl IFN0 b3VuZA== IGFy Iik7Cg== ZW5lcg== c2Vy MTE= YmplY3Q= ZXNzYWdl ZmVy IG1vcmU= YXRpb25z ZW50cw== IGhpcw== IHRoZXk= LlM= IFk= dXNl bmU= aXNo b2xk X2Q= aW8= aWVsZA== IHBlcg== Q29udA== aW5ncw== IyMjIw== IGRhdGE= IHNh ZWY= Zm8= IG9uZQ== ZW5n IGRpcw== QVQ= IG5hbWU= IHRydWU= dmFs bGVk LmY= IG5l IGVuZA== MzI= LlQ= MTY= Y3Jl YXJr bG9n RXg= ZXJyb3I= X2lk dXJyZQ== YW5nZQ== IG51bGw= cnJheQ== IG15 cGFu aWN0 YXRvcg== Vmlldw== TGlzdA== CXJldHVybg== 4oCd IHByZQ== IHg= Y2x1ZGU= YXJn MTU= b3Y= Lmg= ID4= IHRoZWly Jyk= aXJzdA== aWNr Z2g= TEU= T1I= IHByaXZhdGU= dGVt DQoNCg== dXNlcg== ICk= Y29t LkE= IjsK IGlk cmVhZA== IHdobw== X2I= Ij4K IHRpbWU= IG1hbg== cnk= PT09PT09PT0= cm91cA== cm9w cHVibGlj dmVs dW1iZXI= Ymxl IHdoaWNo KioqKioqKioqKioqKioqKg== IGFueQ== IGZhbHNl d2U= IHZhbHVl IGxp Iik= bmRlcg== Z3I= IG5v cGFyYW0= MjU= Zmln LmNvbQ== IGFwcA== X2w= aW9ucw== LkQ= IENo IGFib3V0 IGFkZA== IHN1 IHN0cmluZw== SUQ= IG92ZXI= c3RyaW5n Lmw= b3VyY2U= MDAw X0M= XQo= IHF1 IFN0cmluZw== Y2E= U0U= IHJv c2g= dWFs VHlwZQ== c29u bmV3 ZXJu IGFn QVI= XTsK XS4= ID8= aWNhbA== IGRlcw== dXRo aXg= YXlz IHR5cGU= J3Q= YXVsdA== IGludGVy dmFy LmI= IHBhcnQ= LmQ= dXJyZW50 SVQ= RU4= MzA= ZW5j KGY= cmE= dmFsdWU= Y2hv MTg= dXR0b24= b3Nl MTQ= ICE9 YXRlcg== w6k= cmVhdGU= b2xs cG9z eWxl bmc= QUw= dXNpbmc= YW1lcw== IHsNCg== YXRlcw== ZWx5 IHdvcms= IGVt aW5hbA== IHNw IHdoZW4= LnNldA== ICAgICAg KToK dG8= cXVpcmU= aW5kb3c= bGVtZW50 cGVjdA== YXNo W2k= IHVzZQ== LkY= cGVj IGFk b3Zl Y2VwdGlvbg== ZW5ndGg= aW5jbHVkZQ== YWRlcg== ICAgICAgICAgICAgICAgICAgICAgICAgICAg YXR1cw== VGg= aXRsZQ== cml0 dm9pZA== KCku KAo= IG9mZg== IG90aGVy ICYm JzsK bXM= IGJlZW4= IHRl bWw= Y28= bmM= MTM= ZXJ2aWNl ICU= KioK YW5u YWRl CgoKCg== bG9jaw== Y29uc3Q= MTAw cG9uc2U= IHN1cA== Kys= ZGF0ZQ== IGFjYw== IGhhZA== IGJ1 MjAw IFJl IHdlcmU= IGZpbGU= IHdvdWxk IOKAnA== dmVu aXNz IG91cg== Y2xhc3M= cmF3 IHllYXI= RGF0YQ== IHZhbA== IHNvbWU= ZnRlcg== eXM= IC8vLw== cm91bmQ= dmlldw== IHBl IHRoZXJl IHNhaWQ= ZHU= b2Y= bGluZQ== Lyo= ZHVjdA== IGhlcg== ICAgICAgICAgICAgIA== UmVz IGNv IGNvbW0= aXNl bWlu ICAgIAo= I2luY2x1ZGU= ZXRob2Q= LlA= dXRl IGFzcw== SW50 YXNr bG9j IGxpa2U= b2R5 IGxldA== bG9hZA== IGFt cm9s IGdy eXA= IGFsc28= IEl0 dXJs aWZpYw== b3Jz X1A= X24= aWdo IHRoYW4= Q29t QU4= VUw= YXRpbmc= MTc= IFRoaXM= cmVm X1M= IHN0YXRpYw== cm9sbA== IGp1c3Q= IHJlc3VsdA== aWFu aWR0aA== IHRoZW0= KSk7Cg== ZGVy cmVhaw== Q29u Oi8v dWxl Li4u YXJjaA== ZW1lbnQ= IDw8 NTA= dXNo ZW5zZQ== YXJy IGludG8= Y2Vzcw== YW1w aWVk dW1lbnQ= IFw= XSw= d28= YWxz IHdoYXQ= YW5j VmFsdWU= PSc= b2x1bQ== IHBvcw== YWdlcw== YXllcg== IHNj dWVz IikK X1Q= IGxpc3Q= KHM= IGNhc2U= Q2g= CQkJCQk= Ly8vLy8vLy8= cG9uZW50 IHo= IGtu bGV0 REU= cmVk IGZl IH0sCg== ICw= KHQ= IGZpcnN0 Jyk7Cg== d29yZA== IGltcG9ydA== IGFjdA== IGNoYXI= Q1Q= IFRy b3BsZQ== PXs= CWY= MjQ= aWVudA== Y2VudA== Lmo= bGVjdGlvbg== KSkK IG9ubHk= IHByaW50 bWVy Llc= b2Nr IC0t VGV4dA== IG9w YW5r IGl0cw== IGJhY2s= WyI= IG5lZWQ= IGNs IHN1Yg== IGxh KCg= LiI= T2JqZWN0 IHN0YXJ0 ZmlsZQ== KHNlbGY= bmVy ZXk= IHVzZXI= IGVudA== IENvbQ== aXRz IENvbg== b3VibGU= b3dlcg== aXRlbQ== dmVyeQ== IFdl NjQ= bGljaw== IFE= cGhw dHRw Jzo= aWNz IHVuZGVy ICoK Lkw= KTs= aWNlcw== IHJlZw== KQ0K CXB1YmxpYw== U1M= IHRoZW4= cmVhdA== aW91cw== Lkc= ZWs= aXJlY3Q= aGVjaw== Y3JpcHQ= bmluZw== IFVu IG1heQ== IFdo Qm8= SXRlbQ== c3RydWN0 LnN0 cmVhbQ== aWJsZQ== bG9hdA== IG9yZw== dW5k c3Vt X2lu Li4v X00= IGhvdw== cml0ZQ== Jwo= VG8= NDA= d3c= IHBlb3BsZQ== aW5kZXg= Lm4= aHR0cA== KG0= ZWN0b3I= IGluZA== IGphdg== XSwK IEhl X3N0 ZnVs b2xl KXsK IHNob3VsZA== b3B5 ZWxw aWVy X25hbWU= ZXJzb24= SU9O b3Rl IHRlc3Q= IGJldA== cnJvcg== dWxhcg== 44A= INA= YnM= dGluZw== IG1ha2U= VHI= IGFmdGVy YXJnZXQ= Uk8= b2x1bW4= cmM= X3Jl ZGVmaW5l MjI= IHJpZ2h0 cmlnaHQ= ZGF5 IGxvbmc= W10= KHA= dGQ= Y29uZA== IFBybw== IHJlbQ== cHRpb25z dmlk Lmc= IGV4dA== IF9f JykK cGFjZQ== bXA= IG1pbg== c3RhbmNl YWly YWN0aW9u d2g= dHlwZQ== dXRpbA== YWl0 PD8= SUM= dGV4dA== IHBo IGZs Lk0= Y2Nlc3M= YnI= Zm9yZQ== ZXJzaW9u KSwK LnJl YXRlZw== IGxvYw== aW5z LXM= dHJpYg== IEludA== IGFycmF5 LCI= UHJv KGM= ZXNzaW9u PgoK IHNoZQ== Il0= YXBo IGV4cA== ZXJ0eQ== IFNl IHBhcg== dW5j RVQ= IHJlYWQ= cHJpbnQ= IHJlbA== IGZvcm0= IGRy RXhjZXB0aW9u aW5wdXQ= IHRyYW5z IyMjIyMjIyM= b3JkZXI= Qnk= IGF3 aXRpZXM= dWZm cGxheQ== LmFkZA== IOKAkw== IHdhbnQ= IGNvbXA= bWVudHM= IHx8 YXo= YmU= IG51bWJlcg== IHJlcXVpcmU= IEV4 NjA= IGNvbA== IGtleQ== ZW1iZXI= IHR3bw== IHNpemU= IHdoZXJl VVQ= cmVzdWx0 ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== b3VnaA== b3JsZA== b29k dWNo YXRpdmU= Z2Vy YXJlbnQ= IC8q IGFyZw== IHdoaWxl MjM= KHRoaXM= IHJlYw== IGRpZg== U3RhdGU= IHNwZWM= cmlkZQ== X0Y= IGxvb2s= QU0= aWxpdHk= ZXRlcg== 4oCZdA== CgoK YXlvdXQ= LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= YWdlcg== IGNvdWxk IGJy ZW5kcw== dXJlcw== IGtub3c= ZXRz IElm IFNo Lnc= YmFjaw== IHNlcg== ICs9 IGZy KCkpOwo= IGhhbmQ= SW5k VUxM SW0= KCk7Cgo= IG1vc3Q= IHRyeQ== IG5vdw== cm91Z2g= Pg0K YWNrYWdl IGhpbQ== Ll8= aWZ5 IGJyZWFr ICk7Cg== cmVu I2RlZmluZQ== aXR0 IGFw CWM= KG4= IFlvdQ== OgoK LW0= IGV2ZXJ5 dXN0b20= bGllbnQ= b2N1bWVudA== Y3JpcHRpb24= RXJyb3I= LWI= 0L4= XVs= OTk= dHJhbnM= IHBvaW50 IHN0ZA== IGZpbA== VGltZQ== ODA= IG1vZA== IC0+ IGVycm9y YWg= IHRleHQ= cm9sbGVy bG9zZQ== cWw= IHBvbA== Pjwv IHNob3c= VXNlcg== YXNlZA== IHsKCg== IGZpbmQ= 0LA= RUQ= c3Bhbg== ZW51 IGN1cnJlbnQ= IHVzZWQ= Y2VwdA== Y2x1ZA== IHBsYXk= IGxvZw== dXRpb24= Zmw= IHNlZQ== aW5kb3dz IGhlbHA= IHRoZXNl IHBhc3M= IGRvd24= IGV2ZW4= YXNvbg== dWlsZA== ZnJvbQ== KGQ= IGJs bGFiZWw= ZWxzZQ== 0LU= ICgh aXplZA== KCks IG9i IGl0ZW0= dW1w VVI= b3Ju IGRvbg== U2U= bWFu Mjc= YW1wbGU= dG4= PT09PT09PT09PT09PT09PQ== SGU= Z3JhbQ== IGRpZA== d24= X2g= aXZlcg== IHNt IHRocm91Z2g= IEFu Y2hl IGludg== b3VzZQ== IGVz IE5ldw== ZXhwb3J0 bWFyeQ== dXRv bGVy IGxhc3Q= IGV2ZW50 dHJ5 77w= aWx5 aWduZWQ= aW5lcw== b2xsb3c= aWNlbnNl c29sZQ== bGVhcg== KGludA== IGFnYWlu IGhpZ2g= aHRtbA== SW5kZXg= dXRob3I= IC8qKgo= IGxpbmU= RXZlbnQ= X0Q= IGRvZXM= aXRpYWw= IGNy YXJz Mjg= IHRlbQ== Y2F1c2U= ZmFjZQ== IGA= X0E= QnV0dG9u YXR1cmU= ZWN0ZWQ= RVM= aXN0ZXI= CQo= IGJlZm9yZQ== YWxl b3RoZXI= IGJlY2F1c2U= cm9pZA== IGVk aWs= cmVn IERl IGRpc3Q= fSwK IHN0YXRl IGNvbnM= cmludA== YXR0 IGhlcmU= aW5lZA== IGZpbmFs ICIi S2V5 TE8= IGRlbA== cHR5 dGhpbmc= MjY= IEFuZA== IHJ1bg== IFg= eW0= LmFwcA== IHZlcnk= Y2Vz X04= YXJlZA== d2FyZA== bGlzdA== aXRlZA== b2xvZw== aXRjaA== Qm94 aWZl MzM= IGFj IG1vZGVs IG1vbg== IHdheQ== bGV0ZQ== IGNhbGw= IGF0dA== IGNhbA== dmVydA== IGRlYw== bGVhc2U= b3Vu IH0pOwo= ZnI= Zm9ybWF0aW9u ZXRhaWw= IG51bQ== YWo= cXVlcnk= IHdlbGw= IG9iamVjdA== IEFz IHllYXJz Q29sb3I= SVM= IGRlZmF1bHQ= V2g= IGlucw== YWludA== IGphdmE= IHNpbQ== IEFy bW9u dGls KCk7DQo= KTo= U2V0 Mjk= YXR0ZXI= IHZpZXc= IHByZXM= YXJyYXk= V2U= QXQ= IGJlbA== IG1hbnk= MjE= TWFu ZW5kZXI= IGJlaW5n IGdvb2Q= CQkJCQkJ YXRpb25hbA== d2FyZQ== LmxvZw== ew0K IHVzaW5n X0I= IDo9 X3c= aXN0cw== bGlzaA== IHN0dWQ= IEFs IGd1 Y29uZmln dXJpbmc= dGltZQ== b2tlbg== YW1lc3BhY2U= IHJlcXVlc3Q= IGNoaWxk IMM= bG9i IHBhcmFt IH0NCg== MDE= IGVjaG8= ZnVuY3Rpb24= KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= cHM= RWxlbWVudA== YWxr bGljYXRpb24= Ynk= U2l6ZQ== cmF3aW5n IHBlcnNvbg== ICAgICAgICAgICAgICAgICA= XG4= b2JqZWN0 aW5jZQ== RW4= RmlsZQ== dWY= ZmZlY3Q= QUM= IHN0eWxl c3VtbWFyeQ== IHF1ZQ== X3I= ICgk TW9kZWw= aWRlbnQ= IG1ldGhvZA== SUw= b3R0 bGVzcw== SU5H ICgp IGV4cGVjdA== eW5j cGFja2FnZQ== MzU= dXJz IHByb3Q= Li8= cHJl ICkK bWE= IHN1cg== IGZvdW5k SW5mbw== cGFy aW1lcw== LmU= YWlucw== IHBvc3Q= LWQ= NDU= b2xlYW4= IHNs UEU= IHN1Y2g= c2VsZWN0 YWluZXI= IHRoaW5r IGRpZmZlcg== LnI= LyoqCg== RkY= b29s cGxhdGU= cXVhbA== IEZvcg== IG11Y2g= dWM= KG5ldw== b2R1bGU= IHNvbQ== IGh0dHA= IExpc3Q= IGNvdW50 IGluc3Q= Y2hhcg== bWl0 Lmlk YWtpbmc= IGdlbmVy cHg= dmljZQ== Mzc= X2RhdGE= IE5VTEw= fQ0K aWRk 44CC IG1lZA== b3Jn aWRlcg== YWNoZQ== d29yaw== IGNoZWNr d2Vlbg== ICgo dGhl YW50cw== Pjw= LkI= LWM= IG9wZW4= IGVzdA== ICAgICAgICAK IG5leHQ= SU0= 0YI= T1Q= w7M= IGZvbGxvdw== Y29udGVudA== ICAgICAgICAgICAg IGluY2x1ZA== SEU= IFJlcw== IGhyZWY= 0Lg= IGNhcg== eXBlcw== aW1hZ2U= VW4= IGJvb2w= QUQ= IGdhbWU= LkZvcm0= cm93cw== Ki8= dmVsb3A= LkRyYXdpbmc= IHBhdGg= aXNpb24= IGVhY2g= IFBs X3R5cGU= UGF0aA== bmVjdGlvbg== IGF2 Jyku IHN1cHBvcnQ= RU5U cmVt Iiku IG93bg== IGNvcg== Y291bnQ= bWlzcw== dWFsbHk= IG1lbQ== c3Rk aWVuY2U= c2VhcmNo IgoK Rm9ybQ== IHNleA== ZW5hbWU= IHNpZ24= IGV0 ICAgICAgICAgIA== Jywn IEFwcA== IHRob3Nl b2Zm IGVycg== IHN5c3RlbQ== IGJlc3Q= Y29kZQ== IHNhbWU= IGRp dXNz IGNyZWF0ZQ== YXRoZXI= QXJyYXk= Lmlu ZmU= U2VydmljZQ== VU4= YXRz IFo= YWx0aA== IG1hZGU= dHJ1ZQ== QUI= IG1hcms= cmlk aWZpZWQ= LA0K eW4= cHJlc3M= IGdyb3Vw IGZpbg== IExpY2Vuc2U= RmllbGQ= ZWdlcg== IHdvcmxk aW5lc3M= dHk= IHByb2Nlc3M= KGI= IGNyZQ== YXJu aXZlcw== IG1haW4= aWRlbw== MzY= X2c= QUc= dmFsaWQ= aW1n UEk= IGNvbG9y IHJlcG9ydA== IHRha2U= cmli T00= IGRheQ== UmVxdWVzdA== IHNr YmVycw== CXM= LkFkZA== b290 SW1hZ2U= IGNvbXBsZQ== b2xsZWN0aW9u IHRvcA== IGZyZWU= QVM= RGU= IE9u SUc= OTA= ZXRh RGF0ZQ== IGFjdGlvbg== MzQ= T3Zlcg== aXRvcg== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= bm90 IGluZGV4 aGVy aWNvbg== T24= Ow0KDQo= aXZpdHk= bWFuZA== LldpbmRvd3M= T0w= IHJlYWw= IG1heA== bGFuZA== Li4uLg== cmFwaA== IGJ1aWxk bGVn YXNzd29yZA== PwoK 4oCm b29r dWNr IG1lc3NhZ2U= dGVzdA== aXZlcnM= Mzg= IGlucHV0 IGFydA== IGJldHdlZW4= R2V0 ZW50ZXI= Z3JvdW5k ZW5l w6E= Lmxlbmd0aA== Tm9kZQ== KGk= Q2xhc3M= Zm9y IOKAlA== dGVu b2lu IGtl dWk= IElO IHRhYmxl c3Vi IExl IGhlYWQ= IG11c3Q= Ly8vLy8vLy8vLy8vLy8vLw== LnV0aWw= Q29udGV4dA== IG9yZGVy IG1vdg== b3Zlcg== IGNvbnRpbg== IHNheQ== c3RhdGlj LlRleHQ= IGNsYXNzTmFtZQ== cGFueQ== IHRlcg== aGVhZA== cmc= IHByb2R1Y3Q= VGhpcw== LuKAnQ== IEJ1dA== NzA= bG95 IGRvdWJsZQ== c2c= IHBsYWNl Lng= bWVzc2FnZQ== IGluZm9ybWF0aW9u cHJpdmF0ZQ== IG9wZXI= Y2Vk ZGI= Ij48Lw== UGFyYW0= aWNsZQ== IHdlZWs= IHByb3A= dGFibGU= aWRnZXQ= cGxhY2U= UHJvcA== IEFsbA== ZWxz Ym94 LgoKCgo= LlI= IFRv aXRlcg== U2g= dXJhdGlvbg== b2xkZXI= X2xpc3Q= Y29tZQ== IHN3 aXphdGlvbg== CWZvcg== Ymw= IHByb2dyYW0= KGU= YXBl Y2hlY2s= LkZvcm1z IHVuZA== YXRlZ29yeQ== NzU= YWdz IHJlc3BvbnNl VVM= cmVxdWVzdA== IHN0cnVjdA== ZXNjcmlwdGlvbg== IGNvZGU= X0g= dWZmZXI= IHdpdGhvdXQ= bG9iYWw= TWFuYWdlcg== aWx0ZXI= UE8= CXRoaXM= b3B0aW9u IHNvbA== ID09PQ== YWtlcw== Q29udHJvbGxlcg== NDQ= TWVzc2FnZQ== IHJlZg== ZXZlcg== IFNv YWluaW5n LmFwcGVuZA== IHN0aWxs IHByb3ZpZA== IGFzc2VydA== bWVk IGNhcA== dXNpbmVzcw== IHJlcA== dGluZ3M= dmVk Lk4= YXBp T0Q= IGZpZWxk aXZlbg== b3Rv 4oCc Y29s KHg= Z2h0 UmVzdWx0 Q29kZQ== Lmlz bGluaw== IGNvdXI= QW4= IHRlYW0= CWludA== aWZ0 NTU= IHNlY29uZA== IGdvaW5n IHJhbmdl X0U= bmVzcw== Mzk= IGZhbQ== IG5pbA== IENvbnQ= YWlsYWJsZQ== dXRlcw== YXRhYg== IGZhY3Q= IHZpcw== KCY= IEFO MzE= QWw= dGl0bGU= IGFuZHJvaWQ= Q0U= XCI= aXJ0 IHdyaXQ= 0L0= CW0= ZnR3YXJl b25k IHJldA== b3NpdGlvbg== IGhvbWU= IGxlZnQ= YXJncw== bWVyaWM= NDg= IGRpcmVjdA== b2Np UGw= QXM= cmV0 YWRv T2Y= Y2hu IEdldA== ZWU= cm9zcw== KCk7 X19fXw== LnBo SXQ= b3V0ZQ== IGV4cGVy Y2hvb2w= d3d3 fSw= IGFsbG93 IMI= KCkp c2l6ZQ== aXNt YWk= dHJhY3Q= YW5l Li4uCgo= Y29udGV4dA== IGJlZw== Q0g= IHBhZ2U= aGlw bm8= Y29yZQ== c3A= IGRpZmZlcmVudA== aWFibGU= IE1l X0lO YnV0dG9u IElz ZXJ2aWNlcw== IGNh IGFyb3VuZA== QXBw cmF0aW9u IHJlY2U= IHJlYWxseQ== IGltYWdl IHRhcmdldA== IGRlcA== b3B5cmlnaHQ= dHJh aW5nbGU= aXRhbA== TGF5b3V0 IGJvdGg= T3ZlcnJpZGU= YXJt PT4= YXRlcmlhbA== aWxlZA== IHB1dA== UXU= 0YA= dW5n bWFw CQkJCQkJCQk= IGxldmVs Q29tcG9uZW50 Ym9vaw== Y3JlZW4= X1JF IGNvbmZpZw== 44E= T3I= LmRhdGE= IGRvY3VtZW50 Iiwi dHJpYnV0ZQ== dXg= TG9n ZmVyZW5jZQ== cG9zdA== X2U= IGxvY2Fs YW5kb20= YXNzZXJ0 VmFs bGVjdGVk aW5h YXRhYmFzZQ== QWRk IGNvbnRlbnQ= LnByaW50 c2lnbmVk cmlj LiIKCg== IGZh IQoK LWY= aXZlZA== IHF1ZXN0 LmV4 IGZsb2F0 IGRldmVsb3A= 0L7Q TWFw YWRpbmc= IHBvc3M= VUU= bmFtZXNwYWNl X08= CWI= LkdldA== Pig= anNvbg== ZXRhaWxz NjY= IHRvbw== IGV4dGVuZHM= IE5vbmU= IGZvcmU= KFN0cmluZw== Zm9ybWF0 IGdyZWF0 aW50ZXI= Y2FsZQ== 0YE= cm9u aXZpbmc= RW50 ZW5jeQ== eHQ= b3k= MDU= IG1vbnRo IGhhcHA= IHN1cGVy YmFy ZGVmYXVsdA== X2Rl b3Jkcw== bG4= KHsK IEluZA== YXNlcw== IHRpdGxl IGNvbnRleHQ= MDg= b2g= LXA= RW0= IG1ldA== VGVzdA== IGxpZmU= X3Y= IFVT VUk= b2NhdGlvbg== bWQ= IFsK IF0= c3c= IGluY3Jl c2NyaXB0 ZW50aWFs d2F5cw== LmRl IHNyYw== IGNhdGNo IEFtZXJpYw== Ly8K ICAgICAgICAgICAgICA= IHBheQ== cGxpdA== 4oCU IGNvdW4= b2Jq LnBocA== IGNoYW5nZQ== ZXRoaW5n J3Jl YXN0ZXI= bG9z bGF0aW9u ICAK TGU= w6Q= KHs= cmVhZHk= IE5v IHBvc2l0aW9u IG9sZA== IGJvb2s= YWJsZWQ= YnVn MjAy SGFuZA== fTsKCg== aXNwbGF5 YXZpbmc= MDQ= IGdvdmVy IHZlcnNpb24= U3lzdGVt bmVjdA== cmVzcG9uc2U= U3R5bGU= VXA= YW5ndQ== IHRocmVl aW5pdA== ZXJv IGxhdw== ZW5kaWY= IGJhc2U= ZW1haWw= KGw= X1Y= IGNvbmY= QVRF IGR1cmluZw== dGVz IGNvbnNvbGU= IFBy IHNwZQ== dmVz NjU= cGF0aA== aWFsb2c= ZGl0aW9u X3Rv YXJkcw== IGFnYWluc3Q= ZXR3b3Jr IFBo X0w= Y3Vy aW1pdA== V2l0aA== IHBvd2Vy aXVt JzsKCg== IHdvbQ== bGVmdA== b3VyY2Vz YXRyaQ== IElt IE1hbg== b3J0aA== JHs= ODg= cXVhbHM= ZXNl X3NpemU= IGlzcw== b3RhbA== LWc= aXF1ZQ== cmFtZQ== IHdpZHRo ZXJn KSg= aXR0bGU= VFI= IFRoZXk= ZW5jZXM= MDI= cmw= b25z IGxhYmVs Lnk= LXQ= dXBkYXRl YW5lbA== c2M= LnRv IHByb2plY3Q= w7w= IGVsZW1lbnQ= IHN1Y2Nlc3M= CQkK LnNo cmFt Y2hlZA== KCkpCg== ICgK IGRhdGU= IHRvdA== X1NU QWxs aWZpY2F0aW9u CXZhcg== IHRyaQ== Y2hlbQ== bXk= IGJpZw== IEFk IEF0 b3Rz bnVt QWN0 IG1hcA== ZXJh Y29wZQ== LiQ= LOKAnQ== IHBvcA== IGZldw== IGxlbg== dWlk ZXRlcnM= dWxlcw== w60= c291cmNl aHR0cHM= IGRlbQ== IGVhcg== IyMjIyMjIyMjIyMjIyMjIw== IG1hdGNo b3JpZXM= NDk= YWNlcw== IENs IG5vZGU= Nzg= aXJj bG9jYWw= dW5pdHk= fTsK IGFub3RoZXI= PDw= b2dsZQ== IHNpdA== ZXdvcms= VEU= Lkk= TlM= b2xvZ3k= b3VnaHQ= LkNvbnQ= Pj4= IGNhcmU= c3RhdGU= CXByaXZhdGU= IGVmZmVjdA== Kysp X2ZpbGU= ZW5kaW5n TGluZQ== Rm9y aW9y IFNj IGZ1bg== LlNpemU= CWVsc2U= XSk= c3RhcnQ= dmlvdXM= IH0s b3Vycw== IGxlZw== IHNlcnZpY2U= IHNpbmNl aXJvbg== TGFiZWw= IG5vbg== IGxvcw== aWN0aW9u IGZ1bGw= YWN0ZXI= Ym9hcmQ= Z3Jlc3M= IHR1cm4= aXRoZXI= MDk= LnNpemU= IGJvZHk= cmVzaA== ZXR1cm4= MTk5 KF8= eWxlcw== b3JtYWw= cGk= IHNvbWV0aGluZw== IS0t dWludA== IHByb2R1 IHN0YW5k IHByb2JsZQ== IGF2YWlsYWJsZQ== bXQ= IEJs IC4uLg== IGJsb2Nr SW5wdXQ= IGtlZXA= Q291bnQ= b3Blbg== IFsn IHRocm93 dWlsZGVy QWN0aW9u IHRoaW5ncw== VHJ1ZQ== IHVybA== IEJv cHJpbnRm IHJlZA== anM= LmNyZWF0ZQ== IE9y U3RhdHVz SW5zdGFuY2U= IGNvbnRyb2w= IGNvbWU= IGN1c3RvbQ== bG9jYXRpb24= MDc= bW9kZWw= IA0K IHNvdXJjZQ== IGVhcw== Lm91dA== XQoK b25leQ== IGF3YWl0 IHBhcnRpYw== QVA= dWJsaXNo b2Rlcw== X3Bybw== cGx5 cml0ZXI= IHByb3Y= IG1pbGw= SFQ= XSkK IGNoYW5n IGFzaw== ICAgICAgICAgICAgICAgICAgICAg IG91dHB1dA== IGVtYWls Njg= LnB1c2g= IH0NCg0K aW5hdGlvbg== NDc= YXRyaXg= VGFibGU= dWNjZXNz XSk7Cg== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IGRpc2M= KFs= IGJ1c2luZXNz aGVpZ2h0 Lmh0bWw= dGE= ZmllbGQ= IHJlcXVpcmVk X1I= IGdvdmVybg== fQ0KDQo= bGV4 NTAw Liw= IFNldA== dXJjaA== Ly8v dHM= YWY= IG1pZ2h0 aXN0b3J5 U3Ry IG5ldmVy UmVzcG9uc2U= YXJzZQ== YWRh IEhvdw== ICop IDs= IGhhcmQ= QWQ= IGludGVybg== dXNlZA== KGRhdGE= bW9k YW5uZWw= IG5w dWdn IC8+Cg== IGNhbGxlZA== Ym9keQ== IGNobw== KHI= X3NldA== aXJk ID49 IH07Cg== IG9wdGlvbnM= IEdlbmVy IGhlaWdodA== UG9pbnQ= WW91 ZXR5 Q2xpY2s= IHNtYWxs IGlkZQ== IGFjY2Vzcw== YW5ndWFnZQ== IHByb3RlY3RlZA== IGpvYg== IFRoZXJl RGVm IGFkZHJlc3M= IHVpbnQ= Tm90 b28= YXBz PGRpdg== YWluZWQ= YXR1cg== IHN1bQ== LXc= IERhdGU= IGxpdHRsZQ== IGZyaQ== WVBF IHBvcnQ= ZWg= cHJpbmc= X3BhdGg= IHN0YXR1cw== MDY= YWlt Ym9vbA== IGFwcGU= IG9z Lm5hbWU= ZW5zaW9u X0c= IHVwZGF0ZQ== Q29uZmln YWZm RVJS IDw9 YXRlbHk= I2lm dWN0aW9u OTU= IFRl IGxpbms= IFVzZXI= LmZpbmQ= Lm9yZw== bWU= IGdpdmVu T3V0 I2VuZGlm IGJldHRlcg== UGFnZQ== IGZlZWw= ZW5u TUw= IGFscmVhZHk= IGluY2x1ZGluZw== b29nbGU= cnU= aWNhbGx5 cHJvcA== bGVhbg== b3V0ZXI= IGFsd2F5cw== b3JkaW5n SWY= b3JhZ2U= IHBhcmVudA== dmlz CQkJCQkJCQ== IGdvdA== c3RhbmQ= IGxlc3M= L3M= IEFzcw== YXB0 aXJlZA== IEFkZA== IGFjY291bnQ= cGxveQ== IGRlcg== cmVzZW50 IGxvdA== IHZhbGlk CWQ= IGJpdA== cG9uZW50cw== IGZvbGxvd2luZw== X2V4 U09O IHN1cmU= b2NpYWw= IHByb20= ZXJ0aWVz aGVhZGVy LnBybw== IGJvb2xlYW4= IHNlYXJjaA== a2Vu IG9yaWc= IGVy RWQ= RU0= YXV0 bGluZw== YWxpdHk= QnlJZA== YmVk CWNhc2U= NDY= ZXRoZXI= cG9zaXQ= IGludmVzdA== IE9S IHNheXM= bWlzc2lvbg== QU1F IHRlbXA= b2Fk IHJlc3Q= aW5mbw== IGludGVyZXN0 QXJn IHBlcmZvcm0= cG9ucw== IFZpZXc= IHZlcg== bGli KGNvbnN0 VXRpbA== TGlzdGVuZXI= YXJnZQ== Nzc= IG11bHQ= IGRpZQ== IHNpdGU= Li4vLi4v RUw= IHZhbHVlcw== IH0pCg== cGVu Tm8= aWNybw== IGJlaA== ICcuLw== YWN5 cmVj KCktPg== CSAgIA== Iikp Q29udGVudA== X1c= cGxlbWVudA== IHdvbg== IHZpZGVv YWRp cG9pbnQ= JSU= MDM= IGds ZXJ2ZWQ= dmlyb24= SUY= dXRlZA== 44M= J20= IGNlcnQ= IHByb2Y= IGNlbGw= YXJp IHBsYXllcg== YWlz IGNvc3Q= IGh1bQ== KFI= IG9mZmlj a3M= LnRleHQ= YXR1cmVz IHRvdGFs ICovCgo= b3Bl IHN0YXQ= VU0= IGxvYWQ= aWdodHM= IGNsZWFy dXJv IHRlY2hu dXBwb3J0 SVI= IHJvdw== IHNlZW0= IHE= IHNob3J0 IE5vdA== aXBw R3JvdXA= c2VjdGlvbg== bWF4 aXJs IG92ZXJyaWRl IGNvbXBhbnk= IGRvbmU= Iik7DQo= IGdyZQ== LlJl IGJlbGll cmlzdA== IGhlYWx0aA== QU5U KCkKCg== IEJl LnZhbHVl IEdy b3R0b20= IGFyZ3M= UFQ= c3RhdHVz ZnVuYw== dW1lbnRz LWg= TnVtYmVy Og0K IExvZw== ZXJ2ZXI= ICksCg== YW1lbnQ= IG9iag== aW5j IGNoaWxkcmVu aWN5 SVo= YW5kcw== YWJseQ== IGRpc3RyaWI= IGN1cg== ZXJpYWw= IGRheXM= cmVhdGVk cmVjdA== LWw= aXJt aWRkZW4= b21i IGluaXRpYWw= Lmpz IOI= UXVlcnk= IG9ubGluZQ== aW1hbA== LmNvbg== YXU= VXJs Y29udHJvbA== aXJlY3Rpb24= IGluc3RhbmNl T1JU IEZy d2hlcmU= IGphdmF4 IG9yZ2Fu YXB0ZXI= IHJlYXNvbg== b3B0aW9ucw== NTk= IE1hcg== KGE= IHdpdGhpbg== LuKAnQoK T0RF X0RF YWRtaW4= ZW5kZWQ= IGRlc2lnbg== IERhdGE= dW5l IEZpbGU= cm9vdA== IGNlbnQ= IGFycg== X2FkZA== bGVu cGFnZQ== LCc= X3N0cg== IGJybw== YWJpbGl0eQ== b3V0aA== NTg= L2M= cG9zZQ== aXJ0dWFs ZWFyY2g= X3VybA== YXJnaW4= SHR0cA== IHNjaG9vbA== YXZh IGNvbnNpZGVy LmxhYmVs IEFycmF5 NDI= d2Vi b3B0 LnByaW50bG4= dWxhdGlvbg== IGZ1bmM= UEw= ICJc IFRleHQ= YWN0b3J5 KGZ1bmN0aW9u bnVsbA== IGVuZw== ZG93bg== IGluY2x1ZGU= IEVu IERy IGRi ISE= c2lkZQ== IGluaXQ= cXVpcmVk IFNoZQ== Q29sdW1u cmVhY3Q= IGFubg== IHN0b3A= IGxhdGVy IFRoYXQ= ZW50aW9u ZGY= VUc= SUxF IGNsaWVudA== cmFmdA== ZmZlcg== UE9TVA== ZWxwZXI= IGxvdmU= cXVvdGU= b3Vk IGpzb24= IGFibGU= IG1lbg== QVg= IENvcHlyaWdodA== w7Y= YXZpZw== cmVx Q2xpZW50 fSk7Cg== LkNvbQ== ZXJj aWx0 cGVjaWFs X2NvbQ== cm9vbQ== Lk5hbWU= IGdpdmU= YW1i aWtl IGNvbmRpdGlvbg== Y2xpZW50 YXRvcnM= OiI= IGNvcHk= dXR1cmU= aXZlcnNpdHk= ZXJuYWw= e3s= IENhbg== b3VuYw== ZG8= IG9jYw== IGFwcHJv dGhlcnM= emU= IGVpdGhlcg== IEZs IGltcG9ydGFudA== IGxlYWQ= YXR0cg== QVJU RXF1YWw= IGRh ZXRjaA== ZW50aXR5 IGZhbWlseQ== YWRkaW5n IG9wdGlvbg== IGV4aXN0 aWNh IE9iamVjdA== Njk= J3Zl dmVycw== aXRpb25hbA== Njc= b3V0cHV0 IFRydWU= IE9G X3RpbWU= IG9mZmVy IH0pOwoK SEVS ZWdpbg== IiI= IHdhdGVy IGNoZQ== IE15 b3JlZA== IHN0ZXA= YW5jZXM= Q0s= QVk= 4Lg= c3RydWN0aW9u KEM= MzAw b3VjaA== U3RyZWFt YWN0aXZl YW1h RW50aXR5 cHJvZHVjdA== KCl7Cg== IGdvdmVybm1lbnQ= IElE YWpvcg== QW5k IGRpc3BsYXk= 0Ls= IHRpbWVz IGZvdXI= IGZhcg== IHByZXNlbnQ= IE5T IFwK dWVzdA== IGJhcw== ZWNobw== Y2hpbGQ= aWZpZXI= SGFuZGxlcg== IGxpYg== UHJvcGVydHk= dHJhbnNsYXRpb24= IHJvb20= IG9uY2U= IFtd Y2VudGVy PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0= IHJlc3VsdHM= IGNvbnRpbnVl IHRhbGs= X2dldA== IGdyb3c= LnN3 ZWI= IFB1YmxpYw== T1A= ZWN1dGU= b2xz ICoq Iik7Cgo= IG1hc3M= dXJlZA== LmNsYXNz b21pYw== IG1lYW4= aXBz IGF1dA== KTsNCg0K IHVudGls IG1hcmtldA== IGFyZWE= dWl0 IGxlbmd0aA== IFdpdGg= c3RydWN0b3I= ZXZlbnQ= Ij48 IFNw SVY= IG11cw== aWZm IGtpbmQ= YXV0aG9y b3VuZHM= bWI= X2tleQ== NDE= d2lkdGg= cG9zaXRvcnk= IGxpZ2h0 dWs= Um93 b2hu YWxm dmlyb25tZW50 YXBwZXI= b2xsZWN0aW9ucw== IHNpZGU= X2luZm8= IGV4YW1wbGU= aW1hcnk= IHdy IGNhbXA= Y3JpYmU= MjU1 Ii8= IG1pc3M= d2F5 IGJhc2Vk IHBsYW4= Vmlz b21haW4= dW5r IGF3YXk= VVA= PFQ= T1M= aW9k IE1vbg== 4oCZcmU= IGxpaw== w6c= aXZlbHk= LnY= aW1lcg== aXplcg== U3Vi IGJ1dHRvbg== IFVw IGV4cGVyaWVuY2U= Q0w= IHJlbmRlcg== X3ZhbHVl IG5lYXI= VVJM YWx0 IGNvdW50cnk= aWJpbGl0eQ== NTc= KCksCg== ZWFk IGF1dGhvcg== IHNwZWNpZmlj YmFzZQ== KG5hbWU= b25lcw== IERv IGFsb25n eWVhcg== IGV4cHJlc3M= Lic= ZW52 IGJlZ2lu IHNvZnR3YXJl IGltcA== IHdpbg== w7Nu IHRoaW5n VHJhbnM= IFRIRQ== IDw/ IHdoeQ== IGRvZXNu aWo= Z2luZw== CWc= IHNpbmdsZQ== b2Zmc2V0 YXJuaW5n b2dyYXBo bGV5 X2NvdW50 IGFuYWw= Y3JlYXRl L20= IFJlZw== OTg= dW5jaA== PSQ= aXNr IHJpZ2h0cw== KE0= ICIiIgo= YXBlcg== Lm1vZGVs IHBv ZW1wdHk= YXJ0bWVudA== IGFudA== IFdoZW4= IHdvbWVu IEVk IHNlYXNvbg== IGRlc3Q= w6M= KGg= IHBvc3NpYmxl IHNldmVy IGJ0bg== IGRpZG4= IHNlbnQ= IGVuYw== IGNvbW1hbmQ= IF0sCg== X3g= IHJlY2VudA== b2x1dGlvbg== dmVjdG9y IEJ5 IE1heQ== IEFjdA== u78= IG1vbmV5 SU5U YnNpdGU= CXA= Lg0K 77u/ c2w= YXR0ZXJu IENsYXNz IHRvbGQ= dWRpbw== Y3VycmVudA== IGVxdQ== IGF1dG8= IFN0YXRl ZGE= bXNn KSk7Cgo= IHdvcmtpbmc= IHF1ZXJ5 IEJy IHdpbmRvdw== YXV0aA== b25seQ== CXQ= IGxlYXN0 YWdu IGV4cGw= aXR0ZXI= YXJpbmc= IGNvbHVtbg== IEdlbmVyYWw= Ijoi ZXJhbA== cmlvcg== IHJlY29yZA== SUI= RVg= IGRhdA== IG1ha2luZw== dWVk IENhcg== ZW1w Ii4= IE1lZA== IGNsb3Nl IHBlcmNlbnQ= IHBhc3Q= KGc= Oig= IHdyaXRl IG1vdmU= IHBhdA== Q29udHJvbA== LlRv IHZp Ki8K aW5hdGU= J2xs YWdlZA== TnVsbA== IHNwZWNpYWw= SVpF IGNpdHk= LyoK IEVuZw== aXhlZA== aW5hcnk= cHk= IGVmZg== YXJpbw== IHRlbGw= YXZvcg== IHNlbGVjdA== bGV2ZWw= aW11bQ== b3Blcg== QnVpbGRlcg== SVA= JyksCg== ZXNj IGZvbnQ= IjsKCg== IEFt aXNoZWQ= aWxscw== SW50ZXI= T1c= IGNvdXJzZQ== IGxhdGU= aWRkbGU= NDM= IGFtb3VudA== IGFzeW5j aW5v Y3Vs IOw= YW5kbGU= X3VzZXI= IGJlbg== IENhbA== ICRf IFJlcA== IGVub3VnaA== VG9rZW4= LnVzZXI= KGo= U2M= V2lkdGg= bm93 YXRmb3Jt IGxvb2tpbmc= IGhvbGQ= TW9kdWxl SVRZ dm8= aXNvbg== LkRhdGE= eWM= IHBvdA== IFRydW1w aWR1YWw= aWRlcw== cnQ= IHByb3BlcnR5 ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== YW1ld29yaw== Z28= IGxvdw== IHBhcmE= IHByaWNl dXJ5 IHRvZGF5 cm95 ICcv IHBvbGl0 ICcn eW1i UGg= IGFkdg== IGF0dGFjaw== IFN0ZQ== Uk9N NDAw YW5h IG1lYW5z IHN0b3J5 aWRz YWtlbg== IG1lZXQ= IG1vbQ== IOKAmA== ID8+ IGRlbg== b2JpbGU= Y2hhbmdl ICAgICAgICAgICAgCg== aWNp bmE= IEZvcm0= IHNvcnQ= U2VsZWN0 cGFyZQ== IHRob3VnaHQ= X2Nvbg== IHRhc2s= b2N1cw== IERF IE1pbg== IG9wdA== CWJyZWFr dW1lcg== S0U= dGhlbg== IGRldA== IFRlc3Q= cG9ydHM= IHJldmlldw== KCcv bW92ZQ== IHN3aXRjaA== RVJU cGF0Y2g= YW5ub3Q= 44I= IGFib3Zl aXRpdmU= NTY= IHF1ZXN0aW9u IFF1 44CCCgo= Z2xl IHdvcmQ= IHByb3ZpZGU= IFJldHVybg== IHJlc2VhcmNo w6Nv dXN0cg== IHB1Ymxpc2g= Y2hlbWE= fX0= IENPTg== LWlu YWxsYmFjaw== IGNvdmVy XFw= Y29sb3I= IElT IHdoZXRoZXI= aW1hdGU= aXNj QmFy IGRpdg== QmU= b3Vybg== IGhhdmluZw== bGVt cGxheWVy YWJz YW1lcmE= bmV5 IGV4Yw== Z2V0aGVy cGxpZWQ= YW8= WyQ= ICsr aXBl c2hvdw== L2Q= Wzo= YWdlbWVudA== bGV2 X0lE OTc= cmFyeQ== YWRlcw== X3Nl YXVzZQ== IGVtcGxveQ== ICovDQo= IGZyZQ== ICdA IGNvbXBsZXQ= IGxhcmdl cmFs XHg= IGZhYw== PFN0cmluZw== IGNyZWF0ZWQ= dXBlcg== LnN0YXRl IGhvc3Q= ZW5lcmlj L2I= KCE= d2hpbGU= aWFz QlVH ICk7Cgo= IHJvbGU= UmVn IENvbG9y U3RhcnQ= IHBvcm4= dG9w IHdlYg== IGRldg== IGRlYWw= KyspCg== SW50ZWdlcg== cG9zaXRpb24= Lm9u ICgi 5Lg= IHByb2JsZW0= c3Y= IHByZXNz QUJMRQ== QVRJT04= IFNlZQ== YW5jaA== IHRob3VnaA== bGVlcA== IDwhLS0= IHBvaW50cw== ICAgICAgICAgICAgICAgICAgICAgICAgIA== Lko= IDo6 cHRy REI= Kys7Cg== LnBuZw== bm9kZQ== c29mdA== cG9uZA== IGV2ZXI= LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== TWVudQ== KCcj IHNlcnZpY2Vz cGc= fSkK cGFyYW1z IGFjdHVhbGx5 ICIv RW1wdHk= TWV0aG9k IGlkZW50 dW5pYw== IG1pbGxpb24= IGFmZg== c3R5bGU= IGNvbmM= aW9z aWdubWVudA== VUxU UHI= IjsNCg== IHVuZGVyc3RhbmQ= dWFyeQ== IGhhcHBlbg== IHNlcnZlcg== IENv U0M= IGxlcw== IGZpbGVz R3JpZA== c3Fs IG9mdGVu IGluZm8= X3Ry c3Jj b255 IHNwYWNl dW1i IHBhc3N3b3Jk IHN0b3Jl LAoK IFdoYXQ= Z2Vk IEZhbHNl VXM= c3dlcg== X2luZGV4 IGZvcm1hdA== bW9zdA== c20= TmV3 IGRldGFpbHM= IHByb2I= IEFORA== KCkNCg== aWxhcg== ICR7 cnlwdA== LkNvbGxlY3Rpb25z JHRoaXM= IEZyZWU= X29m KGZhbHNl ZGF0ZWQ= ID4+ IGZhY2U= Q1RJT04= IHNhdmU= IHR5cA== ZGV2 KCIj QUdF Y29udGFpbmVy ZWRpdA== UUw= IGl0ZW1z IHNvY2lhbA== aWVu IFJlYWN0 KS4KCg== IG1hcg== IHJlZHU= IFJF LnB1dA== IG1ham9y Q2VsbA== bmV4dA== IGV4cGVjdGVk IHlldA== IGluZGl2 dHJpYnV0ZXM= YXRpcw== YW1lZA== IGZvb2Q= U291cmNl KHN0cmluZw== ICsK aXRlcw== ZHI= IG1lbWJlcnM= IGNvbWI= aXRlbXM= IFBlcg== VEg= PVRydWU= IGJhcg== X1NF Y29tbQ== KHc= KQoKCg== IHNlbmQ= IGluYw== dW5zaWduZWQ= RkE= IHBhcmFtcw== YXBwaW5n cm9z dWdpbg== ZmE= IGNvbm5lY3Rpb24= IH07Cgo= IGJlY29tZQ== TW9kZQ== IGV2 IGRpZmY= IFVuaXRlZA== SGVpZ2h0 ZnVsbHk= aW1hZ2Vz IG1ha2Vz IGdsb2JhbA== IGNvbnRhY3Q= JzoK IGFicw== 0LDQ ZmxvYXQ= IGV4Y2VwdA== IFBvbA== Q2hpbGQ= dHlw IGNlcnRhaW4= acOzbg== T1VU IGltcHJv aWxlcw== IC0tPgo= IFBhcnQ= dmFsdWVz b3Nz Lyoq aWxpdA== IEV2ZW50 Y3VyaXR5 c3Rlcg== IGNoYXJhY3Rlcg== MTk4 IG5ld3M= ICIs IGRldmljZQ== Y2Vs bG9naW4= aGVldA== RGVmYXVsdA== QCI= CSA= Y2xpY2s= KHZhbHVl IEFi IHByZXZpb3Vz RVJST1I= b2NhbA== IG1hdGVyaWFs IGJlbG93 IENocmlzdA== IG1lZGlh Y292ZXI= IFVJ IGZhaWw= IGJsYWNr IGNvbXBvbmVudA== IEFtZXJpY2Fu IGFkZGVk IGJ1eQ== c3RpdA== IGNhbWU= IGRlbGV0ZQ== cHJvcGVydHk= b2Rpbmc= IGNhcmQ= cm9wcw== IGh0dHBz IHJvb3Q= IGhhbmRsZQ== Q0M= QmFjaw== ZW1wbGF0ZQ== IGdldHRpbmc= X2J5 bWFpbA== X3No LmFzc2VydA== IERlYw== KHRydWU= IGNvbXB1dA== IGNsYWlt Jz0+ IFN1Yg== IGFpcg== b3Bz bmF2 ZW1lbnRz KGlk IGVudGVy YW5nZWQ= RW5k IGxvY2F0aW9u IG5pZ2h0 IGRvaW5n IFJlZA== bGlu fQoKCg== dmlkZXI= IHBpY2s= IHdhdGNo ZXNzYWdlcw== IGh1bWFu IGRhbQ== cGVuZA== ZGly IHRheA== IGdpcmw= cmVldA== IGJveA== IHN0cm9uZw== KHY= cmVs IGludGVyZmFjZQ== IG1zZw== ZmVjdA== X2F0 IGhvdXNl IHRyYWNr Jyk7Cgo= amU= IEpvaG4= aXN0cg== KFM= dWJl IGNl aXR0ZWQ= VkVS Kik= cGFyZW50 IGFwcGxpY2F0aW9u YW55 LnN3aW5n IHBhY2s= XHU= IHByYWN0 IHNlY3Rpb24= Y3R4 IHVuc2lnbmVk LlBvaW50 IE9uZQ== xLE= aXBsZQ== YWlk 0YM= VmVjdG9y Ynl0ZQ== IHdhaXQ= IMOg w6U= IHRvZ2V0aGVy IHRocm93cw== Rk8= Jykp aG9zdA== aXNpbmc= LnZpZXc= IHRlcm1z ZnJhbWV3b3Jr LXI= IGFwcGx5 IHNlc3Npb24= T3B0aW9ucw== dWdnZXN0 IG90aGVycw== d2l0dGVy IGZ1bmQ= SW5pdA== X18o ZW5zb3I= R0VU IHNldmVyYWw= aWk= W2o= SU8= IHRlbXBsYXRl UG9zaXRpb24= IGVjb24= YWNoaW5l IGls LnNwcmluZw== bWFpbg== ZWx0 aW1lbnQ= UmVj bW0= IFVuaXZlcnNpdHk= dXJzb3I= ICAgICAgICAgICAgICAgICAgICA= R0w= aWN0dXJl aXRodWI= Y2Vy Y2FzdA== RnJvbQ== YWxlcw== IHN1YmplY3Q= cGFzc3dvcmQ= bnk= IGVzYw== LndyaXRl 77yM V2hhdA== Lkg= IGhpc3Rvcnk= IEZl IGluZGl2aWR1YWw= dW5pdA== IC0tPg== IGR1 SVNU IHVzZXJz ZnM= ZmFsc2U= dW50 VGl0bGU= IG1vdA== IGZ1dHVyZQ== YWNoZWQ= IHN0YXJ0ZWQ= IG1vZGU= ICc8 X2FycmF5 IGF4 J107Cg== aXJlcw== VGhlcmU= dWdodA== dG1s cG9zZWQ= aWN1bHQ= IHRvb2s= IGdhbWVz IH19 ID8+Cg== IHByb2R1Y3Rz SXM= IGJhZA== IERlcw== LnBhdGg= JwoK IFBvc3Q= YXZlbA== KDo= MTUw IG5lZWRz IGtub3du Rmw= IGV4ZWM= IHNlZW4= NTE= dW1l IGJvcmRlcg== IGxpdmU= dGVtcA== UGVy IHZhcmlhYmxl aWV0 IERlZg== IGdl ZW1l X2JhY2s= Zmlyc3Q= IHByb3ZpZGVk Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8= IGZpbGVuYW1l IGhvcGU= dWx5 YXV0bw== ZmluZA== X3N0cmluZw== YnRu aXR1ZGU= QXR0cmlidXRl IHlvdW5n LnR4dA== IHdlYnNpdGU= IFByb3A= IGV5 PigpOwo= aW9uYWw= QVJS aWN0aW9uYXJ5 dXJ0aGVy Ljwv QUxM IHN0dWR5 aWxp IG5ldHdvcms= eWw= aXN0YW5jZQ== T0s= TlU= cmVzdA== IFNU aWNyb3NvZnQ= IGxpbWl0 IGN1dA== KCk6Cg== IGNvdQ== b2du IHNpemVvZg== aXZhbA== IHdlbnQ= Lno= TGluaw== IGZpcmU= IGFjcm9zcw== IGNvbW11bml0eQ== cmVnaW9u TkU= UmVm IG9mZmljaWFs IHZpc2l0 b2x2ZQ== IHJlY2VpdmVk IHRva2Vu IG1vbnRocw== IGFuaW0= IHBhcnRpY3VsYXI= c3R5bGVz aWNv IGVzcw== ODc= LkNvbnRyb2w= IMOp YmFsbA== IGxlYXJu aW5kaW5n VmFy IGRlY2w= KGVycg== TEVDVA== T25l cGhh IH4= Zm9ydA== YXN1cmU= IG1pbmQ= IEVuZA== Q2hlY2s= IHF1aWNr Iiks QU5E dXRpb25z QmFzZQ== X19fX19fX18= IGNvbW1lbnQ= SU5F 4oCZdmU= QnV0 IEVs IFVz IGFkbWlu bWFyaw== IE5hbWU= YAo= IFR5cGU= YW1pYw== cGM= bG9vcg== RlQ= IG9wcA== Y2tldA== KS0+ dHg= IHB1cg== dWVs eW1ib2w= dWF0aW9u YW5nZXI= IGJhY2tncm91bmQ= ZWNlc3M= ZWZpbmVk Li4uLi4uLi4= IGRlc2NyaXB0aW9u IHJlcHJlc2VudA== IikpOwo= cHJlc3Npb24= cm93c2Vy IHNlcmllcw== d2FyZHM= NTI= KCRf YWlzZQ== IGhvdA== YWNpdHk= cmllcw== YWN0aW9ucw== Q3JlYXRl YWRpbw== YW1wbGVz IG9yaWdpbmFs ZW5zaXZl Zm9udA== c3RyZWFt 77u/dXNpbmc= LnNwcmluZ2ZyYW1ld29yaw== MDAx c2VydmVy IGJpbGw= QUNL aWxlbmFtZQ== IGZyYW1l ID0K RWRpdA== YWRpdXM= IGRyYXc= YW5rcw== IGRldGVy IGNvbWVz X2ludA== IGZvcmVhY2g= YW5nbGU= IGVsZWN0 cGVjdGVk SGVhZGVy aXN0cmF0aW9u RmFsc2U= IEdhbWU= IGZpbHRlcg== QWN0aXZpdHk= IGxhcmc= aW5pdGlvbg== ICI8 MjU2 aXNlZA== IHJlbW92ZQ== IFRyYW5z bWV0 c2Vl Rm9ybWF0 Q29tbWFuZA== IEVY Tm9uZQ== IGZyb250 QVNF IFJlYw== b3VuZGF0aW9u IHZv OTY= PVwi KCo= Q2hhbmdl LldyaXRl Z3JvdXA= aWVudHM= dXk= KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKg== IGRpZw== aHI= KC0= IGdlbg== bnVtYmVy dmVj dXJvcGU= ZW50cnk= TEw= IHN0ZQ== VmFsaWQ= J10s X3BhcmFt IHNlbGVjdGVk IGFjY29yZGluZw== IERpcw== IHV0aWw= QnVmZmVy X2Vycm9y IGFzc29jaQ== X1NJWkU= IHdvcg== IHByaW50Zg== cmFn wqA= REQ= IFZhbA== IGFjdGl2 RW5n ZXRpbWU= IHZpcnR1YWw= YWlnbg== YXVy IFByZXM= IEV4Y2VwdGlvbg== IGFueXRoaW5n IE9mZg== IGhvdXJz IHdhcg== QXJncw== YWdpbmc= IG1vZGVscw== IFRpbWU= T2I= YW1z am95 IGVhcmx5 LnJlYWQ= ODY= IGNlbnRlcg== IEluaXRpYWw= IGxhbmd1YWdl bGVuZ3Ro eHk= IHNu IGluZg== UG9zdA== IGFnbw== IGVhc3k= X2NvZGU= IEFOWQ== X2No IGRvd25sb2Fk KFQ= YXZlZA== 4oCT IHN0dWRlbnRz IGZpZw== bGlnaHQ= eHg= IGJ1ZmZlcg== IERlcA== IE1hdGg= SVRI IHZhcmk= IGR1ZQ== RmFjdG9yeQ== IHBvcg== IGVw b3R5cGU= IGNhbm5vdA== IHdoaXRl PGludA== dGVybg== IHJlZ2lzdGVy IHByZWQ= Y2x1cw== X2RhdGU= IC8qKg== IGF1dGg= IFtdCg== IHBlcmlvZA== bm93bg== IHZvdA== IHNjcmVlbg== J2Q= VHlwZXM= IHRtcA== 0LXQ dXJhbA== IGJlbmVm X3k= IG5ldA== IFN0YXRlcw== J11bJw== IE5l IE5PVA== IG5lZw== MTAy IGNvbW1vbg== c2NvcGU= IGNyZWQ= Z2Vz X1RZUEU= IHN1Z2dlc3Q= b29t LgoKCg== IGFjY2VwdA== IHJhbmRvbQ== ZXJt IFZlY3Rvcg== d2l0aA== VEVS KHN0cg== IHJlc3BvbnM= IGhpdA== LlNldA== Z3JpZA== cmlh IGNsaWNr dW5kbGU= Q2FzZQ== aW5zZXJ0 VXRpbHM= ICIiIg== IGltcGxlbWVudA== YXRhbA== dGVtcHQ= dGVtcGxhdGU= b2Ny cmV0dXJucw== IHBsYXllcnM= dXNlcnM= ZWRlZg== IFRoZXNl IGFtb25n IGRlYg== aGE= LmdldEVsZW1lbnQ= IGNpcmM= IGFuc3dlcg== IHdhbGs= IHRyZWF0 IEdl IENyZWF0ZQ== IGFnZQ== IHJlcQ== T1NU YW5ndWxhcg== 0Y8= IGZpdmU= NTM= IGRpc3RyaWJ1dGVk IGZyaWVuZA== VFA= IGNsZWFu b3dz LkNvbnRyb2xz ZGlz IHdvcmRz Lmlv enk= IGhlYWRlcg== IENoZWNr 4oCZbQ== anVzdA== aG9sZGVy PSI8Pw== IEdOVQ== IENvbA== aW1lc3Q= ZW50aWM= ewoK IHRyZQ== bGFzdA== bGE= IFlvcms= TG8= IGRpc2N1c3M= IEdvZA== IGlzc3Vl cmV3 V2luZG93 IGxhbmQ= MTIw IHN0cmVhbQ== IFBhcg== IHF1YWxpdHk= UGFy X251bQ== NTQ= IHNhbA== ZWx2ZXM= T1JE KHVzZXI= IHdvcmtz IGhhbGY= ZW5zZXM= dmFz IHBvbGljZQ== KCIv dWE= IHNpbXBsZQ== QWRkcmVzcw== IGVtcHR5 ZXNo MTI4 VXBkYXRl IENyZWF0ZWQ= KCcu KS4K ICAgICAgICAgICAgICAgICAg IGFncmU= IEZST00= IGNvb2s= IGV2ZXJ5dGhpbmc= aWxpdGllcw== LnN0YXR1cw== IHJlbGF0aW9ucw== ZXh0ZXJu IG5vdGhpbmc= IHJ1bm5pbmc= CXZvaWQ= Ukk= X2E= X0NPTg== cG9y LnN1Yg== cmVxdWlyZQ== IENpdHk= IFdlc3Q= IG1vcg== c3RvcmU= RXF1YWxz b2Rlcg== IG5h IFtb ICgn IERvbg== RVJT L3A= Lmpzb24= YWJvcg== IHNvbWVvbmU= X3RleHQ= LmNzcw== LlRhYg== IFNvbWU= YXRv ZG91Ymxl IHNoYXJl KHZvaWQ= X2Rpcg== IHVy U3RhY2s= IFdvcmxk Llg= c3RyYWN0 SG93 LkdlbmVyaWM= aWNsZXM= IGVudHJ5 IGNoYW5nZXM= IHBlcnNvbmFs KEE= IG9mZnNldA== X3B0cg== IHBpZQ== IEphbg== LWdyb3Vw bW9kdWxl SXRlbXM= IEhvd2V2ZXI= dmVyYWdl LkZvbnQ= IGV2ZW50cw== Lm1pbg== IGludm9s emE= IHdob2xl IG5lZWRlZA== IGxpa2VseQ== cmllZg== T1JN dmVyc2lvbg== IGZpZ2h0 IGVpbg== RnJhbWU= MTk3 Z2Vu IE91dA== YXZpZ2F0aW9u TGVuZ3Ro aWxsZWQ= cXVlbmNl ICE9PQ== IFNvZnR3YXJl IHdyaXRpbmc= IHJhdGU= J10sCg== UGFuZWw= aW5uZXI= IFsi IHR3 Y2Q= IDsK X3N0YXRl IFNt IE1hcms= KSkKCg== cHJvdA== IE1y bWV0aG9k dXN0b21lcg== SWNvbg== IGNvcnJlY3Q= KG9iamVjdA== IE1vcmU= IGZhbGw= IHZvbA== IGRldmVsb3BtZW50 ZW50bHk= IHNp bWVkaQ== dmluZw== UFA= YWtlcg== IGluZHU= IGVsaWY= IHByZXQ= IGJlbGlldmU= bnM= b21ldA== MTIz IEludGVybg== UmVjdA== U28= LmVycm9y UmVhZA== IGZlYXR1cmVz IG1pbnV0ZXM= LS0t YXNpbmc= Y3JldA== Ij4NCg== LmFubm90 IGNvbGxlY3Rpb24= Jy4= IHNpbWlsYXI= IHRha2Vu KCIl T3JkZXI= J10K LW1k IFRI YWNlZA== IGlzbg== L2o= IHNvbg== Z3JhcGg= IEludGVnZXI= IG5lY2Vzcw== cmVlbg== IHVt IFw8 IG1vbWVudA== IGJyaW5n IGluZGlj eXNpcw== TGV2ZWw= dmVyc2U= dXJyZW5j X3Rlc3Q= IGVudGlyZQ== RG93bg== IH0KCgo= KHJlc3VsdA== IFJlYWQ= w6g= TW9k IHRyeWluZw== IiksCg== IG1lbWJlcg== IENvcg== T0RP LWNvbnRyb2w= dW50aW1l IFNpbQ== RGlhbG9n cGxvdA== X29u IHBoeXM= fS8= IG5hbWVzcGFjZQ== CQ0K YWNj UGxheWVy QVJF ODk= IGZvb3Q= IGJvYXJk cGFydA== IHN1cw== d2lzZQ== IE1j IHB1c2g= QVRB IHBsZWFzZQ== cmllZA== d2VldA== Yml0 aWRlZA== VkU= IFN3 VUI= IHR5cGVz ZWRpYQ== IGNsb3M= YWNlYm9vaw== V2hlbg== IGVkaXQ= aWdnZXI= IGVuZXJn Q29udGFpbmVy IHBob3Q= IENvdW50 IEV1cm9wZQ== Lklz IFJ1c3M= cGVlZA== IFN0cg== IHB5 IGN1bHQ= IGRlZmluZWQ= Y2NvdW50 IG9idA== LkxvY2F0aW9u IHRocmVhZA== aWxsZQ== IGluc3RlYWQ= c3Ryb25n IFNlYw== VVJF IGlkZWE= LnNl ZW15 c2VsZWN0ZWQ= Q29ubmVjdGlvbg== YWNpbmc= dGhyZWFk Lm5leHQ= IGNvbGw= IGZpbG0= aXN0aWM= IGNvbXBldA== IGNvbm4= dGhvdWdo IGNvbXBhbg== b2NrZXQ= IHRlYWNo PSg= IHBob25l IGFjdGl2ZQ== Nzk= ZGVsZXRl MTAx dHJpZXM= IG1v IGRlYXRo fSk7Cgo= b2NvbA== V2lkZ2V0 IGFydGljbGU= cm9kdQ== YW5kaWQ= 0Ys= IENy a2E= KCk6 bG9vZA== CQkJCg== IGFsbW9zdA== IHNlbGw= ZXJ2bGV0 cmlw VW5pdA== IGFwcGxpYw== IGNvbm5lY3Q= IGZlYXR1cmU= IHZpYQ== Jyks IGxpbQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IEd1 RW5naW5l IGVucw== IGVudmlyb25tZW50 YmxvY2s= SEVSRQ== TlVMTA== Z3k= dGFn KSku ZXhw IGNvbXBs IGluc3RhbGw= IGNvbXBsZXRl cXVldWU= YXR1cmFs IGdlbmVyYWw= dGhvbg== IGFza2Vk b3Jlcw== KHJlcw== IHJlc2VydmVk U1A= IOKApg== xYI= IHNpZ25pZmlj T2Zm ICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IEFn IEp1c3Q= IEVycm9y IGluZmw= YWRhdGE= IGljb24= YXNrcw== Jyc= X0xP Py4= YWNjb3VudA== ICgq JykKCg== cmFw X3Zhcg== IEZPUg== IHBhcnR5 IFlvdXI= Y2F0 c3RyeQ== Lm5ldw== Ym9vdA== IE5vdg== IHZlY3Rvcg== IG5vcm1hbA== IGZ1cnRoZXI= UmVwb3NpdG9yeQ== ODAw IGRhdGFiYXNl YXR0bGU= IG11c2lj IHNwZWVk IGRvYw== cHJvY2Vzcw== SUdIVA== LnBhcnNl IHRha2luZw== IHZpb2w= Y2VlZA== IEFmdGVy IGZvcndhcmQ= IGNyaXQ= Ii8+Cg== cm90 IGZhaWxlZA== ZWZvcmU= IGNvbmNlcm4= b2U= YmE= IHNlbmRlcg== IHRlcm0= aGFz PSIj IHBvdGVudGlhbA== TnVt IHB1Ymxpc2hlZA== LmNsb3Nl IEltYWdl c3RyYWludA== VUQ= IE9i IHByb2JhYmx5 bGlt IjoK b2x1bWU= IGNvbnN1bQ== NzY= YWd1ZQ== ZW5zaW9ucw== IGludmVzdGln LXllYXI= Jyk7 LXNt IGVuam95 b3JpZw== ZXJpbmc= Y3A= bGVhc2Vk cGxlbWVudHM= IHJldHVybnM= cGF0 Qk8= IEhvdXNl LkxhYmVs IHdlaWdodA== aWdoYg== IGNvbmRpdGlvbnM= IGV4Y2VwdGlvbg== ZGVzY3JpcHRpb24= IHRyYWQ= LXRv IHt9 IG1vZHVsZQ== RU5E LmFw LnByb3Bz IGNvbnN0cnVjdG9y YXZlcw== IGZhdm9y IE5vdw== O2k= IE1haW4= X2s= ZXJpZXM= 4oCZbGw= dHJhbnNmb3Jt aW1lc3RhbXA= UHJl IG1lcg== LnJlcw== c3RhbnQ= TG9jYXRpb24= X05BTUU= IGxvc3M= IAoK bmV0 IGVuZ2luZQ== QmxvY2s= IGlzc3Vlcw== IHBhcnNl IEJhcg== IHN0YXk= IEpTT04= IGRvbQ== YWlycw== d25lcg== IGxvd2Vy IiwNCg== IERlbQ== dWZhY3Q= IHBz IHBlcmZlY3Q= Ukw= IGVkdWM= bHM= ZW1vcnk= QVJSQU5U dWdl IGV4YWN0 LmtleQ== YWxsZWQ= ZWNo aWVm XC8= b2tl IGZvcm1lcg== YWxsb2M= IHNpeA== aWRh IG1hcmdpbg== IGhlYXJ0 YWxk cGFjaw== LmdldEVsZW1lbnRCeUlk IFdBUlJBTlQ= IHJhdGhlcg== IGJ1aWxkaW5n ZXJtYW4= bGljZQ== IHF1ZXN0aW9ucw== aXplcw== bGVnZQ== aXJlY3Rvcnk= IGpl IGNhcw== cHJvcHM= dXRm IHNlY3VyaXR5 IGhvd2V2ZXI= d2VpZ2h0 IGluc2lkZQ== IHByZXNpZGVudA== Q2hhcg== IFdJVEg= Lm1hcA== IGdyYXBo IHRhZw== X3N0YXR1cw== IGF0dGVtcHQ= b3Bw dXNlcw== CWNvbnN0 IHJvdW5k LCQ= IGZyaWVuZHM= RW1haWw= Pz4= UmVzb3VyY2U= S0VZ b3Nw LnF1ZXJ5 IE5vcnRo YWJsZXM= aXN0cmli X2NsYXNz ZWxsbw== VGhhdA== 0Lo= cGVjaWFsbHk= IFByZXNpZGVudA== IGNhbXBhaWdu IGFsdA== YXJlYQ== IGNoYWxs IG9wcG9ydA== LkNvbg== IGVuZXJneQ== bGlrZQ== LnN0cmluZw== aW5ndG9u KSo= eXk= IHByb2Zlc3Npb24= aXJ0aA== IHNlZw== 5pw= IGhvcg== aWVycw== Y2Fu IGJlaGluZA== UHJvZHVjdA== Zmc= IFNr LmpwZw== Pzo= XTsKCg== IGNhbGxiYWNr IEh0dHA= 0Yw= bG9uZw== TVM= QVRI IHJhaXNl IHdhbnRlZA== cm93bg== dXRvcg== bHQ= XT0= ZWxpbmU= TUE= IHNlcGFy Y3M= c2VtYg== RGlz YnNlcnY= IFdpbGw= IHBvbGljeQ== IHRoaXJk cGhvbmU= IGJlZA== L2c= Ll9f IEluYw== aXppbmc= LnJlbW92ZQ== aW5zdGFuY2U= LnR5cGU= IHNlcnY= RWFjaA== IGhhcg== IE1lc3NhZ2U= KGtleQ== U0VMRUNU UG9z KSk7DQo= IHJlY29tbQ== IHRyYWluaW5n IEVudA== IENoYXI= aWNodA== KGZpbGU= IHByaW9y R2FtZQ== IGV4aXQ= UGFyYW1z LmNvcmU= UEM= bmVz YW5jZWQ= KHJlcXVlc3Q= UGFzc3dvcmQ= fT4K IG1hZw== IHJlbGVhc2U= IHNoYWxs dWRlbnQ= IFNvdXRo YW5kbw== Oic= LlRhYkluZGV4 c2s= YW5uZXI= aXNzZXQ= IG91dHNpZGU= bGVkZ2U= IOU= IFJvYg== IGltbQ== IQo= IFdlYg== RGVz QkM= YW5jaWFs Um91dGU= RGVj ZmVyZW5jZXM= IHB1cmNo IE1vZGVs Y3Rvcg== Z24= X3N0YXJ0 X3Vu Lio= aXNlcw== IGdyb3VuZA== IHVuaXF1ZQ== IGJlYXV0 eyI= IHBvdXI= IE9jdA== IHRyZWU= c2V0cw== X3Jlcw== JyktPg== X3JlZw== KCJc IGJ5dGU= Qmw= IGRhdGluZw== IG1hdHRlcg== IFJlbQ== ICcuLi8= IEF1Zw== IExh ICQo b3VybmFs MTEx aWFt IHNob3dz d3JpdGU= IGJhbGw= IHNpbXBseQ== IGZhc3Q= IG1lbW9yeQ== QVNT IE9m b3ZlZA== YW50ZQ== YXVs aXN0cnk= KSkpOwo= IGZpdA== PHN0cmluZw== IHBvbGl0aWNhbA== YW5jZWw= Xy4= Y2FyZA== LmN1cnJlbnQ= b2No X2ltYWdl XHQ= Iwo= KEw= IGluZHVzdHJ5 Y29taW5n IGV4dHJh NjAw IHJlcG9ydGVk LnN0YXJ0 IHJlc291cmNlcw== IGltZw== Zmxvdw== X0VY KG51bGw= IFByZQ== IHdyb25n aW50ZXJmYWNl UGFyYW1ldGVy bmVycw== 4bs= dHVyZQ== ZXJzaXN0 b3VudHJ5 IHNlZW1z YWxhbmNl ZGVzdA== CVN0cmluZw== IG1haW50 IHVuaXQ= YWN0ZXJz IFRS aWZ1bA== ZXhwb3J0cw== cHJvamVjdA== QXBwbGljYXRpb24= bGVnYXRl IHRha2Vz dGVybQ== IGV0Yw== dXN0ZXI= IGFwcGVhcg== YWRkcmVzcw== IGZlbQ== aHM= IGhvbQ== LC0= IGRpZmZpY3VsdA== IGNvbWluZw== T3Blbg== IHNldHRpbmdz IFdhcg== IFRoZW4= IGF1dG9t IEZvdW5kYXRpb24= IHF1aXRl RGVzY3JpcHRpb24= IGJsb2c= aXF1 UFM= MTEw X2ZpZWxk SnNvbg== U1NJT04= IFNjaA== IExP IGRlc2NyaQ== IGV2ZXJ5b25l IHByZXR0eQ== IGxvbmdlcg== IG1lbnU= IGN1cnJlbnRseQ== c2Vj IHJlbGF0aW9uc2hpcA== IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyM= IE1hcA== YXNldA== IHBhcmFtZXRlcnM= IGNydXNo Ig0K SUxJVFk= aWdyYXRpb24= IGNvdXQ= dG90YWw= IG5hbWVz bmRlZg== Iik7 cmllbmQ= eW5hbWlj IGVmZm9ydA== IGFjdHVhbA== IGZpZWxkcw== T1VO dGVycw== MjUw IGZpeA== X21vZGVs IGNhc2Vz Q0E= TXk= SW50ZXJmYWNl IFNF MTk2 XV0= YWxsZQ== IE5hdGlvbmFs IEFycmF5TGlzdA== aW5saW5l LlY= YXJh cmVmaXg= YXNj UmVhZGVy INC/ YXN0aWM= KCgp Q2w= LmFubm90YXRpb24= IHBlcmZvcm1hbmNl YWlseQ== LnRvU3RyaW5n Lm5ldA== dmlld3M= LmVuZA== YXllcnM= bGF0ZQ== IEFwcg== ZWRlcmFs J10p LmJvZHk= IGhpZ2hlcg== X2Zs Y3I= YWxlcnQ= X25vZGU= IEdvb2dsZQ== IGl0c2VsZg== QXV0aA== dXJyZW5jeQ== IHNpZ25pZmljYW50 YXBwZW5k IHJlc3BlY3Q= c3RyYXA= IHVuYQ== cml0ZXJpYQ== UE9SVA== LmFwYWNoZQ== T3V0cHV0 IHByb2dyZXNz IG1pZA== IE1pY3Jvc29mdA== IHJlc291cmNl YWJsaXNo IGRpbQ== LmxvYWQ= LkFwcA== IGRpcmVjdGlvbg== IGFkZGl0aW9uYWw= ICAgICAgICAgICAgICAgICAgICAgICAg IG51bWJlcnM= IGNvbXBhbmllcw== LlRo IHNvdW5k dXNlcm5hbWU= IHN0YXRlbWVudA== IGFsZXJ0 IGNvbnRyYWN0 aG9tZQ== X2xlbmd0aA== LkNvbXBvbmVudA== ZXY= LkV4 77ya Ijs= IEhpZ2g= ICkKCg== IFBvaW50 b3Bo IGxpbmVz LT5f IikKCg== b3g= YXBwbGljYXRpb24= IF0K CgoKCgoK MTgw IHNvb24= Y3Rpb25z aW5nZXI= IGpvaW4= IFBl IOs= IGxhcw== LkU= Y3Nz L29y IFN0YXJ0 IFRP IHN1YnM= Y29ubg== Y29tcG9uZW50cw== REVCVUc= cXVhcmU= RnVuY3Rpb24= ZW5kYXI= LmluZGV4 IGZpbGw= xJk= IGNob29zZQ== aG93 IEFtZXJpY2E= YXNzZXRz LS0tLS0tLS0tLS0t IFZhbHVl IG9mZmljZQ== IHZlaA== IHRyYW5zZm9ybQ== IEFydA== IGluZGU= IGZu IGltcGxlbWVudHM= YW5nbw== cGxldGU= KyI= dG1w YW1pbHk= IGhhc2g= bWlzc2lvbnM= RVNU Z3Q= UHJvdmlkZXI= ICAgICAgICAgICAgICAgICAgICAgIA== IGZsYWc= IHBhcnRpY2lw ZGVu IFJldHVybnM= IG5vdGU= w7xy cG0= aWRlb3M= IHNwZWNpZmllZA== IEVO ZXN0ZXI= b2xpZA== IHVwb24= KHN0ZA== CXY= ICdc dXo= IHZlcnQ= IHZpY3Q= CXNlbGY= ICIk ODU= Lms= IGdyb3Vwcw== Z2l0aHVi bGFuZw== IG11dA== VE8= IHZl IFBsZWFzZQ== OwoKCg== YWNjZXNz IHsi cmVh IHJpc2s= aWNrZXI= b2dnbGU= CXdoaWxl QU5H LnNlbmQ= NzI= IHdvbWFu IGdldHM= IGlnbg== IElk X2xvZw== T05F IGV2aWQ= IEhhcg== X3N1Yg== IGVuZGw= IGluY2x1ZGVk KCkpOwoK IEFw aWdy IHNlbQ== IEJsYWNr ZG9j X3RhYmxl ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== LXVw IGNhdXNl IC4u IHZhbg== X2RpY3Q= IGZvY3Vz SU5E Q0VTUw== LkxvZw== IG11bHRpcGxl aWRv IHJlZ2FyZA== LU0= YW5kbGVy b3Vyc2U= IGRlZw== LlU= IGFkZGl0aW9u IHZhcmlvdXM= IHJlY2VpdmU= 0LXQvQ== IEhU T2Jq REY= IGluY3JlYXNl IE9wZW4= XTs= IGNvbW1pdA== Pwo= YXRlZ29yaWVz YXRvcnk= c2hpcA== IE1pY2g= IGh0bWw= cm9taXNl IGxlYXZl IHN0cmF0ZWc= YXZlbg== IENvbnNvbGU= a25vd24= LW4= X0xF LmNvbXBvbmVudA== IGJyZQ== U2Vzc2lvbg== aWFuY2U= IGFsaWdu dHlwZWRlZg== X3Jlc3VsdA== IFdIRVJF LnNwbGl0 IHJlYWRpbmc= RkFVTFQ= IGNsbw== IG5vdGljZQ== X3By YXJ0ZXI= IGxvY2s= IHN0YW5kYXJk ZXRpYw== ZWxsb3c= IHBhZGRpbmc= IEhpcw== IHN0YXRlcw== X2Nhc3Q= KFA= YWE= IGludGVybmFs ZWFu IFBSTw== IEtleQ== IGVzcGVjaWFsbHk= bWluZw== IGNyb3Nz IG5hdGlvbmFs X29iamVjdA== ZmlsdGVy IHNjcmlwdA== LnVwZGF0ZQ== X2k= IEFzc2VydA== L2NvcmU= JSUlJQ== IHByb2JsZW1z aXN0b3I= IC49 IGFyY2g= IHdyaXR0ZW4= IG1pbGl0 TUVOVA== LmNo Y2FwZQ== IE11cw== X2NvbmZpZw== IEFQSQ== Zm9vdA== IGltYWdlcw== ZW5kbA== Lklu Rmlyc3Q= IHBsYXRmb3Jt LnByb3Q= T3B0aW9u c3Rl IFRPRE8= IGZvcmNl LmNvbnQ= CWVjaG8= IERhdg== UHRy KEI= UlQ= IEJhc2U= XVsn IGFubm91bmM= Y29uc29sZQ== IFB5 ZHM= LmFz IHByZXZlbnQ= YXBhbg== IHsn fTwv IFNlcnZpY2U= IFNlbg== YWRvcg== cHJvZmlsZQ== VG9w IGl0ZXI= cG8= SUVT SlNPTg== SUU= aWFudA== 44CB X2o= IFNlcHQ= X21hcA== YnVt KGNvbnRleHQ= IEhvbWU= aWFucw== R0I= NjM= IGxpdmluZw== IHBhdHRlcm4= KGlucHV0 aWNpZW50 OTk5 Q29yZQ== IGVudGl0eQ== IGludGVn Q2hhbmdlZA== IHVzZWZ1bA== LmluZm8= IHRvb2w= KGl0ZW0= IG9r IGZlZWQ= SVg= w6lz IE5ld3M= cmVtb3Zl ZXJyeQ== CQkJCQkJCQkJ aXBtZW50 YXJlcw== RG8= Q3VycmVudA== LmNvbnRlbnQ= Lkdyb3Vw dXN0cmFs INGB fSk= IHBvcHVsYXI= IHN0cmU= IG1ldGhvZHM= X0VSUk9S TGVmdA== Y2Fs YnNw LlRvU3RyaW5n IGRpcg== IGFsbG93ZWQ= IGltcGFjdA== IildCg== NjI= LmNvbmZpZw== IGVsZW1lbnRz IHByb3Rl IHRyYWlu LnRy cnM= IFJlcHVibGlj IFRhc2s= NjE= YXJpZXM= KEQ= KGdldA== 4oCmCgo= IHJlbGF0ZWQ= IHZlcnM= IHNpbA== ICIiOwo= IGNtZA== IHRlY2hub2xvZ3k= LndpZHRo RmxvYXQ= IFVzZQ== Qm9keQ== c2hvdWxk LmpvaW4= Rm9udA== bGx1bQ== eWNsZQ== IEJyaXQ= IG1pdA== IHNjYWxl IChf ZXJuZWw= IikpCg== IHNjb3Jl L3Y= IHN0dWRlbnQ= VUM= LnNob3c= IGF2ZXJhZ2U= RW5hYmxlZA== KGV4 Y29tbW9u aW1hdGlvbg== OkAi Y2hpZQ== IC4uLgoK cml2ZXI= IE1hcmNo Y2F0ZWdvcnk= Zmlu IGNvdXJ0 0LI= U2VydmVy IGNvbnRhaW5lcg== LXN0 X2Zvcg== IHBhcnRz IGRlY2lzaW9u b2Jz b3Vi bWl0dGVk ICQoJyM= IHNhdw== IGFwcHJvYWNo SUNF IHNheWluZw== IGFueW9uZQ== bWV0YQ== U0Q= IHNvbmc= ZGlzcGxheQ== T3Blcg== b3V0ZXM= IGNoYW5uZWw= IGNoYW5nZWQ= w6o= IGZpbmFsbHk= X251bWJlcg== UGxlYXNl 4KQ= b3Jpbmc= LXJl IGtpbGw= IGRydWc= d2luZG93 IGNvbnZlcnQ= b21icmU= IHdheXM= SGVscGVy IEZpcnN0 KF9f dXJpdHk= IFdpbmRvd3M= ZWVz IG1hdA== cmFwcGVy IHBsdXM= YW5nZXM= Il0u YXpvbg== L3Q= bGF0 YXN0ZQ== IHByb2ZpbGU= IHJlYWR5 I2lmbmRlZg== cm90ZQ== IHNlbnNl R2VuZXI= IENvbmZpZw== b215 IEp1bmU= IGxhdGVzdA== IHNhZg== IHJlZ2lvbg== IGRlZXA= d2l0Y2g= IFBhcms= fWA= IEZyb20= SUk= IGN2 IHJlYWNo IGNvdW50ZXI= IFdvcms= IFVSTA== IFVwZGF0ZQ== JywNCg== IGltbWVkaQ== Y2xvc2U= YWRvcw== ZmVycmVk IHdlZWtz dXJn IGRhbWFnZQ== IGxvc3Q= YW5p X2xv IGhpbXNlbGY= IGRvZw== KV0K 778= cGly dHQ= IHBhcGVy IHRoZW1z c2Vjb25k IHN0YWZm IElucHV0 Iis= IEZhY2Vib29r IGFsbG9j IHNjaGVk QUNF IHRoZW1zZWx2ZXM= IENvbXBvbmVudA== IGRyaXZlcg== amE= KHBhdGg= IGNhdGVnb3J5 YWxscw== cHU= bGx1bWluYXRl IEFjdGlvbg== LmJ1dHRvbg== IEdM aXN0aWNz IG9pbA== IHN0b2Nr Pic= IGRlYWQ= VkFM UVVF KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq IGNoYXJn UmV0dXJu IGZ1bA== ZG9t IHJ1bGVz IG1vZGlmeQ== IGV2YWw= aGFt YXRlbWVudA== XDw= dWxh PUZhbHNl UkE= IGNvbnRhaW5z NzQ= IHN0YWNr bWFy IHt9Cg== IHVuZGVmaW5lZA== QXNz IENoaW5h dmV5 Kgo= IHBsYXlpbmc= KS8= YWN0b3I= IGJvdHRvbQ== bGllcg== IE51bWJlcg== IGNvdXBsZQ== REM= IFNP Z29y LnNldFRleHQ= c3VjY2Vzcw== Y29tbWFuZA== RmlsdGVy IE91cg== X2l0ZW0= IGN0eA== IHJvYWQ= VmVyc2lvbg== Y2FzZQ== dXJ0 YXZpb3I= eWNo c2VtYmx5 IFByb2R1Y3Q= IGhlbGQ= YWZl IGluY2x1ZGVz PHF1b3Rl IGF2b2lk IEZpbg== IE1vZA== IHRhYg== YW5v w7E= aXBwaW5n LWU= IGluc2VydA== dGFyZ2V0 Y2hhbg== Lk1vZGVs SU1F XAo= IG1hY2hpbmU= YXZ5 IE5P IEludGVy IG9wZXJhdGlvbg== bW9kYWw= VGFn XTo= IHByb2R1Y3Rpb24= IGFyZWFz IHJlbg== X2Zyb20= bmJzcA== IG9wZXJhdG9y bWVu YXBwZWQ= X3Blcg== emVu KCIu LnNhdmU= PSJ7ew== IHRvcg== KHJlc3BvbnNl IGNhbmRpZA== IGNvbnY= YWlsZWQ= IExpYg== Y29tcA== dXJh 77+9 IEhlcmU= IGFyZ3VtZW50 aG9vZA== IGVzdGFibGlzaA== b2dyYXBoeQ== IG9uQ2xpY2s= YW1iZGE= IHNjaA== IG1vdmll IHNlYw== IGFjdGl2aXR5 2Kc= IHNxbA== X2FsbA== aW5jaXA= IHByb3ZpZGVz IHN5cw== YWNrZXQ= IHdhc24= IHVzZXM= IEZ1bmN0aW9u Lmdvb2dsZQ== IFJlc3VsdA== ODQ= VmlzaWJsZQ== YWdtYQ== ZWxjb21l IFN5 IENlbnQ= QUxTRQ== YWNpw7Nu RVhU IGxpY2Vuc2U= IExvbmc= IGFjY29t IGFiaWxpdHk= LmhlaWdodA== QWN0aXZl b2xvZ2ljYWw= b2x5 KSks LlNl IHBhcmFtZXRlcg== cHJpdGU= QUJJTElUWQ== LnNlcnZpY2U= IEdyb3Vw X3F1ZXJ5 IEl0ZW0= aW5pbmc= IGp1ZA== aW1z Zml4 aW5kZXI= YWdyYW0= IGZ1bmN0aW9ucw== IGV4cGVyaQ== IEVt IHJvdA== IHBlbg== LmJ0bg== IEFT I2lmZGVm IGNob2ljZQ== IFBhZ2U= X1BSTw== UVU= 5Y8= YW50aXR5 wq0= d29yZHM= IHJlYWRvbmx5 IGZsZXg= cHJvdGVjdGVk IEFueQ== IGNoYXJhY3RlcnM= ZW5jZWQ= IEp1bHk= aWxlcg== Q2FyZA== dXJhbmNl IHJldg== LmV2ZW50 YWx5 MTMw IHdvbmRlcg== IFBvcnQ= IGxlZ2Fs cm9sZQ== IHRlbg== IGdvZXM= TVA= d2hpdGU= KToNCg== KSkNCg== IHJlZmVyZW5jZQ== IG1pcw== IFByb2plY3Q= aWNrcw== PiY= Q09O IHJlcGw= IHJlZ3VsYXI= U3RvcmFnZQ== cmFtZXdvcms= IGdvYWw= IHRvdWNo LndpZGdldA== IGJ1aWx0 ZGVz UGFydA== KHJl IHdvcnRo aGli Z2FtZQ== OTE= MTky INCy YWNpb24= IFdoaXRl KHR5cGU= KGA= ODE= IG5hdHVyYWw= IGluag== IGNhbGN1bA== IEFwcmls Lkxpc3Q= IGFzc29jaWF0ZWQ= CVN5c3RlbQ== fn4= PVs= IHN0b3JhZ2U= IGJ5dGVz IHRyYXZlbA== IHNvdQ== IHBhc3NlZA== IT0= YXNjcmlwdA== Lm9wZW4= IGdyaWQ= IGJ1cw== IHJlY29nbg== QWI= IGhvbg== IENlbnRlcg== IHByZWM= YnVpbGQ= NzM= SFRNTA== IFNhbg== IGNvdW50cmllcw== YWxlZA== dG9rZW4= a3Q= IHF1YWw= TGFzdA== YWRvdw== IG1hbnVmYWN0 aWRhZA== amFuZ28= TmV4dA== eGY= LmE= IHBvcm5v IFBN ZXJ2ZQ== aXRpbmc= X3Ro Y2k= PU5vbmU= Z3M= IGxvZ2lu YXRpdmVz J10pOwo= xIU= IGlsbA== SUE= Y2hpbGRyZW4= RE8= IGxldmVscw== IHt7 IGxvb2tz ICIj VG9TdHJpbmc= IG5lY2Vzc2FyeQ== ICAgCg== Y2VsbA== RW50cnk= ICcj IGV4dHJlbQ== U2VsZWN0b3I= IHBsYWNlaG9sZGVy TG9hZA== IHJlbGVhc2Vk T1JF RW51bWVy IFRW U0VU aW5x UHJlc3M= IERlcGFydG1lbnQ= IHByb3BlcnRpZXM= IHJlc3BvbmQ= U2VhcmNo YWVs IHJlcXU= IEJvb2s= Lwo= KHN0 IGZpbmFuY2lhbA== aWNrZXQ= X2lucHV0 IHRocmVhdA== KGlu U3RyaXA= 7J0= w6fDo28= NzE= IGV2aWRlbmNl KSk7 IEJybw== IFtdOwo= IG91 YnVm U2NyaXB0 ZGF0 IHJ1bGU= I2ltcG9ydA== PSIv U2VyaWFs IHN0YXJ0aW5n W2luZGV4 YWU= IGNvbnRyaWI= c2Vzc2lvbg== X25ldw== dXRhYmxl b2Jlcg== ICIuLw== IGxvZ2dlcg== IHJlY2VudGx5 IHJldHVybmVk DQ0K KSkpCg== aXRpb25z IHNlZWs= IGNvbW11bmlj ICIu IHVzZXJuYW1l RUNU RFM= IG90aGVyd2lzZQ== IEdlcm1hbg== LmF3 QWRhcHRlcg== aXhlbA== IHN5c3RlbXM= IGRyb3A= ODM= IHN0cnVjdHVyZQ== ICQoIiM= ZW5jaWVz YW5uaW5n IExpbms= IFJlc3BvbnNl IHN0cmk= xbw= IERC 5pc= YW5kcm9pZA== c3VibWl0 b3Rpb24= OTI= KEA= LnRlc3Q= ODI= CgoKCgoKCgo= XTsNCg== IGRpcmVjdGx5 ICIl cmlz ZWx0YQ== QUlM KXsNCg== bWluZQ== ICAgICAgICAgICAgICAgICAgICAgICAgICA= KGs= Ym9u YXNpYw== cGl0ZQ== X19f TWF4 IGVycm9ycw== IFdoaWxl IGFyZ3VtZW50cw== IGVuc3VyZQ== UmlnaHQ= LWJhc2Vk V2Vi IC09 IGludHJvZHU= IEluc3Q= IFdhc2g= b3JkaW4= am9pbg== RGF0YWJhc2U= IGdyYWQ= IHVzdWFsbHk= SVRF UHJvcHM= Pz4K IEdv QE92ZXJyaWRl UkVG IGlw IEF1c3RyYWw= IGlzdA== Vmlld0J5SWQ= IHNlcmlvdXM= IGN1c3RvbWVy LnByb3RvdHlwZQ== b2Rv Y29y IGRvb3I= IFdJVEhPVVQ= IHBsYW50 IGJlZ2Fu IGRpc3RhbmNl KCkpLg== IGNoYW5jZQ== IG9yZA== Y2FtZQ== cHJhZ21h IHByb3RlY3Q= cmFnbWVudA== IE5vZGU= ZW5pbmc= 0Yc= IHJvdXRl IFNjaG9vbA== aGk= IG5laWdoYg== QWZ0ZXI= bGljaXQ= IGNvbnRy IHByaW1hcnk= QUE= LldyaXRlTGluZQ== dXRpbHM= IGJp UmVk LkxpbnE= Lm9iamVjdA== IGxlYWRlcnM= dW5pdGllcw== IGd1bg== b250aA== IERldg== RklMRQ== IGNvbW1lbnRz X2xlbg== YXJyb3c= YW1vdW50 UmFuZ2U= c2VydA== R3JpZFZpZXc= IHVwZGF0ZWQ= IE1v IGluZm9ybQ== b2NpZXR5 YWxh QWNjZXNz IGhhYg== IGNyZWF0 X2FyZw== IEphbnVhcnk= IERheQ== IikNCg== dXBsZQ== ZG9jdW1lbnQ= Z29yaXRo bWVudQ== IE92ZXI= YmI= LnRpdGxl X291dA== IGxlZA== dXJp ID8+PC8= Z2w= IGJhbms= YXltZW50 CXByaW50Zg== TUQ= IHNhbXBsZQ== IGhhbmRz IFZlcnNpb24= dWFyaW8= IG9mZmVycw== aXR5RW5naW5l IHNoYXBl IHNsZWVw X3BvaW50 U2V0dGluZ3M= IGFjaGll IHNvbGQ= b3Rh LmJpbmQ= QW0= IHNhZmU= U3RvcmU= IHNoYXJlZA== IHByaXY= X1ZBTA== IHNlbnM= KXs= IHJlbWVtYmVy c2hhcmVk ZWxlbWVudA== IHNob290 VmVydA== Y291dA== IGVudg== X2xhYmVs ID4K cnVu IHNjZW5l KGFycmF5 ZGV2aWNl X3RpdGxl YWdvbg== XQ0K YWJ5 IGJlY2FtZQ== Ym9vbGVhbg== IHBhcms= IENvZGU= dXBsb2Fk cmlkYXk= IFNlcHRlbWJlcg== RmU= IHNlbg== Y2luZw== Rkw= Q29s dXRz X3BhZ2U= aW5u IGltcGxpZWQ= YWxpbmc= IHlvdXJzZWxm LkNvdW50 Y29uZg== IGF1ZA== X2luaXQ= Lik= IHdyb3Rl MDAz Tkc= LkVycm9y 5Ls= LmZvcg== IGVxdWFs IFJlcXVlc3Q= IHNlcmlhbA== IGFsbG93cw== WFg= IG1pZGRsZQ== Y2hvcg== MTk1 OTQ= w7g= ZXJ2YWw= LkNvbHVtbg== cmVhZGluZw== IGVzY29ydA== IEF1Z3VzdA== IHF1aWNrbHk= IHdlYXA= IENH cm9wcmk= aG8= IGNvcA== KHN0cnVjdA== IEJpZw== IHZz IGZyZXF1 LlZhbHVl IGFjdGlvbnM= IHByb3Blcg== IGlubg== IG9iamVjdHM= IG1hdHJpeA== YXZhc2NyaXB0 IG9uZXM= Lmdyb3Vw IGdyZWVu IHBhaW50 b29scw== eWNs ZW5jb2Rl b2x0 Y29tbWVudA== LmFwaQ== RGly IHVuZQ== aXpvbnQ= LnBvc2l0aW9u IGRlc2lnbmVk X3ZhbA== YXZp aXJpbmc= dGFi IGxheWVy IHZpZXdz IHJldmU= cmFlbA== IE9O cmljcw== MTYw bnA= IGNvcmU= KCkpOw0K TWFpbg== IGV4cGVydA== CQkNCg== X2Vu IC8+ dXR0ZXI= SUFM YWlscw== IEtpbmc= Ki8KCg== IE1ldA== X2VuZA== YWRkcg== b3Jh IGly TWlu IHN1cnBy IHJlcGU= IGRpcmVjdG9yeQ== UFVU LVM= IGVsZWN0aW9u aGFwcw== LnByZQ== Y20= VmFsdWVz ICIK Y29sdW1u aXZpbA== TG9naW4= aW51ZQ== OTM= IGJlYXV0aWZ1bA== IHNlY3JldA== KGV2ZW50 IGNoYXQ= dW1z IG9yaWdpbg== IGVmZmVjdHM= IG1hbmFnZW1lbnQ= aWxsYQ== dGs= IHNldHRpbmc= IENvdXI= IG1hc3NhZ2U= CWVuZA== IGhhcHB5 IGZpbmlzaA== IGNhbWVyYQ== IFZlcg== IERlbW9jcg== IEhlcg== KFE= Y29ucw== aXRh ICcu e30= CUM= IHN0dWZm MTk0 IDoK IEFS VGFzaw== aGlkZGVu ZXJvcw== SUdO YXRpbw== IEhlYWx0aA== b2x1dGU= RW50ZXI= Jz4= IFR3aXR0ZXI= IENvdW50eQ== c2NyaWJl ID0+Cg== IGh5 Zml0 IG1pbGl0YXJ5 IHNhbGU= cmVxdWlyZWQ= bm9u Ym9vdHN0cmFw aG9sZA== cmlt LW9sZA== IERvd24= IG1lbnRpb24= Y29udGFjdA== X2dyb3Vw b2RheQ== IHRvd24= IHNvbHV0aW9u dWF0ZQ== ZWxsaW5n XS0+ b3Rlcw== ZW50YWw= b21lbg== b3NwaXRhbA== IFN1cA== X0VO IHNsb3c= U0VTU0lPTg== IGJsdWU= YWdv IGxpdmVz IF4= LnVu aW5zdA== ZW5nZQ== IGN1c3RvbWVycw== IGNhc3Q= dWRnZXQ= 77yB aWNlbnM= IGRldGVybWlu U2VsZWN0ZWQ= X3Bs dWV1ZQ== IGRhcms= Ly8KCg== c2k= dGhlcm4= IEphcGFu L3c= UFU= IEVhc3Q= b3ZpZQ== IHBhY2thZ2U= IG5vcg== IGFwaQ== Ym90 Il07Cg== X3Bvc3Q= dWxhdGU= IGNsdWI= JykpOwo= IGxvb3A= UElP aW9uZQ== c2hvdA== SW5pdGlhbA== IHBsYXllZA== cmVnaXN0ZXI= cm91Z2h0 X21heA== YWNlbWVudA== bWF0Y2g= cmFwaGljcw== QVNU IGV4aXN0aW5n IGNvbXBsZXg= REE= LkNo LmNvbW1vbg== bW8= ICcuLi8uLi8= aXRv IGFuYWx5c2lz IGRlbGl2ZXI= ICAgICAgICAgICAgICAgIAo= aWR4 w6A= b25nbw== IEVuZ2xpc2g= PCEtLQ== IGNvbXB1dGVy RU5TRQ== IHBhcw== IHJhaXM= SGFzaA== IG1vYmlsZQ== IG93bmVy RklH ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg dGhlcw== IGF0dHI= d2Q= LnRpbWU= YXdu IHRyZWF0bWVudA== IEFj LlZpZXc= aW1wbA== bW9yZQ== cGFzcw== IGhh LmZyb20= IGxlYWRpbmc= RkZGRg== KGVycm9y LnVp YXRhcg== YWRlcnM= ZGF0ZXM= IHp1 IGZsb3c= VGFyZ2V0 IGludm9sdmVk IGlv cGFyc2U= JF8= aGVzdA== LmludA== LWl0ZW0= YXN5 U3A= IHNoaWZ0 TlQ= IHRm X1RS LndlYg== Q1M= IH0p IGV5ZXM= MTI1 MTA1 X3o= Jyk7DQo= aWZvcm4= IHtA IG5pY2U= Lmxpc3Q= ICAgIA0K IGZsb29y IHJlZGlyZWN0 IFVL KFsn IHdpc2g= IGNhcHQ= bGVnYWw= IElP IHN0YWdl LlN0cmluZw== IEFmcg== aWdlbg== IFNI RGVsZXRl ZWxscw== IHNvbGlk IG1lZXRpbmc= IHdvcmtlZA== IGVkaXRvcg== aW55 0Lw= X3JlYWQ= Lklk ZWZm T2Zmc2V0 Y2hh VVNFUg== CQkgICA= aXBwZWQ= IGRpY3Q= IFJ1bg== LmhwcA== IGFuZw== eG1s aW1wbGU= IG1lZGljYWw= X3Rva2Vu Y29ubmVjdA== IGhvdXI= IGNvbnRyb2xsZXI= X21lc3NhZ2U= VUlE R3I= YW5kZWQ= X0NI IGJvb2tz IHNwZWFr YW1pbmc= IG1vdW50 UmVjb3Jk CXN0cnVjdA== LldlYg== b25kb24= IC8vCg== IGZlbHQ= LkF1dG8= aWRnZQ== X3Bvcw== UFI= IG1vZGVybg== Q29sbGVjdGlvbg== X21zZw== Q0Q= IExv IHNlY29uZHM= aWJseQ== LmVxdWFscw== IGludGVybmF0aW9uYWw= I3ByYWdtYQ== b290aA== V3JpdGVy aWF0ZQ== IGNlbGU= IEJpdA== aXZv aXZlcnk= cmQ= SEVDSw== IGNhY2hl LmNvdW50 IHJvbGw= LlJlYWQ= MTA4 UkVE IHNldHVw aXpvbnRhbA== bW9kZWxz YXJndg== IGNvbnNpZGVyZWQ= PSIuLi8= c2V0dGluZ3M= IFJlbA== IGdyb3d0aA== IG1peA== IFdhc2hpbmd0b24= IHBsdA== IElN 4bo= IHR1cm5lZA== IERhdGVUaW1l IFdlZA== KHVybA== ICIt IGxldHRlcg== QXN5bmM= ICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IE9jdG9iZXI= X2xpbmU= IGF0dGVudGlvbg== IGNvbGxlY3Q= IEhhc2g= IGltYWc= VHJlZQ== IHNpdHVhdGlvbg== ZXR0ZQ== X25v SVZF IHZvbg== LnRhcmdldA== IGtub3dsZWRnZQ== IGRyaXZl LnBvc3Q= IGJsb29k IGNpdA== cHJpbWFyeQ== IGNvbmZpZ3VyYXRpb24= dGVl IHBob3Rv aXNvZGU= VHJhY2U= IGdhdmU= IHNob3Q= IEFpcg== IG1vdGhlcg== cHJpY2U= IG1vcm5pbmc= KSl7Cg== LXg= IHRyYWRl IGRlc2M= ICYmCg== IHBhcmVudHM= QXBp 5Yg= dGVk d2Vy IOY= IHN5 IEtl UGFyc2Vy 5YU= YW5jeQ== IHBpZWNl aWZvcm5pYQ== dG9TdHJpbmc= cmFu aWRpbmc= UFRJT04= Y29tZXM= L2xpYw== LmNsaWVudA== RWw= TG9uZw== IHByb2Zlc3Npb25hbA== cnVwdA== dmE= IGNvbXBsZXRlbHk= IHByYWN0aWNl MDAy IHNlbGVjdGlvbg== UmVt aW5p IGNhbQ== UkVF IHNpdGVz cGE= QVRVUw== 0YHRgg== YXJyYW50 Kig= X0tFWQ== IEJ1dHRvbg== IEZyaWRheQ== c2VxdQ== IHJlYWRlcg== IG1lc3NhZ2Vz 6K8= IGJ1Zg== S2U= IG5vdg== SFA= TXNn YWxpZ24= YXJpbHk= ICcs X3dpdGg= IGRhcw== IGhlYXJk YXRvbWlj cmlhbA== KVs= IGRpc2U= QGVuZA== IGdvbGQ= IGZhaXI= IHNhbGVz LkJ1dHRvbg== c3RyaWN0 c2F2ZQ== IG1lYXN1cmU= ICIr ZWNhdXNl Vmlld0NvbnRyb2xsZXI= IFRhYmxl LnBhcmFt IGRlY2lkZWQ= KCgo SU5GTw== IG9wcG9ydHVuaXR5 VGU= SUNFTlNF Y2NvcmRpbmc= a2k= IFVO IGNvbnRhaW4= IG1hbmFnZXI= IHBhaW4= IEZpcmU= cm9tZQ== IHBsYW5z Rm91bmQ= bGF5 IERlY2VtYmVy IGluZmx1 w7o= cmVuY2g= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg YXppbmc= YnJpZWY= Y2FsbA== d29vZA== IGxvYWRlZA== IGdyYW5k L2Y= aW1w X1U= MTI3 U1RS 4oCi IGNyZWRpdA== LkNvbG9y b3JnZQ== UVVFU1Q= IGRpZmZlcmVuY2U= IFBD d2FyZ3M= IHB1Yg== dW5kYXk= IGZyYQ== Lm1heA== IHRyaWVk YW5uZWxz c2VuZA== IHJlcG9ydHM= IGFkdWx0 5Lo= IGNvbnNpc3Q= IFN0cmVldA== IFByb2dyYW0= U1FM TWF0cml4 b3VuY2ls LUE= CXc= IHdob3Nl IHJlbGln IFNleA== IGdpdmVz bm9uZQ== Lm1lc3NhZ2U= KEc= LmF3dA== LXJpZ2h0 IE5vdmVtYmVy ZWxsaWc= MzYw dXRpdmU= xIM= b3Zlcm4= IGVhc2lseQ== IGlkZWFz MTA0 INC9 L2Nzcw== bHlpbmc= ZWxsZQ== Q2Fu X2NvbG9y 0L7Qsg== IHBhaXI= bmd0aA== IHNwbGl0 MTQw ZHJvcA== YXJ0eQ== b25h IGNhcGl0YWw= IGhlYXI= IGV4aXN0cw== CWxvZw== ZW1v UnVu b2k= IHBhcnNlcg== IE1ldGhvZA== IGVkdWNhdGlvbg== W2s= IGxpYnJhcnk= PiI7Cg== X1VO CXN0ZA== b2RlZA== IGNhbGxz aGVyZQ== UmVs IGJyYW5k YmFja2dyb3VuZA== Z2E= X2FkZHJlc3M= X3BhcmFtcw== Q2F0ZWdvcnk= MTAz IEluZGlh X2V2ZW50 IGluZw== UmVuZGVy LmNs dW1weQ== IHBldA== RkM= IEFudA== RXh0 IGNoYXJnZQ== ZW5lZA== Z3JhZA== RU8= IGRlcGVuZA== IC4KCg== ZnJhbWU= IGRm IGh1Z2U= IFBBUlQ= ZWRz Ozs= IEFN IGJhc2lj IExldA== bGljaA== IGFybQ== IHN0YXI= IGZlZGVyYWw= V29yaw== IGNhcnJ5 IElzcmFlbA== KG9iag== PXt7 IHNhdmVk IHN5bg== IGNvbnN0YW50 VkVOVA== IHBvc2l0aXZl IGNvbmR1Y3Q= IHNraW4= IGVhcmxpZXI= IGxheW91dA== IElQ T1VS IHRpbQ== c3R5bGVzaGVldA== X2Ns IENhcmQ= Kyspewo= IHRlbXBlcg== IERhdmlk CXRyeQ== LmRhcnQ= IHdhbnRz IHBpY3R1cmU= IHZpZGVvcw== IENvbW0= aXNpb25z X01BWA== TWFwcGluZw== LWNvbnRlbnQ= IEVhcg== LWRl IHByZW0= YnJ1YXJ5 IGNvbXBvbmVudHM= IHRocm91Z2hvdXQ= IHB1bGw= IHBhZ2Vz ZW50ZQ== cmVzcG9uZA== IGdhcw== Y3JpcHRvcg== IGVkZ2U= IGJvdW5k QUNU KioqKioq IGNyZWF0aW5n IENI IG51bGxwdHI= QnI= Kyc= LmNv Pjo6 IGxlYXJuaW5n Lkxlbmd0aA== X1NI IHBhdGllbnRz QUlO IGtpZHM= IGNvbWZvcnQ= IHNob3du dWdpbnM= IEJhY2s= ZWxsYQ== X0NM IGxhdA== IGRpc3BhdGNo IGNsYXNzZXM= LmF0 LmJlZ2lu IHN1Y2Nlc3NmdWw= YmFu IG9idGFpbg== IFNs IGxhY2s= aXRlcmF0b3I= VGhyZWFk KHNpemU= IG5vbmU= Lmhhcw== X1g= c29ydA== bmFw cGV0 Ymlu NzAw IENhbmFkYQ== VGhleQ== IGRhbnM= IE1hdA== PHRk IGhhaXI= ICcnLAo= IGN1 IGxhd3M= bGV0ZWQ= cGVk IHBvdw== IGtuZXc= X0NPTQ== Xyw= IE1hZw== aWRlbnRz KHJlcQ== ICks LWNlbnRlcg== MTkw IHdpZGU= IEF1dGhvcg== c3RhbnRz IGpvYnM= IG1hdGg= ZXRpbWVz Qm9vbGVhbg== IHNjb3Bl X2lz IG1lYXM= IGtleXM= ZWxheQ== IGV4YWN0bHk= Jz0+Jw== IFBhdWw= bWFz CXByaW50 KGxlbg== ZmQ= ICk7 LkV2ZW50 cWxp aXJpdA== aWVsZHM= b21hbg== IFRvcA== IHZvdGU= IG1hc2s= IHRoZW1l LQo= IHByb3Bz IGZpbmU= IHdyaXRlcg== X29mZnNldA== Y2Fy IGFsdGVybg== IGNvcHlyaWdodA== IGRlc3Ryb3k= cHBlcg== IGdlbmVyYXRl cHBlZA== 4oCZZA== ICAgICAgCg== bWFrZQ== IFNob3c= IGJyb3dzZXI= IGZhdm9yaXRl IGNhcmVlcg== IGhhcHBlbmVk KGNoYXI= IHJlY29tbWVuZA== IGxpdGVy LmZpbHRlcg== Z3JhZGU= IMKj UGhvbmU= b21z IG5hbWVk LWxhYmVs aXBv IE90aGVy IHBhbmVs IHJvY2s= U2NhbGU= CWFzc2VydA== 0LQ= IHRydXN0 ZnJvbnQ= IGRlbW9u QXI= TmV0 IGVjb25vbWlj Zm9vdGVy IHJhY2U= KG5vZGU= IE9wdGlvbg== c3BsaXQ= IHBoeXNpY2Fs aWZlc3Q= IHJlbW92ZWQ= Lmh0dHA= KSksCg== IGxvb2tlZA== Jzs= ZGluZw== Z2VzdA== YXR1cmRheQ== L2xpY2Vuc2Vz UHJpY2U= IGRybw== IHRvd2FyZHM= IHVucw== IENM CXN0YXRpYw== IHJvd3M= IGRlZmluZQ== LnJlcGxhY2U= IGZhdGhlcg== IERlc2lnbg== YXNzaWdu bXV0 RGV2aWNl RGlk JykpCg== b21ldHJ5 YXlsb2Fk IGhpc3Rvcg== IFBhcmFt IEJvb2xlYW4= IG5hdHVyZQ== IGpz IG5hdGlvbg== aWg= IGRpc2NvdmVy c2Vt SGFuZGxl CXI= IFRlY2hu IHdhbGw= eyQ= QHByb3BlcnR5 ICIuLi8= IGV4YW0= LmRyYXc= b3BwaW5n IG5lYXJseQ== IGNvb2w= IGluZGVwZW5k UkVT IGhhbmRsZXI= IE1vbmRheQ== IHN1bg== U3R5bGVz b3VzbHk= IAk= dmVzdA== RGlzcGxheQ== KHk= YXRpY2FsbHk= IHByZWRpY3Q= eWluZw== IHNvbWV0aW1lcw== Il0K IGRyaW5r IGJ1bA== aWZpY2F0aW9ucw== Lmluc2VydA== LnJlZw== IHRlc3Rz QWxpZ25tZW50 IGFsbGVn IGF0dHJpYnV0ZQ== IE5vdGU= IG15c2VsZg== YXJ0cw== Tm93 IGludGVyZXN0aW5n bGllbnRz IHBvcHVsYXRpb24= IENhbGlmb3JuaWE= Ikk= 5bk= IGdyZWF0ZXI= dWVzZGF5 IHRob3Vz IGNvc3Rz IGxhdW5jaA== XEh0dHA= a2Vy YmFuZA== IFBsYXk= IGJhbmQ= LnNoYXBl ZXNvbWU= YXJ0aWNsZQ== LnJm IHdlcg== w6Fz ZW1iZXJz dXNy QkE= aWNhbg== ZXR0 dmFsaWRhdGU= dWx0aQ== IGltbWVkaWF0ZWx5 emVy IGZpZ3VyZQ== b2Vz ZWxsZXI= aXJjbGU= IFNpZ24= LmRi IHJhbms= Qnl0ZXM= IHByb2plY3Rz X3JlYw== VUxBUg== QVBJ IExpbmU= UG9ydA== IHBvbGw= IGdpdmluZw== aWRlbmNl LS0K IHBsb3Q= aWNpYWw= IHdhcnJhbnQ= SVRJT04= IERvdWJsZQ== IGJpbGxpb24= Z29yaXRobQ== IGVxdWlwbWVudA== REFURQ== IEAi RUU= IHBsZQ== aWF0aW9u IGhlYWRlcnM= IHByb2NlZA== LkNvbXBvbmVudE1vZGVs IE9iYW1h IHBh IEJlc3Q= aW1hdGVseQ== LmdldFN0cmluZw== Llw= bXBsb3k= IHJhdw== X2Jsb2Nr dW5kcmVk In0sCg== MTEy Lkdyb3VwTGF5b3V0 IGJyb3VnaHQ= TlNTdHJpbmc= dGhyb3c= Y3JlYXRlZA== Lk5ldw== X3ZpZXc= Q1A= ZXBz T3A= IGdyYXRpcw== ICci IGludGVydmlldw== IiIiCg== IHBhcnRpYWw= IGFyaWE= YmluZw== QXV0aG9y Qm9vaw== IFBhdA== dW1hbg== VXNlcnM= cGx1cw== MTkz IERpcmVjdA== dmVudWU= YWxwaGE= VUNDRVNT IENhbGw= ICk7DQo= aW1hdGVk IHJlbWFpbg== IGFudGk= IExvbmRvbg== IHNhZmV0eQ== UE9TRQ== b2xlcw== Y29udHJvbGxlcg== Qnl0ZQ== IENvdXJ0 IFBoaWw= IEFzc29jaQ== ZW5h 5ZA= X1NUUg== Y29pbg== cmVzaG9sZA== IGJhdGNo X0NsaWNr ZW50aWNhdGlvbg== Pic7Cg== ZW50eQ== IGJlZ2lubmluZw== IHplcm8= IENvbnZlcnQ= IHRlcnI= IHBhaWQ= IGluY3JlYXNlZA== Y2F0Y2g= LXNpemU= MTE1 YWN0aXZpdHk= ZXF1YWxz IHF1ZXVl ICIn IEludGVybmF0aW9uYWw= IGbDvHI= dXJzZGF5 IHNjaWVudA== YWxsb3c= YXhpcw== IGFwcHJvcHJp ZWRnZQ== IGlkeA== U3VjY2Vzcw== ZW50aWZpZXI= Olw= eGlz IG1heGltdW0= YXJrcw== IGJpcnRo KGluZGV4 IG1heWJl LnB5 ZmlsZXM= IGxpbWl0ZWQ= X2NoZWNr bG9vaw== cGxpZXM= IG1vdmVtZW50 J10u IGJyb2Fk IEJF IFVuaXR5RW5naW5l LmNwcA== IEV2ZXJ5 QWRtaW4= IGZhbnM= cGFyZWQ= CiAgICAK IGZvcmVpZ24= IHBhbg== IHRvdXI= IE9yZGVy IG1vdmluZw== IGF1Zg== Q2FsbA== Y2I= xZ8= dmVudG9yeQ== IFNxbA== IGZ1bGx5 Q2xpY2tMaXN0ZW5lcg== V09SRA== IGFubm91bmNlZA== KQ0KDQo= IGFncmVlZA== cmll IGVhcm4= X2xpbms= LmFycmF5 KHRleHQ= IG1hdGVyaWFscw== LHA= ZmZmZg== dmc= IMKp IHVubGVzcw== YWpheA== TE9H IHNleHVhbA== IFwi LXRpbWU= IGNvYWNo IHN1cHBvcnRlZA== IHBob3Rvcw== aWZvcm0= LkNyZWF0ZQ== KV0= cmllcg== IGRpYWxvZw== YXZlcg== aWdl KSs= X2lkeA== Ols= X21pbg== IENvbmc= IHByZXNzdXJl IHRlYW1z U2lnbg== YmVnaW4= cmlhbg== TkVTUw== TFM= IGltcHJvdmU= IFN1bmRheQ== IGRlZmluaXRpb24= aWdlcg== cm9sbGVycw== IHRoaW5raW5n VGVtcGxhdGU= LUY= IGVtZXJn cGxhdGVz IFVTQQ== LnNldFN0YXRl IEFsc28= cmV2 IGVuYWJsZQ== IENP UEVDVA== IGNvbmNlcHQ= KS0= IOKAog== IHNldHM= IG1lYW5pbmc= ZW1vbg== IENvbnM= Y21w ZWRlcg== YW5uZWQ= aWNlbnNlZA== IFN1cGVy IGRhaWx5 IG11bHRp X3U= IGNoYWxsZW5n X21vZGU= IFByb21pc2U= IHN0cmljdA== am8= aW50b24= KGxpc3Q= T25seQ== Pns= IHZlaGljbGU= 7ZU= IFBsYXllcg== MTA2 IERlbA== IHBvb2w= LnVybA== bmVzZGF5 KCk7DQoNCg== OTAw ICIpOwo= TG9jYWw= LiIpOwo= IG9yZ2FuaXphdGlvbg== cmVuZGVy IEFwcGxpY2F0aW9u IHN1bW1lcg== ZXhwZWN0ZWQ= TkE= IHJhcA== X29iag== IHN1cmZhY2U= IFBVUg== IH0sCgo= IHZhcmlhYmxlcw== KG1lc3NhZ2U= IG9waW4= LmJhY2s= 0LDQvQ== IHdvcmtlcnM= dm0= Q28= dWdodGVy IG1hc3Rlcg== ICIiLA== IHN0b3JpZXM= LlVzZXI= IGNlbGVicg== aW5lc2U= QlM= IENvbW1hbmQ= YXNoYm9hcmQ= IG9n a2c= LmltYWdl LnN0eWxl IHN0ZXBz IEJlbg== KGFyZ3M= NDA0 IFBlcnNvbg== LHk= IG9mZmljaWFscw== fAo= IHNraWxscw== dmM= IGJ1aWxkZXI= IGdhcg== QWNjb3VudA== IEF1dGg= 55Q= J10pCg== IEFU bm4= LkludA== U1NFUlQ= IGVmZmVjdGl2ZQ== TEVURQ== IHRvb2xz QVJE IGRpZ2l0YWw= MTkx RG91Ymxl IEZpbmQ= UkM= IGlubGluZQ== L3I= QVJBTQ== QVNL IGludGVudA== YWlnaHQ= X2FkZHI= IHJlcXVlc3Rz LmZpcnN0 IGRlYnVn IHNwZW50 KCkpKTsK xZs= IHByaW5jaXA= TG9nZ2Vy Y2x1ZGVz LnVzZQ== IHN1cnY= bWVkaWE= IEZlYnJ1YXJ5 IE1hYw== IG1pc3Npbmc= IHdpZmU= IHRhbGtpbmc= IE1ha2U= IGNhcnQ= IGxvY2F0ZWQ= RW5j LWE= Y2hyb24= IGNhcmRz IGd1eQ== IHBlcnM= IFllcw== YXRldmVy IEFuZw== b2xhcg== IEV2ZW4= IGFjY3Vy IFBvd2Vy IEdvbGQ= Y2xlYXI= UHJvY2Vzcw== IHJlY29yZHM= IGtpbGxlZA== LmNsZWFy IFdBUlJBTlRJRVM= IHB1cnBvc2U= cGFuZWw= SkVDVA== w61h IGV4ZXJj V1M= L0w= LmV4cG9ydHM= IF9fXw== IHNpbg== U2VydmxldA== IGTDqQ== LmRlbGV0ZQ== cm9rZQ== U2w= dWdo ZWFycw== IHBvaW50ZXI= IGhvcA== YWxsZXJ5 IG9icw== Y292ZXJ5 CWNoYXI= CQkJCQkJCQkJCQ== CWRlZg== b2NpdHk= aXRjaGVu dWxhdGlvbnM= IEZJVA== ICku c3RyYWludHM= dmVudGlvbg== IHJlcXVpcmVz IE9wZXI= TUU= T1VOVA== YWxsZXQ= IG5vcm0= SVJF ZXhhcw== IHByb2dyYW1z IHdlYWs= Jy4k dWluZw== CSAgICAgICA= IG1pbA== IGZpcm0= aW5pdGVseQ== X1ZBTFVF YXBzZQ== YXRpc2Y= IGRlbWFuZA== X21vZA== IGRlc2NyaWJlZA== IHBsYWNlcw== VklE IGFsb25l IGV4cG9ydA== IHZlYw== IE1heA== IGFjdGl2aXRpZXM= aWN0dXJlcw== Z2VuZXI= IG1h gqw= IGV4cHJlc3Npb24= Q2FsbGJhY2s= X2NvbnRlbnQ= IE1vc3Q= IHRlc3Rpbmc= RUM= Q0hBTlQ= IGFkanVzdA== LlRocmVhZGluZw== KGN0eA== IGFncmVl aWdoZXN0 IHVp IExhdw== Llk= Pjw/ IHBvZA== LWxn 4oCdCgo= IGRlc2NyaWJl IEV1cm9wZWFu LXNo IFBVUlBPU0U= T1JZ IGNvbnZlcnM= IElsbHVtaW5hdGU= IEF2 KGNo PyI= Y2hlbg== aW1h RG9jdW1lbnQ= IG9wZXJhdGlvbnM= d2lu CWZ1bmN0aW9u LkltYWdl IHNjZW4= L2g= IFND IGV4cGxv OiU= LyoqDQo= TkFNRQ== 5og= KHZhcg== IGRpcmVjdG9y T05H IHlpZWxk IGZlZXQ= IFNlYXJjaA== IEls IHJlc3RhdXI= ZHVj IGludGVnZXI= MTA3 ICcnOwo= IGhpZ2hseQ== Y2hlY2tlZA== IFBBUlRJQw== RVJDSEFOVA== 77yJ IG9wdGlt UXVldWU= IExJ aXRhdGlvbg== IHRyYW5zcG9ydA== aXNzaW9u ZmlsbA== dXNpb24= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg CWJvb2w= LXRo dXB0 IGVzc2VudGlhbA== YW50ZWQ= IGJlbmVmaXRz CVM= JzsNCg== aWtp IGdpcmxz aWNlZA== YnVmZmVy XSs= IHNvY2tldA== IHByaWNlcw== IEZyZQ== IHNhdA== IHdvb2Q= TWVudUl0ZW0= QVJH IEFkbWlu T1dO ZGs= IHJlc2V0 IGZvcm1z INC4 5pY= IFR1ZXNkYXk= MTA5 IEluaXRpYWxpemVk X3RyYWlu b3Jhcnk= YXRlZ29y IGR0 VG90YWw= Y29uc3RydWN0 aWxpZXM= IGd1eXM= 0LXRgA== IGluc3RydWN0aW9u MDEw eWxlZA== IGludGVybmV0 ZXRhZGF0YQ== YWR5 ZmFjZXM= amVjdGlvbg== IEphY2s= IHJlY3Q= Wy0= IExlZw== IGRldmljZXM= T0M= ICoNCg== b3JhdGlvbg== ZXJ0YWlu IGd1YXJk b3N0cmVhbQ== IGVudW0= LmxheW91dA== ICI7Cg== dm9rZQ== IE9r SG9tZQ== KHRy RVRI IGRlbGF5 IHB1cmNoYXNl ZGM= IGFyZW4= X29uY2U= CQkJCQo= cm9y ZHJhdw== LnJ1bg== KG1vZGVs VGltZW91dA== bGlr IEFyZw== LmVu IGZpc2g= Y3B5 X2Zl RVJDSEFOVEFCSUxJVFk= KFg= X291dHB1dA== Pz8= IGpv YW5kYXJk IGRvbGw= ZXJyb3Jz X2Jhc2U= IFBBUlRJQ1VMQVI= IGxlYWRlcg== IGNvbXBhcg== IGRvdWI= IFZpcw== U3RhY2tUcmFjZQ== LUM= IFN0dWQ= c3RpdHV0ZQ== TW9yZQ== IERlc2NyaXB0aW9u V0FSRQ== YWRz INC6 YmluZA== PXNlbGY= ZW1wbG95 W24= LmFsbA== LUI= JiY= YWxt IGN1bHR1cmU= aG91c2U= IHN1ZmZlcg== ICcl IHN0cmFpZ2h0 IFN0YXI= dWRv IGRlZA== IENPTQ== IGNvbmZpcm0= IEdvb2Q= LnNj X19fX19fX19fX19fX19fXw== RFI= Q29uZmlndXJhdGlvbg== RGF0ZVRpbWU= IGFkdmVydA== IGNvdWxkbg== YXN5bmM= c3RhY2s= JykNCg== S2l0 IGhvdXM= IG1lY2hhbg== cmF0ZQ== MjA0 IGF1ZGlv CWNvdXQ= Y29yZXM= IHNwb3Q= IGluY3JlYXNpbmc= ICMj KSkp cG9pbnRz IGNvbXBhcmVk bGln IGJlaGF2aW9y IEJZ IEF0dA== Y3JhZnQ= aGVhZGVycw== ZXRl ZW5kcmVnaW9u IGRldGFpbA== VUxF IENvbW1vbg== CXByb3RlY3RlZA== c3Rvbg== IEZJVE5FU1M= IGZyZXNo Ij4KCg== LmV4YW1wbGU= YmVyZw== IG1vdmVk CWU= IFNhdHVyZGF5 IHBheWxvYWQ= xIc= KToKCg== IGJleQ== dXJlcg== PHNjcmlwdA== IHN5bWJvbA== IGFzc3Vt IHB1bA== RWZmZWN0 IGh1bmRyZWQ= VG9vbA== YWtlZA== Y29ubmVjdGlvbg== IHZvaWNl IHBk IHRyYW5zYWN0aW9u IGxpbmtz RXJy IEluZGlhbg== VEM= YXRhbG9n bmk= c2lnbg== PDwi amk= eWE= IGRlbW9uc3Ry dWxhdGVk LlN0 IGluc3RpdA== IGJvb3N0 IGNlbGxz b2xpYw== LlBybw== Ojwv RXZlbnRMaXN0ZW5lcg== aWZ5aW5n IERp b3Jyb3c= LmV4ZWN1dGU= IGNvbGxlZ2U= WW91cg== IGxhcmdlc3Q= LmRpcw== IHF1aQ== IGluZGl2aWR1YWxz X2J1ZmZlcg== IG5n U0E= IENvbnRyb2w= IHNpbmc= IHN1aXQ= ICAgIAk= U0c= IGp1bXA= IHNtYXJ0 b21h IEV4cA== ICct IGFzc2lzdA== IHN1Y2Nlc3NmdWxseQ== c3lz IENyZQ== X3JlZg== IFRodXJzZGF5 IGJ1cg== INC0 IGJleW9uZA== IG5vZGVz RGV0YWlscw== aW5jdA== IEphbWVz IGFmZmVjdA== ZXhjZXB0aW9u IHR5cGVvZg== KA0K LXNl IGZldGNo YCw= IGNydXNoZXI= fS4= IEJP U2hvdw== IHJhdGVz IGJvbg== LWljb24= IE1lZGlh UkVTUw== IFZhbGlk 0L7Quw== IGZ1Y2s= YWNrcw== IHN0dWRpZXM= TWU= IG93bmVycw== fWVsc2U= IGdyb3dpbmc= VmFyaWFibGU= IEJlbA== LnJhbmRvbQ== dmVtZW50 b255bQ== KEY= IEZBTFNF IHRvcmNo KHJvdw== aWdv c3RydWN0dXJl MTIx IGNlcnRhaW5seQ== RGVw IEdyZWVu cXVlc3Rpb24= IGFkZGluZw== IERldmVsb3A= X2RlZg== IG1hY2g= PSU= CQkg Y29uZHM= UHJvamVjdA== IHJlamVjdA== IM4= IHBvb3I= IGF3YXJl MTE0 IEJ1aWxk IEJyaXRpc2g= IE5F IG51bWVy cmVlcw== Y2xhaW0= IG1vY2s= IG9t IHNjcmU= T0xE LnBs ZWxlcg== IGNvcnJlc3BvbmQ= X0hF IGJpbmFyeQ== MTE2 X29yZGVy IFNRTA== IGFkdmFudA== IHByZXY= Lls= LmFzc2VydEVxdWFs cGxpZXI= YXJw IGNsb3NlZA== IGVuY291cg== IFFTdHJpbmc= YXVk IGRldmVsb3BlZA== IHBlcm1pc3Npb24= LmRlYnVn b3BlcmF0b3I= ICcK IHN5bQ== YXRpdmVseQ== w6ll LWNvbG9y IEdFVA== a3k= IGFsdGhvdWdo X3JlcXVlc3Q= X2VsZW1lbnQ= Li4uLi4uLi4uLi4uLi4uLg== X0RBVEE= IGFtYXppbmc= IHNi IERlZmF1bHQ= RXZlbnRz IGZhaWx1cmU= YWNsZQ== UHJvcGVydGllcw== IGRyZWFt IGRpc3Ry IGF1 IGdlbmVyYXRlZA== 5pU= IFRlYW0= VVNF IGluY29tZQ== IGV5ZQ== X25vdA== Il0s X2Zvcm0= U3VwcG9ydA== b3JkZXJz LlByaW50 dmlsbGU= IFdlZG5lc2RheQ== b2x2ZXI= IG9wcG9z aXNhdGlvbg== b2xh Q2xvc2U= PHA= X3dpZHRo SW52YWxpZA== eGI= IHN0cnVnZw== X2FjdGlvbg== IHR4dA== IFBhdGg= YWxhcg== IE1FUkNIQU5UQUJJTElUWQ== c2VydmljZQ== IE1pY2hhZWw= YWJsZVZpZXc= RGVidWc= b2tlcw== U2hl IGd1ZXNz IEphdmE= X1BBVEg= IHBhcnRpY3VsYXJseQ== IElJ IGRvbWFpbg== 5bm0 IHJlZHVjZQ== LWxlZnQ= cmVhbA== IGFwcGVhcnM= IGNvbW8= IFVuaXQ= IEdvdmVybg== YWxp YWxsZWw= IEpldw== X0k= IGNvcw== LmNvbG9y IEdsb2JhbA== IHRlbGU= YmVu X3RyYW5z IHJlYXNvbnM= IGVtYg== ZW5zaXR5 bGluZXM= b21pbg== U2NyZWVu 0LDRgg== cGVjdHM= Y2xpcA== Zm9v cmVudA== IGFm IGRhbmdlcg== aWxpbmc= TmFtZXM= T3Vy IGRpc3RyaWJ1dGlvbg== V2hpbGU= U0w= V3JpdGU= IGdvdG8= IGNvbG9ycw== IHBvd2VyZnVs a2lu IGRlcHRo ZXJjaWFs IENvbmdyZXNz IE1hcmtldA== RGI= dW5kZXI= IExhc3Q= w58= Z3JlZw== IHBvc3Rz X1VSTA== b3Rvcw== RG9u IG1pY3Jv IGFycmVzdA== 0L8= IChA IEhvdA== IEluZGV4 OyY= IyE= IE5vcg== IENhcA== LSg= IGludGVyZXN0ZWQ= cGVhcg== IHJlbnQ= IGFsYnVt b2xpY3k= Lmxhbmc= LnRyYW5z LmZvcm1hdA== IHsNCg0K cGhlcmU= IGF4aXM= IEJ1c2luZXNz ZXJzaXN0ZW5jZQ== dXJy IG1pbmltdW0= ZW5kb3I= IFNE MTEz IEludGVybmV0 5aQ= RXhw aXZlcnNl TU0= IG9idmlvdXM= IGJhc2lz IHNjaWVuY2U= IGJ1ZGdldA== aXphdGlvbnM= UEE= IGZsYWdz cHJldA== TE9DSw== IHZhcmlldHk= IHRydXRo ZHQ= IGdvbmU= IGJhdHRsZQ== PHN0ZA== IFNpbA== cmY= dWRh IGVyb3Q= IENhbQ== IHN0YXRpb24= ICc8Lw== Y2hlbWU= IFN1bg== IGZpbmlzaGVk IHNob3A= IEtvcmU= IGVpZ2h0 X1JFRw== TkQ= Piw= Ij48Pw== KG51bQ== CWlubGluZQ== VHJhbnNhY3Rpb24= Lk9u IG1haWw= cmV5 cmVzdWx0cw== IG5hdg== SU1JVA== X2lkcw== TWFrZQ== 5Yo= TW9kYWw= IExPRw== IFN1cg== IGluc3RhbmNlb2Y= IG92ZXJhbGw= IEluZm9ybWF0aW9u IGNvbnN0cnVjdGlvbg== X0ZJTEU= YnV0 IG1lZGlj IGR1cmF0aW9u aXRuZXNz YWdlbnQ= QVY= IHNldmVu b2xm IH19Cg== Il0sCg== MTcw MTIy IGNhbGxpbmc= IGFucw== dGhyb3dz b3Jpem9udGFs IHVzZVN0YXRl LmZs IFN0YXR1cw== IE9ubGluZQ== UlI= IFJpY2g= IEhpbGw= IGJyYWlu IGZvbGxvd2Vk MjQw ZW1pYw== IHNsaWdodA== IGluc3VyYW5jZQ== LkFycmF5 IGFic3RyYWN0 IFN1bQ== cmVkaXJlY3Q= b3duZXI= KG1zZw== IENsaW50b24= Tm9u CWV4 IHZvbHVtZQ== IEV2ZW50QXJncw== LUw= IERpbQ== IE1hcnQ= IGN1cnNvcg== IGltcGxlbWVudGF0aW9u dXJyZWQ= IGxhcmdlcg== KTsKCgo= Jys= LnRyYW5zZm9ybQ== IHVwbG9hZA== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== RHJhdw== bmVs CWZsb2F0 cXJ0 IE5ldHdvcms= IHRpdA== QXhpcw== LmFuZHJvaWQ= IGNvbXBsZXRlZA== IG11cg== IGNvbHVtbnM= eGM= IHN1cHBseQ== aW1pbmFs IHNwcg== PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PQ== IHVuaXRz KHU= bWk= cmVwbGFjZQ== W2tleQ== 4Lk= YW50aWM= IHBheW1lbnQ= LEI= IEFwcGxl Z2lu UmVxdWlyZWQ= Iys= bGFuZHM= IHNxdQ== IGZhY3Rvcg== ZGVj IHN0cmVuZ3Ro IGJveQ== IGJhbGFuY2U= IHNvdXJjZXM= c2NyZWVu LXRvcA== IEFtYXpvbg== IGhpZGRlbg== 0LXRgg== X2NsaWVudA== IGVhdA== LmRpc3BsYXk= IMK7 IHRyaWdnZXI= YW5hZ2Vy IHRybw== IGNsYWltcw== Zm9yZA== IENvbXBhbnk= IGdpZnQ= LDo= X2FwcA== aGFuZGxl IHByb2R1Y2U= L2xpYg== NTEy IC0q CXNldA== J107 YXJj YW5kZXI= IEVuZ2luZQ== IGF0dHJpYnV0ZXM= dGFzaw== PD0= KE4= IHdhcm0= d2hpY2g= IEZvcmU= YWdub3N0 bXlz IHRhbA== IFNhbA== Z2k= IFByaW50 IFRSVUU= INC+ LlVJ IGZsYXNo cm9wZXJ0eQ== LmxvY2F0aW9u IE1pbGw= Ymk= Y29udHI= LnJlcXVlc3Q= IFNhbQ== IG5lZ2F0aXZl a2l0 IHNldHQ= LnByaW50U3RhY2tUcmFjZQ== YWJl CWk= IGJ1cm4= IHNvY2lldHk= Q2FjaGU= IFNlY3VyaXR5 Lm1vZGVscw== IFdBUlJBTlRZ X3Vw Y2VpdmU= IGNsaWVudHM= LlRy IHByb3ZpZGluZw== IHJvdXQ= bWF0ZXJpYWw= IHx8Cg== IFNlcg== IE9mZmljZQ== RlRXQVJF ICck IGZvYw== IGV4Y2VsbA== IGNhdA== bm9ybWFs IGRldGVybWluZQ== CXVpbnQ= UGFuZQ== IGVtcGxveWVlcw== IFRleGFz IHRyYWZm IFJlcG9ydA== YW50YQ== IEJveA== IGRqYW5nbw== IHBhcnRuZXI= RUI= TElORQ== IGZlZWxpbmc= IGNpdmls KGZsb2F0 U3Fs IHdvdWxkbg== LmluaXQ= LmxlZnQ= LXY= X2xldmVs J30= QUY= IGxvYWRpbmc= IE9ubHk= IGNvb2tpZXM= IEds Q08= IHN0cmF0ZWd5 KCcuLw== IHNoaXA= cG9zZXM= IHNpZ25hbA== IGFscGhh LnBvcA== UmFkaXVz IHJlcGxhY2U= X0RJUg== Y291bnRlcg== YnNlcnZhYmxl ZWxh V2VpZ2h0 aGFzaA== Ym9zZQ== Zng= IEVtYWls IHJlZmVy bG9jYWxob3N0 X1JP aXF1ZXM= U3RlcA== IGFoZWFk KFZpZXc= IFNlcnZpY2Vz IEpzb24= ZXNzb3I= IHB1bg== IGFwcHJvcHJpYXRl YWtlcnM= b3Nlbg== cG9zaW5n IGFnZW50 ZmM= IHRyYW5zZmVy IGludmFsaWQ= IFJlc2VhcmNo VmVydGV4 IGdheQ== IGpvdXJuYWw= W3g= ICIiLAo= IFdlbGw= LlRhc2tz U3BlYw== IG9s IHNwZW5k IEF1c3RyYWxpYQ== TWF0Y2g= Lmp1bml0 ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IE1BWA== aXphYmxl Y2x1c2l2ZQ== X3ZhbGlk IHF1YXJ0ZXI= eWFu MDA1 IEVkaXQ= YXJkZW4= PW5ldw== IGZyYWc= Qml0 emk= YWluZQ== dWRk Lk9iamVjdA== ZGVidWc= IGNhc2g= X0lN IGVlbg== IGNvbW1lcmNpYWw= IFZpZGVv bG9hZGVy IGZpeGVk IGFwcGxpY2F0aW9ucw== IF8s IFJ1c3NpYQ== aXRlY3Q= Xyg= IEJsb2Nr IHNhbg== IFRvbQ== IHBlcmhhcHM= IHNpZw== bGV2YW50 IGNvcnBvcg== YXRhc2V0 cm9uaWM= eGU= IGV0aA== U29tZQ== cG9w X09L IHRlbmQ= LlJlcw== X2FuZA== IHJldmlld3M= IHdpbGQ= MTE3 IGRlZ3JlZQ== Lk8= Lm9iamVjdHM= X2FyZ3M= bmls IGRpc2FibGVk UGFyZW50 IG5vdGVz ICIiCg== KHN0YXRl aXN0cmljdA== IGxvZ2dpbmc= LklP IE1hbA== RE0= IHhtbA== IFJvYmVydA== ZWxlbg== bGF5b3V0 Zm9s J10pKQ== LGI= IEplcg== ZmlsZW5hbWU= IGZhbg== IEN1c3RvbQ== PSIi IERpZQ== QnVuZGxl LnV0aWxz IHRyaXA= TUI= IHNvZnQ= X01PREU= IGFwcGxpY2FibGU= IHVwcGVy RVJWRVI= X2Fs X0xPRw== SGVyZQ== d3A= IFNlcnZlcg== IENsaWVudA== IGNoZW0= U2Nyb2xs IGhpZ2hlc3Q= IFNlbGVjdA== ICJA IFdoeQ== U2Vj aGVlbA== T3BlcmF0aW9u IGNvbm5lY3RlZA== aXJtZWQ= IGNpdGl6 IENoZQ== IGZvcmNlcw== IHd3dw== Um9vdA== QU5DRQ== TWFueQ== aWNpcA== cmdhbg== MjIw IFRvcg== IFByZXNz IE1vcg== LWxpbmU= dWxlZA== Plw= IHRodXM= IFJlZ2lzdGVy aG9s IENoaW5lc2U= IHBvc3RlZA== IG1hZ24= YWJpbGl0aWVz IGRpc2Vhc2U= IHJlbWFpbnM= IFByb2Y= LWZvcm0= IGNpbg== b3JnYW4= aWNhdGU= IHN0cmVzcw== XSo= IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= X2NvbnRleHQ= b3JyeQ== IGRpZWQ= bWF0 IHN0YXJ0cw== Lk1lc3NhZ2U= IHJ1bnM= IGd1aWRl IHdhcnJhbnR5 ZW50aWFscw== ZGljdA== IFNpemU= dWxlcg== IHJlc3BvbnNpYmxl X1NFVA== IGNvbnRhaW5pbmc= IFByaWNl fHw= MzUw RlM= IGVtcA== X2J1dHRvbg== KHVpbnQ= IHN1ZmY= cHRo IGRlZmluaXRlbHk= cHV0ZQ== IG1hcmtldGluZw== IFdI IFNpZQ== Kz0= T0xPUg== IGNvbnN1bHQ= IHNpZ25lZA== IHNlcXVlbmNl bGVl IHJlcXVpcmVtZW50cw== aHk= RXhwcmVzcw== TVQ= c2V5 IHVsdA== 5a4= ZWxsaWdlbmNl IGFuYWx5 IGRyZXNz ZW5naW5l IEdyZWF0 IEFuZHJvaWQ= IEFsZXg= bW9kZQ== RGljdGlvbmFyeQ== LkRhdGU= 5L0= VklDRQ== IGZhbWlsaWVz IFJ1c3NpYW4= IFRpbWVz LmNhbGw= JCg= UHJvZmlsZQ== IGZvbGRlcg== Y2hlcw== IGxlZ2lz X3Jvdw== dW5lcw== 2YQ= IH0pLg== QXNzZXJ0 YWdlbg== IEhhbmQ= SXRlcg== IGJpZ2dlc3Q= b3JlYWNo IHBvbGlj IHBlcm1pc3Npb25z IHNob3dlZA== IEVsZW1lbnQ= IHRvcGlj 4oCU4oCU cm9hZA== IEJhbms= cmVjb3Jk IHBhcnRuZXJz IFJlZg== ZXNzaW9ucw== IGFzc2Vzcw== VVNU IFBhcnR5 cHJvZHU= TEM= IHVs LmZvcm0= aGlkZQ== Y29weQ== VVRG IFNPRlRXQVJF DQoNCg0K IExpbg== dW5h dWdhcg== IGFkbWluaXN0cmF0aW9u IG9wZW5pbmc= IHNjYW4= IGNvbnRpbnVlZA== Y29tcG9uZW50 LnNw IGhhcHBlbnM= dW1teQ== IFBS LkZpbGU= IERvd25sb2Fk TG9hZGluZw== ZGk= IHdhaXRpbmc= X0FERA== VGFi LnF1ZXJ5U2VsZWN0b3I= IGVjb25vbXk= IEZyZW5jaA== dHh0 IGZhbnQ= XzsK SG9sZGVy U0g= MDA0 IG51bXB5 IHN0cmVldA== IG1hbGU= XE1vZGVs YW5naW5n MzMz IEJpbGw= IHByZXZpb3VzbHk= Qkk= IFNlY3JldA== IG1pc3Q= IEZpZWxk dXBz IFByb2Nlc3M= IGtlcHQ= IE9U IHRyYWRpdGlvbmFs Lmk= YW1pbg== IGhlbHBz QW55 b3JpZ2lu aWx0ZXJz anU= ZGVzYw== IEFjY291bnQ= ICkNCg== a3RvcA== b2xseQ== IGZz IOo= IHV0 IGNlbnRyYWw= KHRlc3Q= LkFu IHNhdGlzZg== R1I= IEZ1bGw= IGhlYXQ= aWJlcg== IG9udG8= bW9z U2NoZW1h IGZhY3Rvcnk= Ii4k YXdz U3RhdGVtZW50 KHRhcmdldA== CW5ldw== LmJl IGd1ZXN0 IG1hbA== QVJZ IHJlYWNoZWQ= IG1vdXNl IGNoYWxsZW5nZQ== CWRvdWJsZQ== IFRlbQ== IHRlcnJvcg== IGV4dHJhY3Q= X1RP IHNlcGFyYXRl IG1pcg== aGVscA== IGNhcGFjaXR5 IFByb3BlcnR5 a2Fu X2NyZWF0ZQ== IExpZ2h0 LnBhcmVudA== IHVuZGVyc3RhbmRpbmc= IGVhc2llcg== IHw9 IGVuaA== IGZhdA== IHByb3Rlc3Q= YW1t X0FU LW9m aWxz IE9o IHBzeWNo ICQu aW5kcw== IHJlbGF0aXZl c2hvcA== c2hvcnQ= IFNhbmQ= MjEw dWVzdGlvbg== IGZlYXI= LwoK LmNvbnRleHQ= IHNjaG9vbHM= IHNlcnZl em9uZQ== X2Ri IG1ham9yaXR5 ZXhhbXBsZQ== IGxhbmc= CSAg UmVnaXN0ZXI= ZW5kbw== IHByb2Nlc3Npbmc= X3RlbXBsYXRl LXVzZXI= IGVn Q09N IEJsdWU= aXJv IHJlbW90ZQ== IElU IyEv IHJlZGlzdHJpYg== MTI0 cmF6 IFNpbmNl IFR1cg== MTM1 QmFja2dyb3VuZA== PT09 IHJlZmxlY3Q= IHByb3M= Y21k IHdob20= Q29tcGF0 IEFyZQ== SWRlbnRpZmllcg== IFRob20= X3BvcnQ= Z3U= IG1vbml0b3I= cm0= IHBhdGllbnQ= dmVydGVy IGdhaW4= LXVp SW5zdA== IGRpZXM= MTE4 QXJlYQ== X2ZpbHRlcg== IGdyYXQ= IHJlYWxpdHk= b3JkaW5hdGU= b2x2ZWQ= Q29udGFjdA== IGNvbXBsaWFuY2U= X29y IFZhcg== ZGw= IGFwcGVuZA== R0VS KG1heA== LnJlbmRlcg== IGR5bmFtaWM= b3JkaW5hdGVz X29wdGlvbnM= X2NvbHVtbg== IGJhdHRlcg== c3BhY2U= TGE= IFNvdXJjZQ== L2Jpbg== IGRvcw== IEJvYXJk IFRocmVhZA== IEFM KGNvbmZpZw== MTQ0 IE1lcg== IG1pbGVz X2hlYWRlcg== RVRIT0Q= aXp6 IGJlbmVmaXQ= IGludGVncg== KGN1cnJlbnQ= dWxv LmRlZmF1bHQ= IERpdg== IHRvbg== b3Ro ZXJ2YXRpb24= ZWRvbQ== IGJhYnk= Y2VpdmVk LnRvcA== cmlvcml0eQ== IExvY2Fs cmlhZ2U= IGF0dGFja3M= IGhvc3BpdGFs MTY4 IGZlbWFsZQ== IExvZ2lu IEZsb3I= IGNoYWlu YXNoaW9u VGV4dHVyZQ== U2F2ZQ== IGZhcm0= LmNvbnRhaW5z LlRlc3Q= IGtub3dz IGdlbmVyYWxseQ== aXBlbGluZQ== IG1lYW50 ZW5jaWE= IG5pY2h0 IGNvbnRlbnRz UE0= Y2hlZHVsZQ== KGxpbmU= Q0c= am9i IFJlYWw= dWVy ZmlybQ== INg= ZXRybw== ImAK IHNwZWVjaA== IHRocg== Zm9yZWFjaA== IHdhcm4= CWw= IGhlYXZ5 PGxp TmU= IGludmVzdGlnYXRpb24= TWF0aA== LXRpdGxl IGNodXJjaA== IGRlc3BpdGU= Y2hhaW4= IHdoYXRldmVy YXJpYW4= Zm4= IG1ldGE= fSkKCg== VUZG IHJlZ2FyZGluZw== X1NVQ0NFU1M= bWVz IEludGVudA== IHJlc29sdmU= cG9zcw== aXJh Zm9yY2U= b2ljZQ== w6I= IHBt IHVwZGF0ZXM= QXJy INE= dGVzdGluZw== IHRvd2FyZA== bnRheA== 64s= IGxpc3Rlbg== IGdvYWxz SW5zdGFuY2VTdGF0ZQ== RHI= IHJhcmU= IHRyYWls S2V5cw== Q2Fs Q2Fy IFBlb3BsZQ== CWxvY2Fs Y2xhc3Nlcw== UmVmZXJlbmNl LmZvckVhY2g= ZW1i YWN0aXY= IHByaW0= cmVkaWN0 IHJhZA== 5pWw LkJhY2s= IHNwcmVhZA== IGNsb2Nr IHZpcg== ZWRpdG9y IGVmZm9ydHM= IGJyYW5jaA== IGluZHVzdA== IG1vdG9y IGFtYg== IGRhdGV0aW1l IHJlbmNvbnQ= IENocmlzdGlhbg== IEFtZXJpY2Fucw== ZnVsbA== IGZtdA== Lm1haW4= IGNhdXNlZA== X3VwZGF0ZQ== IENvbnRlbnQ= QVRDSA== IGJhdGg= IEVhY2g= IHJhZGlv YWNobWVudA== dXp6 U3VibWl0 IHJlc3RyaWN0 YWJpbg== IExvYWQ= IGV4dGVuc2lvbg== IGVzc2F5 IGhhdA== YXZpb3Vy dG9CZQ== Ijpb IG9mZmVyZWQ= IHZpbGw= KGRvdWJsZQ== MTE5 5pel YmM= X2ZyZWU= IE1pc3M= IEJlcg== IOg= IExpa2U= IGhlbHBlZA== LmdldE5hbWU= X0FM IHNwaXJpdA== IEFwYWNoZQ== d3M= IHRoZXJlZm9yZQ== KHBhcmFtcw== X2ltZw== IHBlYWNl IGluY29y IEVYUEVDVA== IG1pbm9y aXBlcw== CWRhdGE= c2VsZWN0b3I= Y2l0eQ== dHJpZQ== LmJhc2U= X2ZyYW1l IG9wZW5lZA== L2pzb24= TFk= bnU= LkRl dGY= bWFyZ2lu LlBhcnNl IHBp IGVx YmQ= RmllbGRz IFRyZWU= IGJhbg== aXN0YW4= CiAgICAgICAgCg== CWds IHByb2R1Y2Vk c3lzdGVt TWFyaw== X2hhc2g= IGJn IGNvbnN0aXQ= IExlYWd1ZQ== IG1pc3Npb24= X2Zvcm1hdA== KFsK Y2x1c2lvbg== ISI= 0Lc= YnJlYWs= CXN3aXRjaA== IHRoZXI= VHJhbnNmb3Jt IGZvb3RiYWxs LWxpbms= cm91dGU= LmF1dGg= IGJhZw== b3ZlcnM= IGVuYWJsZWQ= IHJhYw== KEk= Q1I= YW5jaW5n IG1hbmFnZWQ= X3E= TkdUSA== IG1hYw== IEF1dG8= YW1lbnRl ICcnLA== LkFwcGVuZA== IHBpbg== Lml0ZW0= YWNraW5n IG9jY2Fz cGVyc29u IHRp LlJlZw== IGhhdmVu IGdsYXNz ICI8Lw== IFNpbXBsZQ== UHJpbnQ= IHN1cnJvdW5k Tk8= 44CCCg== ICAgICAgICANCg== IE1hbnk= ICJf IHdlZWtlbmQ= IHNvbWV3 LnBhcmFtcw== c21hbGw= QVRFRA== IHBsdWdpbg== ZmllbGRz IEluaXRpYWxpemU= b29u YXRpbGU= eWU= IHZvdXM= TEFH IG9sZGVy IGdhbQ== IGV4dHJlbWVseQ== IGhldA== ZW51bQ== IFNFVA== eGZm IHRpbWVy L2luZGV4 IGNyaXRpY2Fs Um93cw== X2FyZ3VtZW50 IGV4ZWN1dGU= IHNob3dpbmc= LnhtbA== LWxpc3Q= Um9sZQ== dHlwZW5hbWU= X21ldGhvZA== dGhhdA== Y2hlcg== IOKG WFQ= IHRob3VzYW5kcw== CW4= IHJlc3A= X3ByaWNl b2x1dA== QWc= IFR3bw== IGJlY29tZXM= IGh1cw== LlVzZQ== dGhlbWU= dXJi IC8qCg== ZXJpYWxpemU= QVJO IGxvc2U= TG93ZXI= IHZlbA== IGRlZmVuc2U= Y29uZGl0aW9u IGJlcw== IGRyeQ== IHNjcm9sbA== LlNob3c= SUVM 0L7RgA== IFJlc3Q= V2hlcmU= b29kcw== IEplcw== IHdpcmU= X0lORk8= IHN0cmluZ3M= Z21lbnQ= IG1hdGNoZXM= IGVsZWN0cmlj IGV4Y2VsbGVudA== IENvdW5jaWw= aWRhZGU= IHd4 cHVzaA== X2VudHJ5 IHRhc2tz IHJpY2g= c2E= IFNtaXRo VU5DVElPTg== UG9pbnRlcg== cGVjdGl2ZQ== MTMx IHdpZGdldA== aXN0YQ== IGFnZW5jeQ== IHNpY2g= b2xvZ2llcw== IHRyaWFs YWx5c2lz LmNoZWNr QVJL IG9uQ2hhbmdl YWJvdXQ= Jywk KHZhbA== IHBsYWNlZA== X05P IGRhbg== LmVxdWFs CSAgICAg IHdlYXRoZXI= LmdhbWU= IGRlc3RpbmF0aW9u X1VTRVI= aWVjZQ== IHByb3ZpZGVy Lmxhc3Q= cGxleA== Tm90ZQ== L2pz IHDDpQ== IHBsYW5uaW5n YXR0cmlidXRl UFJP YXRjaGVz IDwt IHNlZWluZw== IGNhbmNlbA== X2luZA== LmtleXM= IHZpc3VhbA== IEN1cnJlbnQ= IENvbGxlZ2U= IFJvY2s= IGFncmVlbWVudA== IFN0b3Jl b3Zpbmc= IGNvcm5lcg== YW1waW9ucw== SVNF Rmlu IHByb3RlY3Rpb24= IGZp UGxheQ== cGx1Z2lu KX0= LmZyYW1l LXo= IHRyYW5zaXRpb24= aWdpbg== IGNhbmRpZGF0ZQ== IFVuaW9u X3ZhbHVlcw== KG1hcA== Y2xl IHRyZW5k d2lkZQ== YXJlbg== TG9j VVRI IEJheQ== IHNtYWxsZXI= aXVz MTQx d2VsbA== IGNyaW1pbmFs IGNvbmZsaWM= YmVydA== X0lOVA== IGludmVzdG1lbnQ= Y3VzdG9t IFNlc3Npb24= X3dyaXRl YW5pYQ== IE1hc3M= X0VR X05PVA== IHZpb2xlbmNl QXJndW1lbnQ= X2VtYWls IGJlbG9uZw== X2Z1bmN0aW9u IGVuZW15 ZW1h IEFkZHJlc3M= LmVtcHR5 IGlubmVy IENvbnRhY3Q= TG9hZGVy PGlucHV0 IENB bG90 IHBpY3R1cmVz IFN1cHBvcnQ= X25hbWVz MTg4 TGF5ZXI= IENsaWNr U3Vt w6Y= IExvb2s= dW91cw== TGli RmxhZ3M= dGVhbQ== RVA= MTg5 aGF0 b3ZlcnJpZGU= YXBzZWQ= IGxhYmVscw== cXVpcw== IFN0cmVhbQ== X2RldmljZQ== IENvbW1pdA== KHJvb3Q= In0= LmlzRW1wdHk= MTI2 CU0= IGFuZ2xl IEJlY2F1c2U= JSUlJSUlJSU= IGFpbQ== IHN0aWNr c3RtdA== YWdyYXBo YW5zd2Vy IGNsaW4= IElzbA== LmV4dA== IElOVA== IHN0eWxlcw== IGJvcm4= IHNjcg== IGV4cGFuZA== IHJhaXNlZA== VGV4dEJveA== SUxM LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t SFRUUA== MTMy Pik= X2NoYXI= cmVzb3VyY2U= IGVwaXNvZGU= ICdf IEVz IEVhcnRo wqDCoA== VVBEQVRF MTMz IFNvdQ== dWlz dHlwZXM= IG1hcw== IGZhdg== IGNvbnN0cnVjdA== X3JhdGU= ZXJhcw== IHwK cm9wZXJ0aWVz IGV4dGVybmFs IGFwcGxpZWQ= IHByZWZpeA== b3RlZA== bGVycw== IGNvbGQ= IFNQ IENodXJjaA== IE91dHB1dA== bG9zZWQ= 55o= aWZpY2F0ZQ== b3BlcmF0aW9u aGVyaXQ= eEZG LmVudg== X2Vycg== b3No RGlyZWN0aW9u Q2FuY2Vs IEZyYW5r IGZpbmRpbmc= LikKCg== IHJvdXRlcg== 44O7 c2Vz IGNyb3c= PT0n IHNhbmQ= IHJpZA== aXR1cmU= IGVudHJl IG9ic2Vydg== IHZhYw== 8J8= LVQ= QXJ0 bmlnaHQ= LnNlYXJjaA== IGV4Y2hhbmdl IGRpc3RyaWN0 Lm9z IGRlcGFydG1lbnQ= IGRvY3VtZW50cw== IGNlbnR1cnk= IE5leHQ= SG9zdA== IEtJTkQ= IHN1c3A= LVA= cmVuZA== LmVt dWl0ZQ== aXN0ZXJz KGpzb24= IEFubg== d3Q= YXRp IEhUTUw= d2hlbg== RGlyZWN0b3J5 IHNodXQ= PGE= ZWR5 IGhlYWx0aHk= IHRlbXBlcmF0dXJl IEdlbg== IG1ldGFs IHN1Ym1pdA== IERP IGF0dHJhY3Q= IHt9Owo= IFdvcmQ= IGxs IHNlZW1lZA== a28= SUVE IGxhYm9y LkNvbnRleHQ= IGFzc2V0 eW91 IGNhcnM= IENvbHVtbg== IHLDqQ== IHNxdWFyZQ== IE5TU3RyaW5n 4oCdLA== YXBlcw== Li4uCg== IHRoYW5rcw== KHByb3Bz IHRpY2s= IGV4cGVyaW1lbnQ= IHByaXNvbg== dHJlZQ== LXRleHQ= IElPRXhjZXB0aW9u LXdpZHRo X1NUQVRVUw== ZmFzdA== LWJvZHk= LWhlYWRlcg== IGd1YXI= Y3JldGU= IFRpbQ== IGNsZWFybHk= IFJlcHVibGljYW4= IGp1c3RpZnk= 0LjRgg== CSAgICA= Y2FjaGU= Oy8v IHByZXNlbmNl IGZhY3RvcnM= IGVtcGxveWVl XSkp TWVtYmVy IHNlbGVjdG9y Ym9y IE1leA== 55qE dXRleA== X3RhZw== YWlsdXJl IE5ldA== IHJlbGk= RUc= IGZwcmludGY= IHRlZW4= bG9zcw== IGxlYXZpbmc= MTM0 RGVsZWdhdGU= IGJlYXQ= IG1pbnV0ZQ== c3Vic2NyaWJl IHJlZGlzdHJpYnV0ZQ== Q29uc3RhbnRz IGNhbmNlcg== L3s= Qkw= IHNwYW4= IENoaWxk Q2VudGVy IGVhcnRo WVM= IExldmVs IHNlYQ== LnN1cHBvcnQ= LmlubmVy Lkl0ZW0= aWxsaW5n ICAgIAogICAgCg== IExhYmVs MzIw IEVzdA== KGFyZw== MTQ1 Ym9Cb3g= CWZvcmVhY2g= Y29z RmFpbGVk c3dlcnM= RWRpdG9y cm9udA== IE1Q ZXhwcg== IExpZmU= ID8/ w7Zy IGF0dGVuZA== IFF1ZQ== IHNwZWNpZXM= LUQ= IGF1cw== U3RydWN0 IGFkdmFudGFnZQ== b3N0b24= LWJsb2Nr aW5pdGlhbA== Q1JF IHRydWx5 IGNvbXBhcmU= b3JuZXk= IHNwZWN0 RnVsbA== YmVz IHZpc2libGU= IG1lc3M= c3RhbmNlcw== IGNsb3Vk X3ZlcnNpb24= IGZ1cm4= aWNhZ28= TE9X IHRyYWZmaWM= IGZvbA== cnlwdG8= IGRlY2xhcg== IHNsb3Q= IEV4dA== IEVuZ2xhbmQ= IFVuZGVy IHRh bGV0dGVy MjAz IG9mZmljZXI= IERvbmFsZA== WWVz X2pzb24= SVRhYmxlVmlldw== IFVTRQ== bXBsb3llZQ== IG9waW5pb24= IEF1dA== Ym9yZGVy IGFkdmljZQ== IGF1dG9tYXRpY2FsbHk= aXNjbw== IG1t LnZpcw== YW1s IGluaXRpYWxpemU= ICh7 IDsKCg== IGdlbmVyYXRpb24= IGJpdHM= Y2xpcHNl IHVuZg== dXRvcnM= cGx0 IGRlbHRh ZXN0cm95 aXNpcw== PGJy IGxpbWl0YXRpb25z IGVuZGVk IE1hZA== aWxt VGhlc2U= MTg3 IE1pbmlzdGVy IGNoYXJ0 RnJhZ21lbnQ= IGluZGVwZW5kZW50 WWVhcg== IGluc3Ry IHRhZ3M= QVZF IEFyY2g= c3RvcA== UHJvZ3Jlc3M= IG1p IGxlYXJuZWQ= R2U= IGhvdGVs MTUx U00= VFlQRQ== IGN5 RVJTSU9O dW5hdGVseQ== bGltaXQ= c2Vs IG1vdmllcw== IHN0ZWVs b3o= Z2I= IENhbXA= c2l0ZQ== IExvZ2dlcg== UExF 0L7QtA== LnJpZ2h0 IENvcmU= IG1peGVk c3RlcA== IHB1dHM= c3VwZXI= Um91dGVy MTg2 Lkh0dHA= MjIy bHlwaA== IENvbG9ycw== IGFuZHJvaWR4 LnN0cg== IGlubm92 IGRlY2s= Jz4K YXBlcnM= XSg= Y29udGludWU= c3BlYw== IFJvYWQ= QVNI aWxpYXI= IGNvbnRpbnVlcw== IGFwcG9pbnQ= ICMK IFZpcg== ID8+Ig== IGJpbg== fSIs Z29pbmc= ZWFjaA== QkQ= MTg1 IEFjY2Vzcw== RG9j IE1hbmFnZW1lbnQ= QkVS YXNrZXQ= LmdldEluc3RhbmNl MTI5 IGVzdGFibGlzaGVk c29ja2V0 SU5T CXZpcnR1YWw= CXJlc3VsdA== UkVBRA== X2hlaWdodA== MTUy IEZvbnQ= ICgpOwo= X2h0bWw= IG5laWdoYm9y bG9y IGdhdGhlcg== IH0pCgo= IGlkZW50aXR5 IGZhYg== cGFkZGluZw== IFJvdXRl RW51bWVyYWJsZQ== w7Q= IGZvcmNlZA== L2pxdWVyeQ== LgoKCgoKCg== cmVzZW50cw== X2xlZnQ= LlBhcmFt CXRocm93 IEhhbQ== IGV2ZW50dWFsbHk= YWNlcg== cHVi IHRyYQ== dW5pcXVl ZGVs IEZsb3JpZGE= IENsZWFu eGE= IMK3 IHZhbGlkYXRl VmlzdWFs RXhwcmVzc2lvbg== X2Z1bmM= bWVtYmVy CWg= dHJs MTM2 CUc= bmFwc2hvdA== IFByb3BUeXBlcw== dmlu MTUz XSkKCg== b3ds aWZpZXM= ICQoJy4= IENvbnRleHQ= IFRvYXN0 LktleQ== IG9mZmljZXJz L24= c24= dW5kZWZpbmVk Lml0ZW1z dXRvdw== YW1hZ2U= IGFjY291bnRz b29raWU= U2VjdGlvbg== aWNpYW5z IGFkdmlz KGlz Wzos IEZyYW5jZQ== RnVuYw== aWNpb3Vz IHRvaw== Q2hhbm5lbA== IEFE X05VTQ== IHRpbWVvdXQ= bGVtbWE= cmVtZQ== dWo= LkFs dWNsZWFy KG9z KCI8 Wwo= ZmV0Y2g= IGJhbA== IGd1aWQ= LWFsaWdu IFdyaXRl IE9uY2U= dXRvd2lyZWQ= T0RVTEU= IHBpdGNo Q0Y= Ynl0ZXM= IENvbW1pc3Npb24= IGluY3JlZA== UEVS X3Jlc3BvbnNl IExvcw== cGFyc2Vy IGFzc3VtZQ== LlJlcXVlc3Q= IFRva2Vu X3Bvc2l0aW9u IG5vbQ== LXRlcm0= IHJlbWFpbmluZw== aW9zdHJlYW0= IHBpZWNlcw== YXB5 IExlc3M= cmFuZ2U= dW1ibg== cHJpc2U= X29wdGlvbg== MjMw SW1wbA== a3dhcmdz IGJ1c2luZXNzZXM= QWxlcnQ= IHBhcnRpZXM= IENvbnRhaW5lcg== IFByaXZhdGU= IFBsYW4= IHJlZ2lzdGVyZWQ= IGpvdXI= YWNrZXI= 0LXQvdC4 Lz4= Y2hhdA== c2VjdA== IGNyZWF0aW9u b2x1dGVseQ== IGluc3RhbnQ= IGRlbGl2ZXJ5 aWNrZW4= eWVz MTYz IEZyYW5j Ymxpbmc= ZW5kYQ== Wyg= X3Jhbmdl ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IHNjaGVkdWxl Q29ubg== IHRoYW5r eGQ= IGhvb2s= IGRvY3VtZW50YXRpb24= UGFyYW1ldGVycw== SGVsbG8= dnQ= IGFydGljbGVz IHdlc3Q= ZGVmaW5lZA== LnNlbGVjdA== b2tlbnM= IFZBTA== LmZpbGU= cmVzZXQ= IG15cw== IE1B XSks IGNpdGllcw== cmVsYXRlZA== 5Zs= IGFwcGVhcmVk IHdpZA== LnBhbmVs IElucw== LmVudGl0eQ== IGRlY3Jl IExvdQ== KHRpbWU= IFRoYW5r LmNyZWF0ZUVsZW1lbnQ= IG1lbnRpb25lZA== b3VuY2U= IFRyeQ== IFdhbGw= L2ltYWdlcw== IE1lbnU= Jw0K IEVy IGNyaXRpYw== IFllYXI= KHBhcmFt IGZsbw== Tk4= b290ZXI= IF07Cg== IEFmZg== ImdpdGh1Yg== cm9vbXM= IGh5cA== Z2xvYmFs IGF2ZWM= 5pyI IGNvbXBsZXRpb24= IGNvbmQ= b255bW91cw== KHRlbXA= IHN0YXJz IHJlbGV2YW50 IGNvdmVyZWQ= IGVsaW0= X3R5cGVz KGJvb2w= IHR1 X2V4aXN0cw== IHNlY3VyZQ== IHN0b3JlZA== XS8= eEY= IENvbnRyb2xsZXI= IG1pZ3I= TUk= IERlbg== IGFubnVhbA== VUlM LWFuZA== IGNyaW1l YmVs IGtpdGNoZW4= QGc= X3Bo b3VybmFtZW50 IFNvY2lhbA== IFNwZWNpYWw= bG9nZ2Vy IHRhaWw= IHVua25vd24= ZGVk IGFwcHJlYw== KGRi Y2Y= MTU1 IGFzc2lnbg== LW91dA== IE1vbnQ= ZHA= d2lkZ2V0 IHN0b25l LXByaW1hcnk= LmdyaWQ= UmVzdWx0cw== YXp6 IGRhdWdodGVy IGN1cnI= MTc1 IGxpbg== IHNvdXRo Zm9ybXM= IE9VVA== bGV0dGU= YWtz aWd1cmU= IEVV dmFyaWFibGU= IGJyaWVm IFNjb3R0 IGNvbmZlcmVuY2U= YW5kYQ== X2xvY2s= b3JhbA== IGVpbmU= T1JT Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLw== ZXNzbw== IHJpcw== IGdlbmRlcg== ZXN0aWM= TGljZW5zZQ== KG91dA== IG1z U2Vl IHdpbGxpbmc= YXpl IHNwb3J0cw== IHllcw== bHU= IHB1cnM= L2phdmFzY3JpcHQ= LXBybw== bmF2YmFy X3Byb2R1Y3Q= L2Jvb3RzdHJhcA== IGRyaXZpbmc= IMQ= IHByb3Bvcw== dWx0aXA= dXBsaWM= LmVtYWls IGFwcHJveA== KGNs IHdlYXI= IHJlcGx5 YXNzZXQ= IGljZQ== IHR4 a3I= IEdlcm1hbnk= IEdlb3JnZQ== IGNi CWVycg== TW92ZQ== IHBvbHk= dm9pY2U= fSI= IGFuaW1hbA== QXY= IExvY2F0aW9u IG5hdGl2ZQ== XVsi PGRvdWJsZQ== IG1haXM= LGludA== IHByZXBhcg== IGludGVydmFs cGxlbWVudGF0aW9u X0VSUg== IGJ1Zw== PiI= c3RhdA== IH0sDQo= PHNwYW4= IGZhaXRo IHJvbQ== cHJldg== IEVsZWN0 RmluZA== IGdvZA== b3Rvcg== Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t b3JpZ2luYWw= Q3Bw IFNlbmF0ZQ== IHBvc2l0aW9ucw== IHdlYXBvbnM= IGNvZmY= IHB1cnBvc2Vz cG9s IGltcHJlc3M= IGFuaW1hbHM= LkVudGl0eQ== KG5w IG11cmRlcg== IGBg ZmxhZw== IHNvbHV0aW9ucw== IEFjdGl2ZQ== IGJyaWdodA== LmRhdGU= IHNpdHU= 77yI LklE IHNpZQ== KSwNCg== YWt0 U3BhY2U= LmRhdA== LmluZGV4T2Y= aGFu YXppbmU= IFpl IGNyYXNo KC8= Pj0= 0LE= MTM5 aXZh LkF1dG9TaXpl IExhdA== X2V4dA== SW5pdGlhbGl6ZQ== LnJlZ2lzdGVy MTU2 T1BZ IHJldmVyc2U= X2Rpcw== J11b IHByb21wdA== b250bw== IEpvdXJuYWw= cm91dGVy IG15c3FsaQ== I2Vsc2U= KSI= LXhz bGV0cw== cGhhbg== LkxF MTM3 V2lsbA== IGFmZm9yZA== IHNraWxs LXRvZ2dsZQ== TkM= QmluZA== VFM= SnVzdA== aXRlcmFs WVA= CXVuc2lnbmVk IHdpbmQ= MTQ5 KSk6Cg== IHdhcm5pbmc= IFdhdGVy IGRyYWZ0 IGNt IHNhbQ== IGhvbGRpbmc= emlw IFNjaWVuY2U= IHN1cHBvc2Vk R2Vu IGRpZXQ= PGg= IFBhc3M= dmk= IGh1c2JhbmQ= 77+977+9 bm90ZQ== IEFib3V0 IEluc3RpdHV0ZQ== IGNsaW1hdGU= LkZvcm1hdA== IG51dA== ZXN0ZWQ= IGFwcGFyZW50 IGhvbGRz Zmk= bmV3cw== Q00= dmlkZW8= Jzon RElUSU9O cGluZw== IHNlbmlvcg== d2E= LS0+Cg== X2RlZmF1bHQ= IERhdGFiYXNl cmVw RVNT bmVyZ3k= LkZpbmQ= X21hc2s= IHJpc2U= IGtlcm5lbA== Ojok LlE= IG9mZmVyaW5n ZGVjbA== IENT IGxpc3RlZA== IG1vc3RseQ== ZW5nZXI= IGJsb2Nrcw== b2xv IGdvdmVybmluZw== XEY= IGNvbmNlbnQ= LmdldFRleHQ= IG1i IG9jY3VycmVk IGNoYW5naW5n U2NlbmU= X0NPREU= QmVo IlRoZQ== IHRpbGU= IEFzc29jaWF0aW9u CVA= YWx0eQ== X2Fk b2RpZXM= aWF0ZWQ= IHByZXBhcmVk cG9zc2libGU= IG1vcnQ= VEVTVA== MTQy IGlnbm9yZQ== IGNhbGM= IHJz IGFzc2VydEVxdWFscw== IHN6 IFRISVM= LiIK IGNhbnZhcw== amF2YQ== IGR1dA== VkFMSUQ= LnNxbA== LmlucHV0 IGF1eA== U3Vw IGFydGlzdA== VmVj X1RJTUU= LnN0cmluZ2lmeQ== ZXR3ZWVu IENhdGVnb3J5 IFst IERldkV4cHJlc3M= IEp1bA== IHJpbmc= LmVk WVk= TGV0 VGV4dEZpZWxk IGZsYXQ= X3ByaW50 IE9USEVS YWRpYW4= IGNoZWNrZWQ= ZWxl QWxpZ24= c3RhbmRpbmc= IFtdLA== IGxhYg== dWNreQ== IENocmlzdG1hcw== KGltYWdl Lm1vZHVsZQ== IGxvdHM= IHNsaWdodGx5 KGZpbmFs ZXJnZQ== 6L8= MTQ3 IFBvbGljZQ== MTQz IFJpZ2h0 IGF3YXJk IE9T IHt9Cgo= IHB0cg== b3Zlcw== aWNhdGVk 0LXQvA== IG1hbmFnZQ== b2xpZGF5 QW1vdW50 b29sU3RyaXA= dGJvZHk= TmF2 d3JhcA== QkI= IHdhdGNoaW5n YXJpb3M= IG9wdGlvbmFs X0s= IExpY2Vuc2Vk Lk1hcA== VGltZXI= IEFQ IFJldg== KG8= LGM= dW1pbg== ZXRhaWxlZA== IEh5 IGJsYW5r YWdnZXI= IFNlbGY= KClb Lm1ha2U= ZWFybg== Y2hhbm5lbA== PHByZQ== YmxlbQ== X3Bhc3N3b3Jk X3Nw aWNpbmc= ZXo= IHRoZW9yeQ== IFRlcg== MTg0 LG4= bG9nbw== IEhUVFA= KCkpKQ== LmhhbmRsZQ== PjsK V29ybGQ= IHB5dGhvbg== IGxpZg== IHRyYXY= IGNvbnZlbg== Y29tcGFueQ== IENsdWI= MTM4 VmVy QnRu IHpvbmU= cHJvZHVjdHM= IEVkdWM= IHZlcmlmeQ== IE1pbA== b25v XSk7Cgo= RU5DRQ== IHBhY2tldA== IGNlcg== IGVudW1lcg== IHBhcnM= Zm9ybWVk IG9jY3Vw dHJl IGV4ZXJjaXNl RGF5 X3N1bQ== IGFza2luZw== YXB0aW9u IG9yZGVycw== IHNwZW5kaW5n IEVSUg== LkRpcw== IFV0aWw= 4oCcSQ== XCc= Pyk= Lz4K IGVtb3Q= IGluZmx1ZW5jZQ== IEFmcmljYQ== YXR0ZXJz 2YU= LnNlc3Npb24= IGNoaWVm CQkJCQkJCQkJCQk= IHRvbQ== Y2x1ZGVk c2VyaWFs X2hhbmRsZXI= LlR5cGU= YXBlZA== IHBvbGljaWVz LWV4 LXRy Ymxhbms= bWVyY2U= IGNvdmVyYWdl IHJj X21hdHJpeA== X2JveA== IGNoYXJnZXM= IEJvc3Rvbg== UGU= IGNpcmN1bQ== IGZpbGxlZA== MTQ4 IG5vcnRo aWN0dXJlQm94 CXJlcw== 6K4= IHRlcm1pbg== IFvigKY= SVJFQ1Q= IGJlcg== ICIuLi8uLi8= cmV0Y2g= LmNvZGU= X2NvbA== IEdvdmVybm1lbnQ= IGFyZ3Y= IExvcmQ= YXNp RXhlYw== CWxldA== dmVydGlz IGRpc2N1c3Npb24= ZW5hbmNl b3V0dWJl dHlwZW9m IHNlcnZlZA== IFB1dA== CXg= IHN3ZWV0 QmVmb3Jl YXRlZ3k= Lm9m IE1hdGVyaWFs U29ydA== T05U aWdpdGFs V2h5 IHN1c3Q= IOc= YWJldA== IHNlZ21lbnQ= IFtdLAo= IE11c2xpbQ== IGZpbmRWaWV3QnlJZA== Y3V0 X1RFWFQ= IE1hcnk= IGxvdmVk IGxpZQ== IEpP IGlzc2V0 bW9udGg= IHByaW1l dGk= IENhcm9s VXNl MTQ2 IFBvcA== IFNhdmU= SW50ZXJ2YWw= ZXhlY3V0ZQ== ZHk= IElyYW4= X2NvbnQ= CVQ= IHBoYXNl Y2hlY2tib3g= d2Vlaw== IGhpZGU= IHRpbA== IGp1 Q3VzdG9t YnVyZw== L00= VE9O IHF1YW50 IHJ1Yg== aXhlbHM= IGluc3RhbGxlZA== IGR1bXA= IHByb3Blcmx5 KExpc3Q= IGRlY2lkZQ== YXBwbHk= SGFz IGtlZXBpbmc= IGNpdGl6ZW5z IGpvaW50 cG9vbA== U29ja2V0 X29w IHdlYXBvbg== Z25vcmU= IEV4ZWM= b3R0ZW4= IE1T ICgt IFJldmlldw== IGV4YW1wbGVz IHRpZ2h0 ISg= RFA= IE1lc3NhZ2VCb3g= IHBob3RvZ3JhcGg= MTY0 VVJJ w6l0 bG93 IEdyYW5k LnBlcnNpc3RlbmNl IG1haW50YWlu IG51bXM= IHppcA== aWFscw== IEdldHM= cGVn IEJ1ZmZlcg== fn5+fg== cmFzdHJ1Y3R1cmU= IFBM dWVu b2JieQ== c2l6ZW9m IHBpYw== IHNlZWQ= IGV4cGVyaWVuY2Vk IG9kZA== IGtpY2s= IHByb2NlZHVyZQ== YXZpZ2F0b3I= LW9u LGo= IEFsdGhvdWdo IHVzZXJJZA== YWNjZXB0 Qmx1ZQ== SUNvbG9y bGF5ZXI= YXZhaWxhYmxl IGVuZHM= LnRhYmxl IGRhdGFzZXQ= YnVz IGV4cGxhaW4= KHBybw== IENvbW1pdHRlZQ== IG5vdGVk XToK RGlt c3RkaW8= MTU0 LiIsCg== X3NvdXJjZQ== MTgx IFdlZWs= IEVkZ2U= IG9wZXJhdGluZw== IGVzdGU= aXBs MzMw YWdpbmF0aW9u IHByb2NlZWQ= IGFuaW1hdGlvbg== Lk1vZGVscw== IFdhdGNo aWF0 IG9wcG9u L0E= UmVwb3J0 IHNvdW5kcw== X2J1Zg== SUVMRA== IGJ1bmQ= CWdldA== LnBy KHRtcA== IGtpZA== PgoKCg== IHlhbmc= Tm90Rm91bmQ= 0YY= bWF0aA== QGdtYWls IExJTUlU cmVkaWVudHM= IHZlbnQ= YXZpZ2F0ZQ== TG9vaw== IHJlbGlnaW91cw== IHJhbmQ= cmlv KEdM X2lw dWFu aWNpZW5jeQ== IENoYW5nZQ== Pg0KDQo= IEVudGl0eQ== IHJlbmNvbnRyZQ== IFJldA== cGxhbg== w6lu Qk9PTA== dXJpZXM= dHJhaW4= RGVmaW5pdGlvbg== PT09PT09PT09PT09 eno= NDUw QW5pbWF0aW9u IE9L X21lbnU= LmJs X3Njb3Jl IGFjYWQ= KFN5c3RlbQ== IHJlZnJlc2g= Jz0+JA== LkdyYXBoaWNz YW1lbnRv cGlk dGM= IHRpcHM= IGhvbWVz IGZ1ZWw= 4pY= X2hlbHBlcg== ICANCg== IFJvb20= LkNsb3Nl X2F0dHI= IE1vdW50 IEV2 YXJzZXI= X3RvcA== ZWFo IERlbGV0ZQ== 44CN dWtl IHVzYWdl YXJpYQ== X2Rldg== IHRleHR1cmU= IGNvbnZlcnNhdGlvbg== ZXBlcg== QmVhbg== ZG9uZQ== bm9uYXRvbWlj IFNlY29uZA== IHNob290aW5n X3ByZQ== Q29tcG9uZW50cw== IF0KCg== X18s c3RpdHV0aW9u LkNoYXI= PigpOwoK IHByZXNlbnRlZA== IHdh b2tlcg== LQoK aW5lcg== IGJlY29taW5n IGluY2lkZW50 QXR0 MTYy IHJldmVhbGVk Zm9yYw== IGJvb3Q= LnBhZ2U= RW51bWVyYXRvcg== MTY1 Xy0+ UGhvdG8= IHNwcmluZw== LiIs IERpY3Rpb25hcnk= QkpFQ1Q= IGxvY2F0aW9ucw== IHNhbXBsZXM= SW5wdXRTdHJlYW0= IEJyb3du IHN0YXRz cXVhbGl0eQ== 0YU= LWRpcw== IGhlbHBpbmc= IHBlZA== MjI0 KHNl IFdobw== YWxpYW4= aW50ZXJuYWw= IGZ0 PigpLg== LT57 IG1pbmU= IHNlY3Rvcg== IGdybw== IG9wcG9ydHVuaXRpZXM= IMO8 IG1w IGFsbGVnZWQ= IGRvdWJ0 TW91c2U= QWJvdXQ= X3BhcnQ= IGNoYWly IHN0b3BwZWQ= MTYx bG9vcA== ZW50aXRpZXM= IGFwcHM= YW5zaW9u IG1lbnRhbA== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= RlI= IGRlZmVuZA== Y2FyZQ== IGlkZWFs L2FwaQ== dXJmYWNl MDEx IGVsZQ== dWxhdG9y IFJpZ2h0cw== YW5ndWFnZXM= IGZ1bmRz IGFkYXB0 QXR0cmlidXRlcw== IGRlcGxveQ== b3B0cw== IHZhbGlkYXRpb24= IGNvbmNlcm5z dWNl Lm51bQ== dWx0dXJl aWxh IGN1cA== IHB1cmU= LkZvcmU= MTgz IEhhc2hNYXA= LnZhbHVlT2Y= YXNt TU8= IGNz IHN0b3Jlcw== ICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKg== IGNvbW11bmljYXRpb24= bWVt LkV2ZW50SGFuZGxlcg== LlN0YXR1cw== X3JpZ2h0 LnNldE9u U2hlZXQ= IGlkZW50aWZ5 ZW5lcmF0ZWQ= b3JkZXJlZA== ICJb IHN3ZQ== Q29uZGl0aW9u IEFjY29yZGluZw== IHByZXBhcmU= IHJvYg== UG9vbA== IHNwb3J0 cnY= IFJvdXRlcg== IGFsdGVybmF0aXZl KFtd IENoaWNhZ28= aXBoZXI= aXNjaGU= IERpcmVjdG9y a2w= IFdpbA== a2V5cw== IG15c3Fs IHdlbGNvbWU= a2luZw== IE1hbmFnZXI= IGNhdWdodA== KX0K U2NvcmU= X1BS IHN1cnZleQ== aGFi SGVhZGVycw== QURFUg== IGRlY29y IHR1cm5z IHJhZGl1cw== ZXJydXB0 Q29y IG1lbA== IGludHI= KHE= IEFD YW1vcw== TUFY IEdyaWQ= IEplc3Vz ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg LkRF IHRz IGxpbmtlZA== ZnJlZQ== IFF0 IC8qKg0K IGZhc3Rlcg== Y3Ry X0o= RFQ= LkNoZWNr IGNvbWJpbmF0aW9u IGludGVuZGVk LXRoZQ== LXR5cGU= MTgy ZWN0b3Jz YW1p dXRpbmc= IHVtYQ== WE1M VUNU QXA= IFJhbmRvbQ== IHJhbg== LnNvcnQ= IHNvcnRlZA== LlVu NDAx X1BFUg== aXRvcnk= IHByaW9yaXR5 IEdhbA== IE9sZA== aG90 IERpc3BsYXk= KHN1Yg== X1RI X1k= IENhcmU= bG9hZGluZw== S2luZA== X2hhbmRsZQ== LCw= cmFzZQ== X3JlcGxhY2U= LmFkZEV2ZW50TGlzdGVuZXI= IFJU MTcy IGVudGVyZWQ= Z2Vycw== IGljaA== KHN0YXJ0 MjA1 L2FwcA== IGJyb3RoZXI= TWVtb3J5 T3V0bGV0 IHV0Zg== cHJlYw== IG5hdmlnYXRpb24= T1JL IGRzdA== RGV0YWls IGF1ZGllbmNl IGR1cg== IGNsdXN0ZXI= dW5jaGVk IF0s IGNvbWZvcnRhYmxl LnZhbHVlcw== IFRvdGFs IHNuYXA= IHN0YW5kYXJkcw== IHBlcmZvcm1lZA== aGFuZA== KCJA 5a0= IHBoaWw= aWJy dHJpbQ== IGZvcmdldA== MTU3 IGRvY3Rvcg== LlRleHRCb3g= Mzc3 aWNvbnM= LHM= IE9w U20= U3RvcA== CUxpc3Q= CXU= Q29tbWVudA== X1ZFUlNJT04= Llh0cmE= UGVyc29u cmI= TE9C ICAgICAgICAgICAgICAgICAgICAK IENlbnRyYWw= Mjcw SUNL cmFx IHB1dHRpbmc= IG1k IExvdmU= UHJvZ3JhbQ== Qm9yZGVy b29y IGFsbG93aW5n YWZ0ZXI= IGVudHJpZXM= IE1heWJl XSku IFNob3J0 KVw= Lm5vdw== ZnJpZW5k IHByZWZlcg== IEdQSU8= b3Npcw== IEdhbWVPYmplY3Q= IHNraXA= IGNvbXBldGl0aW9u X21hdGNo bGljYXRpb25z X0NPTlQ= Lmdyb3VwQm94 IGFscw== NjY2 Ildl X2Vx bGFu X3NlYXJjaA== IE11c2lj YXNpcw== IGJpbmQ= IElzbGFuZA== cnVt KEU= IHNlYXQ= VmlkZW8= IGFjaw== cmVlaw== PXsoKQ== IHJhdGluZw== IHJlc3RhdXJhbnQ= NDU2 REVY KGJ1Zg== cHBpbmc= dWFsaXR5 IGxlYWd1ZQ== MTc2 IGZvY3VzZWQ= YXBvbg== JGRhdGE= Q0xVRA== Q0xVRElORw== IGFic29sdXRl KHF1ZXJ5 IHRlbGxz QW5n IGNvbW11bml0aWVz IGhvbmVzdA== b2tpbmc= IGFwYXJ0 YXJpdHk= LyQ= X21vZHVsZQ== IEVuYw== LmFu LkNvbmZpZw== Q3Jl IHNob2Nr IEFyYWI= SUVOVA== L3Jl IHJldHJpZQ== eWNsZXI= aXNh IE9yZ2Fu LmdyYXBo IO0= IEJBUw== RW51bQ== IHBvc3NpYmx5 0YDQsNA= IEphcGFuZXNl IGNyYWZ0 IFBsYWNl IHRhbGVudA== IGZ1bmRpbmc= IGNvbmZpcm1lZA== IGN5Y2xl L3g= R0U= IGhlYXJpbmc= IHBsYW50cw== IG1vdXRo cGFnZXM= b3JpYQ== IFJlbW92ZQ== X3RvdGFs IG9k b2xsYXBzZQ== ZG9vcg== IGJvdWdodA== IGFkZHI= QVJDSA== X2RpbQ== ZGRlbg== IGRlY2FkZXM= UkVRVUVTVA== IHZlcnNpb25z ZmlyZQ== MDA2 IG1vdmVz ZmI= IGNvZmZlZQ== LmNvbm5lY3Q= IFJvdw== IHNjaGVtYQ== U2NvcGU= LVR5cGU= IGZpZ2h0aW5n IHJldGFpbA== IG1vZGlmaWVk VEY= RmlsZXM= bmll X2NvbW1hbmQ= c3RvbmU= INGC X3RocmVhZA== IGJvbmQ= IERldmVsb3BtZW50 IHB0 Rk9STQ== cGxldA== IGlkZW50aWZpZWQ= Y3Bw MjA2 MjI1 IGNvZGluZw== b2tlZA== IE1hc3Rlcg== SURUSA== IHJlc2lkZW50cw== cmVkaXQ= IFBob3Rv PS0= dW50ZQ== YXRldXI= MTU5 X1NUQVRF IFNpbmc= IHNoZWV0 LnZhbA== b3JzZQ== IGhlcnM= IGRldGVybWluZWQ= Q29tbW9u IHdlZA== X3F1ZXVl UEg= IEF0bA== Y3JlZA== L0xJQ0VOU0U= IG1lcw== IGFkdmFuY2Vk LmphdmE= LlNo R28= a2lsbA== ZnA= X3NldHRpbmdz IHBhbA== IHRydWNr IGNvbWJpbmVk ICIkew== IENvcnBvcg== IGpvaW5lZA== IEpvc2U= IEN1cA== dW5z ZXN0aXZhbA== bGV2aXNpb24= IGJyb2tlbg== IG1hcnJpYWdl IFdlc3Rlcm4= IHJlcHJlc2VudHM= IFRpdGxl IHNz LkFzcw== b25nb29zZQ== aWVudG8= PD4oKTsK IGFic29sdXRlbHk= IHNtb290aA== VEVSTg== IFVubGVzcw== V29yZA== IG1lcmdl aWdhbg== IFZvbA== IG5u LmdldElk INC3 MTcx IHNleHk= IHNlZWtpbmc= U2luZ2xl LnRoaXM= MTc5 IGtvbQ== Ym91bmQ= OyI= IGZvbnRTaXpl X2Rm IGluanVyeQ== KEg= IGlzc3VlZA== X0VORA== OnNlbGY= MDIw IHBhdGNo IGxlYXZlcw== IGFkb3B0 RmlsZU5hbWU= 44CQ IGV4ZWN1dGl2ZQ== IEJ5dGU= XSkpCg== IG51 b3V0aW5n Y2x1ZGluZw== LVI= Lm9wdGlvbnM= IHN1YnN0YW50 YXZheA== IEJVVA== IHRlY2huaWNhbA== IHR3aWNl IG3DoXM= IHVuaXZlcnM= eXI= IGRyYWc= IERD IHNlZA== IGJvdA== IFBhbA== IEhhbGw= Zm9yY2VtZW50 IGF1Y2g= Lm1vZA== bm90YXRpb24= X2ZpbGVz LmxpbmU= X2ZsYWc= W25hbWU= IHJlc29sdXRpb24= IGJvdHQ= KCJb ZW5kZQ== KGFycg== RnJlZQ== KEAi IERpc3RyaWN0 UEVD Oi0= UGlja2Vy IEpv ICAgICAK IFJpdmVy X3Jvd3M= IGhlbHBmdWw= IG1hc3NpdmU= LS0tCg== IG1lYXN1cmVz MDA3 IFJ1bnRpbWU= IHdvcnJ5 IFNwZWM= CUQ= 44CR ICl7Cg== IHdvcnNl KGZpbGVuYW1l IGxheQ== IG1hZ2lj IFRoZWly b3Vs c3Ryb3k= IFdoZXJl Mjgw IHN1ZGRlbg== IGRlZmU= IGJpbmRpbmc= IGZsaWdodA== IE9uSW5pdA== IFdvbWVu IFBvbGljeQ== IGRydWdz aXNoaW5n KCcuLi8= IE1lbA== cGVhdA== dG9y IHByb3Bvc2Vk IHN0YXRlZA== X1JFUw== IGVhc3Q= MjEy IENPTkRJVElPTg== X2Rlc2M= IHdpbm5pbmc= Zm9saW8= TWFwcGVy IFBhbg== IEFuZ2U= LnNlcnZsZXQ= IGNvcGllcw== TE0= IHZt 5Y0= IGRpY3Rpb25hcnk= U2Vn MTc3 ZWxpbmVz IFNlbmQ= IGlyb24= IEZvcnQ= MTY2 LmRvbWFpbg== IGRlYmF0ZQ== Tm90TnVsbA== ZXE= YWNoZXI= bGY= CWZtdA== IGxhd3k= MTc4 xJ8= IE1lbg== IHRyaW0= KE5VTEw= ICEh IHBhZA== IGZvbGxvd3M= Il1bIg== cmVxdQ== IEVw LmdpdGh1Yg== KGltZw== ZXRv KCdc U2VydmljZXM= dW1ibmFpbA== X21haW4= cGxldGVk Zm9ydHVuYXRlbHk= IHdpbmRvd3M= IHBsYW5l IENvbm5lY3Rpb24= LmxvY2Fs dWFyZA== fVw= PT0i YW5kb24= IFJveQ== d2VzdA== MTU4 aWdpbmFs ZW1pZXM= aXR6 Jyk6Cg== IFBldGVy IHRvdWdo IHJlZHVjZWQ= IGNhbGN1bGF0ZQ== IHJhcGlk Y3VzdG9tZXI= IGVmZmljaWVudA== IG1lZGl1bQ== IGZlbGw= LnJlZg== IENhcw== IGZlZWRiYWNr U3BlZWQ= KG91dHB1dA== YWpl IGNhdGVnb3JpZXM= IGZlZQ== fTs= IGRlbGV0ZWQ= cmVo IHByb29m RGVzYw== QnVpbGQ= IHNpZGVz LkFycmF5TGlzdA== LSU= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= 2LE= Lm1hdGNo 0LvQuA== IGZlZWxz IGFjaGlldmU= IGNsaW0= X09O IENE IHRlYWNoZXI= X2N1cnJlbnQ= Ym4= X1BM aXN0aW5n RW5hYmxl R0VO IHR2 IHNvY2s= IHBsYXlz IGRpc2NvdW50 IEtF IERlYnVn Rm9yZQ== IElyYXE= IGFwcGVhcmFuY2U= TW9u IHN0eWxlZA== IEh1bWFu aW90 IEhpc3Rvcnk= IHNhYw== IENvbGxlY3Rpb24= IHJlY29tbWVuZGVk LlNlbGVjdGVk IG9yZ2FuaXphdGlvbnM= IGRpc2NvdmVyZWQ= Y29ob2w= YWRhcw== IFRob21hcw== TWF5 IGNvbnNlcnY= IGRvbWlu IEZvbGxvdw== IFNlY3Rpb24= IFRoYW5rcw== VXNlcm5hbWU= IHJlY2lwZQ== IHdvbmRlcmZ1bA== LnNsZWVw X2lm CQoJCg== b3Jubw== IHJ1 X3RhcmdldA== LiIi 4KY= RXZlbnRBcmdz IGlucHV0cw== IGZpZg== IHZpc2lvbg== Y3k= IFNlcmllcw== KSgoKA== IHRyYWRpbmc= IG1hcmtlcg== QmVnaW4= IHR5cGljYWxseQ== IGNhdXNlcw== ZHJvcGRvd24= X0RFQlVH MjYw IGRldGVjdA== Y291bnRyeQ== ISIpOwo= CVI= YXBweQ== IGNyZWY= KCc8 Ij0+ IExF cmVhZGVy IGFkbWluaXN0cg== w7U= dWNrZXQ= IGZhc2hpb24= LmNoYXI= aXphcg== IGRpc2FibGU= IHN1Yw== IExpdmU= aXNzdWU= IG1ldGFkYXRh ZmxhZ3M= IPCf IGNvbW1pdHRlZA== IHZh IHJvdWdo ICcnJwo= IGhpZ2hsaWdodA== X3ZhcnM= Vk8= IGVuY29kaW5n LVo= X3NpZ24= JCgiIw== IHJhaW4= cmVhdGVzdA== IEVORA== U2VsZWN0aW9u IGNhbmRpZGF0ZXM= IHNhdg== LkVtcHR5 IGRlY2lzaW9ucw== IGNvbGxhYm9y cmlkZ2U= ZmVlZA== cmVzc2lvbg== IHBlcnNvbnM= Vk0= MDA4 ZWdh X0JJVA== QWNjb3JkaW5n YWNrZWQ= IGRvbGxhcnM= X2xvc3M= IENvc3Q= fSIK Tm90aWZpY2F0aW9u IHByb3N0aXQ= IGF1dGhvcml0eQ== LnJlYw== IHNwb2tlcw== IFRvZGF5 aXN0YW50 IEhlYWQ= 4oCdLg== ZXJ0YWlubWVudA== Y2Vhbg== Y3VsYXRl IHZlbg== SG93ZXZlcg== X2Fycg== IHRva2Vucw== R3JhcGg= IEp1ZA== IFZpcmdpbg== IFNlcmlhbA== dW5uaW5n TXV0YWJsZQ== YWdlcnM= LmNzdg== IGRldmVsb3Bpbmc= IGluc3RydWN0aW9ucw== IHByb21pc2U= IHJlcXVlc3RlZA== X2VuY29kZQ== LyI= IEljb24= dWlsdA== LWRheQ== IGludGVsbGlnZW5jZQ== LklT IE9ic2VydmFibGU= IEhhcmQ= Qm9vbA== MjEx aWRlbnRpYWw= LkFuY2hvcg== IHNlbGxpbmc= Q0k= QUdFUw== dGxl YnVy VUZGRVI= Ulk= IGJpZ2dlcg== IHJhdA== IGZhbW91cw== IHR5cGVuYW1l IGV4cGxhaW5lZA== fX0K IG51Y2xlYXI= LU4= IGNyaXNpcw== IEVudGVy IGFuc3dlcnM= LyR7 L3Bs IHNlcXU= X25leHQ= bWFzaw== IHN0YW5kaW5n IHBsZW50eQ== IENyb3Nz CXJldA== ZHJv IENhc3Q= MTY3 PXRydWU= IENocmlz aWNpbw== IE1pa2U= RGVjaW1hbA== YWRkQ29tcG9uZW50 TGVu IGNvY2s= ICN7 VVJO PHRy IGF1dGhvcml0aWVz UmVzb3VyY2Vz LUg= Qm90dG9t MDEy X3F1 cHV0ZXI= ZXN0ZXJkYXk= RGlzcGF0Y2g= c2luY2U= IGZhbWlsaWFy LGk= VkM= IG1lbnQ= LEM= IGZyZWVkb20= IHJvdXRlcw== IEJ1eQ== IGNvbW1hbmRz IG1lc2g= L0M= IFNldHRpbmdz LXN0eWxl IHdpdG5lc3M= IGNsZQ== IHVuaW9u ZWZhdWx0 YXJldA== IHRob3VnaHRz IC0tLS0= X3Byb2Nlc3M= X3Vz aW5nbHk= VUVT VG91Y2g= INC8 X29wZW4= IFZlYw== IHJld2FyZA== LkNsaWNr Lzo= IG5pZQ== Q2hhbmdlcw== TW9udGg= 77yf IGV4ZWN1dGlvbg== IGJlYWNo KEludGVnZXI= CWE= Lyc= LkZvbnRTdHlsZQ== IGFib3J0 IFNpbmdsZQ== KGlzc2V0 IGRw IH19PC8= IE1h MjE0 LlJvd3M= IFBldA== JSk= cmFuZA== 6YA= UnVsZQ== IGhlbA== MDIx UklURQ== IHF1aWV0 IHJhdGlv IENPTkRJVElPTlM= b3NvcGg= IElM IGFkdmVudA== Y2Fw Ozwv IFVTQg== RHJpdmVy IG91cnM= IEpvaG5zb24= Lks= X2RlbGV0ZQ== LnE= CXN0cg== L2NvbW1vbg== CXN0cmluZw== IFBERg== YWN0cw== LkFjdGlvbg== IFF1ZXJ5 LnJlc3BvbnNl IEdpcmw= IHByb2Nlc3Nlcw== PEludGVnZXI= aW1v IGFkZHM= IGVudGlyZWx5 IHdhc2g= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKg== IGFuaW1hdGVk IHByb2ZpdA== ZW5jaW5n L1M= IFN5bQ== IG1hbnVhbA== RG93bmxvYWQ= ICghJA== IG1vdGlvbg== d2VicGFjaw== LWJvdHRvbQ== IGdyYXR1aXQ= UEc= KDos IGVyYQ== IGhv IEppbQ== cXVpcg== IEJBU0lT w6Fu REVS IGV4cGVuc2l2ZQ== X2Nv Qm91bmRz V2VsbA== IERlbW9jcmF0aWM= IOKGkg== LlJlbQ== X1NZ bmFtZXM= IFZp IGlzaW5zdGFuY2U= XCI+ ICo9 IFBT IGRhbmdlcm91cw== W3A= T01F T3RoZXI= IFN0cmluZ0J1aWxkZXI= UG9pbnRz aGVhZGluZw== IGN1cnJlbmN5 IHBlcmNlbnRhZ2U= X0FQSQ== IGNsYXNzaWM= dGhlYWQ= IE1P RkU= SWR4 YXdhaXQ= IMOo IGFjY2lkZW50 IHZhcmlhbnQ= IG15c3Q= IExhbmQ= IEJyZQ== IGhhcm0= IEFjYw== IGNoYXJnZWQ= aW9uZXM= VmlzaWJpbGl0eQ== YXJyeQ== IExhbmd1YWdl IHdhbGtpbmc= Ii4KCg== aWZlcg== IGxlYWRlcnNoaXA= LkZyb20= eW5hbQ== IHRpbWVzdGFtcA== aXB0 IEhhcw== UkVGRVI= IEl0cw== IGxpc3RlbmVy VVRF MjEz X2Rlc2NyaXB0aW9u IGV4cGVyaWVuY2Vz IGNyZWF0ZXM= UlM= Y2FydA== YmxhY2s= IGNob2ljZXM= d2Fy NzUw ICcnJw== IG9yZGVyZWQ= IGV2ZW5pbmc= IHBpbA== IHR1bg== IEJhZA== KGFwcA== cmFuZG9t IGV4cGxpY2l0 IGFycml2ZWQ= IGZseQ== IGVjb25vbQ== LW1haWw= IGxpc3Rz IGFyY2hpdGVjdA== MjM0 IFBheQ== IGRz IFNvbA== IHZlaGljbGVz SHo= LWNvbQ== IGtpbmc= X2VxdWFs IEhlbHA= IGFidXNl NDgw MTY5 LS07Cg== IGV4dHI= IGNoZW1pY2Fs 5L8= IG9yaWVudA== IGJyZWF0aA== IFNwYWNl KGVsZW1lbnQ= d2FpdA== REVE aWdtYQ== IGVudHI= IHNvYg== LW5hbWU= IGFmZmVjdGVk aWth IGNvYWw= X3dvcms= IGh1bmRyZWRz IHBvbGl0aWNz c3ViamVjdA== IGNvbnN1bWVy QU5HRQ== IHJlcGVhdGVk U2VuZA== ICNb IHByb3RvY29s IGxlYWRz dXNldW0= RXZlcnk= ODA4 MTc0 SW1wb3J0 KGNvdW50 IGNoYWxsZW5nZXM= IG5vdmVs IGRlcGFydA== Yml0cw== LkN1cnJlbnQ= IGAkew== b3Rpbmc= KFw= IGNyZWF0aXZl IGJ1ZmY= IGludHJvZHVjZWQ= dXNpYw== bW9kdWxlcw== QXJl LWRvYw== bGFuZ3VhZ2U= X2NhY2hl IHRvZA== Pz48Lw== b21ldGhpbmc= IGh1bg== 5bo= YXRlcnM= SW50ZW50 IGltcGxlbWVudGVk IENhc2U= Q2hpbGRyZW4= IG5vdGlmaWNhdGlvbg== UmVuZGVyZXI= V3JhcHBlcg== T2JqZWN0cw== dGw= LkNvbnRhaW5z UGx1Z2lu LnJvdw== IGZvcmc= IHBlcm1pdA== IHRhcmdldHM= IElG IHRpcA== c2V4 IHN1cHBvcnRz IGZvbGQ= cGhvdG8= fSwNCg== IGdvb2dsZQ== JCgnIw== IHNoYXJpbmc= IGdvb2Rz dnM= IERhbg== UmF0ZQ== IE1hcnRpbg== IG1hbm5lcg== bGll LlRoZQ== SW50ZXJuYWw= IENPTlRS TW9jaw== UklHSFQ= ICd7 IGNvbnRyb2xz TWF0 IG1hbmQ= IGV4dGVuZGVk T2s= IGVtYmVk IHBsYW5ldA== IE5vbg== LWNo KSIs ZXBhcg== IGJlbGlldmVk IEVudmlyb25tZW50 IEZyaWVuZA== LXJlcw== IGhhbmRsaW5n bmlj LWxldmVs c2NyaQ== WG1s QkU= dW5nZW4= IGFsdGVy W2lkeA== UG9w Y2Ft ICgoKA== IHNoaXBwaW5n IGJhdHRlcnk= aWRkbGV3YXJl TUM= IGltcGw= b3RhdGlvbg== IExhYg== PGZvcm0= CW5hbWU= IEdhbWVz cmF5 RXh0cmE= VHdv KHBsYXllcg== IExlcw== wrA= IGNoYXJzZXQ= IGpvdXJuZXk= ZXRpbmc= 5pg= 4pQ= 55So IGRpbg== IHBlcm1hbg== IHNvbHZl IGxhdW5jaGVk IG5pbmU= IHNlbmRpbmc= IHRlbGxpbmc= LnBhc3N3b3Jk IE1hdHJpeA== ZXJpYw== IGdyYWI= LnU= IExpYnJhcnk= IGRlYnQ= SU5L LmZpbmRWaWV3QnlJZA== IGZyZXF1ZW5jeQ== LmFk X1RFU1Q= IG5lZ290 IEFmcmljYW4= c2VuZGVy xaE= R2xvYmFs MTcz IGV4cGVydHM= KyspDQo= IGRlcGVuZGluZw== Z3JheQ== IGp1ZGdl IHNlbnRlbmNl bG9zdXJl QWM= IHRyYWNl RWRnZQ== IGZyaWVuZGx5 IGNvbmNlcm5lZA== YmxvZw== IGNsYWltZWQ= fSc= aW50ZWdlcg== X3RyZWU= CWNvbnRpbnVl eGk= IGFjY2VwdGVk X29uZQ== IEVkdWNhdGlvbg== dWJsaXNoZWQ= Z29u YXBwb2ludA== b3V0cw== IG1pbmluZw== IHNvbmdz IGhlcnNlbGY= IGdyYW50ZWQ= IHBhc3Npb24= IExha2U= IGxvYW4= dWVudA== Y2hhbnQ= IGRldGFpbGVk ZXhjZXB0 X2NtZA== IEhF UmVsYXRlZA== enQ= J30sCg== IHNwZWNpZmljYWxseQ== U3RhdGlj IGNhcnJpZWQ= QU5T XCI6 Q3JlYXRlZA== IGN1bA== XS0= X2FwaQ== RlA= IHNpdHRpbmc= ICIiKQ== CWdvdG8= IEVxdQ== IGFzc2F1bHQ= a2lucw== YW5jZXI= b2dlbg== IHZvdGVycw== IFByb3Q= RGVzY3JpcHRvcg== 44O8 LkFzc2VydA== YnNpdGVz b3N0ZXI= LW1lbnU= IGFybXM= LkNsaWVudA== LmJhY2tncm91bmQ= YXZpdHk= IHZ1bA== X01BU0s= IGhvdXNpbmc= IGJlYXI= X2l0ZXI= cGlyZWQ= IG1hcmtldHM= IFN0dWRlbnQ= IHRpY2tldA== IG1pbGxpb25z ZmxhdGVy KT0= IHJlY292ZXI= IEZvcmNl IEJvdGg= IHZpY3RpbQ== IERpc2M= cmVwb3J0 IGZvdXJ0aA== IEFzc2VtYmx5 L3VzZXI= TnVsbE9y dGV4dGFyZWE= IGF0aA== IChb IGNoYW5uZWxz IEp1c3RpY2U= Y2hvaWNl TE9CQUw= ZXhlYw== ZW1hbGU= IGVsZW0= X2xl IHJlc3BvbnNpYmlsaXR5 IFR3 SUNBVElPTg== IGVsc2VpZg== IGZv YXN0cw== IHRyZWF0ZWQ= c2Vu IFZpY3Q= c3VtZXI= X0JBU0U= IGFzdA== Pnt7 IFJlc291cmNl IFN0YW5kYXJk IFByZW0= dXBkYXRlZA== aXZhbGVudA== IGFzc2V0cw== X3RlbXA= IGludGVyZXN0cw== IGhhcmR3YXJl IFJvbQ== IFNoYXJl ICcnCg== ICos IFRha2U= IEltYWdlcw== X0NIRUNL KHR5cGVvZg== IEp1bg== XDxe IGxpcXU= IHdvcnN0 eW1ib2xz CQkJICAg IGRyaXZlcnM= IERvY3VtZW50 ZW5v IFRlY2hub2xvZ3k= IGFwcHJvdmVk dW1wcw== IHNub3c= Zm9ybWFuY2U= X0FTU0VSVA== dWl0cw== MjA3 2YY= IGRpZmZlcmVuY2Vz LlZpc2libGU= CQkJDQo= IFBz X2ZldGNo IHRvZG8= LicsCg== IHNlbA== dXJlcnM= aW52YWxpZA== IHR3ZWV0 VkVM IHJlc2VhcmNoZXJz IHNwcmludGY= IFJP IHBlbA== LlRyYW5z IGlsbGVnYWw= ZGlhbG9n c21hcnR5 bGc= X01JTg== IGhlcm8= ZmluYWw= IHBw Lkxl IGNp CVJU IHN1Z2dlc3RlZA== cGRm YWNoaW5n IFJv IFByb3BlcnRpZXM= IFNp IGJ1eWluZw== IG11 IGxhbmRz aWZpZXJz IEZJTEU= Uk9VUA== IGhvbGRlcg== IFNvbg== IHN5bXB0 LnJvdXRl KT8= IGFyZ2M= IGZvcnQ= IGNhc2lubw== X2NhdGVnb3J5 IGZvcnVt MjE1 cHJlZml4 YXB0dXJl VHViZQ== ZW1z aW1pemU= IG51ZQ== YXVz Y291cnNl QVRPUg== KCkpLA== QWR2ZXJ0aXM= SU5HUw== IGFja25vdw== IEtvcmVh cGxpbmc= IHdvcmtlcg== UExJRUQ= aGFs IFJpY2hhcmQ= RWxlbWVudHM= CQkJIA== c3Rhcg== IHJlbGF0aW9uc2hpcHM= IGNoZWFw QUNI IFhNTA== LCY= IExvdWlz IHJpZGU= X0ZBSUw= IGNodW5r W3M= X09VVA== IGNob3Nlbg== X1s= Lyg= IEplZmY= X3Ns cHJpdg== IENhbmFkaWFu IHVuYWJsZQ== X0ZMQUc= IG5vcw== aGlnaA== IGxpZnQ= ZnVu KCl7 ZWxseQ== eWNsZXJWaWV3 X2Fz X0xJU1Q= IHJhZGk= LmdldFZhbHVl MzA0 IEFuZ2VsZXM= IFNwYW4= X2luc3RhbmNl aXRvcnM= MjA4 IG1pZ3JhdGlvbg== QUs= T2g= wq4= LnNlbGVjdGVk IEdU IGFkdmFuY2U= IFN0eWxl LkRhdGFHcmlkVmlldw== ZWN0aW9u 0Y4= cGlv cm9n IHNob3BwaW5n IFJlY3Q= SWxsdW1pbmF0ZQ== T1U= CWFycmF5 IHN1YnN0YW50aWFs IHByZWdu IHByb21vdGU= SUVX LkxheW91dA== IHNpZ25z Ly4= IGxldHRlcnM= Qm9hcmQ= Y3RybA== Ilw= IEpvbmVz IHZlcnRleA== IGph IGFmZmlsaQ== IHdlYWx0aA== CWRlZmF1bHQ= IHNpZ25pZmljYW50bHk= IGVj IHhz YWN0dWFs LnBlcg== X3N0ZXA= YW52YXM= bWFj IHRyYW5zbA== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= SXRlcmF0b3I= IG9jaA== YWdub3N0aWM= IER1cmluZw== IERFRkFVTFQ= IHRpbGw= IHNpZ25hdHVyZQ== IGJpcmQ= IE9s MzEw IEly SFM= YXZhdGFy RVNTQUdF IGVsZXY= IG10 IE5hdg== IHJlbGF4 IHBsYXRl SVRFTQ== KGRhdGU= Lm5vdA== IGdyYWRl IH0pLAo= PyIKCg== aWVuY2Vz SGlnaA== IERJUw== MjMx ZGlzYWJsZWQ= UVVJ IG5vaXNl YXV4 IFVQ ODg4 b3Nh IHZvYw== ICkp b2NvbQ== X09GRg== IERi TG9jaw== LmVjbGlwc2U= LGQ= IERyYXc= ICIo IHZpc2l0ZWQ= IOKI IHN1Y2NlZWQ= IGltcG9zc2libGU= YWlyZQ== IFR1cm4= IGRpc2g= Rkc= IHNlbnNvcg== QU5O YWJh IHN1cmc= XSk7DQo= IGZw X2Fu LUo= LUc= IEpvYg== Q29udmVydA== IEtFWQ== IGF1dGhvcnM= X3NlcnZlcg== XHI= IC0qLQ== ZmxleA== IHNvYw== UmV0 IHNhbHQ= IOKApgoK IENsZWFy KHBhZ2U= LWRhbmdlcg== IHJvb21z Y29udg== I3s= Lm9w IEFyZWE= X1ND aGVu IGJlZ2lucw== LXk= IGV4Y2l0ZWQ= IGlnbm9yZWQ= IGJvbnVz c3R1ZGVudA== IE1lbWJlcg== IHJlbGF0aXZlbHk= IExvdw== IFByb2R1 YXRld2F5 cG9zdXJl IHRoaWNr YW5pZWw= KHZpZXc= IENydXNo RXh0ZW5zaW9u SWw= ZWVk TE9D Lmlt Lkl0ZW1z IGNvbmZsaWN0 LnByZXZlbnQ= MjUy IG9uQ3JlYXRl dXY= aXNlcg== IHdhdmU= TWFy IENvbW11bml0eQ== aWNoZQ== IE5vdGhpbmc= W20= IExlZQ== cmllbmRz MjMy w6hyZQ== ISEh YW56 LnJlc3VsdA== IFNL X1BBUkFN IGRlbW9jcg== QmFja0NvbG9y LmV4aXN0cw== Ikl0 KG9wdGlvbnM= cmF6eQ== YXNlcg== XERhdGFiYXNl YWxlbmRhcg== X2Fzcw== O30K dmVydGV4 aW5lY3JhZnQ= V2FybmluZw== YXJnbw== IGFjdG9y IEluc3RlYWQ= IFVzaW5n U2VsZg== QGludGVyZmFjZQ== IHNwZWFraW5n IFBhcmlz IExJQ0VOU0U= Lm5vZGU= IEZvb2Q= RUlG IEJp LlN0YXJ0 IElC IHVuaXZlcnNpdHk= MjU0 IEhlYWRlcg== LnByb2R1Y3Q= NDA5 Q29weQ== ZXRj cmljYWw= ID4+Pg== Ym9va3M= IGFsZ29yaXRobQ== ICdfXw== KGphdmF4 IG51bWVyb3Vz U2hhcmU= SGF2ZQ== IHJlY3J1 IHByb3Zl LnN1YnN0cmluZw== aGVhbHRo 0LXQuw== IGRlY2ltYWw= IGNvbW1pc3Npb24= c2NyaXB0aW9u eEM= IHN1bW1hcnk= YXR0ZWQ= IGNsb3Nlcg== ZmluaXNoZWQ= KCkpewo= IFdvb2Q= MzAx X2ZpZWxkcw== a3U= X2l0ZW1z RmxhZw== IGNvbmZpZGVuY2U= IEZlZGVyYWw= ZHV4 IGNvbXBhdA== IHZlcnRpY2Fs 0Lk= w6hz OyI+Cg== X21hbmFnZXI= KCkpKQo= SURF OiIs MjM1 X18K IFdheQ== MjIx 0Yg= VGVtcA== IFNUUg== cml0dGVu U3luYw== IEFW IENFTw== IEd1aWQ= IGVudmlyb25tZW50YWw= IGNvcnJlc3BvbmRpbmc= CWNvbnNvbGU= IGp1c3RpY2U= IEpT IGxpdmVk Z2Fy IEdyYXBo IFN0YXQ= IGlQaG9uZQ== LmFs IEhE IG9jY3Vy IHRocmVzaG9sZA== NTA5 IG9uY2xpY2s= UkVH LkdyYXBoaWNzVW5pdA== TWV0YQ== xb4= IGN1bQ== LmdudQ== w6s= IG9idGFpbmVk IGNvbXBsYWludA== IGVhdGluZw== IHRhcg== X3Rhc2s= IG9wdHM= MjE2 KHRv UGFzcw== IHBsYXN0aWM= dGlsaXR5 IFdpbg== LnByZXZlbnREZWZhdWx0 cGlsZQ== IEdhcg== IHF1YW50aXR5 X2xhc3Q= IGdyZWF0ZXN0 RGFv X0RJUw== IFVzZWQ= IEhQ cml0aW5n U0lPTg== Ymx1ZQ== ZG9tYWlu IHNjb3Jlcw== Tm9ybWFs X2FkbWlu IEFTU0VSVA== VGhlbg== Kioq ZGlzdA== bG9u IGhhdGU= c2hhbA== SW1hZ2VWaWV3 ZGF0YWJhc2U= IHBhbmQ= IGxvZ2lj PWZhbHNl Ymc= IENvbmZpZ3VyYXRpb24= IG51cg== T0c= IG1hcnJpZWQ= Ois= IGRyb3BwZWQ= MDQw IHJlZ2lzdHJhdGlvbg== 0L7QvA== dWx0aXBsZQ== aXplcnM= c2hhcGU= LmNvcHk= IHdlYXJpbmc= IENhdGg= IGRlZGljYXRlZA== IC4uLgo= IGFkdm9j IEZhbWlseQ== IHN0YXRlbWVudHM= ZW1hdGlj YW1waW9uc2hpcA== IG1vdGl2 IEhhdmU= IGJsb3c= Sm9i Y2VydA== X3ZlY3Rvcg== aW5zdGFsbA== IENPUFk= ZW1iZWQ= RElS IFNwcmluZw== IGV4aGli MjIz Y2Ru IENvbW1lbnQ= IE9wdGlvbmFs LnBsYXllcg== IERhcms= KHBvcw== IFNob3VsZA== IGNlbnRyZQ== IEd1YXJk w7N3 IHRyb3VibGU= RU5FUg== KHVuc2lnbmVk X3NlcnZpY2U= IG5z dWxpbmc= IE1leGljbw== IE5Z bXlzcWw= IGxpYw== 5Zw= TXI= LWZs IEN1c3RvbWVy aWRp ID8+Cgo= cmlibGU= INC/0YA= IHNpemVz X1NUUklORw== dmFsaWRhdGlvbg== IEpvbg== KEh0dHA= YWRkQ2xhc3M= Tm9kZXM= IGZyYWdtZW50 IHNwb2tl IHdhc3Rl Sm9pbg== IGlsbHVzdHI= ZWxp Y2llbnQ= IGFpZA== IHByb3NlYw== Jyl7Cg== IHBhc3Npbmc= IGZhY2Vz U2hhcGU= X1o= aXRp IGFsbGU= IHJvYm90 ICAgICAgIAo= IFNwZQ== IHJlY2VpdmluZw== IERldGFpbHM= ICIp bWc= X1JFRg== IGNvbXBhcmlzb24= Kiw= IEZvdW5k X3Nlc3Npb24= KFU= L0Y= IHh4eA== TmV0d29yaw== ZGVycw== IGNhcHR1cmU= IGNvcnJl IEx0ZA== IEFkdg== W0A= IGNsaXA= TWlsbA== IFByb2ZpbGU= IGVuZGlm IG9ibGln ZGVzY3JpYmU= LmVsZW1lbnQ= cml0ZXJpb24= TEQ= ZXJlZA== IGZhdm91cg== c2NvcmU= IEZpbHRlcg== YXR0cmlidXRlcw== IGNoZWNrcw== SW5mbGF0ZXI= IFBsdXM= IHNjaWVudGlmaWM= IHByaXZhY3k= SGVhZA== IGZlYXQ= IGRlZ3JlZXM= IFBhbGU= OyI+ IGZpbG1z IEF1ZGlv IFRhZw== IEVuZXJneQ== aXRhcg== cGFyYXRvcg== IGZlbGxvdw== IGV2dA== IFRyaQ== IERBTQ== Y2xvdWQ= IFBhc3N3b3Jk IERlbW9jcmF0cw== IEFjYWQ= JGxhbmc= IHJlYg== KCkpCgo= 0L3Riw== IEJ1cg== cmVhZGNy IGhleA== MjA5 Q29uc29sZQ== Y3Rs b3VzZWw= IFdpbGxpYW0= IGF6 X1BPUlQ= IHByYWN0aWNlcw== IGFueXdoZXJl IFBvc2l0aW9u IC0+Cg== aWFtcw== LnVzZXJuYW1l cGxhY2Vob2xkZXI= IG9kZXI= IFNlY3JldGFyeQ== IGlU bW9uZA== ZXZlbnRz P+KAnQ== LlN1Yg== IGF0dGFjaGVk IG7Do28= IGVzdGF0ZQ== MzY1 LmFjdGlvbg== IGZpZ3VyZXM= IH0pOw0K IHN1YnNjcmk= LnRhZw== bmFt LnBsb3Q= bm9vbg== bGlhbWVudA== Q2hhcmFjdGVy LnRhYg== IHdpbnRlcg== IFZhcmlhYmxl IHRyZWVz IHByb3Vk KFY= X2xvYWQ= IGhpZXI= IEVjb24= IGZk IHZpY3RpbXM= UmVzdA== aWFuYQ== IGZha2U= LlByaW50bG4= IHN0cmxlbg== IHNhZA== IGJsZQ== UHJvdA== IGJ1dHRvbnM= IHRlbGV2aXNpb24= IGxvZ28= ZXh0ZW5zaW9u CWo= c3RlaW4= YWNpb25lcw== ICIiIgoK IHNpbXA= IHJlY29yZGVk IGJyaW5ncw== IHByaW5jaXBhbA== IGZlZXM= KHNvdXJjZQ== a2Rpcg== IHV0aWxz IGNvcnJlY3RseQ== Zmls IHdlbA== UGFpcg== LWJ1dHRvbg== c2NhbGU= dmVyaWZ5 W2M= IC0tLQ== IGVzY2FwZQ== aWtlcw== TG93ZXJDYXNl aWNpYW4= IGNoYXB0ZXI= IFRZUEU= IHNoYWRvdw== IGF3ZXNvbWU= V0U= ZWxpZg== IGxhbWJkYQ== IGRpc3RpbmN0 IGJhcmU= LW9mZg== IGNvbG91cg== LmFwcGVuZENoaWxk b2xlYw== YWdh LmZpbGw= CXN1cGVy IGFkag== KHBvc2l0aW9u LmdldEl0ZW0= MjQy U2hvcnQ= IHRvdGFsbHk= VkQ= IFRyZQ== X2Vw dmVtZW50cw== IFNvbHV0aW9u IGZ1bmRhbWVudA== Rm9sbG93 IGZhY2lsaXR5 IGhhcHBlbmluZw== T0Y= LnRleHRCb3g= U3Bhbg== IMKr aWRlbg== IGV4Y2VlZA== KHBhcmVudA== IGNw 57s= IGhhc24= IHByaQ== IGNvbnNlcXU= bmVu IElOVE8= SWdub3Jl IEZ1dHVyZQ== IGNhcmJvbg== IFN0ZWVs Zm10 b2tpZQ== IHNwbA== KHRpdGxl LWluZm8= IGRlYWxz IGZpeHR1cmU= ZWE= RGl2 IHRlc3RlZA== X3JldHVybg== KQoKCgo= dXBwb3J0ZWQ= IENvb2s= IHBheWluZw== IElsbA== IGFycmVzdGVk IFByaW1l X2NhbGxiYWNr PiwK ZHJpdmVy T25jZQ== YWJi X2J5dGVz IFNldHM= KE9iamVjdA== IGNj IHNoZWxs YWxv KTsvLw== KGxvZw== MjY0 Y3RvcnM= KTwv IG5laWdoYm9yaG9vZA== NDIw YWlsYWJpbGl0eQ== dm9s IHlvdXRo IHRlY2huaXF1ZXM= IFNjaGVtYQ== dWg= bWVudGU= IHJlcG9zaXRvcnk= aW1t IGNvb2tpZQ== SlM= b3ZpZXM= Ons= Q29tcGxldGU= U2luY2U= IGxhdWdo X0JP ZW5hYmxl IERvZXM= IFdhbGs= d2hhdA== a2Vz IG11bHRpcA== aW1lbnRz ZXVy IHZpY3Rvcnk= R2VuZXJhdG9y IE1vcw== cm92ZXJz IGNvbXB1dGU= IHByb3ZpZGVycw== IE1lZGlj TFA= X0NPTkZJRw== IHZldGVy c3RlcnM= X3dpbmRvdw== dW1lcmlj CQkJCQkK LlJlc3BvbnNl IHJlcGxhY2Vk LnJvb3Q= LWZyZWU= LWNvbnRhaW5lcg== IG1hdGNoaW5n IEVkaXRvcg== PSR7 IFNhZg== IHNpbmQ= KGJ1ZmZlcg== 5Yc= LmVkdQ== KV07Cg== IE5GTA== YXlh IGRvZ3M= IGRlc2lyZQ== IE1pZGRsZQ== Q2FydA== MzA2 VGhlbWU= IG1vYg== IGRpc3BsYXllZA== aWdpdA== IGFkdWx0cw== IiIi IGRlbGl2ZXJlZA== dmlzaWJsZQ== Ijp7Cg== PDw8 IEdP c2Nyb2xs eEU= IGFzc2lnbmVk IEJvb2w= IHdw IGNvbWJhdA== IEhhdw== Li0= IHN1cHBvcnRpbmc= LkNvbnRlbnQ= MzQ1 aXJjcmFmdA== IHNwaW4= IENS Lm15 4KU= dHBs IHNwYWNlcw== Pyw= Mzg0 IFN5cmlh IHBhdHRlcm5z LWJveA== IGZyYW1ld29yaw== LyU= KGxvbmc= IHRlYWNoaW5n QVJOSU5H X2tleXM= IHRhYmxlcw== VU5D aW5hdGlvbnM= LXdlaWdodA== cmFkaW8= IFBhYw== LnNlcnZlcg== LkNoYXJGaWVsZA== cmluZw== IHF1b3Rl YW5uYQ== IHdlcmRlbg== IGNyZWFt IG1hY2hpbmVz LWs= Mzc1 IHN0aW0= IFN0b2Nr cmljaw== IGltcG9ydGFuY2U= cng= w7Vlcw== 2Yg= IHN0cm9rZQ== YWdyYQ== IHRhc3Rl IERFQlVH VGhhbmtz IFJlcXVpcmVk b3Zh TWVkaWE= IHNpxJk= KGJhc2U= cG9zdHM= IGZpbGVOYW1l Q2hlY2tlZA== IGludGVycnVwdA== ICgpCg== cHl0aG9u cGFpcg== IGNpcmNsZQ== IGluaXRp X3N0cmVhbQ== IGNvbXByZWg= bGVhcm4= UHVibGlj IGh1bWFucw== IGJyaW5naW5n b2dyYXBoaWM= X2xheWVy LWxpa2U= dXBwb3J0SW5pdGlhbGl6ZQ== aWRlYmFy IHZvdGVz IGRlc2lyZWQ= TWFzaw== IHJlbGF0aW9u Lkluc3RhbmNl SGVscA== IGluc3Bpcg== IE1vbm8= Vmlld01vZGVs b21ldGltZXM= IGJhY2tncm91bmRDb2xvcg== IHJvdGF0aW9u IG1hcmk= L3Rlc3Q= SU5TRVJU U3Rhcg== cGh5 SWRz X0dFVA== IGluY3JlYXNlcw== X2Nsb3Nl MjMz X0ZPUk0= IFvigKZdCgo= YXph VEVYVA== IMOk IFZhbg== IGxpZ2h0cw== IEd1aWRl IGRhdGVz LkNvbW1hbmQ= YW1hbg== IHBhdGhz LmVkaXQ= CWFkZA== ZHg= IHJlYWN0aW9u IEJlYWNo LmdldE1lc3NhZ2U= RW52aXJvbm1lbnQ= aW50ZXJlc3Q= IG1pbmlzdGVy IHJlYWRlcnM= CUY= IGRvbWVzdGlj IGZpbGVk Q2l0eQ== IG1hcHBpbmc= IERFUw== IHJlcGFpcg== dGljcw== aXh0dXJl IG5vbWJyZQ== LklTdXBwb3J0SW5pdGlhbGl6ZQ== em8= LklzTnVsbE9y IENhcm9saW5h IERlcg== IEVWRU5U IGdlc3Q= IGhpc3Q= cmVzb3VyY2Vz IG9ycGhhbg== LkFyZQ== IEludmVzdA== UkVGRVJSRUQ= LkxvZ2dlcg== IFJvbWFu IGN1bHR1cmFs ZmVhdHVyZQ== cHRz YnQ= IGRvdA== IGRpYW0= dXNwZW5k X2FjY2Vzcw== KCl7DQo= IHN1cnByaXNl YWJpbA== IHZpcnQ= IGJvbWI= YXJvbg== X0lT IHZhc3Q= UmVhbA== ZXBlbmQ= aWN0ZWQ= IHBpY2tlZA== IEZM IFJlcHVibGljYW5z Lnplcm9z UHJlc3NlZA== c3Vw LkNvcmU= TWljcm9zb2Z0 c2VydmljZXM= YWdpYw== aXZlbmVzcw== IHBkZg== IHJvbGVz NDAz cmFz IGluZHVzdHJpYWw= IGZhY2lsaXRpZXM= MjQ1 6KE= IG5p IGJh IGNscw== CUI= Q3VzdG9tZXI= IGltYWdpbmU= IGV4cG9ydHM= T3V0cHV0U3RyZWFt IG1hZA== KGRl KXsKCg== IGZybw== aHVz IGNvbW1pdHRlZQ== 7J20 LHg= IGRpdmlzaW9u KGNsaWVudA== KGphdmE= b3B0aW9uYWw= LkVxdWFs IFBoeXM= aW5ndQ== MDMz NzIw IHN5bmM= IE5h fX08Lw== T0xVTQ== aXTDqQ== IGlkZW50aWZpZXI= b3dlZA== IGV4dGVudA== IGh1cg== VkE= Y2xhcg== IGVkZ2Vz Q3JpdGVyaWE= IGluZGVlZA== aW5oZXJpdA== IE5pZ2h0 MzAy IHJlcG9ydGluZw== IGVuY291bnRlcg== IGtpbmRz X3ByZWQ= IGNvbnNpZGVyaW5n Lig= IHByb3RlaW4= VHlw Z3JpY3VsdA== IEJhbGw= QENvbXBvbmVudA== IEVzcw== IFJ1Yg== ODAy dWxw ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== aXR1ZA== LmF0dHI= aWVudGU= IHNwZWxs IEpvZQ== RU5URVI= X2hvc3Q= aXRhbg== IG1hdHRlcnM= IGVtZXJnZW5jeQ== dWF0ZWQ= IENoYXQ= PXsn Y29udHJp YXJrZXI= 5oiQ aXBlcg== IHNjaGVtZQ== KHN0ZGVycg== ICoo Y2VpdmVy LmNvbHVtbg== IG1hcmtlZA== X0FUVFI= IGJvZGllcw== IElNUExJRUQ= R2Fw IFBPU1Q= IGNvcnBvcmF0ZQ== IGRpbWVuc2lvbg== IGNvbnRyYXN0 ZXJ2aWV3 IEVSUk9S IGNhcGFibGU= IGFkdmVydGlzaW5n dXJjaGFzZQ== IFBB IEZyYW5jaXNjbw== IGZhY2luZw== 44CM Z2l0 IGJlZXI= IHNreQ== ZG93bmxvYWQ= IEN1cg== bWM= YW5ueQ== LmZsb29y IGNyaXRlcmlh IHBhcnNlSW50 YCwK IGFzcGVjdA== IGJ1bmRsZQ== Q291bGQ= IHRhbms= LWlk IGh1cnQ= IGJyb2FkY2FzdA== T0tFTg== b3dudA== bnVsbGFibGU= Q2Fw IGFsY29ob2w= IENvbGw= IEhlbHBlcg== IEFm Lm1ldGhvZA== IHBsYW5uZWQ= cGxlcg== IFNpdGU= IHJlc2M= b21lbnQ= IEphdmFTY3JpcHQ= U0VSVkVS IHJocw== ZXJlcw== KCIs aWZp LmZpZWxkcw== IHBhcmtpbmc= IGlzbGFuZA== IHNpc3Rlcg== Xwo= Q29uc3RyYWludHM= IEF1c3Q= ZGlt X3BvaW50cw== IGdhcA== X2FjdGl2ZQ== IHZvb3I= IFBP QmFn LXNjYWxl bGFtYmRh LkRpc3Bvc2U= cnVsZQ== IG93bmVk IE1lZGljYWw= MzAz ZW50cmllcw== IHNvbGFy IHJlc3VsdGluZw== IGVzdGltYXRlZA== IGltcHJvdmVk RHVyYXRpb24= ZW1wbG95ZWU= JC4= QWN0aW9ucw== TGlrZQ== LCg= KFJlcXVlc3Q= JXM= Lk9wZW4= KSIK IHBpeGVs IGFkYXB0ZXI= IHJldmVudWU= b2dyYW0= IExB IE1hY2hpbmU= INin IGZsZQ== IGJpa2U= SW5zZXRz IGRpc3A= IGNvbnNpc3RlbnQ= YcOnw6Nv Z2VuZGVy IFRob3Nl cGVyaWVuY2U= LkJhY2tDb2xvcg== LnBsYXk= IHJ1c2g= IGF4aW9z IG5lY2s= X21lbQ== LlBSRUZFUlJFRA== X2ZpcnN0 Q0I= IFdpZGdldA== IHNlcQ== aGFy IGhpdHM= IOKCrA== IGNvbnRhaW5lZA== cmllbnQ= d2F0ZXI= TE9BRA== IFZpcmdpbmlh IEFybQ== IC4v wrs= X3Jvb3Q= IGFzc2lzdGFuY2U= W10s c3luYw== IHZlZ2V0 ZXNjYXBl aWNlcg== Ym9vc3Q= IEZsb2F0 LVc= Ki8NCg== Kj4= MjE4 ICQoIi4= LnBvcw== IGJveXM= IHdlZGRpbmc= IGFnZW50cw== PSJf IEFybXk= IGhpbnQ= dmlzaW9u IHRlY2g= IENvbm5lY3Q= IGxlZ2VuZA== IEJldA== LkJhc2U= U3ViamVjdA== IGxpdA== UmVtb3Zl ICI6 IEZpbmFs cGVhcmFuY2U= IGlUdW5lcw== IHBhcnRpY2lwYW50cw== IFB5dGhvbg== IGJ1c3k= aWVs dmVydGljZXM= IHRlbXBsYXRlVXJs IENsb3Nl SW1n IENvcnBvcmF0aW9u dGltZXN0YW1w IGV4dGVuZA== IHdlYnNpdGVz IHBvc3NpYmlsaXR5 0L7Rgg== IGvDtg== IG1lYXQ= IHJlcHJlc2VudGF0aW9u MjQx IAkJ X1NUQVJU LmFwcGx5 IFZhbGxleQ== IFN1Y2Nlc3M= SGk= IG5vYg== IElFbnVtZXJhYmxl X3NlbGVjdA== Z2Vv LiIpCg== IHR1cm5pbmc= IGZhYnJpYw== KCIiKTsK IHBlcnNwZWN0aXZl 6Zc= IFNu VGhhbms= O2o= LlBhcmFtZXRlcnM= CSAgICAgICAgICAg IGZhY3Rz MzA1 IHVudA== Lmluc3RhbmNl IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIw== LWVuZA== IEpPSU4= IEhlbg== IHVyaQ== 5ZCN INC90LA= IEluZm8= IGNvbmR1Y3RlZA== IMOl T1VSQ0U= IHdpbmU= Sm9obg== LkVycm9yZg== IEFnZQ== b3VuZGVk IHJlYWxpemU= MzEy IF07 IHN1YnNlcXU= LG0= KFVzZXI= aWFubw== IGFjY29tcGw= aXNw LnN0ZA== 6Yc= IEJlZA== LnNldEF0dHJpYnV0ZQ== QlI= a2VlcA== IEFMTA== IGlzb2w= YW1tYQ== UGFja2FnZQ== IG9jY2FzaW9u LXN1Y2Nlc3M= 0LXQtA== IExJTUlURUQ= c3RyaXA= KCkKCgo= aXN0cmlidXRpb24= Q29sb3Jz ICs6Kw== RGlkTG9hZA== YWxlcg== IHRpZA== IExFRA== IExpbmtlZA== IENhcnQ= KCkpDQo= X1JFQUQ= IGtpbGxpbmc= IFBIUA== ZmVjdGlvbg== IGluc3RhbmNlcw== Y3Y= Ii8+ IHNm IHRheGVz X2xvY2F0aW9u IEJpdGNvaW4= dWFibGU= cmFuaw== aWdub3Jl dHJhY2s= 0LrQsA== IHNob3VsZG4= IE9Q PT57Cg== IGtt IGhlbHBlcg== X2hlYWQ= IFdoZXRoZXI= b2Nv X2Js IHN0YXRpc3RpY3M= IGJlYXV0eQ== IHRvZw== dGlw 64uk IGNzdg== KHNxbA== c3RkbGli d2Vhaw== IGxpa2Vz xI0= IHJlcGVhdA== IGFwYXJ0bWVudA== IGVtcGg= X2VkaXQ= IHZpdA== CXR5cGU= MjE3 RXZlbg== dXRlbg== IGNpcmN1bXN0YW5jZXM= Ymlhbg== IHN1Z2Fy V2luZG93cw== 7J4= IG9ic2VydmVk L2RhdGE= IGNhbGVuZGFy IHN0cmlrZQ== IFJFUw== X3Nj Zm9ueQ== b3JlbQ== KHo= cG93ZXI= ZXRlY3Q= IFNhdA== LmRlc2NyaXB0aW9u IGdhbmc= IFNwb3J0cw== b25ncw== IEJ1bmRsZQ== LnN1bQ== b25jZQ== IGFjY3VzZWQ= IGV4cGxvcmU= IGFwcHJveGltYXRlbHk= IGxvc2luZw== dGhlc2lz IEZ1bmQ= IGRpYWdu QXV0b3dpcmVk cHJvcGVydGllcw== IF8u IGNudA== Y2VkdXJl IHl5 IGdyYW50 c29jaw== LmlubmVySFRNTA== IF0pOwo= IENPTkZJRw== PSck NTUw XV07Cg== VU5E IGdsb2I= IGRpcmU= dWZmbGU= X01FTQ== IGF1dGhlbnRpYw== Pigi IGRlY2FkZQ== IEltcG9ydA== IG9yaWdpbmFsbHk= IGpRdWVyeQ== IGluZGljYXRl IG91cnNlbHZlcw== U3c= LmxibA== ZW5lcmF0ZQ== IGJhc2ljYWxseQ== IEhvbQ== ICsjKw== IEJyaXRhaW4= IEthcg== dG9FcXVhbA== LnN0b3A= IG1vZGFs aXNp IHN1Z2dlc3Rz IGR0eXBl IHR1cg== YmY= IGNvbm5lY3Rpb25z IEJlZm9yZQ== aXN0ZWQ= bW91c2U= IHB1bGxlZA== LmJ1aWxk IGxlZ2lzbGF0aW9u IGZvcnRo cGFk ZWdv Lk5vdw== IGV4Y2l0aW5n fQoKCgo= IGNvbXBy IHNoYXJlcw== IHJpZw== Z3JlZW4= X3ZlYw== IGVudW1lcmF0ZQ== QXV0bw== aWNhdG9y IFJheQ== YXNzZQ== IGhvbGlkYXk= IG51bGxhYmxl Z3Vu X2RldGFpbHM= IHdyYXBwZXI= c2Vx IFlvdW5n anVhbmE= ICJfXw== bGljZW5zZQ== c2VydmU= Xig= aWRlcnM= LlJlbW92ZQ== cm9wZG93bg== J1M= cGlu KHRva2Vu LkRlZmF1bHQ= IHJlYXNvbmFibGU= YW1waW9u IFNvY2lldHk= IGJlaQ== ZXJ2ZXM= cmFk IEZveA== X2ltYWdlcw== IHdoZWVs Jylb IGNmZw== KEJ5 Q29uc3RydWN0b3I= IHZhcnk= LnN3aWZ0 IHByb3h5 CUg= IEFub3RoZXI= IFBlbg== IGNoZWNraW5n IGplc3Q= bWFuYWdlcg== T3JpZ2lu dWdz b2ly PjwhLS0= IGV4cHJlc3NlZA== IG1vZGVy IGFnZW5jaWVz IGlo LWhpZGRlbg== aW91c2x5 IFJvZA== IHNvbGU= TWVk LkFueQ== IHBj YmFs RXhhbXBsZQ== IFNhbGU= IHN0cmlw IENvbXA= IHByZXNpZGVudGlhbA== TW9zdA== cHV0YXRpb24= KHJlZg== IEZvdXI= X2ZpbGVuYW1l IGVuZm9yY2VtZW50 2K8= IEdlb3Jn d2VpZ2h0cw== L2w= IGFnZ3Jlc3M= IGRyYXdpbmc= YW5keQ== PEk= LWo= YWth aHJlZg== IHRlYWNoZXJz X1E= KGl0 IE1C IHRlbXBvcmFyeQ== aXJlYmFzZQ== c3RyYQ== 5pe2 6LQ= KGxhYmVs b3Vw IHRvcGljcw== IHBvcnRpb24= aWRvcw== IEpld2lzaA== IHJlY292ZXJ5 NjUw IHN0YW5kcw== I1s= IGFmdGVybm9vbg== IEFydGljbGU= X2F0dA== IGV4cGxhbg== IFBhaw== LnNldE9uQ2xpY2tMaXN0ZW5lcg== LmNoaWxkcmVu IGlr Kyg= bGFn IGRpc2s= IGNvbnRyb3ZlcnM= Ij4m YXNw IHdpZQ== IEF1c3RyYWxpYW4= IFlvdVR1YmU= QXR0cg== Y29udGFpbnM= ZHVjZQ== IE1hdHQ= MzQw YXRlcm4= IHZvbHVudGU= IG5ld3Nw VlA= b2x0aXA= IGRlbGVnYXRl X21ldGE= IGFjY3VyYXRl IEV4YW1wbGU= JSw= IERhaWx5 IGNhYmlu IFNX IGxpbWl0cw== a2lw IGFybXk= IGVuZGluZw== IGJvc3M= IERpYWxvZw== QWxzbw== PSIjIg== b3JkYW4= cm93c2U= LW1pbg== ICIm X2xvYw== VVg= IGRldmVsb3BlcnM= IGFjY3VyYWN5 IG1haW50ZW5hbmNl IGhlYXY= IGZpbHRlcnM= LlRvb2xTdHJpcA== IG5hcnI= IEVtcA== T1JERVI= IE1vYmlsZQ== LlNlcmlhbA== Lm91dHB1dA== MjQ0 LmNvbA== TWF0ZXJpYWw= dW1h IGNvbnN1bWVycw== c2hpZnQ= IHB1ZWQ= IG1pbmk= Y29sbGVjdGlvbg== IGthbg== LmNlbnRlcg== SGlzdG9yeQ== IGJlbmNo KCkpOw== aXRvcmllcw== IGNyb3dk X2NhbGw= IHBvd2Vycw== LUU= IGRpc21pc3M= IHRhbGtz IENoYW5uZWw= Zm9yd2FyZA== X2NvbnRyb2w= L3NyYw== aWVzdA== KioqKioqKioqKioqKioqKioqKioqKioq IGJldGE= KGNvbG9y X09CSkVDVA== IEFwaQ== IGVmZmVjdGl2ZWx5 Q2FtZXJh c2Q= dXNzeQ== Mjkw RGljdA== IEVmZmVjdA== aWJpbGl0aWVz IHJldHVybmluZw== IEZhcg== ICcnKQ== IG1vZHVsZXM= MjE5 aWxhdGlvbg== ICgl VFJHTA== IHN0b3Jt b25uYQ== IEVYUA== IHNwb25z IGRpc3Bs ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg ZmFsbA== 5Yw= aWduS2V5 X1VT ZXRyaWNz IGhhbmRsZXM= VEw= X2Ftb3VudA== b3dh YnJhbmQ= IFRvb2w= IHVzdWFs Llo= Y3JlbWVudA== YWRpdW0= c3RvY2s= IHNlcnZpbmc= IEJvbg== IGxpbmVhcg== IFRhcmdldA== IFJhZGlv SEw= U2hhZGVy b21hdGlj YWd1ZXM= aW5pdHk= ZGlmZg== X2l0ZXJhdG9y cXVvdA== ICwK Y2FsbGJhY2s= IHN5bXB0b21z W18= IEJ1bA== IEZlYg== dW5kbw== X2FjY291bnQ= IHR5cGVkZWY= 0LjRgQ== dHJhcw== VXNlcklk IFBlbm4= IFN1cHJlbWU= fT4= dXNlcklk MzI3 IEtpbQ== IGdh IGFydGlzdHM= 5bg= IEFic3RyYWN0 b2tlbW9u IGhhbQ== b3ZhbA== IGNoYQ== YXRlbg== 5YY= Rml4ZWQ= IHZ1bG5lcg== IFBhcmFtZXRlcnM= cXVhbnRpdHk= LkNsZWFy U2VydmxldFJlcXVlc3Q= IHlh IHNvdWw= MDgw dHJhbnNhY3Rpb24= IHNvbG8= IHBhaXJz 5pQ= IEdyZQ== X3dvcmQ= IEND IGdp emll IHNjaGVkdWxlZA== cm90YXRpb24= Z3lwdA== dWxvdXM= Ojpf IEVsbA== PCE= CQkgIA== bHA= YWhh Q29weXJpZ2h0 MDA5 IGRyYW0= MjUx IGRpYWdyYW0= IE1lbQ== IGdhcmRlbg== Q29tcA== IGF0dGVtcHRz dWZmaXg= Pigp IHBoaWxvc29waA== X3JlbA== 5bw= IHN2 LnNlY29uZA== YW50bw== Lkpzb24= IFRlbGU= X2xvY2Fs X3NlbmQ= IGFzcGVjdHM= 7Jc= SUJMRQ== IHJhaWw= IHdpZGVseQ== YXNoZWQ= aWFy aW5m dXBwZXI= ZGphbmdv X3Jlc3VsdHM= aXNzaW5n IGVxdWl2YWxlbnQ= T1VORA== IHR5 IHBvdGVudGlhbGx5 QWR2ZXJ0aXNlbWVudA== MjM4 IFJlY29yZA== Mzgw cmVzZW50YXRpb24= X3dpZGdldA== b3VuZGluZw== IHJlbGlnaW9u IGNvbnNj IExpbQ== LmFt SHRtbA== ICc6 UEFUSA== X3NwZWM= b3J0ZWQ= aWRhZGVz X3NoYXBl IGtlZXBz LlNhdmU= IExvYw== b3Jp IFRFU1Q= dW5pY2lw IHJlZ2lvbnM= IGJlbGlldmVz L2Vu cG9zaXRl eyc= cHJlcGFyZQ== X2NvbnN0 c2FtcGxl IFdpbGxpYW1z IHN0cnQ= X0dldA== IEFuZHJldw== LmFjdGl2ZQ== IGxheWVycw== VmlzdWFsU3R5bGU= YXp5 IEtu IGFjaWQ= IEFzaWE= IGV4Y2Vzcw== CW15 IGtleWJvYXJk ZW5zdXM= IGNyZXc= IG1pc3NlZA== bWFzdGVy IFdpbGQ= IG5ld2x5 IHdpbm5lcg== IHN0dWI= aWNvZGU= Lm1vdmU= RG9tYWlu IFNhcg== IGZvcmVzdA== TEVE Y2xhaW1lcg== LmV4aXQ= IFdpbmRvdw== IHJlc2lzdGFuY2U= IENIRUNL KCIt IFJ5YW4= IHBpcGU= IGNvYXN0 REVG Ly8h X29mZg== ZXhpdA== IHVsdGltYXRlbHk= aW1pdGl2ZQ== IEtlZXA= IGhpc3RvcmljYWw= IGFueXdheQ== IEphY2tzb24= b2NrZXI= RVJO IFVJTlQ= eW50YXg= RVJZ aXNtcw== IGNu IG9jY3Vycw== IDs7 VGV4dFZpZXc= QUU= L2ltZw== IHllc3RlcmRheQ== LWRlZmF1bHQ= IHRpbnk= IHByb2M= IGFsaXZl IFJFRw== LnRo ZWFyaW5n LmdldExvZ2dlcg== PGxpbms= X2xvZ2lu Rm9sZGVy YWJj bHlwaGljb24= 0L3Qvg== IG5vdGljZWQ= b2RpZ28= IGVkaXRpb24= aW1hdG9y LkVuYWJsZWQ= LnBhcnNlSW50 IHlhcmRz CQkJCQkJCQkJCQkJ IHZlcmJvc2U= 0LvRjw== X0JZ LmxvZ2lu Lio7Cg== IE1pZA== w6llcw== IGdsbw== IGJ1aWxkaW5ncw== IHpl IEl0ZXI= IHR1YmU= IFBvdA== XE0= MjUz PHRo YnJpZGdl IFNjcmlwdA== IE1vZHVsZQ== IHZhY2M= IGluc3RhbGxhdGlvbg== dnk= VmlzdWFsU3R5bGVCYWNrQ29sb3I= IFNN LnRvdGFs NjQw YmF0 IGZpbmRz IGF0bW9z U3Vidmlldw== aXphcmQ= IHJlcGxhY2VtZW50 bGljYXRlZA== YXBpcw== IGxvZ2dlZA== IExlZnQ= R3Vp X1R5cGU= dG0= UGFk IGhvdXNlaG9sZA== IHJlbGU= IHByb3Bvc2Fs X0NMQVNT MjQz Ojo6Og== IGluZnJhc3RydWN0dXJl SW5qZWN0 L2h0bWw= MjI2 IGFkcw== aXp6YQ== IG1n Y3RyaW5l JQo= PGh0bWw= LWltYWdl IGF0dG9ybmV5 PG0= KCcs IGNhbm4= IHByaW50bG4= b29zZQ== IHllbGxvdw== LmV4cA== cGF5bWVudA== IHRhYmxlVmlldw== YXdheQ== IG9wcG9zaXRpb24= IEFnYWlu IEhhbmRsZQ== IGV4Y2x1c2l2ZQ== aW5hcg== w6ly 0L7QsQ== IENPREU= ZW1wb3Jhcnk= IHJlYWN0 cGlwZQ== MjM2 Y3o= LmFjdGl2aXR5 IGxhcmdlbHk= IGRpc3M= YXh5 ZXNpcw== IFJlbg== IGNvcm4= LlVzZVZpc3VhbFN0eWxlQmFja0NvbG9y ZGF5cw== IGZydWl0 SW5zZXJ0 X2VuYw== RXN0 X2RlYw== IEx1Yw== IMO8YmVy cGFyYW1ldGVycw== UEVSVA== ZXhwcmVzcw== X3Byb2ZpbGU= VW5rbm93bg== IHJldm9sdXRpb24= LmFkZHJlc3M= X3JlcXVpcmU= IHVuaWZvcm0= IFBhY2s= bGFy IFVJVGFibGVWaWV3 IGRlcGVuZHM= VmFsaWRhdGlvbg== Y29uZmlybQ== T3duZXI= IHRyaWI= aGV0 IElkZQ== YW5zYXM= MjQ3 TGFuZ3VhZ2U= dWV0 IFBv IFN0ZXZl IGNvbnRlc3Q= X0RFRkFVTFQ= IGFwcGFyZW50bHk= UkVFTg== IGZyZXF1ZW50bHk= IHRyYWRpdGlvbg== b2NvbGF0ZQ== U0k= IEFyZ3VtZW50 Rm9jdXM= ZXJ0ZQ== IExheW91dA== IGR4 IGdlbmVyYXRvcg== IFdhaXQ= UG9saWN5 bGlnaHRz LkV4ZWN1dGU= NTU1 UHk= IGJlZHJvb20= ZWRh cmFpZA== CXNpemU= IGFuY2llbnQ= IHB1bXA= IGR3 ICghKA== IHNwZWNpZnk= KHN0YXR1cw== IEZCSQ== LmV4Y2VwdGlvbg== IHJlbWFyaw== bHltcA== YW50ZWU= VXBsb2Fk ZXJuZXQ= 6aE= aW5lbnQ= IFJlbmRlcg== ZG0= IE1lbW9yeQ== cmljaA== IFRvb2xz IGtuZQ== IHBlcm0= YmFk IGRpbm5lcg== LnJlc2V0 IGpMYWJlbA== RmVhdHVyZQ== LlNlcnZpY2U= ICh7Cg== IHJlZmVycmVk LmNsYXNzTGlzdA== MjQ4 IGluaXRXaXRo IFRleHRWaWV3 IG5laXRoZXI= IGNvdW50eQ== ICJ7 56c= IHRhY2s= Y2xhc3NOYW1l IFVTRVI= IHJlbmV3 YGA= Z2V0TmFtZQ== IGJyb3du RXJyb3Jz ZXJ0bw== IHN1c3RhaW4= U08= bGV0ZXM= IEludmFsaWQ= MjQ2 MjI3 IGVuZW1pZXM= dW5nZQ== IGV4aXN0ZW5jZQ== ZXJyYQ== CiAgCg== dXRvcmlhbA== I2E= cGF5 Y2hhcmdl IElyZQ== YXRlc3Q= IGV4cGxvcw== IGZpcmVk TkVS IFR5 aWNpb24= VXJp IG9idmlvdXNseQ== IENvbHVt ICcr IERldmljZQ== LXJlbGF0ZWQ= X0FSRw== IHZvcg== IExlc3Nlcg== X09Q U2VyaWFsaXplcg== IHVwZ3JhZGU= TGlnaHQ= IGNvZGVz Kys7DQo= IHdyaXRlcw== Zm9vZA== IMOpdA== QHNlY3Rpb24= IHRyYWNrcw== IHNlcmlvdXNseQ== Y2h0 NDMw KHNpemVvZg== IGltbWVkaWF0ZQ== IHNjaWVudGlzdHM= IHsk X25l LkFuY2hvclN0eWxlcw== IGFjY29tbW9k IEhhcnJ5 IHNpZ2h0 IFBhbGVzdA== ZXJzaXN0ZW50 INGD LWlucHV0 IGNvb3JkaW5hdGVz wrc= MjI4 V2VsY29tZQ== LmNvbmY= IGdyZXc= IGJvbGQ= IENQVQ== KG15 IHBlcmZlY3RseQ== IG1vbWVudHM= IE1vdmll LWRhdGE= eXN0YWw= X1dJRFRI MjYy IFNjcmVlbg== 5p0= IGRpc2Fw IHJlZHVjdGlvbg== LkdldENvbXBvbmVudA== X01PRFVMRQ== IGdlbmVyaWM= IGR5 YWxsZXI= IGN1cmw= IEJvZHk= IGJhbmtz LHQ= YXZn IGV2aWw= IG1hbnVmYWN0dXJlcg== IHJlY2VpdmVy Q29sdW1ucw== IGluZ3JlZGllbnRz CW91dA== cXVlcw== LkxvYWQ= IHNsb3dseQ== IFRvd24= IENlbGw= X25vcm1hbA== X3ByZWZpeA== IEFsZXJ0 KCJ7 w6Ry 4oCcVGhl IE1E IGNvdXJzZXM= YXRoYW4= 6Zk= b2Nj IFNFUg== ZXNpZ24= QWRkcg== PVsn KCIuLw== XX0= LmZvbnQ= IEluc3RhZ3JhbQ== IEJvcmRlcg== b2Rh IGhhbGw= IHJ1bQ== X2JpdA== IHNhdmluZw== X2Rvd24= UmFuZG9t X3JlZ2lzdGVy KENvbnRleHQ= IG9wcG9zaXRl Um9vbQ== WUVT 0LDQvdC4 IGVuam95ZWQ= X3J1bg== Q2xlYXI= 4oCY IEZvcmQ= b25pYw== b3N0ZW4= Il0p X2F1dGg= Ly8NCg== IHN1ZmZpY2llbnQ= TEVT IHBoZW4= IG9o X2Nzdg== IHJvdXRpbmU= LkFyZUVxdWFs YXlsb3I= IGJhc2tldA== X0NPTU0= cnlwdGVk U2lt IFNob3A= IHN0dWRpbw== YXRvcw== KFc= W3N0cmluZw== w6R0 b2dh IHNocg== IHNpY2s= QW5vdGhlcg== IGRvb3Jz X05F IFRIUkVF Lm9yZGVy cmF6aWw= IG1hcHM= X1RSVUU= dHJhbnNsYXRl IG5lYXJieQ== MjY1 IG5hY2g= TE9BVA== YmF0Y2g= MjI5 IGx1eA== YXNoZXM= YW5nZXJz 4oCm4oCm X0VWRU5U X1VQ IGFjdHM= aW52 X01FVEhPRA== Y2Npb24= IHJldGFpbg== dXRjaA== INCx IGtub3dpbmc= IHJlcHJlc2VudGluZw== Tk9U cG5n Q29udHJhY3Q= IHRyaWNr IEVkaXRpb24= dXBsaWNhdGU= IGNvbnRyb2xsZWQ= Y2Zn amF2YXNjcmlwdA== IG1pbGs= V2hpdGU= U2VxdWVuY2U= YXdh IGRpc2N1c3NlZA== NTAx IEJ1c2g= IFlFUw== LmZhY3Rvcnk= dGFncw== IHRhY3Q= IHNpZA== JCQ= IEVudW0= Mjc1 IGZyYW1lcw== fSk7 IHJlZ3Vs J107DQo= UmVnaW9u MzIx ZmZm IGNybw== KGNvbQ== PSIr U3R1ZGVudA== IGRpc2FwcG9pbnQ= UkVTVUxU Q291bnRlcg== IGJ1dHRlcg== IEhh IERpZ2l0YWw= IGJpZA== Ij57ew== aW5nZXJz IENvdW50cnk= X3RwbA== Il0pCg== L2s= ZGF0aW5n OiM= IERBVEE= eW5jaHJvbg== X2JvZHk= b2xseXdvb2Q= IHZhbG9y aXBpZW50 b2Z0 VUJM ZG9jcw== IHN5bmNocm9u IGZvcm1lZA== cnVwdGlvbg== IGxpc3Rh UmVxdWVzdE1hcHBpbmc= IHZpbGxhZ2U= IGtub2Nr b2Nz Ins= X2ZsYWdz IHRyYW5zYWN0aW9ucw== IGhhYml0 IEpl ZWRlbg== IGFpcmNyYWZ0 aXJr IEFC IGZhaXJseQ== LmludGVy LkFjdA== IGluc3RydW1lbnQ= cmVtb3ZlQ2xhc3M= LmNvbW1hbmQ= 0Yk= CW1lbQ== KG1pbg== IG90 IGNvbGxl PXM= dGltZW91dA== IGlkcw== IE1hdGNo aWpu emVybw== NDEw IG5ldHdvcmtz Lmdvdg== IGludGVs IHNlY3Rpb25z b3V0aW5l KGNtZA== KGRpcg== IExJQUJJTElUWQ== IEJsb2c= IGJyaWRnZQ== MzA4 IENW Y29udmVydA== ICIpCg== IEJlcm4= X1BP ZXZhbA== KHNldA== dG9vbA== IHBheW1lbnRz QmVoYXZpb3Vy IGNvbmNyZXRl IGVsaWc= IGFjY2VsZXI= IGhvbGU= X28= VEVHRVI= IGdyYXBoaWNz T3du Rm9ybWF0dGVy b25kZXI= IHBhY2thZ2Vz L2E= IEtub3c= T3JEZWZhdWx0 IGR1dHk= V2FpdA== 0L3QsA== X3JlY29yZA== W3Q= TWVzaA== IG9uZ29pbmc= LmJlYW5z IHRhbg== IGludGVycHJldA== YXN0ZXJz UVVBTA== IGxlZ3M= XFJlcXVlc3Q= LWZpbGU= X211dGV4 IFNhaW50 Ly8j IHByb2hpYg== KGluZm8= Oj0= bGludXg= IGJsbw== b3RpYw== CWZpbmFs X2V4cA== IFN0b3A= YXBpbmc= KHNhdmVk X3B1c2g= IGVhc2U= X0ZS cG9uc2l2ZQ== c3RyY21w OgoKCgo= 5Lu2 b2xp IGV4dHJlbWU= IHByb2Zlc3Nvcg== SW1hZ2Vz LklPRXhjZXB0aW9u IGFkZHJlc3Nlcw== cGxlbWVudGVk IGluY29ycG9y IHVzZUVmZmVjdA== X09G IERh bm9tYnJl SVJTVA== IGRpc2NyaW0= IGNvbXBlbnM= Z3JlZ2F0ZQ== YW5jZWxs YWNoZXM= IENyaXRlcmlh JHJlc3VsdA== RGVzdHJveQ== IHNlY29uZGFyeQ== V2F0Y2g= IFNlbQ== IE1jQw== IGFjYWRlbWlj VXBwZXI= Ojp+ dXRyYWw= IERvZw== YWRlZA== MjM3 VmFsaWRhdG9y IGRlcml2ZWQ= IHNldFRpbWVvdXQ= IEtlbg== IHR5cGljYWw= IEJvYg== IGJvdW5kcw== IFNlYXNvbg== IGNyYXp5 ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg LXJvdXRlcg== aXR0ZXN0 IE1pcg== IGVtb3Rpb25hbA== LHY= Y24= L3N0 5b0= b25vbQ== IGRlY2xhcmVk Pi4= YWlsaW5n IC8qPDw8 IG5vcm1hbGx5 KE1l ZXZpbg== bGlrZWx5 IHBvaW50ZWQ= IFN0YWNr IHdhbGxz LlZlY3Rvcg== bWVhbg== XV0K IGxpc3RlbmluZw== YWR2 IHN3YXA= SUZU 2Ko= LmFyZ3Y= dWxz PG9wdGlvbg== bm90YXRpb25z IGVtYWlscw== IFVrcg== YXN0YQ== IFRodXM= IFN0b25l IGFwcGVhbA== LuKAmQ== IHJlZ3VsYXRpb25z UHJlZmVyZW5jZXM= IFBob25l dWxm IERS IHRlY2hub2xvZ2llcw== IHBhcmFncmFwaA== IG5lY2Vzc2FyaWx5 Mzcw MDMw LmVhY2g= PGZsb2F0 cmVzYQ== IHVuZGVyc3Q= IGZpbmdlcg== cHJlc3NlZA== LWJ5 aWZmZXI= d2F0Y2g= IEJh QUlN IHdlaWdodHM= IFJvbg== Jyl9fQ== W3NlbGY= LS0tLS0tLS0tLQo= cGVyaW1lbnQ= IHRvU3RyaW5n eGlj IENhbWVyYQ== IQoKCgo= YXVyYW50 UHJlZml4 IGluc3RpdHV0aW9ucw== OmludA== IGV4cG9zdXJl cGF0dGVybg== IExpbnV4 Lm51bWJlcg== cmVkaWVudA== QXJndW1lbnRFeGNlcHRpb24= IENoaWVm In0s IGVsZWN0cm9uaWM= cm9uZw== ZXJk c3BOZXQ= cmFpdA== Lycs IE9oaW8= Q29udHJvbGxlcnM= IGNvbnRpbnVpbmc= IFRlbXBsYXRl IEV0aA== c3o= L2Vudg== RW52 JS4= YXJ0ZXJz KSgo IFRBQkxF IMOu cGVyYXR1cmU= cHJvZ3Jlc3M= UHJlcw== 6rA= aW1wbGVtZW50YXRpb24= IGJpZW4= IHN0cmVldHM= X01TRw== TmV3cw== IyMj Oi8= IGN1dHRpbmc= eEI= cmVzc2Vk X0VOQUJMRQ== bGFi IGNhdXNpbmc= XSkpOwo= YnJh eEZGRkY= aWxseQ== cGxldGlvbg== d2lsbA== X2Jhcg== IHN0cnVjdHVyZXM= IEltcA== 24w= IDw+ IC0tLS0tLS0tLS0tLS0tLS0= X0JVRkZFUg== LmRpcg== IHBsYWlu IHBlZXI= MjQ5 Z2c= b2ludHM= IHNvbWV3aGF0 IHdldA== IGVtcGxveW1lbnQ= IHRpY2tldHM= aXJtcw== IHR1cGxl c2lz JHNxbA== cmln IGNvbnZlcnNpb24= IGdlcw== IGNvbmZpZ3VyZQ== ZWdy IENh IF9fKCc= b3VzdG9u LnRva2Vu QmxhY2s= IG1hZ2F6aW5l QVc= LklO b3Npbmc= IGJyb2tl IENydQ== REVMRVRF IGRlc3Ryb3llZA== KE1hdGg= IGFwcHJvdmFs LWRvbQ== IElJSQ== dGFibGVWaWV3 IGRlc2lnbnM= IGNydXNoaW5n IGNvbnNlbnQ= ZGlybmFtZQ== b21w IGNyeXB0 Pyg= b3JvdWdo MzA3 Lm8= CWxpc3Q= YW1zdW5n LiIiIgo= ZXJyaW5n R29vZ2xl X3BhaXI= X0lOSVQ= cmVtYXJrcw== IGdlYXI= RmlsbA== bGlmZQ== fSIpCg== IHN1aXRhYmxl IHN1cnByaXNlZA== X1JFUVVFU1Q= IG1hbmlmZXN0 YXR0ZW4= IGZydXN0cg== b3ZlbWVudA== LmNsaWNr IGlp IGV4cGFuc2lvbg== aWdz UGFyc2U= LlJlZ3VsYXI= Um9i X2xheW91dA== 7KA= IHRyYW5zbGF0aW9u IEJlYXV0 QmVzdA== X0NPTE9S PGxhYmVs IGxpcXVpZA== SVRT IHByb2Q= MjM5 IG9wZXJhdGU= VUlLaXQ= IG5hdHVy YXJndW1lbnQ= X2RldGFpbA== IENlbnRyZQ== ICItLQ== IH19Ig== bG9jYWxl LnR2 X3NlcQ== IHVwY29taW5n Q2hhcnQ= IERpdmlzaW9u IGNsaW5pY2Fs Q29tcGFueQ== U2VwYXI= bGFz IEh1bg== OnM= IGhlYWRpbmc= 0L7Qsw== ICIiKTsK W2lk Ymlh IHN0cmV0Y2g= aWNpZGU= IHJlcHJvZHU= LnByb2plY3Q= bGVnZW5k ZW5kZXJz IHJlc3BvbnNlcw== IG9udA== cml0aWNhbA== IHJlZnVnZQ== IExp IDoKCg== IFRocmVl LmNvbnRyb2xsZXI= X0lOREVY X0ZPUg== XE1vZGVscw== amF4 CWV4aXQ= IOKW IGNvdmVycw== CXk= LS4= SU5ET1c= IGZhaWxz aW5jbHVkZXM= IGZhdWx0 NDQw IGx5 NDQ0 w7Fv LnNsaWNl SUxFRA== IFB1cg== IEFzaWFu X2JhdGNo Lk1heA== dmw= IENPUFlSSUdIVA== IGdpYW50 IE1hbnVhbA== IENvcHk= Q2xhc3NOYW1l SGVhbHRo Q3Vyc29y SUJPdXRsZXQ= IHR3ZQ== 5rM= X2xhYmVscw== IGNvbGxlY3RlZA== IGZ1cm5pdHVyZQ== IGRlYWxpbmc= Q29udHJvbHM= IEhvdGVs Y2tz IGNob3Nl 4pSA b2Rk U1I= 2Yo= 7IQ= IGFjY29yZA== IE1vdmU= IE1vZGU= IE1vY2s= IHRocmVhZHM= KysrKw== IE9wdGlvbnM= UmVmcmVzaA== IERpZA== J10tPg== dWNj X2NoYW5uZWw= LmFicw== IHt9LAo= IFdhbA== ZXJpb3I= IG1haW5seQ== IERyaXZlcg== Tm90Rm91bmRFeGNlcHRpb24= IGNvdW50cw== ZWFt ICY9 UXVlc3Rpb24= IEFsaQ== IGFueW1vcmU= ZGV0YWls dGFpbA== IG1pbGU= IEZhaXI= IHNvcnJ5 IHN1cnJvdW5kaW5n IGFkbQ== RGV2 IG1hcmlqdWFuYQ== IFNvdW5k IEFzaA== RkQ= VGVhbQ== LnBvcnQ= IFtdCgo= dWJibGU= IGFzYw== IGludGVudGlvbg== QWNj Y2hp dXN0ZXJz IGluc3BpcmVk c2Vn Q0xV IG1hbmlw TWV0YWRhdGE= Q29ubmVjdA== IEJlaA== IGZpbmRpbmdz IGFzc2VtYmx5 d29ybGQ= IHJlbWFpbmVk IHVpZA== KC4= IG14 TG9vcA== CgoKCgo= IGZhbnRhc3RpYw== d2hv YWtp IEJhc2lj IFlldA== IFVzZXJz aWtpcA== IGhlYWRz IE1pY2hpZ2Fu X2l0 IFRvcm9udG8= IHJlY29yZGluZw== IHN1Ym1pdHRlZA== X3ZhcmlhYmxl bWVkaWF0ZQ== LmdyYXBoaWNz IHN0b29k IHJlYXI= dmVsb2NpdHk= X01FU1NBR0U= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg cm9sZXM= IFRvdXI= X3llYXI= ZW5kbWVudA== YW1wcw== IElyZWxhbmQ= bWFs IHlvdW5nZXI= IHN0cnVnZ2xl IGNhYmxl IFNETA== KCct YW5lcw== IE5lZWQ= LlJvdw== UG9s IFBI X3NjcmlwdA== YWdlbQ== IEJhcw== X3NwYWNl LmxvYw== Omk= YWRy IGVuZ2luZWVyaW5n aXRlbg== KSY= IHVr IExpdHRsZQ== X0NPVU5U eEE= QXJyYXlMaXN0 5o0= ICIiKQo= QW5jaG9y IGhhbmc= dHdpdHRlcg== IGNvbXBldGl0aXZl LnNyYw== 44GX IHRyYW5zbGF0ZQ== IENyZWF0ZXM= b29rcw== IFJvbGw= JycnCg== L3No c29tZQ== RW5jb2Rpbmc= LnJlc29sdmU= IGRlc2lnbmVy IFN0b3JhZ2U= IHph IE5ldmVy IHNvbWV3aGVyZQ== IGJveGVz LnNvdXJjZQ== IHB5Z2FtZQ== IGdyb3du LnR3 KCkpLAo= JyxbJw== IG9wcG9uZW50 KHNyYw== LmxheWVy QVBQ IEFjdGl2 IGd1ZXN0cw== IFZBTFVFUw== fTsKCgo= Lm5hdGl2ZQ== IGFtb3VudHM= LlJF IGNsb25l IHdlcmVu ICI8PA== X2Fj IGJyZWFraW5n IHJlbGlhYmxl LlBPU1Q= IFNreQ== ICcm IHNhdmVkSW5zdGFuY2VTdGF0ZQ== YXN0aW5n aWxsaW9u Y29tbWVudHM= dWx0eQ== Lm1lbnU= L2NvbmZpZw== IAoKCg== VE9ETw== IHB1cmNoYXNlZA== X2Nvcg== CWF1dG8= Q29tcGF0QWN0aXZpdHk= Y29tcGxldGU= X2dyYXBo aXNvZGVz IHNpdHVhdGlvbnM= IEhvcg== UmVjZWl2ZQ== 4oCcV2U= IGVudGl0aWVz LmFzc2VydEVxdWFscw== 0L7Qug== IFNhbnM= dmluY2U= cm9tcHQ= PQo= IC8u LlNlbGVjdA== eWx2 IGJhdHQ= QXVkaW8= IGluY3JlYXNpbmdseQ== LkJ1bmRsZQ== IGV4cGxhaW5z MDYw dGhlYXN0 Lm9mZnNldA== IGhhbA== IHRlY2huaXF1ZQ== X2xpbWl0 IGRyYXdu QVlFUg== IGZlYXR1cmVk eXl5eQ== YXRpbg== cGhlbg== YWNoZWw= IVw= bG93ZXI= IEdS IHBhZw== IFBhcnNl IHRvdQ== 5LiA RGlzdGFuY2U= SW5kZXhQYXRo IGhlbGw= c2lt VVRUT04= VXNhZ2U= ZWxlbml1bQ== IEZhbGw= ICIuJA== IE11 IGNydWM= IHNvbnQ= UkVGSVg= MzEx IGludGVyaW9y IE9seW1w LkF1dG9TY2FsZQ== cGFyYQ== QXhpc0FsaWdubWVudA== IHJpdmVy RHRv IHdpdGhkcmF3 UmVhY3Q= LWNsYXNz YmVmb3Jl X2FsbG9j Q29udGVudHM= IFdhcw== SUNU IGZvcm11bGE= IGluZGljYXRlcw== ICAgIAoK X3N0b3Jl aXR0aW5n IEl0YWxpYW4= X1NldA== X3JlcG9ydA== IHBpZA== X1ZFUg== IHdpbnM= IENsb3Vk Iil7Cg== Y2hlc3Rlcg== IGRlbmllZA== IHdpcmQ= IFN0ZXA= IGludmVzdG9ycw== Ym9sZA== X2Rpc3BsYXk= b3V2ZXI= b3Jlcg== UmVzZXQ= IHN1cmdlcnk= IHN0cmF0ZWdpZXM= L21hdGVyaWFs X3VuaXQ= IGNvdW5jaWw= LlBlcg== IOKAng== IHJlZm9ybQ== RnJhbWV3b3Jr IGxpc3Rpbmc= X2J0bg== IGJpcw== JWQ= ZWdhcw== IHN1ZGRlbmx5 X1NFUg== MzE1 IGFv X2RpcmVjdG9yeQ== ZmFz IHByZW1pdW0= IHRyYWNraW5n IEJM IG1hdHVyZQ== IGJhdGhyb29t ICcvJw== IMSR UGVyZm9ybWVk IHNvbGRpZXJz YXJuaW5ncw== IHdhbGtlZA== LWNvbg== Ym90dG9t IHN1cnByaXNpbmc= IGdlbmU= VXN1YXJpbw== LkRFRkFVTFQ= IE1JVA== Q09ERQ== IEVneXB0 cGlja2Vy eXNxbA== QVRVUkU= ZGV0YWlscw== IENvbmZlcmVuY2U= SW5mb3JtYXRpb24= IE1haWw= LWRvd24= cmFyaWVz YnJv IHN1YmplY3Rz ICcq 6K+3 b3JpZW50 OkA= dmVyYm9zZQ== RUY= IHRvbGVy MzEz ZW5nZXJz IGVuZHBvaW50 IHN0cmFuZ2U= IGNvbG9u IHByZWZlcnJlZA== ZGVw IEVW QVJSQVk= IHdoZQ== IHB1cA== X25vZGVz IHRhbGtlZA== IGluc3RpdHV0aW9u ZGJj IGV4cG9zZWQ= dGVlbg== IEZyb250 VFQ= X05PTkU= XC9cLw== cHJvZ3JhbQ== IGVuY291cmFnZQ== LmA= c2hpcmU= IElzbGFt MzI1 ZWVu Tkk= JyI= LldpZHRo IGxpa2Vk IHsuLi4= IFN5c3RlbXM= IHZvdHJl IG1hbnVmYWN0dXJpbmc= Q29udmVydGVy IEluZg== 7Jo= RFRP IGluY2hlcw== IOCk w7k= IENoYXJsZXM= QlU= IikpOwoK IExhYm9y dW5u IGVzdGlt bW9iaWxl IExlYXJu Mjgx X0NBTEw= 4oQ= IGluZGljZXM= IHR1Yg== Mjg4 aWtpcGVkaWE= Q29zdA== cm93YWJsZQ== 66E= Z2FnZQ== IGZ1bmN0aW9uYWxpdHk= dXp6bGU= ZW1vcw== LmxpYg== IGRhc3M= 0LXQug== ZW5uYQ== IHNob3Rz IHJlc3RvcmU= L0Q= Rm9yS2V5 XSxb YWxpYXM= bGludA== LnN0cmVhbQ== 5qA= X0ZPUk1BVA== IHNpbHZlcg== LnJlcG9zaXRvcnk= IGxlZ2lzbA== LkJvcmRlcg== X2ZlYXR1cmVz UGVybWlzc2lvbg== IGhvdXNlcw== IFdhcnM= X0NPTVA= IGluanVyaWVz IGNvbnN0YW50bHk= Zmx1dHRlcg== RU5V IENvbmY= IHJlY29nbml6ZWQ= IHByYWN0aWNhbA== IGRlY2VudA== Qko= XSk7 YXN0eQ== IEFjdGl2aXR5 LW1vZGU= IHNsaWRl LklzTnVsbE9yRW1wdHk= IFlPVQ== UG93ZXI= aW5kaWNlcw== IHF1YWxpZmllZA== IHRocm93bg== aGVsbG8= MzE2 IE5pY2s= bGFo YXNzZW1ibHk= IFNtYWxs b2xkaW5n U2hvdWxk IFNpbHZlcg== KHNhdmVkSW5zdGFuY2VTdGF0ZQ== IHRvZ2dsZQ== Lk5vdA== Q3RybA== Om5pbA== IENvbnRpbnVl IEJvb3Q= 5ok= IE11cg== ZG9u IEZB U25hcHNob3Q= IGFzc29jaWF0aW9u Zm94 LGE= YXppb25l XSkNCg== Q1RZUEU= IGZhZGU= IERhcg== Lm5hdmlnYXRpb24= IGx1Y2s= U0NSSQ== IERlYWQ= IHRlcm1pbmFs X0xFTkdUSA== IGVmZmljaWVuY3k= IHVudw== IG5hcnJvdw== aW1lbnRv KENvbG9y IFNlYQ== X2FyZWE= LEE= X29wdA== IEhpbGxhcnk= LnRhc2s= IEphYw== YXN0ZWQ= IEFkYW0= IElsbGVnYWw= IHNlYXJjaGluZw== SW5zdGFuY2VPZg== SmF2YQ== IEZvcm1hdA== IHJlYWxpemVk IENoaWxkcmVu IGtpbA== KGZyYW1l 4oCdLgoK IHNjZW5hcmlv Il0pOwo= IGluY3JlZGlibGU= bGl4 SU9FeGNlcHRpb24= IFF1ZXN0 aWx0eQ== IHVubG9jaw== 4oKs IHJlZmVyZW5jZXM= IFZlcnQ= QmluZGluZw== ZWdhdGl2ZQ== IHdyYXA= LmRhdGFiYXNl KGNvbnRlbnQ= QnVm IFRyYWQ= IEF1ZA== dHJhY2U= Lm1vY2s= IHRoZXJhcHk= CUw= LlRvSW50 IEtpbmdkb20= QnVz aGF1c3Q= IiIiCgo= KGVuZA== LmRyYXdhYmxl W107Cg== IEhvc3BpdGFs IHBoYXJt LS0tLS0= IEFH w6lk PiIpOwo= IHdhbGxldA== YXRhYmxl KSQ= IG1vbnRobHk= IGRpYWdub3N0aWM= U3ltYm9s IGl0ZXJhdG9y dW5maW5pc2hlZA== IGltbWlncmF0aW9u c3I= Uk9X KGdhbWU= IGNsb3RoZXM= IFVudA== IGFjdGl2YXRpb24= X0Nvbg== Mjcz Lmhhc2g= IGluaXRpYWxseQ== Lkhhc2g= IGN1dHM= Zm91bmQ= IFN0b3J5 0YbQuA== YWNhbw== X1RZUA== cHJvdG8= ZXN0cg== LXBhZ2U= YWhy IGluY29ycmVjdA== IEpvc2VwaA== VGV4dEJveENvbHVtbg== X3N0eWxl IERhbmllbA== c2hlZXQ= IGxpdg== bGluZWQ= IHJh UnVudGltZQ== X2VtcHR5 c2x1Zw== X3N0cnVjdA== 64o= bXU= IHBlcm1pdHRlZA== IHJlZ2lvbmFs IHNvYnJl IFN1Y2g= IFtf IHJvb2Y= LkFsaWdubWVudA== dGltZXM= Lm1zZw== IGNoZXN0 IFRhYg== IGVzdGE= w6Ru IHN1YnNjcmlwdGlvbg== KGNvbW1hbmQ= c3BlY2lhbA== IG1lYWw= Iik6Cg== X2N0eA== IGNsb3NlbHk= MzA5 ZXRyeQ== LWJl YWRlbA== IFJhbQ== aWdlc3Q= IFNwYW5pc2g= IGNvbW1pdG1lbnQ= IHdha2U= Kj4o UEhQ X3s= Y2tlcg== PExpc3Q= X251bGw= Mzkw IFJlc2VydmVk IGluaGVy LkNvbHVtbnM= LkFzcE5ldA== X0lOVkFMSUQ= IFBhcmFtZXRlcg== IGV4cHI= fXs= Q2VsbFN0eWxl IHZhbHVhYmxl IGZ1bm55 SW52 IHN0YWJsZQ== KnQ= IHBpbGw= Mjk5 cGxpZXJz IENTUw== IENvbmRpdGlvbg== IFNwZWVk dWJsaXNoZXI= MjU5 IG9mZmVuc2l2ZQ== Y2VzdA== aWNhcw== IHNwYXJr IFByb3Rl c2V0dXA= SUZZ IFRheA== V2hv RmFtaWx5 LWZvcg== LnVr IGZhc2M= c3Zn IikpLg== IGJpcnRoZGF5 4paI dmVo ZWxsZWQ= IGltcG9ydHM= IElzbGFtaWM= VEE= IFN0YW4= d2VhdGhlcg== IHN1c3BlY3Q= ZWF0dXJl ZW5uZXM= V00= Lm1pbmVjcmFmdA== YXZpZA== 6L0= LnNlY3VyaXR5 aW5vcw== R29vZA== IG1hcmNo NjU1 MjU3 IHBvc3Nlc3M= dXN1YXJpbw== Q29ucw== YW1iZXI= Y2hlZHVsZXI= IGhvcnNl 570= KGJvZHk= IFRyYW5zZm9ybQ== X2RlY29kZQ== LnN2Zw== IGZvbw== IGRlbGxh ZXh0ZW5kcw== YW1lcg== IHByb2Nlc3NlZA== IEhhcnI= IEFJ IGtv Q0hBUg== KCU= IHRhcA== KHsn Y3JvbGw= RE9N IHRlYQ== IHJlaW4= MjYx IHdvcmxkd2lkZQ== X2Zu c2hh IGJpcg== w6fDtWVz PSIjIj4= IHJlcHJlc2VudGVk aWxsZXI= KGV4cGVjdGVk IGRhbmNl IHZpc2l0b3Jz LmNvbmNhdA== LWJpdA== VVJSRQ== IFJvZw== dnA= aXBo IExMQw== aXRsZWQ= aWFtaQ== Q29sbA== X3JlYWw= X3Nob3c= X2ZvbGRlcg== IGRhcg== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IGxhdHRlcg== YXJjaHk= IGJvdw== IG91dGNvbWU= NTEw IFBvc3RlZA== IHJpc2tz IFRoZXJlZm9yZQ== IG93bmVyc2hpcA== IHBhcmFsbGVs IHBlbmRpbmc= Z2VvbWV0cnk= IHJlY29nbml6ZQ== U1RFTQ== IENQ IGltbWlncg== SVRMRQ== ICAgIAkJ Y29ubmVjdGVk IHNtaWxl KGRvY3VtZW50 XENvbXBvbmVudA== dmVydGljYWw= IGNvbnN1bXB0aW9u IHNob2Vz LmltcGw= dW5rcw== LiI7Cg== IGZvb2Rz Xyk7Cg== LmFzc2VydFRydWU= IHBpcGVsaW5l IGNvbGxlY3Rpb25z IGVhcm5lZA== IENlcnQ= IHBhcnRuZXJzaGlw KGFjdGlvbg== MjYz IGNk IFZlcnk= T3B0aW9uYWw= IHNjcmVlbnM= IHRpdGxlcw== ZW5lcmF0b3I= IGFiYW5kb24= a2luZA== SUxURVI= IGNsb3Npbmc= bGljYQ== X2ludGVy IGNhbXB1cw== c2V0dGluZw== U3ByaXRl 44Gv X3JlcGx5 VG9MaXN0 OlwvXC8= ZWRl IGZvbGtz IGJvYXQ= KGFyZ3Y= IHBlcm1hbmVudA== IGNhcnJ5aW5n IGNvbnNlcnZhdGl2ZQ== aW1wb3J0YW50 LmltZw== IEltbQ== IGRpbWVuc2lvbnM= YWxhbmQ= c2luZ2xl RXhpdA== LS0tLS0tLS0tLQ== YXJpYW50 dGVybmFs U2Vjb25kcw== IEl0YWx5 b3RsaW4= LlJlc3VtZQ== PSci KT09 Y2VwdG9y IHNjYQ== L21haW4= U2VjdXJpdHk= X2RhdA== IGxldHM= IGFxdQ== IHdoZW5ldmVy YmVycnk= IGFjdGluZw== YW50aQ== cGQ= Jmd0 5q0= Wm9uZQ== VG9kYXk= IS4= MzIz VG9Qcm9wcw== YWJpcw== aXRhYmxl IGdhbA== XXs= aXpvbmE= IGluY29udHJp TkVU Ly8vCg== W2lu X3NhdmU= IGV4ZW0= IEtlbm4= IGV2b2x1dGlvbg== Mjcy dmFycw== X3N0YXRz LW9ubHk= IENvbG9yYWRv IHdhdGNoZWQ= Ym91cg== IHNldmVyZQ== IHByb2Zlc3Npb25hbHM= cG9ydGlvbg== IGd1YXJhbnRl 0LM= IHB1c2hlZA== IEdp 770= IHR1bQ== IEF6 IEVkZ2VJbnNldHM= IikpOw0K aXNzZQ== LmFj U2V0dGluZw== IGFwcHJlY2lhdGU= IFZhbHVlRXJyb3I= IHN1cnZl IFJvbGU= LkludGVy cGxvdGxpYg== amV0 ZGFt IHBsYXRmb3Jtcw== dGVsZQ== VVRP IEludGVybmFs Kzo= fTsNCg== R2VuZXJhbA== XEVudGl0eQ== IGxhd3llcg== cXVpdg== IFBvc3Rz aXNv IGFjY3Vt b2Jl IG1hcmtz IF07Cgo= CXRleHQ= LnN1Y2Nlc3M= Y3Vycg== YXNh ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IHRoaW4= X292ZXI= MDE2 YXJlc3Q= IE9z KGFkZHJlc3M= IHZlbG9jaXR5 IFtdOwoK PSIuLi8uLi8= IFByaXY= Ym93 IGd1YXJhbnRlZQ== JQoK MzIy IGV2YWx1YXRl LkxFTkdUSA== IGludmVudG9yeQ== cWE= X2RlYnVn Lk9uQ2xpY2tMaXN0ZW5lcg== IGxpZXM= IGFzc2Vzc21lbnQ= ZGF0ZXRpbWU= LmJhY2tncm91bmRDb2xvcg== ICovDQoNCg== cmFm dW53cmFw IEZvb3Q= IG5vdGlmeQ== IGxvd2VzdA== RE9DVFlQRQ== IGxhbmd1YWdlcw== ZXh0cmE= LWJhY2s= IGVpbmVu dGVtcGxhdGVz Mjcx X3Bhc3M= NTIw Nzc3 IE11c3Q= IGVzdMOh X2NvcmU= IFNjb3Q= QUk= IGJpYXM= YXRpb25zaGlw Q29uc3RhbnQ= IHByb2dyYW1taW5n SW5z dXNwZW5kTGF5b3V0 IFBST1ZJRA== YW50ZXM= IHNoaXJ0 aW5hdGVk Lk9L W2E= IHRoaW5rcw== PwoKCgo= IHJlZ2FyZGxlc3M= IE1hZ2lj dWxhdGluZw== CWNsYXNz YWRkR3JvdXA= UkVBVEU= IFNV IHNpbXBs Y29weXJpZ2h0 IGJ1bmNo IHVuaXZlcnNl OTUw IEVycg== IHByZXNlbnRhdGlvbg== Y2F0ZWdvcmllcw== IGF0dGFjaA== LnNpZ24= X0FD IGRpc2NpcGw= IHJlZ3VsYXJseQ== IHByaW1hcmlseQ== aW5rcw== W1s= LnJhbmQ= LnNob3VsZA== b3dudG93bg== PSIn IHNhbnM= IHN1cHBvcnRlcnM= c2VxdWVuY2U= R08= Li4KCg== IFNwcg== IGNhcmVmdWxseQ== VUlDb2xvcg== ZGVzdHJveQ== IHRvZG9z IE9SREVS b3R0ZWQ= IGRvbnQ= YXVkaQ== X3BsYXllcg== Z3Jl NjI1 IE9pbA== PGJvZHk= X3N0YWNr LlBhZGRpbmc= IFByb2R1Y3Rz IHByaXZpbGU= MDE0 IGluanVyZWQ= IEZ1cnRoZXI= IGFsaWFz LlJlc3VtZUxheW91dA== X0xFTg== IHNlcw== J107Cgo= Y3JlZW5z IGRpcmVjdGVk LlN1c3BlbmRMYXlvdXQ= b2RnZQ== LkF0 bWFya3M= IFVuaXZlcnM= ZXJ0cw== IEVzYw== IG5hdmJhcg== IHV0aWxpdHk= YWdub3N0aWNz IGluamVjdA== IEROQQ== ICIsIg== YW1hcg== IGV1 IHJlc3RhdXJhbnRz X3B1dA== dXRlcnM= VG9vbFN0cmlw dHc= aXN0cm8= IHpvb20= IGxlZ2l0 cGVjaWZpYw== Mjg1 IENvbWU= IGxvY2FsU3RvcmFnZQ== IGFic29y LlBhbmVs IERlc2lnbmVy IG93 SUNBTA== X3VyaQ== KGZpZWxk IHN1cGVydg== RXhpc3Rz IHJlc3BlY3RpdmVseQ== IFN0YW5k Q29uZg== dXNzaWFu MzY0 IGFyYw== IG5k dWNrcw== IHJlc3Ry IHNlYXNvbnM= IENoYXB0ZXI= IFN3aXRjaA== cGlj IGhp bG9hZGVk IGZsdWlk LWJ0bg== IHJ1bnRpbWU= Lml0 MjU4 Qk4= T3BhY2l0eQ== YXNhbnQ= cnlwdGlvbg== LW5hdGl2ZQ== IHRhdWdodA== 5a8= YWdtZW50 IG11bA== UmVnaXN0cnk= X2dyaWQ= IEJyb29r OlNldA== IG1vbmdvb3Nl QU1FUw== aW5uZXJIVE1M IHNvY2k= IEludGVs Z2V0SWQ= Q21k IGFjY2Vzc2libGU= cmFtZXM= bGV0b24= IF9fKA== CWRlbGV0ZQ== IFNxdWFyZQ== IgoKCg== IGJ1Y2tldA== YXZvcml0ZQ== IEJyZWFr Kytd IGJydXNo MjY2 IHRlbnNvcg== L2h0dHA= VGlsZQ== IGZ1bmN0aW9uYWw= ICIq d2hlbA== IHRlbnQ= IENoYXJhY3Rlcg== IHNlZXM= LlNU Qmln IGV4dGVybg== VXJscw== KSkpKSw= IEpy LkJ1aWxkZXI= Ljs= bmw= X0luaXQ= IEhFUg== xbxl bXlzcWxp X2ljb24= dmFu IGZlZWxpbmdz IGxlYW4= IGhvcGluZw== VFY= PSI8Pz0= IGN1cnZl X3N0ZA== X0xJTkU= ZHN0 IG1vcmFs ZW1lcw== b2d5 IHVyYmFu MDE1 IGFzaWRl IGVkaXRpbmc= QURE U2Vjb25k VHJhY2s= IHZvdGluZw== IGhvbm9y Lics ZWxsZW4= Q2hhdA== IGltcHJvdmVtZW50 J10KCg== oIE= IHBhcnNlZA== ICAgICAgICAgCg== IGxhenk= IGZhbGxpbmc= U2VyaWFsaXpl IFBh X2dy IGZvcmV2ZXI= LndoaXRl LlF1ZXJ5 QmVk IER1 IHJlc3VtZQ== IHBhcGVycw== IEluaXQ= IHN1ZmZlcmluZw== 4oCL IGRlY2xhcmF0aW9ucw== KCkt IGV4ZWN1dGVk IEhvbA== LmJsb2Nr 44Oz U0s= IHN0dWNr IExvY2s= aW5jaXBhbA== TnVsbGFibGU= IHNlc3Npb25z dW5p IGNvdXA= YXBwcm8= Z2hhbg== X3Bvb2w= Mjgz CWlk IHNsb3Rz IG1lZGljaW5l IGdsYWQ= IE1vbm9CZWhhdmlvdXI= YXRyZQ== ICQoJw== bWVyaWNhbg== YWdn IGthbm4= X2Nvbm5lY3Q= IGJyYW5kcw== IHNrZQ== IGRpZ2l0 PG4= IGJhY2t1cA== IHBlcnNvbmFsbHk= LlByb3BlcnR5 MzE0 LmNvbW1pdA== IGNyeQ== X2NvdW50ZXI= IG1hbGxvYw== IGdyYW4= IERyb3A= cGxhdGZvcm0= cmVkZW50aWFscw== aW5raW5n IFVJTA== dWJz IG1s bGVzc2x5 R2VuZXJhdGVk ZXJlb3R5cGU= IGJhdA== TGF5b3V0UGFuZWw= TE9U Iik7DQoNCg== IG11c2NsZQ== IGNlcnRpZmljYXRl QU5ETEU= IGhhcmRlcg== IHBpeGVscw== KSIsCg== LkhlYWRlcg== IGRldmVsb3Blcg== IExhcw== ZWdhbg== Ljw= IGV4cGxvZGU= IHBhcnRpY2lwYXRl UGF0dGVybg== KHRhYmxl IFRFWFQ= Y29uc3RhbnRz eEQ= dGhldw== fSwKCg== 44Gu X2Rlcw== IHN1YnN0cg== IFNtYXJ0 IHNjYWxh Z2VudA== LWJhcg== ZXNzaW9uYWw= dW1icw== LmV4ZWM= J1w= VEs= dW5pc3Q= cHJvb2Y= Y2lhbA== cHJvYw== PXsi LmhyZWY= PSQo IGx1bmNo aXNjYWw= IEVudHJ5 IG91dGRvb3I= c2VtYmxl IGVzc2VudGlhbGx5 L0c= W10p JSI= c3Rlbg== VVNFRA== IGR1c3Q= 5bA= CQoK IHJldGlyZQ== IGZpYg== QWx0aG91Z2g= IGxvdmVz IHJlYWRz eWNsZXM= IEhlbA== X3VpbnQ= ICcuJA== X2luaXRpYWw= TmFtZWQ= IGZ1bmRhbWVudGFs QURJTkc= IHRvdw== IEFERA== IEFjYWRlbXk= MDUw OlN0cmluZw== IGNvbXByZWhlbnNpdmU= LnNjYWw= IE1ldGE= TWVzc2FnZXM= LmFubm90YXRpb25z XFJlc3BvbnNl IGFja25vd2xlZA== IEFSRQ== XT09 IGNsZWFuaW5n 6L4= RW50aXRpZXM= IFNhbGVz IFdpcw== LmV4dGVuZA== YWxsZW5nZQ== IGdhbWluZw== JHF1ZXJ5 SUNFUw== RVRDSA== SG9yaXpvbnRhbA== cXVlbnRpYWw= ODUw QkFDSw== ZGV2ZWxvcA== aXNvcg== KGNvZGU= LUs= X1BJTg== cmVxdWVuY3k= IFF1ZXN0aW9u X2NvbnRhaW5lcg== X21vZHVsZXM= IEplcnNleQ== X2RpZmY= LmVs ICooKA== Y250 IFNh Q1BQ aW5pdGU= IHVudXM= LXdoaXRl ZXRhcnk= IGludm9sdmluZw== ID8+DQo= YmVzdA== YWxsYXM= ZW50ZWQ= ICAgICAgICAgICAgICAgICAgICAgICAgCg== X2Nvbm5lY3Rpb24= IHJlcG8= ZW5hYmxlZA== 0LDQug== IHNoYQ== IG1lbWJlcnNoaXA= U3RhdHVzQ29kZQ== aW5hdGluZw== X3Nt X2N1c3RvbQ== X3dlaWdodA== IGNzcw== U3RhdA== X2Vudg== bGlua3M= VFJM IEhpdA== LHI= dXBpZA== IG9wZW5z IGdlbnQ= X3Zpcw== IGpveQ== PHc= X2Nvc3Q= IFB5T2JqZWN0 cmVuY2U= IEdlb3JnaWE= IEJyb2Fk bW1h 4oI= cGY= ICJcIg== ICgm b21v IGxpdGVyYWxseQ== iJg= bWV0cmlj IGJhcnM= emVk KHdpbmRvdw== IElzcmFlbGk= IGZvcm1hbA== aWRlbnRpZmllcg== LmRhbw== IERlYXRo JTsK IGRlY2xhcmU= YXJtcw== UkVBTQ== UEVSVFk= IGNvbnNlcXVlbmNlcw== dG9vbHM= UGVvcGxl IFdoaWNo PigpOw0K LmRlY29kZQ== X0FDVA== QnV0dG9ucw== LmZsb2F0 LkZpcnN0 66U= IFBvbGl0 IFhDVA== VGFncw== IENHRmxvYXQ= PXN0cg== IGxlYWY= LWNoZWNr IElzcw== LnN5c3RlbQ== bG9nb3V0 YWNodA== QW5nbGU= c2lu Y2hhcnQ= SU5URVI= IE5VTQ== QmFzaWM= LlByb3BlcnRpZXM= 5Lit X2NoYW5nZQ== IEJyYXppbA== QWJzdHJhY3Q= IDorOg== X3VzZQ== 0LDQuw== MjY4 IEx5 SUJVVA== IG91dGVy IC0tPg0K IHJlbGllZg== bGFw cXVlcg== X3BhcmVudA== aGVhcA== TE9TRQ== IGNvbWJpbmU= IFJvc2U= b3dlcnM= IHByb2NlZHVyZXM= IFNvcnQ= YW5pbQ== dmFyaWFudA== ZWhpY2xl IHNpZ25pbmc= UHJpbWFyeQ== Y3VycmVuY3k= IHNleGU= b2Vu dGhldGE= ZW1hbg== IGltcHJlc3NpdmU= KCdf CVU= IFRleHRTdHlsZQ== X2NudA== IHNsaWNl KCc6 IHVuZGVyc3Rvb2Q= SGlz Mjc3 MDEz IGluZm9ybWVk IG5pY2s= NDI5 KFRBRw== aGQ= IGVsZWN0aW9ucw== ZXN0dXJl IFNhbnRh IENvYXN0 LnBkZg== aW5jaXBsZQ== LmNsb25l Ym9ybg== dXRh IGxpY2Vuc2Vk Q3I= IGJyZWFk IEhvdXN0b24= IG5vZA== IGhvcGVz IENHUmVjdA== IGd1aWx0eQ== LmdpZg== IHJvc2U= LkNvbW1vbg== VGlw QU5L IEZD RHVyaW5n IFN5bWZvbnk= IGRlZmVuc2l2ZQ== a20= KT4= YXJjaGl2ZQ== IFVSSQ== eWNsaW5n LW8= IFdlYnNpdGU= QU1Q NDA1 aXNobWVudA== IGRvY3RvcnM= RGlyZWN0 QVJJ IFJlZGlyZWN0 aWVyZW4= OTYw X2Rpc3Q= eW8= IFByb2dyZXNz IHp1bQ== IG1lbW9y IEVE IGp1cg== 5o2u X1RBQkxF IHV1aWQ= RXhwcg== LmhlYWQ= KCcl cG9pbnRlcg== IGVzdGltYXRl IEdyZWc= IGxvYWRlcg== IGlPUw== IG1lbnM= W3k= IHJlZnVzZWQ= IHByZWNpc2lvbg== aXNjaA== IEFDVElPTg== Q2xvdWQ= c1dpdGg= KHJldA== Mjky X0FERFI= X2NvbmY= KGRm IGxvY2tlZA== IHJpc2luZw== 44O744O7 IE1z IHNjZW5lcw== X0VYVA== X3Jhdw== X3RoZQ== cGVvcGxl IHJlY29u IEZ1bg== IGJsZXNz IFVwZGF0ZWQ= NDIy w7xu ICAgICAgICAgICAgDQo= cGVjdGlvbg== UmVsZWFzZQ== LmxvZ2dlcg== IFNZ IGNvdW5zZWw= dXJk X3RydWU= IGV2ZXJ5Ym9keQ== aXZvdA== IGhlbmNl IE5BUw== Nzg5 IG9wcG9zZWQ= dW5rbm93bg== IERFU0M= IENoYWly ZmFpbGVk IElOQ0xVRElORw== Mzg2 MzUy IHdyaXRlcnM= e30K w610 X2NvcHk= fTo= IEJhdA== IGNvbnZlcnRlZA== ZWRpbmc= cGxhY2VtZW50 IEhvc3Q= U291bmQ= 0LjQvA== IHNvdWdodA== NDAy bWlk IHNhbGFyeQ== b2dn 4oSi YnVs IHdpcg== dmFsaWRhdG9y X1NUQVQ= LnN0b3Jl IEJhdHRsZQ== xLFu IC0tPgoK VHJ1bXA= ZG90 IENPTlQ= LmZldGNo IGNvbnRpbnU= d2Fz IGZyYXVk X3RtcA== bWl0dGVy LnBpY3R1cmVCb3g= R0E= IHRvdXJuYW1lbnQ= LklucHV0 MzQz W3I= ZXhpb24= Y2VudGFnZQ== IEtvcmVhbg== dW5kZWY= IEF2YWlsYWJsZQ== cmVzaGFwZQ== IGtpdA== IFN0cnVjdA== IFNVQg== QW5zd2Vy X2xpYg== LnR3aXR0ZXI= IG9yZQ== IERyYWdvbg== LkV4dA== LGs= IGV4cGxhbmF0aW9u cmVmcw== IERyaXZl IFRyYWluaW5n Mjgy Lkhhcw== MzQx aW50YWdl Ymln b2xvZ2lzdA== ZW5uaXM= NDYw 2Yc= IGNoaWNrZW4= ICAgICAgICAgIAo= 55s= 44Gn IHBlYWs= IGRyaW5raW5n IGVuY29kZQ== IE5FVw== bWFsbG9j CWZwcmludGY= ID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09 aW5jbHVkaW5n IHByaW5jaXBsZXM= IE1haA== MjY3 c3RvcmFnZQ== LWtleQ== IGtleXdvcmQ= JTs= IHRyYWluZWQ= LmNvbnRyaWI= IGt2 X18nOgo= IEJveQ== cGFyYW1ldGVy IHN1aXRl IHRob3VzYW5k IGNvb3JkaW5hdGU= LWdlbmVyYXRlZA== 7ZWY Z2VuZXJhdGVk IGFkbWl0dGVk IHB1c3N5 I3c= IHN3aW0= dW5pb24= TmE= Mjc0 IFJveWFs LmNoYW5uZWw= VXBkYXRlZA== X1JPT1Q= IHZpdGFs MzM1 cmFjdGlvbg== IENydXNoZXI= IHByZWNlZA== IGhvcml6b250YWw= Qmx1ZXByaW50 IGF0dHJz IHNtb2tl 0JI= LkVxdWFscw== RkI= IFJlc291cmNlcw== cm9sbGluZw== IHBhc3Nlcw== IE51bQ== cm90YXRl ZXR5cGU= XCIs IHNlbnNpdGl2ZQ== IHRhbGw= P+KAnQoK UHJveHk= aXk= X3NlY3Rpb24= 4oCU4oCU4oCU4oCU YnJpZA== IGNpcmN1aXQ= YXRhbg== RU5D IGRyaXZlbg== IHZvdGVk IGVkdWNhdGlvbmFs IGludGVyYWN0aW9u YWJldGVz IHRvbmU= IEluaXRpYWxpemVDb21wb25lbnQ= IG1lcmVseQ== IOye Y29va2ll X2Rpdg== IFVJTGFiZWw= dmVseQ== fSk7DQo= X0VOVA== IysjKw== YXJ0aWNsZXM= IFNvdXRoZXJu IHN0cm9uZ2Vy IEdpdmVu IEVyaWM= IElS YWJzdHJhY3Q= VW5kZXI= bmFibGU= IGluY3JlbWVudA== b3Zlbg== IGNvaW4= X3RpbWVy IHN1ZmZlcmVk IEZSRUU= J10uIg== IFF1ZWVu c3RhdHM= IG1lZXRpbmdz Mjc2 IGVudGVyaW5n IGFsb25nc2lkZQ== KHNlc3Npb24= aXRhbHM= IGZvdW5kYXRpb24= IENyZWRpdA== LmRpdg== X0FMTA== cGNpb24= X3N0YXQ= aWNraW5n RGVmYXVsdHM= X3NyYw== IG91dHB1dHM= L0I= IGVudGh1cw== LWJs LkZvcmVDb2xvcg== CXRlbXA= RmFjZQ== IGludGVyYWN0 IHdlaXJk TW91bnQ= cmVsbA== dWRlbnRz IHJlcXVpcmVtZW50 IFN1cw== SUVS IGVsZWN0ZWQ= cmVmZXJlbmNl IE1F IHNlcnZlcnM= LndhaXQ= IHNuYXBzaG90 aWx0b24= IHRyaWVz IHRpcG8= LlRpbWU= Pnc= IG1vdW50YWlu IHBvdW5kcw== IFsuLi4= ZXhpc3Rz IG5nT24= X01BUA== IGZseWluZw== MzMx eGlldHk= CXZhbHVl X0RC dW5v IHNlYXRz VFVSTg== LmF1dGhvcg== ISk= b3JjZQ== IGluZGljYXRlZA== MzE3 LnNpbg== IGFzc2lnbm1lbnQ= aW1pZW50bw== IEZyYW1l MzI0 X2dlbg== aW5lcnk= Xyk= bWVzc2FnZXM= LnNldHRpbmdz IE1lYW4= IE11c2V1bQ== aXJx YXR0YWNo IFBhbGVzdGlu X1FV X3RhZ3M= IGNhc3VhbA== ZW1lbg== QVNTV09SRA== NDMy JHM= IENpcmM= 0L7QuQ== ZXRyaWM= L1A= MDE4 IGVwb2No PGhlYWQ= X0NNRA== IGdpdA== IHBlbmFsdHk= b3JwaA== X3VzZXJz b3Vyc2Vz LkRhdGVUaW1l YXRlcm5pb24= X3Byb2plY3Q= IHN1cGVyaW9y IERhbQ== IFNlYXR0bGU= WFk= PlRoZQ== IEFr IGdyYXNz LyoNCg== KGRpcw== IGd1bnM= IHRi IEtldmlu LmFyZ3M= IEFo b3BlZA== KEo= Y29sdW1ucw== YXJndW1lbnRz IFdpdGhFdmVudHM= X2Z1bGw= IERlZmVuc2U= U2ltcGxl IGRlYXRocw== Mjk1 IGV4dGVuc2l2ZQ== IFN0aWxs IEV4cHJlc3Npb24= IEFnZW5jeQ== IHBlcmZvcm1pbmc= Rlg= IHVzdWFyaW8= VUFM U2lkZQ== b2Rvcw== YXB0b3A= IGNyZWRlbnRpYWxz X2NhcA== YXRpZW50 IERpc25leQ== IGFp IGNoaXA= IHZvbHQ= Lm1ha2VUZXh0 JSUlJSUlJSUlJSUlJSUlJQ== IGJlbGllZg== X0xPQw== IENpdmls TmF2aWdhdGlvbg== IHJldmVhbA== IHZpb2xlbnQ= IEZpbA== IGNhdGFsb2c= ZW1lZA== c2Nhbg== LmNvbnRyb2w= IGNvbnN0aXR1dGlvbg== Q291bnRyeQ== U2VwYXJhdG9y X0FQUA== dG9waWM= dWV0b290aA== TUlO IGRlc2NyaXB0b3I= eXQ= RVRIRVI= IGRpc3RyaWJ1dGU= J30K LnRyaW0= LkxpbmU= IGxibA== YXNzZXJ0RXF1YWxz IERldA== b21ib2s= KHdpZHRo IHRvcnQ= IEVYUFJFU1M= YWNv VXNpbmc= IEJyYW5k d2FsbA== RU1FTlQ= IENvbW11bmlj PHVpbnQ= IEdVSQ== RUdJTg== IFJhbmdl L2k= IFRheWxvcg== Y29zdA== IHJlc3BvbmRlZA== IFRoZW1l bmNl SVNI IGZlYXR1cmluZw== UmV0dXJucw== IEty IC4K IG5hbQ== X2Ni VGVzdGluZw== IHt9LA== eWFs LmZpZWxk IC89 X1NIT1JU bWF0ZXM= VGVzdENhc2U= YWlubGVzcw== IGV2YWx1YXRpb24= X0lURU0= IFBhY2lmaWM= CWs= IGNhbnQ= IFJvcw== KXM= IGZldA== U1RSSU5H MzE5 IERpc3Bvc2U= Z2Fs IEpvaW4= IFBvcm4= IENhdGhvbGlj QVJHRVQ= Y3B1 56CB LnNjcm9sbA== MzI4 SVNJTkc= aWZlc3R5bGU= YW5jZW1lbnQ= IG1lcmM= IEJyb3dzZXI= ZXRlcm1pbg== IG92ZXJmbG93 QXZhaWxhYmxl IGJvdHRsZQ== OlVJ aWZpY2lhbA== IGNvb3Jk Y2xhcmF0aW9u IGNvbmo= R0xPQkFM b2t1 IGt3YXJncw== Y29uZGl0aW9ucw== dWx1bQ== IGdlbnU= IEhlcm8= 5Y4= IHVuZXhwZWN0ZWQ= IERBTUFHRVM= IGth IENvdWxk VVBQT1JU IFBob3Rvcw== IGNvbmZpZGVudA== IGRldGVjdGVk ZGVn cmdi IHN0cm9uZ2x5 IH07DQo= ICk6 IGxlY3Q= dXJzaXZl Uk9M IFdlaWdodA== IGVudGVydGFpbm1lbnQ= ICkpOwo= IGdvbm5h IGJi LmRv R1M= IG1pc3Rha2U= REw= IFBST1ZJREVE ZWFybmluZw== TGltaXQ= aXNzaW9ucw== W3Y= 5LiN aXJ0eQ== RGVs IHVuZGVybHlpbmc= cHJlbmU= IGphdw== IERJ cGVlcg== IG9iamVjdGl2ZQ== IGRlcG9zaXQ= IGtvbg== IGVzcA== Mjc4 LnNldFZpc2liaWxpdHk= L2xvZ2lu PHR5cGVuYW1l IGZyYW5jaA== L2U= MjY5 UGFyYWxsZWw= IHNjb3JlZA== IEhvbg== IFZpbGw= aWdh IGFudGljaXA= X2Fzc2VydA== IE9wdA== IGRlc2NyaWJlcw== d2Fu bW91bnQ= IG1vbml0b3Jpbmc= IHRvdXQ= 64qU fSx7 Li4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4= PWludA== IGN1c3Q= LS0tLS0t IGF0bW9zcGhlcmU= UEFS b3J0ZQ== SVNJQkxF IElyb24= IE5vdGlmaWNhdGlvbg== LmxvZ2dpbmc= IEJPT0w= LXBvaW50 IGFmcmFpZA== ZW50YQ== IHRvbW9ycm93 QGltcGxlbWVudGF0aW9u IGVuZ2FnZQ== IEFudGg= IEZsb29y IFVs VG9vbHM= IGJhYg== IGNhcmVmdWw= 44GE IGNydWNpYWw= IGNhbGN1bGF0ZWQ= IFNB IHd5 OTEx RFg= X1RBRw== aW5kZWQ= IGpldA== IEVuZ2luZWVyaW5n Lk1BWA== ZW56 dmQ= IHB1YmxpY2F0aW9u ICMjIw== IGZhY2Vk cmFoYW0= IENhcHQ= MzM2 QXNzZXQ= IENvbnN0YW50cw== IGxvYW5z X0lQ IEZpc2g= UmVkdWM= X21hdA== RGF0ZUZvcm1hdA== X21l W11bXQ== IGludGVncml0eQ== IENvdXJzZQ== bG9iYWxz IGZhY2lsaXQ= IGVtYnI= IE5n LlN5c3RlbQ== IG1hbnVmYWN0dXJlcnM= IHByb3Zlbg== Lm9uQ3JlYXRl IGFsYXJt IMKn IGNvbW1vbmx5 aWNvcw== 5paw IFN0YXRpb24= fSku IEZpbG0= d2k= 54k= IGVuZ2FnZWQ= U3RhdHM= IGdvdmVybm1lbnRz NTQw IGFmZm9yZGFibGU= X3Byb3BlcnR5 IGFnZXM= KCctLQ== IGbDtnI= IFByb2Zlc3Nvcg== IGh5ZHJv UHVzaA== IG9yZ2FuaXplZA== Mjg0 QWNjZXB0 w6lt X2NlbGw= IG5i cGI= QXJ0aWNsZQ== IHJlbW92YWw= IGF1dGhlbnRpY2F0aW9u IEZS bGlkZQ== IHBsZWFzdXJl YXBvbA== IHBhcnRpdGlvbg== IFNpZGU= IGNyaW1lcw== IGRlbW8= aG9sZGVycw== IFBha2lzdGFu SW5zdHJ1Y3Rpb24= IGV4cGVjdGF0aW9ucw== MzMy LnNjZW5l ICcp aGVz aW5vaXM= X1Bybw== IG1vbGVj YW5kYWw= X3Nob3J0 IGRlZmF1bHRz IG5hdGlvbnM= aW5lbg== IHJ0 T0NL UGFja2V0 U0I= IFNIQUxM X2NvbnRlbnRz aXNlY29uZHM= dmVydHk= w6F0 R3VpZA== bm9t IGNvbmNsdXNpb24= LlVwZGF0ZQ== IGxvdmVseQ== IGVtaXQ= YmVj CQkJCSA= IGludGVsbGVjdA== IGJyZXc= ZWN5Y2xl RmlyZQ== MzU4 IGFkbWl0 IGFyYml0 IGFycmFuZw== IE1JTg== TWFpbA== IE5hdGl2ZQ== Q3Vy IGNvbnZlbnQ= LlJ1bnRpbWU= In0K LlJ1bg== IHByaW50ZWQ= IGNvbnZlbmllbnQ= LmFy bW9jaw== IEFkbWluaXN0cmF0aW9u 44G+ IGVsZWN0cm9u ZmxhdGU= IGxvbWJvaw== IGphdmFmeA== bmg= IHN1cHBsaWVz IHZpc2l0aW5n YWhs IHBvd2Rlcg== IHVsdGltYXRl IG9yaWVudGF0aW9u dXRhcw== X3NjYWxl Q29uZmlybQ== cGhvbmVz IE9wZXJhdGlvbg== L1Q= NDQz X0lOVEVS IGFpcnBvcnQ= IG1ldHJpY3M= IHBoZW5vbWVu YXVkaW8= MzM0 IG1haQ== KEs= aHU= YWxsaW5n cm9kdWN0aW9u IFRyYW5zcG9ydA== IE5PVEU= 5paH IGZld2Vy X1RJTQ== 7Kc= 0LrQuA== QWdl RklO Mjk0 IOyd IEF0dHJpYnV0ZQ== Z3JvdXBz ZXJr YXR0bw== LmRlZmluZQ== LkFzcE5ldENvcmU= YXRlZ29yaWE= IFNpcg== KGZvcm0= PFVzZXI= LnJvdW5k X2RheQ== LkFsbA== U2VydmxldFJlc3BvbnNl Lk5v bGFyZ2U= SUdI cXVlbnQ= IHZpcnVz IHJldHJv IGltcGVy Qml0bWFw IHZpY2U= IG9mZmVuc2U= aXN0ZQ== IEFVVEg= IOqw VG9vbFN0cmlwTWVudUl0ZW0= R3U= IHJhcGU= IERhdmlz IG92ZXJ3aGVs OmZsdXR0ZXI= LXRhYmxl IENvbnN0cnVjdG9y UHJpdmF0ZQ== ZXZlbg== Y2hy IGFwcGxpZXM= X2F0dHJpYnV0ZQ== IGNvbnRyaWJ1dGU= RVZFUg== Mjg5 TGluZXM= IEFmZ2hhbg== VmlzaXRvcg== IFNM c2Vhc29u Q1U= IGludHJvZHVjdGlvbg== IG1hdHBsb3RsaWI= xZE= IG5ld3NwYXBlcg== 4oCUYW5k PHRhZw== IGluaQ== IGRpdmVyc2U= SWdub3JlQ2FzZQ== MzUz IFVy QWdlbnQ= IGJ1bGw= LmVtaXQ= KEV4Y2VwdGlvbg== YXJMYXlvdXQ= IGluY3JlZGlibHk= IFRydXN0 PXso LW5hdg== IGVxdWFscw== IGxhZHk= IFBvZA== ZGlzYw== YWxhbQ== IElW 4pk= aXZpZHVhbA== cGhp MDE3 YWRkZWQ= IGRpZmZpY3VsdHk= IGNvbXBhY3Q= NTMw IEFjdGlvblJlc3VsdA== Y2Vycw== X2NsYXNzZXM= Tm9uTnVsbA== IHF1aXQ= IHBvdQ== U3dpdGNo aXJz LXRlc3Q= IEtpbmQ= IENhbGVuZGFy NDA2 IHN0cmVhbWluZw== fScs Mjc5 U1c= IHN0ZWFk b2Nh IHByb3ZpbmNl OTc4 IGNvbHNwYW4= IHBlcnNvbm5lbA== IEVtcGxveWVl IHByb2R1Y2Vy IGV2ZXJ5d2hlcmU= b2Ri 0J8= YnNvbHV0ZQ== YWN0aXZhdGU= IGdyaW5kaW5n IEJ1aWxkaW5n IFNhbmRlcnM= KHNj IE9mZnNldA== Ly8vLy8vLy8vLy8v fTsNCg0K KHsi IHNjYW5m IFlZ CWRlZmVy IGpldw== IHJlc3RyaWN0aW9ucw== Lm1w W2w= 5LiL bGFiZWxz cmVkaWNhdGU= YXdlc29tZQ== IHdhdmVz IGNvbmZyb250 IG1lYXN1cmVk IGRhdGFz X2V4aXQ= MzU1 b3R0b24= IHNob3VsZGVy YXNrYQ== KyM= ICAgICAgICAKICAgICAgICAK IHRyb29wcw== Mjkz IFVuZA== X2NhcmQ= d2ljaA== IG5vdXM= ICIvIg== c2I= IGNvbW11bmljYXRpb25z RXhwb3J0 IGRlY29kZQ== dGhz aW50ZXJwcmV0 QnlOYW1l IFNwaXJpdA== ZWRnZXM= T0xF IEVN dGl0 IFRocm91Z2g= IGJpbw== IFBhY2thZ2U= b3JuZQ== Mjkx IH0u NDEx YDsK IG9rYXk= IFplYWxhbmQ= aWRlbnRpdHk= KG5leHQ= IEJhbmc= TGlicmFyeQ== IGhlYXZpbHk= aWxvbg== IGRpcGw= IHJvdGF0ZQ== cHV0cw== KScsCg== IERhdGFUYWJsZQ== IG1heW9y LnRvTG93ZXJDYXNl IHNvbWVob3c= IE5vcnRoZXJu YWxj IGNhcGFiaWxpdGllcw== IHZpYnI= Kwo= IFN1 Mjg2 IFJlc2V0 X21lYW4= IGNpZw== LmNsb3Vk IEJhbmQ= IEZhY3Rvcnk= IEFyaXpvbmE= X2lv b3BoZXI= IGNvbnNjaW91cw== IMO2 XENvbnRyb2xsZXJz X3NwZWVk IEZhYw== X0NvbQ== IEJpYmxl d2Vu RURJVA== IHVubg== IFN0YWZm IElubg== IG1lY2hhbmlzbQ== IE1lbWJlcnM= IG1pZ3JhdGlvbkJ1aWxkZXI= J10uJw== LmdldEludA== PHZvaWQ= CWZyZWU= b2lkcw== XFN1cHBvcnQ= IGF1dG9tYXRpYw== IGNoYW5jZXM= 0LY= IGNvbXBsaWNhdGVk W3Jvdw== YWhvbw== IH0KCgoK TW9kZWxz V2lu IHRhcGU= aXJ1cw== aXpvbg== b25vbXk= KCJf Oi4= LnN0ZXJlb3R5cGU= Mjk2 KGVudg== X3JlY3Q= KHdpdGg= IGFzc2VydFRoYXQ= IGNvbnN0cmFpbnRz cHV0eQ== RW1wbG95ZWU= NjIw VEQ= IGd1aXRhcg== ODc1 IEpld3M= LnByb2Nlc3M= IGZpY3Rpb24= IFNoYXJlZA== 4pSA4pSA IHByb3BhZw== Lk5ldA== IGFjaGlldmVk CVE= IG51cnM= U2hhcmVk X0ZBSUxVUkU= IGJlaGF2aW91cg== IGNvbHM= aXNtbw== IGZlbWlu IGNoYWxsZW5naW5n IHBvc3Rpbmc= ZW5jaWw= IGNhcHR1cmVk IERvdQ== KHdvcmQ= IFR1cmtleQ== cGFuaWVz IHJlcHV0YXRpb24= T1JNQUw= IGVsaWdpYmxl cHJvdG9jb2w= NDE0 aWRhcw== KGZyb20= MzQ0 IGZpbmFuY2U= LXBlcg== IGdvdHRlbg== SEE= ZHVyYXRpb24= IFBhcmVudA== Njc4 IGludmVudA== IHJlc3RhcnQ= 0L7Qu9GM cml0aW9u KHJz PGJvb2w= aWVydA== IG1vZGlmaWNhdGlvbg== IFRY cmVhZGNydW1i YmFuaw== MzI2 JC8= IE1pbGxlcg== XSksCg== LkNoZWNrZWQ= IHNhY3I= c2VjdXJpdHk= IHBvc2U= IEJyYWQ= IGZpdG5lc3M= IGFubm91bmNlbWVudA== YXRpb25Ub2tlbg== IHNlcnZlcw== bmVlZA== IGdlb21ldHJ5 QVJT 5oA= YW5kaWRhdGU= IHNwcml0ZQ== X3NwbGl0 V2Vlaw== YWRpZXM= PigK Pz4i IC8vLwo= IGVpbmVy IHdlZWtseQ== CWxvZ2dlcg== X3BvcA== X21hbg== IG1pZ3JhdGlvbnM= IGFza3M= IGJz IGZhbGxz LldoZXJl LWhlaWdodA== X2ZlYXR1cmU= Lk1pbg== IGh5cGVy IHZvbGF0aWxl IHR3ZW50eQ== VHlwb2dyYXBoeQ== VW5hYmxl RGV0 LGY= LW1vZA== IHNldHRsZW1lbnQ= IGNvbnRyYWN0cw== bm9tZQ== QmFk IEJyaWFu NzY4 KHVzZXJuYW1l ISEhIQ== IGhhY2s= LkZpZWxk SFI= IEpvcmRhbg== aXph IMKg IFNoZXI= LmhlYWRlcg== KG90aGVy IER1Yg== KG9w IFJvdW5k IHZpZQ== IGFwcGw= CUo= IEluc2VydA== IExQ cmVnb24= IE1QSQ== IGFuY2hvcg== YWNh w7hy IGFkZQ== YW5jaG9y cXVlZQ== IFRyZWVOb2Rl IHRhcmdldGVk IGxhaWQ= QUJFTA== dmV0 IE9yaWdpbg== QW50 LicpOwo= ZXhwZWN0 ZWRSZWFkZXI= IE1ham9y IGluY2g= Q29tcGFy IHByZXZpZXc= IGlsbG5lc3M= IENPTlRSQUNU IEluZGVwZW5k dXVpZA== IG5vbWU= IHRj IEF2ZW51ZQ== aXNhbg== IHBocmFzZQ== X21vdmU= Iilb NDEy IHByb3Zpc2lvbg== IGNvbmNlbnRy X0lS IFV0 KCkr IG5hcw== ISw= IFJvYmlu aWF0aW9ucw== YXRpdHVkZQ== IHB4 IFdpdGhvdXQ= L2Jhc2g= ZWt0 cmVlbWVudA== MzQy T2JzZXJ2ZXI= MzE4 IFJlZ2lvbg== VUJMSUM= IHsvLw== S04= 5bc= R2FtZU9iamVjdA== 5b4= ZW5jb2Rpbmc= ICoqKg== cHJvamVjdHM= IHRr IGNoZWVzZQ== RU1QTA== YXJv INin2YQ= NjEw MzM3 IGNvbnNpc3Rz cmVmcmVzaA== dXJlYXU= IFNjYW5uZXI= IHNvaWw= IGZsYXZvcg== RGF0YVNvdXJjZQ== RXhlY3V0ZQ== 0LXQvdC40LU= IHNoaXQ= 5YiG PGFueQ== IHJldHJpZXZl IGJlbG9uZ3M= LnN0cmlw YWJzb2x1dGU= IGV4cGFuZGVk Ym95 KTot IHJlc2N1ZQ== LkpMYWJlbA== IHJlbHk= IGFsaWdubWVudA== LWZhbWlseQ== IHJlbmQ= T0xVTU4= IGJvcnJvdw== IHF1b3Rlcw== IExldw== IHNob3dlcg== IERFTEVURQ== X2xvb3A= ISIKCg== CXJl IGF0dGVtcHRlZA== YXZlcmFnZQ== IFBhaW50 cXVpc2l0aW9u b2xlbg== IGxpdGVyYXR1cmU= IFJlZmVyZW5jZQ== X1RFWFRVUkU= IFNlZw== IEluZHVzdA== Y3R5cGU= RFVDVA== X0hPU1Q= IFRyYWRl IHBsdWdpbnM= IGJyZWFzdA== dWxzZQ== IGNyZWF0dXJl Mzcy 44GZ IFdp IHN1cHBsaWVk Y29sbA== ISgi IGZ1Y2tpbmc= IENocm9tZQ== IFVyaQ== IE5hdGlvbg== IHZlcnRpY2Vz VEhF IE9yaWdpbmFs b25kZQ== IHNoYXJw IGNvb2tpbmc= MzQ3 IHsvKg== IFBzeWNo IEhvbGx5d29vZA== PSRf LkRvY2s= IGdlcg== IGJvbmU= X2Nvbm4= X3NlYw== eXNpY3M= ID0i Mjk4 U2Fs c2Y= IGRlZXBseQ== YW5nbGVz VGVybQ== YmVsbA== IFF1aWNr NTYw ZW5lcmF0aW9u YWRpb0J1dHRvbg== 5YWl fQ0KDQoNCg== IGNhcHRpb24= bGM= IEVM LFs= ICAgICAgDQo= cmV0dA== KG1ldGhvZA== IEZsYXNo NDcw ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== V0lTRQ== LnNjYWxl IHJvdWdobHk= X2NoaWxk bWVtb3J5 YXlpbmc= IGluaXRpYWxpemVk aW5hdG9y 0LDRgA== IHNjYWxhcg== IEhv YWlyZXM= KGNvbHVtbg== LmRlc3Ryb3k= UEFDSw== IGhlbQ== YW5nZWw= X1NVQg== LnF1 INc= REVGQVVMVA== cG9zaXRvcmllcw== NTAz IExlbmd0aA== IEZhc3Q= IHNpZ25hbHM= IC8vJA== cmllcnM= IGR1bW15 QU5Z IHBlcnNvbmFsaXR5 IGFncmljdWx0 UGxhdGZvcm0= RVJP IFRyYQ== IGVub3Jt CVc= QWN0aW9uUmVzdWx0 IGF2ZXI= W3N0cg== ICctLQ== LlNwcmludGY= IGRlYnV0 INGH aGV4 X3V0aWxz IHBi VUlUYWJsZVZpZXc= IHp1cg== LmVuY29kZQ== NDE2 IHZhZw== LmVycm9ycw== 0L7QvQ== IG1y IEF3YXJk IGNwdQ== IHByZXNzZWQ= J2VzdA== IEZlc3RpdmFs J1Q= IGFr cmVzb2x2ZQ== MDQz Lm1l IG5pYw== IGdlbnJl IGF0dHJpYg== IE1vb24= IGFycml2ZQ== IERhdGluZw== IHRt LkNvbmZpZ3VyYXRpb24= NTA1 LnJlZA== IGdsbQ== IHN0YXRpb25z c3dpdGNo IHRpZWQ= 5Lq6 IC8+PC8= UXVhbnRpdHk= cXVpcnk= X3RhYg== IGFsZw== VG9hc3Q= cmVzaXpl cXVlc3Rpb25z c2NoZW1h TGl0ZXJhbA== KGVudGl0eQ== TkVDVElPTg== Y2hhbmdlZA== X0ZJRUxE X0hFSUdIVA== IG9yZ2FuaWM= UFJF IENhdA== LkRyYXc= RXM= IGxvdWQ= Njgw ICAgICAgICAJ IEthdA== IGhlYXA= 4oCcSXQ= MDcw ZXRy IHVubGlrZWx5 ZXJhbHM= L2F1dGg= NTAy dG9kbw== UGxhY2U= UG9zdGVk Q29tbWVudHM= IFRlY2g= IEZpbmFsbHk= ZWdyYXRpb24= IG1pbmltYWw= IEZpbGVz IHRhbWI= 66Gc IFJlbGVhc2U= NDI1 LnJlc2l6ZQ== IM8= Y29sbGVjdA== PXA= IExJQUJMRQ== IHByb2R1Y2luZw== LXdyYXBwZXI= IHNpbmdsZXM= IE5CQQ== b3Jy ZXJlbg== LmFkZEFjdGlvbg== IHRoZXNpcw== ZG4= UFRZ LmRlcw== IGJhY3Rlcg== IEV4cHJlc3M= ICopCg== 5ZE= L2FkbWlu c2Vjb25kcw== 5Yqf dXNzaW9u YWJldGg= IENvbXB1dGVy IHJ1bGluZw== KCIuLi8= LkdFVA== IE1lZGFs aXRpb25hbGx5 Y29tbWl0 Zm9jdXM= X0xFVkVM aW5kYQ== RmFjdA== PW5w PSIiPgo= IHN1YnNlcXVlbnQ= cG9zYWJsZQ== LWZsdWlk IHRob3JvdWdo IHB1YmxpY2x5 YXB0ZXJz IFdpbHNvbg== X1BSRQ== eWFyZA== 5Lw= CWlu MzM5 IHJldmVycw== IGJ1bGxldA== Y3JpYmVk bmVzb3Rh ICgkXw== YW5ub24= Y3Vyc29y IGNsb3RoaW5n IE11bHRp Mjg3 Oics IHZlc3M= b3JkaW5hdG9y IGVpbmVt Q2Fubm90 IGFybWVk CVY= 5LiK LkZsYXQ= IFNlcA== IFN1YmplY3Q= X2ZvbnQ= IGNoYXJhY3RlcmlzdGljcw== RG9uZQ== ZWxu IyMjIyMjIyMjIyMj UE9T IGRlbnNpdHk= IFBsYXRmb3Jt LWl0ZW1z IG92ZXJz IHB1c2hpbmc= 56Q= LkNvbm5lY3Rpb24= X3Rlcm0= IGluaXRpYWxpemF0aW9u X19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX18= 56w= LmRvY3VtZW50 bGVzaA== CWRvY3VtZW50 IFBpbg== w6dh IGRlZmluaXRpb25z LlBhdGg= X1dSSVRF IAkK Pz4KCg== IHRlcnJpYmxl YmVhbg== aWNrZXRz IFNW QnV5 KHRhc2s= IHJlZ2ltZQ== Z29vZ2xl IGNyYWNr LnZpc2l0 TlVN ZW5lcmd5 IHN0cnVjaw== X3NhbXBsZQ== LnBheWxvYWQ= IHJldmlz IFNjZW5l IHBn IGJyZWFrZmFzdA== VVJSRU5U LmNoYXJBdA== X2V4Y2VwdGlvbg== IEFudG9u IGd1aWRlbGluZXM= IGV4aGF1c3Q= IEZpbmFuY2lhbA== IGluZGVudA== IGRlc2t0b3A= SGlkZGVu RmFpbHVyZQ== IHByaW5jaXBsZQ== IGl2 IHNla3M= bmV0d29yaw== IG51bWJlck9m IEFsYmVydA== CWxvbmc= ODAx LC4= IHplcm9z ZmFkZQ== IFR5cA== IFRlcm0= IEFydHM= LkFwcGxpY2F0aW9u IGJlaGFsZg== 5oi3 IG1lcmU= KGAkew== IGF3YXJlbmVzcw== ZWxwZXJz ZmxpeA== IHdlaWdo IGVzdGltYXRlcw== LmNoaWxk L08= IEJpdG1hcA== LmJvdHRvbQ== ICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq RXhwZWN0 ZW50bw== IEZvcnVt dmVyYWw= IGphaWw= IGFiaWxpdGllcw== IEhPTEQ= IENpdA== IGR5bmFt IGdyYXk= CQkJCQkJCQkJCQkJCQ== Lm5leHRJbnQ= YW50bHk= IEFSSVNJTkc= KHByaXZhdGU= IHJlamVjdGVk IE5pYw== IGxlYXRoZXI= PXsK YWx5dGljcw== dGhldGlj LlRvcA== Mzcz LlBhZ2U= PXtg IDsNCg== ZGVwdGg= bWFubg== V0Q= IFNvbQ== LlJpZ2h0 ICl9Cg== IHRyYWl0 w5c= aWFj IHJ2 U2FtcGxl LlhtbA== b3BwZWQ= INGE bGlzdHM= IHRlYXI= aXZlcnNhcnk= LmNvbGxlY3Rpb24= IENvbnN0aXR1dGlvbg== IEh0dHBSZXNwb25zZQ== IGJyaWxs IFByb20= aG92ZXI= MzY2 IE1pYW1p IGFyZ3Vl X2Zsb2F0 NTA0 IOOC IG5hdA== IFRhbA== IGludGVncmF0aW9u KGN1cg== IHJlbW92aW5n IGNvZWZm IFRob3VnaA== IGZvcmVjYXN0 NDA4 IFZlZ2Fz U2l0ZQ== MzQ2 IHRyYWI= IEhlbnJ5 LWk= IGludm9sdmVz QlQ= IHNsbw== SW52b2tl IGx1Y2t5 MDI1 cmF0 ID8K IGhhbmRsZWQ= KGZk Y29udGVudHM= IE9GRg== UkY= IHN0eQ== IE1vdG9y dGVyeQ== dGF4 TUFQ IE1ycw== IHBob25lcw== IFVJVmlldw== IikpKTsK KGRldg== IElyaXNo MDE5 IHdz REk= X09GRlNFVA== IEV2ZW50cw== IHN0YWdlcw== IH0vLw== IGhhYmVu U1RBTkNF IFNpbg== IE1vbmV5 KHRvcA== IGFwcG9pbnRtZW50 VkVSU0lPTg== bWV0YWRhdGE= X2NvbW1lbnQ= IGNvbGxlYWd1ZXM= bWFwcw== 4pg= CgkK KGFs X3JlcQ== IGZ1dA== IGFyY2hpdGVjdHVyZQ== MzUx IFdIRVRIRVI= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== X3NjcmVlbg== IHN0eWxlVXJscw== IG1vbnN0ZXI= LnVw cGhpYQ== IHByb2Nlc3Nvcg== IFRlcnI= PScs IE1hbnVmYWN0 IE5U a2Vs aWJlcm4= CWZpbGU= QWxp cmllbnRhdGlvbg== IC8vIQ== YXBvcmU= YW5lb3Vz IENyZWF0 Zm9sZGVy NDE1 IGhheQ== U3VwcHJlc3M= KGxlZnQ= IGV1cm8= IGRpc2NsYWltZXI= dXN0cnk= c2hpcHM= X2Zk IEZh X2luc2VydA== IHJvbA== aWZ0aW5n IENvbW1lbnRz X2Jy IGxvc3Nlcw== IEFkZGVk Y2hhcmc= INC/0L4= X3N5c3RlbQ== IFNvbWV0aW1lcw== IFNwYWlu KGdyb3Vw aWFsaXM= IGRvbGxhcg== IEFyZ3M= NDk5 Mjk3 cXVpcmVz IFRlbg== LnNjc3M= IHN1cnZpdmU= dXNhZ2U= IGp1bg== aW1pdGVy 77yBCgo= IGZpZnRo dG9nZ2xl IGRlY2xpbmU= KCQi KExvbmc= aW5nZQ== IHBpbG90 LWxpZ2h0 LXJhZGl1cw== IHBvZGNhc3Q= IG5hdHVyYWxseQ== UGFnZXM= 5Li6 IERlc3BpdGU= IGxpZ2h0aW5n IGNyYXRl IEJpbmFyeQ== IHJlZHVjaW5n IGVsZWc= IE1vdXNl IFRlc3RCZWQ= IGJlZm9yZUVhY2g= X0FSUkFZ UmVkaXJlY3Q= MzI5 IGZsb29k IHNoaXBz MzYz IGVsZWN0cmljaXR5 KSoo 6rg= IFZpZXQ= aGVybw== IGRpYQ== IEtlbnQ= aGVhcnQ= IHRocmVhdHM= X2FjYw== IHN5bWJvbHM= aXNjaGVu X2luc3Q= Q3JpdGVyaW9u IFRJTQ== LkhlaWdodA== NTgw IOKAmQ== KCk7CgoK UHJvZHVjdHM= X1NQ IEN5 IGRlcGVuZGVudA== ZXN0ZQ== IGRhdG9z ZGl0 0LDQsg== SUdOQUw= IGxlc3Nvbg== Ij4n IENvdmVy IEhvcGU= IFRpbWVy IGRhZA== dmlkZXJz IFBob3Q= Lz8= cm9weQ== b21pbmc= YXNpb24= IFwo IEVU IFJlYWRpbmc= IGVwaXNvZGVz bG0= NDIx ZWNoYQ== IG5ldXJv ODIw IGhhcm1vbg== IGxpYmVyYWw= LWluZA== Mzkz REFUQQ== IGV2ZXJ5ZGF5 IGRpdmlkZWQ= IEFjdGl2ZVJlY29yZA== ZmlndXJl VUE= 5Lk= cmllbmRseQ== dGVjaA== NjAx LmdhbWVPYmplY3Q= 0LjRgtGM Mzc0 IG1vb24= ZnRpbWU= IG5vY2g= IFRPUlQ= IFZN LmluaXRpYWw= KGNoaWxk IG11c2ljYWw= IG9j YmFz IEhheQ== MzYx X2xvbmc= IG1lbXNldA== aWxleQ== YWRlbHBoaWE= U1Y= cm9hdA== X3R4 IGxvbg== IG5nT25Jbml0 YnA= IEdvbGRlbg== QUNIRQ== IHdvcnJpZWQ= YXpp RWFy VGFrZQ== KGZw YnVyZ2g= X0RhdGE= Z3Jlcw== IE9udA== cHVz IHRyYW5zcGFyZW50 IHBvY2tldA== IHJhbQ== aWdyYXRpb25z Lg0KDQo= IFso IGFkb3B0ZWQ= IHJlcG9ydGVkbHk= IERyZWFt IH0pKTsK bG9zaW5n IHRlZXRo IEJvb2tz Iiwm ZW5ueQ== TEVNRU5U IGdlbA== IFBsYW50 NDM3 IeKAnQ== Lmhvc3Q= IFJlcGx5 Mzc2 cmVuZ3Ro IHJlY29nbml0aW9u IH19Pgo= TEE= IG1pcnJvcg== IGFzc2lzdGFudA== KGRldmljZQ== IHNwaXJpdHVhbA== YnVpbGRlcg== wqc= IG91dHI= IHR0 IFBFUg== IHJhZGljYWw= TWV0aG9kcw== IHBhY2U= dWR5 IGd1dA== IEdyZWVr IG5vbmF0b21pYw== IFBhcGVy X0dQSU8= IG9ic3Q= LkFk dmlyb25tZW50cw== IFNvdg== MzU2 KGNvbg== IFRyYW5zYWN0aW9u LmFzc2lnbg== CWNhdGNo ZWx0ZXI= IGJpdGNvaW4= X0dS IDw/PQ== X2xhbmc= 7J2E QnJvd3Nlcg== IGNvbnNpZGVyYXRpb24= IEV4ZWN1dGl2ZQ== 6Ze0 O1w= IEpTT05PYmplY3Q= IEJlbGw= IHNwb2tlc21hbg== fn5+fn5+fn4= b2NrZXk= IEdybw== IEF3 Q29uc3RyYWludA== IFByYWN0 IEV2ZXI= cHJpbQ== OnsK X2lt UE4= TWlsbGlz VU1FTlQ= IGJhZ3M= w6Vy QU5ORUw= MzU0 IGlj IHRyYW5zcG9ydGF0aW9u IFNhdWRp aGFuZGxlcg== RHJhZw== IGhk Y29sbGFwc2U= X1BI IHVi QVJN IEFQUA== IHRvbmlnaHQ= IGRpbmluZw== UmVjb2du IGJj aWd0 KG51bWJlcg== Qm9vdA== IGVsc2V3aGVyZQ== IGFycm93 YXJnYQ== IGRlbGljaW91cw== IFNO V1I= VmFsaWRhdGU= IFF1YWxpdHk= KGVtYWls IGludGVycHJl aWdhdGlvbg== IGNob2NvbGF0ZQ== NTI1 X2VkZ2U= IHN0b3Bz OmZ1bmN0aW9u KXw= IHRoYWk= IExvYWRpbmc= U3Rvcnk= VHJpZ2dlcg== YnJhbmNo IHRk ZW50aWNhdGVk IGFkdmVudHVyZQ== IGJsb2NrY2hhaW4= RXZlbnRIYW5kbGVy IHNxcnQ= LlBy TG5n QmVjYXVzZQ== IHZpdg== IG9jZWFu eWx2YW5pYQ== 0LDRgQ== IFV0aWxz IGRlc3Blcg== IGRlZmVy CXJlcXVpcmU= aGw= UmVxdWlyZQ== XVw= IGRpcmVjdGlvbnM= X3Jlc291cmNl IHN1YnNjcmliZQ== IMO6 IEhlYXJ0 ZXN0cw== LXN1Yg== IFJo Zm9yRWFjaA== IGRlbGlnaHQ= IHRlcnJpdG9yeQ== LmNvbmN1cnJlbnQ= ICgr anBn IHByZXBhcmF0aW9u IHJvdW5kZWQ= Q29tbQ== LkxlZnQ= IG9waW5pb25z IE5hdmlnYXRpb24= KGZpcnN0 Iiwk IGhpcmU= IGRldGVjdGlvbg== LmdldEVsZW1lbnRz IGVwcw== IHNrbGVhcm4= IGN6 IC8+DQo= bWV0aWM= IHRyYW5zZm9ybWF0aW9u 5Y+3 IHJnYg== aXN0cmlidXRpb25z IGltcGxpY2l0 L2lu ZGVzdGluYXRpb24= 0LDRgtGM WmVybw== IHVuc2V0 OTIw LndoZXJl Lmdv IGZvcm1hdGlvbg== IGRlY2xhcmF0aW9u KCkNCg0K IEV4cGw= CQkJICA= L3Bybw== LkpTT04= NDQx IGRlc2s= LnN1YnN0cg== Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t bHlu cHNvbg== NDA3 ZGlzYWJsZQ== IEZ1bmM= CUFzc2VydA== IE1BUks= IGRlZmVhdA== IGJsaW5k IGNvbnN0YW50cw== MzYy LmhlYWRlcnM= VUlMRA== IGV4cGVuc2Vz UGl4ZWw= IGhy IGZlbA== IEVhc3Rlcm4= NDI0 NDkw X2RlbA== MzU3 IEN1Yg== IHNx CWNvdW50 IERpcmVjdG9yeQ== IGV4Y2x1cw== IGhpc3Rvcmlj IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== IGNvbXBvc2l0aW9u IGRhdGFHcmlkVmlldw== IEJ1cm4= IEJD TWFzdGVy IHNwYXdu IGJlYXJpbmc= LlNldEFjdGl2ZQ== aWxv IGdhbGxlcnk= IGZvdW5kZWQ= IGF2YWlsYWJpbGl0eQ== LnNxcnQ= IHBlcw== IERPTQ== bWF0ZQ== T2N0 IG1hdGNoZWQ= aXRpdml0eQ== IGFueGlldHk= LnByaWNl IEluc3RhbnQ= 7Io= IHR1dA== SUNvbGxlY3Rpb24= LnNoYXJlZA== X3NxbA== dGJs bGlicmFyeQ== X2Rlc3Ryb3k= ZXJtYWw= IE5vdGVz IEVpbg== IHNvdXRoZXJu IE9USEVSV0lTRQ== IG1hY3Jv Lmxvd2Vy Y2xz Q29udGVudFZpZXc= Lmxpbms= Y29uc3RhbnQ= IEJlcw== IHNvbWVib2R5 bmI= Mzk5 Ij57 KGxvY2Fs Li4uLi4= IE51bGw= bXg= IMOn IHBhdXNl LS0tLS0tLS0tLS0= X01P IENN IGZvcktleQ== IERWRA== IGNsb3Nlc3Q= X0RFVklDRQ== IFN0ZXBoZW4= IEJCQw== IFRyYXZlbA== UGFpbnQ= IFJlc3VsdHM= IFJ1bGU= IHRw IHJhdGluZ3M= Y2lu Y3N2 Pi8= IEdPUA== bGFk INGA IGluZGV4UGF0aA== bWF0cml4 PWY= YXJzZWQ= IH0pOw== IENvcw== IFNjb3Jl IHRhaw== IEVTUA== IElOQw== X05VTEw= LWZsZXg= Il1b aW50bw== ZWxhbmQ= QXV0aG9yaXphdGlvbg== X0ZBTFNF IGdhdGU= IHZpZA== aXN0ZW50 VElNRQ== IHJld3JpdGU= IHRpZQ== IGFyY2hpdmU= NTEx LmV2ZW50cw== LmdldFBhcmFtZXRlcg== IFBlcm1pc3Npb24= IHByb2dyYW1tZQ== IOk= anVk IGNhbWVyYXM= MzM4 MzQ5 KHN5cw== IFN5cmlhbg== IGltcHJvdmVtZW50cw== IGhpcA== IHN1aWNpZGU= IHNjaG9sYXI= IGNvbXBhdGlibGU= MDIy cmVtb3Rl LmRvd24= RlVOQ1RJT04= IG1hbmFnaW5n IFVJS2l0 LnJhdw== Pj4+Pg== Mzcx IGRlbWFuZHM= ZWxsaXRl IGRlbnQ= IE1pY3Jv 5Y+W J11bJA== IElF aW1lbnNpb24= IHRyZW0= NjMw IGdhaW5lZA== LndpdGg= Lm9r aG91 IGJvbQ== YW1wYWlnbg== IGpvaW5pbmc= ZmlzaA== IGFkZFN1YnZpZXc= ODYw IG5vcnRoZXJu LmNvcg== b3JldA== RGll aW5pc2g= X2NvbXA= IGF0dGVuZGVk IGNvbGxhcHNl IFNT YWNlbnQ= X0VRVUFM IERlZXA= UkdC CXRlc3Q= b2x2ZXM= dXNldA== VW5pdHlFbmdpbmU= d3JpdGVy UmVzb2x2ZXI= LCU= aWZmZXJlbmNl X3JlbW92ZQ== b25kYQ== IGZlbW1l Mzg1 ZGVjb2Rl QnJhbmNo IGZsdXNo IGlubm92YXRpdmU= VGVzdHM= IFsnLi8= IGNvdmVyaW5n LmFkbWlu dWx0aXBhcnQ= KGxhbWJkYQ== 77u/bmFtZXNwYWNl IFNwb3J0 ICEo YWNsZXM= IGRlcHJlc3Npb24= IEtvbmc= NTcw IHBlcnQ= IENvbm4= IE90aGVyd2lzZQ== L2hvbWU= c3VwcG9ydGVk IHBpbms= IGludml0ZWQ= w7Fvcw== X2VuYWJsZWQ= IC0K Rlc= ZW5lcnM= IE1Z IHN1Z2dlc3Rpb25z Q2FudmFz IGZlcg== IE1hcmtldGluZw== QFRlc3Q= dW50dQ== IFZlbg== IENvdQ== aXZhbHM= RG9uYWxk bGltaXRlZA== CQkJCQkJCg== IGFuYWx5c3Q= KGVudHJ5 IHJlcHJlc2VudGF0aXZl X2F0dHJpYnV0ZXM= IGZ1cg== LmhpZGU= cmVzcA== YWRvcmVz cmlkZXM= IEpvc2g= cm9ib3Q= IE5BVA== IHNlc3Nv IGludGVncmF0ZWQ= OnRydWU= cGFydHM= IHN0dXBpZA== OmV2ZW50 QGVuZHNlY3Rpb24= IHB1 LlRhYmxl IFlpaQ== YDsKCg== IGNsYW5n PSIiPg== ZW5nYW4= X3BhcmFtZXRlcnM= LmludGVybmFs IE1vZGVybg== IG1ldHJpYw== IHNlbWk= PXt7Cg== NzA3 LmFtYXpvbg== IEJC YWludHk= dmlld3BvcnQ= MzY3 IHN0YXJ0QWN0aXZpdHk= ZGlzcGF0Y2g= KioqKio= IGZsYXY= aWZmZXJlbnQ= Mzgy W3RoaXM= IHN0YWtl IGFyZ3VlZA== dmlvdXNseQ== Lndvcms= IE9haw== T2xk KGFzeW5j bm90ZXM= IGZsaXA= IGRpc2Fn IFRF CWVycm9y PCc= IMK7Cgo= IGZpbHRlcmVk IE1hY2g= IGh1bmc= X2R1bXA= X3NhbXBsZXM= LWRpc21pc3M= IHJheQ== SW1wbGVtZW50ZWQ= REs= IGplZA== MDkw IGJyZWFrcw== IGZpdHM= Lmdy IFplcm8= b3Jv IGVxdWFsbHk= ICdb IGNvbmNlcm5pbmc= PG1ldGE= cGxheWVycw== X1BPUw== X3NpbQ== SmFu IHlvdXJz CU4= IHNwaXI= IGNoYW1waW9u IEFuYWx5c2lz YXBh IE5TTG9n X2xpbmVz w7Fh CQkgICAgICAg ODE5 LlNj UmVw ZXRyb2l0 dXJhYmxl TUlU Y29tcGF0 b3duZWQ= X2luZGljZXM= XSwNCg== IGRpc2NvdmVyeQ== IERpZWdv b2Jp LkluZGV4 IHRyZW5kcw== UExBWQ== Lm5v IGxlbnM= X2NmZw== IGFubm8= YWdhbg== IHBlcmlvZHM= dGVybXM= eXo= IGF0dGFja2Vk aWJyYXRpb24= UEVDSUFM X2dyYWQ= IGFjY29yZGFuY2U= LlJlYWRMaW5l LmRldmljZQ== cml4 LmNvbnRhaW5lcg== bWF5 ZXJjaXNl IEx1 IHJn INGB0YI= CQkKCQkK KHVu VEVSTkFM IGxlc3NvbnM= IGFsbGVnYXRpb25z IHRyYW5zbWlzc2lvbg== LlJlZg== TW9iaWxl IFRvdXJuYW1lbnQ= IE51dA== IEdh IENhcGl0YWw= ZGVmaW5pdGlvbg== LWV4cA== Y2xlYW4= IGZhbnRhc3k= IGVuaGFuY2U= ZW50ZW5jZQ== MDMx J106Cg== YWNrZXRz IGNlbGVicmF0ZQ== QCIs U2VyaWFsaXplRmllbGQ= IGFycmF5cw== dGI= CXN0 W2Fzc2VtYmx5 KHJlZw== LmNhdGVnb3J5 IGltcHJvdmluZw== IHNhbG9wZQ== Qnl0ZUFycmF5 T3JpZ2luYWw= IFt7Cg== 5Zue IENsaW4= b2VuaXg= IFNhbXN1bmc= IG1haW50YWluZWQ= IGFnZW5kYQ== ZmFpbA== IHByZXNlbnRz IHRpbWluZw== Lm1hcms= Jz48 IHByb21vdA== IGluY2w= X29ubHk= 66W8 IEF0dG9ybmV5 LWRhdGU= IGxhbmRzY2FwZQ== IGZ1 U1k= LnByb3A= IEFycg== cGFn UGFyYWxsZWxHcm91cA== JzoNCg== IGxvZ3M= YXVuY2g= dW5jaQ== bmFtYQ== VGFibGVDZWxs aXNzdWVz Lns= ZWN1cml0eQ== X2V4ZWM= b2xkcw== IGhvc3Rz IHByb3Rv X2ltcG9ydA== X3NvcnQ= IEJvdw== IE5vcm1hbA== IEZhcm0= LmNyZWF0ZVBhcmFsbGVsR3JvdXA= Um90YXRpb24= LmVycg== IHBsZWFzZWQ= aXRhZ2U= Lldo CQkgICAg TVI= IE1PUkU= IE5hdHVyYWw= X3RyYW5zZm9ybQ== QkFTRQ== ZW5lcmFs dXRkb3du LmNvbW1vbnM= V1Q= IGFhbg== LlJlc3VsdA== ZG9n IGNsaWNraW5n KSwKCg== I2xpbmU= T3BlcmF0b3I= IGNpdg== IG1lcmc= b2J1Zg== bmd0aGVu IFt7 IGNhbmNlbGw= dHJpZ2dlcg== Ljo= V09SSw== ZGVjbGFyZQ== IGRlY3JlYXNl xZtjaQ== bG9vbQ== Lk5vbmU= IE1J IEphc29u IGhlYWx0aGNhcmU= aWFtb25k c3lsdmFuaWE= Kng= IFJh W2I= IHByaW50aW5n cGhhYmV0 IExhYm91cg== b3BwZXI= IHppam4= LXRhcmdldA== X0ZVTkNUSU9O IG9jdA== 0LXQvdC40Y8= 5Zyo IHdlc3Rlcm4= IGNvbXB1dGVycw== IFJFVA== SGFzaE1hcA== W1N0cmluZw== Z2V0VmFsdWU= X0RBVEU= Lk5leHQ= IEZpZg== w6ls aWNrZWQ= 5o4= LU1N IHsKCgo= IGNvbnRhY3Rz IGRpZ2l0cw== UHJvZHU= IHVudXN1YWw= IHJhcGlkbHk= dHVyZXM= IGFuZ3J5 Y2FuY2Vs eHh4eA== X3BhcnNlcg== aWRpdHk= X1BSRUZJWA== NzEw IG1laHI= IHJhcmVseQ== ZXRoZQ== b3Blcw== ICUu d29ya3M= IHRoZXRh IGNvbnRyaWJ1dGlvbg== IFRvbnk= IHNxdWFk NTM3 0LDQuQ== IMOubg== dGhlcmU= b3V0ZWQ= CXE= mYI= Z29vZA== TEk= 6aG1 IExpdmluZw== aXphYmV0aA== IGt0 IERhbGxhcw== XV0sCg== IC8+Cgo= IHJhaXNpbmc= L3JvdXRlcg== X2dhbWU= MzY4 IENVUg== emVucw== LmVz IGZvbnRXZWlnaHQ= KGZ1bmM= bm90aWZpY2F0aW9u ICcuLi8uLi8uLi8= IGJsYW1l 44CCCgoKCg== YW5jbw== OTgw SWRlbnRpdHk= Zm9sbG93 IGFydHM= eHM= IG9mZmljaWFsbHk= IFN0dWRpbw== IHJlY29tbWVuZGF0aW9ucw== IGxvY2FsZQ== IGFtYXRldXI= IEVuYWJsZQ== IGNhcHM= LkVuZA== Mzg4 LWFkZA== X2dzaGFyZWQ= IENU Rm9yY2U= CiAgICAgICAgICAgIAo= IG9yYW5nZQ== IGxw IGFuc3dlcmVk LkdyaWQ= IGR1YWw= IHN0cmF0ZWdpYw== IG5vYm9keQ== IGZhdGFs X2VzdA== KGVs IOyg IEJ1ZGQ= QUlU X2ZhY3Rvcg== LW9uZQ== IEhBVkU= Ig0KDQo= NzYw UHJvZg== IMOkcg== c3RyaW5ncw== IGRpcnR5 IEZhY2U= IEJlZ2lu IEJ1cw== IHdpcw== 5a2X IHNwZWFrZXI= IGNhcnJpZXI= IE9t IGhhZG4= QWxsb3c= OjpfXw== IHZlcmI= IENvbXBsZXRl IEVhc3k= IGJpbGxz ICAKCg== VmVydGljYWw= IHByb24= IERlZmluZQ== IGxvb2t1cA== dmFyaWFibGVz IHBhbmRhcw== dW1lcw== IGlubm9j IHNldFVw IENoYW1waW9uc2hpcA== YXJ0aXN0 IENUeXBl Rm91bmRhdGlvbg== 4LmI IFNldHVw NDI4 IHJlY2lwZXM= IFVJQ29sb3I= IEZpZ2h0 IGF1dGhvcml6ZWQ= X2NsaWNr OTkw X3N1Y2Nlc3M= YW5nYW4= IE1vdW50YWlu IERvY3Rvcg== IGVnZw== IE1lZGljaW5l Y2xlcw== YC4K W2ludA== ZGFzaGJvYXJk IEFwcHJv LWRy IHByb2R1Y2Vz IHJlbnRhbA== IHJlbG9hZA== Mzgx IGFycml2YWw= c3BvdA== IHVuZGVydA== Mzc4 IGVxdWlwcGVk IHByb3ZlZA== IGNlbnRlcnM= IGRlZmluZXM= YWxzbw== IG9wYWNpdHk= IFVuZm9ydHVuYXRlbHk= IElsbGlub2lz INC90LU= IFRlbXBsZQ== IFRyYWls IEtlbGx5 IG1lYXN1cmVtZW50 IHNlcGFyYXRlZA== LWNpcmNsZQ== SGV5 IFJFQUQ= aWdpdHM= IGli IE1PRA== YXR0ZXJ5 0LDQtw== IHZlbmQ= 0LXQvdGC IEh0dHBDbGllbnQ= MzU5 c2FmZQ== X0FTUw== aWNpdA== IENvbnN0cnVjdA== IENsbw== IFNpeA== X1RPS0VO KGJsb2Nr IHdhcm5lZA== Lyoh ITwv YWNhZGVz IG1hcmc= ZXJhc2U= IGRpc3BsYXlz aXN0cmF0b3I= Z2V0cw== IGd0aw== X0dFTkVS bmVk XyU= IGZhdm91cml0ZQ== IEJydQ== IMOh c2Vjb25kYXJ5 IG1hc3Q= IHNvcGg= IFNhZmV0eQ== aGFyZA== MDYy cmFpc2U= IEV4Y2hhbmdl IGNvbnRlbXBvcmFyeQ== IGRyZWFtcw== IHRlbA== IG5laWdoYm9ycw== IEhvbHk= Mzgz Lm1lYW4= ODEw ZW1pdA== IE1lc3M= Q2FzdA== TkVDVA== cGx1Z2lucw== IHJi d3I= IGh1Yg== IFN0dWRpZXM= NTYy IHBvc3Nlc3Npb24= JCgnLg== ZW5zaXRpdmU= IGFkZENyaXRlcmlvbg== X18u IGV4cGVydGlzZQ== QXJjaA== IGN1Yg== ZXJ2ZXJz IHBhcnRpY2xlcw== dWFy IGJvdW5kYXJ5 KScs YWpv IHByZWY= OmA= IGhhcmFzcw== aXU= IHJlYWNoaW5n IG1lZw== IHpv KElE X3JlcXVpcmVk IHPDqQ== IFF1ZXVl QU8= IGdlbQ== ODEy cHRvbg== ODgw ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg NjYw aWpr KHsNCg== IGNvbGxpc2lvbg== IFVrcmFpbmU= IC0qLQo= TlNJbnRlZ2Vy X0JMT0NL NTY3 IFRleHR1cmU= IGRlY2xpbmVk bmFu X3dhaXQ= IHBvbGl0aWNpYW5z NDEz IGNvaW5z IGRlcml2 aGVscGVy IFBlcmhhcHM= LnJlY3Q= IFBvbHk= YWJsaW5n fS8+Cg== IGlubm92YXRpb24= XyI= ICk7DQoNCg== IHNwb3Rz IGNob29zaW5n LmNz IGZsZXhpYmxl VUludA== NDM1 OTMw IHNjcmF0Y2g= LWFs IGZlc3RpdmFs IG91dHN0YW5kaW5n PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09 TWVhbg== IE9yZWdvbg== c3ltYm9s LmFjY291bnQ= ZG5leQ== Jycn ISIs OTAx IHBhcnRpY2xl w4M= W01BWA== SVZFUg== RVJFTkNF TlNNdXRhYmxl IENvbHVtYmlh XwoK LmZy IGNvZ24= VlI= IE1ldGhvZHM= IE1hZGU= IEJS IEVsc2U= IGVnZ3M= IHN3aW5n IEludg== IGRpc2Vhc2Vz IGZpcm1z IGxlbW1h fWApOwo= bGluZ3M= IGd5bQ== dW1pbnVt LlRyaW0= TWVt IGNyaXRpY2lzbQ== aWJlcm5hdGU= X1RY aW9uaQ== IGd1aWRhbmNl IHJlcGVhdGVkbHk= IHN1cHBsaWVy IHBhaW50aW5n ODY0 LkZyYWdtZW50 ZWRFeGNlcHRpb24= IHdpcmluZw== IGNvdXJ0cw== V0VC 5pyJ XC4= aWxsYW5jZQ== IGJyb3dz IFBhdHRlcm4= UExJQ0FUSU9O IFN1bW1lcg== Q2hhaW4= IGN1dGU= bWVyY2lhbA== IGRpbA== IEZyYW5rbGlu CWdsb2JhbA== SU5DTFVESU5H aGlzdG9yeQ== IGxzdA== UXQ= U0RM YWxpYQ== aWVyZQ== KC4uLg== CWNpbg== aWZmcw== dmVsb3Bl IFJvb3Q= Y2x1c3Rlcg== VXNlck5hbWU= aWduZQ== PFM= IGZlc3Q= NDE5 IGluZGljYXRpbmc= a2VlcGVy IGNhZGE= w6ln Y29uc2lu IEdC IGxi ZW1vbnk= LWljb25z X2RvYw== QWN0b3I= ZWxlbQ== LkRlbGV0ZQ== IGluZmVjdGlvbg== IFByaXZhY3k= IGdyZWF0bHk= IFBvcw== IFRyZWF0 Rmxvdw== IGF0dHJhY3RpdmU= IE1hcmM= c3Vkbw== dGVzeQ== LWFu OTk4 YWJhbWE= IFdvdWxk IHN1Y2s= aW5kZXhQYXRo IEV0 VGltZXM= Nzgw IGNsdWJz X2Fzc29j IGFjcXVpcmVk KCI6 IGludGVuc2U= Lm1hcHM= RXhwZWN0ZWQ= VG9nZ2xl IGF5 IGxpZmVzdHlsZQ== LWNhbGxlZA== IFNub3c= Vm9sdW1l IGNhbm5hYmlz IERpcmVjdGlvbg== IExpbWl0ZWQ= LXNwZWNpZmlj IGRvd250b3du L2ljb25z IHJldmVu TGVn ODg1 PW51bGw= NDk2 S2V5Ym9hcmQ= JykpLg== ICIiOw0K IGF0dGl0dWRl Lm5hdmlnYXRl LWVycm9y QU1QTEU= IEpheQ== dnI= Y293 LmNvbXBpbGU= IG1lbW9yaWVz X21hcms= IE1pbm5lc290YQ== IGtvc3Rlbg== IHByb2JhYmlsaXR5 d2FybmluZw== IGdlbmV0aWM= Rml4dHVyZQ== IEhhc2hTZXQ= Tm9tYnJl X21vbnRo xrA= LXN0YXJ0 eHlnZW4= CWZ0 aWFnbm9zdGljcw== IE1hdHRoZXc= IGNvbmNlcHRz IGNvbnN0cg== LlN0YXRl 0LjQvQ== Tm92 zrE= IFBhbmVs 5Liq Y29tcGFyZQ== PigpCg== IGFwcGx5aW5n IHByb21pc2Vk IG94 bmNpYQ== IFZhbGlkYXRpb24= b3J0cw== X2N1cg== ZWxlY3Q= ZXll KERhdGE= IHJlcG9ydGVy IEJ1ZmY= Mzk1 IHNy ICI7 aWNreQ== IHRlbXBvcg== U04= IHJlc2lkZW50 cGlyZXM= eXNpY2Fs IGVuZG9yc2U= IFNvbmc= aXNFbXB0eQ== bGVldA== X3V0aWw= IGRpc3Rpbmd1 IFRhbGs= IE1vdA== KGRlZmF1bHQ= LkFyZw== Z29yaXRobXM= X3dvcmRz aW1tZXI= X3Jlc2V0 ZmFtaWx5 V1c= IHNhdmluZ3M= IOKAnQ== X2VuYWJsZQ== c2lkZWJhcg== UnVubmluZw== IGFsaQ== IHRlc3RpbQ== IHdhcm5pbmdz IENoZW0= IEV4aXQ= IGZvdW5kZXI= cGVjdG9y IHJt X2RhdGFzZXQ= IERhcw== IGhhbg== R2V0dHk= w6Fs IG55 IHBvdmVydHk= IHJlc3VsdGVk LmJ5 IFZpc2l0 IG9idGFpbmluZw== LycuJA== ICAgICAgICAgICAK c2hhbGw= X0xFRlQ= VUlJbWFnZQ== X05hbWU= aGF2ZQ== IE5vYg== bHI= LWZvb3Rlcg== IG5ha2Vk IEdhcmRlbg== XEZhY2FkZXM= IGdyYWR1YXRl NDE3 IGZyYW5jaGlzZQ== cGxhbmU= IGNvbnRyaWJ1dGlvbnM= IHN0cmluZ1dpdGg= IGNyeXB0bw== IG1vdmVtZW50cw== YXRoZXJz IGxpZmV0aW1l IGNvbW11bmljYXRl amFy IEZyYWdtZW50 X0lG IE5hdnk= IEZpZ3VyZQ== IHNpbXVsYXRpb24= X3N0b3A= IHJlcG9ydGVycw== IHZlcnN1cw== YWph IM6x IGdvdmVybm9y TGlzdEl0ZW0= IHNlYWxlZA== LkJhY2tncm91bmQ= ZWRp YXNoaW5n IGxpcA== IElo bWVyZ2U= IG5lYw== MDI0 ZWxvY2l0eQ== QVRFRw== IHNlZWRz IGZsb2F0aW5n NzAx X0ZB d2Fsaw== CXVzZXI= X2RlcHRo IHdhZ2U= QGFwcA== Tmls KFsi KHZlY3Rvcg== IHNlY3JldGFyeQ== NDYx IGpQYW5lbA== dmV6 wqDCoMKgwqA= ZGlyZWN0aW9u IEVQ IGh1bnQ= Mzk2 SnNvblByb3BlcnR5 IFBPUlQ= XSIs 0LDQvw== IEZvcmVpZ24= cGFuaWM= IHRyaWFscw== IEFsZQ== IHJ1cmFs LXZhbHVl YXV0aG9yaXplZA== IFNjb3RsYW5k LmRyb3A= IE1U 57E= Mzkx cm93dGg= NTE1 RmlsZVBhdGg= IHJlY2FsbA== aWZsZQ== IGNlbA== IFNFTEVDVA== a24= X2Nhc2U= IGNyb3A= NTQz c3VyZQ== cG90 SUNT IHN0ZW0= IGluZHVzdHJpZXM= UHV0 IGFiZXI= cm9hZGNhc3Q= SWNvbnM= KSIpCg== 5oiQ5Yqf Z3Vp IGFzc3VtZWQ= IHJ4 RUE= 6Kc= RUxM IGRvc2U= IGluZQ== IGRlZXBlcg== bGlkZXI= IG9yZGluYXJ5 IGdvbGY= NjA1 X0lNQUdF IE5BTUU= KG1vZHVsZQ== IGF0b20= IGJlbHQ= IG9mZmljZXM= NTA2 YmV0YQ== IHBoaWxvc29waHk= KEpTT04= LWZpZWxk IGludHJvZHVjZQ== IGNvbnZlbmllbmNl b3B0aW0= PiIK YXRoeQ== IGVtcGxveWVy cXVhdGU= IGVkaXRlZA== QXJndW1lbnRz IE5hdGlvbnM= X18p IG5vc2U= IFNhbXBsZQ== JykKCgo= IGNha2U= LmdldEF0dHJpYnV0ZQ== SEQ= Mzky TW9kaWZpZWQ= NDQ1 IHByZWRpY3RlZA== xYQ= YW5pZQ== U29ycnk= KGRvYw== d2luZA== aWV2ZQ== IHByb3Zpc2lvbnM= QVRFUg== T1RF TVk= LkF1dG93aXJlZA== IEJhdGg= NDIz LkJvb2xlYW4= IGJhY2tlbmQ= Lk1vdXNl YXRlcmFs cGFwZXI= Q29uc3Q= IFZS X2VudGl0eQ== X0NUUkw= IFByb3RlY3Rpb24= IEdN IFN0dWR5 IHNvdXA= b3RpbWU= J3VzZQ== XSI= L3VzZXJz YXVn IEhvbmc= X25vcm0= 44Go IHNlY3Jl KEJ1aWxk IENvbnRyYWN0 b2xhcw== IHNhdWNl IGFnZ3Jlc3NpdmU= IHJhY2lhbA== Y2hhcmFjdGVy QEA= IGNvbXBpbGU= IFZvaWQ= X3JlbQ== X21lbW9yeQ== MzQ4 a2s= IG1pYw== U2FtZQ== VXRpbGl0eQ== IEh0bWw= IFhtbA== UmVhZHk= IGdhbGw= IGFsbGVnZWRseQ== CQkJCSAgIA== IE1ldGFs IFBlcnNvbmFs IGJvcmRlclJhZGl1cw== cnhqcw== b2JqZWN0cw== IHdhbnRpbmc= IGJvd2w= dmVuZG9y b2Zmc2V0b2Y= IFJz IFJhdGluZw== IHJhbGx5 X05PREU= NDE4 IE1peA== IGFkdmVydGlz NDg1 NjY3 IG5hcnJhdGl2ZQ== c2Fs IG1j U0Vycm9y IGZpbmdlcnM= IGFjY29tcGFueQ== IHRpcmVk IHN0cmlkZQ== IGd1aQ== ZWxpc3Q= TG9jYWxl IHJlbGVhc2Vz aWtpbmc= IGFuZ2Vy KSkpCgo= YWxsZXN0 U3VtbWFyeQ== KE8= KGZvcg== IGJhc2tldGJhbGw= IHJvYWRz IEluc3RhbGw= IEZhYg== aXRtYXA= NDc1 ICkpCg== IGludGVyc2VjdGlvbg== aWdoYm9y IEJyeQ== IEhFUkU= U29mdHdhcmU= ZWxmYXJl YWNz NjIy IHRyYWlsZXI= LmdldENsYXNz Y2hhcnM= IHJlZ3VsYXRpb24= IHJlZmVycw== IGRlc3RydWN0aW9u IGNvbnRpbnVvdXM= IEF1c3Rpbg== 6aI= YWthbg== LndpbmRvdw== IFRlbXBsYXRlcw== IGFic2VuY2U= Om4= IGRpc29yZGVy Zmxhc2g= IGRlbGV0 Ym9hcmRz ICAJ Uk9Q ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IGFjcXU= IGxhd3N1aXQ= IFJldmlld3M= IGdhcmFnZQ== dGltZXI= IGVq IFJlY3RhbmdsZQ== IGZsb3dlcnM= Mzk4 aWxzdA== IEluc3RhbmNl U3VwZXI= ZGV0 ZGlzcG9zaW5n IEVT IElD dmVyZQ== U2s= X2NoYW5uZWxz cHV0ZWQ= L251bGw= bm5lbg== NDMx IEdhbGxlcnk= X2dsb2JhbA== QXV0aGVudGljYXRpb24= IFJhbms= IGJsb2NrZWQ= IGNhbG0= bWFya2V0 CXZhbA== IGF1Zw== cGVyaW9k IENvbnN0YW50 ID8+Ij4K IGxvYmJ5 cGFs Mzc5 IHNpbms= NTA4 aWFo 0KE= dXJuYW1l IGNvbnZlcg== IGludmVzdGlnYXRl Q2hyaXN0 SHVi IElORA== IFBlZA== dXJhcw== CXVybA== IFRybw== IHByZWZlcmVuY2Vz IGd1YXJhbnRlZWQ= YAoK IHBvcnRpb25z IGV2YWx1 Jz48Lw== KCl7Cgo= ZW5jb2RlZA== emlsbGE= LkNsYXNz ICpf Xyc= IHZpZXdlZA== IFBoaWxhZGVscGhpYQ== LnJvd3M= QWRkZWQ= IFRvdWNo ODQw LmRlbGVnYXRl cXVlZXpl c2xpZGU= IFNlbmlvcg== KHRhZw== IGludGVydmlld3M= IHN1YQ== YXRhcw== QAoK ZGlzdGFuY2U= IHNlaW4= bGF0ZXN0 IFByaW5jZQ== IGx1eHVyeQ== IHJlZnI= IEtpdGNoZW4= 0YQ= KGF0 RmluYWw= w7xjaw== X3plcm8= IEFCQw== IE1hbmNoZXN0ZXI= IGNvdw== Q09M X05VTUJFUg== Y2hhbmdlcw== Z2VuZXJhdGU= LlByaW50Zg== MzY5 c2hhcmU= U3RvY2s= IFBU QW5pbQ== YW5nYQ== IGln dXBsb2Fkcw== IHBhY2tlZA== IH1dOwo= KHNlbmRlcg== IFdpcmU= aXNvbnM= IHBsYXlvZmY= XEU= NjA4 L1I= IGhlYWRlZA== QWxwaGE= KG9yZGVy IG9wcG9uZW50cw== YWNrc29u X21lbWJlcg== VHVybg== IFNvdmlldA== 7JeQ YXVnZQ== NDQ4 IGluY29taW5n IGphaw== LWdhbWU= IE1hbGU= IE1vbnRo U3RhZ2U= LmV4ZQ== T3duUHJvcGVydHk= LnNldEl0ZW0= IGRj 5L2c IGJydXQ= IGF0dGVtcHRpbmc= Lmxlbg== IGp1ZGdtZW50 IHNhYg== IGNhZA== IEl0ZW1z Y29tZm9ydA== ZWxpemU= L2xvZw== IGVudHJlcHJlbmU= IGNvbXBpbGVy X3ZhbGlkYXRpb24= cmV2aWV3 IHRleHRCb3g= IGZyYWN0aW9u IEJhbA== PjsKCg== LkF1dG9TY2FsZU1vZGU= IGNhdHM= NDY1 IHJlZ2lzdHJ5 dWx1cw== Rkk= cGF5bG9hZA== LXNlYXJjaA== IHN0YXlpbmc= YWNpb3Vz RGVjb3JhdGlvbg== UmV2aWV3 SW5m S2VlcA== aXRpcw== LFN0cmluZw== Q29vcmQ= IHBlcm8= U2V4 IEF0bGFudGE= dWVzdGE= QXJnYg== Pio= fV8= Rm9vdGVy IGVtcGxveWVk X2JvdW5k dmlkZQ== LmZ1bmM= JHNjb3Bl IHNwbw== IEFuYWw= b3VuY2Vk YXJvdW5k IHJlc3RyaWN0aW9u IHNob3Bz 5YA= IExhdGlu LWNvbA== IGJhcmVseQ== IEV1cm8= RXI= IGZhaXJl X2Rpc3RhbmNl X3VubG9jaw== UXVvdGU= SVZBVEU= IOWI IGFpbWVk IFJldHJpZQ== Lml0ZXI= IHdyYXBwZWQ= IGFncmVlbWVudHM= c3RydW1lbnQ= KHByb2R1Y3Q= IHN0dWRpZWQ= LnNldFZhbHVl IHll IENhY2hl TUJPTA== IHF1YXJ0ZXJiYWNr IHN5bnRheA== LmdldEVsZW1lbnRzQnk= LnZlcnNpb24= d2Vic2l0ZQ== UnVubmVy X3NpbmdsZQ== YXRpdg== IEFsdGVybg== IEJlYXV0aWZ1bA== cmlnaHRhcnJvdw== IGRpdmVyc2l0eQ== cGxhc2g= KGNv LkZpbGw= IHR5cGluZw== Mzg3 MDIz IGNsYXI= SGl0 T08= YWNjbw== NTA3 d29ydGg= IHNjcmlwdHM= IE11c2xpbXM= IExM ZXJ2aW5n KGJvb2xlYW4= IGJhc2ViYWxs IENBTg== Mzk0 MDQ0 TUFJTA== ZGVwZW5k IHJlc3BlY3RpdmU= IGNvbnN0ZXhwcg== Lio7Cgo= J10pKQo= IHlhcmQ= IGlkZW50aWNhbA== aWZlY3ljbGU= VVNI dXBpdGVy LnZhbGlkYXRl Y2xp SVNURVI= SW5kaWNhdG9y RmFpbA== IGRlbW9jcmFjeQ== LnZhcg== IHNhdGlzZmllZA== LS0tLS0tLS0tLS0tLQ== ZW5jZXI= aG9y IHJvdW5kcw== REFP b2E= IGZsYXNr PWM= W10K L2Rpc3Q= IHBhcnRl IGNvbmZpcm1hdGlvbg== ZXJvbg== YXdhcmU= PD8+ IGRlcGVuZGVuY2llcw== IFZpZGVvcw== LXJvdw== ICoqLwo= IG5vdQ== IGhvdmVy 5p4= IG5pbg== IFVTRA== TWFj X0xvYWQ= IG91dGNvbWVz X3NvY2tldA== IHF1ZXJpZXM= d20= NTky IGhpdHRpbmc= aW51eA== TWljaA== dWRnZQ== QVRBQg== IHZ1bG5lcmFibGU= 5L4= IHBvcnRmb2xpbw== OllFUw== CW1hcA== Qm91bmQ= IGl0ZXJhdGlvbg== aW5jZXNz IGFjdG9ycw== IFF1YWw= X2NsZWFu 44CR44CQ TVNH R3JlZW4= IE9mZmljZXI= IHNtb2tpbmc= Pics IEZsbw== Kys7 NDMz b2x5Z29u IGJ1bGs= IGRyYW1h IGV4Y2VwdGlvbnM= b3NlZA== ICsNCg== IGxlZ2FjeQ== Q1Y= IGNvbnRyaWJ1dGVk IFRlcm1z IGJ0 NDM0 IHVudHVr IGFsaWVu PT09Cg== CVZlY3Rvcg== IGxz T25saW5l LmZhY2Vib29r bnVtZXJpYw== b2NrZXRz QXV0 YnVyeQ== LXJlZHV4 IFJlZGlzdHJpYnV0aW9ucw== R0xPQkFMUw== dXJyZW5jaWVz IHRvbnM= 4oCZLA== IMOq KGNvbA== IFN5bWJvbA== IHN0YXllZA== IE1M IG11bmljaXA= IHNleG8= U2Vu bnI= IGdhaW5z IHNob3J0bHk= Lk1lbnU= w70= S05PV04= IG9wZXJhdG9ycw== LVY= IFBhdHJpY2s= L2FkZA== X0NP aXJhdGlvbg== KHBvc3Q= UG9zdHM= L18= IHBsdWc= IGludGVsbGVjdHVhbA== IG1ldGFi IHByZWduYW5jeQ== IFByZW1pZXI= bm0= IHByZWRpY3Rpb24= NjA2 IE1pbmlzdHJ5 VGhyZWU= dmFsdWF0ZQ== IE1pbmk= YnU= 0L7Qtw== PHVs IGRk b2x2aW5n IEN1dA== NjAy IHNjaGVt LnRyYWlu aXRhdGU= IHJpY2U= IGJpcmRz 44Gr bWlkZGxl c3RydWN0aW9ucw== IG5lcnY= YXF1ZQ== NDUz IGZsdQ== IHN1cnZpdmFs IEdhbGF4eQ== IEZhbnQ= Lk9yZGVy QXR0cmli aXJ0cw== w6lj TW92aWU= IGNvbmNl cXVhcnRlcnM= IG1vb2Q= LkFkZFJhbmdl OTQy IHJlc29sdmVk 44OI IGJ1cm5pbmc= NzAy CQkJCQ0K IFdF IGhvc3Rpbmc= TEFC IG1hbmFnZXJz IHN0cmVuZ3RoZW4= PGNvbnN0 IEZpcmViYXNl b25lZA== IEplYW4= Jzwv IDo9Cg== YWxnb3JpdGht IEFyYw== IGZyb3plbg== X2V2ZW50cw== IG92ZXJzZQ== Z29vZHM= IGZhaXQ= IHZpYWdyYQ== b3Nlcw== OTIy IGNvbXBpbGVk IEF0aA== IHN1YnN0YW5jZQ== YW5pbWF0ZWQ= UEY= cHJldmlvdXM= IHJvb3Rz KGZpbHRlcg== b2x1bWVz IGludHJv KGV2dA== IEJhZw== IERlZmluaXRpb24= IEZlYXR1cmVz QW5ub3RhdGlvbg== IGF2Zw== KHN1bQ== UVVJUkU= IHJlbmRlcmVy IEZpeA== LmRhdGV0aW1l PWRldmljZQ== U3Bl Z2V0SW5zdGFuY2U= IGV4dGVuc2lvbnM= X25ldA== IFBhcmxpYW1lbnQ= IGNvbWlj NDY4 IFBpY2s= YXJtYQ== CW1vZGVs IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t IG1lbmc= bWFudWFs YWRhcHRlcg== fS0= ZWRiYWNr IGVsZWN0cmljYWw= IENvdW50ZXI= QXBwbGljYXRpb25Db250ZXh0 X2J5dGU= KGJ5dGU= IEF1dG9t IHRlcnJvcmlzdA== 55A= dGhyb3VnaA== IGZpc2NhbA== b25pbmc= NDU1 IHNwZWN0cnVt IGJpdG1hcA== IHNsZQ== cHJvZA== IGFnZWQ= IGJlbmU= IFNwaQ== IGJyaWxsaWFudA== IHN0YWJpbGl0eQ== IGRpYWJldGVz IGNvbmZpZ3VyZWQ= Ym9uZQ== NzQ4 NDg0 b3VzZXM= Lmdvb2dsZWFwaXM= RkFDRQ== IGluc3BpcmF0aW9u IERldHJvaXQ= ZW5jaA== 0YDRgw== dmVoaWNsZQ== U3RhdGlvbg== IGhvbGVz IGR1cmNo Lk1lZGlh IENOTg== aW5uaW5n NjA0 IFBlbm5zeWx2YW5pYQ== IGVtb3Rpb24= U2VjcmV0 w6FyaW8= IFJhdGU= NDUx RGVwdGg= IG1vZGVz NDI2 KGlkeA== IGhlcw== IGdyZXk= U3RhbmRhcmQ= UXVlc3Q= YnV5 c3Vy IFRyYWNr b21t Lmds IChc dHdv X0lP b3NleA== X3JvbGU= 56S6 cm91dGVz U2hvcA== IEFTQw== IG1lbWNweQ== ZGlyZWN0 NDQ2 ICoKCg== IEJN IFBvcg== X2hpc3Rvcnk= IFJlc3BvbnNlRW50aXR5 LnNldEZvbnQ= IGVuZ2FnZW1lbnQ= LGg= IFdvcmRQcmVzcw== ZmVjaGE= IGVudHJhbmNl RGVzcGl0ZQ== SURFTlQ= IHNhbml0 IEdlbmVyYXRl KCIiLA== X3ZpZGVv U3RyYXRlZ3k= X29r IHRpZXM= IGxvZ2ljYWw= IEJyb24= KEZpbGU= IE1vaA== LlNwbGl0 LlRyeQ== IEhpbmQ= IHNjb3Jpbmc= IGFwcHJvYWNoZXM= IGZsb3Vy VlJU ODA0 VVNUT00= NDY3 c2NyaXB0cw== IEVwaXNvZGU= Mzg5 IEFtYg== X09S IGZyYXVlbg== IHVubGlrZQ== IHJpZGluZw== IHBpdA== IHRyYW5zZg== YXJ0ZQ== 4LmJ cmFwZQ== cmV0dmFs X2FmdGVy Ijw8 NzAz IEJlcmxpbg== IHRpc3N1ZQ== LkludGVudA== INC00LvRjw== IHN0dW5uaW5n IEhhbA== LkludGVnZXI= IHdoZXJlYXM= IGRlbGVn IHVzZXJOYW1l IGZvcm1hdHM= IGNvbXBlbnNhdGlvbg== IEh1bQ== YXJyaW5n IHVuc2FmZQ== UGlu Y2x1Yg== a2V5d29yZA== X3RoZW1l IGNhbGxlcg== IGdob3N0 IGVudGl0bGVk IE1hcw== NTYx IGRlbW9uc3RyYXRl IEhvd2FyZA== RHJvcA== I3VuZGVm NDI3 IGludm9rZQ== IEJyaWRnZQ== ZW5kZW4= aWJsaW5n U2xvdA== QVRBQkFTRQ== IHRlbXBlcmF0dXJlcw== c2VyaWVz IFJlbWVtYmVy Q2FsZW5kYXI= QkY= PT8= MDY0 IEFG KGh0dHA= bWFrZXJz ZmluaXR5 cHJlY2F0ZWQ= V0g= b2xpZGF5cw== LXVu aWFsZQ== XFVzZXI= cmVhc29u JywKCg== T1dFUg== IHByZWRpY3Rpb25z cHJvYg== Lm5u ICc7Cg== LkZyb21Bcmdi X0xPTkc= IHRyb3Vi IHVuaXR0ZXN0 ZWxpaG9vZA== CWlz NDQy IGNvbnNlYw== TEVBU0U= IGNsaWNrZWQ= IHRlbXBsYXRlcw== Qlk= cGVybQ== bWF0Y2hlcw== bGF3 KHRm X3JhdGlv aXRlbXB0eQ== IGNyZWF0b3I= Qml0cw== RW5jb2Rlcg== Ki4= IFVJVA== IE1hc2s= Y3VybA== LWdv IE9jYw== Y29ycmVjdA== IEdlcg== KGxheW91dA== dW5jdA== LmRpc3BhdGNo O2FtcA== LmlzUmVxdWlyZWQ= CWRv bWly IHB0aHJlYWQ= LWF1dG8= IEljZQ== IHZpb2xhdGlvbg== IGNvbmNsdWRlZA== IHZhcnM= Y2FudmFz IFRlbXA= IFBoaWxpcHA= iOuLpA== Y3JlYXNl IGZpc2hpbmc= YWJiaXQ= IGNvbmNlbnRyYXRpb24= aXJ0aGRheQ== IGdyb3Nz IGtp IEhhbmRsZXI= IGltbWlncmFudHM= 6IA= VW5k cG4= cmFj NDU0 IENvbnN1bHQ= Zm9sZA== IHN0cnVnZ2xpbmc= aGVhdA== R2VuZXJpYw== IHJpZGlj IENPVklE b21pdGVtcHR5 X09QVElPTg== 6rCA IGNyZWF0dXJlcw== X1BBR0U= ZWk= KGhvc3Q= X0hQUA== NTE2 IFhYWA== IGF3aw== YXNjYWRl IHByZWc= cHJvdmlkZXI= UGFs ZWdlbg== Y2xvbmU= LlJlZ2lzdGVy IGF0dGFjaG1lbnQ= YmVpdA== dGhlbGVzcw== KERhdGU= IEZvcmVzdA== Q0dSZWN0 IGNoaWxkaG9vZA== YW1pbmU= YXhlcw== J109 TmF2aWdhdG9y IHJlcGxpZWQ= X2ludg== LFQ= IEZlYXR1cmU= NDM4 ey0= TEFORw== IGNvbnZleQ== 55So5oi3 IFNlcmlm IEF1cw== bGljaGU= IHVudXNlZA== IG1vbnQ= bm9kZXM= IHNldQ== LmNsYXNzTmFtZQ== bm9ybQ== X1NFUlZFUg== IHdpbmc= aW54 UmF3 IEphbQ== NTkw IGluc2lnaHQ= NDcx NTM1 IE5H IEludGVyZmFjZQ== IHN0bXQ= IG5hbg== Y3VsYXRvcg== LWFwcA== KEJ1bmRsZQ== TWVzc2FnZUJveA== 4K4= IG1lZXRz dWJ5 T3B0aW9uUGFuZQ== aXRhcmlhbg== IGNvbGxhYm9yYXRpb24= bW92aWU= IGFybW9y X2JpdHM= IEhhdmluZw== IG51ZGU= IFNldHRpbmc= IHN1Y2M= RGVsYXk= LmNvbXBvbmVudHM= YWNodXNldA== IEFsZXhhbmRlcg== wqk= IG1ldGVycw== IHByZXBhcmluZw== IGluY2VudA== 5ZM= IGvDtm5uZW4= IENvbnNlcnY= IG51bWVybw== YWNodXNldHRz LWludA== IGVtcGhhcw== bGF5b3V0cw== RXhjZWw= SUJBY3Rpb24= IHJlc2lkZW50aWFs ZWxpbmc= IE5D IEFsbGVu IGNldHRl IG1pbmRz LnJlcXVpcmVk 2LM= IEdpcmxz IH07 IHN0cmluZ1dpdGhGb3JtYXQ= IGFkZHJlc3NlZA== dGhleQ== IEJsb29k cG9zZXI= IGphbQ== yJk= 5pWw5o2u IHN0ZG91dA== IFVURg== Q2xhc3Nlcw== PiI7DQo= IFNhdg== LkJvbGQ= IGVuYWJsZXM= CXRtcA== IG1hbnVhbGx5 IFNxdQ== dXNlcmlk LmZ1bmN0aW9u LmNhY2hl TE9QVA== LlNlcnZpY2Vz NTg4 ZGRpdA== dGlt PGltZw== IFRoaW5ncw== IEV2ZXJ5dGhpbmc= IGFwdA== Mzk3 ZW1hbmQ= IHJvbGxpbmc= 66Y= LmxldmVs IHN0b20= IFdpbnRlcg== IHZpZXdpbmc= KHZhbHVlcw== b2NvbXBsZXRl dmlh dXBv IGFib3J0aW9u NTMy acOocmU= 77yR X0JVVFRPTg== X2RvbWFpbg== IGJyYQ== IEFzdA== aW5hcw== IHN0YXRpc3Q= Y29k TFI= IGRyaXZlcw== IGZvbGxvd2Vycw== IGFsbGllcw== CWN1cnJlbnQ= ZWNlc3Nhcnk= IGRhbWFnZWQ= X3B0 YW5kbGVz b3VudHJpZXM= IHNpbXVsdA== ZXU= IGNvbnRyb3ZlcnNpYWw= X0dST1VQ IHJpYg== LkluZm8= Om1t Lm5vcm1hbA== X0FERFJFU1M= IO2V YWRkbGU= IER1cg== LkVsZW1lbnQ= NjU2 V2FybmluZ3M= IGNyZWRpdHM= IGluaGli IGVtaXNzaW9ucw== NTQ1 IGhheg== LnlvdXR1YmU= dWdnZWQ= IGJvdGhlcg== IEthbnNhcw== IEZpeGVk IFRlc3Rz IEZJWA== NTc2 VW5pZm9ybQ== IGtvbnQ= Pj4+ c3RhdGlvbg== bG9yZQ== YXR5cGU= aXNob3A= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= NTIx Q29tYm9Cb3g= IHZhY2F0aW9u IGluaXRpYXRpdmU= IGRlZmF1bHRWYWx1ZQ== Nzcw Y29uY2F0 IEto NjMy IFdlbGNvbWU= aXplZE5hbWU= TWlncmF0aW9u IGdyYWRpZW50 SG90 IGhhcmRseQ== ZWxv IFN0dWRlbnRz IGxvb3Nl NzMw YXR6 LlNlbmQ= Jy8= IHVuaXZlcnNhbA== IGVudGVycHJpc2U= IHJlZ2V4 IHZpc2l0b3I= IEZseQ== U2Vx 4LiZ IFZpc3VhbA== IGxpYnJhcmllcw== YXRvZXM= UGF5bWVudA== NDQ3 IHBlbnQ= IGdhdGhlcmVk VlJUWA== IERN U3BsaXQ= IGxldHRpbmc= 0J0= X2Vycm9ycw== ZXBvY2g= UEFSQU0= Y3U= 0YHRgtCy b2x1dGlvbnM= RWRpdGluZw== Zm9udHM= IGFsbG9jYXRlZA== IEJhc2Vk KFk= IEp1ZGdl IGJyb3RoZXJz RklMRVM= w6dv NTMx d2I= X1BJ J14= IHN3b3Jk LnNlcnZpY2Vz IG5s VGlt aWdn IE1vb3Jl IGNyeXB0b2M= 5Ye6 X3Bvc3Rz b3RhdGU= Pyc= Li4uLgoK IGts PSIk IGRlY29yYXRpb24= 4bqh IERJUkVDVA== R1VJ KT0+ewo= IG5ld3NsZXR0ZXI= IHByZWNpcw== KHBvaW50 IEVxdWlwbWVudA== dXR5 IERhdmU= IHBhcnRpY2lwYXRpb24= dWFyaW9z eGl0 LkFz RVRFUg== b3JvdXM= IHNoaWVsZA== W10+ aWxpdGFyeQ== Lm9yaWdpbg== IHByb21vdGlvbg== VW50 IGN0 VFJB NTU2 Vmlld0hvbGRlcg== IHNpZ21h ZGVsdGE= YXJlaG91c2U= Y29udHJhY3Q= KFZlY3Rvcg== NzIx IGNvbXBldGU= L2Zvcm0= L2NvbXBvbmVudHM= IG5y IEluZG9uZXM= INC+0YI= IFZvbHVtZQ== LmZpbGVz KHJlc3A= L21vZGVscw== IHN1cmY= c3RhbmRhcmQ= L28= IFhDVEFzc2VydA== VklDRVM= LkNvZGU= U0VE IGFjdGl2YXRl RGVsdGE= IGxpbWl0YXRpb24= cmlq IHByZWduYW50 Ol4o IHNvdXI= cGll ODAz IGV4cGVuc2U= aWNhdGlvbg== IExhcmdl IMKx IEJvd2w= KG1vZGVscw== L04= ODU3 UGE= LnJlbG9hZA== IHdvbmRlcmluZw== NDYy RXhlY3V0aW9u CSAgICAgIA== IEdyYXBoaWNz IENvbnRpbg== X2pvYg== IGdldE5hbWU= IE1hZ24= IERXT1JE bWFk IG5o ZmVhdHVyZXM= fSIpOwo= aGVldHM= KHRyYWlu em4= IHJlY3J1aXQ= LmNvbm5lY3Rpb24= IGJhcnJlbA== IHN0ZWFt X3NldHRpbmc= IGFuZ3VsYXI= YW5lb3VzbHk= IGJpbA== IE5vcm0= NTIy KCEk aWJ0 JSg= IHBvc2l0 IEZhdGhlcg== aW50ZW5kbw== NTY1 TGl2ZQ== MDQx IHBvcnRz IG1lag== IGxhbmRpbmc= cG9uZGVy IGNvZA== X0hFQURFUg== Lk1hcmdpbg== IGJhbGxz IGRpc2N1c3Npb25z IGJsZW5k SGV4 IGZhcm1lcnM= IG1haW50YWluaW5n ICAgDQo= c3lu W1Q= cnVz NDM5 dWZmZXJz IGNvbnRyaWJ1dG9ycw== X3N5cw== LkRlYnVn IGNvbnN0cnVjdGVk b21lcw== P2lk c2xpZGVy IHN1cHBsaWVycw== NjEx c2NyaWJlcg== cGVz 0J4= IjoNCg== XENvbnRyb2xsZXI= KSkKCgo= IGx1YQ== TXVsdGk= RU5T U3Jj IHBldGl0aW9u IHNsYXZl bG9va2luZw== VkVSVA== CXZlY3Rvcg== U3BlY2lhbA== aGg= YW5uZQ== IE5pZ2Vy L3ZpZXdz emluZw== ZW5kYW50 PEM= c3BlZWQ= NTE0 IHt9OwoK QmVnaW5Jbml0 IGZvcGVu QFJlcXVlc3RNYXBwaW5n RW5kSW5pdA== IHB1bmNo U2VuZGVy NjAz 6ZQ= Z2V0TWVzc2FnZQ== L3R5cGVz LlBJ KCcnKTsK b2N1c2Vk KGFsbA== IGRyb3Bkb3du KS5fXw== IFZpbg== LkZvcmVpZ25LZXk= NjEy Y2FuZg== b3VyZWQ= IE9yZ2FuaXphdGlvbg== INCw IEN1bHR1cmU= KGNscw== LF8= OTAy cmdiYQ== 7J2Y LmRhdGFHcmlkVmlldw== IGRvemVu IEdlcw== ODA1 NDY0 X3NoYXJlZA== bmljaw== IGhvc3A= b21ldGVy NDk1 IGNsYWltaW5n MDMy aWJsZXM= cmlr 5piv ZW5hcmlv IGRlbmdhbg== b2Ji bW9udA== X3Jhbms= KCcvJyw= IGFwb2xvZw== UHM= X3Bvd2Vy IEdyZWU= IGZ1bGZpbGw= IGZpcmViYXNl OTEw IGZhcmU= IEhpbQ== IGJlYW4= 4oCmLg== IFNQSQ== X1JY IHBlcmNlcHRpb24= cmVsYXRpdmU= Y29tcGlsZQ== dXVt dXRvcw== YXVj IEFzaw== IGluZGljYXRvcg== L3Ro LnNldFN0cmluZw== IFdpc2NvbnNpbg== LkRvbWFpbg== IGFydGlmaWNpYWw= RGV2ZWxvcA== IFNhcmFo IGx5aW5n KHNlYXJjaA== IEVtcGlyZQ== dXJyaW5n 5pe26Ze0 PSIkew== IGdldElk IFBheW1lbnQ= dHJhbnNpdGlvbg== IF0u aXhpbg== VlQ= LXNlbGVjdA== IGRlbW9uc3RyYXRlZA== IGxhc3ROYW1l ZW1wbG95bWVudA== LmdldFByb3BlcnR5 IGZvdWdodA== ZmlsZU5hbWU= IFBlcnM= NDUy LWNhcmQ= YXN0cg== YXR0cnM= IHByb21pbmVudA== RGVzaWdu YW5jb3V2ZXI= 44GX44E= YXJkbw== c2VjcmV0 IHJhZw== IHBvaXNvbg== LW1hbg== LG9taXRlbXB0eQ== NzQw CXVu aXR6ZXI= IENhc2lubw== IFJvc3M= LWZvb3Q= KHJlc3VsdHM= UGxhbg== IGxhc2Vy 6riw X0RS NTIz RmFjZWJvb2s= NDQ5 IGJvYXJkcw== c3Rh XV0s Njc1 IHRpbGVz U0laRQ== ID1+ OTcw IHByZW1pZXI= b2NhYg== IGVuY29kZWQ= IHJlc2VydmU= NjA5 IEFmZ2hhbmlzdGFu IExpc3ROb2Rl dXJscw== IHN1Ym1pc3Npb24= IG5ldQ== NDc3 ICMrIw== X1BPU1Q= IG1vaXN0 ZWxsaQ== ZWxsaWdlbnQ= LmFsZXJ0 w7Nk YnJl IENvbGxlY3Q= IGdyYXBoaWM= IGxvbmdpdHVkZQ== IFByb3ZpZA== IENhbGN1bGF0ZQ== eGZmZmY= Y3JpdGVyaWE= IHdhdGVycw== cm9jaw== bG9xdWVudA== IFRyaWI= NTEz IGJ1cnN0 IHN1ZmZpeA== LkV4dGVuc2lvbnM= aXNoZXM= aXZlbA== IExJS0U= IEdldHR5 LkFjdGlvbkV2ZW50 LnNsZg== IEhBTA== dXBhbA== RUFS NTI0 dWRp X3RpbWVvdXQ= VUY= IFNpbmdhcG9yZQ== IEFkdmVudA== X2ludGVydmFs Y2hhZnQ= IEVtZXI= IHRlbGVwaG9uZQ== IFR1cms= X2ludGVyZmFjZQ== IE93bg== IGVuY291cmFnZWQ= PE9iamVjdA== X1RleHQ= IE9udGFyaW8= IEFwcGx5 LmZpcmViYXNl IGFudGli UHJpb3JpdHk= ZW5leg== RGF5cw== Y2lk dXJyZW5jZQ== Oy8= aW5uZWQ= 0YHRjw== IHZleg== Znc= Ly8k YXR0YWNr NDU4 IHN0YXJ0dXA= YWluZXJz LmZyYWdtZW50 b3BhY2l0eQ== KGNvbm4= aGVpbQ== Lm5ldHdvcms= KHN0cmVhbQ== Njcw IE5PTg== dG9s ODMw IFhib3g= IERT IGNhY2hlZA== IHByb3N0aXR1dGFz IEJhbHQ= KCdb NTc1 IG5vZXhjZXB0 Iic= IHNk LnZhbGlk X2Fn IHJhY2Vz NDgx IHJvZA== aXR1ZGVz PD4o NTQ0 LlByb2R1Y3Q= Rm9ybXM= TkVX UGF5 CWJvb2xlYW4= X2NvbnRhY3Q= IEVsZWN0cmlj c2tpcA== IHd1cg== IGNocm9uaWM= X2RyaXZlcg== OTQw IFNhYg== IFVsdA== IFJhZA== U1RBVFVT IExld2lz T0I= IGdpZnRz LlJlYw== VFJVRQ== IGludGVuc2l0eQ== TWFya2Vy LmNvbXBhcmU= ZmZpYw== Q29va2ll IEJhYnk= IEJpZ0RlY2ltYWw= aWxldA== IEhPTERFUlM= IExhZHk= IGx1bmc= IEFsYWJhbWE= IGRlc3M= YCk7Cg== IEJ1aWxkZXI= X3JlZ2lvbg== IG5ldXRyYWw= OTA5 Qm90aA== IGhw IGhvcm4= IHNlZ21lbnRz IEVD Ij0+Ig== KHJlYw== IFBp R00= IGxhcHRvcA== U2NhbGFy NDYz aXNk LWRpYWxvZw== IEFuZGVyc29u IG1pc3Rha2Vz NzA4 IEhhbg== amVz ZXN0aW5hdGlvbg== NDM2 IHByb21pc2Vz Ymlk IFNjaWVudA== R0lO IFBlcmZvcm1hbmNl YmFnZQ== LnVzZXJz bGVhZGluZw== IG9yYWw= R3JhcGhpY3M= NDg4 X1BUUg== NTE4 aGFuZw== IGluZXY= cHJvY2Vzc2luZw== RmFjdG9y IE5B JHN0cmluZw== IGdyb3VuZHM= LlNhdmVDaGFuZ2Vz Y2xvY2s= OTQx Y3JpcGNpb24= IE5ld3Rvbg== Z2M= LmluY2x1ZGVz IGJsYXN0 ICctJw== IHB1ZWRl NDY5 LlNlc3Npb24= IGdyZXA= X2ZpbmFs IEdheQ== IEdpdmU= aXJp LXN0YXI= IFVJSW1hZ2U= X2Vwb2No dWJi ZW50aA== IGVsaXRl IGNhbXBhaWducw== IFBvcm5v X2Fzc2lnbg== UHJvdG9jb2w= IEJlaW5n IEFpcnBvcnQ= IGNvbnZlbnRpb25hbA== IFdhdA== IENJ RVRB IEFudGhvbnk= IHRhYmxldA== KGZvcm1hdA== IGNvbnNpc3RlbnRseQ== IElvd2E= NDc0 IGF2YXRhcg== MDI3 LmN1cnNvcg== IVs= IGhhbmdpbmc= SGVy U3VjaA== JzsKCgo= b3JnZW91cw== KCk9PQ== IHZpZXdNb2RlbA== IOOD IGVscw== IEFnZW50 RmV0Y2g= YXBvcg== IGN4 cHJlYWQ= IFBpZXI= b2VmZg== NjE2 U24= ODkw IFZpcnR1YWw= QXBy LldoaXRl NjE1 X01PRA== IFBvaW50cw== 5aSx IGdlbmVz IHZlbmRvcg== IG1haW5zdHJlYW0= PHNyYw== IEVsaXphYmV0aA== RGVjb2Rlcg== LXN0YXRl IEdsYXNz bmN5 YWRpYW5z X21vbg== IFJlbW90ZQ== IHdpcmVsZXNz IE1p 5Yk= NDY2 6KGo c3RhZ2U= IFRpbGU= bGxpYg== VmFyaWFudA== PT0K IGdvbGRlbg== KFFTdHJpbmc= LnB1dEV4dHJh IERvbQ== IEFuaW1hdGlvbg== IGludGVyYWN0aXZl aWZhY3Q= 6Zmk TEVU IGZyZXF1ZW50 IDw+Cg== RmlsZW5hbWU= IHNuZQ== IEZvb3RiYWxs IHJpdmFs IGRpc2FzdGVy aW9uaWM= IERhbWFnZQ== LlJlc291cmNl LWVu IFR5cGVz Z2V0U3RyaW5n KGJvYXJk IGJvbA== cGxhaW4= enlt 4Liy IHNjYW5uZXI= aWxkZXI= X21zZ3M= 5o8= KGludGVudA== IGRlc3RydWN0 IGJ1c3Q= IEVtcGxveQ== b25p IFVJVmlld0NvbnRyb2xsZXI= IG9kZHM= ZWFyZXI= R2VvbWV0cnk= IHlpaQ== X0VYUE9SVA== IEF0dGFjaw== IG5pZXQ= IGltcHJlc3Npb24= IEdpbA== X3Byb2I= NTI4 IENG IEV4cGVyaWVuY2U= L3BsdWdpbnM= Lk1ldGhvZA== IGJlbGllZnM= TmF0aXZl X2J1aWxk IHZpZw== IHJhbmtz Y292ZXJlZA== NzA1 c3VjaA== R3VhcmQ= LnBhY2s= YWRkZXI= ODA5 aXZpYQ== bG5n INCy0Ys= NTUy VGltZXN0YW1w X25vdw== IHBva2Vy IHVuYw== IHNoYXBlcw== LXR5cGVz X3BlcmlvZA== cGs= IHZldGVyYW4= IHNvbm8= IGFwcG9pbnRlZA== b3ZlcmZsb3c= LmRyaXZlcg== X2NhdA== dXR0 cGxhbnQ= aW1i IEFjY2VwdA== IGNvbmNlcnQ= CW5vZGU= CXo= Pz4NCg== IGJhbm5lZA== CSAgICAgICAgICAgICAgIA== IHRveGlj IGRpc2FwcGU= NDcz yJs= IGdyYWNl YXRlZnVs UmVwbHk= IENydXo= NDg2 IHNjcmFw IGtleXdvcmRz c2ltcA== IG1vcnRnYWdl IGN5YmVy IEV4ZWN1dGU= IGxhdGl0dWRl aWZ1 LkNPTQ== ZGJv IHNvcnRz IEdhcw== b21pYWw= LkxvY2Fs Q2VsbHM= LlJlcGxhY2U= U3RyaW5ncw== LmZpdA== IFRoaXJk JSIsCg== IHt9Ii4= IFNvbnk= IFs6 NTg1 IGZhbGxlbg== LicpCg== aW5o IE1D IHJlZGlz Q29kZXM= IHByb2ZpbGVz aG9vaw== UmVkdWNlcg== X0ZVTkM= IG5hdmlnYXRl c3RybGVu IGhvcm0= 4Z4= IFNS LmJvb3Q= IGRpZ2VzdA== CWhlYWRlcg== LmZpbmRPbmU= 5oE= RGJUeXBl bmlh X21lcmdl IGRvbm5l L0dldHR5 X0NIQVI= IGJhbmRz LlVSTA== YXJ0aWFs IGZyZXE= IHNpc3Q= Tmc= IHJlbmRlcmluZw== XENvcmU= V2lkZ2V0cw== IFZB IGFjdGl2aXN0cw== U3Rl PV8= YWxsYQ== U3RhbXA= IGxvYWRz IHh4 IExlYXJuaW5n Lk12Yw== dWly KCIk IGNvbm5lY3Rpbmc= UmVhZE9ubHk= dXJ1 IEVhZw== QklU X0RFTA== 5ac= YXJyYXNz ZXh0ZXJuYWw= IFlPVVI= IEJyZXc= IEZpdmU= IHJlc2l6ZQ== aWdpZA== ZXJhdGlvbg== NjUz INGN NTM2 5Yqg MDM5 IENhdGNo 2YE= IExlb24= YW1pbA== LkJvZHk= Q2xpcA== L2xpc3Q= LmJy RWRpdFRleHQ= CWRi LkdhbWU= KEJ1aWxkQ29udGV4dA== YmFja2VuZA== LlJlZA== ZmFjZWJvb2s= NTI5 LnVybHM= bXI= cm9sbGVk LS0tLS0tLQ== IGludGVydmVudGlvbg== IHJldGlyZW1lbnQ= IEtpdA== IFBSRQ== VXBwZXJDYXNl IFNvY2tldA== IDot IHN0dWR5aW5n IE1ldHJv YXJkZWQ= IGNvbnZlcnNhdGlvbnM= Q2FsbGVk IGV4YW1pbmU= ZXJ0aWZpY2F0ZQ== Lmd6 LXJlc3BvbnNpdmU= IHJlZnVuZA== X25ldHdvcms= MDI2 YWxsb3dlZA== ZW1wdA== IG1lYWxz Q2F0ZWdvcmllcw== IHRyYXZlbGluZw== IGtn IHNoYW1l ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IGV4cGxpY2l0bHk= IG1hdGhlbWF0aWM= IFN1aXRl IFJHQg== KioqKioqLw== IG1peHR1cmU= bGVhcm5pbmc= LnRlbXBsYXRl YXR0cw== d3g= CWN0eA== LnByb3BlcnRpZXM= IGRyaW5rcw== IEVpdGhlcg== c2V0VGV4dA== LmdldERhdGE= LnppcA== IHJldmVhbHM= PHRhYmxl Lkhhc2hNYXA= IEh1cg== KSIpOwo= LmZyYW1ld29yaw== IFNUQVJU ZmVlZGJhY2s= NDU3 IHNhZmVseQ== Lmljb24= Y29uZmlndXJl LmxvY2s= LmxheWVycw== Lz4uCg== IHJhbmtlZA== X2ltcGw= IEhhbmRsZXM= IGhvc3RlZA== IHVwZGF0aW5n YWxidW0= 6Z0= IHNoYWRlcg== RWRpdG9ycw== LXJvdW5k W117 IHNlcA== IEhp VEVN bG9va3Vw Lm1hbg== X0lOUFVU IHRocmVhdGVuZWQ= X0lNUE9SVA== IGRyb3Bz cnVpdA== c2lk Ym90aA== IEV4Y2Vs IGplcg== b3JkaW5hcnk= 0LXQuQ== VklFVw== cmVwbHk= ICk6Cg== Y29sb3Jz dmVyaWZpZWQ= X1Ry X3BhcnNl IGNvbmdyZXNz NjE3 UHJvbWlzZQ== aW50cw== IE1vdGhlcg== LkFwaQ== IER1cmF0aW9u IGZpcnN0TmFtZQ== aW5oZXJpdGRvYw== IE1hcnM= IGFwcg== T0RZ IHZpc2l0cw== NjMx IGhlYWxpbmc= bGV0dGVycw== KSkpOw0K ZnV0dXJl LkZyYW1ld29yaw== IGtpc3M= IGludm9sdmU= IHNpbGVudA== YWRvd3M= IGFueWJvZHk= c2No Njkw IHNvbGVseQ== LWltZw== IHByb3ByaQ== IGluc3RydWN0 IGxpY2Vuc2Vz IG1ldGg= IGNvbmRlbQ== IERvbWFpbg== IEhhcnJpcw== IHPDpQ== Q0VQVA== QmF0Y2g= QGV4dGVuZHM= IENPTlRSSUJVVA== LkRhdGFGcmFtZQ== NDcy X3BhY2tldA== cmVjaXNpb24= IGZvY3VzaW5n Lmh0 X18iOgo= OkdldA== IEtD IHBhc3NhZ2U= U2VnbWVudA== X2NlbnRlcg== LXpB X0JM IGNvbnZpbg== IGNsYXNzaWZpZWQ= IE5TTXV0YWJsZQ== X2Fw dGlsZQ== UmVjdGFuZ2xl NDky KG51bXM= dmVucw== IFVJQnV0dG9u IEZlZGVy YW1v IG91dGxpbmU= IFBhcnNlcg== IOKJ IFdvcmtz LlNjaGVtYQ== IGVuZ2luZXM= NjM3 NTYz X2NvbW1vbg== NTQy X29sZA== IHNldENvbnRlbnRWaWV3 IC8vLzw= IEJU Zm0= IGRpdmVycw== X3dlaWdodHM= ZW1hcms= IEFDVA== IHByb3BvcnRpb24= b3ZlcmxheQ== LmRpcm5hbWU= IEdpdA== X1JFRkVSRU5DRQ== PD4= bGI= X3J1bGU= 6LSl IFB1dGlu IHNsZWVwaW5n KCk6DQo= IHByZXNlcnZl IHBhcmxpYW1lbnQ= IExvb2tpbmc= IHBpY2tpbmc= IERpc3BhdGNo IHNsaXA= 65M= IEx5bg== X3NpZ25hbA== Y29uZmlndXJhdGlvbg== IFBpdHQ= NDkx YWRlbg== cHJvY2VkdXJl IGVudGh1c2k= ZmlnaHQ= IENvbnNpZGVy IHRvcm4= Q29ubmVjdGVk LmNvcw== X2dyb3Vwcw== IFRoaW5r IGRlbGliZXI= IHJlc2lk d29ya2luZw== LmNvbHVtbnM= IENhbGxlZA== IGVzbGludA== PiIs X0RPV04= aGlzdA== IEFkdmFuY2Vk IHJld2FyZHM= YWN0b3Jz IHNpbGVuY2U= NDc5 IG15dGg= IG5ldXI= NTE5 IGF1Y3Rpb24= LkdldFN0cmluZw== ZWtz KHByb2plY3Q= NTk4 CW1zZw== CW91dHB1dA== IGNvbXBsYWludHM= NTUx LFM= IHRibA== ICwKCg== cmlvcnM= YWhyZW4= IGxhd3llcnM= cmVkdXg= X3N5bWJvbA== b2ZmZWU= X1JFU1VMVA== KE5hbWU= VVRD LmN1cnJlbnRUaW1l IG9yZ2FuaXM= LmFyZw== NTMz IG1pbmlt d2ljaw== IHJlY2VpdmVz QmFsYW5jZQ== IHNwZWFrcw== IERheXM= IEJlbG93 NDgz dGlwbw== UHJlc2VudA== IHJlc2Vydg== aHA= IHJpdA== X1JJR0hU LS0p IGNoYWlybWFu Nzgx RElT IEJPT1NU IGV4cGVyaW1lbnRz Njg3 X18pOwo= IHN0YW1w IGZlcnQ= IGZvbmQ= VGVy ZWx2ZQ== dXJlbg== K2k= ZW5kZW5jeQ== IHZpcnR1YWxseQ== Li4uIg== 772e OTI1 LWNlbnQ= X3VuaXF1ZQ== IHByaWNpbmc= bWlj UkVTSA== IDo6Og== IGFubm90YXRpb24= IENpcmNsZQ== b25nb2Ri aXRhcw== ICUo KGNvbXBvbmVudA== INC+0LE= KHBvcnQ= LWhvdXI= Lm9iag== TEJM IGp1cnk= R0JU IHNweQ== IFByb2Zlc3Npb25hbA== ICIiOwoK IHN0cmlraW5n IGRpc2NyaW1pbmF0aW9u IHBheXM= OTM3 bGljdA== ZW50ZXM= IHRocm93aW5n IFBsdWdpbg== KGRlZg== IFJ1bnRpbWVFeGNlcHRpb24= IE1pZ3JhdGlvbg== NTk5 IGRpYw== YmFn b25pYQ== IGNvcnJ1cHRpb24= NzA0 KE1hcA== IHByeg== LmR0bw== IGFjcXVpcmU= U3RhdGVUb1Byb3Bz IGxvdmluZw== 0L7Qtg== X3BhdHRlcm4= IGVtb3Rpb25z IHB1Ymxpc2hlcg== X2Jl IGNvdXBsZXM= NDk4 b2o= IENoYXJ0 IHRyb3A= LnRvb2w= IGVzdGFibGlzaG1lbnQ= IGRvbA== NjU0 IHRvd2Vy IGxhbmU= IFN5ZG5leQ== IGZpbGxpbmc= Y2xhaW1lZA== NjQ0 IGRpYWxvZ3Vl IGNvbnZlbnRpb24= Ym9va2luZw== cGFyZW5jeQ== 5rE= IEdlbmVyaWM= NzE4 XFNjaGVtYQ== NDgy NjE4 IHJhbmdlcw== L2No IHBhbmVscw== IHJ1bGVk 55Sf LnRz X3NldHM= IGNsZWFudXA= UHJldmlvdXM= IEFuaW1hbA== NjA3 KCQo IEF2ZQ== b2xsYXI= MDI4 X2V2YWw= CU5hbWU= KHRyZWU= ICJd NTcx IGR1dGllcw== PScv Q2xpY2tlZA== IGRpZmZlcmVudGx5 IENsYXJr IGRpdA== b2xvZ2lzdHM= IHN5bmQ= IHNlbmRz LWtub3du a2I= IE1vZGFs aXRhdGl2ZQ== IHJhY2luZw== IGhpZ2hsaWdodHM= IFNpbW9u IENhcHRhaW4= 5L+h IENC Y29udGlu YXJhbg== IHBoeXNpY3M= cmV0dHk= ZXRhbA== Lm1k YXhpb3M= IHNwZWFrZXJz IHByZXA= IGF3YXJkZWQ= 7KeA IENvcm4= IE5hdHVyZQ== VURJTw== NzM3 IHByb2o= LXByZQ== W3U= RmVhdHVyZXM= IGlzRXF1YWw= QmluYXJ5 c2ln IGNvbmZ1c2lvbg== NTQ2 NTY4 IEhhdA== IGt0w7M= LmNvbmZpZ3VyZQ== TU9O NDk0 L2VkaXQ= X0FkZA== LHRydWU= NTQx IGNsaQ== RXJyb3JNZXNzYWdl LWxvYWRlcg== RGltZW5zaW9ucw== dWx0aXBseQ== IHshIQ== IFNxbENvbW1hbmQ= IHNwb2tlbg== IHBpY3M= IHRveQ== KEtleQ== IExvb3A= 2Kg= RUFUVVJF aW5jdGlvbg== X3NldHVw d3JhcHBlcg== IHRvbmc= Y3VsYXI= T3B0 LlBs PSIs KGxlbmd0aA== dW1u IGNocm9t IHNldmVudA== IElsbGVnYWxBcmd1bWVudEV4Y2VwdGlvbg== NDc4 CXN0YXJ0 IGJlZ3Vu Q0VQVElPTg== ZGF0YXNldA== ODI1 IEZhaWxlZA== Y29scw== NDU5 IGtuZWU= aW1vcmU= LnNwbGljZQ== c2hlbGw= aWdnZXJz IHRoZW1lcw== OTk1 IERK IEFzc2lzdGFudA== LSQ= TWF5YmU= IG9yZGVyaW5n IEludGVsbGlnZW5jZQ== IE1hc3NhY2h1c2V0dHM= IGZhaWxpbmc= ZWxzb24= R3JlYXQ= PWk= LnJlc3Q= IGludml0ZQ== LWRpc2FibGU= Lkdyb3VwQm94 4oCZZXN0 IHRhY2tsZQ== Z3Y= ZXR0ZXI= ICksDQo= X3J1bGVz Lndhcm4= ZnVuY3Rpb25z IENocmlzdGlhbnM= IGJhY2tlZA== IHNsaWRlcg== IGVuam95aW5n bmVzdA== IGhpag== X21z Ly8q QW5ub3RhdGlvbnM= IFZhcmlhYmxlcw== PFY= KHNlcnZlcg== IE9yYWNsZQ== ZWxlbWVudHM= IG9yZ2FuaXNhdGlvbg== X3BvaW50ZXI= IEhlYWRlcnM= W2Q= IGRlYWRsaW5l aXNzYQ== IGtuaWZl IE5BU0E= IEhlaWdodA== Nzg0 IEFzeW5j IHZlbnVl LmRvbQ== Ym91cm5l IEhhd2Fp IG1lbW8= aWN0aW9ucw== IHN1cnZlaWxsYW5jZQ== b21p L2Fzc2V0cw== NTg3 IGVkdQ== xJs= IHJvc3Rlcg== IGhpcmVk IFRvaw== IHBsYWNlbWVudA== dXJhdGlvbnM= IHNldFN0YXRl IE1hZ2F6aW5l IGhvcnJvcg== VHJ5 IGxhZw== IEV2ZXJ5b25l dGh1cg== KSk7DQoNCg== LnJldHVybg== IHN5bXA= 4paI4paI IG5pZ2h0cw== d29ya2Vy IGFsZQ== ZW5uZXNzZWU= LnN0ZXA= IHN5bmNocm9uaXplZA== NDg3 b3VyaQ== RG9lcw== LmNoYW5nZQ== Zm9u LnNldEJhY2tncm91bmQ= aXJjdWxhcg== NDc2 Ky0= IENJQQ== NzI5 IEphbmU= IFNpbWlsYXI= LUk= bGV2ZWxhbmQ= IHByb3NwZWN0 X2ZvdW5k CWNvbG9y LkRpYWdub3N0aWNz IGFubm91bmNl IGFzc3VtZXM= L3Ry IGJk OTg3 IENhcmJvbg== IGFuYWx5cw== NTY0 LmRlc3Q= bmlr IExpZQ== LWluZGV4 RHJhd2FibGU= IFRBRw== IHRyaWFuZ2xl X0ZMT0FU CQkgICAgIA== LmJsYWNr dnVl Y3VyYWN5 IGFmZmVjdHM= OTA2 IHN1cmVseQ== U2xpZGVy dWtp Y2VyeQ== IHVudGVy LnByb2ZpbGU= b3Jkb24= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= bGVhdmU= IHNtYXJ0cGhvbmU= Z2ll IGNvbnNwaXI= IHR1dG9yaWFs 57G7 IGNhYg== NzY1 IFN1bW1hcnk= KgoK w6Ro IlRoaXM= IHNsaWRlcw== Ijwv LmRldg== Jzw= IFJpbmc= xYJh IGtvdGxpbg== LmR1bXBz IGJhc3M= 7Is= UE9JTlQ= IHV0dGVy IMOpcw== LmZ1bGw= T0xM IGNlcmVtb255 c2xvdA== IGFpbXM= dG9vbHRpcA== LnNjb3Jl LWRk NjQy IHByb3g= UmVjb2duaXplcg== ZHluYW1pYw== w6RuZA== L3N0ZA== RFU= IE5vdEltcGxlbWVudGVk KCItLQ== UkFX NjM1 IGV0aG5pYw== YW5ubw== IGNoYW1waW9uc2hpcA== LHNlbGY= IGFjY2VwdGFibGU= IFNwcml0ZQ== W3R5cGU= w7xo IFZL KGpQYW5lbA== NTQ4 aXRy 66A= YXVyYQ== IGZhY3VsdHk= YXZlcnM= IFJlY29yZHM= LlNlY3VyaXR5 IGNvbnN0cmFpbnQ= LkJs VWludA== YmFsYW5jZQ== IGNvbW1l IE5paw== U3VwcHJlc3NXYXJuaW5ncw== IE9jZWFu NTU0 X0lk RGF0YVNldA== IGluc2VydGVk IjsNCg0K 4oCz aXBwZXQ= IGFubml2ZXJzYXJ5 IHJldGlyZWQ= b3JjaA== IHBlcnBldA== XEZvcm0= IGludm9sdmVtZW50 X3VzZXJuYW1l YWxlbQ== X1NFUlZJQ0U= IEluZGlhbmE= IGNpZ2FyZXQ= YXJ0eg== IFJD IG1lYXN1cmVtZW50cw== 572u IGFmZmlsaWF0ZQ== YWNpb25hbA== LXNlY3Rpb24= X2NvbnRyb2xsZXI= dmFyZA== X2Vs IFRveQ== PFA= TWFjaGluZQ== w7ptZXI= IFllYWg= IllvdQ== IG1vbA== LkNs Y29udHJvbGxlcnM= IHN1c3BlbmRlZA== Kys7Cgo= QVRU IHByb2plY3Rpb24= UGFkZGluZw== NTg2 Lm1hdGg= Njg2 ZmFjdG9yeQ== MDQy IGdhbW1h KCk+ Y3ljbGU= IEJ1bGw= cGF0aHM= IHVucA== IHZpZXdEaWRMb2Fk X01vZGVs IGFzc2VydFRydWU= IHJhdGVk RGVjbA== dmVydGVk IERhdA== YnJldw== IHBvaW50aW5n TXM= IFBvaW50ZXI= KSc= X25vbg== NTI3 IFNFQw== IHllYWg= Z2VuY3k= aW5pdGlhbGl6ZQ== Zmx5 NzEx W3Bvcw== LGc= VGVsZQ== MDM0 IGpva2U= IGNsYXVzZQ== LmZpbmRCeUlk ZW5lcw== KGluc3RhbmNl NjI2 wqM= OTE1 IHNsaWM= X2hvbWU= ICovfQo= X3BhZ2Vz KHNlcnZpY2U= OTA1 UlA= IEFtb25n LmdldEN1cnJlbnQ= ODA2 44K5 IHNsZWU= PTw/ X3Byb3A= Zmx1c2g= IE1N QmVs Tm90ZXM= ICovCgoK MDM1 IHJo VGFibGVz IEp1 IFwNCg== bGljaGVu IEluc3VyYW5jZQ== XQoKCg== IGNvb3Blcg== 4oCUdGhl Lm1hdA== NDg5 IGZvaQ== KGF1dG8= TWFyZ2lu NjM2 IHJlc2lkZW5jZQ== NTU5 IEhpc3Rvcg== IH49 RGk= ICcpCg== IGV4Y2x1ZGU= LkRyb3A= JyI7Cg== IGNvYw== X3VwbG9hZA== SGlkZQ== IFVua25vd24= IG5vcm1hbGl6ZQ== X3JldA== LicKCg== Lm5vZGVz ODcw LkRhdGFTb3VyY2U= YmxlbXM= IGdlbnRsZQ== OiQ= JykpOwoK LlJlc291cmNlcw== 4og= IFRhaQ== VkVE IEd1bg== bGVhbnM= IERvYw== LlZvaWQ= IEFtZW5kbWVudA== ODY2 ZXNzZWQ= NzA2 IHJlY2lwaWVudA== Lk5vZGU= b3Zv IGFsaWduSXRlbXM= IFVuaXR5 IFJvbWU= YnVybg== IHZvbHRhZ2U= IFNIQQ== NTM0 NTcy IEdPT0Q= aGVscGVycw== LyoqKi8= IGVsaW1pbmF0ZQ== d2Fw X2FuZ2xl IHJlZnVnZWVz CWFzc2VydEVxdWFscw== IHByb2Jl KCcuLi8uLi8= eW91cg== IG1lcmNo VUJMRQ== CXJlc3BvbnNl X0RFRg== IGVudmlyb25tZW50cw== b3VzaW5n IHJlc3RyaWN0ZWQ= IENPTlRSSUJVVE9SUw== NjIx IGNvbXBhbmlvbg== 4bqj cG93 dXJ0bGU= Ymll LlBlcmZvcm0= PW4= cmVkaXM= IGRpdmlkZQ== IGNvbGxlY3RpdmU= RGlmZg== RHluYW1pYw== aXNTZWxlY3RlZA== YXN0eXBl IExvdA== IFN0YXRlbWVudA== aWNpcGFudA== YWto NTE3 IHNlcmlhbGl6ZXI= X0NGRw== YXZhbA== IHZpZXdlcnM= IEZP T2Nj IHJvYnVzdA== IE1pdA== X0FORA== VHJhbnNpdGlvbg== dW5hdGU= IHByaWRl IGRyYW1hdGlj IFBhZ2Vz X3R1cGxl IGNvcGllZA== bW4= IG91Z2h0 IGVxdWFsaXR5 X2hhcw== X1dS NTcz ZW1p IHN1cmdl aWxsbw== KCl9 MDgx IHBlcmY= OTIx dWxr IGludmVzdG1lbnRz Nzg1 IGdlbmVyYXRpb25z IHJlc29ydA== IHRydXN0ZWQ= X2ZyZXE= IGZvcm1h QVRJT05T IEh1 IEdyYWQ= X2NwdQ== ICIsCg== cmVzc2U= KCoq IGhlcmVieQ== IGxha2U= X1NUQUNL IEJ1cmVhdQ== IHN1c3RhaW5hYmxl IFBF IGRlaQ== IEFuc3dlcg== UGx1cw== L3dlYg== IHN0ZXI= IG1vdW50ZWQ= X2NsZWFy Zm9ubw== aWFuY2Vz X2ZpbmQ= IGNvbmZ1c2Vk X2Jpbg== REVDTA== IGluc3RhbnRseQ== VUlU X0RP U2V0dXA= a2Vl X3ByaW50Zg== X3N0bXQ= IFN0ZWFt cHJvZg== bHY= IHNvbHZpbmc= bGF0b3I= b3R5cGVz QW5kcm9pZA== X2VzY2FwZQ== TGVhdmU= LmdldFRpbWU= ODEx aWZz IGNvdg== IENsYXNzaWM= LWRhcms= NTI2 RGlzcGF0Y2hlcg== LWdyYXk= IFBhbGVzdGluaWFu LmRlZXA= IEluamVjdA== IHJlZmxlY3Rpb24= NTM4 IGh5cG8= Y29uc3RydWN0b3I= LmFwcGxpY2F0aW9u eXN0ZXI= 4pU= c2Nob29s IENvdw== NTkz IGZvb3RhZ2U= LWlucw== IC8qKjw= YXRvbQ== IHByb2ZpdHM= OTIz IGJvb2tpbmc= X3RocmVzaG9sZA== IExpdmVy IGNpdGl6ZW4= Yng= IFN0b3Jt IENvcnA= IHdpZGVy Iikpewo= X0FDVElPTg== aW9ycw== YWlzZXM= Om5vbmU= IGNpdGVk ImZtdA== QXVn Y29tYg== IHdoaXRlcw== IHNlc3M= Xl4= aWdodGg= IHRhbmc= X0NBUA== NjE0 IGludGVyYWN0aW9ucw== NDk3 IGdhcmQ= NjQ2 IHByaXpl NjQ3 YWZrYQ== VHJp XEVsb3F1ZW50 IER5bmFtaWM= 55CG Z3A= IHJlYWxt IE5p IEVkd2FyZA== IGlkZW50aWZpY2F0aW9u IHBoeXNpY2FsbHk= 5pys IHBpY2tz LWZyaWVuZGx5 PGk= aWZpY2U= X0FQ TG9nZ2Vk NTUz fSIu L3V0aWxz IC4uLi4= RU5USUFM KEFjdGlvbg== J10pOwoK IHByb3Rlc3Rz b2xpbmU= X1JFVFVSTg== IHBvcHVsYXRpb25z IFJhaW4= ZHVw b3JpYWw= IEF1dGhvcml0eQ== X2V4cHI= MDc1 LnVz IGNvcnJ1cHQ= CWltcG9ydA== PGNoYXI= IExFRlQ= IGNhYmluZXQ= IG5laWdoYm91cg== IFNxbFBhcmFtZXRlcg== YXR0ZXJlZA== ZW1pYQ== IHJldmlld2Vk IEhlbGxv YmxvY2tz KHByb2Nlc3M= OTk3 IG9ic2VydmF0aW9u cmF0aW5n Lmdsb2JhbA== IHByZWZlcmVuY2U= LnByZXBhcmU= IGRvemVucw== V29ya2Vy IGNhbGN1bGF0aW9u IFRvd2Vy YWlyeQ== IElTTw== IGh1bWFuaXR5 LmFzSW5zdGFuY2VPZg== NzEy IGR5cw== IHBpZXI= aWd1ZQ== IGFzc29jaWF0ZQ== IGludGlt bm90aWZ5 KHt9LA== ODI4 IFJlcHJlc2VudA== cGhldA== c2V1ZG8= 64uI64uk LlBvc2l0aW9u IGNsb3N1cmU= KGNsYXNz CXRpbWU= IE9yYW5nZQ== X29wcw== IHBvcHVw IEltcHJv X3NlY3JldA== IEV1 LnNldExheW91dA== dWxseQ== IHNjcmV3 IFNpemVk IENPTVA= IG5vdGlmaWNhdGlvbnM= VHJhbnNmZXI= RW1pdHRlcg== KG9sZA== bGV0aWM= NDkz IC0KCg== IHBhbmlj NzE1 IExDRA== cnVsZXM= IGFmZmFpcnM= IEZpbGw= X0lSUQ== OTEy YXR0YWNobWVudA== IHZvbQ== PGJ1dHRvbg== NTk1 IHRleHRz IGFjdGl2YXRlZA== LmFjY2Vzcw== KHJlYWRlcg== VGVt IGNvcm9u cm9waA== RE1JTg== IGVtZXJnZWQ= IGluZmxhdGVy IEluZGVwZW5kZW50 b3Jpb3Vz IERlbGhp Njcy IGdseXBoaWNvbg== IENhcmw= U2k= IGV4cGVyaW1lbnRhbA== LmJhcg== SUFO IHNxbGl0ZQ== Y2Npw7Nu OTA0 X0JBQ0s= LG5hbWU= aG9ydA== IHRlbnM= NTQ5 6rM= dXNpdmU= IGdlbnVpbmU= IGJ1Y2s= L2Rpdg== LnJvb20= X05FVw== ZXN0YWRv IEFyaw== b2NvbHM= LmdlbmVyYXRl dG91Y2g= Zml4ZWQ= ICco IHJlZmVycmluZw== IG92ZXJ3aGVsbWluZw== KGxldA== IGZ1ZQ== NjIz X0VOVg== d29tYW4= RmlndXJl YW5pbWF0ZQ== IE1vcnQ= IGxvbmdlc3Q= Y29sbg== VE0= Ol8= cmllbA== LE4= IFJBTQ== IGp1c3RpZnlDb250ZW50 IGFjdGl2ZWx5 L3B1YmxpYw== IOuw R2l2ZW4= T1RBTA== 5aSx6LSl U2VxdWVudGlhbA== IHN1cHBsZW1lbnQ= LmFi IGNhdGVnb3I= fX0sCg== YWhhbg== J3Vu b3NpdHk= IGFjY29tcGxpc2g= VXRpbGl0aWVz LnZpZXdz LmNu Y2VpbA== IENCRA== IFJG UEVH IEdpZnQ= QVlT IFdJTg== cGFuaWVk IMWf IG9ic2VydmVy IHNtZWxs IHs6 TGlua2Vk PlsK b2xlcg== IGxpYmVydA== IGAK IHdlbm4= bGF0ZWQ= IGltbXVuZQ== KE5vZGU= IFByb2JsZW0= IEFicw== bG9ncw== IC4uLw== IEFEQw== IH19Ij4K PicpOwo= PWI= IFdpbmQ= bGFob21h IGFsbG9jYXRl b3JpYW4= IHByZXNjcmlwdGlvbg== LXF1YWxpdHk= IE1heW9y ODU1 aW5lbHk= ZW5kZm9yZWFjaA== IENvbXBsZXg= a29t NzA5 VFk= Nzkw XV0u LlN0eWxl X21hbnk= JywnJA== IGJhcnJpZXI= IEZldGNo IE1hcnZlbA== IHJlc2lzdA== 0L7Qs9C+ YmlkZGVu IFJ1bm5hYmxl OmZhbHNl ODk5 IGJ1aWxkcw== IFN0YWdl IGR1Yg== ZW1wbw== LnNpdGU= NTU4 OwoKCgo= OTk0 IERlbnZlcg== IHJldmVs IHRyaWdnZXJlZA== IGRpY2U= X2ZhaWw= IGdj ODMz NTg5 CVg= IFRocm93YWJsZQ== Nzc1 LnJvdXRlcg== IFJldm9sdXRpb24= 0YDQsA== X05PTg== MDU1 n6U= NTc4 IGVsZGVy IGFicm9hZA== INC1 IEFkdWx0 Ymxy Z2x5cGhpY29u NjEz IHByb21vdGluZw== IGl6 IFNvbGlk NjQ1 X2xvYWRlcg== ZWFybHk= LmVuYWJsZWQ= LWVkaXQ= IFVM X3BsYXk= IEludGVycnVwdA== IGFkdmFudGFnZXM= dWNsZQ== IG1lY2hhbmljYWw= LnRhYmxlTGF5b3V0UGFuZWw= IFdvcmtpbmc= IGFub255bW91cw== UmF0aW5n aWdpb3Vz X3Bob25l LmFkZEFjdGlvbkxpc3RlbmVy IGZyYW4= dW5kZW4= ICopJg== X2Jvb2w= dWxhdGl2ZQ== IGNvbmU= IE11bHQ= IG3Dtg== IEZvcndhcmQ= XSk6Cg== IGNvbnZpbmNlZA== YWN0ZWQ= NjQz 44GT IENvbmZpZ3VyZQ== IGNlaWxpbmc= RGVy IHBhc3NlbmdlcnM= R3JvdXBz IHNvY2Nlcg== L1c= YXZpb3Jz c3dpdGg= IFpvbmU= Lk9wdGlvbnM= IE1vbQ== aWVkZXI= QXJyYXlz IHRyZWF0bWVudHM= IHByb3RlY3Rpbmc= ZmFj IHBpY2tsZQ== QnV0dG9uSXRlbQ== NzEz IGJsb2NraW5n c3RyYXI= w7I= IEV4cG9ydA== IHRocmV3 b3R0YQ== IEJBU0U= Lndz LkxFQURJTkc= b3JkZXJCeQ== X2RlbGF5 IFB1 LmRsbA== IENob29zZQ== OTky UG9saWNl IEJFR0lO Ym94ZXM= IGRpYW1vbmQ= LGw= IAkJCQ== IGN1cmlvdXM= NjI0 dHY= IGVyb3Rpc2NoZQ== YWNrYWdlcw== CVNldA== VGljaw== LmJvcmRlcg== c3RhdGljbWV0aG9k IGNoZXI= aW52b2ljZQ== IGNydQ== IGRlZmVjdA== X21ldGFkYXRh cmVsYXRpb24= aWthbg== W04= KFF0 KEJhc2U= 5oGv YmVhdA== IEVtcHR5 CW8= X3NoaWZ0 IHJlZ3JldA== NzIy VGhvc2U= Q2VudA== IFBvcnR1Zw== IElzbGFuZHM= IFRJTUU= TWFuYWdlbWVudA== OTk2 LXNw NTM5 w6ptZQ== IG5vdGlvbg== dW5pZnU= UEs= ODI2 6KGM IENVUkxPUFQ= XCJc VVY= 57o= ZHJh Y291 PWA= IERlc3Ryb3k= cnA= LmNhbmNlbA== R0c= cnVudGltZQ== IFZ1ZQ== IHByb2dyZXNzaXZl L3NlcnZpY2Vz IHJ1bm5lcg== X0ZSQU1F LlRvb2xTdHJpcE1lbnVJdGVt ICcsJw== ZGVsYXk= PXV0Zg== IHNjcmVlbmluZw== IHB1bGxpbmc= b21hcw== IGFudGg= LW5ldw== L2xvY2Fs IGlQYWQ= IHR3aXR0ZXI= IGR5aW5n IGhlYXZlbg== IFVJbnQ= IFNlbmF0b3I= IHByZXN1bQ== IFdhbGtlcg== IG92ZXJjb21l ZXRlY3Rpb24= IGVtYmFycmFzcw== Q2hpbmE= NjM5 SW5jbHVkZQ== Uk9MTA== IGRhdGFUeXBl RGF2aWQ= 4Lij bG9w LW1vbnRo IHNjYXI= IFNhZmU= ICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= IGFjY2Vzc29yaWVz IHJhbXA= X1VTRQ== IGNvbnRyYWQ= KSldCg== IHByZXN0 IEhS IFJhcA== IHVzaXpl IGNhcGFiaWxpdHk= IGNvcnQ= LW5leHQ= MDc3 NjI3 IGJ1cmRlbg== ODIy X3JlYWRlcg== IEBA cmVndWxhcg== IEth MDM2 TUFO IGFzdHI= ICcnKQo= IGZlZA== IHBhcnNpbmc= IFllYXJz IGJyb2tlcg== Ijp7Ig== IGFrdA== SW52ZW50b3J5 YWJlbGVk IGFyZ3BhcnNl KioqKioqKgo= dmVyc2F0aW9u IGNvcmQ= IFRp IGhvcGVmdWxseQ== IGFo dmVyYg== IHN0b2xlbg== LkVudHJ5 IGV4cGVjdGluZw== T3JpZW50YXRpb24= IHBvd2VyZWQ= IHBlcnNpc3Q= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= J10pOw== JykpLAo= IENhc2g= CWl0ZW0= ODE4 Z3JhZGVz cm9wb2w= YmFzaWM= ICIpOw0K IGF3YXJkcw== KHJhbmdl LWFsbA== IElCT3V0bGV0 IEluZGVlZA== LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== IHN0b21hY2g= IGZsb3dlcg== IHNldw== X3RpbWVz YXZpcw== UVN0cmluZw== IFJvdXRlcw== X3Byb3Q= IGNvbWVkeQ== IGxvZ291dA== IHdvb2Rlbg== IHBvc3Rlcg== cGllY2U= LkpvaW4= IFBvaw== Y2Vsb25h bXV0ZXg= Ow0KDQoNCg== IHN0cmlrZXM= Nzg3 TG9hZGVk KWFyZw== ZXNh VW5pdGVk RXA= UEVMTA== ODA3 IEF0bGFudGlj dWxsZXQ= NjUy YXBwbGU= IHNldHRsZWQ= YWNvbg== IHByaW50ZXI= IEdD 5a6a IHJlbmRlcmVk LOKAmQ== aGVpdA== c29jaWFs Lmdl NzE0 IFJpY2s= IFV0YWg= Z290 b25pY2Fs IFNjcm9sbA== IFNjaWVuY2Vz IGp1Zw== IGFtcGw= ZW50aQ== TEVGVA== IHRhYnM= IGVub3Jtb3Vz LmdldEtleQ== bG9jYXRl LkVY LnN0b3JhZ2U= Lldl IHRvYXN0 IEFkZGl0aW9uYWxseQ== ODgy IE5PVw== NTQ3 X1VQREFURQ== IHRyYW5zZmVycmVk dGhh LkRpc3BsYXk= X3Vp SURFTw== IG1lYW5pbmdmdWw= IE1vc2Nvdw== LHRoaXM= IFZpY3Rvcmlh 5pS5 INCf LnN0YWNr IEJhcm4= cGFyZWRTdGF0ZW1lbnQ= OnN0cmluZw== IGJpag== IFNUQVRF IGVtcGxveWVycw== CWlucHV0 KHw= IGxleA== aW52b2tl CW51bQ== Kyss YXRpYWw= b3JzZXM= IGZvcms= X3R4dA== IEFudG9uaW8= ICg8 YXZlcnNl IGRldmFzdA== 44CA LkRlYw== IEdhcmQ= L3Vp LiU= dHJp IHJvbGxlZA== VmFsdWVQYWly aXR0ZW4= IFRoZXI= IHZyb3U= IEZsb3c= IEZpbmFuY2U= IENvbWI= SEM= LnNldFZpc2libGU= aXNs IHBr Nzcz IHVwc2V0 KHJhdw== IFZpY2U= ZWF0dXJlcw== IExhbmc= MDI5 TG9va2luZw== NzY3 IEFTVA== IHRyaXBz IEp1c3Rpbg== YnJvd3Nlcg== PSInLiQ= LnZlcnRpY2Vz ODIx LWNv fS97 ID8s IERvbWlu IEJlbGc= Ijw= IHN1cHBvc2U= YWRkeQ== IHdhbGtz Njg4 RVJSVQ== X2ZpbHRlcnM= UHJlZmVycmVk c2NlbmU= 0LXRgQ== IEFmZmFpcnM= ICIjew== IG9uU3VibWl0 IHN0b2Nrcw== L3ZpZXc= Z3JlZQ== LWdldA== OTAz aGl0 Sm8= LmdldEM= NzI1 SW5pdGlhbGl6ZWQ= 0YLQuA== Y3V0cw== KFR5cGU= IEFncmVlbWVudA== IFZpZXRuYW0= IC8qIQ== IHBpenph LXZpZXc= X2Vt IGxocw== IG11eQ== IElkZW50 IEZyaWVuZHM= MDYx IGFidW5k X0FE LnRpbWVzdGFtcA== LSc= IGR1cGxpY2F0ZQ== IGh1bnRpbmc= IHJlZ3VsYXRvcnk= aWFv YW1vdXM= IEVudGVydGFpbm1lbnQ= W0E= aWF0cmlj X0NMSUVOVA== IEtpZHM= L3BrZw== QnJlYWs= KSkpOwoK IFNoYXBl IHJlbGF0aW5n SW50ZXJydXB0 YWJsZU9wYWNpdHk= ZW1icmU= IG15c3Rlcnk= IGpvdXJuYWxpc3Rz cml0YWJsZQ== Lkxpbms= IHN0b3BwaW5n Q1JFVA== LkRC IHBvcHVsYXJpdHk= IGdldw== IGltcHI= c2V0VmFsdWU= RkxBRw== CW1heA== IGJha2U= d3k= IEVjb25vbWlj IGVuY29udHI= IGZuYW1l L2Rl UmFuaw== IGJ1Z3M= LnNt IG1lZGlhbg== RE9XTg== IFN1cmU= QXRJbmRleA== IERpY2s= IChfXw== LmRlbHRh RnI= IHN1Z2dlc3Rpbmc= IFJlY3ljbGVyVmlldw== LGU= U1RBUlQ= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= eGZvcmQ= IHJlY2VpcHQ= Q0xBSU0= cmVhZG9ubHk= OTY4 IGVuZ2FnaW5n NjE5 Q2E= YXNtYQ== IGVuc3VyaW5n RW5nbGlzaA== IFZhbmNvdXZlcg== aHl0aA== IHB1cmNoYXNpbmc= IFBJ LndvcmQ= KHNw LmhvbWU= OmRlZg== IGdpZw== NTc0 Njcx IFZl Zm9ydW0= IE1pdGNo QmF5 X0ZM NjUx IHNvbGw= NTc3 X2NvbHVtbnM= IG1pbm9yaXR5 YmlyZA== IGhhbmRlZA== U1NM U1RBVA== IG5lcnZvdXM= g70= IGZpbGVQYXRo Q1JFQVRF QXc= IHBlbnM= ODM1 c2VlZA== IENvbXB1dGU= b2xr NTk0 IEFzc2V0 cmVhY2g= JyksDQo= bmF2aWdhdGlvbg== TEY= L3V0aWw= IFB1Yg== IOKU Y2lvbg== IyMK MDcy SUlJ VGFnTmFtZQ== IGFtaWQ= cGVybWlzc2lvbg== aWZpYWJsZQ== eEZGRkZGRkZG 0L3QuA== LkJ1ZmZlcg== X2lycQ== ZGFyaw== IHJldHZhbA== LmZpcmU= cHJvZHVjdGlvbg== Lmxpc3Rlbg== IFdlYXRoZXI= IGJ1eWVycw== Lm5l ZXJw IFBlbnQ= Njk5 IHdlbGZhcmU= IHBhZ2VTaXpl IFN0YWRpdW0= ZXJ0YQ== IGxldg== YW1wYQ== UGFnZXI= NjY1 IGNoYXJnaW5n IE5ldGZsaXg= fG51bGw= X3JhbmRvbQ== LnhwYXRo IHN0ZXJl IElTSVM= cG9uc2Vz KGxvYw== NTY2 ZXlvbmQ= IE9mZmljaWFs NjU3 IE1hcnlsYW5k RGF0YVR5cGU= X3Bhcg== e30s IEVuam95 NzI3 X1NISUZU IEF3YXJkcw== X0VOVFJZ IHNlZW1pbmdseQ== ZW50aWNhdGU= IGhlYXJ0cw== NTgz XzsKCg== IEhJVg== IGluZGl2aWQ= IEZsYWc= X2N0cmw= IENhbGxiYWNr LHo= IEdQVQ== CW9iag== IFBob2VuaXg= IEJVUw== OTA3 IHJ1YmJlcg== X0FVVEg= IFNvbHV0aW9ucw== KGxvY2F0aW9u VmFyaWFibGVz LnNldEVuYWJsZWQ= X2hpZ2g= V08= R2VzdHVyZQ== IHJldHJ5 IG9iamVjdEZvcktleQ== YWxsb3dlZW4= IG1vcw== IENlbGU= IGlra2U= KGNlbGw= IE1PREU= cmVuYQ== IGRlc2NyaWJpbmc= NjQx IHBoaQ== IHJk IGRlc2VydmU= IHdoZWVscw== 5biC IGNyaXRpY3M= NzU1 TmFtZXNwYWNl IEZyYQ== IAoKCgo= IGFsbGE= IHJlcXVpcmluZw== 5pyf dXRhdGlvbg== IGRlbGF5ZWQ= IGFkbWluaXN0cmF0aXZl IGJheQ== LmhpZGRlbg== VGV4 MDUx IGJvdW5kYXJpZXM= IF0pOwoK IEZvbGxvd2luZw== fi8= Rmk= X2NvbnY= X1RJVExF IGRlc2Rl SUNvbGxlY3Rpb25WaWV3 QWxpYXM= IGJpdGU= cGF0aWVudA== X0NPTU1BTkQ= Q29tcGxldGVk CWVsaWY= KDw= QnVzaW5lc3M= IFBvb2w= IHB1cnN1ZQ== IEJhbg== X3N0ZXBz X0RFQ0w= dW1ibGU= IGNvbWJv IExheWVy Lnhy IGR1cA== LS0tLS0tLS0t NjI4 IG1vZGlmaWVy cm9i cmV6 Njk2 IGF0aGxldGVz VXNlZA== d2Vhcg== ODE1 IGxlZ2l0aW1hdGU= ICIKCg== IGh2 U3Rk MDM3 IEhvbGQ= IHN1cnZpdg== IEFsbGlhbmNl IEVhcmx5 Nzc4 QmVoYXZpb3I= KGZvbnQ= L2xpYnM= IHJlY3RhbmdsZQ== IHNpbmdlcg== IGFtcA== RXF1YWxUbw== ICIuIg== IGdpcmxmcmllbmQ= 5bE= bGluZWFy b2JzZXJ2 IHBpw7k= IGNvbXBsZW1lbnQ= V2l0aFZhbHVl KHBhc3N3b3Jk dGFrZQ== Qmxhbms= IENvbXBhcg== JyIs X3BvbGljeQ== bW9uZ29vc2U= X0ZBSUxFRA== LnJlcG9ydA== UmF0aW8= LlBlcmZvcm1MYXlvdXQ= NzQ3 dXNhYmxl bWVycw== X3JlbmRlcg== UEVFRA== Nzcy IGxlc2I= CUU= X3Rvb2w= IGxhZGllcw== OTA4 0L7RgQ== KSkpKQo= Ozs7Ow== LmRvdA== IG5lc3Q= cGVhaw== dWtraXQ= ZWNh X1NX ICYo IE9rbGFob21h IGJhbmtpbmc= NTY5 IE5pbnRlbmRv NzUy IHJlcHJvZHVjZQ== X2VsZW1lbnRz X21hYw== cHJveHk= IHJlbWFya2FibGU= fS8kew== IG91dHM= Lmhhc05leHQ= TU9ERQ== NjU4 IGFuaW1l LmNvbm4= VW5pcXVl RG9t IGltcG9ydGFudGx5 aXR0eQ== IGp1aWNl VHc= IFBhcnRuZXJz IGF0dGFja2luZw== IHBvcnRhYmxl YW1pZW50bw== LlBpY3R1cmVCb3g= Lmdlbg== IG9wdGltYWw= NTgy IHJlY3Jl IGpvdXJuYWxpc3Q= IEV4dHJhY3Q= IE1vcmVvdmVy IG1hcmdpblRvcA== LkFw IGZpcmluZw== TmFO CXRlbXBsYXRl 0LDQtA== LkVu IGRlZmVuY2U= IFRlbA== aWxlbg== amFu PWRhdGE= IFVybA== IFJldXRlcnM= KHRvdGFs IEZpZnRo IGVzc2F5cw== IGludGVycHJldGF0aW9u IGNoYXJpdHk= IFJ1bGVz IHN1YnNlY3Rpb24= c3R5bGVk YXplcg== bGFncw== TElTVA== IHVwbG9hZGVk IHRyYXNo IHJlZ2lzdHI= IHNlbGxlcg== Pic7DQo= IHN0YXJ0VGltZQ== 55k= c3k= KEh0dHBTZXJ2bGV0UmVxdWVzdA== IHRyYXA= R0M= IGVtYmVkZGVk IHN1cnJvdW5kZWQ= ODE2 aW1pdHM= VFg= eWxpbmRlcg== Njg1 IEZhbA== IHNlbnRlbmNlcw== IEph SUZJQ0FUSU9O d2VhcG9u b3ZhdGlvbg== IGNvYXQ= IGludGVycG9s IGxpcHM= IEt5 IHZlY3RvcnM= X2Ft IGludGFrZQ== Lndvcmxk IGluYm94 IE1BQw== X2Fi KG5hbWVvZg== NjMz IGVudGVydA== IGdhdGhlcmluZw== IFNJTQ== Kysu bnlh J319 IFVQREFURQ== IHBhYw== KGh0bWw= IFNhbnQ= aWF0aW5n IElkZWFz IHNwcmF5 IEhhcnQ= IHZlcmlmaWNhdGlvbg== YWRlc2g= L21vZHVsZXM= IE1pbmQ= IFNpemVkQm94 IHNoZWx0ZXI= IGhlcm9lcw== YXR0eQ== IGNlcnRpZmllZA== c2o= IMOqdHJl xYJv IHB1Ymxpc2hpbmc= IE1hbGF5cw== LmdldFVzZXI= IFByb3ZpZGVy IExpbmtlZExpc3Q= IEJvcg== Uk9VTkQ= ZGlk dGFpbg== cGlyZQ== IEplbm4= dGVs YW5kZQ== NzU3 X2Zyb250 IE1jRw== VGVzdE1ldGhvZA== 4Lit IG9jY2FzaW9uYWxseQ== IFdhbGVz IGV4ZXJjaXNlcw== INCS MDQ1 LXBsdXM= IHZhbGlkYXRvcg== IHByYXllcg== TEFURUQ= X2F1dGhvcg== IGxhYm91cg== KysK LWVxdWl2 IEdQTA== IGZhY2Vib29r c2ltcGxl Z2x5 UHJvY2Vzc29y aXB5 NzQ0 ICo+ NjQ4 IGNsZWFyZWQ= IFB1c2g= ODU4 IHBlbmlz U3RydWN0dXJl bGlq IE1vcmdhbg== IGhhbmRmdWw= Ii4K OTg0 fFw= ICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq IEFxdQ== NTg0 X0lD LmxvYWRz IG1ldGVy IE1hcmluZQ== Ojp7 IFRT Nzc2 IEFycmF5cw== LlRpdGxl R1JBTQ== dGVybWlu IGNvaW5j RWxzZQ== X3N0YXRlcw== LXJ1bg== bWVtYmVycw== Nzgy YXN0cm8= MDY2 IG9uUHJlc3M= IGJlaW5ncw== IGFiYW5kb25lZA== IHRheHA= b3duZXJz Lm1vZGU= IGRpYWdub3Npcw== IF8K IEtuaWdodA== CUE= IG9ic2VydmU= KSwn ODIz ISIpCg== IFBhcmE= IHZhcmlhdGlvbg== KEZhbHNl IEFudGk= IGdyaQ== IGhvbWVsZXNz P3Y= IGJleg== LlNlcnZlcg== cmVsZWFzZQ== IFBhdHJp IGNoYXJz IHJhbmtpbmc= YWN0aXZhdGlvbg== NTgx IHdpZGVz cXI= LlNxbA== YWN1bGFy IEJvdA== X3N5bmM= IGhhcHBpbmVzcw== IHZvbHVudGVlcnM= ODc3 IHNpdHM= Lzw= W2U= KGZpbGVOYW1l IGNhcGFj ODMy IE1hcmlh ZmF0aGVy IGdyYW0= Kmk= IGNhc28= X2RyYXc= IFJhdw== IEl0ZXJhdG9y NjY0 IFBhZGRpbmc= OTI0 UEQ= Qk9Y IFNQRUNJQUw= IGZlY2hh IHZpZGU= IExlYWRlcg== 5Lul JCgiLg== IGRpYW1ldGVy IG1pbGQ= NzQ1 IHJvY2tz YXBwaW5ncw== MDQ4 ZGlyZWN0b3J5 NTU3 LmZsdXNo IEplc3M= VU5JVA== IFBlYXI= IG1hbmRhdG9yeQ== U3Vy cXQ= IHN0cmVhbXM= IGNvb3BlcmF0aW9u IFNhYw== IGNoZWFwZXI= CWNo YW5pbWF0aW9u ZmFyZQ== KGhlaWdodA== KFRydWU= Tlk= IHdyZXN0 IHBvbGxz IGVuY291bnRlcmVk IE1hcmtldGFibGU= X1BBU1NXT1JE NzE2 X1NFTEVDVA== IEFyYWJpYQ== X2Nsb2Nr IHZveQ== INC40Lc= IHN0aXI= aXNpYmxl LWVmZmVjdA== LmNyZWF0ZWQ= IHRveXM= IFRyYWRhYmxl IHJ1c3Q= IHN0cmNweQ== X3RpbWVzdGFtcA== IHRhbGVudGVk LG51bGw= IEpvYnM= IFBvcnRsYW5k IHdlYWtuZXNz VGhyb3c= IEFuZ2Vs 5L+u NzU0 IHVuY2VydA== 77yJCg== IOydtA== V2hpY2g= IFstXTo= U29tZXRoaW5n IGNvbnZpY3RlZA== a2xl ZWRpdW0= IGJyYW5jaGVz IGJhc2Vz 564= IGNvbXBsZXhpdHk= IEZpZw== LnJlc2hhcGU= JGRi NzM2 X0NPTlNU IFRlcw== LnJ1bnRpbWU= IGRlbnk= IEJTRA== IGty aGF0dA== IFN0YXRpYw== IHVuaXZlcnNpdGllcw== UmVwbGFjZQ== IGRyb3Zl IGFkb2xlcw== X3BsdWdpbg== IExHQlQ= IHRleA== ZHVjdGlvbg== NzUx Nzk5 RURJ IFRlZA== X1VSSQ== IHJlY2VwdGlvbg== YXJ0ZW4= LlNpbmdsZQ== cmljZQ== c2Npb3Vz ODQz X2Jn IHdhZ2Vz IFNlcnZsZXQ= VUlMYXlvdXQ= IGZvcm1hdHRlZA== Lk1vZA== PGNsYXNz aXNlbg== IHJlcHJlc2VudGF0aXZlcw== Il09 IHBvcnRhbA== IEh1bnRlcg== IGhpcmluZw== X18pCg== cmljdWx1bQ== dW8= bGllc3Q= IHRlYXJz TGF0 IGxpdGVyYWw= Lkluc2VydA== IGN1cnM= IENvbXB1dA== IHRlcnJvcmlzbQ== IHN3ZWVw IFtdDQo= IHBhc3Nlbmdlcg== IGVhc3Rlcm4= IHR3ZWV0cw== IG9wZXJhdGVk d25k IFN5bg== LnRvb2xz IFdN dWxhdGVz IGJhY3Rlcmlh KGJ5dGVz LnNldERhdGE= IHZpc2liaWxpdHk= Ly89PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09 ZWxt IGdlbmVyYXRpbmc= IG12 IGto amVu L3NlYXJjaA== IGFjY291bnRpbmc= c2VnbWVudA== YWN0aWM= Lmlw IGRlcGxveW1lbnQ= IGZvb3Rlcg== PicsCg== IGV4cGFuZGluZw== IEhhbWlsdG9u IENvbnRyaWI= LlRhYmxlcw== NzI4 QWN0aXY= SEg= b2NvbW1lcmNl Xzs= IGFtb25nc3Q= b3dpbmc= ODU5 IENvbGQ= QVBI IHBzeWNob2xvZ2ljYWw= X3RlbnNvcg== IHBhY2thZ2luZw== IFN3ZWRlbg== IHBhcmU= IGFnZ3JlZ2F0ZQ== IG1vZGVyYXRl ODYy X2hhbmQ= IGRlc2lnbmF0ZWQ= IGRydW0= IGdldFVzZXI= IENyZWVr X3Njb3Bl IFRyYW5zZmVy IE1hcmc= IGZpZ2h0ZXJz V25k IFNlbA== IExhdW5jaA== IGVtZXJnaW5n aWZyYW1l IEFkZGl0aW9uYWw= IGZlYXJz IHNhdGVsbGl0ZQ== Xzo= IGRpc3Bvc2luZw== R2V0VmFsdWU= SHR0cFBvc3Q= QVRJVkU= dWxhcnk= Vmlld3M= IGF0dGVuZGluZw== IFRlbm5lc3NlZQ== IE1pc3Npb24= IG1lZGljYXRpb24= IFd5 IEFubmE= 2Lk= IFZlcnRleA== LnR5cGVz T3JnYW4= LkRhdGFHcmlkVmlld1RleHRCb3hDb2x1bW4= IFJT IHRlbXBv KEFwcA== ODky VmVyc2lvblVJRA== LnBvaW50 IER1dGNo SG91cnM= TFU= IHF1b3RlZA== LmJ1aWxkZXI= IFBlcmZlY3Q= IEFsd2F5cw== X3R3bw== IGV4Y2x1c2l2ZWx5 IENyYQ== aWZpY2Fy IEFXUw== aW5naGFt Y29tcGxleA== a2VybmVs IGdyYXZpdHk= IHdp MDUy IG92ZXJ2aWV3 NjYx IFdhbnQ= IFdQ KHNo LnJvdGF0aW9u U3RhdGVz IFRlZW4= X2NvbXBvbmVudHM= 7IiY UmVjZWl2ZWQ= IGx5cmljcw== cml0ZXM= CQkJCQkg LUFtZXJpY2Fu W251bQ== L3B5dGhvbg== IFVBUlQ= IGFwcGxl IEpvbmF0aGFu IG1vbWVudHVt 4Lix grk= IG1pY2g= YW5kcmE= IGJpb2xvZ2ljYWw= IE1lbnM= ICUl ZWxzZWE= IE1leGljYW4= LnJhbmRpbnQ= IHRhbGU= IFZhbGlkYXRl IGRlZmVhdGVk Lmh0bQ== IGNvcHBlcg== PS8= Y29zeXN0ZW0= IHJpcA== ZGVjaW1hbA== LlZJU0lCTEU= IFRh CQkJCQkJCQkJCQkJCQk= IGRvd25sb2FkZWQ= ZW52aXJvbm1lbnQ= IG5vbWluZQ== YnVpbGRpbmc= IFNwb3Q= aXBoZXJhbA== IGFsdG8= cXVldA== IEZU L2dldA== L21hc3Rlcg== V0lO 5YWD Njc2 V2VzdA== YXJnYw== IHByb2R1Y2Vycw== IE11Y2g= X3N0b3JhZ2U= Y3JlZGl0 Q09OVA== IHZldA== IHZvaWNlcw== KCcnLA== IGluc3RydW1lbnRz NjYy IE1TRw== ZXNzZQ== cmVwb3NpdG9yeQ== b21pY3M= IGRlYWxlcg== U3RpbGw= IGJhbm5lcg== YXNjaWk= IHJlbWFya3M= W2pz IHNob3J0ZXI= Z3VscA== IG15c3Rlcg== IGt1bg== IEJpcmQ= IHRpZW5l Nzg4 bnV0 IFVt IHdpc2U= WWVhaA== SU5FU1M= MDQ2 X2JlZ2lu LWhlYWRpbmc= Q291cnNl IA0KDQo= b21iaWU= Z3JhZGVk IEdQUw== IMW8ZQ== Rml0 Y2FwdGlvbg== w7Zu L2ltYWdl bGlh KG1vZA== IGxlYWs= ZW56YQ== NjI5 L0g= IEhhcHB5 OTkz RGlzdA== bng= IEdvdmVybm9y KGxhc3Q= dGVhY2hlcg== IFNlbnQ= c3VwcG9ydA== ODM4 amVjdG9yeQ== INmF UmVnaXN0cmF0aW9u MDYz IEdyYXk= LGZhbHNl IGFkanVzdGVk KHNldHRpbmdz PFI= IE1hZ2U= IHBsYWludA== XykK CWl0 b21ldHJpYw== LmJvb3RzdHJhcA== IGNhcnJpZXM= SXA= ICEk IHN3aW1taW5n IE1hcmlv IFF1ZXN0aW9ucw== UEFDRQ== 5pa5 ZW9y fX0i IG92ZW4= IEtvbg== IHdpc2RvbQ== IGFjcXVpc2l0aW9u ZXNzbWVudA== YWdpbmU= IGV4cHJlc3Npb25z U2VxdWVudGlhbEdyb3Vw RnJvbnQ= dWxwdA== YXdr J10pCgo= ODEz NzMy X0FS IGFuYWxvZw== dWxpbg== X1BSSU5U IExH IGJsb2I= IEZ1cnRoZXJtb3Jl X2NvbXBvbmVudA== IENvbGU= TEFO U0NSSVBUSU9O IGxhcA== aWNlbnNpbmc= X1RJTUVPVVQ= IEZybw== IGxpYWJpbGl0eQ== IGNvbXBvc2Vk NjM0 LmNyZWF0ZVNlcXVlbnRpYWxHcm91cA== X3BlcnNvbg== IGJlYW0= CSAgICAgICAg IE5vdEZvdW5k Njg0 LicK w61z LlRleHRWaWV3 UERG IGthcg== X18oJw== ICI6Ig== X21lc3NhZ2Vz IGhhcnZlc3Q= Lmhpc3Rvcnk= PicK LWZvbGQ= 5oo= IEJldHRlcg== ICJcPA== c3BhY2luZw== IGZ1cm5pc2hlZA== OTEz b3Nlcg== XX0K ICQi cHVsbA== LlBvc3Q= OTE5 KGlw l48= LmZyb250 bnRl IEZN Z3VpZA== ODQ0 IG5lZ290aWF0aW9ucw== YWdvbmFs OTM0 IHRyZW1lbmQ= dW5nZW9u QWR2 Y2Fyb3VzZWw= w59l X0RFU0M= IGhhbW1lcg== 4bqt ICAgICAgICAKCg== LWNvcmU= LXNlcnZpY2U= IGNvcm5lcnM= IFNG cHJlZA== PkE= IEpMYWJlbA== IHJvbWFudGlj IHRlc3RpbW9ueQ== b3Nj IEdlbmVyYXRpb24= YXN1cmVz X2ludGVybmFs IHByaW50cw== IF0pCg== IENsZXZlbGFuZA== cmVwbw== RGlzYw== Njc3 NzYy ICI+Cg== 77+977+977+977+9 IG5lYXJlc3Q= NTkx X3Ri KHJlcXVpcmU= RU9G LWNoaWxk IGJ1ZGQ= Llh0cmFFZGl0b3Jz YWx0aWVz NzIz XCI6XCI= V29yZHM= OTE3 IGxvY2FsbHk= IHB1cmNoYXNlcw== Njk1 RHJhd2Vy ZXh0cmFjdA== IGV4ZWN1dA== fScu dXNlcmRhdGE= IGZvY3VzZXM= LW1pbnV0ZQ== NzY0 IFB1Ymxpc2g= b2dv IG1vdW50YWlucw== Qm90 fT57 IHRlbnNpb24= cm9k bWVzaA== IHRyYW5zZm9ybWVk LFI= KCl9Cg== Lmxvbmc= IGdvcmdlb3Vz IFNjaGVkdWxl IG9sZGVzdA== IHN1YnByb2Nlc3M= KElO eWVjdA== IENvb3Blcg== YXJuZXNz IE1vbml0b3I= LnBhcnQ= OTcy IE5CQw== NjY4 IGNvdHRvbg== IGhvbA== NzI2 IHJnYmE= IEJpbw== Q29udGludWU= UG9k IHBhcnRpY2lwYXRpbmc= Y2x1c2lvbnM= KEJ5VmFs NzM0 w6w= IEhPVw== X3NldG9wdA== IGFjY29tcGFueWluZw== MDkx YXRvbg== IC9c IEF1dGhlbnRpY2F0aW9u acOpbg== IEJhcmFjaw== Lyou IGVhZ2Vy IENhbmNlbA== PGxlbW1h ZXBo CXdpbmRvdw== IGluY2lkZW50cw== NzU2 KSwo LkRlcw== aWJl IEZ1bmN0aW9ucw== IGhvc3BpdGFscw== MDM4 IG94eWdlbg== cm9vdFNjb3Bl IGRyZXc= CXJlcXVlc3Q= bm90aWNl YWt1 YW1lbnRz ZmFy OTcz Nzc0 IHByZWNpc2U= X3dyYXBwZXI= IGxpc3RlbmVycw== QVo= LmJvdW5kcw== IEF2ZXJhZ2U= ZmllbGRzZXQ= X2F4aXM= IGV4YW1pbmF0aW9u Jy4K bW9ucw== Kyspew0K IEZvcm1z 7ZWc OTE2 Q3BwTWV0aG9k X3RyYWNl IGVuZ2luZWVy NjYz IEZsYXQ= IHJldmlzaW9u IGhlYXRpbmc= NjM4 L3Byb2ZpbGU= LnJ1 cHJpb3JpdHk= IGluZmVy X1NUUkVBTQ== ICopKA== PiQ= T0xFQU4= T0tJRQ== SUJJTElUWQ== VUFHRQ== IFN1cnZleQ== MDcx IHJlc2lnbg== d2luZw== IHNlY3JldHM= IGNoaXBz SlNPTk9iamVjdA== RGVza3RvcA== NTk2 X1NZTUJPTA== KHJlc291cmNl IDwvPgo= IG5ld2VzdA== dWxp IGRlc2VydA== IGRpcA== IFBvdw== IGVxdWF0aW9u IHBvc3NpYmlsaXRpZXM= IEZlZA== b3NwaA== IFsl IGJ1YmJsZQ== ZXRoZXJsYW5kcw== Nzkz IGNlbWVudA== LmF1dG8= X0FO 4oCZLg== c2VsZWN0aW9u IEJvbmQ= OTg4 RGVu LU8= LmdldFR5cGU= ODk2 LldpbmRvdw== cHJlcw== IHN3aW5nZXI= In0pCg== IHBpcA== IG1pY2U= IGNvbXBvdW5k LXBsdWdpbg== aWtv IGNlbnR1cmllcw== aWN1bGFy LWlubGluZQ== CWtleQ== Plw8 RU5TSU9O IFsNCg== IHByZWNpc2VseQ== IMOpdMOp IFBhc3Q= IENhbWJyaWRnZQ== LWZ1bGw= IGFuYWx5emU= IFN0ZXZlbg== IG5lbQ== ZHVl b3Jlbg== IG11c2NsZXM= aWppbmc= ODUy Ly0= IEtlbm5lZHk= NTk3 Uk0= b3NzaWJsZQ== IGFjdHJlc3M= IGRvbG9y OTE0 5b2V TmVlZA== LnRvZ2dsZQ== IFJhY2U= d2Vycw== Lm1hdGVyaWFs IER1ZQ== IFBlbA== I3ByaW50 IGluZGVwZW5kZW5jZQ== ZXh1cw== U2hhZG93 IGVuY29kZXI= KGxldmVs IFN3aWZ0 LmRvYw== X3NlbGVjdGlvbg== OTUy IHNlcmlhbFZlcnNpb25VSUQ= OTQ1 TGFiZWxz IHBlcmZvcm1hbmNlcw== LlRhZw== IE5ITA== aXplbg== L1VJS2l0 OTkx X0NPTlRST0w= IGVhcm5pbmdz OTc1 IEFsdA== X0hBTkRMRQ== Q3R4 IHBlcnN1 IHRyYW4= 56g= X0NIQU5ORUw= IHNhdGlzZmFjdGlvbg== IEdQ NzY5 aW94 bWl0dA== bGFuZG8= IHBpZw== aW5hbHM= w6puY2lh NzMx U3VyZmFjZQ== IFVVSUQ= IGJlbmVmaWNpYWw= IHNlcXVlbmNlcw== CW1lbXNldA== IG1hZ2ljYWw= wqs= IHdvcm4= QVND cG9wdXA= Q09NUA== X2JlZm9yZQ== ZW5lc3M= VWk= TGVz LnJlcXVpcmU= LlNlcmlhbGl6YWJsZQ== YWRkR2Fw IGF1dGhvcml6YXRpb24= MDg1 LnB5cGxvdA== dXJyYXk= bGF0aXR1ZGU= ODQ1 ZnJhbWVz YWpz IGNvbXBhc3M= IG9ic2VydmF0aW9ucw== X3N1cA== LmVudmlyb24= IHRyaXBsZQ== IFJ1Ynk= IGRyYWlu X0ZJTFRFUg== U2Fu VU1Q TnVsbEV4Y2VwdGlvbg== IEdhYg== b3dl IFR1cmtpc2g= X3NlcXVlbmNl IEdyYW50 dWVsYQ== IHdv IGN1YmU= aXE= IGRpc29yZGVycw== IGV4dHJhb3JkaW5hcnk= IGN0cmw= IFNlcQ== ZW50cg== ODY1 IHNhbmN0aW9ucw== OTQ5 dXRzY2g= UmVwb3J0cw== IGluaGVyaXQ= UGVyaW9k IHBob3RvZ3JhcGh5 IEZyYW1ld29yaw== IHNwZWNpYWxpc3Q= ID8KCg== X3NlbGVjdGVk LlBsYXllcg== IGFsbG9jYXRpb24= KGFjY291bnQ= IHN0cnVjdHVyYWw= dmFibGU= LW9mZnNldA== LkFwcENvbXBhdEFjdGl2aXR5 0LDQvA== LkFkZFdpdGhWYWx1ZQ== IGljb25z IHNodXRkb3du X2xvdw== IENvbXBhcmU= IENl PWhlYWQ= bGFt LnByZWRpY3Q= X0RFQw== IFNsZWVw IEdyYXRpcw== IHN1Z2dlc3Rpb24= IERFTA== Y2FmZg== YXZpcnVz Tm90aGluZw== nos= IHdpZGVzcHJlYWQ= IG1lY2hhbmlzbXM= IHRleHRBbGlnbg== b2NjdXA= IFJhaWw= Ok5T IGZpYmVy IG1r IHZpbnRhZ2U= LWxvbmc= LnJlZHVjZQ== LkVudGl0aWVz KHJlY29yZA== IHBsZWFzYW50 RlJJTkc= LkNlbGxz T1RU CWVsc2VpZg== NjQ5 NzI0 X2NvbmZpcm0= IFZpZXdHcm91cA== c3lt IHByYXk= IHN1c3BlY3RlZA== Q29udGFpbnM= OTgz IGJvcmRlcnM= IGNvbXBvbmVudERpZA== QVNTRVJU IGluZmluaXRl LW9yZGVy IGhlbGxv IEdyYWRl LmN1cnJlbnRUaW1lTWlsbGlz YXBvbGlz emg= CU9iamVjdA== Olxc SE8= dmFsdWF0aW9u IHZvY2Fi NzE5 IGNvdXBvbg== YXRhYmFzZXM= LkdldFR5cGU= TGVhcm4= Nzky XT0i IEdhcnk= b3RpdmU= IGFzaA== IGJpYg== WFhYWA== IGJhbGFuY2Vk VkFMVUU= IE5hdA== X0Fk PEU= 5Yy6 IE1ldGhvZEluZm8= ODk3 TElC IGNvbnNpZGVyYWJsZQ== IEluZHVzdHJ5 dGVzdHM= LnNldFRpdGxl IEJsdWV0b290aA== IG1hcHBlZA== IEJydWNl IE1haW5XaW5kb3c= CXN0YXR1cw== IHJheg== IE1hbmQ= IGNsYXNzaWZpY2F0aW9u UGVybWlzc2lvbnM= OTY5 IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= IGNvbnRhaW5lcnM= OnNldA== X3htbA== IHdoaWxzdA== VGhyb3VnaA== IHZhbGlnbg== IHdvcmxkcw== Q09SRA== RURJQQ== 0YDQvtCy IHNwYXJl IEhhZA== IERFRg== KHB0cg== IHdhcm1pbmc= ODk4 4KS+ IGNvbnNlbnN1cw== YWduZQ== Q1RM IOyV Lk1haW4= d2ViRWxlbWVudA== IHBpc3Q= Rmxhc2g= QXBwZW5k LnR3aW1n VGFw IHZlZ2V0YWJsZXM= YWxn MDU4 LnNhbXBsZQ== IGNvYWNoaW5n KGluZA== Q2VsbFZhbHVl Q2hlY2tCb3g= IEhlbGw= Uk9PVA== Nzk2 IHN0YWRpdW0= IGludmVzdGlnYXRpbmc= KSU= c3RlZA== OTY1 IFdyaXRpbmc= IOqy IHVubw== IHt7LS0= IGNvb3Jkcw== IHVuc2Vy b3JnYW5pemF0aW9u IENyaW1l IERlbW9jcmF0 NTc5 IHZpbg== L2ZpbGU= MDc4 LWFwaQ== IEF5 IGZ1bmRlZA== IEJyZXhpdA== IEdo ZW50aW5h Y2FzZXM= IGRhc2g= ICEhfQo= SEk= T2ZmaWNl IGNhcHRhaW4= IHdvcnNoaXA= XEM= NzMz ODUx IGdsb2Jl X2JvYXJk IGJhYmllcw== ODc2 IGNvbnNlY3V0aXZl IGVuaGFuY2Vk ZXJldW0= IEFkdmlz IGdyYWlu Nzcx IGNyYXc= YW5jZWxsYXRpb25Ub2tlbg== LmFscGhh X1dJVEg= IE90dA== IENvb2w= LmJhdGNo IHZlcmlmaWVk KGNhbGxiYWNr IHJlZ2FyZHM= Njgz IEludFB0cg== b3VjaGVy IGtpbg== IHRvdWNoZWQ= aXTDoA== YXRob24= IGFkamFjZW50 IGFjY29tcGFuaWVk TEVBUg== IGltcGxpZXM= IGhpbGw= IEJhbHRpbW9yZQ== PSIt RmluYWxseQ== ODgz U2Ft aWNvcHQ= IHNvZA== IG1hag== IFNoaXBwaW5n IGdldEFsbA== IGNvYWNoZXM= IGRvbmF0aW9ucw== aWxvdA== IFRhcg== Y2Vycg== IGJhZGdl IG1hcmtlcnM= IFJhbmQ= YWlzZWQ= aXNzYW5jZQ== IGV4cGxvcmluZw== ODI3 dWNlZA== IEluZG9uZXNpYQ== IGJlbmVhdGg= IG1hZ25ldGlj IG11c2V1bQ== bWF0Y2hDb25kaXRpb24= IGRpc3J1cHQ= IHJlbWluZA== IFRN IC8+PA== IGZvb2w= IGVzaw== Lk51bGw= IERpZXM= X09VVFBVVA== X1RZUEVE IHBhaW50ZWQ= Njcz NzM1 IHNvcGhpc3RpYw== IEJlYXI= Km4= X1BBQ0s= IGRlbGl2ZXJpbmc= IENPVU5U 5Y2V IGplZw== LWNhcg== Zm5hbWU= IHJhbmdpbmc= ODQ4 IE5lZw== LyoqKioqKi8= IENIQVI= IHVsdHJh R3JhZA== PXQ= IGp1ZGdlcw== IERpc2U= YW5uZXJz OTg1 ODkx ODYx IHNjYWw= X2NhbA== IENPTk5FQ1RJT04= X2VtYmVk KGZu IENyYWZ0 MDQ3 IFBhcw== IiktPg== LmNvbnZlcnQ= LnJlc291cmNl IFNUQVRVUw== w7RuZw== IFRpdA== IGNsYXNzcm9vbQ== IEFyY2hpdGVjdA== IEtpbmdz IHN0ZWFkeQ== LyohCg== IEdlbmU= KSI7Cg== aWNpYQ== c3Rhbg== IENvbnN0cnVjdGlvbg== dW1wZXI= OTUx d2M= IENCUw== aW5naW5n LXBhcnR5 KGRyaXZlcg== TUFSSw== MDgy IG5lc3RlZA== ZXdhcmQ= IGRlcGVuZGVuY3k= IG1hbGVz OTI4 IE9ORQ== IFByb2R1Y3Rpb24= XVsk 44O844M= X0xPQUQ= IEJvbA== ZWxyeQ== ODMx oOmZpA== IFJlcXVpcmU= IHBsYWNpbmc= eHh4 Q0FMRQ== IHRodW1i ODI0 Q2hvb3Nl IHByb3RvdHlwZQ== Vk9JRA== IGxlc2JpYW4= NzQx IHRyYWl0cw== U2hhcnA= IGNvbnN1bWU= VHJ1dGg= IGFjdGlvblBlcmZvcm1lZA== IEVudmlyb25tZW50YWw= IERlYW4= IGVzdGFkbw== c2FtZQ== IG51bWVyaWM= IHRyYW5zaXQ= LkVtYWls LXNpZGU= X1JVTg== IFZpbGxhZ2U= X09QRU4= 6KY= LnJlbQ== LXdhcm5pbmc= YW55YQ== UHJvcGVydHlDaGFuZ2Vk ICghXw== KGNoZWNr aWxpYQ== IFNvZnQ= c3RlcHM= IE1hZHJpZA== TWVtb3J5V2FybmluZw== IGhhbmRsZXJz IGV4cGVyaWVuY2luZw== IGluc3BlY3Q= YnV0dG9ucw== UmVjZWl2ZU1lbW9yeVdhcm5pbmc= Y2hlbXk= TGlua3M= IHVybGxpYg== LlN5c3RlbUNvbG9ycw== IEVpZ2Vu IHB1bmlzaG1lbnQ= OlVJQ29udHJvbA== YmFyYQ== LXNldA== IH0NCg0KDQo= IHRvbGVyYW5jZQ== IGludGVyZmFjZXM= LnJlZGlyZWN0 aWdoYm9ycw== Y3NyZg== X2JhY2tncm91bmQ= LlV0aWxz X0hU Njky IEludGVyZXN0 aW1vcw== IGdyYW50cw== MDgz IGV4YW1pbmVk 0JQ= IGNm Zm9yZ2U= YmFja3M= IE9iamVjdHM= X3NlbnQ= LmVudHJ5 IFRIRU4= ZWxsaWRv Y2lh LHJlcw== NjU5 Njgx L3N0ZGM= Lm5k KEludA== IEF1dGhvcnM= IEFwcENvbXBhdEFjdGl2aXR5 J3s= IG1lZGk= TXVzaWM= aWdt Y2VpcHQ= IGF1c3M= IHRhcmdldGluZw== IEtleXM= aG4= Ol0K IG1pbmVyYWw= w64= LmNh NzYx b21lZA== IHNoZWV0cw== IGNhbWI= IGRlYWRseQ== LmluamVjdA== KHVuaXQ= IFNlbGVjdGlvbg== Lmdtcw== KGNvbm5lY3Rpb24= ICQoIg== w6ltb24= IEN1cnJlbnRseQ== cHRl X3BhdGhz ODQ3 bGVhZg== IGltcGxpY2F0aW9ucw== cG9zYWw= 5L2N Wy8= YW5jaWE= 6Zs= bXVs Y2ll IGdlaWxl Njc5 aW1hbHM= VUlWaWV3 IHN1cnJl c2VyaWFsaXpl SVNP IGFyYml0cmFyeQ== IHNvY2thZGRy LmZu IE1lcmM= IGNhc3Rpbmc= S2V5RG93bg== IG5ld1ZhbHVl b3BlbnM= NzE3 VG9kbw== IGZsZXhpYmlsaXR5 CQkJCSAg VmVsb2NpdHk= w7pu cm93aW5n IGNvbXB1dGVk YCkK c3RhdGVtZW50 IHJp X2NhcnQ= TG93 dHJhbnNmZXI= Lm5hdg== IGdyYXZl IERvb3I= CWFsZXJ0 Njkx Njk4 LnN1YnNjcmliZQ== LXByb2ZpbGU= CWJhc2U= IOKIkg== X18KCg== IGVuZ2luZWVycw== IGV4cGxvc2lvbg== IGRhcmk= Njgy CUxvZw== b25hbA== IGlzb2xhdGVk e2k= IE1zZw== RnV0dXJl IHJhY2lzdA== LXdyYXA= IFZlcnM= Ym9yZw== SVNJT04= INGA0LDQ IFlhbg== ODM2 aW5pdFdpdGg= IG5vbWlu KGVtcHR5 w61u 44Kk CXdpZHRo IGNoYW1iZXI= L2FqYXg= RU1Q MDkz IG5lY2Vz aXZvcw== bG9naWM= Kikm Y3JpcHRz OTc2 Um93QXQ= MDUz aWJsaW5ncw== IGVhcnM= IGNvbXB1dGluZw== IG1ha2Vy IE5laXRoZXI= YnJlYWRjcnVtYg== IHNlcmlhbGl6ZQ== IFdpdGhpbg== IGRlbGw= X1RSQUNF MDky PWE= IHdpc2hlcw== LWluY2g= IERvcg== IGlubm9jZW50 IERvbA== IGludGVucw== Zm9yY2Vk MDU0 IEJJVA== IHBob3RvZ3JhcGhz IGNhc2E= IExlbg== XEZyYW1ld29yaw== LlNpbXBsZQ== IGRlYXI= ODk1 KS8o aXBwaQ== IG93bnM= UGxheWVycw== IHByb3Bvc2Fscw== LnBp dXNhbGVt RGFtYWdl IGNhbG9yaWVz IENyZWF0aXZl IFsk IC8vDQo= Nzg2 QW5kVmlldw== w6htZQ== LmN1c3RvbQ== X2ZhY3Rvcnk= Y29tbWFuZHM= X2xvb2s= IHN0cmNtcA== WU4= YWlyZWQ= IGF1ZGl0 0L7RgdGC IFJldmVyc2U= cm9wcmlhdGU= ZXRpY3M= PHZlY3Rvcg== LnNlbGVuaXVt Lm9y IHByZWRpY2F0ZQ== IGZpbmlzaGluZw== IGtsZQ== IFJlcG9z IEtoYW4= IE1ha2luZw== IEZT IHB1dGU= CXN0YXRl X1NVUFBPUlQ= Jy0= b3JpZW50YXRpb24= IGV4aXN0ZWQ= YXR1cmE= IGV4cGVjdHM= IFNoYWRvdw== OTY2 IG9yZ2FuaXo= 5Z6L IHN1c3BlbnNpb24= NjY5 IHVpdA== IHNpbXVsdGFuZW91c2x5 IEFmZmVybw== OiIpOwo= IHJvY2tldA== Y2Fz ZXRlcm1pbmU= YWNldXQ= Njkz eGw= IEFNRA== KGdyYXBo NzU4 ODcy YXNzb2Np X0NS LmFyYW5nZQ== MDQ5 KGpMYWJlbA== IGJlZWY= UXVpY2s= LmNhcmQ= XSk6 LWdy Nzk3 LkdPTkU= X0NMT1NF IE5ldg== w61hcw== IHN0ZXBwZWQ= IEZyZWVkb20= IFdS TlNBcnJheQ== X3J4 X2RpYWxvZw== IGhvdGVscw== OTUz IChcPA== IERpYW1vbmQ= IGFzc3VtcHRpb24= dW1p KGl0ZW1z DQ0NCg== 5rOV IG5lbA== Qm9va3M= 5Y6/ dXNi IEZJTg== ODgx 5qw= IGNvcnBvcmF0aW9ucw== VVNB ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== OTI5 LnByb3BlcnR5 ZXdpc2U= X3Bsb3Q= Ij4nOwo= IHBlcHBlcg== OTg5 IHNoZWQ= IE1lZGl1bQ== IENvb2tpZQ== ODg5 IG92ZXJzZWFz ZWRvcg== YXN1cmVtZW50 NzY2 5a2Y ICcuJw== IHBocA== IFBST0M= IGV4Y2VwdGlvbmFs KHRo IEpldA== IG9jY3VwaWVk LnNldEltYWdl IFJlbGF0ZWQ= dWNrZXI= TWVtYmVycw== UFJJTlQ= IEdsbw== X1ZJRVc= fSIsCg== IGFkb3B0aW9u W10pCg== ODQy IE1pc3NvdXJp IExpbmNvbG4= ZXJhbGQ= UG9wdXA= IGZhdGU= LWJvb3RzdHJhcA== ZmVjdGlvbnM= IFBvbGw= X0FSR1M= aW5hbmNl Njk3 LWhvbWU= Liks X2RvbmU= Njk0 OgoKCg== IGRpc2N1c3Npbmc= IFNRTEV4Y2VwdGlvbg== IGVsZWN0cm8= CXJlcQ== IHp3 ODg2 IGx1aQ== OTMy IG92ZXJuaWdodA== JHVzZXI= IFdBWQ== IGFsbGVyZw== IGRpc2FwcG9pbnRlZA== IHJhZGlhdGlvbg== IGltcHJlc3NlZA== aWZpY2F0ZXM= IHRvYg== Q0xBU1M= IGN1ZGE= X2RldA== LXBvc3Q= dWx1 VHJhbnNsYXRpb24= LWhhbmQ= LnllYXI= IE1vbmdv IHVuY2xlYXI= LmVuZ2luZQ== V0VCUEFDSw== cmljZXM= X0FDQ0VTUw== IGhvbGlkYXlz cGVyY2VudA== LklkZW50aXR5 IEdvdg== IHBhc3Npb25hdGU= ISEu IEdyZWVjZQ== cGx1c3BsdXM= JykpOw== R1A= IGV4Y2l0 LnRhYlBhZ2U= X2NvbmQ= IHNwb25zb3I= TU9EVUxF X3Byb2M= ICQK IHJhdGlvbmFs LlRvb2w= IGlocg== Y2Nh 5ZOB IEVzdGF0ZQ== SUJVVEU= QWN0aW9uUGVyZm9ybWVk IFNvbGFy poI= IGVxdWl0eQ== dGlk OTM4 IHJlY2lw LnNpbXBsZQ== bWs= Njg5 IEx1a2U= IEd1YXJkaWFu IGVuY3J5cHRlZA== IGRvbWluYW50 LnBsYWNl IE5W ODM5 IHRvbmd1ZQ== KEdldA== IHN0YWlubGVzcw== LlBsYXk= IGVi YWNp LmJ1ZmZlcg== cmVhZGNydW1icw== IHZhY2NpbmU= cHJvbQ== OTc5 IHVzZXJJbmZv IHNsdWc= U2VyaWFsaXplZE5hbWU= LXdpZGU= IHJlYWN0aW9ucw== IFlhbmc= IEFkZHM= KHVzZXJJZA== IHBsYXRlcw== IE1FTQ== IGJhaWw= SW5zaWRl ZXRlZA== IGVsc2lm IHNha2U= IGN5Y2xlcw== IOyX CUk= LWNvbGxhcHNl ODQx IEdNVA== ODE0 RGVjbGFyYXRpb24= IGdyb3M= IHJlYWNoZXM= IGN1c3RvZHk= VW50aWw= NzUz ODU2 dHU= IENoZW4= IG54 KGFkZHI= IE9mZmVy IGNvbGxlZw== YXNzYWRvcg== Njc0 IG1hcHBlcg== ODU0 IFNJR05BTA== IEJsb29t IEhvbGw= IEltcGVy LWRlcw== X3NpdGU= UHJvYw== RXF1 IGF0b21pYw== IFdvbWFu c2VudA== NzM4 ODE3 c2Nhcg== IGludGVsbGlnZW50 IEdldHRpbmc= IFJlZ2lzdHJhdGlvbg== IFBoaWxs IGtpbGxlcg== dW5pY29kZQ== CgkJCg== IEphY29i IENvbnN0 IGxvY2F0ZQ== IGNhdXM= NzQ5 IFNjaG9sYXI= IGNvbnN0aXR1dGlvbmFs IGluZmxhdGlvbg== IEdvdA== PWFycmF5 ZW5kdW0= IHRyYW5zbGF0ZWQ= IGRpdm9yY2U= RW50cmllcw== IHNvcg== IFF1b3Rl aXJsaW5lcw== VUs= IGV4Y2Vs KG9wdA== IEFEVg== LDos IGNvbnRhY3RlZA== NzQy IERB IHJpbmdz IEluZHVzdHJpYWw= LmdldENvbnRleHQ= IGZvcmdvdHRlbg== IFRhbg== IHBhbnRz IG92 IGRlY29kZXI= IFBhcnRpYWw= IHZj IGJhdHRsZXM= QXJpYWw= RlJJTkdFTUVOVA== aXJhdGVz LHc= YWludGVuYW5jZQ== IE9k IFRlY2hub2xvZ2llcw== 5YmN IENhcnRlcg== LmZpbmRBbGw= Tm9tZQ== QmVu IFVzYWdl IFBpY3R1cmU= IGJhZGx5 X3BhbmVs IHBhdGVudA== IFByb3RvY29s bG90dGU= CXBsYXllcg== amVjdGlvbnM= NzQ2 IGRvdQ== X3JlbGVhc2U= dXJuaXR1cmU= X3RheA== IEZpZWxkcw== LmRhdGFzZXQ= X21hc3Rlcg== Q0xVREU= IFBoYXJt YnN0 IG9wZXJhdGlvbmFs LmNlbGw= IGlkZW50aWZ5aW5n IGp3dA== dHVwbGU= IFRD IENybw== OTM2 aXhtYXA= LWNvbXBvbmVudHM= Z2VuZXJhbA== IG96 X0Rl X2RvdWJsZQ== IFRvbw== MDg4 LlZpZXdHcm91cA== ODc5 Z2F0ZQ== ZGluZ3M= cGhvdG9z IGdyYW5kZQ== b2xsZWN0 X2xpbg== IGF3ZnVs ZmlsdGVycw== IGFsdGVybmF0ZQ== ZXNw IGNvbXByZXNz ZW8= IFNjYWxl IGluZGlyZWN0 IGludm9pY2U= CgoKCgoKCgoKCgoKCgoKCg== U3RhcnRpbmc= IFBsYXllcnM= aWVsZQ== LnRoZW4= OTgx T3Jk IFR1cGxl IGJvdXQ= IFN0YXRpc3RpY3M= UHJldmlldw== IHB1enpsZQ== IFdpZHRo U1RBVEU= IG92ZXJsYXk= CW9u IGluZnI= IHNtYWxsZXN0 bG9ja2Vk 0YLQvg== c3Ns Nzc5 IGRlZW1lZA== IHNjbw== cmVjaw== IGpCdXR0b24= IG1pc3Npb25z ODcx 56ew LlNlbGVjdGVkSW5kZXg= VEFCTEU= U2VwdA== IGFja25vd2xlZGdl IHN0cnRvdGltZQ== IFRlbGw= IERhaw== IGFsdW1pbnVt IGZlbmNl IFN0YXJz Q09ORklH IHJldHJvZml0 IGVtcGhhc2lz L2hlYWRlcg== IFNvbWV0aGluZw== aW5pc2hlZA== PSciLiQ= IFZhbGlkYXRvcnM= IHBvbGFy c2VjdGlvbnM= OTQ0 LmFzcHg= IGFzcGly Lk1vY2s= Q29kZUdlbg== IHBldXQ= OTcx IGFjY2VwdGluZw== IGJhY2tpbmc= UGljdHVyZQ== L2Fw 0LXQsw== X1NFQw== LXVzZQ== YW5ub3RhdGlvbg== IGNvZ25pdGl2ZQ== IGdyaXA= aG91cg== IExlZ2Fs IGVwaWM= LnRvb2xTdHJpcA== Lm5vdGlmeQ== Lkxhc3Q= T1JJWg== TWlkZGxld2FyZQ== Y3JpcHRpb25z bGFzaA== X0ZPVU5E IExpdmVycG9vbA== IHt9Iiw= OTMx SW5zdGFsbA== IG5pdA== IGZpZ3VyZWQ= W2xlbg== Lldpbg== LnBsYXRmb3Jt ODUz IGdhbWJsaW5n KGR0 YXZlcnk= CWluY2x1ZGU= V2hldGhlcg== Um91dGluZw== IHRoZXJhcA== UmVtb3Rl IExvc3M= eWxs IGFwcHJvYWNoZWQ= IFZlaGljbGU= IEFscGhh IHZvY8Oq YW5zd2Vycw== TlNEaWN0aW9uYXJ5 OTU0 Y29uc2lkZXI= dW51c2Vk IEZhbg== b3JhYmxl ZnJl ODcz IERJU0NMQUlN IEFjdG9y Ll0= dG9IYXZl LnVzZXJJZA== IHNwZWVkcw== ZXdheQ== IHJlY3Vycw== INCz X3ByaXY= IeKAnQoK Q2hvaWNl IHNldHRsZQ== IHBsYW5lcw== J30s VG9t SVRFUg== ISIK 5bs= YWNoZWxvcg== IHNlcGFyYXRpb24= IGRhbA== YWRq IHJlZ2lzdGVycw== cml6 IE5vdGljZQ== IGx1 IGNvdXJhZ2U= IGF4ZXM= Y2VsbGVudA== LmFzeW5j MDcz IGNvbXBhdGliaWxpdHk= 56s= ICEKCg== CXRpdGxl WUxF CW1lc3NhZ2U= VVVJRA== T0xERVI= IEhI IFN0eWxlU2hlZXQ= IGFjY2Vzc2Vk LnZhbGlkYXRpb24= dGFza3M= IHBvbGx1dGlvbg== LmNhbnZhcw== IGluZ3JlZGllbnQ= IENhYmlu QWg= b2xkb3du IE5PSQ== IMOX W2Y= ZWR1Yw== eWFsdHk= KG5vdA== X1N0YXRl OTMz YW1lbg== Nzk1 NzM5 IGRhbw== dWRhZA== ZWxsZXJz fSY= bGljaXR5 X1dJTkRPVw== IHRhdHRv dmFsb3I= LlJhbmdl IHJlZmVyZW5jZWQ= IFJlc2VydmU= TW9uZXk= ODc0 U0NSSVBU L3Byb2R1Y3Q= Y2hvaWNlcw== IHRpbg== 44KT OTE4 IHNlcGFyYXRvcg== IHBrZw== YW1tZWQ= IE1BVA== ISEKCg== IHJhaWQ= IG1vdGl2YXRpb24= IFhQ IEJhY2tncm91bmQ= IFF1YXRlcm5pb24= LmRlZmluZVByb3BlcnR5 aWtlcg== CXBhcmVudA== IE9yaWdpbmFsbHk= YW50YWdl IEhhbnM= IHRpbWVsaW5l LmN1cg== b3BpYw== IFNlcXU= bXVzdA== IENvYWw= IGZvcm1hdHRlcg== X1JHQg== IF8oIg== J30pLAo= ID09PT09PT09PT09PT09PT09 IEZVTkNUSU9O IGxuZw== aWNhdGVz bGl2ZQ== X2VuZ2luZQ== IHRvd25z ODY4 JykpCgo= IFBL KGFwaQ== CXNjYW5m MDg5 cGFja2V0 LnBob25l 4YA= IEFuZHk= X05BTUVT OTgy UExZ OTU1 IG1pbnM= aW1p IGJyaWNr IGJsYWRl LnN0ZG91dA== fWA7Cg== U2hpZnQ= CXNi IENoZWNrcw== IHBoZW5vbWVub24= QXZhdGFy IG1pbmlzdHJ5 cm9zZQ== CUZpbGU= ODc4 IHRpdGxlZA== KExPRw== IGdhbg== ZGVzaWdu KCksDQo= IGJvbmVz c3Rt xZvEhw== IElucHV0U3RyZWFt IHZvbHVudA== IFNlcmlhbGl6YWJsZQ== IGZpZ2h0ZXI= IERyYWc= VHdpdHRlcg== IHN1YnNpZA== 57w= IGZvcnVtcw== LmxvYWRpbmc= bG9nZ2Vk X3RoaXM= IHRlcnJhaW4= IGlycmU= IEluZw== IENO X29iamVjdHM= LnVpZA== IGNvbnNjaW91c25lc3M= VElOR1M= IEdhbGw= IHBvcnRyYXk= MDU2 IERldmVsb3Blcg== IHBhcnRpY2lwYW50 ICI7DQo= L21vZGVs Nzk0 IE9wZXJhdGlvbnM= Xlw= IExhdGVy IHJhaXNlcw== LW5vbmU= Lm1ldGE= PScuJA== RmluaXNoZWQ= IHJlcGxhY2luZw== IHNhbXBsaW5n IEplbg== IlRoZXJl UkVBTA== QUxF 7Iqk T3JkZXJz X3BhcmFtZXRlcg== IE9seW1waWM= IHRyw6hz IGFyZW5h aW9s Oz8+ IGltcGFjdHM= IFdT OmdldA== IGZsaWdodHM= IFJ1c3NlbGw= Y2FtZXJh Rm4= c2lnbWE= IGZvcmNpbmc= IGxvY2Fscw== IGRlcGFydHVyZQ== IGNlbGVicmF0aW9u IFNheQ== ODg0 77yS IEhpbGxz Lmhhc093blByb3BlcnR5 IHR5cGluZ3M= LkFQSQ== IGRvbmF0aW9u T3BlcmF0aW9uRXhjZXB0aW9u LkFjdGl2aXR5 Y3BsdXNwbHVz IENoYXJsaWU= IGltcG9ydGVk IGRhbm4= IG9jY2FzaW9ucw== IGltcGxlbWVudGluZw== IHB1cnBsZQ== LmRpYWxvZw== U1FMRXhjZXB0aW9u ZXJubw== IHdhcnM= IHBhc3Rl IGRlY3JlYXNlZA== IGhhcnNo IGVsYWJvcg== aW5wdXRz IFZpZXdz IGVycm9yTWVzc2FnZQ== X211bA== CXdyaXRl IENvcA== IEFubnVhbA== KGJ1dHRvbg== IHZpZGE= YmFycw== IEhhcnZhcmQ= CWV4cGVjdA== IGluZGV4ZXM= IGRvY3VtZW50YXJ5 IGZsZXNo T1JMRA== IERlbHRh TUFORA== QnJ1c2g= LWNvbHVtbg== IGRldmVsb3BtZW50cw== OTc0 Nzgz bWV0aG9kVmlzaXRvcg== c2xpY2U= IFBETw== IGludmVzdGluZw== ODY3 aXJhYmxl IHhtbG5z 77yb YXJ0YQ== IHRoZW9yaWVz X2NpdHk= ICRfXw== Q3JlYXRpbmc= KHBy RHJvcGRvd24= aXNtYXRjaA== IE5FVA== OTI2 J10pKXsK IFZhbHVlcw== IFNFTw== IFNUQVQ= IGVjb3N5c3RlbQ== IHRlbXB0 IFxc IC8vewo= IENocmlzdG9waGVy IEtlbnR1Y2t5 IEh0dHBTZXJ2bGV0UmVzcG9uc2U= IGh5YnJpZA== eW9u IGZlZWRpbmc= IEV4dHJh Tm9ybQ== SVRDSA== IFNlYW4= IFVwbG9hZA== bXVu cHVy IHBlcnNpc3RlbnQ= IElEQw== IFBlcmZvcm0= ODYz Lm1lcmdl X3Jvb20= TWVhbndoaWxl IT0n IFdlbA== QXJnc0NvbnN0cnVjdG9y ODg3 LkRhdGFiYXNl IGNvdW50aW5n KCkq lOWbng== IFRPUA== bWlsbA== IERU SUdORUQ= OTU2 IEtC IGNvbXBseQ== U291dGg= X2NvbGxlY3Rpb24= Q2hhcHRlcg== IGV4cGxhaW5pbmc= X0FN X3Rz Y2FyZHM= IHF1ZWw= IHBvbGU= IHRvdWNoZG93bg== IE90aGVycw== IHBlZXJz IFR5cGVFcnJvcg== NzYz IHNpeHRo IGNoZWVy IGRpc3B1dGU= OTYz ODkz dXNj KV0s dGh1bWI= IGhpZGluZw== IFNJRw== bGlrZXM= IFBBR0U= LlJlZmxlY3Rpb24= IGhlYWRxdWFydGVycw== VElORw== IEdob3N0 TUxF JAo= IGNvbnRyYXJ5 ZXh0ZW5k J10pLg== RkZFQ1Q= IFBpbnRlcmVzdA== w7ptZXJv cmljYW5l CXNlc3Npb24= IGNyeXN0YWw= LUNvbnRyb2w= b3Zlcm5tZW50 b2dyYWY= OTYx LWFjdGlvbg== dm9sdW1l ZnRlbg== IHVuY29u IGFuaW1hdGU= IGxlYXNl c2Ny IHJlZnVzZQ== 44CL ZnRw aW5mb3JtYXRpb24= IGV2YWx1YXRlZA== IGluamVjdGlvbg== IGphY2s= IHdvcmtzaG9w 5rOo UFRI IFRz b2ZmZXI= CW9z IGtpbmdkb20= TWlzc2luZw== IGxhd21ha2Vycw== ZXh0RmllbGQ= IHNpbmdpbmc= YWJp L2NsaWVudA== Lm1lZGlh QVRFR09SWQ== U2lnbmF0dXJl JScsCg== IEZ1Y2s= XVs6 IHNlbnNvcnM= L2NvbQ== IFByaW1hcnk= LlNRTA== X3Byb2dyYW0= IHBpbGxz IGludGVncmFs IGZsZWV0 IGRyb3BwaW5n LnNs QmVlbg== IHBldHM= IGFkdmlzZWQ= IGRyYWdvbg== X0VESVQ= KGlt OTM5 RkVS IERydWc= KHJhbmRvbQ== IGNvbXByZXNzaW9u b3VzdA== WyU= IGJ1eWVy aG9w Um9sZXM= bWFuYWdl IHBhaW5mdWw= IEJyYW5jaA== LW1vZGFs ZW5hbnQ= IE1lc2g= L2ZvbnQ= IEdyYWhhbQ== IOKY IG5j IEZyYW5jaXM= IHNwZWNpZmljYXRpb24= IGRhbWFnZXM= LWNvbmZpZw== IHRoZW9yZXQ= c2VjdXJl X211bHRp YWNldXRpY2Fs IGRlbWFuZGluZw== ZW5uZQ== SVNUUw== MDk0 KCkpKTsKCg== UmVhc29u UmVjZW50 cGhhc2U= IHBzeQ== X01BTg== IHZvbHVudGVlcg== 5b8= aXN0cmlidXRlZA== bGlv IHByb2R1Y3Rpdml0eQ== X2NvbW0= U3ByaW5n bmlz LndlaWdodA== IENhbmNlcg== QWxsb2M= IFR3ZWV0 IHNlcGFyYXRlbHk= CWNoZWNr X3Byb3BlcnRpZXM= LlVuaXQ= ODI5 X0NMSw== IGd0 ICgpOwoK IGhhbmR5 ODM0 IFRob21wc29u IHVubmVjZXNzYXJ5 IFJlYWRlcg== ODk0 R04= PXJlcXVlc3Q= IFV0aWxpdHk= LlJlcG9zaXRvcnk= IEF4 aHlkcg== Nzkx aWV1 IHRoeQ== IGx0 X21haWw= 5L+u5pS5 YWlsYW5k IFBoaWxpcA== IGJpdHRlcg== IGJldHRpbmc= ODM3 IHRpbWVk b2Nrcw== MDc2 J2E= IGFsZ29yaXRobXM= IHJlaW50ZXJwcmV0 IHRvc3M= cm9nZW4= IGhvcGVk KHNlbGVjdGVk IHZlbnR1cmU= VEVY IExlYXZl LlN1YnN0cmluZw== IGdyYXRlZnVs NzQz dWth IENvbnN1bWVy IGFnZ3JlZw== Q2lyY2xl 4LiB X2Jsb2Nrcw== IGxlZ2FsbHk= ICJ8 44OD LmJvYXJk LkFi RnVuY3Rpb25z cmVjaXBl 6Ic= IE94Zm9yZA== IHdob2xlcw== LkJ1aWxk X2NoYW5nZWQ= aGFp IGRlcGFydG1lbnRz OTY0 SW1w IGNvYWxpdGlvbg== SU5GUklOR0VNRU5U IGVtcG93ZXI= aXRjaGVz Tm9ydGg= IGluZmxhbW0= T05TRQ== IG1pc3NpbGU= IFJhag== IElzc3Vl IGF0b2k= Y2FsZWQ= LkNvbnRyb2xsZXJz IFdvbGY= IGNydXNoZXJz 4buH LkF1dGg= LmFkZEF0dHJpYnV0ZQ== aGlz IGJvb3Rz LmNsZWFu Y2FtcA== IHRlbmFudA== IHR1bmU= IHt9Jy4= IHdvcmtvdXQ= UmVwbw== IHBhcnRpYWxseQ== TUlTU0lPTg== amFtaW4= IFNC IGRldGVybWluYXRpb24= ICcnKTsK IEJlbmc= IHZvcw== IGluaGFi L2xhbmc= c2J1cmdo RXhlY3V0b3I= aG9uZQ== IENoYWxsZW5nZQ== X2xpbmtz LkxldmVs IHVuZGVyZ3JvdW5k LWNvZGU= OTU5 IG9wdGltaXphdGlvbg== bG9nZ2luZw== X2Rlc3Q= IHNuYWtl IGNoZW1pY2Fscw== X0lNUE9SVEVE YWRvb3A= IFRIQVQ= bWFuYWdlZA== IHJlZHVjZXM= IFJFQUw= IEd1eQ== X0dFTkVSSUM= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq LmFtb3VudA== IGRlcmU= Z2V0VGltZQ== IHBhbnQ= YW5vbnltb3Vz IGhhcm1vbnk= IEFsYW4= IHNjZW5hcmlvcw== IGRpcnQ= aHRhZ3M= TWM= U2hlbGw= cmlu ew0KDQo= LnBvdw== CWNsaWVudA== IGNvbnNwaXJhY3k= IGFkbWlzc2lvbg== IFJlZ2lvbmFs IFZpZXdDb250cm9sbGVy IFBoaWxpcHBpbmVz IGRlcG9z IHBhcA== OTYy IFBhZA== UGF1bA== LkNvbWJvQm94 IHR1dG9y IFJlY2lwZQ== d3JpdGluZw== IGNvbnRyaWJ1dG9y T1RI U21hbGw= Vkk= IGhhY2Vy ZXF1 IEV4YW1wbGVz aHVtYW4= Lm1lc3NhZ2Vz CXR5cA== ICgNCg== IFNTTA== TEVO IFJvbW5leQ== KGdyaWQ= CW1pbg== ID4KCg== IGZydWl0cw== IHZvdGVy SW5saW5l cGFuZQ== IENvbGxlY3Rpb25z Y2hhcnNldA== IHNwYW0= emI= aXRlbWFw IHN1Y2NlZWRlZA== X0NPTA== IGVsYXBzZWQ= aW1ldGVy IHJlY292ZXJlZA== VGVuc29y aGF0dGFu LnNldHVw aXN0bw== KGhlYWQ= OTc3 IFNJWkU= IHRhY3RpY3M= IGRpc3R1cg== IHByZXZhbA== aWNpb3M= KFZhbHVl X2NvbHM= IEZhdA== IHNlYWw= IHNvbnM= IGVuc3VyZXM= MDk1 IHByZXNzaW5n PSY= aWdlbm91cw== IGhhcmFzc21lbnQ= X0pTT04= IGlnbm9y eW5vbWlhbA== b21lcg== X3N0YXRpYw== IHNpZ25pZmljYW5jZQ== IGNpcmNsZXM= X1N5c3RlbQ== IGRpc2NpcGxpbmU= IGRyZXNzZWQ= IHNwaGVyZQ== OTI3 IGNsaW1i NzU5 X2FjdGlvbnM= IEJhYg== ICc9Jyw= X3NjaGVtYQ== InVzZQ== IHVuZGVycw== IGN1cHM= LnNjcmVlbg== L25ldw== IGFwcGVhcmluZw== VE9Q dmlzZWQ= Y2xhbmc= IGludmVzdGlnYXRvcnM= IG15c3RlcmlvdXM= IHByb21pc2luZw== IHF1YWxpZnk= IGNhdmU= IGVxdWlw PXg= R1Q= KGxpbms= LnZlbG9jaXR5 LmVyYXNl b3Rlcg== KysrKysrKys= cHJvZml0 IHpvbmVz X3VpZA== LXNlcg== IG9iamVjdGl2ZXM= IG1pbGY= d2Via2l0 KG1hdGNo bmVo IEFzc29jaWF0ZWQ= IFRvZG8= PWQ= MDY1 Q2Ft IHZvY2Fs IHN1ZG8= KEVY IHRyb3U= QUJD LmJlYW4= IEdyb3VuZA== IFJFU1Q= d2VldHM= SW5n aW1vbg== OTQ2 X2J1cw== IENPTE9S dW50bw== IGZvc3M= IExpbmtz ODY5 w6RuZw== L2Zvcm1z cHJpc2Vz IGFjaGlldmVtZW50 Q0FMTA== 0LXQu9GM IFZlcmlmeQ== X1NPVVJDRQ== YXB0Y2hh SURE X3JlZmVyZW5jZQ== R29sZA== ICAgICAgICAgICAgICAgICAgICAgICAgICAgIAo= OTQ3 UmVjZWl2ZXI= MDk5 IGFq X2RpcmVjdGlvbg== fV0= IENvbXBldA== IGJhbmc= Nzk4 IENhc3M= LXVybA== dGVjaG4= IEplcnVzYWxlbQ== bG9uZ2l0dWRl Jyk7DQoNCg== IHdpbm5lcnM= VGFza3M= IERNQQ== IHRvb2x0aXA= jrc= IEJyYQ== X2R1cmF0aW9u Y3VyeQ== cGFyZW50cw== LS0tLTwv IHBhc3Nwb3J0 ODQ5 V0M= INC7 Y2Vzc2lvbg== IFllbGxvdw== IGVuY3J5cHRpb24= JwoKCg== IGxpc3Rpbmdz IENvbW11bmljYXRpb25z Ll8K ICIiIg0K IGZi IHN0cmljdGx5 IExpdGVy IEVudGVycHJpc2U= X2JvdHRvbQ== QUtF a2V0 IHRhbQ== QmV0d2Vlbg== X1RPUA== RGlzYWJsZQ== IGZpbGluZw== IENocm9u U0VRVQ== ICZfX18= ODQ2 IGZhbA== IFNMT1Q= RW1iZWQ= dXRoZXI= IFJlc3RhdXJhbnQ= IHJlYWxpc3RpYw== IScpOwo= IERFQUw= IFBlcmlvZA== LmdldFg= IHNlaHI= Il0nKS4= OTQz ZXNzYQ== CW1lbWNweQ== IGFja25vd2xlZGdlZA== c2VuYWw= IFVuaXZlcnNhbA== ICcnOwoK L3dpa2k= aWVubmU= IE5TQXJyYXk= IGFjY2VwdGFuY2U= IGxpdmVy IHRvb3Ro IGFjY3Vz CUxPRw== dmFsdQ== 5YC8 IHNlY3RvcnM= cGVyaW1lbnRhbA== L2NsYXNz X2dv TWljaGFlbA== b2xhdGlsZQ== IFBST0Y= IGNvbXByb20= c3BlY2lhbGNoYXJz IOKc IGlzRXF1YWxUb1N0cmluZw== IEh1bmc= LmFzTGlzdA== L2dv Pj4o IEtpcg== IGludHJvcw== IHNrZXRjaA== IHNraWxsZWQ= IGltbWVy IGFkZXF1YXRl X3JlcA== KGhlYWRlcg== X2xpa2U= IHBlcmNlaXZlZA== c3No IGFzc3VtaW5n IGZm X3V1aWQ= dWxhcw== IGRlbW9jcmF0aWM= LmVudGl0aWVz U2VyaWVz YXBob3Jl IG5ld2Vy fSg= U0VD YWlybw== IGNvbW1vZA== IHByaXZpbGVnZQ== IGRldXg= IEhvcA== Licv Y3RpYw== Lic7Cg== PD89 IFVU ZXRpZXM= X0NPTlRFTlQ= LnJlbGVhc2U= LmRpc21pc3M= IGZj b3VuZ2U= cHdk X3ByZXY= TWdy IEJ1ZmZlcmVkUmVhZGVy d3JpdHRlbg== IEVi ICkKCgo= dWl0bw== IGNvbnRyb3ZlcnN5 IGRpc3Bvc2Vk IGZvdG8= TGlzdFZpZXc= L2NyZWF0ZQ== IENPTA== Y29tbXVuaWM= MDY4 IGZyZWVseQ== dW5hbA== b3ZpZA== CXRy cGFnaW5hdGlvbg== IENvbW1vbnM= RWxlbQ== IFJFTQ== IGNvcnJlbGF0aW9u KCkrIg== IEhpZGU= YW5kaW5n KHZlYw== aXRvcw== IEN1bHQ= IG51dHJpdGlvbg== dmFscw== IGRldGVybWluaW5n bG9yZA== IHNjYW5kYWw= IHNoYWxsb3c= b2Rhc2g= X3NlcmlhbA== IFNsbw== IGRpc3Bvbg== UGxvdA== aWNrbGU= IGVsbA== IHVuZW1wbG95bWVudA== Rk0= cm9ucw== bMSx TW8= RXhpc3Q= SURT Q2hv IEtleWJvYXJk LnBhcnNlcg== LkdldE9iamVjdA== IHNwZWxscw== IGdlc2No IG1hZ25pdHVkZQ== X1NM aXNkaWN0aW9u ICcpOwo= aWxpYW5z IHNoYXI= IFByb2I= dWlsdGlu IHR1bm5lbA== PkM= IFdhcnJlbg== IG9wdGltaXplcg== IFNFUlZJQ0VT X29wZXI= Z2V0QXR0cmlidXRl IE1jSw== X3NlbGY= MDg0 LnJz IikKCgo= R2V0Q29tcG9uZW50 ZXJjZQ== IHRvdXM= dW5pdHM= J10pOw0K Wm9vbQ== L0U= IG9ic2M= IGZhc3Rlc3Q= b25saW5l IHBlYWNlZnVs ZmZlbg== IGNhcmdv CXBy IHNlZWtz enU= MDc0 VHJpbQ== IHdhcmQ= IHZlcmQ= IGJsb2dz LmV4Y2VwdGlvbnM= IFByZW1pdW0= IE5ldGhlcmxhbmRz U2FmZQ== RmluaXNo IEFsYnVt X0FDQw== PXRoaXM= dmlydHVhbA== XT4= X0xBQkVM IE5pY2g= X3dpbg== IEFhcm9u V1A= OyQ= YWltcw== IEltYWdlVmlldw== IGVuZGxlc3M= RVJB X0RJU0FCTEU= IGNhbmNlbGxlZA== LXVz IGluc3BlY3Rpb24= ZW1pbg== IEdyZXk= LW9wZW4= IGl0ZXJhdGlvbnM= Lm93bmVy IGtlcmFz LlBhc3N3b3Jk IFJ5 IElOUw== QWly IFNldmVyYWw= LlRhYlN0b3A= SU5HTEU= IEhhaXI= IENhbnZhcw== QUFBQQ== IGZsYXc= Y2VkZXM= LlJlcG9ydA== 7Yo= IFRpcHM= Y3JpcHRvcnM= LnRyYW5zYWN0aW9u LlNwcmluZw== IHZpZXdlcg== IGluc2lnaHRz 6L6T b3JkaW9u VUlOVA== c2Vlaw== IEF1Zg== 7J6Q IHN0cmFpbg== VG9vbHRpcA== IGR6 aWduYWw= YWR0 IHVj ZmluaXRl IG5t LmNtZA== IE15U3Fs W2RhdGE= LmphY2tzb24= LnRyZWU= UmVxdWVzdFBhcmFt X2FnZW50 IildDQo= IGFzc2Fzcw== KENvbnN0YW50cw== OnNz IE1BTg== Ky0rLQ== IEJvdHRvbQ== cHJpbnRz IFNhbWU= QEF1dG93aXJlZA== c3dhcA== aWNpw7Nu IHByb3Rlc3RlcnM= IGhvbmV5 IFZldGVy KENhbGVuZGFy LWFk IEJyb29rbHlu TGlmZQ== X1ZBUg== emVjaA== IENBTEw= X0NBU1Q= IEVsZWN0aW9u IHRoaWNrbmVzcw== VmVyeQ== X0lOVEVHRVI= LWRldg== KSkpKQ== YXBhdA== b29vbw== ZGVtbw== IHBhcnNlRmxvYXQ= IFJhdGhlcg== U1RJVA== bWFrZXI= W2N1cnJlbnQ= Y2hyb25v IGNocmlzdA== 44Gq IERldGFpbA== xrDhuw== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IHN1bA== aWRlbmN5 UXVl IGVsZWdhbnQ= YXBvbnM= IGRpc2hlcw== IGludGVnZXJz KHJlYWQ= MDU3 ZmluZFZpZXdCeUlk IEFtb3VudA== IFNraXA= IGhhYml0cw== Kiko IG1vbnN0ZXJz TUFD OmVuZA== IGZyYW5r QXNzZW1ibHk= IGRmcw== IG5ldXQ= X1RZUEVT ZXF1YWw= bG95ZA== KHVyaQ== IGNoaQ== IGRlZmVuZGFudA== IGNvbmZsaWN0cw== IHZpbA== LWpz IFBlYWNl IG11dGFibGU= KXNlbmRlcg== IEZvY3Vz 5bu6 IGFwcHJlY2lhdGVk c2xlZXA= IFJFRA== Q3VsdHVyZQ== IGRlc2lnbmVycw== X2dlbmVyYXRvcg== Y29kZXM= L2V4 LkdldFZhbHVl dW1ibGVk LnNjYWxhanM= cGVyb3I= IHZldGVyYW5z IH0pDQo= IHVuZm9ydHVuYXRlbHk= X0NSRUFURQ== TWFzcw== IENMQUlN IE1lZXQ= X3N1cHBvcnQ= QmFuaw== KCkuCg== RGFyaw== X0xPVw== IE1pbmluZw== IE93bmVy aWVyYQ== Q2xpZW50ZQ== IGVuY291cmFnaW5n PlM= IGJveWZyaWVuZA== IEhhbGY= IEFDQw== QWZm X2Fy LWxpZmU= Y3g= LkpCdXR0b24= aXphZG8= Lnplcm8= Lm9wZW5xYQ== b3Rvbg== LnRleHRDb250ZW50 IHRvbGw= YXRpZQ== IGJhbGxvdA== LW51bWJlcg== LkV4Y2VwdGlvbg== CXBhcmFtcw== Y2lyY2xl LW1hcA== IG5hcA== IFJvYm90 IEljaA== cmVnaXN0cmF0aW9u QW1hem9u cm9sbG1lbnQ= KGV4cA== IHRhbmtz IEdvcmRvbg== IG1hY2hpbmVyeQ== IGJhc2VsaW5l 5os= MDg2 2Kk= IENvbnZlbnRpb24= CWNvbmZpZw== b29raWVz bXVsdA== UmVjb3Jkcw== IEVTVA== IGdhcmJhZ2U= IGNvbmZvcm0= aWRhbA== IGJhcmc= IHN1cnZpdmVk IGludmVzdGlnYXRpb25z OTM1 LmNvbnRhaW5zS2V5 LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0K b3J0aW9u IGhvcnI= X2h0dHA= IG1hbnQ= XTsNCg0K YmluYXJ5 OTQ4 ZW1wbA== IGlucXVpcnk= IE1lYW53aGlsZQ== MDk4 IGNvbGxlY3Rpbmc= LkVudGl0eUZyYW1ld29yaw== IiwKCg== IFBpYw== QEluamVjdA== aWNrbmVzcw== IEJpbmRpbmc= IGNvbnRyb2xsaW5n cmV2ZXJzZQ== IGNoYWlycw== c2VtYmxlZA== KGFkZA== RGlzYWJsZWQ= YW5hcw== LnRyYW5zbGF0ZQ== LS0tLS0tLS0tLS0K IHJlZmxlY3RlZA== Il0KCg== RXh0ZXJuYWw= QXJyb3c= U2luZ2xldG9u JXg= IMU= IGFuY2VzdA== IE9ybGVhbnM= CWNtZA== IHByb2hpYml0ZWQ= aXRobWV0aWM= KGNoYW5uZWw= X2Nzcw== Rm9yd2FyZA== LnNvY2tldA== IGx1Yw== 4oY= IEZpcmVmb3g= IE1vdmllcw== KV8= LmVuZHM= KHNoYXBl IGRlYWx0 IHNhdmVz IGdsb3J5 IG1lam9y IGJyZWF0aGluZw== IGVsbGVy Z2V0RGF0YQ== IGFuZ2xlcw== IHRvb2xiYXI= IHNwYWNpbmc= MDU5 SVBT IGZsb29ycw== X0FDVElWRQ== IHNodWZmbGU= L3NoYXJlZA== IEVsZQ== ZWRpc2g= IHdlYmNhbQ== LmV4cGVjdA== aWxvYw== IEluY2x1ZGVz IHR3ZWV0ZWQ= IDop IEVzc2F5 Rml4 LWJldHdlZW4= X3dlYg== LmNvbnY= IHJhY2lzbQ== IHJlZmxlY3Rz dW1t 0LjRgtC1 X2Zvb3Rlcg== L2RvY3M= IFBvdXI= TmdNb2R1bGU= LmluaXRpYWxpemU= cGF0dGVybnM= X0lu IEFiYg== Kg0K IHNlbnRpbWVudA== YnVmZg== X2NvdW50cw== IHJldXNl Y2h1bms= IGltcG9zZWQ= UHJpbWFyeUtleQ== Rm9yZWdyb3VuZA== IGNvbnN1bWVk PyE= IGRpY2s= IGNocm9u IEZlcm4= IHJlc3BvbnNpdmU= OTU4 IGluc2VjdA== aWN1bHR5 IHJ3 IGFsaWtl IHN1YnNldA== IENvb2tpZXM= IFBhaXI= IHRpZXI= SUZP YXZvdXI= IFFV LHNpemVvZg== IG1lcmdlZA== bXY= aXRvbA== eWxvbg== IGp1bXBlZA== LnJvbGU= ZW5zYWpl UnVsZXM= IGJyb3dzZQ== QW5pbWF0b3I= IHlvZ2E= IHZhcmlhbnRz IGNvdXJ0ZXN5 dXJhbg== cGJz ZWxzZWlm QWx0 IExhbmU= Q0xL SU1BUlk= X1BST1BFUlRZ 77yQ IGNoYW4= IGdyYWR1YWxseQ== IHNoYWtl IGJsb25kZQ== Li4uIik7Cg== LXNleA== IGdhbWVwbGF5 YWNpZXM= LnJlZnJlc2g= VVNC IFBsb3Q= V2Fz aXNzaXBwaQ== IFRlbnNvcg== IGNyeXB0b2N1cnJlbmN5 IGRpZmZpY3VsdGllcw== RGVsZXRlZA== V2l0aG91dA== X2FwcGVuZA== X3Zlcg== OTY3 IikpDQo= IGhvbmVzdGx5 IHBpdm90 IHRlbXBz X3Bz IFVubGlrZQ== Wzot VlM= X2luZg== IGp1bmlvcg== IGFuaW1hdGlvbnM= IGZpbGVwYXRo Pzwv W1w= IG9wZXJhdGVz X3JlZA== IEJvb3RzdHJhcA== bGVhZA== ZWZmZWN0 wr0= IFN0ZXI= IEJ1Y2s= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IGRlcHV0eQ== VGhhbg== 4bq/ T05FTlQ= IEhlYXQ= ZXRoZWxlc3M= XSl7Cg== IGtvc3Rlbmxvcw== KCk7Ly8= IGRlcGxveWVk Pnt7JA== IHVuaWNvZGU= cGxhY2Vz IENvZmZlZQ== LlNF IFBBUg== KHR4dA== Z2VicmE= IGZpcmVz TWFpbldpbmRvdw== bWVkaXVt ICjigJw= IGxn IGNtcA== L2Jhc2U= X2xheWVycw== X2VudHJpZXM= IGFkbWluaXN0ZXI= IFNVQ0g= QlA= IFNjb3R0aXNo CQ0KCQ0K Z3VhcmQ= IFN0cm9uZw== SW5zbg== IENBUA== YXN1cnk= IFNFRQ== Q2xvY2s= ZXJpZQ== XG1vZGVscw== ICQk IENhYg== IHd1cmRl IHNvbGRpZXI= IGNsaXBz IGFycmFuZ2VtZW50 IFdvbmRlcg== IEhvcm4= IHNjYXJlZA== IGN1cmU= bWtkaXI= IGFsaWduZWQ= IFBpbms= IGxhbmRlZA== RGltZW5zaW9u U2Nyb2xsUGFuZQ== LmNoYXQ= LldpdGg= IFRyYWlu XS4K IHRoaXJ0eQ== IGR1cmFibGU= IGxk IGxhdGVpbml0 IGNoYXJ0cw== IGluc3VsdA== LkZhdGFs X2N0 IG1hc2tz Q0xVREVE UHJlc2lkZW50 IGNvbG91cnM= Z21lbnRz LmF0dHJpYnV0ZXM= IEZsZXg= IENsb2Nr w61jdWw= aW1lbg== Sk8= IFJlZ2V4 X0xJTks= IGNvdWNo IElOUFVU IGJlYXRpbmc= YnVzaW5lc3M= cHJlY2Vk LnVuaXQ= IEZlbA== TmV2ZXI= b3NwZWw= LnN0YXJ0c3dpdGg= IEVQQQ== Lm9ubHk= IHByZXZlbnRpbmc= eWVy Q29sdW1uTmFtZQ== IGVsZXZhdGlvbg== Zmx1 aWN5Y2xl IG9mZmxpbmU= VG9vbGJhcg== IGNvbXBldGluZw== KV0u IG1vZw== IGlzVmFsaWQ= QXNr X2F2 X2xhdA== QU5D IEpvaA== a2Vycw== IGd1YXJkcw== IGNoYWlucw== IFNpbXBsZURhdGVGb3JtYXQ= LnN0YXRpYw== IHZlc3NlbA== IG11ZA== IHN0YWJpbA== IHN0cmV0 Z20= YW1hdGlvbg== 55w= LXdpdGg= IHJvcw== X1BB IHJlc3VsdGFkbw== IGNvbmZpZGVudGlhbA== IFRva3lv CXVzaW5n IE1hdGhm b21iaW5l IEVTUE4= IGRlYWxlcnM= IGRpc21pc3NlZA== VFJZ IHRlZW5z cmVjb3Jkcw== IHdpbmdz Z2FsbGVyeQ== YWNjb3VudHM= X0xJQg== IGphY2tldA== IE5TT2JqZWN0 IHN0b25lcw== IERlbGl2ZXJ5 IERpZXQ= L3dhdGNo IHRvaWxldA== IEd1ZXN0 LmRheQ== MDY3 IGludHZhbA== MDg3 VmlzaXQ= IGludmVzdGlnYXRlZA== IHBlbnRydQ== IFRoZWF0cmU= YW5kaWRhdGVz TGFuZw== IFNlcnY= IGNvbnRyb2xsZXJz IHNldFRpdGxl TlA= YW15 ZmxhdA== KHVp MDY5 X2RvY3VtZW50 6IO9 IENvaW4= IEFkYW1z cHRpYw== IHByb2R1Y3RpdmU= IGFjY29tcGxpc2hlZA== DQoNCg0KDQo= IGRlZmVycmVk aWVudGVz IHNpbmM= b2xhcnM= UmlnaHRhcnJvdw== IHZhcmlhdGlvbnM= KG9mZnNldA== OTU3 LkxheW91dEluZmxhdGVy IHN1c3BlbmQ= IHByZXZlbnRpb24= X3ByaXZhdGU= X2pz 4piF IHdpZWRlcg== YXR1bQ== kow= IGFwcGVhcmFuY2Vz LkRvY3VtZW50 IHZhbGlkYXRlcw== Y2FsZW5kYXI= fSI7Cg== LmRlbW8= Y29udXQ= IGNvcnJlY3Rpb24= IERlYWw= IGJhdHRlcmllcw== LmR1cmF0aW9u LFw= X21hcmtlcg== bXVsdGk= IGhhbHQ= IGNtcw== IHNoYXBlZA== QnJv cmVkdWNl ICMjIyM= Q1RPUg== IEJlbmVm IGljb25pYw== IHBpYW5v IGVmZmVjdGl2ZW5lc3M= fC4K IGFqYXg= IHZvbHVtZXM= 4Lih IGNsanM= ICAgICAgICAgICAgICAK YXRocw== cmFpdHM= 5aSn 0ZY= X211bHQ= IGZhc2NpbmF0aW5n QXZlcmFnZQ== IHByw6k= IENoYWlybWFu LmZpbmRFbGVtZW50 X3Bpbg== IGNvbXBhcmluZw== IGRhcmtuZXNz LUZp LXNlcnZlcg== IHNlbGVjdGluZw== c3RlcmRhbQ== IFBhcnRz Rk9STUFUSU9O IG5vdGluZw== IHBpbGU= b2dz IHBhbGV0dGU= X2Rv aXRpemU= MDc5 KCko IGRlZmluaW5n IHJlbWFpbmRlcg== VW5pdHM= X1RBU0s= SHR0cENsaWVudA== U29jaWFs IGZ1bmRyYQ== TlI= Y2hlc3Q= Q3VycmVuY3k= LmFkYXB0ZXI= IGRvcA== dW50aW5n QU5HVUFHRQ== Ikhl CWluZGV4 X3BhY2thZ2U= Lkljb24= IHJlcGV0 bWFzcw== PSIuJA== IFN1ZA== IGxpZA== cHJvdmluY2U= 7Jw= R1BJTw== 0Jo= IE15U1FM IGRvY3M= IEdB IGlwc3Vt S2VybmVs IGFjY2VwdHM= IGZpdHRpbmc= IGN1YW5kbw== IGR1cGxpYw== IEJyb3RoZXI= IEtsZQ== bnVtcw== IG1vcnBo ICMjIyMjIyMj IENHUG9pbnQ= PHVuc2lnbmVk 5L6L IER1a2U= LnNldEJvdW5kcw== cXM= b3JpYw== amVy IHJlZ2FyZGVk SHR0cFJlcXVlc3Q= IGJvbmRz IHRob3JvdWdobHk= ZW5jZW50 IGhpZ2hsaWdodGVk IGFjcmVz IHdvcmtwbGFjZQ== IEx1eA== IHF1b3Q= OTg2 LmluZmxhdGU= IGRvY3VtZW50ZWQ= IGFkZGljdGlvbg== IG11dGF0aW9u LmNpdHk= IGJvdHRsZXM= IFJlcG9zaXRvcnk= b25u ZXJybm8= QVJJQUJMRQ== 5bqm X0JFR0lO Z2xhcw== J30pCg== IE1hc3NhZ2U= IFdoaXQ= cmVnZXg= V0E= IG91dGxldA== LWhlYWQ= IGV4cGlyZWQ= IFRoYWk= L2luY2x1ZGU= Z3JhZGllbnQ= c2NhbmY= IHNlYW0= d2Fs CWJ1Zg== QmVhcmVy IHByZWNpb3Vz aWZhY3Rz Y29vcmQ= IGV4cGxvcmF0aW9u LmdldFk= KGhhbmRsZQ== VG9waWM= IFZlbnQ= cmhz LS0tLS0tCg== IEJyaWdodA== IGd1aWxk bW90aGVy c3Rvcm0= IG11bmljaXBhbA== IGluaw== LlRZUEU= d2w= Li4uPC8= X0RFVg== PSIuLw== X2Jvb2s= dGh5 aXR6ZXJsYW5k b3BsZXM= dHJhY3Rpb24= IENhbWVyb24= IEFuZHJl LnJlc3VsdHM= IGNocm9tZQ== IHNlY3VyZWQ= IHN1cmZhY2Vz KTw= IHRvYmFjY28= CXNwcmludGY= IGVzY2Fs IHN0ZGVycg== IE1lbGJvdXJuZQ== IGRpc3RyaWN0cw== IG1hdHQ= b2hlbg== IGRhdGFHcmlkVmlld0NlbGxTdHlsZQ== KE1vZGVs IHNlbnNpdGl2aXR5 S0E= dHJhbnNwb3J0 LmdldERhdGU= IHN1YnRsZQ== VUdJTg== Lm1vdXNl IGFsdGVybmF0aXZlcw== IGVsbGU= Y29yYXRpb24= cmVhdGlvbg== 5ps= X05PUk1BTA== RGlzcGxheU5hbWU= IGZhbmN5 SVNFRA== TU9E LlJlYWRPbmx5 IFVi IEN1 aWNvbA== IE5lbHNvbg== IENPUg== YW56YQ== IFNwYXJr ICJcXA== LS0KCg== d29vY29tbWVyY2U= IHJlbWVtYmVyZWQ= dmVyaXR5 IEV4dGVuc2lvbg== IFBE IHNlYXJjaGVz LnNv IEZvb3Rlcg== ID0n IFdBUk5JTkc= LWxv CXRhYmxl IGRyYXdlcg== cGljdHVyZQ== IEZhbnRhc3k= c3Rvcnk= IG3Dqm1l IwoK X3NsaWNl b2x0YWdl SGFy L3k= IEVS ZGll IFBPUw== LmFjdGlvbnM= KE1haW4= ZXdhcnQ= YXBldXQ= IFNURQ== aWRkaW5n LnJlYWRMaW5l IHNlYXJjaGVk V2Vk LmZpZ3VyZQ== dWdodGVycw== KCkuX18= IG9yYml0 c2hpcHBpbmc= IGZyaWVuZHNoaXA= IFNoaWZ0 LW9y cXVv V0hFUkU= IEVzcA== LmZvcndhcmQ= b2ZmaWNl IGnDpw== IENoZWxzZWE= SXRlbVNlbGVjdGVk YWNoZXJz ZGVsZXRlZA== cm91cw== ICItIg== IEdyYW4= IPCfmA== LXBvd2Vy ZXR0YQ== IHJlbWluZGVy ZW5zb3Jz IEFsbG93 xJlk X3RlYW0= IGNyb3du dGlja2V0 IGNvbGxlY3Rpb25WaWV3 bGFjZQ== IGZpeGVz IEh1Yg== Y2F0YWxvZw== IElkZW50aXR5 IGV4Y2Vzc2l2ZQ== IE5hdmlnYXRvcg== X0JS LXBsYXk= IENhbXBhaWdu ICAgICAgICAgICAgICAgCg== YXNpdmU= IHdj IEJlaWppbmc= L3d3dw== IG1ha2V1cA== IGRpc3RhbmNlcw== IHNhdGlzZnk= Q09ORA== IHdvdW5k KCld IHZpb2xhdGlvbnM= IHN0YXlz LyM= aWxpbmU= XEV4Y2VwdGlvbg== IE1vdGlvbg== IGhlYWw= X3BsYW4= cmFzZXM= KG1haW4= QXBwbGU= IGNvbXBsZXRpbmc= IGRldGVybWluZXM= U2Nhbg== IHN0ZWFs IFNvYw== QW5hbHlzaXM= IGZhdm9yaXRlcw== IGNhbXBv b25lcg== IEZsaWdodA== Li4uCgoKCg== KSkpKSk7Cg== LWNvdW50 IHB3 QXNTdHJpbmc= IHNleHVhbGx5 Rmlyc3ROYW1l IEVzY29ydA== Y2FsYw== IFdpa2lwZWRpYQ== IGRvY2tlcg== IFN3ZWV0 J2lk SW50bw== IEh1bnQ= LmVxdWFsVG8= IGxhYm9yYXRvcnk= IEJVU0lORVNT RmlsZURpYWxvZw== VHJlZU5vZGU= LkVuYw== IE1heGltdW0= IG1vdGhlcnM= 5rU= IGZyYWN0 LnN0YXJ0c1dpdGg= IGhhcmRjb3Jl Lm9i 5aeL ID48Lw== X3Jv KCgq Pz8/Pw== X3ZlcnRleA== a2VpdA== IEhhbGxvd2Vlbg== VEk= IFZh X2Nhcg== PSJ7eyQ= IHJhbmRvbWx5 0LDQvdC40LU= IHNob2NrZWQ= IFBva8OpbW9u c2lnbmFs IFNESw== bWlkZGxld2FyZQ== IHRyZWF0aW5n IGJ1cm5lZA== RGVwYXJ0bWVudA== IFNwZWN0 IGNsaWVudGU= IFJlZGRpdA== X2F2Zw== IGluc3RhbGxpbmc= X2FscGhh LGRhdGE= IHNldElk IExpc3RWaWV3 KHByb3BlcnR5 IGNyb3NzaW5n IE9iag== IFdhcmQ= IFJlZGlyZWN0VG8= IFByZXNlbnQ= IGRyYXdz Y2hlZHVsZWQ= IGxlZ2lzbGF0aXZl IHR3aXN0 IFN0cmE= IEFGUA== IENoYXA= LXBy OkNHUmVjdA== IGNlcw== Um91dGVz bm9m IHZpc2E= IFRDUA== IEVWRU4= aXZpYWw= IExldHRlcg== UkFZ IGltcGxvZGU= LmVx PScr IG1vdGl2YXRlZA== LnZpc2libGU= LnNob3J0 Pm1hbnVhbA== IFRlY2huaWNhbA== IGNvcnBvcmF0aW9u IEhX YW5rYQ== VEFJTA== aXN0YXM= IHBlcmZvcm1z IEJlaGF2aW9y LkZvcg== X09SREVS IEtpY2s= IGNhbGxiYWNrcw== X2Ry dWVnbw== aHVi dWZmaWNpZW50 c2t5 IGJw aHRhYmxl IE9OTFk= IEFVVEhPUlM= LkFyZ3VtZW50 In07Cg== IFRodW5kZXI= IEtvbQ== LlNob3VsZA== QVVUSA== YWh1 X3BheW1lbnQ= IHN0YXJ0ZXI= 7ISc 7Jqp QmxvZw== LnBhdGNo IGdvdmVybmVk YXNzeQ== LWZvdW5k IHRoZWF0ZXI= IEZvbnRXZWlnaHQ= IEJhdG1hbg== Iklm LlJhbmRvbQ== X2RlbHRh IENF QXV0aGVudGljYXRlZA== IGRyb25l IGNvdXM= cmFkaXVz TWVy KE5vbmU= IE5K X2hlYWRlcnM= IGFtZXI= cHl0ZXN0 IEFjdGlvbnM= CQkJICAgIA== IGV0dA== IGhvbHk= IHVuY29tZm9ydA== IE5pbg== IERlY2ltYWw= IE1lc3NhZ2Vz LnNlbmRlcg== XV0pCg== IGVtYnJhY2U= VGhvdWdo L3Nw IGN1bHR1cmVz IGhpZ2h3YXk= dGFy LmZhaWw= X2hpZGRlbg== IGNvbXBvbmVudERpZE1vdW50 IFdyaWdodA== IGphZw== X2ls Li4vLi4vLi4v aWd1 Rm9vZA== IGFjZQ== IGHDsW9z VVNE IG11dHVhbA== TG9naWM= IHRlbXBsZQ== IGJyaWVmbHk= IFRyaXA= Y2xhc3NtZXRob2Q= ZGVmYXVsdHM= IGNodW5rcw== LCwsLA== IFJlYXNvbg== JGlk LXVwcw== IGRhbW4= IHRydWNrcw== IHVubGltaXRlZA== IHNjdWxwdA== IENhcmRz IGF1dG9y IFRlc3Rpbmc= IGRpZXNl c2hvcHM= 57Q= KHBheWxvYWQ= IFBBVEg= IE1lbW9yaWFs IHJpZGljdWxvdXM= ZWdyZWU= LXdpbm5pbmc= IHJlaGFi IHNvcGhpc3RpY2F0ZWQ= d3BkYg== CXBhdGg= ISI7Cg== X1NZUw== LnNwZWVk IHNvYXA= c3VmZml4 V3JhcA== IGVuaGFuY2VtZW50 w4k= w7pi IHBsYXlsaXN0 IG1peGluZw== YW50aWRhZA== PSIiOwo= IFJldmlzaW9u IEJlYXQ= LmluYw== LXdheQ== ZW5jaWFz dWxlcnM= Q2F0 aWRlbA== IFNoaXA= LnNldENvbG9y IHRocmVhdGVuaW5n Lm1vZHVsZXM= IGFmdGVyd2FyZHM= IERhc2hib2FyZA== CiAK U2lnbmFs IHByaW1lcg== b3JuZXlz aWNpYXJ5 IGxpZ25l X3ByZWRpY3Q= IGFlc3Q= X2h0dHBz Pjo= IExleA== IHJlbmNvbnRyZXM= ZWdyYWw= c2NhbGE= X2ZhbWlseQ== w59lbg== X3N5bQ== IHVuY2VydGFpbnR5 IFZBTFVF IH07DQoNCg== IGJyb2FkZXI= IGhvcnNlcw== 44Gd IEthbA== b2Jh X0lORVQ= IEtpbGw= anF1ZXJ5 YW1pbmF0aW9u W0Ai IG11ag== IyMjCg== Rmlyc3RPckRlZmF1bHQ= dGhlblJldHVybg== Q2hl L2Zvb3Rlcg== IHBhcmtz YXNqZQ== IEd1bGY= IG1vZGVzdA== LkluaXQ= 77yfCgo= IHByb3NwZWN0cw== IHN2Zw== IOWP LkRpYWxvZw== X05FVA== ICgoJA== IGVr IFdhcm5pbmc= IE1L PExN ICcNCg== aWVt aGV0aWM= IGl4 dGhpbms= LXNoYWRvdw== IEVsZA== IE5ldmFkYQ== IExlYWY= IEdST1VQ IHByb21v ZW50aW5l CU1hcA== IE1vZGVscw== IEtyaXN0 X2tlcm5lbA== LW1hZGU= IGNlcnI= QXNzZXRz ZWxsYXI= IGludm9rZWQ= LnZ1ZQ== IGN1bHRpdg== Q2xvc2Vk IGdlbmVyYXRlcw== ZmZmZmZm dGhlc2l6ZQ== c3FydA== IENhc3RsZQ== LmNhcg== IGtlZW4= dW5kYQ== IENyb3c= IFNpbmdo eXRob24= IGJlYW5z bGFyZw== 5paH5Lu2 QXdlc29tZQ== dW5jYXRl UGF0aHM= b2pp KGN1cnI= Q09ORFM= IG1pbQ== IHNob3VsZGVycw== SGFyZA== YXN0ZXM= 0LDQtdGC IGNvbnZpbmNl ZGVjZXNz bWFkZQ== IENNRA== Lklt IGNoYW9z ZW5zaXZlbHk= IGNvb2xpbmc= IGJ1cmllZA== KCdA X1Nl CQkJCQkJCQkJCQkJCQkJCQ== LmNvbXBhbnk= LnN1Ym1pdA== cGhhbnQ= IGJvb3RzdHJhcA== X2hlbHA= 4Kc= LmR1bXA= IGRpZmVy X21hcHBpbmc= IGNpcmN1bGFy IGVzY29ydHM= IGJlcmU= IGdyYWR1 IExlZ2VuZA== aW1lZGlh IEJhcmNlbG9uYQ== IGJlZHM= 5Yiw 44CK X3ZvbHVtZQ== IHRyZW1lbmRvdXM= IHNjYWxpbmc= IHBpbnM= ZW5hcw== dHlwZXBhcmFt RGFzaGJvYXJk cmVuZGVyZXI= IHNwaQ== ICYk IFNraW4= YWxtYXJ0 IGhvY2tleQ== ICciLiQ= IGVycm5v IGJldw== Rm9sbG93aW5n Lk1vZHVsZQ== ZXJhYmxl IE1pbGl0YXJ5 IFJpbw== X2F2YWlsYWJsZQ== IFN1cmZhY2U= IHN0YWI= SUZJRVI= IExJU1Q= IGRhc2hib2FyZA== IGNsdXN0ZXJz LnBsdWdpbg== IGpvdQ== IERlY29y Rm91cg== IGRlbGxl KioqKioqLwo= aWF6 aW5kZQ== Y2hpbmc= IGdldEl0ZW0= LkFkZHJlc3M= bWVudGVk QW1lcmlj UGxhaW4= IHVzYg== IFByYWN0aWNl X21lbnQ= LmJsdWU= SGludA== 0YDQsNCy IGNvbm5lY3Rvcg== IGluaGVyaXRlZA== 0LjQsg== IGludGVydmFscw== IGNlcmU= IHVk IGluY29u LkV4aXN0cw== IE1pYw== Rks= KGNhcmQ= LlNldHRpbmdz IGV4aGliaXRpb24= IG9uUHJlc3NlZA== IHJlc3RvcmVk ZW5ndQ== LmRlZg== IHJlY3Y= LiIpOw0K ZW5jb2Rlcg== YXRoZXJpbmU= KGRlc3Q= YXplZA== I2VuZHJlZ2lvbg== c2VtYmw= LE0= b2J5 INC/0LXRgA== LkNhbGw= IGF0dGVuZGFuY2U= LWJvcmRlcg== IGFkZHJlc3Npbmc= w6pu IExldg== IGJhc2g= YmVuY2g= Q3JlZGVudGlhbHM= U3BhY2luZw== KG9m X1JFU0VU aWd1b3Vz IGNydWVs IGNyb3NzZWQ= IGxldXI= IEdvbGY= b3JyZWN0 IHBhY2tldHM= IERhdGFTZXQ= IHBhcnRseQ== U0VRVUVOVElBTA== IGluZGljYXRpb24= IFNhbHQ= YWNpYQ== ICopOwo= CWluZm8= IFZpZXdCYWc= b256 IGVkaXRvcmlhbA== IEFyZW5h IHNpcg== X1N0YXRpYw== KHNvY2tldA== c3U= Y2hvb3Nl Lm1vbnRo Lk15 MDk2 w6lyaQ== O2ZvbnQ= ZG9lcw== IGNvbnZlcnRlcg== IHNhbHY= IGxy IGluZmx1ZW5jZWQ= KGZlYXR1cmU= IFF1ZWVucw== bGV0dA== X01PTg== JmFtcA== VG91Y2hhYmxlT3BhY2l0eQ== T0ZG IG1ldGFib2w= KGl0ZXI= IHZpdGFtaW4= IElORElSRUNU YXV0b20= X3B1YmxpYw== IGFkanVzdG1lbnQ= IHNwZWNpYWxpemVk d2luZG93cw== LmFkZEFsbA== IGFjY29yZGluZ2x5 IEpPcHRpb25QYW5l IGNlbGxzcGFjaW5n IHF1YWQ= IGNyZWVw IG91dGxldHM= fWApCg== IHByaWVzdA== X1RIUkVBRA== IE1hcng= IEJ5VmFs IGN1YWw= 6Z2i IHRlbXBvcmFyaWx5 QW5u a2VsZXRvbg== 5aU= IExPQw== YXVlcg== ZGVyaXZl IGJlaGF2aW9ycw== YXNlbmFtZQ== IENlbnR1cnk= IGhvcnJpYmxl TUVTUw== X0xpc3Q= d2Vp UGF0 IENob2ljZQ== X0ZST00= CWxpbmU= Lmludm9rZQ== LkJvdHRvbQ== IG5vd2hlcmU= LiIKCgoK X2V4cG9ydA== IHN0cnVnZ2xlZA== LkFwcGVhcmFuY2U= IEpCdXR0b24= IEplcmVteQ== KFtb IGtpY2tlZA== bWFyc2hhbA== c3RhZmY= ZXNpdHk= IHF1aXo= X2VmZmVjdA== IH0pKTsKCg== bWVs YmFubmVy IFBJTg== IGludmVudGlvbg== IGNvbnNvbGlk IG9wcw== IEJldHdlZW4= amFjaw== ZXJuYXRpb25hbA== IHNhY3JpZmljZQ== YWdhdGlvbg== IEpveQ== IGFtZW5kbWVudA== IFNvbGQ= IHByaXNvbmVycw== 0LDQvdC90Ys= RG9jdW1lbnRz KV0pCg== dXN0ZWQ= IExpbmVhckxheW91dA== b3Nv X0VN LnNlbGY= Lk1pZGRsZQ== KS8v IFwn IGZ1Y2tlZA== IE11cnJheQ== IHByb2ZvdW5k X0VMRU1FTlQ= dWx0YQ== aWxlcnM= cG9ydGZvbGlv SnVuZQ== dGNw bW9kaWZpZWQ= IFRyYWNl IEtlbA== YWx5emVy KT0+ IFJlcGFpcg== X0JF QnJhbmQ= dWFydA== cHJldmlldw== IGluaXRpYXRpdmVz cnVubmluZw== YmFuZw== CXVwZGF0ZQ== IENvYWNo UmljaA== IHlvdXR1YmU= IHJpdHVhbA== YXBwYQ== IFJvYmluc29u cHJlY2lzaW9u Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLw== PVtdCg== IGNlbGVicmF0ZWQ= T1RP IGluY2x1c2lvbg== SlA= JzsNCg0K IG5vdGFibGU= KF8u TWFuYWdlZA== IGd1aWRlcw== Jm5ic3A= YXRlZFJvdXRl IEFkanVzdA== IGNvbG9yZWQ= X3Njb3Jlcw== IFRlc2xh X3Byb2dyZXNz Lmluc3Q= Wydf LmZsYWdz IGZjbG9zZQ== X09QRVI= xbx5 X25vdGU= IHRyYW5zZ2VuZGVy 5ZU= UklQVA== IGFic2VudA== IGFtZXQ= IG9wZXJhbmQ= 66k= IGhvb2Q= dG9Mb3dlckNhc2U= YXZv IENpcmN1aXQ= IExpbmQ= LS19fQo= PW0= IHN1cHByZXNz IE1BUA== aWFuZw== LWFkbWlu IHNpZGViYXI= IEJ1 IEhleA== LEY= IFNpZ25hbA== IHRyYW5zcGFyZW5jeQ== IEZlZGVyYXRpb24= L1Y= UmVx IHB1bHNl IHRlbmRz TnVtYmVycw== JSc= IGRlcG9ydA== ZGF0YXM= X1VJTlQ= X3RyYQ== b2tv ICI/ Y29tcGV0 c29sZXRl dW5kcnk= IG92ZXJsYXA= fWAsCg== Lmx5 X3N1bW1hcnk= IExvc3Q= LkNlbnRlcg== IGRpc2FiaWxpdHk= LlNlcmlhbGl6YXRpb24= IGdlb20= ID86 IFdv IHNoaXBwZWQ= guaVsA== IHVnbHk= IGV4Y2l0ZW1lbnQ= IGV4dGVyaW9y IGNoZWNrb3V0 IGt1cg== LEQ= IEFsYXNrYQ== IHN5bnRoZXRpYw== IEJ1ZGdldA== IFN1YnNjcmliZQ== ICYK yJlp IFl1 CXF1ZXJ5 fS4K IHRyYWdlZA== YXNzZW4= IGFjY29tbW9kYXRpb24= IHBoeXNpY2lhbg== IHJlbmFtZWQ= IHRpZGFr esSF IG1pbnVz bnljaA== MDk3 X0VYQ0VQVElPTg== dGhyZWFkcw== IHRpcmU= X2NyZWF0ZWQ= ZW5zdXJl IHdvcnRoeQ== IGV4Y3VzZQ== IGNsb3Ro LnBhcmVudE5vZGU= L3BsYXRmb3Jt IFVGQw== IEd0aw== dW5ueQ== IGdpYnQ= a2VsZXk= aHVt KHR4 CWRldg== IG91dGZpdA== ZG9vcnM= IGZvbg== aWN1dA== dm9sYXRpbGU= IGhvbW9zZXg= TWF4aW11bQ== IGV4cGVuZA== IH0pOwoKCg== RXE= b25kZXJz ZGVwYXJ0bWVudA== IFBoeXNpY3M= In0pOwo= IHBhcmFk LlN0cg== IHNlbGU= SUZJRUQ= IGRlbGl2ZXJz aXZhbg== IHJlc3BvbnNpYmlsaXRpZXM= IGFkdm9jYXRlcw== 6LU= IFJJRA== LnBhcmFtZXRlcnM= TWV0cmljcw== cm9uaWNz IFVJVGFibGVWaWV3Q2VsbA== QWJzb2x1dGU= aXBzZQ== eWx1bQ== TUxFbGVtZW50 X1ZBTElE PHRpdGxl RGxn cGFjZXM= IHN5bmRyb21l YmVhbnM= X2RhdGFiYXNl b3ppbGxh IE1lZw== REJH IGx1Yg== QmFnQ29uc3RyYWludHM= YWJhZA== IHByb2plY3RlZA== X0JZVEU= LlNpemVG c3RyZWV0 CgoKCgoKCgoKCg== IExPU1M= IGRpcmVjdG9ycw== L25ld3M= IG51cnNpbmc= IERvbmU= LkhUVFA= ZGlzY291bnQ= IFJvdA== VG9NYW55 IGVuYWJsaW5n IGF1c3Np b3N0YQ== ICAgICAgICAgICAgICAgIA0K 6L29 IGhlbGljb3B0 IEluc2lkZQ== 5L+h5oGv aXNwZXI= IEFsbGFo QVJDSEFS IHJvbGxz Q29tcGFyZQ== WFA= SW5kZXhPZg== U1VN IGFzc3VyZWQ= IFBoeXNpY2Fs RW5kcG9pbnQ= Lkdsb2JhbA== LmRldGFpbA== IHRoZWZ0 Lmp1cGl0ZXI= IGh1bW9y LlJlbmRlcg== QWxleA== LmNhcA== IGJ1ZmZlcnM= IGRpc3Bvc2U= dGlvbg== LnByZXNlbnQ= emVs LFA= IGRlc3BlcmF0ZQ== LmdldENvbHVtbg== IHR3aW4= 7JY= LmNhbg== IGZsZWU= IElyYW5pYW4= IHN0aWNreQ== IFVUQw== TFQ= Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8v IGxpY2Vuc2luZw== X1BPSU5U IE1hcHM= IGxvbA== PW1vZGVscw== LXRhYg== IE5hc2g= X2xvZ2dlcg== dG9yY2g= IENPTlNFUVVFTlRJQUw= Tm90RW1wdHk= L3JlYWN0 IHBm IGFzc2VydGlvbg== IHN1YnNlcXVlbnRseQ== X2Nhbg== IHBhbmRlbWlj b2d1ZQ== IisK X2VudA== X1BhcmFt LgoKCgoKCgoK UmVzZWFyY2g= Q2FwdHVyZQ== IGJlbG92ZWQ= ZGVt IGV4dHJhY3RlZA== IGZpZ2h0cw== RVJD KGF1dGg= cG9zaXRpb25z IHJldmVyc2Vk KHN0YWNr IF8p dXRvZmY= X2Zsb3c= 54K5 KEdhbWU= IGV4Y2x1ZGVk IENTVg== Y2c= IFRpdGFu cGF1c2U= IGNlcmNh IGR1bXBzdGVy TGVzcw== IGtvdGxpbng= YXN0ZXJ4bWw= IHBvaW50ZXJz IGZsb3dz IFR1bg== IE1haW5BY3Rpdml0eQ== IGRpc2NyZXQ= IGNvbWJpbmF0aW9ucw== dmlzaXQ= X2JpbmQ= b290aW5n ZGF0ZXI= X2xvb2t1cA== Lm5pbw== IHN3ZWF0 IFJk IHNjaWVudGlzdA== IFBpeGVs QE5nTW9kdWxl UGxheWluZw== IHVuZm9sZA== VHJhbnNsYXRl IExhd3JlbmNl IEZJWE1F QmlsbA== IFJJR0hU IHdoZXJldmVy IG9vaw== dmlkZW5jZQ== IF1dOw== IFNraWxs dW5pc3Rk IPCfmYI= IGZlbWFsZXM= LS0pCg== jrflj5Y= IEZyZWQ= T3ZlcmFsbA== 2YI= IGVzc2VuY2U= IHRoZXJlYnk= IHdvdW5kZWQ= IERPV04= bGVzc29u dGV4dHVyZQ== Um91bmQ= IGF1dG9tYXRlZA== INCh IFVwZGF0ZXM= IHNoYWRl cHVibGlzaA== IEdlYXI= PWxhbWJkYQ== IGxldmVy KSsi aGlsbA== IHJhZGFy cnlpbmc= ICIpLg== ZmlsbGVk IGxpbmV1cA== IGRs IHdvcmtzcGFjZQ== Vm8= X2R0 67I= X0l0ZW0= TlNVUkw= LnZlcmlmeQ== IEhhd2FpaQ== R29k TWFyY2g= IFvigKZd IHBlbG8= dXJpb3Vz IFBpdHRzYnVyZ2g= Lkl0 Q2xlYW4= Plw8Xg== IGlvcw== c291bmQ= Il07 IGZyZWVk cm90dGxl IExvd2Vy W2NvdW50 5Z0= IHBhbGU= IFdheW5l ZWFydGg= X2NhdGVnb3JpZXM= VUNL Lm1ldGFkYXRh IHN1bW1vbg== SE9NRQ== 0L7Qu9GM0Lc= IG1hbnVmYWN0dXJlZA== IGRvY2s= IGNvbXBldGl0b3Jz X01PREVM b2tpYQ== IEhleQ== zr8= IGJhY2t3YXJk IFBPU1M= cm9wYQ== IGNyaQ== X09CSg== VHJhbnNwb3J0 LWhpZ2g= IGVyb3Rpaw== X3Nsb3Q= IGFydGlj X2ZyYW1ld29yaw== LXNlcmlm IFNxbERiVHlwZQ== Jyko KyIv IHdvcmU= U2ls IHN0b3Jpbmc= IFBoYXNl dWFudA== IGJ1bXA= aW5obw== IGRpZ24= IGJhY2tz cXE= KGhhc2g= IGdlbw== IHRlbmRlcg== TG9nbw== ISkK IE1Y IEFydGh1cg== ZXNzb2E= X0No IGJlZHJvb21z PSIjIj48 IHRocm9hdA== aW5zaWM= LmludGVnZXI= IHByaW1pdGl2ZQ== VHJ1dGh5 IGZhY2lsaXRhdGU= IGNyZWF0aXZpdHk= IEROUw== IGdyYQ== dWV6 IGNvdW50bGVzcw== IFBvbGFuZA== J00= IERpc3Q= IHZlc3Q= IGNlcnRpZmljYXRpb24= 4buR aGVsZA== ZXh0ZW5zaW9ucw== KHN0YXRpYw== IGdyYWRlcw== IFViZXI= 44Gf IFtdKQo= ZGF0b3M= IGdldERhdGE= IENoYXJn IEJT Lm1pY3Jvc29mdA== LnZpZGVv LmRpcmVjdGlvbg== LT57Jw== bHVh YXBlc3Q= IGJvaWxlcg== ZXJlaw== IGRlY2lkZXM= Lmphcg== SVND IFdvcmRz KENPTg== RU1QTEFURQ== cmVlemU= c2hvdHM= YXBwcw== dW50ZWQ= LnNldE5hbWU= Ojo8 LWJvbGQ= 6rI= 5a+G TG9uZ3JpZ2h0YXJyb3c= IHVuZmFpcg== IGVhcm5pbmc= IHNoZWxm VVJFTUVOVA== IGlkbGU= X01FTlU= LkN1c3RvbQ== QUdFUg== LSI= X3N3aXRjaA== YmVjYXVzZQ== KXZpZXc= bWFyZQ== X2NvbmRpdGlvbg== IFN0YXJ0aW5n TXZj KHByZQ== ZHVtcA== X0xPQ0s= YXRldGltZQ== LmNhbGxiYWNr IENlcg== b3BvbA== aWJyYXJ5 IHJlc2VydmF0aW9u CQkJCQkJCQo= bGVjdG9y Z3JhZHVhdGU= IGdlbmVyb3Vz IGlvbg== cmljYW8= bXE= X2NvbXBsZXRl KGN1cnNvcg== IEZvcm1Db250cm9s OmNlbnRlcg== IHN1YnN0aXR1dGU= IFBsYW5uaW5n IHBlbnNpb24= IHJlY29tbWVuZGF0aW9u IFRhZ3M= IGdlZg== IGFsYnVtcw== IHdhc2hpbmc= cm9j IHRyYWlucw== YXRpbmdz IGV4cG9uZW50 YWNrYmFy LWxu w6Fn LkRhdGFBbm5vdGF0aW9ucw== IEVJRg== IE1hbGF5c2lh CVBPUlQ= b251cw== IGNsZXZlcg== IHBldQ== PgoKCgo= IEFyZ3VtZW50cw== IGRlYnVnZ2luZw== KHJpZ2h0 J0Q= Y29tcHV0ZQ== IGZpbmVzdA== T1JBR0U= IHNwZWN0YWN1bGFy cGhyYXNl IGluZGlh IGxlZ2VuZGFyeQ== YmlydGg= IGNvbXBvc2l0ZQ== IGdyb3dz IFRE IGVwaWQ= IGxhdW5jaGluZw== XV1b TWludXRlcw== IENoYQ== IGNsZWFuZWQ= IHdpdG5lc3Nlcw== dWthbg== CVR5cGU= IGhhYmU= cGFyYWdyYXBo IEpQYW5lbA== IEhhbm4= IHZhcmllZA== IFBva2Vtb24= IE1VU1Q= 5Yqo LnZpc2liaWxpdHk= b3B1cA== Xls= LmV4cGFuZA== ICInLA== LmZhc3RlcnhtbA== X2F1dG8= IFNoZWV0 bWFya2Vy UGFyY2Vs ZXdz IFN0cmF0ZWd5 LW1ha2luZw== IHVudmU= IHRyYWlsaW5n IGNsaWNrcw== IEdldENvbXBvbmVudA== CWNvbnRlbnQ= SUdFTkNF RVJORUw= TlNNdXRhYmxlQXJyYXk= IGJyZWF0 IGhhcm1mdWw= tog= IGJlc2lkZXM= IGJvcmluZw== IGJydXRhbA== dmFuZw== KHBhcnNl cXVpY2s= IHB5dGVzdA== IHN3aXRjaGluZw== KCldCg== IOyE TEVS CWZvbnQ= IG5ldHQ= KV0KCg== KC9c 5p6c dG9BcnJheQ== IGJyZWVk IENBUg== IFdlYXBvbg== QWJz dG90 IHNldE5hbWU= YXB0aXZl IDos IGVzY2FwZWQ= b3JkZW4= IFByaQ== dGh1bWJuYWls IGRlc2NyaXB0aW9ucw== L3N0eWxlcw== IFBDSQ== IGFscGhhYmV0 YXN0aWNzZWFyY2g= Tk9URQ== IGNpYWxpcw== IEdyaWZm IHBvcnF1ZQ== IHByb3RlaW5z cGxheXM= IHN0YXRpbmc= IGltYWdpbmF0aW9u IGZhY2lhbA== IE1lY2hhbg== IGFycmFuZ2Vk X3VzZWQ= IGFycmFuZ2VtZW50cw== IFBpcGU= aG9zdG5hbWU= IHByb3ZpbmM= VGl0 LkZsYXRTdHlsZQ== IFNwbGl0 IExvYWRlcg== LmNj IGNsaW5pYw== LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== IGJha2luZw== IEVOVA== bmVhdGg= 44CBCgo= QU5F LkVudGl0eUZyYW1ld29ya0NvcmU= YXBwZXJz Lmlj IE5nTW9kdWxl IEZPUk0= ICc7 LXByb2ZpdA== aHc= ZW5lbXk= IEV5ZQ== IGNhdXRpb24= dG93bg== IHVyZ2Vk IEppbW15 eW5jaHJvbm91cw== LXNpemVk bWFraW5n LHs= XScs X09iamVjdA== YWhvbWE= IGFjdGl2aXN0 SU5WQUw= IENvbW1lcmNpYWw= IE9ybGFuZG8= KHRhYg== INio QWxnb3JpdGht IGhlcml0YWdl R2V0TWFwcGluZw== IGZhaWx1cmVz cmlvcw== YXRpdmE= IHRldA== IGNhcnBldA== KFo= dGhyZWU= IGRpc2Nsb3N1cmU= LkVSUk9S X2NhbGxlZA== IGRpYWw= IG9jY2FzaW9uYWw= LkVycg== IGZ1bmNpb24= Y2FmZm9sZA== IHJlbGVhc2luZw== 77yJCgo= X1ZhbHVl IFZhcmk= eWVsbG93 IHN0cnVnZ2xlcw== LmNhbA== IERha290YQ== CWNsb3Nl IHNhbmR3aWNo IGFuYWx5dGljcw== ICoqKQ== JiM= IEpvcw== IHBhc3NpdmU= QVRUUg== VGhyb3dhYmxl IE11bg== IFVpbnQ= KGRpc3Bvc2luZw== YXJhaw== IExlYWRlcnM= IGFmZmVjdGluZw== IGl0ZW1WaWV3 IGVjb25vbWljcw== ZnY= 4LmA LnJi IE92ZXJhbGw= IHdlYWx0aHk= IGV2b2x2ZWQ= bmRh IEh1cw== cmVzdHJpY3Q= dW1lbg== IEFncmljdWx0 IQoKCg== IGV4cGlyZXM= IHNwb2tlc3BlcnNvbg== aW50ZXJ2YWw= IMOi IHF1ZWVu KG5pbA== aW5nbw== SGVhcA== 2Y4= IGNvbXBsYWlu U3lt IENsb25l IFJ1 IFdJTEw= IENyeXN0YWw= L2NvbnRlbnQ= aW5nZW4= b2ludG1lbnQ= TGFzdE5hbWU= YXZpY29u IElCTQ== IERpbWVuc2lvbg== YW5o aWNpcGFudHM= IEFubmU= LnByb2dyZXNz IGFsZ28= b2JpbA== IFZvaWNl IEZF IGdsaQ== IHZlZA== IHByZXZlbnRz XENvbHVtbg== IGZvbGs= ZXR0aQ== IG1u IENMQVNT IGRpc3BsYXlpbmc= IEts IEZlcnI= ZHV0bw== Lmli IGRhZG9z J25hbWU= LXNwYWNl IGl0YWxpYW4= IGludmVyc2U= IGRlbnNl dXRlcg== IElFbnVtZXJhdG9y LXNpZ24= IG5hdGlvbndpZGU= IHBlcnNvbmE= IHNvbHZlZA== IGRyYW1hdGljYWxseQ== TG9nb3V0 IGdyYXY= IGFuYWx5c2Vz b2xsbw== IGxhbXA= LnRlYW0= IEVyb3Q= PVsi IGRhbmNpbmc= ID8+Lw== IGNhdGVy ZmZl IFNoYQ== IEJvcw== IFJFUVVJUkU= IE1vbnN0ZXI= IFJC IElERQ== IHN1aXRz IGZvcm1EYXRh KHRoZXRh IHNwYXRpYWw= PU5VTEw= IFNxbENvbm5lY3Rpb24= IOA= IFZlbmV6 IE1vcm5pbmc= IHB1YmxpY2F0aW9ucw== IE5PTklORlJJTkdFTUVOVA== Zmlyc3ROYW1l dWRz V291bGQ= X0hFQUQ= IGludmVzdGVk c3RhYmxl ZnJlZA== IGNvbW1hbmRlcg== U0VT 4oCUYQ== YW5jaGU= IE1vdmVtZW50 67M= U3VpdGU= IGp1cmlzZGljdGlvbg== 66as IEJldGg= alF1ZXJ5 IElzYQ== IGRlbnRhbA== LCo= IExpbWl0 aWxpYXRpb24= PSJ7 YmFzdA== IHR1cmI= aXN5 T09L IGFkdm9jYXRl aW1hZw== TEVDVElPTg== 0LvRjA== KGNhdGVnb3J5 LmRlYw== IHVuaXF1 X3Nu IGF0dHJhY3RlZA== IMOJ IFJ1bm5pbmc= X2VkZ2Vz IERpc2FibGU= X0FT 5Zu+ IG5ldHdvcmtpbmc= X2JyYW5jaA== SGF2aW5n dG9CZVRydXRoeQ== R0k= IGNhbXBz c2Vw LXBhcnQ= ICkKCgoKCgoKCg== dXN0cmFsaWE= IFJlcG9ydHM= cml0bw== IHdhaXN0 X3BsdXM= IFdX LXBlcnNvbg== QXByaWw= IHNhcg== LnRhcg== IGFncmljdWx0dXJhbA== dGlj IHRjcA== IHNldFZhbHVl YWdlbnRv IEFwcGU= cGlsZXI= Q0FERQ== IGFuY2hl YXRjaGVy IGNvbWljcw== IGxicw== X3NlZ21lbnQ= J109JA== aXR0ZXJz aWNoZXI= R0lORQ== IHV0aWxpemU= IEN1cnNvcg== X2V4cHJlc3Npb24= IGRhZw== PGxvbmc= IHJoeXRo 5o+Q IGNvbnN1bHRhdGlvbg== WWV0 IikpCgo= X01BQw== Y291bGQ= ICdcXA== IFZv CWh0dHA= IGdz cGhlcg== LWdyaWQ= SmFtZXM= SnVs IHNjaG9u IHRlbnNvcmZsb3c= IExPR0dFUg== YW1hcw== IHNjaXB5 IGNvbnZpY3Rpb24= LmFn IGFkbWluaXN0cmF0b3I= KSl7DQo= IG51bg== Imdyb3Vw UG9y IG51cnNl ZXhwcmVzc2lvbg== YWt5 IEhlYXZ5 Lm9wdA== LmdldEFsbA== IG92ZXJs LyIs X2NvdW50cnk= 544= IEdFTkVS X3JvdXRl IERhbA== wrQ= b2xvYWQ= IHVuY29tZm9ydGFibGU= KG1lbnU= IGhvc3RuYW1l JyIpOwo= IGNhbGN1bGF0aW9ucw== LWNsaWNr IHByb3RlY3RpdmU= 44Kv X0Zvcm0= dW5ncw== QWN0dWFs bWY= IFByb2Nlc3Npbmc= IEludmVudG9yeQ== KG1hdHJpeA== YXBwcm9wcmlhdGU= d2Vn aWph IGNocg== IHJpZmxl LXdzag== a2Fy IGluZGVwZW5kZW50bHk= SU9T IGNvbnNpc3RlbmN5 dm4= L3N5c3RlbQ== IENoYW5nZXM= IGV4cG9zZQ== aWNpZW50cw== IHJlbGF0ZQ== CW5leHQ= 6Kg= dWRlcw== IGdsYXNzZXM= RlhNTA== Li4uLi4u IFBkZg== IGFwcHJvdmU= IHtc IGV4aXN0ZQ== KSko QVJFTlQ= 0L7Qvw== IExhdGVzdA== IE5pZ2VyaWE= LkludGVyZmFjZXM= IHJlbW92ZXM= RW5lbXk= IGVuZm9yY2U= dmVydHM= CXBvcw== X3RleHR1cmU= V0FSRA== IElOQ0lERU5U KGNvbnRhaW5lcg== IGRlZmVuZGluZw== IFJY IEhvb2s= YnJpcw== IEZsYXNr R3JheQ== LikK dmlzaWJpbGl0eQ== IFJlZGlyZWN0VG9BY3Rpb24= ZXJyYWw= X2VsZW0= IHJlc29u ZnJvbnRlbmQ= X3ZhcmlhYmxlcw== YXRlcmlh ICsi YXZlbGVk UklY IGRlZmljaXQ= X0NoZWNr WVlZWQ== VG9PbmU= c3B5 IHVuaXRlZA== ZW5kZW50 IHBvZGU= 44GM Q0FU KGZtdA== IEJvbnVz IHJlY2s= wro= TW9kdWxlcw== IHZhY3V1bQ== UmFkaW8= IERBTUFHRQ== UGVu IFBhcmtlcg== OzsK IFJlYWxseQ== X25lZw== cGVuZGluZw== IG5vbWluZWU= IENhdGVnb3JpZXM= IFVsdHJh V2VhcG9u IGRlZmVuZGVy SXNz IEdlbmRlcg== IERyZXNz IGltcHJpc29u IGJhbmtydXB0 aW1lbnNpb25hbA== UEhB IFN0cmF0ZWc= IFBST0ZJVFM= IHBhdHJp Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8= ZGVsZWdhdGU= IGZvclN0YXRl IGRldm90ZWQ= X21ha2U= IHRlcnJvcmlzdHM= IFNuYXA= X25hdg== IEFB IElhbg== CWFwcA== UGxhY2VtZW50 X2hkcg== PEs= IHNhbmc= c3Ryb2tl LVE= Pjw/PQ== LW1vZGVs YXZhbmE= IFdhbmc= ICAgICAgICAgICAgIAo= CWluaXQ= IGVudHJlcHJlbmV1cg== YXRpdm8= TG92ZQ== LW92ZXI= V2F0ZXI= IG1vZHM= Z2VuY2U= VGVjaG4= Png= LlRhc2s= bW9uZXk= aWJhYmE= J30pOwo= IFNwZWNpZmlj IExpbmVhcg== X09QVA== SGFzaENvZGU= KFBsYXllcg== LkNvbnRhaW5zS2V5 IGNvbGxhcHNlZA== dHJhbnNwYXJlbnQ= X1JBTkdF Vmlld2Vy KGNmZw== IHNvcnRpbmc= IGluZmVjdGVk IE5hY2g= IGFjY29tbW9kYXRl LmVsZW1lbnRz X1BBUlQ= IFNleHk= PWdldA== KHllYXI= IHhocg== Ol0= b3dza2k= IHN1bW1hcg== IMK/ IGludGU= IHdvcmtmbG93 IFRhaXdhbg== dmVyc2lvbnM= 5Y+R IHN1cnByaXNpbmdseQ== IG9wdGljYWw= IHByb2Nlcw== IGRpc2FncmVl IG51ZXZv IENBTQ== c29ydGVk bGVhc2Vz aXN0bGU= SWRlbnQ= CWV2ZW50 amVjdGVk Q2h1bms= VmFycw== LnByb3ZpZGVy IHByb2NlZWRpbmdz IGluY2x1c2l2ZQ== IGFydHdvcms= ZW5kYW50cw== 77yaCg== c2Vlbg== IGxpZw== IG1ha2Vycw== X2Z1bg== IGxlbmd0aHM= UGF0aFZhcmlhYmxl W2l0ZW0= 4Li1 RGVhZA== RkZGRkZG IFVyYmFu dXBsZXM= aWNoZW4= KG51bGxwdHI= LnNwZWM= LFN5c3RlbQ== VVJBVElPTg== KGpvYg== 5byP IHRyYWNrZXI= xZk= IE1S IFNRTGl0ZQ== IGR0bw== IDs7Cg== IG1pbnQ= IEludHJvZHVjdGlvbg== Y2Fv IHF1ZXN0aW9uZWQ= IGZpdHRlZA== cmV2aXNpb24= c3E= IG1pZw== X3VuaXRz X2FzeW5j IGZsaWNr fSk7CgoK IG5vdHJl fWAs RmlsdGVycw== IG11bmRv X2RheXM= IGZybQ== dXRj IHZhbHM= ZXdpZHRo IEdlbmVyYXRvcg== IEFydGlzdA== IElEcw== IEFydGljbGVz cmVhdGVy IENvbXBvbmVudEZpeHR1cmU= Lj0= IHJvdQ== LW5v LmJ1a2tpdA== ZWdn IERpZmY= YXRpY3M= 0YPRhw== 4oCUCgo= IENoYXJsb3R0ZQ== Ynll IH0pOw0KDQo= IFZpaw== IEJyb3c= IGx2 IEdpYg== LXdpbmc= R0xJR0VOQ0U= KEls IEVuZ2luZWVy LldhaXQ= IFBpY3R1cmVz IHJoZXQ= IHRoZXJtYWw= IHByYWlzZQ== PD4oKTsKCg== IFNwaWRlcg== UGF1c2U= IEJha2Vy IHNsb3dlcg== IH1dCg== X2VucXVldWU= IGRpc2FwcGVhcmVk IFRpY2tldA== SU5VWA== X0xPQ0FM 0LDRgdGB QEluamVjdGFibGU= Y29tbXVuaXR5 R2VzdHVyZVJlY29nbml6ZXI= 5Zu9 IHNjYWxlcw== IC0o Lycr IFNpdA== IGV4ZWN1dGl2ZXM= YXJkaW5n IGFkdmVycw== IGJhY2t3YXJkcw== CWNvbnRleHQ= IEhhbXA= IFBG IERlY2s= IENyYWln QW1lcmljYW4= IGJlbGw= IHByb2w= dWZlbg== IHJuZw== YXJzaGFs IFNpbXBseQ== Zmlyc3RuYW1l c2hvcmU= SnVseQ== IG1vcnRhbGl0eQ== IOKGkgoK SGVscGVycw== IGJlbmNobWFyaw== ZW1hZGU= IG9yZ2FuaXNhdGlvbnM= Lmdzb24= IFRleHRGaWVsZA== IGNpdmlsaWFucw== LkFycmF5cw== IE1pc3Npc3NpcHBp IGludGVybWVkaWF0ZQ== Z2V0VXNlcg== X2NsdXN0ZXI= UmVsYXRpdmU= Zm9yZWlnbg== LnF1ZXJ5U2VsZWN0b3JBbGw= Rm9yZWlnbktleQ== IHJlYXNvbmFibHk= LS0tLS0tLS0tCg== Q2FyZHM= IEthbQ== IFRob3I= IHJvbGxlcg== LWVsZW1lbnQ= IEN1cnJlbmN5 ZGRpZQ== QUxMWQ== IFJB IHBlcm1ldA== YWFhYQ== IGhvbWV3b3Jr IFZpdA== IG1vbGQ= IEZlcg== W3N0YXJ0 IHN0YXRpc3RpY2Fs IHNjYXJ5 X0hPTUU= LkJlZ2lu Q29uc3RydWN0 b2dlbmlj IERFQUxJTkdT IHRhbWJpw6lu aXhvbg== LmluZA== YWNyZQ== IHRyYW5zZm9ybXM= IE5hcA== LkJsb2Nr dXNzaWE= cGlyYXRpb24= dWxlbnQ= IGNlaWw= Q2xhdXNl bmFpcmU= VEVT IG5lYXQ= U1RE IFJlZ0V4cA== cGVyZm9ybQ== Oik= IHVuaW9ucw== IHN1YmxpYw== IHdpbmRz bG9hdGluZw== Z2xpY2g= IHBhZ2luYXRpb24= U2tpbGw= QXBwbHk= IE9wZXJhdG9y aXN0b2dyYW0= IHF1YWxpdGllcw== Q3Jvc3M= IGRlY29t XSwi IEp1YW4= Lm1vZGFs LkNoaWxk IFJvZ2Vy U1RJVFVURQ== OkNHUmVjdE1ha2U= YWxldHRl IHN0YQ== YXNpZGU= IGJsdXI= IFdh aWZldGltZQ== cmVlZA== Y29udHJvbHM= IGJpbnM= INC/0L7Quw== Ki8sCg== VUlT IFJvdQ== IERlbW8= LWF3ZXNvbWU= IENoYWlu IGhhc3Rh IEJhcnQ= LktFWQ== IHZlbmRvcnM= bm9mb2xsb3c= IERlc3Q= X2J1aWxkZXI= IGFyZ3Vlcw== X2Fuc3dlcg== Z290bw== IFJFU1VMVA== IE1PTg== IHBvZGVy b29ucw== X0NBU0U= IHJlcGxpYw== IGZpbmFuY2luZw== IERBVEU= Y2Vybg== X3RyYWNr dGllcw== L2xvZ28= IE5FR0xJR0VOQ0U= Z2V0VHlwZQ== PlQ= YmV0 Z2lybA== IElOQ0lERU5UQUw= LXNpdGU= LnRyaWdnZXI= IExpc2E= X2lucHV0cw== IHJlbGF0aXZlcw== TG9nZ2VkSW4= Q29uZmlndXJl SUs= LmFjY2VwdA== UmVzdW1l IERyYWZ0 ICo+KA== IFdB ZWRpYW4= ZXJuZXNz IExheW91dEluZmxhdGVy Ki8NCg0K b3RoeQ== IG9ibGlnYXRpb24= U3Vic2NyaWJl IHRodW1ibmFpbA== ZXhpc3Q= IGluc2lzdGVk IFVJQ29sbGVjdGlvblZpZXc= IEFuZ3VsYXI= IHRhYmxldHM= IEltcGFjdA== 44CNCgo= YWhv IGNoYXJhY3RlcmlzdGlj Z2Q= ID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0= b3VydA== YC4= QXBwcm8= Q29vcmRpbmF0ZQ== UmVtZW1iZXI= IG1hcmluZQ== XT09Jw== IEFkbWluaXN0cmF0b3I= LmdldERlZmF1bHQ= IGZvcmdvdA== IFN0cnVjdHVyZQ== VnVl YXJzaW5n bW9tZW50 a3c= X2N1cnNvcg== QXR0YWNr IGF0aGxldGlj IGRpYWdub3NlZA== IGVuZGU= 5Yig6Zmk SG91c2U= IFBBUkFN IHdpa2k= IE9wcA== IGNvbnNlcnZhdGlvbg== IHNuZA== X3RlbQ== c3Vic3Ry IENhcGU= LnNpbQ== VVRJT04= YW5hbg== 4oCZdW4= IGd5 LXdvcms= IGNvbXBlbGxpbmc= PScj CXN1Yg== IGRpcmVjdG9yaWVz 7Yq4 IHRvdWNoZXM= b3V0aW5lcw== LkNvbGxlY3Rpb24= c2NoZWR1bGU= LmxhdA== IERvY3RyaW5l Q0FB IFJlZmVy IHNoaWZ0cw== IGxpa2VsaWhvb2Q= cHJldGVy IEZlbWFsZQ== IGludGVyY2VwdA== IGxvdQ== 55m7 IHJ1Zw== IENyb3du ICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= LXByb2R1Y3Q= IHByb21wdGVk dW5nbGU= ZG9ja2Vy IFR1 IFVuaXF1ZQ== X0Vycm9y dWxvcw== IOKE IChg R2V0dGluZw== X3NjYWw= IEVuaA== w7x0 IHN1c3RhaW5lZA== IHBhdGNoZXM= IHByb3NwZXI= IEdhemE= X2xpZ2h0 IGluY29ucw== LS0tLS0tLS0K CQkgICAgICA= U0Y= Q04= OiI7Cg== IENvbGxpbnM= KCop IGNvbXBpbGF0aW9u J10NCg== IGNvbnNlcXVlbmNl LC4uLg== IGRt IEJMT0NL Q2x1c3Rlcg== IHNraQ== KGFyZ2M= VHVwbGU= IGpvaW5z IFNoZXJpZmY= V2Fy aW5kaQ== IGNvbW1lbnRlZA== SE9TVA== IGludml0YXRpb24= YXBhbmVzZQ== IHBlcm1pdHM= cHJlY2VkZW50ZWQ= X3pvbmU= IEFteQ== X1JE TWluaW11bQ== IGludm9jYXRpb24= LmVuYWJsZQ== aWNodGVu LW93bmVk Imlk X1BPSU5URVI= RmFj IHNwZWNpZmljYXRpb25z IG5vbWluYXRpb24= IGdw PCg= IHJvYm90cw== IEplcnJ5 IGhvbGRlcnM= IHdhbmQ= Y21z IH0pKQo= LlRvYXN0 IElMaXN0 QmFzZWQ= em9vbQ== L3N0eWxl IEJlY2s= TWVu IGNvbnRyaWJ1dGluZw== IHVuZG8= IE9I IGFkZE9iamVjdA== IGVpZ2Vu c2lnbnVw 6ZSZ IGRpc3RhbnQ= UEFSQVRPUg== IE1hcmk= IG3DoQ== RW1w w7Nz IOyImA== ZXZ0 K2o= cGFyaw== IFN0YXk= IER1bg== IHNveQ== PiU= YXppbmVz IHRpZW1wbw== KG1l cHJlc2VudA== LlRoaXM= IGVkaXRvcnM= RklFTEQ= Lldvcms= IFVuaXZlcnNl IGRydW5r LnRpbWVy IGFsdGVyZWQ= IE5hcg== 66Cl LkFjdGl2ZQ== aWRvcg== 560= LmRlbHRhVGltZQ== IGF3a3dhcmQ= JnF1b3Q= IFNhZmFyaQ== IHRyaWNrcw== TUVOVFM= ZGl2aXNpb24= IHZhcnlpbmc= IEhpZ2h3YXk= IHBob3RvZ3JhcGhlcg== IFN0ZXdhcnQ= IGxhc3Rpbmc= LlByZQ== LmFtYXpvbmF3cw== IEx1Y2s= LkRlc2NyaXB0aW9u IE5heg== bmVn IGPDsw== PDwiXA== IFN1cnY= IFVuYw== UmVjaXBl LkJvcmRlclN0eWxl IG1vZGlmaWNhdGlvbnM= LWF0 QVRGT1JN aGRy YWtv IHN1YmxpY2Vuc2U= IEp1bXA= IGJlaW0= IE1hbmhhdHRhbg== LmJvb2w= X2h3 0YLRjA== Qmlu IGdhdGV3YXk= IiI6 IFVJUw== OiIr LWRlZg== IFJlZ3VsYXI= L3Rlc3Rpbmc= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= c3RyaW5nc3RyZWFt IGRpc3Bhcg== IG1vYmls LXJlYWQ= IEFkYXB0ZXI= IENoYW1waW9ucw== IHNjaGVkdWxlcg== IGtpbGxz IE11bHRpcGxl aXJyb3I= IGdvZHM= QURP YWt0ZQ== IFVzdWFyaW8= LmNpcmN1bGFy IHJlY2VwdA== IEV4cHI= IGVsZGVybHk= IG5pY2VseQ== IGJlc3Rl V2FudA== IGNsYXNzaWNhbA== LnNwcml0ZQ== b2JqYw== IE1hc29u IHNpc3RlbWE= LkJsYWNr ZXNv IFplaXQ= IGRpdmlk IGVudGVycw== X3N1YmplY3Q= IFBsYW5ldA== Lndhcm5pbmc= IEdyYW0= X3Rva2Vucw== IGhvdXNlaG9sZHM= X2N1c3RvbWVy dXNlck5hbWU= Y3Jvc3M= IHBpb25l IGFzc2lzdHM= X1NN aWJv IGxveWFs IHVzZWxlc3M= I2VsaWY= IFVsdGltYXRl Q29tZQ== Z2Vs IGRpY2g= eHl6 aWtlbA== b2JyYQ== X3NjYW4= IEludGVyaW9y IE5pY2U= IHBsYWM= CXRhcmdldA== IHZpcmFs YXNzbw== KCkv dW5kZQ== IEFkb2Jl T3M= dmlzaXRlZA== IE9X IEZlZWQ= IFNlcXVlbmNl IG1hbmFnZXM= aW5zb24= IExvdWlzaWFuYQ== e30p IEhhYg== IExE IGJpcA== cHJpdGVz KGVsZW0= LmhpYmVybmF0ZQ== w6lsw6k= IG9obmU= X3RyYW5zYWN0aW9u IGFubnVuY2k= UHVibGlzaGVk IEhvbmRh IFRhbQ== IFBhY2tldA== X3NlbGVjdG9y IGNoYWxsZW5nZWQ= UHJvY2Vzc2luZw== LWhvdmVy IHRyYWluZXI= X2NhbmNlbA== IE5TRGljdGlvbmFyeQ== YWJyaWM= IE1MUw== X3NlbnNvcg== IHNocmluaw== IEZY dGhyZXNob2xk CUhY LW1hcms= YC5g U2NoZW1l KGZ1bGw= X3dyaXRlcg== IFN5cw== IGZsZWQ= IENpbg== LXdpZGdldA== IFByZXZpb3Vz R2VuZGVy X3F1ZXN0aW9u RmVlZA== IHNjcnV0 KHByZWZpeA== 44CC44CC IGluZmVjdGlvbnM= UGFydHM= IGhpZXJhcmNoeQ== X0RFTEVURQ== IFBhdGllbnQ= X3BheQ== IHByb21vdGVk IOyL IGNpdmlsaWFu IGFncmljdWx0dXJl IFBpZWNl IHN0YW5jZQ== dXRzY2hl QXNzaWdu LkFDVElPTg== Rmln X3JhZGl1cw== IFN5bmM= ZHVjZXI= ZmFpbHVyZQ== ZW5zZWQ= cHRpbWU= Qk0= X2RhdGV0aW1l cXVpdm8= UVVFVUU= 6ICF QXBwZWFy IHN1bW1pdA== OnZvaWQ= IHZpbmU= 6K6k b25uZQ== X1RSQU5T LmdyZWVu X2Nj IGh1bmdyeQ== ICI+ KCkpOw0KDQo= RXh0cmFjdA== aXplbnM= IHNvbHZlcg== Tm90aWZ5 IGVuZ2xpc2g= IFNob3BwaW5n aW50ZXJmYWNlcw== UkVR IGlsbGVn IFVJSW1hZ2VWaWV3 IGRpc2Nvbm5lY3Q= IFVudGls IENvbnNlcnZhdGl2ZQ== QENvbHVtbg== IHNoaWZ0ZWQ= IDoNCg== IGZpY2g= IGRsYQ== IHNob2U= IiksDQo= dWxhcml0eQ== X1JFU1A= V2VhdGhlcg== VUlBcHBsaWNhdGlvbg== Lml0ZXJhdG9y IGFnaW5n LlBhcmVudA== b3dpZQ== KGVxdWFs IENvbnY= L2RlZmF1bHQ= IG1lYXN1cmluZw== LnByZXY= LklzVmFsaWQ= LkZhdA== IHPEgw== a2V5d29yZHM= d2l0aG91dA== IHNvdmVyZQ== IGV4Y2hhbmdlcw== IG1lbHQ= IGlzbGFuZHM= IEludGVncg== IGp1bXBpbmc= IGdsZQ== IGpvdXJuYWxpc20= IGRhdGVk TG9jYWxpemVk IFJlZnJlc2g= UGFydGljbGU= IGFh IFNUUklDVA== IGJvZA== LlByb2Nlc3M= X0FVVE8= IFB1Ymxpc2hlZA== ZXZlcnk= IHRlY2hub2xvZ2ljYWw= bHN4 IGlycml0 QWRkaXRpb25hbA== IGRlbGltaXRlcg== X2xhbmd1YWdl LWFyZWE= Ym95cw== IFR1YmU= IHdhdA== IG1lY2hhbmljcw== X293bmVy U3BlbGw= IFN0b3JpZXM= LkFwcGVuZExpbmU= VGFibGVWaWV3 aGVt c3RpY2s= b2xsb3dlcg== SUZG IFVW b2xsaXNpb24= U1VC IGNvbXBhcmFibGU= IGRvbmRl c2FsZXM= bGx2bQ== IH1dLAo= T1RUT00= IFB1cnBvc2U= TGFi IGludGVydmlld2Vk b2lz YXNpbA== LnNldElk IEluc3RydWN0aW9u LS0+ IE1vZGlmaWVk YXRpb25hbGx5 IE1lZXRpbmc= 6K+v I3JlZ2lvbg== IHJvdXRpbmc= LmZvY3Vz IFlvdXRo PEQ= IE5hZw== Y29udGFjdHM= IGZvcm1pbmc= IG1pZQ== JyxbJy4uLw== IEJQ IGFwcGV0 IFRlYWNoZXI= IFRQ IGFubnVhbGx5 b3V0ZWRFdmVudEFyZ3M= IFNwZWFrZXI= IHJlbmFtZQ== Q0ZH KCIvLw== 5o6l L3BhZ2Vz IHByw6lz IFNwZWxs LkFsbG93 IElOVEVSUlU= ICgj 4oCZCgo= X0dlbmVyaWM= Lmltc2hvdw== X3RpbQ== LWZhY2U= KCYo YXRpbnVt IHJldm9sdXRpb25hcnk= IEhvdXJz cmFpbg== IGFueXRpbWU= IGFiYg== LmpzcA== U2Nyb2xsVmlldw== IFRydXRo IGFudGljaXBhdGVk IGFjY2VudA== LmNoZWNrZWQ= IHNwZWNpZmllcw== IGNhZg== IGNlbGxwYWRkaW5n IGNvb2tlZA== IEh1Z2g= cGVlaw== X1JBVEU= IGRvcm0= Lw0K SVZJVFk= LkNvbnRyb2xsZXI= KHBhcnQ= LmNvbnN0cmFpbnQ= IGludmFzaW9u TU9WRQ== IGdsdWM= bGVuYW1l IGFtZW4= ZW5nbGlzaA== IFN3aXR6ZXJsYW5k IjsKCgo= cGVzdA== LmNvbGxlY3Q= Tmli IERpY3Q= IEVtYg== KHN1YmplY3Q= IG91dHJhZ2U= IGRlY2lkaW5n IHNlbnRlbmNlZA== RmVjaGE= IkE= IHF1ZXI= IGZvbnRGYW1pbHk= IHF1YWRy LVk= X0NBQ0hF IGFuYWx5emVk IGdhaW5pbmc= IEFnYWluc3Q= IFNvdWw= dGF1 IGxpZ2h0d2VpZ2h0 IFRG IEVmZmVjdHM= LlR5cGVz LmFkZENsYXNz IHZlZ2Fu 6YE= Lici IEV4cGxvcmVy LmRldGVjdA== LnNoaWZ0 IG9ibGlnYXRpb25z bGFzdE5hbWU= IGFzc29jaWF0aW9ucw== IFRpbWVTcGFu dW50ZXI= IEZyZXNo Q29tcGF0aWJsZQ== UHVi aWRnZXM= Lm9wdGlvbg== dmFyaQ== Lmhhc2hDb2Rl IGdlYg== LnNlY3Rpb24= LW5vdA== IFN1Ym1pdA== VE4= cmVnaXN0cnk= X21lZGlh IG5hag== ZmZ0 IG1hdGU= LXRoaXJk IHBvY2tldHM= ZXN0YQ== IGJlbnQ= IE5vcmQ= IHJldGFpbGVycw== IE1vcnJpcw== LiIiIgoK V3Jvbmc= IMWb UmF5 LmVj IEJpbmQ= X0hBTkQ= KG5vbg== aXNWYWxpZA== IHNpbWlsYXJseQ== X0xJTUlU IGR5bmFtaWNz IGRpc3RpbmN0aW9u 44GG PE4= IG9ydGg= IFRveW90YQ== IEthdGU= IExT b3JpZQ== IFNwcmluZ3M= IGZyZWFr bGFzdG5hbWU= X01VTFQ= LXN0ZXA= Iig= QUREUg== IGVudGVydGFpbmluZw== X0NPTkY= IGRlY29kZWQ= IHN0cmVhaw== IHdhaXRlZA== IG5vdGlmaWVk cm9kdWNlZA== dmlzdWFs LkxheW91dFBhcmFtcw== 5rA= ZXNpYW4= Zml0cw== c3ByaW5n IEJlcm5pZQ== VXNlckRlZmF1bHRz IHBlZGVzdA== QXBwZWFyYW5jZQ== IFdpa2k= IE5PVElDRQ== IHNzaA== IGR1cmFudGU= IFppcA== xLFy IE5BVE8= IHR3ZWx2ZQ== IHJveWFs 77g= IG1lcmNoYW50 IEZ1cm5pdHVyZQ== J10pLAo= LFg= IGZvbGRlcnM= IEdhdGU= CWZ1bmM= cGljaw== X3VzdWFyaW8= IFZlcm0= bWVudGlvbg== dXJwb3Nl IGFsZXJ0cw== eGlvdXM= X3NpZw== IEZ1 ICg6 IGR1bWI= 5YWz IGFjY3VyYXRlbHk= 6YeN UkI= LXNjcmVlbg== IFZFUg== am91cg== IHJvbWFuY2U= dWNjZWVk LmNob2ljZQ== IGFkaXA= X2RpbXM= U2VyaWFsaXphYmxl 44KL LmpvYg== IHByb2c= dWNoYXI= IGdlbnRseQ== IFJTUw== aWN0dXJlZA== X0VOQUJMRUQ= CWxhYmVs YXdrcw== IEVuc3VyZQ== cmVtZW1iZXI= 7KCV IHRyYW5zbWl0 e3sk LlRyYW5zYWN0aW9u dXJzZQ== X3JlbGF0aXZl IHNpemVk IFhY IFByaW5jZXNz IExhcnJ5 IHByw7M= INGB0YLRgA== IHNpc3RlcnM= ZXN0cnVjdA== IGNoZWNrcG9pbnQ= Omxlbmd0aA== IENhcmxvcw== L2ljb24= X1RBUkdFVA== VG9rZW5z IHBhdGllbmNl IFNlbGVjdGVk cXR5 LnNob3dNZXNzYWdl IHdpbGRsaWZl IFByb3Bz Ym0= LWFycm93 IHBhcmNlbA== ZmlyZWJhc2U= IEJlbmphbWlu Y2Vzc28= LnRpbQ== IEdhcmM= LmFueQ== IEhPV0VWRVI= IEtv IGdyYWJiZWQ= X2ZyYW1lcw== IG9iamVjdEF0SW5kZXg= IEFEVklTRUQ= IHN1YnVy CUdM IH0pfQo= LWxlbmd0aA== 7Iuc IFBvdHRlcg== X2J1ZmY= Lmd1aQ== IEVuY29kaW5n RWxlY3Q= LW1lc3NhZ2U= IO+/vQ== IMiZaQ== IEFyZ3VtZW50TnVsbEV4Y2VwdGlvbg== 0LDRhtC4 IG1pbmltaXpl IHJlc3BvbmRpbmc= JF9bJw== IEluZGl2aWR1YWw= w6Fj IElOVEVS IG1hc3R1cmI= IEJpbg== KCck 65Oc IG9wZW5seQ== ID48 IHVudG8= b2xvZ2ljYWxseQ== IE11bA== VklESUE= IHNsaW0= IENvbW1pc3Npb25lcg== KG9u IHVuZGVybmVhdGg= L2Ri dm90ZQ== KE1lc3NhZ2U= IFBvcGU= RGVmaW5lZA== IHN3aWZ0 dXJm IGFkYXB0ZWQ= U0VM IHJldmVudWVz IGRpdmluZQ== PXk= R3JhZGllbnQ= X2FjdA== IC8qITw= IHBvbHlnb24= IEZEQQ== IENhcnI= YXRhYmxlcw== KHN0ZG91dA== IHJlZnJpZ2Vy IGNvb3JkaW4= YXZvcml0ZXM= 0YjQuA== IGNvbXBhc3Npb24= IFBPU1NJQklMSVRZ LXNlY29uZGFyeQ== dXJhY3k= IGNvbXByb21pc2U= X0FW X29z IGJlc2lkZQ== g50= IGxu LnBsdWdpbnM= Q2FwYWNpdHk= YWxhaA== LmJpbg== IENSQw== X2JhbGFuY2U= IGZsZXhEaXJlY3Rpb24= IGFtYml0 IG5pY2tuYW1l IEZvcmNlcw== Q0xF IFNoZWxs IHNhaWw= IFdyaXRlcg== IEFsaWNl ZHc= IEluZGlhbnM= IE1hcnNoYWxs X1NSQw== IG5vcm1hbGl6ZWQ= IEphZw== 44KS emVpdA== cnBj w61j LmlubGluZQ== IHRyYXZlcnM= X251bWVyaWM= IHV0aWxpdGllcw== IGV2YWM= SU5QVVQ= CXJlZ2lzdGVy TVg= IENhbXBiZWxs IGRhdGFzZXRz IGRlbWFuZGVk IGluaXRpYWxTdGF0ZQ== Z2Fu IGVp VW5leHBlY3RlZA== LXdlYg== dHJhaXQ= LFk= IFRvZGQ= IHNrZWxldG9u IG9wdGltaXpl 56ys IFVwb24= IFN0T2JqZWN0 IGFwbGlj Lic8Lw== QUND YWxvdXM= IGhhc2hDb2Rl IEJpYg== SU5BTA== IGludmlzaWJsZQ== IGhldGVy IHNhZmVy fS8v LnRoZW1l Lm5hdmlnYXRpb25Db250cm9sbGVy X21lc2g= c2tpbGw= IFZpb2w= wrI= IEVPRg== IEtp eW1tZXRyaWM= IG1heGxlbmd0aA== xaM= ZnJpZW5kcw== IEV2YW5z IGxlbW9u ICgu U2xpZGU= IFRoYWlsYW5k IENhbm4= IGFtZW5k IGNpcg== IHNpbGx5 ZXNpbWFs X3BpYw== cHJvY2Vzc29y SmF2YVNjcmlwdA== IGV2aWRlbnQ= X2Rp PlA= dnJvbg== LlVO IHBhaW50ZXI= aXphcnJl IGxhdg== IHBvbQ== cHJlZw== PWZ1bmN0aW9u KHNlcmlhbA== aWZpY2E= dW1pbmc= 5Zyw 44GC LW9w VUNI IEhlbmQ= LnByb3BUeXBlcw== IHlv IHJvdXRpbmVz IGNhcmluZw== U2Vt IHJlc2VydmVz IHByaW9yaXRpZXM= cmVkaXRz SVNUUg== Q29udGVudFR5cGU= IFNjaHc= L21lZGlh IGVzdHI= IGNsaW1iaW5n LXdlZWs= Y2hlcmNoZQ== c2Vuc29y VG9BcnJheQ== IE1vbnRyZWFs IGNsb3Vkcw== IEluamVjdGFibGU= IFJpY2U= IHByb3BhZ2FuZGE= X3Byb3ZpZGVy IGluZG9vcg== IGluYXVn IGRpcGxvbQ== IG1lc3NhZ2luZw== X211dA== 5aaC IGt3 T05T YXJpYW5z UlBD KV0NCg== LXJheQ== IFNvcg== bWFsbA== IG1hcmtldHBsYWNl IHZ0aw== TWE= b2dhbg== aWdp IHNwb25zb3JlZA== IERhbmk= LlNFVkVS PicuJA== bXVsdGlwYXJ0 IFdvbA== IHRhYmxlTmFtZQ== IFVzZXJuYW1l QmFja2dyb3VuZENvbG9y IGZyaWdodA== X0VNQUlM U2VwdGVtYmVy X3ZhbHM= b3BpYQ== IHNwb3R0ZWQ= LUNo IGRhdGFTb3VyY2U= LyIK 0LXQutGC IFJlcXVlc3RNZXRob2Q= IFJlcGxhY2U= LWRv YWhu IFBoRA== XS4KCg== Tk9O Z2VtZW50 IFRocg== IHF1aWV0bHk= IHRvcnR1cmU= IHRlYXM= IENZ IGF0cg== ZGV2ZWxvcG1lbnQ= LWRldGFpbA== IGxpZ2h0ZXI= IGFyZ3Vpbmc= IGRlc2VydmVz IGN1cnJpY3VsdW0= X0NPTlRFWFQ= xYJ5 SElURQ== CUlE L3VwbG9hZHM= IHRpdHM= cmVv X2Ryb3A= LlVURg== IHBpY2t1cA== IGdyb2Nlcnk= IFB1cmU= IGVhc2llc3Q= UGhpbA== LmZlYXR1cmU= KCIq IGludmVzdG9y dG9r IGphcg== TG9z 4oCU4oCU4oCU4oCU4oCU4oCU4oCU4oCU LnF1ZXVl LXNwZWVk TWFs dW1ibHI= IENPTlNU IEhSRVNVTFQ= IERhbmNl KGZpbGVQYXRo IGF0dHJpYnV0ZWQ= 4KWN IEJ1bmQ= Y29pbnM= IHPDo28= IHBpcg== cGVyc29uYWw= IHByZWxpbQ== IHByb3Bvc2U= IFRM XV0p IFN1YnNjcmlwdGlvbg== IEtyZQ== LGxlbg== LkZpcnN0T3JEZWZhdWx0 KS0t X3Byb2R1Y3Rz LkdldEJ5dGVz U2hpcA== IGVuY3J5cHQ= IFNH IE15c3Q= aGly IGl0ZXJhdGU= IGludGVuZA== Lm1vY2tpdG8= IGNoYXB0ZXJz KGFuZ2xl IFZsYWQ= 6K6+ Jy4KCg== UmVzcG9uc2VCb2R5 IEFiZA== ZGVhbA== IGJhcnJpZXJz LW91dGxpbmU= YmlsbA== IEZhbGxz X3NlY29uZA== LmluY2x1ZGU= LmNlaWw= IG9jY3VwYXRpb24= cGhvbnk= Lm1vdmVUbw== IEplbm5pZmVy QVNURVI= OyI+PA== IEVuYWJsZWQ= IHRlcm1pbmF0ZQ== IElv bGF0aW9ucw== IFRIRU9SWQ== IGVhcmxpZXN0 IHJhY2s= IFNjYXI= c2hha2U= Y2hpcA== IHV2 IGFsbGlhbmNl 0L/QuNGB IEdPT0RT emlvbmU= IFZJ IHst IGZpbHRlcmluZw== IG1pc2Nvbg== LkRvY2tTdHlsZQ== IGJ1c2g= IGp1bms= 5ow= IFFVRQ== IGhvb2tz IGZpcm13YXJl IG1pZGRsZXdhcmU= ZGlj IE9ha2xhbmQ= IGFycml2ZXM= UGF5bG9hZA== cGl4ZWw= XXw= IHN0YXJ0RGF0ZQ== LlBSTw== X2F1ZGlv IG1pZGZpZWxk aWdpZGJvZHk= IFN3aXNz IENsaXA= IER1bXA= IFRleHRCb3g= IGdlaA== eWllbGQ= b2Rz IHJlZmVyZW5kdW0= QmFja2VuZA== IENyZWFt IGRvbWluYXRlZA== IEFyY2hpdmU= IHJpZGVycw== LnByZXBhcmVTdGF0ZW1lbnQ= IHF1YW5kbw== IGNoZWY= d2lraQ== aW5lbA== YW1wbGluZw== KCJcXA== IHNhZw== X3Byb3h5 44GV cGRv LmdldEVsZW1lbnRzQnlUYWdOYW1l IGRlbW9uc3RyYXRpb24= IE5QQw== IGFyY2hpdm8= ZW5kYW5jZQ== IGVmZmljaWVudGx5 KGFjdHVhbA== LnRhYmxlVmlldw== IG11c2g= IGJlYXJz X3RocmVhZHM= amFz YWh1bg== IG5ldXJhbA== IGRlc2lnbmluZw== IEdEUA== IGxpZnRlZA== 55uu IEpvaW50 IEluY2x1ZGU= IEdpYW50cw== IHdpdGhkcmF3YWw= IFJlbnQ= bmF0aXZl IFNlZWs= Z3Jlc3Npb24= X0NQVQ== XFM= IFNoaWVsZA== IHNvbGlj IGJvb20= eWVjdG8= IG1hbnVmYWN0dXJl IOKAiw== IGJib3g= IGVhcnRocXU= b2xsZWN0b3Jz OkAiJQ== IGxvb3Bz SmU= YWxraW5n IFdoYXRz IEJveXM= LmJvb2s= QVJHRQ== X3BpeGVs IHN1c3BlY3Rz zrk= dXNw IEJNVw== aWVjZXM= KHBlcnNvbg== 5byA 6bs= IFBvZGNhc3Q= IGJvdQ== KEl0ZW0= w7s= KElucHV0 SHR0cEdldA== IGJ1cmc= KV4= Qk9BUkQ= Ki8s IGd1bHA= IEJlbm4= IGRlY2tz LnN0YXR1c0NvZGU= IGFjdXRl IGh1Zw== dWd1 IHBsZWQ= LCIl aGFwZQ== INC30LDQvw== IE1haW5l LnJlYWw= IGRhbGFt IE1pbm9y LkZsb2F0 ZGlzcA== IHRs IGVuY291bnQ= PT4k IGZn dGVlcw== IFJlY29tbQ== w6Rs IGNoZW1pc3RyeQ== QmxvY2tz T0lE IGZvcmV4 IEFwcGVuZA== IHsq IFN1cHBseQ== Q0dGbG9hdA== KGJs IGF0ZQ== YWRvcmE= IGd1c3Q= QXNzb2Np Pi4K RkVUQ0g= LnNlcmlhbA== d2lkZ2V0cw== YXJkbGVzcw== aWVmcw== X0ZVTEw= ZXJuZXRlcw== IFByZWQ= 2K0= 5LqL dWJlcm5ldGVz IExhdXJh IGxhYmVsZWQ= SGlnaGxpZ2h0 IGFubm95aW5n L3VwZGF0ZQ== KGRlc2NyaXB0aW9u IGludGltaWQ= JGM= IikpKQo= LkFQ IFtdKg== IEVYSVQ= Lkhvc3Q= IE9QRU4= LnNlbmRNZXNzYWdl X2NhbWVyYQ== X3RpbGU= IHRoZXJt b25vbW91cw== IGRpc2Fkdg== IG5hYXI= aW5kZXhPZg== IFBQ LnByb3RvY29s QUZF IHRleHR1cmVz IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMj dW1iYWk= LnN0YXRz IEdF IGll IFNURA== IE1hbm4= LnJlZmxlY3Q= S0I= IGRpdmU= Lndhdg== LyotLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t L3NldHRpbmdz LmxpZmVjeWNsZQ== IGRhdWdodGVycw== b3J1cw== dWJlcg== TklORw== c3RyaQ== IFRpcA== IHpu IHN3aXRjaGVk aW5ldA== dWZmeQ== IFRyYW5zcG9ydGF0aW9u KGNvbmY= ZnJpY2E= IFhM IExlYWQ= X3BlcmNlbnQ= PE1hcA== IHRocnVzdA== b3Ji aWtr IHRyYXVtYQ== QWNjZXNzb3I= IEZpdA== IFN0cmluZ0J1ZmZlcg== ZXhwbA== KHNjcmVlbg== IGF1ZGllbmNlcw== IE9QVElPTg== X3JvdW5k W25vZGU= YmVo LT5fXw== cGVybWlzc2lvbnM= IERldGVybWluZQ== Lk1hbg== IGFkdmFuY2Vz LklucHV0U3RyZWFt IHN0cm9uZ2VzdA== IGVCYXk= ICMt IGRpcm5hbWU= IFNNUw== IG1lZGljYXRpb25z IGFtZW5kZWQ= IGNodXJjaGVz IEltcGVyaWFs JHJvdw== IE1hZGlzb24= IEluc3A= IGFmZmFpcg== IHBzeWNob2xvZ3k= dmg= IHNldmVyaXR5 4oCQ IHN0cmlwcw== QUg= dmVydGlzaW5n IGNvbnNl SU1BR0U= IFN0YXRz CXNj LkN1cnNvcg== IGZyZWV6ZQ== c3Nvbg== KHhtbA== IFN1c2Fu LnRpbGU= ZWRlZA== ICAgIAkJCQ== dWVsbGU= IE1pdGNoZWxs YmFzZWQ= T3BlcmFuZA== veaVsA== IEZG CXN0cmNweQ== b3VuY2Vz aWxkbw== LmV4ZWN1dGVRdWVyeQ== IGFwcHJvYWNoaW5n IFNldmVu IG51dHM= IHJpYw== YXNzaWdubWVudA== IGNhbGN1bGF0b3I= IE11cnBoeQ== IEJvdQ== 7YQ= IGJ1dHQ= IHRpY2tz UHJvamVjdHM= aWxpYg== LnRleHRDb2xvcg== bW92 X2xvZ28= KHRlbXBsYXRl IElOSVQ= IGltYWdlVmlldw== c2NyaXB0aW9ucw== T1JJVFk= Q29uc3VtZXI= IHVucHJlY2VkZW50ZWQ= IHRvdXJpc3Q= IGJyb24= IGNvbnRyYWN0b3I= IGxpY2VuY2U= IE5hbQ== 5q8= KHRyYW5zZm9ybQ== X0FUVA== UHJlZg== IEdhbQ== IHZlc3NlbHM= IGhhdg== TGF0ZXI= LlRvTG93ZXI= IHVybHM= IGJyZWFrZG93bg== IHBlbmFsdGllcw== IGZvc3Rlcg== IFVF IGNsdWU= Y29tZWQ= 5ZCN56ew LW1haW4= IHB0cw== IGNvdW50ZWQ= aWN0cw== L3Bvc3Q= IGdldGF0dHI= IHBpbmc= QU5DRUw= IHBlYw== 0YXQvtC0 YW50b20= IEJsdWVwcmludA== IEV2ZW50RW1pdHRlcg== IGzDpA== 5rI= IHN0cmF3 KGNvbXA= J3VuZQ== Pk4= LWNsaWVudA== ZXNNb2R1bGU= LWJhc2U= IHJldHJlYXQ= X3NpbXBsZQ== CQkJCQkJIA== ZmVl JykNCg0K Q29udHJvbEl0ZW0= IHN1YnNjcmliZXJz cGxlYXNl IEVmZg== IHBvdW5k IEJ5dGVz IFRlYQ== X2FjdGl2aXR5 IG1heGlt IG9wY29kZQ== QlNE LmNvbnN0YW50 O30= b21icmVz IGNhcmVlcnM= KS4KCgoK IHNwcmVhZGluZw== LWV4cGFuZGVk IE9yZA== YW1hcmlu IG1vYmlsaXR5 VW5mb3J0dW5hdGVseQ== YWtr Tkw= X3JlZGlyZWN0 IFBH IFNlbnNvcg== Ym9s dGFw X01FTU9SWQ== IFVJQWxlcnQ= cGxpdHVkZQ== V2Vic2l0ZQ== IExvZ28= bG92ZQ== W2luZA== IGFsdG9nZXRoZXI= IHdvbmRlcmVk IGVzcGVy IExpYmVyYWw= IG9zcw== IGVsaXQ= IHN0aWZm b2RveA== X21lbnRpb25z IERvdWdsYXM= X3BpZA== IENL IGluaXRXaXRoRnJhbWU= LmJsb2c= cGtn YW5naGFp UVVJUkVE dXU= IG1rZGly QVRBTA== IHVuaA== aW5jZXM= c3Ro IGh5cG90aGVzaXM= IGNhdGE= IFRC IENsYXI= IHByZWRlY2Vzcw== IHNpdHVhdGVk LXdvcmxk KSkv IGhlYWRsaW5lcw== LnN0YXQ= IG91dGJyZWFr c3BhdGg= X0ZMQUdT IFNlcnZsZXRFeGNlcHRpb24= U3Vu RlJPTQ== IERpcg== 44O744O744O7 X2Nvb3Jk IE9wdGlt TW9uaXRvcg== LmJpdA== WFhY IHRvZGFz ZmVsZA== 0YDQuA== aW1pcg== IHBvbGl0aWNhbGx5 IG1vbGVjdWxhcg== IHRyYWRlZA== IHt7JA== IFN3ZWRpc2g= ICdALw== X1JFQUw= IHdhcmVob3VzZQ== dG9kYXk= LEw= b3Jw PHNlY3Rpb24= LWJy eW1l IFVzZXJTZXJ2aWNl IGxpYmVydHk= IG1vbWVudG8= KEltYWdl PHNpemU= U2No IGpvZw== aW9sb2d5 YXJlbnRseQ== IHF1YW50dW0= IEFidQ== IHJpbQ== IG1hbmE= Rm9udFNpemU= QnVpbGRpbmc= c3RhaXJz QUlMQUJMRQ== ICYn IHNlY3Q= IHNpZ2g= KGJhdGNo LklDb250YWluZXI= cG9sbA== IENvcnBz zrU= YXJ1 IEtheQ== LnJhbmdl X2NsaWNrZWQ= IFJvYmVydHM= Lk5ldHdvcms= ZmluaXNo LU1hbg== IGNvbGxlZ2Vz IEZpbmU= IikpLAo= ZmlsbQ== IHJlbWluZGVk IGdlc3R1cmU= b3V0aWw= IHRocmVhZGluZw== IG9iamV0 IHRvdXJz YWN0aXZhdGVk Lm1rZGly PXVzZXI= IHJlZGU= ZsO8 X1NZU1RFTQ== cHY= IGNvbmdy IG1hc3Nhc2pl IHByYWN0aXRpb24= VW5pdmVyc2l0eQ== IHRhYmluZGV4 0Jg= U2V0cw== IGNvdW50aWVz Z3Vlc3Q= ZmFu IHdvcmRlbg== LmRp 0L3QsNGH wr8= aWdEZWNpbWFs IHNob3Jl IGfDtg== IHJlcGFpcnM= IGhlbHBlcnM= IGNlbnRlcmVk T0xMT1c= IG1hcFN0YXRlVG9Qcm9wcw== IGNlbnRz PEE= IGV4cGVjdGF0aW9u T2N0b2Jlcg== IGJnY29sb3I= Y2FsZXM= LkNPTg== IFZlbA== IGNyeWluZw== LXNlYXNvbg== IGZ1bmN0aW9uaW5n X0xPQ0FUSU9O w7xzcw== YmVyeQ== UGFyYQ== b21pbmF0b3I= LWxl IGV0aGljYWw= aGFzaHRhZ3M= ZW1wbG8= IG7Dum1lcm8= KGFjdGl2aXR5 LlN0b3A= LnN0cmZ0aW1l SUxE IHRvZQ== CU5vZGU= IikNCg0K IFB1ZXJ0bw== IGV4ZWN1dGluZw== IEdVSUQ= IG9wcG9zaW5n YWxwaA== IGV4aGliaXQ= X2ZsYXNo IG1laWxsZQ== IGpzb25PYmplY3Q= SGVybw== YWludGVk X0RPTQ== IHdpbA== IHNsb3Bl IG3DpQ== IElyYXFp IG9yZ2FuaXpl CWpRdWVyeQ== SFVE c2hpbmU= Lndl IFNraWxscw== cG9uc29y IGNvbmNsdXNpb25z IHJlZm9ybXM= IHJlbHVjdA== bmFtZWQ= IE9saXZlcg== IC8vfQo= LWxvb2tpbmc= IGZvZw== IEhP IEZyaWVk IGluZXZpdGFibGU= IERhdGFHcmlkVmlldw== SG91cg== aWxsZXM= bG9naWNhbA== IGNvbm5lY3Rpdml0eQ== LnR3aWc= IEt5bGU= KGRzdA== LVNo IFN0dWRpb3M= KExldmVs LmpldA== X1BST1RP LWRlY29yYXRpb24= T1RIRVI= IHJlYWRpbHk= LlBhcmFtZXRlcg== IG11bHRpcGx5 IExJQg== YXJtZWQ= IHNvb25lcg== 5oQ= X0VT IGZvc3NpbA== IEFuYw== 4oCcVGhpcw== bG9kYXNo UHl0aG9u IGhpc3RvZ3JhbQ== d2VzdGVybg== IGluZmFudA== IGNvb3JkaW5hdG9y IG5pYg== Om0= IHJlc3BlY3RlZA== IGRlZmluaXQ= JlQ= X3BhZA== IFRyaWdnZXI= dGhhbA== IGltYWdlTmFtZWQ= IGJlYXRlbg== CXJj IFBhbGFjZQ== IGhhemFyZA== IGlzb2xhdGlvbg== X3Jj Y29udHJl T1VUUFVU IHJlaWdu IFBsYXRl QVRFUw== IGZsdXg= IHBhY2tz LmdldFNlbGVjdGVk IHBhcnRpY2lwYXRlZA== IG5lZWRsZQ== LWRlcHRo Ojo6Ojo6 LWxhdw== aW5zcGFjZQ== b25pdG9y PW5v IEF0b21pYw== IEJyYWlu RWRpdGFibGU= LXNj cmVkZW50aWFs IFBlcnJ5 a2ll IC0tLS0tLS0tLS0K LnN0cm9rZQ== KEludGVudA== IHVuaXR5 dW1sYWg= RnVydGhlcg== IHByemU= IHPDuA== 44KK IFBST0NVUkVNRU5U IEhvdXNpbmc= IGF0dG9ybmV5cw== IGNvbXBvc2U= YXR0ZXJpbmc= IldoYXQ= ZHJhdWw= IHN0cmFpZ2h0Zm9yd2FyZA== SW5zdGFudA== LkpUZXh0RmllbGQ= IHRyYWRlcw== 0LvQsA== IHsh IGxhdGVseQ== SU1H IEFsZA== IElOTkVS IGNhcnRvb24= LlNvdXJjZQ== RkFMU0U= IGRvdWdo ZmVu KHJlY3Q= RGF0YVRhYmxl Tmljaw== IEJ1dHRlcg== cmVhZHM= X2NvbW1lbnRz RU5W IENvbm5lY3RpY3V0 LUZJUlNU CQkJICAgICA= YWNoaQ== Lk1zZw== cmVjdGlvbg== IHJlbGF4ZWQ= IHNoYWZ0 IGVm IEFkZGluZw== IGJyZWFjaA== IO+8mg== cmFtYQ== IGNvbmR1Y3Rpbmc= ICg7 KGds IENBVVNFRA== YXNoaQ== IEZMQUc= IENvbW1lcmNl IElOVEVHRVI= aG91cnM= IFNjaG9vbHM= IG51Y2xl QWdhaW4= cHJvag== IHNldmVudGg= RU1QTEFSWQ== KG1vY2s= J10sDQo= X1NQRUVE PmZhbHNl IHNwYQ== IE5lYXI= 7JU= IGludHJpZw== X21lbWJlcnM= d2F2ZQ== IGFuYWx5c3Rz X09T ZWRpbg== IEZyaQ== IHJldHJpZXZlZA== UmVndWxhcg== X29icw== RVhQT1JU Jyl9fSI= ImNsYXNz X18oKA== YnVja2V0 IHN0cm8= IFBhdGNo eXN0aWNr ZnVsbmVzcw== YXBvcw== RGE= CQkJCQkgICA= IGVucmljaA== dW5vcmRlcmVk aG9sZQ== Q29uZw== PFByb2R1Y3Q= IEN1cnQ= KHRoZQ== X2xvd2Vy IGF2b2lkaW5n IGJ1eno= IHZpYWJsZQ== dWJh LWlz YXJlbA== IGFjdGVk LWRldGFpbHM= 4LiH IFRoZW9yeQ== IFB1bg== IEFub255bW91cw== Li4uIgo= w6hyZXM= 5Y+v IFZpc2lvbg== X3NlbQ== YXNoYQ== IGNlbGVicml0eQ== IGVuZERhdGU= IHBvcHVsYXRl IGN1aXM= cXVhbnQ= Zmxvb3I= IGdsb2JhbGx5 IGNydWlzZQ== IFN0YW5sZXk= IGJpa2Vz LmdldENvbm5lY3Rpb24= IHBvb3JseQ== X290aGVy YW1waW5n LiIpOwoK b2Rp X0FETUlO LmNvbG9ycw== IEdhbWluZw== Pic7Cgo= U1RSVUNU UVI= SURz KGFyZ3VtZW50cw== X2F1eA== KEV2ZW50 X1BSSVZBVEU= IFRyZWs= IGRvd25sb2Fkcw== bXV0YWJsZQ== X1NUUlVDVA== KHd4 IGRvbWFpbnM= anNweA== IFZpYWdyYQ== Q29tbWFuZHM= SnM= LmNmZw== Q29udGVudFBhbmU= IEVkaXRUZXh0 4KWN4KQ= QXR0YWNo IEFSTQ== cG9zaXRpdmU= IEdlbmVyYXRlZA== IHNlaXplZA== PTo= IGVsZWN0cm9uaWNz IEFwcENvbXBvbmVudA== LycsCg== LmVxdWFsc0lnbm9yZUNhc2U= RG9jdHJpbmU= ZGlzaw== IFBvbGl0aWNhbA== Q0hP PEY= CWhlaWdodA== IEJ1Zw== Lmxl aWto IG1pbGxpc2Vjb25kcw== IGNvbnN0aXR1 bWFn Lm5s LXJhbmdl YW5nZ2Fs Jyxb cm9wb2xpdGFu IMOc IFVD LmRlc2M= LUxBU1Q= ZnN0cmVhbQ== aWJpbA== IGZpZXI= VkVSWQ== IOuz SVJU X1VJ KGFicw== IGtuZWVz IHJvb2tpZQ== IFZhYw== YXJlbmE= Y29tbWVuZA== LVw= IFNVQlNUSVRVVEU= U29mdA== IHBhcnRpcg== d2VhbHRo 6KaB KGRhdGFzZXQ= IENsaW1hdGU= LXNob3c= IHJlbGlhYmlsaXR5 X2NodW5r 5Luj X3N0b2Nr IEVYRU1QTEFSWQ== 77iP IHbDrQ== IHNtaWxlZA== IGRyaWxs LkZ1bmN0aW9u IFNJ IHJlZ3Jlc3Npb24= LVg= IEphcg== cHJlZg== CXN1Y2Nlc3M= IEhpdGxlcg== IGluc3RpbmN0 IGZlbW1lcw== IGxvdmVy PAo= IG11bHRpcGxpZXI= cmls UmVzaXpl IEF1dGhvcml6YXRpb24= IEthbg== RGlzcGF0Y2hUb1Byb3Bz IGNyb3Bz dG9rZW5z ZWNu ZW50aWFsbHk= IElOVEVSUlVQVElPTg== ZmFrZQ== VW5kZWZpbmVk IEFL IFRlc3RDYXNl IHJhYg== IHRvcnJlbnQ= IE90 QmFycw== IGxlY3R1cmU= IGVuam8= IHJlc3BvbmRz IGluZGV4ZWQ= T2ZXb3Jr X2NoYWlu KSktPg== IEJlYXV0eQ== IGA8 IHRvdWNoaW5n IHwtLQ== CWZsYWc= bm9ybWFsaXpl IHRyYXBwZWQ= IGVzdGFibGlzaGluZw== L2J1aWxk QUo= Znk= LXJlYWN0 YXZu UklQVElPTg== IGt1dA== IEZhc2hpb24= IEluZm9ybQ== Y3VyaXRpZXM= PGJ5dGU= IFVrcmFpbg== IHN1Zw== IGNvbnNpc3Rpbmc= b29kbGU= LmN0eA== LlRvTGlzdA== IGNvbW1lbnRhcnk= IHRyYW5zZmVycw== IG5vc3Q= aWhhZA== IFVwcGVy IGNvbmZ1c2luZw== bWlzc2luZw== LWNs IGJvdW5kaW5n IGNvbmdyZXNzaW9uYWw= IHJldmVhbGluZw== ZGg= cnVw IHRyZXM= cmVwZWF0 LAoKCgo= X3RhYw== IGV4cGVk R2lybA== aG9yaXpvbnRhbA== ICIuLi8uLi8uLi8= KG9wdGlvbg== IHdlaXRlcg== CXNxbA== ID0+ewo= IGdhcmxpYw== IHJlcHI= IHJlcGxpZXM= KHByb3A= IHNwaXJpdHM= IGluc3BpcmU= IGJhc2VtZW50 LnJlamVjdA== IGhpbnRz IHBvbGxpbmc= CSAK X3JhdGluZw== IGNhdGg= YXZpZXI= IGNvbXByZXNzZWQ= IFZT XSc= IGp1ZGljaWFs IFRyZW5k dHJhaW5pbmc= RVNUQU1Q b2duaXRpb24= xIE= U0VOVA== dmVudGlvbnM= IGNvbnN1bHRhbnQ= dW1waA== IHVzZXJTZXJ2aWNl LE5VTEw= a2g= RGVhcg== X0JBRA== aXRhdGlvbnM= IG1ldGFwaA== J8Op YW5kaXNl LWZvbnQ= LmNoYXJ0 IHNn X0NvbnRyb2xsZXI= LmpwZWc= IFVMT05H CWdhbWU= KHNz IE1hag== CWdv IFNhZA== IEJlcmc= IE1pbmU= UGFjaw== IHJlc2lzdGFudA== IFJPTQ== IHBlZw== IFN0YW5mb3Jk IFlhaG9v IHNjYWxlZA== IGxhbg== PVtd Ii8+PC8= IHBsb3Rz LioK IHRyYXZlbGVk IE9zY2Fy Vkw= IGxpbmtpbmc= IHRpcmVz ICcqJw== IEJ1ZmZlcmVk ZXJp ICoqKio= IG92ZXJsb29r Lk5vbg== IHLDqXM= IGVneQ== 5bCP IGF0dGFja2Vy CQkJCQkJCQkJCQkJCQkJ LnN5bmM= QVNDQURF R3JvdW5k IGRlY2F5 IFRvbg== IGpld2Vscnk= IGJ5cGFzcw== IG1lbWJy Uk5B PFN5c3RlbQ== IE1lZGljYXJl KG5ldA== b3Np SEI= REVD e0VJRg== X2ZpbGw= IHRyYXZlbGxpbmc= b2JzZXJ2ZXI= IGNvbnN1bHRpbmc= UkVBVA== UGhhc2U= KGlp IFNVTQ== Pg0NCg== IHN1ZA== CWJhY2tncm91bmQ= IHNjaG9sYXJz LW11dGVk YXLDoQ== ID09PT09 IF9fX18= Q3JlYXQ= ZW5ldmVy L3dw IFZQTg== RXJyb3JDb2Rl KV0sCg== KGJ1aWxkZXI= IEVuZW15 U2Vuc29y dXNh IHRyaWdnZXJz IHBsYXlvZmZz X1JFUQ== ICh+ IEJhcnJ5 IHBlcm1hbmVudGx5 IFJVTg== IGJ1cmU= LkZhdGFsZg== IGNoaWNr CXBhbmlj cHNp b2th 6YCJ Pls= IHVuZGVyc3RhbmRz IEp1bmlvcg== IElORk8= PW15c3FsaQ== dXN0YWlu LXNvdXJjZQ== c2Vydg== IENSRUFURQ== LmF1 IHNlbGxz ICAKICAK RXVyb3Bl enc= cHJlaA== IE5TQQ== IHh5 4Li0 IEJleW9uZA== SW5zdGVhZA== Tm9uUXVlcnk= IGFyaXNl IGF2b2lkZWQ= LmVtcGxhY2U= X21vZGVscw== fSksCg== IGhpZA== ICZf LnBvaW50cw== LmdldFdpZHRo LkV4ZWM= IC8vLy8= IFNlc3Npb25z Li4uXA== IENvbG9tYg== IGFjY2VsZXJhdGlvbg== cmVzdG9yZQ== IGlsZQ== b2JpYw== PE5vZGU= IERY IEJlc2lkZXM= LmFnZQ== IENvbnRhaW5z TmF0aW9uYWw= IEltcGxlbWVudGF0aW9u IGVmZmlj IFJN SHk= IFdlZGRpbmc= b2tpZXM= IHJlY3Vyc2l2ZQ== IHByb3NlY3V0b3Jz LlNlbGVjdGlvbg== IEZvcm11bGE= QmVlbkNhbGxlZA== W2lp IEZyYW4= IHRyYWdlZHk= X0ZFQVRVUkU= mag= Y29tcGFzcw== IEJo PwoKCg== LndyaXRlcg== IEhvdXI= RGJDb250ZXh0 aW92 YW1vbg== cmVwcg== 6YM= CWZp J11d IERyeQ== LnJv IE9ic2Vydg== 5qCH Rm9ybWVy IEJhbGFuY2U= CWpzb24= IHByenk= SVNT KHNvY2s= IExJTkU= IGRlY2U= IGFsbHk= IHRlbmRlbmN5 RnVu IHNjaGVtZXM= IGludGVydmVu 5piO IGFkdmVyc2U= cXVvdGVsZXY= IHNhY3JpZmlj X3NpZGU= IG11dGV4 QUdJQw== IG9jY3VycmluZw== IENvbW11bmljYXRpb24= dW1hcg== 57yW IFRyZWF0bWVudA== LnBlcnNvbg== IExD IGVjaA== KCgi IERpc2Vhc2U= w6Rk IEFa LkFjY291bnQ= IGNvbnRpbnVvdXNseQ== RU5ESU5H IFJFVFVSTg== LXN0cmluZw== LmZpbGVuYW1l c3ludGhlc2l6ZQ== UmVzcG9uZGVy KG9wdHM= cmVncw== IG51ZXN0 UGVlcg== Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= IGdhdWdl IEtpbg== LnNjaGVtYQ== IGFycmFuZ2U= IEJsYWtl X1R5cGVJbmZv Q292ZXI= IEhhbXBzaGlyZQ== UGFwZXI= LWlubmVy dXRpbGl0eQ== IGNyb3Nzb3JpZ2lu Rk9S IGlnbm9yaW5n IERE YXZhbg== IHRyYWRpdGlvbnM= IGdldFN0cmluZw== IGV0aGljcw== IE1hdGVyaWFscw== REVTQw== IGVuenlt aW9sZXQ= IENoaXA= IE1jRG9uYWxk IG5lcnZl 54Q= Iild 5rGC IFN1Z2Fy X1NJTQ== anBlZw== IGRpc2NyZXRpb24= IFRO Ym92ZQ== IE1pbmltdW0= IEZvcm1Hcm91cA== IHdvcmtmb3JjZQ== IEV4ZWN1dGlvbg== ZXJyZXI= CSAgICAJ IHByZXNjcmliZWQ= LlRleHRBbGlnbg== T1BFTg== IFBC aW1pdHk= IEV4dGVybmFs wrBD IEFwcGxpY2F0aW9uQ29udHJvbGxlcg== IGJhcnI= aW1wbGljaXQ= X2RvdA== IENvbG9u Q09MT1I= LlByb2plY3Q= Kjwv LXhs IG9zYw== KHBhdHRlcm4= Jyl9Cg== c3VjY2Vzc2Z1bA== YWxvZw== U3R1ZGVudHM= XXN0cmluZw== YW50b24= YXR0aQ== Y2hlbWljYWw= LmluZg== KGRy OlVJQ29udHJvbFN0YXRl dG9JbnQ= XTwv 0LDQtdC8 IMW+ LkFjdGlvbkxpc3RlbmVy LlNFVkVSRQ== IFNhbHY= X1RSQU4= L2ludGVybmFs IHdlbGNvbWVk LmNvbW1lbnQ= bXV0YXRpb24= IEZBUQ== Lm9uZQ== IExBQg== In19 IFJvbA== aWV2ZWQ= IGFkdmVudHVyZXM= IGZ1bmVyYWw= IHNwb3VzZQ== KG9wZW4= IFJlYWR5 IHRvdXJpc20= YWRpbg== X2ZhY2U= 4oKB IG1pZ3JhbnRz IFB1cmNoYXNl Y29yZA== IE9VVFBVVA== KSkNCg0K U2VndWU= dGFicw== IGRvdHM= IG5haWw= Ym9ybmU= IGRlc2lyZXM= IHByZXZlbnRlZA== J109PQ== IHRpbWVseQ== SUNB U2Nhbm5lcg== IEx1Y2Fz IGdpdGh1Yg== J11bXQ== ZGlh Y29ub21pYw== IGRpZXNlcg== dW5kZXJz LkhhbmRsZXI= PyIs LmRhdGFi IGFkdmlzZQ== LmFuaW1hdGlvbg== IG92ZXJoZWFk IG9ic3RhY2xlcw== X2pvaW4= IG3DqQ== RmxhdA== LmRpc3Bvc2U= IEV4cGVjdGVk IGZsZXc= IGVtYm9k X3NsdWc= IG5hbWVseQ== IHdpdG5lc3NlZA== c29saWQ= LmxlZ2VuZA== UXVhbA== X3N1cmZhY2U= 44Op QW1lcmljYQ== IGFmZmlsaWF0ZXM= IFByb3M= X2V4dGVuc2lvbg== YmluZGluZw== U1RBTEw= LnJlYWR5 IGNvcHlpbmc= IEhlbmNl IGRpc2NvcmQ= X3NoaXA= UHJvcGVydHlOYW1l CQkgICAgICAgICAgIA== IGFjaGlldmluZw== IEJlYw== Wmlw U29tZXRpbWVz 44GL IGNvbnRyYQ== IHB1bmlzaA== IGluc3VsaW4= IGRpc2FwcGVhcg== X2VudW0= LmF1dA== IGhhc2F0dHI= YWZmZWN0ZWQ= c2hl JHRhYmxl a3Np IGxhY2tpbmc= IGRpc2NvdW50cw== U3RtdA== IEFyZ2VudGluYQ== IHVucGFjaw== IFJvdXRlZEV2ZW50QXJncw== ICc/ aW50ZXJvcA== IHNvZmE= IGR5bg== IEdyYWNl IGludGVncmF0ZQ== 2YM= IGRlbGF5cw== IEltcGxlbWVudA== UHJvb2Y= IGFwcGxpY2FudHM= IExlYXRoZXI= 7Ja0 IGVuam95YWJsZQ== U3Bpbm5lcg== L3o= IGZvYW0= IExhYm9yYXRvcnk= IHJlc2VhcmNoZXI= IENocmlzdGlhbml0eQ== IGN1c3RvbWl6ZQ== IGNpcGhlcg== IGRvZA== IHPDsw== QEVudGl0eQ== T05MWQ== aW52ZW50b3J5 IGNvbmNsdWRl IGN1ZW50YQ== IENvaGVu LWluY29tZQ== bWJI bWVudGF0aW9u IHZlcnc= dWRw QU1M LmNvbWJvQm94 Zmg= am9icw== RmlsZVN5bmM= IEJhcmJhcmE= IFNjYW4= Y3JlZW5zaG90 IE9ydGg= LnZpZXdEaWRMb2Fk IEFSUkFZ LEA= L2ludA== R2VuZXJhdGU= IGRlbW9uc3RyYXRlcw== IFplbmQ= 5YiX CXZvbGF0aWxl PXI= IGZt CWJ1ZmZlcg== ZW5hdGU= LkNvbWJpbmU= IG1pc2M= Y2hlbWFz IHB1cmVseQ== IGdsVmVydGV4 LlJlc3Q= IHJlY2FsbGVk IGZyZWVs IHNxdWU= VHJhY2tlcg== IFBocA== IERpc3RhbmNl IGJlYXN0 Q29tcGxleA== IGNvbnNpZGVycw== 572R dHJpYnV0aW9u IGNvbXBsaW1lbnQ= X2xpbmVubw== IE11dGFibGU= IHVuZGVm IEdlbQ== IGNvbXBvdW5kcw== LnV1aWQ= IGFub255bQ== IHN0YWlycw== IERiU2V0 d29ydA== IFNlbnM= LkJlZm9yZQ== IGVuZGZvcmVhY2g= IFRvZ2V0aGVy YXRpbGl0eQ== IG1vaXN0dXJl LSR7 KFRlc3Q= VEI= bXVzaWM= IGluc2lzdA== IGhlYWRsaW5l LkFuZA== UEFUQ0g= IFByZXBhcmU= IHN3aXRjaGVz KnA= IFll X2Ficw== LmhhbmRsZXI= IGFzc2lnbm1lbnRz UHJlZmVyZW5jZQ== RU5USVRZ IHBpcGVz IEFsZXJ0RGlhbG9n b2dyYXBoaWNhbA== IHBhdGlv IHdlYnBhY2s= YnBz TmF2TGluaw== Lk51bWJlcg== IEFybW9y IFBldGVycw== IERlc2M= ZHVpbm8= IEljb25z LmdldEhlaWdodA== IHRleHRWaWV3 CU5VTEw= YWxsb2NhdGU= fSR7 IFByaXpl LW51bQ== Lk1vdmU= 6L6T5YWl LmNhbWVyYQ== UHJvYmxlbQ== CXR5cGVkZWY= KHN0b3Jl IERJU0NMQUlNRUQ= IHN1YnN0YW50aWFsbHk= RkZG IGVwc2lsb24= IGluZXF1YWxpdHk= X2NoaWxkcmVu 5LiH cmVsdQ== UGllY2U= YW50cnk= YmFiZWw= dmV0aWNh IHN1cnZleXM= IGRldGVjdG9y CWFyZ3M= LlNlbGVjdGVkVmFsdWU= IGludGVyZmVyZW5jZQ== Li4uKQo= LlNUUklORw== IFR5bGVy IENhdGFsb2c= VmVydGljZXM= IFByb2plY3Rz IExlYmFu LiIpCgo= Lmtlcm5lbA== IHJpZGVz IE11dA== YW50aA== 0L7RgNC8 ZW5uaWFs LnRhc2tz LnNldFByb3BlcnR5 YXRlZ29yaQ== 5pyA L2Nvbg== YnJhY2U= IE5TRXJyb3I= J10pKTsK bGlzdGVk IFByZXZpZXc= QWN0aXZhdGU= IGN5Y2w= LWFjdGl2ZQ== aGFk VG9v IHJlZ2lzdA== bGljYWw= IHBvZXRyeQ== SW1wb3J0cw== 77yB77yB Ojw= IGNoYXJt IENvdW4= b2xsaWRlcg== IGh3 fWAK PWFyZ3M= IE5ldXJv aXRpY2Fs aWVuZW4= IERvdA== X09OTFk= RE4= IFBsYXlTdGF0aW9u IHN0ZWVw IHByYWN0aWNhbGx5 IGFwcGxpY2FudA== IGFyb20= YW5pYw== CWRpc3BsYXk= IHRlcm1pbmF0ZWQ= IGNsYXJpdHk= IE1lbnVJdGVt IEt1cg== aWpl X3dlZWs= KGRpY3Q= X3JlY29yZHM= IENvc3Rh IGtldA== RXh0ZW5zaW9ucw== IG5ldWtlbg== aW5zaQ== X2luYw== IOaW IGVpbmY= IFJpc2s= IGVsZXZhdGVk cGVycw== VURB IEtO IGxpbmVk IE1vcm0= KTsKCgoK Pn0K cGxhaW50 Z2V0VGV4dA== IGluZGl2aWR1YWxseQ== IGNoZWNrYm94 VVk= IExhbWI= IGR5c2Z1bmN0aW9u IExhcg== 4LA= IENyZWF0aW5n Jyk7CgoK IlRoZXk= bG9jYXRpb25z X0NPUkU= SW50ZXJhY3Rpb24= dW1ibmFpbHM= IFBhcnRuZXI= YnJpdA== IGxlc3Nlcg== IFNsb3Q= c2V0QXR0cmlidXRl IFdhdmU= LnBv L3N0b3Jl IGJyb3dzaW5n X3Bk c3VtZQ== c2Vk Q3VydmU= IHBsYXNtYQ== IHN1c3BpY2lvdXM= 7J24 IEJhaA== IEV4cGxpY2l0 X0ND LkNsaWVudFNpemU= XFZpZXc= IHN1YnN0aXQ= bG9vbg== IEdBTUU= IEJyaWQ= m+W7ug== X1VzZXI= IHNxdWFyZXM= Zm9uZQ== IHNhY3JlZA== dWdocw== XWludGVyZmFjZQ== IFRocm93 IEtpcms= IGVtcGlyZQ== IGFzc2Vzc2Vk VGF4 IEhlYXZlbg== LWJ1ZmZlcg== X1NUQVRJQw== w6luw6k= LWJvcmRlcmVk IHB1bmN0 KG1vZGU= IGtlaW5l U2VudA== IENhbGN1bA== IEV2ZQ== IHN0eWxpc2g= IG9pbHM= LlRlc3RDYXNl IHRyYWRlbWFyaw== IGxpdGVyYXJ5 IGNvbmNlbnRyYXRpb25z IFJlbGF0aW9ucw== KENsYXNz IHN0ZGlu IHbDpg== YmFja3Vw LlZFUlNJT04= LkF1dG9TY2FsZURpbWVuc2lvbnM= c3RhcnRlcg== VHJhbnNhY3Rpb25hbA== LXBhbmVs U3R1ZGlv a2M= IENoYW1iZXI= IFNwaWVs IHJobw== 2KfZhA== ISc= LkF0dHJpYnV0ZXM= IG11cmRlcmVk YXBldXRpYw== IGludGltYXRl IHRleHRGaWVsZA== IEJ1ZmZhbG8= ZHVtbXk= IiU= IExpYmVydHk= b2Jhcg== IFRhbms= IFBvcHVsYXI= ZXJ2aXNvcg== IEluaXRp IE1hbGw= IFByaW9y Q0FQ IENsYXk= IENlcnRpZmljYXRl LkxvY2s= LXN0cmlw LWRyaXZlbg== L2FsbA== IE1lc3NhZ2VCb3hCdXR0b25z X1NFQ1JFVA== X3Bi IHJhdHM= 4KS+4KQ= IG50 LlJvdXRlcg== X3RvcGlj IHRlbm5pcw== IFBVQkxJQw== IEFjdGl2YXRlZFJvdXRl ICcsCg== IGNvc3R1bWU= IGpva2Vz LkhhbmRsZQ== CWJ5dGU= IGZsYXZvcnM= KGNj IHBlcnNvbmFz CWltYWdl IE5hemk= IGdyYW1tYXI= IMO6bHQ= IHZhbHZl IHZpYw== IFJhY2hlbA== X2ludmFsaWQ= UHJlZnM= c3RkaW50 KHJvdXRl IGh0bWxzcGVjaWFsY2hhcnM= IHBlb3BsZXM= cGxpbmU= IG52 IFF1YW50 b3BwZXJz IGN1cnJlbnRVc2Vy IENhdGFs IHJlY29uYw== IGNvbmp1bmN0aW9u bHg= YW1idXJn IGluZmx1ZW50aWFs ZGFuZ2Vy aW5kZXJz ICVAIiw= LmNvbmZpZ3VyYXRpb24= b3NvbWU= LmlkZW50aXR5 IHBpY2tlcg== bm9zdA== IERJWQ== QXVndXN0 YWJsbw== TGVhZg== IFJlY28= Y2tv RE9D IEhlcm0= OmFueQ== IEludGVydmlldw== IFRleA== eGZl KHdvcms= IGxlYXA= SGVhZGluZw== IHF1YXJ0ZXJz XEJ1bmRsZQ== cmVi UGVyaGFwcw== IEdtYkg= QmlydGg= CXN1bQ== IFdhdHNvbg== Lm5pbA== 56E= e30KCg== aWNhaWQ= R2V0dGVy Im5hbWU= ICINCg== X25vbmU= em0= YWN1dGU= dWVzdG8= IHNvdXM= IHJlYnVpbGQ= IG5ld3NwYXBlcnM= IEhheg== IGtpdHM= aWZv Qmx1cg== IHN1aXRlZA== LUlu 4K8= IEtlaXRo IE5vcndheQ== SU5JVA== aXJlY2Npb24= aWV0aWVz X3VzYWdl IERvdWc= cmlzZQ== IHRyaWxsaW9u aW1pdGVk IFJFTA== YWxpYw== IGNyaXRpY2l6ZWQ= dGhlb3JlbQ== IGNlYXNl IHNpZGV3 IFRlcnJ5 IHN1YnNpZGk= IGZpcm1seQ== IGF3cw== IGhvdHQ= IGRyZXNzaW5n YmFkZ2U= IEFwcGxpY2F0aW9ucw== 6L+U5Zue IGxhdWdoZWQ= IGhvYmJ5 IG11c2ljaWFucw== ICou LnBsYWNlaG9sZGVy IGNvdW50ZXJz IENhcGl0b2w= U0RL IGhlbG1ldA== YW5kYm94 cXVpdA== IGNyaW1pbmFscw== IHRlZW5hZ2Vy KHVwZGF0ZQ== R2w= LnNlbGVjdGlvbg== IGRpc2NoYXJnZQ== IHByZXNlbnRpbmc= dWZhY3R1cmVy X1VOS05PV04= IHN0cmVzc2Vk 5Zmo UHJvdG8= X2NvcnJlY3Q= aGF1cw== IHJlbm92 IGZpcmVhcm1z IHRlY2huaWNhbGx5 LWJyb3dzZXI= IGNhbmR5 U3Ryb2tl IGV4ZWN1dG9y IG9jY3VycmVuY2U= IElQdg== X0lOVEVSRkFDRQ== IFJldHJpZXZl LmJhZA== RXhjaGFuZ2U= TmF2YmFy IEtpZA== KGdldEFwcGxpY2F0aW9uQ29udGV4dA== X1NUT1A= IEJvc3M= TGlzdGVuZXJz IHNob290ZXI= IEFsYg== w6RjaA== IHBpeA== LmtleUNvZGU= YWxvbmU= IGFic3VyZA== IEN1bQ== IE5ld3RvbnNvZnQ= aWt0 IGxhdWdoaW5n IGNhcGl0YWxpc20= cmVlTm9kZQ== VHg= X1FVRVJZ LlNsZWVw KGxvZ2lu V2ViRWxlbWVudA== IGNlbGVicmF0aW5n IGRlcHJlY2F0ZWQ= IG1hYXI= IGFydGlzdGlj X0FTU09D IEJvcmRlclJhZGl1cw== CXdw IHN1cnZpdm9ycw== SW5uZXI= LXJlZA== IHByb3NlY3V0aW9u X3Bw KCI8Lw== IF49 IGxhbQ== IFRyYWRpbmc= ZmxhcmU= RGV0ZWN0b3I= TUY= IEVtZXJnZW5jeQ== IEVhZ2xlcw== cXVhZA== IEluY3Jl cGxpYW5jZQ== XE1pZ3JhdGlvbg== IHVwZ3JhZGVz Q1BV YWdnaQ== ZnByaW50Zg== aWdpb24= IGJlYXV0aWZ1bGx5 IGRyaWVk X0hJR0g= IGdwaW8= TVND IERlcHV0eQ== IERlY2w= IHRyZWFzdXJl c2dpdmluZw== X3NpZGViYXI= IGFwYXJ0bWVudHM= IFdy IGJvYXRz IGJvcg== Lmxhbmd1YWdl IFVp bGl0 ZnJt YW5jaWVz IG1hc3Nlcw== IEFzc2lnbg== IFBPTA== IG1hcERpc3BhdGNoVG9Qcm9wcw== IGJyYWNrZXQ= IFBhcA== IENp IEludG8= IHRlYW1tYXRlcw== IGZvcmFsbA== dWx1aQ== IENhcm4= X0lOUw== YXppb25p Y2Vw IHRvdXJpc3Rz LWJsdWU= IExlZA== IHBlbmV0 IEZv IGltYWdpbmc= cHJh IHNsYXZlcw== b2xlcmFuY2U= IGluY29ycG9yYXRlZA== Jiw= dWFibHk= IEthcA== WG1sRWxlbWVudA== IE11ZWxsZXI= Q2hhbmdlTGlzdGVuZXI= IEhvbGlkYXk= CSAgICAgICAgIA== RmxleA== CVVzZXI= Il0pKQ== X3N1Ym1pdA== LmJvbGQ= IGxvY2tz IEN1YmE= dWRzb24= SG9vaw== IFdhcm5lcg== X3N0YXI= Ij0+JA== IGNvbW1h dW5jaGVja2Vk Z3JhcGhpY3M= cm9ycw== R1JPVU5E KHB1YmxpYw== IGN1c3RvbWl6ZWQ= IEFya2Fuc2Fz IFJldw== IGV4cGlyYXRpb24= 15U= IEN1bA== IG5vbnM= LkZpbHRlcg== IHNlbmF0b3I= X2RlZmluaXRpb24= YXNoaW5ndG9u eW1waA== L0o= IGZ1c2U= cmFtaWQ= IFN1cHBsaWVy IGF1dG9jb21wbGV0ZQ== IH0pLA== LiIKCgo= X2Z1bmN0aW9ucw== CXRv LmV2YWw= IFRPYmplY3Q= UmVmZXJlbmNlcw== IGhlYXRlZA== SEFM ICkpfQo= fSQ= IEJhcnI= X1VOSVQ= KyQ= IGdldFZhbHVl aXBlZA== Y2hpZWQ= KHZt Y3Vl X2ludGVnZXI= X2NvdXJzZQ== dGhpcmQ= IHJldmlzZWQ= KiovCg== X0RJUkVDVA== T3V0T2Y= KCIo IEZlZWw= IHJlYXNz IHN1YnRpdGxl cGVyaQ== bmY= IGVuam95cw== IHRyZWF0cw== KXRoaXM= LXRhYnM= YW5jZXJz IGNvbnRpbmVudA== IGNhcmRpbw== U2Vy LnF1ZXN0aW9u IHBocmFzZXM= VmFsaWRhdG9ycw== IHBvcHVs IGzDrQ== c29uZw== X0lOVEVSTkFM IGFkdmlzZXI= IHB1eno= IGFtYml0aW91cw== IFRvYg== IERQ IHByZXNpZGVuY3k= IHN1cnJlbmRlcg== IHdhdGNoZXM= X2JpbmFyeQ== IFNvb24= IGNhbmFkYQ== KCIiKQo= XT0n IEJyYW5kb24= ZXBzaWxvbg== cnc= LmFkZENoaWxk LkNvcHk= UHJpbmNpcGFs UGhvdG9z IG1hcmdpbmFs IGJhc2ljcw== ZWluZw== TXVzdA== X1N0cmluZw== IG9sZQ== TWFnZW50bw== LmN1c3RvbWVy KHByZXY= 4Lil IGxveWFsdHk= Q29n IHByb3RvY29scw== IENvbXBhbmllcw== IHRoZW9yZXRpY2Fs IGFjY2Vzc2luZw== IFplbg== Lm9uZXM= YXR0aWNl X3dvcmxk emVz IHRhdHRvbw== IG1lbm9z IGludGVyc2VjdA== Il07Cgo= YmVsaWU= IGluYWN0aXZl LnJlYWRsaW5l LWxhYmVsbGVk LmRvbmU= bGlja3I= IFdPUks= IGRlcml2YXRpdmU= IGRhdGFiYXNlcw== 4oKC IHN4 LmlzQXJyYXk= IHlz IHBhZGE= IEJ1bGxldA== KGAv aXNBY3RpdmU= IENHU2l6ZQ== KGVxdWFsVG8= IENvbHVtYnVz IG1hcnJ5 REVW X2xpbWl0cw== cm9uZXM= SUFT IHRhdQ== bWlubw== X1dyaXRl IFdpbmU= IFtbJw== IFB1bGw= cml0ZXJz cmllbnRz IHNoaWZ0aW5n dXBw X1RJTUVS IENvbmRpdGlvbnM= 4bql IE9yZGVycw== IFN0cmVuZ3Ro 5omA IHZhbGlkaXR5 IGZvdA== ZXR1cg== IGJvbHQ= 5YaF IEFsb25n b3NoaQ== IGFzc3VtcHRpb25z IG1hZ2F6aW5lcw== X1NQSQ== IHB1bnQ= X1BST0RVQ1Q= IHJlbGF5 IEphdmFzY3JpcHQ= LnRl LWVz IHdpZGdldHM= KGZz PEl0ZW0= X2V4dHJh IHJlY3J1aXRpbmc= RXQ= IG5lY2Vzc2l0eQ== cHc= IG5vdmVscw== dXNzZWxz Q3JlYXRvcg== IE1WUA== IE9D dGhvb2Q= Y2xpZW50cw== KSkq IGNoYXJhY3Rlcml6ZWQ= X1NFTkQ= dXRp VHk= LmZyb21Kc29u QFNlcnZpY2U= 44KC Q2hyaXM= X0lz IEpvaG5ueQ== IGNsZWFuZXI= IEluaXRpYWxpemVz VU5L KGF4aXM= 0LXQtw== aWV2YWw= IFdhcnJpb3Jz fSko RE1J 4pmA IFRyZWFzdXJ5 IGZlYXM= IHNsYQ== X0VOVU0= bGhz IEluc3RpdA== aXBwZXJz TGluZWFy UmVhZGluZw== cXVpcmllcw== LWNlbGw= Y2hyb21l LlNlYXJjaA== SU5B 57G75Z6L IAogCg== IFNhbXVlbA== IG1pbGxz IGRvbmF0ZQ== IEdlbw== KHJvd3M= IHNoZWVw IMOpbA== 5L2T IGJlbQ== X1VOVVNFRA== IFJDQw== IGludHJvZHVjaW5n YXR0YQ== IFByaW9yaXR5 IEZC IFNlcmdl PiI7 YXRjaGluZw== IEtub3dsZWRnZQ== CVRoZQ== O21hcmdpbg== bGVzc25lc3M= b3BhcmQ= dW1hdGlj KCkpKTsNCg== IGZhbHM= KGNhY2hl VHlwZUlk 6YCa X2Nob2ljZQ== IEdvdGg= IFNpdGVz TUc= X2JvcmRlcg== SW5kaWNlcw== Q29tcGFyZXI= IFJlZGlzdHJpYnV0aW9u IGNsb3NldA== IHZlcnNhdGlsZQ== SW5wdXRz KioqKioqKioqKioqKioqKioqKio= IG9iZXNpdHk= cXVpeg== Z3Jh KGdsb2JhbA== 5Yqh IGNvbGxlY3Rvcg== IGtvcg== b3ZhYmxl QURD IEV2ZW50SGFuZGxlcg== Lm5j IHBsYXliYWNr aWVudG9z X3Blcm0= X1dBUk5JTkc= IE9seW1waWNz Lm5vcm0= IEJyb2FkY2FzdA== X3NtYWxs ZHJpdmU= Lmlsb2M= IHR5cGVk TUVN X2NvbnM= RE1FVEhPRA== IGx1bg== LmRpc3RhbmNl KHBhcg== cG9vbg== IGJhc3Q= YWN0aXZpdGllcw== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== Og0KDQo= U0VS KSYm X2xzdA== IFBvbGlzaA== IGtub2NrZWQ= IGZydXN0cmF0aW9u YXVrZWU= IHBob3NwaA== aXF1aWQ= X2NvZWZm 5q2k TGF0ZXN0 IER1c3Q= VGlwbw== IG1haW50YWlucw== IG1hcnNo aW5jaW5u bGJs Q2FyZQ== IG5laWdoYm9yaG9vZHM= X2dwaW8= IEFyc2VuYWw= RGVt IFdoZQ== X2hvb2s= IGxkYw== IEhhcnBlcg== IEJlcmtlbGV5 IGdyYWR1YXRlZA== UGVyY2VudA== IGFycml2aW5n IEFkdmVudHVyZQ== KHNjb3Bl KCcq cXVhcnRlcg== IE1hcmll U3BlYWtpbmc= X2NvZGVnZW4= IGltbXVu Y2FzdGVy 44KM 5ZWG IERpbWVuc2lvbnM= LnJlY29yZA== IHRleHRv IE1pY2hlbGxl UGVuZGluZw== KGJ5 X1BBUg== dWNodA== YmVl LlRocmVhZA== YW1waXJl a25vdw== IENsaW5pY2Fs IG1hcmdpbkJvdHRvbQ== IGRpc3Rpbmd1aXNo LkZ1bGw= LnVuZGVmaW5lZA== IFNlcXVlbGl6ZQ== IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIw== IGVkdWNhdGVk X09WRVI= 5bqP IMKgIMKg X2VhY2g= IHVyZ2U= ZGVwYXJ0 IGRvbm9ycw== IEF1 IGJpbGxpb25z IGJlbG9uZ2luZw== X2FnZQ== X0ludA== IHN1YnN0YW5jZXM= bWFjaGluZQ== ISEhCgo= IGpzb25pZnk= aWJiZWFu IENhZA== IGVuZFRpbWU= IGN5Y2xpbmc= IFVJVGV4dEZpZWxk IGxldmVyYWdl IHZhbmlsbGE= ZWF0 TGF1bmNo KHB0 c3RhdGVz IENvbnRyb2xz IFJlc3BvbnM= IEpha2U= IGFzbGVlcA== Zm9ydHVuYXRl Lm5leHRMaW5l U2l6ZU1vZGU= 7J28 VGVzdGluZ01vZHVsZQ== R2VybWFu IEludmVzdGln LnJldmVyc2U= IEJBQ0s= KERhdGVUaW1l IG5vbnByb2ZpdA== IEV4cGVjdA== IHRhbnRv J10pLA== CXRoZQ== TXVsdGlwbGU= KGdldEFjdGl2aXR5 X1dBSVQ= IGrDoQ== ZGVjb3I= bGV2YW5jZQ== IEdpdEh1Yg== bWluYXRpb24= X3F1YW50aXR5 LlNjYW5uZXI= IExpb24= 6ZSZ6K+v IGRyZQ== IHRhbnRyYQ== IGNvbnRlbnRUeXBl IGZpZA== X2FsdA== TlNJbmRleFBhdGg= LXBs 5YyW IGFudGliaW90 dGFibGVz YWNpYWw= IFJlZ2lzdHJ5 IG9saXZl aWdlcnM= IHN1YnNjcmliZXI= X3ByZXM= IFN5bnRheA== IGxvdmVycw== LkJ5dGU= b2xkZXJz X2ZvcndhcmQ= YWx3YXlz Q2FwdGlvbg== UHJpdg== IFRhbXBh aXNhdGV1cg== LWxhYmVsbGVkYnk= IFRvU3RyaW5n IOyCrA== IGluaXRpYXRlZA== V0Y= IGluc3RpdHV0aW9uYWw= aW5qZWN0 IFNjcg== IGRvY3RyaW5l IHNwYWNpb3Vz aXN1cmU= IEFuYQ== InRpbWU= ZXNzYWdpbmc= IGNpZA== IE5hbg== IGluY29tcGxldGU= VEFH LWJ1aWxk RGVjZW1iZXI= IHJlc2lkdWFs KFBETw== IExpc3Rlbg== IGdseXBo IGdhcHM= bmVh LlJlY3Q= IHNhdQ== IFBob3RvZ3JhcGg= IGV4ZWN1dGFibGU= IEV4cGVydA== Q29yb3V0aW5l X3NpemVz IE5M LmlzVmFsaWQ= KTt9Cg== LXJlZw== IGNpdGluZw== Y3dk IE90dGF3YQ== IEJhdHQ= IHJlbmV3YWJsZQ== IHByZWxpbWluYXJ5 IGFzeWx1bQ== IHdyaXN0 IHV0aWxpeg== IGRldGVudGlvbg== RmFzdA== IGFuZ2U= aW5jaW5uYXRp IHN0ZWVyaW5n IE5hTg== aW9zaXR5 L3BhZ2U= IOi/ c3Rlcm9s IGRpc2c= KERC IERFU0NSSVBUSU9O IF8k IG9ic3RhY2xl IGJpemFycmU= IGV4dHJhY3Rpb24= X2V4cGVjdGVk IGxvc2Vz IENlbGVicg== IGh0bWxGb3I= IGV4cGxvaXQ= 0L7Qu9GM0LfQvtCy WFla IG1hZ25ldA== YW1wZWQ= IGF0b21z U291cmNlcw== cGVjdGl2ZXM= 0YHQu9C4 ID0NCg== IGRhcmU= IFdhbHRlcg== IGJyaWdodG5lc3M= IGFubm90YXRpb25z 648= aXNrZQ== U2NoZWR1bGU= LmltYWdlcw== cm9zc28= ICIuLg== Z2FtbWE= IGluc3RydWN0b3I= IG92ZXJ3cml0ZQ== LWFt IGRldmFzdGF0aW5n IFNhaW50cw== IGhz IGJvbnVzZXM= JG91dHB1dA== aWpk KEFjdGlvbkV2ZW50 bW9uaXRvcg== IG1hdHRyZXNz SmFudWFyeQ== Lmpw IGNhcmFjdGVy IGltcG9zZQ== X3Jlc3Q= IFNpZ25hdHVyZQ== IGNvcm9uYXZpcnVz 44GK X2NvbXBhcmU= TWVhc3VyZQ== aXRhdGVk ZWxpams= aWdvcw== ZXNhcg== IHJ1c2hlZA== bWV0cnk= X1NFUEFSQVRPUg== X1dF X0FUVFJJQlVURQ== IHlhbWw= IHNwZWNz IFJhaA== cGhlcmlj IEludmVzdG1lbnQ= w6RsbA== IGFwcGVhbGluZw== IHZpZXdwb3J0 56k= IG1hcmdpbkxlZnQ= IHN1YnRyYWN0 IEVESVQ= CUFycmF5TGlzdA== Z3JhZGluZw== IEZhaWx1cmU= YXNwZXI= RUVL KG5vdw== PG9iamVjdA== IEFsaWdubWVudA== cGxlYWRv cXR0 KEVSUk9S IElOVkFMSUQ= IHVzZXJpZA== cmFpc2Vz SURJ IHZhcmlhbmNl IE5pbA== L2RlbGV0ZQ== X01BSU4= LlRva2Vu LkNhdGVnb3J5 PikK Q29sbGlzaW9u IEdyZWF0ZXI= IFJhY2luZw== YWxhbg== IG1vbmV0YXJ5 LG5ldw== IFNvcnJ5 LkVuYWJsZQ== IEluc3RhbnRpYXRl b2xsZW4= 66m0 IENhbGxpbmc= X2hvdXI= QURB IHNoeQ== KSoq ID09Pg== IGVzcGVjaWFs IGludGVycHJldGVk IT0i IHBoYXJtYWN5 LnNpbmdsZQ== IENpYWxpcw== IHBhcmFz LnRvVXBwZXJDYXNl IERlbW9u UHJpbWU= IHJhbmtpbmdz QWRkaW5n X0hBU0g= IEV4YW0= 2qk= IFZpY3Rvcg== T2theQ== Il07DQo= IGZvcnR1bmU= IEZFVENI ZXhwYW5k LkludGVyb3A= IGJhcm4= 5raI dWV2bw== IHNwZWN1bGF0aW9u 4pSA4pSA4pSA4pSA IE51 IEJsdWVz KGZuYW1l IGluaGFiaXQ= IFwiJQ== Q0VT dWxhcmlv X2Ny IHZhbGlkYXRlZA== IG1pZG5pZ2h0 YW5raW5n IGluY29ycG9yYXRl IHB1cnN1aXQ= RVhQ cHJpbWU= UGlk LVVT IE51cnM= IFdoZWVs 6Zg= IGlucA== IHN1cHBvcnRpdmU= Lm1lbWJlcg== IFNob3Q= LkNoZWNrQm94 IGFmZmlybQ== VG9y RnVsbFllYXI= IGNvbnNpZGVyYWJseQ== Y3JlZGVudGlhbHM= X29wdHM= Um9sbA== KHJvdW5k IGNvbWVudA== X1VBUlQ= IGV4dGVuZGluZw== Ukc= cmVzdWx0YWRv aXR1 LmdldFNlc3Npb24= IGF0dHJhY3Rpb24= JkQ= JGh0bWw= IEplc3NpY2E= IEFzc29jaWF0ZQ== YcOx X2Vk IExhZw== IG9yaWdpbnM= KCkpLT4= YWRkRXZlbnRMaXN0ZW5lcg== SUFMT0c= 5ZCm LkNvbXBhcmU= QWxidW0= IEt1 PFE= YXJnZXN0 IHByb2xvbmc= IGNvbmZpZ3VyYXRpb25z IGFjY2lkZW50YWxseQ== X3Bob3Rv ICcnOw0K IHZlcnNl Qm9i IGZhcm1pbmc= ZGVsaXZlcnk= IE1hY2s= IHVzZVNlbGVjdG9y LmJvb3RzdHJhcGNkbg== a2VlcGluZw== ZW55 LnVwbG9hZA== IE1FVEhPRA== Y3JlYXRvcg== PF8= IEVhc3Rlcg== Li0t VUlCdXR0b24= 44KJ b21ldGVycw== IHNoaW5l IGhvZ3k= XHM= IGhhcm5lc3M= LkNlbGw= IGxpZnRpbmc= IGNvbWJpbmVz IE9jY3Vw ZXhjbHVkZQ== cGF0aWFs IHJlc3Bpcg== X2ZpdA== IGZpZnR5 IE1vbA== IHR1bmVk LWRpbWVuc2lvbmFs IHFz IHRvcHM= PiI7Cgo= cXVpc2l0ZQ== Y2hhbm5lbHM= L3Jlcw== IEFuYWx5dGljcw== LmFwcGNvbXBhdA== L3Rv IG9uRXJyb3I= KGF0dHI= SVJN IHJhZ2F6 LWFz LlNlY29uZA== b3JpZW50ZWQ= IGRvbm4= IGxpZ2h0bmluZw== Zmlk IFBsZQ== 44G+44GZ dHJv LlRydWU= T2JzZXJ2YWJsZQ== 15k= dW1iaW5n IHByb3NwZWN0aXZl LWZpbHRlcg== IHB1cnN1YW50 KHBvaW50cw== LkJpbmQ= IHBhbG0= Y2xlYXJmaXg= w7Zz IEdvbno= IHdlYWtlbg== RHJpdmU= ZW5pZG8= bGxk b2JveA== YW5lYW4= R290 5L+d UmVnZXg= 5oM= IHNhbGFk YXNzaXM= Im5ldA== aW5oZXJpdERvYw== IFJW cXVpZXI= IGNsYXp6 xLHFnw== b3N0ZXJvbmU= IGFpcmxpbmU= Lmxpc3RkaXI= IGRvd25sb2FkaW5n IFBhbG0= d2F1a2Vl Jmx0 LkJM X0lOTElORQ== b2Zmcw== PDwo X25ld3M= IGNoYXNl Lz48 IGV1cm9z IEVneXB0aWFu IFN0YWlubGVzcw== X0JPT0w= IEd1aWxk IER5bmFt W2luZGV4UGF0aA== IO8= IG1lbW9yYWJsZQ== IENoYW1waW9u UmVzb3VyY2VNYW5hZ2Vy LkxvZ2lu IEZvcm1lcg== eXBlZA== IGxsZWc= OyIs RFdPUkQ= IHRheGk= IGJvbWJz cmFo LnRhZ3M= X3Rlc3Rz c3RvbmVz 4oCdKQ== W2c= cnR5cGU= IHZ1 IGhvc3RpbGU= Q2hhcnM= IFBhdHJpb3Rz L3N0YXR1cw== PEI= IEluY29tZQ== IERhZA== IHBhdHJvbA== X0NIQU5HRQ== IHVwZ3JhZGVk IGNoaW5h c2V0cQ== U3RhcnRlZA== LlVuZGVm IGNoZWNrc3Vt IGZydXN0cmF0ZWQ= e28= IGVuZg== IHdvb2Rz IEFueW9uZQ== RW5jb2Rl IFF0V2lkZ2V0cw== YXJlYXM= IHNoZWVy c2tp ZW5kcG9pbnQ= X1Rlc3Q= U291cA== fn5+fn5+fn5+fn5+fn5+fg== KGZpbGVz CQkJCQkNCg== LnNwYXJr IHZhbHVlZA== ICUK LmNvbnRyb2xz IFhDVEFzc2VydEVxdWFs IGZhbWU= IFJpYw== RE9U IEFsYmVydGE= 5L2/ b3NhbA== LldlYkNvbnRyb2xz IC0tLS0tLS0tLS0tLQ== IE1pcw== IFNZUw== Tm9ubnVsbA== PWl0ZW0= IGV4cGlyZQ== RGVjb2Rl X29wZXJhdGlvbg== IFZhbGlkYXRvcg== LkNFTlRFUg== dWZmcw== Km0= IGF2YW50 5qyh 4oCcWW91 LnBlcm1pc3Npb24= Li4uKQ== IExpYw== X2Nvb3Jkcw== Lm5vbWJyZQ== Y2xv LkludGVybmFs IENobw== X3N3 CUls Y2xr IGNhc3RsZQ== KGxheWVy cGl0 IGd1aWRlZA== IOKWiA== IHN1cGVyYg== IHN1cHBsZW1lbnRz X2NlbnQ= IHBlZWs= SU5BUlk= LkNvbnRlbnRBbGlnbm1lbnQ= ZmFsbHM= IikpOw== V2FsbA== KS4NCg== IERhbm55 aXJtaW5naGFt SUFMSVo= KGNyZWF0ZQ== Iklu U2VydmljZVByb3ZpZGVy IHByaWNlZA== bWFjcm8= YW1hYw== LmJveA== LS0tLQo= 44Or IFN1aXQ= dXJzdA== YnJ1 b3VybmFscw== bnVtZXJv X18oKQo= RGFz IE1pdHQ= dWRlcg== P1w= ZnU= W0I= IDopCgo= KGludGVy YnJhaW5z IGF0dGl0dWRlcw== VmVyaWZ5 IHNpZ25hdHVyZXM= YWNrQmFy IGdk SmFjaw== LmNhdA== IHp6 d2FyZg== RlRFUg== Iik7CgoK QWxpdmU= SUNMRQ== IFdoYXRldmVy IG91dGxpbmVk c3ByaXRl 0LXQsg== X0FC X0RFUFRI IGNydXNoZWQ= YWFh KGV2 5py6 QW50aQ== SUNP aXNFcXVhbFRv LnN1bg== aWN1bG8= c2FsZQ== X2hleA== IFZr YXB0b3I= VW5pb24= IERpc2NvdW50 bGlzdGE= LlVuZGVmT3I= IGF1dG9tYXRpb24= Tm9y 5a+5 5Y+C5pWw IHJlZmxleA== IExhdXJl LnNob3dNZXNzYWdlRGlhbG9n LnRlbXA= IGFrYW4= IF9fX19fXw== LklzVHJ1ZQ== QVJFRA== YWdsZQ== RW5lcmd5 IHF1YW50aXRpZXM= 4oCZw6k= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IGNpdGl6ZW5zaGlw bW91dGg= IGluYXBwcm9wcmlhdGU= IE91dGRvb3I= V2hpdGVTcGFjZQ== QW5vbnltb3Vz bG9hZHM= d2ViRWxlbWVudFByb3BlcnRpZXM= VGVu IGFjY2lkZW50cw== IGFkdmVydGlzZW1lbnQ= IFllbWVu KGNhbGw= IHNsYXZlcnk= 0YHQvw== IExhbQ== X0JJVFM= b21lZ2E= IE9sZQ== IGtpZG4= X0Fu IFJhaWQ= Q3JlYXRpb24= c2F2ZWQ= IHByb3BvcnQ= V0FSTklORw== XFA= IHB3ZA== RGF0YVJlYWRlcg== aXNjaGVy YWRlb24= IFByZWRpY3Q= IHJlYXNvbmluZw== IGRlc3Ryb3lpbmc= SGVs KmQ= IExlZ2lzbA== X1By CQkJICAgICAgIA== IHN5bXBhdGg= IGNoZXNz IG1hbQ== OmhvdmVy IGNvbnZlcnRz IHBlbGE= IHByb2dyZXNzaW9u ICJfIg== IEdpbGw= CXNob3c= IHN1cHBvc2VkbHk= YWNjdXJhY3k= ZWxpbg== IHVuZm9sZGluZw== IEh5cGVy IHdhbm5h IHVwcw== KCM= IENyaW1pbmFs KFBvaW50 YXRMbmc= YWN0bHk= IGNvbnRyYWN0b3Jz J119 ZHJhdWxpYw== w7NkaWdv IFRU IFdpZGU= IEFSRw== X2lj RkxBR1M= U2Nob29s IGNsZWFyaW5n LWJlaW5n PXtb LGNvbnN0 bWFuZW50 T3ZlcmxheQ== KCci 6YeP IFRpbWVzdGFtcA== IG1haWxpbmc= IENha2U= LlRoYXQ= IG1lZGl0YXRpb24= cXA= IGVtcHJlc2E= IExpb25z IHdlbGQ= IExpbmtlZElu IGN1c2g= IGdlbm9tZQ== LkluZGV4T2Y= YWdhaW4= IGZhbGxiYWNr IGNhbXBpbmc= cmVkZA== LXN0cmlwZWQ= IGR2 RmVicnVhcnk= IFByb3h5 dXNr IGRpZXNlbA== V1JJVEU= UkVBSw== TG9yZW0= Lkludm9rZQ== LWRpdg== SW50ZXJjZXB0b3I= IERI aWFsZXM= IHZpbGxhZ2Vz 2LQ= IEVOVg== U3lz LlhS IHBvZW0= w4I= Y2FkZQ== cGxvdHM= IHso LmdpdA== L3N2Zw== bmNtcA== IMSN YWluZXM= 5Ye95pWw ICgpCgo= b3BzaXM= IFJlbGF0aW9uc2hpcA== X2F1dA== IEJvbWI= CWNvbQ== KnNpemVvZg== b2ZmaWNpYWw= X3BheWxvYWQ= CQkJCQkgIA== Lm1hbmFnZXI= IEFyb3VuZA== CXNlbmQ= IEV4ZXJjaXNl IEJpbGx5 aXZp IG5lZWRpbmc= X3VybHM= X3Rhc2tz IEhlbQ== IHRlYXJEb3du ZW5jcnlwdA== LnRpZQ== IGFzbQ== SUNI IENHUmVjdE1ha2U= 7ISx dWxvbmc= IGl0cg== IEdTVA== IG9mZmVyaW5ncw== cm9iZQ== RUVF b3BlcmF0b3Jz X1BST1A= aW5kZW50 QURF b3Jm 65A= IGJsZXNzZWQ= dmFzY3VsYXI= IGNvbm9j SGFwcHk= QnJpZGdl aWxpdGF0aW9u am9pbnQ= IEFkbWluaXN0cg== LXRyYW5zZm9ybQ== IG1lYW50aW1l L0s= IEJlZHJvb20= IHJpZ2lk IGJyb3dzZXJz RU1QVFk= LlNlcmlhbGl6ZQ== X0VE IHN0aXRjaA== IGphbg== ZWxsdA== IGJyYWNl IHRyYWlscw== cHVibGlzaGVk 5a+G56CB fScpCg== IGFjaWRz ICEhIQ== X2RpcmVjdA== PigpKTsK YWrEhQ== X09DQw== IHBsYW5ldHM= 5p+l IER1Ymxpbg== IHNlcmll LnByaW50Zg== ZGVlcA== YCk= IFwk IM68 X1ZJREVP ZW5kb3Jz IENyeXB0bw== RmFy LlRyYW5zcGFyZW50 LlRS aWFzbQ== X3RyYWluaW5n IHRlYWNoZXM= IEJlbHQ= IGxpbWl0aW5n IEthdGg= IEluZGV4UGF0aA== IGFjaGlldmVtZW50cw== IHNlcsOh aW50ZXJvcFJlcXVpcmU= IGRpc3Nl Lklm YXJtaW5n dWxzaW9u UG8= X0RFVEFJTA== UHJvdG90eXBl IENBTA== IGFncmVlcw== LnZv LkV4ZWN1dGVOb25RdWVyeQ== IFRvcGlj ICd7fQ== QXJt IGVjYw== TWFn IHNlcmlhbGl6ZWQ= CWNvbm4= Y2FjaGVk PXRm IEJ5dGVBcnJheQ== cHJvdG9idWY= dmFyY2hhcg== CUFTU0VSVA== IGxpc3Rl X3RyaWdnZXI= t7g= RmVlbA== VGFob21h IExpaw== IHN0cnVjdHVyZWQ= ZXJndXM= LkluaXRpYWw= X2dl Y2xqcw== LmNvbnRhY3Q= IGFuZGVyZQ== JHN0bXQ= X0NVUlJFTlQ= IERpc2NvdmVy JHJlcw== Zm9ybWF0dGVy SGE= dmFuZ3N0 IGVtZXJnZQ== 44CC4oCd IENhYmluZXQ= LXNxdWFyZQ== 6YOo IHJhZ2U= IEFK IFZU c2hhZG93 IEZhaXRo ZW5hbWVz cHJldHR5 aGFzaWw= cGFydHk= IHZhcmNoYXI= IGZvdG9z IGFsdW0= IEJlbGdpdW0= LnlsYWJlbA== IGRlag== X251bWJlcnM= IGh1 LnNldEFkYXB0ZXI= IFVzdWFsbHk= KHNhbXBsZQ== LlNoYXJlZA== IGJvb2tlZA== ID4+PQ== IG1pbmVyYWxz Ij48Pz0= IGFkanVzdG1lbnRz IERM IHZpYnJhbnQ= IERlcGVuZGVuY3k= IHphcA== L1g= IGZvbnRz dHJpcA== 0LjRhw== IHR1YmVz Y2xhbWF0aW9u IOun IHByb3RhZ29u b3Vwb24= IEJydXNo KHByZWQ= b3VybmV5 J10pLT4= cHJvZw== Ym9v X21k X3BhY2s= KGV4cHJlc3M= dXR6 XEF1dGg= LGlk IENoaWxl YWN0aWNl IHJlY3J1aXRtZW50 IHBvc2Vz IHZ1bG5lcmFiaWxpdHk= aW5zdGFuYw== b3J1bQ== ZGVzcw== IHhs JSUlJSUlJSUlJSUlJSUlJSUlJSUlJSUlJSUlJSUlJSU= KGZpZw== IGRlbGV0aW5n LmRlbA== KScpCg== IFdlZWtseQ== Pz8/ KHN0cmNtcA== c21pdGg= IHB1cnN1aW5n LXNv IEFwcHM= LycK IGRlY2lz Rk9SRQ== RXZlcnlvbmU= IGxhbmVz VmlydHVhbA== LmF0dGFjaA== KExvZw== IE1lZGljYWlk KFBhdGg= IFR1cm5lcg== L2FwcGxpY2F0aW9u IHBvcnRyYWl0 IG9wcG9zZQ== Y2hlY2tvdXQ= IGZpbmlzaGVz X01F QmFycmllcg== U29uZw== VkFS RWFybGllcg== cmVsbGE= IGhhc3Q= YXphcg== IHB1bGxz bmd4 IGluc3BpcmluZw== 0YPRjg== LWRpcmVjdGlvbg== IGV4cGxvc2l2ZQ== IGNyZWF0ZWRBdA== c3Rv IHdoZWF0 IEJ1aWx0 J2Fp IHRyYWNrZWQ= aGFtbWFk Um93QXRJbmRleFBhdGg= X2hlYXA= RHVl IGNvbm5lY3Rz LnB1Ymxpc2g= ZW11 IGJ1bGxldHM= QkFS b2xhdGU= IGludGVybmFsbHk= IGNhdGNoaW5n LXBhc3N3b3Jk b3VjaGVk 5oCn ZW91cw== IHhyYW5nZQ== UXVhbGl0eQ== dnY= TWFuYWdl KCgk YWNlbWVudHM= IEJyb3RoZXJz IEhFQUQ= IFVuc3VwcG9ydGVk c2Fu ZXNp KioqCg== IGFkYXB0YXRpb24= IFdvcmtlcg== J10v LnNhdmVmaWc= KHRyYW5z 2Kw= bmVl Q29ycmVjdA== Li4uIikK IHN1Ym1pdHRpbmc= LXBhdGg= CWxhc3Q= aXNzYW4= LnhsYWJlbA== IFNlcGFy L25v X2Jlc3Q= IE1pbGxz X3NvY2s= KGZsYWc= IGRlc3RpbmF0aW9ucw== ZW1wdGlvbg== IEZBSUw= 5ZKM IHJw ZmFjdA== CWxlbg== REFZ IHNlaXo= X2RzdA== bGlw LkxpbmVhcg== IEJhc2tldA== JHQ= JGk= LWJyYW5k IE5laWw= IEVx IHRob3U= b2dlbmU= IHNjaG9sYXJzaGlw 5pu0 IHN3bw== YWdpbmF0b3I= ZW5p KGJvb2s= IGJsaW5r dGh1cw== IGNhbmNlbGxhdGlvblRva2Vu IFBhbGVzdGluaWFucw== IHByb2ZpdGFibGU= IGJhY2twYWNr ZW5zb24= PExvbmc= IHBvb2xz IHN0aWNrcw== IHNwb2tlc3dvbWFu QmVpbmc= IEhlcml0YWdl IE5pa2U= U0hB IE5vdEltcGxlbWVudGVkRXhjZXB0aW9u JGNvcmU= IFJpY28= L2xhdGVzdA== IEN6ZWNo bmVyUmFkaXVz KGxpbmVz IHNlbWVzdGVy IHdvdW5kcw== UHJvY2VkdXJl Lm1haWw= KCkpOgo= IGNvcnJpZA== dGVyZWQ= IE5DQUE= IGdhbGF4eQ== X2tpbmQ= aWxr IHRyYXM= X1BPTA== IEhldA== IHJlZnVnZWU= IHRlZW5hZ2U= LmJpbmRpbmc= cG9zdGFs IGnDp2lu IERhdGFUeXBl 6ZY= eWNsZXJ2aWV3 LHZhbHVl X2lkZW50aWZpZXI= PGI= IG91dGZpbGU= DQogICAgDQo= IGNyw6k= IHJlc3BvbmRlbnRz IEJlYXN0 Y2VsZWQ= IGludGVyZg== LXRoZW1l Z2lm IFJhbmdlcnM= SVRBTA== IGF1dGhlbnRpY2F0ZQ== Q29tcGxldGlvbg== dXJzb3Jz IGNpbmVtYQ== IGRpc2NvdXI= IEphdw== T0NLRVQ= IHByYXllcnM= IEx1aXM= ZnJhZw== PVsK IGJyYXZl X3Bvc2U= Q2VydGlmaWNhdGU= LWZl aWZlcmF5 IEZsYWdz Q29udGFpbmVyR2Fw IENyaXQ= UmVzdWx0U2V0 CWN1cg== IGNvcnJlc3BvbmRz U3RhZmY= Lkh0dHBTZXJ2bGV0UmVxdWVzdA== IG5ldXJvbnM= IE1haW5BeGlzQWxpZ25tZW50 ZWRhcg== IGdhZA== X3BhcnRz IM6y IGZ4 L2ZpbGVz IEJyb3M= aGlwcw== IGdsdWNvc2U= IGZhcm1z IG1lbnRhbGx5 cmVzdGF1cmFudA== VGFibGVOYW1l IE1lcmNlZGVz LlZpc3VhbA== IGFuY2g= aW5hbGc= X3J1bnRpbWU= IHByb3ByaWV0YXJ5 IGludGVudGlvbnM= aXpp U2xpY2U= OyI+PC8= X1dPUkQ= XE1pZ3JhdGlvbnM= IEVOQUJMRQ== X1BBUkFNRVRFUg== IEJpc2hvcA== LnN1YmplY3Q= aWxsYXM= Lm1hdHJpeA== dXJyZW5jZXM= Knk= IGNvc3RseQ== IENodWNr IGNsb3Nlcw== IE1pZ2h0 LXN0b3Jl IG1hbGw= aWV0ZW4= LkFicw== IGNvdXBsZWQ= LmJhc2lj IDo6Ojo6Ojo6 TWFrZXI= Y2Fubm90 IGFjaA== IEVsaQ== 4oiS b3JuYQ== IGNwcw== IHRoZXJlb2Y= IEB7 IE5TTXV0YWJsZUFycmF5 zr0= cHJvZHVjdGl2ZQ== U3F1YXJl dGVtcHRz IGVsaW1pbmF0ZWQ= PE0= IGNvbnNlcnZhdGl2ZXM= IFN1cmc= LnBhcg== IEJ1Y2g= KmI= Rm9ydA== Q29sb3Vy IENoaQ== ZWRpYw== PnRydWU= IE5ZQw== IGJvcmVk IERldGVjdA== IGFwcGFy IGplYW5z IFRhaw== SU9E IEhvcnNl KEZJTEU= KD8= cmlxdWU= b3B0aW1pemVy bmF0 bG95cw== CVRva2Vu b3VidGVk dWVzcw== b2NvYQ== RGF0YU1lbWJlcg== X1BPV0VS Y2xhc3NMaXN0 UHVzaEJ1dHRvbg== IFdpRmk= LlN0cmVhbQ== Lmd1aWxk IG5vZw== IFBvcnR1Z2Fs IFVudGVy UHJpbWl0aXZl Ym9zcw== IERldXRzY2g= IGVyb3RpYw== IHN0cmNvbnY= LlRyeVBhcnNl IGdyYW1z LlN1Y2Nlc3M= X3Br IEhhcnZleQ== LW1pbmRlZA== LmNvdW50cnk= W10i IGFuZ2Vs IGJlYXRz IFZvcg== aWxpbw== Lm1hc3Rlcg== c29tZXRoaW5n IFBBQ0s= KGlm UmVxdWVzdEJvZHk= IGFudGVz L3dpZGdldA== IG1vZG8= IEFX ZmluZGVy IG9wdGltaXplZA== IG1pc3NpbGVz TkI= CWludGVybmFs dGV4 IFNyaQ== IGRhbWFnaW5n IE1haXM= LUFsbG93 IFpo LWFsdA== ICkpOwoK 6Ik= IGluZmx1ZW5jZXM= IGNhdGFs X1JFR0lTVEVS IEFQSXM= LWNlbnR1cnk= IGJpb2xvZ3k= IEFjdHVhbA== IGhlZWxz VFJBQ0U= X0RJRw== RGF0YXNldA== IE1hdHRlcg== IGNsYXNzaWZpZXI= Lndpa2lwZWRpYQ== IFJvZ2Vycw== IGRvbmF0ZWQ= cmF3bGVy ZW5lbg== IGNhc2lub3M= b3J0YWw= IHByaXZl c3Bl ZHVjZXJz LmVw IGdyYXNw YWNqaQ== IGRhaXJ5 IGJ1c2Vz LmNvbW0= Lmlucw== IElSUw== IEJlZXI= YWRj b2FyZA== X01FVA== ICcrJw== cmFucw== IGtpbmRh IOKUgg== IE1hdXI= 0LDQsw== IGJhbmR3aWR0aA== aWJ1cw== IERpZmZlcmVudA== KG1hdA== IFJlc3VtZQ== X1VOUw== ZXN0YWJsaXNo IGZvbmN0aW9u U3Vic2NyaXB0aW9u X2NvbXBhbnk= IGxpZ2h0bHk= LmNvbmZpcm0= LnlhbWw= IEJvb3N0 Q29tbWVyY2U= LXRlbXBsYXRl X0RFTEFZ IEhJ IG5hdmln KFNlbmRlcg== IEhT XyIr IFJFUVVFU1Q= IHdpZmk= PSIiCg== XSktPg== IHJvcGU= IHZpb2xhdGVk IGdsYW5jZQ== IEt1cmQ= IOiu ZGVjaw== IElTQk4= IGluZmVjdA== IEZvbw== IGdldHRlcg== IHRlbmVy YXBwZQ== Lmho X2hvdA== PEFN cG9seQ== ISIsCg== IGNvbnZlcnRpbmc= IFdXRQ== Uk9T KCd7 Q29tbWl0 KUw= IE9yZQ== IHNwYXJzZQ== IGRpc3Bvc2Fs IGNhbmNlbGVk 5ZCO IGFlcg== IHZpbnls 4buD cmVjb2du YXJraW5n IHRyaWNreQ== KnM= IHByb2NlZWRz IGlzbw== IGNvY29udXQ= IGNyYWZ0ZWQ= SUVMRFM= IHF1ZXN0bw== IGNvbW11bg== X0NPTk5FQ1Q= IHRyYWZmaWNraW5n RGVlcA== YcOnw7Vlcw== Y29kaWdv dmVhdQ== IGJldHJheQ== aW50YQ== VEVE w6Zy bWFydA== X0JVUw== L3Nj aWFsbHk= IGNpZ2FyZXR0ZXM= 6K+B KG5u IG1vZGVsaW5n L3Byb2R1Y3Rz d2Fybg== IG1ldHJv IEl2 Jik= IENhYmxl zrs= Q29tcGFyaXNvbg== Z2FyeQ== IEJB UEFSVA== IHB2 X3VwZGF0ZWQ= Q3JlZGl0 b3J0aHk= b2JzZXJ2YWJsZQ== IHRoZWF0cmU= QkxF O30KCg== bGF1bmNo X3N0cmluZ3M= dWdv IFJQRw== LWF1dGg= 0KA= aG9sbQ== IFBhbmQ= VWlk IGltcGx5 7Jy8 J109Jw== L1VzZXI= IHN0cmNhdA== 0L3Ri9C5 RGF0YUFkYXB0ZXI= IGxhbmRzYw== IGRpcGxvbWF0aWM= 77yT KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKg== IENoaWNrZW4= IGJjcnlwdA== LkluZg== W2NvbA== IFF1YW50aXR5 LXBvc2l0aW9u IGRpZXRhcnk= IGZpbG1t SXNyYWVs UHJldg== IE1pbGxpb24= IHJlbWVk IGJpbGxpbmc= IG91dGRvb3Jz LnRt IG5hZA== Rm9yZw== Wlo= IHNzbA== XSwn S1Q= ZnJlcQ== PWRvY3VtZW50 Ymx1cg== rLg= IEplZmZlcnNvbg== Q3M= KHNhdmU= IHN0cmFw SW5kaWE= IGlkZW9sb2d5 Qk9TRQ== IEZQ KGFucw== IGZldmVy IFlhbQ== S2luZw== 4LI= QVRJTkc= Ym9oeWRy cm9sbGJhY2s= IG5ld05vZGU= IE5WSURJQQ== IGhvbm91cg== IENvbmZpcm0= eGJk IHN1Y2Nlc3Nvcg== L3U= bGl2 b3VybmFtZW50cw== QXR0YWNobWVudA== IGdydXA= IHRyaWJl IGNhcmVz ZWZ0 X3NhbWU= J2xhYmVs IOOAkA== TW90b3I= IGluZXhw ICIoIg== X1BPU0lUSU9O IHZhbGxleQ== IFJlc3VsdFNldA== IHByZXNlcnZlZA== IG11dGF0aW9ucw== IHF1ZXN0aW9uaW5n bXVuaXRpb24= cGFyc2VJbnQ= IFNy IE1ldGFkYXRh 4oCd77yM dGltZXN0YW1wcw== IHRyYW5zaXRpb25z 7Zk= 0Yo= aW9t LkRv IHBpbmU= IGZ1bmc= IHRyYW5zbWl0dGVk Y3RpbWU= IEZhbQ== UmV2aXNpb24= QmFz VVBFUg== RGVzdGluYXRpb24= dG9IYXZlQmVlbkNhbGxlZA== IHVuZm9ydHVuYXRl SU5FUw== X3Byb2Y= QW1vbmc= IEN5YmVy IEJhdHRlcnk= Z2VucmU= IFZpZXdNb2RlbA== LT0= IHV0aWxpemVk cGFpbnQ= LkludGVnZXJGaWVsZA== ZXJuaXR5 Y29tcGlsZXI= 4oCLCgo= IE1hc3RlcnM= LlRvQXJyYXk= IHN0cnRvbA== IFVrcmFpbmlhbg== fSkpOwo= IHNoZW1hbGU= IlRoYXQ= Zm9yYWxs L2Rvd25sb2Fk IHJoZXRvcmlj LmxhdGl0dWRl IFdIRU4= IHNob2NraW5n SUZJQw== Lk5vcm1hbA== X0ZPTERFUg== IGRyaWZ0 IG1vdW50aW5n LWJvb2s= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAK IFdpcmVsZXNz PiIuJA== IHJlbGllcw== KENvbnNvbGU= SW50ZXJuYXRpb25hbA== LT57JA== TWlk IGRpc3NlcnQ= ZGRz IGRlcG9zaXRz CWRyaXZlcg== I2dh cHJpc2luZw== cHJpbnRsbg== IHByZXNlbnRlcg== IG1pbmVz Q1NT IER1YWw= KCEo IGthbQ== IGlzTG9hZGluZw== IFByb3RlY3Q= LnVwcGVy YXJpdW0= XToKCgo= WWlp LXNoaXJ0 IElNQUdF X2NvbG9ycw== IHVyZ2VudA== LkNvbnRhaW5lcg== ISgK U2F0dXJkYXk= IHNvY2lldGllcw== IFRoYW4= IENvZA== PUA= IGF0dGFjaG1lbnRz Lm1vYmlsZQ== IHNwaXRl IGJvdW5jZQ== cmF3bA== aW5zdGFuY2V0eXBl IFRydWNr IG1hbmlwdWxhdGlvbg== KENvbmZpZw== LWluc3Q= IHN0b3I= aXR1dGlvbg== UHJlZmVycmVkR2Fw IG1haW5BeGlzQWxpZ25tZW50 IGxpc3RlbmVk JycnCgo= b3R0YWdl LXByb2plY3Q= LkFQUExJQ0FUSU9O CXJvb3Q= IHdoaXQ= IGJpbGRlcg== IGtlcg== IGFwcGxpYW5jZXM= cm93YXZl 7J2A ZW1hdGljcw== IE9yZw== b3Bpbmc= X1NFQVJDSA== IGNoYW0= YWRkQ29udGFpbmVyR2Fw ICgpLg== IEFycm93 SWxsZWdhbA== Q3VycmVudGx5 IHVzYQ== IHBhc3N3b3Jkcw== IHJlbm93bg== YXZlcm4= IEV2aWw= IGNvbmNhdA== IGR1bw== IHZhbGU= IEJlYW4= IGluZGljYXRvcnM= Y21hdGg= IFB1bXA= Tm92ZW1iZXI= aWZpY2FudA== X0RPTUFJTg== cmVnYXI= IFBvcnRhbA== IiQ= IGZvcm1lcmx5 Il06Cg== IFZpc2liaWxpdHk= LmdldEVsZW1lbnRzQnlDbGFzc05hbWU= X1JFRA== IGNoYW1waW9ucw== 4LQ= VmFsb3I= X2Vz KmE= LXJlcGVhdA== QmFuZA== LnN0YWdl IGJ1cmVhdWM= Q250 ZXRlbg== LWZ1bmN0aW9u IG11aXRv UElE X2VkaXRvcg== IGNyYXNoZWQ= ZGVhZA== a2F0 YWdo IEVYVA== YXNzZXI= LXNtYWxs IHJlYWxpeg== KEVudGl0eQ== w7pz IEFjdHVhbGx5 IEVsaXRl IGhlbG0= KG5vbmF0b21pYw== YXNoZXI= Q29tbXVuaXR5 YWxsZW5n aXJ5 IEdyb3d0aA== IHN1ZQ== IGZyZXF1ZW5jaWVz X2Rlc2NyaXB0b3I= LkF0dHJpYnV0ZQ== IHJlY2lwaWVudHM= X05T LyIr aWJhbg== IGF0aGxldGU= IElnbg== X0RNQQ== KGRz IFJlcXVpcmVtZW50cw== QURJ ZXJleg== XEFkbWlu YnJhc2th IFJ1c3Q= UmVsYXRpb24= Q09E IFZFUlNJT04= ZW1tYQ== KSl7 LkR1cmF0aW9u IENhbWI= LWxvZ28= IHJlYWRhYmxl IGNyZWF0b3Jz KCldOwo= VXBEb3du LWhhbGY= LmdldE1vbnRo KHNm UGlj IGh1bmdlcg== LnR4 IGV4Y2VlZGVk X3NlZWQ= KF4= X3Nr LnBlcmZvcm0= ID46Og== IG1vbmdv PWZsb2F0 YmluZFBhcmFt U21hcnQ= aWZh IHNlY3VyaXRpZXM= IHByZWp1ZA== ICwi IGNvcnBz IHZyYQ== YW1hY2FyZQ== aXRlcnI= KE1lZGlh dWNoZQ== IGNvYg== IGxpYmVy Lmdlb21ldHJ5 TG9jYXRvcg== IHNsaWRpbmc= IHN1cmdpY2Fs X0NVUg== IGNvbnNlY3Q= Wyo= IFJlc29ydA== U3R1Yg== X0RPVUJMRQ== IFNvcGg= IGVsZWN0b3JhbA== X2Rpc2FibGU= INGB0L4= IExpZ2h0bmluZw== IG1lbnRpb25z b2N5 IGxlYWtlZA== IHJlbGF4aW5n UHJlc2VudGVy dnNw IGd1aWx0 PS09LQ== LnJlcGx5 IE1pcnJvcg== Q2FtcA== ICsjKyMrIys= ICsjKyMrIysjKyMr LkF1dGhvcg== IGRpcmVjdGl2ZQ== LWhvb2s= 7YSw fQoKCgoK QHB5dGVzdA== X3JhbmQ= bWlz IGNvbG9yZnVs dWpl bGFzc2Vz IENsYXNzZXM= LmhhdmU= JSks 6aKY IGRpc3R1cmJpbmc= c3Vic3RyaW5n IEtvaA== SW52ZXN0 cHVyY2hhc2U= IHJlY3ljbGluZw== IEFSVA== aWVyYXJjaHk= IGZwcw== LmNoZWNrQm94 7ZW0 X21hdGVyaWFs ZHVjYXRpb24= IGZ3 dWRpdA== IHJldmlld2luZw== IFNpZA== U3ludGF4 IFdyaXR0ZW4= YXJnYXI= VU1F L3E= Q2xhc3NpZmllcg== T2ZmaWNpYWw= IGpheno= IG9tZWdh UGh5c2ljcw== IGx1Z2Fy X2FjY2Vzc29y LmNvbW1hbmRz QWJpbGl0eQ== IEJhdGNo UkFN IGVuY291bnRlcnM= LlF1 QllURQ== IERpc3RyaWJ1dGlvbg== IHVzbw== IFJlY292ZXJ5 YXBwcm92ZWQ= IGRlbmlhbA== L3NoYXJl TGlua2VkTGlzdA== KQ0KDQoNCg== dWRkeQ== IGZpbmVz IHJ5 VW5pY29kZQ== CXJlbmRlcg== IHByZW1pc2Vz IHBvbg== YWxpYXNlcw== L0ZvdW5kYXRpb24= Y3VkYQ== IENvY2s= LDop KGZvbGRlcg== IG3DqWQ= ZHJhZw== IHRhbGVudHM= ICAgCgo= 0LXRgdGC0LI= bW9i LnltbA== IGFzdGVy IGRpc2NyZQ== Z29hbA== IEdUWA== IFNVQ0NFU1M= IExPTkc= KGZpbmQ= IHNpbmd1bGFy X3N6 IEV0aGVyZXVt Li4K IGlycmVz Jykpewo= IG1pbmlzdGVycw== U3RlcHM= aXZlcnNhbA== IE5ldmVydGhlbGVzcw== LWxlZA== ICglKQ== 56Gu IHRpbWV6b25l IHN0cmFuZ2Vy KHJlbmRlcg== IHNodXRpbA== IG1waA== IHRyaW8= cHB5 IHByZWRvbWlu IGVuZG9ycw== IFJ1c3NpYW5z CXJvdw== IHdpemFyZA== LnNlcmlhbGl6ZQ== IGNvbXBsYWluZWQ= IHNpZG8= IGRlbGlnaHRlZA== LW1l IFJhdg== SHVtYW4= YWRheXM= cmVjdg== V29ya2luZw== SnVtcA== IMOlcg== IEF1dG9tYXRpYw== X0Jhc2U= 5qC8 YXVyYW50cw== wq8= 5rg= KENUeXBl SUZJ KGFtb3VudA== IGJlbGlldmluZw== PW15c3Fs IGZpcg== IHJlc3RvcmF0aW9u ZXJlY28= 0KI= Xycr IGVib29r IGRlYnJpcw== KGlucHV0cw== QVlPVVQ= IHNjcmVhbWluZw== YXZpYQ== bGFuZGVy IGRpc3RyZXNz IGFzc2VtYmxlZA== IEF2b2lk KHRocmVhZA== IFJQQw== X0VYSVQ= KHF1ZXVl 0LjRgdGC RGxs IHNrdWxs X3B1Yg== Y2hleg== bWluYXRl ZW5zZW4= IGluc2FuZQ== Ym91bmRz IFJvc2Vu IGNvbmRpdGlvbmluZw== cHJvY2Vzc2Vk dmlkZW9z Zm91cg== LkNvbnY= fDsK UGVyc29uYWw= Y2VycHQ= OlVJQ29udHJvbFN0YXRlTm9ybWFs IGRvc2Vz IEthcmw= IEZyZXF1 LkJBU0U= IFZvdGU= IGNvbmN1cnJlbnQ= IE1lc3NhZ2VCb3hJY29u IMOW IER1YmFp IFJldGFpbA== Om51bWJlcg== IE9ic2VydmVy IEJpZ0ludGVnZXI= X29yaWdpbg== X1dPUks= RnJhbWVz IG5vdGFibHk= LuKAnA== IHRyb3BpY2Fs IG5pY2hl YW1pbmE= LnN5cw== KHRva2Vucw== bW9kaWZ5 b3NpdA== c3Ryb20= IENvbWljcw== T1BUSU9O VGlja2V0 IGZhY3Rvcmllcw== IGRpc3B1dA== X0ZpbGU= IEZpbm4= ZWVl IERpc2NvcmQ= X21vbmV5 LnRwbA== X3NhZmU= TEI= IGdsdXQ= Sks= LmZsb3c= LWNvbnQ= Z29z IGhvcml6b24= IFJ1c2g= Ojoq UGlwZQ== dWxsYQ== Ym9yb3VnaA== aGVpbWVy KG1vdmU= KFRleHQ= fSk7DQoNCg== d2VsY29tZQ== IENvbXBvbmVudHM= IGdvdmVybmFuY2U= Y2xvc2Vk CW1hcmdpbg== IGxhdW5kcnk= IFRlcm1pbmFs aXphcmRz LuKAlA== LnJlbW90ZQ== LnJhZGl1cw== IFF1ZWJlYw== IGRo VGVjaA== IE1pc3Q= c2VsbGVy X2xpdGVyYWw= IGdlbml1cw== IGJyYWlucw== Z2Vt IE1lYXN1cmU= IGNhdGFzdA== cmFuY2U= LlRleHRGaWVsZA== IGNvbnN1bWluZw== ICdcJyc= b3VidGVkbHk= IENlcnRhaW4= RXY= ZXJ0aQ== YmVpbmc= RXhwZXJpZW5jZQ== IC8vWw== IEFyYWJpYw== IENyaXN0 IEF6dXJl IGhvcmE= bGFkZXNo XEJsdWVwcmludA== ZGFy LnJlbA== IHN1cHJlbQ== IFJlYWdhbg== IEF0dHJpYnV0ZXM= LXNpZGViYXI= IHVzZVN0eWxlcw== IEFpcmxpbmVz IGhpbGxz L3hodG1s dmluYw== X21vY2s= CiAgICAgICAgICAgICAgICAK IFBpbGw= LkxheW91dFN0eWxl IENvbW1hbmRlcg== XTw= c2lnbmF0dXJl IHt9DQo= IGhhdHJlZA== IOuL b2xlc3Rlcm9s ICoqKioqKioq YW5jZWxsb3I= Y3JvcA== VElN CQkKCg== eXNxbGk= dWl0aXZl CXVuc2V0 X3NlbA== IG1lbnVz dGljaw== IGNvbnN0aXR1dGU= IEVsZW1lbnRz IFJlZGlz YWdnaW8= X2Zw X2RlcGVuZA== ZW1hcw== Q0FTVA== b3Jhbmdl am9u IEVtaWx5 IHBvdGF0b2Vz IHJlY2VwdG9y IEVsZWN0cm9uaWM= IExpZ2h0cw== IGNvbWJpbmluZw== IFNvbWVvbmU= ICMjIyMjIyMjLg== IFRPRA== L3Nob3c= WGQ= LiIn YWZ4 IHRyYWdpYw== U3R5bGVk IE1hcmNv R2FsbGVyeQ== ZGFsZQ== LuKAnQoKCgo= w6lyaWU= L3NlcnZpY2U= 5LqG IGFtYmllbnQ= X1NFVFRJTkdT LkFkYXB0ZXI= bGVuZQ== IHRyYXZlbHM= Tm90aWNl IGNsZWFucw== IEZlbQ== Y2hhaXI= 0YPQvQ== L215 X2JhZA== IEVjb25vbWljcw== SVNB X0NOVA== KE1lbnU= 5LqO IFJpZGdl IGxlbmd0aHk= RG90 IGp1bXBz IGhleQ== JHBkZg== IHdvcm0= IHN1dA== IHNoZXI= aWFtbw== IENhbGM= dHJpZXZl IGNvcHM= IENocm9t IHJlZ3VsYXRlZA== cmVhdG1lbnQ= IEhpZ2hlcg== b2tz IGRlemU= TE9DQVRJT04= b25nc1Rv IGZpbml0ZQ== IHZhcmllcw== IHBvc2l0aW9uZWQ= J2ls 6YeR IGhpa2U= KGRvbmU= cGxheWxpc3Q= IGFkYQ== IGNvYXN0YWw= IE5hbmN5 LkRhdGVUaW1lRmllbGQ= Q3BwQ29kZUdlbg== IFNpbWlsYXJseQ== cmV1cg== IENvbnRy IEhpZGRlbg== IEJldGE= YXRjaGVk X2luc3RhbGw= Lk91dHB1dA== TG9va3Vw IFJpY2htb25k cXVhcmVk IG1hbmdh LWNvbnRyb2xz IEJlcm5hcmQ= TGFyZ2U= IHNsaWNlcw== IG9mZmVuY2U= IE1lZ2E= IGVzdGFy IGpvaW50cw== IHN1bW0= X3BsYXRmb3Jt QnVmZg== LmFkZFN1YnZpZXc= IHJldGFpbmVk TGV0dGVy LmRpbQ== IGVzc2VyZQ== IFNjYWZmb2xk RVhQRUNU CVJF LmxvbmdpdHVkZQ== w7xuZA== IHN0YXR1ZQ== LmFkZFdpZGdldA== IENhcmliYmVhbg== YWRkUHJlZmVycmVkR2Fw aWxkZQ== VUlMYWJlbA== IE9wcG9ydA== IGltcGVyaWFs dXJzaW9u IG1hbmRhdGU= IHByb21vdGlvbmFs IHZr aWHFgg== IHB5bA== IENyZWF0aW9u 0L7Qt9C0 IHNpbXBsZXI= LndoYXQ= IFJlY2VudA== U3Rvcm0= LnF1YW50aXR5 IExvdg== Ii0= dWJibGVz X25vdGlmaWNhdGlvbg== KHdvcmxk dXJnZXI= Kigt OiIK aG0= YW5zaGlw IEFsbW9zdA== IG1vdG9yY3ljbGU= X2ZlZQ== IGFic29yYg== IFZpbmNlbnQ= IHNvdW5kZWQ= w61zdA== IHBoYXJtYWNldXRpY2Fs aHRhZw== IEtpbmRsZQ== aXRhbGl6ZQ== IEVtcGVyb3I= b3VzdGlj IHNwZWNpYWxpc3Rz 5YWs Qm9yZGVyU3R5bGU= L1w= UkVMQVRFRA== KCcsJyw= KGV4cHI= IGh0 5Y2I X0NyZWF0ZQ== IHNwZWNpYWxseQ== IFtdOw0K IGhlZWw= IHNlcHQ= X2FyY2g= KGluaXRpYWw= JS4KCg== XCIsXCI= IGRpc2N1c3Nlcw== IHVwdA== IFsm IG1hbnVz LmhhbmQ= IE1BSU4= IERlbm1hcms= IF0sDQo= IGNyeXN0 IG5hY2s= Q29vcmRz X2lubmVy IG1pZHN0 IGF3YWtl INCe LWJyZWFr w612ZWw= X1BBU1M= IFBhcmFtcw== IGRldHI= IHNwaWRlcg== IENvbmNlcHQ= IHByZW5k Q0hFRA== LkV4aXQ= IHBvcHVsYXRlZA== IHZpcnR1ZQ== X1NFU1NJT04= IG5vdXZlbA== b2F1dGg= INC00LDQvdC90Ys= cmluaw== LkhlYWRlclRleHQ= YXR1cmF0ZWQ= IGVyc3Q= IOWF 4KWH X3Zpc2libGU= ZXllcg== IGxpYWJsZQ== IGRlYmU= IGJ3 ey0j X1dJTg== ZGZz SG92ZXI= IFBVVA== LWFuZ2xl IG5vYmxl IHRyYWNlcw== ZW5jdg== IHVzZXJEYXRh X2lucw== IFN1eg== IG5ld3NsZXR0ZXJz IE1vZGk= IGVudHJlcHJlbmV1cnM= IHRyaWJ1dGU= IHJ1bW9ycw== IHJy IFF1YXJ0ZXI= 6rOg IGZlZWRz w7Nn IGVudmVsb3Bl IGxlYXI= IGvDuA== ZGV2ZWxvcGVy U2ltaWxhcg== OiIpCg== c3Vic2NyaXB0aW9u TW9kaWZpZXI= aXRhbGlj IG5hc3R5 IHRlcm1pbmF0aW9u IGNoYXJtaW5n IOKf dG9ucw== LnRyYWNl aG90cw== IFVS TW9udA== IGp1c3RpZmllZA== IEdhbmc= aW5lYQ== IGJvZw== KGFw XyQ= IGNvbnRhbWlu LkRvdA== CURlYnVn KGV4cG9ydHM= IHBhaXJlZA== IEFzc2lnbm1lbnQ= IGF1dG9tb2JpbGU= k40= IHBoYXNlcw== dnc= QFN1cHByZXNzV2FybmluZ3M= PVw= cmFudA== LWVk CWF3YWl0 IGNlcnRpZmljYXRlcw== Jz4i IGludGFjdA== Q1RSTA== TWlrZQ== Z3JlZ2F0aW9u QVRURVJO IHJlcHVibGlj X3VwcGVy aWxpYXJ5 IGNvbXB1dGF0aW9u aGlyZQ== IFNoaW4= X0FOWQ== IE1hbnVmYWN0dXJlcg== IENhcm0= IGJlYXJpbmdz X2NvbWI= Y2Fk dXJpc3RpYw== IHdob2xlc2FsZQ== IGRvbm9y LmludGVyZmFjZXM= cHJlc3Nv IEJydW4= LWNsb3Nl cHJvdmU= X1NL CWZyYW1l ZXRyb3M= IFBhaW4= X0VYUA== IExU X2Zz LmRhdGFz CXNz dm9pcg== IEF4aXM= TWFqb3I= PSI8 W2g= IHByb2Zlc3M= aWdyYXRl KHNjb3Jl S2V5d29yZA== Im9z ICAgIAkK YW5hbHlzaXM= IHJlcGxheQ== LnBhc3M= XGQ= dGxz IHNhbmN0 LmxpZ2h0 X21vYmlsZQ== 0YHRgtGM CXRvdGFs dWl0eQ== IHBhdXNlZA== TkFT IGVuY29yZQ== bG9l IC0qLQoK LmhpZ2g= YW1wbGVy IFNlY3VyZQ== IGZyYWdtZW50cw== X3ZlbA== aWxsYXJ5 IFN0ZWlu IERhd24= IG1heGltaXpl 4Lii IC9e IGNvbnRpbnVhbGx5 IHNoYWRvd3M= CSAgICAgICAgICAgICAgICAgICA= IElBY3Rpb25SZXN1bHQ= IGluZm9ybWFjacOzbg== Q0hFQ0s= LlNlbGVjdGVkSXRlbQ== YnVuZGxl b2xsZXk= PEludA== QUlORVI= IFdpbmc= dGl0bGVz b3VudGFpbg== Q1k= IExvY2FsZQ== Zm9ybWVy PGNvbnRleHQ= UmFkaW9CdXR0b24= X3NjaGVkdWxl IGZhYnVsb3Vz Um9iZXJ0 X1BST0ZJTEU= IGdhdGVz SU1Q IFBlbnRhZ29u Z29sZA== YmFjaA== ZW1wbG95ZWVz Um90YXRl IGNoYW1w IHNlbGJzdA== QWx0ZXJu IGNvbnZlcnRWaWV3 Lyw= IH4o U3RyZWV0 X3BsYWNl IHBlcnNvbmFsaXplZA== UHVibGlzaGVy IFNPQ0s= X05BTUVTUEFDRQ== IFN0YW5kYXJkcw== c29ldmVy X0NFTlRFUg== SW50ZXJlc3Q= w7R0 dGVtcGVyYXR1cmU= Vmlld3BvcnQ= Z2V0UmVzb3VyY2U= IGVhdGVu IHNlbXByZQ== IGFibm9ybWFs IGN5bGluZGVy IHRyb3VibGVz bm9k 0YvQsg== Z2FtZXM= X2ds UGxhbmU= Z3JleQ== X3RibA== LkNvbXBvbmVudFBsYWNlbWVudA== IENoYXNl TG9nZ2luZw== bWFueQ== 7IY= IGZsYW1l PSI8Pz0k IEdyb3Vwcw== LVU= 0YDQsNC9 CgoKCgoKCg== IHZhdWx0 b21vbg== cHJvYmxlbQ== IHRyYWRlcnM= IHBlcmlwaGVyYWw= IGhvbWVwYWdl KGRlcw== IFN1Y2Nlc3NmdWxseQ== IHJlYm9vdA== IGNlbGx1bGFy aWlp IFBsYW5z bGlzdGluZw== CWRpcw== IFJlZmxlY3Q= CWV4Y2VwdA== Iiko IHRhbWLDqW0= VmVoaWNsZQ== YWNjaQ== bHVzaA== T3JkZXJCeQ== IGltYWdpbmVk Y29kZWM= IGRhdGVUaW1l TWljcm8= IHJlbWluZHM= IGZydXN0cmF0aW5n IFZpc3Rh VHJhaW4= INCy0YE= IG1vbGVjdWxlcw== YXZpbg== IGRvdWJsZWQ= IGJyYWtl IGNhbGNpdW0= RnJpZGF5 IElkZW50aWZpZXI= 5Z8= 0YvQuQ== IEphaA== UmVu IHNjYW0= IERlbm5pcw== LnNldEludA== 4p8= IGFwcGVhbHM= IEF1cg== IHNwbGFzaA== ZXF1YWxzSWdub3JlQ2FzZQ== d2h5 IHNhcA== U3VwcG9ydGVk IHNlcmE= IDoi IFZlcm1vbnQ= IHJldW4= IE5vdmE= ICAgICAgICAgICAgCiAgICAgICAgICAgIAo= UmF0ZWQ= IGxheWluZw== IEthcmVu LkRlc2VyaWFsaXpl IGNvZGVj IHRheHBheWVycw== OyIpOwo= IGNydWRl IG1vbGU= IHVzZUNvbnRleHQ= CXJlc3A= IHBrdA== IENhbm5vdA== UGlwZWxpbmU= 5YaG dGljYWw= QWN0aW9uQmFy YWVkYQ== IENyaXRpY2Fs IE5hZA== IGJsZWVkaW5n IGxsdm0= L2N1c3RvbQ== IFNpbXBzb24= U3k= aXRhYmx5 IFN1bW1pdA== KCkpKS4= RUxMT1c= JCcs TWV0 SW52b2ljZQ== b2xpc3Q= IHNwaW5l YXV0aWZ1bA== cGFpZA== IGxvY2tlcg== X2FybQ== XCI+PA== IHRyYWplY3Rvcnk= X3Jpbmc= IGh5ZHJvZ2Vu dHJvbg== IHN0YXR1dGU= IGNvbmRpdGlvbmFs IHRyYXk= LXNjaG9vbA== KHdpZGdldA== JGNvbmZpZw== IHJlcXVlc3Rpbmc= LnVpbnQ= ZXRvbg== YnJpdGllcw== T2ZUeXBl QURNSU4= cHJlZGljdA== IGdlZ2Vu IEhhcHA= T0NVTUVOVA== IEFwYXJ0 IC0tLS0t cm9l dWlkZQ== anVzdGlmeQ== IFNxdWFk IHByb2Zlcw== LmJvdA== X2N1cnJlbmN5 aW5uZW4= IE11bWJhaQ== IE51bWJlcnM= YXZhbmF1Z2g= YWduaXR1ZGU= 4oCcVGhlcmU= PWh0dHA= 54mH IHZi Kyc8Lw== IG9yZ2FuaXppbmc= YW5pdW0= SW5TZWN0aW9u LmFuZA== IGV0ZXJuYWw= IHNvdWxz X09ORQ== X25z X2Jhc2lj IHJldFZhbA== LXNoYXBlZA== aWZkZWY= IE1vemlsbGE= IGVpZw== Y29tcGxldGVk Tm90aWZpY2F0aW9ucw== VEVDVA== cmllbg== Y29vcmRpbmF0ZXM= IHByZXRlbmQ= cG9uc29yZWQ= LnN0ZGVycg== IGdhbWVycw== IGRlZmVuZGVk VG9vbFRpcA== dWl0YXI= IGZyYW5jYQ== IFdvb2Rz IGlocmU= IHBzZXVkbw== IGNyb3dkcw== IFNZU1RFTQ== bGVj LmtlcmFz IGNpcmN1bGF0aW9u ZWVy LmNi dXp6eQ== 7Zg= LnJlYWRlcg== IHNlcXVlbA== U2V2ZXJhbA== LnBvcnRhbA== LS0tLS0K aXN0cmFy 77u/Ly8= UGk= IFwiIg== IGN1c3RvbXM= IGRpc3BsYXlOYW1l IG5vdGljZXM= IGNhcmI= Ll8KCg== IHByb2R1Y3Rv INGB0Ls= IG51bWVyaWNhbA== IHVuaW50 IGNvZGlnbw== T3JkaW5hbA== U3RyaW5nVXRpbHM= IGTDqWM= IExhbg== IHNob3djYXNl IGFyaXRobWV0aWM= LXNjcm9sbA== X1RFTVBMQVRF IFJvdXRlck1vZHVsZQ== IFNoYWRlcg== INCd cG9saWN5 UGVyZm9ybWFuY2U= CWJvcmRlcg== KGZpbGVwYXRo 56m6 X2VuZXJneQ== X0NT VGhlaXI= LnNwYWNpbmc= KGRw IExBTkdVQUdF IGhpc3RvcmljYWxseQ== Ij57eyQ= IGlub2Rl c2ls IGhhY2U= IHNldmVyZWx5 IE92ZXJ2aWV3 IHNwcmF3 IGJlYWNoZXM= OmxlZnQ= t7s= KCR7 IEZJUlNU IFNwYQ== LWFzcw== IGJhaXNl IE5PREU= IFBpenph UGV0 KHNlcQ== XCI+Cg== Q3BwTWV0aG9kUG9pbnRlcg== IHZw IGlh X3NlY29uZHM= ZW1ldA== L2Jsb2I= X1RIUkVTSA== Li4uDQo= RGVzdA== IE5I LmRhdGFTb3VyY2U= aXTDqXM= IEphaw== c2VsbA== IHdvcmtzaG9wcw== PHU= IHJpdmFscw== IEVYSVNUUw== aG9t LXRva2Vu Y29tcGF0aWJsZQ== LkpQYW5lbA== IHBoeXNpY2lhbnM= YXJ0aW4= IGRlc2lyYWJsZQ== IGRpc3RpbmN0aXZl LkRlcA== Z2lk aWxpYXRl LG1heA== IHByZW1pZXJl IHFEZWJ1Zw== IGFkdm9jYWN5 IHdoaXNwZXI= UHQ= IHVuY2hhbmdlZA== X3F0eQ== 6K+35rGC U2Vhc29u YXZlbGVuZ3Ro IFB1bA== IGTDrWE= J11dXSwK YWxpcw== KCIm Ym9ybw== IGJt IFJhZGk= d3Jvbmc= IEdvaW5n aW1lVHlwZQ== aWpp LWZlZWRiYWNr IE5hbWVz IEJhcHQ= IHByb2JhYmxl IEV0aGVy IFBvbGl0aWNz X3Byb3RvY29s bGluaW5n U2F0 IGNvcnJlbA== LlByaW1hcnk= KG51bGxhYmxl UklPUklUWQ== IGNvbG9yaW5n IHV0aWxpemluZw== ZGFz IGV4cG9ydGVk IGNhcnJpZXJz Q29udg== LmVkaXRvcg== acOz KGhhbmRsZXM= IGFwcHJlY2lhdGlvbg== LmltcG9ydA== IEF1c3RyaWE= IFN0cmlw aWxpZ2h0 IGFwcHJvcHJpYXRlbHk= IFByZXN0 IFdpcg== IFVJQXBwbGljYXRpb24= YWxjaGVteQ== IE1vYg== IERldGVybWlu ZXJndXNvbg== cmVnaXN0ZXJlZA== X2NvbnZlcnQ= IFZsYWRpbWly LlNob3dEaWFsb2c= cmVmbGVjdA== IHNob29r IGFzc3VyZQ== IE9mdGVu IGNpdmlsaXphdGlvbg== IHZvY2FidWxhcnk= Zm9yZWdyb3VuZA== IFNjb3Bl IHVud2FudGVk YWN0aW5n IChbXQ== IG1hcmtpbmc= Lm9yaWdpbmFs IE1PVkU= IHNwb3J0aW5n Y2VwdGlvbnM= TlNOdW1iZXI= U2l6ZXM= IHByb3ZpbmNpYWw= X1RyYW5z IHByb2JsZW1hdGlj ZGlnaXQ= IEVtbWE= bG9ja3M= IENyZXc= aWJh Jyk6 aXNoYQ== IG1hbW0= IG9jY3VyZWQ= d2Nz KHJ1bGU= IG1lcmNoYW5kaXNl ZXNwZWNpYWxseQ== IFR3aW4= IG5hbWluZw== IHNsb2c= IGltcHJvdmVz IGFkaGVy OnRleHQ= LmhhZG9vcA== X0hUVFA= LnRvTGlzdA== LmRpc2FibGVk IGxlbnNlcw== LmluaQ== IFJhcmU= IFVidW50dQ== IHNjcmFt b2xhdGlvbg== dGl0dWxv RXZlcnl0aGluZw== IG5vZGRlZA== aWNodGln X2NvbnN0YW50 emM= bGlmdA== IE5vdGlmeQ== b25kbw== IElORg== KCIr IEtheg== IGRyZWFk Lm1hcHBlcg== bGV1cg== IENvbWV5 IE5C aWNlcnM= LlB1c2g= IEhhY2s= IEJyYXppbGlhbg== X3Byb2Q= IC8vCgo= IGJpY3ljbGU= IHVuYXZhaWxhYmxl IGFkb2xlc2NlbnQ= Ymxr IG1pdGln X2JsdWU= 7Jg= ZmFkZUlu IFV0aWxpdGllcw== IE1O O2s= PHN0eWxl LXN0YXR1cw== aW5kbw== IGlubmluZ3M= IGdq IHx8PQ== LmV1 Ok51bWJlcg== IGN1aXNpbmU= IFVSTHM= aWVr IHdpcmVz CXBz aWVn Lm1r c29hcA== IHNvbWV0aW1l IHN0YXA= X3Nlcmllcw== LlRhcmdldA== 5ro= LmRlc3RpbmF0aW9u T1VOVEVS UmFpc2Vz JkE= IHNtYXJ0cGhvbmVz TklFbnY= LnNkaw== IGhlbGljb3B0ZXI= IGltcGU= IEJpcnRo QVU= YnJlYWRjcnVtYnM= Y29vcmRz IGV4cGxvcmVk IGxvZA== IElw Z2FibGU= aWFuZQ== IGFydGlmYWN0cw== Qm94TGF5b3V0 2KfYsQ== bGlzdGVuZXI= LmNhcnQ= IEh1ZmY= IEhpbmR1 IERhdGFUeXBlcw== IERydXBhbA== SUdOT1JF IG9mZnNldHM= IFJUQw== LWxvZ2lu 5q4= IFFPYmplY3Q= IHByb3NlY3V0b3I= Um9jaw== X2NoYXQ= V2F5 7LI= IG5lZ2xpZw== IGR1ZGU= Ozw= IGRlbGVnYXRlcw== X2ZhaWxlZA== L2Rldg== L3dvcms= KE5ldw== ZXRhYmxl KCki KEljb25z IHBvcms= IE1vZGVsQW5kVmlldw== IFZJUA== IEtvcg== bWl4 IG94aWQ= IFNDUkVFTg== IEZvdXJ0aA== LyIsCg== IHRlZQ== IFN0ZXZlbnM= dGlja3M= IHBsZWRnZQ== aWJib24= IExvYW4= IG5lbw== bnVtcHk= IFNoYXJlZFByZWZlcmVuY2Vz LW9yaWVudGVk IExvZ2dlckZhY3Rvcnk= IEdyYXBoUUw= emVuaWE= Il8= V29tZW4= LmNhc3Q= IGRlbGliZXJhdGVseQ== K2I= IEFybg== Zm9udFNpemU= IG1hemU= IGJsYW1lZA== Lm1hcw== fSkNCg== ZWxlcmlr IHNjYW5uaW5n IFdvcmtzaG9w IGZpbmRlbg== IGNhdXQ= VUlGb250 KHJldHVybg== YWxpbg== Y2FzdGxl Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8v IGluY2VudGl2ZQ== b3BhdGg= YmxvYg== IGNpZ2FyZXR0ZQ== IGZlcnRpbA== Ki8KCgo= IFNoYXI= CiAgICAgIAo= IHVuY2VydGFpbg== IFN0b24= T3BlcmF0aW9ucw== IFNwZW5jZXI= IGRlZmlu IFNvbG8= b25lc3Q= t7vliqA= IHVvbW8= R2l2ZQ== IGRlbnRybw== O3BhZGRpbmc= ZW50YWk= IENhcnM= IGVudGh1c2lhc20= IE9wZXJhdGluZw== U2tpcA== cGFyYXRpb24= IHByb3RlY3Rz IHJldmVy ZGc= IENpbmNpbm5hdGk= IGNvbnNlY3RldHVy IG11c3M= ZW1wbG95ZWQ= YXVzZXM= aW5rbGU= LlZhbHVlcw== o7w= bG92 X1dBUk4= IGJvb2ttYXJr IEFwb2xsbw== LmF4aXM= IG3DqXQ= IG9wZW5lcg== IHR1bW9y ZGFu IGVsZW1lbnRhcnk= IHNraXBwZWQ= IEtlcg== YXNpYQ== X3Jlc3A= IGRlbW9s IENhbmFkaWFucw== IHRhc3Rlcw== VUludGVnZXI= ICckew== LmF3cw== Uk9JRA== cmlhbnM= TVE= b3JkYWJsZQ== IGNvdXNpbg== UHJvcGFnYXRpb24= KFNlc3Npb24= cGhhbHQ= VUxE IFNjYWxhcg== IGJsb29keQ== IOCm Lm1hc2s= LHE= IFVuaXRz IGNlbnRyZXM= IFByaW0= Ll0KCg== IFNoYXc= UHJvbQ== IFRob3VnaHQ= Q2hlY2tlcg== X291dHB1dHM= KGNoYW4= RUlOVkFM IGJvYg== X2NtcA== UGVk IG1hdHJpY2Vz IHZyb3V3ZW4= IGdlbnVpbmVseQ== aGlnaGxpZ2h0 KGRpc3BsYXk= KSE9 IGRlbGljYXRl IEx1dGhlcg== IE1pbGVz IHVzZXJJRA== JT0= YXRldXJz X0JVRg== LS0tLS0tLQo= aW1pdGl2ZXM= IHNoZWx2ZXM= c2xvdw== X2luZm9ybWF0aW9u TEVH V3I= LmZvcm1z Y2VsYW5k L3Vu OiY= LuKAmQoK PSIl IHByb3N0 IGZvbnRzaXpl dWNpw7Nu Z2V0aWM= YW10 PSIu RGVjb3I= QnJpdA== ICIiKS4= IGZvdW5kaW5n LkZpbGVOYW1l IFRpZXI= IGRpc2Nsb3Nl w6Ft LnN5bg== LlZpZXdIb2xkZXI= bGljYW50 X3N0YWdl TW9uZGF5 IGRlc2VyaWFsaXpl dGFsaw== IHRyYWRpdGlvbmFsbHk= 5oCB 2K4= TEVY IGVo CVJPTQ== IHt9KQo= UXVlc3Rpb25z bmNweQ== IGZpeGluZw== 0LrRgw== X0tleQ== Ong= IFNUUklORw== INGE0LDQuQ== CWxlZnQ= IEJlbmNo ZWxsaWo= VVJSRUQ= IERpYWdyYW0= fWNhdGNo L3RpbWU= IE1pc3Npbmc= ZGJuYW1l IHNvcmU= IFdhbHQ= dWdnaW5n cmVwcmVzZW50 IEdT bmV5cw== CXBhZ2U= IHZvbGNhbg== KGJ0bg== IGV4Y2VlZHM= IGVyZw== IHBpbG90cw== IFNlZA== ZXJzaW9ucw== IHBhdHJvbg== UlY= L3RvcA== LmFzc2V0 X2Nyb3Nz LkVkaXRvcg== LnRi IHdlbGNvbWluZw== U0NSRUVO KWZpbmRWaWV3QnlJZA== Q29kZXI= PElBY3Rpb25SZXN1bHQ= X1FVRVVF 4YM= IGhlaWdodHM= UmVxdWVzdHM= IHN5bWJvbGlj DQ0KDQ0K IGNvdXBvbnM= LWZpdmU= IERlc2t0b3A= IG1pc21hdGNo ICdfJw== X0RJVg== QVNPTg== LnRyYW5zcG9zZQ== KG1hc2s= IENlbHQ= LkhhbmQ= YXR1 asSZ IHt9KTsK TWlzcw== IHByaW1h bXVuZA== b2x2 IFByZXR0eQ== IHJlYmVs IEZE YXN0aWNhbGx5 T0xU LWF4aXM= dXhl IGVpbmZhY2g= IENoZW1pY2Fs X3NlZw== bGVldGNvZGU= bG9wZQ== X29yaWc= ICAJCQ== KERvdWJsZQ== IFBheVBhbA== LkJhY2tncm91bmRJbWFnZQ== IGhvbWVtYWRl Liku KHBhcnNlcg== YXRybw== YWNjb3JkaW9u RGVmaW5l IOyeiA== IEFVVE8= LnN1bW1hcnk= c2NhbGFy IEhvb2Q= cXVpbg== X2Rlcg== IEdlc2No LmNvbXB1dGU= RmVlZGJhY2s= IHBoYXJtYWM= IMWfaQ== IGdsb3Nz IEZJTFRFUg== SU5TVEFOQ0U= IGthbA== LlBM X0ZSRUU= R3JhZGU= IOKZ Lm1ldHJpY3M= IGNhZ2U= Llh0cmFHcmlk X2Rz emln aW50ZXJvcFJlcXVpcmVEZWZhdWx0 LnJlbW92ZUNsYXNz PT09PT09PT09PT09PQ== IG1hc3RlcnM= U3RhdGVFeGNlcHRpb24= aWxsZXJ5 IEJyYWR5 IGxpbmluZw== X2Nz aW5zdWxh IH06 W3Bvc2l0aW9u IFJ4 IEJZVEU= IFN0cmlrZQ== INCa IENsdXN0ZXI= LmRvd25sb2Fk QWxsb3dlZA== IGFtZW5pdGllcw== IG9uVGFw ZnVsV2lkZ2V0 IHN0cmVuZ3Rocw== dHdlZXQ= IGFzY2VuZGluZw== IGRpc2Nsb3NlZA== Z3Jhdg== ZGlzdHJpY3Q= KTw8 KSwi KGRlZnVu X3w= IGdhemU= 0LDRjw== IGZvcnR5 PT09PT09PT09PT0= U2NpZW5jZQ== c2VtYmxlcg== CWJvZHk= X3RyYW5zZmVy IGxvbmd0aW1l IGNvbXBsaWNhdGlvbnM= IGJvb3Ro VkVSUg== IHlpZWxkcw== IG5hdmlnYXRvcg== OjpfKCc= RUNUT1I= X0NvbmZpZw== IGxhc3RlZA== dXNhbA== 55m75b2V IGdsb3Zlcw== IGJlbGx5 U2FsZXM= KE1ldGhvZA== KG1lbWJlcg== IFJlZWQ= cGFzc2Vk U2lnbklu LG51bQ== VUxPTkc= IExFRw== bmVscw== IG1lbnRvcg== KHJj IE9idmlvdXNseQ== Lmlm IEZyZWRlcg== SEVBRA== QGF1dGhvcg== Q29uZGl0aW9ucw== IGdhcmRlbnM= IFJpcA== KHVzZXJz IE9rYXk= IHdyZXN0bGluZw== aW1lc3RvbmU= IENlcnRpZmllZA== IHZlcmRpY3Q= YWlkYQ== LmlubmVyVGV4dA== aWNhc3Q= CWF0 IHByZXN1bWFibHk= IEZVTg== YWplcw== 0Jc= PiIsCg== X1Bpbg== dWVzZQ== IG92ZXJyaWRlcw== X3JlYWR5 QWR2YW5jZWQ= IG9waQ== LWNhcnQ= KCIvIiw= IERlYg== Q1JZ IFZlcnRpY2Fs IE9WRVI= IENvcnBvcmF0ZQ== ICIiOw== IHN0ZXBwaW5n ZWo= IGFjY3VzYXRpb25z IG9yYXo= X3RhaWw= IGluZHVjZWQ= IGVsYXN0aWM= IGJsb3du LC8v IGJhY2tncm91bmRz 4oCZdW5l LXNkaw== IHNldEludGVydmFs IGluY2VudGl2ZXM= IHZlZ2V0YWJsZQ== X09u ZXhwYW5kZWQ= cGl4 X3NoYWRlcg== IFNQRFg= QGV4YW1wbGU= IFdyYXBwZXI= Llplcm8= UG9zaXRpdmU= IHNwaW5uZXI= IGludmVudGVk IEdhdGVz 0L7RgtC+0YA= IGNvbXBhcmlzb25z 6Lc= LnByaW1hcnk= ZGF0YVByb3ZpZGVy YWRkaXRpb25hbA== CW9wdGlvbnM= c25hcHNob3Q= LnNldEhvcml6b250YWw= ICJ7fQ== IEZpc2hlcg== aGFsdGVu PFR5cGU= IG1heExlbmd0aA== IE10 IOqwgA== LmpldGJyYWlucw== IGlkZW50aWZpZXM= IGZsb3dpbmc= IERpc2N1c3Npb24= YXRzYnk= IHNjaHc= dWdodHk= IHJpdmVycw== LnVuaXF1ZQ== X1BIWQ== ZWRyYWw= KGxs IGNzcmY= cHBlcnM= w7xs IEVzcGVjaWFsbHk= cG9ydGVk IEhhcnJpc29u KioqKioqKi8K VGV4dENvbG9y 7Iq1 d2lyZQ== IHN0YXR1c0NvZGU= IEZpbmlzaA== Y2VuY2U= IE1jQ2Fpbg== IFdvcg== KGF3YWl0 ICktPg== IFJlZ2lzdGVyZWQ= SU5FRA== a2Fs cGFyaXNvbg== IG9iamV0bw== Vmk= bWFuZGE= IHJlbmV3ZWQ= IFNvZg== ZXNzZWw= Lm5kYXJyYXk= IGNyYXA= 566h LmFic3BhdGg= KHVw IGNsZWFyYW5jZQ== IFRX X0NPUFk= ICAgICAgICAgICAgCQ== IGZvcmVzdHM= IGFyZ3VhYmx5 IEFTUw== aGV5 YW1lbA== X2ZvcmU= IFNvdXRoZWFzdA== IGFidXNlZA== IHByYWN0aWNpbmc= YWtlZGlycw== 5Li7 X3Jlc291cmNlcw== IHBvbmQ= LkZpeGVk TGFzdEVycm9y IFBzeWNob2xvZ3k= ICIvLw== ITo= UmV1c2FibGU= IG1lbnNhamU= IHJvc3B5 IGJvdXI= IHZhcmlldGllcw== IGVtcGF0aA== KCh7 X29yZw== IE1lcw== IE1hZ2VudG8= SVNUT1JZ VW5sZXNz IGhq IER1dHk= SnVu LHNpemU= IHBhaW50aW5ncw== IGRpc3BlbnM= ZGFydA== IGJlaGF2aW9yYWw= IHJwYw== Y2FsY3VsYXRl ZnJ1aXQ= X21t CXB0aHJlYWQ= TWF4TGVuZ3Ro IGN1cnJlbmNpZXM= X2NhcGFjaXR5 IE96 IGZpcmVhcm0= IGNvZWZmaWNpZW50 IGJhbmtydXB0Y3k= d2FydA== IGZhdGlndWU= QVZB IGVzcGE= X3Bj IFF1b3Rlcw== X0xJR0hU IFRpY2tldHM= IHJlbGF0ZXM= IHB1Ymxpc2hlcnM= IHVubG9ja2Vk IC8vLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== IEludGVycnVwdGVkRXhjZXB0aW9u IG91dGxvb2s= cm4= IHJlYmVscw== V3JpdHRlbg== IGFzaWFu b3R0bw== IAkJCQk= X2dwdQ== VHh0 LkltYWdlVmlldw== IHN1aXM= X3RhYmxlcw== LlJlY3ljbGVyVmlldw== IHdoYXRzb2V2ZXI= 6IE= XSsrOwo= YXNzZXJ0VHJ1ZQ== X3ZlcmlmeQ== IFJpdmVycw== IF1b SmV0 aWRpYW4= U2libGluZw== IGdlbnJlcw== LkFjY2Vzcw== T1BT IHRyaXZpYWw= 4Liq YWxlbg== 0LLQtdC0 IFN3b3Jk IHNjcnV0aW55 KGNi IGNvbW1lcmNl IGd1YXJhbnRlZXM= X2Fkdg== IExFVA== cmVjaW8= IGhpbGFy IGJhY2t5YXJk 44CP IGlsbHVzdHJhdGVk L3ZlbmRvcg== LlV0aWw= IHdvdw== TE9Z IE1hcnNoYWw= Ij4nLiQ= IEJhaw== IG1vZGlmaWVycw== ZGljdGlvbmFyeQ== IFN0cmU= bXVsdGlwbGU= IikpLA== IENvcnQ= J10iKS4= KGFkbWlu IENyZWF0b3I= SW50ZXJuZXQ= KG1z bG9neQ== REVDTEFSRQ== IE1hcmN1cw== PDw8PA== 44Gg X215 KGluc3Q= IHNjaWVuY2Vz TkRFUg== LmVudGVy IGl0dQ== IGJlaGF2ZQ== UGFu b21iaWVz PSc8 JykpOw0K IE1FTlU= IFdvcmtlcnM= Lk5vRXJyb3I= IGJpbmRpbmdz IGRpc2FiaWxpdGllcw== e1w= IE11bmljaXA= IGNvcmVz dXJwbGU= IE5va2lh dXNpb25z IEZpdG5lc3M= LmhhbmRsZUNoYW5nZQ== IGphdmFzY3JpcHQ= 7JqU KGRlYw== IHBhY2tpbmc= LWRlcGVuZA== IHRyYW5zY3JpcHQ= emVyb3M= X2FsZXJ0 PyIsCg== bGlicw== sdC+0YI= IHwKCg== dHJhaW5lZA== IEdlbnQ= IFJhYg== eHA= X2NvbmZpZ3VyYXRpb24= 5aSp X2FjY2VwdA== LnJlY3ljbGVydmlldw== OnVybA== IE11aGFtbWFk IHByaXZpbGVnZXM= X2Jhbms= dWt1 d2FsbGV0 IFJPT1Q= IGVuY3VlbnQ= P2ZhbWlseQ== CXBvc2l0aW9u IGNn IHByZWNpcA== bWV0aG9kcw== X2Zhc3Q= aW5jcmVtZW50 IFRpZ2Vy X09DQ1VSUkVE cXVpcA== IEhBUw== X2RvbQ== IHdyZWNr Ymo= IGRlcm4= IG9yZ2Fucw== LmVudHJpZXM= IF8oJw== cmFtZW50bw== IEphbWll IHB1bms= SVBQ IHByb2dyYW1h IGF0dGFpbg== IHByb3Zlcw== L3NpZ24= IGFuc3dlcmluZw== IGxhZGRlcg== KioqKioqKioqKioqKioqKioqKioqKioqKioqKg== IFdhbG1hcnQ= IENPTlRFTlQ= ZHVjdG9y IHZlcmJhbA== IFBJRA== Y3J5cHRv X0NBTExCQUNL ID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PQ== IHBvdGVudA== IHNob3J0cw== LlVyaQ== LnVuaWZvcm0= O2JvcmRlcg== IFdlcg== IGhlcmVpbg== bGxh IElocg== UGl4bWFw bGl0ZXJhbA== ISkKCg== Z2VuZXJpYw== cnVzdA== X3NjcmlwdHM= b3N0bw== aXR1cw== IENvYWxpdGlvbg== IHJlbW90 ZGVwbG95 IEVhZ2xl 44CB44CM IGltcG9ydGFudGU= CW9iamVjdA== IHNlYXNvbmFs bmVq YWlkdQ== QmluZFZpZXc= IFNpZXJyYQ== LWJn IG1ha2VTdHlsZXM= W29mZnNldA== R2FtZXM= IGhvcm1vbmU= QVJJTw== aGVhZHM= KHNlbGVjdA== IFN0YXJ0ZWQ= QHBhcmFt X2RlY2w= X2Jsb2c= IGHDsW8= XEFwaQ== IE1pbHdhdWtlZQ== UHJvdmlk QW5pbWF0ZWQ= IGNvb2xlcg== IFNlZWQ= LkVkaXQ= z4Q= IFRha2luZw== IGJvcmRlckNvbG9y LWZvdW5kZXI= LkxvZ2dlckZhY3Rvcnk= ICIiCgo= QUxU IExhdGU= RURJQVRF ICk7CgoK YWZh IGNhbmNlbGxhdGlvbg== QXRvbQ== IEJpcm1pbmdoYW0= ZW1wcmVzYQ== SEVNQQ== YXNjYWw= IHVwc2lkZQ== LlZlcnNpb24= IEZvbGRlcg== IEVpZ2h0 IFZpbnRhZ2U= IEFwcERlbGVnYXRl IFByZXZlbnRpb24= LnNlcGFyYXRvcg== U1RN KHJvb20= Z2VuZXJhdG9y IGNhdHRsZQ== CVo= IFBhcnRpY2xl J307Cg== IG5laWdoYm91cnM= IFN0YXRlbGVzcw== IGFsdGl0dWRl IHNhaW50 0L7QsdCw0LI= IGNvbnZpbmM= IENvbnRlbnRz IGpldW5l KHRz U2VyaWFsaXphdGlvbg== KGNvbGxlY3Rpb24= IEpheno= IERvZA== IFJvY2g= YWNpbw== Y29tbWVuZGVk REVGSU5F Lm9ubG9hZA== IHNwZWNpYWx0eQ== UExBQ0U= X01PVkU= IGFjY291bnRhYmxl UmV1dGVycw== IGZpY2tlbg== IGRlcHI= V293 Vm9pZA== LnNwYWNl 4LiX IHRx IFBldHM= PCQ= KEN1cnJlbnQ= YmVycmllcw== cGxhbmF0aW9u IGxpc3RPZg== IFRodQ== IFBSSU5U IG1pc21v IGRvaQ== Y2hr IFVuaWNvZGU= KHJvbGU= IHZpcmdpbg== PFBvaW50 X1JFU1BPTlNF LWhvdXNl IFZlbmV6dWVsYQ== RU1BSUw= IHDDumI= X2V4aXN0 QmFsbA== LkNM cmVmZXJlbmNlcw== IEJlYXV0aWZ1bFNvdXA= CUV4cGVjdA== VEhJUw== 0YPQtA== YmFuZQ== IHRlbXBvcmFs RVJJQw== ZXRhcw== IHJlZnJlc2hpbmc= IHNlY3VsYXI= QHN5bnRoZXNpemU= YWNjdXI= IG5lbGxh IFNPTA== LnBpcGU= Q2hhbm5lbHM= 6Ieq IGluc2VydGlvbg== 4buL ZWxpYQ== IGFkanVzdGFibGU= Q2FuYWRh IElURU0= IGN1cnZlcw== IENoZWFw bGV0aW5n IG9wdGltaXN0aWM= YWxsbw== IHBvbGl0aWNpYW4= X2Rvd25sb2Fk PWVkZ2U= T1JUSA== IG1vZGVsbw== YXJ0bw== LnJvdGF0ZQ== IHNlbGVuaXVt 5oiR X2FsaWFz IHJlbm93bmVk Licu IGN6eQ== IGFsbGVz LkNvbXBpbGVy IEJhc3M= Q29ubmVjdG9y LlJvbGU= TElOSw== IGNyaXRlcmlvbg== bGVtZXRyeQ== U3VjY2Vzc2Z1bGx5 L3BuZw== IGV5ZWI= YXNwYmVycnk= KGdy IGRhbmdlcnM= IGNvcnJlY3RlZA== IGdsb3c= IGVsYWJvcmF0ZQ== IEJlYXJz YXdhaQ== PSInKw== IHByb21vdGlvbnM= IG1hdGhlbWF0aWNhbA== ICJg X0dlbmVyaWNDbGFzcw== IENoZWY= LlNvcnQ= dGFibGVOYW1l UklD IHZvbHVudGFyeQ== IEJsYWRl LWVsZWN0 IENvbWJhdA== IEFiaWxpdHk= IGFiZG9t IGR1Y2s= VG1w 5YWo IGVyYXNl LlBo IERlZmF1bHRz cGFydG1lbnQ= X1VTQg== w6p0ZQ== Oyc= IHBhZHM= IE9iYW1hY2FyZQ== LlRvdGFs IGRpdmVydA== IGNyaWNrZXQ= IHJlY3JlYXRpb25hbA== KHJlZA== IENsZQ== UlU= IG1pc3Rha2Vu IE1vbnRhbmE= IHN0cml2ZQ== X3NsaWRlcg== IFBsYXN0aWM= IGRlY29yYXRlZA== IFZQ bGljbw== CWZhbHNl IHByZWZz KFwi X2ZhbHNl aWVuZG8= IEAk QnVja2V0 YWN0aWNhbA== IFpoYW5n LmNvbHM= LkJpbmRpbmc= IHdheA== X1NUT1JBR0U= IGxhd24= IHJm LlNjZW5l IENhbGN1bGF0b3I= LmRlc2lnbg== IHJlc2ls 0LvQtdC8 RW1wbG95 IFByaWNlcw== IFBXTQ== YWdp LmV2YWx1YXRl CXBhcmFt IGJyYXNz YmJlbg== IGluZmxhbW1hdGlvbg== dWxsaXZhbg== IGFubm90 IHBI aWFtZXRlcg== IEJUQw== KGJveA== U3Rvcnlib2FyZA== IGNsYXk= LmFzc2VydFJhaXNlcw== fHN0cmluZw== LkFwcGx5 IG1hdGNoZXI= dW5kZWQ= IHNhdGlzZnlpbmc= IOyglQ== UmVuZGVyaW5n X2FwcHJv aW5kcm9tZQ== QU5FTA== X2ZpeA== YnJ1c2g= Lk1hdGNo IHNtaWxpbmc= b25hdXQ= U3VuZGF5 IGRlbGV0aW9u IGVuY291cmFnZXM= UHVsbA== IHJldmVuZ2U= IHF1YXJyeQ== dHJhZGU= IGNhYmxlcw== KGRlbHRh aXRlc3BhY2U= IGZo LmJ1bmlmdQ== IHZpZWw= X0lOQ0xVREVE IFRhaWw= YWRhcg== b2Zz IG1ldGFscw== Z29t X21ldGhvZHM= IG5q LlN0ZA== KHdpbg== JCgn IHR1cnRsZQ== dXJvbg== IGVucm9sbGVk IEh6 IEJveERlY29yYXRpb24= IHBvbnQ= cmVsYXRpb25zaGlw Qmk= s7s= IG1hc2N1bA== IHNoYWRlcw== IHZy IExvZ2lj IGFpbg== IERJU1Q= IGNvbGxhcg== InByb2ZpbGU= R2VuZXJhdGVkVmFsdWU= IFBvc3NpYmxl IGVpbmVz g4E= LnRpbWVvdXQ= IEVj IGplcnNleQ== LkRvdWJsZQ== IHF1YWxpZnlpbmc= dm9y Q1JFRU4= X0FwcA== X3JlY3Y= IGFsaWVucw== SXRz RXNj aWF0b3I= IEVjbGlwc2U= IGdo VmljdA== CWh0bWw= dG9v LmNvbnN0 IGFudGVyaW9y IFd1 KGtleXM= IHVsdHI= X3BvbHk= IFRhcA== IEJ1ZA== QVdT IGNyYXNoZXM= X3RvdA== Q29udGlu LWhhbmRlZA== YWx0aG91Z2g= 4Lia aWZpY2VudA== IGRldmU= dXRvcnk= IFdvcnRo X01T IGZsb29yaW5n IHNlbGxlcnM= IFRoYW5rc2dpdmluZw== IHBuZw== IHZhbG9yZXM= IHNsZWV2ZQ== IGZpbGxl 0JA= IGFwcG9pbnRtZW50cw== IHZpbQ== VXNlckluZm8= Qk9PU1Q= IHBvc2Vk aW5pdGlhbGl6ZWQ= LnByb2R1Y3Rz IExlYWRlcnNoaXA= bWFudWVs JyU= ZW1hcmtz UGVyY2VudGFnZQ== KGRpc3Q= LmF2YXRhcg== KGhPYmplY3Q= 5LuK X2lmZg== aWNvbmU= Oyk= X25pbA== IGFib2w= 0LXRgdGC IHZlbnVlcw== LkNvbnZlcnQ= IScpCg== LkJpdG1hcA== c2tpbg== X0NPTFVNTg== UmV2 R1JFU1M= Z293 IHdpc2hlZA== dHJhY3Rz LmFzc2VydEZhbHNl IHNjcmVlbnNob3Q= IGZvaXM= Q29tYg== TGluZVdpZHRo IEdyYWI= IGludGVuc2l2ZQ== CXNo Kyk= LmZpcnN0TmFtZQ== X1BST0NFU1M= IHRpbHQ= aXRvcmVk LkxPRw== IGJhaw== IGludGVudGlvbmFsbHk= LnBsYXllcnM= KGNhbnZhcw== KSkpDQo= LlByb3ZpZGVy X1BVQkxJQw== VGFsaw== IExpdg== Y2hlZHVsZXJz IGxj YWRpYw== ZmVhdHVyZWQ= LnJlc291cmNlcw== RnVsbE5hbWU= IG1lYW53aGlsZQ== QnVmZmVycw== IHJlc29sdmVy IFNBUA== X1RF R05V IEZvcm1zTW9kdWxl X3do IFN3ZQ== LndpZGdldHM= IGNhYmluZXRz IHN1c2NlcHQ= IEJvdHQ= YWN0aXZleA== YXZhcg== YW50aWNz ICI9Ig== X2t3YXJncw== IGdhbWVPYmplY3Q= IEFuZ2xl Lkl0ZXI= bWFyc2g= IEJpcnRoZGF5 IENNUw== cmVxdWVzdHM= IFBlYXJs X0VPTA== IGxpbnV4 KG9yZw== X01vdXNl LmNvbnN0cnVjdG9y IHpk IGtpY2tz YXJ0aXNhbg== IGVheA== S24= cG9uZ2U= IEZpbmxhbmQ= IG1ldHJlcw== IEFzc2Vzc21lbnQ= cGFydG5lcg== L3ByZQ== IScsCg== W0ludA== IG9zbG8= ZGF0ZXBpY2tlcg== L1N0cmluZw== b3BsYXk= IEhlYnJldw== LGRvdWJsZQ== IHRyYWJhbA== KyJc CUVJRg== L3RleHQ= X0ZJUlNU IFBldGU= IGVnbw== IGV4dHJhcw== UERP IHJlZ3VsYXRl IFFXaWRnZXQ= c3Rz IFNob3dz IE5IUw== LmNvdXJzZQ== cHRocmVhZA== IEZ1ZWw= LnRpbWVz IMKw IHN0cmlkZXM= KCQoJyM= KHdvcmRz IHJoeXRobQ== IHNwb250 IHNlbnNhdGlvbg== IHNwaWtl Q2xvc2luZw== 6aG16Z2i TnVtZXJpYw== IGJyZWF0aGU= IGZpbmFsZQ== X0ZBQ1Q= aW5pb24= IGNoaWxs IGZvcm1hbGx5 QU5HRUQ= ICc6Jw== INC/0YDQuA== YXE= IEZhYnJpYw== KGxhdA== IFByaW5jaXBhbA== IGVycm8= b2NhbGU= Tm9t IGZvc3Q= X0NVU1RPTQ== LmludGVsbGlq ZXJ0b29scw== IGNsYXNzZQ== YWRpZW50cw== IGZ1bmRyYWlzaW5n RU5F X09QVElPTlM= X29i Ly99Cg== IHByb3RlY3Rpb25z LnNlZWQ= TlY= dGVybWluYWw= Ozs7 UHJlZGljYXRl IOy2 IGJvbWJpbmc= R0Y= IGNoZXc= KSkpLg== cXVhbGlmaWVk XT17 bGlzdGVu Q0VOVA== ZGlnZXN0 RWFzdA== IGRpdmVy IGVuZHBvaW50cw== IGVl IGNvbGxlYWd1ZQ== IGRpc3NlcnRhdGlvbg== X2NvbW1pdA== X0RBVA== LnJj IGJyZWFzdHM= IFJ1Zw== IFBpbA== Q29udHJhY3Rz IEJyeWFu V2ViVmlldw== IGNvbmNlbnRyYXRl IElubmVy ICd8 c3Rkb3V0 X1N1Yg== Pi0tPgo= Vm9s IFNTRA== KSkpLA== Lk9wdGlvbmFs IG51cnNlcw== IG9yYg== X3Bl KTsNCg0KDQo= cGxhY2Vk ZXNzZXI= IHRoZXJhcGV1dGlj IHdoaXRlc3BhY2U= IGFzdG9u U3VjY2Vzc2Z1bA== IHByYWlzZWQ= IFdlcw== IGVpZ2h0aA== aXJhbA== IHZyb3V3 IGZhY3Rpb24= X2JpYXM= IHdpdGNo IG5wYw== KHNi IFJvZHJpZw== X2JpZw== RGVwZW5kZW5jeQ== IEFicmFoYW0= YXJkaQ== Q0FS bm9z IGFidW5kYW5jZQ== IG51dHJpZW50cw== aW5zdGVpbg== LlZlcnQ= IElTUw== PFU= IHN1bXM= X2hpc3Q= IGZhcm1lcg== IEFicg== U2hvdA== IEJhZFJlcXVlc3Q= IGhhc3M= IFJhaWxz IGFmZmlsaWF0ZWQ= 5p2l IGVyZg== SU5G IFZpZXdIb2xkZXI= bWluaQ== IFJvdGg= IGZhaXRoZnVs IFBoaWxsaXBz QU5ET00= XS5b X1BBWQ== IEFyY3RpYw== ZmFrZXI= RGlnaXQ= TWFsZQ== c3RkZXJy c2V5cw== IMWh X3JlbW90ZQ== bGlxdWU= IGluZGVm IEluZHVzdHJpZXM= aXRyYQ== X3BhaXJz PGlvc3RyZWFt IHNhbGFyaWVz aWtlbg== LkZyYW1l UExJQw== X1NQRUM= IE1lZGl0ZXJy IHN5c3RlbWF0aWM= IGludGVycm9n SWNvbkJ1dHRvbg== c2Vh aW50cm8= IElzc3Vlcw== ZW5jcnlwdGVk IGludGVybmF0aW9uYWxseQ== IHNucHJpbnRm IHBhc3Rh IEJyYWRsZXk= X1N0YXR1cw== QUxL X1BBRA== LmxhdW5jaA== PHNlbGVjdA== IGhhcmRlc3Q= IHBoeQ== ICgoKg== LXNsaWRl IE5vYm9keQ== U3U= IGFzw60= Y2xvc2VzdA== X2luaXRpYWxpemVy IHN1cHBvcnRlcg== LWdlbg== IHRhbGVz IGNvcnA= X2Z1 c2F0 bmVpZ2hib3I= Lk1pZ3JhdGlvbnM= IGFsZ3Vu IHNpbm9u LlNwZWM= PywK LkdM bWFsZQ== IG1vbml0b3Jz eWxhbg== LUxpY2Vuc2U= Lm1hdGNoZXM= IEFCUw== IE1hc3Q= IFdhbGxldA== KCQoIiM= RGlydHk= IGNvcGU= IGludGVycG9sYXRpb24= b3VzZWQ= IEpldHM= LkZMQUc= LkNhbmNlbA== LkV2ZW50cw== bmV2ZXI= IE1Ieg== PkQ= IHNlcnZsZXQ= YmFzdGlhbg== ID4m U0lE X2Nsaw== IGRpdmlzaW9ucw== fScsCg== IGRpbGRv IHBhcmFkZQ== bWFqb3I= IGFib2FyZA== Oysr IGZ1c2lvbg== In0seyI= IERpYWxvZ1Jlc3VsdA== CWFycg== LWVt X25y KGhhbmRsZXI= Lk5FVA== Llh0cmFSZXBvcnRz IFNoYWg= IEJyaWVm LSw= IHByZWNpbw== CQkJICAgICAg IHRhbnQ= IEdyYW5kZQ== L3htbA== X0lDT04= IFJldHJv dW5xdWU= IG5hZw== dG9GaXhlZA== WEw= IGRlY2xhcmluZw== IENvbmNyZXRl IEFtYXppbmc= CXByaW50aw== IGRlYmF0ZXM= REFURUQ= IGFlc3RoZXRpYw== ZW1ldGVyeQ== Um91dGluZ01vZHVsZQ== IE5hc2h2aWxsZQ== V0FZUw== IHdvbGY= IG9ic2VydmVycw== T1RB YW5zb24= IGVh IGdyZWVuaG91c2U= k43kvZw= IHN0YWly IGltbWlncmFudA== X2FwcGx5 cGVhcmU= IEJsb29tYmVyZw== X1BMQVlFUg== UmVzcA== 5q2j Q2hvb3Nlcg== IElDb2xsZWN0aW9u UGV0ZXI= RXJybw== LmRldGVjdENoYW5nZXM= TWFwcw== IHNxdWVlemU= IEhvbWVz d2VnaWFu IGZvcm1hdHRpbmc= IG5lZ290aWF0ZQ== dWxk IE5lcA== IFFC IGVjb25vbWllcw== ICovLA== IHJlZHVuZA== IEFiZXI= LklzTnVsbE9yV2hpdGVTcGFjZQ== eWNsZWQ= ICAgICAgICAgICAgICAgICAgCg== X1No IHNrZXB0 IHJlY3JlYXRlZA== IGdldFR5cGU= IG1hcmdpbnM= IGNvbG9uaWFs Y2hhcnRz Ly9A IHByb2Nlc3NvcnM= 6K+0 YmF0aXM= 5oSP YXRvcmlv bWVudGlvbmVk UGF0aWVudA== IHByZXk= Q2hlY2tib3g= X3hwYXRo LnNraXA= IE1vcm1vbg== IE1lbW9yeVN0cmVhbQ== Q1JFTUVOVA== IGt1 bWVsZA== XERhdGE= IEtlcm5lbA== aWx0cg== 6YCB KHByb2ZpbGU= Q2FyYm9u Uk9MRQ== KHBs XSoo Lm1lbW9yeQ== IG1lZGFs IGFkdmlzb3I= aXTDpHQ= IGhkcg== aWVydW5n IFByb3ZpZGVz KGFscGhh IHRlZW5hZ2Vycw== LXBhcnNlcg== LkxhdExuZw== XSgpCg== IGZlbG9ueQ== CQkJCgkJCQo= Qk9PSw== IHNsYXNo IGNsZWFyZml4 IFByb3BoZXQ= 5a65 cmlnaHRuZXNz LWZp LmtpbmQ= ZXJ0b24= Smlt IG1hbmlwdWxhdGU= IHdvcmtzaGVldA== b2xpbg== c3RhcnM= IGFydGlmYWN0 X0VNUFRZ CW1haW4= LS0tLS0tLS0tLS0tLTwv L3N0YXRpYw== SVRJRVM= IENvdW5zZWw= IFdD IEJMQUNL LXN5c3RlbQ== IFRyaXBsZQ== LmJ0 c29mdHdhcmU= XScpLg== SW5qZWN0aW9u X25vdGlmeQ== IGZpZnRlZW4= IGFtYmFzc2Fkb3I= YnJlYWtpbmc= VVJJQ29tcG9uZW50 IFByb3Rlc3Q= LlJlc2V0 IE1Qcw== dnJv LmdldFN0YXR1cw== X21vcmU= Y3Vw IEtlbnlh 5bey IGFtbXVuaXRpb24= 15XX IERhc2g= IHVuZGVyZ28= IGJ1ZGR5 0YLQvtGA ZXRpY2FsbHk= X091dA== IEJyb2Fkd2F5 qow= IEZpdHo= IHN0cmlwcGVk LWNhY2hl IHVtYg== IGFub20= IHNpYmxpbmdz b2N1bWVudGVk SW50ZXJydXB0ZWRFeGNlcHRpb24= IHBlbmc= bHN0 X0FMSUdO LWNhcA== UkQ= Y2VsbHM= IE1vdG9ycw== IHRyYW5zbGF0aW9ucw== dXN0ZXJpbmc= 6Zo= IGxlYWtz ZmlsZVBhdGg= IG91dGdvaW5n X2VuZHBvaW50 X0dM LmxpZmVyYXk= cmljaHQ= IE9wZW5HTA== LmpwYQ== IGFmZmVjdGlvbg== Zmx1eA== IGdseQ== IGJ1ZA== Pic7 IGV4cHJlc3Npbmc= IElR IEZhY3Q= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioK X21hc3M= KSk6 IGNvbmRvbQ== IGNyZWF0ZVN0YXRl b21ldG93bg== IGlycg== ID4o PkI= aXRlcmF0aW9u 44Oq IHNoaXJ0cw== b3VudHk= LT4k X1NJR04= IERhbGU= IGpq RWFzeQ== RnJl IE55 IGNobG9y bWF0Y2hlZA== IEdlcm0= LVVB IE5hdGhhbg== ZWR1Y2F0aW9u LXlhcmQ= LWNoZQ== aG91c2Vz cml0aW9uYWw= IHByb3hpbWl0eQ== IGRpZXNlbQ== 4bqtcA== IGRyb3VnaHQ= LmF1ZGlv IExlbw== IGZhdm9yYWJsZQ== aW5jaA== IERhdw== cmlibHk= X3N0dWRlbnQ= aWRhYmxl T1ZF IGxhY2tz b3VuY2luZw== LmJ1c2luZXNz IHJlb3Blbg== bWF5YmU= X0dMT0JBTA== IGRyZXNzZXM= IEVkd2FyZHM= ZW5zaWJsZQ== IEhhcmR3YXJl IEV4Y2VsbGVudA== IFRpbWVVbml0 Q1RJT05T IHNjaGVkdWxlcw== IHNlZ3Vl T3BlbnM= YW1tZW4= LUlkZW50aWZpZXI= IHN0YXJpbmc= IGhhcHBpbHk= IEhvYg== J18= ICIpOw== YW1lbnRvcw== ZXRjaGVk IC8+fQo= LlVzZXJz IGludGVycnVwdGVk Q29udGFjdHM= IHJlZ2lzdHJv aW5idXJnaA== Q0hB X2ltcA== cGhpcw== c2F5 IHJldGFpbGVy Lk5PREU= L21hcHM= X0xBU1Q= IENoYXJnZQ== X2d1YXJk Q29sbGlkZXI= IFN0YXRlbGVzc1dpZGdldA== IjpbIg== KCIuLi8uLi8= aW94aWRl IFN1bmQ= ICcnOw== dW5zZXQ= YWRkV2lkZ2V0 0LvRjg== ZWxsZXM= YWxrZXI= QXJj IGRlZHVjdA== R1VJTGF5b3V0 IFZpbGxh IGZvcmJpZGRlbg== X3doZXJl IFwv IFRpYg== X0FY XQ0KDQo= IEJpcg== IGJlbmQ= IE1BS0U= IE1FVA== IGZ1dHVyZXM= IHdlaWdodGVk IiIiDQo= IGF1dGhvcml6ZQ== KHByb2dyYW0= fSx7Ig== IGNvZWZmaWNpZW50cw== w6pz UGVyUGFnZQ== IEJhdGhyb29t IFB1Ymxpc2hpbmc= R1BM IHN1Ym1pc3Npb25z IE5VTUJFUg== asSF IGFkZGl0aW9uYWxseQ== ZW1wcmU= IFNoZWw= b3R5cA== U29sdXRpb24= IHRodW5kZXI= X2Vj IAogICAgCg== IEZlbGxvdw== IGtheQ== IG5ld1N0YXRl T05UQUw= SW1wbGVtZW50YXRpb24= Lkxvb2s= IGVudHM= IGxvcnM= IEJJRw== ZmFi IGF2ZXJhZ2Vk IEZlZWRiYWNr IFdlbGxz IG1hcnRpYWw= IGluZHVs IENvbW11bmlzdA== IEZvcmV4 IEFncmljdWx0dXJl Ils= IHF1YXI= IEtvbnQ= CXZpZXc= LkJ5dGVz ZGVza3RvcA== IE1ha2Vz YWtlc3BlYXJl Lk51bGxhYmxl IHNwb3RsaWdodA== VkI= b3d5 KHRvcmNo dHJpZGdl X2JvdW5kcw== IGFwb2xvZ2l6ZQ== LmFkZEl0ZW0= YW50ZA== Kik7Cg== LHU= KGdlbg== 57uT cmVhdG9y IENvcmQ= b3VwcGVy Lm1ldHJv IGV3 IFdPUkQ= LkFmdGVy IGRldGFpbmVk IEhhbW1lcg== ZXhpc3Rpbmc= IG9zdA== IG1vbnVtZW50 LWN1c3RvbQ== VXNlcklE IE5vbQ== IHJlamVjdGlvbg== KGRpbQ== IHNpbmdsZXRvbg== CWRpZQ== YXJpYW5jZQ== cmVwb3J0cw== XSE9 ZWxkYQ== IHByZXZhbGVuY2U= X3JlZ3M= LiIu IGZlbWluaXN0 Q29kZWM= ICoqCg== KGxhYmVscw== X01BUks= RkFJTEVE IGFkbWluaXN0ZXJlZA== V04= ICAgICAgICAJCQ== IG5vdW4= d2ln IGdvdHRh IHJpZg== LWlt IFBhdWxv IENvbW1hbmRUeXBl XSkpCgo= LXplcm8= VHJhaW5pbmc= IGxvcmQ= X2FydA== cmVkZGl0 Q2VydA== IHBlc28= Um90 IGVuZGFuZ2Vy LmRy dXNlckluZm8= dW50cw== bnY= IFRyYWlsZXI= LWZpcnN0 KG1ha2U= IGJlbmVmaWNp LWJsYWNr acOf IHVuZG91YnRlZGx5 IG1leA== IEFuY2llbnQ= KGFz IGRlc2NlbnQ= UGljaw== IHJlcGxpY2E= JG9iag== w6Rocg== IGFycm93cw== ZnR5 IExpYnlh dWdh Y2hhcmdlZA== VHVy IGhvbWlj aXNzZW4= IEZha2U= IGJlZXJz IHNjYXR0ZXJlZA== KFRpbWU= VVRJTA== IGJ1cmVhdWNy L3BsYWlu IHN0aWNraW5n RkFJTA== IENvdmlk VGhpcmQ= X3ByZXNlbnQ= IFBpZXJyZQ== IOuq IFsuLi5dCgo= UHJvYg== IFRyYWZmaWM= aWNhbw== ZG9jdG9y ICksCgo= VGFicw== YWx1 77ya4oCc IGluaGVyZW50 X05v cml0aXM= IFByb29m LmJhc2VuYW1l 5Lya IGNoaW0= IFByb3RlY3RlZA== Y3JpdA== IHByb25l INC60L7QvQ== IEhlcm9lcw== IGFueGlvdXM= IGFub3M= IHdlZWtlbmRz IHNleHQ= IHJlZHVjZXI= PVVURg== aGFsZg== IFNhdw== Lm1t IG51ZXZh LmN1cnJlbnRUYXJnZXQ= Lmx1YQ== X0VYVEVOU0lPTg== CXJlZw== IEN0cmw= X2FsaWdu YWNjZXB0YWJsZQ== IHJ1c2hpbmc= ZnJhYw== IGJvYXN0cw== Rml2ZQ== wrE= IFRlbXBlcmF0dXJl Pik6 IGNoYXJ0ZXI= UkVBVEVE IHN1YmplY3RlZA== IG9wYw== aGVhbHRoeQ== 5L2/55So IFNjaWVudGlmaWM= IGZyYXU= cmlhZ2Vz 4LiU LmludmVudG9yeQ== YXRpb25hbGU= TWFk bWludXRlcw== Pj4oKTsK IEVudg== IHJlY29yZGluZ3M= IHN1c3BpY2lvbg== c3FsaXRl CXJlYWQ= 44Gm IHdvcnJpZXM= LnB1dFN0cmluZw== IFNoYW5naGFp KHVpZA== cmVy IHbDrWRl Iik6 IG1ldGhvZG9sb2d5 INC60L7RgtC+0YA= Y2Nj YXZhZA== IGluZHVjdGlvbg== CVRocmVhZA== LHN0cmluZw== 4bqhaQ== bmVobWVu dWl0aW9u ICpfXw== LmVtZg== IOyc L3RoZW1lcw== IE5pbmU= Lk9uZQ== IEVtYmVk IGZheg== dWF0aW9ucw== IHByaXZhdGVseQ== IGxpbmc= W0Y= dXNoaQ== IGxhdW5jaGVz KEtFWQ== R01U IGFpbWluZw== cGF0aWJsZQ== IEJpZGVu aXc= IERlZ3JlZQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= ICQoJzw= w6FyaW9z dG9VcHBlckNhc2U= 7KCc IEVVUg== IG92ZXJzaWdodA== IHRhYmxlc3A= VXBkYXRlcw== Lm1ha2VkaXJz IGh1bWlkaXR5 L3RlbXBsYXRl QWx3YXlz KElT X2NlcnQ= RGln IHVuZGVyd2F5 b3J0b24= IEh1cnJpY2FuZQ== IHNwZW5kcw== IFNlZ21lbnQ= IGZsaWVz IFRvZ2dsZQ== IEx5bmNo IHNlbnNlcw== IEtvcw== c2V0RW5hYmxlZA== aXN0aWNhbGx5 IHRlc3Rlcg== IGFkbWluaXN0cmF0b3Jz IHRhZ2dlZA== 0JM= IHNob3J0Y3V0 IFJlc29sdXRpb24= IHN1cGVydmlzaW9u IEFzaGxleQ== VHJhY2tpbmc= dWxhdG9yeQ== YW5kZWw= aXN0ZW4= IHVucmU= KGRpZmY= QU5UUw== IHJpZGVy IHPEhQ== LlNlcmllcw== X29yZGVycw== T1JJWk9OVEFM IHJldGVudGlvbg== 44CCPC8= LlRlc3Rz U3lu LnBhcnNlRG91Ymxl a29kZQ== emVudA== R2VuZXJhdGlvbg== IGFkbWl0cw== IExlYWs= IGFrYQ== Uk9XUw== IEFuZ2VsYQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IG5vb24= IHN0YXJr IGRyYWdnZWQ= 44O844I= IHJlY3ljbGVyVmlldw== IFNpbGljb24= X3N1ZmZpeA== Sm9u Y29jaw== IFByb2JhYmx5 SW50cm9kdWN0aW9u IFRlcnJvcg== KFRoaXM= IEJhc2ViYWxs IGplbnRlcg== Y2hlc3RyYQ== Lm5hbg== PWc= IGNsYXJpZnk= eWlp cm9vdHM= IG5vdGVib29r IEV4Y2VwdA== IHJpc2Vz IEJydXNzZWxz YXRvcmllcw== LlVTRVI= cm9zc292ZXI= L3VwbG9hZA== IEV2ZW50dWFsbHk= Q29uc2lkZXI= IEJvdW5k LmlkZW50aWZpZXI= KHVuaXR0ZXN0 IGluZmVyaW9y IGNyYw== IGF1dGlzbQ== VUlBbGVydA== IEthdmFuYXVnaA== aW5lbWVudA== cXVldWVSZXVzYWJsZQ== U2tpbg== LmJhY2tlbmQ= LmdldFN0YXRl dW5kaW5n IHN1YmNsYXNz IHJlZmluZWQ= IGFubm95 IHJuZA== RGlyZWN0b3I= IOuC YmVjY2E= bW9uZ29kYg== IENvbW1vbndlYWx0aA== QXo= IFRoaW5n IHJlY29t dW5pbmc= CWNvbg== CSAgICAK ZW1pY3M= ZWNk IGhvcm55 QVRSSVg= IG1pc2xlYWRpbmc= IEJldw== L25vZGU= Y3N0ZGlv 4Lin IGFkZGl0aW9ucw== cmly X3JlcXVlc3Rz IHJlY2hlcmNoZQ== c3R1ZGVudHM= X3Bvc2l0aW9ucw== ZXJ0ZXh0 IEV2b2x1dGlvbg== YW5kZXo= IGRpc3R1cmI= a2V5dXA= IEJ1dGxlcg== LnJlYWRsaW5lcw== X3N0ZGlv IGJlZQ== IEFyY2hpdmVz IG5ldmVydGhlbGVzcw== VVJJVFk= IGRyb25lcw== dXJpdGllcw== IOKYhQ== Ij4NCg0K IGRpYWdvbmFs IENhbmNlbGxhdGlvblRva2Vu X0ludGVybmFs IHJ1aW4= LlF0 b2NyYXRpYw== VGVs IEFuc3dlcnM= bWF0aWM= IHhw YXRlbQ== X2pvYnM= X2FueQ== IHNlbmlvcnM= IGxhbmRtYXJr IFFMaXN0 IG1hbmV1 b3RpZnk= LyI7Cg== L3NlcnZlcg== IFBoaWxvc29waA== dXRlbmFudA== KGlv aHo= IGF1dGhlbnRpY2F0ZWQ= ZHY= LUNvbXBhdGlibGU= T3JpZ2luYWxseQ== LGZ1bmN0aW9u 44CCDQo= IFJlcHJlc2VudGF0aXZl YXNpbHk= aXJjdWl0 LmR0 KG1hdGg= Lk1hcnNoYWw= Wyw= IENpdGllcw== X3R1cm4= fCkK IGNhbnRpZGFk YWx0ZXI= CXVp IE5lYnJhc2th IHNraXJ0 LmJn U2hhcmVkUHJlZmVyZW5jZXM= KHN0eWxl IGdyaWVm Z2V3 IHNhZmVn b2xhbmc= X2xpc3Rz 7Js= IGdyYW5pdGU= IGhvdHRlc3Q= LmpkYmM= LkN1c3RvbWVy IOKJpA== IHdhYXI= X3NjZW5l Kycv IEpUZXh0RmllbGQ= IHNlYXRpbmc= IHdlYXJz IGAv Q2FzZXM= IFlvdXR1YmU= xLFt IGJhbGNvbg== LEc= TWV0YURhdGE= LXByaWNl U0NS VW5pdHk= IHRydW5r PXtgJHs= IGVhcnRocXVha2U= UGFydGlhbA== IHN1YnN0 IGVsaW1pbg== PSInLg== Ly8qW0A= IHN1cGVydmlzb3I= dnJvbGV0 X2FydGljbGU= IHBhbmU= Ymlv IG1vdG9ycw== Tk0= RnJhbms= IG9uaW9u LXdvcmQ= SXRlbUNsaWNrTGlzdGVuZXI= IGJyaXQ= ZW5kZW5jaWVz Q29tcHV0ZXI= X3J1bm5pbmc= KGRheQ== LWhl KG5hbWVk IFNhY2g= 0L7Rhw== Y2FtcGFpZ24= LkFic3RyYWN0 KHdyYXBwZXI= LnBheQ== IHV3 R2Vv cmFpbHM= L3NlbGVjdA== aWNodGU= c29ucw== RVZFTlQ= IGFsaW1lbnQ= UHJvdmlkZXJz QXdhaXQ= X0lOVEVSVkFM Lm9mZg== IGdsdXRlbg== X2Nsb3Vk IHdlbg== LmV4dHJhY3Q= CWJ1dHRvbg== L01N UGFydHk= IGRlbW9ncmFwaGlj X2Vycm5v IGhpa2luZw== KCcnKQo= IixAIg== IHdpdA== csOh b2xvZ2ll IFN0eWxlcw== IEJyb3dzZXJNb2R1bGU= LlJlcXVlc3RNYXBwaW5n aWNhbnM= UEFHRQ== Y3JlYXRpb24= IEZlcmd1c29u dWRlZA== bnVtYmVycw== IEdUSw== IHByZXNlbnRhdGlvbnM= IEJvYmJ5 X3NwYW4= ZXN0eWxl IGlsbGVnYWxseQ== YWJlbGE= IGJhdHRsZWZpZWxk Y2FwYWNpdHk= dGVycm9y XSIpOwo= IHdhcnJpb3I= bGVhZGVy IERCRw== IFJldmVudWU= IHZpZ2ls IGNvdW50ZXJwYXJ0cw== KEVycm9y QUNURVI= IGhlZWZ0 IHNlbGVjdGlvbnM= emV1Zw== dG9t LXR3bw== LjsK X3N0YXRlbWVudA== IEFpZA== IFZ1bA== X3JnYg== IHByaXplcw== IGVkaXRhYmxl CWZvcm0= xLFuxLE= LmRlY29y RGVtbw== bGljZXM= IGVuY3R5cGU= cmF0dWxhdGlvbnM= IFJPUw== X2NoYXJz IEphaHI= cGFydGlhbA== 0YPRgg== IFJlY2VpdmU= IExhbmRz QVBURVI= IGNob3BwZWQ= Li4i IEFuYWx5 IFVJRA== IFJhZGVvbg== IEJlZQ== IHVubQ== Pk0= LmZpbmRhbGw= VG9rZW5pemVy IFdIQVQ= IHNq RHJhd2luZw== RXNz T05E irY= KHBhY2tldA== 4oCUYnV0 SW52b2NhdGlvbg== IE51Y2xlYXI= PzsK IGdyYW5kZXM= IENyeXB0 cmVtYXJr ICcuLi8uLi8uLi8uLi8= IGluYWJpbGl0eQ== bWFnaWM= Y2F0cw== IHNpbXVsYXRl OiR7 aW5mbGF0ZQ== IGVuZXI= Ok5P aXBsZXM= IG1lcml0 IFJhdGVk IGdsdWU= L2Jsb2c= IGdyZW4= IHRocmlsbGVk LkNI dW5jYW4= IFBSSU1BUlk= IHBlcnNlYw== IGZlYXJlZA== Lk1JTg== IFRoZWF0ZXI= 6ZI= YXRlZ29yaWU= 5q61 IGFwcGV0aXRl c3F1YXJl IEFsZXhhbmQ= LlVzZXJJZA== X2d0 X2VudGVy IGdyYWR1YXRlcw== RnJhZ21lbnRNYW5hZ2Vy QXV0aG9yaXpl LU5MUw== KE15 IHRyaXVtcGg= dXN0aW5n X1BBUkFNUw== Q2hhcmFjdGVycw== KDosOiw= X0JVSUxE TUh6 IHdhc2hlZA== IHVuY2xl U3RldmU= YXJkb3du PHN0ZGlv X3Rlcm1z IE1BUg== IGhvc2U= dWN1cw== IENsYWlt IFJhbXM= IG1vZGVsQnVpbGRlcg== IG7DqQ== dXNlcklE PWpzb24= LlJlc3BvbnNlV3JpdGVy mOiupA== IGdydXBv LWl0 IEtP LU1haWw= IGNvbmZlcmVuY2Vz SUZB IEFzc2Fk IHByb25vdW5jZWQ= IGFuY2VzdG9ycw== IFRSQUNF IEdlRm9yY2U= IHByaXZhdA== cGVsbA== ZW1vamk= INmI R2VucmU= IGNvbmNlbnRyYXRlZA== amFuZw== TU9URQ== IFpvb20= dG9vbGJhcg== IHV0dGVybHk= IGVuY29tcGFzcw== IFNvY2Nlcg== IGV1cm9wZQ== LWFpcg== LmFuaW0= X0NUTA== aGVyZW50 cmV4 aW50ZXJhY3RpdmU= 44Gn44GZ IEthcw== IGRlc3BlcmF0ZWx5 KGFy IGJpaw== IHRyYXZlcnNl ZXVycw== UmVjeWNsZXJWaWV3 IE1hcmdhcmV0 IGhvcGVmdWw= IE1pZw== X01FTUJFUg== cmVjZWl2ZXI= TWF0Y2hlcg== ZGVwZW5kZW50 IGV4Y2VsbGVuY2U= 0LDQtg== TE9T QXNwZWN0 IGFkYWxhaA== IEVjb25vbXk= dWxvdXNseQ== IGV2YWx1YXRpbmc= IGRldmlhdGlvbg== ZXh0ZXI= L2RhdA== Q29scw== IFBva2Vy Ym9hcmRpbmc= LkNoaWxkcmVu QU5HTEU= w68= IFlvZ2E= IGhhdGVk QWRhbQ== IEZDQw== SU1BTA== IGZhaW50 X0RJU1BMQVk= IGV2b2x2ZQ== IGZyaWRnZQ== IHLDqWc= IGVtb3Rpb25hbGx5 4oCcSWY= YXdlaQ== ZXJlc2E= Jywi QkVHSU4= IFZBUkNIQVI= IHhp ZmFjdG9y dHo= X3BoYXNl U0VR KHJhbmQ= IG1hdGhlbWF0aWNz IGNvbnRleHRz LWFj IEZJRw== IENhcHRpb24= IFdhaXRGb3I= LXdlc3Q= IGZpcmVmaWdodA== X0xFRA== ZWN0aW9ucw== CXRocm93cw== IFRha2Vz b2JyZQ== IEF2YXRhcg== IElubm92YXRpb24= IGNhbGlicmF0aW9u OnRoaXM= X2VuY29kaW5n IGNhbGN1bGF0aW5n ICMjIyMjIyMjIyMjIyMjIyM= IFByb2dyYW1z IEhJR0g= LmNvbmZpZ3VyZVRlc3RpbmdNb2R1bGU= UG9seWdvbg== X0RCRw== Il0sDQo= 0LDQsQ== IHNpbWlsYXJpdHk= IHByemV6 IEZpcm0= IG1pc3VuZGVy IE1vdmluZw== IE1PVg== IHJlYWN0b3I= UmVxdWVzdGVk ZXhwZWN0cw== IGVyZWN0 bGljaHQ= b3VsZGVy SURHRVQ= IGRldmls IHByb2dyYW1tZXM= IENvbW1vbk1vZHVsZQ== ICInIg== KEF1dGg= 44CC77yM IFN0YXRlZnVsV2lkZ2V0 6K6h L29wZW4= aW5hbGx5 LlJvdW5k IFdpc2g= IGh1bWFuaXRhcmlhbg== QWNjZXNzVG9rZW4= IFNPQw== IHBva2Vtb24= IHZhcG9y X2FkZGVk CUdldA== c3BlbGw= IEluaXRpYXRpdmU= IEhFTA== YWlycm8= YmxlZA== INCx0Ys= IHNlbnNpYmxl IEx1YQ== fCgK IGZpeHR1cmVz IG9yZ2FzbQ== Q3V0 dWt0 Z3Vl IGNyZWRpYmlsaXR5 OmltYWdl IENQUA== LnNu KGRlc2M= IFJlaWQ= LWRlZ3JlZQ== X3NvdW5k Q2xvbmU= 4buZ YWtzaQ== PiR7 X2NvbmZpcm1hdGlvbg== IHRyb3BoeQ== V29ya3M= IEVsZWN0cm9uaWNz IE1lZGl0ZXJyYW5lYW4= X21ldHJpY3M= IGFubm91bmNpbmc= IERBWQ== X3Byb3Rv IHBlYXI= YmFzZVVybA== CQkJCQkJCQkK IGNvb3JkaW5hdGlvbg== Ok4= LmFuaW1hdGU= IENvdHRvbg== X2hpdA== 4pw= IGpldHp0 aWZ0ZXI= KGZpZWxkcw== b3dubG9hZA== aWZpY2FjaW9u LmN1ZGE= IExpdQ== PmVxdWFscw== IEFjZQ== 0YDQsNC8 IFN1cGVybWFu IEdhcmNpYQ== IGFycmVzdHM= YWdhcg== IHt9KQ== IG1hY3Jvcw== cm91cGU= w6p0cmU= IHR3aXN0ZWQ= c3RydW1lbnRz Xygi X3ZlcnRpY2Vz IFRyYW5zaXRpb24= 0LjQug== W21heA== bWluZA== IGFjY2Vzc1Rva2Vu IHVubGU= bXVz Y29w IEZhY3Rvcg== IGNvbmNlZA== IHJldHI= LmxpbmFsZw== LXNsaWRlcg== b2Js X1N0YXRpY0ZpZWxkcw== IHpvbWJpZQ== c2VsbGluZw== IGNoYXA= IHNoYWtpbmc= IFRyYW5zbGF0ZQ== IEFtc3RlcmRhbQ== IEVUSA== X0VYVEVSTg== a2Q= X2Rpc2M= IHByZWNlZGluZw== IHByaXg= T2JqZWN0TmFtZQ== X21vZGlmaWVk YXJkd2FyZQ== ID8+Ij4= IERX YCR7 ID8+Ij48Pw== dXllbg== IGRvbm5h IHhzaQ== ICQiew== IERyYXdpbmc= LG5pbA== IG9uZGVy Qkc= T2JzZXJ2 IGNvbnNpZGVyYXRpb25z Ym9hdA== IEJhbmtz IGluZGljdA== LEk= IEJsdQ== KHZlcnNpb24= Y2xpZW50ZQ== b2xhbg== TEVTUw== YXNzZXJ0U2FtZQ== X3ZvaWQ= IFdBUw== CWVudW0= IG1peGVy RVc= YWZmZQ== IGJsb3dqb2I= dGV4dEZpZWxk IGltbWVuc2U= X3JlcG8= IGdsb2JhbHM= YW50YWdlcw== LnRvZGF5 VGh1cnNkYXk= IEJyaWc= e30pCg== IEltYWdpbmU= KEdQSU8= IGVzdG8= IFByb3ZpbmNl IE1lbnRhbA== X2NlbGxz IEp1bGlhbg== LlNjcmVlbg== IGNhbmRsZQ== IG1vbmRl IHZlcmc= aXRlcmFscw== LWxheW91dA== R3Vlc3Q= IHZpbmQ= IEVjaG8= Jyl9 IG1hbm4= X0JPT0xFQU4= aGFw IG5pZ2h0bWFyZQ== VUdI IG5vbmV0aGVsZXNz IGF0aGU= IEhvbGxhbmQ= IEJvcm4= XE9STQ== YW51dA== X2xldmVscw== IHBldGl0ZQ== LWFydA== X1NIT1c= bnVtYmVyT2Y= X3RodW1ibmFpbA== YW1pbnM= IERlZmluZXM= ICI9 LlN0YXR1c0NvZGU= IGRpZ25pdHk= IEJpa2U= Lk5ld0xpbmU= IEdsYXM= KGxvZ2dlcg== IGNhdGNoZXM= dm90ZXM= IGV4YW1pbmluZw== L3JlZ2lzdGVy IHNwZWNpZnlpbmc= X2ZpeGVk IGRyYXdpbmdz VGhyZXNob2xk QXg= IEFyY2hpdGVjdHVyZQ== KHBpZA== V2lyZQ== KGNvbnQ= bGFuZQ== TGlzdHM= IHNwcmludA== IGdyYW5kZmF0aGVy X0FH IHNjaGVkdWxpbmc= Q0xVUw== YXR1cml0eQ== IGxvY2tpbmc= W3NpemU= X3N0eWxlcw== IHdi LS0+Cgo= IHNwaW5uaW5n X3BlbmRpbmc= TWF0Y2hlcnM= LktleXM= IFBW ZW51cw== YW50aXM= IGRpc2NhcmQ= IGhhdWw= IGVtcGly IHBhdGh3YXk= IG9haw== 0LzQtdC9 LWluZHVjZWQ= IGltcGFpcg== IENhbGdhcnk= LmlzSGlkZGVu ZHo= X2luY2x1ZGU= IGdt ICcoJw== UFk= dWdnZXN0aW9ucw== IGNvbW1vZGl0eQ== Y3Jv L3N1Yg== IGdldEluc3RhbmNl IExlZ2FjeQ== IEtpbA== QmFs KHNob3J0 SW5mb3Jt K3g= KnI= IEhvcGVmdWxseQ== b3JhdGU= IG1hY2hlbg== IHRyZWF0eQ== IE9yaQ== LnB1YmxpYw== LWhvcml6b250YWw= IHRhY3RpYw== IGJvcmQ= d2FyZXM= IGFtbW8= IExpc3Rz IGVxdWF0aW9ucw== L2hlcg== IE5TVw== Qm91bmRpbmc= X0NvbGxlY3Rpb25z IGF2YWls LkRyb3BEb3du 6LA= IGho IGzDoA== LnBi IG1lbW9yaWFs IEFUVFI= IGV4aGF1c3RlZA== IHRzcA== CXJlZGlyZWN0 IGxpa2V3aXNl U1RFUg== TGphdmE= IGNvbmRlbW5lZA== b2NhdXN0 KHN0cmljdA== IGV4ZW1wdA== IHNtcw== IGV4YWdnZXI= U1lT IGxvdW5nZQ== Ol4= IHRvZGQ= ZGVi YXRvcmlhbA== IFBvcnRlcg== IHR1aXRpb24= IGV4ZW1wbA== IHBhcmVu LmxpbmVUbw== IGtpZG5leQ== IMOnYQ== IGN1aQ== 77yM6K+3 WEM= IG1vxbw= IG5vbWluYXRlZA== bHVuZw== SW1HdWk= IEJ1eno= IHN0ZXJlbw== cG9ydGFs cmVzYXM= IGtsYXNz IGRyYWZ0ZWQ= IHByb2plY3RpbGU= L2dwbA== KHBhcmFtZXRlcnM= KikK IGFzc2lzdGVk IE5TSW50ZWdlcg== c2l0ZW1hcA== Om50aA== LlZpZXdz LkFyZ3VtZW50UGFyc2Vy IG1lZXI= emllcg== IERpZw== PD89JA== X3Blcm1pc3Npb24= CUFkZA== b2xvZ2lh IHNjaQ== IGZpbmFuY2lhbGx5 IHNjcm9sbGluZw== LmRpc3Q= X0hBUw== dWJ1bnR1 LnBhZ2Vz SW5jcmU= YnVyc2U= IEFtYXRldXI= 5rqQ QmxvYg== IGNob2xlc3Rlcm9s REVT bWluaW11bQ== IHJlZnVzaW5n dW5uZWQ= 0Jw= IFJE LlNlcnZsZXQ= ICovOwo= dWRkZW4= IHZpZXdCb3g= IG1ldGFib2xpc20= IHN0ZWFsaW5n IEJldmVy YWduZXRpYw== VkVSUklERQ== X0FVRElP 0YDRiw== IGFyY2hpdmVz LmxpbmVhcg== PXs8 dW5jYXRlZA== QWNjZXNzRXhjZXB0aW9u IHBpY3R1cmVCb3g= CXNlbGVjdA== TGF0aXR1ZGU= dmlzb3I= cmVpYg== IHBhaw== SG9wZQ== IEl0ZXJhYmxl LnJlc3BvbnNlVGV4dA== IFF1YWQ= IEJyb29rcw== IFRvdA== T1BU ZWxvbmc= IGNvY2FpbmU= IGFubw== RGFu IHBzaQ== 0LDQu9GM LmdldENoaWxk IFJFRg== LWFi IFRyaWFuZ2xl PFRleHQ= IENvbG9tYmlh aW5reQ== 6Imy KX0+Cg== IHBsYWc= cGluZQ== IGJsYW5rZXQ= IDo8Lw== IFRyYW5zbGF0aW9u bm92 IHBlcmZlY3Rpb24= IENvbmZlZGVy LnN0dWI= LkludGVyb3BTZXJ2aWNlcw== LlN0b3Jl IGVucm9sbG1lbnQ= IGRlZXI= TW92ZW1lbnQ= LWZyb20= aGM= IGV2YW5nZWw= IElsbHVzdHI= IHRydW1w X1N0YXJ0 cGxhbmVz IEJpbA== SW5mb3M= LXRyYW5z IHJhbmNo IExpbmRh X21hcg== UkVU L25ldA== TGF3 TkY= IFByZXZlbnQ= IGNyaWVk IGVkdWNhdGU= YXN0aWNz eWk= LkxpbmVhckxheW91dA== TUVUSE9E IEVn bWFwcGVy 5pmC LmFzYXJyYXk= z4E= acOnw6Nv UmV1c2U= X3Jldg== IFBST0RVQ1Q= X0NvZGU= ICAgICANCg== IFNFUlZJQ0U= X2NvdmVy LiwK LkV4ZWN1dGVSZWFkZXI= IERpbmluZw== LmFyY2g= IG90cm8= IERpc2NvdmVyeQ== IEtleUVycm9y IEJlbmVmaXRz X1NIQQ== LlVubWFyc2hhbA== SEVBREVS TXV0ZXg= QU1B IGluaXRpYXRl U3RheQ== TGl0dGxl ICgpLA== IGRlY2VudHJhbA== UmVzb2x1dGlvbg== LmhlYWx0aA== CWZjbG9zZQ== 5Lqk IHN0YWtlaG9sZGVycw== IGFyY2hhZQ== RGlnaXRhbA== bGVzY29wZQ== X3Blbg== IEl0ZW1TdGFjaw== IENhbm9u IEtlbmQ= IMO4 X2FqYXg= aW5ncmVkaWVudHM= RGVsaXZlcnk= U2VjdGlvbnM= IGRpc2FwcG9pbnRpbmc= IEdyZW4= LHJl IGRlY3J5cHQ= b2xvZ2lj X2ZtdA== IFNsaWRlcg== bmFo V2FzaGluZ3Rvbg== enVuZw== INGG eWN6 aWV2ZXM= LkRFQlVH IFRJ IGhhY2tpbmc= IGNlbnRy Zmxvd3M= IGRpZFJlY2VpdmVNZW1vcnlXYXJuaW5n IGFjY291bnRhYmlsaXR5 Q09VTlQ= 0LvQtdC80LXQvdGC Ymxv L2lk IFNsb3c= aXp6YXJk LnJlbW92ZUV2ZW50TGlzdGVuZXI= IOyehQ== L0k= aXNtYQ== IEh1ZHNvbg== fX0s dW1lZA== IHJlYWxpc2U= dW5zYWZl IHp1cw== IHNob3J0YWdl b2xpYQ== X3ByaW9yaXR5 IGZsb29kaW5n b3BlcmF0aW9ucw== UG9seQ== YWJhbg== W2N1cg== IGVza29ydGU= X0RFU0NSSVBUSU9O X25hdA== IG1hbGljaW91cw== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IFBhcmtz IHRheHBheWVy IEZvc3Rlcg== IHNleHVhbGl0eQ== 57O7 67A= XA0K LnNlZWs= 0LDQvdC40Y8= L2FydGljbGU= 6L+H IFVocg== IGdyYW5kbW90aGVy IEJsZQ== ZnVydA== YW1iYWg= bm90aWZpY2F0aW9ucw== ZGVwcmVjYXRlZA== IHVpbnRwdHI= b2tp KEFycmF5 IGF1dG9ub21vdXM= IG9icg== wq/Crw== IGJhc2VuYW1l IHVudmVpbGVk c29s IE5vdEltcGxlbWVudGVkRXJyb3I= IGRlcHJlc3M= XycuJA== IFVOSVQ= JScs LXRhZw== Z3JlcA== IE1haW50ZW5hbmNl IHdhcmZhcmU= X1JFU09VUkNF KHNwZWM= KGN2 IG5hZGE= 55S1 IGNyb3dkZWQ= QmVsb3c= IFphY2g= RXN0YWRv X3ByaW1l IHRyYWJham8= IGluZm9ybWF0aXZl U2NvdHQ= IHNlcmlhbGl6ZXJz IE5hcw== VGh1bms= IG1lcmN5 LC4uLgoK IGFkZGljdA== LmNvbnN0YW50cw== IGRhdGFmcmFtZQ== X3JlYXNvbg== Z29tZXJ5 7Iq164uI64uk IG5lZ2xlY3Q= IExpbmVz IG1lbWI= X0VYRUM= YXNzYWdl IFlhcmQ= e30nLg== IGxvdHRlcnk= dGVpbg== X2NhbGM= aWt1 X1JFQ09SRA== V2Fybg== IGhlYWx0aGllcg== dXJlbWVudA== IHlhcm4= IENvcm5lcg== KHppcA== KGluaXQ= IExpdA== SFc= c3Vic2V0 IE1G RVRFUlM= X3JvdA== IGVyZQ== IE92ZXJyaWRl V2FsbGV0 X3Jld2FyZA== IHNhZ2U= c2V0VmlzaWJsZQ== IEpzb25SZXNwb25zZQ== SUNZ 6K+i VmFyQ2hhcg== YWF0 LWdyZWVu IGlycQ== YW5pdHk= IHdob2V2ZXI= X3NoYXJl IGZvdXQ= cm9sbHM= IHdpbGxpbmduZXNz LmNvbXBvbmVudEluc3RhbmNl IGhvbm9yZWQ= dXJ2ZXk= QmVy IHJ1bm5lcnM= IGxpZXU= b3Jwb3I= X3N0cnVjdHVyZQ== QmFyQnV0dG9uSXRlbQ== YWR4 IEJlbm5ldHQ= IGRpbGln IGZsdWN0 SURERU4= X1NlbGVjdGVk KGRpdg== IHF1aWNrZXI= YWxvbmc= Z3JhcGhxbA== aW5leg== IGNpdGU= IEluc3RydWN0aW9ucw== IGluc2VydGluZw== LmNsb3VkZmxhcmU= Y291cG9u ZWRMaXN0 IFN0b3Jlcw== X21hbGxvYw== 56ym IEF3ZXNvbWU= IGxhbWI= UkVTVA== IGludGVzdA== IE5hdmJhcg== LmZlYXR1cmVz SW5jcmVtZW50 IFBvbQ== IGluc3VmZmljaWVudA== X0xPR0lO UExFTUVOVA== IE9BdXRo LklORk8= IGV4b3RpYw== IENBU0U= CSAgCg== IEdhbmQ= dGhlc2Vz IG5vdm8= IERlbGw= 4oCm4oCm4oCm4oCm X3NvZnQ= IGFncmVlaW5n Y2VudHM= bG9hbg== JyIsCg== IFJhbg== REVM IG9yZ2FuaXNlZA== K24= IEhlYWx0aGNhcmU= IGRldGVyaW9y IGltcGxlbWVudGF0aW9ucw== IGNhcm4= ICwn IExPQUQ= IHBsYW50ZWQ= 5pyq Rm9ybUNvbnRyb2w= X21hdGNoZXM= IHBlcmlvZGlj X1Rv IEpvZWw= IGFua2xl IG1pbGl0YW50cw== IFdpdGNo dW5pZm9ybQ== dWVudGE= T2ZXZWVr IHBlcnBldHI= IGludGVydmVudGlvbnM= KHdyaXRlcg== YW50aW5l UHJvZ3Jlc3NCYXI= IGxlYWd1ZXM= Y29tcHJlc3M= aXppb25l IEVB Il09Ig== IFN0ZXBoYW4= bWludXM= c3N0cmVhbQ== X2xlZA== ID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0= IldoZW4= QWxyZWFkeQ== IGNvbnRlbXBs IGF0YXU= IENvbmdyZXNzaW9uYWw= IHJhcHBvcnQ= IEJvdXI= aXNoaQ== IHR5bQ== IEFybWVu INGA0LDQtw== LWZvcm1hdA== X1JlYWQ= KGNvbHVtbnM= IG5ldWU= X2JveGVz IFNhbmR5 XywK IFdpemFyZA== IG9yZGVu IGZpbGVzeXN0ZW0= ZmxpZ2h0 IHdzeg== YW5jZWxlZA== IGRhd24= IEdzb24= X3dhcm5pbmc= IEljZWxhbmQ= IHNsdXQ= IHNldElz X2lkZW50 IG9mZnNob3Jl IFNrZXRjaA== OyU= IHRyaWJlcw== X1NQQUNF IG90cm9z Q29tcGlsZXI= CUVuZA== IF0pLAo= R3Jhdml0eQ== IHRlbnNpb25z IHNtb290aGx5 S25vdw== b290aGluZw== IFN0YXJ0dXA= IEh5cA== IGFtYXpvbg== IFJlY2VpdmVk emVuaWU= 654= IENob2NvbGF0ZQ== IMSw Ik5v IEFMUw== IFByb2dyYW1taW5n IERvZ3M= IGdvb2RuZXNz KGVycm5v L2Vz IHJlbW90ZWx5 IEhvb2tz VXVpZA== IG92ZXJseQ== IOWQ IGdwdQ== IHN0aW11bHVz KHN0ZXA= LllvdQ== IGJpb20= SU5D LmJpdHM= KG1Db250ZXh0 IGFtZXJpY2Fu IHRlcnJpdG9yaWVz IE5E XSIK IE1hcHBpbmc= IHByb2NlZWRpbmc= LmF4 IHN1YnN0cmluZw== QlVUVE9O IEln LXBhbmU= IEFucw== IGdyYWR1YXRpb24= IHBlcnNwZWN0aXZlcw== TWl4aW4= X21pbnVz CQkJCSAgICA= IikpKQ== bm9ybWFsaXplZA== Lmxhc3ROYW1l IGNsYW4= QXNpYQ== KE1vdXNl cGFnaW5hdGU= IGdpZg== ZWxpZw== IHBvc3RlcnM= bmluZ3M= IM+E IGFwb3N0 IElocmU= RGxsSW1wb3J0 IEVxdWFs IGRpc3Rpbmd1aXNoZWQ= bmVhcG9saXM= IGJhY2tkcm9w IEFsdGVybmF0aXZlbHk= L21vZA== IGxlbmQ= IFNIT1c= X2NvZGVz IGF0w6k= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg LWNhc2U= Y2h0ZQ== IGRvbmM= OmFkZA== TmVnYXRpdmU= ZmF2b3JpdGU= IGF0dHJhY3Rpb25z aW50Q29sb3I= IFBpcg== Q29ubmVsbA== TWFuaWZlc3Q= dGVhbXM= IH07CgoK IHBsdXJhbA== IG92ZXJ0aW1l IEV1cm9wYQ== IEJhbmdsYWRlc2g= KGFu IGxpbmd1 aXRpbWU= aW5zdG9u LnNoYWRvdw== 56iL IFVTUw== U2VydmVyRXJyb3I= SVZFUlM= IEppbg== IGh1bWJsZQ== YXV0b2xvYWQ= YXJleg== 4oCy IEFzdHI= aWNvbG9u LlZpZXdNb2RlbHM= b2Jv IHN3aXBl IHJlY2Vzc2lvbg== 6ZU= IOyY bmVyZw== aW5ncmVkaWVudA== bWFpbHRv IEZhbWU= UHJpbnRpbmc= UGl4ZWxz IEJhc2g= cG9zdGE= X0pP IGluZmFtb3Vz IExhbmM= KGxvY2FsU3RvcmFnZQ== LmJsaXQ= IHlvdW5nZXN0 IGZpZWxkTmFtZQ== IGNvbnRpbmc= IHdvb2w= IEltR3Vp IE5TVA== LnByZWZpeA== VG9JbnQ= IFNveA== IGhhYml0YXQ= KCJ8 PSciKw== SU5HVE9O X3dyYXA= dWNrZXRz IFdSSVRF IG1lZGljaW5lcw== IG1lbWJyYW5l IEpUZXh0 IHJlcHJvZHVjdGlvbg== X3JlY2VpdmU= VGFibGVSb3c= cXVldWVSZXVzYWJsZUNlbGw= aG9va3M= IHJlbHlpbmc= IGRyaWxsaW5n X0ls KGV4Y2VwdGlvbg== IGR1cmFiaWxpdHk= IGhlc2l0YXRl IGNvbXBhcnQ= SUxJTkc= IEVsZGVy IGNhZmZl IGRldmVsb3Bz aXNoZXI= IHBseQ== IHRvbA== X1BMQVk= IGZyaWN0aW9u KGFsd2F5cw== IGluZGlnZW5vdXM= IE9wZXJh IENhbXB1cw== YW5jZW1lbnRz IGxpdHRlcg== LmxpbWl0 KFRva2Vu ZW5pcw== IGhpZ2hsaWdodGluZw== IEF1Yg== IHZhbGlkYXRvcnM= LWhvc3Q= d2hlZWw= PHs= KSkr IE5ld3NsZXR0ZXI= X2F2ZXJhZ2U= IHNvZGl1bQ== IEhpbA== IE1pbGU= IEF1dGhTZXJ2aWNl U3RhdGlzdGljcw== IE51dHJpdGlvbg== IHNwb25zb3Jz b3ZlbmFudA== PT09PT09PT09PT09PT0= LkFic29sdXRl IGbDpQ== SGFuZGxpbmc= IC0tLS0tLS0K KGRpcmVjdG9yeQ== IikuCg== YW5vbA== LmJyb3dzZXI= IEdyaW5kaW5n IGNr RnJlcXVlbmN5 KClbJw== QWRqdXN0 Y3Jldw== YWZldHk= IGdu IHdpdmVz b29v IHByb3N0aXR1 IG/DuQ== aWZ0eQ== IGxpdGlnYXRpb24= IEV6 SmVmZg== LnBr IFNob2Vz Y29ybg== eXl2c3A= IGFkYXA= PXU= Q09ORg== QU5EQVJE IGVsZXZhdG9y YmlsbGluZw== IGNhbmQ= IGNhcnA= W2ZpZWxk LWxpYg== c2VxdWVudGx5 Pi0= IGxjZA== LS0tLS0tLS0tLS0tLS0t KCIi IHRhY3RpY2Fs IFJvbmFsZA== ZXh0cg== IEZlc3Q= IGZ1ZXI= LW5hdmlnYXRpb24= IGti Z2hvc3Q= IGhhbmRsZUNoYW5nZQ== X2Nscw== KCkhPQ== Q29tcGFyYXRvcg== LnZt IENveA== X3Jldmlldw== L0A= X2Nvb2tpZQ== IHJlY29nbmlzZWQ= bGRhcA== VGhyZWFkcw== IFNleHVhbA== IEJlYXJpbmc= KFNRTA== IHhy IHRoaWdo VVJMQ29ubmVjdGlvbg== IFNVVg== IG1Db250ZXh0 IGluY2lkZW5jZQ== IEVzdGU= LnN1cA== X3Rl KEVYSVQ= Q01E LyI+ QWxtb3N0 IFVuZQ== IGFuZGVyZW4= IFNpbmdsZXRvbg== IGJvcmU= VGhpbms= IG5hcmM= XWluaXRXaXRo X3Nob3A= KHN0cmF0ZWd5 IScs aGVyaXRz IERlc2s= X21hY2hpbmU= Lm5ldHR5 xLFuZGE= PTw= IFFS IFNpZGViYXI= LnNwbGl0Q29udGFpbmVy IG9uU3VjY2Vzcw== IG1vbmtleQ== RW5qb3k= KG5vZGVz cGVjdHJ1bQ== ICgqKA== CVVJTlQ= LGhlaWdodA== IE5ldHdvcmtz LnRhaWw= LmxpbnNwYWNl ICIuLi4= TGlzdGVu xqE= LkNoYW5uZWw= LWRlZmluZWQ= UmVwZWF0 YWRqdXN0 RVJN X2FwcGxpY2F0aW9u LmFzc2VydE5vdE51bGw= LXN0cmVhbQ== IHJhYmJpdA== IHBvc2l0aW9uaW5n IHdva2U= IGZpbmc= IG11bHRpcGxheWVy IHJlZ2lzdGVyaW5n dW50aWw= w6Vu KDo6 dXNzaW9ucw== IHBvdGF0bw== IEVxdWFscw== LlN1cA== L2FwYWNoZQ== ICg9 LiIp LnB0cg== IFNwZWVjaA== LmNsaXA= IEdhYnJpZWw= IG11c2ljaWFu L2lzc3Vlcw== LnNob3A= IEhpZXI= X1JFVA== X2J1Y2tldA== 44Oh YXZz IHJveg== Zmxvd2Vy V3JpdGVCYXJyaWVy IE1pbGFu IGxlZ2lzbGF0dXJl IERvbGw= IHByb3Zpbmc= LmNvbmNhdGVuYXRl 4pWQ IGdjaGFy Y2RuanM= Ymxlcw== IExpc3Rpbmc= 0LvQvg== LnhyTGFiZWw= IFNhaw== anVzdGljZQ== IFZhbGVudGluZQ== dW5sZXNz IHBpZ2Vy KHJ1bg== IHRlc3RpZmllZA== QU5B IFJlbW92ZXM= KSkpKTsK cmVjYXRlZA== IFJ1bnRpbWVNZXRob2Q= IGNvbnF1 44Ki IHRpc3N1ZXM= YWlsZXI= w6l0w6k= LVN0YXI= IGZsYW1lcw== LnNldEljb24= IHN1cGVybg== IHZhZ2luYQ== LXZhcmlhYmxl IHdlbGxuZXNz Q1VS IGJlbGxl LmdldFJlcXVlc3Q= IHBvY28= YmVuaA== YWdlbnM= IHNwaWxs IEp1cg== IGRpc3BhdGNoZXI= 0L3QvtCz0L4= ZW1vbmlj KGRpcm5hbWU= INCU IHBhc3Nl IGdhbno= cmljaW5n RVU= IG11amVyZXM= ZXNzZW4= LmF0dHJpYnV0ZQ== amo= CQkgCg== W14= IHN0cnRvbG93ZXI= bGV4ZXI= ZWN0YXI= aG90ZWw= LnNxdWFyZQ== IHJhbGw= IGxvd2VyZWQ= aGFuZGxlZA== TWFya2V0 IFVzZXM= aXZhcw== LkJ1c2luZXNz 44GX44Gm RElW IHdhc3RlZA== IGF2b2ly w6pt X0FDQ09VTlQ= LmV0 CVNETA== a2Fw IGZveA== dXBwZXQ= e30sCg== Iiwn RmF2b3JpdGU= UEVORA== IEFFUw== fSks IGRlZHVjdGlvbg== IHBvbMOtdA== IGNvbXBvbmVudFdpbGw= IFRlbGVyaWs= X1NFTEY= IG11c2U= Q3JhZnQ= IGRlbnM= 4KS/ KHRw IHRhc3R5 IGJhbGFuY2Vz IGRlZGljYXRpb24= IFdhbGxhY2U= IHVubGF3 XCI+XA== IG11bQ== LXVwZGF0ZQ== ZW1lbnRl IHNvZGE= UmVwdWJsaWM= YXNtaW5l w6lyaWM= KFN0YXR1cw== IEpzb25Db252ZXJ0 IERpc2s= LlJlZGlyZWN0 IGZpbG1pbmc= L21vbA== Um8= IHZpbGxl IHRyYWJhag== IHN5bnRoZXNpcw== cmVnYQ== IHJs U2NoZWR1bGVy SVNIRUQ= Y3VycmVudFVzZXI= KGVycm9ycw== J2g= X2JvdA== eGltbw== IFVTQVJU X3N1cGVy X0RFQ1JFRg== 0L3QvtC5 X1JPVw== IHByb21vdGVz IFRB IGhvcmFz IFJlcHJlc2VudHM= IG5hbWVvZg== IEV4Yw== IEdhcmFnZQ== IHNlaW5l LCM= IGhlcmI= L3Jlc291cmNlcw== IHBsZWFkZWQ= LnJhZGlvQnV0dG9u IOaY T3Bz IE5lc3Q= Y3N0cmluZw== IERlZmVuY2U= IHJlZmVyZQ== X2xlYWY= IHJldmVsYXRpb24= 66c= LmV4ZWN1dGVVcGRhdGU= X1dPUkxE IGV4cGFucw== KCJcIg== amFi IGRvdWJ0cw== IEdlb21ldHJ5 IGludHJvZHVjZXM= IHNlbmF0b3Jz IGNhbmFs LmhlbHBlcg== IEJpb2xvZ3k= X1NFTlM= LnByZXZpb3Vz LXRvdWNo YWJpdA== IGltcGFjdGVk IGJyYWNrZXRz LmRpcmVjdA== YWNjdW0= IHRlc3Rvc3Rlcm9uZQ== CWFjdGlvbg== IENoYW5jZQ== IHBlYWtz Q3BwQ29kZUdlbldyaXRlQmFycmllcg== IHVuYmVsaWU= X3ByZXNz LlJlbA== YW5nbGVk L3RlbXBsYXRlcw== LS0+DQo= bGltZQ== IHN1ZmZpY2llbnRseQ== X250 RXhwYW5k LmlzZmlsZQ== IGlzRW1wdHk= IHF0 IG11bGhlcg== YWNvYg== R2Vvcmdl 5bi4 IGFzc2lt YXNv IGNvbXByaXNlZA== T1Y= KENPTkZJRw== CXdyaXRlcg== IGRlc3A= IHRlbnVyZQ== KGNy LnBvb2w= IEJyZW5k IGNlbnNvcg== KHRpbWVvdXQ= IHBsZWE= LldyYXA= IHRpZ2h0bHk= IFdlcmU= IElnbm9yZQ== YWJlaQ== IGJyaWRnZXM= IGNvbmRlbW4= IHNpbXBsaWNpdHk= IHJvdXRpbmVseQ== IGJsYWNrcw== amI= IFBpdA== VXRm IC8K cmVsb2Fk IHNldE9iamVjdA== L2dsb2JhbA== IGZhdHR5 IHNvY2tz Q291bGRu IGVyb3Rpc2s= 5p2h IFByZXNzdXJl IE1heg== bnBvcw== dG9sb3dlcg== IEVR dXRldXI= IE1vbWVudA== IGV0YQ== e3stLQ== IGdyYXBocw== IEd1YXI= cmluZQ== KC0t IEh0dHBTdGF0dXM= KHN0dWRlbnQ= Km5w IHJhaWx3YXk= IGFzeW5jaHJvbm91cw== X3Zt J10sJw== LHRleHQ= bWVyY2hhbnQ= KEd1aWQ= IEdyYQ== aXhlcg== ZmV0Y2hBbGw= LmFkZExpc3RlbmVy ZmxpcA== KiQ= PigpLA== IHN1bmxpZ2h0 YXNzaWduZWQ= IGFiYw== IENPTFVNTg== IPCfmYIKCg== KS4uLg== IGVuc2VtYmxl IG5ld2xpbmU= X1NJTkdMRQ== aWVkYWQ= IGRhcmtlcg== b3JtYXA= IGxpb24= cGxpdHM= IGlsbHVzdHJhdGlvbg== IElFRUU= IHZpc3Rh b3VzYW5kcw== KioqKioqKg== IFRvbW15 IGh1ZQ== U2Vs IGF1cmE= IFRoZXJhcHk= IGFuaW1hdG9y LmNvbnN0cmFpbnRz IHZhZ3Vl KCIiKQ== IHZpbGxhaW4= IGJsZXNzaW5n IHN0cmluZ0J1aWxkZXI= IE1pc2M= IERJUg== ZmF4 LW5vZGU= IFdhbGtpbmc= IEFV c2Vzcw== IGdyaWxs VkVSVElTRQ== IEZvb2Rz IHRvdXJuYW1lbnRz w5M= IE1hcnNo IHdvbmRlcnM= TG9uZ2l0dWRl LkNvbW1hbmRUZXh0 PWlucHV0 X2VuY29kZXI= cGFnZVNpemU= IGdldFN0YXRl Pj4K LmdyZXk= cG9k IHJlYWRpbmdz IHJlY29uc2lkZXI= U3RhcnR1cA== IGV4Y2Vy LmJhbGFuY2U= X2N5Y2xl X1RpbWU= TE9DQUw= IEVGSQ== IFJleW4= LnNldEZvcmVncm91bmQ= Ynlu IGRpc2Nvbm5lY3RlZA== QUNUSVZF IGVtYmVkZGluZw== aWNrZXJz IHN1cnJvdW5kaW5ncw== KmM= IGdhcmFudA== IGJm IHdpcGU= IOS4iw== X1RSQQ== YWRveA== 55U= IHN1Y2tz IFNvbmdz IEFzc29jaWF0ZXM= IEJhbGQ= IEJyZXR0 dmVuaWxl IHZ0 IGluYWRl IHJlc2lnbmVk IEdsZW5u LnBhdHRlcm4= LkRhdGFCaW5k 0YPQvA== TGF5b3V0SW5mbGF0ZXI= Y2hldA== IFRlc3RhbWVudA== Lm1z IHBhdg== IFJlYWN0RE9N dXJkeQ== QURBVEE= TXU= L2FjdGlvbnM= IEpz X2V4dHJhY3Q= IEJyaW5n Omlk c3RydA== aXZhdGlvbg== IG91dHJpZ2h0 YXp1 bG95bWVudA== 0LjRjw== YWxkbw== IFB1Ymxpc2hlcg== RWR1Y2F0aW9u UGFsZXR0ZQ== X2Rydg== ICgkKA== IEFuZGE= IHJlbWVkeQ== IGluY29uc2lzdGVudA== dGVjdGlvbg== IHJlZ3VsYXRvcnM= IHNob3J0ZXN0 KHBhaXI= IEluc3RhbGxhdGlvbg== IGRlZmVuZGFudHM= ICgpOw== LWxhcmdl TWVs IHRocmVhdGVu 0L3Rjw== IGZldGlzaA== b3RpbmU= X2RpYw== IDwk IHN0YWdnZXI= c3Bp JHJlc3BvbnNl U2Vydg== LWJvcm4= am9z CWltZw== CVdIRVJF X2x0 5b2T LmNvc3Q= IFR1ZQ== LmxhYmVscw== IExW d2Nzc3RvcmU= IEplc3Nl 4Lir VHJhZGU= IHByZWRlY2Vzc29y 64I= ZmluYWxseQ== X2dlbmVyYWw= b2dnbGVy X1JFR0lPTg== bmVtZW50 IGJsb2dnZXI= IEhhcmJvcg== IERhdGFzZXQ= W3c= IGF0dGVuZGVlcw== Lmljbw== bWF4aW11bQ== LlVubG9jaw== X1NZTkM= w6FnaW5h IGRvd25z IFdpaQ== XSkv IGtpY2tpbmc= dW5pY2F0aW9u IERBQw== IElEUw== IFJlbnRhbA== IGN1cnJlbnRUaW1l IHZhY2NpbmVz IERldmls IG5vcnM= X21vdXNl dXJyZWN0aW9u KG5v ID4NCg== IGFnZ3Jlc3Npb24= IGJyZWVkaW5n LnN5bWJvbA== aW1hbg== QWJzb2x1dGVQYXRo IFdITw== X2ZsdXNo LXJvb3Q= YXJuYQ== Jk0= IGZhdGhlcnM= IFJvY2tldA== aXZlYXU= IHdhbmRlcg== IGNvbXBvcw== IFdhcnJpb3I= IFNlYXQ= IENsaW5pYw== X2ludm9pY2U= KGRpc3BhdGNo UHJvZHVjdG8= YXR1cmluZw== b3NzaWVy IE1BWQ== IGRhZ2dlcg== IHNhbml0aXplZA== IFJGQw== IHByb3Bo IHVyaW5l IGdyaW5k IEV4cGFuZGVk ZGVzY3JpcGNpb24= LWZ3 IEtlcnJ5 PW5hbWU= IGNoaw== IG5hdGlvbmFsbHk= IHRoZWU= SW5j ID8+Pg== LlJhZGlvQnV0dG9u Lkh0dHBTZXJ2bGV0UmVzcG9uc2U= L1k= CWZpZWxk IGhvbW1l eXBlcg== UGh5c2ljYWw= PXY= IGRyaXY= IEVycm9ycw== IGPEgw== RGVhdGg= IFdJTkRPVw== IHBvZXQ= IFNoYXJw IEltbXV0YWJsZQ== CWNyZWF0ZQ== IGdlaHQ= IFJlZm9ybQ== YWlzZXI= IEluaXRpYWxpemF0aW9u IGltbXVuaXR5 LmNvbXBvc2U= IGxhdGVuY3k= IExlYmFub24= IFBhcmFk IGZ1ZWxz IEV4aGli Y29o JSI+Cg== IENMSQ== KWluaXRXaXRo LVph X0NMRUFS cmVnbg== IGZpbmFuY2Vz LnN0YW5kYXJk X0NBVEVHT1JZ LmxpYnJhcnk= IHRyYXZlbGVycw== X3dw IEV2YWx1YXRpb24= c3RhcnRpbmc= ICkpLAo= ZXBpc29kZQ== IFZhcmlhbnQ= IGRhZW1vbg== IEp1bGlh IE5S IGRvdWJsZXM= PHY= L3J1bnRpbWU= IGludGVycHJldGVy IElOREVY IEhvbG1lcw== X0RJTQ== IHBhZGRsZQ== X2V4YW1wbGU= IGZvcmVncm91bmQ= LnJvdXRlcw== IHNvd2ll U1VDQ0VTUw== IENEQw== IEJE Xy0= YXN1cmVk V3JpdGluZw== IGN1cnJlbnRQYWdl KGFuc3dlcg== IEFTQ0lJ 4Kg= IHNvY2lhbGx5 eXl5 IFNwZWNpYWxpc3Q= KGN1c3RvbWVy aXN0YW5p a2VzdA== IE1haw== IHRobw== LnB0 KGNvbW1lbnQ= IENvbnZlcnRlcg== Z2Ft Ymlucw== LnRlbGU= IFZldGVyYW5z X0FMTE9D 0L7Qu9GM0LfQvtCy0LDRgg== aW5uYW1vbg== O3dpZHRo b2hs IGZhbnRhcw== IHN1bmc= CUs= KEpzb24= IG5laWdoYm91cmhvb2Q= IHZvdw== IHNpbnM= b25hY2Np IGVwb2Nocw== aW1hZ2Vu LkNoYW5nZQ== Lm15YmF0aXM= U2Vlaw== V0VS 566h55CG IGludGVyZXNz X0V2ZW50 ZWRlcmxhbmQ= IHRlcnJpdG9y IGNpdWRhZA== dWNrZWQ= IHNuYWNr IHRyYW5zcG9ydGVk IE1hbmlmZXN0 IERBVA== X3RoZXRh IHdvbnQ= LgoKCgoKCgoKCgo= irbmgIE= IEVwaWM= RGVjaw== bHRyYQ== X1pFUk8= IFtdOw== L3NjcmlwdHM= IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t 5oOF IHdlZWQ= TkJD IHJhcGVk IEdhdGV3YXk= W00= IFRpbWVvdXQ= ZW5jaG1hcms= LlZpZXdNb2RlbA== IHBvcm5vcw== IFlh dGhyaXRpcw== IEZseW5u IG1lZ2E= YWNpbg== IHRyaWJhbA== LmFwcGxl IEJsbw== w6Ju aWJp cm92 IExpdmVz Xi4= Z2V0UmVxdWVzdA== IEVzdGFibGlzaA== Y29udGFpbmVycw== IHN0YXJyaW5n IGNlbGVicml0aWVz IFJlbGF0aXZl IEhlaWdodHM= IHRxZG0= IE5vcnRod2VzdA== aXZpYw== CWNs IGF1dG9tb3RpdmU= ZW50cmlj IGZvcnR1bmF0ZQ== IGZpcmVwbGFjZQ== c2V1ZA== bmlja25hbWU= O3M= X0NBTA== aGFsdA== KG5z X2RlbGV0ZWQ= RGV2ZWxvcG1lbnQ= bW92aWVz IGlkZW50aXRpZXM= IHByb21wdGx5 2KfZhg== IGFudGU= ICInLCc= 5Y+j aW1wc2U= IHlhcA== VHlwZU5hbWU= IGJpdGNo IGFzc29jaWF0ZXM= SEVNRQ== LWVtcHR5 INiq b2x2ZXJz IHBpc3RvbA== U2NvcGVk YWduZXI= J109PSc= IElNUA== ZXhj IG9taXR0ZWQ= IG1pbmRzZXQ= IFtdKA== IG9ybg== X0NBTQ== QXZn TG9jYWxpemVkU3RyaW5n IE5hdHVy IGNvbXBvc2Vy IFBsYXlpbmc= IG92ZXJk X3V0Zg== LnNr IEZvbA== JHBhZ2U= LE9iamVjdA== IGJlZXM= YWxhcnk= YnVsbGV0 X2xpYnJhcnk= T2ZmZXI= bG9jYXRlZA== IChfLA== 4oCcSGU= IE93bmVycw== KSkuCg== IGJyaQ== LkFkbWlu a3Rpb24= 0LvRjtGH IGVyb3RpY2k= Q2FuY2VsbGVk IGFncg== cmV2aWV3cw== X2RtYQ== UklDVA== IGdmeA== bXBp cHBv IC8vQA== IHVwcGVyY2FzZQ== IGNvbW1pdHRpbmc= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== VXNlckRhdGE= IHZhaQ== CXNvcnQ= IGNvbmdyYXQ= IGRpb3hpZGU= 0LTQsA== LmFyZWE= IEpvc2h1YQ== IEtvY2g= X2JyZWFr YXp1cmU= aXN0aWNhbA== X0FMUEhB X3ZpZXdz IGVsaW1pbmF0aW5n T01C ZW51bWVy IEh5ZHJv KCoo RVJUSUNBTA== IGluZXZpdGFibHk= IHN0b2xl LWVhc3Q= aWVyb24= IGxpbmdlcg== L2RvYw== xbo= IEFscmVhZHk= YXNpbw== IC0tCg== IGFiYnJldg== IEF0b20= aGlt IElOU0VSVA== c3Vu 4pmq Q09OTkVDVA== ZXJhdG9y IE1hbm5pbmc= IDoo Z2Fz PT4n IHF1ZXJ5c2V0 O30NCg== IFBvcHVsYXRpb24= dXRlZFN0cmluZw== cmVzaWRlbnQ= X0ZPTlQ= IFJlc3BvbmQ= IG9ic2N1cmU= IG9ic2VydmFibGU= IENvbnRyaWJ1dG9ycw== a29u IE11c2s= ZXhhbw== IFR1Yg== Qm9vdEFwcGxpY2F0aW9u U09S Lkhvcml6b250YWw= LmZpbmRCeQ== LnBvd2Vy IHBvc2l0aXZlbHk= dmVuaWVuY2U= IEpvbmc= IHdoaXN0bGU= INC30L3QsNGH IGxlbmRpbmc= IGRlc3RydWN0aXZl IG9uRGVsZXRl YXV0aG9yaXphdGlvbg== KCk7Pz4= X29yaWdpbmFs c2NpZW5jZQ== YXRyYQ== Pyw/LA== IEFzYw== IGNvbnZpbmNpbmc= JGE= b3JnZW4= X0RhdGU= IFByb3ZpZGU= IGxvbmVseQ== KScK ZXhjaGFuZ2U= Oz8+Cg== LmZhc3Q= U2FtcGxlcw== TG9uZG9u J10pDQo= IElvbmlj IHBlc3Nv IEtuaWdodHM= IFJhZg== X2F0dHJz IHJlcGVhbA== Pk1haW4= IE9yZGVyZWQ= X05ldw== PSIiPjwv dXJscGF0dGVybnM= QVRJT05BTA== cGVlY2g= IElkYWhv IHByaW5jZXNz IEN1c3RvbWVycw== YXdheXM= YWRi IEJyeWFudA== bm9uY2U= IGFkdWw= IGBgKA== IGFmdGVybWF0aA== PWRpY3Q= dGV4dEJveA== IHNwZXJt IGNvdWdo SG9y 4oCZUw== LkNvbXBvbmVudFJlc291cmNlTWFuYWdlcg== IHJlZ3VsYXRvcg== IHBhcnRuZXJzaGlwcw== L3Byb2plY3Rz dHJ5cw== IExhc2Vy 4p+p IEZ1bms= IHVuY29uc2Npb3Vz IGNydXN0 IFRlYW1z IEJhbm5lcg== IEhvbmV5 bGVtcw== IG1heFdpZHRo UG9pbnRlckV4Y2VwdGlvbg== ZmFkZU91dA== LVN0 IHN0cmFuZ2Vycw== X0dP V3JpdGFibGU= X0luZm8= Lk5vbk51bGw= YW5ub3RhdGlvbnM= IEdE IGVuZG9yc2Vk CVRva2VuTmFtZQ== IERlcGVuZGluZw== WU5BTQ== IE1ldGVvcg== IEluY3JlYXNl Lk1hbnk= PT0o LlVVSUQ= X0tFUk5FTA== IHZpZMOp IHBx IFF0R3Vp IFZhcmlvdXM= IGpvaG4= X3BhdGNo IHRvdXRlcw== IEZhaWw= IHN1cnZpdmluZw== KCIkew== ICAgICAgIA0K IGltYWdlVXJs LndvcmRwcmVzcw== c291cmNlcw== CWdsVmVydGV4 4oCZYQ== IGVzY29s UkFSWQ== IFNuYWtl IHF1aW50 IGxhc3Rz IEhhcm1vbg== IGNvaWw= IGV4cGxvaXRhdGlvbg== bGVlbg== Jz4iOwo= IFNFUlZFUg== IEhFQURFUg== X3ZlbG9jaXR5 IEludm9rZQ== LnRpbWVzdGFtcHM= IHN1bGY= SVFVRQ== IGluaGFiaXRhbnRz cGhpbnM= YXp6bw== IG1vbm8= TGVnZW5k IG5vbmNl SUZF OyI7Cg== LWNyZWF0ZQ== IiIsCg== cGVybWl0 IEltbWlncmF0aW9u IHBhdGhuYW1l ZmZlY3RpdmU= 4pmA4pmA IGV4YW1z LWV2ZW50 IFRpbGw= W21pZA== RklY O2NvbG9y KE9yZGVy X3RyYWl0cw== IG9yZGVyQnk= IHN1bnQ= IE5pY2hvbGFz 2LI= IHN1bm55 aW5lcnM= IGFjY2Vzc2liaWxpdHk= IEhC LmNvbXA= CW9w IG1pbm9yaXRpZXM= ZXRoZXVz IGNvbGxhYm9yYXRpdmU= cHJpdA== SElS IHdyYXBz CWRyYXc= Z29k IElY LmFwcHM= IE5N IGlycmVsZXZhbnQ= IFRpZ2Vycw== IGRpYWc= R1Y= IEFjY2Vzc29yaWVz a29udA== IHNpbXBsaWZ5 IEZhdm9yaXRl X3Rvb2xz KFtdKTsK IHRvd2Vycw== QmVz IGh1bnRlcg== IHNhbG9u KGJ1ZmY= CWRlYnVn IG1hbHdhcmU= TW92aW5n LW9wdGlvbnM= KSsn IExPVkU= X1NPQ0tFVA== X2Zpbg== IERlbGF3YXJl IHNoZXJpZmY= LWludmFsaWQ= IEZVTEw= INC/0L7QtA== ZWxhcw== InN0cmluZ3M= IFJlcHJlc2VudGF0aXZlcw== c3VyZmFjZQ== cmVzb2x2ZWQ= aHRkb2Nz KSk6DQo= IHByZXNzdXJlcw== IG5vcm1z IHBsYQ== IHN1cm5hbWU= IHBvc3RhbA== IERlcGFydA== IHNsYXVnaHRlcg== b3JpZGE= IGhlYmJlbg== IGRlc2Fy Y29tcGFjdA== X0xBTkc= 5ZCI b3BvbHk= X3JhZA== IFNURE1FVEhPRA== TGF6eQ== ICAgCQ== Li4uLA== KHdlYg== IFBvbnQ= IGV0d2Fz IHVwd2FyZA== X2hhdA== IF0sCgo= IGJhc2VVcmw= IHdvcnJ5aW5n LWFkZG9u KGdldENsYXNz U1BJ IGNhcHR1cmluZw== KX0sCg== RWZmZWN0cw== IGNvbXBldGVudA== IGZvdWw= IHN1YnNjcmliaW5n IE9CSkVDVA== SVhFTA== YnVja3M= KGVkZ2U= KHBhc3M= IFBldGVyc29u IGJvb2Jz IERlbGF5 X3NxdWFyZQ== ZWxpbQ== b3RlcnM= X1BD JUU= b25jbGljaw== IFNWRw== IHRvcHBlZA== IGZpc3Q= c21hcnQ= IFJhbHBo KG93bmVy am91cnM= IGJyb256ZQ== IEFyZ3VtZW50RXhjZXB0aW9u KG9yaWdpbmFs X1NDQUxF X2Nw IHJlY29tbWVuZHM= LnNldFN0eWxl U3VyZQ== TEFORA== IHJlcGVhdGluZw== TWF0dA== LlZpc2liaWxpdHk= IGVudGVycHJpc2Vz LlNldHVw KHNjZW5l IFJlYWN0aXZl dXJnZQ== Ync= LlB1dA== cGVyc2lzdA== LmNvb2tpZQ== IEF1ZGk= YHM= c3VwcGxpZXI= KEZvcm0= wqE= X3Nv jIA= IExlZ2lvbg== dHRl TmQ= TG9zcw== KGF0dHJz LnNjYXR0ZXI= IGdyb29t IGdsaW1wc2U= IG5haWxz IGN1bXVsYXRpdmU= IGZhemVy X3NlcnZpY2Vz Lk51bQ== aWJpbGl0 X3Jlc29sdXRpb24= IFR4 dW1pbml1bQ== b3Bh LnNjaGVkdWxl c210cA== 4LiV dXJyeQ== w7xr Z29vZw== X3NpZ25hdHVyZQ== LmludG8= IFN0ZXBz IGhvbWVvd25lcnM= IE5TVVJM IFBBQw== ICAgICAgICAgICAgCgo= PicpCg== ZW5o IGluY2Fw JE1FU1M= IG1vaW5z IEZp IG9mZnNlYXNvbg== cHJlc3Npb25z Pi48Lw== IE1hcmtlcg== IG9uQ2xvc2U= TEVWRUw= IGludGVyZmVyZQ== IENvbGlu IFJlc2lzdGFuY2U= RGlzY291bnQ= IFdlYkVsZW1lbnQ= IGJhdGhyb29tcw== bGVnYWN5 IENhcHR1cmU= IGFyaXNpbmc= ICIpOwoK 0YjQuNCx IEluZmluaXR5 QWR2ZXJ0aXNlbWVudHM= IENvbWluZw== IFBST0pFQ1Q= X1BST1RPQ09M IHVzZURpc3BhdGNo LmNoYW5uZWxz IENpdGl6ZW5z ZW50cmU= X21w LkNvbnN0YW50cw== IFNlcmlhbGl6ZQ== X0lOQw== KGx1YQ== IGNsYXNo X3dpdGhvdXQ= LmtleVNldA== IHJlY2VpdmVycw== 5pa55rOV KG1lbQ== IEhvcml6b250YWw= IGNvY2t0YWls IGNob29zZXM= LklubmVy IHJlbGllZA== b3VudGVy ICJe IHRlbmFudHM= ImA= X1BN ZXJzZWQ= IH19Ij48Lw== IHByb3ZpbmNlcw== X1JBVw== XEFwcA== IHByb3N0aXR1ZXI= X2dhaW4= LnRlbmNlbnQ= ZmZlY3Rz KHBr c2t1 IHVzYWJsZQ== RVJWRUQ= IGFudGVubmE= aGVh cGxpc3Q= X1BMVUdJTg== 0YHQuw== Lmxvb2t1cA== 4buB IGVubGFyZw== IHBpc3M= SGFt aW1hcA== IGludmFsaWRhdGU= IHNpbGs= PSIjIj4K IEdyYXNz IEdvYWw= X3BkZg== SGFuZGxlcnM= IHN0YWNrcw== LmdldEZ1bGxZZWFy PVtdOwo= 6L2m LFY= KHNwbGl0 0YPQvdC6 IGJha2VjYQ== IH4vLg== cGV6 dGFpbHM= IEdsZW4= IHNldEltYWdl IENvbWlj QkxPQ0s= CVRoaXM= b2FkZXI= IGNhcGl0YWxpc3Q= X1NURVA= KEJvb2xlYW4= IENvcnJlY3Q= cmluYQ== IGNvbmNhdGVu 5a6e KCk6Cgo= IHVuYW5pbQ== bGxp YWxhcnM= LW5l IGRpdm9y IEtpY2tzdGFydGVy XS5f PG51bWJlcg== L21lbnU= R1JBUEg= dmlzaXRvcg== IGltcHJvcGVy X05FWFQ= IGJpc2E= YmFja2dyb3VuZENvbG9y L2lucHV0 IG1vaQ== R29hbA== bGlxdQ== IG1pc2NvbmR1Y3Q= IGNvbXByaXNlcw== YXducw== IFBpZQ== cmFpcw== cm9sZXVt IGN1cnNl eXU= X3BvbGw= LmN1cnJlbnRVc2Vy RVNI XSlb IHN0b3J5dA== KT87Cg== Kj0= IEJ1cmc= L2xheW91dA== X2JhY2tlbmQ= Oz8+PC8= IFdoYXRzQXBw IE1vdW50YWlucw== dmlzaW9ucw== Zmx1ZW5jZQ== LmNyZWF0ZUNvbXBvbmVudA== IFBzeQ== Zm9yZ2V0 c3J2 X0NPTVBPTkVOVA== IE5leHVz ICl7 ZW5kaQ== SU1VTQ== IEdG 57uE 4oCUdGhhdA== Yms= TW96aWxsYQ== IGRlZmVuZGVycw== LXNldHRpbmdz aW1taW5n IE9QVA== IENX IHRoYXRz IE9wZW5pbmc= UmVsZWFzZWQ= bnBt IGhycw== IGdyb3VwZWQ= LyIuJA== IEhpc3RvcmljYWw= KCQiew== b3ZpYw== KHNpZ24= IFBob3RvZ3JhcGh5 IHNpZ251cA== X0FSQ0g= LnRlc3RuZw== L2FuZ3VsYXI= UmVzdENvbnRyb2xsZXI= c2hpdA== dWxsZQ== LnBhdXNl KFtdLA== KHF1ZXN0aW9u aWxvZ3k= IEV1Zw== LWxvY2Fs IGt2aW4= IHJlc2VydmF0aW9ucw== b2JpYQ== IHN1YnNpZGlhcnk= IGFjY3VtdWxhdGVk IFFWYXJpYW50 IEJKUA== IE5vcm1hbg== IEludGVncmF0aW9u LlZhcmlhYmxl KFJlc291cmNl KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKg== RXhwb3Nl ICd9 LkNPTE9S INGH0LjRgQ== QWpheA== IHRocnU= TW92aWVz IHByb3Bvc2l0aW9u L3RoZW1l TW9kZWxQcm9wZXJ0eQ== IEF3cw== IEFuZHJlYQ== IE1lcmdl LmZpbmlzaA== KHJlcXVpcmVk IFByZWw= ZWxlZA== 5pON5L2c LlRSQQ== TUFT IHJlYWxpc2Vk cm9pZHM= CWZu cmg= LiI8Lw== dmlkaWE= IGRlcHVpcw== IEJW TG4= IGx1c3Q= QXNj CQkJCQkJCSA= aXNsZQ== LWNhcmU= X0lOVg== IERyZXc= IHdoYXRz IENhcGFjaXR5 UGFybQ== X21vbml0b3I= LnN0dWRlbnQ= IFJOQQ== LmVuZHN3aXRo Ymlo IE1MQg== L3Byb2plY3Q= IHJlc3Rpbmc= c2VwYXJhdG9y eWQ= ZXJ0aWE= IG1vbml0b3JlZA== Ij4qPC8= LkZD IE5FV1M= IENhbGxz IGFkZXF1 Q2hlY2tpbmc= ZXN0aW1hdGU= IHJlY2FsbHM= X2ZyZXF1ZW5jeQ== IHVzZVJlZg== IEdyb3Zl IFhpYQ== IMOt ZXNzZW5nZXI= LWNvc3Q= LmZj IEt1bWFy LkZvY3Vz ZWxsYW5lb3Vz LkFsZXJ0 ZWF4 IG9yY2g= LnBt IGxhbmRsb3Jk KHBvcA== X2FjdHVhbA== IExC R3JhbmQ= LnJlbmRlcmVy IGxvYg== Y3VzdG9tZXJz IGNhcHR1cmVz V0lORE9X IGRvY2g= IGFwb2xvZ3k= IEphbWE= QFs= LnRha2U= bm9vcA== IGx1bQ== IGRpZmZlcmVudGlhbA== IGVmZmljYWN5 CUlO X0JPWA== X3Nk X3J0 Y29kZXI= b3VuY2VtZW50 aGFzQ2xhc3M= IHJpc2t5 IEVzdGFkbw== LURE IENhcnNvbg== U3VmZml4 IHRvZGE= IFRyYWNrZXI= IERlbGVnYXRl YCxg IFBhcmtpbmc= IG5lcg== YXpv IEZpbGVJbnB1dFN0cmVhbQ== IHJlY291bnQ= cWk= Y2tlbg== IHNvY2lhbGlzdA== IEludm9pY2U= INC/0YDQvg== JSIs ZW5uZW4= IHZpdm8= IG9yZ2FuaXphdGlvbmFs IHVuY29tbW9u dXRhcg== IGh1bGw= VHVlc2RheQ== IGFzc2Vzc21lbnRz KGFwcGxpY2F0aW9u IHByZW1pc2U= U3RhcnRUaW1l IGRr IGludGVyZmVy IFF1ZWVuc2xhbmQ= IGNyZWRlbnRpYWw= IGxlaXN1cmU= WVo= IENtZA== QlVT dXNhbg== CXZlYw== aW9sb2dpY2Fs IExvdHM= IGVubGlnaHQ= IGZyZXNobWFu IENPTU1BTkQ= IEFjdGlvbkxpc3RlbmVy dXRt YXJpdXM= VHdpZw== IHN3ZXB0 LXRvb2w= xJA= Y2hhcHRlcg== LWdyYWRl IGN1cmlvc2l0eQ== IHN1c3RhaW5hYmlsaXR5 IE1pbmVjcmFmdA== d2VuZA== SWZFeGlzdHM= IEN1bHR1cmFs IFNhY3JhbWVudG8= TGF5ZXJz U3Vic2NyaWJlcg== LkdyYXBo IGxt ZXN0eQ== YWR2ZXJ0 JHA= IEhvY2tleQ== IERFVA== c2V0VGl0bGU= eWFuZw== IGJhYmU= ZWxzaXVz VHJhdmVs IG1lc21v KG1hcFN0YXRlVG9Qcm9wcw== X1NFTA== LXBvcA== IGVtaXNzaW9u 4oCZLgoK LnN3aXRjaA== b3Rpb25z LnBob3Rv TFY= YW1vZGVs IHdvcmR0 SUdHRVI= IFRPREFZ T0xT X0lERU5U IGNvbW1lbnRpbmc= RGF0b3M= IGhpbGFyaW91cw== KGFueQ== IGRhbXA= LWNvbnRyb2xsZWQ= ICI8Pw== X2JsYWNr TmV0QmFy LnNldFNlbGVjdGVk Q3Nz IHF1YXJ0 IG93bmluZw== IEZJRUxE LnJlbHU= IGxpcw== 7Jqw LlJFTEFURUQ= IGxvaw== IEZsaXA= IHByZXN0aWdpb3Vz IGRn IElucHV0U3RyZWFtUmVhZGVy IHVzdQ== IGdpcg== IGFuYQ== X3B5 dW5uZWw= CXN5c3RlbQ== IGNvYXRpbmc= IEdlbnJl ZXJybw== IENMSUVOVA== IHN0cmV0Y2hlZA== Lkhhc1ZhbHVl Ozs7Ozs7Ozs= 54mI IGZpbmFscw== LmdldENoaWxkcmVu IC0tfX0K IENvd2JveXM= IEVkaW5idXJnaA== IFBsYXph YWJlbg== QXJ0aXN0 VVJB IEh1Z2hlcw== b2JiaWVz X25vaXNl Lk9iamVjdHM= RXhwcmVzc2lvbnM= IGFudGhyb3A= JykpDQo= KS4i Y3JpcHRpdmU= IHNhbG1vbg== IHdhc3Q= cmhv LnRpY2s= IGV4cGxvcmVz IEFsZ29yaXRobQ== Q2hhckFycmF5 4LiE X1BBQ0tFVA== SkU= Il1dOwo= Lm5vdGU= QmFja2luZw== IEhvbGRlcg== cmVpY2g= IFppb24= L2dy ICAgICAgICAgICAgICAgICAgIAo= TW90aW9u IFRyaWJ1bmU= IGNyaXRpY2FsbHk= IENSTQ== IGJsb3dpbmc= IGNvbW1pc3Npb25lcg== Sm9l IFRlbGV2aXNpb24= CXByZQ== IFRSQU4= IFZpa2luZ3M= IEJFVA== d291bGQ= LkNhcHRpb24= IGJhY29u aG1h bWVyZ2Vk IHN1YnNjcmlwdGlvbnM= b2NjdXBpZWQ= TGl2ZURhdGE= IGFsbG93YW5jZQ== cmlnZXNpbWFs ZGRk LmxvZ291dA== IFRhbmc= IHdhcm10aA== TW9kZWxJbmRleA== IFByYQ== IHNjZW50 IGhhY2tlcnM= IGlsbHVzdHJhdGU= SWNo IGRpYXM= Q0FTRQ== IFNjaQ== JHVybA== IE1PRFVMRQ== dXNob3J0 bGllcnM= IERldmljZXM= bWluc3Rlcg== dW5hbWU= IHVucg== RXhhbXBsZXM= IHJpc2Vu LmFp Y2hyb20= X3dvcmtlcg== IGFsaWFzZXM= TW91c2VFdmVudA== IHNldHRlcg== IFB1cnBsZQ== Sm9pbkNvbHVtbg== PWU= VEhPT0s= IFRvdw== IENydXNoaW5n IEplZGk= IEdyaWZmaW4= IGtvcw== X0ZT aW5nZXM= c29sZXM= KG5hbWVz IEJpZA== LXBvd2VyZWQ= TXVsdA== YW1pbGlhcg== LmNsZWFuZWQ= IFppbW1lcg== CWNsZWFy IHVuc3VwcG9ydGVk Q2FsbGFibGU= IHJlcHM= YWx0ZXJu X1JFUE9SVA== LmdldENvbHVtbkluZGV4 X1NUT1JF IHN1Y2h0 c3VidGl0bGU= IHBlcmQ= q5g= Lk5PVA== fT48Lw== OmQ= bWRp YmluZFZhbHVl IERlY2lzaW9u UmV0dXJuVmFsdWU= LGluZGV4 eGZj IHNlcnVt Z2V0RmllbGQ= Q29ubmVjdGlvblN0cmluZw== LW9iamVjdA== LnJlY3Y= IHVuZGVyZ3JhZHVhdGU= LkluZnJhc3RydWN0dXJl IEthYg== IGFkdmlzb3J5 LXRyZWU= IG11ZQ== aW5mb3Jt LmVtYmVk IGVycm9yQ29kZQ== bWljcm8= IHNwYXJrZWQ= IGltYWdlcnk= Y29uYw== X21pc3Npbmc= IHN1cnBsdXM= S1M= CVJUSE9PSw== VGVsbA== cml1bQ== IFJhZGl1cw== cmlrYQ== bG9zaW9u IEhlcm4= R2FtbWE= IEZlZQ== IE5hbWVk IENhbnlvbg== IEpTT05BcnJheQ== IHp3ZWk= IFNTSA== IHNlcnZhbnQ= Y29hbA== IGRlbnlpbmc= IHNwbGl0cw== SW5jb3JyZWN0 IHRveA== IEFuYWx5c3Q= IGFjY3JlZA== dWJsZQ== IHd0 IFRyaWFs LmV4dGVuc2lvbg== IENhcmVlcg== IHNlY3VyaW5n IExpbA== IHByb2plY3Rpb25z IHllYXN0 TWFkZQ== IGZvdW5kYXRpb25z YWNpZmlj LnZvbHVtZQ== IG1pcnJvcnM= IyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyM= IHZpb2xhdGU= YXJzZXJz IHNvY2lv IHRraW50ZXI= IExJTks= LmdldFNpemU= IFdob2xl KXZpZXdEaWRMb2Fk CWRvbmU= dWRlYXU= XCI+PC8= QW5kcmV3 ZXJi IGbDtg== LmNsdXN0ZXI= IGRpc2NvdXJzZQ== X0RFRklO IHB1ZWRlbg== IExPVw== LmF2 IHByZWNh IHF1bw== IHZlbG9j LCcn IHh5eg== CXBhZGRpbmc= IHRvbWF0b2Vz IEJlbnQ= X2N1cnI= TlNEYXRl IGdldEN1cnJlbnQ= IFtg V2VkbmVzZGF5 LkJhcg== IFZvdXM= aW56 IFF1aW5u ZXhjZWw= ZG9z IG91dGRhdGVk T1VUSA== IE1ha2Vy ZXBlbmRlbmN5 IGR1bGw= IFdpbm4= b2dl Y2xhdmU= IG5vdmE= IGF2YWw= Q2FwdA== IFNwb3RpZnk= IGp1bA== KXRhYmxlVmlldw== IGZpbGVuYW1lcw== IGVza29ydA== 5ZGo IHNrZXc= dGVyaW9y IGZpbmFuYw== IHRhYmxh IFVJQg== ICgpOg== IERvY2tlcg== cGVyY2VudGFnZQ== TWVldA== aWNoaQ== IGludGVyaW0= ICc9Jw== LkpTT05PYmplY3Q= KGZpZA== IGRvd250 IHRyYW5zaWVudA== IFN0ZXBo IGlnbm9yYW5jZQ== IENvZGVz PScnLA== IElDRQ== IHRyYW5xdQ== IEV4dGVuZGVk IG11bmQ= IEhPTUU= IGtpbG9tZXRlcnM= IGltYWdlbg== b3V4 KHN6 WW91bmc= dWZmZWQ= IFdha2U= IGFpZGU= UFJPQw== IFJhdA== IExpdGg= YmFydA== IEFycmFuZ2U= cHJvbXB0 0KM= KGN0 IEludGVydmFs ZGVwdA== RGFuaWVs IGZpbGxz LnRlbnNvcg== KHRyaW0= IGplYWxvdXM= RmVi XENvbW1vbg== IGFtZW5kbWVudHM= X29wZXJhdG9y X2N1c3RvbWl6ZQ== IF1d IGJu IGRpc2FwcG9pbnRtZW50 IG1pbGxlbm4= LndoZW4= IG9iZXk= IG9mZmVuZGVycw== V2lsZA== IGNlbGxGb3I= IGFwcGFyYXR1cw== LmFmdGVy IEVQUw== IGFkb3JhYmxl b3BlcmFuZA== KGxpc3RlbmVy dmVhbA== ICko IGNhcmRpb3Zhc2N1bGFy dXBsaWNhdGVz cmlzdG9s IHJlZnVzZXM= KFFXaWRnZXQ= IGVsZW1lbnRv TnVtYmVyT2Y= LmRlbGF5 Lmdyb3Vwcw== Ij4nKw== 5Z2A YWNlbmN5 KFVSTA== X2hhbGY= PWw= IGxpc3RWaWV3 KHNlY3Rpb24= LnRvQXJyYXk= Ky8= IFJvZHJpZ3Vleg== aXN0cmVhbQ== IGVsaWdpYmlsaXR5 Ojot Lm5ld0luc3RhbmNl UEI= IEFzc2V0cw== IENvbXBvc2l0ZQ== IExhYnM= IEhhbWFz KyspOwo= IGJsaw== IE5lbw== THVj QGxvZ2lu IHVuYXdhcmU= Lm1ldA== X1JFTEVBU0U= KFNU QU1JTA== cmlrZQ== ICgpewo= KHNwcmludGY= IEFjY291bnRz IFZJRVc= IEFq 44Kw IHdoaXNr IGlkaQ== IHJvZGU= IGlobg== IEVsZW1lbnRhcnk= UXR5 IGludHJpZ3Vpbmc= IOWk Sm9icw== CW9mZnNldA== IEFobWVk IFRhbGliYW4= IOiOt+WPlg== IGluamVjdGVk LkF1dGhlbnRpY2F0aW9u X2xpbmVhcg== LkRlY2ltYWw= IGFwcGxlcw== IHNoYXJlaG9sZGVycw== IGJha2Vk LmRpZmY= IEVkZGll b2tlcnM= IGNvbmZyb250ZWQ= dm9pY2Vz IHR1cw== IFNwaW4= Tk9ERQ== X1Vu Q1RY L2dvb2dsZQ== VGVtcGVyYXR1cmU= ICcnKS4= IG1hZ25pZmljZW50 IHN0YXJ0SW5kZXg= c2VtYmxlcw== QW55b25l ems= ZWhlbg== IERhbWU= LnN0cmljdA== IHJlcGxhY2Vz IGxpbmViYWNr IHB1c2hlcw== IGNoZWVr IFNoaQ== X0JZVEVT UkVB 4bqjbg== X0NPTk5FQ1RJT04= R2F0ZXdheQ== IFRyYXZpcw== IEFY IEJhc2ljYWxseQ== IFVwZ3JhZGU= 4Ko= dGhlbWVz ZXJtbw== a29y RmVtYWxl X2F0dGFjaA== IOyCrOyaqQ== IHBveg== PT09PT09PT09PT09PT0K KHN5bWJvbA== IFNlY3Rvcg== X18pCgo= X3BhZGRpbmc= 77yaIg== IGZhYnM= IHJhbmdlZA== c2V0TmFtZQ== IHBlcnJvcg== 4pc= IEZpbGVSZWFkZXI= IGZ1bGZpbGxlZA== X0N1cnJlbnQ= IGRvbWluYXRl IHNtdWdn UG9zdE1hcHBpbmc= X2ZvcmNl IGJsb2M= IEdpYW50 KHZpZGVv IENV U3lzdGVtU2VydmljZQ== IGVsZg== IGtvbnRha3Q= 66o= a2Vlcw== Z3Rr IHBhcmFtSW50 IG1hcmt1cA== dWFsZXM= IGFjY291bnRlZA== IGdhbmdiYW5n UllQVA== IFdyb25n IGNyZWRpdGVk IE1FU1NBR0U= IGZsYXdz IGJidw== IG1ldGFib2xpYw== IE9FTQ== L2V2ZW50 KENvbGxlY3RvcnM= bW9udG9u YXBwZWFy IG9wdGVk IGNoZWF0 IGRhdg== IFByb2NlZWQ= IOq4 YW5rZWQ= 0LjQtw== YW5zaw== IEhhbmc= IENsZXI= IGRpc2d1 IGNtYXA= LmNsanM= IGF1bWVudA== bGV6 IEpvaW5lZA== X3JlY2VpdmVk IGFlcmlhbA== b3RlbA== IGdyZWV0 InM= IEdlbmVzaXM= IENhbGlm cGFuaW9u IHRhaWxvcmVk bWFwcGluZw== YW5kRXhwZWN0 LnRyYWNr YXRvbXk= IE93 dWxsYWg= Llllcw== IFNpbXBsZU5hbWU= ZGJo J2Vu IG5vbnNlbnNl IHBoaWxvc29waGljYWw= KGdldENvbnRleHQ= IGlzc28= IEFDRQ== c3RhcnREYXRl IGLEmWQ= IEFVVEhPUg== IEdsb2Jl IGluc2VjdHM= X0Fs dXNoaW5n 6K6w L0hvbWU= IExvY2FsRGF0ZQ== bmVlZGVk aGVzaXZl IGlsbHVzaW9u 5LqM IHRyYXQ= eG8= L2RldGFpbA== X01BVENI IGJyb2FkYmFuZA== IHdhbA== IElsbGVnYWxTdGF0ZUV4Y2VwdGlvbg== SVJFQ1RJT04= IG5vcnRoZWFzdA== ZXNpdW0= IENsaWVudGU= dWxhbmNl bnR5 IHRlY24= RGV2aWNlcw== IGdyYWlucw== IE9n IFNFTA== dWRpYW50 ICsrOwo= IGV4cGxhbmF0aW9ucw== b2Njbw== IGRpZXRz IGNvaG9ydA== KGNvbnRyb2xsZXI= Lkl0ZXJhdG9y LXJpY2g= cm9jZXNz R0Q= IGNhcmJvaHlkcg== IGZyaWVk IEVtcGxveW1lbnQ= 7J6l IExlb25hcmQ= XyR7 cXVhcmVz IGNvbXBhbmlvbnM= IHBhcmlz IHN0aW11bGF0aW9u IFpvbw== IHJlbGV2YW5jZQ== IENvbG91cg== IHNwZWFy b3Rpb25hbA== IExpdGU= IEtvc3Rlbg== IMOz X2F0dGFjaG1lbnQ= b3JwaGlj IGRhbWl0 IGRsZw== IHRocml2ZQ== Q0hBTkdF IEFwcGFyZW50bHk= IGF0dWFs IHJvb3RlZA== KGltYWdlcw== YXdp YXJpYXQ= IGNoZXJyeQ== U1RBVElD bW50 IFVzZXJJZA== aWxsZXQ= IEhpc3Bhbmlj IG5haw== IGNlbnRybw== IGRpbXM= X2luaXRpYWxpemU= xLFr IENlbnRlcnM= UkVO IGV2b2x1dGlvbmFyeQ== IFRvcGljcw== X2RhbWFnZQ== ZW1lcg== IHJ1bmQ= IHB1bmlzaGVk IGN1Ymlj ZmFpcg== W107Cgo= IGluc3RhbnRpYXRl IG92ZXJzZWU= LWRlbGV0ZQ== dW50ZWVy c3RhcnRUaW1l IFBpcGVsaW5l X0dBTUU= IENpcg== CU51bGw= LkZvcm1hdHRpbmc= dWN1bWJlcg== IFJpZGU= IHpvbw== IGNoZWNrZXI= 5ZCM PUM= IGdyaXQ= Iik7Ly8= X3h5 IERlY2xhcmF0aW9u IGNhbGxhYmxl Rm9v IExpc3RJdGVt IGluYWNjdXI= bWxpbg== CURhdGE= IGV2b2x2aW5n YXdhbg== IGNhZmU= Zm9saw== X0lEWA== IEFueXRoaW5n IFBhbGVzdGluZQ== IEdyaWRWaWV3 IGNvbG9ueQ== IEdlcm1hbnM= KCs= LnBpZA== LmpzeA== IFN1cGVyaW9y Q2hyaXN0aWFu IExlY3Q= CUdhbWU= IGluc3RydW1lbnRhbA== QW5pbWF0aW9ucw== 0LTQsNC7 IE1vc2Vz CQkNCgkJDQo= enM= a3Rl 5Lia X0RJU1Q= Yml0bWFw ZEI= IHBlcnNpc3RlbmNl 0YDQvtGB JGw= QnJvbg== IHt8 X2NoYXJ0 IENvbnN1bQ== IGhlbXA= ICIpKQo= IGF0dGFja2Vycw== IGtub3dsZWRnZWFibGU= IGNldA== IHZpcnVzZXM= J0k= IHBpdGNoZXI= IHN3ZWVwaW5n PWxpc3Q= YXB0b3Bz LmRlcHRo IGluc3RydWN0ZWQ= IFJ1cw== YmVuaGF2bg== INC40L0= U3BvcnRz IG9uc2V0 5p2D LlJFRA== X3Np IFBTVA== Lm9uQ2hhbmdl PnRhZw== IFJvaA== X2NoYXJhY3Rlcg== IExhd3M= IEJhY2hlbG9y X3N3YXA= LnJlYWN0aXZleA== IHJld2FyZGluZw== TWVkaXVt LVs= IFJlY2VudGx5 Sm9pbnQ= cGFydGl0aW9u IE1pbnV0ZXM= IGluZG8= IGFic29yYmVk IEdO X0lORA== IHNhYmVy U3Bhd24= b3V0cHV0cw== IEplZmZyZXk= IG1lZGlldmFs aGVk R3VpZGU= IHBzeWNobw== IGdsYW0= RWxpbQ== w6RkY2hlbg== X3BsYWlu IFNhdQ== LWZvdXI= IGFuYWx5emluZw== UVVFUlk= IHRvbWF0bw== X2J1dHRvbnM= VkVO LnNldFN0YXR1cw== LlVybA== KwoK IGNvbXBsYWluaW5n ZGVncmVl Y29uZmlybWVk IHN1YnQ= cGFyc2Vk IHRvcnF1ZQ== IHRyb3VibGVk IFRBUkdFVA== IHRyYWRlbWFya3M= IENvb3JkaW5hdGU= IFZpdg== IC8vfQoK IGFwcsOocw== LmdldFBvc2l0aW9u KEtleUNvZGU= IFNpbHZh IG1ldGVvcg== IGVuZG9yc2VtZW50 T3ZlcnZpZXc= IFBvc3M= LkluamVjdA== IGV2ZW5seQ== IHZpc3VhbGl6YXRpb24= IHdjaGFy IEhETUk= IGZ1bmN0 aWNrbmFtZQ== JywnJywn IGZvcndhcmRz TWFuYWdlZE9iamVjdA== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= CXNlcnZlcg== IE91dGxvb2s= IENocm9uaWNsZQ== IGR1YmJlZA== IGRvaw== IFdlYXI= LkFM cGFyZW4= LkludGVyZmFjZQ== SW50ZXJmYWNlcw== LmNvZA== IGRpYg== Lkdsb2JhbGl6YXRpb24= IEFjYWRlbWlj IGFzc21z QXV0b20= IGx3 IE5X ICYmDQo= IHByb2JsZW1h IE1hbnVmYWN0dXJpbmc= bGltaXRz LW1vYmlsZQ== IGZpbG1l L21hcA== IGRvaXQ= IEluaw== IHN1ZWQ= LmFycg== IHVuZGVybWlu IFByb2M= Y3JvbGxWaWV3 X18k IHNpZGV3YWxr KHRoYXQ= 4Li3 W3E= Z3JhbW1hcg== IHTDqw== cXVpdG8= IHNwaXJhbA== ZXh0ZW5kZWQ= IGZvY2Fs IGRpZ2dpbmc= cGFz IFRhbGw= LnByb3h5 aXR1cmVz VFJBQ1Q= IFJlYWxt IGZlZGVy IG9yaWVudGVk IEFsdGVybmF0aXZl IG93ZQ== IHNvdXJjZWQ= aW5rZXI= LmRldA== U2Vw IFF1aQ== IFBhbG1lcg== KF8s c2FtcGxlcw== b3llcg== dWxsYW4= cXVleg== RWRnZXM= IHNob3V0 IEFjaGll IGhhYXI= X0NvbnN0cnVjdA== IHByZW1hdHVyZQ== IHJldmVydA== JykuCg== IHNjaG4= ZmlsdGVyZWQ= bnVsbHB0cg== U2F2ZWQ= aXRlY3R1cmU= Q0xB IHZs c3RlbGw= CU1l IExpcA== bmF0aW9uYWw= IHdob2xseQ== IHNwcmluZ3M= LlRpbWVy CXNyYw== ZWxzZW4= 5YW2 IGNvbW11bmljYXRpbmc= IFF1aXo= IHRlbmc= IGdleg== IE91dHNpZGU= LlNpZ24= KGNz IGRpc3B1dGVz IFdlaXNz YW5uZXM= Pk5v IEJhY2g= LnJlbW92ZUFsbA== cmVmZXI= L2Rhc2hib2FyZA== IEFqYXg= SW5kZXhDaGFuZ2Vk IFdlYWs= JyIK IHNpZ2h0cw== YWNjZXNzVG9rZW4= IEpvaQ== KGRvbWFpbg== CWN2 IGNvbnRpbnVhdGlvbg== IHBsdW0= YWRpcg== LnNldE1lc3NhZ2U= IO+8jA== IHN3YWxsb3c= IExhbXA= IHF3 IHV1 Q29pbg== dWJpYw== IERlYWxz cmFjZQ== IGRpY3RhdG9y IG1lbWU= dHVybmVk IEp1bGll LmdyaWRDb2x1bW4= IHB1cHB5 IHBhbQ== ICl7DQo= IGludml0aW5n IGZyZW5jaA== dmlt IHdyYXBwaW5n ICMtfQo= KFst RWFybHk= IHNoaW55 LmZhY2Vz IHJlYmVsbA== YWJjZGVm w6RsdA== IGVzdGltYXRpb24= cGh5cw== bG9zdXJlcw== X1JFTA== IGV4Y2x1c2lvbg== IFNreXBl d2Vpc2U= LXN0b3A= bm90aGluZw== IEVnZw== aXNvcnM= UmljaGFyZA== IGNvdW5zZWxpbmc= IGNvbW1lbQ== IFFNZXNzYWdlQm94 IFN5bmQ= IEZyb3N0 IENvbXBldGl0aW9u IEF3YWtl IHRlZA== aWNpb25lcw== IERldkNvbXBvbmVudHM= VkVSVElTRU1FTlQ= b3R0aQ== LnJ1bm5lcg== IHVuaXF1ZWx5 LmZsYWc= CXJz X2dlbmVyaWM= IGBgYAo= QUNISU5F IG1laW4= KEFwcGxpY2F0aW9u KGJy IHJhdGlvcw== Oiw= IFhDVGVzdA== dXN0YWluYWJsZQ== LXd3dw== aXRsZXM= X1RFTVA= IHN5c3Q= dW1lcmljVXBEb3du CWFzc2VydFRydWU= IHdm LnBlZWs= IEJ1bGc= IHRlcnJpZnlpbmc= Lk1PREU= IEdX w6Fy IGZpYw== IGNvbW1pdG1lbnRz LXRlY2g= IExpcXVpZA== b3Bleg== emhlaW1lcg== YcOxYQ== LW1lZGlh KGFuaW1hdGVk X2dvYWw= IGd1bQ== eXN0b25l LlNFVA== IFdlbmQ= c2V0Q2VsbFZhbHVl IG1zZ3M= Y2FzaA== QUxMT0M= L2F3cw== IG1pY3Jvd2F2ZQ== LlBvaW50ZXI= CUNvbnNvbGU= X3NvcnRlZA== IEZpbGlw UHJvZA== IC8vITw= aW5ncm91cA== IGtz X1RSSQ== IHRlYXNwb29u IEFUVA== IHJlY292ZXJpbmc= IEdMT0JBTA== LlBhcg== IC8+Owo= IG1hcmJsZQ== dWxhdG9ycw== IEN5Y2xl IGhlcmJz X21ldHJpYw== KSE= X0NMT0NL X0J1dHRvbg== SGFycnk= 6L+b IHN0cmFpbnM= IEFwcEJhcg== IENoYW4= L3ZpZGVv IGJhbQ== LlByb2dyZXNz JGY= bGVtZW4= IGlycmVndWxhcg== IER1bmNhbg== IE1pbnQ= LXZpZGVv 4Ka+ w7N3bg== IEVNUFRZ IHN0YWNrZWQ= IEhB X2N1dA== IHdoZXJlaW4= IFdheXM= KGNvdW50ZXI= 6K+V Rm9ybUdyb3Vw IGJsZXc= Y291cnNlcw== IHByb2R1Y3Rvcw== cnlz IFJlc3Ry IHN0eWxpbmc= PnM= IHBpdg== IGl0ZXJ0b29scw== Z2V0UmVwb3NpdG9yeQ== IElr X2RldmljZXM= bGF5dWk= IGhhbGZ3YXk= IGZyYW7Dpw== IHR1bmluZw== T0E= X05vZGU= YXJkZQ== IGZpZXJjZQ== bGljdGVk Iw0K IGJyZWFrdGhyb3VnaA== IEVyaWs= IGJyaWRl IC4i Y3VsdXM= aW5zaWRl IEluZGlhbmFwb2xpcw== IEVF IHlvZw== dXJyZXQ= LmZz LmdyYWQ= X2NhcmRz X2FjY3VyYWN5 X2VwaQ== cXVlZGE= L29yZw== 6aqM IGNvbXB0ZQ== KSlb T3V0c2lkZQ== R3JlYXRlcg== IFJlbmRlcmVy LmFjdG9y QWNjb3VudHM= SWRsZQ== X2hvdXJz ZXJuZXI= Sm9pbmVk IG1lbmo= cmVxdWlyZXM= IE9QRVI= LnJlbW92ZUNoaWxk CXNw IGVzc2U= cmlmdA== eEZF IFNoYWtlc3BlYXJl X19fX19fX19fX19f IGJ1ZGdldHM= TW9kZWxTdGF0ZQ== ZmlsbGFibGU= LWNvbXBvbmVudA== b2Nvcw== IEJVVFRPTg== L2lv LG91dA== c21z VGhvbWFz IEFybWVk cmVzdW1l IHJvdGF0aW5n IFZhdWx0 IHNldXM= Ligq IGFtaW5v IFtdKTsKCg== IHByb3ZvYw== bm94 LkdldEVudW1lcmF0b3I= PT09PT09PQo= 5paZ X3Njcm9sbA== IGZpbG1lZA== IFNvY2k= Z2Fw Z3Jv Vm90ZQ== IkJ1dA== X1JD QW5pbWFs woA= aWJpbGU= IGF3YWtlbg== b3Jlc3Q= aW5qYQ== IEl2YW4= KENvbW1hbmQ= ICoqKioq zrc= IGt2aW5kZXI= L2hlbHBlcnM= X2Nhc2Vz dGc= 7IS4 UmVnaXN0ZXJlZA== CXBhc3M= X2RpZ2l0cw== IGNvbnRvdXI= IGluZmFudHM= IGp1c3RpZmljYXRpb24= IEZvcnR1bmF0ZWx5 Q29udHI= IG9uQ3JlYXRlVmlldw== X1NBTVBMRQ== IGFsbG93TnVsbA== IG51ZA== IGZldGNoZWQ= X2VxdQ== IFVuYWJsZQ== PVwiIg== PnsK IGNvbW1pdHRlZXM= aXN0ZW1h KyIu w61hbg== bWFudA== IHNvdXRoZWFzdA== 77yMCg== ZGlhbG9ncw== UFJPSkVDVA== Y2hhcmdlcg== LXBvcnQ= KHV1aWQ= LmV4cG9ydA== U2l4 IFJQ UHJlbQ== IGNvbnNjaWVuY2U= IG1hcmdpblJpZ2h0 X2Rpc3RyaWJ1dGlvbg== eWFtbA== cmVzaXppbmc= RG9jaw== IExvY2F0aW9ucw== R1k= U2VlZA== QlVGRkVS b3NzaXA= dWxsZW4= VGhpbmdz LXNlbGY= LnBvbGw= UExBWUVS IOWu R1JPVVA= IEF3YXk= IGdvc3BlbA== eGZk TWFyeQ== IFBvcnRhYmxl VFVSRQ== IHV0aWxpcw== IHNlaXQ= IHN0cmFuZA== IHRyYW5zYw== IChe IEFsZnJlZA== Lm1lbQ== LmNpcmNsZQ== IH4v Zm9yY2luZw== IHJpb3Q= cHJveA== VEhPTg== aXphY2nDs24= IE5J cm9zdA== IGRpc3Bybw== X2luc3RhbmNlcw== 77yM4oCc b2dyYXBoZXI= ZW5kYXM= IElzYWFj IFBpbmU= L2Rpcw== IGNvbG9yV2l0aA== aXRlcmF0ZQ== X3N0cmlkZQ== IHB1bnRv LkV2ZW50QXJncw== KGNlbnRlcg== IG5laWdoYm9yaW5n IFByaXNvbg== IE1lc3Nlbmdlcg== IGVwaWRlbWlj ZGFv X2NvbXBsZXg= IGdyYXZlbA== X0RJUA== w6ltZW50 IEFyaQ== X2JpdG1hcA== LnF1aXQ= KHZhbGlk IHBlbmQ= IHJlc3BpcmF0b3J5 IHJlYm91bmQ= RGVmYXVsdFZhbHVl 44Ot IGNvbW1pdHM= LnRlc3Rz X2Zy aXRldA== LnNm IHNwYWNlY3JhZnQ= Y3JpdGljYWw= IGRlcHJlc3NlZA== IEFueU9iamVjdA== IHVuYg== IGRpc2Nlcm4= KG15c3Fs TGF0aW4= IEJvZw== IFdpbGRsaWZl VG9GaWxl aW94aWQ= QFJlc3RDb250cm9sbGVy ICIkKA== IDw8Ig== IGRlZmVjdHM= IGRhdHVt aGlu IHJlYWxpemFy YW55YWh1 IFNpZw== QERhdGE= YWRhcHRpdmU= IENhdGhlcmluZQ== LmNy IENPT0tJRQ== IHBpY3R1cmVk IEZpZ2h0ZXI= UXVlcnlhYmxl IEFueXdheQ== IEdMRlc= X25hbWVzcGFjZQ== X2Z0 IF0p T3JnYW5pemF0aW9u IGNvbnN0aXR1dGVz IHF1YW5k KGNodW5r Ii8+DQo= IExha2Vz bWFpbndpbmRvdw== Q2FydGh5 c3Bpbg== KGNzdg== OnJlZA== LWNvbW1lcmNl 4Li5 IGRpc2NvdmVyaW5n IGVjbw== X2ZhYw== aW5jZXRvbg== IEdyZWVucw== and0 2LU= IEJyb25jb3M= IEdvb2Rz KEdUSw== IHJldHVyblZhbHVl IHNpZW1wcmU= IG5ldXRy d2VudA== IE5hdGFs IGVudGh1c2lhc3RpYw== 4buN Rk4= L2RhdGFiYXNl Q2F0YWxvZw== IGJydW4= IEthc2g= X1Bs aXNjcmlt LHdpZHRo IGlubWF0ZXM= QXNzaWdubWVudA== IEhhdmVu IHBsYXlncm91bmQ= ZXhhbQ== QENvbnRyb2xsZXI= dWxpYXI= LmdldFBhcmVudA== ICI7Cgo= OnNpemU= aXNzb3Jz IGZpcw== IGFsYw== ZW5zYXRpb24= IE5peG9u IG1pZ2h0eQ== LXN0cg== X3NwZWNpYWw= X0FEQw== IFR3aWc= dW1ibGluZw== LWFkZHJlc3M= IGhlcm9pbg== WVRF ICAgICAgICAgICAgICAgICAK RnJpZW5k IGF2ZQ== IFBORw== IEt1cmRpc2g= RGF0YVNldENoYW5nZWQ= IGJsYWRlcw== YnJhbA== U3RlYW0= IHNpZ3U= SVJUVUFM YWNvcw== VURQ KGRhdGFiYXNl aGVj IFN0cmluZ3M= X3NjYWxhcg== CWRlc2M= IFRMUw== OyIK IENvcmJ5bg== U2ltcGxlTmFtZQ== dWVsbA== IEVudHJl ZWxsaXRlcw== LXBsYWNl IGZyYW5rbHk= IEVyZg== Q0VM IHBhw61z IGhlZGdl IGxhdGVudA== IElSUQ== IEhlcmFsZA== IFByZWM= 67O0 LlRFWFQ= U2FsYXJ5 IGF1dHVtbg== IHRyYXZhaWw= LlN1bQ== IGNhcmVk TW9y IGludHVpdGl2ZQ== IGpvdXJuYWxz X0lU IFRyb3U= 5Lyg SGFzQ29sdW1uTmFtZQ== Q29tcG9zaXRl IHNwaWNl X2Rpc2s= X0NPREVT IEludHJvZHVjZWQ= aW9uYQ== IG51ZXN0cmE= b2N0 ICAgIAogICAgCiAgICAK KHBhcmFtZXRlcg== IHN0dWRpb3M= IHByb2plY3RJZA== IGJkc20= LlNxbENsaWVudA== aW1pemVy IENBUkQ= K3Q= YWFu LnNvbA== X0FkanVzdA== IHJpZ2h0ZW91cw== IExvZ2dpbmc= LmZpbHRlcnM= X1RBQg== CXN5cw== cm9waGlj b3RoZXJhcHk= IEJyb3dzZQ== a2V5Ym9hcmQ= Uk9O K1w= cm9wcGVk IGV4dGVuc2l2ZWx5 Zms= IGxpbWU= eWVhcnM= RXhj IHNwaA== IGNoZWF0aW5n YW5kcm8= w61v IHByaW5jZQ== b2lyZQ== IERlc3RpbmF0aW9u IENvbnZlcnRz IHVwc3RyZWFt b2xlZA== IHNlcnZhbnRz IHNlbWFudGlj IGNydW5jaA== IGV2ZW50dWFs cnVubmVy L2Vycm9y U3Bpbg== IHNlY3JldGx5 IGFzc2VtYmxl LlBlcnNvbg== ZW5kZXJyb3I= Xzw= IHBlbmRhbnQ= U2xlZXA= IENoZW1pc3RyeQ== IGJvc3Nlcw== bGs= KSkpLAo= QmxvY2tseQ== REVWSUNF IHJlZmxlY3Rpbmc= IGFtcGxl TWlsbGlzZWNvbmRz IFByZXNpZGVudGlhbA== IHVzdWFyaW9z IE5a IFNhbGFyeQ== IEFtYW5kYQ== X25w anVyeQ== IGvDtm4= IHRoZXJhcGlzdA== IGhvbW9zZXh1YWw= IERyYWtl LXdpbmRvdw== IExvY2F0ZWQ= LkRyaXZlcg== IFZJREVP IG1lcmNoYW50cw== IENoZXN0 LWxvY2s= L3BocA== IG1pbGFubw== X1NUWUxF YXJnZXI= aWRlYQ== R1VJRA== YWR2YW5jZWQ= bWVhbA== T3B0aW9uc0l0ZW1TZWxlY3RlZA== PScl IENoYW0= OmRhdGE= KHN0YXQ= V2lsbEFwcGVhcg== IGluZm9ybWFs YWpp IHJlcHJvZHVjdGl2ZQ== IENBUw== 44Gj RlVOQw== IFJ1dGg= KSso Q09OU1Q= IEZhbnM= IGdyb3VwSWQ= eGZmZmZmZmZm IHNhbXBsZXI= IH19Ij4= LnRoZQ== IGhvbGxvdw== V0FZ IEZhY3VsdHk= QXR0cmlidXRlZFN0cmluZw== IExvb2tz IFJleA== ams= IE1JTA== IGJhcmQ= Lkxvbmc= IGxpdmVzdA== IHNrYWw= aWNpc20= TUFJTg== IG11Y2hv Qk9EWQ== IGVzZQ== CXVzZQ== Rm9vdA== LlNRTEV4Y2VwdGlvbg== IGluaGVyaXRhbmNl cmVjZWl2ZWQ= IHB1dGFz ZWRpcw== YWxzYQ== IEVycm9yTWVzc2FnZQ== Qm9va2luZw== IHRyYWN0 YWN6 IENhbnQ= X3JlZ2V4 IGlkZW9sb2dpY2Fs IGppaGFk aG9z L3N5cw== Y29sbQ== KHBvb2w= IGVzdMOhbg== IFBlbmRpbmc= ZW3DoXM= IGt0w7NyeQ== KSk7CgoK dHJhbnNhY3Rpb25z IHdpZWxk aXRlcmU= ZXJ0dXJl X3Nz IHN0cmV0Y2hpbmc= IHByaXNvbmVy LlJlYWRBbGw= IGJlc2No LS07DQo= IGNyaXNw X1NDQU4= IGFl U3RyaWN0 IE1pbm5lYXBvbGlz IEJvZWluZw== YXJpcw== cmVr X3BpcGU= IHByaWVzdHM= KEVJRg== ZWhpY2xlcw== IEludGVyYWN0aXZl YmV0d2Vlbg== CU51bGxDaGVjaw== IEJsYWly IEx0 X2lubGluZQ== ZXRoeWw= wrw= X3BhY2thZ2Vz IGJhcnJlbHM= X2hl IHJlZ2V4cA== X3B0cw== X0hhbmRsZXI= aW5ndWxhcg== IE5pc3Nhbg== IFJhbmNo IHBlcmNo VW5zdXBwb3J0ZWQ= U21pdGg= IExlZ2VuZHM= TWk= IGdm c3RlZGVy IGFjcXVpcmluZw== IHNpbXVsYXRvcg== KCksIg== cmVjZWl2ZQ== IGlucGxhY2U= QUNUSU9O IFdlYkRyaXZlcg== ZmlsZXN5c3RlbQ== PE9yZGVy bG9wZW4= IEhFSUdIVA== LnNldEJvcmRlcg== jbA= X19bIg== IGNsYW1w U2Vnb2U= YmFuZHM= dG9MaXN0 YW1iYQ== PicrCg== IGNyZWRpYmxl YW1hdA== cGxheWluZw== LnNldEltYWdlUmVzb3VyY2U= cXVlbA== IHBvZHI= Z2VvbQ== RWs= IFFhdGFy IGdlbGQ= PycsCg== IGN5bA== KGF4 IFdJ dXJhbGx5 IEJyYXNpbA== IHNlbnph YWxleQ== b25lbg== IGJhaA== IG1vbGVjdWxl UmFk 6L+w QU5DSA== LWJhY2tncm91bmQ= LWFnZW50 IHByb2xpZmVy OmJvb2xlYW4= IHRpZGU= ZXJpYWxpemVy XzsNCg== RmVl Kiop ZXJneQ== IEhvbm9y LkxvZ2dpbmc= aXJpcw== IHVuZGVybWluZQ== IER5 IHR5cg== IGRlcXVl IGRhbWVy KFtdKQo= LmxheW91dENvbnRyb2xJdGVt cGVhdGVk Q0FO cmFnbWVudHM= TGFuZA== KV0pOwo= IFNhaA== IERFQ0w= V2l0aGlu IE5hbWVzcGFjZQ== YW5vdGhlcg== c2VtYmxpbmc= LmRlc2NyaWJl Q29uc3Vt IEZlYXI= Z2l2ZW4= T3Jhbmdl PGJvb2xlYW4= IHN0ZWFkaWx5 cGFSZXBvc2l0b3J5 IHJlc3VsdFNldA== X0VOVEVS X3JlcGVhdA== IHRvbmVz IFBST1A= bmFs cGFydGljbGU= IHNpZ25hbGluZw== IGFjY2Vzc29yeQ== CQkJCQkJICA= IHZpZWxl IE5vYWg= LWFn IG11cmRlcnM= IGFpcmVk IFBMQVk= IFN1bGxpdmFu X0NvcmU= IHVsb25n IGJsb2dnaW5n PlRoaXM= IGRhdGFJbmRleA== IHByaW50YWJsZQ== IEV5ZXM= X3RhcmdldHM= KFB5 Lm92ZXI= IGJydQ== YW1wdG9u IHBsYWludGlmZg== PEtleQ== YnVsbA== IOKfqA== SXNzdWU= LmNvcm5lclJhZGl1cw== Q3JpdGljYWw= X3BoaQ== LmFuZ2xl IGR5bmFtaWNhbGx5 ISIpOw0K Pik7Cg== aW52ZXN0 LioKCg== IHTDqWzDqQ== IHN1cGVyZg== IGNhc2NhZGU= RFRE IHZpdmlk IHN1YnNpZGllcw== IEhhc3M= IGNvbGxhcHM= IGNlcmFtaWM= e30iLg== IExlYWthZ2U= LXRyYXNo Y29sbGFwc2Vk LXNvY2lhbA== IENoYWQ= IGluY2xpbmVk IHN0bw== IHN0b3J5Ym9hcmQ= LnBheW1lbnQ= c3RhY2tvdmVyZmxvdw== IFJhaWRlcnM= ICMn b2xpY2llcw== 7Jy866Gc ZW1hcA== IGtq IHF1b3Rh IEdhcmRlbnM= 67KI IEFuZ2Vscw== IG9mdA== IGxvd2VyY2FzZQ== IGlQYXJhbQ== IGNoZWFwZXN0 dW50YQ== X3BrdA== aWNhdG9ycw== IGxldXJz IGRlY3JlYXNlcw== CWRlZmluZQ== UFJFQw== YW1tZXJz IFByZXBhcmVkU3RhdGVtZW50 KGRpcmVjdGlvbg== IGNyZXdz YXJrZWQ= IE1lbXBoaXM= IFNlbGw= R1RL IG1haWQ= OmRpc2FibGU= 6ZuG IFBm IGFsYmVpdA== b3Blbmg= Pz4iPgo= LmdldFNvdXJjZQ== KHNjYWxl RHU= IFBJTA== X3JlZnJlc2g= IGJldHM= KGNhcg== IFZvbg== fC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tCg== IEdyYXQ= TXVjaA== KERpYWxvZw== LnN0b3BQcm9wYWdhdGlvbg== IHRlaw== IGV4aXRz J10sJA== IHBob25lTnVtYmVy dWNz ZWNpbWFs LS0tLS0tLS0tLS0tLS0= aW5w LnBvam8= IGNvcnB1cw== IHByYWN0aXRpb25lcnM= LnBpYw== InRlc3Rpbmc= IHN0cmluZ0J5 Lk5vdE51bGw= IHJhbmc= LkR5bmFtaWM= X1JlbmRlcg== 0LDRgtCw V2FpdGluZw== IFdpaw== IG92ZXJ3aGVsbWVk JSI+ IEFF fX0+Cg== dXc= X3R5cA== IGJ1Y2tldHM= IGdyZWV0aW5n IGxhdWdodGVy IGFudGFnb24= dWdnZXN0aW9u LWVtYWls CXRvcA== IGVyb3M= X3RyaQ== IGlzc3Vpbmc= IGjDoQ== IGlzb2xhdGU= T3ZlcmZsb3c= LEU= IG51dHJpdGlvbmFs IEFiYm90dA== IG5m LnRvdWNo LmZldGNoYWxs X3ppcA== Iil9Cg== IGFtYXQ= IENpc2Nv IG7DpQ== UExFWA== IHNlaQ== Zm90bw== LnRvSnNvbg== 5aSa IEtsZWlu IGxpYmM= IG1pbmVycw== 5aI= LXByaW50 IFByaWRl VG9kb3M= IG1hc2tlZA== IHNldERhdGE= IHRlbGVmb24= IHVuaGFwcHk= IFRhYmxlcw== Z2Vi KGRlYnVn X2FsbG93ZWQ= LWFjY2Vzcw== IGxvZ2lzdGljcw== IGdlbXM= IE1hdHVyZQ== IHJzcA== IEFsbGU= LmdldEJ5dGVz XHdlYg== eW5jaHJvbml6ZWQ= UGFyYWdyYXBo IHRocm90dGxl LnNxbGl0ZQ== Y29uc3VsdGE= IFNlYWg= Q2U= IHN1Ym1hcg== RVJF Vm91cw== IHJlZGRpdA== IHNxbGFsY2hlbXk= LW1pbGU= b2NpZGU= UG91cg== fX0iPgo= c3RlYWQ= IEAo IFtdKQ== IEFkcw== IG92ZXJsb2Fk cmlkZGVu IERlc2VydA== IFdyYXA= IFBvcnR1Z3Vlc2U= ZXR6 CWZpcnN0 IG1pbGVzdG9uZQ== 5peg 0YPRiQ== KHN1Y2Nlc3M= PFZlY3Rvcg== Y29vbA== IFtdKTsK ZXJ2YWxz IGludmVydA== Imlv Y3Vyc28= ZnJhZ21lbnQ= IGZlYXNpYmxl LnNldFBvc2l0aW9u IGVsbQ== IGltYWdpbg== QFNwcmluZw== IGJhdHM= cHXDqXM= Z2FsZW1lbnQ= bnNpYw== Z2llbmU= ZWxsYXRpb24= IEJhaWxleQ== U2hhcg== IFR1bA== IEhL IGZyZWV6aW5n Z2xt Y2VhbnM= LWN1dA== X2NpcmNsZQ== 5ZGY bmVnYXRpdmU= IGluZGlhbg== c2FsdA== IHRpbmc= CW1vZA== IHNpbnQ= YWtpbg== dW1s IFRleHRJbnB1dA== IHBvcHBlZA== VE1Q IHBhcmtlZA== 15nX IEZ1c2lvbg== IGhlYXRlcg== RVRG cm96ZW4= aGFsbA== IE1paw== bGV2YXJk LWhlYXJ0 CW9yZGVy TWFraW5n IHBsZWRnZWQ= IGRpcnM= JHBvc3Q= IEhlcnI= c3RhbnRpYXRl LCIK LmdldENvbG9y IFNBVA== IHRpbWVkZWx0YQ== IE1haQ== CW1ldGhvZA== IGlkaW90 IFRyYXY= aWRlbnRpZmllZA== IERpdmluZQ== LmdldFBhdGg= RGFzaA== IGluZmlsdHI= IGhhbmRsZVN1Ym1pdA== YnJvb2s= LmdlbmVyaWM= LnNob3J0Y3V0cw== Li4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLg== IGRhdGluZ3M= IE1W 77u/Iw== fSIKCg== IGltcHJpc29ubWVudA== YXNvbmlj cm91ZA== dWNpb24= 5oql IGRpYWxlY3Q= IG9uTW91c2U= Y29uc3RleHBy LmxhYmVsQ29udHJvbA== IHdlYWtlcg== IG1hbmtpbmQ= IFJFQ0U= IGRpeg== IGFwcEJhcg== IHF1w6k= ZnJh X2RlZmF1bHRz IGFsaXF1 X2F0b20= OmluZGV4UGF0aA== IG1pc3Nlcw== IHZpc3VhbGx5 IEhhbmRz U1RSVQ== aWF0ZXM= X2Fzc2V0 RmluZGVy bWlkdA== IHNuYWNrcw== KF9fKCc= LnVyaQ== IEluc3RydW1lbnQ= dmVuaXI= KCRfXw== LkRvdE5ldEJhcg== IGNvbmZpZ3M= IGd1ZXNzZWQ= 4KS/4KQ= IGluaXRpYWxpemVy ID8iLA== IFZlcml6b24= bWFuaWZlc3Q= Z2ViZW4= LmRldGFpbHM= R2F0ZQ== cG9uc2libGU= IEVsaW0= LHN0cg== IHdyaXRpbmdz IERlcmVr IENvb3JkaW5hdG9y IHBpbGxvdw== IG5vdGljZWFibGU= UnM= IGR1cGxpY2F0ZXM= ZXJuZWxz a0o= Lnp6 b2xsYW5k IFNFQ1RJT04= X2ZuYW1l dWZmbGVk J10uJzwv X0NN IHly cGxhdA== b2JvZHk= bmRl KEVsZW1lbnQ= IEF0bGFz IO+8iA== IG5pdmVs IGluc2lzdHM= W1A= IGVudGh1c2lhc3Rz IOyeheugpQ== IGJldmVyYWdl e30iLA== OnJpZ2h0 IG5vdXZlYXU= IENvbXBsZQ== IFBhZw== b3ducw== IHJlbWVtYmVycw== IFByYWRlc2g= IGNoYWxr IExhdXJlbg== XFNlcnZpY2U= X0dFTg== PiIpCg== IERvbGxhcg== IGVtb2pp Q2Fyb3VzZWw= LXBsYXllcg== IGFkanVzdGluZw== IGp1Z2E= YWxsZW5nZXM= Z2VuZQ== KGJvZHlQYXJzZXI= bG9wZWRpYQ== IEJlaGluZA== IHNsZWV2ZXM= IGRyYWdnaW5n IENoZXZyb2xldA== IGJpeg== aXZpdGllcw== IEZyZXF1ZW5jeQ== LGNoYXI= LldISVRF X3ByZXZpZXc= KSc7Cg== X2F4 SU9OUw== LmNwdQ== LmlucHV0cw== VUJF X2ZlZWQ= IFN1cHBsZW1lbnQ= ISku ZXN1cw== IFVEUA== IG1pY3JvcGhvbmU= IGNvbmZpcm1z LmlzTm90RW1wdHk= IjoiIiwK X1NDUkVFTg== CWV4cGVjdGVk Ky0rLSstKy0= IEhhaXQ= ZmFzdGNhbGw= IGRlcGljdA== dmI= X3BpY3R1cmU= CWRlc2NyaXB0aW9u IFdpZmU= dWNp IHZpY2lvdXM= 5LuW dWViYQ== IHNldFVzZXI= 44Gh IGRpdmluZw== IG9wZXJh dXNlcmNvbnRlbnQ= YXJhaA== KX0s eXVu dmVsdA== IHVuY292ZXJlZA== IGhpcHM= IG9zY2lsbA== IGFzc2VydGluZw== IFhp LnJlc3RvcmU= a2Vh IHNwZWxsaW5n IGRlcml2ZQ== YWJ3ZQ== IERvdw== LnNldFR5cGU= X3Zz IGNvenk= LmNhdGVnb3JpZXM= T3Jn X21ncg== IGR1bmdlb24= Y29sbGVjdGlvblZpZXc= IEJsYW5r YWNpYXM= w6TDpA== X2NsZWFudXA= X0FDVElWSVRZ IHRyaWFuZ2xlcw== Lk1lbnVJdGVt IGlwaG9uZQ== IFdvbg== XV0KCg== IENvbXBhcmlzb24= LkRvYw== IGNhbm9uaWNhbA== IFN1ZGFu Jyl7 VXBJbnNpZGU= YnVpbHRpbg== RU5DWQ== eGJl IGNodWNr IGNvbnRyYWRpY3Q= IG51ZXN0cm8= IGFyY2hpdGVjdHVyYWw= IEZpYg== IGNvbXBhcmVz Kms= Q2Zn 54Sh bnRlbg== TWF0Y2hlcw== IERPV05MT0FE X0hBTkRMRVI= bWFuYWdlbWVudA== W1M= RU5H woDC ZmFuZw== IHNsaXBwZWQ= IExhbmth ZXNjYXBpbmc= IHRhY2tsZXM= IFBlZHJv LlByb3A= Licn LkdlbmVyYXRlZA== Lk5ld0d1aWQ= YXRyaWdlc2ltYWw= aWxsb24= IHN0YXRpc3RpYw== c3BlY2llcw== aG9sZGluZw== RHJ1cGFs IGZ1bmRhbWVudGFsbHk= IGJvbmRhZ2U= IHJlc29sdXRpb25z SW5saW5lRGF0YQ== XFR5cGU= ZXN0aW9u LndyYXA= IHdhcnJpb3Jz IExPQ0FM QXJjaGl2ZQ== IGVtYnJhY2Vk 4bun LlZlcg== IEFmZm9yZGFibGU= b2xlc2FsZQ== IEFwcGxpZWQ= IENvbnZlcnNpb24= bWVnYQ== X2NhbQ== IGNlcmVtb24= YXVydXM= IFZvbGs= Lm9wZW5z L2Fib3V0 IFN0ZA== am91cm5hbA== KCkpew0K LCJc KEFycmF5cw== IERlbnNl YXNlw7Fh w6RubmVy L3N0YXQ= dXNlckRhdGE= IGdlcm1hbg== IHR6 d29ydGh5 Rm9ybWF0RXhjZXB0aW9u cGhlcmQ= IHNtaWxlcw== IFdoZW5ldmVy KGFkYXB0ZXI= LmJhZGxvZ2lj IGJyaWVmaW5n LkdyaWRDb2x1bW4= LWNoYXI= ZGltZW5zaW9u IENvcHBlcg== IG5pbnRo ICd7ew== IHJhdg== X1RhYmxl IGRlcml2YXRpdmVz IFJhaXNl IEZ1dA== YXJtb3I= LXBhZGRpbmc= IHJlbWlu CXN0eWxl IE1lbWJlcnNoaXA= IHNwcmVhZHM= IGdhbGxlcmllcw== IENsYXJrZQ== IGNvbmNlcHRpb24= bWludXRl IGFidXNpdmU= X2Fkag== IHRlcnJpZmlj IG92ZXJ0 b3VyY2luZw== IGVudHJhZGE= bGV2ZWxz IGNyaXRpcXVl IHJlc3BlY3Rz IE1NQQ== aWVuZQ== IGVuY2Fwcw== IFJheW1vbmQ= RGl2aWRlcg== aXZhYmxl YmF6 IEBfOwo= IENsYWlyZQ== IHVyZ2luZw== Q0VF IHRyYW5zZm9ybWVy ZGlzY29yZA== IEpvdXJuZXk= dG9z IGNvbXBldGl0aW9ucw== IE9CSg== IEJpcw== IHJlbGF4YXRpb24= aWR5 X0lOU1RBTkNF IFByZWY= ZGFkb3M= aWNpZW5jaWVz IE1lZGlhUXVlcnk= IEN1YmU= IFN0cmFuZ2U= Z3B1 KGRheXM= X0luaXRTdHJ1Y3Q= IGZpbmdlcnByaW50 ZW1hdA== IEdlY2tv IHJhaWxz IEx1bQ== c3RyYWN0aW9u aWd1bmc= KG1vdmll X2RpY3Rpb25hcnk= X2ludGVycnVwdA== IFFD aWtlZA== YXBwZW5kQ2hpbGQ= cmVjaXBpZW50 csOp VmU= IHRvd2Vs Lmxhc3RJbmRleE9m IHBsYWNlYm8= IFdpZQ== LmVzcA== KERlYnVn b3BlcmF0aXZl IGRlY2Vhc2Vk Jmlk CW11dGV4 ZWxpYw== IGJhcHQ= CQ0KDQo= IGZhcnRoZXI= SGFsZg== LmRpc2FibGU= Lm1lbnVTdHJpcA== bGVjY2lvbg== IHJlc3VsdENvZGU= IGNhbnM= LWVsZWN0aW9u ZmVtYWxl X0ZJWA== YXVzaWJsZQ== IFBPV0VS IHJlY29uc3RydWN0aW9u IHNjYW5z Llh0cmFCYXJz 4oCYcw== UmVtb3ZlZA== IHBhcmFncmFwaHM= X21hcmdpbg== IGx5bXBo IGJvcw== bGluZ3Rvbg== IEJhcHRpc3Q= IGFkdmVydGlzZW1lbnRz IE1hbmFnZQ== L3l5eXk= SU9VUw== RU5DRVM= IEZpY3Rpb24= CW1lbnU= IEZpbGVPdXRwdXRTdHJlYW0= b3Zhbg== IEZlbmc= IHNraXBwaW5n Z2V0Q2xhc3M= YW5uaQ== IHJlYm91bmRz IHB1YmxpY2l0eQ== IGluZ3Jlcw== dXNlbWVudA== IHRob3VnaHRmdWw= LkNoYXJ0 IGhhdHRl cGFzc3BvcnQ= IGhvb2tlZA== IExlbnM= IGZsYWdzaGlw IHN0aXA= IEdFTg== IGNsdWVz aXB2 IFJpc2U= IEdldw== dGFibGVuYW1l IGZvcmVtb3N0 X3ZhbGlkYXRl X2FuYWx5c2lz b2xsYQ== IHF1YWxpZmljYXRpb25z IGRpc3RyaWJ1dGlvbnM= IEZsb3dlcg== IHRlbnNl IHRoYW5rZnVs IGNsdXRjaA== IHVuaWZpZWQ= cm9hZHM= IHNpdGk= IHN0YWxs X1BSSU9SSVRZ Y3N0ZGxpYg== X1VTRVJOQU1F LmJ5dGVz P3BhZ2U= ZXJtYWxpbms= IFZlZ2V0 L3ZuZA== LWF1dGhvcg== Lk5PTkU= IENvbmN1cnJlbnQ= IENyeQ== IHN0YXJ0ZXJz IEludGVyYWN0aW9u ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IExFVkVM RWxs IGNvbWJvQm94 IFRoZXJlc2E= dGVr X0hhbmRsZQ== IGFieQ== LmdkeA== LGVuZA== KExvY2Fs T2w= a25pZmU= YXJpYWw= IEhvZmY= IHByb3N0aXR1ZXJhZGU= RG9jdG9y SW5zdGFuY2Vz LlNldFZhbHVl CWZyb20= IGx1eHVyaW91cw== SW5kZW50 QWxsb2NhdG9y X0RSQVc= KCIsIiw= IEZyYW5jZXM= IGdyb3VwQm94 KHNjaGVtYQ== UHJpbnRm T1JJRVM= LWdyYWRpZW50 IHJlcHV0 YXJpbg== X0RPTkU= aW5jcmU= aWdudHk= IGV4ZXJ0 IC0u L0FwcA== LXRocm91Z2g= IGRlY2xpbmluZw== IGRlc3NlcnQ= IGluY3VtYg== IGRlc2lnbmF0aW9u LlBPUlQ= LHN0cm9uZw== IHNhbmRib3g= IHdpbmVz IFBhdg== JHN0cg== YXNrZWxs IGjDtg== IFBZ R2V0SW5zdGFuY2U= VGV4dElucHV0 Z2FtZU9iamVjdA== L2V2ZW50cw== Y3JlYXRlZEF0 IGxvY2FsVmFy IFdISVRF cGVyZWQ= aWxlZ2U= ZWZmaWNpZW50 LGNvbG9y Y2F0ZQ== IENhZmU= IHNpbWlsYXJpdGllcw== IHB1bXBz IEh1bmdhcnk= LlVzZXJuYW1l IHNrYXRl IHRvdWNoZG93bnM= IGFjY2VsZXJhdGU= IEhlbGVu T01FTQ== IEt1bg== X3ZvbA== IGZpbmRBbGw= IE1lbnNjaGVu YWhlYWQ= KTsi a29tbWVu IHBvc3Nlc3NlZA== LmFyZ21heA== LnRyYW5zaXRpb24= QVJQ T0xVTUU= KHNjcmlwdA== INCY IEZpbmRpbmc= b25jZXM= SW8= Qm9sZA== IHJlbmV3YWw= X0RJQUxPRw== IGRpc3JlZw== SU5URVJO IHRvdXRl IGVsZWN0cg== IEdyb3Nz CXRydWU= LkZpZWxkcw== IFdJRFRI IERlbnQ= IMOB TlNOb3RpZmljYXRpb24= IGFvcw== IG1lbGVl LlZhbGlkYXRpb24= IERFQw== LWRlcGVuZGVudA== IHN1aWM= VHJhaXRz JG1lc3NhZ2U= IERlYXI= CUZJTEU= bGFuZ3VhZ2Vz LlByb3Q= LmFkZHI= LWdlbmVyYXRpb24= SUNPTg== IHRyYW5zcGxhbnQ= LWRlc2NyaXB0aW9u IGNoYXNpbmc= IGNoZWVz IH0qLwo= VHJhZA== cXVlcmllcw== L3dpZGdldHM= c3VicGFja2FnZQ== IGVzcGVj IGNyYWNrZWQ= IGNvbXBldGl0b3I= UHVyY2hhc2U= LXRlYW0= b2xlY3VsYXI= b3JUaHVuaw== JlA= IHJlbGVudA== LyN7 IHByb2R1Y3RJZA== IOi+ IExhdg== IEFsdGVy Lk1vZGU= QURJTw== Z3Jw 5re75Yqg UXVpdA== IGRlcHRocw== LWNhdGVnb3J5 IERBVEFCQVNF U1BFTEw= IEZhbGNvbg== IFFTdHJpbmdMaXN0 ICcnLg== IEluc3RpdHV0aW9u ZGFtYWdl YXpvcg== YmVsb25nc1Rv dmVyYWdlcw== IE5PTkU= aXBwZXRz LFwK IGZvb3RwcmludA== X2FyY2hpdmU= bmFr LmdldEZpZWxk IFJlZmxlY3Rpb24= ICdd IEhCTw== X2Rpc2NvdW50 IGluY2VzdA== IERvZGdl IFdhZGU= Lk5P ImVuY29kaW5n IEJsb2NrY2hhaW4= IGxhd3N1aXRz IE1haW50 Y2h0ZW4= IMOpdGFpdA== IGt0w7NyZQ== X2N0bA== KHRpbWVy QmF0dGxl aXpv YXllZA== SU9S IEdsYXNnb3c= IHN5bnRo X2xvZ3M= LnBvc2U= X0FkanVzdG9yVGh1bms= KCgm IHVuc3VyZQ== eXN0YXRl 7ZWY64qU T1VMRA== Lm5n IGRlZmF1bHRkaWN0 d29ya3NwYWNl IHNlbGVjdGl2ZQ== UGlja2VyQ29udHJvbGxlcg== WU5BTUlD Lm1ldGhvZHM= IHBhdGh3YXlz IEZldw== S0c= Q1JZUFQ= Zm9sbG93aW5n IERMQw== IFNhcmE= IHByZXNldA== ZXN0cnVjdG9y IEt1cnQ= IGFpcnBsYW5l IG9tcA== IFBhcmVudHM= IE1hcnRpbmV6 LmNvbXBsZXRl IGJyb2FkbHk= IHNjYXJl IE3DqQ== IGVsaW1pbmF0aW9u IHBvdXJlZA== L3N3 IGNvbXVu IG1hc2M= IE9yZ2FuaWM= IFN0cmluZ1V0aWxz aWxhdGVyYWw= IHJlbHVjdGFudA== LWFnZQ== IG56 LiJc IHBhc3Rvcg== YWxleg== IGVmZWN0 cHJvdg== L2luaXQ= IHBlbm4= dW5kcw== IHNzaXpl IFByb2o= YmFzZW5hbWU= IHNoZWxscw== IE5lY2s= IEVuZm9yY2VtZW50 dmlkZWQ= c3Rvd24= U3BoZXJl JHI= dXNzZW4= YWZpbA== IFRlbGVncmFt IGFuYWx5dGljYWw= 0L3Ri9C1 dXN1YWxseQ== eG4= IGhpc3Rvcmlhbg== IEdyZWdvcnk= b2xwaA== IFVuYQ== IGNvbnRyaWJ1dGVz JS0= YW50aWFnbw== 0YDQtdC0 LnJlZ2lvbg== IGFicnVwdA== IFVuc3VwcG9ydGVkT3BlcmF0aW9uRXhjZXB0aW9u IFRBU0s= X2ZpbmlzaA== IG5vdG9yaW91cw== IFZz IE1R IHN1bnNldA== IHVuYWNjZXB0YWJsZQ== YXJjZXI= IGlsbHVtaW4= IE9yYg== IGJo RXN0ZQ== X2Rpc3BhdGNo IHJpcHBlZA== IHRvdWpvdXJz IFBhcmNlbA== X2xs LnVzZXJOYW1l LmNsYXNzZXM= U09VUkNF KE51bWJlcg== 0LXQu9GP IGhlYWRwaG9uZXM= KHNpZGU= Y29uc3RpdHV0aW9u YW5uYWg= DQogICAgICAgIA0K IGNsaWZm LXJlZg== IG1vc3RyYXI= IFBvd2VsbA== K3k= IEJH X2ZyYWdtZW50 LlBvcnQ= IHJlYWxpemluZw== cGFyYW1yZWY= IGhvbWV0b3du QFRhYmxl KyI8Lw== b21pZA== IGR1Zw== CWJ0bg== IHN1YmplY3RpdmU= L2Jyb3dzZXI= IHVzaG9ydA== IE1vbnRnb21lcnk= LXJhdGU= CXB1dHM= bGV0aWNz b3Jucw== 4oCcV2hhdA== ZWVwZXI= LkludmFyaWFudA== IGNvbmNlYWxlZA== X251bXB5 PT09PT09PT09 KHBz TG9jYXRpb25z LmFzdHlwZQ== IENIQU5HRQ== Lk9yZGVyQnk= O2hlaWdodA== IGdlbnRl IGdydW50 IFBsYW5l IHNhZGx5 IExvZ2Fu X3VzZWM= LmRndg== IHNpbmNlcg== IHBu CWd0aw== IGluc3RhbGxlcg== IGRpc3BsYWNlbWVudA== IGJ1cm5z 0YPRgQ== aXZlcmVk Ol0pCg== c2VhdA== YW5pbmc= fSkKCgo= X3JvbGVz YXRpY2Fu IGdlbmVyYXRvcnM= IGh1cnRz IHNuaXBwZXQ= IGdzb24= IHNlZ3JlZw== IGRpc3RyaWJ1dG9y IGFkdmFuY2luZw== cG9zdGdyZXM= IHVzcg== IExpcw== LmFzc2VydElz X2Nk IGh5ZHJhdWxpYw== LmNvdW50ZXI= IEluZGVwZW5kZW5jZQ== IGRpZmbDqQ== VW5saWtl IHRvbWI= dmlr cG9zdGVk d2Y= IGRlc2NlbmRpbmc= ZHlu YW1lbnRhbA== IEZydWl0 IFlv LmRvdWJsZQ== IElB aWV2 aWJyYXRl IFJlbGlnaW9u TWFueVRvT25l LVRh IGJhbmFuYQ== IEF2ZW5nZXJz IEhvbG9jYXVzdA== IGdldEM= IGNvbmRv IEdvdGhpYw== IHByb3NwZXJpdHk= VFJBTlM= IGRvZXNudA== IENoYW9z SVRU IENVUlJFTlQ= XGhlbHBlcnM= X1NBVkU= YXZpdA== Y29tcHV0ZXI= X3NoZWV0 IEJyZXdpbmc= IHJvYmJlcnk= IOqyvQ== INC60L7QvA== IG7DpA== LnJlZ2V4 IGRpc3J1cHRpb24= IFNpbXVsYXRpb24= YXBpZA== IHN1cHJlbWU= zrw= IGNvbW1pc3Npb25lZA== IGFic29ycHRpb24= IE5ld2Nhc3RsZQ== CWNvbnN0cnVjdG9y VGVybXM= IHJpdg== IHJlbGlnaW9ucw== V2l0aFRhZw== Lkh0bWw= bGlua2Vk Q29tcG91bmQ= IE1hbnM= IGxha2Vz aXp6bGU= LnNldFNpemU= YWJlcg== IE5lZWRz cGFja2FnZXM= LlRhYlBhZ2U= IHJlZnM= IGlvdXRpbA== IERvaW5n ICJcKA== IHBoZW5vbWVuYQ== LkdldEludA== QUxUSA== IHBhcmxpYW1lbnRhcnk= IHJlZnVzYWw= IGluZXhwZW5zaXZl IH0KCgoKCg== IHNvbGlkYXJpdHk= CXB1c2g= aGF1bA== IEJlcmU= U2l6ZXI= SW5kaXZpZHVhbA== IGFuY2U= IGRpbGU= IFBlYWs= KGhy RWRpdGluZ0NvbnRyb2xsZXI= SE4= X1BFUklPRA== RVRT QmFubmVy ZXJyb3JNZXNzYWdl LkNBU0NBREU= LWlnbm9yZQ== IFNJR04= IE9C X2Rk KERFRkFVTFQ= IHNvbw== IFZpY3Rvcmlhbg== IGN1cnQ= IGRpc2NyZXRl cnlsaWM= aW1iYWJ3ZQ== LnRvRml4ZWQ= bMOk LnN0ZGlu IHF0eQ== Uk9MTEVS bWVkaWF0ZWx5 IHBsdW1iaW5n IFByb3BlcnR5Q2hhbmdlZA== YXJyYW50eQ== IEJyZWFrZmFzdA== LnNldEhlYWRlcg== LnB5dGhvbg== Y29tbWVyY2U= b3BlbmN2 Pi0tfX0K RnJlbmNo RW50aXR5TWFuYWdlcg== IFBsYWlu Ly8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8vLy8= wrM= KFJF Y2FwdA== IG9yZ2FuaXNtcw== IGpldHM= b2xvY2F0aW9u IEFwcFJvdXRpbmdNb2R1bGU= IGdsb3Jpb3Vz 5pyN IGRpc2NhcmRlZA== CQkJCSAgICAg IEFybm9sZA== bHVn IHBhcmw= IGhvcm1vbmVz IG1haA== IFNvbmlj IG9yZ2FuaXplcnM= X1BMQVRGT1JN Lmludg== IGNob3Jk dmVudGlvbmFs CW9m RXBpc29kZQ== LkVudW0= dW5rdA== IERo IEphcmVk IE5haw== IGludGVuZHM= RW5kaWFu IGF1c3RyYWxpYQ== X2N2 KHJlc29sdmU= IGNsaW5pY3M= bGlrZWQ= QVNISU5HVE9O aW5oYQ== Jyo= IE5Q X2JlaA== IGhm IHfDvHI= Y2F0ZWdvcmlh JGZvcm0= IHN1YndheQ== IGlzQWN0aXZl cG9wdWxhcg== Q291cg== IGNvb2xkb3du IGFpbnNp IEdMdWludA== ZXJlYWw= IGFycmF5T2Y= IGhhdGNo PT09PT09PT09PQ== cmVzc2Vz X1BQ Ll4= X2RlY2F5 IEJsZXNz bWV0cmljcw== IENPUFlJTkc= IER1bXBzdGVy IEpvc8Op IERlc2lnbnM= PFZvaWQ= 57q/ ID8+PA== ICJ9Cg== dGltZXpvbmU= IGVlcg== bWF4Y2Ru IEVTQw== aWdhcmV0 X2Nvbm5lY3RlZA== X3JldmVyc2U= IHF1ZXN0aW9uYWJsZQ== IFVTQw== IHR1dHRp IGRyb3BvdXQ= IEFjdGl2aXRpZXM= IFdpbmRz JykpKTsK IGNvbmdlc3Q= xJ/EsQ== IHByb2xvbmdlZA== 6L+Z IENyb3NzQXhpc0FsaWdubWVudA== TEVFUA== IFZBTElE IEdheg== IGRlcGVuZGVuY2U= IFByaXg= LkNvbXBpbGVyU2VydmljZXM= anVtcA== IHN0cmF0 Y2lyYw== IENVU1RPTQ== eGFh IGJtcA== IGJ1cmVhdQ== IHdhcmVu Tlg= KFdpbmRvdw== IENocmlzdGll X0ZF IHRu IE9tZWdh Y29tbXVuaWNhdGlvbnM= SG9tZVBhZ2U= Y29tcGxldGlvbg== IHN1cHBseWluZw== WVBFUw== w6F2ZWw= 5Yi2 KGNsaWNr XENvbnRyYWN0cw== L3F1ZXN0aW9ucw== IGV6 QU1T Lm1lc2g= ICc8Pw== asOg SW5p LiM= IENhcmRpbmFscw== cGNpw7Nu Q3ViZQ== IFBhdGllbnRz X3ByZWY= QWN0aW9uQnV0dG9u KGJ1aWxk IFZpc2E= b3ZlbA== KEFycmF5TGlzdA== SWdu IHJlaGFiaWxpdGF0aW9u IHBhbGFjZQ== IHNwZWVjaGVz fScK SHR0cFJlc3BvbnNl CWNvZGU= RHVtbXk= IGFjYWRlbXk= Lm1vdmll IGluY29ycmVjdGx5 IGN5Yw== KFVuaXR5RW5naW5l CWNhbGxiYWNr IFNhdGFu IEZVTkM= IGNoYW50 IEhlYWx0aHk= OicsCg== U2hpcHBpbmc= X21j IER5bGFu IFByb2R1Y2Vy IHJlc3B1ZXN0YQ== IHBvbGlzaGVk QnJvYWRjYXN0 IGJhbGFuY2luZw== IFNsaWRl IENhcHM= c3RpbGw= IGhhcHBpZXI= IEdvc3BlbA== dHJhbg== LnBhdGhuYW1l QWN0aXZlU2hlZXQ= IENoYW5n PlwK Um9ib3Q= SnNvbk9iamVjdA== IERG IFByb2Nlc3Nvcg== X3Nob3VsZA== LnByb3RvYnVm LXVzZXJz IGVtYnJ5 Rk9OVA== IHN0YXJ0dXBz IERhdGFTb3VyY2U= KSM= dXJvcw== X0NvbG9y IHN0YW5kYWxvbmU= fVs= amQ= IGZvcmdpdmU= IG5neA== IEdlbmVyYWxseQ== IGNvbmZpZ3VyYWJsZQ== L29yZGVy IHZhcw== JykiOwo= IFJS IFRyb3k= IGNvbXByb21pc2Vk IFN3YW4= aW50ZW5kZW50 Q2VudHJhbA== X2tlZXBlcg== IGFycXVpdm8= IFJlYWRPbmx5 X2N1cnZl a3Y= ZW50aW4= 6LE= IEV5 LmltcmVhZA== IFBhbQ== aWZmZQ== YXRpdml0eQ== eGJj IGdyaW0= LWZpbGxlZA== bmFtZXNl J106 IGF1cg== IEdpYnNvbg== Lk1vdXNlRXZlbnQ= IGxhZG8= YXZhZG9j IGZhbWls IE1vZGVy ZnBz 44CA44CA LWV4YW1wbGU= IEFsemhlaW1lcg== IFV0Zg== X2FyZ3VtZW50cw== Q29uY2x1c2lvbg== dGV4dENvbnRlbnQ= cmVtYWluaW5n IGludGVycnVwdHM= IEJhY2t1cA== IE1vbmc= IHJlY2VwdG9ycw== aGlzdG9y LmNvcm91dGluZXM= IHNob3V0ZWQ= QWxhcm0= IGNvbWJ1c3Q= IGdyb3Rl dWx0dXJhbA== KGlkcw== LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= aXBsaW5hcnk= T3B0cw== IFlhbGU= bG9jYWxTdG9yYWdl IGVxdWl2YWw= IEZsZWV0 XGI= KnBp IFFMYWJlbA== 5qE= IHZ4 IEFDTA== IHN1Y2Vzc28= IHBlcmM= IE5vdHJl IGFuYXJjaA== UmluZw== c3Bi IHN0cnBvcw== c3RvcmVz IE1hcGxl KE1haW5BY3Rpdml0eQ== KCIiKSk= IHZpZXdIb2xkZXI= UXVhZA== IGlndWFs b3JzY2hl Lm1hcmdpbg== IGluZGll IGZyYW5j IEZvcm1CdWlsZGVy IFBhcnRpY2lw LmZsYXNo IHN0b3Jtcw== VWx0 IGZlbg== W25ldw== RXZlcg== PSIK IGxvY2FsaXplZA== X2ZvbGxvdw== IG5hdmU= IGRvbWluYW5jZQ== KHRpbGU= Sm91cm5hbA== IFZD IHBlbmV0cmF0aW9u 77yV IGNvbXBhcnRtZW50 IGJpZHM= Rm9ybWF0dGVk KioqKioqLwoK KGNpdHk= 4oCUaXQ= W0M= IHVzZUNhbGxiYWNr YXVi KT8u IFZBUg== IFNlYmFzdGlhbg== IE1vc3M= IGFidW5kYW50 R3JlZw== 0YLQsA== X2Np IGJpYmxp Q1JN IEF0dGVtcHQ= aXNtZQ== ZGFzaA== 44CO X211 LkZvcm1hdHRpbmdFbmFibGVk SW5kZWVk LWRpcmVjdA== IHN1Y2tpbmc= IHBuZQ== b2NhYnVsYXJ5 IFBhY2tlcnM= Lk5hdmlnYXRpb24= IHBpZWQ= Y3JpYmluZw== IFN0dWFydA== LlRvRG91Ymxl IFNlY29uZGFyeQ== U2F2aW5n IER1dA== IE1hZGQ= TWFnaWM= LEg= LmRvY3VtZW50RWxlbWVudA== IEJTVA== IGRpZmZlcnM= IG1vcmVvdmVy X25k U0VBUkNI 0L/RgNCw0LI= 5rQ= dG9NYXRjaA== IGRlY3JlYXNpbmc= LW1lbWJlcg== YW1wdXM= KGJvb3N0 RGFpbHk= RGF0YUdyaWRWaWV3 IEh0dHBDb250ZXh0 IGhpcHA= X3dvcmtlcnM= LWxhbmd1YWdl 6ZM= IGNvbnNpc3RlZA== YXRoaW5n IE1lcmN1cnk= JGNvbnRlbnQ= IHByYWN0aWNlZA== IE1vZHVsZXM= X0RBWQ== IHdlYWtuZXNzZXM= IExvZGdl IG5hcg== IE1hdGU= IGpw IEh0dHBIZWFkZXJz IHNtbw== IFRPS0VO XSko IGFxdWk= c3dhZ2Vu IHNydg== CWFucw== QXJvdW5k IE1hbnVlbA== IGZpY3Rpb25hbA== IElNRw== IC4n IEJlcnJ5 IHdhbGxwYXBlcg== c2V4dWFs aWVybw== IOeahA== 7IaM QmFja2luZ0ZpZWxk IEFkcmlhbg== QkFTRVBBVEg= IHJlcGVhdHM= IGJsdWVz IHVucHJlZGljdA== X2NvbGw= c3RhY2xl IFR1bWJscg== IEVsZg== IGFzc3VyYW5jZQ== IGNlbnN1cw== IElNUE9SVA== RU5ERVI= YW5vcw== ID0o IEVsbGlz IgoKCgo= Lndpbg== IEFib3Zl YWxvbg== X3RpY2s= IHJlcHJlc2VudGF0aW9ucw== IOaV d2lk IEFybXM= TGlzdGE= X2ZhaWx1cmU= X2Nt LkZsYXRBcHBlYXJhbmNl IHRocm9uZQ== UGF0Y2g= IFZveQ== ZW5nbA== IG5lZ290aWF0aW5n PmA= IHNob290cw== IEZQUw== LlllYXI= IEtpc3M= ZW5jacOzbg== cmVldGluZw== RnJvbUZpbGU= IHJlc2lnbmF0aW9u 2Lc= IHR3aW5z xrDhu6M= IGdlYnJ1 LmdldENvbnRlbnQ= LlRyZWU= IEVtcGxveWVlcw== IEZJRkE= IGNlcnRhaW50eQ== KENs IHRvdGFscw== ZWRpdGFibGU= 4KWA LlJlcG9ydGluZw== TWFz cXVpZXQ= LnJ1bGVz IFZP Y29uZXhpb24= LEs= IGFsbG9jYXRvcg== IFBvd2Rlcg== XFJlcG9zaXRvcnk= QmVhdA== X3RpcG8= IFsnJyw= X0lOVFI= IDw8PA== PGhy Iik9PQ== dWdnYWdl IENyYXc= IMOpZ2FsZW1lbnQ= IGdpbmdlcg== IHByaW1lcmE= IHByb2R1dG8= bHRr LlVzZXJOYW1l IHN0cmVycm9y bWl0aA== X25i IGRpc2NvbWZvcnQ= J107Pz48Lw== UVQ= IGVydXB0 IERhbmlzaA== XEFjdGl2ZQ== X2FkYXB0ZXI= IGJ1YmJsZXM= cm9sbG8= b3Jnb3Q= 0L3Ri9GF VkVDVE9S b2NvZGU= IEJ1bGxz IGJvaWw= PiIpOw0K ZHJvcElmRXhpc3Rz IEJlZw== X0hBTA== IGNyb3NzQXhpc0FsaWdubWVudA== IEV2aWRlbmNl IHBlY3VsaWFy IGluc3RpdHV0ZQ== dmVpcw== IGZmdA== w4E= IHpvZWt0 YW5hbHk= IEhvbWVsYW5k IHBlbmV0cg== dWRkZW5seQ== CWVsZW1lbnQ= IEJyZW4= IFRydWRlYXU= IEN1YmFu amFt dXNsaW0= X2V2 IHN0ZW1z fSU= neWniw== IGJyYW5kaW5n IGNvcnJlc3BvbmRlbmNl LmpxdWVyeQ== ouWNlQ== IFJlYWRz KEh0dHBTdGF0dXNDb2Rl YXNzaW4= KHNsb3Q= IEdyYWR1YXRl Ly8vPA== IGluZm9ybWF0aW9ucw== RU5BQkxF IHB1aXM= IGZpbmRlcg== IEJyaXM= IG5ldHRzdGVkZXI= X21pZA== IG9ncw== IFN0ZXJsaW5n IGFycm9n c3RyZnRpbWU= fAoK IHZveA== IFJlZ2FyZGxlc3M= IGVzbw== IENvbWZvcnQ= LkJvb2xlYW5GaWVsZA== IHVo QUNZ IHNxdWVleg== IFZpYw== Y29udHJv Lmxv IGlyZQ== IENvbWVkeQ== 67Y= IG9yaWdpbmF0ZWQ= IHNoaXBtZW50 fG1heA== X2d1aWQ= bGV2YXRpb24= 0L3QsNGP KHVuZGVmaW5lZA== IEREUg== IHNob290aW5ncw== IExhdGlubw== RU5ET1I= IGF2ZXJhZ2luZw== IGdyZWV0ZWQ= IHRoZWF0ZXJz 0L7QtQ== IGRC IGdzdA== IGRlZmluaXRl LlN0b3JhZ2U= Lmhlcg== IGFmb3Jl IFJlYWxpdHk= IEdvZHM= dmVyc2Vk IGhhbmRzb21l IGV4Y2x1ZGluZw== KGFk UXVvdGVz IFNjaGVtZQ== P3E= IFRhbWls VGlja3M= IHBlc3Q= J24= IHBvcm5vZ3JhcGh5 X21vZGFs IC0tLS0tLS0tLS0= IGRpc3Bvc2FibGU= RlJFRQ== IHNoYXJr Q0hF IGRlcGljdGVk IGRlbW9uc3RyYXRpb25z IEtpbGxlZA== IFJVTEU= IG9ic2Vzc2Vk IHNpbXBsaWZpZWQ= UG9zdGFs IGNvbmNlcHR1YWw= IHBzdA== TGFz X1BST0pFQ1Q= dWNjZWVkZWQ= b2x1 xJ9p IHBlcnNvbmFsaXRpZXM= IHJlc2hhcGU= IGVuY2xvc2Vk CXB0cg== IHR1dG9yaWFscw== IGV4cGxvZGVk X0RJUkVDVE9SWQ== 5YaF5a65 IGNhbm9u IHJlY29nbmlzZQ== UEFE IEFwcHJveA== IFJlc3RvcmU= IEltcG9ydGFudA== IGhlYXZpZXI= LlNlcXVlbnRpYWw= RWFydGg= IE1pbGs= LnNldFJlcXVlc3Q= LnRlbQ== IHJlY29uc3RydWN0 IHNrZXB0aWNhbA== X1ByaXZhdGU= QlVG cXVh OmE= IHNlaw== IGR3ZWxs b3NzYQ== IHJld2FyZGVk 0LjQuQ== KHRvcGlj X3BhcnRpdGlvbg== IF9fX19fX19fX19fX19fX19fXw== S2V5d29yZHM= IEZyYW5jbw== TGl0ZQ== IG5ha2Vu INC30LA= T0JKRUNU IGNyYWZ0cw== IFN3YXA= LlhuYQ== LkNvbm5lY3Q= IGJhbGNvbnk= KHJlYWw= IEJhcm5lcw== Ymly IFR3ZW50eQ== YXlhbg== YXRhcnM= IFByb3BlbA== IElobmVu VXBncmFkZQ== IGN1cmI= LXNlY29uZA== IG5lcGg= LnByZXM= 7J6F LnNlcQ== IHBhZGRlZA== Ij8= amw= 44Os Jyk8Lw== IGNpdmlj Z29ucw== PmE= Q29vcmRpbmF0ZXM= IGVuYWN0ZWQ= RU5UUw== IGxhYw== LmZpbmFs IFBocFN0b3Jt Y2FsbGVk IGlucXVpcmllcw== Lm1pZGRsZXdhcmU= IERvd250b3du Lyc7Cg== IGtpbG9tZXQ= YWNjZWw= IHF1aWVu d3N0cmluZw== c2V0RGF0YQ== IG1hbmVyYQ== IG1vZHVsYXI= cmltcA== IHRhcmlmZnM= 4oCZaWw= X1RIUk9X L2NvbG9y IEhUTUxFbGVtZW50 IGNhcnJv IHByZXJl IHBsb3R0aW5n IFBvc2l0aXZl IE1hY2hpbmVz T1RFUw== 4bub cGxlYXNhbnQ= IGFsdGU= IGFpbmRh dGhlc2U= IGNvcnM= aXBheQ== IEFkdmlzb3J5 IFJ1Ymlv anE= IGxpbWVzdG9uZQ== IGRldGFjaGVk 6K6+572u dGVuYW50 IERlcHRo YWxvcmU= INGB0YLRgNC+0Lo= IEZPUkU= IExheQ== cHJlc2VudGF0aW9u KScpOwo= LnN1YnBsb3Rz z4M= Tk9X R2Fy aGFuZGxlcw== YWJyYQ== cHV0aWVz IEVsZWN0cmljYWw= TWlkZGxl cm9waWM= IEpE IER5bg== IEJyaXN0b2w= IE1jQ2FydGh5 IHN0cmlrZXI= IGVudW1lcmFibGU= IEV2YW4= LmRlZmF1bHRz cXVlbmNlcw== KXx8 CXRva2Vu 4peP LWRyb3Bkb3du U1RPUkU= IEdyYXBoaWM= KHBw RXhwbA== IHVwd2FyZHM= IERpc3RyaWJ1dGVk IFdFQg== SmVy aXNOYU4= 55Sf5oiQ PlI= w7xzc2Vu ZWZz IHVuY292ZXI= IGx1ZA== LmNhbGN1bGF0ZQ== IGludHB0cg== IG1pZGZpZWxkZXI= LkhlYWRlcnM= IG1m ZXJlZg== Lk1ldHJv IFNwZWFraW5n OmI= IGNyeXB0b2N1cnJlbmNpZXM= IGRlbW9ucw== CUVYUEVDVA== IHdpY2tlZA== eW91dHViZQ== OkludA== IEhpbmRp IENBVA== INi5 cmFy b21vcmU= L3Blcg== L2xpY2Vuc2U= IHJlaW0= IGF3YWl0aW5n IGxldGhhbA== IEVG cm91bmRlZA== IFBsYXRpbnVt INCy0YHQtQ== LmNvb3Jkcw== LkRldmljZQ== L2l0ZW0= IFdlbm4= Y29tcGlsZUNvbXBvbmVudHM= IEtpbmRlcg== LnJlbW92ZUl0ZW0= IGFuZGE= Ym5i IHByYQ== KHRyYW5zYWN0aW9u IGVtYmFycmFzc2luZw== CUJPT0w= LmNvbnRlbnRWaWV3 IGV2ZW50ZGF0YQ== YXRvcmU= IHByb3ZpZGVkSW4= aXJtYQ== IHpvbmE= X0hX 5pk= IHN0b3Zl IGNvdW50ZXJwYXJ0 X1Byb2R1Y3Q= X01BTkFHRVI= IGluZnJpbmc= IEVSQQ== X3BhcnR5 0ZE= IGluaWNp X1JlcXVlc3Q= IG1pcmFjbGU= IGNhbmNlbEJ1dHRvbg== U3B5 YXTDsw== IHBvbGlzaA== IE5pY29sZQ== LmRpc3BsYXlOYW1l XFJlcXVlc3Rz IHVzZUhpc3Rvcnk= Um91dGVyTW9kdWxl IHN0YXJlZA== SURFUg== 0YPQvdC60YbQuA== IG5vdGE= JGFycg== cGVjaWZpZWQ= IHRvcHA= X0RSSVZFUg== L25n 5aA= X3Rt JXRpbWVvdXQ= PHM= ICgqKQ== IEh0dHBSZXF1ZXN0 X1RSQUNL KG5vdGU= IEV4cGxvcmU= X3NlcnY= IOe7 QmluZGVy KyIs LmF0dA== IEV0aGk= IGPDs2RpZ28= PSdc LmxpbmVz KE9m 5bCG bWlzc2libGU= IHbDqQ== IGFjb3VzdGlj IGNyYWZ0aW5n bml0 LmJh IEx1Y3k= IGlQb2Q= IHB1cGlscw== LW1heA== X3dy KGNw IFJFUE9SVA== IGRucw== IFJlZmVyZW5jZXM= IHVuZGVydGFrZW4= IGvDuGJlbmhhdm4= IGNoYWk= IENyb2F0 X0xvZw== cm93bmVk X21lZA== CWRhdGU= I19f IGNvc3R1bWVz IFJlcXVpcmVz YWZmbGU= 54q25oCB LVNlbWl0 ZWxhaWRl 0LXRgtC+0LQ= IHBlc3RpYw== IGRyYQ== RE9DVU1FTlQ= IC4uLg0K fWB9Cg== IEF1Y3Rpb24= IERvY2s= eHh4eHh4eHg= KGdldFN0cmluZw== hY0= IGJvcmRlcldpZHRo IE1hY2hpbmVyeQ== IHByZWRpY3RhYmxl LlNI IGFtcGxpdHVkZQ== LmZvclJvb3Q= SU5hdmlnYXRpb24= VGFibGVNb2RlbA== YXR0cmli IG1hbmV1dmVy IGV4Y2F2 QkVSUw== IGRhcGF0 IGluc3RhbGxhdGlvbnM= LkFzeW5j IHJheXM= PeKAnQ== Ow0NCg== LmNyeXB0bw== X2RiZw== IEVudW1lcmFibGU= T2ZTaXpl X2Vwb2Nocw== bXc= TUVOVQ== b3V0bGluZQ== IFBhcGVycw== PT09PT09PT09PT09Cg== IHVuaWZvcm1z IEdpZw== LXBhY2thZ2U= IEplbmtpbnM= IEhvbWVQYWdl LmlzU2VsZWN0ZWQ= IG1lY2hhbmlj TUs= IFNvdW5kcw== Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQo= IHJlc2VhcmNoaW5n IGluZm9z b2dyYXBoaWNz ZXJzZXQ= KFsnLw== IFRpbWJlcg== LmFnZW50 LnRvSlNPTg== X2NvbW1hbmRz cGFyaW5n X2FkanVzdA== Lm5vbWU= KGdsbQ== U3RhdHVzQmFy ZmlsZXBhdGg= P+KAmQ== IGRldGVjdGl2ZQ== IHVuc2VyZXI= IFRpYmV0 RU5ERUQ= KHNlZWQ= IHNuZWFr IGFtb3I= PSIvLw== IFBhbnRoZXJz YWxsYXg= IExJVkU= CURXT1JE XT0t IHRvcm5hZG8= L21pbg== IGx1bmdz LWN1cnJlbnQ= IEJvb2tpbmc= 5YiX6KGo IGVuam95bWVudA== 4KSw SkE= dHlwZWQ= LkJ0bg== ZmF0 dWdhbA== IFNoYXJlcw== IGRpc2dy IEJBUg== IEZPWA== T3Bjb2Rl IFN6 a2V5ZG93bg== aWN0aW9uYXJpZXM= IGRldGFpbGluZw== fSkpCg== IHBvaw== IGRlbW9uc3RyYXRpbmc= IG5vdGF0aW9u bGF5ZXJz QGlm IE5QUg== LnN0cmljdEVxdWFs IFJlY2lwZXM= LlRlbnNvcg== IGxpcXVvcg== IGRlYnRz LmVuZHNXaXRo V2hlZWw= LlBvcw== Q1NW JGFyaXR5 IHVuc3RhYmxl KGxvc3M= RU5TT1I= IGVsZXZlbg== IExvcGV6 IEhvcGtpbnM= Y29ub20= IFNldGg= IHBvZW1z UXVhbnQ= IGdzbA== IHN5cnVw IHNpYmxpbmc= IGNhc3M= LXZvdXM= w7Z0 X1BBVFRFUk4= X1NFQ1RJT04= ZXN0aW1hdGVk dXBncmFkZQ== Lm1vbmdvZGI= IEJvYXQ= X0NUWA== IGZldGNoaW5n dXN0aW4= cGllbA== TWFyZw== UmVmbGVjdGlvbg== IGR1Y3Q= IE11bmljaXBhbA== IGJ4 LkdldEN1cnJlbnQ= bWxpbms= IEFjY291bnRpbmc= IEdlbmV2YQ== X1Bvcw== IHBhc3Nlcg== IGhlYXJpbmdz Y29tcGFu IGZyYWdpbGU= SW5pdGlhbGl6ZXI= d2Fsa2Vy Lk1hdGVyaWFs IEh1bnRpbmc= dHJ5c2lkZQ== IGthdA== IGNsZXJr 4Z8= ZG9pbmc= CWdyb3Vw IHNhbmN0aW9u Lmxi IExhenk= IENvbnN0cmFpbnQ= UGFnaW5hdGlvbg== IHBvdXZleg== IEluZGljYXRlcw== TUVS IGNvdXJz IHllYXJseQ== IGdyb3NzZQ== YWJicmV2 IERPTg== IHByb2NlZWRlZA== ZW50bGljaA== IHByb3BlcnR5TmFtZQ== IFRlYWNoaW5n c3RhZHQ= IGN1dG9mZg== b3JuZXJz IGFmcmljYQ== IHJlbmRlcnM= IFlhbmtlZXM= IFRvb2xiYXI= c3BhY2Vz LmZpbGxTdHlsZQ== IHNlZ3VuZG8= X3N0cmxlbg== LkZpcmViYXNl 5aSE IG1lbnRpb25pbmc= XCg= IFZhbHZl U2V0dGVy IHNwYW5z IEFsY29ob2w= IExldHRlcnM= XHhl IFRL X0JMRQ== LmdldFJlc3VsdA== PFBsYXllcg== IFBhdHQ= IGVhc2luZw== IHR1cmtleQ== IEZlbg== Jyki IGNvbmZpbmVk IGluY2x1cw== U3VwZXJ2aWV3 KHdpdGhJZGVudGlmaWVy ZW5jaWFs IHN0dWZmZWQ= VGhldGE= IGVjb25vbWlzdHM= fSkpOwoK Y29va2llcw== IFJvb3Nl IENoZWVzZQ== IGZpY2hpZXI= IGVuZm9yY2Vk QUJC bm/Fm2Np X0FMTE9X IHJlY3J1aXRlZA== IGV4cGVuZGl0dXJl LW5pZ2h0 IGFzc2VydE5vdE51bGw= X2V4ZWN1dGU= INiv SU5ERVg= X0ZNVA== IHJlc2N1ZWQ= IE1vbnRobHk= IENvbnNlcnZhdGlvbg== IEdlYg== T2JhbWE= RXBvY2g= aWNpZXM= IE9ydA== IHNvaXQ= KGljb24= RnJpZW5kcw== bW9s IGdyb3VuZGVk IENhdXNl YWRlbmE= V0VFTg== IEx1bg== SVRJVkU= Lmxvb3A= X3VudGls IGNvcnI= LmVkZ2Vz IGh5cG90aA== Y2hlZHVsaW5n dHJhbnNsYXRvcg== INCc Um9t 44CRCgo= IFhhbWFyaW4= IHZpb2xhdGluZw== LmFuY2hvcg== LS0tCgo= IHRyYWRlcg== QURWRVJUSVNFTUVOVA== IHVuc2VyZQ== IERBTw== IGJsb25k IFBBVA== Lmdsb2I= IOi+kw== IHNwbGl0dGluZw== IHVuc3Vic2NyaWJl IGF0bW9zcGhlcmlj IFRyaW0= IGNpdGF0aW9u IGluZmVyZW5jZQ== IEZ0 IERhcndpbg== ZmluZE9uZQ== IEdlbA== KENvbnZlcnQ= IGFjY2Vzc29y O3RleHQ= KHNvcnRlZA== IGp1ZGdlZA== KTtc OnA= IG1laW5l IFNsaW0= LkNvbW1hbmRz IHBlcmNlaXZl Y29ob2xpYw== PERhdGE= LmVudHJ5U2V0 IGFzc2VydEZhbHNl IFBhdHJvbA== ZW5zZW0= xYLEhQ== qKE= V0lEVEg= IFJlc2N1ZQ== IFVJRg== X1RIUkVTSE9MRA== IE1pY2hlbA== QVRFUklBTA== b3BlbnNvdXJjZQ== IERpYW5h IGludml0ZXM= X0JPRFk= IHJlc2Vydm9pcg== IHJvaQ== Y3VzdA== KHRj 77yBIik7Cg== IGZlc3RpdmFscw== IHBlcmZvcm1lcnM= IGNsaW1iZWQ= IGp1bmdsZQ== U3RyaW5nTGVuZ3Ro IHVubGF3ZnVs aWVycmU= dmVydGlzZW1lbnQ= IHN0YWtlcw== IGhhdHM= TW9kaWZ5 IExFVFRFUg== LkhpZGU= IHN0YXR1dG9yeQ== X3doaXRl IFBlcmw= dXRlbmJlcmc= ZW1wbGU= Lldvcmxk IG92ZXJsb29rZWQ= IGNvbmNsdWRlcw== Lyo9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09 LXdpc2U= CXN0cmVhbQ== cG9wdWxhdGlvbg== IGV2ZW50bw== IGlsbHVzdHJhdGlvbnM= ZnRz IGF1dG9m IFByb2NlZHVyZQ== IGRlc2VydmVk LXRpbWVz IGdvbA== TlNFcnJvcg== Y3Jlc3Q= IFBha2lzdGFuaQ== YW55Y2g= Z2V0Q3VycmVudA== IGxhcg== bnRs IFJlYmVjY2E= IG1hdGVyaWE= IGZpbmRCeQ== L2Fk Q2FsbGJhY2tz IEFscw== IEthdGll IE9ic2VydmFibGVDb2xsZWN0aW9u IERvY3VtZW50YXRpb24= VHlwZWQ= IEN1bHR1cmVJbmZv IFRpbW90aHk= IGxhdGVyYWw= InR5cGU= IHVuYXV0aG9yaXplZA== IHRlYWNoaW5ncw== IGRlYnVnZ2Vy W3ZhbHVl IGFsb3Jz IHV6 IHNjYXR0ZXI= IGRvd253YXJk IG1pZ2xp c3RhdHVzQ29kZQ== ICgpKQ== IE1X INC80L7Qtg== Uk9TUw== LmJ1Zg== IGZhaXJ5 IEluZnJhc3RydWN0dXJl PT4i dGxlbWVudA== JCgi RnJvbVN0cmluZw== IEJpbGQ= IGNvbnZlbnRpb25z X25hdGl2ZQ== IEluc3BlY3Rvcg== IFBpc3Q= dWJhcg== IHJlZ3M= IFBpbG90 VGh1cw== Picr IGNlbGE= Lm5ld3M= KFByb2R1Y3Q= TGl2aW5n UnVzc2lh IGZhY2V0 ZXRpY2Fs IFsnJA== L1s= IERpcmU= IGdhc2Vz IElORk9STUFUSU9O IEVhdA== IEZvcnVtcw== IENoYXJhY3RlcnM= X21ldA== IOyLnA== IGtpbmdz YWNoaWU= IExhbWJkYQ== IHRpbWVycw== IExpZ2h0aW5n IENhc2V5 YWRkaXI= YW5kZXg= LmFuc3dlcg== IEhpcA== IFByaW5jaXA= U3RhcnREYXRl IOOAjA== dHJlcw== ICYj Lk1heFZhbHVl IFByb2JsZW1z IGxhdGV4 T2ZDbGFzcw== IEx5bm4= Ly8n IHZveWFnZQ== IHNodXR0bGU= IFJvbGxlcg== IFJ1bnRpbWVFcnJvcg== dXlh RGlj CWJ1aWxkZXI= IGJ1bGx5aW5n IHNpbXBsZXN0 LmNhbGxlZA== IExS IG1vcmFsaXR5 IHN0dXJkeQ== dHJhY2tpbmc= LnN3YWdnZXI= X0JJTkQ= SVRPUg== LXVybGVuY29kZWQ= INGF IFRyaW5pdHk= IHRyYXBz IHwt IHNldFRleHQ= IGJhcmdhaW4= IGJyYWtlcw== LmdldENvZGU= IG1pZ3JhdGU= IHJpYmJvbg== KXJldHVybg== IGNoYXJnZXI= YWNvbQ== QURJVVM= IEFtYmFzc2Fkb3I= LWFmdGVy IGFubmk= CXNwaW4= Q29uY2VwdA== IEhlbmRlcnNvbg== IEhPU1Q= LnJhbms= IE5vcnRoZWFzdA== IGJlcmxpbg== IHJlcXVpcw== LmZlZWQ= IHNvdXJjZU1hcHBpbmc= IFJlbmNvbnRyZQ== LmFqYXg= bmVzdGpz IHRyZWs= IE5hY2lvbmFs ICZb IHBheWFibGU= b3J0ZXg= IGRlcHQ= ZmllbGROYW1l IGNvbXBsZXRlcw== IFJWQQ== IG9uaW9ucw== YWxpZ25tZW50 Rm9ybWF0cw== ICd7JA== SGFzaFNldA== IEJvZA== LkludmFyaWFudEN1bHR1cmU= IHNldHRsZW1lbnRz IGh5ZHI= LnVwZGF0ZWQ= dmVudGg= KHNlY29uZHM= PSIvIg== IHdlYnBhZ2U= KAoK IHRpcg== IHRvZXM= IEJyaWNr IGFtYml0aW9u UG90 PW1heA== RVRJTUU= IGRlcG90 Y2FsbHM= IE5vcndlZ2lhbg== YDo= IGJ1cmdlcg== IHByb2Zlc3NvcnM= IEFsbG9jYXRl LXRoaXJkcw== LWNoYXJ0 IGZvcmQ= Kk4= LmtvdGxpbg== IHBhcGVyd29yaw== IERFVklDRQ== JUAiLA== cmVzcGVjdA== KG1w 6auY LWlm IGN1c2hpb24= b2JvdA== IHBhcmM= U1BBQ0U= IE5ldGFueWFodQ== IHNlbGZpc2g= ZmVhdA== IGNsaWVudGVz LXRvb2xz IHBvcmNo IGpx LnZlcmJvc2U= IGxpYmVyYWxz XSkKCgo= cGllcw== Tm90Qmxhbms= KHRlcm0= yJtp X1BhcmFtcw== Lm5vcm1hbGl6ZQ== QnVsbGV0 QVNJQw== KGhleA== X2NsaWVudGU= Kyw= X0RJ IGZvcnRoY29taW5n fSIpXQo= c2Vv VW0= Pk5hbWU= IGNvbWZvcnRhYmx5 aXJlY3Rpb25hbA== V0lUSA== L3By IFBvb3I= IFZpdGFtaW4= dmlj R0g= IHByaW9yaXQ= IE5O IENsb3NlZA== pO0= IGlzT3Blbg== XENvbnNvbGU= QW5kRmVlbA== LlNVQ0NFU1M= X09QRVJBVElPTg== cG9sYXRpb24= IFRhcw== cHN6 Picu Q1VSUkVOVA== VmVuZG9y aG9zdHM= IEVyZA== PnRhZ2dlcg== IHNvdXJjZU1hcHBpbmdVUkw= IG1hcmF0aG9u X2Nsb3NlZA== IGV4ZW1wdGlvbg== IHJlY29nbml6ZXM= aWRlc2hvdw== JyQ= KCcvJyk7Cg== bWl0cw== d2Fyeg== IENoZXJyeQ== taw= bm9y cG9ydGU= IHds X2JhY2t1cA== LmdldEJvb2xlYW4= LmdldFJlc291cmNl IGRlZmluaXRpdmU= LkVkaXRUZXh0 IHPDrQ== LkNPTlQ= IFBMQVlFUg== LmNhcmRz IFNob3Jl KCcvJykK Y2x1aXI= V2ViRHJpdmVy KG1vbnRo LXJlbGVhc2U= IGluc3BlY3Rvcg== 5aM= IE5G X2NsaXA= 5a2Q IGludGVyYWN0aW5n LnRtcA== ICcnJwoK IGRlZQ== IGZyb3N0 Il0pKQo= IFBsYWNlcw== VGhyb3dz Zm9yaw== L2RheQ== aVBob25l IE1JQw== IGZvbGRpbmc= IGNyb3Jl IENoaWVmcw== cGhlcmljYWw= KHByaWNl LldyaXRlU3RyaW5n IGV4aXRpbmc= XScsCg== aWdodGluZw== SW5ncmVkaWVudA== KHZlcnRleA== IHNjcm9sbFZpZXc= aGY= Om5ldw== U0VO c2VjdG9y IHNwaW5z IFNjaGVkdWxlcg== b3RlY2hu c2VtaWNvbG9u Rm9udE9mU2l6ZQ== IFNwZWNpZmljYWxseQ== ZmxhbW0= Lk9iamVjdElk IGNvbnRh X3Blcm1pc3Npb25z CUZST00= SUNPREU= L2tn IEhvdGVscw== LW1lZA== IERpbg== IG5hdnk= Z2V0UGFyYW0= IG1lbmQ= IHBvcnRyYXllZA== IE1ldHJvcG9saXRhbg== UGFpbnRlcg== IHJlZmVycmFs X2dvb2Q= IG1hcnZlbA== b3NhaWM= Pigm LnVy IGVzdG9z V2lsbGlhbQ== IHRpbWJlcg== IHF1ZWxxdWVz IERvY3VtZW50cw== LlhhbWw= IGJhdGNoZXM= 6YGT IFJlbGVhc2Vk VGFpbA== Q09PS0lF aGVpZA== X3N0YXRpb24= IFZpYQ== U2FsZQ== IFJlcGVhdA== IHByb21pbg== IFpv LWZvcndhcmQ= IElvbg== aXRhcnk= IGp1cw== LXJlcXVlc3Q= IHByb3VkbHk= IFN0cmVhbWluZw== KE1vdXNlRXZlbnQ= IFNwcmludA== X3JvdGF0aW9u UmVwb3NpdG9yaWVz IHRhcnQ= INGB0LI= IG1hcHBpbmdz 6Ko= Q3U= Q3ljbGU= IGJ1bg== CWx1YQ== 44OJ ICgoIQ== IGNvbGxlY3RpdmVseQ== IENvbmQ= IHdzenlzdA== KGxpYg== b3BlbmhhZ2Vu X3NraXA= LkNvbHVtbkhlYWRlcg== 6YI= cGVyaWVuY2Vk j+i/sA== X3Byb3Bz IGNvbnRyYWNl IG1hdGNodXA= YWJldGlj Lm1lbWJlcnM= UkVDVA== KGRhdA== IHNvZw== cmVub20= X01ldGhvZA== Q3VzdG9tZXJz ZnVsbG5hbWU= Wk4= cmV0cnk= IGthcA== IE5ldQ== 6Io= YWRkQ2hpbGQ= d2lsbFJldHVybg== X3Blcm1hbGluaw== IGVuZXJnZXRpYw== IFdldA== IE1vcnI= IGdjZA== Y291bnRz LHR5cGU= ZGln KExvZ2lu IGNyYWNrcw== IGJhY3RlcmlhbA== IE1lYXQ= IEFybXN0cm9uZw== IEJyb256ZQ== IGFwcHJveGltYXRl X2RpcnM= bGlnYQ== xYJhZA== IGtpbmRuZXNz IGNvbnRyZQ== IEVWRVJZ TUVU IGFubm91bmNlbWVudHM= Z3Bpbw== IFdhaXRGb3JTZWNvbmRz IFBob3Rvc2hvcA== IGRpc2NvbnRpbg== L2Rk IHRvcG9sb2d5 YW5pY2Fs LmludGVyZmFjZQ== YXVjb3Vw Lkhhc2hTZXQ= QVJJQU5U KHJvdXRlcw== IFRlaA== IGh5cGU= XSIpLg== IHNsYW0= IGJyb3Ro LWludGVy IFJpZA== LW1hbmFnZXI= Q2FuY2VsYXI= IFBhZ2luYXRpb24= IHNvdW5kdHJhY2s= IHBvc3Rlcmlvcg== IHNjcnVi Y3JlYXRpbmc= LSo= aXJ0ZWVu LmR5 LnN5bW1ldHJpYw== ICIiLg== PT09PT09PT09PT09PT09 IGNoYXNzaXM= IG51bWJlck9mUm93cw== RGV2ZWxvcGVy X2JpbnM= IE9VUg== cmllYg== UHJvcw== IHdpxJk= ImQ= IGFzeW5jaW8= emVpZ2Vu X3NwaQ== LkFMTA== IHNjcmV3cw== Q2hpbmVzZQ== IGFwaUtleQ== IHVuc3VjY2Vzc2Z1bA== IFNlYWhhd2tz T1JH 56ug IHByb2Zlc3Npb25hbGx5 IENvdXBvbg== 5a2X5q61 Q29udmVudGlvbg== IHBvbHlt 5omL IHNhbHZhdGlvbg== IGVuZ2luZWVyZWQ= IFdyZXN0 IEdDQw== IHdhcm1lcg== TGF5b3V0Q29uc3RyYWludA== IGFnZ3Jhdg== U2NyaXB0cw== dmVudHVyZQ== IHJlZnJpZ2VyYXRvcg== IGlubm92YXRpb25z IFJ1bm5lcg== TklD IFJvbGxpbmc= Q29udHJvbEV2ZW50cw== IGxvb3M= cGFj CXBhbmVs ZWZl IEJ1ZGRoYQ== LS0tLS0tLS0tLS0tLS0K 5bqT KGZvcktleQ== IGx1bWlu ICg/ IEFJRFM= LHVzZXI= aW1pZW50b3M= Y29udGVudFR5cGU= YW50bHI= 6aY= IFdlbHQ= UHJvZHVjdGlvbg== bWlnaHQ= IFZJSQ== Iiwo IG9ic2VydmluZw== IGRlbGliZXJhdGU= KGNvbnRyb2w= IHdpdGhk IHNlbWFuYQ== U1RBQ0s= dWNoZW4= TmljZQ== IERldXRzY2hsYW5k IFNwZWNpZmllcw== ZG1h aXppbw== IEZhY3Rz X3BvcHVw IERpcmVjdG9ycw== ezo= W1I= INGN0LvQtdC80LXQvdGC IHBsYXQ= IGRpcmVjdGluZw== 5LiJ IEdpbGJlcnQ= 4oCmLgoK LnFtbA== IHRoZXJlYWZ0ZXI= IGRpc3Bvc2l0aW9u ZHJhZnQ= IHN1cmdlb24= IEluc2lkZXI= QmxlbmQ= IFRyZXY= dHJpbnNpYw== VG9waWNz cmlldmU= X0ZJTEVOQU1F IGF1dHJlcw== Sm9zZQ== UHJvZHVjZXI= ZXJ1cw== IHBldGl0 IE5FWFQ= IEZpbHRlcnM= IHJlcGxpY2F0ZQ== Il0pLg== IGxlbmRlcnM= XSIsCg== O2NoYXJzZXQ= Q3BwT2JqZWN0 IGZsb3JhbA== IFRpcG8= IGNpcmN1aXRz ZWFzeQ== KCYk aXR0YQ== ZXJ5bA== X0NPTU1PTg== J319Pgo= LWJhY2tlZA== KHZhcmlhYmxl KEluZGV4 IHZvaXI= X2xvY2F0aW9ucw== Kyspew== IExvdWlzdmlsbGU= IGdyYXRpdHVkZQ== Lk1vY2tpdG8= IFBvd2Vycw== aWV1cnM= IGdlb2dyYXBoaWM= cmFsZQ== IGNyYQ== IFNwdXJz aXBoZXJ0ZXh0 QUNJT04= LWNvbW1vbg== IHZpY3Rvcmllcw== IEZpbmFscw== LnNodWZmbGU= LW1pbGxpb24= X1BST0M= YXNzdW1l IGlscw== REJD Qm9vdFRlc3Q= IGxhdm9y LnRlc3Rpbmc= LmFzdA== Il0v bW9pZA== IHF1YWxpZmljYXRpb24= Z2VzY2g= CXB1dA== IGFpcnBvcnRz Skk= VGVhY2hlcg== X3VuaWZvcm0= IG5hbWE= IEJhc3Q= ZXJ0eXBl Y2FwdHVyZQ== Z2V0QWxs IFJleW5vbGRz b29sZWQ= LmNvbW1lbnRz IGNoaW4= KS4q INC40LvQuA== dGds dWRvcw== IGTDrWFz Y2hhaQ== LnByb2dyYW0= IHBzeg== CWljb24= cGhpbA== ZW50cmFs X1dSQVA= b3Zp IG5vc3RhbGc= SW5maW5pdHk= CXlpZWxk IHZpdGFtaW5z UXVhdGVybmlvbg== U2luaw== X2dvb2Rz IC4uLi4uLi4u IFdpbmdz dXJpZGFk LXN0b3J5 Il0pCgo= aWRlbGl0eQ== VHlwZURlZg== R3Rr IO2M X01haW4= IGNoZXo= IFJhdmVu IHBheXJvbGw= IGZyZWVsYW5jZQ== TExV IE1lbmQ= ZWRheQ== QXBpTW9kZWxQcm9wZXJ0eQ== LkZvcm1Cb3JkZXJTdHlsZQ== IGVjb25vbWlzdA== c3RhbmJ1bA== IGZyZWlnaHQ= LUFnZW50 KG1ldGE= IHN5bW1ldHJ5 ICcuLg== LkNhbGVuZGFy LWF1dA== Z2Y= cGVudA== eWNsb3BlZGlh IHdpc2hpbmc= CgoKCgoKCgoKCgoK IGdlbnRsZW1hbg== IOqz PSM= IGxlY3R1cmVz 4oCcSW4= ICFf IGhi IFZlbmRvcg== UmVjZW50bHk= X25vdGVz 5o+Q56S6 Ik15 SGVhZGVyc0hlaWdodA== X1NP IHVud2lsbGluZw== IHN1cGVyaGVybw== Z2lv cHN5 IFBlZXI= amF2YXg= JmFwb3M= IENyaXNpcw== b3JkaW5hbA== TWVtY3B5 KysrKysrKysrKysrKysrKw== LXZhbA== IHdvcmtib29r LWFw PWs= IG1ldGFsbGlj X3BlZXI= QnlQcmltYXJ5S2V5 X1NE dWF0b3I= X1NIQURFUg== KU1hdGg= LlRyYW5zZm9ybQ== IGNvd3M= UGhp IENsZW0= KF8oIg== IEx1ZA== LWRlbGF5 IFNlY3VyaXRpZXM= IE9ydGhvZG94 U3ltZm9ueQ== KHJlcG9ydA== IGVudGVydGFpbg== RVBT aXpvcGg= ZXh1YWw= SVJE 5LuO IGxpdGg= IHNhbml0aXpl IGZlbWluaW5l SVNCTg== LmF1dGhlbnRpY2F0aW9u X3BpcGVsaW5l L2NvbnN0YW50cw== IENPTkY= IGx1Y3I= cmljaWE= LnR0Zg== LnNldENvbnRlbnQ= IHN0YW4= b3JlYW4= IExsb3lk LnJhd1ZhbHVl IGdvcg== IEJyb3ducw== UmVncmVzc2lvbg== IGxvd2VyaW5n bmFpc3NhbmNl IGJsb3dz IGFtYXplZA== IHVucmVsYXRlZA== UmV2aWV3cw== IHJ1Ynk= IE1vZGlmaWVy IGdpYW50cw== LnRocmVhZA== IGNvbnRhaW5tZW50 IFN0YXJ0Q29yb3V0aW5l dW1hdA== b3JlbGVhc2U= IFJhbmR5 QGVuZGlm RGlnZXN0 IHN1YnVyYmFu PSIpOwo= IGFubm9uY2U= LnZhcmlhYmxl XEZvdW5kYXRpb24= IGFjcmU= VmFu IHR1cGxlcw== ZG5z IFN0YW5kaW5n X2xhcmdl IGJveGluZw== U3VwcG9ydEFjdGlvbkJhcg== IEZvcnR1bmU= IFJ1bQ== X211bHRpcGxl YXJjaGljYWw= IGZ3cml0ZQ== X3F1b3Rl IGZvb2xpc2g= IGNvbXByaXNpbmc= INC+0L8= LXNlbGVjdGVk dmY= bWFpZA== TmFtYQ== KGRhdGV0aW1l IGluZGlyZWN0bHk= Z2FydA== Zml4dHVyZXM= Y2hvcw== IEhhbG8= IHJlY3VycmluZw== LW5ld3M= dmls IE51cnNpbmc= LXByb2R1 IEhR XEh0dHBGb3VuZGF0aW9u ZW5jaQ== YXVlbg== IHZ5 b2NyYWN5 IGRlbGVnYXRpb24= IGFzcGhhbHQ= IHNldFNlbGVjdGVk a29r L3Jlc3Q= bWV0aWNz IE5TRGF0ZQ== IHRyYXZlbGxlZA== IHJlY2li IG1pbWU= Q0xJRU5U IEdV IEhBTkRMRQ== L1E= W3o= IGJvdGhlcmVk IEJCUQ== w6dhcw== X2V4YW1wbGVz X0ZJTg== IHdoaXRlQ29sb3I= IGFzdHJvbm9t LWRpcg== IHNvdmVyZWlnbg== IGJyZWV6ZQ== IGlubmluZw== IEVkbW9udG9u Z2xp LmJsb2dzcG90 anN4 IHZlcnNh IE1vaGFtbWVk LkpvYg== LXRvZ2dsZXI= INC/0L7Qu9GM0LfQvtCy0LDRgg== YXJkb24= IG5ld2Jvcm4= IG5hdmFs bm90ZXE= IHR1bWJscg== IGhlbnRhaQ== IFR5cGljYWxseQ== IGxvb3Q= LlNwcml0ZQ== RmxpZ2h0 IHdhdmVsZW5ndGg= LXNr IEVsbGU= X2V4cG9ydHM= INGP IElI aXpvcGhyZW4= IO2B X3ByaW1hcnk= IG1vaXM= IEJO IHN5c3RlbWlj IGRpZmVyZW50ZXM= SU5DVA== ICcnCgo= JHE= V2lkZ2V0SXRlbQ== Y2xpZGU= JGZpbGU= TGVtbWE= L3RhYmxl YWdyaWQ= IE1vbmdvREI= aW50ZQ== IGFwcHJlbnQ= wq1pbmc= LkRi IMOC aGFtbWVy PScnOwo= IGJyb2tlcnM= aXRsZW1lbnQ= c2VtYmxpZXM= RWxl e3g= IGxhc3RuYW1l PC0= IGZsYXR0ZW4= X2JhbmQ= LlJvb3Q= LnJlYWRGaWxlU3luYw== PT09PT09 LnJ4 Pw0K IG1ldGFwaG9y VGk= Y29udGU= IGRlYml0 IGNvbnRlbXB0 Q3BwVHlwZQ== 5pSv Rm9ybUZpZWxk cmF0aW8= b3NvcGhlcg== IGltcGxhbnQ= UFVSRQ== IGFsdGE= X21hbmFnZW1lbnQ= IHJlZmluZQ== IENoZWNrQm94 IENoYXJs LXZlcnNpb24= Y29uZGl0aW9uYWw= dmVudWVz IHJpZmxlcw== IG9mZnNwcmluZw== IG1pbGxpbmc= IHNoYXJwbHk= IHVuZGVyd2F0ZXI= KG9yaWdpbg== X0NvbnRyb2w= IC4k UGx1Z2lucw== IGRyeWluZw== IGlsbHVzdHJhdGVz LXU= IHZlZ2V0YXJpYW4= bnBj SGVhcnQ= OycsCg== Y29tbWE= dGVlbnRo YXNhbg== L3NwZWM= X21vdmVz LW1hcmdpbg== IGluZ2Vu wqDCoMKg IHByb2pldA== IG90cmE= IGJyYXM= LnV0Yw== IHNsZXB0 PXN1Yg== YWJpbGl0 cG9zdGVy IHNkaw== b3VuY2lsbA== IHdk UHJlcGFyZWRTdGF0ZW1lbnQ= IERydW0= KGF0dHJpYnV0ZQ== IEV0aGVybmV0 CURC Q2FsaWZvcm5pYQ== Y3ViZQ== W0k= LkNyZWF0ZWQ= IEhN IHRyYWNpbmc= Rm9ybXNNb2R1bGU= LXlvdQ== LmN1cnJlbmN5 ZmVlZGluZw== IHRib2R5 TGk= YWNjaW9u bmFz IHRyb3V2ZXI= Tk9ORQ== In0sDQo= IGZ0cA== V2l0aElkZW50aWZpZXI= cG9sYXRl RmlsZUluZm8= IHB1cnN1ZWQ= ICAgIA0KICAgIA0K REVTQ1JJUFRJT04= fSovCg== RnJvbU5pYg== IGRlY29yYXRpdmU= X1NTTA== KGNoYXQ= VExT IHN1cnByaXNlcw== YWxjdWxhdGU= IFNwbGFzaA== KENvbmZpZ3VyYXRpb24= IFNFTQ== aW1zb24= L2xpYnJhcnk= PERvdWJsZQ== LnJvYm90 wqDCoMKgwqDCoMKgwqDCoA== IENQRg== IFVuZGVyc3RhbmRpbmc= IGNvc21ldGlj IFh0 dGlwcw== K2s= KCIn IFBEVA== V0FS LmdldE9iamVjdA== IFRyYWRpdGlvbmFs LnNsdWc= IERpcGw= PSIiLA== IEZpbG1z IEFuaW0= LmhlbHA= IGVtYmFzc3k= IEJvb3Rz IGJ1bms= LXJpc2s= IHBjaQ== IC9cLg== IElQVA== IGNyYXNoaW5n IGlwdg== X2tl IFJFU1A= LkxvZ0Vycm9y IGluYWRlcXVhdGU= SW9u IEbDvHI= cmljdWxh IHNob3VsZEJl YWxyZWFkeQ== J10uIjwv IFN0dWZm RGlnaXRl IHRyYW5zbGF0b3I= X3Nwcml0ZQ== bGV0YWw= IG1haW9y IFNleGU= dGhhbmtz IENvbXBsZXRlZA== IGdhc29saW5l LmF0dHJz YmFnYWk= IE9yaWc= Ol0s LmxvY2FsZQ== IFJvbWE= w61m IGZhdm9yZWQ= IHZhaW4= IHNwb29u IEphaHJlbg== IG5pbmc= V1dX LGZsb2F0 X0RBVEFCQVNF Qm9vdHN0cmFw IENCQw== IENodW5r X2ludG8= IEtvbA== IGRlZmVuc2Vz b3JlZFByb2NlZHVyZQ== YmFsbHM= VGV4dENoYW5nZWQ= IHNoYXBpbmc= IH19Pg== R0VE ZmFx IG9wdGlvbmFsbHk= X0Rpcw== IFN1Y2Nlc3NmdWw= IENlbnN1cw== IGluY2FyY2Vy X0NBUkQ= IGF2aWF0aW9u IEd5bQ== QXV0aG9yaXR5 LkJlYW4= c2hhZGVy Tm90RXhpc3Q= X1RleHRDaGFuZ2Vk IFNUT1A= KHRlYW0= Ikg= d2c= IGdyaW5kZXI= IHN0cmlwZQ== IHByZXNlcnZhdGlvbg== Q2xhaW0= YXZlcnNhbA== d2FyZWhvdXNl dGFyZ2V0cw== VHJ1c3Q= IGFsbGV2 LHd3dw== b3Vzc2U= X2NoYW4= X1NpemU= c3lzdGVtcw== IG9iamVjdGlvbg== IEthbmU= IGNvcnJvcw== IERTTA== IHVh IE1I IFN0cmF0ZWdpYw== X3RjcA== IOqwkg== IGJvcnJvd2Vk IEFjaA== CWNvbW1hbmQ= IGdwcw== bGVzdG9u aWNoZXZlcg== IFVB IGFzc2F1bHRlZA== IHNwZWNpYWxpemVz CXNlYXJjaA== SG90ZWw= ICAgICAgICAgICAgICAgICAgICANCg== IFBpdGNo INmB UkVBRFk= IHBhcmVudGFs IGfDqW7DqQ== IGRvbm7DqWVz IGRldGFpbg== VEFSR0VU IHByb3RhZ29uaXN0 IGNsZWFySW50ZXJ2YWw= IEljb25CdXR0b24= IEdldEFsbA== VHlwZUluZm8= RUg= 4oCcVGhleQ== IHtb IGdhZw== INqp IERyb3Bkb3du LmZyZWU= Z29uZQ== aW1lbnM= IGluc3RhbA== CWN1cmw= X0NBTg== IEJvbmU= 77yU b255bXM= LWdvdmVybm1lbnQ= LmJpbmRpbmdOYXZpZ2F0b3I= IERhbnM= IE1jTA== KGVu Pihf 0JLRiw== Lio7DQo= PWo= LWNvcg== U29u LlRvb2xTdHJpcEl0ZW0= LWFyb3VuZA== X1hNTA== ZW5kRGF0ZQ== IHNsYWNr IHJvdGF0ZWQ= IG5vcWE= IGNvdHRhZ2U= IGVuY29udHJhcg== X3NraWxs aG91ZXR0ZQ== IQ0K LndlYXRoZXI= IGVtcGhhc2l6ZWQ= 5a62 INGB0L/QuNGB IENvbXBpbGVy KGFuZHJvaWQ= IOKAug== LnR1cm4= IHN1cHByZXNzaW9u X2NhbGxz ICpA KHN0cmxlbg== LmhleA== IEJpbGxz IFJTQQ== z4I= IEVzY2FwZQ== ZW1lbnRpYQ== IGZyb250ZW5k IHBpbnQ= X2V4Yw== enpv W10sCg== ICInLCci LkVudmlyb25tZW50 IGFmb3JlbWVudGlvbmVk IGVuZHVyZQ== cHJvdG90eXBl dGhlcmFweQ== c3Np RGVn X3BsdWdpbnM= LnVzZXJJbmZv UHJpbnRlcg== IFBST0dSQU0= IHJ1aW5z IGVtcGlyaWNhbA== IGNyYXds IEJvaWxlcg== LWNvbW1lbnQ= LnN1YnBsb3Q= X2V0 ICcuJyw= bWlub3I= IEN1c3RvbXM= IHlhdw== dW5kZXJsaW5l IENvbW8= KCgn KG1lYW4= IGNoYXF1ZQ== IEJsb2Nrcw== LnJhZA== aWxpYnJpdW0= IHdlYmRyaXZlcg== IG1lbGhvcg== ZGFuYQ== IEFidXNl IFNvdXRod2VzdA== IFBhcmVu UEVSVElFUw== CUlM IHNjcmVhbQ== dnU= IGluY29tZXM= IG5pbQ== IGxhY2U= IGNvbXBlbnNhdGU= UmV2ZXJzZQ== RGF0 X2F0dGFjaw== IG5vdXI= YWNoZW4= Y2Vr PEZ1bmM= d2ll Y29tcHJlc3NlZA== LW1hdGNo KCIiKV0K aW1pemVk Lm9yaWVudGF0aW9u LmNvbXBhcmVUbw== IG1hc3NhZ2dp IOychA== IGVsYm93 IGFudGlveGlk dW5kcmVkcw== L3Rvb2xz IFJPVw== YW5tYXI= IFdvdw== X3RpY2tldA== UHJvZ3JhbW1pbmc= IHRoZW9y LXJldmlldw== KCkpKSk7Cg== IFJpY2hhcmRzb24= IFBvY2tldA== XVtd YW1wcA== X2hlYWx0aA== IFBPUA== IE5hdmFs R3Vlc3M= IGFuY2VzdG9y LkdldEFsbA== LmxvY2FsU2NhbGU= IE1hcHBlcg== IGFjY3VtdWxhdGlvbg== IHNpbXVsYXRlZA== IERyaXZlcnM= IGTDqXM= Y3VycmluZw== IGVsZXBoYW50 IGFkdmVydGlzZWQ= IG1haWxib3g= U0hJRlQ= IE1vbmljYQ== IGFuYw== IHdhcmRyb2Jl SW5ncmVkaWVudHM= IHx8DQo= aXBweQ== IGFudGliaW90aWNz YXZpbmdz KGN4 IEZlcnJhcmk= IEFuaW1hdG9y LmR0eXBl cmVtb3ZlZA== b3JkZXJieQ== IGNyZXM= b2PDqg== IHB5bQ== IENpcmN1bGFy QGluZGV4 IFdhcm0= U2F5 IEFzc2lzdGFuY2U= IGN1cnRhaW4= IE1vbnRl SUxFUg== IENWRQ== IER1Y2s= IEFsbG93cw== X2ZpcmU= IERlcmJ5 IHJlcG9z IGh0dHBDbGllbnQ= IHBzeWNoaWF0 IG5vd2FkYXlz IGNhdXRpb3Vz IENvbXB1dGluZw== IGNvbXBsZXRpb25IYW5kbGVy IFdlbHNo IEJFU1Q= IHN0cmVzc2Z1bA== X1BF 5pel5pyf IERhdGFGcmFtZQ== CUludGVnZXI= X1ByaW50 TW92ZXM= IHRyYW5zZm9ybWluZw== LkJhdGNo eWFob28= UG9zaXRpb25z emVq IG5vb2Q= aW9yZXM= Xyo= IGNsaw== IEZsb3lk IGhhcA== Zm9udHNpemU= IG5heg== Lm5vdGlmaWNhdGlvbg== IERlcHJlc3Npb24= IGFjbmU= KioqCgo= ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCg== LmNvbnRlbnRz eW50aA== IFN0cmFpZ2h0 Jyl9fSI+PC8= IGJ1bGI= Ulg= Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0K IGNvbXVuaWM= IFJO LW1lZGl1bQ== TEVBTg== PWxlbg== UGhvbmVOdW1iZXI= ZXJ2YXRpb25z QWNjdXJhY3k= IEFubm90YXRpb24= X2tleXdvcmQ= X2hpbnQ= IEF0aGVucw== IGFzc2lzdGluZw== IEhD LkluaXRpYWxpemU= JykpKQo= dXBh IHN1aXY= IElQQw== PFRFbnRpdHk= IGJyYW5kZWQ= b29tbGE= bGFyxLE= IFhNTEh0dHBSZXF1ZXN0 IGTDqWrDoA== IHRyYW5zY3JpcHRpb24= IHByZXZhbGVudA== LnBsYW4= IHN0YXJl IHdvcmtvdXRz IEVkdWNhdGlvbmFs IG1lc3N5 IE1PVA== LkNvbW1hbmRUeXBl UWVk KGdjYQ== IExpbmVhckxheW91dE1hbmFnZXI= IEJsb3c= IEFsdW1pbnVt IHN3aW5nZXJjbHVi IFRyYW5zaXQ= IGV4cG9z dmly KHNlY29uZA== IGJlbG9uZ2Vk U3RvbmU= 6ZW/ IFN1bA== IGdpZA== IGFsbG95 ZXJ2YQ== aXNlY29uZA== X1JFTkRFUg== IGFuZ2Vscw== IFBoaWxvc29waHk= b3B1cw== IG1vbw== ZW5ndWlu X1ZBUklBQkxF X0RFU1Q= KGF1eA== IGhvZQ== IGRvYg== YXR0YWNobWVudHM= IGNvcnJpZG9y IGRpdmlkZW5k nbw= IFRocm91Z2hvdXQ= Lm9wdGlt JG5ldw== IGJlcmc= IHNwcmVhZHNoZWV0 LlRyeUdldFZhbHVl IHBheW91dA== IE9uRGVzdHJveQ== YXV0aGVudGljYXRpb24= IE1pZ3VlbA== cnRj IENocmlzdGluZQ== IEFJUg== IGp1cmlz IGRlc3BhaXI= IHBhdGVudHM= LWhhcw== JV4= 5LuY X3N0cmR1cA== IFJlYXI= ZXR0ZXM= KHByb3BlcnRpZXM= IHdyaXRhYmxl LmlzTnVsbA== b2xpY3M= X2Jsb2I= IGN1YWxxdWllcg== YWZp b3d5Y2g= 6I635Y+W w4c= IENhcmRpbmFs IHRlbWE= IkFuZA== UGFnZVNpemU= 56eS LlNpbXBsZURhdGVGb3JtYXQ= IFdpbm5lcg== IGNvcnJlbw== X3dl LmFkZE9iamVjdA== KGNvdXJzZQ== IGhvZw== b3Bybw== IHByb2JhdGlvbg== dW5hYmxl KGFjdGl2ZQ== 5Zu+54mH IHBlcnRhaW5pbmc= IGVtcGhhc2l6ZQ== IFByaW50ZXI= PS4= IHVwZ3JhZGluZw== L2NvbnRhY3Q= PVtb LXNhbg== CXZhbHVlcw== IGRvc2FnZQ== U29saWQ= IFJvb3NldmVsdA== 5ZWG5ZOB IHJlY3JlYXRpb24= IFRlcm1pbg== LkJhZA== IEJvbHQ= U2t5 X0ltYWdl IHNxdWly IENvYg== T1JO IGF1Yw== LkxFRlQ= J0I= LXJlc2lzdGFudA== PiIr IHRva2VuaXplcg== IHNvdmVyZWlnbnR5 IFBlbmNl KCkiKTsK IHBlc3NvYXM= Lkdl IEluY2x1ZGVk IHBhZ2luYQ== IGV4cG9zaW5n 0LXRiA== X1NDUklQVA== LyQnLA== VGh1bWJuYWls 15Q= d2ViRWxlbWVudFg= d2ViRWxlbWVudFhwYXRocw== cHJlc3N1cmU= IEN1cnJ5 X0NQ T0xVVElPTg== SUxFUw== cHJvdGVjdA== b29sYQ== V29ya3NwYWNl e307Cg== IFVOUw== IHN5bXBhdGh5 cm9rZXI= IHJlbW9kZWw= CWNlbGw= IGF0b3A= LkZ1bGxOYW1l IGZhdXQ= IEVhc2lseQ== X2R5bmFtaWM= IGZyYW1lZA== IG1vdGl2ZQ== 6Lev c2Ft IG1hcmNh IFRleHRFZGl0aW5nQ29udHJvbGxlcg== IGRlc3RydWN0b3I= Y3JlYW0= IHJ1ZGU= IEJvbGQ= IEluZGlnZW5vdXM= IGdlbnM= IHJlbGFjaW9u KHN5c3RlbQ== IFVJRm9udA== X2NoYXJnZQ== VVNURVI= RVY= Lk5hbWVzcGFjZQ== IG1lcmdlcg== IGNhbGxvYw== Z2FuZw== QmFkUmVxdWVzdA== IHNwZXI= LWRlc2lnbg== IOKH Q2hhbg== IG9yZ2FuaXNt LCk= PWlk X3BsYW5l IENhc2Vz ZWxmYXN0 IExlZ2lzbGF0dXJl IEZha2Vy IGludm9raW5n LXV0aWxz KCkuJw== LmZhY2U= IGd1YXJkaWFu bXlNb2RhbA== IGNsaXBib2FyZA== IEFUTQ== IHBlYXM= IFN5bHY= LmNhbGM= IENvbnRhY3Rz aW50VmFsdWU= IG1vZGlmeWluZw== IEJhcmI= Lmxvc3M= X3BlcmNlbnRhZ2U= QXNrZWQ= KGxzdA== YXRlZ29yaWNhbA== LWZpbGVz IFJvbWFuaWE= LkFj IGhhaQ== IEZseWluZw== IMW8 anA= IFRyYWluZXI= LmFyYw== X2RlZw== IHRyYWNlYmFjaw== T3JGYWls RkxPVw== Lm9sZA== b3lh Z210 aXNlbXB0eQ== IHZhY2NpbmF0aW9u IG9ic29sZXRl cmVjb2duaXplZA== IHJ1aW5lZA== IFJlaW4= IFRyYWNraW5n eGZi 2KfbjA== IHbDpnJl IGJyeXN0ZXI= IElUUw== IGRlc3Rpbnk= IHN3ZWFy IHJlZGVz IGNsZg== IGZsaXBwZWQ= CWhlYWQ= Qmx1ZXRvb3Ro IE92ZXJyaWRlcw== OkJvb2xlYW4= Xz0= X2xy c3Bhd24= OmluZGV4 VkFMVUVT aXNrZXk= PyIpOwo= LnN5bnRoZXRpYw== IENoZWNraW5n c3RydWN0dXJlcw== aXBpbmc= IHZvY2Fscw== LVVw IE1hbnVmYWN0dXJlcnM= IE1hcnJpYWdl 5Luj56CB IGdhcm5lcg== X0NsaWVudA== cGFyYWxsZWw= UklFTkQ= IHZpbmVnYXI= c2VndWU= SkI= IGNvbnRhY3Rpbmc= IENhcnJvbGw= IG91dHJlYWNo dGVuc29y X3ZhcmlhbnQ= IHRoZWF0 bGljYWJsZQ== e3w= dGlueQ== X2xldHRlcg== IHBlbmNpbA== SGVhZGVyc0hlaWdodFNpemVNb2Rl aWx0cm8= LmF1dG9jb25maWd1cmU= LmRyYWc= LnVzZVN0YXRl IEJNSQ== aGludA== Q29tcGlsZQ== Klw= ZW5hcnk= IGx2bA== LkNhY2hl Kz0i X3R2 cnVpdG1lbnQ= IGZyZWFk QXJ0aWNsZXM= ZmlsYQ== IHBhY2thZ2Vk 4piG QVRIRVI= IFBsYW5uZWQ= c2NoZW1l IGRpYXJ5 IG9mZmVuc2Vz Lzw/ ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== UHJvZ3Jlc3NIVUQ= IEdvcg== LmdldFRpdGxl IG1vY2tlZA== IFRvcnk= ICIpIjsK I2c= IGxpZWQ= IHN2Yw== X2d1aQ== RU5UUlk= IHNlcnZpY2lv bW91c2VvdmVy U0FDVElPTg== 44Kz IHJlaWZl bGVjdHJpYw== X2NyZWF0aW9u UmVhbGl0eQ== KCcr cHJvZHVjdElk U3VwcGxpZXI= LUxl LnJlcG8= dWNraW5n X1N0cg== IFJlbGF5 0LjQuA== IHBlcnY= Q2hpY2Fnbw== IG1haXNvbg== IHN0aWNrZXI= X3ByZXNzZWQ= U3dhcA== IElH IHN1c2NlcHRpYmxl b2NhZG8= IGdpbg== ZXhl aWdoYm9yaG9vZA== KWA= IGRpYWdyYW1z IGluZmxhbW1hdG9yeQ== IHTDqQ== IFBvcHVw IGFwcHJlaA== IFBvcnRmb2xpbw== IHdvcnM= LmVudW1z 0LXQs9C+ L0J1dHRvbg== IFBoYW50b20= ICM6 IGRpaw== cGFnZXI= ZnRhcg== IG9yZ2FuaXplcg== KGNoaWxkcmVu IE11bmljaA== IHN0cmFuZw== IFJX 44K/ TWFo cHRpZGU= IGxlYXJucw== IHJlZHVjdGlvbnM= IFJlcGxhY2VtZW50 T1RT YWxjb24= KHBhcnRz YmFzaA== IENpdGl6ZW4= jbDsnbQ= IEh0dHBTZXJ2bGV0 X1NDSEVNQQ== bWVhbnM= IGhvcnJpZmlj VkVSSUZZ IERDSEVDSw== ICgv LmJlZm9yZQ== LnRleHR1cmU= Z2V0TW9jaw== IFNlbnNl SW5zcGVjdG9y VGV4dE5vZGU= KEFM LmdldE5vZGU= IGJveWM= IEJyaXNiYW5l IGJhdHRsaW5n CXR4 IGxvYmJ5aW5n YnVpbHQ= IFNFRUs= IHJhbmRvbWl6ZWQ= Z25p X2NsdXN0ZXJz X2lkZW50aXR5 IGNhcmRpYWM= IG5ld1VzZXI= LlZpZGVv ZHVpdA== XWluaXQ= QXRs KXZhbHVl VGV4dFV0aWxz INC10YHQu9C4 Q29tcHV0ZQ== PSgn CQkgICAgICAgICAgICAgICA= IGFydGVy IFRXTw== JykpLA== IERJVg== IHByaXZpbGVnZWQ= IFBhcnRuZXJzaGlw IEhlYXRoZXI= YmF5 YXRpc2ZpZWQ= aW5zdGFncmFt X1NlbmQ= IEFTRg== JG5hbWU= IGJvbw== IGTDqWY= X0ZpZWxk IEVkdQ== Y2FuZGlkYXRl cnVieQ== IGFjY3VtdWxhdGU= KEludFB0cg== IGJ1c2luZXNzbWFu IGVjb25vbWljYWxseQ== IFJpbmdz IElucHV0cw== uYQ= YWNpZQ== IEFsYXJt IExvZ291dA== LnNlcXVlbmNl IFZpZW5uYQ== b3By IGRydW1z PWNvbmZpZw== cXVp IGRhdG8= IHBvbHltZXI= IENoYW5nZWQ= V2ViUmVxdWVzdA== IEFkdmFuY2U= IHVuZGVyZ29pbmc= LkNvbnNvbGU= IGN1cnJlbnROb2Rl IFdvb2w= IHDDoWdpbmE= UkVHSVNURVI= IHNhZ2E= IFlPUks= YW1hbmhv 5a6M IEJ1bmRlcw== IERpYWxvZ0ludGVyZmFjZQ== Z2VvaXM= dW5jaWF0aW9u PyQ= LkFzc2VydGlvbnM= IHNlYXRlZA== IFNweQ== UG9zZQ== IkM= IGFob3Jh INGE0LDQudC7 IOuzgA== IHdhcnA= UHJvamVjdGlvbg== IFNpbmdsZXM= IEFkdmVydGlzaW5n TGludXg= dXN0eQ== IHBlbmFs VVNJQw== b2RpYQ== Lm5ldGJlYW5z IFVn IEJyZW50 LWxvZw== L2NhdGVnb3J5 IEN1c3RvbWl6ZQ== aXJlbg== 77yaPC8= aW5hcnM= ICgrKw== R29pbmc= RVhFQw== KG1lc2g= IHBlcmltZXRlcg== Q2xz Y2VpdmluZw== bWVuc2FqZQ== KCkpKXsK IHByb3N0YXRl X2J1eQ== IFJvb2Y= LlJldHVybg== IG1hcnJpYWdlcw== X3RodW1i 574= 4K+N VGV4dHVyZXM= KFRFWFQ= c2hvcnRjdXQ= VHJhbnNmb3JtZXI= QVRJQw== IFNub3dkZW4= c2NyaWJlcnM= bWFya2Vk IOKGkQ== aG9yYQ== T1BFUg== IEZZ IEF1dGhlbnRpYw== IGF1ZGk= cmFtZXI= IExpdGVyYXR1cmU= IGl0ZW1JZA== LkF0dA== KGNudA== IEtT LWxpbnV4 IFBhcnRpY2lwYW50 IENydWlzZQ== aXR1bG8= dXN0cmlhbA== IGNsYXNl ID0k X2RhdGVz Y3VycmVudFBhZ2U= aXhh ZXhhY3Q= IHRzbA== LlNv L2RvY3VtZW50 aGFydA== X0lETEU= e30u eWV0 SXJvbg== IFRocm9uZXM= c25k XHhh IGJldmVyYWdlcw== X3RyYW5zcG9ydA== IGZvaWw= IHRhc3Rpbmc= IGdvZWQ= TWVtbw== IG5pdHJvZ2Vu Lk1lbWJlcg== LmZsYXQ= IGlsbHVt bWluZW50 Lnpvb20= IFB0cg== b2Npbw== IENvbnN1bHRpbmc= IENvbmU= CWl0ZW1z IExN IG9hdXRo IFByb2dyYW1tZQ== b2Nob25k KHNlbGVjdG9y IHdhdGVycHJvb2Y= IE1lcmtlbA== IHN1ZmZlcnM= IG5wbQ== 6LGh IExhbmRpbmc= IExBTg== CQkJCQkJDQo= L2lz IHPDqXJpZQ== IEdVSUxheW91dA== Z2l2ZQ== X0NZ QnJvd3Nl Lm11bHRpcGx5 PSIkKA== dXNv LXBhcmVudA== Lk1hdGg= Lm51bWJlck9m IHRpZW5lbg== IHJlc2VudA== IHBpdGNoaW5n Il0pLAo= LlV0aWxpdGllcw== IG11bHRpcGxpY2F0aW9u OnR5cGU= IHBwcmludA== aWFuaQ== 5YiZ IGxhdW5jaGVy IHJ1Z2J5 546w CgkJCQo= aGlk QW5nbGVz IGdvb2RieWU= IGlucHV0U3RyZWFt LndhdGNo R29vZHM= IFNheXM= PkY= IFN0aWNr IGNlcmM= IFNsZWU= CQkgICAgICAgIA== PEltYWdl IOiuvg== LWVkaXRvcg== cGllY2Vz IERyYW1h IC8vLy8vLy8vLy8vLy8vLy8vLw== IFRhc2tz QVJD Z2F0ZXdheQ== LmdldGN3ZA== Lk1ldGFkYXRh IGd1ZXNzaW5n 5Zyw5Z2A IHNtYXJ0ZXI= IEdldEVudW1lcmF0b3I= IGVmdGVy L29wZXJhdG9ycw== IEdMZmxvYXQ= IGbDuHI= IG9wYXF1ZQ== 5L+d5a2Y U3ByZWFk U1lTVEVN IGludmVyc2lvbg== IEJhc2tldGJhbGw= IHNpbXVsYXRpb25z IGRlbmllcw== IGF2ZXo= X2xpc3RlbmVy IGVuaGFuY2luZw== IE15dGg= IExha2Vycw== X01E TmRFeA== REFUQUJBU0U= IHThuw== YXJ0aA== W2xlZnQ= IGNvbnRlc3Rz c3RpbGU= KEtFUk4= X2Zj X3Bt IHByZXNpZGVudHM= IGhvc3BpdGFsaXR5 IGZhZGVJbg== Uk9QRVJUWQ== X21hcHM= IERlZmluaXRpb25z IGFzc2Vzc2luZw== IHVzYXI= IHF1YW50aXRhdGl2ZQ== bW96 QmVhdXRpZnVs Wygo Ym9ucw== ZnJlcXVlbmN5 Q29udGFpbg== IHB1enpsZXM= IENhc3Rybw== IHZpbGxh IGtpbmRseQ== Rm9udEF3ZXNvbWU= ZXJuYQ== ZXBvY2hz X2RhdGFz CWlw LnBhZGRpbmc= IENvbnRlc3Q= IGVkaXRpb25z IGRpc3Byb3BvcnRpb24= IElDTw== IGNvbWViYWNr PXZhbHVl cmlhZA== LXNvcnQ= U3VibWl0dGVk KG5ldHdvcms= IENlbA== IGluc3RhbGxtZW50 bGFzaGVz Lkxpc3RWaWV3 IFZhdGljYW4= KE1lZGlhVHlwZQ== SVZFRA== cmVhY2hhYmxl Oklz IENJVFk= 5Lqs IEhlbHBmdWw= IGJhxZ8= JQ0K IHBzeWNoaWF0cmlj IHJlY3ljbGVk Rk9STUFU IEdyb3c= YmluZQ== R2l0 LnNz IFdlYXBvbnM= IFN0eQ== X2Fycm93 KnNlbGY= aXJlbWVudA== IGRlZ2xp QXBwRGVsZWdhdGU= X2Jhbm5lcg== IGNvb3JkaW5hdGVk IFdlYmNhbQ== IGNlbGVicmF0aW9ucw== LmFjdA== KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq KHNob3c= IHdlZWtkYXk= IGNvbmNlcnRz 0L7Qu9C9 Y2xpbg== IGNyb24= IE5pbQ== LnNldFZlcnRpY2Fs IEVsbGVu 2LPYqg== IFNBTQ== RWZm Z3o= c3RlYW0= IGFudGlxdWU= cGh5c2ljYWw= IEZvcm1EYXRh LnNldHRlcg== IFBPSU5U Qm9u IGZsYXZvdXI= ZXJ2ZW50aW9u X0VOVElUWQ== CSAgICAgICAgICAgIA== IGludHJpbnNpYw== IOaO YXBwZW5kVG8= YXJhbWVs KV0p IFJlY29tbWVuZA== KW0= T3V0T2ZSYW5nZQ== IGtuaWdodA== IHNhdGVsbGl0ZXM= IFRpdGFucw== IHdlaWdoZWQ= IERhbmE= ZWFzZQ== IHNpcA== U0lN IERldmVsb3BlcnM= bWFsaW5r L2NoZWNr X1BMTA== bnVuZw== IGRyeWVy PUE= LmR3 X1NRTA== IHN1YnBsb3Q= RFJPUA== IHByb3RvdHlwZXM= IGhvdXJseQ== ZGlzcGxheU5hbWU= IGFzaQ== IFZpb2xlbmNl IGFzdHJvbmF1dA== IGRhdGF0eXBl IGluZm9ybWF0aW9uYWw= IGludmVzdGlnYXRpdmU= ZXRlcm1pbmVk cmVuYWw= Oyc+ CWNvbA== Vkc= X2Jvb2xlYW4= cmVjZW50 ICopCgo= IFJhaW5ib3c= b21tZW4= IGx1cg== IG9wcHJlc3Npb24= KCIsIik7Cg== IEZhY2lsaXR5 REVGSU5FRA== IG5lb24= IG9mZmVuZGVy QUZQ IENsZWFuaW5n W10pOg== IHVuZG9jdW1lbnRlZA== LlJlcG9zaXRvcmllcw== IEd1aXRhcg== 0LDRgdGB0LjQsg== U2tpbGxz IHRlc3RpbW9u cnlwdG9ncmFwaHk= IEFtYmVy IFN0YWxpbg== IGxvbmU= IGFwZW5hcw== IGRpZXNlcw== IEFyZHVpbm8= 6L2s PT0t X0FjdA== IGNvZGVk 4pag YW1idXJnZXI= LWxpbmtz IGFybW91cg== LkhpZ2g= Z2V0Q29udGVudA== c3RhZw== IGhlY2s= IOyXhg== IE1jQ29ubmVsbA== IENvbmNlcnQ= IEFsbG9j w6RyZQ== LnJlcGxhY2VBbGw= IHBhcnRpdGlvbnM= cm90dA== IEZsZQ== X1RSRUU= cmVhc29uYWJsZQ== IFJlcG9ydGluZw== IGJpbGxpb25haXJl c2NvcmVz bWlucw== LWV5ZQ== TU9SRQ== YWJvcnQ= IFNXVA== IGludmVydGVk IFRlYWNoZXJz O24= IGFzdHJv 0L3QvtCy 0LDQvdC40YY= cHJvZHVjdG8= Y291bnRyaWVz IE93ZW4= IGNvbnRhbWluYXRpb24= IHZpYmU= IEVsbGk= LnNjcmlwdA== IE9saXZl RE1B dmllcg== OnNlbWljb2xvbg== LW1vZHVsZQ== Z3Jlc3NpdmU= YWd1 X3BsYXllcnM= IHJlc3VsdGFkb3M= c3RhcnRlZA== c2Nyb2xsVG9w PT09PT0= IHdlaWdoaW5n IFtbWw== emFobA== KE5T IEFzc2VydGlvbg== bGVhZ3Vl LnNldFRleHRDb2xvcg== CU1lc3NhZ2U= IG1vbXM= X0FG Lndo QUxT IGF1dHJl XQoKCgo= Lm9wYWNpdHk= IEJ1ZGRoaXN0 IGRlYWY= IE9yZ2FuaXNhdGlvbg== KEdsb2JhbA== ZW5zY2g= IGhlYWRhY2hl IEFsaWVu X2lub2Rl IFN0YXJr IOaJ LWxuZA== b3JlZg== X2ZlYXQ= IHBlZGVzdHJpYW4= IG5vbWluYWw= IGJhbGxvb24= IHNwcml0ZXM= UHJvdG90eXBlT2Y= IEFwb3N0 IEZFQVRVUkU= T0g= IHJlY2Vzcw== IERvbm5h Y29uc3VtZXI= JEdMT0JBTFM= IEdJRg== LWZyYW1l SW5pY2lv IHBhc3NhZ2Vz RGF0ZVN0cmluZw== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== LmJ5dGU= QnVn aW5pdGlhbGl6ZXI= cGt0 b2RpdW0= IERFUg== Lm9wcw== bGVyaQ== IGdpZnRlZA== IGRldGFjaA== dGVycmFpbg== ZWx0ZXJz 44GP LmxvYWRlcg== IE5HTw== c3RybmNtcA== S2g= KGZvbnRTaXpl cm9ja2V0 IHByZWNlZGVudA== IEF1cm9yYQ== IEV4cGVyaW1lbnQ= aXNwaGVyZQ== RW5jb2RlZA== IOKAkwoK IHB5cmFtaWQ= IEFubml2ZXJzYXJ5 b2ZpbA== 658= KHBsdWdpbg== Q29lZmY= IGNvb3BlcmF0ZQ== IHByZWRvbWluYW50bHk= SVNN UGhyYXNl X0RFRklORQ== RmxpcA== QU1JTFk= IE1hcmtldHM= IFN0cmVhbVJlYWRlcg== IENvbWJpbmU= IG1hbnVzY3JpcHQ= enph LHRw V2hhdGV2ZXI= SVRJQ0FM aWdoYm91cg== RGF0YVByb3ZpZGVy LlRleHR1cmU= cHJpdmFjeQ== LlNESw== IHJlY2hhcmdl IGNwcA== IENGRw== KGhvbGRlcg== KHB5 bW90 IHNhdm9pcg== IFJvc2E= IFBDcw== IO2Z Lmhlcm9rdQ== IGZyZW4= IFJpbGV5 YWdhdGU= IHNvbmQ= Lnhsc3g= IGhhY2tlZA== c3RhZA== R2k= IHNhbml0eQ== IFNxbERhdGFBZGFwdGVy Li4uIiw= IFB1c3N5 ICoqKioqKioqKioqKioqKio= IGhhc3NsZQ== X1BBUkVOVA== IFVBRQ== IGJlZ2lubmVycw== KENsaWVudA== IHN0YXRpc3RpY2FsbHk= LmhvdXI= ZWRlbHRh IHRyYWN0aW9u dWVsdmU= YXJhdA== IHNhdW5h SU5WQUxJRA== IGluZGljdG1lbnQ= QUxMRQ== IGRpc3NlbnQ= IFR5cG9ncmFwaHk= IGludGVudGlvbmFs c2l0 IEFuaW1hbHM= IGNvdW50cnlzaWRl IHVhcnQ= fVwi IHNlYW1sZXNz vuekug== IGF1dG9z ICInIjsK Rmx1c2g= QU5OT1Q= IGFsZ2VicmE= YXNzb2M= IFdhdGVycw== IHByZXBhcmF0aW9ucw== cm9ueW0= Wyxd U2Fucw== IGFybWllcw== aXBlZw== IGNyZWFteQ== LmFydA== ZXRyZQ== IEFuaW1hdGVk IHVucGxlYXNhbnQ= ZW1lYW4= Z3JlYXQ= acSF IEVhcmxpZXI= IGNoaWM= IHByZXNlcnZpbmc= KGV4ZWM= IEludmVzdGlnYXRpb24= CUdQSU8= IHJpZ29yb3Vz aWpv PW51bQ== IHRvb2xTdHJpcA== KXNldA== KyIm IEFjY2VsZXI= IGRldmVsb3BtZW50YWw= aXNwb3NhYmxl IGZsYXdlZA== cmVuZQ== VXBkYXRpbmc= IHdhdGNoZG9n IGRlbm9taW5hdG9y IHN1YnVyYnM= IC4uLik= IGNvbnZpY3Rpb25z Y2xvc3VyZQ== LklQ IHRyYW5zbGF0ZXM= LnN3dA== LlRyYWNl IG1ldHRyZQ== LmlzRW5hYmxlZA== IEVmZmVjdGl2ZQ== LnRvSW50 IGVuY2hhbnQ= IHN0dW5uZWQ= IHBvaQ== L2NvZGU= YWRt LmRhdGFiaW5kaW5n IExvcmVt X19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fXw== IGxlZGdlcg== IGNhcmE= IEdpcg== IHdhaXRz VW5v IGN3ZA== 6L6R IFRSZXN1bHQ= IHJlam8= IGVtaXR0ZWQ= IFdlc3RtaW5zdGVy 5LiA5Liq bmVr X1Rpcw== IGVuYWN0 CXdpdGg= b3JnaWE= IGp1ZQ== UGVyZm9ybQ== U1BBVEg= LnRvcGlj IERhdGVu 4bqn IHNpdGlv X01N IlNv YmlhbA== IHNjb3BlZA== UmVxdWlyZXM= IFRPVEFM IENoYW5jZWxsb3I= KGNvbnRlbnRz IHN0ZWFsdGg= ZGV2aWNlcw== LXBhc3M= aWxpaA== IE1hbGNvbG0= IERlcG90 IGNvbmZpZ3Vy YXVzc2lhbg== X2NvbnN0cmFpbnQ= 0LLQtdGC R1JB IFJhdGVz LmRhdGFHcmlkVmlld1RleHRCb3hDb2x1bW4= IE5vYmVs aXRpY3M= IGlnbm9yYW50 IFJlcG9ydGVy IEVib2xh IFNob2Nr X3JlbGF0aW9u IE5pbmph KWM= IHRpY2tlcg== LmlzQ2hlY2tlZA== IFN1cHBsaWVycw== IFJhcGlk TGV2ZWxz 4oKs4oSi CXF1ZXVl IGNob3A= IFVuaXg= cmVqZWN0 LWNhbGVuZGFy KHNvcnQ= w6huZQ== ZXJjaWNpbw== IGhlY3Q= Q0FMTFRZUEU= cm91cG9u IHJlbnRhbHM= YXV0aG9ycw== e25hbWU= IEZJRk8= IGxhc3Nlbg== IE5vdXM= IHNuYXBwZWQ= IGZlcnRpbGl0eQ== ImxvZw== Y2xpY2tlZA== IHBsYW50aW5n IGdi L291dHB1dA== UEVBVA== IGNhdGVnb3JpYQ== IGJhY2g= UHJvZmVzc29y aW50aA== Il0NCg== UmVjb3JkZXI= c2VyZGU= IFRyYW5zbWlzc2lvbg== dHJhZA== IHR1cmJv X1ZFUlRFWA== XEV2ZW50 aWx2ZXI= IGJvZGlseQ== IFNvdXJjZXM= IGtpbGxpbmdz LnhyVGFibGVDZWxs IGZvbGRlZA== L2xlZ2Fs dW5lcg== IFJpZmxl IE1JREk= X1NlbGVjdGVkSW5kZXhDaGFuZ2Vk LlNpemVUeXBl IFdlYlNvY2tldA== IHNlbGVjY2lvbg== U2FuZA== b3Ryb3M= IGVudmlzaW9u L2V0Yw== IE1lbGlzc2E= U3BvdA== 0L3QvtC1 X0FSTQ== QXR0ZW1wdA== IEJJ 44GU IERV IGJhY2tsYXNo c3RyaWRl L2NsYXNzZXM= IHRleHRDb2xvcg== X3N0YWZm b2JsaW4= YWdlbnRh LmNvbGxlY3Rpb25z aWxsYWdl Jw0KDQo= ZmxhdHRlbg== X3NhbGVz X01BU1RFUg== VFc= X2Rh UGl0Y2g= cGhpZXM= IHpvbWJpZXM= IFZFUlk= IFBoYXJtYWN5 IHByb2dyZXNzQmFy IGhhc2h0YWc= U2lkZWJhcg== QHN0b3A= KHBj 0L7Qu9C2 TUFLRQ== IENvcm9u IGt2aW5uZXI= IE1haWQ= Ym9i LnRpdGxlTGFiZWw= IHN1Y2Nlc3Nlcw== IERlbW9jcmFjeQ== IFN1cmdlcnk= IGNvdWdhcg== IGN1cnNv IGxvcm8= aXN0ZW5jeQ== U2VuaW9y w6Zr IEFBQQ== IEJPT0s= 0LrQvg== V1NUUg== ICovLAo= b3lhbA== LnZlY3Rvcg== IFNQRUM= U1NG IGNvbXB1bHM= IEFwcGVhbHM= IFdpbnN0b24= IE1vY2tpdG8= Y29udHJpYg== LmF2YWlsYWJsZQ== ZW50aXR5TWFuYWdlcg== YXJpYXM= X3NhbGU= X3Jz IGRlY29kaW5n IGxvY2F0b3I= b2xpdGg= IGtvbA== IGFzY2lp IFJ1dA== L2ludGVyZmFjZQ== CQkJCQkJICAg IE51bWVy LmZsaXA= LWRlbA== IGJvbHN0ZXI= b25vbWlj IHpt TEc= RmluZEJ5 IGFkYXB0aXZl bG9v IHZ1ZQ== KHJldmVyc2U= X2NhbnZhcw== LnJvbGVz aWZpY2Fkbw== dmVuaWVudA== IkFz IEVudHI= YWxpZ25lZA== IGJlcmVpdHM= Ly8vCgo= Lmd3dA== LmVtcGxveWVl X2NsaQ== IGFudGljaXBhdGU= 6ZmQ IHBpaw== IG11c2hyb29tcw== KHR0 IG9tYQ== IFNhbmNoZXo= X2dvb2dsZQ== LlZhbGlk IEZpbGVOYW1l aXZhdGl2ZQ== a2Vk LXdhcg== IG1hdHVyaXR5 0LjQtA== IG1pbmVy UmVkdWNlcnM= IExhdExuZw== X1NURA== RGlnaXRz Q2FsYw== LXVwbG9hZA== IGhhbmRpYw== 4Li14LmI ZWdyYXRlZA== IFNUTQ== Q2xpZW50cw== IFR1cmJv U1lOQw== IHBob3RvZ3JhcGhlcnM= Lk91dA== LmNoYXJhY3Rlcg== QlVJTEQ= LnVubG9jaw== IGFyaXNlcw== IENvbW1hbmRz KCIiKTsNCg== X0ZPUkU= Oycs KyIn LkltYWdlcw== Iil7 IE1leWVy IG5lZ2F0aXZlbHk= IERMTA== IGV4ZQ== IGRlZmljaWVuY3k= IHdpbGRseQ== LXN3aXRjaA== Y29uc3RydWN0aW9u IGV4Y2VwdGlvbmFsbHk= IExpeg== L2phdmE= IHRoZWlycw== IENvbnRlbXBvcmFyeQ== bGlz LmZpbGxSZWN0 IE5GQw== IHJlaGU= KG51bWJlcnM= IHJhc3Rlcg== IGZpZ3VyaW5n IHNob3dj IEppbGw= IGFyY2FkZQ== IENvbnN0cnVjdHM= bWRs KCd8 IGlkZW50aWZpZXJz IHN0ZWxsYXI= KENvbm5lY3Rpb24= ICJ7ew== eW9y KG15c3FsaQ== IGRvdmU= T2ZCaXJ0aA== LmRpc2Nvbm5lY3Q= X2hp IHp3aXNjaGVu IEdydW5k aXJvcw== X0FycmF5 Lm9uY2xpY2s= YW5zb20= QW5zd2Vycw== CXJlbW92ZQ== RmE= IGh1cnJ5 LWluZg== IGdldENsYXNz IFJlZ3VsYXRpb24= IEZMQUdT bWlzYw== S2Vu X2hlYWRpbmc= R0h6 LWVudHJ5 IGJpb2dyYXBoeQ== U2ln LW1m V2F0Y2hlcg== 4oCcQQ== fXB4 IHNwaWN5 X3Nx TG9zdA== KHRyYWNr 0LDQu9C4 RGVzY2VuZGluZw== PGJpdHM= cXVpbmU= IEFkdm9j X1NO IEhhbm5haA== UE9Q IGVtaXR0ZXI= IGN5bg== IENBRA== Pyku L3NldA== IFNpc3Rlcg== IEVuZHBvaW50 IG1lbm9y IGludGVycA== cms= aWRsZQ== IG91dGZpdHM= LnZlcnRleA== IGNsaWM= QVJFTg== IHBvc3R1cmU= IE9wcG9ydHVuaXR5 dng= IEZvcmJlcw== LkRpcmVjdGlvbg== IHJlc2lkZQ== IHJlbWVtYmVyaW5n bmVzdHk= QXV0b3Jlc2l6aW5n cHJvdmlkZXJz IEFI IGh1cnRpbmc= IExpbHk= ZXZhbHVhdGU= bGlqaw== cGFwZXJz IFNtYXNo IExBU1Q= IHdlbGxz d2FzaGVy X1JPTEU= IERhbmdlcg== Kigo X3JlcG9zaXRvcnk= IFJlc29sdmU= IFJvb21z X1JH IFFU b29w IEhlYXA= IHNsb3dpbmc= IGdyYXR1aXRl X2NhdGFsb2c= IHBvbHlub21pYWw= THk= cGNz Rm94 IEN5cg== IGRpbWlu L21vbnRo U2FsdA== IGhpbmQ= LlBFUg== Rm9ydW0= Y2Vu X3BvbA== 7Zi4 IGluc2Vy KH4= QHRlc3Q= IEdvbGRtYW4= IHVwbG9hZGluZw== RmM= IGtvbW1lcg== IG1pdHQ= X2xvZ2dlZA== IGJ1Y2tz LWxheWVy KX07Cg== IE9N IHZlZw== Y29sb3Vy INC+0LHRig== U3RkU3RyaW5n X3F1ZQ== IFRpYW4= IHNwZWNpYWxpemU= 0LjQvw== INC60Ls= dHJpYWw= LWVkZ2U= IG1hcnM= T0dMRQ== IGVtcGF0aHk= IEJvbQ== IGNvbGxpc2lvbnM= IGNhcnRl IFRlaWw= IE1QTA== IHBvcm7DtA== IGFpcmxpbmVz QXdz TnM= IFNwYXdu KHVzZQ== 6buY6K6k IHlhY2M= c3Rvcg== IGNvbmZlc3M= IHBlcXVl cmFnZQ== PyIK L2RhdGF0YWJsZXM= IFNob3dlcg== X18v IGNyeXN0YWxz IGJ1c2Nhcg== IEhhdXM= aXphw6fDo28= X2VudGl0aWVz lYw= mow= eGNj dmlydA== LWNoZXZyb24= KFJlc3VsdA== Y2FrZQ== Q09NRQ== IHByb2hpYml0 IENoZXNz IGJlYXVjb3Vw INGH0YLQvg== UlVO IElL w7PFgg== X1VwZGF0ZQ== IHNsZWVr IFNwZWNpZnk= X2NyZWRlbnRpYWxz xZ90 IFVzZXJOYW1l CVZhbHVl IGFycmF5TGlzdA== IGV4Y2hhbmdlZA== aXBzaXM= LnJlbGF0ZWQ= IFNlaXRl X0JBUg== IExlbQ== IFdBVENI IENsaWVudHM= IC4q IEVhcmw= LXJlcG9ydA== IGZvcmVpZ25lcnM= IHN0cmVuZ3RoZW5pbmc= CURlc2NyaXB0aW9u KGdv LnRvb2xiYXI= IGNhbGN1bGF0ZXM= CXNvdXJjZQ== IGN6YXM= IHJlY2w= YWJv IGxvY2FsaG9zdA== IF57Cg== LlBvcA== IERlc2lnbmVk XEFic3RyYWN0 SG9sZA== IEd1aWRlbGluZXM= aXBsaW5l IGNhY2hpbmc= LlJlYWRlcg== X2V4dGVybmFs LnN0cnB0aW1l IFdlZWtlbmQ= LU1hcg== IEJlaQ== IHsqfQ== IFJ1ZA== IGV4cGxvcg== IEJvdWxldmFyZA== Q2FzaA== IHByZXBhcmVz IHNlcmlhbGl6YXRpb24= ZXdhdGVy IGFkYw== OgoKCgoKCg== UmVmZXI= IHNjYW5uZWQ= fX0KCg== IEZ1bA== IHRvdXJpbmc= 44OD44Kv Pigo c3VydmV5 IO2Y Li4uJykK IERpdmlkZXI= b3Ns X0NBTkNFTA== X3ByZXBhcmU= c3Rpbg== IEhlYXRo LlByaW1hcnlLZXk= IOKGkA== IExvY2FsRGF0ZVRpbWU= IGNvb3BlcmF0aXZl TGVhcm5pbmc= LmVucXVldWU= IGdvb2c= IFJlZ3Jlc3Npb24= aW1hdGVz IHZveWV1cg== IERyaW5r cGx1Zw== IGxlbmRlcg== bWFuYQ== IHBlcnNvbm5lcw== eXBzZQ== IHVubGluaw== IFJhdmVucw== IGh1cmQ= IHBlcmlvZGljYWxseQ== QVJHUw== IEdI Y2hhcmFjdGVycw== Li4uIgoK LWVzdGFibGlzaA== IGRu KGNvbmRpdGlvbg== IEdyYXZpdHk= IGVzdGFz X2ZvY3Vz Q3JlYXR1cmU= KHNpdGU= IGNhcnI= IFJM IFJJ IE1vdG8= QVNG IEx1Y2tpbHk= CVJvdXRl IGVudHJvcHk= KCIsIg== Q29sbGVjdA== KGNvbnRhY3Q= IEZsb3JlbmNl IHByZW1pdW1z IGxpZmVjeWNsZQ== IGJhbnM= eGVm V2ViS2l0 IEZsb2F0aW5n IGNvc2E= U3BlY2lmaWM= IExvYW5z YnJlYWQ= IGRlc2NyaXB0b3Jz IHs6Lg== VEhSRUFE IFRyZW50 IHNjb3A= UUE= IEFudGFy cGVs X2RpZmZlcmVuY2U= X2NoYW5nZXM= KC4uLik= IFJvdGF0aW9u IExHUEw= IEpVU1Q= KFRhc2s= X3N1YnNldA== IFRSQU5T 5Yqb IFNjb3V0 LXBvcHVw IHNtb2tlZA== X0NsYXNz IHR1cm5vdmVy YnJha2s= IFJvY2t5 dGFz LlJlZ3VsYXJFeHByZXNzaW9ucw== IEVsbGlvdHQ= IFNwaW5uZXI= RFVDVElPTg== IGxpYnJl IG1vbHRv ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg IEZUUA== bXBlZw== KGZlYXR1cmVz IGJhbGQ= IFZpZA== IHNob3V0aW5n TGludA== IHNvY2tldHM= IHByb3c= IG5vdXZlbGxl aXNjYXJk IFNwb25zb3I= IGNvbnN1bHRh KSkpOw== SW5kaWFu IFJhc3BiZXJyeQ== IHRlYW1tYXRl IEpXVA== IEdoYW5h IGNha2Vz cHJpbWVy Zm9ybWE= ZXJnYXJ0ZW4= X01hbmFnZXI= IHByZXNlYXNvbg== R0FNRQ== fCI= IEJyb2Nr IG9jY3VweQ== IGRlY29yYXRpb25z w6FuZA== IGNvdA== IHBhcmFu RGlzaw== cmVtYWlu Pj8= U3Ryb25n IGZyYW5jZQ== IEVyYQ== LWNy LkJ1ZmZlcmVkUmVhZGVy IFBhcmFkaXNl IFZBVA== IEFuZGVycw== IGxpbWI= YW1wb28= IGltcGVyYXRpdmU= VVRJTElUWQ== IFJlY29nbml0aW9u IHJhZ2F6emU= IHBvcHM= eXByZXNz IGVtYmFyZ28= Ly97Cg== IHN5bGw= UFRS 5a2Y5Zyo IGRpZG50 TWFpbGVy IGFjYWRlbWljcw== IEZyYXVlbg== bmVpZGVy LXJlbA== IHJhaW5ib3c= KElu IHNsaWNlZA== PT09PT09PT09PT09PQo= KHNlbmQ= TlNNdXRhYmxlRGljdGlvbmFyeQ== dm9z KHBhY2thZ2U= IG9yZGluYW5jZQ== dmlld2Vy IFNhbnRvcw== LXNlbGxpbmc= IGdvdg== ZXR0bGU= IGZvdW5kZXJz IHdha2luZw== c2xhc2hlcw== LXBvdW5k cmVjaHQ= 2KfYqg== Lm9uQ2xpY2s= IG5vcmQ= c3TDpG5k X3doZW4= VVRFUlM= aWNj IGNhcHN1bGU= IFdpZA== TWFyYw== 4Li4 cm9yZWQ= VUdF TE9VRA== IEF1ZGl0 aXBpZW50cw== b3BpYW4= IFN1ZQ== IHd1cmRlbg== LkhlbHBlcnM= IGZhY3Rpb25z W25w LXRoYW4= IHJlY28= IGthcw== IGNtZHM= L25ldHdvcms= eGJm Z2V0Q29sb3I= IGJpYXNlZA== IExhaw== RGF0YXM= dmVudHM= IOuy X1BT LlZhbGlkYXRl SW52b2tlcg== IG5ldWVu IGp1dmVuaWxl VklTSU9O IGRldm90ZQ== IGxpbmhh IGRpc2NvdW50ZWQ= XENvbmZpZw== IHdvcnRod2hpbGU= IHNraW5ueQ== IENvdXJzZXM= bGV5cw== IE1vcnRnYWdl S2V2aW4= IGFubm91bmNlcw== XSkq cmVzZXJ2YXRpb24= IOaVsA== IHByZWp1ZGljZQ== IFN0cmluZ0NvbXBhcmlzb24= IGJlYXJk LXdpbg== IFPDo28= CW1z amFs IEVhcm4= X3BvcnRz IE5vbWJyZQ== X0NPUg== IEJVSUxE LnNvdW5k WWVsbG93 IGxpbmViYWNrZXI= IGNoYXJpdGFibGU= anVn X05PTk5VTEw= IERlbnRhbA== Ij4kew== CW1hdGNo UnVzc2lhbg== IHZlcnNjaA== IHBpbm5lZA== IGFkb3B0aW5n T3B0aW9uc01lbnU= UGFn IHBhaXJpbmc= IHRyZWFk ZXJjaXNlcw== IFNwcmVhZA== KWk= IEJBRA== X3Rm VUlJbWFnZVZpZXc= cG9wdWxhdGU= YmFi IM+D Wysr IG9waW9pZA== ICMjCg== ZHR5cGU= IFN0YXJ0cw== KCcvJyk= IHBlcnNvbmFscw== LW1hcmtldA== IHJlZHVuZGFudA== IEVzc2VudGlhbA== IHNjcmFweQ== INC40Lw= YWNs IGNyZWFy IEJlbmQ= IHJlbGlldmU= LXJvb20= d2lmZQ== IHbDoA== IFFQb2ludA== IHF1YXNp IG1ldGhvZE5hbWU= XHhj IFBlcnU= L1RoZQ== Lm9ybQ== IHZpeg== L3BkZg== TG9jYXRlZA== IGNvbmZyb250YXRpb24= IENoYW1waW9uc2hpcHM= IGh5cGVydA== IGRq IFVzZXJJbmZv IOWIm+W7ug== XHhi KHNpbQ== ID09Cg== IHN0YWdpbmc= IGRyYXN0aWNhbGx5 5a2m bG9yZHM= Lmxlc3M= 0LLQtdC00LjRgtC1 IEJ1Y2tldA== IE1hbQ== LnRlcm0= X3Bp Y3p5 LnB1Yg== cHJlY2lv IFZpcnQ= IHJvbWFu aXRhdA== TGV4 X2luZm9z xLA= Lm90aGVy VkVMTw== IHBvbmRlcg== IGhhbm5v KFBhZ2U= ZG9p IHBvbGl0ZQ== IHByb2dyYW1tZXI= RGllcw== JGQ= IHJlcGxpY2F0aW9u YWRkQ29sdW1u ZnJpY2Fu IGxlbmc= YmVlcg== b2l0 IHdhc3Rpbmc= eWxpbQ== bWVhc3VyZQ== TmVn IHBhcnRpZQ== LmNvbnNvbGU= IEd1aW5lYQ== VEVM X2ZhY3Q= LmNodW5r IGxlbnQ= IGFsbGVy IOCklQ== X2lkbGU= IGFkbWlzc2lvbnM= SlNPTkFycmF5 IHZpYnJhdGlvbg== LmhlbHBlcnM= 5aSW IGhlbg== am9obg== IOyDnQ== IGp1ZGdlbWVudA== IGdlZW4= dGVycmE= Xns= IEl6 IGPDog== aW5zdGFuY2Vz IHRocmVhdGVucw== IG3DvHNzZW4= S2luZE9mQ2xhc3M= IHN0b3J5dGVsbGluZw== X2RlbW8= cmlhcw== UHJpdmFjeQ== aGlmdA== IFlp ZXNvcg== 7ZWg ZW5zaXRpdml0eQ== LldyaXRlcg== 4LiC RGlzdHJpY3Q= LmdldEpTT05PYmplY3Q= SW1wcm8= KGdldFJlc291cmNlcw== IFNQRUxM cm9kdWNl IHNsb3dlZA== IGxpbmV3aWR0aA== IGhvbmVzdHk= IENvb3Jk IEZvcms= IERpc3BhdGNoUXVldWU= IENsaWZm IFdpcmluZw== X1RJTUVTVEFNUA== b2xsYWg= YXZvaWQ= KytdOwo= c2VtYW50aWM= LWNzcw== IHZldG8= IE1lcnI= IGxlZ2lzbGF0b3Jz Q0VFREVE IHF1ZXN0aW9ubmFpcmU= IFBpbGxz Q2FsY3VsYXRl KGNvcmU= J2U= IGRpc2xpa2U= IFByZWZlcmVuY2Vz X0VYVEVSTkFM 6LCD IGRvZGdl 5pyN5Yqh Lm5hbWVz LmRyYXdJbWFnZQ== X3Byb20= dWNrbGFuZA== IDwkPg== xLF6 L3NpdGU= 6aG5 cm9waGU= IGNvbXBlbGxlZA== IGxhcHRvcHM= IHVuaQ== Q0xPU0U= IGNhc3VhbHRpZXM= IFVuaWZvcm0= VGVybWluYWw= LiIsIg== REFU KFRyZWVOb2Rl IEdhbmRoaQ== KHN0bXQ= QVhC Kk0= IHVtYnJlbGxh YW5pbWFs IGdycGM= IHdoZXJlYnk= IGZsb2F0cw== CWFyZw== IGRiZw== IGV4Y2VlZGluZw== RXZlbnRUeXBl LlNhdmVDaGFuZ2VzQXN5bmM= IHt7ew== IG93ZWQ= YWhyZW5oZWl0 IOyn IGVxdWlwbw== dXJhaQ== IGlkb2w= XSIpCg== X21ham9y IGVudGlyZXR5 aW5nZXJwcmludA== w6dvcw== L2FjY291bnQ= CXJpZ2h0 dXJzb3M= IEVEVA== X0lOU0VSVA== IHNoaW5pbmc= IDw6 RWRnZUluc2V0cw== IGNvbG9uaWVz LklN CSAJ Uk9BRA== Q0NDQw== cGxhY2luZw== IGdldEFjdGl2aXR5 ZW1hY3M= JyUo LmNsaWNrZWQ= IFRoZW0= aXNpYQ== QnVzY2Fy LnJlbmFtZQ== IG9hdGg= IGFmdGVyd2FyZA== IFVGTw== QVBT IEphY2tzb252aWxsZQ== LnNvbWU= Q29uZmlybWVk LnNjYW4= aWdJbnRlZ2Vy RGVjb3JhdG9y c2hpZWxk cmVzc2l2ZQ== LmRpZA== 6K+36L6T5YWl IHNodXR0ZXI= RGFt IHBhcmVudGluZw== ZXllZA== JGl0ZW0= LWRldmVsb3A= IGV4dHJhY3Rz IGRlY2VudHJhbGl6ZWQ= IEVsc2E= X3NwaW4= XSkr LWluaXRpYWw= IG11bHRpdHVkZQ== IHNlbnNvcnk= IE1PREVM IHNhZmVndWFyZA== 7Lk= IGh1bnRlcnM= IFRpbnk= SU5P ZGVjb3JhdGU= IE5vU3VjaA== SG8= KFJlc3BvbnNl IHJ1bGVy CXNob3J0 IGNhc3Rlcg== IGNsaWVudElk IHBkYg== 64+E aXRpYw== IEdhbWVTdGF0ZQ== IG5ld0l0ZW0= KQoKCgoKCg== b3Vpcw== bm9j LkJMQUNL X1ZFQ1RPUg== LS0tLS0tLS0tLTwv IGV4YW1pbmVz CWJsb2Nr IGFkZG9u IHN1cnZleWVk IExpc3RlbmVy IGZyb250aWVy IGxhY2tlZA== SlVTVA== INGN0YI= IHRpbnQ= IE15c3Rlcnk= ZGF0ZVRpbWU= IFR1dG9yaWFs IGZ1bGxOYW1l IERyYWdvbnM= X0ZJTEVT IFByaW50V3JpdGVy IGJlZXQ= IExhZGllcw== X3RpcA== IEphaHJl b3JhbWE= IGluc3VsYXRpb24= KEVudmlyb25tZW50 X2FzdA== YmVyZ2Vy bGVuYQ== b2dlbmVvdXM= X01PTlRI LXByZXNlbnQ= IGZyYW1ld29ya3M= UVE= UEhQRXhjZWw= IGNvdW50ZG93bg== IEZX KGNsdXN0ZXI= OmM= IG9raHR0cA== b2JzZXJ2ZQ== W3BsYXllcg== Lmhl IFBhbmFtYQ== QXVzdHJhbGlh IG91bmNlcw== IGFnZ3Jlc3NpdmVseQ== IHdhcm5z IGN1c3RvbWl6YXRpb24= X1F1ZXJ5 d2lz IGludmFs QUZG KGNhbWVyYQ== V2ly IG5lZ290aWF0aW9u CU8= IHJlc3BlY3RmdWw= IGRpYW1vbmRz J2F2 YXBwcm94 L2Ry IGdyYWJz IGFjY29tcGFuaWVz Y29uc3RyYWludA== IHJleg== KHJlZ2lvbg== IGJhaXQ= dGVybWluYXRl IEJlbGdpYW4= YXNzaXVt IF0NCg== U3lzdGVtcw== b3VzZWRvd24= LmJ1cw== U2V0VmFsdWU= IFByZXA= IGNvbnZlbmllbnRseQ== Lm1pZA== Y2FzZWNtcA== TnVtZXJv ZGFpbHk= IENvZGluZw== KGRlc3RpbmF0aW9u IyQ= dWrEhQ== IGVtZXJnZW5jZQ== X3BhcmE= X0lOQ0xVREU= Izo= IHJlY29nbml6aW5n IGZ1Zw== In19LAo= IGJ1aWxkZXJz IFRlcnJpdG9yeQ== IGluaGVyZW50bHk= IGRlcml2aW5n LmV0aA== IERpbm5lcg== LnNldE9iamVjdE5hbWU= IGNlbGVicmF0ZXM= IHF1ZXVlcw== IE1hcmtz QUxURVI= IERhcnQ= cG9rZQ== X0NIQU5HRUQ= IHBhYXI= bGllcw== LnZvbGxleQ== IE1lYW5pbmc= IE9GRlNFVA== ZW5zaW5n IGZyw6Vu LmxvY2FsU3RvcmFnZQ== IOup KHt9KTsK ZGVjb2Rlcg== IHJvdWxldHRl IGRpc21hbnQ= SXI= IGluc3VyZw== ICcnOgo= LuKAnQo= IGJydW5ldHRl LmFzc2V0cw== X05FVFdPUks= 4LiK bnlt X1NvdXJjZQ== XFRlc3Rz RXNjYXBl Y3J5cHQ= LlhNTA== IHNvdW5kaW5n b3Bjb2Rl IGNsYXNzaWZ5 IGVtYmFycmFzc2Vk IExPR0lO IHJlc2lkdWU= IE5FRUQ= LmRlZXBFcXVhbA== cGVyYw== LWNhbA== UmVkaXM= VHJh KF8p YXNrZXRz Z3JhZGF0aW9u IGVuenltZQ== IFN0ZXBoYW5pZQ== LkludmFsaWQ= J10/Pjwv IGRpc3BsYWNlZA== IGVsZW1lbnRvcw== KGR1cmF0aW9u cm93Q291bnQ= IEZTdGFy bGV0YQ== L3BvcHBlcg== IHN0YXRv IHBlcmZvcm1lcg== IGRpc2NpcGxpbmVz IEZ1bGx5 aWN1bGFybHk= IGVyc3Rlbg== IFBvbHlnb24= IGRpc2NpcGxlcw== LmlzZGly IHRlc3RpZnk= X1NS cHJpc2luZ2x5 IEdMaW50 IHdpcGVk IGNhcnZlZA== IERpc2g= Lmhlcm9rdWFwcA== c3RpdGlhbA== IE1BVENI Y2xhaXI= IERheXRvbg== LycpCg== SURETEU= IGluZnJh IGxpdmVseQ== IGRlcHM= IFsuLi5d CQkJCQkJCQkJCQkJCQkJCQk= IExvbg== RXh0cmFz VHJhbnNpZW50 0LLQtdGA L21vZHVsZQ== IGVuZHVyYW5jZQ== X3RleA== ICJ+Lw== X3lsYWJlbA== IG9iZWQ= L2dhbWU= b3BzeQ== IGZpcnN0bmFtZQ== LmZvcmNl IG1hcnQ= XENsaWVudA== IGxlZ2l0aW0= LmZsYXR0ZW4= Iics b3NleHVhbA== IGpvdXJz TUg= ZXhwaXJlcw== IHN0eWw= LmludGVydmFs S25vd24= IGZvbGxvd2Vy IGRhbGxh cGlyeQ== X3NzbA== aXNobGlzdA== IFJleQ== IHN1cGVybWFya2V0 T2J2aW91c2x5 LWVudGVy IHByb2JhYmlsaXRpZXM= IEhW IENpbmVtYQ== IGN0eXBlcw== IEJDTQ== X1RBQw== O2E= LmJ1dHRvbnM= IHJldHJpZXZpbmc= aWxhcml0eQ== IHVuZGVydGFraW5n CXN0YWNr IGtlbA== IFhlbg== KHBoaQ== IHRvdWdoZXI= IFNlbGxlcg== Y2Fwcw== IEVtYmVy IENoaW4= IGxhdWdocw== Q29udmVyc2lvbg== Lmxpc3RlbmVy JkI= IHBhcmFkaWdt IGp1bmN0aW9u JC8sCg== W28= IENvbnNlcnZhdGl2ZXM= z4A= bGF0ZXM= X0V4Y2VwdGlvbg== IG1laWxsZXVy IHN0cmFwcw== cXVpc2l0ZXM= CXNu IG1hc3NhY3Jl b3R0ZXM= X2dyZWVu VGl0bGVz Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== IFJlZ3VsYXRpb25z YXJs X3Nob3J0Y29kZQ== IERyYXdlcg== IHBhcm9sZQ== IHdpbGRlcm5lc3M= aXNzb24= IEFGVEVS Q3JlZGVudGlhbA== QmxvY2tpbmc= IEhUQw== U2lu KGF1dGhvcg== IGNvcnRleA== Jyl7DQo= 77yJ77yM IGR1bXBlZA== IFNodXQ= IEtleUV2ZW50 CVBsYXllcg== LmdldFBsYXllcg== IGlnbm9yZXM= dG9nZ2xlQ2xhc3M= IEV4Y2x1c2l2ZQ== PigpOw== LmdldFA= YW55ZQ== IG5ldXJvbg== aWZvbGQ= IEtub3du Qml0Y29pbg== QW55d2F5 YXlldHRl ICdbJw== w6BuaA== bWdy IGNvcnJlbGF0ZWQ= IG5hdXNl IG1lbnRhbGl0eQ== aGFzTWFueQ== IEZH YW1waWU= SVRV RnM= LlNw X2JldHdlZW4= RGVwZW5kZW5jaWVz b3Vn UGxhY2Vob2xkZXI= PXRleHQ= IE1hbmFnaW5n b2NhbHlwc2U= 5YyX X21hZw== Zmxk 4pE= Q0FN IEhlbHBlcnM= IGRvc3Q= L291dA== IGFzc2Fzc2luYXRpb24= LmdldEltYWdl IEtlbm55 LicpCgo= KXsvLw== IFJhbmdlcg== IGdlaw== IHNpbmNlcmU= PFZhbHVl IERPVA== IFZpY3Rvcnk= IGxlZ2VuZHM= IHByaXNvbnM= KGV4cHJlc3Npb24= IFJhYmJpdA== X3NlbnRlbmNl IGJpdGVz IG9uRmFpbHVyZQ== IOKIiA== S2lt LmdlbmRlcg== IM67 IFsu Il0pOw== bGFuZGluZw== LWRpZ2l0 VEVNUA== CWVudHJ5 IHN0cnRvaw== IGRlc2NlbmRhbnRz dW1ubw== IGxlYW5pbmc= IHNwZWNpZmljcw== cW4= IFNwYXJ0 IHBvcnI= RURJQVRFSw== IHNlcGVy J2F1dA== IFNURVA= IEJvcmRlckxheW91dA== IHJldHJvcw== IFNhbHZhZG9y IEVOR0lORQ== eGRj VHdlZXQ= dms= IOyy XTw8 aGV0aWNz Y29kaW5n UmVhY2g= LnJlcQ== Z3VpZGU= LnNjb3Bl c2hpcnQ= cm9nYXRl U0VUVElORw== IFByb3RlaW4= IGVpbmc= LkVNUFRZ LmRm IGNsZWFyZXI= IGNyb3Nzb3Zlcg== IFRveXM= IGNvYXRlZA== Lk1vbnRo IEF0dGFjaA== L3J1bg== LnRhYnM= IG9nc8Ol QnJvd24= LkRBVEU= IGZvcw== 5a2X56ym V29vZA== LXRocmVl aGVyaXRlZA== IHJvcA== KGFj IGVtYm9kaW1lbnQ= IEtlbm5ldGg= IGNhbm5vbg== IGJpZGRpbmc= PElFbnVtZXJhYmxl CXNldFRpbWVvdXQ= X2RpZ2l0 IGVsaW1pbmFy KG5l YnVkZ2V0 Q1NJ IOyVhA== IEFTUA== R3JvdXBJZA== X0NPVU5URVI= Y29uc3VsdA== IGlmcmFtZQ== bGVnZW4= X0RFQ0xBUkU= U2hhcnBlcg== IEZyaWVuZGx5 dWxldA== LWNvbW1hbmQ= INCg Y3ljbGVz IFdhc3Rl IHRhcHBlZA== CUJ1ZmZlcg== 4oCUaW4= IAogIAo= IElkZWFs IENhbmR5 X1N5bnRheA== w6p0 7J2M YWJvdmU= IE5hemlz IGZzdA== c2Vpbg== IGt1bm5lbg== d2lr IFNhdmluZw== LmV4dGVuc2lvbnM= IERlc2VyaWFsaXpl b3VyZw== LmF0dHJpYg== 77yaCgo= IFdpbnM= LmVxbA== Unlhbg== X2Fjaw== T1VSQ0VT IG9ucw== Z3Jlc2U= YWZpYQ== TW9kZXJu IGFkaGVyZQ== IGJpb3M= KGFjYw== a2Jk VGhyb3du qeuLiOuLpA== CUh0dHA= CXhtbA== RW5kRGF0ZQ== KHBhcnNlZA== LmdldGVudg== cmVnaXN0cg== bmVsbA== aW9uYXJpbw== LmlubmVyV2lkdGg= cnRs UFY= X3BpZWNl IERlcG9zaXQ= eWVycw== IE5TTnVtYmVy IGdpbnQ= ZW5zZW1ibGU= IG5ld2NvbQ== IFZpZXRuYW1lc2U= X2hw IGFjY3VzaW5n IHF1aXM= IGludmVzdGlnYXRvcg== ZXNzZW50aWFs IENY LmZvck5hbWU= ZGVmcw== IGFuYWx5c2U= X2FuaW1hdGlvbg== IHRoYQ== dGFib29sYQ== IFRIQw== w61jdWxv IGdsb3dpbmc= IGhvbm9ycw== YnN0cmFjdA== a3A= SVRFUw== ICMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyM= I2dldA== L0Rlc2t0b3A= CWdsbQ== IHppbmM= w6F0aWNh IDw8Cg== Vk1M IFVubGltaXRlZA== dnJl LWJlZA== X25vbmNl IEdJ dHJhdmVs IGlzS2luZE9mQ2xhc3M= IGFub255bWl0eQ== RmlyZXN0b3Jl IGVtYWlsZWQ= X0ZMQVNI IGbDpXI= 4piF4piF IDpd SHVt LnJlc2VydmU= w7xt IGtvc3Rlbmxvc2U= IFNDUA== dXRhbg== IEdvcmU= IGNoYXRz Lz4NCg== LmdldFJlc291cmNlcw== IGx1bXA= X2NvbnN0cw== KGV4dA== CWRpcg== 4p0= IHBhZGRpbmdUb3A= IG9ic2Vzc2lvbg== IGJhbm5pbmc= IEFwcE1vZHVsZQ== IHBhcnRpc2Fu IGNhdGFsb2d1ZQ== IG1pbm9ycw== IHBpdGNoZXM= d2VlcA== IHVuZGVydGFrZQ== IHRoZW1lZA== YXVkaXQ= LnNjcm9sbFRvcA== IHJlcg== IHN5bXB0b20= IG9wZW5pbmdz LmJsb2Nrcw== b3Blbmlk IGFzc2g= LXNhdmU= IFBpZw== IHJlZ2Fpbg== IGluaWNpYWw= L2Zhdmljb24= CWV4cA== IHNwaWNlcw== aXNrYQ== Y2xhaW1z bWFr ZGVmaW5pdGlvbnM= IGNvcnJlc3BvbmRlbnQ= IENhbm5hYmlz X18sCg== IEx1Y2t5 IEdhdXNzaWFu IE5lYXJseQ== Q0FE J11dCg== IGFkZXF1YXRlbHk= IFRJVExF Y29uc3RpdHV0aW9uYWw= LW1t X292ZXJyaWRl IGJsYXM= LnJlYWR5U3RhdGU= IHJlbWluaXM= IHJlaW5mb3JjZWQ= IENvbGxhYm9y IGRlY29yYXRpbmc= IGJhY2hlbG9y RVJSVVBU IHVwcmlnaHQ= aXBhdGlvbg== IE5vYmxl IHZhbHVlRm9yS2V5 IHNldExvYWRpbmc= Lklnbm9yZQ== 5YE= R2xvYmFscw== IE1lbnQ= QVNTRVM= IGxpbWJz IEhVRA== aW5jaQ== Lml2 IFFNb2RlbEluZGV4 RnVzZQ== IHBlZGFs X0ZSRVE= KHZlcmJvc2U= IGxvbmdpdHVk IENoYXJ0ZXI= 6re4 IGJ1bmRsZXM= Lmlnbm9yZQ== dW1ibw== RU1B Li4uLi4uLg== c3g= LkNhcmQ= IGhldXRl IHN0ZWVy anVtbGFo IHtf X0NoZWNrZWQ= IGZheA== IEd1c3Q= aXRjaGVucw== ICkpCgo= IHJlbWFya2FibHk= L1hNTA== LXJlbW92ZQ== X2J0 IGluY3Vi LnBhY2thZ2U= LmN1cnJlbnRUaHJlYWQ= IEhpZ2hsYW5kZXI= LnNpZGU= c3BsYXNo IGljaQ== PUQ= IHB1Y2s= IGJhbGxvdHM= IGh1Z2VseQ== Y29lZmY= IHBEYXRh LkNPTFVNTg== IEhlYWxpbmc= IG9yZGlu ISks ICcnLA0K KG1k IFNhc2s= PHN0cm9uZw== IHN1cnZpdm9y LnNlcmllcw== IGNhZmZlaW5l IGAo LlRSQUlMSU5H X0lucHV0 KCJe emQ= Jik7Cg== IFBpbmc= IHZvdWNoZXI= LnJhdGluZw== LXNoaXJ0cw== IFJldHJpZXZlcw== LmFsaWJhYmE= T3JhY2xl X01PVg== T2xkRGF0YQ== IC8qDQo= IGdib29sZWFu ID0+DQo= IHLDoQ== IGJsdW50 IEltYWdlSWNvbg== aWZpaw== UlRD IGZpYmVycw== IHRvaWxl LnNlbnQ= IFB5UXQ= JGFwcA== IG1lZGlv IGdyYW50aW5n IHRzbGludA== IE3Dtg== KGZpZ3NpemU= IGh1cnJpY2FuZQ== IGxpZmVz IMOE cm9jZXNzaW5n X3N0YW5kYXJk LW9wdGlvbg== JykpKQ== IHZhY2FudA== 5bel IEhvbGxvdw== aGFuZGxlQ2hhbmdl IGRpdmlkZXI= IEVuZ2luZWVycw== IHN2ZW5z IGNvbXBsaWFudA== dGFuZ2dhbA== IENyZWRpdHM= IEVtaXJhdGVz UnVsZUNvbnRleHQ= IHJlYWxpemF0aW9u IGRpc3RyYWN0ZWQ= XSs9 IGF1Z21lbnQ= IER3 b3Rw b3JyZW50 RWRpdGFy LnN0b2Nr U3R1ZHk= cGVjdGlvbnM= IEdhbWVNYW5hZ2Vy PWN1dA== IGZsb2Nr IFJvbWFucw== dGhlbQ== LWhvcA== IHNjcmVlbnNob3Rz IC8qIQo= IGNvbnZlcnNpb25z IG5vcm1hbGl6YXRpb24= KGNvbmZpZ3VyYXRpb24= IGFlcm9z X3NlY3VyaXR5 IScK Qm9udXM= IERSSVZFUg== CURhdGU= dGll IFd5b21pbmc= U3RhbmQ= aXRyZQ== IHNob3BwZXJz IGRpc2FkdmFudGFnZQ== IGxpa2luZw== 56yR IHVuZGVyc3RhbmRhYmxl U0VF IGhveQ== IG5pbmV0ZQ== IGNvbmZlcg== IG5vd3JhcA== IFZlcm4= LA0KDQo= aW1lc3RlcA== TGF5b3V0TWFuYWdlcg== 4Lc= CXdhaXQ= UExFVEVE SmFwYW4= IGluZHVjZQ== IOWv 0L7Qt9Cy X0VORFBPSU5U Lmhvcml6b250YWw= IGFjY2VsZXJhdGVk cmltb24= SVZFUw== VHJhbnNhY3Rpb25z TGVhbg== IFNPVVI= d2hldGhlcg== eWc= IG9pZA== IEVudGl0eU1hbmFnZXI= T1VOVFJZ IGZpbGE= T0xVTU5T SU5VRQ== IEFuY2hvcg== VFJBTg== d29v YmxvY2txdW90ZQ== IE51cnNl IENhcnA= IHJlZGVlbQ== LnRyeQ== IEpQ IHRpbWVzdGFtcHM= ID8+Ij48 IFJFTU9WRQ== IFN0YXJidWNrcw== UmVhbGx5 IGZsb29kZWQ= LkNhbGxiYWNr RHJvcERvd24= aXBybw== IHRlbmRlZA== bHRl IHByb3BvcnRpb25z LXRl IFJlbmE= bGljYXRl Zm9yY2Vz LmV4dHJh LmF1dGhlbnRpY2F0ZQ== 0LLQvtC0 obA= IGZvckNvbnRyb2xFdmVudHM= IHNlbmhh IGtlaW4= IG1pbmlzdA== IFByZWZlcmVuY2U= IFRlbGVncmFwaA== 0YPQvw== c3RycG9z IGlsbG5lc3Nlcw== IHBpZ3M= IGdldEludGVudA== U29s IMKh KGNwdQ== W3Byb3A= c2NyZWVucw== Jyk7Pz4= IEFjdHM= IHN0cmR1cA== IGF2ZXJhZ2Vz YW5hbA== IENhc3VhbA== R3JvdXBCb3g= IEhhbmRib29r L2NvbW1lbnRz IG51bWJlcmVk IGJyb2FkY2FzdGluZw== 55uR Lm5hdGl2ZUVsZW1lbnQ= Lm11 IHVwZGF0ZWRBdA== IERvZXNu LkFD LmNvbGw= IHJlY29yZGVy X3NoYQ== Qmc= Ymls IGJvbHRz IOes IGltcG9zaW5n IEluZm9ybWF0aW9uZW4= X2ZsYXNoZGF0YQ== ZWNvbm9taWM= UmVtYXJr dWNhcw== IE9mZmljZXJz IFRFUg== V2Fsaw== IG1lcmNhZG8= X2dlbmVyYXRl SFk= Q2FsbGluZw== c25hcA== c2NyaXB0SWQ= Lm9wZXJhdGlvbg== IEZsYW1l bGluZXNz IHJlbnRlZA== X3RvZ2dsZQ== LWNoYW5naW5n IFRZ J3V0aWw= RUVQ IGdyYXBocWw= IFVuaQ== IGltcHVsc2U= LkJhc2lj IGVuZXJnaWVz TUFSWQ== IE1hcmNlbA== IG1vcnRhbA== IGZyZXM= bWVucw== bW90aW9u IHNhbXBsZWQ= 4oCcVGhhdA== aWRheQ== cXVpcG1lbnQ= Z2V0SW50 IEFic29sdXRl LCci dW5lZA== LnNoYXJl IH0pKA== bW1t IFJpc2luZw== 5Lu7 IHVuZW1wbG95ZWQ= eGZh LmZvbGxvdw== CQkJCSAgICAgIA== c2x0 LlBob25l IGtuaXZlcw== IGV2ZQ== b25DbGljaw== XSkpDQo= IFdpdG5lc3M= CU5T IEVPUw== IFN0ZWZhbg== IFByaWVzdA== 4oCUd2hpY2g= R2V0U3RyaW5n LkJ5 IHVwc3RhaXJz IGRldHJpbWVudA== YnJva2Vu ZW1icm8= IG5pY290aW5l aWxpb24= IGFzdG9uaXNoaW5n X2FmZg== IExlc3Nvbg== IGFjY2lkZW50YWw= b2Rvcg== IGRlY2ly IG5ld05hbWU= Ky4= 55u4 aWdzbGlzdA== IEdpdGh1Yg== IHN1Y2Nlc3NpdmU= cmFjaWFs IGVudmlyb24= 6aqM6K+B IHJlZGlyZWN0ZWQ= VE9UQUw= IGdyYWJiaW5n IExhbmNl IGZvcmZl X0NC 5b6u RWxhcHNlZA== X3dheQ== KERpYWxvZ0ludGVyZmFjZQ== X21lYXN1cmU= eGJi RG9n RGVwYXJ0 LXNyYw== cmVzb2x2ZXI= d2l0aHN0YW5kaW5n X3NoZWxs IExhc3ROYW1l IEF2aWF0aW9u IGJlZ2lubmVy KCIlLg== KHRvb2w= INC90L7Qsg== OmluaXQ= KEFQSQ== IE1vcnJpc29u dnRDb2xvcg== IHN0YXBsZQ== L0lORk8= IHN1cGVybmF0dXJhbA== IHN0ZWFr dGltZWxpbmU= enpsZQ== ImAKCg== U2Vjb25kYXJ5 IE5lcGFs LlN0cmluZ1V0aWxz IGFkYW0= ICguLi4= IHN1YnN0aXR1dGlvbg== IGJvYXJkaW5n IEtleXdvcmQ= IEFzc2F1bHQ= ZGJjVGVtcGxhdGU= IG9yZGVySWQ= KGVuZ2luZQ== LmFzc2VydFRoYXQ= IFZlbnVz IGhvbWljaWRl IEF2YWw= IGd1dHRlcg== IFN1cHBvcnRlZA== L3BhcnQ= IGFjY2xhaW1lZA== SGlzdG9y IG1lc2Vz w7xiZXI= IFJlbmV3 IGdyYXM= IEVr IGluZmlsZQ== aW5keQ== Lm11c2lj LlNjcm9sbA== IEFnZXM= IE5hcnV0bw== IEdhdGhlcg== IGNvbmZpcm1pbmc= PSgi IHBpdGNoZWQ= b2xleQ== RnJhbmNl Kyci JHRvdGFs IG9uZGU= IGRpdGNo X3NpZ21h IGNvbnRpbnVpdHk= cmV3YXJk LWxvYWQ= IHByb2Nlc28= TG9ja2Vk c3Rhdw== IHNwaW5hbA== bGF6eQ== IT09 amVzdA== IGR1bg== IFJvZGdlcnM= CWdyaWQ= IGxvZ29z IEJlbmdhbA== LnN1cGVy UHJvdmlkZXM= IG51dHJpZW50 LlRpbWVzdGFtcA== SVpBVElPTg== 5YaM IGZhdHM= IFh4eA== Y3RpY2E= VGFyZ2V0cw== IGNvbnRvdXJz IHJlb3JkZXJlZA== OkFycmF5 IHRvbGVyYXRl Vmly IHRlcnJpYmx5 IGJyaWNrcw== KCZf aGI= UG9ydGFs IEJyZWFk LndoaWNo wq10 YXNJbnN0YW5jZU9m IGpvYmplY3Q= CWxlbmd0aA== X01U OyI+DQo= X0VYSVNU IG1hdGVybmFs UkVM IOqyveyasA== aGVl IGxheW91dHM= IExhcA== YWlzeQ== IHN0dW1ibGVk IFVJRw== IFNjbw== IGltcGFpcmVk UkVTU0VE IGFidXNlcw== VkY= QVJC Lk5BTUU= cmNo cHJpbWly X2NvbXBsZXRlZA== IHBlbm55 Q2hyb21l KGJlZ2lu ZXJuZW4= LWNoZWNrYm94 UGxhaW5PbGREYXRh IExQQw== cmFkZQ== c3Bpcg== IGNvbmNlaXZlZA== VGlwcw== IElvVA== IEdhbg== 6IGU IGJpYXNlcw== IGNvbnN1bHRhbnRz cGxlZA== X2h0 YXNzb2NpYXRlZA== XSwKCg== IGRlbGlnaHRmdWw= INGC0LXQug== SGVsdmV0aWNh KGxvYWQ= LWV4cGFuZA== X1dJREdFVA== dG9h IEFrdA== IG9tbg== IGNsYXVzZXM= SW50ZWw= Ki99Cg== X3JlZ2lzdHJhdGlvbg== IG9sZFZhbHVl IHJlc3RvcmluZw== IHVucmVhbA== T1ZFUg== CQoJCgkK QVRT X3Byb2Jl IGRpdmlzb3I= LnVwZGF0ZUR5bmFtaWM= 5bmz UHJvZHVjZXM= c3RhbXA= Lmpib3Nz CXRhc2s= ISg6 IHBzeWNoaWM= QGNsYXNz TWFydGlu IFBhc3NlZA== Y2xhcmF0aW9ucw== aGVs 0LDRhw== CWNvcHk= LWJpbg== emFu aWdyYW0= 4Ka+4KY= KHNpZw== IENhdmFs XyMj ICU9 b3V0bGluZWQ= IEFjaWQ= IHVucHJlZGljdGFibGU= LWRhc2hib2FyZA== SGV4U3RyaW5n K2M= LlB1YmxpYw== 4bqp IGNvbnZleW9y IEVC IHNlbGVjdHM= IGtub2NraW5n IENlYw== SUJVVEVT b3dhxIc= Z2F0c2J5 KnY= ZW50cm9weQ== IGRpc3BhdGNoZWQ= IGNhbWVs IFNhdHVybg== IG92ZXJ3ZWlnaHQ= KHBob25l cGFyYWJsZQ== JUI= X3ZlY3RvcnM= IGJyZXdpbmc= IFRr IERvd25sb2Fkcw== IFNhdmVk LlByaWNl IGN1cnZlZA== IFBhcmVudGhvb2Q= 6LY= LnBubA== cGxldGVseQ== LkRheQ== IGFkdmVydGlzZXJz IGVqZWM= IHByemVk 668= ISc7Cg== IEt1c2g= IFRBQg== IHF1ZXN0cw== IGNvaW5jaWRlbmNl dW1taWVz IEthc2htaXI= IEV0aGljcw== X2dyb3d0aA== IGFrdGl2 IGdyb3VwaW5n 5aKe X3RydXRo 5ZCs dG9kb3M= aXNldA== VGV4Q29vcmQ= w6R0dA== IFp1cg== cm95cw== X01BR0lD IGJyZXdlcnk= KFN0YXRl IFNNQUxM IFBsYW50cw== aXRiYXJ0 ZWFjaGVy IEFkZWxhaWRl THU= IGZpY2s= dW5kbGVz X2xvYWRlZA== 0LjQtQ== UG9sbA== cml0aWM= RUxZ ICsn IFByb2Zlc3Npb24= IHN0YW1wcw== IFNldw== c2Nyb2xsVmlldw== IGNvbW11bmlzdA== L3Byb2JsZW1z fQ0KDQoNCg0K LG8= IHVkcA== IG9iZXNl YXBwcm92ZQ== YW5jZWxsYXRpb24= X0dhbWU= IEhhc2h0YWJsZQ== YWRhcHRpdmVTdHlsZXM= IHBvc3Nlc3Nlcw== Lm1hdGNoZXI= ZnVuY3Rpb25hbA== TXJz CXNhdmU= IERiVHlwZQ== IGtlbg== Z2V0Q29udGV4dA== IG1hbnM= KHJlbA== IEJyb3RoZXJob29k KWAK 6Kej LkluZm9ybWF0aW9u T3V0T2ZSYW5nZUV4Y2VwdGlvbg== IFNlaw== Q2Fz IGJsb2dnZXJz RWl0aGVy KCIiIg== IHBpbmNo IGNvYXJzZQ== KXA= IFB1bHNl IGxlYXJudA== IGRlbnRpc3Q= IG9uY2hhbmdl IGRpcmVjdGl2ZXM= KGFjdGlvbnM= bnlkZXI= IFNoaXI= VHJhaXQ= X2RlcA== IFBFVA== IFJFUA== LkFwcFNldHRpbmdz Y3VhZG9y aWRlbmF2 IGVudmk= IHNsYW1tZWQ= IFNob290 IGRhdGVGb3JtYXQ= LmpvZGE= dmV5cw== ICkuCgo= IGNhcmVn IFBhcmFsbGVs X3RyYW5zbGF0aW9u LmZ1bmN0aW9ucw== Lm9icw== UnVudGltZUV4Y2VwdGlvbg== W109 b3ZlcnZpZXc= IFNjaGw= IG5vaXN5 IE9uUHJvcGVydHlDaGFuZ2Vk U2VuZGluZw== IHVuZmFtaWxpYXI= VXBvbg== IFByaW50cw== LnR5cA== IGZsZWVpbmc= CW1vdmU= KFVu IHFy 15w= X2JldGE= IHNraWVz CW1l V05E IHN0aWNrZXJz Ymxhcw== IGluc2VydHM= IHZlcnNlcw== IERldw== IHRhbmdpYmxl IGhlY2hv UE9M IHRlYXJkb3du b21uaWE= SUJF LmNvdmVy X3N0cmF0ZWd5 Xi0= c2V0UG9zaXRpb24= dWFsZQ== U2lnbmVk IGlmYWNl YXNlbGluZQ== LnNldFRpbWU= IE1pbmVyYWw= IEZpZ2h0aW5n c2tpbnM= IGRpc2NyaW1pbg== IGRhbnNr IFByaW5jZXRvbg== YWNpc3Q= ICgpKTsK dHJhY2tz aW1vbmlhbA== YWRlY2ltYWw= RVBST00= dWdnbGU= Lk5vdGlmaWNhdGlvbg== JG1haWw= Y2FudGlkYWQ= IEp1bmc= IHNlZWtlcnM= IHBsYXVzaWJsZQ== dGllcg== 0LXQtg== IHJhcHBlcg== IE1hbmE= IEh0dHBTdGF0dXNDb2Rl IGJ1cm50 bG9zZXM= IEZvdG8= IEpzb25PYmplY3Q= SW5zdGFncmFt IHN5c2NhbGw= IHJlYWxpdGllcw== IE1BVExBQg== Ol57Cg== VEVSTQ== IENiZA== IFBhcmFncmFwaA== IHRyYXbDqXM= IGNvbnN0cnVjdGluZw== IHN3YWw= IHBpZ2U= TExMTA== LWV4aXN0aW5n R2V0cw== IG1lbHRlZA== IG1pdGlnYXRl SGVu IGht aW1hcw== IEFv IFBlcmV6 IERBTA== IOuLpA== IGRpdmlz U3Rvcnlib2FyZFNlZ3Vl IE1vZGlmeQ== IMOcYmVy X09WRVJSSURF LnBlbQ== dW50b3M= IGVzcGHDsQ== IHs/ IFBBWQ== X2lwdg== IEZ1cnk= X18uX18= ZWxvdw== LWNlbnRlcmVk Y2hlY2tz X1JlZw== LUphdmFkb2M= CWxvYWQ= IExpa2V3aXNl 2KfZhQ== VU5F LnNlbQ== eGNi IENhdmU= X3NsZWVw IHNpbGVudGx5 IEV4dHJlbWU= LlRvVXBwZXI= CUNIRUNL IGN1ZQ== IFFCeXRlQXJyYXk= IGNvcnJ1cHRlZA== IETDqQ== IGltcGVk R2V0TmFtZQ== IGluYWNjdXJhdGU= IHNvYmVy 0LXQtQ== IGJhcmNvZGU= LS0pewo= aW5raQ== IMOpcA== IGRyaQ== IEFMVA== Pj4+Pj4+Pj4= b250YQ== W0w= IGludGVyZXM= dmVydGluZw== IGRpYWdub3N0aWNz cGRldg== 6Kk= IEludGVncmF0ZWQ= KS4n X2dj JHRleHQ= LmdhbWVz IFRlcnJh J1Jl LnRyYW5zZmVy X0ZJRk8= Z2V0TW9kZWw= IGJsYW5k IENvbGVtYW4= IHByaW1lcw== IOaI IGNyb3NzZXM= bms= R0lORw== ICde IEJsb2I= IGludGVyY291cnNl IEJsdmQ= IHdlaWdocw== X3JlZ3VsYXI= IFBlcnRo IHNlcGFyYXRpbmc= IGJpbGxlZA== LnRhYkNvbnRyb2w= IHB1cHBldA== IHV0aWxpemF0aW9u IOKWoA== IHN1Y2Nlcw== IGxhbXBz X3Byb2o= RXJpYw== IHJlbm92YXRpb24= IEZhbWlsaWVz IEJpdHM= cGFydGlhbHM= LU1lbg== c29sdXRpb24= IGR3YXJm LklOVEVHRVI= IExPQ0s= LmN0 IGV4Y2VycHQ= IFBpeA== IEZpcnN0TmFtZQ== QU5URUQ= IEFkbWly LWhlbHA= UHJpb3I= IEFsaWdu LklOU1RBTkNF TGluZUVkaXQ= KCcvOg== IGluZXQ= b2R1cw== LnBrbA== IEtZ dXBlcnQ= IG5lcnZlcw== X2dyYWRpZW50 fScsJw== X3VucmVm IHNhdHVyYXRlZA== IENvbm5lY3RlZA== IEZO RVhJVA== IHRlbGVwb3J0 IGF2YWl0 UGFnZVJvdXRl IGRpdm9yY2Vk KGxhbmc= ZnN0 IFR5cg== IG1lc3Nlbmdlcg== aWZzdHJlYW0= WFM= IEJhbmtpbmc= IGluZmVjdGlvdXM= IE1vbnM= X0xPT1A= IHp1csO8Y2s= IG9idGVuZXI= L3JlcG9z VmVs YWNybw== IHVzZXJSZXBvc2l0b3J5 c3R5bGVUeXBl IFNSQw== Vk1MSU5VWA== cmVjdXJzaXZl L2Jhcg== X2NoaXA= b21pbmF0ZWQ= IE5pdA== 4oCUdG8= IEJ1ZGRo 0L7QvNC10YA= IE1BRw== IENIRQ== X2Rlbg== LnJhaXNlcw== X2RlZ3JlZQ== IHB1bXBraW4= X3RlbXBsYXRlcw== X01FRElB IFRpbWVsaW5l IGJvdHM= T2JqZWN0VHlwZQ== IGJ1eXM= LnBvc3Rz Q0FM d2FpdGluZw== IERhbmllbHM= IGRhYmVp IFNpZ21h aWxvcg== aWdlbA== LFc= QURT KHBhbmVs 7LK0 aXRhdGluZw== LnBhbGV0dGU= IG1vc3F1aXRv IHRlZ28= KHBhcnNlSW50 IGRlc3B1w6lz cHJvbWlzZQ== IHdpag== dHlwZXNjcmlwdA== IFR2 X0lERU5USUZJRVI= KS4KCgo= X2ZsYXQ= aXRzdQ== VVNS ZXhwZXJpZW5jZQ== LWZpdA== cGhpbng= X3RocmVzaA== IGlkZWFsbHk= IEZyZWVtYW4= LERC X3J3 562J VWI= X3N0YXRpc3RpY3M= PSIiPjw= IGNob3Jl IHlvcms= aW5zdGFsbGVk QWRkaXRpb25hbGx5 IHBzdG10 eWxrbw== OjoK Rm9yZXN0 IGhlYWRzZXQ= IGdhbGxvbg== 0YDQtdC8 IHdpdGhkcmF3bg== IENhbmRpZGF0ZQ== IG1lbHRpbmc= IGZyZWV6ZXI= IGhs X0hFTFA= bWltZQ== KC8q IHRoaXJzdA== JHJldHVybg== bWVtYmVyb2Y= 0LXQsQ== IEh0dHBTZXJ2bGV0UmVxdWVzdA== KG9i X1Jlc3VsdA== IGFzc2VydGVk IGZ1bGZpbGxpbmc= IHN0cmV0Y2hlcw== cGFyYXRlZA== LWZ1bmRlZA== IOWb aW5nbGVz X2Nh LmNvbmRpdGlvbg== IERpc3BsYXlz IG9yYW5n IENSRQ== IGdsQmluZA== IFNlbGVjdG9y L3R5cGU= IEFsZXhh Y2hlZHVsZXM= IFBlbmluc3VsYQ== IHBhcml0eQ== CWRlc3Q= IERvb3Jz DQoJDQo= X2RpbWVuc2lvbg== IGFsb2Fk LlN0b3JlZFByb2NlZHVyZQ== KHBhcmVu IEJ1cmtl JyldCg== LWVuZ2luZQ== IHF1aXI= IEh5YnJpZA== IERvZQ== IG91dGxpbmVz IFRyZW5kcw== X05W cGVyaW1lbnRz IEhpbg== Pycs CVRleHQ= RlVM IHNtZWxscw== IHNsaWNr IG1pc2VyYWJsZQ== IEFycmF5QWRhcHRlcg== IHBhcmFtU3RyaW5n SG9t X2xpdGVyYWxz dXN1YXJpb3M= IHByb21wdGluZw== X2xhenk= IEFjdGl2YXRpb24= X29j V2Vhaw== IGFuZWNk IFVDTEE= PXJl aXNzZW1lbnQ= IEVzY29ydHM= RXhjZWxsZW50 IFBhdXNl IHJlcG9zaXRvcmllcw== VE9S YXJpYXRl X2lzbw== dXBkYXRlcw== aGFsYg== dWRpYW50ZQ== 66Gd IG5haXZl IFBlZw== IExvdW5nZQ== QVJHSU4= KGJpbg== T25DbGlja0xpc3RlbmVy IEZBSUxFRA== IGxpdGU= IGR6aWU= IExpdGVyYWw= aXZvcg== ZmNudGw= IGVhdHM= IHFlZA== VW5sb2Nr cmlkaW5n dW5kYWk= PU0= QVRURVI= Q29uZmlndXJlQXdhaXQ= aWNpYXM= dXN0b21lZA== IHN1Y2Nlc3Npb24= ZW5kVGltZQ== IEp1cGl0ZXI= IGp1ZGdpbmc= ZHJhdGlvbg== X2RvY3M= Lm1v IGVkdWNhdG9ycw== IFZpbmU= Q29uZA== W291dA== cWI= XFZhbGlkYXRvcg== IG1lYW5pbmdz IHByZXNlbnRseQ== IGRpdmlkaW5n b3R0ZW5oYW0= YXNjdWxhcg== IHRyYWlsZXJz IENMT1NF 0LDQvNC4 4oCZYWk= IEdhaW4= d29y IHBsYW5uZXI= IGRpc3RyaWJ1dGluZw== dmF0 bW9udGhz eGxhYmVs SEY= VmlvbA== LkJBU0VMSU5F 0LXRgtGB0Y8= IFJvdGF0ZQ== IHR4bg== OmJvbGQ= IGJsb3Nz Rm9yZ2VyeQ== KGVtYmVk IGpha28= c3ByaW50Zg== dGhlaXI= IGV4aGliaXRz LXN0YXRpYw== aGVjeQ== Z2V0QWN0aXZlU2hlZXQ= LmNsaWVudHM= 44GN X2hpZGU= W3dvcmQ= Q2I= YWRkSXRlbQ== YXhl X3JhZGlv YWxpb24= bW9kaWZpZXI= IHNhdHVyYXRpb24= IGRlbm9t X3BpeGVscw== bWVzcw== KGZs YXRpZg== IHNlY3M= IHByb3N0aXR1dGlvbg== IGdyYW5kY2hpbGRyZW4= IHBhcmFkaXNl IEZlbGQ= X0JJTkFSWQ== aXRvdXM= 4LmE IGZsYXNoaW5n LXNpZGVk IGNvbnRyYWRpY3Rpb24= LyoKCg== eWxhYmVs IFRldA== IGFkbWlyZQ== cmVzbw== IGxldHo= IFNFQVJDSA== c2xvdHM= IFJld2FyZHM= IEhvZw== IE5TRGF0YQ== c3Rhc2g= RmFsbA== IEFtZXI= TGluZWFyTGF5b3V0 L3Bob3Rvcw== IGZlYXRoZXI= IHwNCg== RG93bmxvYWRz LlN0YXJ0c1dpdGg= IC8vIw== aW5lVHJhbnNmb3Jt IGFmZmlk VnRibA== IFJvZ3Vl c2NyaWJlZA== IGZhdWM= IE1vbnJvZQ== IGRlY2xhcmVz bW9kZXJu cmVvbg== YXliZQ== UEFTUw== ZmVycw== X01VTFRJ IE1hdGhlbWF0aWNz IHN1ZGFo X0FUVEFDSA== IG51bWJlcldpdGg= IFNvbG9tb24= amlu b2dyYWZpYQ== w7Zs X2Rlc2lnbg== Y3VsYXRlZA== IEx1bmE= aWVzeg== ID0+Jw== IHJldmVsYXRpb25z QWxvbmc= KGVk IEZpbGVuYW1l IHlsYWJlbA== U2VjdXJl IGJ1c2Nh YWdub3Npcw== X1JFQ0U= IG92ZXJsYXBwaW5n RXh0ZW50 IGFudGljaXBhdGlvbg== Q2hlY2tz IEFMU08= b3Jj aWxpbmd1YWw= aXRhdGlvbmFs IGFkdmFuY2VtZW50 b3Vybw== IFByZWRpY2F0ZQ== 5b6X ZXJpYQ== IFBpZXJjZQ== b3Jpbw== IG1lcml0cw== IHBlYW51dA== LlBhY2thZ2U= IENvbmR1Y3Q= X1NFTlNPUg== IGJvaWxpbmc= IGludHJh IElHTg== IEZ1cg== LlJlZnJlc2g= IFJlYWNo X2RlY29kZXI= LkV4cA== INGC0LDQug== cGlsbA== LFE= IEdyaWxs IHBvcHBpbmc= LkFn IHByb3llY3Rv IG1pbGVhZ2U= IGVjb2xvZ2ljYWw= XV0pOwo= IMKt c3VicGxvdA== YWNhZA== IFRyeWluZw== cmVjaXBlcw== JGNyaXRlcmlh IFBlcnNpYW4= LWJvdW5k TUFTSw== IEdlc3R1cmU= IGtr IFBWQw== IHByb2hpYml0aW9u IGNvbWFuZG8= IExPT0s= U2hvcHBpbmc= IGRpc3RvcnRpb24= PEJvb2xlYW4= LkdldExlbmd0aA== dW1wdA== XFByb2R1Y3Q= ZWxsZXJ5 IGZpcmV3YWxs Zm9ybWF0dGVk LnJlZGlz IGVzYQ== IFJob2Rl U29t Lm5vbg== ICcpLg== IGdldFZpZXc= 4bqhbg== cHJ1cw== TWF0dGhldw== IHNpYQ== IEZvcnM= R1BV aWVudHJhcw== X0lOU1Q= IG9sYXJhaw== IGltcG9ydGluZw== VENQ LyIpOwo= ZWl0aGVy IGZyZXNobHk= Y2FzY2FkZQ== KGNoYXJhY3Rlcg== IEplZXA= b3RpY3M= X1VUSUw= Llh0cmFQcmludGluZw== LmZpcnN0Q2hpbGQ= IEV4Y2VsbA== IGR2ZA== IHRhbGxlcg== IHJhcw== eXBhc3M= IGFzc2lnbnM= IGdyaWV2 LW1vcmU= SkQ= IEJ1cm5z Jz4NCg== LkRlcGVuZGVuY3k= LlF1ZXJ5U3RyaW5n Lk93bmVy IGV4cGlyeQ== VGh1 KFZlYw== IGhhemFyZG91cw== IHJwbQ== QVBPTg== IGFkZFRhcmdldA== c3ZpbGxl cE5ldA== IEltZw== IFRJTUVS LkFuaW1hdGlvbg== IGJlaw== IGFzc29ydA== IGxlYmlo IGJvZHlQYXJzZXI= IHZpYnJhdGluZw== SURM IGJ1dHRlcmtuaWZl aW50ZXJz IHBlcnN1YWRl IExHQlRR 6Is= LnNvZnQ= IGJlYW1z X3N1cg== LkRlZg== IGxhYnM= CXBsdA== IHNraW5z IHRyYW5zZmVycmluZw== IGltYWdpbmFyeQ== X0VuZA== O2JhY2tncm91bmQ= IGxhcHM= X0NPTU1FTlQ= KFNETA== b25kcw== LlJlY29yZA== IEltcGxlbWVudHM= X3RpY2tz KCkpKQoK IGFyb3Nl XT8= IE1w IElDb21tYW5k IHNjdWxwdHVyZQ== IGNvbnRyYWN0ZWQ= PEhUTUw= IGNhbGVuZA== YXR5 L1N1Yg== IGt2aW5u X0lHTk9SRQ== IFNoYW5l TUxT IHN0aW11bGF0ZQ== UGFydGl0aW9u IG11bg== w7Nt ZXJhbGE= LWFjY291bnQ= LkJpbmFyeQ== Y8Op IHNlaXpl Y29ubmVjdGlvbnM= IAogICAgICAgIAo= IERpYWdub3N0aWM= VklTSUJMRQ== IFJ1bnM= IGltcHJlc3Npb25z c3VpdGU= b2JsZQ== fi0= YWt1a2Fu PFBlcnNvbg== IE5vcw== IEd1aQ== LndhaXRGb3I= UkVTRVQ= IHBvc3Rwb24= RGlzY292ZXI= YXJyaXNvbg== c2hhdw== Ymxvb2Q= QUpPUg== 5pu05paw IE11c2U= 5pS2 IHJldGFpbmluZw== b3R0ZQ== IG1vc3F1ZQ== IFNuZQ== IHN0YW5kYXJkaXplZA== IG1haW5sYW5k X3RocmVl dW5nZW9ucw== Z2V0RG9jdHJpbmU= IHdoYWxl IGFnZw== IFBvcnNjaGU= bm93bGVk bGF0ZW50 IFJlbGF0aW9u IC8vJw== IHNodXR0aW5n IFJlbWl4 X2Nvdg== IHNhaWxpbmc= IHZvd2Vk IHBvdHM= b3V0dQ== IGhhaXJ5 Y2FzdHM= UmVsb2Fk IHJlY29ubmVjdA== dGVyYQ== LmNoaWxkTm9kZXM= IFJhY2s= IGN1cnJlbnRJbmRleA== IGFsbGVu IOeUqOaItw== IEN1YnM= W1g= X1NFUQ== X1JFTU9WRQ== LmdldEFjdGlvbg== KC9e ZXJyYXI= IGV0aGVy Y3VydmU= IHNsYXA= IHVvbQ== T3RoZXJz IGVuZ3I= RGlzcG9zaXRpb24= IHN0YWdlZA== RXll IEF1eA== YXV0aGVudGljYXRl ICQ/ IEFuZHJlYXM= IHNldHc= LkFydA== IGZvcmVjYXN0cw== IGF1bnQ= LW1pZGRsZQ== IG1pc2Q= ZGVzaw== IGVzY29ydGU= IENhc2E= cm9waWNhbA== IGV4ZW1wbGU= cGxhbmV0 KFVJTlQ= IHdoaXA= IFBDQg== Y2xpZGVhbg== PSJc IG94aWRl IHN1Y2NlZWRz ZGVyaXZlZA== IEVjb25vbQ== X2Nvb3JkaW5hdGVz aXJhcw== RHJhZnQ= IHZpc3VhbGl6ZQ== QnJpYW4= X0FTU1VNRQ== IE9iamVjdElk IHRyYWluZXJz X0ZPUkNF IGNvbnNvbGVz LXByb2Nlc3M= bGljaGVy IFNpbW1vbnM= VGFraW5n IENsYWltcw== IGRpZmbDqXJlbnQ= QWN0aXZpdHlSZXN1bHQ= IHNucw== 6YCJ5os= IENydXM= IGxsYW0= cmFi IEpvYW4= QUFB CWZpbHRlcg== aXNob3Bz Z2V0dGluZw== 4LU= IHF1YW50bw== UGFzdA== b3ZpY2g= IGluanVzdGljZQ== IEZMT0FU IGFscmlnaHQ= XERC KEdhbWVPYmplY3Q= dWlzaA== KGJvdA== IGdhbGxvbnM= IFLDqQ== IFNhaWQ= IFNURE1FVEhPRENBTExUWVBF YWlzaW5n X3Byb2Nlc3Nvcg== ZWxsaWRvcw== dGVyZGFt IEJlYW0= VGV4dEFyZWE= IHJldG9ybm8= Lk1ha2U= ICQoIjw= IGxvY2tkb3du IHJlbWVkaWVz IHZlZWw= eGVl ZG9jdHlwZQ== Rmls IEV4cGFuZA== IGVtcGxveXM= IHNlc3Npb25TdG9yYWdl UGhw UHVibGlzaA== IHJldGFs ZmFicw== eW5hbWljcw== IHRvc3NlZA== IG51bWJlck9mUm93c0luU2VjdGlvbg== eHBhdGg= XG1vZHVsZXM= IGRpc2FzdHI= IE1VTFQ= Lk1lc2g= LXN0YWdl IHNkZg== aXR1bmc= dWdlcw== ID8+Ij48Lw== X2luZGV4ZXM= IHZhbHVhdGlvbg== IGxpZmVsb25n IGV4cGVkaXRpb24= KFlpaQ== IHBhaW5z IFBSSQ== IE1peGVk IENoYW5naW5n R2VybWFueQ== Y29tbXVuaWNhdGlvbg== Lm9yZ2Fu IE1hcmF0aG9u Z2V0UGF0aA== IEFjY3VyYWN5 IEdsb2JhbHM= Jyl9fTwv IE9XTkVS 4oCm4oCd IHN0YWJiZWQ= IHNjaGl6b3BocmVu IEZu IENPUkU= IERhdGFSb3c= IExURA== IG15dGhz IGZhbW91c2x5 fCwK IFNlb3Vs U2ly IEJlcms= UmVnRXhw LmdldFJvdw== IERlY29kZQ== Uk4= IG1hbmc= IGVtcGxveWluZw== X25vbWJyZQ== PFRhc2s= IEd1eXM= IEFydGlrZWw= QmVycnk= enVyZQ== IHZhbGV1cg== aGl0cw== IGx1Y3JhdGl2ZQ== IGluZm9ybWF0 Q2xpbnRvbg== IHRlcw== IENlcnRpZmljYXRpb24= X3dz IG9mZmVuY2Vz ZWJyYQ== IEF4aW9z cmVzdGFydA== TE4= LkVuY29kZQ== bWl1bQ== IEZlYXR1cmVk 0YjQuNCx0LrQsA== IERlcHQ= OyYj IE15ZXJz CXRyYW5zZm9ybQ== VGV4YXM= 16g= IFlvcmtzaGlyZQ== bG5hbWU= QnJl 44GT44Gu IHNjZW5lcnk= IGbDvGg= CQkJCSAgICAgICA= IERvb20= IEFETUlO KGVz INC80LDRgdGB0LjQsg== X2FzY2lp L0RhdGE= bGVzaG9vdGluZw== QmFu IG1lbW9pcg== INmG IEF1c3M= KXBhcmVu IGd1aWRpbmc= IGJheg== w7h5 QURN IGRtYQ== LlF1ZXVl IFN1cHBsaWVz IE1jRA== IEFnZW50cw== X2Ji c2xhc2g= IGhhc2hlcw== IGNyYW5r IFJhZw== IGF1dG9ub215 w610dWxv IHJlY3Vyc2lvbg== IENyYXp5 X3RyYWNrZXI= IE1i X3BoeQ== Zm9vYmFy CXNwZWVk IGNhbXBvcw== IG1vdWxk IGNoYXJpdGllcw== SEVJR0hU IGVhdXRv X3NvbHV0aW9u IERH bWFydmlu WWVzdGVyZGF5 IEJlY29tZQ== PGxs b3Jpcw== W25leHQ= IGluY3VtYmVudA== IER1cA== CW92ZXJyaWRl 5a6J CWNmZw== IHPDtg== IGRlc2U= LWRp IG9udHZhbmdzdA== IGRlY2lzaXZl 5Lu3 X2tlZXA= KERhdGFiYXNl Xy8= IENMTA== LW1ldGhvZA== CVBvaW50 IEJ5dGVCdWZmZXI= IHRyYWNlZA== YWRkVG8= 7IS47JqU YW55YWs= IGVtcHJlc2Fz KHJlcG9zaXRvcnk= LmNyZWF0ZVN0YXRlbWVudA== IGVsYQ== Rm9yZ2VyeVRva2Vu IGlzZW1wdHk= YXNpbg== IExvb2t1cA== 0LXQvdCw IHZpb2xhdGVz IFNtYXJ0eQ== IHphaw== KCQu U0hPVw== INCi YXJ1cw== KFRFU1Q= cGFja2Vk IGhpc3Rvcmlh IGNhbmNlcnM= IEtyZW1saW4= UmVkdWNl L2hvdw== IMSQ VElUTEU= LmxvY2FsUG9zaXRpb24= bGlhYmxl IOesrA== IGZyYW5jYWlz CWhhc2g= IGluaWNpbw== IENyYXNo IHsu IGNsb2Nrcw== ZHVjdG9yeQ== IFB2 6528 IGRvaXM= XC0= IGphYXI= IE1heWE= bW96aWxsYQ== CXJlc291cmNl ISEK YXlzY2FsZQ== ICctJyw= 5Y+W5raI IHN0YWxl Q29ybmVy w6hsZQ== aXRpdmVz emFz aWNvcm4= LkV4cHJlc3Npb24= w7N0 QXBwbGljYXRpb25z UmVzdHI= X0luZGV4 jbDsnbTthLA= IEpGcmFtZQ== c2l4 X0lNRw== 6JeP IE51bWVyaWM= IHdpcms= X1NVTQ== PERhdGVUaW1l IHB5bGludA== IGxhbWVudA== IFBvc2U= X2VudHJvcHk= IGVuY291cmFnZW1lbnQ= IGxhaW4= 5Yib5bu6 LWZy IGNvcnJlY3Rpb25z cGhhcw== dXVy YXRlZ29yaWFz IGNhdGFseXN0 LmFsdA== IEZlcm5hbmRv LkRhdGFHcmlkVmlld0NlbGxTdHlsZQ== IGhlcmJhbA== IFJH U1RFUA== SUZu IFRvbmc= xb5l IElOQ0xVREU= IGhj dHJhY2tlcg== CVN0cmluZ0J1aWxkZXI= IERlc3Rpbnk= IHNvcGhvbW9yZQ== IERlZA== IFBBUkE= aXpvbnRhbGx5 LWNoYW5nZQ== ZW5kaWQ= 6YCJ5oup aWprZQ== IEF0aGxldGlj YmFp Z2V0UG9zaXRpb24= Lm5hbWVzcGFjZQ== 6K6i5Y2V UkFDVA== IHJlbGlldmVk IHBvdXJpbmc= IGl5 cm92ZQ== IGFkb2xlc2NlbnRz IGF3ZQ== cmVhcw== QW50aUZvcmdlcnlUb2tlbg== cm93bmluZw== IFVuY2xl LkNvbm4= IE1lZGlhVHlwZQ== Lm9yYWNsZQ== SU5URVJOQUw= LGFuZA== IGZhdXg= aXBtYXA= JG1vZGVs IEdlb2Zm X0FYSVM= KCgpKQo= IG5lZ2xlY3RlZA== IHF1YXJ0ZXJseQ== IGRpZXNlbg== IGRyYWdvbnM= TmlnaHQ= L1dlYg== PFZlYw== CSAgICAgICAgICAgICAgICAgICAgICAg IE9icw== YmRk IGhlaXI= LWFuZ3VsYXI= TWVudVN0cmlw ICciPic= a2luc29u INC60L7Quw== b2duaXRpdmU= X2xp IGltbWluZW50 IGFmZmluaXR5 LnNpZ25hbA== IG5vdGNo IFN0ZWVsZXJz bWF4bGVuZ3Ro S0s= IEV1Z2VuZQ== X1BXTQ== cm9p IOKXjw== IEhhbWJ1cmc= Lk11c3Q= IGF4ZQ== ZW5lZg== IGFtYml0aW9ucw== IFNwZWNpZXM= IFN0cmVzcw== IGF3aGlsZQ== INCx0YPQtA== IHdpdGhzdGFuZA== IERlY29kZXI= X2ludmVudG9yeQ== IHsNDQo= IHRndA== IHJhaWxyb2Fk V0FTSElOR1RPTg== IG5lZ290aWF0ZWQ= TlNU LXBob25l LFU= IGV4ZXJjaXNpbmc= 4bul X1BJWEVM YXZvcnM= aXRlcmF0ZWQ= IHZhbXBpcmU= YWRhbA== SW5ncmVzZQ== IHVuZw== amVjdGl2ZQ== LmNlbGxz IG5hbm8= IG1hcmtkb3du X1JVTEU= KGV2ZW50cw== IGx1Z2dhZ2U= TUVTU0FHRQ== aWdrZWl0 JGNvdW50 QXR0cmlidXRlTmFtZQ== SUdJTkFM X0VudA== IEJG IENPTU1FTlQ= X2luaQ== IEV1cm9wZWFucw== IEJlbGxl 5ZG9 KVsn 5bqU IFVzZWZ1bA== LnJlZmVyZW5jZQ== KCkiLA== X2dyYWRl IEthdw== IHNlbnRlbmNpbmc= IHNvY2lhbGlzbQ== bW9uc3Rlcg== X0xBWUVS IGRlZXBlc3Q= d2s= IE5vaXNl IyMjCgo= IHByw6lj b3RsZQ== 0YLQtQ== YXVm aWJhbA== IGNvbnF1ZXI= PkVtYWls IGFtYnVsYW5jZQ== T0FE ICgiJQ== IEZJ LmZpeHR1cmU= IHRlcnNl ICAgIAkJCQk= IHNhbmN0dWFyeQ== dWdp IENvbXBhcmF0b3I= RGVmaW5pdGlvbnM= IGFzdGhtYQ== IGxhY3Q= IGhhcmR3b29k LmNsb2Nr IGF0dHJhY3Rpbmc= IE1vdXI= KGRpc3RhbmNl aWNpdHM= IGJvbm5l IEFDQ0VTUw== LkRlc2VyaWFsaXplT2JqZWN0 IFR5cGVk IGpldQ== IGFwcElk IENsYXJh IEhG IFJlaWNo aXBwbGVz Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== X2RlbGl2ZXJ5 ZXJpYWxpemF0aW9u IHBsYWludGlmZnM= U2NpZW50 c2hvcHBpbmc= IER1bW15 IFdhbGQ= R3JvdXBOYW1l IGluc2NyaXB0aW9u ZWxvZw== Ojo6Ojo6Ojo= X2xk QmFja1ByZXNzZWQ= LlJhdw== IE9uVHJpZ2dlcg== IG11c2V1bXM= IEJlZW4= IEFkdmVudHVyZXM= IHNsYXRl IGxldHQ= IHN1bmQ= IEdpbg== IE1lY2hhbmljYWw= LnNoaXA= QXBwQ29tcG9uZW50 IGRlc3RpbmVk IGR3ZWxsaW5n UHJvZmlsZXI= UHJlcGFyZQ== emVpY2g= IHNpbGljb24= KGhhcw== ICMl VklERU8= IGNvbGxhYm9yYXRl TGlu IHNjb3Blcw== KGNsYXNzTmFtZQ== KHNk YW5kaW4= LmhhbQ== U2VydmljZUltcGw= LWRlc2NyaWJlZA== IGlyb255 c3RpYWw= IEh1YXdlaQ== KHJlcG8= IHVuZXhwZWN0ZWRseQ== IEthaQ== Lmluc3RhbGw= XHhm IGV4aGliaXRlZA== X1RDUA== IE94 X0NITw== IHByb3N0aXR1ZXJ0ZQ== IHbDpA== IHNpdG8= IGNvbnN0aXR1ZW50cw== IENvbnRpbnVlZA== IFNBVkU= cnNz L21lc3NhZ2U= dWJlcw== IG1pc2RlbWVhbg== IHRheGF0aW9u IHN0b3J5bGluZQ== aGFpcg== IEZpbmRz U0lH dmVyaWZpY2F0aW9u fj0= Lmhw SXRlcmFibGU= 0YvQtQ== YXRvcmk= IGN0cg== Ung= Xyk7Cgo= ZGFn LnBpbg== IHBzZXVk IGludm8= 0YHRgtGA X3BpeA== 5Li656m6 IHN3b3Ju 4oCUb3I= X3JlZ2lzdHJ5 IGRpc2FzdGVycw== IFJPSQ== IOKAlQ== YWt0dQ== Zm9yZXN0 YmVpdGVu 4oCUSQ== dWV2YQ== ZWd0 IHNwaWtlcw== VVJFUw== IFJlY29tbWVuZGVk IGV4cGxvaXRlZA== IEZyZWRlcmljaw== X0NPTVBMRVRF IERydWdz ISEhISEhISE= IFJpdg== U1RPUA== Uk9PTQ== IFBBU1NXT1JE Q29va2llcw== LkVs 4but IEJlcnQ= IGhhc2hlZA== aWNlc3Rlcg== IGRlY29yYXRvcg== IHF1ZXJ5U3RyaW5n OjsK ICJbIg== b3RvcGU= LUFtZXJpYw== IE1hdHRoZXdz VVJBTA== 4oCcLA== U3VtbWVy Zm9z X0NPTlRBSU5FUg== X0FDSw== IGZpbHRy X2Rpc3A= X1Jl IGZhY2lsZQ== 0LDRiA== IOyVig== IGViZW4= IHNwcmluaw== IFF1aW50 PlY= IGhpc3RvcmlhbnM= b3VybWV0 IE1vbml0b3Jpbmc= bGVkZ2Vy Y290dA== IHdhcmU= R0dMRQ== Y2Fycw== IE1FRElBVEVL IHZvbHVwdA== X1ZpZXc= SEVM KGNvcHk= KHN0YXRz IGNocm9tb3NvbWU= IEN1cnRpcw== LWNvbmY= KGFzc2V0 IGh2b3I= RmlsZVN5c3RlbQ== PD4oKTsNCg== b2NvZGVy IENhbm5vbg== KXg= IFNtb290aA== IFNBUw== X2Nl CXByZXY= X21vdmll RWM= X3dhbGw= PEJ1dHRvbg== IEZBU1Q= IG9uVmlldw== dWxhbg== IFNVUFBPUlQ= IGdlc2NoaWNodGVu IFNvbnM= SW1t JElGbg== IGZhaXJuZXNz IGRwaQ== YXRzdQ== Sm9zaA== RXF1YWxpdHk= IH0oKQo= X2xlc3M= IFJhdGlv IENhdHM= IFN0ZXJu TW9uc3Rlcg== IG1lcmN1cnk= w7xocg== IHBsdXNpZXVycw== LmRlc2VyaWFsaXpl c2NvcHk= LkZhbHNl KWFuaW1hdGVk IEV4cGVydHM= ICIiKXsK LldoZW4= c2VlYWxzbw== LnVucGFjaw== TEVN LnNlbGVjdEFsbA== IHBlcmNlcHRpb25z dWRpbmc= aXJsaW5n IFByaW50aW5n Z3JhbXM= IEZpbGVTdHJlYW0= ZXJ2aWxsZQ== aWxvZw== aWNtcA== X0NvdW50 IGxpdmVzdG9jaw== LWNh ZG9jdW1lbnRz IHBvbGVz CXdhbnQ= IGZsdW9yZXM= IHN0YW5kcG9pbnQ= IEh1Z2U= IHJhZGlhbnM= IFVJQmFy RURJVU0= IEhpc3Rvcmlj X2hvbGRlcg== IE1hcmluZXM= IHTDpA== LkxpZ2h0 cXVpcmVy YXNvbnJ5 ZGl2aWRlcg== IEZsdXR0ZXI= X2Zi cmVzdHJpY3RlZA== IEV2ZXJ5Ym9keQ== TsOjbw== IGtub3Q= IFR3aXRjaA== IGhhbGx3YXk= KENvbGxpZGVy SW5wdXRFbGVtZW50 PykK L29mZg== Lyk= cGxheWVk W09G IGJhdHRpbmc= X2Rs IGNvbWVkaWFu IMOpdg== IERFTQ== IEVkZW4= OndoaXRl Jycs Q29uc3RydWN0aW9u YWNlcmI= IHRhc2tlZA== Lm1hbmFnZQ== UmVsYXRpb25zaGlw IHBob24= bno= X0JHUg== VmFsaWRhdGVBbnRpRm9yZ2VyeVRva2Vu X2Fpcg== 4oCcV2hlbg== IGdsZnc= IENvbnZlcnNhdGlvbg== X1RPVEFM LFo= IGdyYXo= IGl0ZXJhYmxl IFBBU1M= IGFkdmVydGlzZQ== IG3DtmdsaWNo L3RyYWlu IFZvbGtzd2FnZW4= IGNyZWVweQ== ICIpDQo= UVVFTkNF IGFsdGFy IGVkaXRz Y29tcGlsZWQ= YXduaW5n IER1bmdlb24= IG9zZw== TmF2aWdhdGlvbkJhcg== IHRyZW5kaW5n IEVjbw== b2dnbGVz Y2RvdA== fC0= U2ll ZWNyZXQ= IE5lZ2F0aXZl IExpbmc= IERJTQ== IENXRQ== IENhcnJpZXI= IGNhcnRyaWRnZQ== X3VzYg== PW9z IEphY2tpZQ== IG90cmFz IGNvbW1vZGl0aWVz IFByZXNlbnRhdGlvbg== KSYmKA== IE1hcnRoYQ== IENhdGhvbGljcw== IE1vbmQ= 0L7QsdGL X2Fic29sdXRl IGFzaGFtZWQ= cG9uc29ycw== dGFs IHNhZG5lc3M= IHB1w7I= RmFkZQ== LXByZXZpZXc= IFJlcXVlc3Rz IENhbHZpbg== aG9ybg== UmV1c2VJZGVudGlmaWVy KHByb3ZpZGVy L2FwcHM= aW1lbw== CUNsYXNz U2Ftc3VuZw== IFdPUkxE IGNpbm5hbW9u ZG90ZW52 IElVc2Vy IERFVg== X0NoYXI= LmliYXRpcw== ZXRp L21l c3N0 LnN5bQ== IFJ1Z2J5 LW1hc3Rlcg== YWphcg== IFlFQVI= IG9kcA== IFJvbGVz IGJpcGFydGlzYW4= YWlsbGU= IGJsb2NrZXI= IGdyZWVucw== LlNFQ09ORFM= IGJlbGlldmVycw== IExpa2Vz RkxPQVQ= IG1haw== IGdjYw== 4pWQ4pWQ KCJ+Lw== U0NSSVBUT1I= IHRvbm5lcw== IFNhbmc= IHRyYW5zcG9zZQ== ZW5uYWk= UHJlZA== IHNvbGx0ZQ== LmdpdGh1YnVzZXJjb250ZW50 KHByaW50 IEhvbGU= 55yL YWRnZXQ= IHByb21wdHM= IGdlbmV0aWNhbGx5 IEhvZA== IHZlcnRpY2FsbHk= X2NvbnRyb2xz 0YHRgtCw0L0= Iil7DQo= JHRpdGxl IH0pLAoK IHN0YXRld2lkZQ== IENvcnJlc3BvbmQ= IEF0dHI= aXRhbnQ= RWxlbWVudFR5cGU= IG91dHdhcmQ= IGZhbWlsaWE= KGFydGljbGU= IGJsYXQ= wqAK IGdsR2V0 IFJlY2VpdmVy ICUt YWRhbQ== V2lubmVy IHRhaWxvcg== X3B3ZA== ZXJ0ZW4= U3Rhbg== CWFsbA== YWxpdmU= c3RydG90aW1l 77+9cw== c2Vzc2lvbnM= JGNvbm4= YXNzaXN0 IGNoYXR0aW5n IE1hbnQ= ICVA ICIiKTsKCg== IGRndg== IO2VqA== LnJlcGVhdA== X01lc3NhZ2U= IGFkdmlzZXJz L3BhdGg= IGtlcw== KX08Lw== TWlzYw== IGJzb24= IHRyaW1tZWQ= IEFjaw== VmVydGV4QXR0cmli 57Si dWF0ZXM= Lm15c3Fs IGRlc3Rpbg== IHByb2Js KENvbnN0YW50 YXNzZXM= LWltYWdlcw== X0FSRUE= X18qLw== W10o IHNpZ25Jbg== xJE= eHI= YWhpcg== LmZpcmVzdG9yZQ== IHNlcXVlbnRpYWw= IElkZWE= LWJhc2lj X3BhZw== IGluc3RhZ3JhbQ== b3Ryb24= X2FsaWdubWVudA== XFxcXA== LkZhY3Rvcnk= LnJ1bGU= LmNoZGly IGxpYnJv KGdhbWVPYmplY3Q= LlRvb2xTdHJpcEJ1dHRvbg== IGRpc2NvdmVycw== LkFyZ3M= ZG9i IHZu 4oaS IGTDvA== IFhN IGFsdW1uaQ== IGhvbmU= IHNlY3VyZWx5 X2Ryb3Bkb3du RGlzY2xhaW1lcg== IGR6aQ== KHRpbWVzdGFtcA== Jyld IGN1bHRpdmF0aW9u Li4uCgoK IFRyZWF0eQ== IERpc3M= IGNvbmZsaWN0aW5n LmdldFNlbGVjdGlvbg== IHBsYXlhYmxl IFNpbGs= IEVxdWFsaXR5 IG1veQ== IGZsYXR0 IG1vdGl2ZXM= UGVyZmVjdA== LmV4aXN0 IHR3ZWFr IG9taXQ= IFR3aWxpZ2h0 IGtpc3Npbmc= IGNocmlzdGlhbg== KFNF X2RlZmluZQ== IFBlbmc= U29ydGVk J2lu TG9ncw== 4buHbg== IG55bG9u RHVtcA== SW1hZ2luZQ== cmVuYW1l IGJlZm9yZWhhbmQ= cHlnYW1l IGJweQ== IERq IHRpdHVsbw== IG5sdGs= IFNjaG1pZHQ= IENhdg== KG9uZQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= LmdldE1vZGVs IFB0 YXRvaQ== LmxvY2Fscw== YnVyc2VtZW50 UHJvdmluY2U= IEFwcHJvdmVk KCk8PA== w7NyaWE= dXNjaA== IEplbm55 YXJyYW50cw== IExpYmVydA== TG9yZA== IFJlbW92ZWQ= X2NvZGVj LmJ1bmRsZQ== IEdvbnphbGV6 b3BlcnM= neWni+WMlg== ZXR0aW5n IGdvZGRlc3M= cmlwZQ== IG11c2N1bGFy CQkJCQkJCQkg IEh1Z28= IG1lam9yZXM= bG9pZA== cml0ZWxu Z2lz YWRkb24= ICgoKCg= YXBwb2ludG1lbnQ= cmVzZXJ2ZWQ= CWZyaWVuZA== X2F2YXRhcg== Qk9PTEU= YWhp LUVORA== IGlmZg== w7Ni IEJydW5v cm93c2FibGU= IFBvaXNvbg== KGZsYWdz dXJ0bGVz IEFuaW1l IG1pZ3JhbnQ= CXN0cmNhdA== KHJlcGx5 IFJlZnVnZQ== IEJX ZWZ1bA== JHZhbHVl ZmVk ICAgICAgICAgICAgICAgICAgICAgICAK 6LWE KGNt IHZ1bG5lcmFiaWxpdGllcw== IFsoJw== IHVuYmVsaWV2YWJsZQ== c3RyaWN0aW9u ZW50aWV0aA== IHByYXlpbmc= Q2xhaW1z IGthdWZlbg== bsOp IHBvaXNvbmluZw== Y29sbGVjdGlvbnM= IGluaXRTdGF0ZQ== IFNldmVyaXR5 IGNvbnRlbnRpb24= IAoJCg== LmNvbnRyb2xsZXJz c3RydWN0dXJlZA== aWN0aW0= IE9iZXI= IC8qI19f X09U IEFtZXJpY2Fz IEFkYQ== UHJvZHV0bw== Lm11bHRp IGdyYXBl YmVn 5p+l6K+i IHF1YXJ0eg== IFJvbWFuY2U= IE1pZHdlc3Q= IGhvdXNlZA== IGZ1cm5pc2g= aWNvbnQ= LnVuc2hpZnQ= b3RyZQ== IMO6bg== aXBwbGU= IHN1YnVyYg== dWFsaQ== Vm9pY2U= LklzQW55 LGNvbHVtbg== IFByb3NlYw== SURB CXBvc3Q= cHRvbXM= dsOp IEluZ3JlZGllbnRz w7ZmZg== Lm9wZXJhdG9y IDw8PQ== bGFzdGlj IHJlc2VtYmxl VW5hdXRob3JpemVk IHR1dHRv X1NXSVRDSA== X1JFQURZ fT0= bm93bGVkZ2U= IGFwcGVuZGVk dW5nYW4= 4oCZZW4= IExvcmVu cHVibGlzaGVy IE1H fSwi IFdhbHNo VGVtcGxhdGVz X3NvY2lhbA== IHBhcmlzaA== IFNwbA== bWluYXRlZA== KEZBTFNF IGZvcmVmcm9udA== bW9kaXR5 IGJpbGF0ZXJhbA== IGNvbXBldGl0 IGNhbmRsZXM= LmRw IGNvbGxlY3Rz dGVsZWZvbm8= IGF0dGVudA== IExlbW9u aXphZGE= IHRoZXJhcGllcw== IHBhcmFkb3g= IHRhcw== LXN1Ym1pdA== ZWtlcg== SU5hdmlnYXRpb25Db250cm9sbGVy IG1ldGF2YXI= IHNld2luZw== IFppbWJhYndl IGxhd2Z1bA== IGxvcmU= IExvYWRz INGB0L7Qt9C0 LnByb21pc2U= IEZhY2Vz LlBsYXRmb3Jt LmdldExvY2F0aW9u IHRyb3VibGluZw== IHbDrWRlbw== IEZlYXR1cmluZw== 5Lqn cWVk IG9uQmluZA== IHRvZGRsZXI= Q2xv RGl2aXNpb24= LWdhbGxlcnk= IEdlbGQ= c3BlY2lmaWM= RmllbGROYW1l X2V4Y2Vs XGh0ZG9jcw== IERW ICY6 IHR3aWc= IENvbmNlcm4= IHNob3RndW4= IG5pY2tlbA== IEx1eHVyeQ== X0tFWVM= Lm5weQ== xa8= IGZvcmVoZWFk zrI= IGVuZGFuZ2VyZWQ= L3RoZQ== cGlwZWxpbmU= xbE= bmVv RXhwbG9yZQ== U3BlY1dhcm4= IGludGVyY2hhbmdl KHBp YmlydGhkYXk= RGF0YVJvdw== IFNQUg== IG9zdGU= ICJ+ YXRpc2ZhY3Rpb24= Tkg= b3Jkbw== LWZvY3VzZWQ= J0E= lok= LmJlc3Q= IFNwZWNpZmljYXRpb24= Lz4uCgo= b2dlbmVzaXM= IE9QVElPTlM= dXB0b29scw== IG1pbGl0YW50 IGV4aXRlZA== aWdhcg== IENPTU0= IERpc3Bvc2FibGU= YXljYXN0 IHJvd3NwYW4= IHN5bnRoZXM= IHNvbmRlcm4= IDwhLS08 IEVuZGU= LnZhcmlhYmxlcw== IGNvbnNlcXVlbnRseQ== c2Rr U3VwcGx5 cmVzcG9uc2l2ZQ== T3BlbmluZw== cGhvdA== IH1c IGJ1bGxzaGl0 IGJlYWNvbg== X3NhdA== IHNuYXBz IEdIeg== TE9ORw== PHBhaXI= IFsKCg== IFZlcmc= IEVpbmU= L3Bvc3Rz IGFyYWI= IHN1bWE= 44Oz44OI IHNjYXJj IG9sZWg= ID8/Pw== IE9mZmVycw== eGVk IGZ1bGxXaWR0aA== LWFjdGlvbnM= T3V0ZXI= IEV4cG8= w6lyZXI= Lkhl REg= IGhpbA== IE1pbGxlbm4= 0LXQvdGM SWNl X2dyYXk= INC/0L7Qu9GD0Yc= IFB1bms= IHRpbWV2YWw= IGlzYQ== IENIdG1s LkRhdGFQcm9wZXJ0eU5hbWU= IGRpeQ== dG91cg== IGpUZXh0RmllbGQ= IGplbGx5 IGFra2E= LWVyYQ== RGVwcmVjYXRlZA== X0lNUEw= IE1vbnRocw== X0lURVI= IGFydGU= IEhlYWRpbmc= IEJvaA== IHByYWc= IGRvd25zdHJlYW0= IEJPQVJE X2tleXdvcmRz IE1ldHJvRnJhbWV3b3Jr KS0o PEV2ZW50 4bqldA== IFByZWNpc2lvbg== IE1SSQ== aGVyZW5jZQ== aXhv KSkpewo= KCk/Pg== IHNhYXQ= IFdhcmVob3VzZQ== X2F0b21pYw== IHZvaWNlZA== SXRlbUNsaWNr ICAgICAgCQ== LlJlc3VsdFNldA== L3BsdWdpbg== IGhhbGxz PWZvcm0= IFdhZ25lcg== ZW1haWxz JSUK VU5LTk9XTg== IFJpbQ== dWludHB0cg== IExpYmVyYWxz IHRlcnJpdG9yaWFs IE11cmRlcg== IExhZGVu IHByZXNpZGVudGU= KGNhcA== IH0sewo= YXZvdXJpdGU= ZmluZEFsbA== IGFwcGxhdWQ= IOuplA== L3Bob3Rv X3N5bg== LndhbGs= IHN1bnNoaW5l IHN0dWJib3Ju IGRvd25zaWRl IExURQ== LWJ1aWxkaW5n UXVlcnlCdWlsZGVy X2Rpc2FibGVk VGVycg== YWtyYQ== UmVmcmVzaGluZw== X3Byb2Jz IGZvbGw= PmI= IGNvbGxhdGVyYWw= JGVycm9y IGFjb21wYW4= X2l2 K2Q= YWp1 IOKd c3VybmFtZQ== LmFydGljbGU= IGJpY3k= IjoKCg== Pjw/PSQ= 0LrQu9GO0Yc= ZWNvbWU= RmluZGluZw== KHBk IHJlY3Rhbmd1bGFy ZXN0bw== aWhpbA== PScnKQo= IG1hbnNpb24= X2ZpbHRlcmVk YW5lZA== UFJPRFVDVA== TE9HWQ== X2ly LlJlbW90ZQ== IGV4ZWN1dGVz b3RlY2hub2xvZ3k= IFBST0NFU1M= IHJvd0luZGV4 Z2V0WA== TXV0 aW5za3k= KHN0cmluZ3M= IE1veg== Rmxvb3I= LlN0cnVjdA== X3ByZWRpY3Rpb24= IGNhcnJpYWdl IGNvbGxlY3RvcnM= IFdoZWVscw== IGJ1bmRsZWQ= YXhlZA== a29s X2Nyb3A= IGJsb29t QmVzaWRlcw== IG92ZXJyaWRkZW4= IHN1Ym5ldA== aWVuaWE= Kj46Og== IFByaW1pdGl2ZQ== IOag LkNoYXJhY3Rlcg== 6KGo56S6 IEFESEQ= Uk9Z SmFwYW5lc2U= T1VT OlVJQ29udHJvbEV2ZW50 IFBBTA== aXphY2lvbg== IGNoZXJjaGU= b3J0aW5n IG9yZ2Fz LlV0Yw== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= XERvbWFpbg== T1JB IHRlcnJhY2U= IHByaXM= CQkJCQkJCQkJCg== IHJhaWRz X2luY3JlbWVudA== IHVuanVzdA== JG9wdGlvbnM= b25DaGFuZ2U= Qmxvb2Q= RmlsbQ== IGhhbmRpbmc= IG11Zw== U09MRQ== 44OV aWNvbmR1Y3Rvcg== IElzbGFtaXN0 ICIiKTsNCg== LW92ZXJsYXk= LGNvbA== 6Zw= YXJyaW5ncw== X2NvbnRyYWN0 CWxs cGlw X2VtYmVkZGluZw== IHBlcm1pdGU= IG1vZGVt IHRyaWdnZXJpbmc= KGh3bmQ= LiIpXQo= IHNhbnQ= IGV4dGluY3Rpb24= IGNsYXNoZXM= LkF1ZGlv IHN1bw== Lm11bHQ= IHNlYXNvbmVk LlZhckNoYXI= cG93ZXJlZA== ImNvbnRleHQ= IG1lbmM= KEdyYXBoaWNz JHdoZXJl IHJlY3VwZXI= YWNrbGU= IG5ld0RhdGE= IEJyZWFraW5n ZXJnZWQ= IENQUFVOSVQ= IE11bGw= IGtvbW10 IExlZWRz JywnPQ== Lm5leHRUb2tlbg== IFJpZw== UkVUVVJO CXRpbWVy fV97 IE1hcmluYQ== IHNsb2dhbg== SVpFRA== T3BlbkdM X1BhZ2U= YXRpdmFz IGhhemFyZHM= J3ZhbHVl IGNvcnBzZQ== IEZsb3dlcnM= X29ubGluZQ== ZGFs IENvbGxpc2lvbg== w6BuZw== IGZlcnJ5 IHBva2U= IFRvdXJpc20= aW5lcmFyeQ== L1NldA== LkVtcGxveWVl PkA= LHZhbA== IE1pbGY= YXZleg== UmV0cnk= LiIv IHJvdW5kaW5n LXBsYWNlbWVudA== IGNlcnY= TWV4 IE1zZ0JveA== X3Npbms= bWFuaWE= X2NyZWRpdA== R3VhcmRhcg== IHZhbml0eQ== IGltbXV0YWJsZQ== IGNvbnRhbWluYXRlZA== 0LrQsNC3 5Liy YWNoYQ== IGhhdGg= IGVudW1lcmF0aW9u LmdldEJ5 4bq/dA== IERhbw== b2JpZXJubw== IEd1dA== X1BJUEU= LmFkdg== IEd1dGVuYmVyZw== YWRo 66y4 ZnVzYw== LlZL cHRh IEVNUA== LkZpcnN0TmFtZQ== IHJlYWxpemVz LmNn IHVuaXRl UExJVA== IEFiZHVs IE1FRA== UkFJTlQ= IHF1ZXN0YQ== c3RkaW4= IGNhbG9yaWU= CWdsQmluZA== IGFybWE= eWxsYW5k T01Q LXE= IEtoYWw= c2FsYXJ5 CUFORA== c2dp X3RoYW4= LWJ1aWx0 ICsvLQ== IG5hcmdz X2xhdW5jaA== IFNR em9u IEJlbmVk X3VuaW9u PigpOw0KDQo= IFNpbXM= IERhdGVz CUNvbm5lY3Rpb24= IFBlcmM= Z3JhbnQ= YW1waWw= IGFnZ3JlZ2F0aW9u ZXNlbGVjdA== X1NVUA== KHsKCg== Lm9t IHdt LmNvbnRyYWN0 LU9yaWdpbg== IGdlbWU= ZnJlZXpl TlVNQkVS LmN1cnI= IEdsYWQ= c2xh IFJlYg== 0LXRgdGC0LLQvg== YXJib24= L2NvbnRyb2xsZXJz U2xvdHM= LmRlZXBjb3B5 RlVMTA== dWlyZQ== QHN0dWRlbnQ= 4LmJ4Lit VHJhbnNsYXRvcg== IHByZWZlcmFibHk= Y2hlbWlzdHJ5 IEphY29icw== bmFy ICgiXA== bmVhcg== aWZpcXVl CWNvbHVtbg== IG1pbnV0b3M= aWdlcw== IGVzdGFibGU= LWRpc2M= KENoYXI= a292 ZXhhbXBsZXM= X18oIg== INC60LDQug== IEJvcmlz KGR4 c3By IG92ZXJoYXVs YXRvb24= IEhhcmxleQ== aWNhbWVudGU= 4paI4paI4paI4paI ZXZpdHk= dXNoZXI= LlZpc3VhbFN0dWRpbw== V2F2ZQ== IE5vcm1hbGx5 c3Rvb2Q= b3JuaW5ncw== IGhhbmRtYWRl KGxvZ2dpbmc= IGNhcmNpbg== YWNqYQ== IHN1cGVycw== IHNpZWdl CUlm IElMb2dnZXI= VUFSVA== QW5pbWF0aW9uRnJhbWU= IHRhcGVz IGFpZHM= IENvbG9uZWw= dmVlZG9y IG1kbA== cGhvbg== RGlzbWlzcw== QXZhaWxhYmlsaXR5 VW5pZm9ybUxvY2F0aW9u IGlkZWFscw== cXVldHRl a2VpdGVu IEVNQUlM IE5lYg== IHN1bW1vbmVk IGdvdmVybm1lbnRhbA== IEhvcnJvcg== Y2hhbmdpbmc= IEFjdGl2YXRl SWxs PHRib2R5 Y3JlYXRpdmU= IEJMRQ== IG1hZG5lc3M= T3JOaWw= IGhpbg== xZM= LkdldEtleQ== X2NvbnNvbGU= Ik91cg== IGd1aW50 IGFtaQ== IHJlZmxlY3RpdmU= IGNyYWNraW5n IFJp UkFM dXJzZWQ= cHVyZQ== IHJlcGFpcmVk IHRpZ2Vy IE5pY29sYXM= VnM= bnRo LmV4cHJlc3Npb24= IHNlYXM= X0FDQ0VQVA== IGZvcmM= IEZyYXU= IHRocmVzaA== IM+A KEJBU0U= X09wZW4= V3VudXNlZA== IERvbWVzdGlj KHByaXY= Z3Vlc3M= Ly8hCg== Z2V0SXRlbQ== KCkpCgoK bXV0YXRpb25z IHN0cw== IGRlbWVudGlh c3Bva2Vu JHBhcmFtcw== IHBhdHJvbnM= IHJ1bndheQ== IEJVWQ== Lldhcm5pbmc= IG5ldXRyYWxpdHk= emhvdQ== 0YDQsNGJ YWt0ZXI= IENvbnN0cnVjdG9ycw== w5NO IFByb2dyZXNzaXZl IEJ1cmdlcg== IGluY3VycmVk IGltcGxpY2l0bHk= X2Vudmlyb25tZW50 IGV4YWNlcmI= IGVuZHVyaW5n c2lj IFBhcnRpY2lwYW50cw== X0Jsb2Nr IGVucm9sbA== X2VtcGxveWVl IFBlcHBlcg== bGF1Z2h0ZXI= 44OW J107Pz4= PScu KHJlbmFtZQ== IHNoZWx0ZXJz IEFNQQ== X2dhcA== IFJFVVRFUlM= eGFtcHA= T01JQw== IHBlZGlkbw== IGTDqXZlbG9w X18oLyoh X29k d2VyZQ== X051bWJlcg== X211bHRpcGxpZXI= S0VFUA== IHNob3dlcnM= IG1hZ2U= IHNpbm8= Y3Jvdw== LmlkeA== X25vdGljZQ== dWVpbA== IG15cmlhZA== IEF2YWlsYWJpbGl0eQ== Y2VudHJhbA== IEFCT1VU IGluY29ycG9yYXRpbmc= IC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tCg== X3dpZGdldHM= IHN5c3RlbUZvbnRPZlNpemU= w7ZydA== L2pwZWc= IFNNVFA= KGJyb3dzZXI= Z3Vucw== c2V0dw== X0FWQUlMQUJMRQ== IGluY29ycG9yYXRlcw== L2FuZHJvaWQ= eXg= 5biD X2xhYg== IGxlYWtpbmc= IEhpbnQ= w7xuY2hlbg== LlNjYWxl IGZpcmV3b3Jrcw== IGxQYXJhbQ== YnNk YXhvbg== KHByZWRpY3Q= Q29uZ3JhdHVsYXRpb25z IFNwZWN0cnVt SVJD IEFkbWluaXN0cmF0aXZl IGltcHJpc29uZWQ= UlNwZWM= IHJldGFpbnM= IHNldHRsaW5n IGNpdGF0aW9ucw== IFdvcmxkcw== c3RyY29udg== b3VzYW5k IEJlZ2lubmluZw== IEFuZHJld3M= IFNoYXJvbg== RXhlY3V0aW5n Z3JvdXBJZA== YWRkRmllbGQ= IGV4cGFuZHM= IGtpbG9tZXRyZXM= bGlua3k= IGdycA== SU5BVElPTg== QnJpdGlzaA== IGNvbXBvcnQ= LkRhdGFHcmlkVmlld0NvbHVtbg== IFByb2R1Y3Rpb25z aWxkZW4= IHVuaXg= X2dhbGxlcnk= X1BST1ZJRA== b3JkZXJpbmc= X2Fubg== Ymg= LkRlc2lnbg== IHRyZWZmZW4= IHVuZGVybGluZQ== X251bXM= 7ZWc64uk KXY= dXNpemU= IGRpc2FwcGVhcmFuY2U= VG9Cb3VuZHM= IHBjbA== IFdpbm5pcGVn IFNoZXJtYW4= X2xhbWJkYQ== bmFudA== IHJvb3RWaWV3 LkZsYWdz IGNlbnNvcnNoaXA= c2VudGVuY2U= LnJlYWRJbnQ= X2Fzc2lnbm1lbnQ= IHZlcnNjaGllZA== IEZyYWN0aW9u IG5hdGlvbmFsaXN0 IGp1ZWdv IERlYWxlcg== IHByZWRpY3Rpbmc= YXVwdA== aGVsbQ== X1BSSUNF X0RT KCIjew== bGlmdGluZw== IHBvc2luZw== IE5TTXV0YWJsZURpY3Rpb25hcnk= IHNtYXNo IGFraW4= IGNhbXB1c2Vz IE91dGxpbmU= IEVsYXN0aWM= X0NoZWNrZWRDaGFuZ2Vk KElFbnVtZXJhYmxl c3F1ZWV6ZQ== cHR1bmU= X0ZST05U bWg= IOyDneyEsQ== UnVuV2l0aA== IHR1cm5vdXQ= c2libGluZ3M= KWU= X0FSR1VNRU5U IEdyaWRCYWdDb25zdHJhaW50cw== X1BPT0w= LlJJR0hU aWdnaW5z dGVsZXBob25l XEV4dGVuc2lvbg== IEFyaXN0 aXR1cg== IGZyaWVz X2R1cA== RXhwYW5kZWQ= LXJv IFdvcmxkd2lkZQ== IENvcms= w7Ns TGlt IGRlbm4= UHJldHR5 IGZ5 VHJpYW5nbGU= RmVhdHVyZWQ= KENvbW1vbg== X2VmZg== ICIiDQo= 4bubaQ== X0xJTkVBUg== IFJpY2E= IGNhZsOp IGFwcGVsbA== IG5pdmVhdQ== ICYs IGZhYnJpY3M= X1BsYXllcg== IGh5Z2llbmU= IGRpc2FzdHJvdXM= IHNoYXJlZEluc3RhbmNl X3BpdGNo cno= ZW5tZW50 TmVhcg== X1NUQVRT IHN0YWlu IEROQw== IGlzc3U= Xks= CXRyZWU= X2Jsaw== c2V6 bGFpbg== YW11 X293bmVk VVNBUlQ= Lmhhc0NsYXNz SVNPTg== IGZvZQ== dXNoZWQ= X1VOU0lHTkVE IGluZGV4aW5n IEZpcmViYXNlQXV0aA== IGxpdGVyYWN5 IFNVUg== IENvbHRz YmVjdWU= IEludHJv IGNoYW90aWM= IGFuaQ== IEFubmll xrDhu50= LmR4 ZGlzY29ubmVjdA== IGFyY2hpdmVk W0xpc3Q= PU4= LnByZXNlbnRhdGlvbg== UmVzdGF1cmFudA== IHJvY2tldHM= PWh0dHBz L29w IHB1cnNl IEtyaXM= IGNvcmFs c2V0UGFyYW1ldGVy IGlycmln UXVlZW4= TlNEYXRh IHZhc3RseQ== LkZpbGVz IGZlbWluaXNt KFN0cmVhbQ== IGF0cmli IGxpcXVpZGl0eQ== PEZpbGU= dHJhZw== W2NvbnRhaW5z IGhpbmRp CWNw aG9tZXBhZ2U= IHN1cnBhc3M= IGRheWxpZ2h0 YXV0aG9yaXpl IENvbnNlcXVlbnRseQ== QXN5bmNSZXN1bHQ= IERpYXJ5 LlBhdHRlcm4= LiovCg== ZW5zY2hhZnQ= IEp1ZGljaWFyeQ== QWR1bHQ= KCY6 IGplb3BhcmQ= IEJsaXp6YXJk IGdn IjsvLw== WEhS IHBhc3N3ZA== Pn0= JyksJw== IGNvbXBhcmF0b3I= LmNoYWlu IGluc3VyZWQ= X0VER0U= IHR5bGtv X01BSk9S d2F2 XEZpbGU= RW50cg== J2FwcA== IGZvcmdpdmVuZXNz CWRzdA== Ijot Lm1vbg== ICgKCg== IGNhcGl0YQ== IGluaXRDb21wb25lbnRz IHN3b3Jkcw== IE91dHB1dFN0cmVhbQ== IGhlYXJz IFNQQUNF LWluc3BpcmVk X2Jvb3Q= Lm5vbmU= LmdldElucHV0U3RyZWFt IGRldmlzZQ== IHBlZGlhdHJpYw== YW5zaQ== X3BhcnRpYWw= IHNoYXJk IGZ1cmlvdXM= IGRyYXdhYmxl JSku KGVt IEJha2U= CXBlcnJvcg== IFJlbGlnaW91cw== LSIr CQkJICAgICAgICAgICA= IFNlY3JldHM= KG5vcm1hbA== QUNFUw== IFN0b2NraG9sbQ== LW5vcm1hbA== IGFjY3VzdG9tZWQ= IGJvdXRpcXVl IFN3aW5n IGZpbQ== IFBV LlNvY2tldA== ICciJw== YW5q TWFudWFs IG11amVy IHBoeXNpb2xvZ2ljYWw= Y29udGFpbg== TWVyZ2U= IHN1YXM= ICd7Ig== bmVnbw== IHN1YnNjcmliZWQ= dG9hc3Q= X1ZFUkJPU0U= IGtuaXQ= IEFydGlzdHM= IGhlYXJ0YmVhdA== IGZpcmVmaWdodGVycw== c3Nh W3s= IHVuZGVyc2NvcmU= IGhpc3Rvcmllcw== aWdtb2lk RmllbGRWYWx1ZQ== VG9BZGQ= LkNv IEhhcm9sZA== QXZvaWQ= aWdoYm91cnM= b3JkZQ== IHRydXRocw== L2Fs IHdpcmVk IEl0YWxpYQ== IHNlcnZpY2lvcw== IEFVRElP ICciKw== IHB1bXBpbmc= IENsZW1lbnQ= w4NP 5Y6f Pm4= IHN0clNxbA== amRiYw== 4oE= CVNFVA== IEJVRkZFUg== Oi8vIg== IGNpcmN1bXN0YW5jZQ== VUlUYWJsZVZpZXdDZWxs LnZlcnRpY2Fs IEpvaG5z dG9saXN0 IGRyaXZld2F5 IGxlYXJuZXJz dG9iZXI= d2lubmVy LXlvdXI= LnN0YXRlcw== SE0= IGdyYWRpZW50cw== IHNlaXp1cmU= IG1hdGVy IGRldGFs IFJlZHVjZQ== KG1vdXNl IFJlU2hhcnBlcg== LXJvdXRpbmc= INi0 IGpvaW50bHk= IEZhbWls PE1lc3NhZ2U= ZXhwaXJl X3RyYWRl 4oCmLi4= IEZVTkNUSU9OUw== IHhlbg== IHt9Ow== RmFi IGZlYXN0 KERi Rmlyc3RSZXNwb25kZXI= xLFsxLE= IG1heFZhbHVl IC06 YXB0aWM= Lkdzb24= IFJvdmVy X2Nu bG91ZA== IGNoYW1iZXJz INC30LDQtA== LmZvcmVhY2g= LmdldEVtYWls 55+l Lk5vZGVz IFZX IFdhaXRpbmc= KFF0Q29yZQ== IHPDs2xv cnE= YW5ndWFyZA== IHJlc2VtYmxlcw== Oltb IGdlZA== X0VQ KEFjdGl2aXR5 IElzbg== IENydXNoZXJz X1JVTlRJTUU= CW9wZW4= IEhpZ2hsaWdodHM= w6lyYXRpb24= IHllbGxpbmc= IExJR0hU UGhvdA== dmVuZ2U= IFN1c3A= IENocg== LkRpc3RhbmNl YXJzaW1w bGljYXM= Lk1vbg== IHN1Y2tlZA== cHJpbnRlZA== bXV0ZQ== IHNldEVycm9y Lk9wdGlvbg== IGltcGFpcm1lbnQ= bm9pc2U= IHBhcnRuZXJlZA== w40= ZGVucw== aWN6 IHdhaXRGb3I= IG92ZXJsb29raW5n IEZPUk1BVA== IFRTdHJpbmc= IHJlbnRpbmc= CWNvbXBvbmVudA== LkZyZWU= IExhdW5jaGVy PWRhdGU= IFBvZHM= QUdNRU5U Q29kaWdv Qml0RmllbGRz IHViaXF1 LWNhcm91c2Vs IFNpbXVsYXRvcg== aW5vZGU= J10pewo= IEJhZ2hk IG5vcnRod2VzdA== aHRha2luZw== PCY= IHRyYW0= IGZvcndhcmRlZA== IGVycm9yTXNn X0FTU0lHTg== IEVudGl0aWVz LlBhcnQ= cmVhdHVyZQ== KFVyaQ== IERyaXZpbmc= IGludmFzaXZl aWdyYXRpb25CdWlsZGVy b3NhdXJz CXBvcnQ= IGJyYW4= aXR0aW5ncw== RG9vcg== IHsl KGxpbWl0 IHNxdWFyZWQ= IERJU1BMQVk= LkFjY2VwdA== LmJhc2VVcmw= LkVudGVy IC4uLikK IG93bA== IHNsYXRlZA== LmZlY2hh X1NFRw== PXsk IE9OTElORQ== T05Z INC00LDQvdC90YvRhQ== b250ZQ== X0NMSUNL U2E= SW1wb3J0YW50 IGNhcm91c2Vs IGFwcGVhbGVk IE5pZQ== L2Jvb2s= W10+KA== IHhtYXg= IGxhbmdl LlN1cHByZXNz IFRoaW5raW5n QWRkcmVzc2Vz IFNhbGx5 LVRW IENoYXJsZXN0b24= KSIKCg== IHRhbGx5 IHVsbA== IGxvY2FsZXM= ZXdhbg== IGluY3JlbWVudGFs 65Cc IGNhcmV0 anVyZQ== IGRvcg== IGxvY2FsaXphdGlvbg== IHNlYWZvb2Q= IFJ1YmJlcg== LlRoZXJl IEZpc2hpbmc= WVlZ bWFnZQ== IEZsZXhpYmxl IEdFTkVSQUw= ZWth IHRocml2aW5n IHNpcw== IGJvdXJnZW9pcw== RmFrZQ== LFwi INC+0LQ= Q09S LWVmZmVjdGl2ZQ== IHNrdQ== ZWRseQ== IyMKCg== IEhvbGx5 IEZMQVNI L1RS Lm5z cHJvYmU= Z2lmdA== b3dpdHo= LW5hdmJhcg== IHNhY2s= 57qn IFRocmVhdA== WkE= WE0= JyksCgo= IExMVk0= YXN6 RWRpdGVk V2l0aFN0cmluZw== U2lsdmVy eW5h X3JlbmRlcmVy CURFQlVH KG9wZXJhdGlvbg== IFNsb3Rz IEF1YnVybg== eGVj IGhvbW9zZXh1YWxpdHk= LlJlc3RDb250cm9sbGVy ZXJzaXZl IHByb2ZpbA== IE15YW5tYXI= cm9zc2U= X0lSUW4= IHNlbmRNZXNzYWdl IHRlY2huaWNpYW5z IG1hbmU= Y29tbW9ucw== IHNocmVkZA== Qm9vc3Q= IHN5bXBhdGhldGlj LWVmZg== IENlcnRhaW5seQ== IHfDpGg= IFJvY2hlc3Rlcg== dWNjaQ== dXJt ZW1wb3I= ICIiOgo= LXNwYWNpbmc= IHNpeHR5 IOKckw== X3JlcG9ydGluZw== V2ls b3lv IGRpZFNlbGVjdA== LmdldExvbmc= LnNldEVycm9y X25j IERvbmc= CWFzeW5j IEhpZ2hseQ== XToNCg== TGVha3M= LC4uLgo= dmFsdWF0b3I= ZGljdGlvbnM= b3hlbA== IGdlc3R1cmVz PSI/ YmFncw== IFJlbGllZg== c3Vic2V0ZXE= KG5hbWVzcGFjZQ== fXw= IG1pY3JvYmk= IHB1cml0eQ== Y2hpbw== fT8= X01VVA== X2FjdGl2YXRpb24= IFBpcmF0ZXM= ICUj aWZpY2FjacOzbg== 5Ys= IE5SQQ== w6dvbg== fSkoKTsK IENoZXN0ZXI= 4oCT4oCT Z2V0Q29ubmVjdGlvbg== LmFyZ3VtZW50cw== RmV0Y2hpbmc= IEZyeQ== IERpdA== IHppY2g= cGFzdA== LWxpYnJhcnk= IEhheWVz IGJvdW50eQ== IFNwcmluZ2ZpZWxk UE9S IEFQUg== IEVtYmFzc3k= UVVFU1RJT04= IFNvbGRpZXI= ZXJ0YXM= IE5PUk1BTA== IGR1cw== Ym9sdA== IGRvcnQ= IExpZnQ= IGdldFJhbmRvbQ== LlJ1bldpdGg= LCksCg== IHZhcmFyZ2lu IGhhbmRsZUNsaWNr XEh0bWw= IGhvbW1lcw== Y2lkYWRl KGVw SmE= L2RpYWxvZw== LnJhdGU= IFdlaQ== ZnVsbHNjcmVlbg== IE5Vbml0 Lm1lYXN1cmU= VmFscw== IFNpZ25lZA== IHJ1cw== IHJhZnQ= IEJsb25kZQ== IG5ldHM= IE1ldHJpYw== aWNoVGV4dEJveA== IHVyZQ== IGludGVycmFjaWFs ICd9Cg== KHN0b3JhZ2U= SW50ZWdyYXRpb24= IGJhbmNv QVNZ IGppbnQ= IGRlZ3JhZGF0aW9u IEhBTkQ= dWVyZG8= PScn IHN0cm9rZXM= cmV3cml0ZQ== KFNldA== IE1hdERpYWxvZw== IGRvc3NpZXI= CWFuZA== QURESU5H IG11dHVhbGx5 IHByZWNlZGVk fX07Cg== IHN1YnR5cGU= IHJlc29sdmluZw== IGdlb21ldHJpYw== W2NvbHVtbg== IENUUkw= IEhM IGRhaA== ICg7Ow== UmFpbHM= w5w= IEdlbmVyYXRlcw== LUxlbmd0aA== cGVkbw== b2dlbm91cw== IFJvYmVydHNvbg== LkJvb2w= b2RlcnM= X0FHRU5U cGFzc3dk IE5vZGVz LmJp IFdC IHByb3BoZXQ= c2xhdmU= IOW8 IHdlaWw= JTwv IGNhcmJz 5rC0 IGV4cHJlc3NseQ== XHhk LWV5ZWQ= IENyZWF0dXJl Y29udGFpbmVk KFNJRw== IEVuaGFuY2VtZW50 IENvcnM= R2Fs X1NJR05BTA== cmVpbnRlcnByZXQ= IFFQdXNoQnV0dG9u X05vbmU= IGdlbm9jaWRl IFNlYWw= 5LiK5Lyg KHBlcg== 0LvRjNGC IMOgcw== LlRlbXBsYXRl ICkNCg0K LnNpbmdsZXRvbg== CXNsZWVw IHNwYXduZWQ= IHBvc3Nlc3Npb25z Z2V0Q29uZmln IHRhaQ== bHVkZQ== IE1ldGVy IGJpYmxpY2Fs bWFyc2hhbGxlcg== LlRvb2xraXQ= IExlc2JpYW4= LnNtYXJ0 IGJveWNvdHQ= IGZyeQ== LWRlc2M= X1NlcnZpY2U= IG1hY2h0 IENhaXJv w6Bp X3ByZXZpb3Vz LnRyYW5zcG9ydA== TWVkaWNhbA== Q0dQb2ludA== UVVBUkU= IGJyaWdodGVy IGNoZWNrQm94 IEZPVU5E LmJyYW5jaA== IGJsYWg= IFByZWx1ZGU= T2ZmbGluZQ== TGlzdGluZw== LyoqLyou IEpS cGhhbnRz Z2V0WQ== LkZpbmRDb250cm9s Ii4uLg== 0LrQtQ== SFJFU1VMVA== IGNoZWNrbGlzdA== KGFzdA== IGJvcnJvd2luZw== 4oCmYW5k INCX IHByb2N1cmVtZW50 LXRhc2s= X2hhbA== UGxheWxpc3Q= LnN0YXI= X1NVUFBPUlRFRA== QVNN JUE= cmVzdHJpYWw= INC40YHQvw== IHBhZ2Vy IERpYWJldGVz IE1haGFy dGFu QWN0dWFsbHk= Pi8v IFhW 4KeN IHNlamE= LnZpc3VhbA== a2tlcg== XTsKCgo= IHR5cGVOYW1l LkJ1dA== Q2xpZW50UmVjdA== aWNhbHM= IERqYW5nbw== IFJhcGU= IHBheWRheQ== KHJlc291cmNlcw== LmJpeg== dG9p KFJ1bnRpbWU= IER5bmFtaWNz IEludmFsaWRPcGVyYXRpb25FeGNlcHRpb24= KHR5cGVz IFRhYnM= Lk1pZGRsZUxlZnQ= eGFi IF8o IERyZWFtcw== X0dyb3Vw KGNvcg== TGVhZGVy IGdyYWR1YWw= KEJpZ0RlY2ltYWw= IHRleHRhcmVh bGV0aW9u IEZpbmlzaGVk IFBvbGU= IHRhcHBpbmc= Jig= IGZsaXJ0 IHRlcnJpZmllZA== IHBhZHk= ZXJlZw== ZWxkb20= IHN0YXRpb25hcnk= IHBvbnk= IFJFR0lTVEVS X2FjY2Vs IEhlcno= IG1hdHJpeg== IENhZg== eGFj YXNjdXM= IGVubGFyZ2U= QUNIRUQ= eXl2YWw= IHNpYw== IENhbmFs OnY= PT8s IEltcHJvdmVtZW50 P30iLA== TlNPYmplY3Q= IGVzY2FwaW5n IE51bGxhYmxl IGjDpA== d2FudA== RWxpbWluYXI= IENMTG9jYXRpb24= IHJldXNlSWRlbnRpZmllcg== QnVmZmVyU2l6ZQ== w59lcg== IEFza2Vk J11dLAo= IHNoaWVsZHM= Z3JhbmQ= IFRvd25zaGlw IFB1Yk1lZA== ZWN0bA== Zml2ZQ== IFJlYWN0aXZlRm9ybXNNb2R1bGU= IEdMZW51bQ== RGFy aWZhY2U= LWluZGVudA== Rm9ybXVsYQ== LnNuYXBzaG90 Q09NUEFSRQ== IGJlbHRz CWNhY2hl bGRhdGE= IGVkYWQ= IEJPWA== KGNhcnQ= X0xBWU9VVA== IGZmbHVzaA== IExPUw== IFNvcnRlZA== LnNsaWRl IHRpamQ= IFRleGFucw== IFB1cmNo IExldmVscw== IHNlbWFudGljcw== IFRlaHJhbg== Ym1w LnVybGVuY29kZWQ= X3hsYWJlbA== KGd1bHA= IEJ1dHRvbnM= IEJyb2tlcg== 55uR5ZCs JGVtYWls 2ZA= IGNsYXNzaWNz Y29tcG9zZQ== KGJz IHVuaGVhbHRoeQ== RXhlcmNpc2U= Y3JldHM= IFBhcnM= IERldGVybWluZXM= YWZvcnQ= KG9icw== IG5hc3Q= IGlocmVu IHJveWFsdHk= c2VyaWFsaXplcg== aWV1eA== ICAgICAgICAgICAgICAgICAgICAgIAo= ZXhlY3V0aW9u IHZpZXdDb250cm9sbGVy IHJlcHJv LnBl IGNhcGl0YWxpemU= 5Ye7 IHR1bm5lbHM= LkRBVEE= cGlyaXQ= Q29sbGVjdGlvbnM= KX19 IE9E IGZ1enp5 SW1tZWRpYXRl bGo= Oz8+Ig== W3Zhcg== IHZvbGF0aWxpdHk= cmVnbG8= IHByb2xpZmVyYXRpb24= IG9yYWNsZQ== IEN2 IG51bmNh UFJJTlRG IGJyZWFrcG9pbnQ= LkVO IGJlc3Rlbg== IHJlYmVsbGlvbg== UGF1c2Vk IGZsb3du IHZpY2luaXR5 d3JpZ2h0 LGNw aXNjaW5n b3VjaGVycw== QXNo eWFy IEVq cmVwcmVzZW50ZWQ= b2RpYw== LmNyb3Nz IGNyZWF0aW9ucw== IFBhYmxv ZmVzdA== IEhpbHRvbg== UmVwb3J0ZXI= IERpbA== aWxlbmFtZXM= IGV4cGVuZGl0dXJlcw== X0VESVRPUg== IEFyaWFs IHBsdW5n IHVubmFtZWQ= T3JFbHNl IHJlY3JlYXRl IEhlYXJ0cw== PmFsZXJ0 LmdldFBhc3N3b3Jk IE11c3Rhbmc= Vks= IGFjY29tcGxpc2htZW50cw== QXBwZW5kaW5n IENheQ== IFVzZXJNb2RlbA== IHN1YnN5c3RlbQ== TGVnYWw= eW5jaHJvbml6ZQ== X1BFUk1JU1NJT04= IEFwYXJ0bWVudA== bGlnZQ== IGFmZmlsaWF0aW9u KERFQlVH VHM= IENvbG9yaW5n IFdvaG4= bmljZQ== KGxpc3Rh 4LE= cGxveW1lbnQ= 44G+44Gf 5aW9 c3Vic3Q= J11dWyc= YWJvbA== PSdf 4KeN4KY= b3JwaGlzbQ== LmxpdGVyYWw= IFBsdWc= IG13 b21hbA== ICInIiw= dXNp IHNpZ2hlZA== aWN1bHR1cmFs Lios IFByb3N0aXQ= KGNvbnNvbGU= SVBMRQ== IFRyYXA= WFI= IEVkaXRvckdVSUxheW91dA== X3ZvY2Fi IGluY29tcGF0aWJsZQ== IHVuY29uc3RpdHV0aW9uYWw= LWxh IGVyb3RpcXVl IGRlcHV0aWVz cXVpc2l0aW9ucw== bmV3VmFsdWU= YWRpYQ== IGh3bmQ= Z2luZ3M= IFZhcw== IEluY3JlbWVudA== IEZsaW50 YW1iaWE= X1BvaW50 LWRpc3BsYXk= IEZ1bm55 LnRvYXN0 LmRhcms= QmluZGluZ3M= IGRlc2NyaXB0aXZl YXJlbmQ= LlJldA== IHJlY3Vyc2l2ZWx5 IE1r IFRJTEU= LmNyZWF0ZVRleHROb2Rl IFJBVw== IGluZmx1eA== 54mp VG9r LWJvYXJk UmVjb3JkaW5n U3RyZW5ndGg= IHJhaW5mYWxs KGRk LmZ4bWw= bmV0cw== LkltYWdpbmc= IEJJT1M= XSsi T0U= IHJlc2lkZW5jeQ== WkU= V0I= LnNwYW4= X2RlZmluZWQ= Qk9U Pm51bGw= Zm9ybURhdGE= Q3BwTWV0aG9kSW5pdGlhbGl6ZWQ= X1VTRVJT IE5vdmVs aW5za2k= PntA ZXR0bw== bmF0dXJhbA== IFN0cmljdA== Onc= LnNhZmU= IHRvd2Vscw== 4bqtdA== LmdzdWI= 66M= aW5xdQ== IGFpZGVz IGluY29t Z2V0dGVy IHdhc2hlcg== YWN0b3JpZXM= IGdldHRlcnM= bWl0ZQ== X3NvdXJjZXM= IGhhcm1sZXNz IHVub3M= cHJlaGVuc2l2ZQ== IG5vZG8= IGdlb2dyYXBoaWNhbA== IFNlbGVjdExpc3Q= LlNjcmlwdA== LkVudW1z IEVOVEVS d2FsZA== IEJhcm9u IHBhcnRpY3Vs LmN1cnJlbnRQYWdl QFRyYW5zYWN0aW9uYWw= W2xpbmU= CWRlcw== SmFzb24= LmdldENvdW50 IFBlbm55 IFBheWxvYWQ= c2hhcnA= W3JpZ2h0 dmVudGE= IGFwbA== IHByb2R1aXRz IG90dA== VHJhY2tz LkFuZHJvaWQ= IHNpbGljb25l IEVMU0U= YW5pbWF0aW9ucw== dWx0dXJlSW5mbw== IGJsdWVwcmludA== b2ZzdHJlYW0= IFtdW10= IFNlcnZl IHRyaWc= CXNlcnZpY2U= IFN0cmF0 IFNhdmFnZQ== IG9ianM= IE5vdGlmaWNhdGlvbnM= LHBvcw== VGhpbmc= IFJCSQ== b3BhdGh5 IG5hdWdodHk= bGJz ZXByb20= PiIu IHBpb25lZXI= IGphcGFuZXNl QXVk IGFsbGV5 IFBldHNj J10/Pg== IEtpbGxlcg== LmdldEFic29sdXRlUGF0aA== X2NhcHM= xas= IHN1YnN0cmF0ZQ== LmFzc2VydElu 7JWE IHRoeXJvaWQ= IERlbHV4ZQ== IGZhY3RvcmlhbA== IHByZXNzZXM= IEFjY29t PW9wZW4= LmdldFM= IGV4cGxvcmVy IHJlc2lkZXM= QXNzb2NpYXRlZA== IHRyYW5zZm9ybWF0aW9ucw== VHU= IFJpY2hhcmRz X2JpcnRo PSN7 LXNwZQ== KG5k IHZpc3VhbHM= X3N0YW1w IHRlcm1pbmFscw== cm91dGluZQ== KioqLwo= IEphYg== S0w= Q29udHJpYg== IHNvdXRod2VzdA== IFBlcA== CWVudGl0eQ== IGxpbmVy LlN0YXR1c09L IFNjaHVs KENM IG1pam4= YXN0b3M= X2RpZ2VzdA== IHBlcnNpc3RlZA== LWNvbnRhY3Q= IG9kb3I= IGRpc2NvdmVyaWVz X0ZJRUxEUw== Rmx5 IHJ6 IExpc3Rh UmVzZXJ2ZWQ= dGF4b25vbXk= KXNlY3Rpb24= LyIpCg== L3JlcXVlc3Q= IHNvbWVkYXk= Y2l0aWVz L2ZpcmU= IG9iamVjdGlvbnM= CURFQ0xBUkU= Lm5hdmlnYXRpb25JdGVt LnNldGRlZmF1bHQ= cmV0dXJuVmFsdWU= VUNDRUVERUQ= IG9ibGlnZWQ= IFFhZWRh IGh5c3Rlcg== ZXN0aGVz ZGlzdGluY3Q= w6B5 IENvbWJv CXNm IOKK IGRpc2NyZXBhbg== IGluc2lnbg== IFJFU1VMVFM= IFZhbGlkYXRpb25FcnJvcg== IEh0dHBSZXNwb25zZVJlZGlyZWN0 CVFTdHJpbmc= IGF1dG9mb2N1cw== RHVy IFJFTEVBU0U= LWRvbGxhcg== LkNvbW1pdA== IGtow7RuZw== IGxhdW5kZXI= Lj0i IOaWhw== IGJ5ZQ== LkdldEtleURvd24= IGdpbw== X3NpZA== IGdxbA== LmNt X1NMT1Q= LkdldEluc3RhbmNl cmV1c2U= LnNodXRkb3du IGplcnNleXM= X01Q cGF0aWJpbGl0eQ== IOiuvue9rg== IHJlcGxhY2VtZW50cw== IHByZWNlZGVuY2U= IGJ1ZmZlcmVk LmJz X0dSRUVO YnJhaW4= w6FjaA== YXZhaWxhYmlsaXR5 IEVURg== IGZyZXQ= aXN0aW5l IGxpZnRz RXhpc3Rpbmc= IHN0ZXJlb3R5cGVz IGVtcHQ= bW9uZ28= LnRyYWluaW5n YWxpc3Q= LklzRW5hYmxlZA== ICIh PD8K dWlkbw== IGludFZhbHVl LmVsYXN0aWNzZWFyY2g= TE9HSU4= IHJlbGlhbmNl IHZpZXdUeXBl IGRpbWluaXNoZWQ= U2FyYWg= IEFwcHJvYWNo X1dFQg== IGRybQ== IGNvbHVtbmlzdA== TWFya3Vw IGFxdcOt IERpYW5l IGN3 IFRpY2s= Lm9ic2VydmU= SVJPTg== SW5CYWNrZ3JvdW5k IGVib255 IENvdXJ0ZXN5 Om51bGw= KioqKioqKi8KCg== L3Jlc291cmNl SXRlcmF0aW9u ZGVmYXVsdFZhbHVl YXR0ZW50aW9u INGA0LDQsdC+0YI= IHdhaXZlcg== IHByb2R1aXQ= IEdyYWRpZW50 IHBlcmNlbnRhZ2Vz IFNBTA== IE1k KHNuYXBzaG90 CWlv aWtlcnM= V2VicGFjaw== IHNldFBhc3N3b3Jk IGRlZmVhdGluZw== IEplZw== ZWxhcHNlZA== aG9sZHM= X3NoYWRvdw== IG9mZmVuZGVk IFBhbnQ= IENhbGxhYmxl X0lORk9STUFUSU9O ZmZlZQ== KGVtcGxveWVl IFlBTUw= cG9zc2libHk= IG1heGltYWw= ZWxsdWxhcg== IFNueWRlcg== ZGVzY3JpcHRvcg== IFBMRUFTRQ== RGxnSXRlbQ== IGFydGlsbGVyeQ== YH0K cG9zaXVt IGxlZXI= JWM= IGRpc3Bvcw== Lm11bA== IGdlb2dyYXBoeQ== IGdyYXBoaWNhbA== IGRyYW5r IG1vdGlvbnM= IHJ1dGg= KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio= IHByb2R1Y3Rpb25z IGNyZWF0ZVRpbWU= IFNjcmlwdHVyZQ== YmJi dWNocw== 5LiN6IO9 LkJpZ0RlY2ltYWw= c2l6ZXM= X3NvbHZlcg== X0Zyb20= X2pvaW50 IHBhdGhsaWI= IGdlYXJz INGE0L7RgNC8 IGNvbmNlYWw= IGRpZmZlcmVudGlhdGU= PEdhbWVPYmplY3Q= IGplZGVu IGFsbw== Z2xvYmFscw== ZXJ2YXRpdmU= IHBhZGQ= IFBseQ== X3R5 IHByZXNlbnRl IHByb3ByaWV0 X2xz IFB1bmNo IENyYXdmb3Jk YmVsb3c= Q3BwR2VuZXJpYw== IENPTlRST0w= IG9jZWFucw== IFJPVVQ= IHJhbmRpbnQ= CWFkZHI= IEhvbmVzdA== IGVudmVsb3A= IHRyYXVtYXRpYw== IExBVA== IHRn 7Iqk7Yq4 RXh0ZW5kZWQ= IHVuY2hlY2tlZA== IG9ic3RydWN0 X3RpbWV6b25l UGVyc2lzdGVudA== IGxsZXY= LyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKgo= IEZsYQ== LnBoeXNpY3M= IGZvcmdlZA== IExhdXI= IG1vbm9wb2x5 IGNocmlzdG1hcw== Z292 IFNtb2tl W2Rm IGJpc2hvcA== bG9jYWxPYmplY3Q= b3JyaA== b250dmFuZ3N0 ZHJ5 IGVyZm9s LWNl IE9yZGVyZWREaWN0 IGh4 IFJFU0VU U3Vj IHJlY2tsZXNz YWxhbWF0 QmlnSW50ZWdlcg== IGJ1bGJz IG11dGU= 5pS+ LlVsdHJh TG9u IGNsZWFyVGltZW91dA== PFJpZ2lkYm9keQ== c3dpcGVy IENvbWVz XGRi CW1w IHJlc3Rz TW92ZWQ= IExvcmU= LkRpbWVuc2lvbg== IE1hbml0 Lmh4eA== PT09PT09PQ== cGl0Y2g= ZmZpZWxk c2tpbGxz X2FsYnVt dHJhbnNsYXRlZA== IFhJ IHZlaW4= IERhdmlkc29u IEF1Y2tsYW5k eXNzZXk= IGF1dGhlbnRpY2l0eQ== IEFzc2lzdA== IGNvbXByaXNl Q3JlYXRlVGltZQ== IHRyZW5jaA== LndlZWs= LS07 IFVJQWxlcnRDb250cm9sbGVy X3JlbGF0ZWQ= Q01T cmVtZWx5 IGxleGVy aXJtd2FyZQ== RWxlbWVudHNCeQ== LXVwcGVy IHN0YWdu LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ== X3NuYXBzaG90 L1hNTFNjaGVtYQ== X09yZGVy IGFubmV4 X0VOQ09E IEFsdG8= YXJpb3Vz REo= IGFib3J0aW9ucw== Q29tYmF0 IExpY2VuY2U= dWdnZXN0ZWQ= W0s= LCkpCg== KCcvLw== LkNhbg== c2Vjcw== cXVvdGVz X3RyeQ== IFNhZ2U= IE1vdg== J29u cmVnaXN0 IFdyaXRlcw== IERpZ2VzdA== CWNvbnRhaW5lcg== LXByb2dyZXNz IGdvYXQ= X3NjaGVtZQ== LkdldENoaWxk IGFzeW0= Lm15YmF0aXNwbHVz YXRpY2E= cGdzcWw= X2Fzc2V0cw== Pks= IGFmaW4= TlNT IE5BVg== KCcuJyw= IGAi IGF1ZGl0b3I= X01PVVNF IHdhbGxldHM= IG1vdQ== cnVucw== ZXRlcmFuZ2Fu IFJlc2VydmF0aW9u IGV4cGVyaWVuY2lh CXByb2Nlc3M= LWltcG9ydA== X1JldHVybg== IE1hY3Jv IFBlbmlz cGl4ZWxz IHNldEVtYWls KE1pZ3JhdGlvbkJ1aWxkZXI= KHhz IEVzdG9u IEJ1YmJsZQ== QUxMT1c= CWhhbmRsZXI= JHJldA== IGNvbXBsaW1lbnRhcnk= LWNpdHk= IGVsbG9z IFNPVVJDRQ== IEFkdmlzb3I= b2xvZ8OtYQ== IGZhZGVk LnBj X1JHQkE= QUZY IHJlcGF5 IEZhbGNvbnM= X2lzc3Vl b21pZG91 LmJhb21pZG91 IGluZnJpbmdlbWVudA== dXJuaW5n L3N0b3JhZ2U= X3F1YW50 IFF0Q29yZQ== IG1lbGw= X2RlbnNpdHk= IEtub3g= IFN1cnZpdmFs LmdldFVzZXJuYW1l IGNvbW1lcmNpYWxseQ== Z3Jhc3M= IG1laXM= 5Lq/ IFBlcm1pc3Npb25z X1FVT1RFUw== aXBob25l IExPVA== IHRocmlsbGVy IENoYXBlbA== IFJpcw== Pmk= LUlE IHJpZ2h0bHk= Q3J5cHQ= IElzdGFuYnVs cmVkcw== X3Jlc2l6ZQ== UG9wdWxhdGlvbg== KGZldGNo IEhPVA== OmZpcnN0 IGdhZGdldHM= UHlPYmplY3Q= IG1lcmdpbmc= ZHVjZWQ= bGVnYXRlcw== dWJlY3Rs JS8= YWxsZWU= IHp1c2FtbWVu LlByb3BUeXBlcw== YXN0bw== Oio= cmVjZQ== UmVzcG9uc2VUeXBl L2dyb3Vw IGJhcmJhcg== IENhcm9saW5l b3VyY2Vk 57uP IGx1YnJpYw== aW5zcGVjdGlvbg== YW1tYWQ= CUltYWdl IGllcnI= IGN1cnRhaW5z X0FSQg== IE9yYWw= IGFsbGllZA== IFN0YXR1c0NvZGU= IENsZWFybHk= UHJlZmVycmVkU2l6ZQ== cXVpbmE= IHNwb3M= IG9wdGltaXNt IGNvbXByYXI= IGx1Zw== IEJvb20= Y29uZmlybWF0aW9u X0RVUkFUSU9O X2Jyb3dzZXI= IHJlcGV0aXRpb24= IGtlZXBlcg== IGFkZFRv KGpz LlN0YXQ= LkNvbmQ= IEhlcm5hbmRleg== cGFxdWU= IHZvbHVudGFyaWx5 IGplcms= IExleQ== IGRvY3VtZW50bw== X2RlYWQ= IFRFQ0g= IGluY2VwdGlvbg== KCJ7fQ== IG9uTG9hZA== eGRk IElTUA== c3BlY2lmaWVk IOusuA== UFJPQ0VTUw== KGFsZXJ0 Lk1N IGNyZWF0ZVN0b3Jl KHVuaXF1ZQ== LmdldEJsb2Nr 656Y dW5vcw== IHRyb3BoaWVz X2hvdmVy IERhZGR5 Lk1l IENPVVI= T0JK YXRlbWFsYQ== IFBzaQ== IG5vcm1hbHM= YWNpZXI= IE1CQQ== IHBhd24= z4U= IHNwb250YW5lb3Vz IGF1eGlsaWFyeQ== IGluYXVndXJhbA== IGZhc3Rpbmc= IEZpbGVTeXN0ZW0= IHplbg== X0JMVUU= IHN1YnRyZWU= IHByZXByb2Nlc3M= LXRyYWNr Q2hhcmxlcw== IGRlcG9zaXRlZA== IHF1ZXJ5UGFyYW1z 0L7Qu9GM0LrQvg== aWVtYnJl IHByYXc= eEZD IHBhbmM= X25vbQ== aGVyb2Vz Lmphdg== OjokXw== INin2YTZhQ== U0dsb2JhbA== 5o+P6L+w PXRlbXA= ZXN0aQ== IGNvbnN0cnVjdGl2ZQ== IFNoaW0= IERpcmVjdGlvbnM= IEJpbmc= ZGlydHk= LXJ1bm5pbmc= X2ZpbGVwYXRo b3JkZXJJZA== Z2FyZA== X29yaWVudA== IHNjb3V0 IHBzeWNob2xvZ2lzdA== 7LY= IOWt ZGVxdWU= IEhlcm1pb25l IFBvd2VyUG9pbnQ= IGVsbGE= IFVJQmFyQnV0dG9uSXRlbQ== U3Vidmlld3M= QFJlcG9zaXRvcnk= IiIiCgoK IHJldG91cg== IGNpcmNh R3JhcGhpYw== IEdyYXR1aXQ= ZGR5 IHRlY2huaWNpYW4= IENsZWFudXA= IHBlcnNvbm5l IHJlc2lu Lk11bHQ= JG0= IE9yY2hlc3RyYQ== IHdoZWVsY2hhaXI= LlND CUdhbWVPYmplY3Q= IG1vxbxl T3BlbmVk IGNoaWNrZW5z b3Rhcw== X3RlbXBlcmF0dXJl IGRldGVjdGluZw== IGFjcXVhaW50 IDw/PSQ= Pl0= IG1lbnN0cg== IGR5ZQ== Um9ib3Rv LnVuaXRz IFZpbnls Y3VyYQ== cnlwdG9u ZWRk PXRlc3Q= IHRyb3Y= Q29uZmlybWF0aW9u IHRoZW9sb2d5 IEhvbGRpbmdz dWF0aW5n UHJlZGljdA== W3VzZXI= IDon IFNlc3Nv cGFyZW50SWQ= Q29kZUF0 YWJibw== IFRyZXZvcg== IFF1aXQ= X3NoaXBwaW5n X1JB IGtsZWluZQ== 56Y= X0xhYmVs IE9tYXI= IEdSRUVO LykK cm9r IHJvYXN0ZWQ= X1JU IOKAjg== QFJ1bldpdGg= Pk5O IHRhbmQ= Kycu Y3J1ZA== LmtleWJvYXJk YXN0ZXJ5 QkFE IENvbHVtbnM= LkNvbXBhbnk= IHNlbWluYXI= IGdldENvbnRlbnRQYW5l IGNhdGFzdHJvcGhpYw== IGVtYnJvaWQ= aWF0aXZl IGNydWVsdHk= Ymlz IGluc2U= IEJyb2tlbg== CWZz IG1WaWV3 0LDRhtC40Lg= LWZhY2Vib29r IGNhY2hlcw== 44CC44CCCgo= IE9STQ== IERpc3RyaWI= IFNjZW5lTWFuYWdlcg== X3RyYW5zaXRpb24= b21leg== IFNIRQ== IHdvcmtsb2Fk U3VwcG9ydGVkRXhjZXB0aW9u IHJpZXM= IOWc KGNhdA== SGFzTWF4TGVuZ3Ro QXBwcw== LlRBQkxF IEtleVZhbHVlUGFpcg== ZWRpZG8= LlJlbmRlcmluZw== IGVsZWN0cm9t IGFyYml0cmF0aW9u IHZhcmlhYmlsaXR5 YXBvbGxv IHV0bW9zdA== b3BlbnNzbA== IGjDpQ== KCcm LlN0YW5kYXJk IGRpc3RyYWN0aW9u aWZheA== IOuVjA== dGhvc2U= aXNwZW5z dmFr IFNVUA== IElzUGxhaW5PbGREYXRh LGtleQ== ZnJhZ2lzdGljcw== IEpveWNl IEZpYmVy LlNlcnZsZXRFeGNlcHRpb24= X0FsbA== IGJhY2tlcnM= IEF0dHJpYnV0ZUVycm9y ewoKCg== QHlhaG9v LWRpcmVjdG9yeQ== IHVuaW5zdGFsbA== IGZsdW9y bGlxdWlk IGzDoQ== IGZyaWdodGVuaW5n YWRhbg== IEFVVA== IHRhdHRvb3M= IHByb3BhZ2F0aW9u LnRyYW5zbGF0aW9u 0J/RgA== X3NjaGVkdWxlcg== 44CC4oCc IGNhaXJv IEh0dHBDbGllbnRNb2R1bGU= IE5EUA== IEhpdHM= IFRyYW5zZm9ybWF0aW9u IENhZXNhcg== c3RpbQ== IEJ1cnRvbg== d3lu IGNvbW1hbmRlZA== IENsb3RoaW5n IFJ1bnRpbWVPYmplY3Q= cmVhbGx5 Y2xh LnNh IFNoYW5ub24= IGNvbW1pc3Npb25z IEphbmV0 IGRpc2d1c3Rpbmc= IG9wdGltdW0= X3NvbA== dXJvbnM= IFNIQVJF QXR0cnM= IFNjaGU= IEJpZ051bWJlcg== IGNpZ2Fy KGRlcHRo IGZyYWM= IEN1cnZl TEFTVA== IFNDUklQVA== 6rO8 TWFsbG9j Lmdyb3VwYnk= IExlc2xpZQ== IHdoaWNoZXZlcg== U21hcnR5 L3dl IEFtcA== LGlu bG9wcw== ZGVwZW5kZW5jeQ== Y2VkdXJlcw== IGB7 eGljbw== Q29sbGVjdG9y IGhhYw== IERhcmtuZXNz ZmZmZmZmZmY= Jz0+Ig== IHBsZWFzaW5n Y29ubmVjdG9y em9z UENJ dmFj IEluY29ycG9y IG5lZA== X0ZBQ1RPUg== LmZi IG91bmNl X3NhdmVk INix IGRlZWRz IERvbHBoaW5z IGJ1ZW4= RVND LHRpbWU= X0FVVA== ZWNz IFNlbmF0b3Jz Lm91dGVy IFNlbGxpbmc= IHJpbg== PmAK Lm9ic2VydmFibGU= IGNvc3Rpbmc= REc= IHdpbmRpbmc= IHNrYQ== IGNpcmN1bGF0aW5n IGZvcm1pZGFibGU= YW1wbw== IFJhaXNlZA== IHZlZ2V0YXRpb24= VUZGSVg= S2lsbA== cHRpdmU= KHJ2 IENvdW50cmllcw== IE5ha2Vk IEpB KSkiCg== dWRhcw== IGJhcms= CWxldmVs IGZvZXM= PkFkZA== WW91VHViZQ== O3Q= TkNZ Q2x1Yg== RWlu LS0NCg== IGNvbnN0cmFpbmVk RVR3aXR0ZXI= WUc= RGVzY3JpcGNpb24= VU5DSA== IGVucXVldWU= IGRpc2tz IFdlbnQ= IG11aXQ= CWxvY2F0aW9u IHJldmlzaW9ucw== IEFDSw== LWZpeGVk dHJhc291bmQ= XFRlc3Q= U3RhcnRQb3NpdGlvbg== LWh0bWw= IHByb2JsZW1hcw== X0lOVEVSUlVQVA== IFNUT1JF 5qih aWxpYXRlZA== IFJQTQ== W3RlbXA= YWNodGVu IGNpYw== IEF1dG9tYXRpb24= IGhpZ2hz Lyg/ OicpCg== c3Bhcms= cmVscw== CW1vdg== VVRFUw== LkF1dGhvcml6YXRpb24= IFNjaG5laWRlcg== IGNoZWVrcw== YWRkcmVzc2Vz YXJkaW4= IHJlbW92YWJsZQ== LkJhZFJlcXVlc3Q= aWNpb25hcg== IERpZXNlbA== dGhhbg== L34= IGRhenU= UmVnaXN0cm8= ZmZp X0RMTA== IG5pZXU= IG1vaXN0dXI= LWV2ZW50cw== IHRocmlsbA== LmdldEVudGl0eQ== IHRvZ2c= IHdhdg== KWRpZA== YXRr KHN1YnN0cg== IEluamVjdGlvbg== X21i LkRpdg== IGVuZGVhdm9y ICjCow== IGNsdXR0ZXI= IHVyZ2VuY3k= IGluc3RydWN0b3Jz LScs LXN0YW5kYXJk Y2Vt CWhhbmRsZQ== LmZ0 U3RlcGhlbg== Um9u 44GZ44KL c2Np IEF0bW9z IGNhdGVyaW5n IGZpYXQ= LlBlcmNlbnQ= IENvbmdv eGRm Lm1vemlsbGE= IHNlaGVu LnNob3dUb2FzdA== T09U LXJlc3VsdA== zIE= IGdob3N0cw== IEJ1ZW4= IFJpZGVy IERvY3RvcnM= IHVyYW5pdW0= IGxvdWRseQ== IHBvaXNlZA== IGZhdm9ycw== KEFQ TEVZ IHNpY2tuZXNz IGNoYXR0ZQ== IGludGVncmF0aW5n IFl1cA== Q2xvc3VyZQ== IFRhbGVz IGxpbmVh IGV5ZWw= LkNyeXB0b2dyYXBoeQ== dW5leHBlY3RlZA== YWxlbWVudA== Y2l0 ZXRBZGRyZXNz TGVhZA== eGNk X25lZ2F0aXZl X2NvcnI= aWdyYXBo LWNoYW5uZWw= IGRpc2Nv U2VlZGVy YmVhbQ== X2Rw Q0ND IFByb3ZpZGVk IGpzb25EYXRh X1dI RklORQ== Qlg= LkRhdGFBY2Nlc3M= IHRlbXB0ZWQ= IGZpbmVk aXNDaGVja2Vk IGZyYXVkdWxlbnQ= RnJp IGRvbWlj UXVpeg== IFVuZGVyZ3JvdW5k YWJyYXM= IElEaXNwb3NhYmxl IFBlcnNvbmE= IHJvZ3Vl IEJleQ== Z2V0Q2xpZW50 ZWtlbg== ICcnJw0K V2lraQ== KEh0dHBTdGF0dXM= U3RyZXRjaA== IEdlc3Q= IO2VmA== IGVudGl0bGVtZW50 IGRvZW4= YmxvZ3M= IHZpdHJv Ik9o IFN1bW1vbg== IEJhY2tib25l IGfDvA== Z2V0Q29sdW1u IFdJTkFQSQ== CXZh X1JFUVVJUkVE LnRocm93 IHNldEN1cnJlbnQ= ZHVjdGVk KEZ1bmN0aW9u ZWxzaW5raQ== X1Blcg== ZmxpZXM= IGluY29tcGV0 IGp1xbw= KCkl IC0tLQo= dW1hcw== IE9sZGVy IGRpc3B1dGVk X1JFUVVJUkU= Lm1hdG11bA== dW5rZW4= 5LmL 44GL44KJ IHR0bA== dW5kZXJzY29yZQ== IFBhdHJpY2lh IHRhcGVy IHNlaW5lcg== IHNheWE= 5Y+w aWVyaQ== LnNlY3JldA== IHhvcg== IG1pdG9jaG9uZA== IGNhcmRib2FyZA== fWB9 LUJFR0lO IGRhdmlk b3Vsb3M= IFBldGVyc2J1cmc= ICIiLA0K c2hlbGY= LXdhdGVy LWJ5dGU= INC+0LHRitC10LrRgg== IHN0aXJyaW5n 7Je0 IGNvbXB0 IFBvdGVudGlhbA== UkFGVA== IGVhcHBseQ== IHN3aW5naW5n IGZlYw== QVJB IHdhbmRlcmluZw== IHByZWZlcnM= SmVzdXM= IHBpcmF0ZQ== IElzaXM= Lk1pbmltdW0= IFZhbGU= X0JU cmVuY2hlZA== Y29ycw== KGl0ZW1WaWV3 IGfDpQ== LkNvbnRhY3Q= Vmlld0NoaWxk aW5kc2F5 Y29uZmlncw== RHVwbGljYXRl 4oCmSQ== enlzdA== KHRvZG8= LlJlbW92ZUF0 X0RJRkY= IEJvdHRsZQ== IHZvbHRh dHJhZmZpYw== TGVl IOyk IHR1bmVz IEVjdWFkb3I= IFl1bg== IHVuZGVyd2VudA== aWNvbQ== ICcnKXsK LXBvbA== ZmxhbW1hdG9yeQ== TXV0YXRpb24= IHJlY2Fw X3ZlcnQ= T1RJT04= Q0RBVEE= aWNpbmU= X2JvdW5kYXJ5 U2NhbGFycw== IFVsdGltYXRlbHk= RVE= bWV0YWw= a3Nlcw== bXBs IGNvbnRlbg== U29sZA== RVNTQUdFUw== IGJpbmRlcg== IGxpbmVu IE15QXBw LW1ldGE= CXJhaXNl b3VsdHJ5 CW1vZHVsZQ== 5pi+56S6 bsOt IHlycw== IHBoeXNpYw== LXBsYXRmb3Jt IHN3aW5nZXJz KGhlYWRlcnM= Licp IEJV IEluY29udHJp U2NlbmFyaW8= QW1i IHByZW1pw6hyZQ== L2FydGljbGVz IE1ham9yaXR5 Q0xVU0lWRQ== b25vcg== IGhhYsOtYQ== 5bee IG1pZGk= IExhYw== LmZpbmRJbmRleA== IFBhaW50aW5n LmJvcmRlckNvbG9y Kmo= IGNvbmdlc3Rpb24= X0RJQ1Q= b2xsZQ== YXJuYXRpb24= KHRleHR1cmU= IHVm IEVpbnN0ZWlu KFRocmVhZA== IGluZG9vcnM= c2NyYXRjaA== IG1ha2Vu LlNUQVJU IEp1ZHk= Zm9ydW1z CgoKCgoKCgoK QklMRQ== IHZvdQ== TVlTUUw= IGdlcm5l IEltcG9ydEVycm9y IFN1cnJl PG5hdg== IERpZXNl ZXdhcmU= IOuqqA== aW1wbGVtZW50ZWQ= U0lHTg== ICd7QA== cnpl Lm1pbmVjcmFmdGZvcmdl LmlubmVySGVpZ2h0 YmVjaw== IGN1cnJ5 IGZvcm11bGFz YWdvZw== ZW5kZXQ= IFBhaWQ= IFJvYmVydG8= IHVucGFpZA== PWhlYWRlcnM= LlBvd2Vy IGJyZWQ= b3JFbHNl b3hpZGU= IGZpbmFsaXpl c2V0Q29sb3I= IFN0YWR0 KCdcXA== aXNtaWM= IGhlbGU= LlByb3RvY29s Lkhvc3Rpbmc= X01lbnU= X2NvbmRpdGlvbnM= IHB1cmdl LnhhbWw= YmFyZQ== RlJBTUU= IGN1YmVz IEpvaGFubmVz b2NyYXRz LkRpcmVjdG9yeQ== KWE= Pyk6 X0xJQlJBUlk= IGdldFRva2Vu IGVjaG9lZA== PWg= X3NvYw== IEV2YWx1YXRl IOq4sA== IERlbGV0ZWQ= RXU= IGNsb25lZA== c3RhdGlzdGljcw== LkNhbnZhcw== IGhhY2tlcg== IGdhbmdz LnJlc3VtZQ== cGVhY2U= 0JLQstC10LTQuNGC0LU= IFByb2NlZWRpbmdz 56U= IGphcGFu ID8+Pgo= ICR7KHs= LnJlY3RhbmdsZQ== Z3c= IE9yaWVudGF0aW9u JW0= LiIpKTsK IExpZXV0ZW5hbnQ= LnRydWU= IGVsdA== IERJUkVDVE9SWQ== zq8= LmRheXM= dXR0Z2FydA== IHVuZGVyd2Vhcg== LCkK Q0lE aW1lbGluZQ== IEJsZW5k cGhhc2lz IHBlcnNl IGdsaXR0ZXI= IHVuaXE= IENvbWJvQm94 IHNlc3Npb25JZA== dXN0ZXJpdHk= SURHRQ== 0L7QsdGJ 0KQ= cmVuZGVycw== X3Bvc2l0aXZl X3Nsb3Rz YnJvYWRjYXN0 IE1vbGQ= L0NvcmU= IEJhbm5vbg== VG9vbEJhcg== YWJlbGxl X2F3 b2xlY3VsZQ== IGRlbGV0ZXM= IMOhcmVh IHByb3BvcnRpb25hbA== TVc= IHdhcnk= IGludGVybWVkaQ== ICoqKioqKioqKioqKioqKioqKioqKioqKg== LlNUQVRVUw== X3R3 IGFyb21h IGFjdGl2aXNt LklzTm90TnVsbA== dWF0 IHBvc3REYXRh IHBlbQ== X2N0b3I= IFJhcGlkcw== LW9mZnNldG9m IGluZWZmZWN0aXZl IG9uRGVzdHJveQ== IE1ldHJpY3M= IHBhZGRpbmdMZWZ0 LWVuYWJsZWQ= IEdvYWxz eW5jaHJvbm91c2x5 IHllcg== SXRlbUF0 IE1ZU1FM Y2Vzbw== LktpbmQ= dGVj KGJ1bmRsZQ== IHJlZmVyZWU= LiI7DQo= IGNvbmV4 IGJpa2luaQ== X0FQUExJQ0FUSU9O IHN3ZWxsaW5n IGJlYWRz IGJhcmdhaW5pbmc= LS0tLS0tLS0tLS0KCg== IGtpdGE= KmZ0 TWluaQ== IFRvbmlnaHQ= IG1hbmlwdWxhdGVk TWlycm9y IFBvc3RhbA== IG1hcmU= RFc= IGNvbXBpbGluZw== IGZvcmVuc2lj LmdldFZpZXc= ZXBpbmc= Q29z IGFjY3JlZGl0ZWQ= IG9iamV0aXZv Y2FyZXQ= UGFpcnM= KT4+ IHNlw7E= IHF1b3RhdGlvbg== IEJyYW5kcw== dWJp eXB5 IElubGluZQ== aW1ldGVycw== V2ludmFsaWQ= CWxpbms= IEJlbGZhc3Q= IE1lYXN1cmVtZW50 X05PVElGSUNBVElPTg== IHJveQ== IENHQ29udGV4dA== IHdlZGRpbmdz VVJOUw== IHBvZGNhc3Rz IFNlcmc= IOuNsOydtO2EsA== IGVhcm5lc3Q= Y292ZXJhZ2U= aXRlRGF0YWJhc2U= RW1wbG95ZWVz IERlbWFuZA== IGNvbnRlbmlkbw== IFFWZWN0b3I= IiwiXA== IEdlcmFsZA== KClg IGdyaWRCYWdDb25zdHJhaW50cw== UkVTT1VSQ0U= IFNhZw== YWJpbGlkYWQ= IGNvZXJj b3VuY2VtZW50cw== IElzbGU= LmVkZ2U= IGV4dGVy KV1b IFBsYXlsaXN0 IEJsaW5k IFZpdGFs IGxhdHRpY2U= cmF0ZWQ= ZGVwZW5kZW5jaWVz IGBgYA== IEthbmc= bWFjaA== LmZhZGU= IEd1ZXNz Kls= TmF0dXJhbA== Lk9r IFJlbmFpc3NhbmNl IHRodWlz IGxpa2Vu Kmg= XCcs LWNsb2Nr IE9iamVjdGl2ZQ== ZmluZE9yRmFpbA== IERpcnR5 IHNjYW5k IFZBUklBQkxF IGNvbXBhcmF0aXZl eXBhZA== KFNvdXJjZQ== ZWNv IGp1c3F1 CWFwaQ== QnVpbHQ= ICMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMj IGxhYmVsaW5n IGhlYWRhY2hlcw== IG11ZmY= IE9yY2g= IGhhdGVz LWJyZWFraW5n L2J1dHRvbg== IEJ1eWluZw== TWV0cmlj IHVuc3BlY2lmaWVk L2hlYWQ= IHN0aW5n IHJlaW5mb3JjZQ== IENvbVZpc2libGU= Ymxpbms= IEFobWFk ZGJn X2xibA== IGh0dA== 7JuQ cm9wb2xpcw== ICgoX18= IHBlcm1l IGFwcGFyZWw= U1RSRUFN Y2h0cw== IHNlaW5z ZmlsbFR5cGU= 7KO8 Uk9XU0VS dW1waW5n IE5pZ2VyaWFu 4oCUaXM= X2xvZ2lj Lk9yZGluYWw= bG9zdA== L3Vzcg== QWY= IEl0ZXJhdGU= aWJz YWFs IHN5bW1ldHJpYw== LGlucHV0 IFBMTA== dXppb25l Y2FwdGNoYQ== IFRhbGU= RXhwaXJlZA== IE9iamVjdE1hcHBlcg== Y2lkbw== LmdldE5leHQ= IG1lbmphZGk= OnNlbGVjdGVk IHJpZW4= X3NlbmRlcg== UHdk IEZsaWNrcg== LkphdmE= X3ZvdGU= X01vZGU= LiR7 IGZ1Y2tz IEFsaWJhYmE= IGluc2lkZXI= YWNpbWllbnRv IGZyYW7Dp2Fpcw== SlNPTkV4Y2VwdGlvbg== IEp3dA== TWl0 bGVpY2g= IHByYWN0aXRpb25lcg== L3NvdXJjZQ== IG9nbmk= IHBoaWxvc29waGVy U25hY2tCYXI= c3RlbGx1bmc= KGJpdG1hcA== IGFzdGVyb2lk IG1hcGxl dWNoYQ== aXRlbUlk IHN0ZWh0 T3JkZXJlZA== ZW5idXJn L3Rva2Vu 6YWN IFdlYmI= b3dhbmll IFdBSVQ= IEhEUg== IEV2YQ== QVRUTEU= KG1hc3Rlcg== IGVycw== YWxvYWQ= IHNtdHA= dW5pcQ== IGd1aXQ= IFJhZmFlbA== Imlu KFVJ KExheW91dEluZmxhdGVy b3Jhbg== IHNlcnZp bmV6 IFRvcnJlcw== Lk1pZGRsZUNlbnRlcg== IG1vbGw= IFRleHRBbGlnbg== X3VwbG9hZGVk IE1laHI= IGhvbW8= LWxpbmtlZA== dW5uZXI= X2xlbmd0aHM= IGRpZmZ1c2U= IEF1dG9tb3RpdmU= WWVhcnM= IGxpZW4= W2NvdW50ZXI= a2xhc3M= 0YHRgtC4 LkVuZ2luZQ== IG1lbnk= dWx0eg== IGluZmFudHJ5 Vmlh c2VjdHM= LmRhc2hib2FyZA== IHNwb25zb3JzaGlw Lk1vZGlmaWVk Oy0= IFZlbG9jaXR5 dHJhY3RlZA== KG1ldGFkYXRh IHBsYWd1ZQ== TlNVc2VyRGVmYXVsdHM= YXBwcm92YWw= cHJvYmFibHk= LXNpeA== X1ZJUw== OicnLAo= LmVuYw== Lk1lc3NhZ2Vz X1BST0dSRVNT IG5lY2tsYWNl IFRlbXBvcmFyeQ== X21hcmt1cA== IEZ1bmN0aW9uYWw= IEpp IHRlc3RDYXNl ICgpOw0K X0NlbGw= IFJlc2lkZW50aWFs IFJhaWx3YXk= KCgmX19f IGRlZmF1bHRzdGF0ZQ== IGVpbm1hbA== LmZhYw== KmY= IHBpY25pYw== KGV2YWw= IGZ1cm5hY2U= YXNzb2NpYXRpb24= eyEh IENvbXBpbGU= eGVi RXZhbA== gOyepQ== KGNhbA== IG1hcmtldGVycw== X2hlbHBlcnM= bG9jYWxjdHg= IHlvZ3VydA== IHZpdGE= LGxlbmd0aA== IElucHV0RGVjb3JhdGlvbg== IGludGVydmVuZQ== IGNvbXB1dGF0aW9uYWw= RGVuaWVk L2Vudmlyb25tZW50 aWlk LkJveA== LVRpbWU= IGV4Y3VzZXM= dHJhbnNwb3Nl IG91dHJhZ2VvdXM= KFNlcnZlcg== ZGltcw== Il0pOw0K kJw= IEVpc2Vu KE9w IGhhc2hsaWI= KGxp fiw= xLFuZA== IFNwaGVyZQ== IEJlbGxh LXRyYW5zaXRpb24= LnJlYWRTdHJpbmc= aGVhcmQ= IFp1Y2tlcg== IHdhbm4= IGphaWxlZA== IFRhbGVudA== b3Bob2JpYQ== wrY= IG9wZXJhbmRz U29tZW9uZQ== IExpYnJhcmllcw== cHJpbWFyeUtleQ== 16o= VXI= IG1hdGVz INGI LWR1dHk= cG91cg== PEVudGl0eQ== PllvdQ== Q3JlYXRvcnM= V2l0aE5hbWU= J2ludA== IFJhdGlvbmFs PUI= LkF1dG9GaWVsZA== IEZvdW5kZXI= IE1lZ2Fu LmltYWdlVmlldw== Ym93cw== IHdpdGhSb3V0ZXI= IGxpYmVyYXRpb24= IGZvcmFt IGNpdGFz b2NoZW4= LnN3YXA= IC4uCg== LmN2dENvbG9y IEF3YXJl IHF1ZWVy 5aSE55CG IEluZmluaXRl L3N0cmluZw== IGJsZW5kZWQ= LUNvbA== IHd5cw== IHNpY2hlcg== Lkxhc3ROYW1l X3dhdGVy X1JlbQ== IGFydGhyaXRpcw== LkFQUA== IEV4cGFuc2lvbg== eGRi ZXN0cm8= ZmF2aWNvbg== VmVyaWZpZWQ= IGRlbGl2ZXJpZXM= YXJrZXQ= IGdldEltYWdl IEpQRUc= IFRSSQ== IEVsZXY= ZnVzaW9u IGpwZWc= Y29sbGlzaW9u IGRlc2NlbmQ= LmZvcmU= IExvZ3M= IHBvbGljaW5n dW50YXM= Lmhvc3RuYW1l YWNjZXB0ZWQ= 4KWL IFdlbmR5 LnJlYWRGaWxl IFNhbnRpYWdv IEdvbA== cmliYm9u c3RyYXRpb24= IHB1ZGQ= IC8vXw== aXNMb2FkaW5n X1NFUklBTA== IGluc3RhbnRpYXRlZA== IHBvZHM= IHdhcnJhbnRz IGFkbWl0dGluZw== CWNvbm5lY3Rpb24= X2J1ZmZlcnM= IEluY2g= IFpFUk8= d2VydA== IENsYW4= CWls KHNoYWRlcg== IHBpbGdy IOWK RHN0 X2JhcmFuZw== Oicj QnV0dG9uVGV4dA== dGVyZQ== X2FtdA== IEZvcmV2ZXI= LkxpbmtlZExpc3Q= dWFyZHM= dXJvdXM= IFNlbmRlcg== dmFyaWFudHM= X21hZ2lj IGFjY29tbW9kYXRpb25z YXBHZXN0dXJlUmVjb2duaXplcg== UHJvbXB0 ID8+DQoNCg== IHJlcHJvZHVjZWQ= X3ByZWNpc2lvbg== IHJ1dA== bW9uZHM= O3g= IH0sDQoNCg== 55S7 IFZpdGE= IHByb3Bvc2Vz IFBhcnRpdGlvbg== SElORw== ICN7QA== IGVzc2E= KGJhcg== IFplbGRh LmNhdGNo X2V4Y2VwdA== IG92ZXJ3aGVsbWluZ2x5 CVRFU1Q= X0NPTlRBQ1Q= X187 IFNlbWk= IHRyYWJhbGhv cmFkb3Vybw== X3NxdWFyZWQ= 4LY= JUQ= IHByYXQ= aXRleg== KGVsZW1lbnRz UGxhbnQ= YWd1YQ== IGlocmVy LkNvbA== IE1jTg== IENvcmV5 T05FWQ== Q2VsZQ== cmVtZW50 IG1hbHQ= IEx1aw== 57uf UE1FTlQ= IGFuYWx5emVy IEhhbms= X3VuaWNvZGU= IGJ1cmlhbA== IENlbHRpYw== RUZG TG90 d29u IE51ZGU= IE5hdGU= IFNpbmdlcg== IFNJVEU= KGJpdA== Yml6 IGRldG9u UkVBRE1F OkFkZA== IEhvbGRpbmc= e3JldHVybg== bmNpYXM= Pg0KDQoNCg== cnVwdGlvbnM= LnJlYWN0 dXJzYWw= 4Lib IERPTkU= aXZhdGVk Lm5vdGVz IHN0cmlwZXM= cmlwcA== aXJhbg== IHNsYWI= IEJ1cm5pbmc= KGVudA== LnNlYw== R1U= X2dvbGQ= XSkpLg== ZWxpbmVzcw== 0L7QsdGA0LDQ IOKIgA== IGNvc21pYw== J10pOgo= Y2Npb25lcw== Y2lzaW9u Y29tcGFyaXNvbg== IEV2YW5nZWw= IFNoaXJ0 bGFnZW4= IGnFnw== IGZpbGxlcg== LnByb2Q= IAkJCQkJ INGE0YPQvdC60YbQuA== IFplcm9Db25zdHJ1Y3Rvcg== QXRB XSkNCg0K IGNvbnN0cnVjdG9ycw== X1NIQVJFRA== CWRldmljZQ== IEFkdmljZQ== OkAiJUA= Pn0n LklzRW1wdHk= IGludHM= bW9zdGF0 IFNpZ251cA== Z2Vhcg== KHBhdGhz LHsi L0RvY3VtZW50cw== PENhdGVnb3J5 VUVTVA== IGdldERlc2NyaXB0aW9u ICJ7XCI= IEpvZXk= b2Rlbg== X2d1ZXNz RVVS IGhlcnI= IHNlZGFu IHJlYWN0ZWQ= X2Nsb25l IFJldmVs IGZvcmI= UmVtYWluaW5n XFNlcnZpY2Vz IGF2aXM= YmF0aW0= emVwdA== IERCTnVsbA== Q29ubmVjdGlvbnM= IGRpc3BvbmlibGU= cGhpbg== IHN0dQ== IHNjaG9sYXJzaGlwcw== LXNoYXJpbmc= Zm9ybWluZw== IEJyaQ== VmFySW5zbg== L3Nlc3Npb24= IGFtYmlndW91cw== IGFwcmVzZW50 X3Jk c2l0ZXM= L2FjdGlvbg== dHJhY3Rvcg== IGRpbGVtbWE= IFNY XS0tPgo= IEphY2tldA== UkFUSU9O LmdldFNlbGVjdGVkSXRlbQ== LWluaXQ= IFJlZ2lzdGVycw== X3NlcA== IFRvb2xraXQ= LmRpY3Q= IHhsYWJlbA== XFRhYmxl dG9j X2NvbWJv IENvbXBhY3Q= IHJ1Z2dlZA== 4KWH4KQ= LW1hbmFnZW1lbnQ= Jyl9fSI+Cg== IFN0YW1w xLFs cm94 IGxhbmRzY2FwZXM= X05PVEU= bW9uYXJ5 Y2Fi IG1vZXQ= eGFm cmNvZGU= LWNsaQ== X2dhdGU= W2V2ZW50 U1BPUlQ= Z2lh IFNVUEVS L0xvZ2lu X3NodXRkb3du aW50ZXJydXB0 IHByZXRlbmRpbmc= IGZyaW5nZQ== IFJlZHM= IENVREE= IFVOSVg= dml0 IGJyaWc= ZHJ2 IENvbm5lY3Rvcg== VGhlcmVmb3Jl IGxpYQ== RGV0ZWN0aW9u X2FjdG9y IHRlbXBmaWxl IGVjY2VudHJpYw== LXJvbGU= IHBhZHg= ZGVudA== V2VzdGVybg== IOq3uA== IEFwcGxpY2F0aW9uUmVjb3Jk IGNhbXBhaWduaW5n X3J1bm5lcg== IENpdmlj YWxlaWdo IGRpcmVrdA== LnN1bA== ICAJCQk= YW50ZW4= IGlzc3Vlcg== IGFzc2VydGlvbnM= KG9yaWc= QVRJTw== IGxlYW5lZA== w6Rz LkRUTw== ZXhwbG9kZQ== Lk9ic2VydmFibGU= IHN0YWdnZXJpbmc= IGtpZG5hcHBlZA== IHByb2dyYW1tZXJz IElubm92 LnBhcmFtZXRlcg== IGRvbWluYXRpb24= IHNrZXB0aWM= IOaYrw== IGF2b2lkcw== LlZlcmlmeQ== dWJieQ== IEFTTg== IGZvcm1hdG8= IEJlYXRsZXM= X2JyYW5k IGluc2V0 eW91dHU= IHRvYw== LWZpbmFs U2hvd2luZw== IERvdWI= IE1lc2E= QWRq X21lZGl1bQ== Q3JlYXRlcw== KGVuZHBvaW50 CVVQ YmJpZQ== IHN0YWxr LmRhdGFiaW5k LlNjYW4= YWdlbnRz JCw= aW5kaXZpZHVhbA== Kykv CXZt KG5vdGlmaWNhdGlvbg== IGluZXg= IENsYXNzaWZpY2F0aW9u cmVubw== IG9saWc= LXJhdGVk IGZvcm11bGF0aW9u Jyx7 IGFjZXB0 X3VucGFjaw== X0NB LlBvdw== CWlt IGFsdW1pbml1bQ== QU5P IHhu IGPDs21v IEluZ3JlZGllbnQ= IHNlaXp1cmVz 5YWx aWZpY2Fkb3I= IHNpZ3VpZW50ZQ== IEluZnJhZ2lzdGljcw== IGR1cGxpY2F0ZWQ= IERlZQ== IG7DuA== IEFDQ0VQVA== KGNyYXRl 0LjRgtC10LvRjA== LWxlc3M= IGluZmluaXR5 QW5hbHl6ZXI= LURheQ== cml0dA== KGNpbg== IEd5 IG11bHRpcGxpZWQ= dWNoaQ== IEJhbGR3aW4= L2lw IHNob3J0Y3V0cw== LkFERA== IHZpZ29y X2luc3RydWN0aW9u KDs= X2V0YQ== 6L+e dXRvcmlhbHM= IGJvb3N0aW5n YnY= IGFja25vd2xlZGdlcw== TGlzdGVuaW5n RkFR O2I= KCgt IGFyY2hpdGVjdHM= IHp3ZQ== IHB1bHM= IGdldENvdW50 dmVyYnM= 44Cc KENvbGxlY3Rpb24= a3Jl IGp1cmlzZGljdGlvbnM= X2JyaWRnZQ== IENyYWNr IERpZmZpY3VsdHk= S08= UmVzZXJ2YXRpb24= X3JlcXVpcmVz VG91cg== 44GX44Gf LnNldEN1cnJlbnQ= IGt5 IEFsYmFueQ== IOin bGxlcg== YWduYQ== d29ya2Vycw== LmJsYW5r IFByYXllcg== TUlD IHJlc2lsaWVuY2U= VGVY IExhbmd1YWdlcw== c3R1ZHk= CWN1cnI= IGVuenltZXM= U2x1Zw== IO2MjA== c3RyYWw= IHR1bW9ycw== IHNlZ3VuZGE= PSd7 aW5zdHJ1Y3Rpb24= IExpc3A= L2luZm8= ICJ7JA== LDopLA== IGd2 KEVycm9yTWVzc2FnZQ== ICc9 fS0kew== LkRvY3VtZW50cw== IldlbGw= IHJlbWluaXNjZW50 IGdheg== aXJvcHI= ZWhy IHN1cHByZXNzZWQ= ZXJzaA== LnNjcm9sbFRv IGNhZGVuYQ== IGdhbWVTdGF0ZQ== w61t KGNvbnY= IFRvbW9ycm93 IENDVA== TW9uZ28= dWxn LkNhbWVyYQ== LmhhbmRsZXJz bXBo IHN0aw== IGdlbmV0aWNz QUNJTkc= VHJpdmlh IEJhbQ== KG1hcmtlcg== LlN0cmV0Y2g= IFN1bm5p IEJldHR5 LnRvbGlzdA== dW5saWtlbHk= LlJlY3RhbmdsZQ== b2Jzb2xldGU= SUxPTg== aW5uZXJUZXh0 ZW1ib3VyZw== YU4= IFZlaGljbGVz dW5sb2Nr OnV0Zg== bm9i IFNlZWluZw== IE5FVkVS IHRscw== IGZpbGxlcw== IGJlbmVmaXRlZA== IENsaW50 Ki8pLA== LmZvbGQ= IHBvc2libGU= QURFRA== dGhvdXNl LkRBTA== IE9kZA== cm9rZXM= IFN1bm55 IFBhcnRpYWxFcQ== X0J1ZmZlcg== IExldmk= bG9uZ3JpZ2h0YXJyb3c= ZWxkb24= Z2FnZXM= X3dhcm4= LkNyZWF0ZVRhYmxl IERpcA== X3F1ZXN0aW9ucw== LmxvZ2lj ICMi PXsoKT0+ IHRlcA== IGp1aWN5 7IKs ZW5rbw== aWFsZWN0 2Yk= IG9uYm9hcmQ= IOaP CXJ0 X1VURg== IFFBY3Rpb24= 4oCe KENvbXBvbmVudA== KGF1ZGlv LmhpdA== Z3Rl IHByb2dyYW1tZWQ= c3RhdGVQYXJhbXM= IHBvbHllc3Rlcg== ZmlyZXM= Ynlzcw== XT0o X3F1YWxpdHk= T2ZEYXk= IEZhaXJ5 IHllbGxlZA== b3Bs KHVzZXJOYW1l IERpZmZlcmVuY2U= IGV2YWx1YXRpb25z aWZmYW55 IGN5Y2xpc3Rz IGNpZGFkZQ== IHRleHRib29r IHByb2ZpbGluZw== X18pLA== ZGVh LmFjdGl2YXRl IGluZGljYXRpb25z 0JU= VG91Y2hVcEluc2lkZQ== IGludmFsdWFibGU= IE1BU0s= IGNvbnRlbmQ= RnJlcQ== IHJlY3J1aXRz KGludGVydmFs IFVzZXJQcm9maWxl ICcuLy4uLw== ZWR1 X0NhbGxiYWNr IGFuYWxvZ3k= IFRyb3BoeQ== YXBwaGlyZQ== VmlkZW9z IENoZXI= IEhhdg== 4oCmIg== LnZhbGlkYXRvcg== Z2Z4 IFVPYmplY3Q= Y2xhc3NuYW1lcw== dHJpYW5nbGU= IEVuY29kZXI= LnNweQ== IHByZWRhdG9ycw== PXN0YXR1cw== LXNhZmU= OiIsCg== IEluY2x1ZGluZw== IHt9Ow0K KmNvcw== IGVuZHVyZWQ= LnN1bGFrZQ== IG51cnNlcnk= IGZyYWdyYW5jZQ== IHJlYnVpbGRpbmc= IG50aA== IEZyYXNlcg== LnNldERhdGU= IFZpbmNl X1JFU1Q= IHZlbnRpbGF0aW9u 5rW3 Y3JpYmVz LmFzbQ== bHBWdGJs IEFiZQ== dWlzaW5l LGFycmF5 CWNsYXNzTmFtZQ== ZXJyYWxz ICcKCg== Q2hlY2tvdXQ= IHNvbGljaXQ= QXV4 X2NhcHR1cmU= IHJpYnM= cmFnb24= dmlvbA== dG9waWNz RnVuY3Rpb25GbGFncw== IE1hcnR5 YmlrZQ== IFR1Y2tlcg== KGtlcm5lbA== IE9wcw== Q2xvc2VPcGVyYXRpb24= L2RlbW8= aWxkYQ== IGzDrW5lYQ== QVBQSU5H IHN1aXRlcw== LnZpc2l0VmFySW5zbg== dXJ1cw== IE1pbnV0ZQ== KG1hbmFnZXI= IGJ1dHRlcmZseQ== IGFwYXJl IHdvbHZlcw== SldU IFNhbG9u CWRlbGF5 LWVzbGludA== aXNhdGlvbnM= LnJwYw== KXwo IFNuYXBjaGF0 L21t TU4= Y2VyaWVz LnRleHRBbGlnbm1lbnQ= IEZyYW5rZnVydA== IGFkbw== KG5ld1ZhbHVl KGFjY2Vzcw== KEV4cHJlc3Npb24= IFNpZ25Jbg== IEhhaXRp X3Rw LnNldFBhcmFtZXRlcg== TWludXRl IG1hbnVhbHM= cmljYW5lcw== IFBUUg== IE91dGVy IGdldGxpbmU= b2NhdGlvbnM= X0NE IEx5b24= L2d1aQ== X2xpdmU= aWRhbg== Lmdlb20= IGJvcmRlckJvdHRvbQ== aW11dGg= X2NoZWNrcG9pbnQ= IG1ldQ== IElydmluZw== IHBldXZlbnQ= KE1BWA== IEFSQ0g= IHBvdg== LnNvdXJjZWZvcmdl IGphbWFpcw== IGFyaw== IEJhZ2hkYWQ= IENMRUFS TWVudUJhcg== IHRyb2lz Q0hFRFVMRQ== ICMNCg== KENhbGw= JG9yZGVy KE1hdGVyaWFs IGVuY29udHJhZG8= JGxpc3Q= IE1FVEhPRFM= LmJlZ2luVHJhbnNhY3Rpb24= X01BRw== U3R5bGVTaGVldA== IG1ham9ycw== IGluZGVmaW5pdGVseQ== Y2xlYW51cA== IGhvbWVsYW5k KGR0bw== RGF0ZXM= UHJlc2VudGF0aW9u IERL PXtgLw== CUtleQ== KEJsb2Nr X2NoZWNrYm94 bmVlZHM= IG9uQ29tcGxldGU= cmljbw== IGdsZWljaA== IHht T09E QmV0dGVy IFNRTElURQ== LkJvb2s= eGFk IEdvbmU= CWRw IGRldm90aW9u IHN0bQ== IG9ic2Vzcw== IEJhY2tlbmQ= UXVlcmllcw== SWs= Ly8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq IGRpdmlkZW5kcw== LnBhcmVudEVsZW1lbnQ= fSIpCgo= IE1hdGVyaWFsUGFnZVJvdXRl Om51bQ== IGV4cGxpYw== IE9M bGVhc3Q= T29wcw== aW1lbnRvcw== IGluc3VyZXJz IGhlcm9pYw== CWZpZWxkcw== LmltZ3Vy LmJ0bkNhbmNlbA== IERldGVjdGl2ZQ== KHNt IE11dGFibGVMaXZlRGF0YQ== LmxhYg== KChb IGhhaXJzdA== IFRyYW5zYWN0aW9ucw== 5byA5aeL IHN0ZENsYXNz dWVudG8= R0lT X2NvZA== SW5zdHJ1Y3Rpb25z Q2FsbHM= UG9pbnRlclR5cGU= IFJ3 IGFzc29ydG1lbnQ= IERJRw== K3I= X0NFUlQ= IGluc3RhYmlsaXR5 IHZpYg== b25hcw== IHJva3U= YXBlbGxpZG8= IGFuZ2w= cHJlbmV1cg== IGZsdWlkcw== aXNlYXNl IGRlZWQ= cXVpc3Q= X0NPTlNUQU5U IGVxdWlsaWJyaXVt X2RlbGVnYXRl IFF1YW50dW0= cmVp Q2FwYWJpbGl0aWVz cmVjdGFuZ2xl Pz48 YWxpZW4= IEp1Zw== RE5B VGlja2V0cw== T2NjdXJz IEhhd2s= LnNldEhvcml6b250YWxHcm91cA== XENvbGxlY3Rpb24= ZmZpdGk= IHJlYXJy LnNldFZlcnRpY2FsR3JvdXA= IGNhdml0eQ== IGFkdWx0ZQ== RmFjYWRl LXdo IExPTA== 2LA= IGdyYW5kcGFyZW50cw== U3dpZnQ= CXd4 5omA5pyJ aWZlbg== ZmZzZXQ= QmV5b25k Ly99Cgo= IHdhZ2Vy IGJ1cnk= IGNvbW1lbmNl cmVnaXN0cm8= c2NpZW50 IFBlcmNlbnQ= INC00L7Qu9C2 KGlkZW50aWZpZXI= LnNldE1vZGVs IHNlbGRvbQ== bnRvbg== IGFwcGxpYW5jZQ== YW11cw== cnlzbGVy IHBhbnRpZXM= ZW5ndWlucw== IG1pbWlj IG9uQ2hhbmdlZA== IGFsY29ob2xpYw== LnJlbG9hZERhdGE= Q2hhcmdl IEZheA== IGpTY3JvbGxQYW5l RW1wcmVzYQ== IHNoYXR0ZXJlZA== eGJh Rm9udHM= P3M= IHBvc3RzZWFzb24= cmV0YWlu X3JhdGVz IHJlcXVlc3RDb2Rl LnRvZG8= wrRz Q0hL IEtlZXBpbmc= ZW5nZWFuY2U= IHZzY29kZQ== SVBQSU5H RGVmYXVsdENsb3NlT3BlcmF0aW9u X3JhaXNl IE9jdWx1cw== b2dyYW1z cmFq cGNp IGNvcnJvc2lvbg== LmhhbmRsZVN1Ym1pdA== QWNjZXNzaWJsZQ== IFBpYW5v bGl0dGxl QUNM xIdl LnVud3JhcA== IENvbnZlcnM= IExlYmVu aW9uZWVy IE1lcmNoYW50 IEpvcmdl IGVtYnJhY2luZw== IHZlbnRh w6FzdA== IHZpZW5l PFFTdHJpbmc= IGV4cGxvc2lvbnM= IGRpc3R1cmJlZA== LiI8 bWVtbw== IEFib3JpZ2luYWw= IGNvbXBsZXRv VGV4UGFyYW1ldGVy IHVvbWluaQ== KGFnZW50 0YPRgA== IFdob2xlc2FsZQ== L2Ft IEJvb2ttYXJr ZHJhZ29u IGdsb3Zl ICIiKSk7Cg== aXZhcmlhdGU= bm93cmFw SW5DaGlsZHJlbg== LkJy IGNvbmV4aW9u IGJhY2tib25l IGVjbGlwc2U= IHBlcnNlY3V0aW9u JzoKCg== L2xpbms= IFBlcm8= YW5kYXM= IFRlaw== LiIpOw== LWFuYWx5c2lz IGVyYWQ= TWFyc2hhbA== IGFuY2hvcnM= b2dlcg== IGNvbnZlcmdlbmNl c3RpY2t5 IG5hdmVn aW50ZXJu X0RFU0NSSVBUT1I= IENvbnN1bHRhbnQ= ICAgICAgICAgICAgICAgICAgICAgCg== IEF1Y2g= IGVycmU= xZtsaQ== IEhvcml6b24= Y29sYQ== SW5zdGFsbGF0aW9u aG90bWFpbA== Q05O LkNvbGxlY3RvcnM= Y2hz KHRyYWNl IEVuY3J5cHQ= IC0tLS0tLQ== IEJhc2VDb250cm9sbGVy IGFndWE= IHJlYWN0aXZl aWRs IGNsYXNzTmFtZXM= CVNlc3Npb24= IERvZGdlcnM= SGFk X2x2 SXNWYWxpZA== IEhFTFA= dXR0bw== IFZlcmlmaWNhdGlvbg== IGdldGVudg== X3Bh LmJtcA== OmY= IExvdWlzZQ== KCc7 L3NvY2tldA== R3JhbnRlZA== LmNhbGVuZGFy KElQ IFBY LlJvb20= IHByb2dyYW1t ZW5zaQ== IHRhYmxlc3Bvb25z IGxldmU= IG1vc3Ry LnRpcG8= L2Fu KGRp IGJpb2Q= IGRiQ29udGV4dA== IEpTWA== CXJlc3VsdHM= LkVORA== aHRl bGlmeQ== UHJlY2lzaW9u 6IqC QVJTRVI= KWRpZFJlY2VpdmVNZW1vcnlXYXJuaW5n YXR0ZW1wdA== SVNQ JmE= X1BPUA== IFRhYw== IHByZXBhcmVkU3RhdGVtZW50 INC30LDQv9C40YE= IG93aW5n LHN0YXJ0 IHJldmlld2Vy IHJzdA== IHByb3BUeXBlcw== IHJvY2t5 X2xvY2FsZQ== IFN0cmF0ZWdpZXM= IFdlYmVy LkNhc2NhZGU= X2VxdWFsVG8= IGNvc2Fz IERlbGV0ZXM= IE1heGlt IHNocmltcA== cmV0cmlldmU= LkluY2x1ZGU= SUdJTg== IE9F XSk7DQoNCg== LmVudW1lcg== IGNvZWY= X051bGw= UmE= dHlhcmQ= IFNoYXdu a2VlcGVycw== IHFx X3Ni b21lbnM= IEV4ZWN1dGVz IyI= VFRZ IFZhbHVlVHlwZQ== KTsqLwo= IEFic29sdXRlbHk= IFRvdHRlbmhhbQ== L2FydA== IGJsZXNzaW5ncw== IHN3aWZ0bHk= YnVzdGVy IGF2aWQ= Q09NTQ== LHRlbXA= IH0/Pgo= LWdyb3dpbmc= IGRlZXBjb3B5 QWNr ZWdnaWVz IF9fKCI= IG5vaXI= dGVycm9yaXNt IGFudGhlbQ== YWdlbmN5 X1BBQ0tBR0U= IENsb3N1cmU= LnJlZ2lzdHJ5 IG1hbW1hbHM= PEw= VUlDb2xsZWN0aW9uVmlldw== IExFRHM= IHZvbGxleQ== KEJ1ZmZlcg== X05BVElWRQ== bGliYw== aW1wbG9kZQ== U2Nyb2xsQmFy IE1hcmlvbg== LkNvbnRyYWN0cw== X0F0 IFdlaW5zdGVpbg== Y29tcGFyZVRv IEhvc2U= ZW5pdHk= LmNyZWF0ZVF1ZXJ5 X3JvdXRlcg== IHN0aW11bGk= ICsrKQ== IENoYW1w IEJheWVybg== YXNzYQ== LnZh IGRpc3RyaWJ1dG9ycw== IGZpbGVwcml2YXRl IGRlcGFydGVk Y2NjYw== QGNsaWNr IEx1bmNo Pkw= IGJsdWV0b290aA== LkRlZXA= LXN0YW5kaW5n w6FjaWw= IHJvb2Z0 IFBhdGhz X2l0ZXJhdGlvbnM= SW52YWxpZEFyZ3VtZW50RXhjZXB0aW9u LnNwaQ== IFVJQWxlcnRBY3Rpb24= dXll c2lnbmlu LnByaW9yaXR5 IEVzc2F5cw== PSd7JA== IOi/lOWbng== X3NpZ25lZA== LnBlcnNpc3Q= IHJlZGVzaWdu VG9Mb3dlcg== IE5ld21hbg== PXN0YXJ0 IElzcmFlbGlz YXNpc3dh U3BlZWNo IG51bWVyb3M= aGFuZGxlcnM= IFdvbmc= INC80LXRgtC+0LQ= V2VpZ2h0cw== IEd1amFy dGVpbA== IE5vbmV0aGVsZXNz X0VGRkVDVA== IHZlY3Q= IE9zYw== IGNvYXRz IFdoZWF0 IGdlZWs= IFBST1BFUlRZ d29ybQ== X2NvbnN0YW50cw== IEJvdWxkZXI= IFBhcm0= Y29sZQ== IGRlZmF1bHRDZW50ZXI= IFJvdWdl OkE= eGNm IFZlbmljZQ== bWVkaWFu IHJlZGVtcHRpb24= RnJlc2g= IGNvc20= IGZpZ3Vy IHJlZnVyYg== Q09QRQ== LmNk IGNob3Jkcw== IFNndA== xY0= VlBO IFNFTkQ= YWluZW4= X2FjY291bnRz IHRlbnRo IGRpc3NvbHZlZA== PEFwcA== IENvdmVyYWdl dXNlU3RhdGU= w6lybw== Li48 IOyjvA== IGRyZWFtaW5n IEZvcmVjYXN0 LkN1cnNvcnM= IHZpc2Fz L3NjcmlwdA== X3N0YXJ0ZWQ= IGdhc3Ry KFBSTw== XTsvLw== LlRpbGU= KnNpbg== KEFkYXB0ZXI= IFNhbmRyYQ== X1NJRw== YXJkYXNo IE92YWw= IGRlc2NyaXBjaW9u KHNs IERlc2NyaXB0b3I= IGAk L2ZyZWU= IEtleXdvcmRz IHR1ZG8= aW9uYWxl KGZvdW5k Lnh5eg== IEdlbmVyYXRpb25UeXBl X0RJU0FCTEVE KGFyZWE= IGVsaXRlcw== IGhvbWJyZQ== KG1lc3NhZ2Vz IFJhYw== IGV4dGluZ3U= IEVzdGE= b3Bv LnZlbA== bW91c2VvdXQ= IGNvbnZvbHV0aW9u IEhhbmRsaW5n IGNlaWxpbmdz VGVr IEFyZWFz LndyaXRlcm93 PFZpZXc= IENvcm5lbGw= X0JJTg== LmludmFsaWQ= JycnDQo= aWXFvA== X1Bvc2l0aW9u IGtpZGRpbmc= UENPREU= IHdhdGNoZXI= bG94 IOKX RGF2ZQ== X2FsbG93 IGJpc2V4dWFs IHVub3JkZXJlZA== IFNjaHdl X3NlZ21lbnRz IHRlYXJpbmc= SU5MSU5F IHVuZGVz Lmdvb2Rz LmNhbQ== IExX CXdoZXJl Q2FsY3VsYXRvcg== LXRocmVhdA== LWFsZXJ0 IFN1enVraQ== IElQQQ== IEF0dGFjaG1lbnQ= QUNDRVNT KGR0eXBl T3Bw X3N5bWJvbHM= IGRhbnNrZQ== bGFnZQ== b3JnZXQ= cmVzb2x1dGlvbg== 0LXRhw== IFFDb2xvcg== IEJhcnJldHQ= 0LDRhtC40Y8= PVwn IE5hdkNvbnRyb2xsZXI= L3JlZg== KGNvdW50cnk= X0hEUg== IHRlcnNlYnV0 cGV0aXRpb24= IHN1Zg== Y3JlZGl0cw== 4LmM eG0= IERhdmllcw== LnJlZGRpdA== IHdvdmVu IE9ibA== IEtN IENvbnNpZGVyaW5n ZW5zb3JlZA== LnBlcmlvZA== IGRkbA== JHdw IGV4dHJlbWlzdA== O1wK IGtpbQ== YWxlcnM= IHNwYW5uaW5n IGNvaGVyZW50 IGNvbnNlZ3U= LnRleHRMYWJlbA== LmdlbmVyYWw= X2Rhc2hib2FyZA== 0LvQtdC90LjQtQ== a2ljaw== X1BJRA== IEV4dGVuc2lvbnM= cmVnZXhw IENsYXVzZQ== X21vdg== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA== IFJld2FyZA== IExFR08= QWs= PS09LT0tPS0= CXBhcnNlcg== IG9uemU= 6YCA 4oCd44CC X2JhbGw= KHJocw== IGNob3J1cw== PGNvdW50 YXN1cmFibGU= IHdpcmtsaWNo IEVyaW4= IE1TTkJD IGV0dGVy IENyb24= X0ZMT1c= ICwNCg== IGNhbGlkYWQ= IEZpbGVXcml0ZXI= CXN0bXQ= KEJ5dGU= X3BhdA== IHRlbGVzY29wZQ== IGdyZWVk IFRvcnQ= KHdyaXRl XGFwcGxpY2F0aW9u CVJUTFI= IENvbmZpZ3VyYXRpb25NYW5hZ2Vy VW5peA== RW5kVGltZQ== SW5jbHVkZXM= IEhhcnZlc3Q= ZW5iZXJn IEF1c3RyYWxpYW5z IOuT IHJu IHJlcHV0YWJsZQ== IGJsZW5kaW5n VUxBVElPTg== IEJyZW5kYW4= ZGFk IG3DuA== IFdvbw== X2Rj VW5l IHJ1ZQ== d2l0aGlu YW5nZXA= IHBvdWNo XCIiLA== IFNpYw== 4oCdKSw= YWx5emU= IEdlZg== Y292ZXJz IGRibw== cmVwbGFjZUFsbA== CUxvZ2dlcg== VHJ5aW5n W3N0YXRl LXBpZWNl 6ZaT YmVoYXZpb3I= YWxsb3dz bHJ0 X3B5dGhvbg== ZXJ0dXJh LWNvdW50cnk= IFRH LlVJTWFuYWdlcg== YmVucw== YWxleA== IEJyZWl0YmFydA== YmFj IHByZWRpY3Rz IGdhYg== IGNhcmRpbmFs LlRpbWVVbml0 IFZpc2l0b3I= IE1pbmc= IGxpdnJl IHBhcmVudElk cG9ydHVu IGRpbWVuc2lvbmFs IFZlc3Q= ZW5pYw== 4LM= INmH IEJMVUU= IGl0ZW1Db3VudA== IGZlYXRoZXJz CXBzdG10 IFBvbGFy ey8v dW5kaQ== 0YPQtg== emFy RXJyb3JSZXNwb25zZQ== 7IOB UmVwcmVzZW50YXRpb24= Kl8= K10= cHJlcGVuZA== ICc+ IGxlZ2l0aW1hY3k= IG9v U2xpbmt5 IG5hdGlvbmFscw== LndvcmRz O3A= dHJhcA== b21hbmlw IGN1ZXM= IGdyYWR1YXRpbmc= IHNlbWFwaG9yZQ== Il0pOwoK YWNleQ== UkVFVA== R3JhYg== IEZlbGl4 KElk X25laWdoYm9ycw== IG1lYW5pbmdsZXNz KGRlbA== IGplZGVy IENvbnRlbnRWYWx1ZXM= LmFic29sdXRl L2Ns IHhi ZGF0dW0= IHRvcnR1cmVk IHJ1YmJpbmc= U2NvcmVz IPCfmIk= IGF2b25z IGFtc3RlcmRhbQ== RU9T SGFs IHRydXN0d29ydGh5 Iz0= LkVYVFJB IG1hbm8= aXNpY2luZw== LXN1cHBvcnQ= CWN1cnNvcg== IFNwbw== YWltYXNzYWdl TWlzc2lvbg== W117Ig== IHByaW50ZXJz R1JFRU4= IHRlZw== IGFiZG9taW5hbA== IQoKCgoKCg== LlNob3J0 0LDQt9Cy IEdpZnRz fSIp KGJpbmRpbmc= eGNl 4oCR aW5mb3M= Rm9ybURhdGE= IGRhcnQ= IGVsZW1z KGludg== WUw= dGlu R0VORVI= 4buv IFRha2Vu dWNrbGU= OmU= IHNwZWN0cmFs LmJhaWR1 LycpOwo= IGdyZWVkeQ== ZXNpb24= LCwsLCwsLCw= IC8+LAo= SW50ZXJuYWxTZXJ2ZXJFcnJvcg== TlNOb3RpZmljYXRpb25DZW50ZXI= IEFp IHNwaXQ= IGF1Z21lbnRlZA== IHN0YW5kYXJkVXNlckRlZmF1bHRz RklOSVRZ UmFjZQ== OkM= IFJFQ09SRA== IEhpZ2hsaWdodA== ICdg IGRlZmljaXRz IG5laQ== IHJlc2VhcmNoZWQ= VGE= IGNvcHA= LkdldEhhc2hDb2Rl KToNCg0K T25DbGljaw== IFdlbGxpbmd0b24= IHJldml2YWw= 5q+U 6Zeu IE5TUw== IGZvcm4= IGludMOp IEt1d2FpdA== X2ZsaXA= X2Jv X1w= IG9jY3VycmVuY2Vz IFNjaWVudGlzdHM= U1JD b2dlbnM= aWdyYW50 UkVNT1RF IFNJRA== Lm9wdHM= dXZl KCldKQo= IGxpYmVydGFyaWFu IEdsaWRl bGVzZW4= IGZvcm1l b3dhbmlh IGFubm95ZWQ= RGVmcw== IEV4ZWN1dG9y IGNhc3Rz LnNldENoZWNrZWQ= IFNoYXJpbmc= LlNlcmlhbGl6ZU9iamVjdA== IHNlbGVjdG9ycw== X09USEVS 66+4 KHN1cGVy KE9T X1ZFUklGWQ== aWR1bnQ= PGhlYWRlcg== IC8+JzsK IHZpZMOpbw== IE5lZ3Jv IExvcmRz IFRvdXJz IHNvZnRseQ== LnJlY2VpdmU= IEVSQw== IGRhdGFTZXQ= QmFkZ2U= CUV2ZW50 IHBlcmw= IHt9XA== KHNlbnRlbmNl T3JVcGRhdGU= IGRpbWluaXNo UElO KGRyYXc= LlRvRGF0ZVRpbWU= LkVxdWFsVG8= KHBpbg== LXBlbmNpbA== bHVlbnQ= IENhbGxlcg== IHBsYXlmdWw= LScr eGNh c3dpY2s= KXt9Cg== fTokew== IE1ldGg= LmdldENlbGw= LmJyZWFr IHltYXg= PSc8Pw== LWpzb24= IHByaW1laXJv IGluZGljZQ== 44Kj IFVOSVRZ KGFi 0YbQuNC4 X0hBVkU= LXllYXJz IEVyZG9nYW4= LXN0YWNr IGRpc2NoYXJnZWQ= IGJyZWF0aHRha2luZw== IGdyYXNzcm9vdHM= IEFzaWRl aGVsbA== IHNuYWtlcw== L2xvZ291dA== IG1pbldpZHRo IEhlYXI= IFN0b25lcw== IFdpc2RvbQ== IEV2ZW5pbmc= X2JsYW5r IFByb21vdGlvbg== IE1NTQ== IEJhcnM= 44K3 bmo= X1RJ IFNvY2lhbGlzdA== IEVH LW9wdA== PVwiJA== KGRpYWxvZw== IGJlaG9sZA== IGludHJpY2F0ZQ== IGVyZWN0aWxl RXh0cmFjdG9y IHNjbA== IGNsYXM= KGhpc3Rvcnk= aWRlbnRhbGx5 IHBuZXVt UmFuZA== IExhcHRvcA== Y2FsbGVy IEZsb29k b3BlbmVk dWRkZXI= IEdldHRlcg== X3dhbGs= KHdlaWdodA== IEFsZXhhbmRyaWE= IHRhYmxlYXU= VmFyaQ== IC0tLS0tLS0t 6Iez ZXdvcnRoeQ== U3BlY2lmaWNhdGlvbg== IHRocmVzaG9sZHM= KCIiKTsKCg== X2ZvdXI= IFNhZGx5 IChfKQ== aXNtYXRpYw== IEphaWw= dG9IYXZlQmVlbkNhbGxlZFdpdGg= Lm1hcg== IHByZXZpZXdz IHNjYWZm aW5kaWNhdG9y IGNvZGVjcw== IGF1dG9j KHJ0 LmdldEhvdXJz IFJI IFN1cmdl aXZhbWVudGU= IGNvbnRlbmRlcg== Q3BwR2VuZXJpY0NsYXNz IDs7Xg== OjoqOwo= LXJlY29yZA== IG1hbWE= IGltZ3M= LmlzTG9hZGluZw== IG5lZWRsZXM= IGVuY3VlbnRyYQ== b2RhdGE= IEJ1ZmZlcmVkSW1hZ2U= CWphdmE= IFRvbWI= VU5JVFk= IGxpbmdlcmll IEphbWFpY2E= YnVncw== KioKCg== IE1hbw== LmJlZ2luUGF0aA== IHByb3N0aXR1dA== IFBoaWxpcHBpbmU= X3Nm X3Bvdw== IFNjaG8= eGRl J8OpdA== 4oCZYXV0 YWlzb24= IEZpbGVJbmZv dHVybnN0aWxl ZHJlYW0= IGlWYXI= c3ludGF4 aWxsaXNlY29uZHM= cHJvZmlsZXM= X1JFR0VY INC00L4= IENvbW11bg== QmV0 aXB6aWc= IE1lbW8= Lmlkcw== IHBob3RvZ3JhcGhlZA== IGFwcHJveGltYXRpb24= OnZhcmlhYmxlcw== IG1vZGlmaWNhcg== X1NNQUxM IEhlbXA= IGRpc3Jlc3BlY3Q= IGNvbnRlc3RlZA== IGlubm9jZW5jZQ== aWxsaXM= U3ltYm9scw== IGluc3BpcmF0aW9uYWw= IGRpc2NpcGxpbmFyeQ== IFBlcm1hbmVudA== IGRlc2Ny IFVOREVS 0YHRiw== cHJlc3Nvcg== SU1FUg== IG1vdW50cw== IG1vcmFsbHk= X1NFQ09ORA== LmZpbGVOYW1l 44OX IGNvbnN0cnVjdHM= IFNVTg== RVNQ RmluYW5jaWFs IE51cg== w7RsZQ== cmljdWxhcg== IFVzZXJNYW5hZ2Vy aWJpbGlkYWQ= IG9uUmVzcG9uc2U= IGZpbG1tYWtlcg== IGFsb3Q= X1RIUkVBRFM= IGVudmlyb25tZW50YWxseQ== Li4uLi4uLi4uLi4uLi4uLi4uLi4uLi4u IHJhc2g= IEx5cmljcw== IGlwYWlycw== QmFja3Vw U2lnbnVw IEB7Cg== SlVuaXQ= d29ya2Zsb3c= IENvbXBsZXRpb24= IGludHVpdGlvbg== 8J0= IG1pYQ== IFNuYWNrYmFy IFRpbg== CWluc3RhbmNl IE11c2ljYWw= IHdlbGNvbWVz IHJlZHJhdw== X2NvbG91cg== X1JFQUxUWVBF X3NpbmNl IEJ5dGVBcnJheU91dHB1dFN0cmVhbQ== LWRlbWFuZA== YXJldGg= LnBhZA== c2Vr JywuLi4K LWZpcmU= Lnw= IG51bWI= IERPVUJMRQ== QU1BR0U= Y2htb2Q= LWls IGFsYXJtaW5n Q29w 5aSH aW52aXRl X0lURU1T IGxldWs= IHJlZWw= IGZ1bGZpbGxtZW50 UmVzdG9yZQ== X3Jy KGNsYXNzZXM= IHBhZ2luZw== eW1heA== cmFwcGVk 7ZmU fWB9Pgo= IEhpcm8= KFRSVUU= YXN1cmVy IGN1ZXI= VWJlcg== Lk9wZXJhdGlvbg== IG9sYW4= IHRocmlsbGluZw== PFJlc3BvbnNl IEZlbWlu IHRyYXZlcnNhbA== IHBvYw== IHNldFN0YXR1cw== ZGVjbGFy c3RkYWZ4 IGFkZGljdGl2ZQ== IEJ0bg== IGV4cGxvc2l2ZXM= IENvb2tpbmc= IFBsYWludA== IGFjY3VtdWxhdG9y IEFwcG9pbnRtZW50 LHBhc3N3b3Jk IEZBUg== bHVldA== RnVydGhlcm1vcmU= ZGVjbHNwZWM= X1N0YXRpY3M= LkRpY3Rpb25hcnk= Ij4nLg== CXZhbGlk IiIs SW5zdHJ1bWVudA== Pko= IG5vc3Ry IFJpZnQ= X1BvcnQ= IHZlY2Vz W1sn IHJhbGxpZXM= LXNlcmllcw== IHZ2 LnVj IHJ0bg== U3RhdGVDaGFuZ2Vk KGlucw== IENsYQ== LS0tLS0tLS0tLS0tCg== Y3Vz IFJlbG9hZA== Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0= LnNlY29uZHM= X2Rlc3RpbmF0aW9u IHNjcmV3ZWQ= PmM= VGhpY2tuZXNz RGVzaWduZXI= IGdyaWRz bsSF KGNvb2tpZQ== VHJpcA== LU1vYmlsZQ== IHZvbGw= IGdlbml0YWw= IGNvbmZpc2M= IENvbmZlZGVyYXRl IHdlYlZpZXc= IG1pc2U= IGNsZXI= KHNlbGVjdGlvbg== JGRhdGU= IHNoYXJwZW4= cmFnZW4= QW5kVXBkYXRl IHJlbWl4 IGh0b25z Ulc= TVBJ IHJldHJpZXZhbA== IHJpY2hlc3Q= LkRlY29kZQ== OmluaXRDb21wb25lbnRz IFRWYWx1ZQ== U2FpbnQ= QGluY2x1ZGU= IFBFUlNPTg== LnNlcA== IExEQVA= Z2Jh IGdyb8OfZQ== IHJlbGlhYmx5 IERGUw== LmdldEl0ZW1JZA== IHByw6lzZW50 LmdldFRva2Vu IGNoaW5lc2U= IE1lYWw= WU9V Ij48Pz0k KGNob2ljZQ== IHBoZW5vbWVuYWw= IFN0ZWVsZQ== wqI= IFBhY2thZ2VNYW5hZ2Vy IFN5bmRyb21l RGlyZWN0b3JpZXM= aXZhcg== LnVuc3Vic2NyaWJl bGllw58= bW9ubw== X2Nvbm5lY3Rpb25z X3ByZXNlbmNl eW55 S25pZmU= IGdyb292ZQ== IHNjb29w VEVNUEw= YXNha2k= LmhhbWNyZXN0 IGhhcmJvcg== Y292 Kno= IFh1 IHByb3Bvc2luZw== IEZSQU1F Q2hpcA== IEVlbg== IOyghA== IHNtYXNoZWQ= VW5zaWduZWQ= KC4u X2ZpbmlzaGVk IGdldFN0YXR1cw== IGZpYnJl QXhlcw== ICcvJyw= eWFyZHM= TURC LWJz aW50ZW50 IGJvb3N0ZXI= LmRzdA== LkRpYWxvZ1Jlc3VsdA== IE1ldHM= IGJlYXN0cw== aW5jcmVtZW50cw== LmthZmth VUlBbGVydEFjdGlvbg== LWV2ZXI= X2JhbA== IGhlbHQ= IGZyZW9wZW4= IFJlY3J1aXRtZW50 bGljdHM= Zm9yZ2V0dGFibGU= RGlzcGxheWVk X1ZFTkRPUg== Q29sbGVnZQ== QVNDSUk= IFNpbms= IE1hY2Vk IGN0b3I= IGVzdMOjbw== IFdpbmRzb3I= X2NoZWNrZWQ= X2RldGVjdA== YXR0ZW5k IHhtaW4= IGluZGlzcGVucw== L3BlcnNvbg== X0RFVEFJTFM= UkVESVQ= SGF5 YWJvbGlj IGZ1bmN0b29scw== aWFpcw== RlRQ X1JlY3Q= IEluZHk= LXB1YmxpYw== b2hhbg== X21hbmFnZQ== Q29tcHV0ZWQ= 7JeQ7ISc IFNsaWNl IGdheXM= IGFsZXg= YWl0cw== IHJlY2VpcHRz U1BFQw== IEJFRk9SRQ== IFByZWZpeA== X3Zpc2l0 IHNwdW4= TEVURUQ= IGRvdw== IGxlZ2FsaXphdGlvbg== YWJiYWdl IGNsYXc= IFRjbA== eGltYQ== IGNvdmVydA== Tmk= IHRoYW5rZWQ= IGFsbGVyZ2lj bG92ZXI= IEJyZWFzdA== LmlzQWN0aXZl IGdlYmVu VkVSU0U= Wk9ORQ== CVJlc3VsdA== JykuJw== IGdlZQ== IFNlcmlvdXNseQ== cHVycGxl IEVzcGHDsWE= aWZpZQ== LXBhY2s= UGFydGljbGVz ICcvLi4v IG11bHRpbWVkaWE= YXV0b2NvbXBsZXRl IFRIUkVBRA== IHJlZmVyZW5jaW5n cmVldGluZ3M= IHF1b3Rpbmc= IGFzc2lzdGFudHM= amVuaXM= aGFwcHk= IGxheXM= bGliZnQ= eGRh IGZvdQ== cGlhcg== UmVjb21tZW5kZWQ= IEJpcmRz IFdhcnJhbnR5 w7xybGljaA== LklOVklTSUJMRQ== X2FuY2hvcg== 4oCdOg== RmFudA== X2RlZnM= IGRyZWFtZWQ= IF9fX19fX18s cGxh w6RmdA== b2RrYQ== xLFz IGRhZGR5 c2NoZW1hcw== PXplcm9z IHJhdHQ= CQkgICAgCQ== aWVq IGRyaWxscw== LTw/ QUJB Lmxpbmtz IERlcGVuZGVuY3lQcm9wZXJ0eQ== Lmxvdw== aGVlZA== X0JMQUNL L0FkbWlu IGFtaWdvcw== aW5nZWQ= IE1pY2tleQ== LkdldEF4aXM= IE5lZWRlZA== IEVuY29kZQ== w6lyaWV1cg== IE1hbmlsYQ== IENvbGxlZw== YWRhc3Rybw== IGNoaWNhcw== 5L2g IG9uZXNlbGY= eGVh ZHVr IGd3 dXJnaWNhbA== IENlbnRybw== IGFlcw== ZmVlbA== IHRyb3Q= IGVsZWN0cm9ucw== IHJpdHVhbHM= IEJpbGRlcg== IGRlY29yYXRl IFRva2VuVHlwZQ== IGx1cmU= QXBpQ2xpZW50 Z3JwYw== IE9yYw== Q29udGV4dE1lbnU= UFJFRklY LXRoZW1lZA== X2ZpZm8= LklucHV0U3RyZWFtUmVhZGVy X3NwZWNpZmlj IERTUA== PXN1YnByb2Nlc3M= L3NoZQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAo= IGRhdW50aW5n IGNsZWFycw== IE1vdmVz IG15c3Rlcmllcw== LWJlc3Q= IFZ1 b2xpYg== IElzaA== IGNhcmFjdA== KExhYmVs IERlYmlhbg== IEV4cGVyaW1lbnRhbA== IGNhdg== LlRvRGVjaW1hbA== IFJob2Rlcw== IEhhd2tz IGZvdW50YWlu X1BFTkRJTkc= X1NV IHd4U3RyaW5n IFBldw== LmNsaQ== 0YTQvtGA0Lw= LndlYmtpdA== X0NO IDs7PQ== CW5hbWVzcGFjZQ== IHdQYXJhbQ== IHB1cHBpZXM= IHRlcm1pbm9sb2d5 IGFkZGljdGVk IGZvcmdl IEdhcmRuZXI= IHBlc3NvYQ== CVJlc3VsdFNldA== IGF0dGVudQ== YW5nZW1lbnQ= X2luZHM= Q2hp YXJpdGg= RW5jb2RpbmdFeGNlcHRpb24= bW91c2Vkb3du IEJFVFdFRU4= d2VpZ2g= IkZvcg== LmRk aXRlbA== WU8= IERpY2U= dW5peA== IE9idA== IENlZGFy IHNwZWNpbWVucw== cG9ybg== IHVub2ZmaWNpYWw= 6buR c29tZXRpbWVz IEJ1bGxk dHJ1c3Q= Z2V0UmVzdWx0 IHNtb2tlcnM= IHNhbmR3aWNoZXM= IGV4aA== IEZhZGU= X0RD IG1hc3R1cmJhdGlvbg== Zm9ydGF3ZXNvbWU= VEhJTkc= X2FuZHJvaWQ= IGRlZGlj LXNlbnNpdGl2ZQ== IG5hY2t0 TElCSU5U IGFnb24= IERJU0FCTEU= b25lc2lh Ymllcw== IFpJUA== IGhhdW50ZWQ= IGN1aWQ= L2NhcnQ= a29z CVJUTFU= IGhpbmRlcg== IGFkaXBpc2ljaW5n SUVOQ0U= LmJhbms= IEN5cHJ1cw== bWl4ZWQ= LmN5 LXNpbmdsZQ== PGxlbg== Q29taW5n IGZhdWx0cw== IGZvcmVzZWU= Z2V0bGluZQ== ImE= IGJyYWc= IGRpc2Nz IHJpcGU= IG7DpnI= IEdH U0hPVA== ZGVyYWJhZA== KGVkaXQ= VG9MZWZ0 W10pOwo= IGRvR2V0 dmF0dXJl TmVlZGVk IENoZW5n Y2Np RUZJ IGZldWQ= IGx1bmFy LlNoYXBl Tm9ib2R5 X1RSSUdHRVI= Q3k= Z3JvdW5kQ29sb3I= IFJlbW92YWw= KGJvdHRvbQ== JG1zZw== U0NJSQ== cml0eg== IGZyZW50ZQ== IGNvbXBvc3Q= YW5zd2VyZWQ= IFJvZHI= X0hUTUw= IHNpbGhvdWV0dGU= IFFVRVNU IENhdGhlZHJhbA== LkNvbW1lbnQ= IE1u LW5ldHdvcms= LmdldEZpbGU= LmdlbmVyYXRvcg== IENoZWNrb3V0 X3pvb20= IGVuY29kZVVSSUNvbXBvbmVudA== X1RD c29t IFNlcmll IGJhc2VVUkw= CXJ1bg== IGh1aA== LnNlbGVjdGVkSW5kZXg= IFNUQVI= fi1+LQ== YWJjZGVmZ2g= Lm1hcHBpbmc= PWRhdGV0aW1l Q29vbA== bmlt IERpcmVjdGl2ZQ== RmVkZXJhbA== IG1lbnVJdGVt INCQ QW5uYQ== IFJlY3JlYXRpb24= cnlhbg== LWFnZWQ= emVyYmFp 4oCm4oCdCgo= Y2FtcG8= IG1pbmlhdHVyZQ== ZGV0YWNo bWVhbmluZw== X2VtcA== UGVhaw== IGJjbQ== IEh1bmdhcmlhbg== IENhc2NhZGU= IHNhY2tz IHRydW5jYXRl IOKWiOKWiA== IHdoYWxlcw== IHNvcnRhYmxl IGFzc2VydHM= IHNlYWxz b2N5dGVz XSkpKQo= YWxhcm0= cmVzc2luZw== KHNpZ25hbA== IGVtcGVyb3I= CU9O Y29tbWl0dGVl IHRyaWxvZ3k= LlRyYW5zYWN0aW9uYWw= R3Jvdw== X3VhcnQ= IHN3aW5ncw== IHNwZWN0YWNsZQ== 4oCZYXY= IFNlbnRpbmVs INmE IFRvdQ== IHdpZG93 Z2VyYWxk LHVpbnQ= IHVudXN1YWxseQ== PENhcmQ= IFJlc3RhcnQ= bW9y 44GC44KK aXhlZFJlYWxpdHk= IGhhbmRndW4= 4pSA4pSA4pSA4pSA4pSA4pSA4pSA4pSA IGxpdGhpdW0= UmVzb2x2ZQ== Z2V0Qnl0ZXM= L2Z1bmN0aW9ucw== IHRhY2tsaW5n T3V0bGluZWQ= IH08Lw== IFNleG8= IEFuaw== IHJhdGlvbmFsZQ== cmVtb3ZlQXR0cg== IG11bmljaXBhbGl0eQ== IGFzc2F1bHRz Q0hPT0w= IFJlZQ== IGJhdWQ= pqw= IGVuaGFuY2Vz INC/0YDQtdC0 IGNvbmNlc3M= Lmluc3RhZ3JhbQ== LmdldFJlc3BvbnNl c2VnbWVudHM= IHdlbGxiZWluZw== fTsKCgoK aHVuZw== 44OG IHJlbm92YXRlZA== LmV4cGVjdGVk IHJhZGlhbA== IGNvbW11bmFs dXNlck1hbmFnZXI= K2E= IGZ1bmRhbWVudGFscw== LlRI 6II= IHJhbnQ= IFN0cmF3 IE9sZURi YXppbw== IGhhbWJ1cmc= IHBhaW50cw== IHRodW1icw== IE51bGxQb2ludGVyRXhjZXB0aW9u IGdyb3VwZQ== IEhvbWVDb21wb25lbnQ= IGJhbGxv IElOSVRJQUw= X2FyZQ== IFBlcw== dXJzZXM= IGJhcmR6bw== LmdldExlbmd0aA== YW1vdG8= Lm5vdGlmeURhdGFTZXRDaGFuZ2Vk aWVuZXM= ZW56aWU= X2VtYg== dW1uaQ== c21vb3Ro IERybw== cGFzdGU= IE5hcnI= LS0tLQoK z4k= IEF1dG9y IG91dHJvcw== IExBQkVM LnBh LlN0dWRlbnQ= KFhtbA== IGV0aG5pY2l0eQ== IEl2eQ== 44KI X2Zha2U= Pyg6 dXBsb2FkZWQ= Z2V0TWFuYWdlcg== LVFhZWRh b2RpYWM= Q29ubm9y aWhhbg== TUFU KG1pZA== IEFsYmFu IHNvaXI= Q29tYm8= IFB1YmxpY2F0aW9u b3BvdWxvcw== cGlz IHRlbXBsZXM= b25neWFuZw== X2NsaWVudHM= IHJvZHM= IHhj aWprZW4= IHJlYXA= IOS4i+WNiA== CWNvbm5lY3Q= Rm9jdXNlZA== LGNvdW50 aWV0ZXQ= IGhhY2lh X2FsbG9jYXRvcg== IHRveGljaXR5 KHNlcXVlbmNl IG51ZXN0cm9z IFByaW5jaXBsZXM= IGxsZQ== YWxhcmlh LndyaXRlU3RyaW5n IEFGTA== aWZuZGVm IERvcw== xZtjaWU= IEFnZ3JlZ2F0ZQ== IHNhY3JpZmljZXM= X29mZnNldHM= bGRi IGxhdGNo IGZ1bGxzY3JlZW4= bWlzc2l2ZQ== T1BUSU9OUw== IFRlbGVwaG9uZQ== IGFyc2VuYWw= amVqZXI= IEhvc3A= IGZhdm91cml0ZXM= cml2ZQ== LmluY3JlbWVudA== IGJ2 IEZhbnRhc3RpYw== LnNheQ== ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA= IG1lZGljaW5hbA== IERST1A= IHBpdHk= bWV0aXM= IHdvbGxlbg== IGJlZg== X0Js ID4+Cgo= Ym93ZXI= IHN3YXBwZWQ= L2luc3RhbGw= IHNpbmtz ZXRyaXpl IGRlY2xpbmVz CW15c3Fs IENTdHJpbmc= IE1vdGlvbkV2ZW50 Lkxhbmd1YWdl Um9hZA== 0YLQtdGA YXNjaW1lbnRv JykpLT4= LmFib3V0 KGVkaXRvcg== IFJhdGluZ3M= aW5jb21l xaFl LmRlcXVldWVSZXVzYWJsZUNlbGw= IEF1c3RyaWFu IHN1bGxh IFRyaWJ1bmFs IERpZG4= 0L7QstCw0YA= IGluc3BlY3Rpb25z Qm9zcw== IGNvY2t0YWlscw== IGFwb2xvZ2l6ZWQ= X3N1YnBsb3Q= b3BhbA== Kz0o IHJlc29uYW5jZQ== aWJ1 IOumrA== cm9tYQ== cmVzZXJ2ZQ== cGxz IFRhaA== YXhpZXM= T1BMRQ== IERhcnJlbg== IFpvbWJpZQ== X01hcA== IF0pCgo= IFFp IFNhaWw= IHJlc3RyaWN0aXZl IGVyb3Npb24= LXBhcg== V0hJVEU= IG9sZHU= IGFwZXJ0dXJl IGJpdGNvaW5z dGV4dG8= IENvbWNhc3Q= IHRpbWVsZXNz ZW5raW5z IGZlZWRlcg== L3RtcA== cmVzZGVu Kydf LkRlc3Ryb3k= IMOnb2s= IERPQ1VNRU5U LmxuZw== LnRhZ05hbWU= IGt1bGxhbg== ZWdyYXRl ICgqLg== 57yW6L6R IGhhbmRzaGFrZQ== c29j X2dlb21ldHJ5 IERhbWFzY3Vz TWlub3I= IEthZmth 7Jes RmxvcmlkYQ== X2NvbXB1dGU= LmV4cHI= IHBhcmFsbGU= IERpYXo= Y2ly W3RhcmdldA== IGpva2luZw== IGdsb3I= KHNldHE= X2hhbmRsZXJz SGFuZw== IGZlcnI= cmltaW5hbA== CSAgICAJCQ== ZW50aWVz ZGVmaW5lcw== LXRheA== anNvbnA= IFVQUw== bWV0cm8= X187Cg== IFVnYW5kYQ== XSkpOgo= X3Rk eGFl bHc= Lk9T IExvZ2dlZA== YWNpZA== IE1heW8= YXNwZWN0 IHZhZ2luYWw= IGluaXRpYWxpemluZw== IHN0ZXJvaWRz ZmljdGlvbg== R1JF Z2VuZA== IGxpYWJpbGl0aWVz IExldHM= TWVjaA== KG5j KGNoYW5nZQ== IGNvbm5lY3RvcnM= Oms= IHRhc3Q= ISIpOwoK dGhpbmdz cm9waHk= bHVldG9vdGg= IFNpZ25VcA== LmN0cmw= IHRoZXJlaW4= b3JkYQ== LmVzY2FwZQ== aWdhdG9y IHBldHJvbA== IHNwZWNpbWVu IGRlYnV0ZWQ= LVBybw== IGNyaXNlcw== LmFkZFZpZXc= 64+Z LWRvb3I= IG1vbmV0 IG1pbGxpcw== IHZpZXI= SW50ZXJuYWxFbnVtZXJhdG9y IGFkbWlucw== IExhaXI= emlu Z2V0UXVlcnk= dW1ibGVz TElNSVQ= IFZpZw== X3Nvbmc= PENoYXJhY3Rlcg== Ojou X2hvbQ== X2Jw IFN1cGVydmlzb3I= c3VibWlzc2lvbg== YWJpbGU= IG5vaQ== T3JDcmVhdGU= IHBlZWw= IG9uU3RhcnQ= IHNlbnRpbWVudHM= dmVoaWNsZXM= IGNsYXNzcm9vbXM= IHN6ZXI= IGJlbmRpbmc= IGxvbmdldml0eQ== IGFjbA== IEFsZXBwbw== IFVN IFJpY2h0 IG11bHRpcHJvY2Vzc2luZw== RE9NQUlO IiwiKw== X1lFQVI= IHNjcmFwZQ== IHNvbGl0YXJ5 ICJdIjsK L2Vycm9ycw== 7J6s nOugpQ== YmV0dGVy CW51bWJlcg== IExG IEFjcm9zcw== UHViTWVk XCIi IEV4Y2VsbGVuY2U= IHVzYW5kbw== IFVJUA== QWN0aXZpdHlJbmRpY2F0b3I= X1ZPSUQ= IGJyZWVkcw== 772l dWVzdGFz IFRyZWFzdXJl dXN0cmFsaWFu KGZhY2U= IFRlbm5pcw== CUludA== IEhhbnNlbg== 57U= Okk= IOKclA== R1JBWQ== T1VTRQ== IGhlcGF0 oO0= QUlS w7PFvA== IHF1ZXVlZA== dmluY2lh IENocm9taXVt IGNvbXBldGVuY2U= dW5nYWw= aWxsaQ== IGdldEJ5 IEZpbmRlcg== IGluY2FwYWJsZQ== IHNhZGQ= IGNpdGVz IENodXJjaGlsbA== U2Rr TW9yZW92ZXI= QXNwTmV0 KEZsb2F0 JHBhc3N3b3Jk IENvbm5vcg== LXNlc3Npb24= X2Rt Kikp IGRldXRzY2g= IE5Y IHBlcmtz X1NPUlQ= X1RPT0w= X1ZJU0lCTEU= LmFzcA== 5oiW IEJyZWF0aA== RGV0ZWN0 IER1ZWw= LmNtYg== W2l0 LlNldEJvb2w= IG5hcmNpc3M= IGFiaWRl IGVqZW1wbG8= IOKElQ== IG1vcm5pbmdz IGNvbXB1dGVz LnNzbA== anQ= IG11Y2hvcw== X1NT W2VuZA== IGJhc2lu IGFsZ3Vub3M= IENyb2F0aWE= bGluZXdpZHRo KHRhZ3M= KGhpZGRlbg== w61jaW8= IGFwYXI= INC2 5LiO LmZvb2Q= IFJ1cmFs IGJyZWFkdGg= 5b2x KHNlc3M= KyIp IFBhc3Rl IHNlcnZpZG9y IEJpdFNldA== IFRyYW4= bGF1cw== dmV0dGU= ZXllcw== IENMSUNL IFZJSUk= IFR1cm5z IExlQnJvbg== IE11ag== IERlZw== IEFkdWx0cw== X3N1aXRl cHJvY2Vzc2FibGU= IFBIWQ== Z2hlc3Q= LkZhaWw= IFNsYWNr Y2Vq XENhcmJvbg== IHN1cGVyc3Rhcg== IGhvbGRpbmdz KGZvcm1z ICcjJw== TXVsdGlw KCJbJQ== LXNvbGlk L3VybA== LXRpZXI= W2xlbmd0aA== IFN0cmVhbVdyaXRlcg== IE1hcmtldHBsYWNl Z2V0dGV4dA== X1RJQ0s= IEZvcmdl IGJsYWNramFjaw== IERPRVM= IE1hdHRlcnM= d2F2ZXM= IHdoaXNwZXJlZA== IGx1c2g= 7Jik ZGlnaXRhbA== IHdyaW5r IEhvZ2Fu IHJ1c3RpYw== LkFwcGx5UmVzb3VyY2Vz IEhhcmR5 b3NvbWVz QVVU LlNUQVRF IG5hcnJhdGl2ZXM= CXN0b3Jl Ymli CVNjYW5uZXI= IENvZHk= XFJlcG9zaXRvcmllcw== IHJldW5pb24= YW5kdW0= 4oCZaA== IHNuaWZm TlNCdW5kbGU= IGNvbXByZWhlbmQ= X1VTQUdF X29jYw== VVJSRU5DWQ== Sk5J IHNwZWNpYWxpemluZw== IHZpc2lvbnM= IGRvbG9yZQ== IHbDoQ== IENoZXZ5 IFN0eWxlZA== aW1wYWN0 YWxsZW4= IGthcnQ= IFRhYmxldA== c3R1ZmY= cmVlc29tZQ== 0LDRgtC+0YA= Ly8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0K X0FkbWlu IGNlbGxwaG9uZQ== IGF1dG9wbGF5 IGNhbWJpbw== IG1hcml0aW1l X0JPT1Q= LXF1YXJ0ZXI= IGxhdGluYQ== IEFKQVg= ZXF1aXY= IEZyb250aWVy IFhZ fV0K IFJvdWdo LnByb3Rv IGNvcnJlY3RuZXNz IGZhY2ls IFJlYWNoZWQ= 44Gd44Gu VklT LnBz IHN0cm5jcHk= IGRpZmZ1c2lvbg== LnN0YXJ0QWN0aXZpdHk= 77+977+977+9 IGFjY29tcA== QU1FU1BBQ0U= aW1vbmlhbHM= IEJsYXN0 YWJ5cmlu IGRvbWU= IGV4dHJhdg== IHllbg== IGN1bGluYXJ5 UFJJ IENvbW11bml0aWVz bmlk X29wZXJhdGlvbnM= Lmhz IE1pbHRvbg== IG5vaXNlcw== QXV0b3Jlc2l6aW5nTWFzaw== KGNpZA== fQoKCgoKCg== XX0sCg== IERldGVjdGlvbg== dGFibGE= IGxpYmVydGllcw== X0RZTkFNSUM= d2dldA== IFTDvHI= IFBhc2NhbA== VHJhbnNwYXJlbnQ= RGVsYXllZA== XSgp IEhlcmJlcnQ= PEFjdGlvblJlc3VsdA== Y2hhbGxlbmdl IG11c2hyb29t Lmluc2VydEJlZm9yZQ== IFJpbg== IGh1bW91cg== IGbDuA== YXBpS2V5 YWxsb2NhdGVk IGNvbmZlc3Npb24= LiIsDQo= CWFzc2VydFRoYXQ= IFNPUlQ= IExPUkQ= IGV4cG9ydGVy LnNldExldmVs cG9rZW1vbg== YXNodHJh IGbDqQ== dXJhdG9y KE1TRw== IHR1cA== IEh1bGw= IHlpZWxkZWQ= LlN1YmplY3Q= XFJvdXRl IT8= INGD0LTQsNC7 XFNlY3VyaXR5 LWFy IGFsbGVnYXRpb24= KFNldHRpbmdz w6RuZGVy IGVsbGlwc2U= IFJldHJvZml0 IHJlZ3VsYXRpbmc= IE1vbGx5 IExvaw== X0N1c3RvbQ== IFByb21v aXNpbg== IHJlc3VtZWQ= IG1ldHJvcG9saXRhbg== LmVycm9yTWVzc2FnZQ== Oi0tLS0tLS0tLS0tLS08Lw== Lm1s c2NvcGlj LnJlZnM= YXB0b3Jz IEluc3RydW1lbnRz IHByb3BhZ2F0ZQ== fS0+ IHBhc2Fkbw== dGhhbms= X0RlbGV0ZQ== IEJyaWdodG9u LHVuc2lnbmVk 5L2c6ICF IGFzcGlyYXRpb25z LWhvdw== Um9zZQ== PSgo X25lZWRlZA== X3BsdXJhbA== PEFwcGxpY2F0aW9u IFdFRUs= IFVubG9jaw== IFRFTVA= U291 IHNjaGl6b3BocmVuaWE= IHRyb2xs IGNvbXBsZW1lbnRhcnk= IE5FVFdPUks= IGJsaXI= IHByb2dyZXNzRGlhbG9n IiUo IEF0dHJpYnV0ZVNldA== CXRz Lml0ZXJpdGVtcw== 6K+d IGVzY3JpdA== dm91cw== X3BsYWNlcw== SEs= IHNlZ3Vpcg== X2Z3 IFJvdW5kZWQ= IGRpc3Bvc2l0 6KeG cGFybQ== d293 U1RSVUNUSU9O LmFsbG93 IENoYXJTZXF1ZW5jZQ== CWV4dGVybg== IHByb3NlY3V0ZWQ= IG1vcnRhcg== IEp1ZGE= LW1zZw== IGVzdHVk LmdldERlc2NyaXB0aW9u IHNvdw== YW1icmU= IHJvbWE= RW5o Ym9udXM= IHNxdWF0 IGRpc3RyYQ== ZWRJbWFnZQ== IHBlcHBlcnM= LXBlcmZvcm1hbmNl LAoKCg== LGZpbGU= IE1JTUU= X2NvbmNhdA== QUJT LWZhc2hpb24= IHVuZGVyY292ZXI= T25lVG9NYW55 IHJlY2xhaW0= Q09QWQ== IGJpbmRz IFRhcGU= IGdvc3NpcA== IEVxdWl0eQ== L0NhcmQ= LmFjdGl2 J2Ft IGRyYWluYWdl PFNjYWxhcnM= IG9uQmluZFZpZXdIb2xkZXI= KCk/Lg== IHNvcnJvdw== IEli dXB5 X1VVSUQ= IENoYXJt IEVsZWN0aW9ucw== Lm9uRGVzdHJveQ== IEludGVyZXN0aW5nbHk= b3VuZGluZ0JveA== X2RldGVjdGlvbg== LWhlbGQ= X3Vua25vd24= IHJlZnJhaW4= IG3DqXRvZG8= IGVCb29r RU5PTUVN IGRhbmc= UHJvZmVzc2lvbmFs IGRpY3Rpb25hcmllcw== L215c3Fs IFNUVUQ= IG1hc3Nl c2NhcGU= IGRyZWk= Om5hbWU= LmxvZ28= U2lnblVw IHRhaHVu KHRoZW1l IEZlbW1l IGJvbWJlcg== IEphZGU= IFRheQ== IHN1Ym1hcmluZQ== X2NsYXVzZQ== enljaA== IHNpbXVsdGFuZW91cw== IGNhc29z LmJvb2xlYW4= KGxocw== IGNvbnRpbmVudGFs LXNhbGU= CWVudg== IEN1dGU= IEZhY3RvcnlHaXJs YWJ1cw== L3ZhbHVl IGphZHg= IHN0ZXJu Pj4KCg== IHN1cmZhY2Vk IOyggOyepQ== cGxhdHo= CWVtYWls Y2VwdG9ycw== Ij4o IGVwaWxl 6K+7 IERlYnQ= 5ZGK Tk9Q Imh0dHBz Omo= Rm9ybUl0ZW0= X0xJQ0VOU0U= LmdldERvdWJsZQ== IEFnZW5kYQ== CWZpbmFsbHk= KGZpbHRlcnM= KGF2 576O QVBFUg== IGxhdmE= 0LXRgNC2 KSkpKQoK IGZhdWx0eQ== X25t IHRyYXZh KEJpdG1hcA== IHNwZWVkaW5n PicpLg== IHNjcmVlbmVk X3JvbGw= IE1hY0Jvb2s= IEFVRA== IGRpYWdub3Nl LkdlbmVyYXRl IF5e IHN0cnM= W1Rlc3Q= IHJhbnNvbQ== IERIQ1A= ZWxkZW4= IGludGVycHJldGF0aW9ucw== KCldLg== ZmxhdE1hcA== IGxpbmVIZWlnaHQ= X21vdW50 IFdpemFyZHM= IHNsdXRz ZWhsZXI= b2RhbA== IG1pbGl0aWE= 5bI= ZWFybmVk IG1pc2VyeQ== aW50dmFs ZnVuZA== IGhpZGVz IGRpYXJy IFdlc2xleQ== IHhtbQ== IHF1ZW0= IEFyYWJz aWZ0aA== YXRlZ29yaXplZA== RGlzcG9zYWJsZQ== UHVyZQ== X05PVElGWQ== c25pcHBldA== IEdhcnJldHQ= LnJ1bm5pbmc= LndlaWdodHM= ICgtLQ== IGludmFyaWFudA== 5LqL5Lu2 IEFsbG93ZWQ= ZGlycw== IHBhc3Npb25z IGxhZA== IEZsdXNo bWVudXM= OmJsb2Nr IGNvbXByYQ== LmNob21w YWxsb2NhdG9y IGN1cmF0ZWQ= IEtub3dpbmc= IFBhdHRlcnNvbg== IHRlbGFo J2V4 IGRvb21lZA== IHBoaWxhbnRo b3R0eQ== LnN0eWxlcw== T3duZWQ= IGFsbGVyZ2llcw== PXBhcmFtcw== b2Nlc2U= aXRlbGlzdA== IFNlbmRpbmc= YmVm b3JyYXI= IE7Do28= IEZhcmdv IEx1Yg== IENvbWJpbmVk X2dpdmVu CQkJCQkgICAg IHJlY29uY2lsaWF0aW9u UGF0dGVybnM= YXphcmQ= IGJpb21hc3M= IEhvdXNlcw== cmVzcHVlc3Rh Y2Nv L3RvcGljcw== IFl1aw== IHdlYWtlbmVk X2NhbGVuZGFy IG11bGhlcmVz IE1hcmw= IHNpbmU= IFRpbA== IFNvdWxz IERldXRzY2hl IEZPTExPVw== IHBpcGVsaW5lcw== IEJldmVybHk= X0RJUFNFVFRJTkc= IiM= IFByb3Rv LmJpZw== IFNhdmluZ3M= IFRhbno= anVu IEdhbW1h IFNhZGQ= IGFkdmlzb3Jz IHJvYXN0 IHVudGVycw== dWRpZXM= X2xvbg== LXBvaW50ZXI= IEVsZW1lbnRSZWY= XEJ1aWxkZXI= ZXhhbXBsZUlucHV0 LndlYmRyaXZlcg== ZGF0YVR5cGU= IFF1aXRl IENlbHRpY3M= dWls LWRlZmVuc2U= YmlzaA== IFVJV2luZG93 IFN1ZGRlbmx5 LmhvdA== LnJlYXNvbg== IGfDtnI= QU1E Lk11bHRp YXV0aGVudGljYXRlZA== cmVnaW9ucw== Oyg= 0LDRgNCw0Lw= IEtpcmJ5 JHJvdXRl UFJFQ0FURUQ= IER1cmhhbQ== b3dv IFBlcmZvcm1z IGRpc3JlZ2FyZA== bnN0 IFBvbHM= IGdldFA= Il06 LWNvbG9yZWQ= KEtleXM= IEFsbGVn X21vZGlmeQ== X2xvYWRpbmc= c3RyYWluZWQ= IGF0cm9j X3Bocg== PFNwcml0ZQ== IHNhdGlzZmFjdG9yeQ== bWFuc2hpcA== LnBpcGVsaW5l VG9ueQ== IHRoaWVm cG9sYXRvcg== KGxvY2s= YnVyc3Q= IE9wdGltaXphdGlvbg== IHN1cmZpbmc= Illlcw== IGRlc2NlbmRlZA== 5pI= X0NsZWFy IGNyaWVz IEZyb3plbg== RElSRUNU LUNvbg== IExlaWNlc3Rlcg== 5aWz T09N PWRi IGdldE1lc3NhZ2U= PFN0dWRlbnQ= X2JhdGNoZXM= Lk1hc2s= X2V0aA== XCk= IHNvbWE= Q2F0Y2g= W2No T3duZXJz aW5kbGU= OmF1dG8= LnZlcnQ= aXZy LnNldExvY2F0aW9u IGZsdWVudA== X0VORElBTg== IENhcmxv Y2VwdHM= YWRkQWN0aW9u Lm9hdXRo PFVuaXR5RW5naW5l cmVlbWVudHM= LlNraXA= PykKCg== LmRlZmF1bHRQcm9wcw== IGNhYmU= IFNoZW4= ZXJvc2lz IFByb2ZpdA== IHBvaXM= X0NSRUFURUQ= IHJlbW92ZUZyb20= KHdz P2FjdGlvbg== KEZpZWxk IGVycm9uZQ== Lm1pbmltdW0= IFJldHJpZXZlZA== IGRhZG8= IFBSSVZBVEU= LXNwZWM= IGd6aXA= cGRhdGE= IHBvc1k= KGxvdw== IHF1YWxxdWVy L2Nsb3Vk 6rKM KGNvbW1vbg== IEFyYmVpdA== b3JnYW5pc2F0aW9u IHRpZHk= IFJvbGFuZA== KHBo LnpvbmU= IGdlbnRsZW1lbg== xrDhu6Nj 5bGx IGVuY2xvc3VyZQ== IE1hbmFmb3J0 CUNvbG9y U3RlbmNpbA== Tmlj IHRoZW9yZW0= IFZH IGNvbG91cmVk VkJveExheW91dA== dWxzaXZl RHJhZ29u Y2Zm ZXRlc3Q= ZW5zYQ== b2ZkYXk= LkF6dXJl OlVJQ29udHJvbEV2ZW50VG91Y2hVcEluc2lkZQ== X3VwZGF0ZXM= IHRyZW5keQ== dWdhcw== d2Vha1NlbGY= IHJpZGdl aWJyaQ== IOy2lA== KENH IE1vbmtleQ== LndyaXRlSW50 LnRpbWVkZWx0YQ== Vmlld0NvbnRyb2xsZXJBbmltYXRlZA== IFByb3ZpZGVuY2U= 44GI IGJsZW5kcw== L1N1YnRocmVzaG9sZA== IEFwcGw= IGF0YW4= IHJlbG9hZERhdGE= dW1ib3Ryb24= c3TDvHQ= T0F1dGg= IEdpdmluZw== IOyEpA== IEZpbm5pc2g= Y2hlY2tpbmc= LkVtYmVk c2VxdWVsaXpl IGluaXRpYWxpemVz IE9zbG8= 2LY= Z2V0RXh0ZW5zaW9u X0FMVA== KGJsYW5r IGZhdGFsRXJyb3I= IGRlbWlzZQ== KioqKioK IFhT KEFG IEVucw== YW50aGE= IFBPUg== IG5pY2g= Lk5hbWVk IGdpZ2FudGlj IE9ic2VydmF0b3J5 LlJlc29sdmU= IFBheW1lbnRz Z3VpbGQ= IGN1cnJlbnRTdGF0ZQ== PT09PT09PT09PT09PT09Cg== IFNleQ== cERhdGE= IGRlYWRsaW5lcw== IGNlbnRyYWxpemVk IFNjaG9sYXJzaGlw X3N1cHBvcnRlZA== LmNocm9tZQ== KCldKTsK IGN5YW4= IENhZ2U= QXV0aG9ycw== Xw0K L29z a2lt ZGVl LnRleA== IHlvdXJzZWx2ZXM= IG1ncg== IGFsaw== LWluc3RhbGw= IGRyYWZ0aW5n IHJ1bW9y IHN0YXR1ZXM= UG9vbGluZw== b2xpbmE= QUFBQUFBQUE= LyotLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t IGV4dHJlbWlzdHM= Q2FsY3Vs aWdodGhvdXNl SW5zZXQ= KElOUFVU IHN5bmNocm9uaXphdGlvbg== aXZpcnVz LmF4ZXM= IEdhcA== LUFu X1RlbXBsYXRl IGdhbWVy IENyaWNrZXQ= IGxpbnQ= IGF1dGhvcml0YXJpYW4= TlNVSW50ZWdlcg== IHJlZG8= IGFkaXBpc2Npbmc= X0ZFVENI Y2h