/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  Location: () => Location,
  default: () => SemanticCanvasPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian = require("obsidian");

// FileNode.ts
var FileNode = class {
  /**
   * A Node on the Canvas that represents a file in the vault
   * @param file
   * @param data
   * @param settings
   * @returns
   */
  constructor(file, data, settings, appRef) {
    var _a;
    this.filePath = file.file;
    this.propsOnCanvas = {};
    this.app = appRef;
    if (file.inGroups === void 0)
      file.inGroups = [];
    let relevantIds = [file.id];
    relevantIds = [file.id, ...file.inGroups.map((g) => g.id)];
    const relevantEdges = (_a = data.edges) == null ? void 0 : _a.filter((edge) => {
      if (relevantIds.some((id) => edge.fromNode == id))
        return true;
      if (relevantIds.some((id) => edge.toNode == id && edge.isBidirectional))
        return true;
      return false;
    });
    if ((relevantEdges == null ? void 0 : relevantEdges.length) === 0 && file.inGroups.length === 0) {
      this.propsOnCanvas = null;
      return;
    }
    let edges = relevantEdges == null ? void 0 : relevantEdges.map((edge) => {
      var _a2, _b, _c, _d;
      let newEdge = {
        otherSideId: edge.toNode,
        isBidirectional: edge.isBidirectional
      };
      if (file.id === newEdge.otherSideId)
        newEdge.otherSideId = edge.fromNode;
      newEdge.otherSide = (_a2 = data.cards) == null ? void 0 : _a2.find((card) => card.id === newEdge.otherSideId);
      newEdge.type = "card";
      newEdge.propLbl = settings.cardDefault;
      if (newEdge.otherSide === void 0) {
        newEdge.otherSide = (_b = data.urls) == null ? void 0 : _b.find((url) => url.id === newEdge.otherSideId);
        newEdge.type = "url";
        newEdge.propLbl = settings.urlDefault;
      }
      if (newEdge.otherSide === void 0) {
        newEdge.otherSide = (_c = data.files) == null ? void 0 : _c.find((file2) => file2.id === newEdge.otherSideId);
        newEdge.type = "file";
        newEdge.propLbl = settings.fileDefault;
      }
      if (newEdge.otherSide === void 0) {
        newEdge.otherSide = (_d = data.groups) == null ? void 0 : _d.find((group) => group.id === newEdge.otherSideId);
        newEdge.type = "group";
      }
      if (newEdge.otherSide === void 0)
        throw new Error("Could not find other side of edge");
      if (newEdge.type === "card")
        newEdge.propVal = newEdge.otherSide.text;
      if (newEdge.type === "url")
        newEdge.propVal = newEdge.otherSide.url;
      if (newEdge.type === "file")
        newEdge.propVal = convertToWikilink(newEdge.otherSide, this);
      if (edge.label !== void 0)
        newEdge.propLbl = edge.label;
      return newEdge;
    }).filter((newEdge) => newEdge.propLbl !== void 0 && newEdge.propLbl !== "");
    if (file.inGroups.length > 0 && settings.useGroups) {
      this.propsOnCanvas[settings.groupDefault] = file.inGroups.map((group) => group.label);
    }
    if (settings.useCards) {
      edges.filter((edge) => edge.type === "card").forEach((edge) => {
        if (!this.propsOnCanvas.hasOwnProperty(edge.propLbl)) {
          this.propsOnCanvas[edge.propLbl] = [edge.propVal];
          return;
        }
        this.propsOnCanvas[edge.propLbl].push(edge.propVal);
      });
    }
    if (settings.useUrls) {
      edges.filter((edge) => edge.type === "url").forEach((edge) => {
        if (!this.propsOnCanvas.hasOwnProperty(edge.propLbl)) {
          this.propsOnCanvas[edge.propLbl] = [edge.propVal];
          return;
        }
        this.propsOnCanvas[edge.propLbl].push(edge.propVal);
      });
    }
    if (settings.useFiles) {
      edges.filter((edge) => edge.type === "file").forEach((edge) => {
        if (!this.propsOnCanvas.hasOwnProperty(edge.propLbl)) {
          this.propsOnCanvas[edge.propLbl] = [edge.propVal];
          return;
        }
        this.propsOnCanvas[edge.propLbl].push(edge.propVal);
      });
    }
    function convertToWikilink(otherSide, that) {
      const otherFile = that.app.metadataCache.getFirstLinkpathDest(otherSide.file, that.filePath);
      let linkTextContent = that.app.metadataCache.fileToLinktext(otherFile, that.filePath);
      if (otherSide.hasOwnProperty("subpath"))
        linkTextContent = linkTextContent + otherSide.subpath;
      return "[[" + linkTextContent + "]]";
    }
  }
};

// main.ts
var Location = /* @__PURE__ */ ((Location2) => {
  Location2[Location2["VaultFolder"] = 0] = "VaultFolder";
  Location2[Location2["SameFolder"] = 1] = "SameFolder";
  Location2[Location2["SpecifiedFolder"] = 2] = "SpecifiedFolder";
  return Location2;
})(Location || {});
var DEFAULT_SETTINGS = {
  newFileLocation: 0 /* VaultFolder */,
  customFileLocation: "",
  // The default strings for unlabeled edges
  cardDefault: "cards",
  fileDefault: "files",
  urlDefault: "urls",
  // The string for group containment
  groupDefault: "groups",
  // For disabling whole types of interactions
  useCards: true,
  useUrls: true,
  useFiles: true,
  useGroups: false,
  excludeKeys: "alias,aliases,tags,cssClasses"
};
var SemanticCanvasPlugin = class extends import_obsidian.Plugin {
  async onload() {
    await this.loadSettings();
    this.addCommand({
      id: "set-canvas-to-note-properties",
      name: "Overwrite note properties based on canvas",
      callback: () => {
        this.pushCanvasDataToNotes(true);
      }
    });
    this.addCommand({
      id: "append-canvas-to-note-properties",
      name: "Append note properties based on canvas",
      callback: () => {
        this.pushCanvasDataToNotes(false);
      }
    });
    this.addCommand({
      id: "create-canvas-from-note",
      name: "Create canvas based on note",
      callback: () => {
        this.createCanvasFromNote();
      }
    });
    this.addSettingTab(new SemanticCanvasSettingsTab(this.app, this));
    this.registerEvent(
      //@ts-expect-error - it works, despite TypeScript not seeing the 'canvas:' methods
      this.app.workspace.on("canvas:edge-menu", (menu, edge) => {
        if (edge.label === "" || edge.toLineEnd === null || edge.from.node.filePath === void 0)
          return;
        const isBidirectional = edge.fromLineEnd !== null && edge.to.node.filePath !== void 0;
        menu.addSeparator();
        menu.addItem((item) => {
          item.setTitle(isBidirectional ? "Remove property from both notes" : "Remove property from source note").setIcon("list-minus").onClick(() => {
            const file = this.app.vault.getFileByPath(edge.from.node.filePath);
            if (file === null)
              return;
            this.app.fileManager.processFrontMatter(file, (frontmatter) => {
              frontmatter[edge.label] = void 0;
            });
            if (isBidirectional) {
              const otherFile = this.app.vault.getFileByPath(edge.to.node.filePath);
              if (otherFile === null)
                return;
              this.app.fileManager.processFrontMatter(otherFile, (frontmatter) => {
                frontmatter[edge.label] = void 0;
              });
            }
            if (isBidirectional)
              new import_obsidian.Notice(`Successfully removed prop in 2 files`);
            if (!isBidirectional)
              new import_obsidian.Notice(`Successfully removed prop in 1 file`);
          });
        });
        menu.addItem((item) => {
          item.setTitle(isBidirectional ? "Update property in both notes" : "Update property in source note").setIcon("list-restart").onClick(() => {
            let toVal = edge.to.node.text;
            if (toVal === void 0) {
              const filenameAsWikiLink = "[[" + edge.to.node.filePath.split("/").pop().substring(0, edge.to.node.filePath.split("/").pop().length - 3) + "]]";
              toVal = filenameAsWikiLink;
            }
            const file = this.app.vault.getFileByPath(edge.from.node.filePath);
            if (file === null)
              return;
            this.app.fileManager.processFrontMatter(file, (frontmatter) => {
              frontmatter[edge.label] = toVal;
            });
            if (isBidirectional) {
              let otherToVal = edge.from.node.text;
              if (otherToVal === void 0) {
                const filenameAsWikiLink = "[[" + edge.from.node.filePath.split("/").pop().substring(0, edge.from.node.filePath.split("/").pop().length - 3) + "]]";
                otherToVal = filenameAsWikiLink;
              }
              const otherFile = this.app.vault.getFileByPath(edge.to.node.filePath);
              if (otherFile === null)
                return;
              this.app.fileManager.processFrontMatter(otherFile, (frontmatter) => {
                frontmatter[edge.label] = otherToVal;
              });
            }
            if (isBidirectional)
              new import_obsidian.Notice(`Successfully set 2 props in 2 files`);
            if (!isBidirectional)
              new import_obsidian.Notice(`Successfully set 1 prop in 1 file`);
          });
        });
      })
    );
    this.registerEvent(
      //@ts-expect-error - it works, despite TypeScript not seeing the 'canvas:' methods
      this.app.workspace.on("canvas:node-connection-drop-menu", (menu, edge, third) => {
        if (edge.file === void 0)
          return;
        const noteProps = this.getNoteData(edge.file.path);
        noteProps.forEach((prop) => {
          menu.addItem((item) => {
            const key = Object.keys(prop)[0];
            item.setTitle("Property: " + key).setIcon("down-arrow").onClick(() => {
              var _a;
              const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
              if (activeView === null) {
                new import_obsidian.Notice("Aborted: Active view was null");
                return;
              }
              if (((_a = activeView == null ? void 0 : activeView.file) == null ? void 0 : _a.extension) !== "canvas") {
                new import_obsidian.Notice("Aborted: Active view is not a canvas");
                return;
              }
              this.addNodeDataAtLocation(activeView, prop[key], key, third.to.node.x, third.to.node.y, third.from.node);
            });
          });
        });
      })
    );
    this.registerEvent(
      //@ts-expect-error - it works, despite TypeScript not seeing the 'canvas:' methods
      this.app.workspace.on("canvas:node-menu", (menu, node) => {
        if (node.file === void 0)
          return;
        menu.addItem((item) => {
          item.setTitle("Pull note properties to canvas").setIcon("file-down").onClick(() => {
            const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
            if (!isValidActiveView(activeView))
              return;
            this.pullNotePropertiesToCanvas(activeView, [node], false);
          });
        });
        menu.addItem((item) => {
          item.setTitle("Show existing connections").setIcon("git-compare-arrows").onClick(() => {
            const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
            if (!isValidActiveView(activeView))
              return;
            this.pullNotePropertiesToCanvas(activeView, [node], true);
          });
        });
        menu.addItem((item) => {
          item.setTitle("Append properties in note").setIcon("list-plus").onClick(() => {
            const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
            if (!isValidActiveView(activeView))
              return;
            this.pushCanvasDataToNotes(false, activeView.file, node.file.path);
          });
        });
        menu.addItem((item) => {
          item.setTitle("Overwrite properties in note").setIcon("list-restart").onClick(() => {
            const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
            if (!isValidActiveView(activeView))
              return;
            this.pushCanvasDataToNotes(true, activeView.file, node.file.path);
          });
        });
        function isValidActiveView(activeView) {
          var _a;
          if (activeView === null) {
            new import_obsidian.Notice("Aborted: Active view was null");
            return false;
          }
          if (activeView.file === null) {
            new import_obsidian.Notice("Aborted: Active view has no file property");
            return false;
          }
          if (((_a = activeView == null ? void 0 : activeView.file) == null ? void 0 : _a.extension) !== "canvas") {
            new import_obsidian.Notice("Aborted: Active view is not a canvas");
            return false;
          }
          return true;
        }
      })
    );
    this.registerEvent(
      this.app.workspace.on("file-menu", (menu, file) => {
        var _a;
        const activeView = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
        if (file instanceof import_obsidian.TFolder || file === void 0)
          return;
        if (file.extension === "md" && ((_a = activeView == null ? void 0 : activeView.file) == null ? void 0 : _a.extension) !== "canvas") {
          menu.addItem((item) => {
            item.setTitle("Create canvas based on note").setIcon("square-plus").onClick(() => {
              this.createCanvasFromNote(file);
            });
          });
        }
        if (file.extension === "canvas") {
          menu.addItem((item) => {
            item.setTitle("Append note properties based on canvas").setIcon("list-plus").onClick(() => {
              this.pushCanvasDataToNotes(false, file);
            });
          });
          menu.addItem((item) => {
            item.setTitle("Overwrite note properties based on canvas").setIcon("list-restart").onClick(() => {
              this.pushCanvasDataToNotes(true, file);
            });
          });
          menu.addItem((item) => {
            item.setTitle("Pull in properies for all notes on this canvas").setIcon("file-down").onClick(() => {
              var _a2;
              const activeView2 = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
              if (activeView2 === null) {
                new import_obsidian.Notice("Aborted: Active view was null");
                return;
              }
              if (((_a2 = activeView2 == null ? void 0 : activeView2.file) == null ? void 0 : _a2.extension) !== "canvas") {
                new import_obsidian.Notice("Aborted: Active view is not a canvas");
                return;
              }
              const nodes = JSON.parse(activeView2.data)["nodes"].filter((node) => node.type === "file");
              this.pullNotePropertiesToCanvas(activeView2, nodes, false);
            });
          });
          menu.addItem((item) => {
            item.setTitle("Show all connections between notes on this canvas").setIcon("git-compare-arrows").onClick(() => {
              var _a2;
              const activeView2 = this.app.workspace.getActiveViewOfType(import_obsidian.TextFileView);
              if (activeView2 === null) {
                new import_obsidian.Notice("Aborted: Active view was null");
                return;
              }
              if (((_a2 = activeView2 == null ? void 0 : activeView2.file) == null ? void 0 : _a2.extension) !== "canvas") {
                new import_obsidian.Notice("Aborted: Active view is not a canvas");
                return;
              }
              const nodes = JSON.parse(activeView2.data)["nodes"].filter((node) => node.type === "file");
              this.pullNotePropertiesToCanvas(activeView2, nodes, true);
            });
          });
        }
      })
    );
  }
  /**
   * The main function for using a note to create a new canvas.
   */
  async createCanvasFromNote(file) {
    if (file === void 0)
      file = this.app.workspace.getActiveFile();
    if (!file || (file == null ? void 0 : file.extension) !== "md") {
      new import_obsidian.Notice("Aborted: Active file is not Markdown file");
      return;
    }
    const name = file.basename;
    new import_obsidian.Notice("Creating canvas for " + name);
    let listTypeProps = this.getNoteData(file.path);
    const that = this;
    const canvasContents = buildCanvasContents(file, listTypeProps);
    const savePath = createSavePathBasedOnSettings(file, that);
    const createdCanvas = await this.app.vault.create(savePath, JSON.stringify(canvasContents));
    this.app.workspace.getLeaf().openFile(createdCanvas);
    function buildCanvasContents(file2, propsMap) {
      const thisFileNodeData = {
        color: "1",
        x: 0,
        y: 0,
        id: "0",
        width: 400,
        height: 400,
        type: "file",
        file: file2.path
      };
      let canvasContents2 = {
        nodes: [thisFileNodeData],
        edges: []
      };
      if (propsMap.length === 0)
        return canvasContents2;
      const firstColumnPosition = 600;
      let curY = 0;
      let nodeCount = 1;
      let edgeCount = 0;
      propsMap.forEach((propObj) => {
        const key = Object.keys(propObj)[0];
        const valArr = propObj[key];
        if (!Array.isArray(valArr))
          throw new Error("A non-array was passed into buildCanvasContents");
        addEdge(key);
        if (SemanticCanvasPlugin.isGroup(valArr))
          return addGroup(key, valArr);
        const val = valArr[0];
        return addNode(val, firstColumnPosition);
      });
      thisFileNodeData.y = curY / 2 - thisFileNodeData.height / 2;
      return canvasContents2;
      function addEdge(label) {
        edgeCount = edgeCount + 1;
        canvasContents2.edges.push({
          id: edgeCount.toString(),
          fromNode: "0",
          fromSide: "right",
          toNode: (nodeCount + 1).toString(),
          toSide: "left",
          label
        });
      }
      function addNode(val, xPos) {
        nodeCount = nodeCount + 1;
        const newNode = {
          id: nodeCount.toString(),
          x: xPos.toString(),
          y: curY.toString()
        };
        if (SemanticCanvasPlugin.isFile(val)) {
          newNode.type = "file";
          newNode.file = val.substring(2, val.length - 2);
          newNode.width = 400;
          newNode.height = 400;
          if (that.app.vault.getAbstractFileByPath(newNode.file) === null) {
            const splitToBaseAndAlias = newNode.file.split("|");
            const base = splitToBaseAndAlias[0];
            const splitToPathAndSubpath = base.split("#");
            const path = splitToPathAndSubpath[0];
            if (splitToPathAndSubpath.length > 1)
              newNode.subpath = "#" + splitToPathAndSubpath[1];
            const foundFile = that.app.metadataCache.getFirstLinkpathDest(path, file2.path);
            if (foundFile !== null)
              newNode.file = foundFile.path;
          }
        } else if (SemanticCanvasPlugin.isURL(val)) {
          newNode.type = "link";
          newNode.url = val;
          newNode.width = 400;
          newNode.height = 400;
        } else {
          newNode.type = "text";
          newNode.text = val;
          newNode.width = val.length > 15 ? 400 : 200;
          newNode.height = val.length > 15 ? 200 : 100;
        }
        if (xPos === firstColumnPosition) {
          curY = curY + parseInt(newNode.height) + 50;
        }
        canvasContents2.nodes.push(newNode);
        return newNode;
      }
      function addGroup(key, valArr) {
        nodeCount = nodeCount + 1;
        const newGroup = {
          type: "group",
          id: nodeCount.toString(),
          x: firstColumnPosition,
          y: curY,
          label: key,
          width: 50,
          height: 50
        };
        let xPos = firstColumnPosition + 50;
        curY = curY + 50;
        valArr.forEach((val) => {
          let newNode = addNode(val, xPos);
          xPos = xPos + newNode.width + 50;
          newGroup.width = newGroup.width + newNode.width + 50;
          if (newNode.height + 100 > newGroup.height)
            newGroup.height = newNode.height + 100;
        });
        curY = curY + newGroup.height;
        canvasContents2.nodes.push(newGroup);
      }
    }
    function createSavePathBasedOnSettings(file2, that2) {
      let location = "";
      switch (that2.settings.newFileLocation) {
        case 1 /* SameFolder */:
          location = file2.parent.path;
          break;
        case 2 /* SpecifiedFolder */:
          const fileLocationExists = that2.app.vault.getAbstractFileByPath(that2.settings.customFileLocation) !== null;
          if (fileLocationExists) {
            location = that2.settings.customFileLocation;
          } else {
            new import_obsidian.Notice(
              `folder ${that2.settings.customFileLocation} does not exist, creating in root folder`
            );
          }
      }
      let canvasPath = name + ".canvas";
      if (location !== "")
        canvasPath = location + "/" + canvasPath;
      while (that2.app.vault.getAbstractFileByPath(canvasPath) !== null) {
        canvasPath = canvasPath.substring(0, canvasPath.length - 7) + " (new).canvas";
      }
      return canvasPath;
    }
  }
  /**
   * The main function for using an existing canvas to update note properties.
   * @param overwrite `true` will overwrite existing values for keys
   */
  async pushCanvasDataToNotes(overwrite, canvasFile, onlyUpdateNoteAtPath) {
    var _a;
    if (canvasFile === void 0)
      canvasFile = this.app.workspace.getActiveFile();
    if (!canvasFile || (canvasFile == null ? void 0 : canvasFile.extension) !== "canvas") {
      new import_obsidian.Notice("Aborted: Active file is not Canvas");
      return;
    }
    let data = await SemanticCanvasPlugin.getCanvasMap(canvasFile);
    if (!data) {
      new import_obsidian.Notice("Aborted: No Canvas data found");
      return;
    }
    let fileNodes = (_a = data == null ? void 0 : data.files) == null ? void 0 : _a.map((file) => new FileNode(file, data, this.settings, this.app));
    let dedupedFileNodes = [];
    fileNodes == null ? void 0 : fileNodes.forEach((fileNode) => {
      if (fileNode.propsOnCanvas === null)
        return;
      let existing = dedupedFileNodes == null ? void 0 : dedupedFileNodes.find((ogNodeList) => ogNodeList.filePath === fileNode.filePath);
      if (existing === void 0) {
        dedupedFileNodes.push(fileNode);
        return;
      }
      existing.propsOnCanvas = mergeProps(existing.propsOnCanvas, fileNode.propsOnCanvas);
    });
    dedupedFileNodes = dedupedFileNodes.filter((fileNode) => fileNode.propsOnCanvas && Object.keys(fileNode.propsOnCanvas).length > 0);
    let actualFilesMap = dedupedFileNodes.map((fileNode) => {
      const file = this.app.vault.getFileByPath(fileNode.filePath);
      if (file === null)
        throw new Error("No file found at path " + fileNode.filePath);
      return {
        file,
        props: fileNode.propsOnCanvas
      };
    });
    actualFilesMap = actualFilesMap.filter((fileMap) => {
      var _a2;
      return ((_a2 = fileMap.file) == null ? void 0 : _a2.extension) === "md";
    });
    if (onlyUpdateNoteAtPath !== void 0) {
      actualFilesMap = actualFilesMap.filter((fileMap) => fileMap.file.path === onlyUpdateNoteAtPath);
    }
    let propertyAddCount = 0;
    actualFilesMap.forEach((fileMap) => {
      if (fileMap.props === null)
        throw new Error("Cannot push canvas data to notes - fileMap.props was null");
      propertyAddCount = propertyAddCount + Object.keys(fileMap.props).length;
    });
    let modifiedFileCount = actualFilesMap.length;
    actualFilesMap.forEach((fileMap) => this.app.fileManager.processFrontMatter(fileMap.file, (frontmatter) => {
      Object.keys(fileMap.props).forEach((key) => {
        if (overwrite || !frontmatter.hasOwnProperty(key)) {
          frontmatter[key] = fileMap.props[key];
          return;
        }
        if (!Array.isArray(frontmatter[key]))
          frontmatter[key] = [frontmatter[key]];
        fileMap.props[key] = fileMap.props[key].filter((val) => !frontmatter[key].some((og) => og === val));
        frontmatter[key] = [...frontmatter[key], ...fileMap.props[key]];
      });
    }));
    if (modifiedFileCount > 0) {
      new import_obsidian.Notice(`Successfully set ${propertyAddCount} prop(s) in ${modifiedFileCount} file(s)`);
    } else {
      new import_obsidian.Notice(`No notes connections found on canvas.`);
    }
    function mergeProps(a, b) {
      Object.keys(b).forEach((key) => {
        if (a.hasOwnProperty(key)) {
          a[key] = [...a[key], ...b[key]];
        } else {
          a[key] = b[key];
        }
      });
      return a;
    }
  }
  /**
   * Creates a new node in the file represented inside the passed-in File view & saves it
   * @param text property value from the note
   * @param label the key the value has in the note
   * @param x where to put the new node
   * @param y where to put the new node
   */
  async addNodeDataAtLocation(fileView, textArr, label, x, y, fromNode) {
    if (fileView.file === null)
      throw new Error("fileView had no associated file");
    const visibleCanvasData = JSON.parse(fileView.data);
    const that = this;
    const newNodeOrGroup = makeNodeOrGroupOfNodesFor(textArr, label);
    visibleCanvasData.nodes.push(...newNodeOrGroup);
    const fromToSides = SemanticCanvasPlugin.determineSides(fromNode, newNodeOrGroup[0]);
    visibleCanvasData.edges.push({
      id: (Math.random() + 1).toString(36).substring(4),
      fromNode: fromNode.id,
      fromSide: fromToSides.from,
      toNode: newNodeOrGroup[0].id,
      toSide: fromToSides.to,
      label
    });
    this.app.vault.process(fileView.file, () => JSON.stringify(visibleCanvasData));
    function makeNodeOrGroupOfNodesFor(propVals, label2) {
      const returnObj = [];
      propVals.forEach((text) => {
        let newNode = {
          id: (Math.random() + 1).toString(36).substring(4),
          x: x - 100,
          y: y - 50 + 110 * returnObj.length,
          width: 200,
          height: 100
        };
        const isfile = SemanticCanvasPlugin.isFile(text);
        newNode.type = isfile ? "file" : "text";
        if (isfile) {
          const linkSansBrackets = text.substring(2, text.length - 2);
          const foundFile = that.app.metadataCache.getFirstLinkpathDest(linkSansBrackets, fileView.file.path);
          if (foundFile !== null) {
            newNode.file = foundFile.path;
          }
          if (foundFile === null) {
            newNode.type = "text";
            newNode.text = text;
          }
        }
        if (!isfile)
          newNode.text = text;
        returnObj.push(newNode);
      });
      if (propVals.length > 1) {
        let newNode = {
          id: (Math.random() + 1).toString(36).substring(4),
          x: x - 110,
          y: y - 60,
          width: 220,
          height: 10 + 110 * returnObj.length,
          type: "group",
          label: label2
        };
        returnObj.unshift(newNode);
      }
      return returnObj;
    }
  }
  /**
   * The main function for using an existing canvas to update note properties.
   * @param overwrite `true` will overwrite existing values for keys
   */
  async pullNotePropertiesToCanvas(fileView, nodesToPullFrom, existingOnly = false) {
    if (fileView.file === null)
      throw new Error("fileView had no associated file");
    const visibleCanvasData = JSON.parse(fileView.data);
    const canvasMap = await SemanticCanvasPlugin.getCanvasMap(fileView.file);
    if (canvasMap === void 0)
      throw new Error("Canvas Map was unable to be created");
    let connectionTargets = SemanticCanvasPlugin.buildConnectionTargets(canvasMap);
    let edgesToBuild = [];
    let nodesToBuild = [];
    nodesToPullFrom.forEach((node) => {
      let noteProps = this.getNoteData(typeof node.file === "string" ? node.file : node.file.path);
      noteProps.forEach((prop) => {
        const key = Object.keys(prop)[0];
        const vals = prop[key];
        vals.forEach((val) => {
          let connection = connectionTargets.find((target) => target.content === val || target.normalizedFileName && target.normalizedFileName === val);
          if (connection === void 0) {
            if (existingOnly)
              return;
            let newNode = {
              id: (Math.random() + 1).toString(36).substring(4),
              x: Number.parseFloat(node.x) + Number.parseFloat(node.width) + 20,
              y: Number.parseFloat(node.y) + (Number.parseFloat(node.height) + 20) * nodesToBuild.length,
              width: node.width,
              height: node.height,
              label: key
            };
            const isfile = SemanticCanvasPlugin.isFile(val);
            newNode.type = isfile ? "file" : "text";
            if (isfile) {
              const linkSansBrackets = val.substring(2, val.length - 2);
              const foundFile = this.app.metadataCache.getFirstLinkpathDest(linkSansBrackets, fileView.file.path);
              if (foundFile !== null)
                newNode.file = foundFile.path;
              if (foundFile === null) {
                newNode.type = "text";
                newNode.text = val;
              }
            }
            if (!isfile)
              newNode.text = val;
            nodesToBuild.push(newNode);
            edgesToBuild.push({
              id: (Math.random() + 1).toString(36).substring(4),
              fromNode: node.id,
              fromSide: "right",
              toNode: newNode.id,
              toSide: "left",
              label: key
            });
            return;
          }
          if (edgeAlreadyExists(node.id, connection.id, key))
            return;
          const fromToSides = SemanticCanvasPlugin.determineSides(node, connection);
          edgesToBuild.push({
            id: (Math.random() + 1).toString(36).substring(4),
            fromNode: node.id,
            fromSide: fromToSides.from,
            toNode: connection.id,
            toSide: fromToSides.to,
            label: key
          });
        });
      });
    });
    visibleCanvasData.edges.push(...edgesToBuild);
    visibleCanvasData.nodes.push(...nodesToBuild);
    this.app.vault.process(fileView.file, () => JSON.stringify(visibleCanvasData));
    return;
    function edgeAlreadyExists(fromId, toId, labeled) {
      return visibleCanvasData.edges.some((edge) => edge.fromNode === fromId && edge.toNode === toId && edge.label === labeled);
    }
  }
  /**
   * Gets the **list type** properties from the passed-in note file
   * @param file the path of the .md file to get properties from
   * @returns list-type properties map
   */
  getNoteData(filepath) {
    var _a;
    const allProperties = (_a = this.app.metadataCache.getCache(filepath)) == null ? void 0 : _a.frontmatter;
    let listTypeProps = [];
    const excludeKeys = this.settings.excludeKeys.split(",").map((key) => key.trim().toUpperCase());
    if (allProperties !== void 0) {
      Object.keys(allProperties).forEach((key) => {
        if (excludeKeys.some((exclusion) => exclusion === key.toUpperCase()))
          return;
        if (Array.isArray(allProperties[key]))
          listTypeProps.push({ [key]: allProperties[key] });
      });
    }
    return listTypeProps;
  }
  //#region --- Static Helper Methods
  /**
   * Creates a list of pre-existing things on a canvas that a hypothetical node
   * *could* link to if it's looking for links. 
   * Content is returned a key:value pair where the key is the node id 
   * and the value is a string-based representation of the content for comparison
   * @param nodes 
   */
  static buildConnectionTargets(nodes) {
    var _a, _b, _c;
    let returnArray = [];
    (_a = nodes.cards) == null ? void 0 : _a.forEach((card) => {
      returnArray.push({
        nodeType: "card",
        id: card.id,
        content: card.text,
        x: card.x,
        y: card.y,
        w: card.width,
        h: card.height
      });
    });
    (_b = nodes.files) == null ? void 0 : _b.forEach((file) => {
      const filename = file.file;
      const filenameAsWikiLink = "[[" + file.file.split("/").pop().substring(0, file.file.split("/").pop().length - 3) + "]]";
      returnArray.push({
        nodeType: "file",
        id: file.id,
        content: filename,
        normalizedFileName: filenameAsWikiLink,
        x: file.x,
        y: file.y,
        w: file.width,
        h: file.height
      });
    });
    (_c = nodes.urls) == null ? void 0 : _c.forEach((url) => {
      returnArray.push({
        nodeType: "url",
        id: url.id,
        content: url.url,
        x: url.x,
        y: url.y,
        w: url.width,
        h: url.height
      });
    });
    return returnArray;
  }
  static determineSides(fromNode, toNode) {
    let verticalDelta = fromNode.y - toNode.y;
    let horizontalDelta = fromNode.x - toNode.x;
    if (Math.abs(verticalDelta) > Math.abs(horizontalDelta)) {
      if (verticalDelta > 0)
        return { from: "top", to: "bottom" };
      return { from: "bottom", to: "top" };
    }
    if (horizontalDelta > 0)
      return { from: "left", to: "right" };
    return { from: "right", to: "left" };
  }
  static isGroup(val) {
    return val.length > 1;
  }
  static isFile(val) {
    if (val.substring(0, 2) !== "[[")
      return false;
    if (val.substring(val.length - 2) !== "]]")
      return false;
    if (val.split("[[").length !== 2)
      return false;
    return true;
  }
  static isURL(val) {
    if (val.toUpperCase().substring(0, 4) !== "HTTP")
      return false;
    if (!val.contains("//"))
      return false;
    if (val.length < 8)
      return false;
    return true;
  }
  static async getCanvasData(file) {
    if (file === null || file.extension !== "canvas")
      return;
    let rawCanvasText = await file.vault.cachedRead(file);
    let canvas = JSON.parse(rawCanvasText);
    return canvas;
  }
  static getCanvasNodes(data) {
    var _a;
    if (data === void 0)
      return void 0;
    let map = {
      cards: data.nodes.filter((node) => node.type == "text"),
      files: data.nodes.filter((node) => node.type == "file"),
      urls: data.nodes.filter((node) => node.type == "link"),
      groups: data.nodes.filter((node) => node.type == "group")
    };
    (_a = map.groups) == null ? void 0 : _a.forEach((group) => {
      var _a2, _b, _c;
      group.containedNodes = [];
      (_a2 = map.files) == null ? void 0 : _a2.forEach((file) => {
        if (groupContainsNode(group, file)) {
          group.containedNodes.push(file);
          if (file.hasOwnProperty("inGroups")) {
            file.inGroups.push(group);
          } else {
            file.inGroups = [group];
          }
        }
      });
      (_b = map.cards) == null ? void 0 : _b.forEach((cards) => {
        if (groupContainsNode(group, cards)) {
          group.containedNodes.push(cards);
        }
      });
      (_c = map.urls) == null ? void 0 : _c.forEach((urls) => {
        if (groupContainsNode(group, urls)) {
          group.containedNodes.push(urls);
        }
      });
    });
    function groupContainsNode(group, node) {
      if (group.y > node.y)
        return false;
      if (group.y + group.height < node.y + node.height)
        return false;
      if (group.x > node.x)
        return false;
      if (group.x + group.width < node.x + node.width)
        return false;
      return true;
    }
    return map;
  }
  static getCanvasEdges(data) {
    if (data === void 0)
      return void 0;
    data.edges.forEach((edge) => {
      edge.isBidirectional = edge.fromEnd === "arrow" || edge.toEnd === "none";
    });
    return data.edges;
  }
  static async getCanvasMap(file) {
    if (!file)
      return void 0;
    const canvasData = await SemanticCanvasPlugin.getCanvasData(file);
    if (!canvasData)
      return void 0;
    let map = SemanticCanvasPlugin.getCanvasNodes(canvasData);
    if (!map)
      return void 0;
    let edges = SemanticCanvasPlugin.getCanvasEdges(canvasData);
    map.edges = edges;
    edges == null ? void 0 : edges.forEach((edge) => {
      var _a;
      const toType = getTypeOfNodeById(edge.toNode);
      if (toType === "group") {
        let group = (_a = map == null ? void 0 : map.groups) == null ? void 0 : _a.find((g) => g.id === edge.toNode);
        if (!group)
          throw new Error("Unmatched group. ID: " + edge.toNode);
        makePhantomPropagatedEdgesToGroupContents(group, edge);
      }
    });
    return map;
    function getTypeOfNodeById(nodeId) {
      var _a, _b, _c, _d;
      if ((_a = map == null ? void 0 : map.cards) == null ? void 0 : _a.some((card) => card.id === nodeId))
        return "card";
      if ((_b = map == null ? void 0 : map.files) == null ? void 0 : _b.some((file2) => file2.id === nodeId))
        return "file";
      if ((_c = map == null ? void 0 : map.urls) == null ? void 0 : _c.some((url) => url.id === nodeId))
        return "url";
      if ((_d = map == null ? void 0 : map.groups) == null ? void 0 : _d.some((group) => group.id === nodeId))
        return "group";
      throw new Error("No type found for id: " + nodeId);
    }
    function makePhantomPropagatedEdgesToGroupContents(group, edge) {
      group.containedNodes.forEach((node) => {
        if (node.type === "group")
          return;
        const newEdge = {
          id: edge.id + "-phantom",
          fromNode: edge.fromNode,
          fromSide: "right",
          //doesn't matter
          toNode: node.id,
          toSide: "left",
          //doesn't matter
          label: edge.hasOwnProperty("label") ? edge.label : group.label
        };
        edges == null ? void 0 : edges.push(newEdge);
      });
    }
  }
  //#endregion
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
var SemanticCanvasSettingsTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h1", { text: "Note \u2192 create canvas" });
    new import_obsidian.Setting(containerEl).setName("Default location for new canvas files").addDropdown((dropDown) => {
      dropDown.addOption(Location[0 /* VaultFolder */], "Vault folder").addOption(
        Location[1 /* SameFolder */],
        "Same folder as current file"
      ).addOption(
        Location[2 /* SpecifiedFolder */],
        "In the folder specified below"
      ).setValue(
        Location[this.plugin.settings.newFileLocation] || Location[0 /* VaultFolder */]
      ).onChange(async (value) => {
        this.plugin.settings.newFileLocation = Location[value];
        await this.plugin.saveSettings();
        this.display();
      });
    });
    if (this.plugin.settings.newFileLocation == 2 /* SpecifiedFolder */) {
      new import_obsidian.Setting(containerEl).setName("Folder to create new canvas files in").addText((text) => {
        text.setPlaceholder("Example: folder 1/folder 2").setValue(this.plugin.settings.customFileLocation).onChange(async (value) => {
          this.plugin.settings.customFileLocation = value;
          await this.plugin.saveSettings();
        });
      });
    }
    new import_obsidian.Setting(containerEl).setName("Keys to ignore").setDesc(`A comma-separated list of property keys to ignore (case-insensitive).`).addTextArea((text) => {
      text.setValue(this.plugin.settings.excludeKeys).onChange(async (value) => {
        this.plugin.settings.excludeKeys = value;
        await this.plugin.saveSettings();
      });
    });
    containerEl.createEl("h1", { text: "Canvas \u2192 set note properties" });
    containerEl.createEl("h2", { text: "Toggle property setting per type" });
    new import_obsidian.Setting(containerEl).setName("Set note properties for connections to cards ").setDesc("Default: true").addToggle((toggle) => toggle.setValue(this.plugin.settings.useCards).onChange(async (value) => {
      this.plugin.settings.useCards = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Set note properties for connections to urls").setDesc("Default: true").addToggle((toggle) => toggle.setValue(this.plugin.settings.useUrls).onChange(async (value) => {
      this.plugin.settings.useUrls = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Set note properties for connections to files").setDesc("Default: true").addToggle((toggle) => toggle.setValue(this.plugin.settings.useFiles).onChange(async (value) => {
      this.plugin.settings.useFiles = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Set note properties based on containment in groups").setDesc("Default: false").addToggle((toggle) => toggle.setValue(this.plugin.settings.useGroups).onChange(async (value) => {
      this.plugin.settings.useGroups = value;
      await this.plugin.saveSettings();
    }));
    containerEl.createEl("h2", { text: "Default property keys for unlabeled connections" });
    new import_obsidian.Setting(containerEl).setName("Property key for unlabeled connections to: cards").setDesc("Leave blank to only create properties for labeled edges. Default: cards").addText((text) => text.setPlaceholder("Default cards key...").setValue(this.plugin.settings.cardDefault).onChange(async (value) => {
      this.plugin.settings.cardDefault = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Property key for unlabeled connections to: urls").setDesc("Leave blank to only create properties for labeled edges. Default: urls").addText((text) => text.setPlaceholder("Default urls key...").setValue(this.plugin.settings.urlDefault).onChange(async (value) => {
      this.plugin.settings.urlDefault = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Property key for unlabeled connections to: files").setDesc("Leave blank to only create properties for labeled edges. Default: files").addText((text) => text.setPlaceholder("Default files key...").setValue(this.plugin.settings.fileDefault).onChange(async (value) => {
      this.plugin.settings.fileDefault = value;
      await this.plugin.saveSettings();
    }));
    containerEl.createEl("h2", { text: "Property keys for group containment" });
    new import_obsidian.Setting(containerEl).setName("Property key for unlabeled groups").setDesc("Default: groups").addText((text) => text.setPlaceholder("Default groups key...").setValue(this.plugin.settings.groupDefault).onChange(async (value) => {
      this.plugin.settings.groupDefault = value;
      await this.plugin.saveSettings();
    }));
  }
};

/* nosourcemap */