/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => QuickTagPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian5 = require("obsidian");

// src/utilities.ts
var import_obsidian4 = require("obsidian");

// src/modal.ts
var import_obsidian = require("obsidian");

// src/constants.ts
var SPECIAL_COMMANDS = ["REMOVE ALL"];
var WOAH_LOTS_OF_FILES = 20;
var KNOWN_BAD_CHARACTERS = [
  "\u2012",
  "\u2013",
  "\u2014",
  "\u2015",
  "\u204F",
  "\u203D",
  "\u2018",
  "\u201A",
  "\u201B",
  "\u2039",
  "\u203A",
  "\u201C",
  "\u201D",
  "\u201E",
  "\u201F",
  "\u2045",
  "\u2046",
  "\u204B",
  "\u204E",
  "\u2051",
  "\u2044",
  "\u204A",
  "\u2030",
  "\u2031",
  "\u2052",
  "\u2020",
  "\u2021",
  "\u2022",
  "\u2023",
  "\u2043",
  "\u204C",
  "\u204D",
  "\u2032",
  "\u2035",
  "\u2038",
  "\u203B",
  "\u2050",
  "\u2041",
  "\u2042",
  "\u2016",
  "\u2011",
  "\u2033",
  "\u2034",
  "\u2057",
  "\u2036",
  "\u2037",
  "`",
  "^",
  "\u203E",
  "\u2017",
  "\u2053",
  ",",
  ";",
  ":",
  "!",
  "\u203C",
  "\u2049",
  "?",
  "\u2048",
  "\u2047",
  ".",
  "\u2024",
  "\u2025",
  "\u2026",
  "'",
  '"',
  "(",
  ")",
  "[",
  "]",
  "{",
  "}",
  "@",
  "*",
  "&",
  "%",
  "\u2054",
  "+",
  "<",
  "=",
  ">",
  "|",
  "~",
  "$",
  "\u2055",
  "\u2056",
  "\u2058",
  "\u2059",
  "\u205A",
  "\u205B",
  "\u205C",
  "\u205D",
  "\u205E",
  "\u2E00",
  "\u2E01",
  "\u2E02",
  "\u2E03",
  "\u2E04",
  "\u2E05",
  "\u2E06",
  "\u2E07",
  "\u2E08",
  "\u2E09",
  "\u2E0A",
  "\u2E0B",
  "\u2E0C",
  "\u2E0D",
  "\u2E0E",
  "\u2E0F",
  "\u2E10",
  "\u2E11",
  "\u2E12",
  "\u2E13",
  "\u2E14",
  "\u2E15",
  "\u2E16",
  "\u2E17",
  "\u2E1C",
  "\u2E1D",
  " ",
  "#"
];

// src/clean_inputs.ts
var modifier_map = {
  "none": null,
  "camelcase": camelCase,
  "pascalcase": titleCase,
  "snakecase": snakeCase,
  "kebabcase": kebabCase
};
function prep_clean_query(original_query, plugin) {
  let fixed_query = original_query;
  let setting_value = plugin.settings.preffered_casing;
  let modifier_func = modifier_map[setting_value];
  if (modifier_func) {
    fixed_query = modifier_func(fixed_query);
  }
  for (const index in KNOWN_BAD_CHARACTERS) {
    fixed_query = fixed_query.replaceAll(KNOWN_BAD_CHARACTERS[index], "");
  }
  return fixed_query;
}
function titleCase(str) {
  str = str.toLocaleLowerCase();
  let words = str.split(" ");
  for (let i = 0; i < words.length; i++) {
    words[i] = words[i].charAt(0).toUpperCase() + words[i].slice(1);
  }
  return words.join(" ");
}
function camelCase(str) {
  str = str.toLocaleLowerCase();
  let words = str.split(" ");
  for (let i = 0; i < words.length; i++) {
    if (i == 0) {
      continue;
    }
    words[i] = words[i].charAt(0).toUpperCase() + words[i].slice(1);
  }
  return words.join(" ");
}
function kebabCase(str) {
  str = str.replaceAll(" ", "-");
  while (str.contains("--")) {
    str.replace("--", "-");
  }
  return str;
}
function snakeCase(str) {
  str = str.replaceAll(" ", "_");
  while (str.contains("__")) {
    str.replace("__", "_");
  }
  return str;
}

// src/modal.ts
var QuickTagSelector = class extends import_obsidian.FuzzySuggestModal {
  constructor(plugin, gatherer, onChooseItemCallback, fileList) {
    super(plugin.app);
    this.plugin = plugin;
    this.gatherer = gatherer.retrieve_tags;
    this.settings = plugin.settings;
    this.fileList = fileList ? fileList : [];
    this.tag = "";
    this.onChooseItemCallback = onChooseItemCallback;
    this.inputListener = this.listenInput.bind(this);
    this.tagCache = [];
    this.new_tags_enabled = gatherer.get_new_tag_permission();
  }
  onOpen() {
    this.setPlaceholder("Select a tag");
    this.inputEl.addEventListener("keyup", this.inputListener);
    super.onOpen();
  }
  onClose() {
    this.inputEl.removeEventListener("keyup", this.inputListener);
    super.onClose();
  }
  listenInput(evt) {
    this.getSuggestions(this.inputEl.value);
  }
  getSuggestions(query) {
    let cleaned_query = prep_clean_query(query, this.plugin);
    let search = (0, import_obsidian.prepareFuzzySearch)(cleaned_query);
    let options = this.getItems();
    if (this.new_tags_enabled) {
      if (!/^[0-9]+$/.test(cleaned_query)) {
        options = options.concat(["#" + cleaned_query + " (new tag)"]);
      }
    }
    let result = [];
    for (const item in options) {
      const match = search(options[item]);
      if (match) {
        result.push({ "item": options[item], "match": match });
      }
    }
    return result;
  }
  getItems() {
    if (!this.gatherer) {
      new import_obsidian.Notice("Error: Could not find tags!");
      return [];
    }
    if (this.tagCache.length == 0) {
      this.tagCache = this.gatherer(this, this.fileList);
    }
    return this.tagCache;
  }
  getItemText(tag) {
    return tag;
  }
  async onChooseItem(result) {
    let cleaned_tag = SPECIAL_COMMANDS.includes(result) ? result : result.split(" ")[0];
    this.onChooseItemCallback(cleaned_tag);
  }
};
var ConfirmModal = class extends import_obsidian.Modal {
  constructor(thisApp, onSubmit, message) {
    super(thisApp);
    this.onSubmit = onSubmit;
    this.message = message;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", { text: this.message });
    new import_obsidian.Setting(contentEl).addButton((btn) => btn.setButtonText("Yes").setCta().onClick(() => {
      this.close();
      this.onSubmit(true);
    })).addButton((btn) => btn.setButtonText("No").setCta().onClick(() => {
      this.close();
      this.onSubmit(false);
    }));
  }
  async onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};

// src/tag_gatherers.ts
var import_obsidian2 = require("obsidian");
var BaseGatherer = class {
  constructor() {
    this._new_tag_permission = true;
  }
  enable_new_tag_permission() {
    this._new_tag_permission = true;
  }
  disable_new_tag_permission() {
    this._new_tag_permission = false;
  }
  get_new_tag_permission() {
    return this._new_tag_permission;
  }
};
var AddTagList = class extends BaseGatherer {
  retrieve_tags(plugin, fileList) {
    let tagSettings = _getStarredTags(plugin.settings, "cut_in_line");
    let tag_array = tagSettings.map((e) => e.replace("#", "")).filter((e) => e).map((e) => "#" + e);
    if (!plugin.settings.all_tags) {
      return tag_array;
    }
    let tag_cache = getTagsFromAppCache();
    tag_cache.sort();
    tag_cache.forEach((tag) => {
      if (tag_array.indexOf(tag) == -1) {
        tag_array.push(tag);
      }
    });
    return tag_array;
  }
};
var TagsOnFiles = class extends BaseGatherer {
  constructor() {
    super(...arguments);
    this._new_tag_permission = false;
  }
  retrieve_tags(plugin, fileList) {
    let tag_array = [];
    this.tag_map = {};
    fileList.forEach((f) => {
      let cache = plugin.app.metadataCache.getFileCache(f);
      if (cache) {
        let new_tags = (0, import_obsidian2.parseFrontMatterTags)(cache.frontmatter);
        if (new_tags) {
          new_tags.map((e) => e.replace("#", "")).filter((e) => e).map((e) => "#" + e);
          new_tags.forEach((item) => {
            if (!(item in this.tag_map)) {
              this.tag_map[item] = 0;
            }
            this.tag_map[item] += 1;
          });
        }
      }
    });
    for (const item in this.tag_map) {
      let quantity = this.tag_map[item];
      if (quantity > 1) {
        tag_array.push(item + " (" + this.tag_map[item].toString() + " notes)");
      } else {
        tag_array.push(item);
      }
    }
    tag_array.push("REMOVE ALL");
    return tag_array;
  }
};
var NonStarredTags = class extends BaseGatherer {
  constructor() {
    super(...arguments);
    this._new_tag_permission = false;
  }
  retrieve_tags(plugin) {
    let tag_array = getTagsFromAppCache();
    let starredTags = _getStarredTags(plugin.settings);
    starredTags.forEach((t) => tag_array.remove(t));
    tag_array.sort();
    return tag_array;
  }
};
function _getStarredTags(settings, filter_key) {
  let results = [];
  settings.priorityTags.forEach((t) => {
    if (filter_key) {
      t[filter_key] ? results.push(t.tag_value) : null;
    } else {
      results.push(t.tag_value);
    }
  });
  return results;
}
function getTagsFromAppCache() {
  let results = [];
  for (const key in this.app.metadataCache.getTags()) {
    results.push(key);
  }
  return results;
}

// src/file_filters.ts
var import_obsidian3 = require("obsidian");
function getFilteredWithTag(fileList, tag) {
  if (SPECIAL_COMMANDS.includes(tag)) {
    return fileList;
  }
  let resultList = fileList.filter((file) => filterTag(file, tag) == true);
  return resultList;
}
function getFilteredWithoutTag(fileList, tag) {
  if (SPECIAL_COMMANDS.includes(tag)) {
    return fileList;
  }
  let resultList = fileList.filter((file) => filterTag(file, tag) == false);
  return resultList;
}
function filterTag(thisFile, tag) {
  let cache = this.app.metadataCache.getFileCache(thisFile);
  let existing_tags = (0, import_obsidian3.parseFrontMatterTags)(cache.frontmatter);
  if (existing_tags == null ? void 0 : existing_tags.includes(tag)) {
    return true;
  } else {
    return false;
  }
}
function onlyTaggableFiles(fileList) {
  let resultList = fileList.filter((file) => (file.extension ? true : false) == true && file.extension == "md");
  return resultList;
}

// src/utilities.ts
var tag_key = "tags";
var tag_cleanup = ["tag", "Tag", "Tags"];
function _getActiveFile() {
  let thisFile = this.app.workspace.getActiveFile();
  if (thisFile instanceof import_obsidian4.TFile) {
    return [thisFile];
  } else {
    new import_obsidian4.Notice("No file open!");
    return [];
  }
}
async function _addTag(thisFile, tag) {
  this.tag = _formatHashTag(tag);
  await _cleanFile(thisFile);
  await this.app.fileManager.processFrontMatter(thisFile, _addFrontMatterTag.bind(this));
}
function _addFrontMatterTag(frontmatter) {
  frontmatter = _collectExistingTags(frontmatter);
  frontmatter[tag_key] = frontmatter[tag_key].map((t) => _formatHashTag(t));
  frontmatter[tag_key].push(this.tag);
}
async function _removeTag(thisFile, tag) {
  this.tag = _formatHashTag(tag);
  await _cleanFile(thisFile);
  let processor = _getRemovalProcessor(tag);
  await this.app.fileManager.processFrontMatter(thisFile, processor.bind(this));
}
function _getRemovalProcessor(tag) {
  if (tag != "REMOVE ALL") {
    return _removeFrontMatterTag;
  } else {
    console.log("removing all tags.....");
    return _removeAllFrontMatterTags;
  }
}
function _removeFrontMatterTag(frontmatter) {
  frontmatter = _collectExistingTags(frontmatter);
  let tags = frontmatter[tag_key];
  tags = tags.map((t) => _formatHashTag(t));
  let indx = tags.indexOf(this.tag, 0);
  if (indx > -1) {
    tags.splice(indx, 1);
  }
  frontmatter[tag_key] = tags;
}
function _removeAllFrontMatterTags(frontmatter) {
  frontmatter[tag_key] = [];
}
function _toggleTags(files, input_tag) {
  let tag = _formatHashTag(input_tag);
  let tag_added = 0;
  let tag_removed = 0;
  for (let i = 0; i < files.length; i++) {
    let exists = filterTag(files[i], `#${tag}`);
    if (!exists) {
      _addTag(files[i], tag);
      tag_added++;
    } else {
      _removeTag(files[i], tag);
      tag_removed++;
    }
  }
  return [tag_added, tag_removed];
}
async function _addTagToMany(files, tag, plugin) {
  console.log("ADDING TAGS");
  await _apply_bulk_changes(files, tag, plugin, _addTag);
}
async function _removeTagFromMany(files, tag, plugin) {
  console.log("REMOVING TAGS");
  await _apply_bulk_changes(files, tag, plugin, _removeTag);
}
async function _apply_bulk_changes(files, tag, plugin, func) {
  let status_bar = plugin.addStatusBarItem();
  status_bar.createEl("span");
  let useStatusBar = false;
  if (files.length > WOAH_LOTS_OF_FILES) {
    new import_obsidian4.Notice("Processing " + files.length + " files... This might take a while. See status bar for progress.");
    useStatusBar = true;
  }
  for (let i = 0; i < files.length; i++) {
    if (useStatusBar) {
      status_bar.setText(`Processing ${tag}: ${i + 1}/${files.length}`);
    }
    await func(files[i], tag);
  }
  status_bar.remove();
}
async function _cleanFile(f) {
  let text = await this.app.vault.read(f);
  let modified = _cleanNoteContent(text);
  if (modified) {
    console.log(`fixing up broken parts of ${f.basename}'s yaml...`);
    await this.app.vault.modify(f, text);
  }
}
function _cleanNoteContent(content) {
  let modified = false;
  if (content[0] == "\n") {
    while (content[0] == "\n") {
      content = content.slice(1);
    }
    modified = true;
  }
  if (content.indexOf("---\n") == 0) {
    let matches = content.match(/---\s*\n?/g);
    if (matches && matches[1] != "---\n" && matches[1] != "---") {
      content = content.replace(matches[1], "---\n");
      modified = true;
    }
  }
  if (modified) {
    return content;
  } else {
    return false;
  }
}
function _formatHashTag(tag) {
  return tag.replace("#", "");
}
function _collectExistingTags(yml) {
  if (!yml.hasOwnProperty(tag_key) || yml[tag_key] === null) {
    yml[tag_key] = [];
  } else {
    yml[tag_key] = _conformToArray(yml[tag_key]);
  }
  let alternate_keys = tag_cleanup.filter((v) => Object.keys(yml).includes(v));
  for (let i = 0; i < alternate_keys.length; i++) {
    let otherTags = _conformToArray(yml[alternate_keys[i]]);
    otherTags.forEach((tag) => {
      !yml[tag_key].includes(tag) ? yml[tag_key].push(tag) : console.log(tag + " already exists");
    });
    delete yml[alternate_keys[i]];
  }
  for (let i = 0; i < yml[tag_key].length; i++) {
    yml[tag_key][i] = _formatHashTag(yml[tag_key][i]);
  }
  return yml;
}
function _conformToArray(input) {
  let converted_array = typeof input === "string" ? input.split(",").map((e) => e.trim()) : input;
  let separated_array = [];
  converted_array.forEach((str) => separated_array.push(str.split(" ")));
  let output = separated_array.flat(Infinity);
  return output ? output : [];
}
function selectTag(plugin, gatherer, notes) {
  let active_gatherer = gatherer ? gatherer : new AddTagList();
  let active_notes = notes ? notes : [];
  return new Promise((resolve) => {
    new QuickTagSelector(plugin, active_gatherer, (result) => {
      resolve(result);
    }, active_notes).open();
  });
}
function confirmationNotification(mode, tag, applicableFiles) {
  let notes = applicableFiles.length > 1 ? applicableFiles.length + " notes" : applicableFiles[0].basename;
  let tofrom = mode == "add" ? " added to " : " removed from ";
  if (tag == "REMOVE ALL") {
    new import_obsidian4.Notice("All tags removed from " + notes);
  } else {
    new import_obsidian4.Notice(tag + tofrom + notes);
  }
}
function dynamicToggleCommand(plugin, StarredTag) {
  let tag = StarredTag.tag_value.replace("#", "");
  let commandId = `quick-add-tag:${tag}`;
  let fullId = `quick-tagger:${commandId}`;
  let state = false;
  if (plugin.app.commands.findCommand(fullId)) {
    delete plugin.app.commands.commands[fullId];
    delete plugin.app.commands.editorCommands[fullId];
  } else {
    plugin.addCommand({
      id: commandId,
      name: `Toggle #${tag}`,
      callback: () => {
        toggleTagOnActive(plugin, tag);
      }
    });
    state = true;
  }
  return state;
}
function dynamicAddMenuItems(menu, files, plugin) {
  let starredTags = plugin.settings.priorityTags;
  let singleFile = files.length == 1;
  let singleFileTags = [];
  if (singleFile) {
    let tmp_gatherer = new TagsOnFiles();
    singleFileTags = tmp_gatherer.retrieve_tags(plugin, files);
  }
  let operation = singleFile ? toggleTagOnFile : addTagsDirectly;
  starredTags.forEach((t) => {
    if (t.right_click) {
      menu.addItem((item) => {
        let title = `Tag with ${t.tag_value}`;
        if (singleFile) {
          let state = singleFileTags.includes(t.tag_value);
          title = state ? `Remove ${t.tag_value}` : `Add ${t.tag_value}`;
        }
        item.setTitle(title).setIcon("tag").onClick(async () => {
          operation(plugin, files, t.tag_value);
        });
      });
    }
  });
}
async function addDialogs(mode, tag, quantity) {
  let verb = mode;
  let tofrom = mode == "add" ? " to " : " from ";
  let confirm = true;
  if (tag == "REMOVE ALL") {
    let msg = "This will delete all tags on the active note(s), are you sure?";
    confirm = await adjust_tag_dialog(msg);
    verb = "";
  }
  if (!confirm) {
    return confirm;
  }
  if (quantity && quantity > 1) {
    let msg = "You are about to " + verb + " " + tag + tofrom + quantity + " notes, are you sure?";
    confirm = await adjust_tag_dialog(msg);
  }
  return confirm;
}
async function adjust_tag_dialog(msg) {
  let confirm = false;
  await new Promise((resolve) => {
    new ConfirmModal(this.app, (result) => resolve(confirm = result), msg).open();
  });
  return confirm;
}
async function addTagsWithModal(plugin, files) {
  let tag = await selectTag(plugin, new AddTagList(), files);
  addTagsDirectly(plugin, files, tag);
}
async function addTagWithModal(plugin) {
  let currentFile = _getActiveFile();
  addTagsWithModal(plugin, currentFile);
}
async function removeTagsWithModal(plugin, files) {
  let tag = await selectTag(plugin, new TagsOnFiles(), files);
  await removeTagsDirectly(plugin, files, tag);
}
async function removeTagWithModal(plugin) {
  let currentFile = _getActiveFile();
  await removeTagsWithModal(plugin, currentFile);
}
function toggleTagOnActive(plugin, tag) {
  let file = _getActiveFile();
  toggleTagOnFile(plugin, file, tag);
}
function toggleTagOnFile(plugin, file, tag) {
  update_last_used_tag(plugin, tag);
  let tag_added = _toggleTags(file, tag);
  tag_added[0] ? confirmationNotification("add", tag, file) : confirmationNotification("remove", tag, file);
}
async function addTagsDirectly(plugin, files, tag) {
  let applicableFiles = getFilteredWithoutTag(files, tag);
  if (applicableFiles.length == 0) {
    new import_obsidian4.Notice("No file tags to change!");
    return;
  }
  let confirm = await addDialogs("add", tag, files.length);
  if (confirm) {
    update_last_used_tag(plugin, tag);
    await _addTagToMany(applicableFiles, tag.replace("#", ""), plugin).then(
      () => confirmationNotification("add", tag, applicableFiles)
    );
  }
}
async function removeTagsDirectly(plugin, files, tag) {
  let applicableFiles = getFilteredWithTag(files, tag);
  if (applicableFiles.length == 0) {
    new import_obsidian4.Notice("No file tags to change!");
    return;
  }
  let confirm = await addDialogs("remove", tag, applicableFiles.length);
  if (confirm) {
    update_last_used_tag(plugin, tag);
    await _removeTagFromMany(applicableFiles, tag.replace("#", ""), plugin).then(
      () => confirmationNotification("remove", tag, applicableFiles)
    );
  }
}
async function update_last_used_tag(plugin, tag) {
  plugin.settings.last_used_tag = tag;
  await plugin.saveSettings();
  let commandId = "repeat-last-tag";
  if (plugin.app.commands.findCommand(commandId)) {
    delete plugin.app.commands.commands[commandId];
    delete plugin.app.commands.editorCommands[commandId];
  }
  plugin.addCommand({
    id: commandId,
    name: `Toggle recently used tag (${tag})`,
    callback: () => {
      toggleTagOnActive(plugin, tag);
    }
  });
}

// src/main.ts
var DEFAULT_SETTINGS = {
  all_tags: true,
  preffered_casing: "None",
  priorityTags: [],
  last_used_tag: ""
};
var QuickTagPlugin = class extends import_obsidian5.Plugin {
  async onload() {
    await this.loadSettings();
    let starredTags = this.settings.priorityTags;
    starredTags.forEach((t) => {
      if (t.add_command) {
        dynamicToggleCommand(this, t);
      }
    });
    this._statusBarItem = new Array();
    this.redrawButtons();
    const addTagRibbonIcon = this.addRibbonIcon("tag", "Add tag to current note", async (evt) => {
      addTagWithModal(this);
    });
    const removeTagRibbonIcon = this.addRibbonIcon("x-square", "Remove tag from current note", (evt) => {
      removeTagWithModal(this);
    });
    this.addCommand({
      id: "quick-add-tag",
      name: "Add tag",
      callback: () => {
        addTagWithModal(this);
      }
    });
    this.addCommand({
      id: "quick-remove-tag",
      name: "Remove tag",
      callback: () => {
        removeTagWithModal(this);
      }
    });
    this.addCommand({
      id: "repeat-last-tag",
      name: `Toggle recently used tag (none)`,
      callback: () => {
        new import_obsidian5.Notice("ERROR: No recent tag, please assign a tag with Quick Tagger before using this command");
      }
    });
    this.registerEvent(
      this.app.workspace.on("files-menu", (menu, files) => {
        files = onlyTaggableFiles(files);
        if (files.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Tag " + files.length + " files with...").setIcon("tag").onClick(() => {
            addTagsWithModal(this, files);
          });
        });
      })
    );
    this.registerEvent(
      this.app.workspace.on("files-menu", (menu, files) => {
        if (files.length < 1) {
          return;
        }
        dynamicAddMenuItems(menu, files, this);
      })
    );
    this.registerEvent(
      this.app.workspace.on("files-menu", (menu, files) => {
        files = onlyTaggableFiles(files);
        if (files.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Remove Tag from " + files.length + " files...").setIcon("tag").onClick(() => {
            removeTagsWithModal(this, files);
          });
        });
      })
    );
    this.registerEvent(
      this.app.workspace.on("file-menu", (menu, file) => {
        let thisFile = onlyTaggableFiles([file]);
        if (thisFile.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Tag file with...").setIcon("tag").onClick(() => {
            addTagsWithModal(this, thisFile);
          });
        });
      })
    );
    this.registerEvent(
      this.app.workspace.on("file-menu", (menu, file) => {
        let thisFile = onlyTaggableFiles([file]);
        if (thisFile.length < 1) {
          return;
        }
        dynamicAddMenuItems(menu, thisFile, this);
      })
    );
    this.registerEvent(
      this.app.workspace.on("file-menu", (menu, file) => {
        let thisFile = onlyTaggableFiles([file]);
        if (thisFile.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Remove Tag(s)...").setIcon("tag").onClick(() => {
            removeTagsWithModal(this, thisFile);
          });
        });
      })
    );
    this.registerEvent(
      this.app.workspace.on("search:results-menu", (menu, leaf) => {
        let files = [];
        leaf.dom.vChildren.children.forEach((e) => files.push(e.file));
        files = onlyTaggableFiles(files);
        if (files.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Add Tag to " + files.length + " notes...").setIcon("tag").onClick(() => {
            addTagsWithModal(this, files);
          });
        });
      })
    );
    this.registerEvent(
      this.app.workspace.on("search:results-menu", (menu, leaf) => {
        let files = [];
        leaf.dom.vChildren.children.forEach((e) => files.push(e.file));
        files = onlyTaggableFiles(files);
        if (files.length < 1) {
          return;
        }
        dynamicAddMenuItems(menu, files, this);
      })
    );
    this.registerEvent(
      this.app.workspace.on("search:results-menu", (menu, leaf) => {
        let files = [];
        leaf.dom.vChildren.children.forEach((e) => files.push(e.file));
        files = onlyTaggableFiles(files);
        if (files.length < 1) {
          return;
        }
        menu.addItem((item) => {
          item.setTitle("Remove Tags from " + files.length + " notes...").setIcon("tag").onClick(() => {
            removeTagsWithModal(this, files);
          });
        });
      })
    );
    this.addSettingTab(new QuickTagSettingTab(this));
  }
  async onunload() {
    this.settings.last_used_tag = "";
    await this.saveSettings();
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
  redrawButtons() {
    if (this._statusBarItem) {
      this._statusBarItem.forEach((t) => t.remove());
    }
    let starredTags = this.settings.priorityTags;
    starredTags.forEach(
      (t) => {
        if (t.status_bar) {
          let item_to_add = this.addStatusBarItem();
          this._statusBarItem.push(item_to_add);
          item_to_add.classList.add("mod-clickable");
          item_to_add.setText(t.tag_value);
          item_to_add.setAttribute("aria-label", `Toggle #${t.tag_value} on active note`);
          item_to_add.setAttribute("aria-label-position", "top");
          item_to_add.addEventListener("click", async () => {
            toggleTagOnActive(this, t.tag_value);
          });
        }
      }
    );
  }
};
var QuickTagSettingTab = class extends import_obsidian5.PluginSettingTab {
  constructor(plugin) {
    super(plugin.app, plugin);
    this.app = plugin.app;
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian5.Setting(containerEl).setName("Use all tags").setDesc("If disabled, only Starred Tags will be shown in the tag selection dialog.").addToggle((toggle) => toggle.setValue(this.plugin.settings.all_tags).onChange(async (value) => {
      this.plugin.settings.all_tags = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Preferred tag case").setDesc('Helper to replace spaces in input with a preffered tag style. "None" will just remove invalid characters.').addDropdown((dropdown) => dropdown.addOption("none", "None").addOption("camelcase", "applyCamelCase").addOption("pascalcase", "ApplyPascalCase").addOption("snakecase", "apply_snake_case").addOption("kebabcase", "apply-kebab-case").setValue(this.plugin.settings.preffered_casing).onChange(async (value) => {
      this.plugin.settings.preffered_casing = value;
      await this.plugin.saveSettings();
    }));
    containerEl.createEl("h1", { text: "Starred tags" });
    containerEl.createEl("h2", "hello");
    const starredDiv = containerEl.createDiv();
    this.drawPriorityTags(starredDiv);
    new import_obsidian5.Setting(containerEl).addButton((btn) => btn.setTooltip("Add a starred tag").onClick(async () => {
      let thisTag = await selectTag(this.plugin, new NonStarredTags());
      this.plugin.settings.priorityTags.push({
        tag_value: thisTag,
        cut_in_line: true,
        add_command: false,
        status_bar: false,
        right_click: false
      });
      await this.plugin.saveSettings();
      this.drawPriorityTags(starredDiv);
    }).setIcon("plus"));
  }
  drawPriorityTags(div) {
    div.empty();
    const priorityTags = this.plugin.settings.priorityTags;
    new import_obsidian5.Setting(div).addButton((btn) => {
      btn.setIcon("star");
      let msg = "The first toggle on a starred tag moves it to the top of the list when selecting a tag for your notes.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("chevron-right-square");
      let msg = "The second toggle on a starred tag adds a command for it so you can create a hotkey, etc.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("martini");
      let msg = "The third toggle on a starred tag adds a button for it to the status bar.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("mouse-pointer-click");
      let msg = "The fourth toggle on a starred tag adds it to the context menu.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("up-arrow-with-tail");
      let msg = "The up arrow button moves the starred tag up on the starred tag list. This affects the order it's displayed in the tag selection dialog.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("down-arrow-with-tail");
      let msg = "The down arrow button moves the starred tag down on the starred tag list. This affects the order it's displayed in the tag selection dialog.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).addButton((btn) => {
      btn.setIcon("trash");
      let msg = "The trash can button removes the starred tag from the starred list.";
      btn.onClick(() => new import_obsidian5.Notice(msg, 6e3));
      btn.setTooltip(msg);
    }).nameEl.setText("Starred tags get special treatment. Click or hover over these buttons for more details \u{1F449}");
    priorityTags.forEach((tag, i) => {
      const s = new import_obsidian5.Setting(div).addToggle((toggle) => {
        toggle.setValue(tag.cut_in_line).onChange(async (value) => {
          tag.cut_in_line = value;
          await this.plugin.saveSettings();
          new import_obsidian5.Notice(tag.cut_in_line ? `Added ${tag.tag_value} to priority section of selector dialog` : `Removed ${tag.tag_value} from priority section of selector dialog`);
        });
        toggle.setTooltip("Show first in tag selection dialog");
      }).addToggle((toggle) => {
        toggle.setValue(tag.add_command).onChange(async (value) => {
          tag.add_command = value;
          await this.plugin.saveSettings();
          dynamicToggleCommand(this.plugin, tag);
          new import_obsidian5.Notice(tag.add_command ? `Added ${tag.tag_value} command` : `Removed ${tag.tag_value} command`);
        });
        toggle.setTooltip("Add command for this tag");
      }).addToggle((toggle) => {
        toggle.setValue(tag.status_bar).onChange(async (value) => {
          tag.status_bar = value;
          await this.plugin.saveSettings();
          new import_obsidian5.Notice(tag.status_bar ? `Added ${tag.tag_value} button to status bar` : `Removed ${tag.tag_value} button from status bar`);
          this.plugin.redrawButtons();
        });
        toggle.setTooltip("Add button to status bar");
      }).addToggle((toggle) => {
        toggle.setValue(tag.right_click).onChange(async (value) => {
          tag.right_click = value;
          await this.plugin.saveSettings();
          new import_obsidian5.Notice(tag.right_click ? `Added ${tag.tag_value} to right-click menu` : `Removed ${tag.tag_value} from right-click menu`);
        });
        toggle.setTooltip("Add context menu entry");
      }).addButton((button) => {
        button.onClick(async () => {
          const oldTag = priorityTags[i - 1];
          priorityTags[i - 1] = tag;
          priorityTags[i] = oldTag;
          this.drawPriorityTags(div);
          await this.plugin.saveSettings();
          this.plugin.redrawButtons();
        });
        button.setIcon("up-arrow-with-tail");
        button.setTooltip("Move Starred tag up");
        if (i === 0) {
          button.setDisabled(true);
        }
      }).addButton((button) => {
        button.onClick(async () => {
          const oldTag = priorityTags[i + 1];
          priorityTags[i + 1] = tag;
          priorityTags[i] = oldTag;
          this.drawPriorityTags(div);
          await this.plugin.saveSettings();
          this.plugin.redrawButtons();
        });
        button.setIcon("down-arrow-with-tail");
        button.setTooltip("Move Starred tag down");
        if (i === priorityTags.length - 1) {
          button.setDisabled(true);
        }
      }).addButton((btn) => {
        btn.onClick(async () => {
          priorityTags.remove(tag);
          await this.plugin.saveSettings();
          this.drawPriorityTags(div);
        });
        btn.setIcon("trash");
        btn.setTooltip("Remove this tag");
      });
      s.nameEl.createEl("div", { text: tag.tag_value });
    });
  }
};
//# sourceMappingURL=data:application/json;base64,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
