/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => PythonScripterPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian = require("obsidian");
var path = __toESM(require("path"));
var fs = __toESM(require("fs"));
var import_child_process = require("child_process");
var DEFAULT_SETTINGS = {
  pythonPath: "",
  pythonExe: "",
  pythonIndividualExes: {},
  passVaultPath: {},
  passCurrentFile: {},
  additionalArgs: {},
  dotFiles: {}
  // useLastFile: false
};
var PythonScripterPlugin = class extends import_obsidian.Plugin {
  getBasePath() {
    let basePath;
    if (this.app.vault.adapter instanceof import_obsidian.FileSystemAdapter) {
      basePath = this.app.vault.adapter.getBasePath();
    } else {
      throw new Error("Cannot determine base path.");
    }
    return `${basePath}`;
  }
  async onload() {
    await this.loadSettings();
    var basePath = this.getBasePath();
    var defaultRelativePath = path.join(".", this.app.vault.configDir, "scripts", "python");
    this.pythonDirectory = path.join(basePath, defaultRelativePath);
    this.pythonDirectoryRelative = defaultRelativePath;
    if (this.settings.pythonPath != "") {
      this.pythonDirectory = path.join(basePath, this.settings.pythonPath);
      this.pythonDirectoryRelative = this.settings.pythonPath;
    } else {
      this.pythonDirectory = path.join(basePath, defaultRelativePath);
      this.pythonDirectoryRelative = defaultRelativePath;
    }
    try {
      await this.app.vault.createFolder(this.pythonDirectoryRelative);
    } catch (error) {
    }
    var files = fs.readdirSync(this.pythonDirectory);
    for (var index = 0; index < files.length; index++) {
      const filePath = path.join(this.pythonDirectory, files[index]);
      const fileName = files[index];
      const basePath2 = this.getBasePath();
      const obsidianCommand = {
        id: "run-" + files[index],
        name: "Run " + files[index],
        callback: () => {
          fs.stat(filePath, (err, stats) => {
            var _a, _b;
            if (err) {
              console.error(err);
              return;
            }
            let dot_files = this.settings.dotFiles[fileName];
            if (dot_files != void 0 && !path.isAbsolute(dot_files)) {
              dot_files = path.join(basePath2, dot_files);
            }
            if (fileName in this.settings.dotFiles) {
              if (!fs.existsSync(dot_files)) {
                new import_obsidian.Notice(`Error: ${dot_files} does not exist`);
                console.log(`Error: ${dot_files} does not exist`);
                return;
              }
              let dotFile = fs.readFileSync(dot_files, "utf8");
              let lines = dotFile.split("\n");
              for (var i = 0; i < lines.length; i++) {
                let line = lines[i].split("=");
                if (line.length == 2) {
                  process.env[line[0]] = line[1];
                }
              }
            }
            let python_exe = "";
            if (this.settings.pythonExe != "") {
              python_exe = this.settings.pythonExe;
            } else {
              python_exe = "python";
            }
            if (fileName in this.settings.pythonIndividualExes) {
              python_exe = this.settings.pythonIndividualExes[fileName];
              if (!fs.existsSync(this.settings.pythonIndividualExes[fileName])) {
                new import_obsidian.Notice(`Python Exe: ${this.settings.pythonIndividualExes[fileName]} for ${fileName} does not exist`);
                console.log(`Python Exe: ${this.settings.pythonIndividualExes[fileName]} for ${fileName} does not exist`);
                return;
              }
            }
            console.log(`Python Exe: ${python_exe}`);
            let main_file = "";
            if (stats.isFile()) {
              main_file = filePath;
            } else if (stats.isDirectory()) {
              main_file = path.join(filePath, "src", "main.py");
            } else {
              new import_obsidian.Notice(`Error: ${filePath} is not a file or directory`);
              console.log(`Error: ${filePath} is not a file or directory`);
              return;
            }
            let get_vault_path = true;
            let get_file_path = true;
            if (this.settings.passVaultPath[fileName] === void 0) {
              this.settings.passVaultPath[fileName] = true;
              get_vault_path = true;
              this.saveSettings();
            }
            if (this.settings.passCurrentFile[fileName] === void 0) {
              this.settings.passCurrentFile[fileName] = true;
              get_file_path = true;
              this.saveSettings();
            }
            var args = [];
            if (get_vault_path) {
              args.push(basePath2);
            }
            if (get_file_path) {
              var local_current_file_path = (_b = (_a = this.app.workspace.getActiveFile()) == null ? void 0 : _a.path) == null ? void 0 : _b.toString();
              if (!(local_current_file_path === void 0)) {
                args.push(local_current_file_path);
              } else {
                args.push("");
              }
            }
            if (this.settings.additionalArgs[fileName] === void 0) {
              this.settings.additionalArgs[fileName] = [];
            }
            for (var i = 0; i < this.settings.additionalArgs[fileName].length; i++) {
              args.push(this.settings.additionalArgs[fileName][i]);
            }
            let command = `${python_exe} "${main_file}"`;
            for (var i = 0; i < args.length; i++) {
              command += ` "${args[i]}"`;
            }
            (0, import_child_process.exec)(command, { cwd: this.pythonDirectory }, (error, stdout, stderr) => {
              if (error) {
                new import_obsidian.Notice(`Error executing script ${filePath}: ${error}`);
                console.log(`Error executing script ${filePath}: ${error}`);
                return;
              }
              new import_obsidian.Notice(`Script ` + fileName + ` output:
${stdout}`);
              console.log(`Script ` + fileName + ` output:
${stdout}`);
            });
          });
        }
      };
      this.addCommand(obsidianCommand);
    }
    this.addSettingTab(new PythonScripterSettingTab(this.app, this, files));
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
var PythonScripterSettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin, files) {
    super(app, plugin);
    this.plugin = plugin;
    this.files = files;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    this.containerEl.createEl("h1", { text: `Default Behavior` });
    new import_obsidian.Setting(containerEl).setName("Python Script Path").setDesc("Defaults to .obsidian\\scripts\\python").addText((text) => text.setPlaceholder("Enter path").setValue(this.plugin.settings.pythonPath).onChange(async (value) => {
      this.plugin.settings.pythonPath = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Default Python Executable").setDesc("Defaults to python").addText((text) => text.setPlaceholder("Enter path or command").setValue(this.plugin.settings.pythonExe).onChange(async (value) => {
      this.plugin.settings.pythonExe = value;
      await this.plugin.saveSettings();
    }));
    this.containerEl.createEl("h1", { text: `Scripts` });
    this.containerEl.createEl("p", { text: `Use the following areas to set settings per script, paths provided may either be absolute or relative to the vault path.` });
    for (var index = 0; index < this.files.length; index++) {
      let file = this.files[index];
      if (!(file in this.plugin.settings.passVaultPath)) {
        this.plugin.settings.passVaultPath[file] = true;
      }
      if (!(file in this.plugin.settings.passCurrentFile)) {
        this.plugin.settings.passCurrentFile[file] = true;
      }
      this.containerEl.createEl("h2", { text: `${file}` });
      new import_obsidian.Setting(containerEl).setName(`${file} Python Executable`).setDesc(`Overides the default python executable for ${file}`).addTextArea((area) => {
        area.setValue(this.plugin.settings.pythonIndividualExes[file]).onChange(async (value) => {
          this.plugin.settings.pythonIndividualExes[file] = value;
          await this.plugin.saveSettings();
        });
      });
      new import_obsidian.Setting(containerEl).setName(`${file} .env File`).setDesc(`Provides Runtime Environment Variables for ${file}`).addTextArea((area) => {
        area.setValue(this.plugin.settings.dotFiles[file]).onChange(async (value) => {
          this.plugin.settings.dotFiles[file] = value;
          await this.plugin.saveSettings();
        });
      });
      new import_obsidian.Setting(containerEl).setName(`Pass Vault Path`).setDesc(`Whether to pass the vault path to ${file}`).addToggle((area) => {
        area.setValue(this.plugin.settings.passVaultPath[file]).onChange(async (value) => {
          this.plugin.settings.passVaultPath[file] = value;
          await this.plugin.saveSettings();
          this.display();
        });
      });
      new import_obsidian.Setting(containerEl).setName(`Pass Active File Path`).setDesc(`Whether to pass the active file path to  to ${file}`).addToggle((area) => {
        area.setValue(this.plugin.settings.passCurrentFile[file]).onChange(async (value) => {
          this.plugin.settings.passCurrentFile[file] = value;
          await this.plugin.saveSettings();
          this.display();
        });
      });
      this.containerEl.createEl("h3", { text: `Arguments` });
      new import_obsidian.Setting(containerEl).setName(`Add Argument`).setDesc(``).addButton((area) => {
        area.onClick(async (value) => {
          this.plugin.settings.additionalArgs[file].push("");
          await this.plugin.saveSettings();
          this.display();
        }).setIcon("plus");
      });
      new import_obsidian.Setting(containerEl).setName(`Remove Argument`).setDesc(``).addButton((area) => {
        area.onClick(async (value) => {
          this.plugin.settings.additionalArgs[file].pop();
          await this.plugin.saveSettings();
          this.display();
        }).setIcon("minus");
      });
      if (!(file in this.plugin.settings.additionalArgs)) {
        this.plugin.settings.additionalArgs[file] = [];
      }
      if (this.plugin.settings.passVaultPath[file] && this.plugin.settings.passCurrentFile[file]) {
        new import_obsidian.Setting(containerEl).setName(`Arg 1`).addText((area) => {
          area.setValue("[vault path]").setPlaceholder("[vault path]").setDisabled(true);
        });
        new import_obsidian.Setting(containerEl).setName(`Arg 2`).addText((area) => {
          area.setValue("[active file]").setPlaceholder("[active file]").setDisabled(true);
        });
        for (var i = 0; i < this.plugin.settings.additionalArgs[file].length; i++) {
          new import_obsidian.Setting(containerEl).setName(`Arg ${i + 3}`).addText((area) => {
            area.setPlaceholder("Enter argument").setValue(this.plugin.settings.additionalArgs[file][i]).onChange(async (value) => {
              this.plugin.settings.additionalArgs[file][i] = value;
              await this.plugin.saveSettings();
            });
          });
        }
      } else if (this.plugin.settings.passVaultPath[file] && !this.plugin.settings.passCurrentFile[file]) {
        new import_obsidian.Setting(containerEl).setName(`Arg 1`).addText((area) => {
          area.setValue("[vault path]").setPlaceholder("[vault path]").setDisabled(true);
        });
        for (var i = 0; i < this.plugin.settings.additionalArgs[file].length; i++) {
          new import_obsidian.Setting(containerEl).setName(`Arg ${i + 2}`).addText((area) => {
            area.setPlaceholder("Enter argument").setValue(this.plugin.settings.additionalArgs[file][i]).onChange(async (value) => {
              this.plugin.settings.additionalArgs[file][i] = value;
              await this.plugin.saveSettings();
            });
          });
        }
      } else if (!this.plugin.settings.passVaultPath[file] && this.plugin.settings.passCurrentFile[file]) {
        new import_obsidian.Setting(containerEl).setName(`Arg 1`).addText((area) => {
          area.setValue("[active file]").setPlaceholder("[active file]").setDisabled(true);
        });
        for (var i = 0; i < this.plugin.settings.additionalArgs[file].length; i++) {
          new import_obsidian.Setting(containerEl).setName(`Arg ${i + 2}`).addText((area) => {
            area.setPlaceholder("Enter argument").setValue(this.plugin.settings.additionalArgs[file][i]).onChange(async (value) => {
              this.plugin.settings.additionalArgs[file][i] = value;
              await this.plugin.saveSettings();
            });
          });
        }
      } else {
        for (var i = 0; i < this.plugin.settings.additionalArgs[file].length; i++) {
          new import_obsidian.Setting(containerEl).setName(`Arg ${i + 1}`).addText((area) => {
            area.setPlaceholder("Enter argument").setValue(this.plugin.settings.additionalArgs[file][i]).onChange(async (value) => {
              this.plugin.settings.additionalArgs[file][i] = value;
              await this.plugin.saveSettings();
            });
          });
        }
      }
    }
  }
};
//# sourceMappingURL=data:application/json;base64,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
