/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

'use strict';

var obsidian = require('obsidian');

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

const labeledRegex = /^[ \t]*date:(.+?)(?:^[ \t]*title:(.+?))?(?:^[ \t]*content:(.+?))?(?=^[ \t]*date:)/gimsu;
const timelineLabeledParser = (source) => {
    source += "\ndate: ";
    let sourceMatch;
    const parsed = [];
    while ((sourceMatch = labeledRegex.exec(source)) !== null) {
        parsed.push({
            time: sourceMatch[1],
            title: sourceMatch[2],
            description: sourceMatch[3]
        });
    }
    return parsed;
};
const timelineParser = (source) => {
    const sourceSplitted = source.split(/^\s*\+ ?/gm).slice(1);
    sourceSplitted.push("", "");
    const parsed = [];
    const counter = sourceSplitted.length - (sourceSplitted.length % 3);
    for (let i = 0; i < counter; i += 3) {
        parsed.push({
            time: sourceSplitted[i],
            title: sourceSplitted[i + 1],
            description: sourceSplitted[i + 2]
        });
    }
    return parsed;
};
const toExport = [
    { tag: "timeline", parser: timelineParser },
    { tag: "timeline-labeled", parser: timelineLabeledParser },
];

class TimelineElement {
    constructor(root, sourcePath) {
        this.addEvent = (info) => {
            Object.entries(info).map(([key, val]) => {
                const element = this.root.createDiv({ cls: key });
                const text = val;
                obsidian.MarkdownRenderer.renderMarkdown(text, element, this.sourcePath, null);
                return [key, element];
            });
        };
        this.getElement = () => this.root;
        this.root = root.createDiv({ cls: 'timeline' });
        this.sourcePath = sourcePath;
    }
}

const classRegex = /(?<=^\s*)\[.+?\]/gs;
const toClassArray = (input) => {
    input = input.trim();
    if (input[0] != "[" || input[input.length - 1] != "]")
        return [];
    return input
        .substring(1, input.length - 1)
        .trim()
        .split(/\s*,\s*/);
};
class TimelinePlugin extends obsidian.Plugin {
    constructor() {
        super(...arguments);
        this.onload = () => __awaiter(this, void 0, void 0, function* () {
            toExport.forEach(({ tag, parser }) => {
                this.registerMarkdownCodeBlockProcessor(tag, (source, root, ctx) => {
                    const timelineElement = new TimelineElement(root, ctx.sourcePath);
                    const el = timelineElement.getElement();
                    el.addClass("timeline");
                    const classMatch = source.match(classRegex);
                    if (classMatch !== null) {
                        const classes = toClassArray(classMatch[0]);
                        el.addClasses(classes);
                    }
                    const events = parser(source);
                    events.forEach(e => timelineElement.addEvent(e));
                });
            });
            console.log("timeline load");
        });
        this.onunload = () => __awaiter(this, void 0, void 0, function* () {
            console.log("timeline onunload");
        });
    }
}

module.exports = TimelinePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
