/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ImgurPlugin.ts
var ImgurPlugin_exports = {};
__export(ImgurPlugin_exports, {
  default: () => ImgurPlugin
});
module.exports = __toCommonJS(ImgurPlugin_exports);
var import_obsidian13 = require("obsidian");

// src/ui/ImageUploadBlockingModal.ts
var import_obsidian = require("obsidian");
var ImageUploadBlockingModal = class extends import_obsidian.Modal {
  onOpen() {
    this.titleEl.setText("Imgur plugin");
    this.contentEl.setText("Uploading image...");
    const buttonsDiv = this.modalEl.createDiv("modal-button-container");
    new import_obsidian.ButtonComponent(buttonsDiv).setButtonText("Cancel").setCta().onClick(() => {
      this.close();
    });
    this.isOpen = true;
  }
  onClose() {
    this.isOpen = false;
  }
};

// src/ui/RemoteUploadConfirmationDialog.ts
var import_obsidian2 = require("obsidian");
var RemoteUploadConfirmationDialog = class extends import_obsidian2.Modal {
  constructor() {
    super(...arguments);
    this.userResponded = false;
    this.resp = new Promise((resolve) => {
      this.deferredResolve = resolve;
    });
  }
  async response() {
    return this.resp;
  }
  onOpen() {
    this.titleEl.setText("Imgur plugin");
    this.contentEl.setText("Would you like to upload to Imgur or paste your content locally?");
    const buttonsDiv = this.modalEl.createDiv("modal-button-container");
    new import_obsidian2.ButtonComponent(buttonsDiv).setButtonText("Always upload").setCta().onClick(() => {
      this.deferredResolve({ shouldUpload: true, alwaysUpload: true });
      this.afterUserInput();
    });
    new import_obsidian2.ButtonComponent(buttonsDiv).setButtonText("Upload").setCta().onClick(() => {
      this.deferredResolve({ shouldUpload: true });
      this.afterUserInput();
    });
    new import_obsidian2.ButtonComponent(buttonsDiv).setButtonText("Paste locally").onClick(() => {
      this.deferredResolve({ shouldUpload: false });
      this.afterUserInput();
    });
  }
  afterUserInput() {
    this.userResponded = true;
    this.close();
  }
  onClose() {
    if (!this.userResponded) this.deferredResolve({ shouldUpload: void 0 });
  }
};

// src/utils/FileList.ts
function allFilesAreImages(files) {
  if (files.length === 0) return false;
  for (const file of files) {
    if (!file.type.startsWith("image")) return false;
  }
  return true;
}

// src/utils/events.ts
function buildPasteEventCopy(originalEvent, files) {
  const clipboardData = new DataTransfer();
  for (const file of files) {
    clipboardData.items.add(file);
  }
  return new ClipboardEvent(originalEvent.type, { clipboardData });
}

// src/Canvas.ts
function createImgurCanvasPasteHandler(plugin, originalPasteHandler) {
  return function(e) {
    return imgurCanvasPaste.call(this, plugin, originalPasteHandler, e);
  };
}
async function imgurCanvasPaste(plugin, originalPasteHandler, e) {
  const { files } = e.clipboardData;
  if (!allFilesAreImages(files) || files.length != 1) {
    void originalPasteHandler.call(this, e);
    return;
  }
  if (plugin.settings.showRemoteUploadConfirmation) {
    const modal = new RemoteUploadConfirmationDialog(plugin.app);
    modal.open();
    const userResp = await modal.response();
    switch (userResp.shouldUpload) {
      case void 0:
        return;
      case true:
        if (userResp.alwaysUpload) {
          plugin.settings.showRemoteUploadConfirmation = false;
          void plugin.saveSettings();
        }
        break;
      case false:
        void originalPasteHandler.call(this, e);
        return;
      default:
        return;
    }
  }
  const canvas = this.canvas;
  uploadImageOnCanvas(canvas, plugin, buildPasteEventCopy(e, files)).catch(() => {
    void originalPasteHandler.call(this, e);
  });
}
function uploadImageOnCanvas(canvas, plugin, e) {
  const modal = new ImageUploadBlockingModal(plugin.app);
  modal.open();
  const file = e.clipboardData.files[0];
  return plugin.getCurrentImagesUploader().upload(file, plugin.settings.albumToUpload).then((url) => {
    if (!modal.isOpen) {
      return;
    }
    modal.close();
    pasteRemoteImageToCanvas(canvas, url);
  }).catch((err) => {
    modal.close();
    throw err;
  });
}
function pasteRemoteImageToCanvas(canvas, imageUrl) {
  canvas.createTextNode({
    pos: canvas.posCenter(),
    position: "center",
    text: `![](${imageUrl})`
  });
}

// src/UploadStrategy.ts
var _UploadStrategy = class _UploadStrategy {
  constructor(id, description) {
    this.id = id;
    this.description = description;
    _UploadStrategy.valuesArr.push(this);
  }
  static get values() {
    return this.valuesArr;
  }
};
_UploadStrategy.valuesArr = [];
_UploadStrategy.ANONYMOUS_IMGUR = new _UploadStrategy("ANONYMOUS_IMGUR", "Anonymous Imgur upload");
_UploadStrategy.AUTHENTICATED_IMGUR = new _UploadStrategy(
  "AUTHENTICATED_IMGUR",
  "Authenticated Imgur upload"
);
var UploadStrategy = _UploadStrategy;

// src/aux-event-classes/DragEventCopy.ts
var DragEventCopy = class _DragEventCopy extends DragEvent {
  static create(fromEvent, files) {
    const dataTransfer = new DataTransfer();
    for (const file of files) {
      dataTransfer.items.add(file);
    }
    return new _DragEventCopy(fromEvent.type, {
      dataTransfer,
      clientX: fromEvent.clientX,
      clientY: fromEvent.clientY
    });
  }
};

// src/aux-event-classes/PasteEventCopy.ts
var PasteEventCopy = class extends ClipboardEvent {
  constructor(originalEvent) {
    const { files } = originalEvent.clipboardData;
    const dt = new DataTransfer();
    for (const file of files) {
      dt.items.add(file);
    }
    super("paste", { clipboardData: dt });
  }
};

// src/imgur/resizing/ImgurSize.ts
var _ImgurSize = class _ImgurSize {
  constructor(suffix, description, sizeHint) {
    this.suffix = suffix;
    this.description = description;
    this.sizeHint = sizeHint;
    _ImgurSize.VALUES.push(this);
  }
  static values() {
    return _ImgurSize.VALUES;
  }
  toString() {
    return this.description;
  }
};
_ImgurSize.VALUES = [];
_ImgurSize.SMALL_SQUARE = new _ImgurSize("s", "Small square", "90x90");
_ImgurSize.BIG_SQUARE = new _ImgurSize("b", "Big square", "160x160");
_ImgurSize.SMALL_THUMBNAIL = new _ImgurSize("t", "Small Thumbnail", "160x160");
_ImgurSize.MEDIUM_THUMBNAIL = new _ImgurSize("m", "Medium Thumbnail", "320x320");
_ImgurSize.LARGE_THUMBNAIL = new _ImgurSize("l", "Large Thumbnail", "640x640");
_ImgurSize.HUGE_THUMBNAIL = new _ImgurSize("h", "Huge Thumbnail", "1024x1024");
_ImgurSize.ORIGINAL = new _ImgurSize("", "Original size");
var ImgurSize = _ImgurSize;

// src/imgur/resizing/plugin-callback.ts
var import_obsidian3 = require("obsidian");

// src/imgur/resizing/MarkdownImagePieces.ts
function isWrapped(img) {
  return "urlPrefix" in img && "urlSuffix" in img;
}
var IMGUR_IMAGE_ID_LENGTH = 7;
var RESIZED_IMGUR_IMAGE_ID_LENGTH = IMGUR_IMAGE_ID_LENGTH + 1;
function isImageIdOfExpectedSize(imageId) {
  return [IMGUR_IMAGE_ID_LENGTH, RESIZED_IMGUR_IMAGE_ID_LENGTH].includes(imageId.length);
}
function mdImagePiecesFrom(arr) {
  const imageId = arr[4];
  if (!isImageIdOfExpectedSize(imageId)) throw Error("Imgur image id is of unexpcted size");
  return {
    ...arr[1] && { urlPrefix: arr[1] },
    imgPrefix: arr[2],
    imgurhost: arr[3],
    imageId: imageId.slice(0, IMGUR_IMAGE_ID_LENGTH),
    imageExt: arr[5],
    ...arr[6] && { urlSuffix: arr[6] },
    startIndex: arr.index,
    endIndex: arr.index + arr[0].length
  };
}

// src/imgur/resizing/md-image-parsing.ts
var imgurImageRegexp = /(\[)?(!\[[^[\]]*]\()(https?:\/\/(?:i\.)?imgur\.com\/)(\w+)\.(png|jpe?g|gif)\)(]\(https?:\/\/(?:i\.)?imgur\.com\/\w+\.(?:png|jpe?g|gif)\))?/gm;
var parseImgurImages = (line) => line.matchAll(imgurImageRegexp);
var isMatchUnderCursor = (match, cursorPosition) => cursorPosition >= match.index && cursorPosition < match.index + match[0].length;
var MatchWrapper = class {
  constructor(match) {
    this.match = match;
  }
  get exists() {
    return !!this.match;
  }
  get mdImagePieces() {
    return mdImagePiecesFrom(this.match);
  }
};
var findImgurMarkdownImage = (str, cursorPosOnStr) => {
  const allMatchedOnStr = parseImgurImages(str);
  const matchUnderCursor = Array.from(allMatchedOnStr).find(
    (match) => isMatchUnderCursor(match, cursorPosOnStr)
  );
  return new MatchWrapper(matchUnderCursor);
};
var md_image_parsing_default = findImgurMarkdownImage;

// src/imgur/resizing/resizing.ts
var resizeTo = (size) => (pieces) => {
  let replacement;
  const resizedUrl = `${pieces.imgPrefix}${pieces.imgurhost}${pieces.imageId}${size.suffix}.${pieces.imageExt})`;
  if (size === ImgurSize.ORIGINAL) {
    replacement = resizedUrl;
  } else if (isWrapped(pieces)) {
    replacement = `${pieces.urlPrefix}${resizedUrl}${pieces.urlSuffix}`;
  } else {
    replacement = `[${resizedUrl}](${pieces.imgurhost}${pieces.imageId}.${pieces.imageExt})`;
  }
  return {
    content: replacement,
    from: pieces.startIndex,
    to: pieces.endIndex
  };
};
var resizing_default = resizeTo;

// src/imgur/resizing/plugin-callback.ts
var editorCheckCallbackFor = (size) => (checking, editor) => {
  const lineNumber = editor.getCursor().line;
  const match = md_image_parsing_default(editor.getLine(lineNumber), editor.getCursor().ch);
  if (!match.exists) return false;
  if (checking && match.exists) return true;
  let replacement;
  try {
    replacement = resizing_default(size)(match.mdImagePieces);
  } catch (e) {
    if (e instanceof Error) {
      new import_obsidian3.Notice(e.message);
    } else {
      console.error(e);
    }
    return false;
  }
  editor.replaceRange(
    replacement.content,
    { line: lineNumber, ch: replacement.from },
    { line: lineNumber, ch: replacement.to }
  );
  return true;
};
var plugin_callback_default = editorCheckCallbackFor;

// src/ui/ImgurPluginSettingsTab.ts
var import_obsidian7 = require("obsidian");

// src/imgur/constants.ts
var IMGUR_API_BASE = "https://api.imgur.com/3";
var IMGUR_ACCESS_TOKEN_LOCALSTORAGE_KEY = "imgur-access_token";
var IMGUR_POTENTIALLY_SUPPORTED_FILES_EXTENSIONS = [
  "jpeg",
  "jpg",
  "png",
  "gif",
  "apng",
  "tiff",
  "mp4",
  "mpeg",
  "avi",
  "webm",
  "mov",
  "mkv"
];

// src/uploader/ApiError.ts
var ApiError = class extends Error {
};

// src/ui/ImgurAuthModal.ts
var import_obsidian4 = require("obsidian");
var ONE_SECOND_MILLIS = 1e3;
var OPEN_BROWSER_IN_SECONDS = 4;
var ImgurAuthModal = class extends import_obsidian4.Modal {
  constructor(clientId, app, afterClose) {
    super(app);
    this.afterClose = afterClose;
    this.secondsLeft = OPEN_BROWSER_IN_SECONDS;
    this.opened = false;
    this.intervalId = null;
    this.authLink = `https://api.imgur.com/oauth2/authorize?client_id=${clientId}&response_type=token`;
  }
  get isOpen() {
    return this.opened;
  }
  onOpen() {
    this.opened = true;
    this.timerDiv = this.modalEl.createDiv();
    this.updateText();
    this.intervalId = setInterval(() => {
      this.secondsLeft -= 1;
      this.updateText();
      if (this.secondsLeft === 0) {
        window.open(this.authLink);
        clearInterval(this.intervalId);
      }
    }, ONE_SECOND_MILLIS);
    this.addNoWaitDiv(this.intervalId);
    new import_obsidian4.ButtonComponent(this.modalEl.createDiv()).setButtonText("Cancel").setCta().onClick(() => this.close());
  }
  onClose() {
    clearInterval(this.intervalId);
    this.opened = false;
    if (this.afterClose) void this.afterClose();
  }
  addNoWaitDiv(interval) {
    const linkEl = createEl("a", { href: this.authLink, text: "here" });
    const noWaitDiv = this.modalEl.createDiv();
    noWaitDiv.appendText("If you do not want to wait, click ");
    noWaitDiv.append(linkEl);
    linkEl.onclick = () => {
      clearInterval(interval);
      this.secondsLeft = 0;
      this.updateText();
    };
    return noWaitDiv;
  }
  updateText() {
    this.timerDiv.setText(
      `Please complete authentication at imgur.com; Opening browser in ${this.secondsLeft} seconds...`
    );
  }
};

// src/ui/ImgurAuthenticationStatus.ts
var import_obsidian5 = require("obsidian");
var ImgurAuthenticationStatus = class {
  constructor(parent) {
    this.parent = parent;
    const settingItem = this.parent.createDiv();
    settingItem.addClass("setting-item");
    const settingItemInfo = settingItem.createDiv();
    settingItemInfo.addClass("setting-item-info");
    const settingItemControl = settingItem.createDiv();
    settingItemControl.addClass("setting-item-control");
    this.authStatusDiv = settingItemInfo.createDiv();
    this.buttonsDiv = settingItemControl;
  }
  setNotAuthenticated() {
    this.clear();
    this.authStatusDiv.setText("Not authenticated");
    this.addAuthButton();
  }
  setStatusChecking() {
    this.clear();
    this.authStatusDiv.setText("Checking Imgur authentication...");
  }
  setAuthenticatedAs(currentUser) {
    this.clear();
    this.authStatusDiv.setText(`Authenticated as: ${currentUser} \u2705`);
    this.addLogoutButton();
  }
  setInternetConnectionProblem() {
    this.clear();
    this.authStatusDiv.setText("Internet connection problem");
  }
  setImgurSessionError(sessionError) {
    this.clear();
    this.authStatusDiv.setText(`Imgur session error: ${sessionError}`);
    this.addAuthButton();
  }
  setNotAuthenticatedWithError() {
    this.clear();
    this.authStatusDiv.setText("\u26A0\uFE0F Not authenticated. See console for error");
    this.addAuthButton();
  }
  disableAuthButton() {
    var _a;
    (_a = this.authButton) == null ? void 0 : _a.setDisabled(true);
  }
  enableAuthButton() {
    var _a;
    (_a = this.authButton) == null ? void 0 : _a.setDisabled(false);
  }
  clear() {
    this.authStatusDiv.empty();
    this.buttonsDiv.empty();
    this.authButton = void 0;
  }
  addLogoutButton() {
    new import_obsidian5.ButtonComponent(this.buttonsDiv).setButtonText("Logout").setWarning().onClick((e) => this.logoutButtonClick(e));
  }
  addAuthButton() {
    this.authButton = new import_obsidian5.ButtonComponent(this.buttonsDiv).setButtonText("Authenticate").setCta().onClick((e) => this.authButtonClick(e));
  }
};

// src/ui/NewAlbumModal.ts
var import_obsidian6 = require("obsidian");
var NewAlbumModal = class extends import_obsidian6.Modal {
  onOpen() {
    this.setModalTitle();
    const { newAlbumNameField, newAlbumDescriptionField } = this.createInputs();
    const { createButton, cancelButton } = this.createButtons();
    setRequiredAlbumNameChangeCallback(newAlbumNameField, createButton);
    this.setCreateButtonCallback(createButton, newAlbumNameField, newAlbumDescriptionField);
    cancelButton.onClick(() => this.close());
  }
  setModalTitle() {
    this.titleEl.setText("Create new album");
  }
  createInputs() {
    const newAlbumNameField = new import_obsidian6.TextComponent(
      this.modalEl.createDiv("setting-item").createDiv("setting-item-info")
    );
    newAlbumNameField.setPlaceholder("Album name (required)");
    newAlbumNameField.inputEl.setAttr("maxlength", 55);
    newAlbumNameField.inputEl.setCssStyles({ width: "100%" });
    const newAlbumDescriptionField = new import_obsidian6.TextAreaComponent(
      this.modalEl.createDiv("setting-item").createDiv("setting-item-info")
    );
    newAlbumDescriptionField.setPlaceholder("Album description (optional)");
    newAlbumDescriptionField.inputEl.setCssStyles({ width: "100%" });
    return { newAlbumNameField, newAlbumDescriptionField };
  }
  createButtons() {
    const buttonsContainer = this.modalEl.createDiv("modal-button-container");
    const cancelButton = new import_obsidian6.ButtonComponent(buttonsContainer);
    cancelButton.setButtonText("Cancel");
    const createButton = new import_obsidian6.ButtonComponent(buttonsContainer);
    createButton.setButtonText("Create");
    disableActionButton(createButton);
    return { createButton, cancelButton };
  }
  setCreateButtonCallback(createButton, albumNameField, albumDescriptionField) {
    createButton.onClick(async () => {
      setButtonInProgress(createButton);
      await this.createButtonHandler(albumNameField.getValue(), albumDescriptionField.getValue());
      this.close();
    });
  }
};
function setRequiredAlbumNameChangeCallback(newAlbumNameField, createButton) {
  newAlbumNameField.onChange((value) => {
    if (value.length === 0) {
      disableActionButton(createButton);
    } else {
      activateActionButton(createButton);
    }
  });
}
function setButtonInProgress(createButton) {
  createButton.setDisabled(true);
  createButton.setIcon("loader");
}
function activateActionButton(createButton) {
  createButton.setDisabled(false);
  createButton.setCta();
}
function disableActionButton(button) {
  button.setDisabled(true);
  button.buttonEl.setAttribute("disabled", "true");
  button.removeCta();
}

// src/ui/ImgurPluginSettingsTab.ts
var ImgurPluginSettingsTab = class _ImgurPluginSettingsTab extends import_obsidian7.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.authenticatedUserName = void 0;
    this.plugin = plugin;
    this.plugin.registerObsidianProtocolHandler("imgur-oauth", (params) => {
      var _a;
      if (!((_a = this.authModal) == null ? void 0 : _a.isOpen)) return;
      if (params.error) {
        new import_obsidian7.Notice(`Authentication failed with error: ${params.error}`);
        return;
      }
      const mappedData = params.hash.split("&").map((p) => {
        const sp = p.split("=");
        return [sp[0], sp[1]];
      });
      const map = new Map(mappedData);
      localStorage.setItem(IMGUR_ACCESS_TOKEN_LOCALSTORAGE_KEY, map.get("access_token"));
      this.plugin.setupImagesUploader();
      this.authModal.close();
      this.authModal = null;
    });
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "Imgur Plugin settings" });
    const uploadApproachDiv = containerEl.createDiv();
    this.strategyDiv = containerEl.createDiv();
    new import_obsidian7.Setting(uploadApproachDiv).setName("Images upload approach").addDropdown((dropdown) => {
      UploadStrategy.values.forEach((s) => {
        dropdown.addOption(s.id, s.description);
      });
      dropdown.setValue(this.plugin.settings.uploadStrategy);
      dropdown.onChange(async (v) => {
        this.plugin.settings.uploadStrategy = v;
        this.plugin.setupImagesUploader();
        await this.drawSettings(this.strategyDiv);
      });
    });
    void this.drawSettings(this.strategyDiv);
    new import_obsidian7.Setting(containerEl).setName("Confirm before upload").addToggle((t) => {
      t.setValue(this.plugin.settings.showRemoteUploadConfirmation);
      t.onChange((newValue) => {
        this.plugin.settings.showRemoteUploadConfirmation = newValue;
      });
    });
  }
  hide() {
    void this.plugin.saveSettings().then(() => this.plugin.setupImagesUploader());
  }
  async drawSettings(parentEl) {
    parentEl.empty();
    this.drawClientIdField(parentEl);
    if (this.plugin.settings.uploadStrategy === UploadStrategy.AUTHENTICATED_IMGUR.id) {
      await this.createAuthenticationInfoBlock(parentEl);
      if (this.authenticatedUserName) this.drawAlbumSettings(parentEl);
    }
  }
  drawClientIdField(containerEl) {
    new import_obsidian7.Setting(containerEl).setName("Client ID").setTooltip(`Personal Client ID is required for plugin to work`, { delay: 1 }).setDesc(_ImgurPluginSettingsTab.clientIdSettingDescription()).addText(
      (text) => text.setPlaceholder("Enter your client_id").setValue(this.plugin.settings.clientId).onChange((value) => {
        this.plugin.settings.clientId = value;
        this.enableOrDisableAuthenticationButton();
      })
    );
  }
  static clientIdSettingDescription() {
    const fragment = document.createDocumentFragment();
    const newClientIdInstructionsLink = document.createElement("a");
    newClientIdInstructionsLink.textContent = "the instructions";
    newClientIdInstructionsLink.setAttribute(
      "href",
      "https://github.com/gavvvr/obsidian-imgur-plugin?tab=readme-ov-file#generating-client-id"
    );
    const existingClientIdsLink = document.createElement("a");
    existingClientIdsLink.text = "here";
    existingClientIdsLink.setAttribute("href", "https://imgur.com/account/settings/apps");
    fragment.append("Find your existing Client ID ", existingClientIdsLink);
    fragment.append(" or follow ", newClientIdInstructionsLink, " to generate new Client ID.");
    return fragment;
  }
  enableOrDisableAuthenticationButton() {
    if (this.plugin.settings.clientId) this.authElem.enableAuthButton();
    else this.authElem.disableAuthButton();
  }
  async createAuthenticationInfoBlock(parentEl) {
    this.authElem = new ImgurAuthenticationStatus(parentEl);
    await this.drawAuthenticationInfo();
    this.enableOrDisableAuthenticationButton();
    this.authElem.authButtonClick = () => {
      const modal = new ImgurAuthModal(this.plugin.settings.clientId, this.app, async () => {
        await this.drawAuthenticationInfo();
      });
      modal.open();
      this.authModal = modal;
    };
    this.authElem.logoutButtonClick = async () => {
      localStorage.removeItem(IMGUR_ACCESS_TOKEN_LOCALSTORAGE_KEY);
      this.plugin.setupImagesUploader();
      await this.drawAuthenticationInfo();
    };
  }
  async drawAuthenticationInfo() {
    const authenticatedClient = this.plugin.getAuthenticatedImgurClient();
    if (!authenticatedClient) {
      this.authElem.setNotAuthenticated();
      return;
    }
    this.authElem.setStatusChecking();
    try {
      this.authenticatedUserName = (await authenticatedClient.accountInfo()).data.url;
      this.authElem.setAuthenticatedAs(this.authenticatedUserName);
    } catch (e) {
      if (e instanceof TypeError && e.message === "Failed to fetch") {
        this.authElem.setInternetConnectionProblem();
      } else if (e instanceof ApiError) {
        this.authElem.setImgurSessionError(e.message);
      } else {
        console.warn("Not authenticated, exception: ", e);
        this.authElem.setNotAuthenticatedWithError();
      }
    }
  }
  drawAlbumSettings(parentEl) {
    const albumSetting = new import_obsidian7.Setting(parentEl);
    this.addAlbumsManagerLink(albumSetting.descEl, this.authenticatedUserName);
    albumSetting.setName("Album to upload").addDropdown(async (d) => {
      d.setDisabled(true);
      d.addOption("", "Loading...");
      await this.populateList(d);
      d.selectEl.options.remove(0);
      d.setDisabled(false);
      d.onChange((value) => {
        if (value === "\uFF0B") {
          const handler = async (name, description) => {
            const client = this.plugin.getAuthenticatedImgurClient();
            try {
              const resp = await client.createNewAlbum(name, description);
              if (resp.success === true) {
                await this.populateList(d);
                d.setValue(resp.data.id);
                d.selectEl.removeClass("mod-warning");
                this.plugin.settings.albumToUpload = resp.data.id;
              }
            } catch (e) {
              new import_obsidian7.Notice("Failed to create new album. Open console to see log");
              console.error("Failed to create a new album", e);
            }
          };
          const modal = new NewAlbumModal(this.app);
          modal.createButtonHandler = handler;
          modal.open();
          return;
        }
        if (value === "null") {
          this.plugin.settings.albumToUpload = void 0;
        } else {
          this.plugin.settings.albumToUpload = value;
        }
        for (const opt of Array.from(d.selectEl.options)) {
          if (opt.value === value) {
            if (opt.innerText.contains("\u26A0\uFE0F")) {
              d.selectEl.addClass("mod-warning");
            } else {
              d.selectEl.removeClass("mod-warning");
            }
          }
        }
      });
    });
  }
  addAlbumsManagerLink(element, loggedInUser) {
    const link = `https://${loggedInUser}.imgur.com/all`;
    const linkEl = createEl("a", { href: link, text: link });
    element.appendText("Manage your albums at ");
    element.append(linkEl);
  }
  async populateList(d) {
    const client = this.plugin.getAuthenticatedImgurClient();
    const albums = (await client.listAlbums()).data;
    albums.sort((a1, a2) => a1.datetime - a2.datetime);
    d.addOption(null, "Not specified");
    d.addOption("\uFF0B", "\uFF0B Create new album");
    for (const album of albums) {
      d.addOption(album.id, album.title);
    }
    const currentlyChosenAlbum = this.plugin.settings.albumToUpload;
    if (currentlyChosenAlbum != void 0 && !albums.some((a) => a.id === currentlyChosenAlbum)) {
      d.addOption(
        currentlyChosenAlbum,
        `id: ${currentlyChosenAlbum} (\u26A0\uFE0F album not found at imgur.com)`
      );
      d.selectEl.addClass("mod-warning");
    }
    d.setValue(currentlyChosenAlbum);
  }
};

// src/ui/InfoModal.ts
var import_obsidian8 = require("obsidian");
var InfoModal = class extends import_obsidian8.Modal {
  constructor(app, title, message) {
    super(app);
    this.setTitle(title);
    this.contentEl.createEl("p", { text: message });
    const buttonsDiv = this.modalEl.createDiv("modal-button-container");
    new import_obsidian8.ButtonComponent(buttonsDiv).setButtonText("Ok");
  }
};

// src/ui/UpdateLinksConfirmationModal.ts
var import_obsidian9 = require("obsidian");
var UpdateLinksConfirmationModal = class extends import_obsidian9.Modal {
  constructor(app, localFileName, stats) {
    super(app);
    this.setTitle("Replace links in vault");
    this.contentEl.createEl("p", {
      text: `Do you want to replace internal links that link to original local file (${localFileName}) with remote link?`
    });
    this.contentEl.createEl("p", {
      text: `This will affect ${stats.linksCount} links in ${stats.filesCount} files.`
    });
    const buttonsDiv = this.modalEl.createDiv("modal-button-container");
    this.updateOnceButton = new import_obsidian9.ButtonComponent(buttonsDiv).setButtonText("Yes");
    this.doNotUpdateButton = new import_obsidian9.ButtonComponent(buttonsDiv).setButtonText("Do not update");
  }
  onDoUpdateClick(callback) {
    this.updateOnceButton.onClick(callback);
  }
  onDoNotUpdateClick(callback) {
    this.doNotUpdateButton.onClick(callback);
  }
  disableButtons() {
    this.updateOnceButton.setDisabled(true);
    this.doNotUpdateButton.setDisabled(true);
  }
};

// src/imgur/AuthenticatedImgurClient.ts
var import_obsidian10 = require("obsidian");

// src/utils/multipart-http.ts
function buildMultipartBody(formData, boundary) {
  const multipartPirces = multipartPiecesFrom(formData);
  return composeMultipartBodyFrom(multipartPirces, boundary);
}
function multipartPiecesFrom(formData) {
  const pieces = [];
  formData.forEach((content, name) => {
    if (typeof content === "string") {
      pieces.push(stringToFormDataSection(name, content));
    } else if (content instanceof File) {
      pieces.push(fileToFormDataSection(name, content));
    }
  });
  return pieces;
}
var MIME_LINE_BREAK = "\r\n";
var DOUBLE_LINE_BREAK = `${MIME_LINE_BREAK}${MIME_LINE_BREAK}`;
function stringToFormDataSection(formName, strValue) {
  return `Content-Disposition: form-data; name="${formName}"${DOUBLE_LINE_BREAK}${strValue}`;
}
function fileToFormDataSection(formName, file) {
  const firstLine = `Content-Disposition: form-data; name="${formName}"; filename="${file.name}"`;
  const contentType = file.type ? [MIME_LINE_BREAK, `Content-Type: ${file.type}`] : [""];
  return new Blob([firstLine, ...contentType, DOUBLE_LINE_BREAK, file]);
}
function composeMultipartBodyFrom(multipartPieces, boundaryLine) {
  const allPieces = addMultipartBoundaries(multipartPieces, boundaryLine);
  const singleBlob = new Blob(addLineBreaks(allPieces));
  return singleBlob;
}
function addMultipartBoundaries(multipartPieces, boundary) {
  const boundaryLine = `--${boundary}`;
  const allPieces = multipartPieces.flatMap((p) => [boundaryLine, p]);
  const finalBoundaryLine = `--${boundary}--`;
  allPieces.push(finalBoundaryLine);
  return allPieces;
}
function addLineBreaks(allPieces) {
  const result = [];
  for (let i = 0; i < allPieces.length; i++) {
    result.push(allPieces[i]);
    if (i !== allPieces.length - 1) {
      result.push(MIME_LINE_BREAK);
    }
  }
  return result;
}

// src/utils/obsidian-http-client.ts
async function prepareMultipartRequestPiece(requestData) {
  const boundary = `----formdata-0${`${Math.floor(Math.random() * 1e11)}`.padStart(11, "0")}`;
  return {
    contentType: `multipart/form-data; boundary=${boundary}`,
    body: await buildMultipartBody(requestData, boundary).arrayBuffer()
  };
}

// src/imgur/AuthenticatedImgurClient.ts
function handleImgurErrorResponse(resp) {
  if (resp.headers["Content-Type"] === "application/json") {
    throw new ApiError(resp.json.data.error);
  }
  throw new Error(resp.text);
}
var AuthenticatedImgurClient = class {
  constructor(accessToken) {
    this.accessToken = accessToken;
    void this.accountInfo().then((r) => this.authenticatedUser = r.data.url).catch((e) => console.error("Failed to get info about currently authenticated user!", e));
  }
  async accountInfo() {
    const req = {
      url: `${IMGUR_API_BASE}/account/me`,
      method: "GET",
      headers: { Authorization: `Bearer ${this.accessToken}` },
      throw: false
    };
    const resp = await (0, import_obsidian10.requestUrl)(req);
    if (resp.status >= 400) {
      handleImgurErrorResponse(resp);
    }
    return resp.json;
  }
  async upload(image, albumId) {
    const requestData = new FormData();
    requestData.append("image", image);
    if (albumId) {
      requestData.append("album", albumId);
    }
    const request = {
      url: `${IMGUR_API_BASE}/image`,
      method: "POST",
      headers: { Authorization: `Bearer ${this.accessToken}` },
      ...await prepareMultipartRequestPiece(requestData),
      throw: false
    };
    const resp = await (0, import_obsidian10.requestUrl)(request);
    if (resp.status >= 400) {
      handleImgurErrorResponse(resp);
    }
    return resp.json;
  }
  async listAlbums() {
    const req = {
      url: `${IMGUR_API_BASE}/account/${this.authenticatedUser}/albums`,
      method: "GET",
      headers: { Authorization: `Bearer ${this.accessToken}` },
      throw: false
    };
    const resp = await (0, import_obsidian10.requestUrl)(req);
    if (resp.status >= 400) {
      handleImgurErrorResponse(resp);
    }
    return resp.json;
  }
  async createNewAlbum(name, description) {
    const requestData = new FormData();
    requestData.append("title", name);
    if (description) {
      requestData.append("description", description);
    }
    const request = {
      url: `${IMGUR_API_BASE}/album`,
      method: "POST",
      headers: { Authorization: `Bearer ${this.accessToken}` },
      ...await prepareMultipartRequestPiece(requestData),
      throw: false
    };
    const resp = await (0, import_obsidian10.requestUrl)(request);
    if (resp.status >= 400) {
      handleImgurErrorResponse(resp);
    }
    return resp.json;
  }
};

// src/uploader/imgur/ImgurAnonymousUploader.ts
var import_obsidian11 = require("obsidian");
var ImgurAnonymousUploader = class {
  constructor(clientId) {
    this.clientId = clientId;
  }
  async upload(image) {
    const requestData = new FormData();
    requestData.append("image", image);
    const request = {
      url: `${IMGUR_API_BASE}/image`,
      method: "POST",
      headers: { Authorization: `Client-ID ${this.clientId}` },
      ...await prepareMultipartRequestPiece(requestData),
      throw: false
    };
    const resp = await (0, import_obsidian11.requestUrl)(request);
    if (resp.status >= 400) {
      handleImgurErrorResponse(resp);
    }
    return resp.json.data.link;
  }
};

// src/uploader/imgur/ImgurAuthenticatedUploader.ts
var ImgurAuthenticatedUploader = class {
  constructor(client) {
    this.client = client;
  }
  async upload(image, albumId) {
    return (await this.client.upload(image, albumId)).data.link;
  }
};

// src/uploader/imgUploaderFactory.ts
function buildUploaderFrom(settings) {
  if (UploadStrategy.AUTHENTICATED_IMGUR.id === settings.uploadStrategy) {
    const accessToken = localStorage.getItem(IMGUR_ACCESS_TOKEN_LOCALSTORAGE_KEY);
    if (!accessToken) {
      return void 0;
    }
    return new ImgurAuthenticatedUploader(new AuthenticatedImgurClient(accessToken));
  }
  if (settings.uploadStrategy === UploadStrategy.ANONYMOUS_IMGUR.id) {
    if (settings.clientId) {
      return new ImgurAnonymousUploader(settings.clientId);
    } else {
      return void 0;
    }
  }
  throw Error("This line of code should never be reached");
}

// src/utils/editor.ts
var import_obsidian12 = require("obsidian");
function localEmbeddedImageExpectedBoundaries(from) {
  return [
    { ...from.start, ch: from.start.ch - 3 },
    { ...from.end, ch: from.end.ch + 2 }
  ];
}
var findLocalFileUnderCursor = (editor, ctx) => {
  const clickable = editor.getClickableTokenAt(editor.getCursor());
  if (!clickable) return null;
  if (clickable.type !== "internal-link") return null;
  const [localImageExpectedStart, localImageExpectedEnd] = localEmbeddedImageExpectedBoundaries(clickable);
  const clickablePrefix = editor.getRange(localImageExpectedStart, clickable.start);
  const clickableSuffix = editor.getRange(clickable.end, localImageExpectedEnd);
  if (clickablePrefix !== "![[" || clickableSuffix !== "]]") return null;
  const lt = (0, import_obsidian12.parseLinktext)(clickable.text);
  const file = ctx.app.metadataCache.getFirstLinkpathDest(lt.path, ctx.file.path);
  if (!IMGUR_POTENTIALLY_SUPPORTED_FILES_EXTENSIONS.includes(file.extension)) return null;
  return {
    file,
    start: localImageExpectedStart,
    end: localImageExpectedEnd
  };
};

// src/utils/misc.ts
function fixImageTypeIfNeeded(image) {
  if (passesInstanceofCheck(image)) {
    return image;
  }
  return new File([image], image.name, { type: image.type, lastModified: image.lastModified });
  function passesInstanceofCheck(image2) {
    return image2 instanceof File;
  }
}

// src/ImgurPlugin.ts
var DEFAULT_SETTINGS = {
  uploadStrategy: UploadStrategy.ANONYMOUS_IMGUR.id,
  clientId: null,
  showRemoteUploadConfirmation: true,
  albumToUpload: void 0
};
var ImgurPlugin = class _ImgurPlugin extends import_obsidian13.Plugin {
  constructor() {
    super(...arguments);
    this.customPasteEventCallback = async (e, _, markdownView) => {
      if (e instanceof PasteEventCopy) return;
      if (!this.imgUploader) {
        _ImgurPlugin.showUnconfiguredPluginNotice();
        return;
      }
      const { files } = e.clipboardData;
      if (!allFilesAreImages(files)) return;
      e.preventDefault();
      if (this.settings.showRemoteUploadConfirmation) {
        const modal = new RemoteUploadConfirmationDialog(this.app);
        modal.open();
        const userResp = await modal.response();
        switch (userResp.shouldUpload) {
          case void 0:
            return;
          case true:
            if (userResp.alwaysUpload) {
              this.settings.showRemoteUploadConfirmation = false;
              void this.saveSettings();
            }
            break;
          case false:
            markdownView.currentMode.clipboardManager.handlePaste(new PasteEventCopy(e));
            return;
          default:
            return;
        }
      }
      for (const file of files) {
        this.uploadFileAndEmbedImgurImage(file).catch(() => {
          markdownView.currentMode.clipboardManager.handlePaste(new PasteEventCopy(e));
        });
      }
    };
    this.customDropEventListener = async (e, _, markdownView) => {
      if (e instanceof DragEventCopy) return;
      if (!this.imgUploader) {
        _ImgurPlugin.showUnconfiguredPluginNotice();
        return;
      }
      if (e.dataTransfer.types.length !== 1 || e.dataTransfer.types[0] !== "Files") {
        return;
      }
      const { files } = e.dataTransfer;
      if (!allFilesAreImages(files)) return;
      e.preventDefault();
      if (this.settings.showRemoteUploadConfirmation) {
        const modal = new RemoteUploadConfirmationDialog(this.app);
        modal.open();
        const userResp = await modal.response();
        switch (userResp.shouldUpload) {
          case void 0:
            return;
          case true:
            if (userResp.alwaysUpload) {
              this.settings.showRemoteUploadConfirmation = false;
              void this.saveSettings();
            }
            break;
          case false: {
            markdownView.currentMode.clipboardManager.handleDrop(DragEventCopy.create(e, files));
            return;
          }
          default:
            return;
        }
      }
      this.getEditor().replaceSelection("\n");
      const promises = [];
      const filesFailedToUpload = [];
      for (const image of files) {
        const uploadPromise = this.uploadFileAndEmbedImgurImage(image).catch(() => {
          filesFailedToUpload.push(image);
        });
        promises.push(uploadPromise);
      }
      await Promise.all(promises);
      if (filesFailedToUpload.length === 0) {
        return;
      }
      markdownView.currentMode.clipboardManager.handleDrop(
        DragEventCopy.create(e, filesFailedToUpload)
      );
    };
    this.imgurPluginRightClickHandler = (menu, editor, view) => {
      const localFile = findLocalFileUnderCursor(editor, view);
      if (!localFile) return;
      menu.addItem((item) => {
        item.setTitle("Upload to Imgur").setIcon("wand").onClick(() => this.doUploadLocalImage({ image: localFile, editor, noteFile: view.file }));
      });
    };
    this.editorCheckCallbackForLocalUpload = (checking, editor, ctx) => {
      const localFile = findLocalFileUnderCursor(editor, ctx);
      if (!localFile) return false;
      if (checking) return true;
      void this.doUploadLocalImage({ image: localFile, editor, noteFile: ctx.file });
    };
  }
  getCurrentImagesUploader() {
    return this.imgUploaderField;
  }
  async doUploadLocalImage(imageInEditor) {
    const { image, editor, noteFile } = imageInEditor;
    const { file: imageFile, start, end } = image;
    const imageUrl = await this.uploadLocalImageFromEditor(editor, imageFile, start, end);
    this.proposeToReplaceOtherLocalLinksIfAny(imageFile, imageUrl, {
      path: noteFile.path,
      startPosition: start
    });
  }
  proposeToReplaceOtherLocalLinksIfAny(originalLocalFile, remoteImageUrl, originalReference) {
    const otherReferencesByNote = this.getAllCachedReferencesForFile(originalLocalFile);
    removeReferenceToOriginalNoteIfPresent(otherReferencesByNote, originalReference);
    const notesWithSameLocalFile = Object.keys(otherReferencesByNote);
    if (notesWithSameLocalFile.length === 0) return;
    this.showLinksUpdateDialog(originalLocalFile, remoteImageUrl, otherReferencesByNote);
  }
  getAllCachedReferencesForFile(file) {
    const allLinks = this.app.metadataCache.resolvedLinks;
    const notesWithLinks = [];
    for (const [notePath, noteLinks] of Object.entries(allLinks)) {
      for (const [linkName] of Object.entries(noteLinks)) {
        if (linkName === file.name) notesWithLinks.push(notePath);
      }
    }
    const linksByNote = notesWithLinks.reduce(
      (acc, note) => {
        const noteMetadata = this.app.metadataCache.getCache(note);
        const noteLinks = noteMetadata.embeds;
        if (noteLinks) {
          acc[note] = noteLinks.filter((l) => l.link === file.name);
        }
        return acc;
      },
      {}
    );
    return linksByNote;
  }
  showLinksUpdateDialog(localFile, remoteImageUrl, otherReferencesByNote) {
    const stats = getFilesAndLinksStats(otherReferencesByNote);
    const dialogBox = new UpdateLinksConfirmationModal(this.app, localFile.path, stats);
    dialogBox.onDoNotUpdateClick(() => dialogBox.close());
    dialogBox.onDoUpdateClick(() => {
      dialogBox.disableButtons();
      dialogBox.setContent("Working...");
      this.replaceAllLocalReferencesWithRemoteOne(otherReferencesByNote, remoteImageUrl).catch((e) => {
        new InfoModal(
          this.app,
          "Error",
          "Unexpected error occurred, check Developer Tools console for details"
        ).open();
        console.error("Something bad happened during links update", e);
      }).finally(() => dialogBox.close());
      new import_obsidian13.Notice(`Updated ${stats.linksCount} links in ${stats.filesCount} files`);
    });
    dialogBox.open();
  }
  async replaceAllLocalReferencesWithRemoteOne(referencesByNotes, remoteImageUrl) {
    for (const [notePath, refs] of Object.entries(referencesByNotes)) {
      const noteFile = this.app.vault.getFileByPath(notePath);
      const refsStartOffsetsSortedDescending = refs.map((ref) => ({
        start: ref.position.start.offset,
        end: ref.position.end.offset
      })).sort((ref1, ref2) => ref2.start - ref1.start);
      await this.app.vault.process(noteFile, (noteContent) => {
        let updatedContent = noteContent;
        refsStartOffsetsSortedDescending.forEach((refPos) => {
          updatedContent = updatedContent.substring(0, refPos.start) + `![](${remoteImageUrl})` + updatedContent.substring(refPos.end);
        });
        return updatedContent;
      });
    }
  }
  async uploadLocalImageFromEditor(editor, file, start, end) {
    const arrayBuffer = await this.app.vault.readBinary(file);
    const fileToUpload = new File([arrayBuffer], file.name);
    editor.replaceRange("\n", end, end);
    const imageUrl = await this.uploadFileAndEmbedImgurImage(fileToUpload, {
      ch: 0,
      line: end.line + 1
    });
    editor.replaceRange(`<!--${editor.getRange(start, end)}-->`, start, end);
    return imageUrl;
  }
  get imgUploader() {
    return this.imgUploaderField;
  }
  async loadSettings() {
    this.settings = {
      ...DEFAULT_SETTINGS,
      ...await this.loadData()
    };
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
  onload() {
    void this.initPlugin();
  }
  async initPlugin() {
    await this.loadSettings();
    this.addSettingTab(new ImgurPluginSettingsTab(this.app, this));
    this.setupImagesUploader();
    this.setupImgurHandlers();
    this.addResizingCommands();
    this.addUploadLocalCommand();
  }
  setupImagesUploader() {
    const uploader = buildUploaderFrom(this.settings);
    this.imgUploaderField = uploader;
    if (!uploader) return;
    const originalUploadFunction = uploader.upload;
    uploader.upload = function(image, albumId) {
      if (!uploader) return;
      return originalUploadFunction.call(uploader, fixImageTypeIfNeeded(image), albumId);
    };
  }
  setupImgurHandlers() {
    this.registerEvent(this.app.workspace.on("editor-paste", this.customPasteEventCallback));
    this.registerEvent(this.app.workspace.on("editor-drop", this.customDropEventListener));
    this.registerEvent(
      this.app.workspace.on("active-leaf-change", (leaf) => {
        const view = leaf.view;
        if (view.getViewType() === "canvas") {
          this.overridePasteHandlerForCanvasView(view);
        }
      })
    );
    this.registerEvent(this.app.workspace.on("editor-menu", this.imgurPluginRightClickHandler));
  }
  overridePasteHandlerForCanvasView(view) {
    const originalPasteFn = view.handlePaste;
    view.handlePaste = createImgurCanvasPasteHandler(this, originalPasteFn);
  }
  addResizingCommands() {
    const sizes = ImgurSize.values();
    for (const size of sizes) {
      this.addCommand({
        id: `imgur-resize-${size.suffix}-command`,
        name: `Resize to ${size.description}${size.sizeHint ? ` (${size.sizeHint})` : ""}`,
        editorCheckCallback: plugin_callback_default(size)
      });
    }
  }
  addUploadLocalCommand() {
    this.addCommand({
      id: "imgur-upload-local",
      name: "Upload to Imgur",
      editorCheckCallback: this.editorCheckCallbackForLocalUpload
    });
  }
  getAuthenticatedImgurClient() {
    if (this.imgUploader instanceof ImgurAuthenticatedUploader) {
      return this.imgUploader.client;
    }
    return null;
  }
  static showUnconfiguredPluginNotice() {
    const fiveSecondsMillis = 5e3;
    new import_obsidian13.Notice("\u26A0\uFE0F Please configure Client ID for Imgur plugin or disable it", fiveSecondsMillis);
  }
  async uploadFileAndEmbedImgurImage(file, atPos) {
    const pasteId = (Math.random() + 1).toString(36).substring(2, 7);
    this.insertTemporaryText(pasteId, atPos);
    let imgUrl;
    try {
      imgUrl = await this.imgUploaderField.upload(file, this.settings.albumToUpload);
    } catch (e) {
      if (e instanceof ApiError) {
        this.handleFailedUpload(
          pasteId,
          `Upload failed, remote server returned an error: ${e.message}`
        );
      } else {
        console.error("Failed imgur request: ", e);
        this.handleFailedUpload(pasteId, "\u26A0\uFE0FImgur upload failed, check dev console");
      }
      throw e;
    }
    this.embedMarkDownImage(pasteId, imgUrl);
    return imgUrl;
  }
  insertTemporaryText(pasteId, atPos) {
    const progressText = _ImgurPlugin.progressTextFor(pasteId);
    const replacement = `${progressText}
`;
    const editor = this.getEditor();
    if (atPos) {
      editor.replaceRange(replacement, atPos, atPos);
    } else {
      this.getEditor().replaceSelection(replacement);
    }
  }
  static progressTextFor(id) {
    return `![Uploading file...${id}]()`;
  }
  embedMarkDownImage(pasteId, imageUrl) {
    const progressText = _ImgurPlugin.progressTextFor(pasteId);
    const markDownImage = `![](${imageUrl})`;
    _ImgurPlugin.replaceFirstOccurrence(this.getEditor(), progressText, markDownImage);
  }
  handleFailedUpload(pasteId, message) {
    const progressText = _ImgurPlugin.progressTextFor(pasteId);
    _ImgurPlugin.replaceFirstOccurrence(this.getEditor(), progressText, `<!--${message}-->`);
  }
  getEditor() {
    const mdView = this.app.workspace.getActiveViewOfType(import_obsidian13.MarkdownView);
    return mdView.editor;
  }
  static replaceFirstOccurrence(editor, target, replacement) {
    const lines = editor.getValue().split("\n");
    for (let i = 0; i < lines.length; i += 1) {
      const ch = lines[i].indexOf(target);
      if (ch !== -1) {
        const from = { line: i, ch };
        const to = { line: i, ch: ch + target.length };
        editor.replaceRange(replacement, from, to);
        break;
      }
    }
  }
};
function removeReferenceToOriginalNoteIfPresent(otherReferencesByNote, originalNote) {
  if (!Object.keys(otherReferencesByNote).includes(originalNote.path)) return;
  const refsFromOriginalNote = otherReferencesByNote[originalNote.path];
  const originalRefStart = originalNote.startPosition;
  const refForExclusion = refsFromOriginalNote.find(
    (r) => r.position.start.line === originalRefStart.line && r.position.start.col === originalRefStart.ch
  );
  if (refForExclusion) {
    refsFromOriginalNote.remove(refForExclusion);
    if (refsFromOriginalNote.length === 0) {
      delete otherReferencesByNote[originalNote.path];
    }
  }
}
function getFilesAndLinksStats(otherReferencesByNote) {
  return {
    filesCount: Object.keys(otherReferencesByNote).length,
    linksCount: Object.values(otherReferencesByNote).reduce(
      (count, refs) => count + refs.length,
      0
    )
  };
}

/* nosourcemap */