/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to2, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to2, key) && key !== except)
        __defProp(to2, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to2;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/mark.js/dist/mark.js
var require_mark = __commonJS({
  "node_modules/mark.js/dist/mark.js"(exports, module2) {
    (function(global, factory) {
      typeof exports === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : global.Mark = factory();
    })(exports, (function() {
      "use strict";
      var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
        return typeof obj;
      } : function(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
      var classCallCheck = function(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
          throw new TypeError("Cannot call a class as a function");
        }
      };
      var createClass = /* @__PURE__ */ (function() {
        function defineProperties(target, props) {
          for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
          }
        }
        return function(Constructor, protoProps, staticProps) {
          if (protoProps) defineProperties(Constructor.prototype, protoProps);
          if (staticProps) defineProperties(Constructor, staticProps);
          return Constructor;
        };
      })();
      var _extends = Object.assign || function(target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];
          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }
        return target;
      };
      var DOMIterator = (function() {
        function DOMIterator2(ctx) {
          var iframes = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
          var exclude = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : [];
          var iframesTimeout = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 5e3;
          classCallCheck(this, DOMIterator2);
          this.ctx = ctx;
          this.iframes = iframes;
          this.exclude = exclude;
          this.iframesTimeout = iframesTimeout;
        }
        createClass(DOMIterator2, [{
          key: "getContexts",
          value: function getContexts() {
            var ctx = void 0, filteredCtx = [];
            if (typeof this.ctx === "undefined" || !this.ctx) {
              ctx = [];
            } else if (NodeList.prototype.isPrototypeOf(this.ctx)) {
              ctx = Array.prototype.slice.call(this.ctx);
            } else if (Array.isArray(this.ctx)) {
              ctx = this.ctx;
            } else if (typeof this.ctx === "string") {
              ctx = Array.prototype.slice.call(document.querySelectorAll(this.ctx));
            } else {
              ctx = [this.ctx];
            }
            ctx.forEach(function(ctx2) {
              var isDescendant = filteredCtx.filter(function(contexts) {
                return contexts.contains(ctx2);
              }).length > 0;
              if (filteredCtx.indexOf(ctx2) === -1 && !isDescendant) {
                filteredCtx.push(ctx2);
              }
            });
            return filteredCtx;
          }
        }, {
          key: "getIframeContents",
          value: function getIframeContents(ifr, successFn) {
            var errorFn = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : function() {
            };
            var doc = void 0;
            try {
              var ifrWin = ifr.contentWindow;
              doc = ifrWin.document;
              if (!ifrWin || !doc) {
                throw new Error("iframe inaccessible");
              }
            } catch (e2) {
              errorFn();
            }
            if (doc) {
              successFn(doc);
            }
          }
        }, {
          key: "isIframeBlank",
          value: function isIframeBlank(ifr) {
            var bl2 = "about:blank", src = ifr.getAttribute("src").trim(), href = ifr.contentWindow.location.href;
            return href === bl2 && src !== bl2 && src;
          }
        }, {
          key: "observeIframeLoad",
          value: function observeIframeLoad(ifr, successFn, errorFn) {
            var _this = this;
            var called = false, tout = null;
            var listener = function listener2() {
              if (called) {
                return;
              }
              called = true;
              clearTimeout(tout);
              try {
                if (!_this.isIframeBlank(ifr)) {
                  ifr.removeEventListener("load", listener2);
                  _this.getIframeContents(ifr, successFn, errorFn);
                }
              } catch (e2) {
                errorFn();
              }
            };
            ifr.addEventListener("load", listener);
            tout = setTimeout(listener, this.iframesTimeout);
          }
        }, {
          key: "onIframeReady",
          value: function onIframeReady(ifr, successFn, errorFn) {
            try {
              if (ifr.contentWindow.document.readyState === "complete") {
                if (this.isIframeBlank(ifr)) {
                  this.observeIframeLoad(ifr, successFn, errorFn);
                } else {
                  this.getIframeContents(ifr, successFn, errorFn);
                }
              } else {
                this.observeIframeLoad(ifr, successFn, errorFn);
              }
            } catch (e2) {
              errorFn();
            }
          }
        }, {
          key: "waitForIframes",
          value: function waitForIframes(ctx, done) {
            var _this2 = this;
            var eachCalled = 0;
            this.forEachIframe(ctx, function() {
              return true;
            }, function(ifr) {
              eachCalled++;
              _this2.waitForIframes(ifr.querySelector("html"), function() {
                if (!--eachCalled) {
                  done();
                }
              });
            }, function(handled) {
              if (!handled) {
                done();
              }
            });
          }
        }, {
          key: "forEachIframe",
          value: function forEachIframe(ctx, filter, each) {
            var _this3 = this;
            var end = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : function() {
            };
            var ifr = ctx.querySelectorAll("iframe"), open = ifr.length, handled = 0;
            ifr = Array.prototype.slice.call(ifr);
            var checkEnd = function checkEnd2() {
              if (--open <= 0) {
                end(handled);
              }
            };
            if (!open) {
              checkEnd();
            }
            ifr.forEach(function(ifr2) {
              if (DOMIterator2.matches(ifr2, _this3.exclude)) {
                checkEnd();
              } else {
                _this3.onIframeReady(ifr2, function(con) {
                  if (filter(ifr2)) {
                    handled++;
                    each(con);
                  }
                  checkEnd();
                }, checkEnd);
              }
            });
          }
        }, {
          key: "createIterator",
          value: function createIterator(ctx, whatToShow, filter) {
            return document.createNodeIterator(ctx, whatToShow, filter, false);
          }
        }, {
          key: "createInstanceOnIframe",
          value: function createInstanceOnIframe(contents) {
            return new DOMIterator2(contents.querySelector("html"), this.iframes);
          }
        }, {
          key: "compareNodeIframe",
          value: function compareNodeIframe(node, prevNode, ifr) {
            var compCurr = node.compareDocumentPosition(ifr), prev = Node.DOCUMENT_POSITION_PRECEDING;
            if (compCurr & prev) {
              if (prevNode !== null) {
                var compPrev = prevNode.compareDocumentPosition(ifr), after2 = Node.DOCUMENT_POSITION_FOLLOWING;
                if (compPrev & after2) {
                  return true;
                }
              } else {
                return true;
              }
            }
            return false;
          }
        }, {
          key: "getIteratorNode",
          value: function getIteratorNode(itr) {
            var prevNode = itr.previousNode();
            var node = void 0;
            if (prevNode === null) {
              node = itr.nextNode();
            } else {
              node = itr.nextNode() && itr.nextNode();
            }
            return {
              prevNode,
              node
            };
          }
        }, {
          key: "checkIframeFilter",
          value: function checkIframeFilter(node, prevNode, currIfr, ifr) {
            var key = false, handled = false;
            ifr.forEach(function(ifrDict, i) {
              if (ifrDict.val === currIfr) {
                key = i;
                handled = ifrDict.handled;
              }
            });
            if (this.compareNodeIframe(node, prevNode, currIfr)) {
              if (key === false && !handled) {
                ifr.push({
                  val: currIfr,
                  handled: true
                });
              } else if (key !== false && !handled) {
                ifr[key].handled = true;
              }
              return true;
            }
            if (key === false) {
              ifr.push({
                val: currIfr,
                handled: false
              });
            }
            return false;
          }
        }, {
          key: "handleOpenIframes",
          value: function handleOpenIframes(ifr, whatToShow, eCb, fCb) {
            var _this4 = this;
            ifr.forEach(function(ifrDict) {
              if (!ifrDict.handled) {
                _this4.getIframeContents(ifrDict.val, function(con) {
                  _this4.createInstanceOnIframe(con).forEachNode(whatToShow, eCb, fCb);
                });
              }
            });
          }
        }, {
          key: "iterateThroughNodes",
          value: function iterateThroughNodes(whatToShow, ctx, eachCb, filterCb, doneCb) {
            var _this5 = this;
            var itr = this.createIterator(ctx, whatToShow, filterCb);
            var ifr = [], elements = [], node = void 0, prevNode = void 0, retrieveNodes = function retrieveNodes2() {
              var _getIteratorNode = _this5.getIteratorNode(itr);
              prevNode = _getIteratorNode.prevNode;
              node = _getIteratorNode.node;
              return node;
            };
            while (retrieveNodes()) {
              if (this.iframes) {
                this.forEachIframe(ctx, function(currIfr) {
                  return _this5.checkIframeFilter(node, prevNode, currIfr, ifr);
                }, function(con) {
                  _this5.createInstanceOnIframe(con).forEachNode(whatToShow, function(ifrNode) {
                    return elements.push(ifrNode);
                  }, filterCb);
                });
              }
              elements.push(node);
            }
            elements.forEach(function(node2) {
              eachCb(node2);
            });
            if (this.iframes) {
              this.handleOpenIframes(ifr, whatToShow, eachCb, filterCb);
            }
            doneCb();
          }
        }, {
          key: "forEachNode",
          value: function forEachNode(whatToShow, each, filter) {
            var _this6 = this;
            var done = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : function() {
            };
            var contexts = this.getContexts();
            var open = contexts.length;
            if (!open) {
              done();
            }
            contexts.forEach(function(ctx) {
              var ready = function ready2() {
                _this6.iterateThroughNodes(whatToShow, ctx, each, filter, function() {
                  if (--open <= 0) {
                    done();
                  }
                });
              };
              if (_this6.iframes) {
                _this6.waitForIframes(ctx, ready);
              } else {
                ready();
              }
            });
          }
        }], [{
          key: "matches",
          value: function matches(element, selector) {
            var selectors = typeof selector === "string" ? [selector] : selector, fn2 = element.matches || element.matchesSelector || element.msMatchesSelector || element.mozMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector;
            if (fn2) {
              var match = false;
              selectors.every(function(sel) {
                if (fn2.call(element, sel)) {
                  match = true;
                  return false;
                }
                return true;
              });
              return match;
            } else {
              return false;
            }
          }
        }]);
        return DOMIterator2;
      })();
      var Mark$1 = (function() {
        function Mark3(ctx) {
          classCallCheck(this, Mark3);
          this.ctx = ctx;
          this.ie = false;
          var ua2 = window.navigator.userAgent;
          if (ua2.indexOf("MSIE") > -1 || ua2.indexOf("Trident") > -1) {
            this.ie = true;
          }
        }
        createClass(Mark3, [{
          key: "log",
          value: function log(msg) {
            var level = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "debug";
            var log2 = this.opt.log;
            if (!this.opt.debug) {
              return;
            }
            if ((typeof log2 === "undefined" ? "undefined" : _typeof(log2)) === "object" && typeof log2[level] === "function") {
              log2[level]("mark.js: " + msg);
            }
          }
        }, {
          key: "escapeStr",
          value: function escapeStr(str) {
            return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
          }
        }, {
          key: "createRegExp",
          value: function createRegExp(str) {
            if (this.opt.wildcards !== "disabled") {
              str = this.setupWildcardsRegExp(str);
            }
            str = this.escapeStr(str);
            if (Object.keys(this.opt.synonyms).length) {
              str = this.createSynonymsRegExp(str);
            }
            if (this.opt.ignoreJoiners || this.opt.ignorePunctuation.length) {
              str = this.setupIgnoreJoinersRegExp(str);
            }
            if (this.opt.diacritics) {
              str = this.createDiacriticsRegExp(str);
            }
            str = this.createMergedBlanksRegExp(str);
            if (this.opt.ignoreJoiners || this.opt.ignorePunctuation.length) {
              str = this.createJoinersRegExp(str);
            }
            if (this.opt.wildcards !== "disabled") {
              str = this.createWildcardsRegExp(str);
            }
            str = this.createAccuracyRegExp(str);
            return str;
          }
        }, {
          key: "createSynonymsRegExp",
          value: function createSynonymsRegExp(str) {
            var syn = this.opt.synonyms, sens = this.opt.caseSensitive ? "" : "i", joinerPlaceholder = this.opt.ignoreJoiners || this.opt.ignorePunctuation.length ? "\0" : "";
            for (var index2 in syn) {
              if (syn.hasOwnProperty(index2)) {
                var value = syn[index2], k1 = this.opt.wildcards !== "disabled" ? this.setupWildcardsRegExp(index2) : this.escapeStr(index2), k2 = this.opt.wildcards !== "disabled" ? this.setupWildcardsRegExp(value) : this.escapeStr(value);
                if (k1 !== "" && k2 !== "") {
                  str = str.replace(new RegExp("(" + this.escapeStr(k1) + "|" + this.escapeStr(k2) + ")", "gm" + sens), joinerPlaceholder + ("(" + this.processSynomyms(k1) + "|") + (this.processSynomyms(k2) + ")") + joinerPlaceholder);
                }
              }
            }
            return str;
          }
        }, {
          key: "processSynomyms",
          value: function processSynomyms(str) {
            if (this.opt.ignoreJoiners || this.opt.ignorePunctuation.length) {
              str = this.setupIgnoreJoinersRegExp(str);
            }
            return str;
          }
        }, {
          key: "setupWildcardsRegExp",
          value: function setupWildcardsRegExp(str) {
            str = str.replace(/(?:\\)*\?/g, function(val) {
              return val.charAt(0) === "\\" ? "?" : "";
            });
            return str.replace(/(?:\\)*\*/g, function(val) {
              return val.charAt(0) === "\\" ? "*" : "";
            });
          }
        }, {
          key: "createWildcardsRegExp",
          value: function createWildcardsRegExp(str) {
            var spaces = this.opt.wildcards === "withSpaces";
            return str.replace(/\u0001/g, spaces ? "[\\S\\s]?" : "\\S?").replace(/\u0002/g, spaces ? "[\\S\\s]*?" : "\\S*");
          }
        }, {
          key: "setupIgnoreJoinersRegExp",
          value: function setupIgnoreJoinersRegExp(str) {
            return str.replace(/[^(|)\\]/g, function(val, indx, original) {
              var nextChar = original.charAt(indx + 1);
              if (/[(|)\\]/.test(nextChar) || nextChar === "") {
                return val;
              } else {
                return val + "\0";
              }
            });
          }
        }, {
          key: "createJoinersRegExp",
          value: function createJoinersRegExp(str) {
            var joiner = [];
            var ignorePunctuation = this.opt.ignorePunctuation;
            if (Array.isArray(ignorePunctuation) && ignorePunctuation.length) {
              joiner.push(this.escapeStr(ignorePunctuation.join("")));
            }
            if (this.opt.ignoreJoiners) {
              joiner.push("\\u00ad\\u200b\\u200c\\u200d");
            }
            return joiner.length ? str.split(/\u0000+/).join("[" + joiner.join("") + "]*") : str;
          }
        }, {
          key: "createDiacriticsRegExp",
          value: function createDiacriticsRegExp(str) {
            var sens = this.opt.caseSensitive ? "" : "i", dct = this.opt.caseSensitive ? ["a\xE0\xE1\u1EA3\xE3\u1EA1\u0103\u1EB1\u1EAF\u1EB3\u1EB5\u1EB7\xE2\u1EA7\u1EA5\u1EA9\u1EAB\u1EAD\xE4\xE5\u0101\u0105", "A\xC0\xC1\u1EA2\xC3\u1EA0\u0102\u1EB0\u1EAE\u1EB2\u1EB4\u1EB6\xC2\u1EA6\u1EA4\u1EA8\u1EAA\u1EAC\xC4\xC5\u0100\u0104", "c\xE7\u0107\u010D", "C\xC7\u0106\u010C", "d\u0111\u010F", "D\u0110\u010E", "e\xE8\xE9\u1EBB\u1EBD\u1EB9\xEA\u1EC1\u1EBF\u1EC3\u1EC5\u1EC7\xEB\u011B\u0113\u0119", "E\xC8\xC9\u1EBA\u1EBC\u1EB8\xCA\u1EC0\u1EBE\u1EC2\u1EC4\u1EC6\xCB\u011A\u0112\u0118", "i\xEC\xED\u1EC9\u0129\u1ECB\xEE\xEF\u012B", "I\xCC\xCD\u1EC8\u0128\u1ECA\xCE\xCF\u012A", "l\u0142", "L\u0141", "n\xF1\u0148\u0144", "N\xD1\u0147\u0143", "o\xF2\xF3\u1ECF\xF5\u1ECD\xF4\u1ED3\u1ED1\u1ED5\u1ED7\u1ED9\u01A1\u1EDF\u1EE1\u1EDB\u1EDD\u1EE3\xF6\xF8\u014D", "O\xD2\xD3\u1ECE\xD5\u1ECC\xD4\u1ED2\u1ED0\u1ED4\u1ED6\u1ED8\u01A0\u1EDE\u1EE0\u1EDA\u1EDC\u1EE2\xD6\xD8\u014C", "r\u0159", "R\u0158", "s\u0161\u015B\u0219\u015F", "S\u0160\u015A\u0218\u015E", "t\u0165\u021B\u0163", "T\u0164\u021A\u0162", "u\xF9\xFA\u1EE7\u0169\u1EE5\u01B0\u1EEB\u1EE9\u1EED\u1EEF\u1EF1\xFB\xFC\u016F\u016B", "U\xD9\xDA\u1EE6\u0168\u1EE4\u01AF\u1EEA\u1EE8\u1EEC\u1EEE\u1EF0\xDB\xDC\u016E\u016A", "y\xFD\u1EF3\u1EF7\u1EF9\u1EF5\xFF", "Y\xDD\u1EF2\u1EF6\u1EF8\u1EF4\u0178", "z\u017E\u017C\u017A", "Z\u017D\u017B\u0179"] : ["a\xE0\xE1\u1EA3\xE3\u1EA1\u0103\u1EB1\u1EAF\u1EB3\u1EB5\u1EB7\xE2\u1EA7\u1EA5\u1EA9\u1EAB\u1EAD\xE4\xE5\u0101\u0105A\xC0\xC1\u1EA2\xC3\u1EA0\u0102\u1EB0\u1EAE\u1EB2\u1EB4\u1EB6\xC2\u1EA6\u1EA4\u1EA8\u1EAA\u1EAC\xC4\xC5\u0100\u0104", "c\xE7\u0107\u010DC\xC7\u0106\u010C", "d\u0111\u010FD\u0110\u010E", "e\xE8\xE9\u1EBB\u1EBD\u1EB9\xEA\u1EC1\u1EBF\u1EC3\u1EC5\u1EC7\xEB\u011B\u0113\u0119E\xC8\xC9\u1EBA\u1EBC\u1EB8\xCA\u1EC0\u1EBE\u1EC2\u1EC4\u1EC6\xCB\u011A\u0112\u0118", "i\xEC\xED\u1EC9\u0129\u1ECB\xEE\xEF\u012BI\xCC\xCD\u1EC8\u0128\u1ECA\xCE\xCF\u012A", "l\u0142L\u0141", "n\xF1\u0148\u0144N\xD1\u0147\u0143", "o\xF2\xF3\u1ECF\xF5\u1ECD\xF4\u1ED3\u1ED1\u1ED5\u1ED7\u1ED9\u01A1\u1EDF\u1EE1\u1EDB\u1EDD\u1EE3\xF6\xF8\u014DO\xD2\xD3\u1ECE\xD5\u1ECC\xD4\u1ED2\u1ED0\u1ED4\u1ED6\u1ED8\u01A0\u1EDE\u1EE0\u1EDA\u1EDC\u1EE2\xD6\xD8\u014C", "r\u0159R\u0158", "s\u0161\u015B\u0219\u015FS\u0160\u015A\u0218\u015E", "t\u0165\u021B\u0163T\u0164\u021A\u0162", "u\xF9\xFA\u1EE7\u0169\u1EE5\u01B0\u1EEB\u1EE9\u1EED\u1EEF\u1EF1\xFB\xFC\u016F\u016BU\xD9\xDA\u1EE6\u0168\u1EE4\u01AF\u1EEA\u1EE8\u1EEC\u1EEE\u1EF0\xDB\xDC\u016E\u016A", "y\xFD\u1EF3\u1EF7\u1EF9\u1EF5\xFFY\xDD\u1EF2\u1EF6\u1EF8\u1EF4\u0178", "z\u017E\u017C\u017AZ\u017D\u017B\u0179"];
            var handled = [];
            str.split("").forEach(function(ch2) {
              dct.every(function(dct2) {
                if (dct2.indexOf(ch2) !== -1) {
                  if (handled.indexOf(dct2) > -1) {
                    return false;
                  }
                  str = str.replace(new RegExp("[" + dct2 + "]", "gm" + sens), "[" + dct2 + "]");
                  handled.push(dct2);
                }
                return true;
              });
            });
            return str;
          }
        }, {
          key: "createMergedBlanksRegExp",
          value: function createMergedBlanksRegExp(str) {
            return str.replace(/[\s]+/gmi, "[\\s]+");
          }
        }, {
          key: "createAccuracyRegExp",
          value: function createAccuracyRegExp(str) {
            var _this = this;
            var chars = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~\xA1\xBF";
            var acc = this.opt.accuracy, val = typeof acc === "string" ? acc : acc.value, ls2 = typeof acc === "string" ? [] : acc.limiters, lsJoin = "";
            ls2.forEach(function(limiter) {
              lsJoin += "|" + _this.escapeStr(limiter);
            });
            switch (val) {
              case "partially":
              default:
                return "()(" + str + ")";
              case "complementary":
                lsJoin = "\\s" + (lsJoin ? lsJoin : this.escapeStr(chars));
                return "()([^" + lsJoin + "]*" + str + "[^" + lsJoin + "]*)";
              case "exactly":
                return "(^|\\s" + lsJoin + ")(" + str + ")(?=$|\\s" + lsJoin + ")";
            }
          }
        }, {
          key: "getSeparatedKeywords",
          value: function getSeparatedKeywords(sv) {
            var _this2 = this;
            var stack = [];
            sv.forEach(function(kw) {
              if (!_this2.opt.separateWordSearch) {
                if (kw.trim() && stack.indexOf(kw) === -1) {
                  stack.push(kw);
                }
              } else {
                kw.split(" ").forEach(function(kwSplitted) {
                  if (kwSplitted.trim() && stack.indexOf(kwSplitted) === -1) {
                    stack.push(kwSplitted);
                  }
                });
              }
            });
            return {
              "keywords": stack.sort(function(a, b2) {
                return b2.length - a.length;
              }),
              "length": stack.length
            };
          }
        }, {
          key: "isNumeric",
          value: function isNumeric(value) {
            return Number(parseFloat(value)) == value;
          }
        }, {
          key: "checkRanges",
          value: function checkRanges(array) {
            var _this3 = this;
            if (!Array.isArray(array) || Object.prototype.toString.call(array[0]) !== "[object Object]") {
              this.log("markRanges() will only accept an array of objects");
              this.opt.noMatch(array);
              return [];
            }
            var stack = [];
            var last = 0;
            array.sort(function(a, b2) {
              return a.start - b2.start;
            }).forEach(function(item) {
              var _callNoMatchOnInvalid = _this3.callNoMatchOnInvalidRanges(item, last), start = _callNoMatchOnInvalid.start, end = _callNoMatchOnInvalid.end, valid = _callNoMatchOnInvalid.valid;
              if (valid) {
                item.start = start;
                item.length = end - start;
                stack.push(item);
                last = end;
              }
            });
            return stack;
          }
        }, {
          key: "callNoMatchOnInvalidRanges",
          value: function callNoMatchOnInvalidRanges(range, last) {
            var start = void 0, end = void 0, valid = false;
            if (range && typeof range.start !== "undefined") {
              start = parseInt(range.start, 10);
              end = start + parseInt(range.length, 10);
              if (this.isNumeric(range.start) && this.isNumeric(range.length) && end - last > 0 && end - start > 0) {
                valid = true;
              } else {
                this.log("Ignoring invalid or overlapping range: " + ("" + JSON.stringify(range)));
                this.opt.noMatch(range);
              }
            } else {
              this.log("Ignoring invalid range: " + JSON.stringify(range));
              this.opt.noMatch(range);
            }
            return {
              start,
              end,
              valid
            };
          }
        }, {
          key: "checkWhitespaceRanges",
          value: function checkWhitespaceRanges(range, originalLength, string) {
            var end = void 0, valid = true, max = string.length, offset = originalLength - max, start = parseInt(range.start, 10) - offset;
            start = start > max ? max : start;
            end = start + parseInt(range.length, 10);
            if (end > max) {
              end = max;
              this.log("End range automatically set to the max value of " + max);
            }
            if (start < 0 || end - start < 0 || start > max || end > max) {
              valid = false;
              this.log("Invalid range: " + JSON.stringify(range));
              this.opt.noMatch(range);
            } else if (string.substring(start, end).replace(/\s+/g, "") === "") {
              valid = false;
              this.log("Skipping whitespace only range: " + JSON.stringify(range));
              this.opt.noMatch(range);
            }
            return {
              start,
              end,
              valid
            };
          }
        }, {
          key: "getTextNodes",
          value: function getTextNodes(cb) {
            var _this4 = this;
            var val = "", nodes = [];
            this.iterator.forEachNode(NodeFilter.SHOW_TEXT, function(node) {
              nodes.push({
                start: val.length,
                end: (val += node.textContent).length,
                node
              });
            }, function(node) {
              if (_this4.matchesExclude(node.parentNode)) {
                return NodeFilter.FILTER_REJECT;
              } else {
                return NodeFilter.FILTER_ACCEPT;
              }
            }, function() {
              cb({
                value: val,
                nodes
              });
            });
          }
        }, {
          key: "matchesExclude",
          value: function matchesExclude(el) {
            return DOMIterator.matches(el, this.opt.exclude.concat(["script", "style", "title", "head", "html"]));
          }
        }, {
          key: "wrapRangeInTextNode",
          value: function wrapRangeInTextNode(node, start, end) {
            var hEl = !this.opt.element ? "mark" : this.opt.element, startNode = node.splitText(start), ret = startNode.splitText(end - start);
            var repl = document.createElement(hEl);
            repl.setAttribute("data-markjs", "true");
            if (this.opt.className) {
              repl.setAttribute("class", this.opt.className);
            }
            repl.textContent = startNode.textContent;
            startNode.parentNode.replaceChild(repl, startNode);
            return ret;
          }
        }, {
          key: "wrapRangeInMappedTextNode",
          value: function wrapRangeInMappedTextNode(dict, start, end, filterCb, eachCb) {
            var _this5 = this;
            dict.nodes.every(function(n, i) {
              var sibl = dict.nodes[i + 1];
              if (typeof sibl === "undefined" || sibl.start > start) {
                if (!filterCb(n.node)) {
                  return false;
                }
                var s = start - n.start, e2 = (end > n.end ? n.end : end) - n.start, startStr = dict.value.substr(0, n.start), endStr = dict.value.substr(e2 + n.start);
                n.node = _this5.wrapRangeInTextNode(n.node, s, e2);
                dict.value = startStr + endStr;
                dict.nodes.forEach(function(k2, j) {
                  if (j >= i) {
                    if (dict.nodes[j].start > 0 && j !== i) {
                      dict.nodes[j].start -= e2;
                    }
                    dict.nodes[j].end -= e2;
                  }
                });
                end -= e2;
                eachCb(n.node.previousSibling, n.start);
                if (end > n.end) {
                  start = n.end;
                } else {
                  return false;
                }
              }
              return true;
            });
          }
        }, {
          key: "wrapMatches",
          value: function wrapMatches(regex, ignoreGroups, filterCb, eachCb, endCb) {
            var _this6 = this;
            var matchIdx = ignoreGroups === 0 ? 0 : ignoreGroups + 1;
            this.getTextNodes(function(dict) {
              dict.nodes.forEach(function(node) {
                node = node.node;
                var match = void 0;
                while ((match = regex.exec(node.textContent)) !== null && match[matchIdx] !== "") {
                  if (!filterCb(match[matchIdx], node)) {
                    continue;
                  }
                  var pos = match.index;
                  if (matchIdx !== 0) {
                    for (var i = 1; i < matchIdx; i++) {
                      pos += match[i].length;
                    }
                  }
                  node = _this6.wrapRangeInTextNode(node, pos, pos + match[matchIdx].length);
                  eachCb(node.previousSibling);
                  regex.lastIndex = 0;
                }
              });
              endCb();
            });
          }
        }, {
          key: "wrapMatchesAcrossElements",
          value: function wrapMatchesAcrossElements(regex, ignoreGroups, filterCb, eachCb, endCb) {
            var _this7 = this;
            var matchIdx = ignoreGroups === 0 ? 0 : ignoreGroups + 1;
            this.getTextNodes(function(dict) {
              var match = void 0;
              while ((match = regex.exec(dict.value)) !== null && match[matchIdx] !== "") {
                var start = match.index;
                if (matchIdx !== 0) {
                  for (var i = 1; i < matchIdx; i++) {
                    start += match[i].length;
                  }
                }
                var end = start + match[matchIdx].length;
                _this7.wrapRangeInMappedTextNode(dict, start, end, function(node) {
                  return filterCb(match[matchIdx], node);
                }, function(node, lastIndex) {
                  regex.lastIndex = lastIndex;
                  eachCb(node);
                });
              }
              endCb();
            });
          }
        }, {
          key: "wrapRangeFromIndex",
          value: function wrapRangeFromIndex(ranges, filterCb, eachCb, endCb) {
            var _this8 = this;
            this.getTextNodes(function(dict) {
              var originalLength = dict.value.length;
              ranges.forEach(function(range, counter) {
                var _checkWhitespaceRange = _this8.checkWhitespaceRanges(range, originalLength, dict.value), start = _checkWhitespaceRange.start, end = _checkWhitespaceRange.end, valid = _checkWhitespaceRange.valid;
                if (valid) {
                  _this8.wrapRangeInMappedTextNode(dict, start, end, function(node) {
                    return filterCb(node, range, dict.value.substring(start, end), counter);
                  }, function(node) {
                    eachCb(node, range);
                  });
                }
              });
              endCb();
            });
          }
        }, {
          key: "unwrapMatches",
          value: function unwrapMatches(node) {
            var parent = node.parentNode;
            var docFrag = document.createDocumentFragment();
            while (node.firstChild) {
              docFrag.appendChild(node.removeChild(node.firstChild));
            }
            parent.replaceChild(docFrag, node);
            if (!this.ie) {
              parent.normalize();
            } else {
              this.normalizeTextNode(parent);
            }
          }
        }, {
          key: "normalizeTextNode",
          value: function normalizeTextNode(node) {
            if (!node) {
              return;
            }
            if (node.nodeType === 3) {
              while (node.nextSibling && node.nextSibling.nodeType === 3) {
                node.nodeValue += node.nextSibling.nodeValue;
                node.parentNode.removeChild(node.nextSibling);
              }
            } else {
              this.normalizeTextNode(node.firstChild);
            }
            this.normalizeTextNode(node.nextSibling);
          }
        }, {
          key: "markRegExp",
          value: function markRegExp(regexp, opt) {
            var _this9 = this;
            this.opt = opt;
            this.log('Searching with expression "' + regexp + '"');
            var totalMatches = 0, fn2 = "wrapMatches";
            var eachCb = function eachCb2(element) {
              totalMatches++;
              _this9.opt.each(element);
            };
            if (this.opt.acrossElements) {
              fn2 = "wrapMatchesAcrossElements";
            }
            this[fn2](regexp, this.opt.ignoreGroups, function(match, node) {
              return _this9.opt.filter(node, match, totalMatches);
            }, eachCb, function() {
              if (totalMatches === 0) {
                _this9.opt.noMatch(regexp);
              }
              _this9.opt.done(totalMatches);
            });
          }
        }, {
          key: "mark",
          value: function mark(sv, opt) {
            var _this10 = this;
            this.opt = opt;
            var totalMatches = 0, fn2 = "wrapMatches";
            var _getSeparatedKeywords = this.getSeparatedKeywords(typeof sv === "string" ? [sv] : sv), kwArr = _getSeparatedKeywords.keywords, kwArrLen = _getSeparatedKeywords.length, sens = this.opt.caseSensitive ? "" : "i", handler = function handler2(kw) {
              var regex = new RegExp(_this10.createRegExp(kw), "gm" + sens), matches = 0;
              _this10.log('Searching with expression "' + regex + '"');
              _this10[fn2](regex, 1, function(term, node) {
                return _this10.opt.filter(node, kw, totalMatches, matches);
              }, function(element) {
                matches++;
                totalMatches++;
                _this10.opt.each(element);
              }, function() {
                if (matches === 0) {
                  _this10.opt.noMatch(kw);
                }
                if (kwArr[kwArrLen - 1] === kw) {
                  _this10.opt.done(totalMatches);
                } else {
                  handler2(kwArr[kwArr.indexOf(kw) + 1]);
                }
              });
            };
            if (this.opt.acrossElements) {
              fn2 = "wrapMatchesAcrossElements";
            }
            if (kwArrLen === 0) {
              this.opt.done(totalMatches);
            } else {
              handler(kwArr[0]);
            }
          }
        }, {
          key: "markRanges",
          value: function markRanges(rawRanges, opt) {
            var _this11 = this;
            this.opt = opt;
            var totalMatches = 0, ranges = this.checkRanges(rawRanges);
            if (ranges && ranges.length) {
              this.log("Starting to mark with the following ranges: " + JSON.stringify(ranges));
              this.wrapRangeFromIndex(ranges, function(node, range, match, counter) {
                return _this11.opt.filter(node, range, match, counter);
              }, function(element, range) {
                totalMatches++;
                _this11.opt.each(element, range);
              }, function() {
                _this11.opt.done(totalMatches);
              });
            } else {
              this.opt.done(totalMatches);
            }
          }
        }, {
          key: "unmark",
          value: function unmark(opt) {
            var _this12 = this;
            this.opt = opt;
            var sel = this.opt.element ? this.opt.element : "*";
            sel += "[data-markjs]";
            if (this.opt.className) {
              sel += "." + this.opt.className;
            }
            this.log('Removal selector "' + sel + '"');
            this.iterator.forEachNode(NodeFilter.SHOW_ELEMENT, function(node) {
              _this12.unwrapMatches(node);
            }, function(node) {
              var matchesSel = DOMIterator.matches(node, sel), matchesExclude = _this12.matchesExclude(node);
              if (!matchesSel || matchesExclude) {
                return NodeFilter.FILTER_REJECT;
              } else {
                return NodeFilter.FILTER_ACCEPT;
              }
            }, this.opt.done);
          }
        }, {
          key: "opt",
          set: function set$$1(val) {
            this._opt = _extends({}, {
              "element": "",
              "className": "",
              "exclude": [],
              "iframes": false,
              "iframesTimeout": 5e3,
              "separateWordSearch": true,
              "diacritics": true,
              "synonyms": {},
              "accuracy": "partially",
              "acrossElements": false,
              "caseSensitive": false,
              "ignoreJoiners": false,
              "ignoreGroups": 0,
              "ignorePunctuation": [],
              "wildcards": "disabled",
              "each": function each() {
              },
              "noMatch": function noMatch() {
              },
              "filter": function filter() {
                return true;
              },
              "done": function done() {
              },
              "debug": false,
              "log": window.console
            }, val);
          },
          get: function get$$1() {
            return this._opt;
          }
        }, {
          key: "iterator",
          get: function get$$1() {
            return new DOMIterator(this.ctx, this.opt.iframes, this.opt.exclude, this.opt.iframesTimeout);
          }
        }]);
        return Mark3;
      })();
      function Mark2(ctx) {
        var _this = this;
        var instance = new Mark$1(ctx);
        this.mark = function(sv, opt) {
          instance.mark(sv, opt);
          return _this;
        };
        this.markRegExp = function(sv, opt) {
          instance.markRegExp(sv, opt);
          return _this;
        };
        this.markRanges = function(sv, opt) {
          instance.markRanges(sv, opt);
          return _this;
        };
        this.unmark = function(opt) {
          instance.unmark(opt);
          return _this;
        };
        return this;
      }
      return Mark2;
    }));
  }
});

// src/HtmlPlugin.ts
var HtmlPlugin_exports = {};
__export(HtmlPlugin_exports, {
  default: () => HtmlPlugin
});
module.exports = __toCommonJS(HtmlPlugin_exports);
var import_obsidian3 = require("obsidian");

// src/HtmlView.ts
var import_obsidian2 = require("obsidian");

// src/HtmlPluginSettings.ts
var import_obsidian = require("obsidian");

// src/HtmlPluginOpMode.ts
var OP_MODE_INFO_DATA = {
  ["TextMode" /* Text */]: "Text Mode",
  ["HighRestrictedMode" /* HighRestricted */]: "High Restricted Mode",
  ["BalanceMode" /* Balance */]: "Balance Mode",
  ["LowRestrictedMode" /* LowRestricted */]: "Low Restricted Mode",
  ["UnestrictedMode" /* Unrestricted */]: "Unrestricted Mode"
};
var OP_MODE_INFO_HTML = `
<style>
  #ophCompTable {
    border: 1px solid var(--table-border-color);
    border-collapse: collapse;
    padding: 5px;
    margin: 5px;
  }
  #ophCompTable caption {
    border: 1px solid var(--table-border-color);
    padding: 5px;
    background: var(--background-primary-alt);
  }
  #ophCompTable th {
    border: 1px solid var(--table-border-color);
    padding: 5px;
    background: var(--background-modifier-hover);
  }
  #ophCompTable td {
    padding: 5px;
    text-align: center;
  }
  #ophCompTable span {
    font-weight: bold;
    float: right;
  }
  
  code {
    background: var(--code-background);
    font-family: -apple-system, BlinkMacSystemFont, var(--font-monospace);
  }  
</style>

<details>
<summary>Comparison</summary>
<table id="ophCompTable">
  <thead>
  <tr>
	<th> </th>
	<th>Images</th>
	<th>Styles</th>
	<th>Scripting</th>
	<th>DSD<sup>*</sup></th>
	<th>CSP<sup>#</sup></th>
	<th>HTML Sanitization</th>
	<th>Isolated</th>
  </tr>
  </thead>
  <tbody>
  <tr>
	<td><span> Text Mode </span></td>
	<td> No </td>
	<td> No </td>
	<td> No </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
  </tr>
  <tr>
	<td><span> High Restricted Mode </span></td>
	<td> Yes<sup>[1]</sup> </td>
	<td> Partial </td>
	<td> No </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
  </tr>
  <tr>
	<td><span> Balance Mode </span></td>
	<td> Yes </td>
	<td> Yes </td>
	<td> No </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes </td>
  </tr>
  <tr>
	<td><span> Low Restricted Mode </span></td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Partial<sup>[2]</sup> </td>
	<td> Yes </td>
	<td> No </td>
	<td> No </td>
	<td> Yes </td>
  </tr>
  <tr>
	<td><span> Unrestricted Mode </span></td>
	<td> Yes </td>
	<td> Yes </td>
	<td> Yes<sup>[3]</sup> </td>
	<td> Yes </td>
	<td> No </td>
	<td> No </td>
	<td> Yes </td>
  </tr>
  <tbody>
</table>

<div><b>*</b>: <a href="https://web.dev/declarative-shadow-dom/">Declarative Shadow DOM</a></div>
<div><b>#</b>: <a href="https://en.wikipedia.org/wiki/Content_Security_Policy">Content Security Policy</a></div>
<div>[1]: The external image sources would be blocked by CSP.</div>
<div>[2]: The script codes inside <code>&lt;script&gt;</code> and external script files are still not executable.</div>
<div>[3]: The external script files may not executable due to Obsidian's limitation.</div>
<br />
</details>

<details>
<summary>Detail Explanation</summary>
<ol>
  <li><b>Text Mode</b> - Highly recommended for the files came from untrusted source! This mode almost sanitized all visual effects, script codes, and styles out. Meanwhile, it keeps text parts for reading the content of HTML files with HTML layout elements.</li>
  <li><b>High Restricted Mode</b> - This mode recommended for the user who wants more security. It would keep custom elements but sanitize unsafe HTML elements out, as well as unsafe attributes and their contents. The external image sources would be blocked by CSP, and the images are only available from the HTML files themselves.</li>
  <li><b>Balance Mode</b> - This mode is the default mode for this plugin. It would keep all custom elements and HTML elements, but sanitize unsafe attributes and their contents out.</li>
  <li><b>Low Restricted Mode</b> - This mode would not sanitize anything, all elements and their content would be keeped. The script codes inside <code>&lt;script&gt;</code> still not executable, nor the external script files. </li>
  
  <li><b style="color: red;">Unrestricted Mode</b> - This mode is <b style="color: red;">very dangerous</b> and may cause the Obsidian app crash, <b style="color: red; text-transform: uppercase;">the Obsidian and this plugin cannot assume responsibility or liability for switching to this mode</b>. It would not sanitize anything, and all elements and their content would be keeped. The Obsidian app itself might adjust something. The external script files may not executable due to Obsidian's limitation. Strongly recommended not switching to this mode for normal usage.<br />
    If you encounter troubles after switch to this mode, it is recommended to take these recovery steps:
	<ul>
	  <li>Turn back to previous file which can open normally.</li>
	  <li><ins>Delete or move the bad opened file to trash can. Otherwise, Obsidian would still open it after re-launched.</ins></li>
	  <li>Return to this settings page to switch another Operating Mode.</li>
	</ul>
	<br />
	Sometimes you still cannot see what you want, then you should check the content of HTML file. This mode is just leave the content alone (only <ins>adjust the external link anchor tags to let them open in default browser windows</ins>), but the file might has some self-contained security protection facilities (such as CSP) and they would block something to avoid XSS attacks. If you find something like <code>&lt;meta http-equiv="Content-Security-Policy" /&gt;</code> inside the HTML file, it means the file is protected by CSP mechanism. You might 
	<ul>
	  <li>Modify or remove the CSP <code>&lt;meta&gt;</code> tag by hands.</li>
	  <li>Change the capture settings of the original web page saving app to disable CSP or something else, and re-save the web page.</li>
	</ul>
  </li>
</ol>
</details>
`;

// src/HtmlPluginSettings.ts
var DEFAULT_SETTINGS = {
  bgColorEnabled: false,
  bgColor: "#ffffff",
  opMode: "BalanceMode" /* Balance */,
  zoomByWheelAndGesture: true,
  zoomValue: 1,
  extraFileExt: "",
  mhtmlSupport: false
  // Support MHTML, Feature request #19
};
var HtmlSettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app2, plugin) {
    super(app2, plugin);
    this.app = app2;
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h1", { text: "HTML Reader Settings" });
    containerEl.createEl("pre", { text: "\u203B Remember to reload the file after changing any setting." }).setAttribute("style", "color:red");
    containerEl.createEl("h2", { text: "General Settings" });
    const opModeSetting = new import_obsidian.Setting(containerEl);
    opModeSetting.setName("Operating Mode").setDesc("Set operating mode for this plugin to protect user and app.").addDropdown((dropdown) => {
      dropdown.addOptions(OP_MODE_INFO_DATA);
      dropdown.setValue(this.plugin.settings.opMode).onChange(async (opMode) => {
        this.plugin.settings.opMode = opMode;
        await this.plugin.saveSettings();
      });
    });
    if (!this.opModeInfoFrag || this.opModeInfoFrag.childNodes.length <= 0) {
      this.opModeInfoFrag = new Range().createContextualFragment(OP_MODE_INFO_HTML);
    }
    opModeSetting.infoEl.appendChild(this.opModeInfoFrag.cloneNode(true));
    const bgColorSetting = new import_obsidian.Setting(containerEl);
    bgColorSetting.setName("Background Color").setDesc("Set HTML <body> element background color forcely.").addColorPicker((picker) => {
      picker.setValue(this.plugin.settings.bgColor).onChange(async (newColor) => {
        this.plugin.settings.bgColor = newColor;
        await this.plugin.saveSettings();
      });
    }).addToggle((toggle) => {
      toggle.setValue(this.plugin.settings.bgColorEnabled).onChange(async (enabled) => {
        this.plugin.settings.bgColorEnabled = enabled;
        await this.plugin.saveSettings();
      });
    });
    const extraFileExtSetting = new import_obsidian.Setting(containerEl);
    extraFileExtSetting.setName("Extra File Extensions").setDesc("Open HTML format files with user defined file extensions (list of comma separated strings). Change this setting may cause other plugins un-workable, so you shall know very clearly what you are doing. Remember to relaunch the Obsidian app after change this setting!").addText(
      (val) => val.setValue(this.plugin.settings.extraFileExt).setPlaceholder("e.g. xhtml, htm123").onChange(async (value) => {
        this.plugin.settings.extraFileExt = value;
        await this.plugin.saveSettings();
      })
    );
    const mhtmlSupportedSetting = new import_obsidian.Setting(containerEl);
    mhtmlSupportedSetting.setName("MHTML File Format Support").setDesc("Support with MHTML file format (.mht and .mhtml). Enable this option would convert the MHTML file format to HTML file format on the fly each time while opening the MHTML file. Therefore it would waste time on converting MHTML content! This option would override the 'Extra File Extensions' setting, and it also might cause other plugins un-workable. Remember to relaunch the Obsidian app after change this setting.").addToggle((toggle) => {
      toggle.setValue(this.plugin.settings.mhtmlSupport).onChange(async (enabled) => {
        this.plugin.settings.mhtmlSupport = enabled;
        await this.plugin.saveSettings();
      });
    });
    containerEl.createEl("h2", { text: "HotKeys and Touch Gestures Settings" });
    containerEl.createEl("small", { text: `Almost all keyboard hotkeys are taken from Obsidian's global hotkey settings, so you shall modify them via \u2699"Settings" \u21E8 "Hotkeys" options page.` });
    this.buildHotkeySettings();
    new import_obsidian.Setting(containerEl).setName("Quick document zoom in and out").setDesc("Zoom the document using Ctrl + Wheel (zoom in: \u2191, zoom out: \u2193), or using the trackpad/touch screen/touch panel two-finger pinch-zoom gesture (zoom in: \u2190 \u2192, zoom out: \u2192 \u2190).").addToggle((toggle) => {
      toggle.setValue(this.plugin.settings.zoomByWheelAndGesture).onChange(async (enabled) => {
        this.plugin.settings.zoomByWheelAndGesture = enabled;
        await this.plugin.saveSettings();
      });
    });
  }
  buildHotkeySettings() {
    const { containerEl } = this;
    let gSearch = this.app.hotkeyManager.getHotkeys("editor:open-search") || this.app.hotkeyManager.getDefaultHotkeys("editor:open-search");
    const hkSearch = new import_obsidian.Setting(containerEl);
    hkSearch.setName("Search document text").setDesc(`Search current file.`);
    let hotkeyPairs = [
      { elm: hkSearch, settings: gSearch }
    ];
    if (!this.app.isMobile) {
      let gZoomIn = this.app.hotkeyManager.getHotkeys("window:zoom-in") || this.app.hotkeyManager.getDefaultHotkeys("window:zoom-in");
      const hkZoomIn = new import_obsidian.Setting(containerEl).setName("Zoom in document").setDesc(`Zoom in current file.`);
      hotkeyPairs.push({ elm: hkZoomIn, settings: gZoomIn });
      let gZoomOut = this.app.hotkeyManager.getHotkeys("window:zoom-out") || this.app.hotkeyManager.getDefaultHotkeys("window:zoom-out");
      const hkZoomOut = new import_obsidian.Setting(containerEl).setName("Zoom out document").setDesc(`Zoom out current file.`);
      hotkeyPairs.push({ elm: hkZoomOut, settings: gZoomOut });
      let gZoomReset = this.app.hotkeyManager.getHotkeys("window:reset-zoom") || this.app.hotkeyManager.getDefaultHotkeys("window:reset-zoom");
      const hkZoomReset = new import_obsidian.Setting(containerEl).setName("Reset document zoom").setDesc(`Reset current file zoom.`);
      hotkeyPairs.push({ elm: hkZoomReset, settings: gZoomReset });
    }
    for (let pair of hotkeyPairs) {
      if (pair.settings && pair.settings.length > 0) {
        for (let i = 0; i < pair.settings.length; ++i) {
          if (i >= 2) {
            let eps = pair.elm.controlEl.createEl("span");
            eps.textContent = "...";
            break;
          }
          let hk = pair.settings[i];
          pair.elm.addButton((btn) => {
            if (hk.modifiers && hk.modifiers.length > 0)
              btn.setButtonText(`${this.toNativeModifierString(hk.modifiers, hk.key)}`);
            else
              btn.setButtonText(`${hk.key}`);
            btn.setDisabled(true);
          });
        }
      } else {
        pair.elm.addButton((btn) => {
          btn.setButtonText(`Blank`);
          btn.setDisabled(true);
        });
      }
    }
  }
  toNativeModifierString(modifiers, key) {
    if (isMacPlatform() || isIosPlatform()) {
      return modifiers.join("").replace("Mod", "\u2318").replace("Meta", "\u2318").replace("Shift", "\u21E7").replace("Alt", "\u2325").replace("Ctrl", "^").concat(key);
    } else {
      return modifiers.join(" + ").replace("Mod", "Ctrl").replace("Meta", "Win").concat(` + ${key}`);
    }
  }
};
function isMacPlatform() {
  const macosPlatforms = ["Macintosh", "MacIntel", "MacPPC", "Mac68K"];
  if (macosPlatforms.indexOf(window.navigator.platform) !== -1)
    return true;
  return false;
}
function isIosPlatform() {
  const iosPlatforms = ["iPhone", "iPad", "iPod"];
  const userAgent = window.navigator.userAgent;
  for (let plat of iosPlatforms)
    if (userAgent.contains(plat))
      return true;
  return false;
}

// node_modules/single-filez-core/processors/compression/compression-extract.js
async function extract(content, { password, prompt = () => {
}, shadowRootScriptURL, zipOptions = { useWebWorkers: false }, noBlobURL } = {}) {
  const KNOWN_MIMETYPES = {
    "gif": "image/gif",
    "jpg": "image/jpeg",
    "png": "image/png",
    "tif": "image/tiff",
    "tiff": "image/tiff",
    "bmp": "image/bmp",
    "ico": "image/vnd.microsoft.icon",
    "webp": "image/webp",
    "svg": "image/svg+xml",
    "avi": "video/x-msvideo",
    "ogv": "video/ogg",
    "mp4": "video/mp4",
    "mpeg": "video/mpeg",
    "ts": "video/mp2t",
    "webm": "video/webm",
    "3gp": "video/3gpp",
    "3g2": "video/3gpp",
    "mp3": "audio/mpeg",
    "oga": "audio/ogg",
    "mid": "audio/midi",
    "midi": "audio/midi",
    "opus": "audio/opus",
    "wav": "audio/wav",
    "weba": "audio/webm",
    "heif": "image/heif",
    "heic": "image/heic",
    "avif": "image/avif",
    "apng": "image/apng",
    "mov": "video/quicktime",
    "otf": "font/otf",
    "ttf": "font/ttf",
    "woff": "font/woff",
    "woff2": "font/woff2",
    "eot": "application/vnd.ms-fontobject",
    "pdf": "application/pdf"
  };
  const REGEXP_MATCH_STYLESHEET = /stylesheet_[0-9]+\.css/;
  const REGEXP_MATCH_SCRIPT = /scripts\/[0-9]+\.js/;
  const REGEXP_MATCH_ROOT_INDEX = /^([0-9_]+\/)?index\.html$/;
  const REGEXP_MATCH_INDEX = /index\.html$/;
  const REGEXP_MATCH_FRAMES = /frames\//;
  const REGEXP_MATCH_MANIFEST = /manifest\.json$/;
  const CHARSET_UTF82 = ";charset=utf-8";
  const REGEXP_ESCAPE = /([{}()^$&.*?/+|[\\\\]|\]|-)/g;
  if (Array.isArray(content)) {
    content = new Blob([new Uint8Array(content)]);
  }
  zip.configure(zipOptions);
  const blobReader = new zip.BlobReader(content);
  const zipReader = new zip.ZipReader(blobReader);
  const entries = await zipReader.getEntries();
  const options = { password };
  let docContent, origDocContent, url, resources = [], indexPages = [], textResources = [];
  await Promise.all(entries.map(async (entry) => {
    const { filename } = entry;
    let dataWriter, content2, textContent, mimeType;
    const resourceInfo = {};
    if (!options.password && entry.encrypted) {
      options.password = prompt("Please enter the password to view the page");
    }
    if (filename.match(REGEXP_MATCH_INDEX) || filename.match(REGEXP_MATCH_STYLESHEET) || filename.match(REGEXP_MATCH_SCRIPT)) {
      if (filename.match(REGEXP_MATCH_INDEX)) {
        indexPages.push(resourceInfo);
      } else {
        textResources.push(resourceInfo);
      }
      dataWriter = new zip.TextWriter();
      textContent = await entry.getData(dataWriter, options);
      if (filename.match(REGEXP_MATCH_INDEX)) {
        mimeType = "text/html" + CHARSET_UTF82;
      } else {
        if (filename.match(REGEXP_MATCH_STYLESHEET)) {
          mimeType = "text/css" + CHARSET_UTF82;
        } else if (filename.match(REGEXP_MATCH_SCRIPT)) {
          mimeType = "text/javascript" + CHARSET_UTF82;
        }
      }
    } else {
      resources.push(resourceInfo);
      const extension = filename.match(/\.([^.]+)/);
      if (extension && extension[1] && KNOWN_MIMETYPES[extension[1]]) {
        mimeType = KNOWN_MIMETYPES[extension[1]];
      } else {
        mimeType = "application/octet-stream";
      }
      if (filename.match(REGEXP_MATCH_FRAMES) || noBlobURL) {
        content2 = await entry.getData(new zip.Data64URIWriter(mimeType), options);
      } else {
        const blob = await entry.getData(new zip.BlobWriter(mimeType), options);
        content2 = URL.createObjectURL(blob);
      }
    }
    const name = entry.filename.match(/^([0-9_]+\/)?(.*)$/)[2];
    let prefixPath = "";
    const prefixPathMatch = filename.match(/(.*\/)[^/]+$/);
    if (prefixPathMatch && prefixPathMatch[1]) {
      prefixPath = prefixPathMatch[1];
    }
    Object.assign(resourceInfo, {
      prefixPath,
      filename: entry.filename,
      name,
      url: entry.comment,
      content: content2,
      mimeType,
      textContent,
      parentResources: []
    });
  }));
  await zipReader.close();
  indexPages.sort(sortByFilenameLengthDec);
  textResources.sort(sortByFilenameLengthInc);
  resources = resources.sort(sortByFilenameLengthDec).concat(...textResources).concat(...indexPages);
  for (const resource of resources) {
    const { filename, prefixPath } = resource;
    let { textContent } = resource;
    if (textContent !== void 0) {
      if (filename.match(REGEXP_MATCH_ROOT_INDEX)) {
        origDocContent = textContent;
      }
      if (!filename.match(REGEXP_MATCH_SCRIPT)) {
        resources.forEach((innerResource) => {
          const { filename: filename2, parentResources, content: content2 } = innerResource;
          if (filename2.startsWith(prefixPath) && filename2 != resource.filename) {
            const relativeFilename = filename2.substring(prefixPath.length);
            if (!relativeFilename.match(REGEXP_MATCH_MANIFEST)) {
              if (textContent.includes(relativeFilename)) {
                parentResources.push(resource.filename);
                if (innerResource.textContent === void 0) {
                  textContent = replaceAll(textContent, relativeFilename, content2);
                }
              }
            }
          }
        });
        resource.textContent = textContent;
      }
    }
  }
  for (const resource of resources) {
    let { textContent, prefixPath, filename } = resource;
    if (textContent !== void 0) {
      if (!filename.match(REGEXP_MATCH_SCRIPT)) {
        const resourceFilename = filename;
        for (const innerResource of resources) {
          const { filename: filename2 } = innerResource;
          if (filename2.startsWith(prefixPath) && filename2 != resourceFilename) {
            const relativeFilename = filename2.substring(prefixPath.length);
            if (!relativeFilename.match(REGEXP_MATCH_MANIFEST)) {
              const position = textContent.indexOf(relativeFilename);
              if (position != -1) {
                innerResource.content = await getContent(innerResource);
                textContent = replaceAll(textContent, relativeFilename, innerResource.content);
              }
            }
          }
        }
        resource.textContent = textContent;
        resource.content = await getContent(resource);
      }
      if (filename.match(REGEXP_MATCH_INDEX)) {
        if (shadowRootScriptURL) {
          resource.textContent = textContent.replace(/<script data-template-shadow-root.*<\/script>/g, "<script data-template-shadow-root src=" + shadowRootScriptURL + "><\/script>");
        }
      }
      if (filename.match(REGEXP_MATCH_ROOT_INDEX)) {
        docContent = textContent;
        url = resource.url;
      }
    }
  }
  return { docContent, origDocContent, resources, url };
  async function getContent(resource) {
    return resource.filename.match(REGEXP_MATCH_FRAMES) || noBlobURL ? await getDataURI(resource.textContent, resource.mimeType) : URL.createObjectURL(new Blob([resource.textContent], { type: resource.mimeType }));
  }
  async function getDataURI(textContent, mimeType) {
    const reader = new FileReader();
    reader.readAsDataURL(new Blob([textContent], { type: mimeType }));
    return new Promise((resolve, reject) => {
      reader.onload = () => resolve(reader.result.replace(CHARSET_UTF82, ""));
      reader.onerror = reject;
    });
  }
  function replaceAll(string, search, replacement) {
    if (typeof string.replaceAll == "function") {
      return string.replaceAll(search, replacement);
    } else {
      const searchRegExp = new RegExp(search.replace(REGEXP_ESCAPE, "\\$1"), "g");
      return string.replace(searchRegExp, replacement);
    }
  }
  function sortByFilenameLengthDec(resourceLeft, resourceRight) {
    const lengthDifference = resourceRight.filename.length - resourceLeft.filename.length;
    if (lengthDifference) {
      return lengthDifference;
    } else {
      return resourceRight.filename.localeCompare(resourceLeft.filename);
    }
  }
  function sortByFilenameLengthInc(resourceLeft, resourceRight) {
    const lengthDifference = resourceLeft.filename.length - resourceRight.filename.length;
    if (lengthDifference) {
      return lengthDifference;
    } else {
      return resourceLeft.filename.localeCompare(resourceRight.filename);
    }
  }
}

// node_modules/@zip.js/zip.js/index.js
var zip_exports = {};
__export(zip_exports, {
  BlobReader: () => BlobReader,
  BlobWriter: () => BlobWriter,
  Data64URIReader: () => Data64URIReader,
  Data64URIWriter: () => Data64URIWriter,
  ERR_BAD_FORMAT: () => ERR_BAD_FORMAT,
  ERR_CENTRAL_DIRECTORY_NOT_FOUND: () => ERR_CENTRAL_DIRECTORY_NOT_FOUND,
  ERR_DUPLICATED_NAME: () => ERR_DUPLICATED_NAME,
  ERR_ENCRYPTED: () => ERR_ENCRYPTED,
  ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND: () => ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND,
  ERR_EOCDR_NOT_FOUND: () => ERR_EOCDR_NOT_FOUND,
  ERR_EXTRAFIELD_ZIP64_NOT_FOUND: () => ERR_EXTRAFIELD_ZIP64_NOT_FOUND,
  ERR_HTTP_RANGE: () => ERR_HTTP_RANGE,
  ERR_INVALID_COMMENT: () => ERR_INVALID_COMMENT,
  ERR_INVALID_ENCRYPTION_STRENGTH: () => ERR_INVALID_ENCRYPTION_STRENGTH,
  ERR_INVALID_ENTRY_COMMENT: () => ERR_INVALID_ENTRY_COMMENT,
  ERR_INVALID_ENTRY_NAME: () => ERR_INVALID_ENTRY_NAME,
  ERR_INVALID_EXTRAFIELD_DATA: () => ERR_INVALID_EXTRAFIELD_DATA,
  ERR_INVALID_EXTRAFIELD_TYPE: () => ERR_INVALID_EXTRAFIELD_TYPE,
  ERR_INVALID_PASSWORD: () => ERR_INVALID_PASSWORD,
  ERR_INVALID_SIGNATURE: () => ERR_INVALID_SIGNATURE,
  ERR_INVALID_UNCOMPRESSED_SIZE: () => ERR_INVALID_UNCOMPRESSED_SIZE,
  ERR_INVALID_VERSION: () => ERR_INVALID_VERSION,
  ERR_LOCAL_FILE_HEADER_NOT_FOUND: () => ERR_LOCAL_FILE_HEADER_NOT_FOUND,
  ERR_OVERLAPPING_ENTRY: () => ERR_OVERLAPPING_ENTRY,
  ERR_SPLIT_ZIP_FILE: () => ERR_SPLIT_ZIP_FILE,
  ERR_UNDEFINED_UNCOMPRESSED_SIZE: () => ERR_UNDEFINED_UNCOMPRESSED_SIZE,
  ERR_UNSUPPORTED_COMPRESSION: () => ERR_UNSUPPORTED_COMPRESSION,
  ERR_UNSUPPORTED_ENCRYPTION: () => ERR_UNSUPPORTED_ENCRYPTION,
  ERR_UNSUPPORTED_FORMAT: () => ERR_UNSUPPORTED_FORMAT,
  ERR_ZIP_NOT_EMPTY: () => ERR_ZIP_NOT_EMPTY,
  HttpRangeReader: () => HttpRangeReader,
  HttpReader: () => HttpReader,
  Reader: () => Reader,
  SplitDataReader: () => SplitDataReader,
  SplitDataWriter: () => SplitDataWriter,
  TextReader: () => TextReader,
  TextWriter: () => TextWriter,
  Uint8ArrayReader: () => Uint8ArrayReader,
  Uint8ArrayWriter: () => Uint8ArrayWriter,
  Writer: () => Writer,
  ZipReader: () => ZipReader,
  ZipReaderStream: () => ZipReaderStream,
  ZipWriter: () => ZipWriter,
  ZipWriterStream: () => ZipWriterStream,
  configure: () => configure,
  fs: () => fs,
  getMimeType: () => getMimeType2,
  terminateWorkers: () => terminateWorkersAndModule
});

// node_modules/@zip.js/zip.js/lib/core/constants.js
var MAX_32_BITS = 4294967295;
var MAX_16_BITS = 65535;
var MAX_8_BITS = 255;
var COMPRESSION_METHOD_DEFLATE = 8;
var COMPRESSION_METHOD_DEFLATE_64 = 9;
var COMPRESSION_METHOD_STORE = 0;
var COMPRESSION_METHOD_AES = 99;
var LOCAL_FILE_HEADER_SIGNATURE = 67324752;
var SPLIT_ZIP_FILE_SIGNATURE = 134695760;
var DATA_DESCRIPTOR_RECORD_SIGNATURE = SPLIT_ZIP_FILE_SIGNATURE;
var CENTRAL_FILE_HEADER_SIGNATURE = 33639248;
var END_OF_CENTRAL_DIR_SIGNATURE = 101010256;
var ZIP64_END_OF_CENTRAL_DIR_SIGNATURE = 101075792;
var ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE = 117853008;
var END_OF_CENTRAL_DIR_LENGTH = 22;
var ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH = 20;
var ZIP64_END_OF_CENTRAL_DIR_LENGTH = 56;
var ZIP64_END_OF_CENTRAL_DIR_TOTAL_LENGTH = END_OF_CENTRAL_DIR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LENGTH;
var DATA_DESCRIPTOR_RECORD_LENGTH = 12;
var DATA_DESCRIPTOR_RECORD_ZIP_64_LENGTH = 20;
var DATA_DESCRIPTOR_RECORD_SIGNATURE_LENGTH = 4;
var EXTRAFIELD_TYPE_ZIP64 = 1;
var EXTRAFIELD_TYPE_AES = 39169;
var EXTRAFIELD_TYPE_NTFS = 10;
var EXTRAFIELD_TYPE_NTFS_TAG1 = 1;
var EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP = 21589;
var EXTRAFIELD_TYPE_UNICODE_PATH = 28789;
var EXTRAFIELD_TYPE_UNICODE_COMMENT = 25461;
var EXTRAFIELD_TYPE_USDZ = 6534;
var EXTRAFIELD_TYPE_INFOZIP = 30837;
var EXTRAFIELD_TYPE_UNIX = 30805;
var BITFLAG_ENCRYPTED = 1;
var BITFLAG_LEVEL = 6;
var BITFLAG_LEVEL_MAX_MASK = 2;
var BITFLAG_LEVEL_FAST_MASK = 4;
var BITFLAG_LEVEL_SUPER_FAST_MASK = 6;
var BITFLAG_DATA_DESCRIPTOR = 8;
var BITFLAG_LANG_ENCODING_FLAG = 2048;
var FILE_ATTR_MSDOS_DIR_MASK = 16;
var FILE_ATTR_MSDOS_READONLY_MASK = 1;
var FILE_ATTR_MSDOS_HIDDEN_MASK = 2;
var FILE_ATTR_MSDOS_SYSTEM_MASK = 4;
var FILE_ATTR_MSDOS_ARCHIVE_MASK = 32;
var FILE_ATTR_UNIX_TYPE_MASK = 61440;
var FILE_ATTR_UNIX_TYPE_DIR = 16384;
var FILE_ATTR_UNIX_EXECUTABLE_MASK = 73;
var FILE_ATTR_UNIX_DEFAULT_MASK = 420;
var FILE_ATTR_UNIX_SETUID_MASK = 2048;
var FILE_ATTR_UNIX_SETGID_MASK = 1024;
var FILE_ATTR_UNIX_STICKY_MASK = 512;
var VERSION_DEFLATE = 20;
var VERSION_ZIP64 = 45;
var VERSION_AES = 51;
var DIRECTORY_SIGNATURE = "/";
var HEADER_SIZE = 30;
var HEADER_OFFSET_SIGNATURE = 10;
var HEADER_OFFSET_COMPRESSED_SIZE = 14;
var HEADER_OFFSET_UNCOMPRESSED_SIZE = 18;
var MAX_DATE = new Date(2107, 11, 31);
var MIN_DATE = new Date(1980, 0, 1);
var UNDEFINED_VALUE = void 0;
var UNDEFINED_TYPE = "undefined";
var FUNCTION_TYPE = "function";
var OBJECT_TYPE = "object";

// node_modules/@zip.js/zip.js/lib/core/configuration.js
var MINIMUM_CHUNK_SIZE = 64;
var maxWorkers = 2;
try {
  if (typeof navigator != UNDEFINED_TYPE && navigator.hardwareConcurrency) {
    maxWorkers = navigator.hardwareConcurrency;
  }
} catch {
}
var DEFAULT_CONFIGURATION = {
  workerURI: "./core/web-worker-wasm.js",
  wasmURI: "./core/streams/zlib-wasm/zlib-streams.wasm",
  chunkSize: 64 * 1024,
  maxWorkers,
  terminateWorkerTimeout: 5e3,
  useWebWorkers: true,
  useCompressionStream: true,
  CompressionStream: typeof CompressionStream != UNDEFINED_TYPE && CompressionStream,
  DecompressionStream: typeof DecompressionStream != UNDEFINED_TYPE && DecompressionStream
};
var config = Object.assign({}, DEFAULT_CONFIGURATION);
function getConfiguration() {
  return config;
}
function getChunkSize(config2) {
  return Math.max(config2.chunkSize, MINIMUM_CHUNK_SIZE);
}
function configure(configuration) {
  const {
    baseURI,
    chunkSize,
    maxWorkers: maxWorkers2,
    terminateWorkerTimeout,
    useCompressionStream,
    useWebWorkers,
    CompressionStream: CompressionStream2,
    DecompressionStream: DecompressionStream2,
    CompressionStreamZlib: CompressionStreamZlib2,
    DecompressionStreamZlib: DecompressionStreamZlib2,
    workerURI,
    wasmURI
  } = configuration;
  setIfDefined("baseURI", baseURI);
  setIfDefined("wasmURI", wasmURI);
  setIfDefined("workerURI", workerURI);
  setIfDefined("chunkSize", chunkSize);
  setIfDefined("maxWorkers", maxWorkers2);
  setIfDefined("terminateWorkerTimeout", terminateWorkerTimeout);
  setIfDefined("useCompressionStream", useCompressionStream);
  setIfDefined("useWebWorkers", useWebWorkers);
  setIfDefined("CompressionStream", CompressionStream2);
  setIfDefined("DecompressionStream", DecompressionStream2);
  setIfDefined("CompressionStreamZlib", CompressionStreamZlib2);
  setIfDefined("DecompressionStreamZlib", DecompressionStreamZlib2);
}
function setIfDefined(propertyName, propertyValue) {
  if (propertyValue !== UNDEFINED_VALUE) {
    config[propertyName] = propertyValue;
  }
}

// node_modules/@zip.js/zip.js/lib/core/web-worker-inline-wasm.js
function t(t2) {
  let e2;
  t2({ workerURI: () => (e2 || (e2 = "data:text/javascript," + encodeURIComponent('(t=>{"function"==typeof define&&define.amd?define(t):t()})(function(){"use strict";const{Array:t,Object:e,Number:n,Math:s,Error:r,Uint8Array:o,Uint16Array:i,Uint32Array:c,Int32Array:a,Map:h,DataView:f,Promise:l,TextEncoder:u,crypto:w,postMessage:p,TransformStream:d,ReadableStream:y,WritableStream:m,CompressionStream:g,DecompressionStream:S}=self,b=void 0,v="undefined",k="function",z=[];for(let t=0;256>t;t++){let e=t;for(let t=0;8>t;t++)1&e?e=e>>>1^3988292384:e>>>=1;z[t]=e}class C{constructor(t){this.t=t||-1}append(t){let e=0|this.t;for(let n=0,s=0|t.length;s>n;n++)e=e>>>8^z[255&(e^t[n])];this.t=e}get(){return~this.t}}class A extends d{constructor(){let t;const e=new C;super({transform(t,n){e.append(t),n.enqueue(t)},flush(){const n=new o(4);new f(n.buffer).setUint32(0,e.get()),t.value=n}}),t=this}}const x={concat(t,e){if(0===t.length||0===e.length)return t.concat(e);const n=t[t.length-1],s=x.o(n);return 32===s?t.concat(e):x.i(e,s,0|n,t.slice(0,t.length-1))},h(t){const e=t.length;if(0===e)return 0;const n=t[e-1];return 32*(e-1)+x.o(n)},l(t,e){if(32*t.length<e)return t;const n=(t=t.slice(0,s.ceil(e/32))).length;return e&=31,n>0&&e&&(t[n-1]=x.u(e,t[n-1]&2147483648>>e-1,1)),t},u:(t,e,n)=>32===t?e:(n?0|e:e<<32-t)+1099511627776*t,o:t=>s.round(t/1099511627776)||32,i(t,e,n,s){for(void 0===s&&(s=[]);e>=32;e-=32)s.push(n),n=0;if(0===e)return s.concat(t);for(let r=0;r<t.length;r++)s.push(n|t[r]>>>e),n=t[r]<<32-e;const r=t.length?t[t.length-1]:0,o=x.o(r);return s.push(x.u(e+o&31,e+o>32?n:s.pop(),1)),s}},I={bytes:{p(t){const e=x.h(t)/8,n=new o(e);let s;for(let r=0;e>r;r++)3&r||(s=t[r/4]),n[r]=s>>>24,s<<=8;return n},m(t){const e=[];let n,s=0;for(n=0;n<t.length;n++)s=s<<8|t[n],3&~n||(e.push(s),s=0);return 3&n&&e.push(x.u(8*(3&n),s)),e}}},R=class{constructor(t){const e=this;e.blockSize=512,e.S=[1732584193,4023233417,2562383102,271733878,3285377520],e.v=[1518500249,1859775393,2400959708,3395469782],t?(e.k=t.k.slice(0),e.C=t.C.slice(0),e.A=t.A):e.reset()}reset(){const t=this;return t.k=t.S.slice(0),t.C=[],t.A=0,t}update(t){const e=this;"string"==typeof t&&(t=I.I.m(t));const n=e.C=x.concat(e.C,t),s=e.A,o=e.A=s+x.h(t);if(o>9007199254740991)throw new r("Cannot hash more than 2^53 - 1 bits");const i=new c(n);let a=0;for(let t=e.blockSize+s-(e.blockSize+s&e.blockSize-1);o>=t;t+=e.blockSize)e.R(i.subarray(16*a,16*(a+1))),a+=1;return n.splice(0,16*a),e}P(){const t=this;let e=t.C;const n=t.k;e=x.concat(e,[x.u(1,1)]);for(let t=e.length+2;15&t;t++)e.push(0);for(e.push(s.floor(t.A/4294967296)),e.push(0|t.A);e.length;)t.R(e.splice(0,16));return t.reset(),n}U(t,e,n,s){return t>19?t>39?t>59?t>79?void 0:e^n^s:e&n|e&s|n&s:e^n^s:e&n|~e&s}V(t,e){return e<<t|e>>>32-t}R(e){const n=this,r=n.k,o=t(80);for(let t=0;16>t;t++)o[t]=e[t];let i=r[0],c=r[1],a=r[2],h=r[3],f=r[4];for(let t=0;79>=t;t++){16>t||(o[t]=n.V(1,o[t-3]^o[t-8]^o[t-14]^o[t-16]));const e=n.V(5,i)+n.U(t,c,a,h)+f+o[t]+n.v[s.floor(t/20)]|0;f=h,h=a,a=n.V(30,c),c=i,i=e}r[0]=r[0]+i|0,r[1]=r[1]+c|0,r[2]=r[2]+a|0,r[3]=r[3]+h|0,r[4]=r[4]+f|0}},P={getRandomValues(t){const e=new c(t.buffer),n=t=>{let e=987654321;const n=4294967295;return()=>(e=36969*(65535&e)+(e>>16)&n,(((e<<16)+(t=18e3*(65535&t)+(t>>16)&n)&n)/4294967296+.5)*(s.random()>.5?1:-1))};for(let r,o=0;o<t.length;o+=4){const t=n(4294967296*(r||s.random()));r=987654071*t(),e[o/4]=4294967296*t()|0}return t}},U={importKey:t=>new U.M(I.bytes.m(t)),_(t,e,n,s){if(n=n||1e4,0>s||0>n)throw new r("invalid params to pbkdf2");const o=1+(s>>5)<<2;let i,c,a,h,l;const u=new ArrayBuffer(o),w=new f(u);let p=0;const d=x;for(e=I.bytes.m(e),l=1;(o||1)>p;l++){for(i=c=t.encrypt(d.concat(e,[l])),a=1;n>a;a++)for(c=t.encrypt(c),h=0;h<c.length;h++)i[h]^=c[h];for(a=0;(o||1)>p&&a<i.length;a++)w.setInt32(p,i[a]),p+=4}return u.slice(0,s/8)},M:class{constructor(t){const e=this,n=e.B=R,s=[[],[]];e.D=[new n,new n];const r=e.D[0].blockSize/32;t.length>r&&(t=(new n).update(t).P());for(let e=0;r>e;e++)s[0][e]=909522486^t[e],s[1][e]=1549556828^t[e];e.D[0].update(s[0]),e.D[1].update(s[1]),e.W=new n(e.D[0])}reset(){const t=this;t.W=new t.B(t.D[0]),t.K=!1}update(t){this.K=!0,this.W.update(t)}digest(){const t=this,e=t.W.P(),n=new t.B(t.D[1]).update(e).P();return t.reset(),n}encrypt(t){if(this.K)throw new r("encrypt on already updated hmac called!");return this.update(t),this.digest(t)}}},V=typeof w!=v&&typeof w.getRandomValues==k,M="Invalid password",_="Invalid signature",B="zipjs-abort-check-password";function D(t){return V?w.getRandomValues(t):P.getRandomValues(t)}const W=16,K={name:"PBKDF2"},E=e.assign({hash:{name:"HMAC"}},K),L=e.assign({iterations:1e3,hash:{name:"SHA-1"}},K),O=["deriveBits"],T=[8,12,16],j=[16,24,32],H=10,Z=[0,0,0,0],F=typeof w!=v,N=F&&w.subtle,q=F&&typeof N!=v,G=I.bytes,J=class{constructor(t){const e=this;e.L=[[[],[],[],[],[]],[[],[],[],[],[]]],e.L[0][0][0]||e.O();const n=e.L[0][4],s=e.L[1],o=t.length;let i,c,a,h=1;if(4!==o&&6!==o&&8!==o)throw new r("invalid aes key size");for(e.v=[c=t.slice(0),a=[]],i=o;4*o+28>i;i++){let t=c[i-1];(i%o===0||8===o&&i%o===4)&&(t=n[t>>>24]<<24^n[t>>16&255]<<16^n[t>>8&255]<<8^n[255&t],i%o===0&&(t=t<<8^t>>>24^h<<24,h=h<<1^283*(h>>7))),c[i]=c[i-o]^t}for(let t=0;i;t++,i--){const e=c[3&t?i:i-4];a[t]=4>=i||4>t?e:s[0][n[e>>>24]]^s[1][n[e>>16&255]]^s[2][n[e>>8&255]]^s[3][n[255&e]]}}encrypt(t){return this.T(t,0)}decrypt(t){return this.T(t,1)}O(){const t=this.L[0],e=this.L[1],n=t[4],s=e[4],r=[],o=[];let i,c,a,h;for(let t=0;256>t;t++)o[(r[t]=t<<1^283*(t>>7))^t]=t;for(let f=i=0;!n[f];f^=c||1,i=o[i]||1){let o=i^i<<1^i<<2^i<<3^i<<4;o=o>>8^255&o^99,n[f]=o,s[o]=f,h=r[a=r[c=r[f]]];let l=16843009*h^65537*a^257*c^16843008*f,u=257*r[o]^16843008*o;for(let n=0;4>n;n++)t[n][f]=u=u<<24^u>>>8,e[n][o]=l=l<<24^l>>>8}for(let n=0;5>n;n++)t[n]=t[n].slice(0),e[n]=e[n].slice(0)}T(t,e){if(4!==t.length)throw new r("invalid aes block size");const n=this.v[e],s=n.length/4-2,o=[0,0,0,0],i=this.L[e],c=i[0],a=i[1],h=i[2],f=i[3],l=i[4];let u,w,p,d=t[0]^n[0],y=t[e?3:1]^n[1],m=t[2]^n[2],g=t[e?1:3]^n[3],S=4;for(let t=0;s>t;t++)u=c[d>>>24]^a[y>>16&255]^h[m>>8&255]^f[255&g]^n[S],w=c[y>>>24]^a[m>>16&255]^h[g>>8&255]^f[255&d]^n[S+1],p=c[m>>>24]^a[g>>16&255]^h[d>>8&255]^f[255&y]^n[S+2],g=c[g>>>24]^a[d>>16&255]^h[y>>8&255]^f[255&m]^n[S+3],S+=4,d=u,y=w,m=p;for(let t=0;4>t;t++)o[e?3&-t:t]=l[d>>>24]<<24^l[y>>16&255]<<16^l[m>>8&255]<<8^l[255&g]^n[S++],u=d,d=y,y=m,m=g,g=u;return o}},Q=class{constructor(t,e){this.j=t,this.H=e,this.Z=e}reset(){this.Z=this.H}update(t){return this.F(this.j,t,this.Z)}N(t){if(255&~(t>>24))t+=1<<24;else{let e=t>>16&255,n=t>>8&255,s=255&t;255===e?(e=0,255===n?(n=0,255===s?s=0:++s):++n):++e,t=0,t+=e<<16,t+=n<<8,t+=s}return t}q(t){0===(t[0]=this.N(t[0]))&&(t[1]=this.N(t[1]))}F(t,e,n){let s;if(!(s=e.length))return[];const r=x.h(e);for(let r=0;s>r;r+=4){this.q(n);const s=t.encrypt(n);e[r]^=s[0],e[r+1]^=s[1],e[r+2]^=s[2],e[r+3]^=s[3]}return x.l(e,r)}},X=U.M;let Y=F&&q&&typeof N.importKey==k,$=F&&q&&typeof N.deriveBits==k;class tt extends d{constructor({password:t,rawPassword:n,signed:s,encryptionStrength:i,checkPasswordOnly:c}){super({start(){e.assign(this,{ready:new l(t=>this.G=t),password:rt(t,n),signed:s,J:i-1,pending:new o})},async transform(t,e){const n=this,{password:s,J:i,G:a,ready:h}=n;s?(await(async(t,e,n,s)=>{const o=await st(t,e,n,it(s,0,T[e])),i=it(s,T[e]);if(o[0]!=i[0]||o[1]!=i[1])throw new r(M)})(n,i,s,it(t,0,T[i]+2)),t=it(t,T[i]+2),c?e.error(new r(B)):a()):await h;const f=new o(t.length-H-(t.length-H)%W);e.enqueue(nt(n,t,f,0,H,!0))},async flush(t){const{signed:e,X:n,Y:s,pending:i,ready:c}=this;if(s&&n){await c;const a=it(i,0,i.length-H),h=it(i,i.length-H);let f=new o;if(a.length){const t=at(G,a);s.update(t);const e=n.update(t);f=ct(G,e)}if(e){const t=it(ct(G,s.digest()),0,H);for(let e=0;H>e;e++)if(t[e]!=h[e])throw new r(_)}t.enqueue(f)}}})}}class et extends d{constructor({password:t,rawPassword:n,encryptionStrength:s}){let r;super({start(){e.assign(this,{ready:new l(t=>this.G=t),password:rt(t,n),J:s-1,pending:new o})},async transform(t,e){const n=this,{password:s,J:r,G:i,ready:c}=n;let a=new o;s?(a=await(async(t,e,n)=>{const s=D(new o(T[e]));return ot(s,await st(t,e,n,s))})(n,r,s),i()):await c;const h=new o(a.length+t.length-t.length%W);h.set(a,0),e.enqueue(nt(n,t,h,a.length,0))},async flush(t){const{X:e,Y:n,pending:s,ready:i}=this;if(n&&e){await i;let c=new o;if(s.length){const t=e.update(at(G,s));n.update(t),c=ct(G,t)}r.signature=ct(G,n.digest()).slice(0,H),t.enqueue(ot(c,r.signature))}}}),r=this}}function nt(t,e,n,s,r,i){const{X:c,Y:a,pending:h}=t,f=e.length-r;let l;for(h.length&&(e=ot(h,e),n=((t,e)=>{if(e&&e>t.length){const n=t;(t=new o(e)).set(n,0)}return t})(n,f-f%W)),l=0;f-W>=l;l+=W){const t=at(G,it(e,l,l+W));i&&a.update(t);const r=c.update(t);i||a.update(r),n.set(ct(G,r),l+s)}return t.pending=it(e,l),n}async function st(n,s,r,i){n.password=null;const c=await(async(t,e,n,s,r)=>{if(!Y)return U.importKey(e);try{return await N.importKey("raw",e,n,!1,r)}catch{return Y=!1,U.importKey(e)}})(0,r,E,0,O),a=await(async(t,e,n)=>{if(!$)return U._(e,t.salt,L.iterations,n);try{return await N.deriveBits(t,e,n)}catch{return $=!1,U._(e,t.salt,L.iterations,n)}})(e.assign({salt:i},L),c,8*(2*j[s]+2)),h=new o(a),f=at(G,it(h,0,j[s])),l=at(G,it(h,j[s],2*j[s])),u=it(h,2*j[s]);return e.assign(n,{keys:{key:f,$:l,passwordVerification:u},X:new Q(new J(f),t.from(Z)),Y:new X(l)}),u}function rt(t,e){return e===b?(t=>{if(typeof u==v){const e=new o((t=unescape(encodeURIComponent(t))).length);for(let n=0;n<e.length;n++)e[n]=t.charCodeAt(n);return e}return(new u).encode(t)})(t):e}function ot(t,e){let n=t;return t.length+e.length&&(n=new o(t.length+e.length),n.set(t,0),n.set(e,t.length)),n}function it(t,e,n){return t.subarray(e,n)}function ct(t,e){return t.p(e)}function at(t,e){return t.m(e)}class ht extends d{constructor({password:t,passwordVerification:n,checkPasswordOnly:s}){super({start(){e.assign(this,{password:t,passwordVerification:n}),wt(this,t)},transform(t,e){const n=this;if(n.password){const e=lt(n,t.subarray(0,12));if(n.password=null,e.at(-1)!=n.passwordVerification)throw new r(M);t=t.subarray(12)}s?e.error(new r(B)):e.enqueue(lt(n,t))}})}}class ft extends d{constructor({password:t,passwordVerification:n}){super({start(){e.assign(this,{password:t,passwordVerification:n}),wt(this,t)},transform(t,e){const n=this;let s,r;if(n.password){n.password=null;const e=D(new o(12));e[11]=n.passwordVerification,s=new o(t.length+e.length),s.set(ut(n,e),0),r=12}else s=new o(t.length),r=0;s.set(ut(n,t),r),e.enqueue(s)}})}}function lt(t,e){const n=new o(e.length);for(let s=0;s<e.length;s++)n[s]=dt(t)^e[s],pt(t,n[s]);return n}function ut(t,e){const n=new o(e.length);for(let s=0;s<e.length;s++)n[s]=dt(t)^e[s],pt(t,e[s]);return n}function wt(t,n){const s=[305419896,591751049,878082192];e.assign(t,{keys:s,tt:new C(s[0]),et:new C(s[2])});for(let e=0;e<n.length;e++)pt(t,n.charCodeAt(e))}function pt(t,e){let[n,r,o]=t.keys;t.tt.append([e]),n=~t.tt.get(),r=mt(s.imul(mt(r+yt(n)),134775813)+1),t.et.append([r>>>24]),o=~t.et.get(),t.keys=[n,r,o]}function dt(t){const e=2|t.keys[2];return yt(s.imul(e,1^e)>>>8)}function yt(t){return 255&t}function mt(t){return 4294967295&t}class gt extends d{constructor(t,{chunkSize:e,nt:n,CompressionStream:s}){super({});const{compressed:r,encrypted:o,useCompressionStream:i,zipCrypto:c,signed:a,level:h}=t,l=this;let u,w,p=super.readable;o&&!c||!a||(u=new A,p=kt(p,u)),r&&(p=vt(p,i,{level:h,chunkSize:e},s,n,s)),o&&(c?p=kt(p,new ft(t)):(w=new et(t),p=kt(p,w))),bt(l,p,()=>{let t;o&&!c&&(t=w.signature),o&&!c||!a||(t=new f(u.value.buffer).getUint32(0)),l.signature=t})}}class St extends d{constructor(t,{chunkSize:e,st:n,DecompressionStream:s}){super({});const{zipCrypto:o,encrypted:i,signed:c,signature:a,compressed:h,useCompressionStream:l,rt:u}=t;let w,p,d=super.readable;i&&(o?d=kt(d,new ht(t)):(p=new tt(t),d=kt(d,p))),h&&(d=vt(d,l,{chunkSize:e,rt:u},s,n,s)),i&&!o||!c||(w=new A,d=kt(d,w)),bt(this,d,()=>{if((!i||o)&&c){const t=new f(w.value.buffer);if(a!=t.getUint32(0,!1))throw new r(_)}})}}function bt(t,n,s){n=kt(n,new d({flush:s})),e.defineProperty(t,"readable",{get:()=>n})}function vt(t,e,n,s,r,o){const i=e&&s?s:r||o,c=n.rt?"deflate64-raw":"deflate-raw";try{t=kt(t,new i(c,n))}catch(s){if(!e)throw s;if(r)t=kt(t,new r(c,n));else{if(!o)throw s;t=kt(t,new o(c,n))}}return t}function kt(t,e){return t.pipeThrough(e)}const zt="data",Ct="close";class At extends d{constructor(t,n){super({});const s=this,{codecType:o}=t;let i;o.startsWith("deflate")?i=gt:o.startsWith("inflate")&&(i=St),s.outputSize=0;let c=0;const a=new i(t,n),h=super.readable,f=new d({transform(t,e){t&&t.length&&(c+=t.length,e.enqueue(t))},flush(){e.assign(s,{inputSize:c})}}),l=new d({transform(e,n){if(e&&e.length&&(n.enqueue(e),s.outputSize+=e.length,t.outputSize!==b&&s.outputSize>t.outputSize))throw new r("Invalid uncompressed size")},flush(){const{signature:t}=a;e.assign(s,{signature:t,inputSize:c})}});e.defineProperty(s,"readable",{get:()=>h.pipeThrough(f).pipeThrough(a).pipeThrough(l)})}}class xt extends d{constructor(t){let e;super({transform:function n(s,r){if(e){const t=new o(e.length+s.length);t.set(e),t.set(s,e.length),s=t,e=null}s.length>t?(r.enqueue(s.slice(0,t)),n(s.slice(t),r)):e=s},flush(t){e&&e.length&&t.enqueue(e)}})}}const It=new h,Rt=new h;let Pt,Ut,Vt,Mt,_t,Bt=0;async function Dt(t){try{const{options:e,config:s}=t;if(!e.useCompressionStream)try{await self.initModule(t.config)}catch{e.useCompressionStream=!0}s.CompressionStream=self.CompressionStream,s.DecompressionStream=self.DecompressionStream;const r={highWaterMark:1},o=t.readable||new y({async pull(t){const e=new l(t=>It.set(Bt,t));Wt({type:"pull",messageId:Bt}),Bt=(Bt+1)%n.MAX_SAFE_INTEGER;const{value:s,done:r}=await e;t.enqueue(s),r&&t.close()}},r),i=t.writable||new m({async write(t){let e;const s=new l(t=>e=t);Rt.set(Bt,e),Wt({type:zt,value:t,messageId:Bt}),Bt=(Bt+1)%n.MAX_SAFE_INTEGER,await s}},r),c=new At(e,s);Pt=new AbortController;const{signal:a}=Pt;await o.pipeThrough(c).pipeThrough(new xt(s.chunkSize)).pipeTo(i,{signal:a,preventClose:!0,preventAbort:!0}),await i.getWriter().close();const{signature:h,inputSize:f,outputSize:u}=c;Wt({type:Ct,result:{signature:h,inputSize:f,outputSize:u}})}catch(t){t.outputSize=0,Kt(t)}}function Wt(t){let{value:e}=t;if(e)if(e.length)try{e=new o(e),t.value=e.buffer,p(t,[t.value])}catch{p(t)}else p(t);else p(t)}function Kt(t=new r("Unknown error")){const{message:e,stack:n,code:s,name:o,outputSize:i}=t;p({error:{message:e,stack:n,code:s,name:o,outputSize:i}})}function Et(t,e,n={}){const i="number"==typeof n.level?n.level:-1,c="number"==typeof n.ot?n.ot:65536,a="number"==typeof n.it?n.it:65536;return new d({start(){let n;if(this.ct=Vt(c),this.in=Vt(a),this.it=a,this.ht=new o(c),t?(this.ft=Ut.deflate_process,this.lt=Ut.deflate_last_consumed,this.ut=Ut.deflate_end,this.wt=Ut.deflate_new(),n="gzip"===e?Ut.deflate_init_gzip(this.wt,i):"deflate-raw"===e?Ut.deflate_init_raw(this.wt,i):Ut.deflate_init(this.wt,i)):"deflate64-raw"===e?(this.ft=Ut.inflate9_process,this.lt=Ut.inflate9_last_consumed,this.ut=Ut.inflate9_end,this.wt=Ut.inflate9_new(),n=Ut.inflate9_init_raw(this.wt)):(this.ft=Ut.inflate_process,this.lt=Ut.inflate_last_consumed,this.ut=Ut.inflate_end,this.wt=Ut.inflate_new(),n="deflate-raw"===e?Ut.inflate_init_raw(this.wt):"gzip"===e?Ut.inflate_init_gzip(this.wt):Ut.inflate_init(this.wt)),0!==n)throw new r("init failed:"+n)},transform(e,n){try{const i=e,a=new o(_t.buffer),h=this.ft,f=this.lt,l=this.ct,u=this.ht;let w=0;for(;w<i.length;){const e=s.min(i.length-w,32768);this.in&&this.it>=e||(this.in&&Mt&&Mt(this.in),this.in=Vt(e),this.it=e),a.set(i.subarray(w,w+e),this.in);const o=h(this.wt,this.in,e,l,c,0);if(!t&&0>o)throw new r("process error:"+o);const p=16777215&o;p&&(u.set(a.subarray(l,l+p),0),n.enqueue(u.slice(0,p)));const d=f(this.wt);if(0===d)break;w+=d}}catch(t){this.ut&&this.wt&&this.ut(this.wt),this.in&&Mt&&Mt(this.in),this.ct&&Mt&&Mt(this.ct),n.error(t)}},flush(e){try{const n=new o(_t.buffer),s=this.ft,i=this.ct,a=this.ht;for(;;){const o=s(this.wt,0,0,i,c,4);if(!t&&0>o)throw new r("process error:"+o);const h=16777215&o,f=o>>24&255;if(h&&(a.set(n.subarray(i,i+h),0),e.enqueue(a.slice(0,h))),1===f||0===h)break}}catch(t){e.error(t)}finally{if(this.ut&&this.wt){const t=this.ut(this.wt);0!==t&&e.error(new r("end error:"+t))}this.in&&Mt&&Mt(this.in),this.ct&&Mt&&Mt(this.ct)}}})}addEventListener("message",({data:t})=>{const{type:e,messageId:n,value:s,done:r}=t;try{if("start"==e&&Dt(t),e==zt){const t=It.get(n);It.delete(n),t({value:new o(s),done:r})}if("ack"==e){const t=Rt.get(n);Rt.delete(n),t()}e==Ct&&Pt.abort()}catch(t){Kt(t)}});class Lt{constructor(t="deflate",e){return Et(!0,t,e)}}class Ot{constructor(t="deflate",e){return Et(!1,t,e)}}let Tt=!1;self.initModule=async t=>{try{const e=await(async(t,{baseURI:e})=>{if(!Tt){let n,s;try{try{s=new URL(t,e)}catch{}const r=await fetch(s);n=await r.arrayBuffer()}catch(e){if(!t.startsWith("data:application/wasm;base64,"))throw e;n=(t=>{const e=t.split(",")[1],n=atob(e),s=n.length,r=new o(s);for(let t=0;s>t;++t)r[t]=n.charCodeAt(t);return r.buffer})(t)}(t=>{if(Ut=t,({malloc:Vt,free:Mt,memory:_t}=Ut),"function"!=typeof Vt||"function"!=typeof Mt||!_t)throw Ut=Vt=Mt=_t=null,new r("Invalid WASM module")})((await WebAssembly.instantiate(n)).instance.exports),Tt=!0}})(t.wasmURI,t);return t.nt=Lt,t.st=Ot,e}catch{}}});\n')), e2) });
}

// node_modules/@zip.js/zip.js/lib/core/streams/codecs/crc32.js
var table = [];
for (let i = 0; i < 256; i++) {
  let t2 = i;
  for (let j = 0; j < 8; j++) {
    if (t2 & 1) {
      t2 = t2 >>> 1 ^ 3988292384;
    } else {
      t2 = t2 >>> 1;
    }
  }
  table[i] = t2;
}
var Crc32 = class {
  constructor(crc) {
    this.crc = crc || -1;
  }
  append(data) {
    let crc = this.crc | 0;
    for (let offset = 0, length = data.length | 0; offset < length; offset++) {
      crc = crc >>> 8 ^ table[(crc ^ data[offset]) & 255];
    }
    this.crc = crc;
  }
  get() {
    return ~this.crc;
  }
};

// node_modules/@zip.js/zip.js/lib/core/streams/crc32-stream.js
var Crc32Stream = class extends TransformStream {
  constructor() {
    let stream;
    const crc32 = new Crc32();
    super({
      transform(chunk, controller) {
        crc32.append(chunk);
        controller.enqueue(chunk);
      },
      flush() {
        const value = new Uint8Array(4);
        const dataView = new DataView(value.buffer);
        dataView.setUint32(0, crc32.get());
        stream.value = value;
      }
    });
    stream = this;
  }
};

// node_modules/@zip.js/zip.js/lib/core/util/encode-text.js
function encodeText(value) {
  if (typeof TextEncoder == UNDEFINED_TYPE) {
    value = unescape(encodeURIComponent(value));
    const result = new Uint8Array(value.length);
    for (let i = 0; i < result.length; i++) {
      result[i] = value.charCodeAt(i);
    }
    return result;
  } else {
    return new TextEncoder().encode(value);
  }
}

// node_modules/@zip.js/zip.js/lib/core/streams/codecs/sjcl.js
var bitArray = {
  /**
   * Concatenate two bit arrays.
   * @param {bitArray} a1 The first array.
   * @param {bitArray} a2 The second array.
   * @return {bitArray} The concatenation of a1 and a2.
   */
  concat(a1, a2) {
    if (a1.length === 0 || a2.length === 0) {
      return a1.concat(a2);
    }
    const last = a1[a1.length - 1], shift = bitArray.getPartial(last);
    if (shift === 32) {
      return a1.concat(a2);
    } else {
      return bitArray._shiftRight(a2, shift, last | 0, a1.slice(0, a1.length - 1));
    }
  },
  /**
   * Find the length of an array of bits.
   * @param {bitArray} a The array.
   * @return {Number} The length of a, in bits.
   */
  bitLength(a) {
    const l = a.length;
    if (l === 0) {
      return 0;
    }
    const x2 = a[l - 1];
    return (l - 1) * 32 + bitArray.getPartial(x2);
  },
  /**
   * Truncate an array.
   * @param {bitArray} a The array.
   * @param {Number} len The length to truncate to, in bits.
   * @return {bitArray} A new array, truncated to len bits.
   */
  clamp(a, len) {
    if (a.length * 32 < len) {
      return a;
    }
    a = a.slice(0, Math.ceil(len / 32));
    const l = a.length;
    len = len & 31;
    if (l > 0 && len) {
      a[l - 1] = bitArray.partial(len, a[l - 1] & 2147483648 >> len - 1, 1);
    }
    return a;
  },
  /**
   * Make a partial word for a bit array.
   * @param {Number} len The number of bits in the word.
   * @param {Number} x The bits.
   * @param {Number} [_end=0] Pass 1 if x has already been shifted to the high side.
   * @return {Number} The partial word.
   */
  partial(len, x2, _end) {
    if (len === 32) {
      return x2;
    }
    return (_end ? x2 | 0 : x2 << 32 - len) + len * 1099511627776;
  },
  /**
   * Get the number of bits used by a partial word.
   * @param {Number} x The partial word.
   * @return {Number} The number of bits used by the partial word.
   */
  getPartial(x2) {
    return Math.round(x2 / 1099511627776) || 32;
  },
  /** Shift an array right.
   * @param {bitArray} a The array to shift.
   * @param {Number} shift The number of bits to shift.
   * @param {Number} [carry=0] A byte to carry in
   * @param {bitArray} [out=[]] An array to prepend to the output.
   * @private
   */
  _shiftRight(a, shift, carry, out) {
    if (out === void 0) {
      out = [];
    }
    for (; shift >= 32; shift -= 32) {
      out.push(carry);
      carry = 0;
    }
    if (shift === 0) {
      return out.concat(a);
    }
    for (let i = 0; i < a.length; i++) {
      out.push(carry | a[i] >>> shift);
      carry = a[i] << 32 - shift;
    }
    const last2 = a.length ? a[a.length - 1] : 0;
    const shift2 = bitArray.getPartial(last2);
    out.push(bitArray.partial(shift + shift2 & 31, shift + shift2 > 32 ? carry : out.pop(), 1));
    return out;
  }
};
var codec = {
  bytes: {
    /** Convert from a bitArray to an array of bytes. */
    fromBits(arr) {
      const bl2 = bitArray.bitLength(arr);
      const byteLength = bl2 / 8;
      const out = new Uint8Array(byteLength);
      let tmp;
      for (let i = 0; i < byteLength; i++) {
        if ((i & 3) === 0) {
          tmp = arr[i / 4];
        }
        out[i] = tmp >>> 24;
        tmp <<= 8;
      }
      return out;
    },
    /** Convert from an array of bytes to a bitArray. */
    toBits(bytes) {
      const out = [];
      let i;
      let tmp = 0;
      for (i = 0; i < bytes.length; i++) {
        tmp = tmp << 8 | bytes[i];
        if ((i & 3) === 3) {
          out.push(tmp);
          tmp = 0;
        }
      }
      if (i & 3) {
        out.push(bitArray.partial(8 * (i & 3), tmp));
      }
      return out;
    }
  }
};
var hash = {};
hash.sha1 = class {
  constructor(hash2) {
    const sha1 = this;
    sha1.blockSize = 512;
    sha1._init = [1732584193, 4023233417, 2562383102, 271733878, 3285377520];
    sha1._key = [1518500249, 1859775393, 2400959708, 3395469782];
    if (hash2) {
      sha1._h = hash2._h.slice(0);
      sha1._buffer = hash2._buffer.slice(0);
      sha1._length = hash2._length;
    } else {
      sha1.reset();
    }
  }
  /**
   * Reset the hash state.
   * @return this
   */
  reset() {
    const sha1 = this;
    sha1._h = sha1._init.slice(0);
    sha1._buffer = [];
    sha1._length = 0;
    return sha1;
  }
  /**
   * Input several words to the hash.
   * @param {bitArray|String} data the data to hash.
   * @return this
   */
  update(data) {
    const sha1 = this;
    if (typeof data === "string") {
      data = codec.utf8String.toBits(data);
    }
    const b2 = sha1._buffer = bitArray.concat(sha1._buffer, data);
    const ol = sha1._length;
    const nl = sha1._length = ol + bitArray.bitLength(data);
    if (nl > 9007199254740991) {
      throw new Error("Cannot hash more than 2^53 - 1 bits");
    }
    const c = new Uint32Array(b2);
    let j = 0;
    for (let i = sha1.blockSize + ol - (sha1.blockSize + ol & sha1.blockSize - 1); i <= nl; i += sha1.blockSize) {
      sha1._block(c.subarray(16 * j, 16 * (j + 1)));
      j += 1;
    }
    b2.splice(0, 16 * j);
    return sha1;
  }
  /**
   * Complete hashing and output the hash value.
   * @return {bitArray} The hash value, an array of 5 big-endian words. TODO
   */
  finalize() {
    const sha1 = this;
    let b2 = sha1._buffer;
    const h = sha1._h;
    b2 = bitArray.concat(b2, [bitArray.partial(1, 1)]);
    for (let i = b2.length + 2; i & 15; i++) {
      b2.push(0);
    }
    b2.push(Math.floor(sha1._length / 4294967296));
    b2.push(sha1._length | 0);
    while (b2.length) {
      sha1._block(b2.splice(0, 16));
    }
    sha1.reset();
    return h;
  }
  /**
   * The SHA-1 logical functions f(0), f(1), ..., f(79).
   * @private
   */
  _f(t2, b2, c, d) {
    if (t2 <= 19) {
      return b2 & c | ~b2 & d;
    } else if (t2 <= 39) {
      return b2 ^ c ^ d;
    } else if (t2 <= 59) {
      return b2 & c | b2 & d | c & d;
    } else if (t2 <= 79) {
      return b2 ^ c ^ d;
    }
  }
  /**
   * Circular left-shift operator.
   * @private
   */
  _S(n, x2) {
    return x2 << n | x2 >>> 32 - n;
  }
  /**
   * Perform one cycle of SHA-1.
   * @param {Uint32Array|bitArray} words one block of words.
   * @private
   */
  _block(words) {
    const sha1 = this;
    const h = sha1._h;
    const w = Array(80);
    for (let j = 0; j < 16; j++) {
      w[j] = words[j];
    }
    let a = h[0];
    let b2 = h[1];
    let c = h[2];
    let d = h[3];
    let e2 = h[4];
    for (let t2 = 0; t2 <= 79; t2++) {
      if (t2 >= 16) {
        w[t2] = sha1._S(1, w[t2 - 3] ^ w[t2 - 8] ^ w[t2 - 14] ^ w[t2 - 16]);
      }
      const tmp = sha1._S(5, a) + sha1._f(t2, b2, c, d) + e2 + w[t2] + sha1._key[Math.floor(t2 / 20)] | 0;
      e2 = d;
      d = c;
      c = sha1._S(30, b2);
      b2 = a;
      a = tmp;
    }
    h[0] = h[0] + a | 0;
    h[1] = h[1] + b2 | 0;
    h[2] = h[2] + c | 0;
    h[3] = h[3] + d | 0;
    h[4] = h[4] + e2 | 0;
  }
};
var cipher = {};
cipher.aes = class {
  constructor(key) {
    const aes = this;
    aes._tables = [[[], [], [], [], []], [[], [], [], [], []]];
    if (!aes._tables[0][0][0]) {
      aes._precompute();
    }
    const sbox = aes._tables[0][4];
    const decTable = aes._tables[1];
    const keyLen = key.length;
    let i, encKey, decKey, rcon = 1;
    if (keyLen !== 4 && keyLen !== 6 && keyLen !== 8) {
      throw new Error("invalid aes key size");
    }
    aes._key = [encKey = key.slice(0), decKey = []];
    for (i = keyLen; i < 4 * keyLen + 28; i++) {
      let tmp = encKey[i - 1];
      if (i % keyLen === 0 || keyLen === 8 && i % keyLen === 4) {
        tmp = sbox[tmp >>> 24] << 24 ^ sbox[tmp >> 16 & 255] << 16 ^ sbox[tmp >> 8 & 255] << 8 ^ sbox[tmp & 255];
        if (i % keyLen === 0) {
          tmp = tmp << 8 ^ tmp >>> 24 ^ rcon << 24;
          rcon = rcon << 1 ^ (rcon >> 7) * 283;
        }
      }
      encKey[i] = encKey[i - keyLen] ^ tmp;
    }
    for (let j = 0; i; j++, i--) {
      const tmp = encKey[j & 3 ? i : i - 4];
      if (i <= 4 || j < 4) {
        decKey[j] = tmp;
      } else {
        decKey[j] = decTable[0][sbox[tmp >>> 24]] ^ decTable[1][sbox[tmp >> 16 & 255]] ^ decTable[2][sbox[tmp >> 8 & 255]] ^ decTable[3][sbox[tmp & 255]];
      }
    }
  }
  // public
  /* Something like this might appear here eventually
  name: "AES",
  blockSize: 4,
  keySizes: [4,6,8],
  */
  /**
   * Encrypt an array of 4 big-endian words.
   * @param {Array} data The plaintext.
   * @return {Array} The ciphertext.
   */
  encrypt(data) {
    return this._crypt(data, 0);
  }
  /**
   * Decrypt an array of 4 big-endian words.
   * @param {Array} data The ciphertext.
   * @return {Array} The plaintext.
   */
  decrypt(data) {
    return this._crypt(data, 1);
  }
  /**
   * Expand the S-box tables.
   *
   * @private
   */
  _precompute() {
    const encTable = this._tables[0];
    const decTable = this._tables[1];
    const sbox = encTable[4];
    const sboxInv = decTable[4];
    const d = [];
    const th2 = [];
    let xInv, x2, x4, x8;
    for (let i = 0; i < 256; i++) {
      th2[(d[i] = i << 1 ^ (i >> 7) * 283) ^ i] = i;
    }
    for (let x3 = xInv = 0; !sbox[x3]; x3 ^= x2 || 1, xInv = th2[xInv] || 1) {
      let s = xInv ^ xInv << 1 ^ xInv << 2 ^ xInv << 3 ^ xInv << 4;
      s = s >> 8 ^ s & 255 ^ 99;
      sbox[x3] = s;
      sboxInv[s] = x3;
      x8 = d[x4 = d[x2 = d[x3]]];
      let tDec = x8 * 16843009 ^ x4 * 65537 ^ x2 * 257 ^ x3 * 16843008;
      let tEnc = d[s] * 257 ^ s * 16843008;
      for (let i = 0; i < 4; i++) {
        encTable[i][x3] = tEnc = tEnc << 24 ^ tEnc >>> 8;
        decTable[i][s] = tDec = tDec << 24 ^ tDec >>> 8;
      }
    }
    for (let i = 0; i < 5; i++) {
      encTable[i] = encTable[i].slice(0);
      decTable[i] = decTable[i].slice(0);
    }
  }
  /**
   * Encryption and decryption core.
   * @param {Array} input Four words to be encrypted or decrypted.
   * @param dir The direction, 0 for encrypt and 1 for decrypt.
   * @return {Array} The four encrypted or decrypted words.
   * @private
   */
  _crypt(input, dir) {
    if (input.length !== 4) {
      throw new Error("invalid aes block size");
    }
    const key = this._key[dir];
    const nInnerRounds = key.length / 4 - 2;
    const out = [0, 0, 0, 0];
    const table3 = this._tables[dir];
    const t0 = table3[0];
    const t1 = table3[1];
    const t2 = table3[2];
    const t3 = table3[3];
    const sbox = table3[4];
    let a = input[0] ^ key[0];
    let b2 = input[dir ? 3 : 1] ^ key[1];
    let c = input[2] ^ key[2];
    let d = input[dir ? 1 : 3] ^ key[3];
    let kIndex = 4;
    let a2, b22, c2;
    for (let i = 0; i < nInnerRounds; i++) {
      a2 = t0[a >>> 24] ^ t1[b2 >> 16 & 255] ^ t2[c >> 8 & 255] ^ t3[d & 255] ^ key[kIndex];
      b22 = t0[b2 >>> 24] ^ t1[c >> 16 & 255] ^ t2[d >> 8 & 255] ^ t3[a & 255] ^ key[kIndex + 1];
      c2 = t0[c >>> 24] ^ t1[d >> 16 & 255] ^ t2[a >> 8 & 255] ^ t3[b2 & 255] ^ key[kIndex + 2];
      d = t0[d >>> 24] ^ t1[a >> 16 & 255] ^ t2[b2 >> 8 & 255] ^ t3[c & 255] ^ key[kIndex + 3];
      kIndex += 4;
      a = a2;
      b2 = b22;
      c = c2;
    }
    for (let i = 0; i < 4; i++) {
      out[dir ? 3 & -i : i] = sbox[a >>> 24] << 24 ^ sbox[b2 >> 16 & 255] << 16 ^ sbox[c >> 8 & 255] << 8 ^ sbox[d & 255] ^ key[kIndex++];
      a2 = a;
      a = b2;
      b2 = c;
      c = d;
      d = a2;
    }
    return out;
  }
};
var random = {
  /** 
   * Generate random words with pure js, cryptographically not as strong & safe as native implementation.
   * @param {TypedArray} typedArray The array to fill.
   * @return {TypedArray} The random values.
   */
  getRandomValues(typedArray) {
    const words = new Uint32Array(typedArray.buffer);
    const r = (m_w) => {
      let m_z = 987654321;
      const mask = 4294967295;
      return function() {
        m_z = 36969 * (m_z & 65535) + (m_z >> 16) & mask;
        m_w = 18e3 * (m_w & 65535) + (m_w >> 16) & mask;
        const result = ((m_z << 16) + m_w & mask) / 4294967296 + 0.5;
        return result * (Math.random() > 0.5 ? 1 : -1);
      };
    };
    for (let i = 0, rcache; i < typedArray.length; i += 4) {
      const _r2 = r((rcache || Math.random()) * 4294967296);
      rcache = _r2() * 987654071;
      words[i / 4] = _r2() * 4294967296 | 0;
    }
    return typedArray;
  }
};
var mode = {};
mode.ctrGladman = class {
  constructor(prf, iv) {
    this._prf = prf;
    this._initIv = iv;
    this._iv = iv;
  }
  reset() {
    this._iv = this._initIv;
  }
  /** Input some data to calculate.
   * @param {bitArray} data the data to process, it must be intergral multiple of 128 bits unless it's the last.
   */
  update(data) {
    return this.calculate(this._prf, data, this._iv);
  }
  incWord(word) {
    if ((word >> 24 & 255) === 255) {
      let b1 = word >> 16 & 255;
      let b2 = word >> 8 & 255;
      let b3 = word & 255;
      if (b1 === 255) {
        b1 = 0;
        if (b2 === 255) {
          b2 = 0;
          if (b3 === 255) {
            b3 = 0;
          } else {
            ++b3;
          }
        } else {
          ++b2;
        }
      } else {
        ++b1;
      }
      word = 0;
      word += b1 << 16;
      word += b2 << 8;
      word += b3;
    } else {
      word += 1 << 24;
    }
    return word;
  }
  incCounter(counter) {
    if ((counter[0] = this.incWord(counter[0])) === 0) {
      counter[1] = this.incWord(counter[1]);
    }
  }
  calculate(prf, data, iv) {
    let l;
    if (!(l = data.length)) {
      return [];
    }
    const bl2 = bitArray.bitLength(data);
    for (let i = 0; i < l; i += 4) {
      this.incCounter(iv);
      const e2 = prf.encrypt(iv);
      data[i] ^= e2[0];
      data[i + 1] ^= e2[1];
      data[i + 2] ^= e2[2];
      data[i + 3] ^= e2[3];
    }
    return bitArray.clamp(data, bl2);
  }
};
var misc = {
  importKey(password) {
    return new misc.hmacSha1(codec.bytes.toBits(password));
  },
  pbkdf2(prf, salt, count, length) {
    count = count || 1e4;
    if (length < 0 || count < 0) {
      throw new Error("invalid params to pbkdf2");
    }
    const byteLength = (length >> 5) + 1 << 2;
    let u, ui2, i, j, k2;
    const arrayBuffer = new ArrayBuffer(byteLength);
    const out = new DataView(arrayBuffer);
    let outLength = 0;
    const b2 = bitArray;
    salt = codec.bytes.toBits(salt);
    for (k2 = 1; outLength < (byteLength || 1); k2++) {
      u = ui2 = prf.encrypt(b2.concat(salt, [k2]));
      for (i = 1; i < count; i++) {
        ui2 = prf.encrypt(ui2);
        for (j = 0; j < ui2.length; j++) {
          u[j] ^= ui2[j];
        }
      }
      for (i = 0; outLength < (byteLength || 1) && i < u.length; i++) {
        out.setInt32(outLength, u[i]);
        outLength += 4;
      }
    }
    return arrayBuffer.slice(0, length / 8);
  }
};
misc.hmacSha1 = class {
  constructor(key) {
    const hmac = this;
    const Hash = hmac._hash = hash.sha1;
    const exKey = [[], []];
    hmac._baseHash = [new Hash(), new Hash()];
    const bs2 = hmac._baseHash[0].blockSize / 32;
    if (key.length > bs2) {
      key = new Hash().update(key).finalize();
    }
    for (let i = 0; i < bs2; i++) {
      exKey[0][i] = key[i] ^ 909522486;
      exKey[1][i] = key[i] ^ 1549556828;
    }
    hmac._baseHash[0].update(exKey[0]);
    hmac._baseHash[1].update(exKey[1]);
    hmac._resultHash = new Hash(hmac._baseHash[0]);
  }
  reset() {
    const hmac = this;
    hmac._resultHash = new hmac._hash(hmac._baseHash[0]);
    hmac._updated = false;
  }
  update(data) {
    const hmac = this;
    hmac._updated = true;
    hmac._resultHash.update(data);
  }
  digest() {
    const hmac = this;
    const w = hmac._resultHash.finalize();
    const result = new hmac._hash(hmac._baseHash[1]).update(w).finalize();
    hmac.reset();
    return result;
  }
  encrypt(data) {
    if (!this._updated) {
      this.update(data);
      return this.digest(data);
    } else {
      throw new Error("encrypt on already updated hmac called!");
    }
  }
};

// node_modules/@zip.js/zip.js/lib/core/streams/common-crypto.js
var GET_RANDOM_VALUES_SUPPORTED = typeof crypto != UNDEFINED_TYPE && typeof crypto.getRandomValues == FUNCTION_TYPE;
var ERR_INVALID_PASSWORD = "Invalid password";
var ERR_INVALID_SIGNATURE = "Invalid signature";
var ERR_ABORT_CHECK_PASSWORD = "zipjs-abort-check-password";
function getRandomValues(array) {
  if (GET_RANDOM_VALUES_SUPPORTED) {
    return crypto.getRandomValues(array);
  } else {
    return random.getRandomValues(array);
  }
}

// node_modules/@zip.js/zip.js/lib/core/streams/aes-crypto-stream.js
var BLOCK_LENGTH = 16;
var RAW_FORMAT = "raw";
var PBKDF2_ALGORITHM = { name: "PBKDF2" };
var HASH_ALGORITHM = { name: "HMAC" };
var HASH_FUNCTION = "SHA-1";
var BASE_KEY_ALGORITHM = Object.assign({ hash: HASH_ALGORITHM }, PBKDF2_ALGORITHM);
var DERIVED_BITS_ALGORITHM = Object.assign({ iterations: 1e3, hash: { name: HASH_FUNCTION } }, PBKDF2_ALGORITHM);
var DERIVED_BITS_USAGE = ["deriveBits"];
var SALT_LENGTH = [8, 12, 16];
var KEY_LENGTH = [16, 24, 32];
var SIGNATURE_LENGTH = 10;
var COUNTER_DEFAULT_VALUE = [0, 0, 0, 0];
var CRYPTO_API_SUPPORTED = typeof crypto != UNDEFINED_TYPE;
var subtle = CRYPTO_API_SUPPORTED && crypto.subtle;
var SUBTLE_API_SUPPORTED = CRYPTO_API_SUPPORTED && typeof subtle != UNDEFINED_TYPE;
var codecBytes = codec.bytes;
var Aes = cipher.aes;
var CtrGladman = mode.ctrGladman;
var HmacSha1 = misc.hmacSha1;
var IMPORT_KEY_SUPPORTED = CRYPTO_API_SUPPORTED && SUBTLE_API_SUPPORTED && typeof subtle.importKey == FUNCTION_TYPE;
var DERIVE_BITS_SUPPORTED = CRYPTO_API_SUPPORTED && SUBTLE_API_SUPPORTED && typeof subtle.deriveBits == FUNCTION_TYPE;
var AESDecryptionStream = class extends TransformStream {
  constructor({ password, rawPassword, signed, encryptionStrength, checkPasswordOnly }) {
    super({
      start() {
        Object.assign(this, {
          ready: new Promise((resolve) => this.resolveReady = resolve),
          password: encodePassword(password, rawPassword),
          signed,
          strength: encryptionStrength - 1,
          pending: new Uint8Array()
        });
      },
      async transform(chunk, controller) {
        const aesCrypto = this;
        const {
          password: password2,
          strength,
          resolveReady,
          ready
        } = aesCrypto;
        if (password2) {
          await createDecryptionKeys(aesCrypto, strength, password2, subarray(chunk, 0, SALT_LENGTH[strength] + 2));
          chunk = subarray(chunk, SALT_LENGTH[strength] + 2);
          if (checkPasswordOnly) {
            controller.error(new Error(ERR_ABORT_CHECK_PASSWORD));
          } else {
            resolveReady();
          }
        } else {
          await ready;
        }
        const output = new Uint8Array(chunk.length - SIGNATURE_LENGTH - (chunk.length - SIGNATURE_LENGTH) % BLOCK_LENGTH);
        controller.enqueue(append(aesCrypto, chunk, output, 0, SIGNATURE_LENGTH, true));
      },
      async flush(controller) {
        const {
          signed: signed2,
          ctr,
          hmac,
          pending,
          ready
        } = this;
        if (hmac && ctr) {
          await ready;
          const chunkToDecrypt = subarray(pending, 0, pending.length - SIGNATURE_LENGTH);
          const originalSignature = subarray(pending, pending.length - SIGNATURE_LENGTH);
          let decryptedChunkArray = new Uint8Array();
          if (chunkToDecrypt.length) {
            const encryptedChunk = toBits(codecBytes, chunkToDecrypt);
            hmac.update(encryptedChunk);
            const decryptedChunk = ctr.update(encryptedChunk);
            decryptedChunkArray = fromBits(codecBytes, decryptedChunk);
          }
          if (signed2) {
            const signature = subarray(fromBits(codecBytes, hmac.digest()), 0, SIGNATURE_LENGTH);
            for (let indexSignature = 0; indexSignature < SIGNATURE_LENGTH; indexSignature++) {
              if (signature[indexSignature] != originalSignature[indexSignature]) {
                throw new Error(ERR_INVALID_SIGNATURE);
              }
            }
          }
          controller.enqueue(decryptedChunkArray);
        }
      }
    });
  }
};
var AESEncryptionStream = class extends TransformStream {
  constructor({ password, rawPassword, encryptionStrength }) {
    let stream;
    super({
      start() {
        Object.assign(this, {
          ready: new Promise((resolve) => this.resolveReady = resolve),
          password: encodePassword(password, rawPassword),
          strength: encryptionStrength - 1,
          pending: new Uint8Array()
        });
      },
      async transform(chunk, controller) {
        const aesCrypto = this;
        const {
          password: password2,
          strength,
          resolveReady,
          ready
        } = aesCrypto;
        let preamble = new Uint8Array();
        if (password2) {
          preamble = await createEncryptionKeys(aesCrypto, strength, password2);
          resolveReady();
        } else {
          await ready;
        }
        const output = new Uint8Array(preamble.length + chunk.length - chunk.length % BLOCK_LENGTH);
        output.set(preamble, 0);
        controller.enqueue(append(aesCrypto, chunk, output, preamble.length, 0));
      },
      async flush(controller) {
        const {
          ctr,
          hmac,
          pending,
          ready
        } = this;
        if (hmac && ctr) {
          await ready;
          let encryptedChunkArray = new Uint8Array();
          if (pending.length) {
            const encryptedChunk = ctr.update(toBits(codecBytes, pending));
            hmac.update(encryptedChunk);
            encryptedChunkArray = fromBits(codecBytes, encryptedChunk);
          }
          stream.signature = fromBits(codecBytes, hmac.digest()).slice(0, SIGNATURE_LENGTH);
          controller.enqueue(concat(encryptedChunkArray, stream.signature));
        }
      }
    });
    stream = this;
  }
};
function append(aesCrypto, input, output, paddingStart, paddingEnd, verifySignature) {
  const {
    ctr,
    hmac,
    pending
  } = aesCrypto;
  const inputLength = input.length - paddingEnd;
  if (pending.length) {
    input = concat(pending, input);
    output = expand(output, inputLength - inputLength % BLOCK_LENGTH);
  }
  let offset;
  for (offset = 0; offset <= inputLength - BLOCK_LENGTH; offset += BLOCK_LENGTH) {
    const inputChunk = toBits(codecBytes, subarray(input, offset, offset + BLOCK_LENGTH));
    if (verifySignature) {
      hmac.update(inputChunk);
    }
    const outputChunk = ctr.update(inputChunk);
    if (!verifySignature) {
      hmac.update(outputChunk);
    }
    output.set(fromBits(codecBytes, outputChunk), offset + paddingStart);
  }
  aesCrypto.pending = subarray(input, offset);
  return output;
}
async function createDecryptionKeys(decrypt2, strength, password, preamble) {
  const passwordVerificationKey = await createKeys(decrypt2, strength, password, subarray(preamble, 0, SALT_LENGTH[strength]));
  const passwordVerification = subarray(preamble, SALT_LENGTH[strength]);
  if (passwordVerificationKey[0] != passwordVerification[0] || passwordVerificationKey[1] != passwordVerification[1]) {
    throw new Error(ERR_INVALID_PASSWORD);
  }
}
async function createEncryptionKeys(encrypt2, strength, password) {
  const salt = getRandomValues(new Uint8Array(SALT_LENGTH[strength]));
  const passwordVerification = await createKeys(encrypt2, strength, password, salt);
  return concat(salt, passwordVerification);
}
async function createKeys(aesCrypto, strength, password, salt) {
  aesCrypto.password = null;
  const baseKey = await importKey(RAW_FORMAT, password, BASE_KEY_ALGORITHM, false, DERIVED_BITS_USAGE);
  const derivedBits = await deriveBits(Object.assign({ salt }, DERIVED_BITS_ALGORITHM), baseKey, 8 * (KEY_LENGTH[strength] * 2 + 2));
  const compositeKey = new Uint8Array(derivedBits);
  const key = toBits(codecBytes, subarray(compositeKey, 0, KEY_LENGTH[strength]));
  const authentication = toBits(codecBytes, subarray(compositeKey, KEY_LENGTH[strength], KEY_LENGTH[strength] * 2));
  const passwordVerification = subarray(compositeKey, KEY_LENGTH[strength] * 2);
  Object.assign(aesCrypto, {
    keys: {
      key,
      authentication,
      passwordVerification
    },
    ctr: new CtrGladman(new Aes(key), Array.from(COUNTER_DEFAULT_VALUE)),
    hmac: new HmacSha1(authentication)
  });
  return passwordVerification;
}
async function importKey(format, password, algorithm, extractable, keyUsages) {
  if (IMPORT_KEY_SUPPORTED) {
    try {
      return await subtle.importKey(format, password, algorithm, extractable, keyUsages);
    } catch {
      IMPORT_KEY_SUPPORTED = false;
      return misc.importKey(password);
    }
  } else {
    return misc.importKey(password);
  }
}
async function deriveBits(algorithm, baseKey, length) {
  if (DERIVE_BITS_SUPPORTED) {
    try {
      return await subtle.deriveBits(algorithm, baseKey, length);
    } catch {
      DERIVE_BITS_SUPPORTED = false;
      return misc.pbkdf2(baseKey, algorithm.salt, DERIVED_BITS_ALGORITHM.iterations, length);
    }
  } else {
    return misc.pbkdf2(baseKey, algorithm.salt, DERIVED_BITS_ALGORITHM.iterations, length);
  }
}
function encodePassword(password, rawPassword) {
  if (rawPassword === UNDEFINED_VALUE) {
    return encodeText(password);
  } else {
    return rawPassword;
  }
}
function concat(leftArray, rightArray) {
  let array = leftArray;
  if (leftArray.length + rightArray.length) {
    array = new Uint8Array(leftArray.length + rightArray.length);
    array.set(leftArray, 0);
    array.set(rightArray, leftArray.length);
  }
  return array;
}
function expand(inputArray, length) {
  if (length && length > inputArray.length) {
    const array = inputArray;
    inputArray = new Uint8Array(length);
    inputArray.set(array, 0);
  }
  return inputArray;
}
function subarray(array, begin, end) {
  return array.subarray(begin, end);
}
function fromBits(codecBytes2, chunk) {
  return codecBytes2.fromBits(chunk);
}
function toBits(codecBytes2, chunk) {
  return codecBytes2.toBits(chunk);
}

// node_modules/@zip.js/zip.js/lib/core/streams/zip-crypto-stream.js
var HEADER_LENGTH = 12;
var ZipCryptoDecryptionStream = class extends TransformStream {
  constructor({ password, passwordVerification, checkPasswordOnly }) {
    super({
      start() {
        Object.assign(this, {
          password,
          passwordVerification
        });
        createKeys2(this, password);
      },
      transform(chunk, controller) {
        const zipCrypto = this;
        if (zipCrypto.password) {
          const decryptedHeader = decrypt(zipCrypto, chunk.subarray(0, HEADER_LENGTH));
          zipCrypto.password = null;
          if (decryptedHeader.at(-1) != zipCrypto.passwordVerification) {
            throw new Error(ERR_INVALID_PASSWORD);
          }
          chunk = chunk.subarray(HEADER_LENGTH);
        }
        if (checkPasswordOnly) {
          controller.error(new Error(ERR_ABORT_CHECK_PASSWORD));
        } else {
          controller.enqueue(decrypt(zipCrypto, chunk));
        }
      }
    });
  }
};
var ZipCryptoEncryptionStream = class extends TransformStream {
  constructor({ password, passwordVerification }) {
    super({
      start() {
        Object.assign(this, {
          password,
          passwordVerification
        });
        createKeys2(this, password);
      },
      transform(chunk, controller) {
        const zipCrypto = this;
        let output;
        let offset;
        if (zipCrypto.password) {
          zipCrypto.password = null;
          const header = getRandomValues(new Uint8Array(HEADER_LENGTH));
          header[HEADER_LENGTH - 1] = zipCrypto.passwordVerification;
          output = new Uint8Array(chunk.length + header.length);
          output.set(encrypt(zipCrypto, header), 0);
          offset = HEADER_LENGTH;
        } else {
          output = new Uint8Array(chunk.length);
          offset = 0;
        }
        output.set(encrypt(zipCrypto, chunk), offset);
        controller.enqueue(output);
      }
    });
  }
};
function decrypt(target, input) {
  const output = new Uint8Array(input.length);
  for (let index2 = 0; index2 < input.length; index2++) {
    output[index2] = getByte(target) ^ input[index2];
    updateKeys(target, output[index2]);
  }
  return output;
}
function encrypt(target, input) {
  const output = new Uint8Array(input.length);
  for (let index2 = 0; index2 < input.length; index2++) {
    output[index2] = getByte(target) ^ input[index2];
    updateKeys(target, input[index2]);
  }
  return output;
}
function createKeys2(target, password) {
  const keys = [305419896, 591751049, 878082192];
  Object.assign(target, {
    keys,
    crcKey0: new Crc32(keys[0]),
    crcKey2: new Crc32(keys[2])
  });
  for (let index2 = 0; index2 < password.length; index2++) {
    updateKeys(target, password.charCodeAt(index2));
  }
}
function updateKeys(target, byte) {
  let [key0, key1, key2] = target.keys;
  target.crcKey0.append([byte]);
  key0 = ~target.crcKey0.get();
  key1 = getInt32(Math.imul(getInt32(key1 + getInt8(key0)), 134775813) + 1);
  target.crcKey2.append([key1 >>> 24]);
  key2 = ~target.crcKey2.get();
  target.keys = [key0, key1, key2];
}
function getByte(target) {
  const temp = target.keys[2] | 2;
  return getInt8(Math.imul(temp, temp ^ 1) >>> 8);
}
function getInt8(number) {
  return number & 255;
}
function getInt32(number) {
  return number & 4294967295;
}

// node_modules/@zip.js/zip.js/lib/core/streams/zip-entry-stream.js
var ERR_INVALID_UNCOMPRESSED_SIZE = "Invalid uncompressed size";
var FORMAT_DEFLATE_RAW = "deflate-raw";
var FORMAT_DEFLATE64_RAW = "deflate64-raw";
var DeflateStream = class extends TransformStream {
  constructor(options, { chunkSize, CompressionStreamZlib: CompressionStreamZlib2, CompressionStream: CompressionStream2 }) {
    super({});
    const { compressed, encrypted, useCompressionStream, zipCrypto, signed, level } = options;
    const stream = this;
    let crc32Stream, encryptionStream;
    let readable = super.readable;
    if ((!encrypted || zipCrypto) && signed) {
      crc32Stream = new Crc32Stream();
      readable = pipeThrough(readable, crc32Stream);
    }
    if (compressed) {
      readable = pipeThroughCommpressionStream(readable, useCompressionStream, { level, chunkSize }, CompressionStream2, CompressionStreamZlib2, CompressionStream2);
    }
    if (encrypted) {
      if (zipCrypto) {
        readable = pipeThrough(readable, new ZipCryptoEncryptionStream(options));
      } else {
        encryptionStream = new AESEncryptionStream(options);
        readable = pipeThrough(readable, encryptionStream);
      }
    }
    setReadable(stream, readable, () => {
      let signature;
      if (encrypted && !zipCrypto) {
        signature = encryptionStream.signature;
      }
      if ((!encrypted || zipCrypto) && signed) {
        signature = new DataView(crc32Stream.value.buffer).getUint32(0);
      }
      stream.signature = signature;
    });
  }
};
var InflateStream = class extends TransformStream {
  constructor(options, { chunkSize, DecompressionStreamZlib: DecompressionStreamZlib2, DecompressionStream: DecompressionStream2 }) {
    super({});
    const { zipCrypto, encrypted, signed, signature, compressed, useCompressionStream, deflate64 } = options;
    let crc32Stream, decryptionStream;
    let readable = super.readable;
    if (encrypted) {
      if (zipCrypto) {
        readable = pipeThrough(readable, new ZipCryptoDecryptionStream(options));
      } else {
        decryptionStream = new AESDecryptionStream(options);
        readable = pipeThrough(readable, decryptionStream);
      }
    }
    if (compressed) {
      readable = pipeThroughCommpressionStream(readable, useCompressionStream, { chunkSize, deflate64 }, DecompressionStream2, DecompressionStreamZlib2, DecompressionStream2);
    }
    if ((!encrypted || zipCrypto) && signed) {
      crc32Stream = new Crc32Stream();
      readable = pipeThrough(readable, crc32Stream);
    }
    setReadable(this, readable, () => {
      if ((!encrypted || zipCrypto) && signed) {
        const dataViewSignature = new DataView(crc32Stream.value.buffer);
        if (signature != dataViewSignature.getUint32(0, false)) {
          throw new Error(ERR_INVALID_SIGNATURE);
        }
      }
    });
  }
};
function setReadable(stream, readable, flush) {
  readable = pipeThrough(readable, new TransformStream({ flush }));
  Object.defineProperty(stream, "readable", {
    get() {
      return readable;
    }
  });
}
function pipeThroughCommpressionStream(readable, useCompressionStream, options, CompressionStreamNative, CompressionStreamZlib2, CompressionStream2) {
  const Stream2 = useCompressionStream && CompressionStreamNative ? CompressionStreamNative : CompressionStreamZlib2 || CompressionStream2;
  const format = options.deflate64 ? FORMAT_DEFLATE64_RAW : FORMAT_DEFLATE_RAW;
  try {
    readable = pipeThrough(readable, new Stream2(format, options));
  } catch (error) {
    if (useCompressionStream) {
      if (CompressionStreamZlib2) {
        readable = pipeThrough(readable, new CompressionStreamZlib2(format, options));
      } else if (CompressionStream2) {
        readable = pipeThrough(readable, new CompressionStream2(format, options));
      } else {
        throw error;
      }
    } else {
      throw error;
    }
  }
  return readable;
}
function pipeThrough(readable, transformStream) {
  return readable.pipeThrough(transformStream);
}

// node_modules/@zip.js/zip.js/lib/core/streams/codec-stream.js
var MESSAGE_EVENT_TYPE = "message";
var MESSAGE_START = "start";
var MESSAGE_PULL = "pull";
var MESSAGE_DATA = "data";
var MESSAGE_ACK_DATA = "ack";
var MESSAGE_CLOSE = "close";
var CODEC_DEFLATE = "deflate";
var CODEC_INFLATE = "inflate";
var CodecStream = class extends TransformStream {
  constructor(options, config2) {
    super({});
    const codec2 = this;
    const { codecType } = options;
    let Stream2;
    if (codecType.startsWith(CODEC_DEFLATE)) {
      Stream2 = DeflateStream;
    } else if (codecType.startsWith(CODEC_INFLATE)) {
      Stream2 = InflateStream;
    }
    codec2.outputSize = 0;
    let inputSize = 0;
    const stream = new Stream2(options, config2);
    const readable = super.readable;
    const inputSizeStream = new TransformStream({
      transform(chunk, controller) {
        if (chunk && chunk.length) {
          inputSize += chunk.length;
          controller.enqueue(chunk);
        }
      },
      flush() {
        Object.assign(codec2, {
          inputSize
        });
      }
    });
    const outputSizeStream = new TransformStream({
      transform(chunk, controller) {
        if (chunk && chunk.length) {
          controller.enqueue(chunk);
          codec2.outputSize += chunk.length;
          if (options.outputSize !== UNDEFINED_VALUE && codec2.outputSize > options.outputSize) {
            throw new Error(ERR_INVALID_UNCOMPRESSED_SIZE);
          }
        }
      },
      flush() {
        const { signature } = stream;
        Object.assign(codec2, {
          signature,
          inputSize
        });
      }
    });
    Object.defineProperty(codec2, "readable", {
      get() {
        return readable.pipeThrough(inputSizeStream).pipeThrough(stream).pipeThrough(outputSizeStream);
      }
    });
  }
};
var ChunkStream = class extends TransformStream {
  constructor(chunkSize) {
    let pendingChunk;
    super({
      transform,
      flush(controller) {
        if (pendingChunk && pendingChunk.length) {
          controller.enqueue(pendingChunk);
        }
      }
    });
    function transform(chunk, controller) {
      if (pendingChunk) {
        const newChunk = new Uint8Array(pendingChunk.length + chunk.length);
        newChunk.set(pendingChunk);
        newChunk.set(chunk, pendingChunk.length);
        chunk = newChunk;
        pendingChunk = null;
      }
      if (chunk.length > chunkSize) {
        controller.enqueue(chunk.slice(0, chunkSize));
        transform(chunk.slice(chunkSize), controller);
      } else {
        pendingChunk = chunk;
      }
    }
  }
};

// node_modules/@zip.js/zip.js/lib/core/codec-worker.js
var WEB_WORKERS_SUPPORTED = typeof Worker != UNDEFINED_TYPE;
var initModule = () => {
};
function configureWorker({ initModule: initModuleFunction }) {
  initModule = initModuleFunction;
}
var CodecWorker = class {
  constructor(workerData, { readable, writable }, { options, config: config2, streamOptions, useWebWorkers, transferStreams, workerURI }, onTaskFinished) {
    const { signal } = streamOptions;
    Object.assign(workerData, {
      busy: true,
      readable: readable.pipeThrough(new ChunkStream(config2.chunkSize)).pipeThrough(new ProgressWatcherStream(streamOptions), { signal }),
      writable,
      options: Object.assign({}, options),
      workerURI,
      transferStreams,
      terminate() {
        return new Promise((resolve) => {
          const { worker, busy } = workerData;
          if (worker) {
            if (busy) {
              workerData.resolveTerminated = resolve;
            } else {
              worker.terminate();
              resolve();
            }
            workerData.interface = null;
          } else {
            resolve();
          }
        });
      },
      onTaskFinished() {
        const { resolveTerminated } = workerData;
        if (resolveTerminated) {
          workerData.resolveTerminated = null;
          workerData.terminated = true;
          workerData.worker.terminate();
          resolveTerminated();
        }
        workerData.busy = false;
        onTaskFinished(workerData);
      }
    });
    return (useWebWorkers && WEB_WORKERS_SUPPORTED ? createWebWorkerInterface : createWorkerInterface)(workerData, config2);
  }
};
var ProgressWatcherStream = class extends TransformStream {
  constructor({ onstart, onprogress, size, onend }) {
    let chunkOffset = 0;
    super({
      async start() {
        if (onstart) {
          await callHandler(onstart, size);
        }
      },
      async transform(chunk, controller) {
        chunkOffset += chunk.length;
        if (onprogress) {
          await callHandler(onprogress, chunkOffset, size);
        }
        controller.enqueue(chunk);
      },
      async flush() {
        if (onend) {
          await callHandler(onend, chunkOffset);
        }
      }
    });
  }
};
async function callHandler(handler, ...parameters) {
  try {
    await handler(...parameters);
  } catch {
  }
}
function createWorkerInterface(workerData, config2) {
  return {
    run: () => runWorker(workerData, config2)
  };
}
function createWebWorkerInterface(workerData, config2) {
  const { baseURI, chunkSize } = config2;
  let { wasmURI } = config2;
  if (!workerData.interface) {
    if (typeof wasmURI == FUNCTION_TYPE) {
      wasmURI = wasmURI();
    }
    let worker;
    try {
      worker = getWebWorker(workerData.workerURI, baseURI, workerData);
    } catch {
      WEB_WORKERS_SUPPORTED = false;
      return createWorkerInterface(workerData, config2);
    }
    Object.assign(workerData, {
      worker,
      interface: {
        run: () => runWebWorker(workerData, { chunkSize, wasmURI, baseURI })
      }
    });
  }
  return workerData.interface;
}
async function runWorker({ options, readable, writable, onTaskFinished }, config2) {
  let codecStream;
  try {
    if (!options.useCompressionStream) {
      try {
        await initModule(config2);
      } catch {
        options.useCompressionStream = true;
      }
    }
    codecStream = new CodecStream(options, config2);
    await readable.pipeThrough(codecStream).pipeTo(writable, { preventClose: true, preventAbort: true });
    const {
      signature,
      inputSize,
      outputSize
    } = codecStream;
    return {
      signature,
      inputSize,
      outputSize
    };
  } catch (error) {
    if (codecStream) {
      error.outputSize = codecStream.outputSize;
    }
    throw error;
  } finally {
    onTaskFinished();
  }
}
async function runWebWorker(workerData, config2) {
  let resolveResult, rejectResult;
  const result = new Promise((resolve, reject) => {
    resolveResult = resolve;
    rejectResult = reject;
  });
  Object.assign(workerData, {
    reader: null,
    writer: null,
    resolveResult,
    rejectResult,
    result
  });
  const { readable, options } = workerData;
  const { writable, closed } = watchClosedStream(workerData.writable);
  const streamsTransferred = sendMessage({
    type: MESSAGE_START,
    options,
    config: config2,
    readable,
    writable
  }, workerData);
  if (!streamsTransferred) {
    Object.assign(workerData, {
      reader: readable.getReader(),
      writer: writable.getWriter()
    });
  }
  const resultValue = await result;
  if (!streamsTransferred) {
    await writable.getWriter().close();
  }
  await closed;
  return resultValue;
}
function watchClosedStream(writableSource) {
  let resolveStreamClosed;
  const closed = new Promise((resolve) => resolveStreamClosed = resolve);
  const writable = new WritableStream({
    async write(chunk) {
      const writer = writableSource.getWriter();
      await writer.ready;
      await writer.write(chunk);
      writer.releaseLock();
    },
    close() {
      resolveStreamClosed();
    },
    abort(reason) {
      const writer = writableSource.getWriter();
      return writer.abort(reason);
    }
  });
  return { writable, closed };
}
var transferStreamsSupported = true;
function getWebWorker(url, baseURI, workerData) {
  const workerOptions = { type: "module" };
  let scriptUrl, worker;
  if (typeof url == FUNCTION_TYPE) {
    url = url();
  }
  if (url.startsWith("data:") || url.startsWith("blob:")) {
    try {
      worker = new Worker(url);
    } catch {
      worker = new Worker(url, workerOptions);
    }
  } else {
    try {
      scriptUrl = new URL(url, baseURI);
    } catch {
      scriptUrl = url;
    }
    worker = new Worker(scriptUrl, workerOptions);
  }
  worker.addEventListener(MESSAGE_EVENT_TYPE, (event) => onMessage(event, workerData));
  return worker;
}
function sendMessage(message, { worker, writer, onTaskFinished, transferStreams }) {
  try {
    const { value, readable, writable } = message;
    const transferables = [];
    if (value) {
      message.value = value;
      transferables.push(message.value.buffer);
    }
    if (transferStreams && transferStreamsSupported) {
      if (readable) {
        transferables.push(readable);
      }
      if (writable) {
        transferables.push(writable);
      }
    } else {
      message.readable = message.writable = null;
    }
    if (transferables.length) {
      try {
        worker.postMessage(message, transferables);
        return true;
      } catch {
        transferStreamsSupported = false;
        message.readable = message.writable = null;
        worker.postMessage(message);
      }
    } else {
      worker.postMessage(message);
    }
  } catch (error) {
    if (writer) {
      writer.releaseLock();
    }
    onTaskFinished();
    throw error;
  }
}
async function onMessage({ data }, workerData) {
  const { type, value, messageId, result, error } = data;
  const { reader, writer, resolveResult, rejectResult, onTaskFinished } = workerData;
  try {
    if (error) {
      const { message, stack, code, name, outputSize } = error;
      const responseError = new Error(message);
      Object.assign(responseError, { stack, code, name, outputSize });
      close(responseError);
    } else {
      if (type == MESSAGE_PULL) {
        const { value: value2, done } = await reader.read();
        sendMessage({ type: MESSAGE_DATA, value: value2, done, messageId }, workerData);
      }
      if (type == MESSAGE_DATA) {
        await writer.ready;
        await writer.write(new Uint8Array(value));
        sendMessage({ type: MESSAGE_ACK_DATA, messageId }, workerData);
      }
      if (type == MESSAGE_CLOSE) {
        close(null, result);
      }
    }
  } catch (error2) {
    sendMessage({ type: MESSAGE_CLOSE, messageId }, workerData);
    close(error2);
  }
  function close(error2, result2) {
    if (error2) {
      rejectResult(error2);
    } else {
      resolveResult(result2);
    }
    if (writer) {
      writer.releaseLock();
    }
    onTaskFinished();
  }
}

// node_modules/@zip.js/zip.js/lib/core/codec-pool.js
var pool = [];
var pendingRequests = [];
var indexWorker = 0;
async function runWorker2(stream, workerOptions) {
  const { options, config: config2 } = workerOptions;
  const { transferStreams, useWebWorkers, useCompressionStream, compressed, signed, encrypted } = options;
  const { workerURI, maxWorkers: maxWorkers2 } = config2;
  workerOptions.transferStreams = transferStreams || transferStreams === UNDEFINED_VALUE;
  const streamCopy = !compressed && !signed && !encrypted && !workerOptions.transferStreams;
  workerOptions.useWebWorkers = !streamCopy && (useWebWorkers || useWebWorkers === UNDEFINED_VALUE && config2.useWebWorkers);
  workerOptions.workerURI = workerOptions.useWebWorkers && workerURI ? workerURI : UNDEFINED_VALUE;
  options.useCompressionStream = useCompressionStream || useCompressionStream === UNDEFINED_VALUE && config2.useCompressionStream;
  return (await getWorker()).run();
  async function getWorker() {
    const workerData = pool.find((workerData2) => !workerData2.busy);
    if (workerData) {
      clearTerminateTimeout(workerData);
      return new CodecWorker(workerData, stream, workerOptions, onTaskFinished);
    } else if (pool.length < maxWorkers2) {
      const workerData2 = { indexWorker };
      indexWorker++;
      pool.push(workerData2);
      return new CodecWorker(workerData2, stream, workerOptions, onTaskFinished);
    } else {
      return new Promise((resolve) => pendingRequests.push({ resolve, stream, workerOptions }));
    }
  }
  function onTaskFinished(workerData) {
    if (pendingRequests.length) {
      const [{ resolve, stream: stream2, workerOptions: workerOptions2 }] = pendingRequests.splice(0, 1);
      resolve(new CodecWorker(workerData, stream2, workerOptions2, onTaskFinished));
    } else if (workerData.worker) {
      clearTerminateTimeout(workerData);
      terminateWorker(workerData, workerOptions);
    } else {
      pool = pool.filter((data) => data != workerData);
    }
  }
}
function terminateWorker(workerData, workerOptions) {
  const { config: config2 } = workerOptions;
  const { terminateWorkerTimeout } = config2;
  if (Number.isFinite(terminateWorkerTimeout) && terminateWorkerTimeout >= 0) {
    if (workerData.terminated) {
      workerData.terminated = false;
    } else {
      workerData.terminateTimeout = setTimeout(async () => {
        pool = pool.filter((data) => data != workerData);
        try {
          await workerData.terminate();
        } catch {
        }
      }, terminateWorkerTimeout);
    }
  }
}
function clearTerminateTimeout(workerData) {
  const { terminateTimeout } = workerData;
  if (terminateTimeout) {
    clearTimeout(terminateTimeout);
    workerData.terminateTimeout = null;
  }
}
async function terminateWorkers() {
  await Promise.allSettled(pool.map((workerData) => {
    clearTerminateTimeout(workerData);
    return workerData.terminate();
  }));
}

// node_modules/@zip.js/zip.js/lib/core/io.js
var ERR_HTTP_STATUS = "HTTP error ";
var ERR_HTTP_RANGE = "HTTP Range not supported";
var ERR_ITERATOR_COMPLETED_TOO_SOON = "Writer iterator completed too soon";
var ERR_WRITER_NOT_INITIALIZED = "Writer not initialized";
var CONTENT_TYPE_TEXT_PLAIN = "text/plain";
var HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
var HTTP_HEADER_CONTENT_RANGE = "Content-Range";
var HTTP_HEADER_ACCEPT_RANGES = "Accept-Ranges";
var HTTP_HEADER_RANGE = "Range";
var HTTP_HEADER_CONTENT_TYPE = "Content-Type";
var HTTP_METHOD_HEAD = "HEAD";
var HTTP_METHOD_GET = "GET";
var HTTP_RANGE_UNIT = "bytes";
var DEFAULT_CHUNK_SIZE = 64 * 1024;
var DEFAULT_BUFFER_SIZE = 256 * 1024;
var PROPERTY_NAME_WRITABLE = "writable";
var Stream = class {
  constructor() {
    this.size = 0;
  }
  init() {
    this.initialized = true;
  }
};
var Reader = class extends Stream {
  get readable() {
    const reader = this;
    const { chunkSize = DEFAULT_CHUNK_SIZE } = reader;
    const readable = new ReadableStream({
      start() {
        this.chunkOffset = 0;
      },
      async pull(controller) {
        const { offset = 0, size, diskNumberStart } = readable;
        const { chunkOffset } = this;
        const dataSize = size === UNDEFINED_VALUE ? chunkSize : Math.min(chunkSize, size - chunkOffset);
        const data = await readUint8Array(reader, offset + chunkOffset, dataSize, diskNumberStart);
        controller.enqueue(data);
        if (chunkOffset + chunkSize > size || size === UNDEFINED_VALUE && !data.length && dataSize) {
          controller.close();
        } else {
          this.chunkOffset += chunkSize;
        }
      }
    });
    return readable;
  }
};
var Writer = class extends Stream {
  constructor() {
    super();
    const writer = this;
    const writable = new WritableStream({
      write(chunk) {
        if (!writer.initialized) {
          throw new Error(ERR_WRITER_NOT_INITIALIZED);
        }
        return writer.writeUint8Array(chunk);
      }
    });
    Object.defineProperty(writer, PROPERTY_NAME_WRITABLE, {
      get() {
        return writable;
      }
    });
  }
  writeUint8Array() {
  }
};
var Data64URIReader = class extends Reader {
  constructor(dataURI) {
    super();
    let dataEnd = dataURI.length;
    while (dataURI.charAt(dataEnd - 1) == "=") {
      dataEnd--;
    }
    const dataStart = dataURI.indexOf(",") + 1;
    Object.assign(this, {
      dataURI,
      dataStart,
      size: Math.floor((dataEnd - dataStart) * 0.75)
    });
  }
  readUint8Array(offset, length) {
    const {
      dataStart,
      dataURI
    } = this;
    const dataArray = new Uint8Array(length);
    const start = Math.floor(offset / 3) * 4;
    const bytes = atob(dataURI.substring(start + dataStart, Math.ceil((offset + length) / 3) * 4 + dataStart));
    const delta = offset - Math.floor(start / 4) * 3;
    let effectiveLength = 0;
    for (let indexByte = delta; indexByte < delta + length && indexByte < bytes.length; indexByte++) {
      dataArray[indexByte - delta] = bytes.charCodeAt(indexByte);
      effectiveLength++;
    }
    if (effectiveLength < dataArray.length) {
      return dataArray.subarray(0, effectiveLength);
    } else {
      return dataArray;
    }
  }
};
var Data64URIWriter = class extends Writer {
  constructor(contentType) {
    super();
    Object.assign(this, {
      data: "data:" + (contentType || "") + ";base64,",
      pending: []
    });
  }
  writeUint8Array(array) {
    const writer = this;
    let indexArray = 0;
    let dataString = writer.pending;
    const delta = writer.pending.length;
    writer.pending = "";
    for (indexArray = 0; indexArray < Math.floor((delta + array.length) / 3) * 3 - delta; indexArray++) {
      dataString += String.fromCharCode(array[indexArray]);
    }
    for (; indexArray < array.length; indexArray++) {
      writer.pending += String.fromCharCode(array[indexArray]);
    }
    if (dataString.length) {
      if (dataString.length > 2) {
        writer.data += btoa(dataString);
      } else {
        writer.pending += dataString;
      }
    }
  }
  getData() {
    return this.data + btoa(this.pending);
  }
};
var BlobReader = class extends Reader {
  constructor(blob) {
    super();
    Object.assign(this, {
      blob,
      size: blob.size
    });
  }
  async readUint8Array(offset, length) {
    const reader = this;
    const offsetEnd = offset + length;
    const blob = offset || offsetEnd < reader.size ? reader.blob.slice(offset, offsetEnd) : reader.blob;
    let arrayBuffer = await blob.arrayBuffer();
    if (arrayBuffer.byteLength > length) {
      arrayBuffer = arrayBuffer.slice(offset, offsetEnd);
    }
    return new Uint8Array(arrayBuffer);
  }
};
var BlobWriter = class extends Stream {
  constructor(contentType) {
    super();
    const writer = this;
    const transformStream = new TransformStream();
    const headers = [];
    if (contentType) {
      headers.push([HTTP_HEADER_CONTENT_TYPE, contentType]);
    }
    Object.defineProperty(writer, PROPERTY_NAME_WRITABLE, {
      get() {
        return transformStream.writable;
      }
    });
    writer.blob = new Response(transformStream.readable, { headers }).blob();
  }
  getData() {
    return this.blob;
  }
};
var TextReader = class extends BlobReader {
  constructor(text) {
    super(new Blob([text], { type: CONTENT_TYPE_TEXT_PLAIN }));
  }
};
var TextWriter = class extends BlobWriter {
  constructor(encoding) {
    super(encoding);
    Object.assign(this, {
      encoding,
      utf8: !encoding || encoding.toLowerCase() == "utf-8"
    });
  }
  async getData() {
    const {
      encoding,
      utf8
    } = this;
    const blob = await super.getData();
    if (blob.text && utf8) {
      return blob.text();
    } else {
      const reader = new FileReader();
      return new Promise((resolve, reject) => {
        Object.assign(reader, {
          onload: ({ target }) => resolve(target.result),
          onerror: () => reject(reader.error)
        });
        reader.readAsText(blob, encoding);
      });
    }
  }
};
var FetchReader = class extends Reader {
  constructor(url, options) {
    super();
    createHttpReader(this, url, options);
  }
  async init() {
    await initHttpReader(this, sendFetchRequest, getFetchRequestData);
    super.init();
  }
  readUint8Array(index2, length) {
    return readUint8ArrayHttpReader(this, index2, length, sendFetchRequest, getFetchRequestData);
  }
};
var XHRReader = class extends Reader {
  constructor(url, options) {
    super();
    createHttpReader(this, url, options);
  }
  async init() {
    await initHttpReader(this, sendXMLHttpRequest, getXMLHttpRequestData);
    super.init();
  }
  readUint8Array(index2, length) {
    return readUint8ArrayHttpReader(this, index2, length, sendXMLHttpRequest, getXMLHttpRequestData);
  }
};
function createHttpReader(httpReader, url, options) {
  const {
    preventHeadRequest,
    useRangeHeader,
    forceRangeRequests,
    combineSizeEocd
  } = options;
  options = Object.assign({}, options);
  delete options.preventHeadRequest;
  delete options.useRangeHeader;
  delete options.forceRangeRequests;
  delete options.combineSizeEocd;
  delete options.useXHR;
  Object.assign(httpReader, {
    url,
    options,
    preventHeadRequest,
    useRangeHeader,
    forceRangeRequests,
    combineSizeEocd
  });
}
async function initHttpReader(httpReader, sendRequest, getRequestData2) {
  const {
    url,
    preventHeadRequest,
    useRangeHeader,
    forceRangeRequests,
    combineSizeEocd
  } = httpReader;
  if (isHttpFamily(url) && (useRangeHeader || forceRangeRequests) && (typeof preventHeadRequest == "undefined" || preventHeadRequest)) {
    const response = await sendRequest(HTTP_METHOD_GET, httpReader, getRangeHeaders(httpReader, combineSizeEocd ? -END_OF_CENTRAL_DIR_LENGTH : void 0));
    const acceptRanges = response.headers.get(HTTP_HEADER_ACCEPT_RANGES);
    if (!forceRangeRequests && (!acceptRanges || acceptRanges.toLowerCase() != HTTP_RANGE_UNIT)) {
      throw new Error(ERR_HTTP_RANGE);
    } else {
      if (combineSizeEocd) {
        httpReader.eocdCache = new Uint8Array(await response.arrayBuffer());
      }
      let contentSize;
      const contentRangeHeader = response.headers.get(HTTP_HEADER_CONTENT_RANGE);
      if (contentRangeHeader) {
        const splitHeader = contentRangeHeader.trim().split(/\s*\/\s*/);
        if (splitHeader.length) {
          const headerValue = splitHeader[1];
          if (headerValue && headerValue != "*") {
            contentSize = Number(headerValue);
          }
        }
      }
      if (contentSize === UNDEFINED_VALUE) {
        await getContentLength(httpReader, sendRequest, getRequestData2);
      } else {
        httpReader.size = contentSize;
      }
    }
  } else {
    await getContentLength(httpReader, sendRequest, getRequestData2);
  }
}
async function readUint8ArrayHttpReader(httpReader, index2, length, sendRequest, getRequestData2) {
  const {
    useRangeHeader,
    forceRangeRequests,
    eocdCache,
    size,
    options
  } = httpReader;
  if (useRangeHeader || forceRangeRequests) {
    if (eocdCache && index2 == size - END_OF_CENTRAL_DIR_LENGTH && length == END_OF_CENTRAL_DIR_LENGTH) {
      return eocdCache;
    }
    if (index2 >= size) {
      return new Uint8Array();
    } else {
      if (index2 + length > size) {
        length = size - index2;
      }
      const response = await sendRequest(HTTP_METHOD_GET, httpReader, getRangeHeaders(httpReader, index2, length));
      if (response.status != 206) {
        throw new Error(ERR_HTTP_RANGE);
      }
      return new Uint8Array(await response.arrayBuffer());
    }
  } else {
    const { data } = httpReader;
    if (!data) {
      await getRequestData2(httpReader, options);
    }
    return new Uint8Array(httpReader.data.subarray(index2, index2 + length));
  }
}
function getRangeHeaders(httpReader, index2 = 0, length = 1) {
  return Object.assign({}, getHeaders(httpReader), { [HTTP_HEADER_RANGE]: HTTP_RANGE_UNIT + "=" + (index2 < 0 ? index2 : index2 + "-" + (index2 + length - 1)) });
}
function getHeaders({ options }) {
  const { headers } = options;
  if (headers) {
    if (Symbol.iterator in headers) {
      return Object.fromEntries(headers);
    } else {
      return headers;
    }
  }
}
async function getFetchRequestData(httpReader) {
  await getRequestData(httpReader, sendFetchRequest);
}
async function getXMLHttpRequestData(httpReader) {
  await getRequestData(httpReader, sendXMLHttpRequest);
}
async function getRequestData(httpReader, sendRequest) {
  const response = await sendRequest(HTTP_METHOD_GET, httpReader, getHeaders(httpReader));
  httpReader.data = new Uint8Array(await response.arrayBuffer());
  if (!httpReader.size) {
    httpReader.size = httpReader.data.length;
  }
}
async function getContentLength(httpReader, sendRequest, getRequestData2) {
  if (httpReader.preventHeadRequest) {
    await getRequestData2(httpReader, httpReader.options);
  } else {
    const response = await sendRequest(HTTP_METHOD_HEAD, httpReader, getHeaders(httpReader));
    const contentLength = response.headers.get(HTTP_HEADER_CONTENT_LENGTH);
    if (contentLength) {
      httpReader.size = Number(contentLength);
    } else {
      await getRequestData2(httpReader, httpReader.options);
    }
  }
}
async function sendFetchRequest(method, { options, url }, headers) {
  const response = await fetch(url, Object.assign({}, options, { method, headers }));
  if (response.status < 400) {
    return response;
  } else {
    throw response.status == 416 ? new Error(ERR_HTTP_RANGE) : new Error(ERR_HTTP_STATUS + (response.statusText || response.status));
  }
}
function sendXMLHttpRequest(method, { url }, headers) {
  return new Promise((resolve, reject) => {
    const request = new XMLHttpRequest();
    request.addEventListener("load", () => {
      if (request.status < 400) {
        const headers2 = [];
        request.getAllResponseHeaders().trim().split(/[\r\n]+/).forEach((header) => {
          const splitHeader = header.trim().split(/\s*:\s*/);
          splitHeader[0] = splitHeader[0].trim().replace(/^[a-z]|-[a-z]/g, (value) => value.toUpperCase());
          headers2.push(splitHeader);
        });
        resolve({
          status: request.status,
          arrayBuffer: () => request.response,
          headers: new Map(headers2)
        });
      } else {
        reject(request.status == 416 ? new Error(ERR_HTTP_RANGE) : new Error(ERR_HTTP_STATUS + (request.statusText || request.status)));
      }
    }, false);
    request.addEventListener("error", (event) => reject(event.detail ? event.detail.error : new Error("Network error")), false);
    request.open(method, url);
    if (headers) {
      for (const entry of Object.entries(headers)) {
        request.setRequestHeader(entry[0], entry[1]);
      }
    }
    request.responseType = "arraybuffer";
    request.send();
  });
}
var HttpReader = class extends Reader {
  constructor(url, options = {}) {
    super();
    Object.assign(this, {
      url,
      reader: options.useXHR ? new XHRReader(url, options) : new FetchReader(url, options)
    });
  }
  set size(value) {
  }
  get size() {
    return this.reader.size;
  }
  async init() {
    await this.reader.init();
    super.init();
  }
  readUint8Array(index2, length) {
    return this.reader.readUint8Array(index2, length);
  }
};
var HttpRangeReader = class extends HttpReader {
  constructor(url, options = {}) {
    options.useRangeHeader = true;
    super(url, options);
  }
};
var Uint8ArrayReader = class extends Reader {
  constructor(array) {
    super();
    array = new Uint8Array(array.buffer, array.byteOffset, array.byteLength);
    Object.assign(this, {
      array,
      size: array.length
    });
  }
  readUint8Array(index2, length) {
    return this.array.slice(index2, index2 + length);
  }
};
var Uint8ArrayWriter = class extends Writer {
  constructor(defaultBufferSize) {
    super();
    this.defaultBufferSize = defaultBufferSize || DEFAULT_BUFFER_SIZE;
  }
  init(initSize = 0) {
    Object.assign(this, {
      offset: 0,
      array: new Uint8Array(initSize > 0 ? initSize : this.defaultBufferSize)
    });
    super.init();
  }
  writeUint8Array(array) {
    const writer = this;
    const requiredLength = writer.offset + array.length;
    if (requiredLength > writer.array.length) {
      let newLength = writer.array.length ? writer.array.length * 2 : writer.defaultBufferSize;
      while (newLength < requiredLength) {
        newLength *= 2;
      }
      const previousArray = writer.array;
      writer.array = new Uint8Array(newLength);
      writer.array.set(previousArray);
    }
    writer.array.set(array, writer.offset);
    writer.offset += array.length;
  }
  getData() {
    if (this.offset === this.array.length) {
      return this.array;
    } else {
      return this.array.slice(0, this.offset);
    }
  }
};
var SplitDataReader = class extends Reader {
  constructor(readers) {
    super();
    this.readers = readers;
  }
  async init() {
    const reader = this;
    const { readers } = reader;
    reader.lastDiskNumber = 0;
    reader.lastDiskOffset = 0;
    await Promise.all(readers.map(async (diskReader, indexDiskReader) => {
      await diskReader.init();
      if (indexDiskReader != readers.length - 1) {
        reader.lastDiskOffset += diskReader.size;
      }
      reader.size += diskReader.size;
    }));
    super.init();
  }
  async readUint8Array(offset, length, diskNumber = 0) {
    const reader = this;
    const { readers } = this;
    let result;
    let currentDiskNumber = diskNumber;
    if (currentDiskNumber == -1) {
      currentDiskNumber = readers.length - 1;
    }
    let currentReaderOffset = offset;
    while (readers[currentDiskNumber] && currentReaderOffset >= readers[currentDiskNumber].size) {
      currentReaderOffset -= readers[currentDiskNumber].size;
      currentDiskNumber++;
    }
    const currentReader = readers[currentDiskNumber];
    if (currentReader) {
      const currentReaderSize = currentReader.size;
      if (currentReaderOffset + length <= currentReaderSize) {
        result = await readUint8Array(currentReader, currentReaderOffset, length);
      } else {
        const chunkLength = currentReaderSize - currentReaderOffset;
        result = new Uint8Array(length);
        const firstPart = await readUint8Array(currentReader, currentReaderOffset, chunkLength);
        result.set(firstPart, 0);
        const secondPart = await reader.readUint8Array(offset + chunkLength, length - chunkLength, diskNumber);
        result.set(secondPart, chunkLength);
        if (firstPart.length + secondPart.length < length) {
          result = result.subarray(0, firstPart.length + secondPart.length);
        }
      }
    } else {
      result = new Uint8Array();
    }
    reader.lastDiskNumber = Math.max(currentDiskNumber, reader.lastDiskNumber);
    return result;
  }
};
var SplitDataWriter = class extends Stream {
  constructor(writerGenerator, maxSize = 4294967295) {
    super();
    const writer = this;
    Object.assign(writer, {
      diskNumber: 0,
      diskOffset: 0,
      size: 0,
      maxSize,
      availableSize: maxSize
    });
    let diskSourceWriter, diskWritable, diskWriter;
    const writable = new WritableStream({
      async write(chunk) {
        const { availableSize } = writer;
        if (!diskWriter) {
          const { value, done } = await writerGenerator.next();
          if (done && !value) {
            throw new Error(ERR_ITERATOR_COMPLETED_TOO_SOON);
          } else {
            diskSourceWriter = value;
            diskSourceWriter.size = 0;
            if (diskSourceWriter.maxSize) {
              writer.maxSize = diskSourceWriter.maxSize;
            }
            writer.availableSize = writer.maxSize;
            await initStream(diskSourceWriter);
            diskWritable = value.writable;
            diskWriter = diskWritable.getWriter();
          }
          await this.write(chunk);
        } else if (chunk.length >= availableSize) {
          await writeChunk(chunk.subarray(0, availableSize));
          await closeDisk();
          writer.diskOffset += diskSourceWriter.size;
          writer.diskNumber++;
          diskWriter = null;
          await this.write(chunk.subarray(availableSize));
        } else {
          await writeChunk(chunk);
        }
      },
      async close() {
        await diskWriter.ready;
        await closeDisk();
      }
    });
    Object.defineProperty(writer, PROPERTY_NAME_WRITABLE, {
      get() {
        return writable;
      }
    });
    async function writeChunk(chunk) {
      const chunkLength = chunk.length;
      if (chunkLength) {
        await diskWriter.ready;
        await diskWriter.write(chunk);
        diskSourceWriter.size += chunkLength;
        writer.size += chunkLength;
        writer.availableSize -= chunkLength;
      }
    }
    async function closeDisk() {
      await diskWriter.close();
    }
  }
};
var GenericReader = class {
  constructor(reader) {
    if (Array.isArray(reader)) {
      reader = new SplitDataReader(reader);
    }
    if (reader instanceof ReadableStream) {
      reader = {
        readable: reader
      };
    }
    return reader;
  }
};
var GenericWriter = class {
  constructor(writer) {
    if (writer.writable === UNDEFINED_VALUE && typeof writer.next == FUNCTION_TYPE) {
      writer = new SplitDataWriter(writer);
    }
    if (writer instanceof WritableStream) {
      writer = {
        writable: writer
      };
    }
    if (writer.size === UNDEFINED_VALUE) {
      writer.size = 0;
    }
    if (!(writer instanceof SplitDataWriter)) {
      Object.assign(writer, {
        diskNumber: 0,
        diskOffset: 0,
        availableSize: Infinity,
        maxSize: Infinity
      });
    }
    return writer;
  }
};
function isHttpFamily(url) {
  const { baseURI } = getConfiguration();
  const { protocol } = new URL(url, baseURI);
  return protocol == "http:" || protocol == "https:";
}
async function initStream(stream, initSize) {
  if (stream.init && !stream.initialized) {
    await stream.init(initSize);
  } else {
    return Promise.resolve();
  }
}
function readUint8Array(reader, offset, size, diskNumber) {
  return reader.readUint8Array(offset, size, diskNumber);
}

// node_modules/@zip.js/zip.js/lib/core/util/decode-cp437.js
var CP437 = "\0\u263A\u263B\u2665\u2666\u2663\u2660\u2022\u25D8\u25CB\u25D9\u2642\u2640\u266A\u266B\u263C\u25BA\u25C4\u2195\u203C\xB6\xA7\u25AC\u21A8\u2191\u2193\u2192\u2190\u221F\u2194\u25B2\u25BC !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u2302\xC7\xFC\xE9\xE2\xE4\xE0\xE5\xE7\xEA\xEB\xE8\xEF\xEE\xEC\xC4\xC5\xC9\xE6\xC6\xF4\xF6\xF2\xFB\xF9\xFF\xD6\xDC\xA2\xA3\xA5\u20A7\u0192\xE1\xED\xF3\xFA\xF1\xD1\xAA\xBA\xBF\u2310\xAC\xBD\xBC\xA1\xAB\xBB\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255D\u255C\u255B\u2510\u2514\u2534\u252C\u251C\u2500\u253C\u255E\u255F\u255A\u2554\u2569\u2566\u2560\u2550\u256C\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256B\u256A\u2518\u250C\u2588\u2584\u258C\u2590\u2580\u03B1\xDF\u0393\u03C0\u03A3\u03C3\xB5\u03C4\u03A6\u0398\u03A9\u03B4\u221E\u03C6\u03B5\u2229\u2261\xB1\u2265\u2264\u2320\u2321\xF7\u2248\xB0\u2219\xB7\u221A\u207F\xB2\u25A0 ".split("");
var VALID_CP437 = CP437.length == 256;
function decodeCP437(stringValue) {
  if (VALID_CP437) {
    let result = "";
    for (let indexCharacter = 0; indexCharacter < stringValue.length; indexCharacter++) {
      result += CP437[stringValue[indexCharacter]];
    }
    return result;
  } else {
    return new TextDecoder().decode(stringValue);
  }
}

// node_modules/@zip.js/zip.js/lib/core/util/decode-text.js
function decodeText(value, encoding) {
  if (encoding && encoding.trim().toLowerCase() == "cp437") {
    return decodeCP437(value);
  } else {
    return new TextDecoder(encoding).decode(value);
  }
}

// node_modules/@zip.js/zip.js/lib/core/zip-entry.js
var PROPERTY_NAME_FILENAME = "filename";
var PROPERTY_NAME_RAW_FILENAME = "rawFilename";
var PROPERTY_NAME_COMMENT = "comment";
var PROPERTY_NAME_RAW_COMMENT = "rawComment";
var PROPERTY_NAME_UNCOMPRESSED_SIZE = "uncompressedSize";
var PROPERTY_NAME_COMPRESSED_SIZE = "compressedSize";
var PROPERTY_NAME_OFFSET = "offset";
var PROPERTY_NAME_DISK_NUMBER_START = "diskNumberStart";
var PROPERTY_NAME_LAST_MODIFICATION_DATE = "lastModDate";
var PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE = "rawLastModDate";
var PROPERTY_NAME_LAST_ACCESS_DATE = "lastAccessDate";
var PROPERTY_NAME_RAW_LAST_ACCESS_DATE = "rawLastAccessDate";
var PROPERTY_NAME_CREATION_DATE = "creationDate";
var PROPERTY_NAME_RAW_CREATION_DATE = "rawCreationDate";
var PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES = "internalFileAttributes";
var PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES = "externalFileAttributes";
var PROPERTY_NAME_MSDOS_ATTRIBUTES_RAW = "msdosAttributesRaw";
var PROPERTY_NAME_MSDOS_ATTRIBUTES = "msdosAttributes";
var PROPERTY_NAME_MS_DOS_COMPATIBLE = "msDosCompatible";
var PROPERTY_NAME_ZIP64 = "zip64";
var PROPERTY_NAME_ENCRYPTED = "encrypted";
var PROPERTY_NAME_VERSION = "version";
var PROPERTY_NAME_VERSION_MADE_BY = "versionMadeBy";
var PROPERTY_NAME_ZIPCRYPTO = "zipCrypto";
var PROPERTY_NAME_DIRECTORY = "directory";
var PROPERTY_NAME_EXECUTABLE = "executable";
var PROPERTY_NAME_COMPRESSION_METHOD = "compressionMethod";
var PROPERTY_NAME_SIGNATURE = "signature";
var PROPERTY_NAME_EXTRA_FIELD = "extraField";
var PROPERTY_NAME_EXTRA_FIELD_INFOZIP = "extraFieldInfoZip";
var PROPERTY_NAME_EXTRA_FIELD_UNIX = "extraFieldUnix";
var PROPERTY_NAME_UID = "uid";
var PROPERTY_NAME_GID = "gid";
var PROPERTY_NAME_UNIX_MODE = "unixMode";
var PROPERTY_NAME_SETUID = "setuid";
var PROPERTY_NAME_SETGID = "setgid";
var PROPERTY_NAME_STICKY = "sticky";
var PROPERTY_NAME_BITFLAG = "bitFlag";
var PROPERTY_NAME_FILENAME_UTF8 = "filenameUTF8";
var PROPERTY_NAME_COMMENT_UTF8 = "commentUTF8";
var PROPERTY_NAME_RAW_EXTRA_FIELD = "rawExtraField";
var PROPERTY_NAME_EXTRA_FIELD_ZIP64 = "extraFieldZip64";
var PROPERTY_NAME_EXTRA_FIELD_UNICODE_PATH = "extraFieldUnicodePath";
var PROPERTY_NAME_EXTRA_FIELD_UNICODE_COMMENT = "extraFieldUnicodeComment";
var PROPERTY_NAME_EXTRA_FIELD_AES = "extraFieldAES";
var PROPERTY_NAME_EXTRA_FIELD_NTFS = "extraFieldNTFS";
var PROPERTY_NAME_EXTRA_FIELD_EXTENDED_TIMESTAMP = "extraFieldExtendedTimestamp";
var PROPERTY_NAMES = [
  PROPERTY_NAME_FILENAME,
  PROPERTY_NAME_RAW_FILENAME,
  PROPERTY_NAME_UNCOMPRESSED_SIZE,
  PROPERTY_NAME_COMPRESSED_SIZE,
  PROPERTY_NAME_LAST_MODIFICATION_DATE,
  PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE,
  PROPERTY_NAME_COMMENT,
  PROPERTY_NAME_RAW_COMMENT,
  PROPERTY_NAME_LAST_ACCESS_DATE,
  PROPERTY_NAME_CREATION_DATE,
  PROPERTY_NAME_RAW_CREATION_DATE,
  PROPERTY_NAME_OFFSET,
  PROPERTY_NAME_DISK_NUMBER_START,
  PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES,
  PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES,
  PROPERTY_NAME_MSDOS_ATTRIBUTES_RAW,
  PROPERTY_NAME_MSDOS_ATTRIBUTES,
  PROPERTY_NAME_MS_DOS_COMPATIBLE,
  PROPERTY_NAME_ZIP64,
  PROPERTY_NAME_ENCRYPTED,
  PROPERTY_NAME_VERSION,
  PROPERTY_NAME_VERSION_MADE_BY,
  PROPERTY_NAME_ZIPCRYPTO,
  PROPERTY_NAME_DIRECTORY,
  PROPERTY_NAME_EXECUTABLE,
  PROPERTY_NAME_COMPRESSION_METHOD,
  PROPERTY_NAME_SIGNATURE,
  PROPERTY_NAME_EXTRA_FIELD,
  PROPERTY_NAME_EXTRA_FIELD_UNIX,
  PROPERTY_NAME_EXTRA_FIELD_INFOZIP,
  PROPERTY_NAME_UID,
  PROPERTY_NAME_GID,
  PROPERTY_NAME_UNIX_MODE,
  PROPERTY_NAME_SETUID,
  PROPERTY_NAME_SETGID,
  PROPERTY_NAME_STICKY,
  PROPERTY_NAME_BITFLAG,
  PROPERTY_NAME_FILENAME_UTF8,
  PROPERTY_NAME_COMMENT_UTF8,
  PROPERTY_NAME_RAW_EXTRA_FIELD,
  PROPERTY_NAME_EXTRA_FIELD_ZIP64,
  PROPERTY_NAME_EXTRA_FIELD_UNICODE_PATH,
  PROPERTY_NAME_EXTRA_FIELD_UNICODE_COMMENT,
  PROPERTY_NAME_EXTRA_FIELD_AES,
  PROPERTY_NAME_EXTRA_FIELD_NTFS,
  PROPERTY_NAME_EXTRA_FIELD_EXTENDED_TIMESTAMP
];
var Entry = class {
  constructor(data) {
    PROPERTY_NAMES.forEach((name) => this[name] = data[name]);
  }
};

// node_modules/@zip.js/zip.js/lib/core/options.js
var OPTION_FILENAME_ENCODING = "filenameEncoding";
var OPTION_COMMENT_ENCODING = "commentEncoding";
var OPTION_DECODE_TEXT = "decodeText";
var OPTION_EXTRACT_PREPENDED_DATA = "extractPrependedData";
var OPTION_EXTRACT_APPENDED_DATA = "extractAppendedData";
var OPTION_PASSWORD = "password";
var OPTION_RAW_PASSWORD = "rawPassword";
var OPTION_PASS_THROUGH = "passThrough";
var OPTION_SIGNAL = "signal";
var OPTION_CHECK_PASSWORD_ONLY = "checkPasswordOnly";
var OPTION_CHECK_OVERLAPPING_ENTRY_ONLY = "checkOverlappingEntryOnly";
var OPTION_CHECK_OVERLAPPING_ENTRY = "checkOverlappingEntry";
var OPTION_CHECK_SIGNATURE = "checkSignature";
var OPTION_USE_WEB_WORKERS = "useWebWorkers";
var OPTION_USE_COMPRESSION_STREAM = "useCompressionStream";
var OPTION_TRANSFER_STREAMS = "transferStreams";
var OPTION_PREVENT_CLOSE = "preventClose";
var OPTION_ENCRYPTION_STRENGTH = "encryptionStrength";
var OPTION_EXTENDED_TIMESTAMP = "extendedTimestamp";
var OPTION_KEEP_ORDER = "keepOrder";
var OPTION_LEVEL = "level";
var OPTION_BUFFERED_WRITE = "bufferedWrite";
var OPTION_DATA_DESCRIPTOR_SIGNATURE = "dataDescriptorSignature";
var OPTION_USE_UNICODE_FILE_NAMES = "useUnicodeFileNames";
var OPTION_DATA_DESCRIPTOR = "dataDescriptor";
var OPTION_SUPPORT_ZIP64_SPLIT_FILE = "supportZip64SplitFile";
var OPTION_ENCODE_TEXT = "encodeText";
var OPTION_OFFSET = "offset";
var OPTION_USDZ = "usdz";
var OPTION_UNIX_EXTRA_FIELD_TYPE = "unixExtraFieldType";

// node_modules/@zip.js/zip.js/lib/core/zip-reader.js
var ERR_BAD_FORMAT = "File format is not recognized";
var ERR_EOCDR_NOT_FOUND = "End of central directory not found";
var ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND = "End of Zip64 central directory locator not found";
var ERR_CENTRAL_DIRECTORY_NOT_FOUND = "Central directory header not found";
var ERR_LOCAL_FILE_HEADER_NOT_FOUND = "Local file header not found";
var ERR_EXTRAFIELD_ZIP64_NOT_FOUND = "Zip64 extra field not found";
var ERR_ENCRYPTED = "File contains encrypted entry";
var ERR_UNSUPPORTED_ENCRYPTION = "Encryption method not supported";
var ERR_UNSUPPORTED_COMPRESSION = "Compression method not supported";
var ERR_SPLIT_ZIP_FILE = "Split zip file";
var ERR_OVERLAPPING_ENTRY = "Overlapping entry found";
var CHARSET_UTF8 = "utf-8";
var PROPERTY_NAME_UTF8_SUFFIX = "UTF8";
var CHARSET_CP437 = "cp437";
var ZIP64_PROPERTIES = [
  [PROPERTY_NAME_UNCOMPRESSED_SIZE, MAX_32_BITS],
  [PROPERTY_NAME_COMPRESSED_SIZE, MAX_32_BITS],
  [PROPERTY_NAME_OFFSET, MAX_32_BITS],
  [PROPERTY_NAME_DISK_NUMBER_START, MAX_16_BITS]
];
var ZIP64_EXTRACTION = {
  [MAX_16_BITS]: {
    getValue: getUint32,
    bytes: 4
  },
  [MAX_32_BITS]: {
    getValue: getBigUint64,
    bytes: 8
  }
};
var ZipReader = class {
  constructor(reader, options = {}) {
    Object.assign(this, {
      reader: new GenericReader(reader),
      options,
      config: getConfiguration(),
      readRanges: []
    });
  }
  async *getEntriesGenerator(options = {}) {
    const zipReader = this;
    let { reader } = zipReader;
    const { config: config2 } = zipReader;
    await initStream(reader);
    if (reader.size === UNDEFINED_VALUE || !reader.readUint8Array) {
      reader = new BlobReader(await new Response(reader.readable).blob());
      await initStream(reader);
    }
    if (reader.size < END_OF_CENTRAL_DIR_LENGTH) {
      throw new Error(ERR_BAD_FORMAT);
    }
    reader.chunkSize = getChunkSize(config2);
    const endOfDirectoryInfo = await seekSignature(reader, END_OF_CENTRAL_DIR_SIGNATURE, reader.size, END_OF_CENTRAL_DIR_LENGTH, MAX_16_BITS * 16);
    if (!endOfDirectoryInfo) {
      const signatureArray = await readUint8Array(reader, 0, 4);
      const signatureView = getDataView(signatureArray);
      if (getUint32(signatureView) == SPLIT_ZIP_FILE_SIGNATURE) {
        throw new Error(ERR_SPLIT_ZIP_FILE);
      } else {
        throw new Error(ERR_EOCDR_NOT_FOUND);
      }
    }
    const endOfDirectoryView = getDataView(endOfDirectoryInfo);
    let directoryDataLength = getUint32(endOfDirectoryView, 12);
    let directoryDataOffset = getUint32(endOfDirectoryView, 16);
    const commentOffset = endOfDirectoryInfo.offset;
    const commentLength = getUint16(endOfDirectoryView, 20);
    const appendedDataOffset = commentOffset + END_OF_CENTRAL_DIR_LENGTH + commentLength;
    let lastDiskNumber = getUint16(endOfDirectoryView, 4);
    const expectedLastDiskNumber = reader.lastDiskNumber || 0;
    let diskNumber = getUint16(endOfDirectoryView, 6);
    let filesLength = getUint16(endOfDirectoryView, 8);
    let prependedDataLength = 0;
    let startOffset = 0;
    if (directoryDataOffset == MAX_32_BITS || directoryDataLength == MAX_32_BITS || filesLength == MAX_16_BITS || diskNumber == MAX_16_BITS) {
      const endOfDirectoryLocatorArray = await readUint8Array(reader, endOfDirectoryInfo.offset - ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH, ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH);
      const endOfDirectoryLocatorView = getDataView(endOfDirectoryLocatorArray);
      if (getUint32(endOfDirectoryLocatorView, 0) == ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE) {
        directoryDataOffset = getBigUint64(endOfDirectoryLocatorView, 8);
        let endOfDirectoryArray = await readUint8Array(reader, directoryDataOffset, ZIP64_END_OF_CENTRAL_DIR_LENGTH, -1);
        let endOfDirectoryView2 = getDataView(endOfDirectoryArray);
        const expectedDirectoryDataOffset = endOfDirectoryInfo.offset - ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH - ZIP64_END_OF_CENTRAL_DIR_LENGTH;
        if (getUint32(endOfDirectoryView2, 0) != ZIP64_END_OF_CENTRAL_DIR_SIGNATURE && directoryDataOffset != expectedDirectoryDataOffset) {
          const originalDirectoryDataOffset = directoryDataOffset;
          directoryDataOffset = expectedDirectoryDataOffset;
          if (directoryDataOffset > originalDirectoryDataOffset) {
            prependedDataLength = directoryDataOffset - originalDirectoryDataOffset;
          }
          endOfDirectoryArray = await readUint8Array(reader, directoryDataOffset, ZIP64_END_OF_CENTRAL_DIR_LENGTH, -1);
          endOfDirectoryView2 = getDataView(endOfDirectoryArray);
        }
        if (getUint32(endOfDirectoryView2, 0) != ZIP64_END_OF_CENTRAL_DIR_SIGNATURE) {
          throw new Error(ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND);
        }
        if (lastDiskNumber == MAX_16_BITS) {
          lastDiskNumber = getUint32(endOfDirectoryView2, 16);
        }
        if (diskNumber == MAX_16_BITS) {
          diskNumber = getUint32(endOfDirectoryView2, 20);
        }
        if (filesLength == MAX_16_BITS) {
          filesLength = getBigUint64(endOfDirectoryView2, 32);
        }
        if (directoryDataLength == MAX_32_BITS) {
          directoryDataLength = getBigUint64(endOfDirectoryView2, 40);
        }
        directoryDataOffset -= directoryDataLength;
      }
    }
    if (directoryDataOffset >= reader.size) {
      prependedDataLength = reader.size - directoryDataOffset - directoryDataLength - END_OF_CENTRAL_DIR_LENGTH;
      directoryDataOffset = reader.size - directoryDataLength - END_OF_CENTRAL_DIR_LENGTH;
    }
    if (expectedLastDiskNumber != lastDiskNumber) {
      throw new Error(ERR_SPLIT_ZIP_FILE);
    }
    if (directoryDataOffset < 0) {
      throw new Error(ERR_BAD_FORMAT);
    }
    let offset = 0;
    let directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
    let directoryView = getDataView(directoryArray);
    if (directoryDataLength) {
      const expectedDirectoryDataOffset = endOfDirectoryInfo.offset - directoryDataLength;
      if (getUint32(directoryView, offset) != CENTRAL_FILE_HEADER_SIGNATURE && directoryDataOffset != expectedDirectoryDataOffset) {
        const originalDirectoryDataOffset = directoryDataOffset;
        directoryDataOffset = expectedDirectoryDataOffset;
        if (directoryDataOffset > originalDirectoryDataOffset) {
          prependedDataLength += directoryDataOffset - originalDirectoryDataOffset;
        }
        directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
        directoryView = getDataView(directoryArray);
      }
    }
    const expectedDirectoryDataLength = endOfDirectoryInfo.offset - directoryDataOffset - (reader.lastDiskOffset || 0);
    if (directoryDataLength != expectedDirectoryDataLength && expectedDirectoryDataLength >= 0) {
      directoryDataLength = expectedDirectoryDataLength;
      directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
      directoryView = getDataView(directoryArray);
    }
    if (directoryDataOffset < 0 || directoryDataOffset >= reader.size) {
      throw new Error(ERR_BAD_FORMAT);
    }
    const filenameEncoding = getOptionValue(zipReader, options, OPTION_FILENAME_ENCODING);
    const commentEncoding = getOptionValue(zipReader, options, OPTION_COMMENT_ENCODING);
    for (let indexFile = 0; indexFile < filesLength; indexFile++) {
      const fileEntry = new ZipEntry(reader, config2, zipReader.options);
      if (getUint32(directoryView, offset) != CENTRAL_FILE_HEADER_SIGNATURE) {
        throw new Error(ERR_CENTRAL_DIRECTORY_NOT_FOUND);
      }
      readCommonHeader(fileEntry, directoryView, offset + 6);
      const languageEncodingFlag = Boolean(fileEntry.bitFlag.languageEncodingFlag);
      const filenameOffset = offset + 46;
      const extraFieldOffset = filenameOffset + fileEntry.filenameLength;
      const commentOffset2 = extraFieldOffset + fileEntry.extraFieldLength;
      const versionMadeBy = getUint16(directoryView, offset + 4);
      const msDosCompatible = versionMadeBy >> 8 == 0;
      const unixCompatible = versionMadeBy >> 8 == 3;
      const rawFilename = directoryArray.subarray(filenameOffset, extraFieldOffset);
      const commentLength2 = getUint16(directoryView, offset + 32);
      const endOffset = commentOffset2 + commentLength2;
      const rawComment = directoryArray.subarray(commentOffset2, endOffset);
      const filenameUTF8 = languageEncodingFlag;
      const commentUTF8 = languageEncodingFlag;
      const externalFileAttributes = getUint32(directoryView, offset + 38);
      const msdosAttributesRaw = externalFileAttributes & MAX_8_BITS;
      const msdosAttributes = {
        readOnly: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_READONLY_MASK),
        hidden: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_HIDDEN_MASK),
        system: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_SYSTEM_MASK),
        directory: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_DIR_MASK),
        archive: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_ARCHIVE_MASK)
      };
      const offsetFileEntry = getUint32(directoryView, offset + 42) + prependedDataLength;
      const decode = getOptionValue(zipReader, options, OPTION_DECODE_TEXT) || decodeText;
      const rawFilenameEncoding = filenameUTF8 ? CHARSET_UTF8 : filenameEncoding || CHARSET_CP437;
      const rawCommentEncoding = commentUTF8 ? CHARSET_UTF8 : commentEncoding || CHARSET_CP437;
      let filename = decode(rawFilename, rawFilenameEncoding);
      if (filename === UNDEFINED_VALUE) {
        filename = decodeText(rawFilename, rawFilenameEncoding);
      }
      let comment = decode(rawComment, rawCommentEncoding);
      if (comment === UNDEFINED_VALUE) {
        comment = decodeText(rawComment, rawCommentEncoding);
      }
      Object.assign(fileEntry, {
        versionMadeBy,
        msDosCompatible,
        compressedSize: 0,
        uncompressedSize: 0,
        commentLength: commentLength2,
        offset: offsetFileEntry,
        diskNumberStart: getUint16(directoryView, offset + 34),
        internalFileAttributes: getUint16(directoryView, offset + 36),
        externalFileAttributes,
        msdosAttributesRaw,
        msdosAttributes,
        rawFilename,
        filenameUTF8,
        commentUTF8,
        rawExtraField: directoryArray.subarray(extraFieldOffset, commentOffset2),
        rawComment,
        filename,
        comment
      });
      startOffset = Math.max(offsetFileEntry, startOffset);
      readCommonFooter(fileEntry, fileEntry, directoryView, offset + 6);
      const unixExternalUpper = fileEntry.externalFileAttributes >> 16 & MAX_16_BITS;
      if (fileEntry.unixMode === UNDEFINED_VALUE && (unixExternalUpper & (FILE_ATTR_UNIX_DEFAULT_MASK | FILE_ATTR_UNIX_EXECUTABLE_MASK | FILE_ATTR_UNIX_TYPE_DIR)) != 0) {
        fileEntry.unixMode = unixExternalUpper;
      }
      const setuid = Boolean(fileEntry.unixMode & FILE_ATTR_UNIX_SETUID_MASK);
      const setgid = Boolean(fileEntry.unixMode & FILE_ATTR_UNIX_SETGID_MASK);
      const sticky = Boolean(fileEntry.unixMode & FILE_ATTR_UNIX_STICKY_MASK);
      const executable = fileEntry.unixMode !== UNDEFINED_VALUE ? (fileEntry.unixMode & FILE_ATTR_UNIX_EXECUTABLE_MASK) != 0 : unixCompatible && (unixExternalUpper & FILE_ATTR_UNIX_EXECUTABLE_MASK) != 0;
      const modeIsDir = fileEntry.unixMode !== UNDEFINED_VALUE && (fileEntry.unixMode & FILE_ATTR_UNIX_TYPE_MASK) == FILE_ATTR_UNIX_TYPE_DIR;
      const upperIsDir = (unixExternalUpper & FILE_ATTR_UNIX_TYPE_MASK) == FILE_ATTR_UNIX_TYPE_DIR;
      Object.assign(fileEntry, {
        setuid,
        setgid,
        sticky,
        unixExternalUpper,
        internalFileAttribute: fileEntry.internalFileAttributes,
        externalFileAttribute: fileEntry.externalFileAttributes,
        executable,
        directory: modeIsDir || upperIsDir || msDosCompatible && msdosAttributes.directory || filename.endsWith(DIRECTORY_SIGNATURE) && !fileEntry.uncompressedSize,
        zipCrypto: fileEntry.encrypted && !fileEntry.extraFieldAES
      });
      const entry = new Entry(fileEntry);
      entry.getData = (writer, options2) => fileEntry.getData(writer, entry, zipReader.readRanges, options2);
      entry.arrayBuffer = async (options2) => {
        const writer = new TransformStream();
        const [arrayBuffer] = await Promise.all([
          new Response(writer.readable).arrayBuffer(),
          fileEntry.getData(writer, entry, zipReader.readRanges, options2)
        ]);
        return arrayBuffer;
      };
      offset = endOffset;
      const { onprogress } = options;
      if (onprogress) {
        try {
          await onprogress(indexFile + 1, filesLength, new Entry(fileEntry));
        } catch {
        }
      }
      yield entry;
    }
    const extractPrependedData = getOptionValue(zipReader, options, OPTION_EXTRACT_PREPENDED_DATA);
    const extractAppendedData = getOptionValue(zipReader, options, OPTION_EXTRACT_APPENDED_DATA);
    if (extractPrependedData) {
      zipReader.prependedData = startOffset > 0 ? await readUint8Array(reader, 0, startOffset) : new Uint8Array();
    }
    zipReader.comment = commentLength ? await readUint8Array(reader, commentOffset + END_OF_CENTRAL_DIR_LENGTH, commentLength) : new Uint8Array();
    if (extractAppendedData) {
      zipReader.appendedData = appendedDataOffset < reader.size ? await readUint8Array(reader, appendedDataOffset, reader.size - appendedDataOffset) : new Uint8Array();
    }
    return true;
  }
  async getEntries(options = {}) {
    const entries = [];
    for await (const entry of this.getEntriesGenerator(options)) {
      entries.push(entry);
    }
    return entries;
  }
  async close() {
  }
};
var ZipReaderStream = class {
  constructor(options = {}) {
    const { readable, writable } = new TransformStream();
    const gen = new ZipReader(readable, options).getEntriesGenerator();
    this.readable = new ReadableStream({
      async pull(controller) {
        const { done, value } = await gen.next();
        if (done)
          return controller.close();
        const chunk = {
          ...value,
          readable: (function() {
            const { readable: readable2, writable: writable2 } = new TransformStream();
            if (value.getData) {
              value.getData(writable2);
              return readable2;
            }
          })()
        };
        delete chunk.getData;
        controller.enqueue(chunk);
      }
    });
    this.writable = writable;
  }
};
var ZipEntry = class {
  constructor(reader, config2, options) {
    Object.assign(this, {
      reader,
      config: config2,
      options
    });
  }
  async getData(writer, fileEntry, readRanges, options = {}) {
    const zipEntry = this;
    const {
      reader,
      offset,
      diskNumberStart,
      extraFieldAES,
      extraFieldZip64,
      compressionMethod,
      config: config2,
      bitFlag,
      signature,
      rawLastModDate,
      uncompressedSize,
      compressedSize
    } = zipEntry;
    const {
      dataDescriptor
    } = bitFlag;
    const localDirectory = fileEntry.localDirectory = {};
    const dataArray = await readUint8Array(reader, offset, HEADER_SIZE, diskNumberStart);
    const dataView = getDataView(dataArray);
    let password = getOptionValue(zipEntry, options, OPTION_PASSWORD);
    let rawPassword = getOptionValue(zipEntry, options, OPTION_RAW_PASSWORD);
    const passThrough = getOptionValue(zipEntry, options, OPTION_PASS_THROUGH);
    password = password && password.length && password;
    rawPassword = rawPassword && rawPassword.length && rawPassword;
    if (extraFieldAES) {
      if (extraFieldAES.originalCompressionMethod != COMPRESSION_METHOD_AES) {
        throw new Error(ERR_UNSUPPORTED_COMPRESSION);
      }
    }
    if (compressionMethod != COMPRESSION_METHOD_STORE && compressionMethod != COMPRESSION_METHOD_DEFLATE && compressionMethod != COMPRESSION_METHOD_DEFLATE_64 && !passThrough) {
      throw new Error(ERR_UNSUPPORTED_COMPRESSION);
    }
    if (getUint32(dataView, 0) != LOCAL_FILE_HEADER_SIGNATURE) {
      throw new Error(ERR_LOCAL_FILE_HEADER_NOT_FOUND);
    }
    readCommonHeader(localDirectory, dataView, 4);
    const {
      extraFieldLength,
      filenameLength,
      lastAccessDate,
      creationDate
    } = localDirectory;
    localDirectory.rawExtraField = extraFieldLength ? await readUint8Array(reader, offset + HEADER_SIZE + filenameLength, extraFieldLength, diskNumberStart) : new Uint8Array();
    readCommonFooter(zipEntry, localDirectory, dataView, 4, true);
    Object.assign(fileEntry, { lastAccessDate, creationDate });
    const encrypted = zipEntry.encrypted && localDirectory.encrypted && !passThrough;
    const zipCrypto = encrypted && !extraFieldAES;
    if (!passThrough) {
      fileEntry.zipCrypto = zipCrypto;
    }
    if (encrypted) {
      if (!zipCrypto && extraFieldAES.strength === UNDEFINED_VALUE) {
        throw new Error(ERR_UNSUPPORTED_ENCRYPTION);
      } else if (!password && !rawPassword) {
        throw new Error(ERR_ENCRYPTED);
      }
    }
    const dataOffset = offset + HEADER_SIZE + filenameLength + extraFieldLength;
    const size = compressedSize;
    const readable = reader.readable;
    Object.assign(readable, {
      diskNumberStart,
      offset: dataOffset,
      size
    });
    const signal = getOptionValue(zipEntry, options, OPTION_SIGNAL);
    const checkPasswordOnly = getOptionValue(zipEntry, options, OPTION_CHECK_PASSWORD_ONLY);
    let checkOverlappingEntry = getOptionValue(zipEntry, options, OPTION_CHECK_OVERLAPPING_ENTRY);
    const checkOverlappingEntryOnly = getOptionValue(zipEntry, options, OPTION_CHECK_OVERLAPPING_ENTRY_ONLY);
    if (checkOverlappingEntryOnly) {
      checkOverlappingEntry = true;
    }
    const { onstart, onprogress, onend } = options;
    const deflate64 = compressionMethod == COMPRESSION_METHOD_DEFLATE_64;
    let useCompressionStream = getOptionValue(zipEntry, options, OPTION_USE_COMPRESSION_STREAM);
    if (deflate64) {
      useCompressionStream = false;
    }
    const workerOptions = {
      options: {
        codecType: CODEC_INFLATE,
        password,
        rawPassword,
        zipCrypto,
        encryptionStrength: extraFieldAES && extraFieldAES.strength,
        signed: getOptionValue(zipEntry, options, OPTION_CHECK_SIGNATURE) && !passThrough,
        passwordVerification: zipCrypto && (dataDescriptor ? rawLastModDate >>> 8 & MAX_8_BITS : signature >>> 24 & MAX_8_BITS),
        outputSize: passThrough ? compressedSize : uncompressedSize,
        signature,
        compressed: compressionMethod != 0 && !passThrough,
        encrypted: zipEntry.encrypted && !passThrough,
        useWebWorkers: getOptionValue(zipEntry, options, OPTION_USE_WEB_WORKERS),
        useCompressionStream,
        transferStreams: getOptionValue(zipEntry, options, OPTION_TRANSFER_STREAMS),
        deflate64,
        checkPasswordOnly
      },
      config: config2,
      streamOptions: { signal, size, onstart, onprogress, onend }
    };
    if (checkOverlappingEntry) {
      await detectOverlappingEntry({
        reader,
        fileEntry,
        offset,
        diskNumberStart,
        signature,
        compressedSize,
        uncompressedSize,
        dataOffset,
        dataDescriptor: dataDescriptor || localDirectory.bitFlag.dataDescriptor,
        extraFieldZip64: extraFieldZip64 || localDirectory.extraFieldZip64,
        readRanges
      });
    }
    let writable;
    try {
      if (!checkOverlappingEntryOnly) {
        if (checkPasswordOnly) {
          writer = new WritableStream();
        }
        writer = new GenericWriter(writer);
        await initStream(writer, passThrough ? compressedSize : uncompressedSize);
        ({ writable } = writer);
        const { outputSize } = await runWorker2({ readable, writable }, workerOptions);
        writer.size += outputSize;
        if (outputSize != (passThrough ? compressedSize : uncompressedSize)) {
          throw new Error(ERR_INVALID_UNCOMPRESSED_SIZE);
        }
      }
    } catch (error) {
      if (error.outputSize !== UNDEFINED_VALUE) {
        writer.size += error.outputSize;
      }
      if (!checkPasswordOnly || error.message != ERR_ABORT_CHECK_PASSWORD) {
        throw error;
      }
    } finally {
      const preventClose = getOptionValue(zipEntry, options, OPTION_PREVENT_CLOSE);
      if (!preventClose && writable && !writable.locked) {
        await writable.getWriter().close();
      }
    }
    return checkPasswordOnly || checkOverlappingEntryOnly ? UNDEFINED_VALUE : writer.getData ? writer.getData() : writable;
  }
};
function readCommonHeader(directory, dataView, offset) {
  const rawBitFlag = directory.rawBitFlag = getUint16(dataView, offset + 2);
  const encrypted = (rawBitFlag & BITFLAG_ENCRYPTED) == BITFLAG_ENCRYPTED;
  const rawLastModDate = getUint32(dataView, offset + 6);
  Object.assign(directory, {
    encrypted,
    version: getUint16(dataView, offset),
    bitFlag: {
      level: (rawBitFlag & BITFLAG_LEVEL) >> 1,
      dataDescriptor: (rawBitFlag & BITFLAG_DATA_DESCRIPTOR) == BITFLAG_DATA_DESCRIPTOR,
      languageEncodingFlag: (rawBitFlag & BITFLAG_LANG_ENCODING_FLAG) == BITFLAG_LANG_ENCODING_FLAG
    },
    rawLastModDate,
    lastModDate: getDate(rawLastModDate),
    filenameLength: getUint16(dataView, offset + 22),
    extraFieldLength: getUint16(dataView, offset + 24)
  });
}
function readCommonFooter(fileEntry, directory, dataView, offset, localDirectory) {
  const { rawExtraField } = directory;
  const extraField = directory.extraField = /* @__PURE__ */ new Map();
  const rawExtraFieldView = getDataView(new Uint8Array(rawExtraField));
  let offsetExtraField = 0;
  try {
    while (offsetExtraField < rawExtraField.length) {
      const type = getUint16(rawExtraFieldView, offsetExtraField);
      const size = getUint16(rawExtraFieldView, offsetExtraField + 2);
      extraField.set(type, {
        type,
        data: rawExtraField.slice(offsetExtraField + 4, offsetExtraField + 4 + size)
      });
      offsetExtraField += 4 + size;
    }
  } catch {
  }
  const compressionMethod = getUint16(dataView, offset + 4);
  Object.assign(directory, {
    signature: getUint32(dataView, offset + HEADER_OFFSET_SIGNATURE),
    compressedSize: getUint32(dataView, offset + HEADER_OFFSET_COMPRESSED_SIZE),
    uncompressedSize: getUint32(dataView, offset + HEADER_OFFSET_UNCOMPRESSED_SIZE)
  });
  const extraFieldZip64 = extraField.get(EXTRAFIELD_TYPE_ZIP64);
  if (extraFieldZip64) {
    readExtraFieldZip64(extraFieldZip64, directory);
    directory.extraFieldZip64 = extraFieldZip64;
  }
  const extraFieldUnicodePath = extraField.get(EXTRAFIELD_TYPE_UNICODE_PATH);
  if (extraFieldUnicodePath) {
    readExtraFieldUnicode(extraFieldUnicodePath, PROPERTY_NAME_FILENAME, PROPERTY_NAME_RAW_FILENAME, directory, fileEntry);
    directory.extraFieldUnicodePath = extraFieldUnicodePath;
  }
  const extraFieldUnicodeComment = extraField.get(EXTRAFIELD_TYPE_UNICODE_COMMENT);
  if (extraFieldUnicodeComment) {
    readExtraFieldUnicode(extraFieldUnicodeComment, PROPERTY_NAME_COMMENT, PROPERTY_NAME_RAW_COMMENT, directory, fileEntry);
    directory.extraFieldUnicodeComment = extraFieldUnicodeComment;
  }
  const extraFieldAES = extraField.get(EXTRAFIELD_TYPE_AES);
  if (extraFieldAES) {
    readExtraFieldAES(extraFieldAES, directory, compressionMethod);
    directory.extraFieldAES = extraFieldAES;
  } else {
    directory.compressionMethod = compressionMethod;
  }
  const extraFieldNTFS = extraField.get(EXTRAFIELD_TYPE_NTFS);
  if (extraFieldNTFS) {
    readExtraFieldNTFS(extraFieldNTFS, directory);
    directory.extraFieldNTFS = extraFieldNTFS;
  }
  const extraFieldUnix = extraField.get(EXTRAFIELD_TYPE_UNIX);
  if (extraFieldUnix) {
    readExtraFieldUnix(extraFieldUnix, directory, false);
    directory.extraFieldUnix = extraFieldUnix;
  } else {
    const extraFieldInfoZip = extraField.get(EXTRAFIELD_TYPE_INFOZIP);
    if (extraFieldInfoZip) {
      readExtraFieldUnix(extraFieldInfoZip, directory, true);
      directory.extraFieldInfoZip = extraFieldInfoZip;
    }
  }
  const extraFieldExtendedTimestamp = extraField.get(EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
  if (extraFieldExtendedTimestamp) {
    readExtraFieldExtendedTimestamp(extraFieldExtendedTimestamp, directory, localDirectory);
    directory.extraFieldExtendedTimestamp = extraFieldExtendedTimestamp;
  }
  const extraFieldUSDZ = extraField.get(EXTRAFIELD_TYPE_USDZ);
  if (extraFieldUSDZ) {
    directory.extraFieldUSDZ = extraFieldUSDZ;
  }
}
function readExtraFieldZip64(extraFieldZip64, directory) {
  directory.zip64 = true;
  const extraFieldView = getDataView(extraFieldZip64.data);
  const missingProperties = ZIP64_PROPERTIES.filter(([propertyName, max]) => directory[propertyName] == max);
  for (let indexMissingProperty = 0, offset = 0; indexMissingProperty < missingProperties.length; indexMissingProperty++) {
    const [propertyName, max] = missingProperties[indexMissingProperty];
    if (directory[propertyName] == max) {
      const extraction = ZIP64_EXTRACTION[max];
      directory[propertyName] = extraFieldZip64[propertyName] = extraction.getValue(extraFieldView, offset);
      offset += extraction.bytes;
    } else if (extraFieldZip64[propertyName]) {
      throw new Error(ERR_EXTRAFIELD_ZIP64_NOT_FOUND);
    }
  }
}
function readExtraFieldUnicode(extraFieldUnicode, propertyName, rawPropertyName, directory, fileEntry) {
  const extraFieldView = getDataView(extraFieldUnicode.data);
  const crc32 = new Crc32();
  crc32.append(fileEntry[rawPropertyName]);
  const dataViewSignature = getDataView(new Uint8Array(4));
  dataViewSignature.setUint32(0, crc32.get(), true);
  const signature = getUint32(extraFieldView, 1);
  Object.assign(extraFieldUnicode, {
    version: getUint8(extraFieldView, 0),
    [propertyName]: decodeText(extraFieldUnicode.data.subarray(5)),
    valid: !fileEntry.bitFlag.languageEncodingFlag && signature == getUint32(dataViewSignature, 0)
  });
  if (extraFieldUnicode.valid) {
    directory[propertyName] = extraFieldUnicode[propertyName];
    directory[propertyName + PROPERTY_NAME_UTF8_SUFFIX] = true;
  }
}
function readExtraFieldAES(extraFieldAES, directory, compressionMethod) {
  const extraFieldView = getDataView(extraFieldAES.data);
  const strength = getUint8(extraFieldView, 4);
  Object.assign(extraFieldAES, {
    vendorVersion: getUint8(extraFieldView, 0),
    vendorId: getUint8(extraFieldView, 2),
    strength,
    originalCompressionMethod: compressionMethod,
    compressionMethod: getUint16(extraFieldView, 5)
  });
  directory.compressionMethod = extraFieldAES.compressionMethod;
}
function readExtraFieldNTFS(extraFieldNTFS, directory) {
  const extraFieldView = getDataView(extraFieldNTFS.data);
  let offsetExtraField = 4;
  let tag1Data;
  try {
    while (offsetExtraField < extraFieldNTFS.data.length && !tag1Data) {
      const tagValue = getUint16(extraFieldView, offsetExtraField);
      const attributeSize = getUint16(extraFieldView, offsetExtraField + 2);
      if (tagValue == EXTRAFIELD_TYPE_NTFS_TAG1) {
        tag1Data = extraFieldNTFS.data.slice(offsetExtraField + 4, offsetExtraField + 4 + attributeSize);
      }
      offsetExtraField += 4 + attributeSize;
    }
  } catch {
  }
  try {
    if (tag1Data && tag1Data.length == 24) {
      const tag1View = getDataView(tag1Data);
      const rawLastModDate = tag1View.getBigUint64(0, true);
      const rawLastAccessDate = tag1View.getBigUint64(8, true);
      const rawCreationDate = tag1View.getBigUint64(16, true);
      Object.assign(extraFieldNTFS, {
        rawLastModDate,
        rawLastAccessDate,
        rawCreationDate
      });
      const lastModDate = getDateNTFS(rawLastModDate);
      const lastAccessDate = getDateNTFS(rawLastAccessDate);
      const creationDate = getDateNTFS(rawCreationDate);
      const extraFieldData = { lastModDate, lastAccessDate, creationDate };
      Object.assign(extraFieldNTFS, extraFieldData);
      Object.assign(directory, extraFieldData);
    }
  } catch {
  }
}
function readExtraFieldUnix(extraField, directory, isInfoZip) {
  try {
    const view = getDataView(new Uint8Array(extraField.data));
    let offset = 0;
    const version = getUint8(view, offset++);
    const uidSize = getUint8(view, offset++);
    const uidBytes = extraField.data.subarray(offset, offset + uidSize);
    offset += uidSize;
    const uid = unpackUnixId(uidBytes);
    const gidSize = getUint8(view, offset++);
    const gidBytes = extraField.data.subarray(offset, offset + gidSize);
    offset += gidSize;
    const gid = unpackUnixId(gidBytes);
    let unixMode = UNDEFINED_VALUE;
    if (!isInfoZip && offset + 2 <= extraField.data.length) {
      const base = extraField.data;
      const modeView = new DataView(base.buffer, base.byteOffset + offset, 2);
      unixMode = modeView.getUint16(0, true);
    }
    Object.assign(extraField, { version, uid, gid, unixMode });
    if (uid !== UNDEFINED_VALUE) {
      directory.uid = uid;
    }
    if (gid !== UNDEFINED_VALUE) {
      directory.gid = gid;
    }
    if (unixMode !== UNDEFINED_VALUE) {
      directory.unixMode = unixMode;
    }
  } catch {
  }
}
function unpackUnixId(bytes) {
  const buffer = new Uint8Array(4);
  buffer.set(bytes, 0);
  const view = new DataView(buffer.buffer, buffer.byteOffset, 4);
  return view.getUint32(0, true);
}
function readExtraFieldExtendedTimestamp(extraFieldExtendedTimestamp, directory, localDirectory) {
  const extraFieldView = getDataView(extraFieldExtendedTimestamp.data);
  const flags = getUint8(extraFieldView, 0);
  const timeProperties = [];
  const timeRawProperties = [];
  if (localDirectory) {
    if ((flags & 1) == 1) {
      timeProperties.push(PROPERTY_NAME_LAST_MODIFICATION_DATE);
      timeRawProperties.push(PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE);
    }
    if ((flags & 2) == 2) {
      timeProperties.push(PROPERTY_NAME_LAST_ACCESS_DATE);
      timeRawProperties.push(PROPERTY_NAME_RAW_LAST_ACCESS_DATE);
    }
    if ((flags & 4) == 4) {
      timeProperties.push(PROPERTY_NAME_CREATION_DATE);
      timeRawProperties.push(PROPERTY_NAME_RAW_CREATION_DATE);
    }
  } else if (extraFieldExtendedTimestamp.data.length >= 5) {
    timeProperties.push(PROPERTY_NAME_LAST_MODIFICATION_DATE);
    timeRawProperties.push(PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE);
  }
  let offset = 1;
  timeProperties.forEach((propertyName, indexProperty) => {
    if (extraFieldExtendedTimestamp.data.length >= offset + 4) {
      const time = getUint32(extraFieldView, offset);
      directory[propertyName] = extraFieldExtendedTimestamp[propertyName] = new Date(time * 1e3);
      const rawPropertyName = timeRawProperties[indexProperty];
      extraFieldExtendedTimestamp[rawPropertyName] = time;
    }
    offset += 4;
  });
}
async function detectOverlappingEntry({
  reader,
  fileEntry,
  offset,
  diskNumberStart,
  signature,
  compressedSize,
  uncompressedSize,
  dataOffset,
  dataDescriptor,
  extraFieldZip64,
  readRanges
}) {
  let diskOffset = 0;
  if (diskNumberStart) {
    for (let indexReader = 0; indexReader < diskNumberStart; indexReader++) {
      const diskReader = reader.readers[indexReader];
      diskOffset += diskReader.size;
    }
  }
  let dataDescriptorLength = 0;
  if (dataDescriptor) {
    if (extraFieldZip64) {
      dataDescriptorLength = DATA_DESCRIPTOR_RECORD_ZIP_64_LENGTH;
    } else {
      dataDescriptorLength = DATA_DESCRIPTOR_RECORD_LENGTH;
    }
  }
  if (dataDescriptorLength) {
    const dataDescriptorArray = await readUint8Array(reader, dataOffset + compressedSize, dataDescriptorLength + DATA_DESCRIPTOR_RECORD_SIGNATURE_LENGTH, diskNumberStart);
    const dataDescriptorSignature = getUint32(getDataView(dataDescriptorArray), 0) == DATA_DESCRIPTOR_RECORD_SIGNATURE;
    if (dataDescriptorSignature) {
      const readSignature = getUint32(getDataView(dataDescriptorArray), 4);
      let readCompressedSize;
      let readUncompressedSize;
      if (extraFieldZip64) {
        readCompressedSize = getBigUint64(getDataView(dataDescriptorArray), 8);
        readUncompressedSize = getBigUint64(getDataView(dataDescriptorArray), 16);
      } else {
        readCompressedSize = getUint32(getDataView(dataDescriptorArray), 8);
        readUncompressedSize = getUint32(getDataView(dataDescriptorArray), 12);
      }
      const matchSignature = fileEntry.encrypted && !fileEntry.zipCrypto || readSignature == signature;
      if (matchSignature && readCompressedSize == compressedSize && readUncompressedSize == uncompressedSize) {
        dataDescriptorLength += DATA_DESCRIPTOR_RECORD_SIGNATURE_LENGTH;
      }
    }
  }
  const range = {
    start: diskOffset + offset,
    end: diskOffset + dataOffset + compressedSize + dataDescriptorLength,
    fileEntry
  };
  for (const otherRange of readRanges) {
    if (otherRange.fileEntry != fileEntry && range.start >= otherRange.start && range.start < otherRange.end) {
      const error = new Error(ERR_OVERLAPPING_ENTRY);
      error.overlappingEntry = otherRange.fileEntry;
      throw error;
    }
  }
  readRanges.push(range);
}
async function seekSignature(reader, signature, startOffset, minimumBytes, maximumLength) {
  const signatureArray = new Uint8Array(4);
  const signatureView = getDataView(signatureArray);
  setUint32(signatureView, 0, signature);
  const maximumBytes = minimumBytes + maximumLength;
  return await seek(minimumBytes) || await seek(Math.min(maximumBytes, startOffset));
  async function seek(length) {
    const offset = startOffset - length;
    const bytes = await readUint8Array(reader, offset, length);
    for (let indexByte = bytes.length - minimumBytes; indexByte >= 0; indexByte--) {
      if (bytes[indexByte] == signatureArray[0] && bytes[indexByte + 1] == signatureArray[1] && bytes[indexByte + 2] == signatureArray[2] && bytes[indexByte + 3] == signatureArray[3]) {
        return {
          offset: offset + indexByte,
          buffer: bytes.slice(indexByte, indexByte + minimumBytes).buffer
        };
      }
    }
  }
}
function getOptionValue(zipReader, options, name) {
  return options[name] === UNDEFINED_VALUE ? zipReader.options[name] : options[name];
}
function getDate(timeRaw) {
  const date = (timeRaw & 4294901760) >> 16, time = timeRaw & MAX_16_BITS;
  try {
    return new Date(1980 + ((date & 65024) >> 9), ((date & 480) >> 5) - 1, date & 31, (time & 63488) >> 11, (time & 2016) >> 5, (time & 31) * 2, 0);
  } catch {
  }
}
function getDateNTFS(timeRaw) {
  return new Date(Number(timeRaw / BigInt(1e4) - BigInt(116444736e5)));
}
function getUint8(view, offset) {
  return view.getUint8(offset);
}
function getUint16(view, offset) {
  return view.getUint16(offset, true);
}
function getUint32(view, offset) {
  return view.getUint32(offset, true);
}
function getBigUint64(view, offset) {
  return Number(view.getBigUint64(offset, true));
}
function setUint32(view, offset, value) {
  view.setUint32(offset, value, true);
}
function getDataView(array) {
  return new DataView(array.buffer);
}

// node_modules/@zip.js/zip.js/lib/core/zip-writer.js
var ERR_DUPLICATED_NAME = "File already exists";
var ERR_INVALID_COMMENT = "Zip file comment exceeds 64KB";
var ERR_INVALID_ENTRY_COMMENT = "File entry comment exceeds 64KB";
var ERR_INVALID_ENTRY_NAME = "File entry name exceeds 64KB";
var ERR_INVALID_VERSION = "Version exceeds 65535";
var ERR_INVALID_ENCRYPTION_STRENGTH = "The strength must equal 1, 2, or 3";
var ERR_INVALID_EXTRAFIELD_TYPE = "Extra field type exceeds 65535";
var ERR_INVALID_EXTRAFIELD_DATA = "Extra field data exceeds 64KB";
var ERR_UNSUPPORTED_FORMAT = "Zip64 is not supported (make sure 'keepOrder' is set to 'true')";
var ERR_UNDEFINED_UNCOMPRESSED_SIZE = "Undefined uncompressed size";
var ERR_ZIP_NOT_EMPTY = "Zip file not empty";
var ERR_INVALID_UID = "Invalid uid (must be integer 0..2^32-1)";
var ERR_INVALID_GID = "Invalid gid (must be integer 0..2^32-1)";
var ERR_INVALID_UNIX_MODE = "Invalid UNIX mode (must be integer 0..65535)";
var ERR_INVALID_UNIX_EXTRA_FIELD_TYPE = "Invalid unixExtraFieldType (must be 'infozip' or 'unix')";
var ERR_INVALID_MSDOS_ATTRIBUTES = "Invalid msdosAttributesRaw (must be integer 0..255)";
var ERR_INVALID_MSDOS_DATA = "Invalid msdosAttributes (must be an object with boolean flags)";
var EXTRAFIELD_DATA_AES = new Uint8Array([7, 0, 2, 0, 65, 69, 3, 0, 0]);
var INFOZIP_EXTRA_FIELD_TYPE = "infozip";
var UNIX_EXTRA_FIELD_TYPE = "unix";
var workers = 0;
var pendingEntries = [];
var ZipWriter = class {
  constructor(writer, options = {}) {
    writer = new GenericWriter(writer);
    const addSplitZipSignature = writer.availableSize !== UNDEFINED_VALUE && writer.availableSize > 0 && writer.availableSize !== Infinity && writer.maxSize !== UNDEFINED_VALUE && writer.maxSize > 0 && writer.maxSize !== Infinity;
    Object.assign(this, {
      writer,
      addSplitZipSignature,
      options,
      config: getConfiguration(),
      files: /* @__PURE__ */ new Map(),
      filenames: /* @__PURE__ */ new Set(),
      offset: options[OPTION_OFFSET] === UNDEFINED_VALUE ? writer.size || writer.writable.size || 0 : options[OPTION_OFFSET],
      pendingEntriesSize: 0,
      pendingAddFileCalls: /* @__PURE__ */ new Set(),
      bufferedWrites: 0
    });
  }
  async prependZip(reader) {
    if (this.filenames.size) {
      throw new Error(ERR_ZIP_NOT_EMPTY);
    }
    reader = new GenericReader(reader);
    const zipReader = new ZipReader(reader.readable);
    const entries = await zipReader.getEntries();
    await zipReader.close();
    await reader.readable.pipeTo(this.writer.writable, { preventClose: true, preventAbort: true });
    this.writer.size = this.offset = reader.size;
    this.filenames = new Set(entries.map((entry) => entry.filename));
    this.files = new Map(entries.map((entry) => {
      const {
        version,
        compressionMethod,
        lastModDate,
        lastAccessDate,
        creationDate,
        rawFilename,
        bitFlag,
        encrypted,
        uncompressedSize,
        compressedSize,
        diskOffset,
        diskNumber,
        zip64
      } = entry;
      let {
        rawExtraFieldZip64,
        rawExtraFieldAES,
        rawExtraFieldExtendedTimestamp,
        rawExtraFieldNTFS,
        rawExtraFieldUnix,
        rawExtraField
      } = entry;
      const { level, languageEncodingFlag, dataDescriptor } = bitFlag;
      rawExtraFieldZip64 = rawExtraFieldZip64 || new Uint8Array();
      rawExtraFieldAES = rawExtraFieldAES || new Uint8Array();
      rawExtraFieldExtendedTimestamp = rawExtraFieldExtendedTimestamp || new Uint8Array();
      rawExtraFieldNTFS = rawExtraFieldNTFS || new Uint8Array();
      rawExtraFieldUnix = entry.rawExtraFieldUnix || new Uint8Array();
      rawExtraField = rawExtraField || new Uint8Array();
      const extraFieldLength = getLength(rawExtraFieldZip64, rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraFieldUnix, rawExtraField);
      const zip64UncompressedSize = zip64 && uncompressedSize > MAX_32_BITS;
      const zip64CompressedSize = zip64 && compressedSize > MAX_32_BITS;
      const {
        headerArray,
        headerView
      } = getHeaderArrayData({
        version,
        bitFlag: getBitFlag(level, languageEncodingFlag, dataDescriptor, encrypted, compressionMethod),
        compressionMethod,
        uncompressedSize,
        compressedSize,
        lastModDate,
        rawFilename,
        zip64CompressedSize,
        zip64UncompressedSize,
        extraFieldLength
      });
      Object.assign(entry, {
        zip64UncompressedSize,
        zip64CompressedSize,
        zip64Offset: zip64 && this.offset - diskOffset > MAX_32_BITS,
        zip64DiskNumberStart: zip64 && diskNumber > MAX_16_BITS,
        rawExtraFieldZip64,
        rawExtraFieldAES,
        rawExtraFieldExtendedTimestamp,
        rawExtraFieldNTFS,
        rawExtraFieldUnix,
        rawExtraField,
        extendedTimestamp: rawExtraFieldExtendedTimestamp.length > 0 || rawExtraFieldNTFS.length > 0,
        extraFieldExtendedTimestampFlag: 1 + (lastAccessDate ? 2 : 0) + (creationDate ? 4 : 0),
        headerArray,
        headerView
      });
      return [entry.filename, entry];
    }));
  }
  async add(name = "", reader, options = {}) {
    const zipWriter = this;
    const {
      pendingAddFileCalls,
      config: config2
    } = zipWriter;
    if (workers < config2.maxWorkers) {
      workers++;
    } else {
      await new Promise((resolve) => pendingEntries.push(resolve));
    }
    let promiseAddFile;
    try {
      name = name.trim();
      if (zipWriter.filenames.has(name)) {
        throw new Error(ERR_DUPLICATED_NAME);
      }
      zipWriter.filenames.add(name);
      promiseAddFile = addFile(zipWriter, name, reader, options);
      pendingAddFileCalls.add(promiseAddFile);
      return await promiseAddFile;
    } catch (error) {
      zipWriter.filenames.delete(name);
      throw error;
    } finally {
      pendingAddFileCalls.delete(promiseAddFile);
      const pendingEntry = pendingEntries.shift();
      if (pendingEntry) {
        pendingEntry();
      } else {
        workers--;
      }
    }
  }
  remove(entry) {
    const { filenames, files } = this;
    if (typeof entry == "string") {
      entry = files.get(entry);
    }
    if (entry && entry.filename !== UNDEFINED_VALUE) {
      const { filename } = entry;
      if (filenames.has(filename) && files.has(filename)) {
        filenames.delete(filename);
        files.delete(filename);
        return true;
      }
    }
    return false;
  }
  async close(comment = new Uint8Array(), options = {}) {
    const zipWriter = this;
    const { pendingAddFileCalls, writer } = this;
    const { writable } = writer;
    while (pendingAddFileCalls.size) {
      await Promise.allSettled(Array.from(pendingAddFileCalls));
    }
    await closeFile(zipWriter, comment, options);
    const preventClose = getOptionValue2(zipWriter, options, OPTION_PREVENT_CLOSE);
    if (!preventClose) {
      await writable.getWriter().close();
    }
    return writer.getData ? writer.getData() : writable;
  }
};
var ZipWriterStream = class {
  constructor(options = {}) {
    const { readable, writable } = new TransformStream();
    this.readable = readable;
    this.zipWriter = new ZipWriter(writable, options);
  }
  transform(path) {
    const { readable, writable } = new TransformStream({
      flush: () => {
        this.zipWriter.close();
      }
    });
    this.zipWriter.add(path, readable);
    return { readable: this.readable, writable };
  }
  writable(path) {
    const { readable, writable } = new TransformStream();
    this.zipWriter.add(path, readable);
    return writable;
  }
  close(comment = UNDEFINED_VALUE, options = {}) {
    return this.zipWriter.close(comment, options);
  }
};
async function addFile(zipWriter, name, reader, options) {
  name = name.trim();
  let msDosCompatible = getOptionValue2(zipWriter, options, PROPERTY_NAME_MS_DOS_COMPATIBLE);
  let versionMadeBy = getOptionValue2(zipWriter, options, PROPERTY_NAME_VERSION_MADE_BY, msDosCompatible ? 20 : 768);
  const executable = getOptionValue2(zipWriter, options, PROPERTY_NAME_EXECUTABLE);
  const uid = getOptionValue2(zipWriter, options, PROPERTY_NAME_UID);
  const gid = getOptionValue2(zipWriter, options, PROPERTY_NAME_GID);
  let unixMode = getOptionValue2(zipWriter, options, PROPERTY_NAME_UNIX_MODE);
  const unixExtraFieldType = getOptionValue2(zipWriter, options, OPTION_UNIX_EXTRA_FIELD_TYPE);
  let setuid = getOptionValue2(zipWriter, options, PROPERTY_NAME_SETUID);
  let setgid = getOptionValue2(zipWriter, options, PROPERTY_NAME_SETGID);
  let sticky = getOptionValue2(zipWriter, options, PROPERTY_NAME_STICKY);
  if (uid !== UNDEFINED_VALUE && (uid < 0 || uid > MAX_32_BITS)) {
    throw new Error(ERR_INVALID_UID);
  }
  if (gid !== UNDEFINED_VALUE && (gid < 0 || gid > MAX_32_BITS)) {
    throw new Error(ERR_INVALID_GID);
  }
  if (unixMode !== UNDEFINED_VALUE && (unixMode < 0 || unixMode > MAX_16_BITS)) {
    throw new Error(ERR_INVALID_UNIX_MODE);
  }
  if (unixExtraFieldType !== UNDEFINED_VALUE && unixExtraFieldType !== INFOZIP_EXTRA_FIELD_TYPE && unixExtraFieldType !== UNIX_EXTRA_FIELD_TYPE) {
    throw new Error(ERR_INVALID_UNIX_EXTRA_FIELD_TYPE);
  }
  let msdosAttributesRaw = getOptionValue2(zipWriter, options, PROPERTY_NAME_MSDOS_ATTRIBUTES_RAW);
  let msdosAttributes = getOptionValue2(zipWriter, options, PROPERTY_NAME_MSDOS_ATTRIBUTES);
  const hasUnixMetadata = uid !== UNDEFINED_VALUE || gid !== UNDEFINED_VALUE || unixMode !== UNDEFINED_VALUE || unixExtraFieldType;
  const hasMsDosProvided = msdosAttributesRaw !== UNDEFINED_VALUE || msdosAttributes !== UNDEFINED_VALUE;
  if (hasUnixMetadata) {
    msDosCompatible = false;
    versionMadeBy = versionMadeBy & MAX_16_BITS | 3 << 8;
  } else if (hasMsDosProvided) {
    msDosCompatible = true;
    versionMadeBy = versionMadeBy & MAX_8_BITS;
  }
  if (msdosAttributesRaw !== UNDEFINED_VALUE && (msdosAttributesRaw < 0 || msdosAttributesRaw > MAX_8_BITS)) {
    throw new Error(ERR_INVALID_MSDOS_ATTRIBUTES);
  }
  if (msdosAttributes && typeof msdosAttributes !== OBJECT_TYPE) {
    throw new Error(ERR_INVALID_MSDOS_DATA);
  }
  if (versionMadeBy > MAX_16_BITS) {
    throw new Error(ERR_INVALID_VERSION);
  }
  let externalFileAttributes = getOptionValue2(zipWriter, options, PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES, 0);
  if (!options[PROPERTY_NAME_DIRECTORY] && name.endsWith(DIRECTORY_SIGNATURE)) {
    options[PROPERTY_NAME_DIRECTORY] = true;
  }
  const directory = getOptionValue2(zipWriter, options, PROPERTY_NAME_DIRECTORY);
  if (directory) {
    if (!name.endsWith(DIRECTORY_SIGNATURE)) {
      name += DIRECTORY_SIGNATURE;
    }
    if (externalFileAttributes === 0) {
      externalFileAttributes = FILE_ATTR_MSDOS_DIR_MASK;
      if (!msDosCompatible) {
        externalFileAttributes |= (FILE_ATTR_UNIX_TYPE_DIR | FILE_ATTR_UNIX_EXECUTABLE_MASK | FILE_ATTR_UNIX_DEFAULT_MASK) << 16;
      }
    }
  } else if (!msDosCompatible && externalFileAttributes === 0) {
    if (executable) {
      externalFileAttributes = (FILE_ATTR_UNIX_EXECUTABLE_MASK | FILE_ATTR_UNIX_DEFAULT_MASK) << 16;
    } else {
      externalFileAttributes = FILE_ATTR_UNIX_DEFAULT_MASK << 16;
    }
  }
  let unixExternalUpper;
  if (!msDosCompatible) {
    unixExternalUpper = externalFileAttributes >> 16 & MAX_16_BITS;
    unixMode = unixMode === UNDEFINED_VALUE ? unixExternalUpper : unixMode & MAX_16_BITS;
    if (setuid) {
      unixMode |= FILE_ATTR_UNIX_SETUID_MASK;
    } else {
      setuid = Boolean(unixMode & FILE_ATTR_UNIX_SETUID_MASK);
    }
    if (setgid) {
      unixMode |= FILE_ATTR_UNIX_SETGID_MASK;
    } else {
      setgid = Boolean(unixMode & FILE_ATTR_UNIX_SETGID_MASK);
    }
    if (sticky) {
      unixMode |= FILE_ATTR_UNIX_STICKY_MASK;
    } else {
      sticky = Boolean(unixMode & FILE_ATTR_UNIX_STICKY_MASK);
    }
    if (directory) {
      unixMode |= FILE_ATTR_UNIX_TYPE_DIR;
    }
    externalFileAttributes = (unixMode & MAX_16_BITS) << 16 | externalFileAttributes & MAX_8_BITS;
  }
  ({ msdosAttributesRaw, msdosAttributes } = normalizeMsdosAttributes(msdosAttributesRaw, msdosAttributes));
  if (hasMsDosProvided) {
    externalFileAttributes = externalFileAttributes & MAX_32_BITS | msdosAttributesRaw & MAX_8_BITS;
  }
  const encode = getOptionValue2(zipWriter, options, OPTION_ENCODE_TEXT, encodeText);
  let rawFilename = encode(name);
  if (rawFilename === UNDEFINED_VALUE) {
    rawFilename = encodeText(name);
  }
  if (getLength(rawFilename) > MAX_16_BITS) {
    throw new Error(ERR_INVALID_ENTRY_NAME);
  }
  const comment = options[PROPERTY_NAME_COMMENT] || "";
  let rawComment = encode(comment);
  if (rawComment === UNDEFINED_VALUE) {
    rawComment = encodeText(comment);
  }
  if (getLength(rawComment) > MAX_16_BITS) {
    throw new Error(ERR_INVALID_ENTRY_COMMENT);
  }
  const version = getOptionValue2(zipWriter, options, PROPERTY_NAME_VERSION, VERSION_DEFLATE);
  if (version > MAX_16_BITS) {
    throw new Error(ERR_INVALID_VERSION);
  }
  const lastModDate = getOptionValue2(zipWriter, options, PROPERTY_NAME_LAST_MODIFICATION_DATE, /* @__PURE__ */ new Date());
  const lastAccessDate = getOptionValue2(zipWriter, options, PROPERTY_NAME_LAST_ACCESS_DATE);
  const creationDate = getOptionValue2(zipWriter, options, PROPERTY_NAME_CREATION_DATE);
  const internalFileAttributes = getOptionValue2(zipWriter, options, PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES, 0);
  const passThrough = getOptionValue2(zipWriter, options, OPTION_PASS_THROUGH);
  let password, rawPassword;
  if (!passThrough) {
    password = getOptionValue2(zipWriter, options, OPTION_PASSWORD);
    rawPassword = getOptionValue2(zipWriter, options, OPTION_RAW_PASSWORD);
  }
  const encryptionStrength = getOptionValue2(zipWriter, options, OPTION_ENCRYPTION_STRENGTH, 3);
  const zipCrypto = getOptionValue2(zipWriter, options, PROPERTY_NAME_ZIPCRYPTO);
  const extendedTimestamp = getOptionValue2(zipWriter, options, OPTION_EXTENDED_TIMESTAMP, true);
  const keepOrder = getOptionValue2(zipWriter, options, OPTION_KEEP_ORDER, true);
  const useWebWorkers = getOptionValue2(zipWriter, options, OPTION_USE_WEB_WORKERS);
  const bufferedWrite = getOptionValue2(zipWriter, options, OPTION_BUFFERED_WRITE);
  const dataDescriptorSignature = getOptionValue2(zipWriter, options, OPTION_DATA_DESCRIPTOR_SIGNATURE, false);
  const signal = getOptionValue2(zipWriter, options, OPTION_SIGNAL);
  const useUnicodeFileNames = getOptionValue2(zipWriter, options, OPTION_USE_UNICODE_FILE_NAMES, true);
  const compressionMethod = getOptionValue2(zipWriter, options, PROPERTY_NAME_COMPRESSION_METHOD);
  let level = getOptionValue2(zipWriter, options, OPTION_LEVEL);
  let useCompressionStream = getOptionValue2(zipWriter, options, OPTION_USE_COMPRESSION_STREAM);
  let dataDescriptor = getOptionValue2(zipWriter, options, OPTION_DATA_DESCRIPTOR);
  if (bufferedWrite && dataDescriptor === UNDEFINED_VALUE) {
    dataDescriptor = false;
  }
  if (dataDescriptor === UNDEFINED_VALUE || zipCrypto) {
    dataDescriptor = true;
  }
  if (level !== UNDEFINED_VALUE && level != 6) {
    useCompressionStream = false;
  }
  if (!useCompressionStream && (zipWriter.config.CompressionStream === UNDEFINED_VALUE && zipWriter.config.CompressionStreamZlib === UNDEFINED_VALUE)) {
    level = 0;
  }
  let zip64 = getOptionValue2(zipWriter, options, PROPERTY_NAME_ZIP64);
  if (!zipCrypto && (password !== UNDEFINED_VALUE || rawPassword !== UNDEFINED_VALUE) && !(encryptionStrength >= 1 && encryptionStrength <= 3)) {
    throw new Error(ERR_INVALID_ENCRYPTION_STRENGTH);
  }
  let rawExtraField = new Uint8Array();
  const extraField = options[PROPERTY_NAME_EXTRA_FIELD];
  if (extraField) {
    let extraFieldSize = 0;
    let offset = 0;
    extraField.forEach((data) => extraFieldSize += 4 + getLength(data));
    rawExtraField = new Uint8Array(extraFieldSize);
    extraField.forEach((data, type) => {
      if (type > MAX_16_BITS) {
        throw new Error(ERR_INVALID_EXTRAFIELD_TYPE);
      }
      if (getLength(data) > MAX_16_BITS) {
        throw new Error(ERR_INVALID_EXTRAFIELD_DATA);
      }
      arraySet(rawExtraField, new Uint16Array([type]), offset);
      arraySet(rawExtraField, new Uint16Array([getLength(data)]), offset + 2);
      arraySet(rawExtraField, data, offset + 4);
      offset += 4 + getLength(data);
    });
  }
  let maximumCompressedSize = 0;
  let maximumEntrySize = 0;
  let uncompressedSize = 0;
  if (passThrough) {
    uncompressedSize = options[PROPERTY_NAME_UNCOMPRESSED_SIZE];
    if (uncompressedSize === UNDEFINED_VALUE) {
      throw new Error(ERR_UNDEFINED_UNCOMPRESSED_SIZE);
    }
  }
  const zip64Enabled = zip64 === true;
  if (reader) {
    reader = new GenericReader(reader);
    await initStream(reader);
    if (!passThrough) {
      if (reader.size === UNDEFINED_VALUE) {
        dataDescriptor = true;
        if (zip64 || zip64 === UNDEFINED_VALUE) {
          zip64 = true;
          uncompressedSize = maximumCompressedSize = MAX_32_BITS + 1;
        }
      } else {
        options.uncompressedSize = uncompressedSize = reader.size;
        maximumCompressedSize = getMaximumCompressedSize(uncompressedSize);
      }
    } else {
      options.uncompressedSize = uncompressedSize;
      maximumCompressedSize = getMaximumCompressedSize(uncompressedSize);
    }
  }
  const { diskOffset, diskNumber, maxSize } = zipWriter.writer;
  const zip64UncompressedSize = zip64Enabled || uncompressedSize > MAX_32_BITS;
  const zip64CompressedSize = zip64Enabled || maximumCompressedSize > MAX_32_BITS;
  const zip64Offset = zip64Enabled || zipWriter.offset + zipWriter.pendingEntriesSize - diskOffset > MAX_32_BITS;
  const supportZip64SplitFile = getOptionValue2(zipWriter, options, OPTION_SUPPORT_ZIP64_SPLIT_FILE, true);
  const zip64DiskNumberStart = supportZip64SplitFile && zip64Enabled || diskNumber + Math.ceil(zipWriter.pendingEntriesSize / maxSize) > MAX_16_BITS;
  if (zip64Offset || zip64UncompressedSize || zip64CompressedSize || zip64DiskNumberStart) {
    if (zip64 === false || !keepOrder) {
      throw new Error(ERR_UNSUPPORTED_FORMAT);
    } else {
      zip64 = true;
    }
  }
  zip64 = zip64 || false;
  const encrypted = getOptionValue2(zipWriter, options, PROPERTY_NAME_ENCRYPTED);
  options = Object.assign({}, options, {
    rawFilename,
    rawComment,
    version,
    versionMadeBy,
    lastModDate,
    lastAccessDate,
    creationDate,
    rawExtraField,
    zip64,
    zip64UncompressedSize,
    zip64CompressedSize,
    zip64Offset,
    zip64DiskNumberStart,
    password,
    rawPassword,
    level,
    useWebWorkers,
    encryptionStrength,
    extendedTimestamp,
    zipCrypto,
    bufferedWrite,
    keepOrder,
    useUnicodeFileNames,
    dataDescriptor,
    dataDescriptorSignature,
    signal,
    msDosCompatible,
    internalFileAttribute: internalFileAttributes,
    internalFileAttributes,
    externalFileAttribute: externalFileAttributes,
    externalFileAttributes,
    useCompressionStream,
    passThrough,
    encrypted: Boolean(password && getLength(password) || rawPassword && getLength(rawPassword)) || passThrough && encrypted,
    signature: options[PROPERTY_NAME_SIGNATURE],
    compressionMethod,
    uncompressedSize,
    offset: zipWriter.offset - diskOffset,
    diskNumberStart: diskNumber,
    uid,
    gid,
    setuid,
    setgid,
    sticky,
    unixMode,
    msdosAttributesRaw,
    msdosAttributes,
    unixExternalUpper
  });
  const headerInfo = getHeaderInfo(options);
  const dataDescriptorInfo = getDataDescriptorInfo(options);
  const metadataSize = getLength(headerInfo.localHeaderArray, dataDescriptorInfo.dataDescriptorArray);
  maximumEntrySize = metadataSize + maximumCompressedSize;
  if (zipWriter.options[OPTION_USDZ]) {
    maximumEntrySize += maximumEntrySize + 64;
  }
  zipWriter.pendingEntriesSize += maximumEntrySize;
  let fileEntry;
  try {
    fileEntry = await getFileEntry(zipWriter, name, reader, { headerInfo, dataDescriptorInfo, metadataSize }, options);
  } finally {
    zipWriter.pendingEntriesSize -= maximumEntrySize;
  }
  Object.assign(fileEntry, { name, comment, extraField });
  return new Entry(fileEntry);
}
async function getFileEntry(zipWriter, name, reader, entryInfo, options) {
  const {
    files,
    writer
  } = zipWriter;
  const {
    keepOrder,
    dataDescriptor,
    signal
  } = options;
  const {
    headerInfo
  } = entryInfo;
  const usdz = zipWriter.options[OPTION_USDZ];
  const previousFileEntry = Array.from(files.values()).pop();
  let fileEntry = {};
  let bufferedWrite;
  let releaseLockWriter;
  let releaseLockCurrentFileEntry;
  let writingBufferedEntryData;
  let writingEntryData;
  let fileWriter;
  let blobPromise;
  files.set(name, fileEntry);
  try {
    let lockPreviousFileEntry;
    if (keepOrder) {
      lockPreviousFileEntry = previousFileEntry && previousFileEntry.lock;
      requestLockCurrentFileEntry();
    }
    if ((options.bufferedWrite || zipWriter.writerLocked || zipWriter.bufferedWrites && keepOrder || !dataDescriptor) && !usdz) {
      fileWriter = new TransformStream();
      fileWriter.size = 0;
      bufferedWrite = true;
      zipWriter.bufferedWrites++;
      await initStream(writer);
    } else {
      fileWriter = writer;
      await requestLockWriter();
    }
    await initStream(fileWriter);
    const { writable, diskOffset } = writer;
    if (zipWriter.addSplitZipSignature) {
      delete zipWriter.addSplitZipSignature;
      const signatureArray = new Uint8Array(4);
      const signatureArrayView = getDataView2(signatureArray);
      setUint322(signatureArrayView, 0, SPLIT_ZIP_FILE_SIGNATURE);
      await writeData(writer, signatureArray);
      zipWriter.offset += 4;
    }
    if (usdz) {
      appendExtraFieldUSDZ(entryInfo, zipWriter.offset - diskOffset);
    }
    const {
      localHeaderView,
      localHeaderArray
    } = headerInfo;
    if (!bufferedWrite) {
      await lockPreviousFileEntry;
      await skipDiskIfNeeded(writable);
    }
    const { diskNumber } = writer;
    writingEntryData = true;
    fileEntry.diskNumberStart = diskNumber;
    if (bufferedWrite) {
      blobPromise = new Response(fileWriter.readable).blob();
    } else {
      await writeData(fileWriter, localHeaderArray);
    }
    fileEntry = await createFileEntry(reader, fileWriter, fileEntry, entryInfo, zipWriter.config, options);
    const { zip64 } = fileEntry;
    writingEntryData = false;
    files.set(name, fileEntry);
    fileEntry.filename = name;
    if (bufferedWrite) {
      const [blob] = await Promise.all([blobPromise, fileWriter.writable.getWriter().close(), lockPreviousFileEntry]);
      await requestLockWriter();
      writingBufferedEntryData = true;
      fileEntry.diskNumberStart = writer.diskNumber;
      fileEntry.offset = zipWriter.offset - writer.diskOffset;
      if (zip64) {
        updateZip64ExtraField(fileEntry);
      }
      updateLocalHeader(fileEntry, localHeaderView, options);
      await skipDiskIfNeeded(writable);
      await writeData(writer, localHeaderArray);
      await blob.stream().pipeTo(writable, { preventClose: true, preventAbort: true, signal });
      writer.size += fileWriter.size;
      writingBufferedEntryData = false;
    } else {
      fileEntry.offset = zipWriter.offset - diskOffset;
      if (zip64) {
        updateZip64ExtraField(fileEntry);
      }
    }
    if (fileEntry.offset > MAX_32_BITS && !zip64) {
      throw new Error(ERR_UNSUPPORTED_FORMAT);
    }
    zipWriter.offset += fileEntry.size;
    return fileEntry;
  } catch (error) {
    if (bufferedWrite && writingBufferedEntryData || !bufferedWrite && writingEntryData) {
      zipWriter.hasCorruptedEntries = true;
      if (error) {
        try {
          error.corruptedEntry = true;
        } catch {
        }
      }
      if (bufferedWrite) {
        zipWriter.offset += fileWriter.size;
      } else {
        zipWriter.offset = fileWriter.size;
      }
    }
    files.delete(name);
    throw error;
  } finally {
    if (bufferedWrite) {
      zipWriter.bufferedWrites--;
    }
    if (releaseLockCurrentFileEntry) {
      releaseLockCurrentFileEntry();
    }
    if (releaseLockWriter) {
      releaseLockWriter();
    }
  }
  function requestLockCurrentFileEntry() {
    fileEntry.lock = new Promise((resolve) => releaseLockCurrentFileEntry = resolve);
  }
  async function requestLockWriter() {
    zipWriter.writerLocked = true;
    const { lockWriter } = zipWriter;
    zipWriter.lockWriter = new Promise((resolve) => releaseLockWriter = () => {
      zipWriter.writerLocked = false;
      resolve();
    });
    await lockWriter;
  }
  async function skipDiskIfNeeded(writable) {
    if (getLength(headerInfo.localHeaderArray) > writer.availableSize) {
      writer.availableSize = 0;
      await writeData(writable, new Uint8Array());
    }
  }
}
async function createFileEntry(reader, writer, { diskNumberStart, lock }, entryInfo, config2, options) {
  const {
    headerInfo,
    dataDescriptorInfo,
    metadataSize
  } = entryInfo;
  const {
    headerArray,
    headerView,
    lastModDate,
    rawLastModDate,
    encrypted,
    compressed,
    version,
    compressionMethod,
    rawExtraFieldZip64,
    localExtraFieldZip64Length,
    rawExtraFieldExtendedTimestamp,
    extraFieldExtendedTimestampFlag,
    rawExtraFieldNTFS,
    rawExtraFieldUnix,
    rawExtraFieldAES
  } = headerInfo;
  const { dataDescriptorArray } = dataDescriptorInfo;
  const {
    rawFilename,
    lastAccessDate,
    creationDate,
    password,
    rawPassword,
    level,
    zip64,
    zip64UncompressedSize,
    zip64CompressedSize,
    zip64Offset,
    zip64DiskNumberStart,
    zipCrypto,
    dataDescriptor,
    directory,
    executable,
    versionMadeBy,
    rawComment,
    rawExtraField,
    useWebWorkers,
    onstart,
    onprogress,
    onend,
    signal,
    encryptionStrength,
    extendedTimestamp,
    msDosCompatible,
    internalFileAttributes,
    externalFileAttributes,
    uid,
    gid,
    unixMode,
    setuid,
    setgid,
    sticky,
    unixExternalUpper,
    msdosAttributesRaw,
    msdosAttributes,
    useCompressionStream,
    passThrough
  } = options;
  const fileEntry = {
    lock,
    versionMadeBy,
    zip64,
    directory: Boolean(directory),
    executable: Boolean(executable),
    filenameUTF8: true,
    rawFilename,
    commentUTF8: true,
    rawComment,
    rawExtraFieldZip64,
    localExtraFieldZip64Length,
    rawExtraFieldExtendedTimestamp,
    rawExtraFieldNTFS,
    rawExtraFieldUnix,
    rawExtraFieldAES,
    rawExtraField,
    extendedTimestamp,
    msDosCompatible,
    internalFileAttributes,
    externalFileAttributes,
    diskNumberStart,
    uid,
    gid,
    unixMode,
    setuid,
    setgid,
    sticky,
    unixExternalUpper,
    msdosAttributesRaw,
    msdosAttributes
  };
  let {
    signature,
    uncompressedSize
  } = options;
  let compressedSize = 0;
  if (!passThrough) {
    uncompressedSize = 0;
  }
  const { writable } = writer;
  if (reader) {
    reader.chunkSize = getChunkSize(config2);
    const readable = reader.readable;
    const size = reader.size;
    const workerOptions = {
      options: {
        codecType: CODEC_DEFLATE,
        level,
        rawPassword,
        password,
        encryptionStrength,
        zipCrypto: encrypted && zipCrypto,
        passwordVerification: encrypted && zipCrypto && rawLastModDate >> 8 & MAX_8_BITS,
        signed: !passThrough,
        compressed: compressed && !passThrough,
        encrypted: encrypted && !passThrough,
        useWebWorkers,
        useCompressionStream,
        transferStreams: false
      },
      config: config2,
      streamOptions: { signal, size, onstart, onprogress, onend }
    };
    try {
      const result = await runWorker2({ readable, writable }, workerOptions);
      compressedSize = result.outputSize;
      writer.size += compressedSize;
      if (!passThrough) {
        uncompressedSize = result.inputSize;
        signature = result.signature;
      }
    } catch (error) {
      if (error.outputSize !== UNDEFINED_VALUE) {
        writer.size += error.outputSize;
      }
      throw error;
    }
  }
  setEntryInfo({
    signature,
    compressedSize,
    uncompressedSize,
    headerInfo,
    dataDescriptorInfo
  }, options);
  if (dataDescriptor) {
    await writeData(writer, dataDescriptorArray);
  }
  Object.assign(fileEntry, {
    uncompressedSize,
    compressedSize,
    lastModDate,
    rawLastModDate,
    creationDate,
    lastAccessDate,
    encrypted,
    zipCrypto,
    size: metadataSize + compressedSize,
    compressionMethod,
    version,
    headerArray,
    headerView,
    signature,
    extraFieldExtendedTimestampFlag,
    zip64UncompressedSize,
    zip64CompressedSize,
    zip64Offset,
    zip64DiskNumberStart
  });
  return fileEntry;
}
function getHeaderInfo(options) {
  const {
    rawFilename,
    lastModDate,
    lastAccessDate,
    creationDate,
    level,
    zip64,
    zipCrypto,
    useUnicodeFileNames,
    dataDescriptor,
    directory,
    rawExtraField,
    encryptionStrength,
    extendedTimestamp,
    passThrough,
    encrypted,
    zip64UncompressedSize,
    zip64CompressedSize,
    zip64Offset,
    zip64DiskNumberStart,
    uncompressedSize,
    offset,
    diskNumberStart
  } = options;
  let { version, compressionMethod } = options;
  const compressed = !directory && (level > 0 || level === UNDEFINED_VALUE && compressionMethod !== 0);
  let rawExtraFieldZip64;
  const uncompressedFile = passThrough || !compressed;
  const zip64ExtraFieldComplete = zip64 && (options.bufferedWrite || (!zip64UncompressedSize && !zip64CompressedSize || uncompressedFile));
  if (zip64) {
    let rawExtraFieldZip64Length = 4;
    if (zip64UncompressedSize) {
      rawExtraFieldZip64Length += 8;
    }
    if (zip64CompressedSize) {
      rawExtraFieldZip64Length += 8;
    }
    if (zip64Offset) {
      rawExtraFieldZip64Length += 8;
    }
    if (zip64DiskNumberStart) {
      rawExtraFieldZip64Length += 4;
    }
    rawExtraFieldZip64 = new Uint8Array(rawExtraFieldZip64Length);
    const rawExtraFieldZip64View = getDataView2(rawExtraFieldZip64);
    setUint16(rawExtraFieldZip64View, 0, EXTRAFIELD_TYPE_ZIP64);
    setUint16(rawExtraFieldZip64View, 2, getLength(rawExtraFieldZip64) - 4);
    if (zip64ExtraFieldComplete) {
      const rawExtraFieldZip64View2 = getDataView2(rawExtraFieldZip64);
      let rawExtraFieldZip64Offset = 4;
      if (zip64UncompressedSize) {
        setBigUint64(rawExtraFieldZip64View2, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64CompressedSize && uncompressedFile) {
        setBigUint64(rawExtraFieldZip64View2, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64Offset) {
        setBigUint64(rawExtraFieldZip64View2, rawExtraFieldZip64Offset, BigInt(offset));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64DiskNumberStart) {
        setUint322(rawExtraFieldZip64View2, rawExtraFieldZip64Offset, diskNumberStart);
        rawExtraFieldZip64Offset += 4;
      }
    }
  } else {
    rawExtraFieldZip64 = new Uint8Array();
  }
  let rawExtraFieldAES;
  if (encrypted && !zipCrypto) {
    rawExtraFieldAES = new Uint8Array(getLength(EXTRAFIELD_DATA_AES) + 2);
    const extraFieldAESView = getDataView2(rawExtraFieldAES);
    setUint16(extraFieldAESView, 0, EXTRAFIELD_TYPE_AES);
    arraySet(rawExtraFieldAES, EXTRAFIELD_DATA_AES, 2);
    setUint8(extraFieldAESView, 8, encryptionStrength);
  } else {
    rawExtraFieldAES = new Uint8Array();
  }
  let rawExtraFieldNTFS;
  let rawExtraFieldExtendedTimestamp;
  let extraFieldExtendedTimestampFlag;
  if (extendedTimestamp) {
    rawExtraFieldExtendedTimestamp = new Uint8Array(9 + (lastAccessDate ? 4 : 0) + (creationDate ? 4 : 0));
    const extraFieldExtendedTimestampView = getDataView2(rawExtraFieldExtendedTimestamp);
    setUint16(extraFieldExtendedTimestampView, 0, EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
    setUint16(extraFieldExtendedTimestampView, 2, getLength(rawExtraFieldExtendedTimestamp) - 4);
    extraFieldExtendedTimestampFlag = 1 + (lastAccessDate ? 2 : 0) + (creationDate ? 4 : 0);
    setUint8(extraFieldExtendedTimestampView, 4, extraFieldExtendedTimestampFlag);
    let offset2 = 5;
    setUint322(extraFieldExtendedTimestampView, offset2, Math.floor(lastModDate.getTime() / 1e3));
    offset2 += 4;
    if (lastAccessDate) {
      setUint322(extraFieldExtendedTimestampView, offset2, Math.floor(lastAccessDate.getTime() / 1e3));
      offset2 += 4;
    }
    if (creationDate) {
      setUint322(extraFieldExtendedTimestampView, offset2, Math.floor(creationDate.getTime() / 1e3));
    }
    try {
      rawExtraFieldNTFS = new Uint8Array(36);
      const extraFieldNTFSView = getDataView2(rawExtraFieldNTFS);
      const lastModTimeNTFS = getTimeNTFS(lastModDate);
      setUint16(extraFieldNTFSView, 0, EXTRAFIELD_TYPE_NTFS);
      setUint16(extraFieldNTFSView, 2, 32);
      setUint16(extraFieldNTFSView, 8, EXTRAFIELD_TYPE_NTFS_TAG1);
      setUint16(extraFieldNTFSView, 10, 24);
      setBigUint64(extraFieldNTFSView, 12, lastModTimeNTFS);
      setBigUint64(extraFieldNTFSView, 20, getTimeNTFS(lastAccessDate) || lastModTimeNTFS);
      setBigUint64(extraFieldNTFSView, 28, getTimeNTFS(creationDate) || lastModTimeNTFS);
    } catch {
      rawExtraFieldNTFS = new Uint8Array();
    }
  } else {
    rawExtraFieldNTFS = rawExtraFieldExtendedTimestamp = new Uint8Array();
  }
  let rawExtraFieldUnix;
  try {
    const { uid, gid, unixMode, setuid, setgid, sticky, unixExtraFieldType } = options;
    if (unixExtraFieldType && (uid !== UNDEFINED_VALUE || gid !== UNDEFINED_VALUE || unixMode !== UNDEFINED_VALUE)) {
      const uidBytes = packUnixId(uid);
      const gidBytes = packUnixId(gid);
      let modeArray = new Uint8Array();
      if (unixExtraFieldType == UNIX_EXTRA_FIELD_TYPE && unixMode !== UNDEFINED_VALUE) {
        let modeToWrite = unixMode & MAX_16_BITS;
        if (setuid) {
          modeToWrite |= FILE_ATTR_UNIX_SETUID_MASK;
        }
        if (setgid) {
          modeToWrite |= FILE_ATTR_UNIX_SETGID_MASK;
        }
        if (sticky) {
          modeToWrite |= FILE_ATTR_UNIX_STICKY_MASK;
        }
        modeArray = new Uint8Array(2);
        const modeDataView = new DataView(modeArray.buffer);
        modeDataView.setUint16(0, modeToWrite, true);
      }
      const payloadLength = 3 + uidBytes.length + gidBytes.length + modeArray.length;
      rawExtraFieldUnix = new Uint8Array(4 + payloadLength);
      const rawExtraFieldUnixView = getDataView2(rawExtraFieldUnix);
      setUint16(rawExtraFieldUnixView, 0, unixExtraFieldType == INFOZIP_EXTRA_FIELD_TYPE ? EXTRAFIELD_TYPE_INFOZIP : EXTRAFIELD_TYPE_UNIX);
      setUint16(rawExtraFieldUnixView, 2, payloadLength);
      setUint8(rawExtraFieldUnixView, 4, 1);
      setUint8(rawExtraFieldUnixView, 5, uidBytes.length);
      let offset2 = 6;
      arraySet(rawExtraFieldUnix, uidBytes, offset2);
      offset2 += uidBytes.length;
      setUint8(rawExtraFieldUnixView, offset2, gidBytes.length);
      offset2++;
      arraySet(rawExtraFieldUnix, gidBytes, offset2);
      offset2 += gidBytes.length;
      arraySet(rawExtraFieldUnix, modeArray, offset2);
    } else {
      rawExtraFieldUnix = new Uint8Array();
    }
  } catch {
    rawExtraFieldUnix = new Uint8Array();
  }
  if (compressionMethod === UNDEFINED_VALUE) {
    compressionMethod = compressed ? COMPRESSION_METHOD_DEFLATE : COMPRESSION_METHOD_STORE;
  }
  if (zip64) {
    version = version > VERSION_ZIP64 ? version : VERSION_ZIP64;
  }
  if (encrypted && !zipCrypto) {
    version = version > VERSION_AES ? version : VERSION_AES;
    rawExtraFieldAES[9] = compressionMethod;
    compressionMethod = COMPRESSION_METHOD_AES;
  }
  const localExtraFieldZip64Length = zip64ExtraFieldComplete ? getLength(rawExtraFieldZip64) : 0;
  const extraFieldLength = localExtraFieldZip64Length + getLength(rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraFieldUnix, rawExtraField);
  const {
    headerArray,
    headerView,
    rawLastModDate
  } = getHeaderArrayData({
    version,
    bitFlag: getBitFlag(level, useUnicodeFileNames, dataDescriptor, encrypted, compressionMethod),
    compressionMethod,
    uncompressedSize,
    lastModDate: lastModDate < MIN_DATE ? MIN_DATE : lastModDate > MAX_DATE ? MAX_DATE : lastModDate,
    rawFilename,
    zip64CompressedSize,
    zip64UncompressedSize,
    extraFieldLength
  });
  let localHeaderOffset = HEADER_SIZE;
  const localHeaderArray = new Uint8Array(localHeaderOffset + getLength(rawFilename) + extraFieldLength);
  const localHeaderView = getDataView2(localHeaderArray);
  setUint322(localHeaderView, 0, LOCAL_FILE_HEADER_SIGNATURE);
  arraySet(localHeaderArray, headerArray, 4);
  arraySet(localHeaderArray, rawFilename, localHeaderOffset);
  localHeaderOffset += getLength(rawFilename);
  if (zip64ExtraFieldComplete) {
    arraySet(localHeaderArray, rawExtraFieldZip64, localHeaderOffset);
  }
  localHeaderOffset += localExtraFieldZip64Length;
  arraySet(localHeaderArray, rawExtraFieldAES, localHeaderOffset);
  localHeaderOffset += getLength(rawExtraFieldAES);
  arraySet(localHeaderArray, rawExtraFieldExtendedTimestamp, localHeaderOffset);
  localHeaderOffset += getLength(rawExtraFieldExtendedTimestamp);
  arraySet(localHeaderArray, rawExtraFieldNTFS, localHeaderOffset);
  localHeaderOffset += getLength(rawExtraFieldNTFS);
  arraySet(localHeaderArray, rawExtraFieldUnix, localHeaderOffset);
  localHeaderOffset += getLength(rawExtraFieldUnix);
  arraySet(localHeaderArray, rawExtraField, localHeaderOffset);
  if (dataDescriptor) {
    setUint322(localHeaderView, HEADER_OFFSET_COMPRESSED_SIZE + 4, 0);
    setUint322(localHeaderView, HEADER_OFFSET_UNCOMPRESSED_SIZE + 4, 0);
  }
  return {
    localHeaderArray,
    localHeaderView,
    headerArray,
    headerView,
    lastModDate,
    rawLastModDate,
    encrypted,
    compressed,
    version,
    compressionMethod,
    extraFieldExtendedTimestampFlag,
    rawExtraFieldZip64,
    localExtraFieldZip64Length,
    rawExtraFieldExtendedTimestamp,
    rawExtraFieldNTFS,
    rawExtraFieldUnix,
    rawExtraFieldAES,
    extraFieldLength
  };
}
function appendExtraFieldUSDZ(entryInfo, zipWriterOffset) {
  const { headerInfo } = entryInfo;
  let { localHeaderArray, extraFieldLength } = headerInfo;
  let localHeaderArrayView = getDataView2(localHeaderArray);
  let extraBytesLength = 64 - (zipWriterOffset + getLength(localHeaderArray)) % 64;
  if (extraBytesLength < 4) {
    extraBytesLength += 64;
  }
  const rawExtraFieldUSDZ = new Uint8Array(extraBytesLength);
  const extraFieldUSDZView = getDataView2(rawExtraFieldUSDZ);
  setUint16(extraFieldUSDZView, 0, EXTRAFIELD_TYPE_USDZ);
  setUint16(extraFieldUSDZView, 2, extraBytesLength - 2);
  const previousLocalHeaderArray = localHeaderArray;
  headerInfo.localHeaderArray = localHeaderArray = new Uint8Array(getLength(previousLocalHeaderArray) + extraBytesLength);
  arraySet(localHeaderArray, previousLocalHeaderArray);
  arraySet(localHeaderArray, rawExtraFieldUSDZ, getLength(previousLocalHeaderArray));
  localHeaderArrayView = getDataView2(localHeaderArray);
  setUint16(localHeaderArrayView, 28, extraFieldLength + extraBytesLength);
  entryInfo.metadataSize += extraBytesLength;
}
function packUnixId(id) {
  if (id === UNDEFINED_VALUE) {
    return new Uint8Array();
  } else {
    const dataArray = new Uint8Array(4);
    const dataView = getDataView2(dataArray);
    dataView.setUint32(0, id, true);
    let length = 4;
    while (length > 1 && dataArray[length - 1] === 0) {
      length--;
    }
    return dataArray.subarray(0, length);
  }
}
function normalizeMsdosAttributes(msdosAttributesRaw, msdosAttributes) {
  if (msdosAttributesRaw !== UNDEFINED_VALUE) {
    msdosAttributesRaw = msdosAttributesRaw & MAX_8_BITS;
  } else if (msdosAttributes !== UNDEFINED_VALUE) {
    const { readOnly, hidden, system, directory: msdDir, archive } = msdosAttributes;
    let raw = 0;
    if (readOnly) raw |= FILE_ATTR_MSDOS_READONLY_MASK;
    if (hidden) raw |= FILE_ATTR_MSDOS_HIDDEN_MASK;
    if (system) raw |= FILE_ATTR_MSDOS_SYSTEM_MASK;
    if (msdDir) raw |= FILE_ATTR_MSDOS_DIR_MASK;
    if (archive) raw |= FILE_ATTR_MSDOS_ARCHIVE_MASK;
    msdosAttributesRaw = raw & MAX_8_BITS;
  }
  if (msdosAttributes === UNDEFINED_VALUE) {
    msdosAttributes = {
      readOnly: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_READONLY_MASK),
      hidden: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_HIDDEN_MASK),
      system: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_SYSTEM_MASK),
      directory: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_DIR_MASK),
      archive: Boolean(msdosAttributesRaw & FILE_ATTR_MSDOS_ARCHIVE_MASK)
    };
  }
  return { msdosAttributesRaw, msdosAttributes };
}
function getDataDescriptorInfo({
  zip64,
  dataDescriptor,
  dataDescriptorSignature
}) {
  let dataDescriptorArray = new Uint8Array();
  let dataDescriptorView, dataDescriptorOffset = 0;
  let dataDescriptorLength = zip64 ? DATA_DESCRIPTOR_RECORD_ZIP_64_LENGTH : DATA_DESCRIPTOR_RECORD_LENGTH;
  if (dataDescriptorSignature) {
    dataDescriptorLength += DATA_DESCRIPTOR_RECORD_SIGNATURE_LENGTH;
  }
  if (dataDescriptor) {
    dataDescriptorArray = new Uint8Array(dataDescriptorLength);
    dataDescriptorView = getDataView2(dataDescriptorArray);
    if (dataDescriptorSignature) {
      dataDescriptorOffset = DATA_DESCRIPTOR_RECORD_SIGNATURE_LENGTH;
      setUint322(dataDescriptorView, 0, DATA_DESCRIPTOR_RECORD_SIGNATURE);
    }
  }
  return {
    dataDescriptorArray,
    dataDescriptorView,
    dataDescriptorOffset
  };
}
function setEntryInfo({
  signature,
  compressedSize,
  uncompressedSize,
  headerInfo,
  dataDescriptorInfo
}, {
  zip64,
  zipCrypto,
  dataDescriptor
}) {
  const {
    headerView,
    encrypted
  } = headerInfo;
  const {
    dataDescriptorView,
    dataDescriptorOffset
  } = dataDescriptorInfo;
  if ((!encrypted || zipCrypto) && signature !== UNDEFINED_VALUE) {
    setUint322(headerView, HEADER_OFFSET_SIGNATURE, signature);
    if (dataDescriptor) {
      setUint322(dataDescriptorView, dataDescriptorOffset, signature);
    }
  }
  if (zip64) {
    if (dataDescriptor) {
      setBigUint64(dataDescriptorView, dataDescriptorOffset + 4, BigInt(compressedSize));
      setBigUint64(dataDescriptorView, dataDescriptorOffset + 12, BigInt(uncompressedSize));
    }
  } else {
    setUint322(headerView, HEADER_OFFSET_COMPRESSED_SIZE, compressedSize);
    setUint322(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, uncompressedSize);
    if (dataDescriptor) {
      setUint322(dataDescriptorView, dataDescriptorOffset + 4, compressedSize);
      setUint322(dataDescriptorView, dataDescriptorOffset + 8, uncompressedSize);
    }
  }
}
function updateLocalHeader({
  rawFilename,
  encrypted,
  zip64,
  localExtraFieldZip64Length,
  signature,
  compressedSize,
  uncompressedSize,
  offset,
  diskNumberStart,
  zip64UncompressedSize,
  zip64CompressedSize,
  zip64Offset,
  zip64DiskNumberStart
}, localHeaderView, { dataDescriptor }) {
  if (!dataDescriptor) {
    if (!encrypted) {
      setUint322(localHeaderView, HEADER_OFFSET_SIGNATURE + 4, signature);
    }
    if (!zip64) {
      setUint322(localHeaderView, HEADER_OFFSET_COMPRESSED_SIZE + 4, compressedSize);
      setUint322(localHeaderView, HEADER_OFFSET_UNCOMPRESSED_SIZE + 4, uncompressedSize);
    }
  }
  if (zip64) {
    if (localExtraFieldZip64Length) {
      let localHeaderOffset = HEADER_SIZE + getLength(rawFilename) + 4;
      if (zip64UncompressedSize) {
        setBigUint64(localHeaderView, localHeaderOffset, BigInt(uncompressedSize));
        localHeaderOffset += 8;
      }
      if (zip64CompressedSize) {
        setBigUint64(localHeaderView, localHeaderOffset, BigInt(compressedSize));
        localHeaderOffset += 8;
      }
      if (zip64Offset) {
        setBigUint64(localHeaderView, localHeaderOffset, BigInt(offset));
        localHeaderOffset += 8;
      }
      if (zip64DiskNumberStart) {
        setUint322(localHeaderView, localHeaderOffset, diskNumberStart);
      }
    }
  }
}
function updateZip64ExtraField({
  compressedSize,
  uncompressedSize,
  offset,
  diskNumberStart,
  zip64UncompressedSize,
  zip64CompressedSize,
  zip64Offset,
  zip64DiskNumberStart,
  rawExtraFieldZip64
}) {
  const rawExtraFieldZip64View = getDataView2(rawExtraFieldZip64);
  let rawExtraFieldZip64Offset = 4;
  if (zip64UncompressedSize) {
    setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
    rawExtraFieldZip64Offset += 8;
  }
  if (zip64CompressedSize) {
    setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(compressedSize));
    rawExtraFieldZip64Offset += 8;
  }
  if (zip64Offset) {
    setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(offset));
    rawExtraFieldZip64Offset += 8;
  }
  if (zip64DiskNumberStart) {
    setUint322(rawExtraFieldZip64View, rawExtraFieldZip64Offset, diskNumberStart);
  }
}
async function closeFile(zipWriter, comment, options) {
  const { files, writer } = zipWriter;
  const { diskOffset } = writer;
  let { diskNumber } = writer;
  let offset = 0;
  let directoryDataLength = 0;
  let directoryOffset = zipWriter.offset - diskOffset;
  let filesLength = files.size;
  for (const [, fileEntry] of files) {
    const {
      rawFilename,
      rawExtraFieldZip64,
      rawExtraFieldAES,
      rawComment,
      rawExtraFieldNTFS,
      rawExtraFieldUnix,
      rawExtraField,
      extendedTimestamp,
      extraFieldExtendedTimestampFlag,
      lastModDate
    } = fileEntry;
    let rawExtraFieldTimestamp;
    if (extendedTimestamp) {
      rawExtraFieldTimestamp = new Uint8Array(9);
      const extraFieldExtendedTimestampView = getDataView2(rawExtraFieldTimestamp);
      setUint16(extraFieldExtendedTimestampView, 0, EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
      setUint16(extraFieldExtendedTimestampView, 2, 5);
      setUint8(extraFieldExtendedTimestampView, 4, extraFieldExtendedTimestampFlag);
      setUint322(extraFieldExtendedTimestampView, 5, Math.floor(lastModDate.getTime() / 1e3));
    } else {
      rawExtraFieldTimestamp = new Uint8Array();
    }
    fileEntry.rawExtraFieldExtendedTimestamp = rawExtraFieldTimestamp;
    directoryDataLength += 46 + getLength(
      rawFilename,
      rawComment,
      rawExtraFieldZip64,
      rawExtraFieldAES,
      rawExtraFieldNTFS,
      rawExtraFieldUnix,
      rawExtraFieldTimestamp,
      rawExtraField
    );
  }
  const directoryArray = new Uint8Array(directoryDataLength);
  const directoryView = getDataView2(directoryArray);
  await initStream(writer);
  let directoryDiskOffset = 0;
  for (const [indexFileEntry, fileEntry] of Array.from(files.values()).entries()) {
    const {
      offset: fileEntryOffset,
      rawFilename,
      rawExtraFieldZip64,
      rawExtraFieldAES,
      rawExtraFieldExtendedTimestamp,
      rawExtraFieldNTFS,
      rawExtraFieldUnix,
      rawExtraField,
      rawComment,
      versionMadeBy,
      headerArray,
      headerView,
      zip64: zip642,
      zip64UncompressedSize,
      zip64CompressedSize,
      zip64DiskNumberStart,
      zip64Offset,
      internalFileAttributes,
      externalFileAttributes,
      diskNumberStart,
      uncompressedSize,
      compressedSize
    } = fileEntry;
    const extraFieldLength = getLength(rawExtraFieldZip64, rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraFieldUnix, rawExtraField);
    setUint322(directoryView, offset, CENTRAL_FILE_HEADER_SIGNATURE);
    setUint16(directoryView, offset + 4, versionMadeBy);
    if (!zip64UncompressedSize) {
      setUint322(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, uncompressedSize);
    }
    if (!zip64CompressedSize) {
      setUint322(headerView, HEADER_OFFSET_COMPRESSED_SIZE, compressedSize);
    }
    arraySet(directoryArray, headerArray, offset + 6);
    let directoryOffset2 = offset + HEADER_SIZE;
    setUint16(directoryView, directoryOffset2, extraFieldLength);
    directoryOffset2 += 2;
    setUint16(directoryView, directoryOffset2, getLength(rawComment));
    directoryOffset2 += 2;
    setUint16(directoryView, directoryOffset2, zip642 && zip64DiskNumberStart ? MAX_16_BITS : diskNumberStart);
    directoryOffset2 += 2;
    setUint16(directoryView, directoryOffset2, internalFileAttributes);
    directoryOffset2 += 2;
    if (externalFileAttributes) {
      setUint322(directoryView, directoryOffset2, externalFileAttributes);
    }
    directoryOffset2 += 4;
    setUint322(directoryView, directoryOffset2, zip642 && zip64Offset ? MAX_32_BITS : fileEntryOffset);
    directoryOffset2 += 4;
    arraySet(directoryArray, rawFilename, directoryOffset2);
    directoryOffset2 += getLength(rawFilename);
    arraySet(directoryArray, rawExtraFieldZip64, directoryOffset2);
    directoryOffset2 += getLength(rawExtraFieldZip64);
    arraySet(directoryArray, rawExtraFieldAES, directoryOffset2);
    directoryOffset2 += getLength(rawExtraFieldAES);
    arraySet(directoryArray, rawExtraFieldExtendedTimestamp, directoryOffset2);
    directoryOffset2 += getLength(rawExtraFieldExtendedTimestamp);
    arraySet(directoryArray, rawExtraFieldNTFS, directoryOffset2);
    directoryOffset2 += getLength(rawExtraFieldNTFS);
    arraySet(directoryArray, rawExtraFieldUnix, directoryOffset2);
    directoryOffset2 += getLength(rawExtraFieldUnix);
    arraySet(directoryArray, rawExtraField, directoryOffset2);
    directoryOffset2 += getLength(rawExtraField);
    arraySet(directoryArray, rawComment, directoryOffset2);
    directoryOffset2 += getLength(rawComment);
    if (offset - directoryDiskOffset > writer.availableSize) {
      writer.availableSize = 0;
      await writeData(writer, directoryArray.slice(directoryDiskOffset, offset));
      directoryDiskOffset = offset;
    }
    offset = directoryOffset2;
    if (options.onprogress) {
      try {
        await options.onprogress(indexFileEntry + 1, files.size, new Entry(fileEntry));
      } catch {
      }
    }
  }
  await writeData(writer, directoryDiskOffset ? directoryArray.slice(directoryDiskOffset) : directoryArray);
  let lastDiskNumber = writer.diskNumber;
  const { availableSize } = writer;
  if (availableSize < END_OF_CENTRAL_DIR_LENGTH) {
    lastDiskNumber++;
  }
  let zip64 = getOptionValue2(zipWriter, options, PROPERTY_NAME_ZIP64);
  if (directoryOffset > MAX_32_BITS || directoryDataLength > MAX_32_BITS || filesLength > MAX_16_BITS || lastDiskNumber > MAX_16_BITS) {
    if (zip64 === false) {
      throw new Error(ERR_UNSUPPORTED_FORMAT);
    } else {
      zip64 = true;
    }
  }
  const endOfdirectoryArray = new Uint8Array(zip64 ? ZIP64_END_OF_CENTRAL_DIR_TOTAL_LENGTH : END_OF_CENTRAL_DIR_LENGTH);
  const endOfdirectoryView = getDataView2(endOfdirectoryArray);
  offset = 0;
  if (zip64) {
    setUint322(endOfdirectoryView, 0, ZIP64_END_OF_CENTRAL_DIR_SIGNATURE);
    setBigUint64(endOfdirectoryView, 4, BigInt(44));
    setUint16(endOfdirectoryView, 12, 45);
    setUint16(endOfdirectoryView, 14, 45);
    setUint322(endOfdirectoryView, 16, lastDiskNumber);
    setUint322(endOfdirectoryView, 20, diskNumber);
    setBigUint64(endOfdirectoryView, 24, BigInt(filesLength));
    setBigUint64(endOfdirectoryView, 32, BigInt(filesLength));
    setBigUint64(endOfdirectoryView, 40, BigInt(directoryDataLength));
    setBigUint64(endOfdirectoryView, 48, BigInt(directoryOffset));
    setUint322(endOfdirectoryView, 56, ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE);
    setBigUint64(endOfdirectoryView, 64, BigInt(directoryOffset) + BigInt(directoryDataLength));
    setUint322(endOfdirectoryView, 72, lastDiskNumber + 1);
    const supportZip64SplitFile = getOptionValue2(zipWriter, options, OPTION_SUPPORT_ZIP64_SPLIT_FILE, true);
    if (supportZip64SplitFile) {
      lastDiskNumber = MAX_16_BITS;
      diskNumber = MAX_16_BITS;
    }
    filesLength = MAX_16_BITS;
    directoryOffset = MAX_32_BITS;
    directoryDataLength = MAX_32_BITS;
    offset += ZIP64_END_OF_CENTRAL_DIR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH;
  }
  setUint322(endOfdirectoryView, offset, END_OF_CENTRAL_DIR_SIGNATURE);
  setUint16(endOfdirectoryView, offset + 4, lastDiskNumber);
  setUint16(endOfdirectoryView, offset + 6, diskNumber);
  setUint16(endOfdirectoryView, offset + 8, filesLength);
  setUint16(endOfdirectoryView, offset + 10, filesLength);
  setUint322(endOfdirectoryView, offset + 12, directoryDataLength);
  setUint322(endOfdirectoryView, offset + 16, directoryOffset);
  const commentLength = getLength(comment);
  if (commentLength) {
    if (commentLength <= MAX_16_BITS) {
      setUint16(endOfdirectoryView, offset + 20, commentLength);
    } else {
      throw new Error(ERR_INVALID_COMMENT);
    }
  }
  await writeData(writer, endOfdirectoryArray);
  if (commentLength) {
    await writeData(writer, comment);
  }
}
async function writeData(writer, array) {
  const { writable } = writer;
  const streamWriter = writable.getWriter();
  try {
    await streamWriter.ready;
    writer.size += getLength(array);
    await streamWriter.write(array);
  } finally {
    streamWriter.releaseLock();
  }
}
function getTimeNTFS(date) {
  if (date) {
    return (BigInt(date.getTime()) + BigInt(116444736e5)) * BigInt(1e4);
  }
}
function getOptionValue2(zipWriter, options, name, defaultValue) {
  const result = options[name] === UNDEFINED_VALUE ? zipWriter.options[name] : options[name];
  return result === UNDEFINED_VALUE ? defaultValue : result;
}
function getMaximumCompressedSize(uncompressedSize) {
  return uncompressedSize + 5 * (Math.floor(uncompressedSize / 16383) + 1);
}
function setUint8(view, offset, value) {
  view.setUint8(offset, value);
}
function setUint16(view, offset, value) {
  view.setUint16(offset, value, true);
}
function setUint322(view, offset, value) {
  view.setUint32(offset, value, true);
}
function setBigUint64(view, offset, value) {
  view.setBigUint64(offset, value, true);
}
function arraySet(array, typedArray, offset) {
  array.set(typedArray, offset);
}
function getDataView2(array) {
  return new DataView(array.buffer);
}
function getLength(...arrayLikes) {
  let result = 0;
  arrayLikes.forEach((arrayLike) => arrayLike && (result += arrayLike.length));
  return result;
}
function getHeaderArrayData({
  version,
  bitFlag,
  compressionMethod,
  uncompressedSize,
  compressedSize,
  lastModDate,
  rawFilename,
  zip64CompressedSize,
  zip64UncompressedSize,
  extraFieldLength
}) {
  const headerArray = new Uint8Array(HEADER_SIZE - 4);
  const headerView = getDataView2(headerArray);
  setUint16(headerView, 0, version);
  setUint16(headerView, 2, bitFlag);
  setUint16(headerView, 4, compressionMethod);
  const dateArray = new Uint32Array(1);
  const dateView = getDataView2(dateArray);
  setUint16(dateView, 0, (lastModDate.getHours() << 6 | lastModDate.getMinutes()) << 5 | lastModDate.getSeconds() / 2);
  setUint16(dateView, 2, (lastModDate.getFullYear() - 1980 << 4 | lastModDate.getMonth() + 1) << 5 | lastModDate.getDate());
  const rawLastModDate = dateArray[0];
  setUint322(headerView, 6, rawLastModDate);
  if (zip64CompressedSize || compressedSize !== UNDEFINED_VALUE) {
    setUint322(headerView, HEADER_OFFSET_COMPRESSED_SIZE, zip64CompressedSize ? MAX_32_BITS : compressedSize);
  }
  if (zip64UncompressedSize || uncompressedSize !== UNDEFINED_VALUE) {
    setUint322(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, zip64UncompressedSize ? MAX_32_BITS : uncompressedSize);
  }
  setUint16(headerView, 22, getLength(rawFilename));
  setUint16(headerView, 24, extraFieldLength);
  return {
    headerArray,
    headerView,
    rawLastModDate
  };
}
function getBitFlag(level, useUnicodeFileNames, dataDescriptor, encrypted, compressionMethod) {
  let bitFlag = 0;
  if (useUnicodeFileNames) {
    bitFlag = bitFlag | BITFLAG_LANG_ENCODING_FLAG;
  }
  if (dataDescriptor) {
    bitFlag = bitFlag | BITFLAG_DATA_DESCRIPTOR;
  }
  if (compressionMethod == COMPRESSION_METHOD_DEFLATE || compressionMethod == COMPRESSION_METHOD_DEFLATE_64) {
    if (level >= 0 && level <= 3) {
      bitFlag = bitFlag | BITFLAG_LEVEL_SUPER_FAST_MASK;
    }
    if (level > 3 && level <= 5) {
      bitFlag = bitFlag | BITFLAG_LEVEL_FAST_MASK;
    }
    if (level == 9) {
      bitFlag = bitFlag | BITFLAG_LEVEL_MAX_MASK;
    }
  }
  if (encrypted) {
    bitFlag = bitFlag | BITFLAG_ENCRYPTED;
  }
  return bitFlag;
}

// node_modules/@zip.js/zip.js/lib/core/util/default-mime-type.js
function getMimeType() {
  return "application/octet-stream";
}

// node_modules/@zip.js/zip.js/lib/zip-core-base.js
var import_meta = {};
try {
  configure({ baseURI: import_meta.url });
} catch {
}

// node_modules/@zip.js/zip.js/lib/core/zlib-streams-inline.js
var A = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
function g(g2) {
  let B2;
  g2({ wasmURI: () => (B2 || (B2 = "data:application/wasm;base64," + ((g3) => {
    g3 = ((g4) => {
      const B4 = (g4 = (g4 + "").replace(/[^A-Za-z0-9+/=]/g, "")).length, E3 = [];
      for (let I3 = 0; B4 > I3; I3 += 4) {
        const B5 = A.indexOf(g4[I3]) << 18 | A.indexOf(g4[I3 + 1]) << 12 | (63 & A.indexOf(g4[I3 + 2])) << 6 | 63 & A.indexOf(g4[I3 + 3]);
        E3.push(B5 >> 16 & 255), "=" !== g4[I3 + 2] && E3.push(B5 >> 8 & 255), "=" !== g4[I3 + 3] && E3.push(255 & B5);
      }
      return new Uint8Array(E3);
    })(g3);
    let B3 = new Uint8Array(1024), E2 = 0;
    for (let A3 = 0; A3 < g3.length; ) {
      const C2 = g3[A3++];
      if (128 & C2) {
        const Q2 = 3 + (127 & C2), Y2 = g3[A3++] << 8 | g3[A3++], D2 = E2 - Y2;
        I2(E2 + Q2);
        for (let A4 = 0; Q2 > A4; A4++) B3[E2++] = B3[D2 + A4];
      } else {
        const Q2 = C2;
        I2(E2 + Q2);
        for (let I3 = 0; Q2 > I3 && A3 < g3.length; I3++) B3[E2++] = g3[A3++];
      }
    }
    return ((g4) => {
      let B4 = "";
      const E3 = g4.length;
      let I3 = 0;
      for (; E3 > I3 + 2; I3 += 3) {
        const E4 = g4[I3] << 16 | g4[I3 + 1] << 8 | g4[I3 + 2];
        B4 += A[E4 >> 18 & 63] + A[E4 >> 12 & 63] + A[E4 >> 6 & 63] + A[63 & E4];
      }
      const C2 = E3 - I3;
      if (1 === C2) {
        const E4 = g4[I3] << 16;
        B4 += A[E4 >> 18 & 63] + A[E4 >> 12 & 63] + "==";
      } else if (2 === C2) {
        const E4 = g4[I3] << 16 | g4[I3 + 1] << 8;
        B4 += A[E4 >> 18 & 63] + A[E4 >> 12 & 63] + A[E4 >> 6 & 63] + "=";
      }
      return B4;
    })(new Uint8Array(B3.buffer.slice(0, E2)));
    function I2(A3) {
      if (B3.length < A3) {
        let g4 = 2 * B3.length;
        for (; A3 > g4; ) g4 *= 2;
        const I3 = new Uint8Array(g4);
        I3.set(B3.subarray(0, E2)), B3 = I3;
      }
    }
  })("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")), B2) });
}

// node_modules/@zip.js/zip.js/lib/core/streams/zlib-wasm/zlib-streams.js
var wasm;
var malloc;
var free;
var memory;
function setWasmExports(wasmAPI) {
  wasm = wasmAPI;
  ({ malloc, free, memory } = wasm);
  if (typeof malloc !== "function" || typeof free !== "function" || !memory) {
    wasm = malloc = free = memory = null;
    throw new Error("Invalid WASM module");
  }
}
function _make(isCompress, type, options = {}) {
  const level = typeof options.level === "number" ? options.level : -1;
  const outBufferSize = typeof options.outBuffer === "number" ? options.outBuffer : 64 * 1024;
  const inBufferSize = typeof options.inBufferSize === "number" ? options.inBufferSize : 64 * 1024;
  return new TransformStream({
    start() {
      let result;
      this.out = malloc(outBufferSize);
      this.in = malloc(inBufferSize);
      this.inBufferSize = inBufferSize;
      this._scratch = new Uint8Array(outBufferSize);
      if (isCompress) {
        this._process = wasm.deflate_process;
        this._last_consumed = wasm.deflate_last_consumed;
        this._end = wasm.deflate_end;
        this.streamHandle = wasm.deflate_new();
        if (type === "gzip") {
          result = wasm.deflate_init_gzip(this.streamHandle, level);
        } else if (type === "deflate-raw") {
          result = wasm.deflate_init_raw(this.streamHandle, level);
        } else {
          result = wasm.deflate_init(this.streamHandle, level);
        }
      } else {
        if (type === "deflate64-raw") {
          this._process = wasm.inflate9_process;
          this._last_consumed = wasm.inflate9_last_consumed;
          this._end = wasm.inflate9_end;
          this.streamHandle = wasm.inflate9_new();
          result = wasm.inflate9_init_raw(this.streamHandle);
        } else {
          this._process = wasm.inflate_process;
          this._last_consumed = wasm.inflate_last_consumed;
          this._end = wasm.inflate_end;
          this.streamHandle = wasm.inflate_new();
          if (type === "deflate-raw") {
            result = wasm.inflate_init_raw(this.streamHandle);
          } else if (type === "gzip") {
            result = wasm.inflate_init_gzip(this.streamHandle);
          } else {
            result = wasm.inflate_init(this.streamHandle);
          }
        }
      }
      if (result !== 0) {
        throw new Error("init failed:" + result);
      }
    },
    transform(chunk, controller) {
      try {
        const buffer = chunk;
        const heap = new Uint8Array(memory.buffer);
        const process = this._process;
        const last_consumed = this._last_consumed;
        const out = this.out;
        const scratch = this._scratch;
        let offset = 0;
        while (offset < buffer.length) {
          const toRead = Math.min(buffer.length - offset, 32 * 1024);
          if (!this.in || this.inBufferSize < toRead) {
            if (this.in && free) {
              free(this.in);
            }
            this.in = malloc(toRead);
            this.inBufferSize = toRead;
          }
          heap.set(buffer.subarray(offset, offset + toRead), this.in);
          const result = process(this.streamHandle, this.in, toRead, out, outBufferSize, 0);
          if (!isCompress && result < 0) {
            throw new Error("process error:" + result);
          }
          const prod = result & 16777215;
          if (prod) {
            scratch.set(heap.subarray(out, out + prod), 0);
            controller.enqueue(scratch.slice(0, prod));
          }
          const consumed = last_consumed(this.streamHandle);
          if (consumed === 0) {
            break;
          }
          offset += consumed;
        }
      } catch (error) {
        if (this._end && this.streamHandle) {
          this._end(this.streamHandle);
        }
        if (this.in && free) {
          free(this.in);
        }
        if (this.out && free) {
          free(this.out);
        }
        controller.error(error);
      }
    },
    flush(controller) {
      try {
        const heap = new Uint8Array(memory.buffer);
        const process = this._process;
        const out = this.out;
        const scratch = this._scratch;
        while (true) {
          const result = process(this.streamHandle, 0, 0, out, outBufferSize, 4);
          if (!isCompress && result < 0) {
            throw new Error("process error:" + result);
          }
          const produced = result & 16777215;
          const code = result >> 24 & 255;
          if (produced) {
            scratch.set(heap.subarray(out, out + produced), 0);
            controller.enqueue(scratch.slice(0, produced));
          }
          if (code === 1 || produced === 0) {
            break;
          }
        }
      } catch (error) {
        controller.error(error);
      } finally {
        if (this._end && this.streamHandle) {
          const result = this._end(this.streamHandle);
          if (result !== 0) {
            controller.error(new Error("end error:" + result));
          }
        }
        if (this.in && free) {
          free(this.in);
        }
        if (this.out && free) {
          free(this.out);
        }
      }
    }
  });
}
var CompressionStreamZlib = class {
  constructor(type = "deflate", options) {
    return _make(true, type, options);
  }
};
var DecompressionStreamZlib = class {
  constructor(type = "deflate", options) {
    return _make(false, type, options);
  }
};

// node_modules/@zip.js/zip.js/lib/core/streams/zlib-wasm/zlib-streams-loader.js
var initializedModule = false;
async function initModule2(wasmURI, { baseURI }) {
  if (!initializedModule) {
    let arrayBuffer, uri;
    try {
      try {
        uri = new URL(wasmURI, baseURI);
      } catch {
      }
      const response = await fetch(uri);
      arrayBuffer = await response.arrayBuffer();
    } catch (error) {
      if (wasmURI.startsWith("data:application/wasm;base64,")) {
        arrayBuffer = arrayBufferFromDataURI(wasmURI);
      } else {
        throw error;
      }
    }
    const wasmInstance = await WebAssembly.instantiate(arrayBuffer);
    setWasmExports(wasmInstance.instance.exports);
    initializedModule = true;
  }
}
function resetWasmModule() {
  initializedModule = false;
}
function arrayBufferFromDataURI(dataURI) {
  const base64 = dataURI.split(",")[1];
  const binary = atob(base64);
  const len = binary.length;
  const bytes = new Uint8Array(len);
  for (let i = 0; i < len; ++i) {
    bytes[i] = binary.charCodeAt(i);
  }
  return bytes.buffer;
}

// node_modules/@zip.js/zip.js/lib/zip-module-wasm.js
var modulePromise;
g(configure);
configureWorker({
  initModule: (config2) => {
    if (!modulePromise) {
      let { wasmURI } = config2;
      if (typeof wasmURI == FUNCTION_TYPE) {
        wasmURI = wasmURI();
      }
      modulePromise = initModule2(wasmURI, config2);
    }
    return modulePromise;
  }
});
configure({
  CompressionStreamZlib,
  DecompressionStreamZlib
});
function terminateWorkersAndModule() {
  modulePromise = null;
  terminateWorkers();
  resetWasmModule();
}

// node_modules/@zip.js/zip.js/lib/core/zip-fs.js
var ZipEntry2 = class {
  constructor(fs3, name, params, parent) {
    const zipEntry = this;
    if (fs3.root && parent && parent.getChildByName(name)) {
      throw new Error("Entry filename already exists");
    }
    if (!params) {
      params = {};
    }
    Object.assign(zipEntry, {
      fs: fs3,
      name,
      data: params.data,
      options: params.options,
      id: fs3.entries.length,
      parent,
      children: [],
      uncompressedSize: params.uncompressedSize || 0,
      passThrough: params.passThrough
    });
    fs3.entries.push(zipEntry);
    if (parent) {
      zipEntry.parent.children.push(zipEntry);
    }
  }
  moveTo(target) {
    const zipEntry = this;
    zipEntry.fs.move(zipEntry, target);
  }
  getFullname() {
    return this.getRelativeName();
  }
  getRelativeName(ancestor = this.fs.root) {
    const zipEntry = this;
    let relativeName = zipEntry.name;
    let entry = zipEntry.parent;
    while (entry && entry != ancestor) {
      relativeName = (entry.name ? entry.name + "/" : "") + relativeName;
      entry = entry.parent;
    }
    return relativeName;
  }
  isDescendantOf(ancestor) {
    let entry = this.parent;
    while (entry && entry.id != ancestor.id) {
      entry = entry.parent;
    }
    return Boolean(entry);
  }
  rename(name) {
    const parent = this.parent;
    if (parent && parent.getChildByName(name)) {
      throw new Error("Entry filename already exists");
    } else {
      this.name = name;
    }
  }
};
var ZipFileEntry = class _ZipFileEntry extends ZipEntry2 {
  constructor(fs3, name, params, parent) {
    super(fs3, name, params, parent);
    const zipEntry = this;
    zipEntry.Reader = params.Reader;
    zipEntry.Writer = params.Writer;
    if (params.getData) {
      zipEntry.getData = params.getData;
    }
  }
  clone() {
    return new _ZipFileEntry(this.fs, this.name, this);
  }
  async getData(writer, options = {}) {
    const zipEntry = this;
    if (!writer || writer.constructor == zipEntry.Writer && zipEntry.data) {
      return zipEntry.data;
    } else {
      const reader = zipEntry.reader = new zipEntry.Reader(zipEntry.data, options);
      const uncompressedSize = zipEntry.data ? zipEntry.data.uncompressedSize : reader.size;
      await Promise.all([initStream(reader), initStream(writer, uncompressedSize)]);
      const { readable } = reader;
      zipEntry.uncompressedSize = reader.size;
      await readable.pipeTo(writer.writable);
      return writer.getData ? writer.getData() : writer.writable;
    }
  }
  isPasswordProtected() {
    return this.data.encrypted;
  }
  async checkPassword(password, options = {}) {
    const zipEntry = this;
    if (zipEntry.isPasswordProtected()) {
      options.password = password;
      options.checkPasswordOnly = true;
      try {
        await zipEntry.data.getData(null, options);
        return true;
      } catch (error) {
        if (error.message == ERR_INVALID_PASSWORD) {
          return false;
        } else {
          throw error;
        }
      }
    } else {
      return true;
    }
  }
  getText(encoding, options) {
    return this.getData(new TextWriter(encoding), options);
  }
  getBlob(mimeType, options) {
    return this.getData(new BlobWriter(mimeType), options);
  }
  getData64URI(mimeType, options) {
    return this.getData(new Data64URIWriter(mimeType), options);
  }
  getUint8Array(options) {
    return this.getData(new Uint8ArrayWriter(), options);
  }
  getWritable(writable = new WritableStream(), options) {
    return this.getData({ writable }, options);
  }
  getArrayBuffer(options) {
    return this.data.arrayBuffer(options);
  }
  replaceBlob(blob) {
    Object.assign(this, {
      data: blob,
      Reader: BlobReader,
      Writer: BlobWriter,
      reader: null
    });
  }
  replaceText(text) {
    Object.assign(this, {
      data: text,
      Reader: TextReader,
      Writer: TextWriter,
      reader: null
    });
  }
  replaceData64URI(dataURI) {
    Object.assign(this, {
      data: dataURI,
      Reader: Data64URIReader,
      Writer: Data64URIWriter,
      reader: null
    });
  }
  replaceUint8Array(array) {
    Object.assign(this, {
      data: array,
      Reader: Uint8ArrayReader,
      Writer: Uint8ArrayWriter,
      reader: null
    });
  }
  replaceReadable(readable) {
    Object.assign(this, {
      data: null,
      Reader: function() {
        return { readable };
      },
      Writer: null,
      reader: null
    });
  }
};
var ZipDirectoryEntry = class _ZipDirectoryEntry extends ZipEntry2 {
  constructor(fs3, name, params, parent) {
    super(fs3, name, params, parent);
    this.directory = true;
  }
  clone(deepClone) {
    const zipEntry = this;
    const clonedEntry = new _ZipDirectoryEntry(zipEntry.fs, zipEntry.name);
    if (deepClone) {
      clonedEntry.children = zipEntry.children.map((child) => {
        const childClone = child.clone(deepClone);
        childClone.parent = clonedEntry;
        return childClone;
      });
    }
    return clonedEntry;
  }
  addDirectory(name, options) {
    return addChild(this, name, { options }, true);
  }
  addText(name, text, options = {}) {
    return addChild(this, name, {
      data: text,
      Reader: TextReader,
      Writer: TextWriter,
      options,
      uncompressedSize: text.length
    });
  }
  addBlob(name, blob, options = {}) {
    return addChild(this, name, {
      data: blob,
      Reader: BlobReader,
      Writer: BlobWriter,
      options,
      uncompressedSize: blob.size
    });
  }
  addData64URI(name, dataURI, options = {}) {
    let dataEnd = dataURI.length;
    while (dataURI.charAt(dataEnd - 1) == "=") {
      dataEnd--;
    }
    const dataStart = dataURI.indexOf(",") + 1;
    return addChild(this, name, {
      data: dataURI,
      Reader: Data64URIReader,
      Writer: Data64URIWriter,
      options,
      uncompressedSize: Math.floor((dataEnd - dataStart) * 0.75)
    });
  }
  addUint8Array(name, array, options = {}) {
    return addChild(this, name, {
      data: array,
      Reader: Uint8ArrayReader,
      Writer: Uint8ArrayWriter,
      options,
      uncompressedSize: array.length
    });
  }
  addHttpContent(name, url, options = {}) {
    return addChild(this, name, {
      data: url,
      Reader: class extends HttpReader {
        constructor(url2) {
          super(url2, options);
        }
      },
      options
    });
  }
  addReadable(name, readable, options = {}) {
    return addChild(this, name, {
      Reader: function() {
        return { readable };
      },
      options
    });
  }
  addFileSystemEntry(fileSystemEntry, options = {}) {
    return addFileSystemHandle(this, fileSystemEntry, options);
  }
  addFileSystemHandle(handle, options = {}) {
    return addFileSystemHandle(this, handle, options);
  }
  addFile(file, options = {}) {
    if (!options.lastModDate) {
      options.lastModDate = new Date(file.lastModified);
    }
    return addChild(this, file.name, {
      data: file,
      Reader: function() {
        const readable = file.stream();
        const size = file.size;
        return { readable, size };
      },
      options,
      uncompressedSize: file.size
    });
  }
  addData(name, params) {
    return addChild(this, name, params);
  }
  importBlob(blob, options) {
    return this.importZip(new BlobReader(blob), options);
  }
  importData64URI(dataURI, options) {
    return this.importZip(new Data64URIReader(dataURI), options);
  }
  importUint8Array(array, options) {
    return this.importZip(new Uint8ArrayReader(array), options);
  }
  importHttpContent(url, options) {
    return this.importZip(new HttpReader(url, options), options);
  }
  importReadable(readable, options) {
    return this.importZip({ readable }, options);
  }
  exportBlob(options = {}) {
    return this.exportZip(new BlobWriter(options.mimeType || "application/zip"), options);
  }
  exportData64URI(options = {}) {
    return this.exportZip(new Data64URIWriter(options.mimeType || "application/zip"), options);
  }
  exportUint8Array(options = {}) {
    return this.exportZip(new Uint8ArrayWriter(), options);
  }
  async exportWritable(writable = new WritableStream(), options = {}) {
    await this.exportZip({ writable }, options);
    return writable;
  }
  async importZip(reader, options = {}) {
    await initStream(reader);
    const zipReader = new ZipReader(reader, options);
    const importedEntries = [];
    const entries = await zipReader.getEntries();
    for (const entry of entries) {
      let parent = this;
      try {
        const path = entry.filename.split("/");
        const name = path.pop();
        path.forEach((pathPart, pathIndex) => {
          const previousParent = parent;
          parent = parent.getChildByName(pathPart);
          if (!parent) {
            parent = new _ZipDirectoryEntry(this.fs, pathPart, { data: pathIndex == path.length - 1 ? entry : null }, previousParent);
            importedEntries.push(parent);
          }
        });
        if (!entry.directory) {
          importedEntries.push(addChild(parent, name, {
            data: entry,
            Reader: getZipBlobReader(Object.assign({}, options)),
            uncompressedSize: entry.uncompressedSize,
            passThrough: options.passThrough
          }));
        }
      } catch (error) {
        try {
          error.cause = {
            entry
          };
        } catch {
        }
        throw error;
      }
    }
    return importedEntries;
  }
  async exportZip(writer, options) {
    const zipEntry = this;
    if (options.bufferedWrite === UNDEFINED_VALUE) {
      options.bufferedWrite = true;
    }
    await Promise.all([initReaders(zipEntry, options.readerOptions), initStream(writer)]);
    const zipWriter = new ZipWriter(writer, options);
    await exportZip(zipWriter, zipEntry, getTotalSize([zipEntry], "uncompressedSize"), options);
    await zipWriter.close();
    return writer.getData ? writer.getData() : writer.writable;
  }
  getChildByName(name) {
    const children = this.children;
    for (let childIndex = 0; childIndex < children.length; childIndex++) {
      const child = children[childIndex];
      if (child.name == name) {
        return child;
      }
    }
  }
  isPasswordProtected() {
    const children = this.children;
    for (let childIndex = 0; childIndex < children.length; childIndex++) {
      const child = children[childIndex];
      if (child.isPasswordProtected()) {
        return true;
      }
    }
    return false;
  }
  async checkPassword(password, options = {}) {
    const children = this.children;
    const result = await Promise.all(children.map((child) => child.checkPassword(password, options)));
    return !result.includes(false);
  }
};
var FS = class {
  constructor() {
    resetFS(this);
  }
  get children() {
    return this.root.children;
  }
  remove(entry) {
    detach(entry);
    this.entries[entry.id] = null;
  }
  move(entry, destination) {
    if (entry == this.root) {
      throw new Error("Root directory cannot be moved");
    } else {
      if (destination.directory) {
        if (!destination.isDescendantOf(entry)) {
          if (entry != destination) {
            if (destination.getChildByName(entry.name)) {
              throw new Error("Entry filename already exists");
            }
            detach(entry);
            entry.parent = destination;
            destination.children.push(entry);
          }
        } else {
          throw new Error("Entry is a ancestor of target entry");
        }
      } else {
        throw new Error("Target entry is not a directory");
      }
    }
  }
  find(fullname) {
    const path = fullname.split("/");
    let node = this.root;
    for (let index2 = 0; node && index2 < path.length; index2++) {
      node = node.getChildByName(path[index2]);
    }
    return node;
  }
  getById(id) {
    return this.entries[id];
  }
  getChildByName(name) {
    return this.root.getChildByName(name);
  }
  addDirectory(name, options) {
    return this.root.addDirectory(name, options);
  }
  addText(name, text, options) {
    return this.root.addText(name, text, options);
  }
  addBlob(name, blob, options) {
    return this.root.addBlob(name, blob, options);
  }
  addData64URI(name, dataURI, options) {
    return this.root.addData64URI(name, dataURI, options);
  }
  addUint8Array(name, array, options) {
    return this.root.addUint8Array(name, array, options);
  }
  addHttpContent(name, url, options) {
    return this.root.addHttpContent(name, url, options);
  }
  addReadable(name, readable, options) {
    return this.root.addReadable(name, readable, options);
  }
  addFileSystemEntry(fileSystemEntry, options) {
    return this.root.addFileSystemEntry(fileSystemEntry, options);
  }
  addFileSystemHandle(handle, options) {
    return this.root.addFileSystemHandle(handle, options);
  }
  addFile(file, options) {
    return this.root.addFile(file, options);
  }
  addData(name, params) {
    return this.root.addData(name, params);
  }
  importBlob(blob, options) {
    resetFS(this);
    return this.root.importBlob(blob, options);
  }
  importData64URI(dataURI, options) {
    resetFS(this);
    return this.root.importData64URI(dataURI, options);
  }
  importUint8Array(array, options) {
    resetFS(this);
    return this.root.importUint8Array(array, options);
  }
  importHttpContent(url, options) {
    resetFS(this);
    return this.root.importHttpContent(url, options);
  }
  importReadable(readable, options) {
    resetFS(this);
    return this.root.importReadable(readable, options);
  }
  importZip(reader, options) {
    return this.root.importZip(reader, options);
  }
  exportBlob(options) {
    return this.root.exportBlob(options);
  }
  exportData64URI(options) {
    return this.root.exportData64URI(options);
  }
  exportUint8Array(options) {
    return this.root.exportUint8Array(options);
  }
  exportWritable(writable, options) {
    return this.root.exportWritable(writable, options);
  }
  isPasswordProtected() {
    return this.root.isPasswordProtected();
  }
  checkPassword(password, options) {
    return this.root.checkPassword(password, options);
  }
};
var fs = { FS, ZipDirectoryEntry, ZipFileEntry };
function getTotalSize(entries, propertyName) {
  let size = 0;
  entries.forEach(process);
  return size;
  function process(entry) {
    size += entry[propertyName];
    if (entry.children) {
      entry.children.forEach(process);
    }
  }
}
function getZipBlobReader(options) {
  return class extends Reader {
    constructor(entry, options2 = {}) {
      super();
      this.entry = entry;
      this.options = options2;
    }
    async init() {
      const zipBlobReader = this;
      zipBlobReader.size = zipBlobReader.entry.uncompressedSize;
      const data = await zipBlobReader.entry.getData(new BlobWriter(), Object.assign({}, zipBlobReader.options, options));
      zipBlobReader.data = data;
      zipBlobReader.blobReader = new BlobReader(data);
      super.init();
    }
    readUint8Array(index2, length) {
      return this.blobReader.readUint8Array(index2, length);
    }
  };
}
async function initReaders(entry, options) {
  if (entry.children.length) {
    await Promise.all(entry.children.map(async (child) => {
      if (child.directory) {
        await initReaders(child, options);
      } else {
        const reader = child.reader = new child.Reader(child.data, options);
        try {
          await initStream(reader);
        } catch (error) {
          try {
            error.entryId = child.id;
            error.cause = {
              entry: child
            };
          } catch {
          }
          throw error;
        }
        child.uncompressedSize = reader.size;
      }
    }));
  }
}
function detach(entry) {
  if (entry.parent) {
    const children = entry.parent.children;
    children.forEach((child, index2) => {
      if (child.id == entry.id) {
        children.splice(index2, 1);
      }
    });
  }
}
async function exportZip(zipWriter, entry, totalSize, options) {
  const selectedEntry = entry;
  const entryOffsets = /* @__PURE__ */ new Map();
  await process(zipWriter, entry);
  async function process(zipWriter2, entry2) {
    await exportChild();
    async function exportChild() {
      if (options.bufferedWrite) {
        await Promise.allSettled(entry2.children.map(processChild));
      } else {
        for (const child of entry2.children) {
          await processChild(child);
        }
      }
    }
    async function processChild(child) {
      const name = options.relativePath ? child.getRelativeName(selectedEntry) : child.getFullname();
      const childOptions = child.options || {};
      let zipEntryOptions = {};
      if (child.data instanceof Entry) {
        const {
          externalFileAttributes,
          versionMadeBy,
          comment,
          lastModDate,
          creationDate,
          lastAccessDate,
          uncompressedSize,
          encrypted,
          zipCrypto,
          signature,
          compressionMethod,
          extraFieldAES
        } = child.data;
        zipEntryOptions = {
          externalFileAttributes,
          versionMadeBy,
          comment,
          lastModDate,
          creationDate,
          lastAccessDate
        };
        if (child.passThrough) {
          let level, encryptionStrength;
          if (compressionMethod === 0) {
            level = 0;
          }
          if (extraFieldAES) {
            encryptionStrength = extraFieldAES.strength;
          }
          zipEntryOptions = Object.assign(zipEntryOptions, {
            passThrough: true,
            encrypted,
            zipCrypto,
            signature,
            uncompressedSize,
            level,
            encryptionStrength,
            compressionMethod
          });
        }
      }
      await zipWriter2.add(name, child.reader, Object.assign({}, options, zipEntryOptions, childOptions, {
        directory: child.directory,
        onprogress: async (indexProgress) => {
          if (options.onprogress) {
            entryOffsets.set(name, indexProgress);
            try {
              await options.onprogress(Array.from(entryOffsets.values()).reduce((previousValue, currentValue) => previousValue + currentValue), totalSize);
            } catch {
            }
          }
        }
      }));
      await process(zipWriter2, child);
    }
  }
}
function addFileSystemHandle(zipEntry, handle, options) {
  return addFile2(zipEntry, handle, []);
  async function addFile2(parentEntry, handle2, addedEntries) {
    if (handle2) {
      try {
        if (handle2.isFile || handle2.isDirectory) {
          handle2 = await transformToFileSystemhandle(handle2);
        }
        if (handle2.kind == "file") {
          const file = await handle2.getFile();
          addedEntries.push(
            parentEntry.addData(file.name, {
              Reader: function() {
                const readable = file.stream();
                const size = file.size;
                return { readable, size };
              },
              options: Object.assign({}, { lastModDate: new Date(file.lastModified) }, options),
              uncompressedSize: file.size
            })
          );
        } else if (handle2.kind == "directory") {
          const directoryEntry = parentEntry.addDirectory(handle2.name);
          addedEntries.push(directoryEntry);
          for await (const childHandle of handle2.values()) {
            await addFile2(directoryEntry, childHandle, addedEntries);
          }
        }
      } catch (error) {
        const message = error.message + (handle2 ? " (" + handle2.name + ")" : "");
        throw new Error(message);
      }
    }
    return addedEntries;
  }
}
async function transformToFileSystemhandle(entry) {
  const handle = {
    name: entry.name
  };
  if (entry.isFile) {
    handle.kind = "file";
    handle.getFile = () => new Promise((resolve, reject) => entry.file(resolve, reject));
  }
  if (entry.isDirectory) {
    handle.kind = "directory";
    const handles = await transformToFileSystemhandles(entry);
    handle.values = () => handles;
  }
  return handle;
}
async function transformToFileSystemhandles(entry) {
  const entries = [];
  function readEntries(directoryReader, resolve, reject) {
    directoryReader.readEntries(async (entriesPart) => {
      if (!entriesPart.length) {
        resolve(entries);
      } else {
        for (const entry2 of entriesPart) {
          entries.push(await transformToFileSystemhandle(entry2));
        }
        readEntries(directoryReader, resolve, reject);
      }
    }, reject);
  }
  await new Promise(
    (resolve, reject) => readEntries(entry.createReader(), resolve, reject)
  );
  return {
    [Symbol.iterator]() {
      let entryIndex = 0;
      return {
        next() {
          const result = {
            value: entries[entryIndex],
            done: entryIndex == entries.length
          };
          entryIndex++;
          return result;
        }
      };
    }
  };
}
function resetFS(fs3) {
  fs3.entries = [];
  fs3.root = new ZipDirectoryEntry(fs3);
}
function addChild(parent, name, params, directory) {
  if (parent.directory) {
    return directory ? new ZipDirectoryEntry(parent.fs, name, params, parent) : new ZipFileEntry(parent.fs, name, params, parent);
  } else {
    throw new Error("Parent entry is not a directory");
  }
}

// node_modules/@zip.js/zip.js/lib/core/util/mime-type.js
var table2 = {
  "application": {
    "andrew-inset": "ez",
    "annodex": "anx",
    "atom+xml": "atom",
    "atomcat+xml": "atomcat",
    "atomserv+xml": "atomsrv",
    "bbolin": "lin",
    "cu-seeme": "cu",
    "davmount+xml": "davmount",
    "dsptype": "tsp",
    "ecmascript": [
      "es",
      "ecma"
    ],
    "futuresplash": "spl",
    "hta": "hta",
    "java-archive": "jar",
    "java-serialized-object": "ser",
    "java-vm": "class",
    "m3g": "m3g",
    "mac-binhex40": "hqx",
    "mathematica": [
      "nb",
      "ma",
      "mb"
    ],
    "msaccess": "mdb",
    "msword": [
      "doc",
      "dot",
      "wiz"
    ],
    "mxf": "mxf",
    "oda": "oda",
    "ogg": "ogx",
    "pdf": "pdf",
    "pgp-keys": "key",
    "pgp-signature": [
      "asc",
      "sig"
    ],
    "pics-rules": "prf",
    "postscript": [
      "ps",
      "ai",
      "eps",
      "epsi",
      "epsf",
      "eps2",
      "eps3"
    ],
    "rar": "rar",
    "rdf+xml": "rdf",
    "rss+xml": "rss",
    "rtf": "rtf",
    "xhtml+xml": [
      "xhtml",
      "xht"
    ],
    "xml": [
      "xml",
      "xsl",
      "xsd",
      "xpdl"
    ],
    "xspf+xml": "xspf",
    "zip": "zip",
    "vnd.android.package-archive": "apk",
    "vnd.cinderella": "cdy",
    "vnd.google-earth.kml+xml": "kml",
    "vnd.google-earth.kmz": "kmz",
    "vnd.mozilla.xul+xml": "xul",
    "vnd.ms-excel": [
      "xls",
      "xlb",
      "xlt",
      "xlm",
      "xla",
      "xlc",
      "xlw"
    ],
    "vnd.ms-pki.seccat": "cat",
    "vnd.ms-pki.stl": "stl",
    "vnd.ms-powerpoint": [
      "ppt",
      "pps",
      "pot",
      "ppa",
      "pwz"
    ],
    "vnd.oasis.opendocument.chart": "odc",
    "vnd.oasis.opendocument.database": "odb",
    "vnd.oasis.opendocument.formula": "odf",
    "vnd.oasis.opendocument.graphics": "odg",
    "vnd.oasis.opendocument.graphics-template": "otg",
    "vnd.oasis.opendocument.image": "odi",
    "vnd.oasis.opendocument.presentation": "odp",
    "vnd.oasis.opendocument.presentation-template": "otp",
    "vnd.oasis.opendocument.spreadsheet": "ods",
    "vnd.oasis.opendocument.spreadsheet-template": "ots",
    "vnd.oasis.opendocument.text": "odt",
    "vnd.oasis.opendocument.text-master": [
      "odm",
      "otm"
    ],
    "vnd.oasis.opendocument.text-template": "ott",
    "vnd.oasis.opendocument.text-web": "oth",
    "vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
    "vnd.openxmlformats-officedocument.spreadsheetml.template": "xltx",
    "vnd.openxmlformats-officedocument.presentationml.presentation": "pptx",
    "vnd.openxmlformats-officedocument.presentationml.slideshow": "ppsx",
    "vnd.openxmlformats-officedocument.presentationml.template": "potx",
    "vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
    "vnd.openxmlformats-officedocument.wordprocessingml.template": "dotx",
    "vnd.smaf": "mmf",
    "vnd.stardivision.calc": "sdc",
    "vnd.stardivision.chart": "sds",
    "vnd.stardivision.draw": "sda",
    "vnd.stardivision.impress": "sdd",
    "vnd.stardivision.math": [
      "sdf",
      "smf"
    ],
    "vnd.stardivision.writer": [
      "sdw",
      "vor"
    ],
    "vnd.stardivision.writer-global": "sgl",
    "vnd.sun.xml.calc": "sxc",
    "vnd.sun.xml.calc.template": "stc",
    "vnd.sun.xml.draw": "sxd",
    "vnd.sun.xml.draw.template": "std",
    "vnd.sun.xml.impress": "sxi",
    "vnd.sun.xml.impress.template": "sti",
    "vnd.sun.xml.math": "sxm",
    "vnd.sun.xml.writer": "sxw",
    "vnd.sun.xml.writer.global": "sxg",
    "vnd.sun.xml.writer.template": "stw",
    "vnd.symbian.install": [
      "sis",
      "sisx"
    ],
    "vnd.visio": [
      "vsd",
      "vst",
      "vss",
      "vsw",
      "vsdx",
      "vssx",
      "vstx",
      "vssm",
      "vstm"
    ],
    "vnd.wap.wbxml": "wbxml",
    "vnd.wap.wmlc": "wmlc",
    "vnd.wap.wmlscriptc": "wmlsc",
    "vnd.wordperfect": "wpd",
    "vnd.wordperfect5.1": "wp5",
    "x-123": "wk",
    "x-7z-compressed": "7z",
    "x-abiword": "abw",
    "x-apple-diskimage": "dmg",
    "x-bcpio": "bcpio",
    "x-bittorrent": "torrent",
    "x-cbr": [
      "cbr",
      "cba",
      "cbt",
      "cb7"
    ],
    "x-cbz": "cbz",
    "x-cdf": [
      "cdf",
      "cda"
    ],
    "x-cdlink": "vcd",
    "x-chess-pgn": "pgn",
    "x-cpio": "cpio",
    "x-csh": "csh",
    "x-director": [
      "dir",
      "dxr",
      "cst",
      "cct",
      "cxt",
      "w3d",
      "fgd",
      "swa"
    ],
    "x-dms": "dms",
    "x-doom": "wad",
    "x-dvi": "dvi",
    "x-httpd-eruby": "rhtml",
    "x-font": "pcf.Z",
    "x-freemind": "mm",
    "x-gnumeric": "gnumeric",
    "x-go-sgf": "sgf",
    "x-graphing-calculator": "gcf",
    "x-gtar": [
      "gtar",
      "taz"
    ],
    "x-hdf": "hdf",
    "x-httpd-php": [
      "phtml",
      "pht",
      "php"
    ],
    "x-httpd-php-source": "phps",
    "x-httpd-php3": "php3",
    "x-httpd-php3-preprocessed": "php3p",
    "x-httpd-php4": "php4",
    "x-httpd-php5": "php5",
    "x-ica": "ica",
    "x-info": "info",
    "x-internet-signup": [
      "ins",
      "isp"
    ],
    "x-iphone": "iii",
    "x-iso9660-image": "iso",
    "x-java-jnlp-file": "jnlp",
    "x-jmol": "jmz",
    "x-killustrator": "kil",
    "x-latex": "latex",
    "x-lyx": "lyx",
    "x-lzx": "lzx",
    "x-maker": [
      "frm",
      "fb",
      "fbdoc"
    ],
    "x-ms-wmd": "wmd",
    "x-msdos-program": [
      "com",
      "exe",
      "bat",
      "dll"
    ],
    "x-netcdf": [
      "nc"
    ],
    "x-ns-proxy-autoconfig": [
      "pac",
      "dat"
    ],
    "x-nwc": "nwc",
    "x-object": "o",
    "x-oz-application": "oza",
    "x-pkcs7-certreqresp": "p7r",
    "x-python-code": [
      "pyc",
      "pyo"
    ],
    "x-qgis": [
      "qgs",
      "shp",
      "shx"
    ],
    "x-quicktimeplayer": "qtl",
    "x-redhat-package-manager": [
      "rpm",
      "rpa"
    ],
    "x-ruby": "rb",
    "x-sh": "sh",
    "x-shar": "shar",
    "x-shockwave-flash": [
      "swf",
      "swfl"
    ],
    "x-silverlight": "scr",
    "x-stuffit": "sit",
    "x-sv4cpio": "sv4cpio",
    "x-sv4crc": "sv4crc",
    "x-tar": "tar",
    "x-tex-gf": "gf",
    "x-tex-pk": "pk",
    "x-texinfo": [
      "texinfo",
      "texi"
    ],
    "x-trash": [
      "~",
      "%",
      "bak",
      "old",
      "sik"
    ],
    "x-ustar": "ustar",
    "x-wais-source": "src",
    "x-wingz": "wz",
    "x-x509-ca-cert": [
      "crt",
      "der",
      "cer"
    ],
    "x-xcf": "xcf",
    "x-xfig": "fig",
    "x-xpinstall": "xpi",
    "applixware": "aw",
    "atomsvc+xml": "atomsvc",
    "ccxml+xml": "ccxml",
    "cdmi-capability": "cdmia",
    "cdmi-container": "cdmic",
    "cdmi-domain": "cdmid",
    "cdmi-object": "cdmio",
    "cdmi-queue": "cdmiq",
    "docbook+xml": "dbk",
    "dssc+der": "dssc",
    "dssc+xml": "xdssc",
    "emma+xml": "emma",
    "epub+zip": "epub",
    "exi": "exi",
    "font-tdpfr": "pfr",
    "gml+xml": "gml",
    "gpx+xml": "gpx",
    "gxf": "gxf",
    "hyperstudio": "stk",
    "inkml+xml": [
      "ink",
      "inkml"
    ],
    "ipfix": "ipfix",
    "jsonml+json": "jsonml",
    "lost+xml": "lostxml",
    "mads+xml": "mads",
    "marc": "mrc",
    "marcxml+xml": "mrcx",
    "mathml+xml": [
      "mathml",
      "mml"
    ],
    "mbox": "mbox",
    "mediaservercontrol+xml": "mscml",
    "metalink+xml": "metalink",
    "metalink4+xml": "meta4",
    "mets+xml": "mets",
    "mods+xml": "mods",
    "mp21": [
      "m21",
      "mp21"
    ],
    "mp4": "mp4s",
    "oebps-package+xml": "opf",
    "omdoc+xml": "omdoc",
    "onenote": [
      "onetoc",
      "onetoc2",
      "onetmp",
      "onepkg"
    ],
    "oxps": "oxps",
    "patch-ops-error+xml": "xer",
    "pgp-encrypted": "pgp",
    "pkcs10": "p10",
    "pkcs7-mime": [
      "p7m",
      "p7c"
    ],
    "pkcs7-signature": "p7s",
    "pkcs8": "p8",
    "pkix-attr-cert": "ac",
    "pkix-crl": "crl",
    "pkix-pkipath": "pkipath",
    "pkixcmp": "pki",
    "pls+xml": "pls",
    "prs.cww": "cww",
    "pskc+xml": "pskcxml",
    "reginfo+xml": "rif",
    "relax-ng-compact-syntax": "rnc",
    "resource-lists+xml": "rl",
    "resource-lists-diff+xml": "rld",
    "rls-services+xml": "rs",
    "rpki-ghostbusters": "gbr",
    "rpki-manifest": "mft",
    "rpki-roa": "roa",
    "rsd+xml": "rsd",
    "sbml+xml": "sbml",
    "scvp-cv-request": "scq",
    "scvp-cv-response": "scs",
    "scvp-vp-request": "spq",
    "scvp-vp-response": "spp",
    "sdp": "sdp",
    "set-payment-initiation": "setpay",
    "set-registration-initiation": "setreg",
    "shf+xml": "shf",
    "sparql-query": "rq",
    "sparql-results+xml": "srx",
    "srgs": "gram",
    "srgs+xml": "grxml",
    "sru+xml": "sru",
    "ssdl+xml": "ssdl",
    "ssml+xml": "ssml",
    "tei+xml": [
      "tei",
      "teicorpus"
    ],
    "thraud+xml": "tfi",
    "timestamped-data": "tsd",
    "vnd.3gpp.pic-bw-large": "plb",
    "vnd.3gpp.pic-bw-small": "psb",
    "vnd.3gpp.pic-bw-var": "pvb",
    "vnd.3gpp2.tcap": "tcap",
    "vnd.3m.post-it-notes": "pwn",
    "vnd.accpac.simply.aso": "aso",
    "vnd.accpac.simply.imp": "imp",
    "vnd.acucobol": "acu",
    "vnd.acucorp": [
      "atc",
      "acutc"
    ],
    "vnd.adobe.air-application-installer-package+zip": "air",
    "vnd.adobe.formscentral.fcdt": "fcdt",
    "vnd.adobe.fxp": [
      "fxp",
      "fxpl"
    ],
    "vnd.adobe.xdp+xml": "xdp",
    "vnd.adobe.xfdf": "xfdf",
    "vnd.ahead.space": "ahead",
    "vnd.airzip.filesecure.azf": "azf",
    "vnd.airzip.filesecure.azs": "azs",
    "vnd.amazon.ebook": "azw",
    "vnd.americandynamics.acc": "acc",
    "vnd.amiga.ami": "ami",
    "vnd.anser-web-certificate-issue-initiation": "cii",
    "vnd.anser-web-funds-transfer-initiation": "fti",
    "vnd.antix.game-component": "atx",
    "vnd.apple.installer+xml": "mpkg",
    "vnd.apple.mpegurl": "m3u8",
    "vnd.aristanetworks.swi": "swi",
    "vnd.astraea-software.iota": "iota",
    "vnd.audiograph": "aep",
    "vnd.blueice.multipass": "mpm",
    "vnd.bmi": "bmi",
    "vnd.businessobjects": "rep",
    "vnd.chemdraw+xml": "cdxml",
    "vnd.chipnuts.karaoke-mmd": "mmd",
    "vnd.claymore": "cla",
    "vnd.cloanto.rp9": "rp9",
    "vnd.clonk.c4group": [
      "c4g",
      "c4d",
      "c4f",
      "c4p",
      "c4u"
    ],
    "vnd.cluetrust.cartomobile-config": "c11amc",
    "vnd.cluetrust.cartomobile-config-pkg": "c11amz",
    "vnd.commonspace": "csp",
    "vnd.contact.cmsg": "cdbcmsg",
    "vnd.cosmocaller": "cmc",
    "vnd.crick.clicker": "clkx",
    "vnd.crick.clicker.keyboard": "clkk",
    "vnd.crick.clicker.palette": "clkp",
    "vnd.crick.clicker.template": "clkt",
    "vnd.crick.clicker.wordbank": "clkw",
    "vnd.criticaltools.wbs+xml": "wbs",
    "vnd.ctc-posml": "pml",
    "vnd.cups-ppd": "ppd",
    "vnd.curl.car": "car",
    "vnd.curl.pcurl": "pcurl",
    "vnd.dart": "dart",
    "vnd.data-vision.rdz": "rdz",
    "vnd.dece.data": [
      "uvf",
      "uvvf",
      "uvd",
      "uvvd"
    ],
    "vnd.dece.ttml+xml": [
      "uvt",
      "uvvt"
    ],
    "vnd.dece.unspecified": [
      "uvx",
      "uvvx"
    ],
    "vnd.dece.zip": [
      "uvz",
      "uvvz"
    ],
    "vnd.denovo.fcselayout-link": "fe_launch",
    "vnd.dna": "dna",
    "vnd.dolby.mlp": "mlp",
    "vnd.dpgraph": "dpg",
    "vnd.dreamfactory": "dfac",
    "vnd.ds-keypoint": "kpxx",
    "vnd.dvb.ait": "ait",
    "vnd.dvb.service": "svc",
    "vnd.dynageo": "geo",
    "vnd.ecowin.chart": "mag",
    "vnd.enliven": "nml",
    "vnd.epson.esf": "esf",
    "vnd.epson.msf": "msf",
    "vnd.epson.quickanime": "qam",
    "vnd.epson.salt": "slt",
    "vnd.epson.ssf": "ssf",
    "vnd.eszigno3+xml": [
      "es3",
      "et3"
    ],
    "vnd.ezpix-album": "ez2",
    "vnd.ezpix-package": "ez3",
    "vnd.fdf": "fdf",
    "vnd.fdsn.mseed": "mseed",
    "vnd.fdsn.seed": [
      "seed",
      "dataless"
    ],
    "vnd.flographit": "gph",
    "vnd.fluxtime.clip": "ftc",
    "vnd.framemaker": [
      "fm",
      "frame",
      "maker",
      "book"
    ],
    "vnd.frogans.fnc": "fnc",
    "vnd.frogans.ltf": "ltf",
    "vnd.fsc.weblaunch": "fsc",
    "vnd.fujitsu.oasys": "oas",
    "vnd.fujitsu.oasys2": "oa2",
    "vnd.fujitsu.oasys3": "oa3",
    "vnd.fujitsu.oasysgp": "fg5",
    "vnd.fujitsu.oasysprs": "bh2",
    "vnd.fujixerox.ddd": "ddd",
    "vnd.fujixerox.docuworks": "xdw",
    "vnd.fujixerox.docuworks.binder": "xbd",
    "vnd.fuzzysheet": "fzs",
    "vnd.genomatix.tuxedo": "txd",
    "vnd.geogebra.file": "ggb",
    "vnd.geogebra.tool": "ggt",
    "vnd.geometry-explorer": [
      "gex",
      "gre"
    ],
    "vnd.geonext": "gxt",
    "vnd.geoplan": "g2w",
    "vnd.geospace": "g3w",
    "vnd.gmx": "gmx",
    "vnd.grafeq": [
      "gqf",
      "gqs"
    ],
    "vnd.groove-account": "gac",
    "vnd.groove-help": "ghf",
    "vnd.groove-identity-message": "gim",
    "vnd.groove-injector": "grv",
    "vnd.groove-tool-message": "gtm",
    "vnd.groove-tool-template": "tpl",
    "vnd.groove-vcard": "vcg",
    "vnd.hal+xml": "hal",
    "vnd.handheld-entertainment+xml": "zmm",
    "vnd.hbci": "hbci",
    "vnd.hhe.lesson-player": "les",
    "vnd.hp-hpgl": "hpgl",
    "vnd.hp-hpid": "hpid",
    "vnd.hp-hps": "hps",
    "vnd.hp-jlyt": "jlt",
    "vnd.hp-pcl": "pcl",
    "vnd.hp-pclxl": "pclxl",
    "vnd.hydrostatix.sof-data": "sfd-hdstx",
    "vnd.ibm.minipay": "mpy",
    "vnd.ibm.modcap": [
      "afp",
      "listafp",
      "list3820"
    ],
    "vnd.ibm.rights-management": "irm",
    "vnd.ibm.secure-container": "sc",
    "vnd.iccprofile": [
      "icc",
      "icm"
    ],
    "vnd.igloader": "igl",
    "vnd.immervision-ivp": "ivp",
    "vnd.immervision-ivu": "ivu",
    "vnd.insors.igm": "igm",
    "vnd.intercon.formnet": [
      "xpw",
      "xpx"
    ],
    "vnd.intergeo": "i2g",
    "vnd.intu.qbo": "qbo",
    "vnd.intu.qfx": "qfx",
    "vnd.ipunplugged.rcprofile": "rcprofile",
    "vnd.irepository.package+xml": "irp",
    "vnd.is-xpr": "xpr",
    "vnd.isac.fcs": "fcs",
    "vnd.jam": "jam",
    "vnd.jcp.javame.midlet-rms": "rms",
    "vnd.jisp": "jisp",
    "vnd.joost.joda-archive": "joda",
    "vnd.kahootz": [
      "ktz",
      "ktr"
    ],
    "vnd.kde.karbon": "karbon",
    "vnd.kde.kchart": "chrt",
    "vnd.kde.kformula": "kfo",
    "vnd.kde.kivio": "flw",
    "vnd.kde.kontour": "kon",
    "vnd.kde.kpresenter": [
      "kpr",
      "kpt"
    ],
    "vnd.kde.kspread": "ksp",
    "vnd.kde.kword": [
      "kwd",
      "kwt"
    ],
    "vnd.kenameaapp": "htke",
    "vnd.kidspiration": "kia",
    "vnd.kinar": [
      "kne",
      "knp"
    ],
    "vnd.koan": [
      "skp",
      "skd",
      "skt",
      "skm"
    ],
    "vnd.kodak-descriptor": "sse",
    "vnd.las.las+xml": "lasxml",
    "vnd.llamagraphics.life-balance.desktop": "lbd",
    "vnd.llamagraphics.life-balance.exchange+xml": "lbe",
    "vnd.lotus-1-2-3": "123",
    "vnd.lotus-approach": "apr",
    "vnd.lotus-freelance": "pre",
    "vnd.lotus-notes": "nsf",
    "vnd.lotus-organizer": "org",
    "vnd.lotus-screencam": "scm",
    "vnd.lotus-wordpro": "lwp",
    "vnd.macports.portpkg": "portpkg",
    "vnd.mcd": "mcd",
    "vnd.medcalcdata": "mc1",
    "vnd.mediastation.cdkey": "cdkey",
    "vnd.mfer": "mwf",
    "vnd.mfmp": "mfm",
    "vnd.micrografx.flo": "flo",
    "vnd.micrografx.igx": "igx",
    "vnd.mif": "mif",
    "vnd.mobius.daf": "daf",
    "vnd.mobius.dis": "dis",
    "vnd.mobius.mbk": "mbk",
    "vnd.mobius.mqy": "mqy",
    "vnd.mobius.msl": "msl",
    "vnd.mobius.plc": "plc",
    "vnd.mobius.txf": "txf",
    "vnd.mophun.application": "mpn",
    "vnd.mophun.certificate": "mpc",
    "vnd.ms-artgalry": "cil",
    "vnd.ms-cab-compressed": "cab",
    "vnd.ms-excel.addin.macroenabled.12": "xlam",
    "vnd.ms-excel.sheet.binary.macroenabled.12": "xlsb",
    "vnd.ms-excel.sheet.macroenabled.12": "xlsm",
    "vnd.ms-excel.template.macroenabled.12": "xltm",
    "vnd.ms-fontobject": "eot",
    "vnd.ms-htmlhelp": "chm",
    "vnd.ms-ims": "ims",
    "vnd.ms-lrm": "lrm",
    "vnd.ms-officetheme": "thmx",
    "vnd.ms-powerpoint.addin.macroenabled.12": "ppam",
    "vnd.ms-powerpoint.presentation.macroenabled.12": "pptm",
    "vnd.ms-powerpoint.slide.macroenabled.12": "sldm",
    "vnd.ms-powerpoint.slideshow.macroenabled.12": "ppsm",
    "vnd.ms-powerpoint.template.macroenabled.12": "potm",
    "vnd.ms-project": [
      "mpp",
      "mpt"
    ],
    "vnd.ms-word.document.macroenabled.12": "docm",
    "vnd.ms-word.template.macroenabled.12": "dotm",
    "vnd.ms-works": [
      "wps",
      "wks",
      "wcm",
      "wdb"
    ],
    "vnd.ms-wpl": "wpl",
    "vnd.ms-xpsdocument": "xps",
    "vnd.mseq": "mseq",
    "vnd.musician": "mus",
    "vnd.muvee.style": "msty",
    "vnd.mynfc": "taglet",
    "vnd.neurolanguage.nlu": "nlu",
    "vnd.nitf": [
      "ntf",
      "nitf"
    ],
    "vnd.noblenet-directory": "nnd",
    "vnd.noblenet-sealer": "nns",
    "vnd.noblenet-web": "nnw",
    "vnd.nokia.n-gage.data": "ngdat",
    "vnd.nokia.n-gage.symbian.install": "n-gage",
    "vnd.nokia.radio-preset": "rpst",
    "vnd.nokia.radio-presets": "rpss",
    "vnd.novadigm.edm": "edm",
    "vnd.novadigm.edx": "edx",
    "vnd.novadigm.ext": "ext",
    "vnd.oasis.opendocument.chart-template": "otc",
    "vnd.oasis.opendocument.formula-template": "odft",
    "vnd.oasis.opendocument.image-template": "oti",
    "vnd.olpc-sugar": "xo",
    "vnd.oma.dd2+xml": "dd2",
    "vnd.openofficeorg.extension": "oxt",
    "vnd.openxmlformats-officedocument.presentationml.slide": "sldx",
    "vnd.osgeo.mapguide.package": "mgp",
    "vnd.osgi.dp": "dp",
    "vnd.osgi.subsystem": "esa",
    "vnd.palm": [
      "pdb",
      "pqa",
      "oprc"
    ],
    "vnd.pawaafile": "paw",
    "vnd.pg.format": "str",
    "vnd.pg.osasli": "ei6",
    "vnd.picsel": "efif",
    "vnd.pmi.widget": "wg",
    "vnd.pocketlearn": "plf",
    "vnd.powerbuilder6": "pbd",
    "vnd.previewsystems.box": "box",
    "vnd.proteus.magazine": "mgz",
    "vnd.publishare-delta-tree": "qps",
    "vnd.pvi.ptid1": "ptid",
    "vnd.quark.quarkxpress": [
      "qxd",
      "qxt",
      "qwd",
      "qwt",
      "qxl",
      "qxb"
    ],
    "vnd.realvnc.bed": "bed",
    "vnd.recordare.musicxml": "mxl",
    "vnd.recordare.musicxml+xml": "musicxml",
    "vnd.rig.cryptonote": "cryptonote",
    "vnd.rn-realmedia": "rm",
    "vnd.rn-realmedia-vbr": "rmvb",
    "vnd.route66.link66+xml": "link66",
    "vnd.sailingtracker.track": "st",
    "vnd.seemail": "see",
    "vnd.sema": "sema",
    "vnd.semd": "semd",
    "vnd.semf": "semf",
    "vnd.shana.informed.formdata": "ifm",
    "vnd.shana.informed.formtemplate": "itp",
    "vnd.shana.informed.interchange": "iif",
    "vnd.shana.informed.package": "ipk",
    "vnd.simtech-mindmapper": [
      "twd",
      "twds"
    ],
    "vnd.smart.teacher": "teacher",
    "vnd.solent.sdkm+xml": [
      "sdkm",
      "sdkd"
    ],
    "vnd.spotfire.dxp": "dxp",
    "vnd.spotfire.sfs": "sfs",
    "vnd.stepmania.package": "smzip",
    "vnd.stepmania.stepchart": "sm",
    "vnd.sus-calendar": [
      "sus",
      "susp"
    ],
    "vnd.svd": "svd",
    "vnd.syncml+xml": "xsm",
    "vnd.syncml.dm+wbxml": "bdm",
    "vnd.syncml.dm+xml": "xdm",
    "vnd.tao.intent-module-archive": "tao",
    "vnd.tcpdump.pcap": [
      "pcap",
      "cap",
      "dmp"
    ],
    "vnd.tmobile-livetv": "tmo",
    "vnd.trid.tpt": "tpt",
    "vnd.triscape.mxs": "mxs",
    "vnd.trueapp": "tra",
    "vnd.ufdl": [
      "ufd",
      "ufdl"
    ],
    "vnd.uiq.theme": "utz",
    "vnd.umajin": "umj",
    "vnd.unity": "unityweb",
    "vnd.uoml+xml": "uoml",
    "vnd.vcx": "vcx",
    "vnd.visionary": "vis",
    "vnd.vsf": "vsf",
    "vnd.webturbo": "wtb",
    "vnd.wolfram.player": "nbp",
    "vnd.wqd": "wqd",
    "vnd.wt.stf": "stf",
    "vnd.xara": "xar",
    "vnd.xfdl": "xfdl",
    "vnd.yamaha.hv-dic": "hvd",
    "vnd.yamaha.hv-script": "hvs",
    "vnd.yamaha.hv-voice": "hvp",
    "vnd.yamaha.openscoreformat": "osf",
    "vnd.yamaha.openscoreformat.osfpvg+xml": "osfpvg",
    "vnd.yamaha.smaf-audio": "saf",
    "vnd.yamaha.smaf-phrase": "spf",
    "vnd.yellowriver-custom-menu": "cmp",
    "vnd.zul": [
      "zir",
      "zirz"
    ],
    "vnd.zzazz.deck+xml": "zaz",
    "voicexml+xml": "vxml",
    "widget": "wgt",
    "winhlp": "hlp",
    "wsdl+xml": "wsdl",
    "wspolicy+xml": "wspolicy",
    "x-ace-compressed": "ace",
    "x-authorware-bin": [
      "aab",
      "x32",
      "u32",
      "vox"
    ],
    "x-authorware-map": "aam",
    "x-authorware-seg": "aas",
    "x-blorb": [
      "blb",
      "blorb"
    ],
    "x-bzip": "bz",
    "x-bzip2": [
      "bz2",
      "boz"
    ],
    "x-cfs-compressed": "cfs",
    "x-chat": "chat",
    "x-conference": "nsc",
    "x-dgc-compressed": "dgc",
    "x-dtbncx+xml": "ncx",
    "x-dtbook+xml": "dtb",
    "x-dtbresource+xml": "res",
    "x-eva": "eva",
    "x-font-bdf": "bdf",
    "x-font-ghostscript": "gsf",
    "x-font-linux-psf": "psf",
    "x-font-pcf": "pcf",
    "x-font-snf": "snf",
    "x-font-ttf": [
      "ttf",
      "ttc"
    ],
    "x-font-type1": [
      "pfa",
      "pfb",
      "pfm",
      "afm"
    ],
    "x-freearc": "arc",
    "x-gca-compressed": "gca",
    "x-glulx": "ulx",
    "x-gramps-xml": "gramps",
    "x-install-instructions": "install",
    "x-lzh-compressed": [
      "lzh",
      "lha"
    ],
    "x-mie": "mie",
    "x-mobipocket-ebook": [
      "prc",
      "mobi"
    ],
    "x-ms-application": "application",
    "x-ms-shortcut": "lnk",
    "x-ms-xbap": "xbap",
    "x-msbinder": "obd",
    "x-mscardfile": "crd",
    "x-msclip": "clp",
    "application/x-ms-installer": "msi",
    "x-msmediaview": [
      "mvb",
      "m13",
      "m14"
    ],
    "x-msmetafile": [
      "wmf",
      "wmz",
      "emf",
      "emz"
    ],
    "x-msmoney": "mny",
    "x-mspublisher": "pub",
    "x-msschedule": "scd",
    "x-msterminal": "trm",
    "x-mswrite": "wri",
    "x-nzb": "nzb",
    "x-pkcs12": [
      "p12",
      "pfx"
    ],
    "x-pkcs7-certificates": [
      "p7b",
      "spc"
    ],
    "x-research-info-systems": "ris",
    "x-silverlight-app": "xap",
    "x-sql": "sql",
    "x-stuffitx": "sitx",
    "x-subrip": "srt",
    "x-t3vm-image": "t3",
    "x-tex-tfm": "tfm",
    "x-tgif": "obj",
    "x-xliff+xml": "xlf",
    "x-xz": "xz",
    "x-zmachine": [
      "z1",
      "z2",
      "z3",
      "z4",
      "z5",
      "z6",
      "z7",
      "z8"
    ],
    "xaml+xml": "xaml",
    "xcap-diff+xml": "xdf",
    "xenc+xml": "xenc",
    "xml-dtd": "dtd",
    "xop+xml": "xop",
    "xproc+xml": "xpl",
    "xslt+xml": "xslt",
    "xv+xml": [
      "mxml",
      "xhvml",
      "xvml",
      "xvm"
    ],
    "yang": "yang",
    "yin+xml": "yin",
    "envoy": "evy",
    "fractals": "fif",
    "internet-property-stream": "acx",
    "olescript": "axs",
    "vnd.ms-outlook": "msg",
    "vnd.ms-pkicertstore": "sst",
    "x-compress": "z",
    "x-perfmon": [
      "pma",
      "pmc",
      "pmr",
      "pmw"
    ],
    "ynd.ms-pkipko": "pko",
    "gzip": [
      "gz",
      "tgz"
    ],
    "smil+xml": [
      "smi",
      "smil"
    ],
    "vnd.debian.binary-package": [
      "deb",
      "udeb"
    ],
    "vnd.hzn-3d-crossword": "x3d",
    "vnd.sqlite3": [
      "db",
      "sqlite",
      "sqlite3",
      "db-wal",
      "sqlite-wal",
      "db-shm",
      "sqlite-shm"
    ],
    "vnd.wap.sic": "sic",
    "vnd.wap.slc": "slc",
    "x-krita": [
      "kra",
      "krz"
    ],
    "x-perl": [
      "pm",
      "pl"
    ],
    "yaml": [
      "yaml",
      "yml"
    ]
  },
  "audio": {
    "amr": "amr",
    "amr-wb": "awb",
    "annodex": "axa",
    "basic": [
      "au",
      "snd"
    ],
    "flac": "flac",
    "midi": [
      "mid",
      "midi",
      "kar",
      "rmi"
    ],
    "mpeg": [
      "mpga",
      "mpega",
      "mp3",
      "m4a",
      "mp2a",
      "m2a",
      "m3a"
    ],
    "mpegurl": "m3u",
    "ogg": [
      "oga",
      "ogg",
      "spx"
    ],
    "prs.sid": "sid",
    "x-aiff": "aifc",
    "x-gsm": "gsm",
    "x-ms-wma": "wma",
    "x-ms-wax": "wax",
    "x-pn-realaudio": "ram",
    "x-realaudio": "ra",
    "x-sd2": "sd2",
    "adpcm": "adp",
    "mp4": "mp4a",
    "s3m": "s3m",
    "silk": "sil",
    "vnd.dece.audio": [
      "uva",
      "uvva"
    ],
    "vnd.digital-winds": "eol",
    "vnd.dra": "dra",
    "vnd.dts": "dts",
    "vnd.dts.hd": "dtshd",
    "vnd.lucent.voice": "lvp",
    "vnd.ms-playready.media.pya": "pya",
    "vnd.nuera.ecelp4800": "ecelp4800",
    "vnd.nuera.ecelp7470": "ecelp7470",
    "vnd.nuera.ecelp9600": "ecelp9600",
    "vnd.rip": "rip",
    "webm": "weba",
    "x-caf": "caf",
    "x-matroska": "mka",
    "x-pn-realaudio-plugin": "rmp",
    "xm": "xm",
    "aac": "aac",
    "aiff": [
      "aiff",
      "aif",
      "aff"
    ],
    "opus": "opus",
    "wav": "wav"
  },
  "chemical": {
    "x-alchemy": "alc",
    "x-cache": [
      "cac",
      "cache"
    ],
    "x-cache-csf": "csf",
    "x-cactvs-binary": [
      "cbin",
      "cascii",
      "ctab"
    ],
    "x-cdx": "cdx",
    "x-chem3d": "c3d",
    "x-cif": "cif",
    "x-cmdf": "cmdf",
    "x-cml": "cml",
    "x-compass": "cpa",
    "x-crossfire": "bsd",
    "x-csml": [
      "csml",
      "csm"
    ],
    "x-ctx": "ctx",
    "x-cxf": [
      "cxf",
      "cef"
    ],
    "x-embl-dl-nucleotide": [
      "emb",
      "embl"
    ],
    "x-gamess-input": [
      "inp",
      "gam",
      "gamin"
    ],
    "x-gaussian-checkpoint": [
      "fch",
      "fchk"
    ],
    "x-gaussian-cube": "cub",
    "x-gaussian-input": [
      "gau",
      "gjc",
      "gjf"
    ],
    "x-gaussian-log": "gal",
    "x-gcg8-sequence": "gcg",
    "x-genbank": "gen",
    "x-hin": "hin",
    "x-isostar": [
      "istr",
      "ist"
    ],
    "x-jcamp-dx": [
      "jdx",
      "dx"
    ],
    "x-kinemage": "kin",
    "x-macmolecule": "mcm",
    "x-macromodel-input": "mmod",
    "x-mdl-molfile": "mol",
    "x-mdl-rdfile": "rd",
    "x-mdl-rxnfile": "rxn",
    "x-mdl-sdfile": "sd",
    "x-mdl-tgf": "tgf",
    "x-mmcif": "mcif",
    "x-mol2": "mol2",
    "x-molconn-Z": "b",
    "x-mopac-graph": "gpt",
    "x-mopac-input": [
      "mop",
      "mopcrt",
      "zmt"
    ],
    "x-mopac-out": "moo",
    "x-ncbi-asn1": "asn",
    "x-ncbi-asn1-ascii": [
      "prt",
      "ent"
    ],
    "x-ncbi-asn1-binary": "val",
    "x-rosdal": "ros",
    "x-swissprot": "sw",
    "x-vamas-iso14976": "vms",
    "x-vmd": "vmd",
    "x-xtel": "xtel",
    "x-xyz": "xyz"
  },
  "font": {
    "otf": "otf",
    "woff": "woff",
    "woff2": "woff2"
  },
  "image": {
    "gif": "gif",
    "ief": "ief",
    "jpeg": [
      "jpeg",
      "jpg",
      "jpe",
      "jfif",
      "jfif-tbnl",
      "jif"
    ],
    "pcx": "pcx",
    "png": "png",
    "svg+xml": [
      "svg",
      "svgz"
    ],
    "tiff": [
      "tiff",
      "tif"
    ],
    "vnd.djvu": [
      "djvu",
      "djv"
    ],
    "vnd.wap.wbmp": "wbmp",
    "x-canon-cr2": "cr2",
    "x-canon-crw": "crw",
    "x-cmu-raster": "ras",
    "x-coreldraw": "cdr",
    "x-coreldrawpattern": "pat",
    "x-coreldrawtemplate": "cdt",
    "x-corelphotopaint": "cpt",
    "x-epson-erf": "erf",
    "x-icon": "ico",
    "x-jg": "art",
    "x-jng": "jng",
    "x-nikon-nef": "nef",
    "x-olympus-orf": "orf",
    "x-portable-anymap": "pnm",
    "x-portable-bitmap": "pbm",
    "x-portable-graymap": "pgm",
    "x-portable-pixmap": "ppm",
    "x-rgb": "rgb",
    "x-xbitmap": "xbm",
    "x-xpixmap": "xpm",
    "x-xwindowdump": "xwd",
    "bmp": "bmp",
    "cgm": "cgm",
    "g3fax": "g3",
    "ktx": "ktx",
    "prs.btif": "btif",
    "sgi": "sgi",
    "vnd.dece.graphic": [
      "uvi",
      "uvvi",
      "uvg",
      "uvvg"
    ],
    "vnd.dwg": "dwg",
    "vnd.dxf": "dxf",
    "vnd.fastbidsheet": "fbs",
    "vnd.fpx": "fpx",
    "vnd.fst": "fst",
    "vnd.fujixerox.edmics-mmr": "mmr",
    "vnd.fujixerox.edmics-rlc": "rlc",
    "vnd.ms-modi": "mdi",
    "vnd.ms-photo": "wdp",
    "vnd.net-fpx": "npx",
    "vnd.xiff": "xif",
    "webp": "webp",
    "x-3ds": "3ds",
    "x-cmx": "cmx",
    "x-freehand": [
      "fh",
      "fhc",
      "fh4",
      "fh5",
      "fh7"
    ],
    "x-pict": [
      "pic",
      "pct"
    ],
    "x-tga": "tga",
    "cis-cod": "cod",
    "avif": "avifs",
    "heic": [
      "heif",
      "heic"
    ],
    "pjpeg": [
      "pjpg"
    ],
    "vnd.adobe.photoshop": "psd",
    "x-adobe-dng": "dng",
    "x-fuji-raf": "raf",
    "x-icns": "icns",
    "x-kodak-dcr": "dcr",
    "x-kodak-k25": "k25",
    "x-kodak-kdc": "kdc",
    "x-minolta-mrw": "mrw",
    "x-panasonic-raw": [
      "raw",
      "rw2",
      "rwl"
    ],
    "x-pentax-pef": [
      "pef",
      "ptx"
    ],
    "x-sigma-x3f": "x3f",
    "x-sony-arw": "arw",
    "x-sony-sr2": "sr2",
    "x-sony-srf": "srf"
  },
  "message": {
    "rfc822": [
      "eml",
      "mime",
      "mht",
      "mhtml",
      "nws"
    ]
  },
  "model": {
    "iges": [
      "igs",
      "iges"
    ],
    "mesh": [
      "msh",
      "mesh",
      "silo"
    ],
    "vrml": [
      "wrl",
      "vrml"
    ],
    "x3d+vrml": [
      "x3dv",
      "x3dvz"
    ],
    "x3d+xml": "x3dz",
    "x3d+binary": [
      "x3db",
      "x3dbz"
    ],
    "vnd.collada+xml": "dae",
    "vnd.dwf": "dwf",
    "vnd.gdl": "gdl",
    "vnd.gtw": "gtw",
    "vnd.mts": "mts",
    "vnd.usdz+zip": "usdz",
    "vnd.vtu": "vtu"
  },
  "text": {
    "cache-manifest": [
      "manifest",
      "appcache"
    ],
    "calendar": [
      "ics",
      "icz",
      "ifb"
    ],
    "css": "css",
    "csv": "csv",
    "h323": "323",
    "html": [
      "html",
      "htm",
      "shtml",
      "stm"
    ],
    "iuls": "uls",
    "plain": [
      "txt",
      "text",
      "brf",
      "conf",
      "def",
      "list",
      "log",
      "in",
      "bas",
      "diff",
      "ksh"
    ],
    "richtext": "rtx",
    "scriptlet": [
      "sct",
      "wsc"
    ],
    "texmacs": "tm",
    "tab-separated-values": "tsv",
    "vnd.sun.j2me.app-descriptor": "jad",
    "vnd.wap.wml": "wml",
    "vnd.wap.wmlscript": "wmls",
    "x-bibtex": "bib",
    "x-boo": "boo",
    "x-c++hdr": [
      "h++",
      "hpp",
      "hxx",
      "hh"
    ],
    "x-c++src": [
      "c++",
      "cpp",
      "cxx",
      "cc"
    ],
    "x-component": "htc",
    "x-dsrc": "d",
    "x-diff": "patch",
    "x-haskell": "hs",
    "x-java": "java",
    "x-literate-haskell": "lhs",
    "x-moc": "moc",
    "x-pascal": [
      "p",
      "pas",
      "pp",
      "inc"
    ],
    "x-pcs-gcd": "gcd",
    "x-python": "py",
    "x-scala": "scala",
    "x-setext": "etx",
    "x-tcl": [
      "tcl",
      "tk"
    ],
    "x-tex": [
      "tex",
      "ltx",
      "sty",
      "cls"
    ],
    "x-vcalendar": "vcs",
    "x-vcard": "vcf",
    "n3": "n3",
    "prs.lines.tag": "dsc",
    "sgml": [
      "sgml",
      "sgm"
    ],
    "troff": [
      "t",
      "tr",
      "roff",
      "man",
      "me",
      "ms"
    ],
    "turtle": "ttl",
    "uri-list": [
      "uri",
      "uris",
      "urls"
    ],
    "vcard": "vcard",
    "vnd.curl": "curl",
    "vnd.curl.dcurl": "dcurl",
    "vnd.curl.scurl": "scurl",
    "vnd.curl.mcurl": "mcurl",
    "vnd.dvb.subtitle": "sub",
    "vnd.fly": "fly",
    "vnd.fmi.flexstor": "flx",
    "vnd.graphviz": "gv",
    "vnd.in3d.3dml": "3dml",
    "vnd.in3d.spot": "spot",
    "x-asm": [
      "s",
      "asm"
    ],
    "x-c": [
      "c",
      "h",
      "dic"
    ],
    "x-fortran": [
      "f",
      "for",
      "f77",
      "f90"
    ],
    "x-opml": "opml",
    "x-nfo": "nfo",
    "x-sfv": "sfv",
    "x-uuencode": "uu",
    "webviewhtml": "htt",
    "javascript": "js",
    "json": "json",
    "markdown": [
      "md",
      "markdown",
      "mdown",
      "markdn"
    ],
    "vnd.wap.si": "si",
    "vnd.wap.sl": "sl"
  },
  "video": {
    "avif": "avif",
    "3gpp": "3gp",
    "annodex": "axv",
    "dl": "dl",
    "dv": [
      "dif",
      "dv"
    ],
    "fli": "fli",
    "gl": "gl",
    "mpeg": [
      "mpeg",
      "mpg",
      "mpe",
      "m1v",
      "m2v",
      "mp2",
      "mpa",
      "mpv2"
    ],
    "mp4": [
      "mp4",
      "mp4v",
      "mpg4"
    ],
    "quicktime": [
      "qt",
      "mov"
    ],
    "ogg": "ogv",
    "vnd.mpegurl": [
      "mxu",
      "m4u"
    ],
    "x-flv": "flv",
    "x-la-asf": [
      "lsf",
      "lsx"
    ],
    "x-mng": "mng",
    "x-ms-asf": [
      "asf",
      "asx",
      "asr"
    ],
    "x-ms-wm": "wm",
    "x-ms-wmv": "wmv",
    "x-ms-wmx": "wmx",
    "x-ms-wvx": "wvx",
    "x-msvideo": "avi",
    "x-sgi-movie": "movie",
    "x-matroska": [
      "mpv",
      "mkv",
      "mk3d",
      "mks"
    ],
    "3gpp2": "3g2",
    "h261": "h261",
    "h263": "h263",
    "h264": "h264",
    "jpeg": "jpgv",
    "jpm": [
      "jpm",
      "jpgm"
    ],
    "mj2": [
      "mj2",
      "mjp2"
    ],
    "vnd.dece.hd": [
      "uvh",
      "uvvh"
    ],
    "vnd.dece.mobile": [
      "uvm",
      "uvvm"
    ],
    "vnd.dece.pd": [
      "uvp",
      "uvvp"
    ],
    "vnd.dece.sd": [
      "uvs",
      "uvvs"
    ],
    "vnd.dece.video": [
      "uvv",
      "uvvv"
    ],
    "vnd.dvb.file": "dvb",
    "vnd.fvt": "fvt",
    "vnd.ms-playready.media.pyv": "pyv",
    "vnd.uvvu.mp4": [
      "uvu",
      "uvvu"
    ],
    "vnd.vivo": "viv",
    "webm": "webm",
    "x-f4v": "f4v",
    "x-m4v": "m4v",
    "x-ms-vob": "vob",
    "x-smv": "smv",
    "mp2t": "ts"
  },
  "x-conference": {
    "x-cooltalk": "ice"
  },
  "x-world": {
    "x-vrml": [
      "vrm",
      "flr",
      "wrz",
      "xaf",
      "xof"
    ]
  }
};
var mimeTypes = (() => {
  const mimeTypes2 = {};
  for (const type of Object.keys(table2)) {
    for (const subtype of Object.keys(table2[type])) {
      const value = table2[type][subtype];
      if (typeof value == "string") {
        mimeTypes2[value] = type + "/" + subtype;
      } else {
        for (let indexMimeType = 0; indexMimeType < value.length; indexMimeType++) {
          mimeTypes2[value[indexMimeType]] = type + "/" + subtype;
        }
      }
    }
  }
  return mimeTypes2;
})();
function getMimeType2(filename) {
  return filename && mimeTypes[filename.split(".").pop().toLowerCase()] || getMimeType();
}

// node_modules/@zip.js/zip.js/lib/zip-fs-wasm.js
t(configure);

// node_modules/parse5/dist/common/unicode.js
var UNDEFINED_CODE_POINTS = /* @__PURE__ */ new Set([
  65534,
  65535,
  131070,
  131071,
  196606,
  196607,
  262142,
  262143,
  327678,
  327679,
  393214,
  393215,
  458750,
  458751,
  524286,
  524287,
  589822,
  589823,
  655358,
  655359,
  720894,
  720895,
  786430,
  786431,
  851966,
  851967,
  917502,
  917503,
  983038,
  983039,
  1048574,
  1048575,
  1114110,
  1114111
]);
var REPLACEMENT_CHARACTER = "\uFFFD";
var CODE_POINTS;
(function(CODE_POINTS2) {
  CODE_POINTS2[CODE_POINTS2["EOF"] = -1] = "EOF";
  CODE_POINTS2[CODE_POINTS2["NULL"] = 0] = "NULL";
  CODE_POINTS2[CODE_POINTS2["TABULATION"] = 9] = "TABULATION";
  CODE_POINTS2[CODE_POINTS2["CARRIAGE_RETURN"] = 13] = "CARRIAGE_RETURN";
  CODE_POINTS2[CODE_POINTS2["LINE_FEED"] = 10] = "LINE_FEED";
  CODE_POINTS2[CODE_POINTS2["FORM_FEED"] = 12] = "FORM_FEED";
  CODE_POINTS2[CODE_POINTS2["SPACE"] = 32] = "SPACE";
  CODE_POINTS2[CODE_POINTS2["EXCLAMATION_MARK"] = 33] = "EXCLAMATION_MARK";
  CODE_POINTS2[CODE_POINTS2["QUOTATION_MARK"] = 34] = "QUOTATION_MARK";
  CODE_POINTS2[CODE_POINTS2["AMPERSAND"] = 38] = "AMPERSAND";
  CODE_POINTS2[CODE_POINTS2["APOSTROPHE"] = 39] = "APOSTROPHE";
  CODE_POINTS2[CODE_POINTS2["HYPHEN_MINUS"] = 45] = "HYPHEN_MINUS";
  CODE_POINTS2[CODE_POINTS2["SOLIDUS"] = 47] = "SOLIDUS";
  CODE_POINTS2[CODE_POINTS2["DIGIT_0"] = 48] = "DIGIT_0";
  CODE_POINTS2[CODE_POINTS2["DIGIT_9"] = 57] = "DIGIT_9";
  CODE_POINTS2[CODE_POINTS2["SEMICOLON"] = 59] = "SEMICOLON";
  CODE_POINTS2[CODE_POINTS2["LESS_THAN_SIGN"] = 60] = "LESS_THAN_SIGN";
  CODE_POINTS2[CODE_POINTS2["EQUALS_SIGN"] = 61] = "EQUALS_SIGN";
  CODE_POINTS2[CODE_POINTS2["GREATER_THAN_SIGN"] = 62] = "GREATER_THAN_SIGN";
  CODE_POINTS2[CODE_POINTS2["QUESTION_MARK"] = 63] = "QUESTION_MARK";
  CODE_POINTS2[CODE_POINTS2["LATIN_CAPITAL_A"] = 65] = "LATIN_CAPITAL_A";
  CODE_POINTS2[CODE_POINTS2["LATIN_CAPITAL_Z"] = 90] = "LATIN_CAPITAL_Z";
  CODE_POINTS2[CODE_POINTS2["RIGHT_SQUARE_BRACKET"] = 93] = "RIGHT_SQUARE_BRACKET";
  CODE_POINTS2[CODE_POINTS2["GRAVE_ACCENT"] = 96] = "GRAVE_ACCENT";
  CODE_POINTS2[CODE_POINTS2["LATIN_SMALL_A"] = 97] = "LATIN_SMALL_A";
  CODE_POINTS2[CODE_POINTS2["LATIN_SMALL_Z"] = 122] = "LATIN_SMALL_Z";
})(CODE_POINTS || (CODE_POINTS = {}));
var SEQUENCES = {
  DASH_DASH: "--",
  CDATA_START: "[CDATA[",
  DOCTYPE: "doctype",
  SCRIPT: "script",
  PUBLIC: "public",
  SYSTEM: "system"
};
function isSurrogate(cp2) {
  return cp2 >= 55296 && cp2 <= 57343;
}
function isSurrogatePair(cp2) {
  return cp2 >= 56320 && cp2 <= 57343;
}
function getSurrogatePairCodePoint(cp1, cp2) {
  return (cp1 - 55296) * 1024 + 9216 + cp2;
}
function isControlCodePoint(cp2) {
  return cp2 !== 32 && cp2 !== 10 && cp2 !== 13 && cp2 !== 9 && cp2 !== 12 && cp2 >= 1 && cp2 <= 31 || cp2 >= 127 && cp2 <= 159;
}
function isUndefinedCodePoint(cp2) {
  return cp2 >= 64976 && cp2 <= 65007 || UNDEFINED_CODE_POINTS.has(cp2);
}

// node_modules/parse5/dist/common/error-codes.js
var ERR;
(function(ERR2) {
  ERR2["controlCharacterInInputStream"] = "control-character-in-input-stream";
  ERR2["noncharacterInInputStream"] = "noncharacter-in-input-stream";
  ERR2["surrogateInInputStream"] = "surrogate-in-input-stream";
  ERR2["nonVoidHtmlElementStartTagWithTrailingSolidus"] = "non-void-html-element-start-tag-with-trailing-solidus";
  ERR2["endTagWithAttributes"] = "end-tag-with-attributes";
  ERR2["endTagWithTrailingSolidus"] = "end-tag-with-trailing-solidus";
  ERR2["unexpectedSolidusInTag"] = "unexpected-solidus-in-tag";
  ERR2["unexpectedNullCharacter"] = "unexpected-null-character";
  ERR2["unexpectedQuestionMarkInsteadOfTagName"] = "unexpected-question-mark-instead-of-tag-name";
  ERR2["invalidFirstCharacterOfTagName"] = "invalid-first-character-of-tag-name";
  ERR2["unexpectedEqualsSignBeforeAttributeName"] = "unexpected-equals-sign-before-attribute-name";
  ERR2["missingEndTagName"] = "missing-end-tag-name";
  ERR2["unexpectedCharacterInAttributeName"] = "unexpected-character-in-attribute-name";
  ERR2["unknownNamedCharacterReference"] = "unknown-named-character-reference";
  ERR2["missingSemicolonAfterCharacterReference"] = "missing-semicolon-after-character-reference";
  ERR2["unexpectedCharacterAfterDoctypeSystemIdentifier"] = "unexpected-character-after-doctype-system-identifier";
  ERR2["unexpectedCharacterInUnquotedAttributeValue"] = "unexpected-character-in-unquoted-attribute-value";
  ERR2["eofBeforeTagName"] = "eof-before-tag-name";
  ERR2["eofInTag"] = "eof-in-tag";
  ERR2["missingAttributeValue"] = "missing-attribute-value";
  ERR2["missingWhitespaceBetweenAttributes"] = "missing-whitespace-between-attributes";
  ERR2["missingWhitespaceAfterDoctypePublicKeyword"] = "missing-whitespace-after-doctype-public-keyword";
  ERR2["missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers"] = "missing-whitespace-between-doctype-public-and-system-identifiers";
  ERR2["missingWhitespaceAfterDoctypeSystemKeyword"] = "missing-whitespace-after-doctype-system-keyword";
  ERR2["missingQuoteBeforeDoctypePublicIdentifier"] = "missing-quote-before-doctype-public-identifier";
  ERR2["missingQuoteBeforeDoctypeSystemIdentifier"] = "missing-quote-before-doctype-system-identifier";
  ERR2["missingDoctypePublicIdentifier"] = "missing-doctype-public-identifier";
  ERR2["missingDoctypeSystemIdentifier"] = "missing-doctype-system-identifier";
  ERR2["abruptDoctypePublicIdentifier"] = "abrupt-doctype-public-identifier";
  ERR2["abruptDoctypeSystemIdentifier"] = "abrupt-doctype-system-identifier";
  ERR2["cdataInHtmlContent"] = "cdata-in-html-content";
  ERR2["incorrectlyOpenedComment"] = "incorrectly-opened-comment";
  ERR2["eofInScriptHtmlCommentLikeText"] = "eof-in-script-html-comment-like-text";
  ERR2["eofInDoctype"] = "eof-in-doctype";
  ERR2["nestedComment"] = "nested-comment";
  ERR2["abruptClosingOfEmptyComment"] = "abrupt-closing-of-empty-comment";
  ERR2["eofInComment"] = "eof-in-comment";
  ERR2["incorrectlyClosedComment"] = "incorrectly-closed-comment";
  ERR2["eofInCdata"] = "eof-in-cdata";
  ERR2["absenceOfDigitsInNumericCharacterReference"] = "absence-of-digits-in-numeric-character-reference";
  ERR2["nullCharacterReference"] = "null-character-reference";
  ERR2["surrogateCharacterReference"] = "surrogate-character-reference";
  ERR2["characterReferenceOutsideUnicodeRange"] = "character-reference-outside-unicode-range";
  ERR2["controlCharacterReference"] = "control-character-reference";
  ERR2["noncharacterCharacterReference"] = "noncharacter-character-reference";
  ERR2["missingWhitespaceBeforeDoctypeName"] = "missing-whitespace-before-doctype-name";
  ERR2["missingDoctypeName"] = "missing-doctype-name";
  ERR2["invalidCharacterSequenceAfterDoctypeName"] = "invalid-character-sequence-after-doctype-name";
  ERR2["duplicateAttribute"] = "duplicate-attribute";
  ERR2["nonConformingDoctype"] = "non-conforming-doctype";
  ERR2["missingDoctype"] = "missing-doctype";
  ERR2["misplacedDoctype"] = "misplaced-doctype";
  ERR2["endTagWithoutMatchingOpenElement"] = "end-tag-without-matching-open-element";
  ERR2["closingOfElementWithOpenChildElements"] = "closing-of-element-with-open-child-elements";
  ERR2["disallowedContentInNoscriptInHead"] = "disallowed-content-in-noscript-in-head";
  ERR2["openElementsLeftAfterEof"] = "open-elements-left-after-eof";
  ERR2["abandonedHeadElementChild"] = "abandoned-head-element-child";
  ERR2["misplacedStartTagForHeadElement"] = "misplaced-start-tag-for-head-element";
  ERR2["nestedNoscriptInHead"] = "nested-noscript-in-head";
  ERR2["eofInElementThatCanContainOnlyText"] = "eof-in-element-that-can-contain-only-text";
})(ERR || (ERR = {}));

// node_modules/parse5/dist/tokenizer/preprocessor.js
var DEFAULT_BUFFER_WATERLINE = 1 << 16;
var Preprocessor = class {
  constructor(handler) {
    this.handler = handler;
    this.html = "";
    this.pos = -1;
    this.lastGapPos = -2;
    this.gapStack = [];
    this.skipNextNewLine = false;
    this.lastChunkWritten = false;
    this.endOfChunkHit = false;
    this.bufferWaterline = DEFAULT_BUFFER_WATERLINE;
    this.isEol = false;
    this.lineStartPos = 0;
    this.droppedBufferSize = 0;
    this.line = 1;
    this.lastErrOffset = -1;
  }
  /** The column on the current line. If we just saw a gap (eg. a surrogate pair), return the index before. */
  get col() {
    return this.pos - this.lineStartPos + Number(this.lastGapPos !== this.pos);
  }
  get offset() {
    return this.droppedBufferSize + this.pos;
  }
  getError(code, cpOffset) {
    const { line, col, offset } = this;
    const startCol = col + cpOffset;
    const startOffset = offset + cpOffset;
    return {
      code,
      startLine: line,
      endLine: line,
      startCol,
      endCol: startCol,
      startOffset,
      endOffset: startOffset
    };
  }
  _err(code) {
    if (this.handler.onParseError && this.lastErrOffset !== this.offset) {
      this.lastErrOffset = this.offset;
      this.handler.onParseError(this.getError(code, 0));
    }
  }
  _addGap() {
    this.gapStack.push(this.lastGapPos);
    this.lastGapPos = this.pos;
  }
  _processSurrogate(cp2) {
    if (this.pos !== this.html.length - 1) {
      const nextCp = this.html.charCodeAt(this.pos + 1);
      if (isSurrogatePair(nextCp)) {
        this.pos++;
        this._addGap();
        return getSurrogatePairCodePoint(cp2, nextCp);
      }
    } else if (!this.lastChunkWritten) {
      this.endOfChunkHit = true;
      return CODE_POINTS.EOF;
    }
    this._err(ERR.surrogateInInputStream);
    return cp2;
  }
  willDropParsedChunk() {
    return this.pos > this.bufferWaterline;
  }
  dropParsedChunk() {
    if (this.willDropParsedChunk()) {
      this.html = this.html.substring(this.pos);
      this.lineStartPos -= this.pos;
      this.droppedBufferSize += this.pos;
      this.pos = 0;
      this.lastGapPos = -2;
      this.gapStack.length = 0;
    }
  }
  write(chunk, isLastChunk) {
    if (this.html.length > 0) {
      this.html += chunk;
    } else {
      this.html = chunk;
    }
    this.endOfChunkHit = false;
    this.lastChunkWritten = isLastChunk;
  }
  insertHtmlAtCurrentPos(chunk) {
    this.html = this.html.substring(0, this.pos + 1) + chunk + this.html.substring(this.pos + 1);
    this.endOfChunkHit = false;
  }
  startsWith(pattern, caseSensitive) {
    if (this.pos + pattern.length > this.html.length) {
      this.endOfChunkHit = !this.lastChunkWritten;
      return false;
    }
    if (caseSensitive) {
      return this.html.startsWith(pattern, this.pos);
    }
    for (let i = 0; i < pattern.length; i++) {
      const cp2 = this.html.charCodeAt(this.pos + i) | 32;
      if (cp2 !== pattern.charCodeAt(i)) {
        return false;
      }
    }
    return true;
  }
  peek(offset) {
    const pos = this.pos + offset;
    if (pos >= this.html.length) {
      this.endOfChunkHit = !this.lastChunkWritten;
      return CODE_POINTS.EOF;
    }
    const code = this.html.charCodeAt(pos);
    return code === CODE_POINTS.CARRIAGE_RETURN ? CODE_POINTS.LINE_FEED : code;
  }
  advance() {
    this.pos++;
    if (this.isEol) {
      this.isEol = false;
      this.line++;
      this.lineStartPos = this.pos;
    }
    if (this.pos >= this.html.length) {
      this.endOfChunkHit = !this.lastChunkWritten;
      return CODE_POINTS.EOF;
    }
    let cp2 = this.html.charCodeAt(this.pos);
    if (cp2 === CODE_POINTS.CARRIAGE_RETURN) {
      this.isEol = true;
      this.skipNextNewLine = true;
      return CODE_POINTS.LINE_FEED;
    }
    if (cp2 === CODE_POINTS.LINE_FEED) {
      this.isEol = true;
      if (this.skipNextNewLine) {
        this.line--;
        this.skipNextNewLine = false;
        this._addGap();
        return this.advance();
      }
    }
    this.skipNextNewLine = false;
    if (isSurrogate(cp2)) {
      cp2 = this._processSurrogate(cp2);
    }
    const isCommonValidRange = this.handler.onParseError === null || cp2 > 31 && cp2 < 127 || cp2 === CODE_POINTS.LINE_FEED || cp2 === CODE_POINTS.CARRIAGE_RETURN || cp2 > 159 && cp2 < 64976;
    if (!isCommonValidRange) {
      this._checkForProblematicCharacters(cp2);
    }
    return cp2;
  }
  _checkForProblematicCharacters(cp2) {
    if (isControlCodePoint(cp2)) {
      this._err(ERR.controlCharacterInInputStream);
    } else if (isUndefinedCodePoint(cp2)) {
      this._err(ERR.noncharacterInInputStream);
    }
  }
  retreat(count) {
    this.pos -= count;
    while (this.pos < this.lastGapPos) {
      this.lastGapPos = this.gapStack.pop();
      this.pos--;
    }
    this.isEol = false;
  }
};

// node_modules/parse5/dist/common/token.js
var TokenType;
(function(TokenType2) {
  TokenType2[TokenType2["CHARACTER"] = 0] = "CHARACTER";
  TokenType2[TokenType2["NULL_CHARACTER"] = 1] = "NULL_CHARACTER";
  TokenType2[TokenType2["WHITESPACE_CHARACTER"] = 2] = "WHITESPACE_CHARACTER";
  TokenType2[TokenType2["START_TAG"] = 3] = "START_TAG";
  TokenType2[TokenType2["END_TAG"] = 4] = "END_TAG";
  TokenType2[TokenType2["COMMENT"] = 5] = "COMMENT";
  TokenType2[TokenType2["DOCTYPE"] = 6] = "DOCTYPE";
  TokenType2[TokenType2["EOF"] = 7] = "EOF";
  TokenType2[TokenType2["HIBERNATION"] = 8] = "HIBERNATION";
})(TokenType || (TokenType = {}));
function getTokenAttr(token, attrName) {
  for (let i = token.attrs.length - 1; i >= 0; i--) {
    if (token.attrs[i].name === attrName) {
      return token.attrs[i].value;
    }
  }
  return null;
}

// node_modules/entities/dist/esm/generated/decode-data-html.js
var htmlDecodeTree = /* @__PURE__ */ new Uint16Array(
  // prettier-ignore
  /* @__PURE__ */ '\u1D41<\xD5\u0131\u028A\u049D\u057B\u05D0\u0675\u06DE\u07A2\u07D6\u080F\u0A4A\u0A91\u0DA1\u0E6D\u0F09\u0F26\u10CA\u1228\u12E1\u1415\u149D\u14C3\u14DF\u1525\0\0\0\0\0\0\u156B\u16CD\u198D\u1C12\u1DDD\u1F7E\u2060\u21B0\u228D\u23C0\u23FB\u2442\u2824\u2912\u2D08\u2E48\u2FCE\u3016\u32BA\u3639\u37AC\u38FE\u3A28\u3A71\u3AE0\u3B2E\u0800EMabcfglmnoprstu\\bfms\x7F\x84\x8B\x90\x95\x98\xA6\xB3\xB9\xC8\xCFlig\u803B\xC6\u40C6P\u803B&\u4026cute\u803B\xC1\u40C1reve;\u4102\u0100iyx}rc\u803B\xC2\u40C2;\u4410r;\uC000\u{1D504}rave\u803B\xC0\u40C0pha;\u4391acr;\u4100d;\u6A53\u0100gp\x9D\xA1on;\u4104f;\uC000\u{1D538}plyFunction;\u6061ing\u803B\xC5\u40C5\u0100cs\xBE\xC3r;\uC000\u{1D49C}ign;\u6254ilde\u803B\xC3\u40C3ml\u803B\xC4\u40C4\u0400aceforsu\xE5\xFB\xFE\u0117\u011C\u0122\u0127\u012A\u0100cr\xEA\xF2kslash;\u6216\u0176\xF6\xF8;\u6AE7ed;\u6306y;\u4411\u0180crt\u0105\u010B\u0114ause;\u6235noullis;\u612Ca;\u4392r;\uC000\u{1D505}pf;\uC000\u{1D539}eve;\u42D8c\xF2\u0113mpeq;\u624E\u0700HOacdefhilorsu\u014D\u0151\u0156\u0180\u019E\u01A2\u01B5\u01B7\u01BA\u01DC\u0215\u0273\u0278\u027Ecy;\u4427PY\u803B\xA9\u40A9\u0180cpy\u015D\u0162\u017Aute;\u4106\u0100;i\u0167\u0168\u62D2talDifferentialD;\u6145leys;\u612D\u0200aeio\u0189\u018E\u0194\u0198ron;\u410Cdil\u803B\xC7\u40C7rc;\u4108nint;\u6230ot;\u410A\u0100dn\u01A7\u01ADilla;\u40B8terDot;\u40B7\xF2\u017Fi;\u43A7rcle\u0200DMPT\u01C7\u01CB\u01D1\u01D6ot;\u6299inus;\u6296lus;\u6295imes;\u6297o\u0100cs\u01E2\u01F8kwiseContourIntegral;\u6232eCurly\u0100DQ\u0203\u020FoubleQuote;\u601Duote;\u6019\u0200lnpu\u021E\u0228\u0247\u0255on\u0100;e\u0225\u0226\u6237;\u6A74\u0180git\u022F\u0236\u023Aruent;\u6261nt;\u622FourIntegral;\u622E\u0100fr\u024C\u024E;\u6102oduct;\u6210nterClockwiseContourIntegral;\u6233oss;\u6A2Fcr;\uC000\u{1D49E}p\u0100;C\u0284\u0285\u62D3ap;\u624D\u0580DJSZacefios\u02A0\u02AC\u02B0\u02B4\u02B8\u02CB\u02D7\u02E1\u02E6\u0333\u048D\u0100;o\u0179\u02A5trahd;\u6911cy;\u4402cy;\u4405cy;\u440F\u0180grs\u02BF\u02C4\u02C7ger;\u6021r;\u61A1hv;\u6AE4\u0100ay\u02D0\u02D5ron;\u410E;\u4414l\u0100;t\u02DD\u02DE\u6207a;\u4394r;\uC000\u{1D507}\u0100af\u02EB\u0327\u0100cm\u02F0\u0322ritical\u0200ADGT\u0300\u0306\u0316\u031Ccute;\u40B4o\u0174\u030B\u030D;\u42D9bleAcute;\u42DDrave;\u4060ilde;\u42DCond;\u62C4ferentialD;\u6146\u0470\u033D\0\0\0\u0342\u0354\0\u0405f;\uC000\u{1D53B}\u0180;DE\u0348\u0349\u034D\u40A8ot;\u60DCqual;\u6250ble\u0300CDLRUV\u0363\u0372\u0382\u03CF\u03E2\u03F8ontourIntegra\xEC\u0239o\u0274\u0379\0\0\u037B\xBB\u0349nArrow;\u61D3\u0100eo\u0387\u03A4ft\u0180ART\u0390\u0396\u03A1rrow;\u61D0ightArrow;\u61D4e\xE5\u02CAng\u0100LR\u03AB\u03C4eft\u0100AR\u03B3\u03B9rrow;\u67F8ightArrow;\u67FAightArrow;\u67F9ight\u0100AT\u03D8\u03DErrow;\u61D2ee;\u62A8p\u0241\u03E9\0\0\u03EFrrow;\u61D1ownArrow;\u61D5erticalBar;\u6225n\u0300ABLRTa\u0412\u042A\u0430\u045E\u047F\u037Crrow\u0180;BU\u041D\u041E\u0422\u6193ar;\u6913pArrow;\u61F5reve;\u4311eft\u02D2\u043A\0\u0446\0\u0450ightVector;\u6950eeVector;\u695Eector\u0100;B\u0459\u045A\u61BDar;\u6956ight\u01D4\u0467\0\u0471eeVector;\u695Fector\u0100;B\u047A\u047B\u61C1ar;\u6957ee\u0100;A\u0486\u0487\u62A4rrow;\u61A7\u0100ct\u0492\u0497r;\uC000\u{1D49F}rok;\u4110\u0800NTacdfglmopqstux\u04BD\u04C0\u04C4\u04CB\u04DE\u04E2\u04E7\u04EE\u04F5\u0521\u052F\u0536\u0552\u055D\u0560\u0565G;\u414AH\u803B\xD0\u40D0cute\u803B\xC9\u40C9\u0180aiy\u04D2\u04D7\u04DCron;\u411Arc\u803B\xCA\u40CA;\u442Dot;\u4116r;\uC000\u{1D508}rave\u803B\xC8\u40C8ement;\u6208\u0100ap\u04FA\u04FEcr;\u4112ty\u0253\u0506\0\0\u0512mallSquare;\u65FBerySmallSquare;\u65AB\u0100gp\u0526\u052Aon;\u4118f;\uC000\u{1D53C}silon;\u4395u\u0100ai\u053C\u0549l\u0100;T\u0542\u0543\u6A75ilde;\u6242librium;\u61CC\u0100ci\u0557\u055Ar;\u6130m;\u6A73a;\u4397ml\u803B\xCB\u40CB\u0100ip\u056A\u056Fsts;\u6203onentialE;\u6147\u0280cfios\u0585\u0588\u058D\u05B2\u05CCy;\u4424r;\uC000\u{1D509}lled\u0253\u0597\0\0\u05A3mallSquare;\u65FCerySmallSquare;\u65AA\u0370\u05BA\0\u05BF\0\0\u05C4f;\uC000\u{1D53D}All;\u6200riertrf;\u6131c\xF2\u05CB\u0600JTabcdfgorst\u05E8\u05EC\u05EF\u05FA\u0600\u0612\u0616\u061B\u061D\u0623\u066C\u0672cy;\u4403\u803B>\u403Emma\u0100;d\u05F7\u05F8\u4393;\u43DCreve;\u411E\u0180eiy\u0607\u060C\u0610dil;\u4122rc;\u411C;\u4413ot;\u4120r;\uC000\u{1D50A};\u62D9pf;\uC000\u{1D53E}eater\u0300EFGLST\u0635\u0644\u064E\u0656\u065B\u0666qual\u0100;L\u063E\u063F\u6265ess;\u62DBullEqual;\u6267reater;\u6AA2ess;\u6277lantEqual;\u6A7Eilde;\u6273cr;\uC000\u{1D4A2};\u626B\u0400Aacfiosu\u0685\u068B\u0696\u069B\u069E\u06AA\u06BE\u06CARDcy;\u442A\u0100ct\u0690\u0694ek;\u42C7;\u405Eirc;\u4124r;\u610ClbertSpace;\u610B\u01F0\u06AF\0\u06B2f;\u610DizontalLine;\u6500\u0100ct\u06C3\u06C5\xF2\u06A9rok;\u4126mp\u0144\u06D0\u06D8ownHum\xF0\u012Fqual;\u624F\u0700EJOacdfgmnostu\u06FA\u06FE\u0703\u0707\u070E\u071A\u071E\u0721\u0728\u0744\u0778\u078B\u078F\u0795cy;\u4415lig;\u4132cy;\u4401cute\u803B\xCD\u40CD\u0100iy\u0713\u0718rc\u803B\xCE\u40CE;\u4418ot;\u4130r;\u6111rave\u803B\xCC\u40CC\u0180;ap\u0720\u072F\u073F\u0100cg\u0734\u0737r;\u412AinaryI;\u6148lie\xF3\u03DD\u01F4\u0749\0\u0762\u0100;e\u074D\u074E\u622C\u0100gr\u0753\u0758ral;\u622Bsection;\u62C2isible\u0100CT\u076C\u0772omma;\u6063imes;\u6062\u0180gpt\u077F\u0783\u0788on;\u412Ef;\uC000\u{1D540}a;\u4399cr;\u6110ilde;\u4128\u01EB\u079A\0\u079Ecy;\u4406l\u803B\xCF\u40CF\u0280cfosu\u07AC\u07B7\u07BC\u07C2\u07D0\u0100iy\u07B1\u07B5rc;\u4134;\u4419r;\uC000\u{1D50D}pf;\uC000\u{1D541}\u01E3\u07C7\0\u07CCr;\uC000\u{1D4A5}rcy;\u4408kcy;\u4404\u0380HJacfos\u07E4\u07E8\u07EC\u07F1\u07FD\u0802\u0808cy;\u4425cy;\u440Cppa;\u439A\u0100ey\u07F6\u07FBdil;\u4136;\u441Ar;\uC000\u{1D50E}pf;\uC000\u{1D542}cr;\uC000\u{1D4A6}\u0580JTaceflmost\u0825\u0829\u082C\u0850\u0863\u09B3\u09B8\u09C7\u09CD\u0A37\u0A47cy;\u4409\u803B<\u403C\u0280cmnpr\u0837\u083C\u0841\u0844\u084Dute;\u4139bda;\u439Bg;\u67EAlacetrf;\u6112r;\u619E\u0180aey\u0857\u085C\u0861ron;\u413Ddil;\u413B;\u441B\u0100fs\u0868\u0970t\u0500ACDFRTUVar\u087E\u08A9\u08B1\u08E0\u08E6\u08FC\u092F\u095B\u0390\u096A\u0100nr\u0883\u088FgleBracket;\u67E8row\u0180;BR\u0899\u089A\u089E\u6190ar;\u61E4ightArrow;\u61C6eiling;\u6308o\u01F5\u08B7\0\u08C3bleBracket;\u67E6n\u01D4\u08C8\0\u08D2eeVector;\u6961ector\u0100;B\u08DB\u08DC\u61C3ar;\u6959loor;\u630Aight\u0100AV\u08EF\u08F5rrow;\u6194ector;\u694E\u0100er\u0901\u0917e\u0180;AV\u0909\u090A\u0910\u62A3rrow;\u61A4ector;\u695Aiangle\u0180;BE\u0924\u0925\u0929\u62B2ar;\u69CFqual;\u62B4p\u0180DTV\u0937\u0942\u094CownVector;\u6951eeVector;\u6960ector\u0100;B\u0956\u0957\u61BFar;\u6958ector\u0100;B\u0965\u0966\u61BCar;\u6952ight\xE1\u039Cs\u0300EFGLST\u097E\u098B\u0995\u099D\u09A2\u09ADqualGreater;\u62DAullEqual;\u6266reater;\u6276ess;\u6AA1lantEqual;\u6A7Dilde;\u6272r;\uC000\u{1D50F}\u0100;e\u09BD\u09BE\u62D8ftarrow;\u61DAidot;\u413F\u0180npw\u09D4\u0A16\u0A1Bg\u0200LRlr\u09DE\u09F7\u0A02\u0A10eft\u0100AR\u09E6\u09ECrrow;\u67F5ightArrow;\u67F7ightArrow;\u67F6eft\u0100ar\u03B3\u0A0Aight\xE1\u03BFight\xE1\u03CAf;\uC000\u{1D543}er\u0100LR\u0A22\u0A2CeftArrow;\u6199ightArrow;\u6198\u0180cht\u0A3E\u0A40\u0A42\xF2\u084C;\u61B0rok;\u4141;\u626A\u0400acefiosu\u0A5A\u0A5D\u0A60\u0A77\u0A7C\u0A85\u0A8B\u0A8Ep;\u6905y;\u441C\u0100dl\u0A65\u0A6FiumSpace;\u605Flintrf;\u6133r;\uC000\u{1D510}nusPlus;\u6213pf;\uC000\u{1D544}c\xF2\u0A76;\u439C\u0480Jacefostu\u0AA3\u0AA7\u0AAD\u0AC0\u0B14\u0B19\u0D91\u0D97\u0D9Ecy;\u440Acute;\u4143\u0180aey\u0AB4\u0AB9\u0ABEron;\u4147dil;\u4145;\u441D\u0180gsw\u0AC7\u0AF0\u0B0Eative\u0180MTV\u0AD3\u0ADF\u0AE8ediumSpace;\u600Bhi\u0100cn\u0AE6\u0AD8\xEB\u0AD9eryThi\xEE\u0AD9ted\u0100GL\u0AF8\u0B06reaterGreate\xF2\u0673essLes\xF3\u0A48Line;\u400Ar;\uC000\u{1D511}\u0200Bnpt\u0B22\u0B28\u0B37\u0B3Areak;\u6060BreakingSpace;\u40A0f;\u6115\u0680;CDEGHLNPRSTV\u0B55\u0B56\u0B6A\u0B7C\u0BA1\u0BEB\u0C04\u0C5E\u0C84\u0CA6\u0CD8\u0D61\u0D85\u6AEC\u0100ou\u0B5B\u0B64ngruent;\u6262pCap;\u626DoubleVerticalBar;\u6226\u0180lqx\u0B83\u0B8A\u0B9Bement;\u6209ual\u0100;T\u0B92\u0B93\u6260ilde;\uC000\u2242\u0338ists;\u6204reater\u0380;EFGLST\u0BB6\u0BB7\u0BBD\u0BC9\u0BD3\u0BD8\u0BE5\u626Fqual;\u6271ullEqual;\uC000\u2267\u0338reater;\uC000\u226B\u0338ess;\u6279lantEqual;\uC000\u2A7E\u0338ilde;\u6275ump\u0144\u0BF2\u0BFDownHump;\uC000\u224E\u0338qual;\uC000\u224F\u0338e\u0100fs\u0C0A\u0C27tTriangle\u0180;BE\u0C1A\u0C1B\u0C21\u62EAar;\uC000\u29CF\u0338qual;\u62ECs\u0300;EGLST\u0C35\u0C36\u0C3C\u0C44\u0C4B\u0C58\u626Equal;\u6270reater;\u6278ess;\uC000\u226A\u0338lantEqual;\uC000\u2A7D\u0338ilde;\u6274ested\u0100GL\u0C68\u0C79reaterGreater;\uC000\u2AA2\u0338essLess;\uC000\u2AA1\u0338recedes\u0180;ES\u0C92\u0C93\u0C9B\u6280qual;\uC000\u2AAF\u0338lantEqual;\u62E0\u0100ei\u0CAB\u0CB9verseElement;\u620CghtTriangle\u0180;BE\u0CCB\u0CCC\u0CD2\u62EBar;\uC000\u29D0\u0338qual;\u62ED\u0100qu\u0CDD\u0D0CuareSu\u0100bp\u0CE8\u0CF9set\u0100;E\u0CF0\u0CF3\uC000\u228F\u0338qual;\u62E2erset\u0100;E\u0D03\u0D06\uC000\u2290\u0338qual;\u62E3\u0180bcp\u0D13\u0D24\u0D4Eset\u0100;E\u0D1B\u0D1E\uC000\u2282\u20D2qual;\u6288ceeds\u0200;EST\u0D32\u0D33\u0D3B\u0D46\u6281qual;\uC000\u2AB0\u0338lantEqual;\u62E1ilde;\uC000\u227F\u0338erset\u0100;E\u0D58\u0D5B\uC000\u2283\u20D2qual;\u6289ilde\u0200;EFT\u0D6E\u0D6F\u0D75\u0D7F\u6241qual;\u6244ullEqual;\u6247ilde;\u6249erticalBar;\u6224cr;\uC000\u{1D4A9}ilde\u803B\xD1\u40D1;\u439D\u0700Eacdfgmoprstuv\u0DBD\u0DC2\u0DC9\u0DD5\u0DDB\u0DE0\u0DE7\u0DFC\u0E02\u0E20\u0E22\u0E32\u0E3F\u0E44lig;\u4152cute\u803B\xD3\u40D3\u0100iy\u0DCE\u0DD3rc\u803B\xD4\u40D4;\u441Eblac;\u4150r;\uC000\u{1D512}rave\u803B\xD2\u40D2\u0180aei\u0DEE\u0DF2\u0DF6cr;\u414Cga;\u43A9cron;\u439Fpf;\uC000\u{1D546}enCurly\u0100DQ\u0E0E\u0E1AoubleQuote;\u601Cuote;\u6018;\u6A54\u0100cl\u0E27\u0E2Cr;\uC000\u{1D4AA}ash\u803B\xD8\u40D8i\u016C\u0E37\u0E3Cde\u803B\xD5\u40D5es;\u6A37ml\u803B\xD6\u40D6er\u0100BP\u0E4B\u0E60\u0100ar\u0E50\u0E53r;\u603Eac\u0100ek\u0E5A\u0E5C;\u63DEet;\u63B4arenthesis;\u63DC\u0480acfhilors\u0E7F\u0E87\u0E8A\u0E8F\u0E92\u0E94\u0E9D\u0EB0\u0EFCrtialD;\u6202y;\u441Fr;\uC000\u{1D513}i;\u43A6;\u43A0usMinus;\u40B1\u0100ip\u0EA2\u0EADncareplan\xE5\u069Df;\u6119\u0200;eio\u0EB9\u0EBA\u0EE0\u0EE4\u6ABBcedes\u0200;EST\u0EC8\u0EC9\u0ECF\u0EDA\u627Aqual;\u6AAFlantEqual;\u627Cilde;\u627Eme;\u6033\u0100dp\u0EE9\u0EEEuct;\u620Fortion\u0100;a\u0225\u0EF9l;\u621D\u0100ci\u0F01\u0F06r;\uC000\u{1D4AB};\u43A8\u0200Ufos\u0F11\u0F16\u0F1B\u0F1FOT\u803B"\u4022r;\uC000\u{1D514}pf;\u611Acr;\uC000\u{1D4AC}\u0600BEacefhiorsu\u0F3E\u0F43\u0F47\u0F60\u0F73\u0FA7\u0FAA\u0FAD\u1096\u10A9\u10B4\u10BEarr;\u6910G\u803B\xAE\u40AE\u0180cnr\u0F4E\u0F53\u0F56ute;\u4154g;\u67EBr\u0100;t\u0F5C\u0F5D\u61A0l;\u6916\u0180aey\u0F67\u0F6C\u0F71ron;\u4158dil;\u4156;\u4420\u0100;v\u0F78\u0F79\u611Cerse\u0100EU\u0F82\u0F99\u0100lq\u0F87\u0F8Eement;\u620Builibrium;\u61CBpEquilibrium;\u696Fr\xBB\u0F79o;\u43A1ght\u0400ACDFTUVa\u0FC1\u0FEB\u0FF3\u1022\u1028\u105B\u1087\u03D8\u0100nr\u0FC6\u0FD2gleBracket;\u67E9row\u0180;BL\u0FDC\u0FDD\u0FE1\u6192ar;\u61E5eftArrow;\u61C4eiling;\u6309o\u01F5\u0FF9\0\u1005bleBracket;\u67E7n\u01D4\u100A\0\u1014eeVector;\u695Dector\u0100;B\u101D\u101E\u61C2ar;\u6955loor;\u630B\u0100er\u102D\u1043e\u0180;AV\u1035\u1036\u103C\u62A2rrow;\u61A6ector;\u695Biangle\u0180;BE\u1050\u1051\u1055\u62B3ar;\u69D0qual;\u62B5p\u0180DTV\u1063\u106E\u1078ownVector;\u694FeeVector;\u695Cector\u0100;B\u1082\u1083\u61BEar;\u6954ector\u0100;B\u1091\u1092\u61C0ar;\u6953\u0100pu\u109B\u109Ef;\u611DndImplies;\u6970ightarrow;\u61DB\u0100ch\u10B9\u10BCr;\u611B;\u61B1leDelayed;\u69F4\u0680HOacfhimoqstu\u10E4\u10F1\u10F7\u10FD\u1119\u111E\u1151\u1156\u1161\u1167\u11B5\u11BB\u11BF\u0100Cc\u10E9\u10EEHcy;\u4429y;\u4428FTcy;\u442Ccute;\u415A\u0280;aeiy\u1108\u1109\u110E\u1113\u1117\u6ABCron;\u4160dil;\u415Erc;\u415C;\u4421r;\uC000\u{1D516}ort\u0200DLRU\u112A\u1134\u113E\u1149ownArrow\xBB\u041EeftArrow\xBB\u089AightArrow\xBB\u0FDDpArrow;\u6191gma;\u43A3allCircle;\u6218pf;\uC000\u{1D54A}\u0272\u116D\0\0\u1170t;\u621Aare\u0200;ISU\u117B\u117C\u1189\u11AF\u65A1ntersection;\u6293u\u0100bp\u118F\u119Eset\u0100;E\u1197\u1198\u628Fqual;\u6291erset\u0100;E\u11A8\u11A9\u6290qual;\u6292nion;\u6294cr;\uC000\u{1D4AE}ar;\u62C6\u0200bcmp\u11C8\u11DB\u1209\u120B\u0100;s\u11CD\u11CE\u62D0et\u0100;E\u11CD\u11D5qual;\u6286\u0100ch\u11E0\u1205eeds\u0200;EST\u11ED\u11EE\u11F4\u11FF\u627Bqual;\u6AB0lantEqual;\u627Dilde;\u627FTh\xE1\u0F8C;\u6211\u0180;es\u1212\u1213\u1223\u62D1rset\u0100;E\u121C\u121D\u6283qual;\u6287et\xBB\u1213\u0580HRSacfhiors\u123E\u1244\u1249\u1255\u125E\u1271\u1276\u129F\u12C2\u12C8\u12D1ORN\u803B\xDE\u40DEADE;\u6122\u0100Hc\u124E\u1252cy;\u440By;\u4426\u0100bu\u125A\u125C;\u4009;\u43A4\u0180aey\u1265\u126A\u126Fron;\u4164dil;\u4162;\u4422r;\uC000\u{1D517}\u0100ei\u127B\u1289\u01F2\u1280\0\u1287efore;\u6234a;\u4398\u0100cn\u128E\u1298kSpace;\uC000\u205F\u200ASpace;\u6009lde\u0200;EFT\u12AB\u12AC\u12B2\u12BC\u623Cqual;\u6243ullEqual;\u6245ilde;\u6248pf;\uC000\u{1D54B}ipleDot;\u60DB\u0100ct\u12D6\u12DBr;\uC000\u{1D4AF}rok;\u4166\u0AE1\u12F7\u130E\u131A\u1326\0\u132C\u1331\0\0\0\0\0\u1338\u133D\u1377\u1385\0\u13FF\u1404\u140A\u1410\u0100cr\u12FB\u1301ute\u803B\xDA\u40DAr\u0100;o\u1307\u1308\u619Fcir;\u6949r\u01E3\u1313\0\u1316y;\u440Eve;\u416C\u0100iy\u131E\u1323rc\u803B\xDB\u40DB;\u4423blac;\u4170r;\uC000\u{1D518}rave\u803B\xD9\u40D9acr;\u416A\u0100di\u1341\u1369er\u0100BP\u1348\u135D\u0100ar\u134D\u1350r;\u405Fac\u0100ek\u1357\u1359;\u63DFet;\u63B5arenthesis;\u63DDon\u0100;P\u1370\u1371\u62C3lus;\u628E\u0100gp\u137B\u137Fon;\u4172f;\uC000\u{1D54C}\u0400ADETadps\u1395\u13AE\u13B8\u13C4\u03E8\u13D2\u13D7\u13F3rrow\u0180;BD\u1150\u13A0\u13A4ar;\u6912ownArrow;\u61C5ownArrow;\u6195quilibrium;\u696Eee\u0100;A\u13CB\u13CC\u62A5rrow;\u61A5own\xE1\u03F3er\u0100LR\u13DE\u13E8eftArrow;\u6196ightArrow;\u6197i\u0100;l\u13F9\u13FA\u43D2on;\u43A5ing;\u416Ecr;\uC000\u{1D4B0}ilde;\u4168ml\u803B\xDC\u40DC\u0480Dbcdefosv\u1427\u142C\u1430\u1433\u143E\u1485\u148A\u1490\u1496ash;\u62ABar;\u6AEBy;\u4412ash\u0100;l\u143B\u143C\u62A9;\u6AE6\u0100er\u1443\u1445;\u62C1\u0180bty\u144C\u1450\u147Aar;\u6016\u0100;i\u144F\u1455cal\u0200BLST\u1461\u1465\u146A\u1474ar;\u6223ine;\u407Ceparator;\u6758ilde;\u6240ThinSpace;\u600Ar;\uC000\u{1D519}pf;\uC000\u{1D54D}cr;\uC000\u{1D4B1}dash;\u62AA\u0280cefos\u14A7\u14AC\u14B1\u14B6\u14BCirc;\u4174dge;\u62C0r;\uC000\u{1D51A}pf;\uC000\u{1D54E}cr;\uC000\u{1D4B2}\u0200fios\u14CB\u14D0\u14D2\u14D8r;\uC000\u{1D51B};\u439Epf;\uC000\u{1D54F}cr;\uC000\u{1D4B3}\u0480AIUacfosu\u14F1\u14F5\u14F9\u14FD\u1504\u150F\u1514\u151A\u1520cy;\u442Fcy;\u4407cy;\u442Ecute\u803B\xDD\u40DD\u0100iy\u1509\u150Drc;\u4176;\u442Br;\uC000\u{1D51C}pf;\uC000\u{1D550}cr;\uC000\u{1D4B4}ml;\u4178\u0400Hacdefos\u1535\u1539\u153F\u154B\u154F\u155D\u1560\u1564cy;\u4416cute;\u4179\u0100ay\u1544\u1549ron;\u417D;\u4417ot;\u417B\u01F2\u1554\0\u155BoWidt\xE8\u0AD9a;\u4396r;\u6128pf;\u6124cr;\uC000\u{1D4B5}\u0BE1\u1583\u158A\u1590\0\u15B0\u15B6\u15BF\0\0\0\0\u15C6\u15DB\u15EB\u165F\u166D\0\u1695\u169B\u16B2\u16B9\0\u16BEcute\u803B\xE1\u40E1reve;\u4103\u0300;Ediuy\u159C\u159D\u15A1\u15A3\u15A8\u15AD\u623E;\uC000\u223E\u0333;\u623Frc\u803B\xE2\u40E2te\u80BB\xB4\u0306;\u4430lig\u803B\xE6\u40E6\u0100;r\xB2\u15BA;\uC000\u{1D51E}rave\u803B\xE0\u40E0\u0100ep\u15CA\u15D6\u0100fp\u15CF\u15D4sym;\u6135\xE8\u15D3ha;\u43B1\u0100ap\u15DFc\u0100cl\u15E4\u15E7r;\u4101g;\u6A3F\u0264\u15F0\0\0\u160A\u0280;adsv\u15FA\u15FB\u15FF\u1601\u1607\u6227nd;\u6A55;\u6A5Clope;\u6A58;\u6A5A\u0380;elmrsz\u1618\u1619\u161B\u161E\u163F\u164F\u1659\u6220;\u69A4e\xBB\u1619sd\u0100;a\u1625\u1626\u6221\u0461\u1630\u1632\u1634\u1636\u1638\u163A\u163C\u163E;\u69A8;\u69A9;\u69AA;\u69AB;\u69AC;\u69AD;\u69AE;\u69AFt\u0100;v\u1645\u1646\u621Fb\u0100;d\u164C\u164D\u62BE;\u699D\u0100pt\u1654\u1657h;\u6222\xBB\xB9arr;\u637C\u0100gp\u1663\u1667on;\u4105f;\uC000\u{1D552}\u0380;Eaeiop\u12C1\u167B\u167D\u1682\u1684\u1687\u168A;\u6A70cir;\u6A6F;\u624Ad;\u624Bs;\u4027rox\u0100;e\u12C1\u1692\xF1\u1683ing\u803B\xE5\u40E5\u0180cty\u16A1\u16A6\u16A8r;\uC000\u{1D4B6};\u402Amp\u0100;e\u12C1\u16AF\xF1\u0288ilde\u803B\xE3\u40E3ml\u803B\xE4\u40E4\u0100ci\u16C2\u16C8onin\xF4\u0272nt;\u6A11\u0800Nabcdefiklnoprsu\u16ED\u16F1\u1730\u173C\u1743\u1748\u1778\u177D\u17E0\u17E6\u1839\u1850\u170D\u193D\u1948\u1970ot;\u6AED\u0100cr\u16F6\u171Ek\u0200ceps\u1700\u1705\u170D\u1713ong;\u624Cpsilon;\u43F6rime;\u6035im\u0100;e\u171A\u171B\u623Dq;\u62CD\u0176\u1722\u1726ee;\u62BDed\u0100;g\u172C\u172D\u6305e\xBB\u172Drk\u0100;t\u135C\u1737brk;\u63B6\u0100oy\u1701\u1741;\u4431quo;\u601E\u0280cmprt\u1753\u175B\u1761\u1764\u1768aus\u0100;e\u010A\u0109ptyv;\u69B0s\xE9\u170Cno\xF5\u0113\u0180ahw\u176F\u1771\u1773;\u43B2;\u6136een;\u626Cr;\uC000\u{1D51F}g\u0380costuvw\u178D\u179D\u17B3\u17C1\u17D5\u17DB\u17DE\u0180aiu\u1794\u1796\u179A\xF0\u0760rc;\u65EFp\xBB\u1371\u0180dpt\u17A4\u17A8\u17ADot;\u6A00lus;\u6A01imes;\u6A02\u0271\u17B9\0\0\u17BEcup;\u6A06ar;\u6605riangle\u0100du\u17CD\u17D2own;\u65BDp;\u65B3plus;\u6A04e\xE5\u1444\xE5\u14ADarow;\u690D\u0180ako\u17ED\u1826\u1835\u0100cn\u17F2\u1823k\u0180lst\u17FA\u05AB\u1802ozenge;\u69EBriangle\u0200;dlr\u1812\u1813\u1818\u181D\u65B4own;\u65BEeft;\u65C2ight;\u65B8k;\u6423\u01B1\u182B\0\u1833\u01B2\u182F\0\u1831;\u6592;\u65914;\u6593ck;\u6588\u0100eo\u183E\u184D\u0100;q\u1843\u1846\uC000=\u20E5uiv;\uC000\u2261\u20E5t;\u6310\u0200ptwx\u1859\u185E\u1867\u186Cf;\uC000\u{1D553}\u0100;t\u13CB\u1863om\xBB\u13CCtie;\u62C8\u0600DHUVbdhmptuv\u1885\u1896\u18AA\u18BB\u18D7\u18DB\u18EC\u18FF\u1905\u190A\u1910\u1921\u0200LRlr\u188E\u1890\u1892\u1894;\u6557;\u6554;\u6556;\u6553\u0280;DUdu\u18A1\u18A2\u18A4\u18A6\u18A8\u6550;\u6566;\u6569;\u6564;\u6567\u0200LRlr\u18B3\u18B5\u18B7\u18B9;\u655D;\u655A;\u655C;\u6559\u0380;HLRhlr\u18CA\u18CB\u18CD\u18CF\u18D1\u18D3\u18D5\u6551;\u656C;\u6563;\u6560;\u656B;\u6562;\u655Fox;\u69C9\u0200LRlr\u18E4\u18E6\u18E8\u18EA;\u6555;\u6552;\u6510;\u650C\u0280;DUdu\u06BD\u18F7\u18F9\u18FB\u18FD;\u6565;\u6568;\u652C;\u6534inus;\u629Flus;\u629Eimes;\u62A0\u0200LRlr\u1919\u191B\u191D\u191F;\u655B;\u6558;\u6518;\u6514\u0380;HLRhlr\u1930\u1931\u1933\u1935\u1937\u1939\u193B\u6502;\u656A;\u6561;\u655E;\u653C;\u6524;\u651C\u0100ev\u0123\u1942bar\u803B\xA6\u40A6\u0200ceio\u1951\u1956\u195A\u1960r;\uC000\u{1D4B7}mi;\u604Fm\u0100;e\u171A\u171Cl\u0180;bh\u1968\u1969\u196B\u405C;\u69C5sub;\u67C8\u016C\u1974\u197El\u0100;e\u1979\u197A\u6022t\xBB\u197Ap\u0180;Ee\u012F\u1985\u1987;\u6AAE\u0100;q\u06DC\u06DB\u0CE1\u19A7\0\u19E8\u1A11\u1A15\u1A32\0\u1A37\u1A50\0\0\u1AB4\0\0\u1AC1\0\0\u1B21\u1B2E\u1B4D\u1B52\0\u1BFD\0\u1C0C\u0180cpr\u19AD\u19B2\u19DDute;\u4107\u0300;abcds\u19BF\u19C0\u19C4\u19CA\u19D5\u19D9\u6229nd;\u6A44rcup;\u6A49\u0100au\u19CF\u19D2p;\u6A4Bp;\u6A47ot;\u6A40;\uC000\u2229\uFE00\u0100eo\u19E2\u19E5t;\u6041\xEE\u0693\u0200aeiu\u19F0\u19FB\u1A01\u1A05\u01F0\u19F5\0\u19F8s;\u6A4Don;\u410Ddil\u803B\xE7\u40E7rc;\u4109ps\u0100;s\u1A0C\u1A0D\u6A4Cm;\u6A50ot;\u410B\u0180dmn\u1A1B\u1A20\u1A26il\u80BB\xB8\u01ADptyv;\u69B2t\u8100\xA2;e\u1A2D\u1A2E\u40A2r\xE4\u01B2r;\uC000\u{1D520}\u0180cei\u1A3D\u1A40\u1A4Dy;\u4447ck\u0100;m\u1A47\u1A48\u6713ark\xBB\u1A48;\u43C7r\u0380;Ecefms\u1A5F\u1A60\u1A62\u1A6B\u1AA4\u1AAA\u1AAE\u65CB;\u69C3\u0180;el\u1A69\u1A6A\u1A6D\u42C6q;\u6257e\u0261\u1A74\0\0\u1A88rrow\u0100lr\u1A7C\u1A81eft;\u61BAight;\u61BB\u0280RSacd\u1A92\u1A94\u1A96\u1A9A\u1A9F\xBB\u0F47;\u64C8st;\u629Birc;\u629Aash;\u629Dnint;\u6A10id;\u6AEFcir;\u69C2ubs\u0100;u\u1ABB\u1ABC\u6663it\xBB\u1ABC\u02EC\u1AC7\u1AD4\u1AFA\0\u1B0Aon\u0100;e\u1ACD\u1ACE\u403A\u0100;q\xC7\xC6\u026D\u1AD9\0\0\u1AE2a\u0100;t\u1ADE\u1ADF\u402C;\u4040\u0180;fl\u1AE8\u1AE9\u1AEB\u6201\xEE\u1160e\u0100mx\u1AF1\u1AF6ent\xBB\u1AE9e\xF3\u024D\u01E7\u1AFE\0\u1B07\u0100;d\u12BB\u1B02ot;\u6A6Dn\xF4\u0246\u0180fry\u1B10\u1B14\u1B17;\uC000\u{1D554}o\xE4\u0254\u8100\xA9;s\u0155\u1B1Dr;\u6117\u0100ao\u1B25\u1B29rr;\u61B5ss;\u6717\u0100cu\u1B32\u1B37r;\uC000\u{1D4B8}\u0100bp\u1B3C\u1B44\u0100;e\u1B41\u1B42\u6ACF;\u6AD1\u0100;e\u1B49\u1B4A\u6AD0;\u6AD2dot;\u62EF\u0380delprvw\u1B60\u1B6C\u1B77\u1B82\u1BAC\u1BD4\u1BF9arr\u0100lr\u1B68\u1B6A;\u6938;\u6935\u0270\u1B72\0\0\u1B75r;\u62DEc;\u62DFarr\u0100;p\u1B7F\u1B80\u61B6;\u693D\u0300;bcdos\u1B8F\u1B90\u1B96\u1BA1\u1BA5\u1BA8\u622Arcap;\u6A48\u0100au\u1B9B\u1B9Ep;\u6A46p;\u6A4Aot;\u628Dr;\u6A45;\uC000\u222A\uFE00\u0200alrv\u1BB5\u1BBF\u1BDE\u1BE3rr\u0100;m\u1BBC\u1BBD\u61B7;\u693Cy\u0180evw\u1BC7\u1BD4\u1BD8q\u0270\u1BCE\0\0\u1BD2re\xE3\u1B73u\xE3\u1B75ee;\u62CEedge;\u62CFen\u803B\xA4\u40A4earrow\u0100lr\u1BEE\u1BF3eft\xBB\u1B80ight\xBB\u1BBDe\xE4\u1BDD\u0100ci\u1C01\u1C07onin\xF4\u01F7nt;\u6231lcty;\u632D\u0980AHabcdefhijlorstuwz\u1C38\u1C3B\u1C3F\u1C5D\u1C69\u1C75\u1C8A\u1C9E\u1CAC\u1CB7\u1CFB\u1CFF\u1D0D\u1D7B\u1D91\u1DAB\u1DBB\u1DC6\u1DCDr\xF2\u0381ar;\u6965\u0200glrs\u1C48\u1C4D\u1C52\u1C54ger;\u6020eth;\u6138\xF2\u1133h\u0100;v\u1C5A\u1C5B\u6010\xBB\u090A\u016B\u1C61\u1C67arow;\u690Fa\xE3\u0315\u0100ay\u1C6E\u1C73ron;\u410F;\u4434\u0180;ao\u0332\u1C7C\u1C84\u0100gr\u02BF\u1C81r;\u61CAtseq;\u6A77\u0180glm\u1C91\u1C94\u1C98\u803B\xB0\u40B0ta;\u43B4ptyv;\u69B1\u0100ir\u1CA3\u1CA8sht;\u697F;\uC000\u{1D521}ar\u0100lr\u1CB3\u1CB5\xBB\u08DC\xBB\u101E\u0280aegsv\u1CC2\u0378\u1CD6\u1CDC\u1CE0m\u0180;os\u0326\u1CCA\u1CD4nd\u0100;s\u0326\u1CD1uit;\u6666amma;\u43DDin;\u62F2\u0180;io\u1CE7\u1CE8\u1CF8\u40F7de\u8100\xF7;o\u1CE7\u1CF0ntimes;\u62C7n\xF8\u1CF7cy;\u4452c\u026F\u1D06\0\0\u1D0Arn;\u631Eop;\u630D\u0280lptuw\u1D18\u1D1D\u1D22\u1D49\u1D55lar;\u4024f;\uC000\u{1D555}\u0280;emps\u030B\u1D2D\u1D37\u1D3D\u1D42q\u0100;d\u0352\u1D33ot;\u6251inus;\u6238lus;\u6214quare;\u62A1blebarwedg\xE5\xFAn\u0180adh\u112E\u1D5D\u1D67ownarrow\xF3\u1C83arpoon\u0100lr\u1D72\u1D76ef\xF4\u1CB4igh\xF4\u1CB6\u0162\u1D7F\u1D85karo\xF7\u0F42\u026F\u1D8A\0\0\u1D8Ern;\u631Fop;\u630C\u0180cot\u1D98\u1DA3\u1DA6\u0100ry\u1D9D\u1DA1;\uC000\u{1D4B9};\u4455l;\u69F6rok;\u4111\u0100dr\u1DB0\u1DB4ot;\u62F1i\u0100;f\u1DBA\u1816\u65BF\u0100ah\u1DC0\u1DC3r\xF2\u0429a\xF2\u0FA6angle;\u69A6\u0100ci\u1DD2\u1DD5y;\u445Fgrarr;\u67FF\u0900Dacdefglmnopqrstux\u1E01\u1E09\u1E19\u1E38\u0578\u1E3C\u1E49\u1E61\u1E7E\u1EA5\u1EAF\u1EBD\u1EE1\u1F2A\u1F37\u1F44\u1F4E\u1F5A\u0100Do\u1E06\u1D34o\xF4\u1C89\u0100cs\u1E0E\u1E14ute\u803B\xE9\u40E9ter;\u6A6E\u0200aioy\u1E22\u1E27\u1E31\u1E36ron;\u411Br\u0100;c\u1E2D\u1E2E\u6256\u803B\xEA\u40EAlon;\u6255;\u444Dot;\u4117\u0100Dr\u1E41\u1E45ot;\u6252;\uC000\u{1D522}\u0180;rs\u1E50\u1E51\u1E57\u6A9Aave\u803B\xE8\u40E8\u0100;d\u1E5C\u1E5D\u6A96ot;\u6A98\u0200;ils\u1E6A\u1E6B\u1E72\u1E74\u6A99nters;\u63E7;\u6113\u0100;d\u1E79\u1E7A\u6A95ot;\u6A97\u0180aps\u1E85\u1E89\u1E97cr;\u4113ty\u0180;sv\u1E92\u1E93\u1E95\u6205et\xBB\u1E93p\u01001;\u1E9D\u1EA4\u0133\u1EA1\u1EA3;\u6004;\u6005\u6003\u0100gs\u1EAA\u1EAC;\u414Bp;\u6002\u0100gp\u1EB4\u1EB8on;\u4119f;\uC000\u{1D556}\u0180als\u1EC4\u1ECE\u1ED2r\u0100;s\u1ECA\u1ECB\u62D5l;\u69E3us;\u6A71i\u0180;lv\u1EDA\u1EDB\u1EDF\u43B5on\xBB\u1EDB;\u43F5\u0200csuv\u1EEA\u1EF3\u1F0B\u1F23\u0100io\u1EEF\u1E31rc\xBB\u1E2E\u0269\u1EF9\0\0\u1EFB\xED\u0548ant\u0100gl\u1F02\u1F06tr\xBB\u1E5Dess\xBB\u1E7A\u0180aei\u1F12\u1F16\u1F1Als;\u403Dst;\u625Fv\u0100;D\u0235\u1F20D;\u6A78parsl;\u69E5\u0100Da\u1F2F\u1F33ot;\u6253rr;\u6971\u0180cdi\u1F3E\u1F41\u1EF8r;\u612Fo\xF4\u0352\u0100ah\u1F49\u1F4B;\u43B7\u803B\xF0\u40F0\u0100mr\u1F53\u1F57l\u803B\xEB\u40EBo;\u60AC\u0180cip\u1F61\u1F64\u1F67l;\u4021s\xF4\u056E\u0100eo\u1F6C\u1F74ctatio\xEE\u0559nential\xE5\u0579\u09E1\u1F92\0\u1F9E\0\u1FA1\u1FA7\0\0\u1FC6\u1FCC\0\u1FD3\0\u1FE6\u1FEA\u2000\0\u2008\u205Allingdotse\xF1\u1E44y;\u4444male;\u6640\u0180ilr\u1FAD\u1FB3\u1FC1lig;\u8000\uFB03\u0269\u1FB9\0\0\u1FBDg;\u8000\uFB00ig;\u8000\uFB04;\uC000\u{1D523}lig;\u8000\uFB01lig;\uC000fj\u0180alt\u1FD9\u1FDC\u1FE1t;\u666Dig;\u8000\uFB02ns;\u65B1of;\u4192\u01F0\u1FEE\0\u1FF3f;\uC000\u{1D557}\u0100ak\u05BF\u1FF7\u0100;v\u1FFC\u1FFD\u62D4;\u6AD9artint;\u6A0D\u0100ao\u200C\u2055\u0100cs\u2011\u2052\u03B1\u201A\u2030\u2038\u2045\u2048\0\u2050\u03B2\u2022\u2025\u2027\u202A\u202C\0\u202E\u803B\xBD\u40BD;\u6153\u803B\xBC\u40BC;\u6155;\u6159;\u615B\u01B3\u2034\0\u2036;\u6154;\u6156\u02B4\u203E\u2041\0\0\u2043\u803B\xBE\u40BE;\u6157;\u615C5;\u6158\u01B6\u204C\0\u204E;\u615A;\u615D8;\u615El;\u6044wn;\u6322cr;\uC000\u{1D4BB}\u0880Eabcdefgijlnorstv\u2082\u2089\u209F\u20A5\u20B0\u20B4\u20F0\u20F5\u20FA\u20FF\u2103\u2112\u2138\u0317\u213E\u2152\u219E\u0100;l\u064D\u2087;\u6A8C\u0180cmp\u2090\u2095\u209Dute;\u41F5ma\u0100;d\u209C\u1CDA\u43B3;\u6A86reve;\u411F\u0100iy\u20AA\u20AErc;\u411D;\u4433ot;\u4121\u0200;lqs\u063E\u0642\u20BD\u20C9\u0180;qs\u063E\u064C\u20C4lan\xF4\u0665\u0200;cdl\u0665\u20D2\u20D5\u20E5c;\u6AA9ot\u0100;o\u20DC\u20DD\u6A80\u0100;l\u20E2\u20E3\u6A82;\u6A84\u0100;e\u20EA\u20ED\uC000\u22DB\uFE00s;\u6A94r;\uC000\u{1D524}\u0100;g\u0673\u061Bmel;\u6137cy;\u4453\u0200;Eaj\u065A\u210C\u210E\u2110;\u6A92;\u6AA5;\u6AA4\u0200Eaes\u211B\u211D\u2129\u2134;\u6269p\u0100;p\u2123\u2124\u6A8Arox\xBB\u2124\u0100;q\u212E\u212F\u6A88\u0100;q\u212E\u211Bim;\u62E7pf;\uC000\u{1D558}\u0100ci\u2143\u2146r;\u610Am\u0180;el\u066B\u214E\u2150;\u6A8E;\u6A90\u8300>;cdlqr\u05EE\u2160\u216A\u216E\u2173\u2179\u0100ci\u2165\u2167;\u6AA7r;\u6A7Aot;\u62D7Par;\u6995uest;\u6A7C\u0280adels\u2184\u216A\u2190\u0656\u219B\u01F0\u2189\0\u218Epro\xF8\u209Er;\u6978q\u0100lq\u063F\u2196les\xF3\u2088i\xED\u066B\u0100en\u21A3\u21ADrtneqq;\uC000\u2269\uFE00\xC5\u21AA\u0500Aabcefkosy\u21C4\u21C7\u21F1\u21F5\u21FA\u2218\u221D\u222F\u2268\u227Dr\xF2\u03A0\u0200ilmr\u21D0\u21D4\u21D7\u21DBrs\xF0\u1484f\xBB\u2024il\xF4\u06A9\u0100dr\u21E0\u21E4cy;\u444A\u0180;cw\u08F4\u21EB\u21EFir;\u6948;\u61ADar;\u610Firc;\u4125\u0180alr\u2201\u220E\u2213rts\u0100;u\u2209\u220A\u6665it\xBB\u220Alip;\u6026con;\u62B9r;\uC000\u{1D525}s\u0100ew\u2223\u2229arow;\u6925arow;\u6926\u0280amopr\u223A\u223E\u2243\u225E\u2263rr;\u61FFtht;\u623Bk\u0100lr\u2249\u2253eftarrow;\u61A9ightarrow;\u61AAf;\uC000\u{1D559}bar;\u6015\u0180clt\u226F\u2274\u2278r;\uC000\u{1D4BD}as\xE8\u21F4rok;\u4127\u0100bp\u2282\u2287ull;\u6043hen\xBB\u1C5B\u0AE1\u22A3\0\u22AA\0\u22B8\u22C5\u22CE\0\u22D5\u22F3\0\0\u22F8\u2322\u2367\u2362\u237F\0\u2386\u23AA\u23B4cute\u803B\xED\u40ED\u0180;iy\u0771\u22B0\u22B5rc\u803B\xEE\u40EE;\u4438\u0100cx\u22BC\u22BFy;\u4435cl\u803B\xA1\u40A1\u0100fr\u039F\u22C9;\uC000\u{1D526}rave\u803B\xEC\u40EC\u0200;ino\u073E\u22DD\u22E9\u22EE\u0100in\u22E2\u22E6nt;\u6A0Ct;\u622Dfin;\u69DCta;\u6129lig;\u4133\u0180aop\u22FE\u231A\u231D\u0180cgt\u2305\u2308\u2317r;\u412B\u0180elp\u071F\u230F\u2313in\xE5\u078Ear\xF4\u0720h;\u4131f;\u62B7ed;\u41B5\u0280;cfot\u04F4\u232C\u2331\u233D\u2341are;\u6105in\u0100;t\u2338\u2339\u621Eie;\u69DDdo\xF4\u2319\u0280;celp\u0757\u234C\u2350\u235B\u2361al;\u62BA\u0100gr\u2355\u2359er\xF3\u1563\xE3\u234Darhk;\u6A17rod;\u6A3C\u0200cgpt\u236F\u2372\u2376\u237By;\u4451on;\u412Ff;\uC000\u{1D55A}a;\u43B9uest\u803B\xBF\u40BF\u0100ci\u238A\u238Fr;\uC000\u{1D4BE}n\u0280;Edsv\u04F4\u239B\u239D\u23A1\u04F3;\u62F9ot;\u62F5\u0100;v\u23A6\u23A7\u62F4;\u62F3\u0100;i\u0777\u23AElde;\u4129\u01EB\u23B8\0\u23BCcy;\u4456l\u803B\xEF\u40EF\u0300cfmosu\u23CC\u23D7\u23DC\u23E1\u23E7\u23F5\u0100iy\u23D1\u23D5rc;\u4135;\u4439r;\uC000\u{1D527}ath;\u4237pf;\uC000\u{1D55B}\u01E3\u23EC\0\u23F1r;\uC000\u{1D4BF}rcy;\u4458kcy;\u4454\u0400acfghjos\u240B\u2416\u2422\u2427\u242D\u2431\u2435\u243Bppa\u0100;v\u2413\u2414\u43BA;\u43F0\u0100ey\u241B\u2420dil;\u4137;\u443Ar;\uC000\u{1D528}reen;\u4138cy;\u4445cy;\u445Cpf;\uC000\u{1D55C}cr;\uC000\u{1D4C0}\u0B80ABEHabcdefghjlmnoprstuv\u2470\u2481\u2486\u248D\u2491\u250E\u253D\u255A\u2580\u264E\u265E\u2665\u2679\u267D\u269A\u26B2\u26D8\u275D\u2768\u278B\u27C0\u2801\u2812\u0180art\u2477\u247A\u247Cr\xF2\u09C6\xF2\u0395ail;\u691Barr;\u690E\u0100;g\u0994\u248B;\u6A8Bar;\u6962\u0963\u24A5\0\u24AA\0\u24B1\0\0\0\0\0\u24B5\u24BA\0\u24C6\u24C8\u24CD\0\u24F9ute;\u413Amptyv;\u69B4ra\xEE\u084Cbda;\u43BBg\u0180;dl\u088E\u24C1\u24C3;\u6991\xE5\u088E;\u6A85uo\u803B\xAB\u40ABr\u0400;bfhlpst\u0899\u24DE\u24E6\u24E9\u24EB\u24EE\u24F1\u24F5\u0100;f\u089D\u24E3s;\u691Fs;\u691D\xEB\u2252p;\u61ABl;\u6939im;\u6973l;\u61A2\u0180;ae\u24FF\u2500\u2504\u6AABil;\u6919\u0100;s\u2509\u250A\u6AAD;\uC000\u2AAD\uFE00\u0180abr\u2515\u2519\u251Drr;\u690Crk;\u6772\u0100ak\u2522\u252Cc\u0100ek\u2528\u252A;\u407B;\u405B\u0100es\u2531\u2533;\u698Bl\u0100du\u2539\u253B;\u698F;\u698D\u0200aeuy\u2546\u254B\u2556\u2558ron;\u413E\u0100di\u2550\u2554il;\u413C\xEC\u08B0\xE2\u2529;\u443B\u0200cqrs\u2563\u2566\u256D\u257Da;\u6936uo\u0100;r\u0E19\u1746\u0100du\u2572\u2577har;\u6967shar;\u694Bh;\u61B2\u0280;fgqs\u258B\u258C\u0989\u25F3\u25FF\u6264t\u0280ahlrt\u2598\u25A4\u25B7\u25C2\u25E8rrow\u0100;t\u0899\u25A1a\xE9\u24F6arpoon\u0100du\u25AF\u25B4own\xBB\u045Ap\xBB\u0966eftarrows;\u61C7ight\u0180ahs\u25CD\u25D6\u25DErrow\u0100;s\u08F4\u08A7arpoon\xF3\u0F98quigarro\xF7\u21F0hreetimes;\u62CB\u0180;qs\u258B\u0993\u25FAlan\xF4\u09AC\u0280;cdgs\u09AC\u260A\u260D\u261D\u2628c;\u6AA8ot\u0100;o\u2614\u2615\u6A7F\u0100;r\u261A\u261B\u6A81;\u6A83\u0100;e\u2622\u2625\uC000\u22DA\uFE00s;\u6A93\u0280adegs\u2633\u2639\u263D\u2649\u264Bppro\xF8\u24C6ot;\u62D6q\u0100gq\u2643\u2645\xF4\u0989gt\xF2\u248C\xF4\u099Bi\xED\u09B2\u0180ilr\u2655\u08E1\u265Asht;\u697C;\uC000\u{1D529}\u0100;E\u099C\u2663;\u6A91\u0161\u2669\u2676r\u0100du\u25B2\u266E\u0100;l\u0965\u2673;\u696Alk;\u6584cy;\u4459\u0280;acht\u0A48\u2688\u268B\u2691\u2696r\xF2\u25C1orne\xF2\u1D08ard;\u696Bri;\u65FA\u0100io\u269F\u26A4dot;\u4140ust\u0100;a\u26AC\u26AD\u63B0che\xBB\u26AD\u0200Eaes\u26BB\u26BD\u26C9\u26D4;\u6268p\u0100;p\u26C3\u26C4\u6A89rox\xBB\u26C4\u0100;q\u26CE\u26CF\u6A87\u0100;q\u26CE\u26BBim;\u62E6\u0400abnoptwz\u26E9\u26F4\u26F7\u271A\u272F\u2741\u2747\u2750\u0100nr\u26EE\u26F1g;\u67ECr;\u61FDr\xEB\u08C1g\u0180lmr\u26FF\u270D\u2714eft\u0100ar\u09E6\u2707ight\xE1\u09F2apsto;\u67FCight\xE1\u09FDparrow\u0100lr\u2725\u2729ef\xF4\u24EDight;\u61AC\u0180afl\u2736\u2739\u273Dr;\u6985;\uC000\u{1D55D}us;\u6A2Dimes;\u6A34\u0161\u274B\u274Fst;\u6217\xE1\u134E\u0180;ef\u2757\u2758\u1800\u65CAnge\xBB\u2758ar\u0100;l\u2764\u2765\u4028t;\u6993\u0280achmt\u2773\u2776\u277C\u2785\u2787r\xF2\u08A8orne\xF2\u1D8Car\u0100;d\u0F98\u2783;\u696D;\u600Eri;\u62BF\u0300achiqt\u2798\u279D\u0A40\u27A2\u27AE\u27BBquo;\u6039r;\uC000\u{1D4C1}m\u0180;eg\u09B2\u27AA\u27AC;\u6A8D;\u6A8F\u0100bu\u252A\u27B3o\u0100;r\u0E1F\u27B9;\u601Arok;\u4142\u8400<;cdhilqr\u082B\u27D2\u2639\u27DC\u27E0\u27E5\u27EA\u27F0\u0100ci\u27D7\u27D9;\u6AA6r;\u6A79re\xE5\u25F2mes;\u62C9arr;\u6976uest;\u6A7B\u0100Pi\u27F5\u27F9ar;\u6996\u0180;ef\u2800\u092D\u181B\u65C3r\u0100du\u2807\u280Dshar;\u694Ahar;\u6966\u0100en\u2817\u2821rtneqq;\uC000\u2268\uFE00\xC5\u281E\u0700Dacdefhilnopsu\u2840\u2845\u2882\u288E\u2893\u28A0\u28A5\u28A8\u28DA\u28E2\u28E4\u0A83\u28F3\u2902Dot;\u623A\u0200clpr\u284E\u2852\u2863\u287Dr\u803B\xAF\u40AF\u0100et\u2857\u2859;\u6642\u0100;e\u285E\u285F\u6720se\xBB\u285F\u0100;s\u103B\u2868to\u0200;dlu\u103B\u2873\u2877\u287Bow\xEE\u048Cef\xF4\u090F\xF0\u13D1ker;\u65AE\u0100oy\u2887\u288Cmma;\u6A29;\u443Cash;\u6014asuredangle\xBB\u1626r;\uC000\u{1D52A}o;\u6127\u0180cdn\u28AF\u28B4\u28C9ro\u803B\xB5\u40B5\u0200;acd\u1464\u28BD\u28C0\u28C4s\xF4\u16A7ir;\u6AF0ot\u80BB\xB7\u01B5us\u0180;bd\u28D2\u1903\u28D3\u6212\u0100;u\u1D3C\u28D8;\u6A2A\u0163\u28DE\u28E1p;\u6ADB\xF2\u2212\xF0\u0A81\u0100dp\u28E9\u28EEels;\u62A7f;\uC000\u{1D55E}\u0100ct\u28F8\u28FDr;\uC000\u{1D4C2}pos\xBB\u159D\u0180;lm\u2909\u290A\u290D\u43BCtimap;\u62B8\u0C00GLRVabcdefghijlmoprstuvw\u2942\u2953\u297E\u2989\u2998\u29DA\u29E9\u2A15\u2A1A\u2A58\u2A5D\u2A83\u2A95\u2AA4\u2AA8\u2B04\u2B07\u2B44\u2B7F\u2BAE\u2C34\u2C67\u2C7C\u2CE9\u0100gt\u2947\u294B;\uC000\u22D9\u0338\u0100;v\u2950\u0BCF\uC000\u226B\u20D2\u0180elt\u295A\u2972\u2976ft\u0100ar\u2961\u2967rrow;\u61CDightarrow;\u61CE;\uC000\u22D8\u0338\u0100;v\u297B\u0C47\uC000\u226A\u20D2ightarrow;\u61CF\u0100Dd\u298E\u2993ash;\u62AFash;\u62AE\u0280bcnpt\u29A3\u29A7\u29AC\u29B1\u29CCla\xBB\u02DEute;\u4144g;\uC000\u2220\u20D2\u0280;Eiop\u0D84\u29BC\u29C0\u29C5\u29C8;\uC000\u2A70\u0338d;\uC000\u224B\u0338s;\u4149ro\xF8\u0D84ur\u0100;a\u29D3\u29D4\u666El\u0100;s\u29D3\u0B38\u01F3\u29DF\0\u29E3p\u80BB\xA0\u0B37mp\u0100;e\u0BF9\u0C00\u0280aeouy\u29F4\u29FE\u2A03\u2A10\u2A13\u01F0\u29F9\0\u29FB;\u6A43on;\u4148dil;\u4146ng\u0100;d\u0D7E\u2A0Aot;\uC000\u2A6D\u0338p;\u6A42;\u443Dash;\u6013\u0380;Aadqsx\u0B92\u2A29\u2A2D\u2A3B\u2A41\u2A45\u2A50rr;\u61D7r\u0100hr\u2A33\u2A36k;\u6924\u0100;o\u13F2\u13F0ot;\uC000\u2250\u0338ui\xF6\u0B63\u0100ei\u2A4A\u2A4Ear;\u6928\xED\u0B98ist\u0100;s\u0BA0\u0B9Fr;\uC000\u{1D52B}\u0200Eest\u0BC5\u2A66\u2A79\u2A7C\u0180;qs\u0BBC\u2A6D\u0BE1\u0180;qs\u0BBC\u0BC5\u2A74lan\xF4\u0BE2i\xED\u0BEA\u0100;r\u0BB6\u2A81\xBB\u0BB7\u0180Aap\u2A8A\u2A8D\u2A91r\xF2\u2971rr;\u61AEar;\u6AF2\u0180;sv\u0F8D\u2A9C\u0F8C\u0100;d\u2AA1\u2AA2\u62FC;\u62FAcy;\u445A\u0380AEadest\u2AB7\u2ABA\u2ABE\u2AC2\u2AC5\u2AF6\u2AF9r\xF2\u2966;\uC000\u2266\u0338rr;\u619Ar;\u6025\u0200;fqs\u0C3B\u2ACE\u2AE3\u2AEFt\u0100ar\u2AD4\u2AD9rro\xF7\u2AC1ightarro\xF7\u2A90\u0180;qs\u0C3B\u2ABA\u2AEAlan\xF4\u0C55\u0100;s\u0C55\u2AF4\xBB\u0C36i\xED\u0C5D\u0100;r\u0C35\u2AFEi\u0100;e\u0C1A\u0C25i\xE4\u0D90\u0100pt\u2B0C\u2B11f;\uC000\u{1D55F}\u8180\xAC;in\u2B19\u2B1A\u2B36\u40ACn\u0200;Edv\u0B89\u2B24\u2B28\u2B2E;\uC000\u22F9\u0338ot;\uC000\u22F5\u0338\u01E1\u0B89\u2B33\u2B35;\u62F7;\u62F6i\u0100;v\u0CB8\u2B3C\u01E1\u0CB8\u2B41\u2B43;\u62FE;\u62FD\u0180aor\u2B4B\u2B63\u2B69r\u0200;ast\u0B7B\u2B55\u2B5A\u2B5Flle\xEC\u0B7Bl;\uC000\u2AFD\u20E5;\uC000\u2202\u0338lint;\u6A14\u0180;ce\u0C92\u2B70\u2B73u\xE5\u0CA5\u0100;c\u0C98\u2B78\u0100;e\u0C92\u2B7D\xF1\u0C98\u0200Aait\u2B88\u2B8B\u2B9D\u2BA7r\xF2\u2988rr\u0180;cw\u2B94\u2B95\u2B99\u619B;\uC000\u2933\u0338;\uC000\u219D\u0338ghtarrow\xBB\u2B95ri\u0100;e\u0CCB\u0CD6\u0380chimpqu\u2BBD\u2BCD\u2BD9\u2B04\u0B78\u2BE4\u2BEF\u0200;cer\u0D32\u2BC6\u0D37\u2BC9u\xE5\u0D45;\uC000\u{1D4C3}ort\u026D\u2B05\0\0\u2BD6ar\xE1\u2B56m\u0100;e\u0D6E\u2BDF\u0100;q\u0D74\u0D73su\u0100bp\u2BEB\u2BED\xE5\u0CF8\xE5\u0D0B\u0180bcp\u2BF6\u2C11\u2C19\u0200;Ees\u2BFF\u2C00\u0D22\u2C04\u6284;\uC000\u2AC5\u0338et\u0100;e\u0D1B\u2C0Bq\u0100;q\u0D23\u2C00c\u0100;e\u0D32\u2C17\xF1\u0D38\u0200;Ees\u2C22\u2C23\u0D5F\u2C27\u6285;\uC000\u2AC6\u0338et\u0100;e\u0D58\u2C2Eq\u0100;q\u0D60\u2C23\u0200gilr\u2C3D\u2C3F\u2C45\u2C47\xEC\u0BD7lde\u803B\xF1\u40F1\xE7\u0C43iangle\u0100lr\u2C52\u2C5Ceft\u0100;e\u0C1A\u2C5A\xF1\u0C26ight\u0100;e\u0CCB\u2C65\xF1\u0CD7\u0100;m\u2C6C\u2C6D\u43BD\u0180;es\u2C74\u2C75\u2C79\u4023ro;\u6116p;\u6007\u0480DHadgilrs\u2C8F\u2C94\u2C99\u2C9E\u2CA3\u2CB0\u2CB6\u2CD3\u2CE3ash;\u62ADarr;\u6904p;\uC000\u224D\u20D2ash;\u62AC\u0100et\u2CA8\u2CAC;\uC000\u2265\u20D2;\uC000>\u20D2nfin;\u69DE\u0180Aet\u2CBD\u2CC1\u2CC5rr;\u6902;\uC000\u2264\u20D2\u0100;r\u2CCA\u2CCD\uC000<\u20D2ie;\uC000\u22B4\u20D2\u0100At\u2CD8\u2CDCrr;\u6903rie;\uC000\u22B5\u20D2im;\uC000\u223C\u20D2\u0180Aan\u2CF0\u2CF4\u2D02rr;\u61D6r\u0100hr\u2CFA\u2CFDk;\u6923\u0100;o\u13E7\u13E5ear;\u6927\u1253\u1A95\0\0\0\0\0\0\0\0\0\0\0\0\0\u2D2D\0\u2D38\u2D48\u2D60\u2D65\u2D72\u2D84\u1B07\0\0\u2D8D\u2DAB\0\u2DC8\u2DCE\0\u2DDC\u2E19\u2E2B\u2E3E\u2E43\u0100cs\u2D31\u1A97ute\u803B\xF3\u40F3\u0100iy\u2D3C\u2D45r\u0100;c\u1A9E\u2D42\u803B\xF4\u40F4;\u443E\u0280abios\u1AA0\u2D52\u2D57\u01C8\u2D5Alac;\u4151v;\u6A38old;\u69BClig;\u4153\u0100cr\u2D69\u2D6Dir;\u69BF;\uC000\u{1D52C}\u036F\u2D79\0\0\u2D7C\0\u2D82n;\u42DBave\u803B\xF2\u40F2;\u69C1\u0100bm\u2D88\u0DF4ar;\u69B5\u0200acit\u2D95\u2D98\u2DA5\u2DA8r\xF2\u1A80\u0100ir\u2D9D\u2DA0r;\u69BEoss;\u69BBn\xE5\u0E52;\u69C0\u0180aei\u2DB1\u2DB5\u2DB9cr;\u414Dga;\u43C9\u0180cdn\u2DC0\u2DC5\u01CDron;\u43BF;\u69B6pf;\uC000\u{1D560}\u0180ael\u2DD4\u2DD7\u01D2r;\u69B7rp;\u69B9\u0380;adiosv\u2DEA\u2DEB\u2DEE\u2E08\u2E0D\u2E10\u2E16\u6228r\xF2\u1A86\u0200;efm\u2DF7\u2DF8\u2E02\u2E05\u6A5Dr\u0100;o\u2DFE\u2DFF\u6134f\xBB\u2DFF\u803B\xAA\u40AA\u803B\xBA\u40BAgof;\u62B6r;\u6A56lope;\u6A57;\u6A5B\u0180clo\u2E1F\u2E21\u2E27\xF2\u2E01ash\u803B\xF8\u40F8l;\u6298i\u016C\u2E2F\u2E34de\u803B\xF5\u40F5es\u0100;a\u01DB\u2E3As;\u6A36ml\u803B\xF6\u40F6bar;\u633D\u0AE1\u2E5E\0\u2E7D\0\u2E80\u2E9D\0\u2EA2\u2EB9\0\0\u2ECB\u0E9C\0\u2F13\0\0\u2F2B\u2FBC\0\u2FC8r\u0200;ast\u0403\u2E67\u2E72\u0E85\u8100\xB6;l\u2E6D\u2E6E\u40B6le\xEC\u0403\u0269\u2E78\0\0\u2E7Bm;\u6AF3;\u6AFDy;\u443Fr\u0280cimpt\u2E8B\u2E8F\u2E93\u1865\u2E97nt;\u4025od;\u402Eil;\u6030enk;\u6031r;\uC000\u{1D52D}\u0180imo\u2EA8\u2EB0\u2EB4\u0100;v\u2EAD\u2EAE\u43C6;\u43D5ma\xF4\u0A76ne;\u660E\u0180;tv\u2EBF\u2EC0\u2EC8\u43C0chfork\xBB\u1FFD;\u43D6\u0100au\u2ECF\u2EDFn\u0100ck\u2ED5\u2EDDk\u0100;h\u21F4\u2EDB;\u610E\xF6\u21F4s\u0480;abcdemst\u2EF3\u2EF4\u1908\u2EF9\u2EFD\u2F04\u2F06\u2F0A\u2F0E\u402Bcir;\u6A23ir;\u6A22\u0100ou\u1D40\u2F02;\u6A25;\u6A72n\u80BB\xB1\u0E9Dim;\u6A26wo;\u6A27\u0180ipu\u2F19\u2F20\u2F25ntint;\u6A15f;\uC000\u{1D561}nd\u803B\xA3\u40A3\u0500;Eaceinosu\u0EC8\u2F3F\u2F41\u2F44\u2F47\u2F81\u2F89\u2F92\u2F7E\u2FB6;\u6AB3p;\u6AB7u\xE5\u0ED9\u0100;c\u0ECE\u2F4C\u0300;acens\u0EC8\u2F59\u2F5F\u2F66\u2F68\u2F7Eppro\xF8\u2F43urlye\xF1\u0ED9\xF1\u0ECE\u0180aes\u2F6F\u2F76\u2F7Approx;\u6AB9qq;\u6AB5im;\u62E8i\xED\u0EDFme\u0100;s\u2F88\u0EAE\u6032\u0180Eas\u2F78\u2F90\u2F7A\xF0\u2F75\u0180dfp\u0EEC\u2F99\u2FAF\u0180als\u2FA0\u2FA5\u2FAAlar;\u632Eine;\u6312urf;\u6313\u0100;t\u0EFB\u2FB4\xEF\u0EFBrel;\u62B0\u0100ci\u2FC0\u2FC5r;\uC000\u{1D4C5};\u43C8ncsp;\u6008\u0300fiopsu\u2FDA\u22E2\u2FDF\u2FE5\u2FEB\u2FF1r;\uC000\u{1D52E}pf;\uC000\u{1D562}rime;\u6057cr;\uC000\u{1D4C6}\u0180aeo\u2FF8\u3009\u3013t\u0100ei\u2FFE\u3005rnion\xF3\u06B0nt;\u6A16st\u0100;e\u3010\u3011\u403F\xF1\u1F19\xF4\u0F14\u0A80ABHabcdefhilmnoprstux\u3040\u3051\u3055\u3059\u30E0\u310E\u312B\u3147\u3162\u3172\u318E\u3206\u3215\u3224\u3229\u3258\u326E\u3272\u3290\u32B0\u32B7\u0180art\u3047\u304A\u304Cr\xF2\u10B3\xF2\u03DDail;\u691Car\xF2\u1C65ar;\u6964\u0380cdenqrt\u3068\u3075\u3078\u307F\u308F\u3094\u30CC\u0100eu\u306D\u3071;\uC000\u223D\u0331te;\u4155i\xE3\u116Emptyv;\u69B3g\u0200;del\u0FD1\u3089\u308B\u308D;\u6992;\u69A5\xE5\u0FD1uo\u803B\xBB\u40BBr\u0580;abcfhlpstw\u0FDC\u30AC\u30AF\u30B7\u30B9\u30BC\u30BE\u30C0\u30C3\u30C7\u30CAp;\u6975\u0100;f\u0FE0\u30B4s;\u6920;\u6933s;\u691E\xEB\u225D\xF0\u272El;\u6945im;\u6974l;\u61A3;\u619D\u0100ai\u30D1\u30D5il;\u691Ao\u0100;n\u30DB\u30DC\u6236al\xF3\u0F1E\u0180abr\u30E7\u30EA\u30EEr\xF2\u17E5rk;\u6773\u0100ak\u30F3\u30FDc\u0100ek\u30F9\u30FB;\u407D;\u405D\u0100es\u3102\u3104;\u698Cl\u0100du\u310A\u310C;\u698E;\u6990\u0200aeuy\u3117\u311C\u3127\u3129ron;\u4159\u0100di\u3121\u3125il;\u4157\xEC\u0FF2\xE2\u30FA;\u4440\u0200clqs\u3134\u3137\u313D\u3144a;\u6937dhar;\u6969uo\u0100;r\u020E\u020Dh;\u61B3\u0180acg\u314E\u315F\u0F44l\u0200;ips\u0F78\u3158\u315B\u109Cn\xE5\u10BBar\xF4\u0FA9t;\u65AD\u0180ilr\u3169\u1023\u316Esht;\u697D;\uC000\u{1D52F}\u0100ao\u3177\u3186r\u0100du\u317D\u317F\xBB\u047B\u0100;l\u1091\u3184;\u696C\u0100;v\u318B\u318C\u43C1;\u43F1\u0180gns\u3195\u31F9\u31FCht\u0300ahlrst\u31A4\u31B0\u31C2\u31D8\u31E4\u31EErrow\u0100;t\u0FDC\u31ADa\xE9\u30C8arpoon\u0100du\u31BB\u31BFow\xEE\u317Ep\xBB\u1092eft\u0100ah\u31CA\u31D0rrow\xF3\u0FEAarpoon\xF3\u0551ightarrows;\u61C9quigarro\xF7\u30CBhreetimes;\u62CCg;\u42DAingdotse\xF1\u1F32\u0180ahm\u320D\u3210\u3213r\xF2\u0FEAa\xF2\u0551;\u600Foust\u0100;a\u321E\u321F\u63B1che\xBB\u321Fmid;\u6AEE\u0200abpt\u3232\u323D\u3240\u3252\u0100nr\u3237\u323Ag;\u67EDr;\u61FEr\xEB\u1003\u0180afl\u3247\u324A\u324Er;\u6986;\uC000\u{1D563}us;\u6A2Eimes;\u6A35\u0100ap\u325D\u3267r\u0100;g\u3263\u3264\u4029t;\u6994olint;\u6A12ar\xF2\u31E3\u0200achq\u327B\u3280\u10BC\u3285quo;\u603Ar;\uC000\u{1D4C7}\u0100bu\u30FB\u328Ao\u0100;r\u0214\u0213\u0180hir\u3297\u329B\u32A0re\xE5\u31F8mes;\u62CAi\u0200;efl\u32AA\u1059\u1821\u32AB\u65B9tri;\u69CEluhar;\u6968;\u611E\u0D61\u32D5\u32DB\u32DF\u332C\u3338\u3371\0\u337A\u33A4\0\0\u33EC\u33F0\0\u3428\u3448\u345A\u34AD\u34B1\u34CA\u34F1\0\u3616\0\0\u3633cute;\u415Bqu\xEF\u27BA\u0500;Eaceinpsy\u11ED\u32F3\u32F5\u32FF\u3302\u330B\u330F\u331F\u3326\u3329;\u6AB4\u01F0\u32FA\0\u32FC;\u6AB8on;\u4161u\xE5\u11FE\u0100;d\u11F3\u3307il;\u415Frc;\u415D\u0180Eas\u3316\u3318\u331B;\u6AB6p;\u6ABAim;\u62E9olint;\u6A13i\xED\u1204;\u4441ot\u0180;be\u3334\u1D47\u3335\u62C5;\u6A66\u0380Aacmstx\u3346\u334A\u3357\u335B\u335E\u3363\u336Drr;\u61D8r\u0100hr\u3350\u3352\xEB\u2228\u0100;o\u0A36\u0A34t\u803B\xA7\u40A7i;\u403Bwar;\u6929m\u0100in\u3369\xF0nu\xF3\xF1t;\u6736r\u0100;o\u3376\u2055\uC000\u{1D530}\u0200acoy\u3382\u3386\u3391\u33A0rp;\u666F\u0100hy\u338B\u338Fcy;\u4449;\u4448rt\u026D\u3399\0\0\u339Ci\xE4\u1464ara\xEC\u2E6F\u803B\xAD\u40AD\u0100gm\u33A8\u33B4ma\u0180;fv\u33B1\u33B2\u33B2\u43C3;\u43C2\u0400;deglnpr\u12AB\u33C5\u33C9\u33CE\u33D6\u33DE\u33E1\u33E6ot;\u6A6A\u0100;q\u12B1\u12B0\u0100;E\u33D3\u33D4\u6A9E;\u6AA0\u0100;E\u33DB\u33DC\u6A9D;\u6A9Fe;\u6246lus;\u6A24arr;\u6972ar\xF2\u113D\u0200aeit\u33F8\u3408\u340F\u3417\u0100ls\u33FD\u3404lsetm\xE9\u336Ahp;\u6A33parsl;\u69E4\u0100dl\u1463\u3414e;\u6323\u0100;e\u341C\u341D\u6AAA\u0100;s\u3422\u3423\u6AAC;\uC000\u2AAC\uFE00\u0180flp\u342E\u3433\u3442tcy;\u444C\u0100;b\u3438\u3439\u402F\u0100;a\u343E\u343F\u69C4r;\u633Ff;\uC000\u{1D564}a\u0100dr\u344D\u0402es\u0100;u\u3454\u3455\u6660it\xBB\u3455\u0180csu\u3460\u3479\u349F\u0100au\u3465\u346Fp\u0100;s\u1188\u346B;\uC000\u2293\uFE00p\u0100;s\u11B4\u3475;\uC000\u2294\uFE00u\u0100bp\u347F\u348F\u0180;es\u1197\u119C\u3486et\u0100;e\u1197\u348D\xF1\u119D\u0180;es\u11A8\u11AD\u3496et\u0100;e\u11A8\u349D\xF1\u11AE\u0180;af\u117B\u34A6\u05B0r\u0165\u34AB\u05B1\xBB\u117Car\xF2\u1148\u0200cemt\u34B9\u34BE\u34C2\u34C5r;\uC000\u{1D4C8}tm\xEE\xF1i\xEC\u3415ar\xE6\u11BE\u0100ar\u34CE\u34D5r\u0100;f\u34D4\u17BF\u6606\u0100an\u34DA\u34EDight\u0100ep\u34E3\u34EApsilo\xEE\u1EE0h\xE9\u2EAFs\xBB\u2852\u0280bcmnp\u34FB\u355E\u1209\u358B\u358E\u0480;Edemnprs\u350E\u350F\u3511\u3515\u351E\u3523\u352C\u3531\u3536\u6282;\u6AC5ot;\u6ABD\u0100;d\u11DA\u351Aot;\u6AC3ult;\u6AC1\u0100Ee\u3528\u352A;\u6ACB;\u628Alus;\u6ABFarr;\u6979\u0180eiu\u353D\u3552\u3555t\u0180;en\u350E\u3545\u354Bq\u0100;q\u11DA\u350Feq\u0100;q\u352B\u3528m;\u6AC7\u0100bp\u355A\u355C;\u6AD5;\u6AD3c\u0300;acens\u11ED\u356C\u3572\u3579\u357B\u3326ppro\xF8\u32FAurlye\xF1\u11FE\xF1\u11F3\u0180aes\u3582\u3588\u331Bppro\xF8\u331Aq\xF1\u3317g;\u666A\u0680123;Edehlmnps\u35A9\u35AC\u35AF\u121C\u35B2\u35B4\u35C0\u35C9\u35D5\u35DA\u35DF\u35E8\u35ED\u803B\xB9\u40B9\u803B\xB2\u40B2\u803B\xB3\u40B3;\u6AC6\u0100os\u35B9\u35BCt;\u6ABEub;\u6AD8\u0100;d\u1222\u35C5ot;\u6AC4s\u0100ou\u35CF\u35D2l;\u67C9b;\u6AD7arr;\u697Bult;\u6AC2\u0100Ee\u35E4\u35E6;\u6ACC;\u628Blus;\u6AC0\u0180eiu\u35F4\u3609\u360Ct\u0180;en\u121C\u35FC\u3602q\u0100;q\u1222\u35B2eq\u0100;q\u35E7\u35E4m;\u6AC8\u0100bp\u3611\u3613;\u6AD4;\u6AD6\u0180Aan\u361C\u3620\u362Drr;\u61D9r\u0100hr\u3626\u3628\xEB\u222E\u0100;o\u0A2B\u0A29war;\u692Alig\u803B\xDF\u40DF\u0BE1\u3651\u365D\u3660\u12CE\u3673\u3679\0\u367E\u36C2\0\0\0\0\0\u36DB\u3703\0\u3709\u376C\0\0\0\u3787\u0272\u3656\0\0\u365Bget;\u6316;\u43C4r\xEB\u0E5F\u0180aey\u3666\u366B\u3670ron;\u4165dil;\u4163;\u4442lrec;\u6315r;\uC000\u{1D531}\u0200eiko\u3686\u369D\u36B5\u36BC\u01F2\u368B\0\u3691e\u01004f\u1284\u1281a\u0180;sv\u3698\u3699\u369B\u43B8ym;\u43D1\u0100cn\u36A2\u36B2k\u0100as\u36A8\u36AEppro\xF8\u12C1im\xBB\u12ACs\xF0\u129E\u0100as\u36BA\u36AE\xF0\u12C1rn\u803B\xFE\u40FE\u01EC\u031F\u36C6\u22E7es\u8180\xD7;bd\u36CF\u36D0\u36D8\u40D7\u0100;a\u190F\u36D5r;\u6A31;\u6A30\u0180eps\u36E1\u36E3\u3700\xE1\u2A4D\u0200;bcf\u0486\u36EC\u36F0\u36F4ot;\u6336ir;\u6AF1\u0100;o\u36F9\u36FC\uC000\u{1D565}rk;\u6ADA\xE1\u3362rime;\u6034\u0180aip\u370F\u3712\u3764d\xE5\u1248\u0380adempst\u3721\u374D\u3740\u3751\u3757\u375C\u375Fngle\u0280;dlqr\u3730\u3731\u3736\u3740\u3742\u65B5own\xBB\u1DBBeft\u0100;e\u2800\u373E\xF1\u092E;\u625Cight\u0100;e\u32AA\u374B\xF1\u105Aot;\u65ECinus;\u6A3Alus;\u6A39b;\u69CDime;\u6A3Bezium;\u63E2\u0180cht\u3772\u377D\u3781\u0100ry\u3777\u377B;\uC000\u{1D4C9};\u4446cy;\u445Brok;\u4167\u0100io\u378B\u378Ex\xF4\u1777head\u0100lr\u3797\u37A0eftarro\xF7\u084Fightarrow\xBB\u0F5D\u0900AHabcdfghlmoprstuw\u37D0\u37D3\u37D7\u37E4\u37F0\u37FC\u380E\u381C\u3823\u3834\u3851\u385D\u386B\u38A9\u38CC\u38D2\u38EA\u38F6r\xF2\u03EDar;\u6963\u0100cr\u37DC\u37E2ute\u803B\xFA\u40FA\xF2\u1150r\u01E3\u37EA\0\u37EDy;\u445Eve;\u416D\u0100iy\u37F5\u37FArc\u803B\xFB\u40FB;\u4443\u0180abh\u3803\u3806\u380Br\xF2\u13ADlac;\u4171a\xF2\u13C3\u0100ir\u3813\u3818sht;\u697E;\uC000\u{1D532}rave\u803B\xF9\u40F9\u0161\u3827\u3831r\u0100lr\u382C\u382E\xBB\u0957\xBB\u1083lk;\u6580\u0100ct\u3839\u384D\u026F\u383F\0\0\u384Arn\u0100;e\u3845\u3846\u631Cr\xBB\u3846op;\u630Fri;\u65F8\u0100al\u3856\u385Acr;\u416B\u80BB\xA8\u0349\u0100gp\u3862\u3866on;\u4173f;\uC000\u{1D566}\u0300adhlsu\u114B\u3878\u387D\u1372\u3891\u38A0own\xE1\u13B3arpoon\u0100lr\u3888\u388Cef\xF4\u382Digh\xF4\u382Fi\u0180;hl\u3899\u389A\u389C\u43C5\xBB\u13FAon\xBB\u389Aparrows;\u61C8\u0180cit\u38B0\u38C4\u38C8\u026F\u38B6\0\0\u38C1rn\u0100;e\u38BC\u38BD\u631Dr\xBB\u38BDop;\u630Eng;\u416Fri;\u65F9cr;\uC000\u{1D4CA}\u0180dir\u38D9\u38DD\u38E2ot;\u62F0lde;\u4169i\u0100;f\u3730\u38E8\xBB\u1813\u0100am\u38EF\u38F2r\xF2\u38A8l\u803B\xFC\u40FCangle;\u69A7\u0780ABDacdeflnoprsz\u391C\u391F\u3929\u392D\u39B5\u39B8\u39BD\u39DF\u39E4\u39E8\u39F3\u39F9\u39FD\u3A01\u3A20r\xF2\u03F7ar\u0100;v\u3926\u3927\u6AE8;\u6AE9as\xE8\u03E1\u0100nr\u3932\u3937grt;\u699C\u0380eknprst\u34E3\u3946\u394B\u3952\u395D\u3964\u3996app\xE1\u2415othin\xE7\u1E96\u0180hir\u34EB\u2EC8\u3959op\xF4\u2FB5\u0100;h\u13B7\u3962\xEF\u318D\u0100iu\u3969\u396Dgm\xE1\u33B3\u0100bp\u3972\u3984setneq\u0100;q\u397D\u3980\uC000\u228A\uFE00;\uC000\u2ACB\uFE00setneq\u0100;q\u398F\u3992\uC000\u228B\uFE00;\uC000\u2ACC\uFE00\u0100hr\u399B\u399Fet\xE1\u369Ciangle\u0100lr\u39AA\u39AFeft\xBB\u0925ight\xBB\u1051y;\u4432ash\xBB\u1036\u0180elr\u39C4\u39D2\u39D7\u0180;be\u2DEA\u39CB\u39CFar;\u62BBq;\u625Alip;\u62EE\u0100bt\u39DC\u1468a\xF2\u1469r;\uC000\u{1D533}tr\xE9\u39AEsu\u0100bp\u39EF\u39F1\xBB\u0D1C\xBB\u0D59pf;\uC000\u{1D567}ro\xF0\u0EFBtr\xE9\u39B4\u0100cu\u3A06\u3A0Br;\uC000\u{1D4CB}\u0100bp\u3A10\u3A18n\u0100Ee\u3980\u3A16\xBB\u397En\u0100Ee\u3992\u3A1E\xBB\u3990igzag;\u699A\u0380cefoprs\u3A36\u3A3B\u3A56\u3A5B\u3A54\u3A61\u3A6Airc;\u4175\u0100di\u3A40\u3A51\u0100bg\u3A45\u3A49ar;\u6A5Fe\u0100;q\u15FA\u3A4F;\u6259erp;\u6118r;\uC000\u{1D534}pf;\uC000\u{1D568}\u0100;e\u1479\u3A66at\xE8\u1479cr;\uC000\u{1D4CC}\u0AE3\u178E\u3A87\0\u3A8B\0\u3A90\u3A9B\0\0\u3A9D\u3AA8\u3AAB\u3AAF\0\0\u3AC3\u3ACE\0\u3AD8\u17DC\u17DFtr\xE9\u17D1r;\uC000\u{1D535}\u0100Aa\u3A94\u3A97r\xF2\u03C3r\xF2\u09F6;\u43BE\u0100Aa\u3AA1\u3AA4r\xF2\u03B8r\xF2\u09EBa\xF0\u2713is;\u62FB\u0180dpt\u17A4\u3AB5\u3ABE\u0100fl\u3ABA\u17A9;\uC000\u{1D569}im\xE5\u17B2\u0100Aa\u3AC7\u3ACAr\xF2\u03CEr\xF2\u0A01\u0100cq\u3AD2\u17B8r;\uC000\u{1D4CD}\u0100pt\u17D6\u3ADCr\xE9\u17D4\u0400acefiosu\u3AF0\u3AFD\u3B08\u3B0C\u3B11\u3B15\u3B1B\u3B21c\u0100uy\u3AF6\u3AFBte\u803B\xFD\u40FD;\u444F\u0100iy\u3B02\u3B06rc;\u4177;\u444Bn\u803B\xA5\u40A5r;\uC000\u{1D536}cy;\u4457pf;\uC000\u{1D56A}cr;\uC000\u{1D4CE}\u0100cm\u3B26\u3B29y;\u444El\u803B\xFF\u40FF\u0500acdefhiosw\u3B42\u3B48\u3B54\u3B58\u3B64\u3B69\u3B6D\u3B74\u3B7A\u3B80cute;\u417A\u0100ay\u3B4D\u3B52ron;\u417E;\u4437ot;\u417C\u0100et\u3B5D\u3B61tr\xE6\u155Fa;\u43B6r;\uC000\u{1D537}cy;\u4436grarr;\u61DDpf;\uC000\u{1D56B}cr;\uC000\u{1D4CF}\u0100jn\u3B85\u3B87;\u600Dj;\u600C'.split("").map((c) => c.charCodeAt(0))
);

// node_modules/entities/dist/esm/decode-codepoint.js
var _a;
var decodeMap = /* @__PURE__ */ new Map([
  [0, 65533],
  // C1 Unicode control character reference replacements
  [128, 8364],
  [130, 8218],
  [131, 402],
  [132, 8222],
  [133, 8230],
  [134, 8224],
  [135, 8225],
  [136, 710],
  [137, 8240],
  [138, 352],
  [139, 8249],
  [140, 338],
  [142, 381],
  [145, 8216],
  [146, 8217],
  [147, 8220],
  [148, 8221],
  [149, 8226],
  [150, 8211],
  [151, 8212],
  [152, 732],
  [153, 8482],
  [154, 353],
  [155, 8250],
  [156, 339],
  [158, 382],
  [159, 376]
]);
var fromCodePoint = (
  // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition, n/no-unsupported-features/es-builtins
  (_a = String.fromCodePoint) !== null && _a !== void 0 ? _a : function(codePoint) {
    let output = "";
    if (codePoint > 65535) {
      codePoint -= 65536;
      output += String.fromCharCode(codePoint >>> 10 & 1023 | 55296);
      codePoint = 56320 | codePoint & 1023;
    }
    output += String.fromCharCode(codePoint);
    return output;
  }
);
function replaceCodePoint(codePoint) {
  var _a3;
  if (codePoint >= 55296 && codePoint <= 57343 || codePoint > 1114111) {
    return 65533;
  }
  return (_a3 = decodeMap.get(codePoint)) !== null && _a3 !== void 0 ? _a3 : codePoint;
}

// node_modules/entities/dist/esm/decode.js
var CharCodes;
(function(CharCodes2) {
  CharCodes2[CharCodes2["NUM"] = 35] = "NUM";
  CharCodes2[CharCodes2["SEMI"] = 59] = "SEMI";
  CharCodes2[CharCodes2["EQUALS"] = 61] = "EQUALS";
  CharCodes2[CharCodes2["ZERO"] = 48] = "ZERO";
  CharCodes2[CharCodes2["NINE"] = 57] = "NINE";
  CharCodes2[CharCodes2["LOWER_A"] = 97] = "LOWER_A";
  CharCodes2[CharCodes2["LOWER_F"] = 102] = "LOWER_F";
  CharCodes2[CharCodes2["LOWER_X"] = 120] = "LOWER_X";
  CharCodes2[CharCodes2["LOWER_Z"] = 122] = "LOWER_Z";
  CharCodes2[CharCodes2["UPPER_A"] = 65] = "UPPER_A";
  CharCodes2[CharCodes2["UPPER_F"] = 70] = "UPPER_F";
  CharCodes2[CharCodes2["UPPER_Z"] = 90] = "UPPER_Z";
})(CharCodes || (CharCodes = {}));
var TO_LOWER_BIT = 32;
var BinTrieFlags;
(function(BinTrieFlags2) {
  BinTrieFlags2[BinTrieFlags2["VALUE_LENGTH"] = 49152] = "VALUE_LENGTH";
  BinTrieFlags2[BinTrieFlags2["BRANCH_LENGTH"] = 16256] = "BRANCH_LENGTH";
  BinTrieFlags2[BinTrieFlags2["JUMP_TABLE"] = 127] = "JUMP_TABLE";
})(BinTrieFlags || (BinTrieFlags = {}));
function isNumber(code) {
  return code >= CharCodes.ZERO && code <= CharCodes.NINE;
}
function isHexadecimalCharacter(code) {
  return code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_F || code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_F;
}
function isAsciiAlphaNumeric(code) {
  return code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_Z || code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_Z || isNumber(code);
}
function isEntityInAttributeInvalidEnd(code) {
  return code === CharCodes.EQUALS || isAsciiAlphaNumeric(code);
}
var EntityDecoderState;
(function(EntityDecoderState2) {
  EntityDecoderState2[EntityDecoderState2["EntityStart"] = 0] = "EntityStart";
  EntityDecoderState2[EntityDecoderState2["NumericStart"] = 1] = "NumericStart";
  EntityDecoderState2[EntityDecoderState2["NumericDecimal"] = 2] = "NumericDecimal";
  EntityDecoderState2[EntityDecoderState2["NumericHex"] = 3] = "NumericHex";
  EntityDecoderState2[EntityDecoderState2["NamedEntity"] = 4] = "NamedEntity";
})(EntityDecoderState || (EntityDecoderState = {}));
var DecodingMode;
(function(DecodingMode2) {
  DecodingMode2[DecodingMode2["Legacy"] = 0] = "Legacy";
  DecodingMode2[DecodingMode2["Strict"] = 1] = "Strict";
  DecodingMode2[DecodingMode2["Attribute"] = 2] = "Attribute";
})(DecodingMode || (DecodingMode = {}));
var EntityDecoder = class {
  constructor(decodeTree, emitCodePoint, errors) {
    this.decodeTree = decodeTree;
    this.emitCodePoint = emitCodePoint;
    this.errors = errors;
    this.state = EntityDecoderState.EntityStart;
    this.consumed = 1;
    this.result = 0;
    this.treeIndex = 0;
    this.excess = 1;
    this.decodeMode = DecodingMode.Strict;
  }
  /** Resets the instance to make it reusable. */
  startEntity(decodeMode) {
    this.decodeMode = decodeMode;
    this.state = EntityDecoderState.EntityStart;
    this.result = 0;
    this.treeIndex = 0;
    this.excess = 1;
    this.consumed = 1;
  }
  /**
   * Write an entity to the decoder. This can be called multiple times with partial entities.
   * If the entity is incomplete, the decoder will return -1.
   *
   * Mirrors the implementation of `getDecoder`, but with the ability to stop decoding if the
   * entity is incomplete, and resume when the next string is written.
   *
   * @param input The string containing the entity (or a continuation of the entity).
   * @param offset The offset at which the entity begins. Should be 0 if this is not the first call.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  write(input, offset) {
    switch (this.state) {
      case EntityDecoderState.EntityStart: {
        if (input.charCodeAt(offset) === CharCodes.NUM) {
          this.state = EntityDecoderState.NumericStart;
          this.consumed += 1;
          return this.stateNumericStart(input, offset + 1);
        }
        this.state = EntityDecoderState.NamedEntity;
        return this.stateNamedEntity(input, offset);
      }
      case EntityDecoderState.NumericStart: {
        return this.stateNumericStart(input, offset);
      }
      case EntityDecoderState.NumericDecimal: {
        return this.stateNumericDecimal(input, offset);
      }
      case EntityDecoderState.NumericHex: {
        return this.stateNumericHex(input, offset);
      }
      case EntityDecoderState.NamedEntity: {
        return this.stateNamedEntity(input, offset);
      }
    }
  }
  /**
   * Switches between the numeric decimal and hexadecimal states.
   *
   * Equivalent to the `Numeric character reference state` in the HTML spec.
   *
   * @param input The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  stateNumericStart(input, offset) {
    if (offset >= input.length) {
      return -1;
    }
    if ((input.charCodeAt(offset) | TO_LOWER_BIT) === CharCodes.LOWER_X) {
      this.state = EntityDecoderState.NumericHex;
      this.consumed += 1;
      return this.stateNumericHex(input, offset + 1);
    }
    this.state = EntityDecoderState.NumericDecimal;
    return this.stateNumericDecimal(input, offset);
  }
  addToNumericResult(input, start, end, base) {
    if (start !== end) {
      const digitCount = end - start;
      this.result = this.result * Math.pow(base, digitCount) + Number.parseInt(input.substr(start, digitCount), base);
      this.consumed += digitCount;
    }
  }
  /**
   * Parses a hexadecimal numeric entity.
   *
   * Equivalent to the `Hexademical character reference state` in the HTML spec.
   *
   * @param input The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  stateNumericHex(input, offset) {
    const startIndex = offset;
    while (offset < input.length) {
      const char = input.charCodeAt(offset);
      if (isNumber(char) || isHexadecimalCharacter(char)) {
        offset += 1;
      } else {
        this.addToNumericResult(input, startIndex, offset, 16);
        return this.emitNumericEntity(char, 3);
      }
    }
    this.addToNumericResult(input, startIndex, offset, 16);
    return -1;
  }
  /**
   * Parses a decimal numeric entity.
   *
   * Equivalent to the `Decimal character reference state` in the HTML spec.
   *
   * @param input The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  stateNumericDecimal(input, offset) {
    const startIndex = offset;
    while (offset < input.length) {
      const char = input.charCodeAt(offset);
      if (isNumber(char)) {
        offset += 1;
      } else {
        this.addToNumericResult(input, startIndex, offset, 10);
        return this.emitNumericEntity(char, 2);
      }
    }
    this.addToNumericResult(input, startIndex, offset, 10);
    return -1;
  }
  /**
   * Validate and emit a numeric entity.
   *
   * Implements the logic from the `Hexademical character reference start
   * state` and `Numeric character reference end state` in the HTML spec.
   *
   * @param lastCp The last code point of the entity. Used to see if the
   *               entity was terminated with a semicolon.
   * @param expectedLength The minimum number of characters that should be
   *                       consumed. Used to validate that at least one digit
   *                       was consumed.
   * @returns The number of characters that were consumed.
   */
  emitNumericEntity(lastCp, expectedLength) {
    var _a3;
    if (this.consumed <= expectedLength) {
      (_a3 = this.errors) === null || _a3 === void 0 ? void 0 : _a3.absenceOfDigitsInNumericCharacterReference(this.consumed);
      return 0;
    }
    if (lastCp === CharCodes.SEMI) {
      this.consumed += 1;
    } else if (this.decodeMode === DecodingMode.Strict) {
      return 0;
    }
    this.emitCodePoint(replaceCodePoint(this.result), this.consumed);
    if (this.errors) {
      if (lastCp !== CharCodes.SEMI) {
        this.errors.missingSemicolonAfterCharacterReference();
      }
      this.errors.validateNumericCharacterReference(this.result);
    }
    return this.consumed;
  }
  /**
   * Parses a named entity.
   *
   * Equivalent to the `Named character reference state` in the HTML spec.
   *
   * @param input The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  stateNamedEntity(input, offset) {
    const { decodeTree } = this;
    let current = decodeTree[this.treeIndex];
    let valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
    for (; offset < input.length; offset++, this.excess++) {
      const char = input.charCodeAt(offset);
      this.treeIndex = determineBranch(decodeTree, current, this.treeIndex + Math.max(1, valueLength), char);
      if (this.treeIndex < 0) {
        return this.result === 0 || // If we are parsing an attribute
        this.decodeMode === DecodingMode.Attribute && // We shouldn't have consumed any characters after the entity,
        (valueLength === 0 || // And there should be no invalid characters.
        isEntityInAttributeInvalidEnd(char)) ? 0 : this.emitNotTerminatedNamedEntity();
      }
      current = decodeTree[this.treeIndex];
      valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
      if (valueLength !== 0) {
        if (char === CharCodes.SEMI) {
          return this.emitNamedEntityData(this.treeIndex, valueLength, this.consumed + this.excess);
        }
        if (this.decodeMode !== DecodingMode.Strict) {
          this.result = this.treeIndex;
          this.consumed += this.excess;
          this.excess = 0;
        }
      }
    }
    return -1;
  }
  /**
   * Emit a named entity that was not terminated with a semicolon.
   *
   * @returns The number of characters consumed.
   */
  emitNotTerminatedNamedEntity() {
    var _a3;
    const { result, decodeTree } = this;
    const valueLength = (decodeTree[result] & BinTrieFlags.VALUE_LENGTH) >> 14;
    this.emitNamedEntityData(result, valueLength, this.consumed);
    (_a3 = this.errors) === null || _a3 === void 0 ? void 0 : _a3.missingSemicolonAfterCharacterReference();
    return this.consumed;
  }
  /**
   * Emit a named entity.
   *
   * @param result The index of the entity in the decode tree.
   * @param valueLength The number of bytes in the entity.
   * @param consumed The number of characters consumed.
   *
   * @returns The number of characters consumed.
   */
  emitNamedEntityData(result, valueLength, consumed) {
    const { decodeTree } = this;
    this.emitCodePoint(valueLength === 1 ? decodeTree[result] & ~BinTrieFlags.VALUE_LENGTH : decodeTree[result + 1], consumed);
    if (valueLength === 3) {
      this.emitCodePoint(decodeTree[result + 2], consumed);
    }
    return consumed;
  }
  /**
   * Signal to the parser that the end of the input was reached.
   *
   * Remaining data will be emitted and relevant errors will be produced.
   *
   * @returns The number of characters consumed.
   */
  end() {
    var _a3;
    switch (this.state) {
      case EntityDecoderState.NamedEntity: {
        return this.result !== 0 && (this.decodeMode !== DecodingMode.Attribute || this.result === this.treeIndex) ? this.emitNotTerminatedNamedEntity() : 0;
      }
      // Otherwise, emit a numeric entity if we have one.
      case EntityDecoderState.NumericDecimal: {
        return this.emitNumericEntity(0, 2);
      }
      case EntityDecoderState.NumericHex: {
        return this.emitNumericEntity(0, 3);
      }
      case EntityDecoderState.NumericStart: {
        (_a3 = this.errors) === null || _a3 === void 0 ? void 0 : _a3.absenceOfDigitsInNumericCharacterReference(this.consumed);
        return 0;
      }
      case EntityDecoderState.EntityStart: {
        return 0;
      }
    }
  }
};
function determineBranch(decodeTree, current, nodeIndex, char) {
  const branchCount = (current & BinTrieFlags.BRANCH_LENGTH) >> 7;
  const jumpOffset = current & BinTrieFlags.JUMP_TABLE;
  if (branchCount === 0) {
    return jumpOffset !== 0 && char === jumpOffset ? nodeIndex : -1;
  }
  if (jumpOffset) {
    const value = char - jumpOffset;
    return value < 0 || value >= branchCount ? -1 : decodeTree[nodeIndex + value] - 1;
  }
  let lo2 = nodeIndex;
  let hi2 = lo2 + branchCount - 1;
  while (lo2 <= hi2) {
    const mid = lo2 + hi2 >>> 1;
    const midValue = decodeTree[mid];
    if (midValue < char) {
      lo2 = mid + 1;
    } else if (midValue > char) {
      hi2 = mid - 1;
    } else {
      return decodeTree[mid + branchCount];
    }
  }
  return -1;
}

// node_modules/parse5/dist/common/html.js
var html_exports = {};
__export(html_exports, {
  ATTRS: () => ATTRS,
  DOCUMENT_MODE: () => DOCUMENT_MODE,
  NS: () => NS,
  NUMBERED_HEADERS: () => NUMBERED_HEADERS,
  SPECIAL_ELEMENTS: () => SPECIAL_ELEMENTS,
  TAG_ID: () => TAG_ID,
  TAG_NAMES: () => TAG_NAMES,
  getTagID: () => getTagID,
  hasUnescapedText: () => hasUnescapedText
});
var NS;
(function(NS3) {
  NS3["HTML"] = "http://www.w3.org/1999/xhtml";
  NS3["MATHML"] = "http://www.w3.org/1998/Math/MathML";
  NS3["SVG"] = "http://www.w3.org/2000/svg";
  NS3["XLINK"] = "http://www.w3.org/1999/xlink";
  NS3["XML"] = "http://www.w3.org/XML/1998/namespace";
  NS3["XMLNS"] = "http://www.w3.org/2000/xmlns/";
})(NS || (NS = {}));
var ATTRS;
(function(ATTRS3) {
  ATTRS3["TYPE"] = "type";
  ATTRS3["ACTION"] = "action";
  ATTRS3["ENCODING"] = "encoding";
  ATTRS3["PROMPT"] = "prompt";
  ATTRS3["NAME"] = "name";
  ATTRS3["COLOR"] = "color";
  ATTRS3["FACE"] = "face";
  ATTRS3["SIZE"] = "size";
})(ATTRS || (ATTRS = {}));
var DOCUMENT_MODE;
(function(DOCUMENT_MODE2) {
  DOCUMENT_MODE2["NO_QUIRKS"] = "no-quirks";
  DOCUMENT_MODE2["QUIRKS"] = "quirks";
  DOCUMENT_MODE2["LIMITED_QUIRKS"] = "limited-quirks";
})(DOCUMENT_MODE || (DOCUMENT_MODE = {}));
var TAG_NAMES;
(function(TAG_NAMES3) {
  TAG_NAMES3["A"] = "a";
  TAG_NAMES3["ADDRESS"] = "address";
  TAG_NAMES3["ANNOTATION_XML"] = "annotation-xml";
  TAG_NAMES3["APPLET"] = "applet";
  TAG_NAMES3["AREA"] = "area";
  TAG_NAMES3["ARTICLE"] = "article";
  TAG_NAMES3["ASIDE"] = "aside";
  TAG_NAMES3["B"] = "b";
  TAG_NAMES3["BASE"] = "base";
  TAG_NAMES3["BASEFONT"] = "basefont";
  TAG_NAMES3["BGSOUND"] = "bgsound";
  TAG_NAMES3["BIG"] = "big";
  TAG_NAMES3["BLOCKQUOTE"] = "blockquote";
  TAG_NAMES3["BODY"] = "body";
  TAG_NAMES3["BR"] = "br";
  TAG_NAMES3["BUTTON"] = "button";
  TAG_NAMES3["CAPTION"] = "caption";
  TAG_NAMES3["CENTER"] = "center";
  TAG_NAMES3["CODE"] = "code";
  TAG_NAMES3["COL"] = "col";
  TAG_NAMES3["COLGROUP"] = "colgroup";
  TAG_NAMES3["DD"] = "dd";
  TAG_NAMES3["DESC"] = "desc";
  TAG_NAMES3["DETAILS"] = "details";
  TAG_NAMES3["DIALOG"] = "dialog";
  TAG_NAMES3["DIR"] = "dir";
  TAG_NAMES3["DIV"] = "div";
  TAG_NAMES3["DL"] = "dl";
  TAG_NAMES3["DT"] = "dt";
  TAG_NAMES3["EM"] = "em";
  TAG_NAMES3["EMBED"] = "embed";
  TAG_NAMES3["FIELDSET"] = "fieldset";
  TAG_NAMES3["FIGCAPTION"] = "figcaption";
  TAG_NAMES3["FIGURE"] = "figure";
  TAG_NAMES3["FONT"] = "font";
  TAG_NAMES3["FOOTER"] = "footer";
  TAG_NAMES3["FOREIGN_OBJECT"] = "foreignObject";
  TAG_NAMES3["FORM"] = "form";
  TAG_NAMES3["FRAME"] = "frame";
  TAG_NAMES3["FRAMESET"] = "frameset";
  TAG_NAMES3["H1"] = "h1";
  TAG_NAMES3["H2"] = "h2";
  TAG_NAMES3["H3"] = "h3";
  TAG_NAMES3["H4"] = "h4";
  TAG_NAMES3["H5"] = "h5";
  TAG_NAMES3["H6"] = "h6";
  TAG_NAMES3["HEAD"] = "head";
  TAG_NAMES3["HEADER"] = "header";
  TAG_NAMES3["HGROUP"] = "hgroup";
  TAG_NAMES3["HR"] = "hr";
  TAG_NAMES3["HTML"] = "html";
  TAG_NAMES3["I"] = "i";
  TAG_NAMES3["IMG"] = "img";
  TAG_NAMES3["IMAGE"] = "image";
  TAG_NAMES3["INPUT"] = "input";
  TAG_NAMES3["IFRAME"] = "iframe";
  TAG_NAMES3["KEYGEN"] = "keygen";
  TAG_NAMES3["LABEL"] = "label";
  TAG_NAMES3["LI"] = "li";
  TAG_NAMES3["LINK"] = "link";
  TAG_NAMES3["LISTING"] = "listing";
  TAG_NAMES3["MAIN"] = "main";
  TAG_NAMES3["MALIGNMARK"] = "malignmark";
  TAG_NAMES3["MARQUEE"] = "marquee";
  TAG_NAMES3["MATH"] = "math";
  TAG_NAMES3["MENU"] = "menu";
  TAG_NAMES3["META"] = "meta";
  TAG_NAMES3["MGLYPH"] = "mglyph";
  TAG_NAMES3["MI"] = "mi";
  TAG_NAMES3["MO"] = "mo";
  TAG_NAMES3["MN"] = "mn";
  TAG_NAMES3["MS"] = "ms";
  TAG_NAMES3["MTEXT"] = "mtext";
  TAG_NAMES3["NAV"] = "nav";
  TAG_NAMES3["NOBR"] = "nobr";
  TAG_NAMES3["NOFRAMES"] = "noframes";
  TAG_NAMES3["NOEMBED"] = "noembed";
  TAG_NAMES3["NOSCRIPT"] = "noscript";
  TAG_NAMES3["OBJECT"] = "object";
  TAG_NAMES3["OL"] = "ol";
  TAG_NAMES3["OPTGROUP"] = "optgroup";
  TAG_NAMES3["OPTION"] = "option";
  TAG_NAMES3["P"] = "p";
  TAG_NAMES3["PARAM"] = "param";
  TAG_NAMES3["PLAINTEXT"] = "plaintext";
  TAG_NAMES3["PRE"] = "pre";
  TAG_NAMES3["RB"] = "rb";
  TAG_NAMES3["RP"] = "rp";
  TAG_NAMES3["RT"] = "rt";
  TAG_NAMES3["RTC"] = "rtc";
  TAG_NAMES3["RUBY"] = "ruby";
  TAG_NAMES3["S"] = "s";
  TAG_NAMES3["SCRIPT"] = "script";
  TAG_NAMES3["SEARCH"] = "search";
  TAG_NAMES3["SECTION"] = "section";
  TAG_NAMES3["SELECT"] = "select";
  TAG_NAMES3["SOURCE"] = "source";
  TAG_NAMES3["SMALL"] = "small";
  TAG_NAMES3["SPAN"] = "span";
  TAG_NAMES3["STRIKE"] = "strike";
  TAG_NAMES3["STRONG"] = "strong";
  TAG_NAMES3["STYLE"] = "style";
  TAG_NAMES3["SUB"] = "sub";
  TAG_NAMES3["SUMMARY"] = "summary";
  TAG_NAMES3["SUP"] = "sup";
  TAG_NAMES3["TABLE"] = "table";
  TAG_NAMES3["TBODY"] = "tbody";
  TAG_NAMES3["TEMPLATE"] = "template";
  TAG_NAMES3["TEXTAREA"] = "textarea";
  TAG_NAMES3["TFOOT"] = "tfoot";
  TAG_NAMES3["TD"] = "td";
  TAG_NAMES3["TH"] = "th";
  TAG_NAMES3["THEAD"] = "thead";
  TAG_NAMES3["TITLE"] = "title";
  TAG_NAMES3["TR"] = "tr";
  TAG_NAMES3["TRACK"] = "track";
  TAG_NAMES3["TT"] = "tt";
  TAG_NAMES3["U"] = "u";
  TAG_NAMES3["UL"] = "ul";
  TAG_NAMES3["SVG"] = "svg";
  TAG_NAMES3["VAR"] = "var";
  TAG_NAMES3["WBR"] = "wbr";
  TAG_NAMES3["XMP"] = "xmp";
})(TAG_NAMES || (TAG_NAMES = {}));
var TAG_ID;
(function(TAG_ID2) {
  TAG_ID2[TAG_ID2["UNKNOWN"] = 0] = "UNKNOWN";
  TAG_ID2[TAG_ID2["A"] = 1] = "A";
  TAG_ID2[TAG_ID2["ADDRESS"] = 2] = "ADDRESS";
  TAG_ID2[TAG_ID2["ANNOTATION_XML"] = 3] = "ANNOTATION_XML";
  TAG_ID2[TAG_ID2["APPLET"] = 4] = "APPLET";
  TAG_ID2[TAG_ID2["AREA"] = 5] = "AREA";
  TAG_ID2[TAG_ID2["ARTICLE"] = 6] = "ARTICLE";
  TAG_ID2[TAG_ID2["ASIDE"] = 7] = "ASIDE";
  TAG_ID2[TAG_ID2["B"] = 8] = "B";
  TAG_ID2[TAG_ID2["BASE"] = 9] = "BASE";
  TAG_ID2[TAG_ID2["BASEFONT"] = 10] = "BASEFONT";
  TAG_ID2[TAG_ID2["BGSOUND"] = 11] = "BGSOUND";
  TAG_ID2[TAG_ID2["BIG"] = 12] = "BIG";
  TAG_ID2[TAG_ID2["BLOCKQUOTE"] = 13] = "BLOCKQUOTE";
  TAG_ID2[TAG_ID2["BODY"] = 14] = "BODY";
  TAG_ID2[TAG_ID2["BR"] = 15] = "BR";
  TAG_ID2[TAG_ID2["BUTTON"] = 16] = "BUTTON";
  TAG_ID2[TAG_ID2["CAPTION"] = 17] = "CAPTION";
  TAG_ID2[TAG_ID2["CENTER"] = 18] = "CENTER";
  TAG_ID2[TAG_ID2["CODE"] = 19] = "CODE";
  TAG_ID2[TAG_ID2["COL"] = 20] = "COL";
  TAG_ID2[TAG_ID2["COLGROUP"] = 21] = "COLGROUP";
  TAG_ID2[TAG_ID2["DD"] = 22] = "DD";
  TAG_ID2[TAG_ID2["DESC"] = 23] = "DESC";
  TAG_ID2[TAG_ID2["DETAILS"] = 24] = "DETAILS";
  TAG_ID2[TAG_ID2["DIALOG"] = 25] = "DIALOG";
  TAG_ID2[TAG_ID2["DIR"] = 26] = "DIR";
  TAG_ID2[TAG_ID2["DIV"] = 27] = "DIV";
  TAG_ID2[TAG_ID2["DL"] = 28] = "DL";
  TAG_ID2[TAG_ID2["DT"] = 29] = "DT";
  TAG_ID2[TAG_ID2["EM"] = 30] = "EM";
  TAG_ID2[TAG_ID2["EMBED"] = 31] = "EMBED";
  TAG_ID2[TAG_ID2["FIELDSET"] = 32] = "FIELDSET";
  TAG_ID2[TAG_ID2["FIGCAPTION"] = 33] = "FIGCAPTION";
  TAG_ID2[TAG_ID2["FIGURE"] = 34] = "FIGURE";
  TAG_ID2[TAG_ID2["FONT"] = 35] = "FONT";
  TAG_ID2[TAG_ID2["FOOTER"] = 36] = "FOOTER";
  TAG_ID2[TAG_ID2["FOREIGN_OBJECT"] = 37] = "FOREIGN_OBJECT";
  TAG_ID2[TAG_ID2["FORM"] = 38] = "FORM";
  TAG_ID2[TAG_ID2["FRAME"] = 39] = "FRAME";
  TAG_ID2[TAG_ID2["FRAMESET"] = 40] = "FRAMESET";
  TAG_ID2[TAG_ID2["H1"] = 41] = "H1";
  TAG_ID2[TAG_ID2["H2"] = 42] = "H2";
  TAG_ID2[TAG_ID2["H3"] = 43] = "H3";
  TAG_ID2[TAG_ID2["H4"] = 44] = "H4";
  TAG_ID2[TAG_ID2["H5"] = 45] = "H5";
  TAG_ID2[TAG_ID2["H6"] = 46] = "H6";
  TAG_ID2[TAG_ID2["HEAD"] = 47] = "HEAD";
  TAG_ID2[TAG_ID2["HEADER"] = 48] = "HEADER";
  TAG_ID2[TAG_ID2["HGROUP"] = 49] = "HGROUP";
  TAG_ID2[TAG_ID2["HR"] = 50] = "HR";
  TAG_ID2[TAG_ID2["HTML"] = 51] = "HTML";
  TAG_ID2[TAG_ID2["I"] = 52] = "I";
  TAG_ID2[TAG_ID2["IMG"] = 53] = "IMG";
  TAG_ID2[TAG_ID2["IMAGE"] = 54] = "IMAGE";
  TAG_ID2[TAG_ID2["INPUT"] = 55] = "INPUT";
  TAG_ID2[TAG_ID2["IFRAME"] = 56] = "IFRAME";
  TAG_ID2[TAG_ID2["KEYGEN"] = 57] = "KEYGEN";
  TAG_ID2[TAG_ID2["LABEL"] = 58] = "LABEL";
  TAG_ID2[TAG_ID2["LI"] = 59] = "LI";
  TAG_ID2[TAG_ID2["LINK"] = 60] = "LINK";
  TAG_ID2[TAG_ID2["LISTING"] = 61] = "LISTING";
  TAG_ID2[TAG_ID2["MAIN"] = 62] = "MAIN";
  TAG_ID2[TAG_ID2["MALIGNMARK"] = 63] = "MALIGNMARK";
  TAG_ID2[TAG_ID2["MARQUEE"] = 64] = "MARQUEE";
  TAG_ID2[TAG_ID2["MATH"] = 65] = "MATH";
  TAG_ID2[TAG_ID2["MENU"] = 66] = "MENU";
  TAG_ID2[TAG_ID2["META"] = 67] = "META";
  TAG_ID2[TAG_ID2["MGLYPH"] = 68] = "MGLYPH";
  TAG_ID2[TAG_ID2["MI"] = 69] = "MI";
  TAG_ID2[TAG_ID2["MO"] = 70] = "MO";
  TAG_ID2[TAG_ID2["MN"] = 71] = "MN";
  TAG_ID2[TAG_ID2["MS"] = 72] = "MS";
  TAG_ID2[TAG_ID2["MTEXT"] = 73] = "MTEXT";
  TAG_ID2[TAG_ID2["NAV"] = 74] = "NAV";
  TAG_ID2[TAG_ID2["NOBR"] = 75] = "NOBR";
  TAG_ID2[TAG_ID2["NOFRAMES"] = 76] = "NOFRAMES";
  TAG_ID2[TAG_ID2["NOEMBED"] = 77] = "NOEMBED";
  TAG_ID2[TAG_ID2["NOSCRIPT"] = 78] = "NOSCRIPT";
  TAG_ID2[TAG_ID2["OBJECT"] = 79] = "OBJECT";
  TAG_ID2[TAG_ID2["OL"] = 80] = "OL";
  TAG_ID2[TAG_ID2["OPTGROUP"] = 81] = "OPTGROUP";
  TAG_ID2[TAG_ID2["OPTION"] = 82] = "OPTION";
  TAG_ID2[TAG_ID2["P"] = 83] = "P";
  TAG_ID2[TAG_ID2["PARAM"] = 84] = "PARAM";
  TAG_ID2[TAG_ID2["PLAINTEXT"] = 85] = "PLAINTEXT";
  TAG_ID2[TAG_ID2["PRE"] = 86] = "PRE";
  TAG_ID2[TAG_ID2["RB"] = 87] = "RB";
  TAG_ID2[TAG_ID2["RP"] = 88] = "RP";
  TAG_ID2[TAG_ID2["RT"] = 89] = "RT";
  TAG_ID2[TAG_ID2["RTC"] = 90] = "RTC";
  TAG_ID2[TAG_ID2["RUBY"] = 91] = "RUBY";
  TAG_ID2[TAG_ID2["S"] = 92] = "S";
  TAG_ID2[TAG_ID2["SCRIPT"] = 93] = "SCRIPT";
  TAG_ID2[TAG_ID2["SEARCH"] = 94] = "SEARCH";
  TAG_ID2[TAG_ID2["SECTION"] = 95] = "SECTION";
  TAG_ID2[TAG_ID2["SELECT"] = 96] = "SELECT";
  TAG_ID2[TAG_ID2["SOURCE"] = 97] = "SOURCE";
  TAG_ID2[TAG_ID2["SMALL"] = 98] = "SMALL";
  TAG_ID2[TAG_ID2["SPAN"] = 99] = "SPAN";
  TAG_ID2[TAG_ID2["STRIKE"] = 100] = "STRIKE";
  TAG_ID2[TAG_ID2["STRONG"] = 101] = "STRONG";
  TAG_ID2[TAG_ID2["STYLE"] = 102] = "STYLE";
  TAG_ID2[TAG_ID2["SUB"] = 103] = "SUB";
  TAG_ID2[TAG_ID2["SUMMARY"] = 104] = "SUMMARY";
  TAG_ID2[TAG_ID2["SUP"] = 105] = "SUP";
  TAG_ID2[TAG_ID2["TABLE"] = 106] = "TABLE";
  TAG_ID2[TAG_ID2["TBODY"] = 107] = "TBODY";
  TAG_ID2[TAG_ID2["TEMPLATE"] = 108] = "TEMPLATE";
  TAG_ID2[TAG_ID2["TEXTAREA"] = 109] = "TEXTAREA";
  TAG_ID2[TAG_ID2["TFOOT"] = 110] = "TFOOT";
  TAG_ID2[TAG_ID2["TD"] = 111] = "TD";
  TAG_ID2[TAG_ID2["TH"] = 112] = "TH";
  TAG_ID2[TAG_ID2["THEAD"] = 113] = "THEAD";
  TAG_ID2[TAG_ID2["TITLE"] = 114] = "TITLE";
  TAG_ID2[TAG_ID2["TR"] = 115] = "TR";
  TAG_ID2[TAG_ID2["TRACK"] = 116] = "TRACK";
  TAG_ID2[TAG_ID2["TT"] = 117] = "TT";
  TAG_ID2[TAG_ID2["U"] = 118] = "U";
  TAG_ID2[TAG_ID2["UL"] = 119] = "UL";
  TAG_ID2[TAG_ID2["SVG"] = 120] = "SVG";
  TAG_ID2[TAG_ID2["VAR"] = 121] = "VAR";
  TAG_ID2[TAG_ID2["WBR"] = 122] = "WBR";
  TAG_ID2[TAG_ID2["XMP"] = 123] = "XMP";
})(TAG_ID || (TAG_ID = {}));
var TAG_NAME_TO_ID = /* @__PURE__ */ new Map([
  [TAG_NAMES.A, TAG_ID.A],
  [TAG_NAMES.ADDRESS, TAG_ID.ADDRESS],
  [TAG_NAMES.ANNOTATION_XML, TAG_ID.ANNOTATION_XML],
  [TAG_NAMES.APPLET, TAG_ID.APPLET],
  [TAG_NAMES.AREA, TAG_ID.AREA],
  [TAG_NAMES.ARTICLE, TAG_ID.ARTICLE],
  [TAG_NAMES.ASIDE, TAG_ID.ASIDE],
  [TAG_NAMES.B, TAG_ID.B],
  [TAG_NAMES.BASE, TAG_ID.BASE],
  [TAG_NAMES.BASEFONT, TAG_ID.BASEFONT],
  [TAG_NAMES.BGSOUND, TAG_ID.BGSOUND],
  [TAG_NAMES.BIG, TAG_ID.BIG],
  [TAG_NAMES.BLOCKQUOTE, TAG_ID.BLOCKQUOTE],
  [TAG_NAMES.BODY, TAG_ID.BODY],
  [TAG_NAMES.BR, TAG_ID.BR],
  [TAG_NAMES.BUTTON, TAG_ID.BUTTON],
  [TAG_NAMES.CAPTION, TAG_ID.CAPTION],
  [TAG_NAMES.CENTER, TAG_ID.CENTER],
  [TAG_NAMES.CODE, TAG_ID.CODE],
  [TAG_NAMES.COL, TAG_ID.COL],
  [TAG_NAMES.COLGROUP, TAG_ID.COLGROUP],
  [TAG_NAMES.DD, TAG_ID.DD],
  [TAG_NAMES.DESC, TAG_ID.DESC],
  [TAG_NAMES.DETAILS, TAG_ID.DETAILS],
  [TAG_NAMES.DIALOG, TAG_ID.DIALOG],
  [TAG_NAMES.DIR, TAG_ID.DIR],
  [TAG_NAMES.DIV, TAG_ID.DIV],
  [TAG_NAMES.DL, TAG_ID.DL],
  [TAG_NAMES.DT, TAG_ID.DT],
  [TAG_NAMES.EM, TAG_ID.EM],
  [TAG_NAMES.EMBED, TAG_ID.EMBED],
  [TAG_NAMES.FIELDSET, TAG_ID.FIELDSET],
  [TAG_NAMES.FIGCAPTION, TAG_ID.FIGCAPTION],
  [TAG_NAMES.FIGURE, TAG_ID.FIGURE],
  [TAG_NAMES.FONT, TAG_ID.FONT],
  [TAG_NAMES.FOOTER, TAG_ID.FOOTER],
  [TAG_NAMES.FOREIGN_OBJECT, TAG_ID.FOREIGN_OBJECT],
  [TAG_NAMES.FORM, TAG_ID.FORM],
  [TAG_NAMES.FRAME, TAG_ID.FRAME],
  [TAG_NAMES.FRAMESET, TAG_ID.FRAMESET],
  [TAG_NAMES.H1, TAG_ID.H1],
  [TAG_NAMES.H2, TAG_ID.H2],
  [TAG_NAMES.H3, TAG_ID.H3],
  [TAG_NAMES.H4, TAG_ID.H4],
  [TAG_NAMES.H5, TAG_ID.H5],
  [TAG_NAMES.H6, TAG_ID.H6],
  [TAG_NAMES.HEAD, TAG_ID.HEAD],
  [TAG_NAMES.HEADER, TAG_ID.HEADER],
  [TAG_NAMES.HGROUP, TAG_ID.HGROUP],
  [TAG_NAMES.HR, TAG_ID.HR],
  [TAG_NAMES.HTML, TAG_ID.HTML],
  [TAG_NAMES.I, TAG_ID.I],
  [TAG_NAMES.IMG, TAG_ID.IMG],
  [TAG_NAMES.IMAGE, TAG_ID.IMAGE],
  [TAG_NAMES.INPUT, TAG_ID.INPUT],
  [TAG_NAMES.IFRAME, TAG_ID.IFRAME],
  [TAG_NAMES.KEYGEN, TAG_ID.KEYGEN],
  [TAG_NAMES.LABEL, TAG_ID.LABEL],
  [TAG_NAMES.LI, TAG_ID.LI],
  [TAG_NAMES.LINK, TAG_ID.LINK],
  [TAG_NAMES.LISTING, TAG_ID.LISTING],
  [TAG_NAMES.MAIN, TAG_ID.MAIN],
  [TAG_NAMES.MALIGNMARK, TAG_ID.MALIGNMARK],
  [TAG_NAMES.MARQUEE, TAG_ID.MARQUEE],
  [TAG_NAMES.MATH, TAG_ID.MATH],
  [TAG_NAMES.MENU, TAG_ID.MENU],
  [TAG_NAMES.META, TAG_ID.META],
  [TAG_NAMES.MGLYPH, TAG_ID.MGLYPH],
  [TAG_NAMES.MI, TAG_ID.MI],
  [TAG_NAMES.MO, TAG_ID.MO],
  [TAG_NAMES.MN, TAG_ID.MN],
  [TAG_NAMES.MS, TAG_ID.MS],
  [TAG_NAMES.MTEXT, TAG_ID.MTEXT],
  [TAG_NAMES.NAV, TAG_ID.NAV],
  [TAG_NAMES.NOBR, TAG_ID.NOBR],
  [TAG_NAMES.NOFRAMES, TAG_ID.NOFRAMES],
  [TAG_NAMES.NOEMBED, TAG_ID.NOEMBED],
  [TAG_NAMES.NOSCRIPT, TAG_ID.NOSCRIPT],
  [TAG_NAMES.OBJECT, TAG_ID.OBJECT],
  [TAG_NAMES.OL, TAG_ID.OL],
  [TAG_NAMES.OPTGROUP, TAG_ID.OPTGROUP],
  [TAG_NAMES.OPTION, TAG_ID.OPTION],
  [TAG_NAMES.P, TAG_ID.P],
  [TAG_NAMES.PARAM, TAG_ID.PARAM],
  [TAG_NAMES.PLAINTEXT, TAG_ID.PLAINTEXT],
  [TAG_NAMES.PRE, TAG_ID.PRE],
  [TAG_NAMES.RB, TAG_ID.RB],
  [TAG_NAMES.RP, TAG_ID.RP],
  [TAG_NAMES.RT, TAG_ID.RT],
  [TAG_NAMES.RTC, TAG_ID.RTC],
  [TAG_NAMES.RUBY, TAG_ID.RUBY],
  [TAG_NAMES.S, TAG_ID.S],
  [TAG_NAMES.SCRIPT, TAG_ID.SCRIPT],
  [TAG_NAMES.SEARCH, TAG_ID.SEARCH],
  [TAG_NAMES.SECTION, TAG_ID.SECTION],
  [TAG_NAMES.SELECT, TAG_ID.SELECT],
  [TAG_NAMES.SOURCE, TAG_ID.SOURCE],
  [TAG_NAMES.SMALL, TAG_ID.SMALL],
  [TAG_NAMES.SPAN, TAG_ID.SPAN],
  [TAG_NAMES.STRIKE, TAG_ID.STRIKE],
  [TAG_NAMES.STRONG, TAG_ID.STRONG],
  [TAG_NAMES.STYLE, TAG_ID.STYLE],
  [TAG_NAMES.SUB, TAG_ID.SUB],
  [TAG_NAMES.SUMMARY, TAG_ID.SUMMARY],
  [TAG_NAMES.SUP, TAG_ID.SUP],
  [TAG_NAMES.TABLE, TAG_ID.TABLE],
  [TAG_NAMES.TBODY, TAG_ID.TBODY],
  [TAG_NAMES.TEMPLATE, TAG_ID.TEMPLATE],
  [TAG_NAMES.TEXTAREA, TAG_ID.TEXTAREA],
  [TAG_NAMES.TFOOT, TAG_ID.TFOOT],
  [TAG_NAMES.TD, TAG_ID.TD],
  [TAG_NAMES.TH, TAG_ID.TH],
  [TAG_NAMES.THEAD, TAG_ID.THEAD],
  [TAG_NAMES.TITLE, TAG_ID.TITLE],
  [TAG_NAMES.TR, TAG_ID.TR],
  [TAG_NAMES.TRACK, TAG_ID.TRACK],
  [TAG_NAMES.TT, TAG_ID.TT],
  [TAG_NAMES.U, TAG_ID.U],
  [TAG_NAMES.UL, TAG_ID.UL],
  [TAG_NAMES.SVG, TAG_ID.SVG],
  [TAG_NAMES.VAR, TAG_ID.VAR],
  [TAG_NAMES.WBR, TAG_ID.WBR],
  [TAG_NAMES.XMP, TAG_ID.XMP]
]);
function getTagID(tagName) {
  var _a3;
  return (_a3 = TAG_NAME_TO_ID.get(tagName)) !== null && _a3 !== void 0 ? _a3 : TAG_ID.UNKNOWN;
}
var $ = TAG_ID;
var SPECIAL_ELEMENTS = {
  [NS.HTML]: /* @__PURE__ */ new Set([
    $.ADDRESS,
    $.APPLET,
    $.AREA,
    $.ARTICLE,
    $.ASIDE,
    $.BASE,
    $.BASEFONT,
    $.BGSOUND,
    $.BLOCKQUOTE,
    $.BODY,
    $.BR,
    $.BUTTON,
    $.CAPTION,
    $.CENTER,
    $.COL,
    $.COLGROUP,
    $.DD,
    $.DETAILS,
    $.DIR,
    $.DIV,
    $.DL,
    $.DT,
    $.EMBED,
    $.FIELDSET,
    $.FIGCAPTION,
    $.FIGURE,
    $.FOOTER,
    $.FORM,
    $.FRAME,
    $.FRAMESET,
    $.H1,
    $.H2,
    $.H3,
    $.H4,
    $.H5,
    $.H6,
    $.HEAD,
    $.HEADER,
    $.HGROUP,
    $.HR,
    $.HTML,
    $.IFRAME,
    $.IMG,
    $.INPUT,
    $.LI,
    $.LINK,
    $.LISTING,
    $.MAIN,
    $.MARQUEE,
    $.MENU,
    $.META,
    $.NAV,
    $.NOEMBED,
    $.NOFRAMES,
    $.NOSCRIPT,
    $.OBJECT,
    $.OL,
    $.P,
    $.PARAM,
    $.PLAINTEXT,
    $.PRE,
    $.SCRIPT,
    $.SECTION,
    $.SELECT,
    $.SOURCE,
    $.STYLE,
    $.SUMMARY,
    $.TABLE,
    $.TBODY,
    $.TD,
    $.TEMPLATE,
    $.TEXTAREA,
    $.TFOOT,
    $.TH,
    $.THEAD,
    $.TITLE,
    $.TR,
    $.TRACK,
    $.UL,
    $.WBR,
    $.XMP
  ]),
  [NS.MATHML]: /* @__PURE__ */ new Set([$.MI, $.MO, $.MN, $.MS, $.MTEXT, $.ANNOTATION_XML]),
  [NS.SVG]: /* @__PURE__ */ new Set([$.TITLE, $.FOREIGN_OBJECT, $.DESC]),
  [NS.XLINK]: /* @__PURE__ */ new Set(),
  [NS.XML]: /* @__PURE__ */ new Set(),
  [NS.XMLNS]: /* @__PURE__ */ new Set()
};
var NUMBERED_HEADERS = /* @__PURE__ */ new Set([$.H1, $.H2, $.H3, $.H4, $.H5, $.H6]);
var UNESCAPED_TEXT = /* @__PURE__ */ new Set([
  TAG_NAMES.STYLE,
  TAG_NAMES.SCRIPT,
  TAG_NAMES.XMP,
  TAG_NAMES.IFRAME,
  TAG_NAMES.NOEMBED,
  TAG_NAMES.NOFRAMES,
  TAG_NAMES.PLAINTEXT
]);
function hasUnescapedText(tn2, scriptingEnabled) {
  return UNESCAPED_TEXT.has(tn2) || scriptingEnabled && tn2 === TAG_NAMES.NOSCRIPT;
}

// node_modules/parse5/dist/tokenizer/index.js
var State;
(function(State2) {
  State2[State2["DATA"] = 0] = "DATA";
  State2[State2["RCDATA"] = 1] = "RCDATA";
  State2[State2["RAWTEXT"] = 2] = "RAWTEXT";
  State2[State2["SCRIPT_DATA"] = 3] = "SCRIPT_DATA";
  State2[State2["PLAINTEXT"] = 4] = "PLAINTEXT";
  State2[State2["TAG_OPEN"] = 5] = "TAG_OPEN";
  State2[State2["END_TAG_OPEN"] = 6] = "END_TAG_OPEN";
  State2[State2["TAG_NAME"] = 7] = "TAG_NAME";
  State2[State2["RCDATA_LESS_THAN_SIGN"] = 8] = "RCDATA_LESS_THAN_SIGN";
  State2[State2["RCDATA_END_TAG_OPEN"] = 9] = "RCDATA_END_TAG_OPEN";
  State2[State2["RCDATA_END_TAG_NAME"] = 10] = "RCDATA_END_TAG_NAME";
  State2[State2["RAWTEXT_LESS_THAN_SIGN"] = 11] = "RAWTEXT_LESS_THAN_SIGN";
  State2[State2["RAWTEXT_END_TAG_OPEN"] = 12] = "RAWTEXT_END_TAG_OPEN";
  State2[State2["RAWTEXT_END_TAG_NAME"] = 13] = "RAWTEXT_END_TAG_NAME";
  State2[State2["SCRIPT_DATA_LESS_THAN_SIGN"] = 14] = "SCRIPT_DATA_LESS_THAN_SIGN";
  State2[State2["SCRIPT_DATA_END_TAG_OPEN"] = 15] = "SCRIPT_DATA_END_TAG_OPEN";
  State2[State2["SCRIPT_DATA_END_TAG_NAME"] = 16] = "SCRIPT_DATA_END_TAG_NAME";
  State2[State2["SCRIPT_DATA_ESCAPE_START"] = 17] = "SCRIPT_DATA_ESCAPE_START";
  State2[State2["SCRIPT_DATA_ESCAPE_START_DASH"] = 18] = "SCRIPT_DATA_ESCAPE_START_DASH";
  State2[State2["SCRIPT_DATA_ESCAPED"] = 19] = "SCRIPT_DATA_ESCAPED";
  State2[State2["SCRIPT_DATA_ESCAPED_DASH"] = 20] = "SCRIPT_DATA_ESCAPED_DASH";
  State2[State2["SCRIPT_DATA_ESCAPED_DASH_DASH"] = 21] = "SCRIPT_DATA_ESCAPED_DASH_DASH";
  State2[State2["SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN"] = 22] = "SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN";
  State2[State2["SCRIPT_DATA_ESCAPED_END_TAG_OPEN"] = 23] = "SCRIPT_DATA_ESCAPED_END_TAG_OPEN";
  State2[State2["SCRIPT_DATA_ESCAPED_END_TAG_NAME"] = 24] = "SCRIPT_DATA_ESCAPED_END_TAG_NAME";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPE_START"] = 25] = "SCRIPT_DATA_DOUBLE_ESCAPE_START";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPED"] = 26] = "SCRIPT_DATA_DOUBLE_ESCAPED";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPED_DASH"] = 27] = "SCRIPT_DATA_DOUBLE_ESCAPED_DASH";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH"] = 28] = "SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN"] = 29] = "SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN";
  State2[State2["SCRIPT_DATA_DOUBLE_ESCAPE_END"] = 30] = "SCRIPT_DATA_DOUBLE_ESCAPE_END";
  State2[State2["BEFORE_ATTRIBUTE_NAME"] = 31] = "BEFORE_ATTRIBUTE_NAME";
  State2[State2["ATTRIBUTE_NAME"] = 32] = "ATTRIBUTE_NAME";
  State2[State2["AFTER_ATTRIBUTE_NAME"] = 33] = "AFTER_ATTRIBUTE_NAME";
  State2[State2["BEFORE_ATTRIBUTE_VALUE"] = 34] = "BEFORE_ATTRIBUTE_VALUE";
  State2[State2["ATTRIBUTE_VALUE_DOUBLE_QUOTED"] = 35] = "ATTRIBUTE_VALUE_DOUBLE_QUOTED";
  State2[State2["ATTRIBUTE_VALUE_SINGLE_QUOTED"] = 36] = "ATTRIBUTE_VALUE_SINGLE_QUOTED";
  State2[State2["ATTRIBUTE_VALUE_UNQUOTED"] = 37] = "ATTRIBUTE_VALUE_UNQUOTED";
  State2[State2["AFTER_ATTRIBUTE_VALUE_QUOTED"] = 38] = "AFTER_ATTRIBUTE_VALUE_QUOTED";
  State2[State2["SELF_CLOSING_START_TAG"] = 39] = "SELF_CLOSING_START_TAG";
  State2[State2["BOGUS_COMMENT"] = 40] = "BOGUS_COMMENT";
  State2[State2["MARKUP_DECLARATION_OPEN"] = 41] = "MARKUP_DECLARATION_OPEN";
  State2[State2["COMMENT_START"] = 42] = "COMMENT_START";
  State2[State2["COMMENT_START_DASH"] = 43] = "COMMENT_START_DASH";
  State2[State2["COMMENT"] = 44] = "COMMENT";
  State2[State2["COMMENT_LESS_THAN_SIGN"] = 45] = "COMMENT_LESS_THAN_SIGN";
  State2[State2["COMMENT_LESS_THAN_SIGN_BANG"] = 46] = "COMMENT_LESS_THAN_SIGN_BANG";
  State2[State2["COMMENT_LESS_THAN_SIGN_BANG_DASH"] = 47] = "COMMENT_LESS_THAN_SIGN_BANG_DASH";
  State2[State2["COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH"] = 48] = "COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH";
  State2[State2["COMMENT_END_DASH"] = 49] = "COMMENT_END_DASH";
  State2[State2["COMMENT_END"] = 50] = "COMMENT_END";
  State2[State2["COMMENT_END_BANG"] = 51] = "COMMENT_END_BANG";
  State2[State2["DOCTYPE"] = 52] = "DOCTYPE";
  State2[State2["BEFORE_DOCTYPE_NAME"] = 53] = "BEFORE_DOCTYPE_NAME";
  State2[State2["DOCTYPE_NAME"] = 54] = "DOCTYPE_NAME";
  State2[State2["AFTER_DOCTYPE_NAME"] = 55] = "AFTER_DOCTYPE_NAME";
  State2[State2["AFTER_DOCTYPE_PUBLIC_KEYWORD"] = 56] = "AFTER_DOCTYPE_PUBLIC_KEYWORD";
  State2[State2["BEFORE_DOCTYPE_PUBLIC_IDENTIFIER"] = 57] = "BEFORE_DOCTYPE_PUBLIC_IDENTIFIER";
  State2[State2["DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED"] = 58] = "DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED";
  State2[State2["DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED"] = 59] = "DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED";
  State2[State2["AFTER_DOCTYPE_PUBLIC_IDENTIFIER"] = 60] = "AFTER_DOCTYPE_PUBLIC_IDENTIFIER";
  State2[State2["BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS"] = 61] = "BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS";
  State2[State2["AFTER_DOCTYPE_SYSTEM_KEYWORD"] = 62] = "AFTER_DOCTYPE_SYSTEM_KEYWORD";
  State2[State2["BEFORE_DOCTYPE_SYSTEM_IDENTIFIER"] = 63] = "BEFORE_DOCTYPE_SYSTEM_IDENTIFIER";
  State2[State2["DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED"] = 64] = "DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED";
  State2[State2["DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED"] = 65] = "DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED";
  State2[State2["AFTER_DOCTYPE_SYSTEM_IDENTIFIER"] = 66] = "AFTER_DOCTYPE_SYSTEM_IDENTIFIER";
  State2[State2["BOGUS_DOCTYPE"] = 67] = "BOGUS_DOCTYPE";
  State2[State2["CDATA_SECTION"] = 68] = "CDATA_SECTION";
  State2[State2["CDATA_SECTION_BRACKET"] = 69] = "CDATA_SECTION_BRACKET";
  State2[State2["CDATA_SECTION_END"] = 70] = "CDATA_SECTION_END";
  State2[State2["CHARACTER_REFERENCE"] = 71] = "CHARACTER_REFERENCE";
  State2[State2["AMBIGUOUS_AMPERSAND"] = 72] = "AMBIGUOUS_AMPERSAND";
})(State || (State = {}));
var TokenizerMode = {
  DATA: State.DATA,
  RCDATA: State.RCDATA,
  RAWTEXT: State.RAWTEXT,
  SCRIPT_DATA: State.SCRIPT_DATA,
  PLAINTEXT: State.PLAINTEXT,
  CDATA_SECTION: State.CDATA_SECTION
};
function isAsciiDigit(cp2) {
  return cp2 >= CODE_POINTS.DIGIT_0 && cp2 <= CODE_POINTS.DIGIT_9;
}
function isAsciiUpper(cp2) {
  return cp2 >= CODE_POINTS.LATIN_CAPITAL_A && cp2 <= CODE_POINTS.LATIN_CAPITAL_Z;
}
function isAsciiLower(cp2) {
  return cp2 >= CODE_POINTS.LATIN_SMALL_A && cp2 <= CODE_POINTS.LATIN_SMALL_Z;
}
function isAsciiLetter(cp2) {
  return isAsciiLower(cp2) || isAsciiUpper(cp2);
}
function isAsciiAlphaNumeric2(cp2) {
  return isAsciiLetter(cp2) || isAsciiDigit(cp2);
}
function toAsciiLower(cp2) {
  return cp2 + 32;
}
function isWhitespace(cp2) {
  return cp2 === CODE_POINTS.SPACE || cp2 === CODE_POINTS.LINE_FEED || cp2 === CODE_POINTS.TABULATION || cp2 === CODE_POINTS.FORM_FEED;
}
function isScriptDataDoubleEscapeSequenceEnd(cp2) {
  return isWhitespace(cp2) || cp2 === CODE_POINTS.SOLIDUS || cp2 === CODE_POINTS.GREATER_THAN_SIGN;
}
function getErrorForNumericCharacterReference(code) {
  if (code === CODE_POINTS.NULL) {
    return ERR.nullCharacterReference;
  } else if (code > 1114111) {
    return ERR.characterReferenceOutsideUnicodeRange;
  } else if (isSurrogate(code)) {
    return ERR.surrogateCharacterReference;
  } else if (isUndefinedCodePoint(code)) {
    return ERR.noncharacterCharacterReference;
  } else if (isControlCodePoint(code) || code === CODE_POINTS.CARRIAGE_RETURN) {
    return ERR.controlCharacterReference;
  }
  return null;
}
var Tokenizer = class {
  constructor(options, handler) {
    this.options = options;
    this.handler = handler;
    this.paused = false;
    this.inLoop = false;
    this.inForeignNode = false;
    this.lastStartTagName = "";
    this.active = false;
    this.state = State.DATA;
    this.returnState = State.DATA;
    this.entityStartPos = 0;
    this.consumedAfterSnapshot = -1;
    this.currentCharacterToken = null;
    this.currentToken = null;
    this.currentAttr = { name: "", value: "" };
    this.preprocessor = new Preprocessor(handler);
    this.currentLocation = this.getCurrentLocation(-1);
    this.entityDecoder = new EntityDecoder(htmlDecodeTree, (cp2, consumed) => {
      this.preprocessor.pos = this.entityStartPos + consumed - 1;
      this._flushCodePointConsumedAsCharacterReference(cp2);
    }, handler.onParseError ? {
      missingSemicolonAfterCharacterReference: () => {
        this._err(ERR.missingSemicolonAfterCharacterReference, 1);
      },
      absenceOfDigitsInNumericCharacterReference: (consumed) => {
        this._err(ERR.absenceOfDigitsInNumericCharacterReference, this.entityStartPos - this.preprocessor.pos + consumed);
      },
      validateNumericCharacterReference: (code) => {
        const error = getErrorForNumericCharacterReference(code);
        if (error)
          this._err(error, 1);
      }
    } : void 0);
  }
  //Errors
  _err(code, cpOffset = 0) {
    var _a3, _b;
    (_b = (_a3 = this.handler).onParseError) === null || _b === void 0 ? void 0 : _b.call(_a3, this.preprocessor.getError(code, cpOffset));
  }
  // NOTE: `offset` may never run across line boundaries.
  getCurrentLocation(offset) {
    if (!this.options.sourceCodeLocationInfo) {
      return null;
    }
    return {
      startLine: this.preprocessor.line,
      startCol: this.preprocessor.col - offset,
      startOffset: this.preprocessor.offset - offset,
      endLine: -1,
      endCol: -1,
      endOffset: -1
    };
  }
  _runParsingLoop() {
    if (this.inLoop)
      return;
    this.inLoop = true;
    while (this.active && !this.paused) {
      this.consumedAfterSnapshot = 0;
      const cp2 = this._consume();
      if (!this._ensureHibernation()) {
        this._callState(cp2);
      }
    }
    this.inLoop = false;
  }
  //API
  pause() {
    this.paused = true;
  }
  resume(writeCallback) {
    if (!this.paused) {
      throw new Error("Parser was already resumed");
    }
    this.paused = false;
    if (this.inLoop)
      return;
    this._runParsingLoop();
    if (!this.paused) {
      writeCallback === null || writeCallback === void 0 ? void 0 : writeCallback();
    }
  }
  write(chunk, isLastChunk, writeCallback) {
    this.active = true;
    this.preprocessor.write(chunk, isLastChunk);
    this._runParsingLoop();
    if (!this.paused) {
      writeCallback === null || writeCallback === void 0 ? void 0 : writeCallback();
    }
  }
  insertHtmlAtCurrentPos(chunk) {
    this.active = true;
    this.preprocessor.insertHtmlAtCurrentPos(chunk);
    this._runParsingLoop();
  }
  //Hibernation
  _ensureHibernation() {
    if (this.preprocessor.endOfChunkHit) {
      this.preprocessor.retreat(this.consumedAfterSnapshot);
      this.consumedAfterSnapshot = 0;
      this.active = false;
      return true;
    }
    return false;
  }
  //Consumption
  _consume() {
    this.consumedAfterSnapshot++;
    return this.preprocessor.advance();
  }
  _advanceBy(count) {
    this.consumedAfterSnapshot += count;
    for (let i = 0; i < count; i++) {
      this.preprocessor.advance();
    }
  }
  _consumeSequenceIfMatch(pattern, caseSensitive) {
    if (this.preprocessor.startsWith(pattern, caseSensitive)) {
      this._advanceBy(pattern.length - 1);
      return true;
    }
    return false;
  }
  //Token creation
  _createStartTagToken() {
    this.currentToken = {
      type: TokenType.START_TAG,
      tagName: "",
      tagID: TAG_ID.UNKNOWN,
      selfClosing: false,
      ackSelfClosing: false,
      attrs: [],
      location: this.getCurrentLocation(1)
    };
  }
  _createEndTagToken() {
    this.currentToken = {
      type: TokenType.END_TAG,
      tagName: "",
      tagID: TAG_ID.UNKNOWN,
      selfClosing: false,
      ackSelfClosing: false,
      attrs: [],
      location: this.getCurrentLocation(2)
    };
  }
  _createCommentToken(offset) {
    this.currentToken = {
      type: TokenType.COMMENT,
      data: "",
      location: this.getCurrentLocation(offset)
    };
  }
  _createDoctypeToken(initialName) {
    this.currentToken = {
      type: TokenType.DOCTYPE,
      name: initialName,
      forceQuirks: false,
      publicId: null,
      systemId: null,
      location: this.currentLocation
    };
  }
  _createCharacterToken(type, chars) {
    this.currentCharacterToken = {
      type,
      chars,
      location: this.currentLocation
    };
  }
  //Tag attributes
  _createAttr(attrNameFirstCh) {
    this.currentAttr = {
      name: attrNameFirstCh,
      value: ""
    };
    this.currentLocation = this.getCurrentLocation(0);
  }
  _leaveAttrName() {
    var _a3;
    var _b;
    const token = this.currentToken;
    if (getTokenAttr(token, this.currentAttr.name) === null) {
      token.attrs.push(this.currentAttr);
      if (token.location && this.currentLocation) {
        const attrLocations = (_a3 = (_b = token.location).attrs) !== null && _a3 !== void 0 ? _a3 : _b.attrs = /* @__PURE__ */ Object.create(null);
        attrLocations[this.currentAttr.name] = this.currentLocation;
        this._leaveAttrValue();
      }
    } else {
      this._err(ERR.duplicateAttribute);
    }
  }
  _leaveAttrValue() {
    if (this.currentLocation) {
      this.currentLocation.endLine = this.preprocessor.line;
      this.currentLocation.endCol = this.preprocessor.col;
      this.currentLocation.endOffset = this.preprocessor.offset;
    }
  }
  //Token emission
  prepareToken(ct) {
    this._emitCurrentCharacterToken(ct.location);
    this.currentToken = null;
    if (ct.location) {
      ct.location.endLine = this.preprocessor.line;
      ct.location.endCol = this.preprocessor.col + 1;
      ct.location.endOffset = this.preprocessor.offset + 1;
    }
    this.currentLocation = this.getCurrentLocation(-1);
  }
  emitCurrentTagToken() {
    const ct = this.currentToken;
    this.prepareToken(ct);
    ct.tagID = getTagID(ct.tagName);
    if (ct.type === TokenType.START_TAG) {
      this.lastStartTagName = ct.tagName;
      this.handler.onStartTag(ct);
    } else {
      if (ct.attrs.length > 0) {
        this._err(ERR.endTagWithAttributes);
      }
      if (ct.selfClosing) {
        this._err(ERR.endTagWithTrailingSolidus);
      }
      this.handler.onEndTag(ct);
    }
    this.preprocessor.dropParsedChunk();
  }
  emitCurrentComment(ct) {
    this.prepareToken(ct);
    this.handler.onComment(ct);
    this.preprocessor.dropParsedChunk();
  }
  emitCurrentDoctype(ct) {
    this.prepareToken(ct);
    this.handler.onDoctype(ct);
    this.preprocessor.dropParsedChunk();
  }
  _emitCurrentCharacterToken(nextLocation) {
    if (this.currentCharacterToken) {
      if (nextLocation && this.currentCharacterToken.location) {
        this.currentCharacterToken.location.endLine = nextLocation.startLine;
        this.currentCharacterToken.location.endCol = nextLocation.startCol;
        this.currentCharacterToken.location.endOffset = nextLocation.startOffset;
      }
      switch (this.currentCharacterToken.type) {
        case TokenType.CHARACTER: {
          this.handler.onCharacter(this.currentCharacterToken);
          break;
        }
        case TokenType.NULL_CHARACTER: {
          this.handler.onNullCharacter(this.currentCharacterToken);
          break;
        }
        case TokenType.WHITESPACE_CHARACTER: {
          this.handler.onWhitespaceCharacter(this.currentCharacterToken);
          break;
        }
      }
      this.currentCharacterToken = null;
    }
  }
  _emitEOFToken() {
    const location = this.getCurrentLocation(0);
    if (location) {
      location.endLine = location.startLine;
      location.endCol = location.startCol;
      location.endOffset = location.startOffset;
    }
    this._emitCurrentCharacterToken(location);
    this.handler.onEof({ type: TokenType.EOF, location });
    this.active = false;
  }
  //Characters emission
  //OPTIMIZATION: The specification uses only one type of character token (one token per character).
  //This causes a huge memory overhead and a lot of unnecessary parser loops. parse5 uses 3 groups of characters.
  //If we have a sequence of characters that belong to the same group, the parser can process it
  //as a single solid character token.
  //So, there are 3 types of character tokens in parse5:
  //1)TokenType.NULL_CHARACTER - \u0000-character sequences (e.g. '\u0000\u0000\u0000')
  //2)TokenType.WHITESPACE_CHARACTER - any whitespace/new-line character sequences (e.g. '\n  \r\t   \f')
  //3)TokenType.CHARACTER - any character sequence which don't belong to groups 1 and 2 (e.g. 'abcdef1234@@#$%^')
  _appendCharToCurrentCharacterToken(type, ch2) {
    if (this.currentCharacterToken) {
      if (this.currentCharacterToken.type === type) {
        this.currentCharacterToken.chars += ch2;
        return;
      } else {
        this.currentLocation = this.getCurrentLocation(0);
        this._emitCurrentCharacterToken(this.currentLocation);
        this.preprocessor.dropParsedChunk();
      }
    }
    this._createCharacterToken(type, ch2);
  }
  _emitCodePoint(cp2) {
    const type = isWhitespace(cp2) ? TokenType.WHITESPACE_CHARACTER : cp2 === CODE_POINTS.NULL ? TokenType.NULL_CHARACTER : TokenType.CHARACTER;
    this._appendCharToCurrentCharacterToken(type, String.fromCodePoint(cp2));
  }
  //NOTE: used when we emit characters explicitly.
  //This is always for non-whitespace and non-null characters, which allows us to avoid additional checks.
  _emitChars(ch2) {
    this._appendCharToCurrentCharacterToken(TokenType.CHARACTER, ch2);
  }
  // Character reference helpers
  _startCharacterReference() {
    this.returnState = this.state;
    this.state = State.CHARACTER_REFERENCE;
    this.entityStartPos = this.preprocessor.pos;
    this.entityDecoder.startEntity(this._isCharacterReferenceInAttribute() ? DecodingMode.Attribute : DecodingMode.Legacy);
  }
  _isCharacterReferenceInAttribute() {
    return this.returnState === State.ATTRIBUTE_VALUE_DOUBLE_QUOTED || this.returnState === State.ATTRIBUTE_VALUE_SINGLE_QUOTED || this.returnState === State.ATTRIBUTE_VALUE_UNQUOTED;
  }
  _flushCodePointConsumedAsCharacterReference(cp2) {
    if (this._isCharacterReferenceInAttribute()) {
      this.currentAttr.value += String.fromCodePoint(cp2);
    } else {
      this._emitCodePoint(cp2);
    }
  }
  // Calling states this way turns out to be much faster than any other approach.
  _callState(cp2) {
    switch (this.state) {
      case State.DATA: {
        this._stateData(cp2);
        break;
      }
      case State.RCDATA: {
        this._stateRcdata(cp2);
        break;
      }
      case State.RAWTEXT: {
        this._stateRawtext(cp2);
        break;
      }
      case State.SCRIPT_DATA: {
        this._stateScriptData(cp2);
        break;
      }
      case State.PLAINTEXT: {
        this._statePlaintext(cp2);
        break;
      }
      case State.TAG_OPEN: {
        this._stateTagOpen(cp2);
        break;
      }
      case State.END_TAG_OPEN: {
        this._stateEndTagOpen(cp2);
        break;
      }
      case State.TAG_NAME: {
        this._stateTagName(cp2);
        break;
      }
      case State.RCDATA_LESS_THAN_SIGN: {
        this._stateRcdataLessThanSign(cp2);
        break;
      }
      case State.RCDATA_END_TAG_OPEN: {
        this._stateRcdataEndTagOpen(cp2);
        break;
      }
      case State.RCDATA_END_TAG_NAME: {
        this._stateRcdataEndTagName(cp2);
        break;
      }
      case State.RAWTEXT_LESS_THAN_SIGN: {
        this._stateRawtextLessThanSign(cp2);
        break;
      }
      case State.RAWTEXT_END_TAG_OPEN: {
        this._stateRawtextEndTagOpen(cp2);
        break;
      }
      case State.RAWTEXT_END_TAG_NAME: {
        this._stateRawtextEndTagName(cp2);
        break;
      }
      case State.SCRIPT_DATA_LESS_THAN_SIGN: {
        this._stateScriptDataLessThanSign(cp2);
        break;
      }
      case State.SCRIPT_DATA_END_TAG_OPEN: {
        this._stateScriptDataEndTagOpen(cp2);
        break;
      }
      case State.SCRIPT_DATA_END_TAG_NAME: {
        this._stateScriptDataEndTagName(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPE_START: {
        this._stateScriptDataEscapeStart(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPE_START_DASH: {
        this._stateScriptDataEscapeStartDash(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED: {
        this._stateScriptDataEscaped(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED_DASH: {
        this._stateScriptDataEscapedDash(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED_DASH_DASH: {
        this._stateScriptDataEscapedDashDash(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN: {
        this._stateScriptDataEscapedLessThanSign(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED_END_TAG_OPEN: {
        this._stateScriptDataEscapedEndTagOpen(cp2);
        break;
      }
      case State.SCRIPT_DATA_ESCAPED_END_TAG_NAME: {
        this._stateScriptDataEscapedEndTagName(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPE_START: {
        this._stateScriptDataDoubleEscapeStart(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPED: {
        this._stateScriptDataDoubleEscaped(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPED_DASH: {
        this._stateScriptDataDoubleEscapedDash(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH: {
        this._stateScriptDataDoubleEscapedDashDash(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN: {
        this._stateScriptDataDoubleEscapedLessThanSign(cp2);
        break;
      }
      case State.SCRIPT_DATA_DOUBLE_ESCAPE_END: {
        this._stateScriptDataDoubleEscapeEnd(cp2);
        break;
      }
      case State.BEFORE_ATTRIBUTE_NAME: {
        this._stateBeforeAttributeName(cp2);
        break;
      }
      case State.ATTRIBUTE_NAME: {
        this._stateAttributeName(cp2);
        break;
      }
      case State.AFTER_ATTRIBUTE_NAME: {
        this._stateAfterAttributeName(cp2);
        break;
      }
      case State.BEFORE_ATTRIBUTE_VALUE: {
        this._stateBeforeAttributeValue(cp2);
        break;
      }
      case State.ATTRIBUTE_VALUE_DOUBLE_QUOTED: {
        this._stateAttributeValueDoubleQuoted(cp2);
        break;
      }
      case State.ATTRIBUTE_VALUE_SINGLE_QUOTED: {
        this._stateAttributeValueSingleQuoted(cp2);
        break;
      }
      case State.ATTRIBUTE_VALUE_UNQUOTED: {
        this._stateAttributeValueUnquoted(cp2);
        break;
      }
      case State.AFTER_ATTRIBUTE_VALUE_QUOTED: {
        this._stateAfterAttributeValueQuoted(cp2);
        break;
      }
      case State.SELF_CLOSING_START_TAG: {
        this._stateSelfClosingStartTag(cp2);
        break;
      }
      case State.BOGUS_COMMENT: {
        this._stateBogusComment(cp2);
        break;
      }
      case State.MARKUP_DECLARATION_OPEN: {
        this._stateMarkupDeclarationOpen(cp2);
        break;
      }
      case State.COMMENT_START: {
        this._stateCommentStart(cp2);
        break;
      }
      case State.COMMENT_START_DASH: {
        this._stateCommentStartDash(cp2);
        break;
      }
      case State.COMMENT: {
        this._stateComment(cp2);
        break;
      }
      case State.COMMENT_LESS_THAN_SIGN: {
        this._stateCommentLessThanSign(cp2);
        break;
      }
      case State.COMMENT_LESS_THAN_SIGN_BANG: {
        this._stateCommentLessThanSignBang(cp2);
        break;
      }
      case State.COMMENT_LESS_THAN_SIGN_BANG_DASH: {
        this._stateCommentLessThanSignBangDash(cp2);
        break;
      }
      case State.COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH: {
        this._stateCommentLessThanSignBangDashDash(cp2);
        break;
      }
      case State.COMMENT_END_DASH: {
        this._stateCommentEndDash(cp2);
        break;
      }
      case State.COMMENT_END: {
        this._stateCommentEnd(cp2);
        break;
      }
      case State.COMMENT_END_BANG: {
        this._stateCommentEndBang(cp2);
        break;
      }
      case State.DOCTYPE: {
        this._stateDoctype(cp2);
        break;
      }
      case State.BEFORE_DOCTYPE_NAME: {
        this._stateBeforeDoctypeName(cp2);
        break;
      }
      case State.DOCTYPE_NAME: {
        this._stateDoctypeName(cp2);
        break;
      }
      case State.AFTER_DOCTYPE_NAME: {
        this._stateAfterDoctypeName(cp2);
        break;
      }
      case State.AFTER_DOCTYPE_PUBLIC_KEYWORD: {
        this._stateAfterDoctypePublicKeyword(cp2);
        break;
      }
      case State.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER: {
        this._stateBeforeDoctypePublicIdentifier(cp2);
        break;
      }
      case State.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED: {
        this._stateDoctypePublicIdentifierDoubleQuoted(cp2);
        break;
      }
      case State.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED: {
        this._stateDoctypePublicIdentifierSingleQuoted(cp2);
        break;
      }
      case State.AFTER_DOCTYPE_PUBLIC_IDENTIFIER: {
        this._stateAfterDoctypePublicIdentifier(cp2);
        break;
      }
      case State.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS: {
        this._stateBetweenDoctypePublicAndSystemIdentifiers(cp2);
        break;
      }
      case State.AFTER_DOCTYPE_SYSTEM_KEYWORD: {
        this._stateAfterDoctypeSystemKeyword(cp2);
        break;
      }
      case State.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER: {
        this._stateBeforeDoctypeSystemIdentifier(cp2);
        break;
      }
      case State.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED: {
        this._stateDoctypeSystemIdentifierDoubleQuoted(cp2);
        break;
      }
      case State.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED: {
        this._stateDoctypeSystemIdentifierSingleQuoted(cp2);
        break;
      }
      case State.AFTER_DOCTYPE_SYSTEM_IDENTIFIER: {
        this._stateAfterDoctypeSystemIdentifier(cp2);
        break;
      }
      case State.BOGUS_DOCTYPE: {
        this._stateBogusDoctype(cp2);
        break;
      }
      case State.CDATA_SECTION: {
        this._stateCdataSection(cp2);
        break;
      }
      case State.CDATA_SECTION_BRACKET: {
        this._stateCdataSectionBracket(cp2);
        break;
      }
      case State.CDATA_SECTION_END: {
        this._stateCdataSectionEnd(cp2);
        break;
      }
      case State.CHARACTER_REFERENCE: {
        this._stateCharacterReference();
        break;
      }
      case State.AMBIGUOUS_AMPERSAND: {
        this._stateAmbiguousAmpersand(cp2);
        break;
      }
      default: {
        throw new Error("Unknown state");
      }
    }
  }
  // State machine
  // Data state
  //------------------------------------------------------------------
  _stateData(cp2) {
    switch (cp2) {
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.TAG_OPEN;
        break;
      }
      case CODE_POINTS.AMPERSAND: {
        this._startCharacterReference();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitCodePoint(cp2);
        break;
      }
      case CODE_POINTS.EOF: {
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  //  RCDATA state
  //------------------------------------------------------------------
  _stateRcdata(cp2) {
    switch (cp2) {
      case CODE_POINTS.AMPERSAND: {
        this._startCharacterReference();
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.RCDATA_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // RAWTEXT state
  //------------------------------------------------------------------
  _stateRawtext(cp2) {
    switch (cp2) {
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.RAWTEXT_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data state
  //------------------------------------------------------------------
  _stateScriptData(cp2) {
    switch (cp2) {
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // PLAINTEXT state
  //------------------------------------------------------------------
  _statePlaintext(cp2) {
    switch (cp2) {
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // Tag open state
  //------------------------------------------------------------------
  _stateTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this._createStartTagToken();
      this.state = State.TAG_NAME;
      this._stateTagName(cp2);
    } else
      switch (cp2) {
        case CODE_POINTS.EXCLAMATION_MARK: {
          this.state = State.MARKUP_DECLARATION_OPEN;
          break;
        }
        case CODE_POINTS.SOLIDUS: {
          this.state = State.END_TAG_OPEN;
          break;
        }
        case CODE_POINTS.QUESTION_MARK: {
          this._err(ERR.unexpectedQuestionMarkInsteadOfTagName);
          this._createCommentToken(1);
          this.state = State.BOGUS_COMMENT;
          this._stateBogusComment(cp2);
          break;
        }
        case CODE_POINTS.EOF: {
          this._err(ERR.eofBeforeTagName);
          this._emitChars("<");
          this._emitEOFToken();
          break;
        }
        default: {
          this._err(ERR.invalidFirstCharacterOfTagName);
          this._emitChars("<");
          this.state = State.DATA;
          this._stateData(cp2);
        }
      }
  }
  // End tag open state
  //------------------------------------------------------------------
  _stateEndTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this._createEndTagToken();
      this.state = State.TAG_NAME;
      this._stateTagName(cp2);
    } else
      switch (cp2) {
        case CODE_POINTS.GREATER_THAN_SIGN: {
          this._err(ERR.missingEndTagName);
          this.state = State.DATA;
          break;
        }
        case CODE_POINTS.EOF: {
          this._err(ERR.eofBeforeTagName);
          this._emitChars("</");
          this._emitEOFToken();
          break;
        }
        default: {
          this._err(ERR.invalidFirstCharacterOfTagName);
          this._createCommentToken(2);
          this.state = State.BOGUS_COMMENT;
          this._stateBogusComment(cp2);
        }
      }
  }
  // Tag name state
  //------------------------------------------------------------------
  _stateTagName(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        break;
      }
      case CODE_POINTS.SOLIDUS: {
        this.state = State.SELF_CLOSING_START_TAG;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.tagName += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        token.tagName += String.fromCodePoint(isAsciiUpper(cp2) ? toAsciiLower(cp2) : cp2);
      }
    }
  }
  // RCDATA less-than sign state
  //------------------------------------------------------------------
  _stateRcdataLessThanSign(cp2) {
    if (cp2 === CODE_POINTS.SOLIDUS) {
      this.state = State.RCDATA_END_TAG_OPEN;
    } else {
      this._emitChars("<");
      this.state = State.RCDATA;
      this._stateRcdata(cp2);
    }
  }
  // RCDATA end tag open state
  //------------------------------------------------------------------
  _stateRcdataEndTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this.state = State.RCDATA_END_TAG_NAME;
      this._stateRcdataEndTagName(cp2);
    } else {
      this._emitChars("</");
      this.state = State.RCDATA;
      this._stateRcdata(cp2);
    }
  }
  handleSpecialEndTag(_cp) {
    if (!this.preprocessor.startsWith(this.lastStartTagName, false)) {
      return !this._ensureHibernation();
    }
    this._createEndTagToken();
    const token = this.currentToken;
    token.tagName = this.lastStartTagName;
    const cp2 = this.preprocessor.peek(this.lastStartTagName.length);
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this._advanceBy(this.lastStartTagName.length);
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        return false;
      }
      case CODE_POINTS.SOLIDUS: {
        this._advanceBy(this.lastStartTagName.length);
        this.state = State.SELF_CLOSING_START_TAG;
        return false;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._advanceBy(this.lastStartTagName.length);
        this.emitCurrentTagToken();
        this.state = State.DATA;
        return false;
      }
      default: {
        return !this._ensureHibernation();
      }
    }
  }
  // RCDATA end tag name state
  //------------------------------------------------------------------
  _stateRcdataEndTagName(cp2) {
    if (this.handleSpecialEndTag(cp2)) {
      this._emitChars("</");
      this.state = State.RCDATA;
      this._stateRcdata(cp2);
    }
  }
  // RAWTEXT less-than sign state
  //------------------------------------------------------------------
  _stateRawtextLessThanSign(cp2) {
    if (cp2 === CODE_POINTS.SOLIDUS) {
      this.state = State.RAWTEXT_END_TAG_OPEN;
    } else {
      this._emitChars("<");
      this.state = State.RAWTEXT;
      this._stateRawtext(cp2);
    }
  }
  // RAWTEXT end tag open state
  //------------------------------------------------------------------
  _stateRawtextEndTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this.state = State.RAWTEXT_END_TAG_NAME;
      this._stateRawtextEndTagName(cp2);
    } else {
      this._emitChars("</");
      this.state = State.RAWTEXT;
      this._stateRawtext(cp2);
    }
  }
  // RAWTEXT end tag name state
  //------------------------------------------------------------------
  _stateRawtextEndTagName(cp2) {
    if (this.handleSpecialEndTag(cp2)) {
      this._emitChars("</");
      this.state = State.RAWTEXT;
      this._stateRawtext(cp2);
    }
  }
  // Script data less-than sign state
  //------------------------------------------------------------------
  _stateScriptDataLessThanSign(cp2) {
    switch (cp2) {
      case CODE_POINTS.SOLIDUS: {
        this.state = State.SCRIPT_DATA_END_TAG_OPEN;
        break;
      }
      case CODE_POINTS.EXCLAMATION_MARK: {
        this.state = State.SCRIPT_DATA_ESCAPE_START;
        this._emitChars("<!");
        break;
      }
      default: {
        this._emitChars("<");
        this.state = State.SCRIPT_DATA;
        this._stateScriptData(cp2);
      }
    }
  }
  // Script data end tag open state
  //------------------------------------------------------------------
  _stateScriptDataEndTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this.state = State.SCRIPT_DATA_END_TAG_NAME;
      this._stateScriptDataEndTagName(cp2);
    } else {
      this._emitChars("</");
      this.state = State.SCRIPT_DATA;
      this._stateScriptData(cp2);
    }
  }
  // Script data end tag name state
  //------------------------------------------------------------------
  _stateScriptDataEndTagName(cp2) {
    if (this.handleSpecialEndTag(cp2)) {
      this._emitChars("</");
      this.state = State.SCRIPT_DATA;
      this._stateScriptData(cp2);
    }
  }
  // Script data escape start state
  //------------------------------------------------------------------
  _stateScriptDataEscapeStart(cp2) {
    if (cp2 === CODE_POINTS.HYPHEN_MINUS) {
      this.state = State.SCRIPT_DATA_ESCAPE_START_DASH;
      this._emitChars("-");
    } else {
      this.state = State.SCRIPT_DATA;
      this._stateScriptData(cp2);
    }
  }
  // Script data escape start dash state
  //------------------------------------------------------------------
  _stateScriptDataEscapeStartDash(cp2) {
    if (cp2 === CODE_POINTS.HYPHEN_MINUS) {
      this.state = State.SCRIPT_DATA_ESCAPED_DASH_DASH;
      this._emitChars("-");
    } else {
      this.state = State.SCRIPT_DATA;
      this._stateScriptData(cp2);
    }
  }
  // Script data escaped state
  //------------------------------------------------------------------
  _stateScriptDataEscaped(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.SCRIPT_DATA_ESCAPED_DASH;
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data escaped dash state
  //------------------------------------------------------------------
  _stateScriptDataEscapedDash(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.SCRIPT_DATA_ESCAPED_DASH_DASH;
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.state = State.SCRIPT_DATA_ESCAPED;
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this.state = State.SCRIPT_DATA_ESCAPED;
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data escaped dash dash state
  //------------------------------------------------------------------
  _stateScriptDataEscapedDashDash(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.SCRIPT_DATA;
        this._emitChars(">");
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.state = State.SCRIPT_DATA_ESCAPED;
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this.state = State.SCRIPT_DATA_ESCAPED;
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data escaped less-than sign state
  //------------------------------------------------------------------
  _stateScriptDataEscapedLessThanSign(cp2) {
    if (cp2 === CODE_POINTS.SOLIDUS) {
      this.state = State.SCRIPT_DATA_ESCAPED_END_TAG_OPEN;
    } else if (isAsciiLetter(cp2)) {
      this._emitChars("<");
      this.state = State.SCRIPT_DATA_DOUBLE_ESCAPE_START;
      this._stateScriptDataDoubleEscapeStart(cp2);
    } else {
      this._emitChars("<");
      this.state = State.SCRIPT_DATA_ESCAPED;
      this._stateScriptDataEscaped(cp2);
    }
  }
  // Script data escaped end tag open state
  //------------------------------------------------------------------
  _stateScriptDataEscapedEndTagOpen(cp2) {
    if (isAsciiLetter(cp2)) {
      this.state = State.SCRIPT_DATA_ESCAPED_END_TAG_NAME;
      this._stateScriptDataEscapedEndTagName(cp2);
    } else {
      this._emitChars("</");
      this.state = State.SCRIPT_DATA_ESCAPED;
      this._stateScriptDataEscaped(cp2);
    }
  }
  // Script data escaped end tag name state
  //------------------------------------------------------------------
  _stateScriptDataEscapedEndTagName(cp2) {
    if (this.handleSpecialEndTag(cp2)) {
      this._emitChars("</");
      this.state = State.SCRIPT_DATA_ESCAPED;
      this._stateScriptDataEscaped(cp2);
    }
  }
  // Script data double escape start state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscapeStart(cp2) {
    if (this.preprocessor.startsWith(SEQUENCES.SCRIPT, false) && isScriptDataDoubleEscapeSequenceEnd(this.preprocessor.peek(SEQUENCES.SCRIPT.length))) {
      this._emitCodePoint(cp2);
      for (let i = 0; i < SEQUENCES.SCRIPT.length; i++) {
        this._emitCodePoint(this._consume());
      }
      this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
    } else if (!this._ensureHibernation()) {
      this.state = State.SCRIPT_DATA_ESCAPED;
      this._stateScriptDataEscaped(cp2);
    }
  }
  // Script data double escaped state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscaped(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED_DASH;
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
        this._emitChars("<");
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data double escaped dash state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscapedDash(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH;
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
        this._emitChars("<");
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data double escaped dash dash state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscapedDashDash(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this._emitChars("-");
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
        this._emitChars("<");
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.SCRIPT_DATA;
        this._emitChars(">");
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
        this._emitChars(REPLACEMENT_CHARACTER);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInScriptHtmlCommentLikeText);
        this._emitEOFToken();
        break;
      }
      default: {
        this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
        this._emitCodePoint(cp2);
      }
    }
  }
  // Script data double escaped less-than sign state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscapedLessThanSign(cp2) {
    if (cp2 === CODE_POINTS.SOLIDUS) {
      this.state = State.SCRIPT_DATA_DOUBLE_ESCAPE_END;
      this._emitChars("/");
    } else {
      this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
      this._stateScriptDataDoubleEscaped(cp2);
    }
  }
  // Script data double escape end state
  //------------------------------------------------------------------
  _stateScriptDataDoubleEscapeEnd(cp2) {
    if (this.preprocessor.startsWith(SEQUENCES.SCRIPT, false) && isScriptDataDoubleEscapeSequenceEnd(this.preprocessor.peek(SEQUENCES.SCRIPT.length))) {
      this._emitCodePoint(cp2);
      for (let i = 0; i < SEQUENCES.SCRIPT.length; i++) {
        this._emitCodePoint(this._consume());
      }
      this.state = State.SCRIPT_DATA_ESCAPED;
    } else if (!this._ensureHibernation()) {
      this.state = State.SCRIPT_DATA_DOUBLE_ESCAPED;
      this._stateScriptDataDoubleEscaped(cp2);
    }
  }
  // Before attribute name state
  //------------------------------------------------------------------
  _stateBeforeAttributeName(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.SOLIDUS:
      case CODE_POINTS.GREATER_THAN_SIGN:
      case CODE_POINTS.EOF: {
        this.state = State.AFTER_ATTRIBUTE_NAME;
        this._stateAfterAttributeName(cp2);
        break;
      }
      case CODE_POINTS.EQUALS_SIGN: {
        this._err(ERR.unexpectedEqualsSignBeforeAttributeName);
        this._createAttr("=");
        this.state = State.ATTRIBUTE_NAME;
        break;
      }
      default: {
        this._createAttr("");
        this.state = State.ATTRIBUTE_NAME;
        this._stateAttributeName(cp2);
      }
    }
  }
  // Attribute name state
  //------------------------------------------------------------------
  _stateAttributeName(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED:
      case CODE_POINTS.SOLIDUS:
      case CODE_POINTS.GREATER_THAN_SIGN:
      case CODE_POINTS.EOF: {
        this._leaveAttrName();
        this.state = State.AFTER_ATTRIBUTE_NAME;
        this._stateAfterAttributeName(cp2);
        break;
      }
      case CODE_POINTS.EQUALS_SIGN: {
        this._leaveAttrName();
        this.state = State.BEFORE_ATTRIBUTE_VALUE;
        break;
      }
      case CODE_POINTS.QUOTATION_MARK:
      case CODE_POINTS.APOSTROPHE:
      case CODE_POINTS.LESS_THAN_SIGN: {
        this._err(ERR.unexpectedCharacterInAttributeName);
        this.currentAttr.name += String.fromCodePoint(cp2);
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.currentAttr.name += REPLACEMENT_CHARACTER;
        break;
      }
      default: {
        this.currentAttr.name += String.fromCodePoint(isAsciiUpper(cp2) ? toAsciiLower(cp2) : cp2);
      }
    }
  }
  // After attribute name state
  //------------------------------------------------------------------
  _stateAfterAttributeName(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.SOLIDUS: {
        this.state = State.SELF_CLOSING_START_TAG;
        break;
      }
      case CODE_POINTS.EQUALS_SIGN: {
        this.state = State.BEFORE_ATTRIBUTE_VALUE;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this._createAttr("");
        this.state = State.ATTRIBUTE_NAME;
        this._stateAttributeName(cp2);
      }
    }
  }
  // Before attribute value state
  //------------------------------------------------------------------
  _stateBeforeAttributeValue(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        this.state = State.ATTRIBUTE_VALUE_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        this.state = State.ATTRIBUTE_VALUE_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.missingAttributeValue);
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      default: {
        this.state = State.ATTRIBUTE_VALUE_UNQUOTED;
        this._stateAttributeValueUnquoted(cp2);
      }
    }
  }
  // Attribute value (double-quoted) state
  //------------------------------------------------------------------
  _stateAttributeValueDoubleQuoted(cp2) {
    switch (cp2) {
      case CODE_POINTS.QUOTATION_MARK: {
        this.state = State.AFTER_ATTRIBUTE_VALUE_QUOTED;
        break;
      }
      case CODE_POINTS.AMPERSAND: {
        this._startCharacterReference();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.currentAttr.value += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this.currentAttr.value += String.fromCodePoint(cp2);
      }
    }
  }
  // Attribute value (single-quoted) state
  //------------------------------------------------------------------
  _stateAttributeValueSingleQuoted(cp2) {
    switch (cp2) {
      case CODE_POINTS.APOSTROPHE: {
        this.state = State.AFTER_ATTRIBUTE_VALUE_QUOTED;
        break;
      }
      case CODE_POINTS.AMPERSAND: {
        this._startCharacterReference();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.currentAttr.value += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this.currentAttr.value += String.fromCodePoint(cp2);
      }
    }
  }
  // Attribute value (unquoted) state
  //------------------------------------------------------------------
  _stateAttributeValueUnquoted(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this._leaveAttrValue();
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        break;
      }
      case CODE_POINTS.AMPERSAND: {
        this._startCharacterReference();
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._leaveAttrValue();
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        this.currentAttr.value += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.QUOTATION_MARK:
      case CODE_POINTS.APOSTROPHE:
      case CODE_POINTS.LESS_THAN_SIGN:
      case CODE_POINTS.EQUALS_SIGN:
      case CODE_POINTS.GRAVE_ACCENT: {
        this._err(ERR.unexpectedCharacterInUnquotedAttributeValue);
        this.currentAttr.value += String.fromCodePoint(cp2);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this.currentAttr.value += String.fromCodePoint(cp2);
      }
    }
  }
  // After attribute value (quoted) state
  //------------------------------------------------------------------
  _stateAfterAttributeValueQuoted(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this._leaveAttrValue();
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        break;
      }
      case CODE_POINTS.SOLIDUS: {
        this._leaveAttrValue();
        this.state = State.SELF_CLOSING_START_TAG;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._leaveAttrValue();
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingWhitespaceBetweenAttributes);
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        this._stateBeforeAttributeName(cp2);
      }
    }
  }
  // Self-closing start tag state
  //------------------------------------------------------------------
  _stateSelfClosingStartTag(cp2) {
    switch (cp2) {
      case CODE_POINTS.GREATER_THAN_SIGN: {
        const token = this.currentToken;
        token.selfClosing = true;
        this.state = State.DATA;
        this.emitCurrentTagToken();
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInTag);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.unexpectedSolidusInTag);
        this.state = State.BEFORE_ATTRIBUTE_NAME;
        this._stateBeforeAttributeName(cp2);
      }
    }
  }
  // Bogus comment state
  //------------------------------------------------------------------
  _stateBogusComment(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentComment(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.data += REPLACEMENT_CHARACTER;
        break;
      }
      default: {
        token.data += String.fromCodePoint(cp2);
      }
    }
  }
  // Markup declaration open state
  //------------------------------------------------------------------
  _stateMarkupDeclarationOpen(cp2) {
    if (this._consumeSequenceIfMatch(SEQUENCES.DASH_DASH, true)) {
      this._createCommentToken(SEQUENCES.DASH_DASH.length + 1);
      this.state = State.COMMENT_START;
    } else if (this._consumeSequenceIfMatch(SEQUENCES.DOCTYPE, false)) {
      this.currentLocation = this.getCurrentLocation(SEQUENCES.DOCTYPE.length + 1);
      this.state = State.DOCTYPE;
    } else if (this._consumeSequenceIfMatch(SEQUENCES.CDATA_START, true)) {
      if (this.inForeignNode) {
        this.state = State.CDATA_SECTION;
      } else {
        this._err(ERR.cdataInHtmlContent);
        this._createCommentToken(SEQUENCES.CDATA_START.length + 1);
        this.currentToken.data = "[CDATA[";
        this.state = State.BOGUS_COMMENT;
      }
    } else if (!this._ensureHibernation()) {
      this._err(ERR.incorrectlyOpenedComment);
      this._createCommentToken(2);
      this.state = State.BOGUS_COMMENT;
      this._stateBogusComment(cp2);
    }
  }
  // Comment start state
  //------------------------------------------------------------------
  _stateCommentStart(cp2) {
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.COMMENT_START_DASH;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptClosingOfEmptyComment);
        this.state = State.DATA;
        const token = this.currentToken;
        this.emitCurrentComment(token);
        break;
      }
      default: {
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // Comment start dash state
  //------------------------------------------------------------------
  _stateCommentStartDash(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.COMMENT_END;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptClosingOfEmptyComment);
        this.state = State.DATA;
        this.emitCurrentComment(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInComment);
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.data += "-";
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // Comment state
  //------------------------------------------------------------------
  _stateComment(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.COMMENT_END_DASH;
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        token.data += "<";
        this.state = State.COMMENT_LESS_THAN_SIGN;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.data += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInComment);
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.data += String.fromCodePoint(cp2);
      }
    }
  }
  // Comment less-than sign state
  //------------------------------------------------------------------
  _stateCommentLessThanSign(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.EXCLAMATION_MARK: {
        token.data += "!";
        this.state = State.COMMENT_LESS_THAN_SIGN_BANG;
        break;
      }
      case CODE_POINTS.LESS_THAN_SIGN: {
        token.data += "<";
        break;
      }
      default: {
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // Comment less-than sign bang state
  //------------------------------------------------------------------
  _stateCommentLessThanSignBang(cp2) {
    if (cp2 === CODE_POINTS.HYPHEN_MINUS) {
      this.state = State.COMMENT_LESS_THAN_SIGN_BANG_DASH;
    } else {
      this.state = State.COMMENT;
      this._stateComment(cp2);
    }
  }
  // Comment less-than sign bang dash state
  //------------------------------------------------------------------
  _stateCommentLessThanSignBangDash(cp2) {
    if (cp2 === CODE_POINTS.HYPHEN_MINUS) {
      this.state = State.COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH;
    } else {
      this.state = State.COMMENT_END_DASH;
      this._stateCommentEndDash(cp2);
    }
  }
  // Comment less-than sign bang dash dash state
  //------------------------------------------------------------------
  _stateCommentLessThanSignBangDashDash(cp2) {
    if (cp2 !== CODE_POINTS.GREATER_THAN_SIGN && cp2 !== CODE_POINTS.EOF) {
      this._err(ERR.nestedComment);
    }
    this.state = State.COMMENT_END;
    this._stateCommentEnd(cp2);
  }
  // Comment end dash state
  //------------------------------------------------------------------
  _stateCommentEndDash(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        this.state = State.COMMENT_END;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInComment);
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.data += "-";
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // Comment end state
  //------------------------------------------------------------------
  _stateCommentEnd(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentComment(token);
        break;
      }
      case CODE_POINTS.EXCLAMATION_MARK: {
        this.state = State.COMMENT_END_BANG;
        break;
      }
      case CODE_POINTS.HYPHEN_MINUS: {
        token.data += "-";
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInComment);
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.data += "--";
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // Comment end bang state
  //------------------------------------------------------------------
  _stateCommentEndBang(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.HYPHEN_MINUS: {
        token.data += "--!";
        this.state = State.COMMENT_END_DASH;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.incorrectlyClosedComment);
        this.state = State.DATA;
        this.emitCurrentComment(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInComment);
        this.emitCurrentComment(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.data += "--!";
        this.state = State.COMMENT;
        this._stateComment(cp2);
      }
    }
  }
  // DOCTYPE state
  //------------------------------------------------------------------
  _stateDoctype(cp2) {
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.BEFORE_DOCTYPE_NAME;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.BEFORE_DOCTYPE_NAME;
        this._stateBeforeDoctypeName(cp2);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        this._createDoctypeToken(null);
        const token = this.currentToken;
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingWhitespaceBeforeDoctypeName);
        this.state = State.BEFORE_DOCTYPE_NAME;
        this._stateBeforeDoctypeName(cp2);
      }
    }
  }
  // Before DOCTYPE name state
  //------------------------------------------------------------------
  _stateBeforeDoctypeName(cp2) {
    if (isAsciiUpper(cp2)) {
      this._createDoctypeToken(String.fromCharCode(toAsciiLower(cp2)));
      this.state = State.DOCTYPE_NAME;
    } else
      switch (cp2) {
        case CODE_POINTS.SPACE:
        case CODE_POINTS.LINE_FEED:
        case CODE_POINTS.TABULATION:
        case CODE_POINTS.FORM_FEED: {
          break;
        }
        case CODE_POINTS.NULL: {
          this._err(ERR.unexpectedNullCharacter);
          this._createDoctypeToken(REPLACEMENT_CHARACTER);
          this.state = State.DOCTYPE_NAME;
          break;
        }
        case CODE_POINTS.GREATER_THAN_SIGN: {
          this._err(ERR.missingDoctypeName);
          this._createDoctypeToken(null);
          const token = this.currentToken;
          token.forceQuirks = true;
          this.emitCurrentDoctype(token);
          this.state = State.DATA;
          break;
        }
        case CODE_POINTS.EOF: {
          this._err(ERR.eofInDoctype);
          this._createDoctypeToken(null);
          const token = this.currentToken;
          token.forceQuirks = true;
          this.emitCurrentDoctype(token);
          this._emitEOFToken();
          break;
        }
        default: {
          this._createDoctypeToken(String.fromCodePoint(cp2));
          this.state = State.DOCTYPE_NAME;
        }
      }
  }
  // DOCTYPE name state
  //------------------------------------------------------------------
  _stateDoctypeName(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.AFTER_DOCTYPE_NAME;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.name += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.name += String.fromCodePoint(isAsciiUpper(cp2) ? toAsciiLower(cp2) : cp2);
      }
    }
  }
  // After DOCTYPE name state
  //------------------------------------------------------------------
  _stateAfterDoctypeName(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        if (this._consumeSequenceIfMatch(SEQUENCES.PUBLIC, false)) {
          this.state = State.AFTER_DOCTYPE_PUBLIC_KEYWORD;
        } else if (this._consumeSequenceIfMatch(SEQUENCES.SYSTEM, false)) {
          this.state = State.AFTER_DOCTYPE_SYSTEM_KEYWORD;
        } else if (!this._ensureHibernation()) {
          this._err(ERR.invalidCharacterSequenceAfterDoctypeName);
          token.forceQuirks = true;
          this.state = State.BOGUS_DOCTYPE;
          this._stateBogusDoctype(cp2);
        }
      }
    }
  }
  // After DOCTYPE public keyword state
  //------------------------------------------------------------------
  _stateAfterDoctypePublicKeyword(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER;
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        this._err(ERR.missingWhitespaceAfterDoctypePublicKeyword);
        token.publicId = "";
        this.state = State.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        this._err(ERR.missingWhitespaceAfterDoctypePublicKeyword);
        token.publicId = "";
        this.state = State.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.missingDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // Before DOCTYPE public identifier state
  //------------------------------------------------------------------
  _stateBeforeDoctypePublicIdentifier(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        token.publicId = "";
        this.state = State.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        token.publicId = "";
        this.state = State.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.missingDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // DOCTYPE public identifier (double-quoted) state
  //------------------------------------------------------------------
  _stateDoctypePublicIdentifierDoubleQuoted(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.QUOTATION_MARK: {
        this.state = State.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.publicId += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.publicId += String.fromCodePoint(cp2);
      }
    }
  }
  // DOCTYPE public identifier (single-quoted) state
  //------------------------------------------------------------------
  _stateDoctypePublicIdentifierSingleQuoted(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.APOSTROPHE: {
        this.state = State.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.publicId += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptDoctypePublicIdentifier);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.publicId += String.fromCodePoint(cp2);
      }
    }
  }
  // After DOCTYPE public identifier state
  //------------------------------------------------------------------
  _stateAfterDoctypePublicIdentifier(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        this._err(ERR.missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers);
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        this._err(ERR.missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers);
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // Between DOCTYPE public and system identifiers state
  //------------------------------------------------------------------
  _stateBetweenDoctypePublicAndSystemIdentifiers(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // After DOCTYPE system keyword state
  //------------------------------------------------------------------
  _stateAfterDoctypeSystemKeyword(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        this.state = State.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER;
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        this._err(ERR.missingWhitespaceAfterDoctypeSystemKeyword);
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        this._err(ERR.missingWhitespaceAfterDoctypeSystemKeyword);
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.missingDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // Before DOCTYPE system identifier state
  //------------------------------------------------------------------
  _stateBeforeDoctypeSystemIdentifier(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.QUOTATION_MARK: {
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
        break;
      }
      case CODE_POINTS.APOSTROPHE: {
        token.systemId = "";
        this.state = State.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.missingDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.DATA;
        this.emitCurrentDoctype(token);
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.missingQuoteBeforeDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // DOCTYPE system identifier (double-quoted) state
  //------------------------------------------------------------------
  _stateDoctypeSystemIdentifierDoubleQuoted(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.QUOTATION_MARK: {
        this.state = State.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.systemId += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.systemId += String.fromCodePoint(cp2);
      }
    }
  }
  // DOCTYPE system identifier (single-quoted) state
  //------------------------------------------------------------------
  _stateDoctypeSystemIdentifierSingleQuoted(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.APOSTROPHE: {
        this.state = State.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        token.systemId += REPLACEMENT_CHARACTER;
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this._err(ERR.abruptDoctypeSystemIdentifier);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        token.systemId += String.fromCodePoint(cp2);
      }
    }
  }
  // After DOCTYPE system identifier state
  //------------------------------------------------------------------
  _stateAfterDoctypeSystemIdentifier(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.SPACE:
      case CODE_POINTS.LINE_FEED:
      case CODE_POINTS.TABULATION:
      case CODE_POINTS.FORM_FEED: {
        break;
      }
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInDoctype);
        token.forceQuirks = true;
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default: {
        this._err(ERR.unexpectedCharacterAfterDoctypeSystemIdentifier);
        this.state = State.BOGUS_DOCTYPE;
        this._stateBogusDoctype(cp2);
      }
    }
  }
  // Bogus DOCTYPE state
  //------------------------------------------------------------------
  _stateBogusDoctype(cp2) {
    const token = this.currentToken;
    switch (cp2) {
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.emitCurrentDoctype(token);
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.NULL: {
        this._err(ERR.unexpectedNullCharacter);
        break;
      }
      case CODE_POINTS.EOF: {
        this.emitCurrentDoctype(token);
        this._emitEOFToken();
        break;
      }
      default:
    }
  }
  // CDATA section state
  //------------------------------------------------------------------
  _stateCdataSection(cp2) {
    switch (cp2) {
      case CODE_POINTS.RIGHT_SQUARE_BRACKET: {
        this.state = State.CDATA_SECTION_BRACKET;
        break;
      }
      case CODE_POINTS.EOF: {
        this._err(ERR.eofInCdata);
        this._emitEOFToken();
        break;
      }
      default: {
        this._emitCodePoint(cp2);
      }
    }
  }
  // CDATA section bracket state
  //------------------------------------------------------------------
  _stateCdataSectionBracket(cp2) {
    if (cp2 === CODE_POINTS.RIGHT_SQUARE_BRACKET) {
      this.state = State.CDATA_SECTION_END;
    } else {
      this._emitChars("]");
      this.state = State.CDATA_SECTION;
      this._stateCdataSection(cp2);
    }
  }
  // CDATA section end state
  //------------------------------------------------------------------
  _stateCdataSectionEnd(cp2) {
    switch (cp2) {
      case CODE_POINTS.GREATER_THAN_SIGN: {
        this.state = State.DATA;
        break;
      }
      case CODE_POINTS.RIGHT_SQUARE_BRACKET: {
        this._emitChars("]");
        break;
      }
      default: {
        this._emitChars("]]");
        this.state = State.CDATA_SECTION;
        this._stateCdataSection(cp2);
      }
    }
  }
  // Character reference state
  //------------------------------------------------------------------
  _stateCharacterReference() {
    let length = this.entityDecoder.write(this.preprocessor.html, this.preprocessor.pos);
    if (length < 0) {
      if (this.preprocessor.lastChunkWritten) {
        length = this.entityDecoder.end();
      } else {
        this.active = false;
        this.preprocessor.pos = this.preprocessor.html.length - 1;
        this.consumedAfterSnapshot = 0;
        this.preprocessor.endOfChunkHit = true;
        return;
      }
    }
    if (length === 0) {
      this.preprocessor.pos = this.entityStartPos;
      this._flushCodePointConsumedAsCharacterReference(CODE_POINTS.AMPERSAND);
      this.state = !this._isCharacterReferenceInAttribute() && isAsciiAlphaNumeric2(this.preprocessor.peek(1)) ? State.AMBIGUOUS_AMPERSAND : this.returnState;
    } else {
      this.state = this.returnState;
    }
  }
  // Ambiguos ampersand state
  //------------------------------------------------------------------
  _stateAmbiguousAmpersand(cp2) {
    if (isAsciiAlphaNumeric2(cp2)) {
      this._flushCodePointConsumedAsCharacterReference(cp2);
    } else {
      if (cp2 === CODE_POINTS.SEMICOLON) {
        this._err(ERR.unknownNamedCharacterReference);
      }
      this.state = this.returnState;
      this._callState(cp2);
    }
  }
};

// node_modules/parse5/dist/parser/open-element-stack.js
var IMPLICIT_END_TAG_REQUIRED = /* @__PURE__ */ new Set([TAG_ID.DD, TAG_ID.DT, TAG_ID.LI, TAG_ID.OPTGROUP, TAG_ID.OPTION, TAG_ID.P, TAG_ID.RB, TAG_ID.RP, TAG_ID.RT, TAG_ID.RTC]);
var IMPLICIT_END_TAG_REQUIRED_THOROUGHLY = /* @__PURE__ */ new Set([
  ...IMPLICIT_END_TAG_REQUIRED,
  TAG_ID.CAPTION,
  TAG_ID.COLGROUP,
  TAG_ID.TBODY,
  TAG_ID.TD,
  TAG_ID.TFOOT,
  TAG_ID.TH,
  TAG_ID.THEAD,
  TAG_ID.TR
]);
var SCOPING_ELEMENTS_HTML = /* @__PURE__ */ new Set([
  TAG_ID.APPLET,
  TAG_ID.CAPTION,
  TAG_ID.HTML,
  TAG_ID.MARQUEE,
  TAG_ID.OBJECT,
  TAG_ID.TABLE,
  TAG_ID.TD,
  TAG_ID.TEMPLATE,
  TAG_ID.TH
]);
var SCOPING_ELEMENTS_HTML_LIST = /* @__PURE__ */ new Set([...SCOPING_ELEMENTS_HTML, TAG_ID.OL, TAG_ID.UL]);
var SCOPING_ELEMENTS_HTML_BUTTON = /* @__PURE__ */ new Set([...SCOPING_ELEMENTS_HTML, TAG_ID.BUTTON]);
var SCOPING_ELEMENTS_MATHML = /* @__PURE__ */ new Set([TAG_ID.ANNOTATION_XML, TAG_ID.MI, TAG_ID.MN, TAG_ID.MO, TAG_ID.MS, TAG_ID.MTEXT]);
var SCOPING_ELEMENTS_SVG = /* @__PURE__ */ new Set([TAG_ID.DESC, TAG_ID.FOREIGN_OBJECT, TAG_ID.TITLE]);
var TABLE_ROW_CONTEXT = /* @__PURE__ */ new Set([TAG_ID.TR, TAG_ID.TEMPLATE, TAG_ID.HTML]);
var TABLE_BODY_CONTEXT = /* @__PURE__ */ new Set([TAG_ID.TBODY, TAG_ID.TFOOT, TAG_ID.THEAD, TAG_ID.TEMPLATE, TAG_ID.HTML]);
var TABLE_CONTEXT = /* @__PURE__ */ new Set([TAG_ID.TABLE, TAG_ID.TEMPLATE, TAG_ID.HTML]);
var TABLE_CELLS = /* @__PURE__ */ new Set([TAG_ID.TD, TAG_ID.TH]);
var OpenElementStack = class {
  get currentTmplContentOrNode() {
    return this._isInTemplate() ? this.treeAdapter.getTemplateContent(this.current) : this.current;
  }
  constructor(document2, treeAdapter2, handler) {
    this.treeAdapter = treeAdapter2;
    this.handler = handler;
    this.items = [];
    this.tagIDs = [];
    this.stackTop = -1;
    this.tmplCount = 0;
    this.currentTagId = TAG_ID.UNKNOWN;
    this.current = document2;
  }
  //Index of element
  _indexOf(element) {
    return this.items.lastIndexOf(element, this.stackTop);
  }
  //Update current element
  _isInTemplate() {
    return this.currentTagId === TAG_ID.TEMPLATE && this.treeAdapter.getNamespaceURI(this.current) === NS.HTML;
  }
  _updateCurrentElement() {
    this.current = this.items[this.stackTop];
    this.currentTagId = this.tagIDs[this.stackTop];
  }
  //Mutations
  push(element, tagID) {
    this.stackTop++;
    this.items[this.stackTop] = element;
    this.current = element;
    this.tagIDs[this.stackTop] = tagID;
    this.currentTagId = tagID;
    if (this._isInTemplate()) {
      this.tmplCount++;
    }
    this.handler.onItemPush(element, tagID, true);
  }
  pop() {
    const popped = this.current;
    if (this.tmplCount > 0 && this._isInTemplate()) {
      this.tmplCount--;
    }
    this.stackTop--;
    this._updateCurrentElement();
    this.handler.onItemPop(popped, true);
  }
  replace(oldElement, newElement) {
    const idx = this._indexOf(oldElement);
    this.items[idx] = newElement;
    if (idx === this.stackTop) {
      this.current = newElement;
    }
  }
  insertAfter(referenceElement, newElement, newElementID) {
    const insertionIdx = this._indexOf(referenceElement) + 1;
    this.items.splice(insertionIdx, 0, newElement);
    this.tagIDs.splice(insertionIdx, 0, newElementID);
    this.stackTop++;
    if (insertionIdx === this.stackTop) {
      this._updateCurrentElement();
    }
    if (this.current && this.currentTagId !== void 0) {
      this.handler.onItemPush(this.current, this.currentTagId, insertionIdx === this.stackTop);
    }
  }
  popUntilTagNamePopped(tagName) {
    let targetIdx = this.stackTop + 1;
    do {
      targetIdx = this.tagIDs.lastIndexOf(tagName, targetIdx - 1);
    } while (targetIdx > 0 && this.treeAdapter.getNamespaceURI(this.items[targetIdx]) !== NS.HTML);
    this.shortenToLength(Math.max(targetIdx, 0));
  }
  shortenToLength(idx) {
    while (this.stackTop >= idx) {
      const popped = this.current;
      if (this.tmplCount > 0 && this._isInTemplate()) {
        this.tmplCount -= 1;
      }
      this.stackTop--;
      this._updateCurrentElement();
      this.handler.onItemPop(popped, this.stackTop < idx);
    }
  }
  popUntilElementPopped(element) {
    const idx = this._indexOf(element);
    this.shortenToLength(Math.max(idx, 0));
  }
  popUntilPopped(tagNames, targetNS) {
    const idx = this._indexOfTagNames(tagNames, targetNS);
    this.shortenToLength(Math.max(idx, 0));
  }
  popUntilNumberedHeaderPopped() {
    this.popUntilPopped(NUMBERED_HEADERS, NS.HTML);
  }
  popUntilTableCellPopped() {
    this.popUntilPopped(TABLE_CELLS, NS.HTML);
  }
  popAllUpToHtmlElement() {
    this.tmplCount = 0;
    this.shortenToLength(1);
  }
  _indexOfTagNames(tagNames, namespace) {
    for (let i = this.stackTop; i >= 0; i--) {
      if (tagNames.has(this.tagIDs[i]) && this.treeAdapter.getNamespaceURI(this.items[i]) === namespace) {
        return i;
      }
    }
    return -1;
  }
  clearBackTo(tagNames, targetNS) {
    const idx = this._indexOfTagNames(tagNames, targetNS);
    this.shortenToLength(idx + 1);
  }
  clearBackToTableContext() {
    this.clearBackTo(TABLE_CONTEXT, NS.HTML);
  }
  clearBackToTableBodyContext() {
    this.clearBackTo(TABLE_BODY_CONTEXT, NS.HTML);
  }
  clearBackToTableRowContext() {
    this.clearBackTo(TABLE_ROW_CONTEXT, NS.HTML);
  }
  remove(element) {
    const idx = this._indexOf(element);
    if (idx >= 0) {
      if (idx === this.stackTop) {
        this.pop();
      } else {
        this.items.splice(idx, 1);
        this.tagIDs.splice(idx, 1);
        this.stackTop--;
        this._updateCurrentElement();
        this.handler.onItemPop(element, false);
      }
    }
  }
  //Search
  tryPeekProperlyNestedBodyElement() {
    return this.stackTop >= 1 && this.tagIDs[1] === TAG_ID.BODY ? this.items[1] : null;
  }
  contains(element) {
    return this._indexOf(element) > -1;
  }
  getCommonAncestor(element) {
    const elementIdx = this._indexOf(element) - 1;
    return elementIdx >= 0 ? this.items[elementIdx] : null;
  }
  isRootHtmlElementCurrent() {
    return this.stackTop === 0 && this.tagIDs[0] === TAG_ID.HTML;
  }
  //Element in scope
  hasInDynamicScope(tagName, htmlScope) {
    for (let i = this.stackTop; i >= 0; i--) {
      const tn2 = this.tagIDs[i];
      switch (this.treeAdapter.getNamespaceURI(this.items[i])) {
        case NS.HTML: {
          if (tn2 === tagName)
            return true;
          if (htmlScope.has(tn2))
            return false;
          break;
        }
        case NS.SVG: {
          if (SCOPING_ELEMENTS_SVG.has(tn2))
            return false;
          break;
        }
        case NS.MATHML: {
          if (SCOPING_ELEMENTS_MATHML.has(tn2))
            return false;
          break;
        }
      }
    }
    return true;
  }
  hasInScope(tagName) {
    return this.hasInDynamicScope(tagName, SCOPING_ELEMENTS_HTML);
  }
  hasInListItemScope(tagName) {
    return this.hasInDynamicScope(tagName, SCOPING_ELEMENTS_HTML_LIST);
  }
  hasInButtonScope(tagName) {
    return this.hasInDynamicScope(tagName, SCOPING_ELEMENTS_HTML_BUTTON);
  }
  hasNumberedHeaderInScope() {
    for (let i = this.stackTop; i >= 0; i--) {
      const tn2 = this.tagIDs[i];
      switch (this.treeAdapter.getNamespaceURI(this.items[i])) {
        case NS.HTML: {
          if (NUMBERED_HEADERS.has(tn2))
            return true;
          if (SCOPING_ELEMENTS_HTML.has(tn2))
            return false;
          break;
        }
        case NS.SVG: {
          if (SCOPING_ELEMENTS_SVG.has(tn2))
            return false;
          break;
        }
        case NS.MATHML: {
          if (SCOPING_ELEMENTS_MATHML.has(tn2))
            return false;
          break;
        }
      }
    }
    return true;
  }
  hasInTableScope(tagName) {
    for (let i = this.stackTop; i >= 0; i--) {
      if (this.treeAdapter.getNamespaceURI(this.items[i]) !== NS.HTML) {
        continue;
      }
      switch (this.tagIDs[i]) {
        case tagName: {
          return true;
        }
        case TAG_ID.TABLE:
        case TAG_ID.HTML: {
          return false;
        }
      }
    }
    return true;
  }
  hasTableBodyContextInTableScope() {
    for (let i = this.stackTop; i >= 0; i--) {
      if (this.treeAdapter.getNamespaceURI(this.items[i]) !== NS.HTML) {
        continue;
      }
      switch (this.tagIDs[i]) {
        case TAG_ID.TBODY:
        case TAG_ID.THEAD:
        case TAG_ID.TFOOT: {
          return true;
        }
        case TAG_ID.TABLE:
        case TAG_ID.HTML: {
          return false;
        }
      }
    }
    return true;
  }
  hasInSelectScope(tagName) {
    for (let i = this.stackTop; i >= 0; i--) {
      if (this.treeAdapter.getNamespaceURI(this.items[i]) !== NS.HTML) {
        continue;
      }
      switch (this.tagIDs[i]) {
        case tagName: {
          return true;
        }
        case TAG_ID.OPTION:
        case TAG_ID.OPTGROUP: {
          break;
        }
        default: {
          return false;
        }
      }
    }
    return true;
  }
  //Implied end tags
  generateImpliedEndTags() {
    while (this.currentTagId !== void 0 && IMPLICIT_END_TAG_REQUIRED.has(this.currentTagId)) {
      this.pop();
    }
  }
  generateImpliedEndTagsThoroughly() {
    while (this.currentTagId !== void 0 && IMPLICIT_END_TAG_REQUIRED_THOROUGHLY.has(this.currentTagId)) {
      this.pop();
    }
  }
  generateImpliedEndTagsWithExclusion(exclusionId) {
    while (this.currentTagId !== void 0 && this.currentTagId !== exclusionId && IMPLICIT_END_TAG_REQUIRED_THOROUGHLY.has(this.currentTagId)) {
      this.pop();
    }
  }
};

// node_modules/parse5/dist/parser/formatting-element-list.js
var NOAH_ARK_CAPACITY = 3;
var EntryType;
(function(EntryType2) {
  EntryType2[EntryType2["Marker"] = 0] = "Marker";
  EntryType2[EntryType2["Element"] = 1] = "Element";
})(EntryType || (EntryType = {}));
var MARKER = { type: EntryType.Marker };
var FormattingElementList = class {
  constructor(treeAdapter2) {
    this.treeAdapter = treeAdapter2;
    this.entries = [];
    this.bookmark = null;
  }
  //Noah Ark's condition
  //OPTIMIZATION: at first we try to find possible candidates for exclusion using
  //lightweight heuristics without thorough attributes check.
  _getNoahArkConditionCandidates(newElement, neAttrs) {
    const candidates = [];
    const neAttrsLength = neAttrs.length;
    const neTagName = this.treeAdapter.getTagName(newElement);
    const neNamespaceURI = this.treeAdapter.getNamespaceURI(newElement);
    for (let i = 0; i < this.entries.length; i++) {
      const entry = this.entries[i];
      if (entry.type === EntryType.Marker) {
        break;
      }
      const { element } = entry;
      if (this.treeAdapter.getTagName(element) === neTagName && this.treeAdapter.getNamespaceURI(element) === neNamespaceURI) {
        const elementAttrs = this.treeAdapter.getAttrList(element);
        if (elementAttrs.length === neAttrsLength) {
          candidates.push({ idx: i, attrs: elementAttrs });
        }
      }
    }
    return candidates;
  }
  _ensureNoahArkCondition(newElement) {
    if (this.entries.length < NOAH_ARK_CAPACITY)
      return;
    const neAttrs = this.treeAdapter.getAttrList(newElement);
    const candidates = this._getNoahArkConditionCandidates(newElement, neAttrs);
    if (candidates.length < NOAH_ARK_CAPACITY)
      return;
    const neAttrsMap = new Map(neAttrs.map((neAttr) => [neAttr.name, neAttr.value]));
    let validCandidates = 0;
    for (let i = 0; i < candidates.length; i++) {
      const candidate = candidates[i];
      if (candidate.attrs.every((cAttr) => neAttrsMap.get(cAttr.name) === cAttr.value)) {
        validCandidates += 1;
        if (validCandidates >= NOAH_ARK_CAPACITY) {
          this.entries.splice(candidate.idx, 1);
        }
      }
    }
  }
  //Mutations
  insertMarker() {
    this.entries.unshift(MARKER);
  }
  pushElement(element, token) {
    this._ensureNoahArkCondition(element);
    this.entries.unshift({
      type: EntryType.Element,
      element,
      token
    });
  }
  insertElementAfterBookmark(element, token) {
    const bookmarkIdx = this.entries.indexOf(this.bookmark);
    this.entries.splice(bookmarkIdx, 0, {
      type: EntryType.Element,
      element,
      token
    });
  }
  removeEntry(entry) {
    const entryIndex = this.entries.indexOf(entry);
    if (entryIndex !== -1) {
      this.entries.splice(entryIndex, 1);
    }
  }
  /**
   * Clears the list of formatting elements up to the last marker.
   *
   * @see https://html.spec.whatwg.org/multipage/parsing.html#clear-the-list-of-active-formatting-elements-up-to-the-last-marker
   */
  clearToLastMarker() {
    const markerIdx = this.entries.indexOf(MARKER);
    if (markerIdx === -1) {
      this.entries.length = 0;
    } else {
      this.entries.splice(0, markerIdx + 1);
    }
  }
  //Search
  getElementEntryInScopeWithTagName(tagName) {
    const entry = this.entries.find((entry2) => entry2.type === EntryType.Marker || this.treeAdapter.getTagName(entry2.element) === tagName);
    return entry && entry.type === EntryType.Element ? entry : null;
  }
  getElementEntry(element) {
    return this.entries.find((entry) => entry.type === EntryType.Element && entry.element === element);
  }
};

// node_modules/parse5/dist/tree-adapters/default.js
var defaultTreeAdapter = {
  //Node construction
  createDocument() {
    return {
      nodeName: "#document",
      mode: DOCUMENT_MODE.NO_QUIRKS,
      childNodes: []
    };
  },
  createDocumentFragment() {
    return {
      nodeName: "#document-fragment",
      childNodes: []
    };
  },
  createElement(tagName, namespaceURI, attrs) {
    return {
      nodeName: tagName,
      tagName,
      attrs,
      namespaceURI,
      childNodes: [],
      parentNode: null
    };
  },
  createCommentNode(data) {
    return {
      nodeName: "#comment",
      data,
      parentNode: null
    };
  },
  createTextNode(value) {
    return {
      nodeName: "#text",
      value,
      parentNode: null
    };
  },
  //Tree mutation
  appendChild(parentNode, newNode) {
    parentNode.childNodes.push(newNode);
    newNode.parentNode = parentNode;
  },
  insertBefore(parentNode, newNode, referenceNode) {
    const insertionIdx = parentNode.childNodes.indexOf(referenceNode);
    parentNode.childNodes.splice(insertionIdx, 0, newNode);
    newNode.parentNode = parentNode;
  },
  setTemplateContent(templateElement, contentElement) {
    templateElement.content = contentElement;
  },
  getTemplateContent(templateElement) {
    return templateElement.content;
  },
  setDocumentType(document2, name, publicId, systemId) {
    const doctypeNode = document2.childNodes.find((node) => node.nodeName === "#documentType");
    if (doctypeNode) {
      doctypeNode.name = name;
      doctypeNode.publicId = publicId;
      doctypeNode.systemId = systemId;
    } else {
      const node = {
        nodeName: "#documentType",
        name,
        publicId,
        systemId,
        parentNode: null
      };
      defaultTreeAdapter.appendChild(document2, node);
    }
  },
  setDocumentMode(document2, mode2) {
    document2.mode = mode2;
  },
  getDocumentMode(document2) {
    return document2.mode;
  },
  detachNode(node) {
    if (node.parentNode) {
      const idx = node.parentNode.childNodes.indexOf(node);
      node.parentNode.childNodes.splice(idx, 1);
      node.parentNode = null;
    }
  },
  insertText(parentNode, text) {
    if (parentNode.childNodes.length > 0) {
      const prevNode = parentNode.childNodes[parentNode.childNodes.length - 1];
      if (defaultTreeAdapter.isTextNode(prevNode)) {
        prevNode.value += text;
        return;
      }
    }
    defaultTreeAdapter.appendChild(parentNode, defaultTreeAdapter.createTextNode(text));
  },
  insertTextBefore(parentNode, text, referenceNode) {
    const prevNode = parentNode.childNodes[parentNode.childNodes.indexOf(referenceNode) - 1];
    if (prevNode && defaultTreeAdapter.isTextNode(prevNode)) {
      prevNode.value += text;
    } else {
      defaultTreeAdapter.insertBefore(parentNode, defaultTreeAdapter.createTextNode(text), referenceNode);
    }
  },
  adoptAttributes(recipient, attrs) {
    const recipientAttrsMap = new Set(recipient.attrs.map((attr) => attr.name));
    for (let j = 0; j < attrs.length; j++) {
      if (!recipientAttrsMap.has(attrs[j].name)) {
        recipient.attrs.push(attrs[j]);
      }
    }
  },
  //Tree traversing
  getFirstChild(node) {
    return node.childNodes[0];
  },
  getChildNodes(node) {
    return node.childNodes;
  },
  getParentNode(node) {
    return node.parentNode;
  },
  getAttrList(element) {
    return element.attrs;
  },
  //Node data
  getTagName(element) {
    return element.tagName;
  },
  getNamespaceURI(element) {
    return element.namespaceURI;
  },
  getTextNodeContent(textNode) {
    return textNode.value;
  },
  getCommentNodeContent(commentNode) {
    return commentNode.data;
  },
  getDocumentTypeNodeName(doctypeNode) {
    return doctypeNode.name;
  },
  getDocumentTypeNodePublicId(doctypeNode) {
    return doctypeNode.publicId;
  },
  getDocumentTypeNodeSystemId(doctypeNode) {
    return doctypeNode.systemId;
  },
  //Node types
  isTextNode(node) {
    return node.nodeName === "#text";
  },
  isCommentNode(node) {
    return node.nodeName === "#comment";
  },
  isDocumentTypeNode(node) {
    return node.nodeName === "#documentType";
  },
  isElementNode(node) {
    return Object.prototype.hasOwnProperty.call(node, "tagName");
  },
  // Source code location
  setNodeSourceCodeLocation(node, location) {
    node.sourceCodeLocation = location;
  },
  getNodeSourceCodeLocation(node) {
    return node.sourceCodeLocation;
  },
  updateNodeSourceCodeLocation(node, endLocation) {
    node.sourceCodeLocation = { ...node.sourceCodeLocation, ...endLocation };
  }
};

// node_modules/parse5/dist/common/doctype.js
var VALID_DOCTYPE_NAME = "html";
var VALID_SYSTEM_ID = "about:legacy-compat";
var QUIRKS_MODE_SYSTEM_ID = "http://www.ibm.com/data/dtd/v11/ibmxhtml1-transitional.dtd";
var QUIRKS_MODE_PUBLIC_ID_PREFIXES = [
  "+//silmaril//dtd html pro v0r11 19970101//",
  "-//as//dtd html 3.0 aswedit + extensions//",
  "-//advasoft ltd//dtd html 3.0 aswedit + extensions//",
  "-//ietf//dtd html 2.0 level 1//",
  "-//ietf//dtd html 2.0 level 2//",
  "-//ietf//dtd html 2.0 strict level 1//",
  "-//ietf//dtd html 2.0 strict level 2//",
  "-//ietf//dtd html 2.0 strict//",
  "-//ietf//dtd html 2.0//",
  "-//ietf//dtd html 2.1e//",
  "-//ietf//dtd html 3.0//",
  "-//ietf//dtd html 3.2 final//",
  "-//ietf//dtd html 3.2//",
  "-//ietf//dtd html 3//",
  "-//ietf//dtd html level 0//",
  "-//ietf//dtd html level 1//",
  "-//ietf//dtd html level 2//",
  "-//ietf//dtd html level 3//",
  "-//ietf//dtd html strict level 0//",
  "-//ietf//dtd html strict level 1//",
  "-//ietf//dtd html strict level 2//",
  "-//ietf//dtd html strict level 3//",
  "-//ietf//dtd html strict//",
  "-//ietf//dtd html//",
  "-//metrius//dtd metrius presentational//",
  "-//microsoft//dtd internet explorer 2.0 html strict//",
  "-//microsoft//dtd internet explorer 2.0 html//",
  "-//microsoft//dtd internet explorer 2.0 tables//",
  "-//microsoft//dtd internet explorer 3.0 html strict//",
  "-//microsoft//dtd internet explorer 3.0 html//",
  "-//microsoft//dtd internet explorer 3.0 tables//",
  "-//netscape comm. corp.//dtd html//",
  "-//netscape comm. corp.//dtd strict html//",
  "-//o'reilly and associates//dtd html 2.0//",
  "-//o'reilly and associates//dtd html extended 1.0//",
  "-//o'reilly and associates//dtd html extended relaxed 1.0//",
  "-//sq//dtd html 2.0 hotmetal + extensions//",
  "-//softquad software//dtd hotmetal pro 6.0::19990601::extensions to html 4.0//",
  "-//softquad//dtd hotmetal pro 4.0::19971010::extensions to html 4.0//",
  "-//spyglass//dtd html 2.0 extended//",
  "-//sun microsystems corp.//dtd hotjava html//",
  "-//sun microsystems corp.//dtd hotjava strict html//",
  "-//w3c//dtd html 3 1995-03-24//",
  "-//w3c//dtd html 3.2 draft//",
  "-//w3c//dtd html 3.2 final//",
  "-//w3c//dtd html 3.2//",
  "-//w3c//dtd html 3.2s draft//",
  "-//w3c//dtd html 4.0 frameset//",
  "-//w3c//dtd html 4.0 transitional//",
  "-//w3c//dtd html experimental 19960712//",
  "-//w3c//dtd html experimental 970421//",
  "-//w3c//dtd w3 html//",
  "-//w3o//dtd w3 html 3.0//",
  "-//webtechs//dtd mozilla html 2.0//",
  "-//webtechs//dtd mozilla html//"
];
var QUIRKS_MODE_NO_SYSTEM_ID_PUBLIC_ID_PREFIXES = [
  ...QUIRKS_MODE_PUBLIC_ID_PREFIXES,
  "-//w3c//dtd html 4.01 frameset//",
  "-//w3c//dtd html 4.01 transitional//"
];
var QUIRKS_MODE_PUBLIC_IDS = /* @__PURE__ */ new Set([
  "-//w3o//dtd w3 html strict 3.0//en//",
  "-/w3c/dtd html 4.0 transitional/en",
  "html"
]);
var LIMITED_QUIRKS_PUBLIC_ID_PREFIXES = ["-//w3c//dtd xhtml 1.0 frameset//", "-//w3c//dtd xhtml 1.0 transitional//"];
var LIMITED_QUIRKS_WITH_SYSTEM_ID_PUBLIC_ID_PREFIXES = [
  ...LIMITED_QUIRKS_PUBLIC_ID_PREFIXES,
  "-//w3c//dtd html 4.01 frameset//",
  "-//w3c//dtd html 4.01 transitional//"
];
function hasPrefix(publicId, prefixes) {
  return prefixes.some((prefix) => publicId.startsWith(prefix));
}
function isConforming(token) {
  return token.name === VALID_DOCTYPE_NAME && token.publicId === null && (token.systemId === null || token.systemId === VALID_SYSTEM_ID);
}
function getDocumentMode(token) {
  if (token.name !== VALID_DOCTYPE_NAME) {
    return DOCUMENT_MODE.QUIRKS;
  }
  const { systemId } = token;
  if (systemId && systemId.toLowerCase() === QUIRKS_MODE_SYSTEM_ID) {
    return DOCUMENT_MODE.QUIRKS;
  }
  let { publicId } = token;
  if (publicId !== null) {
    publicId = publicId.toLowerCase();
    if (QUIRKS_MODE_PUBLIC_IDS.has(publicId)) {
      return DOCUMENT_MODE.QUIRKS;
    }
    let prefixes = systemId === null ? QUIRKS_MODE_NO_SYSTEM_ID_PUBLIC_ID_PREFIXES : QUIRKS_MODE_PUBLIC_ID_PREFIXES;
    if (hasPrefix(publicId, prefixes)) {
      return DOCUMENT_MODE.QUIRKS;
    }
    prefixes = systemId === null ? LIMITED_QUIRKS_PUBLIC_ID_PREFIXES : LIMITED_QUIRKS_WITH_SYSTEM_ID_PUBLIC_ID_PREFIXES;
    if (hasPrefix(publicId, prefixes)) {
      return DOCUMENT_MODE.LIMITED_QUIRKS;
    }
  }
  return DOCUMENT_MODE.NO_QUIRKS;
}

// node_modules/parse5/dist/common/foreign-content.js
var MIME_TYPES = {
  TEXT_HTML: "text/html",
  APPLICATION_XML: "application/xhtml+xml"
};
var DEFINITION_URL_ATTR = "definitionurl";
var ADJUSTED_DEFINITION_URL_ATTR = "definitionURL";
var SVG_ATTRS_ADJUSTMENT_MAP = new Map([
  "attributeName",
  "attributeType",
  "baseFrequency",
  "baseProfile",
  "calcMode",
  "clipPathUnits",
  "diffuseConstant",
  "edgeMode",
  "filterUnits",
  "glyphRef",
  "gradientTransform",
  "gradientUnits",
  "kernelMatrix",
  "kernelUnitLength",
  "keyPoints",
  "keySplines",
  "keyTimes",
  "lengthAdjust",
  "limitingConeAngle",
  "markerHeight",
  "markerUnits",
  "markerWidth",
  "maskContentUnits",
  "maskUnits",
  "numOctaves",
  "pathLength",
  "patternContentUnits",
  "patternTransform",
  "patternUnits",
  "pointsAtX",
  "pointsAtY",
  "pointsAtZ",
  "preserveAlpha",
  "preserveAspectRatio",
  "primitiveUnits",
  "refX",
  "refY",
  "repeatCount",
  "repeatDur",
  "requiredExtensions",
  "requiredFeatures",
  "specularConstant",
  "specularExponent",
  "spreadMethod",
  "startOffset",
  "stdDeviation",
  "stitchTiles",
  "surfaceScale",
  "systemLanguage",
  "tableValues",
  "targetX",
  "targetY",
  "textLength",
  "viewBox",
  "viewTarget",
  "xChannelSelector",
  "yChannelSelector",
  "zoomAndPan"
].map((attr) => [attr.toLowerCase(), attr]));
var XML_ATTRS_ADJUSTMENT_MAP = /* @__PURE__ */ new Map([
  ["xlink:actuate", { prefix: "xlink", name: "actuate", namespace: NS.XLINK }],
  ["xlink:arcrole", { prefix: "xlink", name: "arcrole", namespace: NS.XLINK }],
  ["xlink:href", { prefix: "xlink", name: "href", namespace: NS.XLINK }],
  ["xlink:role", { prefix: "xlink", name: "role", namespace: NS.XLINK }],
  ["xlink:show", { prefix: "xlink", name: "show", namespace: NS.XLINK }],
  ["xlink:title", { prefix: "xlink", name: "title", namespace: NS.XLINK }],
  ["xlink:type", { prefix: "xlink", name: "type", namespace: NS.XLINK }],
  ["xml:lang", { prefix: "xml", name: "lang", namespace: NS.XML }],
  ["xml:space", { prefix: "xml", name: "space", namespace: NS.XML }],
  ["xmlns", { prefix: "", name: "xmlns", namespace: NS.XMLNS }],
  ["xmlns:xlink", { prefix: "xmlns", name: "xlink", namespace: NS.XMLNS }]
]);
var SVG_TAG_NAMES_ADJUSTMENT_MAP = new Map([
  "altGlyph",
  "altGlyphDef",
  "altGlyphItem",
  "animateColor",
  "animateMotion",
  "animateTransform",
  "clipPath",
  "feBlend",
  "feColorMatrix",
  "feComponentTransfer",
  "feComposite",
  "feConvolveMatrix",
  "feDiffuseLighting",
  "feDisplacementMap",
  "feDistantLight",
  "feFlood",
  "feFuncA",
  "feFuncB",
  "feFuncG",
  "feFuncR",
  "feGaussianBlur",
  "feImage",
  "feMerge",
  "feMergeNode",
  "feMorphology",
  "feOffset",
  "fePointLight",
  "feSpecularLighting",
  "feSpotLight",
  "feTile",
  "feTurbulence",
  "foreignObject",
  "glyphRef",
  "linearGradient",
  "radialGradient",
  "textPath"
].map((tn2) => [tn2.toLowerCase(), tn2]));
var EXITS_FOREIGN_CONTENT = /* @__PURE__ */ new Set([
  TAG_ID.B,
  TAG_ID.BIG,
  TAG_ID.BLOCKQUOTE,
  TAG_ID.BODY,
  TAG_ID.BR,
  TAG_ID.CENTER,
  TAG_ID.CODE,
  TAG_ID.DD,
  TAG_ID.DIV,
  TAG_ID.DL,
  TAG_ID.DT,
  TAG_ID.EM,
  TAG_ID.EMBED,
  TAG_ID.H1,
  TAG_ID.H2,
  TAG_ID.H3,
  TAG_ID.H4,
  TAG_ID.H5,
  TAG_ID.H6,
  TAG_ID.HEAD,
  TAG_ID.HR,
  TAG_ID.I,
  TAG_ID.IMG,
  TAG_ID.LI,
  TAG_ID.LISTING,
  TAG_ID.MENU,
  TAG_ID.META,
  TAG_ID.NOBR,
  TAG_ID.OL,
  TAG_ID.P,
  TAG_ID.PRE,
  TAG_ID.RUBY,
  TAG_ID.S,
  TAG_ID.SMALL,
  TAG_ID.SPAN,
  TAG_ID.STRONG,
  TAG_ID.STRIKE,
  TAG_ID.SUB,
  TAG_ID.SUP,
  TAG_ID.TABLE,
  TAG_ID.TT,
  TAG_ID.U,
  TAG_ID.UL,
  TAG_ID.VAR
]);
function causesExit(startTagToken) {
  const tn2 = startTagToken.tagID;
  const isFontWithAttrs = tn2 === TAG_ID.FONT && startTagToken.attrs.some(({ name }) => name === ATTRS.COLOR || name === ATTRS.SIZE || name === ATTRS.FACE);
  return isFontWithAttrs || EXITS_FOREIGN_CONTENT.has(tn2);
}
function adjustTokenMathMLAttrs(token) {
  for (let i = 0; i < token.attrs.length; i++) {
    if (token.attrs[i].name === DEFINITION_URL_ATTR) {
      token.attrs[i].name = ADJUSTED_DEFINITION_URL_ATTR;
      break;
    }
  }
}
function adjustTokenSVGAttrs(token) {
  for (let i = 0; i < token.attrs.length; i++) {
    const adjustedAttrName = SVG_ATTRS_ADJUSTMENT_MAP.get(token.attrs[i].name);
    if (adjustedAttrName != null) {
      token.attrs[i].name = adjustedAttrName;
    }
  }
}
function adjustTokenXMLAttrs(token) {
  for (let i = 0; i < token.attrs.length; i++) {
    const adjustedAttrEntry = XML_ATTRS_ADJUSTMENT_MAP.get(token.attrs[i].name);
    if (adjustedAttrEntry) {
      token.attrs[i].prefix = adjustedAttrEntry.prefix;
      token.attrs[i].name = adjustedAttrEntry.name;
      token.attrs[i].namespace = adjustedAttrEntry.namespace;
    }
  }
}
function adjustTokenSVGTagName(token) {
  const adjustedTagName = SVG_TAG_NAMES_ADJUSTMENT_MAP.get(token.tagName);
  if (adjustedTagName != null) {
    token.tagName = adjustedTagName;
    token.tagID = getTagID(token.tagName);
  }
}
function isMathMLTextIntegrationPoint(tn2, ns2) {
  return ns2 === NS.MATHML && (tn2 === TAG_ID.MI || tn2 === TAG_ID.MO || tn2 === TAG_ID.MN || tn2 === TAG_ID.MS || tn2 === TAG_ID.MTEXT);
}
function isHtmlIntegrationPoint(tn2, ns2, attrs) {
  if (ns2 === NS.MATHML && tn2 === TAG_ID.ANNOTATION_XML) {
    for (let i = 0; i < attrs.length; i++) {
      if (attrs[i].name === ATTRS.ENCODING) {
        const value = attrs[i].value.toLowerCase();
        return value === MIME_TYPES.TEXT_HTML || value === MIME_TYPES.APPLICATION_XML;
      }
    }
  }
  return ns2 === NS.SVG && (tn2 === TAG_ID.FOREIGN_OBJECT || tn2 === TAG_ID.DESC || tn2 === TAG_ID.TITLE);
}
function isIntegrationPoint(tn2, ns2, attrs, foreignNS) {
  return (!foreignNS || foreignNS === NS.HTML) && isHtmlIntegrationPoint(tn2, ns2, attrs) || (!foreignNS || foreignNS === NS.MATHML) && isMathMLTextIntegrationPoint(tn2, ns2);
}

// node_modules/parse5/dist/parser/index.js
var HIDDEN_INPUT_TYPE = "hidden";
var AA_OUTER_LOOP_ITER = 8;
var AA_INNER_LOOP_ITER = 3;
var InsertionMode;
(function(InsertionMode2) {
  InsertionMode2[InsertionMode2["INITIAL"] = 0] = "INITIAL";
  InsertionMode2[InsertionMode2["BEFORE_HTML"] = 1] = "BEFORE_HTML";
  InsertionMode2[InsertionMode2["BEFORE_HEAD"] = 2] = "BEFORE_HEAD";
  InsertionMode2[InsertionMode2["IN_HEAD"] = 3] = "IN_HEAD";
  InsertionMode2[InsertionMode2["IN_HEAD_NO_SCRIPT"] = 4] = "IN_HEAD_NO_SCRIPT";
  InsertionMode2[InsertionMode2["AFTER_HEAD"] = 5] = "AFTER_HEAD";
  InsertionMode2[InsertionMode2["IN_BODY"] = 6] = "IN_BODY";
  InsertionMode2[InsertionMode2["TEXT"] = 7] = "TEXT";
  InsertionMode2[InsertionMode2["IN_TABLE"] = 8] = "IN_TABLE";
  InsertionMode2[InsertionMode2["IN_TABLE_TEXT"] = 9] = "IN_TABLE_TEXT";
  InsertionMode2[InsertionMode2["IN_CAPTION"] = 10] = "IN_CAPTION";
  InsertionMode2[InsertionMode2["IN_COLUMN_GROUP"] = 11] = "IN_COLUMN_GROUP";
  InsertionMode2[InsertionMode2["IN_TABLE_BODY"] = 12] = "IN_TABLE_BODY";
  InsertionMode2[InsertionMode2["IN_ROW"] = 13] = "IN_ROW";
  InsertionMode2[InsertionMode2["IN_CELL"] = 14] = "IN_CELL";
  InsertionMode2[InsertionMode2["IN_SELECT"] = 15] = "IN_SELECT";
  InsertionMode2[InsertionMode2["IN_SELECT_IN_TABLE"] = 16] = "IN_SELECT_IN_TABLE";
  InsertionMode2[InsertionMode2["IN_TEMPLATE"] = 17] = "IN_TEMPLATE";
  InsertionMode2[InsertionMode2["AFTER_BODY"] = 18] = "AFTER_BODY";
  InsertionMode2[InsertionMode2["IN_FRAMESET"] = 19] = "IN_FRAMESET";
  InsertionMode2[InsertionMode2["AFTER_FRAMESET"] = 20] = "AFTER_FRAMESET";
  InsertionMode2[InsertionMode2["AFTER_AFTER_BODY"] = 21] = "AFTER_AFTER_BODY";
  InsertionMode2[InsertionMode2["AFTER_AFTER_FRAMESET"] = 22] = "AFTER_AFTER_FRAMESET";
})(InsertionMode || (InsertionMode = {}));
var BASE_LOC = {
  startLine: -1,
  startCol: -1,
  startOffset: -1,
  endLine: -1,
  endCol: -1,
  endOffset: -1
};
var TABLE_STRUCTURE_TAGS = /* @__PURE__ */ new Set([TAG_ID.TABLE, TAG_ID.TBODY, TAG_ID.TFOOT, TAG_ID.THEAD, TAG_ID.TR]);
var defaultParserOptions = {
  scriptingEnabled: true,
  sourceCodeLocationInfo: false,
  treeAdapter: defaultTreeAdapter,
  onParseError: null
};
var Parser = class {
  constructor(options, document2, fragmentContext = null, scriptHandler = null) {
    this.fragmentContext = fragmentContext;
    this.scriptHandler = scriptHandler;
    this.currentToken = null;
    this.stopped = false;
    this.insertionMode = InsertionMode.INITIAL;
    this.originalInsertionMode = InsertionMode.INITIAL;
    this.headElement = null;
    this.formElement = null;
    this.currentNotInHTML = false;
    this.tmplInsertionModeStack = [];
    this.pendingCharacterTokens = [];
    this.hasNonWhitespacePendingCharacterToken = false;
    this.framesetOk = true;
    this.skipNextNewLine = false;
    this.fosterParentingEnabled = false;
    this.options = {
      ...defaultParserOptions,
      ...options
    };
    this.treeAdapter = this.options.treeAdapter;
    this.onParseError = this.options.onParseError;
    if (this.onParseError) {
      this.options.sourceCodeLocationInfo = true;
    }
    this.document = document2 !== null && document2 !== void 0 ? document2 : this.treeAdapter.createDocument();
    this.tokenizer = new Tokenizer(this.options, this);
    this.activeFormattingElements = new FormattingElementList(this.treeAdapter);
    this.fragmentContextID = fragmentContext ? getTagID(this.treeAdapter.getTagName(fragmentContext)) : TAG_ID.UNKNOWN;
    this._setContextModes(fragmentContext !== null && fragmentContext !== void 0 ? fragmentContext : this.document, this.fragmentContextID);
    this.openElements = new OpenElementStack(this.document, this.treeAdapter, this);
  }
  // API
  static parse(html, options) {
    const parser = new this(options);
    parser.tokenizer.write(html, true);
    return parser.document;
  }
  static getFragmentParser(fragmentContext, options) {
    const opts = {
      ...defaultParserOptions,
      ...options
    };
    fragmentContext !== null && fragmentContext !== void 0 ? fragmentContext : fragmentContext = opts.treeAdapter.createElement(TAG_NAMES.TEMPLATE, NS.HTML, []);
    const documentMock = opts.treeAdapter.createElement("documentmock", NS.HTML, []);
    const parser = new this(opts, documentMock, fragmentContext);
    if (parser.fragmentContextID === TAG_ID.TEMPLATE) {
      parser.tmplInsertionModeStack.unshift(InsertionMode.IN_TEMPLATE);
    }
    parser._initTokenizerForFragmentParsing();
    parser._insertFakeRootElement();
    parser._resetInsertionMode();
    parser._findFormInFragmentContext();
    return parser;
  }
  getFragment() {
    const rootElement = this.treeAdapter.getFirstChild(this.document);
    const fragment = this.treeAdapter.createDocumentFragment();
    this._adoptNodes(rootElement, fragment);
    return fragment;
  }
  //Errors
  /** @internal */
  _err(token, code, beforeToken) {
    var _a3;
    if (!this.onParseError)
      return;
    const loc = (_a3 = token.location) !== null && _a3 !== void 0 ? _a3 : BASE_LOC;
    const err = {
      code,
      startLine: loc.startLine,
      startCol: loc.startCol,
      startOffset: loc.startOffset,
      endLine: beforeToken ? loc.startLine : loc.endLine,
      endCol: beforeToken ? loc.startCol : loc.endCol,
      endOffset: beforeToken ? loc.startOffset : loc.endOffset
    };
    this.onParseError(err);
  }
  //Stack events
  /** @internal */
  onItemPush(node, tid, isTop) {
    var _a3, _b;
    (_b = (_a3 = this.treeAdapter).onItemPush) === null || _b === void 0 ? void 0 : _b.call(_a3, node);
    if (isTop && this.openElements.stackTop > 0)
      this._setContextModes(node, tid);
  }
  /** @internal */
  onItemPop(node, isTop) {
    var _a3, _b;
    if (this.options.sourceCodeLocationInfo) {
      this._setEndLocation(node, this.currentToken);
    }
    (_b = (_a3 = this.treeAdapter).onItemPop) === null || _b === void 0 ? void 0 : _b.call(_a3, node, this.openElements.current);
    if (isTop) {
      let current;
      let currentTagId;
      if (this.openElements.stackTop === 0 && this.fragmentContext) {
        current = this.fragmentContext;
        currentTagId = this.fragmentContextID;
      } else {
        ({ current, currentTagId } = this.openElements);
      }
      this._setContextModes(current, currentTagId);
    }
  }
  _setContextModes(current, tid) {
    const isHTML = current === this.document || current && this.treeAdapter.getNamespaceURI(current) === NS.HTML;
    this.currentNotInHTML = !isHTML;
    this.tokenizer.inForeignNode = !isHTML && current !== void 0 && tid !== void 0 && !this._isIntegrationPoint(tid, current);
  }
  /** @protected */
  _switchToTextParsing(currentToken, nextTokenizerState) {
    this._insertElement(currentToken, NS.HTML);
    this.tokenizer.state = nextTokenizerState;
    this.originalInsertionMode = this.insertionMode;
    this.insertionMode = InsertionMode.TEXT;
  }
  switchToPlaintextParsing() {
    this.insertionMode = InsertionMode.TEXT;
    this.originalInsertionMode = InsertionMode.IN_BODY;
    this.tokenizer.state = TokenizerMode.PLAINTEXT;
  }
  //Fragment parsing
  /** @protected */
  _getAdjustedCurrentElement() {
    return this.openElements.stackTop === 0 && this.fragmentContext ? this.fragmentContext : this.openElements.current;
  }
  /** @protected */
  _findFormInFragmentContext() {
    let node = this.fragmentContext;
    while (node) {
      if (this.treeAdapter.getTagName(node) === TAG_NAMES.FORM) {
        this.formElement = node;
        break;
      }
      node = this.treeAdapter.getParentNode(node);
    }
  }
  _initTokenizerForFragmentParsing() {
    if (!this.fragmentContext || this.treeAdapter.getNamespaceURI(this.fragmentContext) !== NS.HTML) {
      return;
    }
    switch (this.fragmentContextID) {
      case TAG_ID.TITLE:
      case TAG_ID.TEXTAREA: {
        this.tokenizer.state = TokenizerMode.RCDATA;
        break;
      }
      case TAG_ID.STYLE:
      case TAG_ID.XMP:
      case TAG_ID.IFRAME:
      case TAG_ID.NOEMBED:
      case TAG_ID.NOFRAMES:
      case TAG_ID.NOSCRIPT: {
        this.tokenizer.state = TokenizerMode.RAWTEXT;
        break;
      }
      case TAG_ID.SCRIPT: {
        this.tokenizer.state = TokenizerMode.SCRIPT_DATA;
        break;
      }
      case TAG_ID.PLAINTEXT: {
        this.tokenizer.state = TokenizerMode.PLAINTEXT;
        break;
      }
      default:
    }
  }
  //Tree mutation
  /** @protected */
  _setDocumentType(token) {
    const name = token.name || "";
    const publicId = token.publicId || "";
    const systemId = token.systemId || "";
    this.treeAdapter.setDocumentType(this.document, name, publicId, systemId);
    if (token.location) {
      const documentChildren = this.treeAdapter.getChildNodes(this.document);
      const docTypeNode = documentChildren.find((node) => this.treeAdapter.isDocumentTypeNode(node));
      if (docTypeNode) {
        this.treeAdapter.setNodeSourceCodeLocation(docTypeNode, token.location);
      }
    }
  }
  /** @protected */
  _attachElementToTree(element, location) {
    if (this.options.sourceCodeLocationInfo) {
      const loc = location && {
        ...location,
        startTag: location
      };
      this.treeAdapter.setNodeSourceCodeLocation(element, loc);
    }
    if (this._shouldFosterParentOnInsertion()) {
      this._fosterParentElement(element);
    } else {
      const parent = this.openElements.currentTmplContentOrNode;
      this.treeAdapter.appendChild(parent !== null && parent !== void 0 ? parent : this.document, element);
    }
  }
  /**
   * For self-closing tags. Add an element to the tree, but skip adding it
   * to the stack.
   */
  /** @protected */
  _appendElement(token, namespaceURI) {
    const element = this.treeAdapter.createElement(token.tagName, namespaceURI, token.attrs);
    this._attachElementToTree(element, token.location);
  }
  /** @protected */
  _insertElement(token, namespaceURI) {
    const element = this.treeAdapter.createElement(token.tagName, namespaceURI, token.attrs);
    this._attachElementToTree(element, token.location);
    this.openElements.push(element, token.tagID);
  }
  /** @protected */
  _insertFakeElement(tagName, tagID) {
    const element = this.treeAdapter.createElement(tagName, NS.HTML, []);
    this._attachElementToTree(element, null);
    this.openElements.push(element, tagID);
  }
  /** @protected */
  _insertTemplate(token) {
    const tmpl = this.treeAdapter.createElement(token.tagName, NS.HTML, token.attrs);
    const content = this.treeAdapter.createDocumentFragment();
    this.treeAdapter.setTemplateContent(tmpl, content);
    this._attachElementToTree(tmpl, token.location);
    this.openElements.push(tmpl, token.tagID);
    if (this.options.sourceCodeLocationInfo)
      this.treeAdapter.setNodeSourceCodeLocation(content, null);
  }
  /** @protected */
  _insertFakeRootElement() {
    const element = this.treeAdapter.createElement(TAG_NAMES.HTML, NS.HTML, []);
    if (this.options.sourceCodeLocationInfo)
      this.treeAdapter.setNodeSourceCodeLocation(element, null);
    this.treeAdapter.appendChild(this.openElements.current, element);
    this.openElements.push(element, TAG_ID.HTML);
  }
  /** @protected */
  _appendCommentNode(token, parent) {
    const commentNode = this.treeAdapter.createCommentNode(token.data);
    this.treeAdapter.appendChild(parent, commentNode);
    if (this.options.sourceCodeLocationInfo) {
      this.treeAdapter.setNodeSourceCodeLocation(commentNode, token.location);
    }
  }
  /** @protected */
  _insertCharacters(token) {
    let parent;
    let beforeElement;
    if (this._shouldFosterParentOnInsertion()) {
      ({ parent, beforeElement } = this._findFosterParentingLocation());
      if (beforeElement) {
        this.treeAdapter.insertTextBefore(parent, token.chars, beforeElement);
      } else {
        this.treeAdapter.insertText(parent, token.chars);
      }
    } else {
      parent = this.openElements.currentTmplContentOrNode;
      this.treeAdapter.insertText(parent, token.chars);
    }
    if (!token.location)
      return;
    const siblings = this.treeAdapter.getChildNodes(parent);
    const textNodeIdx = beforeElement ? siblings.lastIndexOf(beforeElement) : siblings.length;
    const textNode = siblings[textNodeIdx - 1];
    const tnLoc = this.treeAdapter.getNodeSourceCodeLocation(textNode);
    if (tnLoc) {
      const { endLine, endCol, endOffset } = token.location;
      this.treeAdapter.updateNodeSourceCodeLocation(textNode, { endLine, endCol, endOffset });
    } else if (this.options.sourceCodeLocationInfo) {
      this.treeAdapter.setNodeSourceCodeLocation(textNode, token.location);
    }
  }
  /** @protected */
  _adoptNodes(donor, recipient) {
    for (let child = this.treeAdapter.getFirstChild(donor); child; child = this.treeAdapter.getFirstChild(donor)) {
      this.treeAdapter.detachNode(child);
      this.treeAdapter.appendChild(recipient, child);
    }
  }
  /** @protected */
  _setEndLocation(element, closingToken) {
    if (this.treeAdapter.getNodeSourceCodeLocation(element) && closingToken.location) {
      const ctLoc = closingToken.location;
      const tn2 = this.treeAdapter.getTagName(element);
      const endLoc = (
        // NOTE: For cases like <p> <p> </p> - First 'p' closes without a closing
        // tag and for cases like <td> <p> </td> - 'p' closes without a closing tag.
        closingToken.type === TokenType.END_TAG && tn2 === closingToken.tagName ? {
          endTag: { ...ctLoc },
          endLine: ctLoc.endLine,
          endCol: ctLoc.endCol,
          endOffset: ctLoc.endOffset
        } : {
          endLine: ctLoc.startLine,
          endCol: ctLoc.startCol,
          endOffset: ctLoc.startOffset
        }
      );
      this.treeAdapter.updateNodeSourceCodeLocation(element, endLoc);
    }
  }
  //Token processing
  shouldProcessStartTagTokenInForeignContent(token) {
    if (!this.currentNotInHTML)
      return false;
    let current;
    let currentTagId;
    if (this.openElements.stackTop === 0 && this.fragmentContext) {
      current = this.fragmentContext;
      currentTagId = this.fragmentContextID;
    } else {
      ({ current, currentTagId } = this.openElements);
    }
    if (token.tagID === TAG_ID.SVG && this.treeAdapter.getTagName(current) === TAG_NAMES.ANNOTATION_XML && this.treeAdapter.getNamespaceURI(current) === NS.MATHML) {
      return false;
    }
    return (
      // Check that `current` is not an integration point for HTML or MathML elements.
      this.tokenizer.inForeignNode || // If it _is_ an integration point, then we might have to check that it is not an HTML
      // integration point.
      (token.tagID === TAG_ID.MGLYPH || token.tagID === TAG_ID.MALIGNMARK) && currentTagId !== void 0 && !this._isIntegrationPoint(currentTagId, current, NS.HTML)
    );
  }
  /** @protected */
  _processToken(token) {
    switch (token.type) {
      case TokenType.CHARACTER: {
        this.onCharacter(token);
        break;
      }
      case TokenType.NULL_CHARACTER: {
        this.onNullCharacter(token);
        break;
      }
      case TokenType.COMMENT: {
        this.onComment(token);
        break;
      }
      case TokenType.DOCTYPE: {
        this.onDoctype(token);
        break;
      }
      case TokenType.START_TAG: {
        this._processStartTag(token);
        break;
      }
      case TokenType.END_TAG: {
        this.onEndTag(token);
        break;
      }
      case TokenType.EOF: {
        this.onEof(token);
        break;
      }
      case TokenType.WHITESPACE_CHARACTER: {
        this.onWhitespaceCharacter(token);
        break;
      }
    }
  }
  //Integration points
  /** @protected */
  _isIntegrationPoint(tid, element, foreignNS) {
    const ns2 = this.treeAdapter.getNamespaceURI(element);
    const attrs = this.treeAdapter.getAttrList(element);
    return isIntegrationPoint(tid, ns2, attrs, foreignNS);
  }
  //Active formatting elements reconstruction
  /** @protected */
  _reconstructActiveFormattingElements() {
    const listLength = this.activeFormattingElements.entries.length;
    if (listLength) {
      const endIndex = this.activeFormattingElements.entries.findIndex((entry) => entry.type === EntryType.Marker || this.openElements.contains(entry.element));
      const unopenIdx = endIndex === -1 ? listLength - 1 : endIndex - 1;
      for (let i = unopenIdx; i >= 0; i--) {
        const entry = this.activeFormattingElements.entries[i];
        this._insertElement(entry.token, this.treeAdapter.getNamespaceURI(entry.element));
        entry.element = this.openElements.current;
      }
    }
  }
  //Close elements
  /** @protected */
  _closeTableCell() {
    this.openElements.generateImpliedEndTags();
    this.openElements.popUntilTableCellPopped();
    this.activeFormattingElements.clearToLastMarker();
    this.insertionMode = InsertionMode.IN_ROW;
  }
  /** @protected */
  _closePElement() {
    this.openElements.generateImpliedEndTagsWithExclusion(TAG_ID.P);
    this.openElements.popUntilTagNamePopped(TAG_ID.P);
  }
  //Insertion modes
  /** @protected */
  _resetInsertionMode() {
    for (let i = this.openElements.stackTop; i >= 0; i--) {
      switch (i === 0 && this.fragmentContext ? this.fragmentContextID : this.openElements.tagIDs[i]) {
        case TAG_ID.TR: {
          this.insertionMode = InsertionMode.IN_ROW;
          return;
        }
        case TAG_ID.TBODY:
        case TAG_ID.THEAD:
        case TAG_ID.TFOOT: {
          this.insertionMode = InsertionMode.IN_TABLE_BODY;
          return;
        }
        case TAG_ID.CAPTION: {
          this.insertionMode = InsertionMode.IN_CAPTION;
          return;
        }
        case TAG_ID.COLGROUP: {
          this.insertionMode = InsertionMode.IN_COLUMN_GROUP;
          return;
        }
        case TAG_ID.TABLE: {
          this.insertionMode = InsertionMode.IN_TABLE;
          return;
        }
        case TAG_ID.BODY: {
          this.insertionMode = InsertionMode.IN_BODY;
          return;
        }
        case TAG_ID.FRAMESET: {
          this.insertionMode = InsertionMode.IN_FRAMESET;
          return;
        }
        case TAG_ID.SELECT: {
          this._resetInsertionModeForSelect(i);
          return;
        }
        case TAG_ID.TEMPLATE: {
          this.insertionMode = this.tmplInsertionModeStack[0];
          return;
        }
        case TAG_ID.HTML: {
          this.insertionMode = this.headElement ? InsertionMode.AFTER_HEAD : InsertionMode.BEFORE_HEAD;
          return;
        }
        case TAG_ID.TD:
        case TAG_ID.TH: {
          if (i > 0) {
            this.insertionMode = InsertionMode.IN_CELL;
            return;
          }
          break;
        }
        case TAG_ID.HEAD: {
          if (i > 0) {
            this.insertionMode = InsertionMode.IN_HEAD;
            return;
          }
          break;
        }
      }
    }
    this.insertionMode = InsertionMode.IN_BODY;
  }
  /** @protected */
  _resetInsertionModeForSelect(selectIdx) {
    if (selectIdx > 0) {
      for (let i = selectIdx - 1; i > 0; i--) {
        const tn2 = this.openElements.tagIDs[i];
        if (tn2 === TAG_ID.TEMPLATE) {
          break;
        } else if (tn2 === TAG_ID.TABLE) {
          this.insertionMode = InsertionMode.IN_SELECT_IN_TABLE;
          return;
        }
      }
    }
    this.insertionMode = InsertionMode.IN_SELECT;
  }
  //Foster parenting
  /** @protected */
  _isElementCausesFosterParenting(tn2) {
    return TABLE_STRUCTURE_TAGS.has(tn2);
  }
  /** @protected */
  _shouldFosterParentOnInsertion() {
    return this.fosterParentingEnabled && this.openElements.currentTagId !== void 0 && this._isElementCausesFosterParenting(this.openElements.currentTagId);
  }
  /** @protected */
  _findFosterParentingLocation() {
    for (let i = this.openElements.stackTop; i >= 0; i--) {
      const openElement = this.openElements.items[i];
      switch (this.openElements.tagIDs[i]) {
        case TAG_ID.TEMPLATE: {
          if (this.treeAdapter.getNamespaceURI(openElement) === NS.HTML) {
            return { parent: this.treeAdapter.getTemplateContent(openElement), beforeElement: null };
          }
          break;
        }
        case TAG_ID.TABLE: {
          const parent = this.treeAdapter.getParentNode(openElement);
          if (parent) {
            return { parent, beforeElement: openElement };
          }
          return { parent: this.openElements.items[i - 1], beforeElement: null };
        }
        default:
      }
    }
    return { parent: this.openElements.items[0], beforeElement: null };
  }
  /** @protected */
  _fosterParentElement(element) {
    const location = this._findFosterParentingLocation();
    if (location.beforeElement) {
      this.treeAdapter.insertBefore(location.parent, element, location.beforeElement);
    } else {
      this.treeAdapter.appendChild(location.parent, element);
    }
  }
  //Special elements
  /** @protected */
  _isSpecialElement(element, id) {
    const ns2 = this.treeAdapter.getNamespaceURI(element);
    return SPECIAL_ELEMENTS[ns2].has(id);
  }
  /** @internal */
  onCharacter(token) {
    this.skipNextNewLine = false;
    if (this.tokenizer.inForeignNode) {
      characterInForeignContent(this, token);
      return;
    }
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        tokenInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HTML: {
        tokenBeforeHtml(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD: {
        tokenBeforeHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD: {
        tokenInHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD_NO_SCRIPT: {
        tokenInHeadNoScript(this, token);
        break;
      }
      case InsertionMode.AFTER_HEAD: {
        tokenAfterHead(this, token);
        break;
      }
      case InsertionMode.IN_BODY:
      case InsertionMode.IN_CAPTION:
      case InsertionMode.IN_CELL:
      case InsertionMode.IN_TEMPLATE: {
        characterInBody(this, token);
        break;
      }
      case InsertionMode.TEXT:
      case InsertionMode.IN_SELECT:
      case InsertionMode.IN_SELECT_IN_TABLE: {
        this._insertCharacters(token);
        break;
      }
      case InsertionMode.IN_TABLE:
      case InsertionMode.IN_TABLE_BODY:
      case InsertionMode.IN_ROW: {
        characterInTable(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        characterInTableText(this, token);
        break;
      }
      case InsertionMode.IN_COLUMN_GROUP: {
        tokenInColumnGroup(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY: {
        tokenAfterBody(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_BODY: {
        tokenAfterAfterBody(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onNullCharacter(token) {
    this.skipNextNewLine = false;
    if (this.tokenizer.inForeignNode) {
      nullCharacterInForeignContent(this, token);
      return;
    }
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        tokenInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HTML: {
        tokenBeforeHtml(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD: {
        tokenBeforeHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD: {
        tokenInHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD_NO_SCRIPT: {
        tokenInHeadNoScript(this, token);
        break;
      }
      case InsertionMode.AFTER_HEAD: {
        tokenAfterHead(this, token);
        break;
      }
      case InsertionMode.TEXT: {
        this._insertCharacters(token);
        break;
      }
      case InsertionMode.IN_TABLE:
      case InsertionMode.IN_TABLE_BODY:
      case InsertionMode.IN_ROW: {
        characterInTable(this, token);
        break;
      }
      case InsertionMode.IN_COLUMN_GROUP: {
        tokenInColumnGroup(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY: {
        tokenAfterBody(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_BODY: {
        tokenAfterAfterBody(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onComment(token) {
    this.skipNextNewLine = false;
    if (this.currentNotInHTML) {
      appendComment(this, token);
      return;
    }
    switch (this.insertionMode) {
      case InsertionMode.INITIAL:
      case InsertionMode.BEFORE_HTML:
      case InsertionMode.BEFORE_HEAD:
      case InsertionMode.IN_HEAD:
      case InsertionMode.IN_HEAD_NO_SCRIPT:
      case InsertionMode.AFTER_HEAD:
      case InsertionMode.IN_BODY:
      case InsertionMode.IN_TABLE:
      case InsertionMode.IN_CAPTION:
      case InsertionMode.IN_COLUMN_GROUP:
      case InsertionMode.IN_TABLE_BODY:
      case InsertionMode.IN_ROW:
      case InsertionMode.IN_CELL:
      case InsertionMode.IN_SELECT:
      case InsertionMode.IN_SELECT_IN_TABLE:
      case InsertionMode.IN_TEMPLATE:
      case InsertionMode.IN_FRAMESET:
      case InsertionMode.AFTER_FRAMESET: {
        appendComment(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        tokenInTableText(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY: {
        appendCommentToRootHtmlElement(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_BODY:
      case InsertionMode.AFTER_AFTER_FRAMESET: {
        appendCommentToDocument(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onDoctype(token) {
    this.skipNextNewLine = false;
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        doctypeInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD:
      case InsertionMode.IN_HEAD:
      case InsertionMode.IN_HEAD_NO_SCRIPT:
      case InsertionMode.AFTER_HEAD: {
        this._err(token, ERR.misplacedDoctype);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        tokenInTableText(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onStartTag(token) {
    this.skipNextNewLine = false;
    this.currentToken = token;
    this._processStartTag(token);
    if (token.selfClosing && !token.ackSelfClosing) {
      this._err(token, ERR.nonVoidHtmlElementStartTagWithTrailingSolidus);
    }
  }
  /**
   * Processes a given start tag.
   *
   * `onStartTag` checks if a self-closing tag was recognized. When a token
   * is moved inbetween multiple insertion modes, this check for self-closing
   * could lead to false positives. To avoid this, `_processStartTag` is used
   * for nested calls.
   *
   * @param token The token to process.
   * @protected
   */
  _processStartTag(token) {
    if (this.shouldProcessStartTagTokenInForeignContent(token)) {
      startTagInForeignContent(this, token);
    } else {
      this._startTagOutsideForeignContent(token);
    }
  }
  /** @protected */
  _startTagOutsideForeignContent(token) {
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        tokenInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HTML: {
        startTagBeforeHtml(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD: {
        startTagBeforeHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD: {
        startTagInHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD_NO_SCRIPT: {
        startTagInHeadNoScript(this, token);
        break;
      }
      case InsertionMode.AFTER_HEAD: {
        startTagAfterHead(this, token);
        break;
      }
      case InsertionMode.IN_BODY: {
        startTagInBody(this, token);
        break;
      }
      case InsertionMode.IN_TABLE: {
        startTagInTable(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        tokenInTableText(this, token);
        break;
      }
      case InsertionMode.IN_CAPTION: {
        startTagInCaption(this, token);
        break;
      }
      case InsertionMode.IN_COLUMN_GROUP: {
        startTagInColumnGroup(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_BODY: {
        startTagInTableBody(this, token);
        break;
      }
      case InsertionMode.IN_ROW: {
        startTagInRow(this, token);
        break;
      }
      case InsertionMode.IN_CELL: {
        startTagInCell(this, token);
        break;
      }
      case InsertionMode.IN_SELECT: {
        startTagInSelect(this, token);
        break;
      }
      case InsertionMode.IN_SELECT_IN_TABLE: {
        startTagInSelectInTable(this, token);
        break;
      }
      case InsertionMode.IN_TEMPLATE: {
        startTagInTemplate(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY: {
        startTagAfterBody(this, token);
        break;
      }
      case InsertionMode.IN_FRAMESET: {
        startTagInFrameset(this, token);
        break;
      }
      case InsertionMode.AFTER_FRAMESET: {
        startTagAfterFrameset(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_BODY: {
        startTagAfterAfterBody(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_FRAMESET: {
        startTagAfterAfterFrameset(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onEndTag(token) {
    this.skipNextNewLine = false;
    this.currentToken = token;
    if (this.currentNotInHTML) {
      endTagInForeignContent(this, token);
    } else {
      this._endTagOutsideForeignContent(token);
    }
  }
  /** @protected */
  _endTagOutsideForeignContent(token) {
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        tokenInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HTML: {
        endTagBeforeHtml(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD: {
        endTagBeforeHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD: {
        endTagInHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD_NO_SCRIPT: {
        endTagInHeadNoScript(this, token);
        break;
      }
      case InsertionMode.AFTER_HEAD: {
        endTagAfterHead(this, token);
        break;
      }
      case InsertionMode.IN_BODY: {
        endTagInBody(this, token);
        break;
      }
      case InsertionMode.TEXT: {
        endTagInText(this, token);
        break;
      }
      case InsertionMode.IN_TABLE: {
        endTagInTable(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        tokenInTableText(this, token);
        break;
      }
      case InsertionMode.IN_CAPTION: {
        endTagInCaption(this, token);
        break;
      }
      case InsertionMode.IN_COLUMN_GROUP: {
        endTagInColumnGroup(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_BODY: {
        endTagInTableBody(this, token);
        break;
      }
      case InsertionMode.IN_ROW: {
        endTagInRow(this, token);
        break;
      }
      case InsertionMode.IN_CELL: {
        endTagInCell(this, token);
        break;
      }
      case InsertionMode.IN_SELECT: {
        endTagInSelect(this, token);
        break;
      }
      case InsertionMode.IN_SELECT_IN_TABLE: {
        endTagInSelectInTable(this, token);
        break;
      }
      case InsertionMode.IN_TEMPLATE: {
        endTagInTemplate(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY: {
        endTagAfterBody(this, token);
        break;
      }
      case InsertionMode.IN_FRAMESET: {
        endTagInFrameset(this, token);
        break;
      }
      case InsertionMode.AFTER_FRAMESET: {
        endTagAfterFrameset(this, token);
        break;
      }
      case InsertionMode.AFTER_AFTER_BODY: {
        tokenAfterAfterBody(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onEof(token) {
    switch (this.insertionMode) {
      case InsertionMode.INITIAL: {
        tokenInInitialMode(this, token);
        break;
      }
      case InsertionMode.BEFORE_HTML: {
        tokenBeforeHtml(this, token);
        break;
      }
      case InsertionMode.BEFORE_HEAD: {
        tokenBeforeHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD: {
        tokenInHead(this, token);
        break;
      }
      case InsertionMode.IN_HEAD_NO_SCRIPT: {
        tokenInHeadNoScript(this, token);
        break;
      }
      case InsertionMode.AFTER_HEAD: {
        tokenAfterHead(this, token);
        break;
      }
      case InsertionMode.IN_BODY:
      case InsertionMode.IN_TABLE:
      case InsertionMode.IN_CAPTION:
      case InsertionMode.IN_COLUMN_GROUP:
      case InsertionMode.IN_TABLE_BODY:
      case InsertionMode.IN_ROW:
      case InsertionMode.IN_CELL:
      case InsertionMode.IN_SELECT:
      case InsertionMode.IN_SELECT_IN_TABLE: {
        eofInBody(this, token);
        break;
      }
      case InsertionMode.TEXT: {
        eofInText(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        tokenInTableText(this, token);
        break;
      }
      case InsertionMode.IN_TEMPLATE: {
        eofInTemplate(this, token);
        break;
      }
      case InsertionMode.AFTER_BODY:
      case InsertionMode.IN_FRAMESET:
      case InsertionMode.AFTER_FRAMESET:
      case InsertionMode.AFTER_AFTER_BODY:
      case InsertionMode.AFTER_AFTER_FRAMESET: {
        stopParsing(this, token);
        break;
      }
      default:
    }
  }
  /** @internal */
  onWhitespaceCharacter(token) {
    if (this.skipNextNewLine) {
      this.skipNextNewLine = false;
      if (token.chars.charCodeAt(0) === CODE_POINTS.LINE_FEED) {
        if (token.chars.length === 1) {
          return;
        }
        token.chars = token.chars.substr(1);
      }
    }
    if (this.tokenizer.inForeignNode) {
      this._insertCharacters(token);
      return;
    }
    switch (this.insertionMode) {
      case InsertionMode.IN_HEAD:
      case InsertionMode.IN_HEAD_NO_SCRIPT:
      case InsertionMode.AFTER_HEAD:
      case InsertionMode.TEXT:
      case InsertionMode.IN_COLUMN_GROUP:
      case InsertionMode.IN_SELECT:
      case InsertionMode.IN_SELECT_IN_TABLE:
      case InsertionMode.IN_FRAMESET:
      case InsertionMode.AFTER_FRAMESET: {
        this._insertCharacters(token);
        break;
      }
      case InsertionMode.IN_BODY:
      case InsertionMode.IN_CAPTION:
      case InsertionMode.IN_CELL:
      case InsertionMode.IN_TEMPLATE:
      case InsertionMode.AFTER_BODY:
      case InsertionMode.AFTER_AFTER_BODY:
      case InsertionMode.AFTER_AFTER_FRAMESET: {
        whitespaceCharacterInBody(this, token);
        break;
      }
      case InsertionMode.IN_TABLE:
      case InsertionMode.IN_TABLE_BODY:
      case InsertionMode.IN_ROW: {
        characterInTable(this, token);
        break;
      }
      case InsertionMode.IN_TABLE_TEXT: {
        whitespaceCharacterInTableText(this, token);
        break;
      }
      default:
    }
  }
};
function aaObtainFormattingElementEntry(p, token) {
  let formattingElementEntry = p.activeFormattingElements.getElementEntryInScopeWithTagName(token.tagName);
  if (formattingElementEntry) {
    if (!p.openElements.contains(formattingElementEntry.element)) {
      p.activeFormattingElements.removeEntry(formattingElementEntry);
      formattingElementEntry = null;
    } else if (!p.openElements.hasInScope(token.tagID)) {
      formattingElementEntry = null;
    }
  } else {
    genericEndTagInBody(p, token);
  }
  return formattingElementEntry;
}
function aaObtainFurthestBlock(p, formattingElementEntry) {
  let furthestBlock = null;
  let idx = p.openElements.stackTop;
  for (; idx >= 0; idx--) {
    const element = p.openElements.items[idx];
    if (element === formattingElementEntry.element) {
      break;
    }
    if (p._isSpecialElement(element, p.openElements.tagIDs[idx])) {
      furthestBlock = element;
    }
  }
  if (!furthestBlock) {
    p.openElements.shortenToLength(Math.max(idx, 0));
    p.activeFormattingElements.removeEntry(formattingElementEntry);
  }
  return furthestBlock;
}
function aaInnerLoop(p, furthestBlock, formattingElement) {
  let lastElement = furthestBlock;
  let nextElement = p.openElements.getCommonAncestor(furthestBlock);
  for (let i = 0, element = nextElement; element !== formattingElement; i++, element = nextElement) {
    nextElement = p.openElements.getCommonAncestor(element);
    const elementEntry = p.activeFormattingElements.getElementEntry(element);
    const counterOverflow = elementEntry && i >= AA_INNER_LOOP_ITER;
    const shouldRemoveFromOpenElements = !elementEntry || counterOverflow;
    if (shouldRemoveFromOpenElements) {
      if (counterOverflow) {
        p.activeFormattingElements.removeEntry(elementEntry);
      }
      p.openElements.remove(element);
    } else {
      element = aaRecreateElementFromEntry(p, elementEntry);
      if (lastElement === furthestBlock) {
        p.activeFormattingElements.bookmark = elementEntry;
      }
      p.treeAdapter.detachNode(lastElement);
      p.treeAdapter.appendChild(element, lastElement);
      lastElement = element;
    }
  }
  return lastElement;
}
function aaRecreateElementFromEntry(p, elementEntry) {
  const ns2 = p.treeAdapter.getNamespaceURI(elementEntry.element);
  const newElement = p.treeAdapter.createElement(elementEntry.token.tagName, ns2, elementEntry.token.attrs);
  p.openElements.replace(elementEntry.element, newElement);
  elementEntry.element = newElement;
  return newElement;
}
function aaInsertLastNodeInCommonAncestor(p, commonAncestor, lastElement) {
  const tn2 = p.treeAdapter.getTagName(commonAncestor);
  const tid = getTagID(tn2);
  if (p._isElementCausesFosterParenting(tid)) {
    p._fosterParentElement(lastElement);
  } else {
    const ns2 = p.treeAdapter.getNamespaceURI(commonAncestor);
    if (tid === TAG_ID.TEMPLATE && ns2 === NS.HTML) {
      commonAncestor = p.treeAdapter.getTemplateContent(commonAncestor);
    }
    p.treeAdapter.appendChild(commonAncestor, lastElement);
  }
}
function aaReplaceFormattingElement(p, furthestBlock, formattingElementEntry) {
  const ns2 = p.treeAdapter.getNamespaceURI(formattingElementEntry.element);
  const { token } = formattingElementEntry;
  const newElement = p.treeAdapter.createElement(token.tagName, ns2, token.attrs);
  p._adoptNodes(furthestBlock, newElement);
  p.treeAdapter.appendChild(furthestBlock, newElement);
  p.activeFormattingElements.insertElementAfterBookmark(newElement, token);
  p.activeFormattingElements.removeEntry(formattingElementEntry);
  p.openElements.remove(formattingElementEntry.element);
  p.openElements.insertAfter(furthestBlock, newElement, token.tagID);
}
function callAdoptionAgency(p, token) {
  for (let i = 0; i < AA_OUTER_LOOP_ITER; i++) {
    const formattingElementEntry = aaObtainFormattingElementEntry(p, token);
    if (!formattingElementEntry) {
      break;
    }
    const furthestBlock = aaObtainFurthestBlock(p, formattingElementEntry);
    if (!furthestBlock) {
      break;
    }
    p.activeFormattingElements.bookmark = formattingElementEntry;
    const lastElement = aaInnerLoop(p, furthestBlock, formattingElementEntry.element);
    const commonAncestor = p.openElements.getCommonAncestor(formattingElementEntry.element);
    p.treeAdapter.detachNode(lastElement);
    if (commonAncestor)
      aaInsertLastNodeInCommonAncestor(p, commonAncestor, lastElement);
    aaReplaceFormattingElement(p, furthestBlock, formattingElementEntry);
  }
}
function appendComment(p, token) {
  p._appendCommentNode(token, p.openElements.currentTmplContentOrNode);
}
function appendCommentToRootHtmlElement(p, token) {
  p._appendCommentNode(token, p.openElements.items[0]);
}
function appendCommentToDocument(p, token) {
  p._appendCommentNode(token, p.document);
}
function stopParsing(p, token) {
  p.stopped = true;
  if (token.location) {
    const target = p.fragmentContext ? 0 : 2;
    for (let i = p.openElements.stackTop; i >= target; i--) {
      p._setEndLocation(p.openElements.items[i], token);
    }
    if (!p.fragmentContext && p.openElements.stackTop >= 0) {
      const htmlElement = p.openElements.items[0];
      const htmlLocation = p.treeAdapter.getNodeSourceCodeLocation(htmlElement);
      if (htmlLocation && !htmlLocation.endTag) {
        p._setEndLocation(htmlElement, token);
        if (p.openElements.stackTop >= 1) {
          const bodyElement = p.openElements.items[1];
          const bodyLocation = p.treeAdapter.getNodeSourceCodeLocation(bodyElement);
          if (bodyLocation && !bodyLocation.endTag) {
            p._setEndLocation(bodyElement, token);
          }
        }
      }
    }
  }
}
function doctypeInInitialMode(p, token) {
  p._setDocumentType(token);
  const mode2 = token.forceQuirks ? DOCUMENT_MODE.QUIRKS : getDocumentMode(token);
  if (!isConforming(token)) {
    p._err(token, ERR.nonConformingDoctype);
  }
  p.treeAdapter.setDocumentMode(p.document, mode2);
  p.insertionMode = InsertionMode.BEFORE_HTML;
}
function tokenInInitialMode(p, token) {
  p._err(token, ERR.missingDoctype, true);
  p.treeAdapter.setDocumentMode(p.document, DOCUMENT_MODE.QUIRKS);
  p.insertionMode = InsertionMode.BEFORE_HTML;
  p._processToken(token);
}
function startTagBeforeHtml(p, token) {
  if (token.tagID === TAG_ID.HTML) {
    p._insertElement(token, NS.HTML);
    p.insertionMode = InsertionMode.BEFORE_HEAD;
  } else {
    tokenBeforeHtml(p, token);
  }
}
function endTagBeforeHtml(p, token) {
  const tn2 = token.tagID;
  if (tn2 === TAG_ID.HTML || tn2 === TAG_ID.HEAD || tn2 === TAG_ID.BODY || tn2 === TAG_ID.BR) {
    tokenBeforeHtml(p, token);
  }
}
function tokenBeforeHtml(p, token) {
  p._insertFakeRootElement();
  p.insertionMode = InsertionMode.BEFORE_HEAD;
  p._processToken(token);
}
function startTagBeforeHead(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.HEAD: {
      p._insertElement(token, NS.HTML);
      p.headElement = p.openElements.current;
      p.insertionMode = InsertionMode.IN_HEAD;
      break;
    }
    default: {
      tokenBeforeHead(p, token);
    }
  }
}
function endTagBeforeHead(p, token) {
  const tn2 = token.tagID;
  if (tn2 === TAG_ID.HEAD || tn2 === TAG_ID.BODY || tn2 === TAG_ID.HTML || tn2 === TAG_ID.BR) {
    tokenBeforeHead(p, token);
  } else {
    p._err(token, ERR.endTagWithoutMatchingOpenElement);
  }
}
function tokenBeforeHead(p, token) {
  p._insertFakeElement(TAG_NAMES.HEAD, TAG_ID.HEAD);
  p.headElement = p.openElements.current;
  p.insertionMode = InsertionMode.IN_HEAD;
  p._processToken(token);
}
function startTagInHead(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.BASE:
    case TAG_ID.BASEFONT:
    case TAG_ID.BGSOUND:
    case TAG_ID.LINK:
    case TAG_ID.META: {
      p._appendElement(token, NS.HTML);
      token.ackSelfClosing = true;
      break;
    }
    case TAG_ID.TITLE: {
      p._switchToTextParsing(token, TokenizerMode.RCDATA);
      break;
    }
    case TAG_ID.NOSCRIPT: {
      if (p.options.scriptingEnabled) {
        p._switchToTextParsing(token, TokenizerMode.RAWTEXT);
      } else {
        p._insertElement(token, NS.HTML);
        p.insertionMode = InsertionMode.IN_HEAD_NO_SCRIPT;
      }
      break;
    }
    case TAG_ID.NOFRAMES:
    case TAG_ID.STYLE: {
      p._switchToTextParsing(token, TokenizerMode.RAWTEXT);
      break;
    }
    case TAG_ID.SCRIPT: {
      p._switchToTextParsing(token, TokenizerMode.SCRIPT_DATA);
      break;
    }
    case TAG_ID.TEMPLATE: {
      p._insertTemplate(token);
      p.activeFormattingElements.insertMarker();
      p.framesetOk = false;
      p.insertionMode = InsertionMode.IN_TEMPLATE;
      p.tmplInsertionModeStack.unshift(InsertionMode.IN_TEMPLATE);
      break;
    }
    case TAG_ID.HEAD: {
      p._err(token, ERR.misplacedStartTagForHeadElement);
      break;
    }
    default: {
      tokenInHead(p, token);
    }
  }
}
function endTagInHead(p, token) {
  switch (token.tagID) {
    case TAG_ID.HEAD: {
      p.openElements.pop();
      p.insertionMode = InsertionMode.AFTER_HEAD;
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.BR:
    case TAG_ID.HTML: {
      tokenInHead(p, token);
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    default: {
      p._err(token, ERR.endTagWithoutMatchingOpenElement);
    }
  }
}
function templateEndTagInHead(p, token) {
  if (p.openElements.tmplCount > 0) {
    p.openElements.generateImpliedEndTagsThoroughly();
    if (p.openElements.currentTagId !== TAG_ID.TEMPLATE) {
      p._err(token, ERR.closingOfElementWithOpenChildElements);
    }
    p.openElements.popUntilTagNamePopped(TAG_ID.TEMPLATE);
    p.activeFormattingElements.clearToLastMarker();
    p.tmplInsertionModeStack.shift();
    p._resetInsertionMode();
  } else {
    p._err(token, ERR.endTagWithoutMatchingOpenElement);
  }
}
function tokenInHead(p, token) {
  p.openElements.pop();
  p.insertionMode = InsertionMode.AFTER_HEAD;
  p._processToken(token);
}
function startTagInHeadNoScript(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.BASEFONT:
    case TAG_ID.BGSOUND:
    case TAG_ID.HEAD:
    case TAG_ID.LINK:
    case TAG_ID.META:
    case TAG_ID.NOFRAMES:
    case TAG_ID.STYLE: {
      startTagInHead(p, token);
      break;
    }
    case TAG_ID.NOSCRIPT: {
      p._err(token, ERR.nestedNoscriptInHead);
      break;
    }
    default: {
      tokenInHeadNoScript(p, token);
    }
  }
}
function endTagInHeadNoScript(p, token) {
  switch (token.tagID) {
    case TAG_ID.NOSCRIPT: {
      p.openElements.pop();
      p.insertionMode = InsertionMode.IN_HEAD;
      break;
    }
    case TAG_ID.BR: {
      tokenInHeadNoScript(p, token);
      break;
    }
    default: {
      p._err(token, ERR.endTagWithoutMatchingOpenElement);
    }
  }
}
function tokenInHeadNoScript(p, token) {
  const errCode = token.type === TokenType.EOF ? ERR.openElementsLeftAfterEof : ERR.disallowedContentInNoscriptInHead;
  p._err(token, errCode);
  p.openElements.pop();
  p.insertionMode = InsertionMode.IN_HEAD;
  p._processToken(token);
}
function startTagAfterHead(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.BODY: {
      p._insertElement(token, NS.HTML);
      p.framesetOk = false;
      p.insertionMode = InsertionMode.IN_BODY;
      break;
    }
    case TAG_ID.FRAMESET: {
      p._insertElement(token, NS.HTML);
      p.insertionMode = InsertionMode.IN_FRAMESET;
      break;
    }
    case TAG_ID.BASE:
    case TAG_ID.BASEFONT:
    case TAG_ID.BGSOUND:
    case TAG_ID.LINK:
    case TAG_ID.META:
    case TAG_ID.NOFRAMES:
    case TAG_ID.SCRIPT:
    case TAG_ID.STYLE:
    case TAG_ID.TEMPLATE:
    case TAG_ID.TITLE: {
      p._err(token, ERR.abandonedHeadElementChild);
      p.openElements.push(p.headElement, TAG_ID.HEAD);
      startTagInHead(p, token);
      p.openElements.remove(p.headElement);
      break;
    }
    case TAG_ID.HEAD: {
      p._err(token, ERR.misplacedStartTagForHeadElement);
      break;
    }
    default: {
      tokenAfterHead(p, token);
    }
  }
}
function endTagAfterHead(p, token) {
  switch (token.tagID) {
    case TAG_ID.BODY:
    case TAG_ID.HTML:
    case TAG_ID.BR: {
      tokenAfterHead(p, token);
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    default: {
      p._err(token, ERR.endTagWithoutMatchingOpenElement);
    }
  }
}
function tokenAfterHead(p, token) {
  p._insertFakeElement(TAG_NAMES.BODY, TAG_ID.BODY);
  p.insertionMode = InsertionMode.IN_BODY;
  modeInBody(p, token);
}
function modeInBody(p, token) {
  switch (token.type) {
    case TokenType.CHARACTER: {
      characterInBody(p, token);
      break;
    }
    case TokenType.WHITESPACE_CHARACTER: {
      whitespaceCharacterInBody(p, token);
      break;
    }
    case TokenType.COMMENT: {
      appendComment(p, token);
      break;
    }
    case TokenType.START_TAG: {
      startTagInBody(p, token);
      break;
    }
    case TokenType.END_TAG: {
      endTagInBody(p, token);
      break;
    }
    case TokenType.EOF: {
      eofInBody(p, token);
      break;
    }
    default:
  }
}
function whitespaceCharacterInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertCharacters(token);
}
function characterInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertCharacters(token);
  p.framesetOk = false;
}
function htmlStartTagInBody(p, token) {
  if (p.openElements.tmplCount === 0) {
    p.treeAdapter.adoptAttributes(p.openElements.items[0], token.attrs);
  }
}
function bodyStartTagInBody(p, token) {
  const bodyElement = p.openElements.tryPeekProperlyNestedBodyElement();
  if (bodyElement && p.openElements.tmplCount === 0) {
    p.framesetOk = false;
    p.treeAdapter.adoptAttributes(bodyElement, token.attrs);
  }
}
function framesetStartTagInBody(p, token) {
  const bodyElement = p.openElements.tryPeekProperlyNestedBodyElement();
  if (p.framesetOk && bodyElement) {
    p.treeAdapter.detachNode(bodyElement);
    p.openElements.popAllUpToHtmlElement();
    p._insertElement(token, NS.HTML);
    p.insertionMode = InsertionMode.IN_FRAMESET;
  }
}
function addressStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._insertElement(token, NS.HTML);
}
function numberedHeaderStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  if (p.openElements.currentTagId !== void 0 && NUMBERED_HEADERS.has(p.openElements.currentTagId)) {
    p.openElements.pop();
  }
  p._insertElement(token, NS.HTML);
}
function preStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._insertElement(token, NS.HTML);
  p.skipNextNewLine = true;
  p.framesetOk = false;
}
function formStartTagInBody(p, token) {
  const inTemplate = p.openElements.tmplCount > 0;
  if (!p.formElement || inTemplate) {
    if (p.openElements.hasInButtonScope(TAG_ID.P)) {
      p._closePElement();
    }
    p._insertElement(token, NS.HTML);
    if (!inTemplate) {
      p.formElement = p.openElements.current;
    }
  }
}
function listItemStartTagInBody(p, token) {
  p.framesetOk = false;
  const tn2 = token.tagID;
  for (let i = p.openElements.stackTop; i >= 0; i--) {
    const elementId = p.openElements.tagIDs[i];
    if (tn2 === TAG_ID.LI && elementId === TAG_ID.LI || (tn2 === TAG_ID.DD || tn2 === TAG_ID.DT) && (elementId === TAG_ID.DD || elementId === TAG_ID.DT)) {
      p.openElements.generateImpliedEndTagsWithExclusion(elementId);
      p.openElements.popUntilTagNamePopped(elementId);
      break;
    }
    if (elementId !== TAG_ID.ADDRESS && elementId !== TAG_ID.DIV && elementId !== TAG_ID.P && p._isSpecialElement(p.openElements.items[i], elementId)) {
      break;
    }
  }
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._insertElement(token, NS.HTML);
}
function plaintextStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._insertElement(token, NS.HTML);
  p.tokenizer.state = TokenizerMode.PLAINTEXT;
}
function buttonStartTagInBody(p, token) {
  if (p.openElements.hasInScope(TAG_ID.BUTTON)) {
    p.openElements.generateImpliedEndTags();
    p.openElements.popUntilTagNamePopped(TAG_ID.BUTTON);
  }
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
  p.framesetOk = false;
}
function aStartTagInBody(p, token) {
  const activeElementEntry = p.activeFormattingElements.getElementEntryInScopeWithTagName(TAG_NAMES.A);
  if (activeElementEntry) {
    callAdoptionAgency(p, token);
    p.openElements.remove(activeElementEntry.element);
    p.activeFormattingElements.removeEntry(activeElementEntry);
  }
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
  p.activeFormattingElements.pushElement(p.openElements.current, token);
}
function bStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
  p.activeFormattingElements.pushElement(p.openElements.current, token);
}
function nobrStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  if (p.openElements.hasInScope(TAG_ID.NOBR)) {
    callAdoptionAgency(p, token);
    p._reconstructActiveFormattingElements();
  }
  p._insertElement(token, NS.HTML);
  p.activeFormattingElements.pushElement(p.openElements.current, token);
}
function appletStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
  p.activeFormattingElements.insertMarker();
  p.framesetOk = false;
}
function tableStartTagInBody(p, token) {
  if (p.treeAdapter.getDocumentMode(p.document) !== DOCUMENT_MODE.QUIRKS && p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._insertElement(token, NS.HTML);
  p.framesetOk = false;
  p.insertionMode = InsertionMode.IN_TABLE;
}
function areaStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._appendElement(token, NS.HTML);
  p.framesetOk = false;
  token.ackSelfClosing = true;
}
function isHiddenInput(token) {
  const inputType = getTokenAttr(token, ATTRS.TYPE);
  return inputType != null && inputType.toLowerCase() === HIDDEN_INPUT_TYPE;
}
function inputStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._appendElement(token, NS.HTML);
  if (!isHiddenInput(token)) {
    p.framesetOk = false;
  }
  token.ackSelfClosing = true;
}
function paramStartTagInBody(p, token) {
  p._appendElement(token, NS.HTML);
  token.ackSelfClosing = true;
}
function hrStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._appendElement(token, NS.HTML);
  p.framesetOk = false;
  token.ackSelfClosing = true;
}
function imageStartTagInBody(p, token) {
  token.tagName = TAG_NAMES.IMG;
  token.tagID = TAG_ID.IMG;
  areaStartTagInBody(p, token);
}
function textareaStartTagInBody(p, token) {
  p._insertElement(token, NS.HTML);
  p.skipNextNewLine = true;
  p.tokenizer.state = TokenizerMode.RCDATA;
  p.originalInsertionMode = p.insertionMode;
  p.framesetOk = false;
  p.insertionMode = InsertionMode.TEXT;
}
function xmpStartTagInBody(p, token) {
  if (p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._closePElement();
  }
  p._reconstructActiveFormattingElements();
  p.framesetOk = false;
  p._switchToTextParsing(token, TokenizerMode.RAWTEXT);
}
function iframeStartTagInBody(p, token) {
  p.framesetOk = false;
  p._switchToTextParsing(token, TokenizerMode.RAWTEXT);
}
function rawTextStartTagInBody(p, token) {
  p._switchToTextParsing(token, TokenizerMode.RAWTEXT);
}
function selectStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
  p.framesetOk = false;
  p.insertionMode = p.insertionMode === InsertionMode.IN_TABLE || p.insertionMode === InsertionMode.IN_CAPTION || p.insertionMode === InsertionMode.IN_TABLE_BODY || p.insertionMode === InsertionMode.IN_ROW || p.insertionMode === InsertionMode.IN_CELL ? InsertionMode.IN_SELECT_IN_TABLE : InsertionMode.IN_SELECT;
}
function optgroupStartTagInBody(p, token) {
  if (p.openElements.currentTagId === TAG_ID.OPTION) {
    p.openElements.pop();
  }
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
}
function rbStartTagInBody(p, token) {
  if (p.openElements.hasInScope(TAG_ID.RUBY)) {
    p.openElements.generateImpliedEndTags();
  }
  p._insertElement(token, NS.HTML);
}
function rtStartTagInBody(p, token) {
  if (p.openElements.hasInScope(TAG_ID.RUBY)) {
    p.openElements.generateImpliedEndTagsWithExclusion(TAG_ID.RTC);
  }
  p._insertElement(token, NS.HTML);
}
function mathStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  adjustTokenMathMLAttrs(token);
  adjustTokenXMLAttrs(token);
  if (token.selfClosing) {
    p._appendElement(token, NS.MATHML);
  } else {
    p._insertElement(token, NS.MATHML);
  }
  token.ackSelfClosing = true;
}
function svgStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  adjustTokenSVGAttrs(token);
  adjustTokenXMLAttrs(token);
  if (token.selfClosing) {
    p._appendElement(token, NS.SVG);
  } else {
    p._insertElement(token, NS.SVG);
  }
  token.ackSelfClosing = true;
}
function genericStartTagInBody(p, token) {
  p._reconstructActiveFormattingElements();
  p._insertElement(token, NS.HTML);
}
function startTagInBody(p, token) {
  switch (token.tagID) {
    case TAG_ID.I:
    case TAG_ID.S:
    case TAG_ID.B:
    case TAG_ID.U:
    case TAG_ID.EM:
    case TAG_ID.TT:
    case TAG_ID.BIG:
    case TAG_ID.CODE:
    case TAG_ID.FONT:
    case TAG_ID.SMALL:
    case TAG_ID.STRIKE:
    case TAG_ID.STRONG: {
      bStartTagInBody(p, token);
      break;
    }
    case TAG_ID.A: {
      aStartTagInBody(p, token);
      break;
    }
    case TAG_ID.H1:
    case TAG_ID.H2:
    case TAG_ID.H3:
    case TAG_ID.H4:
    case TAG_ID.H5:
    case TAG_ID.H6: {
      numberedHeaderStartTagInBody(p, token);
      break;
    }
    case TAG_ID.P:
    case TAG_ID.DL:
    case TAG_ID.OL:
    case TAG_ID.UL:
    case TAG_ID.DIV:
    case TAG_ID.DIR:
    case TAG_ID.NAV:
    case TAG_ID.MAIN:
    case TAG_ID.MENU:
    case TAG_ID.ASIDE:
    case TAG_ID.CENTER:
    case TAG_ID.FIGURE:
    case TAG_ID.FOOTER:
    case TAG_ID.HEADER:
    case TAG_ID.HGROUP:
    case TAG_ID.DIALOG:
    case TAG_ID.DETAILS:
    case TAG_ID.ADDRESS:
    case TAG_ID.ARTICLE:
    case TAG_ID.SEARCH:
    case TAG_ID.SECTION:
    case TAG_ID.SUMMARY:
    case TAG_ID.FIELDSET:
    case TAG_ID.BLOCKQUOTE:
    case TAG_ID.FIGCAPTION: {
      addressStartTagInBody(p, token);
      break;
    }
    case TAG_ID.LI:
    case TAG_ID.DD:
    case TAG_ID.DT: {
      listItemStartTagInBody(p, token);
      break;
    }
    case TAG_ID.BR:
    case TAG_ID.IMG:
    case TAG_ID.WBR:
    case TAG_ID.AREA:
    case TAG_ID.EMBED:
    case TAG_ID.KEYGEN: {
      areaStartTagInBody(p, token);
      break;
    }
    case TAG_ID.HR: {
      hrStartTagInBody(p, token);
      break;
    }
    case TAG_ID.RB:
    case TAG_ID.RTC: {
      rbStartTagInBody(p, token);
      break;
    }
    case TAG_ID.RT:
    case TAG_ID.RP: {
      rtStartTagInBody(p, token);
      break;
    }
    case TAG_ID.PRE:
    case TAG_ID.LISTING: {
      preStartTagInBody(p, token);
      break;
    }
    case TAG_ID.XMP: {
      xmpStartTagInBody(p, token);
      break;
    }
    case TAG_ID.SVG: {
      svgStartTagInBody(p, token);
      break;
    }
    case TAG_ID.HTML: {
      htmlStartTagInBody(p, token);
      break;
    }
    case TAG_ID.BASE:
    case TAG_ID.LINK:
    case TAG_ID.META:
    case TAG_ID.STYLE:
    case TAG_ID.TITLE:
    case TAG_ID.SCRIPT:
    case TAG_ID.BGSOUND:
    case TAG_ID.BASEFONT:
    case TAG_ID.TEMPLATE: {
      startTagInHead(p, token);
      break;
    }
    case TAG_ID.BODY: {
      bodyStartTagInBody(p, token);
      break;
    }
    case TAG_ID.FORM: {
      formStartTagInBody(p, token);
      break;
    }
    case TAG_ID.NOBR: {
      nobrStartTagInBody(p, token);
      break;
    }
    case TAG_ID.MATH: {
      mathStartTagInBody(p, token);
      break;
    }
    case TAG_ID.TABLE: {
      tableStartTagInBody(p, token);
      break;
    }
    case TAG_ID.INPUT: {
      inputStartTagInBody(p, token);
      break;
    }
    case TAG_ID.PARAM:
    case TAG_ID.TRACK:
    case TAG_ID.SOURCE: {
      paramStartTagInBody(p, token);
      break;
    }
    case TAG_ID.IMAGE: {
      imageStartTagInBody(p, token);
      break;
    }
    case TAG_ID.BUTTON: {
      buttonStartTagInBody(p, token);
      break;
    }
    case TAG_ID.APPLET:
    case TAG_ID.OBJECT:
    case TAG_ID.MARQUEE: {
      appletStartTagInBody(p, token);
      break;
    }
    case TAG_ID.IFRAME: {
      iframeStartTagInBody(p, token);
      break;
    }
    case TAG_ID.SELECT: {
      selectStartTagInBody(p, token);
      break;
    }
    case TAG_ID.OPTION:
    case TAG_ID.OPTGROUP: {
      optgroupStartTagInBody(p, token);
      break;
    }
    case TAG_ID.NOEMBED:
    case TAG_ID.NOFRAMES: {
      rawTextStartTagInBody(p, token);
      break;
    }
    case TAG_ID.FRAMESET: {
      framesetStartTagInBody(p, token);
      break;
    }
    case TAG_ID.TEXTAREA: {
      textareaStartTagInBody(p, token);
      break;
    }
    case TAG_ID.NOSCRIPT: {
      if (p.options.scriptingEnabled) {
        rawTextStartTagInBody(p, token);
      } else {
        genericStartTagInBody(p, token);
      }
      break;
    }
    case TAG_ID.PLAINTEXT: {
      plaintextStartTagInBody(p, token);
      break;
    }
    case TAG_ID.COL:
    case TAG_ID.TH:
    case TAG_ID.TD:
    case TAG_ID.TR:
    case TAG_ID.HEAD:
    case TAG_ID.FRAME:
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD:
    case TAG_ID.CAPTION:
    case TAG_ID.COLGROUP: {
      break;
    }
    default: {
      genericStartTagInBody(p, token);
    }
  }
}
function bodyEndTagInBody(p, token) {
  if (p.openElements.hasInScope(TAG_ID.BODY)) {
    p.insertionMode = InsertionMode.AFTER_BODY;
    if (p.options.sourceCodeLocationInfo) {
      const bodyElement = p.openElements.tryPeekProperlyNestedBodyElement();
      if (bodyElement) {
        p._setEndLocation(bodyElement, token);
      }
    }
  }
}
function htmlEndTagInBody(p, token) {
  if (p.openElements.hasInScope(TAG_ID.BODY)) {
    p.insertionMode = InsertionMode.AFTER_BODY;
    endTagAfterBody(p, token);
  }
}
function addressEndTagInBody(p, token) {
  const tn2 = token.tagID;
  if (p.openElements.hasInScope(tn2)) {
    p.openElements.generateImpliedEndTags();
    p.openElements.popUntilTagNamePopped(tn2);
  }
}
function formEndTagInBody(p) {
  const inTemplate = p.openElements.tmplCount > 0;
  const { formElement } = p;
  if (!inTemplate) {
    p.formElement = null;
  }
  if ((formElement || inTemplate) && p.openElements.hasInScope(TAG_ID.FORM)) {
    p.openElements.generateImpliedEndTags();
    if (inTemplate) {
      p.openElements.popUntilTagNamePopped(TAG_ID.FORM);
    } else if (formElement) {
      p.openElements.remove(formElement);
    }
  }
}
function pEndTagInBody(p) {
  if (!p.openElements.hasInButtonScope(TAG_ID.P)) {
    p._insertFakeElement(TAG_NAMES.P, TAG_ID.P);
  }
  p._closePElement();
}
function liEndTagInBody(p) {
  if (p.openElements.hasInListItemScope(TAG_ID.LI)) {
    p.openElements.generateImpliedEndTagsWithExclusion(TAG_ID.LI);
    p.openElements.popUntilTagNamePopped(TAG_ID.LI);
  }
}
function ddEndTagInBody(p, token) {
  const tn2 = token.tagID;
  if (p.openElements.hasInScope(tn2)) {
    p.openElements.generateImpliedEndTagsWithExclusion(tn2);
    p.openElements.popUntilTagNamePopped(tn2);
  }
}
function numberedHeaderEndTagInBody(p) {
  if (p.openElements.hasNumberedHeaderInScope()) {
    p.openElements.generateImpliedEndTags();
    p.openElements.popUntilNumberedHeaderPopped();
  }
}
function appletEndTagInBody(p, token) {
  const tn2 = token.tagID;
  if (p.openElements.hasInScope(tn2)) {
    p.openElements.generateImpliedEndTags();
    p.openElements.popUntilTagNamePopped(tn2);
    p.activeFormattingElements.clearToLastMarker();
  }
}
function brEndTagInBody(p) {
  p._reconstructActiveFormattingElements();
  p._insertFakeElement(TAG_NAMES.BR, TAG_ID.BR);
  p.openElements.pop();
  p.framesetOk = false;
}
function genericEndTagInBody(p, token) {
  const tn2 = token.tagName;
  const tid = token.tagID;
  for (let i = p.openElements.stackTop; i > 0; i--) {
    const element = p.openElements.items[i];
    const elementId = p.openElements.tagIDs[i];
    if (tid === elementId && (tid !== TAG_ID.UNKNOWN || p.treeAdapter.getTagName(element) === tn2)) {
      p.openElements.generateImpliedEndTagsWithExclusion(tid);
      if (p.openElements.stackTop >= i)
        p.openElements.shortenToLength(i);
      break;
    }
    if (p._isSpecialElement(element, elementId)) {
      break;
    }
  }
}
function endTagInBody(p, token) {
  switch (token.tagID) {
    case TAG_ID.A:
    case TAG_ID.B:
    case TAG_ID.I:
    case TAG_ID.S:
    case TAG_ID.U:
    case TAG_ID.EM:
    case TAG_ID.TT:
    case TAG_ID.BIG:
    case TAG_ID.CODE:
    case TAG_ID.FONT:
    case TAG_ID.NOBR:
    case TAG_ID.SMALL:
    case TAG_ID.STRIKE:
    case TAG_ID.STRONG: {
      callAdoptionAgency(p, token);
      break;
    }
    case TAG_ID.P: {
      pEndTagInBody(p);
      break;
    }
    case TAG_ID.DL:
    case TAG_ID.UL:
    case TAG_ID.OL:
    case TAG_ID.DIR:
    case TAG_ID.DIV:
    case TAG_ID.NAV:
    case TAG_ID.PRE:
    case TAG_ID.MAIN:
    case TAG_ID.MENU:
    case TAG_ID.ASIDE:
    case TAG_ID.BUTTON:
    case TAG_ID.CENTER:
    case TAG_ID.FIGURE:
    case TAG_ID.FOOTER:
    case TAG_ID.HEADER:
    case TAG_ID.HGROUP:
    case TAG_ID.DIALOG:
    case TAG_ID.ADDRESS:
    case TAG_ID.ARTICLE:
    case TAG_ID.DETAILS:
    case TAG_ID.SEARCH:
    case TAG_ID.SECTION:
    case TAG_ID.SUMMARY:
    case TAG_ID.LISTING:
    case TAG_ID.FIELDSET:
    case TAG_ID.BLOCKQUOTE:
    case TAG_ID.FIGCAPTION: {
      addressEndTagInBody(p, token);
      break;
    }
    case TAG_ID.LI: {
      liEndTagInBody(p);
      break;
    }
    case TAG_ID.DD:
    case TAG_ID.DT: {
      ddEndTagInBody(p, token);
      break;
    }
    case TAG_ID.H1:
    case TAG_ID.H2:
    case TAG_ID.H3:
    case TAG_ID.H4:
    case TAG_ID.H5:
    case TAG_ID.H6: {
      numberedHeaderEndTagInBody(p);
      break;
    }
    case TAG_ID.BR: {
      brEndTagInBody(p);
      break;
    }
    case TAG_ID.BODY: {
      bodyEndTagInBody(p, token);
      break;
    }
    case TAG_ID.HTML: {
      htmlEndTagInBody(p, token);
      break;
    }
    case TAG_ID.FORM: {
      formEndTagInBody(p);
      break;
    }
    case TAG_ID.APPLET:
    case TAG_ID.OBJECT:
    case TAG_ID.MARQUEE: {
      appletEndTagInBody(p, token);
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    default: {
      genericEndTagInBody(p, token);
    }
  }
}
function eofInBody(p, token) {
  if (p.tmplInsertionModeStack.length > 0) {
    eofInTemplate(p, token);
  } else {
    stopParsing(p, token);
  }
}
function endTagInText(p, token) {
  var _a3;
  if (token.tagID === TAG_ID.SCRIPT) {
    (_a3 = p.scriptHandler) === null || _a3 === void 0 ? void 0 : _a3.call(p, p.openElements.current);
  }
  p.openElements.pop();
  p.insertionMode = p.originalInsertionMode;
}
function eofInText(p, token) {
  p._err(token, ERR.eofInElementThatCanContainOnlyText);
  p.openElements.pop();
  p.insertionMode = p.originalInsertionMode;
  p.onEof(token);
}
function characterInTable(p, token) {
  if (p.openElements.currentTagId !== void 0 && TABLE_STRUCTURE_TAGS.has(p.openElements.currentTagId)) {
    p.pendingCharacterTokens.length = 0;
    p.hasNonWhitespacePendingCharacterToken = false;
    p.originalInsertionMode = p.insertionMode;
    p.insertionMode = InsertionMode.IN_TABLE_TEXT;
    switch (token.type) {
      case TokenType.CHARACTER: {
        characterInTableText(p, token);
        break;
      }
      case TokenType.WHITESPACE_CHARACTER: {
        whitespaceCharacterInTableText(p, token);
        break;
      }
    }
  } else {
    tokenInTable(p, token);
  }
}
function captionStartTagInTable(p, token) {
  p.openElements.clearBackToTableContext();
  p.activeFormattingElements.insertMarker();
  p._insertElement(token, NS.HTML);
  p.insertionMode = InsertionMode.IN_CAPTION;
}
function colgroupStartTagInTable(p, token) {
  p.openElements.clearBackToTableContext();
  p._insertElement(token, NS.HTML);
  p.insertionMode = InsertionMode.IN_COLUMN_GROUP;
}
function colStartTagInTable(p, token) {
  p.openElements.clearBackToTableContext();
  p._insertFakeElement(TAG_NAMES.COLGROUP, TAG_ID.COLGROUP);
  p.insertionMode = InsertionMode.IN_COLUMN_GROUP;
  startTagInColumnGroup(p, token);
}
function tbodyStartTagInTable(p, token) {
  p.openElements.clearBackToTableContext();
  p._insertElement(token, NS.HTML);
  p.insertionMode = InsertionMode.IN_TABLE_BODY;
}
function tdStartTagInTable(p, token) {
  p.openElements.clearBackToTableContext();
  p._insertFakeElement(TAG_NAMES.TBODY, TAG_ID.TBODY);
  p.insertionMode = InsertionMode.IN_TABLE_BODY;
  startTagInTableBody(p, token);
}
function tableStartTagInTable(p, token) {
  if (p.openElements.hasInTableScope(TAG_ID.TABLE)) {
    p.openElements.popUntilTagNamePopped(TAG_ID.TABLE);
    p._resetInsertionMode();
    p._processStartTag(token);
  }
}
function inputStartTagInTable(p, token) {
  if (isHiddenInput(token)) {
    p._appendElement(token, NS.HTML);
  } else {
    tokenInTable(p, token);
  }
  token.ackSelfClosing = true;
}
function formStartTagInTable(p, token) {
  if (!p.formElement && p.openElements.tmplCount === 0) {
    p._insertElement(token, NS.HTML);
    p.formElement = p.openElements.current;
    p.openElements.pop();
  }
}
function startTagInTable(p, token) {
  switch (token.tagID) {
    case TAG_ID.TD:
    case TAG_ID.TH:
    case TAG_ID.TR: {
      tdStartTagInTable(p, token);
      break;
    }
    case TAG_ID.STYLE:
    case TAG_ID.SCRIPT:
    case TAG_ID.TEMPLATE: {
      startTagInHead(p, token);
      break;
    }
    case TAG_ID.COL: {
      colStartTagInTable(p, token);
      break;
    }
    case TAG_ID.FORM: {
      formStartTagInTable(p, token);
      break;
    }
    case TAG_ID.TABLE: {
      tableStartTagInTable(p, token);
      break;
    }
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD: {
      tbodyStartTagInTable(p, token);
      break;
    }
    case TAG_ID.INPUT: {
      inputStartTagInTable(p, token);
      break;
    }
    case TAG_ID.CAPTION: {
      captionStartTagInTable(p, token);
      break;
    }
    case TAG_ID.COLGROUP: {
      colgroupStartTagInTable(p, token);
      break;
    }
    default: {
      tokenInTable(p, token);
    }
  }
}
function endTagInTable(p, token) {
  switch (token.tagID) {
    case TAG_ID.TABLE: {
      if (p.openElements.hasInTableScope(TAG_ID.TABLE)) {
        p.openElements.popUntilTagNamePopped(TAG_ID.TABLE);
        p._resetInsertionMode();
      }
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.HTML:
    case TAG_ID.TBODY:
    case TAG_ID.TD:
    case TAG_ID.TFOOT:
    case TAG_ID.TH:
    case TAG_ID.THEAD:
    case TAG_ID.TR: {
      break;
    }
    default: {
      tokenInTable(p, token);
    }
  }
}
function tokenInTable(p, token) {
  const savedFosterParentingState = p.fosterParentingEnabled;
  p.fosterParentingEnabled = true;
  modeInBody(p, token);
  p.fosterParentingEnabled = savedFosterParentingState;
}
function whitespaceCharacterInTableText(p, token) {
  p.pendingCharacterTokens.push(token);
}
function characterInTableText(p, token) {
  p.pendingCharacterTokens.push(token);
  p.hasNonWhitespacePendingCharacterToken = true;
}
function tokenInTableText(p, token) {
  let i = 0;
  if (p.hasNonWhitespacePendingCharacterToken) {
    for (; i < p.pendingCharacterTokens.length; i++) {
      tokenInTable(p, p.pendingCharacterTokens[i]);
    }
  } else {
    for (; i < p.pendingCharacterTokens.length; i++) {
      p._insertCharacters(p.pendingCharacterTokens[i]);
    }
  }
  p.insertionMode = p.originalInsertionMode;
  p._processToken(token);
}
var TABLE_VOID_ELEMENTS = /* @__PURE__ */ new Set([TAG_ID.CAPTION, TAG_ID.COL, TAG_ID.COLGROUP, TAG_ID.TBODY, TAG_ID.TD, TAG_ID.TFOOT, TAG_ID.TH, TAG_ID.THEAD, TAG_ID.TR]);
function startTagInCaption(p, token) {
  const tn2 = token.tagID;
  if (TABLE_VOID_ELEMENTS.has(tn2)) {
    if (p.openElements.hasInTableScope(TAG_ID.CAPTION)) {
      p.openElements.generateImpliedEndTags();
      p.openElements.popUntilTagNamePopped(TAG_ID.CAPTION);
      p.activeFormattingElements.clearToLastMarker();
      p.insertionMode = InsertionMode.IN_TABLE;
      startTagInTable(p, token);
    }
  } else {
    startTagInBody(p, token);
  }
}
function endTagInCaption(p, token) {
  const tn2 = token.tagID;
  switch (tn2) {
    case TAG_ID.CAPTION:
    case TAG_ID.TABLE: {
      if (p.openElements.hasInTableScope(TAG_ID.CAPTION)) {
        p.openElements.generateImpliedEndTags();
        p.openElements.popUntilTagNamePopped(TAG_ID.CAPTION);
        p.activeFormattingElements.clearToLastMarker();
        p.insertionMode = InsertionMode.IN_TABLE;
        if (tn2 === TAG_ID.TABLE) {
          endTagInTable(p, token);
        }
      }
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.HTML:
    case TAG_ID.TBODY:
    case TAG_ID.TD:
    case TAG_ID.TFOOT:
    case TAG_ID.TH:
    case TAG_ID.THEAD:
    case TAG_ID.TR: {
      break;
    }
    default: {
      endTagInBody(p, token);
    }
  }
}
function startTagInColumnGroup(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.COL: {
      p._appendElement(token, NS.HTML);
      token.ackSelfClosing = true;
      break;
    }
    case TAG_ID.TEMPLATE: {
      startTagInHead(p, token);
      break;
    }
    default: {
      tokenInColumnGroup(p, token);
    }
  }
}
function endTagInColumnGroup(p, token) {
  switch (token.tagID) {
    case TAG_ID.COLGROUP: {
      if (p.openElements.currentTagId === TAG_ID.COLGROUP) {
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE;
      }
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    case TAG_ID.COL: {
      break;
    }
    default: {
      tokenInColumnGroup(p, token);
    }
  }
}
function tokenInColumnGroup(p, token) {
  if (p.openElements.currentTagId === TAG_ID.COLGROUP) {
    p.openElements.pop();
    p.insertionMode = InsertionMode.IN_TABLE;
    p._processToken(token);
  }
}
function startTagInTableBody(p, token) {
  switch (token.tagID) {
    case TAG_ID.TR: {
      p.openElements.clearBackToTableBodyContext();
      p._insertElement(token, NS.HTML);
      p.insertionMode = InsertionMode.IN_ROW;
      break;
    }
    case TAG_ID.TH:
    case TAG_ID.TD: {
      p.openElements.clearBackToTableBodyContext();
      p._insertFakeElement(TAG_NAMES.TR, TAG_ID.TR);
      p.insertionMode = InsertionMode.IN_ROW;
      startTagInRow(p, token);
      break;
    }
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD: {
      if (p.openElements.hasTableBodyContextInTableScope()) {
        p.openElements.clearBackToTableBodyContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE;
        startTagInTable(p, token);
      }
      break;
    }
    default: {
      startTagInTable(p, token);
    }
  }
}
function endTagInTableBody(p, token) {
  const tn2 = token.tagID;
  switch (token.tagID) {
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD: {
      if (p.openElements.hasInTableScope(tn2)) {
        p.openElements.clearBackToTableBodyContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE;
      }
      break;
    }
    case TAG_ID.TABLE: {
      if (p.openElements.hasTableBodyContextInTableScope()) {
        p.openElements.clearBackToTableBodyContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE;
        endTagInTable(p, token);
      }
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.HTML:
    case TAG_ID.TD:
    case TAG_ID.TH:
    case TAG_ID.TR: {
      break;
    }
    default: {
      endTagInTable(p, token);
    }
  }
}
function startTagInRow(p, token) {
  switch (token.tagID) {
    case TAG_ID.TH:
    case TAG_ID.TD: {
      p.openElements.clearBackToTableRowContext();
      p._insertElement(token, NS.HTML);
      p.insertionMode = InsertionMode.IN_CELL;
      p.activeFormattingElements.insertMarker();
      break;
    }
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD:
    case TAG_ID.TR: {
      if (p.openElements.hasInTableScope(TAG_ID.TR)) {
        p.openElements.clearBackToTableRowContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE_BODY;
        startTagInTableBody(p, token);
      }
      break;
    }
    default: {
      startTagInTable(p, token);
    }
  }
}
function endTagInRow(p, token) {
  switch (token.tagID) {
    case TAG_ID.TR: {
      if (p.openElements.hasInTableScope(TAG_ID.TR)) {
        p.openElements.clearBackToTableRowContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE_BODY;
      }
      break;
    }
    case TAG_ID.TABLE: {
      if (p.openElements.hasInTableScope(TAG_ID.TR)) {
        p.openElements.clearBackToTableRowContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE_BODY;
        endTagInTableBody(p, token);
      }
      break;
    }
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD: {
      if (p.openElements.hasInTableScope(token.tagID) || p.openElements.hasInTableScope(TAG_ID.TR)) {
        p.openElements.clearBackToTableRowContext();
        p.openElements.pop();
        p.insertionMode = InsertionMode.IN_TABLE_BODY;
        endTagInTableBody(p, token);
      }
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.HTML:
    case TAG_ID.TD:
    case TAG_ID.TH: {
      break;
    }
    default: {
      endTagInTable(p, token);
    }
  }
}
function startTagInCell(p, token) {
  const tn2 = token.tagID;
  if (TABLE_VOID_ELEMENTS.has(tn2)) {
    if (p.openElements.hasInTableScope(TAG_ID.TD) || p.openElements.hasInTableScope(TAG_ID.TH)) {
      p._closeTableCell();
      startTagInRow(p, token);
    }
  } else {
    startTagInBody(p, token);
  }
}
function endTagInCell(p, token) {
  const tn2 = token.tagID;
  switch (tn2) {
    case TAG_ID.TD:
    case TAG_ID.TH: {
      if (p.openElements.hasInTableScope(tn2)) {
        p.openElements.generateImpliedEndTags();
        p.openElements.popUntilTagNamePopped(tn2);
        p.activeFormattingElements.clearToLastMarker();
        p.insertionMode = InsertionMode.IN_ROW;
      }
      break;
    }
    case TAG_ID.TABLE:
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD:
    case TAG_ID.TR: {
      if (p.openElements.hasInTableScope(tn2)) {
        p._closeTableCell();
        endTagInRow(p, token);
      }
      break;
    }
    case TAG_ID.BODY:
    case TAG_ID.CAPTION:
    case TAG_ID.COL:
    case TAG_ID.COLGROUP:
    case TAG_ID.HTML: {
      break;
    }
    default: {
      endTagInBody(p, token);
    }
  }
}
function startTagInSelect(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.OPTION: {
      if (p.openElements.currentTagId === TAG_ID.OPTION) {
        p.openElements.pop();
      }
      p._insertElement(token, NS.HTML);
      break;
    }
    case TAG_ID.OPTGROUP: {
      if (p.openElements.currentTagId === TAG_ID.OPTION) {
        p.openElements.pop();
      }
      if (p.openElements.currentTagId === TAG_ID.OPTGROUP) {
        p.openElements.pop();
      }
      p._insertElement(token, NS.HTML);
      break;
    }
    case TAG_ID.HR: {
      if (p.openElements.currentTagId === TAG_ID.OPTION) {
        p.openElements.pop();
      }
      if (p.openElements.currentTagId === TAG_ID.OPTGROUP) {
        p.openElements.pop();
      }
      p._appendElement(token, NS.HTML);
      token.ackSelfClosing = true;
      break;
    }
    case TAG_ID.INPUT:
    case TAG_ID.KEYGEN:
    case TAG_ID.TEXTAREA:
    case TAG_ID.SELECT: {
      if (p.openElements.hasInSelectScope(TAG_ID.SELECT)) {
        p.openElements.popUntilTagNamePopped(TAG_ID.SELECT);
        p._resetInsertionMode();
        if (token.tagID !== TAG_ID.SELECT) {
          p._processStartTag(token);
        }
      }
      break;
    }
    case TAG_ID.SCRIPT:
    case TAG_ID.TEMPLATE: {
      startTagInHead(p, token);
      break;
    }
    default:
  }
}
function endTagInSelect(p, token) {
  switch (token.tagID) {
    case TAG_ID.OPTGROUP: {
      if (p.openElements.stackTop > 0 && p.openElements.currentTagId === TAG_ID.OPTION && p.openElements.tagIDs[p.openElements.stackTop - 1] === TAG_ID.OPTGROUP) {
        p.openElements.pop();
      }
      if (p.openElements.currentTagId === TAG_ID.OPTGROUP) {
        p.openElements.pop();
      }
      break;
    }
    case TAG_ID.OPTION: {
      if (p.openElements.currentTagId === TAG_ID.OPTION) {
        p.openElements.pop();
      }
      break;
    }
    case TAG_ID.SELECT: {
      if (p.openElements.hasInSelectScope(TAG_ID.SELECT)) {
        p.openElements.popUntilTagNamePopped(TAG_ID.SELECT);
        p._resetInsertionMode();
      }
      break;
    }
    case TAG_ID.TEMPLATE: {
      templateEndTagInHead(p, token);
      break;
    }
    default:
  }
}
function startTagInSelectInTable(p, token) {
  const tn2 = token.tagID;
  if (tn2 === TAG_ID.CAPTION || tn2 === TAG_ID.TABLE || tn2 === TAG_ID.TBODY || tn2 === TAG_ID.TFOOT || tn2 === TAG_ID.THEAD || tn2 === TAG_ID.TR || tn2 === TAG_ID.TD || tn2 === TAG_ID.TH) {
    p.openElements.popUntilTagNamePopped(TAG_ID.SELECT);
    p._resetInsertionMode();
    p._processStartTag(token);
  } else {
    startTagInSelect(p, token);
  }
}
function endTagInSelectInTable(p, token) {
  const tn2 = token.tagID;
  if (tn2 === TAG_ID.CAPTION || tn2 === TAG_ID.TABLE || tn2 === TAG_ID.TBODY || tn2 === TAG_ID.TFOOT || tn2 === TAG_ID.THEAD || tn2 === TAG_ID.TR || tn2 === TAG_ID.TD || tn2 === TAG_ID.TH) {
    if (p.openElements.hasInTableScope(tn2)) {
      p.openElements.popUntilTagNamePopped(TAG_ID.SELECT);
      p._resetInsertionMode();
      p.onEndTag(token);
    }
  } else {
    endTagInSelect(p, token);
  }
}
function startTagInTemplate(p, token) {
  switch (token.tagID) {
    // First, handle tags that can start without a mode change
    case TAG_ID.BASE:
    case TAG_ID.BASEFONT:
    case TAG_ID.BGSOUND:
    case TAG_ID.LINK:
    case TAG_ID.META:
    case TAG_ID.NOFRAMES:
    case TAG_ID.SCRIPT:
    case TAG_ID.STYLE:
    case TAG_ID.TEMPLATE:
    case TAG_ID.TITLE: {
      startTagInHead(p, token);
      break;
    }
    // Re-process the token in the appropriate mode
    case TAG_ID.CAPTION:
    case TAG_ID.COLGROUP:
    case TAG_ID.TBODY:
    case TAG_ID.TFOOT:
    case TAG_ID.THEAD: {
      p.tmplInsertionModeStack[0] = InsertionMode.IN_TABLE;
      p.insertionMode = InsertionMode.IN_TABLE;
      startTagInTable(p, token);
      break;
    }
    case TAG_ID.COL: {
      p.tmplInsertionModeStack[0] = InsertionMode.IN_COLUMN_GROUP;
      p.insertionMode = InsertionMode.IN_COLUMN_GROUP;
      startTagInColumnGroup(p, token);
      break;
    }
    case TAG_ID.TR: {
      p.tmplInsertionModeStack[0] = InsertionMode.IN_TABLE_BODY;
      p.insertionMode = InsertionMode.IN_TABLE_BODY;
      startTagInTableBody(p, token);
      break;
    }
    case TAG_ID.TD:
    case TAG_ID.TH: {
      p.tmplInsertionModeStack[0] = InsertionMode.IN_ROW;
      p.insertionMode = InsertionMode.IN_ROW;
      startTagInRow(p, token);
      break;
    }
    default: {
      p.tmplInsertionModeStack[0] = InsertionMode.IN_BODY;
      p.insertionMode = InsertionMode.IN_BODY;
      startTagInBody(p, token);
    }
  }
}
function endTagInTemplate(p, token) {
  if (token.tagID === TAG_ID.TEMPLATE) {
    templateEndTagInHead(p, token);
  }
}
function eofInTemplate(p, token) {
  if (p.openElements.tmplCount > 0) {
    p.openElements.popUntilTagNamePopped(TAG_ID.TEMPLATE);
    p.activeFormattingElements.clearToLastMarker();
    p.tmplInsertionModeStack.shift();
    p._resetInsertionMode();
    p.onEof(token);
  } else {
    stopParsing(p, token);
  }
}
function startTagAfterBody(p, token) {
  if (token.tagID === TAG_ID.HTML) {
    startTagInBody(p, token);
  } else {
    tokenAfterBody(p, token);
  }
}
function endTagAfterBody(p, token) {
  var _a3;
  if (token.tagID === TAG_ID.HTML) {
    if (!p.fragmentContext) {
      p.insertionMode = InsertionMode.AFTER_AFTER_BODY;
    }
    if (p.options.sourceCodeLocationInfo && p.openElements.tagIDs[0] === TAG_ID.HTML) {
      p._setEndLocation(p.openElements.items[0], token);
      const bodyElement = p.openElements.items[1];
      if (bodyElement && !((_a3 = p.treeAdapter.getNodeSourceCodeLocation(bodyElement)) === null || _a3 === void 0 ? void 0 : _a3.endTag)) {
        p._setEndLocation(bodyElement, token);
      }
    }
  } else {
    tokenAfterBody(p, token);
  }
}
function tokenAfterBody(p, token) {
  p.insertionMode = InsertionMode.IN_BODY;
  modeInBody(p, token);
}
function startTagInFrameset(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.FRAMESET: {
      p._insertElement(token, NS.HTML);
      break;
    }
    case TAG_ID.FRAME: {
      p._appendElement(token, NS.HTML);
      token.ackSelfClosing = true;
      break;
    }
    case TAG_ID.NOFRAMES: {
      startTagInHead(p, token);
      break;
    }
    default:
  }
}
function endTagInFrameset(p, token) {
  if (token.tagID === TAG_ID.FRAMESET && !p.openElements.isRootHtmlElementCurrent()) {
    p.openElements.pop();
    if (!p.fragmentContext && p.openElements.currentTagId !== TAG_ID.FRAMESET) {
      p.insertionMode = InsertionMode.AFTER_FRAMESET;
    }
  }
}
function startTagAfterFrameset(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.NOFRAMES: {
      startTagInHead(p, token);
      break;
    }
    default:
  }
}
function endTagAfterFrameset(p, token) {
  if (token.tagID === TAG_ID.HTML) {
    p.insertionMode = InsertionMode.AFTER_AFTER_FRAMESET;
  }
}
function startTagAfterAfterBody(p, token) {
  if (token.tagID === TAG_ID.HTML) {
    startTagInBody(p, token);
  } else {
    tokenAfterAfterBody(p, token);
  }
}
function tokenAfterAfterBody(p, token) {
  p.insertionMode = InsertionMode.IN_BODY;
  modeInBody(p, token);
}
function startTagAfterAfterFrameset(p, token) {
  switch (token.tagID) {
    case TAG_ID.HTML: {
      startTagInBody(p, token);
      break;
    }
    case TAG_ID.NOFRAMES: {
      startTagInHead(p, token);
      break;
    }
    default:
  }
}
function nullCharacterInForeignContent(p, token) {
  token.chars = REPLACEMENT_CHARACTER;
  p._insertCharacters(token);
}
function characterInForeignContent(p, token) {
  p._insertCharacters(token);
  p.framesetOk = false;
}
function popUntilHtmlOrIntegrationPoint(p) {
  while (p.treeAdapter.getNamespaceURI(p.openElements.current) !== NS.HTML && p.openElements.currentTagId !== void 0 && !p._isIntegrationPoint(p.openElements.currentTagId, p.openElements.current)) {
    p.openElements.pop();
  }
}
function startTagInForeignContent(p, token) {
  if (causesExit(token)) {
    popUntilHtmlOrIntegrationPoint(p);
    p._startTagOutsideForeignContent(token);
  } else {
    const current = p._getAdjustedCurrentElement();
    const currentNs = p.treeAdapter.getNamespaceURI(current);
    if (currentNs === NS.MATHML) {
      adjustTokenMathMLAttrs(token);
    } else if (currentNs === NS.SVG) {
      adjustTokenSVGTagName(token);
      adjustTokenSVGAttrs(token);
    }
    adjustTokenXMLAttrs(token);
    if (token.selfClosing) {
      p._appendElement(token, currentNs);
    } else {
      p._insertElement(token, currentNs);
    }
    token.ackSelfClosing = true;
  }
}
function endTagInForeignContent(p, token) {
  if (token.tagID === TAG_ID.P || token.tagID === TAG_ID.BR) {
    popUntilHtmlOrIntegrationPoint(p);
    p._endTagOutsideForeignContent(token);
    return;
  }
  for (let i = p.openElements.stackTop; i > 0; i--) {
    const element = p.openElements.items[i];
    if (p.treeAdapter.getNamespaceURI(element) === NS.HTML) {
      p._endTagOutsideForeignContent(token);
      break;
    }
    const tagName = p.treeAdapter.getTagName(element);
    if (tagName.toLowerCase() === token.tagName) {
      token.tagName = tagName;
      p.openElements.shortenToLength(i);
      break;
    }
  }
}

// node_modules/entities/dist/esm/escape.js
var getCodePoint = (
  // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
  String.prototype.codePointAt == null ? (c, index2) => (c.charCodeAt(index2) & 64512) === 55296 ? (c.charCodeAt(index2) - 55296) * 1024 + c.charCodeAt(index2 + 1) - 56320 + 65536 : c.charCodeAt(index2) : (
    // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
    (input, index2) => input.codePointAt(index2)
  )
);

// node_modules/parse5/dist/serializer/index.js
var VOID_ELEMENTS = /* @__PURE__ */ new Set([
  TAG_NAMES.AREA,
  TAG_NAMES.BASE,
  TAG_NAMES.BASEFONT,
  TAG_NAMES.BGSOUND,
  TAG_NAMES.BR,
  TAG_NAMES.COL,
  TAG_NAMES.EMBED,
  TAG_NAMES.FRAME,
  TAG_NAMES.HR,
  TAG_NAMES.IMG,
  TAG_NAMES.INPUT,
  TAG_NAMES.KEYGEN,
  TAG_NAMES.LINK,
  TAG_NAMES.META,
  TAG_NAMES.PARAM,
  TAG_NAMES.SOURCE,
  TAG_NAMES.TRACK,
  TAG_NAMES.WBR
]);

// node_modules/parse5/dist/index.js
function parse(html, options) {
  return Parser.parse(html, options);
}

// node_modules/mhtml-to-html/lib/dom-parser-node.js
var { NS: NS2, TAG_NAMES: TAG_NAMES2, ATTRS: ATTRS2 } = html_exports;
var VOID_TAG_NAMES = /* @__PURE__ */ new Set([
  TAG_NAMES2.AREA,
  TAG_NAMES2.BASE,
  TAG_NAMES2.BASEFONT,
  TAG_NAMES2.BGSOUND,
  TAG_NAMES2.BR,
  TAG_NAMES2.COL,
  TAG_NAMES2.COMMAND,
  TAG_NAMES2.EMBED,
  TAG_NAMES2.FRAME,
  TAG_NAMES2.HR,
  TAG_NAMES2.IMG,
  TAG_NAMES2.INPUT,
  TAG_NAMES2.KEYGEN,
  TAG_NAMES2.LINK,
  TAG_NAMES2.META,
  TAG_NAMES2.PARAM,
  TAG_NAMES2.SOURCE,
  TAG_NAMES2.TRACK,
  TAG_NAMES2.WBR
]);
var RAW_TEXT_NODE_TAG_NAMES = /* @__PURE__ */ new Set([
  TAG_NAMES2.STYLE,
  TAG_NAMES2.SCRIPT,
  TAG_NAMES2.XMP,
  TAG_NAMES2.IFRAME,
  TAG_NAMES2.NOEMBED,
  TAG_NAMES2.NOFRAMES,
  TAG_NAMES2.PLAINTEXT,
  TAG_NAMES2.NOSCRIPT
]);
var JAVASCRIPT_MIME_TYPE = "text/javascript";
var DOCTYPE_PROPERTY_NAME = "doctype";
var DOCUMENT_ELEMENT_PROPERTY_NAME = "documentElement";
var HEAD_PROPERTY_NAME = "head";
var FIRST_CHILD_PROPERTY_NAME = "firstChild";
var TEXT_CONTENT_PROPERTY_NAME = "textContent";
var OUTER_HTML_PROPERTY_NAME = "outerHTML";
var TEXT_NODE_NAME = "#text";
var COMMENT_NODE_NAME = "#comment";
var DOCTYPE_NODE_NAME = "#documentType";
var AMPERSAND_ENTITY = "&amp;";
var QUOTE_ENTITY = "&quot;";
var NON_BREAKING_SPACE_ENTITY = "&nbsp;";
var LESS_THAN_ENTITY = "&lt;";
var GREATER_THAN_ENTITY = "&gt;";
var XLINK_PREFIX = "xlink";
var XMLNS_PREFIX = "xmlns";
var XML_PREFIX = "xml";
var AMPERSAND_REGEXP = /&/g;
var QUOTE_REGEXP = /"/g;
var NON_BREAKING_SPACE_REGEXP = /\u00a0/g;
var LESS_THAN_REGEXP = /</g;
var GREATER_THAN_REGEXP = />/g;
var INVALID_TAG_NAME_REGEXP = /["'>/=]/;
var OPENING_TAG_MARKER = "<";
var CLOSING_ANGLE_BRACKET = ">";
var CLOSING_TAG_MARKER = "</";
var CLOSING_TAG_MARKER_REGEXP = /<\//gi;
var ESCAPED_CLOSING_TAG_MARKER = "<\\/";
var SELF_CLOSING_TAG_MARKER_REGEXP = /\/>/gi;
var ESCAPED_SELF_CLOSING_TAG_MARKER = "\\/>";
var COMMENT_START_MARKER = "<!--";
var COMMENT_END_MARKER = "-->";
var ATTRIBUTE_PREFIX_SEPARATOR = ":";
var ATTRIBUTE_VALUE_SEPARATOR = "=";
var EMPTY_STRING = "";
var SPACE_CHARACTER = " ";
var QUOTE_CHARACTER = '"';
var treeAdapter = {
  ...defaultTreeAdapter,
  createDocument() {
    const document2 = defaultTreeAdapter.createDocument();
    document2.createElement = function(tagName) {
      return treeAdapter.createElement(tagName, void 0, []);
    };
    document2.createTextNode = function(data) {
      return treeAdapter.createTextNode(data);
    };
    document2.getElementsByTagName = getElementsByTagName;
    Object.defineProperty(document2, DOCTYPE_PROPERTY_NAME, {
      get() {
        const firstChild = treeAdapter.getFirstChild(this);
        if (firstChild && firstChild.nodeName === DOCTYPE_NODE_NAME) {
          return firstChild;
        } else {
          return void 0;
        }
      }
    });
    Object.defineProperty(document2, DOCUMENT_ELEMENT_PROPERTY_NAME, {
      get() {
        return this.childNodes.find((node) => testElement(node, TAG_NAMES2.HTML));
      }
    });
    Object.defineProperty(document2, HEAD_PROPERTY_NAME, {
      get() {
        return this.documentElement.childNodes.find((node) => testElement(node, TAG_NAMES2.HEAD));
      }
    });
    return document2;
  },
  createElement(tagName, namespaceURI, attrs) {
    const element = defaultTreeAdapter.createElement(tagName, namespaceURI, attrs);
    element.getAttribute = getAttribute;
    element.setAttribute = setAttribute;
    element.removeAttribute = removeAttribute;
    element.appendChild = appendChild;
    element.remove = remove;
    element.replaceWith = replaceWith;
    element.prepend = prepend;
    element.after = after;
    element.getElementsByTagName = getElementsByTagName;
    Object.defineProperty(element, FIRST_CHILD_PROPERTY_NAME, {
      get() {
        return treeAdapter.getFirstChild(this);
      }
    });
    Object.defineProperty(element, TEXT_CONTENT_PROPERTY_NAME, {
      get() {
        return joinArray(this.childNodes.map((node) => treeAdapter.getTextNodeContent(node)));
      }
    });
    Object.defineProperty(element, OUTER_HTML_PROPERTY_NAME, {
      get() {
        return serialize2(this);
      }
    });
    return element;
  }
};
var DOMParser = class {
  parseFromString(html) {
    const document2 = parse(html, { treeAdapter });
    if (!document2.head) {
      const headElement = document2.createElement(TAG_NAMES2.HEAD);
      document2.documentElement.prepend(headElement);
    }
    return document2;
  }
};
function getAttribute(name) {
  const attribute = findAttribute(this, name);
  if (attribute) {
    return attribute.value;
  }
}
function setAttribute(name, value) {
  const indexAttribute = findIndexAttribute(this, name);
  if (indexAttribute === -1) {
    this.attrs.push({ name, value });
  } else {
    this.attrs[indexAttribute].value = value;
  }
}
function removeAttribute(name) {
  const indexAttribute = findIndexAttribute(this, name);
  if (indexAttribute !== -1) {
    this.attrs.splice(indexAttribute, 1);
  }
}
function findAttribute(element, name) {
  return element.attrs.find((attr) => testAttributeName(attr, name));
}
function findIndexAttribute(element, name) {
  return element.attrs.findIndex((attr) => testAttributeName(attr, name));
}
function testAttributeName(attr, name) {
  return testCaseInsensitive(attr.name, name);
}
function appendChild(child) {
  return treeAdapter.appendChild(this, child);
}
function remove() {
  if (this.parentNode) {
    const indexNode = findIndexNode(this);
    if (indexNode !== -1) {
      this.parentNode.childNodes.splice(indexNode, 1);
      this.parentNode = void 0;
    }
  }
}
function replaceWith(...nodes) {
  if (this.parentNode) {
    const indexNode = findIndexNode(this);
    if (indexNode !== -1) {
      const oldNodes = this.parentNode.childNodes.splice(indexNode, 1, ...nodes);
      nodes.forEach((node) => node.parentNode = this.parentNode);
      oldNodes.forEach((node) => node.parentNode = void 0);
    }
  }
}
function prepend(...nodes) {
  this.childNodes.unshift(...nodes);
  nodes.forEach((node) => node.parentNode = this);
}
function after(...nodes) {
  if (this.parentNode) {
    const indexNode = findIndexNode(this);
    if (indexNode !== -1) {
      this.parentNode.childNodes.splice(indexNode + 1, 0, ...nodes);
      nodes.forEach((node) => node.parentNode = this.parentNode);
    }
  }
}
function getElementsByTagName(tagName) {
  const elements = [];
  this.childNodes.forEach((node) => {
    if (testElement(node, tagName)) {
      elements.push(node);
    }
    if (node.getElementsByTagName) {
      elements.push(...node.getElementsByTagName(tagName));
    }
  });
  return elements;
}
function findIndexNode(node) {
  return node.parentNode.childNodes.indexOf(node);
}
function testElement(node, name) {
  return node.tagName && testCaseInsensitive(node.tagName, name);
}
function testCaseInsensitive(stringLeft, stringRight) {
  return stringLeft.toLowerCase() === stringRight.toLowerCase();
}
function serialize2(node) {
  if (node.nodeName === TEXT_NODE_NAME) {
    return serializeTextNode(node);
  } else if (node.nodeName === COMMENT_NODE_NAME) {
    return serializeCommentNode(node);
  } else {
    return serializeElement(node);
  }
}
function serializeTextNode(textNode) {
  if (shouldEscapeEntities(textNode)) {
    return escapeEntitiesTextNode(textNode);
  } else if (shouldEscapeTextNode(textNode)) {
    return escapeTextNode(textNode);
  } else {
    return textNode.value;
  }
}
function shouldEscapeEntities(textNode) {
  const parentNodeTagName = textNode.parentNode.tagName && textNode.parentNode.tagName.toLowerCase();
  return parentNodeTagName && !RAW_TEXT_NODE_TAG_NAMES.has(parentNodeTagName);
}
function shouldEscapeTextNode(textNode) {
  const parentNode = textNode.parentNode;
  const parentNodeTagName = textNode.parentNode.tagName && parentNode.tagName.toLowerCase();
  let parentNodeType;
  if (parentNode.attrs) {
    parentNodeType = parentNode.getAttribute(ATTRS2.TYPE);
  }
  return parentNodeTagName === TAG_NAMES2.STYLE || parentNodeTagName === TAG_NAMES2.SCRIPT && (!parentNodeType || parentNodeType === JAVASCRIPT_MIME_TYPE);
}
function escapeTextNode(textNode) {
  return textNode.value.replace(CLOSING_TAG_MARKER_REGEXP, ESCAPED_CLOSING_TAG_MARKER).replace(SELF_CLOSING_TAG_MARKER_REGEXP, ESCAPED_SELF_CLOSING_TAG_MARKER);
}
function escapeEntitiesTextNode(textNode) {
  return textNode.value.replace(AMPERSAND_REGEXP, AMPERSAND_ENTITY).replace(NON_BREAKING_SPACE_REGEXP, NON_BREAKING_SPACE_ENTITY).replace(LESS_THAN_REGEXP, LESS_THAN_ENTITY).replace(GREATER_THAN_REGEXP, GREATER_THAN_ENTITY);
}
function serializeCommentNode(commentNode) {
  return COMMENT_START_MARKER + commentNode.data + COMMENT_END_MARKER;
}
function serializeElement(element) {
  let { tagName } = element;
  tagName = tagName.toLowerCase();
  let html = OPENING_TAG_MARKER + tagName;
  const attributes = serializeAttributes(element);
  if (attributes) {
    html += SPACE_CHARACTER + attributes;
  }
  html += CLOSING_ANGLE_BRACKET;
  html += serializeChildren(element);
  if (!VOID_TAG_NAMES.has(tagName)) {
    html += CLOSING_TAG_MARKER + tagName + CLOSING_ANGLE_BRACKET;
  }
  return html;
}
function serializeChildren(element) {
  if (element.tagName.toLowerCase() === TAG_NAMES2.TEMPLATE) {
    return joinArray(element.content.childNodes.map((node) => serialize2(node)));
  } else {
    return joinArray(element.childNodes.map((node) => serialize2(node)));
  }
}
function serializeAttributes(element) {
  return joinArray(element.attrs.map(({ name, value, prefix, namespace }) => {
    if (!name.match(INVALID_TAG_NAME_REGEXP)) {
      value = escapeAttributeValue(value);
      if (namespace === NS2.XLINK) {
        return serializeAttribute(name, value, XLINK_PREFIX);
      } else if (namespace === NS2.XML) {
        return serializeAttribute(name, value, XML_PREFIX);
      } else if (namespace === NS2.XMLNS) {
        return name === XMLNS_PREFIX ? serializeAttribute(name, value) : serializeAttribute(name, value, XMLNS_PREFIX);
      } else {
        return serializeAttribute(name, value, prefix);
      }
    }
  }), SPACE_CHARACTER);
}
function escapeAttributeValue(value) {
  return value.replace(AMPERSAND_REGEXP, AMPERSAND_ENTITY).replace(NON_BREAKING_SPACE_REGEXP, NON_BREAKING_SPACE_ENTITY).replace(QUOTE_REGEXP, QUOTE_ENTITY);
}
function serializeAttribute(name, value, prefix) {
  if (prefix) {
    return prefix + ATTRIBUTE_PREFIX_SEPARATOR + name + ATTRIBUTE_VALUE_SEPARATOR + QUOTE_CHARACTER + value + QUOTE_CHARACTER;
  } else {
    return name + ATTRIBUTE_VALUE_SEPARATOR + QUOTE_CHARACTER + value + QUOTE_CHARACTER;
  }
}
function joinArray(array, separator = EMPTY_STRING) {
  return array.join(separator);
}

// node_modules/mhtml-to-html/lib/util.js
var EVENT_HANDLER_ATTRIBUTES = [
  "onafterprint",
  "onbeforeprint",
  "onbeforeunload",
  "onhashchange",
  "onlanguagechange",
  "onmessage",
  "onmessageerror",
  "onoffline",
  "ononline",
  "onpagehide",
  "onpageshow",
  "onpopstate",
  "onrejectionhandled",
  "onstorage",
  "onunhandledrejection",
  "onunload",
  "ongamepadconnected",
  "ongamepaddisconnected",
  "onabort",
  "onblur",
  "onfocus",
  "oncancel",
  "onauxclick",
  "onbeforeinput",
  "onbeforetoggle",
  "oncanplay",
  "oncanplaythrough",
  "onchange",
  "onclick",
  "onclose",
  "oncontentvisibilityautostatechange",
  "oncontextlost",
  "oncontextmenu",
  "oncontextrestored",
  "oncopy",
  "oncuechange",
  "oncut",
  "ondblclick",
  "ondrag",
  "ondragend",
  "ondragenter",
  "ondragleave",
  "ondragover",
  "ondragstart",
  "ondrop",
  "ondurationchange",
  "onemptied",
  "onended",
  "onformdata",
  "oninput",
  "oninvalid",
  "onkeydown",
  "onkeypress",
  "onkeyup",
  "onload",
  "onloadeddata",
  "onloadedmetadata",
  "onloadstart",
  "onmousedown",
  "onmouseenter",
  "onmouseleave",
  "onmousemove",
  "onmouseout",
  "onmouseover",
  "onmouseup",
  "onwheel",
  "onpaste",
  "onpause",
  "onplay",
  "onplaying",
  "onprogress",
  "onratechange",
  "onreset",
  "onresize",
  "onscroll",
  "onscrollend",
  "onsecuritypolicyviolation",
  "onseeked",
  "onseeking",
  "onselect",
  "onslotchange",
  "onstalled",
  "onsubmit",
  "onsuspend",
  "ontimeupdate",
  "onvolumechange",
  "onwaiting",
  "onselectstart",
  "onselectionchange",
  "ontoggle",
  "onpointercancel",
  "onpointerdown",
  "onpointerup",
  "onpointermove",
  "onpointerout",
  "onpointerover",
  "onpointerenter",
  "onpointerleave",
  "ongotpointercapture",
  "onlostpointercapture",
  "onanimationcancel",
  "onanimationend",
  "onanimationiteration",
  "onanimationstart",
  "ontransitioncancel",
  "ontransitionend",
  "ontransitionrun",
  "ontransitionstart",
  "onerror",
  "onfullscreenchange",
  "onfullscreenerror"
];
function decodeQuotedPrintable(array) {
  const result = [];
  for (let i = 0; i < array.length; i++) {
    if (array[i] === 61) {
      if (isHex(array[i + 1]) && isHex(array[i + 2])) {
        const hex = parseInt(String.fromCharCode(array[i + 1], array[i + 2]), 16);
        result.push(hex);
        i += 2;
      } else {
        result.push(array[i]);
      }
    } else {
      result.push(array[i]);
    }
  }
  return new Uint8Array(result);
  function isHex(value) {
    return value >= 48 && value <= 57 || value >= 65 && value <= 70;
  }
}
function decodeBinary(array) {
  let data = "";
  for (let indexData = 0; indexData < array.length; indexData++) {
    data += String.fromCharCode(array[indexData]);
  }
  return btoa(data);
}
function decodeBase64(value, charset) {
  const decodedData = new Uint8Array(atob(value).split("").map((char) => char.charCodeAt(0)));
  return new TextDecoder(charset).decode(decodedData);
}
function decodeMimeHeader(encodedSubject) {
  if (encodedSubject && encodedSubject.startsWith("=?") && encodedSubject.endsWith("?=")) {
    const encodedSubjectParts = [];
    let index2 = 0;
    while (index2 < encodedSubject.length) {
      const start = encodedSubject.indexOf("=?", index2);
      if (start === -1) {
        break;
      }
      const endCharset = encodedSubject.indexOf("?", start + 2);
      if (endCharset === -1) {
        break;
      }
      const charset = encodedSubject.substring(start + 2, endCharset);
      const endEncoding = encodedSubject.indexOf("?", endCharset + 1);
      if (endEncoding === -1) {
        break;
      }
      const encoding = encodedSubject.substring(endCharset + 1, endEncoding);
      const endValue = encodedSubject.indexOf("?=", endEncoding + 1);
      if (endValue === -1) {
        break;
      }
      const value = encodedSubject.substring(endEncoding + 1, endValue);
      index2 = endValue + 2;
      if (encoding === "Q") {
        encodedSubjectParts.push(new TextDecoder(charset).decode(decodeQuotedPrintable(new TextEncoder().encode(value))));
      } else if (encoding === "B") {
        encodedSubjectParts.push(decodeBase64(value, charset));
      }
    }
    encodedSubject = encodedSubjectParts.join("");
  }
  return encodedSubject || "";
}
function parseDOM(asset, contentType = "text/html", DOMParser2 = globalThis.DOMParser) {
  let document2;
  try {
    document2 = new DOMParser2().parseFromString(asset, contentType);
  } catch (_2) {
    document2 = new DOMParser2().parseFromString(asset, "text/html");
  }
  return {
    document: document2,
    serialize() {
      let result = "";
      if (this.document.doctype) {
        result += serializeDocType(this.document.doctype) + "\n";
      }
      result += this.document.documentElement.outerHTML;
      return result;
    }
  };
}
function serializeDocType(doctype) {
  return `<!DOCTYPE ${doctype.name}${doctype.publicId ? ` PUBLIC "${doctype.publicId}"` : ""}${doctype.systemId ? ` "${doctype.systemId}"` : ""}>`;
}
function decodeString(array, charset) {
  return new TextDecoder(charset).decode(array);
}
function encodeString(string, charset) {
  return new TextEncoder(charset).encode(string);
}
function getCharset(contentType) {
  const charsetMatch = contentType.match(/charset=([^;]+)/);
  if (charsetMatch) {
    return removeQuotes(charsetMatch[1]).toLowerCase();
  }
}
function removeQuotes(value) {
  return value.replace(/^"(.*)"$/, "$1").replace(/^'(.*)'$/, "$1").trim();
}
function replaceCharset(contentType, charset) {
  return contentType.replace(/charset=([^;]+)/, `charset=${charset}`);
}
function isDocument(contentType) {
  return contentType.startsWith("text/html") || contentType.startsWith("application/xhtml+xml");
}
function isStylesheet(contentType) {
  return contentType.startsWith("text/css");
}
function isText(contentType) {
  return contentType.startsWith("text/");
}
function isMultipartAlternative(contentType) {
  return contentType.startsWith("multipart/alternative");
}
function getBoundary(contentType) {
  const contentTypeParams = contentType.split(";");
  contentTypeParams.shift();
  const boundaryParam = contentTypeParams.find((param) => param.startsWith("boundary="));
  if (boundaryParam) {
    return removeQuotes(boundaryParam.substring(9));
  }
}
function indexOf(array, string) {
  const stringBytes = new TextEncoder().encode(string);
  for (let i = 0; i < array.length; i++) {
    if (array[i] === stringBytes[0]) {
      let match = true;
      for (let j = 1; j < stringBytes.length; j++) {
        if (array[i + j] !== stringBytes[j]) {
          match = false;
          break;
        }
      }
      if (match) {
        return i;
      }
    }
  }
  return -1;
}
function isLineFeed(array) {
  return array.length == 2 ? array[0] == 13 && array[1] == 10 : array.length == 1 ? array[0] == 10 : false;
}
function endsWithCRLF(array) {
  return array.length >= 2 ? array[array.length - 2] == 13 && array[array.length - 1] == 10 : array.length >= 1 ? array[array.length - 1] == 13 : false;
}
function endsWithLF(array) {
  return array.length >= 1 ? array[array.length - 1] == 10 : false;
}
function startsWithBoundary(array) {
  return array.length >= 2 ? array[0] == 45 && array[1] == 45 : false;
}
function getResourceURI({ contentType, transferEncoding, data }) {
  return `data:${contentType};${"base64"},${transferEncoding === "base64" ? data : btoa(unescape(encodeURIComponent(data)))}`;
}
function resolvePath(path, base) {
  if (base && !path.startsWith("data:")) {
    try {
      return new URL(path, base).href;
    } catch (_2) {
      if (path.startsWith("//")) {
        const protocol = base.match(/^[^:]+/);
        if (protocol) {
          return `${protocol[0]}:${path}`;
        } else {
          return path;
        }
      } else {
        return path;
      }
    }
  } else {
    return path;
  }
}

// node_modules/mhtml-to-html/lib/vendor/csstree.esm.js
var Ra = Object.create;
var or = Object.defineProperty;
var Fa = Object.getOwnPropertyDescriptor;
var Ma = Object.getOwnPropertyNames;
var Ba = Object.getPrototypeOf;
var _a2 = Object.prototype.hasOwnProperty;
var Me = (e2, t2) => () => (t2 || e2((t2 = { exports: {} }).exports, t2), t2.exports);
var f = (e2, t2) => {
  for (var r in t2) or(e2, r, { get: t2[r], enumerable: true });
};
var Wa = (e2, t2, r, n) => {
  if (t2 && typeof t2 == "object" || typeof t2 == "function") for (let i of Ma(t2)) !_a2.call(e2, i) && i !== r && or(e2, i, { get: () => t2[i], enumerable: !(n = Fa(t2, i)) || n.enumerable });
  return e2;
};
var qa = (e2, t2, r) => (r = e2 != null ? Ra(Ba(e2)) : {}, Wa(t2 || !e2 || !e2.__esModule ? or(r, "default", { value: e2, enumerable: true }) : r, e2));
var So = Me((fr) => {
  var vo = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
  fr.encode = function(e2) {
    if (0 <= e2 && e2 < vo.length) return vo[e2];
    throw new TypeError("Must be between 0 and 63: " + e2);
  };
  fr.decode = function(e2) {
    var t2 = 65, r = 90, n = 97, i = 122, o = 48, s = 57, u = 43, c = 47, a = 26, l = 52;
    return t2 <= e2 && e2 <= r ? e2 - t2 : n <= e2 && e2 <= i ? e2 - n + a : o <= e2 && e2 <= s ? e2 - o + l : e2 == u ? 62 : e2 == c ? 63 : -1;
  };
});
var Eo = Me((br) => {
  var Co = So(), gr = 5, To = 1 << gr, Ao = To - 1, Lo = To;
  function Za(e2) {
    return e2 < 0 ? (-e2 << 1) + 1 : (e2 << 1) + 0;
  }
  function Ja(e2) {
    var t2 = (e2 & 1) === 1, r = e2 >> 1;
    return t2 ? -r : r;
  }
  br.encode = function(t2) {
    var r = "", n, i = Za(t2);
    do
      n = i & Ao, i >>>= gr, i > 0 && (n |= Lo), r += Co.encode(n);
    while (i > 0);
    return r;
  };
  br.decode = function(t2, r, n) {
    var i = t2.length, o = 0, s = 0, u, c;
    do {
      if (r >= i) throw new Error("Expected more digits in base 64 VLQ value.");
      if (c = Co.decode(t2.charCodeAt(r++)), c === -1) throw new Error("Invalid base64 digit: " + t2.charAt(r - 1));
      u = !!(c & Lo), c &= Ao, o = o + (c << s), s += gr;
    } while (u);
    n.value = Ja(o), n.rest = r;
  };
});
var Rt = Me((W) => {
  function el(e2, t2, r) {
    if (t2 in e2) return e2[t2];
    if (arguments.length === 3) return r;
    throw new Error('"' + t2 + '" is a required argument.');
  }
  W.getArg = el;
  var zo = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/, tl = /^data:.+\,.+$/;
  function lt(e2) {
    var t2 = e2.match(zo);
    return t2 ? { scheme: t2[1], auth: t2[2], host: t2[3], port: t2[4], path: t2[5] } : null;
  }
  W.urlParse = lt;
  function Ge(e2) {
    var t2 = "";
    return e2.scheme && (t2 += e2.scheme + ":"), t2 += "//", e2.auth && (t2 += e2.auth + "@"), e2.host && (t2 += e2.host), e2.port && (t2 += ":" + e2.port), e2.path && (t2 += e2.path), t2;
  }
  W.urlGenerate = Ge;
  var rl = 32;
  function nl(e2) {
    var t2 = [];
    return function(r) {
      for (var n = 0; n < t2.length; n++) if (t2[n].input === r) {
        var i = t2[0];
        return t2[0] = t2[n], t2[n] = i, t2[0].result;
      }
      var o = e2(r);
      return t2.unshift({ input: r, result: o }), t2.length > rl && t2.pop(), o;
    };
  }
  var xr = nl(function(t2) {
    var r = t2, n = lt(t2);
    if (n) {
      if (!n.path) return t2;
      r = n.path;
    }
    for (var i = W.isAbsolute(r), o = [], s = 0, u = 0; ; ) if (s = u, u = r.indexOf("/", s), u === -1) {
      o.push(r.slice(s));
      break;
    } else for (o.push(r.slice(s, u)); u < r.length && r[u] === "/"; ) u++;
    for (var c, a = 0, u = o.length - 1; u >= 0; u--) c = o[u], c === "." ? o.splice(u, 1) : c === ".." ? a++ : a > 0 && (c === "" ? (o.splice(u + 1, a), a = 0) : (o.splice(u, 2), a--));
    return r = o.join("/"), r === "" && (r = i ? "/" : "."), n ? (n.path = r, Ge(n)) : r;
  });
  W.normalize = xr;
  function Po(e2, t2) {
    e2 === "" && (e2 = "."), t2 === "" && (t2 = ".");
    var r = lt(t2), n = lt(e2);
    if (n && (e2 = n.path || "/"), r && !r.scheme) return n && (r.scheme = n.scheme), Ge(r);
    if (r || t2.match(tl)) return t2;
    if (n && !n.host && !n.path) return n.host = t2, Ge(n);
    var i = t2.charAt(0) === "/" ? t2 : xr(e2.replace(/\/+$/, "") + "/" + t2);
    return n ? (n.path = i, Ge(n)) : i;
  }
  W.join = Po;
  W.isAbsolute = function(e2) {
    return e2.charAt(0) === "/" || zo.test(e2);
  };
  function il(e2, t2) {
    e2 === "" && (e2 = "."), e2 = e2.replace(/\/$/, "");
    for (var r = 0; t2.indexOf(e2 + "/") !== 0; ) {
      var n = e2.lastIndexOf("/");
      if (n < 0 || (e2 = e2.slice(0, n), e2.match(/^([^\/]+:\/)?\/*$/))) return t2;
      ++r;
    }
    return Array(r + 1).join("../") + t2.substr(e2.length + 1);
  }
  W.relative = il;
  var Io = (function() {
    var e2 = /* @__PURE__ */ Object.create(null);
    return !("__proto__" in e2);
  })();
  function Do(e2) {
    return e2;
  }
  function ol(e2) {
    return No(e2) ? "$" + e2 : e2;
  }
  W.toSetString = Io ? Do : ol;
  function sl(e2) {
    return No(e2) ? e2.slice(1) : e2;
  }
  W.fromSetString = Io ? Do : sl;
  function No(e2) {
    if (!e2) return false;
    var t2 = e2.length;
    if (t2 < 9 || e2.charCodeAt(t2 - 1) !== 95 || e2.charCodeAt(t2 - 2) !== 95 || e2.charCodeAt(t2 - 3) !== 111 || e2.charCodeAt(t2 - 4) !== 116 || e2.charCodeAt(t2 - 5) !== 111 || e2.charCodeAt(t2 - 6) !== 114 || e2.charCodeAt(t2 - 7) !== 112 || e2.charCodeAt(t2 - 8) !== 95 || e2.charCodeAt(t2 - 9) !== 95) return false;
    for (var r = t2 - 10; r >= 0; r--) if (e2.charCodeAt(r) !== 36) return false;
    return true;
  }
  function al(e2, t2, r) {
    var n = ke(e2.source, t2.source);
    return n !== 0 || (n = e2.originalLine - t2.originalLine, n !== 0) || (n = e2.originalColumn - t2.originalColumn, n !== 0 || r) || (n = e2.generatedColumn - t2.generatedColumn, n !== 0) || (n = e2.generatedLine - t2.generatedLine, n !== 0) ? n : ke(e2.name, t2.name);
  }
  W.compareByOriginalPositions = al;
  function ll(e2, t2, r) {
    var n;
    return n = e2.originalLine - t2.originalLine, n !== 0 || (n = e2.originalColumn - t2.originalColumn, n !== 0 || r) || (n = e2.generatedColumn - t2.generatedColumn, n !== 0) || (n = e2.generatedLine - t2.generatedLine, n !== 0) ? n : ke(e2.name, t2.name);
  }
  W.compareByOriginalPositionsNoSource = ll;
  function cl(e2, t2, r) {
    var n = e2.generatedLine - t2.generatedLine;
    return n !== 0 || (n = e2.generatedColumn - t2.generatedColumn, n !== 0 || r) || (n = ke(e2.source, t2.source), n !== 0) || (n = e2.originalLine - t2.originalLine, n !== 0) || (n = e2.originalColumn - t2.originalColumn, n !== 0) ? n : ke(e2.name, t2.name);
  }
  W.compareByGeneratedPositionsDeflated = cl;
  function ul(e2, t2, r) {
    var n = e2.generatedColumn - t2.generatedColumn;
    return n !== 0 || r || (n = ke(e2.source, t2.source), n !== 0) || (n = e2.originalLine - t2.originalLine, n !== 0) || (n = e2.originalColumn - t2.originalColumn, n !== 0) ? n : ke(e2.name, t2.name);
  }
  W.compareByGeneratedPositionsDeflatedNoLine = ul;
  function ke(e2, t2) {
    return e2 === t2 ? 0 : e2 === null ? 1 : t2 === null ? -1 : e2 > t2 ? 1 : -1;
  }
  function pl(e2, t2) {
    var r = e2.generatedLine - t2.generatedLine;
    return r !== 0 || (r = e2.generatedColumn - t2.generatedColumn, r !== 0) || (r = ke(e2.source, t2.source), r !== 0) || (r = e2.originalLine - t2.originalLine, r !== 0) || (r = e2.originalColumn - t2.originalColumn, r !== 0) ? r : ke(e2.name, t2.name);
  }
  W.compareByGeneratedPositionsInflated = pl;
  function hl(e2) {
    return JSON.parse(e2.replace(/^\)]}'[^\n]*\n/, ""));
  }
  W.parseSourceMapInput = hl;
  function ml(e2, t2, r) {
    if (t2 = t2 || "", e2 && (e2[e2.length - 1] !== "/" && t2[0] !== "/" && (e2 += "/"), t2 = e2 + t2), r) {
      var n = lt(r);
      if (!n) throw new Error("sourceMapURL could not be parsed");
      if (n.path) {
        var i = n.path.lastIndexOf("/");
        i >= 0 && (n.path = n.path.substring(0, i + 1));
      }
      t2 = Po(Ge(n), t2);
    }
    return xr(t2);
  }
  W.computeSourceURL = ml;
});
var Ro = Me((Oo) => {
  var yr = Rt(), kr = Object.prototype.hasOwnProperty, Ne = typeof Map < "u";
  function we() {
    this._array = [], this._set = Ne ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
  }
  we.fromArray = function(t2, r) {
    for (var n = new we(), i = 0, o = t2.length; i < o; i++) n.add(t2[i], r);
    return n;
  };
  we.prototype.size = function() {
    return Ne ? this._set.size : Object.getOwnPropertyNames(this._set).length;
  };
  we.prototype.add = function(t2, r) {
    var n = Ne ? t2 : yr.toSetString(t2), i = Ne ? this.has(t2) : kr.call(this._set, n), o = this._array.length;
    (!i || r) && this._array.push(t2), i || (Ne ? this._set.set(t2, o) : this._set[n] = o);
  };
  we.prototype.has = function(t2) {
    if (Ne) return this._set.has(t2);
    var r = yr.toSetString(t2);
    return kr.call(this._set, r);
  };
  we.prototype.indexOf = function(t2) {
    if (Ne) {
      var r = this._set.get(t2);
      if (r >= 0) return r;
    } else {
      var n = yr.toSetString(t2);
      if (kr.call(this._set, n)) return this._set[n];
    }
    throw new Error('"' + t2 + '" is not in the set.');
  };
  we.prototype.at = function(t2) {
    if (t2 >= 0 && t2 < this._array.length) return this._array[t2];
    throw new Error("No element indexed by " + t2);
  };
  we.prototype.toArray = function() {
    return this._array.slice();
  };
  Oo.ArraySet = we;
});
var Bo = Me((Mo) => {
  var Fo = Rt();
  function dl(e2, t2) {
    var r = e2.generatedLine, n = t2.generatedLine, i = e2.generatedColumn, o = t2.generatedColumn;
    return n > r || n == r && o >= i || Fo.compareByGeneratedPositionsInflated(e2, t2) <= 0;
  }
  function Ft() {
    this._array = [], this._sorted = true, this._last = { generatedLine: -1, generatedColumn: 0 };
  }
  Ft.prototype.unsortedForEach = function(t2, r) {
    this._array.forEach(t2, r);
  };
  Ft.prototype.add = function(t2) {
    dl(this._last, t2) ? (this._last = t2, this._array.push(t2)) : (this._sorted = false, this._array.push(t2));
  };
  Ft.prototype.toArray = function() {
    return this._sorted || (this._array.sort(Fo.compareByGeneratedPositionsInflated), this._sorted = true), this._array;
  };
  Mo.MappingList = Ft;
});
var Wo = Me((_o) => {
  var ct = Eo(), F = Rt(), Mt = Ro().ArraySet, fl = Bo().MappingList;
  function ne(e2) {
    e2 || (e2 = {}), this._file = F.getArg(e2, "file", null), this._sourceRoot = F.getArg(e2, "sourceRoot", null), this._skipValidation = F.getArg(e2, "skipValidation", false), this._sources = new Mt(), this._names = new Mt(), this._mappings = new fl(), this._sourcesContents = null;
  }
  ne.prototype._version = 3;
  ne.fromSourceMap = function(t2) {
    var r = t2.sourceRoot, n = new ne({ file: t2.file, sourceRoot: r });
    return t2.eachMapping(function(i) {
      var o = { generated: { line: i.generatedLine, column: i.generatedColumn } };
      i.source != null && (o.source = i.source, r != null && (o.source = F.relative(r, o.source)), o.original = { line: i.originalLine, column: i.originalColumn }, i.name != null && (o.name = i.name)), n.addMapping(o);
    }), t2.sources.forEach(function(i) {
      var o = i;
      r !== null && (o = F.relative(r, i)), n._sources.has(o) || n._sources.add(o);
      var s = t2.sourceContentFor(i);
      s != null && n.setSourceContent(i, s);
    }), n;
  };
  ne.prototype.addMapping = function(t2) {
    var r = F.getArg(t2, "generated"), n = F.getArg(t2, "original", null), i = F.getArg(t2, "source", null), o = F.getArg(t2, "name", null);
    this._skipValidation || this._validateMapping(r, n, i, o), i != null && (i = String(i), this._sources.has(i) || this._sources.add(i)), o != null && (o = String(o), this._names.has(o) || this._names.add(o)), this._mappings.add({ generatedLine: r.line, generatedColumn: r.column, originalLine: n != null && n.line, originalColumn: n != null && n.column, source: i, name: o });
  };
  ne.prototype.setSourceContent = function(t2, r) {
    var n = t2;
    this._sourceRoot != null && (n = F.relative(this._sourceRoot, n)), r != null ? (this._sourcesContents || (this._sourcesContents = /* @__PURE__ */ Object.create(null)), this._sourcesContents[F.toSetString(n)] = r) : this._sourcesContents && (delete this._sourcesContents[F.toSetString(n)], Object.keys(this._sourcesContents).length === 0 && (this._sourcesContents = null));
  };
  ne.prototype.applySourceMap = function(t2, r, n) {
    var i = r;
    if (r == null) {
      if (t2.file == null) throw new Error(`SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`);
      i = t2.file;
    }
    var o = this._sourceRoot;
    o != null && (i = F.relative(o, i));
    var s = new Mt(), u = new Mt();
    this._mappings.unsortedForEach(function(c) {
      if (c.source === i && c.originalLine != null) {
        var a = t2.originalPositionFor({ line: c.originalLine, column: c.originalColumn });
        a.source != null && (c.source = a.source, n != null && (c.source = F.join(n, c.source)), o != null && (c.source = F.relative(o, c.source)), c.originalLine = a.line, c.originalColumn = a.column, a.name != null && (c.name = a.name));
      }
      var l = c.source;
      l != null && !s.has(l) && s.add(l);
      var p = c.name;
      p != null && !u.has(p) && u.add(p);
    }, this), this._sources = s, this._names = u, t2.sources.forEach(function(c) {
      var a = t2.sourceContentFor(c);
      a != null && (n != null && (c = F.join(n, c)), o != null && (c = F.relative(o, c)), this.setSourceContent(c, a));
    }, this);
  };
  ne.prototype._validateMapping = function(t2, r, n, i) {
    if (r && typeof r.line != "number" && typeof r.column != "number") throw new Error("original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.");
    if (!(t2 && "line" in t2 && "column" in t2 && t2.line > 0 && t2.column >= 0 && !r && !n && !i)) {
      if (t2 && "line" in t2 && "column" in t2 && r && "line" in r && "column" in r && t2.line > 0 && t2.column >= 0 && r.line > 0 && r.column >= 0 && n) return;
      throw new Error("Invalid mapping: " + JSON.stringify({ generated: t2, source: n, original: r, name: i }));
    }
  };
  ne.prototype._serializeMappings = function() {
    for (var t2 = 0, r = 1, n = 0, i = 0, o = 0, s = 0, u = "", c, a, l, p, h = this._mappings.toArray(), d = 0, g2 = h.length; d < g2; d++) {
      if (a = h[d], c = "", a.generatedLine !== r) for (t2 = 0; a.generatedLine !== r; ) c += ";", r++;
      else if (d > 0) {
        if (!F.compareByGeneratedPositionsInflated(a, h[d - 1])) continue;
        c += ",";
      }
      c += ct.encode(a.generatedColumn - t2), t2 = a.generatedColumn, a.source != null && (p = this._sources.indexOf(a.source), c += ct.encode(p - s), s = p, c += ct.encode(a.originalLine - 1 - i), i = a.originalLine - 1, c += ct.encode(a.originalColumn - n), n = a.originalColumn, a.name != null && (l = this._names.indexOf(a.name), c += ct.encode(l - o), o = l)), u += c;
    }
    return u;
  };
  ne.prototype._generateSourcesContent = function(t2, r) {
    return t2.map(function(n) {
      if (!this._sourcesContents) return null;
      r != null && (n = F.relative(r, n));
      var i = F.toSetString(n);
      return Object.prototype.hasOwnProperty.call(this._sourcesContents, i) ? this._sourcesContents[i] : null;
    }, this);
  };
  ne.prototype.toJSON = function() {
    var t2 = { version: this._version, sources: this._sources.toArray(), names: this._names.toArray(), mappings: this._serializeMappings() };
    return this._file != null && (t2.file = this._file), this._sourceRoot != null && (t2.sourceRoot = this._sourceRoot), this._sourcesContents && (t2.sourcesContent = this._generateSourcesContent(t2.sources, t2.sourceRoot)), t2;
  };
  ne.prototype.toString = function() {
    return JSON.stringify(this.toJSON());
  };
  _o.SourceMapGenerator = ne;
});
var sr = {};
f(sr, { AtKeyword: () => D, BadString: () => Be, BadUrl: () => H, CDC: () => G, CDO: () => ze, Colon: () => B, Comma: () => Y, Comment: () => N, Delim: () => v, Dimension: () => k, EOF: () => be, Function: () => y, Hash: () => A2, Ident: () => m, LeftCurlyBracket: () => R, LeftParenthesis: () => S, LeftSquareBracket: () => X, Number: () => b, Percentage: () => P, RightCurlyBracket: () => $2, RightParenthesis: () => x, RightSquareBracket: () => Z, Semicolon: () => _, String: () => te, Url: () => M, WhiteSpace: () => L });
var be = 0;
var m = 1;
var y = 2;
var D = 3;
var A2 = 4;
var te = 5;
var Be = 6;
var M = 7;
var H = 8;
var v = 9;
var b = 10;
var P = 11;
var k = 12;
var L = 13;
var ze = 14;
var G = 15;
var B = 16;
var _ = 17;
var Y = 18;
var X = 19;
var Z = 20;
var S = 21;
var x = 22;
var R = 23;
var $2 = 24;
var N = 25;
function O(e2) {
  return e2 >= 48 && e2 <= 57;
}
function J(e2) {
  return O(e2) || e2 >= 65 && e2 <= 70 || e2 >= 97 && e2 <= 102;
}
function Lt(e2) {
  return e2 >= 65 && e2 <= 90;
}
function ja(e2) {
  return e2 >= 97 && e2 <= 122;
}
function Ua(e2) {
  return Lt(e2) || ja(e2);
}
function Ha(e2) {
  return e2 >= 128;
}
function At(e2) {
  return Ua(e2) || Ha(e2) || e2 === 95;
}
function _e(e2) {
  return At(e2) || O(e2) || e2 === 45;
}
function Ga(e2) {
  return e2 >= 0 && e2 <= 8 || e2 === 11 || e2 >= 14 && e2 <= 31 || e2 === 127;
}
function tt(e2) {
  return e2 === 10 || e2 === 13 || e2 === 12;
}
function me(e2) {
  return tt(e2) || e2 === 32 || e2 === 9;
}
function K(e2, t2) {
  return !(e2 !== 92 || tt(t2) || t2 === 0);
}
function We(e2, t2, r) {
  return e2 === 45 ? At(t2) || t2 === 45 || K(t2, r) : At(e2) ? true : e2 === 92 ? K(e2, t2) : false;
}
function Et(e2, t2, r) {
  return e2 === 43 || e2 === 45 ? O(t2) ? 2 : t2 === 46 && O(r) ? 3 : 0 : e2 === 46 ? O(t2) ? 2 : 0 : O(e2) ? 1 : 0;
}
function zt(e2) {
  return e2 === 65279 || e2 === 65534 ? 1 : 0;
}
var ar = new Array(128);
var Ya = 128;
var rt = 130;
var lr = 131;
var Pt = 132;
var cr = 133;
for (let e2 = 0; e2 < ar.length; e2++) ar[e2] = me(e2) && rt || O(e2) && lr || At(e2) && Pt || Ga(e2) && cr || e2 || Ya;
function It(e2) {
  return e2 < 128 ? ar[e2] : Pt;
}
function qe(e2, t2) {
  return t2 < e2.length ? e2.charCodeAt(t2) : 0;
}
function Dt(e2, t2, r) {
  return r === 13 && qe(e2, t2 + 1) === 10 ? 2 : 1;
}
function xe(e2, t2, r) {
  let n = e2.charCodeAt(t2);
  return Lt(n) && (n = n | 32), n === r;
}
function ye(e2, t2, r, n) {
  if (r - t2 !== n.length || t2 < 0 || r > e2.length) return false;
  for (let i = t2; i < r; i++) {
    let o = n.charCodeAt(i - t2), s = e2.charCodeAt(i);
    if (Lt(s) && (s = s | 32), s !== o) return false;
  }
  return true;
}
function lo(e2, t2) {
  for (; t2 >= 0 && me(e2.charCodeAt(t2)); t2--) ;
  return t2 + 1;
}
function nt(e2, t2) {
  for (; t2 < e2.length && me(e2.charCodeAt(t2)); t2++) ;
  return t2;
}
function ur(e2, t2) {
  for (; t2 < e2.length && O(e2.charCodeAt(t2)); t2++) ;
  return t2;
}
function se(e2, t2) {
  if (t2 += 2, J(qe(e2, t2 - 1))) {
    for (let n = Math.min(e2.length, t2 + 5); t2 < n && J(qe(e2, t2)); t2++) ;
    let r = qe(e2, t2);
    me(r) && (t2 += Dt(e2, t2, r));
  }
  return t2;
}
function it(e2, t2) {
  for (; t2 < e2.length; t2++) {
    let r = e2.charCodeAt(t2);
    if (!_e(r)) {
      if (K(r, qe(e2, t2 + 1))) {
        t2 = se(e2, t2) - 1;
        continue;
      }
      break;
    }
  }
  return t2;
}
function Pe(e2, t2) {
  let r = e2.charCodeAt(t2);
  if ((r === 43 || r === 45) && (r = e2.charCodeAt(t2 += 1)), O(r) && (t2 = ur(e2, t2 + 1), r = e2.charCodeAt(t2)), r === 46 && O(e2.charCodeAt(t2 + 1)) && (t2 += 2, t2 = ur(e2, t2)), xe(e2, t2, 101)) {
    let n = 0;
    r = e2.charCodeAt(t2 + 1), (r === 45 || r === 43) && (n = 1, r = e2.charCodeAt(t2 + 2)), O(r) && (t2 = ur(e2, t2 + 1 + n + 1));
  }
  return t2;
}
function Nt(e2, t2) {
  for (; t2 < e2.length; t2++) {
    let r = e2.charCodeAt(t2);
    if (r === 41) {
      t2++;
      break;
    }
    K(r, qe(e2, t2 + 1)) && (t2 = se(e2, t2));
  }
  return t2;
}
function je(e2) {
  if (e2.length === 1 && !J(e2.charCodeAt(0))) return e2[0];
  let t2 = parseInt(e2, 16);
  return (t2 === 0 || t2 >= 55296 && t2 <= 57343 || t2 > 1114111) && (t2 = 65533), String.fromCodePoint(t2);
}
var Ie = ["EOF-token", "ident-token", "function-token", "at-keyword-token", "hash-token", "string-token", "bad-string-token", "url-token", "bad-url-token", "delim-token", "number-token", "percentage-token", "dimension-token", "whitespace-token", "CDO-token", "CDC-token", "colon-token", "semicolon-token", "comma-token", "[-token", "]-token", "(-token", ")-token", "{-token", "}-token", "comment-token"];
function Ue(e2 = null, t2) {
  return e2 === null || e2.length < t2 ? new Uint32Array(Math.max(t2 + 1024, 16384)) : e2;
}
var co = 10;
var Ka = 12;
var uo = 13;
function po(e2) {
  let t2 = e2.source, r = t2.length, n = t2.length > 0 ? zt(t2.charCodeAt(0)) : 0, i = Ue(e2.lines, r), o = Ue(e2.columns, r), s = e2.startLine, u = e2.startColumn;
  for (let c = n; c < r; c++) {
    let a = t2.charCodeAt(c);
    i[c] = s, o[c] = u++, (a === co || a === uo || a === Ka) && (a === uo && c + 1 < r && t2.charCodeAt(c + 1) === co && (c++, i[c] = s, o[c] = u), s++, u = 1);
  }
  i[r] = s, o[r] = u, e2.lines = i, e2.columns = o, e2.computed = true;
}
var ot = class {
  constructor(t2, r, n, i) {
    this.setSource(t2, r, n, i), this.lines = null, this.columns = null;
  }
  setSource(t2 = "", r = 0, n = 1, i = 1) {
    this.source = t2, this.startOffset = r, this.startLine = n, this.startColumn = i, this.computed = false;
  }
  getLocation(t2, r) {
    return this.computed || po(this), { source: r, offset: this.startOffset + t2, line: this.lines[t2], column: this.columns[t2] };
  }
  getLocationRange(t2, r, n) {
    return this.computed || po(this), { source: n, start: { offset: this.startOffset + t2, line: this.lines[t2], column: this.columns[t2] }, end: { offset: this.startOffset + r, line: this.lines[r], column: this.columns[r] } };
  }
};
var ae = 16777215;
var le = 24;
var at = 1;
var Ot = 2;
var Se = new Uint8Array(32);
Se[2] = 22;
Se[21] = 22;
Se[19] = 20;
Se[23] = 24;
var ce = new Uint8Array(32);
ce[2] = at;
ce[21] = at;
ce[19] = at;
ce[23] = at;
ce[22] = Ot;
ce[20] = Ot;
ce[24] = Ot;
function ho(e2, t2, r) {
  return e2 < t2 ? t2 : e2 > r ? r : e2;
}
var st = class {
  constructor(t2, r) {
    this.setSource(t2, r);
  }
  reset() {
    this.eof = false, this.tokenIndex = -1, this.tokenType = 0, this.tokenStart = this.firstCharOffset, this.tokenEnd = this.firstCharOffset;
  }
  setSource(t2 = "", r = () => {
  }) {
    t2 = String(t2 || "");
    let n = t2.length, i = Ue(this.offsetAndType, t2.length + 1), o = Ue(this.balance, t2.length + 1), s = 0, u = -1, c = 0, a = t2.length;
    this.offsetAndType = null, this.balance = null, o.fill(0), r(t2, (l, p, h) => {
      let d = s++;
      if (i[d] = l << le | h, u === -1 && (u = p), o[d] = a, l === c) {
        let g2 = o[a];
        o[a] = d, a = g2, c = Se[i[g2] >> le];
      } else this.isBlockOpenerTokenType(l) && (a = d, c = Se[l]);
    }), i[s] = 0 << le | n, o[s] = s;
    for (let l = 0; l < s; l++) {
      let p = o[l];
      if (p <= l) {
        let h = o[p];
        h !== l && (o[l] = h);
      } else p > s && (o[l] = s);
    }
    this.source = t2, this.firstCharOffset = u === -1 ? 0 : u, this.tokenCount = s, this.offsetAndType = i, this.balance = o, this.reset(), this.next();
  }
  lookupType(t2) {
    return t2 += this.tokenIndex, t2 < this.tokenCount ? this.offsetAndType[t2] >> le : 0;
  }
  lookupTypeNonSC(t2) {
    for (let r = this.tokenIndex; r < this.tokenCount; r++) {
      let n = this.offsetAndType[r] >> le;
      if (n !== 13 && n !== 25 && t2-- === 0) return n;
    }
    return 0;
  }
  lookupOffset(t2) {
    return t2 += this.tokenIndex, t2 < this.tokenCount ? this.offsetAndType[t2 - 1] & ae : this.source.length;
  }
  lookupOffsetNonSC(t2) {
    for (let r = this.tokenIndex; r < this.tokenCount; r++) {
      let n = this.offsetAndType[r] >> le;
      if (n !== 13 && n !== 25 && t2-- === 0) return r - this.tokenIndex;
    }
    return 0;
  }
  lookupValue(t2, r) {
    return t2 += this.tokenIndex, t2 < this.tokenCount ? ye(this.source, this.offsetAndType[t2 - 1] & ae, this.offsetAndType[t2] & ae, r) : false;
  }
  getTokenStart(t2) {
    return t2 === this.tokenIndex ? this.tokenStart : t2 > 0 ? t2 < this.tokenCount ? this.offsetAndType[t2 - 1] & ae : this.offsetAndType[this.tokenCount] & ae : this.firstCharOffset;
  }
  getTokenEnd(t2) {
    return t2 === this.tokenIndex ? this.tokenEnd : this.offsetAndType[ho(t2, 0, this.tokenCount)] & ae;
  }
  getTokenType(t2) {
    return t2 === this.tokenIndex ? this.tokenType : this.offsetAndType[ho(t2, 0, this.tokenCount)] >> le;
  }
  substrToCursor(t2) {
    return this.source.substring(t2, this.tokenStart);
  }
  isBlockOpenerTokenType(t2) {
    return ce[t2] === at;
  }
  isBlockCloserTokenType(t2) {
    return ce[t2] === Ot;
  }
  getBlockTokenPairIndex(t2) {
    let r = this.getTokenType(t2);
    if (ce[r] === 1) {
      let n = this.balance[t2], i = this.getTokenType(n);
      return Se[r] === i ? n : -1;
    } else if (ce[r] === 2) {
      let n = this.balance[t2], i = this.getTokenType(n);
      return Se[i] === r ? n : -1;
    }
    return -1;
  }
  isBalanceEdge(t2) {
    return this.balance[this.tokenIndex] < t2;
  }
  isDelim(t2, r) {
    return r ? this.lookupType(r) === 9 && this.source.charCodeAt(this.lookupOffset(r)) === t2 : this.tokenType === 9 && this.source.charCodeAt(this.tokenStart) === t2;
  }
  skip(t2) {
    let r = this.tokenIndex + t2;
    r < this.tokenCount ? (this.tokenIndex = r, this.tokenStart = this.offsetAndType[r - 1] & ae, r = this.offsetAndType[r], this.tokenType = r >> le, this.tokenEnd = r & ae) : (this.tokenIndex = this.tokenCount, this.next());
  }
  next() {
    let t2 = this.tokenIndex + 1;
    t2 < this.tokenCount ? (this.tokenIndex = t2, this.tokenStart = this.tokenEnd, t2 = this.offsetAndType[t2], this.tokenType = t2 >> le, this.tokenEnd = t2 & ae) : (this.eof = true, this.tokenIndex = this.tokenCount, this.tokenType = 0, this.tokenStart = this.tokenEnd = this.source.length);
  }
  skipSC() {
    for (; this.tokenType === 13 || this.tokenType === 25; ) this.next();
  }
  skipUntilBalanced(t2, r) {
    let n = t2, i = 0, o = 0;
    e: for (; n < this.tokenCount; n++) {
      if (i = this.balance[n], i < t2) break e;
      switch (o = n > 0 ? this.offsetAndType[n - 1] & ae : this.firstCharOffset, r(this.source.charCodeAt(o))) {
        case 1:
          break e;
        case 2:
          n++;
          break e;
        default:
          this.isBlockOpenerTokenType(this.offsetAndType[n] >> le) && (n = i);
      }
    }
    this.skip(n - this.tokenIndex);
  }
  forEachToken(t2) {
    for (let r = 0, n = this.firstCharOffset; r < this.tokenCount; r++) {
      let i = n, o = this.offsetAndType[r], s = o & ae, u = o >> le;
      n = s, t2(u, i, s, r);
    }
  }
  dump() {
    let t2 = new Array(this.tokenCount);
    return this.forEachToken((r, n, i, o) => {
      t2[o] = { idx: o, type: Ie[r], chunk: this.source.substring(n, i), balance: this.balance[o] };
    }), t2;
  }
};
function Ce(e2, t2) {
  function r(p) {
    return p < u ? e2.charCodeAt(p) : 0;
  }
  function n() {
    if (a = Pe(e2, a), We(r(a), r(a + 1), r(a + 2))) {
      l = 12, a = it(e2, a);
      return;
    }
    if (r(a) === 37) {
      l = 11, a++;
      return;
    }
    l = 10;
  }
  function i() {
    let p = a;
    if (a = it(e2, a), ye(e2, p, a, "url") && r(a) === 40) {
      if (a = nt(e2, a + 1), r(a) === 34 || r(a) === 39) {
        l = 2, a = p + 4;
        return;
      }
      s();
      return;
    }
    if (r(a) === 40) {
      l = 2, a++;
      return;
    }
    l = 1;
  }
  function o(p) {
    for (p || (p = r(a++)), l = 5; a < e2.length; a++) {
      let h = e2.charCodeAt(a);
      switch (It(h)) {
        case p:
          a++;
          return;
        case rt:
          if (tt(h)) {
            a += Dt(e2, a, h), l = 6;
            return;
          }
          break;
        case 92:
          if (a === e2.length - 1) break;
          let d = r(a + 1);
          tt(d) ? a += Dt(e2, a + 1, d) : K(h, d) && (a = se(e2, a) - 1);
          break;
      }
    }
  }
  function s() {
    for (l = 7, a = nt(e2, a); a < e2.length; a++) {
      let p = e2.charCodeAt(a);
      switch (It(p)) {
        case 41:
          a++;
          return;
        case rt:
          if (a = nt(e2, a), r(a) === 41 || a >= e2.length) {
            a < e2.length && a++;
            return;
          }
          a = Nt(e2, a), l = 8;
          return;
        case 34:
        case 39:
        case 40:
        case cr:
          a = Nt(e2, a), l = 8;
          return;
        case 92:
          if (K(p, r(a + 1))) {
            a = se(e2, a) - 1;
            break;
          }
          a = Nt(e2, a), l = 8;
          return;
      }
    }
  }
  e2 = String(e2 || "");
  let u = e2.length, c = zt(r(0)), a = c, l;
  for (; a < u; ) {
    let p = e2.charCodeAt(a);
    switch (It(p)) {
      case rt:
        l = 13, a = nt(e2, a + 1);
        break;
      case 34:
        o();
        break;
      case 35:
        _e(r(a + 1)) || K(r(a + 1), r(a + 2)) ? (l = 4, a = it(e2, a + 1)) : (l = 9, a++);
        break;
      case 39:
        o();
        break;
      case 40:
        l = 21, a++;
        break;
      case 41:
        l = 22, a++;
        break;
      case 43:
        Et(p, r(a + 1), r(a + 2)) ? n() : (l = 9, a++);
        break;
      case 44:
        l = 18, a++;
        break;
      case 45:
        Et(p, r(a + 1), r(a + 2)) ? n() : r(a + 1) === 45 && r(a + 2) === 62 ? (l = 15, a = a + 3) : We(p, r(a + 1), r(a + 2)) ? i() : (l = 9, a++);
        break;
      case 46:
        Et(p, r(a + 1), r(a + 2)) ? n() : (l = 9, a++);
        break;
      case 47:
        r(a + 1) === 42 ? (l = 25, a = e2.indexOf("*/", a + 2), a = a === -1 ? e2.length : a + 2) : (l = 9, a++);
        break;
      case 58:
        l = 16, a++;
        break;
      case 59:
        l = 17, a++;
        break;
      case 60:
        r(a + 1) === 33 && r(a + 2) === 45 && r(a + 3) === 45 ? (l = 14, a = a + 4) : (l = 9, a++);
        break;
      case 64:
        We(r(a + 1), r(a + 2), r(a + 3)) ? (l = 3, a = it(e2, a + 1)) : (l = 9, a++);
        break;
      case 91:
        l = 19, a++;
        break;
      case 92:
        K(p, r(a + 1)) ? i() : (l = 9, a++);
        break;
      case 93:
        l = 20, a++;
        break;
      case 123:
        l = 23, a++;
        break;
      case 125:
        l = 24, a++;
        break;
      case lr:
        n();
        break;
      case Pt:
        i();
        break;
      default:
        l = 9, a++;
    }
    t2(l, c, c = a);
  }
}
var He = null;
var V = class e {
  static createItem(t2) {
    return { prev: null, next: null, data: t2 };
  }
  constructor() {
    this.head = null, this.tail = null, this.cursor = null;
  }
  createItem(t2) {
    return e.createItem(t2);
  }
  allocateCursor(t2, r) {
    let n;
    return He !== null ? (n = He, He = He.cursor, n.prev = t2, n.next = r, n.cursor = this.cursor) : n = { prev: t2, next: r, cursor: this.cursor }, this.cursor = n, n;
  }
  releaseCursor() {
    let { cursor: t2 } = this;
    this.cursor = t2.cursor, t2.prev = null, t2.next = null, t2.cursor = He, He = t2;
  }
  updateCursors(t2, r, n, i) {
    let { cursor: o } = this;
    for (; o !== null; ) o.prev === t2 && (o.prev = r), o.next === n && (o.next = i), o = o.cursor;
  }
  *[Symbol.iterator]() {
    for (let t2 = this.head; t2 !== null; t2 = t2.next) yield t2.data;
  }
  get size() {
    let t2 = 0;
    for (let r = this.head; r !== null; r = r.next) t2++;
    return t2;
  }
  get isEmpty() {
    return this.head === null;
  }
  get first() {
    return this.head && this.head.data;
  }
  get last() {
    return this.tail && this.tail.data;
  }
  fromArray(t2) {
    let r = null;
    this.head = null;
    for (let n of t2) {
      let i = e.createItem(n);
      r !== null ? r.next = i : this.head = i, i.prev = r, r = i;
    }
    return this.tail = r, this;
  }
  toArray() {
    return [...this];
  }
  toJSON() {
    return [...this];
  }
  forEach(t2, r = this) {
    let n = this.allocateCursor(null, this.head);
    for (; n.next !== null; ) {
      let i = n.next;
      n.next = i.next, t2.call(r, i.data, i, this);
    }
    this.releaseCursor();
  }
  forEachRight(t2, r = this) {
    let n = this.allocateCursor(this.tail, null);
    for (; n.prev !== null; ) {
      let i = n.prev;
      n.prev = i.prev, t2.call(r, i.data, i, this);
    }
    this.releaseCursor();
  }
  reduce(t2, r, n = this) {
    let i = this.allocateCursor(null, this.head), o = r, s;
    for (; i.next !== null; ) s = i.next, i.next = s.next, o = t2.call(n, o, s.data, s, this);
    return this.releaseCursor(), o;
  }
  reduceRight(t2, r, n = this) {
    let i = this.allocateCursor(this.tail, null), o = r, s;
    for (; i.prev !== null; ) s = i.prev, i.prev = s.prev, o = t2.call(n, o, s.data, s, this);
    return this.releaseCursor(), o;
  }
  some(t2, r = this) {
    for (let n = this.head; n !== null; n = n.next) if (t2.call(r, n.data, n, this)) return true;
    return false;
  }
  map(t2, r = this) {
    let n = new e();
    for (let i = this.head; i !== null; i = i.next) n.appendData(t2.call(r, i.data, i, this));
    return n;
  }
  filter(t2, r = this) {
    let n = new e();
    for (let i = this.head; i !== null; i = i.next) t2.call(r, i.data, i, this) && n.appendData(i.data);
    return n;
  }
  nextUntil(t2, r, n = this) {
    if (t2 === null) return;
    let i = this.allocateCursor(null, t2);
    for (; i.next !== null; ) {
      let o = i.next;
      if (i.next = o.next, r.call(n, o.data, o, this)) break;
    }
    this.releaseCursor();
  }
  prevUntil(t2, r, n = this) {
    if (t2 === null) return;
    let i = this.allocateCursor(t2, null);
    for (; i.prev !== null; ) {
      let o = i.prev;
      if (i.prev = o.prev, r.call(n, o.data, o, this)) break;
    }
    this.releaseCursor();
  }
  clear() {
    this.head = null, this.tail = null;
  }
  copy() {
    let t2 = new e();
    for (let r of this) t2.appendData(r);
    return t2;
  }
  prepend(t2) {
    return this.updateCursors(null, t2, this.head, t2), this.head !== null ? (this.head.prev = t2, t2.next = this.head) : this.tail = t2, this.head = t2, this;
  }
  prependData(t2) {
    return this.prepend(e.createItem(t2));
  }
  append(t2) {
    return this.insert(t2);
  }
  appendData(t2) {
    return this.insert(e.createItem(t2));
  }
  insert(t2, r = null) {
    if (r !== null) if (this.updateCursors(r.prev, t2, r, t2), r.prev === null) {
      if (this.head !== r) throw new Error("before doesn't belong to list");
      this.head = t2, r.prev = t2, t2.next = r, this.updateCursors(null, t2);
    } else r.prev.next = t2, t2.prev = r.prev, r.prev = t2, t2.next = r;
    else this.updateCursors(this.tail, t2, null, t2), this.tail !== null ? (this.tail.next = t2, t2.prev = this.tail) : this.head = t2, this.tail = t2;
    return this;
  }
  insertData(t2, r) {
    return this.insert(e.createItem(t2), r);
  }
  remove(t2) {
    if (this.updateCursors(t2, t2.prev, t2, t2.next), t2.prev !== null) t2.prev.next = t2.next;
    else {
      if (this.head !== t2) throw new Error("item doesn't belong to list");
      this.head = t2.next;
    }
    if (t2.next !== null) t2.next.prev = t2.prev;
    else {
      if (this.tail !== t2) throw new Error("item doesn't belong to list");
      this.tail = t2.prev;
    }
    return t2.prev = null, t2.next = null, t2;
  }
  push(t2) {
    this.insert(e.createItem(t2));
  }
  pop() {
    return this.tail !== null ? this.remove(this.tail) : null;
  }
  unshift(t2) {
    this.prepend(e.createItem(t2));
  }
  shift() {
    return this.head !== null ? this.remove(this.head) : null;
  }
  prependList(t2) {
    return this.insertList(t2, this.head);
  }
  appendList(t2) {
    return this.insertList(t2);
  }
  insertList(t2, r) {
    return t2.head === null ? this : (r != null ? (this.updateCursors(r.prev, t2.tail, r, t2.head), r.prev !== null ? (r.prev.next = t2.head, t2.head.prev = r.prev) : this.head = t2.head, r.prev = t2.tail, t2.tail.next = r) : (this.updateCursors(this.tail, t2.tail, null, t2.head), this.tail !== null ? (this.tail.next = t2.head, t2.head.prev = this.tail) : this.head = t2.head, this.tail = t2.tail), t2.head = null, t2.tail = null, this);
  }
  replace(t2, r) {
    "head" in r ? this.insertList(r, t2) : this.insert(r, t2), this.remove(t2);
  }
};
function De(e2, t2) {
  let r = Object.create(SyntaxError.prototype), n = new Error();
  return Object.assign(r, { name: e2, message: t2, get stack() {
    return (n.stack || "").replace(/^(.+\n){1,3}/, `${e2}: ${t2}
`);
  } });
}
var pr = 100;
var mo = 60;
var fo = "    ";
function go({ source: e2, line: t2, column: r, baseLine: n, baseColumn: i }, o) {
  function s(g2, ee) {
    return a.slice(g2, ee).map((j, w) => String(g2 + w + 1).padStart(h) + " |" + j).join(`
`);
  }
  let u = `
`.repeat(Math.max(n - 1, 0)), c = " ".repeat(Math.max(i - 1, 0)), a = (u + c + e2).split(/\r\n?|\n|\f/), l = Math.max(1, t2 - o) - 1, p = Math.min(t2 + o, a.length + 1), h = Math.max(4, String(p).length) + 1, d = 0;
  r += (fo.length - 1) * (a[t2 - 1].substr(0, r - 1).match(/\t/g) || []).length, r > pr && (d = r - mo + 3, r = mo - 2);
  for (let g2 = l; g2 <= p; g2++) g2 >= 0 && g2 < a.length && (a[g2] = a[g2].replace(/\t/g, fo), a[g2] = (d > 0 && a[g2].length > d ? "\u2026" : "") + a[g2].substr(d, pr - 2) + (a[g2].length > d + pr - 1 ? "\u2026" : ""));
  return [s(l, t2), new Array(r + h + 2).join("-") + "^", s(t2, p)].filter(Boolean).join(`
`).replace(/^(\s+\d+\s+\|\n)+/, "").replace(/\n(\s+\d+\s+\|)+$/, "");
}
function hr(e2, t2, r, n, i, o = 1, s = 1) {
  return Object.assign(De("SyntaxError", e2), { source: t2, offset: r, line: n, column: i, sourceFragment(c) {
    return go({ source: t2, line: n, column: i, baseLine: o, baseColumn: s }, isNaN(c) ? 0 : c);
  }, get formattedMessage() {
    return `Parse error: ${e2}
` + go({ source: t2, line: n, column: i, baseLine: o, baseColumn: s }, 2);
  } });
}
function bo(e2) {
  let t2 = this.createList(), r = false, n = { recognizer: e2 };
  for (; !this.eof; ) {
    switch (this.tokenType) {
      case 25:
        this.next();
        continue;
      case 13:
        r = true, this.next();
        continue;
    }
    let i = e2.getNode.call(this, n);
    if (i === void 0) break;
    r && (e2.onWhiteSpace && e2.onWhiteSpace.call(this, i, t2, n), r = false), t2.push(i);
  }
  return r && e2.onWhiteSpace && e2.onWhiteSpace.call(this, null, t2, n), t2;
}
var xo = () => {
};
var Va = 33;
var Qa = 35;
var mr = 59;
var yo = 123;
var ko = 0;
function Xa(e2) {
  return function() {
    return this[e2]();
  };
}
function dr(e2) {
  let t2 = /* @__PURE__ */ Object.create(null);
  for (let r of Object.keys(e2)) {
    let n = e2[r], i = n.parse || n;
    i && (t2[r] = i);
  }
  return t2;
}
function $a(e2) {
  let t2 = { context: /* @__PURE__ */ Object.create(null), features: Object.assign(/* @__PURE__ */ Object.create(null), e2.features), scope: Object.assign(/* @__PURE__ */ Object.create(null), e2.scope), atrule: dr(e2.atrule), pseudo: dr(e2.pseudo), node: dr(e2.node) };
  for (let [r, n] of Object.entries(e2.parseContext)) switch (typeof n) {
    case "function":
      t2.context[r] = n;
      break;
    case "string":
      t2.context[r] = Xa(n);
      break;
  }
  return { config: t2, ...t2, ...t2.node };
}
function wo(e2) {
  let t2 = "", r = "<unknown>", n = false, i = xo, o = false, s = new ot(), u = Object.assign(new st(), $a(e2 || {}), { parseAtrulePrelude: true, parseRulePrelude: true, parseValue: true, parseCustomProperty: false, readSequence: bo, consumeUntilBalanceEnd: () => 0, consumeUntilLeftCurlyBracket(l) {
    return l === yo ? 1 : 0;
  }, consumeUntilLeftCurlyBracketOrSemicolon(l) {
    return l === yo || l === mr ? 1 : 0;
  }, consumeUntilExclamationMarkOrSemicolon(l) {
    return l === Va || l === mr ? 1 : 0;
  }, consumeUntilSemicolonIncluded(l) {
    return l === mr ? 2 : 0;
  }, createList() {
    return new V();
  }, createSingleNodeList(l) {
    return new V().appendData(l);
  }, getFirstListNode(l) {
    return l && l.first;
  }, getLastListNode(l) {
    return l && l.last;
  }, parseWithFallback(l, p) {
    let h = this.tokenIndex;
    try {
      return l.call(this);
    } catch (d) {
      if (o) throw d;
      this.skip(h - this.tokenIndex);
      let g2 = p.call(this);
      return o = true, i(d, g2), o = false, g2;
    }
  }, lookupNonWSType(l) {
    let p;
    do
      if (p = this.lookupType(l++), p !== 13 && p !== 25) return p;
    while (p !== ko);
    return ko;
  }, charCodeAt(l) {
    return l >= 0 && l < t2.length ? t2.charCodeAt(l) : 0;
  }, substring(l, p) {
    return t2.substring(l, p);
  }, substrToCursor(l) {
    return this.source.substring(l, this.tokenStart);
  }, cmpChar(l, p) {
    return xe(t2, l, p);
  }, cmpStr(l, p, h) {
    return ye(t2, l, p, h);
  }, consume(l) {
    let p = this.tokenStart;
    return this.eat(l), this.substrToCursor(p);
  }, consumeFunctionName() {
    let l = t2.substring(this.tokenStart, this.tokenEnd - 1);
    return this.eat(2), l;
  }, consumeNumber(l) {
    let p = t2.substring(this.tokenStart, Pe(t2, this.tokenStart));
    return this.eat(l), p;
  }, eat(l) {
    if (this.tokenType !== l) {
      let p = Ie[l].slice(0, -6).replace(/-/g, " ").replace(/^./, (g2) => g2.toUpperCase()), h = `${/[[\](){}]/.test(p) ? `"${p}"` : p} is expected`, d = this.tokenStart;
      switch (l) {
        case 1:
          this.tokenType === 2 || this.tokenType === 7 ? (d = this.tokenEnd - 1, h = "Identifier is expected but function found") : h = "Identifier is expected";
          break;
        case 4:
          this.isDelim(Qa) && (this.next(), d++, h = "Name is expected");
          break;
        case 11:
          this.tokenType === 10 && (d = this.tokenEnd, h = "Percent sign is expected");
          break;
      }
      this.error(h, d);
    }
    this.next();
  }, eatIdent(l) {
    (this.tokenType !== 1 || this.lookupValue(0, l) === false) && this.error(`Identifier "${l}" is expected`), this.next();
  }, eatDelim(l) {
    this.isDelim(l) || this.error(`Delim "${String.fromCharCode(l)}" is expected`), this.next();
  }, getLocation(l, p) {
    return n ? s.getLocationRange(l, p, r) : null;
  }, getLocationFromList(l) {
    if (n) {
      let p = this.getFirstListNode(l), h = this.getLastListNode(l);
      return s.getLocationRange(p !== null ? p.loc.start.offset - s.startOffset : this.tokenStart, h !== null ? h.loc.end.offset - s.startOffset : this.tokenStart, r);
    }
    return null;
  }, error(l, p) {
    let h = typeof p < "u" && p < t2.length ? s.getLocation(p) : this.eof ? s.getLocation(lo(t2, t2.length - 1)) : s.getLocation(this.tokenStart);
    throw new hr(l || "Unexpected input", t2, h.offset, h.line, h.column, s.startLine, s.startColumn);
  } }), c = () => ({ filename: r, source: t2, tokenCount: u.tokenCount, getTokenType: (l) => u.getTokenType(l), getTokenTypeName: (l) => Ie[u.getTokenType(l)], getTokenStart: (l) => u.getTokenStart(l), getTokenEnd: (l) => u.getTokenEnd(l), getTokenValue: (l) => u.source.substring(u.getTokenStart(l), u.getTokenEnd(l)), substring: (l, p) => u.source.substring(l, p), balance: u.balance.subarray(0, u.tokenCount + 1), isBlockOpenerTokenType: u.isBlockOpenerTokenType, isBlockCloserTokenType: u.isBlockCloserTokenType, getBlockTokenPairIndex: (l) => u.getBlockTokenPairIndex(l), getLocation: (l) => s.getLocation(l, r), getRangeLocation: (l, p) => s.getLocationRange(l, p, r) });
  return Object.assign(function(l, p) {
    t2 = l, p = p || {}, u.setSource(t2, Ce), s.setSource(t2, p.offset, p.line, p.column), r = p.filename || "<unknown>", n = !!p.positions, i = typeof p.onParseError == "function" ? p.onParseError : xo, o = false, u.parseAtrulePrelude = "parseAtrulePrelude" in p ? !!p.parseAtrulePrelude : true, u.parseRulePrelude = "parseRulePrelude" in p ? !!p.parseRulePrelude : true, u.parseValue = "parseValue" in p ? !!p.parseValue : true, u.parseCustomProperty = "parseCustomProperty" in p ? !!p.parseCustomProperty : false;
    let { context: h = "default", onComment: d, onToken: g2 } = p;
    if (!(h in u.context)) throw new Error("Unknown context `" + h + "`");
    Array.isArray(g2) ? u.forEachToken((j, w, T) => {
      g2.push({ type: j, start: w, end: T });
    }) : typeof g2 == "function" && u.forEachToken(g2.bind(c())), typeof d == "function" && u.forEachToken((j, w, T) => {
      if (j === 25) {
        let he = u.getLocation(w, T), z = ye(t2, T - 2, T, "*/") ? t2.slice(w + 2, T - 2) : t2.slice(w + 2, T);
        d(z, he);
      }
    });
    let ee = u.context[h].call(u, p);
    return u.eof || u.error(), ee;
  }, { SyntaxError: hr, config: u.config });
}
var jo = qa(Wo(), 1);
var qo = /* @__PURE__ */ new Set(["Atrule", "Selector", "Declaration"]);
function Uo(e2) {
  let t2 = new jo.SourceMapGenerator(), r = { line: 1, column: 0 }, n = { line: 0, column: 0 }, i = { line: 1, column: 0 }, o = { generated: i }, s = 1, u = 0, c = false, a = e2.node;
  e2.node = function(h) {
    if (h.loc && h.loc.start && qo.has(h.type)) {
      let d = h.loc.start.line, g2 = h.loc.start.column - 1;
      (n.line !== d || n.column !== g2) && (n.line = d, n.column = g2, r.line = s, r.column = u, c && (c = false, (r.line !== i.line || r.column !== i.column) && t2.addMapping(o)), c = true, t2.addMapping({ source: h.loc.source, original: n, generated: r }));
    }
    a.call(this, h), c && qo.has(h.type) && (i.line = s, i.column = u);
  };
  let l = e2.emit;
  e2.emit = function(h, d, g2) {
    for (let ee = 0; ee < h.length; ee++) h.charCodeAt(ee) === 10 ? (s++, u = 0) : u++;
    l(h, d, g2);
  };
  let p = e2.result;
  return e2.result = function() {
    return c && t2.addMapping(o), { css: p(), map: t2 };
  }, e2;
}
var Bt = {};
f(Bt, { safe: () => vr, spec: () => yl });
var gl = 43;
var bl = 45;
var wr = (e2, t2) => {
  if (e2 === 9 && (e2 = t2), typeof e2 == "string") {
    let r = e2.charCodeAt(0);
    return r > 127 ? 32768 : r << 8;
  }
  return e2;
};
var Ho = [[1, 1], [1, 2], [1, 7], [1, 8], [1, "-"], [1, 10], [1, 11], [1, 12], [1, 15], [1, 21], [3, 1], [3, 2], [3, 7], [3, 8], [3, "-"], [3, 10], [3, 11], [3, 12], [3, 15], [4, 1], [4, 2], [4, 7], [4, 8], [4, "-"], [4, 10], [4, 11], [4, 12], [4, 15], [12, 1], [12, 2], [12, 7], [12, 8], [12, "-"], [12, 10], [12, 11], [12, 12], [12, 15], ["#", 1], ["#", 2], ["#", 7], ["#", 8], ["#", "-"], ["#", 10], ["#", 11], ["#", 12], ["#", 15], ["-", 1], ["-", 2], ["-", 7], ["-", 8], ["-", "-"], ["-", 10], ["-", 11], ["-", 12], ["-", 15], [10, 1], [10, 2], [10, 7], [10, 8], [10, 10], [10, 11], [10, 12], [10, "%"], [10, 15], ["@", 1], ["@", 2], ["@", 7], ["@", 8], ["@", "-"], ["@", 15], [".", 10], [".", 11], [".", 12], ["+", 10], ["+", 11], ["+", 12], ["/", "*"]];
var xl = Ho.concat([[1, 4], [12, 4], [4, 4], [3, 21], [3, 5], [3, 16], [11, 11], [11, 12], [11, 2], [11, "-"], [22, 1], [22, 2], [22, 11], [22, 12], [22, 4], [22, "-"]]);
function Go(e2) {
  let t2 = new Set(e2.map(([r, n]) => wr(r) << 16 | wr(n)));
  return function(r, n, i) {
    let o = wr(n, i), s = i.charCodeAt(0);
    return (s === bl && n !== 1 && n !== 2 && n !== 15 || s === gl ? t2.has(r << 16 | s << 8) : t2.has(r << 16 | o)) && this.emit(" ", 13, true), o;
  };
}
var yl = Go(Ho);
var vr = Go(xl);
var kl = 92;
function wl(e2, t2) {
  if (typeof t2 == "function") {
    let r = null;
    e2.children.forEach((n) => {
      r !== null && t2.call(this, r), this.node(n), r = n;
    });
    return;
  }
  e2.children.forEach(this.node, this);
}
function vl(e2) {
  Ce(e2, (t2, r, n) => {
    this.token(t2, e2.slice(r, n));
  });
}
function Yo(e2) {
  let t2 = /* @__PURE__ */ new Map();
  for (let [r, n] of Object.entries(e2.node)) typeof (n.generate || n) == "function" && t2.set(r, n.generate || n);
  return function(r, n) {
    let i = "", o = 0, s = { node(c) {
      if (t2.has(c.type)) t2.get(c.type).call(u, c);
      else throw new Error("Unknown node type: " + c.type);
    }, tokenBefore: vr, token(c, a) {
      o = this.tokenBefore(o, c, a), this.emit(a, c, false), c === 9 && a.charCodeAt(0) === kl && this.emit(`
`, 13, true);
    }, emit(c) {
      i += c;
    }, result() {
      return i;
    } };
    n && (typeof n.decorator == "function" && (s = n.decorator(s)), n.sourceMap && (s = Uo(s)), n.mode in Bt && (s.tokenBefore = Bt[n.mode]));
    let u = { node: (c) => s.node(c), children: wl, token: (c, a) => s.token(c, a), tokenize: vl };
    return s.node(r), s.result();
  };
}
function Ko(e2) {
  return { fromPlainObject(t2) {
    return e2(t2, { enter(r) {
      r.children && !(r.children instanceof V) && (r.children = new V().fromArray(r.children));
    } }), t2;
  }, toPlainObject(t2) {
    return e2(t2, { leave(r) {
      r.children && r.children instanceof V && (r.children = r.children.toArray());
    } }), t2;
  } };
}
var { hasOwnProperty: Sr } = Object.prototype;
var ut = function() {
};
function Vo(e2) {
  return typeof e2 == "function" ? e2 : ut;
}
function Qo(e2, t2) {
  return function(r, n, i) {
    r.type === t2 && e2.call(this, r, n, i);
  };
}
function Sl(e2, t2) {
  let r = t2.structure, n = [];
  for (let i in r) {
    if (Sr.call(r, i) === false) continue;
    let o = r[i], s = { name: i, type: false, nullable: false };
    Array.isArray(o) || (o = [o]);
    for (let u of o) u === null ? s.nullable = true : typeof u == "string" ? s.type = "node" : Array.isArray(u) && (s.type = "list");
    s.type && n.push(s);
  }
  return n.length ? { context: t2.walkContext, fields: n } : null;
}
function Cl(e2) {
  let t2 = {};
  for (let r in e2.node) if (Sr.call(e2.node, r)) {
    let n = e2.node[r];
    if (!n.structure) throw new Error("Missed `structure` field in `" + r + "` node type definition");
    t2[r] = Sl(r, n);
  }
  return t2;
}
function Xo(e2, t2) {
  let r = e2.fields.slice(), n = e2.context, i = typeof n == "string";
  return t2 && r.reverse(), function(o, s, u, c) {
    let a;
    i && (a = s[n], s[n] = o);
    for (let l of r) {
      let p = o[l.name];
      if (!l.nullable || p) {
        if (l.type === "list") {
          if (t2 ? p.reduceRight(c, false) : p.reduce(c, false)) return true;
        } else if (u(p)) return true;
      }
    }
    i && (s[n] = a);
  };
}
function $o({ StyleSheet: e2, Atrule: t2, Rule: r, Block: n, DeclarationList: i }) {
  return { Atrule: { StyleSheet: e2, Atrule: t2, Rule: r, Block: n }, Rule: { StyleSheet: e2, Atrule: t2, Rule: r, Block: n }, Declaration: { StyleSheet: e2, Atrule: t2, Rule: r, Block: n, DeclarationList: i } };
}
function Zo(e2) {
  let t2 = Cl(e2), r = {}, n = {}, i = Symbol("break-walk"), o = Symbol("skip-node");
  for (let a in t2) Sr.call(t2, a) && t2[a] !== null && (r[a] = Xo(t2[a], false), n[a] = Xo(t2[a], true));
  let s = $o(r), u = $o(n), c = function(a, l) {
    function p(w, T, he) {
      let z = h.call(j, w, T, he);
      return z === i ? true : z === o ? false : !!(g2.hasOwnProperty(w.type) && g2[w.type](w, j, p, ee) || d.call(j, w, T, he) === i);
    }
    let h = ut, d = ut, g2 = r, ee = (w, T, he, z) => w || p(T, he, z), j = { break: i, skip: o, root: a, stylesheet: null, atrule: null, atrulePrelude: null, rule: null, selector: null, block: null, declaration: null, function: null };
    if (typeof l == "function") h = l;
    else if (l && (h = Vo(l.enter), d = Vo(l.leave), l.reverse && (g2 = n), l.visit)) {
      if (s.hasOwnProperty(l.visit)) g2 = l.reverse ? u[l.visit] : s[l.visit];
      else if (!t2.hasOwnProperty(l.visit)) throw new Error("Bad value `" + l.visit + "` for `visit` option (should be: " + Object.keys(t2).sort().join(", ") + ")");
      h = Qo(h, l.visit), d = Qo(d, l.visit);
    }
    if (h === ut && d === ut) throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function");
    p(a);
  };
  return c.break = i, c.skip = o, c.find = function(a, l) {
    let p = null;
    return c(a, function(h, d, g2) {
      if (l.call(this, h, d, g2)) return p = h, i;
    }), p;
  }, c.findLast = function(a, l) {
    let p = null;
    return c(a, { reverse: true, enter(h, d, g2) {
      if (l.call(this, h, d, g2)) return p = h, i;
    } }), p;
  }, c.findAll = function(a, l) {
    let p = [];
    return c(a, function(h, d, g2) {
      l.call(this, h, d, g2) && p.push(h);
    }), p;
  }, c;
}
function Tl(e2) {
  return e2;
}
function Al(e2) {
  let { min: t2, max: r, comma: n } = e2;
  return t2 === 0 && r === 0 ? n ? "#?" : "*" : t2 === 0 && r === 1 ? "?" : t2 === 1 && r === 0 ? n ? "#" : "+" : t2 === 1 && r === 1 ? "" : (n ? "#" : "") + (t2 === r ? "{" + t2 + "}" : "{" + t2 + "," + (r !== 0 ? r : "") + "}");
}
function Ll(e2) {
  switch (e2.type) {
    case "Range":
      return " [" + (e2.min === null ? "-\u221E" : e2.min) + "," + (e2.max === null ? "\u221E" : e2.max) + "]";
    default:
      throw new Error("Unknown node type `" + e2.type + "`");
  }
}
function El(e2, t2, r, n) {
  let i = e2.combinator === " " || n ? e2.combinator : " " + e2.combinator + " ", o = e2.terms.map((s) => _t(s, t2, r, n)).join(i);
  return e2.explicit || r ? (n || o[0] === "," ? "[" : "[ ") + o + (n ? "]" : " ]") : o;
}
function _t(e2, t2, r, n) {
  let i;
  switch (e2.type) {
    case "Group":
      i = El(e2, t2, r, n) + (e2.disallowEmpty ? "!" : "");
      break;
    case "Multiplier":
      return _t(e2.term, t2, r, n) + t2(Al(e2), e2);
    case "Boolean":
      i = "<boolean-expr[" + _t(e2.term, t2, r, n) + "]>";
      break;
    case "Type":
      i = "<" + e2.name + (e2.opts ? t2(Ll(e2.opts), e2.opts) : "") + ">";
      break;
    case "Property":
      i = "<'" + e2.name + "'>";
      break;
    case "Keyword":
      i = e2.name;
      break;
    case "AtKeyword":
      i = "@" + e2.name;
      break;
    case "Function":
      i = e2.name + "(";
      break;
    case "String":
    case "Token":
      i = e2.value;
      break;
    case "Comma":
      i = ",";
      break;
    default:
      throw new Error("Unknown node type `" + e2.type + "`");
  }
  return t2(i, e2);
}
function Oe(e2, t2) {
  let r = Tl, n = false, i = false;
  return typeof t2 == "function" ? r = t2 : t2 && (n = !!t2.forceBraces, i = !!t2.compact, typeof t2.decorate == "function" && (r = t2.decorate)), _t(e2, r, n, i);
}
var Jo = { offset: 0, line: 1, column: 1 };
function zl(e2, t2) {
  let r = e2.tokens, n = e2.longestMatch, i = n < r.length && r[n].node || null, o = i !== t2 ? i : null, s = 0, u = 0, c = 0, a = "", l, p;
  for (let h = 0; h < r.length; h++) {
    let d = r[h].value;
    h === n && (u = d.length, s = a.length), o !== null && r[h].node === o && (h <= n ? c++ : c = 0), a += d;
  }
  return n === r.length || c > 1 ? (l = Wt(o || t2, "end") || pt(Jo, a), p = pt(l)) : (l = Wt(o, "start") || pt(Wt(t2, "start") || Jo, a.slice(0, s)), p = Wt(o, "end") || pt(l, a.substr(s, u))), { css: a, mismatchOffset: s, mismatchLength: u, start: l, end: p };
}
function Wt(e2, t2) {
  let r = e2 && e2.loc && e2.loc[t2];
  return r ? "line" in r ? pt(r) : r : null;
}
function pt({ offset: e2, line: t2, column: r }, n) {
  let i = { offset: e2, line: t2, column: r };
  if (n) {
    let o = n.split(/\n|\r\n?|\f/);
    i.offset += n.length, i.line += o.length - 1, i.column = o.length === 1 ? i.column + n.length : o.pop().length + 1;
  }
  return i;
}
var Ye = function(e2, t2) {
  let r = De("SyntaxReferenceError", e2 + (t2 ? " `" + t2 + "`" : ""));
  return r.reference = t2, r;
};
var es = function(e2, t2, r, n) {
  let i = De("SyntaxMatchError", e2), { css: o, mismatchOffset: s, mismatchLength: u, start: c, end: a } = zl(n, r);
  return i.rawMessage = e2, i.syntax = t2 ? Oe(t2) : "<generic>", i.css = o, i.mismatchOffset = s, i.mismatchLength = u, i.message = e2 + `
  syntax: ` + i.syntax + `
   value: ` + (o || "<empty string>") + `
  --------` + new Array(i.mismatchOffset + 1).join("-") + "^", Object.assign(i, c), i.loc = { source: r && r.loc && r.loc.source || "<unknown>", start: c, end: a }, i;
};
var qt = /* @__PURE__ */ new Map();
var Ke = /* @__PURE__ */ new Map();
var jt = 45;
var Ut = Pl;
var Cr = Il;
function Ht(e2, t2) {
  return t2 = t2 || 0, e2.length - t2 >= 2 && e2.charCodeAt(t2) === jt && e2.charCodeAt(t2 + 1) === jt;
}
function Tr(e2, t2) {
  if (t2 = t2 || 0, e2.length - t2 >= 3 && e2.charCodeAt(t2) === jt && e2.charCodeAt(t2 + 1) !== jt) {
    let r = e2.indexOf("-", t2 + 2);
    if (r !== -1) return e2.substring(t2, r + 1);
  }
  return "";
}
function Pl(e2) {
  if (qt.has(e2)) return qt.get(e2);
  let t2 = e2.toLowerCase(), r = qt.get(t2);
  if (r === void 0) {
    let n = Ht(t2, 0), i = n ? "" : Tr(t2, 0);
    r = Object.freeze({ basename: t2.substr(i.length), name: t2, prefix: i, vendor: i, custom: n });
  }
  return qt.set(e2, r), r;
}
function Il(e2) {
  if (Ke.has(e2)) return Ke.get(e2);
  let t2 = e2, r = e2[0];
  r === "/" ? r = e2[1] === "/" ? "//" : "/" : r !== "_" && r !== "*" && r !== "$" && r !== "#" && r !== "+" && r !== "&" && (r = "");
  let n = Ht(t2, r.length);
  if (!n && (t2 = t2.toLowerCase(), Ke.has(t2))) {
    let u = Ke.get(t2);
    return Ke.set(e2, u), u;
  }
  let i = n ? "" : Tr(t2, r.length), o = t2.substr(0, r.length + i.length), s = Object.freeze({ basename: t2.substr(o.length), name: t2.substr(r.length), hack: r, vendor: i, prefix: o, custom: n });
  return Ke.set(e2, s), s;
}
var Ve = ["initial", "inherit", "unset", "revert", "revert-layer"];
var mt = 43;
var de = 45;
var Ar = 110;
var Qe = true;
var Nl = false;
function Er(e2, t2) {
  return e2 !== null && e2.type === 9 && e2.value.charCodeAt(0) === t2;
}
function ht(e2, t2, r) {
  for (; e2 !== null && (e2.type === 13 || e2.type === 25); ) e2 = r(++t2);
  return t2;
}
function Te(e2, t2, r, n) {
  if (!e2) return 0;
  let i = e2.value.charCodeAt(t2);
  if (i === mt || i === de) {
    if (r) return 0;
    t2++;
  }
  for (; t2 < e2.value.length; t2++) if (!O(e2.value.charCodeAt(t2))) return 0;
  return n + 1;
}
function Lr(e2, t2, r) {
  let n = false, i = ht(e2, t2, r);
  if (e2 = r(i), e2 === null) return t2;
  if (e2.type !== 10) if (Er(e2, mt) || Er(e2, de)) {
    if (n = true, i = ht(r(++i), i, r), e2 = r(i), e2 === null || e2.type !== 10) return 0;
  } else return t2;
  if (!n) {
    let o = e2.value.charCodeAt(0);
    if (o !== mt && o !== de) return 0;
  }
  return Te(e2, n ? 0 : 1, n, i);
}
function zr(e2, t2) {
  let r = 0;
  if (!e2) return 0;
  if (e2.type === 10) return Te(e2, 0, Nl, r);
  if (e2.type === 1 && e2.value.charCodeAt(0) === de) {
    if (!xe(e2.value, 1, Ar)) return 0;
    switch (e2.value.length) {
      case 2:
        return Lr(t2(++r), r, t2);
      case 3:
        return e2.value.charCodeAt(2) !== de ? 0 : (r = ht(t2(++r), r, t2), e2 = t2(r), Te(e2, 0, Qe, r));
      default:
        return e2.value.charCodeAt(2) !== de ? 0 : Te(e2, 3, Qe, r);
    }
  } else if (e2.type === 1 || Er(e2, mt) && t2(r + 1).type === 1) {
    if (e2.type !== 1 && (e2 = t2(++r)), e2 === null || !xe(e2.value, 0, Ar)) return 0;
    switch (e2.value.length) {
      case 1:
        return Lr(t2(++r), r, t2);
      case 2:
        return e2.value.charCodeAt(1) !== de ? 0 : (r = ht(t2(++r), r, t2), e2 = t2(r), Te(e2, 0, Qe, r));
      default:
        return e2.value.charCodeAt(1) !== de ? 0 : Te(e2, 2, Qe, r);
    }
  } else if (e2.type === 12) {
    let n = e2.value.charCodeAt(0), i = n === mt || n === de ? 1 : 0, o = i;
    for (; o < e2.value.length && O(e2.value.charCodeAt(o)); o++) ;
    return o === i || !xe(e2.value, o, Ar) ? 0 : o + 1 === e2.value.length ? Lr(t2(++r), r, t2) : e2.value.charCodeAt(o + 1) !== de ? 0 : o + 2 === e2.value.length ? (r = ht(t2(++r), r, t2), e2 = t2(r), Te(e2, 0, Qe, r)) : Te(e2, o + 2, Qe, r);
  }
  return 0;
}
var Ol = 43;
var ts = 45;
var rs = 63;
var Rl = 117;
function Pr(e2, t2) {
  return e2 !== null && e2.type === 9 && e2.value.charCodeAt(0) === t2;
}
function Fl(e2, t2) {
  return e2.value.charCodeAt(0) === t2;
}
function dt(e2, t2, r) {
  let n = 0;
  for (let i = t2; i < e2.value.length; i++) {
    let o = e2.value.charCodeAt(i);
    if (o === ts && r && n !== 0) return dt(e2, t2 + n + 1, false), 6;
    if (!J(o) || ++n > 6) return 0;
  }
  return n;
}
function Gt(e2, t2, r) {
  if (!e2) return 0;
  for (; Pr(r(t2), rs); ) {
    if (++e2 > 6) return 0;
    t2++;
  }
  return t2;
}
function Ir(e2, t2) {
  let r = 0;
  if (e2 === null || e2.type !== 1 || !xe(e2.value, 0, Rl) || (e2 = t2(++r), e2 === null)) return 0;
  if (Pr(e2, Ol)) return e2 = t2(++r), e2 === null ? 0 : e2.type === 1 ? Gt(dt(e2, 0, true), ++r, t2) : Pr(e2, rs) ? Gt(1, ++r, t2) : 0;
  if (e2.type === 10) {
    let n = dt(e2, 1, true);
    return n === 0 ? 0 : (e2 = t2(++r), e2 === null ? r : e2.type === 12 || e2.type === 10 ? !Fl(e2, ts) || !dt(e2, 1, false) ? 0 : r + 1 : Gt(n, r, t2));
  }
  return e2.type === 12 ? Gt(dt(e2, 1, true), ++r, t2) : 0;
}
var Ml = ["calc(", "-moz-calc(", "-webkit-calc("];
var Dr = /* @__PURE__ */ new Map([[2, 22], [21, 22], [19, 20], [23, 24]]);
function ue(e2, t2) {
  return t2 < e2.length ? e2.charCodeAt(t2) : 0;
}
function ns(e2, t2) {
  return ye(e2, 0, e2.length, t2);
}
function is(e2, t2) {
  for (let r = 0; r < t2.length; r++) if (ns(e2, t2[r])) return true;
  return false;
}
function os(e2, t2) {
  return t2 !== e2.length - 2 ? false : ue(e2, t2) === 92 && O(ue(e2, t2 + 1));
}
function Yt(e2, t2, r) {
  if (e2 && e2.type === "Range") {
    let n = Number(r !== void 0 && r !== t2.length ? t2.substr(0, r) : t2);
    if (isNaN(n) || e2.min !== null && n < e2.min && typeof e2.min != "string" || e2.max !== null && n > e2.max && typeof e2.max != "string") return true;
  }
  return false;
}
function Bl(e2, t2) {
  let r = 0, n = [], i = 0;
  e: do {
    switch (e2.type) {
      case 24:
      case 22:
      case 20:
        if (e2.type !== r) break e;
        if (r = n.pop(), n.length === 0) {
          i++;
          break e;
        }
        break;
      case 2:
      case 21:
      case 19:
      case 23:
        n.push(r), r = Dr.get(e2.type);
        break;
    }
    i++;
  } while (e2 = t2(i));
  return i;
}
function ie(e2) {
  return function(t2, r, n) {
    return t2 === null ? 0 : t2.type === 2 && is(t2.value, Ml) ? Bl(t2, r) : e2(t2, r, n);
  };
}
function I(e2) {
  return function(t2) {
    return t2 === null || t2.type !== e2 ? 0 : 1;
  };
}
function _l(e2) {
  if (e2 === null || e2.type !== 1) return 0;
  let t2 = e2.value.toLowerCase();
  return is(t2, Ve) || ns(t2, "default") ? 0 : 1;
}
function ss(e2) {
  return e2 === null || e2.type !== 1 || ue(e2.value, 0) !== 45 || ue(e2.value, 1) !== 45 ? 0 : 1;
}
function Wl(e2) {
  return !ss(e2) || e2.value === "--" ? 0 : 1;
}
function ql(e2) {
  if (e2 === null || e2.type !== 4) return 0;
  let t2 = e2.value.length;
  if (t2 !== 4 && t2 !== 5 && t2 !== 7 && t2 !== 9) return 0;
  for (let r = 1; r < t2; r++) if (!J(ue(e2.value, r))) return 0;
  return 1;
}
function jl(e2) {
  return e2 === null || e2.type !== 4 || !We(ue(e2.value, 1), ue(e2.value, 2), ue(e2.value, 3)) ? 0 : 1;
}
function Ul(e2, t2) {
  if (!e2) return 0;
  let r = 0, n = [], i = 0;
  e: do {
    switch (e2.type) {
      case 6:
      case 8:
        break e;
      case 24:
      case 22:
      case 20:
        if (e2.type !== r) break e;
        r = n.pop();
        break;
      case 17:
        if (r === 0) break e;
        break;
      case 9:
        if (r === 0 && e2.value === "!") break e;
        break;
      case 2:
      case 21:
      case 19:
      case 23:
        n.push(r), r = Dr.get(e2.type);
        break;
    }
    i++;
  } while (e2 = t2(i));
  return i;
}
function Hl(e2, t2) {
  if (!e2) return 0;
  let r = 0, n = [], i = 0;
  e: do {
    switch (e2.type) {
      case 6:
      case 8:
        break e;
      case 24:
      case 22:
      case 20:
        if (e2.type !== r) break e;
        r = n.pop();
        break;
      case 2:
      case 21:
      case 19:
      case 23:
        n.push(r), r = Dr.get(e2.type);
        break;
    }
    i++;
  } while (e2 = t2(i));
  return i;
}
function ve(e2) {
  return e2 && (e2 = new Set(e2)), function(t2, r, n) {
    if (t2 === null || t2.type !== 12) return 0;
    let i = Pe(t2.value, 0);
    if (e2 !== null) {
      let o = t2.value.indexOf("\\", i), s = o === -1 || !os(t2.value, o) ? t2.value.substr(i) : t2.value.substring(i, o);
      if (e2.has(s.toLowerCase()) === false) return 0;
    }
    return Yt(n, t2.value, i) ? 0 : 1;
  };
}
function Gl(e2, t2, r) {
  return e2 === null || e2.type !== 11 || Yt(r, e2.value, e2.value.length - 1) ? 0 : 1;
}
function as(e2) {
  return typeof e2 != "function" && (e2 = function() {
    return 0;
  }), function(t2, r, n) {
    return t2 !== null && t2.type === 10 && Number(t2.value) === 0 ? 1 : e2(t2, r, n);
  };
}
function Yl(e2, t2, r) {
  if (e2 === null) return 0;
  let n = Pe(e2.value, 0);
  return !(n === e2.value.length) && !os(e2.value, n) || Yt(r, e2.value, n) ? 0 : 1;
}
function Kl(e2, t2, r) {
  if (e2 === null || e2.type !== 10) return 0;
  let n = ue(e2.value, 0) === 43 || ue(e2.value, 0) === 45 ? 1 : 0;
  for (; n < e2.value.length; n++) if (!O(ue(e2.value, n))) return 0;
  return Yt(r, e2.value, n) ? 0 : 1;
}
var Vl = { "ident-token": I(1), "function-token": I(2), "at-keyword-token": I(3), "hash-token": I(4), "string-token": I(5), "bad-string-token": I(6), "url-token": I(7), "bad-url-token": I(8), "delim-token": I(9), "number-token": I(10), "percentage-token": I(11), "dimension-token": I(12), "whitespace-token": I(13), "CDO-token": I(14), "CDC-token": I(15), "colon-token": I(16), "semicolon-token": I(17), "comma-token": I(18), "[-token": I(19), "]-token": I(20), "(-token": I(21), ")-token": I(22), "{-token": I(23), "}-token": I(24) };
var Ql = { string: I(5), ident: I(1), percentage: ie(Gl), zero: as(), number: ie(Yl), integer: ie(Kl), "custom-ident": _l, "dashed-ident": ss, "custom-property-name": Wl, "hex-color": ql, "id-selector": jl, "an-plus-b": zr, urange: Ir, "declaration-value": Ul, "any-value": Hl };
function Xl(e2) {
  let { angle: t2, decibel: r, frequency: n, flex: i, length: o, resolution: s, semitones: u, time: c } = e2 || {};
  return { dimension: ie(ve(null)), angle: ie(ve(t2)), decibel: ie(ve(r)), frequency: ie(ve(n)), flex: ie(ve(i)), length: ie(as(ve(o))), resolution: ie(ve(s)), semitones: ie(ve(u)), time: ie(ve(c)) };
}
function ls(e2) {
  return { ...Vl, ...Ql, ...Xl(e2) };
}
var Kt = {};
f(Kt, { angle: () => Zl, decibel: () => nc, flex: () => rc, frequency: () => ec, length: () => $l, resolution: () => tc, semitones: () => ic, time: () => Jl });
var $l = ["cm", "mm", "q", "in", "pt", "pc", "px", "em", "rem", "ex", "rex", "cap", "rcap", "ch", "rch", "ic", "ric", "lh", "rlh", "vw", "svw", "lvw", "dvw", "vh", "svh", "lvh", "dvh", "vi", "svi", "lvi", "dvi", "vb", "svb", "lvb", "dvb", "vmin", "svmin", "lvmin", "dvmin", "vmax", "svmax", "lvmax", "dvmax", "cqw", "cqh", "cqi", "cqb", "cqmin", "cqmax"];
var Zl = ["deg", "grad", "rad", "turn"];
var Jl = ["s", "ms"];
var ec = ["hz", "khz"];
var tc = ["dpi", "dpcm", "dppx", "x"];
var rc = ["fr"];
var nc = ["db"];
var ic = ["st"];
var ws = {};
f(ws, { SyntaxError: () => Vt, generate: () => Oe, parse: () => Xe, walk: () => Zt });
function Vt(e2, t2, r) {
  return Object.assign(De("SyntaxError", e2), { input: t2, offset: r, rawMessage: e2, message: e2 + `
  ` + t2 + `
--` + new Array((r || t2.length) + 1).join("-") + "^" });
}
var oc = 9;
var sc = 10;
var ac = 12;
var lc = 13;
var cc = 32;
var cs = new Uint8Array(128).map((e2, t2) => /[a-zA-Z0-9\-]/.test(String.fromCharCode(t2)) ? 1 : 0);
var Qt = class {
  constructor(t2) {
    this.str = t2, this.pos = 0;
  }
  charCodeAt(t2) {
    return t2 < this.str.length ? this.str.charCodeAt(t2) : 0;
  }
  charCode() {
    return this.charCodeAt(this.pos);
  }
  isNameCharCode(t2 = this.charCode()) {
    return t2 < 128 && cs[t2] === 1;
  }
  nextCharCode() {
    return this.charCodeAt(this.pos + 1);
  }
  nextNonWsCode(t2) {
    return this.charCodeAt(this.findWsEnd(t2));
  }
  skipWs() {
    this.pos = this.findWsEnd(this.pos);
  }
  findWsEnd(t2) {
    for (; t2 < this.str.length; t2++) {
      let r = this.str.charCodeAt(t2);
      if (r !== lc && r !== sc && r !== ac && r !== cc && r !== oc) break;
    }
    return t2;
  }
  substringToPos(t2) {
    return this.str.substring(this.pos, this.pos = t2);
  }
  eat(t2) {
    this.charCode() !== t2 && this.error("Expect `" + String.fromCharCode(t2) + "`"), this.pos++;
  }
  peek() {
    return this.pos < this.str.length ? this.str.charAt(this.pos++) : "";
  }
  error(t2) {
    throw new Vt(t2, this.str, this.pos);
  }
  scanSpaces() {
    return this.substringToPos(this.findWsEnd(this.pos));
  }
  scanWord() {
    let t2 = this.pos;
    for (; t2 < this.str.length; t2++) {
      let r = this.str.charCodeAt(t2);
      if (r >= 128 || cs[r] === 0) break;
    }
    return this.pos === t2 && this.error("Expect a keyword"), this.substringToPos(t2);
  }
  scanNumber() {
    let t2 = this.pos;
    for (; t2 < this.str.length; t2++) {
      let r = this.str.charCodeAt(t2);
      if (r < 48 || r > 57) break;
    }
    return this.pos === t2 && this.error("Expect a number"), this.substringToPos(t2);
  }
  scanString() {
    let t2 = this.str.indexOf("'", this.pos + 1);
    return t2 === -1 && (this.pos = this.str.length, this.error("Expect an apostrophe")), this.substringToPos(t2 + 1);
  }
};
var uc = 9;
var pc = 10;
var hc = 12;
var mc = 13;
var dc = 32;
var bs = 33;
var Fr = 35;
var us = 38;
var Xt = 39;
var xs = 40;
var fc = 41;
var ys = 42;
var Mr = 43;
var Br = 44;
var ps = 45;
var _r = 60;
var Or = 62;
var Rr = 63;
var gc = 64;
var ft = 91;
var gt = 93;
var $t = 123;
var hs = 124;
var ms = 125;
var ds = 8734;
var fs2 = { " ": 1, "&&": 2, "||": 3, "|": 4 };
function gs(e2) {
  let t2 = null, r = null;
  return e2.eat($t), e2.skipWs(), t2 = e2.scanNumber(e2), e2.skipWs(), e2.charCode() === Br ? (e2.pos++, e2.skipWs(), e2.charCode() !== ms && (r = e2.scanNumber(e2), e2.skipWs())) : r = t2, e2.eat(ms), { min: Number(t2), max: r ? Number(r) : 0 };
}
function bc(e2) {
  let t2 = null, r = false;
  switch (e2.charCode()) {
    case ys:
      e2.pos++, t2 = { min: 0, max: 0 };
      break;
    case Mr:
      e2.pos++, t2 = { min: 1, max: 0 };
      break;
    case Rr:
      e2.pos++, t2 = { min: 0, max: 1 };
      break;
    case Fr:
      e2.pos++, r = true, e2.charCode() === $t ? t2 = gs(e2) : e2.charCode() === Rr ? (e2.pos++, t2 = { min: 0, max: 0 }) : t2 = { min: 1, max: 0 };
      break;
    case $t:
      t2 = gs(e2);
      break;
    default:
      return null;
  }
  return { type: "Multiplier", comma: r, min: t2.min, max: t2.max, term: null };
}
function Ae(e2, t2) {
  let r = bc(e2);
  return r !== null ? (r.term = t2, e2.charCode() === Fr && e2.charCodeAt(e2.pos - 1) === Mr ? Ae(e2, r) : r) : t2;
}
function Nr(e2) {
  let t2 = e2.peek();
  return t2 === "" ? null : Ae(e2, { type: "Token", value: t2 });
}
function xc(e2) {
  let t2;
  return e2.eat(_r), e2.eat(Xt), t2 = e2.scanWord(), e2.eat(Xt), e2.eat(Or), Ae(e2, { type: "Property", name: t2 });
}
function yc(e2) {
  let t2 = null, r = null, n = 1;
  return e2.eat(ft), e2.charCode() === ps && (e2.peek(), n = -1), n == -1 && e2.charCode() === ds ? e2.peek() : (t2 = n * Number(e2.scanNumber(e2)), e2.isNameCharCode() && (t2 += e2.scanWord())), e2.skipWs(), e2.eat(Br), e2.skipWs(), e2.charCode() === ds ? e2.peek() : (n = 1, e2.charCode() === ps && (e2.peek(), n = -1), r = n * Number(e2.scanNumber(e2)), e2.isNameCharCode() && (r += e2.scanWord())), e2.eat(gt), { type: "Range", min: t2, max: r };
}
function kc(e2) {
  let t2, r = null;
  if (e2.eat(_r), t2 = e2.scanWord(), t2 === "boolean-expr") {
    e2.eat(ft);
    let n = Wr(e2, gt);
    return e2.eat(gt), e2.eat(Or), Ae(e2, { type: "Boolean", term: n.terms.length === 1 ? n.terms[0] : n });
  }
  return e2.charCode() === xs && e2.nextCharCode() === fc && (e2.pos += 2, t2 += "()"), e2.charCodeAt(e2.findWsEnd(e2.pos)) === ft && (e2.skipWs(), r = yc(e2)), e2.eat(Or), Ae(e2, { type: "Type", name: t2, opts: r });
}
function wc(e2) {
  let t2 = e2.scanWord();
  return e2.charCode() === xs ? (e2.pos++, { type: "Function", name: t2 }) : Ae(e2, { type: "Keyword", name: t2 });
}
function vc(e2, t2) {
  function r(i, o) {
    return { type: "Group", terms: i, combinator: o, disallowEmpty: false, explicit: false };
  }
  let n;
  for (t2 = Object.keys(t2).sort((i, o) => fs2[i] - fs2[o]); t2.length > 0; ) {
    n = t2.shift();
    let i = 0, o = 0;
    for (; i < e2.length; i++) {
      let s = e2[i];
      s.type === "Combinator" && (s.value === n ? (o === -1 && (o = i - 1), e2.splice(i, 1), i--) : (o !== -1 && i - o > 1 && (e2.splice(o, i - o, r(e2.slice(o, i), n)), i = o + 1), o = -1));
    }
    o !== -1 && t2.length && e2.splice(o, i - o, r(e2.slice(o, i), n));
  }
  return n;
}
function Wr(e2, t2) {
  let r = /* @__PURE__ */ Object.create(null), n = [], i, o = null, s = e2.pos;
  for (; e2.charCode() !== t2 && (i = Cc(e2, t2)); ) i.type !== "Spaces" && (i.type === "Combinator" ? ((o === null || o.type === "Combinator") && (e2.pos = s, e2.error("Unexpected combinator")), r[i.value] = true) : o !== null && o.type !== "Combinator" && (r[" "] = true, n.push({ type: "Combinator", value: " " })), n.push(i), o = i, s = e2.pos);
  return o !== null && o.type === "Combinator" && (e2.pos -= s, e2.error("Unexpected combinator")), { type: "Group", terms: n, combinator: vc(n, r) || " ", disallowEmpty: false, explicit: false };
}
function Sc(e2, t2) {
  let r;
  return e2.eat(ft), r = Wr(e2, t2), e2.eat(gt), r.explicit = true, e2.charCode() === bs && (e2.pos++, r.disallowEmpty = true), r;
}
function Cc(e2, t2) {
  let r = e2.charCode();
  switch (r) {
    case gt:
      break;
    case ft:
      return Ae(e2, Sc(e2, t2));
    case _r:
      return e2.nextCharCode() === Xt ? xc(e2) : kc(e2);
    case hs:
      return { type: "Combinator", value: e2.substringToPos(e2.pos + (e2.nextCharCode() === hs ? 2 : 1)) };
    case us:
      return e2.pos++, e2.eat(us), { type: "Combinator", value: "&&" };
    case Br:
      return e2.pos++, { type: "Comma" };
    case Xt:
      return Ae(e2, { type: "String", value: e2.scanString() });
    case dc:
    case uc:
    case pc:
    case mc:
    case hc:
      return { type: "Spaces", value: e2.scanSpaces() };
    case gc:
      return r = e2.nextCharCode(), e2.isNameCharCode(r) ? (e2.pos++, { type: "AtKeyword", name: e2.scanWord() }) : Nr(e2);
    case ys:
    case Mr:
    case Rr:
    case Fr:
    case bs:
      break;
    case $t:
      if (r = e2.nextCharCode(), r < 48 || r > 57) return Nr(e2);
      break;
    default:
      return e2.isNameCharCode(r) ? wc(e2) : Nr(e2);
  }
}
function Xe(e2) {
  let t2 = new Qt(e2), r = Wr(t2);
  return t2.pos !== e2.length && t2.error("Unexpected input"), r.terms.length === 1 && r.terms[0].type === "Group" ? r.terms[0] : r;
}
var bt = function() {
};
function ks(e2) {
  return typeof e2 == "function" ? e2 : bt;
}
function Zt(e2, t2, r) {
  function n(s) {
    switch (i.call(r, s), s.type) {
      case "Group":
        s.terms.forEach(n);
        break;
      case "Multiplier":
      case "Boolean":
        n(s.term);
        break;
      case "Type":
      case "Property":
      case "Keyword":
      case "AtKeyword":
      case "Function":
      case "String":
      case "Token":
      case "Comma":
        break;
      default:
        throw new Error("Unknown type: " + s.type);
    }
    o.call(r, s);
  }
  let i = bt, o = bt;
  if (typeof t2 == "function" ? i = t2 : t2 && (i = ks(t2.enter), o = ks(t2.leave)), i === bt && o === bt) throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function");
  n(e2, r);
}
var Tc = { decorator(e2) {
  let t2 = [], r = null;
  return { ...e2, node(n) {
    let i = r;
    r = n, e2.node.call(this, n), r = i;
  }, emit(n, i, o) {
    t2.push({ type: i, value: n, node: o ? null : r });
  }, result() {
    return t2;
  } };
} };
function Ac(e2) {
  let t2 = [];
  return Ce(e2, (r, n, i) => t2.push({ type: r, value: e2.slice(n, i), node: null })), t2;
}
function vs(e2, t2) {
  return typeof e2 == "string" ? Ac(e2) : t2.generate(e2, Tc);
}
var C = { type: "Match" };
var E = { type: "Mismatch" };
var Jt = { type: "DisallowEmpty" };
var Lc = 40;
var Ec = 41;
function Q(e2, t2, r) {
  return t2 === C && r === E || e2 === C && t2 === C && r === C ? e2 : (e2.type === "If" && e2.else === E && t2 === C && (t2 = e2.then, e2 = e2.match), { type: "If", match: e2, then: t2, else: r });
}
function Cs(e2) {
  return e2.length > 2 && e2.charCodeAt(e2.length - 2) === Lc && e2.charCodeAt(e2.length - 1) === Ec;
}
function Ss(e2) {
  return e2.type === "Keyword" || e2.type === "AtKeyword" || e2.type === "Function" || e2.type === "Type" && Cs(e2.name);
}
function Le(e2, t2 = " ", r = false) {
  return { type: "Group", terms: e2, combinator: t2, disallowEmpty: false, explicit: r };
}
function xt(e2, t2, r = /* @__PURE__ */ new Set()) {
  if (!r.has(e2)) switch (r.add(e2), e2.type) {
    case "If":
      e2.match = xt(e2.match, t2, r), e2.then = xt(e2.then, t2, r), e2.else = xt(e2.else, t2, r);
      break;
    case "Type":
      return t2[e2.name] || e2;
  }
  return e2;
}
function qr(e2, t2, r) {
  switch (e2) {
    case " ": {
      let n = C;
      for (let i = t2.length - 1; i >= 0; i--) {
        let o = t2[i];
        n = Q(o, n, E);
      }
      return n;
    }
    case "|": {
      let n = E, i = null;
      for (let o = t2.length - 1; o >= 0; o--) {
        let s = t2[o];
        if (Ss(s) && (i === null && o > 0 && Ss(t2[o - 1]) && (i = /* @__PURE__ */ Object.create(null), n = Q({ type: "Enum", map: i }, C, n)), i !== null)) {
          let u = (Cs(s.name) ? s.name.slice(0, -1) : s.name).toLowerCase();
          if (!(u in i)) {
            i[u] = s;
            continue;
          }
        }
        i = null, n = Q(s, C, n);
      }
      return n;
    }
    case "&&": {
      if (t2.length > 5) return { type: "MatchOnce", terms: t2, all: true };
      let n = E;
      for (let i = t2.length - 1; i >= 0; i--) {
        let o = t2[i], s;
        t2.length > 1 ? s = qr(e2, t2.filter(function(u) {
          return u !== o;
        }), false) : s = C, n = Q(o, s, n);
      }
      return n;
    }
    case "||": {
      if (t2.length > 5) return { type: "MatchOnce", terms: t2, all: false };
      let n = r ? C : E;
      for (let i = t2.length - 1; i >= 0; i--) {
        let o = t2[i], s;
        t2.length > 1 ? s = qr(e2, t2.filter(function(u) {
          return u !== o;
        }), true) : s = C, n = Q(o, s, n);
      }
      return n;
    }
  }
}
function zc(e2) {
  let t2 = C, r = $e(e2.term);
  if (e2.max === 0) r = Q(r, Jt, E), t2 = Q(r, null, E), t2.then = Q(C, C, t2), e2.comma && (t2.then.else = Q({ type: "Comma", syntax: e2 }, t2, E));
  else for (let n = e2.min || 1; n <= e2.max; n++) e2.comma && t2 !== C && (t2 = Q({ type: "Comma", syntax: e2 }, t2, E)), t2 = Q(r, Q(C, C, t2), E);
  if (e2.min === 0) t2 = Q(C, C, t2);
  else for (let n = 0; n < e2.min - 1; n++) e2.comma && t2 !== C && (t2 = Q({ type: "Comma", syntax: e2 }, t2, E)), t2 = Q(r, t2, E);
  return t2;
}
function $e(e2) {
  if (typeof e2 == "function") return { type: "Generic", fn: e2 };
  switch (e2.type) {
    case "Group": {
      let t2 = qr(e2.combinator, e2.terms.map($e), false);
      return e2.disallowEmpty && (t2 = Q(t2, Jt, E)), t2;
    }
    case "Multiplier":
      return zc(e2);
    case "Boolean": {
      let t2 = $e(e2.term), r = $e(Le([Le([{ type: "Keyword", name: "not" }, { type: "Type", name: "!boolean-group" }]), Le([{ type: "Type", name: "!boolean-group" }, Le([{ type: "Multiplier", comma: false, min: 0, max: 0, term: Le([{ type: "Keyword", name: "and" }, { type: "Type", name: "!boolean-group" }]) }, { type: "Multiplier", comma: false, min: 0, max: 0, term: Le([{ type: "Keyword", name: "or" }, { type: "Type", name: "!boolean-group" }]) }], "|")])], "|")), n = $e(Le([{ type: "Type", name: "!term" }, Le([{ type: "Token", value: "(" }, { type: "Type", name: "!self" }, { type: "Token", value: ")" }]), { type: "Type", name: "general-enclosed" }], "|"));
      return xt(n, { "!term": t2, "!self": r }), xt(r, { "!boolean-group": n }), r;
    }
    case "Type":
    case "Property":
      return { type: e2.type, name: e2.name, syntax: e2 };
    case "Keyword":
      return { type: e2.type, name: e2.name.toLowerCase(), syntax: e2 };
    case "AtKeyword":
      return { type: e2.type, name: "@" + e2.name.toLowerCase(), syntax: e2 };
    case "Function":
      return { type: e2.type, name: e2.name.toLowerCase() + "(", syntax: e2 };
    case "String":
      return e2.value.length === 3 ? { type: "Token", value: e2.value.charAt(1), syntax: e2 } : { type: e2.type, value: e2.value.substr(1, e2.value.length - 2).replace(/\\'/g, "'"), syntax: e2 };
    case "Token":
      return { type: e2.type, value: e2.value, syntax: e2 };
    case "Comma":
      return { type: e2.type, syntax: e2 };
    default:
      throw new Error("Unknown node type:", e2.type);
  }
}
function yt(e2, t2) {
  return typeof e2 == "string" && (e2 = Xe(e2)), { type: "MatchGraph", match: $e(e2), syntax: t2 || null, source: e2 };
}
var { hasOwnProperty: Ts } = Object.prototype;
var Pc = 0;
var Ic = 1;
var Ur = 2;
var Ps = 3;
var As = "Match";
var Dc = "Mismatch";
var Nc = "Maximum iteration number exceeded (please fill an issue on https://github.com/csstree/csstree/issues)";
var Ls = 15e3;
var Oc = 0;
function Rc(e2) {
  let t2 = null, r = null, n = e2;
  for (; n !== null; ) r = n.prev, n.prev = t2, t2 = n, n = r;
  return t2;
}
function jr(e2, t2) {
  if (e2.length !== t2.length) return false;
  for (let r = 0; r < e2.length; r++) {
    let n = t2.charCodeAt(r), i = e2.charCodeAt(r);
    if (i >= 65 && i <= 90 && (i = i | 32), i !== n) return false;
  }
  return true;
}
function Fc(e2) {
  return e2.type !== 9 ? false : e2.value !== "?";
}
function Es(e2) {
  return e2 === null ? true : e2.type === 18 || e2.type === 2 || e2.type === 21 || e2.type === 19 || e2.type === 23 || Fc(e2);
}
function zs(e2) {
  return e2 === null ? true : e2.type === 22 || e2.type === 20 || e2.type === 24 || e2.type === 9 && e2.value === "/";
}
function Mc(e2, t2, r) {
  function n() {
    do
      T++, w = T < e2.length ? e2[T] : null;
    while (w !== null && (w.type === 13 || w.type === 25));
  }
  function i(oe) {
    let ge = T + oe;
    return ge < e2.length ? e2[ge] : null;
  }
  function o(oe, ge) {
    return { nextState: oe, matchStack: z, syntaxStack: p, thenStack: h, tokenIndex: T, prev: ge };
  }
  function s(oe) {
    h = { nextState: oe, matchStack: z, syntaxStack: p, prev: h };
  }
  function u(oe) {
    d = o(oe, d);
  }
  function c() {
    z = { type: Ic, syntax: t2.syntax, token: w, prev: z }, n(), g2 = null, T > he && (he = T);
  }
  function a() {
    p = { syntax: t2.syntax, opts: t2.syntax.opts || p !== null && p.opts || null, prev: p }, z = { type: Ur, syntax: t2.syntax, token: z.token, prev: z };
  }
  function l() {
    z.type === Ur ? z = z.prev : z = { type: Ps, syntax: p.syntax, token: z.token, prev: z }, p = p.prev;
  }
  let p = null, h = null, d = null, g2 = null, ee = 0, j = null, w = null, T = -1, he = 0, z = { type: Pc, syntax: null, token: null, prev: null };
  for (n(); j === null && ++ee < Ls; ) switch (t2.type) {
    case "Match":
      if (h === null) {
        if (w !== null && (T !== e2.length - 1 || w.value !== "\\0" && w.value !== "\\9")) {
          t2 = E;
          break;
        }
        j = As;
        break;
      }
      if (t2 = h.nextState, t2 === Jt) if (h.matchStack === z) {
        t2 = E;
        break;
      } else t2 = C;
      for (; h.syntaxStack !== p; ) l();
      h = h.prev;
      break;
    case "Mismatch":
      if (g2 !== null && g2 !== false) (d === null || T > d.tokenIndex) && (d = g2, g2 = false);
      else if (d === null) {
        j = Dc;
        break;
      }
      t2 = d.nextState, h = d.thenStack, p = d.syntaxStack, z = d.matchStack, T = d.tokenIndex, w = T < e2.length ? e2[T] : null, d = d.prev;
      break;
    case "MatchGraph":
      t2 = t2.match;
      break;
    case "If":
      t2.else !== E && u(t2.else), t2.then !== C && s(t2.then), t2 = t2.match;
      break;
    case "MatchOnce":
      t2 = { type: "MatchOnceBuffer", syntax: t2, index: 0, mask: 0 };
      break;
    case "MatchOnceBuffer": {
      let q = t2.syntax.terms;
      if (t2.index === q.length) {
        if (t2.mask === 0 || t2.syntax.all) {
          t2 = E;
          break;
        }
        t2 = C;
        break;
      }
      if (t2.mask === (1 << q.length) - 1) {
        t2 = C;
        break;
      }
      for (; t2.index < q.length; t2.index++) {
        let U = 1 << t2.index;
        if (!(t2.mask & U)) {
          u(t2), s({ type: "AddMatchOnce", syntax: t2.syntax, mask: t2.mask | U }), t2 = q[t2.index++];
          break;
        }
      }
      break;
    }
    case "AddMatchOnce":
      t2 = { type: "MatchOnceBuffer", syntax: t2.syntax, index: 0, mask: t2.mask };
      break;
    case "Enum":
      if (w !== null) {
        let q = w.value.toLowerCase();
        if (q.indexOf("\\") !== -1 && (q = q.replace(/\\[09].*$/, "")), Ts.call(t2.map, q)) {
          t2 = t2.map[q];
          break;
        }
      }
      t2 = E;
      break;
    case "Generic": {
      let q = p !== null ? p.opts : null, U = T + Math.floor(t2.fn(w, i, q));
      if (!isNaN(U) && U > T) {
        for (; T < U; ) c();
        t2 = C;
      } else t2 = E;
      break;
    }
    case "Type":
    case "Property": {
      let q = t2.type === "Type" ? "types" : "properties", U = Ts.call(r, q) ? r[q][t2.name] : null;
      if (!U || !U.match) throw new Error("Bad syntax reference: " + (t2.type === "Type" ? "<" + t2.name + ">" : "<'" + t2.name + "'>"));
      if (g2 !== false && w !== null && t2.type === "Type" && (t2.name === "custom-ident" && w.type === 1 || t2.name === "length" && w.value === "0")) {
        g2 === null && (g2 = o(t2, d)), t2 = E;
        break;
      }
      a(), t2 = U.matchRef || U.match;
      break;
    }
    case "Keyword": {
      let q = t2.name;
      if (w !== null) {
        let U = w.value;
        if (U.indexOf("\\") !== -1 && (U = U.replace(/\\[09].*$/, "")), jr(U, q)) {
          c(), t2 = C;
          break;
        }
      }
      t2 = E;
      break;
    }
    case "AtKeyword":
    case "Function":
      if (w !== null && jr(w.value, t2.name)) {
        c(), t2 = C;
        break;
      }
      t2 = E;
      break;
    case "Token":
      if (w !== null && w.value === t2.value) {
        c(), t2 = C;
        break;
      }
      t2 = E;
      break;
    case "Comma":
      w !== null && w.type === 18 ? Es(z.token) ? t2 = E : (c(), t2 = zs(w) ? E : C) : t2 = Es(z.token) || zs(w) ? C : E;
      break;
    case "String":
      let oe = "", ge = T;
      for (; ge < e2.length && oe.length < t2.value.length; ge++) oe += e2[ge].value;
      if (jr(oe, t2.value)) {
        for (; T < ge; ) c();
        t2 = C;
      } else t2 = E;
      break;
    default:
      throw new Error("Unknown node type: " + t2.type);
  }
  switch (Oc += ee, j) {
    case null:
      console.warn("[csstree-match] BREAK after " + Ls + " iterations"), j = Nc, z = null;
      break;
    case As:
      for (; p !== null; ) l();
      break;
    default:
      z = null;
  }
  return { tokens: e2, reason: j, iterations: ee, match: z, longestMatch: he };
}
function Hr(e2, t2, r) {
  let n = Mc(e2, t2, r || {});
  if (n.match === null) return n;
  let i = n.match, o = n.match = { syntax: t2.syntax || null, match: [] }, s = [o];
  for (i = Rc(i).prev; i !== null; ) {
    switch (i.type) {
      case Ur:
        o.match.push(o = { syntax: i.syntax, match: [] }), s.push(o);
        break;
      case Ps:
        s.pop(), o = s[s.length - 1];
        break;
      default:
        o.match.push({ syntax: i.syntax || null, token: i.token.value, node: i.token.node });
    }
    i = i.prev;
  }
  return n;
}
var Yr = {};
f(Yr, { getTrace: () => Is, isKeyword: () => Wc, isProperty: () => _c, isType: () => Bc });
function Is(e2) {
  function t2(i) {
    return i === null ? false : i.type === "Type" || i.type === "Property" || i.type === "Keyword";
  }
  function r(i) {
    if (Array.isArray(i.match)) {
      for (let o = 0; o < i.match.length; o++) if (r(i.match[o])) return t2(i.syntax) && n.unshift(i.syntax), true;
    } else if (i.node === e2) return n = t2(i.syntax) ? [i.syntax] : [], true;
    return false;
  }
  let n = null;
  return this.matched !== null && r(this.matched), n;
}
function Bc(e2, t2) {
  return Gr(this, e2, (r) => r.type === "Type" && r.name === t2);
}
function _c(e2, t2) {
  return Gr(this, e2, (r) => r.type === "Property" && r.name === t2);
}
function Wc(e2) {
  return Gr(this, e2, (t2) => t2.type === "Keyword");
}
function Gr(e2, t2, r) {
  let n = Is.call(e2, t2);
  return n === null ? false : n.some(r);
}
function Ds(e2) {
  return "node" in e2 ? e2.node : Ds(e2.match[0]);
}
function Ns(e2) {
  return "node" in e2 ? e2.node : Ns(e2.match[e2.match.length - 1]);
}
function Kr(e2, t2, r, n, i) {
  function o(u) {
    if (u.syntax !== null && u.syntax.type === n && u.syntax.name === i) {
      let c = Ds(u), a = Ns(u);
      e2.syntax.walk(t2, function(l, p, h) {
        if (l === c) {
          let d = new V();
          do {
            if (d.appendData(p.data), p.data === a) break;
            p = p.next;
          } while (p !== null);
          s.push({ parent: h, nodes: d });
        }
      });
    }
    Array.isArray(u.match) && u.match.forEach(o);
  }
  let s = [];
  return r.matched !== null && o(r.matched), s;
}
var { hasOwnProperty: kt } = Object.prototype;
function Vr(e2) {
  return typeof e2 == "number" && isFinite(e2) && Math.floor(e2) === e2 && e2 >= 0;
}
function Os(e2) {
  return !!e2 && Vr(e2.offset) && Vr(e2.line) && Vr(e2.column);
}
function qc(e2, t2) {
  return function(n, i) {
    if (!n || n.constructor !== Object) return i(n, "Type of node should be an Object");
    for (let o in n) {
      let s = true;
      if (kt.call(n, o) !== false) {
        if (o === "type") n.type !== e2 && i(n, "Wrong node type `" + n.type + "`, expected `" + e2 + "`");
        else if (o === "loc") {
          if (n.loc === null) continue;
          if (n.loc && n.loc.constructor === Object) if (typeof n.loc.source != "string") o += ".source";
          else if (!Os(n.loc.start)) o += ".start";
          else if (!Os(n.loc.end)) o += ".end";
          else continue;
          s = false;
        } else if (t2.hasOwnProperty(o)) {
          s = false;
          for (let u = 0; !s && u < t2[o].length; u++) {
            let c = t2[o][u];
            switch (c) {
              case String:
                s = typeof n[o] == "string";
                break;
              case Boolean:
                s = typeof n[o] == "boolean";
                break;
              case null:
                s = n[o] === null;
                break;
              default:
                typeof c == "string" ? s = n[o] && n[o].type === c : Array.isArray(c) && (s = n[o] instanceof V);
            }
          }
        } else i(n, "Unknown field `" + o + "` for " + e2 + " node type");
        s || i(n, "Bad value for `" + e2 + "." + o + "`");
      }
    }
    for (let o in t2) kt.call(t2, o) && kt.call(n, o) === false && i(n, "Field `" + e2 + "." + o + "` is missed");
  };
}
function Rs(e2, t2) {
  let r = [];
  for (let n = 0; n < e2.length; n++) {
    let i = e2[n];
    if (i === String || i === Boolean) r.push(i.name.toLowerCase());
    else if (i === null) r.push("null");
    else if (typeof i == "string") r.push(i);
    else if (Array.isArray(i)) r.push("List<" + (Rs(i, t2) || "any") + ">");
    else throw new Error("Wrong value `" + i + "` in `" + t2 + "` structure definition");
  }
  return r.join(" | ");
}
function jc(e2, t2) {
  let r = t2.structure, n = { type: String, loc: true }, i = { type: '"' + e2 + '"' };
  for (let o in r) {
    if (kt.call(r, o) === false) continue;
    let s = n[o] = Array.isArray(r[o]) ? r[o].slice() : [r[o]];
    i[o] = Rs(s, e2 + "." + o);
  }
  return { docs: i, check: qc(e2, n) };
}
function Fs(e2) {
  let t2 = {};
  if (e2.node) {
    for (let r in e2.node) if (kt.call(e2.node, r)) {
      let n = e2.node[r];
      if (n.structure) t2[r] = jc(r, n);
      else throw new Error("Missed `structure` field in `" + r + "` node type definition");
    }
  }
  return t2;
}
function Qr(e2, t2, r) {
  let n = {};
  for (let i in e2) e2[i].syntax && (n[i] = r ? e2[i].syntax : Oe(e2[i].syntax, { compact: t2 }));
  return n;
}
function Uc(e2, t2, r) {
  let n = {};
  for (let [i, o] of Object.entries(e2)) n[i] = { prelude: o.prelude && (r ? o.prelude.syntax : Oe(o.prelude.syntax, { compact: t2 })), descriptors: o.descriptors && Qr(o.descriptors, t2, r) };
  return n;
}
function Hc(e2) {
  for (let t2 = 0; t2 < e2.length; t2++) if (e2[t2].value.toLowerCase() === "var(") return true;
  return false;
}
function Gc(e2) {
  let t2 = e2.terms[0];
  return e2.explicit === false && e2.terms.length === 1 && t2.type === "Multiplier" && t2.comma === true;
}
function pe(e2, t2, r) {
  return { matched: e2, iterations: r, error: t2, ...Yr };
}
function Ze(e2, t2, r, n) {
  let i = vs(r, e2.syntax), o;
  return Hc(i) ? pe(null, new Error("Matching for a tree with var() is not supported")) : (n && (o = Hr(i, e2.cssWideKeywordsSyntax, e2)), (!n || !o.match) && (o = Hr(i, t2.match, e2), !o.match) ? pe(null, new es(o.reason, t2.syntax, r, o), o.iterations) : pe(o.match, null, o.iterations));
}
var Je = class {
  constructor(t2, r, n) {
    if (this.cssWideKeywords = Ve, this.syntax = r, this.generic = false, this.units = { ...Kt }, this.atrules = /* @__PURE__ */ Object.create(null), this.properties = /* @__PURE__ */ Object.create(null), this.types = /* @__PURE__ */ Object.create(null), this.structure = n || Fs(t2), t2) {
      if (t2.cssWideKeywords && (this.cssWideKeywords = t2.cssWideKeywords), t2.units) for (let i of Object.keys(Kt)) Array.isArray(t2.units[i]) && (this.units[i] = t2.units[i]);
      if (t2.types) for (let [i, o] of Object.entries(t2.types)) this.addType_(i, o);
      if (t2.generic) {
        this.generic = true;
        for (let [i, o] of Object.entries(ls(this.units))) this.addType_(i, o);
      }
      if (t2.atrules) for (let [i, o] of Object.entries(t2.atrules)) this.addAtrule_(i, o);
      if (t2.properties) for (let [i, o] of Object.entries(t2.properties)) this.addProperty_(i, o);
    }
    this.cssWideKeywordsSyntax = yt(this.cssWideKeywords.join(" |  "));
  }
  checkStructure(t2) {
    function r(o, s) {
      i.push({ node: o, message: s });
    }
    let n = this.structure, i = [];
    return this.syntax.walk(t2, function(o) {
      n.hasOwnProperty(o.type) ? n[o.type].check(o, r) : r(o, "Unknown node type `" + o.type + "`");
    }), i.length ? i : false;
  }
  createDescriptor(t2, r, n, i = null) {
    let o = { type: r, name: n }, s = { type: r, name: n, parent: i, serializable: typeof t2 == "string" || t2 && typeof t2.type == "string", syntax: null, match: null, matchRef: null };
    return typeof t2 == "function" ? s.match = yt(t2, o) : (typeof t2 == "string" ? Object.defineProperty(s, "syntax", { get() {
      return Object.defineProperty(s, "syntax", { value: Xe(t2) }), s.syntax;
    } }) : s.syntax = t2, Object.defineProperty(s, "match", { get() {
      return Object.defineProperty(s, "match", { value: yt(s.syntax, o) }), s.match;
    } }), r === "Property" && Object.defineProperty(s, "matchRef", { get() {
      let u = s.syntax, c = Gc(u) ? yt({ ...u, terms: [u.terms[0].term] }, o) : null;
      return Object.defineProperty(s, "matchRef", { value: c }), c;
    } })), s;
  }
  addAtrule_(t2, r) {
    r && (this.atrules[t2] = { type: "Atrule", name: t2, prelude: r.prelude ? this.createDescriptor(r.prelude, "AtrulePrelude", t2) : null, descriptors: r.descriptors ? Object.keys(r.descriptors).reduce((n, i) => (n[i] = this.createDescriptor(r.descriptors[i], "AtruleDescriptor", i, t2), n), /* @__PURE__ */ Object.create(null)) : null });
  }
  addProperty_(t2, r) {
    r && (this.properties[t2] = this.createDescriptor(r, "Property", t2));
  }
  addType_(t2, r) {
    r && (this.types[t2] = this.createDescriptor(r, "Type", t2));
  }
  checkAtruleName(t2) {
    if (!this.getAtrule(t2)) return new Ye("Unknown at-rule", "@" + t2);
  }
  checkAtrulePrelude(t2, r) {
    let n = this.checkAtruleName(t2);
    if (n) return n;
    let i = this.getAtrule(t2);
    if (!i.prelude && r) return new SyntaxError("At-rule `@" + t2 + "` should not contain a prelude");
    if (i.prelude && !r && !Ze(this, i.prelude, "", false).matched) return new SyntaxError("At-rule `@" + t2 + "` should contain a prelude");
  }
  checkAtruleDescriptorName(t2, r) {
    let n = this.checkAtruleName(t2);
    if (n) return n;
    let i = this.getAtrule(t2), o = Ut(r);
    if (!i.descriptors) return new SyntaxError("At-rule `@" + t2 + "` has no known descriptors");
    if (!i.descriptors[o.name] && !i.descriptors[o.basename]) return new Ye("Unknown at-rule descriptor", r);
  }
  checkPropertyName(t2) {
    if (!this.getProperty(t2)) return new Ye("Unknown property", t2);
  }
  matchAtrulePrelude(t2, r) {
    let n = this.checkAtrulePrelude(t2, r);
    if (n) return pe(null, n);
    let i = this.getAtrule(t2);
    return i.prelude ? Ze(this, i.prelude, r || "", false) : pe(null, null);
  }
  matchAtruleDescriptor(t2, r, n) {
    let i = this.checkAtruleDescriptorName(t2, r);
    if (i) return pe(null, i);
    let o = this.getAtrule(t2), s = Ut(r);
    return Ze(this, o.descriptors[s.name] || o.descriptors[s.basename], n, false);
  }
  matchDeclaration(t2) {
    return t2.type !== "Declaration" ? pe(null, new Error("Not a Declaration node")) : this.matchProperty(t2.property, t2.value);
  }
  matchProperty(t2, r) {
    if (Cr(t2).custom) return pe(null, new Error("Lexer matching doesn't applicable for custom properties"));
    let n = this.checkPropertyName(t2);
    return n ? pe(null, n) : Ze(this, this.getProperty(t2), r, true);
  }
  matchType(t2, r) {
    let n = this.getType(t2);
    return n ? Ze(this, n, r, false) : pe(null, new Ye("Unknown type", t2));
  }
  match(t2, r) {
    return typeof t2 != "string" && (!t2 || !t2.type) ? pe(null, new Ye("Bad syntax")) : ((typeof t2 == "string" || !t2.match) && (t2 = this.createDescriptor(t2, "Type", "anonymous")), Ze(this, t2, r, false));
  }
  findValueFragments(t2, r, n, i) {
    return Kr(this, r, this.matchProperty(t2, r), n, i);
  }
  findDeclarationValueFragments(t2, r, n) {
    return Kr(this, t2.value, this.matchDeclaration(t2), r, n);
  }
  findAllFragments(t2, r, n) {
    let i = [];
    return this.syntax.walk(t2, { visit: "Declaration", enter: (o) => {
      i.push.apply(i, this.findDeclarationValueFragments(o, r, n));
    } }), i;
  }
  getAtrule(t2, r = true) {
    let n = Ut(t2);
    return (n.vendor && r ? this.atrules[n.name] || this.atrules[n.basename] : this.atrules[n.name]) || null;
  }
  getAtrulePrelude(t2, r = true) {
    let n = this.getAtrule(t2, r);
    return n && n.prelude || null;
  }
  getAtruleDescriptor(t2, r) {
    return this.atrules.hasOwnProperty(t2) && this.atrules.declarators && this.atrules[t2].declarators[r] || null;
  }
  getProperty(t2, r = true) {
    let n = Cr(t2);
    return (n.vendor && r ? this.properties[n.name] || this.properties[n.basename] : this.properties[n.name]) || null;
  }
  getType(t2) {
    return hasOwnProperty.call(this.types, t2) ? this.types[t2] : null;
  }
  validate() {
    function t2(c, a) {
      return a ? `<${c}>` : `<'${c}'>`;
    }
    function r(c, a, l, p) {
      if (l.has(a)) return l.get(a);
      l.set(a, false), p.syntax !== null && Zt(p.syntax, function(h) {
        if (h.type !== "Type" && h.type !== "Property") return;
        let d = h.type === "Type" ? c.types : c.properties, g2 = h.type === "Type" ? i : o;
        hasOwnProperty.call(d, h.name) ? r(c, h.name, g2, d[h.name]) && (n.push(`${t2(a, l === i)} used broken syntax definition ${t2(h.name, h.type === "Type")}`), l.set(a, true)) : (n.push(`${t2(a, l === i)} used missed syntax definition ${t2(h.name, h.type === "Type")}`), l.set(a, true));
      }, this);
    }
    let n = [], i = /* @__PURE__ */ new Map(), o = /* @__PURE__ */ new Map();
    for (let c in this.types) r(this, c, i, this.types[c]);
    for (let c in this.properties) r(this, c, o, this.properties[c]);
    let s = [...i.keys()].filter((c) => i.get(c)), u = [...o.keys()].filter((c) => o.get(c));
    return s.length || u.length ? { errors: n, types: s, properties: u } : null;
  }
  dump(t2, r) {
    return { generic: this.generic, cssWideKeywords: this.cssWideKeywords, units: this.units, types: Qr(this.types, !r, t2), properties: Qr(this.properties, !r, t2), atrules: Uc(this.atrules, !r, t2) };
  }
  toString() {
    return JSON.stringify(this.dump());
  }
};
function Xr(e2, t2) {
  return typeof t2 == "string" && /^\s*\|/.test(t2) ? typeof e2 == "string" ? e2 + t2 : t2.replace(/^\s*\|\s*/, "") : t2 || null;
}
function Yc(e2, t2) {
  let r = /* @__PURE__ */ Object.create(null);
  for (let n of Object.keys(e2)) t2.includes(n) && (r[n] = e2[n]);
  return r;
}
function $r(e2, t2, r) {
  let n = { ...e2 };
  for (let [i, o] of Object.entries(t2)) n[i] = { ...n[i], ...r ? Yc(o, r) : o };
  return n;
}
function wt(e2, t2) {
  let r = { ...e2 };
  for (let [n, i] of Object.entries(t2)) switch (n) {
    case "generic":
      r[n] = !!i;
      break;
    case "cssWideKeywords":
      r[n] = e2[n] ? [...e2[n], ...i] : i || [];
      break;
    case "units":
      r[n] = { ...e2[n] };
      for (let [o, s] of Object.entries(i)) r[n][o] = Array.isArray(s) ? s : [];
      break;
    case "atrules":
      r[n] = { ...e2[n] };
      for (let [o, s] of Object.entries(i)) {
        let u = r[n][o] || {}, c = r[n][o] = { prelude: u.prelude || null, descriptors: { ...u.descriptors } };
        if (s) {
          c.prelude = s.prelude ? Xr(c.prelude, s.prelude) : c.prelude || null;
          for (let [a, l] of Object.entries(s.descriptors || {})) c.descriptors[a] = l ? Xr(c.descriptors[a], l) : null;
          Object.keys(c.descriptors).length || (c.descriptors = null);
        }
      }
      break;
    case "types":
    case "properties":
      r[n] = { ...e2[n] };
      for (let [o, s] of Object.entries(i)) r[n][o] = Xr(r[n][o], s);
      break;
    case "parseContext":
      r[n] = { ...e2[n], ...i };
      break;
    case "scope":
    case "features":
      r[n] = $r(e2[n], i);
      break;
    case "atrule":
    case "pseudo":
      r[n] = $r(e2[n], i, ["parse"]);
      break;
    case "node":
      r[n] = $r(e2[n], i, ["name", "structure", "parse", "generate", "walkContext"]);
      break;
  }
  return r;
}
function Ms(e2) {
  let t2 = wo(e2), r = Zo(e2), n = Yo(e2), { fromPlainObject: i, toPlainObject: o } = Ko(r), s = { lexer: null, createLexer: (u) => new Je(u, s, s.lexer.structure), tokenize: Ce, parse: t2, generate: n, walk: r, find: r.find, findLast: r.findLast, findAll: r.findAll, fromPlainObject: i, toPlainObject: o, fork(u) {
    let c = wt({}, e2);
    return Ms(typeof u == "function" ? u(c) : wt(c, u));
  } };
  return s.lexer = new Je({ generic: e2.generic, cssWideKeywords: e2.cssWideKeywords, units: e2.units, types: e2.types, atrules: e2.atrules, properties: e2.properties, node: e2.node }, s), s;
}
var Zr = (e2) => Ms(wt({}, e2));
var Bs = { generic: true, cssWideKeywords: ["initial", "inherit", "unset", "revert", "revert-layer"], units: { angle: ["deg", "grad", "rad", "turn"], decibel: ["db"], flex: ["fr"], frequency: ["hz", "khz"], length: ["cm", "mm", "q", "in", "pt", "pc", "px", "em", "rem", "ex", "rex", "cap", "rcap", "ch", "rch", "ic", "ric", "lh", "rlh", "vw", "svw", "lvw", "dvw", "vh", "svh", "lvh", "dvh", "vi", "svi", "lvi", "dvi", "vb", "svb", "lvb", "dvb", "vmin", "svmin", "lvmin", "dvmin", "vmax", "svmax", "lvmax", "dvmax", "cqw", "cqh", "cqi", "cqb", "cqmin", "cqmax"], resolution: ["dpi", "dpcm", "dppx", "x"], semitones: ["st"], time: ["s", "ms"] }, types: { "abs()": "abs( <calc-sum> )", "absolute-size": "xx-small|x-small|small|medium|large|x-large|xx-large|xxx-large", "acos()": "acos( <calc-sum> )", "alpha-value": "<number>|<percentage>", "an+b": "odd|even|<integer>|<n-dimension>|'+'? \u2020 n|-n|<ndashdigit-dimension>|'+'? \u2020 <ndashdigit-ident>|<dashndashdigit-ident>|<n-dimension> <signed-integer>|'+'? \u2020 n <signed-integer>|-n <signed-integer>|<ndash-dimension> <signless-integer>|'+'? \u2020 n- <signless-integer>|-n- <signless-integer>|<n-dimension> ['+'|'-'] <signless-integer>|'+'? \u2020 n ['+'|'-'] <signless-integer>|-n ['+'|'-'] <signless-integer>", "anchor()": "anchor( <anchor-name>?&&<anchor-side> , <length-percentage>? )", "anchor-name": "<dashed-ident>", "anchor-side": "inside|outside|top|left|right|bottom|start|end|self-start|self-end|<percentage>|center", "anchor-size": "width|height|block|inline|self-block|self-inline", "anchor-size()": "anchor-size( [<anchor-name>||<anchor-size>]? , <length-percentage>? )", "angle-percentage": "<angle>|<percentage>", "angular-color-hint": "<angle-percentage>|<zero>", "angular-color-stop": "<color> <color-stop-angle>?", "angular-color-stop-list": "<angular-color-stop> , [<angular-color-hint>? , <angular-color-stop>]#?", "animateable-feature": "scroll-position|contents|<custom-ident>", "asin()": "asin( <calc-sum> )", "atan()": "atan( <calc-sum> )", "atan2()": "atan2( <calc-sum> , <calc-sum> )", attachment: "scroll|fixed|local", "attr()": "attr( <attr-name> <type-or-unit>? [, <attr-fallback>]? )", "attr-matcher": "['~'|'|'|'^'|'$'|'*']? '='", "attr-modifier": "i|s", "attribute-selector": "'[' <wq-name> ']'|'[' <wq-name> <attr-matcher> [<string-token>|<ident-token>] <attr-modifier>? ']'", "auto-repeat": "repeat( [auto-fill|auto-fit] , [<line-names>? <fixed-size>]+ <line-names>? )", "auto-track-list": "[<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>? <auto-repeat> [<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>?", axis: "block|inline|x|y", "baseline-position": "[first|last]? baseline", "basic-shape": "<inset()>|<xywh()>|<rect()>|<circle()>|<ellipse()>|<polygon()>|<path()>", "basic-shape-rect": "<inset()>|<rect()>|<xywh()>", "bg-clip": "<visual-box>|border-area|text", "bg-image": "none|<image>", "bg-layer": "<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<visual-box>||<visual-box>", "bg-position": "[[left|center|right|top|bottom|<length-percentage>]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]|[center|[left|right] <length-percentage>?]&&[center|[top|bottom] <length-percentage>?]]", "bg-size": "[<length-percentage>|auto]{1,2}|cover|contain", "blend-mode": "normal|multiply|screen|overlay|darken|lighten|color-dodge|color-burn|hard-light|soft-light|difference|exclusion|hue|saturation|color|luminosity", "blur()": "blur( <length>? )", "brightness()": "brightness( [<number>|<percentage>]? )", "calc()": "calc( <calc-sum> )", "calc-constant": "e|pi|infinity|-infinity|NaN", "calc-product": "<calc-value> ['*' <calc-value>|'/' <number>]*", "calc-size()": "calc-size( <calc-size-basis> , <calc-sum> )", "calc-size-basis": "<intrinsic-size-keyword>|<calc-size()>|any|<calc-sum>", "calc-sum": "<calc-product> [['+'|'-'] <calc-product>]*", "calc-value": "<number>|<dimension>|<percentage>|<calc-constant>|( <calc-sum> )", "cf-final-image": "<image>|<color>", "cf-mixing-image": "<percentage>?&&<image>", "circle()": "circle( <radial-size>? [at <position>]? )", "clamp()": "clamp( <calc-sum>#{3} )", "class-selector": "'.' <ident-token>", "clip-source": "<url>", color: "<color-base>|currentColor|<system-color>|<device-cmyk()>|<light-dark()>|<-non-standard-color>", "color()": "color( <colorspace-params> [/ [<alpha-value>|none]]? )", "color-base": "<hex-color>|<color-function>|<named-color>|<color-mix()>|transparent", "color-function": "<rgb()>|<rgba()>|<hsl()>|<hsla()>|<hwb()>|<lab()>|<lch()>|<oklab()>|<oklch()>|<color()>", "color-interpolation-method": "in [<rectangular-color-space>|<polar-color-space> <hue-interpolation-method>?|<custom-color-space>]", "color-mix()": "color-mix( <color-interpolation-method> , [<color>&&<percentage [0,100]>?]#{2} )", "color-stop": "<color-stop-length>|<color-stop-angle>", "color-stop-angle": "[<angle-percentage>|<zero>]{1,2}", "color-stop-length": "<length-percentage>{1,2}", "color-stop-list": "<linear-color-stop> , [<linear-color-hint>? , <linear-color-stop>]#?", "colorspace-params": "[<predefined-rgb-params>|<xyz-params>]", combinator: "'>'|'+'|'~'|['|' '|']", "common-lig-values": "[common-ligatures|no-common-ligatures]", "compat-auto": "searchfield|textarea|push-button|slider-horizontal|checkbox|radio|square-button|menulist|listbox|meter|progress-bar|button", "complex-selector": "<complex-selector-unit> [<combinator>? <complex-selector-unit>]*", "complex-selector-list": "<complex-selector>#", "composite-style": "clear|copy|source-over|source-in|source-out|source-atop|destination-over|destination-in|destination-out|destination-atop|xor", "compositing-operator": "add|subtract|intersect|exclude", "compound-selector": "[<type-selector>? <subclass-selector>*]!", "compound-selector-list": "<compound-selector>#", "conic-gradient()": "conic-gradient( [<conic-gradient-syntax>] )", "conic-gradient-syntax": "[[[from [<angle>|<zero>]]? [at <position>]?]||<color-interpolation-method>]? , <angular-color-stop-list>", "container-condition": "not <query-in-parens>|<query-in-parens> [[and <query-in-parens>]*|[or <query-in-parens>]*]", "container-name": "<custom-ident>", "container-query": "not <query-in-parens>|<query-in-parens> [[and <query-in-parens>]*|[or <query-in-parens>]*]", "content-distribution": "space-between|space-around|space-evenly|stretch", "content-list": "[<string>|contents|<image>|<counter>|<quote>|<target>|<leader()>|<attr()>]+", "content-position": "center|start|end|flex-start|flex-end", "content-replacement": "<image>", "contextual-alt-values": "[contextual|no-contextual]", "contrast()": "contrast( [<number>|<percentage>]? )", "coord-box": "content-box|padding-box|border-box|fill-box|stroke-box|view-box", "cos()": "cos( <calc-sum> )", counter: "<counter()>|<counters()>", "counter()": "counter( <counter-name> , <counter-style>? )", "counter-name": "<custom-ident>", "counter-style": "<counter-style-name>|symbols( )", "counter-style-name": "<custom-ident>", "counters()": "counters( <counter-name> , <string> , <counter-style>? )", "cross-fade()": "cross-fade( <cf-mixing-image> , <cf-final-image>? )", "cubic-bezier()": "cubic-bezier( [<number [0,1]> , <number>]#{2} )", "cubic-bezier-timing-function": "ease|ease-in|ease-out|ease-in-out|<cubic-bezier()>", "custom-color-space": "<dashed-ident>", "custom-params": "<dashed-ident> [<number>|<percentage>|none]+", dasharray: "[[<length-percentage>|<number>]+]#", "dashndashdigit-ident": "<ident-token>", "deprecated-system-color": "ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonHighlight|ButtonShadow|CaptionText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText", "discretionary-lig-values": "[discretionary-ligatures|no-discretionary-ligatures]", "display-box": "contents|none", "display-inside": "flow|flow-root|table|flex|grid|ruby", "display-internal": "table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption|ruby-base|ruby-text|ruby-base-container|ruby-text-container", "display-legacy": "inline-block|inline-list-item|inline-table|inline-flex|inline-grid", "display-listitem": "<display-outside>?&&[flow|flow-root]?&&list-item", "display-outside": "block|inline|run-in", "drop-shadow()": "drop-shadow( [<color>?&&<length>{2,3}] )", "easing-function": "<linear-easing-function>|<cubic-bezier-easing-function>|<step-easing-function>", "east-asian-variant-values": "[jis78|jis83|jis90|jis04|simplified|traditional]", "east-asian-width-values": "[full-width|proportional-width]", "element()": "element( <custom-ident> , [first|start|last|first-except]? )|element( <id-selector> )", "ellipse()": "ellipse( <radial-size>? [at <position>]? )", "env()": "env( <custom-ident> , <declaration-value>? )", "exp()": "exp( <calc-sum> )", "explicit-track-list": "[<line-names>? <track-size>]+ <line-names>?", "family-name": "<string>|<custom-ident>+", "feature-tag-value": "<string> [<integer>|on|off]?", "feature-type": "@stylistic|@historical-forms|@styleset|@character-variant|@swash|@ornaments|@annotation", "feature-value-block": "<feature-type> '{' <feature-value-declaration-list> '}'", "feature-value-block-list": "<feature-value-block>+", "feature-value-declaration": "<custom-ident> : <integer>+ ;", "feature-value-declaration-list": "<feature-value-declaration>", "feature-value-name": "<custom-ident>", "filter-function": "<blur()>|<brightness()>|<contrast()>|<drop-shadow()>|<grayscale()>|<hue-rotate()>|<invert()>|<opacity()>|<saturate()>|<sepia()>", "filter-value-list": "[<filter-function>|<url>]+", "final-bg-layer": "<'background-color'>||<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<visual-box>||<visual-box>", "fit-content()": "fit-content( <length-percentage [0,\u221E]> )", "fixed-breadth": "<length-percentage>", "fixed-repeat": "repeat( [<integer [1,\u221E]>] , [<line-names>? <fixed-size>]+ <line-names>? )", "fixed-size": "<fixed-breadth>|minmax( <fixed-breadth> , <track-breadth> )|minmax( <inflexible-breadth> , <fixed-breadth> )", "font-stretch-absolute": "normal|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded|<percentage>", "font-variant-css21": "[normal|small-caps]", "font-weight-absolute": "normal|bold|<number [1,1000]>", "form-control-identifier": "select", "frequency-percentage": "<frequency>|<percentage>", "generic-complete": "serif|sans-serif|system-ui|cursive|fantasy|math|monospace", "general-enclosed": "[<function-token> <any-value>? )]|[( <any-value>? )]", "generic-family": "<generic-script-specific>|<generic-complete>|<generic-incomplete>|<-non-standard-generic-family>", "generic-incomplete": "ui-serif|ui-sans-serif|ui-monospace|ui-rounded", "geometry-box": "<shape-box>|fill-box|stroke-box|view-box", gradient: "<linear-gradient()>|<repeating-linear-gradient()>|<radial-gradient()>|<repeating-radial-gradient()>|<conic-gradient()>|<repeating-conic-gradient()>|<-legacy-gradient>", "grayscale()": "grayscale( [<number>|<percentage>]? )", "grid-line": "auto|<custom-ident>|[<integer>&&<custom-ident>?]|[span&&[<integer>||<custom-ident>]]", "historical-lig-values": "[historical-ligatures|no-historical-ligatures]", "hsl()": "hsl( <hue> , <percentage> , <percentage> , <alpha-value>? )|hsl( [<hue>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )", "hsla()": "hsla( <hue> , <percentage> , <percentage> , <alpha-value>? )|hsla( [<hue>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )", hue: "<number>|<angle>", "hue-interpolation-method": "[shorter|longer|increasing|decreasing] hue", "hue-rotate()": "hue-rotate( [<angle>|<zero>]? )", "hwb()": "hwb( [<hue>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )", "hypot()": "hypot( <calc-sum># )", image: "<url>|<image()>|<image-set()>|<element()>|<paint()>|<cross-fade()>|<gradient>", "image()": "image( <image-tags>? [<image-src>? , <color>?]! )", "image-set()": "image-set( <image-set-option># )", "image-set-option": "[<image>|<string>] [<resolution>||type( <string> )]", "image-src": "<url>|<string>", "image-tags": "ltr|rtl", "inflexible-breadth": "<length-percentage>|min-content|max-content|auto", "inset()": "inset( <length-percentage>{1,4} [round <'border-radius'>]? )", "invert()": "invert( [<number>|<percentage>]? )", "keyframe-block": "<keyframe-selector># { <declaration-list> }", "keyframe-selector": "from|to|<percentage [0,100]>|<timeline-range-name> <percentage>", "keyframes-name": "<custom-ident>|<string>", "lab()": "lab( [<percentage>|<number>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )", "layer()": "layer( <layer-name> )", "layer-name": "<ident> ['.' <ident>]*", "lch()": "lch( [<percentage>|<number>|none] [<percentage>|<number>|none] [<hue>|none] [/ [<alpha-value>|none]]? )", "leader()": "leader( <leader-type> )", "leader-type": "dotted|solid|space|<string>", "length-percentage": "<length>|<percentage>", "light-dark()": "light-dark( <color> , <color> )", "line-name-list": "[<line-names>|<name-repeat>]+", "line-names": "'[' <custom-ident>* ']'", "line-style": "none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset", "line-width": "<length>|thin|medium|thick", "linear()": "linear( [<number>&&<percentage>{0,2}]# )", "linear-color-hint": "<length-percentage>", "linear-color-stop": "<color> <color-stop-length>?", "linear-easing-function": "linear|<linear()>", "linear-gradient()": "linear-gradient( [<linear-gradient-syntax>] )", "linear-gradient-syntax": "[[<angle>|<zero>|to <side-or-corner>]||<color-interpolation-method>]? , <color-stop-list>", "log()": "log( <calc-sum> , <calc-sum>? )", "mask-layer": "<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||<geometry-box>||[<geometry-box>|no-clip]||<compositing-operator>||<masking-mode>", "mask-position": "[<length-percentage>|left|center|right] [<length-percentage>|top|center|bottom]?", "mask-reference": "none|<image>|<mask-source>", "mask-source": "<url>", "masking-mode": "alpha|luminance|match-source", "matrix()": "matrix( <number>#{6} )", "matrix3d()": "matrix3d( <number>#{16} )", "max()": "max( <calc-sum># )", "media-and": "<media-in-parens> [and <media-in-parens>]+", "media-condition": "<media-not>|<media-and>|<media-or>|<media-in-parens>", "media-condition-without-or": "<media-not>|<media-and>|<media-in-parens>", "media-feature": "( [<mf-plain>|<mf-boolean>|<mf-range>] )", "media-in-parens": "( <media-condition> )|<media-feature>|<general-enclosed>", "media-not": "not <media-in-parens>", "media-or": "<media-in-parens> [or <media-in-parens>]+", "media-query": "<media-condition>|[not|only]? <media-type> [and <media-condition-without-or>]?", "media-query-list": "<media-query>#", "media-type": "<ident>", "mf-boolean": "<mf-name>", "mf-name": "<ident>", "mf-plain": "<mf-name> : <mf-value>", "mf-range": "<mf-name> ['<'|'>']? '='? <mf-value>|<mf-value> ['<'|'>']? '='? <mf-name>|<mf-value> '<' '='? <mf-name> '<' '='? <mf-value>|<mf-value> '>' '='? <mf-name> '>' '='? <mf-value>", "mf-value": "<number>|<dimension>|<ident>|<ratio>", "min()": "min( <calc-sum># )", "minmax()": "minmax( [<length-percentage>|min-content|max-content|auto] , [<length-percentage>|<flex>|min-content|max-content|auto] )", "mod()": "mod( <calc-sum> , <calc-sum> )", "n-dimension": "<dimension-token>", "name-repeat": "repeat( [<integer [1,\u221E]>|auto-fill] , <line-names>+ )", "named-color": "aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen", "namespace-prefix": "<ident>", "ndash-dimension": "<dimension-token>", "ndashdigit-dimension": "<dimension-token>", "ndashdigit-ident": "<ident-token>", "ns-prefix": "[<ident-token>|'*']? '|'", "number-percentage": "<number>|<percentage>", "numeric-figure-values": "[lining-nums|oldstyle-nums]", "numeric-fraction-values": "[diagonal-fractions|stacked-fractions]", "numeric-spacing-values": "[proportional-nums|tabular-nums]", "offset-path": "<ray()>|<url>|<basic-shape>", "oklab()": "oklab( [<percentage>|<number>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )", "oklch()": "oklch( [<percentage>|<number>|none] [<percentage>|<number>|none] [<hue>|none] [/ [<alpha-value>|none]]? )", "opacity()": "opacity( [<number>|<percentage>]? )", "opacity-value": "<number>|<percentage>", "outline-line-style": "none|dotted|dashed|solid|double|groove|ridge|inset|outset", "outline-radius": "<length>|<percentage>", "overflow-position": "unsafe|safe", "page-body": "<declaration>? [; <page-body>]?|<page-margin-box> <page-body>", "page-margin-box": "<page-margin-box-type> '{' <declaration-list> '}'", "page-margin-box-type": "@top-left-corner|@top-left|@top-center|@top-right|@top-right-corner|@bottom-left-corner|@bottom-left|@bottom-center|@bottom-right|@bottom-right-corner|@left-top|@left-middle|@left-bottom|@right-top|@right-middle|@right-bottom", "page-selector": "<pseudo-page>+|<ident> <pseudo-page>*", "page-selector-list": "[<page-selector>#]?", "page-size": "A5|A4|A3|B5|B4|JIS-B5|JIS-B4|letter|legal|ledger", paint: "none|<color>|<url> [none|<color>]?|context-fill|context-stroke", "paint()": "paint( <ident> , <declaration-value>? )", "paint-box": "<visual-box>|fill-box|stroke-box", "palette-identifier": "<dashed-ident>", "palette-mix()": "palette-mix( <color-interpolation-method> , [[normal|light|dark|<palette-identifier>|<palette-mix()>]&&<percentage [0,100]>?]#{2} )", "path()": "path( <'fill-rule'>? , <string> )", "perspective()": "perspective( [<length [0,\u221E]>|none] )", "polar-color-space": "hsl|hwb|lch|oklch", "polygon()": "polygon( <'fill-rule'>? , [<length-percentage> <length-percentage>]# )", position: "[[left|center|right]||[top|center|bottom]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]?|[[left|right] <length-percentage>]&&[[top|bottom] <length-percentage>]]", "position-area": "[[left|center|right|span-left|span-right|x-start|x-end|span-x-start|span-x-end|x-self-start|x-self-end|span-x-self-start|span-x-self-end|span-all]||[top|center|bottom|span-top|span-bottom|y-start|y-end|span-y-start|span-y-end|y-self-start|y-self-end|span-y-self-start|span-y-self-end|span-all]|[block-start|center|block-end|span-block-start|span-block-end|span-all]||[inline-start|center|inline-end|span-inline-start|span-inline-end|span-all]|[self-block-start|center|self-block-end|span-self-block-start|span-self-block-end|span-all]||[self-inline-start|center|self-inline-end|span-self-inline-start|span-self-inline-end|span-all]|[start|center|end|span-start|span-end|span-all]{1,2}|[self-start|center|self-end|span-self-start|span-self-end|span-all]{1,2}]", "pow()": "pow( <calc-sum> , <calc-sum> )", "predefined-rgb": "srgb|srgb-linear|display-p3|a98-rgb|prophoto-rgb|rec2020", "predefined-rgb-params": "<predefined-rgb> [<number>|<percentage>|none]{3}", "pseudo-class-selector": "':' <ident-token>|':' <function-token> <any-value> ')'", "pseudo-element-selector": "':' <pseudo-class-selector>|<legacy-pseudo-element-selector>", "pseudo-page": ": [left|right|first|blank]", "query-in-parens": "( <container-condition> )|( <size-feature> )|style( <style-query> )|<general-enclosed>", quote: "open-quote|close-quote|no-open-quote|no-close-quote", "radial-extent": "closest-corner|closest-side|farthest-corner|farthest-side", "radial-gradient()": "radial-gradient( [<radial-gradient-syntax>] )", "radial-gradient-syntax": "[[[<radial-shape>||<radial-size>]? [at <position>]?]||<color-interpolation-method>]? , <color-stop-list>", "radial-shape": "circle|ellipse", "radial-size": "<radial-extent>|<length [0,\u221E]>|<length-percentage [0,\u221E]>{2}", ratio: "<number [0,\u221E]> [/ <number [0,\u221E]>]?", "ray()": "ray( <angle>&&<ray-size>?&&contain?&&[at <position>]? )", "ray-size": "closest-side|closest-corner|farthest-side|farthest-corner|sides", "rect()": "rect( [<length-percentage>|auto]{4} [round <'border-radius'>]? )", "rectangular-color-space": "srgb|srgb-linear|display-p3|a98-rgb|prophoto-rgb|rec2020|lab|oklab|xyz|xyz-d50|xyz-d65", "relative-selector": "<combinator>? <complex-selector>", "relative-selector-list": "<relative-selector>#", "relative-size": "larger|smaller", "rem()": "rem( <calc-sum> , <calc-sum> )", "repeat-style": "repeat-x|repeat-y|[repeat|space|round|no-repeat]{1,2}", "repeating-conic-gradient()": "repeating-conic-gradient( [<conic-gradient-syntax>] )", "repeating-linear-gradient()": "repeating-linear-gradient( [<linear-gradient-syntax>] )", "repeating-radial-gradient()": "repeating-radial-gradient( [<radial-gradient-syntax>] )", "reversed-counter-name": "reversed( <counter-name> )", "rgb()": "rgb( <percentage>#{3} , <alpha-value>? )|rgb( <number>#{3} , <alpha-value>? )|rgb( [<number>|<percentage>|none]{3} [/ [<alpha-value>|none]]? )", "rgba()": "rgba( <percentage>#{3} , <alpha-value>? )|rgba( <number>#{3} , <alpha-value>? )|rgba( [<number>|<percentage>|none]{3} [/ [<alpha-value>|none]]? )", "rotate()": "rotate( [<angle>|<zero>] )", "rotate3d()": "rotate3d( <number> , <number> , <number> , [<angle>|<zero>] )", "rotateX()": "rotateX( [<angle>|<zero>] )", "rotateY()": "rotateY( [<angle>|<zero>] )", "rotateZ()": "rotateZ( [<angle>|<zero>] )", "round()": "round( <rounding-strategy>? , <calc-sum> , <calc-sum> )", "rounding-strategy": "nearest|up|down|to-zero", "saturate()": "saturate( [<number>|<percentage>]? )", "scale()": "scale( [<number>|<percentage>]#{1,2} )", "scale3d()": "scale3d( [<number>|<percentage>]#{3} )", "scaleX()": "scaleX( [<number>|<percentage>] )", "scaleY()": "scaleY( [<number>|<percentage>] )", "scaleZ()": "scaleZ( [<number>|<percentage>] )", "scope-end": "<forgiving-selector-list>", "scope-start": "<forgiving-selector-list>", "scroll()": "scroll( [<scroller>||<axis>]? )", scroller: "root|nearest|self", "scroll-state-feature": "<media-query-list>", "scroll-state-in-parens": "( <scroll-state-query> )|( <scroll-state-feature> )|<general-enclosed>", "scroll-state-query": "not <scroll-state-in-parens>|<scroll-state-in-parens> [[and <scroll-state-in-parens>]*|[or <scroll-state-in-parens>]*]|<scroll-state-feature>", "selector-list": "<complex-selector-list>", "self-position": "center|start|end|self-start|self-end|flex-start|flex-end", "sepia()": "sepia( [<number>|<percentage>]? )", shadow: "inset?&&<length>{2,4}&&<color>?", "shadow-t": "[<length>{2,3}&&<color>?]", shape: "rect( <top> , <right> , <bottom> , <left> )|rect( <top> <right> <bottom> <left> )", "shape-box": "<visual-box>|margin-box", "side-or-corner": "[left|right]||[top|bottom]", "sign()": "sign( <calc-sum> )", "signed-integer": "<number-token>", "signless-integer": "<number-token>", "sin()": "sin( <calc-sum> )", "single-animation": "<'animation-duration'>||<easing-function>||<'animation-delay'>||<single-animation-iteration-count>||<single-animation-direction>||<single-animation-fill-mode>||<single-animation-play-state>||[none|<keyframes-name>]||<single-animation-timeline>", "single-animation-composition": "replace|add|accumulate", "single-animation-direction": "normal|reverse|alternate|alternate-reverse", "single-animation-fill-mode": "none|forwards|backwards|both", "single-animation-iteration-count": "infinite|<number>", "single-animation-play-state": "running|paused", "single-animation-timeline": "auto|none|<dashed-ident>|<scroll()>|<view()>", "single-transition": "[none|<single-transition-property>]||<time>||<easing-function>||<time>||<transition-behavior-value>", "single-transition-property": "all|<custom-ident>", size: "closest-side|farthest-side|closest-corner|farthest-corner|<length>|<length-percentage>{2}", "size-feature": "<mf-plain>|<mf-boolean>|<mf-range>", "skew()": "skew( [<angle>|<zero>] , [<angle>|<zero>]? )", "skewX()": "skewX( [<angle>|<zero>] )", "skewY()": "skewY( [<angle>|<zero>] )", "sqrt()": "sqrt( <calc-sum> )", "step-position": "jump-start|jump-end|jump-none|jump-both|start|end", "step-easing-function": "step-start|step-end|<steps()>", "steps()": "steps( <integer> , <step-position>? )", "style-feature": "<declaration>", "style-in-parens": "( <style-condition> )|( <style-feature> )|<general-enclosed>", "style-query": "<style-condition>|<style-feature>", "subclass-selector": "<id-selector>|<class-selector>|<attribute-selector>|<pseudo-class-selector>", "supports-condition": "not <supports-in-parens>|<supports-in-parens> [and <supports-in-parens>]*|<supports-in-parens> [or <supports-in-parens>]*", "supports-decl": "( <declaration> )", "supports-feature": "<supports-decl>|<supports-selector-fn>", "supports-in-parens": "( <supports-condition> )|<supports-feature>|<general-enclosed>", "supports-selector-fn": "selector( <complex-selector> )", symbol: "<string>|<image>|<custom-ident>", "symbols()": "symbols( <symbols-type>? [<string>|<image>]+ )", "symbols-type": "cyclic|numeric|alphabetic|symbolic|fixed", "system-color": "AccentColor|AccentColorText|ActiveText|ButtonBorder|ButtonFace|ButtonText|Canvas|CanvasText|Field|FieldText|GrayText|Highlight|HighlightText|LinkText|Mark|MarkText|SelectedItem|SelectedItemText|VisitedText", "tan()": "tan( <calc-sum> )", target: "<target-counter()>|<target-counters()>|<target-text()>", "target-counter()": "target-counter( [<string>|<url>] , <custom-ident> , <counter-style>? )", "target-counters()": "target-counters( [<string>|<url>] , <custom-ident> , <string> , <counter-style>? )", "target-text()": "target-text( [<string>|<url>] , [content|before|after|first-letter]? )", "text-edge": "[text|cap|ex|ideographic|ideographic-ink] [text|alphabetic|ideographic|ideographic-ink]?", "time-percentage": "<time>|<percentage>", "timeline-range-name": "cover|contain|entry|exit|entry-crossing|exit-crossing", "track-breadth": "<length-percentage>|<flex>|min-content|max-content|auto", "track-list": "[<line-names>? [<track-size>|<track-repeat>]]+ <line-names>?", "track-repeat": "repeat( [<integer [1,\u221E]>] , [<line-names>? <track-size>]+ <line-names>? )", "track-size": "<track-breadth>|minmax( <inflexible-breadth> , <track-breadth> )|fit-content( <length-percentage> )", "transform-function": "<matrix()>|<translate()>|<translateX()>|<translateY()>|<scale()>|<scaleX()>|<scaleY()>|<rotate()>|<skew()>|<skewX()>|<skewY()>|<matrix3d()>|<translate3d()>|<translateZ()>|<scale3d()>|<scaleZ()>|<rotate3d()>|<rotateX()>|<rotateY()>|<rotateZ()>|<perspective()>", "transform-list": "<transform-function>+", "transition-behavior-value": "normal|allow-discrete", "translate()": "translate( <length-percentage> , <length-percentage>? )", "translate3d()": "translate3d( <length-percentage> , <length-percentage> , <length> )", "translateX()": "translateX( <length-percentage> )", "translateY()": "translateY( <length-percentage> )", "translateZ()": "translateZ( <length> )", "try-size": "most-width|most-height|most-block-size|most-inline-size", "try-tactic": "flip-block||flip-inline||flip-start", "type-or-unit": "string|color|url|integer|number|length|angle|time|frequency|cap|ch|em|ex|ic|lh|rlh|rem|vb|vi|vw|vh|vmin|vmax|mm|Q|cm|in|pt|pc|px|deg|grad|rad|turn|ms|s|Hz|kHz|%", "type-selector": "<wq-name>|<ns-prefix>? '*'", "var()": "var( <custom-property-name> , <declaration-value>? )", "view()": "view( [<axis>||<'view-timeline-inset'>]? )", "viewport-length": "auto|<length-percentage>", "visual-box": "content-box|padding-box|border-box", "wq-name": "<ns-prefix>? <ident-token>", "xywh()": "xywh( <length-percentage>{2} <length-percentage [0,\u221E]>{2} [round <'border-radius'>]? )", xyz: "xyz|xyz-d50|xyz-d65", "xyz-params": "<xyz-space> [<number>|<percentage>|none]{3}", "-legacy-gradient": "<-webkit-gradient()>|<-legacy-linear-gradient>|<-legacy-repeating-linear-gradient>|<-legacy-radial-gradient>|<-legacy-repeating-radial-gradient>", "-legacy-linear-gradient": "-moz-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-linear-gradient( <-legacy-linear-gradient-arguments> )", "-legacy-repeating-linear-gradient": "-moz-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )", "-legacy-linear-gradient-arguments": "[<angle>|<side-or-corner>]? , <color-stop-list>", "-legacy-radial-gradient": "-moz-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-radial-gradient( <-legacy-radial-gradient-arguments> )", "-legacy-repeating-radial-gradient": "-moz-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )", "-legacy-radial-gradient-arguments": "[<position> ,]? [[[<-legacy-radial-gradient-shape>||<-legacy-radial-gradient-size>]|[<length>|<percentage>]{2}] ,]? <color-stop-list>", "-legacy-radial-gradient-size": "closest-side|closest-corner|farthest-side|farthest-corner|contain|cover", "-legacy-radial-gradient-shape": "circle|ellipse", "-non-standard-font": "-apple-system-body|-apple-system-headline|-apple-system-subheadline|-apple-system-caption1|-apple-system-caption2|-apple-system-footnote|-apple-system-short-body|-apple-system-short-headline|-apple-system-short-subheadline|-apple-system-short-caption1|-apple-system-short-footnote|-apple-system-tall-body", "-non-standard-color": "-moz-ButtonDefault|-moz-ButtonHoverFace|-moz-ButtonHoverText|-moz-CellHighlight|-moz-CellHighlightText|-moz-Combobox|-moz-ComboboxText|-moz-Dialog|-moz-DialogText|-moz-dragtargetzone|-moz-EvenTreeRow|-moz-Field|-moz-FieldText|-moz-html-CellHighlight|-moz-html-CellHighlightText|-moz-mac-accentdarkestshadow|-moz-mac-accentdarkshadow|-moz-mac-accentface|-moz-mac-accentlightesthighlight|-moz-mac-accentlightshadow|-moz-mac-accentregularhighlight|-moz-mac-accentregularshadow|-moz-mac-chrome-active|-moz-mac-chrome-inactive|-moz-mac-focusring|-moz-mac-menuselect|-moz-mac-menushadow|-moz-mac-menutextselect|-moz-MenuHover|-moz-MenuHoverText|-moz-MenuBarText|-moz-MenuBarHoverText|-moz-nativehyperlinktext|-moz-OddTreeRow|-moz-win-communicationstext|-moz-win-mediatext|-moz-activehyperlinktext|-moz-default-background-color|-moz-default-color|-moz-hyperlinktext|-moz-visitedhyperlinktext|-webkit-activelink|-webkit-focus-ring-color|-webkit-link|-webkit-text", "-non-standard-image-rendering": "optimize-contrast|-moz-crisp-edges|-o-crisp-edges|-webkit-optimize-contrast", "-non-standard-overflow": "overlay|-moz-scrollbars-none|-moz-scrollbars-horizontal|-moz-scrollbars-vertical|-moz-hidden-unscrollable", "-non-standard-size": "intrinsic|min-intrinsic|-webkit-fill-available|-webkit-fit-content|-webkit-min-content|-webkit-max-content|-moz-available|-moz-fit-content|-moz-min-content|-moz-max-content", "-webkit-gradient()": "-webkit-gradient( <-webkit-gradient-type> , <-webkit-gradient-point> [, <-webkit-gradient-point>|, <-webkit-gradient-radius> , <-webkit-gradient-point>] [, <-webkit-gradient-radius>]? [, <-webkit-gradient-color-stop>]* )", "-webkit-gradient-color-stop": "from( <color> )|color-stop( [<number-zero-one>|<percentage>] , <color> )|to( <color> )", "-webkit-gradient-point": "[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]", "-webkit-gradient-radius": "<length>|<percentage>", "-webkit-gradient-type": "linear|radial", "-webkit-mask-box-repeat": "repeat|stretch|round", "-ms-filter-function-list": "<-ms-filter-function>+", "-ms-filter-function": "<-ms-filter-function-progid>|<-ms-filter-function-legacy>", "-ms-filter-function-progid": "'progid:' [<ident-token> '.']* [<ident-token>|<function-token> <any-value>? )]", "-ms-filter-function-legacy": "<ident-token>|<function-token> <any-value>? )", age: "child|young|old", "attr-name": "<wq-name>", "attr-fallback": "<any-value>", bottom: "<length>|auto", "cubic-bezier-easing-function": "ease|ease-in|ease-out|ease-in-out|cubic-bezier( <number [0,1]> , <number> , <number [0,1]> , <number> )", "generic-voice": "[<age>? <gender> <integer>?]", gender: "male|female|neutral", "generic-script-specific": "generic( kai )|generic( fangsong )|generic( nastaliq )", "-non-standard-generic-family": "-apple-system|BlinkMacSystemFont", "intrinsic-size-keyword": "min-content|max-content|fit-content", left: "<length>|auto", "device-cmyk()": "<legacy-device-cmyk-syntax>|<modern-device-cmyk-syntax>", "legacy-device-cmyk-syntax": "device-cmyk( <number>#{4} )", "modern-device-cmyk-syntax": "device-cmyk( <cmyk-component>{4} [/ [<alpha-value>|none]]? )", "cmyk-component": "<number>|<percentage>|none", "color-space": "<rectangular-color-space>|<polar-color-space>|<custom-color-space>", right: "<length>|auto", "forgiving-selector-list": "<complex-real-selector-list>", "forgiving-relative-selector-list": "<relative-real-selector-list>", "complex-real-selector-list": "<complex-real-selector>#", "simple-selector-list": "<simple-selector>#", "relative-real-selector-list": "<relative-real-selector>#", "complex-selector-unit": "[<compound-selector>? <pseudo-compound-selector>*]!", "complex-real-selector": "<compound-selector> [<combinator>? <compound-selector>]*", "relative-real-selector": "<combinator>? <complex-real-selector>", "pseudo-compound-selector": "<pseudo-element-selector> <pseudo-class-selector>*", "simple-selector": "<type-selector>|<subclass-selector>", "legacy-pseudo-element-selector": "':' [before|after|first-line|first-letter]", "svg-length": "<percentage>|<length>|<number>", "svg-writing-mode": "lr-tb|rl-tb|tb-rl|lr|rl|tb", top: "<length>|auto", x: "<number>", y: "<number>", declaration: "<ident-token> : <declaration-value>? ['!' important]?", "declaration-list": "[<declaration>? ';']* <declaration>?", url: "url( <string> <url-modifier>* )|<url-token>", "url-modifier": "<ident>|<function-token> <any-value> )", "number-zero-one": "<number [0,1]>", "number-one-or-greater": "<number [1,\u221E]>", "xyz-space": "xyz|xyz-d50|xyz-d65", "style-condition": "not <style-in-parens>|<style-in-parens> [[and <style-in-parens>]*|[or <style-in-parens>]*]", "-non-standard-display": "-ms-inline-flexbox|-ms-grid|-ms-inline-grid|-webkit-flex|-webkit-inline-flex|-webkit-box|-webkit-inline-box|-moz-inline-stack|-moz-box|-moz-inline-box", "inset-area": "[[left|center|right|span-left|span-right|x-start|x-end|span-x-start|span-x-end|x-self-start|x-self-end|span-x-self-start|span-x-self-end|span-all]||[top|center|bottom|span-top|span-bottom|y-start|y-end|span-y-start|span-y-end|y-self-start|y-self-end|span-y-self-start|span-y-self-end|span-all]|[block-start|center|block-end|span-block-start|span-block-end|span-all]||[inline-start|center|inline-end|span-inline-start|span-inline-end|span-all]|[self-block-start|self-block-end|span-self-block-start|span-self-block-end|span-all]||[self-inline-start|self-inline-end|span-self-inline-start|span-self-inline-end|span-all]|[start|center|end|span-start|span-end|span-all]{1,2}|[self-start|center|self-end|span-self-start|span-self-end|span-all]{1,2}]", "font-variant-css2": "normal|small-caps", "font-width-css3": "normal|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded", "system-family-name": "caption|icon|menu|message-box|small-caption|status-bar" }, properties: { "--*": "<declaration-value>", "-ms-accelerator": "false|true", "-ms-block-progression": "tb|rl|bt|lr", "-ms-content-zoom-chaining": "none|chained", "-ms-content-zoom-limit": "<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>", "-ms-content-zoom-limit-max": "<percentage>", "-ms-content-zoom-limit-min": "<percentage>", "-ms-content-zoom-snap": "<'-ms-content-zoom-snap-type'>||<'-ms-content-zoom-snap-points'>", "-ms-content-zoom-snap-points": "snapInterval( <percentage> , <percentage> )|snapList( <percentage># )", "-ms-content-zoom-snap-type": "none|proximity|mandatory", "-ms-content-zooming": "none|zoom", "-ms-filter": "<string>", "-ms-flow-from": "[none|<custom-ident>]#", "-ms-flow-into": "[none|<custom-ident>]#", "-ms-grid-columns": "none|<track-list>|<auto-track-list>", "-ms-grid-rows": "none|<track-list>|<auto-track-list>", "-ms-high-contrast-adjust": "auto|none", "-ms-hyphenate-limit-chars": "auto|<integer>{1,3}", "-ms-hyphenate-limit-lines": "no-limit|<integer>", "-ms-hyphenate-limit-zone": "<percentage>|<length>", "-ms-ime-align": "auto|after", "-ms-overflow-style": "auto|none|scrollbar|-ms-autohiding-scrollbar", "-ms-scroll-chaining": "chained|none", "-ms-scroll-limit": "<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>", "-ms-scroll-limit-x-max": "auto|<length>", "-ms-scroll-limit-x-min": "<length>", "-ms-scroll-limit-y-max": "auto|<length>", "-ms-scroll-limit-y-min": "<length>", "-ms-scroll-rails": "none|railed", "-ms-scroll-snap-points-x": "snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )", "-ms-scroll-snap-points-y": "snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )", "-ms-scroll-snap-type": "none|proximity|mandatory", "-ms-scroll-snap-x": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>", "-ms-scroll-snap-y": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>", "-ms-scroll-translation": "none|vertical-to-horizontal", "-ms-scrollbar-3dlight-color": "<color>", "-ms-scrollbar-arrow-color": "<color>", "-ms-scrollbar-base-color": "<color>", "-ms-scrollbar-darkshadow-color": "<color>", "-ms-scrollbar-face-color": "<color>", "-ms-scrollbar-highlight-color": "<color>", "-ms-scrollbar-shadow-color": "<color>", "-ms-scrollbar-track-color": "<color>", "-ms-text-autospace": "none|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space", "-ms-touch-select": "grippers|none", "-ms-user-select": "none|element|text", "-ms-wrap-flow": "auto|both|start|end|maximum|clear", "-ms-wrap-margin": "<length>", "-ms-wrap-through": "wrap|none", "-moz-appearance": "none|button|button-arrow-down|button-arrow-next|button-arrow-previous|button-arrow-up|button-bevel|button-focus|caret|checkbox|checkbox-container|checkbox-label|checkmenuitem|dualbutton|groupbox|listbox|listitem|menuarrow|menubar|menucheckbox|menuimage|menuitem|menuitemtext|menulist|menulist-button|menulist-text|menulist-textfield|menupopup|menuradio|menuseparator|meterbar|meterchunk|progressbar|progressbar-vertical|progresschunk|progresschunk-vertical|radio|radio-container|radio-label|radiomenuitem|range|range-thumb|resizer|resizerpanel|scale-horizontal|scalethumbend|scalethumb-horizontal|scalethumbstart|scalethumbtick|scalethumb-vertical|scale-vertical|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|separator|sheet|spinner|spinner-downbutton|spinner-textfield|spinner-upbutton|splitter|statusbar|statusbarpanel|tab|tabpanel|tabpanels|tab-scroll-arrow-back|tab-scroll-arrow-forward|textfield|textfield-multiline|toolbar|toolbarbutton|toolbarbutton-dropdown|toolbargripper|toolbox|tooltip|treeheader|treeheadercell|treeheadersortarrow|treeitem|treeline|treetwisty|treetwistyopen|treeview|-moz-mac-unified-toolbar|-moz-win-borderless-glass|-moz-win-browsertabbar-toolbox|-moz-win-communicationstext|-moz-win-communications-toolbox|-moz-win-exclude-glass|-moz-win-glass|-moz-win-mediatext|-moz-win-media-toolbox|-moz-window-button-box|-moz-window-button-box-maximized|-moz-window-button-close|-moz-window-button-maximize|-moz-window-button-minimize|-moz-window-button-restore|-moz-window-frame-bottom|-moz-window-frame-left|-moz-window-frame-right|-moz-window-titlebar|-moz-window-titlebar-maximized", "-moz-binding": "<url>|none", "-moz-border-bottom-colors": "<color>+|none", "-moz-border-left-colors": "<color>+|none", "-moz-border-right-colors": "<color>+|none", "-moz-border-top-colors": "<color>+|none", "-moz-context-properties": "none|[fill|fill-opacity|stroke|stroke-opacity]#", "-moz-float-edge": "border-box|content-box|margin-box|padding-box", "-moz-force-broken-image-icon": "0|1", "-moz-image-region": "<shape>|auto", "-moz-orient": "inline|block|horizontal|vertical", "-moz-outline-radius": "<outline-radius>{1,4} [/ <outline-radius>{1,4}]?", "-moz-outline-radius-bottomleft": "<outline-radius>", "-moz-outline-radius-bottomright": "<outline-radius>", "-moz-outline-radius-topleft": "<outline-radius>", "-moz-outline-radius-topright": "<outline-radius>", "-moz-stack-sizing": "ignore|stretch-to-fit", "-moz-text-blink": "none|blink", "-moz-user-focus": "ignore|normal|select-after|select-before|select-menu|select-same|select-all|none", "-moz-user-input": "auto|none|enabled|disabled", "-moz-user-modify": "read-only|read-write|write-only", "-moz-window-dragging": "drag|no-drag", "-moz-window-shadow": "default|menu|tooltip|sheet|none", "-webkit-appearance": "none|button|button-bevel|caps-lock-indicator|caret|checkbox|default-button|inner-spin-button|listbox|listitem|media-controls-background|media-controls-fullscreen-background|media-current-time-display|media-enter-fullscreen-button|media-exit-fullscreen-button|media-fullscreen-button|media-mute-button|media-overlay-play-button|media-play-button|media-seek-back-button|media-seek-forward-button|media-slider|media-sliderthumb|media-time-remaining-display|media-toggle-closed-captions-button|media-volume-slider|media-volume-slider-container|media-volume-sliderthumb|menulist|menulist-button|menulist-text|menulist-textfield|meter|progress-bar|progress-bar-value|push-button|radio|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbargripper-horizontal|scrollbargripper-vertical|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|searchfield-cancel-button|searchfield-decoration|searchfield-results-button|searchfield-results-decoration|slider-horizontal|slider-vertical|sliderthumb-horizontal|sliderthumb-vertical|square-button|textarea|textfield|-apple-pay-button", "-webkit-border-before": "<'border-width'>||<'border-style'>||<color>", "-webkit-border-before-color": "<color>", "-webkit-border-before-style": "<'border-style'>", "-webkit-border-before-width": "<'border-width'>", "-webkit-box-reflect": "[above|below|right|left]? <length>? <image>?", "-webkit-line-clamp": "none|<integer>", "-webkit-mask": "[<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||[<visual-box>|border|padding|content|text]||[<visual-box>|border|padding|content]]#", "-webkit-mask-attachment": "<attachment>#", "-webkit-mask-clip": "[<coord-box>|no-clip|border|padding|content|text]#", "-webkit-mask-composite": "<composite-style>#", "-webkit-mask-image": "<mask-reference>#", "-webkit-mask-origin": "[<coord-box>|border|padding|content]#", "-webkit-mask-position": "<position>#", "-webkit-mask-position-x": "[<length-percentage>|left|center|right]#", "-webkit-mask-position-y": "[<length-percentage>|top|center|bottom]#", "-webkit-mask-repeat": "<repeat-style>#", "-webkit-mask-repeat-x": "repeat|no-repeat|space|round", "-webkit-mask-repeat-y": "repeat|no-repeat|space|round", "-webkit-mask-size": "<bg-size>#", "-webkit-overflow-scrolling": "auto|touch", "-webkit-tap-highlight-color": "<color>", "-webkit-text-fill-color": "<color>", "-webkit-text-stroke": "<length>||<color>", "-webkit-text-stroke-color": "<color>", "-webkit-text-stroke-width": "<length>", "-webkit-touch-callout": "default|none", "-webkit-user-modify": "read-only|read-write|read-write-plaintext-only", "-webkit-user-select": "auto|none|text|all", "accent-color": "auto|<color>", "align-content": "normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>", "align-items": "normal|stretch|<baseline-position>|[<overflow-position>? <self-position>]", "align-self": "auto|normal|stretch|<baseline-position>|<overflow-position>? <self-position>", "align-tracks": "[normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>]#", "alignment-baseline": "auto|baseline|before-edge|text-before-edge|middle|central|after-edge|text-after-edge|ideographic|alphabetic|hanging|mathematical", all: "initial|inherit|unset|revert|revert-layer", "anchor-name": "none|<dashed-ident>#", "anchor-scope": "none|all|<dashed-ident>#", animation: "<single-animation>#", "animation-composition": "<single-animation-composition>#", "animation-delay": "<time>#", "animation-direction": "<single-animation-direction>#", "animation-duration": "<time>#", "animation-fill-mode": "<single-animation-fill-mode>#", "animation-iteration-count": "<single-animation-iteration-count>#", "animation-name": "[none|<keyframes-name>]#", "animation-play-state": "<single-animation-play-state>#", "animation-range": "[<'animation-range-start'> <'animation-range-end'>?]#", "animation-range-end": "[normal|<length-percentage>|<timeline-range-name> <length-percentage>?]#", "animation-range-start": "[normal|<length-percentage>|<timeline-range-name> <length-percentage>?]#", "animation-timeline": "<single-animation-timeline>#", "animation-timing-function": "<easing-function>#", appearance: "none|auto|textfield|menulist-button|<compat-auto>", "aspect-ratio": "auto||<ratio>", "backdrop-filter": "none|<filter-value-list>", "backface-visibility": "visible|hidden", background: "[<bg-layer> ,]* <final-bg-layer>", "background-attachment": "<attachment>#", "background-blend-mode": "<blend-mode>#", "background-clip": "<bg-clip>#", "background-color": "<color>", "background-image": "<bg-image>#", "background-origin": "<visual-box>#", "background-position": "<bg-position>#", "background-position-x": "[center|[[left|right|x-start|x-end]? <length-percentage>?]!]#", "background-position-y": "[center|[[top|bottom|y-start|y-end]? <length-percentage>?]!]#", "background-repeat": "<repeat-style>#", "background-size": "<bg-size>#", "baseline-shift": "baseline|sub|super|<svg-length>", "block-size": "<'width'>", border: "<line-width>||<line-style>||<color>", "border-block": "<'border-block-start'>", "border-block-color": "<'border-top-color'>{1,2}", "border-block-end": "<'border-top-width'>||<'border-top-style'>||<color>", "border-block-end-color": "<'border-top-color'>", "border-block-end-style": "<'border-top-style'>", "border-block-end-width": "<'border-top-width'>", "border-block-start": "<'border-top-width'>||<'border-top-style'>||<color>", "border-block-start-color": "<'border-top-color'>", "border-block-start-style": "<'border-top-style'>", "border-block-start-width": "<'border-top-width'>", "border-block-style": "<'border-top-style'>{1,2}", "border-block-width": "<'border-top-width'>{1,2}", "border-bottom": "<line-width>||<line-style>||<color>", "border-bottom-color": "<'border-top-color'>", "border-bottom-left-radius": "<length-percentage>{1,2}", "border-bottom-right-radius": "<length-percentage>{1,2}", "border-bottom-style": "<line-style>", "border-bottom-width": "<line-width>", "border-collapse": "collapse|separate", "border-color": "<color>{1,4}", "border-end-end-radius": "<'border-top-left-radius'>", "border-end-start-radius": "<'border-top-left-radius'>", "border-image": "<'border-image-source'>||<'border-image-slice'> [/ <'border-image-width'>|/ <'border-image-width'>? / <'border-image-outset'>]?||<'border-image-repeat'>", "border-image-outset": "[<length>|<number>]{1,4}", "border-image-repeat": "[stretch|repeat|round|space]{1,2}", "border-image-slice": "<number-percentage>{1,4}&&fill?", "border-image-source": "none|<image>", "border-image-width": "[<length-percentage>|<number>|auto]{1,4}", "border-inline": "<'border-block-start'>", "border-inline-color": "<'border-top-color'>{1,2}", "border-inline-end": "<'border-top-width'>||<'border-top-style'>||<color>", "border-inline-end-color": "<'border-top-color'>", "border-inline-end-style": "<'border-top-style'>", "border-inline-end-width": "<'border-top-width'>", "border-inline-start": "<'border-top-width'>||<'border-top-style'>||<color>", "border-inline-start-color": "<'border-top-color'>", "border-inline-start-style": "<'border-top-style'>", "border-inline-start-width": "<'border-top-width'>", "border-inline-style": "<'border-top-style'>{1,2}", "border-inline-width": "<'border-top-width'>{1,2}", "border-left": "<line-width>||<line-style>||<color>", "border-left-color": "<color>", "border-left-style": "<line-style>", "border-left-width": "<line-width>", "border-radius": "<length-percentage>{1,4} [/ <length-percentage>{1,4}]?", "border-right": "<line-width>||<line-style>||<color>", "border-right-color": "<color>", "border-right-style": "<line-style>", "border-right-width": "<line-width>", "border-spacing": "<length> <length>?", "border-start-end-radius": "<'border-top-left-radius'>", "border-start-start-radius": "<'border-top-left-radius'>", "border-style": "<line-style>{1,4}", "border-top": "<line-width>||<line-style>||<color>", "border-top-color": "<color>", "border-top-left-radius": "<length-percentage>{1,2}", "border-top-right-radius": "<length-percentage>{1,2}", "border-top-style": "<line-style>", "border-top-width": "<line-width>", "border-width": "<line-width>{1,4}", bottom: "<length>|<percentage>|auto", "box-align": "start|center|end|baseline|stretch", "box-decoration-break": "slice|clone", "box-direction": "normal|reverse|inherit", "box-flex": "<number>", "box-flex-group": "<integer>", "box-lines": "single|multiple", "box-ordinal-group": "<integer>", "box-orient": "horizontal|vertical|inline-axis|block-axis|inherit", "box-pack": "start|center|end|justify", "box-shadow": "none|<shadow>#", "box-sizing": "content-box|border-box", "break-after": "auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region", "break-before": "auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region", "break-inside": "auto|avoid|avoid-page|avoid-column|avoid-region", "caption-side": "top|bottom", caret: "<'caret-color'>||<'caret-shape'>", "caret-color": "auto|<color>", "caret-shape": "auto|bar|block|underscore", clear: "none|left|right|both|inline-start|inline-end", clip: "<shape>|auto", "clip-path": "<clip-source>|[<basic-shape>||<geometry-box>]|none", "clip-rule": "nonzero|evenodd", color: "<color>", "color-interpolation-filters": "auto|sRGB|linearRGB", "color-scheme": "normal|[light|dark|<custom-ident>]+&&only?", "column-count": "<integer>|auto", "column-fill": "auto|balance", "column-gap": "normal|<length-percentage>", "column-rule": "<'column-rule-width'>||<'column-rule-style'>||<'column-rule-color'>", "column-rule-color": "<color>", "column-rule-style": "<'border-style'>", "column-rule-width": "<'border-width'>", "column-span": "none|all", "column-width": "<length>|auto", columns: "<'column-width'>||<'column-count'>", contain: "none|strict|content|[[size||inline-size]||layout||style||paint]", "contain-intrinsic-block-size": "auto? [none|<length>]", "contain-intrinsic-height": "auto? [none|<length>]", "contain-intrinsic-inline-size": "auto? [none|<length>]", "contain-intrinsic-size": "[auto? [none|<length>]]{1,2}", "contain-intrinsic-width": "auto? [none|<length>]", container: "<'container-name'> [/ <'container-type'>]?", "container-name": "none|<custom-ident>+", "container-type": "normal|[[size|inline-size]||scroll-state]", content: "normal|none|[<content-replacement>|<content-list>] [/ [<string>|<counter>]+]?", "content-visibility": "visible|auto|hidden", "counter-increment": "[<counter-name> <integer>?]+|none", "counter-reset": "[<counter-name> <integer>?|<reversed-counter-name> <integer>?]+|none", "counter-set": "[<counter-name> <integer>?]+|none", cursor: "[[<url> [<x> <y>]? ,]* [auto|default|none|context-menu|help|pointer|progress|wait|cell|crosshair|text|vertical-text|alias|copy|move|no-drop|not-allowed|e-resize|n-resize|ne-resize|nw-resize|s-resize|se-resize|sw-resize|w-resize|ew-resize|ns-resize|nesw-resize|nwse-resize|col-resize|row-resize|all-scroll|zoom-in|zoom-out|grab|grabbing|hand|-webkit-grab|-webkit-grabbing|-webkit-zoom-in|-webkit-zoom-out|-moz-grab|-moz-grabbing|-moz-zoom-in|-moz-zoom-out]]", cx: "<length>|<percentage>", cy: "<length>|<percentage>", d: "none|path( <string> )", direction: "ltr|rtl", display: "[<display-outside>||<display-inside>]|<display-listitem>|<display-internal>|<display-box>|<display-legacy>|<-non-standard-display>", "dominant-baseline": "auto|use-script|no-change|reset-size|ideographic|alphabetic|hanging|mathematical|central|middle|text-after-edge|text-before-edge", "empty-cells": "show|hide", "field-sizing": "content|fixed", fill: "<paint>", "fill-opacity": "<number-zero-one>", "fill-rule": "nonzero|evenodd", filter: "none|<filter-value-list>|<-ms-filter-function-list>", flex: "none|[<'flex-grow'> <'flex-shrink'>?||<'flex-basis'>]", "flex-basis": "content|<'width'>", "flex-direction": "row|row-reverse|column|column-reverse", "flex-flow": "<'flex-direction'>||<'flex-wrap'>", "flex-grow": "<number>", "flex-shrink": "<number>", "flex-wrap": "nowrap|wrap|wrap-reverse", float: "left|right|none|inline-start|inline-end", "flood-color": "<color>", "flood-opacity": "<'opacity'>", font: "[[<'font-style'>||<font-variant-css2>||<'font-weight'>||<font-width-css3>]? <'font-size'> [/ <'line-height'>]? <'font-family'>#]|<system-family-name>|<-non-standard-font>", "font-family": "[<family-name>|<generic-family>]#", "font-feature-settings": "normal|<feature-tag-value>#", "font-kerning": "auto|normal|none", "font-language-override": "normal|<string>", "font-optical-sizing": "auto|none", "font-palette": "normal|light|dark|<palette-identifier>|<palette-mix()>", "font-size": "<absolute-size>|<relative-size>|<length-percentage [0,\u221E]>|math", "font-size-adjust": "none|[ex-height|cap-height|ch-width|ic-width|ic-height]? [from-font|<number>]", "font-smooth": "auto|never|always|<absolute-size>|<length>", "font-stretch": "<font-stretch-absolute>", "font-style": "normal|italic|oblique <angle>?", "font-synthesis": "none|[weight||style||small-caps||position]", "font-synthesis-position": "auto|none", "font-synthesis-small-caps": "auto|none", "font-synthesis-style": "auto|none", "font-synthesis-weight": "auto|none", "font-variant": "normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>||stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )||[small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps]||<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero||<east-asian-variant-values>||<east-asian-width-values>||ruby]", "font-variant-alternates": "normal|[stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )]", "font-variant-caps": "normal|small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps", "font-variant-east-asian": "normal|[<east-asian-variant-values>||<east-asian-width-values>||ruby]", "font-variant-emoji": "normal|text|emoji|unicode", "font-variant-ligatures": "normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>]", "font-variant-numeric": "normal|[<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero]", "font-variant-position": "normal|sub|super", "font-variation-settings": "normal|[<string> <number>]#", "font-weight": "<font-weight-absolute>|bolder|lighter", "forced-color-adjust": "auto|none|preserve-parent-color", gap: "<'row-gap'> <'column-gap'>?", grid: "<'grid-template'>|<'grid-template-rows'> / [auto-flow&&dense?] <'grid-auto-columns'>?|[auto-flow&&dense?] <'grid-auto-rows'>? / <'grid-template-columns'>", "grid-area": "<grid-line> [/ <grid-line>]{0,3}", "grid-auto-columns": "<track-size>+", "grid-auto-flow": "[row|column]||dense", "grid-auto-rows": "<track-size>+", "grid-column": "<grid-line> [/ <grid-line>]?", "grid-column-end": "<grid-line>", "grid-column-gap": "<length-percentage>", "grid-column-start": "<grid-line>", "grid-gap": "<'grid-row-gap'> <'grid-column-gap'>?", "grid-row": "<grid-line> [/ <grid-line>]?", "grid-row-end": "<grid-line>", "grid-row-gap": "<length-percentage>", "grid-row-start": "<grid-line>", "grid-template": "none|[<'grid-template-rows'> / <'grid-template-columns'>]|[<line-names>? <string> <track-size>? <line-names>?]+ [/ <explicit-track-list>]?", "grid-template-areas": "none|<string>+", "grid-template-columns": "none|<track-list>|<auto-track-list>|subgrid <line-name-list>?", "grid-template-rows": "none|<track-list>|<auto-track-list>|subgrid <line-name-list>?", "hanging-punctuation": "none|[first||[force-end|allow-end]||last]", height: "auto|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "hyphenate-character": "auto|<string>", "hyphenate-limit-chars": "[auto|<integer>]{1,3}", hyphens: "none|manual|auto", "image-orientation": "from-image|<angle>|[<angle>? flip]", "image-rendering": "auto|crisp-edges|pixelated|smooth|optimizeSpeed|optimizeQuality|<-non-standard-image-rendering>", "image-resolution": "[from-image||<resolution>]&&snap?", "ime-mode": "auto|normal|active|inactive|disabled", "initial-letter": "normal|[<number> <integer>?]", "initial-letter-align": "[auto|alphabetic|hanging|ideographic]", "inline-size": "<'width'>", inset: "<'top'>{1,4}", "inset-block": "<'top'>{1,2}", "inset-block-end": "<'top'>", "inset-block-start": "<'top'>", "inset-inline": "<'top'>{1,2}", "inset-inline-end": "<'top'>", "inset-inline-start": "<'top'>", "interpolate-size": "numeric-only|allow-keywords", isolation: "auto|isolate", "justify-content": "normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]", "justify-items": "normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]|legacy|legacy&&[left|right|center]", "justify-self": "auto|normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]", "justify-tracks": "[normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]]#", left: "<length>|<percentage>|auto", "letter-spacing": "normal|<length-percentage>", "lighting-color": "<color>", "line-break": "auto|loose|normal|strict|anywhere", "line-clamp": "none|<integer>", "line-height": "normal|<number>|<length>|<percentage>", "line-height-step": "<length>", "list-style": "<'list-style-type'>||<'list-style-position'>||<'list-style-image'>", "list-style-image": "<image>|none", "list-style-position": "inside|outside", "list-style-type": "<counter-style>|<string>|none", margin: "<'margin-top'>{1,4}", "margin-block": "<'margin-top'>{1,2}", "margin-block-end": "<'margin-top'>", "margin-block-start": "<'margin-top'>", "margin-bottom": "<length-percentage>|auto", "margin-inline": "<'margin-top'>{1,2}", "margin-inline-end": "<'margin-top'>", "margin-inline-start": "<'margin-top'>", "margin-left": "<length-percentage>|auto", "margin-right": "<length-percentage>|auto", "margin-top": "<length-percentage>|auto", "margin-trim": "none|in-flow|all", marker: "none|<url>", "marker-end": "none|<url>", "marker-mid": "none|<url>", "marker-start": "none|<url>", mask: "<mask-layer>#", "mask-border": "<'mask-border-source'>||<'mask-border-slice'> [/ <'mask-border-width'>? [/ <'mask-border-outset'>]?]?||<'mask-border-repeat'>||<'mask-border-mode'>", "mask-border-mode": "luminance|alpha", "mask-border-outset": "[<length>|<number>]{1,4}", "mask-border-repeat": "[stretch|repeat|round|space]{1,2}", "mask-border-slice": "<number-percentage>{1,4} fill?", "mask-border-source": "none|<image>", "mask-border-width": "[<length-percentage>|<number>|auto]{1,4}", "mask-clip": "[<coord-box>|no-clip]#", "mask-composite": "<compositing-operator>#", "mask-image": "<mask-reference>#", "mask-mode": "<masking-mode>#", "mask-origin": "<coord-box>#", "mask-position": "<position>#", "mask-repeat": "<repeat-style>#", "mask-size": "<bg-size>#", "mask-type": "luminance|alpha", "masonry-auto-flow": "[pack|next]||[definite-first|ordered]", "math-depth": "auto-add|add( <integer> )|<integer>", "math-shift": "normal|compact", "math-style": "normal|compact", "max-block-size": "<'max-width'>", "max-height": "none|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "max-inline-size": "<'max-width'>", "max-lines": "none|<integer>", "max-width": "none|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "min-block-size": "<'min-width'>", "min-height": "auto|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "min-inline-size": "<'min-width'>", "min-width": "auto|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "mix-blend-mode": "<blend-mode>|plus-lighter", "object-fit": "fill|contain|cover|none|scale-down", "object-position": "<position>", "object-view-box": "none|<basic-shape-rect>", offset: "[<'offset-position'>? [<'offset-path'> [<'offset-distance'>||<'offset-rotate'>]?]?]! [/ <'offset-anchor'>]?", "offset-anchor": "auto|<position>", "offset-distance": "<length-percentage>", "offset-path": "none|<offset-path>||<coord-box>", "offset-position": "normal|auto|<position>", "offset-rotate": "[auto|reverse]||<angle>", opacity: "<opacity-value>", order: "<integer>", orphans: "<integer>", outline: "<'outline-width'>||<'outline-style'>||<'outline-color'>", "outline-color": "auto|<color>", "outline-offset": "<length>", "outline-style": "auto|<outline-line-style>", "outline-width": "<line-width>", overflow: "[visible|hidden|clip|scroll|auto]{1,2}|<-non-standard-overflow>", "overflow-anchor": "auto|none", "overflow-block": "visible|hidden|clip|scroll|auto", "overflow-clip-box": "padding-box|content-box", "overflow-clip-margin": "<visual-box>||<length [0,\u221E]>", "overflow-inline": "visible|hidden|clip|scroll|auto", "overflow-wrap": "normal|break-word|anywhere", "overflow-x": "visible|hidden|clip|scroll|auto|<-non-standard-overflow>", "overflow-y": "visible|hidden|clip|scroll|auto|<-non-standard-overflow>", overlay: "none|auto", "overscroll-behavior": "[contain|none|auto]{1,2}", "overscroll-behavior-block": "contain|none|auto", "overscroll-behavior-inline": "contain|none|auto", "overscroll-behavior-x": "contain|none|auto", "overscroll-behavior-y": "contain|none|auto", padding: "<'padding-top'>{1,4}", "padding-block": "<'padding-top'>{1,2}", "padding-block-end": "<'padding-top'>", "padding-block-start": "<'padding-top'>", "padding-bottom": "<length-percentage [0,\u221E]>", "padding-inline": "<'padding-top'>{1,2}", "padding-inline-end": "<'padding-top'>", "padding-inline-start": "<'padding-top'>", "padding-left": "<length-percentage [0,\u221E]>", "padding-right": "<length-percentage [0,\u221E]>", "padding-top": "<length-percentage [0,\u221E]>", page: "auto|<custom-ident>", "page-break-after": "auto|always|avoid|left|right|recto|verso", "page-break-before": "auto|always|avoid|left|right|recto|verso", "page-break-inside": "auto|avoid", "paint-order": "normal|[fill||stroke||markers]", perspective: "none|<length>", "perspective-origin": "<position>", "place-content": "<'align-content'> <'justify-content'>?", "place-items": "<'align-items'> <'justify-items'>?", "place-self": "<'align-self'> <'justify-self'>?", "pointer-events": "auto|none|visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|inherit", position: "static|relative|absolute|sticky|fixed|-webkit-sticky", "position-anchor": "auto|<anchor-name>", "position-area": "none|<position-area>", "position-try": "<'position-try-order'>? <'position-try-fallbacks'>", "position-try-fallbacks": "none|[[<dashed-ident>||<try-tactic>]|<'position-area'>]#", "position-try-order": "normal|<try-size>", "position-visibility": "always|[anchors-valid||anchors-visible||no-overflow]", "print-color-adjust": "economy|exact", quotes: "none|auto|[<string> <string>]+", r: "<length>|<percentage>", resize: "none|both|horizontal|vertical|block|inline", right: "<length>|<percentage>|auto", rotate: "none|<angle>|[x|y|z|<number>{3}]&&<angle>", "row-gap": "normal|<length-percentage>", "ruby-align": "start|center|space-between|space-around", "ruby-merge": "separate|collapse|auto", "ruby-position": "[alternate||[over|under]]|inter-character", rx: "<length>|<percentage>", ry: "<length>|<percentage>", scale: "none|[<number>|<percentage>]{1,3}", "scroll-behavior": "auto|smooth", "scroll-initial-target": "none|nearest", "scroll-margin": "<length>{1,4}", "scroll-margin-block": "<length>{1,2}", "scroll-margin-block-end": "<length>", "scroll-margin-block-start": "<length>", "scroll-margin-bottom": "<length>", "scroll-margin-inline": "<length>{1,2}", "scroll-margin-inline-end": "<length>", "scroll-margin-inline-start": "<length>", "scroll-margin-left": "<length>", "scroll-margin-right": "<length>", "scroll-margin-top": "<length>", "scroll-padding": "[auto|<length-percentage>]{1,4}", "scroll-padding-block": "[auto|<length-percentage>]{1,2}", "scroll-padding-block-end": "auto|<length-percentage>", "scroll-padding-block-start": "auto|<length-percentage>", "scroll-padding-bottom": "auto|<length-percentage>", "scroll-padding-inline": "[auto|<length-percentage>]{1,2}", "scroll-padding-inline-end": "auto|<length-percentage>", "scroll-padding-inline-start": "auto|<length-percentage>", "scroll-padding-left": "auto|<length-percentage>", "scroll-padding-right": "auto|<length-percentage>", "scroll-padding-top": "auto|<length-percentage>", "scroll-snap-align": "[none|start|end|center]{1,2}", "scroll-snap-coordinate": "none|<position>#", "scroll-snap-destination": "<position>", "scroll-snap-points-x": "none|repeat( <length-percentage> )", "scroll-snap-points-y": "none|repeat( <length-percentage> )", "scroll-snap-stop": "normal|always", "scroll-snap-type": "none|[x|y|block|inline|both] [mandatory|proximity]?", "scroll-snap-type-x": "none|mandatory|proximity", "scroll-snap-type-y": "none|mandatory|proximity", "scroll-timeline": "[<'scroll-timeline-name'> <'scroll-timeline-axis'>?]#", "scroll-timeline-axis": "[block|inline|x|y]#", "scroll-timeline-name": "[none|<dashed-ident>]#", "scrollbar-color": "auto|<color>{2}", "scrollbar-gutter": "auto|stable&&both-edges?", "scrollbar-width": "auto|thin|none", "shape-image-threshold": "<opacity-value>", "shape-margin": "<length-percentage>", "shape-outside": "none|[<shape-box>||<basic-shape>]|<image>", "shape-rendering": "auto|optimizeSpeed|crispEdges|geometricPrecision", "speak-as": "normal|spell-out||digits||[literal-punctuation|no-punctuation]", "stop-color": "<'color'>", "stop-opacity": "<'opacity'>", stroke: "<paint>", "stroke-dasharray": "none|[<svg-length>+]#", "stroke-dashoffset": "<svg-length>", "stroke-linecap": "butt|round|square", "stroke-linejoin": "miter|round|bevel", "stroke-miterlimit": "<number-one-or-greater>", "stroke-opacity": "<'opacity'>", "stroke-width": "<svg-length>", "tab-size": "<integer>|<length>", "table-layout": "auto|fixed", "text-align": "start|end|left|right|center|justify|match-parent", "text-align-last": "auto|start|end|left|right|center|justify", "text-anchor": "start|middle|end", "text-box": "normal|<'text-box-trim'>||<'text-box-edge'>", "text-box-edge": "auto|<text-edge>", "text-box-trim": "none|trim-start|trim-end|trim-both", "text-combine-upright": "none|all|[digits <integer>?]", "text-decoration": "<'text-decoration-line'>||<'text-decoration-style'>||<'text-decoration-color'>||<'text-decoration-thickness'>", "text-decoration-color": "<color>", "text-decoration-line": "none|[underline||overline||line-through||blink]|spelling-error|grammar-error", "text-decoration-skip": "none|[objects||[spaces|[leading-spaces||trailing-spaces]]||edges||box-decoration]", "text-decoration-skip-ink": "auto|all|none", "text-decoration-style": "solid|double|dotted|dashed|wavy", "text-decoration-thickness": "auto|from-font|<length>|<percentage>", "text-emphasis": "<'text-emphasis-style'>||<'text-emphasis-color'>", "text-emphasis-color": "<color>", "text-emphasis-position": "auto|[over|under]&&[right|left]?", "text-emphasis-style": "none|[[filled|open]||[dot|circle|double-circle|triangle|sesame]]|<string>", "text-indent": "<length-percentage>&&hanging?&&each-line?", "text-justify": "auto|inter-character|inter-word|none", "text-orientation": "mixed|upright|sideways", "text-overflow": "[clip|ellipsis|<string>]{1,2}", "text-rendering": "auto|optimizeSpeed|optimizeLegibility|geometricPrecision", "text-shadow": "none|<shadow-t>#", "text-size-adjust": "none|auto|<percentage>", "text-spacing-trim": "space-all|normal|space-first|trim-start", "text-transform": "none|[capitalize|uppercase|lowercase]||full-width||full-size-kana|math-auto", "text-underline-offset": "auto|<length>|<percentage>", "text-underline-position": "auto|from-font|[under||[left|right]]", "text-wrap": "<'text-wrap-mode'>||<'text-wrap-style'>", "text-wrap-mode": "wrap|nowrap", "text-wrap-style": "auto|balance|stable|pretty", "timeline-scope": "none|<dashed-ident>#", top: "<length>|<percentage>|auto", "touch-action": "auto|none|[[pan-x|pan-left|pan-right]||[pan-y|pan-up|pan-down]||pinch-zoom]|manipulation", transform: "none|<transform-list>", "transform-box": "content-box|border-box|fill-box|stroke-box|view-box", "transform-origin": "[<length-percentage>|left|center|right|top|bottom]|[[<length-percentage>|left|center|right]&&[<length-percentage>|top|center|bottom]] <length>?", "transform-style": "flat|preserve-3d", transition: "<single-transition>#", "transition-behavior": "<transition-behavior-value>#", "transition-delay": "<time>#", "transition-duration": "<time>#", "transition-property": "none|<single-transition-property>#", "transition-timing-function": "<easing-function>#", translate: "none|<length-percentage> [<length-percentage> <length>?]?", "unicode-bidi": "normal|embed|isolate|bidi-override|isolate-override|plaintext|-moz-isolate|-moz-isolate-override|-moz-plaintext|-webkit-isolate|-webkit-isolate-override|-webkit-plaintext", "user-select": "auto|text|none|all", "vector-effect": "none|non-scaling-stroke|non-scaling-size|non-rotation|fixed-position", "vertical-align": "baseline|sub|super|text-top|text-bottom|middle|top|bottom|<percentage>|<length>", "view-timeline": "[<'view-timeline-name'> [<'view-timeline-axis'>||<'view-timeline-inset'>]?]#", "view-timeline-axis": "[block|inline|x|y]#", "view-timeline-inset": "[[auto|<length-percentage>]{1,2}]#", "view-timeline-name": "[none|<dashed-ident>]#", "view-transition-class": "none|<custom-ident>+", "view-transition-name": "none|<custom-ident>", visibility: "visible|hidden|collapse", "white-space": "normal|pre|pre-wrap|pre-line|<'white-space-collapse'>||<'text-wrap-mode'>", "white-space-collapse": "collapse|preserve|preserve-breaks|preserve-spaces|break-spaces", widows: "<integer>", width: "auto|<length-percentage [0,\u221E]>|min-content|max-content|fit-content|fit-content( <length-percentage [0,\u221E]> )|<calc-size()>|<anchor-size()>|stretch|<-non-standard-size>", "will-change": "auto|<animateable-feature>#", "word-break": "normal|break-all|keep-all|break-word|auto-phrase", "word-spacing": "normal|<length>", "word-wrap": "normal|break-word", "writing-mode": "horizontal-tb|vertical-rl|vertical-lr|sideways-rl|sideways-lr|<svg-writing-mode>", x: "<length>|<percentage>", y: "<length>|<percentage>", "z-index": "auto|<integer>", zoom: "normal|reset|<number [0,\u221E]>||<percentage [0,\u221E]>", "-moz-background-clip": "padding|border", "-moz-border-radius-bottomleft": "<'border-bottom-left-radius'>", "-moz-border-radius-bottomright": "<'border-bottom-right-radius'>", "-moz-border-radius-topleft": "<'border-top-left-radius'>", "-moz-border-radius-topright": "<'border-bottom-right-radius'>", "-moz-control-character-visibility": "visible|hidden", "-moz-osx-font-smoothing": "auto|grayscale", "-moz-user-select": "none|text|all|-moz-none", "-ms-flex-align": "start|end|center|baseline|stretch", "-ms-flex-item-align": "auto|start|end|center|baseline|stretch", "-ms-flex-line-pack": "start|end|center|justify|distribute|stretch", "-ms-flex-negative": "<'flex-shrink'>", "-ms-flex-pack": "start|end|center|justify|distribute", "-ms-flex-order": "<integer>", "-ms-flex-positive": "<'flex-grow'>", "-ms-flex-preferred-size": "<'flex-basis'>", "-ms-interpolation-mode": "nearest-neighbor|bicubic", "-ms-grid-column-align": "start|end|center|stretch", "-ms-grid-row-align": "start|end|center|stretch", "-ms-hyphenate-limit-last": "none|always|column|page|spread", "-webkit-background-clip": "[<visual-box>|border|padding|content|text]#", "-webkit-column-break-after": "always|auto|avoid", "-webkit-column-break-before": "always|auto|avoid", "-webkit-column-break-inside": "always|auto|avoid", "-webkit-font-smoothing": "auto|none|antialiased|subpixel-antialiased", "-webkit-mask-box-image": "[<url>|<gradient>|none] [<length-percentage>{4} <-webkit-mask-box-repeat>{2}]?", "-webkit-print-color-adjust": "economy|exact", "-webkit-text-security": "none|circle|disc|square", "-webkit-user-drag": "none|element|auto", behavior: "<url>+", cue: "<'cue-before'> <'cue-after'>?", "cue-after": "<url> <decibel>?|none", "cue-before": "<url> <decibel>?|none", "glyph-orientation-horizontal": "<angle>", "glyph-orientation-vertical": "<angle>", kerning: "auto|<svg-length>", pause: "<'pause-before'> <'pause-after'>?", "pause-after": "<time>|none|x-weak|weak|medium|strong|x-strong", "pause-before": "<time>|none|x-weak|weak|medium|strong|x-strong", "position-try-options": "<'position-try-fallbacks'>", rest: "<'rest-before'> <'rest-after'>?", "rest-after": "<time>|none|x-weak|weak|medium|strong|x-strong", "rest-before": "<time>|none|x-weak|weak|medium|strong|x-strong", speak: "auto|never|always", "voice-balance": "<number>|left|center|right|leftwards|rightwards", "voice-duration": "auto|<time>", "voice-family": "[[<family-name>|<generic-voice>] ,]* [<family-name>|<generic-voice>]|preserve", "voice-pitch": "<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]", "voice-range": "<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]", "voice-rate": "[normal|x-slow|slow|medium|fast|x-fast]||<percentage>", "voice-stress": "normal|strong|moderate|none|reduced", "voice-volume": "silent|[[x-soft|soft|medium|loud|x-loud]||<decibel>]", "white-space-trim": "none|discard-before||discard-after||discard-inner" }, atrules: { charset: { prelude: "<string>", descriptors: null }, "counter-style": { prelude: "<counter-style-name>", descriptors: { "additive-symbols": "[<integer>&&<symbol>]#", fallback: "<counter-style-name>", negative: "<symbol> <symbol>?", pad: "<integer>&&<symbol>", prefix: "<symbol>", range: "[[<integer>|infinite]{2}]#|auto", "speak-as": "auto|bullets|numbers|words|spell-out|<counter-style-name>", suffix: "<symbol>", symbols: "<symbol>+", system: "cyclic|numeric|alphabetic|symbolic|additive|[fixed <integer>?]|[extends <counter-style-name>]" } }, container: { prelude: "[<container-name>]? <container-condition>", descriptors: null }, document: { prelude: "[<url>|url-prefix( <string> )|domain( <string> )|media-document( <string> )|regexp( <string> )]#", descriptors: null }, "font-face": { prelude: null, descriptors: { "ascent-override": "normal|<percentage>", "descent-override": "normal|<percentage>", "font-display": "auto|block|swap|fallback|optional", "font-family": "<family-name>", "font-feature-settings": "normal|<feature-tag-value>#", "font-stretch": "<font-stretch-absolute>{1,2}", "font-style": "normal|italic|oblique <angle>{0,2}", "font-variation-settings": "normal|[<string> <number>]#", "font-weight": "<font-weight-absolute>{1,2}", "line-gap-override": "normal|<percentage>", "size-adjust": "<percentage>", src: "[<url> [format( <string># )]?|local( <family-name> )]#", "unicode-range": "<unicode-range-token>#" } }, "font-feature-values": { prelude: "<family-name>#", descriptors: null }, "font-palette-values": { prelude: "<dashed-ident>", descriptors: { "base-palette": "light|dark|<integer [0,\u221E]>", "font-family": "<family-name>#", "override-colors": "[<integer [0,\u221E]> <color>]#" } }, import: { prelude: "[<string>|<url>] [layer|layer( <layer-name> )]? [supports( [<supports-condition>|<declaration>] )]? <media-query-list>?", descriptors: null }, keyframes: { prelude: "<keyframes-name>", descriptors: null }, layer: { prelude: "[<layer-name>#|<layer-name>?]", descriptors: null }, media: { prelude: "<media-query-list>", descriptors: null }, namespace: { prelude: "<namespace-prefix>? [<string>|<url>]", descriptors: null }, page: { prelude: "<page-selector-list>", descriptors: { bleed: "auto|<length>", marks: "none|[crop||cross]", "page-orientation": "upright|rotate-left|rotate-right", size: "<length>{1,2}|auto|[<page-size>||[portrait|landscape]]" } }, "position-try": { prelude: "<dashed-ident>", descriptors: { top: "<'top'>", left: "<'left'>", bottom: "<'bottom'>", right: "<'right'>", "inset-block-start": "<'inset-block-start'>", "inset-block-end": "<'inset-block-end'>", "inset-inline-start": "<'inset-inline-start'>", "inset-inline-end": "<'inset-inline-end'>", "inset-block": "<'inset-block'>", "inset-inline": "<'inset-inline'>", inset: "<'inset'>", "margin-top": "<'margin-top'>", "margin-left": "<'margin-left'>", "margin-bottom": "<'margin-bottom'>", "margin-right": "<'margin-right'>", "margin-block-start": "<'margin-block-start'>", "margin-block-end": "<'margin-block-end'>", "margin-inline-start": "<'margin-inline-start'>", "margin-inline-end": "<'margin-inline-end'>", margin: "<'margin'>", "margin-block": "<'margin-block'>", "margin-inline": "<'margin-inline'>", width: "<'width'>", height: "<'height'>", "min-width": "<'min-width'>", "min-height": "<'min-height'>", "max-width": "<'max-width'>", "max-height": "<'max-height'>", "block-size": "<'block-size'>", "inline-size": "<'inline-size'>", "min-block-size": "<'min-block-size'>", "min-inline-size": "<'min-inline-size'>", "max-block-size": "<'max-block-size'>", "max-inline-size": "<'max-inline-size'>", "align-self": "<'align-self'>|anchor-center", "justify-self": "<'justify-self'>|anchor-center" } }, property: { prelude: "<custom-property-name>", descriptors: { inherits: "true|false", "initial-value": "<declaration-value>?", syntax: "<string>" } }, scope: { prelude: "[( <scope-start> )]? [to ( <scope-end> )]?", descriptors: null }, "starting-style": { prelude: null, descriptors: null }, supports: { prelude: "<supports-condition>", descriptors: null }, "view-transition": { prelude: null, descriptors: { navigation: "auto|none", types: "none|<custom-ident>+" } }, nest: { prelude: "<complex-selector-list>", descriptors: null } } };
var Ct = {};
f(Ct, { AnPlusB: () => tn, Atrule: () => nn, AtrulePrelude: () => sn, AttributeSelector: () => cn, Block: () => pn, Brackets: () => mn, CDC: () => fn, CDO: () => bn, ClassSelector: () => yn, Combinator: () => wn, Comment: () => Sn, Condition: () => Tn, Declaration: () => Ln, DeclarationList: () => Pn, Dimension: () => Dn, Feature: () => On, FeatureFunction: () => Fn, FeatureRange: () => _n, Function: () => qn, GeneralEnclosed: () => Un, Hash: () => Gn, IdSelector: () => Qn, Identifier: () => Kn, Layer: () => $n, LayerList: () => Jn, MediaQuery: () => ti, MediaQueryList: () => ni, NestingSelector: () => oi, Nth: () => ai, Number: () => ci, Operator: () => pi, Parentheses: () => mi, Percentage: () => fi, PseudoClassSelector: () => bi, PseudoElementSelector: () => yi, Ratio: () => wi, Raw: () => Si, Rule: () => Ti, Scope: () => Li, Selector: () => zi, SelectorList: () => Ii, String: () => Fi, StyleSheet: () => Bi, SupportsDeclaration: () => Wi, TypeSelector: () => Ui, UnicodeRange: () => Yi, Url: () => Zi, Value: () => eo, WhiteSpace: () => ro });
var tn = {};
f(tn, { generate: () => Xc, name: () => Vc, parse: () => en, structure: () => Qc });
var fe = 43;
var re = 45;
var er = 110;
var Re = true;
var Kc = false;
function tr(e2, t2) {
  let r = this.tokenStart + e2, n = this.charCodeAt(r);
  for ((n === fe || n === re) && (t2 && this.error("Number sign is not allowed"), r++); r < this.tokenEnd; r++) O(this.charCodeAt(r)) || this.error("Integer is expected", r);
}
function et(e2) {
  return tr.call(this, 0, e2);
}
function Ee(e2, t2) {
  if (!this.cmpChar(this.tokenStart + e2, t2)) {
    let r = "";
    switch (t2) {
      case er:
        r = "N is expected";
        break;
      case re:
        r = "HyphenMinus is expected";
        break;
    }
    this.error(r, this.tokenStart + e2);
  }
}
function Jr() {
  let e2 = 0, t2 = 0, r = this.tokenType;
  for (; r === 13 || r === 25; ) r = this.lookupType(++e2);
  if (r !== 10) if (this.isDelim(fe, e2) || this.isDelim(re, e2)) {
    t2 = this.isDelim(fe, e2) ? fe : re;
    do
      r = this.lookupType(++e2);
    while (r === 13 || r === 25);
    r !== 10 && (this.skip(e2), et.call(this, Re));
  } else return null;
  return e2 > 0 && this.skip(e2), t2 === 0 && (r = this.charCodeAt(this.tokenStart), r !== fe && r !== re && this.error("Number sign is expected")), et.call(this, t2 !== 0), t2 === re ? "-" + this.consume(10) : this.consume(10);
}
var Vc = "AnPlusB";
var Qc = { a: [String, null], b: [String, null] };
function en() {
  let e2 = this.tokenStart, t2 = null, r = null;
  if (this.tokenType === 10) et.call(this, Kc), r = this.consume(10);
  else if (this.tokenType === 1 && this.cmpChar(this.tokenStart, re)) switch (t2 = "-1", Ee.call(this, 1, er), this.tokenEnd - this.tokenStart) {
    case 2:
      this.next(), r = Jr.call(this);
      break;
    case 3:
      Ee.call(this, 2, re), this.next(), this.skipSC(), et.call(this, Re), r = "-" + this.consume(10);
      break;
    default:
      Ee.call(this, 2, re), tr.call(this, 3, Re), this.next(), r = this.substrToCursor(e2 + 2);
  }
  else if (this.tokenType === 1 || this.isDelim(fe) && this.lookupType(1) === 1) {
    let n = 0;
    switch (t2 = "1", this.isDelim(fe) && (n = 1, this.next()), Ee.call(this, 0, er), this.tokenEnd - this.tokenStart) {
      case 1:
        this.next(), r = Jr.call(this);
        break;
      case 2:
        Ee.call(this, 1, re), this.next(), this.skipSC(), et.call(this, Re), r = "-" + this.consume(10);
        break;
      default:
        Ee.call(this, 1, re), tr.call(this, 2, Re), this.next(), r = this.substrToCursor(e2 + n + 1);
    }
  } else if (this.tokenType === 12) {
    let n = this.charCodeAt(this.tokenStart), i = n === fe || n === re, o = this.tokenStart + i;
    for (; o < this.tokenEnd && O(this.charCodeAt(o)); o++) ;
    o === this.tokenStart + i && this.error("Integer is expected", this.tokenStart + i), Ee.call(this, o - this.tokenStart, er), t2 = this.substring(e2, o), o + 1 === this.tokenEnd ? (this.next(), r = Jr.call(this)) : (Ee.call(this, o - this.tokenStart + 1, re), o + 2 === this.tokenEnd ? (this.next(), this.skipSC(), et.call(this, Re), r = "-" + this.consume(10)) : (tr.call(this, o - this.tokenStart + 2, Re), this.next(), r = this.substrToCursor(o + 1)));
  } else this.error();
  return t2 !== null && t2.charCodeAt(0) === fe && (t2 = t2.substr(1)), r !== null && r.charCodeAt(0) === fe && (r = r.substr(1)), { type: "AnPlusB", loc: this.getLocation(e2, this.tokenStart), a: t2, b: r };
}
function Xc(e2) {
  if (e2.a) {
    let t2 = e2.a === "+1" && "n" || e2.a === "1" && "n" || e2.a === "-1" && "-n" || e2.a + "n";
    if (e2.b) {
      let r = e2.b[0] === "-" || e2.b[0] === "+" ? e2.b : "+" + e2.b;
      this.tokenize(t2 + r);
    } else this.tokenize(t2);
  } else this.tokenize(e2.b);
}
var nn = {};
f(nn, { generate: () => tu, name: () => Zc, parse: () => rn, structure: () => eu, walkContext: () => Jc });
function _s() {
  return this.Raw(this.consumeUntilLeftCurlyBracketOrSemicolon, true);
}
function $c() {
  for (let e2 = 1, t2; t2 = this.lookupType(e2); e2++) {
    if (t2 === 24) return true;
    if (t2 === 23 || t2 === 3) return false;
  }
  return false;
}
var Zc = "Atrule";
var Jc = "atrule";
var eu = { name: String, prelude: ["AtrulePrelude", "Raw", null], block: ["Block", null] };
function rn(e2 = false) {
  let t2 = this.tokenStart, r, n, i = null, o = null;
  switch (this.eat(3), r = this.substrToCursor(t2 + 1), n = r.toLowerCase(), this.skipSC(), this.eof === false && this.tokenType !== 23 && this.tokenType !== 17 && (this.parseAtrulePrelude ? i = this.parseWithFallback(this.AtrulePrelude.bind(this, r, e2), _s) : i = _s.call(this, this.tokenIndex), this.skipSC()), this.tokenType) {
    case 17:
      this.next();
      break;
    case 23:
      hasOwnProperty.call(this.atrule, n) && typeof this.atrule[n].block == "function" ? o = this.atrule[n].block.call(this, e2) : o = this.Block($c.call(this));
      break;
  }
  return { type: "Atrule", loc: this.getLocation(t2, this.tokenStart), name: r, prelude: i, block: o };
}
function tu(e2) {
  this.token(3, "@" + e2.name), e2.prelude !== null && this.node(e2.prelude), e2.block ? this.node(e2.block) : this.token(17, ";");
}
var sn = {};
f(sn, { generate: () => ou, name: () => ru, parse: () => on, structure: () => iu, walkContext: () => nu });
var ru = "AtrulePrelude";
var nu = "atrulePrelude";
var iu = { children: [[]] };
function on(e2) {
  let t2 = null;
  return e2 !== null && (e2 = e2.toLowerCase()), this.skipSC(), hasOwnProperty.call(this.atrule, e2) && typeof this.atrule[e2].prelude == "function" ? t2 = this.atrule[e2].prelude.call(this) : t2 = this.readSequence(this.scope.AtrulePrelude), this.skipSC(), this.eof !== true && this.tokenType !== 23 && this.tokenType !== 17 && this.error("Semicolon or block is expected"), { type: "AtrulePrelude", loc: this.getLocationFromList(t2), children: t2 };
}
function ou(e2) {
  this.children(e2);
}
var cn = {};
f(cn, { generate: () => mu, name: () => pu, parse: () => ln, structure: () => hu });
var su = 36;
var Ws = 42;
var rr = 61;
var au = 94;
var an = 124;
var lu = 126;
function cu() {
  this.eof && this.error("Unexpected end of input");
  let e2 = this.tokenStart, t2 = false;
  return this.isDelim(Ws) ? (t2 = true, this.next()) : this.isDelim(an) || this.eat(1), this.isDelim(an) ? this.charCodeAt(this.tokenStart + 1) !== rr ? (this.next(), this.eat(1)) : t2 && this.error("Identifier is expected", this.tokenEnd) : t2 && this.error("Vertical line is expected"), { type: "Identifier", loc: this.getLocation(e2, this.tokenStart), name: this.substrToCursor(e2) };
}
function uu() {
  let e2 = this.tokenStart, t2 = this.charCodeAt(e2);
  return t2 !== rr && t2 !== lu && t2 !== au && t2 !== su && t2 !== Ws && t2 !== an && this.error("Attribute selector (=, ~=, ^=, $=, *=, |=) is expected"), this.next(), t2 !== rr && (this.isDelim(rr) || this.error("Equal sign is expected"), this.next()), this.substrToCursor(e2);
}
var pu = "AttributeSelector";
var hu = { name: "Identifier", matcher: [String, null], value: ["String", "Identifier", null], flags: [String, null] };
function ln() {
  let e2 = this.tokenStart, t2, r = null, n = null, i = null;
  return this.eat(19), this.skipSC(), t2 = cu.call(this), this.skipSC(), this.tokenType !== 20 && (this.tokenType !== 1 && (r = uu.call(this), this.skipSC(), n = this.tokenType === 5 ? this.String() : this.Identifier(), this.skipSC()), this.tokenType === 1 && (i = this.consume(1), this.skipSC())), this.eat(20), { type: "AttributeSelector", loc: this.getLocation(e2, this.tokenStart), name: t2, matcher: r, value: n, flags: i };
}
function mu(e2) {
  this.token(9, "["), this.node(e2.name), e2.matcher !== null && (this.tokenize(e2.matcher), this.node(e2.value)), e2.flags !== null && this.token(1, e2.flags), this.token(9, "]");
}
var pn = {};
f(pn, { generate: () => yu, name: () => gu, parse: () => un, structure: () => xu, walkContext: () => bu });
var du = 38;
function Us() {
  return this.Raw(null, true);
}
function qs() {
  return this.parseWithFallback(this.Rule, Us);
}
function js() {
  return this.Raw(this.consumeUntilSemicolonIncluded, true);
}
function fu() {
  if (this.tokenType === 17) return js.call(this, this.tokenIndex);
  let e2 = this.parseWithFallback(this.Declaration, js);
  return this.tokenType === 17 && this.next(), e2;
}
var gu = "Block";
var bu = "block";
var xu = { children: [["Atrule", "Rule", "Declaration"]] };
function un(e2) {
  let t2 = e2 ? fu : qs, r = this.tokenStart, n = this.createList();
  this.eat(23);
  e: for (; !this.eof; ) switch (this.tokenType) {
    case 24:
      break e;
    case 13:
    case 25:
      this.next();
      break;
    case 3:
      n.push(this.parseWithFallback(this.Atrule.bind(this, e2), Us));
      break;
    default:
      e2 && this.isDelim(du) ? n.push(qs.call(this)) : n.push(t2.call(this));
  }
  return this.eof || this.eat(24), { type: "Block", loc: this.getLocation(r, this.tokenStart), children: n };
}
function yu(e2) {
  this.token(23, "{"), this.children(e2, (t2) => {
    t2.type === "Declaration" && this.token(17, ";");
  }), this.token(24, "}");
}
var mn = {};
f(mn, { generate: () => vu, name: () => ku, parse: () => hn, structure: () => wu });
var ku = "Brackets";
var wu = { children: [[]] };
function hn(e2, t2) {
  let r = this.tokenStart, n = null;
  return this.eat(19), n = e2.call(this, t2), this.eof || this.eat(20), { type: "Brackets", loc: this.getLocation(r, this.tokenStart), children: n };
}
function vu(e2) {
  this.token(9, "["), this.children(e2), this.token(9, "]");
}
var fn = {};
f(fn, { generate: () => Tu, name: () => Su, parse: () => dn, structure: () => Cu });
var Su = "CDC";
var Cu = [];
function dn() {
  let e2 = this.tokenStart;
  return this.eat(15), { type: "CDC", loc: this.getLocation(e2, this.tokenStart) };
}
function Tu() {
  this.token(15, "-->");
}
var bn = {};
f(bn, { generate: () => Eu, name: () => Au, parse: () => gn, structure: () => Lu });
var Au = "CDO";
var Lu = [];
function gn() {
  let e2 = this.tokenStart;
  return this.eat(14), { type: "CDO", loc: this.getLocation(e2, this.tokenStart) };
}
function Eu() {
  this.token(14, "<!--");
}
var yn = {};
f(yn, { generate: () => Du, name: () => Pu, parse: () => xn, structure: () => Iu });
var zu = 46;
var Pu = "ClassSelector";
var Iu = { name: String };
function xn() {
  return this.eatDelim(zu), { type: "ClassSelector", loc: this.getLocation(this.tokenStart - 1, this.tokenEnd), name: this.consume(1) };
}
function Du(e2) {
  this.token(9, "."), this.token(1, e2.name);
}
var wn = {};
f(wn, { generate: () => Bu, name: () => Fu, parse: () => kn, structure: () => Mu });
var Nu = 43;
var Hs = 47;
var Ou = 62;
var Ru = 126;
var Fu = "Combinator";
var Mu = { name: String };
function kn() {
  let e2 = this.tokenStart, t2;
  switch (this.tokenType) {
    case 13:
      t2 = " ";
      break;
    case 9:
      switch (this.charCodeAt(this.tokenStart)) {
        case Ou:
        case Nu:
        case Ru:
          this.next();
          break;
        case Hs:
          this.next(), this.eatIdent("deep"), this.eatDelim(Hs);
          break;
        default:
          this.error("Combinator is expected");
      }
      t2 = this.substrToCursor(e2);
      break;
  }
  return { type: "Combinator", loc: this.getLocation(e2, this.tokenStart), name: t2 };
}
function Bu(e2) {
  this.tokenize(e2.name);
}
var Sn = {};
f(Sn, { generate: () => Uu, name: () => qu, parse: () => vn, structure: () => ju });
var _u = 42;
var Wu = 47;
var qu = "Comment";
var ju = { value: String };
function vn() {
  let e2 = this.tokenStart, t2 = this.tokenEnd;
  return this.eat(25), t2 - e2 + 2 >= 2 && this.charCodeAt(t2 - 2) === _u && this.charCodeAt(t2 - 1) === Wu && (t2 -= 2), { type: "Comment", loc: this.getLocation(e2, this.tokenStart), value: this.substring(e2 + 2, t2) };
}
function Uu(e2) {
  this.token(25, "/*" + e2.value + "*/");
}
var Tn = {};
f(Tn, { generate: () => Vu, name: () => Gu, parse: () => Cn, structure: () => Yu });
var Hu = /* @__PURE__ */ new Set([16, 22, 0]);
var Gu = "Condition";
var Yu = { kind: String, children: [["Identifier", "Feature", "FeatureFunction", "FeatureRange", "SupportsDeclaration"]] };
function Gs(e2) {
  return this.lookupTypeNonSC(1) === 1 && Hu.has(this.lookupTypeNonSC(2)) ? this.Feature(e2) : this.FeatureRange(e2);
}
var Ku = { media: Gs, container: Gs, supports() {
  return this.SupportsDeclaration();
} };
function Cn(e2 = "media") {
  let t2 = this.createList();
  e: for (; !this.eof; ) switch (this.tokenType) {
    case 25:
    case 13:
      this.next();
      continue;
    case 1:
      t2.push(this.Identifier());
      break;
    case 21: {
      let r = this.parseWithFallback(() => Ku[e2].call(this, e2), () => null);
      r || (r = this.parseWithFallback(() => {
        this.eat(21);
        let n = this.Condition(e2);
        return this.eat(22), n;
      }, () => this.GeneralEnclosed(e2))), t2.push(r);
      break;
    }
    case 2: {
      let r = this.parseWithFallback(() => this.FeatureFunction(e2), () => null);
      r || (r = this.GeneralEnclosed(e2)), t2.push(r);
      break;
    }
    default:
      break e;
  }
  return t2.isEmpty && this.error("Condition is expected"), { type: "Condition", loc: this.getLocationFromList(t2), kind: e2, children: t2 };
}
function Vu(e2) {
  e2.children.forEach((t2) => {
    t2.type === "Condition" ? (this.token(21, "("), this.node(t2), this.token(22, ")")) : this.node(t2);
  });
}
var Ln = {};
f(Ln, { generate: () => sp, name: () => np, parse: () => An, structure: () => op, walkContext: () => ip });
var Ks = 33;
var Qu = 35;
var Xu = 36;
var $u = 38;
var Zu = 42;
var Ju = 43;
var Ys = 47;
function ep() {
  return this.Raw(this.consumeUntilExclamationMarkOrSemicolon, true);
}
function tp() {
  return this.Raw(this.consumeUntilExclamationMarkOrSemicolon, false);
}
function rp() {
  let e2 = this.tokenIndex, t2 = this.Value();
  return t2.type !== "Raw" && this.eof === false && this.tokenType !== 17 && this.isDelim(Ks) === false && this.isBalanceEdge(e2) === false && this.error(), t2;
}
var np = "Declaration";
var ip = "declaration";
var op = { important: [Boolean, String], property: String, value: ["Value", "Raw"] };
function An() {
  let e2 = this.tokenStart, t2 = this.tokenIndex, r = ap.call(this), n = Ht(r), i = n ? this.parseCustomProperty : this.parseValue, o = n ? tp : ep, s = false, u;
  this.skipSC(), this.eat(16);
  let c = this.tokenIndex;
  if (n || this.skipSC(), i ? u = this.parseWithFallback(rp, o) : u = o.call(this, this.tokenIndex), n && u.type === "Value" && u.children.isEmpty) {
    for (let a = c - this.tokenIndex; a <= 0; a++) if (this.lookupType(a) === 13) {
      u.children.appendData({ type: "WhiteSpace", loc: null, value: " " });
      break;
    }
  }
  return this.isDelim(Ks) && (s = lp.call(this), this.skipSC()), this.eof === false && this.tokenType !== 17 && this.isBalanceEdge(t2) === false && this.error(), { type: "Declaration", loc: this.getLocation(e2, this.tokenStart), important: s, property: r, value: u };
}
function sp(e2) {
  this.token(1, e2.property), this.token(16, ":"), this.node(e2.value), e2.important && (this.token(9, "!"), this.token(1, e2.important === true ? "important" : e2.important));
}
function ap() {
  let e2 = this.tokenStart;
  if (this.tokenType === 9) switch (this.charCodeAt(this.tokenStart)) {
    case Zu:
    case Xu:
    case Ju:
    case Qu:
    case $u:
      this.next();
      break;
    case Ys:
      this.next(), this.isDelim(Ys) && this.next();
      break;
  }
  return this.tokenType === 4 ? this.eat(4) : this.eat(1), this.substrToCursor(e2);
}
function lp() {
  this.eat(9), this.skipSC();
  let e2 = this.consume(1);
  return e2 === "important" ? true : e2;
}
var Pn = {};
f(Pn, { generate: () => hp, name: () => up, parse: () => zn, structure: () => pp });
var cp = 38;
function En() {
  return this.Raw(this.consumeUntilSemicolonIncluded, true);
}
var up = "DeclarationList";
var pp = { children: [["Declaration", "Atrule", "Rule"]] };
function zn() {
  let e2 = this.createList();
  for (; !this.eof; ) switch (this.tokenType) {
    case 13:
    case 25:
    case 17:
      this.next();
      break;
    case 3:
      e2.push(this.parseWithFallback(this.Atrule.bind(this, true), En));
      break;
    default:
      this.isDelim(cp) ? e2.push(this.parseWithFallback(this.Rule, En)) : e2.push(this.parseWithFallback(this.Declaration, En));
  }
  return { type: "DeclarationList", loc: this.getLocationFromList(e2), children: e2 };
}
function hp(e2) {
  this.children(e2, (t2) => {
    t2.type === "Declaration" && this.token(17, ";");
  });
}
var Dn = {};
f(Dn, { generate: () => fp, name: () => mp, parse: () => In, structure: () => dp });
var mp = "Dimension";
var dp = { value: String, unit: String };
function In() {
  let e2 = this.tokenStart, t2 = this.consumeNumber(12);
  return { type: "Dimension", loc: this.getLocation(e2, this.tokenStart), value: t2, unit: this.substring(e2 + t2.length, this.tokenStart) };
}
function fp(e2) {
  this.token(12, e2.value + e2.unit);
}
var On = {};
f(On, { generate: () => yp, name: () => bp, parse: () => Nn, structure: () => xp });
var gp = 47;
var bp = "Feature";
var xp = { kind: String, name: String, value: ["Identifier", "Number", "Dimension", "Ratio", "Function", null] };
function Nn(e2) {
  let t2 = this.tokenStart, r, n = null;
  if (this.eat(21), this.skipSC(), r = this.consume(1), this.skipSC(), this.tokenType !== 22) {
    switch (this.eat(16), this.skipSC(), this.tokenType) {
      case 10:
        this.lookupNonWSType(1) === 9 ? n = this.Ratio() : n = this.Number();
        break;
      case 12:
        n = this.Dimension();
        break;
      case 1:
        n = this.Identifier();
        break;
      case 2:
        n = this.parseWithFallback(() => {
          let i = this.Function(this.readSequence, this.scope.Value);
          return this.skipSC(), this.isDelim(gp) && this.error(), i;
        }, () => this.Ratio());
        break;
      default:
        this.error("Number, dimension, ratio or identifier is expected");
    }
    this.skipSC();
  }
  return this.eof || this.eat(22), { type: "Feature", loc: this.getLocation(t2, this.tokenStart), kind: e2, name: r, value: n };
}
function yp(e2) {
  this.token(21, "("), this.token(1, e2.name), e2.value !== null && (this.token(16, ":"), this.node(e2.value)), this.token(22, ")");
}
var Fn = {};
f(Fn, { generate: () => Sp, name: () => kp, parse: () => Rn, structure: () => wp });
var kp = "FeatureFunction";
var wp = { kind: String, feature: String, value: ["Declaration", "Selector"] };
function vp(e2, t2) {
  let n = (this.features[e2] || {})[t2];
  return typeof n != "function" && this.error(`Unknown feature ${t2}()`), n;
}
function Rn(e2 = "unknown") {
  let t2 = this.tokenStart, r = this.consumeFunctionName(), n = vp.call(this, e2, r.toLowerCase());
  this.skipSC();
  let i = this.parseWithFallback(() => {
    let o = this.tokenIndex, s = n.call(this);
    return this.eof === false && this.isBalanceEdge(o) === false && this.error(), s;
  }, () => this.Raw(null, false));
  return this.eof || this.eat(22), { type: "FeatureFunction", loc: this.getLocation(t2, this.tokenStart), kind: e2, feature: r, value: i };
}
function Sp(e2) {
  this.token(2, e2.feature + "("), this.node(e2.value), this.token(22, ")");
}
var _n = {};
f(_n, { generate: () => Ep, name: () => Ap, parse: () => Bn, structure: () => Lp });
var Vs = 47;
var Cp = 60;
var Qs = 61;
var Tp = 62;
var Ap = "FeatureRange";
var Lp = { kind: String, left: ["Identifier", "Number", "Dimension", "Ratio", "Function"], leftComparison: String, middle: ["Identifier", "Number", "Dimension", "Ratio", "Function"], rightComparison: [String, null], right: ["Identifier", "Number", "Dimension", "Ratio", "Function", null] };
function Mn() {
  switch (this.skipSC(), this.tokenType) {
    case 10:
      return this.isDelim(Vs, this.lookupOffsetNonSC(1)) ? this.Ratio() : this.Number();
    case 12:
      return this.Dimension();
    case 1:
      return this.Identifier();
    case 2:
      return this.parseWithFallback(() => {
        let e2 = this.Function(this.readSequence, this.scope.Value);
        return this.skipSC(), this.isDelim(Vs) && this.error(), e2;
      }, () => this.Ratio());
    default:
      this.error("Number, dimension, ratio or identifier is expected");
  }
}
function Xs(e2) {
  if (this.skipSC(), this.isDelim(Cp) || this.isDelim(Tp)) {
    let t2 = this.source[this.tokenStart];
    return this.next(), this.isDelim(Qs) ? (this.next(), t2 + "=") : t2;
  }
  if (this.isDelim(Qs)) return "=";
  this.error(`Expected ${e2 ? '":", ' : ""}"<", ">", "=" or ")"`);
}
function Bn(e2 = "unknown") {
  let t2 = this.tokenStart;
  this.skipSC(), this.eat(21);
  let r = Mn.call(this), n = Xs.call(this, r.type === "Identifier"), i = Mn.call(this), o = null, s = null;
  return this.lookupNonWSType(0) !== 22 && (o = Xs.call(this), s = Mn.call(this)), this.skipSC(), this.eat(22), { type: "FeatureRange", loc: this.getLocation(t2, this.tokenStart), kind: e2, left: r, leftComparison: n, middle: i, rightComparison: o, right: s };
}
function Ep(e2) {
  this.token(21, "("), this.node(e2.left), this.tokenize(e2.leftComparison), this.node(e2.middle), e2.right && (this.tokenize(e2.rightComparison), this.node(e2.right)), this.token(22, ")");
}
var qn = {};
f(qn, { generate: () => Dp, name: () => zp, parse: () => Wn, structure: () => Ip, walkContext: () => Pp });
var zp = "Function";
var Pp = "function";
var Ip = { name: String, children: [[]] };
function Wn(e2, t2) {
  let r = this.tokenStart, n = this.consumeFunctionName(), i = n.toLowerCase(), o;
  return o = t2.hasOwnProperty(i) ? t2[i].call(this, t2) : e2.call(this, t2), this.eof || this.eat(22), { type: "Function", loc: this.getLocation(r, this.tokenStart), name: n, children: o };
}
function Dp(e2) {
  this.token(2, e2.name + "("), this.children(e2), this.token(22, ")");
}
var Un = {};
f(Un, { generate: () => Rp, name: () => Np, parse: () => jn, structure: () => Op });
var Np = "GeneralEnclosed";
var Op = { kind: String, function: [String, null], children: [[]] };
function jn(e2) {
  let t2 = this.tokenStart, r = null;
  this.tokenType === 2 ? r = this.consumeFunctionName() : this.eat(21);
  let n = this.parseWithFallback(() => {
    let i = this.tokenIndex, o = this.readSequence(this.scope.Value);
    return this.eof === false && this.isBalanceEdge(i) === false && this.error(), o;
  }, () => this.createSingleNodeList(this.Raw(null, false)));
  return this.eof || this.eat(22), { type: "GeneralEnclosed", loc: this.getLocation(t2, this.tokenStart), kind: e2, function: r, children: n };
}
function Rp(e2) {
  e2.function ? this.token(2, e2.function + "(") : this.token(21, "("), this.children(e2), this.token(22, ")");
}
var Gn = {};
f(Gn, { generate: () => _p, name: () => Mp, parse: () => Hn, structure: () => Bp, xxx: () => Fp });
var Fp = "XXX";
var Mp = "Hash";
var Bp = { value: String };
function Hn() {
  let e2 = this.tokenStart;
  return this.eat(4), { type: "Hash", loc: this.getLocation(e2, this.tokenStart), value: this.substrToCursor(e2 + 1) };
}
function _p(e2) {
  this.token(4, "#" + e2.value);
}
var Kn = {};
f(Kn, { generate: () => jp, name: () => Wp, parse: () => Yn, structure: () => qp });
var Wp = "Identifier";
var qp = { name: String };
function Yn() {
  return { type: "Identifier", loc: this.getLocation(this.tokenStart, this.tokenEnd), name: this.consume(1) };
}
function jp(e2) {
  this.token(1, e2.name);
}
var Qn = {};
f(Qn, { generate: () => Gp, name: () => Up, parse: () => Vn, structure: () => Hp });
var Up = "IdSelector";
var Hp = { name: String };
function Vn() {
  let e2 = this.tokenStart;
  return this.eat(4), { type: "IdSelector", loc: this.getLocation(e2, this.tokenStart), name: this.substrToCursor(e2 + 1) };
}
function Gp(e2) {
  this.token(9, "#" + e2.name);
}
var $n = {};
f($n, { generate: () => Qp, name: () => Kp, parse: () => Xn, structure: () => Vp });
var Yp = 46;
var Kp = "Layer";
var Vp = { name: String };
function Xn() {
  let e2 = this.tokenStart, t2 = this.consume(1);
  for (; this.isDelim(Yp); ) this.eat(9), t2 += "." + this.consume(1);
  return { type: "Layer", loc: this.getLocation(e2, this.tokenStart), name: t2 };
}
function Qp(e2) {
  this.tokenize(e2.name);
}
var Jn = {};
f(Jn, { generate: () => Zp, name: () => Xp, parse: () => Zn, structure: () => $p });
var Xp = "LayerList";
var $p = { children: [["Layer"]] };
function Zn() {
  let e2 = this.createList();
  for (this.skipSC(); !this.eof && (e2.push(this.Layer()), this.lookupTypeNonSC(0) === 18); ) this.skipSC(), this.next(), this.skipSC();
  return { type: "LayerList", loc: this.getLocationFromList(e2), children: e2 };
}
function Zp(e2) {
  this.children(e2, () => this.token(18, ","));
}
var ti = {};
f(ti, { generate: () => th, name: () => Jp, parse: () => ei, structure: () => eh });
var Jp = "MediaQuery";
var eh = { modifier: [String, null], mediaType: [String, null], condition: ["Condition", null] };
function ei() {
  let e2 = this.tokenStart, t2 = null, r = null, n = null;
  if (this.skipSC(), this.tokenType === 1 && this.lookupTypeNonSC(1) !== 21) {
    let i = this.consume(1), o = i.toLowerCase();
    switch (o === "not" || o === "only" ? (this.skipSC(), t2 = o, r = this.consume(1)) : r = i, this.lookupTypeNonSC(0)) {
      case 1: {
        this.skipSC(), this.eatIdent("and"), n = this.Condition("media");
        break;
      }
      case 23:
      case 17:
      case 18:
      case 0:
        break;
      default:
        this.error("Identifier or parenthesis is expected");
    }
  } else switch (this.tokenType) {
    case 1:
    case 21:
    case 2: {
      n = this.Condition("media");
      break;
    }
    case 23:
    case 17:
    case 0:
      break;
    default:
      this.error("Identifier or parenthesis is expected");
  }
  return { type: "MediaQuery", loc: this.getLocation(e2, this.tokenStart), modifier: t2, mediaType: r, condition: n };
}
function th(e2) {
  e2.mediaType ? (e2.modifier && this.token(1, e2.modifier), this.token(1, e2.mediaType), e2.condition && (this.token(1, "and"), this.node(e2.condition))) : e2.condition && this.node(e2.condition);
}
var ni = {};
f(ni, { generate: () => ih, name: () => rh, parse: () => ri, structure: () => nh });
var rh = "MediaQueryList";
var nh = { children: [["MediaQuery"]] };
function ri() {
  let e2 = this.createList();
  for (this.skipSC(); !this.eof && (e2.push(this.MediaQuery()), this.tokenType === 18); ) this.next();
  return { type: "MediaQueryList", loc: this.getLocationFromList(e2), children: e2 };
}
function ih(e2) {
  this.children(e2, () => this.token(18, ","));
}
var oi = {};
f(oi, { generate: () => lh, name: () => sh, parse: () => ii, structure: () => ah });
var oh = 38;
var sh = "NestingSelector";
var ah = {};
function ii() {
  let e2 = this.tokenStart;
  return this.eatDelim(oh), { type: "NestingSelector", loc: this.getLocation(e2, this.tokenStart) };
}
function lh() {
  this.token(9, "&");
}
var ai = {};
f(ai, { generate: () => ph, name: () => ch, parse: () => si, structure: () => uh });
var ch = "Nth";
var uh = { nth: ["AnPlusB", "Identifier"], selector: ["SelectorList", null] };
function si() {
  this.skipSC();
  let e2 = this.tokenStart, t2 = e2, r = null, n;
  return this.lookupValue(0, "odd") || this.lookupValue(0, "even") ? n = this.Identifier() : n = this.AnPlusB(), t2 = this.tokenStart, this.skipSC(), this.lookupValue(0, "of") && (this.next(), r = this.SelectorList(), t2 = this.tokenStart), { type: "Nth", loc: this.getLocation(e2, t2), nth: n, selector: r };
}
function ph(e2) {
  this.node(e2.nth), e2.selector !== null && (this.token(1, "of"), this.node(e2.selector));
}
var ci = {};
f(ci, { generate: () => dh, name: () => hh, parse: () => li, structure: () => mh });
var hh = "Number";
var mh = { value: String };
function li() {
  return { type: "Number", loc: this.getLocation(this.tokenStart, this.tokenEnd), value: this.consume(10) };
}
function dh(e2) {
  this.token(10, e2.value);
}
var pi = {};
f(pi, { generate: () => bh, name: () => fh, parse: () => ui, structure: () => gh });
var fh = "Operator";
var gh = { value: String };
function ui() {
  let e2 = this.tokenStart;
  return this.next(), { type: "Operator", loc: this.getLocation(e2, this.tokenStart), value: this.substrToCursor(e2) };
}
function bh(e2) {
  this.tokenize(e2.value);
}
var mi = {};
f(mi, { generate: () => kh, name: () => xh, parse: () => hi, structure: () => yh });
var xh = "Parentheses";
var yh = { children: [[]] };
function hi(e2, t2) {
  let r = this.tokenStart, n = null;
  return this.eat(21), n = e2.call(this, t2), this.eof || this.eat(22), { type: "Parentheses", loc: this.getLocation(r, this.tokenStart), children: n };
}
function kh(e2) {
  this.token(21, "("), this.children(e2), this.token(22, ")");
}
var fi = {};
f(fi, { generate: () => Sh, name: () => wh, parse: () => di, structure: () => vh });
var wh = "Percentage";
var vh = { value: String };
function di() {
  return { type: "Percentage", loc: this.getLocation(this.tokenStart, this.tokenEnd), value: this.consumeNumber(11) };
}
function Sh(e2) {
  this.token(11, e2.value + "%");
}
var bi = {};
f(bi, { generate: () => Lh, name: () => Ch, parse: () => gi, structure: () => Ah, walkContext: () => Th });
var Ch = "PseudoClassSelector";
var Th = "function";
var Ah = { name: String, children: [["Raw"], null] };
function gi() {
  let e2 = this.tokenStart, t2 = null, r, n;
  return this.eat(16), this.tokenType === 2 ? (r = this.consumeFunctionName(), n = r.toLowerCase(), this.lookupNonWSType(0) == 22 ? t2 = this.createList() : hasOwnProperty.call(this.pseudo, n) ? (this.skipSC(), t2 = this.pseudo[n].call(this), this.skipSC()) : (t2 = this.createList(), t2.push(this.Raw(null, false))), this.eat(22)) : r = this.consume(1), { type: "PseudoClassSelector", loc: this.getLocation(e2, this.tokenStart), name: r, children: t2 };
}
function Lh(e2) {
  this.token(16, ":"), e2.children === null ? this.token(1, e2.name) : (this.token(2, e2.name + "("), this.children(e2), this.token(22, ")"));
}
var yi = {};
f(yi, { generate: () => Ih, name: () => Eh, parse: () => xi, structure: () => Ph, walkContext: () => zh });
var Eh = "PseudoElementSelector";
var zh = "function";
var Ph = { name: String, children: [["Raw"], null] };
function xi() {
  let e2 = this.tokenStart, t2 = null, r, n;
  return this.eat(16), this.eat(16), this.tokenType === 2 ? (r = this.consumeFunctionName(), n = r.toLowerCase(), this.lookupNonWSType(0) == 22 ? t2 = this.createList() : hasOwnProperty.call(this.pseudo, n) ? (this.skipSC(), t2 = this.pseudo[n].call(this), this.skipSC()) : (t2 = this.createList(), t2.push(this.Raw(null, false))), this.eat(22)) : r = this.consume(1), { type: "PseudoElementSelector", loc: this.getLocation(e2, this.tokenStart), name: r, children: t2 };
}
function Ih(e2) {
  this.token(16, ":"), this.token(16, ":"), e2.children === null ? this.token(1, e2.name) : (this.token(2, e2.name + "("), this.children(e2), this.token(22, ")"));
}
var wi = {};
f(wi, { generate: () => Oh, name: () => Dh, parse: () => ki, structure: () => Nh });
var $s = 47;
function Zs() {
  switch (this.skipSC(), this.tokenType) {
    case 10:
      return this.Number();
    case 2:
      return this.Function(this.readSequence, this.scope.Value);
    default:
      this.error("Number of function is expected");
  }
}
var Dh = "Ratio";
var Nh = { left: ["Number", "Function"], right: ["Number", "Function", null] };
function ki() {
  let e2 = this.tokenStart, t2 = Zs.call(this), r = null;
  return this.skipSC(), this.isDelim($s) && (this.eatDelim($s), r = Zs.call(this)), { type: "Ratio", loc: this.getLocation(e2, this.tokenStart), left: t2, right: r };
}
function Oh(e2) {
  this.node(e2.left), this.token(9, "/"), e2.right ? this.node(e2.right) : this.node(10, 1);
}
var Si = {};
f(Si, { generate: () => Bh, name: () => Fh, parse: () => vi, structure: () => Mh });
function Rh() {
  return this.tokenIndex > 0 && this.lookupType(-1) === 13 ? this.tokenIndex > 1 ? this.getTokenStart(this.tokenIndex - 1) : this.firstCharOffset : this.tokenStart;
}
var Fh = "Raw";
var Mh = { value: String };
function vi(e2, t2) {
  let r = this.getTokenStart(this.tokenIndex), n;
  return this.skipUntilBalanced(this.tokenIndex, e2 || this.consumeUntilBalanceEnd), t2 && this.tokenStart > r ? n = Rh.call(this) : n = this.tokenStart, { type: "Raw", loc: this.getLocation(r, n), value: this.substring(r, n) };
}
function Bh(e2) {
  this.tokenize(e2.value);
}
var Ti = {};
f(Ti, { generate: () => Uh, name: () => Wh, parse: () => Ci, structure: () => jh, walkContext: () => qh });
function Js() {
  return this.Raw(this.consumeUntilLeftCurlyBracket, true);
}
function _h() {
  let e2 = this.SelectorList();
  return e2.type !== "Raw" && this.eof === false && this.tokenType !== 23 && this.error(), e2;
}
var Wh = "Rule";
var qh = "rule";
var jh = { prelude: ["SelectorList", "Raw"], block: ["Block"] };
function Ci() {
  let e2 = this.tokenIndex, t2 = this.tokenStart, r, n;
  return this.parseRulePrelude ? r = this.parseWithFallback(_h, Js) : r = Js.call(this, e2), n = this.Block(true), { type: "Rule", loc: this.getLocation(t2, this.tokenStart), prelude: r, block: n };
}
function Uh(e2) {
  this.node(e2.prelude), this.node(e2.block);
}
var Li = {};
f(Li, { generate: () => Yh, name: () => Hh, parse: () => Ai, structure: () => Gh });
var Hh = "Scope";
var Gh = { root: ["SelectorList", "Raw", null], limit: ["SelectorList", "Raw", null] };
function Ai() {
  let e2 = null, t2 = null;
  this.skipSC();
  let r = this.tokenStart;
  return this.tokenType === 21 && (this.next(), this.skipSC(), e2 = this.parseWithFallback(this.SelectorList, () => this.Raw(false, true)), this.skipSC(), this.eat(22)), this.lookupNonWSType(0) === 1 && (this.skipSC(), this.eatIdent("to"), this.skipSC(), this.eat(21), this.skipSC(), t2 = this.parseWithFallback(this.SelectorList, () => this.Raw(false, true)), this.skipSC(), this.eat(22)), { type: "Scope", loc: this.getLocation(r, this.tokenStart), root: e2, limit: t2 };
}
function Yh(e2) {
  e2.root && (this.token(21, "("), this.node(e2.root), this.token(22, ")")), e2.limit && (this.token(1, "to"), this.token(21, "("), this.node(e2.limit), this.token(22, ")"));
}
var zi = {};
f(zi, { generate: () => Qh, name: () => Kh, parse: () => Ei, structure: () => Vh });
var Kh = "Selector";
var Vh = { children: [["TypeSelector", "IdSelector", "ClassSelector", "AttributeSelector", "PseudoClassSelector", "PseudoElementSelector", "Combinator"]] };
function Ei() {
  let e2 = this.readSequence(this.scope.Selector);
  return this.getFirstListNode(e2) === null && this.error("Selector is expected"), { type: "Selector", loc: this.getLocationFromList(e2), children: e2 };
}
function Qh(e2) {
  this.children(e2);
}
var Ii = {};
f(Ii, { generate: () => Jh, name: () => Xh, parse: () => Pi, structure: () => Zh, walkContext: () => $h });
var Xh = "SelectorList";
var $h = "selector";
var Zh = { children: [["Selector", "Raw"]] };
function Pi() {
  let e2 = this.createList();
  for (; !this.eof; ) {
    if (e2.push(this.Selector()), this.tokenType === 18) {
      this.next();
      continue;
    }
    break;
  }
  return { type: "SelectorList", loc: this.getLocationFromList(e2), children: e2 };
}
function Jh(e2) {
  this.children(e2, () => this.token(18, ","));
}
var Fi = {};
f(Fi, { generate: () => rm, name: () => em, parse: () => Ri, structure: () => tm });
var Oi = {};
f(Oi, { decode: () => vt, encode: () => Ni });
var Di = 92;
var ea = 34;
var ta = 39;
function vt(e2) {
  let t2 = e2.length, r = e2.charCodeAt(0), n = r === ea || r === ta ? 1 : 0, i = n === 1 && t2 > 1 && e2.charCodeAt(t2 - 1) === r ? t2 - 2 : t2 - 1, o = "";
  for (let s = n; s <= i; s++) {
    let u = e2.charCodeAt(s);
    if (u === Di) {
      if (s === i) {
        s !== t2 - 1 && (o = e2.substr(s + 1));
        break;
      }
      if (u = e2.charCodeAt(++s), K(Di, u)) {
        let c = s - 1, a = se(e2, c);
        s = a - 1, o += je(e2.substring(c + 1, a));
      } else u === 13 && e2.charCodeAt(s + 1) === 10 && s++;
    } else o += e2[s];
  }
  return o;
}
function Ni(e2, t2) {
  let r = t2 ? "'" : '"', n = t2 ? ta : ea, i = "", o = false;
  for (let s = 0; s < e2.length; s++) {
    let u = e2.charCodeAt(s);
    if (u === 0) {
      i += "\uFFFD";
      continue;
    }
    if (u <= 31 || u === 127) {
      i += "\\" + u.toString(16), o = true;
      continue;
    }
    u === n || u === Di ? (i += "\\" + e2.charAt(s), o = false) : (o && (J(u) || me(u)) && (i += " "), i += e2.charAt(s), o = false);
  }
  return r + i + r;
}
var em = "String";
var tm = { value: String };
function Ri() {
  return { type: "String", loc: this.getLocation(this.tokenStart, this.tokenEnd), value: vt(this.consume(5)) };
}
function rm(e2) {
  this.token(5, Ni(e2.value));
}
var Bi = {};
f(Bi, { generate: () => am, name: () => im, parse: () => Mi, structure: () => sm, walkContext: () => om });
var nm = 33;
function ra() {
  return this.Raw(null, false);
}
var im = "StyleSheet";
var om = "stylesheet";
var sm = { children: [["Comment", "CDO", "CDC", "Atrule", "Rule", "Raw"]] };
function Mi() {
  let e2 = this.tokenStart, t2 = this.createList(), r;
  for (; !this.eof; ) {
    switch (this.tokenType) {
      case 13:
        this.next();
        continue;
      case 25:
        if (this.charCodeAt(this.tokenStart + 2) !== nm) {
          this.next();
          continue;
        }
        r = this.Comment();
        break;
      case 14:
        r = this.CDO();
        break;
      case 15:
        r = this.CDC();
        break;
      case 3:
        r = this.parseWithFallback(this.Atrule, ra);
        break;
      default:
        r = this.parseWithFallback(this.Rule, ra);
    }
    t2.push(r);
  }
  return { type: "StyleSheet", loc: this.getLocation(e2, this.tokenStart), children: t2 };
}
function am(e2) {
  this.children(e2);
}
var Wi = {};
f(Wi, { generate: () => um, name: () => lm, parse: () => _i, structure: () => cm });
var lm = "SupportsDeclaration";
var cm = { declaration: "Declaration" };
function _i() {
  let e2 = this.tokenStart;
  this.eat(21), this.skipSC();
  let t2 = this.Declaration();
  return this.eof || this.eat(22), { type: "SupportsDeclaration", loc: this.getLocation(e2, this.tokenStart), declaration: t2 };
}
function um(e2) {
  this.token(21, "("), this.node(e2.declaration), this.token(22, ")");
}
var Ui = {};
f(Ui, { generate: () => dm, name: () => hm, parse: () => ji, structure: () => mm });
var pm = 42;
var na = 124;
function qi() {
  this.tokenType !== 1 && this.isDelim(pm) === false && this.error("Identifier or asterisk is expected"), this.next();
}
var hm = "TypeSelector";
var mm = { name: String };
function ji() {
  let e2 = this.tokenStart;
  return this.isDelim(na) ? (this.next(), qi.call(this)) : (qi.call(this), this.isDelim(na) && (this.next(), qi.call(this))), { type: "TypeSelector", loc: this.getLocation(e2, this.tokenStart), name: this.substrToCursor(e2) };
}
function dm(e2) {
  this.tokenize(e2.name);
}
var Yi = {};
f(Yi, { generate: () => ym, name: () => bm, parse: () => Gi, structure: () => xm });
var ia = 43;
var oa = 45;
var Hi = 63;
function St(e2, t2) {
  let r = 0;
  for (let n = this.tokenStart + e2; n < this.tokenEnd; n++) {
    let i = this.charCodeAt(n);
    if (i === oa && t2 && r !== 0) return St.call(this, e2 + r + 1, false), -1;
    J(i) || this.error(t2 && r !== 0 ? "Hyphen minus" + (r < 6 ? " or hex digit" : "") + " is expected" : r < 6 ? "Hex digit is expected" : "Unexpected input", n), ++r > 6 && this.error("Too many hex digits", n);
  }
  return this.next(), r;
}
function nr(e2) {
  let t2 = 0;
  for (; this.isDelim(Hi); ) ++t2 > e2 && this.error("Too many question marks"), this.next();
}
function fm(e2) {
  this.charCodeAt(this.tokenStart) !== e2 && this.error((e2 === ia ? "Plus sign" : "Hyphen minus") + " is expected");
}
function gm() {
  let e2 = 0;
  switch (this.tokenType) {
    case 10:
      if (e2 = St.call(this, 1, true), this.isDelim(Hi)) {
        nr.call(this, 6 - e2);
        break;
      }
      if (this.tokenType === 12 || this.tokenType === 10) {
        fm.call(this, oa), St.call(this, 1, false);
        break;
      }
      break;
    case 12:
      e2 = St.call(this, 1, true), e2 > 0 && nr.call(this, 6 - e2);
      break;
    default:
      if (this.eatDelim(ia), this.tokenType === 1) {
        e2 = St.call(this, 0, true), e2 > 0 && nr.call(this, 6 - e2);
        break;
      }
      if (this.isDelim(Hi)) {
        this.next(), nr.call(this, 5);
        break;
      }
      this.error("Hex digit or question mark is expected");
  }
}
var bm = "UnicodeRange";
var xm = { value: String };
function Gi() {
  let e2 = this.tokenStart;
  return this.eatIdent("u"), gm.call(this), { type: "UnicodeRange", loc: this.getLocation(e2, this.tokenStart), value: this.substrToCursor(e2) };
}
function ym(e2) {
  this.tokenize(e2.value);
}
var Zi = {};
f(Zi, { generate: () => Am, name: () => Cm, parse: () => $i, structure: () => Tm });
var Xi = {};
f(Xi, { decode: () => Vi, encode: () => Qi });
var km = 32;
var Ki = 92;
var wm = 34;
var vm = 39;
var Sm = 40;
var sa = 41;
function Vi(e2) {
  let t2 = e2.length, r = 4, n = e2.charCodeAt(t2 - 1) === sa ? t2 - 2 : t2 - 1, i = "";
  for (; r < n && me(e2.charCodeAt(r)); ) r++;
  for (; r < n && me(e2.charCodeAt(n)); ) n--;
  for (let o = r; o <= n; o++) {
    let s = e2.charCodeAt(o);
    if (s === Ki) {
      if (o === n) {
        o !== t2 - 1 && (i = e2.substr(o + 1));
        break;
      }
      if (s = e2.charCodeAt(++o), K(Ki, s)) {
        let u = o - 1, c = se(e2, u);
        o = c - 1, i += je(e2.substring(u + 1, c));
      } else s === 13 && e2.charCodeAt(o + 1) === 10 && o++;
    } else i += e2[o];
  }
  return i;
}
function Qi(e2) {
  let t2 = "", r = false;
  for (let n = 0; n < e2.length; n++) {
    let i = e2.charCodeAt(n);
    if (i === 0) {
      t2 += "\uFFFD";
      continue;
    }
    if (i <= 31 || i === 127) {
      t2 += "\\" + i.toString(16), r = true;
      continue;
    }
    i === km || i === Ki || i === wm || i === vm || i === Sm || i === sa ? (t2 += "\\" + e2.charAt(n), r = false) : (r && J(i) && (t2 += " "), t2 += e2.charAt(n), r = false);
  }
  return "url(" + t2 + ")";
}
var Cm = "Url";
var Tm = { value: String };
function $i() {
  let e2 = this.tokenStart, t2;
  switch (this.tokenType) {
    case 7:
      t2 = Vi(this.consume(7));
      break;
    case 2:
      this.cmpStr(this.tokenStart, this.tokenEnd, "url(") || this.error("Function name must be `url`"), this.eat(2), this.skipSC(), t2 = vt(this.consume(5)), this.skipSC(), this.eof || this.eat(22);
      break;
    default:
      this.error("Url or Function is expected");
  }
  return { type: "Url", loc: this.getLocation(e2, this.tokenStart), value: t2 };
}
function Am(e2) {
  this.token(7, Qi(e2.value));
}
var eo = {};
f(eo, { generate: () => zm, name: () => Lm, parse: () => Ji, structure: () => Em });
var Lm = "Value";
var Em = { children: [[]] };
function Ji() {
  let e2 = this.tokenStart, t2 = this.readSequence(this.scope.Value);
  return { type: "Value", loc: this.getLocation(e2, this.tokenStart), children: t2 };
}
function zm(e2) {
  this.children(e2);
}
var ro = {};
f(ro, { generate: () => Nm, name: () => Im, parse: () => to, structure: () => Dm });
var Pm = Object.freeze({ type: "WhiteSpace", loc: null, value: " " });
var Im = "WhiteSpace";
var Dm = { value: String };
function to() {
  return this.eat(13), Pm;
}
function Nm(e2) {
  this.token(13, e2.value);
}
var aa = { generic: true, cssWideKeywords: Ve, ...Bs, node: Ct };
var no = {};
f(no, { AtrulePrelude: () => ca, Selector: () => pa, Value: () => fa });
var Om = 35;
var Rm = 42;
var la = 43;
var Fm = 45;
var Mm = 47;
var Bm = 117;
function Tt(e2) {
  switch (this.tokenType) {
    case 4:
      return this.Hash();
    case 18:
      return this.Operator();
    case 21:
      return this.Parentheses(this.readSequence, e2.recognizer);
    case 19:
      return this.Brackets(this.readSequence, e2.recognizer);
    case 5:
      return this.String();
    case 12:
      return this.Dimension();
    case 11:
      return this.Percentage();
    case 10:
      return this.Number();
    case 2:
      return this.cmpStr(this.tokenStart, this.tokenEnd, "url(") ? this.Url() : this.Function(this.readSequence, e2.recognizer);
    case 7:
      return this.Url();
    case 1:
      return this.cmpChar(this.tokenStart, Bm) && this.cmpChar(this.tokenStart + 1, la) ? this.UnicodeRange() : this.Identifier();
    case 9: {
      let t2 = this.charCodeAt(this.tokenStart);
      if (t2 === Mm || t2 === Rm || t2 === la || t2 === Fm) return this.Operator();
      t2 === Om && this.error("Hex or identifier is expected", this.tokenStart + 1);
      break;
    }
  }
}
var ca = { getNode: Tt };
var _m = 35;
var Wm = 38;
var qm = 42;
var jm = 43;
var Um = 47;
var ua = 46;
var Hm = 62;
var Gm = 124;
var Ym = 126;
function Km(e2, t2) {
  t2.last !== null && t2.last.type !== "Combinator" && e2 !== null && e2.type !== "Combinator" && t2.push({ type: "Combinator", loc: null, name: " " });
}
function Vm() {
  switch (this.tokenType) {
    case 19:
      return this.AttributeSelector();
    case 4:
      return this.IdSelector();
    case 16:
      return this.lookupType(1) === 16 ? this.PseudoElementSelector() : this.PseudoClassSelector();
    case 1:
      return this.TypeSelector();
    case 10:
    case 11:
      return this.Percentage();
    case 12:
      this.charCodeAt(this.tokenStart) === ua && this.error("Identifier is expected", this.tokenStart + 1);
      break;
    case 9: {
      switch (this.charCodeAt(this.tokenStart)) {
        case jm:
        case Hm:
        case Ym:
        case Um:
          return this.Combinator();
        case ua:
          return this.ClassSelector();
        case qm:
        case Gm:
          return this.TypeSelector();
        case _m:
          return this.IdSelector();
        case Wm:
          return this.NestingSelector();
      }
      break;
    }
  }
}
var pa = { onWhiteSpace: Km, getNode: Vm };
function ha() {
  return this.createSingleNodeList(this.Raw(null, false));
}
function ma() {
  let e2 = this.createList();
  if (this.skipSC(), e2.push(this.Identifier()), this.skipSC(), this.tokenType === 18) {
    e2.push(this.Operator());
    let t2 = this.tokenIndex, r = this.parseCustomProperty ? this.Value(null) : this.Raw(this.consumeUntilExclamationMarkOrSemicolon, false);
    if (r.type === "Value" && r.children.isEmpty) {
      for (let n = t2 - this.tokenIndex; n <= 0; n++) if (this.lookupType(n) === 13) {
        r.children.appendData({ type: "WhiteSpace", loc: null, value: " " });
        break;
      }
    }
    e2.push(r);
  }
  return e2;
}
function da(e2) {
  return e2 !== null && e2.type === "Operator" && (e2.value[e2.value.length - 1] === "-" || e2.value[e2.value.length - 1] === "+");
}
var fa = { getNode: Tt, onWhiteSpace(e2, t2) {
  da(e2) && (e2.value = " " + e2.value), da(t2.last) && (t2.last.value += " ");
}, expression: ha, var: ma };
var Qm = /* @__PURE__ */ new Set(["none", "and", "not", "or"]);
var ga = { parse: { prelude() {
  let e2 = this.createList();
  if (this.tokenType === 1) {
    let t2 = this.substring(this.tokenStart, this.tokenEnd);
    Qm.has(t2.toLowerCase()) || e2.push(this.Identifier());
  }
  return e2.push(this.Condition("container")), e2;
}, block(e2 = false) {
  return this.Block(e2);
} } };
var ba = { parse: { prelude: null, block() {
  return this.Block(true);
} } };
function io(e2, t2) {
  return this.parseWithFallback(() => {
    try {
      return e2.call(this);
    } finally {
      this.skipSC(), this.lookupNonWSType(0) !== 22 && this.error();
    }
  }, t2 || (() => this.Raw(null, true)));
}
var xa = { layer() {
  this.skipSC();
  let e2 = this.createList(), t2 = io.call(this, this.Layer);
  return (t2.type !== "Raw" || t2.value !== "") && e2.push(t2), e2;
}, supports() {
  this.skipSC();
  let e2 = this.createList(), t2 = io.call(this, this.Declaration, () => io.call(this, () => this.Condition("supports")));
  return (t2.type !== "Raw" || t2.value !== "") && e2.push(t2), e2;
} };
var ya = { parse: { prelude() {
  let e2 = this.createList();
  switch (this.tokenType) {
    case 5:
      e2.push(this.String());
      break;
    case 7:
    case 2:
      e2.push(this.Url());
      break;
    default:
      this.error("String or url() is expected");
  }
  return this.skipSC(), this.tokenType === 1 && this.cmpStr(this.tokenStart, this.tokenEnd, "layer") ? e2.push(this.Identifier()) : this.tokenType === 2 && this.cmpStr(this.tokenStart, this.tokenEnd, "layer(") && e2.push(this.Function(null, xa)), this.skipSC(), this.tokenType === 2 && this.cmpStr(this.tokenStart, this.tokenEnd, "supports(") && e2.push(this.Function(null, xa)), (this.lookupNonWSType(0) === 1 || this.lookupNonWSType(0) === 21) && e2.push(this.MediaQueryList()), e2;
}, block: null } };
var ka = { parse: { prelude() {
  return this.createSingleNodeList(this.LayerList());
}, block() {
  return this.Block(false);
} } };
var wa = { parse: { prelude() {
  return this.createSingleNodeList(this.MediaQueryList());
}, block(e2 = false) {
  return this.Block(e2);
} } };
var va = { parse: { prelude() {
  return this.createSingleNodeList(this.SelectorList());
}, block() {
  return this.Block(true);
} } };
var Sa = { parse: { prelude() {
  return this.createSingleNodeList(this.SelectorList());
}, block() {
  return this.Block(true);
} } };
var Ca = { parse: { prelude() {
  return this.createSingleNodeList(this.Scope());
}, block(e2 = false) {
  return this.Block(e2);
} } };
var Ta = { parse: { prelude: null, block(e2 = false) {
  return this.Block(e2);
} } };
var Aa = { parse: { prelude() {
  return this.createSingleNodeList(this.Condition("supports"));
}, block(e2 = false) {
  return this.Block(e2);
} } };
var La = { container: ga, "font-face": ba, import: ya, layer: ka, media: wa, nest: va, page: Sa, scope: Ca, "starting-style": Ta, supports: Aa };
function Ea() {
  let e2 = this.createList();
  this.skipSC();
  e: for (; !this.eof; ) {
    switch (this.tokenType) {
      case 1:
        e2.push(this.Identifier());
        break;
      case 5:
        e2.push(this.String());
        break;
      case 18:
        e2.push(this.Operator());
        break;
      case 22:
        break e;
      default:
        this.error("Identifier, string or comma is expected");
    }
    this.skipSC();
  }
  return e2;
}
var Fe = { parse() {
  return this.createSingleNodeList(this.SelectorList());
} };
var oo = { parse() {
  return this.createSingleNodeList(this.Selector());
} };
var Xm = { parse() {
  return this.createSingleNodeList(this.Identifier());
} };
var $m = { parse: Ea };
var ir = { parse() {
  return this.createSingleNodeList(this.Nth());
} };
var za = { dir: Xm, has: Fe, lang: $m, matches: Fe, is: Fe, "-moz-any": Fe, "-webkit-any": Fe, where: Fe, not: Fe, "nth-child": ir, "nth-last-child": ir, "nth-last-of-type": ir, "nth-of-type": ir, slotted: oo, host: oo, "host-context": oo };
var so = {};
f(so, { AnPlusB: () => en, Atrule: () => rn, AtrulePrelude: () => on, AttributeSelector: () => ln, Block: () => un, Brackets: () => hn, CDC: () => dn, CDO: () => gn, ClassSelector: () => xn, Combinator: () => kn, Comment: () => vn, Condition: () => Cn, Declaration: () => An, DeclarationList: () => zn, Dimension: () => In, Feature: () => Nn, FeatureFunction: () => Rn, FeatureRange: () => Bn, Function: () => Wn, GeneralEnclosed: () => jn, Hash: () => Hn, IdSelector: () => Vn, Identifier: () => Yn, Layer: () => Xn, LayerList: () => Zn, MediaQuery: () => ei, MediaQueryList: () => ri, NestingSelector: () => ii, Nth: () => si, Number: () => li, Operator: () => ui, Parentheses: () => hi, Percentage: () => di, PseudoClassSelector: () => gi, PseudoElementSelector: () => xi, Ratio: () => ki, Raw: () => vi, Rule: () => Ci, Scope: () => Ai, Selector: () => Ei, SelectorList: () => Pi, String: () => Ri, StyleSheet: () => Mi, SupportsDeclaration: () => _i, TypeSelector: () => ji, UnicodeRange: () => Gi, Url: () => $i, Value: () => Ji, WhiteSpace: () => to });
var Pa = { parseContext: { default: "StyleSheet", stylesheet: "StyleSheet", atrule: "Atrule", atrulePrelude(e2) {
  return this.AtrulePrelude(e2.atrule ? String(e2.atrule) : null);
}, mediaQueryList: "MediaQueryList", mediaQuery: "MediaQuery", condition(e2) {
  return this.Condition(e2.kind);
}, rule: "Rule", selectorList: "SelectorList", selector: "Selector", block() {
  return this.Block(true);
}, declarationList: "DeclarationList", declaration: "Declaration", value: "Value" }, features: { supports: { selector() {
  return this.Selector();
} }, container: { style() {
  return this.Declaration();
} } }, scope: no, atrule: La, pseudo: za, node: so };
var Ia = { node: Ct };
var Da = Zr({ ...aa, ...Pa, ...Ia });
var Oa = {};
f(Oa, { decode: () => Zm, encode: () => Jm });
var Na = 92;
function Zm(e2) {
  let t2 = e2.length - 1, r = "";
  for (let n = 0; n < e2.length; n++) {
    let i = e2.charCodeAt(n);
    if (i === Na) {
      if (n === t2) break;
      if (i = e2.charCodeAt(++n), K(Na, i)) {
        let o = n - 1, s = se(e2, o);
        n = s - 1, r += je(e2.substring(o + 1, s));
      } else i === 13 && e2.charCodeAt(n + 1) === 10 && n++;
    } else r += e2[n];
  }
  return r;
}
function Jm(e2) {
  let t2 = "";
  if (e2.length === 1 && e2.charCodeAt(0) === 45) return "\\-";
  for (let r = 0; r < e2.length; r++) {
    let n = e2.charCodeAt(r);
    if (n === 0) {
      t2 += "\uFFFD";
      continue;
    }
    if (n <= 31 || n === 127 || n >= 48 && n <= 57 && (r === 0 || r === 1 && e2.charCodeAt(0) === 45)) {
      t2 += "\\" + n.toString(16) + " ";
      continue;
    }
    _e(n) ? t2 += e2.charAt(r) : t2 += "\\" + e2.charAt(r);
  }
  return t2;
}
var { tokenize: $b, parse: Zb, generate: Jb, lexer: ex, createLexer: tx, walk: rx, find: nx, findLast: ix, findAll: ox, toPlainObject: sx, fromPlainObject: ax, fork: lx } = Da;

// node_modules/mhtml-to-html/lib/srcset-parser.js
function parse2(input) {
  function isSpace(c2) {
    return c2 === " " || // space
    c2 === "	" || // horizontal tab
    c2 === "\n" || // new line
    c2 === "\f" || // form feed
    c2 === "\r";
  }
  function collectCharacters(regEx) {
    let chars;
    const match = regEx.exec(input.substring(pos));
    if (match) {
      chars = match[0];
      pos += chars.length;
      return chars;
    }
  }
  const inputLength = input.length;
  const regexLeadingSpaces = /^[ \t\n\r\u000c]+/;
  const regexLeadingCommasOrSpaces = /^[, \t\n\r\u000c]+/;
  const regexLeadingNotSpaces = /^[^ \t\n\r\u000c]+/;
  const regexTrailingCommas = /[,]+$/;
  const regexNonNegativeInteger = /^\d+$/;
  const regexFloatingPoint = /^-?(?:[0-9]+|[0-9]*\.[0-9]+)(?:[eE][+-]?[0-9]+)?$/;
  let url, descriptors, currentDescriptor, state, c, pos = 0;
  const candidates = [];
  while (true) {
    collectCharacters(regexLeadingCommasOrSpaces);
    if (pos >= inputLength) {
      return candidates;
    }
    url = collectCharacters(regexLeadingNotSpaces);
    descriptors = [];
    if (url.slice(-1) === ",") {
      url = url.replace(regexTrailingCommas, "");
      parseDescriptors();
    } else {
      tokenize();
    }
  }
  function tokenize() {
    collectCharacters(regexLeadingSpaces);
    currentDescriptor = "";
    state = "in descriptor";
    while (true) {
      c = input.charAt(pos);
      if (state === "in descriptor") {
        if (isSpace(c)) {
          if (currentDescriptor) {
            descriptors.push(currentDescriptor);
            currentDescriptor = "";
            state = "after descriptor";
          }
        } else if (c === ",") {
          pos += 1;
          if (currentDescriptor) {
            descriptors.push(currentDescriptor);
          }
          parseDescriptors();
          return;
        } else if (c === "(") {
          currentDescriptor = currentDescriptor + c;
          state = "in parens";
        } else if (c === "") {
          if (currentDescriptor) {
            descriptors.push(currentDescriptor);
          }
          parseDescriptors();
          return;
        } else {
          currentDescriptor = currentDescriptor + c;
        }
      } else if (state === "in parens") {
        if (c === ")") {
          currentDescriptor = currentDescriptor + c;
          state = "in descriptor";
        } else if (c === "") {
          descriptors.push(currentDescriptor);
          parseDescriptors();
          return;
        } else {
          currentDescriptor = currentDescriptor + c;
        }
      } else if (state === "after descriptor") {
        if (isSpace(c)) {
        } else if (c === "") {
          parseDescriptors();
          return;
        } else {
          state = "in descriptor";
          pos -= 1;
        }
      }
      pos += 1;
    }
  }
  function parseDescriptors() {
    let pError = false, w, d, h, i, desc, lastChar, value, intVal, floatVal;
    const candidate = {};
    for (i = 0; i < descriptors.length; i++) {
      desc = descriptors[i];
      lastChar = desc[desc.length - 1];
      value = desc.substring(0, desc.length - 1);
      intVal = parseInt(value, 10);
      floatVal = parseFloat(value);
      if (regexNonNegativeInteger.test(value) && lastChar === "w") {
        if (w || d) {
          pError = true;
        }
        if (intVal === 0) {
          pError = true;
        } else {
          w = intVal;
        }
      } else if (regexFloatingPoint.test(value) && lastChar === "x") {
        if (w || d || h) {
          pError = true;
        }
        if (floatVal < 0) {
          pError = true;
        } else {
          d = floatVal;
        }
      } else if (regexNonNegativeInteger.test(value) && lastChar === "h") {
        if (h || d) {
          pError = true;
        }
        if (intVal === 0) {
          pError = true;
        } else {
          h = intVal;
        }
      } else {
        pError = true;
      }
    }
    if (!pError) {
      candidate.url = url;
      if (w) {
        candidate.w = w;
      }
      if (d) {
        candidate.d = d;
      }
      if (h) {
        candidate.h = h;
      }
      candidates.push(candidate);
    } else if (console && console.log) {
      console.log('Invalid srcset descriptor found in "' + input + '" at "' + desc + '".');
    }
  }
}
function serialize3(srcset) {
  return srcset.map(function(candidate) {
    let descriptor = "";
    if (candidate.w) {
      descriptor += candidate.w + "w";
    }
    if (candidate.h) {
      descriptor += candidate.h + "h";
    }
    if (candidate.d) {
      descriptor += candidate.d + "x";
    }
    return candidate.url + (descriptor ? " " + descriptor : "");
  }).join(", ");
}

// node_modules/mhtml-to-html/lib/convert.js
var BASE64_ENCODING = "base64";
var HREF_ATTRIBUTE = "href";
var SRC_ATTRIBUTE = "src";
var TITLE_ATTRIBUTE = "title";
var SRCSET_ATTRIBUTE = "srcset";
var SRCDOC_ATTRIBUTE = "srcdoc";
var CONTENT_ATTRIBUTE = "content";
var STYLE_ATTRIBUTE = "style";
var MEDIA_ATTRIBUTE = "media";
var BACKGROUND_ATTRIBUTE = "background";
var REL_ATTRIBUTE = "rel";
var DATA_ATTRIBUTE = "data";
var TYPE_ATTRIBUTE = "type";
var PING_ATTRIBUTE = "ping";
var HTTP_EQUIV_ATTRIBUTE = "http-equiv";
var INTEGRITY_ATTRIBUTE = "integrity";
var CHARSET_ATTRIBUTE = "charset";
var SHADOWMODE_ATTRIBUTE = "shadowmode";
var SHADOWROOTMODE_ATTRIBUTE = "shadowrootmode";
var SIZES_ATTRIBUTE = "sizes";
var STYLESHEET_CONTENT_TYPE = "text/css";
var CID_PROTOCOL = "cid:";
var DATA_PROTOCOL = "data:";
var HTTP_PROTOCOL = "http:";
var HTTPS_PROTOCOL = "https:";
var URN_PROTOCOL = "urn:";
var AT_RULE = "Atrule";
var IMPORT_RULE = "import";
var URL_FUNCTION = "Url";
var STYLESHEET_CONTEXT = "stylesheet";
var DECLARATION_LIST_CONTEXT = "declarationList";
var BASE_TAG = "BASE";
var LINK_TAG = "LINK";
var STYLE_TAG = "STYLE";
var IMG_TAG = "IMG";
var AUDIO_TAG = "AUDIO";
var VIDEO_TAG = "VIDEO";
var SOURCE_TAG = "SOURCE";
var SCRIPT_TAG = "SCRIPT";
var BODY_TAG = "BODY";
var TABLE_TAG = "TABLE";
var TD_TAG = "TD";
var TH_TAG = "TH";
var INPUT_TAG = "INPUT";
var IFRAME_TAG = "IFRAME";
var FRAME_TAG = "FRAME";
var EMBED_TAG = "EMBED";
var OBJECT_TAG = "OBJECT";
var A_TAG = "A";
var AREA_TAG = "AREA";
var META_TAG = "META";
var TEMPLATE_TAG = "TEMPLATE";
var HEAD_TAG = "HEAD";
var TITLE_TAG = "TITLE";
var ORIGINAL_URL_FUNCTION_NAME = "--mhtml-to-html-url";
var ORIGINAL_URL_ATTRIBUTE_PREFIX = "data-original-";
var CONTENT_TYPE_HEADER = "Content-Type";
var REL_ATTRIBUTE_STYLESHEET = "stylesheet";
var REL_ATTRIBUTE_ICON = "icon";
var REL_ATTRIBUTE_CANONICAL = "canonical";
var REL_ATTRIBUTE_ALTERNATE = "alternate";
var HTTP_EQUIV_ATTRIBUTE_REFRESH = "refresh";
var HTTP_EQUIV_ATTRIBUTE_CSP = "content-security-policy";
var TYPE_ATTRIBUTE_IMAGE = "image";
var REL_REMOVED_VALUES_REGEXP = /(preconnect|prerender|dns-prefetch|preload|prefetch|manifest|modulepreload)/gi;
var URN_ERROR_REGEXP = /^urn:[^:]+:(.+)$/;
var APPLICATION_OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
var JSON_LD_CONTENT_TYPE = "application/ld+json";
var TEXT_HTML_CONTENT_TYPE = "text/html";
var UTF8_CHARSET = "utf-8";
var INDEX_PAGE_NOT_FOUND_ERROR = "Index page not found";
var CID_REGEXP = /^<.+>$/;
var CONTENT_TYPE_SEPARATOR = ";";
var DATA_URI_PAYLOAD_SEPARATOR = ",";
var EMPTY_STRING2 = "";
var ORIGINAL_URL_FUNCTION_REGEXP = /url\(--mhtml-to-html-url\\\(\\"(.*?)\\"\\\)\\ /g;
var ORIGINAL_URL_COMMENT = "/* original URL: $1 */ url(";
var DEFAULT_CSP = "default-src 'none'; connect-src 'self' data:; font-src 'self' data:; img-src 'self' data:; style-src 'self' 'unsafe-inline' data:; frame-src 'self' data:; media-src 'self' data:; object-src 'self' data:; ";
var JS_ENABLED_CSP = "script-src 'self' 'unsafe-inline' data:;";
var JS_DISABLED_CSP = "script-src 'none';";
var CSS_FUNCTION_PARENTHESIS_START = "(";
var CSS_FUNCTION_PARENTHESIS_END = ") ";
var SUBJECT_HEADER = "Subject";
var DATE_HEADER = "Date";
var FROM_HEADER = "From";
var JSON_LD_PAGE_INFO = {
  "@context": "https://schema.org",
  "@type": "WebPage",
  "additionalProperty": {
    "@type": "PropertyValue",
    "name": "savedBy"
  }
};
var convert_default = fetchAndConvert;
async function fetchAndConvert(mhtml, config2, failedResources = []) {
  if (config2.fetchMissingResources) {
    let { fetch: fetch2 } = config2;
    let missingResources = [];
    if (!fetch2) {
      fetch2 = globalThis.fetch;
    }
    missingResources = convert(mhtml, config2);
    missingResources = missingResources.filter((resource) => !failedResources.includes(resource.id));
    if (missingResources.length) {
      await Promise.all(missingResources.map(async (resource) => {
        const { id, transferEncoding } = resource;
        let url = id;
        const urnErrorMatch = url.match(URN_ERROR_REGEXP);
        if (urnErrorMatch) {
          url = urnErrorMatch[1];
        }
        try {
          const response = await fetch2(url);
          if (response.ok) {
            resource.contentType = response.headers.get(CONTENT_TYPE_HEADER) || APPLICATION_OCTET_STREAM_CONTENT_TYPE;
            if (transferEncoding === BASE64_ENCODING) {
              const bytes = await response.bytes();
              resource.data = decodeBinary(bytes);
            } else {
              resource.data = await response.text();
            }
            mhtml.resources[id] = resource;
          } else if (!failedResources.includes(id)) {
            failedResources.push(id);
          }
        } catch (_2) {
          if (!failedResources.includes(id)) {
            failedResources.push(id);
          }
        }
      }));
      return fetchAndConvert(mhtml, config2, failedResources);
    } else {
      return convert(mhtml, { ...config2, fetchMissingResources: false });
    }
  } else {
    return convert(mhtml, config2);
  }
}
function convert({ headers, frames, resources, unfoundResources = /* @__PURE__ */ new Set(), index: index2, id }, { DOMParser: DOMParser2, enableScripts, fetchMissingResources } = { DOMParser: globalThis.DOMParser }) {
  let resource = resources[index2];
  if (!resource) {
    throw new Error(INDEX_PAGE_NOT_FOUND_ERROR);
  }
  let base = resource.id;
  if (resource.transferEncoding === BASE64_ENCODING) {
    resource.transferEncoding = void 0;
    resource.data = decodeBase64(resource.data, getCharset(resource.contentType));
  }
  const contentType = resource.contentType.split(CONTENT_TYPE_SEPARATOR)[0];
  const dom = parseDOM(resource.data, contentType, DOMParser2);
  const document2 = dom.document;
  let nodes = [document2];
  const baseElement = document2.getElementsByTagName(BASE_TAG)[0];
  if (baseElement) {
    const href = baseElement.getAttribute(HREF_ATTRIBUTE);
    if (href) {
      base = resolvePath(href, base);
    }
    baseElement.remove();
  }
  if (!fetchMissingResources) {
    resource.used = true;
  }
  nodes = [document2];
  let canonicalLinkElement;
  const stylesheets = {};
  const missingResources = [];
  const removedNodes = [];
  const favicons = [];
  let title;
  while (nodes.length) {
    const childNode = nodes.shift();
    if (childNode.childNodes) {
      for (const child of childNode.childNodes) {
        let href, src;
        if (child.getAttribute) {
          href = child.getAttribute(HREF_ATTRIBUTE);
          if (href) {
            href = resolvePath(href, base);
          }
          src = child.getAttribute(SRC_ATTRIBUTE);
          if (src) {
            src = resolvePath(src, base);
          }
          const style = child.getAttribute(STYLE_ATTRIBUTE);
          if (style) {
            const declarations = replaceStylesheetUrls(resources, base, { data: style }, { context: DECLARATION_LIST_CONTEXT }, stylesheets, fetchMissingResources && missingResources, unfoundResources);
            if (!fetchMissingResources) {
              child.setAttribute(STYLE_ATTRIBUTE, declarations);
            }
          }
          const integrity = child.getAttribute(INTEGRITY_ATTRIBUTE);
          if (integrity) {
            child.removeAttribute(INTEGRITY_ATTRIBUTE);
          }
        }
        if (!enableScripts && child.removeAttribute) {
          EVENT_HANDLER_ATTRIBUTES.forEach((attribute) => child.removeAttribute(attribute));
        }
        if (child.tagName && child.tagName.toUpperCase() === LINK_TAG && href) {
          let rel = child.getAttribute(REL_ATTRIBUTE);
          if (rel) {
            rel = rel.toLowerCase();
            if (rel === REL_ATTRIBUTE_STYLESHEET) {
              resource = getResource(resources, href, child.getAttribute(HREF_ATTRIBUTE));
              if (resource) {
                let base2 = resource.id;
                if (base2.startsWith(CID_PROTOCOL)) {
                  if (index2.match(CID_REGEXP)) {
                    base2 = id;
                  } else {
                    base2 = index2;
                  }
                }
                const stylesheet = replaceStylesheetUrls(resources, base2, resource, { context: STYLESHEET_CONTEXT }, stylesheets, fetchMissingResources && missingResources, unfoundResources);
                if (!fetchMissingResources) {
                  const styleElement = document2.createElement(STYLE_TAG);
                  styleElement.type = STYLESHEET_CONTENT_TYPE;
                  const media = child.getAttribute(MEDIA_ATTRIBUTE);
                  if (media) {
                    styleElement.setAttribute(MEDIA_ATTRIBUTE, media);
                  }
                  resource.used = true;
                  resource.data = stylesheet;
                  if (!href.startsWith(DATA_PROTOCOL)) {
                    styleElement.setAttribute(ORIGINAL_URL_ATTRIBUTE_PREFIX + HREF_ATTRIBUTE, href);
                  }
                  styleElement.appendChild(document2.createTextNode(resource.data));
                  child.replaceWith(styleElement);
                }
              } else if (fetchMissingResources) {
                addMissingResource(missingResources, href);
              } else {
                unfoundResources.add(href);
                setAttribute2(child, HREF_ATTRIBUTE, href);
              }
              if (!fetchMissingResources) {
                const title2 = child.getAttribute(TITLE_ATTRIBUTE);
                if (title2 && rel.includes(REL_ATTRIBUTE_ALTERNATE)) {
                  removedNodes.push(child);
                }
              }
            } else if (rel.includes(REL_ATTRIBUTE_ICON)) {
              resource = getResource(resources, href, child.getAttribute(HREF_ATTRIBUTE));
              const media = child.getAttribute(MEDIA_ATTRIBUTE);
              const type = child.getAttribute(TYPE_ATTRIBUTE);
              const sizes = child.getAttribute(SIZES_ATTRIBUTE);
              if (resource) {
                if (!fetchMissingResources) {
                  resource.used = true;
                  const resourceURI = getResourceURI(resource);
                  setAttribute2(child, HREF_ATTRIBUTE, resourceURI);
                  favicons.push({ href: resourceURI, media, type, sizes, originalHref: href });
                }
              } else if (fetchMissingResources) {
                addMissingResource(missingResources, href, BASE64_ENCODING);
              } else {
                unfoundResources.add(href);
                setAttribute2(child, HREF_ATTRIBUTE, href);
                favicons.push({ href, media, type, sizes });
              }
            } else if (rel == REL_ATTRIBUTE_CANONICAL && !fetchMissingResources) {
              canonicalLinkElement = child;
            }
            if (!fetchMissingResources) {
              const relValue = rel.replace(REL_REMOVED_VALUES_REGEXP, EMPTY_STRING2).trim();
              if (relValue.length) {
                child.setAttribute(REL_ATTRIBUTE, relValue);
              } else {
                removedNodes.push(child);
              }
            }
          }
        } else if (child.tagName && child.tagName.toUpperCase() === STYLE_TAG) {
          const style = replaceStylesheetUrls(resources, base, { data: child.textContent }, { context: STYLESHEET_CONTEXT }, stylesheets, fetchMissingResources && missingResources, unfoundResources);
          if (!fetchMissingResources) {
            const styleElement = document2.createElement(STYLE_TAG);
            styleElement.type = STYLESHEET_CONTENT_TYPE;
            const media = child.getAttribute(MEDIA_ATTRIBUTE);
            if (media) {
              styleElement.setAttribute(MEDIA_ATTRIBUTE, media);
            }
            styleElement.appendChild(document2.createTextNode(style));
            child.replaceWith(styleElement);
          }
        } else if (child.tagName && child.tagName.toUpperCase() === IMG_TAG || child.tagName && child.tagName.toUpperCase() === AUDIO_TAG || child.tagName && child.tagName.toUpperCase() === VIDEO_TAG || child.tagName && child.tagName.toUpperCase() === SOURCE_TAG || child.tagName && child.tagName.toUpperCase() === SCRIPT_TAG) {
          if (src) {
            resource = getResource(resources, src, child.getAttribute(SRC_ATTRIBUTE));
            if (resource) {
              if (!fetchMissingResources) {
                resource.used = true;
                setAttribute2(child, SRC_ATTRIBUTE, getResourceURI(resource));
              }
            } else if (fetchMissingResources) {
              addMissingResource(missingResources, src, BASE64_ENCODING);
            } else {
              unfoundResources.add(src);
              setAttribute2(child, SRC_ATTRIBUTE, src);
            }
          }
          if (child.tagName && child.tagName.toUpperCase() === IMG_TAG || child.tagName && child.tagName.toUpperCase() === SOURCE_TAG) {
            const srcset = child.getAttribute(SRCSET_ATTRIBUTE);
            if (srcset) {
              const srcsetData = parse2(srcset).map((data) => {
                const src2 = resolvePath(data.url, base);
                const resource2 = getResource(resources, src2, data.url);
                if (resource2) {
                  if (!fetchMissingResources) {
                    resource2.used = true;
                    data.url = getResourceURI(resource2);
                  }
                } else if (fetchMissingResources) {
                  addMissingResource(missingResources, src2, BASE64_ENCODING);
                } else {
                  unfoundResources.add(src2);
                  data.url = src2;
                }
                return data;
              });
              if (!fetchMissingResources) {
                setAttribute2(child, SRCSET_ATTRIBUTE, serialize3(srcsetData));
              }
            }
          } else if (child.tagName && child.tagName.toUpperCase() === SCRIPT_TAG && !fetchMissingResources) {
            let type = child.getAttribute(TYPE_ATTRIBUTE);
            if (type) {
              type = type.toLowerCase();
            }
            if (!enableScripts && (!type || type !== JSON_LD_CONTENT_TYPE)) {
              removedNodes.push(child);
            }
          }
        } else if (child.tagName && child.tagName.toUpperCase() === BODY_TAG || child.tagName && child.tagName.toUpperCase() === TABLE_TAG || child.tagName && child.tagName.toUpperCase() === TD_TAG || child.tagName && child.tagName.toUpperCase() === TH_TAG) {
          let background = child.getAttribute(BACKGROUND_ATTRIBUTE);
          if (background && !background.startsWith(DATA_PROTOCOL)) {
            background = resolvePath(background, base);
            resource = getResource(resources, background, child.getAttribute(BACKGROUND_ATTRIBUTE));
            if (resource) {
              if (!fetchMissingResources) {
                resource.used = true;
                setAttribute2(child, BACKGROUND_ATTRIBUTE, getResourceURI(resource));
              }
            } else if (fetchMissingResources) {
              addMissingResource(missingResources, background, BASE64_ENCODING);
            } else {
              unfoundResources.add(background);
              setAttribute2(child, BACKGROUND_ATTRIBUTE, background);
            }
          }
        } else if (child.tagName && child.tagName.toUpperCase() === INPUT_TAG) {
          const type = child.getAttribute(TYPE_ATTRIBUTE);
          if (type && type.toLowerCase() === TYPE_ATTRIBUTE_IMAGE && src) {
            resource = getResource(resources, src, child.getAttribute(SRC_ATTRIBUTE));
            if (resource) {
              if (!fetchMissingResources) {
                resource.used = true;
                setAttribute2(child, SRC_ATTRIBUTE, getResourceURI(resource));
              }
            } else if (fetchMissingResources) {
              addMissingResource(missingResources, src, BASE64_ENCODING);
            } else {
              unfoundResources.add(src);
              setAttribute2(child, SRC_ATTRIBUTE, src);
            }
          }
        } else if (child.tagName && child.tagName.toUpperCase() === IFRAME_TAG || child.tagName && child.tagName.toUpperCase() === FRAME_TAG || child.tagName && child.tagName.toUpperCase() === EMBED_TAG || child.tagName && child.tagName.toUpperCase() === OBJECT_TAG) {
          let id2, attribute;
          if (child.tagName && child.tagName.toUpperCase() === OBJECT_TAG) {
            attribute = DATA_ATTRIBUTE;
            src = child.getAttribute(DATA_ATTRIBUTE);
            if (src) {
              src = resolvePath(src, base);
            }
          } else {
            attribute = SRC_ATTRIBUTE;
          }
          if (src) {
            if (src.startsWith(CID_PROTOCOL)) {
              id2 = `<${src.split(CID_PROTOCOL)[1]}>`;
              resource = frames[id2];
            } else {
              id2 = src;
              resource = getResource(resources, src, child.getAttribute(attribute));
            }
            if (resource) {
              if (child.tagName && child.tagName.toUpperCase() === EMBED_TAG || child.tagName && child.tagName.toUpperCase() === OBJECT_TAG) {
                if (!fetchMissingResources) {
                  resource.used = true;
                  setAttribute2(child, attribute, getResourceURI(resource));
                }
              } else {
                const result = convert({
                  resources: Object.assign({}, resources, { [id2]: resource }),
                  unfoundResources,
                  frames,
                  index: id2,
                  id: resource.id
                }, { DOMParser: DOMParser2, enableScripts, fetchMissingResources });
                if (fetchMissingResources) {
                  for (const missingResource of result) {
                    if (!missingResources.find((resource2) => resource2.id === missingResource.id)) {
                      missingResources.push(missingResource);
                    }
                  }
                } else {
                  resource.used = true;
                  if (child.tagName && child.tagName.toUpperCase() === IFRAME_TAG) {
                    setAttribute2(child, SRC_ATTRIBUTE);
                    child.removeAttribute(SRC_ATTRIBUTE);
                    child.setAttribute(SRCDOC_ATTRIBUTE, result.data);
                  } else {
                    setAttribute2(child, attribute, DATA_PROTOCOL + TEXT_HTML_CONTENT_TYPE + DATA_URI_PAYLOAD_SEPARATOR + encodeURIComponent(result.data));
                  }
                }
              }
            } else if (fetchMissingResources) {
              addMissingResource(missingResources, src);
            } else {
              unfoundResources.add(src);
              setAttribute2(child, attribute, src);
            }
          }
        } else if ((child.tagName && child.tagName.toUpperCase() === A_TAG || child.tagName && child.tagName.toUpperCase() === AREA_TAG) && !fetchMissingResources) {
          if (href) {
            try {
              const url = new URL(child.getAttribute(HREF_ATTRIBUTE), base);
              const hash2 = url.hash;
              url.hash = EMPTY_STRING2;
              if (url == base && hash2) {
                child.setAttribute(HREF_ATTRIBUTE, hash2);
              } else {
                child.setAttribute(HREF_ATTRIBUTE, href);
              }
            } catch (_2) {
              child.setAttribute(HREF_ATTRIBUTE, href);
            }
          }
          child.removeAttribute(PING_ATTRIBUTE);
        } else if (child.tagName && child.tagName.toUpperCase() === META_TAG && !fetchMissingResources) {
          let httpEquiv = child.getAttribute(HTTP_EQUIV_ATTRIBUTE);
          if (httpEquiv) {
            httpEquiv = httpEquiv.toLowerCase();
            if (httpEquiv === HTTP_EQUIV_ATTRIBUTE_REFRESH || httpEquiv === HTTP_EQUIV_ATTRIBUTE_CSP) {
              removedNodes.push(child);
            }
          }
        } else if (child.tagName && child.tagName.toUpperCase() === TEMPLATE_TAG && !fetchMissingResources) {
          const shadowModeAttribute = child.getAttribute(SHADOWMODE_ATTRIBUTE);
          if (shadowModeAttribute) {
            child.removeAttribute(SHADOWMODE_ATTRIBUTE);
            child.setAttribute(SHADOWROOTMODE_ATTRIBUTE, shadowModeAttribute);
          }
          if (child.content) {
            child.content.childNodes.forEach((node) => nodes.push(node));
          }
        } else if (child.tagName && child.tagName.toUpperCase() === TITLE_TAG && !fetchMissingResources && childNode.tagName && childNode.tagName.toUpperCase() === HEAD_TAG && title === void 0 && child.textContent) {
          title = child.textContent;
        }
        nodes.push(child);
      }
    }
  }
  if (fetchMissingResources) {
    return missingResources;
  } else {
    removedNodes.forEach((node) => node.remove());
    if (!canonicalLinkElement) {
      const linkElement = document2.createElement(LINK_TAG);
      linkElement.setAttribute(REL_ATTRIBUTE, REL_ATTRIBUTE_CANONICAL);
      linkElement.setAttribute(HREF_ATTRIBUTE, index2);
      document2.head.appendChild(linkElement);
    }
    let metaElement = document2.createElement(META_TAG);
    metaElement.setAttribute(HTTP_EQUIV_ATTRIBUTE, HTTP_EQUIV_ATTRIBUTE_CSP);
    let csp = DEFAULT_CSP;
    if (enableScripts) {
      csp += JS_ENABLED_CSP;
    } else {
      csp += JS_DISABLED_CSP;
    }
    metaElement.setAttribute(CONTENT_ATTRIBUTE, csp);
    if (document2.head.firstChild) {
      document2.head.prepend(metaElement);
    } else {
      document2.head.appendChild(metaElement);
    }
    metaElement.setAttribute(CONTENT_ATTRIBUTE, csp);
    metaElement = document2.createElement(META_TAG);
    metaElement.setAttribute(CHARSET_ATTRIBUTE, UTF8_CHARSET);
    document2.head.prepend(metaElement);
    if (headers) {
      const pageInfoElement = document2.createElement(SCRIPT_TAG);
      pageInfoElement.setAttribute(TYPE_ATTRIBUTE, JSON_LD_CONTENT_TYPE);
      pageInfoElement.appendChild(document2.createTextNode(JSON.stringify(getPageInfo(headers, index2), null, 2)));
      if (document2.head.firstChild) {
        document2.head.firstChild.after(pageInfoElement);
      } else {
        document2.head.appendChild(pageInfoElement);
      }
    }
    if (unfoundResources.size) {
      unfoundResources.forEach((id2) => {
        if (!id2.startsWith(DATA_PROTOCOL)) {
          resources[id2] = { id: id2, notFound: true, used: true };
        }
      });
    }
    return {
      title,
      favicons,
      data: dom.serialize()
    };
  }
}
function setAttribute2(element, attribute, newValue) {
  const value = element.getAttribute(attribute);
  if (value && !value.startsWith(DATA_PROTOCOL) && value !== newValue) {
    element.setAttribute(ORIGINAL_URL_ATTRIBUTE_PREFIX + attribute, value);
  }
  if (newValue !== void 0) {
    element.setAttribute(attribute, newValue);
  }
}
function replaceStylesheetUrls(resources, base, resource, options = {}, stylesheets, missingResources, unfoundResources) {
  let ast;
  if (resource.id !== void 0) {
    if (stylesheets[resource.id]) {
      return stylesheets[resource.id].data;
    } else {
      stylesheets[resource.id] = {};
    }
  }
  try {
    ast = Zb(resource.data, options);
  } catch (_2) {
  }
  if (ast) {
    rx(ast, (node) => {
      if (node.type === URL_FUNCTION) {
        const path = node.value;
        if (!path.startsWith(DATA_PROTOCOL) && !path.startsWith(ORIGINAL_URL_FUNCTION_NAME)) {
          const id = resolvePath(path, base);
          const resource2 = getResource(resources, id, path);
          if (resource2) {
            if (!missingResources) {
              resource2.used = true;
              if (isStylesheet(resource2.contentType)) {
                resource2.data = replaceStylesheetUrls(resources, resource2.id, resource2, { context: STYLESHEET_CONTEXT }, stylesheets, missingResources, unfoundResources);
              }
              node.value = getOriginalUrlFunction(id, getResourceURI(resource2));
            }
          } else if (missingResources) {
            addMissingResource(missingResources, id, BASE64_ENCODING);
          } else {
            unfoundResources.add(id);
            node.value = getOriginalUrlFunction(id);
          }
        }
      } else if (node.type === AT_RULE && node.name.toLowerCase() === IMPORT_RULE) {
        const path = node.prelude.children.first.value;
        if (!path.startsWith(DATA_PROTOCOL) && !path.startsWith(ORIGINAL_URL_FUNCTION_NAME)) {
          const id = resolvePath(path, base);
          const resource2 = getResource(resources, id, path);
          if (resource2) {
            resource2.data = replaceStylesheetUrls(resources, resource2.id, resource2, { context: STYLESHEET_CONTEXT }, stylesheets, missingResources, unfoundResources);
            if (!missingResources) {
              resource2.used = true;
              node.prelude.children.first.value = getOriginalUrlFunction(id, getResourceURI(resource2));
            }
          } else if (missingResources) {
            addMissingResource(missingResources, id);
          } else {
            unfoundResources.add(id);
            node.prelude.children.first.value = getOriginalUrlFunction(id);
          }
        }
      }
    });
    try {
      const result = Jb(ast);
      if (resource.id !== void 0) {
        stylesheets[resource.id].data = result;
      }
      return result.replace(ORIGINAL_URL_FUNCTION_REGEXP, ORIGINAL_URL_COMMENT);
    } catch (_2) {
      return resource.data;
    }
  } else {
    return resource.data;
  }
}
function getResource(resources, id, rawId) {
  let resource = resources[id];
  if (!resource) {
    resource = resources[rawId];
  }
  return resource;
}
function addMissingResource(missingResources, id, transferEncoding) {
  if ((id.startsWith(HTTP_PROTOCOL) || id.startsWith(HTTPS_PROTOCOL) || id.startsWith(URN_PROTOCOL)) && !missingResources.find((resource) => resource.id === id)) {
    missingResources.push({ id, transferEncoding });
  }
}
function getOriginalUrlFunction(id, resourceURI = id) {
  return ORIGINAL_URL_FUNCTION_NAME + CSS_FUNCTION_PARENTHESIS_START + JSON.stringify(id) + CSS_FUNCTION_PARENTHESIS_END + resourceURI;
}
function getPageInfo(headers, index2) {
  return {
    ...JSON_LD_PAGE_INFO,
    url: index2,
    name: decodeMimeHeader(headers[SUBJECT_HEADER]),
    dateCreated: headers[DATE_HEADER],
    additionalProperty: {
      ...JSON_LD_PAGE_INFO.additionalProperty,
      value: decodeMimeHeader(headers[FROM_HEADER])
    }
  };
}

// node_modules/mhtml-to-html/lib/parse.js
var MHTML_HEADERS = 0;
var MTHML_CONTENT = 1;
var MHTML_DATA = 2;
var MHTML_END = 3;
var STRING_TYPE = "string";
var HEADER_SEPARATOR = ":";
var QUOTED_PRINTABLE_ENCODING = "quoted-printable";
var BINARY_ENCODING = "binary";
var CONTENT_TYPE_HEADER2 = "Content-Type";
var CONTENT_TRANSFER_ENCODING_HEADER = "Content-Transfer-Encoding";
var CONTENT_ID_HEADER = "Content-ID";
var CONTENT_LOCATION_HEADER = "Content-Location";
var BASE64_ENCODING2 = "base64";
var UTF8_CHARSET2 = "utf-8";
var META_TAG2 = "META";
var CONTENT_ATTRIBUTE2 = "content";
var CHARSET_ATTRIBUTE2 = "charset";
var HTTP_EQUIV_ATTRIBUTE2 = "http-equiv";
var AT_RULE2 = "Atrule";
var CHARSET_IDENTIFIER = "charset";
var RANDOM_ID_PREFIX = "_";
var parse_default = parse3;
function parse3(mhtml, { DOMParser: DOMParser2 } = { DOMParser: globalThis.DOMParser }, context = { resources: {}, frames: {} }) {
  if (typeof mhtml === STRING_TYPE) {
    mhtml = encodeString(mhtml);
  }
  const headers = {};
  const { resources, frames } = context;
  let resource, transferEncoding, boundary, headerKey;
  let content = {};
  let state = MHTML_HEADERS;
  let indexMhtml = 0;
  let indexStartEmbeddedMhtml;
  while (state !== MHTML_END && indexMhtml < mhtml.length - 1) {
    let next;
    if (state === MHTML_HEADERS) {
      next = getLine();
      if (!isLineFeed(next)) {
        splitHeaders(next, headers);
      } else {
        if (headers[CONTENT_TYPE_HEADER2]) {
          boundary = getBoundary(headers[CONTENT_TYPE_HEADER2]);
        }
        if (boundary) {
          while (indexOf(next, boundary) === -1 && indexMhtml < mhtml.length - 1) {
            next = getLine();
          }
        } else {
          const previousIndex = indexMhtml;
          next = getLine(transferEncoding);
          if (!boundary && startsWithBoundary(next)) {
            boundary = decodeString(next);
          } else {
            indexMhtml = previousIndex;
          }
        }
        content = {};
        state = MTHML_CONTENT;
      }
    } else if (state === MTHML_CONTENT) {
      if (boundary) {
        if (indexStartEmbeddedMhtml === void 0) {
          indexStartEmbeddedMhtml = indexMhtml;
        }
        next = getLine();
        if (!isLineFeed(next)) {
          splitHeaders(next, content);
        } else {
          initResource(content);
          if (!isMultipartAlternative(resource.contentType)) {
            indexStartEmbeddedMhtml = void 0;
          }
          state = MHTML_DATA;
        }
      } else {
        initResource(headers);
        state = MHTML_DATA;
      }
    } else if (state === MHTML_DATA) {
      const indexEndData = parseResourceData();
      if (indexStartEmbeddedMhtml !== void 0 && indexEndData !== void 0) {
        resource.used = true;
        context.index = convertEmbeddedMhtml(indexEndData);
      } else {
        processResource();
      }
      state = indexMhtml >= mhtml.length - 1 ? MHTML_END : MTHML_CONTENT;
    }
  }
  return { headers, frames, resources, index: context.index };
  function getLine(transferEncoding2) {
    const indexStart = indexMhtml;
    while (!isLineFeed([mhtml[indexMhtml]]) && indexMhtml++ < mhtml.length - 1) ;
    indexMhtml++;
    const line = mhtml.slice(indexStart, indexMhtml);
    return transferEncoding2 === QUOTED_PRINTABLE_ENCODING ? decodeQuotedPrintable(line) : line;
  }
  function splitHeaders(line, obj) {
    const lineString = decodeString(line);
    const indexColumn = lineString.indexOf(HEADER_SEPARATOR);
    if (indexColumn > -1) {
      headerKey = lineString.substring(0, indexColumn).trim();
      obj[headerKey] = lineString.substring(indexColumn + 1, lineString.length).trim();
    } else {
      obj[headerKey] += lineString.trim();
    }
  }
  function initResource(resourceData) {
    transferEncoding = resourceData[CONTENT_TRANSFER_ENCODING_HEADER];
    const contentType = resourceData[CONTENT_TYPE_HEADER2];
    const contentId = resourceData[CONTENT_ID_HEADER];
    let id = resourceData[CONTENT_LOCATION_HEADER];
    if (transferEncoding) {
      transferEncoding = transferEncoding.toLowerCase();
    }
    resource = {
      transferEncoding,
      contentType,
      data: [],
      id
    };
    if (id === void 0) {
      if (contentId !== void 0) {
        id = contentId;
      } else {
        do {
          id = RANDOM_ID_PREFIX + Math.random().toString(36).substring(2);
        } while (resources[id]);
      }
      resource.id = id;
    }
    if (context.index === void 0 && isDocument(contentType)) {
      context.index = id;
    }
    if (contentId !== void 0) {
      frames[contentId] = resource;
    }
    if (!resources[id]) {
      resources[id] = resource;
    }
    content = {};
  }
  function parseResourceData() {
    let next = getLine(transferEncoding);
    let indexEndData, boundaryFound;
    while (!boundaryFound && indexMhtml < mhtml.length - 1) {
      indexEndData = indexMhtml;
      const indexBoundary = indexOf(next, boundary);
      if (indexBoundary !== -1) {
        indexEndData = indexEndData - next.length + indexBoundary - 2;
        if (indexBoundary > 2) {
          next = next.slice(0, indexBoundary - 2);
        } else {
          next = [];
        }
        boundaryFound = true;
      }
      if (resource.transferEncoding === QUOTED_PRINTABLE_ENCODING) {
        if (resource.data.length > 2 && resource.data[resource.data.length - 3] === 61 && endsWithCRLF(next)) {
          resource.data.splice(resource.data.length - 3, 3);
        } else if (resource.data.length > 1 && resource.data[resource.data.length - 2] === 61 && endsWithLF(next)) {
          resource.data.splice(resource.data.length - 2, 2);
        }
      } else if (resource.transferEncoding === BASE64_ENCODING2) {
        if (endsWithCRLF(next)) {
          next = next.slice(0, next.length - 2);
        } else if (endsWithLF(next)) {
          next = next.slice(0, next.length - 1);
        }
      }
      resource.data.splice(resource.data.length, 0, ...next);
      if (!boundaryFound) {
        next = getLine(transferEncoding);
      }
    }
    return indexEndData;
  }
  function convertEmbeddedMhtml(indexEnd) {
    const context2 = { resources, frames };
    if (endsWithCRLF(mhtml)) {
      indexEnd -= 2;
    } else if (endsWithLF(mhtml)) {
      indexEnd--;
    }
    parse3(mhtml.slice(indexStartEmbeddedMhtml, indexEnd), { DOMParser: DOMParser2 }, context2);
    return context2.index;
  }
  function processResource() {
    resource.data = resource.rawData = new Uint8Array(resource.data);
    const charset = getCharset(resource.contentType);
    if (resource.transferEncoding === BINARY_ENCODING && !isText(resource.contentType)) {
      resource.transferEncoding = BASE64_ENCODING2;
      resource.data = decodeBinary(resource.data);
    } else {
      resource.data = decodeString(resource.data, charset);
    }
    resource.contentType = replaceCharset(resource.contentType, UTF8_CHARSET2);
    if (isStylesheet(resource.contentType)) {
      processStylesheetCharset(charset);
    } else if (isDocument(resource.contentType)) {
      processDocumentCharset(charset);
    }
    delete resource.rawData;
  }
  function processStylesheetCharset(charset) {
    try {
      let ast = Zb(resource.data);
      if (ast.children.first && ast.children.first.type === AT_RULE2 && ast.children.first.name.toLowerCase() === CHARSET_IDENTIFIER) {
        const charsetNode = ast.children.first;
        const cssCharset = charsetNode.prelude.children.first.value.toLowerCase();
        if (cssCharset !== UTF8_CHARSET2 && cssCharset !== charset) {
          resource.data = decodeString(resource.rawData, cssCharset);
          ast = Zb(resource.data);
        }
        ast.children.remove(ast.children.head);
        resource.data = Jb(ast);
      }
    } catch (_2) {
    }
  }
  function processDocumentCharset(charset) {
    const contentType = resource.contentType.split(";")[0];
    let dom = parseDOM(resource.data, contentType, DOMParser2);
    let charserMetaElement = getMetaCharsetElement(dom.document.documentElement);
    if (charserMetaElement) {
      let htmlCharset = charserMetaElement.getAttribute(CHARSET_ATTRIBUTE2);
      if (htmlCharset) {
        htmlCharset = htmlCharset.toLowerCase();
        if (htmlCharset !== UTF8_CHARSET2 && htmlCharset !== charset) {
          resource.data = decodeString(resource.rawData, charset);
          dom = parseDOM(resource.data, contentType, DOMParser2);
          charserMetaElement = getMetaCharsetElement(dom.document);
        }
      }
      charserMetaElement.remove();
      resource.data = dom.serialize();
    }
    let metaElement = getMetaContentTypeElement(dom.document);
    if (metaElement) {
      const contentType2 = metaElement.getAttribute(CONTENT_ATTRIBUTE2);
      const htmlCharset = getCharset(contentType2);
      if (htmlCharset && htmlCharset !== UTF8_CHARSET2 && htmlCharset !== charset) {
        resource.data = decodeString(resource.rawData, htmlCharset);
        dom = parseDOM(resource.data, contentType2, DOMParser2);
        metaElement = getMetaContentTypeElement(dom.document.documentElement);
      }
      metaElement.remove();
      resource.data = dom.serialize();
    }
  }
}
function getMetaCharsetElement(document2) {
  const metaElements = document2.getElementsByTagName(META_TAG2);
  return Array.from(metaElements).find((metaElement) => metaElement.getAttribute(CHARSET_ATTRIBUTE2));
}
function getMetaContentTypeElement(document2) {
  const metaElements = document2.getElementsByTagName(META_TAG2);
  return Array.from(metaElements).find((metaElement) => metaElement.getAttribute(HTTP_EQUIV_ATTRIBUTE2) && metaElement.getAttribute(HTTP_EQUIV_ATTRIBUTE2).toLowerCase() === CONTENT_TYPE_HEADER2.toLowerCase());
}

// node_modules/mhtml-to-html/lib/mod.js
function convert2(mhtml, config2 = {}) {
  if (config2.DOMParser === void 0 && globalThis.DOMParser) {
    config2.DOMParser = globalThis.DOMParser;
  }
  if (typeof mhtml === "string" || mhtml instanceof Uint8Array) {
    mhtml = parse4(mhtml, config2);
  }
  return convert_default(mhtml, config2);
}
function parse4(data, config2 = {}) {
  if (config2.DOMParser === void 0 && globalThis.DOMParser) {
    config2.DOMParser = globalThis.DOMParser;
  }
  return parse_default(data, config2);
}

// node_modules/mhtml-to-html/lib/mod-node.js
function convert3(mhtml, config2 = {}) {
  return convert2(mhtml, { ...config2, DOMParser });
}

// src/HtmlView.ts
var import_mark = __toESM(require_mark());

// node_modules/number-precision/build/index.es.js
function strip(num, precision) {
  if (precision === void 0) {
    precision = 15;
  }
  return +parseFloat(Number(num).toPrecision(precision));
}
function digitLength(num) {
  var eSplit = num.toString().split(/[eE]/);
  var len = (eSplit[0].split(".")[1] || "").length - +(eSplit[1] || 0);
  return len > 0 ? len : 0;
}
function float2Fixed(num) {
  if (num.toString().indexOf("e") === -1) {
    return Number(num.toString().replace(".", ""));
  }
  var dLen = digitLength(num);
  return dLen > 0 ? strip(Number(num) * Math.pow(10, dLen)) : Number(num);
}
function checkBoundary(num) {
  if (_boundaryCheckingState) {
    if (num > Number.MAX_SAFE_INTEGER || num < Number.MIN_SAFE_INTEGER) {
      console.warn(num + " is beyond boundary when transfer to integer, the results may not be accurate");
    }
  }
}
function createOperation(operation) {
  return function() {
    var nums = [];
    for (var _i2 = 0; _i2 < arguments.length; _i2++) {
      nums[_i2] = arguments[_i2];
    }
    var first = nums[0], others = nums.slice(1);
    return others.reduce(function(prev, next) {
      return operation(prev, next);
    }, first);
  };
}
var times = createOperation(function(num1, num2) {
  var num1Changed = float2Fixed(num1);
  var num2Changed = float2Fixed(num2);
  var baseNum = digitLength(num1) + digitLength(num2);
  var leftValue = num1Changed * num2Changed;
  checkBoundary(leftValue);
  return leftValue / Math.pow(10, baseNum);
});
var plus = createOperation(function(num1, num2) {
  var baseNum = Math.pow(10, Math.max(digitLength(num1), digitLength(num2)));
  return (times(num1, baseNum) + times(num2, baseNum)) / baseNum;
});
var minus = createOperation(function(num1, num2) {
  var baseNum = Math.pow(10, Math.max(digitLength(num1), digitLength(num2)));
  return (times(num1, baseNum) - times(num2, baseNum)) / baseNum;
});
var divide = createOperation(function(num1, num2) {
  var num1Changed = float2Fixed(num1);
  var num2Changed = float2Fixed(num2);
  checkBoundary(num1Changed);
  checkBoundary(num2Changed);
  return times(num1Changed / num2Changed, strip(Math.pow(10, digitLength(num2) - digitLength(num1))));
});
function round(num, decimal) {
  var base = Math.pow(10, decimal);
  var result = divide(Math.round(Math.abs(times(num, base))), base);
  if (num < 0 && result !== 0) {
    result = times(result, -1);
  }
  return result;
}
var _boundaryCheckingState = true;
function enableBoundaryChecking(flag) {
  if (flag === void 0) {
    flag = true;
  }
  _boundaryCheckingState = flag;
}
var index = {
  strip,
  plus,
  minus,
  times,
  divide,
  round,
  digitLength,
  float2Fixed,
  enableBoundaryChecking
};
var index_es_default = index;

// src/HtmlView.ts
var HTML_FILE_EXTENSIONS = ["html", "htm"];
var VIEW_TYPE_HTML = "html-view";
var MHTML_FILE_EXTENSIONS = ["mht", "mhtml"];
var HtmlView = class extends import_obsidian2.FileView {
  constructor(leaf, settings) {
    super(leaf);
    this.settings = settings;
    this.settings = settings;
  }
  async onLoadFile(file) {
    this.contentEl.empty();
    try {
      const contents = await this.app.vault.readBinary(file);
      let htmlStr = null;
      if (this.settings.mhtmlSupport && MHTML_FILE_EXTENSIONS.indexOf(file.extension) >= 0) {
        const { data, title, favicons } = await convert3(new Uint8Array(contents));
        htmlStr = data;
      } else {
        try {
          globalThis.zip = zip_exports;
          const { docContent } = await extract(new Blob([new Uint8Array(contents)]), { noBlobURL: true });
          htmlStr = docContent;
        } catch {
          const decoder = new TextDecoder();
          htmlStr = decoder.decode(contents);
        }
      }
      index_es_default.enableBoundaryChecking(false);
      this.mainView = this.contentEl.createDiv();
      this.mainView.setAttribute("style", "display: flex; flex-direction: column; height: 100%; padding: 0;");
      this.mainView.innerHTML = MAINVIEW_HTML;
      const searchBar = this.mainView.querySelector("#ohpMainView");
      const iframe = this.mainView.querySelector("#ohpIframe");
      let dom = null, applyAnchorFix = true;
      switch (this.settings.opMode) {
        case "BalanceMode" /* Balance */:
          dom = new window.DOMParser().parseFromString(htmlStr, "text/html");
          await removeScriptTagsAndExtScripts(dom);
          await sanitizeAndApplyPatches(dom);
          await restoreStateBySettings(dom, this.settings);
          iframe.csp = "script-src 'none'; require-trusted-types-for 'script'; object-src 'none'; frame-src https: http: mediastream: blob:;";
          iframe.srcdoc = dom.documentElement.outerHTML;
          break;
        case "LowRestrictedMode" /* LowRestricted */:
          dom = new window.DOMParser().parseFromString(htmlStr, "text/html");
          await removeScriptTagsAndExtScripts(dom);
          await restoreStateBySettings(dom, this.settings);
          iframe.srcdoc = dom.documentElement.outerHTML;
          break;
        case "UnestrictedMode" /* Unrestricted */:
          iframe.srcdoc = htmlStr;
          break;
        case "HighRestrictedMode" /* HighRestricted */:
          const purifier = new window.DOMPurify();
          purifier.addHook("afterSanitizeAttributes", ohpAfterSanitizeAttributes);
          const cleanHtmlHR = purifier.sanitize(htmlStr, hrModeConfig);
          iframe.csp = "default-src 'none'; script-src 'none'; object-src 'none'; frame-src https: http: mediastream: blob:; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; ";
          iframe.srcdoc = cleanHtmlHR;
          break;
        case "TextMode" /* Text */:
          const cleanHtmlText = new window.DOMPurify().sanitize(htmlStr, textModeConfig);
          iframe.sandbox = "allow-same-origin";
          iframe.csp = "default-src 'none'; script-src 'none'; object-src 'none'; frame-src 'none'; font-src 'self' data:; img-src 'none'; style-src 'unsafe-inline'; media-src 'none'; ";
          iframe.srcdoc = cleanHtmlText;
          applyAnchorFix = false;
          break;
      }
      iframe.mainView = this.mainView;
      this.mainView.app = this.app;
      this.mainView.settings = this.settings;
      this.mainView.searchBar = searchBar;
      this.mainView.iframe = iframe;
      iframe.onload = async function() {
        if (applyAnchorFix) {
          applyUserInteractivePatches(iframe.contentDocument);
          await modifyAnchorTarget(iframe.contentDocument);
          iframe.contentWindow.addEventListener("click", sdFixAnchorClickHandler);
        }
        await restoreStateBySettings(iframe.contentWindow.document, iframe.mainView.settings);
        buildUserInteractiveFacilities(iframe.mainView);
        iframe.contentWindow.addEventListener("keydown", (evt) => {
          iframe.dispatchEvent(new evt.constructor(evt.type, evt));
        }, false);
      };
      dispatchEvent(new CustomEvent("DOMContentLoaded"));
    } catch (error) {
      showError(error);
    }
  }
  onunload() {
  }
  onPaneMenu(menu, source) {
    if (source !== "more-options")
      return;
    menu.addItem((item) => {
      item.setTitle(i18next.t("interface.menu.find")).setIcon("lucide-search").onClick(async () => {
        this.mainView.openSearch();
      });
    });
    menu.addItem((item) => {
      item.setTitle(i18next.t("commands.zoom-in")).setIcon("plus-with-circle").onClick(async () => {
        this.mainView.ZoomIn();
      });
    });
    menu.addItem((item) => {
      item.setTitle(i18next.t("commands.zoom-out")).setIcon("minus-with-circle").onClick(async () => {
        this.mainView.ZoomOut();
      });
    });
    menu.addItem((item) => {
      item.setTitle(i18next.t("commands.reset-zoom")).setIcon("reset").onClick(async () => {
        this.mainView.ResetZoom();
      });
    });
    menu.addSeparator();
    super.onPaneMenu(menu, source);
  }
  canAcceptExtension(extension) {
    return HTML_FILE_EXTENSIONS.includes(extension);
  }
  getViewType() {
    return VIEW_TYPE_HTML;
  }
  getIcon() {
    return "code-glyph";
  }
};
async function showError(e2) {
  const notice = new import_obsidian2.Notice("", 8e3);
  notice.noticeEl.createEl("strong", { text: "HTML Reader error" });
  notice.noticeEl.createDiv({ text: `${e2.message}` });
}
function sdFixAnchorClickHandler(evt) {
  const aElm = evt.composedPath().find((elm) => elm.nodeName === "A");
  const regex = /href\s*=\s*['"]\s*#/igm;
  if (!aElm || !aElm.href || !regex.test(aElm.outerHTML))
    return;
  const rootNode = aElm.getRootNode();
  if (!aElm.hash || aElm.hash.length <= 1) {
    if (rootNode.location)
      rootNode.location.hash = "#";
    else
      rootNode.scrollTop = 0;
  } else {
    const idInternal = decodeURIComponent(aElm.hash.slice(1));
    const targetElm = rootNode.getElementById(idInternal);
    if (targetElm) {
      if (rootNode.location) {
        rootNode.location.hash = idInternal;
      } else {
        targetElm.scrollIntoView();
      }
    }
  }
  evt.preventDefault();
}
function ohpAfterSanitizeAttributes(node) {
  if (!node.nodeName)
    return;
  switch (node.nodeName) {
    case "INPUT":
    case "BUTTON":
    case "TEXTAREA":
    case "SELECT":
    case "OPTION":
      node.setAttribute("readOnly", "true");
      node.setAttribute("disabled", "disabled");
      break;
    case "IFRAME":
      node.setAttribute("sandbox", "");
      break;
  }
}
async function sanitizeAndApplyPatches(doc) {
  for (const elm of doc.all) {
    let illSet = /* @__PURE__ */ new Set();
    for (const attr of elm.attributes) {
      let name = attr.name;
      if (name.indexOf("-") > 0)
        name = `${name.split("-")[0]}-*`;
      if (!BM_ALLOWED_ATTRS.contains(name) && !illSet.has(attr.name))
        illSet.add(attr.name);
    }
    for (const attrName of illSet) {
      elm.removeAttribute(attrName);
    }
    if (elm instanceof HTMLAnchorElement) {
      if (elm.href && elm.protocol.contains("javascript:")) {
        elm.setAttribute("href", "javascript:void(0)");
        elm.setAttribute("style", "cursor: default;");
      }
    } else if (elm instanceof HTMLInputElement) {
      elm.readOnly = true;
    } else if (elm instanceof HTMLTextAreaElement) {
      elm.setAttribute("disabled", "disabled");
    } else if (elm instanceof HTMLIFrameElement) {
      if (elm.src && elm.src !== "about:blank") {
        try {
          let url = new URL(elm.src);
          if (url.protocol.contains("javascript:"))
            elm.removeAttribute("src");
        } catch {
          elm.removeAttribute("src");
        }
      }
      elm.setAttribute("sandbox", "");
    }
  }
}
function applyUserInteractivePatches(doc) {
  if (!doc.body.style) {
    doc.body.setAttribute("style", "overflow: auto; user-select: text;");
    return;
  }
  if (doc.body.style.overflow === "")
    doc.body.style.overflow = "auto";
  if (doc.body.style.userSelect === "")
    doc.body.style.userSelect = "text";
}
async function removeScriptTagsAndExtScripts(doc) {
  let allNodes = doc.querySelectorAll("script");
  for (var node of allNodes) {
    node.parentNode.removeChild(node);
  }
  allNodes = doc.querySelectorAll("link");
  for (var node of allNodes) {
    if (!node.rel)
      continue;
    if (node.rel.contains("script"))
      node.parentNode.removeChild(node);
    else if (node.rel.contains("preload") && node.as && node.as.contains("script"))
      node.parentNode.removeChild(node);
  }
}
async function modifyAnchorTarget(doc) {
  let baseElm = doc.querySelector("base");
  if (!baseElm) {
    baseElm = doc.createElement("base");
    doc.head.appendChild(baseElm);
  }
  baseElm.target = "_blank";
  const regex = /href\s*=\s*['"]\s*#/igm;
  const aElms = doc.querySelectorAll("a");
  for (const aElm of aElms) {
    if (aElm.target === "_self")
      aElm.target = "_blank";
    if (!aElm.href)
      continue;
    if (!regex.test(aElm.outerHTML)) {
      if (!aElm.rel) {
        aElm.rel = "noopener noreferrer";
      } else {
        if (!aElm.rel.contains("noopener"))
          aElm.rel += " noopener";
        if (!aElm.rel.contains("noreferrer"))
          aElm.rel += " noreferrer";
      }
      aElm.addEventListener("click", (evt) => {
        if (evt.ctrlKey) {
          evt.preventDefault();
          app.workspace.openLinkText(aElm.getAttribute("href"), "", true);
        }
      });
    }
  }
}
async function restoreStateBySettings(doc, settings) {
  doc.all[0].style.transformOrigin = "left top";
  doc.all[0].style.transform = `scale(${settings.zoomValue})`;
  if (settings.bgColorEnabled) {
    doc.body.setAttribute("bgColor", settings.bgColor);
    doc.body.style.backgroundColor = settings.bgColor;
  }
}
function isUnselectableElement(elm) {
  var style = getComputedStyle(elm);
  return style.display === "none" || elm.offsetWidth === 0;
}
var isAppleSys = isMacPlatform() || isIosPlatform();
function mapNativeHotkeys(app2, cmdId) {
  let ohks = app2.hotkeyManager.getHotkeys(cmdId) || app2.hotkeyManager.getDefaultHotkeys(cmdId);
  const nhks = [];
  if (!ohks || ohks.length <= 0)
    return nhks;
  const nhksNoMod = [];
  for (let ohk of ohks) {
    const hk = new Hotkey();
    hk.key = ohk.key;
    hk.modifiers = [];
    if (ohk.modifiers && ohk.modifiers.length > 0) {
      for (let mod of ohk.modifiers) {
        if (mod === "Mod") {
          hk.modifiers.push(isAppleSys ? "Meta" : "Ctrl");
        } else {
          hk.modifiers.push(mod);
        }
      }
      nhks.push(hk);
    } else {
      nhksNoMod.push(hk);
    }
  }
  return nhks.concat(nhksNoMod);
}
function checkHotkeyModifier(modifiers, evt) {
  if (!modifiers || modifiers.length <= 0)
    return true;
  for (let mod of modifiers) {
    switch (mod) {
      case "Ctrl":
        if (!evt.ctrlKey)
          return false;
        break;
      case "Meta":
        if (!evt.metaKey)
          return false;
        break;
      case "Shift":
        if (!evt.shiftKey)
          return false;
        break;
      case "Alt":
        if (!evt.altKey)
          return false;
        break;
      case "Mod":
        if (isAppleSys ? !evt.metaKey : !evt.ctrlKey)
          return false;
        break;
    }
  }
  return true;
}
async function buildUserInteractiveFacilities(mainView) {
  const searchBar = mainView.searchBar;
  const iframe = mainView.iframe;
  const settings = mainView.settings;
  let isSearchBarVisible = false, hltAllNodes = false;
  let curText;
  let curIndex = -1;
  const allMatched = [];
  const tmpMatched = [];
  const mark = new import_mark.default(iframe.contentWindow.document.body);
  const addMatched = (node) => {
    if (isUnselectableElement(node.parentElement))
      return;
    if (node.textContent && node.textContent.length != curText.length) {
      if (tmpMatched.length <= 0) {
        tmpMatched.push(new Array(node));
        return;
      }
      let tmpText = "";
      for (let idx = 0; idx < tmpMatched.length; ++idx) {
        tmpText += tmpMatched[idx].textContent;
        let tmpText2 = tmpText + node.textContent;
        if (tmpText2.length === curText.length) {
          if (tmpText2.toLowerCase() === curText) {
            let tmpMA = [];
            for (let i = 0; i <= idx; ++i)
              tmpMA.push(tmpMatched[i]);
            tmpMA.push(node);
            allMatched.push(tmpMA);
          }
          for (let i = 0; i <= idx; ++i)
            tmpMatched.shift();
          break;
        }
      }
    } else {
      allMatched.push(new Array(node));
    }
  };
  const obsOpt = {
    "element": "span",
    "className": `ohp-temp-search-class ${HIGHLIGHT_CLASS_NAME}`,
    "separateWordSearch": false,
    "acrossElements": true,
    "each": addMatched
  };
  const tmpOpt = {
    "element": "span",
    "className": `ohp-temp-search-class`,
    "separateWordSearch": false,
    "acrossElements": true,
    "each": addMatched
  };
  const clearObsMark = (array) => {
    if (!array || array.length <= 0)
      return;
    for (let elm of array) {
      if (elm.classList.contains(HIGHLIGHT_CLASS_NAME))
        elm.classList.remove(HIGHLIGHT_CLASS_NAME);
    }
  };
  const setObsMark = (array) => {
    if (!array || array.length <= 0)
      return;
    for (let elm of array) {
      if (!elm.classList.contains(HIGHLIGHT_CLASS_NAME))
        elm.classList.add(HIGHLIGHT_CLASS_NAME);
    }
  };
  const clearAllMarks = (includeTags) => {
    if (includeTags) {
      mark.unmark(obsOpt);
      mark.unmark(tmpOpt);
      hltAllNodes = false;
    } else {
      for (const elm of allMatched) {
        clearObsMark(elm);
      }
    }
    hltAllNodes = false;
  };
  const setAllMarks = (includeObs) => {
    if (allMatched.length <= 0) {
      if (includeObs)
        mark.mark(curText, obsOpt);
      else
        mark.mark(curText, tmpOpt);
    } else if (includeObs) {
      for (const elm of allMatched) {
        setObsMark(elm);
      }
    }
    if (allMatched.length > 0)
      hltAllNodes = true;
  };
  const toggleInputError = (showError2) => {
    if (showError2) {
      clearAllMarks(true);
      if (!input.classList.contains("mod-no-match"))
        input.classList.add("mod-no-match");
    } else {
      if (input.classList.contains("mod-no-match"))
        input.classList.remove("mod-no-match");
    }
  };
  const findNext = () => {
    if (hltAllNodes)
      clearAllMarks(false);
    if (!curText || allMatched.length <= 0)
      return;
    if (curIndex >= 0 && curIndex < allMatched.length)
      clearObsMark(allMatched[curIndex]);
    if (curIndex + 1 >= allMatched.length)
      curIndex = 0;
    else
      curIndex++;
    setObsMark(allMatched[curIndex]);
    allMatched[curIndex][0].scrollIntoView({ behavior: "smooth", block: "center" });
  };
  const findPrev = () => {
    if (hltAllNodes)
      clearAllMarks(false);
    if (!curText || allMatched.length <= 0)
      return;
    if (curIndex >= 0 && curIndex < allMatched.length)
      clearObsMark(allMatched[curIndex]);
    if (curIndex - 1 < 0)
      curIndex = allMatched.length - 1;
    else
      curIndex--;
    setObsMark(allMatched[curIndex]);
    allMatched[curIndex][0].scrollIntoView({ behavior: "smooth", block: "center" });
  };
  const findAll = (text, markAll, selObj) => {
    clearAllMarks(true);
    allMatched.length = 0;
    tmpMatched.length = 0;
    curText = text;
    if (markAll)
      mark.mark(curText, obsOpt);
    else
      mark.mark(curText, tmpOpt);
    if (allMatched.length <= 0) {
      toggleInputError(true);
    } else {
      if (curIndex > allMatched.length)
        curIndex = allMatched.length - 1;
      else if (selObj && selObj.anchorNode) {
        const sibNode = selObj.anchorNode.nextElementSibling || selObj.anchorNode.parentElement;
        if (sibNode && sibNode.nodeName === "SPAN" && sibNode.classList.contains("ohp-temp-search-class")) {
          for (let idx = 0; idx < allMatched.length; ++idx) {
            for (let node of allMatched[idx]) {
              if (node.isSameNode(sibNode)) {
                if (idx >= 1)
                  curIndex = idx - 1;
                else
                  curIndex = idx;
                return;
              }
            }
          }
        }
      }
    }
  };
  const checkAndUpdateMatches = () => {
    let newText = input.value.trim().toLowerCase();
    if (newText === curText)
      return;
    toggleInputError(false);
    if (!newText) {
      clearAllMarks(true);
    } else {
      findAll(newText, false);
    }
    curText = newText;
  };
  const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
  iframe.contentWindow.focus();
  mainView.openSearch = () => {
    searchBar.style.display = "inherit";
    isSearchBarVisible = true;
    input.focus();
    let newText = curText;
    const selObj = iframe.contentWindow.getSelection();
    if (selObj)
      newText = selObj.toString().trim().toLowerCase();
    let reIndex = false;
    if (newText && newText !== curText) {
      findAll(newText, false, selObj);
      reIndex = true;
    }
    if (!curText)
      return;
    input.value = curText;
    if (reIndex) {
      findNext();
      return;
    }
    if (hltAllNodes) {
      setAllMarks(true);
    } else if (curIndex >= 0 && curIndex < allMatched.length) {
      setObsMark(allMatched[curIndex]);
      allMatched[curIndex][0].scrollIntoView({ behavior: "smooth", block: "center" });
    }
  };
  mainView.ZoomIn = () => {
    settings.zoomValue = index_es_default.plus(settings.zoomValue, 0.1);
    iframeDoc.all[0].style.transform = `scale(${settings.zoomValue})`;
    iframe.contentWindow.focus();
  };
  mainView.ZoomOut = () => {
    let scaleValue = index_es_default.minus(settings.zoomValue, 0.1);
    if (scaleValue <= 0.1)
      scaleValue = 0.1;
    settings.zoomValue = scaleValue;
    iframeDoc.all[0].style.transform = `scale(${settings.zoomValue})`;
    iframe.contentWindow.focus();
  };
  mainView.ResetZoom = () => {
    settings.zoomValue = 1;
    iframeDoc.all[0].style.transform = `scale(${settings.zoomValue})`;
    iframe.contentWindow.focus();
  };
  const hksSearch = mapNativeHotkeys(mainView.app, "editor:open-search");
  const hksZoomIn = mapNativeHotkeys(mainView.app, "window:zoom-in");
  const hksZoomOut = mapNativeHotkeys(mainView.app, "window:zoom-out");
  const hksResetZoom = mapNativeHotkeys(mainView.app, "window:reset-zoom");
  const input = searchBar.querySelector("#ohpSearchInput");
  input.addEventListener("keyup", (evt) => {
    if (evt.altKey && evt.keyCode === 13) {
      sall.click();
    } else if (evt.keyCode === 13) {
      next.click();
    }
  });
  const next = searchBar.querySelector("#ohpSearchNext");
  next.addEventListener("click", (evt) => {
    checkAndUpdateMatches();
    findNext();
  });
  (0, import_obsidian2.setIcon)(next, "lucide-arrow-down");
  const prev = searchBar.querySelector("#ohpSearchPrev");
  prev.addEventListener("click", (evt) => {
    checkAndUpdateMatches();
    findPrev();
  });
  (0, import_obsidian2.setIcon)(prev, "lucide-arrow-up");
  const sall = searchBar.querySelector("#ohpSearchSelectAll");
  sall.addEventListener("click", (evt) => {
    checkAndUpdateMatches();
    if (!curText) {
      clearAllMarks(true);
    } else {
      setAllMarks(true);
    }
  });
  (0, import_obsidian2.setIcon)(sall, "lucide-text-select");
  const exit = searchBar.querySelector("#ohpSearchExit");
  exit.addEventListener("click", (evt) => {
    let preAllNodes = hltAllNodes;
    clearAllMarks(false);
    hltAllNodes = preAllNodes;
    searchBar.style.display = "none";
    isSearchBarVisible = false;
    iframe.contentWindow.focus();
  });
  (0, import_obsidian2.setIcon)(exit, "lucide-x");
  searchBar.addEventListener("keydown", (evt) => {
    if (evt.shiftKey && evt.keyCode === 114) {
      prev.click();
    } else if (evt.key === "F3") {
      next.click();
    } else if (evt.key === "Escape") {
      exit.click();
    }
  });
  iframe.contentWindow.addEventListener("keydown", (evt) => {
    if (evt.shiftKey && evt.keyCode === 114) {
      if (isSearchBarVisible)
        prev.click();
    } else if (evt.altKey && evt.keyCode === 13) {
      if (isSearchBarVisible)
        sall.click();
    } else if (evt.key === "F3") {
      if (isSearchBarVisible)
        next.click();
    } else if (evt.key === "F5") {
      this.app.workspace.getActiveViewOfType(HtmlView)?.leaf.rebuildView();
    } else if (evt.key === "Escape") {
      if (isSearchBarVisible)
        exit.click();
    } else {
      switch (evt.key) {
        case "Control":
        case "Meta":
        case "Shift":
        case "Alt":
          return;
      }
      const ek = evt.key.toUpperCase();
      if (hksSearch && hksSearch.length > 0) {
        for (let hk of hksSearch) {
          if (checkHotkeyModifier(hk.modifiers, evt) && ek === hk.key) {
            evt.preventDefault();
            mainView.openSearch();
            return;
          }
        }
      }
      if (hksZoomIn && hksZoomIn.length > 0) {
        for (let hk of hksZoomIn) {
          if (checkHotkeyModifier(hk.modifiers, evt) && ek === hk.key) {
            evt.preventDefault();
            mainView.ZoomIn();
            return;
          }
        }
      }
      if (hksZoomOut && hksZoomOut.length > 0) {
        for (let hk of hksZoomOut) {
          if (checkHotkeyModifier(hk.modifiers, evt) && ek === hk.key) {
            evt.preventDefault();
            mainView.ZoomOut();
            return;
          }
        }
      }
      if (hksResetZoom && hksResetZoom.length > 0) {
        for (let hk of hksResetZoom) {
          if (checkHotkeyModifier(hk.modifiers, evt) && evt.key === hk.key) {
            evt.preventDefault();
            mainView.ResetZoom();
            return;
          }
        }
      }
    }
  });
  let hlt_style = iframe.contentDocument.createElement("style");
  hlt_style.textContent = HIGHLIGHT_STYLE;
  if (iframe.contentDocument.body.children.length > 0)
    iframe.contentDocument.body.insertBefore(hlt_style, iframe.contentDocument.body.children[0]);
  else
    iframe.contentDocument.body.appendChild(hlt_style);
  if (!settings.zoomByWheelAndGesture)
    return;
  iframe.contentWindow.addEventListener("wheel", (evt) => {
    if (!evt.ctrlKey)
      return;
    evt.preventDefault();
    const cy = evt.clientY, py = evt.pageY, delta = evt.deltaY;
    let origPy = index_es_default.divide(py, settings.zoomValue);
    if (delta < 0)
      mainView.ZoomIn();
    else if (delta > 0)
      mainView.ZoomOut();
    if (py > cy) {
      iframe.contentWindow.scroll({ top: index_es_default.minus(index_es_default.times(origPy, settings.zoomValue), cy), behavior: "auto" });
    }
  }, { passive: false });
  const getTouchDistance = (touches) => {
    const touch1 = touches[0];
    const touch2 = touches[1];
    const dx = index_es_default.minus(touch1.clientX, touch2.clientX);
    const dy = index_es_default.minus(touch1.clientY, touch2.clientY);
    return Math.sqrt(dx * dx + dy * dy);
  };
  let pinchStartDistance = 0, pinchPageY = 0, pinchClientY = 0;
  let touchMoving = 0;
  iframe.contentWindow.addEventListener("touchstart", (evt) => {
    if (evt.touches.length === 2) {
      evt.preventDefault();
      pinchStartDistance = getTouchDistance(evt.touches);
      pinchClientY = index_es_default.divide(index_es_default.plus(evt.touches[0].clientY, evt.touches[1].clientY), 2);
      pinchPageY = index_es_default.divide(index_es_default.plus(evt.touches[0].pageY, evt.touches[1].pageY), 2);
    }
  }, { passive: false });
  iframe.contentWindow.addEventListener("touchmove", (evt) => {
    if (evt.touches.length !== 2)
      return;
    if (evt.cancelable) {
      evt.preventDefault();
      evt.stopPropagation();
    }
    if (touchMoving++ !== 3)
      return;
    touchMoving++;
    const pinchDistance = getTouchDistance(evt.touches);
    const cy = pinchClientY, py = pinchPageY;
    let origPy = index_es_default.divide(py, settings.zoomValue);
    if (pinchDistance > pinchStartDistance) {
      mainView.ZoomIn();
    } else if (pinchDistance < pinchStartDistance) {
      mainView.ZoomOut();
    }
    pinchStartDistance = pinchDistance;
    if (py > cy) {
      pinchPageY = index_es_default.times(origPy, settings.zoomValue);
      iframe.contentWindow.scroll({ top: index_es_default.minus(pinchPageY, cy), behavior: "auto" });
    }
    touchMoving = 0;
  }, { passive: false });
}
var Hotkey = class {
};
var HIGHLIGHT_CLASS_NAME = "obsidian-search-match-mark";
var MAINVIEW_HTML = `
<div class="document-search-container" style="display: none; border: none; width: 100%" width="100%" id="ohpMainView">
  <div class="document-search">
    <input class="document-search-input" type="search" placeholder="${i18next.t("editor.search.placeholder-find")}" id="ohpSearchInput">
    <div class="document-search-buttons">
      <button class="document-search-button" aria-label="${i18next.t("editor.search.label-previous")} ${isAppleSys ? "\u21E7F3" : "Shift + F3"}" aria-label-position="top" id="ohpSearchPrev"></button>
      <button class="document-search-button" aria-label="${i18next.t("editor.search.label-next")} F3" aria-label-position="top" id="ohpSearchNext"></button>
      <button class="document-search-button" aria-label="${i18next.t("editor.search.label-find-all")} ${isAppleSys ? "\u2325Enter" : "Alt + Enter"}" aria-label-position="top" id="ohpSearchSelectAll"></button>
	  <span class="document-search-close-button" aria-label="${i18next.t("editor.search.label-exit-search")}" aria-label-position="top" id="ohpSearchExit"></span>
    </div>
  </div>
</div>

<iframe style="border: none; flex-grow: 1; width: 100%; overflow: hidden;" loading="eager" margin="0" padding="0"  width="100%" height="100%" id="ohpIframe">
</iframe>
`;
var HIGHLIGHT_STYLE = `

  span.obsidian-search-match-highlight {
    box-shadow: 0 0 0px 3px hsl(254, 80%, 68%);
    mix-blend-mode: darken;
	border-radius: 2px;
  }
  span.obsidian-search-match-mark {
    background-color: mark;
    color: marktext;
	border-radius: 2px;
  }

`;
var textModeConfig = {
  WHOLE_DOCUMENT: true,
  // Default TAGs ATTRIBUTEs allow list & blocklist https://github.com/cure53/DOMPurify/wiki/Default-TAGs-ATTRIBUTEs-allow-list-&-blocklist
  // allowed tags https://github.com/cure53/DOMPurify/blob/main/src/tags.js
  ADD_TAGS: ["meta", "noscript", "slot"],
  FORBID_TAGS: [
    "a",
    "area",
    "audio",
    "button",
    "canvas",
    "datalist",
    "img",
    "input",
    "map",
    "menu",
    "menuitem",
    "nobr",
    "object",
    "picture",
    "source",
    "style",
    "textarea",
    "track",
    "video"
    // 'svg',
  ],
  // allowed attributes https://github.com/cure53/DOMPurify/blob/main/src/attrs.js
  ADD_ATTR: ["target", "charset", "contenteditable", "dirname", "http-equiv", "sandbox", "wrap", "shadowroot"],
  FORBID_ATTR: ["accept", "action", "autopictureinpicture", "autoplay", "background", "capture", "controls", "controlslist", "crossorigin", "decoding", "default", "download", "href", "hreflang", "inputmode", "integrity", "ismap", "loop", "media", "method", "novalidate", "pattern", "playsinline", "poster", "preload", "spellcheck", "shape", "sizes", "src", "style", "type", "usemap"],
  CUSTOM_ELEMENT_HANDLING: {
    tagNameCheck: (tagName) => tagName,
    // allow all tags with custom element format "xxx-yyy"
    attributeNameCheck: null,
    // default / standard attribute allow-list is used
    allowCustomizedBuiltInElements: true
    // customized built-ins are allowed
  },
  // the USE_PROFILES setting will override the ALLOWED_TAGS setting so don't use them together
  USE_PROFILES: { html: true }
};
var hrModeConfig = {
  WHOLE_DOCUMENT: true,
  ADD_TAGS: ["link", "meta", "slot"],
  ADD_ATTR: ["charset", "content", "http-equiv", "sandbox", "shadowroot"],
  ADD_DATA_URI_TAGS: ["a", "area", "img", "link"],
  // allow external protocol handlers in URL attributes (default is false, be careful, XSS risk)
  // by default only http, https, ftp, ftps, tel, mailto, callto, cid and xmpp are allowed.
  // ALLOW_UNKNOWN_PROTOCOLS: true,
  ALLOWED_URI_REGEXP: /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp|app):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i,
  // extend the existing array of elements that are safe for URI-like values (be careful, XSS risk)
  //ADD_URI_SAFE_ATTR: ['my-attr']
  CUSTOM_ELEMENT_HANDLING: {
    tagNameCheck: (tagName) => tagName,
    // allow all tags with custom element format "xxx-yyy"
    attributeNameCheck: null,
    // default / standard attribute allow-list is used
    allowCustomizedBuiltInElements: true
    // customized built-ins are allowed
  }
};
var BM_ALLOWED_ATTRS = [
  // default allowed attributes of sanitize-html
  "center",
  "target",
  // extra allowed attributes from DOMPurify
  // https://github.com/cure53/DOMPurify/blob/main/src/attrs.js
  "accept",
  "action",
  "align",
  "alt",
  "autocapitalize",
  "autocomplete",
  "autopictureinpicture",
  "autoplay",
  "background",
  "bgcolor",
  "border",
  "capture",
  "cellpadding",
  "cellspacing",
  "checked",
  "cite",
  "class",
  "clear",
  "color",
  "cols",
  "colspan",
  "controls",
  "controlslist",
  "coords",
  "crossorigin",
  "datetime",
  "decoding",
  "default",
  "dir",
  "disabled",
  "disablepictureinpicture",
  "disableremoteplayback",
  "download",
  "draggable",
  "enctype",
  "enterkeyhint",
  "face",
  "for",
  "headers",
  "height",
  "hidden",
  "high",
  "href",
  "hreflang",
  "id",
  "inputmode",
  "integrity",
  "ismap",
  "kind",
  "label",
  "lang",
  "list",
  "loading",
  "loop",
  "low",
  "max",
  "maxlength",
  "media",
  "method",
  "min",
  "minlength",
  "multiple",
  "muted",
  "name",
  "nonce",
  "noshade",
  "novalidate",
  "nowrap",
  "open",
  "optimum",
  "pattern",
  "placeholder",
  "playsinline",
  "poster",
  "preload",
  "pubdate",
  "radiogroup",
  "readonly",
  "rel",
  "required",
  "rev",
  "reversed",
  "role",
  "rows",
  "rowspan",
  "spellcheck",
  "scope",
  "selected",
  "shape",
  "size",
  "sizes",
  "span",
  "srclang",
  "start",
  "src",
  "srcset",
  "step",
  "style",
  "summary",
  "tabindex",
  "title",
  "translate",
  "type",
  "usemap",
  "valign",
  "value",
  "width",
  "xmlns",
  "slot",
  // SVG
  "accent-height",
  "accumulate",
  "additive",
  "alignment-baseline",
  "ascent",
  "attributename",
  "attributetype",
  "azimuth",
  "basefrequency",
  "baseline-shift",
  "begin",
  "bias",
  "by",
  "class",
  "clip",
  "clippathunits",
  "clip-path",
  "clip-rule",
  "color",
  "color-interpolation",
  "color-interpolation-filters",
  "color-profile",
  "color-rendering",
  "cx",
  "cy",
  "d",
  "dx",
  "dy",
  "diffuseconstant",
  "direction",
  "display",
  "divisor",
  "dur",
  "edgemode",
  "elevation",
  "end",
  "fill",
  "fill-opacity",
  "fill-rule",
  "filter",
  "filterunits",
  "flood-color",
  "flood-opacity",
  "font-family",
  "font-size",
  "font-size-adjust",
  "font-stretch",
  "font-style",
  "font-variant",
  "font-weight",
  "fx",
  "fy",
  "g1",
  "g2",
  "glyph-name",
  "glyphref",
  "gradientunits",
  "gradienttransform",
  "image-rendering",
  "in",
  "in2",
  "k",
  "k1",
  "k2",
  "k3",
  "k4",
  "kerning",
  "keypoints",
  "keysplines",
  "keytimes",
  "lengthadjust",
  "letter-spacing",
  "kernelmatrix",
  "kernelunitlength",
  "lighting-color",
  "local",
  "marker-end",
  "marker-mid",
  "marker-start",
  "markerheight",
  "markerunits",
  "markerwidth",
  "maskcontentunits",
  "maskunits",
  "mask",
  "mode",
  "numoctaves",
  "offset",
  "operator",
  "opacity",
  "order",
  "orient",
  "orientation",
  "origin",
  "overflow",
  "paint-order",
  "path",
  "pathlength",
  "patterncontentunits",
  "patterntransform",
  "patternunits",
  "points",
  "preservealpha",
  "preserveaspectratio",
  "primitiveunits",
  "r",
  "rx",
  "ry",
  "radius",
  "refx",
  "refy",
  "repeatcount",
  "repeatdur",
  "restart",
  "result",
  "rotate",
  "scale",
  "seed",
  "shape-rendering",
  "specularconstant",
  "specularexponent",
  "spreadmethod",
  "startoffset",
  "stddeviation",
  "stitchtiles",
  "stop-color",
  "stop-opacity",
  "stroke-dasharray",
  "stroke-dashoffset",
  "stroke-linecap",
  "stroke-linejoin",
  "stroke-miterlimit",
  "stroke-opacity",
  "stroke",
  "stroke-width",
  "surfacescale",
  "systemlanguage",
  "tabindex",
  "targetx",
  "targety",
  "transform",
  "transform-origin",
  "text-anchor",
  "text-decoration",
  "text-rendering",
  "textlength",
  "u1",
  "u2",
  "unicode",
  "values",
  "viewbox",
  "visibility",
  "version",
  "vert-adv-y",
  "vert-origin-x",
  "vert-origin-y",
  "word-spacing",
  "wrap",
  "writing-mode",
  "xchannelselector",
  "ychannelselector",
  "x",
  "x1",
  "x2",
  "y",
  "y1",
  "y2",
  "z",
  "zoomandpan",
  // mathML is not supported by Obsidian/Chrome/Chromium, ref: https://caniuse.com/mathml
  //'accent', 'accentunder', 'bevelled', 'close', 'columnsalign', 'columnlines', 'columnspan', 'denomalign', 'depth', 'displaystyle', 'encoding', 'fence', 'frame', 'largeop', 'length', 'linethickness', 'lspace', 'lquote', 'mathbackground', 'mathcolor', 'mathsize', 'mathvariant', 'maxsize', 'minsize', 'movablelimits', 'notation', 'numalign', 'open', 'rowalign', 'rowlines', 'rowspacing', 'rowspan', 'rspace', 'rquote', 'scriptlevel', 'scriptminsize', 'scriptsizemultiplier', 'selection', 'separator', 'separators', 'stretchy', 'subscriptshift', 'supscriptshift', 'symmetric', 'voffset',
  // XML
  "xlink:href",
  "xml:id",
  "xlink:title",
  "xml:space",
  "xmlns:xlink",
  // default allowed attributes by this plugin
  "async",
  "charset",
  "collapse",
  "collapsed",
  "content",
  "data",
  "defer",
  "external",
  "frameborder",
  "http-equiv",
  "property",
  "sandbox",
  "scoped",
  "scrolling",
  "shadowroot",
  "text",
  "url",
  "var",
  "aria-*",
  "data-*",
  "href-*",
  "src-*",
  "style-*"
];

// src/HtmlPlugin.ts
var HtmlPlugin = class extends import_obsidian3.Plugin {
  async onload() {
    await this.loadSettings();
    this.registerView(VIEW_TYPE_HTML, (leaf) => {
      return new HtmlView(leaf, this.settings);
    });
    try {
      if (this.settings.mhtmlSupport) {
        for (let i = 0; i < MHTML_FILE_EXTENSIONS.length; ++i)
          HTML_FILE_EXTENSIONS.push(MHTML_FILE_EXTENSIONS[i]);
      }
      if (this.settings.extraFileExt !== "") {
        let efe = this.settings.extraFileExt.split(",").map((s) => s.trim()).filter((s) => s.length > 0);
        if (efe && efe.length > 0) {
          for (let i = 0; i < efe.length; ++i)
            HTML_FILE_EXTENSIONS.push(efe[i]);
        }
      }
      this.registerExtensions(HTML_FILE_EXTENSIONS, VIEW_TYPE_HTML);
    } catch (error) {
      await showError(`File extensions ${HTML_FILE_EXTENSIONS} had been registered by other plugin!`);
    }
    this.addSettingTab(new HtmlSettingTab(this.app, this));
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
/*! Bundled license information:

mark.js/dist/mark.js:
  (*!***************************************************
  * mark.js v8.11.1
  * https://markjs.io/
  * Copyright (c) 2014–2018, Julian Kühnel
  * Released under the MIT license https://git.io/vwTVl
  *****************************************************)
*/


/* nosourcemap */