/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// src/main.ts
__export(exports, {
  default: () => FolderIndexPlugin
});
var import_obsidian7 = __toModule(require("obsidian"));

// src/modules/IndexContentProcessorModule.ts
var import_obsidian3 = __toModule(require("obsidian"));

// src/types/MarkdownTextRenderer.ts
var import_obsidian2 = __toModule(require("obsidian"));

// src/types/Utilities.ts
function isIndexFile(path) {
  if (isExcludedPath(path))
    return false;
  const pathParts = path.split(/\//);
  if (pathParts[0] == FolderIndexPlugin.PLUGIN.settings.rootIndexFile)
    return true;
  if (pathParts.length < 2)
    return false;
  const fileName = pathParts[pathParts.length - 1];
  if (FolderIndexPlugin.PLUGIN.settings.indexFileUserSpecified) {
    return fileName == FolderIndexPlugin.PLUGIN.settings.indexFilename + ".md";
  }
  const folderName = pathParts[pathParts.length - 2] + ".md";
  return fileName == folderName || fileName == FolderIndexPlugin.PLUGIN.settings.rootIndexFile;
}
function isExcludedPath(path) {
  for (const excludedFolder of FolderIndexPlugin.PLUGIN.settings.excludeFolders) {
    if (excludedFolder == "")
      continue;
    if (RegExp(`^${excludedFolder}$`).test(path))
      return true;
  }
  for (const pattern of FolderIndexPlugin.PLUGIN.settings.excludePatterns) {
    if (pattern == "")
      continue;
    const escapedPattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, "\\$&").replace(/\\\*/g, ".*");
    if (new RegExp(escapedPattern, "i").test(path))
      return true;
  }
  return false;
}

// src/models/PluginSettingsTab.ts
var import_obsidian = __toModule(require("obsidian"));
var SortBy;
(function(SortBy2) {
  SortBy2["None"] = "Disabled";
  SortBy2["Alphabetically"] = "Alphabetically";
  SortBy2["ReverseAlphabetically"] = "Reverse Alphabetically";
  SortBy2["Natural"] = "Natural";
  SortBy2["ReverseNatural"] = "Reverse Natural";
})(SortBy || (SortBy = {}));
var DEFAULT_SETTINGS = {
  disableHeadlines: false,
  graphOverwrite: false,
  rootIndexFile: "Dashboard.md",
  autoCreateIndexFile: true,
  autoRenameIndexFile: true,
  includeFileContent: false,
  hideIndexFiles: false,
  indexFileInitText: "---\ntags: MOCs\n---\n```folder-index-content\n```",
  autoPreviewMode: false,
  sortIndexFiles: SortBy.Alphabetically,
  sortHeaders: SortBy.None,
  recursiveIndexFiles: false,
  renderFolderBold: true,
  renderFolderItalic: false,
  useBulletPoints: false,
  excludeFolders: [],
  excludePatterns: [],
  recursionLimit: -1,
  headlineLimit: 6,
  indexFileUserSpecified: false,
  indexFilename: "!"
};
var PluginSettingsTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "Graph Settings" });
    new import_obsidian.Setting(containerEl).setName("Overwrite Graph View").setDesc("This will overwrite the default graph view and link files based on their index as well as their normal links").addToggle((component) => component.setValue(this.plugin.settings.graphOverwrite).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.graphOverwrite = value;
      yield this.plugin.saveSettings();
    })));
    containerEl.createEl("h2", { text: "Index File Settings" });
    new import_obsidian.Setting(containerEl).setName("Root Index File").setDesc("The File that is used for the Root Index File").addText((component) => component.setValue(this.plugin.settings.rootIndexFile).setPlaceholder("dashboard.md").onChange((value) => __async(this, null, function* () {
      this.plugin.settings.rootIndexFile = value;
      yield this.plugin.saveSettings();
    })));
    let textFeld = null;
    new import_obsidian.Setting(containerEl).setName("Initial Content").setDesc("Set the initial content for new folder indexes.").addButton((component) => component.setButtonText("Reset").setWarning().setTooltip("Reset to default").onClick(() => __async(this, null, function* () {
      this.plugin.settings.indexFileInitText = DEFAULT_SETTINGS.indexFileInitText;
      textFeld == null ? void 0 : textFeld.setValue(this.plugin.settings.indexFileInitText);
      yield this.plugin.saveSettings();
    }))).addTextArea((component) => {
      textFeld = component;
      component.setPlaceholder("About the folder.").setValue(this.plugin.settings.indexFileInitText).onChange((value) => __async(this, null, function* () {
        this.plugin.settings.indexFileInitText = value;
        yield this.plugin.saveSettings();
      }));
      component.inputEl.rows = 8;
      component.inputEl.cols = 50;
    });
    new import_obsidian.Setting(containerEl).setName("Excluded Folders").setDesc("These Folders will not automatically create an IndexFile").addTextArea((component) => {
      component.setPlaceholder("Folder1\nFolder2/Foo\nFolder3/Foo/Bar").setValue(this.plugin.settings.excludeFolders.join("\n")).onChange((value) => __async(this, null, function* () {
        this.plugin.settings.excludeFolders = value.split("\n");
        yield this.plugin.saveSettings();
      }));
      component.inputEl.rows = 8;
      component.inputEl.cols = 50;
    });
    new import_obsidian.Setting(containerEl).setName("Excluded Patterns").setDesc("Files and folders matching these patterns will be excluded from the content renderer. Use * as wildcard. One pattern per line.").addTextArea((component) => {
      component.setPlaceholder("Assets\n*img*\n*.pdf").setValue(this.plugin.settings.excludePatterns.join("\n")).onChange((value) => __async(this, null, function* () {
        this.plugin.settings.excludePatterns = value.split("\n");
        yield this.plugin.saveSettings();
      }));
      component.inputEl.rows = 8;
      component.inputEl.cols = 50;
    });
    new import_obsidian.Setting(containerEl).setName("Automatically generate IndexFile").setDesc("This will automatically create an IndexFile when you create a new folder").addToggle((component) => component.setValue(this.plugin.settings.autoCreateIndexFile).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.autoCreateIndexFile = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Automatically Rename IndexFile").setDesc("This will automatically rename the folders index file as you rename folders").addToggle((component) => component.setValue(this.plugin.settings.autoRenameIndexFile).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.autoRenameIndexFile = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("User defined index filename").setDesc("This will automatically create an IndexFile with the user defined name").addToggle((component) => component.setValue(this.plugin.settings.indexFileUserSpecified).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.indexFileUserSpecified = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Index filename").setDesc("the filename that is used as the folder index").addText((component) => component.setValue(this.plugin.settings.indexFilename).setPlaceholder("!.md").onChange((value) => __async(this, null, function* () {
      this.plugin.settings.indexFilename = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Hide IndexFile").setDesc("This will hide IndexFiles from the file explorer (Disabled as it causes bugs right now)").addToggle((component) => component.setValue(this.plugin.settings.hideIndexFiles).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.hideIndexFiles = value;
      yield this.plugin.saveSettings();
    })).setDisabled(true));
    containerEl.createEl("h2", { text: "Content Renderer Settings" });
    new import_obsidian.Setting(containerEl).setName("Auto include preview").setDesc("This will automatically include previews when creating index files (!) ").addToggle((component) => component.setValue(this.plugin.settings.includeFileContent).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.includeFileContent = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Disable Headlines").setDesc("This will disable listing headlines within the index file").addToggle((component) => component.setValue(this.plugin.settings.disableHeadlines).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.disableHeadlines = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Headline Limit").setDesc("Limit the Depth of Headlines Displayed").addText((component) => component.setValue(this.plugin.settings.headlineLimit.toString()).setPlaceholder("6").onChange((value) => __async(this, null, function* () {
      let numValue = Number.parseInt(value);
      if (!isNaN(numValue)) {
        if (numValue < 0) {
          numValue = 0;
        } else if (numValue > 6) {
          numValue = 6;
        }
      } else {
        numValue = 6;
      }
      this.plugin.settings.headlineLimit = numValue;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Automatic Preview mode").setDesc("This will automatically swap to preview mode when opening an index file").addToggle((component) => component.setValue(this.plugin.settings.autoPreviewMode).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.autoPreviewMode = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Sort Files Alphabetically").setDesc("This will sort the Files alphabetically").addDropdown((component) => {
      for (const key in SortBy) {
        if (!isNaN(Number(key)))
          continue;
        const enumKey = SortBy[key];
        const enumValue = SortBy[key];
        component.addOption(enumKey, enumValue);
      }
      component.setValue(this.plugin.settings.sortIndexFiles).onChange((value) => __async(this, null, function* () {
        this.plugin.settings.sortIndexFiles = value;
        yield this.plugin.saveSettings();
      }));
    });
    new import_obsidian.Setting(containerEl).setName("Sort Headers Alphabetically").setDesc("This will sort the Headers within a file alphabetically").addDropdown((component) => {
      for (const key in SortBy) {
        if (!isNaN(Number(key)))
          continue;
        const enumKey = SortBy[key];
        const enumValue = SortBy[key];
        component.addOption(enumKey, enumValue);
      }
      component.setValue(this.plugin.settings.sortHeaders).onChange((value) => __async(this, null, function* () {
        this.plugin.settings.sortHeaders = value;
        yield this.plugin.saveSettings();
      }));
    });
    new import_obsidian.Setting(containerEl).setName("Build IndexFiles Recursively").setDesc("This will show all files within a folder and its subfolders").addToggle((component) => component.setValue(this.plugin.settings.recursiveIndexFiles).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.recursiveIndexFiles = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Subfolder Limit").setDesc("Limit the Depth of Subfolders(-1 for no limit)").addText((component) => component.setValue(this.plugin.settings.recursionLimit.toString()).setPlaceholder("-1").onChange((value) => __async(this, null, function* () {
      let numValue = Number.parseInt(value);
      if (isNaN(numValue) || numValue < 0) {
        numValue = -1;
      }
      this.plugin.settings.recursionLimit = numValue;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Render Folders Bold").setDesc("This will render folders in **bold**").addToggle((component) => component.setValue(this.plugin.settings.renderFolderBold).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.renderFolderBold = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Render Folder Italic").setDesc("This will render folders in *italic*").addToggle((component) => component.setValue(this.plugin.settings.renderFolderItalic).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.renderFolderItalic = value;
      yield this.plugin.saveSettings();
    })));
    new import_obsidian.Setting(containerEl).setName("Use bullet-points instead of list").setDesc("This will render the index file as a bullet-point list instead of a numbered list").addToggle((component) => component.setValue(this.plugin.settings.useBulletPoints).onChange((value) => __async(this, null, function* () {
      this.plugin.settings.useBulletPoints = value;
      yield this.plugin.saveSettings();
    })));
  }
};

// src/types/MarkdownTextRenderer.ts
var MarkdownTextRenderer = class {
  constructor(plugin, app) {
    this.plugin = plugin;
    this.app = app;
    this.plugin = plugin;
    this.app = app;
  }
  buildMarkdownText(filesInFolder) {
    const fileTree = this.buildFileTree(filesInFolder);
    return this.buildStructureMarkdownText(fileTree, 0);
  }
  buildStructureMarkdownText(fileTree, indentLevel) {
    let markdownText = "";
    for (const file of fileTree) {
      if (isExcludedPath(file.path)) {
        continue;
      }
      if (file instanceof import_obsidian2.TFolder && this.plugin.settings.recursiveIndexFiles) {
        let children = file.children;
        const indexFile = this.checkIfFolderHasIndexFile(file.children);
        if (indexFile) {
          children = file.children.filter((child) => child.path != indexFile.path);
          markdownText += this.buildContentMarkdownText(indexFile, indentLevel, true);
        } else {
          markdownText += this.buildMarkdownLinkString(file.name, null, indentLevel, true);
        }
        if (this.plugin.settings.recursionLimit === -1 || indentLevel < this.plugin.settings.recursionLimit) {
          markdownText += this.buildStructureMarkdownText(this.buildFileTree(children), indentLevel + 1);
        }
      }
      if (file instanceof import_obsidian2.TFile) {
        if (isIndexFile(file.path)) {
          continue;
        }
        markdownText += this.buildContentMarkdownText(file, indentLevel);
      }
    }
    return markdownText;
  }
  buildContentMarkdownText(file, indentLevel, isFolder = false) {
    var _a, _b;
    let markdownText = "";
    markdownText += this.buildMarkdownLinkString(this.getTitleFromPath(file.path), encodeURI(file.path), indentLevel, isFolder);
    const headers = (_b = (_a = this.app.metadataCache.getFileCache(file)) == null ? void 0 : _a.headings) != null ? _b : [];
    if (headers && !this.plugin.settings.disableHeadlines) {
      const headerTree = this.buildHeaderTree(headers);
      if (this.plugin.settings.headlineLimit !== 0) {
        markdownText += this.buildHeaderMarkdownText(file, headerTree, indentLevel + 1, 1);
      }
    }
    return markdownText;
  }
  buildHeaderMarkdownText(file, headerTree, indentLevel, headlineLevel) {
    let markdownText = "";
    if (this.plugin.settings.sortHeaders === SortBy.Alphabetically) {
      headerTree.sort((a, b) => a.header.heading.localeCompare(b.header.heading));
    } else if (this.plugin.settings.sortHeaders === SortBy.ReverseAlphabetically) {
      headerTree.sort((a, b) => b.header.heading.localeCompare(a.header.heading));
    }
    for (const headerWrapper of headerTree) {
      markdownText += this.buildMarkdownLinkString(headerWrapper.header.heading, encodeURI(file.path) + this.buildHeaderChain(headerWrapper), indentLevel);
      if (headlineLevel < this.plugin.settings.headlineLimit) {
        markdownText += this.buildHeaderMarkdownText(file, headerWrapper.children, indentLevel + 1, headlineLevel + 1);
      }
    }
    return markdownText;
  }
  buildMarkdownLinkString(name, path, indentLevel, isFolder = false) {
    const indentText = this.buildIndentLevel(indentLevel);
    const settings = this.plugin.settings;
    const symbol = settings.useBulletPoints ? "-" : "1.";
    let link = `${indentText}${symbol} ${settings.includeFileContent ? "!" : ""}`;
    if (isFolder) {
      if (settings.renderFolderItalic) {
        name = `*${name}*`;
      }
      if (settings.renderFolderBold) {
        name = `**${name}**`;
      }
    }
    if (path) {
      link += `[${name}](${path})
`;
    } else {
      link += `${name}
`;
    }
    return link;
  }
  getTitleFromPath(path) {
    var _a, _b;
    const file = this.app.vault.getAbstractFileByPath(path);
    if (file instanceof import_obsidian2.TFile) {
      const cache = this.app.metadataCache.getFileCache(file);
      if (cache) {
        return (_b = (_a = cache.frontmatter) == null ? void 0 : _a.title) != null ? _b : file.basename;
      }
      return file.basename;
    }
    return "Something went wrong. Please report this issue.";
  }
  buildHeaderChain(header) {
    if (header.parent) {
      return `${this.buildHeaderChain(header.parent)}#${encodeURI(header.header.heading)}`;
    }
    return `#${encodeURI(header.header.heading)}`;
  }
  checkIfFolderHasIndexFile(children) {
    for (const file of children) {
      if (file instanceof import_obsidian2.TFile) {
        if (isIndexFile(file.path)) {
          return file;
        }
      }
    }
    return null;
  }
  buildHeaderTree(headers) {
    const headerTree = [];
    for (let i = 0; i < headers.length; i++) {
      if (headers[i].level == 1) {
        const wrappedHeader = {
          parent: null,
          header: headers[i],
          children: []
        };
        wrappedHeader.children = this.getHeaderChildren(headers, i + 1, wrappedHeader);
        headerTree.push(wrappedHeader);
      }
    }
    return headerTree;
  }
  getHeaderChildren(headers, startIndex, parentHeader) {
    const children = [];
    if (startIndex > headers.length) {
      return children;
    }
    for (let i = startIndex; i < headers.length; i++) {
      if (headers[i].level <= parentHeader.header.level) {
        return children;
      }
      if (headers[i].level == parentHeader.header.level + 1) {
        const wrappedHeader = {
          parent: parentHeader,
          header: headers[i],
          children: []
        };
        wrappedHeader.children = this.getHeaderChildren(headers, i + 1, wrappedHeader);
        children.push(wrappedHeader);
      }
    }
    return children;
  }
  buildFileTree(filesInFolder) {
    const fileTree = [];
    for (const file of filesInFolder) {
      if (file instanceof import_obsidian2.TFolder && this.plugin.settings.recursiveIndexFiles) {
        fileTree.push(file);
      }
      if (file instanceof import_obsidian2.TFile) {
        fileTree.push(file);
      }
    }
    if (this.plugin.settings.sortIndexFiles === SortBy.Alphabetically) {
      fileTree.sort((a, b) => a.name.localeCompare(b.name));
    } else if (this.plugin.settings.sortIndexFiles === SortBy.ReverseAlphabetically) {
      fileTree.sort((a, b) => b.name.localeCompare(a.name));
    } else if (this.plugin.settings.sortIndexFiles === SortBy.Natural) {
      fileTree.sort((a, b) => this.naturalSort(a.name, b.name));
    } else if (this.plugin.settings.sortIndexFiles === SortBy.ReverseNatural) {
      fileTree.sort((a, b) => this.naturalSort(b.name, a.name));
    }
    return fileTree;
  }
  naturalSort(a, b) {
    const re = /(\d+)|(\D+)/g;
    const aParts = a.split(re).filter((item) => item !== void 0 && item.length > 0);
    const bParts = b.split(re).filter((item) => item !== void 0 && item.length > 0);
    for (let i = 0; i < Math.min(aParts.length, bParts.length); i++) {
      const aPart = aParts[i];
      const bPart = bParts[i];
      if (!isNaN(Number(aPart)) && !isNaN(Number(bPart))) {
        const numA = Number(aPart);
        const numB = Number(bPart);
        if (numA !== numB) {
          return numA - numB;
        }
      } else {
        if (aPart !== bPart) {
          return aPart.localeCompare(bPart);
        }
      }
    }
    return aParts.length - bParts.length;
  }
  buildIndentLevel(indentLevel) {
    let indentText = "";
    for (let j = 0; j < indentLevel; j++) {
      indentText += "	";
    }
    return indentText;
  }
};

// src/modules/IndexContentProcessorModule.ts
var IndexContentProcessorModule = class extends import_obsidian3.MarkdownRenderChild {
  constructor(app, plugin, filePath, container) {
    super(container);
    this.app = app;
    this.plugin = plugin;
    this.filePath = filePath;
    this.container = container;
    this.app = app;
    this.plugin = plugin;
    this.filePath = filePath;
    this.container = container;
  }
  onload() {
    return __async(this, null, function* () {
      yield this.render();
      this.plugin.eventManager.on("settingsUpdate", this.triggerRerender.bind(this));
      this.plugin.registerEvent(this.app.vault.on("rename", this.triggerRerender.bind(this)));
      this.app.workspace.onLayoutReady(() => {
        this.plugin.registerEvent(this.app.vault.on("create", this.triggerRerender.bind(this)));
      });
      this.plugin.registerEvent(this.app.vault.on("delete", this.triggerRerender.bind(this)));
    });
  }
  onunload() {
    return __async(this, null, function* () {
      this.plugin.eventManager.off("settingsUpdate", this.onSettingsUpdate.bind(this));
    });
  }
  onSettingsUpdate() {
    this.render().then();
  }
  triggerRerender() {
    this.render().then();
  }
  render() {
    return __async(this, null, function* () {
      var _a, _b;
      this.container.empty();
      const folder = this.app.vault.getAbstractFileByPath(this.filePath);
      if (folder instanceof import_obsidian3.TFile) {
        const files = (_b = (_a = folder.parent) == null ? void 0 : _a.children) != null ? _b : [];
        const renderer = new MarkdownTextRenderer(this.plugin, this.app);
        yield import_obsidian3.MarkdownRenderer.renderMarkdown(renderer.buildMarkdownText(files), this.container, this.filePath, this);
      }
    });
  }
};

// src/modules/GraphManipulatorModule.ts
var import_obsidian4 = __toModule(require("obsidian"));
var GraphManipulatorModule = class {
  constructor(app, plugin) {
    this.app = app;
    this.plugin = plugin;
    this.app = app;
    this.plugin = plugin;
    this.graphsLeafs = [];
    this.oldGraphOverwrite = this.plugin.settings.graphOverwrite;
    this.load();
  }
  onLayoutChange() {
    this.graphsLeafs = this.app.workspace.getLeavesOfType("graph");
    this.onLeafUpdate(this.graphsLeafs);
  }
  onLeafUpdate(leaves) {
    leaves.forEach((value) => {
      const engine = this.getEngine(value);
      if (engine.oldRender == null) {
        engine.oldRender = engine.render;
        engine.render = () => {
          if (this.plugin.settings.graphOverwrite) {
            this.render(engine);
          } else {
            if (engine.oldRender)
              engine.oldRender();
          }
        };
        if (this.plugin.settings.graphOverwrite) {
          this.clearGraph(engine);
          this.render(engine);
        }
      }
    });
  }
  onSettingsUpdate() {
    if (this.oldGraphOverwrite != this.plugin.settings.graphOverwrite) {
      this.redrawAllGraphs();
      this.oldGraphOverwrite = this.plugin.settings.graphOverwrite;
    }
  }
  load() {
    this.oldGraphOverwrite = this.plugin.settings.graphOverwrite;
    this.plugin.eventManager.on("onLayoutChange", this.onLayoutChange.bind(this));
    this.plugin.eventManager.on("graphLeafUpdate", this.onLeafUpdate.bind(this));
    this.plugin.eventManager.on("settingsUpdate", this.onSettingsUpdate.bind(this));
    this.onLayoutChange();
    if (this.plugin.settings.graphOverwrite) {
      this.clearAllGraphs();
      this.redrawAllGraphs();
    }
  }
  unload() {
    this.graphsLeafs.forEach((value) => {
      const engine = this.getEngine(value);
      if (engine.oldRender != null) {
        engine.render = engine.oldRender;
        delete engine.oldRender;
        this.clearGraph(engine);
        engine.render();
      }
    });
  }
  render(engine) {
    const renderSettings = engine.getOptions();
    const graph = {};
    this.app.vault.getFiles().forEach((file) => __async(this, null, function* () {
      var _a, _b, _c;
      if (Object.keys(engine.fileFilter).length > 0 && !engine.fileFilter[file.path]) {
        return;
      }
      const edges = {};
      const cache = this.app.metadataCache.getFileCache(file);
      if (((_a = file.parent) == null ? void 0 : _a.name) + ".md" == file.name || file.name == this.plugin.settings.rootIndexFile) {
        (_b = file.parent) == null ? void 0 : _b.children.forEach((otherFile) => {
          if (otherFile instanceof import_obsidian4.TFile && file.path != otherFile.path) {
            edges[otherFile.path] = true;
          }
          if (otherFile instanceof import_obsidian4.TFolder) {
            const subIndex = otherFile.children.find((value) => value.name == otherFile.name + ".md");
            if (subIndex != null) {
              edges[subIndex.path] = true;
            }
          }
        });
      }
      if (cache != null) {
        if (cache.links != null) {
          cache.links.forEach((link) => {
            if (link.link.contains("#")) {
              link.link = link.link.split(/#/)[0];
            }
            const linkedFile = this.app.metadataCache.getFirstLinkpathDest(link.link, file.path);
            if (linkedFile == null) {
              edges[link.link] = true;
              if (!renderSettings.hideUnresolved) {
                graph[link.link] = {
                  links: {},
                  type: "unresolved"
                };
              }
            } else {
              edges[linkedFile.path] = true;
            }
          });
        }
        if (cache.frontmatter != null) {
          const frontMatterTags = (0, import_obsidian4.parseFrontMatterTags)(cache.frontmatter);
          if (frontMatterTags != null && renderSettings.showTags) {
            frontMatterTags.forEach((tag) => {
              graph[tag] = {
                links: {},
                type: "tag"
              };
              edges[tag] = true;
            });
          }
        }
        if (cache.tags != null && renderSettings.showTags) {
          cache.tags.forEach((tag) => {
            graph[tag.tag] = {
              links: {},
              type: "tag"
            };
            edges[tag.tag] = true;
          });
        }
        if (cache.embeds != null) {
          cache.embeds.forEach((embed) => {
            const linkedFile = this.app.metadataCache.getFirstLinkpathDest(embed.link, file.path);
            if (linkedFile == null) {
              edges[embed.link] = true;
              graph[embed.link] = {
                links: {},
                type: "unresolved"
              };
            } else {
              edges[linkedFile.path] = true;
            }
          });
        }
      }
      let type = "";
      if (this.app.workspace.getActiveFile() != null && ((_c = this.app.workspace.getActiveFile()) == null ? void 0 : _c.path) == file.path) {
        type = "focused";
      } else if (file.extension != "md") {
        type = "attachment";
      }
      if (type == "attachment" && !renderSettings.showAttachments) {
        return;
      }
      graph[file.path] = {
        links: edges,
        type
      };
    }));
    if (!renderSettings.showOrphans) {
      let allLinks = [];
      for (const graphKey in graph) {
        if (Object.keys(graph[graphKey]["links"]).length > 0) {
          allLinks.push(graphKey);
        }
        allLinks = allLinks.concat(Object.keys(graph[graphKey]["links"]));
      }
      for (const graphKey in graph) {
        if (!allLinks.includes(graphKey)) {
          delete graph[graphKey];
        }
      }
    }
    function AddColorTag(filePath, nodeType) {
      const searchQueries = engine.searchQueries;
      const engineOptions = engine.options;
      const fileFilter = engine.fileFilter;
      return !searchQueries || (nodeType === "" ? filePath === engineOptions.localFile || (fileFilter.hasOwnProperty(filePath) ? fileFilter[filePath] : !engine.hasFilter) : nodeType === "tag" ? searchQueries.every(function(e) {
        return !!e.color || !!e.query.matchTag(filePath);
      }) : nodeType !== "attachment" || searchQueries.every(function(e) {
        return !!e.color || !!e.query.matchFilepath(filePath);
      }));
    }
    for (const graphKey in graph) {
      const returnValue = AddColorTag(graphKey, graph[graphKey].type);
      if (returnValue === true)
        continue;
      graph[graphKey].color = returnValue;
    }
    engine.renderer.setData({
      nodes: graph
    });
  }
  redrawAllGraphs() {
    this.clearAllGraphs();
    this.graphsLeafs.forEach((value) => this.getEngine(value).render());
  }
  clearAllGraphs() {
    this.graphsLeafs.forEach((value) => this.getEngine(value).renderer.setData({
      nodes: {}
    }));
  }
  getEngine(leaf) {
    return leaf.view.dataEngine;
  }
  clearGraph(engine) {
    engine.renderer.setData({
      nodes: {}
    });
  }
};

// src/modules/FolderNoteModule.ts
var import_obsidian5 = __toModule(require("obsidian"));
var FolderNoteModule = class {
  constructor(app, plugin) {
    this.app = app;
    this.plugin = plugin;
    this.viewModeByPlugin = false;
    this.previousState = null;
    this.app = app;
    this.plugin = plugin;
    this.load();
  }
  load() {
    this.app.workspace.onLayoutReady(() => {
      this.plugin.registerEvent(this.app.vault.on("create", this.onCreate.bind(this)));
    });
    this.plugin.registerEvent(this.app.workspace.on("layout-change", this.onLayoutChange.bind(this)));
    this.plugin.registerDomEvent(document, "click", this.onClick.bind(this));
    this.plugin.registerEvent(this.app.vault.on("rename", this.onRename.bind(this)));
  }
  unload() {
  }
  getTargetFromEvent(event) {
    var _a, _b, _c, _d, _e;
    if (!(event.target instanceof HTMLElement)) {
      return null;
    }
    const target = event.target;
    const activePlugins = this.app.plugins.enabledPlugins;
    if (activePlugins.has("file-tree-alternative")) {
      if (target.classList.contains("oz-folder-name")) {
        return (_c = (_b = (_a = target.parentElement) == null ? void 0 : _a.parentElement) == null ? void 0 : _b.parentElement) != null ? _c : null;
      }
      if (target.classList.contains("oz-folder-block")) {
        return (_e = (_d = target.parentElement) == null ? void 0 : _d.parentElement) != null ? _e : null;
      }
    }
    if (target.classList.contains("nav-folder-title"))
      return target;
    if (target.classList.contains("nav-folder-title-content")) {
      return target.parentElement;
    }
    return null;
  }
  indexFilePath(path) {
    if (this.plugin.settings.indexFileUserSpecified) {
      return path + "/" + this.plugin.settings.indexFilename + ".md";
    } else {
      const folderName = path.split("/").pop();
      return path + "/" + folderName + ".md";
    }
  }
  onClick(event) {
    return __async(this, null, function* () {
      const target = this.getTargetFromEvent(event);
      if (target == null)
        return;
      const dataPathAttribute = target.attributes.getNamedItem("data-path");
      let dataPath;
      if (dataPathAttribute == null) {
        return;
      } else {
        dataPath = dataPathAttribute.value;
      }
      let indexFilePath = this.indexFilePath(dataPath);
      if (indexFilePath == "//.md") {
        indexFilePath = this.plugin.settings.rootIndexFile;
      }
      if (!this.doesFileExist(indexFilePath)) {
        if (yield this.createIndexFile(indexFilePath)) {
          yield this.openIndexFile(indexFilePath);
        }
      } else {
        yield this.openIndexFile(indexFilePath);
      }
    });
  }
  doesFileExist(path) {
    return this.app.vault.getAbstractFileByPath(path) != null;
  }
  openIndexFile(path) {
    return __async(this, null, function* () {
      if (!isIndexFile(path)) {
        return;
      }
      const file = this.app.vault.getAbstractFileByPath(path);
      if (file instanceof import_obsidian5.TFile) {
        yield this.app.workspace.getLeaf(false).openFile(file);
      }
    });
  }
  createIndexFile(path) {
    return __async(this, null, function* () {
      if (isExcludedPath(path))
        return false;
      if (this.plugin.settings.autoCreateIndexFile) {
        const name = path.split(/\//).last();
        try {
          if (!name)
            return false;
          const file = yield this.app.vault.create(path, this.plugin.settings.indexFileInitText.replace("{{folder}}", name));
          new import_obsidian5.Notice(`Created index file ${file.basename}`);
          return true;
        } catch (e) {
          new import_obsidian5.Notice(`Failed to create index file ${name}`);
        }
      }
      return false;
    });
  }
  onRename(file, oldPath) {
    return __async(this, null, function* () {
      if (!this.plugin.settings.autoRenameIndexFile) {
        return;
      }
      if (file instanceof import_obsidian5.TFile) {
        return;
      }
      if (oldPath.split("/").pop() == file.name) {
        return;
      }
      const oldIndexFileName = oldPath.split("/").pop();
      if (!this.doesFileExist(`${oldPath}/${oldIndexFileName}.md`))
        return;
      const oldIndexFile = this.app.vault.getAbstractFileByPath(`${oldPath}/${oldIndexFileName}.md`);
      if (!isIndexFile(oldIndexFile.path))
        return;
      oldIndexFile.path = `${file.path}/${oldIndexFileName}.md`;
      try {
        yield this.app.vault.rename(oldIndexFile, `${file.path}/${file.name}.md`);
        new import_obsidian5.Notice(`Renamed index file ${oldIndexFileName} to ${file.name}`);
      } catch (e) {
        new import_obsidian5.Notice(`Failed to rename index file ${oldIndexFileName} to ${file.name}. ${file.name} will be used as the index file.`);
      }
    });
  }
  onLayoutChange() {
    return __async(this, null, function* () {
      const currentLeaf = this.app.workspace.getMostRecentLeaf();
      if (currentLeaf == null) {
        return;
      }
      const currentState = currentLeaf.getViewState();
      try {
        if (this.previousState == null) {
          this.previousState = currentLeaf.getViewState();
        }
        if (!this.plugin.settings.autoPreviewMode) {
          return;
        }
        if (!(currentState.type == "markdown" && this.previousState.type == "markdown")) {
          return;
        }
        if (currentState.state.file == this.previousState.state.file)
          return;
        const currentFile = this.app.vault.getAbstractFileByPath(currentState.state.file);
        if (!isIndexFile(currentFile.path)) {
          if (this.viewModeByPlugin) {
            this.viewModeByPlugin = false;
            currentState.state.mode = "source";
            yield currentLeaf.setViewState(currentState);
          }
          return;
        }
        if (this.previousState.state.mode == "preview") {
          return;
        } else {
          currentState.state.mode = "preview";
          this.viewModeByPlugin = true;
          yield currentLeaf.setViewState(currentState);
        }
      } finally {
        if (currentState.type == "markdown")
          this.previousState = currentLeaf.getViewState();
      }
    });
  }
  onCreate(file) {
    return __async(this, null, function* () {
      if (file instanceof import_obsidian5.TFolder) {
        const indexFilePath = this.indexFilePath(file.path);
        yield this.createIndexFile(indexFilePath);
      }
    });
  }
};

// src/modules/ContextMenuModule.ts
var import_obsidian6 = __toModule(require("obsidian"));
var ContextMenuModule = class {
  constructor(app, plugin) {
    this.app = app;
    this.plugin = plugin;
  }
  addFolderContextMenu() {
    this.app.workspace.on("file-menu", (menu, folder) => {
      if (folder instanceof import_obsidian6.TFolder) {
        const indexFileForFolder = this.getIndexFileForFolder(folder.path);
        if (!this.doesIndexFileExistForFolder(indexFileForFolder)) {
          menu.addItem((item) => {
            item.setTitle("Create Index File").setIcon("any-icon").onClick(() => this.createIndexFileForFolder(indexFileForFolder));
          });
        }
      }
    });
  }
  doesIndexFileExistForFolder(fullPath) {
    return this.app.vault.getAbstractFileByPath(fullPath) != null;
  }
  getIndexFileForFolder(path) {
    return path + "/" + this.getIndexFileName(path) + ".md";
  }
  getIndexFileName(path) {
    return this.plugin.settings.indexFileUserSpecified ? this.plugin.settings.indexFilename : path.split("/").pop() || "";
  }
  createIndexFileForFolder(indexFileForFolder) {
    return __async(this, null, function* () {
      const filePath = indexFileForFolder.substring(0, indexFileForFolder.lastIndexOf("/"));
      try {
        const newFile = yield this.app.vault.create(indexFileForFolder, this.plugin.settings.indexFileInitText.replace("{{folder}}", this.getIndexFileForFolder(indexFileForFolder)));
        new import_obsidian6.Notice(`File "${newFile.name}" created successfully in folder "${newFile.path}".`);
        console.log(`File created at path: ${newFile.path}`);
      } catch (error) {
        console.error(`Failed to create file at path: ${filePath}`, error);
        new import_obsidian6.Notice("Failed to create file. See console for details.");
      }
    });
  }
};

// src/modules/CustomEventTarget.ts
var CustomEventTarget = class extends EventTarget {
  constructor() {
    super(...arguments);
    this.listenersMap = new Map();
  }
  emit(eventName, detail) {
    const event = new CustomEvent(eventName, { detail });
    this.dispatchEvent(event);
  }
  on(eventName, callback) {
    this.addEventListener(eventName, callback);
    const listeners = this.listenersMap.get(eventName) || [];
    listeners.push(callback);
    this.listenersMap.set(eventName, listeners);
  }
  removeAllListeners() {
    for (const [eventName, listeners] of this.listenersMap.entries()) {
      for (const listener of listeners) {
        this.removeEventListener(eventName, listener);
      }
    }
    this.listenersMap.clear();
  }
  off(eventName, callback) {
    const listeners = this.listenersMap.get(eventName);
    if (listeners) {
      const listenerIndex = listeners.indexOf(callback);
      if (listenerIndex !== -1) {
        this.removeEventListener(eventName, callback);
        listeners.splice(listenerIndex, 1);
        this.listenersMap.set(eventName, listeners);
      }
    }
  }
};

// src/main.ts
var FolderIndexPlugin = class extends import_obsidian7.Plugin {
  constructor(app, manifest) {
    super(app, manifest);
    this.oldGraphSetting = false;
    FolderIndexPlugin.PLUGIN = this;
  }
  onload() {
    return __async(this, null, function* () {
      console.log("Loading FolderTableContent");
      this.eventManager = new CustomEventTarget();
      yield this.loadSettings();
      this.settings.hideIndexFiles = false;
      yield this.saveSettings();
      this.oldGraphSetting = this.settings.graphOverwrite;
      this.addSettingTab(new PluginSettingsTab(this.app, this));
      this.app.workspace.onLayoutReady(this.onLayoutReady.bind(this));
      this.registerEvent(this.app.workspace.on("layout-change", this.onLayoutChange.bind(this)));
      this.eventManager.on("settingsUpdate", this.onSettingsUpdate.bind(this));
      this.registerMarkdownCodeBlockProcessor("folder-index-content", (_source, el, ctx) => {
        ctx.addChild(new IndexContentProcessorModule(this.app, this, ctx.sourcePath, el));
      });
      this.folderNodeModule = new FolderNoteModule(this.app, this);
      if (this.settings.graphOverwrite) {
        this.graphManipulator = new GraphManipulatorModule(this.app, this);
      }
      this.contextMenuModule = new ContextMenuModule(this.app, this);
      this.contextMenuModule.addFolderContextMenu();
    });
  }
  onSettingsUpdate() {
    if (this.settings.graphOverwrite != this.oldGraphSetting) {
      if (this.settings.graphOverwrite) {
        this.graphManipulator = new GraphManipulatorModule(this.app, this);
      } else {
        if (this.graphManipulator)
          this.graphManipulator.unload();
      }
      this.oldGraphSetting = this.settings.graphOverwrite;
    }
  }
  onLayoutChange() {
    this.eventManager.emit("onLayoutChange");
  }
  onLayoutReady() {
    this.eventManager.emit("onLayoutReady");
  }
  onunload() {
    return __async(this, null, function* () {
      console.log("Unloading FolderTableContent");
      this.eventManager.removeAllListeners();
      if (this.graphManipulator != null) {
        this.graphManipulator.unload();
      }
      this.folderNodeModule.unload();
    });
  }
  loadSettings() {
    return __async(this, null, function* () {
      this.settings = Object.assign({}, DEFAULT_SETTINGS, yield this.loadData());
    });
  }
  saveSettings() {
    return __async(this, null, function* () {
      yield this.saveData(this.settings);
      this.eventManager.emit("settingsUpdate", this.settings);
    });
  }
};

/* nosourcemap */