/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

'use strict';

var obsidian = require('obsidian');
var require$$0 = require('stream');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var require$$0__default = /*#__PURE__*/_interopDefaultLegacy(require$$0);

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

class ResizeableBuffer{
  constructor(size=100){
    this.size = size;
    this.length = 0;
    this.buf = Buffer.alloc(size);
  }
  prepend(val){
    if(Buffer.isBuffer(val)){
      const length = this.length + val.length;
      if(length >= this.size){
        this.resize();
        if(length >= this.size){
          throw Error('INVALID_BUFFER_STATE')
        }
      }
      const buf = this.buf;
      this.buf = Buffer.alloc(this.size);
      val.copy(this.buf, 0);
      buf.copy(this.buf, val.length);
      this.length += val.length;
    }else {
      const length = this.length++;
      if(length === this.size){
        this.resize();
      }
      const buf = this.clone();
      this.buf[0] = val;
      buf.copy(this.buf,1, 0, length);
    }
  }
  append(val){
    const length = this.length++;
    if(length === this.size){
      this.resize();
    }
    this.buf[length] = val;
  }
  clone(){
    return Buffer.from(this.buf.slice(0, this.length))
  }
  resize(){
    const length = this.length;
    this.size = this.size * 2;
    const buf = Buffer.alloc(this.size);
    this.buf.copy(buf,0, 0, length);
    this.buf = buf;
  }
  toString(encoding){
    if(encoding){
      return this.buf.slice(0, this.length).toString(encoding)
    }else {
      return Uint8Array.prototype.slice.call(this.buf.slice(0, this.length))
    }
  }
  toJSON(){
    return this.toString('utf8')
  }
  reset(){
    this.length = 0;
  }
}

var ResizeableBuffer_1 = ResizeableBuffer;

/*
CSV Parse

Please look at the [project documentation](https://csv.js.org/parse/) for
additional information.
*/

const { Transform } = require$$0__default["default"];


// white space characters
// https://en.wikipedia.org/wiki/Whitespace_character
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions/Character_Classes#Types
// \f\n\r\t\v\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff
const tab = 9;
const nl = 10; // \n, 0x0A in hexadecimal, 10 in decimal
const np = 12;
const cr = 13; // \r, 0x0D in hexadécimal, 13 in decimal
const space = 32;
const boms = {
  // Note, the following are equals:
  // Buffer.from("\ufeff")
  // Buffer.from([239, 187, 191])
  // Buffer.from('EFBBBF', 'hex')
  'utf8': Buffer.from([239, 187, 191]),
  // Note, the following are equals:
  // Buffer.from "\ufeff", 'utf16le
  // Buffer.from([255, 254])
  'utf16le': Buffer.from([255, 254])
};

class Parser extends Transform {
  constructor(opts = {}){
    super({...{readableObjectMode: true}, ...opts, encoding: null});
    this.__originalOptions = opts;
    this.__normalizeOptions(opts);
  }
  __normalizeOptions(opts){
    const options = {};
    // Merge with user options
    for(let opt in opts){
      options[underscore(opt)] = opts[opt];
    }
    // Normalize option `encoding`
    // Note: defined first because other options depends on it
    // to convert chars/strings into buffers.
    if(options.encoding === undefined || options.encoding === true){
      options.encoding = 'utf8';
    }else if(options.encoding === null || options.encoding === false){
      options.encoding = null;
    }else if(typeof options.encoding !== 'string' && options.encoding !== null){
      throw new CsvError('CSV_INVALID_OPTION_ENCODING', [
        'Invalid option encoding:',
        'encoding must be a string or null to return a buffer,',
        `got ${JSON.stringify(options.encoding)}`
      ], options)
    }
    // Normalize option `bom`
    if(options.bom === undefined || options.bom === null || options.bom === false){
      options.bom = false;
    }else if(options.bom !== true){
      throw new CsvError('CSV_INVALID_OPTION_BOM', [
        'Invalid option bom:', 'bom must be true,',
        `got ${JSON.stringify(options.bom)}`
      ], options)
    }
    // Normalize option `cast`
    let fnCastField = null;
    if(options.cast === undefined || options.cast === null || options.cast === false || options.cast === ''){
      options.cast = undefined;
    }else if(typeof options.cast === 'function'){
      fnCastField = options.cast;
      options.cast = true;
    }else if(options.cast !== true){
      throw new CsvError('CSV_INVALID_OPTION_CAST', [
        'Invalid option cast:', 'cast must be true or a function,',
        `got ${JSON.stringify(options.cast)}`
      ], options)
    }
    // Normalize option `cast_date`
    if(options.cast_date === undefined || options.cast_date === null || options.cast_date === false || options.cast_date === ''){
      options.cast_date = false;
    }else if(options.cast_date === true){
      options.cast_date = function(value){
        const date = Date.parse(value);
        return !isNaN(date) ? new Date(date) : value
      };
    }else {
      throw new CsvError('CSV_INVALID_OPTION_CAST_DATE', [
        'Invalid option cast_date:', 'cast_date must be true or a function,',
        `got ${JSON.stringify(options.cast_date)}`
      ], options)
    }
    // Normalize option `columns`
    let fnFirstLineToHeaders = null;
    if(options.columns === true){
      // Fields in the first line are converted as-is to columns
      fnFirstLineToHeaders = undefined;
    }else if(typeof options.columns === 'function'){
      fnFirstLineToHeaders = options.columns;
      options.columns = true;
    }else if(Array.isArray(options.columns)){
      options.columns = normalizeColumnsArray(options.columns);
    }else if(options.columns === undefined || options.columns === null || options.columns === false){
      options.columns = false;
    }else {
      throw new CsvError('CSV_INVALID_OPTION_COLUMNS', [
        'Invalid option columns:',
        'expect an array, a function or true,',
        `got ${JSON.stringify(options.columns)}`
      ], options)
    }
    // Normalize option `columns_duplicates_to_array`
    if(options.columns_duplicates_to_array === undefined || options.columns_duplicates_to_array === null || options.columns_duplicates_to_array === false){
      options.columns_duplicates_to_array = false;
    }else if(options.columns_duplicates_to_array !== true){
      throw new CsvError('CSV_INVALID_OPTION_COLUMNS_DUPLICATES_TO_ARRAY', [
        'Invalid option columns_duplicates_to_array:',
        'expect an boolean,',
        `got ${JSON.stringify(options.columns_duplicates_to_array)}`
      ], options)
    }else if(options.columns === false){
      throw new CsvError('CSV_INVALID_OPTION_COLUMNS_DUPLICATES_TO_ARRAY', [
        'Invalid option columns_duplicates_to_array:',
        'the `columns` mode must be activated.'
      ], options)
    }
    // Normalize option `comment`
    if(options.comment === undefined || options.comment === null || options.comment === false || options.comment === ''){
      options.comment = null;
    }else {
      if(typeof options.comment === 'string'){
        options.comment = Buffer.from(options.comment, options.encoding);
      }
      if(!Buffer.isBuffer(options.comment)){
        throw new CsvError('CSV_INVALID_OPTION_COMMENT', [
          'Invalid option comment:',
          'comment must be a buffer or a string,',
          `got ${JSON.stringify(options.comment)}`
        ], options)
      }
    }
    // Normalize option `delimiter`
    const delimiter_json = JSON.stringify(options.delimiter);
    if(!Array.isArray(options.delimiter)) options.delimiter = [options.delimiter];
    if(options.delimiter.length === 0){
      throw new CsvError('CSV_INVALID_OPTION_DELIMITER', [
        'Invalid option delimiter:',
        'delimiter must be a non empty string or buffer or array of string|buffer,',
        `got ${delimiter_json}`
      ], options)
    }
    options.delimiter = options.delimiter.map(function(delimiter){
      if(delimiter === undefined || delimiter === null || delimiter === false){
        return Buffer.from(',', options.encoding)
      }
      if(typeof delimiter === 'string'){
        delimiter = Buffer.from(delimiter, options.encoding);
      }
      if( !Buffer.isBuffer(delimiter) || delimiter.length === 0){
        throw new CsvError('CSV_INVALID_OPTION_DELIMITER', [
          'Invalid option delimiter:',
          'delimiter must be a non empty string or buffer or array of string|buffer,',
          `got ${delimiter_json}`
        ], options)
      }
      return delimiter
    });
    // Normalize option `escape`
    if(options.escape === undefined || options.escape === true){
      options.escape = Buffer.from('"', options.encoding);
    }else if(typeof options.escape === 'string'){
      options.escape = Buffer.from(options.escape, options.encoding);
    }else if (options.escape === null || options.escape === false){
      options.escape = null;
    }
    if(options.escape !== null){
      if(!Buffer.isBuffer(options.escape)){
        throw new Error(`Invalid Option: escape must be a buffer, a string or a boolean, got ${JSON.stringify(options.escape)}`)
      }
    }
    // Normalize option `from`
    if(options.from === undefined || options.from === null){
      options.from = 1;
    }else {
      if(typeof options.from === 'string' && /\d+/.test(options.from)){
        options.from = parseInt(options.from);
      }
      if(Number.isInteger(options.from)){
        if(options.from < 0){
          throw new Error(`Invalid Option: from must be a positive integer, got ${JSON.stringify(opts.from)}`)
        }
      }else {
        throw new Error(`Invalid Option: from must be an integer, got ${JSON.stringify(options.from)}`)
      }
    }
    // Normalize option `from_line`
    if(options.from_line === undefined || options.from_line === null){
      options.from_line = 1;
    }else {
      if(typeof options.from_line === 'string' && /\d+/.test(options.from_line)){
        options.from_line = parseInt(options.from_line);
      }
      if(Number.isInteger(options.from_line)){
        if(options.from_line <= 0){
          throw new Error(`Invalid Option: from_line must be a positive integer greater than 0, got ${JSON.stringify(opts.from_line)}`)
        }
      }else {
        throw new Error(`Invalid Option: from_line must be an integer, got ${JSON.stringify(opts.from_line)}`)
      }
    }
    // Normalize options `ignore_last_delimiters`
    if(options.ignore_last_delimiters === undefined || options.ignore_last_delimiters === null){
      options.ignore_last_delimiters = false;
    }else if(typeof options.ignore_last_delimiters === 'number'){
      options.ignore_last_delimiters = Math.floor(options.ignore_last_delimiters);
      if(options.ignore_last_delimiters === 0){
        options.ignore_last_delimiters = false;
      }
    }else if(typeof options.ignore_last_delimiters !== 'boolean'){
      throw new CsvError('CSV_INVALID_OPTION_IGNORE_LAST_DELIMITERS', [
        'Invalid option `ignore_last_delimiters`:',
        'the value must be a boolean value or an integer,',
        `got ${JSON.stringify(options.ignore_last_delimiters)}`
      ], options)
    }
    if(options.ignore_last_delimiters === true && options.columns === false){
      throw new CsvError('CSV_IGNORE_LAST_DELIMITERS_REQUIRES_COLUMNS', [
        'The option `ignore_last_delimiters`',
        'requires the activation of the `columns` option'
      ], options)
    }
    // Normalize option `info`
    if(options.info === undefined || options.info === null || options.info === false){
      options.info = false;
    }else if(options.info !== true){
      throw new Error(`Invalid Option: info must be true, got ${JSON.stringify(options.info)}`)
    }
    // Normalize option `max_record_size`
    if(options.max_record_size === undefined || options.max_record_size === null || options.max_record_size === false){
      options.max_record_size = 0;
    }else if(Number.isInteger(options.max_record_size) && options.max_record_size >= 0);else if(typeof options.max_record_size === 'string' && /\d+/.test(options.max_record_size)){
      options.max_record_size = parseInt(options.max_record_size);
    }else {
      throw new Error(`Invalid Option: max_record_size must be a positive integer, got ${JSON.stringify(options.max_record_size)}`)
    }
    // Normalize option `objname`
    if(options.objname === undefined || options.objname === null || options.objname === false){
      options.objname = undefined;
    }else if(Buffer.isBuffer(options.objname)){
      if(options.objname.length === 0){
        throw new Error(`Invalid Option: objname must be a non empty buffer`)
      }
      if(options.encoding === null);else {
        options.objname = options.objname.toString(options.encoding);
      }
    }else if(typeof options.objname === 'string'){
      if(options.objname.length === 0){
        throw new Error(`Invalid Option: objname must be a non empty string`)
      }
      // Great, nothing to do
    }else {
      throw new Error(`Invalid Option: objname must be a string or a buffer, got ${options.objname}`)
    }
    // Normalize option `on_record`
    if(options.on_record === undefined || options.on_record === null){
      options.on_record = undefined;
    }else if(typeof options.on_record !== 'function'){
      throw new CsvError('CSV_INVALID_OPTION_ON_RECORD', [
        'Invalid option `on_record`:',
        'expect a function,',
        `got ${JSON.stringify(options.on_record)}`
      ], options)
    }
    // Normalize option `quote`
    if(options.quote === null || options.quote === false || options.quote === ''){
      options.quote = null;
    }else {
      if(options.quote === undefined || options.quote === true){
        options.quote = Buffer.from('"', options.encoding);
      }else if(typeof options.quote === 'string'){
        options.quote = Buffer.from(options.quote, options.encoding);
      }
      if(!Buffer.isBuffer(options.quote)){
        throw new Error(`Invalid Option: quote must be a buffer or a string, got ${JSON.stringify(options.quote)}`)
      }
    }
    // Normalize option `raw`
    if(options.raw === undefined || options.raw === null || options.raw === false){
      options.raw = false;
    }else if(options.raw !== true){
      throw new Error(`Invalid Option: raw must be true, got ${JSON.stringify(options.raw)}`)
    }
    // Normalize option `record_delimiter`
    if(!options.record_delimiter){
      options.record_delimiter = [];
    }else if(!Array.isArray(options.record_delimiter)){
      options.record_delimiter = [options.record_delimiter];
    }
    options.record_delimiter = options.record_delimiter.map( function(rd){
      if(typeof rd === 'string'){
        rd = Buffer.from(rd, options.encoding);
      }
      return rd
    });
    // Normalize option `relax`
    if(typeof options.relax === 'boolean');else if(options.relax === undefined || options.relax === null){
      options.relax = false;
    }else {
      throw new Error(`Invalid Option: relax must be a boolean, got ${JSON.stringify(options.relax)}`)
    }
    // Normalize option `relax_column_count`
    if(typeof options.relax_column_count === 'boolean');else if(options.relax_column_count === undefined || options.relax_column_count === null){
      options.relax_column_count = false;
    }else {
      throw new Error(`Invalid Option: relax_column_count must be a boolean, got ${JSON.stringify(options.relax_column_count)}`)
    }
    if(typeof options.relax_column_count_less === 'boolean');else if(options.relax_column_count_less === undefined || options.relax_column_count_less === null){
      options.relax_column_count_less = false;
    }else {
      throw new Error(`Invalid Option: relax_column_count_less must be a boolean, got ${JSON.stringify(options.relax_column_count_less)}`)
    }
    if(typeof options.relax_column_count_more === 'boolean');else if(options.relax_column_count_more === undefined || options.relax_column_count_more === null){
      options.relax_column_count_more = false;
    }else {
      throw new Error(`Invalid Option: relax_column_count_more must be a boolean, got ${JSON.stringify(options.relax_column_count_more)}`)
    }
    // Normalize option `skip_empty_lines`
    if(typeof options.skip_empty_lines === 'boolean');else if(options.skip_empty_lines === undefined || options.skip_empty_lines === null){
      options.skip_empty_lines = false;
    }else {
      throw new Error(`Invalid Option: skip_empty_lines must be a boolean, got ${JSON.stringify(options.skip_empty_lines)}`)
    }
    // Normalize option `skip_lines_with_empty_values`
    if(typeof options.skip_lines_with_empty_values === 'boolean');else if(options.skip_lines_with_empty_values === undefined || options.skip_lines_with_empty_values === null){
      options.skip_lines_with_empty_values = false;
    }else {
      throw new Error(`Invalid Option: skip_lines_with_empty_values must be a boolean, got ${JSON.stringify(options.skip_lines_with_empty_values)}`)
    }
    // Normalize option `skip_lines_with_error`
    if(typeof options.skip_lines_with_error === 'boolean');else if(options.skip_lines_with_error === undefined || options.skip_lines_with_error === null){
      options.skip_lines_with_error = false;
    }else {
      throw new Error(`Invalid Option: skip_lines_with_error must be a boolean, got ${JSON.stringify(options.skip_lines_with_error)}`)
    }
    // Normalize option `rtrim`
    if(options.rtrim === undefined || options.rtrim === null || options.rtrim === false){
      options.rtrim = false;
    }else if(options.rtrim !== true){
      throw new Error(`Invalid Option: rtrim must be a boolean, got ${JSON.stringify(options.rtrim)}`)
    }
    // Normalize option `ltrim`
    if(options.ltrim === undefined || options.ltrim === null || options.ltrim === false){
      options.ltrim = false;
    }else if(options.ltrim !== true){
      throw new Error(`Invalid Option: ltrim must be a boolean, got ${JSON.stringify(options.ltrim)}`)
    }
    // Normalize option `trim`
    if(options.trim === undefined || options.trim === null || options.trim === false){
      options.trim = false;
    }else if(options.trim !== true){
      throw new Error(`Invalid Option: trim must be a boolean, got ${JSON.stringify(options.trim)}`)
    }
    // Normalize options `trim`, `ltrim` and `rtrim`
    if(options.trim === true && opts.ltrim !== false){
      options.ltrim = true;
    }else if(options.ltrim !== true){
      options.ltrim = false;
    }
    if(options.trim === true && opts.rtrim !== false){
      options.rtrim = true;
    }else if(options.rtrim !== true){
      options.rtrim = false;
    }
    // Normalize option `to`
    if(options.to === undefined || options.to === null){
      options.to = -1;
    }else {
      if(typeof options.to === 'string' && /\d+/.test(options.to)){
        options.to = parseInt(options.to);
      }
      if(Number.isInteger(options.to)){
        if(options.to <= 0){
          throw new Error(`Invalid Option: to must be a positive integer greater than 0, got ${JSON.stringify(opts.to)}`)
        }
      }else {
        throw new Error(`Invalid Option: to must be an integer, got ${JSON.stringify(opts.to)}`)
      }
    }
    // Normalize option `to_line`
    if(options.to_line === undefined || options.to_line === null){
      options.to_line = -1;
    }else {
      if(typeof options.to_line === 'string' && /\d+/.test(options.to_line)){
        options.to_line = parseInt(options.to_line);
      }
      if(Number.isInteger(options.to_line)){
        if(options.to_line <= 0){
          throw new Error(`Invalid Option: to_line must be a positive integer greater than 0, got ${JSON.stringify(opts.to_line)}`)
        }
      }else {
        throw new Error(`Invalid Option: to_line must be an integer, got ${JSON.stringify(opts.to_line)}`)
      }
    }
    this.info = {
      bytes: 0,
      comment_lines: 0,
      empty_lines: 0,
      invalid_field_length: 0,
      lines: 1,
      records: 0
    };
    this.options = options;
    this.state = {
      bomSkipped: false,
      bufBytesStart: 0,
      castField: fnCastField,
      commenting: false,
      // Current error encountered by a record
      error: undefined,
      enabled: options.from_line === 1,
      escaping: false,
      // escapeIsQuote: options.escape === options.quote,
      escapeIsQuote: Buffer.isBuffer(options.escape) && Buffer.isBuffer(options.quote) && Buffer.compare(options.escape, options.quote) === 0,
      // columns can be `false`, `true`, `Array`
      expectedRecordLength: Array.isArray(options.columns) ? options.columns.length : undefined,
      field: new ResizeableBuffer_1(20),
      firstLineToHeaders: fnFirstLineToHeaders,
      needMoreDataSize: Math.max(
        // Skip if the remaining buffer smaller than comment
        options.comment !== null ? options.comment.length : 0,
        // Skip if the remaining buffer can be delimiter
        ...options.delimiter.map( (delimiter) => delimiter.length),
        // Skip if the remaining buffer can be escape sequence
        options.quote !== null ? options.quote.length : 0,
      ),
      previousBuf: undefined,
      quoting: false,
      stop: false,
      rawBuffer: new ResizeableBuffer_1(100),
      record: [],
      recordHasError: false,
      record_length: 0,
      recordDelimiterMaxLength: options.record_delimiter.length === 0 ? 2 : Math.max(...options.record_delimiter.map( (v) => v.length)),
      trimChars: [Buffer.from(' ', options.encoding)[0], Buffer.from('\t', options.encoding)[0]],
      wasQuoting: false,
      wasRowDelimiter: false
    };
  }
  // Implementation of `Transform._transform`
  _transform(buf, encoding, callback){
    if(this.state.stop === true){
      return
    }
    const err = this.__parse(buf, false);
    if(err !== undefined){
      this.state.stop = true;
    }
    callback(err);
  }
  // Implementation of `Transform._flush`
  _flush(callback){
    if(this.state.stop === true){
      return
    }
    const err = this.__parse(undefined, true);
    callback(err);
  }
  // Central parser implementation
  __parse(nextBuf, end){
    const {bom, comment, escape, from_line, ltrim, max_record_size, quote, raw, relax, rtrim, skip_empty_lines, to, to_line} = this.options;
    let {record_delimiter} = this.options;
    const {bomSkipped, previousBuf, rawBuffer, escapeIsQuote} = this.state;
    let buf;
    if(previousBuf === undefined){
      if(nextBuf === undefined){
        // Handle empty string
        this.push(null);
        return
      }else {
        buf = nextBuf;
      }
    }else if(previousBuf !== undefined && nextBuf === undefined){
      buf = previousBuf;
    }else {
      buf = Buffer.concat([previousBuf, nextBuf]);
    }
    // Handle UTF BOM
    if(bomSkipped === false){
      if(bom === false){
        this.state.bomSkipped = true;
      }else if(buf.length < 3){
        // No enough data
        if(end === false){
          // Wait for more data
          this.state.previousBuf = buf;
          return
        }
      }else {
        for(let encoding in boms){
          if(boms[encoding].compare(buf, 0, boms[encoding].length) === 0){
            // Skip BOM
            let bomLength = boms[encoding].length;
            this.state.bufBytesStart += bomLength;
            buf = buf.slice(bomLength);
            // Renormalize original options with the new encoding
            this.__normalizeOptions({...this.__originalOptions, encoding: encoding});
            break
          }
        }
        this.state.bomSkipped = true;
      }
    }
    const bufLen = buf.length;
    let pos;
    for(pos = 0; pos < bufLen; pos++){
      // Ensure we get enough space to look ahead
      // There should be a way to move this out of the loop
      if(this.__needMoreData(pos, bufLen, end)){
        break
      }
      if(this.state.wasRowDelimiter === true){
        this.info.lines++;
        this.state.wasRowDelimiter = false;
      }
      if(to_line !== -1 && this.info.lines > to_line){
        this.state.stop = true;
        this.push(null);
        return
      }
      // Auto discovery of record_delimiter, unix, mac and windows supported
      if(this.state.quoting === false && record_delimiter.length === 0){
        const record_delimiterCount = this.__autoDiscoverRecordDelimiter(buf, pos);
        if(record_delimiterCount){
          record_delimiter = this.options.record_delimiter;
        }
      }
      const chr = buf[pos];
      if(raw === true){
        rawBuffer.append(chr);
      }
      if((chr === cr || chr === nl) && this.state.wasRowDelimiter === false ){
        this.state.wasRowDelimiter = true;
      }
      // Previous char was a valid escape char
      // treat the current char as a regular char
      if(this.state.escaping === true){
        this.state.escaping = false;
      }else {
        // Escape is only active inside quoted fields
        // We are quoting, the char is an escape chr and there is a chr to escape
        // if(escape !== null && this.state.quoting === true && chr === escape && pos + 1 < bufLen){
        if(escape !== null && this.state.quoting === true && this.__isEscape(buf, pos, chr) && pos + escape.length < bufLen){
          if(escapeIsQuote){
            if(this.__isQuote(buf, pos+escape.length)){
              this.state.escaping = true;
              pos += escape.length - 1;
              continue
            }
          }else {
            this.state.escaping = true;
            pos += escape.length - 1;
            continue
          }
        }
        // Not currently escaping and chr is a quote
        // TODO: need to compare bytes instead of single char
        if(this.state.commenting === false && this.__isQuote(buf, pos)){
          if(this.state.quoting === true){
            const nextChr = buf[pos+quote.length];
            const isNextChrTrimable = rtrim && this.__isCharTrimable(nextChr);
            const isNextChrComment = comment !== null && this.__compareBytes(comment, buf, pos+quote.length, nextChr);
            const isNextChrDelimiter = this.__isDelimiter(buf, pos+quote.length, nextChr);
            const isNextChrRecordDelimiter = record_delimiter.length === 0 ? this.__autoDiscoverRecordDelimiter(buf, pos+quote.length) : this.__isRecordDelimiter(nextChr, buf, pos+quote.length);
            // Escape a quote
            // Treat next char as a regular character
            if(escape !== null && this.__isEscape(buf, pos, chr) && this.__isQuote(buf, pos + escape.length)){
              pos += escape.length - 1;
            }else if(!nextChr || isNextChrDelimiter || isNextChrRecordDelimiter || isNextChrComment || isNextChrTrimable){
              this.state.quoting = false;
              this.state.wasQuoting = true;
              pos += quote.length - 1;
              continue
            }else if(relax === false){
              const err = this.__error(
                new CsvError('CSV_INVALID_CLOSING_QUOTE', [
                  'Invalid Closing Quote:',
                  `got "${String.fromCharCode(nextChr)}"`,
                  `at line ${this.info.lines}`,
                  'instead of delimiter, record delimiter, trimable character',
                  '(if activated) or comment',
                ], this.options, this.__infoField())
              );
              if(err !== undefined) return err
            }else {
              this.state.quoting = false;
              this.state.wasQuoting = true;
              this.state.field.prepend(quote);
              pos += quote.length - 1;
            }
          }else {
            if(this.state.field.length !== 0){
              // In relax mode, treat opening quote preceded by chrs as regular
              if( relax === false ){
                const err = this.__error(
                  new CsvError('INVALID_OPENING_QUOTE', [
                    'Invalid Opening Quote:',
                    `a quote is found inside a field at line ${this.info.lines}`,
                  ], this.options, this.__infoField(), {
                    field: this.state.field,
                  })
                );
                if(err !== undefined) return err
              }
            }else {
              this.state.quoting = true;
              pos += quote.length - 1;
              continue
            }
          }
        }
        if(this.state.quoting === false){
          let recordDelimiterLength = this.__isRecordDelimiter(chr, buf, pos);
          if(recordDelimiterLength !== 0){
            // Do not emit comments which take a full line
            const skipCommentLine = this.state.commenting && (this.state.wasQuoting === false && this.state.record.length === 0 && this.state.field.length === 0);
            if(skipCommentLine){
              this.info.comment_lines++;
              // Skip full comment line
            }else {
              // Activate records emition if above from_line
              if(this.state.enabled === false && this.info.lines + (this.state.wasRowDelimiter === true ? 1: 0) >= from_line){
                this.state.enabled = true;
                this.__resetField();
                this.__resetRecord();
                pos += recordDelimiterLength - 1;
                continue
              }
              // Skip if line is empty and skip_empty_lines activated
              if(skip_empty_lines === true && this.state.wasQuoting === false && this.state.record.length === 0 && this.state.field.length === 0){
                this.info.empty_lines++;
                pos += recordDelimiterLength - 1;
                continue
              }
              this.info.bytes = this.state.bufBytesStart + pos;
              const errField = this.__onField();
              if(errField !== undefined) return errField
              this.info.bytes = this.state.bufBytesStart + pos + recordDelimiterLength;
              const errRecord = this.__onRecord();
              if(errRecord !== undefined) return errRecord
              if(to !== -1 && this.info.records >= to){
                this.state.stop = true;
                this.push(null);
                return
              }
            }
            this.state.commenting = false;
            pos += recordDelimiterLength - 1;
            continue
          }
          if(this.state.commenting){
            continue
          }
          const commentCount = comment === null ? 0 : this.__compareBytes(comment, buf, pos, chr);
          if(commentCount !== 0){
            this.state.commenting = true;
            continue
          }
          let delimiterLength = this.__isDelimiter(buf, pos, chr);
          if(delimiterLength !== 0){
            this.info.bytes = this.state.bufBytesStart + pos;
            const errField = this.__onField();
            if(errField !== undefined) return errField
            pos += delimiterLength - 1;
            continue
          }
        }
      }
      if(this.state.commenting === false){
        if(max_record_size !== 0 && this.state.record_length + this.state.field.length > max_record_size){
          const err = this.__error(
            new CsvError('CSV_MAX_RECORD_SIZE', [
              'Max Record Size:',
              'record exceed the maximum number of tolerated bytes',
              `of ${max_record_size}`,
              `at line ${this.info.lines}`,
            ], this.options, this.__infoField())
          );
          if(err !== undefined) return err
        }
      }
      const lappend = ltrim === false || this.state.quoting === true || this.state.field.length !== 0 || !this.__isCharTrimable(chr);
      // rtrim in non quoting is handle in __onField
      const rappend = rtrim === false || this.state.wasQuoting === false;
      if( lappend === true && rappend === true ){
        this.state.field.append(chr);
      }else if(rtrim === true && !this.__isCharTrimable(chr)){
        const err = this.__error(
          new CsvError('CSV_NON_TRIMABLE_CHAR_AFTER_CLOSING_QUOTE', [
            'Invalid Closing Quote:',
            'found non trimable byte after quote',
            `at line ${this.info.lines}`,
          ], this.options, this.__infoField())
        );
        if(err !== undefined) return err
      }
    }
    if(end === true){
      // Ensure we are not ending in a quoting state
      if(this.state.quoting === true){
        const err = this.__error(
          new CsvError('CSV_QUOTE_NOT_CLOSED', [
            'Quote Not Closed:',
            `the parsing is finished with an opening quote at line ${this.info.lines}`,
          ], this.options, this.__infoField())
        );
        if(err !== undefined) return err
      }else {
        // Skip last line if it has no characters
        if(this.state.wasQuoting === true || this.state.record.length !== 0 || this.state.field.length !== 0){
          this.info.bytes = this.state.bufBytesStart + pos;
          const errField = this.__onField();
          if(errField !== undefined) return errField
          const errRecord = this.__onRecord();
          if(errRecord !== undefined) return errRecord
        }else if(this.state.wasRowDelimiter === true){
          this.info.empty_lines++;
        }else if(this.state.commenting === true){
          this.info.comment_lines++;
        }
      }
    }else {
      this.state.bufBytesStart += pos;
      this.state.previousBuf = buf.slice(pos);
    }
    if(this.state.wasRowDelimiter === true){
      this.info.lines++;
      this.state.wasRowDelimiter = false;
    }
  }
  __onRecord(){
    const {columns, columns_duplicates_to_array, encoding, info, from, relax_column_count, relax_column_count_less, relax_column_count_more, raw, skip_lines_with_empty_values} = this.options;
    const {enabled, record} = this.state;
    if(enabled === false){
      return this.__resetRecord()
    }
    // Convert the first line into column names
    const recordLength = record.length;
    if(columns === true){
      if(skip_lines_with_empty_values === true && isRecordEmpty(record)){
        this.__resetRecord();
        return
      }
      return this.__firstLineToColumns(record)
    }
    if(columns === false && this.info.records === 0){
      this.state.expectedRecordLength = recordLength;
    }
    if(recordLength !== this.state.expectedRecordLength){
      const err = columns === false ?
        // Todo: rename CSV_INCONSISTENT_RECORD_LENGTH to
        // CSV_RECORD_INCONSISTENT_FIELDS_LENGTH
        new CsvError('CSV_INCONSISTENT_RECORD_LENGTH', [
          'Invalid Record Length:',
          `expect ${this.state.expectedRecordLength},`,
          `got ${recordLength} on line ${this.info.lines}`,
        ], this.options, this.__infoField(), {
          record: record,
        })
      :
        // Todo: rename CSV_RECORD_DONT_MATCH_COLUMNS_LENGTH to
        // CSV_RECORD_INCONSISTENT_COLUMNS
        new CsvError('CSV_RECORD_DONT_MATCH_COLUMNS_LENGTH', [
          'Invalid Record Length:',
          `columns length is ${columns.length},`, // rename columns
          `got ${recordLength} on line ${this.info.lines}`,
        ], this.options, this.__infoField(), {
          record: record,
        });
      if(relax_column_count === true ||
        (relax_column_count_less === true && recordLength < this.state.expectedRecordLength) ||
        (relax_column_count_more === true && recordLength > this.state.expectedRecordLength) ){
        this.info.invalid_field_length++;
        this.state.error = err;
      // Error is undefined with skip_lines_with_error
      }else {
        const finalErr = this.__error(err);
        if(finalErr) return finalErr
      }
    }
    if(skip_lines_with_empty_values === true && isRecordEmpty(record)){
      this.__resetRecord();
      return
    }
    if(this.state.recordHasError === true){
      this.__resetRecord();
      this.state.recordHasError = false;
      return
    }
    this.info.records++;
    if(from === 1 || this.info.records >= from){
      // With columns, records are object
      if(columns !== false){
        const obj = {};
        // Transform record array to an object
        for(let i = 0, l = record.length; i < l; i++){
          if(columns[i] === undefined || columns[i].disabled) continue
          // Turn duplicate columns into an array
          if (columns_duplicates_to_array === true && obj[columns[i].name] !== undefined) {
            if (Array.isArray(obj[columns[i].name])) {
              obj[columns[i].name] = obj[columns[i].name].concat(record[i]);
            } else {
              obj[columns[i].name] = [obj[columns[i].name], record[i]];
            }
          } else {
            obj[columns[i].name] = record[i];
          }
        }
        const {objname} = this.options;
        // Without objname (default)
        if(objname === undefined){
          if(raw === true || info === true){
            const err = this.__push(Object.assign(
              {record: obj},
              (raw === true ? {raw: this.state.rawBuffer.toString(encoding)}: {}),
              (info === true ? {info: this.__infoRecord()}: {})
            ));
            if(err){
              return err
            }
          }else {
            const err = this.__push(obj);
            if(err){
              return err
            }
          }
        // With objname (default)
        }else {
          if(raw === true || info === true){
            const err = this.__push(Object.assign(
              {record: [obj[objname], obj]},
              raw === true ? {raw: this.state.rawBuffer.toString(encoding)}: {},
              info === true ? {info: this.__infoRecord()}: {}
            ));
            if(err){
              return err
            }
          }else {
            const err = this.__push([obj[objname], obj]);
            if(err){
              return err
            }
          }
        }
      // Without columns, records are array
      }else {
        if(raw === true || info === true){
          const err = this.__push(Object.assign(
            {record: record},
            raw === true ? {raw: this.state.rawBuffer.toString(encoding)}: {},
            info === true ? {info: this.__infoRecord()}: {}
          ));
          if(err){
            return err
          }
        }else {
          const err = this.__push(record);
          if(err){
            return err
          }
        }
      }
    }
    this.__resetRecord();
  }
  __firstLineToColumns(record){
    const {firstLineToHeaders} = this.state;
    try{
      const headers = firstLineToHeaders === undefined ? record : firstLineToHeaders.call(null, record);
      if(!Array.isArray(headers)){
        return this.__error(
          new CsvError('CSV_INVALID_COLUMN_MAPPING', [
            'Invalid Column Mapping:',
            'expect an array from column function,',
            `got ${JSON.stringify(headers)}`
          ], this.options, this.__infoField(), {
            headers: headers,
          })
        )
      }
      const normalizedHeaders = normalizeColumnsArray(headers);
      this.state.expectedRecordLength = normalizedHeaders.length;
      this.options.columns = normalizedHeaders;
      this.__resetRecord();
      return
    }catch(err){
      return err
    }
  }
  __resetRecord(){
    if(this.options.raw === true){
      this.state.rawBuffer.reset();
    }
    this.state.error = undefined;
    this.state.record = [];
    this.state.record_length = 0;
  }
  __onField(){
    const {cast, encoding, rtrim, max_record_size} = this.options;
    const {enabled, wasQuoting} = this.state;
    // Short circuit for the from_line options
    if(enabled === false){
      return this.__resetField()
    }
    let field = this.state.field.toString(encoding);
    if(rtrim === true && wasQuoting === false){
      field = field.trimRight();
    }
    if(cast === true){
      const [err, f] = this.__cast(field);
      if(err !== undefined) return err
      field = f;
    }
    this.state.record.push(field);
    // Increment record length if record size must not exceed a limit
    if(max_record_size !== 0 && typeof field === 'string'){
      this.state.record_length += field.length;
    }
    this.__resetField();
  }
  __resetField(){
    this.state.field.reset();
    this.state.wasQuoting = false;
  }
  __push(record){
    const {on_record} = this.options;
    if(on_record !== undefined){
      const info = this.__infoRecord();
      try{
        record = on_record.call(null, record, info);
      }catch(err){
        return err
      }
      if(record === undefined || record === null){ return }
    }
    this.push(record);
  }
  // Return a tuple with the error and the casted value
  __cast(field){
    const {columns, relax_column_count} = this.options;
    const isColumns = Array.isArray(columns);
    // Dont loose time calling cast
    // because the final record is an object
    // and this field can't be associated to a key present in columns
    if( isColumns === true && relax_column_count && this.options.columns.length <= this.state.record.length ){
      return [undefined, undefined]
    }
    if(this.state.castField !== null){
      try{
        const info = this.__infoField();
        return [undefined, this.state.castField.call(null, field, info)]
      }catch(err){
        return [err]
      }
    }
    if(this.__isFloat(field)){
      return [undefined, parseFloat(field)]
    }else if(this.options.cast_date !== false){
      const info = this.__infoField();
      return [undefined, this.options.cast_date.call(null, field, info)]
    }
    return [undefined, field]
  }
  // Helper to test if a character is a space or a line delimiter
  __isCharTrimable(chr){
    return chr === space || chr === tab || chr === cr || chr === nl || chr === np
  }
  // Keep it in case we implement the `cast_int` option
  // __isInt(value){
  //   // return Number.isInteger(parseInt(value))
  //   // return !isNaN( parseInt( obj ) );
  //   return /^(\-|\+)?[1-9][0-9]*$/.test(value)
  // }
  __isFloat(value){
    return (value - parseFloat( value ) + 1) >= 0 // Borrowed from jquery
  }
  __compareBytes(sourceBuf, targetBuf, targetPos, firstByte){
    if(sourceBuf[0] !== firstByte) return 0
    const sourceLength = sourceBuf.length;
    for(let i = 1; i < sourceLength; i++){
      if(sourceBuf[i] !== targetBuf[targetPos+i]) return 0
    }
    return sourceLength
  }
  __needMoreData(i, bufLen, end){
    if(end) return false
    const {quote} = this.options;
    const {quoting, needMoreDataSize, recordDelimiterMaxLength} = this.state;
    const numOfCharLeft = bufLen - i - 1;
    const requiredLength = Math.max(
      needMoreDataSize,
      // Skip if the remaining buffer smaller than record delimiter
      recordDelimiterMaxLength,
      // Skip if the remaining buffer can be record delimiter following the closing quote
      // 1 is for quote.length
      quoting ? (quote.length + recordDelimiterMaxLength) : 0,
    );
    return numOfCharLeft < requiredLength
  }
  __isDelimiter(buf, pos, chr){
    const {delimiter, ignore_last_delimiters} = this.options;
    if(ignore_last_delimiters === true && this.state.record.length === this.options.columns.length - 1){
      return 0
    }else if(ignore_last_delimiters !== false && typeof ignore_last_delimiters === 'number' && this.state.record.length === ignore_last_delimiters - 1){
      return 0
    }
    loop1: for(let i = 0; i < delimiter.length; i++){
      const del = delimiter[i];
      if(del[0] === chr){
        for(let j = 1; j < del.length; j++){
          if(del[j] !== buf[pos+j]) continue loop1
        }
        return del.length
      }
    }
    return 0
  }
  __isRecordDelimiter(chr, buf, pos){
    const {record_delimiter} = this.options;
    const recordDelimiterLength = record_delimiter.length;
    loop1: for(let i = 0; i < recordDelimiterLength; i++){
      const rd = record_delimiter[i];
      const rdLength = rd.length;
      if(rd[0] !== chr){
        continue
      }
      for(let j = 1; j < rdLength; j++){
        if(rd[j] !== buf[pos+j]){
          continue loop1
        }
      }
      return rd.length
    }
    return 0
  }
  __isEscape(buf, pos, chr){
    const {escape} = this.options;
    if(escape === null) return false
    const l = escape.length;
    if(escape[0] === chr){
      for(let i = 0; i < l; i++){
        if(escape[i] !== buf[pos+i]){
          return false
        }
      }
      return true
    }
    return false
  }
  __isQuote(buf, pos){
    const {quote} = this.options;
    if(quote === null) return false
    const l = quote.length;
    for(let i = 0; i < l; i++){
      if(quote[i] !== buf[pos+i]){
        return false
      }
    }
    return true
  }
  __autoDiscoverRecordDelimiter(buf, pos){
    const {encoding} = this.options;
    const chr = buf[pos];
    if(chr === cr){
      if(buf[pos+1] === nl){
        this.options.record_delimiter.push(Buffer.from('\r\n', encoding));
        this.state.recordDelimiterMaxLength = 2;
        return 2
      }else {
        this.options.record_delimiter.push(Buffer.from('\r', encoding));
        this.state.recordDelimiterMaxLength = 1;
        return 1
      }
    }else if(chr === nl){
      this.options.record_delimiter.push(Buffer.from('\n', encoding));
      this.state.recordDelimiterMaxLength = 1;
      return 1
    }
    return 0
  }
  __error(msg){
    const {skip_lines_with_error} = this.options;
    const err = typeof msg === 'string' ? new Error(msg) : msg;
    if(skip_lines_with_error){
      this.state.recordHasError = true;
      this.emit('skip', err);
      return undefined
    }else {
      return err
    }
  }
  __infoDataSet(){
    return {
      ...this.info,
      columns: this.options.columns
    }
  }
  __infoRecord(){
    const {columns} = this.options;
    return {
      ...this.__infoDataSet(),
      error: this.state.error,
      header: columns === true,
      index: this.state.record.length,
    }
  }
  __infoField(){
    const {columns} = this.options;
    const isColumns = Array.isArray(columns);
    return {
      ...this.__infoRecord(),
      column: isColumns === true ?
        ( columns.length > this.state.record.length ?
          columns[this.state.record.length].name :
          null
        ) :
        this.state.record.length,
      quoting: this.state.wasQuoting,
    }
  }
}

const parse = function(){
  let data, options, callback;
  for(let i in arguments){
    const argument = arguments[i];
    const type = typeof argument;
    if(data === undefined && (typeof argument === 'string' || Buffer.isBuffer(argument))){
      data = argument;
    }else if(options === undefined && isObject(argument)){
      options = argument;
    }else if(callback === undefined && type === 'function'){
      callback = argument;
    }else {
      throw new CsvError('CSV_INVALID_ARGUMENT', [
        'Invalid argument:',
        `got ${JSON.stringify(argument)} at index ${i}`
      ], options || {})
    }
  }
  const parser = new Parser(options);
  if(callback){
    const records = options === undefined || options.objname === undefined ? [] : {};
    parser.on('readable', function(){
      let record;
      while((record = this.read()) !== null){
        if(options === undefined || options.objname === undefined){
          records.push(record);
        }else {
          records[record[0]] = record[1];
        }
      }
    });
    parser.on('error', function(err){
      callback(err, undefined, parser.__infoDataSet());
    });
    parser.on('end', function(){
      callback(undefined, records, parser.__infoDataSet());
    });
  }
  if(data !== undefined){
    // Give a chance for events to be registered later
    if(typeof setImmediate === 'function'){
      setImmediate(function(){
        parser.write(data);
        parser.end();
      });
    }else {
      parser.write(data);
      parser.end();
    }
  }
  return parser
};

class CsvError extends Error {
  constructor(code, message, options, ...contexts) {
    if(Array.isArray(message)) message = message.join(' ');
    super(message);
    if(Error.captureStackTrace !== undefined){
      Error.captureStackTrace(this, CsvError);
    }
    this.code = code;
    for(const context of contexts){
      for(const key in context){
        const value = context[key];
        this[key] = Buffer.isBuffer(value) ? value.toString(options.encoding) : value == null ? value : JSON.parse(JSON.stringify(value));
      }
    }
  }
}

parse.Parser = Parser;

parse.CsvError = CsvError;

var lib = parse;

const underscore = function(str){
  return str.replace(/([A-Z])/g, function(_, match){
    return '_' + match.toLowerCase()
  })
};

const isObject = function(obj){
  return (typeof obj === 'object' && obj !== null && !Array.isArray(obj))
};

const isRecordEmpty = function(record){
  return record.every( (field) => field == null || field.toString && field.toString().trim() === '' )
};

const normalizeColumnsArray = function(columns){
  const normalizedColumns = [];
  for(let i = 0, l = columns.length; i < l; i++){
    const column = columns[i];
    if(column === undefined || column === null || column === false){
      normalizedColumns[i] = { disabled: true };
    }else if(typeof column === 'string'){
      normalizedColumns[i] = { name: column };
    }else if(isObject(column)){
      if(typeof column.name !== 'string'){
        throw new CsvError('CSV_OPTION_COLUMNS_MISSING_NAME', [
          'Option columns missing name:',
          `property "name" is required at position ${i}`,
          'when column is an object literal'
        ])
      }
      normalizedColumns[i] = column;
    }else {
      throw new CsvError('CSV_INVALID_COLUMN_DEFINITION', [
        'Invalid column definition:',
        'expect a string or a literal object,',
        `got ${JSON.stringify(column)} at position ${i}`
      ])
    }
  }
  return normalizedColumns;
};

var sync = function(data, options={}){
  if(typeof data === 'string'){
    data = Buffer.from(data);
  }
  const records = options && options.objname ? {} : [];
  const parser = new lib.Parser(options);
  parser.push = function(record){
    if(record === null){
      return
    }
    if(options.objname === undefined)
      records.push(record);
    else {
      records[record[0]] = record[1];
    }
  };
  const err1 = parser.__parse(data, false);
  if(err1 !== undefined) throw err1
  const err2 = parser.__parse(undefined, true);
  if(err2 !== undefined) throw err2
  return records
};

/* Jison generated parser */
var _parser = (function() {
    var parser = {
        trace: function trace() {},
        yy: {},
        symbols_: {
            "error": 2,
            "expressions": 3,
            "e": 4,
            "EOF": 5,
            "+": 6,
            "-": 7,
            "*": 8,
            "/": 9,
            "%": 10,
            "^": 11,
            "and": 12,
            "or": 13,
            "not": 14,
            "==": 15,
            "!=": 16,
            "~=": 17,
            "<": 18,
            "<=": 19,
            ">": 20,
            ">=": 21,
            "?": 22,
            ":": 23,
            "(": 24,
            ")": 25,
            "array": 26,
            ",": 27,
            "NUMBER": 28,
            "STRING": 29,
            "SYMBOL": 30,
            "of": 31,
            "argsList": 32,
            "in": 33,
            "inSet": 34,
            "$accept": 0,
            "$end": 1
        },
        terminals_: {
            2: "error",
            5: "EOF",
            6: "+",
            7: "-",
            8: "*",
            9: "/",
            10: "%",
            11: "^",
            12: "and",
            13: "or",
            14: "not",
            15: "==",
            16: "!=",
            17: "~=",
            18: "<",
            19: "<=",
            20: ">",
            21: ">=",
            22: "?",
            23: ":",
            24: "(",
            25: ")",
            27: ",",
            28: "NUMBER",
            29: "STRING",
            30: "SYMBOL",
            31: "of",
            33: "in"
        },
        productions_: [0, [3, 2],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 2],
            [4, 3],
            [4, 3],
            [4, 2],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 3],
            [4, 5],
            [4, 3],
            [4, 5],
            [4, 1],
            [4, 1],
            [4, 1],
            [4, 3],
            [4, 3],
            [4, 4],
            [4, 3],
            [4, 4],
            [32, 1],
            [32, 3],
            [34, 1],
            [34, 3],
            [26, 1],
            [26, 3]
        ],
        performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {

            var $0 = $$.length - 1;
            switch (yystate) {
                case 1:
                    return $$[$0 - 1];
                case 2:
                    this.$ = ["(", $$[$0 - 2], "+", $$[$0], ")"];
                    break;
                case 3:
                    this.$ = ["(", $$[$0 - 2], "-", $$[$0], ")"];
                    break;
                case 4:
                    this.$ = ["(", $$[$0 - 2], "*", $$[$0], ")"];
                    break;
                case 5:
                    this.$ = ["(", $$[$0 - 2], "/", $$[$0], ")"];
                    break;
                case 6:
                    this.$ = ["(", $$[$0 - 2], "%", $$[$0], ")"];
                    break;
                case 7:
                    this.$ = ["(", "Math.pow(", $$[$0 - 2], ",", $$[$0], ")", ")"];
                    break;
                case 8:
                    this.$ = ["(", "-", $$[$0], ")"];
                    break;
                case 9:
                    this.$ = ["(", "Number(", $$[$0 - 2], "&&", $$[$0], ")", ")"];
                    break;
                case 10:
                    this.$ = ["(", "Number(", $$[$0 - 2], "||", $$[$0], ")", ")"];
                    break;
                case 11:
                    this.$ = ["(", "Number(!", $$[$0], ")", ")"];
                    break;
                case 12:
                    this.$ = ["(", "Number(", $$[$0 - 2], "==", $$[$0], ")", ")"];
                    break;
                case 13:
                    this.$ = ["(", "Number(", $$[$0 - 2], "!=", $$[$0], ")", ")"];
                    break;
                case 14:
                    this.$ = ["(", "Number(RegExp(", $$[$0], ").test(", $$[$0 - 2], "))", ")"];
                    break;
                case 15:
                    this.$ = ["(", "Number(", $$[$0 - 2], "<", $$[$0], ")", ")"];
                    break;
                case 16:
                    this.$ = ["(", "Number(", $$[$0 - 2], "<=", $$[$0], ")", ")"];
                    break;
                case 17:
                    this.$ = ["(", "Number(", $$[$0 - 2], "> ", $$[$0], ")", ")"];
                    break;
                case 18:
                    this.$ = ["(", "Number(", $$[$0 - 2], ">=", $$[$0], ")", ")"];
                    break;
                case 19:
                    this.$ = ["(", $$[$0 - 4], "?", $$[$0 - 2], ":", $$[$0], ")"];
                    break;
                case 20:
                    this.$ = ["(", $$[$0 - 1], ")"];
                    break;
                case 21:
                    this.$ = ["(", "[", $$[$0 - 3], ",", $$[$0 - 1], "]", ")"];
                    break;
                case 22:
                    this.$ = ["(", $$[$0], ")"];
                    break;
                case 23:
                    this.$ = ["(", $$[$0], ")"];
                    break;
                case 24:
                    this.$ = ["(", "prop(", $$[$0], ", data)", ")"];
                    break;
                case 25:
                    this.$ = ["(", "prop(", $$[$0 - 2], ",", $$[$0], ")", ")"];
                    break;
                case 26:
                    this.$ = ["(", "(std.isfn(fns, ", $$[$0 - 2], ") ? fns[", $$[$0 - 2], "]() : std.unknown(", $$[$0 - 2], "))", ")"];
                    break;
                case 27:
                    this.$ = ["(", "(std.isfn(fns, ", $$[$0 - 3], ") ? fns[", $$[$0 - 3], "](", $$[$0 - 1], ") : std.unknown(", $$[$0 - 3], "))", ")"];
                    break;
                case 28:
                    this.$ = ["(", "std.isSubset(", $$[$0 - 2], ", ", $$[$0], ")", ")"];
                    break;
                case 29:
                    this.$ = ["(", "+!std.isSubset(", $$[$0 - 3], ", ", $$[$0], ")", ")"];
                    break;
                case 30:
                    this.$ = [$$[$0]];
                    break;
                case 31:
                    this.$ = [$$[$0 - 2], ",", $$[$0]];
                    break;
                case 32:
                    this.$ = ["o ==", $$[$0]];
                    break;
                case 33:
                    this.$ = [$$[$0 - 2], "|| o ==", $$[$0]];
                    break;
                case 34:
                    this.$ = ["(", $$[$0], ")"];
                    break;
                case 35:
                    this.$ = [$$[$0 - 2], ",", $$[$0]];
                    break;
            }
        },
        table: [{
            3: 1,
            4: 2,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            1: [3]
        }, {
            5: [1, 9],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            33: [1, 26]
        }, {
            4: 28,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 29,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 30,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            26: 31,
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            5: [2, 22],
            6: [2, 22],
            7: [2, 22],
            8: [2, 22],
            9: [2, 22],
            10: [2, 22],
            11: [2, 22],
            12: [2, 22],
            13: [2, 22],
            14: [2, 22],
            15: [2, 22],
            16: [2, 22],
            17: [2, 22],
            18: [2, 22],
            19: [2, 22],
            20: [2, 22],
            21: [2, 22],
            22: [2, 22],
            23: [2, 22],
            25: [2, 22],
            27: [2, 22],
            33: [2, 22]
        }, {
            5: [2, 23],
            6: [2, 23],
            7: [2, 23],
            8: [2, 23],
            9: [2, 23],
            10: [2, 23],
            11: [2, 23],
            12: [2, 23],
            13: [2, 23],
            14: [2, 23],
            15: [2, 23],
            16: [2, 23],
            17: [2, 23],
            18: [2, 23],
            19: [2, 23],
            20: [2, 23],
            21: [2, 23],
            22: [2, 23],
            23: [2, 23],
            25: [2, 23],
            27: [2, 23],
            33: [2, 23]
        }, {
            5: [2, 24],
            6: [2, 24],
            7: [2, 24],
            8: [2, 24],
            9: [2, 24],
            10: [2, 24],
            11: [2, 24],
            12: [2, 24],
            13: [2, 24],
            14: [2, 24],
            15: [2, 24],
            16: [2, 24],
            17: [2, 24],
            18: [2, 24],
            19: [2, 24],
            20: [2, 24],
            21: [2, 24],
            22: [2, 24],
            23: [2, 24],
            24: [1, 33],
            25: [2, 24],
            27: [2, 24],
            31: [1, 32],
            33: [2, 24]
        }, {
            1: [2, 1]
        }, {
            4: 34,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 35,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 36,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 37,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 38,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 39,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 40,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 41,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 42,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 43,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 44,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 45,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 46,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 47,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 48,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 49,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 50,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            33: [1, 51]
        }, {
            5: [2, 8],
            6: [2, 8],
            7: [2, 8],
            8: [2, 8],
            9: [2, 8],
            10: [2, 8],
            11: [2, 8],
            12: [2, 8],
            13: [2, 8],
            14: [2, 8],
            15: [2, 8],
            16: [2, 8],
            17: [2, 8],
            18: [2, 8],
            19: [2, 8],
            20: [2, 8],
            21: [2, 8],
            22: [2, 8],
            23: [2, 8],
            25: [2, 8],
            27: [2, 8],
            33: [2, 8]
        }, {
            5: [2, 11],
            6: [2, 11],
            7: [2, 11],
            8: [2, 11],
            9: [2, 11],
            10: [2, 11],
            11: [2, 11],
            12: [2, 11],
            13: [2, 11],
            14: [2, 11],
            15: [2, 11],
            16: [2, 11],
            17: [2, 11],
            18: [2, 11],
            19: [2, 11],
            20: [2, 11],
            21: [2, 11],
            22: [2, 11],
            23: [2, 11],
            25: [2, 11],
            27: [2, 11],
            33: [2, 11]
        }, {
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            25: [1, 52],
            27: [2, 34],
            33: [1, 26]
        }, {
            27: [1, 53]
        }, {
            4: 54,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            4: 57,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            25: [1, 55],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8],
            32: 56
        }, {
            5: [2, 2],
            6: [2, 2],
            7: [2, 2],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 2],
            13: [2, 2],
            14: [1, 27],
            15: [2, 2],
            16: [2, 2],
            17: [2, 2],
            18: [2, 2],
            19: [2, 2],
            20: [2, 2],
            21: [2, 2],
            22: [2, 2],
            23: [2, 2],
            25: [2, 2],
            27: [2, 2],
            33: [2, 2]
        }, {
            5: [2, 3],
            6: [2, 3],
            7: [2, 3],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 3],
            13: [2, 3],
            14: [1, 27],
            15: [2, 3],
            16: [2, 3],
            17: [2, 3],
            18: [2, 3],
            19: [2, 3],
            20: [2, 3],
            21: [2, 3],
            22: [2, 3],
            23: [2, 3],
            25: [2, 3],
            27: [2, 3],
            33: [2, 3]
        }, {
            5: [2, 4],
            6: [2, 4],
            7: [2, 4],
            8: [2, 4],
            9: [2, 4],
            10: [2, 4],
            11: [1, 15],
            12: [2, 4],
            13: [2, 4],
            14: [1, 27],
            15: [2, 4],
            16: [2, 4],
            17: [2, 4],
            18: [2, 4],
            19: [2, 4],
            20: [2, 4],
            21: [2, 4],
            22: [2, 4],
            23: [2, 4],
            25: [2, 4],
            27: [2, 4],
            33: [2, 4]
        }, {
            5: [2, 5],
            6: [2, 5],
            7: [2, 5],
            8: [2, 5],
            9: [2, 5],
            10: [2, 5],
            11: [1, 15],
            12: [2, 5],
            13: [2, 5],
            14: [1, 27],
            15: [2, 5],
            16: [2, 5],
            17: [2, 5],
            18: [2, 5],
            19: [2, 5],
            20: [2, 5],
            21: [2, 5],
            22: [2, 5],
            23: [2, 5],
            25: [2, 5],
            27: [2, 5],
            33: [2, 5]
        }, {
            5: [2, 6],
            6: [2, 6],
            7: [2, 6],
            8: [2, 6],
            9: [2, 6],
            10: [2, 6],
            11: [1, 15],
            12: [2, 6],
            13: [2, 6],
            14: [1, 27],
            15: [2, 6],
            16: [2, 6],
            17: [2, 6],
            18: [2, 6],
            19: [2, 6],
            20: [2, 6],
            21: [2, 6],
            22: [2, 6],
            23: [2, 6],
            25: [2, 6],
            27: [2, 6],
            33: [2, 6]
        }, {
            5: [2, 7],
            6: [2, 7],
            7: [2, 7],
            8: [2, 7],
            9: [2, 7],
            10: [2, 7],
            11: [2, 7],
            12: [2, 7],
            13: [2, 7],
            14: [1, 27],
            15: [2, 7],
            16: [2, 7],
            17: [2, 7],
            18: [2, 7],
            19: [2, 7],
            20: [2, 7],
            21: [2, 7],
            22: [2, 7],
            23: [2, 7],
            25: [2, 7],
            27: [2, 7],
            33: [2, 7]
        }, {
            5: [2, 9],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 9],
            13: [2, 9],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 9],
            23: [2, 9],
            25: [2, 9],
            27: [2, 9],
            33: [1, 26]
        }, {
            5: [2, 10],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [2, 10],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 10],
            23: [2, 10],
            25: [2, 10],
            27: [2, 10],
            33: [1, 26]
        }, {
            5: [2, 12],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 12],
            13: [2, 12],
            14: [1, 27],
            15: [2, 12],
            16: [2, 12],
            17: [2, 12],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 12],
            23: [2, 12],
            25: [2, 12],
            27: [2, 12],
            33: [2, 12]
        }, {
            5: [2, 13],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 13],
            13: [2, 13],
            14: [1, 27],
            15: [2, 13],
            16: [2, 13],
            17: [2, 13],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 13],
            23: [2, 13],
            25: [2, 13],
            27: [2, 13],
            33: [2, 13]
        }, {
            5: [2, 14],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 14],
            13: [2, 14],
            14: [1, 27],
            15: [2, 14],
            16: [2, 14],
            17: [2, 14],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 14],
            23: [2, 14],
            25: [2, 14],
            27: [2, 14],
            33: [2, 14]
        }, {
            5: [2, 15],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 15],
            13: [2, 15],
            14: [1, 27],
            15: [2, 15],
            16: [2, 15],
            17: [2, 15],
            18: [2, 15],
            19: [2, 15],
            20: [2, 15],
            21: [2, 15],
            22: [2, 15],
            23: [2, 15],
            25: [2, 15],
            27: [2, 15],
            33: [2, 15]
        }, {
            5: [2, 16],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 16],
            13: [2, 16],
            14: [1, 27],
            15: [2, 16],
            16: [2, 16],
            17: [2, 16],
            18: [2, 16],
            19: [2, 16],
            20: [2, 16],
            21: [2, 16],
            22: [2, 16],
            23: [2, 16],
            25: [2, 16],
            27: [2, 16],
            33: [2, 16]
        }, {
            5: [2, 17],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 17],
            13: [2, 17],
            14: [1, 27],
            15: [2, 17],
            16: [2, 17],
            17: [2, 17],
            18: [2, 17],
            19: [2, 17],
            20: [2, 17],
            21: [2, 17],
            22: [2, 17],
            23: [2, 17],
            25: [2, 17],
            27: [2, 17],
            33: [2, 17]
        }, {
            5: [2, 18],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 18],
            13: [2, 18],
            14: [1, 27],
            15: [2, 18],
            16: [2, 18],
            17: [2, 18],
            18: [2, 18],
            19: [2, 18],
            20: [2, 18],
            21: [2, 18],
            22: [2, 18],
            23: [2, 18],
            25: [2, 18],
            27: [2, 18],
            33: [2, 18]
        }, {
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            23: [1, 58],
            33: [1, 26]
        }, {
            5: [2, 28],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [2, 28],
            13: [2, 28],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 28],
            23: [2, 28],
            25: [2, 28],
            27: [2, 28],
            33: [2, 28]
        }, {
            4: 59,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            5: [2, 20],
            6: [2, 20],
            7: [2, 20],
            8: [2, 20],
            9: [2, 20],
            10: [2, 20],
            11: [2, 20],
            12: [2, 20],
            13: [2, 20],
            14: [2, 20],
            15: [2, 20],
            16: [2, 20],
            17: [2, 20],
            18: [2, 20],
            19: [2, 20],
            20: [2, 20],
            21: [2, 20],
            22: [2, 20],
            23: [2, 20],
            25: [2, 20],
            27: [2, 20],
            33: [2, 20]
        }, {
            4: 60,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            5: [2, 25],
            6: [2, 25],
            7: [2, 25],
            8: [2, 25],
            9: [2, 25],
            10: [2, 25],
            11: [2, 25],
            12: [2, 25],
            13: [2, 25],
            14: [2, 25],
            15: [2, 25],
            16: [2, 25],
            17: [2, 25],
            18: [2, 25],
            19: [2, 25],
            20: [2, 25],
            21: [2, 25],
            22: [2, 25],
            23: [2, 25],
            25: [2, 25],
            27: [2, 25],
            33: [2, 25]
        }, {
            5: [2, 26],
            6: [2, 26],
            7: [2, 26],
            8: [2, 26],
            9: [2, 26],
            10: [2, 26],
            11: [2, 26],
            12: [2, 26],
            13: [2, 26],
            14: [2, 26],
            15: [2, 26],
            16: [2, 26],
            17: [2, 26],
            18: [2, 26],
            19: [2, 26],
            20: [2, 26],
            21: [2, 26],
            22: [2, 26],
            23: [2, 26],
            25: [2, 26],
            27: [2, 26],
            33: [2, 26]
        }, {
            25: [1, 61],
            27: [1, 62]
        }, {
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            25: [2, 30],
            27: [2, 30],
            33: [1, 26]
        }, {
            4: 63,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            5: [2, 29],
            6: [2, 29],
            7: [2, 29],
            8: [2, 29],
            9: [2, 29],
            10: [2, 29],
            11: [2, 29],
            12: [2, 29],
            13: [2, 29],
            14: [2, 29],
            15: [2, 29],
            16: [2, 29],
            17: [2, 29],
            18: [2, 29],
            19: [2, 29],
            20: [2, 29],
            21: [2, 29],
            22: [2, 29],
            23: [2, 29],
            25: [2, 29],
            27: [2, 29],
            33: [2, 29]
        }, {
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            25: [1, 64],
            27: [2, 35],
            33: [1, 26]
        }, {
            5: [2, 27],
            6: [2, 27],
            7: [2, 27],
            8: [2, 27],
            9: [2, 27],
            10: [2, 27],
            11: [2, 27],
            12: [2, 27],
            13: [2, 27],
            14: [2, 27],
            15: [2, 27],
            16: [2, 27],
            17: [2, 27],
            18: [2, 27],
            19: [2, 27],
            20: [2, 27],
            21: [2, 27],
            22: [2, 27],
            23: [2, 27],
            25: [2, 27],
            27: [2, 27],
            33: [2, 27]
        }, {
            4: 65,
            7: [1, 3],
            14: [1, 4],
            24: [1, 5],
            28: [1, 6],
            29: [1, 7],
            30: [1, 8]
        }, {
            5: [2, 19],
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [2, 19],
            23: [2, 19],
            25: [2, 19],
            27: [2, 19],
            33: [1, 26]
        }, {
            5: [2, 21],
            6: [2, 21],
            7: [2, 21],
            8: [2, 21],
            9: [2, 21],
            10: [2, 21],
            11: [2, 21],
            12: [2, 21],
            13: [2, 21],
            14: [2, 21],
            15: [2, 21],
            16: [2, 21],
            17: [2, 21],
            18: [2, 21],
            19: [2, 21],
            20: [2, 21],
            21: [2, 21],
            22: [2, 21],
            23: [2, 21],
            25: [2, 21],
            27: [2, 21],
            33: [2, 21]
        }, {
            6: [1, 10],
            7: [1, 11],
            8: [1, 12],
            9: [1, 13],
            10: [1, 14],
            11: [1, 15],
            12: [1, 16],
            13: [1, 17],
            14: [1, 27],
            15: [1, 18],
            16: [1, 19],
            17: [1, 20],
            18: [1, 21],
            19: [1, 22],
            20: [1, 23],
            21: [1, 24],
            22: [1, 25],
            25: [2, 31],
            27: [2, 31],
            33: [1, 26]
        }],
        defaultActions: {
            9: [2, 1]
        },
        parseError: function parseError(str, hash) {
            throw new Error(str);
        },
        parse: function parse(input) {
            var self = this,
                stack = [0],
                vstack = [null], // semantic value stack
                lstack = [], // location stack
                table = this.table,
                yytext = '',
                yylineno = 0,
                yyleng = 0,
                recovering = 0,
                TERROR = 2,
                EOF = 1;

            //this.reductionCount = this.shiftCount = 0;

            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            this.yy.parser = this;
            if (typeof this.lexer.yylloc == 'undefined')
                this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);

            var ranges = this.lexer.options && this.lexer.options.ranges;

            if (typeof this.yy.parseError === 'function')
                this.parseError = this.yy.parseError;

            function popStack(n) {
                stack.length = stack.length - 2 * n;
                vstack.length = vstack.length - n;
                lstack.length = lstack.length - n;
            }

            function lex() {
                var token;
                token = self.lexer.lex() || 1; // $end = 1
                // if token isn't its numeric value, convert
                if (typeof token !== 'number') {
                    token = self.symbols_[token] || token;
                }
                return token;
            }

            var symbol, preErrorSymbol, state, action, r, yyval = {},
                p, len, newState, expected;
            while (true) {
                // retreive state number from top of stack
                state = stack[stack.length - 1];

                // use default actions if available
                if (this.defaultActions[state]) {
                    action = this.defaultActions[state];
                } else {
                    if (symbol === null || typeof symbol == 'undefined') {
                        symbol = lex();
                    }
                    // read action for current state and first input
                    action = table[state] && table[state][symbol];
                }

                // handle parse error
                if (typeof action === 'undefined' || !action.length || !action[0]) {

                        var errStr = '';
                        if (!recovering) {
                            // Report error
                            expected = [];
                            for (p in table[state])
                                if (this.terminals_[p] && p > 2) {
                                    expected.push("'" + this.terminals_[p] + "'");
                                }
                            if (this.lexer.showPosition) {
                                errStr = 'Parse error on line ' + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol) + "'";
                            } else {
                                errStr = 'Parse error on line ' + (yylineno + 1) + ": Unexpected " +
                                    (symbol == 1 /*EOF*/ ? "end of input" :
                                        ("'" + (this.terminals_[symbol] || symbol) + "'"));
                            }
                            this.parseError(errStr, {
                                text: this.lexer.match,
                                token: this.terminals_[symbol] || symbol,
                                line: this.lexer.yylineno,
                                loc: yyloc,
                                expected: expected
                            });
                        }

                        // just recovered from another error
                        if (recovering == 3) {
                            if (symbol == EOF) {
                                throw new Error(errStr || 'Parsing halted.');
                            }

                            // discard current lookahead and grab another
                            yyleng = this.lexer.yyleng;
                            yytext = this.lexer.yytext;
                            yylineno = this.lexer.yylineno;
                            yyloc = this.lexer.yylloc;
                            symbol = lex();
                        }

                        // try to recover from error
                        while (1) {
                            // check for error recovery rule in this state
                            if ((TERROR.toString()) in table[state]) {
                                break;
                            }
                            if (state === 0) {
                                throw new Error(errStr || 'Parsing halted.');
                            }
                            popStack(1);
                            state = stack[stack.length - 1];
                        }

                        preErrorSymbol = symbol == 2 ? null : symbol; // save the lookahead token
                        symbol = TERROR; // insert generic error symbol as new lookahead
                        state = stack[stack.length - 1];
                        action = table[state] && table[state][TERROR];
                        recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
                    }

                // this shouldn't happen, unless resolve defaults are off
                if (action[0] instanceof Array && action.length > 1) {
                    throw new Error('Parse Error: multiple actions possible at state: ' + state + ', token: ' + symbol);
                }

                switch (action[0]) {

                    case 1: // shift
                        //this.shiftCount++;

                        stack.push(symbol);
                        vstack.push(this.lexer.yytext);
                        lstack.push(this.lexer.yylloc);
                        stack.push(action[1]); // push state
                        symbol = null;
                        if (!preErrorSymbol) { // normal execution/no error
                            yyleng = this.lexer.yyleng;
                            yytext = this.lexer.yytext;
                            yylineno = this.lexer.yylineno;
                            yyloc = this.lexer.yylloc;
                            if (recovering > 0)
                                recovering--;
                        } else { // error just occurred, resume old lookahead f/ before error
                            symbol = preErrorSymbol;
                            preErrorSymbol = null;
                        }
                        break;

                    case 2: // reduce
                        //this.reductionCount++;

                        len = this.productions_[action[1]][1];

                        // perform semantic action
                        yyval.$ = vstack[vstack.length - len]; // default to $$ = $1
                        // default location, uses first token for firsts, last for lasts
                        yyval._$ = {
                            first_line: lstack[lstack.length - (len || 1)].first_line,
                            last_line: lstack[lstack.length - 1].last_line,
                            first_column: lstack[lstack.length - (len || 1)].first_column,
                            last_column: lstack[lstack.length - 1].last_column
                        };
                        if (ranges) {
                            yyval._$.range = [lstack[lstack.length - (len || 1)].range[0], lstack[lstack.length - 1].range[1]];
                        }
                        r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                        if (typeof r !== 'undefined') {
                            return r;
                        }

                        // pop off stack
                        if (len) {
                            stack = stack.slice(0, -1 * len * 2);
                            vstack = vstack.slice(0, -1 * len);
                            lstack = lstack.slice(0, -1 * len);
                        }

                        stack.push(this.productions_[action[1]][0]); // push nonterminal (reduce)
                        vstack.push(yyval.$);
                        lstack.push(yyval._$);
                        // goto new state = table[STATE][NONTERMINAL]
                        newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
                        stack.push(newState);
                        break;

                    case 3: // accept
                        return true;
                }

            }

            return true;
        }
    };
    var lexer = (function() {
        var lexer = ({
            EOF: 1,
            parseError: function parseError(str, hash) {
                if (this.yy.parser) {
                    this.yy.parser.parseError(str, hash);
                } else {
                    throw new Error(str);
                }
            },
            setInput: function(input) {
                this._input = input;
                this._more = this._less = this.done = false;
                this.yylineno = this.yyleng = 0;
                this.yytext = this.matched = this.match = '';
                this.conditionStack = ['INITIAL'];
                this.yylloc = {
                    first_line: 1,
                    first_column: 0,
                    last_line: 1,
                    last_column: 0
                };
                if (this.options.ranges) this.yylloc.range = [0, 0];
                this.offset = 0;
                return this;
            },
            input: function() {
                var ch = this._input[0];
                this.yytext += ch;
                this.yyleng++;
                this.offset++;
                this.match += ch;
                this.matched += ch;
                var lines = ch.match(/(?:\r\n?|\n).*/g);
                if (lines) {
                    this.yylineno++;
                    this.yylloc.last_line++;
                } else {
                    this.yylloc.last_column++;
                }
                if (this.options.ranges) this.yylloc.range[1]++;

                this._input = this._input.slice(1);
                return ch;
            },
            unput: function(ch) {
                var len = ch.length;
                var lines = ch.split(/(?:\r\n?|\n)/g);

                this._input = ch + this._input;
                this.yytext = this.yytext.substr(0, this.yytext.length - len - 1);
                //this.yyleng -= len;
                this.offset -= len;
                var oldLines = this.match.split(/(?:\r\n?|\n)/g);
                this.match = this.match.substr(0, this.match.length - 1);
                this.matched = this.matched.substr(0, this.matched.length - 1);

                if (lines.length - 1) this.yylineno -= lines.length - 1;
                var r = this.yylloc.range;

                this.yylloc = {
                    first_line: this.yylloc.first_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.first_column,
                    last_column: lines ?
                        (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
                };

                if (this.options.ranges) {
                    this.yylloc.range = [r[0], r[0] + this.yyleng - len];
                }
                return this;
            },
            more: function() {
                this._more = true;
                return this;
            },
            less: function(n) {
                this.unput(this.match.slice(n));
            },
            pastInput: function() {
                var past = this.matched.substr(0, this.matched.length - this.match.length);
                return (past.length > 20 ? '...' : '') + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
                var next = this.match;
                if (next.length < 20) {
                    next += this._input.substr(0, 20 - next.length);
                }
                return (next.substr(0, 20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
            },
            showPosition: function() {
                var pre = this.pastInput();
                var c = new Array(pre.length + 1).join("-");
                return pre + this.upcomingInput() + "\n" + c + "^";
            },
            next: function() {
                if (this.done) {
                    return this.EOF;
                }
                if (!this._input) this.done = true;

                var token,
                    match,
                    tempMatch,
                    index,
                    lines;
                if (!this._more) {
                    this.yytext = '';
                    this.match = '';
                }
                var rules = this._currentRules();
                for (var i = 0; i < rules.length; i++) {
                    tempMatch = this._input.match(this.rules[rules[i]]);
                    if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                        match = tempMatch;
                        index = i;
                        if (!this.options.flex) break;
                    }
                }
                if (match) {
                    lines = match[0].match(/(?:\r\n?|\n).*/g);
                    if (lines) this.yylineno += lines.length;
                    this.yylloc = {
                        first_line: this.yylloc.last_line,
                        last_line: this.yylineno + 1,
                        first_column: this.yylloc.last_column,
                        last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
                    };
                    this.yytext += match[0];
                    this.match += match[0];
                    this.matches = match;
                    this.yyleng = this.yytext.length;
                    if (this.options.ranges) {
                        this.yylloc.range = [this.offset, this.offset += this.yyleng];
                    }
                    this._more = false;
                    this._input = this._input.slice(match[0].length);
                    this.matched += match[0];
                    token = this.performAction.call(this, this.yy, this, rules[index], this.conditionStack[this.conditionStack.length - 1]);
                    if (this.done && this._input) this.done = false;
                    if (token) return token;
                    else return;
                }
                if (this._input === "") {
                    return this.EOF;
                } else {
                    return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                        text: "",
                        token: null,
                        line: this.yylineno
                    });
                }
            },
            lex: function lex() {
                var r = this.next();
                if (typeof r !== 'undefined') {
                    return r;
                } else {
                    return this.lex();
                }
            },
            begin: function begin(condition) {
                this.conditionStack.push(condition);
            },
            popState: function popState() {
                return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
                return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
                return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
                this.begin(condition);
            }
        });
        lexer.options = {};
        lexer.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            switch ($avoiding_name_collisions) {
                case 0:
                    return "*";
                case 1:
                    return "/";
                case 2:
                    return "-";
                case 3:
                    return "+";
                case 4:
                    return "^";
                case 5:
                    return "%";
                case 6:
                    return "(";
                case 7:
                    return ")";
                case 8:
                    return ",";
                case 9:
                    return "==";
                case 10:
                    return "!=";
                case 11:
                    return "~=";
                case 12:
                    return ">=";
                case 13:
                    return "<=";
                case 14:
                    return "<";
                case 15:
                    return ">";
                case 16:
                    return "?";
                case 17:
                    return ":";
                case 18:
                    return "and";
                case 19:
                    return "or";
                case 20:
                    return "not";
                case 21:
                    return "in";
                case 22:
                    return "of";
                case 23:
                    break;
                case 24:
                    return "NUMBER";
                case 25:
                    yy_.yytext = JSON.stringify(yy_.yytext);
                    return "SYMBOL";
                case 26:
                    yy_.yytext = yy.buildString("'", yy_.yytext);
                    return "SYMBOL";
                case 27:
                    yy_.yytext = yy.buildString('"', yy_.yytext);
                    return "STRING";
                case 28:
                    return "EOF";
            }
        };
        lexer.rules = [/^(?:\*)/, /^(?:\/)/, /^(?:-)/, /^(?:\+)/, /^(?:\^)/, /^(?:\%)/, /^(?:\()/, /^(?:\))/, /^(?:\,)/, /^(?:==)/, /^(?:\!=)/, /^(?:\~=)/, /^(?:>=)/, /^(?:<=)/, /^(?:<)/, /^(?:>)/, /^(?:\?)/, /^(?:\:)/, /^(?:and[^\w])/, /^(?:or[^\w])/, /^(?:not[^\w])/, /^(?:in[^\w])/, /^(?:of[^\w])/, /^(?:\s+)/, /^(?:[0-9]+(?:\.[0-9]+)?\b)/, /^(?:[a-zA-Z$_][\.a-zA-Z0-9$_]*)/, /^(?:'(?:\\'|\\\\|[^'\\])*')/, /^(?:"(?:\\"|\\\\|[^"\\])*")/, /^(?:$)/];
        lexer.conditions = {
            "INITIAL": {
                "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28],
                "inclusive": true
            }
        };
        return lexer;
    })();
    parser.lexer = lexer;

    function Parser() {
        this.yy = {};
    }
    Parser.prototype = parser;
    parser.Parser = Parser;
    return new Parser;
})();
const parser = _parser;
_parser.Parser;

// the parser is dynamically generated from generateParser.js at compile time

// Shared utility functions
const std =
{

    isfn: function(fns, funcName) {
        return fns.hasOwnProperty(funcName) && typeof fns[funcName] === "function";
    },

    unknown: function(funcName) {
        throw ReferenceError('Unknown function: ' + funcName + '()');
    },

    coerceArray: function(value) {
        if (Array.isArray(value))
            return value;
        else
            return [value];
    },

    coerceBoolean: function(value) {
        if (typeof value === 'boolean')
            return +value;
        else
            return value;
    },

    isSubset: function(a, b) {
        const A = std.coerceArray(a);
        const B = std.coerceArray(b);
        return +A.every( val => B.includes(val) );
    },

    buildString: function(quote, literal)
    {
        quote = String(quote)[0];
        literal = String(literal);
        let built = '';

        if (literal[0] !== quote || literal[literal.length-1] !== quote)
            throw new Error(`Unexpected internal error: String literal doesn't begin/end with the right quotation mark.`);

        for (let i = 1; i < literal.length - 1; i++)
        {
            if (literal[i] === "\\")
            {
                i++;
                if (i >= literal.length - 1) throw new Error(`Unexpected internal error: Unescaped backslash at the end of string literal.`);

                if (literal[i] === "\\") built += '\\';
                else if (literal[i] === quote) built += quote;
                else throw new Error(`Unexpected internal error: Invalid escaped character in string literal: ${literal[i]}`);
            }
            else if (literal[i] === quote)
            {
                throw new Error(`Unexpected internal error: String literal contains unescaped quotation mark.`);
            }
            else
            {
                built += literal[i];
            }
        }

        return JSON.stringify(built);
    }
};

parser.yy = Object.create(std);

/**
 * Filtrex provides compileExpression() to compile user expressions to JavaScript.
 *
 * See https://github.com/joewalnes/filtrex for tutorial, reference and examples.
 * MIT License.
 *
 * Includes Jison by Zachary Carter. See http://jison.org/
 *
 * -Joe Walnes
 */
function compileExpression(expression, options) {

    // Check and coerce arguments

    if (arguments.length > 2) throw new TypeError('Too many arguments.');

    options = typeof options === "object" ? options : {};
    let {extraFunctions, customProp} = options;
    for (let key of Object.getOwnPropertyNames(options))
    {
        if (key !== "extraFunctions" && key !== "customProp") throw new TypeError(`Unknown option: ${key}`);
    }



    // Functions available to the expression

    let functions = {
        abs: Math.abs,
        ceil: Math.ceil,
        floor: Math.floor,
        log: Math.log,
        max: Math.max,
        min: Math.min,
        random: Math.random,
        round: Math.round,
        sqrt: Math.sqrt,
    };

    if (extraFunctions) {
        for (var name in extraFunctions) {
            if (extraFunctions.hasOwnProperty(name)) {
                functions[name] = extraFunctions[name];
            }
        }
    }



    // Compile the expression

    let tree = parser.parse(expression);

    let js = [];
    js.push('return ');
    function toJs(node) {
        if (Array.isArray(node)) {
            node.forEach(toJs);
        } else {
            js.push(node);
        }
    }
    tree.forEach(toJs);
    js.push(';');



    // Metaprogramming functions

    function prop(name, obj) {
        return Object.prototype.hasOwnProperty.call(obj||{}, name) ? obj[name] : undefined;
    }

    function safeGetter(obj) {
        return function get(name) {
            return Object.prototype.hasOwnProperty.call(obj||{}, name) ? obj[name] : undefined;
        }
    }

    if (typeof customProp === 'function') {
        prop = (name, obj) => std.coerceBoolean(customProp(name, safeGetter(obj), obj));
    }



    // Patch together and return

    let func = new Function('fns', 'std', 'prop', 'data', js.join(''));

    return function(data) {
        try {
            return func(functions, std, prop, data);
        }
        catch (e)
        {
            return e;
        }
    };
}

function applyRowFilters(filters, maxRows = Infinity, rows, columnVariables) {
    const filteredRows = [];
    const expressions = [];
    for (const expression of filters) {
        expressions.push(compileExpression(expression));
    }
    let rowIndex = 1;
    for (const row of rows) {
        let passesTests = true;
        if (rowIndex > maxRows) {
            break;
        }
        for (const expression of expressions) {
            if (!evaluateExpression(row, expression, columnVariables)) {
                passesTests = false;
                break;
            }
        }
        if (passesTests) {
            filteredRows.push(row);
        }
        rowIndex += 1;
    }
    return filteredRows;
}
function sortRows(sortExpressions, rows, columnVariables) {
    const sortedRows = [...rows];
    const expressions = [];
    for (const expression of sortExpressions) {
        expressions.push(compileExpression(expression.expression));
    }
    for (const expression of sortExpressions.reverse()) {
        const sortExpression = compileExpression(expression.expression);
        sortedRows.sort((a, b) => {
            const aResult = evaluateExpression(a, sortExpression, columnVariables);
            const bResult = evaluateExpression(b, sortExpression, columnVariables);
            if (aResult < bResult) {
                return expression.reversed ? 1 : -1;
            }
            else if (aResult > bResult) {
                return expression.reversed ? -1 : 1;
            }
            else {
                return 0;
            }
        });
    }
    return sortedRows;
}
function evaluateExpression(row, expression, columnVariables) {
    const extendedRow = Object.assign({}, row);
    for (const columnVariable in columnVariables !== null && columnVariables !== void 0 ? columnVariables : {}) {
        extendedRow[columnVariable] = row[columnVariables[columnVariable]];
    }
    return expression(extendedRow);
}
function getCellDisplay(row, expression) {
    if (typeof row[expression] === 'string') {
        return row[expression];
    }
    else {
        return JSON.stringify(row[expression]);
    }
}
function getColumnInfo(column) {
    if (typeof column === 'string') {
        return {
            name: column,
            expression: column
        };
    }
    else {
        return column;
    }
}
function getSortExpression(expression) {
    if (typeof expression === 'string') {
        return {
            expression: expression,
            reversed: false
        };
    }
    return expression;
}
function getArrayForArrayOrObject(value) {
    if (value === null || value === undefined) {
        return [];
    }
    if (Array.isArray(value)) {
        return value;
    }
    return [value];
}

function getFilteredCsvData(csvSpec, csvData) {
    var _a, _b, _c;
    const _d = ((_a = csvSpec.csvOptions) !== null && _a !== void 0 ? _a : {}), { cast = true, cast_date = true, trim = true, columns = true, skip_empty_lines = true } = _d, extraOptions = __rest(_d, ["cast", "cast_date", "trim", "columns", "skip_empty_lines"]);
    const csvOptions = Object.assign({ cast, trim, columns, skip_empty_lines }, extraOptions);
    const parsedCsvData = sync(csvData, csvOptions);
    const columnNames = [];
    const rowColumns = Object.keys(parsedCsvData[0]);
    try {
        for (const column of (_b = csvSpec.columns) !== null && _b !== void 0 ? _b : rowColumns) {
            const columnInfo = getColumnInfo(column);
            // Do not attempt to compile/set the expression value
            // if it already exists in our known row columns
            if (rowColumns.indexOf(columnInfo.name) === -1) {
                const expression = compileExpression(columnInfo.expression);
                for (const row of parsedCsvData) {
                    row[columnInfo.name] = evaluateExpression(row, expression, csvSpec.columnVariables);
                }
            }
            columnNames.push(columnInfo.name);
        }
    }
    catch (e) {
        throw new Error(`Error evaluating column expressions: ${e.message}.`);
    }
    let filteredSortedCsvData = [];
    try {
        filteredSortedCsvData = sortRows(getArrayForArrayOrObject(csvSpec.sortBy).map(getSortExpression), applyRowFilters(getArrayForArrayOrObject(csvSpec.filter), (_c = csvSpec.maxRows) !== null && _c !== void 0 ? _c : Infinity, parsedCsvData, csvSpec.columnVariables), csvSpec.columnVariables);
    }
    catch (e) {
        throw new Error(`Error evaluating filter expressions: ${e.message}.`);
    }
    return {
        columns: columnNames,
        rows: filteredSortedCsvData
    };
}

class TableRenderer extends obsidian.MarkdownRenderChild {
    constructor(columns, rows, container) {
        super(container);
        this.columns = columns;
        this.rows = rows;
        this.container = container;
    }
    onload() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.render();
        });
    }
    render() {
        return __awaiter(this, void 0, void 0, function* () {
            const tableEl = this.container.createEl('table');
            const theadEl = tableEl.createEl('thead');
            const headerEl = theadEl.createEl('tr');
            const tbodyEl = tableEl.createEl('tbody');
            const columnNames = [];
            for (const column of this.columns) {
                const columnInfo = getColumnInfo(column);
                headerEl.createEl('th', { text: columnInfo.name });
                columnNames.push(columnInfo.name);
            }
            for (const row of this.rows) {
                const trEl = tbodyEl.createEl('tr');
                for (const columnName of columnNames) {
                    trEl.createEl('td', { text: getCellDisplay(row, columnName) });
                }
            }
        });
    }
}
function renderErrorPre(container, error) {
    let pre = container.createEl('pre', { cls: ["csv-table", "csv-error"] });
    pre.appendText(error);
    return pre;
}

class CsvTablePlugin extends obsidian.Plugin {
    onload() {
        return __awaiter(this, void 0, void 0, function* () {
            this.registerMarkdownCodeBlockProcessor("csvtable", (csvSpecString, el, ctx) => __awaiter(this, void 0, void 0, function* () {
                try {
                    let tableSpec = {
                        source: "", // Assert that this has a proper value below
                    };
                    try {
                        tableSpec = obsidian.parseYaml(csvSpecString);
                    }
                    catch (e) {
                        throw new Error(`Could not parse CSV table spec: ${e.message}`);
                    }
                    if (!tableSpec.source) {
                        throw new Error("Parameter 'source' is required.");
                    }
                    const file = this.app.vault.getAbstractFileByPath(tableSpec.source);
                    if (!(file instanceof obsidian.TFile)) {
                        throw new Error(`CSV file '${tableSpec.source}' could not be found.`);
                    }
                    const csvData = yield this.app.vault.cachedRead(file);
                    console.log("Cached read success");
                    const filteredCsvData = getFilteredCsvData(tableSpec, csvData);
                    ctx.addChild(new TableRenderer(filteredCsvData.columns, filteredCsvData.rows, el));
                }
                catch (e) {
                    renderErrorPre(el, e.message);
                    return;
                }
            }));
        });
    }
}

module.exports = CsvTablePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
