/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => NewTabPlusPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian = require("obsidian");
var DEFAULT_SETTINGS = {
  CheckFileCurrentTabs: true,
  Delay: 30
};
var NewTabPlusPlugin = class extends import_obsidian.Plugin {
  constructor() {
    super(...arguments);
    this.valideTypes = /* @__PURE__ */ new Set(["markdown", "graph", "canvas", "image", "video", "audio", "pdf"]);
    this.prevOpenTabs = [];
    this.prevTabFilePaths = [];
    this.newOpenTabs = [];
    this.newTabFilePaths = [];
    this.isFileProcessed = false;
    this.onClickEvent = (event) => {
      this.isFileProcessed = false;
      this.prevOpenTabs = this.getOpenTabs();
      this.prevTabFilePaths = this.getFilePathsFromTabs(this.prevOpenTabs);
      this.prevActiveTab = this.findActiveTab(this.prevOpenTabs);
    };
    this.getOpenTabs = () => {
      const leaves = [];
      this.app.workspace.iterateAllLeaves((leaf) => {
        if (this.valideTypes.has(leaf.view.getViewType())) {
          leaves.push(leaf);
        }
      });
      return leaves;
    };
    this.getFilePathsFromTabs = (leaves) => {
      return leaves.map((leaf) => {
        if (leaf.view instanceof import_obsidian.FileView) {
          return leaf.view.file.path;
        }
        return leaf.view.getState().file;
      });
    };
    this.findActiveTab = (tabs) => {
      var _a;
      const activeFile = (_a = this.app.workspace.getActiveFile()) == null ? void 0 : _a.path;
      return tabs.find((leaf) => {
        var _a2;
        return ((_a2 = leaf.view.getState()) == null ? void 0 : _a2.file) === activeFile;
      });
    };
    this.findLastFile = () => {
      var _a;
      const activeFile = (_a = this.app.workspace.getActiveFile()) == null ? void 0 : _a.path;
      const index = this.newOpenTabs.findLastIndex((leaf) => {
        var _a2;
        return ((_a2 = leaf.view.getState()) == null ? void 0 : _a2.file) === activeFile;
      });
      return this.newOpenTabs[index];
    };
    this.markFileAsDeleted = async () => {
      this.isFileProcessed = true;
    };
    this.handleFileOpen = (file) => {
      var _a;
      if (this.isFileProcessed)
        return;
      this.isFileProcessed = true;
      if (this.prevOpenTabs.length === 0)
        return;
      this.newOpenTabs = this.getOpenTabs();
      this.newTabFilePaths = this.getFilePathsFromTabs(this.newOpenTabs);
      this.newActiveFilePath = file.path;
      this.newActiveTab = this.findActiveTab(this.newOpenTabs);
      const indexLeaf = this.prevTabFilePaths.findIndex((path) => this.newActiveFilePath == path);
      if (this.newTabFilePaths.length !== this.prevTabFilePaths.length) {
        if (this.newTabFilePaths.length < this.prevTabFilePaths.length)
          return;
        else {
          if (this.prevTabFilePaths.includes(this.newActiveFilePath) && this.settings.CheckFileCurrentTabs) {
            (_a = this.findLastFile()) == null ? void 0 : _a.detach();
            this.app.workspace.setActiveLeaf(this.prevOpenTabs[indexLeaf], { focus: true });
            this.resetVariables();
            return;
          }
          return;
        }
      }
      if (this.areTabsUnchanged())
        return;
      if (indexLeaf !== -1) {
        if (this.prevTabFilePaths.includes(this.newActiveFilePath) && this.settings.CheckFileCurrentTabs) {
          this.executeWithDelay(() => this.openFileInTab(this.app.workspace.getLastOpenFiles()[0], false), this.settings.Delay);
          this.executeWithDelay(() => {
            this.app.workspace.setActiveLeaf(this.prevOpenTabs[indexLeaf], { focus: true });
            this.resetVariables();
          }, this.settings.Delay * 2);
          return;
        }
      }
      this.executeWithDelay(() => this.openFileInTab(this.app.workspace.getLastOpenFiles()[0], false), this.settings.Delay);
      this.executeWithDelay(() => this.openFileInTab(this.newActiveFilePath, true), this.settings.Delay * 2);
      this.resetVariables();
    };
    this.areTabsUnchanged = () => {
      return this.prevTabFilePaths.length === this.newTabFilePaths.length && this.prevTabFilePaths.every((path, index) => path === this.newTabFilePaths[index]);
    };
    this.openFileInTab = (path, newFile) => {
      const file = this.app.vault.getAbstractFileByPath(path);
      if (!file) {
        console.warn(`File not found: ${path}`);
        return;
      }
      const leaf = this.app.workspace.getLeaf(newFile);
      leaf.openFile(file);
    };
    this.resetVariables = () => {
      this.prevOpenTabs = [];
      this.prevTabFilePaths = [];
      this.newOpenTabs = [];
      this.newTabFilePaths = [];
    };
    this.executeWithDelay = (callback, delay = this.settings.Delay) => {
      setTimeout(callback, delay);
    };
  }
  async onload() {
    await this.loadSettings();
    this.registerDomEvent(window, "click", this.onClickEvent, {
      capture: true
    });
    this.registerEvent(this.app.vault.on("delete", this.markFileAsDeleted));
    this.registerEvent(this.app.workspace.on("file-open", this.handleFileOpen));
    this.addSettingTab(new NewTabPlusSettingsTab(this.app, this));
  }
  onunload() {
    this.resetVariables();
  }
  //#region settings
  async loadSettings() {
    const data = await this.loadData();
    this.settings = Object.assign({}, DEFAULT_SETTINGS, data);
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
  //#endregion
};
var NewTabPlusSettingsTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian.Setting(containerEl).setName("Check if file already open").setDesc("This will check if the file is already open among the tabs and will switch to it if it is.").addToggle(
      (bool) => bool.setValue(this.plugin.settings.CheckFileCurrentTabs).onChange(async (value) => {
        this.plugin.settings.CheckFileCurrentTabs = value;
        await this.plugin.saveSettings();
      })
    );
    new import_obsidian.Setting(containerEl).setName("Delay to execute (ms)").setDesc("Default value: 30. You might want to cramp it up a little if you experience misbehaviors").addSlider((slider) => {
      slider.setLimits(10, 100, 10);
      slider.setValue(this.plugin.settings.Delay).onChange(async (value) => {
        this.plugin.settings.Delay = value;
        await this.plugin.saveSettings();
      });
    });
  }
};

/* nosourcemap */