/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => Learning
});
module.exports = __toCommonJS(main_exports);
var import_obsidian3 = require("obsidian");

// src/Modals/PromptModal.ts
var import_obsidian = require("obsidian");
var PromptModal = class extends import_obsidian.Modal {
  constructor(app, notes) {
    super(app);
    this.resolveFn = null;
    this.notes = notes;
    this.docs = this.notes.flatMap((obj) => {
      const { id, title, tags, path } = obj;
      return tags == null ? void 0 : tags.map((tag) => ({
        id: `${id}-${tag}`,
        value: tag,
        titlePaths: { titles: this.notes.filter((o) => {
          var _a;
          return (_a = o.tags) == null ? void 0 : _a.includes(tag);
        }).map((o) => o.title), paths: this.notes.filter((o) => {
          var _a;
          return (_a = o.tags) == null ? void 0 : _a.includes(tag);
        }).map((o) => o.path) },
        titles: this.notes.filter((o) => {
          var _a;
          return (_a = o.tags) == null ? void 0 : _a.includes(tag);
        }).map((o) => o.title),
        paths: this.notes.filter((o) => {
          var _a;
          return (_a = o.tags) == null ? void 0 : _a.includes(tag);
        }).map((o) => o.path)
      }));
    });
    this.modalEl.addClass("memorizationModal");
  }
  calculateSuggestions(input) {
    const suggestions = [];
    this.docs.forEach((doc) => {
      const value = doc.value;
      const lowerCase = value.toLowerCase().substring(1);
      const upperCase = value.toUpperCase().substring(1);
      if ((lowerCase.contains(input) || upperCase.contains(input) || value.contains(input)) && !value.contains("MemorizationPlugin") && input !== "") {
        if (!suggestions.contains(value.toString())) {
          suggestions.push({ tag: value.toString(), titles: doc.titles, paths: doc.paths });
        }
      }
    });
    return suggestions;
  }
  async open() {
    return new Promise((resolve) => {
      this.resolveFn = resolve;
      super.open();
    });
  }
  async onOpen() {
    this.docs = this.docs.filter(
      (value, index, self) => index === self.findIndex((t) => t.value === value.value)
    );
    this.titleEl.createEl("h1", { text: "Search by tag" });
    const searchInput = this.contentEl.createEl("input", { type: "text", cls: "memorizationSearchInput" });
    const suggestionsContainer = this.contentEl.createEl("div", { cls: "memorizationSuggestionsContainer" });
    searchInput.addEventListener("input", async (e) => {
      var _a, _b;
      suggestionsContainer.textContent = "";
      const query = (_b = (_a = e.target) == null ? void 0 : _a.value) != null ? _b : "";
      const suggestions = this.calculateSuggestions(query);
      if (suggestions.length > 0) {
        suggestionsContainer.style.visibility = "visible";
      } else {
        suggestionsContainer.style.visibility = "hidden";
      }
      suggestions.forEach((suggestion) => {
        const item = suggestionsContainer.createEl("div", { cls: "memorizationItemLeave" });
        item.textContent = suggestion.tag;
        item.addEventListener("mouseenter", () => {
          item.className = "memorizationItemEnter";
        });
        item.addEventListener("mouseleave", () => {
          item.className = "memorizationItemLeave";
        });
        item.addEventListener("click", async () => {
          const filteredTitles = suggestion.titles.filter((str) => !str.includes("[Memorization-Plugin]"));
          suggestion.titles = await filteredTitles;
          const mergedArray = filteredTitles.map((value, index) => {
            return { title: value, path: suggestion.paths[index] };
          });
          suggestion.titlePaths = mergedArray;
          if (this.resolveFn) {
            this.resolveFn(suggestion);
            this.resolveFn = null;
            this.close();
          }
          this.app.workspace.onLayoutReady(() => {
            this.close();
          });
        });
      });
    });
  }
};

// src/StudyNote.ts
var import_obsidian2 = require("obsidian");
var DIRECTORYPATH = "./MemorizationPlugin/";
var PATH = "MemorizationPlugin/";
var StudyNote = class {
  constructor(app, title, path) {
    this.originalTitle = title;
    this.title = this.formatNewTitle(title);
    this.path = PATH + this.title;
    this.app = app;
    this.efScore = "2.5";
    this.interval = 0;
    this.repetition = "0";
    this.dateIntervalSet = "0";
    this.quality = "0";
  }
  formatNewTitle(title) {
    const words = title.split("/");
    const modifiedWords = words.map((word) => `[Memorization-Plugin]-${word}`);
    const resultString = modifiedWords.join("/");
    return resultString;
  }
  async createStudyNote() {
    const originalFile = this.app.vault.getAbstractFileByPath(this.originalTitle);
    if (!(originalFile instanceof import_obsidian2.TFile)) {
      return;
    }
    let content = await this.app.vault.read(originalFile);
    const formattedContent = content.replace(/[\r\n]+/g, "\n>");
    const finalFormattedContent = formattedContent.replace(/#\S+/g, "");
    content = "\n#MemorizationPlugin\n>[!INFO]- \n>" + finalFormattedContent;
    content += '\n\n\n\n<form id="learning_level">    <input type="radio" id="memorize-plugin-radio-option0" name="radioOptions" value="0">    <label for="memorize-plugin-radio-option0">0 - No clue.</label>    <br>    <input type="radio" id="memorize-plugin-radio-option1" name="radioOptions" value="1">    <label for="memorize-plugin-radio-option1">1 - You have the slightest clue.</label>    <br>    <input type="radio" id="memorize-plugin-radio-option2" name="radioOptions" value="2">    <label for="memorize-plugin-radio-option2">2 - You have some recollection of this note.</label>    <br>    <input type="radio" id="memorize-plugin-radio-option3" name="radioOptions" value="3">    <label for="memorize-plugin-radio-option3">3 - You remembered this note, but it was difficult.</label>    <br>    <input type="radio" id="memorize-plugin-radio-option4" name="radioOptions" value="4">    <label for="memorize-plugin-radio-option4">4 - You semi-confidently remembered this note.</label>    <br>    <input type="radio" id="memorize-plugin-radio-option5" name="radioOptions" value="5">    <label for="option5">5 - That was easy.</label>    </form><br /><br />    <input id="memorize-plugin-button" value="Next" type="button"/><br />     <label style="font-weight: bold; font-size: 16px;" for="memorize-plugin-button">Note: To study another tag or note, you must select a tag from the Memorization plugin search bar.</label>';
    const file = this.app.vault.getAbstractFileByPath(this.path);
    if (!file) {
      const regex = /\n?---[\s\S]*?---\n?|\n?>(?=#)/g;
      const updatedStr = content.replace(regex, "");
      const frontmatter = `
---
memorize-plugin-ef:${this.efScore}
memorize-plugin-score:0
memorize-plugin-current-date:${this.dateIntervalSet}
memorize-plugin-previous-date:${this.dateIntervalSet}
memorize-plugin-repetitions:${this.repetition}
memorize-plugin-interval:${this.interval}
---
`;
      const updatedContent = frontmatter + updatedStr;
      this.content = updatedContent;
      await this.initializeNotes(updatedContent);
      const file2 = this.app.vault.getAbstractFileByPath(this.path);
      if (file2) {
        file2.name = this.title;
      }
    } else {
      this.loadFile();
    }
  }
  async initializeNotes(updatedContent) {
    const results = this.path.split("/").reduce((result, directory) => {
      if (result.length === 0) {
        result.push(directory);
      } else {
        const lastDirectory = result[result.length - 1];
        result.push(`${lastDirectory}/${directory}`);
      }
      return result;
    }, []);
    for (let path of results) {
      if (path == "MemorizationPlugin") {
        const exists = await this.app.vault.adapter.exists("MemorizationPlugin");
        if (!exists) {
          await this.app.vault.createFolder(DIRECTORYPATH);
        }
      } else if (path.contains(".md")) {
        const file = await this.app.vault.create(path, updatedContent);
        await this.app.vault.modify(file, updatedContent);
      } else {
        const exists = await this.app.vault.adapter.exists((0, import_obsidian2.normalizePath)(path));
        if (!exists) {
          await this.app.vault.createFolder(path);
        }
      }
    }
  }
  deleteNote() {
    const file = this.app.vault.getAbstractFileByPath(this.path);
    this.app.vault.delete(file);
  }
  async loadFile() {
    const scoreRegex = /memorize-plugin-score:\s*(\d+)/;
    const curDateRegex = /memorize-plugin-current-date:(.*)/;
    const efRegex = /memorize-plugin-ef:\s*(\d+)/;
    const repetitionsRegex = /memorize-plugin-repetitions:(\d+)/;
    const intervalRegex = /memorize-plugin-interval:(\d+)/;
    const originalFile = this.app.vault.getAbstractFileByPath(this.path);
    this.content = await this.app.vault.read(originalFile);
    const contents = this.content;
    const match = contents.match(scoreRegex);
    const dateMatch = contents.match(curDateRegex);
    const efMatch = contents.match(efRegex);
    const repetitionsMatch = contents.match(repetitionsRegex);
    const intervalMatch = contents.match(intervalRegex);
    this.efScore = efMatch && efMatch[1];
    this.quality = match && match[1];
    const interval = intervalMatch && intervalMatch[1];
    this.interval = parseInt(interval);
    this.repetition = repetitionsMatch && repetitionsMatch[1];
    const noteDate = dateMatch && dateMatch[1];
    this.dateIntervalSet = noteDate;
    const dateIntervalSet = new Date(noteDate);
    const today = new Date();
    const difference = today.getTime() - dateIntervalSet.getTime();
    const diffInDays = Math.floor(difference / (1e3 * 60 * 60 * 24));
    if (diffInDays < 0) {
      this.interval = diffInDays;
    }
  }
  calculateSuperMemoEF() {
    const repetitions = parseInt(this.repetition, 10);
    const quality = parseInt(this.quality, 10);
    let ef = parseFloat(this.efScore);
    ef = parseFloat(ef.toFixed(1));
    if (quality >= 3) {
      if (repetitions === 0) {
        this.interval = 1;
      } else if (repetitions === 1) {
        this.interval = 6;
      } else if (repetitions > 1) {
        const i = Math.ceil(this.interval * ef);
        this.interval = i;
      }
      this.repetition = (repetitions + 1).toString();
      this.efScore = (ef + (0.1 - (5 - quality) * (0.08 + (5 - quality) * 0.02))).toFixed(1);
    } else {
      this.repetition = "0";
      this.interval = 1;
    }
    if (ef < 1.3) {
      this.efScore = "1.3";
    }
  }
  updateNoteText() {
    const activeView = this.app.workspace.getActiveViewOfType(import_obsidian2.MarkdownView);
    if (activeView) {
      const file = activeView.file;
      const abstractFile = this.app.vault.getAbstractFileByPath(this.title);
      this.calculateSuperMemoEF();
      const regex = /\n?---[\s\S]*?---\n?|\n?>(?=#)/g;
      const finalContent = this.content.replace(regex, `
---
memorize-plugin-ef:${this.efScore}
memorize-plugin-score:${this.quality}
memorize-plugin-current-date:${this.dateIntervalSet}
memorize-plugin-previous-date:${this.dateIntervalSet}
memorize-plugin-repetitions:${this.repetition}
memorize-plugin-interval:${this.interval}
---
`);
      this.content = finalContent;
      if (file) {
        this.app.vault.modify(file, finalContent);
      } else {
        this.app.vault.modify(abstractFile, finalContent);
      }
    }
  }
  setQuality(quality) {
    this.quality = quality;
    this.dateIntervalSet = new Date().toISOString();
  }
  async display(createTabs) {
    await this.app.workspace.openLinkText(this.path, this.path, createTabs, { state: { mode: "preview" } });
    const activeView = this.app.workspace.getActiveViewOfType(import_obsidian2.MarkdownView);
    if (activeView) {
      const viewState = activeView.getState();
      viewState.mode = "preview";
      activeView.setState(viewState, {});
    }
  }
};

// main.ts
var DEFAULT_SETTINGS = {
  deleteNotes: false,
  createTabs: true
};
var Learning = class extends import_obsidian3.Plugin {
  async onload() {
    console.log("loading plugin - Memorization");
    await this.loadSettings();
    this.currentLearningNoteIndex = 0;
    this.notes = [];
    this.studyNotes = [];
    this.addRibbonIcon("brain-cog", "Memorize Notes", async () => {
      await this.startStudy();
    });
    this.addCommand({
      id: "PromptModal",
      name: "Study tag",
      checkCallback: (checking) => {
        if (!checking) {
          (async () => {
            await this.startStudy();
          })();
        }
        return true;
      }
    });
    this.addSettingTab(new MemorizeSettingTab(this.app, this));
    this.registerDomEvent(document, "click", async (evt) => {
      const element = evt.composedPath()[0];
      if (element.id.contains("memorize-plugin-radio")) {
        this.currentLearningNote.setQuality(element.value);
      } else if (element.id.contains("memorize-plugin-button")) {
        const activeView = this.app.workspace.getActiveViewOfType(import_obsidian3.MarkdownView);
        if (activeView) {
          this.deleteOrUpdateNote();
          this.goToNextNote();
        }
      }
    });
  }
  deleteOrUpdateNote() {
    if (this.settings.deleteNotes) {
      if (this.currentLearningNote) {
        this.currentLearningNote.deleteNote();
        this.studyNotes.remove(this.currentLearningNote);
        this.currentLearningNoteIndex -= 1;
      }
    } else {
      if (this.currentLearningNote) {
        this.currentLearningNote.updateNoteText();
      }
    }
  }
  goToNextNote() {
    const nextIndex = this.currentLearningNoteIndex + 1;
    if (nextIndex < this.studyNotes.length) {
      this.currentLearningNoteIndex = nextIndex;
      this.currentLearningNote = this.studyNotes[nextIndex];
      if (this.currentLearningNote) {
        this.currentLearningNote.display(this.settings.createTabs);
      }
    } else {
      this.currentLearningNoteIndex = 0;
      this.studyNotes = this.studyNotes.sort((a, b) => a.interval - b.interval);
      this.currentLearningNote = this.studyNotes[this.currentLearningNoteIndex];
      if (this.currentLearningNote) {
        this.currentLearningNote.display(this.settings.createTabs);
      }
    }
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
  async startStudy() {
    const files = this.app.vault.getMarkdownFiles();
    let notes = [];
    let i = 0;
    files.forEach((file) => {
      const cache = this.app.metadataCache.getCache(file.path);
      const tags = (0, import_obsidian3.getAllTags)(cache);
      notes.push({ id: i, tags, title: file.path, path: this.app.vault.getResourcePath(file) });
      i++;
    });
    this.notes = notes;
    this.suggestionResults = await new PromptModal(this.app, this.notes).open();
    const p = this.suggestionResults.titlePaths[0].path;
    const s = (0, import_obsidian3.normalizePath)(p);
    this.studyNotes = [];
    for (const titlePath of this.suggestionResults.titlePaths) {
      const studyNote = new StudyNote(this.app, titlePath.title, (0, import_obsidian3.normalizePath)(titlePath.path));
      await studyNote.createStudyNote();
      this.studyNotes.push(studyNote);
    }
    this.studyNotes = this.studyNotes.sort((a, b) => a.interval - b.interval);
    this.currentLearningNote = this.studyNotes[this.currentLearningNoteIndex];
    this.studyNotes[this.currentLearningNoteIndex].display(this.settings.createTabs);
  }
};
var MemorizeSettingTab = class extends import_obsidian3.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "General Settings" });
    new import_obsidian3.Setting(containerEl).setName("Delete memorization notes after creation").setDesc("Note: this will disable the spaced repetition feature.").addToggle((toggle) => toggle.setValue(this.plugin.settings.deleteNotes).onChange(async (value) => {
      this.plugin.settings.deleteNotes = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian3.Setting(containerEl).setName("Enable creation of new tabs").setDesc("By default, when you go to the next note in the sequence, a new tab is not created. Enable this if you'd like a new tab created.").addToggle((toggle) => toggle.setValue(this.plugin.settings.createTabs).onChange(async (value) => {
      this.plugin.settings.createTabs = value;
      await this.plugin.saveSettings();
    }));
    containerEl.createEl("h2", { text: "About" });
    containerEl.createEl("a", { text: "Memorization", href: "https://github.com/nwindian/Memorization-Plugin" });
  }
};
//# sourceMappingURL=data:application/json;base64,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
