/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

'use strict';

var obsidian = require('obsidian');

const LINKED_TO = " => ";
const LINKED_FROM = " <= ";
const LINKED_CN = "None";
const LINKED_BOTH = " <=> ";
const MOC_VIEW_TYPE = "map-of-content";

const devLog = (message) => {
};
const removeExtension = (path, extension = ".md") => {
    if (path.endsWith(extension)) {
        return path.slice(0, -extension.length);
    }
    return path;
};
/**@returns True if CTRL / Meta is pressed */
const isCtrlPressed = (e) => {
    return window.navigator.userAgent.includes("Macintosh")
        ? e.metaKey
        : e.ctrlKey;
};
/**  Returns only the name of the actual file  */
const getFileNameFromPath = (path) => {
    return path.split("/").last();
};
/**  return the full path if there are two or more notes with the same filename and extension, else only the filename  */
const getDisplayName = (path, db) => {
    const fileName = getFileNameFromPath(path);
    if (db.fileHasDuplicatedName.get(fileName) === true) {
        return removeExtension(path);
    }
    return removeExtension(fileName);
};
const NavigateToFile = async (app, path, event) => {
    if (!app.metadataCache.getFirstLinkpathDest(path, "/"))
        return;
    app.workspace.openLinkText(path, "/", isCtrlPressed(event));
};
/** Get the paths of all folders in the vault, empty or not */
const GetAllFolders = (app) => {
    const allFolderPaths = [];
    app.vault.getFiles().forEach((file) => {
        // cut of filename
        const folderPath = file.path.slice(0, file.path.length - (file.basename.length + file.extension.length + 1));
        // add path to collected paths
        if (folderPath.length && !allFolderPaths.contains(folderPath)) {
            allFolderPaths.push(folderPath);
        }
    });
    // store all parent folder paths as unique paths if they aren't yet because they don't include any notes directly
    allFolderPaths.forEach((path) => {
        const allSubPaths = path.split("/");
        for (let i = 1; i < allSubPaths.length - 1; i++) {
            const partialPath = allSubPaths.slice(0, i).join("/") + "/";
            if (!allFolderPaths.contains(partialPath)) {
                allFolderPaths.push(partialPath);
            }
        }
    });
    return allFolderPaths;
};

class DBManager {
    constructor(plugin) {
        this.db = {};
        this.allPaths = [];
        this.isDatabaseComplete = false;
        this.isDatabaseUpdating = true;
        this.app = plugin.app;
        this.plugin = plugin;
        this.settings = plugin.settings;
        this.dbEntries = Object.entries(this.db);
    }
    async update(silent = false) {
        this.isDatabaseComplete = false;
        this.isDatabaseUpdating = true;
        try {
            if (this.plugin.CNexists()) {
                let startTime = Date.now();
                if (!silent) {
                    new obsidian.Notice("Updating the Map of Content...");
                }
                devLog("Updating the Map of Content...");
                await new Promise((r) => setTimeout(r, 0));
                this.updateDB();
                await new Promise((r) => setTimeout(r, 0));
                this.timesGetPathRan = 0;
                this.updateDepthInformation();
                this.allPaths.length = 0;
                let pathSoFar = {
                    allMembers: [this.settings.get("CN_path")],
                    items: [[this.settings.get("CN_path"), LINKED_CN]],
                };
                await new Promise((r) => setTimeout(r, 0));
                this.followPaths(pathSoFar);
                await new Promise((r) => setTimeout(r, 0));
                this.updateDescendants();
                if (!silent) {
                    new obsidian.Notice("Update complete");
                }
                devLog(`Update complete, took ${String((Date.now() - startTime) / 1000)} seconds`);
                devLog(`get paths ran ${this.timesGetPathRan} times`);
                this.isDatabaseComplete = true;
            }
        }
        finally {
            this.isDatabaseUpdating = false;
            this.plugin.rerender();
        }
    }
    getNoteFromPath(path) {
        var _a;
        return (_a = this.db) === null || _a === void 0 ? void 0 : _a[path];
    }
    /** return all paths that include a certain note. Only return the path up to that note*/
    findPaths(path) {
        let filteredPaths = [];
        let filteredPathsAsJson = JSON.stringify(filteredPaths);
        this.allPaths.forEach((p) => {
            if (p.allMembers.includes(path)) {
                if (p.allMembers.last() === path) {
                    filteredPaths.push(p);
                }
                else {
                    let index = p.allMembers.indexOf(path) + 1;
                    let choppedOffPath = p.items.slice(0, index);
                    if (!filteredPathsAsJson.includes(JSON.stringify(choppedOffPath))) {
                        // return a path element containing only the parts of the path information up to the note in question
                        filteredPaths.push({
                            allMembers: p.allMembers.slice(0, index),
                            items: p.items.slice(0, index),
                        });
                        filteredPathsAsJson = JSON.stringify(filteredPaths);
                    }
                }
            }
        });
        return filteredPaths;
    }
    allNotes() {
        return this.dbEntries.map(([key, value]) => value);
    }
    updateDB() {
        // TODO - this is a hacky way to clear the db, find a better way - why is this necessary?
        for (let note in this.db) {
            delete this.db[note];
        }
        let vaultFiles = this.app.vault.getFiles();
        devLog(`Total number of files in vault: ${vaultFiles.length}`);
        vaultFiles.forEach((file) => {
            if (this.settings.isExcludedFile(file)) {
                return;
            }
            this.db[file.path] = {
                path: file.path,
                extension: file.extension,
                linksTo: new Set(),
                linkedFrom: new Set(),
                distanceFromCn: null,
            };
        });
        this.dbEntries = Object.entries(this.db);
        this.dbKeys = Object.keys(this.db);
        this.fileHasDuplicatedName = new Map();
        this.allNotes().forEach((note) => {
            let fileName = getFileNameFromPath(note.path);
            // TODO use something like a counter here that just counts up the occurrences of each file name
            if (this.fileHasDuplicatedName.has(fileName)) {
                // If the file name is encountered twice or more, set it's duplicate status to true
                this.fileHasDuplicatedName.set(fileName, true);
            }
            else {
                this.fileHasDuplicatedName.set(fileName, false);
            }
        });
        this.dbEntries = Object.entries(this.db);
        const markdownNotes = this.allNotes().filter((note) => note.extension === "md");
        markdownNotes.forEach((note) => {
            let linksFromNote = this.getValidatedLinksFromNote(note.path, note.path);
            this.db[note.path].linksTo = linksFromNote;
            linksFromNote.forEach((link) => {
                if (!this.db[link]) {
                    return;
                }
                if (!this.db[link].linkedFrom.has(note.path)) {
                    this.db[link].linkedFrom.add(note.path);
                }
            });
        });
    }
    /** starting from the CN, follow all paths and store the information on how long the shortest path to each note is*/
    updateDepthInformation() {
        devLog("Analyzing distance from Central Note. CN path: " +
            this.settings.get("CN_path"));
        let distanceFromCn = 1;
        let previouslyCheckedLinks = []; // all the notes that have already been visited. dont visit them again to prevent endless loops
        let links = [this.settings.get("CN_path")];
        while (links.length > 0) {
            let nextLoopsLinks = new Set();
            links.forEach((link) => {
                let note = this.getNoteFromPath(link);
                if (!note) {
                    return;
                }
                [...note.linksTo, ...note.linkedFrom].forEach((link) => {
                    if (!previouslyCheckedLinks.contains(link)) {
                        nextLoopsLinks.add(link);
                    }
                });
                if (note.distanceFromCn == null ||
                    note.distanceFromCn > distanceFromCn) {
                    note.distanceFromCn = distanceFromCn;
                }
                previouslyCheckedLinks.push(link);
            });
            links = Array.from(nextLoopsLinks);
            distanceFromCn += 1;
        }
    }
    /**
     * Recursive function that follows all possible paths from the CN that aren't unreasonably long or circular and stores them
     * @param basePath the path to be extended in this iteration
     */
    followPaths(basePath) {
        this.timesGetPathRan += 1;
        const note = this.db[basePath.allMembers.last()];
        if (!note) {
            return;
        }
        const newPathsToFollow = [];
        const notesLinkingToThisNoteToFollow = new Set(note.linkedFrom);
        note.linksTo.forEach((link) => {
            if (basePath.allMembers.includes(link)) {
                return;
            }
            let linkDirectionToken = LINKED_TO;
            if (notesLinkingToThisNoteToFollow.has(link)) {
                notesLinkingToThisNoteToFollow.delete(link);
                linkDirectionToken = LINKED_BOTH;
            }
            newPathsToFollow.push({
                allMembers: basePath.allMembers.concat(link),
                items: basePath.items.concat([[link, linkDirectionToken]]),
            });
        });
        notesLinkingToThisNoteToFollow.forEach((link) => {
            if (basePath.allMembers.includes(link)) {
                return;
            }
            newPathsToFollow.push({
                allMembers: basePath.allMembers.concat(link),
                items: basePath.items.concat([[link, LINKED_FROM]]),
            });
        });
        let pathHasNovelChildPath = false;
        newPathsToFollow.forEach((newPath) => {
            // prevent meandering paths that are longer than the shortest path to the note
            if (newPath.allMembers.length >
                this.getNoteFromPath(newPath.allMembers.last()).distanceFromCn) {
                return;
            }
            this.followPaths(newPath);
            pathHasNovelChildPath = true;
        });
        if (pathHasNovelChildPath) {
            return;
        }
        this.allPaths.push(basePath);
    }
    /** for every note, store all notes that come right after it in any path. this is for displaying the tree view */
    updateDescendants() {
        this.descendants = new Map();
        this.allPaths.forEach((path) => {
            path.allMembers
                .slice(0, -1)
                .forEach((notePath, index) => {
                if (!this.descendants.has(notePath)) {
                    this.descendants.set(notePath, new Set([path.allMembers[index + 1]]));
                    return;
                }
                this.descendants.get(notePath).add(path.allMembers[index + 1]);
            });
        });
    }
    getValidatedLinkPath(link, notePath) {
        const linkWithoutAnchor = link.split("#")[0].split("^")[0];
        const linkDestination = this.app.metadataCache.getFirstLinkpathDest(linkWithoutAnchor, notePath);
        if (!linkDestination) {
            return;
        }
        if (this.dbKeys && !this.dbKeys.contains(linkDestination.path)) {
            // TODO why is this called before dbKeys is set?
            return null;
        }
        return linkDestination.path;
    }
    getValidatedLinksFromNote(notePath, sourcePath) {
        var _a, _b, _c;
        const cachedMetadata = this.app.metadataCache.getCache(notePath);
        const linkCaches = [
            ...((_a = cachedMetadata.links) !== null && _a !== void 0 ? _a : []),
            ...((_b = cachedMetadata.embeds) !== null && _b !== void 0 ? _b : []),
            ...((_c = cachedMetadata.frontmatterLinks) !== null && _c !== void 0 ? _c : []),
        ];
        const validatedLinks = new Set();
        for (const linkCache of linkCaches) {
            const validatedLink = this.getValidatedLinkPath(linkCache.link, sourcePath);
            if (!validatedLink) {
                continue;
            }
            validatedLinks.add(validatedLink);
        }
        return validatedLinks;
    }
}

function noop() { }
function run(fn) {
    return fn();
}
function blank_object() {
    return Object.create(null);
}
function run_all(fns) {
    fns.forEach(run);
}
function is_function(thing) {
    return typeof thing === 'function';
}
function safe_not_equal(a, b) {
    return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}
function is_empty(obj) {
    return Object.keys(obj).length === 0;
}
function null_to_empty(value) {
    return value == null ? '' : value;
}
function append(target, node) {
    target.appendChild(node);
}
function append_styles(target, style_sheet_id, styles) {
    const append_styles_to = get_root_for_style(target);
    if (!append_styles_to.getElementById(style_sheet_id)) {
        const style = element('style');
        style.id = style_sheet_id;
        style.textContent = styles;
        append_stylesheet(append_styles_to, style);
    }
}
function get_root_for_style(node) {
    if (!node)
        return document;
    const root = node.getRootNode ? node.getRootNode() : node.ownerDocument;
    if (root && root.host) {
        return root;
    }
    return node.ownerDocument;
}
function append_stylesheet(node, style) {
    append(node.head || node, style);
    return style.sheet;
}
function insert(target, node, anchor) {
    target.insertBefore(node, anchor || null);
}
function detach(node) {
    if (node.parentNode) {
        node.parentNode.removeChild(node);
    }
}
function destroy_each(iterations, detaching) {
    for (let i = 0; i < iterations.length; i += 1) {
        if (iterations[i])
            iterations[i].d(detaching);
    }
}
function element(name) {
    return document.createElement(name);
}
function svg_element(name) {
    return document.createElementNS('http://www.w3.org/2000/svg', name);
}
function text(data) {
    return document.createTextNode(data);
}
function space() {
    return text(' ');
}
function empty() {
    return text('');
}
function listen(node, event, handler, options) {
    node.addEventListener(event, handler, options);
    return () => node.removeEventListener(event, handler, options);
}
function attr(node, attribute, value) {
    if (value == null)
        node.removeAttribute(attribute);
    else if (node.getAttribute(attribute) !== value)
        node.setAttribute(attribute, value);
}
function children(element) {
    return Array.from(element.childNodes);
}
function set_data(text, data) {
    data = '' + data;
    if (text.data === data)
        return;
    text.data = data;
}
function set_input_value(input, value) {
    input.value = value == null ? '' : value;
}
function set_style(node, key, value, important) {
    if (value == null) {
        node.style.removeProperty(key);
    }
    else {
        node.style.setProperty(key, value, important ? 'important' : '');
    }
}
function toggle_class(element, name, toggle) {
    element.classList[toggle ? 'add' : 'remove'](name);
}

let current_component;
function set_current_component(component) {
    current_component = component;
}
function get_current_component() {
    if (!current_component)
        throw new Error('Function called outside component initialization');
    return current_component;
}
/**
 * The `onMount` function schedules a callback to run as soon as the component has been mounted to the DOM.
 * It must be called during the component's initialisation (but doesn't need to live *inside* the component;
 * it can be called from an external module).
 *
 * `onMount` does not run inside a [server-side component](/docs#run-time-server-side-component-api).
 *
 * https://svelte.dev/docs#run-time-svelte-onmount
 */
function onMount(fn) {
    get_current_component().$$.on_mount.push(fn);
}

const dirty_components = [];
const binding_callbacks = [];
let render_callbacks = [];
const flush_callbacks = [];
const resolved_promise = /* @__PURE__ */ Promise.resolve();
let update_scheduled = false;
function schedule_update() {
    if (!update_scheduled) {
        update_scheduled = true;
        resolved_promise.then(flush);
    }
}
function add_render_callback(fn) {
    render_callbacks.push(fn);
}
// flush() calls callbacks in this order:
// 1. All beforeUpdate callbacks, in order: parents before children
// 2. All bind:this callbacks, in reverse order: children before parents.
// 3. All afterUpdate callbacks, in order: parents before children. EXCEPT
//    for afterUpdates called during the initial onMount, which are called in
//    reverse order: children before parents.
// Since callbacks might update component values, which could trigger another
// call to flush(), the following steps guard against this:
// 1. During beforeUpdate, any updated components will be added to the
//    dirty_components array and will cause a reentrant call to flush(). Because
//    the flush index is kept outside the function, the reentrant call will pick
//    up where the earlier call left off and go through all dirty components. The
//    current_component value is saved and restored so that the reentrant call will
//    not interfere with the "parent" flush() call.
// 2. bind:this callbacks cannot trigger new flush() calls.
// 3. During afterUpdate, any updated components will NOT have their afterUpdate
//    callback called a second time; the seen_callbacks set, outside the flush()
//    function, guarantees this behavior.
const seen_callbacks = new Set();
let flushidx = 0; // Do *not* move this inside the flush() function
function flush() {
    // Do not reenter flush while dirty components are updated, as this can
    // result in an infinite loop. Instead, let the inner flush handle it.
    // Reentrancy is ok afterwards for bindings etc.
    if (flushidx !== 0) {
        return;
    }
    const saved_component = current_component;
    do {
        // first, call beforeUpdate functions
        // and update components
        try {
            while (flushidx < dirty_components.length) {
                const component = dirty_components[flushidx];
                flushidx++;
                set_current_component(component);
                update(component.$$);
            }
        }
        catch (e) {
            // reset dirty state to not end up in a deadlocked state and then rethrow
            dirty_components.length = 0;
            flushidx = 0;
            throw e;
        }
        set_current_component(null);
        dirty_components.length = 0;
        flushidx = 0;
        while (binding_callbacks.length)
            binding_callbacks.pop()();
        // then, once components are updated, call
        // afterUpdate functions. This may cause
        // subsequent updates...
        for (let i = 0; i < render_callbacks.length; i += 1) {
            const callback = render_callbacks[i];
            if (!seen_callbacks.has(callback)) {
                // ...so guard against infinite loops
                seen_callbacks.add(callback);
                callback();
            }
        }
        render_callbacks.length = 0;
    } while (dirty_components.length);
    while (flush_callbacks.length) {
        flush_callbacks.pop()();
    }
    update_scheduled = false;
    seen_callbacks.clear();
    set_current_component(saved_component);
}
function update($$) {
    if ($$.fragment !== null) {
        $$.update();
        run_all($$.before_update);
        const dirty = $$.dirty;
        $$.dirty = [-1];
        $$.fragment && $$.fragment.p($$.ctx, dirty);
        $$.after_update.forEach(add_render_callback);
    }
}
/**
 * Useful for example to execute remaining `afterUpdate` callbacks before executing `destroy`.
 */
function flush_render_callbacks(fns) {
    const filtered = [];
    const targets = [];
    render_callbacks.forEach((c) => fns.indexOf(c) === -1 ? filtered.push(c) : targets.push(c));
    targets.forEach((c) => c());
    render_callbacks = filtered;
}
const outroing = new Set();
let outros;
function group_outros() {
    outros = {
        r: 0,
        c: [],
        p: outros // parent group
    };
}
function check_outros() {
    if (!outros.r) {
        run_all(outros.c);
    }
    outros = outros.p;
}
function transition_in(block, local) {
    if (block && block.i) {
        outroing.delete(block);
        block.i(local);
    }
}
function transition_out(block, local, detach, callback) {
    if (block && block.o) {
        if (outroing.has(block))
            return;
        outroing.add(block);
        outros.c.push(() => {
            outroing.delete(block);
            if (callback) {
                if (detach)
                    block.d(1);
                callback();
            }
        });
        block.o(local);
    }
    else if (callback) {
        callback();
    }
}
function create_component(block) {
    block && block.c();
}
function mount_component(component, target, anchor, customElement) {
    const { fragment, after_update } = component.$$;
    fragment && fragment.m(target, anchor);
    if (!customElement) {
        // onMount happens before the initial afterUpdate
        add_render_callback(() => {
            const new_on_destroy = component.$$.on_mount.map(run).filter(is_function);
            // if the component was destroyed immediately
            // it will update the `$$.on_destroy` reference to `null`.
            // the destructured on_destroy may still reference to the old array
            if (component.$$.on_destroy) {
                component.$$.on_destroy.push(...new_on_destroy);
            }
            else {
                // Edge case - component was destroyed immediately,
                // most likely as a result of a binding initialising
                run_all(new_on_destroy);
            }
            component.$$.on_mount = [];
        });
    }
    after_update.forEach(add_render_callback);
}
function destroy_component(component, detaching) {
    const $$ = component.$$;
    if ($$.fragment !== null) {
        flush_render_callbacks($$.after_update);
        run_all($$.on_destroy);
        $$.fragment && $$.fragment.d(detaching);
        // TODO null out other refs, including component.$$ (but need to
        // preserve final state?)
        $$.on_destroy = $$.fragment = null;
        $$.ctx = [];
    }
}
function make_dirty(component, i) {
    if (component.$$.dirty[0] === -1) {
        dirty_components.push(component);
        schedule_update();
        component.$$.dirty.fill(0);
    }
    component.$$.dirty[(i / 31) | 0] |= (1 << (i % 31));
}
function init(component, options, instance, create_fragment, not_equal, props, append_styles, dirty = [-1]) {
    const parent_component = current_component;
    set_current_component(component);
    const $$ = component.$$ = {
        fragment: null,
        ctx: [],
        // state
        props,
        update: noop,
        not_equal,
        bound: blank_object(),
        // lifecycle
        on_mount: [],
        on_destroy: [],
        on_disconnect: [],
        before_update: [],
        after_update: [],
        context: new Map(options.context || (parent_component ? parent_component.$$.context : [])),
        // everything else
        callbacks: blank_object(),
        dirty,
        skip_bound: false,
        root: options.target || parent_component.$$.root
    };
    append_styles && append_styles($$.root);
    let ready = false;
    $$.ctx = instance
        ? instance(component, options.props || {}, (i, ret, ...rest) => {
            const value = rest.length ? rest[0] : ret;
            if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {
                if (!$$.skip_bound && $$.bound[i])
                    $$.bound[i](value);
                if (ready)
                    make_dirty(component, i);
            }
            return ret;
        })
        : [];
    $$.update();
    ready = true;
    run_all($$.before_update);
    // `false` as a special case of no DOM component
    $$.fragment = create_fragment ? create_fragment($$.ctx) : false;
    if (options.target) {
        if (options.hydrate) {
            const nodes = children(options.target);
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            $$.fragment && $$.fragment.l(nodes);
            nodes.forEach(detach);
        }
        else {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            $$.fragment && $$.fragment.c();
        }
        if (options.intro)
            transition_in(component.$$.fragment);
        mount_component(component, options.target, options.anchor, options.customElement);
        flush();
    }
    set_current_component(parent_component);
}
/**
 * Base class for Svelte components. Used when dev=false.
 */
class SvelteComponent {
    $destroy() {
        destroy_component(this, 1);
        this.$destroy = noop;
    }
    $on(type, callback) {
        if (!is_function(callback)) {
            return noop;
        }
        const callbacks = (this.$$.callbacks[type] || (this.$$.callbacks[type] = []));
        callbacks.push(callback);
        return () => {
            const index = callbacks.indexOf(callback);
            if (index !== -1)
                callbacks.splice(index, 1);
        };
    }
    $set($$props) {
        if (this.$$set && !is_empty($$props)) {
            this.$$.skip_bound = true;
            this.$$set($$props);
            this.$$.skip_bound = false;
        }
    }
}

/* src/svelte/NoLinkImage.svelte generated by Svelte v3.59.2 */

function add_css$6(target) {
	append_styles(target, "svelte-7xk711", "div#broken-link-container.svelte-7xk711{position:fixed;bottom:5%;width:100%;height:25%;max-height:200px;align-content:center}svg.svelte-7xk711{display:block;width:100%;height:100%;opacity:60%;position:relative;margin-left:auto;margin-right:auto}");
}

function create_fragment$6(ctx) {
	let div;

	return {
		c() {
			div = element("div");

			div.innerHTML = `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" class="svelte-7xk711"><g><path style="fill:#B3404A;" d="M383.112,223.342c-3.162,0-6.347-1.034-9.008-3.162c-6.227-4.981-7.238-14.067-2.257-20.294
		l23.098-28.877c4.982-6.226,14.067-7.238,20.294-2.257c6.227,4.981,7.238,14.067,2.257,20.294l-23.098,28.877
		C391.545,221.487,387.348,223.342,383.112,223.342z"></path><path style="fill:#B3404A;" d="M435.095,270.439h-37.537c-7.973,0-14.438-6.465-14.438-14.438c0-7.973,6.465-14.438,14.438-14.438
		h37.537c7.973,0,14.438,6.465,14.438,14.438C449.533,263.973,443.069,270.439,435.095,270.439z"></path><path style="fill:#B3404A;" d="M406.229,346.41c-4.237,0-8.433-1.854-11.285-5.42l-23.098-28.877
		c-4.98-6.227-3.97-15.311,2.257-20.294c6.228-4.98,15.313-3.969,20.294,2.257l23.098,28.877c4.98,6.227,3.97,15.311-2.257,20.294
		C412.576,345.376,409.393,346.41,406.229,346.41z"></path><path style="fill:#B3404A;" d="M128.887,223.342c-4.237,0-8.433-1.854-11.285-5.42l-23.098-28.877
		c-4.98-6.227-3.97-15.311,2.257-20.294c6.228-4.981,15.311-3.97,20.294,2.257l23.098,28.877c4.98,6.227,3.97,15.311-2.257,20.294
		C135.232,222.31,132.049,223.342,128.887,223.342z"></path><path style="fill:#B3404A;" d="M114.44,270.439H76.904c-7.973,0-14.438-6.465-14.438-14.438c0-7.973,6.465-14.438,14.438-14.438
		h37.537c7.973,0,14.438,6.465,14.438,14.438C128.878,263.973,122.413,270.439,114.44,270.439z"></path><path style="fill:#B3404A;" d="M105.769,346.41c-3.162,0-6.347-1.034-9.008-3.162c-6.227-4.981-7.238-14.067-2.257-20.294
		l23.098-28.877c4.982-6.226,14.067-7.236,20.294-2.257c6.227,4.981,7.238,14.067,2.257,20.294l-23.098,28.877
		C114.202,344.553,110.004,346.41,105.769,346.41z"></path><path style="fill:#B3404A;" d="M471.123,176.32c-7.973,0-14.438-6.465-14.438-14.438v-53.826c0-29.082-23.661-52.741-52.741-52.741
		h-24.949c-7.973,0-14.438-6.465-14.438-14.438s6.465-14.438,14.438-14.438h24.949c45.004,0,81.617,36.613,81.617,81.617v53.826
		C485.561,169.855,479.096,176.32,471.123,176.32z"></path><path style="fill:#B3404A;" d="M40.877,176.32c-7.973,0-14.438-6.465-14.438-14.438v-53.826c0-45.004,36.613-81.617,81.617-81.617
		h24.948c7.973,0,14.438,6.465,14.438,14.438s-6.465,14.438-14.438,14.438h-24.948c-29.082,0-52.741,23.661-52.741,52.741v53.826
		C55.315,169.855,48.85,176.32,40.877,176.32z"></path><path style="fill:#B3404A;" d="M403.943,485.561h-24.948c-7.973,0-14.438-6.465-14.438-14.438c0-7.973,6.465-14.438,14.438-14.438
		h24.948c29.082,0,52.741-23.661,52.741-52.741v-53.826c0-7.973,6.465-14.438,14.438-14.438c7.973,0,14.438,6.465,14.438,14.438
		v53.826C485.561,448.947,448.947,485.561,403.943,485.561z"></path><path style="fill:#B3404A;" d="M133.005,485.561h-24.948c-45.004,0-81.617-36.613-81.617-81.617v-53.826
		c0-7.973,6.465-14.438,14.438-14.438s14.438,6.465,14.438,14.438v53.826c0,29.082,23.661,52.741,52.741,52.741h24.948
		c7.973,0,14.438,6.465,14.438,14.438C147.442,479.096,140.979,485.561,133.005,485.561z"></path></g><path style="fill:#EBAFAE;" d="M202.039,208.49c12.894,0,23.349-10.453,23.349-23.349V91.748c0-16.593,14.019-30.612,30.612-30.612
	c16.593,0,30.612,14.019,30.612,30.612v93.395c0,12.894,10.453,23.349,23.349,23.349l0,0c12.894,0,23.349-10.453,23.349-23.349
	V91.748c0-42.521-34.789-77.31-77.31-77.31l0,0c-42.521,0-77.31,34.789-77.31,77.31v93.395
	C178.69,198.037,189.143,208.49,202.039,208.49L202.039,208.49z"></path><path style="fill:#B1404A;" d="M309.961,222.928c-20.837,0-37.787-16.95-37.787-37.787V91.748c0-8.616-7.558-16.175-16.175-16.175
	c-8.616,0-16.175,7.558-16.175,16.175v93.395c0,20.837-16.95,37.787-37.787,37.787s-37.787-16.95-37.787-37.787V91.748
	C164.252,41.158,205.409,0,256,0s91.748,41.158,91.748,91.748v93.395C347.746,205.978,330.796,222.928,309.961,222.928z M256,46.698
	c24.42,0,45.05,20.63,45.05,45.05v93.395c0,4.913,3.998,8.911,8.911,8.911s8.911-3.998,8.911-8.911V91.748
	c0-34.668-28.204-62.872-62.872-62.872c-34.668,0-62.872,28.204-62.872,62.872v93.395c0,4.913,3.998,8.911,8.911,8.911
	s8.911-3.998,8.911-8.911V91.748C210.948,67.328,231.578,46.698,256,46.698z"></path><path style="fill:#EBAFAE;" d="M309.96,303.51c-12.894,0-23.349,10.453-23.349,23.349v93.395c0,16.593-14.019,30.612-30.612,30.612
	c-16.593,0-30.612-14.019-30.612-30.612v-93.395c0-12.894-10.453-23.349-23.349-23.349l0,0c-12.894,0-23.349,10.453-23.349,23.349
	v93.395c0,42.521,34.789,77.31,77.31,77.31l0,0c42.521,0,77.31-34.789,77.31-77.31v-93.395
	C333.309,313.963,322.856,303.51,309.96,303.51L309.96,303.51z"></path><path style="fill:#B1404A;" d="M256,512c-50.59,0-91.748-41.158-91.748-91.748v-93.395c0-20.837,16.95-37.787,37.787-37.787
	s37.787,16.95,37.787,37.787v93.395c0,8.616,7.558,16.175,16.175,16.175c8.616,0,16.175-7.558,16.175-16.175v-93.395
	c0-20.837,16.95-37.787,37.787-37.787s37.787,16.95,37.787,37.787v93.395C347.746,470.842,306.59,512,256,512z M202.039,317.947
	c-4.913,0-8.911,3.998-8.911,8.911v93.395c0,34.668,28.204,62.872,62.872,62.872c34.668,0,62.872-28.204,62.872-62.872v-93.395
	c0-4.913-3.998-8.911-8.911-8.911s-8.911,3.998-8.911,8.911v93.395c0,24.42-20.63,45.05-45.05,45.05s-45.05-20.63-45.05-45.05
	v-93.395C210.948,321.944,206.952,317.947,202.039,317.947z"></path></svg>`;

			attr(div, "id", "broken-link-container");
			attr(div, "class", "svelte-7xk711");
		},
		m(target, anchor) {
			insert(target, div, anchor);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

class NoLinkImage extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$6, safe_not_equal, {}, add_css$6);
	}
}

/* src/svelte/Descendants.svelte generated by Svelte v3.59.2 */

function add_css$5(target) {
	append_styles(target, "svelte-buml4", "a.link.svelte-buml4.svelte-buml4{cursor:pointer;text-decoration:none}ul.svelte-buml4.svelte-buml4{list-style:none;margin:0;padding:0}li.svelte-buml4.svelte-buml4{list-style:none;margin:0;padding:0}ul.svelte-buml4.svelte-buml4{padding-left:1em}li.svelte-buml4.svelte-buml4{padding-left:1em;border:5px solid darkgray;border-width:0 0 1px 1px}li.dark-mode.svelte-buml4.svelte-buml4{padding-left:1em;border:5px solid gray;border-width:0 0 1px 1px}li.container.svelte-buml4.svelte-buml4{border-bottom:0px}li.svelte-buml4 p.svelte-buml4{margin:0;position:relative;top:0em;padding:1px 0 1px 0}li.svelte-buml4 ul.svelte-buml4{border-top:1px solid darkgray;margin-left:-1em;padding-left:2em}li.dark-mode.svelte-buml4 ul.svelte-buml4{border-top:1px solid gray}ul li.svelte-buml4:last-child ul.svelte-buml4{border-left:none;margin-left:-17px}.expand-arrow.svelte-buml4.svelte-buml4{color:darkgrey}.expand-arrow.svelte-buml4.svelte-buml4:hover{color:gray}div.expand-button.svelte-buml4.svelte-buml4{display:inline}div.expand-button.svelte-buml4 svg.svg.svelte-buml4{width:14px;height:14px;margin-top:5px}li.light-mode.svelte-buml4 div.expand-button svg.svg.svelte-buml4{fill:darkgrey}li.light-mode.svelte-buml4 div.expand-button svg.svg.svelte-buml4:hover{fill:gray}li.dark-mode.svelte-buml4 div.expand-button svg.svg.svelte-buml4{fill:gray}li.dark-mode.svelte-buml4 div.expand-button svg.svg.svelte-buml4:hover{fill:lightgray}div.expand-button.svelte-buml4 svg.svg.expanded.svelte-buml4{transform:rotate(90deg)}");
}

function get_each_context$4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[12] = list[i];
	return child_ctx;
}

// (42:0) {:else}
function create_else_block$1(ctx) {
	let li;
	let p;
	let t;
	let ul;
	let current;

	function select_block_type_1(ctx, dirty) {
		if (/*indentation*/ ctx[2] === 0) return create_if_block_2$1;
		return create_else_block_1$1;
	}

	let current_block_type = select_block_type_1(ctx);
	let if_block0 = current_block_type(ctx);
	let if_block1 = /*children*/ ctx[7].length > 0 && /*isExpanded*/ ctx[6] && create_if_block_1$1(ctx);

	return {
		c() {
			li = element("li");
			p = element("p");
			if_block0.c();
			t = space();
			ul = element("ul");
			if (if_block1) if_block1.c();
			attr(p, "class", "svelte-buml4");
			attr(ul, "class", "svelte-buml4");
			attr(li, "class", "container " + /*darkModeDependentClass*/ ctx[8] + " svelte-buml4");
		},
		m(target, anchor) {
			insert(target, li, anchor);
			append(li, p);
			if_block0.m(p, null);
			append(li, t);
			append(li, ul);
			if (if_block1) if_block1.m(ul, null);
			current = true;
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type_1(ctx)) && if_block0) {
				if_block0.p(ctx, dirty);
			} else {
				if_block0.d(1);
				if_block0 = current_block_type(ctx);

				if (if_block0) {
					if_block0.c();
					if_block0.m(p, null);
				}
			}

			if (/*children*/ ctx[7].length > 0 && /*isExpanded*/ ctx[6]) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty & /*isExpanded*/ 64) {
						transition_in(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block_1$1(ctx);
					if_block1.c();
					transition_in(if_block1, 1);
					if_block1.m(ul, null);
				}
			} else if (if_block1) {
				group_outros();

				transition_out(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block1);
			current = true;
		},
		o(local) {
			transition_out(if_block1);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(li);
			if_block0.d();
			if (if_block1) if_block1.d();
		}
	};
}

// (40:0) {#if indentation === 0 && children.length === 0}
function create_if_block$1(ctx) {
	let t;

	return {
		c() {
			t = text("No descendants");
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (47:12) {:else}
function create_else_block_1$1(ctx) {
	let t0;
	let a;
	let t1_value = getDisplayName(/*notePath*/ ctx[0], /*db*/ ctx[1]) + "";
	let t1;
	let mounted;
	let dispose;
	let if_block = /*children*/ ctx[7].length > 0 && create_if_block_3$1(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			t0 = space();
			a = element("a");
			t1 = text(t1_value);
			attr(a, "class", "link svelte-buml4");
			attr(a, "title", /*notePath*/ ctx[0]);
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, t0, anchor);
			insert(target, a, anchor);
			append(a, t1);

			if (!mounted) {
				dispose = listen(a, "click", /*click_handler_1*/ ctx[10]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (/*children*/ ctx[7].length > 0) if_block.p(ctx, dirty);
			if (dirty & /*notePath, db*/ 3 && t1_value !== (t1_value = getDisplayName(/*notePath*/ ctx[0], /*db*/ ctx[1]) + "")) set_data(t1, t1_value);

			if (dirty & /*notePath*/ 1) {
				attr(a, "title", /*notePath*/ ctx[0]);
			}
		},
		d(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach(t0);
			if (detaching) detach(a);
			mounted = false;
			dispose();
		}
	};
}

// (45:12) {#if indentation === 0}
function create_if_block_2$1(ctx) {
	let t_value = getDisplayName(/*notePath*/ ctx[0], /*db*/ ctx[1]) + "";
	let t;

	return {
		c() {
			t = text(t_value);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*notePath, db*/ 3 && t_value !== (t_value = getDisplayName(/*notePath*/ ctx[0], /*db*/ ctx[1]) + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (48:16) {#if children.length > 0}
function create_if_block_3$1(ctx) {
	let span;
	let div;
	let mounted;
	let dispose;

	function select_block_type_2(ctx, dirty) {
		if (/*isExpanded*/ ctx[6]) return create_if_block_4$1;
		return create_else_block_2$1;
	}

	let current_block_type = select_block_type_2(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			span = element("span");
			div = element("div");
			if_block.c();
			attr(div, "class", "expand-button svelte-buml4");
			attr(span, "class", "expand-arrow svelte-buml4");
		},
		m(target, anchor) {
			insert(target, span, anchor);
			append(span, div);
			if_block.m(div, null);

			if (!mounted) {
				dispose = listen(span, "click", /*click_handler*/ ctx[9]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (current_block_type !== (current_block_type = select_block_type_2(ctx))) {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(div, null);
				}
			}
		},
		d(detaching) {
			if (detaching) detach(span);
			if_block.d();
			mounted = false;
			dispose();
		}
	};
}

// (64:14) {:else}
function create_else_block_2$1(ctx) {
	let svg;
	let use;

	return {
		c() {
			svg = svg_element("svg");
			use = svg_element("use");
			attr(use, "href", "#expand-arrow-svg");
			attr(svg, "class", "svg svelte-buml4");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, use);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (60:14) {#if isExpanded}
function create_if_block_4$1(ctx) {
	let svg;
	let use;

	return {
		c() {
			svg = svg_element("svg");
			use = svg_element("use");
			attr(use, "href", "#expand-arrow-svg");
			attr(svg, "class", "svg expanded svelte-buml4");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, use);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (82:12) {#if children.length > 0 && isExpanded}
function create_if_block_1$1(ctx) {
	let each_1_anchor;
	let current;
	let each_value = /*children*/ ctx[7];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$4(get_each_context$4(ctx, each_value, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (dirty & /*db, app, children, indentation, view, expandManager*/ 190) {
				each_value = /*children*/ ctx[7];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$4(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block$4(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				group_outros();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(each_1_anchor);
		}
	};
}

// (83:16) {#each children as child}
function create_each_block$4(ctx) {
	let descendants;
	let current;

	descendants = new Descendants({
			props: {
				db: /*db*/ ctx[1],
				app: /*app*/ ctx[4],
				notePath: /*child*/ ctx[12],
				indentation: /*indentation*/ ctx[2] + 1,
				view: /*view*/ ctx[3],
				expandManager: /*expandManager*/ ctx[5]
			}
		});

	return {
		c() {
			create_component(descendants.$$.fragment);
		},
		m(target, anchor) {
			mount_component(descendants, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const descendants_changes = {};
			if (dirty & /*db*/ 2) descendants_changes.db = /*db*/ ctx[1];
			if (dirty & /*app*/ 16) descendants_changes.app = /*app*/ ctx[4];
			if (dirty & /*indentation*/ 4) descendants_changes.indentation = /*indentation*/ ctx[2] + 1;
			if (dirty & /*view*/ 8) descendants_changes.view = /*view*/ ctx[3];
			if (dirty & /*expandManager*/ 32) descendants_changes.expandManager = /*expandManager*/ ctx[5];
			descendants.$set(descendants_changes);
		},
		i(local) {
			if (current) return;
			transition_in(descendants.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(descendants.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(descendants, detaching);
		}
	};
}

function create_fragment$5(ctx) {
	let svg;
	let symbol;
	let path;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*indentation*/ ctx[2] === 0 && /*children*/ ctx[7].length === 0) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			svg = svg_element("svg");
			symbol = svg_element("symbol");
			path = svg_element("path");
			t = space();
			if_block.c();
			if_block_anchor = empty();
			attr(path, "d", "M22 12l-20 12 5-12-5-12z");
			attr(symbol, "id", "expand-arrow-svg");
			attr(symbol, "xmlns", "http://www.w3.org/2000/svg");
			attr(symbol, "viewBox", "0 0 24 24");
			attr(svg, "display", "none");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, symbol);
			append(symbol, path);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(svg);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let { notePath } = $$props;
	let { db } = $$props;
	let { indentation } = $$props;
	let { view } = $$props;
	let { app } = $$props;
	let { expandManager } = $$props;
	let isExpanded;
	const children = Array.from(db.descendants.get(notePath) || []);

	const darkModeDependentClass = document.body.classList.contains("theme-dark")
	? "dark-mode"
	: "light-mode";

	function resetExpanded(newMaxIndent) {
		if (indentation === 0) {
			$$invalidate(6, isExpanded = true);
		} else if (!view.plugin.settings.isExpanded(notePath)) {
			$$invalidate(6, isExpanded = false);
		} else {
			$$invalidate(6, isExpanded = indentation < newMaxIndent);
		}
	}

	expandManager.registerIndentation(indentation);
	resetExpanded(expandManager.initialMaxIndent);
	expandManager.registerRedrawDescendantCallback(resetExpanded);

	const click_handler = () => {
		$$invalidate(6, isExpanded = !isExpanded);
		view.plugin.settings.setExpanded(notePath, isExpanded);

		if (isExpanded) {
			expandManager.onManualExpand();
			expandManager.registerIndentation(indentation + 1);
		}
	};

	const click_handler_1 = event => {
		NavigateToFile(app, notePath, event);
	};

	$$self.$$set = $$props => {
		if ('notePath' in $$props) $$invalidate(0, notePath = $$props.notePath);
		if ('db' in $$props) $$invalidate(1, db = $$props.db);
		if ('indentation' in $$props) $$invalidate(2, indentation = $$props.indentation);
		if ('view' in $$props) $$invalidate(3, view = $$props.view);
		if ('app' in $$props) $$invalidate(4, app = $$props.app);
		if ('expandManager' in $$props) $$invalidate(5, expandManager = $$props.expandManager);
	};

	return [
		notePath,
		db,
		indentation,
		view,
		app,
		expandManager,
		isExpanded,
		children,
		darkModeDependentClass,
		click_handler,
		click_handler_1
	];
}

class Descendants extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance$5,
			create_fragment$5,
			safe_not_equal,
			{
				notePath: 0,
				db: 1,
				indentation: 2,
				view: 3,
				app: 4,
				expandManager: 5
			},
			add_css$5
		);
	}
}

/* src/svelte/UpdateNotice.svelte generated by Svelte v3.59.2 */

function add_css$4(target) {
	append_styles(target, "svelte-19p0mox", "div#all-container.svelte-19p0mox{display:flex;flex-direction:column;height:100%}div#main-moc-div.svelte-19p0mox{padding:initial;width:initial;height:initial;position:initial;overflow:auto;flex:1}div#main-moc-div.dark-mode.svelte-19p0mox{color:#dcddde}");
}

function create_fragment$4(ctx) {
	let div1;
	let div0;
	let h3;
	let t1;
	let ul;
	let t5;
	let a;
	let t7;
	let br0;
	let br1;
	let t8;
	let br2;
	let br3;
	let t9;
	let button;
	let mounted;
	let dispose;

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			h3 = element("h3");
			h3.textContent = "This plugin has been updated";
			t1 = text("\n\n        The latest changes are:\n        ");
			ul = element("ul");

			ul.innerHTML = `<li>Added a settings option to toggle whether the paths to the current note
                are displayed or not (show only it&#39;s descendants)</li> 
            <li>For better readability, links in the view are no longer underlined</li>`;

			t5 = text("\n        See ");
			a = element("a");
			a.textContent = "here";
			t7 = text("\n        for a complete history of all changes.");
			br0 = element("br");
			br1 = element("br");
			t8 = space();
			br2 = element("br");
			br3 = element("br");
			t9 = space();
			button = element("button");
			button.textContent = "Okay";
			set_style(h3, "text-align", "center");
			attr(a, "href", "https://github.com/Robin-Haupt-1/Obsidian-Map-of-Content/releases");
			set_style(button, "display", "block");
			set_style(button, "margin", "auto");
			attr(div0, "id", "main-moc-div");
			attr(div0, "class", "" + (null_to_empty(/*darkModeDependentClass*/ ctx[2]) + " svelte-19p0mox"));
			attr(div1, "id", "all-container");
			attr(div1, "class", "svelte-19p0mox");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			append(div0, h3);
			append(div0, t1);
			append(div0, ul);
			append(div0, t5);
			append(div0, a);
			append(div0, t7);
			append(div0, br0);
			append(div0, br1);
			append(div0, t8);
			append(div0, br2);
			append(div0, br3);
			append(div0, t9);
			append(div0, button);

			if (!mounted) {
				dispose = listen(button, "click", /*click_handler*/ ctx[4]);
				mounted = true;
			}
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div1);
			mounted = false;
			dispose();
		}
	};
}

function instance$4($$self, $$props, $$invalidate) {
	let { view } = $$props;
	let { plugin } = $$props;
	const settings = plugin.settings;

	const darkModeDependentClass = document.body.classList.contains("theme-dark")
	? "dark-mode"
	: "light-mode";

	const click_handler = () => {
		settings.set({ do_show_update_notice: false });
		view.rerender();
	};

	$$self.$$set = $$props => {
		if ('view' in $$props) $$invalidate(0, view = $$props.view);
		if ('plugin' in $$props) $$invalidate(3, plugin = $$props.plugin);
	};

	return [view, settings, darkModeDependentClass, plugin, click_handler];
}

class UpdateNotice extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$4, create_fragment$4, safe_not_equal, { view: 0, plugin: 3 }, add_css$4);
	}
}

class ExpandManager {
    constructor() {
        this.initialMaxIndent = 3;
        this.redrawCallbacks = [];
        this.isManuallyExpanded = false;
    }
    expand() {
        if (this.isManuallyExpanded) {
            this.rerenderDescendants(this.initialMaxIndent);
            this.isManuallyExpanded = false;
        }
        else {
            this.rerenderDescendants(this.initialMaxIndent + 1);
        }
    }
    contract() {
        if (this.initialMaxIndent > 1) {
            this.rerenderDescendants(this.initialMaxIndent - 1);
            this.initialMaxIndent -= 1;
        }
    }
    rerenderDescendants(newMaxIndent) {
        this.redrawCallbacks.forEach((func) => func(newMaxIndent));
    }
    registerRedrawDescendantCallback(redraw) {
        this.redrawCallbacks.push(redraw);
    }
    registerIndentation(indent) {
        if (indent > this.initialMaxIndent) {
            this.initialMaxIndent = indent;
        }
    }
    onManualExpand() {
        this.isManuallyExpanded = true;
    }
}

/* src/svelte/View.svelte generated by Svelte v3.59.2 */

function add_css$3(target) {
	append_styles(target, "svelte-5veaf8", "a.svelte-5veaf8.svelte-5veaf8{text-decoration:none}div#all-container.svelte-5veaf8.svelte-5veaf8{display:flex;flex-direction:column;height:100%}div#top-bar.svelte-5veaf8.svelte-5veaf8{min-height:30px;width:100%;display:grid;grid-template-columns:1fr 1fr 1fr;grid-gap:10px;margin-bottom:1em}div#top-bar.svelte-5veaf8 div#pin-file svg#pinned.svelte-5veaf8{display:none}div#top-bar.svelte-5veaf8 div#pin-file.is-pinned svg#pinned.svelte-5veaf8{display:block}div#top-bar.svelte-5veaf8 div#pin-file.is-pinned svg#not-pinned.svelte-5veaf8{display:none}div#top-bar-flex.svelte-5veaf8.svelte-5veaf8{min-height:30px;display:flex;justify-content:center}div#top-bar.svelte-5veaf8 div.action.svelte-5veaf8{height:20px;width:20px;margin:5px}div#top-bar.svelte-5veaf8 div.action svg.svelte-5veaf8{height:20px;width:20px;fill:darkgrey}div#top-bar.svelte-5veaf8 div.action:hover svg.svelte-5veaf8{fill:grey}div.dark-mode.svelte-5veaf8 div#top-bar div.action svg.svelte-5veaf8{height:20px;width:20px;fill:grey}div.dark-mode.svelte-5veaf8 div#top-bar div.action:hover svg.svelte-5veaf8{fill:darkgrey}div#main-moc-div.svelte-5veaf8.svelte-5veaf8{padding:initial;width:initial;height:initial;position:initial;overflow:auto;flex:1}div.dark-mode.svelte-5veaf8.svelte-5veaf8{color:#dcddde}div#scroll-up-button.svelte-5veaf8.svelte-5veaf8{justify-self:flex-end;display:none}div#scroll-up-button.svelte-5veaf8.svelte-5veaf8{cursor:pointer;color:darkgrey}div#scroll-up-button.svelte-5veaf8 svg.svelte-5veaf8{transform:rotate(-90deg);height:20px}div.light-mode.svelte-5veaf8 div#scroll-up-button svg.svelte-5veaf8{fill:darkgray}div.light-mode.svelte-5veaf8 div#scroll-up-button:hover svg.svelte-5veaf8{fill:gray}div.dark-mode.svelte-5veaf8 div#scroll-up-button svg.svelte-5veaf8{fill:gray}div.dark-mode.svelte-5veaf8 div#scroll-up-button:hover svg.svelte-5veaf8{fill:darkgray}a.link.svelte-5veaf8.svelte-5veaf8{cursor:pointer}ul.svelte-5veaf8.svelte-5veaf8{padding-left:0}svg.path-arrow.svelte-5veaf8.svelte-5veaf8{margin-right:3px;margin-left:3px;display:inline;width:24px;height:0.7em}div.dark-mode.svelte-5veaf8 svg.path-arrow.svelte-5veaf8{fill:lightgray}.error.svelte-5veaf8.svelte-5veaf8{padding:10px;width:initial;height:initial;position:initial;overflow-y:initial;overflow-wrap:initial}");
}

function get_each_context$3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[21] = list[i];
	return child_ctx;
}

function get_each_context_2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[24] = list[i];
	child_ctx[26] = i;
	return child_ctx;
}

function get_each_context_1$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[24] = list[i];
	child_ctx[26] = i;
	return child_ctx;
}

// (161:8) {:else}
function create_else_block(ctx) {
	let show_if = /*plugin*/ ctx[7].settings.get("do_show_paths_to_note");
	let t0;
	let br;
	let t1;
	let ul;
	let descendants;
	let current;
	let if_block = show_if && create_if_block_3(ctx);

	descendants = new Descendants({
			props: {
				db: /*plugin*/ ctx[7].db,
				app: /*plugin*/ ctx[7].app,
				view: /*view*/ ctx[0],
				notePath: /*view*/ ctx[0].openFilePath,
				indentation: 0,
				expandManager: /*expandManager*/ ctx[8]
			}
		});

	return {
		c() {
			if (if_block) if_block.c();
			t0 = space();
			br = element("br");
			t1 = space();
			ul = element("ul");
			create_component(descendants.$$.fragment);
			attr(ul, "class", "svelte-5veaf8");
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, t0, anchor);
			insert(target, br, anchor);
			insert(target, t1, anchor);
			insert(target, ul, anchor);
			mount_component(descendants, ul, null);
			current = true;
		},
		p(ctx, dirty) {
			if (show_if) if_block.p(ctx, dirty);
			const descendants_changes = {};
			if (dirty & /*view*/ 1) descendants_changes.view = /*view*/ ctx[0];
			if (dirty & /*view*/ 1) descendants_changes.notePath = /*view*/ ctx[0].openFilePath;
			descendants.$set(descendants_changes);
		},
		i(local) {
			if (current) return;
			transition_in(descendants.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(descendants.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach(t0);
			if (detaching) detach(br);
			if (detaching) detach(t1);
			if (detaching) detach(ul);
			destroy_component(descendants);
		}
	};
}

// (144:37) 
function create_if_block_2(ctx) {
	let t0;
	let a0;
	let t1_value = getDisplayName(/*plugin*/ ctx[7].settings.get("CN_path"), /*plugin*/ ctx[7].db) + "";
	let t1;
	let t2;
	let br0;
	let br1;
	let t3;
	let a1;
	let t5;
	let br2;
	let t6;
	let nolinkimage;
	let current;
	let mounted;
	let dispose;
	nolinkimage = new NoLinkImage({});

	return {
		c() {
			t0 = text("This file doesn't have any connections to ");
			a0 = element("a");
			t1 = text(t1_value);
			t2 = text(".");
			br0 = element("br");
			br1 = element("br");
			t3 = text(" Link it to a file that is part of your Map of Content. Then\n            ");
			a1 = element("a");
			a1.textContent = "update";
			t5 = text("\n            your Map of Content and watch it grow!");
			br2 = element("br");
			t6 = space();
			create_component(nolinkimage.$$.fragment);
			attr(a0, "class", "link svelte-5veaf8");
			attr(a0, "title", /*plugin*/ ctx[7].settings.get("CN_path"));
			attr(a1, "class", "link svelte-5veaf8");
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, a0, anchor);
			append(a0, t1);
			insert(target, t2, anchor);
			insert(target, br0, anchor);
			insert(target, br1, anchor);
			insert(target, t3, anchor);
			insert(target, a1, anchor);
			insert(target, t5, anchor);
			insert(target, br2, anchor);
			insert(target, t6, anchor);
			mount_component(nolinkimage, target, anchor);
			current = true;

			if (!mounted) {
				dispose = [
					listen(a0, "click", /*click_handler_5*/ ctx[15]),
					listen(a1, "click", /*click_handler_6*/ ctx[16])
				];

				mounted = true;
			}
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(nolinkimage.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(nolinkimage.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(a0);
			if (detaching) detach(t2);
			if (detaching) detach(br0);
			if (detaching) detach(br1);
			if (detaching) detach(t3);
			if (detaching) detach(a1);
			if (detaching) detach(t5);
			if (detaching) detach(br2);
			if (detaching) detach(t6);
			destroy_component(nolinkimage, detaching);
			mounted = false;
			run_all(dispose);
		}
	};
}

// (140:24) 
function create_if_block_1(ctx) {
	let div;

	return {
		c() {
			div = element("div");
			attr(div, "class", "error svelte-5veaf8");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			div.innerHTML = /*error*/ ctx[2];
		},
		p(ctx, dirty) {
			if (dirty & /*error*/ 4) div.innerHTML = /*error*/ ctx[2];		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (138:8) {#if plugin.settings.get("do_show_update_notice")}
function create_if_block(ctx) {
	let updatenotice;
	let current;

	updatenotice = new UpdateNotice({
			props: {
				view: /*view*/ ctx[0],
				plugin: /*plugin*/ ctx[7]
			}
		});

	return {
		c() {
			create_component(updatenotice.$$.fragment);
		},
		m(target, anchor) {
			mount_component(updatenotice, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const updatenotice_changes = {};
			if (dirty & /*view*/ 1) updatenotice_changes.view = /*view*/ ctx[0];
			updatenotice.$set(updatenotice_changes);
		},
		i(local) {
			if (current) return;
			transition_in(updatenotice.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(updatenotice.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(updatenotice, detaching);
		}
	};
}

// (162:12) {#if plugin.settings.get("do_show_paths_to_note")}
function create_if_block_3(ctx) {
	let each_1_anchor;
	let each_value = /*paths*/ ctx[1];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$3(get_each_context$3(ctx, each_value, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*paths, getDisplayName, plugin, NavigateToFile, LINKED_FROM, LINKED_TO, LINKED_BOTH*/ 130) {
				each_value = /*paths*/ ctx[1];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$3(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$3(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(each_1_anchor);
		}
	};
}

// (208:24) {:else}
function create_else_block_2(ctx) {
	let each_1_anchor;
	let each_value_2 = /*path*/ ctx[21].reverse();
	let each_blocks = [];

	for (let i = 0; i < each_value_2.length; i += 1) {
		each_blocks[i] = create_each_block_2(get_each_context_2(ctx, each_value_2, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*paths, LINKED_FROM, LINKED_TO, LINKED_BOTH, getDisplayName, plugin, NavigateToFile*/ 130) {
				each_value_2 = /*path*/ ctx[21].reverse();
				let i;

				for (i = 0; i < each_value_2.length; i += 1) {
					const child_ctx = get_each_context_2(ctx, each_value_2, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_2(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_2.length;
			}
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(each_1_anchor);
		}
	};
}

// (165:24) {#if plugin.settings.get("MOC_path_starts_at_CN")}
function create_if_block_4(ctx) {
	let each_1_anchor;
	let each_value_1 = /*path*/ ctx[21];
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1$1(get_each_context_1$1(ctx, each_value_1, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*paths, getDisplayName, plugin, NavigateToFile, LINKED_FROM, LINKED_TO, LINKED_BOTH*/ 130) {
				each_value_1 = /*path*/ ctx[21];
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1$1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(each_1_anchor);
		}
	};
}

// (212:33) {:else}
function create_else_block_3(ctx) {
	let a;
	let t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "";
	let t;
	let a_title_value;
	let mounted;
	let dispose;

	function click_handler_8(...args) {
		return /*click_handler_8*/ ctx[18](/*pathitem*/ ctx[24], ...args);
	}

	return {
		c() {
			a = element("a");
			t = text(t_value);
			attr(a, "class", "link svelte-5veaf8");
			attr(a, "title", a_title_value = /*pathitem*/ ctx[24][0]);
		},
		m(target, anchor) {
			insert(target, a, anchor);
			append(a, t);

			if (!mounted) {
				dispose = listen(a, "click", click_handler_8);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			if (dirty & /*paths*/ 2 && t_value !== (t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "")) set_data(t, t_value);

			if (dirty & /*paths*/ 2 && a_title_value !== (a_title_value = /*pathitem*/ ctx[24][0])) {
				attr(a, "title", a_title_value);
			}
		},
		d(detaching) {
			if (detaching) detach(a);
			mounted = false;
			dispose();
		}
	};
}

// (210:32) {#if i === 0}
function create_if_block_12(ctx) {
	let span;
	let t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "";
	let t;
	let span_title_value;

	return {
		c() {
			span = element("span");
			t = text(t_value);
			attr(span, "title", span_title_value = /*pathitem*/ ctx[24][0]);
		},
		m(target, anchor) {
			insert(target, span, anchor);
			append(span, t);
		},
		p(ctx, dirty) {
			if (dirty & /*paths*/ 2 && t_value !== (t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "")) set_data(t, t_value);

			if (dirty & /*paths*/ 2 && span_title_value !== (span_title_value = /*pathitem*/ ctx[24][0])) {
				attr(span, "title", span_title_value);
			}
		},
		d(detaching) {
			if (detaching) detach(span);
		}
	};
}

// (240:70) 
function create_if_block_11(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", "M 9 0 L 0 7.5214844 L 9 15 L 9.6445312 14.236328 L 2.1152344 8 L 21.882812 8 L 14.355469 14.234375 L 15 15 L 24 7.4785156 L 15 0 L 14.355469 0.76367188 L 21.884766 7 L 2.1171875 7 L 9.6445312 0.765625 L 9 0 z ");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (230:68) 
function create_if_block_10(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", "M 2.117,7 9.644,0.765 9,0 0,7.521 9,15 9.645,14.236 2.116,8 H 24 V 7 Z");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (220:32) {#if pathitem[1] === LINKED_FROM}
function create_if_block_9(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", " M 21.883,8 14.356,14.235 15,15 24,7.479 15,0 14.355,0.764 21.884,7 H 0 v 1 z");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (209:28) {#each path.reverse() as pathitem, i}
function create_each_block_2(ctx) {
	let t;
	let if_block1_anchor;

	function select_block_type_4(ctx, dirty) {
		if (/*i*/ ctx[26] === 0) return create_if_block_12;
		return create_else_block_3;
	}

	let current_block_type = select_block_type_4(ctx);
	let if_block0 = current_block_type(ctx);

	function select_block_type_5(ctx, dirty) {
		if (/*pathitem*/ ctx[24][1] === LINKED_FROM) return create_if_block_9;
		if (/*pathitem*/ ctx[24][1] === LINKED_TO) return create_if_block_10;
		if (/*pathitem*/ ctx[24][1] === LINKED_BOTH) return create_if_block_11;
	}

	let current_block_type_1 = select_block_type_5(ctx);
	let if_block1 = current_block_type_1 && current_block_type_1(ctx);

	return {
		c() {
			if_block0.c();
			t = space();
			if (if_block1) if_block1.c();
			if_block1_anchor = empty();
		},
		m(target, anchor) {
			if_block0.m(target, anchor);
			insert(target, t, anchor);
			if (if_block1) if_block1.m(target, anchor);
			insert(target, if_block1_anchor, anchor);
		},
		p(ctx, dirty) {
			if_block0.p(ctx, dirty);

			if (current_block_type_1 !== (current_block_type_1 = select_block_type_5(ctx))) {
				if (if_block1) if_block1.d(1);
				if_block1 = current_block_type_1 && current_block_type_1(ctx);

				if (if_block1) {
					if_block1.c();
					if_block1.m(if_block1_anchor.parentNode, if_block1_anchor);
				}
			}
		},
		d(detaching) {
			if_block0.d(detaching);
			if (detaching) detach(t);

			if (if_block1) {
				if_block1.d(detaching);
			}

			if (detaching) detach(if_block1_anchor);
		}
	};
}

// (187:70) 
function create_if_block_8(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", "M 9 0 L 0 7.5214844 L 9 15 L 9.6445312 14.236328 L 2.1152344 8 L 21.882812 8 L 14.355469 14.234375 L 15 15 L 24 7.4785156 L 15 0 L 14.355469 0.76367188 L 21.884766 7 L 2.1171875 7 L 9.6445312 0.765625 L 9 0 z ");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (177:68) 
function create_if_block_7(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", " M 21.883,8 14.356,14.235 15,15 24,7.479 15,0 14.355,0.764 21.884,7 H 0 v 1 z");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (167:32) {#if pathitem[1] === LINKED_FROM}
function create_if_block_6(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", "M 2.117,7 9.644,0.765 9,0 0,7.521 9,15 9.645,14.236 2.116,8 H 24 V 7 Z");
			attr(svg, "class", "path-arrow svelte-5veaf8");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "viewBox", "0 0 24 15.05");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

// (200:33) {:else}
function create_else_block_1(ctx) {
	let a;
	let t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "";
	let t;
	let a_title_value;
	let mounted;
	let dispose;

	function click_handler_7(...args) {
		return /*click_handler_7*/ ctx[17](/*pathitem*/ ctx[24], ...args);
	}

	return {
		c() {
			a = element("a");
			t = text(t_value);
			attr(a, "class", "link svelte-5veaf8");
			attr(a, "title", a_title_value = /*pathitem*/ ctx[24][0]);
		},
		m(target, anchor) {
			insert(target, a, anchor);
			append(a, t);

			if (!mounted) {
				dispose = listen(a, "click", click_handler_7);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			if (dirty & /*paths*/ 2 && t_value !== (t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "")) set_data(t, t_value);

			if (dirty & /*paths*/ 2 && a_title_value !== (a_title_value = /*pathitem*/ ctx[24][0])) {
				attr(a, "title", a_title_value);
			}
		},
		d(detaching) {
			if (detaching) detach(a);
			mounted = false;
			dispose();
		}
	};
}

// (198:32) {#if i === path.length - 1}
function create_if_block_5(ctx) {
	let span;
	let t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "";
	let t;
	let span_title_value;

	return {
		c() {
			span = element("span");
			t = text(t_value);
			attr(span, "title", span_title_value = /*pathitem*/ ctx[24][0]);
		},
		m(target, anchor) {
			insert(target, span, anchor);
			append(span, t);
		},
		p(ctx, dirty) {
			if (dirty & /*paths*/ 2 && t_value !== (t_value = getDisplayName(/*pathitem*/ ctx[24][0], /*plugin*/ ctx[7].db) + "")) set_data(t, t_value);

			if (dirty & /*paths*/ 2 && span_title_value !== (span_title_value = /*pathitem*/ ctx[24][0])) {
				attr(span, "title", span_title_value);
			}
		},
		d(detaching) {
			if (detaching) detach(span);
		}
	};
}

// (166:28) {#each path as pathitem, i}
function create_each_block_1$1(ctx) {
	let t;
	let if_block1_anchor;

	function select_block_type_2(ctx, dirty) {
		if (/*pathitem*/ ctx[24][1] === LINKED_FROM) return create_if_block_6;
		if (/*pathitem*/ ctx[24][1] === LINKED_TO) return create_if_block_7;
		if (/*pathitem*/ ctx[24][1] === LINKED_BOTH) return create_if_block_8;
	}

	let current_block_type = select_block_type_2(ctx);
	let if_block0 = current_block_type && current_block_type(ctx);

	function select_block_type_3(ctx, dirty) {
		if (/*i*/ ctx[26] === /*path*/ ctx[21].length - 1) return create_if_block_5;
		return create_else_block_1;
	}

	let current_block_type_1 = select_block_type_3(ctx);
	let if_block1 = current_block_type_1(ctx);

	return {
		c() {
			if (if_block0) if_block0.c();
			t = space();
			if_block1.c();
			if_block1_anchor = empty();
		},
		m(target, anchor) {
			if (if_block0) if_block0.m(target, anchor);
			insert(target, t, anchor);
			if_block1.m(target, anchor);
			insert(target, if_block1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (current_block_type !== (current_block_type = select_block_type_2(ctx))) {
				if (if_block0) if_block0.d(1);
				if_block0 = current_block_type && current_block_type(ctx);

				if (if_block0) {
					if_block0.c();
					if_block0.m(t.parentNode, t);
				}
			}

			if (current_block_type_1 === (current_block_type_1 = select_block_type_3(ctx)) && if_block1) {
				if_block1.p(ctx, dirty);
			} else {
				if_block1.d(1);
				if_block1 = current_block_type_1(ctx);

				if (if_block1) {
					if_block1.c();
					if_block1.m(if_block1_anchor.parentNode, if_block1_anchor);
				}
			}
		},
		d(detaching) {
			if (if_block0) {
				if_block0.d(detaching);
			}

			if (detaching) detach(t);
			if_block1.d(detaching);
			if (detaching) detach(if_block1_anchor);
		}
	};
}

// (163:16) {#each paths as path}
function create_each_block$3(ctx) {
	let div;
	let t;
	let br;

	function select_block_type_1(ctx, dirty) {
		if (/*plugin*/ ctx[7].settings.get("MOC_path_starts_at_CN")) return create_if_block_4;
		return create_else_block_2;
	}

	let current_block_type = select_block_type_1(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			div = element("div");
			if_block.c();
			t = space();
			br = element("br");
			attr(div, "class", "path");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			if_block.m(div, null);
			insert(target, t, anchor);
			insert(target, br, anchor);
		},
		p(ctx, dirty) {
			if_block.p(ctx, dirty);
		},
		d(detaching) {
			if (detaching) detach(div);
			if_block.d();
			if (detaching) detach(t);
			if (detaching) detach(br);
		}
	};
}

function create_fragment$3(ctx) {
	let div8;
	let div6;
	let div0;
	let svg0;
	let path0;
	let t0;
	let svg1;
	let path1;
	let div0_title_value;
	let t1;
	let div4;
	let div1;
	let t2;
	let div2;
	let t3;
	let div3;
	let t4;
	let div5;
	let t5;
	let div7;
	let show_if;
	let current_block_type_index;
	let if_block;
	let current;
	let mounted;
	let dispose;
	const if_block_creators = [create_if_block, create_if_block_1, create_if_block_2, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (show_if == null) show_if = !!/*plugin*/ ctx[7].settings.get("do_show_update_notice");
		if (show_if) return 0;
		if (/*error*/ ctx[2]) return 1;
		if (/*paths*/ ctx[1].length === 0) return 2;
		return 3;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			div8 = element("div");
			div6 = element("div");
			div0 = element("div");
			svg0 = svg_element("svg");
			path0 = svg_element("path");
			t0 = space();
			svg1 = svg_element("svg");
			path1 = svg_element("path");
			t1 = space();
			div4 = element("div");
			div1 = element("div");
			div1.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="svelte-5veaf8"><path d="M23 12c0 1.042-.154 2.045-.425 3h-2.101c.335-.94.526-1.947.526-3 0-4.962-4.037-9-9-9-1.706 0-3.296.484-4.655 1.314l1.858 2.686h-6.994l2.152-7 1.849 2.673c1.684-1.049 3.659-1.673 5.79-1.673 6.074 0 11 4.925 11 11zm-6.354 7.692c-1.357.826-2.944 1.308-4.646 1.308-4.962 0-9-4.038-9-9 0-1.053.191-2.06.525-3h-2.1c-.271.955-.425 1.958-.425 3 0 6.075 4.925 11 11 11 2.127 0 4.099-.621 5.78-1.667l1.853 2.667 2.152-6.989h-6.994l1.855 2.681z"></path></svg>`;
			t2 = space();
			div2 = element("div");
			div2.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="svelte-5veaf8"><path d="M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6 13h-12v-2h12v2z"></path></svg>`;
			t3 = space();
			div3 = element("div");
			div3.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill-rule="evenodd" clip-rule="evenodd" class="svelte-5veaf8"><path d="M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6 13h-5v5h-2v-5h-5v-2h5v-5h2v5h5v2z"></path></svg>`;
			t4 = space();
			div5 = element("div");
			div5.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="svelte-5veaf8"><path d="M15 5.829l6.171 6.171-6.171 6.171v-3.171h-13v-6h13v-3.171zm-2-4.829v6h-13v10h13v6l11-11-11-11z"></path></svg>`;
			t5 = space();
			div7 = element("div");
			if_block.c();
			attr(path0, "d", "M18 6c0 2.972-2.164 5.433-5 5.91v8.09h-2v-8.089c-2.836-.477-5-2.938-5-5.911 0-3.314 2.687-6 6-6s6 2.687 6 6zm-2 0c0-2.206-1.794-4-4-4s-4 1.794-4 4 1.794 4 4 4 4-1.794 4-4zm-5.618 2.098c2.339 1.84 5.563-.722 3.858-3.539.313 2.237-1.956 4.03-3.858 3.539zm4.618 8.195v2.052l.438.107c1.706.493 2.496 1.027 2.507 1.547-.011.52-.801 1.054-2.507 1.547-2.097.606-4.786.604-6.874.001-1.695-.489-2.515-1.021-2.515-1.547s.82-1.058 2.516-1.548l.436-.106v-2.052c-2.932.593-5.001 2.028-5.001 3.706 0 2.209 3.581 4 8 4s8-1.791 8-4c0-1.678-2.069-3.113-5-3.707z");
			attr(svg0, "id", "not-pinned");
			attr(svg0, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg0, "viewBox", "0 0 24 24");
			attr(svg0, "class", "svelte-5veaf8");
			attr(path1, "d", "M 12,2 C 8.687,2 6,4.687 6,8 c 0,2.972 2.164,5.433 5,5.91 V 20 h 2 v -6.089 c 2.836,-0.477 5,-2.938 5,-5.91 C 18,4.687 15.313,2 12,2 Z M 11.293,6.508 C 10.744,7.158 9.87,7.308 9.34,6.841 8.81,6.374 8.824,5.469 9.374,4.819 9.922,4.169 10.796,4.02 11.326,4.486 c 0.53,0.467 0.515,1.372 -0.033,2.022 z M 20,20 c 0,2.209 -3.581,4 -8,4 -4.419,0 -8,-1.791 -8,-4 0,-1.678 2.069,-3.113 5,-3.707 v 2.052 L 8.564,18.451 C 6.869,18.942 6.048,19.474 6.048,20 c 0,0.526 0.82,1.058 2.516,1.548 2.088,0.603 4.777,0.605 6.874,-10e-4 C 17.144,21.054 17.934,20.52 17.945,20 17.934,19.48 17.144,18.946 15.438,18.453 L 15,18.346 v -2.052 c 2.931,0.593 5,2.028 5,3.706 z");
			attr(svg1, "id", "pinned");
			attr(svg1, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg1, "width", "24");
			attr(svg1, "height", "24");
			attr(svg1, "viewBox", "0 0 24 24");
			attr(svg1, "class", "svelte-5veaf8");
			attr(div0, "id", "pin-file");
			attr(div0, "class", "action is-pinned svelte-5veaf8");

			attr(div0, "title", div0_title_value = /*currentNoteIsPinned*/ ctx[6]
			? "Unpin this file"
			: "Pin this file");

			toggle_class(div0, "is-pinned", /*currentNoteIsPinned*/ ctx[6]);
			attr(div1, "id", "update-moc");
			attr(div1, "class", "action svelte-5veaf8");
			attr(div1, "title", "Update the Map of Content");
			attr(div2, "id", "minus-expand");
			attr(div2, "class", "action svelte-5veaf8");
			attr(div2, "title", "Show fewer descendants");
			attr(div3, "id", "plus-expand");
			attr(div3, "class", "action svelte-5veaf8");
			attr(div3, "title", "Show more descendants");
			attr(div4, "id", "top-bar-flex");
			attr(div4, "class", "svelte-5veaf8");
			attr(div5, "id", "scroll-up-button");
			attr(div5, "title", "Scroll to top");
			attr(div5, "class", "action svelte-5veaf8");
			attr(div6, "id", "top-bar");
			attr(div6, "class", "svelte-5veaf8");
			attr(div7, "id", "main-moc-div");
			attr(div7, "class", "svelte-5veaf8");
			attr(div8, "id", "all-container");

			attr(div8, "class", "" + (null_to_empty(document.body.classList.contains("theme-dark")
			? "dark-mode"
			: "light-mode") + " svelte-5veaf8"));
		},
		m(target, anchor) {
			insert(target, div8, anchor);
			append(div8, div6);
			append(div6, div0);
			append(div0, svg0);
			append(svg0, path0);
			append(div0, t0);
			append(div0, svg1);
			append(svg1, path1);
			append(div6, t1);
			append(div6, div4);
			append(div4, div1);
			append(div4, t2);
			append(div4, div2);
			append(div4, t3);
			append(div4, div3);
			append(div6, t4);
			append(div6, div5);
			/*div5_binding*/ ctx[13](div5);
			append(div8, t5);
			append(div8, div7);
			if_blocks[current_block_type_index].m(div7, null);
			/*div7_binding*/ ctx[19](div7);
			current = true;

			if (!mounted) {
				dispose = [
					listen(div0, "click", /*click_handler*/ ctx[9]),
					listen(div1, "click", /*click_handler_1*/ ctx[10]),
					listen(div2, "click", /*click_handler_2*/ ctx[11]),
					listen(div3, "click", /*click_handler_3*/ ctx[12]),
					listen(div5, "click", /*click_handler_4*/ ctx[14]),
					listen(div7, "scroll", /*scroll_handler*/ ctx[20])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (!current || dirty & /*currentNoteIsPinned*/ 64 && div0_title_value !== (div0_title_value = /*currentNoteIsPinned*/ ctx[6]
			? "Unpin this file"
			: "Pin this file")) {
				attr(div0, "title", div0_title_value);
			}

			if (!current || dirty & /*currentNoteIsPinned*/ 64) {
				toggle_class(div0, "is-pinned", /*currentNoteIsPinned*/ ctx[6]);
			}

			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(div7, null);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div8);
			/*div5_binding*/ ctx[13](null);
			if_blocks[current_block_type_index].d();
			/*div7_binding*/ ctx[19](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$3($$self, $$props, $$invalidate) {
	let { view } = $$props;
	let { paths } = $$props;
	let { error } = $$props;
	const plugin = view.plugin;
	const expandManager = new ExpandManager();
	let scrollUpDiv;
	let mainDiv;
	let isScrollUpDivVisible = false;
	let currentNoteIsPinned = false;

	const click_handler = () => {
		$$invalidate(0, view.isPinned = !view.isPinned, view);
		$$invalidate(6, currentNoteIsPinned = !currentNoteIsPinned);

		if (view.isPinned) ;
	};

	const click_handler_1 = () => {
		plugin.db.update();
	};

	const click_handler_2 = () => {
		expandManager.contract();
	};

	const click_handler_3 = () => {
		expandManager.expand();
	};

	function div5_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			scrollUpDiv = $$value;
			$$invalidate(3, scrollUpDiv);
		});
	}

	const click_handler_4 = () => {
		$$invalidate(4, mainDiv.scrollTop = 0, mainDiv);
	};

	const click_handler_5 = event => NavigateToFile(plugin.app, plugin.settings.get("CN_path"), event);

	const click_handler_6 = () => {
		plugin.db.update();
	};

	const click_handler_7 = (pathitem, event) => NavigateToFile(plugin.app, pathitem[0], event);
	const click_handler_8 = (pathitem, event) => NavigateToFile(plugin.app, pathitem[0], event);

	function div7_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			mainDiv = $$value;
			$$invalidate(4, mainDiv);
		});
	}

	const scroll_handler = e => {
		if (e.target.scrollTop > 30 && !isScrollUpDivVisible) {
			$$invalidate(3, scrollUpDiv.style.display = "block", scrollUpDiv);
			$$invalidate(5, isScrollUpDivVisible = true);
		} else //hide the arrow if user scrolls back to the top
		if (e.target.scrollTop <= 30 && isScrollUpDivVisible) {
			$$invalidate(3, scrollUpDiv.style.display = "none", scrollUpDiv);
			$$invalidate(5, isScrollUpDivVisible = false);
		}
	};

	$$self.$$set = $$props => {
		if ('view' in $$props) $$invalidate(0, view = $$props.view);
		if ('paths' in $$props) $$invalidate(1, paths = $$props.paths);
		if ('error' in $$props) $$invalidate(2, error = $$props.error);
	};

	return [
		view,
		paths,
		error,
		scrollUpDiv,
		mainDiv,
		isScrollUpDivVisible,
		currentNoteIsPinned,
		plugin,
		expandManager,
		click_handler,
		click_handler_1,
		click_handler_2,
		click_handler_3,
		div5_binding,
		click_handler_4,
		click_handler_5,
		click_handler_6,
		click_handler_7,
		click_handler_8,
		div7_binding,
		scroll_handler
	];
}

class View extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$3, create_fragment$3, safe_not_equal, { view: 0, paths: 1, error: 2 }, add_css$3);
	}
}

class MOCView extends obsidian.ItemView {
    constructor(leaf, plugin) {
        super(leaf);
        this.maxIndent = 5;
        this.isPinned = false;
        this.plugin = plugin;
        this.leaf = leaf;
        this.db = this.plugin.db;
        this.settings = plugin.settings;
        this.app = this.plugin.app;
        this.plugin.registerViewInstance(this);
        this.plugin.app.workspace.onLayoutReady(() => this.init());
        this.plugin.app.workspace.on("css-change", () => {
            this.rerender();
        });
    }
    init() {
        this.registerEvent(this.app.workspace.on("file-open", (file) => {
            if (!this.isPinned) {
                this.monitorNote();
                this.rerender();
            }
        }));
        this.monitorNote();
        this.rerender();
    }
    async onOpen() { }
    rerender() {
        this.destroyApp();
        const error = this.getRerenderError();
        if (error) {
            this._app = new View({
                target: this.contentEl,
                props: { view: this, paths: [], error: error },
            });
            return;
        }
        let allPaths = this.db.findPaths(this.openFilePath);
        if (allPaths.length === 0) ;
        this._app = new View({
            target: this.contentEl,
            props: {
                view: this,
                paths: allPaths.map((p) => p.items.slice()),
                error: error,
            },
        });
    }
    getRerenderError() {
        switch (true) {
            case this.db.isDatabaseUpdating:
                return "Updating...";
            case !this.db.isDatabaseComplete:
                return `Your Map of Content couldn't be created.<br><br> Make sure your Central Note path <code>'${this.settings.get("CN_path")}'</code> is correct. You can change this path in the settings tab.`;
            case this.app.workspace.getActiveFile() === null:
                return "No file is open";
            case this.settings.isExcludedFile(this.app.workspace.getActiveFile()):
                return "This file has been excluded from the Map of Content.";
            default:
                this.openFilePath = this.app.workspace.getActiveFile().path;
                if (this.db.getNoteFromPath(this.openFilePath) === undefined) {
                    this.db.update(true);
                    return "Updating...";
                }
        }
    }
    destroyApp() {
        if (!this._app) {
            return;
        }
        this._app.$destroy();
        this._app = undefined; // set symbol to undefined in order to avoid "This component has already been destroyed" message
    }
    onClose() {
        this.destroyApp();
        this.plugin.unregisterViewInstance(this);
        return Promise.resolve();
    }
    async monitorNote() {
        let doUpdateDb = false;
        const activeFile = this.app.workspace.getActiveFile();
        if (activeFile === null) {
            return;
        }
        if (!this.settings.get("auto_update_on_file_change")) {
            return;
        }
        if (this.settings.isExcludedFile(activeFile)) {
            return;
        }
        if (this.noteBeingMonitored &&
            this.app.metadataCache.getCache(this.noteBeingMonitored) === undefined) {
            doUpdateDb = true;
        }
        devLog("Monitornote called on: " + activeFile.path);
        devLog("Old monitoring note: " + this.noteBeingMonitored);
        if (this.noteBeingMonitored &&
            this.app.metadataCache.getCache(this.noteBeingMonitored)) {
            if (activeFile.path !== this.noteBeingMonitored) {
                if (JSON.stringify(Array.from(this.db.getValidatedLinksFromNote(this.noteBeingMonitored, "/"))) !== JSON.stringify(this.linksOfNoteBeingMonitored)) {
                    doUpdateDb = true;
                }
            }
        }
        this.noteBeingMonitored = activeFile.path;
        this.linksOfNoteBeingMonitored = Array.from(this.db.getValidatedLinksFromNote(activeFile.path, "/"));
        if (doUpdateDb) {
            await this.db.update(true);
        }
    }
    getViewType() {
        return MOC_VIEW_TYPE;
    }
    getDisplayText() {
        return "Map of Content";
    }
    getIcon() {
        return "stacked-levels";
    }
}

/* src/svelte/settings/ExcludedFolders.svelte generated by Svelte v3.59.2 */

function add_css$2(target) {
	append_styles(target, "svelte-nevjct", ".svelte-nevjct{font-size:1em}h2.svelte-nevjct{text-align:left}div#exluded-folders-container.svelte-nevjct{display:flex;flex-wrap:wrap;column-gap:10px}div#list-excluded.svelte-nevjct{width:300px}#excluded-select.svelte-nevjct{height:300px;width:300px;font-size:1em;overflow:auto}#add-remove-exluded.svelte-nevjct{height:300px;width:300px}div#currently-excluded.svelte-nevjct{width:600px;max-height:300px;overflow:hidden}div#currently-excluded-list.svelte-nevjct{overflow:auto;max-height:260px}");
}

function get_each_context$2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[20] = list[i];
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[23] = list[i];
	return child_ctx;
}

// (105:6) {#each allFolders as folderPath}
function create_each_block_1(ctx) {
	let option;

	return {
		c() {
			option = element("option");
			option.__value = /*folderPath*/ ctx[23];
			option.value = option.__value;
			attr(option, "class", "svelte-nevjct");
		},
		m(target, anchor) {
			insert(target, option, anchor);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(option);
		}
	};
}

// (143:8) {#each excludedFiles as filePath}
function create_each_block$2(ctx) {
	let li;
	let t_value = /*filePath*/ ctx[20] + "";
	let t;

	return {
		c() {
			li = element("li");
			t = text(t_value);
			attr(li, "class", "svelte-nevjct");
		},
		m(target, anchor) {
			insert(target, li, anchor);
			append(li, t);
		},
		p(ctx, dirty) {
			if (dirty & /*excludedFiles*/ 2 && t_value !== (t_value = /*filePath*/ ctx[20] + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) detach(li);
		}
	};
}

function create_fragment$2(ctx) {
	let h2;
	let t1;
	let div4;
	let div0;
	let select;
	let t2;
	let div1;
	let label;
	let t4;
	let input0;
	let t5;
	let datalist;
	let t6;
	let br0;
	let t7;
	let br1;
	let t8;
	let input1;
	let br2;
	let t9;
	let input2;
	let br3;
	let br4;
	let t10;
	let div3;
	let t11;
	let t12_value = /*excludedFiles*/ ctx[1].length + "";
	let t12;
	let t13;
	let input3;
	let input3_value_value;
	let t14;
	let div2;
	let ul;
	let div2_style_value;
	let mounted;
	let dispose;
	let each_value_1 = /*allFolders*/ ctx[5];
	let each_blocks_1 = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks_1[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	let each_value = /*excludedFiles*/ ctx[1];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$2(get_each_context$2(ctx, each_value, i));
	}

	return {
		c() {
			h2 = element("h2");
			h2.textContent = "Excluded folders";
			t1 = space();
			div4 = element("div");
			div0 = element("div");
			select = element("select");
			t2 = space();
			div1 = element("div");
			label = element("label");
			label.textContent = "Add a folder:";
			t4 = space();
			input0 = element("input");
			t5 = space();
			datalist = element("datalist");

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			t6 = space();
			br0 = element("br");
			t7 = space();
			br1 = element("br");
			t8 = space();
			input1 = element("input");
			br2 = element("br");
			t9 = space();
			input2 = element("input");
			br3 = element("br");
			br4 = element("br");
			t10 = space();
			div3 = element("div");
			t11 = text("Currently excluded files: ");
			t12 = text(t12_value);
			t13 = space();
			input3 = element("input");
			t14 = space();
			div2 = element("div");
			ul = element("ul");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(h2, "class", "svelte-nevjct");
			attr(select, "id", "excluded-select");
			attr(select, "name", "lstValue");
			attr(select, "type", "text");
			select.multiple = true;
			attr(select, "class", "svelte-nevjct");
			attr(div0, "id", "list-excluded");
			attr(div0, "class", "svelte-nevjct");
			attr(label, "for", "Exluded-folders");
			attr(label, "class", "svelte-nevjct");
			attr(input0, "list", "exlude-folder");
			attr(input0, "id", "Exluded-folders");
			attr(input0, "type", "text");
			attr(input0, "placeholder", "Start typing to see suggestions...");
			set_style(input0, "width", "300px");
			attr(input0, "class", "svelte-nevjct");
			attr(datalist, "id", "exlude-folder");
			attr(datalist, "class", "svelte-nevjct");
			attr(br0, "class", "svelte-nevjct");
			attr(br1, "class", "svelte-nevjct");
			attr(input1, "type", "button");
			attr(input1, "name", "add");
			input1.value = "Add";
			attr(input1, "class", "svelte-nevjct");
			attr(br2, "class", "svelte-nevjct");
			attr(input2, "type", "button");
			attr(input2, "name", "delete");
			input2.value = "Delete";
			attr(input2, "class", "svelte-nevjct");
			attr(br3, "class", "svelte-nevjct");
			attr(br4, "class", "svelte-nevjct");
			attr(div1, "id", "add-remove-exluded");
			attr(div1, "class", "svelte-nevjct");
			attr(input3, "type", "button");
			attr(input3, "name", "toggle-show-hidden");
			input3.value = input3_value_value = /*showAllHidden*/ ctx[4] ? "Hide" : "Show";
			attr(input3, "class", "svelte-nevjct");
			attr(ul, "class", "svelte-nevjct");

			attr(div2, "style", div2_style_value = /*showAllHidden*/ ctx[4]
			? "display:block"
			: "display:none");

			attr(div2, "id", "currently-excluded-list");
			attr(div2, "class", "svelte-nevjct");
			attr(div3, "id", "currently-excluded");
			attr(div3, "class", "svelte-nevjct");
			attr(div4, "id", "exluded-folders-container");
			attr(div4, "class", "svelte-nevjct");
		},
		m(target, anchor) {
			insert(target, h2, anchor);
			insert(target, t1, anchor);
			insert(target, div4, anchor);
			append(div4, div0);
			append(div0, select);
			/*select_binding*/ ctx[10](select);
			append(div4, t2);
			append(div4, div1);
			append(div1, label);
			append(div1, t4);
			append(div1, input0);
			/*input0_binding*/ ctx[11](input0);
			set_input_value(input0, /*excludePathInputValue*/ ctx[2]);
			append(div1, t5);
			append(div1, datalist);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				if (each_blocks_1[i]) {
					each_blocks_1[i].m(datalist, null);
				}
			}

			append(div1, t6);
			append(div1, br0);
			append(div1, t7);
			append(div1, br1);
			append(div1, t8);
			append(div1, input1);
			append(div1, br2);
			append(div1, t9);
			append(div1, input2);
			append(div1, br3);
			append(div1, br4);
			append(div4, t10);
			append(div4, div3);
			append(div3, t11);
			append(div3, t12);
			append(div3, t13);
			append(div3, input3);
			append(div3, t14);
			append(div3, div2);
			append(div2, ul);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(ul, null);
				}
			}

			if (!mounted) {
				dispose = [
					listen(input0, "input", /*input0_input_handler*/ ctx[12]),
					listen(input1, "click", /*click_handler*/ ctx[13]),
					listen(input2, "click", /*click_handler_1*/ ctx[14]),
					listen(input3, "click", /*click_handler_2*/ ctx[15])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (dirty & /*excludePathInputValue*/ 4 && input0.value !== /*excludePathInputValue*/ ctx[2]) {
				set_input_value(input0, /*excludePathInputValue*/ ctx[2]);
			}

			if (dirty & /*allFolders*/ 32) {
				each_value_1 = /*allFolders*/ ctx[5];
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks_1[i]) {
						each_blocks_1[i].p(child_ctx, dirty);
					} else {
						each_blocks_1[i] = create_each_block_1(child_ctx);
						each_blocks_1[i].c();
						each_blocks_1[i].m(datalist, null);
					}
				}

				for (; i < each_blocks_1.length; i += 1) {
					each_blocks_1[i].d(1);
				}

				each_blocks_1.length = each_value_1.length;
			}

			if (dirty & /*excludedFiles*/ 2 && t12_value !== (t12_value = /*excludedFiles*/ ctx[1].length + "")) set_data(t12, t12_value);

			if (dirty & /*showAllHidden*/ 16 && input3_value_value !== (input3_value_value = /*showAllHidden*/ ctx[4] ? "Hide" : "Show")) {
				input3.value = input3_value_value;
			}

			if (dirty & /*excludedFiles*/ 2) {
				each_value = /*excludedFiles*/ ctx[1];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$2(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$2(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(ul, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*showAllHidden*/ 16 && div2_style_value !== (div2_style_value = /*showAllHidden*/ ctx[4]
			? "display:block"
			: "display:none")) {
				attr(div2, "style", div2_style_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(h2);
			if (detaching) detach(t1);
			if (detaching) detach(div4);
			/*select_binding*/ ctx[10](null);
			/*input0_binding*/ ctx[11](null);
			destroy_each(each_blocks_1, detaching);
			destroy_each(each_blocks, detaching);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { app } = $$props;
	let { plugin } = $$props;
	let excludedList;
	const excludedFolders = plugin.settings.get("exluded_folders");

	// TODO show all excluded files in TextEdit not list
	// Select box based on https://www.c-sharpcorner.com/UploadFile/mahakgupta/add-and-remove-listbox-items-in-javascript/
	const allFolders = GetAllFolders(app);

	var listOptionsNo = 0;
	let excludedFiles = allExcludedFiles();

	onMount(() => {
		// create select entries for all already excluded folders
		excludedFolders.forEach(folder => {
			$$invalidate(0, excludedList.options[listOptionsNo] = new Option(folder, folder), excludedList);
			listOptionsNo++;
		});
	});

	function allExcludedFiles() {
		return app.vault.getFiles().map(file => file.path).filter(pathToFile => {
			return excludedFolders.some(path => pathToFile.startsWith(path));
		});
	}

	let excludePathInputValue;
	let excludePathInput;
	let showAllHidden = false;

	/** update the list of exluded files and save the updated settings*/
	function save() {
		$$invalidate(1, excludedFiles = allExcludedFiles());
		plugin.settings.set({ exluded_folders: excludedFolders });
	}

	function addValue() {
		if (!excludePathInputValue) {
			return;
		}

		// Return if folder doesn't exist
		if (!allFolders.contains(excludePathInputValue)) {
			alert("Please choose a folder from the list");
			return;
		}

		// Return if folder already on list
		if (excludedFolders.contains(excludePathInputValue)) {
			$$invalidate(3, excludePathInput.value = "", excludePathInput);
			$$invalidate(2, excludePathInputValue = "");
			return;
		}

		// add option to select box
		$$invalidate(0, excludedList.options[listOptionsNo++] = new Option(excludePathInputValue, excludePathInputValue), excludedList);

		excludedFolders.push(excludePathInputValue);

		// reset input field
		$$invalidate(3, excludePathInput.value = "", excludePathInput);

		$$invalidate(2, excludePathInputValue = "");
		save();
		return true;
	}

	function deleteValue() {
		let s = 1;
		let index;

		if (excludedList.selectedIndex === -1) {
			alert("Please select an item from the list");
			return true;
		}

		while (s > 0) {
			index = excludedList.selectedIndex;

			if (index >= 0) {
				excludedFolders.remove(excludedList.options[index].value);
				$$invalidate(0, excludedList.options[index] = null, excludedList);
				--listOptionsNo;
			} else s = 0;
		}

		save();
		return true;
	}

	function select_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			excludedList = $$value;
			$$invalidate(0, excludedList);
		});
	}

	function input0_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			excludePathInput = $$value;
			$$invalidate(3, excludePathInput);
		});
	}

	function input0_input_handler() {
		excludePathInputValue = this.value;
		$$invalidate(2, excludePathInputValue);
	}

	const click_handler = () => {
		addValue();
	};

	const click_handler_1 = () => {
		deleteValue();
	};

	const click_handler_2 = () => {
		$$invalidate(4, showAllHidden = !showAllHidden);
	};

	$$self.$$set = $$props => {
		if ('app' in $$props) $$invalidate(8, app = $$props.app);
		if ('plugin' in $$props) $$invalidate(9, plugin = $$props.plugin);
	};

	return [
		excludedList,
		excludedFiles,
		excludePathInputValue,
		excludePathInput,
		showAllHidden,
		allFolders,
		addValue,
		deleteValue,
		app,
		plugin,
		select_binding,
		input0_binding,
		input0_input_handler,
		click_handler,
		click_handler_1,
		click_handler_2
	];
}

class ExcludedFolders extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { app: 8, plugin: 9 }, add_css$2);
	}
}

/* src/svelte/settings/ExcludedFilenames.svelte generated by Svelte v3.59.2 */

function add_css$1(target) {
	append_styles(target, "svelte-1cxhpyg", ".svelte-1cxhpyg{font-size:1em}h2.svelte-1cxhpyg{text-align:left}div#exlude-filenames.svelte-1cxhpyg{display:flex;flex-wrap:wrap;column-gap:10px}div#list-excluded.svelte-1cxhpyg{width:300px}#excluded-select.svelte-1cxhpyg{height:300px;width:300px;font-size:1em;overflow:auto}#add-remove-exluded.svelte-1cxhpyg{height:300px;width:300px}div#currently-excluded.svelte-1cxhpyg{width:600px;max-height:300px;overflow:hidden}div#currently-excluded-list.svelte-1cxhpyg{overflow:auto;max-height:260px}");
}

function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[20] = list[i];
	return child_ctx;
}

// (133:8) {#each excludedFiles as file_path}
function create_each_block$1(ctx) {
	let li;
	let t_value = /*file_path*/ ctx[20] + "";
	let t;

	return {
		c() {
			li = element("li");
			t = text(t_value);
			attr(li, "class", "svelte-1cxhpyg");
		},
		m(target, anchor) {
			insert(target, li, anchor);
			append(li, t);
		},
		p(ctx, dirty) {
			if (dirty & /*excludedFiles*/ 2 && t_value !== (t_value = /*file_path*/ ctx[20] + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) detach(li);
		}
	};
}

function create_fragment$1(ctx) {
	let h2;
	let t1;
	let br0;
	let br1;
	let t2;
	let div4;
	let div0;
	let select;
	let t3;
	let div1;
	let label;
	let t5;
	let input0;
	let t6;
	let br2;
	let t7;
	let br3;
	let t8;
	let input1;
	let br4;
	let t9;
	let input2;
	let br5;
	let br6;
	let t10;
	let div3;
	let t11;
	let t12_value = /*excludedFiles*/ ctx[1].length + "";
	let t12;
	let t13;
	let input3;
	let input3_value_value;
	let t14;
	let div2;
	let ul;
	let div2_style_value;
	let mounted;
	let dispose;
	let each_value = /*excludedFiles*/ ctx[1];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	return {
		c() {
			h2 = element("h2");
			h2.textContent = "Excluded filenames";
			t1 = text("\nFilenames that contain these phrases will not be included in the Map of Content.\nThat also includes the file extension.");
			br0 = element("br");
			br1 = element("br");
			t2 = space();
			div4 = element("div");
			div0 = element("div");
			select = element("select");
			t3 = space();
			div1 = element("div");
			label = element("label");
			label.textContent = "Add a phrase:";
			t5 = space();
			input0 = element("input");
			t6 = space();
			br2 = element("br");
			t7 = space();
			br3 = element("br");
			t8 = space();
			input1 = element("input");
			br4 = element("br");
			t9 = space();
			input2 = element("input");
			br5 = element("br");
			br6 = element("br");
			t10 = space();
			div3 = element("div");
			t11 = text("Currently excluded files: ");
			t12 = text(t12_value);
			t13 = space();
			input3 = element("input");
			t14 = space();
			div2 = element("div");
			ul = element("ul");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(h2, "class", "svelte-1cxhpyg");
			attr(br0, "class", "svelte-1cxhpyg");
			attr(br1, "class", "svelte-1cxhpyg");
			attr(select, "id", "excluded-select");
			attr(select, "name", "lstValue");
			attr(select, "type", "text");
			select.multiple = true;
			attr(select, "class", "svelte-1cxhpyg");
			attr(div0, "id", "list-excluded");
			attr(div0, "class", "svelte-1cxhpyg");
			attr(label, "for", "Exluded-phrases");
			attr(label, "class", "svelte-1cxhpyg");
			attr(input0, "id", "Exluded-phrases");
			attr(input0, "type", "text");
			set_style(input0, "width", "300px");
			attr(input0, "class", "svelte-1cxhpyg");
			attr(br2, "class", "svelte-1cxhpyg");
			attr(br3, "class", "svelte-1cxhpyg");
			attr(input1, "type", "button");
			attr(input1, "name", "add");
			input1.value = "Add";
			attr(input1, "class", "svelte-1cxhpyg");
			attr(br4, "class", "svelte-1cxhpyg");
			attr(input2, "type", "button");
			attr(input2, "name", "delete");
			input2.value = "Delete";
			attr(input2, "class", "svelte-1cxhpyg");
			attr(br5, "class", "svelte-1cxhpyg");
			attr(br6, "class", "svelte-1cxhpyg");
			attr(div1, "id", "add-remove-exluded");
			attr(div1, "class", "svelte-1cxhpyg");
			attr(input3, "type", "button");
			attr(input3, "name", "toggle-show-hidden");
			input3.value = input3_value_value = /*showAllHidden*/ ctx[4] ? "Hide" : "Show";
			attr(input3, "class", "svelte-1cxhpyg");
			attr(ul, "class", "svelte-1cxhpyg");

			attr(div2, "style", div2_style_value = /*showAllHidden*/ ctx[4]
			? "display:block"
			: "display:none");

			attr(div2, "id", "currently-excluded-list");
			attr(div2, "class", "svelte-1cxhpyg");
			attr(div3, "id", "currently-excluded");
			attr(div3, "class", "svelte-1cxhpyg");
			attr(div4, "id", "exlude-filenames");
			attr(div4, "class", "svelte-1cxhpyg");
		},
		m(target, anchor) {
			insert(target, h2, anchor);
			insert(target, t1, anchor);
			insert(target, br0, anchor);
			insert(target, br1, anchor);
			insert(target, t2, anchor);
			insert(target, div4, anchor);
			append(div4, div0);
			append(div0, select);
			/*select_binding*/ ctx[9](select);
			append(div4, t3);
			append(div4, div1);
			append(div1, label);
			append(div1, t5);
			append(div1, input0);
			/*input0_binding*/ ctx[10](input0);
			set_input_value(input0, /*excludePhraseInputValue*/ ctx[2]);
			append(div1, t6);
			append(div1, br2);
			append(div1, t7);
			append(div1, br3);
			append(div1, t8);
			append(div1, input1);
			append(div1, br4);
			append(div1, t9);
			append(div1, input2);
			append(div1, br5);
			append(div1, br6);
			append(div4, t10);
			append(div4, div3);
			append(div3, t11);
			append(div3, t12);
			append(div3, t13);
			append(div3, input3);
			append(div3, t14);
			append(div3, div2);
			append(div2, ul);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(ul, null);
				}
			}

			if (!mounted) {
				dispose = [
					listen(input0, "input", /*input0_input_handler*/ ctx[11]),
					listen(input1, "click", /*click_handler*/ ctx[12]),
					listen(input2, "click", /*click_handler_1*/ ctx[13]),
					listen(input3, "click", /*click_handler_2*/ ctx[14])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (dirty & /*excludePhraseInputValue*/ 4 && input0.value !== /*excludePhraseInputValue*/ ctx[2]) {
				set_input_value(input0, /*excludePhraseInputValue*/ ctx[2]);
			}

			if (dirty & /*excludedFiles*/ 2 && t12_value !== (t12_value = /*excludedFiles*/ ctx[1].length + "")) set_data(t12, t12_value);

			if (dirty & /*showAllHidden*/ 16 && input3_value_value !== (input3_value_value = /*showAllHidden*/ ctx[4] ? "Hide" : "Show")) {
				input3.value = input3_value_value;
			}

			if (dirty & /*excludedFiles*/ 2) {
				each_value = /*excludedFiles*/ ctx[1];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(ul, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*showAllHidden*/ 16 && div2_style_value !== (div2_style_value = /*showAllHidden*/ ctx[4]
			? "display:block"
			: "display:none")) {
				attr(div2, "style", div2_style_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(h2);
			if (detaching) detach(t1);
			if (detaching) detach(br0);
			if (detaching) detach(br1);
			if (detaching) detach(t2);
			if (detaching) detach(div4);
			/*select_binding*/ ctx[9](null);
			/*input0_binding*/ ctx[10](null);
			destroy_each(each_blocks, detaching);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { app } = $$props;
	let { plugin } = $$props;
	let excludedList;
	const excludedFilenameComponents = plugin.settings.get("exluded_filename_components");
	const allFiles = app.vault.getFiles().map(file => file.basename + "." + file.extension);
	let excludedFiles = allExcludedFiles();

	// TODO show all exluded files in TextEdit not list
	// add all existing excluded folders to select element
	let listOptionsNo = 0;

	onMount(() => {
		// create select entries for all already excluded filename components
		excludedFilenameComponents.forEach(folder => {
			$$invalidate(0, excludedList.options[listOptionsNo] = new Option(folder, folder), excludedList);
			listOptionsNo++;
		});
	});

	function allExcludedFiles() {
		return allFiles.filter(filename => {
			return excludedFilenameComponents.some(path => filename.contains(path));
		});
	}

	let excludePhraseInputValue;
	let excludePhraseInput;
	let showAllHidden = false;

	/** update the list of exluded files and save the updated settings*/
	function save() {
		$$invalidate(1, excludedFiles = allExcludedFiles());

		plugin.settings.set({
			exluded_filename_components: excludedFilenameComponents
		});
	}

	function addValue() {
		if (!excludePhraseInputValue) {
			return;
		}

		// Return if folder already on list
		if (excludedFilenameComponents.contains(excludePhraseInputValue)) {
			$$invalidate(3, excludePhraseInput.value = "", excludePhraseInput);
			$$invalidate(2, excludePhraseInputValue = "");
			return;
		}

		// add option to select box
		$$invalidate(0, excludedList.options[listOptionsNo++] = new Option(excludePhraseInputValue, excludePhraseInputValue), excludedList);

		excludedFilenameComponents.push(excludePhraseInputValue);

		// reset input field
		$$invalidate(3, excludePhraseInput.value = "", excludePhraseInput);

		$$invalidate(2, excludePhraseInputValue = "");
		save();
		return true;
	}

	function deleteValue() {
		let s = 1;
		let selectedIndex;

		if (excludedList.selectedIndex === -1) {
			alert("Please select an item from the list");
			return true;
		}

		while (s > 0) {
			selectedIndex = excludedList.selectedIndex;

			if (selectedIndex >= 0) {
				excludedFilenameComponents.remove(excludedList.options[selectedIndex].value);
				$$invalidate(0, excludedList.options[selectedIndex] = null, excludedList);
				--listOptionsNo;
			} else s = 0;
		}

		save();
		return true;
	}

	function select_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			excludedList = $$value;
			$$invalidate(0, excludedList);
		});
	}

	function input0_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			excludePhraseInput = $$value;
			$$invalidate(3, excludePhraseInput);
		});
	}

	function input0_input_handler() {
		excludePhraseInputValue = this.value;
		$$invalidate(2, excludePhraseInputValue);
	}

	const click_handler = () => {
		addValue();
	};

	const click_handler_1 = () => {
		deleteValue();
	};

	const click_handler_2 = () => {
		$$invalidate(4, showAllHidden = !showAllHidden);
	};

	$$self.$$set = $$props => {
		if ('app' in $$props) $$invalidate(7, app = $$props.app);
		if ('plugin' in $$props) $$invalidate(8, plugin = $$props.plugin);
	};

	return [
		excludedList,
		excludedFiles,
		excludePhraseInputValue,
		excludePhraseInput,
		showAllHidden,
		addValue,
		deleteValue,
		app,
		plugin,
		select_binding,
		input0_binding,
		input0_input_handler,
		click_handler,
		click_handler_1,
		click_handler_2
	];
}

class ExcludedFilenames extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { app: 7, plugin: 8 }, add_css$1);
	}
}

/* src/svelte/Settings.svelte generated by Svelte v3.59.2 */

function add_css(target) {
	append_styles(target, "svelte-1kl37fi", "#settings-container.svelte-1kl37fi{position:relative;height:100%;width:100%}#CN-select.svelte-1kl37fi{min-width:200px;width:50%;font-size:1em}#update-CN-path-button.svelte-1kl37fi{margin-left:auto;margin-right:auto}h2.svelte-1kl37fi{text-align:left}");
}

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[13] = list[i];
	return child_ctx;
}

// (46:12) {#each allFiles as filepath}
function create_each_block(ctx) {
	let option;

	return {
		c() {
			option = element("option");
			option.__value = /*filepath*/ ctx[13];
			option.value = option.__value;
		},
		m(target, anchor) {
			insert(target, option, anchor);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(option);
		}
	};
}

function create_fragment(ctx) {
	let div3;
	let div0;
	let h20;
	let t1;
	let span;
	let t2_value = /*plugin*/ ctx[1].settings.get("CN_path") + "";
	let t2;
	let br0;
	let t3;
	let label0;
	let t5;
	let input0;
	let t6;
	let datalist;
	let t7;
	let button;
	let t9;
	let br1;
	let t10;
	let div1;
	let h21;
	let t12;
	let label1;
	let input1;
	let input1_checked_value;
	let t14;
	let br2;
	let t15;
	let div2;
	let h22;
	let t17;
	let label2;
	let input2;
	let input2_checked_value;
	let t19;
	let br3;
	let t20;
	let label3;
	let input3;
	let input3_checked_value;
	let t22;
	let br4;
	let t23;
	let label4;
	let input4;
	let input4_checked_value;
	let t25;
	let br5;
	let t26;
	let excludedfolders;
	let t27;
	let excludedfilenames;
	let t28;
	let p;
	let current;
	let mounted;
	let dispose;
	let each_value = /*allFiles*/ ctx[4];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	excludedfolders = new ExcludedFolders({
			props: {
				app: /*app*/ ctx[0],
				plugin: /*plugin*/ ctx[1]
			}
		});

	excludedfilenames = new ExcludedFilenames({
			props: {
				app: /*app*/ ctx[0],
				plugin: /*plugin*/ ctx[1]
			}
		});

	return {
		c() {
			div3 = element("div");
			div0 = element("div");
			h20 = element("h2");
			h20.textContent = "Path of your Central Note";
			t1 = text("\n        Current path: ");
			span = element("span");
			t2 = text(t2_value);
			br0 = element("br");
			t3 = space();
			label0 = element("label");
			label0.textContent = "New path:";
			t5 = space();
			input0 = element("input");
			t6 = space();
			datalist = element("datalist");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t7 = space();
			button = element("button");
			button.textContent = "Save";
			t9 = space();
			br1 = element("br");
			t10 = space();
			div1 = element("div");
			h21 = element("h2");
			h21.textContent = "Auto-updating the Map of Content";
			t12 = space();
			label1 = element("label");
			label1.textContent = "Update when switching between files\n        ";
			input1 = element("input");
			t14 = space();
			br2 = element("br");
			t15 = space();
			div2 = element("div");
			h22 = element("h2");
			h22.textContent = "Path and descendants";
			t17 = space();
			label2 = element("label");
			label2.textContent = "Display the paths from the Central Note to the current note\n        ";
			input2 = element("input");
			t19 = space();
			br3 = element("br");
			t20 = space();
			label3 = element("label");
			label3.textContent = "Display the path from the Central Note starting at the Central Note\n        ";
			input3 = element("input");
			t22 = space();
			br4 = element("br");
			t23 = space();
			label4 = element("label");
			label4.textContent = "Remember whether a file's descendants are shown or hidden\n        ";
			input4 = element("input");
			t25 = space();
			br5 = element("br");
			t26 = space();
			create_component(excludedfolders.$$.fragment);
			t27 = space();
			create_component(excludedfilenames.$$.fragment);
			t28 = space();
			p = element("p");
			p.innerHTML = `For support, bug reports or suggesting feature ideas, visit the plugin&#39;s <a href="https://github.com/Robin-Haupt-1/Obsidian-Map-of-Content">GitHub page</a>.<br/><br/>`;
			attr(h20, "class", "svelte-1kl37fi");
			attr(span, "id", "cn-path-input");
			attr(label0, "for", "CN-select");
			attr(input0, "type", "text");
			attr(input0, "list", "notes");
			attr(input0, "id", "CN-select");
			attr(input0, "placeholder", "Start typing to see suggestions...");
			attr(input0, "class", "svelte-1kl37fi");
			attr(datalist, "id", "notes");
			attr(button, "id", "update-CN-path-button");
			attr(button, "type", "button");
			attr(button, "class", "svelte-1kl37fi");
			attr(div0, "class", "path");
			attr(h21, "class", "svelte-1kl37fi");
			attr(label1, "for", "auto-update-file-switch");
			attr(input1, "type", "checkbox");
			attr(input1, "id", "auto-update-file-switch");
			input1.checked = input1_checked_value = /*plugin*/ ctx[1].settings.get("auto_update_on_file_change");
			attr(h22, "class", "svelte-1kl37fi");
			attr(label2, "for", "do_show_paths_to_note");
			attr(input2, "type", "checkbox");
			attr(input2, "id", "do_show_paths_to_note");

			input2.checked = input2_checked_value = /*plugin*/ ctx[1].settings.get("do_show_paths_to_note")
			? "checked"
			: "";

			attr(label3, "for", "MOC_path_starts_at_CN_checkbox");
			attr(input3, "type", "checkbox");
			attr(input3, "id", "MOC_path_starts_at_CN_checkbox");

			input3.checked = input3_checked_value = /*plugin*/ ctx[1].settings.get("MOC_path_starts_at_CN")
			? "checked"
			: "";

			attr(label4, "for", "do_remember_expanded_checkbox");
			attr(input4, "type", "checkbox");
			attr(input4, "id", "do_remember_expanded_checkbox");
			input4.checked = input4_checked_value = /*plugin*/ ctx[1].settings.get("do_remember_expanded");
			attr(div3, "id", "settings-container");
			attr(div3, "class", "svelte-1kl37fi");
		},
		m(target, anchor) {
			insert(target, div3, anchor);
			append(div3, div0);
			append(div0, h20);
			append(div0, t1);
			append(div0, span);
			append(span, t2);
			append(div0, br0);
			append(div0, t3);
			append(div0, label0);
			append(div0, t5);
			append(div0, input0);
			/*input0_binding*/ ctx[6](input0);
			set_input_value(input0, /*cnPathInputValue*/ ctx[3]);
			append(div0, t6);
			append(div0, datalist);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(datalist, null);
				}
			}

			append(div0, t7);
			append(div0, button);
			append(div3, t9);
			append(div3, br1);
			append(div3, t10);
			append(div3, div1);
			append(div1, h21);
			append(div1, t12);
			append(div1, label1);
			append(div1, input1);
			append(div3, t14);
			append(div3, br2);
			append(div3, t15);
			append(div3, div2);
			append(div2, h22);
			append(div2, t17);
			append(div2, label2);
			append(div2, input2);
			append(div2, t19);
			append(div2, br3);
			append(div2, t20);
			append(div2, label3);
			append(div2, input3);
			append(div2, t22);
			append(div2, br4);
			append(div2, t23);
			append(div2, label4);
			append(div2, input4);
			append(div3, t25);
			append(div3, br5);
			append(div3, t26);
			mount_component(excludedfolders, div3, null);
			append(div3, t27);
			mount_component(excludedfilenames, div3, null);
			append(div3, t28);
			append(div3, p);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input0, "input", /*input0_input_handler*/ ctx[7]),
					listen(button, "click", /*click_handler*/ ctx[8]),
					listen(input1, "click", /*click_handler_1*/ ctx[9]),
					listen(input2, "click", /*click_handler_2*/ ctx[10]),
					listen(input3, "click", /*click_handler_3*/ ctx[11]),
					listen(input4, "click", /*click_handler_4*/ ctx[12])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if ((!current || dirty & /*plugin*/ 2) && t2_value !== (t2_value = /*plugin*/ ctx[1].settings.get("CN_path") + "")) set_data(t2, t2_value);

			if (dirty & /*cnPathInputValue*/ 8 && input0.value !== /*cnPathInputValue*/ ctx[3]) {
				set_input_value(input0, /*cnPathInputValue*/ ctx[3]);
			}

			if (dirty & /*allFiles*/ 16) {
				each_value = /*allFiles*/ ctx[4];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(datalist, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (!current || dirty & /*plugin*/ 2 && input1_checked_value !== (input1_checked_value = /*plugin*/ ctx[1].settings.get("auto_update_on_file_change"))) {
				input1.checked = input1_checked_value;
			}

			if (!current || dirty & /*plugin*/ 2 && input2_checked_value !== (input2_checked_value = /*plugin*/ ctx[1].settings.get("do_show_paths_to_note")
			? "checked"
			: "")) {
				input2.checked = input2_checked_value;
			}

			if (!current || dirty & /*plugin*/ 2 && input3_checked_value !== (input3_checked_value = /*plugin*/ ctx[1].settings.get("MOC_path_starts_at_CN")
			? "checked"
			: "")) {
				input3.checked = input3_checked_value;
			}

			if (!current || dirty & /*plugin*/ 2 && input4_checked_value !== (input4_checked_value = /*plugin*/ ctx[1].settings.get("do_remember_expanded"))) {
				input4.checked = input4_checked_value;
			}

			const excludedfolders_changes = {};
			if (dirty & /*app*/ 1) excludedfolders_changes.app = /*app*/ ctx[0];
			if (dirty & /*plugin*/ 2) excludedfolders_changes.plugin = /*plugin*/ ctx[1];
			excludedfolders.$set(excludedfolders_changes);
			const excludedfilenames_changes = {};
			if (dirty & /*app*/ 1) excludedfilenames_changes.app = /*app*/ ctx[0];
			if (dirty & /*plugin*/ 2) excludedfilenames_changes.plugin = /*plugin*/ ctx[1];
			excludedfilenames.$set(excludedfilenames_changes);
		},
		i(local) {
			if (current) return;
			transition_in(excludedfolders.$$.fragment, local);
			transition_in(excludedfilenames.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(excludedfolders.$$.fragment, local);
			transition_out(excludedfilenames.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div3);
			/*input0_binding*/ ctx[6](null);
			destroy_each(each_blocks, detaching);
			destroy_component(excludedfolders);
			destroy_component(excludedfilenames);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { app } = $$props;
	let { plugin } = $$props;
	let cnInput;

	// TODO check the db is complete before allow settings changes (maybe have this svelte only do that and load all other components from other svelte files)
	// TODO lazy load all the file names and folders?
	// get list of all files for dropdown menu
	let allFiles = app.vault.getFiles().map(file => file.path);

	devLog("Central note path: " + plugin.settings.get("CN_path"));
	let cnPathInputValue;

	const updateCNPath = () => {
		if (!cnPathInputValue) {
			return;
		}

		// change TLI path
		plugin.settings.set({ CN_path: cnPathInputValue });
		document.getElementById("cn-path-input").textContent = cnPathInputValue;
		new obsidian.Notice("New Central Note path saved");

		// clear selection dropdown list
		$$invalidate(2, cnInput.value = "", cnInput);

		$$invalidate(3, cnPathInputValue = "");
	};

	function input0_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			cnInput = $$value;
			$$invalidate(2, cnInput);
		});
	}

	function input0_input_handler() {
		cnPathInputValue = this.value;
		$$invalidate(3, cnPathInputValue);
	}

	const click_handler = () => {
		updateCNPath();
	};

	const click_handler_1 = () => {
		plugin.settings.set({
			auto_update_on_file_change: !plugin.settings.get("auto_update_on_file_change")
		});
	};

	const click_handler_2 = () => {
		plugin.settings.set({
			do_show_paths_to_note: !plugin.settings.get("do_show_paths_to_note")
		});
	};

	const click_handler_3 = () => {
		plugin.settings.set({
			MOC_path_starts_at_CN: !plugin.settings.get("MOC_path_starts_at_CN")
		});
	};

	const click_handler_4 = () => {
		plugin.settings.set({
			do_remember_expanded: !plugin.settings.get("do_remember_expanded")
		});
	};

	$$self.$$set = $$props => {
		if ('app' in $$props) $$invalidate(0, app = $$props.app);
		if ('plugin' in $$props) $$invalidate(1, plugin = $$props.plugin);
	};

	return [
		app,
		plugin,
		cnInput,
		cnPathInputValue,
		allFiles,
		updateCNPath,
		input0_binding,
		input0_input_handler,
		click_handler,
		click_handler_1,
		click_handler_2,
		click_handler_3,
		click_handler_4
	];
}

class Settings extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance, create_fragment, safe_not_equal, { app: 0, plugin: 1 }, add_css);
	}
}

const DEFAULT_SETTINGS = {
    CN_path: "Central Note.md",
    exluded_folders: [],
    exluded_filename_components: [],
    settings_version: "1.4.0",
    do_show_update_notice: false,
    auto_update_on_file_change: true,
    do_remember_expanded: false,
    MOC_path_starts_at_CN: false,
    file_descendants_expanded: {},
    do_show_paths_to_note: true,
};
class SettingsManager {
    constructor(plugin) {
        this.genericUpdateVersions = ["0.1.10", "0.1.12", "0.1.14", "1.2.0", "1.3.0"];
        this.silentGenericUpdateVersions = [
            "0.1.15",
            "0.1.16",
            "0.1.17",
            "0.1.18",
            "1.0.0",
            "1.1.0",
        ];
        this.plugin = plugin;
    }
    async loadSettings() {
        this.settings = Object.assign({}, DEFAULT_SETTINGS, this.upgradeSettingsVersion(await this.plugin.loadData()));
        this.saveSettings();
    }
    async saveSettings() {
        await this.plugin.saveData(this.settings);
    }
    async set(updates) {
        Object.assign(this.settings, updates);
        await this.plugin.saveData(this.settings);
    }
    get(setting) {
        return this.settings[setting];
    }
    upgradeSettingsVersion(object) {
        // TODO remove deleted/renamed files from the is_expanded object. But this is only possible once the vault is done being indexed by Obsidian
        try {
            // if fresh install, go with defaults
            if (object === undefined) {
                devLog("fresh install, returning empty settings object");
                return {};
            }
            if (object["settings_version"] === DEFAULT_SETTINGS["settings_version"]) {
                devLog("Settings already in current version");
                return Object.assign(Object.assign({}, DEFAULT_SETTINGS), object);
            }
            if (this.genericUpdateVersions.contains(object["settings_version"])) {
                console.log("performing update of settings to " +
                    DEFAULT_SETTINGS["settings_version"]);
                object["do_show_update_notice"] = true;
            }
            if (this.silentGenericUpdateVersions.contains(object["settings_version"])) {
                console.log("performing silent generic update of settings to " +
                    DEFAULT_SETTINGS["settings_version"]);
            }
            object = JSON.parse(JSON.stringify(object)); // TODO clone the object with ...
            devLog(`old settings object: ${Object.keys(object)}`);
            let oldVersion;
            // determine which version the legacy object is from
            if (!Object.keys(object).contains("settings_version")) {
                oldVersion = "pre-0.1.10";
            }
            else {
                oldVersion = object["settings_version"];
            }
            devLog("old settings version: " + oldVersion);
            if (oldVersion === "pre-0.1.10") {
                // extract the CN path from CN_path_per_vault and save it as CN_path
                devLog("Converting CN path from pre-0.1.10 to 0.1.10");
                const vaultsWithCnPath = object["CN_path_per_vault"].map((val) => val[0]);
                if (vaultsWithCnPath.contains(this.plugin.app.vault.getName())) {
                    object["CN_path"] =
                        object["CN_path_per_vault"][vaultsWithCnPath.indexOf(this.plugin.app.vault.getName())][1];
                }
                else {
                    delete object["CN_path"];
                }
                delete object["CN_path_per_vault"];
                object["settings_version"] = "0.1.10";
            }
            else {
                object["settings_version"] = DEFAULT_SETTINGS["settings_version"];
            }
            return this.upgradeSettingsVersion(object);
        }
        catch (_a) {
            return {};
        }
    }
    isExcludedFile(file) {
        if (this.get("exluded_folders").some((path) => file.path.startsWith(path))) {
            return true;
        }
        return this.get("exluded_filename_components").some((phrase) => (file.basename + "." + file.extension).contains(phrase));
    }
    isExpanded(path) {
        if (!this.get("do_remember_expanded")) {
            return true;
        }
        if (Object.keys(this.get("file_descendants_expanded")).contains(path)) {
            return this.get("file_descendants_expanded")[path];
        }
        this.set({
            file_descendants_expanded: Object.assign(Object.assign({}, this.get("file_descendants_expanded")), { [path]: true }),
        });
        return true;
    }
    setExpanded(path, newIsExpanded) {
        if (!this.get("do_remember_expanded")) {
            return;
        }
        this.set({
            file_descendants_expanded: Object.assign(Object.assign({}, this.get("file_descendants_expanded")), { [path]: newIsExpanded }),
        });
        return true;
    }
}
class MOCSettingTab extends obsidian.PluginSettingTab {
    constructor(plugin) {
        super(plugin.app, plugin);
        this.plugin = plugin;
        this.db = plugin.db;
        this._app = undefined;
    }
    display() {
        if (this._app) {
            this._app.$destroy();
            this._app = undefined;
        }
        this._app = new Settings({
            target: this.containerEl,
            props: { app: this.app, plugin: this.plugin },
        });
    }
    hide() {
        this.plugin.db.update();
    }
}

class MOCPlugin extends obsidian.Plugin {
    async onload() {
        this.settings = new SettingsManager(this);
        await this.settings.loadSettings();
        this.db = new DBManager(this);
        this.registerView(MOC_VIEW_TYPE, (leaf) => (this.view = new MOCView(leaf, this)));
        this.app.workspace.onLayoutReady(() => this.initializePlugin());
    }
    async initializePlugin() {
        this.addSettingTab(new MOCSettingTab(this));
        this.initLeaf();
        this.db.update(true);
        this.addRibbonIcon("sync", "Update Map of Content", async () => {
            await this.db.update();
        });
        this.addCommand({
            id: "rebuild-map-of-content",
            name: "Update Map of Content",
            callback: () => {
                this.db.update();
            },
        });
        this.addCommand({
            id: "show-map-of-content-pane",
            name: "Show Map of Content pane",
            callback: () => {
                this.initLeaf();
            },
        });
        this.addCommand({
            id: "open-note-as-central-note",
            name: "Set current note as Central Note",
            callback: () => {
                const errors = [];
                // make sure a file is opened
                if (this.app.workspace.getActiveFile() === null) {
                    errors.push("No file has been opened");
                }
                else if (this.settings.isExcludedFile(this.app.workspace.getActiveFile())) {
                    errors.push("This file has been excluded from the Map of Content.");
                }
                if (errors.length) {
                    new obsidian.Notice(errors[0]);
                    return;
                }
                this.settings.set({ CN_path: this.app.workspace.getActiveFile().path });
                this.db.update();
            },
        });
    }
    initLeaf() {
        if (this.app.workspace.getLeavesOfType(MOC_VIEW_TYPE).length) ;
        else {
            this.app.workspace.getRightLeaf(true).setViewState({
                type: MOC_VIEW_TYPE,
                active: true,
            });
        }
    }
    rerender() {
        if (this.view) {
            this.view.rerender();
        }
    }
    onunload() {
        if (this.view) {
            this.view.onClose();
        }
        this.app.workspace.detachLeavesOfType(MOC_VIEW_TYPE);
    }
    CNexists() {
        let exists = !(this.app.vault.getAbstractFileByPath(this.settings.get("CN_path")) ===
            null);
        return exists;
    }
    registerViewInstance(view) {
        this.view = view;
    }
    unregisterViewInstance(view) {
        this.view = undefined;
    }
}

module.exports = MOCPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
