/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  DEFAULT_SETTINGS: () => DEFAULT_SETTINGS,
  default: () => LaserBeamPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian2 = require("obsidian");

// src/settings.ts
var import_obsidian = require("obsidian");
var LaserBeamSettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian.Setting(containerEl).setName("Toggle laser beam").setDesc("Turn on/off laser beam").addButton((btn) => {
      btn.setButtonText("Toggle laser").setTooltip("Turn on/off laser").onClick((evt) => {
        this.plugin.toggleLaser(evt);
      });
    });
    new import_obsidian.Setting(containerEl).setName("Status").setDesc("Select laser status").addDropdown((sel) => {
      this.dropdownLaserMovement = sel;
      sel.addOption("dynamic", "Dynamic");
      sel.addOption("static", "Static");
      sel.onChange(async (val) => {
        this.plugin.settings.laserMovement = val;
        this.plugin.setLaserMovement(val);
        await this.plugin.saveSettings();
      }), sel.setValue(this.plugin.settings.laserMovement);
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.dropdownLaserMovement.setValue(DEFAULT_SETTINGS.laserMovement);
        this.plugin.settings.laserMovement = DEFAULT_SETTINGS.laserMovement;
        this.plugin.setLaserMovement(this.plugin.settings.laserMovement);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Focus type").setDesc("Select laser focus type").addDropdown((sel) => {
      this.dropdownLaserType = sel;
      sel.addOption("line", "Line");
      sel.addOption("area", "Area");
      sel.onChange(async (val) => {
        this.plugin.settings.laserType = val;
        this.plugin.setLaserType(val);
        await this.plugin.saveSettings();
      }), sel.setValue(this.plugin.settings.laserType);
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.dropdownLaserType.setValue(DEFAULT_SETTINGS.laserType);
        this.plugin.settings.laserType = DEFAULT_SETTINGS.laserType;
        this.plugin.setLaserType(this.plugin.settings.laserType);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Intensity").setDesc("Set laser intensity (brightness)").addSlider((sli) => {
      this.sliderIntensity = sli;
      let slider_val;
      if (this.plugin.settings.laserIntensity) {
        slider_val = this.plugin.settings.laserIntensity;
      } else {
        slider_val = DEFAULT_SETTINGS.laserIntensity;
      }
      sli.setDynamicTooltip();
      sli.setLimits(0.1, 0.8, 0.1);
      sli.setValue(slider_val);
      sli.onChange((val) => {
        this.plugin.settings.laserIntensity = val;
        this.plugin.setLaserIntensity(val);
        this.plugin.saveSettings();
      });
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.sliderIntensity.setValue(DEFAULT_SETTINGS.laserIntensity);
        this.plugin.settings.laserIntensity = DEFAULT_SETTINGS.laserIntensity;
        this.plugin.setLaserIntensity(this.plugin.settings.laserIntensity);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Line width").setDesc("Set laser line width").addSlider((sli) => {
      this.sliderWidth = sli;
      let slider_val;
      if (this.plugin.settings.laserWidth) {
        slider_val = this.plugin.settings.laserWidth;
      } else {
        slider_val = DEFAULT_SETTINGS.laserWidth;
      }
      sli.setDynamicTooltip();
      sli.setLimits(0.3, 3, 0.1);
      sli.setValue(slider_val);
      sli.onChange((val) => {
        this.plugin.settings.laserWidth = val;
        this.plugin.setLaserWidth(val);
        this.plugin.saveSettings();
      });
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.sliderWidth.setValue(DEFAULT_SETTINGS.laserWidth);
        this.plugin.settings.laserWidth = DEFAULT_SETTINGS.laserWidth;
        this.plugin.setLaserWidth(this.plugin.settings.laserWidth);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Color").setDesc("Select laser color").addDropdown((sel) => {
      this.dropdownLaserColor = sel;
      sel.addOption("blue", "Blue laser");
      sel.addOption("green", "Green laser");
      sel.addOption("orange", "Orange laser");
      sel.addOption("yellow", "Yellow laser");
      sel.addOption("red", "Red laser");
      sel.addOption("pink", "Pink laser");
      sel.addOption("purple", "Purple laser");
      sel.onChange(async (val) => {
        this.plugin.settings.laserColor = val;
        this.plugin.setLaserColor(val);
        await this.plugin.saveSettings();
      }), sel.setValue(this.plugin.settings.laserColor);
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.dropdownLaserColor.setValue(DEFAULT_SETTINGS.laserColor);
        this.plugin.settings.laserColor = DEFAULT_SETTINGS.laserColor;
        this.plugin.setLaserColor(this.plugin.settings.laserColor);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Area size").setDesc("Adjust laser area size").addSlider((sli) => {
      this.sliderArea = sli;
      let slider_val;
      if (this.plugin.settings.laserArea) {
        slider_val = this.plugin.settings.laserArea;
      } else {
        slider_val = DEFAULT_SETTINGS.laserArea;
      }
      sli.setDynamicTooltip();
      sli.setLimits(30, 200, 1);
      sli.setValue(slider_val);
      sli.onChange((val) => {
        this.plugin.settings.laserArea = val;
        this.plugin.setLaserArea(val);
        this.plugin.saveSettings();
      });
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.sliderArea.setValue(DEFAULT_SETTINGS.laserArea);
        this.plugin.settings.laserArea = DEFAULT_SETTINGS.laserArea;
        this.plugin.setLaserArea(this.plugin.settings.laserArea);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Left margin").setDesc("Set laser left margin").addSlider((sli) => {
      this.sliderMarginLeft = sli;
      let slider_val;
      if (this.plugin.settings.laserMarginLeft) {
        slider_val = this.plugin.settings.laserMarginLeft;
      } else {
        slider_val = DEFAULT_SETTINGS.laserMarginLeft;
      }
      sli.setDynamicTooltip();
      sli.setLimits(0, 500, 1);
      sli.setValue(slider_val);
      sli.onChange((val) => {
        this.plugin.settings.laserMarginLeft = val;
        this.plugin.setLaserMargins(val, this.plugin.settings.laserMarginRight);
        this.plugin.saveSettings();
      });
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.sliderMarginLeft.setValue(DEFAULT_SETTINGS.laserMarginLeft);
        this.plugin.settings.laserMarginLeft = DEFAULT_SETTINGS.laserMarginLeft;
        this.plugin.setLaserMargins(this.plugin.settings.laserMarginLeft, this.plugin.settings.laserMarginRight);
        this.plugin.saveSettings();
      });
    });
    new import_obsidian.Setting(containerEl).setName("Right margin").setDesc("Set laser right margin").addSlider((sli) => {
      this.sliderMarginRight = sli;
      let slider_val;
      if (this.plugin.settings.laserMarginRight) {
        slider_val = this.plugin.settings.laserMarginRight;
      } else {
        slider_val = DEFAULT_SETTINGS.laserMarginRight;
      }
      sli.setDynamicTooltip();
      sli.setLimits(0, 500, 1);
      sli.setValue(slider_val);
      sli.onChange((val) => {
        this.plugin.settings.laserMarginRight = val;
        this.plugin.setLaserMargins(this.plugin.settings.laserMarginLeft, val);
        this.plugin.saveSettings();
      });
    }).addExtraButton((btn) => {
      btn.setIcon("rotate-ccw");
      btn.setTooltip("Restore default");
      btn.onClick(() => {
        this.sliderMarginRight.setValue(DEFAULT_SETTINGS.laserMarginRight);
        this.plugin.settings.laserMarginRight = DEFAULT_SETTINGS.laserMarginRight;
        this.plugin.setLaserMargins(this.plugin.settings.laserMarginLeft, this.plugin.settings.laserMarginRight);
        this.plugin.saveSettings();
      });
    });
  }
};

// src/main.ts
var DEFAULT_SETTINGS = {
  isLaserActive: false,
  laserMovement: "dynamic",
  laserType: "line",
  laserColor: "blue",
  laserWidth: 1,
  laserIntensity: 0.7,
  laserArea: 82,
  laserMarginLeft: 0,
  laserMarginRight: 0
};
var LaserBeamPlugin = class extends import_obsidian2.Plugin {
  constructor() {
    super(...arguments);
    this.LB_ICON = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 4V2"/><path d="M15 16v-2"/><path d="M8 9h2"/><path d="M20 9h2"/><path d="M17.8 11.8 19 13"/><path d="M15 9h0"/><path d="M17.8 6.2 19 5"/><path d="m3 21 9-9"/><path d="M12.2 6.2 11 5"/></svg>';
  }
  async onload() {
    await this.loadSettings();
    this.LB_BODY = document.body;
    (0, import_obsidian2.addIcon)("wand-1", this.LB_ICON);
    if (this.settings.isLaserActive) {
      this.activateLaser();
    }
    this.addRibbonIcon("wand-1", "Laser beam", (evt) => {
      this.toggleLaser(evt);
    });
    this.addCommand({
      id: "laser-activate",
      name: "Toggle laser",
      callback: () => {
        if (this.settings.isLaserActive) {
          this.deactivateLaser();
        } else {
          this.activateLaser();
        }
      }
    });
    this.addCommand({
      id: "laser-focus",
      name: "Toggle laser focus type",
      callback: () => {
        if (this.settings.laserType === "line") {
          this.settings.laserType = "area";
          this.setLaserType(this.settings.laserType);
          this.saveSettings();
        } else {
          this.settings.laserType = "line";
          this.setLaserType(this.settings.laserType);
          this.saveSettings();
        }
      }
    });
    this.addSettingTab(new LaserBeamSettingTab(this.app, this));
    this.registerDomEvent(document, "mousemove", this.throttle((evt) => {
      if (this.settings.isLaserActive && this.settings.laserMovement === "dynamic") {
        this.setLaserPos(evt);
      } else {
        return;
      }
    }, 50));
    this.registerDomEvent(document, "keyup", () => {
      this.getCaretPos(this.LB_BODY);
    });
    this.registerDomEvent(document, "click", () => {
      this.getCaretPos(this.LB_BODY);
    });
  }
  throttle(fn, delay) {
    let isWaiting = false;
    return (evt) => {
      if (!isWaiting) {
        fn(evt);
        isWaiting = true;
        setTimeout(() => {
          isWaiting = false;
        }, delay);
      }
    };
  }
  toggleLaser(evt) {
    if (this.settings.isLaserActive) {
      this.deactivateLaser();
    } else {
      this.setLaserPos(evt);
      this.activateLaser();
    }
  }
  activateLaser() {
    this.LB_BODY.classList.add("lb-laser-active");
    this.setLaserType(this.settings.laserType);
    this.setLaserMovement(this.settings.laserMovement);
    this.setLaserColor(this.settings.laserColor);
    this.setLaserIntensity(this.settings.laserIntensity);
    this.setLaserWidth(this.settings.laserWidth);
    this.setLaserArea(this.settings.laserArea);
    this.setLaserMargins(this.settings.laserMarginLeft, this.settings.laserMarginRight);
    this.settings.isLaserActive = true;
    this.saveSettings();
  }
  deactivateLaser() {
    this.LB_BODY.classList.remove("lb-laser-active");
    this.settings.isLaserActive = false;
    this.saveSettings();
  }
  setLaserType(val) {
    ["lb-laser-type-line", "lb-laser-type-area"].map((c) => {
      this.LB_BODY.classList.remove(c);
    });
    switch (val) {
      case "line":
        this.LB_BODY.classList.add("lb-laser-type-line");
        break;
      case "area":
        this.LB_BODY.classList.add("lb-laser-type-area");
        break;
      default:
        this.LB_BODY.classList.add("lb-laser-type-line");
    }
  }
  setLaserColor(val) {
    ["lb-laser-blue", "lb-laser-green", "lb-laser-orange", "lb-laser-yellow", "lb-laser-red", "lb-laser-pink", "lb-laser-purple"].map((c) => this.LB_BODY.classList.remove(c));
    switch (val) {
      case "blue":
        this.LB_BODY.classList.add("lb-laser-blue");
        break;
      case "green":
        this.LB_BODY.classList.add("lb-laser-green");
        break;
      case "orange":
        this.LB_BODY.classList.add("lb-laser-orange");
        break;
      case "yellow":
        this.LB_BODY.classList.add("lb-laser-yellow");
        break;
      case "red":
        this.LB_BODY.classList.add("lb-laser-red");
        break;
      case "pink":
        this.LB_BODY.classList.add("lb-laser-pink");
        break;
      case "purple":
        this.LB_BODY.classList.add("lb-laser-purple");
        break;
      default:
        this.LB_BODY.classList.add("lb-laser-blue");
    }
  }
  setLaserPos(evt) {
    let laserBeamPos;
    if (this.settings.laserType === "line") {
      laserBeamPos = evt.clientY + 16;
    } else {
      laserBeamPos = evt.clientY - this.settings.laserArea / 2;
    }
    this.LB_BODY.style.setProperty("--lb-laser-top", laserBeamPos.toString() + "px");
  }
  setLaserArea(val) {
    if (val >= 30 && val <= 200) {
      this.LB_BODY.style.setProperty("--lb-laser-area", val.toString() + "px");
    }
  }
  setLaserWidth(val) {
    if (val >= 0.3 && val <= 3) {
      this.LB_BODY.style.setProperty("--lb-laser-width", val.toString());
    }
  }
  setLaserIntensity(val) {
    if (val >= 0.1 && val <= 0.8) {
      this.LB_BODY.style.setProperty("--lb-laser-intensity", val.toString());
    }
  }
  setLaserMargins(val1, val2) {
    if (val1 >= 0 && val1 <= 500) {
      this.LB_BODY.style.setProperty("--lb-laser-margin-left", val1.toString() + "px");
    }
    if (val2 >= 0 && val2 <= 500) {
      this.LB_BODY.style.setProperty("--lb-laser-margin-right", val2.toString() + "px");
    }
  }
  setLaserMovement(val) {
    if (["dynamic", "static"].includes(val)) {
      this.settings.laserMovement = val;
    }
    this.LB_BODY.classList.remove("lb-laser-static");
    if (val === "static") {
      this.LB_BODY.classList.add("lb-laser-static");
    } else {
      this.LB_BODY.classList.remove("lb-laser-static");
    }
  }
  getCaretPos(el) {
    var _a;
    const computedStyle = window.getComputedStyle(this.LB_BODY);
    this.lbFontSize = computedStyle.getPropertyValue("--font-text-size");
    try {
      this.cl_editor = (_a = this.app.workspace.getActiveViewOfType(import_obsidian2.MarkdownView)) == null ? void 0 : _a.editor;
      const caretPos = this.cl_editor.cm.coordsAtPos(this.cl_editor.posToOffset(this.cl_editor.getCursor()));
      let pos;
      if (this.settings.laserType === "line") {
        pos = caretPos.bottom + 5;
        el.style.setProperty("--lb-laser-top", pos.toString() + "px");
      } else {
        pos = caretPos.bottom - parseInt(this.lbFontSize) + 5 - this.settings.laserArea / 2;
        el.style.setProperty("--lb-laser-top", pos.toString() + "px");
      }
    } catch (e) {
      return;
    }
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign(
      {},
      DEFAULT_SETTINGS,
      await this.loadData()
    );
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
//# sourceMappingURL=data:application/json;base64,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
