/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => JsonTablePlugin
});
module.exports = __toCommonJS(main_exports);

// src/md.utils.ts
function trimSeperatorSpaces(string) {
  return string.replace(/([^\S\r\n]*[|][^\S\r\n]*)/g, "|");
}
function getTableLines(content) {
  return content.split("\n").map((line) => line.trim()).filter((line) => line.length > 0);
}
function getRowContent(line) {
  return line.slice(1, -1).split("|").map((content) => content.trim());
}
function parseHeader(header) {
  const keys = header.split(".");
  const isArray = keys.map((key) => key.includes("["));
  const indices = keys.map((key) => {
    const match = key.match(/\[(\d+)\]/);
    return match ? parseInt(match[1]) : void 0;
  }).filter((index) => index !== void 0);
  return { keys, isArray, indices };
}
function createHeaderRow(headers) {
  return removeDuplicateWhitespaces(`| ${headers.join(" | ")} |`);
}
function createSeparatorRow(headers) {
  return removeDuplicateWhitespaces(
    `| ${headers.map(() => "---").join(" | ")} |`
  );
}
function createDataRow(data, headers) {
  return `| ${headers.map((header) => data[header] !== void 0 ? `${data[header]}` : "").join(" | ")} |`;
}
function removeDuplicateWhitespaces(row) {
  return row.replace(/( +)/g, " ");
}

// src/json.utils.ts
function isObject(input) {
  return typeof input === "object" && input !== null;
}
function handleArray(value, key, prefix) {
  const flatObject = {};
  value.forEach((item, index) => {
    if (isObject(item)) {
      Object.assign(
        flatObject,
        flattenStructure(item, `${prefix}${key}[${index}].`)
      );
    } else if (item !== void 0) {
      flatObject[`${prefix}${key}[${index}]`] = item;
    }
  });
  return flatObject;
}
function handleValue(value, key, prefix) {
  const flatObject = {};
  const newKey = `${prefix}${key}`;
  if (isObject(value)) {
    Object.assign(flatObject, flattenStructure(value, `${newKey}.`));
  } else if (value !== void 0) {
    flatObject[newKey] = value;
  }
  return flatObject;
}
function flattenStructure(input, prefix = "") {
  const flatObject = {};
  if (!isObject(input)) {
    return flatObject;
  }
  for (const key in input) {
    const value = input[key];
    if (Array.isArray(value)) {
      Object.assign(flatObject, handleArray(value, key, prefix));
    } else {
      Object.assign(flatObject, handleValue(value, key, prefix));
    }
  }
  return flatObject;
}
function collectAllKeys(input) {
  const keys = [];
  for (const obj of input) {
    const jsonObject = flattenStructure(obj);
    for (const key in jsonObject) {
      if (jsonObject.hasOwnProperty(key) && !keys.includes(key)) {
        keys.push(key);
      }
    }
  }
  return keys;
}
function getNestedObject(rowObject, keys, isArray, indices) {
  let current = rowObject;
  for (let j = 0; j < keys.length - 1; j++) {
    const key = keys[j].replace(/\[\d+\]/, "");
    if (isArray[j]) {
      if (!Array.isArray(current[key])) {
        current[key] = [];
      }
      if (indices[j] !== void 0) {
        const arrayCurrent = current[key];
        if (typeof arrayCurrent[indices[j]] !== "object" || arrayCurrent[indices[j]] === null) {
          arrayCurrent[indices[j]] = {};
        }
        current = arrayCurrent[indices[j]];
      }
    } else {
      if (typeof current[key] !== "object" || current[key] === null) {
        current[key] = {};
      }
      current = current[key];
    }
  }
  return current;
}
function convertToPrimitive(input) {
  const check = `${input}`.toLowerCase();
  if (check === "true") {
    return true;
  } else if (check === "false") {
    return false;
  } else if (check === "null") {
    return null;
  } else if (check === "undefined") {
    return void 0;
  } else if (check === "") {
    return void 0;
  } else if (check === "0") {
    return 0;
  } else if (check.startsWith("0")) {
    return input;
  } else if (!isNaN(Number(input))) {
    return Number(input);
  } else {
    return input;
  }
}
function processRow(row, parsedHeaders) {
  const rowData = getRowContent(row);
  const rowObject = {};
  for (let i = 0; i < parsedHeaders.length; i++) {
    processCell(rowData[i], parsedHeaders[i], rowObject);
  }
  return rowObject;
}
function processCell(value, header, rowObject) {
  value = convertToPrimitive(value);
  if (value === void 0 || value === "") {
    return;
  }
  const { keys, isArray, indices } = header;
  const key = keys[keys.length - 1].replace(/\[\d+\]/, "");
  const current = getNestedObject(
    rowObject,
    keys,
    isArray,
    indices
  );
  if (isArray[keys.length - 1]) {
    if (!Array.isArray(current[key])) {
      current[key] = [];
    }
    current[key][indices[keys.length - 1]] = value;
  } else {
    current[key] = value;
  }
}

// src/functions.ts
function jsonToTable(content) {
  const jsonData = JSON.parse(content);
  if (!jsonData || jsonData.length === 0) {
    return "";
  }
  const flatData = jsonData.map((data) => flattenStructure(data));
  const headers = collectAllKeys(flatData);
  const headerRow = createHeaderRow(headers);
  const separatorRow = createSeparatorRow(headers);
  const dataRows = flatData.map(
    (data) => createDataRow(data, headers)
  );
  const markdownTable = [
    headerRow,
    separatorRow,
    ...dataRows.map((data) => {
      return removeDuplicateWhitespaces(data);
    })
  ].join("\n");
  return markdownTable;
}
function tableToJson(content) {
  content = trimSeperatorSpaces(content);
  const lines = getTableLines(content);
  if (lines.length <= 2) {
    return [];
  }
  const headers = getRowContent(lines[0]);
  const rows = lines.slice(2);
  const parsedHeaders = headers.map(parseHeader);
  return rows.map((row) => processRow(row, parsedHeaders)).filter((row) => Object.keys(row).length > 0);
}

// src/main.ts
var import_obsidian2 = require("obsidian");

// src/settings.ts
var import_obsidian = require("obsidian");
var JsonTablePluginSettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian.Setting(containerEl).setName("Enable debug logging").setDesc("If enabled, more will be logged in the console.").addToggle(
      (toggle) => toggle.setValue(this.plugin.settings.devMode).onChange(async (value) => {
        this.plugin.settings.devMode = value;
        await this.plugin.saveSettings();
      })
    );
  }
};

// src/main.ts
var DEFAULT_SETTINGS = {
  devMode: false
};
var JsonTablePlugin = class extends import_obsidian2.Plugin {
  async onload() {
    await this.loadSettings();
    this.addCommand({
      id: "generate-table-from-selected-json",
      name: "Generate table from selected JSON",
      icon: "table",
      editorCallback: (editor) => {
        if (this.settings.devMode) {
          console.log("JSON Table Selection:", editor.getSelection());
        }
        try {
          editor.replaceSelection(jsonToTable(editor.getSelection()));
        } catch (error) {
          console.error(error);
          new import_obsidian2.Notice(error);
        }
      }
    });
    this.addCommand({
      id: "generate-table-from-selected-json-url",
      name: "Generate table from selected JSON URL",
      icon: "link",
      editorCallback: async (editor) => {
        const selection = editor.getSelection();
        try {
          const response = await (0, import_obsidian2.requestUrl)(selection);
          editor.replaceSelection(
            jsonToTable(JSON.stringify(response.json))
          );
          if (this.settings.devMode) {
            console.log(
              "JSON Table fetch response:",
              response.json
            );
          }
        } catch (error) {
          console.error(error);
          new import_obsidian2.Notice(error);
        }
      }
    });
    this.addCommand({
      id: "generate-json-from-selected-table",
      name: "Generate JSON from selected table",
      icon: "file-json",
      editorCallback: (editor) => {
        if (this.settings.devMode) {
          console.log("JSON Table Selection:", editor.getSelection());
        }
        try {
          editor.replaceSelection(
            JSON.stringify(tableToJson(editor.getSelection()))
          );
        } catch (error) {
          console.error(error);
          new import_obsidian2.Notice(error);
        }
      }
    });
    this.addSettingTab(new JsonTablePluginSettingTab(this.app, this));
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign(
      {},
      DEFAULT_SETTINGS,
      await this.loadData()
    );
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};

/* nosourcemap */