/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => InteractivityPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian = require("obsidian");
var DEFAULT_SETTINGS = {
  shellExec: "python",
  shellParams: "-iq\n##plugin##py_manager.py\n",
  executeOnLoad: 'openai.api_key = "sk-"\n',
  notice: false,
  decorateMultiline: true,
  linesToSuppress: 1,
  separatedShells: false,
  prependOutput: ">>> ",
  enviromentVariables: "PYTHONIOENCODING=utf8\n",
  executeOnUnload: "exit()\n",
  regexpCleaner: "^((>>> )|(... ))+",
  shortcuts: "@ -> ##param##\n",
  advanced: false
};
var __EVAL = (s) => (0, eval)(`void (__EVAL = ${__EVAL.toString()}); ${s}`);
var InteractivityPlugin = class extends import_obsidian.Plugin {
  constructor() {
    super(...arguments);
    this.allSubprocesses = {};
    this.warmupOnly = false;
    this.modal = false;
    this.advanced = false;
    this.byEnter = false;
    this.processingNote = "";
  }
  async onload() {
    await this.loadSettings();
    this.advanced = import_obsidian.Platform.isMobile ? false : this.settings.advanced;
    this.addSettingTab(new InteractivitySettingTab(this.app, this));
    this.registerDomEvent(document, "keydown", (evt) => {
      if (!this.modal) {
        this.warmupOnly = true;
        this.app.commands.executeCommandById("interactivity:restart");
        this.warmupOnly = false;
      }
      if (evt.keyCode == 13 && !evt.shiftKey && this.app.workspace.activeEditor) {
        this.byEnter = true;
        this.app.commands.executeCommandById("interactivity:execute");
        this.byEnter = false;
      }
    });
    this.addCommand({
      id: "execute",
      name: "Execute shell command",
      editorCallback: (editor, view) => {
        var _a, _b;
        const file = this.advanced ? this.settings.separatedShells && view.file ? view.file.path : "*" : "js";
        const cursor = editor.getCursor();
        if (import_obsidian.Platform.isMobile) {
          cursor.line++;
          cursor.ch = 0;
        }
        if (typeof this.allSubprocesses[file] !== "undefined") {
          let routine = function(that, byEnter2, ch2) {
            var _a2, _b2;
            const editor2 = (_a2 = that.app.workspace.activeEditor) == null ? void 0 : _a2.editor;
            if (!editor2)
              return;
            let selection = editor2.getSelection();
            let line = editor2.getCursor().line;
            let command = "";
            let maxLen = 0;
            for (const x of that.settings.shortcuts.split("\n")) {
              let m = x.match(/(.*?)\s*->\s*(.*)/);
              if (m && m.length > 2 && maxLen < m[1].length && editor2.getLine(cursor.line - (byEnter2 ? 1 : 0)).indexOf(m[1]) == 0) {
                command = m[2].replace(/##param##/g, editor2.getLine(cursor.line - (byEnter2 ? 1 : 0)).slice(m[1].length));
                maxLen = m[1].length;
              }
            }
            if (command === "") {
              if (selection.length == 0)
                selection = editor2.getLine(line);
              if ((selection.match(/\n/gm) || []).length) {
                let a = editor2.listSelections()[0].anchor.line;
                let b = editor2.listSelections()[0].head.line;
                if (a > b && editor2.listSelections()[0].anchor.ch == 0)
                  a--;
                if (a < b && editor2.listSelections()[0].head.ch == 0)
                  b--;
                let selections = [];
                for (let i = Math.min(a, b); i <= Math.max(a, b); i++)
                  selections.push(editor2.getLine(i));
                selection = selections.join("\n");
                line = Math.max(a, b);
              }
            } else
              selection = command;
            editor2.setCursor({ "line": line, "ch": editor2.getLine(line).length });
            if (selection.replace("\n", "").length) {
              if (that.advanced)
                that.allSubprocesses[file].stdin.write(selection + "\n");
              else {
                let output = "";
                try {
                  output = __EVAL(selection);
                } catch (e) {
                  output = e;
                }
                if (typeof output !== "undefined" && that.processingNote === ((_b2 = that.app.workspace.getActiveFile()) == null ? void 0 : _b2.path)) {
                  that.insertText(editor2, output.toString(), that.settings.decorateMultiline, that.settings.prependOutput, that.settings.notice, that.advanced, that.removeLine);
                  that.statusBarItemEl.setText("");
                }
              }
            }
          };
          const byEnter = this.byEnter;
          const ch = editor.getCursor().ch;
          this.processingNote = (_b = (_a = this.app.workspace.getActiveFile()) == null ? void 0 : _a.path) != null ? _b : "";
          if (byEnter) {
            let command = "";
            for (const x of this.settings.shortcuts.split("\n")) {
              let m = x.match(/(.*?)\s*->\s*(.*)/);
              if (m && m.length > 2 && editor.getLine(cursor.line - (byEnter ? 1 : 0)).indexOf(m[1]) == 0) {
                command = m[2].replace(/##param##/g, editor.getLine(cursor.line - (byEnter ? 1 : 0)).slice(m[1].length));
                break;
              }
            }
            if (command === "")
              return;
            if (import_obsidian.Platform.isMobile) {
              setTimeout((that, byEnter2) => {
                var _a2, _b2;
                editor.setCursor({ "line": cursor.line - (byEnter2 ? 1 : 0), "ch": editor.getLine(cursor.line - (byEnter2 ? 1 : 0)).length });
                that.statusBarItemEl.setText("Interactivity is busy\u23F3");
                routine(that, byEnter2, ch);
                (_b2 = (_a2 = that.app.workspace.activeEditor) == null ? void 0 : _a2.editor) == null ? void 0 : _b2.setCursor({ "line": cursor.line, "ch": editor.getLine(cursor.line).length });
              }, 0, this, byEnter);
            } else {
              editor.replaceRange("", { "line": cursor.line - (byEnter ? 1 : 0), "ch": editor.getLine(cursor.line - (byEnter ? 1 : 0)).length }, { "line": cursor.line, "ch": cursor.ch });
              editor.setCursor({ "line": cursor.line - (byEnter ? 1 : 0), "ch": 0 });
              this.statusBarItemEl.setText("Interactivity is busy\u23F3");
              routine(this, byEnter, ch);
            }
          } else {
            this.statusBarItemEl.setText("Interactivity is busy\u23F3");
            routine(this, byEnter, ch);
          }
        }
      }
    });
    this.addCommand({
      id: "restart",
      name: "Restart Shell",
      editorCallback: (editor, view) => {
        if (!this.warmupOnly) {
          const file = this.advanced ? this.settings.separatedShells && view.file ? view.file.path : "*" : "js";
          if (typeof this.allSubprocesses[file] !== "undefined") {
            if (this.advanced) {
              try {
                try {
                  if (this.settings.executeOnUnload)
                    this.allSubprocesses[file].stdin.write(this.settings.executeOnUnload + "\n");
                } catch (e) {
                }
                this.allSubprocesses[file].kill();
                delete this.allSubprocesses[file];
              } catch (e) {
              }
            }
          }
        }
        setTimeout((that) => {
          that.warmup(editor, view);
        }, this.warmupOnly ? 0 : 350, this);
      }
    });
    const ribbonIconEl = this.addRibbonIcon("activity", "Run Interactivity", (evt) => {
      var _a, _b;
      this.app.commands.executeCommandById("interactivity:execute");
      (_b = (_a = this.app.workspace.activeEditor) == null ? void 0 : _a.editor) == null ? void 0 : _b.focus();
    });
    this.statusBarItemEl = this.addStatusBarItem();
    this.statusBarItemEl.setText("");
    this.warmupOnly = true;
    this.app.commands.executeCommandById("interactivity:restart");
    this.warmupOnly = false;
  }
  onunload() {
    Object.entries(this.allSubprocesses).forEach(([file, s]) => {
      if (typeof this.allSubprocesses[file] !== "undefined") {
        if (this.advanced) {
          try {
            try {
              if (this.settings.executeOnUnload)
                this.allSubprocesses[file].stdin.write(this.settings.executeOnUnload + "\n");
            } catch (e) {
            }
            this.allSubprocesses[file].kill();
            delete this.allSubprocesses[file];
          } catch (e) {
          }
        }
      }
    });
    this.allSubprocesses = {};
  }
  // Remove line from the editor
  removeLine(editor, lineNumber) {
    let ret = "";
    let cur = editor.getCursor();
    if (cur.line >= lineNumber)
      cur.line--;
    editor.getValue().split("\n").forEach((line, i) => {
      if (i != lineNumber)
        ret += line + "\n";
    });
    editor.setValue(ret.slice(0, -1));
    editor.setCursor(cur);
  }
  // Prepare the subprocess
  warmup(editor, view) {
    const file = this.advanced ? this.settings.separatedShells && view.file ? view.file.path : "*" : "js";
    if (typeof this.allSubprocesses[file] === "undefined") {
      if (this.advanced) {
        const cp = require("child_process");
        if (typeof cp === "undefined") {
          new import_obsidian.Notice("Unable to run subprocess");
          return;
        }
        const p = this.app.vault.adapter instanceof import_obsidian.FileSystemAdapter ? (0, import_obsidian.normalizePath)(this.app.vault.adapter.getBasePath() + "/" + this.manifest.dir + "/1").slice(0, -1) : "";
        const params = this.settings.shellParams ? this.settings.shellParams.replace(/##plugin##/g, p).split("\n") : [];
        let enviromentVariables = {};
        this.settings.enviromentVariables.replace(/##plugin##/g, p).split("\n").forEach((line) => {
          const lines = line.split("=");
          if (lines.length > 1)
            enviromentVariables[lines[0]] = lines[1];
        });
        this.allSubprocesses[file] = cp.spawn(this.settings.shellExec.replace(/##plugin##/g, p), params, { env: enviromentVariables });
        this.allSubprocesses[file].stdin.setEncoding("utf-8");
        this.allSubprocesses[file].stdout.setEncoding("utf-8");
        this.allSubprocesses[file].stderr.setEncoding("utf-8");
        if (this.settings.executeOnLoad && this.advanced)
          this.allSubprocesses[file].stdin.write(this.settings.executeOnLoad + "\n");
        let stringsOmitted = 0;
        const that = this;
        const workspace = this.app.workspace;
        let process = function(data) {
          var _a, _b;
          if (stringsOmitted < that.settings.linesToSuppress && that.advanced) {
            stringsOmitted++;
            return;
          }
          data = data.replace(new RegExp(that.settings.regexpCleaner, "mg"), "");
          if (data.length && that.processingNote === ((_a = that.app.workspace.getActiveFile()) == null ? void 0 : _a.path)) {
            if ((_b = workspace.activeEditor) == null ? void 0 : _b.editor)
              that.insertText(workspace.activeEditor.editor, data, that.settings.decorateMultiline, that.settings.prependOutput, that.settings.notice, that.advanced, that.removeLine);
            that.statusBarItemEl.setText("");
          }
        };
        this.allSubprocesses[file].stdout.on("data", process);
        this.allSubprocesses[file].stderr.on("data", process);
      } else
        this.allSubprocesses[file] = true;
    }
  }
  // Add the output to the editor
  insertText(editor, data, decorateMultiline, prependOutput, toNotice, advanced, removeLine) {
    if (toNotice)
      new import_obsidian.Notice(data);
    else {
      const outLines = (data.match(/\n/gm) || []).length + 1;
      data = data.replace(/\r/mg, "");
      if (decorateMultiline)
        data = data.replace(/(^|[^\\])\n(?!\n*$)/g, (match, p1) => p1 + "\n" + prependOutput);
      editor.replaceRange("\n" + prependOutput + data.replace(/\n$/mg, ""), editor.getCursor());
      editor.setCursor({ "line": editor.getCursor().line + outLines - (advanced ? 1 : 0), "ch": editor.getLine(editor.getCursor().line + outLines - (advanced ? 1 : 0)).length });
    }
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
    this.onunload();
  }
  async saveSettings() {
    this.advanced = import_obsidian.Platform.isMobile ? false : this.settings.advanced;
    await this.saveData(this.settings);
  }
};
var InteractivitySettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  hide() {
    this.plugin.modal = false;
  }
  display() {
    this.plugin.modal = true;
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian.Setting(containerEl).setName("Use notifications instead of appending the output to the Obsidian notes").addToggle((toggle) => toggle.setValue(this.plugin.settings.notice).onChange(async (value) => {
      this.plugin.settings.notice = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Decorate output").setDesc("Prepend the output with custom text").addText((text) => text.setPlaceholder("Prepending text").setValue(this.plugin.settings.prependOutput).onChange(async (value) => {
      this.plugin.settings.prependOutput = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Decorate each line of the output").addToggle((toggle) => toggle.setValue(this.plugin.settings.decorateMultiline).onChange(async (value) => {
      this.plugin.settings.decorateMultiline = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Text shortcuts that run commands, one per line").setDesc("Define text shortcuts for running commands. The text before '->' is the shortcut; the text after is the command to execute. Use ##param## to include the line after the shortcut in the command. Press Shift+Enter for a new line without triggering the shortcut.").addTextArea((text) => text.setPlaceholder("shortcut->command(##param##)").setValue(this.plugin.settings.shortcuts).onChange(async (value) => {
      this.plugin.settings.shortcuts = value;
      await this.plugin.saveSettings();
    }));
    if (!import_obsidian.Platform.isMobile) {
      new import_obsidian.Setting(containerEl).setName("Advanced options").setDesc("Use external executables instead of JavaScript (unsafe!)").addToggle((toggle) => toggle.setValue(this.plugin.settings.advanced).onChange(async (value) => {
        this.plugin.settings.advanced = value;
        await this.plugin.saveSettings();
        if (this.plugin.settings.advanced) {
          shellExecEl.settingEl.removeClass("hidden");
          enviromentVariablesEl.settingEl.removeClass("hidden");
          shellParamsEl.settingEl.removeClass("hidden");
          executeOnLoadEl.settingEl.removeClass("hidden");
          executeOnUnloadEl.settingEl.removeClass("hidden");
          separatedShellsEl.settingEl.removeClass("hidden");
          regexpCleanerEl.settingEl.removeClass("hidden");
          linesToSuppressEl.settingEl.removeClass("hidden");
        } else {
          shellExecEl.settingEl.addClass("hidden");
          enviromentVariablesEl.settingEl.addClass("hidden");
          shellParamsEl.settingEl.addClass("hidden");
          executeOnLoadEl.settingEl.addClass("hidden");
          executeOnUnloadEl.settingEl.addClass("hidden");
          separatedShellsEl.settingEl.addClass("hidden");
          regexpCleanerEl.settingEl.addClass("hidden");
          linesToSuppressEl.settingEl.addClass("hidden");
        }
      }));
      const shellExecEl = new import_obsidian.Setting(containerEl).setName("Shell executable path").setDesc("Specify the path to the shell executable. Use ##plugin## to refer to the plugin's directory.").addText((text) => text.setPlaceholder("Path").setValue(this.plugin.settings.shellExec).onChange(async (value) => {
        this.plugin.settings.shellExec = value;
        await this.plugin.saveSettings();
      }));
      const enviromentVariablesEl = new import_obsidian.Setting(containerEl).setName("Enviroment variables, one per line").setDesc("Set environment variables. Use ##plugin## to refer to the plugin's directory.").addTextArea((text) => text.setPlaceholder("Enviroment variables").setValue(this.plugin.settings.enviromentVariables).onChange(async (value) => {
        this.plugin.settings.enviromentVariables = value;
        await this.plugin.saveSettings();
      }));
      const shellParamsEl = new import_obsidian.Setting(containerEl).setName("Shell CLI arguments, one per line").setDesc("Specify shell command-line arguments. Use ##plugin## to refer to the plugin's directory").addTextArea((text) => text.setPlaceholder("Shell arguments").setValue(this.plugin.settings.shellParams).onChange(async (value) => {
        this.plugin.settings.shellParams = value;
        await this.plugin.saveSettings();
      }));
      const executeOnLoadEl = new import_obsidian.Setting(containerEl).setName("Commands to run after starting the shell").addTextArea((text) => text.setPlaceholder("Shell input").setValue(this.plugin.settings.executeOnLoad).onChange(async (value) => {
        this.plugin.settings.executeOnLoad = value;
        await this.plugin.saveSettings();
      }));
      const executeOnUnloadEl = new import_obsidian.Setting(containerEl).setName("Commands to run before closing the shell").setDesc("Not executable when closing Obsidian").addTextArea((text) => text.setPlaceholder("Shell input").setValue(this.plugin.settings.executeOnUnload).onChange(async (value) => {
        this.plugin.settings.executeOnUnload = value;
        await this.plugin.saveSettings();
      }));
      const separatedShellsEl = new import_obsidian.Setting(containerEl).setName("Enable separate shell sessions for each note").setDesc("Requires more memory").addToggle((toggle) => toggle.setValue(this.plugin.settings.separatedShells).onChange(async (value) => {
        this.plugin.settings.separatedShells = value;
        await this.plugin.saveSettings();
      }));
      const regexpCleanerEl = new import_obsidian.Setting(containerEl).setName("Apply a RegExp pattern to filter the output").addText((text) => text.setPlaceholder("RegExp pattern").setValue(this.plugin.settings.regexpCleaner).onChange(async (value) => {
        this.plugin.settings.regexpCleaner = value;
        await this.plugin.saveSettings();
      }));
      const linesToSuppressEl = new import_obsidian.Setting(containerEl).setName("Specify the number of initial lines to suppress").setDesc("e.g., number of lines in shell greetings").addText((text) => text.setPlaceholder("Amount of first lines").setValue(String(this.plugin.settings.linesToSuppress)).onChange(async (value) => {
        this.plugin.settings.linesToSuppress = parseInt(value);
        await this.plugin.saveSettings();
      }));
      if (this.plugin.settings.advanced) {
        shellExecEl.settingEl.removeClass("hidden");
        enviromentVariablesEl.settingEl.removeClass("hidden");
        shellParamsEl.settingEl.removeClass("hidden");
        executeOnLoadEl.settingEl.removeClass("hidden");
        executeOnUnloadEl.settingEl.removeClass("hidden");
        separatedShellsEl.settingEl.removeClass("hidden");
        regexpCleanerEl.settingEl.removeClass("hidden");
        linesToSuppressEl.settingEl.removeClass("hidden");
      } else {
        shellExecEl.settingEl.addClass("hidden");
        enviromentVariablesEl.settingEl.addClass("hidden");
        shellParamsEl.settingEl.addClass("hidden");
        executeOnLoadEl.settingEl.addClass("hidden");
        executeOnUnloadEl.settingEl.addClass("hidden");
        separatedShellsEl.settingEl.addClass("hidden");
        regexpCleanerEl.settingEl.addClass("hidden");
        linesToSuppressEl.settingEl.addClass("hidden");
      }
    }
  }
};
