
/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => ImageInlinePlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian6 = require("obsidian");

// src/utils/conversion.ts
var Base64File = class _Base64File {
  constructor(buffer, filename) {
    this.buffer = buffer;
    this.filename = filename || "image";
  }
  get size() {
    return this.buffer.byteLength;
  }
  to64String() {
    const bytes = new Uint8Array(this.buffer);
    let binary = "";
    for (let i = 0; i < bytes.byteLength; i++) {
      binary += String.fromCharCode(bytes[i]);
    }
    return btoa(binary);
  }
  to64Link() {
    return `![${this.filename}](data:image/png;base64,${this.to64String()})`;
  }
  //class methods
  static from64Link(link) {
    const match = link.match(/!\[(.*?)\]\(data:image\/png;base64,(.*?)\)/);
    if (!match) return null;
    const filename = match[1];
    const base64 = match[2];
    const buffer = Buffer.from(base64, "base64");
    return new _Base64File(buffer, filename);
  }
  static from64String(base64, filename) {
    const buffer = Buffer.from(base64, "base64");
    return new _Base64File(buffer, filename);
  }
  static async fromFile(file) {
    const arrayBuffer = await file.arrayBuffer();
    return new _Base64File(arrayBuffer, file.name);
  }
  static async fromTFile(tfile) {
    const arrayBuffer = await tfile.vault.readBinary(tfile);
    return new _Base64File(arrayBuffer, tfile.name);
  }
};
var Base64Conversion = class {
  async fromClipboardEvent(event) {
    var _a;
    const items = (_a = event.clipboardData) == null ? void 0 : _a.items;
    if (!items) return null;
    for (let i = 0; i < items.length; i++) {
      const item = items[i];
      if (item.type.startsWith("image/")) {
        const file = item.getAsFile();
        if (file) {
          return this.fromFile(file);
        }
      }
    }
    return null;
  }
  async fromClipboard() {
    try {
      const items = await navigator.clipboard.read();
      for (const item of items) {
        if (item.types.includes("image/png") || item.types.includes("image/jpeg")) {
          const blob = await item.getType("image/png") || await item.getType("image/jpeg");
          if (blob) {
            const arrayBuffer = await blob.arrayBuffer();
            return new Base64File(arrayBuffer);
          }
        }
      }
    } catch (error) {
      console.error("Error reading from clipboard:", error);
    }
    return null;
  }
  async fromFile(file) {
    const arrayBuffer = await file.arrayBuffer();
    return new Base64File(arrayBuffer, file.name);
  }
  async fromTFile(tfile) {
    const arrayBuffer = await tfile.vault.readBinary(tfile);
    return new Base64File(arrayBuffer);
  }
  async resize(file, percentage) {
    return new Promise((resolve, reject) => {
      const blob = new Blob([file.buffer]);
      const imageUrl = URL.createObjectURL(blob);
      const img = new Image();
      img.onload = () => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        if (!ctx) {
          reject(new Error("Could not get canvas context"));
          return;
        }
        const newWidth = Math.round(img.width * (percentage / 100));
        const newHeight = Math.round(img.height * (percentage / 100));
        canvas.width = newWidth;
        canvas.height = newHeight;
        ctx.drawImage(img, 0, 0, newWidth, newHeight);
        canvas.toBlob((blob2) => {
          if (!blob2) {
            reject(new Error("Could not create blob from canvas"));
            return;
          }
          blob2.arrayBuffer().then((arrayBuffer) => {
            URL.revokeObjectURL(imageUrl);
            resolve(new Base64File(arrayBuffer));
          }).catch(reject);
        }, "image/png");
      };
      img.onerror = () => {
        URL.revokeObjectURL(imageUrl);
        reject(new Error("Failed to load image"));
      };
      img.src = imageUrl;
    });
  }
};

// src/coms/antiLinkExpand.ts
var import_view = require("@codemirror/view");
var ImageWidget = class extends import_view.WidgetType {
  constructor(imageName) {
    super();
    this.imageName = imageName;
  }
  toDOM() {
    const span = document.createElement("span");
    span.textContent = `...`;
    return span;
  }
};
var linkDecorations = import_view.ViewPlugin.fromClass(class {
  constructor(view) {
    this.decorations = this.buildDecorations(view);
  }
  update(update) {
    if (update.docChanged || update.viewportChanged) {
      this.decorations = this.buildDecorations(update.view);
    }
  }
  buildDecorations(view) {
    const decorations = [];
    const text = view.state.doc.toString();
    const regex = /data:image\/[^;]+;base64,[^)]+/g;
    let match;
    while ((match = regex.exec(text)) !== null) {
      const start = match.index;
      const end = start + match[0].length;
      decorations.push(import_view.Decoration.replace({
        widget: new ImageWidget(match[0]),
        inclusive: true
      }).range(start, end));
    }
    return import_view.Decoration.set(decorations, true);
  }
}, {
  decorations: (v) => v.decorations
});

// src/comsContext/export.ts
var import_obsidian = require("obsidian");
var ExportToVaultModal = class extends import_obsidian.Modal {
  constructor(app, filename, buffer) {
    super(app);
    this.filename = filename;
    this.buffer = buffer;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h2", { text: "Export to Vault" });
    const form = contentEl.createEl("form");
    const filenameContainer = form.createEl("div", { cls: "setting-item" });
    filenameContainer.createEl("label", { text: "Filename" });
    const filenameInput = filenameContainer.createEl("input", {
      type: "text",
      value: this.filename
    });
    const buttonContainer = form.createEl("div", { cls: "setting-item" });
    const exportButton = buttonContainer.createEl("button", {
      text: "Save to Vault",
      cls: "mod-cta"
    });
    exportButton.addEventListener("click", async (e) => {
      e.preventDefault();
      const filename = filenameInput.value || "image.png";
      const activeFile = this.app.workspace.getActiveFile();
      if (activeFile) {
        const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
          filename,
          activeFile.path
        );
        await this.app.vault.createBinary(
          targetPath,
          this.buffer
        );
        new import_obsidian.Notice(`Image saved to ${targetPath}`);
      }
      this.close();
    });
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};
async function registerExportToLocal(plugin) {
  plugin.registerEvent(
    plugin.app.workspace.on("editor-menu", (menu, editor) => {
      const cursor = editor.getCursor();
      const line = editor.getLine(cursor.line);
      const base64Regex = /!\[.*?\]\(data:image\/[^;]+;base64,[^)]+\)/;
      const isBase64Image = base64Regex.test(line);
      if (isBase64Image) {
        menu.addItem((item) => {
          item.setTitle("Export to Vault").setIcon("vault").onClick(async () => {
            const base64Match = line.match(/data:image\/[^;]+;base64,([^)]+)/);
            if (!base64Match) return;
            const base64Data = base64Match[1];
            const buffer = Buffer.from(base64Data, "base64");
            new ExportToVaultModal(plugin.app, "image.png", buffer).open();
          });
        });
      }
    })
  );
}

// src/comsContext/convert.ts
var import_obsidian2 = require("obsidian");
var ConvertToBase64Modal = class extends import_obsidian2.Modal {
  constructor(app, file, editor) {
    super(app);
    this.file = file;
    this.editor = editor;
  }
  async onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h2", { text: "Convert to Base64" });
    try {
      const arrayBuffer = await this.app.vault.readBinary(this.file);
      const base64 = btoa(
        String.fromCharCode(...new Uint8Array(arrayBuffer))
      );
      const mimeType = this.file.extension === "png" ? "image/png" : "image/jpeg";
      const base64Data = `data:${mimeType};base64,${base64}`;
      const markdown = `![[${this.file.name}]]`;
      const newMarkdown = `![${this.file.name}](${base64Data})`;
      const cursor = this.editor.getCursor();
      const line = this.editor.getLine(cursor.line);
      const newLine = line.replace(markdown, newMarkdown);
      const lineStart = this.editor.posToOffset({
        line: cursor.line,
        ch: 0
      });
      const lineEnd = this.editor.posToOffset({
        line: cursor.line,
        ch: line.length
      });
      this.editor.replaceRange(
        newLine,
        this.editor.offsetToPos(lineStart),
        this.editor.offsetToPos(lineEnd)
      );
      new import_obsidian2.Notice("Image converted to base64");
    } catch (error) {
      new import_obsidian2.Notice("Failed to convert image: " + error.message);
    }
    this.close();
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};
async function fetchOnlineImage(url) {
  try {
    const response = await fetch(url);
    if (!response.ok) {
      throw new Error(`Failed to fetch image: HTTP ${response.status}`);
    }
    const contentType = response.headers.get("content-type");
    if (!contentType) {
      throw new Error("No content type received from server");
    }
    if (!contentType.startsWith("image/")) {
      throw new Error(
        `URL does not point to an image (content-type: ${contentType})`
      );
    }
    const blob = await response.blob();
    if (!blob.type.startsWith("image/")) {
      throw new Error(`Invalid image format (blob type: ${blob.type})`);
    }
    const arrayBuffer = await blob.arrayBuffer();
    let filename = url.split("/").pop() || "image";
    filename = filename.split("?")[0];
    if (!filename.includes(".")) {
      const ext = contentType.split("/")[1] || "png";
      filename = `${filename}.${ext}`;
    }
    return new Base64File(arrayBuffer, filename);
  } catch (error) {
    if (error instanceof Error) {
      throw new Error(`Failed to fetch online image: ${error.message}`);
    }
    throw new Error("Failed to fetch online image: Unknown error");
  }
}
async function registerConvertImage(plugin) {
  plugin.registerEvent(
    plugin.app.workspace.on("editor-menu", async (menu, editor) => {
      const cursor = editor.getCursor();
      const line = editor.getLine(cursor.line);
      const localImageRegex = /!\[\[([^\]\n]+\.(png|jpg|jpeg))\]\]/;
      const onlineImageRegex = /!\[([^\]]*)\]\((https?:\/\/[^\)]+)\)/;
      const localMatch = line.match(localImageRegex);
      const onlineMatch = line.match(onlineImageRegex);
      if (localMatch) {
        const imagePath = localMatch[1];
        const activeFile = plugin.app.workspace.getActiveFile();
        if (!activeFile) return;
        const file = plugin.app.metadataCache.getFirstLinkpathDest(
          imagePath,
          activeFile.path
        );
        if (file instanceof import_obsidian2.TFile) {
          menu.addItem((item) => {
            item.setTitle("Convert to Base64").setIcon("code-glyph").onClick(async () => {
              new ConvertToBase64Modal(
                plugin.app,
                file,
                editor
              ).open();
            });
          });
        }
      } else if (onlineMatch) {
        const imageUrl = onlineMatch[2];
        menu.addItem((item) => {
          item.setTitle("Convert online image to base64").setIcon("code-glyph").onClick(async () => {
            try {
              const base64File = await fetchOnlineImage(
                imageUrl
              );
              const sizeInKB = base64File.size / 1024;
              let processedFile = base64File;
              if (plugin.settings.enableResizing) {
                if (plugin.settings.resizeStrategy === "smaller") {
                  if (sizeInKB > plugin.settings.smallerThreshold) {
                    const activeFile = plugin.app.workspace.getActiveFile();
                    if (activeFile) {
                      const file = new File(
                        [base64File.buffer],
                        base64File.filename,
                        { type: "image/png" }
                      );
                      const targetPath = await plugin.app.fileManager.getAvailablePathForAttachment(
                        base64File.filename,
                        activeFile.path
                      );
                      const newFile = await plugin.app.vault.createBinary(
                        targetPath,
                        await file.arrayBuffer()
                      );
                      const link = plugin.app.fileManager.generateMarkdownLink(
                        newFile,
                        activeFile.path
                      );
                      const newLine2 = line.replace(
                        onlineMatch[0],
                        link
                      );
                      const lineStart2 = editor.posToOffset({
                        line: cursor.line,
                        ch: 0
                      });
                      const lineEnd2 = editor.posToOffset({
                        line: cursor.line,
                        ch: line.length
                      });
                      editor.replaceRange(
                        newLine2,
                        editor.offsetToPos(
                          lineStart2
                        ),
                        editor.offsetToPos(lineEnd2)
                      );
                      new import_obsidian2.Notice(
                        "Image saved as attachment due to size"
                      );
                      return;
                    }
                  }
                } else {
                  if (sizeInKB > plugin.settings.largerThreshold || plugin.settings.resizeSmallerFiles) {
                    processedFile = await plugin.conversion.resize(
                      base64File,
                      plugin.settings.resizePercentage
                    );
                    if (plugin.settings.backupOriginalImage) {
                      const activeFile = plugin.app.workspace.getActiveFile();
                      if (activeFile) {
                        const timestamp = (/* @__PURE__ */ new Date()).toISOString().replace(/[:.]/g, "-");
                        const backupFilename = `${base64File.filename.replace(
                          ".png",
                          ""
                        )}_original_${timestamp}.png`;
                        const targetPath = await plugin.app.fileManager.getAvailablePathForAttachment(
                          backupFilename,
                          activeFile.path
                        );
                        const file = new File(
                          [base64File.buffer],
                          backupFilename,
                          { type: "image/png" }
                        );
                        await plugin.app.vault.createBinary(
                          targetPath,
                          await file.arrayBuffer()
                        );
                      }
                    }
                  }
                }
              }
              const newLine = line.replace(
                onlineMatch[0],
                processedFile.to64Link()
              );
              const lineStart = editor.posToOffset({
                line: cursor.line,
                ch: 0
              });
              const lineEnd = editor.posToOffset({
                line: cursor.line,
                ch: line.length
              });
              editor.replaceRange(
                newLine,
                editor.offsetToPos(lineStart),
                editor.offsetToPos(lineEnd)
              );
              new import_obsidian2.Notice("Online image converted to base64");
            } catch (error) {
              if (error instanceof Error) {
                new import_obsidian2.Notice(error.message);
              } else {
                new import_obsidian2.Notice(
                  "Failed to convert online image: Unknown error"
                );
              }
            }
          });
        });
      }
    })
  );
}

// src/commands/selectAndConvert.ts
var import_obsidian3 = require("obsidian");
var ConvertImagesModal = class extends import_obsidian3.Modal {
  constructor(app, plugin) {
    super(app);
    this.plugin = plugin;
    this.conversionScope = "note";
    this.conversionType = "toBase64";
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.empty();
    contentEl.createEl("h2", { text: "Convert Images" });
    const scopeContainer = contentEl.createEl("div", { cls: "setting-item" });
    scopeContainer.createEl("label", { text: "Scope" });
    const scopeSelect = scopeContainer.createEl("select");
    const scopes = [
      { value: "note", text: "Current Note" },
      { value: "folder", text: "Current Folder" },
      { value: "vault", text: "Entire Vault" }
    ];
    scopes.forEach((scope) => {
      scopeSelect.createEl("option", {
        value: scope.value,
        text: scope.text
      });
    });
    const typeContainer = contentEl.createEl("div", { cls: "setting-item" });
    typeContainer.createEl("label", { text: "Conversion Type" });
    const typeSelect = typeContainer.createEl("select");
    const types = [
      { value: "toBase64", text: "Image Files \u2192 Base64" },
      { value: "toImage", text: "Base64 \u2192 Image Files" }
    ];
    types.forEach((type) => {
      typeSelect.createEl("option", {
        value: type.value,
        text: type.text
      });
    });
    const buttonContainer = contentEl.createEl("div", { cls: "setting-item" });
    const convertButton = buttonContainer.createEl("button", {
      text: "Convert",
      cls: "mod-cta"
    });
    convertButton.addEventListener("click", async () => {
      this.conversionScope = scopeSelect.value;
      this.conversionType = typeSelect.value;
      await this.performConversion();
      this.close();
    });
  }
  async performConversion() {
    const files = await this.getFilesInScope();
    console.log("Files in scope:", files.length);
    let converted = 0;
    for (const file of files) {
      if (this.conversionType === "toBase64") {
        const content = await this.app.vault.read(file);
        const imageRegex = /!\[\[([^\]]+\.(png|jpg|jpeg))\]\]/g;
        const matches = content.match(imageRegex);
        if (matches) {
          console.log("Found image embeds in:", file.path);
          await this.convertToBase64(file);
          converted++;
        }
      } else {
        const content = await this.app.vault.read(file);
        const base64Regex = /!\[.*?\]\(data:image\/[^;]+;base64,[^)]+\)/g;
        const matches = content.match(base64Regex);
        if (matches) {
          console.log("Found base64 images in:", file.path);
          await this.convertToImages(file, matches);
          converted++;
        }
      }
    }
    new import_obsidian3.Notice(`Converted ${converted} files`);
  }
  async getFilesInScope() {
    switch (this.conversionScope) {
      case "note":
        const activeFile = this.app.workspace.getActiveFile();
        return activeFile ? [activeFile] : [];
      case "folder":
        const currentFile = this.app.workspace.getActiveFile();
        if (!(currentFile == null ? void 0 : currentFile.parent)) return [];
        return this.app.vault.getMarkdownFiles().filter((f) => f.parent === currentFile.parent);
      case "vault":
        return this.app.vault.getMarkdownFiles();
      default:
        return [];
    }
  }
  async convertToBase64(file) {
    const content = await this.app.vault.read(file);
    const imageRegex = /!\[\[([^\]]+\.(png|jpg|jpeg))\]\]/g;
    let newContent = content;
    let modified = false;
    const matches = Array.from(content.matchAll(imageRegex));
    for (const match of matches) {
      const imagePath = match[1];
      const imageFile = this.app.metadataCache.getFirstLinkpathDest(imagePath, file.path);
      if (imageFile instanceof import_obsidian3.TFile) {
        try {
          const arrayBuffer = await this.app.vault.readBinary(imageFile);
          const base64 = btoa(String.fromCharCode(...new Uint8Array(arrayBuffer)));
          const mimeType = imageFile.extension === "png" ? "image/png" : "image/jpeg";
          const base64Data = `data:${mimeType};base64,${base64}`;
          const markdown = `![[${imageFile.name}]]`;
          const newMarkdown = `![${imageFile.name}](${base64Data})`;
          newContent = newContent.replace(markdown, newMarkdown);
          modified = true;
        } catch (error) {
          console.error("Error converting image:", error);
        }
      }
    }
    if (modified) {
      await this.app.vault.modify(file, newContent);
    }
  }
  async convertToImages(file, matches) {
    const content = await this.app.vault.read(file);
    let newContent = content;
    for (const match of matches) {
      const base64Match = match.match(/data:image\/[^;]+;base64,([^)]+)/);
      if (!base64Match) continue;
      const base64Data = base64Match[1];
      const buffer = Buffer.from(base64Data, "base64");
      const timestamp = (/* @__PURE__ */ new Date()).toISOString().replace(/[:.]/g, "-");
      const filename = `image_${timestamp}.png`;
      const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
        filename,
        file.path
      );
      await this.app.vault.createBinary(targetPath, buffer);
      const newFile = this.app.vault.getAbstractFileByPath(targetPath);
      if (newFile instanceof import_obsidian3.TFile) {
        const link = this.app.fileManager.generateMarkdownLink(newFile, file.path);
        newContent = newContent.replace(match, link);
      }
    }
    if (newContent !== content) {
      await this.app.vault.modify(file, newContent);
    }
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};
function registerConvertCommand(plugin) {
  plugin.addCommand({
    id: "convert-images",
    name: "Convert Images",
    callback: () => {
      new ConvertImagesModal(plugin.app, plugin).open();
    }
  });
}

// src/commands/selectAndExport.ts
var import_obsidian4 = require("obsidian");
var ExportImagesModal = class extends import_obsidian4.Modal {
  constructor(app, plugin) {
    super(app);
    this.plugin = plugin;
    this.conversionScope = "note";
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.empty();
    contentEl.createEl("h2", { text: "Export Images" });
    const scopeContainer = contentEl.createEl("div", { cls: "setting-item" });
    scopeContainer.createEl("label", { text: "Scope" });
    const scopeSelect = scopeContainer.createEl("select");
    const scopes = [
      { value: "note", text: "Current Note" },
      { value: "folder", text: "Current Folder" },
      { value: "vault", text: "Entire Vault" }
    ];
    scopes.forEach((scope) => {
      scopeSelect.createEl("option", {
        value: scope.value,
        text: scope.text
      });
    });
    const buttonContainer = contentEl.createEl("div", { cls: "setting-item" });
    const exportButton = buttonContainer.createEl("button", {
      text: "Export",
      cls: "mod-cta"
    });
    exportButton.addEventListener("click", async () => {
      this.conversionScope = scopeSelect.value;
      await this.exportImages();
      this.close();
    });
  }
  async exportImages() {
    const files = await this.getFilesInScope();
    console.log("Files in scope:", files.length);
    let exportedCount = 0;
    let skippedCount = 0;
    for (const file of files) {
      const content = await this.app.vault.read(file);
      const base64Regex = /!\[.*?\]\(data:image\/[^;]+;base64,([^)]+)\)/g;
      const base64Matches = Array.from(content.matchAll(base64Regex));
      const imageRegex = /!\[\[([^\]]+\.(png|jpg|jpeg))\]\]/g;
      const imageMatches = Array.from(content.matchAll(imageRegex));
      for (const match of base64Matches) {
        try {
          const base64Data = match[1];
          const timestamp = (/* @__PURE__ */ new Date()).toISOString().replace(/[:.]/g, "-");
          const filename = `base64_image_${timestamp}_${exportedCount}.png`;
          const binary = atob(base64Data);
          const array = new Uint8Array(binary.length);
          for (let i = 0; i < binary.length; i++) {
            array[i] = binary.charCodeAt(i);
          }
          const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
            filename,
            file.path
          );
          const existingFile = this.app.vault.getAbstractFileByPath(targetPath);
          if (existingFile instanceof import_obsidian4.TFile) {
            const existingSize = (await this.app.vault.readBinary(existingFile)).byteLength;
            if (existingSize === array.buffer.byteLength) {
              skippedCount++;
              continue;
            }
          }
          await this.app.vault.createBinary(targetPath, array.buffer);
          exportedCount++;
        } catch (error) {
          console.error("Error processing base64 image:", error);
        }
      }
      for (const match of imageMatches) {
        try {
          const imagePath = match[1];
          const imageFile = this.app.metadataCache.getFirstLinkpathDest(imagePath, file.path);
          if (imageFile instanceof import_obsidian4.TFile) {
            const arrayBuffer = await this.app.vault.readBinary(imageFile);
            const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
              imageFile.name,
              file.path
            );
            const existingFile = this.app.vault.getAbstractFileByPath(targetPath);
            if (existingFile instanceof import_obsidian4.TFile) {
              const existingSize = (await this.app.vault.readBinary(existingFile)).byteLength;
              if (existingSize === arrayBuffer.byteLength) {
                skippedCount++;
                continue;
              }
            }
            await this.app.vault.createBinary(targetPath, arrayBuffer);
            exportedCount++;
          }
        } catch (error) {
          console.error("Error processing image embed:", error);
        }
      }
    }
    if (exportedCount > 0 || skippedCount > 0) {
      new import_obsidian4.Notice(`Exported ${exportedCount} images, skipped ${skippedCount} duplicates`);
    } else {
      new import_obsidian4.Notice("No images found to export");
    }
  }
  async getFilesInScope() {
    switch (this.conversionScope) {
      case "note":
        const activeFile = this.app.workspace.getActiveFile();
        return activeFile ? [activeFile] : [];
      case "folder":
        const currentFile = this.app.workspace.getActiveFile();
        if (!(currentFile == null ? void 0 : currentFile.parent)) return [];
        return this.app.vault.getMarkdownFiles().filter((f) => f.parent === currentFile.parent);
      case "vault":
        return this.app.vault.getMarkdownFiles();
      default:
        return [];
    }
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};
function registerExportCommand(plugin) {
  plugin.addCommand({
    id: "export-images",
    name: "Export Images",
    callback: () => {
      new ExportImagesModal(plugin.app, plugin).open();
    }
  });
}

// src/coms/cursorEscape.ts
var import_obsidian5 = require("obsidian");
function registerCursorEscape(plugin) {
  plugin.registerInterval(
    window.setInterval(() => {
      if (!plugin.settings.autoEscapeLink) {
        return;
      }
      const activeView = plugin.app.workspace.getActiveViewOfType(import_obsidian5.MarkdownView);
      if (activeView && activeView.getViewType() === "markdown") {
        const editor = activeView.editor;
        if (editor) {
          checkCursorPosition(editor);
        }
      }
    }, 100)
  );
}
function checkCursorPosition(editor) {
  const cursor = editor.getCursor();
  const selection = editor.getSelection();
  if (selection) {
    return;
  }
  const line = editor.getLine(cursor.line);
  if (!(line.startsWith("![") && line.includes("(data:image/"))) {
    return;
  }
  const linkStart = line.indexOf("(data:image/");
  if (linkStart === -1) {
    return;
  }
  let openParens = 1;
  let linkEnd = linkStart;
  for (let i = linkStart + 1; i < line.length; i++) {
    if (line[i] === "(") openParens++;
    if (line[i] === ")") openParens--;
    if (openParens === 0) {
      linkEnd = i;
      break;
    }
  }
  if (cursor.ch <= linkStart || cursor.ch > linkEnd) {
    return;
  }
  const remainingText = line.slice(cursor.ch);
  const nextClosingParen = remainingText.indexOf(")");
  if (nextClosingParen !== -1) {
    editor.setCursor({
      line: cursor.line,
      ch: cursor.ch + nextClosingParen + 1
    });
  } else {
    editor.setCursor({ line: cursor.line + 1, ch: 0 });
  }
}

// src/main.ts
var DEFAULT_SETTINGS = {
  convertOnPaste: true,
  convertOnDrop: true,
  autoEscapeLink: true,
  // Default to true
  enableResizing: false,
  resizeStrategy: "smaller",
  smallerThreshold: 1e3,
  // 1MB default
  largerThreshold: 1e3,
  // 1MB default
  resizePercentage: 80,
  backupOriginalImage: true,
  resizeSmallerFiles: false
  // Default to false
};
var ImageInlinePlugin = class extends import_obsidian6.Plugin {
  async onload() {
    await this.loadSettings();
    this.conversion = new Base64Conversion();
    this.registerEditorExtension(linkDecorations);
    await registerExportToLocal(this);
    await registerConvertImage(this);
    registerCursorEscape(this);
    await registerConvertCommand(this);
    await registerExportCommand(this);
    this.registerEvent(
      this.app.workspace.on("editor-paste", async (evt, editor) => {
        var _a;
        if (!this.settings.convertOnPaste) return;
        const items = (_a = evt.clipboardData) == null ? void 0 : _a.items;
        if (!items) return;
        const allImages = Array.from(items).every((item) => item.type.startsWith("image/"));
        if (!allImages) return;
        evt.preventDefault();
        const base64Files = [];
        for (const item of Array.from(items)) {
          if (item.type.startsWith("image/")) {
            const file = item.getAsFile();
            if (file) {
              const base64File = await this.conversion.fromFile(file);
              base64Files.push(base64File);
            }
          }
        }
        if (base64Files.length > 0) {
          await this.handleImages(base64Files, editor);
        }
      })
    );
    this.registerEvent(
      this.app.workspace.on("editor-drop", async (evt, editor) => {
        var _a;
        if (!this.settings.convertOnDrop) return;
        const files = (_a = evt.dataTransfer) == null ? void 0 : _a.files;
        if (!files || files.length === 0) return;
        const allImages = Array.from(files).every((file) => file.type.startsWith("image/"));
        if (!allImages) return;
        evt.preventDefault();
        const base64Files = [];
        for (const file of Array.from(files)) {
          if (file.type.startsWith("image/")) {
            const base64File = await this.conversion.fromFile(file);
            base64Files.push(base64File);
          }
        }
        if (base64Files.length > 0) {
          await this.handleImages(base64Files, editor);
        }
      })
    );
    this.addSettingTab(new ImageInlineSettingTab(this.app, this));
  }
  async handleImages(base64Files, editor) {
    try {
      if (!this.settings.enableResizing) {
        const markdown = base64Files.map((file) => file.to64Link()).join("\n");
        editor.replaceSelection(markdown);
        return;
      }
      const processedFiles = [];
      const attachments = [];
      for (const base64File of base64Files) {
        const sizeInKB = base64File.size / 1024;
        if (this.settings.resizeStrategy === "smaller") {
          if (sizeInKB <= this.settings.smallerThreshold) {
            processedFiles.push(base64File);
          } else {
            attachments.push(base64File);
          }
        } else {
          if (sizeInKB > this.settings.largerThreshold) {
            const resizedFile = await this.conversion.resize(base64File, this.settings.resizePercentage);
            processedFiles.push(resizedFile);
            if (this.settings.backupOriginalImage) {
              const activeFile = this.app.workspace.getActiveFile();
              if (activeFile) {
                const timestamp = (/* @__PURE__ */ new Date()).toISOString().replace(/[:.]/g, "-");
                const backupFilename = `${base64File.filename.replace(".png", "")}_original_${timestamp}.png`;
                const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
                  backupFilename,
                  activeFile.path
                );
                const file = new File([base64File.buffer], backupFilename, { type: "image/png" });
                await this.app.vault.createBinary(
                  targetPath,
                  await file.arrayBuffer()
                );
              }
            }
          } else {
            processedFiles.push(base64File);
          }
        }
      }
      if (processedFiles.length > 0) {
        const markdown = processedFiles.map((file) => file.to64Link()).join("\n");
        editor.replaceSelection(markdown);
      }
      if (attachments.length > 0) {
        new import_obsidian6.Notice(`${attachments.length} image(s) will be saved as attachments`);
        for (const attachment of attachments) {
          const activeFile = this.app.workspace.getActiveFile();
          if (activeFile) {
            const file = new File([attachment.buffer], attachment.filename, { type: "image/png" });
            const targetPath = await this.app.fileManager.getAvailablePathForAttachment(
              attachment.filename,
              activeFile.path
            );
            const newFile = await this.app.vault.createBinary(
              targetPath,
              await file.arrayBuffer()
            );
            const link = this.app.fileManager.generateMarkdownLink(
              newFile,
              activeFile.path
            );
            editor.replaceSelection(link + "\n");
          }
        }
      }
    } catch (error) {
      new import_obsidian6.Notice("Failed to process images: " + error.message);
    }
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
var ImageInlineSettingTab = class extends import_obsidian6.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "General Settings" });
    new import_obsidian6.Setting(containerEl).setName("Convert on paste").setDesc("Convert images pasted into the editor to base64").addToggle((toggle) => toggle.setValue(this.plugin.settings.convertOnPaste).onChange(async (value) => {
      this.plugin.settings.convertOnPaste = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian6.Setting(containerEl).setName("Convert on drop").setDesc("Convert images dropped into the editor to base64").addToggle((toggle) => toggle.setValue(this.plugin.settings.convertOnDrop).onChange(async (value) => {
      this.plugin.settings.convertOnDrop = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian6.Setting(containerEl).setName("Auto escape base64 data section").setDesc("Automatically move cursor out of the base64 data section").addToggle((toggle) => toggle.setValue(this.plugin.settings.autoEscapeLink).onChange(async (value) => {
      this.plugin.settings.autoEscapeLink = value;
      await this.plugin.saveSettings();
    }));
    containerEl.createEl("h2", { text: "Image Resizing" });
    new import_obsidian6.Setting(containerEl).setName("Enable resizing").setDesc("Enable image resizing features").addToggle((toggle) => toggle.setValue(this.plugin.settings.enableResizing).onChange(async (value) => {
      this.plugin.settings.enableResizing = value;
      await this.plugin.saveSettings();
      this.display();
    }));
    if (this.plugin.settings.enableResizing) {
      new import_obsidian6.Setting(containerEl).setName("Resizing strategy").setDesc("Choose how to handle image resizing").addDropdown((dropdown) => dropdown.addOption("smaller", "Convert small images to base64").addOption("larger", "Resize large images").setValue(this.plugin.settings.resizeStrategy).onChange(async (value) => {
        this.plugin.settings.resizeStrategy = value;
        await this.plugin.saveSettings();
        this.display();
      }));
      if (this.plugin.settings.resizeStrategy === "smaller") {
        new import_obsidian6.Setting(containerEl).setName("Size threshold").setDesc("Images smaller than this size (in KB) will be converted to base64").addText((text) => text.setValue(this.plugin.settings.smallerThreshold.toString()).onChange(async (value) => {
          const num = Number(value);
          if (!isNaN(num)) {
            this.plugin.settings.smallerThreshold = num;
            await this.plugin.saveSettings();
          }
        }));
      } else {
        new import_obsidian6.Setting(containerEl).setName("Size threshold").setDesc("Images larger than this size (in KB) will be resized").addText((text) => text.setValue(this.plugin.settings.largerThreshold.toString()).onChange(async (value) => {
          const num = Number(value);
          if (!isNaN(num)) {
            this.plugin.settings.largerThreshold = num;
            await this.plugin.saveSettings();
          }
        }));
        new import_obsidian6.Setting(containerEl).setName("Resize percentage").setDesc("Percentage to resize images to (1-100)").addSlider((slider) => slider.setLimits(1, 100, 1).setValue(this.plugin.settings.resizePercentage).setDynamicTooltip().onChange(async (value) => {
          this.plugin.settings.resizePercentage = value;
          await this.plugin.saveSettings();
        }));
        new import_obsidian6.Setting(containerEl).setName("Backup original images").setDesc("Save original images to media folder when resizing").addToggle((toggle) => toggle.setValue(this.plugin.settings.backupOriginalImage).onChange(async (value) => {
          this.plugin.settings.backupOriginalImage = value;
          await this.plugin.saveSettings();
        }));
        new import_obsidian6.Setting(containerEl).setName("Resize smaller files").setDesc("Also resize files smaller than the threshold when using larger strategy").addToggle((toggle) => toggle.setValue(this.plugin.settings.resizeSmallerFiles).onChange(async (value) => {
          this.plugin.settings.resizeSmallerFiles = value;
          await this.plugin.saveSettings();
        }));
      }
    }
  }
};

/* nosourcemap */