/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => GitLabWikiConverterPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian4 = require("obsidian");

// src/converter.ts
var import_obsidian = require("obsidian");
var fs = __toESM(require("fs/promises"));

// src/fileExtensionStripper.ts
var removeFileExtensionForMdFilesInLinks = (fileText) => {
  const markdownRegex = /\[(^$|.*?)\]\((.*?)\)/g;
  const markdownMatches = fileText.match(markdownRegex);
  if (markdownMatches) {
    const fileRegex = /(?<=\().*(?=\))/;
    for (const markdownMatch of markdownMatches) {
      const fileMatch = markdownMatch.match(fileRegex);
      if (fileMatch && fileMatch[0].endsWith(".md")) {
        fileText = fileText.replace(fileMatch[0], fileMatch[0].slice(0, -3));
      }
    }
  }
  return fileText;
};

// src/converter.ts
var path = __toESM(require("path"));

// src/utils.ts
function trimFile(file) {
  if (!file) return "";
  return file.extension == "md" ? file.path.slice(0, -3) : file.path;
}
function isHomePageSelectedAndValid(plugin) {
  if (plugin.settings.homeFilePath != "" && plugin.app.vault.getAbstractFileByPath(plugin.settings.homeFilePath + ".md") != null) {
    return true;
  } else {
    return false;
  }
}
function isUnixHiddenPath(path2) {
  return /(^|\/)\.[^\/\.]/g.test(path2);
}

// src/converter.ts
var convertAndExportVault = async (vault, fileManager, homeFilePath, exportPath) => {
  new import_obsidian.Notice("Starting Vault conversion and export ...", 4e3);
  const homeFile = vault.getAbstractFileByPath(homeFilePath + ".md");
  if (!(homeFile instanceof import_obsidian.TFile)) {
    new import_obsidian.Notice("Export failed! Could not find home file in vault. Make sure the specified home file path is correct.", 0);
    return;
  }
  await fileManager.renameFile(homeFile, "home.md");
  const folders = vault.getAllFolders(false);
  for (const folder of folders) {
    await fileManager.renameFile(folder, folder.path.replace(/\s+/g, "-"));
  }
  const files = vault.getFiles();
  await Promise.all(
    files.map(
      (file) => fileManager.renameFile(file, file.path.replace(/\s+/g, "-"))
    )
  );
  const markdownFiles = vault.getMarkdownFiles();
  await Promise.all(
    markdownFiles.map(
      (file) => vault.process(file, (data) => {
        return removeFileExtensionForMdFilesInLinks(data);
      })
    )
  );
  await exportVaultToSpecifiedLocation(vault, exportPath);
  for (const folder of folders) {
    await fileManager.renameFile(folder, folder.path.replace(/-/g, " "));
  }
  await Promise.all(
    files.map(
      (file) => fileManager.renameFile(file, file.path.replace(/-/g, " "))
    )
  );
  await fileManager.renameFile(homeFile, homeFilePath + ".md");
  new import_obsidian.Notice("Vault conversion and export finished successfully!", 5e3);
};
var exportVaultToSpecifiedLocation = async (vault, rawExportPath) => {
  const adapter = vault.adapter;
  if (adapter instanceof import_obsidian.FileSystemAdapter) {
    const vaultAbsolutePath = adapter.getBasePath();
    const exportPath = rawExportPath.split(path.sep).join(path.posix.sep);
    await fs.cp(vaultAbsolutePath, exportPath, {
      recursive: true,
      errorOnExist: false,
      // overwrite by default
      force: true,
      // overwrite read-only files if needed
      filter: (srcPath) => {
        return !isUnixHiddenPath(path.basename(srcPath));
      }
    });
    return;
  }
  console.error("Could not get file system adapter from vault adapter:", adapter);
};

// src/fileSuggest.ts
var import_obsidian2 = require("obsidian");
var FileSuggest = class extends import_obsidian2.AbstractInputSuggest {
  getSuggestions(inputStr) {
    const mdFiles = this.app.vault.getMarkdownFiles();
    const files = [];
    const inputLower = inputStr.toLowerCase();
    mdFiles.forEach((file) => {
      if (file.path.toLowerCase().contains(inputLower)) {
        files.push(file);
      }
    });
    return files;
  }
  renderSuggestion(file, el) {
    el.setText(trimFile(file));
  }
  selectSuggestion(file) {
    this.textInputEl.value = trimFile(file);
    this.textInputEl.trigger("input");
    this.close();
  }
};

// src/settings.ts
var import_obsidian3 = require("obsidian");
var import_path = require("path");
var DEFAULT_SETTINGS = {
  exportPath: "",
  homeFilePath: ""
};
var GitLabWikiConverterSettingTab = class extends import_obsidian3.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian3.Setting(containerEl).setName("Location").setDesc("Specify the path to where you want to export converted vault.").addText((text) => text.setPlaceholder("Path").setValue(this.plugin.settings.exportPath).onChange(async (value) => {
      this.plugin.settings.exportPath = (0, import_path.normalize)(value);
      await this.plugin.saveSettings();
    }));
    new import_obsidian3.Setting(containerEl).setName("Home page").setDesc("Specify the file, which will be your Gitlab homepage.").addText((text) => {
      new FileSuggest(this.app, text.inputEl);
      text.setPlaceholder("Home").setValue(this.plugin.settings.homeFilePath).onChange(async (value) => {
        this.plugin.settings.homeFilePath = (0, import_obsidian3.normalizePath)(value);
        await this.plugin.saveSettings();
      });
    });
  }
};

// src/main.ts
var GitLabWikiConverterPlugin = class extends import_obsidian4.Plugin {
  async onload() {
    await this.loadSettings();
    this.addCommand({
      id: "export-vault",
      name: "Export Vault as Gitlab Wiki",
      callback: () => {
        if (isHomePageSelectedAndValid(this)) {
          convertAndExportVault(this.app.vault, this.app.fileManager, this.settings.homeFilePath, this.settings.exportPath);
        } else {
          new import_obsidian4.Notice("Export failed! Select a valid Gitlab home page in the settings before exporting vault.", 0);
        }
      }
    });
    this.addSettingTab(new GitLabWikiConverterSettingTab(this.app, this));
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};

/* nosourcemap */