/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/ms/index.js
var require_ms = __commonJS({
  "node_modules/ms/index.js"(exports, module2) {
    var s = 1e3;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    var w = d * 7;
    var y = d * 365.25;
    module2.exports = function(val, options) {
      options = options || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse(val);
      } else if (type === "number" && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n = parseFloat(match[1]);
      var type = (match[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n * y;
        case "weeks":
        case "week":
        case "w":
          return n * w;
        case "days":
        case "day":
        case "d":
          return n * d;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n * h;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n * m;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n * s;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n;
        default:
          return void 0;
      }
    }
    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return Math.round(ms / d) + "d";
      }
      if (msAbs >= h) {
        return Math.round(ms / h) + "h";
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + "m";
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + "s";
      }
      return ms + "ms";
    }
    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return plural(ms, msAbs, d, "day");
      }
      if (msAbs >= h) {
        return plural(ms, msAbs, h, "hour");
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, "minute");
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, "second");
      }
      return ms + " ms";
    }
    function plural(ms, msAbs, n, name) {
      var isPlural = msAbs >= n * 1.5;
      return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
    }
  }
});

// node_modules/debug/src/common.js
var require_common = __commonJS({
  "node_modules/debug/src/common.js"(exports, module2) {
    function setup(env) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env).forEach((key) => {
        createDebug[key] = env[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash = 0;
        for (let i = 0; i < namespace.length; i++) {
          hash = (hash << 5) - hash + namespace.charCodeAt(i);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug2(...args) {
          if (!debug2.enabled) {
            return;
          }
          const self = debug2;
          const curr = Number(/* @__PURE__ */ new Date());
          const ms = curr - (prevTime || curr);
          self.diff = ms;
          self.prev = prevTime;
          self.curr = curr;
          prevTime = curr;
          args[0] = createDebug.coerce(args[0]);
          if (typeof args[0] !== "string") {
            args.unshift("%O");
          }
          let index = 0;
          args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
            if (match === "%%") {
              return "%";
            }
            index++;
            const formatter = createDebug.formatters[format];
            if (typeof formatter === "function") {
              const val = args[index];
              match = formatter.call(self, val);
              args.splice(index, 1);
              index--;
            }
            return match;
          });
          createDebug.formatArgs.call(self, args);
          const logFn = self.log || createDebug.log;
          logFn.apply(self, args);
        }
        debug2.namespace = namespace;
        debug2.useColors = createDebug.useColors();
        debug2.color = createDebug.selectColor(namespace);
        debug2.extend = extend;
        debug2.destroy = createDebug.destroy;
        Object.defineProperty(debug2, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v) => {
            enableOverride = v;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug2);
        }
        return debug2;
      }
      function extend(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        let i;
        const split = (typeof namespaces === "string" ? namespaces : "").split(/[\s,]+/);
        const len = split.length;
        for (i = 0; i < len; i++) {
          if (!split[i]) {
            continue;
          }
          namespaces = split[i].replace(/\*/g, ".*?");
          if (namespaces[0] === "-") {
            createDebug.skips.push(new RegExp("^" + namespaces.slice(1) + "$"));
          } else {
            createDebug.names.push(new RegExp("^" + namespaces + "$"));
          }
        }
      }
      function disable() {
        const namespaces = [
          ...createDebug.names.map(toNamespace),
          ...createDebug.skips.map(toNamespace).map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      function enabled(name) {
        if (name[name.length - 1] === "*") {
          return true;
        }
        let i;
        let len;
        for (i = 0, len = createDebug.skips.length; i < len; i++) {
          if (createDebug.skips[i].test(name)) {
            return false;
          }
        }
        for (i = 0, len = createDebug.names.length; i < len; i++) {
          if (createDebug.names[i].test(name)) {
            return true;
          }
        }
        return false;
      }
      function toNamespace(regexp) {
        return regexp.toString().substring(2, regexp.toString().length - 2).replace(/\.\*\?$/, "*");
      }
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    module2.exports = setup;
  }
});

// node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "node_modules/debug/src/browser.js"(exports, module2) {
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();
    exports.destroy = (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
      typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
      // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    exports.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports.storage.setItem("debug", namespaces);
        } else {
          exports.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    function load() {
      let r;
      try {
        r = exports.storage.getItem("debug");
      } catch (error) {
      }
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    module2.exports = require_common()(exports);
    var { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  }
});

// node_modules/@kwsites/file-exists/dist/src/index.js
var require_src = __commonJS({
  "node_modules/@kwsites/file-exists/dist/src/index.js"(exports) {
    "use strict";
    var __importDefault = exports && exports.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var fs_1 = require("fs");
    var debug_1 = __importDefault(require_browser());
    var log = debug_1.default("@kwsites/file-exists");
    function check(path, isFile, isDirectory) {
      log(`checking %s`, path);
      try {
        const stat = fs_1.statSync(path);
        if (stat.isFile() && isFile) {
          log(`[OK] path represents a file`);
          return true;
        }
        if (stat.isDirectory() && isDirectory) {
          log(`[OK] path represents a directory`);
          return true;
        }
        log(`[FAIL] path represents something other than a file or directory`);
        return false;
      } catch (e) {
        if (e.code === "ENOENT") {
          log(`[FAIL] path is not accessible: %o`, e);
          return false;
        }
        log(`[FATAL] %o`, e);
        throw e;
      }
    }
    function exists2(path, type = exports.READABLE) {
      return check(path, (type & exports.FILE) > 0, (type & exports.FOLDER) > 0);
    }
    exports.exists = exists2;
    exports.FILE = 1;
    exports.FOLDER = 2;
    exports.READABLE = exports.FILE + exports.FOLDER;
  }
});

// node_modules/@kwsites/file-exists/dist/index.js
var require_dist = __commonJS({
  "node_modules/@kwsites/file-exists/dist/index.js"(exports) {
    "use strict";
    function __export3(m) {
      for (var p in m)
        if (!exports.hasOwnProperty(p))
          exports[p] = m[p];
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    __export3(require_src());
  }
});

// node_modules/@kwsites/promise-deferred/dist/index.js
var require_dist2 = __commonJS({
  "node_modules/@kwsites/promise-deferred/dist/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.createDeferred = exports.deferred = void 0;
    function deferred2() {
      let done;
      let fail;
      let status = "pending";
      const promise = new Promise((_done, _fail) => {
        done = _done;
        fail = _fail;
      });
      return {
        promise,
        done(result) {
          if (status === "pending") {
            status = "resolved";
            done(result);
          }
        },
        fail(error) {
          if (status === "pending") {
            status = "rejected";
            fail(error);
          }
        },
        get fulfilled() {
          return status !== "pending";
        },
        get status() {
          return status;
        }
      };
    }
    exports.deferred = deferred2;
    exports.createDeferred = deferred2;
    exports.default = deferred2;
  }
});

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => GitPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian8 = require("obsidian");

// src/components/git-commit.modal.ts
var import_obsidian = require("obsidian");
var GitCommitModal = class extends import_obsidian.Modal {
  constructor(app, prevCommitMsg, onCompleteCallback) {
    super(app);
    this.commit = false;
    this.sync = false;
    this.prevCommitMsg = prevCommitMsg;
    this.onCompleteCallback = onCompleteCallback;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", { text: "Git commit" });
    this.setupPrevCommitMsgDisplay(contentEl);
    new import_obsidian.Setting(contentEl).setName("Commit message").setClass(
      this.prevCommitMsg ? "setting-item-no-top-border" : "setting-item"
    ).addTextArea((comp) => {
      comp.setPlaceholder("Enter commit message...");
      comp.onChange((value) => this.msg = value);
    }).setClass("modal-setting-item-w-text-area");
    const buttons = new import_obsidian.Setting(contentEl).addButton(
      (btn) => btn.setButtonText("Cancel").onClick(() => {
        this.close();
      })
    ).addButton(
      (btn) => btn.setButtonText("Commit").setClass("bg-theme").onClick(() => {
        if (this.msg && this.msg.trim().length > 0) {
          this.commit = true;
          this.close();
        }
      })
    );
    const checkboxContainer = contentEl.createDiv({
      cls: "checkbox-container-w-text"
    });
    const checkbox = contentEl.createEl("input", {
      type: "checkbox",
      attr: {
        id: "sync-checkbox"
      }
    });
    checkbox.addEventListener("change", () => {
      this.sync = checkbox.checked;
    });
    const checkboxText = contentEl.createEl("label", {
      text: "Automatically push to remote repository",
      cls: "font-small",
      attr: {
        for: "sync-checkbox"
      }
    });
    checkboxContainer.appendChild(checkbox);
    checkboxContainer.appendChild(checkboxText);
    buttons.controlEl.insertAdjacentElement("afterbegin", checkboxContainer);
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
    if (this.commit) {
      this.onCompleteCallback(this.msg, this.sync);
    }
  }
  setupPrevCommitMsgDisplay(contentEl) {
    if (this.prevCommitMsg) {
      const prevCommitContainer = contentEl.createDiv(
        "setting-item prev-commit-container"
      );
      const settingName = contentEl.createDiv({
        text: "Previous commit",
        cls: "setting-item-name"
      });
      prevCommitContainer.appendChild(settingName);
      const copyContainer = contentEl.createDiv({
        cls: "copy-container w-100"
      });
      const msgContainer = contentEl.createDiv({
        text: this.prevCommitMsg,
        cls: "msg"
      });
      const icon = contentEl.createEl("div", { cls: "clickable-icon" });
      icon.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="svg-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-copy"><rect width="14" height="14" x="8" y="8" rx="2" ry="2"/><path d="M4 16c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2"/></svg>';
      icon.addEventListener("click", () => {
        if (this.prevCommitMsg) {
          navigator.clipboard.writeText(this.prevCommitMsg);
          new import_obsidian.Notice("Copied to clipboard");
        }
      });
      copyContainer.appendChild(msgContainer);
      copyContainer.appendChild(icon);
      prevCommitContainer.appendChild(copyContainer);
    }
  }
};

// src/components/git-init.modal.ts
var import_obsidian2 = require("obsidian");
var GitInitRemote = class extends import_obsidian2.Modal {
  constructor(app, onCompleteCallback) {
    super(app);
    this.addRemote = false;
    this.onCompleteCallback = onCompleteCallback;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", { text: "Git init remote" });
    new import_obsidian2.Setting(contentEl).setName("Remote repository url").addText(
      (text) => text.setPlaceholder("Enter repository url...").onChange((value) => this.repo = value)
    );
    new import_obsidian2.Setting(contentEl).addButton(
      (btn) => btn.setButtonText("Initialize").setClass("bg-theme").onClick(() => {
        if (this.repo) {
          this.addRemote = true;
          this.close();
        }
      })
    );
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
    if (this.addRemote) {
      this.onCompleteCallback(this.repo);
    }
  }
};

// src/components/git-menu.modal.ts
var import_obsidian3 = require("obsidian");
var GitMenuModal = class extends import_obsidian3.Modal {
  constructor(app, gitInitModal, gitCommitModal, gitSyncModal) {
    super(app);
    this.gitInitModal = gitInitModal;
    this.gitCommitModal = gitCommitModal;
    this.gitSyncModal = gitSyncModal;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", { text: "Git menu" });
    if (this.gitInitModal !== null) {
      new import_obsidian3.Setting(contentEl).setClass("setting-item-without-info").addButton((button) => {
        button.setButtonText("Git init");
        button.setClass("w-100").setClass("font-medium");
        button.onClick(() => {
          this.gitInitModal.open();
          this.close();
        });
      });
    }
    new import_obsidian3.Setting(contentEl).setClass("setting-item-without-info").addButton((button) => {
      button.setButtonText("Git commit");
      button.setClass("w-100").setClass("font-medium");
      button.onClick(() => {
        this.gitCommitModal.open();
        this.close();
      });
    }).addButton((button) => {
      button.setButtonText("Git sync");
      button.setClass("w-100").setClass("font-medium");
      button.onClick(() => {
        this.gitSyncModal.open();
        this.close();
      });
    });
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};

// src/components/git-sync.modal.ts
var import_obsidian4 = require("obsidian");
var GitSyncModal = class extends import_obsidian4.Modal {
  constructor(app, onCompleteCallback) {
    super(app);
    this.onCompleteCallback = onCompleteCallback;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", { text: "Git sync?" });
    contentEl.createEl("span", {
      text: "This will sync with the remote branch."
    });
    new import_obsidian4.Setting(contentEl).setHeading().addButton(
      (btn) => btn.setButtonText("Cancel").onClick(() => {
        this.close();
      })
    ).addButton((btn) => {
      btn.setButtonText("Sync").setClass("bg-theme").onClick(() => {
        this.onCompleteCallback();
        this.close();
      });
    });
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};

// src/config/config.ts
var DEFAULT_SETTINGS = {
  gitRemote: null
};
var IS_DEBUG_MODE = false;

// src/debug/debug.modal.ts
var import_obsidian5 = require("obsidian");
var DebugModal = class extends import_obsidian5.Modal {
  constructor(app, contents) {
    super(app);
    this.heading = "Git Integration Plugin debug message:";
    this.contents = contents;
  }
  onOpen() {
    const { contentEl } = this;
    contentEl.createEl("h1", {
      text: this.heading
    });
    contentEl.createEl("span", { text: this.contents });
  }
};

// src/debug/error.modal.ts
var ErrorModal = class extends DebugModal {
  constructor(app, contents) {
    super(app, contents);
    this.heading = "Git Integration Plugin ran into an error:";
  }
};

// node_modules/simple-git/dist/esm/index.js
var import_file_exists = __toESM(require_dist(), 1);
var import_debug2 = __toESM(require_browser(), 1);
var import_child_process = require("child_process");
var import_promise_deferred = __toESM(require_dist2(), 1);
var import_promise_deferred2 = __toESM(require_dist2(), 1);
var __defProp2 = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames2 = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp2 = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp2.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __markAsModule = (target) => __defProp2(target, "__esModule", { value: true });
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames2(fn)[0]])(fn = 0)), res;
};
var __commonJS2 = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames2(module2))
      if (!__hasOwnProp2.call(target, key) && (copyDefault || key !== "default"))
        __defProp2(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc2(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toCommonJS2 = /* @__PURE__ */ ((cache2) => {
  return (module2, temp) => {
    return cache2 && cache2.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache2 && cache2.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
function pathspec(...paths) {
  const key = new String(paths);
  cache.set(key, paths);
  return key;
}
function isPathSpec(path) {
  return path instanceof String && cache.has(path);
}
function toPaths(pathSpec) {
  return cache.get(pathSpec) || [];
}
var cache;
var init_pathspec = __esm({
  "src/lib/args/pathspec.ts"() {
    cache = /* @__PURE__ */ new WeakMap();
  }
});
var GitError;
var init_git_error = __esm({
  "src/lib/errors/git-error.ts"() {
    GitError = class extends Error {
      constructor(task, message) {
        super(message);
        this.task = task;
        Object.setPrototypeOf(this, new.target.prototype);
      }
    };
  }
});
var GitResponseError;
var init_git_response_error = __esm({
  "src/lib/errors/git-response-error.ts"() {
    init_git_error();
    GitResponseError = class extends GitError {
      constructor(git, message) {
        super(void 0, message || String(git));
        this.git = git;
      }
    };
  }
});
var TaskConfigurationError;
var init_task_configuration_error = __esm({
  "src/lib/errors/task-configuration-error.ts"() {
    init_git_error();
    TaskConfigurationError = class extends GitError {
      constructor(message) {
        super(void 0, message);
      }
    };
  }
});
function asFunction(source) {
  return typeof source === "function" ? source : NOOP;
}
function isUserFunction(source) {
  return typeof source === "function" && source !== NOOP;
}
function splitOn(input, char) {
  const index = input.indexOf(char);
  if (index <= 0) {
    return [input, ""];
  }
  return [input.substr(0, index), input.substr(index + 1)];
}
function first(input, offset = 0) {
  return isArrayLike(input) && input.length > offset ? input[offset] : void 0;
}
function last(input, offset = 0) {
  if (isArrayLike(input) && input.length > offset) {
    return input[input.length - 1 - offset];
  }
}
function isArrayLike(input) {
  return !!(input && typeof input.length === "number");
}
function toLinesWithContent(input = "", trimmed2 = true, separator = "\n") {
  return input.split(separator).reduce((output, line) => {
    const lineContent = trimmed2 ? line.trim() : line;
    if (lineContent) {
      output.push(lineContent);
    }
    return output;
  }, []);
}
function forEachLineWithContent(input, callback) {
  return toLinesWithContent(input, true).map((line) => callback(line));
}
function folderExists(path) {
  return (0, import_file_exists.exists)(path, import_file_exists.FOLDER);
}
function append(target, item) {
  if (Array.isArray(target)) {
    if (!target.includes(item)) {
      target.push(item);
    }
  } else {
    target.add(item);
  }
  return item;
}
function including(target, item) {
  if (Array.isArray(target) && !target.includes(item)) {
    target.push(item);
  }
  return target;
}
function remove(target, item) {
  if (Array.isArray(target)) {
    const index = target.indexOf(item);
    if (index >= 0) {
      target.splice(index, 1);
    }
  } else {
    target.delete(item);
  }
  return item;
}
function asArray(source) {
  return Array.isArray(source) ? source : [source];
}
function asStringArray(source) {
  return asArray(source).map(String);
}
function asNumber(source, onNaN = 0) {
  if (source == null) {
    return onNaN;
  }
  const num = parseInt(source, 10);
  return isNaN(num) ? onNaN : num;
}
function prefixedArray(input, prefix) {
  const output = [];
  for (let i = 0, max = input.length; i < max; i++) {
    output.push(prefix, input[i]);
  }
  return output;
}
function bufferToString(input) {
  return (Array.isArray(input) ? Buffer.concat(input) : input).toString("utf-8");
}
function pick(source, properties) {
  return Object.assign({}, ...properties.map((property) => property in source ? { [property]: source[property] } : {}));
}
function delay(duration = 0) {
  return new Promise((done) => setTimeout(done, duration));
}
function orVoid(input) {
  if (input === false) {
    return void 0;
  }
  return input;
}
var NULL;
var NOOP;
var objectToString;
var init_util = __esm({
  "src/lib/utils/util.ts"() {
    NULL = "\0";
    NOOP = () => {
    };
    objectToString = Object.prototype.toString.call.bind(Object.prototype.toString);
  }
});
function filterType(input, filter, def) {
  if (filter(input)) {
    return input;
  }
  return arguments.length > 2 ? def : void 0;
}
function filterPrimitives(input, omit) {
  const type = isPathSpec(input) ? "string" : typeof input;
  return /number|string|boolean/.test(type) && (!omit || !omit.includes(type));
}
function filterPlainObject(input) {
  return !!input && objectToString(input) === "[object Object]";
}
function filterFunction(input) {
  return typeof input === "function";
}
var filterArray;
var filterString;
var filterStringArray;
var filterStringOrStringArray;
var filterHasLength;
var init_argument_filters = __esm({
  "src/lib/utils/argument-filters.ts"() {
    init_util();
    init_pathspec();
    filterArray = (input) => {
      return Array.isArray(input);
    };
    filterString = (input) => {
      return typeof input === "string";
    };
    filterStringArray = (input) => {
      return Array.isArray(input) && input.every(filterString);
    };
    filterStringOrStringArray = (input) => {
      return filterString(input) || Array.isArray(input) && input.every(filterString);
    };
    filterHasLength = (input) => {
      if (input == null || "number|boolean|function".includes(typeof input)) {
        return false;
      }
      return Array.isArray(input) || typeof input === "string" || typeof input.length === "number";
    };
  }
});
var ExitCodes;
var init_exit_codes = __esm({
  "src/lib/utils/exit-codes.ts"() {
    ExitCodes = /* @__PURE__ */ ((ExitCodes2) => {
      ExitCodes2[ExitCodes2["SUCCESS"] = 0] = "SUCCESS";
      ExitCodes2[ExitCodes2["ERROR"] = 1] = "ERROR";
      ExitCodes2[ExitCodes2["NOT_FOUND"] = -2] = "NOT_FOUND";
      ExitCodes2[ExitCodes2["UNCLEAN"] = 128] = "UNCLEAN";
      return ExitCodes2;
    })(ExitCodes || {});
  }
});
var GitOutputStreams;
var init_git_output_streams = __esm({
  "src/lib/utils/git-output-streams.ts"() {
    GitOutputStreams = class {
      constructor(stdOut, stdErr) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
      }
      asStrings() {
        return new GitOutputStreams(this.stdOut.toString("utf8"), this.stdErr.toString("utf8"));
      }
    };
  }
});
var LineParser;
var RemoteLineParser;
var init_line_parser = __esm({
  "src/lib/utils/line-parser.ts"() {
    LineParser = class {
      constructor(regExp, useMatches) {
        this.matches = [];
        this.parse = (line, target) => {
          this.resetMatches();
          if (!this._regExp.every((reg, index) => this.addMatch(reg, index, line(index)))) {
            return false;
          }
          return this.useMatches(target, this.prepareMatches()) !== false;
        };
        this._regExp = Array.isArray(regExp) ? regExp : [regExp];
        if (useMatches) {
          this.useMatches = useMatches;
        }
      }
      useMatches(target, match) {
        throw new Error(`LineParser:useMatches not implemented`);
      }
      resetMatches() {
        this.matches.length = 0;
      }
      prepareMatches() {
        return this.matches;
      }
      addMatch(reg, index, line) {
        const matched = line && reg.exec(line);
        if (matched) {
          this.pushMatch(index, matched);
        }
        return !!matched;
      }
      pushMatch(_index, matched) {
        this.matches.push(...matched.slice(1));
      }
    };
    RemoteLineParser = class extends LineParser {
      addMatch(reg, index, line) {
        return /^remote:\s/.test(String(line)) && super.addMatch(reg, index, line);
      }
      pushMatch(index, matched) {
        if (index > 0 || matched.length > 1) {
          super.pushMatch(index, matched);
        }
      }
    };
  }
});
function createInstanceConfig(...options) {
  const baseDir = process.cwd();
  const config = Object.assign(__spreadValues({ baseDir }, defaultOptions), ...options.filter((o) => typeof o === "object" && o));
  config.baseDir = config.baseDir || baseDir;
  config.trimmed = config.trimmed === true;
  return config;
}
var defaultOptions;
var init_simple_git_options = __esm({
  "src/lib/utils/simple-git-options.ts"() {
    defaultOptions = {
      binary: "git",
      maxConcurrentProcesses: 5,
      config: [],
      trimmed: false
    };
  }
});
function appendTaskOptions(options, commands = []) {
  if (!filterPlainObject(options)) {
    return commands;
  }
  return Object.keys(options).reduce((commands2, key) => {
    const value = options[key];
    if (isPathSpec(value)) {
      commands2.push(value);
    } else if (filterPrimitives(value, ["boolean"])) {
      commands2.push(key + "=" + value);
    } else {
      commands2.push(key);
    }
    return commands2;
  }, commands);
}
function getTrailingOptions(args, initialPrimitive = 0, objectOnly = false) {
  const command = [];
  for (let i = 0, max = initialPrimitive < 0 ? args.length : initialPrimitive; i < max; i++) {
    if ("string|number".includes(typeof args[i])) {
      command.push(String(args[i]));
    }
  }
  appendTaskOptions(trailingOptionsArgument(args), command);
  if (!objectOnly) {
    command.push(...trailingArrayArgument(args));
  }
  return command;
}
function trailingArrayArgument(args) {
  const hasTrailingCallback = typeof last(args) === "function";
  return filterType(last(args, hasTrailingCallback ? 1 : 0), filterArray, []);
}
function trailingOptionsArgument(args) {
  const hasTrailingCallback = filterFunction(last(args));
  return filterType(last(args, hasTrailingCallback ? 1 : 0), filterPlainObject);
}
function trailingFunctionArgument(args, includeNoop = true) {
  const callback = asFunction(last(args));
  return includeNoop || isUserFunction(callback) ? callback : void 0;
}
var init_task_options = __esm({
  "src/lib/utils/task-options.ts"() {
    init_argument_filters();
    init_util();
    init_pathspec();
  }
});
function callTaskParser(parser3, streams) {
  return parser3(streams.stdOut, streams.stdErr);
}
function parseStringResponse(result, parsers12, texts, trim = true) {
  asArray(texts).forEach((text) => {
    for (let lines = toLinesWithContent(text, trim), i = 0, max = lines.length; i < max; i++) {
      const line = (offset = 0) => {
        if (i + offset >= max) {
          return;
        }
        return lines[i + offset];
      };
      parsers12.some(({ parse }) => parse(line, result));
    }
  });
  return result;
}
var init_task_parser = __esm({
  "src/lib/utils/task-parser.ts"() {
    init_util();
  }
});
var utils_exports = {};
__export2(utils_exports, {
  ExitCodes: () => ExitCodes,
  GitOutputStreams: () => GitOutputStreams,
  LineParser: () => LineParser,
  NOOP: () => NOOP,
  NULL: () => NULL,
  RemoteLineParser: () => RemoteLineParser,
  append: () => append,
  appendTaskOptions: () => appendTaskOptions,
  asArray: () => asArray,
  asFunction: () => asFunction,
  asNumber: () => asNumber,
  asStringArray: () => asStringArray,
  bufferToString: () => bufferToString,
  callTaskParser: () => callTaskParser,
  createInstanceConfig: () => createInstanceConfig,
  delay: () => delay,
  filterArray: () => filterArray,
  filterFunction: () => filterFunction,
  filterHasLength: () => filterHasLength,
  filterPlainObject: () => filterPlainObject,
  filterPrimitives: () => filterPrimitives,
  filterString: () => filterString,
  filterStringArray: () => filterStringArray,
  filterStringOrStringArray: () => filterStringOrStringArray,
  filterType: () => filterType,
  first: () => first,
  folderExists: () => folderExists,
  forEachLineWithContent: () => forEachLineWithContent,
  getTrailingOptions: () => getTrailingOptions,
  including: () => including,
  isUserFunction: () => isUserFunction,
  last: () => last,
  objectToString: () => objectToString,
  orVoid: () => orVoid,
  parseStringResponse: () => parseStringResponse,
  pick: () => pick,
  prefixedArray: () => prefixedArray,
  remove: () => remove,
  splitOn: () => splitOn,
  toLinesWithContent: () => toLinesWithContent,
  trailingFunctionArgument: () => trailingFunctionArgument,
  trailingOptionsArgument: () => trailingOptionsArgument
});
var init_utils = __esm({
  "src/lib/utils/index.ts"() {
    init_argument_filters();
    init_exit_codes();
    init_git_output_streams();
    init_line_parser();
    init_simple_git_options();
    init_task_options();
    init_task_parser();
    init_util();
  }
});
var check_is_repo_exports = {};
__export2(check_is_repo_exports, {
  CheckRepoActions: () => CheckRepoActions,
  checkIsBareRepoTask: () => checkIsBareRepoTask,
  checkIsRepoRootTask: () => checkIsRepoRootTask,
  checkIsRepoTask: () => checkIsRepoTask
});
function checkIsRepoTask(action) {
  switch (action) {
    case "bare":
      return checkIsBareRepoTask();
    case "root":
      return checkIsRepoRootTask();
  }
  const commands = ["rev-parse", "--is-inside-work-tree"];
  return {
    commands,
    format: "utf-8",
    onError,
    parser
  };
}
function checkIsRepoRootTask() {
  const commands = ["rev-parse", "--git-dir"];
  return {
    commands,
    format: "utf-8",
    onError,
    parser(path) {
      return /^\.(git)?$/.test(path.trim());
    }
  };
}
function checkIsBareRepoTask() {
  const commands = ["rev-parse", "--is-bare-repository"];
  return {
    commands,
    format: "utf-8",
    onError,
    parser
  };
}
function isNotRepoMessage(error) {
  return /(Not a git repository|Kein Git-Repository)/i.test(String(error));
}
var CheckRepoActions;
var onError;
var parser;
var init_check_is_repo = __esm({
  "src/lib/tasks/check-is-repo.ts"() {
    init_utils();
    CheckRepoActions = /* @__PURE__ */ ((CheckRepoActions2) => {
      CheckRepoActions2["BARE"] = "bare";
      CheckRepoActions2["IN_TREE"] = "tree";
      CheckRepoActions2["IS_REPO_ROOT"] = "root";
      return CheckRepoActions2;
    })(CheckRepoActions || {});
    onError = ({ exitCode }, error, done, fail) => {
      if (exitCode === 128 && isNotRepoMessage(error)) {
        return done(Buffer.from("false"));
      }
      fail(error);
    };
    parser = (text) => {
      return text.trim() === "true";
    };
  }
});
function cleanSummaryParser(dryRun, text) {
  const summary = new CleanResponse(dryRun);
  const regexp = dryRun ? dryRunRemovalRegexp : removalRegexp;
  toLinesWithContent(text).forEach((line) => {
    const removed = line.replace(regexp, "");
    summary.paths.push(removed);
    (isFolderRegexp.test(removed) ? summary.folders : summary.files).push(removed);
  });
  return summary;
}
var CleanResponse;
var removalRegexp;
var dryRunRemovalRegexp;
var isFolderRegexp;
var init_CleanSummary = __esm({
  "src/lib/responses/CleanSummary.ts"() {
    init_utils();
    CleanResponse = class {
      constructor(dryRun) {
        this.dryRun = dryRun;
        this.paths = [];
        this.files = [];
        this.folders = [];
      }
    };
    removalRegexp = /^[a-z]+\s*/i;
    dryRunRemovalRegexp = /^[a-z]+\s+[a-z]+\s*/i;
    isFolderRegexp = /\/$/;
  }
});
var task_exports = {};
__export2(task_exports, {
  EMPTY_COMMANDS: () => EMPTY_COMMANDS,
  adhocExecTask: () => adhocExecTask,
  configurationErrorTask: () => configurationErrorTask,
  isBufferTask: () => isBufferTask,
  isEmptyTask: () => isEmptyTask,
  straightThroughBufferTask: () => straightThroughBufferTask,
  straightThroughStringTask: () => straightThroughStringTask
});
function adhocExecTask(parser3) {
  return {
    commands: EMPTY_COMMANDS,
    format: "empty",
    parser: parser3
  };
}
function configurationErrorTask(error) {
  return {
    commands: EMPTY_COMMANDS,
    format: "empty",
    parser() {
      throw typeof error === "string" ? new TaskConfigurationError(error) : error;
    }
  };
}
function straightThroughStringTask(commands, trimmed2 = false) {
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return trimmed2 ? String(text).trim() : text;
    }
  };
}
function straightThroughBufferTask(commands) {
  return {
    commands,
    format: "buffer",
    parser(buffer) {
      return buffer;
    }
  };
}
function isBufferTask(task) {
  return task.format === "buffer";
}
function isEmptyTask(task) {
  return task.format === "empty" || !task.commands.length;
}
var EMPTY_COMMANDS;
var init_task = __esm({
  "src/lib/tasks/task.ts"() {
    init_task_configuration_error();
    EMPTY_COMMANDS = [];
  }
});
var clean_exports = {};
__export2(clean_exports, {
  CONFIG_ERROR_INTERACTIVE_MODE: () => CONFIG_ERROR_INTERACTIVE_MODE,
  CONFIG_ERROR_MODE_REQUIRED: () => CONFIG_ERROR_MODE_REQUIRED,
  CONFIG_ERROR_UNKNOWN_OPTION: () => CONFIG_ERROR_UNKNOWN_OPTION,
  CleanOptions: () => CleanOptions,
  cleanTask: () => cleanTask,
  cleanWithOptionsTask: () => cleanWithOptionsTask,
  isCleanOptionsArray: () => isCleanOptionsArray
});
function cleanWithOptionsTask(mode, customArgs) {
  const { cleanMode, options, valid } = getCleanOptions(mode);
  if (!cleanMode) {
    return configurationErrorTask(CONFIG_ERROR_MODE_REQUIRED);
  }
  if (!valid.options) {
    return configurationErrorTask(CONFIG_ERROR_UNKNOWN_OPTION + JSON.stringify(mode));
  }
  options.push(...customArgs);
  if (options.some(isInteractiveMode)) {
    return configurationErrorTask(CONFIG_ERROR_INTERACTIVE_MODE);
  }
  return cleanTask(cleanMode, options);
}
function cleanTask(mode, customArgs) {
  const commands = ["clean", `-${mode}`, ...customArgs];
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return cleanSummaryParser(mode === "n", text);
    }
  };
}
function isCleanOptionsArray(input) {
  return Array.isArray(input) && input.every((test) => CleanOptionValues.has(test));
}
function getCleanOptions(input) {
  let cleanMode;
  let options = [];
  let valid = { cleanMode: false, options: true };
  input.replace(/[^a-z]i/g, "").split("").forEach((char) => {
    if (isCleanMode(char)) {
      cleanMode = char;
      valid.cleanMode = true;
    } else {
      valid.options = valid.options && isKnownOption(options[options.length] = `-${char}`);
    }
  });
  return {
    cleanMode,
    options,
    valid
  };
}
function isCleanMode(cleanMode) {
  return cleanMode === "f" || cleanMode === "n";
}
function isKnownOption(option) {
  return /^-[a-z]$/i.test(option) && CleanOptionValues.has(option.charAt(1));
}
function isInteractiveMode(option) {
  if (/^-[^\-]/.test(option)) {
    return option.indexOf("i") > 0;
  }
  return option === "--interactive";
}
var CONFIG_ERROR_INTERACTIVE_MODE;
var CONFIG_ERROR_MODE_REQUIRED;
var CONFIG_ERROR_UNKNOWN_OPTION;
var CleanOptions;
var CleanOptionValues;
var init_clean = __esm({
  "src/lib/tasks/clean.ts"() {
    init_CleanSummary();
    init_utils();
    init_task();
    CONFIG_ERROR_INTERACTIVE_MODE = "Git clean interactive mode is not supported";
    CONFIG_ERROR_MODE_REQUIRED = 'Git clean mode parameter ("n" or "f") is required';
    CONFIG_ERROR_UNKNOWN_OPTION = "Git clean unknown option found in: ";
    CleanOptions = /* @__PURE__ */ ((CleanOptions2) => {
      CleanOptions2["DRY_RUN"] = "n";
      CleanOptions2["FORCE"] = "f";
      CleanOptions2["IGNORED_INCLUDED"] = "x";
      CleanOptions2["IGNORED_ONLY"] = "X";
      CleanOptions2["EXCLUDING"] = "e";
      CleanOptions2["QUIET"] = "q";
      CleanOptions2["RECURSIVE"] = "d";
      return CleanOptions2;
    })(CleanOptions || {});
    CleanOptionValues = /* @__PURE__ */ new Set([
      "i",
      ...asStringArray(Object.values(CleanOptions))
    ]);
  }
});
function configListParser(text) {
  const config = new ConfigList();
  for (const item of configParser(text)) {
    config.addValue(item.file, String(item.key), item.value);
  }
  return config;
}
function configGetParser(text, key) {
  let value = null;
  const values = [];
  const scopes = /* @__PURE__ */ new Map();
  for (const item of configParser(text, key)) {
    if (item.key !== key) {
      continue;
    }
    values.push(value = item.value);
    if (!scopes.has(item.file)) {
      scopes.set(item.file, []);
    }
    scopes.get(item.file).push(value);
  }
  return {
    key,
    paths: Array.from(scopes.keys()),
    scopes,
    value,
    values
  };
}
function configFilePath(filePath) {
  return filePath.replace(/^(file):/, "");
}
function* configParser(text, requestedKey = null) {
  const lines = text.split("\0");
  for (let i = 0, max = lines.length - 1; i < max; ) {
    const file = configFilePath(lines[i++]);
    let value = lines[i++];
    let key = requestedKey;
    if (value.includes("\n")) {
      const line = splitOn(value, "\n");
      key = line[0];
      value = line[1];
    }
    yield { file, key, value };
  }
}
var ConfigList;
var init_ConfigList = __esm({
  "src/lib/responses/ConfigList.ts"() {
    init_utils();
    ConfigList = class {
      constructor() {
        this.files = [];
        this.values = /* @__PURE__ */ Object.create(null);
      }
      get all() {
        if (!this._all) {
          this._all = this.files.reduce((all, file) => {
            return Object.assign(all, this.values[file]);
          }, {});
        }
        return this._all;
      }
      addFile(file) {
        if (!(file in this.values)) {
          const latest = last(this.files);
          this.values[file] = latest ? Object.create(this.values[latest]) : {};
          this.files.push(file);
        }
        return this.values[file];
      }
      addValue(file, key, value) {
        const values = this.addFile(file);
        if (!values.hasOwnProperty(key)) {
          values[key] = value;
        } else if (Array.isArray(values[key])) {
          values[key].push(value);
        } else {
          values[key] = [values[key], value];
        }
        this._all = void 0;
      }
    };
  }
});
function asConfigScope(scope, fallback) {
  if (typeof scope === "string" && GitConfigScope.hasOwnProperty(scope)) {
    return scope;
  }
  return fallback;
}
function addConfigTask(key, value, append2, scope) {
  const commands = ["config", `--${scope}`];
  if (append2) {
    commands.push("--add");
  }
  commands.push(key, value);
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return text;
    }
  };
}
function getConfigTask(key, scope) {
  const commands = ["config", "--null", "--show-origin", "--get-all", key];
  if (scope) {
    commands.splice(1, 0, `--${scope}`);
  }
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return configGetParser(text, key);
    }
  };
}
function listConfigTask(scope) {
  const commands = ["config", "--list", "--show-origin", "--null"];
  if (scope) {
    commands.push(`--${scope}`);
  }
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return configListParser(text);
    }
  };
}
function config_default() {
  return {
    addConfig(key, value, ...rest) {
      return this._runTask(addConfigTask(key, value, rest[0] === true, asConfigScope(
        rest[1],
        "local"
        /* local */
      )), trailingFunctionArgument(arguments));
    },
    getConfig(key, scope) {
      return this._runTask(getConfigTask(key, asConfigScope(scope, void 0)), trailingFunctionArgument(arguments));
    },
    listConfig(...rest) {
      return this._runTask(listConfigTask(asConfigScope(rest[0], void 0)), trailingFunctionArgument(arguments));
    }
  };
}
var GitConfigScope;
var init_config = __esm({
  "src/lib/tasks/config.ts"() {
    init_ConfigList();
    init_utils();
    GitConfigScope = /* @__PURE__ */ ((GitConfigScope2) => {
      GitConfigScope2["system"] = "system";
      GitConfigScope2["global"] = "global";
      GitConfigScope2["local"] = "local";
      GitConfigScope2["worktree"] = "worktree";
      return GitConfigScope2;
    })(GitConfigScope || {});
  }
});
function isDiffNameStatus(input) {
  return diffNameStatus.has(input);
}
var DiffNameStatus;
var diffNameStatus;
var init_diff_name_status = __esm({
  "src/lib/tasks/diff-name-status.ts"() {
    DiffNameStatus = /* @__PURE__ */ ((DiffNameStatus2) => {
      DiffNameStatus2["ADDED"] = "A";
      DiffNameStatus2["COPIED"] = "C";
      DiffNameStatus2["DELETED"] = "D";
      DiffNameStatus2["MODIFIED"] = "M";
      DiffNameStatus2["RENAMED"] = "R";
      DiffNameStatus2["CHANGED"] = "T";
      DiffNameStatus2["UNMERGED"] = "U";
      DiffNameStatus2["UNKNOWN"] = "X";
      DiffNameStatus2["BROKEN"] = "B";
      return DiffNameStatus2;
    })(DiffNameStatus || {});
    diffNameStatus = new Set(Object.values(DiffNameStatus));
  }
});
function grepQueryBuilder(...params) {
  return new GrepQuery().param(...params);
}
function parseGrep(grep) {
  const paths = /* @__PURE__ */ new Set();
  const results = {};
  forEachLineWithContent(grep, (input) => {
    const [path, line, preview] = input.split(NULL);
    paths.add(path);
    (results[path] = results[path] || []).push({
      line: asNumber(line),
      path,
      preview
    });
  });
  return {
    paths,
    results
  };
}
function grep_default() {
  return {
    grep(searchTerm) {
      const then = trailingFunctionArgument(arguments);
      const options = getTrailingOptions(arguments);
      for (const option of disallowedOptions) {
        if (options.includes(option)) {
          return this._runTask(configurationErrorTask(`git.grep: use of "${option}" is not supported.`), then);
        }
      }
      if (typeof searchTerm === "string") {
        searchTerm = grepQueryBuilder().param(searchTerm);
      }
      const commands = ["grep", "--null", "-n", "--full-name", ...options, ...searchTerm];
      return this._runTask({
        commands,
        format: "utf-8",
        parser(stdOut) {
          return parseGrep(stdOut);
        }
      }, then);
    }
  };
}
var disallowedOptions;
var Query;
var _a;
var GrepQuery;
var init_grep = __esm({
  "src/lib/tasks/grep.ts"() {
    init_utils();
    init_task();
    disallowedOptions = ["-h"];
    Query = Symbol("grepQuery");
    GrepQuery = class {
      constructor() {
        this[_a] = [];
      }
      *[(_a = Query, Symbol.iterator)]() {
        for (const query of this[Query]) {
          yield query;
        }
      }
      and(...and) {
        and.length && this[Query].push("--and", "(", ...prefixedArray(and, "-e"), ")");
        return this;
      }
      param(...param) {
        this[Query].push(...prefixedArray(param, "-e"));
        return this;
      }
    };
  }
});
var reset_exports = {};
__export2(reset_exports, {
  ResetMode: () => ResetMode,
  getResetMode: () => getResetMode,
  resetTask: () => resetTask
});
function resetTask(mode, customArgs) {
  const commands = ["reset"];
  if (isValidResetMode(mode)) {
    commands.push(`--${mode}`);
  }
  commands.push(...customArgs);
  return straightThroughStringTask(commands);
}
function getResetMode(mode) {
  if (isValidResetMode(mode)) {
    return mode;
  }
  switch (typeof mode) {
    case "string":
    case "undefined":
      return "soft";
  }
  return;
}
function isValidResetMode(mode) {
  return ResetModes.includes(mode);
}
var ResetMode;
var ResetModes;
var init_reset = __esm({
  "src/lib/tasks/reset.ts"() {
    init_task();
    ResetMode = /* @__PURE__ */ ((ResetMode2) => {
      ResetMode2["MIXED"] = "mixed";
      ResetMode2["SOFT"] = "soft";
      ResetMode2["HARD"] = "hard";
      ResetMode2["MERGE"] = "merge";
      ResetMode2["KEEP"] = "keep";
      return ResetMode2;
    })(ResetMode || {});
    ResetModes = Array.from(Object.values(ResetMode));
  }
});
function createLog() {
  return (0, import_debug2.default)("simple-git");
}
function prefixedLogger(to, prefix, forward) {
  if (!prefix || !String(prefix).replace(/\s*/, "")) {
    return !forward ? to : (message, ...args) => {
      to(message, ...args);
      forward(message, ...args);
    };
  }
  return (message, ...args) => {
    to(`%s ${message}`, prefix, ...args);
    if (forward) {
      forward(message, ...args);
    }
  };
}
function childLoggerName(name, childDebugger, { namespace: parentNamespace }) {
  if (typeof name === "string") {
    return name;
  }
  const childNamespace = childDebugger && childDebugger.namespace || "";
  if (childNamespace.startsWith(parentNamespace)) {
    return childNamespace.substr(parentNamespace.length + 1);
  }
  return childNamespace || parentNamespace;
}
function createLogger(label, verbose, initialStep, infoDebugger = createLog()) {
  const labelPrefix = label && `[${label}]` || "";
  const spawned = [];
  const debugDebugger = typeof verbose === "string" ? infoDebugger.extend(verbose) : verbose;
  const key = childLoggerName(filterType(verbose, filterString), debugDebugger, infoDebugger);
  return step(initialStep);
  function sibling(name, initial) {
    return append(spawned, createLogger(label, key.replace(/^[^:]+/, name), initial, infoDebugger));
  }
  function step(phase) {
    const stepPrefix = phase && `[${phase}]` || "";
    const debug2 = debugDebugger && prefixedLogger(debugDebugger, stepPrefix) || NOOP;
    const info = prefixedLogger(infoDebugger, `${labelPrefix} ${stepPrefix}`, debug2);
    return Object.assign(debugDebugger ? debug2 : info, {
      label,
      sibling,
      info,
      step
    });
  }
}
var init_git_logger = __esm({
  "src/lib/git-logger.ts"() {
    init_utils();
    import_debug2.default.formatters.L = (value) => String(filterHasLength(value) ? value.length : "-");
    import_debug2.default.formatters.B = (value) => {
      if (Buffer.isBuffer(value)) {
        return value.toString("utf8");
      }
      return objectToString(value);
    };
  }
});
var _TasksPendingQueue;
var TasksPendingQueue;
var init_tasks_pending_queue = __esm({
  "src/lib/runners/tasks-pending-queue.ts"() {
    init_git_error();
    init_git_logger();
    _TasksPendingQueue = class {
      constructor(logLabel = "GitExecutor") {
        this.logLabel = logLabel;
        this._queue = /* @__PURE__ */ new Map();
      }
      withProgress(task) {
        return this._queue.get(task);
      }
      createProgress(task) {
        const name = _TasksPendingQueue.getName(task.commands[0]);
        const logger = createLogger(this.logLabel, name);
        return {
          task,
          logger,
          name
        };
      }
      push(task) {
        const progress = this.createProgress(task);
        progress.logger("Adding task to the queue, commands = %o", task.commands);
        this._queue.set(task, progress);
        return progress;
      }
      fatal(err) {
        for (const [task, { logger }] of Array.from(this._queue.entries())) {
          if (task === err.task) {
            logger.info(`Failed %o`, err);
            logger(`Fatal exception, any as-yet un-started tasks run through this executor will not be attempted`);
          } else {
            logger.info(`A fatal exception occurred in a previous task, the queue has been purged: %o`, err.message);
          }
          this.complete(task);
        }
        if (this._queue.size !== 0) {
          throw new Error(`Queue size should be zero after fatal: ${this._queue.size}`);
        }
      }
      complete(task) {
        const progress = this.withProgress(task);
        if (progress) {
          this._queue.delete(task);
        }
      }
      attempt(task) {
        const progress = this.withProgress(task);
        if (!progress) {
          throw new GitError(void 0, "TasksPendingQueue: attempt called for an unknown task");
        }
        progress.logger("Starting task");
        return progress;
      }
      static getName(name = "empty") {
        return `task:${name}:${++_TasksPendingQueue.counter}`;
      }
    };
    TasksPendingQueue = _TasksPendingQueue;
    TasksPendingQueue.counter = 0;
  }
});
function pluginContext(task, commands) {
  return {
    method: first(task.commands) || "",
    commands
  };
}
function onErrorReceived(target, logger) {
  return (err) => {
    logger(`[ERROR] child process exception %o`, err);
    target.push(Buffer.from(String(err.stack), "ascii"));
  };
}
function onDataReceived(target, name, logger, output) {
  return (buffer) => {
    logger(`%s received %L bytes`, name, buffer);
    output(`%B`, buffer);
    target.push(buffer);
  };
}
var GitExecutorChain;
var init_git_executor_chain = __esm({
  "src/lib/runners/git-executor-chain.ts"() {
    init_git_error();
    init_task();
    init_utils();
    init_tasks_pending_queue();
    GitExecutorChain = class {
      constructor(_executor, _scheduler, _plugins) {
        this._executor = _executor;
        this._scheduler = _scheduler;
        this._plugins = _plugins;
        this._chain = Promise.resolve();
        this._queue = new TasksPendingQueue();
      }
      get binary() {
        return this._executor.binary;
      }
      get cwd() {
        return this._cwd || this._executor.cwd;
      }
      set cwd(cwd) {
        this._cwd = cwd;
      }
      get env() {
        return this._executor.env;
      }
      get outputHandler() {
        return this._executor.outputHandler;
      }
      chain() {
        return this;
      }
      push(task) {
        this._queue.push(task);
        return this._chain = this._chain.then(() => this.attemptTask(task));
      }
      attemptTask(task) {
        return __async(this, null, function* () {
          const onScheduleComplete = yield this._scheduler.next();
          const onQueueComplete = () => this._queue.complete(task);
          try {
            const { logger } = this._queue.attempt(task);
            return yield isEmptyTask(task) ? this.attemptEmptyTask(task, logger) : this.attemptRemoteTask(task, logger);
          } catch (e) {
            throw this.onFatalException(task, e);
          } finally {
            onQueueComplete();
            onScheduleComplete();
          }
        });
      }
      onFatalException(task, e) {
        const gitError = e instanceof GitError ? Object.assign(e, { task }) : new GitError(task, e && String(e));
        this._chain = Promise.resolve();
        this._queue.fatal(gitError);
        return gitError;
      }
      attemptRemoteTask(task, logger) {
        return __async(this, null, function* () {
          const args = this._plugins.exec("spawn.args", [...task.commands], pluginContext(task, task.commands));
          const raw = yield this.gitResponse(task, this.binary, args, this.outputHandler, logger.step("SPAWN"));
          const outputStreams = yield this.handleTaskData(task, args, raw, logger.step("HANDLE"));
          logger(`passing response to task's parser as a %s`, task.format);
          if (isBufferTask(task)) {
            return callTaskParser(task.parser, outputStreams);
          }
          return callTaskParser(task.parser, outputStreams.asStrings());
        });
      }
      attemptEmptyTask(task, logger) {
        return __async(this, null, function* () {
          logger(`empty task bypassing child process to call to task's parser`);
          return task.parser(this);
        });
      }
      handleTaskData(task, args, result, logger) {
        const { exitCode, rejection, stdOut, stdErr } = result;
        return new Promise((done, fail) => {
          logger(`Preparing to handle process response exitCode=%d stdOut=`, exitCode);
          const { error } = this._plugins.exec("task.error", { error: rejection }, __spreadValues(__spreadValues({}, pluginContext(task, args)), result));
          if (error && task.onError) {
            logger.info(`exitCode=%s handling with custom error handler`);
            return task.onError(result, error, (newStdOut) => {
              logger.info(`custom error handler treated as success`);
              logger(`custom error returned a %s`, objectToString(newStdOut));
              done(new GitOutputStreams(Array.isArray(newStdOut) ? Buffer.concat(newStdOut) : newStdOut, Buffer.concat(stdErr)));
            }, fail);
          }
          if (error) {
            logger.info(`handling as error: exitCode=%s stdErr=%s rejection=%o`, exitCode, stdErr.length, rejection);
            return fail(error);
          }
          logger.info(`retrieving task output complete`);
          done(new GitOutputStreams(Buffer.concat(stdOut), Buffer.concat(stdErr)));
        });
      }
      gitResponse(task, command, args, outputHandler, logger) {
        return __async(this, null, function* () {
          const outputLogger = logger.sibling("output");
          const spawnOptions = this._plugins.exec("spawn.options", {
            cwd: this.cwd,
            env: this.env,
            windowsHide: true
          }, pluginContext(task, task.commands));
          return new Promise((done) => {
            const stdOut = [];
            const stdErr = [];
            logger.info(`%s %o`, command, args);
            logger("%O", spawnOptions);
            let rejection = this._beforeSpawn(task, args);
            if (rejection) {
              return done({
                stdOut,
                stdErr,
                exitCode: 9901,
                rejection
              });
            }
            this._plugins.exec("spawn.before", void 0, __spreadProps(__spreadValues({}, pluginContext(task, args)), {
              kill(reason) {
                rejection = reason || rejection;
              }
            }));
            const spawned = (0, import_child_process.spawn)(command, args, spawnOptions);
            spawned.stdout.on("data", onDataReceived(stdOut, "stdOut", logger, outputLogger.step("stdOut")));
            spawned.stderr.on("data", onDataReceived(stdErr, "stdErr", logger, outputLogger.step("stdErr")));
            spawned.on("error", onErrorReceived(stdErr, logger));
            if (outputHandler) {
              logger(`Passing child process stdOut/stdErr to custom outputHandler`);
              outputHandler(command, spawned.stdout, spawned.stderr, [...args]);
            }
            this._plugins.exec("spawn.after", void 0, __spreadProps(__spreadValues({}, pluginContext(task, args)), {
              spawned,
              close(exitCode, reason) {
                done({
                  stdOut,
                  stdErr,
                  exitCode,
                  rejection: rejection || reason
                });
              },
              kill(reason) {
                if (spawned.killed) {
                  return;
                }
                rejection = reason;
                spawned.kill("SIGINT");
              }
            }));
          });
        });
      }
      _beforeSpawn(task, args) {
        let rejection;
        this._plugins.exec("spawn.before", void 0, __spreadProps(__spreadValues({}, pluginContext(task, args)), {
          kill(reason) {
            rejection = reason || rejection;
          }
        }));
        return rejection;
      }
    };
  }
});
var git_executor_exports = {};
__export2(git_executor_exports, {
  GitExecutor: () => GitExecutor
});
var GitExecutor;
var init_git_executor = __esm({
  "src/lib/runners/git-executor.ts"() {
    init_git_executor_chain();
    GitExecutor = class {
      constructor(binary = "git", cwd, _scheduler, _plugins) {
        this.binary = binary;
        this.cwd = cwd;
        this._scheduler = _scheduler;
        this._plugins = _plugins;
        this._chain = new GitExecutorChain(this, this._scheduler, this._plugins);
      }
      chain() {
        return new GitExecutorChain(this, this._scheduler, this._plugins);
      }
      push(task) {
        return this._chain.push(task);
      }
    };
  }
});
function taskCallback(task, response, callback = NOOP) {
  const onSuccess = (data) => {
    callback(null, data);
  };
  const onError2 = (err) => {
    if ((err == null ? void 0 : err.task) === task) {
      callback(err instanceof GitResponseError ? addDeprecationNoticeToError(err) : err, void 0);
    }
  };
  response.then(onSuccess, onError2);
}
function addDeprecationNoticeToError(err) {
  let log = (name) => {
    console.warn(`simple-git deprecation notice: accessing GitResponseError.${name} should be GitResponseError.git.${name}, this will no longer be available in version 3`);
    log = NOOP;
  };
  return Object.create(err, Object.getOwnPropertyNames(err.git).reduce(descriptorReducer, {}));
  function descriptorReducer(all, name) {
    if (name in err) {
      return all;
    }
    all[name] = {
      enumerable: false,
      configurable: false,
      get() {
        log(name);
        return err.git[name];
      }
    };
    return all;
  }
}
var init_task_callback = __esm({
  "src/lib/task-callback.ts"() {
    init_git_response_error();
    init_utils();
  }
});
function changeWorkingDirectoryTask(directory, root) {
  return adhocExecTask((instance) => {
    if (!folderExists(directory)) {
      throw new Error(`Git.cwd: cannot change to non-directory "${directory}"`);
    }
    return (root || instance).cwd = directory;
  });
}
var init_change_working_directory = __esm({
  "src/lib/tasks/change-working-directory.ts"() {
    init_utils();
    init_task();
  }
});
function checkoutTask(args) {
  const commands = ["checkout", ...args];
  if (commands[1] === "-b" && commands.includes("-B")) {
    commands[1] = remove(commands, "-B");
  }
  return straightThroughStringTask(commands);
}
function checkout_default() {
  return {
    checkout() {
      return this._runTask(checkoutTask(getTrailingOptions(arguments, 1)), trailingFunctionArgument(arguments));
    },
    checkoutBranch(branchName, startPoint) {
      return this._runTask(checkoutTask(["-b", branchName, startPoint, ...getTrailingOptions(arguments)]), trailingFunctionArgument(arguments));
    },
    checkoutLocalBranch(branchName) {
      return this._runTask(checkoutTask(["-b", branchName, ...getTrailingOptions(arguments)]), trailingFunctionArgument(arguments));
    }
  };
}
var init_checkout = __esm({
  "src/lib/tasks/checkout.ts"() {
    init_utils();
    init_task();
  }
});
function parseCommitResult(stdOut) {
  const result = {
    author: null,
    branch: "",
    commit: "",
    root: false,
    summary: {
      changes: 0,
      insertions: 0,
      deletions: 0
    }
  };
  return parseStringResponse(result, parsers, stdOut);
}
var parsers;
var init_parse_commit = __esm({
  "src/lib/parsers/parse-commit.ts"() {
    init_utils();
    parsers = [
      new LineParser(/^\[([^\s]+)( \([^)]+\))? ([^\]]+)/, (result, [branch, root, commit]) => {
        result.branch = branch;
        result.commit = commit;
        result.root = !!root;
      }),
      new LineParser(/\s*Author:\s(.+)/i, (result, [author]) => {
        const parts = author.split("<");
        const email = parts.pop();
        if (!email || !email.includes("@")) {
          return;
        }
        result.author = {
          email: email.substr(0, email.length - 1),
          name: parts.join("<").trim()
        };
      }),
      new LineParser(/(\d+)[^,]*(?:,\s*(\d+)[^,]*)(?:,\s*(\d+))/g, (result, [changes, insertions, deletions]) => {
        result.summary.changes = parseInt(changes, 10) || 0;
        result.summary.insertions = parseInt(insertions, 10) || 0;
        result.summary.deletions = parseInt(deletions, 10) || 0;
      }),
      new LineParser(/^(\d+)[^,]*(?:,\s*(\d+)[^(]+\(([+-]))?/, (result, [changes, lines, direction]) => {
        result.summary.changes = parseInt(changes, 10) || 0;
        const count = parseInt(lines, 10) || 0;
        if (direction === "-") {
          result.summary.deletions = count;
        } else if (direction === "+") {
          result.summary.insertions = count;
        }
      })
    ];
  }
});
function commitTask(message, files, customArgs) {
  const commands = [
    "-c",
    "core.abbrev=40",
    "commit",
    ...prefixedArray(message, "-m"),
    ...files,
    ...customArgs
  ];
  return {
    commands,
    format: "utf-8",
    parser: parseCommitResult
  };
}
function commit_default() {
  return {
    commit(message, ...rest) {
      const next = trailingFunctionArgument(arguments);
      const task = rejectDeprecatedSignatures(message) || commitTask(asArray(message), asArray(filterType(rest[0], filterStringOrStringArray, [])), [...filterType(rest[1], filterArray, []), ...getTrailingOptions(arguments, 0, true)]);
      return this._runTask(task, next);
    }
  };
  function rejectDeprecatedSignatures(message) {
    return !filterStringOrStringArray(message) && configurationErrorTask(`git.commit: requires the commit message to be supplied as a string/string[]`);
  }
}
var init_commit = __esm({
  "src/lib/tasks/commit.ts"() {
    init_parse_commit();
    init_utils();
    init_task();
  }
});
function first_commit_default() {
  return {
    firstCommit() {
      return this._runTask(straightThroughStringTask(["rev-list", "--max-parents=0", "HEAD"], true), trailingFunctionArgument(arguments));
    }
  };
}
var init_first_commit = __esm({
  "src/lib/tasks/first-commit.ts"() {
    init_utils();
    init_task();
  }
});
function hashObjectTask(filePath, write) {
  const commands = ["hash-object", filePath];
  if (write) {
    commands.push("-w");
  }
  return straightThroughStringTask(commands, true);
}
var init_hash_object = __esm({
  "src/lib/tasks/hash-object.ts"() {
    init_task();
  }
});
function parseInit(bare, path, text) {
  const response = String(text).trim();
  let result;
  if (result = initResponseRegex.exec(response)) {
    return new InitSummary(bare, path, false, result[1]);
  }
  if (result = reInitResponseRegex.exec(response)) {
    return new InitSummary(bare, path, true, result[1]);
  }
  let gitDir = "";
  const tokens = response.split(" ");
  while (tokens.length) {
    const token = tokens.shift();
    if (token === "in") {
      gitDir = tokens.join(" ");
      break;
    }
  }
  return new InitSummary(bare, path, /^re/i.test(response), gitDir);
}
var InitSummary;
var initResponseRegex;
var reInitResponseRegex;
var init_InitSummary = __esm({
  "src/lib/responses/InitSummary.ts"() {
    InitSummary = class {
      constructor(bare, path, existing, gitDir) {
        this.bare = bare;
        this.path = path;
        this.existing = existing;
        this.gitDir = gitDir;
      }
    };
    initResponseRegex = /^Init.+ repository in (.+)$/;
    reInitResponseRegex = /^Rein.+ in (.+)$/;
  }
});
function hasBareCommand(command) {
  return command.includes(bareCommand);
}
function initTask(bare = false, path, customArgs) {
  const commands = ["init", ...customArgs];
  if (bare && !hasBareCommand(commands)) {
    commands.splice(1, 0, bareCommand);
  }
  return {
    commands,
    format: "utf-8",
    parser(text) {
      return parseInit(commands.includes("--bare"), path, text);
    }
  };
}
var bareCommand;
var init_init = __esm({
  "src/lib/tasks/init.ts"() {
    init_InitSummary();
    bareCommand = "--bare";
  }
});
function logFormatFromCommand(customArgs) {
  for (let i = 0; i < customArgs.length; i++) {
    const format = logFormatRegex.exec(customArgs[i]);
    if (format) {
      return `--${format[1]}`;
    }
  }
  return "";
}
function isLogFormat(customArg) {
  return logFormatRegex.test(customArg);
}
var logFormatRegex;
var init_log_format = __esm({
  "src/lib/args/log-format.ts"() {
    logFormatRegex = /^--(stat|numstat|name-only|name-status)(=|$)/;
  }
});
var DiffSummary;
var init_DiffSummary = __esm({
  "src/lib/responses/DiffSummary.ts"() {
    DiffSummary = class {
      constructor() {
        this.changed = 0;
        this.deletions = 0;
        this.insertions = 0;
        this.files = [];
      }
    };
  }
});
function getDiffParser(format = "") {
  const parser3 = diffSummaryParsers[format];
  return (stdOut) => parseStringResponse(new DiffSummary(), parser3, stdOut, false);
}
var statParser;
var numStatParser;
var nameOnlyParser;
var nameStatusParser;
var diffSummaryParsers;
var init_parse_diff_summary = __esm({
  "src/lib/parsers/parse-diff-summary.ts"() {
    init_log_format();
    init_DiffSummary();
    init_diff_name_status();
    init_utils();
    statParser = [
      new LineParser(/(.+)\s+\|\s+(\d+)(\s+[+\-]+)?$/, (result, [file, changes, alterations = ""]) => {
        result.files.push({
          file: file.trim(),
          changes: asNumber(changes),
          insertions: alterations.replace(/[^+]/g, "").length,
          deletions: alterations.replace(/[^-]/g, "").length,
          binary: false
        });
      }),
      new LineParser(/(.+) \|\s+Bin ([0-9.]+) -> ([0-9.]+) ([a-z]+)/, (result, [file, before, after]) => {
        result.files.push({
          file: file.trim(),
          before: asNumber(before),
          after: asNumber(after),
          binary: true
        });
      }),
      new LineParser(/(\d+) files? changed\s*((?:, \d+ [^,]+){0,2})/, (result, [changed, summary]) => {
        const inserted = /(\d+) i/.exec(summary);
        const deleted = /(\d+) d/.exec(summary);
        result.changed = asNumber(changed);
        result.insertions = asNumber(inserted == null ? void 0 : inserted[1]);
        result.deletions = asNumber(deleted == null ? void 0 : deleted[1]);
      })
    ];
    numStatParser = [
      new LineParser(/(\d+)\t(\d+)\t(.+)$/, (result, [changesInsert, changesDelete, file]) => {
        const insertions = asNumber(changesInsert);
        const deletions = asNumber(changesDelete);
        result.changed++;
        result.insertions += insertions;
        result.deletions += deletions;
        result.files.push({
          file,
          changes: insertions + deletions,
          insertions,
          deletions,
          binary: false
        });
      }),
      new LineParser(/-\t-\t(.+)$/, (result, [file]) => {
        result.changed++;
        result.files.push({
          file,
          after: 0,
          before: 0,
          binary: true
        });
      })
    ];
    nameOnlyParser = [
      new LineParser(/(.+)$/, (result, [file]) => {
        result.changed++;
        result.files.push({
          file,
          changes: 0,
          insertions: 0,
          deletions: 0,
          binary: false
        });
      })
    ];
    nameStatusParser = [
      new LineParser(/([ACDMRTUXB])([0-9]{0,3})\t(.[^\t]*)(\t(.[^\t]*))?$/, (result, [status, _similarity, from, _to, to]) => {
        result.changed++;
        result.files.push({
          file: to != null ? to : from,
          changes: 0,
          status: orVoid(isDiffNameStatus(status) && status),
          insertions: 0,
          deletions: 0,
          binary: false
        });
      })
    ];
    diffSummaryParsers = {
      [
        ""
        /* NONE */
      ]: statParser,
      [
        "--stat"
        /* STAT */
      ]: statParser,
      [
        "--numstat"
        /* NUM_STAT */
      ]: numStatParser,
      [
        "--name-status"
        /* NAME_STATUS */
      ]: nameStatusParser,
      [
        "--name-only"
        /* NAME_ONLY */
      ]: nameOnlyParser
    };
  }
});
function lineBuilder(tokens, fields) {
  return fields.reduce((line, field, index) => {
    line[field] = tokens[index] || "";
    return line;
  }, /* @__PURE__ */ Object.create({ diff: null }));
}
function createListLogSummaryParser(splitter = SPLITTER, fields = defaultFieldNames, logFormat = "") {
  const parseDiffResult = getDiffParser(logFormat);
  return function(stdOut) {
    const all = toLinesWithContent(stdOut, true, START_BOUNDARY).map(function(item) {
      const lineDetail = item.trim().split(COMMIT_BOUNDARY);
      const listLogLine = lineBuilder(lineDetail[0].trim().split(splitter), fields);
      if (lineDetail.length > 1 && !!lineDetail[1].trim()) {
        listLogLine.diff = parseDiffResult(lineDetail[1]);
      }
      return listLogLine;
    });
    return {
      all,
      latest: all.length && all[0] || null,
      total: all.length
    };
  };
}
var START_BOUNDARY;
var COMMIT_BOUNDARY;
var SPLITTER;
var defaultFieldNames;
var init_parse_list_log_summary = __esm({
  "src/lib/parsers/parse-list-log-summary.ts"() {
    init_utils();
    init_parse_diff_summary();
    init_log_format();
    START_BOUNDARY = "\xF2\xF2\xF2\xF2\xF2\xF2 ";
    COMMIT_BOUNDARY = " \xF2\xF2";
    SPLITTER = " \xF2 ";
    defaultFieldNames = ["hash", "date", "message", "refs", "author_name", "author_email"];
  }
});
var diff_exports = {};
__export2(diff_exports, {
  diffSummaryTask: () => diffSummaryTask,
  validateLogFormatConfig: () => validateLogFormatConfig
});
function diffSummaryTask(customArgs) {
  let logFormat = logFormatFromCommand(customArgs);
  const commands = ["diff"];
  if (logFormat === "") {
    logFormat = "--stat";
    commands.push("--stat=4096");
  }
  commands.push(...customArgs);
  return validateLogFormatConfig(commands) || {
    commands,
    format: "utf-8",
    parser: getDiffParser(logFormat)
  };
}
function validateLogFormatConfig(customArgs) {
  const flags = customArgs.filter(isLogFormat);
  if (flags.length > 1) {
    return configurationErrorTask(`Summary flags are mutually exclusive - pick one of ${flags.join(",")}`);
  }
  if (flags.length && customArgs.includes("-z")) {
    return configurationErrorTask(`Summary flag ${flags} parsing is not compatible with null termination option '-z'`);
  }
}
var init_diff = __esm({
  "src/lib/tasks/diff.ts"() {
    init_log_format();
    init_parse_diff_summary();
    init_task();
  }
});
function prettyFormat(format, splitter) {
  const fields = [];
  const formatStr = [];
  Object.keys(format).forEach((field) => {
    fields.push(field);
    formatStr.push(String(format[field]));
  });
  return [fields, formatStr.join(splitter)];
}
function userOptions(input) {
  return Object.keys(input).reduce((out, key) => {
    if (!(key in excludeOptions)) {
      out[key] = input[key];
    }
    return out;
  }, {});
}
function parseLogOptions(opt = {}, customArgs = []) {
  const splitter = filterType(opt.splitter, filterString, SPLITTER);
  const format = !filterPrimitives(opt.format) && opt.format ? opt.format : {
    hash: "%H",
    date: opt.strictDate === false ? "%ai" : "%aI",
    message: "%s",
    refs: "%D",
    body: opt.multiLine ? "%B" : "%b",
    author_name: opt.mailMap !== false ? "%aN" : "%an",
    author_email: opt.mailMap !== false ? "%aE" : "%ae"
  };
  const [fields, formatStr] = prettyFormat(format, splitter);
  const suffix = [];
  const command = [
    `--pretty=format:${START_BOUNDARY}${formatStr}${COMMIT_BOUNDARY}`,
    ...customArgs
  ];
  const maxCount = opt.n || opt["max-count"] || opt.maxCount;
  if (maxCount) {
    command.push(`--max-count=${maxCount}`);
  }
  if (opt.from || opt.to) {
    const rangeOperator = opt.symmetric !== false ? "..." : "..";
    suffix.push(`${opt.from || ""}${rangeOperator}${opt.to || ""}`);
  }
  if (filterString(opt.file)) {
    command.push("--follow", pathspec(opt.file));
  }
  appendTaskOptions(userOptions(opt), command);
  return {
    fields,
    splitter,
    commands: [...command, ...suffix]
  };
}
function logTask(splitter, fields, customArgs) {
  const parser3 = createListLogSummaryParser(splitter, fields, logFormatFromCommand(customArgs));
  return {
    commands: ["log", ...customArgs],
    format: "utf-8",
    parser: parser3
  };
}
function log_default() {
  return {
    log(...rest) {
      const next = trailingFunctionArgument(arguments);
      const options = parseLogOptions(trailingOptionsArgument(arguments), filterType(arguments[0], filterArray));
      const task = rejectDeprecatedSignatures(...rest) || validateLogFormatConfig(options.commands) || createLogTask(options);
      return this._runTask(task, next);
    }
  };
  function createLogTask(options) {
    return logTask(options.splitter, options.fields, options.commands);
  }
  function rejectDeprecatedSignatures(from, to) {
    return filterString(from) && filterString(to) && configurationErrorTask(`git.log(string, string) should be replaced with git.log({ from: string, to: string })`);
  }
}
var excludeOptions;
var init_log = __esm({
  "src/lib/tasks/log.ts"() {
    init_log_format();
    init_pathspec();
    init_parse_list_log_summary();
    init_utils();
    init_task();
    init_diff();
    excludeOptions = /* @__PURE__ */ ((excludeOptions2) => {
      excludeOptions2[excludeOptions2["--pretty"] = 0] = "--pretty";
      excludeOptions2[excludeOptions2["max-count"] = 1] = "max-count";
      excludeOptions2[excludeOptions2["maxCount"] = 2] = "maxCount";
      excludeOptions2[excludeOptions2["n"] = 3] = "n";
      excludeOptions2[excludeOptions2["file"] = 4] = "file";
      excludeOptions2[excludeOptions2["format"] = 5] = "format";
      excludeOptions2[excludeOptions2["from"] = 6] = "from";
      excludeOptions2[excludeOptions2["to"] = 7] = "to";
      excludeOptions2[excludeOptions2["splitter"] = 8] = "splitter";
      excludeOptions2[excludeOptions2["symmetric"] = 9] = "symmetric";
      excludeOptions2[excludeOptions2["mailMap"] = 10] = "mailMap";
      excludeOptions2[excludeOptions2["multiLine"] = 11] = "multiLine";
      excludeOptions2[excludeOptions2["strictDate"] = 12] = "strictDate";
      return excludeOptions2;
    })(excludeOptions || {});
  }
});
var MergeSummaryConflict;
var MergeSummaryDetail;
var init_MergeSummary = __esm({
  "src/lib/responses/MergeSummary.ts"() {
    MergeSummaryConflict = class {
      constructor(reason, file = null, meta) {
        this.reason = reason;
        this.file = file;
        this.meta = meta;
      }
      toString() {
        return `${this.file}:${this.reason}`;
      }
    };
    MergeSummaryDetail = class {
      constructor() {
        this.conflicts = [];
        this.merges = [];
        this.result = "success";
      }
      get failed() {
        return this.conflicts.length > 0;
      }
      get reason() {
        return this.result;
      }
      toString() {
        if (this.conflicts.length) {
          return `CONFLICTS: ${this.conflicts.join(", ")}`;
        }
        return "OK";
      }
    };
  }
});
var PullSummary;
var PullFailedSummary;
var init_PullSummary = __esm({
  "src/lib/responses/PullSummary.ts"() {
    PullSummary = class {
      constructor() {
        this.remoteMessages = {
          all: []
        };
        this.created = [];
        this.deleted = [];
        this.files = [];
        this.deletions = {};
        this.insertions = {};
        this.summary = {
          changes: 0,
          deletions: 0,
          insertions: 0
        };
      }
    };
    PullFailedSummary = class {
      constructor() {
        this.remote = "";
        this.hash = {
          local: "",
          remote: ""
        };
        this.branch = {
          local: "",
          remote: ""
        };
        this.message = "";
      }
      toString() {
        return this.message;
      }
    };
  }
});
function objectEnumerationResult(remoteMessages) {
  return remoteMessages.objects = remoteMessages.objects || {
    compressing: 0,
    counting: 0,
    enumerating: 0,
    packReused: 0,
    reused: { count: 0, delta: 0 },
    total: { count: 0, delta: 0 }
  };
}
function asObjectCount(source) {
  const count = /^\s*(\d+)/.exec(source);
  const delta = /delta (\d+)/i.exec(source);
  return {
    count: asNumber(count && count[1] || "0"),
    delta: asNumber(delta && delta[1] || "0")
  };
}
var remoteMessagesObjectParsers;
var init_parse_remote_objects = __esm({
  "src/lib/parsers/parse-remote-objects.ts"() {
    init_utils();
    remoteMessagesObjectParsers = [
      new RemoteLineParser(/^remote:\s*(enumerating|counting|compressing) objects: (\d+),/i, (result, [action, count]) => {
        const key = action.toLowerCase();
        const enumeration = objectEnumerationResult(result.remoteMessages);
        Object.assign(enumeration, { [key]: asNumber(count) });
      }),
      new RemoteLineParser(/^remote:\s*(enumerating|counting|compressing) objects: \d+% \(\d+\/(\d+)\),/i, (result, [action, count]) => {
        const key = action.toLowerCase();
        const enumeration = objectEnumerationResult(result.remoteMessages);
        Object.assign(enumeration, { [key]: asNumber(count) });
      }),
      new RemoteLineParser(/total ([^,]+), reused ([^,]+), pack-reused (\d+)/i, (result, [total, reused, packReused]) => {
        const objects = objectEnumerationResult(result.remoteMessages);
        objects.total = asObjectCount(total);
        objects.reused = asObjectCount(reused);
        objects.packReused = asNumber(packReused);
      })
    ];
  }
});
function parseRemoteMessages(_stdOut, stdErr) {
  return parseStringResponse({ remoteMessages: new RemoteMessageSummary() }, parsers2, stdErr);
}
var parsers2;
var RemoteMessageSummary;
var init_parse_remote_messages = __esm({
  "src/lib/parsers/parse-remote-messages.ts"() {
    init_utils();
    init_parse_remote_objects();
    parsers2 = [
      new RemoteLineParser(/^remote:\s*(.+)$/, (result, [text]) => {
        result.remoteMessages.all.push(text.trim());
        return false;
      }),
      ...remoteMessagesObjectParsers,
      new RemoteLineParser([/create a (?:pull|merge) request/i, /\s(https?:\/\/\S+)$/], (result, [pullRequestUrl]) => {
        result.remoteMessages.pullRequestUrl = pullRequestUrl;
      }),
      new RemoteLineParser([/found (\d+) vulnerabilities.+\(([^)]+)\)/i, /\s(https?:\/\/\S+)$/], (result, [count, summary, url]) => {
        result.remoteMessages.vulnerabilities = {
          count: asNumber(count),
          summary,
          url
        };
      })
    ];
    RemoteMessageSummary = class {
      constructor() {
        this.all = [];
      }
    };
  }
});
function parsePullErrorResult(stdOut, stdErr) {
  const pullError = parseStringResponse(new PullFailedSummary(), errorParsers, [stdOut, stdErr]);
  return pullError.message && pullError;
}
var FILE_UPDATE_REGEX;
var SUMMARY_REGEX;
var ACTION_REGEX;
var parsers3;
var errorParsers;
var parsePullDetail;
var parsePullResult;
var init_parse_pull = __esm({
  "src/lib/parsers/parse-pull.ts"() {
    init_PullSummary();
    init_utils();
    init_parse_remote_messages();
    FILE_UPDATE_REGEX = /^\s*(.+?)\s+\|\s+\d+\s*(\+*)(-*)/;
    SUMMARY_REGEX = /(\d+)\D+((\d+)\D+\(\+\))?(\D+(\d+)\D+\(-\))?/;
    ACTION_REGEX = /^(create|delete) mode \d+ (.+)/;
    parsers3 = [
      new LineParser(FILE_UPDATE_REGEX, (result, [file, insertions, deletions]) => {
        result.files.push(file);
        if (insertions) {
          result.insertions[file] = insertions.length;
        }
        if (deletions) {
          result.deletions[file] = deletions.length;
        }
      }),
      new LineParser(SUMMARY_REGEX, (result, [changes, , insertions, , deletions]) => {
        if (insertions !== void 0 || deletions !== void 0) {
          result.summary.changes = +changes || 0;
          result.summary.insertions = +insertions || 0;
          result.summary.deletions = +deletions || 0;
          return true;
        }
        return false;
      }),
      new LineParser(ACTION_REGEX, (result, [action, file]) => {
        append(result.files, file);
        append(action === "create" ? result.created : result.deleted, file);
      })
    ];
    errorParsers = [
      new LineParser(/^from\s(.+)$/i, (result, [remote]) => void (result.remote = remote)),
      new LineParser(/^fatal:\s(.+)$/, (result, [message]) => void (result.message = message)),
      new LineParser(/([a-z0-9]+)\.\.([a-z0-9]+)\s+(\S+)\s+->\s+(\S+)$/, (result, [hashLocal, hashRemote, branchLocal, branchRemote]) => {
        result.branch.local = branchLocal;
        result.hash.local = hashLocal;
        result.branch.remote = branchRemote;
        result.hash.remote = hashRemote;
      })
    ];
    parsePullDetail = (stdOut, stdErr) => {
      return parseStringResponse(new PullSummary(), parsers3, [stdOut, stdErr]);
    };
    parsePullResult = (stdOut, stdErr) => {
      return Object.assign(new PullSummary(), parsePullDetail(stdOut, stdErr), parseRemoteMessages(stdOut, stdErr));
    };
  }
});
var parsers4;
var parseMergeResult;
var parseMergeDetail;
var init_parse_merge = __esm({
  "src/lib/parsers/parse-merge.ts"() {
    init_MergeSummary();
    init_utils();
    init_parse_pull();
    parsers4 = [
      new LineParser(/^Auto-merging\s+(.+)$/, (summary, [autoMerge]) => {
        summary.merges.push(autoMerge);
      }),
      new LineParser(/^CONFLICT\s+\((.+)\): Merge conflict in (.+)$/, (summary, [reason, file]) => {
        summary.conflicts.push(new MergeSummaryConflict(reason, file));
      }),
      new LineParser(/^CONFLICT\s+\((.+\/delete)\): (.+) deleted in (.+) and/, (summary, [reason, file, deleteRef]) => {
        summary.conflicts.push(new MergeSummaryConflict(reason, file, { deleteRef }));
      }),
      new LineParser(/^CONFLICT\s+\((.+)\):/, (summary, [reason]) => {
        summary.conflicts.push(new MergeSummaryConflict(reason, null));
      }),
      new LineParser(/^Automatic merge failed;\s+(.+)$/, (summary, [result]) => {
        summary.result = result;
      })
    ];
    parseMergeResult = (stdOut, stdErr) => {
      return Object.assign(parseMergeDetail(stdOut, stdErr), parsePullResult(stdOut, stdErr));
    };
    parseMergeDetail = (stdOut) => {
      return parseStringResponse(new MergeSummaryDetail(), parsers4, stdOut);
    };
  }
});
function mergeTask(customArgs) {
  if (!customArgs.length) {
    return configurationErrorTask("Git.merge requires at least one option");
  }
  return {
    commands: ["merge", ...customArgs],
    format: "utf-8",
    parser(stdOut, stdErr) {
      const merge = parseMergeResult(stdOut, stdErr);
      if (merge.failed) {
        throw new GitResponseError(merge);
      }
      return merge;
    }
  };
}
var init_merge = __esm({
  "src/lib/tasks/merge.ts"() {
    init_git_response_error();
    init_parse_merge();
    init_task();
  }
});
function pushResultPushedItem(local, remote, status) {
  const deleted = status.includes("deleted");
  const tag = status.includes("tag") || /^refs\/tags/.test(local);
  const alreadyUpdated = !status.includes("new");
  return {
    deleted,
    tag,
    branch: !tag,
    new: !alreadyUpdated,
    alreadyUpdated,
    local,
    remote
  };
}
var parsers5;
var parsePushResult;
var parsePushDetail;
var init_parse_push = __esm({
  "src/lib/parsers/parse-push.ts"() {
    init_utils();
    init_parse_remote_messages();
    parsers5 = [
      new LineParser(/^Pushing to (.+)$/, (result, [repo]) => {
        result.repo = repo;
      }),
      new LineParser(/^updating local tracking ref '(.+)'/, (result, [local]) => {
        result.ref = __spreadProps(__spreadValues({}, result.ref || {}), {
          local
        });
      }),
      new LineParser(/^[=*-]\s+([^:]+):(\S+)\s+\[(.+)]$/, (result, [local, remote, type]) => {
        result.pushed.push(pushResultPushedItem(local, remote, type));
      }),
      new LineParser(/^Branch '([^']+)' set up to track remote branch '([^']+)' from '([^']+)'/, (result, [local, remote, remoteName]) => {
        result.branch = __spreadProps(__spreadValues({}, result.branch || {}), {
          local,
          remote,
          remoteName
        });
      }),
      new LineParser(/^([^:]+):(\S+)\s+([a-z0-9]+)\.\.([a-z0-9]+)$/, (result, [local, remote, from, to]) => {
        result.update = {
          head: {
            local,
            remote
          },
          hash: {
            from,
            to
          }
        };
      })
    ];
    parsePushResult = (stdOut, stdErr) => {
      const pushDetail = parsePushDetail(stdOut, stdErr);
      const responseDetail = parseRemoteMessages(stdOut, stdErr);
      return __spreadValues(__spreadValues({}, pushDetail), responseDetail);
    };
    parsePushDetail = (stdOut, stdErr) => {
      return parseStringResponse({ pushed: [] }, parsers5, [stdOut, stdErr]);
    };
  }
});
var push_exports = {};
__export2(push_exports, {
  pushTagsTask: () => pushTagsTask,
  pushTask: () => pushTask
});
function pushTagsTask(ref = {}, customArgs) {
  append(customArgs, "--tags");
  return pushTask(ref, customArgs);
}
function pushTask(ref = {}, customArgs) {
  const commands = ["push", ...customArgs];
  if (ref.branch) {
    commands.splice(1, 0, ref.branch);
  }
  if (ref.remote) {
    commands.splice(1, 0, ref.remote);
  }
  remove(commands, "-v");
  append(commands, "--verbose");
  append(commands, "--porcelain");
  return {
    commands,
    format: "utf-8",
    parser: parsePushResult
  };
}
var init_push = __esm({
  "src/lib/tasks/push.ts"() {
    init_parse_push();
    init_utils();
  }
});
function show_default() {
  return {
    showBuffer() {
      const commands = ["show", ...getTrailingOptions(arguments, 1)];
      if (!commands.includes("--binary")) {
        commands.splice(1, 0, "--binary");
      }
      return this._runTask(straightThroughBufferTask(commands), trailingFunctionArgument(arguments));
    },
    show() {
      const commands = ["show", ...getTrailingOptions(arguments, 1)];
      return this._runTask(straightThroughStringTask(commands), trailingFunctionArgument(arguments));
    }
  };
}
var init_show = __esm({
  "src/lib/tasks/show.ts"() {
    init_utils();
    init_task();
  }
});
var fromPathRegex;
var FileStatusSummary;
var init_FileStatusSummary = __esm({
  "src/lib/responses/FileStatusSummary.ts"() {
    fromPathRegex = /^(.+) -> (.+)$/;
    FileStatusSummary = class {
      constructor(path, index, working_dir) {
        this.path = path;
        this.index = index;
        this.working_dir = working_dir;
        if (index + working_dir === "R") {
          const detail = fromPathRegex.exec(path) || [null, path, path];
          this.from = detail[1] || "";
          this.path = detail[2] || "";
        }
      }
    };
  }
});
function renamedFile(line) {
  const [to, from] = line.split(NULL);
  return {
    from: from || to,
    to
  };
}
function parser2(indexX, indexY, handler) {
  return [`${indexX}${indexY}`, handler];
}
function conflicts(indexX, ...indexY) {
  return indexY.map((y) => parser2(indexX, y, (result, file) => append(result.conflicted, file)));
}
function splitLine(result, lineStr) {
  const trimmed2 = lineStr.trim();
  switch (" ") {
    case trimmed2.charAt(2):
      return data(trimmed2.charAt(0), trimmed2.charAt(1), trimmed2.substr(3));
    case trimmed2.charAt(1):
      return data(" ", trimmed2.charAt(0), trimmed2.substr(2));
    default:
      return;
  }
  function data(index, workingDir, path) {
    const raw = `${index}${workingDir}`;
    const handler = parsers6.get(raw);
    if (handler) {
      handler(result, path);
    }
    if (raw !== "##" && raw !== "!!") {
      result.files.push(new FileStatusSummary(path.replace(/\0.+$/, ""), index, workingDir));
    }
  }
}
var StatusSummary;
var parsers6;
var parseStatusSummary;
var init_StatusSummary = __esm({
  "src/lib/responses/StatusSummary.ts"() {
    init_utils();
    init_FileStatusSummary();
    StatusSummary = class {
      constructor() {
        this.not_added = [];
        this.conflicted = [];
        this.created = [];
        this.deleted = [];
        this.ignored = void 0;
        this.modified = [];
        this.renamed = [];
        this.files = [];
        this.staged = [];
        this.ahead = 0;
        this.behind = 0;
        this.current = null;
        this.tracking = null;
        this.detached = false;
        this.isClean = () => {
          return !this.files.length;
        };
      }
    };
    parsers6 = new Map([
      parser2(" ", "A", (result, file) => append(result.created, file)),
      parser2(" ", "D", (result, file) => append(result.deleted, file)),
      parser2(" ", "M", (result, file) => append(result.modified, file)),
      parser2("A", " ", (result, file) => append(result.created, file) && append(result.staged, file)),
      parser2("A", "M", (result, file) => append(result.created, file) && append(result.staged, file) && append(result.modified, file)),
      parser2("D", " ", (result, file) => append(result.deleted, file) && append(result.staged, file)),
      parser2("M", " ", (result, file) => append(result.modified, file) && append(result.staged, file)),
      parser2("M", "M", (result, file) => append(result.modified, file) && append(result.staged, file)),
      parser2("R", " ", (result, file) => {
        append(result.renamed, renamedFile(file));
      }),
      parser2("R", "M", (result, file) => {
        const renamed = renamedFile(file);
        append(result.renamed, renamed);
        append(result.modified, renamed.to);
      }),
      parser2("!", "!", (_result, _file) => {
        append(_result.ignored = _result.ignored || [], _file);
      }),
      parser2("?", "?", (result, file) => append(result.not_added, file)),
      ...conflicts(
        "A",
        "A",
        "U"
        /* UNMERGED */
      ),
      ...conflicts(
        "D",
        "D",
        "U"
        /* UNMERGED */
      ),
      ...conflicts(
        "U",
        "A",
        "D",
        "U"
        /* UNMERGED */
      ),
      [
        "##",
        (result, line) => {
          const aheadReg = /ahead (\d+)/;
          const behindReg = /behind (\d+)/;
          const currentReg = /^(.+?(?=(?:\.{3}|\s|$)))/;
          const trackingReg = /\.{3}(\S*)/;
          const onEmptyBranchReg = /\son\s([\S]+)$/;
          let regexResult;
          regexResult = aheadReg.exec(line);
          result.ahead = regexResult && +regexResult[1] || 0;
          regexResult = behindReg.exec(line);
          result.behind = regexResult && +regexResult[1] || 0;
          regexResult = currentReg.exec(line);
          result.current = regexResult && regexResult[1];
          regexResult = trackingReg.exec(line);
          result.tracking = regexResult && regexResult[1];
          regexResult = onEmptyBranchReg.exec(line);
          result.current = regexResult && regexResult[1] || result.current;
          result.detached = /\(no branch\)/.test(line);
        }
      ]
    ]);
    parseStatusSummary = function(text) {
      const lines = text.split(NULL);
      const status = new StatusSummary();
      for (let i = 0, l = lines.length; i < l; ) {
        let line = lines[i++].trim();
        if (!line) {
          continue;
        }
        if (line.charAt(0) === "R") {
          line += NULL + (lines[i++] || "");
        }
        splitLine(status, line);
      }
      return status;
    };
  }
});
function statusTask(customArgs) {
  const commands = [
    "status",
    "--porcelain",
    "-b",
    "-u",
    "--null",
    ...customArgs.filter((arg) => !ignoredOptions.includes(arg))
  ];
  return {
    format: "utf-8",
    commands,
    parser(text) {
      return parseStatusSummary(text);
    }
  };
}
var ignoredOptions;
var init_status = __esm({
  "src/lib/tasks/status.ts"() {
    init_StatusSummary();
    ignoredOptions = ["--null", "-z"];
  }
});
function versionResponse(major = 0, minor = 0, patch = 0, agent = "", installed = true) {
  return Object.defineProperty({
    major,
    minor,
    patch,
    agent,
    installed
  }, "toString", {
    value() {
      return `${this.major}.${this.minor}.${this.patch}`;
    },
    configurable: false,
    enumerable: false
  });
}
function notInstalledResponse() {
  return versionResponse(0, 0, 0, "", false);
}
function version_default() {
  return {
    version() {
      return this._runTask({
        commands: ["--version"],
        format: "utf-8",
        parser: versionParser,
        onError(result, error, done, fail) {
          if (result.exitCode === -2) {
            return done(Buffer.from(NOT_INSTALLED));
          }
          fail(error);
        }
      });
    }
  };
}
function versionParser(stdOut) {
  if (stdOut === NOT_INSTALLED) {
    return notInstalledResponse();
  }
  return parseStringResponse(versionResponse(0, 0, 0, stdOut), parsers7, stdOut);
}
var NOT_INSTALLED;
var parsers7;
var init_version = __esm({
  "src/lib/tasks/version.ts"() {
    init_utils();
    NOT_INSTALLED = "installed=false";
    parsers7 = [
      new LineParser(/version (\d+)\.(\d+)\.(\d+)(?:\s*\((.+)\))?/, (result, [major, minor, patch, agent = ""]) => {
        Object.assign(result, versionResponse(asNumber(major), asNumber(minor), asNumber(patch), agent));
      }),
      new LineParser(/version (\d+)\.(\d+)\.(\D+)(.+)?$/, (result, [major, minor, patch, agent = ""]) => {
        Object.assign(result, versionResponse(asNumber(major), asNumber(minor), patch, agent));
      })
    ];
  }
});
var simple_git_api_exports = {};
__export2(simple_git_api_exports, {
  SimpleGitApi: () => SimpleGitApi
});
var SimpleGitApi;
var init_simple_git_api = __esm({
  "src/lib/simple-git-api.ts"() {
    init_task_callback();
    init_change_working_directory();
    init_checkout();
    init_commit();
    init_config();
    init_first_commit();
    init_grep();
    init_hash_object();
    init_init();
    init_log();
    init_merge();
    init_push();
    init_show();
    init_status();
    init_task();
    init_version();
    init_utils();
    SimpleGitApi = class {
      constructor(_executor) {
        this._executor = _executor;
      }
      _runTask(task, then) {
        const chain = this._executor.chain();
        const promise = chain.push(task);
        if (then) {
          taskCallback(task, promise, then);
        }
        return Object.create(this, {
          then: { value: promise.then.bind(promise) },
          catch: { value: promise.catch.bind(promise) },
          _executor: { value: chain }
        });
      }
      add(files) {
        return this._runTask(straightThroughStringTask(["add", ...asArray(files)]), trailingFunctionArgument(arguments));
      }
      cwd(directory) {
        const next = trailingFunctionArgument(arguments);
        if (typeof directory === "string") {
          return this._runTask(changeWorkingDirectoryTask(directory, this._executor), next);
        }
        if (typeof (directory == null ? void 0 : directory.path) === "string") {
          return this._runTask(changeWorkingDirectoryTask(directory.path, directory.root && this._executor || void 0), next);
        }
        return this._runTask(configurationErrorTask("Git.cwd: workingDirectory must be supplied as a string"), next);
      }
      hashObject(path, write) {
        return this._runTask(hashObjectTask(path, write === true), trailingFunctionArgument(arguments));
      }
      init(bare) {
        return this._runTask(initTask(bare === true, this._executor.cwd, getTrailingOptions(arguments)), trailingFunctionArgument(arguments));
      }
      merge() {
        return this._runTask(mergeTask(getTrailingOptions(arguments)), trailingFunctionArgument(arguments));
      }
      mergeFromTo(remote, branch) {
        if (!(filterString(remote) && filterString(branch))) {
          return this._runTask(configurationErrorTask(`Git.mergeFromTo requires that the 'remote' and 'branch' arguments are supplied as strings`));
        }
        return this._runTask(mergeTask([remote, branch, ...getTrailingOptions(arguments)]), trailingFunctionArgument(arguments, false));
      }
      outputHandler(handler) {
        this._executor.outputHandler = handler;
        return this;
      }
      push() {
        const task = pushTask({
          remote: filterType(arguments[0], filterString),
          branch: filterType(arguments[1], filterString)
        }, getTrailingOptions(arguments));
        return this._runTask(task, trailingFunctionArgument(arguments));
      }
      stash() {
        return this._runTask(straightThroughStringTask(["stash", ...getTrailingOptions(arguments)]), trailingFunctionArgument(arguments));
      }
      status() {
        return this._runTask(statusTask(getTrailingOptions(arguments)), trailingFunctionArgument(arguments));
      }
    };
    Object.assign(SimpleGitApi.prototype, checkout_default(), commit_default(), config_default(), first_commit_default(), grep_default(), log_default(), show_default(), version_default());
  }
});
var scheduler_exports = {};
__export2(scheduler_exports, {
  Scheduler: () => Scheduler
});
var createScheduledTask;
var Scheduler;
var init_scheduler = __esm({
  "src/lib/runners/scheduler.ts"() {
    init_utils();
    init_git_logger();
    createScheduledTask = (() => {
      let id = 0;
      return () => {
        id++;
        const { promise, done } = (0, import_promise_deferred.createDeferred)();
        return {
          promise,
          done,
          id
        };
      };
    })();
    Scheduler = class {
      constructor(concurrency = 2) {
        this.concurrency = concurrency;
        this.logger = createLogger("", "scheduler");
        this.pending = [];
        this.running = [];
        this.logger(`Constructed, concurrency=%s`, concurrency);
      }
      schedule() {
        if (!this.pending.length || this.running.length >= this.concurrency) {
          this.logger(`Schedule attempt ignored, pending=%s running=%s concurrency=%s`, this.pending.length, this.running.length, this.concurrency);
          return;
        }
        const task = append(this.running, this.pending.shift());
        this.logger(`Attempting id=%s`, task.id);
        task.done(() => {
          this.logger(`Completing id=`, task.id);
          remove(this.running, task);
          this.schedule();
        });
      }
      next() {
        const { promise, id } = append(this.pending, createScheduledTask());
        this.logger(`Scheduling id=%s`, id);
        this.schedule();
        return promise;
      }
    };
  }
});
var apply_patch_exports = {};
__export2(apply_patch_exports, {
  applyPatchTask: () => applyPatchTask
});
function applyPatchTask(patches, customArgs) {
  return straightThroughStringTask(["apply", ...customArgs, ...patches]);
}
var init_apply_patch = __esm({
  "src/lib/tasks/apply-patch.ts"() {
    init_task();
  }
});
function branchDeletionSuccess(branch, hash) {
  return {
    branch,
    hash,
    success: true
  };
}
function branchDeletionFailure(branch) {
  return {
    branch,
    hash: null,
    success: false
  };
}
var BranchDeletionBatch;
var init_BranchDeleteSummary = __esm({
  "src/lib/responses/BranchDeleteSummary.ts"() {
    BranchDeletionBatch = class {
      constructor() {
        this.all = [];
        this.branches = {};
        this.errors = [];
      }
      get success() {
        return !this.errors.length;
      }
    };
  }
});
function hasBranchDeletionError(data, processExitCode) {
  return processExitCode === 1 && deleteErrorRegex.test(data);
}
var deleteSuccessRegex;
var deleteErrorRegex;
var parsers8;
var parseBranchDeletions;
var init_parse_branch_delete = __esm({
  "src/lib/parsers/parse-branch-delete.ts"() {
    init_BranchDeleteSummary();
    init_utils();
    deleteSuccessRegex = /(\S+)\s+\(\S+\s([^)]+)\)/;
    deleteErrorRegex = /^error[^']+'([^']+)'/m;
    parsers8 = [
      new LineParser(deleteSuccessRegex, (result, [branch, hash]) => {
        const deletion = branchDeletionSuccess(branch, hash);
        result.all.push(deletion);
        result.branches[branch] = deletion;
      }),
      new LineParser(deleteErrorRegex, (result, [branch]) => {
        const deletion = branchDeletionFailure(branch);
        result.errors.push(deletion);
        result.all.push(deletion);
        result.branches[branch] = deletion;
      })
    ];
    parseBranchDeletions = (stdOut, stdErr) => {
      return parseStringResponse(new BranchDeletionBatch(), parsers8, [stdOut, stdErr]);
    };
  }
});
var BranchSummaryResult;
var init_BranchSummary = __esm({
  "src/lib/responses/BranchSummary.ts"() {
    BranchSummaryResult = class {
      constructor() {
        this.all = [];
        this.branches = {};
        this.current = "";
        this.detached = false;
      }
      push(status, detached, name, commit, label) {
        if (status === "*") {
          this.detached = detached;
          this.current = name;
        }
        this.all.push(name);
        this.branches[name] = {
          current: status === "*",
          linkedWorkTree: status === "+",
          name,
          commit,
          label
        };
      }
    };
  }
});
function branchStatus(input) {
  return input ? input.charAt(0) : "";
}
function parseBranchSummary(stdOut) {
  return parseStringResponse(new BranchSummaryResult(), parsers9, stdOut);
}
var parsers9;
var init_parse_branch = __esm({
  "src/lib/parsers/parse-branch.ts"() {
    init_BranchSummary();
    init_utils();
    parsers9 = [
      new LineParser(/^([*+]\s)?\((?:HEAD )?detached (?:from|at) (\S+)\)\s+([a-z0-9]+)\s(.*)$/, (result, [current, name, commit, label]) => {
        result.push(branchStatus(current), true, name, commit, label);
      }),
      new LineParser(/^([*+]\s)?(\S+)\s+([a-z0-9]+)\s?(.*)$/s, (result, [current, name, commit, label]) => {
        result.push(branchStatus(current), false, name, commit, label);
      })
    ];
  }
});
var branch_exports = {};
__export2(branch_exports, {
  branchLocalTask: () => branchLocalTask,
  branchTask: () => branchTask,
  containsDeleteBranchCommand: () => containsDeleteBranchCommand,
  deleteBranchTask: () => deleteBranchTask,
  deleteBranchesTask: () => deleteBranchesTask
});
function containsDeleteBranchCommand(commands) {
  const deleteCommands = ["-d", "-D", "--delete"];
  return commands.some((command) => deleteCommands.includes(command));
}
function branchTask(customArgs) {
  const isDelete = containsDeleteBranchCommand(customArgs);
  const commands = ["branch", ...customArgs];
  if (commands.length === 1) {
    commands.push("-a");
  }
  if (!commands.includes("-v")) {
    commands.splice(1, 0, "-v");
  }
  return {
    format: "utf-8",
    commands,
    parser(stdOut, stdErr) {
      if (isDelete) {
        return parseBranchDeletions(stdOut, stdErr).all[0];
      }
      return parseBranchSummary(stdOut);
    }
  };
}
function branchLocalTask() {
  const parser3 = parseBranchSummary;
  return {
    format: "utf-8",
    commands: ["branch", "-v"],
    parser: parser3
  };
}
function deleteBranchesTask(branches, forceDelete = false) {
  return {
    format: "utf-8",
    commands: ["branch", "-v", forceDelete ? "-D" : "-d", ...branches],
    parser(stdOut, stdErr) {
      return parseBranchDeletions(stdOut, stdErr);
    },
    onError({ exitCode, stdOut }, error, done, fail) {
      if (!hasBranchDeletionError(String(error), exitCode)) {
        return fail(error);
      }
      done(stdOut);
    }
  };
}
function deleteBranchTask(branch, forceDelete = false) {
  const task = {
    format: "utf-8",
    commands: ["branch", "-v", forceDelete ? "-D" : "-d", branch],
    parser(stdOut, stdErr) {
      return parseBranchDeletions(stdOut, stdErr).branches[branch];
    },
    onError({ exitCode, stdErr, stdOut }, error, _, fail) {
      if (!hasBranchDeletionError(String(error), exitCode)) {
        return fail(error);
      }
      throw new GitResponseError(task.parser(bufferToString(stdOut), bufferToString(stdErr)), String(error));
    }
  };
  return task;
}
var init_branch = __esm({
  "src/lib/tasks/branch.ts"() {
    init_git_response_error();
    init_parse_branch_delete();
    init_parse_branch();
    init_utils();
  }
});
var parseCheckIgnore;
var init_CheckIgnore = __esm({
  "src/lib/responses/CheckIgnore.ts"() {
    parseCheckIgnore = (text) => {
      return text.split(/\n/g).map((line) => line.trim()).filter((file) => !!file);
    };
  }
});
var check_ignore_exports = {};
__export2(check_ignore_exports, {
  checkIgnoreTask: () => checkIgnoreTask
});
function checkIgnoreTask(paths) {
  return {
    commands: ["check-ignore", ...paths],
    format: "utf-8",
    parser: parseCheckIgnore
  };
}
var init_check_ignore = __esm({
  "src/lib/tasks/check-ignore.ts"() {
    init_CheckIgnore();
  }
});
var clone_exports = {};
__export2(clone_exports, {
  cloneMirrorTask: () => cloneMirrorTask,
  cloneTask: () => cloneTask
});
function disallowedCommand(command) {
  return /^--upload-pack(=|$)/.test(command);
}
function cloneTask(repo, directory, customArgs) {
  const commands = ["clone", ...customArgs];
  filterString(repo) && commands.push(repo);
  filterString(directory) && commands.push(directory);
  const banned = commands.find(disallowedCommand);
  if (banned) {
    return configurationErrorTask(`git.fetch: potential exploit argument blocked.`);
  }
  return straightThroughStringTask(commands);
}
function cloneMirrorTask(repo, directory, customArgs) {
  append(customArgs, "--mirror");
  return cloneTask(repo, directory, customArgs);
}
var init_clone = __esm({
  "src/lib/tasks/clone.ts"() {
    init_task();
    init_utils();
  }
});
function parseFetchResult(stdOut, stdErr) {
  const result = {
    raw: stdOut,
    remote: null,
    branches: [],
    tags: [],
    updated: [],
    deleted: []
  };
  return parseStringResponse(result, parsers10, [stdOut, stdErr]);
}
var parsers10;
var init_parse_fetch = __esm({
  "src/lib/parsers/parse-fetch.ts"() {
    init_utils();
    parsers10 = [
      new LineParser(/From (.+)$/, (result, [remote]) => {
        result.remote = remote;
      }),
      new LineParser(/\* \[new branch]\s+(\S+)\s*-> (.+)$/, (result, [name, tracking]) => {
        result.branches.push({
          name,
          tracking
        });
      }),
      new LineParser(/\* \[new tag]\s+(\S+)\s*-> (.+)$/, (result, [name, tracking]) => {
        result.tags.push({
          name,
          tracking
        });
      }),
      new LineParser(/- \[deleted]\s+\S+\s*-> (.+)$/, (result, [tracking]) => {
        result.deleted.push({
          tracking
        });
      }),
      new LineParser(/\s*([^.]+)\.\.(\S+)\s+(\S+)\s*-> (.+)$/, (result, [from, to, name, tracking]) => {
        result.updated.push({
          name,
          tracking,
          to,
          from
        });
      })
    ];
  }
});
var fetch_exports = {};
__export2(fetch_exports, {
  fetchTask: () => fetchTask
});
function disallowedCommand2(command) {
  return /^--upload-pack(=|$)/.test(command);
}
function fetchTask(remote, branch, customArgs) {
  const commands = ["fetch", ...customArgs];
  if (remote && branch) {
    commands.push(remote, branch);
  }
  const banned = commands.find(disallowedCommand2);
  if (banned) {
    return configurationErrorTask(`git.fetch: potential exploit argument blocked.`);
  }
  return {
    commands,
    format: "utf-8",
    parser: parseFetchResult
  };
}
var init_fetch = __esm({
  "src/lib/tasks/fetch.ts"() {
    init_parse_fetch();
    init_task();
  }
});
function parseMoveResult(stdOut) {
  return parseStringResponse({ moves: [] }, parsers11, stdOut);
}
var parsers11;
var init_parse_move = __esm({
  "src/lib/parsers/parse-move.ts"() {
    init_utils();
    parsers11 = [
      new LineParser(/^Renaming (.+) to (.+)$/, (result, [from, to]) => {
        result.moves.push({ from, to });
      })
    ];
  }
});
var move_exports = {};
__export2(move_exports, {
  moveTask: () => moveTask
});
function moveTask(from, to) {
  return {
    commands: ["mv", "-v", ...asArray(from), to],
    format: "utf-8",
    parser: parseMoveResult
  };
}
var init_move = __esm({
  "src/lib/tasks/move.ts"() {
    init_parse_move();
    init_utils();
  }
});
var pull_exports = {};
__export2(pull_exports, {
  pullTask: () => pullTask
});
function pullTask(remote, branch, customArgs) {
  const commands = ["pull", ...customArgs];
  if (remote && branch) {
    commands.splice(1, 0, remote, branch);
  }
  return {
    commands,
    format: "utf-8",
    parser(stdOut, stdErr) {
      return parsePullResult(stdOut, stdErr);
    },
    onError(result, _error, _done, fail) {
      const pullError = parsePullErrorResult(bufferToString(result.stdOut), bufferToString(result.stdErr));
      if (pullError) {
        return fail(new GitResponseError(pullError));
      }
      fail(_error);
    }
  };
}
var init_pull = __esm({
  "src/lib/tasks/pull.ts"() {
    init_git_response_error();
    init_parse_pull();
    init_utils();
  }
});
function parseGetRemotes(text) {
  const remotes = {};
  forEach(text, ([name]) => remotes[name] = { name });
  return Object.values(remotes);
}
function parseGetRemotesVerbose(text) {
  const remotes = {};
  forEach(text, ([name, url, purpose]) => {
    if (!remotes.hasOwnProperty(name)) {
      remotes[name] = {
        name,
        refs: { fetch: "", push: "" }
      };
    }
    if (purpose && url) {
      remotes[name].refs[purpose.replace(/[^a-z]/g, "")] = url;
    }
  });
  return Object.values(remotes);
}
function forEach(text, handler) {
  forEachLineWithContent(text, (line) => handler(line.split(/\s+/)));
}
var init_GetRemoteSummary = __esm({
  "src/lib/responses/GetRemoteSummary.ts"() {
    init_utils();
  }
});
var remote_exports = {};
__export2(remote_exports, {
  addRemoteTask: () => addRemoteTask,
  getRemotesTask: () => getRemotesTask,
  listRemotesTask: () => listRemotesTask,
  remoteTask: () => remoteTask,
  removeRemoteTask: () => removeRemoteTask
});
function addRemoteTask(remoteName, remoteRepo, customArgs = []) {
  return straightThroughStringTask(["remote", "add", ...customArgs, remoteName, remoteRepo]);
}
function getRemotesTask(verbose) {
  const commands = ["remote"];
  if (verbose) {
    commands.push("-v");
  }
  return {
    commands,
    format: "utf-8",
    parser: verbose ? parseGetRemotesVerbose : parseGetRemotes
  };
}
function listRemotesTask(customArgs = []) {
  const commands = [...customArgs];
  if (commands[0] !== "ls-remote") {
    commands.unshift("ls-remote");
  }
  return straightThroughStringTask(commands);
}
function remoteTask(customArgs = []) {
  const commands = [...customArgs];
  if (commands[0] !== "remote") {
    commands.unshift("remote");
  }
  return straightThroughStringTask(commands);
}
function removeRemoteTask(remoteName) {
  return straightThroughStringTask(["remote", "remove", remoteName]);
}
var init_remote = __esm({
  "src/lib/tasks/remote.ts"() {
    init_GetRemoteSummary();
    init_task();
  }
});
var stash_list_exports = {};
__export2(stash_list_exports, {
  stashListTask: () => stashListTask
});
function stashListTask(opt = {}, customArgs) {
  const options = parseLogOptions(opt);
  const commands = ["stash", "list", ...options.commands, ...customArgs];
  const parser3 = createListLogSummaryParser(options.splitter, options.fields, logFormatFromCommand(commands));
  return validateLogFormatConfig(commands) || {
    commands,
    format: "utf-8",
    parser: parser3
  };
}
var init_stash_list = __esm({
  "src/lib/tasks/stash-list.ts"() {
    init_log_format();
    init_parse_list_log_summary();
    init_diff();
    init_log();
  }
});
var sub_module_exports = {};
__export2(sub_module_exports, {
  addSubModuleTask: () => addSubModuleTask,
  initSubModuleTask: () => initSubModuleTask,
  subModuleTask: () => subModuleTask,
  updateSubModuleTask: () => updateSubModuleTask
});
function addSubModuleTask(repo, path) {
  return subModuleTask(["add", repo, path]);
}
function initSubModuleTask(customArgs) {
  return subModuleTask(["init", ...customArgs]);
}
function subModuleTask(customArgs) {
  const commands = [...customArgs];
  if (commands[0] !== "submodule") {
    commands.unshift("submodule");
  }
  return straightThroughStringTask(commands);
}
function updateSubModuleTask(customArgs) {
  return subModuleTask(["update", ...customArgs]);
}
var init_sub_module = __esm({
  "src/lib/tasks/sub-module.ts"() {
    init_task();
  }
});
function singleSorted(a, b) {
  const aIsNum = isNaN(a);
  const bIsNum = isNaN(b);
  if (aIsNum !== bIsNum) {
    return aIsNum ? 1 : -1;
  }
  return aIsNum ? sorted(a, b) : 0;
}
function sorted(a, b) {
  return a === b ? 0 : a > b ? 1 : -1;
}
function trimmed(input) {
  return input.trim();
}
function toNumber(input) {
  if (typeof input === "string") {
    return parseInt(input.replace(/^\D+/g, ""), 10) || 0;
  }
  return 0;
}
var TagList;
var parseTagList;
var init_TagList = __esm({
  "src/lib/responses/TagList.ts"() {
    TagList = class {
      constructor(all, latest) {
        this.all = all;
        this.latest = latest;
      }
    };
    parseTagList = function(data, customSort = false) {
      const tags = data.split("\n").map(trimmed).filter(Boolean);
      if (!customSort) {
        tags.sort(function(tagA, tagB) {
          const partsA = tagA.split(".");
          const partsB = tagB.split(".");
          if (partsA.length === 1 || partsB.length === 1) {
            return singleSorted(toNumber(partsA[0]), toNumber(partsB[0]));
          }
          for (let i = 0, l = Math.max(partsA.length, partsB.length); i < l; i++) {
            const diff = sorted(toNumber(partsA[i]), toNumber(partsB[i]));
            if (diff) {
              return diff;
            }
          }
          return 0;
        });
      }
      const latest = customSort ? tags[0] : [...tags].reverse().find((tag) => tag.indexOf(".") >= 0);
      return new TagList(tags, latest);
    };
  }
});
var tag_exports = {};
__export2(tag_exports, {
  addAnnotatedTagTask: () => addAnnotatedTagTask,
  addTagTask: () => addTagTask,
  tagListTask: () => tagListTask
});
function tagListTask(customArgs = []) {
  const hasCustomSort = customArgs.some((option) => /^--sort=/.test(option));
  return {
    format: "utf-8",
    commands: ["tag", "-l", ...customArgs],
    parser(text) {
      return parseTagList(text, hasCustomSort);
    }
  };
}
function addTagTask(name) {
  return {
    format: "utf-8",
    commands: ["tag", name],
    parser() {
      return { name };
    }
  };
}
function addAnnotatedTagTask(name, tagMessage) {
  return {
    format: "utf-8",
    commands: ["tag", "-a", "-m", tagMessage, name],
    parser() {
      return { name };
    }
  };
}
var init_tag = __esm({
  "src/lib/tasks/tag.ts"() {
    init_TagList();
  }
});
var require_git = __commonJS2({
  "src/git.js"(exports, module2) {
    var { GitExecutor: GitExecutor2 } = (init_git_executor(), __toCommonJS2(git_executor_exports));
    var { SimpleGitApi: SimpleGitApi2 } = (init_simple_git_api(), __toCommonJS2(simple_git_api_exports));
    var { Scheduler: Scheduler2 } = (init_scheduler(), __toCommonJS2(scheduler_exports));
    var { configurationErrorTask: configurationErrorTask2 } = (init_task(), __toCommonJS2(task_exports));
    var {
      asArray: asArray2,
      filterArray: filterArray2,
      filterPrimitives: filterPrimitives2,
      filterString: filterString2,
      filterStringOrStringArray: filterStringOrStringArray2,
      filterType: filterType2,
      getTrailingOptions: getTrailingOptions2,
      trailingFunctionArgument: trailingFunctionArgument2,
      trailingOptionsArgument: trailingOptionsArgument2
    } = (init_utils(), __toCommonJS2(utils_exports));
    var { applyPatchTask: applyPatchTask2 } = (init_apply_patch(), __toCommonJS2(apply_patch_exports));
    var {
      branchTask: branchTask2,
      branchLocalTask: branchLocalTask2,
      deleteBranchesTask: deleteBranchesTask2,
      deleteBranchTask: deleteBranchTask2
    } = (init_branch(), __toCommonJS2(branch_exports));
    var { checkIgnoreTask: checkIgnoreTask2 } = (init_check_ignore(), __toCommonJS2(check_ignore_exports));
    var { checkIsRepoTask: checkIsRepoTask2 } = (init_check_is_repo(), __toCommonJS2(check_is_repo_exports));
    var { cloneTask: cloneTask2, cloneMirrorTask: cloneMirrorTask2 } = (init_clone(), __toCommonJS2(clone_exports));
    var { cleanWithOptionsTask: cleanWithOptionsTask2, isCleanOptionsArray: isCleanOptionsArray2 } = (init_clean(), __toCommonJS2(clean_exports));
    var { diffSummaryTask: diffSummaryTask2 } = (init_diff(), __toCommonJS2(diff_exports));
    var { fetchTask: fetchTask2 } = (init_fetch(), __toCommonJS2(fetch_exports));
    var { moveTask: moveTask2 } = (init_move(), __toCommonJS2(move_exports));
    var { pullTask: pullTask2 } = (init_pull(), __toCommonJS2(pull_exports));
    var { pushTagsTask: pushTagsTask2 } = (init_push(), __toCommonJS2(push_exports));
    var {
      addRemoteTask: addRemoteTask2,
      getRemotesTask: getRemotesTask2,
      listRemotesTask: listRemotesTask2,
      remoteTask: remoteTask2,
      removeRemoteTask: removeRemoteTask2
    } = (init_remote(), __toCommonJS2(remote_exports));
    var { getResetMode: getResetMode2, resetTask: resetTask2 } = (init_reset(), __toCommonJS2(reset_exports));
    var { stashListTask: stashListTask2 } = (init_stash_list(), __toCommonJS2(stash_list_exports));
    var {
      addSubModuleTask: addSubModuleTask2,
      initSubModuleTask: initSubModuleTask2,
      subModuleTask: subModuleTask2,
      updateSubModuleTask: updateSubModuleTask2
    } = (init_sub_module(), __toCommonJS2(sub_module_exports));
    var { addAnnotatedTagTask: addAnnotatedTagTask2, addTagTask: addTagTask2, tagListTask: tagListTask2 } = (init_tag(), __toCommonJS2(tag_exports));
    var { straightThroughBufferTask: straightThroughBufferTask2, straightThroughStringTask: straightThroughStringTask2 } = (init_task(), __toCommonJS2(task_exports));
    function Git22(options, plugins) {
      this._executor = new GitExecutor2(options.binary, options.baseDir, new Scheduler2(options.maxConcurrentProcesses), plugins);
      this._trimmed = options.trimmed;
    }
    (Git22.prototype = Object.create(SimpleGitApi2.prototype)).constructor = Git22;
    Git22.prototype.customBinary = function(command) {
      this._executor.binary = command;
      return this;
    };
    Git22.prototype.env = function(name, value) {
      if (arguments.length === 1 && typeof name === "object") {
        this._executor.env = name;
      } else {
        (this._executor.env = this._executor.env || {})[name] = value;
      }
      return this;
    };
    Git22.prototype.stashList = function(options) {
      return this._runTask(stashListTask2(trailingOptionsArgument2(arguments) || {}, filterArray2(options) && options || []), trailingFunctionArgument2(arguments));
    };
    function createCloneTask(api, task, repoPath, localPath) {
      if (typeof repoPath !== "string") {
        return configurationErrorTask2(`git.${api}() requires a string 'repoPath'`);
      }
      return task(repoPath, filterType2(localPath, filterString2), getTrailingOptions2(arguments));
    }
    Git22.prototype.clone = function() {
      return this._runTask(createCloneTask("clone", cloneTask2, ...arguments), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.mirror = function() {
      return this._runTask(createCloneTask("mirror", cloneMirrorTask2, ...arguments), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.mv = function(from, to) {
      return this._runTask(moveTask2(from, to), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.checkoutLatestTag = function(then) {
      var git = this;
      return this.pull(function() {
        git.tags(function(err, tags) {
          git.checkout(tags.latest, then);
        });
      });
    };
    Git22.prototype.pull = function(remote, branch, options, then) {
      return this._runTask(pullTask2(filterType2(remote, filterString2), filterType2(branch, filterString2), getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.fetch = function(remote, branch) {
      return this._runTask(fetchTask2(filterType2(remote, filterString2), filterType2(branch, filterString2), getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.silent = function(silence) {
      console.warn("simple-git deprecation notice: git.silent: logging should be configured using the `debug` library / `DEBUG` environment variable, this will be an error in version 3");
      return this;
    };
    Git22.prototype.tags = function(options, then) {
      return this._runTask(tagListTask2(getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.rebase = function() {
      return this._runTask(straightThroughStringTask2(["rebase", ...getTrailingOptions2(arguments)]), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.reset = function(mode) {
      return this._runTask(resetTask2(getResetMode2(mode), getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.revert = function(commit) {
      const next = trailingFunctionArgument2(arguments);
      if (typeof commit !== "string") {
        return this._runTask(configurationErrorTask2("Commit must be a string"), next);
      }
      return this._runTask(straightThroughStringTask2(["revert", ...getTrailingOptions2(arguments, 0, true), commit]), next);
    };
    Git22.prototype.addTag = function(name) {
      const task = typeof name === "string" ? addTagTask2(name) : configurationErrorTask2("Git.addTag requires a tag name");
      return this._runTask(task, trailingFunctionArgument2(arguments));
    };
    Git22.prototype.addAnnotatedTag = function(tagName, tagMessage) {
      return this._runTask(addAnnotatedTagTask2(tagName, tagMessage), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.deleteLocalBranch = function(branchName, forceDelete, then) {
      return this._runTask(deleteBranchTask2(branchName, typeof forceDelete === "boolean" ? forceDelete : false), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.deleteLocalBranches = function(branchNames, forceDelete, then) {
      return this._runTask(deleteBranchesTask2(branchNames, typeof forceDelete === "boolean" ? forceDelete : false), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.branch = function(options, then) {
      return this._runTask(branchTask2(getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.branchLocal = function(then) {
      return this._runTask(branchLocalTask2(), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.raw = function(commands) {
      const createRestCommands = !Array.isArray(commands);
      const command = [].slice.call(createRestCommands ? arguments : commands, 0);
      for (let i = 0; i < command.length && createRestCommands; i++) {
        if (!filterPrimitives2(command[i])) {
          command.splice(i, command.length - i);
          break;
        }
      }
      command.push(...getTrailingOptions2(arguments, 0, true));
      var next = trailingFunctionArgument2(arguments);
      if (!command.length) {
        return this._runTask(configurationErrorTask2("Raw: must supply one or more command to execute"), next);
      }
      return this._runTask(straightThroughStringTask2(command, this._trimmed), next);
    };
    Git22.prototype.submoduleAdd = function(repo, path, then) {
      return this._runTask(addSubModuleTask2(repo, path), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.submoduleUpdate = function(args, then) {
      return this._runTask(updateSubModuleTask2(getTrailingOptions2(arguments, true)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.submoduleInit = function(args, then) {
      return this._runTask(initSubModuleTask2(getTrailingOptions2(arguments, true)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.subModule = function(options, then) {
      return this._runTask(subModuleTask2(getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.listRemote = function() {
      return this._runTask(listRemotesTask2(getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.addRemote = function(remoteName, remoteRepo, then) {
      return this._runTask(addRemoteTask2(remoteName, remoteRepo, getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.removeRemote = function(remoteName, then) {
      return this._runTask(removeRemoteTask2(remoteName), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.getRemotes = function(verbose, then) {
      return this._runTask(getRemotesTask2(verbose === true), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.remote = function(options, then) {
      return this._runTask(remoteTask2(getTrailingOptions2(arguments)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.tag = function(options, then) {
      const command = getTrailingOptions2(arguments);
      if (command[0] !== "tag") {
        command.unshift("tag");
      }
      return this._runTask(straightThroughStringTask2(command), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.updateServerInfo = function(then) {
      return this._runTask(straightThroughStringTask2(["update-server-info"]), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.pushTags = function(remote, then) {
      const task = pushTagsTask2({ remote: filterType2(remote, filterString2) }, getTrailingOptions2(arguments));
      return this._runTask(task, trailingFunctionArgument2(arguments));
    };
    Git22.prototype.rm = function(files) {
      return this._runTask(straightThroughStringTask2(["rm", "-f", ...asArray2(files)]), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.rmKeepLocal = function(files) {
      return this._runTask(straightThroughStringTask2(["rm", "--cached", ...asArray2(files)]), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.catFile = function(options, then) {
      return this._catFile("utf-8", arguments);
    };
    Git22.prototype.binaryCatFile = function() {
      return this._catFile("buffer", arguments);
    };
    Git22.prototype._catFile = function(format, args) {
      var handler = trailingFunctionArgument2(args);
      var command = ["cat-file"];
      var options = args[0];
      if (typeof options === "string") {
        return this._runTask(configurationErrorTask2("Git.catFile: options must be supplied as an array of strings"), handler);
      }
      if (Array.isArray(options)) {
        command.push.apply(command, options);
      }
      const task = format === "buffer" ? straightThroughBufferTask2(command) : straightThroughStringTask2(command);
      return this._runTask(task, handler);
    };
    Git22.prototype.diff = function(options, then) {
      const task = filterString2(options) ? configurationErrorTask2("git.diff: supplying options as a single string is no longer supported, switch to an array of strings") : straightThroughStringTask2(["diff", ...getTrailingOptions2(arguments)]);
      return this._runTask(task, trailingFunctionArgument2(arguments));
    };
    Git22.prototype.diffSummary = function() {
      return this._runTask(diffSummaryTask2(getTrailingOptions2(arguments, 1)), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.applyPatch = function(patches) {
      const task = !filterStringOrStringArray2(patches) ? configurationErrorTask2(`git.applyPatch requires one or more string patches as the first argument`) : applyPatchTask2(asArray2(patches), getTrailingOptions2([].slice.call(arguments, 1)));
      return this._runTask(task, trailingFunctionArgument2(arguments));
    };
    Git22.prototype.revparse = function() {
      const commands = ["rev-parse", ...getTrailingOptions2(arguments, true)];
      return this._runTask(straightThroughStringTask2(commands, true), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.clean = function(mode, options, then) {
      const usingCleanOptionsArray = isCleanOptionsArray2(mode);
      const cleanMode = usingCleanOptionsArray && mode.join("") || filterType2(mode, filterString2) || "";
      const customArgs = getTrailingOptions2([].slice.call(arguments, usingCleanOptionsArray ? 1 : 0));
      return this._runTask(cleanWithOptionsTask2(cleanMode, customArgs), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.exec = function(then) {
      const task = {
        commands: [],
        format: "utf-8",
        parser() {
          if (typeof then === "function") {
            then();
          }
        }
      };
      return this._runTask(task);
    };
    Git22.prototype.clearQueue = function() {
      return this;
    };
    Git22.prototype.checkIgnore = function(pathnames, then) {
      return this._runTask(checkIgnoreTask2(asArray2(filterType2(pathnames, filterStringOrStringArray2, []))), trailingFunctionArgument2(arguments));
    };
    Git22.prototype.checkIsRepo = function(checkType, then) {
      return this._runTask(checkIsRepoTask2(filterType2(checkType, filterString2)), trailingFunctionArgument2(arguments));
    };
    module2.exports = Git22;
  }
});
init_pathspec();
init_git_error();
var GitConstructError = class extends GitError {
  constructor(config, message) {
    super(void 0, message);
    this.config = config;
  }
};
init_git_error();
init_git_error();
var GitPluginError = class extends GitError {
  constructor(task, plugin, message) {
    super(task, message);
    this.task = task;
    this.plugin = plugin;
    Object.setPrototypeOf(this, new.target.prototype);
  }
};
init_git_response_error();
init_task_configuration_error();
init_check_is_repo();
init_clean();
init_config();
init_diff_name_status();
init_grep();
init_reset();
function abortPlugin(signal) {
  if (!signal) {
    return;
  }
  const onSpawnAfter = {
    type: "spawn.after",
    action(_data, context) {
      function kill() {
        context.kill(new GitPluginError(void 0, "abort", "Abort signal received"));
      }
      signal.addEventListener("abort", kill);
      context.spawned.on("close", () => signal.removeEventListener("abort", kill));
    }
  };
  const onSpawnBefore = {
    type: "spawn.before",
    action(_data, context) {
      if (signal.aborted) {
        context.kill(new GitPluginError(void 0, "abort", "Abort already signaled"));
      }
    }
  };
  return [onSpawnBefore, onSpawnAfter];
}
function isConfigSwitch(arg) {
  return typeof arg === "string" && arg.trim().toLowerCase() === "-c";
}
function preventProtocolOverride(arg, next) {
  if (!isConfigSwitch(arg)) {
    return;
  }
  if (!/^\s*protocol(.[a-z]+)?.allow/.test(next)) {
    return;
  }
  throw new GitPluginError(void 0, "unsafe", "Configuring protocol.allow is not permitted without enabling allowUnsafeExtProtocol");
}
function preventUploadPack(arg, method) {
  if (/^\s*--(upload|receive)-pack/.test(arg)) {
    throw new GitPluginError(void 0, "unsafe", `Use of --upload-pack or --receive-pack is not permitted without enabling allowUnsafePack`);
  }
  if (method === "clone" && /^\s*-u\b/.test(arg)) {
    throw new GitPluginError(void 0, "unsafe", `Use of clone with option -u is not permitted without enabling allowUnsafePack`);
  }
  if (method === "push" && /^\s*--exec\b/.test(arg)) {
    throw new GitPluginError(void 0, "unsafe", `Use of push with option --exec is not permitted without enabling allowUnsafePack`);
  }
}
function blockUnsafeOperationsPlugin({
  allowUnsafeProtocolOverride = false,
  allowUnsafePack = false
} = {}) {
  return {
    type: "spawn.args",
    action(args, context) {
      args.forEach((current, index) => {
        const next = index < args.length ? args[index + 1] : "";
        allowUnsafeProtocolOverride || preventProtocolOverride(current, next);
        allowUnsafePack || preventUploadPack(current, context.method);
      });
      return args;
    }
  };
}
init_utils();
function commandConfigPrefixingPlugin(configuration) {
  const prefix = prefixedArray(configuration, "-c");
  return {
    type: "spawn.args",
    action(data) {
      return [...prefix, ...data];
    }
  };
}
init_utils();
var never = (0, import_promise_deferred2.deferred)().promise;
function completionDetectionPlugin({
  onClose = true,
  onExit = 50
} = {}) {
  function createEvents() {
    let exitCode = -1;
    const events = {
      close: (0, import_promise_deferred2.deferred)(),
      closeTimeout: (0, import_promise_deferred2.deferred)(),
      exit: (0, import_promise_deferred2.deferred)(),
      exitTimeout: (0, import_promise_deferred2.deferred)()
    };
    const result = Promise.race([
      onClose === false ? never : events.closeTimeout.promise,
      onExit === false ? never : events.exitTimeout.promise
    ]);
    configureTimeout(onClose, events.close, events.closeTimeout);
    configureTimeout(onExit, events.exit, events.exitTimeout);
    return {
      close(code) {
        exitCode = code;
        events.close.done();
      },
      exit(code) {
        exitCode = code;
        events.exit.done();
      },
      get exitCode() {
        return exitCode;
      },
      result
    };
  }
  function configureTimeout(flag, event, timeout) {
    if (flag === false) {
      return;
    }
    (flag === true ? event.promise : event.promise.then(() => delay(flag))).then(timeout.done);
  }
  return {
    type: "spawn.after",
    action(_0, _1) {
      return __async(this, arguments, function* (_data, { spawned, close }) {
        var _a2, _b;
        const events = createEvents();
        let deferClose = true;
        let quickClose = () => void (deferClose = false);
        (_a2 = spawned.stdout) == null ? void 0 : _a2.on("data", quickClose);
        (_b = spawned.stderr) == null ? void 0 : _b.on("data", quickClose);
        spawned.on("error", quickClose);
        spawned.on("close", (code) => events.close(code));
        spawned.on("exit", (code) => events.exit(code));
        try {
          yield events.result;
          if (deferClose) {
            yield delay(50);
          }
          close(events.exitCode);
        } catch (err) {
          close(events.exitCode, err);
        }
      });
    }
  };
}
init_git_error();
function isTaskError(result) {
  return !!(result.exitCode && result.stdErr.length);
}
function getErrorMessage(result) {
  return Buffer.concat([...result.stdOut, ...result.stdErr]);
}
function errorDetectionHandler(overwrite = false, isError = isTaskError, errorMessage = getErrorMessage) {
  return (error, result) => {
    if (!overwrite && error || !isError(result)) {
      return error;
    }
    return errorMessage(result);
  };
}
function errorDetectionPlugin(config) {
  return {
    type: "task.error",
    action(data, context) {
      const error = config(data.error, {
        stdErr: context.stdErr,
        stdOut: context.stdOut,
        exitCode: context.exitCode
      });
      if (Buffer.isBuffer(error)) {
        return { error: new GitError(void 0, error.toString("utf-8")) };
      }
      return {
        error
      };
    }
  };
}
init_utils();
var PluginStore = class {
  constructor() {
    this.plugins = /* @__PURE__ */ new Set();
  }
  add(plugin) {
    const plugins = [];
    asArray(plugin).forEach((plugin2) => plugin2 && this.plugins.add(append(plugins, plugin2)));
    return () => {
      plugins.forEach((plugin2) => this.plugins.delete(plugin2));
    };
  }
  exec(type, data, context) {
    let output = data;
    const contextual = Object.freeze(Object.create(context));
    for (const plugin of this.plugins) {
      if (plugin.type === type) {
        output = plugin.action(output, contextual);
      }
    }
    return output;
  }
};
init_utils();
function progressMonitorPlugin(progress) {
  const progressCommand = "--progress";
  const progressMethods = ["checkout", "clone", "fetch", "pull", "push"];
  const onProgress = {
    type: "spawn.after",
    action(_data, context) {
      var _a2;
      if (!context.commands.includes(progressCommand)) {
        return;
      }
      (_a2 = context.spawned.stderr) == null ? void 0 : _a2.on("data", (chunk) => {
        const message = /^([\s\S]+?):\s*(\d+)% \((\d+)\/(\d+)\)/.exec(chunk.toString("utf8"));
        if (!message) {
          return;
        }
        progress({
          method: context.method,
          stage: progressEventStage(message[1]),
          progress: asNumber(message[2]),
          processed: asNumber(message[3]),
          total: asNumber(message[4])
        });
      });
    }
  };
  const onArgs = {
    type: "spawn.args",
    action(args, context) {
      if (!progressMethods.includes(context.method)) {
        return args;
      }
      return including(args, progressCommand);
    }
  };
  return [onArgs, onProgress];
}
function progressEventStage(input) {
  return String(input.toLowerCase().split(" ", 1)) || "unknown";
}
init_utils();
function spawnOptionsPlugin(spawnOptions) {
  const options = pick(spawnOptions, ["uid", "gid"]);
  return {
    type: "spawn.options",
    action(data) {
      return __spreadValues(__spreadValues({}, options), data);
    }
  };
}
function timeoutPlugin({
  block,
  stdErr = true,
  stdOut = true
}) {
  if (block > 0) {
    return {
      type: "spawn.after",
      action(_data, context) {
        var _a2, _b;
        let timeout;
        function wait() {
          timeout && clearTimeout(timeout);
          timeout = setTimeout(kill, block);
        }
        function stop() {
          var _a3, _b2;
          (_a3 = context.spawned.stdout) == null ? void 0 : _a3.off("data", wait);
          (_b2 = context.spawned.stderr) == null ? void 0 : _b2.off("data", wait);
          context.spawned.off("exit", stop);
          context.spawned.off("close", stop);
          timeout && clearTimeout(timeout);
        }
        function kill() {
          stop();
          context.kill(new GitPluginError(void 0, "timeout", `block timeout reached`));
        }
        stdOut && ((_a2 = context.spawned.stdout) == null ? void 0 : _a2.on("data", wait));
        stdErr && ((_b = context.spawned.stderr) == null ? void 0 : _b.on("data", wait));
        context.spawned.on("exit", stop);
        context.spawned.on("close", stop);
        wait();
      }
    };
  }
}
init_pathspec();
function suffixPathsPlugin() {
  return {
    type: "spawn.args",
    action(data) {
      const prefix = [];
      let suffix;
      function append2(args) {
        (suffix = suffix || []).push(...args);
      }
      for (let i = 0; i < data.length; i++) {
        const param = data[i];
        if (isPathSpec(param)) {
          append2(toPaths(param));
          continue;
        }
        if (param === "--") {
          append2(data.slice(i + 1).flatMap((item) => isPathSpec(item) && toPaths(item) || item));
          break;
        }
        prefix.push(param);
      }
      return !suffix ? prefix : [...prefix, "--", ...suffix.map(String)];
    }
  };
}
init_utils();
var Git = require_git();
function gitInstanceFactory(baseDir, options) {
  const plugins = new PluginStore();
  const config = createInstanceConfig(baseDir && (typeof baseDir === "string" ? { baseDir } : baseDir) || {}, options);
  if (!folderExists(config.baseDir)) {
    throw new GitConstructError(config, `Cannot use simple-git on a directory that does not exist`);
  }
  if (Array.isArray(config.config)) {
    plugins.add(commandConfigPrefixingPlugin(config.config));
  }
  plugins.add(blockUnsafeOperationsPlugin(config.unsafe));
  plugins.add(suffixPathsPlugin());
  plugins.add(completionDetectionPlugin(config.completion));
  config.abort && plugins.add(abortPlugin(config.abort));
  config.progress && plugins.add(progressMonitorPlugin(config.progress));
  config.timeout && plugins.add(timeoutPlugin(config.timeout));
  config.spawnOptions && plugins.add(spawnOptionsPlugin(config.spawnOptions));
  plugins.add(errorDetectionPlugin(errorDetectionHandler(true)));
  config.errors && plugins.add(errorDetectionPlugin(config.errors));
  return new Git(config, plugins);
}
init_git_response_error();
var esm_default = gitInstanceFactory;

// src/git/git.ts
var DEFAULT_GIT_OPTIONS = {
  binary: "git",
  trimmed: true
};
var Git2 = class {
  constructor(baseDir) {
    this._instance = null;
    this.REMOTE_NAME = "origin";
    this.branch = null;
    this.instance = esm_default({
      ...DEFAULT_GIT_OPTIONS,
      baseDir
    }).init();
    this.instance.status().then((status) => {
      this.branch = status.current;
    }).catch((err) => {
      console.log(err);
    });
  }
  get instance() {
    if (!this._instance) {
      throw new Error("Git instance is not instantiated");
    }
    return this._instance;
  }
  set instance(inst) {
    this._instance = inst;
  }
  getBranch() {
    return this.branch;
  }
  async getRemote() {
    var _a2, _b;
    const remotes = await this.instance.getRemotes(true);
    if (remotes.length > 0) {
      return (_b = (_a2 = remotes.find((remote) => remote.name === this.REMOTE_NAME)) == null ? void 0 : _a2.refs.push) != null ? _b : null;
    } else {
      return null;
    }
  }
  addRemote(repo) {
    return this.getRemote().then((remote) => {
      if (remote !== null) {
        this.instance.removeRemote(this.REMOTE_NAME);
      }
    }).then(() => this.instance.addRemote(this.REMOTE_NAME, repo));
  }
  addAllAndCommit(msg) {
    return this.instance.add("*").commit(msg);
  }
  addAllAndCommitAndPush(msg) {
    return this.addAllAndCommit(msg).then((res) => {
      if (res.commit) {
        return this.push();
      } else {
        return null;
      }
    }).catch((err) => {
      throw new Error(err.message);
    });
  }
  pull() {
    var _a2;
    return this.instance.pull(this.REMOTE_NAME, (_a2 = this.getBranch()) != null ? _a2 : void 0).catch((err) => {
      if (err.message !== "couldn't find remote ref master") {
        throw new Error(err.message);
      }
    });
  }
  push() {
    var _a2;
    return this.instance.push(this.REMOTE_NAME, (_a2 = this.getBranch()) != null ? _a2 : void 0, ["--set-upstream"]).catch((err) => {
      throw new Error(err.message);
    });
  }
  getLatestCommitMsg() {
    return this.instance.log().then((log) => {
      var _a2, _b;
      return (_b = (_a2 = log.latest) == null ? void 0 : _a2.message) != null ? _b : null;
    }).catch(() => null);
  }
  status() {
    this.instance.status().then((status) => console.log(status));
  }
  log() {
    this.instance.log().then((log) => console.log(log.latest.message));
  }
};

// src/settings-tab.ts
var import_obsidian7 = require("obsidian");

// src/debug/utils/open-folder.ts
var childProcess = __toESM(require("child_process"));
var openFolder = (path) => {
  childProcess.exec(`start "" "${path}"`);
};

// src/utils/utils.ts
var import_obsidian6 = require("obsidian");
var getVaultPath = (app) => {
  if (app.vault.adapter instanceof import_obsidian6.FileSystemAdapter) {
    return app.vault.adapter.getBasePath();
  }
  throw new Error(
    "Unable to get vault base path as vault is not within a valid file system"
  );
};

// src/settings-tab.ts
var SettingsTab = class extends import_obsidian7.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian7.Setting(containerEl).setName("Remote repository url").setDesc(
      "Enter your remote repository url (or change it to push to a different url)"
    ).addText(
      (text) => {
        var _a2;
        return text.setPlaceholder("Remote repository url").setValue((_a2 = this.plugin.settings.gitRemote) != null ? _a2 : "").onChange(async (value) => {
          this.plugin.settings.gitRemote = value;
          await this.plugin.saveSettings();
          if (this.plugin.settings.gitRemote) {
            this.plugin.git.addRemote(this.plugin.settings.gitRemote);
          }
        });
      }
    );
    new import_obsidian7.Setting(containerEl).setName("File explorer").setDesc("Open folder in file explorer").addButton((btn) => {
      btn.setButtonText("Open").setClass("bg-theme").onClick(() => {
        openFolder(getVaultPath(this.app));
      });
    });
  }
};

// src/main.ts
var GitPlugin = class extends import_obsidian8.Plugin {
  constructor() {
    super(...arguments);
    this.latestCommitMsg = null;
  }
  get menuModal() {
    return new GitMenuModal(
      this.app,
      this.settings.gitRemote ? null : this.initRemoteModal,
      this.commitModal,
      this.syncModal
    );
  }
  get initRemoteModal() {
    return new GitInitRemote(this.app, (repo) => {
      this.git.addRemote(repo).then(() => {
        new import_obsidian8.Notice(`Added remote origin "${repo}"`);
        this.updateRemoteRepository(repo);
      }).catch((err) => new import_obsidian8.Notice(err));
    });
  }
  get commitModal() {
    return new GitCommitModal(
      this.app,
      this.latestCommitMsg,
      (msg, sync) => {
        if (sync) {
          this.git.addAllAndCommitAndPush(msg).then((res) => {
            if (res && (res.update || res.pushed.length > 0 && res.pushed[0].new === true)) {
              new import_obsidian8.Notice(`Committed and pushed new changes to remote branch`);
              this.latestCommitMsg = msg.split("\n")[0];
            } else {
              new import_obsidian8.Notice(`No changes to commit`);
            }
          }).catch((err) => new import_obsidian8.Notice(err));
        } else {
          this.git.addAllAndCommit(msg).then((res) => {
            if (res.commit) {
              new import_obsidian8.Notice(`Committed "${msg.split("\n")[0]}"`);
              this.latestCommitMsg = msg.split("\n")[0];
            } else {
              new import_obsidian8.Notice(`No changes to commit`);
            }
          }).catch((err) => new import_obsidian8.Notice(err));
        }
      }
    );
  }
  get syncModal() {
    return new GitSyncModal(this.app, () => {
      this.git.push().then((res) => {
        if (res.update || res.pushed.length > 0 && res.pushed[0].new === true) {
          new import_obsidian8.Notice(`Pushed new changes to remote branch`);
        } else {
          new import_obsidian8.Notice("No changes to push");
        }
      }).catch((err) => {
        this.openDebugModal(err, "ERROR");
        new import_obsidian8.Notice(err);
      });
    });
  }
  async onload() {
    try {
      this.git = new Git2(getVaultPath(this.app));
      await this.loadSettings();
      this.addSettingsPage();
      this.addMenuRibbonIcon();
      this.addOpenInitModalCommand();
      this.addSyncCommand();
      this.addOpenCommitModalCommand();
      this.addStatusBarIndication();
    } catch (err) {
      this.openDebugModal(err, "ERROR");
      new import_obsidian8.Notice(err);
    }
  }
  addMenuRibbonIcon() {
    this.addRibbonIcon("git-compare-arrows", "Open git menu", () => {
      this.menuModal.open();
    });
  }
  addOpenInitModalCommand() {
    this.addCommand({
      id: "init",
      name: "Init repository",
      checkCallback: (checking) => {
        if (!this.settings.gitRemote) {
          if (!checking) {
            this.initRemoteModal.open();
          }
          return true;
        }
      }
    });
  }
  addOpenCommitModalCommand() {
    this.addCommand({
      id: "commit",
      name: "Commit changes",
      callback: () => {
        this.commitModal.open();
      }
    });
  }
  addSyncCommand() {
    this.addCommand({
      id: "sync",
      name: "Sync with remote repository",
      callback: () => {
        this.syncModal.open();
      }
    });
  }
  addStatusBarIndication() {
    const statusBarItemEl = this.addStatusBarItem();
    statusBarItemEl.setText("Git integration active");
  }
  addSettingsPage() {
    this.addSettingTab(new SettingsTab(this.app, this));
  }
  openDebugModal(content, mode = "DEBUG") {
    if (IS_DEBUG_MODE && content) {
      switch (mode) {
        case "ERROR": {
          new ErrorModal(this.app, content).open();
          break;
        }
        default: {
          new DebugModal(this.app, content).open();
        }
      }
    }
  }
  updateRemoteRepository(repo) {
    this.settings.gitRemote = repo != null ? repo : "";
    this.saveSettings();
  }
  onunload() {
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
    const gitRemote = await this.git.getRemote();
    if (gitRemote && !this.settings.gitRemote) {
      this.updateRemoteRepository(gitRemote);
    }
    this.latestCommitMsg = await this.git.getLatestCommitMsg();
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
//# sourceMappingURL=data:application/json;base64,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
