/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/obsidian-daily-notes-interface/dist/main.js
var require_main = __commonJS({
  "node_modules/obsidian-daily-notes-interface/dist/main.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var obsidian = require("obsidian");
    var DEFAULT_DAILY_NOTE_FORMAT = "YYYY-MM-DD";
    var DEFAULT_WEEKLY_NOTE_FORMAT = "gggg-[W]ww";
    var DEFAULT_MONTHLY_NOTE_FORMAT = "YYYY-MM";
    var DEFAULT_QUARTERLY_NOTE_FORMAT = "YYYY-[Q]Q";
    var DEFAULT_YEARLY_NOTE_FORMAT = "YYYY";
    function shouldUsePeriodicNotesSettings(periodicity) {
      var _a, _b;
      const periodicNotes = window.app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a[periodicity]) == null ? void 0 : _b.enabled);
    }
    function getDailyNoteSettings() {
      var _a, _b, _c, _d;
      try {
        const { internalPlugins, plugins } = window.app;
        if (shouldUsePeriodicNotesSettings("daily")) {
          const { format: format2, folder: folder2, template: template2 } = ((_b = (_a = plugins.getPlugin("periodic-notes")) == null ? void 0 : _a.settings) == null ? void 0 : _b.daily) || {};
          return {
            format: format2 || DEFAULT_DAILY_NOTE_FORMAT,
            folder: (folder2 == null ? void 0 : folder2.trim()) || "",
            template: (template2 == null ? void 0 : template2.trim()) || ""
          };
        }
        const { folder, format, template } = ((_d = (_c = internalPlugins.getPluginById("daily-notes")) == null ? void 0 : _c.instance) == null ? void 0 : _d.options) || {};
        return {
          format: format || DEFAULT_DAILY_NOTE_FORMAT,
          folder: (folder == null ? void 0 : folder.trim()) || "",
          template: (template == null ? void 0 : template.trim()) || ""
        };
      } catch (err) {
        console.info("No custom daily note settings found!", err);
      }
    }
    function getWeeklyNoteSettings() {
      var _a, _b, _c, _d, _e, _f, _g;
      try {
        const pluginManager = window.app.plugins;
        const calendarSettings = (_a = pluginManager.getPlugin("calendar")) == null ? void 0 : _a.options;
        const periodicNotesSettings = (_c = (_b = pluginManager.getPlugin("periodic-notes")) == null ? void 0 : _b.settings) == null ? void 0 : _c.weekly;
        if (shouldUsePeriodicNotesSettings("weekly")) {
          return {
            format: periodicNotesSettings.format || DEFAULT_WEEKLY_NOTE_FORMAT,
            folder: ((_d = periodicNotesSettings.folder) == null ? void 0 : _d.trim()) || "",
            template: ((_e = periodicNotesSettings.template) == null ? void 0 : _e.trim()) || ""
          };
        }
        const settings = calendarSettings || {};
        return {
          format: settings.weeklyNoteFormat || DEFAULT_WEEKLY_NOTE_FORMAT,
          folder: ((_f = settings.weeklyNoteFolder) == null ? void 0 : _f.trim()) || "",
          template: ((_g = settings.weeklyNoteTemplate) == null ? void 0 : _g.trim()) || ""
        };
      } catch (err) {
        console.info("No custom weekly note settings found!", err);
      }
    }
    function getMonthlyNoteSettings() {
      var _a, _b, _c, _d;
      const pluginManager = window.app.plugins;
      try {
        const settings = shouldUsePeriodicNotesSettings("monthly") && ((_b = (_a = pluginManager.getPlugin("periodic-notes")) == null ? void 0 : _a.settings) == null ? void 0 : _b.monthly) || {};
        return {
          format: settings.format || DEFAULT_MONTHLY_NOTE_FORMAT,
          folder: ((_c = settings.folder) == null ? void 0 : _c.trim()) || "",
          template: ((_d = settings.template) == null ? void 0 : _d.trim()) || ""
        };
      } catch (err) {
        console.info("No custom monthly note settings found!", err);
      }
    }
    function getQuarterlyNoteSettings() {
      var _a, _b, _c, _d;
      const pluginManager = window.app.plugins;
      try {
        const settings = shouldUsePeriodicNotesSettings("quarterly") && ((_b = (_a = pluginManager.getPlugin("periodic-notes")) == null ? void 0 : _a.settings) == null ? void 0 : _b.quarterly) || {};
        return {
          format: settings.format || DEFAULT_QUARTERLY_NOTE_FORMAT,
          folder: ((_c = settings.folder) == null ? void 0 : _c.trim()) || "",
          template: ((_d = settings.template) == null ? void 0 : _d.trim()) || ""
        };
      } catch (err) {
        console.info("No custom quarterly note settings found!", err);
      }
    }
    function getYearlyNoteSettings() {
      var _a, _b, _c, _d;
      const pluginManager = window.app.plugins;
      try {
        const settings = shouldUsePeriodicNotesSettings("yearly") && ((_b = (_a = pluginManager.getPlugin("periodic-notes")) == null ? void 0 : _a.settings) == null ? void 0 : _b.yearly) || {};
        return {
          format: settings.format || DEFAULT_YEARLY_NOTE_FORMAT,
          folder: ((_c = settings.folder) == null ? void 0 : _c.trim()) || "",
          template: ((_d = settings.template) == null ? void 0 : _d.trim()) || ""
        };
      } catch (err) {
        console.info("No custom yearly note settings found!", err);
      }
    }
    function join(...partSegments) {
      let parts = [];
      for (let i = 0, l = partSegments.length; i < l; i++) {
        parts = parts.concat(partSegments[i].split("/"));
      }
      const newParts = [];
      for (let i = 0, l = parts.length; i < l; i++) {
        const part = parts[i];
        if (!part || part === ".")
          continue;
        else
          newParts.push(part);
      }
      if (parts[0] === "")
        newParts.unshift("");
      return newParts.join("/");
    }
    function basename(fullPath) {
      let base = fullPath.substring(fullPath.lastIndexOf("/") + 1);
      if (base.lastIndexOf(".") != -1)
        base = base.substring(0, base.lastIndexOf("."));
      return base;
    }
    async function ensureFolderExists(path) {
      const dirs = path.replace(/\\/g, "/").split("/");
      dirs.pop();
      if (dirs.length) {
        const dir = join(...dirs);
        if (!window.app.vault.getAbstractFileByPath(dir)) {
          await window.app.vault.createFolder(dir);
        }
      }
    }
    async function getNotePath(directory, filename) {
      if (!filename.endsWith(".md")) {
        filename += ".md";
      }
      const path = obsidian.normalizePath(join(directory, filename));
      await ensureFolderExists(path);
      return path;
    }
    async function getTemplateInfo(template) {
      const { metadataCache, vault } = window.app;
      const templatePath = obsidian.normalizePath(template);
      if (templatePath === "/") {
        return Promise.resolve(["", null]);
      }
      try {
        const templateFile = metadataCache.getFirstLinkpathDest(templatePath, "");
        const contents = await vault.cachedRead(templateFile);
        const IFoldInfo = window.app.foldManager.load(templateFile);
        return [contents, IFoldInfo];
      } catch (err) {
        console.error(`Failed to read the daily note template '${templatePath}'`, err);
        new obsidian.Notice("Failed to read the daily note template");
        return ["", null];
      }
    }
    function getDateUID(date, granularity = "day") {
      const ts = date.clone().startOf(granularity).format();
      return `${granularity}-${ts}`;
    }
    function removeEscapedCharacters(format) {
      return format.replace(/\[[^\]]*\]/g, "");
    }
    function isFormatAmbiguous(format, granularity) {
      if (granularity === "week") {
        const cleanFormat = removeEscapedCharacters(format);
        return /w{1,2}/i.test(cleanFormat) && (/M{1,4}/.test(cleanFormat) || /D{1,4}/.test(cleanFormat));
      }
      return false;
    }
    function getDateFromFile(file, granularity) {
      return getDateFromFilename(file.basename, granularity);
    }
    function getDateFromPath(path, granularity) {
      return getDateFromFilename(basename(path), granularity);
    }
    function getDateFromFilename(filename, granularity) {
      const getSettings = {
        day: getDailyNoteSettings,
        week: getWeeklyNoteSettings,
        month: getMonthlyNoteSettings,
        quarter: getQuarterlyNoteSettings,
        year: getYearlyNoteSettings
      };
      const format = getSettings[granularity]().format.split("/").pop();
      const noteDate = window.moment(filename, format, true);
      if (!noteDate.isValid()) {
        return null;
      }
      if (isFormatAmbiguous(format, granularity)) {
        if (granularity === "week") {
          const cleanFormat = removeEscapedCharacters(format);
          if (/w{1,2}/i.test(cleanFormat)) {
            return window.moment(
              filename,
              // If format contains week, remove day & month formatting
              format.replace(/M{1,4}/g, "").replace(/D{1,4}/g, ""),
              false
            );
          }
        }
      }
      return noteDate;
    }
    var DailyNotesFolderMissingError = class extends Error {
    };
    async function createDailyNote2(date) {
      const app = window.app;
      const { vault } = app;
      const moment3 = window.moment;
      const { template, format, folder } = getDailyNoteSettings();
      const [templateContents, IFoldInfo] = await getTemplateInfo(template);
      const filename = date.format(format);
      const normalizedPath = await getNotePath(folder, filename);
      try {
        const createdFile = await vault.create(normalizedPath, templateContents.replace(/{{\s*date\s*}}/gi, filename).replace(/{{\s*time\s*}}/gi, moment3().format("HH:mm")).replace(/{{\s*title\s*}}/gi, filename).replace(/{{\s*(date|time)\s*(([+-]\d+)([yqmwdhs]))?\s*(:.+?)?}}/gi, (_, _timeOrDate, calc, timeDelta, unit, momentFormat) => {
          const now = moment3();
          const currentDate = date.clone().set({
            hour: now.get("hour"),
            minute: now.get("minute"),
            second: now.get("second")
          });
          if (calc) {
            currentDate.add(parseInt(timeDelta, 10), unit);
          }
          if (momentFormat) {
            return currentDate.format(momentFormat.substring(1).trim());
          }
          return currentDate.format(format);
        }).replace(/{{\s*yesterday\s*}}/gi, date.clone().subtract(1, "day").format(format)).replace(/{{\s*tomorrow\s*}}/gi, date.clone().add(1, "d").format(format)));
        app.foldManager.save(createdFile, IFoldInfo);
        return createdFile;
      } catch (err) {
        console.error(`Failed to create file: '${normalizedPath}'`, err);
        new obsidian.Notice("Unable to create new file.");
      }
    }
    function getDailyNote3(date, dailyNotes) {
      var _a;
      return (_a = dailyNotes[getDateUID(date, "day")]) != null ? _a : null;
    }
    function getAllDailyNotes3() {
      const { vault } = window.app;
      const { folder } = getDailyNoteSettings();
      const dailyNotesFolder = vault.getAbstractFileByPath(obsidian.normalizePath(folder));
      if (!dailyNotesFolder) {
        throw new DailyNotesFolderMissingError("Failed to find daily notes folder");
      }
      const dailyNotes = {};
      obsidian.Vault.recurseChildren(dailyNotesFolder, (note) => {
        if (note instanceof obsidian.TFile) {
          const date = getDateFromFile(note, "day");
          if (date) {
            const dateString = getDateUID(date, "day");
            dailyNotes[dateString] = note;
          }
        }
      });
      return dailyNotes;
    }
    var WeeklyNotesFolderMissingError = class extends Error {
    };
    function getDaysOfWeek() {
      const { moment: moment3 } = window;
      let weekStart = moment3.localeData()._week.dow;
      const daysOfWeek = [
        "sunday",
        "monday",
        "tuesday",
        "wednesday",
        "thursday",
        "friday",
        "saturday"
      ];
      while (weekStart) {
        daysOfWeek.push(daysOfWeek.shift());
        weekStart--;
      }
      return daysOfWeek;
    }
    function getDayOfWeekNumericalValue(dayOfWeekName) {
      return getDaysOfWeek().indexOf(dayOfWeekName.toLowerCase());
    }
    async function createWeeklyNote(date) {
      const { vault } = window.app;
      const { template, format, folder } = getWeeklyNoteSettings();
      const [templateContents, IFoldInfo] = await getTemplateInfo(template);
      const filename = date.format(format);
      const normalizedPath = await getNotePath(folder, filename);
      try {
        const createdFile = await vault.create(normalizedPath, templateContents.replace(/{{\s*(date|time)\s*(([+-]\d+)([yqmwdhs]))?\s*(:.+?)?}}/gi, (_, _timeOrDate, calc, timeDelta, unit, momentFormat) => {
          const now = window.moment();
          const currentDate = date.clone().set({
            hour: now.get("hour"),
            minute: now.get("minute"),
            second: now.get("second")
          });
          if (calc) {
            currentDate.add(parseInt(timeDelta, 10), unit);
          }
          if (momentFormat) {
            return currentDate.format(momentFormat.substring(1).trim());
          }
          return currentDate.format(format);
        }).replace(/{{\s*title\s*}}/gi, filename).replace(/{{\s*time\s*}}/gi, window.moment().format("HH:mm")).replace(/{{\s*(sunday|monday|tuesday|wednesday|thursday|friday|saturday)\s*:(.*?)}}/gi, (_, dayOfWeek, momentFormat) => {
          const day = getDayOfWeekNumericalValue(dayOfWeek);
          return date.weekday(day).format(momentFormat.trim());
        }));
        window.app.foldManager.save(createdFile, IFoldInfo);
        return createdFile;
      } catch (err) {
        console.error(`Failed to create file: '${normalizedPath}'`, err);
        new obsidian.Notice("Unable to create new file.");
      }
    }
    function getWeeklyNote(date, weeklyNotes) {
      var _a;
      return (_a = weeklyNotes[getDateUID(date, "week")]) != null ? _a : null;
    }
    function getAllWeeklyNotes() {
      const weeklyNotes = {};
      if (!appHasWeeklyNotesPluginLoaded()) {
        return weeklyNotes;
      }
      const { vault } = window.app;
      const { folder } = getWeeklyNoteSettings();
      const weeklyNotesFolder = vault.getAbstractFileByPath(obsidian.normalizePath(folder));
      if (!weeklyNotesFolder) {
        throw new WeeklyNotesFolderMissingError("Failed to find weekly notes folder");
      }
      obsidian.Vault.recurseChildren(weeklyNotesFolder, (note) => {
        if (note instanceof obsidian.TFile) {
          const date = getDateFromFile(note, "week");
          if (date) {
            const dateString = getDateUID(date, "week");
            weeklyNotes[dateString] = note;
          }
        }
      });
      return weeklyNotes;
    }
    var MonthlyNotesFolderMissingError = class extends Error {
    };
    async function createMonthlyNote(date) {
      const { vault } = window.app;
      const { template, format, folder } = getMonthlyNoteSettings();
      const [templateContents, IFoldInfo] = await getTemplateInfo(template);
      const filename = date.format(format);
      const normalizedPath = await getNotePath(folder, filename);
      try {
        const createdFile = await vault.create(normalizedPath, templateContents.replace(/{{\s*(date|time)\s*(([+-]\d+)([yqmwdhs]))?\s*(:.+?)?}}/gi, (_, _timeOrDate, calc, timeDelta, unit, momentFormat) => {
          const now = window.moment();
          const currentDate = date.clone().set({
            hour: now.get("hour"),
            minute: now.get("minute"),
            second: now.get("second")
          });
          if (calc) {
            currentDate.add(parseInt(timeDelta, 10), unit);
          }
          if (momentFormat) {
            return currentDate.format(momentFormat.substring(1).trim());
          }
          return currentDate.format(format);
        }).replace(/{{\s*date\s*}}/gi, filename).replace(/{{\s*time\s*}}/gi, window.moment().format("HH:mm")).replace(/{{\s*title\s*}}/gi, filename));
        window.app.foldManager.save(createdFile, IFoldInfo);
        return createdFile;
      } catch (err) {
        console.error(`Failed to create file: '${normalizedPath}'`, err);
        new obsidian.Notice("Unable to create new file.");
      }
    }
    function getMonthlyNote(date, monthlyNotes) {
      var _a;
      return (_a = monthlyNotes[getDateUID(date, "month")]) != null ? _a : null;
    }
    function getAllMonthlyNotes() {
      const monthlyNotes = {};
      if (!appHasMonthlyNotesPluginLoaded()) {
        return monthlyNotes;
      }
      const { vault } = window.app;
      const { folder } = getMonthlyNoteSettings();
      const monthlyNotesFolder = vault.getAbstractFileByPath(obsidian.normalizePath(folder));
      if (!monthlyNotesFolder) {
        throw new MonthlyNotesFolderMissingError("Failed to find monthly notes folder");
      }
      obsidian.Vault.recurseChildren(monthlyNotesFolder, (note) => {
        if (note instanceof obsidian.TFile) {
          const date = getDateFromFile(note, "month");
          if (date) {
            const dateString = getDateUID(date, "month");
            monthlyNotes[dateString] = note;
          }
        }
      });
      return monthlyNotes;
    }
    var QuarterlyNotesFolderMissingError = class extends Error {
    };
    async function createQuarterlyNote(date) {
      const { vault } = window.app;
      const { template, format, folder } = getQuarterlyNoteSettings();
      const [templateContents, IFoldInfo] = await getTemplateInfo(template);
      const filename = date.format(format);
      const normalizedPath = await getNotePath(folder, filename);
      try {
        const createdFile = await vault.create(normalizedPath, templateContents.replace(/{{\s*(date|time)\s*(([+-]\d+)([yqmwdhs]))?\s*(:.+?)?}}/gi, (_, _timeOrDate, calc, timeDelta, unit, momentFormat) => {
          const now = window.moment();
          const currentDate = date.clone().set({
            hour: now.get("hour"),
            minute: now.get("minute"),
            second: now.get("second")
          });
          if (calc) {
            currentDate.add(parseInt(timeDelta, 10), unit);
          }
          if (momentFormat) {
            return currentDate.format(momentFormat.substring(1).trim());
          }
          return currentDate.format(format);
        }).replace(/{{\s*date\s*}}/gi, filename).replace(/{{\s*time\s*}}/gi, window.moment().format("HH:mm")).replace(/{{\s*title\s*}}/gi, filename));
        window.app.foldManager.save(createdFile, IFoldInfo);
        return createdFile;
      } catch (err) {
        console.error(`Failed to create file: '${normalizedPath}'`, err);
        new obsidian.Notice("Unable to create new file.");
      }
    }
    function getQuarterlyNote(date, quarterly) {
      var _a;
      return (_a = quarterly[getDateUID(date, "quarter")]) != null ? _a : null;
    }
    function getAllQuarterlyNotes() {
      const quarterly = {};
      if (!appHasQuarterlyNotesPluginLoaded()) {
        return quarterly;
      }
      const { vault } = window.app;
      const { folder } = getQuarterlyNoteSettings();
      const quarterlyFolder = vault.getAbstractFileByPath(obsidian.normalizePath(folder));
      if (!quarterlyFolder) {
        throw new QuarterlyNotesFolderMissingError("Failed to find quarterly notes folder");
      }
      obsidian.Vault.recurseChildren(quarterlyFolder, (note) => {
        if (note instanceof obsidian.TFile) {
          const date = getDateFromFile(note, "quarter");
          if (date) {
            const dateString = getDateUID(date, "quarter");
            quarterly[dateString] = note;
          }
        }
      });
      return quarterly;
    }
    var YearlyNotesFolderMissingError = class extends Error {
    };
    async function createYearlyNote(date) {
      const { vault } = window.app;
      const { template, format, folder } = getYearlyNoteSettings();
      const [templateContents, IFoldInfo] = await getTemplateInfo(template);
      const filename = date.format(format);
      const normalizedPath = await getNotePath(folder, filename);
      try {
        const createdFile = await vault.create(normalizedPath, templateContents.replace(/{{\s*(date|time)\s*(([+-]\d+)([yqmwdhs]))?\s*(:.+?)?}}/gi, (_, _timeOrDate, calc, timeDelta, unit, momentFormat) => {
          const now = window.moment();
          const currentDate = date.clone().set({
            hour: now.get("hour"),
            minute: now.get("minute"),
            second: now.get("second")
          });
          if (calc) {
            currentDate.add(parseInt(timeDelta, 10), unit);
          }
          if (momentFormat) {
            return currentDate.format(momentFormat.substring(1).trim());
          }
          return currentDate.format(format);
        }).replace(/{{\s*date\s*}}/gi, filename).replace(/{{\s*time\s*}}/gi, window.moment().format("HH:mm")).replace(/{{\s*title\s*}}/gi, filename));
        window.app.foldManager.save(createdFile, IFoldInfo);
        return createdFile;
      } catch (err) {
        console.error(`Failed to create file: '${normalizedPath}'`, err);
        new obsidian.Notice("Unable to create new file.");
      }
    }
    function getYearlyNote(date, yearlyNotes) {
      var _a;
      return (_a = yearlyNotes[getDateUID(date, "year")]) != null ? _a : null;
    }
    function getAllYearlyNotes() {
      const yearlyNotes = {};
      if (!appHasYearlyNotesPluginLoaded()) {
        return yearlyNotes;
      }
      const { vault } = window.app;
      const { folder } = getYearlyNoteSettings();
      const yearlyNotesFolder = vault.getAbstractFileByPath(obsidian.normalizePath(folder));
      if (!yearlyNotesFolder) {
        throw new YearlyNotesFolderMissingError("Failed to find yearly notes folder");
      }
      obsidian.Vault.recurseChildren(yearlyNotesFolder, (note) => {
        if (note instanceof obsidian.TFile) {
          const date = getDateFromFile(note, "year");
          if (date) {
            const dateString = getDateUID(date, "year");
            yearlyNotes[dateString] = note;
          }
        }
      });
      return yearlyNotes;
    }
    function appHasDailyNotesPluginLoaded() {
      var _a, _b;
      const { app } = window;
      const dailyNotesPlugin = app.internalPlugins.plugins["daily-notes"];
      if (dailyNotesPlugin && dailyNotesPlugin.enabled) {
        return true;
      }
      const periodicNotes = app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.daily) == null ? void 0 : _b.enabled);
    }
    function appHasWeeklyNotesPluginLoaded() {
      var _a, _b;
      const { app } = window;
      if (app.plugins.getPlugin("calendar")) {
        return true;
      }
      const periodicNotes = app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.weekly) == null ? void 0 : _b.enabled);
    }
    function appHasMonthlyNotesPluginLoaded() {
      var _a, _b;
      const { app } = window;
      const periodicNotes = app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.monthly) == null ? void 0 : _b.enabled);
    }
    function appHasQuarterlyNotesPluginLoaded() {
      var _a, _b;
      const { app } = window;
      const periodicNotes = app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.quarterly) == null ? void 0 : _b.enabled);
    }
    function appHasYearlyNotesPluginLoaded() {
      var _a, _b;
      const { app } = window;
      const periodicNotes = app.plugins.getPlugin("periodic-notes");
      return periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.yearly) == null ? void 0 : _b.enabled);
    }
    function getPeriodicNoteSettings(granularity) {
      const getSettings = {
        day: getDailyNoteSettings,
        week: getWeeklyNoteSettings,
        month: getMonthlyNoteSettings,
        quarter: getQuarterlyNoteSettings,
        year: getYearlyNoteSettings
      }[granularity];
      return getSettings();
    }
    function createPeriodicNote(granularity, date) {
      const createFn = {
        day: createDailyNote2,
        month: createMonthlyNote,
        week: createWeeklyNote
      };
      return createFn[granularity](date);
    }
    exports.DEFAULT_DAILY_NOTE_FORMAT = DEFAULT_DAILY_NOTE_FORMAT;
    exports.DEFAULT_MONTHLY_NOTE_FORMAT = DEFAULT_MONTHLY_NOTE_FORMAT;
    exports.DEFAULT_QUARTERLY_NOTE_FORMAT = DEFAULT_QUARTERLY_NOTE_FORMAT;
    exports.DEFAULT_WEEKLY_NOTE_FORMAT = DEFAULT_WEEKLY_NOTE_FORMAT;
    exports.DEFAULT_YEARLY_NOTE_FORMAT = DEFAULT_YEARLY_NOTE_FORMAT;
    exports.appHasDailyNotesPluginLoaded = appHasDailyNotesPluginLoaded;
    exports.appHasMonthlyNotesPluginLoaded = appHasMonthlyNotesPluginLoaded;
    exports.appHasQuarterlyNotesPluginLoaded = appHasQuarterlyNotesPluginLoaded;
    exports.appHasWeeklyNotesPluginLoaded = appHasWeeklyNotesPluginLoaded;
    exports.appHasYearlyNotesPluginLoaded = appHasYearlyNotesPluginLoaded;
    exports.createDailyNote = createDailyNote2;
    exports.createMonthlyNote = createMonthlyNote;
    exports.createPeriodicNote = createPeriodicNote;
    exports.createQuarterlyNote = createQuarterlyNote;
    exports.createWeeklyNote = createWeeklyNote;
    exports.createYearlyNote = createYearlyNote;
    exports.getAllDailyNotes = getAllDailyNotes3;
    exports.getAllMonthlyNotes = getAllMonthlyNotes;
    exports.getAllQuarterlyNotes = getAllQuarterlyNotes;
    exports.getAllWeeklyNotes = getAllWeeklyNotes;
    exports.getAllYearlyNotes = getAllYearlyNotes;
    exports.getDailyNote = getDailyNote3;
    exports.getDailyNoteSettings = getDailyNoteSettings;
    exports.getDateFromFile = getDateFromFile;
    exports.getDateFromPath = getDateFromPath;
    exports.getDateUID = getDateUID;
    exports.getMonthlyNote = getMonthlyNote;
    exports.getMonthlyNoteSettings = getMonthlyNoteSettings;
    exports.getPeriodicNoteSettings = getPeriodicNoteSettings;
    exports.getQuarterlyNote = getQuarterlyNote;
    exports.getQuarterlyNoteSettings = getQuarterlyNoteSettings;
    exports.getTemplateInfo = getTemplateInfo;
    exports.getWeeklyNote = getWeeklyNote;
    exports.getWeeklyNoteSettings = getWeeklyNoteSettings;
    exports.getYearlyNote = getYearlyNote;
    exports.getYearlyNoteSettings = getYearlyNoteSettings;
  }
});

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => DailyNoteNavbarPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian4 = require("obsidian");

// src/settings.ts
var import_obsidian2 = require("obsidian");

// src/types.ts
var FIRST_DAY_OF_WEEK = ["Monday", "Sunday"];
var FILE_OPEN_TYPES = ["Active", "New tab", "New window", "Split right", "Split down"];

// src/utils.ts
var import_obsidian = require("obsidian");
var import_obsidian_daily_notes_interface = __toESM(require_main());
function getDatesInWeekByDate(date, firstDayOfWeek) {
  let startOfWeek = date.clone().startOf("isoWeek");
  if (firstDayOfWeek === "Sunday" && date.weekday() === 6) {
    startOfWeek = date.clone();
  } else if (firstDayOfWeek === "Sunday") {
    startOfWeek.subtract(1, "day");
  }
  const daysInWeek = [];
  for (let i = 0; i < 7; i++) {
    daysInWeek.push(startOfWeek.clone().add(i, "days"));
  }
  return daysInWeek;
}
function getDateFromFileName(basename, dateFormat) {
  return (0, import_obsidian.moment)(basename, dateFormat, true);
}
function hideChildren(el) {
  for (let k = 0; k < el.children.length; k++) {
    el.children[k].addClass("daily-note-navbar__hidden");
  }
}
function showChildren(el) {
  for (let k = 0; k < el.children.length; k++) {
    el.children[k].removeClass("daily-note-navbar__hidden");
  }
}
function toRecord(arr) {
  const recordObject = {};
  arr.forEach((item) => recordObject[item] = item);
  return recordObject;
}
async function getDailyNoteFile(date) {
  var _a;
  return (_a = (0, import_obsidian_daily_notes_interface.getDailyNote)(date, (0, import_obsidian_daily_notes_interface.getAllDailyNotes)())) != null ? _a : await (0, import_obsidian_daily_notes_interface.createDailyNote)(date);
}
function selectNavbarFromView(view) {
  const navbars = view.containerEl.getElementsByClassName("daily-note-navbar");
  if (navbars.length > 0) {
    const navbarEl = navbars[0];
    return navbarEl.getAttribute("daily-note-navbar-id");
  }
  return null;
}

// src/settings.ts
var DEFAULT_SETTINGS = {
  dateFormat: "ddd",
  tooltipDateFormat: "YYYY-MM-DD",
  dailyNoteDateFormat: "YYYY-MM-DD",
  firstDayOfWeek: "Monday",
  defaultOpenType: "Active",
  setActive: true
};
var DailyNoteNavbarSettingTab = class extends import_obsidian2.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    new import_obsidian2.Setting(containerEl).setName("Daily note date format").setDesc("Date format for daily notes.").addText((text) => text.setPlaceholder(DEFAULT_SETTINGS.dailyNoteDateFormat).setValue(this.plugin.settings.dailyNoteDateFormat).onChange(async (value) => {
      if (value.trim() === "") {
        value = DEFAULT_SETTINGS.dailyNoteDateFormat;
      }
      this.plugin.settings.dailyNoteDateFormat = value;
      await this.plugin.saveSettings();
      this.plugin.addDailyNoteNavbar();
    }));
    new import_obsidian2.Setting(containerEl).setName("Date format").setDesc("Date format for the daily note bar.").addText((text) => text.setPlaceholder(DEFAULT_SETTINGS.dateFormat).setValue(this.plugin.settings.dateFormat).onChange(async (value) => {
      if (value.trim() === "") {
        value = DEFAULT_SETTINGS.dateFormat;
      }
      this.plugin.settings.dateFormat = value;
      await this.plugin.saveSettings();
      this.plugin.addDailyNoteNavbar();
    }));
    new import_obsidian2.Setting(containerEl).setName("Tooltip date format").setDesc("Date format for tooltips.").addText((text) => text.setPlaceholder(DEFAULT_SETTINGS.tooltipDateFormat).setValue(this.plugin.settings.tooltipDateFormat).onChange(async (value) => {
      if (value.trim() === "") {
        value = DEFAULT_SETTINGS.tooltipDateFormat;
      }
      this.plugin.settings.tooltipDateFormat = value;
      await this.plugin.saveSettings();
      this.plugin.addDailyNoteNavbar();
    }));
    new import_obsidian2.Setting(containerEl).setName("First day of week").setDesc("The first day in the daily note bar.").addDropdown((dropdown) => dropdown.addOptions(toRecord(FIRST_DAY_OF_WEEK.map((item) => item))).setValue(this.plugin.settings.firstDayOfWeek).onChange(async (value) => {
      this.plugin.settings.firstDayOfWeek = value;
      await this.plugin.saveSettings();
      this.plugin.addDailyNoteNavbar();
    }));
    new import_obsidian2.Setting(containerEl).setName("Open files as active").setDesc("Make files active when they are opened.").addToggle((toggle) => toggle.setValue(this.plugin.settings.setActive).onChange(async (value) => {
      this.plugin.settings.setActive = value;
      this.plugin.saveSettings();
    }));
    new import_obsidian2.Setting(containerEl).setName("Open in").setDesc("Where to open files.").addDropdown((dropdown) => dropdown.addOptions(toRecord(FILE_OPEN_TYPES.map((item) => item))).setValue(this.plugin.settings.defaultOpenType).onChange(async (value) => {
      this.plugin.settings.defaultOpenType = value;
      await this.plugin.saveSettings();
      this.plugin.addDailyNoteNavbar();
    }));
  }
};

// src/dailyNoteNavbar/dailyNoteNavbar.ts
var import_obsidian3 = require("obsidian");
var import_obsidian_daily_notes_interface2 = __toESM(require_main());

// src/dailyNoteNavbar/consts.ts
var FILE_OPEN_TYPES_TO_PANE_TYPE = {
  "window": "New window",
  "tab": "New tab",
  "split": "Split right"
};
var FILE_OPEN_TYPES_MAPPING = {
  "New tab": {
    icon: "file-plus",
    title: "Open in new tab"
  },
  "Split right": {
    icon: "separator-vertical",
    title: "Split right"
  },
  "Split down": {
    icon: "separator-vertical",
    title: "Split down"
  },
  "New window": {
    icon: "picture-in-picture-2",
    title: "Open in new window"
  }
};

// src/dailyNoteNavbar/dailyNoteNavbar.ts
var DailyNoteNavbar = class {
  constructor(plugin, id, view, parentEl, date) {
    this.weekOffset = 0;
    this.id = id;
    this.date = date;
    this.weekOffset = 0;
    this.plugin = plugin;
    this.view = view;
    this.containerEl = createDiv();
    this.containerEl.addClass("daily-note-navbar");
    this.containerEl.setAttribute("daily-note-navbar-id", this.id);
    this.parentEl = parentEl;
    this.parentEl.appendChild(this.containerEl);
    this.view.onunload = () => this.plugin.removeNavbar(this.id);
    this.rerender();
  }
  rerender() {
    const activeFile = this.view.file;
    const fileDate = activeFile ? getDateFromFileName(activeFile.basename, this.plugin.settings.dailyNoteDateFormat) : null;
    if (fileDate && fileDate.format("YYYY-MM-DD") !== this.date.format("YYYY-MM-DD")) {
      this.date = fileDate;
      this.weekOffset = 0;
    }
    this.containerEl.replaceChildren();
    const currentDate = (0, import_obsidian3.moment)();
    const dates = getDatesInWeekByDate(this.date.clone().add(this.weekOffset, "week"), this.plugin.settings.firstDayOfWeek);
    new import_obsidian3.ButtonComponent(this.containerEl).setClass("daily-note-navbar__change-week").setIcon("left-arrow").setTooltip("Previous week").onClick(() => {
      this.weekOffset--;
      this.rerender();
    });
    for (const date of dates) {
      const dateString = date.format("YYYY-MM-DD");
      const isActive = this.date.format("YYYY-MM-DD") === dateString;
      const isCurrent = currentDate.format("YYYY-MM-DD") === dateString;
      const exists = (0, import_obsidian_daily_notes_interface2.getDailyNote)(date, (0, import_obsidian_daily_notes_interface2.getAllDailyNotes)());
      const stateClass = isActive ? "daily-note-navbar__active" : exists ? "daily-note-navbar__default" : "daily-note-navbar__not-exists";
      const button = new import_obsidian3.ButtonComponent(this.containerEl).setClass("daily-note-navbar__date").setClass(stateClass).setButtonText(`${date.format(this.plugin.settings.dateFormat)} ${date.date()}`).setTooltip(`${date.format(this.plugin.settings.tooltipDateFormat)}`);
      if (isCurrent) {
        button.setClass("daily-note-navbar__current");
      }
      button.buttonEl.onClickEvent((event) => {
        const paneType = import_obsidian3.Keymap.isModEvent(event);
        if (paneType && paneType !== true) {
          const openType = FILE_OPEN_TYPES_TO_PANE_TYPE[paneType];
          this.plugin.openDailyNote(date, openType);
        } else if (event.type === "click") {
          const openType = event.ctrlKey ? "New tab" : this.plugin.settings.defaultOpenType;
          const isActive2 = this.date.format("YYYY-MM-DD") === date.format("YYYY-MM-DD");
          if (isActive2 && openType === "Active") {
            return;
          }
          this.plugin.openDailyNote(date, openType);
        } else if (event.type === "auxclick") {
          this.createContextMenu(event, date);
        }
      });
    }
    new import_obsidian3.ButtonComponent(this.containerEl).setClass("daily-note-navbar__change-week").setIcon("right-arrow").setTooltip("Next week").onClick(() => {
      this.weekOffset++;
      this.rerender();
    });
  }
  createContextMenu(event, date) {
    const menu = new import_obsidian3.Menu();
    for (const [openType, itemValues] of Object.entries(FILE_OPEN_TYPES_MAPPING)) {
      menu.addItem((item) => item.setIcon(itemValues.icon).setTitle(itemValues.title).onClick(async () => {
        this.plugin.openDailyNote(date, openType);
      }));
    }
    menu.addSeparator();
    menu.addItem((item) => item.setIcon("copy").setTitle("Copy Obsidian URL").onClick(async () => {
      const dailyNote = await getDailyNoteFile(date);
      const extensionLength = dailyNote.extension.length > 0 ? dailyNote.extension.length + 1 : 0;
      const fileName = encodeURIComponent(dailyNote.path.slice(0, -extensionLength));
      const vaultName = this.plugin.app.vault.getName();
      const url = `obsidian://open?vault=${vaultName}&file=${fileName}`;
      navigator.clipboard.writeText(url);
      new import_obsidian3.Notice("URL copied to your clipboard");
    }));
    menu.showAtMouseEvent(event);
  }
};

// src/main.ts
var DailyNoteNavbarPlugin = class extends import_obsidian4.Plugin {
  constructor() {
    super(...arguments);
    this.navbars = {};
    this.nextNavbarId = 0;
  }
  async onload() {
    await this.loadSettings();
    this.addSettingTab(new DailyNoteNavbarSettingTab(this.app, this));
    this.registerEvent(this.app.workspace.on("active-leaf-change", (leaf) => {
      this.addDailyNoteNavbar(leaf);
    }));
    this.registerEvent(this.app.workspace.on("css-change", () => this.rerenderNavbars()));
    this.registerEvent(this.app.vault.on("create", () => this.rerenderNavbars()));
    this.registerEvent(this.app.vault.on("rename", () => this.rerenderNavbars()));
    this.registerEvent(this.app.vault.on("delete", () => this.rerenderNavbars()));
  }
  async addDailyNoteNavbar(leaf) {
    if (!this.hasDependencies()) {
      return;
    }
    const markdownLeaves = this.app.workspace.getLeavesOfType("markdown");
    if (!markdownLeaves.includes(leaf)) {
      return;
    }
    const view = leaf.view;
    const activeFile = view.file;
    if (!activeFile) {
      return;
    }
    const viewHeaderTitleContainers = view.containerEl.getElementsByClassName("view-header-title-container");
    if (viewHeaderTitleContainers.length !== 1) {
      return;
    }
    const titleContainerEl = viewHeaderTitleContainers[0];
    const navbarId = selectNavbarFromView(view);
    const navbar = navbarId ? this.getNavbar(navbarId) : null;
    const fileDate = getDateFromFileName(activeFile.basename, this.settings.dailyNoteDateFormat);
    if (!fileDate.isValid()) {
      if (navbar) {
        this.removeNavbar(navbar.id);
        showChildren(titleContainerEl);
      }
      return;
    }
    if (navbar) {
      navbar.rerender();
    } else {
      hideChildren(titleContainerEl);
      this.createNavbar(view, titleContainerEl, fileDate);
    }
  }
  createNavbar(view, parentEl, date) {
    const navbarId = `${this.nextNavbarId++}`;
    const navbar = new DailyNoteNavbar(this, navbarId, view, parentEl, date);
    this.navbars[navbarId] = navbar;
    return navbar;
  }
  removeNavbar(id) {
    const navbar = this.navbars[id];
    navbar.parentEl.removeChild(navbar.containerEl);
    delete this.navbars[id];
  }
  getNavbar(id) {
    return this.navbars[id];
  }
  rerenderNavbars() {
    for (const navbar of Object.values(this.navbars)) {
      navbar.rerender();
    }
  }
  async openDailyNote(date, openType) {
    const dailyNote = await getDailyNoteFile(date);
    this.openFile(dailyNote, openType);
  }
  async openFile(file, openType) {
    switch (openType) {
      case "New window":
        await this.app.workspace.getLeaf("window").openFile(file, { active: this.settings.setActive });
        return;
      case "New tab":
        await this.app.workspace.getLeaf("tab").openFile(file, { active: this.settings.setActive });
        return;
      case "Split right":
        await this.app.workspace.getLeaf("split", "vertical").openFile(file, { active: this.settings.setActive });
        return;
      case "Split down":
        await this.app.workspace.getLeaf("split", "horizontal").openFile(file, { active: this.settings.setActive });
        return;
      case "Active":
        await this.app.workspace.getLeaf().openFile(file, { active: true });
        break;
    }
  }
  hasDependencies() {
    var _a, _b;
    const dailyNotesPlugin = this.app.internalPlugins.plugins["daily-notes"];
    const periodicNotes = this.app.plugins.getPlugin("periodic-notes");
    if (!dailyNotesPlugin && !periodicNotes) {
      new import_obsidian4.Notice("Daily Note Navbar: Install Periodic Notes or Daily Notes");
      return false;
    }
    if (dailyNotesPlugin && dailyNotesPlugin.enabled) {
      return true;
    } else if (periodicNotes && ((_b = (_a = periodicNotes.settings) == null ? void 0 : _a.daily) == null ? void 0 : _b.enabled)) {
      return true;
    }
    new import_obsidian4.Notice("Daily Note Navbar: Enable Periodic Notes or Daily Notes");
    return false;
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};


/* nosourcemap */